
module ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   0,   9,   0,   3]
  K1( 2,:) = [   9,   0,   3,   0]
  K1( 3,:) = [   0,   3,   0,   9]
  K1( 4,:) = [   3,   0,   9,   0]
  K1( 5,:) = [  12,   0,   4,   0]
  K1( 6,:) = [   0,   0,   0,   0]
  K1( 7,:) = [   4,   0,  12,   0]
  K1( 8,:) = [   0,   0,   0,   0]
  K1( 9,:) = [   0,   0,   4,   0]
  K1(10,:) = [   0,   0,   0,   0]
  K1(11,:) = [   4,   0,   0,   0]
  K1(12,:) = [   0,   0,   0,   0]
  K1(13,:) = [  12,   0,   4,   0]
  K1(14,:) = [   0,   0,   0,   0]
  K1(15,:) = [   4,   0,  12,   0]
  K1(16,:) = [   0,   0,   0,   0]
  K1(17,:) = [   0,   0,  -4,   0]
  K1(18,:) = [   0,   0,   0,   0]
  K1(19,:) = [  -4,   0, -12,   0]
  K1(20,:) = [   0,   0,   0,   0]
  K1(21,:) = [ -12,   0,  -4,   0]
  K1(22,:) = [   0,   0,   0,   0]
  K1(23,:) = [  -4,   0,   0,   0]
  K1(24,:) = [   0,   0,   0,   0]
  K1(25,:) = [  12,   0,   4,   0]
  K1(26,:) = [   0,   0,   0,   0]
  K1(27,:) = [   4,   0,  12,   0]
  K1(28,:) = [   0,   0,   0,   0]
  K1(29,:) = [ -12,   0,  -4,   0]
  K1(30,:) = [   0,   0,   0,   0]
  K1(31,:) = [  -4,   0,   0,   0]
  K1(32,:) = [   0,   0,   0,   0]
  K1(33,:) = [   0,   0,  -4,   0]
  K1(34,:) = [   0,   0,   0,   0]
  K1(35,:) = [  -4,   0, -12,   0]
  K1(36,:) = [   0,   0,   0,   0]
  K1(37,:) = [   0,   0,   4,   0]
  K1(38,:) = [   0,   0,   0,   0]
  K1(39,:) = [   4,   0,   0,   0]
  K1(40,:) = [   0,   0,   0,   0]
  K1(41,:) = [  12,   0,   4,   0]
  K1(42,:) = [   0,   0,   0,   0]
  K1(43,:) = [   4,   0,  12,   0]
  K1(44,:) = [   0,   0,   0,   0]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [   0,   0,   0,   0]
  K1(66,:) = [   0,   0,   0,   0]
  K1(67,:) = [   0,   0,   0,   0]
  K1(68,:) = [   0,   0,   0,   0]
  K1(69,:) = [   0,   0,   0,   0]
  K1(70,:) = [   0,   0,   0,   0]
  K1(71,:) = [   0,   0,   0,   0]
  K1(72,:) = [   0,   0,   0,   0]
  K1(73,:) = [   0,   0,   0,   0]
  K1(74,:) = [   0,   0,   0,   0]
  K1(75,:) = [   0,   0,   0,   0]
  K1(76,:) = [   0,   0,   0,   0]
  K1(77,:) = [   0,   0,   0,   0]
  K1(78,:) = [   0,   0,   0,   0]
  K1(79,:) = [   0,   0,   0,   0]
  K1(80,:) = [   0,   0,   0,   0]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [   0,   0,   0,   0]
  K1(86,:) = [   0,   0,   0,   0]
  K1(87,:) = [   0,   0,   0,   0]
  K1(88,:) = [   0,   0,   0,   0]
  K1(89,:) = [   0,   9,   0,   3]
  K1(90,:) = [   9,   0,   3,   0]
  K1(91,:) = [   0,   3,   0,   9]
  K1(92,:) = [   3,   0,   9,   0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND



module ol_forced_parameters_ppvvj_ew_bbbxbxzz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvj_ew_bbbxbxzz_1_/**/REALKIND

module ol_tree_ppvvj_ew_bbbxbxzz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(12)
  complex(REALKIND), save :: den(345)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 144 ! number of helicity configurations
  integer(intkind2), save :: nhel = 144 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(144) ! physical helicity states
  complex(DREALKIND) :: M1helarr(4,144) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**4)/9._/**/REALKIND
    f( 2) = CI*eQED**4
    f( 3) = CI*eQED**2*gQCD**2
    f( 4) = (CI*eQED**4*MB**2)/(4._/**/REALKIND*cw**4*sw**4)
    f( 5) = (CI*eQED**4*MB**2)/(8._/**/REALKIND*cw**2*MW**2*sw**4)
    f( 6) = (CI*eQED**4*MB**3)/(8._/**/REALKIND*cw**2*MW**2*sw**4)
    f( 7) = (3*CI*eQED**4*lambdaHHH*MB**2*MH**2)/(8._/**/REALKIND*cw**2*MW**2*sw**4)
    f( 8) = (CI*eQED**4*MB)/(18._/**/REALKIND*cw**2*sw**2)
    f( 9) = (CI*eQED**4*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(10) = (CI*eQED**2*gQCD**2*MB)/(2._/**/REALKIND*cw**2*sw**2)
    f(11) = (CI*eQED**4*MB**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(12) = (CI*eQED**4*MW**2)/(cw**4*sw**2)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none

  ! propagators

  den(1) = 1 /((L(5,5) - MH2)+L(6,5))
  den(2) = 1 /((L(5,10) - MH2)+L(6,10))
  den(4) = 1 /((L(5,9) - MH2)+L(6,9))
  den(5) = 1 /((L(5,6) - MH2)+L(6,6))
  den(7) = 1 /((L(5,48) - MH2)+L(6,48))
  den(9) = 1 /((L(5,5) - MZ2)+L(6,5))
  den(10) = 1 /((L(5,10) - MZ2)+L(6,10))
  den(13) = 1 /((L(5,21) - MZ2)+L(6,21))
  den(16) = 1 /((L(5,21) - MH2)+L(6,21))
  den(19) = 1 /((L(5,26) - MZ2)+L(6,26))
  den(22) = 1 /((L(5,26) - MH2)+L(6,26))
  den(25) = 1 /((L(5,18) - MB2)+L(6,18))
  den(26) = 1 /((L(5,40) - MB2)+L(6,40))
  den(29) = 1 /((L(5,5))+L(6,5))
  den(34) = 1 /((L(5,13) - MB2)+L(6,13))
  den(45) = 1 /((L(5,34) - MB2)+L(6,34))
  den(46) = 1 /((L(5,24) - MB2)+L(6,24))
  den(53) = 1 /((L(5,7) - MB2)+L(6,7))
  den(67) = 1 /((L(5,42) - MZ2)+L(6,42))
  den(70) = 1 /((L(5,42) - MH2)+L(6,42))
  den(83) = 1 /((L(5,50) - MB2)+L(6,50))
  den(89) = 1 /((L(5,9) - MZ2)+L(6,9))
  den(90) = 1 /((L(5,6) - MZ2)+L(6,6))
  den(93) = 1 /((L(5,25) - MZ2)+L(6,25))
  den(96) = 1 /((L(5,25) - MH2)+L(6,25))
  den(99) = 1 /((L(5,22) - MZ2)+L(6,22))
  den(102) = 1 /((L(5,22) - MH2)+L(6,22))
  den(105) = 1 /((L(5,17) - MB2)+L(6,17))
  den(108) = 1 /((L(5,6))+L(6,6))
  den(117) = 1 /((L(5,14) - MB2)+L(6,14))
  den(124) = 1 /((L(5,33) - MB2)+L(6,33))
  den(141) = 1 /((L(5,41) - MZ2)+L(6,41))
  den(144) = 1 /((L(5,41) - MH2)+L(6,41))
  den(160) = 1 /((L(5,49) - MB2)+L(6,49))
  den(165) = 1 /((L(5,36) - MB2)+L(6,36))
  den(168) = 1 /((L(5,9))+L(6,9))
  den(183) = 1 /((L(5,20) - MB2)+L(6,20))
  den(190) = 1 /((L(5,11) - MB2)+L(6,11))
  den(204) = 1 /((L(5,38) - MZ2)+L(6,38))
  den(207) = 1 /((L(5,38) - MH2)+L(6,38))
  den(225) = 1 /((L(5,10))+L(6,10))
  den(256) = 1 /((L(5,37) - MZ2)+L(6,37))
  den(259) = 1 /((L(5,37) - MH2)+L(6,37))
  den(279) = 1 /((L(5,21))+L(6,21))
  den(284) = 1 /((L(5,38))+L(6,38))
  den(293) = 1 /((L(5,42))+L(6,42))
  den(298) = 1 /((L(5,37))+L(6,37))
  den(303) = 1 /((L(5,22))+L(6,22))
  den(312) = 1 /((L(5,41))+L(6,41))
  den(331) = 1 /((L(5,26))+L(6,26))
  den(336) = 1 /((L(5,25))+L(6,25))

  ! denominators

  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(3)*den(7)
  den(11) = den(9)*den(10)
  den(12) = den(7)*den(11)
  den(14) = den(1)*den(13)
  den(15) = den(2)*den(14)
  den(17) = den(9)*den(16)
  den(18) = den(10)*den(17)
  den(20) = den(2)*den(19)
  den(21) = den(1)*den(20)
  den(23) = den(10)*den(22)
  den(24) = den(9)*den(23)
  den(27) = den(1)*den(25)
  den(28) = den(26)*den(27)
  den(30) = den(25)*den(29)
  den(31) = den(26)*den(30)
  den(32) = den(9)*den(25)
  den(33) = den(26)*den(32)
  den(35) = den(1)*den(34)
  den(36) = den(25)*den(35)
  den(37) = den(29)*den(34)
  den(38) = den(25)*den(37)
  den(39) = den(9)*den(34)
  den(40) = den(25)*den(39)
  den(41) = den(19)*den(25)
  den(42) = den(1)*den(41)
  den(43) = den(22)*den(25)
  den(44) = den(9)*den(43)
  den(47) = den(1)*den(45)
  den(48) = den(46)*den(47)
  den(49) = den(29)*den(45)
  den(50) = den(46)*den(49)
  den(51) = den(9)*den(45)
  den(52) = den(46)*den(51)
  den(54) = den(1)*den(53)
  den(55) = den(46)*den(54)
  den(56) = den(29)*den(53)
  den(57) = den(46)*den(56)
  den(58) = den(9)*den(53)
  den(59) = den(46)*den(58)
  den(60) = den(19)*den(46)
  den(61) = den(1)*den(60)
  den(62) = den(22)*den(46)
  den(63) = den(9)*den(62)
  den(64) = den(35)*den(45)
  den(65) = den(37)*den(45)
  den(66) = den(39)*den(45)
  den(68) = den(45)*den(67)
  den(69) = den(1)*den(68)
  den(71) = den(45)*den(70)
  den(72) = den(9)*den(71)
  den(73) = den(26)*den(54)
  den(74) = den(26)*den(56)
  den(75) = den(26)*den(58)
  den(76) = den(26)*den(67)
  den(77) = den(1)*den(76)
  den(78) = den(26)*den(70)
  den(79) = den(9)*den(78)
  den(80) = den(7)*den(54)
  den(81) = den(7)*den(56)
  den(82) = den(7)*den(58)
  den(84) = den(7)*den(83)
  den(85) = den(1)*den(84)
  den(86) = den(29)*den(84)
  den(87) = den(9)*den(84)
  den(88) = den(6)*den(7)
  den(91) = den(89)*den(90)
  den(92) = den(7)*den(91)
  den(94) = den(4)*den(93)
  den(95) = den(5)*den(94)
  den(97) = den(89)*den(96)
  den(98) = den(90)*den(97)
  den(100) = den(5)*den(99)
  den(101) = den(4)*den(100)
  den(103) = den(90)*den(102)
  den(104) = den(89)*den(103)
  den(106) = den(5)*den(105)
  den(107) = den(26)*den(106)
  den(109) = den(105)*den(108)
  den(110) = den(26)*den(109)
  den(111) = den(90)*den(105)
  den(112) = den(26)*den(111)
  den(113) = den(93)*den(105)
  den(114) = den(5)*den(113)
  den(115) = den(96)*den(105)
  den(116) = den(90)*den(115)
  den(118) = den(5)*den(117)
  den(119) = den(105)*den(118)
  den(120) = den(108)*den(117)
  den(121) = den(105)*den(120)
  den(122) = den(90)*den(117)
  den(123) = den(105)*den(122)
  den(125) = den(5)*den(124)
  den(126) = den(46)*den(125)
  den(127) = den(108)*den(124)
  den(128) = den(46)*den(127)
  den(129) = den(90)*den(124)
  den(130) = den(46)*den(129)
  den(131) = den(5)*den(53)
  den(132) = den(46)*den(131)
  den(133) = den(53)*den(108)
  den(134) = den(46)*den(133)
  den(135) = den(53)*den(90)
  den(136) = den(46)*den(135)
  den(137) = den(46)*den(96)
  den(138) = den(90)*den(137)
  den(139) = den(46)*den(93)
  den(140) = den(5)*den(139)
  den(142) = den(124)*den(141)
  den(143) = den(5)*den(142)
  den(145) = den(124)*den(144)
  den(146) = den(90)*den(145)
  den(147) = den(118)*den(124)
  den(148) = den(120)*den(124)
  den(149) = den(122)*den(124)
  den(150) = den(26)*den(131)
  den(151) = den(26)*den(133)
  den(152) = den(26)*den(135)
  den(153) = den(26)*den(144)
  den(154) = den(90)*den(153)
  den(155) = den(26)*den(141)
  den(156) = den(5)*den(155)
  den(157) = den(7)*den(131)
  den(158) = den(7)*den(133)
  den(159) = den(7)*den(135)
  den(161) = den(7)*den(160)
  den(162) = den(5)*den(161)
  den(163) = den(108)*den(161)
  den(164) = den(90)*den(161)
  den(166) = den(4)*den(25)
  den(167) = den(165)*den(166)
  den(169) = den(25)*den(168)
  den(170) = den(165)*den(169)
  den(171) = den(25)*den(89)
  den(172) = den(165)*den(171)
  den(173) = den(4)*den(34)
  den(174) = den(25)*den(173)
  den(175) = den(34)*den(168)
  den(176) = den(25)*den(175)
  den(177) = den(34)*den(89)
  den(178) = den(25)*den(177)
  den(179) = den(25)*den(99)
  den(180) = den(4)*den(179)
  den(181) = den(25)*den(102)
  den(182) = den(89)*den(181)
  den(184) = den(4)*den(45)
  den(185) = den(183)*den(184)
  den(186) = den(45)*den(168)
  den(187) = den(183)*den(186)
  den(188) = den(45)*den(89)
  den(189) = den(183)*den(188)
  den(191) = den(4)*den(190)
  den(192) = den(183)*den(191)
  den(193) = den(168)*den(190)
  den(194) = den(183)*den(193)
  den(195) = den(89)*den(190)
  den(196) = den(183)*den(195)
  den(197) = den(99)*den(183)
  den(198) = den(4)*den(197)
  den(199) = den(102)*den(183)
  den(200) = den(89)*den(199)
  den(201) = den(45)*den(173)
  den(202) = den(45)*den(175)
  den(203) = den(45)*den(177)
  den(205) = den(45)*den(204)
  den(206) = den(4)*den(205)
  den(208) = den(45)*den(207)
  den(209) = den(89)*den(208)
  den(210) = den(165)*den(191)
  den(211) = den(165)*den(193)
  den(212) = den(165)*den(195)
  den(213) = den(165)*den(204)
  den(214) = den(4)*den(213)
  den(215) = den(165)*den(207)
  den(216) = den(89)*den(215)
  den(217) = den(7)*den(191)
  den(218) = den(7)*den(193)
  den(219) = den(7)*den(195)
  den(220) = den(4)*den(84)
  den(221) = den(84)*den(168)
  den(222) = den(84)*den(89)
  den(223) = den(2)*den(105)
  den(224) = den(165)*den(223)
  den(226) = den(105)*den(225)
  den(227) = den(165)*den(226)
  den(228) = den(10)*den(105)
  den(229) = den(165)*den(228)
  den(230) = den(13)*den(105)
  den(231) = den(2)*den(230)
  den(232) = den(16)*den(105)
  den(233) = den(10)*den(232)
  den(234) = den(2)*den(117)
  den(235) = den(105)*den(234)
  den(236) = den(117)*den(225)
  den(237) = den(105)*den(236)
  den(238) = den(10)*den(117)
  den(239) = den(105)*den(238)
  den(240) = den(2)*den(124)
  den(241) = den(183)*den(240)
  den(242) = den(124)*den(225)
  den(243) = den(183)*den(242)
  den(244) = den(10)*den(124)
  den(245) = den(183)*den(244)
  den(246) = den(2)*den(190)
  den(247) = den(183)*den(246)
  den(248) = den(190)*den(225)
  den(249) = den(183)*den(248)
  den(250) = den(10)*den(190)
  den(251) = den(183)*den(250)
  den(252) = den(16)*den(183)
  den(253) = den(10)*den(252)
  den(254) = den(13)*den(183)
  den(255) = den(2)*den(254)
  den(257) = den(124)*den(256)
  den(258) = den(2)*den(257)
  den(260) = den(124)*den(259)
  den(261) = den(10)*den(260)
  den(262) = den(124)*den(234)
  den(263) = den(124)*den(236)
  den(264) = den(124)*den(238)
  den(265) = den(165)*den(246)
  den(266) = den(165)*den(248)
  den(267) = den(165)*den(250)
  den(268) = den(165)*den(259)
  den(269) = den(10)*den(268)
  den(270) = den(165)*den(256)
  den(271) = den(2)*den(270)
  den(272) = den(7)*den(246)
  den(273) = den(7)*den(248)
  den(274) = den(7)*den(250)
  den(275) = den(2)*den(161)
  den(276) = den(161)*den(225)
  den(277) = den(10)*den(161)
  den(278) = den(45)*den(232)
  den(280) = den(105)*den(279)
  den(281) = den(45)*den(280)
  den(282) = den(45)*den(230)
  den(283) = den(105)*den(208)
  den(285) = den(45)*den(284)
  den(286) = den(105)*den(285)
  den(287) = den(105)*den(205)
  den(288) = den(105)*den(215)
  den(289) = den(165)*den(284)
  den(290) = den(105)*den(289)
  den(291) = den(105)*den(213)
  den(292) = den(78)*den(105)
  den(294) = den(26)*den(293)
  den(295) = den(105)*den(294)
  den(296) = den(76)*den(105)
  den(297) = den(25)*den(260)
  den(299) = den(124)*den(298)
  den(300) = den(25)*den(299)
  den(301) = den(25)*den(257)
  den(302) = den(124)*den(181)
  den(304) = den(25)*den(303)
  den(305) = den(124)*den(304)
  den(306) = den(124)*den(179)
  den(307) = den(25)*den(268)
  den(308) = den(165)*den(298)
  den(309) = den(25)*den(308)
  den(310) = den(25)*den(270)
  den(311) = den(25)*den(153)
  den(313) = den(26)*den(312)
  den(314) = den(25)*den(313)
  den(315) = den(25)*den(155)
  den(316) = den(124)*den(199)
  den(317) = den(183)*den(303)
  den(318) = den(124)*den(317)
  den(319) = den(124)*den(197)
  den(320) = den(45)*den(252)
  den(321) = den(183)*den(279)
  den(322) = den(45)*den(321)
  den(323) = den(45)*den(254)
  den(324) = den(26)*den(252)
  den(325) = den(26)*den(321)
  den(326) = den(26)*den(254)
  den(327) = den(153)*den(183)
  den(328) = den(183)*den(313)
  den(329) = den(155)*den(183)
  den(330) = den(62)*den(124)
  den(332) = den(46)*den(331)
  den(333) = den(124)*den(332)
  den(334) = den(60)*den(124)
  den(335) = den(45)*den(137)
  den(337) = den(46)*den(336)
  den(338) = den(45)*den(337)
  den(339) = den(45)*den(139)
  den(340) = den(46)*den(268)
  den(341) = den(46)*den(308)
  den(342) = den(46)*den(270)
  den(343) = den(137)*den(165)
  den(344) = den(165)*den(337)
  den(345) = den(139)*den(165)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_ppvvj_ew_bbbxbxzz_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for bottom bottom anti-bottom anti-bottom Z Z -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: L
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_ppvvj_ew_bbbxbxzz_1, only: &
    & external_perm_ppvvj_ew_bbbxbxzz_1, &
    & external_perm_inv_ppvvj_ew_bbbxbxzz_1, &
    & extcomb_perm_ppvvj_ew_bbbxbxzz_1, &
    & average_factor_ppvvj_ew_bbbxbxzz_1, &
    & photonid_ppvvj_ew_bbbxbxzz_1
  use ol_external_ppvvj_ew_bbbxbxzz_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvvj_ew_bbbxbxzz_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_ppvvj_ew_bbbxbxzz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add(0:23-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(4), M1helarray(4,144)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3), ex6(3)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,16), wf6(6,16), wf8(8,48), wf9(9,1), wf12(12,84), wf16(16,4), wf18(18,14), wf24(24,24), wf36(36,2), &
    wf144(144,238)

  type(polcont) :: A(144,238)
  complex(REALKIND) :: Aj(238)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  extmasses2 = [ nMB, nMB, nMB, nMB, nMZ, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
      &  external_perm_inv_ppvvj_ew_bbbxbxzz_1, 6,.false.)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_ppvvj_ew_bbbxbxzz_1(I)
  else if (I < 0) then
    JBmunu = external_perm_ppvvj_ew_bbbxbxzz_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
       & extcomb_perm_ppvvj_ew_bbbxbxzz_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rMB, H1, ex1, POLSEL(1))
  call pol_wf_Q(P(:,2), rMB, H2, ex2, POLSEL(2))
  call pol_wf_A(P(:,3), rMB, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rMB, H4, ex4, POLSEL(4))
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5))
  call pol_wf_V(P(:,6), rMZ, H6, ex6, POLSEL(6))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rMB, H1, ex1, 0)
      call pol_wf_Q(P(:,2), rMB, H2, ex2, 0)
      call pol_wf_A(P(:,3), rMB, H3, ex3, 0)
      call pol_wf_A(P(:,4), rMB, H4, ex4, 0)
      call pol_wf_V(P(:,5), rMZ, H5, ex5, 0)
      call pol_wf_V(P(:,6), rMZ, H6, ex6, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex3, ex1, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gH,ntry, ex4, ex2, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VVS_S(ntry, ex5, ex6, wf4(:,1), wf36(:,1), n4(:,1), t4x36(:,:,1))
  call vert_AQ_S(gH,ntry, ex4, ex1, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_AQ_S(gH,ntry, ex3, ex2, wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_VVS_S(ntry, ex5, ex6, wf4(:,3), wf36(:,2), n4(:,2), t4x36(:,:,2))
  call vert_VV_S(ntry, ex5, ex6, wf9(:,1), n3(:,5), t3x9(:,:,1))
  call vert_SS_S(ntry, wf4(:,1), wf4(:,2), wf16(:,1), n3(:,6), t3x16(:,:,1))
  call vert_QA_Z(gZd,ntry, ex1, ex3, wf4(:,5), n3(:,7), t3x4(:,:,5))
  call vert_QA_Z(gZd,ntry, ex2, ex4, wf4(:,6), n3(:,8), t3x4(:,:,6))
  call prop_W_W(ntry, wf4(:,5), 5, MZ, 1_intkind1, wf4(:,7), n2(1))
  call prop_W_W(ntry, wf4(:,6), 10, MZ, 1_intkind1, wf4(:,8), n2(2))
  call vert_VV_S(ntry, wf4(:,7), wf4(:,8), wf16(:,2), n3(:,9), t3x16(:,:,2))
  call vert_SV_V(ntry, wf4(:,1), ex5, wf12(:,1), n3(:,10), t3x12(:,:,1))
  call vert_SV_V(ntry, wf4(:,2), ex6, wf12(:,2), n3(:,11), t3x12(:,:,2))
  call prop_W_W(ntry, wf12(:,1), 21, MZ, 1_intkind1, wf12(:,3), n2(3))
  call vert_VV_S(ntry, wf4(:,7), ex5, wf12(:,4), n3(:,12), t3x12(:,:,3))
  call vert_VV_S(ntry, wf4(:,8), ex6, wf12(:,5), n3(:,13), t3x12(:,:,4))
  call vert_SV_V(ntry, wf4(:,2), ex5, wf12(:,6), n3(:,14), t3x12(:,:,5))
  call vert_SV_V(ntry, wf4(:,1), ex6, wf12(:,7), n3(:,15), t3x12(:,:,6))
  call prop_W_W(ntry, wf12(:,6), 26, MZ, 1_intkind1, wf12(:,8), n2(4))
  call vert_VV_S(ntry, wf4(:,8), ex5, wf12(:,9), n3(:,16), t3x12(:,:,7))
  call vert_VV_S(ntry, wf4(:,7), ex6, wf12(:,10), n3(:,17), t3x12(:,:,8))
  call vert_ZQ_A(gZd,ntry, ex5, ex2, wf6(:,1), n3(:,18), t3x6(:,:,1))
  call vert_AZ_Q(gZd,ntry, ex4, ex6, wf6(:,2), n3(:,19), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,1), 18, MB, 1_intkind1, wf6(:,3), n2(5))
  call prop_A_Q(ntry, wf6(:,2), 40, MB, 1_intkind1, wf6(:,4), n2(6))
  call vert_QS_A(gH,ntry, wf6(:,3), wf4(:,1), wf24(:,1), n3(:,20), t3x24(:,:,1))
  call vert_QA_V(ntry, ex1, ex3, wf4(:,9), n3(:,21), t3x4(:,:,7))
  call vert_VQ_A(ntry, wf4(:,9), wf6(:,3), wf24(:,2), n3(:,22), t3x24(:,:,2))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), wf6(:,3), wf24(:,3), n3(:,23), t3x24(:,:,3))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4, wf8(:,1), n3(:,24), t3x8(:,:,1))
  call vert_ZQ_A(gZd,ntry, ex6, wf6(:,3), wf18(:,1), n3(:,25), t3x18(:,:,1))
  call prop_A_Q(ntry, wf8(:,1), 13, MB, 1_intkind1, wf8(:,2), n2(7))
  call vert_AV_Q(ntry, ex4, wf4(:,9), wf8(:,3), n3(:,26), t3x8(:,:,2))
  call prop_A_Q(ntry, wf8(:,3), 13, MB, 1_intkind1, wf8(:,4), n2(8))
  call vert_AZ_Q(gZd,ntry, ex4, wf4(:,7), wf8(:,5), n3(:,27), t3x8(:,:,3))
  call prop_A_Q(ntry, wf8(:,5), 13, MB, 1_intkind1, wf8(:,6), n2(9))
  call vert_QA_Z(gZd,ntry, wf6(:,3), ex4, wf12(:,11), n3(:,28), t3x12(:,:,9))
  call prop_W_W(ntry, wf12(:,11), 26, MZ, 1_intkind1, wf12(:,12), n2(10))
  call vert_AQ_S(gH,ntry, ex4, wf6(:,3), wf12(:,13), n3(:,29), t3x12(:,:,10))
  call vert_ZQ_A(gZd,ntry, ex6, ex2, wf6(:,5), n3(:,30), t3x6(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex4, ex5, wf6(:,6), n3(:,31), t3x6(:,:,4))
  call prop_Q_A(ntry, wf6(:,5), 34, MB, 1_intkind1, wf6(:,7), n2(11))
  call prop_A_Q(ntry, wf6(:,6), 24, MB, 1_intkind1, wf6(:,8), n2(12))
  call vert_QS_A(gH,ntry, wf6(:,7), wf4(:,1), wf24(:,4), n3(:,32), t3x24(:,:,4))
  call vert_VQ_A(ntry, wf4(:,9), wf6(:,7), wf24(:,5), n3(:,33), t3x24(:,:,5))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), wf6(:,7), wf24(:,6), n3(:,34), t3x24(:,:,6))
  call vert_QS_A(gH,ntry, ex2, wf4(:,1), wf8(:,7), n3(:,35), t3x8(:,:,4))
  call vert_AZ_Q(gZd,ntry, wf6(:,8), ex6, wf18(:,2), n3(:,36), t3x18(:,:,2))
  call prop_Q_A(ntry, wf8(:,7), 7, MB, 1_intkind1, wf8(:,8), n2(13))
  call vert_VQ_A(ntry, wf4(:,9), ex2, wf8(:,9), n3(:,37), t3x8(:,:,5))
  call prop_Q_A(ntry, wf8(:,9), 7, MB, 1_intkind1, wf8(:,10), n2(14))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex2, wf8(:,11), n3(:,38), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,11), 7, MB, 1_intkind1, wf8(:,12), n2(15))
  call vert_QA_Z(gZd,ntry, ex2, wf6(:,8), wf12(:,14), n3(:,39), t3x12(:,:,11))
  call prop_W_W(ntry, wf12(:,14), 26, MZ, 1_intkind1, wf12(:,15), n2(16))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex2, wf12(:,16), n3(:,40), t3x12(:,:,12))
  call vert_ZQ_A(gZd,ntry, ex5, wf6(:,7), wf18(:,3), n3(:,41), t3x18(:,:,3))
  call vert_QA_Z(gZd,ntry, wf6(:,7), ex4, wf12(:,17), n3(:,42), t3x12(:,:,13))
  call prop_W_W(ntry, wf12(:,17), 42, MZ, 1_intkind1, wf12(:,18), n2(17))
  call vert_AQ_S(gH,ntry, ex4, wf6(:,7), wf12(:,19), n3(:,43), t3x12(:,:,14))
  call vert_AZ_Q(gZd,ntry, wf6(:,4), ex5, wf18(:,4), n3(:,44), t3x18(:,:,4))
  call vert_QA_Z(gZd,ntry, ex2, wf6(:,4), wf12(:,20), n3(:,45), t3x12(:,:,15))
  call prop_W_W(ntry, wf12(:,20), 42, MZ, 1_intkind1, wf12(:,21), n2(18))
  call vert_AQ_S(gH,ntry, wf6(:,4), ex2, wf12(:,22), n3(:,46), t3x12(:,:,16))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex4, wf18(:,5), n3(:,47), t3x18(:,:,5))
  call vert_QS_A(gH,ntry, ex2, wf9(:,1), wf18(:,6), n3(:,48), t3x18(:,:,6))
  call prop_Q_A(ntry, wf18(:,6), 50, MB, 1_intkind1, wf18(:,7), n2(19))
  call vert_SS_S(ntry, wf4(:,4), wf4(:,3), wf16(:,3), n3(:,49), t3x16(:,:,3))
  call vert_QA_Z(gZd,ntry, ex1, ex4, wf4(:,10), n3(:,50), t3x4(:,:,8))
  call vert_QA_Z(gZd,ntry, ex2, ex3, wf4(:,11), n3(:,51), t3x4(:,:,9))
  call prop_W_W(ntry, wf4(:,10), 9, MZ, 1_intkind1, wf4(:,12), n2(20))
  call prop_W_W(ntry, wf4(:,11), 6, MZ, 1_intkind1, wf4(:,13), n2(21))
  call vert_VV_S(ntry, wf4(:,13), wf4(:,12), wf16(:,4), n3(:,52), t3x16(:,:,4))
  call vert_SV_V(ntry, wf4(:,3), ex5, wf12(:,23), n3(:,53), t3x12(:,:,17))
  call vert_SV_V(ntry, wf4(:,4), ex6, wf12(:,24), n3(:,54), t3x12(:,:,18))
  call prop_W_W(ntry, wf12(:,23), 25, MZ, 1_intkind1, wf12(:,25), n2(22))
  call vert_VV_S(ntry, wf4(:,12), ex5, wf12(:,26), n3(:,55), t3x12(:,:,19))
  call vert_VV_S(ntry, wf4(:,13), ex6, wf12(:,27), n3(:,56), t3x12(:,:,20))
  call vert_SV_V(ntry, wf4(:,4), ex5, wf12(:,28), n3(:,57), t3x12(:,:,21))
  call vert_SV_V(ntry, wf4(:,3), ex6, wf12(:,29), n3(:,58), t3x12(:,:,22))
  call prop_W_W(ntry, wf12(:,28), 22, MZ, 1_intkind1, wf12(:,30), n2(23))
  call vert_VV_S(ntry, wf4(:,13), ex5, wf12(:,31), n3(:,59), t3x12(:,:,23))
  call vert_VV_S(ntry, wf4(:,12), ex6, wf12(:,32), n3(:,60), t3x12(:,:,24))
  call vert_ZQ_A(gZd,ntry, ex5, ex1, wf6(:,9), n3(:,61), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,9), 17, MB, 1_intkind1, wf6(:,10), n2(24))
  call vert_QS_A(gH,ntry, wf6(:,10), wf4(:,4), wf24(:,7), n3(:,62), t3x24(:,:,7))
  call vert_QA_V(ntry, ex2, ex3, wf4(:,14), n3(:,63), t3x4(:,:,10))
  call vert_VQ_A(ntry, wf4(:,14), wf6(:,10), wf24(:,8), n3(:,64), t3x24(:,:,8))
  call vert_ZQ_A(gZd,ntry, wf4(:,13), wf6(:,10), wf24(:,9), n3(:,65), t3x24(:,:,9))
  call vert_QA_Z(gZd,ntry, wf6(:,10), ex4, wf12(:,33), n3(:,66), t3x12(:,:,25))
  call prop_W_W(ntry, wf12(:,33), 25, MZ, 1_intkind1, wf12(:,34), n2(25))
  call vert_AQ_S(gH,ntry, ex4, wf6(:,10), wf12(:,35), n3(:,67), t3x12(:,:,26))
  call vert_SA_Q(gH,ntry, wf4(:,4), ex4, wf8(:,13), n3(:,68), t3x8(:,:,7))
  call vert_ZQ_A(gZd,ntry, ex6, wf6(:,10), wf18(:,8), n3(:,69), t3x18(:,:,7))
  call prop_A_Q(ntry, wf8(:,13), 14, MB, 1_intkind1, wf8(:,14), n2(26))
  call vert_AV_Q(ntry, ex4, wf4(:,14), wf8(:,15), n3(:,70), t3x8(:,:,8))
  call prop_A_Q(ntry, wf8(:,15), 14, MB, 1_intkind1, wf8(:,16), n2(27))
  call vert_AZ_Q(gZd,ntry, ex4, wf4(:,13), wf8(:,17), n3(:,71), t3x8(:,:,9))
  call prop_A_Q(ntry, wf8(:,17), 14, MB, 1_intkind1, wf8(:,18), n2(28))
  call vert_ZQ_A(gZd,ntry, ex6, ex1, wf6(:,11), n3(:,72), t3x6(:,:,6))
  call prop_Q_A(ntry, wf6(:,11), 33, MB, 1_intkind1, wf6(:,12), n2(29))
  call vert_QS_A(gH,ntry, wf6(:,12), wf4(:,4), wf24(:,10), n3(:,73), t3x24(:,:,10))
  call vert_VQ_A(ntry, wf4(:,14), wf6(:,12), wf24(:,11), n3(:,74), t3x24(:,:,11))
  call vert_ZQ_A(gZd,ntry, wf4(:,13), wf6(:,12), wf24(:,12), n3(:,75), t3x24(:,:,12))
  call vert_QS_A(gH,ntry, ex1, wf4(:,4), wf8(:,19), n3(:,76), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,19), 7, MB, 1_intkind1, wf8(:,20), n2(30))
  call vert_VQ_A(ntry, wf4(:,14), ex1, wf8(:,21), n3(:,77), t3x8(:,:,11))
  call prop_Q_A(ntry, wf8(:,21), 7, MB, 1_intkind1, wf8(:,22), n2(31))
  call vert_ZQ_A(gZd,ntry, wf4(:,13), ex1, wf8(:,23), n3(:,78), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,23), 7, MB, 1_intkind1, wf8(:,24), n2(32))
  call vert_AQ_S(gH,ntry, wf6(:,8), ex1, wf12(:,36), n3(:,79), t3x12(:,:,27))
  call vert_QA_Z(gZd,ntry, ex1, wf6(:,8), wf12(:,37), n3(:,80), t3x12(:,:,28))
  call prop_W_W(ntry, wf12(:,37), 25, MZ, 1_intkind1, wf12(:,38), n2(33))
  call vert_QA_Z(gZd,ntry, wf6(:,12), ex4, wf12(:,39), n3(:,81), t3x12(:,:,29))
  call prop_W_W(ntry, wf12(:,39), 41, MZ, 1_intkind1, wf12(:,40), n2(34))
  call vert_AQ_S(gH,ntry, ex4, wf6(:,12), wf12(:,41), n3(:,82), t3x12(:,:,30))
  call vert_ZQ_A(gZd,ntry, ex5, wf6(:,12), wf18(:,9), n3(:,83), t3x18(:,:,8))
  call vert_AQ_S(gH,ntry, wf6(:,4), ex1, wf12(:,42), n3(:,84), t3x12(:,:,31))
  call vert_QA_Z(gZd,ntry, ex1, wf6(:,4), wf12(:,43), n3(:,85), t3x12(:,:,32))
  call prop_W_W(ntry, wf12(:,43), 41, MZ, 1_intkind1, wf12(:,44), n2(35))
  call vert_QS_A(gH,ntry, ex1, wf9(:,1), wf18(:,10), n3(:,86), t3x18(:,:,9))
  call prop_Q_A(ntry, wf18(:,10), 49, MB, 1_intkind1, wf18(:,11), n2(36))
  call vert_AZ_Q(gZd,ntry, ex3, ex6, wf6(:,13), n3(:,87), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 36, MB, 1_intkind1, wf6(:,14), n2(37))
  call vert_QS_A(gH,ntry, wf6(:,3), wf4(:,3), wf24(:,13), n3(:,88), t3x24(:,:,13))
  call vert_QA_V(ntry, ex1, ex4, wf4(:,15), n3(:,89), t3x4(:,:,11))
  call vert_VQ_A(ntry, wf4(:,15), wf6(:,3), wf24(:,14), n3(:,90), t3x24(:,:,14))
  call vert_ZQ_A(gZd,ntry, wf4(:,12), wf6(:,3), wf24(:,15), n3(:,91), t3x24(:,:,15))
  call vert_SA_Q(gH,ntry, wf4(:,3), ex3, wf8(:,25), n3(:,92), t3x8(:,:,13))
  call prop_A_Q(ntry, wf8(:,25), 13, MB, 1_intkind1, wf8(:,26), n2(38))
  call vert_AV_Q(ntry, ex3, wf4(:,15), wf8(:,27), n3(:,93), t3x8(:,:,14))
  call prop_A_Q(ntry, wf8(:,27), 13, MB, 1_intkind1, wf8(:,28), n2(39))
  call vert_AZ_Q(gZd,ntry, ex3, wf4(:,12), wf8(:,29), n3(:,94), t3x8(:,:,15))
  call prop_A_Q(ntry, wf8(:,29), 13, MB, 1_intkind1, wf8(:,30), n2(40))
  call vert_QA_Z(gZd,ntry, wf6(:,3), ex3, wf12(:,45), n3(:,95), t3x12(:,:,33))
  call prop_W_W(ntry, wf12(:,45), 22, MZ, 1_intkind1, wf12(:,46), n2(41))
  call vert_AQ_S(gH,ntry, ex3, wf6(:,3), wf12(:,47), n3(:,96), t3x12(:,:,34))
  call vert_AZ_Q(gZd,ntry, ex3, ex5, wf6(:,15), n3(:,97), t3x6(:,:,8))
  call prop_A_Q(ntry, wf6(:,15), 20, MB, 1_intkind1, wf6(:,16), n2(42))
  call vert_QS_A(gH,ntry, wf6(:,7), wf4(:,3), wf24(:,16), n3(:,98), t3x24(:,:,16))
  call vert_VQ_A(ntry, wf4(:,15), wf6(:,7), wf24(:,17), n3(:,99), t3x24(:,:,17))
  call vert_ZQ_A(gZd,ntry, wf4(:,12), wf6(:,7), wf24(:,18), n3(:,100), t3x24(:,:,18))
  call vert_QS_A(gH,ntry, ex2, wf4(:,3), wf8(:,31), n3(:,101), t3x8(:,:,16))
  call vert_AZ_Q(gZd,ntry, wf6(:,16), ex6, wf18(:,12), n3(:,102), t3x18(:,:,10))
  call prop_Q_A(ntry, wf8(:,31), 11, MB, 1_intkind1, wf8(:,32), n2(43))
  call vert_VQ_A(ntry, wf4(:,15), ex2, wf8(:,33), n3(:,103), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,33), 11, MB, 1_intkind1, wf8(:,34), n2(44))
  call vert_ZQ_A(gZd,ntry, wf4(:,12), ex2, wf8(:,35), n3(:,104), t3x8(:,:,18))
  call prop_Q_A(ntry, wf8(:,35), 11, MB, 1_intkind1, wf8(:,36), n2(45))
  call vert_QA_Z(gZd,ntry, ex2, wf6(:,16), wf12(:,48), n3(:,105), t3x12(:,:,35))
  call prop_W_W(ntry, wf12(:,48), 22, MZ, 1_intkind1, wf12(:,49), n2(46))
  call vert_AQ_S(gH,ntry, wf6(:,16), ex2, wf12(:,50), n3(:,106), t3x12(:,:,36))
  call vert_QA_Z(gZd,ntry, wf6(:,7), ex3, wf12(:,51), n3(:,107), t3x12(:,:,37))
  call prop_W_W(ntry, wf12(:,51), 38, MZ, 1_intkind1, wf12(:,52), n2(47))
  call vert_AQ_S(gH,ntry, ex3, wf6(:,7), wf12(:,53), n3(:,108), t3x12(:,:,38))
  call vert_AZ_Q(gZd,ntry, wf6(:,14), ex5, wf18(:,13), n3(:,109), t3x18(:,:,11))
  call vert_QA_Z(gZd,ntry, ex2, wf6(:,14), wf12(:,54), n3(:,110), t3x12(:,:,39))
  call prop_W_W(ntry, wf12(:,54), 38, MZ, 1_intkind1, wf12(:,55), n2(48))
  call vert_AQ_S(gH,ntry, wf6(:,14), ex2, wf12(:,56), n3(:,111), t3x12(:,:,40))
  call vert_SA_Q(gH,ntry, wf9(:,1), ex3, wf18(:,14), n3(:,112), t3x18(:,:,12))
  call vert_QS_A(gH,ntry, wf6(:,10), wf4(:,2), wf24(:,19), n3(:,113), t3x24(:,:,19))
  call vert_QA_V(ntry, ex2, ex4, wf4(:,16), n3(:,114), t3x4(:,:,12))
  call vert_VQ_A(ntry, wf4(:,16), wf6(:,10), wf24(:,20), n3(:,115), t3x24(:,:,20))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf6(:,10), wf24(:,21), n3(:,116), t3x24(:,:,21))
  call vert_QA_Z(gZd,ntry, wf6(:,10), ex3, wf12(:,57), n3(:,117), t3x12(:,:,41))
  call prop_W_W(ntry, wf12(:,57), 21, MZ, 1_intkind1, wf12(:,58), n2(49))
  call vert_AQ_S(gH,ntry, ex3, wf6(:,10), wf12(:,59), n3(:,118), t3x12(:,:,42))
  call vert_SA_Q(gH,ntry, wf4(:,2), ex3, wf8(:,37), n3(:,119), t3x8(:,:,19))
  call prop_A_Q(ntry, wf8(:,37), 14, MB, 1_intkind1, wf8(:,38), n2(50))
  call vert_AV_Q(ntry, ex3, wf4(:,16), wf8(:,39), n3(:,120), t3x8(:,:,20))
  call prop_A_Q(ntry, wf8(:,39), 14, MB, 1_intkind1, wf8(:,40), n2(51))
  call vert_AZ_Q(gZd,ntry, ex3, wf4(:,8), wf8(:,41), n3(:,121), t3x8(:,:,21))
  call prop_A_Q(ntry, wf8(:,41), 14, MB, 1_intkind1, wf8(:,42), n2(52))
  call vert_QS_A(gH,ntry, wf6(:,12), wf4(:,2), wf24(:,22), n3(:,122), t3x24(:,:,22))
  call vert_VQ_A(ntry, wf4(:,16), wf6(:,12), wf24(:,23), n3(:,123), t3x24(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), wf6(:,12), wf24(:,24), n3(:,124), t3x24(:,:,24))
  call vert_QS_A(gH,ntry, ex1, wf4(:,2), wf8(:,43), n3(:,125), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,43), 11, MB, 1_intkind1, wf8(:,44), n2(53))
  call vert_VQ_A(ntry, wf4(:,16), ex1, wf8(:,45), n3(:,126), t3x8(:,:,23))
  call prop_Q_A(ntry, wf8(:,45), 11, MB, 1_intkind1, wf8(:,46), n2(54))
  call vert_ZQ_A(gZd,ntry, wf4(:,8), ex1, wf8(:,47), n3(:,127), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,47), 11, MB, 1_intkind1, wf8(:,48), n2(55))
  call vert_AQ_S(gH,ntry, wf6(:,16), ex1, wf12(:,60), n3(:,128), t3x12(:,:,43))
  call vert_QA_Z(gZd,ntry, ex1, wf6(:,16), wf12(:,61), n3(:,129), t3x12(:,:,44))
  call prop_W_W(ntry, wf12(:,61), 21, MZ, 1_intkind1, wf12(:,62), n2(56))
  call vert_QA_Z(gZd,ntry, wf6(:,12), ex3, wf12(:,63), n3(:,130), t3x12(:,:,45))
  call prop_W_W(ntry, wf12(:,63), 37, MZ, 1_intkind1, wf12(:,64), n2(57))
  call vert_AQ_S(gH,ntry, ex3, wf6(:,12), wf12(:,65), n3(:,131), t3x12(:,:,46))
  call vert_AQ_S(gH,ntry, wf6(:,14), ex1, wf12(:,66), n3(:,132), t3x12(:,:,47))
  call vert_QA_Z(gZd,ntry, ex1, wf6(:,14), wf12(:,67), n3(:,133), t3x12(:,:,48))
  call prop_W_W(ntry, wf12(:,67), 37, MZ, 1_intkind1, wf12(:,68), n2(58))
  call vert_QA_V(ntry, wf6(:,10), ex3, wf12(:,69), n3(:,134), t3x12(:,:,49))
  call vert_QA_V(ntry, wf6(:,7), ex4, wf12(:,70), n3(:,135), t3x12(:,:,50))
  call vert_QA_V(ntry, wf6(:,7), ex3, wf12(:,71), n3(:,136), t3x12(:,:,51))
  call vert_QA_V(ntry, wf6(:,10), ex4, wf12(:,72), n3(:,137), t3x12(:,:,52))
  call vert_QA_V(ntry, ex2, wf6(:,14), wf12(:,73), n3(:,138), t3x12(:,:,53))
  call vert_QA_V(ntry, ex2, wf6(:,4), wf12(:,74), n3(:,139), t3x12(:,:,54))
  call vert_QA_V(ntry, wf6(:,12), ex3, wf12(:,75), n3(:,140), t3x12(:,:,55))
  call vert_QA_V(ntry, wf6(:,3), ex4, wf12(:,76), n3(:,141), t3x12(:,:,56))
  call vert_QA_V(ntry, wf6(:,3), ex3, wf12(:,77), n3(:,142), t3x12(:,:,57))
  call vert_QA_V(ntry, wf6(:,12), ex4, wf12(:,78), n3(:,143), t3x12(:,:,58))
  call vert_QA_V(ntry, ex1, wf6(:,14), wf12(:,79), n3(:,144), t3x12(:,:,59))
  call vert_QA_V(ntry, ex1, wf6(:,4), wf12(:,80), n3(:,145), t3x12(:,:,60))
  call vert_QA_V(ntry, ex2, wf6(:,16), wf12(:,81), n3(:,146), t3x12(:,:,61))
  call vert_QA_V(ntry, ex1, wf6(:,16), wf12(:,82), n3(:,147), t3x12(:,:,62))
  call vert_QA_V(ntry, ex2, wf6(:,8), wf12(:,83), n3(:,148), t3x12(:,:,63))
  call vert_QA_V(ntry, ex1, wf6(:,8), wf12(:,84), n3(:,149), t3x12(:,:,64))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  M2munu = 0
  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_ppvvj_ew_bbbxbxzz_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_ppvvj_ew_bbbxbxzz_1

  do k = 0, 23-1
    M2(k) = M2add(extcomb_perm_ppvvj_ew_bbbxbxzz_1(k))
  end do

  ! photon-factors
  call photon_factors(photonid_ppvvj_ew_bbbxbxzz_1, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*6-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_SS(nsync, wf4(:,2), wf36(:,1), A(:,1), n3(:,150), t3x144(:,:,1), nhel, den(3))
    call cont_SS(nsync, wf4(:,4), wf36(:,2), A(:,2), n3(:,151), t3x144(:,:,2), nhel, den(6))
    call cont_SS(nsync, wf9(:,1), wf16(:,1), A(:,3), n3(:,152), t3x144(:,:,3), nhel, den(8))
    call cont_SS(nsync, wf9(:,1), wf16(:,2), A(:,4), n3(:,153), t3x144(:,:,4), nhel, den(12))
    call cont_VV(nsync, wf12(:,2), wf12(:,3), A(:,5), n3(:,154), t3x144(:,:,5), nhel, den(15))
    call cont_SS(nsync, wf12(:,4), wf12(:,5), A(:,6), n3(:,155), t3x144(:,:,6), nhel, den(18))
    call cont_VV(nsync, wf12(:,7), wf12(:,8), A(:,7), n3(:,156), t3x144(:,:,7), nhel, den(21))
    call cont_SS(nsync, wf12(:,9), wf12(:,10), A(:,8), n3(:,157), t3x144(:,:,8), nhel, den(24))
    call cont_QA(nsync, wf6(:,4), wf24(:,1), A(:,9), n3(:,158), t3x144(:,:,9), nhel, den(28))
    call cont_QA(nsync, wf6(:,4), wf24(:,2), A(:,10), n3(:,159), t3x144(:,:,10), nhel, den(31))
    call cont_QA(nsync, wf6(:,4), wf24(:,3), A(:,11), n3(:,160), t3x144(:,:,11), nhel, den(33))
    call cont_QA(nsync, wf6(:,4), wf24(:,2), A(:,12), n3(:,161), t3x144(:,:,12), nhel, den(31))
    call cont_QA(nsync, wf18(:,1), wf8(:,2), A(:,13), n3(:,162), t3x144(:,:,13), nhel, den(36))
    call cont_QA(nsync, wf18(:,1), wf8(:,4), A(:,14), n3(:,163), t3x144(:,:,14), nhel, den(38))
    call cont_QA(nsync, wf18(:,1), wf8(:,6), A(:,15), n3(:,164), t3x144(:,:,15), nhel, den(40))
    call cont_QA(nsync, wf18(:,1), wf8(:,4), A(:,16), n3(:,165), t3x144(:,:,16), nhel, den(38))
    call cont_VV(nsync, wf12(:,7), wf12(:,12), A(:,17), n3(:,166), t3x144(:,:,17), nhel, den(42))
    call cont_SS(nsync, wf12(:,10), wf12(:,13), A(:,18), n3(:,167), t3x144(:,:,18), nhel, den(44))
    call cont_QA(nsync, wf6(:,8), wf24(:,4), A(:,19), n3(:,168), t3x144(:,:,19), nhel, den(48))
    call cont_QA(nsync, wf6(:,8), wf24(:,5), A(:,20), n3(:,169), t3x144(:,:,20), nhel, den(50))
    call cont_QA(nsync, wf6(:,8), wf24(:,6), A(:,21), n3(:,170), t3x144(:,:,21), nhel, den(52))
    call cont_QA(nsync, wf6(:,8), wf24(:,5), A(:,22), n3(:,171), t3x144(:,:,22), nhel, den(50))
    call cont_QA(nsync, wf18(:,2), wf8(:,8), A(:,23), n3(:,172), t3x144(:,:,23), nhel, den(55))
    call cont_QA(nsync, wf18(:,2), wf8(:,10), A(:,24), n3(:,173), t3x144(:,:,24), nhel, den(57))
    call cont_QA(nsync, wf18(:,2), wf8(:,12), A(:,25), n3(:,174), t3x144(:,:,25), nhel, den(59))
    call cont_QA(nsync, wf18(:,2), wf8(:,10), A(:,26), n3(:,175), t3x144(:,:,26), nhel, den(57))
    call cont_VV(nsync, wf12(:,7), wf12(:,15), A(:,27), n3(:,176), t3x144(:,:,27), nhel, den(61))
    call cont_SS(nsync, wf12(:,10), wf12(:,16), A(:,28), n3(:,177), t3x144(:,:,28), nhel, den(63))
    call cont_QA(nsync, wf8(:,2), wf18(:,3), A(:,29), n3(:,178), t3x144(:,:,29), nhel, den(64))
    call cont_QA(nsync, wf8(:,4), wf18(:,3), A(:,30), n3(:,179), t3x144(:,:,30), nhel, den(65))
    call cont_QA(nsync, wf8(:,6), wf18(:,3), A(:,31), n3(:,180), t3x144(:,:,31), nhel, den(66))
    call cont_QA(nsync, wf8(:,4), wf18(:,3), A(:,32), n3(:,181), t3x144(:,:,32), nhel, den(65))
    call cont_VV(nsync, wf12(:,1), wf12(:,18), A(:,33), n3(:,182), t3x144(:,:,33), nhel, den(69))
    call cont_SS(nsync, wf12(:,4), wf12(:,19), A(:,34), n3(:,183), t3x144(:,:,34), nhel, den(72))
    call cont_QA(nsync, wf8(:,8), wf18(:,4), A(:,35), n3(:,184), t3x144(:,:,35), nhel, den(73))
    call cont_QA(nsync, wf8(:,10), wf18(:,4), A(:,36), n3(:,185), t3x144(:,:,36), nhel, den(74))
    call cont_QA(nsync, wf8(:,12), wf18(:,4), A(:,37), n3(:,186), t3x144(:,:,37), nhel, den(75))
    call cont_QA(nsync, wf8(:,10), wf18(:,4), A(:,38), n3(:,187), t3x144(:,:,38), nhel, den(74))
    call cont_VV(nsync, wf12(:,1), wf12(:,21), A(:,39), n3(:,188), t3x144(:,:,39), nhel, den(77))
    call cont_SS(nsync, wf12(:,4), wf12(:,22), A(:,40), n3(:,189), t3x144(:,:,40), nhel, den(79))
    call cont_QA(nsync, wf8(:,8), wf18(:,5), A(:,41), n3(:,190), t3x144(:,:,41), nhel, den(80))
    call cont_QA(nsync, wf8(:,10), wf18(:,5), A(:,42), n3(:,191), t3x144(:,:,42), nhel, den(81))
    call cont_QA(nsync, wf8(:,12), wf18(:,5), A(:,43), n3(:,192), t3x144(:,:,43), nhel, den(82))
    call cont_QA(nsync, wf8(:,10), wf18(:,5), A(:,44), n3(:,193), t3x144(:,:,44), nhel, den(81))
    call cont_QA(nsync, wf8(:,1), wf18(:,7), A(:,45), n3(:,194), t3x144(:,:,45), nhel, den(85))
    call cont_QA(nsync, wf8(:,3), wf18(:,7), A(:,46), n3(:,195), t3x144(:,:,46), nhel, den(86))
    call cont_QA(nsync, wf8(:,5), wf18(:,7), A(:,47), n3(:,196), t3x144(:,:,47), nhel, den(87))
    call cont_QA(nsync, wf8(:,3), wf18(:,7), A(:,48), n3(:,197), t3x144(:,:,48), nhel, den(86))
    call cont_SS(nsync, wf9(:,1), wf16(:,3), A(:,49), n3(:,198), t3x144(:,:,49), nhel, den(88))
    call cont_SS(nsync, wf9(:,1), wf16(:,4), A(:,50), n3(:,199), t3x144(:,:,50), nhel, den(92))
    call cont_VV(nsync, wf12(:,24), wf12(:,25), A(:,51), n3(:,200), t3x144(:,:,51), nhel, den(95))
    call cont_SS(nsync, wf12(:,26), wf12(:,27), A(:,52), n3(:,201), t3x144(:,:,52), nhel, den(98))
    call cont_VV(nsync, wf12(:,29), wf12(:,30), A(:,53), n3(:,202), t3x144(:,:,53), nhel, den(101))
    call cont_SS(nsync, wf12(:,31), wf12(:,32), A(:,54), n3(:,203), t3x144(:,:,54), nhel, den(104))
    call cont_QA(nsync, wf6(:,4), wf24(:,7), A(:,55), n3(:,204), t3x144(:,:,55), nhel, den(107))
    call cont_QA(nsync, wf6(:,4), wf24(:,8), A(:,56), n3(:,205), t3x144(:,:,56), nhel, den(110))
    call cont_QA(nsync, wf6(:,4), wf24(:,9), A(:,57), n3(:,206), t3x144(:,:,57), nhel, den(112))
    call cont_QA(nsync, wf6(:,4), wf24(:,8), A(:,58), n3(:,207), t3x144(:,:,58), nhel, den(110))
    call cont_VV(nsync, wf12(:,24), wf12(:,34), A(:,59), n3(:,208), t3x144(:,:,59), nhel, den(114))
    call cont_SS(nsync, wf12(:,27), wf12(:,35), A(:,60), n3(:,209), t3x144(:,:,60), nhel, den(116))
    call cont_QA(nsync, wf18(:,8), wf8(:,14), A(:,61), n3(:,210), t3x144(:,:,61), nhel, den(119))
    call cont_QA(nsync, wf18(:,8), wf8(:,16), A(:,62), n3(:,211), t3x144(:,:,62), nhel, den(121))
    call cont_QA(nsync, wf18(:,8), wf8(:,18), A(:,63), n3(:,212), t3x144(:,:,63), nhel, den(123))
    call cont_QA(nsync, wf18(:,8), wf8(:,16), A(:,64), n3(:,213), t3x144(:,:,64), nhel, den(121))
    call cont_QA(nsync, wf6(:,8), wf24(:,10), A(:,65), n3(:,214), t3x144(:,:,65), nhel, den(126))
    call cont_QA(nsync, wf6(:,8), wf24(:,11), A(:,66), n3(:,215), t3x144(:,:,66), nhel, den(128))
    call cont_QA(nsync, wf6(:,8), wf24(:,12), A(:,67), n3(:,216), t3x144(:,:,67), nhel, den(130))
    call cont_QA(nsync, wf6(:,8), wf24(:,11), A(:,68), n3(:,217), t3x144(:,:,68), nhel, den(128))
    call cont_QA(nsync, wf18(:,2), wf8(:,20), A(:,69), n3(:,218), t3x144(:,:,69), nhel, den(132))
    call cont_QA(nsync, wf18(:,2), wf8(:,22), A(:,70), n3(:,219), t3x144(:,:,70), nhel, den(134))
    call cont_QA(nsync, wf18(:,2), wf8(:,24), A(:,71), n3(:,220), t3x144(:,:,71), nhel, den(136))
    call cont_QA(nsync, wf18(:,2), wf8(:,22), A(:,72), n3(:,221), t3x144(:,:,72), nhel, den(134))
    call cont_SS(nsync, wf12(:,27), wf12(:,36), A(:,73), n3(:,222), t3x144(:,:,73), nhel, den(138))
    call cont_VV(nsync, wf12(:,24), wf12(:,38), A(:,74), n3(:,223), t3x144(:,:,74), nhel, den(140))
    call cont_VV(nsync, wf12(:,28), wf12(:,40), A(:,75), n3(:,224), t3x144(:,:,75), nhel, den(143))
    call cont_SS(nsync, wf12(:,31), wf12(:,41), A(:,76), n3(:,225), t3x144(:,:,76), nhel, den(146))
    call cont_QA(nsync, wf8(:,14), wf18(:,9), A(:,77), n3(:,226), t3x144(:,:,77), nhel, den(147))
    call cont_QA(nsync, wf8(:,16), wf18(:,9), A(:,78), n3(:,227), t3x144(:,:,78), nhel, den(148))
    call cont_QA(nsync, wf8(:,18), wf18(:,9), A(:,79), n3(:,228), t3x144(:,:,79), nhel, den(149))
    call cont_QA(nsync, wf8(:,16), wf18(:,9), A(:,80), n3(:,229), t3x144(:,:,80), nhel, den(148))
    call cont_QA(nsync, wf18(:,4), wf8(:,20), A(:,81), n3(:,230), t3x144(:,:,81), nhel, den(150))
    call cont_QA(nsync, wf18(:,4), wf8(:,22), A(:,82), n3(:,231), t3x144(:,:,82), nhel, den(151))
    call cont_QA(nsync, wf18(:,4), wf8(:,24), A(:,83), n3(:,232), t3x144(:,:,83), nhel, den(152))
    call cont_QA(nsync, wf18(:,4), wf8(:,22), A(:,84), n3(:,233), t3x144(:,:,84), nhel, den(151))
    call cont_SS(nsync, wf12(:,31), wf12(:,42), A(:,85), n3(:,234), t3x144(:,:,85), nhel, den(154))
    call cont_VV(nsync, wf12(:,28), wf12(:,44), A(:,86), n3(:,235), t3x144(:,:,86), nhel, den(156))
    call cont_QA(nsync, wf18(:,5), wf8(:,20), A(:,87), n3(:,236), t3x144(:,:,87), nhel, den(157))
    call cont_QA(nsync, wf18(:,5), wf8(:,22), A(:,88), n3(:,237), t3x144(:,:,88), nhel, den(158))
    call cont_QA(nsync, wf18(:,5), wf8(:,24), A(:,89), n3(:,238), t3x144(:,:,89), nhel, den(159))
    call cont_QA(nsync, wf18(:,5), wf8(:,22), A(:,90), n3(:,239), t3x144(:,:,90), nhel, den(158))
    call cont_QA(nsync, wf8(:,13), wf18(:,11), A(:,91), n3(:,240), t3x144(:,:,91), nhel, den(162))
    call cont_QA(nsync, wf8(:,15), wf18(:,11), A(:,92), n3(:,241), t3x144(:,:,92), nhel, den(163))
    call cont_QA(nsync, wf8(:,17), wf18(:,11), A(:,93), n3(:,242), t3x144(:,:,93), nhel, den(164))
    call cont_QA(nsync, wf8(:,15), wf18(:,11), A(:,94), n3(:,243), t3x144(:,:,94), nhel, den(163))
    call cont_QA(nsync, wf6(:,14), wf24(:,13), A(:,95), n3(:,244), t3x144(:,:,95), nhel, den(167))
    call cont_QA(nsync, wf6(:,14), wf24(:,14), A(:,96), n3(:,245), t3x144(:,:,96), nhel, den(170))
    call cont_QA(nsync, wf6(:,14), wf24(:,15), A(:,97), n3(:,246), t3x144(:,:,97), nhel, den(172))
    call cont_QA(nsync, wf6(:,14), wf24(:,14), A(:,98), n3(:,247), t3x144(:,:,98), nhel, den(170))
    call cont_QA(nsync, wf18(:,1), wf8(:,26), A(:,99), n3(:,248), t3x144(:,:,99), nhel, den(174))
    call cont_QA(nsync, wf18(:,1), wf8(:,28), A(:,100), n3(:,249), t3x144(:,:,100), nhel, den(176))
    call cont_QA(nsync, wf18(:,1), wf8(:,30), A(:,101), n3(:,250), t3x144(:,:,101), nhel, den(178))
    call cont_QA(nsync, wf18(:,1), wf8(:,28), A(:,102), n3(:,251), t3x144(:,:,102), nhel, den(176))
    call cont_VV(nsync, wf12(:,29), wf12(:,46), A(:,103), n3(:,252), t3x144(:,:,103), nhel, den(180))
    call cont_SS(nsync, wf12(:,32), wf12(:,47), A(:,104), n3(:,253), t3x144(:,:,104), nhel, den(182))
    call cont_QA(nsync, wf6(:,16), wf24(:,16), A(:,105), n3(:,254), t3x144(:,:,105), nhel, den(185))
    call cont_QA(nsync, wf6(:,16), wf24(:,17), A(:,106), n3(:,255), t3x144(:,:,106), nhel, den(187))
    call cont_QA(nsync, wf6(:,16), wf24(:,18), A(:,107), n3(:,256), t3x144(:,:,107), nhel, den(189))
    call cont_QA(nsync, wf6(:,16), wf24(:,17), A(:,108), n3(:,257), t3x144(:,:,108), nhel, den(187))
    call cont_QA(nsync, wf18(:,12), wf8(:,32), A(:,109), n3(:,258), t3x144(:,:,109), nhel, den(192))
    call cont_QA(nsync, wf18(:,12), wf8(:,34), A(:,110), n3(:,259), t3x144(:,:,110), nhel, den(194))
    call cont_QA(nsync, wf18(:,12), wf8(:,36), A(:,111), n3(:,260), t3x144(:,:,111), nhel, den(196))
    call cont_QA(nsync, wf18(:,12), wf8(:,34), A(:,112), n3(:,261), t3x144(:,:,112), nhel, den(194))
    call cont_VV(nsync, wf12(:,29), wf12(:,49), A(:,113), n3(:,262), t3x144(:,:,113), nhel, den(198))
    call cont_SS(nsync, wf12(:,32), wf12(:,50), A(:,114), n3(:,263), t3x144(:,:,114), nhel, den(200))
    call cont_QA(nsync, wf18(:,3), wf8(:,26), A(:,115), n3(:,264), t3x144(:,:,115), nhel, den(201))
    call cont_QA(nsync, wf18(:,3), wf8(:,28), A(:,116), n3(:,265), t3x144(:,:,116), nhel, den(202))
    call cont_QA(nsync, wf18(:,3), wf8(:,30), A(:,117), n3(:,266), t3x144(:,:,117), nhel, den(203))
    call cont_QA(nsync, wf18(:,3), wf8(:,28), A(:,118), n3(:,267), t3x144(:,:,118), nhel, den(202))
    call cont_VV(nsync, wf12(:,23), wf12(:,52), A(:,119), n3(:,268), t3x144(:,:,119), nhel, den(206))
    call cont_SS(nsync, wf12(:,26), wf12(:,53), A(:,120), n3(:,269), t3x144(:,:,120), nhel, den(209))
    call cont_QA(nsync, wf8(:,32), wf18(:,13), A(:,121), n3(:,270), t3x144(:,:,121), nhel, den(210))
    call cont_QA(nsync, wf8(:,34), wf18(:,13), A(:,122), n3(:,271), t3x144(:,:,122), nhel, den(211))
    call cont_QA(nsync, wf8(:,36), wf18(:,13), A(:,123), n3(:,272), t3x144(:,:,123), nhel, den(212))
    call cont_QA(nsync, wf8(:,34), wf18(:,13), A(:,124), n3(:,273), t3x144(:,:,124), nhel, den(211))
    call cont_VV(nsync, wf12(:,23), wf12(:,55), A(:,125), n3(:,274), t3x144(:,:,125), nhel, den(214))
    call cont_SS(nsync, wf12(:,26), wf12(:,56), A(:,126), n3(:,275), t3x144(:,:,126), nhel, den(216))
    call cont_QA(nsync, wf8(:,32), wf18(:,14), A(:,127), n3(:,276), t3x144(:,:,127), nhel, den(217))
    call cont_QA(nsync, wf8(:,34), wf18(:,14), A(:,128), n3(:,277), t3x144(:,:,128), nhel, den(218))
    call cont_QA(nsync, wf8(:,36), wf18(:,14), A(:,129), n3(:,278), t3x144(:,:,129), nhel, den(219))
    call cont_QA(nsync, wf8(:,34), wf18(:,14), A(:,130), n3(:,279), t3x144(:,:,130), nhel, den(218))
    call cont_QA(nsync, wf18(:,7), wf8(:,25), A(:,131), n3(:,280), t3x144(:,:,131), nhel, den(220))
    call cont_QA(nsync, wf18(:,7), wf8(:,27), A(:,132), n3(:,281), t3x144(:,:,132), nhel, den(221))
    call cont_QA(nsync, wf18(:,7), wf8(:,29), A(:,133), n3(:,282), t3x144(:,:,133), nhel, den(222))
    call cont_QA(nsync, wf18(:,7), wf8(:,27), A(:,134), n3(:,283), t3x144(:,:,134), nhel, den(221))
    call cont_QA(nsync, wf6(:,14), wf24(:,19), A(:,135), n3(:,284), t3x144(:,:,135), nhel, den(224))
    call cont_QA(nsync, wf6(:,14), wf24(:,20), A(:,136), n3(:,285), t3x144(:,:,136), nhel, den(227))
    call cont_QA(nsync, wf6(:,14), wf24(:,21), A(:,137), n3(:,286), t3x144(:,:,137), nhel, den(229))
    call cont_QA(nsync, wf6(:,14), wf24(:,20), A(:,138), n3(:,287), t3x144(:,:,138), nhel, den(227))
    call cont_VV(nsync, wf12(:,2), wf12(:,58), A(:,139), n3(:,288), t3x144(:,:,139), nhel, den(231))
    call cont_SS(nsync, wf12(:,5), wf12(:,59), A(:,140), n3(:,289), t3x144(:,:,140), nhel, den(233))
    call cont_QA(nsync, wf18(:,8), wf8(:,38), A(:,141), n3(:,290), t3x144(:,:,141), nhel, den(235))
    call cont_QA(nsync, wf18(:,8), wf8(:,40), A(:,142), n3(:,291), t3x144(:,:,142), nhel, den(237))
    call cont_QA(nsync, wf18(:,8), wf8(:,42), A(:,143), n3(:,292), t3x144(:,:,143), nhel, den(239))
    call cont_QA(nsync, wf18(:,8), wf8(:,40), A(:,144), n3(:,293), t3x144(:,:,144), nhel, den(237))
    call cont_QA(nsync, wf6(:,16), wf24(:,22), A(:,145), n3(:,294), t3x144(:,:,145), nhel, den(241))
    call cont_QA(nsync, wf6(:,16), wf24(:,23), A(:,146), n3(:,295), t3x144(:,:,146), nhel, den(243))
    call cont_QA(nsync, wf6(:,16), wf24(:,24), A(:,147), n3(:,296), t3x144(:,:,147), nhel, den(245))
    call cont_QA(nsync, wf6(:,16), wf24(:,23), A(:,148), n3(:,297), t3x144(:,:,148), nhel, den(243))
    call cont_QA(nsync, wf18(:,12), wf8(:,44), A(:,149), n3(:,298), t3x144(:,:,149), nhel, den(247))
    call cont_QA(nsync, wf18(:,12), wf8(:,46), A(:,150), n3(:,299), t3x144(:,:,150), nhel, den(249))
    call cont_QA(nsync, wf18(:,12), wf8(:,48), A(:,151), n3(:,300), t3x144(:,:,151), nhel, den(251))
    call cont_QA(nsync, wf18(:,12), wf8(:,46), A(:,152), n3(:,301), t3x144(:,:,152), nhel, den(249))
    call cont_SS(nsync, wf12(:,5), wf12(:,60), A(:,153), n3(:,302), t3x144(:,:,153), nhel, den(253))
    call cont_VV(nsync, wf12(:,2), wf12(:,62), A(:,154), n3(:,303), t3x144(:,:,154), nhel, den(255))
    call cont_VV(nsync, wf12(:,6), wf12(:,64), A(:,155), n3(:,304), t3x144(:,:,155), nhel, den(258))
    call cont_SS(nsync, wf12(:,9), wf12(:,65), A(:,156), n3(:,305), t3x144(:,:,156), nhel, den(261))
    call cont_QA(nsync, wf18(:,9), wf8(:,38), A(:,157), n3(:,306), t3x144(:,:,157), nhel, den(262))
    call cont_QA(nsync, wf18(:,9), wf8(:,40), A(:,158), n3(:,307), t3x144(:,:,158), nhel, den(263))
    call cont_QA(nsync, wf18(:,9), wf8(:,42), A(:,159), n3(:,308), t3x144(:,:,159), nhel, den(264))
    call cont_QA(nsync, wf18(:,9), wf8(:,40), A(:,160), n3(:,309), t3x144(:,:,160), nhel, den(263))
    call cont_QA(nsync, wf18(:,13), wf8(:,44), A(:,161), n3(:,310), t3x144(:,:,161), nhel, den(265))
    call cont_QA(nsync, wf18(:,13), wf8(:,46), A(:,162), n3(:,311), t3x144(:,:,162), nhel, den(266))
    call cont_QA(nsync, wf18(:,13), wf8(:,48), A(:,163), n3(:,312), t3x144(:,:,163), nhel, den(267))
    call cont_QA(nsync, wf18(:,13), wf8(:,46), A(:,164), n3(:,313), t3x144(:,:,164), nhel, den(266))
    call cont_SS(nsync, wf12(:,9), wf12(:,66), A(:,165), n3(:,314), t3x144(:,:,165), nhel, den(269))
    call cont_VV(nsync, wf12(:,6), wf12(:,68), A(:,166), n3(:,315), t3x144(:,:,166), nhel, den(271))
    call cont_QA(nsync, wf18(:,14), wf8(:,44), A(:,167), n3(:,316), t3x144(:,:,167), nhel, den(272))
    call cont_QA(nsync, wf18(:,14), wf8(:,46), A(:,168), n3(:,317), t3x144(:,:,168), nhel, den(273))
    call cont_QA(nsync, wf18(:,14), wf8(:,48), A(:,169), n3(:,318), t3x144(:,:,169), nhel, den(274))
    call cont_QA(nsync, wf18(:,14), wf8(:,46), A(:,170), n3(:,319), t3x144(:,:,170), nhel, den(273))
    call cont_QA(nsync, wf18(:,11), wf8(:,37), A(:,171), n3(:,320), t3x144(:,:,171), nhel, den(275))
    call cont_QA(nsync, wf18(:,11), wf8(:,39), A(:,172), n3(:,321), t3x144(:,:,172), nhel, den(276))
    call cont_QA(nsync, wf18(:,11), wf8(:,41), A(:,173), n3(:,322), t3x144(:,:,173), nhel, den(277))
    call cont_QA(nsync, wf18(:,11), wf8(:,39), A(:,174), n3(:,323), t3x144(:,:,174), nhel, den(276))
    call cont_SS(nsync, wf12(:,19), wf12(:,59), A(:,175), n3(:,324), t3x144(:,:,175), nhel, den(278))
    call cont_VV(nsync, wf12(:,69), wf12(:,70), A(:,176), n3(:,325), t3x144(:,:,176), nhel, den(281))
    call cont_VV(nsync, wf12(:,17), wf12(:,58), A(:,177), n3(:,326), t3x144(:,:,177), nhel, den(282))
    call cont_VV(nsync, wf12(:,69), wf12(:,70), A(:,178), n3(:,327), t3x144(:,:,178), nhel, den(281))
    call cont_SS(nsync, wf12(:,35), wf12(:,53), A(:,179), n3(:,328), t3x144(:,:,179), nhel, den(283))
    call cont_VV(nsync, wf12(:,71), wf12(:,72), A(:,180), n3(:,329), t3x144(:,:,180), nhel, den(286))
    call cont_VV(nsync, wf12(:,33), wf12(:,52), A(:,181), n3(:,330), t3x144(:,:,181), nhel, den(287))
    call cont_VV(nsync, wf12(:,71), wf12(:,72), A(:,182), n3(:,331), t3x144(:,:,182), nhel, den(286))
    call cont_SS(nsync, wf12(:,35), wf12(:,56), A(:,183), n3(:,332), t3x144(:,:,183), nhel, den(288))
    call cont_VV(nsync, wf12(:,72), wf12(:,73), A(:,184), n3(:,333), t3x144(:,:,184), nhel, den(290))
    call cont_VV(nsync, wf12(:,33), wf12(:,55), A(:,185), n3(:,334), t3x144(:,:,185), nhel, den(291))
    call cont_VV(nsync, wf12(:,72), wf12(:,73), A(:,186), n3(:,335), t3x144(:,:,186), nhel, den(290))
    call cont_SS(nsync, wf12(:,22), wf12(:,59), A(:,187), n3(:,336), t3x144(:,:,187), nhel, den(292))
    call cont_VV(nsync, wf12(:,69), wf12(:,74), A(:,188), n3(:,337), t3x144(:,:,188), nhel, den(295))
    call cont_VV(nsync, wf12(:,21), wf12(:,57), A(:,189), n3(:,338), t3x144(:,:,189), nhel, den(296))
    call cont_VV(nsync, wf12(:,69), wf12(:,74), A(:,190), n3(:,339), t3x144(:,:,190), nhel, den(295))
    call cont_SS(nsync, wf12(:,13), wf12(:,65), A(:,191), n3(:,340), t3x144(:,:,191), nhel, den(297))
    call cont_VV(nsync, wf12(:,75), wf12(:,76), A(:,192), n3(:,341), t3x144(:,:,192), nhel, den(300))
    call cont_VV(nsync, wf12(:,11), wf12(:,64), A(:,193), n3(:,342), t3x144(:,:,193), nhel, den(301))
    call cont_VV(nsync, wf12(:,75), wf12(:,76), A(:,194), n3(:,343), t3x144(:,:,194), nhel, den(300))
    call cont_SS(nsync, wf12(:,41), wf12(:,47), A(:,195), n3(:,344), t3x144(:,:,195), nhel, den(302))
    call cont_VV(nsync, wf12(:,77), wf12(:,78), A(:,196), n3(:,345), t3x144(:,:,196), nhel, den(305))
    call cont_VV(nsync, wf12(:,39), wf12(:,46), A(:,197), n3(:,346), t3x144(:,:,197), nhel, den(306))
    call cont_VV(nsync, wf12(:,77), wf12(:,78), A(:,198), n3(:,347), t3x144(:,:,198), nhel, den(305))
    call cont_SS(nsync, wf12(:,13), wf12(:,66), A(:,199), n3(:,348), t3x144(:,:,199), nhel, den(307))
    call cont_VV(nsync, wf12(:,76), wf12(:,79), A(:,200), n3(:,349), t3x144(:,:,200), nhel, den(309))
    call cont_VV(nsync, wf12(:,11), wf12(:,68), A(:,201), n3(:,350), t3x144(:,:,201), nhel, den(310))
    call cont_VV(nsync, wf12(:,76), wf12(:,79), A(:,202), n3(:,351), t3x144(:,:,202), nhel, den(309))
    call cont_SS(nsync, wf12(:,42), wf12(:,47), A(:,203), n3(:,352), t3x144(:,:,203), nhel, den(311))
    call cont_VV(nsync, wf12(:,77), wf12(:,80), A(:,204), n3(:,353), t3x144(:,:,204), nhel, den(314))
    call cont_VV(nsync, wf12(:,44), wf12(:,45), A(:,205), n3(:,354), t3x144(:,:,205), nhel, den(315))
    call cont_VV(nsync, wf12(:,77), wf12(:,80), A(:,206), n3(:,355), t3x144(:,:,206), nhel, den(314))
    call cont_SS(nsync, wf12(:,41), wf12(:,50), A(:,207), n3(:,356), t3x144(:,:,207), nhel, den(316))
    call cont_VV(nsync, wf12(:,78), wf12(:,81), A(:,208), n3(:,357), t3x144(:,:,208), nhel, den(318))
    call cont_VV(nsync, wf12(:,39), wf12(:,49), A(:,209), n3(:,358), t3x144(:,:,209), nhel, den(319))
    call cont_VV(nsync, wf12(:,78), wf12(:,81), A(:,210), n3(:,359), t3x144(:,:,210), nhel, den(318))
    call cont_SS(nsync, wf12(:,19), wf12(:,60), A(:,211), n3(:,360), t3x144(:,:,211), nhel, den(320))
    call cont_VV(nsync, wf12(:,70), wf12(:,82), A(:,212), n3(:,361), t3x144(:,:,212), nhel, den(322))
    call cont_VV(nsync, wf12(:,17), wf12(:,62), A(:,213), n3(:,362), t3x144(:,:,213), nhel, den(323))
    call cont_VV(nsync, wf12(:,70), wf12(:,82), A(:,214), n3(:,363), t3x144(:,:,214), nhel, den(322))
    call cont_SS(nsync, wf12(:,22), wf12(:,60), A(:,215), n3(:,364), t3x144(:,:,215), nhel, den(324))
    call cont_VV(nsync, wf12(:,74), wf12(:,82), A(:,216), n3(:,365), t3x144(:,:,216), nhel, den(325))
    call cont_VV(nsync, wf12(:,20), wf12(:,62), A(:,217), n3(:,366), t3x144(:,:,217), nhel, den(326))
    call cont_VV(nsync, wf12(:,74), wf12(:,82), A(:,218), n3(:,367), t3x144(:,:,218), nhel, den(325))
    call cont_SS(nsync, wf12(:,42), wf12(:,50), A(:,219), n3(:,368), t3x144(:,:,219), nhel, den(327))
    call cont_VV(nsync, wf12(:,80), wf12(:,81), A(:,220), n3(:,369), t3x144(:,:,220), nhel, den(328))
    call cont_VV(nsync, wf12(:,44), wf12(:,48), A(:,221), n3(:,370), t3x144(:,:,221), nhel, den(329))
    call cont_VV(nsync, wf12(:,80), wf12(:,81), A(:,222), n3(:,371), t3x144(:,:,222), nhel, den(328))
    call cont_SS(nsync, wf12(:,16), wf12(:,65), A(:,223), n3(:,372), t3x144(:,:,223), nhel, den(330))
    call cont_VV(nsync, wf12(:,75), wf12(:,83), A(:,224), n3(:,373), t3x144(:,:,224), nhel, den(333))
    call cont_VV(nsync, wf12(:,15), wf12(:,63), A(:,225), n3(:,374), t3x144(:,:,225), nhel, den(334))
    call cont_VV(nsync, wf12(:,75), wf12(:,83), A(:,226), n3(:,375), t3x144(:,:,226), nhel, den(333))
    call cont_SS(nsync, wf12(:,36), wf12(:,53), A(:,227), n3(:,376), t3x144(:,:,227), nhel, den(335))
    call cont_VV(nsync, wf12(:,71), wf12(:,84), A(:,228), n3(:,377), t3x144(:,:,228), nhel, den(338))
    call cont_VV(nsync, wf12(:,38), wf12(:,51), A(:,229), n3(:,378), t3x144(:,:,229), nhel, den(339))
    call cont_VV(nsync, wf12(:,71), wf12(:,84), A(:,230), n3(:,379), t3x144(:,:,230), nhel, den(338))
    call cont_SS(nsync, wf12(:,16), wf12(:,66), A(:,231), n3(:,380), t3x144(:,:,231), nhel, den(340))
    call cont_VV(nsync, wf12(:,79), wf12(:,83), A(:,232), n3(:,381), t3x144(:,:,232), nhel, den(341))
    call cont_VV(nsync, wf12(:,14), wf12(:,68), A(:,233), n3(:,382), t3x144(:,:,233), nhel, den(342))
    call cont_VV(nsync, wf12(:,79), wf12(:,83), A(:,234), n3(:,383), t3x144(:,:,234), nhel, den(341))
    call cont_SS(nsync, wf12(:,36), wf12(:,56), A(:,235), n3(:,384), t3x144(:,:,235), nhel, den(343))
    call cont_VV(nsync, wf12(:,73), wf12(:,84), A(:,236), n3(:,385), t3x144(:,:,236), nhel, den(344))
    call cont_VV(nsync, wf12(:,38), wf12(:,54), A(:,237), n3(:,386), t3x144(:,:,237), nhel, den(345))
    call cont_VV(nsync, wf12(:,73), wf12(:,84), A(:,238), n3(:,387), t3x144(:,:,238), nhel, den(344))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(4) ! M1helarray(4,144)
  integer :: empty(0)

  M1(1) = (A(j,56)%j+A(j,62)%j+A(j,66)%j+A(j,70)%j+A(j,78)%j+A(j,82)%j+A(j,96)%j+A(j,100)%j+A(j,106)%j+A(j,110)%j+A(j,116)%j &
       +A(j,122)%j+A(j,180)%j+A(j,184)%j+A(j,196)%j+A(j,204)%j+A(j,208)%j+A(j,220)%j+A(j,228)%j+A(j,236)%j)*f(1)+(A(j,57)%j &
       +A(j,63)%j+A(j,67)%j+A(j,71)%j+A(j,79)%j+A(j,83)%j+A(j,97)%j+A(j,101)%j+A(j,107)%j+A(j,111)%j+A(j,117)%j+A(j,123)%j &
       +A(j,181)%j+A(j,185)%j+A(j,197)%j+A(j,205)%j+A(j,209)%j+A(j,221)%j+A(j,229)%j+A(j,237)%j)*f(2)+(A(j,51)%j+A(j,53)%j)*f(4) &
       +A(j,2)%j*f(5)+(A(j,87)%j+A(j,91)%j+A(j,127)%j+A(j,131)%j)*f(6)+A(j,49)%j*f(7)+(-A(j,88)%j-A(j,92)%j-A(j,128)%j &
       -A(j,132)%j)*f(8)+(-A(j,59)%j-A(j,60)%j-A(j,73)%j-A(j,74)%j-A(j,75)%j-A(j,76)%j-A(j,85)%j-A(j,86)%j-A(j,89)%j-A(j,93)%j &
       -A(j,103)%j-A(j,104)%j-A(j,113)%j-A(j,114)%j-A(j,119)%j-A(j,120)%j-A(j,125)%j-A(j,126)%j-A(j,129)%j-A(j,133)%j)*f(9)+( &
       -A(j,55)%j-A(j,61)%j-A(j,65)%j-A(j,69)%j-A(j,77)%j-A(j,81)%j-A(j,95)%j-A(j,99)%j-A(j,105)%j-A(j,109)%j-A(j,115)%j &
       -A(j,121)%j-A(j,179)%j-A(j,183)%j-A(j,195)%j-A(j,203)%j-A(j,207)%j-A(j,219)%j-A(j,227)%j-A(j,235)%j)*f(11)+(-A(j,50)%j &
       -A(j,52)%j-A(j,54)%j)*f(12)
  M1(2) = ((-A(j,12)%j-A(j,16)%j-A(j,22)%j-A(j,26)%j-A(j,32)%j-A(j,38)%j-A(j,138)%j-A(j,144)%j-A(j,148)%j-A(j,152)%j-A(j,160)%j &
       -A(j,164)%j-A(j,178)%j-A(j,190)%j-A(j,194)%j-A(j,202)%j-A(j,214)%j-A(j,218)%j-A(j,226)%j-A(j,234)%j)*f(3))/2._/**/REALKIND &
       +((-A(j,58)%j-A(j,64)%j-A(j,68)%j-A(j,72)%j-A(j,80)%j-A(j,84)%j-A(j,98)%j-A(j,102)%j-A(j,108)%j-A(j,112)%j-A(j,118)%j &
       -A(j,124)%j-A(j,182)%j-A(j,186)%j-A(j,198)%j-A(j,206)%j-A(j,210)%j-A(j,222)%j-A(j,230)%j-A(j,238)%j)*f(3))/6._/**/REALKIND &
       +((A(j,90)%j+A(j,94)%j+A(j,130)%j+A(j,134)%j)*f(10))/6._/**/REALKIND+((A(j,44)%j+A(j,48)%j+A(j,170)%j &
       +A(j,174)%j)*f(10))/2._/**/REALKIND
  M1(3) = (-A(j,10)%j-A(j,14)%j-A(j,20)%j-A(j,24)%j-A(j,30)%j-A(j,36)%j-A(j,136)%j-A(j,142)%j-A(j,146)%j-A(j,150)%j-A(j,158)%j &
       -A(j,162)%j-A(j,176)%j-A(j,188)%j-A(j,192)%j-A(j,200)%j-A(j,212)%j-A(j,216)%j-A(j,224)%j-A(j,232)%j)*f(1)+(-A(j,11)%j &
       -A(j,15)%j-A(j,21)%j-A(j,25)%j-A(j,31)%j-A(j,37)%j-A(j,137)%j-A(j,143)%j-A(j,147)%j-A(j,151)%j-A(j,159)%j-A(j,163)%j &
       -A(j,177)%j-A(j,189)%j-A(j,193)%j-A(j,201)%j-A(j,213)%j-A(j,217)%j-A(j,225)%j-A(j,233)%j)*f(2)+(-A(j,5)%j-A(j,7)%j)*f(4) &
       -A(j,1)%j*f(5)+(-A(j,41)%j-A(j,45)%j-A(j,167)%j-A(j,171)%j)*f(6)-A(j,3)%j*f(7)+(A(j,42)%j+A(j,46)%j+A(j,168)%j &
       +A(j,172)%j)*f(8)+(A(j,17)%j+A(j,18)%j+A(j,27)%j+A(j,28)%j+A(j,33)%j+A(j,34)%j+A(j,39)%j+A(j,40)%j+A(j,43)%j+A(j,47)%j &
       +A(j,139)%j+A(j,140)%j+A(j,153)%j+A(j,154)%j+A(j,155)%j+A(j,156)%j+A(j,165)%j+A(j,166)%j+A(j,169)%j+A(j,173)%j)*f(9) &
       +(A(j,9)%j+A(j,13)%j+A(j,19)%j+A(j,23)%j+A(j,29)%j+A(j,35)%j+A(j,135)%j+A(j,141)%j+A(j,145)%j+A(j,149)%j+A(j,157)%j &
       +A(j,161)%j+A(j,175)%j+A(j,187)%j+A(j,191)%j+A(j,199)%j+A(j,211)%j+A(j,215)%j+A(j,223)%j+A(j,231)%j)*f(11)+(A(j,4)%j &
       +A(j,6)%j+A(j,8)%j)*f(12)
  M1(4) = ((A(j,12)%j+A(j,16)%j+A(j,22)%j+A(j,26)%j+A(j,32)%j+A(j,38)%j+A(j,138)%j+A(j,144)%j+A(j,148)%j+A(j,152)%j+A(j,160)%j &
       +A(j,164)%j+A(j,178)%j+A(j,190)%j+A(j,194)%j+A(j,202)%j+A(j,214)%j+A(j,218)%j+A(j,226)%j+A(j,234)%j)*f(3))/6._/**/REALKIND &
       +((A(j,58)%j+A(j,64)%j+A(j,68)%j+A(j,72)%j+A(j,80)%j+A(j,84)%j+A(j,98)%j+A(j,102)%j+A(j,108)%j+A(j,112)%j+A(j,118)%j &
       +A(j,124)%j+A(j,182)%j+A(j,186)%j+A(j,198)%j+A(j,206)%j+A(j,210)%j+A(j,222)%j+A(j,230)%j+A(j,238)%j)*f(3))/2._/**/REALKIND &
       +((-A(j,90)%j-A(j,94)%j-A(j,130)%j-A(j,134)%j)*f(10))/2._/**/REALKIND+((-A(j,44)%j-A(j,48)%j-A(j,170)%j &
       -A(j,174)%j)*f(10))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(4)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 4*extcomb
    do i = 1, 4
      do j = 1, 4
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(4), M2(4)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 4*extcomb
    do i = 1, 4
      do j = 1, 4
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvvj_ew_bbbxbxzz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(4)
  complex(REALKIND), intent(in)  :: M2(4)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 4
    do j = 1, 4
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_ppvvj_ew_bbbxbxzz_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(4,144)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    23, [ (k, k = 0, 23-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_ppvvj_ew_bbbxbxzz_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(6)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(6)
  do J = 1, 6
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 6,extcombs, M2munu)
  do J = 1, 6
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_ppvvj_ew_bbbxbxzz_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_ppvvj_ew_bbbxbxzz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_ppvvj_ew_bbbxbxzz_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_ppvvj_ew_bbbxbxzz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_ppvvj_ew_bbbxbxzz_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_ppvvj_ew_bbbxbxzz_1_/**/REALKIND
