
module ol_vamp_1_ppvvj2_zzggg_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_zzggg_4.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_zzggg_4.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_zzggg_4_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_zzggg_4_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,27) :: G0
  complex(REALKIND), dimension(4,5,4,128) :: G1
  complex(REALKIND), dimension(4,15,4,294) :: G2
  complex(REALKIND), dimension(4,35,4,360) :: G3
  complex(REALKIND), dimension(4,70,4,192) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,12,72))
    allocate(G4tensorhel(70,84,72))
    allocate(G5tensorhel(126,96,72))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,7),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,3),gZu)
  call loop_A_Q(G1(:,:,:,3),Q(:,14),MT,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-4),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,30),MT,G3(:,:,:,1))
  call loop_AZ_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,-4),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,28),MT,G2(:,:,:,5))
  call loop_QS_A(G2(:,:,:,5),wf(:,7),G2(:,:,:,6),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,6),Q(:,31),MT,G3tensor(:,2))
  call loop_QZ_A(G1(:,:,:,4),wf(:,-1),G1(:,:,:,6),gZu)
  call loop_Q_A(G1(:,:,:,6),Q(:,14),MT,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,30),MT,G3(:,:,:,3))
  call loop_QZ_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,31),MT,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,9))
  call loop_AS_Q(G2(:,:,:,9),wf(:,7),G2(:,:,:,10),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,31),MB,G3tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,7),wf(:,-1),G1(:,:,:,9),gZd)
  call loop_A_Q(G1(:,:,:,9),Q(:,14),MB,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-4),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,30),MB,G3(:,:,:,5))
  call loop_AZ_Q(G3(:,:,:,5),wf(:,0),G3(:,:,:,6),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,31),MB,G4tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,10))
  call loop_QV_A(G1(:,:,:,10),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,28),MB,G2(:,:,:,13))
  call loop_QS_A(G2(:,:,:,13),wf(:,7),G2(:,:,:,14),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),MB,G3tensor(:,4))
  call loop_QZ_A(G1(:,:,:,10),wf(:,-1),G1(:,:,:,12),gZd)
  call loop_Q_A(G1(:,:,:,12),Q(:,14),MB,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-4),G2(:,:,:,16))
  call loop_Q_A(G2(:,:,:,16),Q(:,30),MB,G3(:,:,:,7))
  call loop_QZ_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,31),MB,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,8),MT,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,3),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,28),MT,G2(:,:,:,17))
  call loop_QS_A(G2(:,:,:,17),wf(:,7),G2(:,:,:,18),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,31),MT,G3tensor(:,5))
  call loop_QV_A(G1(:,:,:,13),wf(:,-2),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,12),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,28),MT,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,7),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,31),MT,G4tensor(:,5))
  call loop_QZ_A(G2(:,:,:,19),wf(:,-1),G2(:,:,:,21),gZu)
  call loop_Q_A(G2(:,:,:,21),Q(:,14),MT,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,-4),G3(:,:,:,12))
  call loop_Q_A(G3(:,:,:,12),Q(:,30),MT,G4(:,:,:,1))
  call loop_QZ_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,31),MT,G5tensor(:,1))
  call loop_QZ_A(G1(:,:,:,13),wf(:,-1),G1(:,:,:,16),gZu)
  call loop_Q_A(G1(:,:,:,16),Q(:,10),MT,G2(:,:,:,22))
  call loop_QV_A(G2(:,:,:,22),wf(:,3),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,30),MT,G3(:,:,:,13))
  call loop_QZ_A(G3(:,:,:,13),wf(:,0),G3(:,:,:,14),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,14),Q(:,31),MT,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,22),wf(:,-2),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,14),MT,G3(:,:,:,15))
  call loop_QV_A(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_Q_A(G3(:,:,:,16),Q(:,30),MT,G4(:,:,:,3))
  call loop_QZ_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,31),MT,G5tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,8),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,28),MT,G2(:,:,:,25))
  call loop_AS_Q(G2(:,:,:,25),wf(:,7),G2(:,:,:,26),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,31),MT,G3tensor(:,6))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-2),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,12),MT,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,28),MT,G3(:,:,:,17))
  call loop_AS_Q(G3(:,:,:,17),wf(:,7),G3(:,:,:,18),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),MT,G4tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,27),wf(:,-1),G2(:,:,:,29),gZu)
  call loop_A_Q(G2(:,:,:,29),Q(:,14),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-4),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,30),MT,G4(:,:,:,5))
  call loop_AZ_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),MT,G5tensor(:,3))
  call loop_AZ_Q(G1(:,:,:,17),wf(:,-1),G1(:,:,:,20),gZu)
  call loop_A_Q(G1(:,:,:,20),Q(:,10),MT,G2(:,:,:,30))
  call loop_AV_Q(G2(:,:,:,30),wf(:,3),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,30),MT,G3(:,:,:,21))
  call loop_AZ_Q(G3(:,:,:,21),wf(:,0),G3(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,31),MT,G4tensor(:,8))
  call loop_AV_Q(G2(:,:,:,30),wf(:,-2),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,14),MT,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),MT,G4(:,:,:,7))
  call loop_AZ_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),MT,G5tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),MB,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,3),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,28),MB,G2(:,:,:,33))
  call loop_QS_A(G2(:,:,:,33),wf(:,7),G2(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),MB,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,21),wf(:,-2),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,12),MB,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,28),MB,G3(:,:,:,25))
  call loop_QS_A(G3(:,:,:,25),wf(:,7),G3(:,:,:,26),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),MB,G4tensor(:,9))
  call loop_QZ_A(G2(:,:,:,35),wf(:,-1),G2(:,:,:,37),gZd)
  call loop_Q_A(G2(:,:,:,37),Q(:,14),MB,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-4),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,30),MB,G4(:,:,:,9))
  call loop_QZ_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,31),MB,G5tensor(:,5))
  call loop_QZ_A(G1(:,:,:,21),wf(:,-1),G1(:,:,:,24),gZd)
  call loop_Q_A(G1(:,:,:,24),Q(:,10),MB,G2(:,:,:,38))
  call loop_QV_A(G2(:,:,:,38),wf(:,3),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,30),MB,G3(:,:,:,29))
  call loop_QZ_A(G3(:,:,:,29),wf(:,0),G3(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,31),MB,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,38),wf(:,-2),G2(:,:,:,40))
  call loop_Q_A(G2(:,:,:,40),Q(:,14),MB,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-4),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,30),MB,G4(:,:,:,11))
  call loop_QZ_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,31),MB,G5tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,8),MB,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,3),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,28),MB,G2(:,:,:,41))
  call loop_AS_Q(G2(:,:,:,41),wf(:,7),G2(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,31),MB,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-2),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,12),MB,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,28),MB,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,7),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,31),MB,G4tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,43),wf(:,-1),G2(:,:,:,45),gZd)
  call loop_A_Q(G2(:,:,:,45),Q(:,14),MB,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,-4),G3(:,:,:,36))
  call loop_A_Q(G3(:,:,:,36),Q(:,30),MB,G4(:,:,:,13))
  call loop_AZ_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,31),MB,G5tensor(:,7))
  call loop_AZ_Q(G1(:,:,:,25),wf(:,-1),G1(:,:,:,28),gZd)
  call loop_A_Q(G1(:,:,:,28),Q(:,10),MB,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,3),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,30),MB,G3(:,:,:,37))
  call loop_AZ_Q(G3(:,:,:,37),wf(:,0),G3(:,:,:,38),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,31),MB,G4tensor(:,12))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,14),MB,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,30),MB,G4(:,:,:,15))
  call loop_AZ_Q(G4(:,:,:,15),wf(:,0),G4(:,:,:,16),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,31),MB,G5tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,4),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,5),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,28),MT,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,7),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,31),MT,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,29),wf(:,-3),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,12),MT,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_Q_A(G2(:,:,:,52),Q(:,28),MT,G3(:,:,:,41))
  call loop_QS_A(G3(:,:,:,41),wf(:,7),G3(:,:,:,42),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,31),MT,G4tensor(:,13))
  call loop_QZ_A(G2(:,:,:,51),wf(:,-1),G2(:,:,:,53),gZu)
  call loop_Q_A(G2(:,:,:,53),Q(:,14),MT,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,-4),G3(:,:,:,44))
  call loop_Q_A(G3(:,:,:,44),Q(:,30),MT,G4(:,:,:,17))
  call loop_QZ_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),MT,G5tensor(:,9))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,20),MT,G2(:,:,:,54))
  call loop_QV_A(G2(:,:,:,54),wf(:,-3),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,28),MT,G3(:,:,:,45))
  call loop_QS_A(G3(:,:,:,45),wf(:,7),G3(:,:,:,46),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,31),MT,G4tensor(:,14))
  call loop_QZ_A(G2(:,:,:,54),wf(:,-1),G2(:,:,:,56),gZu)
  call loop_Q_A(G2(:,:,:,56),Q(:,22),MT,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-3),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,30),MT,G4(:,:,:,19))
  call loop_QZ_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),MT,G5tensor(:,10))
  call loop_QZ_A(G1(:,:,:,29),wf(:,-1),G1(:,:,:,33),gZu)
  call loop_Q_A(G1(:,:,:,33),Q(:,6),MT,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,5),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,30),MT,G3(:,:,:,49))
  call loop_QZ_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,31),MT,G4tensor(:,15))
  call loop_QV_A(G2(:,:,:,57),wf(:,-4),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,22),MT,G3(:,:,:,51))
  call loop_QV_A(G3(:,:,:,51),wf(:,-3),G3(:,:,:,52))
  call loop_Q_A(G3(:,:,:,52),Q(:,30),MT,G4(:,:,:,21))
  call loop_QZ_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),MT,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,57),wf(:,-3),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,14),MT,G3(:,:,:,53))
  call loop_QV_A(G3(:,:,:,53),wf(:,-4),G3(:,:,:,54))
  call loop_Q_A(G3(:,:,:,54),Q(:,30),MT,G4(:,:,:,23))
  call loop_QZ_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),MT,G5tensor(:,12))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,4),MT,G1(:,:,:,34))
  call loop_AV_Q(G1(:,:,:,34),wf(:,5),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,28),MT,G2(:,:,:,61))
  call loop_AS_Q(G2(:,:,:,61),wf(:,7),G2(:,:,:,62),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,31),MT,G3tensor(:,10))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-3),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,12),MT,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,28),MT,G3(:,:,:,55))
  call loop_AS_Q(G3(:,:,:,55),wf(:,7),G3(:,:,:,56),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,31),MT,G4tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,-1),G2(:,:,:,65),gZu)
  call loop_A_Q(G2(:,:,:,65),Q(:,14),MT,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-4),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,30),MT,G4(:,:,:,25))
  call loop_AZ_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,31),MT,G5tensor(:,13))
  call loop_AV_Q(G1(:,:,:,34),wf(:,-4),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,20),MT,G2(:,:,:,66))
  call loop_AV_Q(G2(:,:,:,66),wf(:,-3),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,28),MT,G3(:,:,:,59))
  call loop_AS_Q(G3(:,:,:,59),wf(:,7),G3(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,31),MT,G4tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,66),wf(:,-1),G2(:,:,:,68),gZu)
  call loop_A_Q(G2(:,:,:,68),Q(:,22),MT,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-3),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,30),MT,G4(:,:,:,27))
  call loop_AZ_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,31),MT,G5tensor(:,14))
  call loop_AZ_Q(G1(:,:,:,34),wf(:,-1),G1(:,:,:,38),gZu)
  call loop_A_Q(G1(:,:,:,38),Q(:,6),MT,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,5),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,30),MT,G3(:,:,:,63))
  call loop_AZ_Q(G3(:,:,:,63),wf(:,0),G3(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,64),Q(:,31),MT,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,22),MT,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,-3),G3(:,:,:,66))
  call loop_A_Q(G3(:,:,:,66),Q(:,30),MT,G4(:,:,:,29))
  call loop_AZ_Q(G4(:,:,:,29),wf(:,0),G4(:,:,:,30),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,31),MT,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-3),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,14),MT,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-4),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,30),MT,G4(:,:,:,31))
  call loop_AZ_Q(G4(:,:,:,31),wf(:,0),G4(:,:,:,32),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,31),MT,G5tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,4),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,5),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,28),MB,G2(:,:,:,73))
  call loop_QS_A(G2(:,:,:,73),wf(:,7),G2(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,74),Q(:,31),MB,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,39),wf(:,-3),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,12),MB,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,28),MB,G3(:,:,:,69))
  call loop_QS_A(G3(:,:,:,69),wf(:,7),G3(:,:,:,70),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,31),MB,G4tensor(:,19))
  call loop_QZ_A(G2(:,:,:,75),wf(:,-1),G2(:,:,:,77),gZd)
  call loop_Q_A(G2(:,:,:,77),Q(:,14),MB,G3(:,:,:,71))
  call loop_QV_A(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_Q_A(G3(:,:,:,72),Q(:,30),MB,G4(:,:,:,33))
  call loop_QZ_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,31),MB,G5tensor(:,17))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,20),MB,G2(:,:,:,78))
  call loop_QV_A(G2(:,:,:,78),wf(:,-3),G2(:,:,:,79))
  call loop_Q_A(G2(:,:,:,79),Q(:,28),MB,G3(:,:,:,73))
  call loop_QS_A(G3(:,:,:,73),wf(:,7),G3(:,:,:,74),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,31),MB,G4tensor(:,20))
  call loop_QZ_A(G2(:,:,:,78),wf(:,-1),G2(:,:,:,80),gZd)
  call loop_Q_A(G2(:,:,:,80),Q(:,22),MB,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-3),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,30),MB,G4(:,:,:,35))
  call loop_QZ_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,31),MB,G5tensor(:,18))
  call loop_QZ_A(G1(:,:,:,39),wf(:,-1),G1(:,:,:,43),gZd)
  call loop_Q_A(G1(:,:,:,43),Q(:,6),MB,G2(:,:,:,81))
  call loop_QV_A(G2(:,:,:,81),wf(:,5),G2(:,:,:,82))
  call loop_Q_A(G2(:,:,:,82),Q(:,30),MB,G3(:,:,:,77))
  call loop_QZ_A(G3(:,:,:,77),wf(:,0),G3(:,:,:,78),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,31),MB,G4tensor(:,21))
  call loop_QV_A(G2(:,:,:,81),wf(:,-4),G2(:,:,:,83))
  call loop_Q_A(G2(:,:,:,83),Q(:,22),MB,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),MB,G4(:,:,:,37))
  call loop_QZ_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),MB,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,81),wf(:,-3),G2(:,:,:,84))
  call loop_Q_A(G2(:,:,:,84),Q(:,14),MB,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-4),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,30),MB,G4(:,:,:,39))
  call loop_QZ_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),MB,G5tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,4),MB,G1(:,:,:,44))
  call loop_AV_Q(G1(:,:,:,44),wf(:,5),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,28),MB,G2(:,:,:,85))
  call loop_AS_Q(G2(:,:,:,85),wf(:,7),G2(:,:,:,86),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,31),MB,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-3),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,12),MB,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-4),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,28),MB,G3(:,:,:,83))
  call loop_AS_Q(G3(:,:,:,83),wf(:,7),G3(:,:,:,84),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,84),Q(:,31),MB,G4tensor(:,22))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,-1),G2(:,:,:,89),gZd)
  call loop_A_Q(G2(:,:,:,89),Q(:,14),MB,G3(:,:,:,85))
  call loop_AV_Q(G3(:,:,:,85),wf(:,-4),G3(:,:,:,86))
  call loop_A_Q(G3(:,:,:,86),Q(:,30),MB,G4(:,:,:,41))
  call loop_AZ_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,31),MB,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,44),wf(:,-4),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,20),MB,G2(:,:,:,90))
  call loop_AV_Q(G2(:,:,:,90),wf(:,-3),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,28),MB,G3(:,:,:,87))
  call loop_AS_Q(G3(:,:,:,87),wf(:,7),G3(:,:,:,88),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,31),MB,G4tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,90),wf(:,-1),G2(:,:,:,92),gZd)
  call loop_A_Q(G2(:,:,:,92),Q(:,22),MB,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-3),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,30),MB,G4(:,:,:,43))
  call loop_AZ_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,31),MB,G5tensor(:,22))
  call loop_AZ_Q(G1(:,:,:,44),wf(:,-1),G1(:,:,:,48),gZd)
  call loop_A_Q(G1(:,:,:,48),Q(:,6),MB,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,5),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,30),MB,G3(:,:,:,91))
  call loop_AZ_Q(G3(:,:,:,91),wf(:,0),G3(:,:,:,92),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,92),Q(:,31),MB,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,22),MB,G3(:,:,:,93))
  call loop_AV_Q(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_A_Q(G3(:,:,:,94),Q(:,30),MB,G4(:,:,:,45))
  call loop_AZ_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,31),MB,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-3),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,14),MB,G3(:,:,:,95))
  call loop_AV_Q(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_A_Q(G3(:,:,:,96),Q(:,30),MB,G4(:,:,:,47))
  call loop_AZ_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,31),MB,G5tensor(:,24))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,2),ZERO,G1(:,:,:,49))
  call loop_AV_Q(G1(:,:,:,49),wf(:,1),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,14),ZERO,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,30),ZERO,G3(:,:,:,97))
  call loop_AZ_Q(G3(:,:,:,97),wf(:,0),G3(:,:,:,98),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,98),Q(:,31),ZERO,G4tensor(:,25))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-4),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,18),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,1),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,30),ZERO,G3(:,:,:,99))
  call loop_AZ_Q(G3(:,:,:,99),wf(:,0),G3(:,:,:,100),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,100),Q(:,31),ZERO,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-3),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,26),ZERO,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-2),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,30),ZERO,G4(:,:,:,49))
  call loop_AZ_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),ZERO,G5tensor(:,25))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-2),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,22),ZERO,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-3),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,30),ZERO,G4(:,:,:,51))
  call loop_AZ_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),ZERO,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,49),wf(:,3),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,22),ZERO,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-3),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,30),ZERO,G3(:,:,:,105))
  call loop_AZ_Q(G3(:,:,:,105),wf(:,0),G3(:,:,:,106),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,31),ZERO,G4tensor(:,27))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-3),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,10),ZERO,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,3),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,30),ZERO,G3(:,:,:,107))
  call loop_AZ_Q(G3(:,:,:,107),wf(:,0),G3(:,:,:,108),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,31),ZERO,G4tensor(:,28))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-4),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,26),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,-2),G3(:,:,:,110))
  call loop_A_Q(G3(:,:,:,110),Q(:,30),ZERO,G4(:,:,:,53))
  call loop_AZ_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),ZERO,G5tensor(:,27))
  call loop_AV_Q(G2(:,:,:,105),wf(:,-2),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,14),ZERO,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,30),ZERO,G4(:,:,:,55))
  call loop_AZ_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),ZERO,G5tensor(:,28))
  call loop_AV_Q(G1(:,:,:,49),wf(:,5),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,26),ZERO,G2(:,:,:,109))
  call loop_AV_Q(G2(:,:,:,109),wf(:,-2),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,30),ZERO,G3(:,:,:,113))
  call loop_AZ_Q(G3(:,:,:,113),wf(:,0),G3(:,:,:,114),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,114),Q(:,31),ZERO,G4tensor(:,29))
  call loop_AV_Q(G1(:,:,:,49),wf(:,-2),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,6),ZERO,G2(:,:,:,111))
  call loop_AV_Q(G2(:,:,:,111),wf(:,5),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,30),ZERO,G3(:,:,:,115))
  call loop_AZ_Q(G3(:,:,:,115),wf(:,0),G3(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,116),Q(:,31),ZERO,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-4),G2(:,:,:,113))
  call loop_A_Q(G2(:,:,:,113),Q(:,22),ZERO,G3(:,:,:,117))
  call loop_AV_Q(G3(:,:,:,117),wf(:,-3),G3(:,:,:,118))
  call loop_A_Q(G3(:,:,:,118),Q(:,30),ZERO,G4(:,:,:,57))
  call loop_AZ_Q(G4(:,:,:,57),wf(:,0),G4(:,:,:,58),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,58),Q(:,31),ZERO,G5tensor(:,29))
  call loop_AV_Q(G2(:,:,:,111),wf(:,-3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,14),ZERO,G3(:,:,:,119))
  call loop_AV_Q(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_A_Q(G3(:,:,:,120),Q(:,30),ZERO,G4(:,:,:,59))
  call loop_AZ_Q(G4(:,:,:,59),wf(:,0),G4(:,:,:,60),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,60),Q(:,31),ZERO,G5tensor(:,30))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,2),MT,G1(:,:,:,56))
  call loop_AV_Q(G1(:,:,:,56),wf(:,1),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,14),MT,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-4),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,30),MT,G3(:,:,:,121))
  call loop_AZ_Q(G3(:,:,:,121),wf(:,0),G3(:,:,:,122),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,122),Q(:,31),MT,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-4),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,18),MT,G2(:,:,:,117))
  call loop_AV_Q(G2(:,:,:,117),wf(:,1),G2(:,:,:,118))
  call loop_A_Q(G2(:,:,:,118),Q(:,30),MT,G3(:,:,:,123))
  call loop_AZ_Q(G3(:,:,:,123),wf(:,0),G3(:,:,:,124),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,124),Q(:,31),MT,G4tensor(:,32))
  call loop_AV_Q(G2(:,:,:,117),wf(:,-3),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,26),MT,G3(:,:,:,125))
  call loop_AV_Q(G3(:,:,:,125),wf(:,-2),G3(:,:,:,126))
  call loop_A_Q(G3(:,:,:,126),Q(:,30),MT,G4(:,:,:,61))
  call loop_AZ_Q(G4(:,:,:,61),wf(:,0),G4(:,:,:,62),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,62),Q(:,31),MT,G5tensor(:,31))
  call loop_AV_Q(G2(:,:,:,117),wf(:,-2),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,22),MT,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,-3),G3(:,:,:,128))
  call loop_A_Q(G3(:,:,:,128),Q(:,30),MT,G4(:,:,:,63))
  call loop_AZ_Q(G4(:,:,:,63),wf(:,0),G4(:,:,:,64),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,64),Q(:,31),MT,G5tensor(:,32))
  call loop_AV_Q(G1(:,:,:,56),wf(:,3),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,22),MT,G2(:,:,:,121))
  call loop_AV_Q(G2(:,:,:,121),wf(:,-3),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,30),MT,G3(:,:,:,129))
  call loop_AZ_Q(G3(:,:,:,129),wf(:,0),G3(:,:,:,130),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,31),MT,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-3),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,10),MT,G2(:,:,:,123))
  call loop_AV_Q(G2(:,:,:,123),wf(:,3),G2(:,:,:,124))
  call loop_A_Q(G2(:,:,:,124),Q(:,30),MT,G3(:,:,:,131))
  call loop_AZ_Q(G3(:,:,:,131),wf(:,0),G3(:,:,:,132),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,132),Q(:,31),MT,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-4),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,26),MT,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-2),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,30),MT,G4(:,:,:,65))
  call loop_AZ_Q(G4(:,:,:,65),wf(:,0),G4(:,:,:,66),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,31),MT,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,123),wf(:,-2),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,14),MT,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,-4),G3(:,:,:,136))
  call loop_A_Q(G3(:,:,:,136),Q(:,30),MT,G4(:,:,:,67))
  call loop_AZ_Q(G4(:,:,:,67),wf(:,0),G4(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,31),MT,G5tensor(:,34))
  call loop_AV_Q(G1(:,:,:,56),wf(:,5),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,26),MT,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-2),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,30),MT,G3(:,:,:,137))
  call loop_AZ_Q(G3(:,:,:,137),wf(:,0),G3(:,:,:,138),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,138),Q(:,31),MT,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,56),wf(:,-2),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,6),MT,G2(:,:,:,129))
  call loop_AV_Q(G2(:,:,:,129),wf(:,5),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,30),MT,G3(:,:,:,139))
  call loop_AZ_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,31),MT,G4tensor(:,36))
  call loop_AV_Q(G2(:,:,:,129),wf(:,-4),G2(:,:,:,131))
  call loop_A_Q(G2(:,:,:,131),Q(:,22),MT,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,30),MT,G4(:,:,:,69))
  call loop_AZ_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,31),MT,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,129),wf(:,-3),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,14),MT,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,30),MT,G4(:,:,:,71))
  call loop_AZ_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,31),MT,G5tensor(:,36))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,2),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,1),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,14),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,30),ZERO,G3(:,:,:,145))
  call loop_QZ_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,31),ZERO,G4tensor(:,37))
  call loop_QV_A(G1(:,:,:,63),wf(:,-4),G1(:,:,:,65))
  call loop_Q_A(G1(:,:,:,65),Q(:,18),ZERO,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,1),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,30),ZERO,G3(:,:,:,147))
  call loop_QZ_A(G3(:,:,:,147),wf(:,0),G3(:,:,:,148),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,31),ZERO,G4tensor(:,38))
  call loop_QV_A(G2(:,:,:,135),wf(:,-3),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,26),ZERO,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_QZ_A(G4(:,:,:,73),wf(:,0),G4(:,:,:,74),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_QV_A(G2(:,:,:,135),wf(:,-2),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,22),ZERO,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,-3),G3(:,:,:,152))
  call loop_Q_A(G3(:,:,:,152),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_QZ_A(G4(:,:,:,75),wf(:,0),G4(:,:,:,76),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_QV_A(G1(:,:,:,63),wf(:,3),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,22),ZERO,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,-3),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,30),ZERO,G3(:,:,:,153))
  call loop_QZ_A(G3(:,:,:,153),wf(:,0),G3(:,:,:,154),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,31),ZERO,G4tensor(:,39))
  call loop_QV_A(G1(:,:,:,63),wf(:,-3),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,10),ZERO,G2(:,:,:,141))
  call loop_QV_A(G2(:,:,:,141),wf(:,3),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,30),ZERO,G3(:,:,:,155))
  call loop_QZ_A(G3(:,:,:,155),wf(:,0),G3(:,:,:,156),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,31),ZERO,G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,141),wf(:,-4),G2(:,:,:,143))
  call loop_Q_A(G2(:,:,:,143),Q(:,26),ZERO,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,-2),G3(:,:,:,158))
  call loop_Q_A(G3(:,:,:,158),Q(:,30),ZERO,G4(:,:,:,77))
  call loop_QZ_A(G4(:,:,:,77),wf(:,0),G4(:,:,:,78),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,78),Q(:,31),ZERO,G5tensor(:,39))
  call loop_QV_A(G2(:,:,:,141),wf(:,-2),G2(:,:,:,144))
  call loop_Q_A(G2(:,:,:,144),Q(:,14),ZERO,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,30),ZERO,G4(:,:,:,79))
  call loop_QZ_A(G4(:,:,:,79),wf(:,0),G4(:,:,:,80),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,80),Q(:,31),ZERO,G5tensor(:,40))
  call loop_QV_A(G1(:,:,:,63),wf(:,5),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,26),ZERO,G2(:,:,:,145))
  call loop_QV_A(G2(:,:,:,145),wf(:,-2),G2(:,:,:,146))
  call loop_Q_A(G2(:,:,:,146),Q(:,30),ZERO,G3(:,:,:,161))
  call loop_QZ_A(G3(:,:,:,161),wf(:,0),G3(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,31),ZERO,G4tensor(:,41))
  call loop_QV_A(G1(:,:,:,63),wf(:,-2),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,6),ZERO,G2(:,:,:,147))
  call loop_QV_A(G2(:,:,:,147),wf(:,5),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,30),ZERO,G3(:,:,:,163))
  call loop_QZ_A(G3(:,:,:,163),wf(:,0),G3(:,:,:,164),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,31),ZERO,G4tensor(:,42))
  call loop_QV_A(G2(:,:,:,147),wf(:,-4),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,22),ZERO,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-3),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,30),ZERO,G4(:,:,:,81))
  call loop_QZ_A(G4(:,:,:,81),wf(:,0),G4(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,31),ZERO,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,147),wf(:,-3),G2(:,:,:,150))
  call loop_Q_A(G2(:,:,:,150),Q(:,14),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,30),ZERO,G4(:,:,:,83))
  call loop_QZ_A(G4(:,:,:,83),wf(:,0),G4(:,:,:,84),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,31),ZERO,G5tensor(:,42))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,2),MT,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,1),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,14),MT,G2(:,:,:,151))
  call loop_QV_A(G2(:,:,:,151),wf(:,-4),G2(:,:,:,152))
  call loop_Q_A(G2(:,:,:,152),Q(:,30),MT,G3(:,:,:,169))
  call loop_QZ_A(G3(:,:,:,169),wf(:,0),G3(:,:,:,170),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,31),MT,G4tensor(:,43))
  call loop_QV_A(G1(:,:,:,70),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,18),MT,G2(:,:,:,153))
  call loop_QV_A(G2(:,:,:,153),wf(:,1),G2(:,:,:,154))
  call loop_Q_A(G2(:,:,:,154),Q(:,30),MT,G3(:,:,:,171))
  call loop_QZ_A(G3(:,:,:,171),wf(:,0),G3(:,:,:,172),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,31),MT,G4tensor(:,44))
  call loop_QV_A(G2(:,:,:,153),wf(:,-3),G2(:,:,:,155))
  call loop_Q_A(G2(:,:,:,155),Q(:,26),MT,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-2),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,30),MT,G4(:,:,:,85))
  call loop_QZ_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,31),MT,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,153),wf(:,-2),G2(:,:,:,156))
  call loop_Q_A(G2(:,:,:,156),Q(:,22),MT,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-3),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,30),MT,G4(:,:,:,87))
  call loop_QZ_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,31),MT,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,70),wf(:,3),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,22),MT,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,-3),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,30),MT,G3(:,:,:,177))
  call loop_QZ_A(G3(:,:,:,177),wf(:,0),G3(:,:,:,178),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,31),MT,G4tensor(:,45))
  call loop_QV_A(G1(:,:,:,70),wf(:,-3),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,10),MT,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,3),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,30),MT,G3(:,:,:,179))
  call loop_QZ_A(G3(:,:,:,179),wf(:,0),G3(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,31),MT,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,159),wf(:,-4),G2(:,:,:,161))
  call loop_Q_A(G2(:,:,:,161),Q(:,26),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-2),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,30),MT,G4(:,:,:,89))
  call loop_QZ_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),MT,G5tensor(:,45))
  call loop_QV_A(G2(:,:,:,159),wf(:,-2),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,14),MT,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-4),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,30),MT,G4(:,:,:,91))
  call loop_QZ_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),MT,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,70),wf(:,5),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,26),MT,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,30),MT,G3(:,:,:,185))
  call loop_QZ_A(G3(:,:,:,185),wf(:,0),G3(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,31),MT,G4tensor(:,47))
  call loop_QV_A(G1(:,:,:,70),wf(:,-2),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,6),MT,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,5),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,30),MT,G3(:,:,:,187))
  call loop_QZ_A(G3(:,:,:,187),wf(:,0),G3(:,:,:,188),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,31),MT,G4tensor(:,48))
  call loop_QV_A(G2(:,:,:,165),wf(:,-4),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,22),MT,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,-3),G3(:,:,:,190))
  call loop_Q_A(G3(:,:,:,190),Q(:,30),MT,G4(:,:,:,93))
  call loop_QZ_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),MT,G5tensor(:,47))
  call loop_QV_A(G2(:,:,:,165),wf(:,-3),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,14),MT,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,30),MT,G4(:,:,:,95))
  call loop_QZ_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),MT,G5tensor(:,48))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,2),ZERO,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,1),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,14),ZERO,G2(:,:,:,169))
  call loop_AV_Q(G2(:,:,:,169),wf(:,-4),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,30),ZERO,G3(:,:,:,193))
  call loop_AZ_Q(G3(:,:,:,193),wf(:,0),G3(:,:,:,194),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,31),ZERO,G4tensor(:,49))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-4),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,18),ZERO,G2(:,:,:,171))
  call loop_AV_Q(G2(:,:,:,171),wf(:,1),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,30),ZERO,G3(:,:,:,195))
  call loop_AZ_Q(G3(:,:,:,195),wf(:,0),G3(:,:,:,196),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,31),ZERO,G4tensor(:,50))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-3),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,26),ZERO,G3(:,:,:,197))
  call loop_AV_Q(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198))
  call loop_A_Q(G3(:,:,:,198),Q(:,30),ZERO,G4(:,:,:,97))
  call loop_AZ_Q(G4(:,:,:,97),wf(:,0),G4(:,:,:,98),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,98),Q(:,31),ZERO,G5tensor(:,49))
  call loop_AV_Q(G2(:,:,:,171),wf(:,-2),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,22),ZERO,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-3),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,30),ZERO,G4(:,:,:,99))
  call loop_AZ_Q(G4(:,:,:,99),wf(:,0),G4(:,:,:,100),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,100),Q(:,31),ZERO,G5tensor(:,50))
  call loop_AV_Q(G1(:,:,:,77),wf(:,3),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,22),ZERO,G2(:,:,:,175))
  call loop_AV_Q(G2(:,:,:,175),wf(:,-3),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,30),ZERO,G3(:,:,:,201))
  call loop_AZ_Q(G3(:,:,:,201),wf(:,0),G3(:,:,:,202),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,31),ZERO,G4tensor(:,51))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-3),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,10),ZERO,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,3),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,30),ZERO,G3(:,:,:,203))
  call loop_AZ_Q(G3(:,:,:,203),wf(:,0),G3(:,:,:,204),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,31),ZERO,G4tensor(:,52))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-4),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,26),ZERO,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-2),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,30),ZERO,G4(:,:,:,101))
  call loop_AZ_Q(G4(:,:,:,101),wf(:,0),G4(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,102),Q(:,31),ZERO,G5tensor(:,51))
  call loop_AV_Q(G2(:,:,:,177),wf(:,-2),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,14),ZERO,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,30),ZERO,G4(:,:,:,103))
  call loop_AZ_Q(G4(:,:,:,103),wf(:,0),G4(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,104),Q(:,31),ZERO,G5tensor(:,52))
  call loop_AV_Q(G1(:,:,:,77),wf(:,5),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,26),ZERO,G2(:,:,:,181))
  call loop_AV_Q(G2(:,:,:,181),wf(:,-2),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,30),ZERO,G3(:,:,:,209))
  call loop_AZ_Q(G3(:,:,:,209),wf(:,0),G3(:,:,:,210),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,31),ZERO,G4tensor(:,53))
  call loop_AV_Q(G1(:,:,:,77),wf(:,-2),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,6),ZERO,G2(:,:,:,183))
  call loop_AV_Q(G2(:,:,:,183),wf(:,5),G2(:,:,:,184))
  call loop_A_Q(G2(:,:,:,184),Q(:,30),ZERO,G3(:,:,:,211))
  call loop_AZ_Q(G3(:,:,:,211),wf(:,0),G3(:,:,:,212),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,31),ZERO,G4tensor(:,54))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-4),G2(:,:,:,185))
  call loop_A_Q(G2(:,:,:,185),Q(:,22),ZERO,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-3),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,30),ZERO,G4(:,:,:,105))
  call loop_AZ_Q(G4(:,:,:,105),wf(:,0),G4(:,:,:,106),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,106),Q(:,31),ZERO,G5tensor(:,53))
  call loop_AV_Q(G2(:,:,:,183),wf(:,-3),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,14),ZERO,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,30),ZERO,G4(:,:,:,107))
  call loop_AZ_Q(G4(:,:,:,107),wf(:,0),G4(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,108),Q(:,31),ZERO,G5tensor(:,54))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,2),MB,G1(:,:,:,84))
  call loop_AV_Q(G1(:,:,:,84),wf(:,1),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,14),MB,G2(:,:,:,187))
  call loop_AV_Q(G2(:,:,:,187),wf(:,-4),G2(:,:,:,188))
  call loop_A_Q(G2(:,:,:,188),Q(:,30),MB,G3(:,:,:,217))
  call loop_AZ_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,31),MB,G4tensor(:,55))
  call loop_AV_Q(G1(:,:,:,84),wf(:,-4),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,18),MB,G2(:,:,:,189))
  call loop_AV_Q(G2(:,:,:,189),wf(:,1),G2(:,:,:,190))
  call loop_A_Q(G2(:,:,:,190),Q(:,30),MB,G3(:,:,:,219))
  call loop_AZ_Q(G3(:,:,:,219),wf(:,0),G3(:,:,:,220),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,31),MB,G4tensor(:,56))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-3),G2(:,:,:,191))
  call loop_A_Q(G2(:,:,:,191),Q(:,26),MB,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-2),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,30),MB,G4(:,:,:,109))
  call loop_AZ_Q(G4(:,:,:,109),wf(:,0),G4(:,:,:,110),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,110),Q(:,31),MB,G5tensor(:,55))
  call loop_AV_Q(G2(:,:,:,189),wf(:,-2),G2(:,:,:,192))
  call loop_A_Q(G2(:,:,:,192),Q(:,22),MB,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-3),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,30),MB,G4(:,:,:,111))
  call loop_AZ_Q(G4(:,:,:,111),wf(:,0),G4(:,:,:,112),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,112),Q(:,31),MB,G5tensor(:,56))
  call loop_AV_Q(G1(:,:,:,84),wf(:,3),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,22),MB,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-3),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,30),MB,G3(:,:,:,225))
  call loop_AZ_Q(G3(:,:,:,225),wf(:,0),G3(:,:,:,226),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,31),MB,G4tensor(:,57))
  call loop_AV_Q(G1(:,:,:,84),wf(:,-3),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,10),MB,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,3),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,30),MB,G3(:,:,:,227))
  call loop_AZ_Q(G3(:,:,:,227),wf(:,0),G3(:,:,:,228),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,31),MB,G4tensor(:,58))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-4),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,26),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,-2),G3(:,:,:,230))
  call loop_A_Q(G3(:,:,:,230),Q(:,30),MB,G4(:,:,:,113))
  call loop_AZ_Q(G4(:,:,:,113),wf(:,0),G4(:,:,:,114),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,114),Q(:,31),MB,G5tensor(:,57))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-2),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,14),MB,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-4),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,30),MB,G4(:,:,:,115))
  call loop_AZ_Q(G4(:,:,:,115),wf(:,0),G4(:,:,:,116),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,116),Q(:,31),MB,G5tensor(:,58))
  call loop_AV_Q(G1(:,:,:,84),wf(:,5),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,26),MB,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,30),MB,G3(:,:,:,233))
  call loop_AZ_Q(G3(:,:,:,233),wf(:,0),G3(:,:,:,234),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,31),MB,G4tensor(:,59))
  call loop_AV_Q(G1(:,:,:,84),wf(:,-2),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,6),MB,G2(:,:,:,201))
  call loop_AV_Q(G2(:,:,:,201),wf(:,5),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,30),MB,G3(:,:,:,235))
  call loop_AZ_Q(G3(:,:,:,235),wf(:,0),G3(:,:,:,236),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,31),MB,G4tensor(:,60))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-4),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,22),MB,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-3),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,30),MB,G4(:,:,:,117))
  call loop_AZ_Q(G4(:,:,:,117),wf(:,0),G4(:,:,:,118),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,118),Q(:,31),MB,G5tensor(:,59))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-3),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,14),MB,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-4),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,30),MB,G4(:,:,:,119))
  call loop_AZ_Q(G4(:,:,:,119),wf(:,0),G4(:,:,:,120),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,120),Q(:,31),MB,G5tensor(:,60))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,2),ZERO,G1(:,:,:,91))
  call loop_QV_A(G1(:,:,:,91),wf(:,1),G1(:,:,:,92))
  call loop_Q_A(G1(:,:,:,92),Q(:,14),ZERO,G2(:,:,:,205))
  call loop_QV_A(G2(:,:,:,205),wf(:,-4),G2(:,:,:,206))
  call loop_Q_A(G2(:,:,:,206),Q(:,30),ZERO,G3(:,:,:,241))
  call loop_QZ_A(G3(:,:,:,241),wf(:,0),G3(:,:,:,242),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,242),Q(:,31),ZERO,G4tensor(:,61))
  call loop_QV_A(G1(:,:,:,91),wf(:,-4),G1(:,:,:,93))
  call loop_Q_A(G1(:,:,:,93),Q(:,18),ZERO,G2(:,:,:,207))
  call loop_QV_A(G2(:,:,:,207),wf(:,1),G2(:,:,:,208))
  call loop_Q_A(G2(:,:,:,208),Q(:,30),ZERO,G3(:,:,:,243))
  call loop_QZ_A(G3(:,:,:,243),wf(:,0),G3(:,:,:,244),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,244),Q(:,31),ZERO,G4tensor(:,62))
  call loop_QV_A(G2(:,:,:,207),wf(:,-3),G2(:,:,:,209))
  call loop_Q_A(G2(:,:,:,209),Q(:,26),ZERO,G3(:,:,:,245))
  call loop_QV_A(G3(:,:,:,245),wf(:,-2),G3(:,:,:,246))
  call loop_Q_A(G3(:,:,:,246),Q(:,30),ZERO,G4(:,:,:,121))
  call loop_QZ_A(G4(:,:,:,121),wf(:,0),G4(:,:,:,122),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,122),Q(:,31),ZERO,G5tensor(:,61))
  call loop_QV_A(G2(:,:,:,207),wf(:,-2),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,22),ZERO,G3(:,:,:,247))
  call loop_QV_A(G3(:,:,:,247),wf(:,-3),G3(:,:,:,248))
  call loop_Q_A(G3(:,:,:,248),Q(:,30),ZERO,G4(:,:,:,123))
  call loop_QZ_A(G4(:,:,:,123),wf(:,0),G4(:,:,:,124),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,124),Q(:,31),ZERO,G5tensor(:,62))
  call loop_QV_A(G1(:,:,:,91),wf(:,3),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,22),ZERO,G2(:,:,:,211))
  call loop_QV_A(G2(:,:,:,211),wf(:,-3),G2(:,:,:,212))
  call loop_Q_A(G2(:,:,:,212),Q(:,30),ZERO,G3(:,:,:,249))
  call loop_QZ_A(G3(:,:,:,249),wf(:,0),G3(:,:,:,250),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,250),Q(:,31),ZERO,G4tensor(:,63))
  call loop_QV_A(G1(:,:,:,91),wf(:,-3),G1(:,:,:,95))
  call loop_Q_A(G1(:,:,:,95),Q(:,10),ZERO,G2(:,:,:,213))
  call loop_QV_A(G2(:,:,:,213),wf(:,3),G2(:,:,:,214))
  call loop_Q_A(G2(:,:,:,214),Q(:,30),ZERO,G3(:,:,:,251))
  call loop_QZ_A(G3(:,:,:,251),wf(:,0),G3(:,:,:,252),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,252),Q(:,31),ZERO,G4tensor(:,64))
  call loop_QV_A(G2(:,:,:,213),wf(:,-4),G2(:,:,:,215))
  call loop_Q_A(G2(:,:,:,215),Q(:,26),ZERO,G3(:,:,:,253))
  call loop_QV_A(G3(:,:,:,253),wf(:,-2),G3(:,:,:,254))
  call loop_Q_A(G3(:,:,:,254),Q(:,30),ZERO,G4(:,:,:,125))
  call loop_QZ_A(G4(:,:,:,125),wf(:,0),G4(:,:,:,126),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,126),Q(:,31),ZERO,G5tensor(:,63))
  call loop_QV_A(G2(:,:,:,213),wf(:,-2),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,14),ZERO,G3(:,:,:,255))
  call loop_QV_A(G3(:,:,:,255),wf(:,-4),G3(:,:,:,256))
  call loop_Q_A(G3(:,:,:,256),Q(:,30),ZERO,G4(:,:,:,127))
  call loop_QZ_A(G4(:,:,:,127),wf(:,0),G4(:,:,:,128),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,128),Q(:,31),ZERO,G5tensor(:,64))
  call loop_QV_A(G1(:,:,:,91),wf(:,5),G1(:,:,:,96))
  call loop_Q_A(G1(:,:,:,96),Q(:,26),ZERO,G2(:,:,:,217))
  call loop_QV_A(G2(:,:,:,217),wf(:,-2),G2(:,:,:,218))
  call loop_Q_A(G2(:,:,:,218),Q(:,30),ZERO,G3(:,:,:,257))
  call loop_QZ_A(G3(:,:,:,257),wf(:,0),G3(:,:,:,258),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,258),Q(:,31),ZERO,G4tensor(:,65))
  call loop_QV_A(G1(:,:,:,91),wf(:,-2),G1(:,:,:,97))
  call loop_Q_A(G1(:,:,:,97),Q(:,6),ZERO,G2(:,:,:,219))
  call loop_QV_A(G2(:,:,:,219),wf(:,5),G2(:,:,:,220))
  call loop_Q_A(G2(:,:,:,220),Q(:,30),ZERO,G3(:,:,:,259))
  call loop_QZ_A(G3(:,:,:,259),wf(:,0),G3(:,:,:,260),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,260),Q(:,31),ZERO,G4tensor(:,66))
  call loop_QV_A(G2(:,:,:,219),wf(:,-4),G2(:,:,:,221))
  call loop_Q_A(G2(:,:,:,221),Q(:,22),ZERO,G3(:,:,:,261))
  call loop_QV_A(G3(:,:,:,261),wf(:,-3),G3(:,:,:,262))
  call loop_Q_A(G3(:,:,:,262),Q(:,30),ZERO,G4(:,:,:,129))
  call loop_QZ_A(G4(:,:,:,129),wf(:,0),G4(:,:,:,130),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,130),Q(:,31),ZERO,G5tensor(:,65))
  call loop_QV_A(G2(:,:,:,219),wf(:,-3),G2(:,:,:,222))
  call loop_Q_A(G2(:,:,:,222),Q(:,14),ZERO,G3(:,:,:,263))
  call loop_QV_A(G3(:,:,:,263),wf(:,-4),G3(:,:,:,264))
  call loop_Q_A(G3(:,:,:,264),Q(:,30),ZERO,G4(:,:,:,131))
  call loop_QZ_A(G4(:,:,:,131),wf(:,0),G4(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,132),Q(:,31),ZERO,G5tensor(:,66))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,2),MB,G1(:,:,:,98))
  call loop_QV_A(G1(:,:,:,98),wf(:,1),G1(:,:,:,99))
  call loop_Q_A(G1(:,:,:,99),Q(:,14),MB,G2(:,:,:,223))
  call loop_QV_A(G2(:,:,:,223),wf(:,-4),G2(:,:,:,224))
  call loop_Q_A(G2(:,:,:,224),Q(:,30),MB,G3(:,:,:,265))
  call loop_QZ_A(G3(:,:,:,265),wf(:,0),G3(:,:,:,266),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,266),Q(:,31),MB,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,98),wf(:,-4),G1(:,:,:,100))
  call loop_Q_A(G1(:,:,:,100),Q(:,18),MB,G2(:,:,:,225))
  call loop_QV_A(G2(:,:,:,225),wf(:,1),G2(:,:,:,226))
  call loop_Q_A(G2(:,:,:,226),Q(:,30),MB,G3(:,:,:,267))
  call loop_QZ_A(G3(:,:,:,267),wf(:,0),G3(:,:,:,268),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,268),Q(:,31),MB,G4tensor(:,68))
  call loop_QV_A(G2(:,:,:,225),wf(:,-3),G2(:,:,:,227))
  call loop_Q_A(G2(:,:,:,227),Q(:,26),MB,G3(:,:,:,269))
  call loop_QV_A(G3(:,:,:,269),wf(:,-2),G3(:,:,:,270))
  call loop_Q_A(G3(:,:,:,270),Q(:,30),MB,G4(:,:,:,133))
  call loop_QZ_A(G4(:,:,:,133),wf(:,0),G4(:,:,:,134),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,134),Q(:,31),MB,G5tensor(:,67))
  call loop_QV_A(G2(:,:,:,225),wf(:,-2),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,22),MB,G3(:,:,:,271))
  call loop_QV_A(G3(:,:,:,271),wf(:,-3),G3(:,:,:,272))
  call loop_Q_A(G3(:,:,:,272),Q(:,30),MB,G4(:,:,:,135))
  call loop_QZ_A(G4(:,:,:,135),wf(:,0),G4(:,:,:,136),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,136),Q(:,31),MB,G5tensor(:,68))
  call loop_QV_A(G1(:,:,:,98),wf(:,3),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,22),MB,G2(:,:,:,229))
  call loop_QV_A(G2(:,:,:,229),wf(:,-3),G2(:,:,:,230))
  call loop_Q_A(G2(:,:,:,230),Q(:,30),MB,G3(:,:,:,273))
  call loop_QZ_A(G3(:,:,:,273),wf(:,0),G3(:,:,:,274),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,274),Q(:,31),MB,G4tensor(:,69))
  call loop_QV_A(G1(:,:,:,98),wf(:,-3),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,10),MB,G2(:,:,:,231))
  call loop_QV_A(G2(:,:,:,231),wf(:,3),G2(:,:,:,232))
  call loop_Q_A(G2(:,:,:,232),Q(:,30),MB,G3(:,:,:,275))
  call loop_QZ_A(G3(:,:,:,275),wf(:,0),G3(:,:,:,276),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,276),Q(:,31),MB,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,231),wf(:,-4),G2(:,:,:,233))
  call loop_Q_A(G2(:,:,:,233),Q(:,26),MB,G3(:,:,:,277))
  call loop_QV_A(G3(:,:,:,277),wf(:,-2),G3(:,:,:,278))
  call loop_Q_A(G3(:,:,:,278),Q(:,30),MB,G4(:,:,:,137))
  call loop_QZ_A(G4(:,:,:,137),wf(:,0),G4(:,:,:,138),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,138),Q(:,31),MB,G5tensor(:,69))
  call loop_QV_A(G2(:,:,:,231),wf(:,-2),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,14),MB,G3(:,:,:,279))
  call loop_QV_A(G3(:,:,:,279),wf(:,-4),G3(:,:,:,280))
  call loop_Q_A(G3(:,:,:,280),Q(:,30),MB,G4(:,:,:,139))
  call loop_QZ_A(G4(:,:,:,139),wf(:,0),G4(:,:,:,140),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,140),Q(:,31),MB,G5tensor(:,70))
  call loop_QV_A(G1(:,:,:,98),wf(:,5),G1(:,:,:,103))
  call loop_Q_A(G1(:,:,:,103),Q(:,26),MB,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,-2),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,30),MB,G3(:,:,:,281))
  call loop_QZ_A(G3(:,:,:,281),wf(:,0),G3(:,:,:,282),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,282),Q(:,31),MB,G4tensor(:,71))
  call loop_QV_A(G1(:,:,:,98),wf(:,-2),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,6),MB,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,5),G2(:,:,:,238))
  call loop_Q_A(G2(:,:,:,238),Q(:,30),MB,G3(:,:,:,283))
  call loop_QZ_A(G3(:,:,:,283),wf(:,0),G3(:,:,:,284),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,284),Q(:,31),MB,G4tensor(:,72))
  call loop_QV_A(G2(:,:,:,237),wf(:,-4),G2(:,:,:,239))
  call loop_Q_A(G2(:,:,:,239),Q(:,22),MB,G3(:,:,:,285))
  call loop_QV_A(G3(:,:,:,285),wf(:,-3),G3(:,:,:,286))
  call loop_Q_A(G3(:,:,:,286),Q(:,30),MB,G4(:,:,:,141))
  call loop_QZ_A(G4(:,:,:,141),wf(:,0),G4(:,:,:,142),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,142),Q(:,31),MB,G5tensor(:,71))
  call loop_QV_A(G2(:,:,:,237),wf(:,-3),G2(:,:,:,240))
  call loop_Q_A(G2(:,:,:,240),Q(:,14),MB,G3(:,:,:,287))
  call loop_QV_A(G3(:,:,:,287),wf(:,-4),G3(:,:,:,288))
  call loop_Q_A(G3(:,:,:,288),Q(:,30),MB,G4(:,:,:,143))
  call loop_QZ_A(G4(:,:,:,143),wf(:,0),G4(:,:,:,144),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,144),Q(:,31),MB,G5tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,12),ZERO,G1(:,:,:,105))
  call loop_QZ_A(G1(:,:,:,105),wf(:,-1),G1(:,:,:,106),gZu)
  call loop_Q_A(G1(:,:,:,106),Q(:,14),ZERO,G2(:,:,:,241))
  call loop_QV_A(G2(:,:,:,241),wf(:,-4),G2(:,:,:,242))
  call loop_Q_A(G2(:,:,:,242),Q(:,30),ZERO,G3(:,:,:,289))
  call loop_QZ_A(G3(:,:,:,289),wf(:,0),G3(:,:,:,290),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,290),Q(:,31),ZERO,G4tensor(:,73))
  call loop_QZ_A(G1(:,:,:,105),wf(:,-1),G1(:,:,:,107),gZd)
  call loop_Q_A(G1(:,:,:,107),Q(:,14),ZERO,G2(:,:,:,243))
  call loop_QV_A(G2(:,:,:,243),wf(:,-4),G2(:,:,:,244))
  call loop_Q_A(G2(:,:,:,244),Q(:,30),ZERO,G3(:,:,:,291))
  call loop_QZ_A(G3(:,:,:,291),wf(:,0),G3(:,:,:,292),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,292),Q(:,31),ZERO,G4tensor(:,74))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,12),ZERO,G1(:,:,:,108))
  call loop_AZ_Q(G1(:,:,:,108),wf(:,-1),G1(:,:,:,109),gZu)
  call loop_A_Q(G1(:,:,:,109),Q(:,14),ZERO,G2(:,:,:,245))
  call loop_AV_Q(G2(:,:,:,245),wf(:,-4),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,30),ZERO,G3(:,:,:,293))
  call loop_AZ_Q(G3(:,:,:,293),wf(:,0),G3(:,:,:,294),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,294),Q(:,31),ZERO,G4tensor(:,75))
  call loop_AZ_Q(G1(:,:,:,108),wf(:,-1),G1(:,:,:,110),gZd)
  call loop_A_Q(G1(:,:,:,110),Q(:,14),ZERO,G2(:,:,:,247))
  call loop_AV_Q(G2(:,:,:,247),wf(:,-4),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,30),ZERO,G3(:,:,:,295))
  call loop_AZ_Q(G3(:,:,:,295),wf(:,0),G3(:,:,:,296),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,296),Q(:,31),ZERO,G4tensor(:,76))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,8),ZERO,G1(:,:,:,111))
  call loop_AZ_Q(G1(:,:,:,111),wf(:,-1),G1(:,:,:,112),gZu)
  call loop_A_Q(G1(:,:,:,112),Q(:,10),ZERO,G2(:,:,:,249))
  call loop_AV_Q(G2(:,:,:,249),wf(:,3),G2(:,:,:,250))
  call loop_A_Q(G2(:,:,:,250),Q(:,30),ZERO,G3(:,:,:,297))
  call loop_AZ_Q(G3(:,:,:,297),wf(:,0),G3(:,:,:,298),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,298),Q(:,31),ZERO,G4tensor(:,77))
  call loop_AV_Q(G2(:,:,:,249),wf(:,-2),G2(:,:,:,251))
  call loop_A_Q(G2(:,:,:,251),Q(:,14),ZERO,G3(:,:,:,299))
  call loop_AV_Q(G3(:,:,:,299),wf(:,-4),G3(:,:,:,300))
  call loop_A_Q(G3(:,:,:,300),Q(:,30),ZERO,G4(:,:,:,145))
  call loop_AZ_Q(G4(:,:,:,145),wf(:,0),G4(:,:,:,146),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,146),Q(:,31),ZERO,G5tensor(:,73))
  call loop_AZ_Q(G1(:,:,:,111),wf(:,-1),G1(:,:,:,113),gZd)
  call loop_A_Q(G1(:,:,:,113),Q(:,10),ZERO,G2(:,:,:,252))
  call loop_AV_Q(G2(:,:,:,252),wf(:,3),G2(:,:,:,253))
  call loop_A_Q(G2(:,:,:,253),Q(:,30),ZERO,G3(:,:,:,301))
  call loop_AZ_Q(G3(:,:,:,301),wf(:,0),G3(:,:,:,302),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,302),Q(:,31),ZERO,G4tensor(:,78))
  call loop_AV_Q(G2(:,:,:,252),wf(:,-2),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,14),ZERO,G3(:,:,:,303))
  call loop_AV_Q(G3(:,:,:,303),wf(:,-4),G3(:,:,:,304))
  call loop_A_Q(G3(:,:,:,304),Q(:,30),ZERO,G4(:,:,:,147))
  call loop_AZ_Q(G4(:,:,:,147),wf(:,0),G4(:,:,:,148),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,148),Q(:,31),ZERO,G5tensor(:,74))
  call loop_AV_Q(G1(:,:,:,111),wf(:,-2),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,12),ZERO,G2(:,:,:,255))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,-1),G2(:,:,:,256),gZu)
  call loop_A_Q(G2(:,:,:,256),Q(:,14),ZERO,G3(:,:,:,305))
  call loop_AV_Q(G3(:,:,:,305),wf(:,-4),G3(:,:,:,306))
  call loop_A_Q(G3(:,:,:,306),Q(:,30),ZERO,G4(:,:,:,149))
  call loop_AZ_Q(G4(:,:,:,149),wf(:,0),G4(:,:,:,150),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,150),Q(:,31),ZERO,G5tensor(:,75))
  call loop_AZ_Q(G2(:,:,:,255),wf(:,-1),G2(:,:,:,257),gZd)
  call loop_A_Q(G2(:,:,:,257),Q(:,14),ZERO,G3(:,:,:,307))
  call loop_AV_Q(G3(:,:,:,307),wf(:,-4),G3(:,:,:,308))
  call loop_A_Q(G3(:,:,:,308),Q(:,30),ZERO,G4(:,:,:,151))
  call loop_AZ_Q(G4(:,:,:,151),wf(:,0),G4(:,:,:,152),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,152),Q(:,31),ZERO,G5tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,8),ZERO,G1(:,:,:,115))
  call loop_QZ_A(G1(:,:,:,115),wf(:,-1),G1(:,:,:,116),gZu)
  call loop_Q_A(G1(:,:,:,116),Q(:,10),ZERO,G2(:,:,:,258))
  call loop_QV_A(G2(:,:,:,258),wf(:,3),G2(:,:,:,259))
  call loop_Q_A(G2(:,:,:,259),Q(:,30),ZERO,G3(:,:,:,309))
  call loop_QZ_A(G3(:,:,:,309),wf(:,0),G3(:,:,:,310),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,310),Q(:,31),ZERO,G4tensor(:,79))
  call loop_QV_A(G2(:,:,:,258),wf(:,-2),G2(:,:,:,260))
  call loop_Q_A(G2(:,:,:,260),Q(:,14),ZERO,G3(:,:,:,311))
  call loop_QV_A(G3(:,:,:,311),wf(:,-4),G3(:,:,:,312))
  call loop_Q_A(G3(:,:,:,312),Q(:,30),ZERO,G4(:,:,:,153))
  call loop_QZ_A(G4(:,:,:,153),wf(:,0),G4(:,:,:,154),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,154),Q(:,31),ZERO,G5tensor(:,77))
  call loop_QZ_A(G1(:,:,:,115),wf(:,-1),G1(:,:,:,117),gZd)
  call loop_Q_A(G1(:,:,:,117),Q(:,10),ZERO,G2(:,:,:,261))
  call loop_QV_A(G2(:,:,:,261),wf(:,3),G2(:,:,:,262))
  call loop_Q_A(G2(:,:,:,262),Q(:,30),ZERO,G3(:,:,:,313))
  call loop_QZ_A(G3(:,:,:,313),wf(:,0),G3(:,:,:,314),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,314),Q(:,31),ZERO,G4tensor(:,80))
  call loop_QV_A(G2(:,:,:,261),wf(:,-2),G2(:,:,:,263))
  call loop_Q_A(G2(:,:,:,263),Q(:,14),ZERO,G3(:,:,:,315))
  call loop_QV_A(G3(:,:,:,315),wf(:,-4),G3(:,:,:,316))
  call loop_Q_A(G3(:,:,:,316),Q(:,30),ZERO,G4(:,:,:,155))
  call loop_QZ_A(G4(:,:,:,155),wf(:,0),G4(:,:,:,156),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,156),Q(:,31),ZERO,G5tensor(:,78))
  call loop_QV_A(G1(:,:,:,115),wf(:,-2),G1(:,:,:,118))
  call loop_Q_A(G1(:,:,:,118),Q(:,12),ZERO,G2(:,:,:,264))
  call loop_QZ_A(G2(:,:,:,264),wf(:,-1),G2(:,:,:,265),gZu)
  call loop_Q_A(G2(:,:,:,265),Q(:,14),ZERO,G3(:,:,:,317))
  call loop_QV_A(G3(:,:,:,317),wf(:,-4),G3(:,:,:,318))
  call loop_Q_A(G3(:,:,:,318),Q(:,30),ZERO,G4(:,:,:,157))
  call loop_QZ_A(G4(:,:,:,157),wf(:,0),G4(:,:,:,158),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,158),Q(:,31),ZERO,G5tensor(:,79))
  call loop_QZ_A(G2(:,:,:,264),wf(:,-1),G2(:,:,:,266),gZd)
  call loop_Q_A(G2(:,:,:,266),Q(:,14),ZERO,G3(:,:,:,319))
  call loop_QV_A(G3(:,:,:,319),wf(:,-4),G3(:,:,:,320))
  call loop_Q_A(G3(:,:,:,320),Q(:,30),ZERO,G4(:,:,:,159))
  call loop_QZ_A(G4(:,:,:,159),wf(:,0),G4(:,:,:,160),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,160),Q(:,31),ZERO,G5tensor(:,80))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,4),ZERO,G1(:,:,:,119))
  call loop_AZ_Q(G1(:,:,:,119),wf(:,-1),G1(:,:,:,120),gZu)
  call loop_A_Q(G1(:,:,:,120),Q(:,6),ZERO,G2(:,:,:,267))
  call loop_AV_Q(G2(:,:,:,267),wf(:,5),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,30),ZERO,G3(:,:,:,321))
  call loop_AZ_Q(G3(:,:,:,321),wf(:,0),G3(:,:,:,322),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,322),Q(:,31),ZERO,G4tensor(:,81))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-4),G2(:,:,:,269))
  call loop_A_Q(G2(:,:,:,269),Q(:,22),ZERO,G3(:,:,:,323))
  call loop_AV_Q(G3(:,:,:,323),wf(:,-3),G3(:,:,:,324))
  call loop_A_Q(G3(:,:,:,324),Q(:,30),ZERO,G4(:,:,:,161))
  call loop_AZ_Q(G4(:,:,:,161),wf(:,0),G4(:,:,:,162),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,162),Q(:,31),ZERO,G5tensor(:,81))
  call loop_AV_Q(G2(:,:,:,267),wf(:,-3),G2(:,:,:,270))
  call loop_A_Q(G2(:,:,:,270),Q(:,14),ZERO,G3(:,:,:,325))
  call loop_AV_Q(G3(:,:,:,325),wf(:,-4),G3(:,:,:,326))
  call loop_A_Q(G3(:,:,:,326),Q(:,30),ZERO,G4(:,:,:,163))
  call loop_AZ_Q(G4(:,:,:,163),wf(:,0),G4(:,:,:,164),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,164),Q(:,31),ZERO,G5tensor(:,82))
  call loop_AZ_Q(G1(:,:,:,119),wf(:,-1),G1(:,:,:,121),gZd)
  call loop_A_Q(G1(:,:,:,121),Q(:,6),ZERO,G2(:,:,:,271))
  call loop_AV_Q(G2(:,:,:,271),wf(:,5),G2(:,:,:,272))
  call loop_A_Q(G2(:,:,:,272),Q(:,30),ZERO,G3(:,:,:,327))
  call loop_AZ_Q(G3(:,:,:,327),wf(:,0),G3(:,:,:,328),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,328),Q(:,31),ZERO,G4tensor(:,82))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-4),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,22),ZERO,G3(:,:,:,329))
  call loop_AV_Q(G3(:,:,:,329),wf(:,-3),G3(:,:,:,330))
  call loop_A_Q(G3(:,:,:,330),Q(:,30),ZERO,G4(:,:,:,165))
  call loop_AZ_Q(G4(:,:,:,165),wf(:,0),G4(:,:,:,166),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,166),Q(:,31),ZERO,G5tensor(:,83))
  call loop_AV_Q(G2(:,:,:,271),wf(:,-3),G2(:,:,:,274))
  call loop_A_Q(G2(:,:,:,274),Q(:,14),ZERO,G3(:,:,:,331))
  call loop_AV_Q(G3(:,:,:,331),wf(:,-4),G3(:,:,:,332))
  call loop_A_Q(G3(:,:,:,332),Q(:,30),ZERO,G4(:,:,:,167))
  call loop_AZ_Q(G4(:,:,:,167),wf(:,0),G4(:,:,:,168),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,168),Q(:,31),ZERO,G5tensor(:,84))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-4),G1(:,:,:,122))
  call loop_A_Q(G1(:,:,:,122),Q(:,20),ZERO,G2(:,:,:,275))
  call loop_AZ_Q(G2(:,:,:,275),wf(:,-1),G2(:,:,:,276),gZu)
  call loop_A_Q(G2(:,:,:,276),Q(:,22),ZERO,G3(:,:,:,333))
  call loop_AV_Q(G3(:,:,:,333),wf(:,-3),G3(:,:,:,334))
  call loop_A_Q(G3(:,:,:,334),Q(:,30),ZERO,G4(:,:,:,169))
  call loop_AZ_Q(G4(:,:,:,169),wf(:,0),G4(:,:,:,170),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,170),Q(:,31),ZERO,G5tensor(:,85))
  call loop_AZ_Q(G2(:,:,:,275),wf(:,-1),G2(:,:,:,277),gZd)
  call loop_A_Q(G2(:,:,:,277),Q(:,22),ZERO,G3(:,:,:,335))
  call loop_AV_Q(G3(:,:,:,335),wf(:,-3),G3(:,:,:,336))
  call loop_A_Q(G3(:,:,:,336),Q(:,30),ZERO,G4(:,:,:,171))
  call loop_AZ_Q(G4(:,:,:,171),wf(:,0),G4(:,:,:,172),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,172),Q(:,31),ZERO,G5tensor(:,86))
  call loop_AV_Q(G1(:,:,:,119),wf(:,-3),G1(:,:,:,123))
  call loop_A_Q(G1(:,:,:,123),Q(:,12),ZERO,G2(:,:,:,278))
  call loop_AZ_Q(G2(:,:,:,278),wf(:,-1),G2(:,:,:,279),gZu)
  call loop_A_Q(G2(:,:,:,279),Q(:,14),ZERO,G3(:,:,:,337))
  call loop_AV_Q(G3(:,:,:,337),wf(:,-4),G3(:,:,:,338))
  call loop_A_Q(G3(:,:,:,338),Q(:,30),ZERO,G4(:,:,:,173))
  call loop_AZ_Q(G4(:,:,:,173),wf(:,0),G4(:,:,:,174),gZu)
  call check_last_A_Q(l_switch,G4(:,:,:,174),Q(:,31),ZERO,G5tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,278),wf(:,-1),G2(:,:,:,280),gZd)
  call loop_A_Q(G2(:,:,:,280),Q(:,14),ZERO,G3(:,:,:,339))
  call loop_AV_Q(G3(:,:,:,339),wf(:,-4),G3(:,:,:,340))
  call loop_A_Q(G3(:,:,:,340),Q(:,30),ZERO,G4(:,:,:,175))
  call loop_AZ_Q(G4(:,:,:,175),wf(:,0),G4(:,:,:,176),gZd)
  call check_last_A_Q(l_switch,G4(:,:,:,176),Q(:,31),ZERO,G5tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,4),ZERO,G1(:,:,:,124))
  call loop_QZ_A(G1(:,:,:,124),wf(:,-1),G1(:,:,:,125),gZu)
  call loop_Q_A(G1(:,:,:,125),Q(:,6),ZERO,G2(:,:,:,281))
  call loop_QV_A(G2(:,:,:,281),wf(:,5),G2(:,:,:,282))
  call loop_Q_A(G2(:,:,:,282),Q(:,30),ZERO,G3(:,:,:,341))
  call loop_QZ_A(G3(:,:,:,341),wf(:,0),G3(:,:,:,342),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,342),Q(:,31),ZERO,G4tensor(:,83))
  call loop_QV_A(G2(:,:,:,281),wf(:,-4),G2(:,:,:,283))
  call loop_Q_A(G2(:,:,:,283),Q(:,22),ZERO,G3(:,:,:,343))
  call loop_QV_A(G3(:,:,:,343),wf(:,-3),G3(:,:,:,344))
  call loop_Q_A(G3(:,:,:,344),Q(:,30),ZERO,G4(:,:,:,177))
  call loop_QZ_A(G4(:,:,:,177),wf(:,0),G4(:,:,:,178),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,178),Q(:,31),ZERO,G5tensor(:,89))
  call loop_QV_A(G2(:,:,:,281),wf(:,-3),G2(:,:,:,284))
  call loop_Q_A(G2(:,:,:,284),Q(:,14),ZERO,G3(:,:,:,345))
  call loop_QV_A(G3(:,:,:,345),wf(:,-4),G3(:,:,:,346))
  call loop_Q_A(G3(:,:,:,346),Q(:,30),ZERO,G4(:,:,:,179))
  call loop_QZ_A(G4(:,:,:,179),wf(:,0),G4(:,:,:,180),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,180),Q(:,31),ZERO,G5tensor(:,90))
  call loop_QZ_A(G1(:,:,:,124),wf(:,-1),G1(:,:,:,126),gZd)
  call loop_Q_A(G1(:,:,:,126),Q(:,6),ZERO,G2(:,:,:,285))
  call loop_QV_A(G2(:,:,:,285),wf(:,5),G2(:,:,:,286))
  call loop_Q_A(G2(:,:,:,286),Q(:,30),ZERO,G3(:,:,:,347))
  call loop_QZ_A(G3(:,:,:,347),wf(:,0),G3(:,:,:,348),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,348),Q(:,31),ZERO,G4tensor(:,84))
  call loop_QV_A(G2(:,:,:,285),wf(:,-4),G2(:,:,:,287))
  call loop_Q_A(G2(:,:,:,287),Q(:,22),ZERO,G3(:,:,:,349))
  call loop_QV_A(G3(:,:,:,349),wf(:,-3),G3(:,:,:,350))
  call loop_Q_A(G3(:,:,:,350),Q(:,30),ZERO,G4(:,:,:,181))
  call loop_QZ_A(G4(:,:,:,181),wf(:,0),G4(:,:,:,182),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,182),Q(:,31),ZERO,G5tensor(:,91))
  call loop_QV_A(G2(:,:,:,285),wf(:,-3),G2(:,:,:,288))
  call loop_Q_A(G2(:,:,:,288),Q(:,14),ZERO,G3(:,:,:,351))
  call loop_QV_A(G3(:,:,:,351),wf(:,-4),G3(:,:,:,352))
  call loop_Q_A(G3(:,:,:,352),Q(:,30),ZERO,G4(:,:,:,183))
  call loop_QZ_A(G4(:,:,:,183),wf(:,0),G4(:,:,:,184),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,184),Q(:,31),ZERO,G5tensor(:,92))
  call loop_QV_A(G1(:,:,:,124),wf(:,-4),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,20),ZERO,G2(:,:,:,289))
  call loop_QZ_A(G2(:,:,:,289),wf(:,-1),G2(:,:,:,290),gZu)
  call loop_Q_A(G2(:,:,:,290),Q(:,22),ZERO,G3(:,:,:,353))
  call loop_QV_A(G3(:,:,:,353),wf(:,-3),G3(:,:,:,354))
  call loop_Q_A(G3(:,:,:,354),Q(:,30),ZERO,G4(:,:,:,185))
  call loop_QZ_A(G4(:,:,:,185),wf(:,0),G4(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,186),Q(:,31),ZERO,G5tensor(:,93))
  call loop_QZ_A(G2(:,:,:,289),wf(:,-1),G2(:,:,:,291),gZd)
  call loop_Q_A(G2(:,:,:,291),Q(:,22),ZERO,G3(:,:,:,355))
  call loop_QV_A(G3(:,:,:,355),wf(:,-3),G3(:,:,:,356))
  call loop_Q_A(G3(:,:,:,356),Q(:,30),ZERO,G4(:,:,:,187))
  call loop_QZ_A(G4(:,:,:,187),wf(:,0),G4(:,:,:,188),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,188),Q(:,31),ZERO,G5tensor(:,94))
  call loop_QV_A(G1(:,:,:,124),wf(:,-3),G1(:,:,:,128))
  call loop_Q_A(G1(:,:,:,128),Q(:,12),ZERO,G2(:,:,:,292))
  call loop_QZ_A(G2(:,:,:,292),wf(:,-1),G2(:,:,:,293),gZu)
  call loop_Q_A(G2(:,:,:,293),Q(:,14),ZERO,G3(:,:,:,357))
  call loop_QV_A(G3(:,:,:,357),wf(:,-4),G3(:,:,:,358))
  call loop_Q_A(G3(:,:,:,358),Q(:,30),ZERO,G4(:,:,:,189))
  call loop_QZ_A(G4(:,:,:,189),wf(:,0),G4(:,:,:,190),gZu)
  call check_last_Q_A(l_switch,G4(:,:,:,190),Q(:,31),ZERO,G5tensor(:,95))
  call loop_QZ_A(G2(:,:,:,292),wf(:,-1),G2(:,:,:,294),gZd)
  call loop_Q_A(G2(:,:,:,294),Q(:,14),ZERO,G3(:,:,:,359))
  call loop_QV_A(G3(:,:,:,359),wf(:,-4),G3(:,:,:,360))
  call loop_Q_A(G3(:,:,:,360),Q(:,30),ZERO,G4(:,:,:,191))
  call loop_QZ_A(G4(:,:,:,191),wf(:,0),G4(:,:,:,192),gZd)
  call check_last_Q_A(l_switch,G4(:,:,:,192),Q(:,31),ZERO,G5tensor(:,96))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(10)) * den(5)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (CI*f(10) * den(5)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(10)) * den(5)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(3) = M(3) + (CI*f(10) * den(5)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(7)) * den(5)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(7) * den(5)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(7)) * den(5)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(7) * den(5)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(10) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(10)) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,5),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(10) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,3))
  M(3) = M(3) + (-(CI*f(10)) * den(6)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,6),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(7) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(7)) * den(6)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,4))
  M(1) = M(1) + (-(CI*f(10)) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(10) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,9),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(10)) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(3) = M(3) + (CI*f(10) * den(7)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,10),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(7)) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(7) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,11),T3sum(1:35,6))
  M(1) = M(1) + (-(CI*f(7)) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(3) = M(3) + (CI*f(7) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,12),T3sum(1:35,6))
  M(1) = M(1) + (f(11) * den(4)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,5),T4sum(1:70,1))
  M(3) = M(3) + (f(11) * den(4)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,9),T4sum(1:70,2))
  M(3) = M(3) + (f(8) * den(4)) * TI2_call(4,momenta_14,masses2_3,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (f(11) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,16),T4sum(1:70,3))
  M(3) = M(3) + (f(11) * den(4)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,22),T4sum(1:70,4))
  M(3) = M(3) + (f(8) * den(4)) * TI2_call(4,momenta_11,masses2_3,G4tensor(:,19),T4sum(1:70,4))
  M(3) = M(3) + (f(11) * den(4)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,17),T4sum(1:70,5))
  M(1) = M(1) + (f(11) * den(4)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,14),T4sum(1:70,5))
  M(3) = M(3) + (f(8) * den(4)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,23),T4sum(1:70,6))
  M(1) = M(1) + (f(8) * den(4)) * TI2_call(4,momenta_12,masses2_3,G4tensor(:,20),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,25),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,25),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,31),T4sum(1:70,8))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,31),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,37),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,37),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,43),T4sum(1:70,8))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,43),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,49),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,49),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,55),T4sum(1:70,9))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,55),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,61),T4sum(1:70,7))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,61),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,67),T4sum(1:70,9))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_6,masses2_3,G4tensor(:,67),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,26),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,26),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,32),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,32),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,38),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,38),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,44),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_7,masses2_4,G4tensor(:,44),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,50),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,50),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,56),T4sum(1:70,12))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,56),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,62),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,62),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,68),T4sum(1:70,12))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_7,masses2_3,G4tensor(:,68),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,73),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,73),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,2),T4sum(1:70,14))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,2),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,75),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,75),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,1),T4sum(1:70,14))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_15,masses2_4,G4tensor(:,1),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,74),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,74),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,4),T4sum(1:70,15))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,4),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,76),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_15,masses2_5,G4tensor(:,76),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(2) * den(1)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,3),T4sum(1:70,15))
  M(4) = M(4) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_15,masses2_3,G4tensor(:,3),T4sum(1:70,15))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,27),T4sum(1:70,16))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,27),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,33),T4sum(1:70,17))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,33),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,39),T4sum(1:70,16))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,39),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_4,G4tensor(:,45),T4sum(1:70,17))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,51),T4sum(1:70,16))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,51),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,57),T4sum(1:70,18))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,57),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,63),T4sum(1:70,16))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,63),T4sum(1:70,16))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,69),T4sum(1:70,18))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_3,G4tensor(:,69),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,28),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,28),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,34),T4sum(1:70,20))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,34),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,40),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,40),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,46),T4sum(1:70,20))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,46),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,52),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,52),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,58),T4sum(1:70,21))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,58),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,64),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,64),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,70),T4sum(1:70,21))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_3,G4tensor(:,70),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,77),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,77),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,8),T4sum(1:70,23))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,8),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,79),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,79),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,6),T4sum(1:70,23))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_13,masses2_4,G4tensor(:,6),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,78),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,78),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,12),T4sum(1:70,24))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,12),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,80),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(3) * den(2)) * TI2_call(4,momenta_13,masses2_5,G4tensor(:,80),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,10),T4sum(1:70,24))
  M(4) = M(4) + (CI*f(2) * den(2)) * TI2_call(4,momenta_13,masses2_3,G4tensor(:,10),T4sum(1:70,24))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,29),T4sum(1:70,25))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,29),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,35),T4sum(1:70,26))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,35),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,41),T4sum(1:70,25))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,41),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,47),T4sum(1:70,26))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_9,masses2_4,G4tensor(:,47),T4sum(1:70,26))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,53),T4sum(1:70,25))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,53),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,59),T4sum(1:70,27))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,59),T4sum(1:70,27))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,65),T4sum(1:70,25))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,65),T4sum(1:70,25))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,71),T4sum(1:70,27))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_9,masses2_3,G4tensor(:,71),T4sum(1:70,27))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,30),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,30),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,36),T4sum(1:70,29))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,36),T4sum(1:70,29))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,42),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,42),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,48),T4sum(1:70,29))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,48),T4sum(1:70,29))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,54),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,54),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,60),T4sum(1:70,30))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,60),T4sum(1:70,30))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,66),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,66),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,72),T4sum(1:70,30))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_4,masses2_3,G4tensor(:,72),T4sum(1:70,30))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,81),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,81),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,18),T4sum(1:70,32))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,18),T4sum(1:70,32))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,83),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,83),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,15),T4sum(1:70,32))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_10,masses2_4,G4tensor(:,15),T4sum(1:70,32))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,82),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,82),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,24),T4sum(1:70,33))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,24),T4sum(1:70,33))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,84),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_10,masses2_5,G4tensor(:,84),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(2) * den(3)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,21),T4sum(1:70,33))
  M(4) = M(4) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_10,masses2_3,G4tensor(:,21),T4sum(1:70,33))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,27),T5sum(1:126,1))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,33),T5sum(1:126,2))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,39),T5sum(1:126,1))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_19,masses2_7,G5tensor(:,45),T5sum(1:126,2))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,51),T5sum(1:126,1))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_19,masses2_6,G5tensor(:,57),T5sum(1:126,3))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_19,masses2_8,G5tensor(:,63),T5sum(1:126,1))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_19,masses2_6,G5tensor(:,69),T5sum(1:126,3))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,25),T5sum(1:126,4))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,31),T5sum(1:126,5))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,37),T5sum(1:126,4))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_21,masses2_7,G5tensor(:,43),T5sum(1:126,5))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,49),T5sum(1:126,4))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_21,masses2_6,G5tensor(:,55),T5sum(1:126,6))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_21,masses2_8,G5tensor(:,61),T5sum(1:126,4))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_21,masses2_6,G5tensor(:,67),T5sum(1:126,6))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,29),T5sum(1:126,7))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,35),T5sum(1:126,8))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,41),T5sum(1:126,7))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_17,masses2_7,G5tensor(:,47),T5sum(1:126,8))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,53),T5sum(1:126,7))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_17,masses2_6,G5tensor(:,59),T5sum(1:126,9))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_17,masses2_8,G5tensor(:,65),T5sum(1:126,7))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_17,masses2_6,G5tensor(:,71),T5sum(1:126,9))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,26),T5sum(1:126,10))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,32),T5sum(1:126,11))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,38),T5sum(1:126,10))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_20,masses2_7,G5tensor(:,44),T5sum(1:126,11))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,50),T5sum(1:126,10))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_20,masses2_6,G5tensor(:,56),T5sum(1:126,12))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_20,masses2_8,G5tensor(:,62),T5sum(1:126,10))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_20,masses2_6,G5tensor(:,68),T5sum(1:126,12))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,30),T5sum(1:126,13))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,36),T5sum(1:126,14))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,42),T5sum(1:126,13))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_16,masses2_7,G5tensor(:,48),T5sum(1:126,14))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,54),T5sum(1:126,13))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_16,masses2_6,G5tensor(:,60),T5sum(1:126,15))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_16,masses2_8,G5tensor(:,66),T5sum(1:126,13))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_16,masses2_6,G5tensor(:,72),T5sum(1:126,15))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,28),T5sum(1:126,16))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,34),T5sum(1:126,17))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,40),T5sum(1:126,16))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_18,masses2_7,G5tensor(:,46),T5sum(1:126,17))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,52),T5sum(1:126,16))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_18,masses2_6,G5tensor(:,58),T5sum(1:126,18))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_18,masses2_8,G5tensor(:,64),T5sum(1:126,16))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_18,masses2_6,G5tensor(:,70),T5sum(1:126,18))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,81),T5sum(1:126,19))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,15),T5sum(1:126,20))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,89),T5sum(1:126,19))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_23,masses2_7,G5tensor(:,11),T5sum(1:126,20))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,83),T5sum(1:126,19))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_23,masses2_6,G5tensor(:,23),T5sum(1:126,21))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_23,masses2_8,G5tensor(:,91),T5sum(1:126,19))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_23,masses2_6,G5tensor(:,19),T5sum(1:126,21))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,85),T5sum(1:126,22))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,14),T5sum(1:126,23))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,93),T5sum(1:126,22))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_25,masses2_7,G5tensor(:,10),T5sum(1:126,23))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,86),T5sum(1:126,22))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_25,masses2_6,G5tensor(:,22),T5sum(1:126,24))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_25,masses2_8,G5tensor(:,94),T5sum(1:126,22))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_25,masses2_6,G5tensor(:,18),T5sum(1:126,24))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,82),T5sum(1:126,25))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,16),T5sum(1:126,26))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,90),T5sum(1:126,25))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_22,masses2_7,G5tensor(:,12),T5sum(1:126,26))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,84),T5sum(1:126,25))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_22,masses2_6,G5tensor(:,24),T5sum(1:126,27))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_22,masses2_8,G5tensor(:,92),T5sum(1:126,25))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_22,masses2_6,G5tensor(:,20),T5sum(1:126,27))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,87),T5sum(1:126,28))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,13),T5sum(1:126,29))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,95),T5sum(1:126,28))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_24,masses2_7,G5tensor(:,9),T5sum(1:126,29))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,88),T5sum(1:126,28))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_24,masses2_6,G5tensor(:,21),T5sum(1:126,30))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_24,masses2_8,G5tensor(:,96),T5sum(1:126,28))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_24,masses2_6,G5tensor(:,17),T5sum(1:126,30))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,73),T5sum(1:126,31))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,4),T5sum(1:126,32))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,77),T5sum(1:126,31))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_26,masses2_7,G5tensor(:,2),T5sum(1:126,32))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,74),T5sum(1:126,31))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,8),T5sum(1:126,33))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_26,masses2_8,G5tensor(:,78),T5sum(1:126,31))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_26,masses2_6,G5tensor(:,6),T5sum(1:126,33))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,75),T5sum(1:126,34))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,3),T5sum(1:126,35))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,79),T5sum(1:126,34))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_27,masses2_7,G5tensor(:,1),T5sum(1:126,35))
  M(4) = M(4) + (-f(5)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,76),T5sum(1:126,34))
  M(4) = M(4) + (-f(4)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,7),T5sum(1:126,36))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_27,masses2_8,G5tensor(:,80),T5sum(1:126,34))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_27,masses2_6,G5tensor(:,5),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_zzggg_4_/**/REALKIND
