
module ol_vamp_1_ppvvj2_wwxggg_5_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_wwxggg_5.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_wwxggg_5.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_wwxggg_5_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_wwxggg_5_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(4)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,23) :: G0
  complex(REALKIND), dimension(4,5,4,94) :: G1
  complex(REALKIND), dimension(4,15,4,228) :: G2
  complex(REALKIND), dimension(4,35,4,240) :: G3
  complex(REALKIND), dimension(4,70,4,96) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,54,72))
    allocate(G4tensorhel(70,90,72))
    allocate(G5tensorhel(126,48,72))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,13),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,3))
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),MT,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,5),G2(:,:,:,4),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),MT,G3tensor(:,3))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,14),MB,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-4),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,30),MB,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),MT,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,-4),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,28),MT,G2(:,:,:,7))
  call loop_QS_A(G2(:,:,:,7),wf(:,13),G2(:,:,:,8),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MT,G3tensor(:,4))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,9))
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,31),MT,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,7),wf(:,5),G2(:,:,:,10),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,31),MT,G3tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,6))
  call loop_AV_Q(G1(:,:,:,6),wf(:,-4),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,28),MB,G2(:,:,:,11))
  call loop_AS_Q(G2(:,:,:,11),wf(:,13),G2(:,:,:,12),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,12),Q(:,31),MB,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,11),wf(:,1),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,31),MB,G3tensor(:,8))
  call loop_AZ_Q(G2(:,:,:,11),wf(:,5),G2(:,:,:,14),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,14),Q(:,31),MB,G3tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,-4),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,28),MB,G2(:,:,:,15))
  call loop_QS_A(G2(:,:,:,15),wf(:,13),G2(:,:,:,16),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,31),MB,G3tensor(:,10))
  call loop_QV_A(G2(:,:,:,15),wf(:,1),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,31),MB,G3tensor(:,11))
  call loop_QZ_A(G2(:,:,:,15),wf(:,5),G2(:,:,:,18),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,31),MB,G3tensor(:,12))
  call loop_QW_A(G1(:,:,:,8),wf(:,-1),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,14),MT,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,30),MT,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,31),MB,G4tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,28),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,31),ZERO,G3tensor(:,13))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,5),G2(:,:,:,23),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,31),ZERO,G3tensor(:,14))
  call loop_AZ_Q(G2(:,:,:,21),wf(:,5),G2(:,:,:,24),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,31),ZERO,G3tensor(:,15))
  call loop_AW_Q(G1(:,:,:,11),wf(:,-1),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,14),ZERO,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,30),ZERO,G3(:,:,:,5))
  call loop_AW_Q(G3(:,:,:,5),wf(:,0),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,12),ZERO,G1(:,:,:,14))
  call loop_QV_A(G1(:,:,:,14),wf(:,-4),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,28),ZERO,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,1),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,31),ZERO,G3tensor(:,16))
  call loop_QZ_A(G2(:,:,:,27),wf(:,5),G2(:,:,:,29),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,29),Q(:,31),ZERO,G3tensor(:,17))
  call loop_QZ_A(G2(:,:,:,27),wf(:,5),G2(:,:,:,30),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,31),ZERO,G3tensor(:,18))
  call loop_QW_A(G1(:,:,:,14),wf(:,-1),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,14),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-4),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,30),ZERO,G3(:,:,:,7))
  call loop_QW_A(G3(:,:,:,7),wf(:,0),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,8),MT,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,9),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,28),MT,G2(:,:,:,33))
  call loop_QS_A(G2(:,:,:,33),wf(:,13),G2(:,:,:,34),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),MT,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,33),wf(:,1),G2(:,:,:,35))
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,31),MT,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,33),wf(:,5),G2(:,:,:,36),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),MT,G3tensor(:,21))
  call loop_QV_A(G1(:,:,:,17),wf(:,-2),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,12),MT,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,28),MT,G3(:,:,:,9))
  call loop_QS_A(G3(:,:,:,9),wf(:,13),G3(:,:,:,10),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,31),MT,G4tensor(:,5))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,11))
  call check_last_Q_A(l_switch,G3(:,:,:,11),Q(:,31),MT,G4tensor(:,6))
  call loop_QZ_A(G3(:,:,:,9),wf(:,5),G3(:,:,:,12),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,31),MT,G4tensor(:,7))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,9),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,28),MT,G2(:,:,:,39))
  call loop_AS_Q(G2(:,:,:,39),wf(:,13),G2(:,:,:,40),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,31),MT,G3tensor(:,22))
  call loop_AV_Q(G2(:,:,:,39),wf(:,1),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,31),MT,G3tensor(:,23))
  call loop_AZ_Q(G2(:,:,:,39),wf(:,5),G2(:,:,:,42),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,31),MT,G3tensor(:,24))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-2),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,12),MT,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-4),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,28),MT,G3(:,:,:,13))
  call loop_AS_Q(G3(:,:,:,13),wf(:,13),G3(:,:,:,14),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,31),MT,G4tensor(:,8))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,15))
  call check_last_A_Q(l_switch,G3(:,:,:,15),Q(:,31),MT,G4tensor(:,9))
  call loop_AZ_Q(G3(:,:,:,13),wf(:,5),G3(:,:,:,16),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,31),MT,G4tensor(:,10))
  call loop_AW_Q(G2(:,:,:,43),wf(:,-1),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,14),MB,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-4),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,30),MB,G4(:,:,:,1))
  call loop_AW_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),MT,G5tensor(:,1))
  call loop_AW_Q(G1(:,:,:,20),wf(:,-1),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,10),MB,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,9),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,30),MB,G3(:,:,:,19))
  call loop_AW_Q(G3(:,:,:,19),wf(:,0),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),MT,G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,46),wf(:,-2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,14),MB,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-4),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),MB,G4(:,:,:,3))
  call loop_AW_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),MT,G5tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,8),MB,G1(:,:,:,24))
  call loop_QV_A(G1(:,:,:,24),wf(:,9),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,28),MB,G2(:,:,:,49))
  call loop_QS_A(G2(:,:,:,49),wf(:,13),G2(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,31),MB,G3tensor(:,25))
  call loop_QV_A(G2(:,:,:,49),wf(:,1),G2(:,:,:,51))
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,31),MB,G3tensor(:,26))
  call loop_QZ_A(G2(:,:,:,49),wf(:,5),G2(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,31),MB,G3tensor(:,27))
  call loop_QV_A(G1(:,:,:,24),wf(:,-2),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,12),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,28),MB,G3(:,:,:,23))
  call loop_QS_A(G3(:,:,:,23),wf(:,13),G3(:,:,:,24),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,31),MB,G4tensor(:,12))
  call loop_QV_A(G3(:,:,:,23),wf(:,1),G3(:,:,:,25))
  call check_last_Q_A(l_switch,G3(:,:,:,25),Q(:,31),MB,G4tensor(:,13))
  call loop_QZ_A(G3(:,:,:,23),wf(:,5),G3(:,:,:,26),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),MB,G4tensor(:,14))
  call loop_QW_A(G2(:,:,:,53),wf(:,-1),G2(:,:,:,55))
  call loop_Q_A(G2(:,:,:,55),Q(:,14),MT,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,-4),G3(:,:,:,28))
  call loop_Q_A(G3(:,:,:,28),Q(:,30),MT,G4(:,:,:,5))
  call loop_QW_A(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_Q_A(l_switch,G4(:,:,:,6),Q(:,31),MB,G5tensor(:,3))
  call loop_QW_A(G1(:,:,:,24),wf(:,-1),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,10),MT,G2(:,:,:,56))
  call loop_QV_A(G2(:,:,:,56),wf(:,9),G2(:,:,:,57))
  call loop_Q_A(G2(:,:,:,57),Q(:,30),MT,G3(:,:,:,29))
  call loop_QW_A(G3(:,:,:,29),wf(:,0),G3(:,:,:,30))
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,31),MB,G4tensor(:,15))
  call loop_QV_A(G2(:,:,:,56),wf(:,-2),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,14),MT,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-4),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,30),MT,G4(:,:,:,7))
  call loop_QW_A(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_Q_A(l_switch,G4(:,:,:,8),Q(:,31),MB,G5tensor(:,4))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,8),MB,G1(:,:,:,28))
  call loop_AV_Q(G1(:,:,:,28),wf(:,9),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,28),MB,G2(:,:,:,59))
  call loop_AS_Q(G2(:,:,:,59),wf(:,13),G2(:,:,:,60),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,60),Q(:,31),MB,G3tensor(:,28))
  call loop_AV_Q(G2(:,:,:,59),wf(:,1),G2(:,:,:,61))
  call check_last_A_Q(l_switch,G2(:,:,:,61),Q(:,31),MB,G3tensor(:,29))
  call loop_AZ_Q(G2(:,:,:,59),wf(:,5),G2(:,:,:,62),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,62),Q(:,31),MB,G3tensor(:,30))
  call loop_AV_Q(G1(:,:,:,28),wf(:,-2),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,12),MB,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,-4),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,28),MB,G3(:,:,:,33))
  call loop_AS_Q(G3(:,:,:,33),wf(:,13),G3(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,31),MB,G4tensor(:,16))
  call loop_AV_Q(G3(:,:,:,33),wf(:,1),G3(:,:,:,35))
  call check_last_A_Q(l_switch,G3(:,:,:,35),Q(:,31),MB,G4tensor(:,17))
  call loop_AZ_Q(G3(:,:,:,33),wf(:,5),G3(:,:,:,36),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,31),MB,G4tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,8),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,9),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,28),ZERO,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,1),G2(:,:,:,66))
  call check_last_Q_A(l_switch,G2(:,:,:,66),Q(:,31),ZERO,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,65),wf(:,5),G2(:,:,:,67),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,67),Q(:,31),ZERO,G3tensor(:,32))
  call loop_QZ_A(G2(:,:,:,65),wf(:,5),G2(:,:,:,68),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,31),ZERO,G3tensor(:,33))
  call loop_QV_A(G1(:,:,:,31),wf(:,-2),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,12),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,28),ZERO,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,31),ZERO,G4tensor(:,19))
  call loop_QZ_A(G3(:,:,:,37),wf(:,5),G3(:,:,:,39),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,39),Q(:,31),ZERO,G4tensor(:,20))
  call loop_QZ_A(G3(:,:,:,37),wf(:,5),G3(:,:,:,40),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,31),ZERO,G4tensor(:,21))
  call loop_QW_A(G2(:,:,:,69),wf(:,-1),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,14),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-4),G3(:,:,:,42))
  call loop_Q_A(G3(:,:,:,42),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_QW_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_QW_A(G1(:,:,:,31),wf(:,-1),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,10),ZERO,G2(:,:,:,72))
  call loop_QV_A(G2(:,:,:,72),wf(:,9),G2(:,:,:,73))
  call loop_Q_A(G2(:,:,:,73),Q(:,30),ZERO,G3(:,:,:,43))
  call loop_QW_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,31),ZERO,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,72),wf(:,-2),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,14),ZERO,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-4),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_QW_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,8),ZERO,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,9),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,28),ZERO,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,1),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,31),ZERO,G3tensor(:,34))
  call loop_AZ_Q(G2(:,:,:,75),wf(:,5),G2(:,:,:,77),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,31),ZERO,G3tensor(:,35))
  call loop_AZ_Q(G2(:,:,:,75),wf(:,5),G2(:,:,:,78),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,31),ZERO,G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-2),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,12),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,28),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,1),G3(:,:,:,48))
  call check_last_A_Q(l_switch,G3(:,:,:,48),Q(:,31),ZERO,G4tensor(:,23))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,5),G3(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,49),Q(:,31),ZERO,G4tensor(:,24))
  call loop_AZ_Q(G3(:,:,:,47),wf(:,5),G3(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,31),ZERO,G4tensor(:,25))
  call loop_AW_Q(G2(:,:,:,79),wf(:,-1),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,14),ZERO,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,-4),G3(:,:,:,52))
  call loop_A_Q(G3(:,:,:,52),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_AW_Q(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_A_Q(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_AW_Q(G1(:,:,:,35),wf(:,-1),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,10),ZERO,G2(:,:,:,82))
  call loop_AV_Q(G2(:,:,:,82),wf(:,9),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,30),ZERO,G3(:,:,:,53))
  call loop_AW_Q(G3(:,:,:,53),wf(:,0),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,31),ZERO,G4tensor(:,26))
  call loop_AV_Q(G2(:,:,:,82),wf(:,-2),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,14),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_AW_Q(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_A_Q(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,4),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,11),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,28),MT,G2(:,:,:,85))
  call loop_QS_A(G2(:,:,:,85),wf(:,13),G2(:,:,:,86),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,86),Q(:,31),MT,G3tensor(:,37))
  call loop_QV_A(G2(:,:,:,85),wf(:,1),G2(:,:,:,87))
  call check_last_Q_A(l_switch,G2(:,:,:,87),Q(:,31),MT,G3tensor(:,38))
  call loop_QZ_A(G2(:,:,:,85),wf(:,5),G2(:,:,:,88),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,31),MT,G3tensor(:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,-3),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,12),MT,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,-4),G2(:,:,:,90))
  call loop_Q_A(G2(:,:,:,90),Q(:,28),MT,G3(:,:,:,57))
  call loop_QS_A(G3(:,:,:,57),wf(:,13),G3(:,:,:,58),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,58),Q(:,31),MT,G4tensor(:,27))
  call loop_QV_A(G3(:,:,:,57),wf(:,1),G3(:,:,:,59))
  call check_last_Q_A(l_switch,G3(:,:,:,59),Q(:,31),MT,G4tensor(:,28))
  call loop_QZ_A(G3(:,:,:,57),wf(:,5),G3(:,:,:,60),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,31),MT,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,20),MT,G2(:,:,:,91))
  call loop_QV_A(G2(:,:,:,91),wf(:,-3),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,28),MT,G3(:,:,:,61))
  call loop_QS_A(G3(:,:,:,61),wf(:,13),G3(:,:,:,62),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,31),MT,G4tensor(:,30))
  call loop_QV_A(G3(:,:,:,61),wf(:,1),G3(:,:,:,63))
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,31),MT,G4tensor(:,31))
  call loop_QZ_A(G3(:,:,:,61),wf(:,5),G3(:,:,:,64),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,31),MT,G4tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,11),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,28),MT,G2(:,:,:,93))
  call loop_AS_Q(G2(:,:,:,93),wf(:,13),G2(:,:,:,94),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,31),MT,G3tensor(:,40))
  call loop_AV_Q(G2(:,:,:,93),wf(:,1),G2(:,:,:,95))
  call check_last_A_Q(l_switch,G2(:,:,:,95),Q(:,31),MT,G3tensor(:,41))
  call loop_AZ_Q(G2(:,:,:,93),wf(:,5),G2(:,:,:,96),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,96),Q(:,31),MT,G3tensor(:,42))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,12),MT,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-4),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,28),MT,G3(:,:,:,65))
  call loop_AS_Q(G3(:,:,:,65),wf(:,13),G3(:,:,:,66),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,31),MT,G4tensor(:,33))
  call loop_AV_Q(G3(:,:,:,65),wf(:,1),G3(:,:,:,67))
  call check_last_A_Q(l_switch,G3(:,:,:,67),Q(:,31),MT,G4tensor(:,34))
  call loop_AZ_Q(G3(:,:,:,65),wf(:,5),G3(:,:,:,68),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,31),MT,G4tensor(:,35))
  call loop_AW_Q(G2(:,:,:,97),wf(:,-1),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,14),MB,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,30),MB,G4(:,:,:,17))
  call loop_AW_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,31),MT,G5tensor(:,9))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,20),MT,G2(:,:,:,100))
  call loop_AV_Q(G2(:,:,:,100),wf(:,-3),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,28),MT,G3(:,:,:,71))
  call loop_AS_Q(G3(:,:,:,71),wf(:,13),G3(:,:,:,72),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,72),Q(:,31),MT,G4tensor(:,36))
  call loop_AV_Q(G3(:,:,:,71),wf(:,1),G3(:,:,:,73))
  call check_last_A_Q(l_switch,G3(:,:,:,73),Q(:,31),MT,G4tensor(:,37))
  call loop_AZ_Q(G3(:,:,:,71),wf(:,5),G3(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,74),Q(:,31),MT,G4tensor(:,38))
  call loop_AW_Q(G2(:,:,:,100),wf(:,-1),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,22),MB,G3(:,:,:,75))
  call loop_AV_Q(G3(:,:,:,75),wf(:,-3),G3(:,:,:,76))
  call loop_A_Q(G3(:,:,:,76),Q(:,30),MB,G4(:,:,:,19))
  call loop_AW_Q(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,31),MT,G5tensor(:,10))
  call loop_AW_Q(G1(:,:,:,43),wf(:,-1),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,6),MB,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,11),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,30),MB,G3(:,:,:,77))
  call loop_AW_Q(G3(:,:,:,77),wf(:,0),G3(:,:,:,78))
  call check_last_A_Q(l_switch,G3(:,:,:,78),Q(:,31),MT,G4tensor(:,39))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-4),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,22),MB,G3(:,:,:,79))
  call loop_AV_Q(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_A_Q(G3(:,:,:,80),Q(:,30),MB,G4(:,:,:,21))
  call loop_AW_Q(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,31),MT,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-3),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,14),MB,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-4),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,30),MB,G4(:,:,:,23))
  call loop_AW_Q(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,31),MT,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,4),MB,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,11),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,28),MB,G2(:,:,:,107))
  call loop_QS_A(G2(:,:,:,107),wf(:,13),G2(:,:,:,108),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,31),MB,G3tensor(:,43))
  call loop_QV_A(G2(:,:,:,107),wf(:,1),G2(:,:,:,109))
  call check_last_Q_A(l_switch,G2(:,:,:,109),Q(:,31),MB,G3tensor(:,44))
  call loop_QZ_A(G2(:,:,:,107),wf(:,5),G2(:,:,:,110),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,31),MB,G3tensor(:,45))
  call loop_QV_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,50))
  call loop_Q_A(G1(:,:,:,50),Q(:,12),MB,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call loop_Q_A(G2(:,:,:,112),Q(:,28),MB,G3(:,:,:,83))
  call loop_QS_A(G3(:,:,:,83),wf(:,13),G3(:,:,:,84),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,31),MB,G4tensor(:,40))
  call loop_QV_A(G3(:,:,:,83),wf(:,1),G3(:,:,:,85))
  call check_last_Q_A(l_switch,G3(:,:,:,85),Q(:,31),MB,G4tensor(:,41))
  call loop_QZ_A(G3(:,:,:,83),wf(:,5),G3(:,:,:,86),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,86),Q(:,31),MB,G4tensor(:,42))
  call loop_QW_A(G2(:,:,:,111),wf(:,-1),G2(:,:,:,113))
  call loop_Q_A(G2(:,:,:,113),Q(:,14),MT,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,30),MT,G4(:,:,:,25))
  call loop_QW_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,31),MB,G5tensor(:,13))
  call loop_QV_A(G1(:,:,:,48),wf(:,-4),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,20),MB,G2(:,:,:,114))
  call loop_QV_A(G2(:,:,:,114),wf(:,-3),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,28),MB,G3(:,:,:,89))
  call loop_QS_A(G3(:,:,:,89),wf(:,13),G3(:,:,:,90),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,31),MB,G4tensor(:,43))
  call loop_QV_A(G3(:,:,:,89),wf(:,1),G3(:,:,:,91))
  call check_last_Q_A(l_switch,G3(:,:,:,91),Q(:,31),MB,G4tensor(:,44))
  call loop_QZ_A(G3(:,:,:,89),wf(:,5),G3(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,31),MB,G4tensor(:,45))
  call loop_QW_A(G2(:,:,:,114),wf(:,-1),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,22),MT,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,30),MT,G4(:,:,:,27))
  call loop_QW_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,31),MB,G5tensor(:,14))
  call loop_QW_A(G1(:,:,:,48),wf(:,-1),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,6),MT,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,11),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,30),MT,G3(:,:,:,95))
  call loop_QW_A(G3(:,:,:,95),wf(:,0),G3(:,:,:,96))
  call check_last_Q_A(l_switch,G3(:,:,:,96),Q(:,31),MB,G4tensor(:,46))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,22),MT,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,-3),G3(:,:,:,98))
  call loop_Q_A(G3(:,:,:,98),Q(:,30),MT,G4(:,:,:,29))
  call loop_QW_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),MB,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,117),wf(:,-3),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,14),MT,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_Q_A(G3(:,:,:,100),Q(:,30),MT,G4(:,:,:,31))
  call loop_QW_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),MB,G5tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,4),MB,G1(:,:,:,53))
  call loop_AV_Q(G1(:,:,:,53),wf(:,11),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,28),MB,G2(:,:,:,121))
  call loop_AS_Q(G2(:,:,:,121),wf(:,13),G2(:,:,:,122),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,122),Q(:,31),MB,G3tensor(:,46))
  call loop_AV_Q(G2(:,:,:,121),wf(:,1),G2(:,:,:,123))
  call check_last_A_Q(l_switch,G2(:,:,:,123),Q(:,31),MB,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,121),wf(:,5),G2(:,:,:,124),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,124),Q(:,31),MB,G3tensor(:,48))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-3),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,12),MB,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,-4),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,28),MB,G3(:,:,:,101))
  call loop_AS_Q(G3(:,:,:,101),wf(:,13),G3(:,:,:,102),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,31),MB,G4tensor(:,47))
  call loop_AV_Q(G3(:,:,:,101),wf(:,1),G3(:,:,:,103))
  call check_last_A_Q(l_switch,G3(:,:,:,103),Q(:,31),MB,G4tensor(:,48))
  call loop_AZ_Q(G3(:,:,:,101),wf(:,5),G3(:,:,:,104),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,31),MB,G4tensor(:,49))
  call loop_AV_Q(G1(:,:,:,53),wf(:,-4),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,20),MB,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-3),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,28),MB,G3(:,:,:,105))
  call loop_AS_Q(G3(:,:,:,105),wf(:,13),G3(:,:,:,106),gH)
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,31),MB,G4tensor(:,50))
  call loop_AV_Q(G3(:,:,:,105),wf(:,1),G3(:,:,:,107))
  call check_last_A_Q(l_switch,G3(:,:,:,107),Q(:,31),MB,G4tensor(:,51))
  call loop_AZ_Q(G3(:,:,:,105),wf(:,5),G3(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,108),Q(:,31),MB,G4tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,4),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,11),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,28),ZERO,G2(:,:,:,129))
  call loop_QV_A(G2(:,:,:,129),wf(:,1),G2(:,:,:,130))
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,31),ZERO,G3tensor(:,49))
  call loop_QZ_A(G2(:,:,:,129),wf(:,5),G2(:,:,:,131),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,31),ZERO,G3tensor(:,50))
  call loop_QZ_A(G2(:,:,:,129),wf(:,5),G2(:,:,:,132),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,31),ZERO,G3tensor(:,51))
  call loop_QV_A(G1(:,:,:,57),wf(:,-3),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,12),ZERO,G2(:,:,:,133))
  call loop_QV_A(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,28),ZERO,G3(:,:,:,109))
  call loop_QV_A(G3(:,:,:,109),wf(:,1),G3(:,:,:,110))
  call check_last_Q_A(l_switch,G3(:,:,:,110),Q(:,31),ZERO,G4tensor(:,53))
  call loop_QZ_A(G3(:,:,:,109),wf(:,5),G3(:,:,:,111),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,111),Q(:,31),ZERO,G4tensor(:,54))
  call loop_QZ_A(G3(:,:,:,109),wf(:,5),G3(:,:,:,112),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,112),Q(:,31),ZERO,G4tensor(:,55))
  call loop_QW_A(G2(:,:,:,133),wf(:,-1),G2(:,:,:,135))
  call loop_Q_A(G2(:,:,:,135),Q(:,14),ZERO,G3(:,:,:,113))
  call loop_QV_A(G3(:,:,:,113),wf(:,-4),G3(:,:,:,114))
  call loop_Q_A(G3(:,:,:,114),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_QW_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_QV_A(G1(:,:,:,57),wf(:,-4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,20),ZERO,G2(:,:,:,136))
  call loop_QV_A(G2(:,:,:,136),wf(:,-3),G2(:,:,:,137))
  call loop_Q_A(G2(:,:,:,137),Q(:,28),ZERO,G3(:,:,:,115))
  call loop_QV_A(G3(:,:,:,115),wf(:,1),G3(:,:,:,116))
  call check_last_Q_A(l_switch,G3(:,:,:,116),Q(:,31),ZERO,G4tensor(:,56))
  call loop_QZ_A(G3(:,:,:,115),wf(:,5),G3(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,117),Q(:,31),ZERO,G4tensor(:,57))
  call loop_QZ_A(G3(:,:,:,115),wf(:,5),G3(:,:,:,118),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,31),ZERO,G4tensor(:,58))
  call loop_QW_A(G2(:,:,:,136),wf(:,-1),G2(:,:,:,138))
  call loop_Q_A(G2(:,:,:,138),Q(:,22),ZERO,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-3),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_QW_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_QW_A(G1(:,:,:,57),wf(:,-1),G1(:,:,:,61))
  call loop_Q_A(G1(:,:,:,61),Q(:,6),ZERO,G2(:,:,:,139))
  call loop_QV_A(G2(:,:,:,139),wf(:,11),G2(:,:,:,140))
  call loop_Q_A(G2(:,:,:,140),Q(:,30),ZERO,G3(:,:,:,121))
  call loop_QW_A(G3(:,:,:,121),wf(:,0),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,31),ZERO,G4tensor(:,59))
  call loop_QV_A(G2(:,:,:,139),wf(:,-4),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,22),ZERO,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-3),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_QW_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,139),wf(:,-3),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,14),ZERO,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-4),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_QW_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,4),ZERO,G1(:,:,:,62))
  call loop_AV_Q(G1(:,:,:,62),wf(:,11),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,28),ZERO,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,1),G2(:,:,:,144))
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,31),ZERO,G3tensor(:,52))
  call loop_AZ_Q(G2(:,:,:,143),wf(:,5),G2(:,:,:,145),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,145),Q(:,31),ZERO,G3tensor(:,53))
  call loop_AZ_Q(G2(:,:,:,143),wf(:,5),G2(:,:,:,146),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,146),Q(:,31),ZERO,G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-3),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,12),ZERO,G2(:,:,:,147))
  call loop_AV_Q(G2(:,:,:,147),wf(:,-4),G2(:,:,:,148))
  call loop_A_Q(G2(:,:,:,148),Q(:,28),ZERO,G3(:,:,:,127))
  call loop_AV_Q(G3(:,:,:,127),wf(:,1),G3(:,:,:,128))
  call check_last_A_Q(l_switch,G3(:,:,:,128),Q(:,31),ZERO,G4tensor(:,60))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,5),G3(:,:,:,129),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,129),Q(:,31),ZERO,G4tensor(:,61))
  call loop_AZ_Q(G3(:,:,:,127),wf(:,5),G3(:,:,:,130),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,31),ZERO,G4tensor(:,62))
  call loop_AW_Q(G2(:,:,:,147),wf(:,-1),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,14),ZERO,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-4),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,30),ZERO,G4(:,:,:,41))
  call loop_AW_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,31),ZERO,G5tensor(:,21))
  call loop_AV_Q(G1(:,:,:,62),wf(:,-4),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,20),ZERO,G2(:,:,:,150))
  call loop_AV_Q(G2(:,:,:,150),wf(:,-3),G2(:,:,:,151))
  call loop_A_Q(G2(:,:,:,151),Q(:,28),ZERO,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,1),G3(:,:,:,134))
  call check_last_A_Q(l_switch,G3(:,:,:,134),Q(:,31),ZERO,G4tensor(:,63))
  call loop_AZ_Q(G3(:,:,:,133),wf(:,5),G3(:,:,:,135),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,135),Q(:,31),ZERO,G4tensor(:,64))
  call loop_AZ_Q(G3(:,:,:,133),wf(:,5),G3(:,:,:,136),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,31),ZERO,G4tensor(:,65))
  call loop_AW_Q(G2(:,:,:,150),wf(:,-1),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,22),ZERO,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-3),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,30),ZERO,G4(:,:,:,43))
  call loop_AW_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,31),ZERO,G5tensor(:,22))
  call loop_AW_Q(G1(:,:,:,62),wf(:,-1),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,6),ZERO,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,11),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,30),ZERO,G3(:,:,:,139))
  call loop_AW_Q(G3(:,:,:,139),wf(:,0),G3(:,:,:,140))
  call check_last_A_Q(l_switch,G3(:,:,:,140),Q(:,31),ZERO,G4tensor(:,66))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-4),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,22),ZERO,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,30),ZERO,G4(:,:,:,45))
  call loop_AW_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,31),ZERO,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-3),G2(:,:,:,156))
  call loop_A_Q(G2(:,:,:,156),Q(:,14),ZERO,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-4),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,30),ZERO,G4(:,:,:,47))
  call loop_AW_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,31),ZERO,G5tensor(:,24))
  call loop_QW_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,2),ZERO,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,7),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,14),ZERO,G2(:,:,:,157))
  call loop_QV_A(G2(:,:,:,157),wf(:,-4),G2(:,:,:,158))
  call loop_Q_A(G2(:,:,:,158),Q(:,30),ZERO,G3(:,:,:,145))
  call loop_QW_A(G3(:,:,:,145),wf(:,0),G3(:,:,:,146))
  call check_last_Q_A(l_switch,G3(:,:,:,146),Q(:,31),ZERO,G4tensor(:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,18),ZERO,G2(:,:,:,159))
  call loop_QV_A(G2(:,:,:,159),wf(:,7),G2(:,:,:,160))
  call loop_Q_A(G2(:,:,:,160),Q(:,30),ZERO,G3(:,:,:,147))
  call loop_QW_A(G3(:,:,:,147),wf(:,0),G3(:,:,:,148))
  call check_last_Q_A(l_switch,G3(:,:,:,148),Q(:,31),ZERO,G4tensor(:,68))
  call loop_QV_A(G2(:,:,:,159),wf(:,-3),G2(:,:,:,161))
  call loop_Q_A(G2(:,:,:,161),Q(:,26),ZERO,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,-2),G3(:,:,:,150))
  call loop_Q_A(G3(:,:,:,150),Q(:,30),ZERO,G4(:,:,:,49))
  call loop_QW_A(G4(:,:,:,49),wf(:,0),G4(:,:,:,50))
  call check_last_Q_A(l_switch,G4(:,:,:,50),Q(:,31),ZERO,G5tensor(:,25))
  call loop_QV_A(G2(:,:,:,159),wf(:,-2),G2(:,:,:,162))
  call loop_Q_A(G2(:,:,:,162),Q(:,22),ZERO,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,-3),G3(:,:,:,152))
  call loop_Q_A(G3(:,:,:,152),Q(:,30),ZERO,G4(:,:,:,51))
  call loop_QW_A(G4(:,:,:,51),wf(:,0),G4(:,:,:,52))
  call check_last_Q_A(l_switch,G4(:,:,:,52),Q(:,31),ZERO,G5tensor(:,26))
  call loop_QV_A(G1(:,:,:,67),wf(:,9),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,22),ZERO,G2(:,:,:,163))
  call loop_QV_A(G2(:,:,:,163),wf(:,-3),G2(:,:,:,164))
  call loop_Q_A(G2(:,:,:,164),Q(:,30),ZERO,G3(:,:,:,153))
  call loop_QW_A(G3(:,:,:,153),wf(:,0),G3(:,:,:,154))
  call check_last_Q_A(l_switch,G3(:,:,:,154),Q(:,31),ZERO,G4tensor(:,69))
  call loop_QV_A(G1(:,:,:,67),wf(:,-3),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,10),ZERO,G2(:,:,:,165))
  call loop_QV_A(G2(:,:,:,165),wf(:,9),G2(:,:,:,166))
  call loop_Q_A(G2(:,:,:,166),Q(:,30),ZERO,G3(:,:,:,155))
  call loop_QW_A(G3(:,:,:,155),wf(:,0),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,31),ZERO,G4tensor(:,70))
  call loop_QV_A(G2(:,:,:,165),wf(:,-4),G2(:,:,:,167))
  call loop_Q_A(G2(:,:,:,167),Q(:,26),ZERO,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,-2),G3(:,:,:,158))
  call loop_Q_A(G3(:,:,:,158),Q(:,30),ZERO,G4(:,:,:,53))
  call loop_QW_A(G4(:,:,:,53),wf(:,0),G4(:,:,:,54))
  call check_last_Q_A(l_switch,G4(:,:,:,54),Q(:,31),ZERO,G5tensor(:,27))
  call loop_QV_A(G2(:,:,:,165),wf(:,-2),G2(:,:,:,168))
  call loop_Q_A(G2(:,:,:,168),Q(:,14),ZERO,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,30),ZERO,G4(:,:,:,55))
  call loop_QW_A(G4(:,:,:,55),wf(:,0),G4(:,:,:,56))
  call check_last_Q_A(l_switch,G4(:,:,:,56),Q(:,31),ZERO,G5tensor(:,28))
  call loop_QV_A(G1(:,:,:,67),wf(:,11),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,26),ZERO,G2(:,:,:,169))
  call loop_QV_A(G2(:,:,:,169),wf(:,-2),G2(:,:,:,170))
  call loop_Q_A(G2(:,:,:,170),Q(:,30),ZERO,G3(:,:,:,161))
  call loop_QW_A(G3(:,:,:,161),wf(:,0),G3(:,:,:,162))
  call check_last_Q_A(l_switch,G3(:,:,:,162),Q(:,31),ZERO,G4tensor(:,71))
  call loop_QV_A(G1(:,:,:,67),wf(:,-2),G1(:,:,:,73))
  call loop_Q_A(G1(:,:,:,73),Q(:,6),ZERO,G2(:,:,:,171))
  call loop_QV_A(G2(:,:,:,171),wf(:,11),G2(:,:,:,172))
  call loop_Q_A(G2(:,:,:,172),Q(:,30),ZERO,G3(:,:,:,163))
  call loop_QW_A(G3(:,:,:,163),wf(:,0),G3(:,:,:,164))
  call check_last_Q_A(l_switch,G3(:,:,:,164),Q(:,31),ZERO,G4tensor(:,72))
  call loop_QV_A(G2(:,:,:,171),wf(:,-4),G2(:,:,:,173))
  call loop_Q_A(G2(:,:,:,173),Q(:,22),ZERO,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-3),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,30),ZERO,G4(:,:,:,57))
  call loop_QW_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,31),ZERO,G5tensor(:,29))
  call loop_QV_A(G2(:,:,:,171),wf(:,-3),G2(:,:,:,174))
  call loop_Q_A(G2(:,:,:,174),Q(:,14),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,30),ZERO,G4(:,:,:,59))
  call loop_QW_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,31),ZERO,G5tensor(:,30))
  call loop_QW_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,2),MT,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,7),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,14),MT,G2(:,:,:,175))
  call loop_QV_A(G2(:,:,:,175),wf(:,-4),G2(:,:,:,176))
  call loop_Q_A(G2(:,:,:,176),Q(:,30),MT,G3(:,:,:,169))
  call loop_QW_A(G3(:,:,:,169),wf(:,0),G3(:,:,:,170))
  call check_last_Q_A(l_switch,G3(:,:,:,170),Q(:,31),MB,G4tensor(:,73))
  call loop_QV_A(G1(:,:,:,74),wf(:,-4),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,18),MT,G2(:,:,:,177))
  call loop_QV_A(G2(:,:,:,177),wf(:,7),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,30),MT,G3(:,:,:,171))
  call loop_QW_A(G3(:,:,:,171),wf(:,0),G3(:,:,:,172))
  call check_last_Q_A(l_switch,G3(:,:,:,172),Q(:,31),MB,G4tensor(:,74))
  call loop_QV_A(G2(:,:,:,177),wf(:,-3),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,26),MT,G3(:,:,:,173))
  call loop_QV_A(G3(:,:,:,173),wf(:,-2),G3(:,:,:,174))
  call loop_Q_A(G3(:,:,:,174),Q(:,30),MT,G4(:,:,:,61))
  call loop_QW_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),MB,G5tensor(:,31))
  call loop_QV_A(G2(:,:,:,177),wf(:,-2),G2(:,:,:,180))
  call loop_Q_A(G2(:,:,:,180),Q(:,22),MT,G3(:,:,:,175))
  call loop_QV_A(G3(:,:,:,175),wf(:,-3),G3(:,:,:,176))
  call loop_Q_A(G3(:,:,:,176),Q(:,30),MT,G4(:,:,:,63))
  call loop_QW_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),MB,G5tensor(:,32))
  call loop_QV_A(G1(:,:,:,74),wf(:,9),G1(:,:,:,77))
  call loop_Q_A(G1(:,:,:,77),Q(:,22),MT,G2(:,:,:,181))
  call loop_QV_A(G2(:,:,:,181),wf(:,-3),G2(:,:,:,182))
  call loop_Q_A(G2(:,:,:,182),Q(:,30),MT,G3(:,:,:,177))
  call loop_QW_A(G3(:,:,:,177),wf(:,0),G3(:,:,:,178))
  call check_last_Q_A(l_switch,G3(:,:,:,178),Q(:,31),MB,G4tensor(:,75))
  call loop_QV_A(G1(:,:,:,74),wf(:,-3),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,10),MT,G2(:,:,:,183))
  call loop_QV_A(G2(:,:,:,183),wf(:,9),G2(:,:,:,184))
  call loop_Q_A(G2(:,:,:,184),Q(:,30),MT,G3(:,:,:,179))
  call loop_QW_A(G3(:,:,:,179),wf(:,0),G3(:,:,:,180))
  call check_last_Q_A(l_switch,G3(:,:,:,180),Q(:,31),MB,G4tensor(:,76))
  call loop_QV_A(G2(:,:,:,183),wf(:,-4),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,26),MT,G3(:,:,:,181))
  call loop_QV_A(G3(:,:,:,181),wf(:,-2),G3(:,:,:,182))
  call loop_Q_A(G3(:,:,:,182),Q(:,30),MT,G4(:,:,:,65))
  call loop_QW_A(G4(:,:,:,65),wf(:,0),G4(:,:,:,66))
  call check_last_Q_A(l_switch,G4(:,:,:,66),Q(:,31),MB,G5tensor(:,33))
  call loop_QV_A(G2(:,:,:,183),wf(:,-2),G2(:,:,:,186))
  call loop_Q_A(G2(:,:,:,186),Q(:,14),MT,G3(:,:,:,183))
  call loop_QV_A(G3(:,:,:,183),wf(:,-4),G3(:,:,:,184))
  call loop_Q_A(G3(:,:,:,184),Q(:,30),MT,G4(:,:,:,67))
  call loop_QW_A(G4(:,:,:,67),wf(:,0),G4(:,:,:,68))
  call check_last_Q_A(l_switch,G4(:,:,:,68),Q(:,31),MB,G5tensor(:,34))
  call loop_QV_A(G1(:,:,:,74),wf(:,11),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,26),MT,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,-2),G2(:,:,:,188))
  call loop_Q_A(G2(:,:,:,188),Q(:,30),MT,G3(:,:,:,185))
  call loop_QW_A(G3(:,:,:,185),wf(:,0),G3(:,:,:,186))
  call check_last_Q_A(l_switch,G3(:,:,:,186),Q(:,31),MB,G4tensor(:,77))
  call loop_QV_A(G1(:,:,:,74),wf(:,-2),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,6),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,11),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,30),MT,G3(:,:,:,187))
  call loop_QW_A(G3(:,:,:,187),wf(:,0),G3(:,:,:,188))
  call check_last_Q_A(l_switch,G3(:,:,:,188),Q(:,31),MB,G4tensor(:,78))
  call loop_QV_A(G2(:,:,:,189),wf(:,-4),G2(:,:,:,191))
  call loop_Q_A(G2(:,:,:,191),Q(:,22),MT,G3(:,:,:,189))
  call loop_QV_A(G3(:,:,:,189),wf(:,-3),G3(:,:,:,190))
  call loop_Q_A(G3(:,:,:,190),Q(:,30),MT,G4(:,:,:,69))
  call loop_QW_A(G4(:,:,:,69),wf(:,0),G4(:,:,:,70))
  call check_last_Q_A(l_switch,G4(:,:,:,70),Q(:,31),MB,G5tensor(:,35))
  call loop_QV_A(G2(:,:,:,189),wf(:,-3),G2(:,:,:,192))
  call loop_Q_A(G2(:,:,:,192),Q(:,14),MT,G3(:,:,:,191))
  call loop_QV_A(G3(:,:,:,191),wf(:,-4),G3(:,:,:,192))
  call loop_Q_A(G3(:,:,:,192),Q(:,30),MT,G4(:,:,:,71))
  call loop_QW_A(G4(:,:,:,71),wf(:,0),G4(:,:,:,72))
  call check_last_Q_A(l_switch,G4(:,:,:,72),Q(:,31),MB,G5tensor(:,36))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,2),ZERO,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,7),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,14),ZERO,G2(:,:,:,193))
  call loop_AV_Q(G2(:,:,:,193),wf(:,-4),G2(:,:,:,194))
  call loop_A_Q(G2(:,:,:,194),Q(:,30),ZERO,G3(:,:,:,193))
  call loop_AW_Q(G3(:,:,:,193),wf(:,0),G3(:,:,:,194))
  call check_last_A_Q(l_switch,G3(:,:,:,194),Q(:,31),ZERO,G4tensor(:,79))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-4),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,18),ZERO,G2(:,:,:,195))
  call loop_AV_Q(G2(:,:,:,195),wf(:,7),G2(:,:,:,196))
  call loop_A_Q(G2(:,:,:,196),Q(:,30),ZERO,G3(:,:,:,195))
  call loop_AW_Q(G3(:,:,:,195),wf(:,0),G3(:,:,:,196))
  call check_last_A_Q(l_switch,G3(:,:,:,196),Q(:,31),ZERO,G4tensor(:,80))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-3),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,26),ZERO,G3(:,:,:,197))
  call loop_AV_Q(G3(:,:,:,197),wf(:,-2),G3(:,:,:,198))
  call loop_A_Q(G3(:,:,:,198),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_AW_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_AV_Q(G2(:,:,:,195),wf(:,-2),G2(:,:,:,198))
  call loop_A_Q(G2(:,:,:,198),Q(:,22),ZERO,G3(:,:,:,199))
  call loop_AV_Q(G3(:,:,:,199),wf(:,-3),G3(:,:,:,200))
  call loop_A_Q(G3(:,:,:,200),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_AW_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,81),wf(:,9),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,22),ZERO,G2(:,:,:,199))
  call loop_AV_Q(G2(:,:,:,199),wf(:,-3),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,30),ZERO,G3(:,:,:,201))
  call loop_AW_Q(G3(:,:,:,201),wf(:,0),G3(:,:,:,202))
  call check_last_A_Q(l_switch,G3(:,:,:,202),Q(:,31),ZERO,G4tensor(:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-3),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,10),ZERO,G2(:,:,:,201))
  call loop_AV_Q(G2(:,:,:,201),wf(:,9),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,30),ZERO,G3(:,:,:,203))
  call loop_AW_Q(G3(:,:,:,203),wf(:,0),G3(:,:,:,204))
  call check_last_A_Q(l_switch,G3(:,:,:,204),Q(:,31),ZERO,G4tensor(:,82))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-4),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,26),ZERO,G3(:,:,:,205))
  call loop_AV_Q(G3(:,:,:,205),wf(:,-2),G3(:,:,:,206))
  call loop_A_Q(G3(:,:,:,206),Q(:,30),ZERO,G4(:,:,:,77))
  call loop_AW_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),ZERO,G5tensor(:,39))
  call loop_AV_Q(G2(:,:,:,201),wf(:,-2),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,14),ZERO,G3(:,:,:,207))
  call loop_AV_Q(G3(:,:,:,207),wf(:,-4),G3(:,:,:,208))
  call loop_A_Q(G3(:,:,:,208),Q(:,30),ZERO,G4(:,:,:,79))
  call loop_AW_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),ZERO,G5tensor(:,40))
  call loop_AV_Q(G1(:,:,:,81),wf(:,11),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,26),ZERO,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,-2),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,30),ZERO,G3(:,:,:,209))
  call loop_AW_Q(G3(:,:,:,209),wf(:,0),G3(:,:,:,210))
  call check_last_A_Q(l_switch,G3(:,:,:,210),Q(:,31),ZERO,G4tensor(:,83))
  call loop_AV_Q(G1(:,:,:,81),wf(:,-2),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,6),ZERO,G2(:,:,:,207))
  call loop_AV_Q(G2(:,:,:,207),wf(:,11),G2(:,:,:,208))
  call loop_A_Q(G2(:,:,:,208),Q(:,30),ZERO,G3(:,:,:,211))
  call loop_AW_Q(G3(:,:,:,211),wf(:,0),G3(:,:,:,212))
  call check_last_A_Q(l_switch,G3(:,:,:,212),Q(:,31),ZERO,G4tensor(:,84))
  call loop_AV_Q(G2(:,:,:,207),wf(:,-4),G2(:,:,:,209))
  call loop_A_Q(G2(:,:,:,209),Q(:,22),ZERO,G3(:,:,:,213))
  call loop_AV_Q(G3(:,:,:,213),wf(:,-3),G3(:,:,:,214))
  call loop_A_Q(G3(:,:,:,214),Q(:,30),ZERO,G4(:,:,:,81))
  call loop_AW_Q(G4(:,:,:,81),wf(:,0),G4(:,:,:,82))
  call check_last_A_Q(l_switch,G4(:,:,:,82),Q(:,31),ZERO,G5tensor(:,41))
  call loop_AV_Q(G2(:,:,:,207),wf(:,-3),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,14),ZERO,G3(:,:,:,215))
  call loop_AV_Q(G3(:,:,:,215),wf(:,-4),G3(:,:,:,216))
  call loop_A_Q(G3(:,:,:,216),Q(:,30),ZERO,G4(:,:,:,83))
  call loop_AW_Q(G4(:,:,:,83),wf(:,0),G4(:,:,:,84))
  call check_last_A_Q(l_switch,G4(:,:,:,84),Q(:,31),ZERO,G5tensor(:,42))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,2),MB,G1(:,:,:,88))
  call loop_AV_Q(G1(:,:,:,88),wf(:,7),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,14),MB,G2(:,:,:,211))
  call loop_AV_Q(G2(:,:,:,211),wf(:,-4),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,30),MB,G3(:,:,:,217))
  call loop_AW_Q(G3(:,:,:,217),wf(:,0),G3(:,:,:,218))
  call check_last_A_Q(l_switch,G3(:,:,:,218),Q(:,31),MT,G4tensor(:,85))
  call loop_AV_Q(G1(:,:,:,88),wf(:,-4),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,18),MB,G2(:,:,:,213))
  call loop_AV_Q(G2(:,:,:,213),wf(:,7),G2(:,:,:,214))
  call loop_A_Q(G2(:,:,:,214),Q(:,30),MB,G3(:,:,:,219))
  call loop_AW_Q(G3(:,:,:,219),wf(:,0),G3(:,:,:,220))
  call check_last_A_Q(l_switch,G3(:,:,:,220),Q(:,31),MT,G4tensor(:,86))
  call loop_AV_Q(G2(:,:,:,213),wf(:,-3),G2(:,:,:,215))
  call loop_A_Q(G2(:,:,:,215),Q(:,26),MB,G3(:,:,:,221))
  call loop_AV_Q(G3(:,:,:,221),wf(:,-2),G3(:,:,:,222))
  call loop_A_Q(G3(:,:,:,222),Q(:,30),MB,G4(:,:,:,85))
  call loop_AW_Q(G4(:,:,:,85),wf(:,0),G4(:,:,:,86))
  call check_last_A_Q(l_switch,G4(:,:,:,86),Q(:,31),MT,G5tensor(:,43))
  call loop_AV_Q(G2(:,:,:,213),wf(:,-2),G2(:,:,:,216))
  call loop_A_Q(G2(:,:,:,216),Q(:,22),MB,G3(:,:,:,223))
  call loop_AV_Q(G3(:,:,:,223),wf(:,-3),G3(:,:,:,224))
  call loop_A_Q(G3(:,:,:,224),Q(:,30),MB,G4(:,:,:,87))
  call loop_AW_Q(G4(:,:,:,87),wf(:,0),G4(:,:,:,88))
  call check_last_A_Q(l_switch,G4(:,:,:,88),Q(:,31),MT,G5tensor(:,44))
  call loop_AV_Q(G1(:,:,:,88),wf(:,9),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,22),MB,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,-3),G2(:,:,:,218))
  call loop_A_Q(G2(:,:,:,218),Q(:,30),MB,G3(:,:,:,225))
  call loop_AW_Q(G3(:,:,:,225),wf(:,0),G3(:,:,:,226))
  call check_last_A_Q(l_switch,G3(:,:,:,226),Q(:,31),MT,G4tensor(:,87))
  call loop_AV_Q(G1(:,:,:,88),wf(:,-3),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,10),MB,G2(:,:,:,219))
  call loop_AV_Q(G2(:,:,:,219),wf(:,9),G2(:,:,:,220))
  call loop_A_Q(G2(:,:,:,220),Q(:,30),MB,G3(:,:,:,227))
  call loop_AW_Q(G3(:,:,:,227),wf(:,0),G3(:,:,:,228))
  call check_last_A_Q(l_switch,G3(:,:,:,228),Q(:,31),MT,G4tensor(:,88))
  call loop_AV_Q(G2(:,:,:,219),wf(:,-4),G2(:,:,:,221))
  call loop_A_Q(G2(:,:,:,221),Q(:,26),MB,G3(:,:,:,229))
  call loop_AV_Q(G3(:,:,:,229),wf(:,-2),G3(:,:,:,230))
  call loop_A_Q(G3(:,:,:,230),Q(:,30),MB,G4(:,:,:,89))
  call loop_AW_Q(G4(:,:,:,89),wf(:,0),G4(:,:,:,90))
  call check_last_A_Q(l_switch,G4(:,:,:,90),Q(:,31),MT,G5tensor(:,45))
  call loop_AV_Q(G2(:,:,:,219),wf(:,-2),G2(:,:,:,222))
  call loop_A_Q(G2(:,:,:,222),Q(:,14),MB,G3(:,:,:,231))
  call loop_AV_Q(G3(:,:,:,231),wf(:,-4),G3(:,:,:,232))
  call loop_A_Q(G3(:,:,:,232),Q(:,30),MB,G4(:,:,:,91))
  call loop_AW_Q(G4(:,:,:,91),wf(:,0),G4(:,:,:,92))
  call check_last_A_Q(l_switch,G4(:,:,:,92),Q(:,31),MT,G5tensor(:,46))
  call loop_AV_Q(G1(:,:,:,88),wf(:,11),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,26),MB,G2(:,:,:,223))
  call loop_AV_Q(G2(:,:,:,223),wf(:,-2),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,30),MB,G3(:,:,:,233))
  call loop_AW_Q(G3(:,:,:,233),wf(:,0),G3(:,:,:,234))
  call check_last_A_Q(l_switch,G3(:,:,:,234),Q(:,31),MT,G4tensor(:,89))
  call loop_AV_Q(G1(:,:,:,88),wf(:,-2),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,6),MB,G2(:,:,:,225))
  call loop_AV_Q(G2(:,:,:,225),wf(:,11),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,30),MB,G3(:,:,:,235))
  call loop_AW_Q(G3(:,:,:,235),wf(:,0),G3(:,:,:,236))
  call check_last_A_Q(l_switch,G3(:,:,:,236),Q(:,31),MT,G4tensor(:,90))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-4),G2(:,:,:,227))
  call loop_A_Q(G2(:,:,:,227),Q(:,22),MB,G3(:,:,:,237))
  call loop_AV_Q(G3(:,:,:,237),wf(:,-3),G3(:,:,:,238))
  call loop_A_Q(G3(:,:,:,238),Q(:,30),MB,G4(:,:,:,93))
  call loop_AW_Q(G4(:,:,:,93),wf(:,0),G4(:,:,:,94))
  call check_last_A_Q(l_switch,G4(:,:,:,94),Q(:,31),MT,G5tensor(:,47))
  call loop_AV_Q(G2(:,:,:,225),wf(:,-3),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,14),MB,G3(:,:,:,239))
  call loop_AV_Q(G3(:,:,:,239),wf(:,-4),G3(:,:,:,240))
  call loop_A_Q(G3(:,:,:,240),Q(:,30),MB,G4(:,:,:,95))
  call loop_AW_Q(G4(:,:,:,95),wf(:,0),G4(:,:,:,96))
  call check_last_A_Q(l_switch,G4(:,:,:,96),Q(:,31),MT,G5tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(23)) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(3) = M(3) + (CI*f(23) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(23)) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(3) = M(3) + (CI*f(23) * den(7)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(20)) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(20) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(20)) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(3) = M(3) + (CI*f(20) * den(7)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(7) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,13),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(7)) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(4) = M(4) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(7) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,16),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(7)) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(4) = M(4) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,13),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(5) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,16),T3sum(1:35,3))
  M(4) = M(4) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(5)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(4) = M(4) + (CI*f(5) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(16) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,14),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(16)) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(15) * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(4) = M(4) + (-(CI*f(15)) * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(16) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,17),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(16)) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,17),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(15) * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(4) = M(4) + (-(CI*f(15)) * den(8)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(16) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,15),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(16)) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,15),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(15) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(15)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(16) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,18),T3sum(1:35,3))
  M(4) = M(4) + (-(CI*f(16)) * den(8)) * TI2_call(3,momenta_3,masses2_3,G3tensor(:,18),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(15) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(4) = M(4) + (-(CI*f(15)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(23) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(23)) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,19),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(23) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,4))
  M(3) = M(3) + (-(CI*f(23)) * den(9)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,22),T3sum(1:35,4))
  M(1) = M(1) + (CI*f(20) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(20)) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,25),T3sum(1:35,5))
  M(1) = M(1) + (CI*f(20) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,5))
  M(3) = M(3) + (-(CI*f(20)) * den(9)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(7)) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,31),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,20),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(7)) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,34),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(7) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,34),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,4))
  M(2) = M(2) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,31),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,31),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(5)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,26),T3sum(1:35,5))
  M(2) = M(2) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,34),T3sum(1:35,6))
  M(4) = M(4) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,34),T3sum(1:35,6))
  M(2) = M(2) + (CI*f(5) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,5))
  M(4) = M(4) + (-(CI*f(5)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,29),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,32),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(16) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,32),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15)) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(15) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,21),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(16)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,35),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(16) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,35),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15)) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,4))
  M(4) = M(4) + (CI*f(15) * den(10)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,24),T3sum(1:35,4))
  M(2) = M(2) + (-(CI*f(16)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,33),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(16) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,33),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(15) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,5))
  M(2) = M(2) + (-(CI*f(16)) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,36),T3sum(1:35,6))
  M(4) = M(4) + (CI*f(16) * den(10)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,36),T3sum(1:35,6))
  M(2) = M(2) + (-(CI*f(15)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,5))
  M(4) = M(4) + (CI*f(15) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,30),T3sum(1:35,5))
  M(1) = M(1) + (-(CI*f(23)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(23) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,37),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(23)) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,7))
  M(3) = M(3) + (CI*f(23) * den(11)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,40),T3sum(1:35,7))
  M(1) = M(1) + (-(CI*f(20)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(20) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,43),T3sum(1:35,8))
  M(1) = M(1) + (-(CI*f(20)) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,8))
  M(3) = M(3) + (CI*f(20) * den(11)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,46),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(7)) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,38),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(7) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(7)) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,41),T3sum(1:35,7))
  M(2) = M(2) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,49),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,8))
  M(4) = M(4) + (CI*f(5) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,44),T3sum(1:35,8))
  M(2) = M(2) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(4) = M(4) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,52),T3sum(1:35,9))
  M(2) = M(2) + (-(CI*f(5)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,8))
  M(4) = M(4) + (CI*f(5) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,47),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(16) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(16)) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,50),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(15)) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,39),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(16) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(16)) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,53),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,7))
  M(4) = M(4) + (-(CI*f(15)) * den(12)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,42),T3sum(1:35,7))
  M(2) = M(2) + (CI*f(16) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(16)) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,51),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(15)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,45),T3sum(1:35,8))
  M(2) = M(2) + (CI*f(16) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(4) = M(4) + (-(CI*f(16)) * den(12)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,54),T3sum(1:35,9))
  M(2) = M(2) + (CI*f(15) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,8))
  M(4) = M(4) + (-(CI*f(15)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,48),T3sum(1:35,8))
  M(1) = M(1) + (f(24) * den(6)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,5),T4sum(1:70,1))
  M(3) = M(3) + (f(24) * den(6)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,8),T4sum(1:70,1))
  M(1) = M(1) + (f(21) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,12),T4sum(1:70,2))
  M(3) = M(3) + (f(21) * den(6)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,16),T4sum(1:70,2))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,19),T4sum(1:70,3))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,6),T4sum(1:70,1))
  M(4) = M(4) + (-f(10) * den(1)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,23),T4sum(1:70,3))
  M(4) = M(4) + (-f(9) * den(1)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,9),T4sum(1:70,1))
  M(2) = M(2) + (f(9) * den(1)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,19),T4sum(1:70,3))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,13),T4sum(1:70,2))
  M(4) = M(4) + (f(9) * den(1)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,23),T4sum(1:70,3))
  M(4) = M(4) + (f(8) * den(1)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,17),T4sum(1:70,2))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,20),T4sum(1:70,3))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,7),T4sum(1:70,1))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,24),T4sum(1:70,3))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_14,masses2_9,G4tensor(:,10),T4sum(1:70,1))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,21),T4sum(1:70,3))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,14),T4sum(1:70,2))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_14,masses2_10,G4tensor(:,25),T4sum(1:70,3))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_14,masses2_4,G4tensor(:,18),T4sum(1:70,2))
  M(1) = M(1) + (f(24) * den(6)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,33),T4sum(1:70,4))
  M(3) = M(3) + (f(24) * den(6)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,27),T4sum(1:70,4))
  M(1) = M(1) + (f(21) * den(6)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,47),T4sum(1:70,5))
  M(3) = M(3) + (f(21) * den(6)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,40),T4sum(1:70,5))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,60),T4sum(1:70,6))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,34),T4sum(1:70,4))
  M(4) = M(4) + (-f(10) * den(1)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,53),T4sum(1:70,6))
  M(4) = M(4) + (-f(9) * den(1)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,28),T4sum(1:70,4))
  M(2) = M(2) + (f(9) * den(1)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,60),T4sum(1:70,6))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,48),T4sum(1:70,5))
  M(4) = M(4) + (f(9) * den(1)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,53),T4sum(1:70,6))
  M(4) = M(4) + (f(8) * den(1)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,41),T4sum(1:70,5))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,61),T4sum(1:70,6))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,35),T4sum(1:70,4))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,54),T4sum(1:70,6))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_11,masses2_9,G4tensor(:,29),T4sum(1:70,4))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,62),T4sum(1:70,6))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,49),T4sum(1:70,5))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_11,masses2_10,G4tensor(:,55),T4sum(1:70,6))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_11,masses2_4,G4tensor(:,42),T4sum(1:70,5))
  M(3) = M(3) + (f(24) * den(6)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,36),T4sum(1:70,7))
  M(1) = M(1) + (f(24) * den(6)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,30),T4sum(1:70,7))
  M(3) = M(3) + (f(21) * den(6)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,50),T4sum(1:70,8))
  M(1) = M(1) + (f(21) * den(6)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,43),T4sum(1:70,8))
  M(4) = M(4) + (-f(10) * den(1)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,63),T4sum(1:70,9))
  M(4) = M(4) + (-f(9) * den(1)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,37),T4sum(1:70,7))
  M(2) = M(2) + (-f(10) * den(1)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,56),T4sum(1:70,9))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,31),T4sum(1:70,7))
  M(4) = M(4) + (f(9) * den(1)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,63),T4sum(1:70,9))
  M(4) = M(4) + (f(8) * den(1)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,51),T4sum(1:70,8))
  M(2) = M(2) + (f(9) * den(1)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,56),T4sum(1:70,9))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,44),T4sum(1:70,8))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,64),T4sum(1:70,9))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,38),T4sum(1:70,7))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,57),T4sum(1:70,9))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_12,masses2_9,G4tensor(:,32),T4sum(1:70,7))
  M(4) = M(4) + (-f(18) * den(2)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,65),T4sum(1:70,9))
  M(4) = M(4) + (-f(17) * den(2)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,52),T4sum(1:70,8))
  M(2) = M(2) + (-f(18) * den(2)) * TI2_call(4,momenta_12,masses2_10,G4tensor(:,58),T4sum(1:70,9))
  M(2) = M(2) + (-f(17) * den(2)) * TI2_call(4,momenta_12,masses2_4,G4tensor(:,45),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,67),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,67),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,73),T4sum(1:70,11))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_6,masses2_8,G4tensor(:,73),T4sum(1:70,11))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,79),T4sum(1:70,10))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_6,masses2_10,G4tensor(:,79),T4sum(1:70,10))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,85),T4sum(1:70,12))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,85),T4sum(1:70,12))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,68),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,68),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,74),T4sum(1:70,14))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_7,masses2_8,G4tensor(:,74),T4sum(1:70,14))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,80),T4sum(1:70,13))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_7,masses2_10,G4tensor(:,80),T4sum(1:70,13))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,86),T4sum(1:70,15))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_7,masses2_5,G4tensor(:,86),T4sum(1:70,15))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,4),T4sum(1:70,16))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,4),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,2),T4sum(1:70,17))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_15,masses2_6,G4tensor(:,2),T4sum(1:70,17))
  M(2) = M(2) + (CI*f(12) * den(3)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,3),T4sum(1:70,16))
  M(4) = M(4) + (-(CI*f(12)) * den(3)) * TI2_call(4,momenta_15,masses2_10,G4tensor(:,3),T4sum(1:70,16))
  M(2) = M(2) + (CI*f(11) * den(3)) * TI2_call(4,momenta_15,masses2_7,G4tensor(:,1),T4sum(1:70,18))
  M(4) = M(4) + (-(CI*f(11)) * den(3)) * TI2_call(4,momenta_15,masses2_7,G4tensor(:,1),T4sum(1:70,18))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,69),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,69),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,75),T4sum(1:70,20))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_8,masses2_8,G4tensor(:,75),T4sum(1:70,20))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,81),T4sum(1:70,19))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_8,masses2_10,G4tensor(:,81),T4sum(1:70,19))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,87),T4sum(1:70,21))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_8,masses2_5,G4tensor(:,87),T4sum(1:70,21))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,70),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,70),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,76),T4sum(1:70,23))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_5,masses2_8,G4tensor(:,76),T4sum(1:70,23))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,82),T4sum(1:70,22))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_5,masses2_10,G4tensor(:,82),T4sum(1:70,22))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,88),T4sum(1:70,24))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,88),T4sum(1:70,24))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,26),T4sum(1:70,25))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,26),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_13,masses2_7,G4tensor(:,11),T4sum(1:70,26))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_13,masses2_7,G4tensor(:,11),T4sum(1:70,26))
  M(2) = M(2) + (-(CI*f(12)) * den(4)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,22),T4sum(1:70,25))
  M(4) = M(4) + (CI*f(12) * den(4)) * TI2_call(4,momenta_13,masses2_10,G4tensor(:,22),T4sum(1:70,25))
  M(2) = M(2) + (-(CI*f(11)) * den(4)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,15),T4sum(1:70,27))
  M(4) = M(4) + (CI*f(11) * den(4)) * TI2_call(4,momenta_13,masses2_6,G4tensor(:,15),T4sum(1:70,27))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,71),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,71),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,77),T4sum(1:70,29))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_9,masses2_8,G4tensor(:,77),T4sum(1:70,29))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,83),T4sum(1:70,28))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_9,masses2_10,G4tensor(:,83),T4sum(1:70,28))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,89),T4sum(1:70,30))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_9,masses2_5,G4tensor(:,89),T4sum(1:70,30))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,72),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,72),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,78),T4sum(1:70,32))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_4,masses2_8,G4tensor(:,78),T4sum(1:70,32))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,84),T4sum(1:70,31))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_4,masses2_10,G4tensor(:,84),T4sum(1:70,31))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,90),T4sum(1:70,33))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,90),T4sum(1:70,33))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,66),T4sum(1:70,34))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,66),T4sum(1:70,34))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_10,masses2_7,G4tensor(:,39),T4sum(1:70,35))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_10,masses2_7,G4tensor(:,39),T4sum(1:70,35))
  M(2) = M(2) + (CI*f(12) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,59),T4sum(1:70,34))
  M(4) = M(4) + (-(CI*f(12)) * den(5)) * TI2_call(4,momenta_10,masses2_10,G4tensor(:,59),T4sum(1:70,34))
  M(2) = M(2) + (CI*f(11) * den(5)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,46),T4sum(1:70,36))
  M(4) = M(4) + (-(CI*f(11)) * den(5)) * TI2_call(4,momenta_10,masses2_6,G4tensor(:,46),T4sum(1:70,36))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_19,masses2_17,G5tensor(:,27),T5sum(1:126,1))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_19,masses2_16,G5tensor(:,33),T5sum(1:126,2))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_19,masses2_17,G5tensor(:,39),T5sum(1:126,1))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_19,masses2_11,G5tensor(:,45),T5sum(1:126,3))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_21,masses2_17,G5tensor(:,25),T5sum(1:126,4))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_21,masses2_16,G5tensor(:,31),T5sum(1:126,5))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_21,masses2_17,G5tensor(:,37),T5sum(1:126,4))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_21,masses2_11,G5tensor(:,43),T5sum(1:126,6))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_17,masses2_17,G5tensor(:,29),T5sum(1:126,7))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_17,masses2_16,G5tensor(:,35),T5sum(1:126,8))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_17,masses2_17,G5tensor(:,41),T5sum(1:126,7))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_17,masses2_11,G5tensor(:,47),T5sum(1:126,9))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_20,masses2_17,G5tensor(:,26),T5sum(1:126,10))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_20,masses2_16,G5tensor(:,32),T5sum(1:126,11))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_20,masses2_17,G5tensor(:,38),T5sum(1:126,10))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_20,masses2_11,G5tensor(:,44),T5sum(1:126,12))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_16,masses2_17,G5tensor(:,30),T5sum(1:126,13))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_16,masses2_16,G5tensor(:,36),T5sum(1:126,14))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_16,masses2_17,G5tensor(:,42),T5sum(1:126,13))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_16,masses2_11,G5tensor(:,48),T5sum(1:126,15))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_18,masses2_17,G5tensor(:,28),T5sum(1:126,16))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_18,masses2_16,G5tensor(:,34),T5sum(1:126,17))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_18,masses2_17,G5tensor(:,40),T5sum(1:126,16))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_18,masses2_11,G5tensor(:,46),T5sum(1:126,18))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_23,masses2_17,G5tensor(:,19),T5sum(1:126,19))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_23,masses2_13,G5tensor(:,15),T5sum(1:126,20))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_23,masses2_17,G5tensor(:,23),T5sum(1:126,19))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_23,masses2_14,G5tensor(:,11),T5sum(1:126,21))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_25,masses2_17,G5tensor(:,22),T5sum(1:126,22))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_25,masses2_15,G5tensor(:,10),T5sum(1:126,23))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_25,masses2_17,G5tensor(:,18),T5sum(1:126,22))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_25,masses2_12,G5tensor(:,14),T5sum(1:126,24))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_22,masses2_17,G5tensor(:,20),T5sum(1:126,25))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_22,masses2_13,G5tensor(:,16),T5sum(1:126,26))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_22,masses2_17,G5tensor(:,24),T5sum(1:126,25))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_22,masses2_14,G5tensor(:,12),T5sum(1:126,27))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_24,masses2_17,G5tensor(:,21),T5sum(1:126,28))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_24,masses2_15,G5tensor(:,9),T5sum(1:126,29))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_24,masses2_17,G5tensor(:,17),T5sum(1:126,28))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_24,masses2_12,G5tensor(:,13),T5sum(1:126,30))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_26,masses2_17,G5tensor(:,6),T5sum(1:126,31))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_26,masses2_13,G5tensor(:,4),T5sum(1:126,32))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_26,masses2_17,G5tensor(:,8),T5sum(1:126,31))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_26,masses2_14,G5tensor(:,2),T5sum(1:126,33))
  M(4) = M(4) + (-f(14)) * TI2_call(5,momenta_27,masses2_17,G5tensor(:,7),T5sum(1:126,34))
  M(4) = M(4) + (-f(13)) * TI2_call(5,momenta_27,masses2_15,G5tensor(:,1),T5sum(1:126,35))
  M(2) = M(2) + (-f(14)) * TI2_call(5,momenta_27,masses2_17,G5tensor(:,5),T5sum(1:126,34))
  M(2) = M(2) + (-f(13)) * TI2_call(5,momenta_27,masses2_12,G5tensor(:,3),T5sum(1:126,36))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_wwxggg_5_/**/REALKIND
