
module ol_vamp_1_ppvvj2_wwxggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_wwxggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_wwxggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_wwxggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_wwxggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,9) :: G0
  complex(REALKIND), dimension(4,5,4,38) :: G1
  complex(REALKIND), dimension(4,15,4,96) :: G2
  complex(REALKIND), dimension(4,35,4,108) :: G3
  complex(REALKIND), dimension(4,70,4,48) :: G4
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,18,72))
    allocate(G4tensorhel(70,36,72))
    allocate(G5tensorhel(126,24,72))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,7),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,5),G2(:,:,:,3),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,5),G2(:,:,:,4),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AW_Q(G1(:,:,:,1),wf(:,-1),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,14),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,-4),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,30),ZERO,G3(:,:,:,1))
  call loop_AW_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,7),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ZERO,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,-4),G1(:,:,:,5))
  call loop_Q_A(G1(:,:,:,5),Q(:,28),ZERO,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,4))
  call loop_QZ_A(G2(:,:,:,7),wf(:,5),G2(:,:,:,9),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,9),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QZ_A(G2(:,:,:,7),wf(:,5),G2(:,:,:,10),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,6))
  call loop_QW_A(G1(:,:,:,4),wf(:,-1),G1(:,:,:,6))
  call loop_Q_A(G1(:,:,:,6),Q(:,14),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-4),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,30),ZERO,G3(:,:,:,3))
  call loop_QW_A(G3(:,:,:,3),wf(:,0),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,9),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),ZERO,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,1),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),ZERO,G3tensor(:,7))
  call loop_QZ_A(G2(:,:,:,13),wf(:,5),G2(:,:,:,15),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,31),ZERO,G3tensor(:,8))
  call loop_QZ_A(G2(:,:,:,13),wf(:,5),G2(:,:,:,16),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,16),Q(:,31),ZERO,G3tensor(:,9))
  call loop_QV_A(G1(:,:,:,7),wf(:,-2),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,12),ZERO,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,28),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_QZ_A(G3(:,:,:,5),wf(:,5),G3(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,7),Q(:,31),ZERO,G4tensor(:,4))
  call loop_QZ_A(G3(:,:,:,5),wf(:,5),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,5))
  call loop_QW_A(G2(:,:,:,17),wf(:,-1),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,14),ZERO,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,-4),G3(:,:,:,10))
  call loop_Q_A(G3(:,:,:,10),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_QW_A(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_Q_A(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_QW_A(G1(:,:,:,7),wf(:,-1),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,10),ZERO,G2(:,:,:,20))
  call loop_QV_A(G2(:,:,:,20),wf(:,9),G2(:,:,:,21))
  call loop_Q_A(G2(:,:,:,21),Q(:,30),ZERO,G3(:,:,:,11))
  call loop_QW_A(G3(:,:,:,11),wf(:,0),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,6))
  call loop_QV_A(G2(:,:,:,20),wf(:,-2),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,14),ZERO,G3(:,:,:,13))
  call loop_QV_A(G3(:,:,:,13),wf(:,-4),G3(:,:,:,14))
  call loop_Q_A(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_QW_A(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_Q_A(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,8),ZERO,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,9),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,28),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,1),G2(:,:,:,24))
  call check_last_A_Q(l_switch,G2(:,:,:,24),Q(:,31),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,5),G2(:,:,:,25),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,25),Q(:,31),ZERO,G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,5),G2(:,:,:,26),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,26),Q(:,31),ZERO,G3tensor(:,12))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-2),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,12),ZERO,G2(:,:,:,27))
  call loop_AV_Q(G2(:,:,:,27),wf(:,-4),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,28),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,31),ZERO,G4tensor(:,7))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,5),G3(:,:,:,17),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,17),Q(:,31),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G3(:,:,:,15),wf(:,5),G3(:,:,:,18),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,9))
  call loop_AW_Q(G2(:,:,:,27),wf(:,-1),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,14),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-4),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AW_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AW_Q(G1(:,:,:,11),wf(:,-1),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,10),ZERO,G2(:,:,:,30))
  call loop_AV_Q(G2(:,:,:,30),wf(:,9),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,30),ZERO,G3(:,:,:,21))
  call loop_AW_Q(G3(:,:,:,21),wf(:,0),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,31),ZERO,G4tensor(:,10))
  call loop_AV_Q(G2(:,:,:,30),wf(:,-2),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AW_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,4),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,11),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,28),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,1),G2(:,:,:,34))
  call check_last_Q_A(l_switch,G2(:,:,:,34),Q(:,31),ZERO,G3tensor(:,13))
  call loop_QZ_A(G2(:,:,:,33),wf(:,5),G2(:,:,:,35),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,35),Q(:,31),ZERO,G3tensor(:,14))
  call loop_QZ_A(G2(:,:,:,33),wf(:,5),G2(:,:,:,36),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),ZERO,G3tensor(:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-3),G1(:,:,:,17))
  call loop_Q_A(G1(:,:,:,17),Q(:,12),ZERO,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,28),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),ZERO,G4tensor(:,11))
  call loop_QZ_A(G3(:,:,:,25),wf(:,5),G3(:,:,:,27),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,27),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QZ_A(G3(:,:,:,25),wf(:,5),G3(:,:,:,28),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,31),ZERO,G4tensor(:,13))
  call loop_QW_A(G2(:,:,:,37),wf(:,-1),G2(:,:,:,39))
  call loop_Q_A(G2(:,:,:,39),Q(:,14),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-4),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_QW_A(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_Q_A(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_QV_A(G1(:,:,:,15),wf(:,-4),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,20),ZERO,G2(:,:,:,40))
  call loop_QV_A(G2(:,:,:,40),wf(:,-3),G2(:,:,:,41))
  call loop_Q_A(G2(:,:,:,41),Q(:,28),ZERO,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,1),G3(:,:,:,32))
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,31),ZERO,G4tensor(:,14))
  call loop_QZ_A(G3(:,:,:,31),wf(:,5),G3(:,:,:,33),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,33),Q(:,31),ZERO,G4tensor(:,15))
  call loop_QZ_A(G3(:,:,:,31),wf(:,5),G3(:,:,:,34),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,31),ZERO,G4tensor(:,16))
  call loop_QW_A(G2(:,:,:,40),wf(:,-1),G2(:,:,:,42))
  call loop_Q_A(G2(:,:,:,42),Q(:,22),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,-3),G3(:,:,:,36))
  call loop_Q_A(G3(:,:,:,36),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_QW_A(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_Q_A(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_QW_A(G1(:,:,:,15),wf(:,-1),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,6),ZERO,G2(:,:,:,43))
  call loop_QV_A(G2(:,:,:,43),wf(:,11),G2(:,:,:,44))
  call loop_Q_A(G2(:,:,:,44),Q(:,30),ZERO,G3(:,:,:,37))
  call loop_QW_A(G3(:,:,:,37),wf(:,0),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,31),ZERO,G4tensor(:,17))
  call loop_QV_A(G2(:,:,:,43),wf(:,-4),G2(:,:,:,45))
  call loop_Q_A(G2(:,:,:,45),Q(:,22),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-3),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_QW_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,43),wf(:,-3),G2(:,:,:,46))
  call loop_Q_A(G2(:,:,:,46),Q(:,14),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,-4),G3(:,:,:,42))
  call loop_Q_A(G3(:,:,:,42),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_QW_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,4),ZERO,G1(:,:,:,20))
  call loop_AV_Q(G1(:,:,:,20),wf(:,11),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,28),ZERO,G2(:,:,:,47))
  call loop_AV_Q(G2(:,:,:,47),wf(:,1),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,31),ZERO,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,47),wf(:,5),G2(:,:,:,49),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,49),Q(:,31),ZERO,G3tensor(:,17))
  call loop_AZ_Q(G2(:,:,:,47),wf(:,5),G2(:,:,:,50),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,50),Q(:,31),ZERO,G3tensor(:,18))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-3),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,12),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-4),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,28),ZERO,G3(:,:,:,43))
  call loop_AV_Q(G3(:,:,:,43),wf(:,1),G3(:,:,:,44))
  call check_last_A_Q(l_switch,G3(:,:,:,44),Q(:,31),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,5),G3(:,:,:,45),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,45),Q(:,31),ZERO,G4tensor(:,19))
  call loop_AZ_Q(G3(:,:,:,43),wf(:,5),G3(:,:,:,46),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,46),Q(:,31),ZERO,G4tensor(:,20))
  call loop_AW_Q(G2(:,:,:,51),wf(:,-1),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,14),ZERO,G3(:,:,:,47))
  call loop_AV_Q(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_AW_Q(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_A_Q(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-4),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,20),ZERO,G2(:,:,:,54))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-3),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,28),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,1),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,31),ZERO,G4tensor(:,21))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,5),G3(:,:,:,51),gZu)
  call check_last_A_Q(l_switch,G3(:,:,:,51),Q(:,31),ZERO,G4tensor(:,22))
  call loop_AZ_Q(G3(:,:,:,49),wf(:,5),G3(:,:,:,52),gZd)
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,31),ZERO,G4tensor(:,23))
  call loop_AW_Q(G2(:,:,:,54),wf(:,-1),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,22),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-3),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_AW_Q(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_A_Q(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_AW_Q(G1(:,:,:,20),wf(:,-1),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,6),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,11),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,30),ZERO,G3(:,:,:,55))
  call loop_AW_Q(G3(:,:,:,55),wf(:,0),G3(:,:,:,56))
  call check_last_A_Q(l_switch,G3(:,:,:,56),Q(:,31),ZERO,G4tensor(:,24))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-4),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,22),ZERO,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-3),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,30),ZERO,G4(:,:,:,21))
  call loop_AW_Q(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_A_Q(l_switch,G4(:,:,:,22),Q(:,31),ZERO,G5tensor(:,11))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-3),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,14),ZERO,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,-4),G3(:,:,:,60))
  call loop_A_Q(G3(:,:,:,60),Q(:,30),ZERO,G4(:,:,:,23))
  call loop_AW_Q(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_A_Q(l_switch,G4(:,:,:,24),Q(:,31),ZERO,G5tensor(:,12))
  call loop_QW_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,2),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,7),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,14),ZERO,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,30),ZERO,G3(:,:,:,61))
  call loop_QW_A(G3(:,:,:,61),wf(:,0),G3(:,:,:,62))
  call check_last_Q_A(l_switch,G3(:,:,:,62),Q(:,31),ZERO,G4tensor(:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,18),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,7),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,30),ZERO,G3(:,:,:,63))
  call loop_QW_A(G3(:,:,:,63),wf(:,0),G3(:,:,:,64))
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,31),ZERO,G4tensor(:,26))
  call loop_QV_A(G2(:,:,:,63),wf(:,-3),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,26),ZERO,G3(:,:,:,65))
  call loop_QV_A(G3(:,:,:,65),wf(:,-2),G3(:,:,:,66))
  call loop_Q_A(G3(:,:,:,66),Q(:,30),ZERO,G4(:,:,:,25))
  call loop_QW_A(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_Q_A(l_switch,G4(:,:,:,26),Q(:,31),ZERO,G5tensor(:,13))
  call loop_QV_A(G2(:,:,:,63),wf(:,-2),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,22),ZERO,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,-3),G3(:,:,:,68))
  call loop_Q_A(G3(:,:,:,68),Q(:,30),ZERO,G4(:,:,:,27))
  call loop_QW_A(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_Q_A(l_switch,G4(:,:,:,28),Q(:,31),ZERO,G5tensor(:,14))
  call loop_QV_A(G1(:,:,:,25),wf(:,9),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,22),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-3),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,30),ZERO,G3(:,:,:,69))
  call loop_QW_A(G3(:,:,:,69),wf(:,0),G3(:,:,:,70))
  call check_last_Q_A(l_switch,G3(:,:,:,70),Q(:,31),ZERO,G4tensor(:,27))
  call loop_QV_A(G1(:,:,:,25),wf(:,-3),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,10),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,9),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,30),ZERO,G3(:,:,:,71))
  call loop_QW_A(G3(:,:,:,71),wf(:,0),G3(:,:,:,72))
  call check_last_Q_A(l_switch,G3(:,:,:,72),Q(:,31),ZERO,G4tensor(:,28))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,26),ZERO,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,-2),G3(:,:,:,74))
  call loop_Q_A(G3(:,:,:,74),Q(:,30),ZERO,G4(:,:,:,29))
  call loop_QW_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),ZERO,G5tensor(:,15))
  call loop_QV_A(G2(:,:,:,69),wf(:,-2),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,14),ZERO,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,-4),G3(:,:,:,76))
  call loop_Q_A(G3(:,:,:,76),Q(:,30),ZERO,G4(:,:,:,31))
  call loop_QW_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),ZERO,G5tensor(:,16))
  call loop_QV_A(G1(:,:,:,25),wf(:,11),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,26),ZERO,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,-2),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,30),ZERO,G3(:,:,:,77))
  call loop_QW_A(G3(:,:,:,77),wf(:,0),G3(:,:,:,78))
  call check_last_Q_A(l_switch,G3(:,:,:,78),Q(:,31),ZERO,G4tensor(:,29))
  call loop_QV_A(G1(:,:,:,25),wf(:,-2),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,6),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,11),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,30),ZERO,G3(:,:,:,79))
  call loop_QW_A(G3(:,:,:,79),wf(:,0),G3(:,:,:,80))
  call check_last_Q_A(l_switch,G3(:,:,:,80),Q(:,31),ZERO,G4tensor(:,30))
  call loop_QV_A(G2(:,:,:,75),wf(:,-4),G2(:,:,:,77))
  call loop_Q_A(G2(:,:,:,77),Q(:,22),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-3),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_QW_A(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_Q_A(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_QV_A(G2(:,:,:,75),wf(:,-3),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,14),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_Q_A(G3(:,:,:,84),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_QW_A(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_Q_A(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,2),ZERO,G1(:,:,:,32))
  call loop_AV_Q(G1(:,:,:,32),wf(:,7),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,14),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,30),ZERO,G3(:,:,:,85))
  call loop_AW_Q(G3(:,:,:,85),wf(:,0),G3(:,:,:,86))
  call check_last_A_Q(l_switch,G3(:,:,:,86),Q(:,31),ZERO,G4tensor(:,31))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-4),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,18),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,7),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,30),ZERO,G3(:,:,:,87))
  call loop_AW_Q(G3(:,:,:,87),wf(:,0),G3(:,:,:,88))
  call check_last_A_Q(l_switch,G3(:,:,:,88),Q(:,31),ZERO,G4tensor(:,32))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-3),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,26),ZERO,G3(:,:,:,89))
  call loop_AV_Q(G3(:,:,:,89),wf(:,-2),G3(:,:,:,90))
  call loop_A_Q(G3(:,:,:,90),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_AW_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-2),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,22),ZERO,G3(:,:,:,91))
  call loop_AV_Q(G3(:,:,:,91),wf(:,-3),G3(:,:,:,92))
  call loop_A_Q(G3(:,:,:,92),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_AW_Q(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_AV_Q(G1(:,:,:,32),wf(:,9),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,22),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,30),ZERO,G3(:,:,:,93))
  call loop_AW_Q(G3(:,:,:,93),wf(:,0),G3(:,:,:,94))
  call check_last_A_Q(l_switch,G3(:,:,:,94),Q(:,31),ZERO,G4tensor(:,33))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-3),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,10),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,9),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,30),ZERO,G3(:,:,:,95))
  call loop_AW_Q(G3(:,:,:,95),wf(:,0),G3(:,:,:,96))
  call check_last_A_Q(l_switch,G3(:,:,:,96),Q(:,31),ZERO,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-4),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,26),ZERO,G3(:,:,:,97))
  call loop_AV_Q(G3(:,:,:,97),wf(:,-2),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,30),ZERO,G4(:,:,:,41))
  call loop_AW_Q(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_A_Q(l_switch,G4(:,:,:,42),Q(:,31),ZERO,G5tensor(:,21))
  call loop_AV_Q(G2(:,:,:,87),wf(:,-2),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,14),ZERO,G3(:,:,:,99))
  call loop_AV_Q(G3(:,:,:,99),wf(:,-4),G3(:,:,:,100))
  call loop_A_Q(G3(:,:,:,100),Q(:,30),ZERO,G4(:,:,:,43))
  call loop_AW_Q(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_A_Q(l_switch,G4(:,:,:,44),Q(:,31),ZERO,G5tensor(:,22))
  call loop_AV_Q(G1(:,:,:,32),wf(:,11),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,26),ZERO,G2(:,:,:,91))
  call loop_AV_Q(G2(:,:,:,91),wf(:,-2),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,30),ZERO,G3(:,:,:,101))
  call loop_AW_Q(G3(:,:,:,101),wf(:,0),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,31),ZERO,G4tensor(:,35))
  call loop_AV_Q(G1(:,:,:,32),wf(:,-2),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,6),ZERO,G2(:,:,:,93))
  call loop_AV_Q(G2(:,:,:,93),wf(:,11),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,30),ZERO,G3(:,:,:,103))
  call loop_AW_Q(G3(:,:,:,103),wf(:,0),G3(:,:,:,104))
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,31),ZERO,G4tensor(:,36))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-4),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,22),ZERO,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,-3),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,30),ZERO,G4(:,:,:,45))
  call loop_AW_Q(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_A_Q(l_switch,G4(:,:,:,46),Q(:,31),ZERO,G5tensor(:,23))
  call loop_AV_Q(G2(:,:,:,93),wf(:,-3),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,14),ZERO,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,30),ZERO,G4(:,:,:,47))
  call loop_AW_Q(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_A_Q(l_switch,G4(:,:,:,48),Q(:,31),ZERO,G5tensor(:,24))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(7) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(7)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(6)) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(2) = M(2) + (CI*f(6) * den(13)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(12) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(12)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(12) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(12)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(13) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (CI*f(13) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(2) = M(2) + (-(CI*f(13)) * den(8)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(CI*f(7)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(7) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(7)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(7) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,7),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(6) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(2) = M(2) + (-(CI*f(6)) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(12)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(12) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,8),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(12)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(12) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(13)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(13) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-(CI*f(13)) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(2) = M(2) + (CI*f(13) * den(10)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (CI*f(7) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(7)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(7) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(7)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,13),T3sum(1:35,3))
  M(1) = M(1) + (-(CI*f(6)) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(2) = M(2) + (CI*f(6) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(12) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(12)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,14),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(12) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(12)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,17),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(13) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(13)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,3))
  M(1) = M(1) + (CI*f(13) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,3))
  M(2) = M(2) + (-(CI*f(13)) * den(12)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,18),T3sum(1:35,3))
  M(1) = M(1) + (-f(9) * den(1)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (f(8) * den(1)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (-f(14) * den(2)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,4),T4sum(1:70,1))
  M(2) = M(2) + (-f(14) * den(2)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,8),T4sum(1:70,1))
  M(1) = M(1) + (-f(15) * den(2)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-f(15) * den(2)) * TI2_call(4,momenta_14,masses2_2,G4tensor(:,9),T4sum(1:70,1))
  M(1) = M(1) + (-f(9) * den(1)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,18),T4sum(1:70,2))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (f(8) * den(1)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,18),T4sum(1:70,2))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,11),T4sum(1:70,2))
  M(1) = M(1) + (-f(14) * den(2)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,19),T4sum(1:70,2))
  M(2) = M(2) + (-f(14) * den(2)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,12),T4sum(1:70,2))
  M(1) = M(1) + (-f(15) * den(2)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,20),T4sum(1:70,2))
  M(2) = M(2) + (-f(15) * den(2)) * TI2_call(4,momenta_11,masses2_2,G4tensor(:,13),T4sum(1:70,2))
  M(2) = M(2) + (-f(9) * den(1)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (-f(9) * den(1)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,14),T4sum(1:70,3))
  M(2) = M(2) + (f(8) * den(1)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,21),T4sum(1:70,3))
  M(1) = M(1) + (f(8) * den(1)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,14),T4sum(1:70,3))
  M(2) = M(2) + (-f(14) * den(2)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,22),T4sum(1:70,3))
  M(1) = M(1) + (-f(14) * den(2)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,15),T4sum(1:70,3))
  M(2) = M(2) + (-f(15) * den(2)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,23),T4sum(1:70,3))
  M(1) = M(1) + (-f(15) * den(2)) * TI2_call(4,momenta_12,masses2_2,G4tensor(:,16),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,25),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,25),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,31),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_6,masses2_2,G4tensor(:,31),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,26),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,26),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,32),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_7,masses2_2,G4tensor(:,32),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,2),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(10) * den(3)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,1),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(10)) * den(3)) * TI2_call(4,momenta_15,masses2_2,G4tensor(:,1),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,27),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,27),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,33),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_8,masses2_2,G4tensor(:,33),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,28),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,28),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,34),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,34),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,10),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,10),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(10)) * den(4)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(10) * den(4)) * TI2_call(4,momenta_13,masses2_2,G4tensor(:,6),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,29),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,35),T4sum(1:70,10))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_9,masses2_2,G4tensor(:,35),T4sum(1:70,10))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,30),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,30),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,36),T4sum(1:70,11))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,24),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,24),T4sum(1:70,12))
  M(1) = M(1) + (CI*f(10) * den(5)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,17),T4sum(1:70,12))
  M(2) = M(2) + (-(CI*f(10)) * den(5)) * TI2_call(4,momenta_10,masses2_2,G4tensor(:,17),T4sum(1:70,12))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,15),T5sum(1:126,1))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_19,masses2_3,G5tensor(:,21),T5sum(1:126,1))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,13),T5sum(1:126,2))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_21,masses2_3,G5tensor(:,19),T5sum(1:126,2))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,17),T5sum(1:126,3))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_17,masses2_3,G5tensor(:,23),T5sum(1:126,3))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,14),T5sum(1:126,4))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_20,masses2_3,G5tensor(:,20),T5sum(1:126,4))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,18),T5sum(1:126,5))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_16,masses2_3,G5tensor(:,24),T5sum(1:126,5))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,16),T5sum(1:126,6))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_18,masses2_3,G5tensor(:,22),T5sum(1:126,6))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,7),T5sum(1:126,7))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_23,masses2_3,G5tensor(:,11),T5sum(1:126,7))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_25,masses2_3,G5tensor(:,10),T5sum(1:126,8))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_25,masses2_3,G5tensor(:,6),T5sum(1:126,8))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,8),T5sum(1:126,9))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_22,masses2_3,G5tensor(:,12),T5sum(1:126,9))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,9),T5sum(1:126,10))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_24,masses2_3,G5tensor(:,5),T5sum(1:126,10))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,2),T5sum(1:126,11))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_26,masses2_3,G5tensor(:,4),T5sum(1:126,11))
  M(2) = M(2) + (-f(11)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,3),T5sum(1:126,12))
  M(1) = M(1) + (-f(11)) * TI2_call(5,momenta_27,masses2_3,G5tensor(:,1),T5sum(1:126,12))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_wwxggg_2_/**/REALKIND
