
module ol_vamp_1_ppvvj2_ddxzzg_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_ddxzzg_3.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_ddxzzg_3.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_ddxzzg_3_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_ddxzzg_3_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,33) :: G0
  complex(REALKIND), dimension(4,5,4,80) :: G1
  complex(REALKIND), dimension(4,15,4,108) :: G2
  complex(REALKIND), dimension(4,35,4,48) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,36,72))
    allocate(G4tensorhel(70,24,72))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AS_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,2),gH)
  call loop_A_Q(G0(:,:,:,2),Q(:,12),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),MT,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),MT,G3tensor(:,1))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,3),gH)
  call loop_Q_A(G0(:,:,:,3),Q(:,12),MT,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,28),MT,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),MT,G3tensor(:,2))
  call loop_AS_Q(G0(:,:,:,1),wf(:,3),G0(:,:,:,4),gH)
  call loop_A_Q(G0(:,:,:,4),Q(:,12),MB,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,28),MB,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),MB,G3tensor(:,3))
  call loop_QS_A(G0(:,:,:,1),wf(:,3),G0(:,:,:,5),gH)
  call loop_Q_A(G0(:,:,:,5),Q(:,12),MB,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),MB,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),MB,G3tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6),gZu)
  call loop_Q_A(G0(:,:,:,6),Q(:,8),ZERO,G1(:,:,:,9))
  call loop_QZ_A(G1(:,:,:,9),wf(:,-2),G1(:,:,:,10),gZu)
  call loop_Q_A(G1(:,:,:,10),Q(:,12),ZERO,G2(:,:,:,9))
  call loop_QV_A(G2(:,:,:,9),wf(:,-4),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,9),wf(:,-4),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,24),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,8),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,11),wf(:,11),G2(:,:,:,13))
  call check_last_Q_A(l_switch,G2(:,:,:,13),Q(:,31),ZERO,G3tensor(:,6))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7),gZu)
  call loop_Q_A(G0(:,:,:,7),Q(:,8),MT,G1(:,:,:,12))
  call loop_QZ_A(G1(:,:,:,12),wf(:,-2),G1(:,:,:,13),gZu)
  call loop_Q_A(G1(:,:,:,13),Q(:,12),MT,G2(:,:,:,14))
  call loop_QV_A(G2(:,:,:,14),wf(:,-4),G2(:,:,:,15))
  call loop_Q_A(G2(:,:,:,15),Q(:,28),MT,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,31),MT,G4tensor(:,2))
  call loop_QV_A(G1(:,:,:,12),wf(:,-4),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,24),MT,G2(:,:,:,16))
  call loop_QV_A(G2(:,:,:,16),wf(:,8),G2(:,:,:,17))
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,31),MT,G3tensor(:,7))
  call loop_QV_A(G2(:,:,:,16),wf(:,11),G2(:,:,:,18))
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,31),MT,G3tensor(:,8))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,15))
  call loop_AZ_Q(G1(:,:,:,15),wf(:,-2),G1(:,:,:,16),gZu)
  call loop_A_Q(G1(:,:,:,16),Q(:,12),ZERO,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,28),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_A_Q(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,24),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,8),G2(:,:,:,22))
  call check_last_A_Q(l_switch,G2(:,:,:,22),Q(:,31),ZERO,G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,21),wf(:,11),G2(:,:,:,23))
  call check_last_A_Q(l_switch,G2(:,:,:,23),Q(:,31),ZERO,G3tensor(:,10))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9),gZu)
  call loop_A_Q(G0(:,:,:,9),Q(:,8),MT,G1(:,:,:,18))
  call loop_AZ_Q(G1(:,:,:,18),wf(:,-2),G1(:,:,:,19),gZu)
  call loop_A_Q(G1(:,:,:,19),Q(:,12),MT,G2(:,:,:,24))
  call loop_AV_Q(G2(:,:,:,24),wf(:,-4),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,28),MT,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,31),MT,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,18),wf(:,-4),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,24),MT,G2(:,:,:,26))
  call loop_AV_Q(G2(:,:,:,26),wf(:,8),G2(:,:,:,27))
  call check_last_A_Q(l_switch,G2(:,:,:,27),Q(:,31),MT,G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,26),wf(:,11),G2(:,:,:,28))
  call check_last_A_Q(l_switch,G2(:,:,:,28),Q(:,31),MT,G3tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,10),gZd)
  call loop_Q_A(G0(:,:,:,10),Q(:,8),ZERO,G1(:,:,:,21))
  call loop_QZ_A(G1(:,:,:,21),wf(:,-2),G1(:,:,:,22),gZd)
  call loop_Q_A(G1(:,:,:,22),Q(:,12),ZERO,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-4),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,28),ZERO,G3(:,:,:,9))
  call loop_QV_A(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_Q_A(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,5))
  call loop_QV_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,24),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,8),G2(:,:,:,32))
  call check_last_Q_A(l_switch,G2(:,:,:,32),Q(:,31),ZERO,G3tensor(:,13))
  call loop_QV_A(G2(:,:,:,31),wf(:,11),G2(:,:,:,33))
  call check_last_Q_A(l_switch,G2(:,:,:,33),Q(:,31),ZERO,G3tensor(:,14))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,11),gZd)
  call loop_Q_A(G0(:,:,:,11),Q(:,8),MB,G1(:,:,:,24))
  call loop_QZ_A(G1(:,:,:,24),wf(:,-2),G1(:,:,:,25),gZd)
  call loop_Q_A(G1(:,:,:,25),Q(:,12),MB,G2(:,:,:,34))
  call loop_QV_A(G2(:,:,:,34),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,28),MB,G3(:,:,:,11))
  call loop_QV_A(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_Q_A(l_switch,G3(:,:,:,12),Q(:,31),MB,G4tensor(:,6))
  call loop_QV_A(G1(:,:,:,24),wf(:,-4),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,24),MB,G2(:,:,:,36))
  call loop_QV_A(G2(:,:,:,36),wf(:,8),G2(:,:,:,37))
  call check_last_Q_A(l_switch,G2(:,:,:,37),Q(:,31),MB,G3tensor(:,15))
  call loop_QV_A(G2(:,:,:,36),wf(:,11),G2(:,:,:,38))
  call check_last_Q_A(l_switch,G2(:,:,:,38),Q(:,31),MB,G3tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,12),gZd)
  call loop_A_Q(G0(:,:,:,12),Q(:,8),ZERO,G1(:,:,:,27))
  call loop_AZ_Q(G1(:,:,:,27),wf(:,-2),G1(:,:,:,28),gZd)
  call loop_A_Q(G1(:,:,:,28),Q(:,12),ZERO,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,28),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,31),ZERO,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,24),ZERO,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,8),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,31),ZERO,G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,41),wf(:,11),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,31),ZERO,G3tensor(:,18))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,13),gZd)
  call loop_A_Q(G0(:,:,:,13),Q(:,8),MB,G1(:,:,:,30))
  call loop_AZ_Q(G1(:,:,:,30),wf(:,-2),G1(:,:,:,31),gZd)
  call loop_A_Q(G1(:,:,:,31),Q(:,12),MB,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-4),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,28),MB,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,31),MB,G4tensor(:,8))
  call loop_AV_Q(G1(:,:,:,30),wf(:,-4),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,24),MB,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,8),G2(:,:,:,47))
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,31),MB,G3tensor(:,19))
  call loop_AV_Q(G2(:,:,:,46),wf(:,11),G2(:,:,:,48))
  call check_last_A_Q(l_switch,G2(:,:,:,48),Q(:,31),MB,G3tensor(:,20))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,14),gZu)
  call loop_A_Q(G0(:,:,:,14),Q(:,4),ZERO,G1(:,:,:,33))
  call loop_AZ_Q(G1(:,:,:,33),wf(:,-3),G1(:,:,:,34),gZu)
  call loop_A_Q(G1(:,:,:,34),Q(:,12),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-4),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,28),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,33),wf(:,-4),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,20),ZERO,G2(:,:,:,51))
  call loop_AZ_Q(G2(:,:,:,51),wf(:,-3),G2(:,:,:,52),gZu)
  call loop_A_Q(G2(:,:,:,52),Q(:,28),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,10))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,15),gZu)
  call loop_A_Q(G0(:,:,:,15),Q(:,4),MT,G1(:,:,:,36))
  call loop_AZ_Q(G1(:,:,:,36),wf(:,-3),G1(:,:,:,37),gZu)
  call loop_A_Q(G1(:,:,:,37),Q(:,12),MT,G2(:,:,:,53))
  call loop_AV_Q(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,28),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_A_Q(l_switch,G3(:,:,:,22),Q(:,31),MT,G4tensor(:,11))
  call loop_AV_Q(G1(:,:,:,36),wf(:,-4),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,20),MT,G2(:,:,:,55))
  call loop_AZ_Q(G2(:,:,:,55),wf(:,-3),G2(:,:,:,56),gZu)
  call loop_A_Q(G2(:,:,:,56),Q(:,28),MT,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_A_Q(l_switch,G3(:,:,:,24),Q(:,31),MT,G4tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,16),gZu)
  call loop_Q_A(G0(:,:,:,16),Q(:,4),ZERO,G1(:,:,:,39))
  call loop_QZ_A(G1(:,:,:,39),wf(:,-3),G1(:,:,:,40),gZu)
  call loop_Q_A(G1(:,:,:,40),Q(:,12),ZERO,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,-4),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,28),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),ZERO,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,39),wf(:,-4),G1(:,:,:,41))
  call loop_Q_A(G1(:,:,:,41),Q(:,20),ZERO,G2(:,:,:,59))
  call loop_QZ_A(G2(:,:,:,59),wf(:,-3),G2(:,:,:,60),gZu)
  call loop_Q_A(G2(:,:,:,60),Q(:,28),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,1),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,31),ZERO,G4tensor(:,14))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,17),gZu)
  call loop_Q_A(G0(:,:,:,17),Q(:,4),MT,G1(:,:,:,42))
  call loop_QZ_A(G1(:,:,:,42),wf(:,-3),G1(:,:,:,43),gZu)
  call loop_Q_A(G1(:,:,:,43),Q(:,12),MT,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-4),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,28),MT,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_Q_A(l_switch,G3(:,:,:,30),Q(:,31),MT,G4tensor(:,15))
  call loop_QV_A(G1(:,:,:,42),wf(:,-4),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,20),MT,G2(:,:,:,63))
  call loop_QZ_A(G2(:,:,:,63),wf(:,-3),G2(:,:,:,64),gZu)
  call loop_Q_A(G2(:,:,:,64),Q(:,28),MT,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,1),G3(:,:,:,32))
  call check_last_Q_A(l_switch,G3(:,:,:,32),Q(:,31),MT,G4tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,18),gZd)
  call loop_A_Q(G0(:,:,:,18),Q(:,4),ZERO,G1(:,:,:,45))
  call loop_AZ_Q(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46),gZd)
  call loop_A_Q(G1(:,:,:,46),Q(:,12),ZERO,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,-4),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,28),ZERO,G3(:,:,:,33))
  call loop_AV_Q(G3(:,:,:,33),wf(:,1),G3(:,:,:,34))
  call check_last_A_Q(l_switch,G3(:,:,:,34),Q(:,31),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,45),wf(:,-4),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,20),ZERO,G2(:,:,:,67))
  call loop_AZ_Q(G2(:,:,:,67),wf(:,-3),G2(:,:,:,68),gZd)
  call loop_A_Q(G2(:,:,:,68),Q(:,28),ZERO,G3(:,:,:,35))
  call loop_AV_Q(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_A_Q(l_switch,G3(:,:,:,36),Q(:,31),ZERO,G4tensor(:,18))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,19),gZd)
  call loop_A_Q(G0(:,:,:,19),Q(:,4),MB,G1(:,:,:,48))
  call loop_AZ_Q(G1(:,:,:,48),wf(:,-3),G1(:,:,:,49),gZd)
  call loop_A_Q(G1(:,:,:,49),Q(:,12),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,28),MB,G3(:,:,:,37))
  call loop_AV_Q(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_A_Q(l_switch,G3(:,:,:,38),Q(:,31),MB,G4tensor(:,19))
  call loop_AV_Q(G1(:,:,:,48),wf(:,-4),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,20),MB,G2(:,:,:,71))
  call loop_AZ_Q(G2(:,:,:,71),wf(:,-3),G2(:,:,:,72),gZd)
  call loop_A_Q(G2(:,:,:,72),Q(:,28),MB,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,1),G3(:,:,:,40))
  call check_last_A_Q(l_switch,G3(:,:,:,40),Q(:,31),MB,G4tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,20),gZd)
  call loop_Q_A(G0(:,:,:,20),Q(:,4),ZERO,G1(:,:,:,51))
  call loop_QZ_A(G1(:,:,:,51),wf(:,-3),G1(:,:,:,52),gZd)
  call loop_Q_A(G1(:,:,:,52),Q(:,12),ZERO,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,-4),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,28),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,1),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,31),ZERO,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,51),wf(:,-4),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,20),ZERO,G2(:,:,:,75))
  call loop_QZ_A(G2(:,:,:,75),wf(:,-3),G2(:,:,:,76),gZd)
  call loop_Q_A(G2(:,:,:,76),Q(:,28),ZERO,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,1),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,31),ZERO,G4tensor(:,22))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,21),gZd)
  call loop_Q_A(G0(:,:,:,21),Q(:,4),MB,G1(:,:,:,54))
  call loop_QZ_A(G1(:,:,:,54),wf(:,-3),G1(:,:,:,55),gZd)
  call loop_Q_A(G1(:,:,:,55),Q(:,12),MB,G2(:,:,:,77))
  call loop_QV_A(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_Q_A(G2(:,:,:,78),Q(:,28),MB,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,1),G3(:,:,:,46))
  call check_last_Q_A(l_switch,G3(:,:,:,46),Q(:,31),MB,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,54),wf(:,-4),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,20),MB,G2(:,:,:,79))
  call loop_QZ_A(G2(:,:,:,79),wf(:,-3),G2(:,:,:,80),gZd)
  call loop_Q_A(G2(:,:,:,80),Q(:,28),MB,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,1),G3(:,:,:,48))
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,31),MB,G4tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,11),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,-4),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,27),ZERO,G2(:,:,:,81))
  call loop_QZ_A(G2(:,:,:,81),wf(:,-2),G2(:,:,:,82),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,31),ZERO,G3tensor(:,21))
  call loop_QZ_A(G2(:,:,:,81),wf(:,-2),G2(:,:,:,83),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,83),Q(:,31),ZERO,G3tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,11),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call loop_Q_A(G1(:,:,:,60),Q(:,27),MT,G2(:,:,:,84))
  call loop_QZ_A(G2(:,:,:,84),wf(:,-2),G2(:,:,:,85),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,85),Q(:,31),MT,G3tensor(:,23))
  call loop_AV_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,11),ZERO,G1(:,:,:,61))
  call loop_AV_Q(G1(:,:,:,61),wf(:,-4),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,27),ZERO,G2(:,:,:,86))
  call loop_AZ_Q(G2(:,:,:,86),wf(:,-2),G2(:,:,:,87),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,87),Q(:,31),ZERO,G3tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,86),wf(:,-2),G2(:,:,:,88),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,31),ZERO,G3tensor(:,25))
  call loop_AV_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,11),MT,G1(:,:,:,63))
  call loop_AV_Q(G1(:,:,:,63),wf(:,-4),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,27),MT,G2(:,:,:,89))
  call loop_AZ_Q(G2(:,:,:,89),wf(:,-2),G2(:,:,:,90),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,90),Q(:,31),MT,G3tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,11),MB,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,27),MB,G2(:,:,:,91))
  call loop_QZ_A(G2(:,:,:,91),wf(:,-2),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,31),MB,G3tensor(:,27))
  call loop_AV_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,11),MB,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-4),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,27),MB,G2(:,:,:,93))
  call loop_AZ_Q(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,94),Q(:,31),MB,G3tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,11),ZERO,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,-4),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,27),ZERO,G2(:,:,:,95))
  call loop_QZ_A(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,31),ZERO,G3tensor(:,29))
  call loop_QZ_A(G2(:,:,:,95),wf(:,-2),G2(:,:,:,97),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,97),Q(:,31),ZERO,G3tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,11),MT,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,-4),G1(:,:,:,72))
  call loop_Q_A(G1(:,:,:,72),Q(:,27),MT,G2(:,:,:,98))
  call loop_QZ_A(G2(:,:,:,98),wf(:,-2),G2(:,:,:,99),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,99),Q(:,31),MT,G3tensor(:,31))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,11),ZERO,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,-4),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,27),ZERO,G2(:,:,:,100))
  call loop_AZ_Q(G2(:,:,:,100),wf(:,-2),G2(:,:,:,101),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,101),Q(:,31),ZERO,G3tensor(:,32))
  call loop_AZ_Q(G2(:,:,:,100),wf(:,-2),G2(:,:,:,102),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,102),Q(:,31),ZERO,G3tensor(:,33))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,31))
  call loop_A_Q(G0(:,:,:,31),Q(:,11),MT,G1(:,:,:,75))
  call loop_AV_Q(G1(:,:,:,75),wf(:,-4),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,27),MT,G2(:,:,:,103))
  call loop_AZ_Q(G2(:,:,:,103),wf(:,-2),G2(:,:,:,104),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,104),Q(:,31),MT,G3tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,18),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,11),MB,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,-4),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,27),MB,G2(:,:,:,105))
  call loop_QZ_A(G2(:,:,:,105),wf(:,-2),G2(:,:,:,106),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,31),MB,G3tensor(:,35))
  call loop_AV_Q(G0(:,:,:,1),wf(:,18),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,11),MB,G1(:,:,:,79))
  call loop_AV_Q(G1(:,:,:,79),wf(:,-4),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,27),MB,G2(:,:,:,107))
  call loop_AZ_Q(G2(:,:,:,107),wf(:,-2),G2(:,:,:,108),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,31),MB,G3tensor(:,36))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(8)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_3,masses2_2,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,3),T3sum(1:35,2))
  M(1) = M(1) + (f(6)/2._/**/REALKIND * den(3)) * TI2_call(3,momenta_3,masses2_1,G3tensor(:,4),T3sum(1:35,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,3),T4sum(1:70,1))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_5,G4tensor(:,4),T4sum(1:70,2))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,5),T4sum(1:70,1))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,6),T4sum(1:70,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_6,G4tensor(:,7),T4sum(1:70,1))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_6,masses2_4,G4tensor(:,8),T4sum(1:70,3))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,11),T4sum(1:70,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,13),T4sum(1:70,4))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_5,G4tensor(:,15),T4sum(1:70,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,17),T4sum(1:70,4))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,19),T4sum(1:70,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_6,G4tensor(:,21),T4sum(1:70,4))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_4,G4tensor(:,23),T4sum(1:70,6))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,10),T4sum(1:70,7))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,12),T4sum(1:70,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,14),T4sum(1:70,7))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_5,G4tensor(:,16),T4sum(1:70,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,18),T4sum(1:70,7))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,20),T4sum(1:70,9))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_6,G4tensor(:,22),T4sum(1:70,7))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_4,G4tensor(:,24),T4sum(1:70,9))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,9),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,11),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,5),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,7),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,17),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,19),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,13),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(15)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,15),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,10),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,12),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,6),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_2,G3tensor(:,8),T3sum(1:35,4))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,18),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,20),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_3,G3tensor(:,14),T3sum(1:35,3))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(16)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,16),T3sum(1:35,5))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,21),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,23),T3sum(1:35,7))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,24),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,26),T3sum(1:35,7))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,22),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,27),T3sum(1:35,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,25),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(18)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,28),T3sum(1:35,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,29),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,31),T3sum(1:35,7))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,32),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_2,G3tensor(:,34),T3sum(1:35,7))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,30),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,35),T3sum(1:35,8))
  M(2) = M(2) + (-(f(4)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_3,G3tensor(:,33),T3sum(1:35,6))
  M(2) = M(2) + (-(f(3)/2._/**/REALKIND) * den(19)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,36),T3sum(1:35,8))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_ddxzzg_3_/**/REALKIND
