
module ol_vamp_1_ppvvj2_ddxazg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_ddxazg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_ddxazg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_ddxazg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_ddxazg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,28) :: G1
  complex(REALKIND), dimension(4,15,4,42) :: G2
  complex(REALKIND), dimension(4,35,4,24) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,12,48))
    allocate(G4tensorhel(70,12,48))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2),gZu)
  call loop_Q_A(G0(:,:,:,2),Q(:,8),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-2),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,12),ZERO,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,-4),G2(:,:,:,2))
  call loop_Q_A(G2(:,:,:,2),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,24),ZERO,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,6),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,1))
  call loop_QV_A(G2(:,:,:,3),wf(:,9),G2(:,:,:,5))
  call check_last_Q_A(l_switch,G2(:,:,:,5),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,3),gZu)
  call loop_A_Q(G0(:,:,:,3),Q(:,8),ZERO,G1(:,:,:,4))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,12),ZERO,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,-4),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,28),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_AV_Q(G1(:,:,:,4),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,24),ZERO,G2(:,:,:,8))
  call loop_AV_Q(G2(:,:,:,8),wf(:,6),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,31),ZERO,G3tensor(:,3))
  call loop_AV_Q(G2(:,:,:,8),wf(:,9),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,4))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,4),gZd)
  call loop_Q_A(G0(:,:,:,4),Q(:,8),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,12),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,-4),G2(:,:,:,12))
  call loop_Q_A(G2(:,:,:,12),Q(:,28),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,24),ZERO,G2(:,:,:,13))
  call loop_QV_A(G2(:,:,:,13),wf(:,6),G2(:,:,:,14))
  call check_last_Q_A(l_switch,G2(:,:,:,14),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QV_A(G2(:,:,:,13),wf(:,9),G2(:,:,:,15))
  call check_last_Q_A(l_switch,G2(:,:,:,15),Q(:,31),ZERO,G3tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,5),gZd)
  call loop_A_Q(G0(:,:,:,5),Q(:,8),ZERO,G1(:,:,:,10))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-2),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,12),ZERO,G2(:,:,:,16))
  call loop_AV_Q(G2(:,:,:,16),wf(:,-4),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,28),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_A_Q(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AV_Q(G1(:,:,:,10),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,24),ZERO,G2(:,:,:,18))
  call loop_AV_Q(G2(:,:,:,18),wf(:,6),G2(:,:,:,19))
  call check_last_A_Q(l_switch,G2(:,:,:,19),Q(:,31),ZERO,G3tensor(:,7))
  call loop_AV_Q(G2(:,:,:,18),wf(:,9),G2(:,:,:,20))
  call check_last_A_Q(l_switch,G2(:,:,:,20),Q(:,31),ZERO,G3tensor(:,8))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,4),ZERO,G1(:,:,:,13))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,14),gZu)
  call loop_A_Q(G1(:,:,:,14),Q(:,12),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,28),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,-3),G1(:,:,:,15),gZd)
  call loop_A_Q(G1(:,:,:,15),Q(:,12),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,-4),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,28),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,6))
  call loop_AV_Q(G1(:,:,:,13),wf(:,-4),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,20),ZERO,G2(:,:,:,25))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26),gZu)
  call loop_A_Q(G2(:,:,:,26),Q(:,28),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,31),ZERO,G4tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,25),wf(:,-3),G2(:,:,:,27),gZd)
  call loop_A_Q(G2(:,:,:,27),Q(:,28),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,31),ZERO,G4tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,4),ZERO,G1(:,:,:,17))
  call loop_QZ_A(G1(:,:,:,17),wf(:,-3),G1(:,:,:,18),gZu)
  call loop_Q_A(G1(:,:,:,18),Q(:,12),ZERO,G2(:,:,:,28))
  call loop_QV_A(G2(:,:,:,28),wf(:,-4),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,28),ZERO,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,9))
  call loop_QZ_A(G1(:,:,:,17),wf(:,-3),G1(:,:,:,19),gZd)
  call loop_Q_A(G1(:,:,:,19),Q(:,12),ZERO,G2(:,:,:,30))
  call loop_QV_A(G2(:,:,:,30),wf(:,-4),G2(:,:,:,31))
  call loop_Q_A(G2(:,:,:,31),Q(:,28),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,10))
  call loop_QV_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,20),ZERO,G2(:,:,:,32))
  call loop_QZ_A(G2(:,:,:,32),wf(:,-3),G2(:,:,:,33),gZu)
  call loop_Q_A(G2(:,:,:,33),Q(:,28),ZERO,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,31),ZERO,G4tensor(:,11))
  call loop_QZ_A(G2(:,:,:,32),wf(:,-3),G2(:,:,:,34),gZd)
  call loop_Q_A(G2(:,:,:,34),Q(:,28),ZERO,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,11),ZERO,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,-4),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,27),ZERO,G2(:,:,:,35))
  call loop_QV_A(G2(:,:,:,35),wf(:,-2),G2(:,:,:,36))
  call check_last_Q_A(l_switch,G2(:,:,:,36),Q(:,31),ZERO,G3tensor(:,9))
  call loop_AV_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,11),ZERO,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,27),ZERO,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-2),G2(:,:,:,38))
  call check_last_A_Q(l_switch,G2(:,:,:,38),Q(:,31),ZERO,G3tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,11),ZERO,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,-4),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,27),ZERO,G2(:,:,:,39))
  call loop_QV_A(G2(:,:,:,39),wf(:,-2),G2(:,:,:,40))
  call check_last_Q_A(l_switch,G2(:,:,:,40),Q(:,31),ZERO,G3tensor(:,11))
  call loop_AV_Q(G0(:,:,:,1),wf(:,15),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,11),ZERO,G1(:,:,:,27))
  call loop_AV_Q(G1(:,:,:,27),wf(:,-4),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,27),ZERO,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42))
  call check_last_A_Q(l_switch,G2(:,:,:,42),Q(:,31),ZERO,G3tensor(:,12))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,3),T4sum(1:70,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_5,masses2_2,G4tensor(:,4),T4sum(1:70,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,9),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,6),T4sum(1:70,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,10),T4sum(1:70,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,7),T4sum(1:70,3))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,11),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,8),T4sum(1:70,3))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,12),T4sum(1:70,3))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,7),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(8)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(3)/2._/**/REALKIND) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,8),T3sum(1:35,1))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(9)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(12)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,9),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(12)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,10),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (f(5)/2._/**/REALKIND * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,11),T3sum(1:35,2))
  M(1) = M(1) + (-(f(4)/2._/**/REALKIND) * den(14)) * TI2_call(3,momenta_2,masses2_1,G3tensor(:,12),T3sum(1:35,2))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_ddxazg_2_/**/REALKIND
