
module ol_vamp_1_ppvvj2_bbxwwxg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G3tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_bbxwwxg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_bbxwwxg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_bbxwwxg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_bbxwwxg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(1)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,22) :: G1
  complex(REALKIND), dimension(4,15,4,24) :: G2
  complex(REALKIND), dimension(4,35,4,12) :: G3
  complex(REALKIND), pointer :: G3tensor(:,:)
  complex(REALKIND), pointer :: G4tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G3tensorhel(35,6,72))
    allocate(G4tensorhel(70,6,72))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G3tensor => G3tensorhel(:,:,hel)
  G4tensor => G4tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,5),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,12),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,28),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,31),ZERO,G3tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,5),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,12),ZERO,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,28),ZERO,G2(:,:,:,3))
  call loop_QV_A(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,31),ZERO,G3tensor(:,2))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,4),gZu)
  call loop_A_Q(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,28),ZERO,G2(:,:,:,5))
  call loop_AV_Q(G2(:,:,:,5),wf(:,1),G2(:,:,:,6))
  call check_last_A_Q(l_switch,G2(:,:,:,6),Q(:,31),ZERO,G3tensor(:,3))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,5),gZu)
  call loop_Q_A(G0(:,:,:,5),Q(:,12),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,-4),G1(:,:,:,8))
  call loop_Q_A(G1(:,:,:,8),Q(:,28),ZERO,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,1),G2(:,:,:,8))
  call check_last_Q_A(l_switch,G2(:,:,:,8),Q(:,31),ZERO,G3tensor(:,4))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,6),G0(:,:,:,6),gZd)
  call loop_A_Q(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,28),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,31),ZERO,G3tensor(:,5))
  call loop_QZ_A(G0(:,:,:,1),wf(:,6),G0(:,:,:,7),gZd)
  call loop_Q_A(G0(:,:,:,7),Q(:,12),ZERO,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,-4),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,28),ZERO,G2(:,:,:,11))
  call loop_QV_A(G2(:,:,:,11),wf(:,1),G2(:,:,:,12))
  call check_last_Q_A(l_switch,G2(:,:,:,12),Q(:,31),ZERO,G3tensor(:,6))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,13))
  call loop_AW_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,12),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-4),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,28),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_QW_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),ZERO,G1(:,:,:,15))
  call loop_QW_A(G1(:,:,:,15),wf(:,-2),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,12),ZERO,G2(:,:,:,15))
  call loop_QV_A(G2(:,:,:,15),wf(:,-4),G2(:,:,:,16))
  call loop_Q_A(G2(:,:,:,16),Q(:,28),ZERO,G3(:,:,:,3))
  call loop_QV_A(G3(:,:,:,3),wf(:,1),G3(:,:,:,4))
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_QW_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,17))
  call loop_QW_A(G1(:,:,:,17),wf(:,-3),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,12),ZERO,G2(:,:,:,17))
  call loop_QV_A(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_Q_A(G2(:,:,:,18),Q(:,28),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,31),ZERO,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,20),ZERO,G2(:,:,:,19))
  call loop_QW_A(G2(:,:,:,19),wf(:,-3),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,28),ZERO,G3(:,:,:,7))
  call loop_QV_A(G3(:,:,:,7),wf(:,1),G3(:,:,:,8))
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AW_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,4),ZERO,G1(:,:,:,20))
  call loop_AW_Q(G1(:,:,:,20),wf(:,-3),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,12),ZERO,G2(:,:,:,21))
  call loop_AV_Q(G2(:,:,:,21),wf(:,-4),G2(:,:,:,22))
  call loop_A_Q(G2(:,:,:,22),Q(:,28),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,20),wf(:,-4),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,20),ZERO,G2(:,:,:,23))
  call loop_AW_Q(G2(:,:,:,23),wf(:,-3),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,28),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,6))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (-(f(5)/2._/**/REALKIND) * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,1),T3sum(1:35,1))
  M(1) = M(1) + (f(4)/2._/**/REALKIND * den(7)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,2),T3sum(1:35,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,3),T3sum(1:35,1))
  M(1) = M(1) + (-(f(7)/2._/**/REALKIND) * den(5)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,4),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(5)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,5),T3sum(1:35,1))
  M(1) = M(1) + (-(f(8)/2._/**/REALKIND) * den(5)) * TI2_call(3,momenta_1,masses2_1,G3tensor(:,6),T3sum(1:35,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_4,masses2_2,G4tensor(:,2),T4sum(1:70,1))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,3),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_2,masses2_2,G4tensor(:,5),T4sum(1:70,2))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,6),T4sum(1:70,3))
  M(1) = M(1) + (-(f(6)/2._/**/REALKIND) * den(1)) * TI2_call(4,momenta_3,masses2_2,G4tensor(:,4),T4sum(1:70,3))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G3tensorhel)
  deallocate(G4tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_bbxwwxg_2_/**/REALKIND
