
module ol_vamp_1_ppvvj2_azggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_azggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_azggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_azggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_azggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,11) :: G0
  complex(REALKIND), dimension(4,5,4,52) :: G1
  complex(REALKIND), dimension(4,15,4,126) :: G2
  complex(REALKIND), dimension(4,35,4,168) :: G3
  complex(REALKIND), dimension(4,70,4,96) :: G4
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G4tensorhel(70,36,48))
    allocate(G5tensorhel(126,48,48))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2),gZu)
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,14),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,30),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,18),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,30),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,0),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-3),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,26),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,22),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-3),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,22),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,30),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,0),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,10),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,3),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,30),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,0),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,26),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-2),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,14),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,26),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,30),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,0),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,6),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,30),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,0),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-4),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,22),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-3),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3),gZu)
  call loop_Q_A(G0(:,:,:,3),Q(:,2),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,1),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,14),ZERO,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,30),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,0),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),ZERO,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,8),wf(:,-4),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,18),ZERO,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,30),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,0),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,31),ZERO,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,21),wf(:,-3),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,26),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,21),wf(:,-2),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,22),ZERO,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,22),ZERO,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,30),ZERO,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,0),G3(:,:,:,34))
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,31),ZERO,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,8),wf(:,-3),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,10),ZERO,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,3),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,30),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,0),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,31),ZERO,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,27),wf(:,-4),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,26),ZERO,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_QV_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,27),wf(:,-2),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,14),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_QV_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,8),wf(:,5),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,26),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,30),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,0),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,31),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,8),wf(:,-2),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,6),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,5),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,30),ZERO,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,22),ZERO,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-3),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),ZERO,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),ZERO,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,33),wf(:,-3),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,14),ZERO,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,30),ZERO,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),ZERO,G5tensor(:,12))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,4),gZd)
  call loop_A_Q(G0(:,:,:,4),Q(:,2),ZERO,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,1),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,14),ZERO,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,30),ZERO,G3(:,:,:,49))
  call loop_AV_Q(G3(:,:,:,49),wf(:,0),G3(:,:,:,50))
  call check_last_A_Q(l_switch,G3(:,:,:,50),Q(:,31),ZERO,G4tensor(:,13))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-4),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,18),ZERO,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,1),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,30),ZERO,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,0),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,31),ZERO,G4tensor(:,14))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-3),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,26),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,-2),G3(:,:,:,54))
  call loop_A_Q(G3(:,:,:,54),Q(:,30),ZERO,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,31),ZERO,G5tensor(:,13))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-2),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,22),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-3),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,30),ZERO,G4(:,:,:,27))
  call loop_AV_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,31),ZERO,G5tensor(:,14))
  call loop_AV_Q(G1(:,:,:,15),wf(:,3),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,22),ZERO,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-3),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,30),ZERO,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,0),G3(:,:,:,58))
  call check_last_A_Q(l_switch,G3(:,:,:,58),Q(:,31),ZERO,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-3),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,10),ZERO,G2(:,:,:,45))
  call loop_AV_Q(G2(:,:,:,45),wf(:,3),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,30),ZERO,G3(:,:,:,59))
  call loop_AV_Q(G3(:,:,:,59),wf(:,0),G3(:,:,:,60))
  call check_last_A_Q(l_switch,G3(:,:,:,60),Q(:,31),ZERO,G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-4),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,26),ZERO,G3(:,:,:,61))
  call loop_AV_Q(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,30),ZERO,G4(:,:,:,29))
  call loop_AV_Q(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_A_Q(l_switch,G4(:,:,:,30),Q(:,31),ZERO,G5tensor(:,15))
  call loop_AV_Q(G2(:,:,:,45),wf(:,-2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,14),ZERO,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,30),ZERO,G4(:,:,:,31))
  call loop_AV_Q(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_A_Q(l_switch,G4(:,:,:,32),Q(:,31),ZERO,G5tensor(:,16))
  call loop_AV_Q(G1(:,:,:,15),wf(:,5),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,26),ZERO,G2(:,:,:,49))
  call loop_AV_Q(G2(:,:,:,49),wf(:,-2),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,30),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,0),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,31),ZERO,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,15),wf(:,-2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,6),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,5),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,30),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,0),G3(:,:,:,68))
  call check_last_A_Q(l_switch,G3(:,:,:,68),Q(:,31),ZERO,G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-4),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,22),ZERO,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-3),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-3),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,14),ZERO,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_QZ_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,5),gZd)
  call loop_Q_A(G0(:,:,:,5),Q(:,2),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,1),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,14),ZERO,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-4),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,30),ZERO,G3(:,:,:,73))
  call loop_QV_A(G3(:,:,:,73),wf(:,0),G3(:,:,:,74))
  call check_last_Q_A(l_switch,G3(:,:,:,74),Q(:,31),ZERO,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,22),wf(:,-4),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,18),ZERO,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call loop_Q_A(G2(:,:,:,58),Q(:,30),ZERO,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,0),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,31),ZERO,G4tensor(:,20))
  call loop_QV_A(G2(:,:,:,57),wf(:,-3),G2(:,:,:,59))
  call loop_Q_A(G2(:,:,:,59),Q(:,26),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_QV_A(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_Q_A(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_QV_A(G2(:,:,:,57),wf(:,-2),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,22),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-3),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_QV_A(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_Q_A(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_QV_A(G1(:,:,:,22),wf(:,3),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,22),ZERO,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,-3),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,30),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,0),G3(:,:,:,82))
  call check_last_Q_A(l_switch,G3(:,:,:,82),Q(:,31),ZERO,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,22),wf(:,-3),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,10),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,3),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,30),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,0),G3(:,:,:,84))
  call check_last_Q_A(l_switch,G3(:,:,:,84),Q(:,31),ZERO,G4tensor(:,22))
  call loop_QV_A(G2(:,:,:,63),wf(:,-4),G2(:,:,:,65))
  call loop_Q_A(G2(:,:,:,65),Q(:,26),ZERO,G3(:,:,:,85))
  call loop_QV_A(G3(:,:,:,85),wf(:,-2),G3(:,:,:,86))
  call loop_Q_A(G3(:,:,:,86),Q(:,30),ZERO,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),ZERO,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,63),wf(:,-2),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,14),ZERO,G3(:,:,:,87))
  call loop_QV_A(G3(:,:,:,87),wf(:,-4),G3(:,:,:,88))
  call loop_Q_A(G3(:,:,:,88),Q(:,30),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),ZERO,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,5),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,26),ZERO,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,-2),G2(:,:,:,68))
  call loop_Q_A(G2(:,:,:,68),Q(:,30),ZERO,G3(:,:,:,89))
  call loop_QV_A(G3(:,:,:,89),wf(:,0),G3(:,:,:,90))
  call check_last_Q_A(l_switch,G3(:,:,:,90),Q(:,31),ZERO,G4tensor(:,23))
  call loop_QV_A(G1(:,:,:,22),wf(:,-2),G1(:,:,:,28))
  call loop_Q_A(G1(:,:,:,28),Q(:,6),ZERO,G2(:,:,:,69))
  call loop_QV_A(G2(:,:,:,69),wf(:,5),G2(:,:,:,70))
  call loop_Q_A(G2(:,:,:,70),Q(:,30),ZERO,G3(:,:,:,91))
  call loop_QV_A(G3(:,:,:,91),wf(:,0),G3(:,:,:,92))
  call check_last_Q_A(l_switch,G3(:,:,:,92),Q(:,31),ZERO,G4tensor(:,24))
  call loop_QV_A(G2(:,:,:,69),wf(:,-4),G2(:,:,:,71))
  call loop_Q_A(G2(:,:,:,71),Q(:,22),ZERO,G3(:,:,:,93))
  call loop_QV_A(G3(:,:,:,93),wf(:,-3),G3(:,:,:,94))
  call loop_Q_A(G3(:,:,:,94),Q(:,30),ZERO,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),ZERO,G5tensor(:,23))
  call loop_QV_A(G2(:,:,:,69),wf(:,-3),G2(:,:,:,72))
  call loop_Q_A(G2(:,:,:,72),Q(:,14),ZERO,G3(:,:,:,95))
  call loop_QV_A(G3(:,:,:,95),wf(:,-4),G3(:,:,:,96))
  call loop_Q_A(G3(:,:,:,96),Q(:,30),ZERO,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),ZERO,G5tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,12),ZERO,G1(:,:,:,29))
  call loop_QZ_A(G1(:,:,:,29),wf(:,-1),G1(:,:,:,30),gZu)
  call loop_Q_A(G1(:,:,:,30),Q(:,14),ZERO,G2(:,:,:,73))
  call loop_QV_A(G2(:,:,:,73),wf(:,-4),G2(:,:,:,74))
  call loop_Q_A(G2(:,:,:,74),Q(:,30),ZERO,G3(:,:,:,97))
  call loop_QV_A(G3(:,:,:,97),wf(:,0),G3(:,:,:,98))
  call check_last_Q_A(l_switch,G3(:,:,:,98),Q(:,31),ZERO,G4tensor(:,25))
  call loop_QZ_A(G1(:,:,:,29),wf(:,-1),G1(:,:,:,31),gZd)
  call loop_Q_A(G1(:,:,:,31),Q(:,14),ZERO,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call loop_Q_A(G2(:,:,:,76),Q(:,30),ZERO,G3(:,:,:,99))
  call loop_QV_A(G3(:,:,:,99),wf(:,0),G3(:,:,:,100))
  call check_last_Q_A(l_switch,G3(:,:,:,100),Q(:,31),ZERO,G4tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,12),ZERO,G1(:,:,:,32))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,-1),G1(:,:,:,33),gZu)
  call loop_A_Q(G1(:,:,:,33),Q(:,14),ZERO,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,-4),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,30),ZERO,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,0),G3(:,:,:,102))
  call check_last_A_Q(l_switch,G3(:,:,:,102),Q(:,31),ZERO,G4tensor(:,27))
  call loop_AZ_Q(G1(:,:,:,32),wf(:,-1),G1(:,:,:,34),gZd)
  call loop_A_Q(G1(:,:,:,34),Q(:,14),ZERO,G2(:,:,:,79))
  call loop_AV_Q(G2(:,:,:,79),wf(:,-4),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,30),ZERO,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,0),G3(:,:,:,104))
  call check_last_A_Q(l_switch,G3(:,:,:,104),Q(:,31),ZERO,G4tensor(:,28))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,8),ZERO,G1(:,:,:,35))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,-1),G1(:,:,:,36),gZu)
  call loop_A_Q(G1(:,:,:,36),Q(:,10),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,3),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,30),ZERO,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,0),G3(:,:,:,106))
  call check_last_A_Q(l_switch,G3(:,:,:,106),Q(:,31),ZERO,G4tensor(:,29))
  call loop_AV_Q(G2(:,:,:,81),wf(:,-2),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,14),ZERO,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,30),ZERO,G4(:,:,:,49))
  call loop_AV_Q(G4(:,:,:,49),wf(:,0),G4(:,:,:,50))
  call check_last_A_Q(l_switch,G4(:,:,:,50),Q(:,31),ZERO,G5tensor(:,25))
  call loop_AZ_Q(G1(:,:,:,35),wf(:,-1),G1(:,:,:,37),gZd)
  call loop_A_Q(G1(:,:,:,37),Q(:,10),ZERO,G2(:,:,:,84))
  call loop_AV_Q(G2(:,:,:,84),wf(:,3),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,30),ZERO,G3(:,:,:,109))
  call loop_AV_Q(G3(:,:,:,109),wf(:,0),G3(:,:,:,110))
  call check_last_A_Q(l_switch,G3(:,:,:,110),Q(:,31),ZERO,G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-2),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,14),ZERO,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-4),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,30),ZERO,G4(:,:,:,51))
  call loop_AV_Q(G4(:,:,:,51),wf(:,0),G4(:,:,:,52))
  call check_last_A_Q(l_switch,G4(:,:,:,52),Q(:,31),ZERO,G5tensor(:,26))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-2),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,12),ZERO,G2(:,:,:,87))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,-1),G2(:,:,:,88),gZu)
  call loop_A_Q(G2(:,:,:,88),Q(:,14),ZERO,G3(:,:,:,113))
  call loop_AV_Q(G3(:,:,:,113),wf(:,-4),G3(:,:,:,114))
  call loop_A_Q(G3(:,:,:,114),Q(:,30),ZERO,G4(:,:,:,53))
  call loop_AV_Q(G4(:,:,:,53),wf(:,0),G4(:,:,:,54))
  call check_last_A_Q(l_switch,G4(:,:,:,54),Q(:,31),ZERO,G5tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,87),wf(:,-1),G2(:,:,:,89),gZd)
  call loop_A_Q(G2(:,:,:,89),Q(:,14),ZERO,G3(:,:,:,115))
  call loop_AV_Q(G3(:,:,:,115),wf(:,-4),G3(:,:,:,116))
  call loop_A_Q(G3(:,:,:,116),Q(:,30),ZERO,G4(:,:,:,55))
  call loop_AV_Q(G4(:,:,:,55),wf(:,0),G4(:,:,:,56))
  call check_last_A_Q(l_switch,G4(:,:,:,56),Q(:,31),ZERO,G5tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,8),ZERO,G1(:,:,:,39))
  call loop_QZ_A(G1(:,:,:,39),wf(:,-1),G1(:,:,:,40),gZu)
  call loop_Q_A(G1(:,:,:,40),Q(:,10),ZERO,G2(:,:,:,90))
  call loop_QV_A(G2(:,:,:,90),wf(:,3),G2(:,:,:,91))
  call loop_Q_A(G2(:,:,:,91),Q(:,30),ZERO,G3(:,:,:,117))
  call loop_QV_A(G3(:,:,:,117),wf(:,0),G3(:,:,:,118))
  call check_last_Q_A(l_switch,G3(:,:,:,118),Q(:,31),ZERO,G4tensor(:,31))
  call loop_QV_A(G2(:,:,:,90),wf(:,-2),G2(:,:,:,92))
  call loop_Q_A(G2(:,:,:,92),Q(:,14),ZERO,G3(:,:,:,119))
  call loop_QV_A(G3(:,:,:,119),wf(:,-4),G3(:,:,:,120))
  call loop_Q_A(G3(:,:,:,120),Q(:,30),ZERO,G4(:,:,:,57))
  call loop_QV_A(G4(:,:,:,57),wf(:,0),G4(:,:,:,58))
  call check_last_Q_A(l_switch,G4(:,:,:,58),Q(:,31),ZERO,G5tensor(:,29))
  call loop_QZ_A(G1(:,:,:,39),wf(:,-1),G1(:,:,:,41),gZd)
  call loop_Q_A(G1(:,:,:,41),Q(:,10),ZERO,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,3),G2(:,:,:,94))
  call loop_Q_A(G2(:,:,:,94),Q(:,30),ZERO,G3(:,:,:,121))
  call loop_QV_A(G3(:,:,:,121),wf(:,0),G3(:,:,:,122))
  call check_last_Q_A(l_switch,G3(:,:,:,122),Q(:,31),ZERO,G4tensor(:,32))
  call loop_QV_A(G2(:,:,:,93),wf(:,-2),G2(:,:,:,95))
  call loop_Q_A(G2(:,:,:,95),Q(:,14),ZERO,G3(:,:,:,123))
  call loop_QV_A(G3(:,:,:,123),wf(:,-4),G3(:,:,:,124))
  call loop_Q_A(G3(:,:,:,124),Q(:,30),ZERO,G4(:,:,:,59))
  call loop_QV_A(G4(:,:,:,59),wf(:,0),G4(:,:,:,60))
  call check_last_Q_A(l_switch,G4(:,:,:,60),Q(:,31),ZERO,G5tensor(:,30))
  call loop_QV_A(G1(:,:,:,39),wf(:,-2),G1(:,:,:,42))
  call loop_Q_A(G1(:,:,:,42),Q(:,12),ZERO,G2(:,:,:,96))
  call loop_QZ_A(G2(:,:,:,96),wf(:,-1),G2(:,:,:,97),gZu)
  call loop_Q_A(G2(:,:,:,97),Q(:,14),ZERO,G3(:,:,:,125))
  call loop_QV_A(G3(:,:,:,125),wf(:,-4),G3(:,:,:,126))
  call loop_Q_A(G3(:,:,:,126),Q(:,30),ZERO,G4(:,:,:,61))
  call loop_QV_A(G4(:,:,:,61),wf(:,0),G4(:,:,:,62))
  call check_last_Q_A(l_switch,G4(:,:,:,62),Q(:,31),ZERO,G5tensor(:,31))
  call loop_QZ_A(G2(:,:,:,96),wf(:,-1),G2(:,:,:,98),gZd)
  call loop_Q_A(G2(:,:,:,98),Q(:,14),ZERO,G3(:,:,:,127))
  call loop_QV_A(G3(:,:,:,127),wf(:,-4),G3(:,:,:,128))
  call loop_Q_A(G3(:,:,:,128),Q(:,30),ZERO,G4(:,:,:,63))
  call loop_QV_A(G4(:,:,:,63),wf(:,0),G4(:,:,:,64))
  call check_last_Q_A(l_switch,G4(:,:,:,64),Q(:,31),ZERO,G5tensor(:,32))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,4),ZERO,G1(:,:,:,43))
  call loop_AZ_Q(G1(:,:,:,43),wf(:,-1),G1(:,:,:,44),gZu)
  call loop_A_Q(G1(:,:,:,44),Q(:,6),ZERO,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,5),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,30),ZERO,G3(:,:,:,129))
  call loop_AV_Q(G3(:,:,:,129),wf(:,0),G3(:,:,:,130))
  call check_last_A_Q(l_switch,G3(:,:,:,130),Q(:,31),ZERO,G4tensor(:,33))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-4),G2(:,:,:,101))
  call loop_A_Q(G2(:,:,:,101),Q(:,22),ZERO,G3(:,:,:,131))
  call loop_AV_Q(G3(:,:,:,131),wf(:,-3),G3(:,:,:,132))
  call loop_A_Q(G3(:,:,:,132),Q(:,30),ZERO,G4(:,:,:,65))
  call loop_AV_Q(G4(:,:,:,65),wf(:,0),G4(:,:,:,66))
  call check_last_A_Q(l_switch,G4(:,:,:,66),Q(:,31),ZERO,G5tensor(:,33))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,14),ZERO,G3(:,:,:,133))
  call loop_AV_Q(G3(:,:,:,133),wf(:,-4),G3(:,:,:,134))
  call loop_A_Q(G3(:,:,:,134),Q(:,30),ZERO,G4(:,:,:,67))
  call loop_AV_Q(G4(:,:,:,67),wf(:,0),G4(:,:,:,68))
  call check_last_A_Q(l_switch,G4(:,:,:,68),Q(:,31),ZERO,G5tensor(:,34))
  call loop_AZ_Q(G1(:,:,:,43),wf(:,-1),G1(:,:,:,45),gZd)
  call loop_A_Q(G1(:,:,:,45),Q(:,6),ZERO,G2(:,:,:,103))
  call loop_AV_Q(G2(:,:,:,103),wf(:,5),G2(:,:,:,104))
  call loop_A_Q(G2(:,:,:,104),Q(:,30),ZERO,G3(:,:,:,135))
  call loop_AV_Q(G3(:,:,:,135),wf(:,0),G3(:,:,:,136))
  call check_last_A_Q(l_switch,G3(:,:,:,136),Q(:,31),ZERO,G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-4),G2(:,:,:,105))
  call loop_A_Q(G2(:,:,:,105),Q(:,22),ZERO,G3(:,:,:,137))
  call loop_AV_Q(G3(:,:,:,137),wf(:,-3),G3(:,:,:,138))
  call loop_A_Q(G3(:,:,:,138),Q(:,30),ZERO,G4(:,:,:,69))
  call loop_AV_Q(G4(:,:,:,69),wf(:,0),G4(:,:,:,70))
  call check_last_A_Q(l_switch,G4(:,:,:,70),Q(:,31),ZERO,G5tensor(:,35))
  call loop_AV_Q(G2(:,:,:,103),wf(:,-3),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,14),ZERO,G3(:,:,:,139))
  call loop_AV_Q(G3(:,:,:,139),wf(:,-4),G3(:,:,:,140))
  call loop_A_Q(G3(:,:,:,140),Q(:,30),ZERO,G4(:,:,:,71))
  call loop_AV_Q(G4(:,:,:,71),wf(:,0),G4(:,:,:,72))
  call check_last_A_Q(l_switch,G4(:,:,:,72),Q(:,31),ZERO,G5tensor(:,36))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-4),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,20),ZERO,G2(:,:,:,107))
  call loop_AZ_Q(G2(:,:,:,107),wf(:,-1),G2(:,:,:,108),gZu)
  call loop_A_Q(G2(:,:,:,108),Q(:,22),ZERO,G3(:,:,:,141))
  call loop_AV_Q(G3(:,:,:,141),wf(:,-3),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,30),ZERO,G4(:,:,:,73))
  call loop_AV_Q(G4(:,:,:,73),wf(:,0),G4(:,:,:,74))
  call check_last_A_Q(l_switch,G4(:,:,:,74),Q(:,31),ZERO,G5tensor(:,37))
  call loop_AZ_Q(G2(:,:,:,107),wf(:,-1),G2(:,:,:,109),gZd)
  call loop_A_Q(G2(:,:,:,109),Q(:,22),ZERO,G3(:,:,:,143))
  call loop_AV_Q(G3(:,:,:,143),wf(:,-3),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,30),ZERO,G4(:,:,:,75))
  call loop_AV_Q(G4(:,:,:,75),wf(:,0),G4(:,:,:,76))
  call check_last_A_Q(l_switch,G4(:,:,:,76),Q(:,31),ZERO,G5tensor(:,38))
  call loop_AV_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,12),ZERO,G2(:,:,:,110))
  call loop_AZ_Q(G2(:,:,:,110),wf(:,-1),G2(:,:,:,111),gZu)
  call loop_A_Q(G2(:,:,:,111),Q(:,14),ZERO,G3(:,:,:,145))
  call loop_AV_Q(G3(:,:,:,145),wf(:,-4),G3(:,:,:,146))
  call loop_A_Q(G3(:,:,:,146),Q(:,30),ZERO,G4(:,:,:,77))
  call loop_AV_Q(G4(:,:,:,77),wf(:,0),G4(:,:,:,78))
  call check_last_A_Q(l_switch,G4(:,:,:,78),Q(:,31),ZERO,G5tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,110),wf(:,-1),G2(:,:,:,112),gZd)
  call loop_A_Q(G2(:,:,:,112),Q(:,14),ZERO,G3(:,:,:,147))
  call loop_AV_Q(G3(:,:,:,147),wf(:,-4),G3(:,:,:,148))
  call loop_A_Q(G3(:,:,:,148),Q(:,30),ZERO,G4(:,:,:,79))
  call loop_AV_Q(G4(:,:,:,79),wf(:,0),G4(:,:,:,80))
  call check_last_A_Q(l_switch,G4(:,:,:,80),Q(:,31),ZERO,G5tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,4),ZERO,G1(:,:,:,48))
  call loop_QZ_A(G1(:,:,:,48),wf(:,-1),G1(:,:,:,49),gZu)
  call loop_Q_A(G1(:,:,:,49),Q(:,6),ZERO,G2(:,:,:,113))
  call loop_QV_A(G2(:,:,:,113),wf(:,5),G2(:,:,:,114))
  call loop_Q_A(G2(:,:,:,114),Q(:,30),ZERO,G3(:,:,:,149))
  call loop_QV_A(G3(:,:,:,149),wf(:,0),G3(:,:,:,150))
  call check_last_Q_A(l_switch,G3(:,:,:,150),Q(:,31),ZERO,G4tensor(:,35))
  call loop_QV_A(G2(:,:,:,113),wf(:,-4),G2(:,:,:,115))
  call loop_Q_A(G2(:,:,:,115),Q(:,22),ZERO,G3(:,:,:,151))
  call loop_QV_A(G3(:,:,:,151),wf(:,-3),G3(:,:,:,152))
  call loop_Q_A(G3(:,:,:,152),Q(:,30),ZERO,G4(:,:,:,81))
  call loop_QV_A(G4(:,:,:,81),wf(:,0),G4(:,:,:,82))
  call check_last_Q_A(l_switch,G4(:,:,:,82),Q(:,31),ZERO,G5tensor(:,41))
  call loop_QV_A(G2(:,:,:,113),wf(:,-3),G2(:,:,:,116))
  call loop_Q_A(G2(:,:,:,116),Q(:,14),ZERO,G3(:,:,:,153))
  call loop_QV_A(G3(:,:,:,153),wf(:,-4),G3(:,:,:,154))
  call loop_Q_A(G3(:,:,:,154),Q(:,30),ZERO,G4(:,:,:,83))
  call loop_QV_A(G4(:,:,:,83),wf(:,0),G4(:,:,:,84))
  call check_last_Q_A(l_switch,G4(:,:,:,84),Q(:,31),ZERO,G5tensor(:,42))
  call loop_QZ_A(G1(:,:,:,48),wf(:,-1),G1(:,:,:,50),gZd)
  call loop_Q_A(G1(:,:,:,50),Q(:,6),ZERO,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,5),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,30),ZERO,G3(:,:,:,155))
  call loop_QV_A(G3(:,:,:,155),wf(:,0),G3(:,:,:,156))
  call check_last_Q_A(l_switch,G3(:,:,:,156),Q(:,31),ZERO,G4tensor(:,36))
  call loop_QV_A(G2(:,:,:,117),wf(:,-4),G2(:,:,:,119))
  call loop_Q_A(G2(:,:,:,119),Q(:,22),ZERO,G3(:,:,:,157))
  call loop_QV_A(G3(:,:,:,157),wf(:,-3),G3(:,:,:,158))
  call loop_Q_A(G3(:,:,:,158),Q(:,30),ZERO,G4(:,:,:,85))
  call loop_QV_A(G4(:,:,:,85),wf(:,0),G4(:,:,:,86))
  call check_last_Q_A(l_switch,G4(:,:,:,86),Q(:,31),ZERO,G5tensor(:,43))
  call loop_QV_A(G2(:,:,:,117),wf(:,-3),G2(:,:,:,120))
  call loop_Q_A(G2(:,:,:,120),Q(:,14),ZERO,G3(:,:,:,159))
  call loop_QV_A(G3(:,:,:,159),wf(:,-4),G3(:,:,:,160))
  call loop_Q_A(G3(:,:,:,160),Q(:,30),ZERO,G4(:,:,:,87))
  call loop_QV_A(G4(:,:,:,87),wf(:,0),G4(:,:,:,88))
  call check_last_Q_A(l_switch,G4(:,:,:,88),Q(:,31),ZERO,G5tensor(:,44))
  call loop_QV_A(G1(:,:,:,48),wf(:,-4),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,20),ZERO,G2(:,:,:,121))
  call loop_QZ_A(G2(:,:,:,121),wf(:,-1),G2(:,:,:,122),gZu)
  call loop_Q_A(G2(:,:,:,122),Q(:,22),ZERO,G3(:,:,:,161))
  call loop_QV_A(G3(:,:,:,161),wf(:,-3),G3(:,:,:,162))
  call loop_Q_A(G3(:,:,:,162),Q(:,30),ZERO,G4(:,:,:,89))
  call loop_QV_A(G4(:,:,:,89),wf(:,0),G4(:,:,:,90))
  call check_last_Q_A(l_switch,G4(:,:,:,90),Q(:,31),ZERO,G5tensor(:,45))
  call loop_QZ_A(G2(:,:,:,121),wf(:,-1),G2(:,:,:,123),gZd)
  call loop_Q_A(G2(:,:,:,123),Q(:,22),ZERO,G3(:,:,:,163))
  call loop_QV_A(G3(:,:,:,163),wf(:,-3),G3(:,:,:,164))
  call loop_Q_A(G3(:,:,:,164),Q(:,30),ZERO,G4(:,:,:,91))
  call loop_QV_A(G4(:,:,:,91),wf(:,0),G4(:,:,:,92))
  call check_last_Q_A(l_switch,G4(:,:,:,92),Q(:,31),ZERO,G5tensor(:,46))
  call loop_QV_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,12),ZERO,G2(:,:,:,124))
  call loop_QZ_A(G2(:,:,:,124),wf(:,-1),G2(:,:,:,125),gZu)
  call loop_Q_A(G2(:,:,:,125),Q(:,14),ZERO,G3(:,:,:,165))
  call loop_QV_A(G3(:,:,:,165),wf(:,-4),G3(:,:,:,166))
  call loop_Q_A(G3(:,:,:,166),Q(:,30),ZERO,G4(:,:,:,93))
  call loop_QV_A(G4(:,:,:,93),wf(:,0),G4(:,:,:,94))
  call check_last_Q_A(l_switch,G4(:,:,:,94),Q(:,31),ZERO,G5tensor(:,47))
  call loop_QZ_A(G2(:,:,:,124),wf(:,-1),G2(:,:,:,126),gZd)
  call loop_Q_A(G2(:,:,:,126),Q(:,14),ZERO,G3(:,:,:,167))
  call loop_QV_A(G3(:,:,:,167),wf(:,-4),G3(:,:,:,168))
  call loop_Q_A(G3(:,:,:,168),Q(:,30),ZERO,G4(:,:,:,95))
  call loop_QV_A(G4(:,:,:,95),wf(:,0),G4(:,:,:,96))
  call check_last_Q_A(l_switch,G4(:,:,:,96),Q(:,31),ZERO,G5tensor(:,48))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,13),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,13),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,19),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,19),T4sum(1:70,1))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,14),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,14),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,20),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,20),T4sum(1:70,2))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,25),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,25),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,27),T4sum(1:70,3))
  M(2) = M(2) + (CI*f(3) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,27),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,26),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,26),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,28),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,28),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,15),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,15),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,21),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,21),T4sum(1:70,4))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,16),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,16),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,22),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,22),T4sum(1:70,5))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,29),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,29),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,31),T4sum(1:70,6))
  M(2) = M(2) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,31),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,30),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,30),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,32),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,32),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,17),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,17),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,23),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,23),T4sum(1:70,7))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,18),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,18),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,24),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,24),T4sum(1:70,8))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,33),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,33),T4sum(1:70,9))
  M(1) = M(1) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,35),T4sum(1:70,9))
  M(2) = M(2) + (CI*f(3) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,35),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,34),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,34),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,36),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,36),T4sum(1:70,9))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,3),T5sum(1:126,1))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,9),T5sum(1:126,1))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,15),T5sum(1:126,1))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,21),T5sum(1:126,1))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,1),T5sum(1:126,2))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,7),T5sum(1:126,2))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,13),T5sum(1:126,2))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,19),T5sum(1:126,2))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,5),T5sum(1:126,3))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,11),T5sum(1:126,3))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,17),T5sum(1:126,3))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,23),T5sum(1:126,3))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,2),T5sum(1:126,4))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,8),T5sum(1:126,4))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,14),T5sum(1:126,4))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,20),T5sum(1:126,4))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,6),T5sum(1:126,5))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,12),T5sum(1:126,5))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,18),T5sum(1:126,5))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,24),T5sum(1:126,5))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,4),T5sum(1:126,6))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,10),T5sum(1:126,6))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,16),T5sum(1:126,6))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,22),T5sum(1:126,6))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,33),T5sum(1:126,7))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,41),T5sum(1:126,7))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,35),T5sum(1:126,7))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,43),T5sum(1:126,7))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,37),T5sum(1:126,8))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,45),T5sum(1:126,8))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,38),T5sum(1:126,8))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,46),T5sum(1:126,8))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,34),T5sum(1:126,9))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,42),T5sum(1:126,9))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,36),T5sum(1:126,9))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,44),T5sum(1:126,9))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,39),T5sum(1:126,10))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,47),T5sum(1:126,10))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,40),T5sum(1:126,10))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,48),T5sum(1:126,10))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,25),T5sum(1:126,11))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,29),T5sum(1:126,11))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,26),T5sum(1:126,11))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,30),T5sum(1:126,11))
  M(2) = M(2) + (f(5)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,27),T5sum(1:126,12))
  M(1) = M(1) + (f(5)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,31),T5sum(1:126,12))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,28),T5sum(1:126,12))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,32),T5sum(1:126,12))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_azggg_2_/**/REALKIND
