
! **********************************************************************
module ol_tensor_sum_storage_ppvvj2_uuxaag_4_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,2)
  complex(REALKIND) :: momenta_2(4,2)
  complex(REALKIND) :: momenta_3(4,3)
  complex(REALKIND) :: momenta_4(4,3)
  complex(REALKIND) :: momenta_5(4,3)

  complex(REALKIND), save :: masses2_1(3)
  complex(REALKIND), save :: masses2_2(3)
  complex(REALKIND), save :: masses2_3(3)
  complex(REALKIND), save :: masses2_4(4)
  complex(REALKIND), save :: masses2_5(4)
  complex(REALKIND), save :: masses2_6(4)

  complex(REALKIND), save :: T3sum(35,6) = 0
  complex(REALKIND), save :: T4sum(70,9) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppvvj2_uuxaag_4")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppvvj2_uuxaag_4")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T3sum(:,1), 0)
  call scale_one_tsum(T3sum(:,2), 0)
  call scale_one_tsum(T3sum(:,3), 0)
  call scale_one_tsum(T3sum(:,4), 0)
  call scale_one_tsum(T3sum(:,5), 0)
  call scale_one_tsum(T3sum(:,6), 0)
  call scale_one_tsum(T4sum(:,1), 2)
  call scale_one_tsum(T4sum(:,2), 2)
  call scale_one_tsum(T4sum(:,3), 2)
  call scale_one_tsum(T4sum(:,4), 2)
  call scale_one_tsum(T4sum(:,5), 2)
  call scale_one_tsum(T4sum(:,6), 2)
  call scale_one_tsum(T4sum(:,7), 2)
  call scale_one_tsum(T4sum(:,8), 2)
  call scale_one_tsum(T4sum(:,9), 2)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_ppvvj2_uuxaag_4, only: &
       & channel_number_ppvvj2_uuxaag_4
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_ppvvj2_uuxaag_4)
  M2 = 0

  momenta_1(:,1) = Q(1:4,8)
  momenta_1(:,2) = Q(1:4,24)
  momenta_2(:,1) = Q(1:4,11)
  momenta_2(:,2) = Q(1:4,27)
  momenta_3(:,1) = Q(1:4,4)
  momenta_3(:,2) = Q(1:4,12)
  momenta_3(:,3) = Q(1:4,28)
  momenta_4(:,1) = Q(1:4,4)
  momenta_4(:,2) = Q(1:4,20)
  momenta_4(:,3) = Q(1:4,28)
  momenta_5(:,1) = Q(1:4,8)
  momenta_5(:,2) = Q(1:4,12)
  momenta_5(:,3) = Q(1:4,28)

  masses2_1 = [ MB2, MB2, MB2 ]
  masses2_2 = [ MT2, MT2, MT2 ]
  masses2_3 = [ ZERO2, ZERO2, ZERO2 ]
  masses2_4 = [ MB2, MB2, MB2, MB2 ]
  masses2_5 = [ MT2, MT2, MT2, MT2 ]
  masses2_6 = [ ZERO2, ZERO2, ZERO2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call tensor_integral(3, momenta_1, masses2_3, T3sum(:,1))
  call tensor_integral(3, momenta_1, masses2_2, T3sum(:,2))
  call tensor_integral(3, momenta_1, masses2_1, T3sum(:,3))
  call tensor_integral(3, momenta_2, masses2_3, T3sum(:,4))
  call tensor_integral(3, momenta_2, masses2_2, T3sum(:,5))
  call tensor_integral(3, momenta_2, masses2_1, T3sum(:,6))

  call tensor_integral(4, momenta_5, masses2_6, T4sum(:,1))
  call tensor_integral(4, momenta_5, masses2_5, T4sum(:,2))
  call tensor_integral(4, momenta_5, masses2_4, T4sum(:,3))
  call tensor_integral(4, momenta_3, masses2_6, T4sum(:,4))
  call tensor_integral(4, momenta_3, masses2_5, T4sum(:,5))
  call tensor_integral(4, momenta_3, masses2_4, T4sum(:,6))
  call tensor_integral(4, momenta_4, masses2_6, T4sum(:,7))
  call tensor_integral(4, momenta_4, masses2_5, T4sum(:,8))
  call tensor_integral(4, momenta_4, masses2_4, T4sum(:,9))

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppvvj2_uuxaag_4_/**/REALKIND
