
! **********************************************************************
module ol_tensor_sum_storage_ppvvj2_azggg_2_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND
  implicit none

  complex(REALKIND) :: momenta_1(4,3)
  complex(REALKIND) :: momenta_2(4,3)
  complex(REALKIND) :: momenta_3(4,3)
  complex(REALKIND) :: momenta_4(4,3)
  complex(REALKIND) :: momenta_5(4,3)
  complex(REALKIND) :: momenta_6(4,3)
  complex(REALKIND) :: momenta_7(4,3)
  complex(REALKIND) :: momenta_8(4,3)
  complex(REALKIND) :: momenta_9(4,3)
  complex(REALKIND) :: momenta_10(4,4)
  complex(REALKIND) :: momenta_11(4,4)
  complex(REALKIND) :: momenta_12(4,4)
  complex(REALKIND) :: momenta_13(4,4)
  complex(REALKIND) :: momenta_14(4,4)
  complex(REALKIND) :: momenta_15(4,4)
  complex(REALKIND) :: momenta_16(4,4)
  complex(REALKIND) :: momenta_17(4,4)
  complex(REALKIND) :: momenta_18(4,4)
  complex(REALKIND) :: momenta_19(4,4)
  complex(REALKIND) :: momenta_20(4,4)
  complex(REALKIND) :: momenta_21(4,4)

  complex(REALKIND), save :: masses2_1(4)
  complex(REALKIND), save :: masses2_2(5)

  complex(REALKIND), save :: T4sum(70,9) = 0
  complex(REALKIND), save :: T5sum(126,12) = 0

  contains

#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppvvj2_azggg_2")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppvvj2_azggg_2")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 5
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  implicit none

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T4sum(:,1), 2)
  call scale_one_tsum(T4sum(:,2), 2)
  call scale_one_tsum(T4sum(:,3), 2)
  call scale_one_tsum(T4sum(:,4), 2)
  call scale_one_tsum(T4sum(:,5), 2)
  call scale_one_tsum(T4sum(:,6), 2)
  call scale_one_tsum(T4sum(:,7), 2)
  call scale_one_tsum(T4sum(:,8), 2)
  call scale_one_tsum(T4sum(:,9), 2)
  call scale_one_tsum(T5sum(:,1), 4)
  call scale_one_tsum(T5sum(:,2), 4)
  call scale_one_tsum(T5sum(:,3), 4)
  call scale_one_tsum(T5sum(:,4), 4)
  call scale_one_tsum(T5sum(:,5), 4)
  call scale_one_tsum(T5sum(:,6), 4)
  call scale_one_tsum(T5sum(:,7), 4)
  call scale_one_tsum(T5sum(:,8), 4)
  call scale_one_tsum(T5sum(:,9), 4)
  call scale_one_tsum(T5sum(:,10), 4)
  call scale_one_tsum(T5sum(:,11), 4)
  call scale_one_tsum(T5sum(:,12), 4)

end subroutine scale_tensor_sum


! **********************************************************************
subroutine integrate_tensor_sum(M2)
! **********************************************************************
  use ol_external_ppvvj2_azggg_2, only: &
       & channel_number_ppvvj2_azggg_2
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/DREALKIND, only: channel_on
  use ol_loop_routines_/**/REALKIND, only: TI_call, tensor_integral
  implicit none
  real(REALKIND), intent(out) :: M2
  call channel_on(channel_number_ppvvj2_azggg_2)
  M2 = 0

  momenta_1(:,1) = Q(1:4,2)
  momenta_1(:,2) = Q(1:4,6)
  momenta_1(:,3) = Q(1:4,30)
  momenta_2(:,1) = Q(1:4,2)
  momenta_2(:,2) = Q(1:4,10)
  momenta_2(:,3) = Q(1:4,30)
  momenta_3(:,1) = Q(1:4,2)
  momenta_3(:,2) = Q(1:4,14)
  momenta_3(:,3) = Q(1:4,30)
  momenta_4(:,1) = Q(1:4,2)
  momenta_4(:,2) = Q(1:4,18)
  momenta_4(:,3) = Q(1:4,30)
  momenta_5(:,1) = Q(1:4,2)
  momenta_5(:,2) = Q(1:4,22)
  momenta_5(:,3) = Q(1:4,30)
  momenta_6(:,1) = Q(1:4,2)
  momenta_6(:,2) = Q(1:4,26)
  momenta_6(:,3) = Q(1:4,30)
  momenta_7(:,1) = Q(1:4,4)
  momenta_7(:,2) = Q(1:4,6)
  momenta_7(:,3) = Q(1:4,30)
  momenta_8(:,1) = Q(1:4,8)
  momenta_8(:,2) = Q(1:4,10)
  momenta_8(:,3) = Q(1:4,30)
  momenta_9(:,1) = Q(1:4,12)
  momenta_9(:,2) = Q(1:4,14)
  momenta_9(:,3) = Q(1:4,30)
  momenta_10(:,1) = Q(1:4,2)
  momenta_10(:,2) = Q(1:4,6)
  momenta_10(:,3) = Q(1:4,14)
  momenta_10(:,4) = Q(1:4,30)
  momenta_11(:,1) = Q(1:4,2)
  momenta_11(:,2) = Q(1:4,6)
  momenta_11(:,3) = Q(1:4,22)
  momenta_11(:,4) = Q(1:4,30)
  momenta_12(:,1) = Q(1:4,2)
  momenta_12(:,2) = Q(1:4,10)
  momenta_12(:,3) = Q(1:4,14)
  momenta_12(:,4) = Q(1:4,30)
  momenta_13(:,1) = Q(1:4,2)
  momenta_13(:,2) = Q(1:4,10)
  momenta_13(:,3) = Q(1:4,26)
  momenta_13(:,4) = Q(1:4,30)
  momenta_14(:,1) = Q(1:4,2)
  momenta_14(:,2) = Q(1:4,18)
  momenta_14(:,3) = Q(1:4,22)
  momenta_14(:,4) = Q(1:4,30)
  momenta_15(:,1) = Q(1:4,2)
  momenta_15(:,2) = Q(1:4,18)
  momenta_15(:,3) = Q(1:4,26)
  momenta_15(:,4) = Q(1:4,30)
  momenta_16(:,1) = Q(1:4,4)
  momenta_16(:,2) = Q(1:4,6)
  momenta_16(:,3) = Q(1:4,14)
  momenta_16(:,4) = Q(1:4,30)
  momenta_17(:,1) = Q(1:4,4)
  momenta_17(:,2) = Q(1:4,6)
  momenta_17(:,3) = Q(1:4,22)
  momenta_17(:,4) = Q(1:4,30)
  momenta_18(:,1) = Q(1:4,4)
  momenta_18(:,2) = Q(1:4,12)
  momenta_18(:,3) = Q(1:4,14)
  momenta_18(:,4) = Q(1:4,30)
  momenta_19(:,1) = Q(1:4,4)
  momenta_19(:,2) = Q(1:4,20)
  momenta_19(:,3) = Q(1:4,22)
  momenta_19(:,4) = Q(1:4,30)
  momenta_20(:,1) = Q(1:4,8)
  momenta_20(:,2) = Q(1:4,10)
  momenta_20(:,3) = Q(1:4,14)
  momenta_20(:,4) = Q(1:4,30)
  momenta_21(:,1) = Q(1:4,8)
  momenta_21(:,2) = Q(1:4,12)
  momenta_21(:,3) = Q(1:4,14)
  momenta_21(:,4) = Q(1:4,30)

  masses2_1 = [ ZERO2, ZERO2, ZERO2, ZERO2 ]
  masses2_2 = [ ZERO2, ZERO2, ZERO2, ZERO2, ZERO2 ]

#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif

  call tensor_integral(4, momenta_3, masses2_1, T4sum(:,1))
  call tensor_integral(4, momenta_4, masses2_1, T4sum(:,2))
  call tensor_integral(4, momenta_9, masses2_1, T4sum(:,3))
  call tensor_integral(4, momenta_5, masses2_1, T4sum(:,4))
  call tensor_integral(4, momenta_2, masses2_1, T4sum(:,5))
  call tensor_integral(4, momenta_8, masses2_1, T4sum(:,6))
  call tensor_integral(4, momenta_6, masses2_1, T4sum(:,7))
  call tensor_integral(4, momenta_1, masses2_1, T4sum(:,8))
  call tensor_integral(4, momenta_7, masses2_1, T4sum(:,9))

  call tensor_integral(5, momenta_13, masses2_2, T5sum(:,1))
  call tensor_integral(5, momenta_15, masses2_2, T5sum(:,2))
  call tensor_integral(5, momenta_11, masses2_2, T5sum(:,3))
  call tensor_integral(5, momenta_14, masses2_2, T5sum(:,4))
  call tensor_integral(5, momenta_10, masses2_2, T5sum(:,5))
  call tensor_integral(5, momenta_12, masses2_2, T5sum(:,6))
  call tensor_integral(5, momenta_17, masses2_2, T5sum(:,7))
  call tensor_integral(5, momenta_19, masses2_2, T5sum(:,8))
  call tensor_integral(5, momenta_16, masses2_2, T5sum(:,9))
  call tensor_integral(5, momenta_18, masses2_2, T5sum(:,10))
  call tensor_integral(5, momenta_20, masses2_2, T5sum(:,11))
  call tensor_integral(5, momenta_21, masses2_2, T5sum(:,12))

#ifdef LOOPSQUARED
  end if
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppvvj2_azggg_2_/**/REALKIND
