
module ol_colourmatrix_ppvvj2_bbxwwxg_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,2), KL(0,2), KL2(34,2), KL2ct(34,2), KL2ct2(34,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  12,   0]
  KL2( 2,:) = [   0,   0]
  KL2( 3,:) = [  16,   0]
  KL2( 4,:) = [   0,   0]
  KL2( 5,:) = [   2,   0]
  KL2( 6,:) = [   0,   0]
  KL2( 7,:) = [  16,   0]
  KL2( 8,:) = [   0,   0]
  KL2( 9,:) = [   0,   0]
  KL2(10,:) = [   0,   0]
  KL2(11,:) = [   0,   0]
  KL2(12,:) = [   0,   0]
  KL2(13,:) = [   0,   0]
  KL2(14,:) = [   0,   0]
  KL2(15,:) = [   0,   0]
  KL2(16,:) = [   0,   0]
  KL2(17,:) = [   0,   0]
  KL2(18,:) = [   0,   0]
  KL2(19,:) = [   0,   0]
  KL2(20,:) = [   0,   0]
  KL2(21,:) = [   0,   0]
  KL2(22,:) = [   0,   0]
  KL2(23,:) = [ -18,   0]
  KL2(24,:) = [   0,   0]
  KL2(25,:) = [ -18,   0]
  KL2(26,:) = [   0,   0]
  KL2(27,:) = [   0,   0]
  KL2(28,:) = [   0,   0]
  KL2(29,:) = [   0,   0]
  KL2(30,:) = [   0,   0]
  KL2(31,:) = [  36,   0]
  KL2(32,:) = [   0,   0]
  KL2(33,:) = [   0,   0]
  KL2(34,:) = [   0,   0]
  KL2 = (1._/**/REALKIND / 3) * KL2

  KL2ct( 1,:) = [  12,   0]
  KL2ct( 2,:) = [   0,   0]
  KL2ct( 3,:) = [  16,   0]
  KL2ct( 4,:) = [   0,   0]
  KL2ct( 5,:) = [   2,   0]
  KL2ct( 6,:) = [   0,   0]
  KL2ct( 7,:) = [  16,   0]
  KL2ct( 8,:) = [   0,   0]
  KL2ct( 9,:) = [   0,   0]
  KL2ct(10,:) = [   0,   0]
  KL2ct(11,:) = [   0,   0]
  KL2ct(12,:) = [   0,   0]
  KL2ct(13,:) = [   0,   0]
  KL2ct(14,:) = [   0,   0]
  KL2ct(15,:) = [   0,   0]
  KL2ct(16,:) = [   0,   0]
  KL2ct(17,:) = [   0,   0]
  KL2ct(18,:) = [   0,   0]
  KL2ct(19,:) = [   0,   0]
  KL2ct(20,:) = [   0,   0]
  KL2ct(21,:) = [   0,   0]
  KL2ct(22,:) = [   0,   0]
  KL2ct(23,:) = [ -18,   0]
  KL2ct(24,:) = [   0,   0]
  KL2ct(25,:) = [ -18,   0]
  KL2ct(26,:) = [   0,   0]
  KL2ct(27,:) = [   0,   0]
  KL2ct(28,:) = [   0,   0]
  KL2ct(29,:) = [   0,   0]
  KL2ct(30,:) = [   0,   0]
  KL2ct(31,:) = [  36,   0]
  KL2ct(32,:) = [   0,   0]
  KL2ct(33,:) = [   0,   0]
  KL2ct(34,:) = [   0,   0]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [  12,   0]
  KL2ct2( 2,:) = [   0,   0]
  KL2ct2( 3,:) = [  16,   0]
  KL2ct2( 4,:) = [   0,   0]
  KL2ct2( 5,:) = [   2,   0]
  KL2ct2( 6,:) = [   0,   0]
  KL2ct2( 7,:) = [  16,   0]
  KL2ct2( 8,:) = [   0,   0]
  KL2ct2( 9,:) = [   0,   0]
  KL2ct2(10,:) = [   0,   0]
  KL2ct2(11,:) = [   0,   0]
  KL2ct2(12,:) = [   0,   0]
  KL2ct2(13,:) = [   0,   0]
  KL2ct2(14,:) = [   0,   0]
  KL2ct2(15,:) = [   0,   0]
  KL2ct2(16,:) = [   0,   0]
  KL2ct2(17,:) = [   0,   0]
  KL2ct2(18,:) = [   0,   0]
  KL2ct2(19,:) = [   0,   0]
  KL2ct2(20,:) = [   0,   0]
  KL2ct2(21,:) = [   0,   0]
  KL2ct2(22,:) = [   0,   0]
  KL2ct2(23,:) = [ -18,   0]
  KL2ct2(24,:) = [   0,   0]
  KL2ct2(25,:) = [ -18,   0]
  KL2ct2(26,:) = [   0,   0]
  KL2ct2(27,:) = [   0,   0]
  KL2ct2(28,:) = [   0,   0]
  KL2ct2(29,:) = [   0,   0]
  KL2ct2(30,:) = [   0,   0]
  KL2ct2(31,:) = [  36,   0]
  KL2ct2(32,:) = [   0,   0]
  KL2ct2(33,:) = [   0,   0]
  KL2ct2(34,:) = [   0,   0]
  KL2ct2 = (1._/**/REALKIND / 3) * KL2ct2


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvj2_bbxwwxg_4_/**/REALKIND



module ol_forced_parameters_ppvvj2_bbxwwxg_4_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvj2_bbxwwxg_4_/**/REALKIND

module ol_loop_ppvvj2_bbxwwxg_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(13), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:7)
  ! denominators
  complex(REALKIND), save :: den(7)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,72), Mct(2,72), Mcol_loop(2,72)
  ! zero helicity identifier
  logical,           save :: zerohel(72) = .true., zerohel_ct(72) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*countertermnorm*ctWWGG*eQED**2*gQCD**3
    f( 2) = (countertermnorm*ctZGG*cw*eQED**2*gQCD**3)/sw
    f( 3) = (eQED**2*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f( 4) = (2*eQED**2*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f( 5) = (4*eQED**2*gQCD**3*integralnorm*SwF)/3._/**/REALKIND
    f( 6) = (eQED**2*gQCD**3*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f( 7) = (eQED**2*gQCD**3*integralnorm*SwF)/sw**2
    f( 8) = (cw*eQED**2*gQCD**3*integralnorm*SwF)/sw
    f( 9) = (2*cw*eQED**2*gQCD**3*integralnorm*SwF)/sw
    f(10) = (CI*countertermnorm*ctHGGsel*eQED**2*gQCD**3*lambdaHWW*MB*MW*YB)/sw
    f(11) = (eQED**2*gQCD**3*integralnorm*lambdaHWW*SwF*YB)/(sw**2*2._/**/REALKIND)
    f(12) = (CI*countertermnorm*ctHGGsel*eQED**2*gQCD**3*lambdaHWW*MT*MW*YT)/sw
    f(13) = (eQED**2*gQCD**3*integralnorm*lambdaHWW*SwF*YT)/(sw**2*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(0), M2(2)
  complex(REALKIND) :: A(4)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMB, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rMB, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rMW, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rMW, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rMB, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rMB, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rMW, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rMW, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call counter_VVG_G(wf(:,-2),wf(:,-3),wf(:,-4),wf(:,2))
  call vert_VV_S(wf(:,-2),wf(:,-3),wf(:,3))
  call counter_GG_S(wf(:,1),wf(:,-4),wf(:,4))
  call vert_UV_W(wf(:,-3),Q(:,8),wf(:,-2),Q(:,4),wf(:,5))
  call prop_W_W(wf(:,5),Q(:,12),MZ,1_intkind1,wf(:,6))
  call counter_GG_V(wf(:,1),Q(:,3),wf(:,-4),Q(:,16),wf(:,7))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3))
  den(2) = 1 / (Q(5,12) - MH2)
  den(4) = 1 / (Q(5,12) - MZ2)
  den(6) = 1 / (Q(5,12))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(4)


  A(1) = cont_VV(wf(:,1),wf(:,2)) * den(1)
  A(2) = cont_SS(wf(:,3),wf(:,4)) * den(3)
  A(3) = cont_SS(wf(:,3),wf(:,4)) * den(3)
  A(4) = cont_VV(wf(:,6),wf(:,7)) * den(5)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(4)
  complex(REALKIND), intent(out) :: M1(0), M2(2)


  M2(1) = -(A(3)*f(10))-A(2)*f(12)
  M2(2) = A(1)*f(1)-A(4)*f(2)

end subroutine colourvectors

end module ol_loop_ppvvj2_bbxwwxg_4_/**/REALKIND
