
module ol_vamp_1_ppvvj2_aaggg_2_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  complex(REALKIND), save, target, allocatable :: G4tensorhel(:,:,:)
  complex(REALKIND), save, target, allocatable :: G5tensorhel(:,:,:)

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvvj2_aaggg_2.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvvj2_aaggg_2.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_ppvvj2_aaggg_2_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_ppvvj2_aaggg_2_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(inout) :: M(2)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,9) :: G0
  complex(REALKIND), dimension(4,5,4,32) :: G1
  complex(REALKIND), dimension(4,15,4,66) :: G2
  complex(REALKIND), dimension(4,35,4,84) :: G3
  complex(REALKIND), dimension(4,70,4,48) :: G4
  complex(REALKIND), pointer :: G4tensor(:,:)
  complex(REALKIND), pointer :: G5tensor(:,:)
#ifdef PRECISION_dp
  logical, save :: first = .true.
  if (first) then
#endif
    allocate(G4tensorhel(70,18,32))
    allocate(G5tensorhel(126,24,32))
#ifdef PRECISION_dp
    first = .false.
  end if
#endif
  if (mode == -1) then
    call gtdealloc()
    return
  end if
  G4tensor => G4tensorhel(:,:,hel)
  G5tensor => G5tensorhel(:,:,hel)

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_AV_Q(G0(:,:,:,1),wf(:,-1),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,2),ZERO,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,14),ZERO,G2(:,:,:,1))
  call loop_AV_Q(G2(:,:,:,1),wf(:,-4),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,30),ZERO,G3(:,:,:,1))
  call loop_AV_Q(G3(:,:,:,1),wf(:,0),G3(:,:,:,2))
  call check_last_A_Q(l_switch,G3(:,:,:,2),Q(:,31),ZERO,G4tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,18),ZERO,G2(:,:,:,3))
  call loop_AV_Q(G2(:,:,:,3),wf(:,1),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,30),ZERO,G3(:,:,:,3))
  call loop_AV_Q(G3(:,:,:,3),wf(:,0),G3(:,:,:,4))
  call check_last_A_Q(l_switch,G3(:,:,:,4),Q(:,31),ZERO,G4tensor(:,2))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-3),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,26),ZERO,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-2),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,30),ZERO,G4(:,:,:,1))
  call loop_AV_Q(G4(:,:,:,1),wf(:,0),G4(:,:,:,2))
  call check_last_A_Q(l_switch,G4(:,:,:,2),Q(:,31),ZERO,G5tensor(:,1))
  call loop_AV_Q(G2(:,:,:,3),wf(:,-2),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,22),ZERO,G3(:,:,:,7))
  call loop_AV_Q(G3(:,:,:,7),wf(:,-3),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,30),ZERO,G4(:,:,:,3))
  call loop_AV_Q(G4(:,:,:,3),wf(:,0),G4(:,:,:,4))
  call check_last_A_Q(l_switch,G4(:,:,:,4),Q(:,31),ZERO,G5tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,22),ZERO,G2(:,:,:,7))
  call loop_AV_Q(G2(:,:,:,7),wf(:,-3),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,30),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,0),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,31),ZERO,G4tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,10),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,3),G2(:,:,:,10))
  call loop_A_Q(G2(:,:,:,10),Q(:,30),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,0),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,31),ZERO,G4tensor(:,4))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-4),G2(:,:,:,11))
  call loop_A_Q(G2(:,:,:,11),Q(:,26),ZERO,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,-2),G3(:,:,:,14))
  call loop_A_Q(G3(:,:,:,14),Q(:,30),ZERO,G4(:,:,:,5))
  call loop_AV_Q(G4(:,:,:,5),wf(:,0),G4(:,:,:,6))
  call check_last_A_Q(l_switch,G4(:,:,:,6),Q(:,31),ZERO,G5tensor(:,3))
  call loop_AV_Q(G2(:,:,:,9),wf(:,-2),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,14),ZERO,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,30),ZERO,G4(:,:,:,7))
  call loop_AV_Q(G4(:,:,:,7),wf(:,0),G4(:,:,:,8))
  call check_last_A_Q(l_switch,G4(:,:,:,8),Q(:,31),ZERO,G5tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,26),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,30),ZERO,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,0),G3(:,:,:,18))
  call check_last_A_Q(l_switch,G3(:,:,:,18),Q(:,31),ZERO,G4tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,6),ZERO,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,5),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,30),ZERO,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,0),G3(:,:,:,20))
  call check_last_A_Q(l_switch,G3(:,:,:,20),Q(:,31),ZERO,G4tensor(:,6))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-4),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,22),ZERO,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-3),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,30),ZERO,G4(:,:,:,9))
  call loop_AV_Q(G4(:,:,:,9),wf(:,0),G4(:,:,:,10))
  call check_last_A_Q(l_switch,G4(:,:,:,10),Q(:,31),ZERO,G5tensor(:,5))
  call loop_AV_Q(G2(:,:,:,15),wf(:,-3),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,14),ZERO,G3(:,:,:,23))
  call loop_AV_Q(G3(:,:,:,23),wf(:,-4),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,30),ZERO,G4(:,:,:,11))
  call loop_AV_Q(G4(:,:,:,11),wf(:,0),G4(:,:,:,12))
  call check_last_A_Q(l_switch,G4(:,:,:,12),Q(:,31),ZERO,G5tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,-1),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,2),ZERO,G1(:,:,:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,1),G1(:,:,:,9))
  call loop_Q_A(G1(:,:,:,9),Q(:,14),ZERO,G2(:,:,:,19))
  call loop_QV_A(G2(:,:,:,19),wf(:,-4),G2(:,:,:,20))
  call loop_Q_A(G2(:,:,:,20),Q(:,30),ZERO,G3(:,:,:,25))
  call loop_QV_A(G3(:,:,:,25),wf(:,0),G3(:,:,:,26))
  call check_last_Q_A(l_switch,G3(:,:,:,26),Q(:,31),ZERO,G4tensor(:,7))
  call loop_QV_A(G1(:,:,:,8),wf(:,-4),G1(:,:,:,10))
  call loop_Q_A(G1(:,:,:,10),Q(:,18),ZERO,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call loop_Q_A(G2(:,:,:,22),Q(:,30),ZERO,G3(:,:,:,27))
  call loop_QV_A(G3(:,:,:,27),wf(:,0),G3(:,:,:,28))
  call check_last_Q_A(l_switch,G3(:,:,:,28),Q(:,31),ZERO,G4tensor(:,8))
  call loop_QV_A(G2(:,:,:,21),wf(:,-3),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,26),ZERO,G3(:,:,:,29))
  call loop_QV_A(G3(:,:,:,29),wf(:,-2),G3(:,:,:,30))
  call loop_Q_A(G3(:,:,:,30),Q(:,30),ZERO,G4(:,:,:,13))
  call loop_QV_A(G4(:,:,:,13),wf(:,0),G4(:,:,:,14))
  call check_last_Q_A(l_switch,G4(:,:,:,14),Q(:,31),ZERO,G5tensor(:,7))
  call loop_QV_A(G2(:,:,:,21),wf(:,-2),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,22),ZERO,G3(:,:,:,31))
  call loop_QV_A(G3(:,:,:,31),wf(:,-3),G3(:,:,:,32))
  call loop_Q_A(G3(:,:,:,32),Q(:,30),ZERO,G4(:,:,:,15))
  call loop_QV_A(G4(:,:,:,15),wf(:,0),G4(:,:,:,16))
  call check_last_Q_A(l_switch,G4(:,:,:,16),Q(:,31),ZERO,G5tensor(:,8))
  call loop_QV_A(G1(:,:,:,8),wf(:,3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,22),ZERO,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-3),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,30),ZERO,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,0),G3(:,:,:,34))
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,31),ZERO,G4tensor(:,9))
  call loop_QV_A(G1(:,:,:,8),wf(:,-3),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,10),ZERO,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,3),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,30),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,0),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,31),ZERO,G4tensor(:,10))
  call loop_QV_A(G2(:,:,:,27),wf(:,-4),G2(:,:,:,29))
  call loop_Q_A(G2(:,:,:,29),Q(:,26),ZERO,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38))
  call loop_Q_A(G3(:,:,:,38),Q(:,30),ZERO,G4(:,:,:,17))
  call loop_QV_A(G4(:,:,:,17),wf(:,0),G4(:,:,:,18))
  call check_last_Q_A(l_switch,G4(:,:,:,18),Q(:,31),ZERO,G5tensor(:,9))
  call loop_QV_A(G2(:,:,:,27),wf(:,-2),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,14),ZERO,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_Q_A(G3(:,:,:,40),Q(:,30),ZERO,G4(:,:,:,19))
  call loop_QV_A(G4(:,:,:,19),wf(:,0),G4(:,:,:,20))
  call check_last_Q_A(l_switch,G4(:,:,:,20),Q(:,31),ZERO,G5tensor(:,10))
  call loop_QV_A(G1(:,:,:,8),wf(:,5),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,26),ZERO,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,30),ZERO,G3(:,:,:,41))
  call loop_QV_A(G3(:,:,:,41),wf(:,0),G3(:,:,:,42))
  call check_last_Q_A(l_switch,G3(:,:,:,42),Q(:,31),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,8),wf(:,-2),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,6),ZERO,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,5),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,30),ZERO,G3(:,:,:,43))
  call loop_QV_A(G3(:,:,:,43),wf(:,0),G3(:,:,:,44))
  call check_last_Q_A(l_switch,G3(:,:,:,44),Q(:,31),ZERO,G4tensor(:,12))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,35))
  call loop_Q_A(G2(:,:,:,35),Q(:,22),ZERO,G3(:,:,:,45))
  call loop_QV_A(G3(:,:,:,45),wf(:,-3),G3(:,:,:,46))
  call loop_Q_A(G3(:,:,:,46),Q(:,30),ZERO,G4(:,:,:,21))
  call loop_QV_A(G4(:,:,:,21),wf(:,0),G4(:,:,:,22))
  call check_last_Q_A(l_switch,G4(:,:,:,22),Q(:,31),ZERO,G5tensor(:,11))
  call loop_QV_A(G2(:,:,:,33),wf(:,-3),G2(:,:,:,36))
  call loop_Q_A(G2(:,:,:,36),Q(:,14),ZERO,G3(:,:,:,47))
  call loop_QV_A(G3(:,:,:,47),wf(:,-4),G3(:,:,:,48))
  call loop_Q_A(G3(:,:,:,48),Q(:,30),ZERO,G4(:,:,:,23))
  call loop_QV_A(G4(:,:,:,23),wf(:,0),G4(:,:,:,24))
  call check_last_Q_A(l_switch,G4(:,:,:,24),Q(:,31),ZERO,G5tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,1),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,12),ZERO,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,-1),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,14),ZERO,G2(:,:,:,37))
  call loop_QV_A(G2(:,:,:,37),wf(:,-4),G2(:,:,:,38))
  call loop_Q_A(G2(:,:,:,38),Q(:,30),ZERO,G3(:,:,:,49))
  call loop_QV_A(G3(:,:,:,49),wf(:,0),G3(:,:,:,50))
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,31),ZERO,G4tensor(:,13))
  call loop_AV_Q(G0(:,:,:,1),wf(:,1),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,12),ZERO,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-1),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,14),ZERO,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,-4),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,30),ZERO,G3(:,:,:,51))
  call loop_AV_Q(G3(:,:,:,51),wf(:,0),G3(:,:,:,52))
  call check_last_A_Q(l_switch,G3(:,:,:,52),Q(:,31),ZERO,G4tensor(:,14))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,8),ZERO,G1(:,:,:,19))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-1),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,10),ZERO,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,3),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,30),ZERO,G3(:,:,:,53))
  call loop_AV_Q(G3(:,:,:,53),wf(:,0),G3(:,:,:,54))
  call check_last_A_Q(l_switch,G3(:,:,:,54),Q(:,31),ZERO,G4tensor(:,15))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,14),ZERO,G3(:,:,:,55))
  call loop_AV_Q(G3(:,:,:,55),wf(:,-4),G3(:,:,:,56))
  call loop_A_Q(G3(:,:,:,56),Q(:,30),ZERO,G4(:,:,:,25))
  call loop_AV_Q(G4(:,:,:,25),wf(:,0),G4(:,:,:,26))
  call check_last_A_Q(l_switch,G4(:,:,:,26),Q(:,31),ZERO,G5tensor(:,13))
  call loop_AV_Q(G1(:,:,:,19),wf(:,-2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,12),ZERO,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,-1),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,14),ZERO,G3(:,:,:,57))
  call loop_AV_Q(G3(:,:,:,57),wf(:,-4),G3(:,:,:,58))
  call loop_A_Q(G3(:,:,:,58),Q(:,30),ZERO,G4(:,:,:,27))
  call loop_AV_Q(G4(:,:,:,27),wf(:,0),G4(:,:,:,28))
  call check_last_A_Q(l_switch,G4(:,:,:,28),Q(:,31),ZERO,G5tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,-3),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,8),ZERO,G1(:,:,:,22))
  call loop_QV_A(G1(:,:,:,22),wf(:,-1),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,10),ZERO,G2(:,:,:,46))
  call loop_QV_A(G2(:,:,:,46),wf(:,3),G2(:,:,:,47))
  call loop_Q_A(G2(:,:,:,47),Q(:,30),ZERO,G3(:,:,:,59))
  call loop_QV_A(G3(:,:,:,59),wf(:,0),G3(:,:,:,60))
  call check_last_Q_A(l_switch,G3(:,:,:,60),Q(:,31),ZERO,G4tensor(:,16))
  call loop_QV_A(G2(:,:,:,46),wf(:,-2),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,14),ZERO,G3(:,:,:,61))
  call loop_QV_A(G3(:,:,:,61),wf(:,-4),G3(:,:,:,62))
  call loop_Q_A(G3(:,:,:,62),Q(:,30),ZERO,G4(:,:,:,29))
  call loop_QV_A(G4(:,:,:,29),wf(:,0),G4(:,:,:,30))
  call check_last_Q_A(l_switch,G4(:,:,:,30),Q(:,31),ZERO,G5tensor(:,15))
  call loop_QV_A(G1(:,:,:,22),wf(:,-2),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,12),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-1),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,14),ZERO,G3(:,:,:,63))
  call loop_QV_A(G3(:,:,:,63),wf(:,-4),G3(:,:,:,64))
  call loop_Q_A(G3(:,:,:,64),Q(:,30),ZERO,G4(:,:,:,31))
  call loop_QV_A(G4(:,:,:,31),wf(:,0),G4(:,:,:,32))
  call check_last_Q_A(l_switch,G4(:,:,:,32),Q(:,31),ZERO,G5tensor(:,16))
  call loop_AV_Q(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,4),ZERO,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-1),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,6),ZERO,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,5),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,30),ZERO,G3(:,:,:,65))
  call loop_AV_Q(G3(:,:,:,65),wf(:,0),G3(:,:,:,66))
  call check_last_A_Q(l_switch,G3(:,:,:,66),Q(:,31),ZERO,G4tensor(:,17))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-4),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,22),ZERO,G3(:,:,:,67))
  call loop_AV_Q(G3(:,:,:,67),wf(:,-3),G3(:,:,:,68))
  call loop_A_Q(G3(:,:,:,68),Q(:,30),ZERO,G4(:,:,:,33))
  call loop_AV_Q(G4(:,:,:,33),wf(:,0),G4(:,:,:,34))
  call check_last_A_Q(l_switch,G4(:,:,:,34),Q(:,31),ZERO,G5tensor(:,17))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-3),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,14),ZERO,G3(:,:,:,69))
  call loop_AV_Q(G3(:,:,:,69),wf(:,-4),G3(:,:,:,70))
  call loop_A_Q(G3(:,:,:,70),Q(:,30),ZERO,G4(:,:,:,35))
  call loop_AV_Q(G4(:,:,:,35),wf(:,0),G4(:,:,:,36))
  call check_last_A_Q(l_switch,G4(:,:,:,36),Q(:,31),ZERO,G5tensor(:,18))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,20),ZERO,G2(:,:,:,55))
  call loop_AV_Q(G2(:,:,:,55),wf(:,-1),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,22),ZERO,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-3),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,30),ZERO,G4(:,:,:,37))
  call loop_AV_Q(G4(:,:,:,37),wf(:,0),G4(:,:,:,38))
  call check_last_A_Q(l_switch,G4(:,:,:,38),Q(:,31),ZERO,G5tensor(:,19))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,12),ZERO,G2(:,:,:,57))
  call loop_AV_Q(G2(:,:,:,57),wf(:,-1),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,14),ZERO,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-4),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,30),ZERO,G4(:,:,:,39))
  call loop_AV_Q(G4(:,:,:,39),wf(:,0),G4(:,:,:,40))
  call check_last_A_Q(l_switch,G4(:,:,:,40),Q(:,31),ZERO,G5tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,4),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,-1),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,6),ZERO,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,5),G2(:,:,:,60))
  call loop_Q_A(G2(:,:,:,60),Q(:,30),ZERO,G3(:,:,:,75))
  call loop_QV_A(G3(:,:,:,75),wf(:,0),G3(:,:,:,76))
  call check_last_Q_A(l_switch,G3(:,:,:,76),Q(:,31),ZERO,G4tensor(:,18))
  call loop_QV_A(G2(:,:,:,59),wf(:,-4),G2(:,:,:,61))
  call loop_Q_A(G2(:,:,:,61),Q(:,22),ZERO,G3(:,:,:,77))
  call loop_QV_A(G3(:,:,:,77),wf(:,-3),G3(:,:,:,78))
  call loop_Q_A(G3(:,:,:,78),Q(:,30),ZERO,G4(:,:,:,41))
  call loop_QV_A(G4(:,:,:,41),wf(:,0),G4(:,:,:,42))
  call check_last_Q_A(l_switch,G4(:,:,:,42),Q(:,31),ZERO,G5tensor(:,21))
  call loop_QV_A(G2(:,:,:,59),wf(:,-3),G2(:,:,:,62))
  call loop_Q_A(G2(:,:,:,62),Q(:,14),ZERO,G3(:,:,:,79))
  call loop_QV_A(G3(:,:,:,79),wf(:,-4),G3(:,:,:,80))
  call loop_Q_A(G3(:,:,:,80),Q(:,30),ZERO,G4(:,:,:,43))
  call loop_QV_A(G4(:,:,:,43),wf(:,0),G4(:,:,:,44))
  call check_last_Q_A(l_switch,G4(:,:,:,44),Q(:,31),ZERO,G5tensor(:,22))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,20),ZERO,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,-1),G2(:,:,:,64))
  call loop_Q_A(G2(:,:,:,64),Q(:,22),ZERO,G3(:,:,:,81))
  call loop_QV_A(G3(:,:,:,81),wf(:,-3),G3(:,:,:,82))
  call loop_Q_A(G3(:,:,:,82),Q(:,30),ZERO,G4(:,:,:,45))
  call loop_QV_A(G4(:,:,:,45),wf(:,0),G4(:,:,:,46))
  call check_last_Q_A(l_switch,G4(:,:,:,46),Q(:,31),ZERO,G5tensor(:,23))
  call loop_QV_A(G1(:,:,:,29),wf(:,-3),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,12),ZERO,G2(:,:,:,65))
  call loop_QV_A(G2(:,:,:,65),wf(:,-1),G2(:,:,:,66))
  call loop_Q_A(G2(:,:,:,66),Q(:,14),ZERO,G3(:,:,:,83))
  call loop_QV_A(G3(:,:,:,83),wf(:,-4),G3(:,:,:,84))
  call loop_Q_A(G3(:,:,:,84),Q(:,30),ZERO,G4(:,:,:,47))
  call loop_QV_A(G4(:,:,:,47),wf(:,0),G4(:,:,:,48))
  call check_last_Q_A(l_switch,G4(:,:,:,48),Q(:,31),ZERO,G5tensor(:,24))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,1),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_3,masses2_1,G4tensor(:,7),T4sum(1:70,1))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,2),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_4,masses2_1,G4tensor(:,8),T4sum(1:70,2))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,13),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(3) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,14),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(3)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,13),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,13),T4sum(1:70,3))
  M(1) = M(1) + (CI*f(2) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,14),T4sum(1:70,3))
  M(2) = M(2) + (-(CI*f(2)) * den(1)) * TI2_call(4,momenta_9,masses2_1,G4tensor(:,14),T4sum(1:70,3))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,3),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_5,masses2_1,G4tensor(:,9),T4sum(1:70,4))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,4),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_2,masses2_1,G4tensor(:,10),T4sum(1:70,5))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,15),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,15),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(3)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,16),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(3) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,16),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,15),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,15),T4sum(1:70,6))
  M(1) = M(1) + (-(CI*f(2)) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,16),T4sum(1:70,6))
  M(2) = M(2) + (CI*f(2) * den(2)) * TI2_call(4,momenta_8,masses2_1,G4tensor(:,16),T4sum(1:70,6))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,5),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_6,masses2_1,G4tensor(:,11),T4sum(1:70,7))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,6),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_1,masses2_1,G4tensor(:,12),T4sum(1:70,8))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,17),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,17),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(3) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,18),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(3)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,18),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,17),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,17),T4sum(1:70,9))
  M(1) = M(1) + (CI*f(2) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,18),T4sum(1:70,9))
  M(2) = M(2) + (-(CI*f(2)) * den(3)) * TI2_call(4,momenta_7,masses2_1,G4tensor(:,18),T4sum(1:70,9))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,3),T5sum(1:126,1))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,9),T5sum(1:126,1))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,3),T5sum(1:126,1))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_13,masses2_2,G5tensor(:,9),T5sum(1:126,1))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,1),T5sum(1:126,2))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,7),T5sum(1:126,2))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,1),T5sum(1:126,2))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_15,masses2_2,G5tensor(:,7),T5sum(1:126,2))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,5),T5sum(1:126,3))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,11),T5sum(1:126,3))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,5),T5sum(1:126,3))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_11,masses2_2,G5tensor(:,11),T5sum(1:126,3))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,2),T5sum(1:126,4))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,8),T5sum(1:126,4))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,2),T5sum(1:126,4))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_14,masses2_2,G5tensor(:,8),T5sum(1:126,4))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,6),T5sum(1:126,5))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,12),T5sum(1:126,5))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,6),T5sum(1:126,5))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_10,masses2_2,G5tensor(:,12),T5sum(1:126,5))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,4),T5sum(1:126,6))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,10),T5sum(1:126,6))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,4),T5sum(1:126,6))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_12,masses2_2,G5tensor(:,10),T5sum(1:126,6))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,17),T5sum(1:126,7))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,21),T5sum(1:126,7))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,17),T5sum(1:126,7))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_17,masses2_2,G5tensor(:,21),T5sum(1:126,7))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,19),T5sum(1:126,8))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,23),T5sum(1:126,8))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,19),T5sum(1:126,8))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_19,masses2_2,G5tensor(:,23),T5sum(1:126,8))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,18),T5sum(1:126,9))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,22),T5sum(1:126,9))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,18),T5sum(1:126,9))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_16,masses2_2,G5tensor(:,22),T5sum(1:126,9))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,20),T5sum(1:126,10))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,24),T5sum(1:126,10))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,20),T5sum(1:126,10))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_18,masses2_2,G5tensor(:,24),T5sum(1:126,10))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,13),T5sum(1:126,11))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,15),T5sum(1:126,11))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,13),T5sum(1:126,11))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_20,masses2_2,G5tensor(:,15),T5sum(1:126,11))
  M(2) = M(2) + (-f(5)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,14),T5sum(1:126,12))
  M(1) = M(1) + (-f(5)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,16),T5sum(1:126,12))
  M(2) = M(2) + (-f(4)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,14),T5sum(1:126,12))
  M(1) = M(1) + (-f(4)) * TI2_call(5,momenta_21,masses2_2,G5tensor(:,16),T5sum(1:126,12))

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none
  deallocate(G4tensorhel)
  deallocate(G5tensorhel)

end subroutine gtdealloc
#endif

end module ol_vamp_1_ppvvj2_aaggg_2_/**/REALKIND
