
module ol_colourmatrix_ppvvj2_uuxzzg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,1), KL(0,1), KL2(17,1), KL2ct(17,1), KL2ct2(17,1)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  12]
  KL2( 2,:) = [  16]
  KL2( 3,:) = [   2]
  KL2( 4,:) = [  16]
  KL2( 5,:) = [   0]
  KL2( 6,:) = [   0]
  KL2( 7,:) = [   0]
  KL2( 8,:) = [   0]
  KL2( 9,:) = [   0]
  KL2(10,:) = [   0]
  KL2(11,:) = [   0]
  KL2(12,:) = [ -18]
  KL2(13,:) = [ -18]
  KL2(14,:) = [   0]
  KL2(15,:) = [   0]
  KL2(16,:) = [  36]
  KL2(17,:) = [   0]
  KL2 = (1._/**/REALKIND / 3) * KL2

  KL2ct( 1,:) = [  12]
  KL2ct( 2,:) = [  16]
  KL2ct( 3,:) = [   2]
  KL2ct( 4,:) = [  16]
  KL2ct( 5,:) = [   0]
  KL2ct( 6,:) = [   0]
  KL2ct( 7,:) = [   0]
  KL2ct( 8,:) = [   0]
  KL2ct( 9,:) = [   0]
  KL2ct(10,:) = [   0]
  KL2ct(11,:) = [   0]
  KL2ct(12,:) = [ -18]
  KL2ct(13,:) = [ -18]
  KL2ct(14,:) = [   0]
  KL2ct(15,:) = [   0]
  KL2ct(16,:) = [  36]
  KL2ct(17,:) = [   0]
  KL2ct = (1._/**/REALKIND / 3) * KL2ct

  KL2ct2( 1,:) = [  12]
  KL2ct2( 2,:) = [  16]
  KL2ct2( 3,:) = [   2]
  KL2ct2( 4,:) = [  16]
  KL2ct2( 5,:) = [   0]
  KL2ct2( 6,:) = [   0]
  KL2ct2( 7,:) = [   0]
  KL2ct2( 8,:) = [   0]
  KL2ct2( 9,:) = [   0]
  KL2ct2(10,:) = [   0]
  KL2ct2(11,:) = [   0]
  KL2ct2(12,:) = [ -18]
  KL2ct2(13,:) = [ -18]
  KL2ct2(14,:) = [   0]
  KL2ct2(15,:) = [   0]
  KL2ct2(16,:) = [  36]
  KL2ct2(17,:) = [   0]
  KL2ct2 = (1._/**/REALKIND / 3) * KL2ct2

  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvvj2_uuxzzg_1_/**/REALKIND



module ol_forced_parameters_ppvvj2_uuxzzg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvvj2_uuxzzg_1_/**/REALKIND

module ol_loop_ppvvj2_uuxzzg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(8), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-5+1:18)
  ! denominators
  complex(REALKIND), save :: den(13)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,72), Mct(1,72), Mcol_loop(1,72)
  ! zero helicity identifier
  logical,           save :: zerohel(72) = .true., zerohel_ct(72) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = countertermnorm*ctZGG*eQED**2*gQCD**3
    f(2) = CI*countertermnorm*ctZZGG*eQED**2*gQCD**3
    f(3) = eQED**2*gQCD**3*integralnorm*SwF
    f(4) = 2*eQED**2*gQCD**3*integralnorm*SwF
    f(5) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*lambdaHZZ*MB*MW*YB)/(cw**2*MQ2sum*sw)
    f(6) = (eQED**2*gQCD**3*integralnorm*lambdaHZZ*SwF*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(7) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**3*lambdaHZZ*MT*MW*YT)/(cw**2*MQ2sum*sw)
    f(8) = (eQED**2*gQCD**3*integralnorm*lambdaHZZ*SwF*YT)/(cw**2*sw**2*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,5)
  integer,           intent(in)  :: H(5)
  integer,           intent(in), optional  :: POLSEL(5)
  complex(REALKIND), intent(out) :: M1(0), M2(1)
  complex(REALKIND) :: A(7)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rMZ, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rMZ, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rMZ, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rMZ, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call counter_VVG_G(wf(:,-2),wf(:,-3),wf(:,-4),wf(:,2))
  call vert_VV_S(wf(:,-2),wf(:,-3),wf(:,3))
  call counter_GG_S(wf(:,1),wf(:,-4),wf(:,4))
  call vert_ZQ_A(gZu,wf(:,-2),wf(:,0),wf(:,5))
  call counter_VG_G(wf(:,-3),wf(:,-4),Q(:,16),wf(:,6),Q(:,24))
  call prop_Q_A(wf(:,5),Q(:,5),ZERO,0_intkind1,wf(:,7))
  call vert_QA_V(wf(:,7),wf(:,-1),wf(:,8))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,-2),wf(:,9))
  call prop_A_Q(wf(:,9),Q(:,6),ZERO,0_intkind1,wf(:,10))
  call vert_QA_V(wf(:,0),wf(:,10),wf(:,11))
  call vert_ZQ_A(gZu,wf(:,-3),wf(:,0),wf(:,12))
  call counter_VG_G(wf(:,-2),wf(:,-4),Q(:,16),wf(:,13),Q(:,20))
  call prop_Q_A(wf(:,12),Q(:,9),ZERO,0_intkind1,wf(:,14))
  call vert_QA_V(wf(:,14),wf(:,-1),wf(:,15))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,-3),wf(:,16))
  call prop_A_Q(wf(:,16),Q(:,10),ZERO,0_intkind1,wf(:,17))
  call vert_QA_V(wf(:,0),wf(:,17),wf(:,18))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3))
  den(2) = 1 / (Q(5,12) - MH2)
  den(4) = 1 / (Q(5,5))
  den(5) = 1 / (Q(5,24))
  den(7) = 1 / (Q(5,6))
  den(9) = 1 / (Q(5,9))
  den(10) = 1 / (Q(5,20))
  den(12) = 1 / (Q(5,10))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(5)*den(7)
  den(11) = den(9)*den(10)
  den(13) = den(10)*den(12)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(7)


  A(1) = cont_VV(wf(:,1),wf(:,2)) * den(1)
  A(2) = cont_SS(wf(:,3),wf(:,4)) * den(3)
  A(3) = cont_SS(wf(:,3),wf(:,4)) * den(3)
  A(4) = cont_VV(wf(:,6),wf(:,8)) * den(6)
  A(5) = cont_VV(wf(:,6),wf(:,11)) * den(8)
  A(6) = cont_VV(wf(:,13),wf(:,15)) * den(11)
  A(7) = cont_VV(wf(:,13),wf(:,18)) * den(13)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(7)
  complex(REALKIND), intent(out) :: M1(0), M2(1)


  M2(1) = (-A(4)-A(5)-A(6)-A(7))*f(1)+A(1)*f(2)-A(3)*f(5)-A(2)*f(7)

end subroutine colourvectors

end module ol_loop_ppvvj2_uuxzzg_1_/**/REALKIND
