
module ol_vamp_1_ppvv_ew_ddxaa_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvv_ew_ddxaa_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvv_ew_ddxaa_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvv_ew_ddxaa_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvv_ew_ddxaa_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvv_ew_ddxaa_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvv_ew_ddxaa_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(16)
  type(Hpolcont), intent(in) :: M(2,16)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMZ,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(2),n2h8(2))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,nMW,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(3),n2h8(3))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(4),h0tab(:,4),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,4),heltab2x16(:,:,4))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(4),n2h8(4))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,5),heltab2x16(:,:,5))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(5),m3h2x8(:,6),heltab2x16(:,:,6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(7),h0tab(:,7),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,7),heltab2x16(:,:,7))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(6),n2h8(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(8),h0tab(:,8),[8,1,2,4],[0,nMZ,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,8),heltab2x16(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(7),n2h8(6))
  Gcoeff(:)%j = (c(10)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(9),h0tab(:,9),[8,1,2,4],[0,nMW,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,9),heltab2x16(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(8),n2h8(7))
  Gcoeff(:)%j = (c(5)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(10),h0tab(:,10),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,10),heltab2x16(:,:,10))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(9),n2h8(8))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(11),h0tab(:,11),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,11),heltab2x16(:,:,11))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(12),h0tab(:,12),[8,1,2,4],[nMW,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(10),m3h2x8(:,12),heltab2x16(:,:,12))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(13),h0tab(:,13),[8,1,4,2],[nMW,0,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(11),m3h2x8(:,13),heltab2x16(:,:,13))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(14),h0tab(:,14),[8,1,4,2],[0,nMW,nMW,0],4,0)
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,14),heltab2x16(:,:,14))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(12),n2h8(9))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(4),[G1H8(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(9),[G1H8(6)])
  call Hloop_QA_V(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_QA_Z(ntryL,G1H8(2),ex2(:),G1H4(2),ngZd,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_QA_W(ntryL,G1H8(3),ex2(:),G1H4(3),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_WA_Q(ntryL,G0H8(1),ex2(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),10,0,G1H4(4),n2h4(1))
  call Hloop_WA_Q(ntryL,G1H8(5),ex2(:),G1H4(5),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_A_Q(ntryL,G1H4(5),10,0,G2H4(1),n2h4(2))
  call Hloop_AQ_V(ntryL,G1H8(9),ex1(:),G1H4(5),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_AQ_Z(ntryL,G1H8(7),ex1(:),G1H4(6),ngZd,m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_AQ_W(ntryL,G1H8(8),ex1(:),G1H4(7),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_WQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G0H4(1),9,0,G1H4(8),n2h4(3))
  call Hloop_WQ_A(ntryL,G1H8(10),ex1(:),G1H4(9),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_Q_A(ntryL,G1H4(9),9,0,G2H4(2),n2h4(4))
  call Hloop_WQ_A(ntryL,G1H8(11),ex1(:),G1H4(9),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G1H4(9),9,0,G2H4(3),n2h4(5))
  call Hloop_AQ_W(ntryL,G1H8(12),ex1(:),G1H4(9),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_VQ_A(ntryL,G1H4(1),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(1),n2h2(1))
  call Hloop_ZQ_A(ntryL,G1H4(2),ex1(:),G1H2(1),ngZd,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(2),n2h2(2))
  call Hloop_WQ_A(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),11,0,G2H2(3),n2h2(3))
  call Hloop_AQ_W(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_W(ntryL,G2H4(1),ex1(:),G2H2(4),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VA_Q(ntryL,G1H4(5),ex2(:),G1H2(2),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_A_Q(ntryL,G1H2(2),11,0,G2H2(5),n2h2(4))
  call Hloop_ZA_Q(ntryL,G1H4(6),ex2(:),G1H2(2),ngZd,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(2),11,0,G2H2(6),n2h2(5))
  call Hloop_WA_Q(ntryL,G1H4(7),ex2(:),G1H2(2),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_A_Q(ntryL,G1H2(2),11,0,G2H2(7),n2h2(6))
  call Hloop_QA_W(ntryL,G1H4(8),ex2(:),G1H2(2),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_W(ntryL,G2H4(2),ex2(:),G2H2(8),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hotf_4pt_reduction(G2H4(3),RedSet_4(1),mass4set(:,1),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),4)
  call HG1shiftOLR(G1H4(2),2,4)
  call Hloop_UV_W(ntryL,G1H4(9),9,ex3(:),4,G2H2(9),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QV_A(ntryL,G1H4(1),ex3(:),G1H2(3),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(3),13,0,G2H2(10),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_WA_Q(ntryL,G1H4(2),ex2(:),G1H2(3),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_QV_A(ntryL,G1H4(4),ex3(:),G1H2(4),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(4),13,0,G2H2(11),n2h2(8))
  call Hloop_QV_A(ntryL,G1H4(5),ex3(:),G1H2(4),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(4),13,0,G2H2(12),n2h2(9))
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(2),mass4set(:,2),  & 
G1H2(4),G1H2(5),G1H2(6),G1H2(7),G1H2(8),2)
  call HG1shiftOLR(G1H2(5),4,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(2),mass4set(:,3),  & 
G1H2(9),G1H2(10),G1H2(11),G1H2(12),G1H2(13),2)
  call HG1shiftOLR(G1H2(10),4,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(2),mass4set(:,4),  & 
G1H2(14),G1H2(15),G1H2(16),G1H2(17),G1H2(18),2)
  call HG1shiftOLR(G1H2(15),4,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(1),ex3(:),G1tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(2),mass4set(:,5),  & 
G1H2(1),G1H2(19),G1H2(20),G1H2(21),G1H2(22),2)
  call HG1shiftOLR(G1H2(19),4,2)
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(3),mass4set(:,2),  & 
G1H2(23),G1H2(24),G1H2(25),G1H2(26),G1H2(27),2)
  call HG1shiftOLR(G1H2(24),4,2)
  call Hotf_4pt_reduction(G2H2(6),RedSet_4(3),mass4set(:,3),  & 
G1H2(28),G1H2(29),G1H2(30),G1H2(31),G1H2(32),2)
  call HG1shiftOLR(G1H2(29),4,2)
  call Hotf_4pt_reduction(G2H2(7),RedSet_4(3),mass4set(:,4),  & 
G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),2)
  call HG1shiftOLR(G1H2(34),4,2)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(2),ex3(:),G1tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hotf_4pt_reduction(G2H2(8),RedSet_4(3),mass4set(:,5),  & 
G1H2(2),G1H2(38),G1H2(39),G1H2(40),G1H2(41),2)
  call HG1shiftOLR(G1H2(38),4,2)
  call Hotf_4pt_reduction(G2H2(9),RedSet_4(1),mass4set(:,6),  & 
G1H2(42),G1H2(43),G1H2(44),G1H2(45),G1H2(46),2)
  call HG1shiftOLR(G1H2(43),2,2)
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(2),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_QV_A(ntryL,G1H2(4),ex3(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(1))
  call Hloop_QV_A(ntryL,G1H2(5),ex3(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(4),n2h1(2))
  call Hloop_QV_A(ntryL,G1H2(8),ex3(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(3))
  call Hloop_QV_A(ntryL,G1H2(9),ex3(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(4))
  call Hloop_QV_A(ntryL,G1H2(10),ex3(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(7),n2h1(5))
  call Hloop_QV_A(ntryL,G1H2(13),ex3(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(8),n2h1(6))
  call Hloop_QV_A(ntryL,G1H2(14),ex3(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(7))
  call Hloop_QV_A(ntryL,G1H2(15),ex3(:),G1H1(1),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(8))
  call Hloop_QV_A(ntryL,G1H2(18),ex3(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(9))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(1),11,ex3(:),4,G2tensor(12),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(19),0,ex3(:),4,G2tensor(13),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(22),11,ex3(:),4,G2tensor(14),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hloop_AV_Q(ntryL,G1H2(23),ex3(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(11))
  call Hloop_AV_Q(ntryL,G1H2(24),ex3(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(16),n2h1(12))
  call Hloop_AV_Q(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(17),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(19),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H2(32),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(20),n2h1(16))
  call Hloop_AV_Q(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(17))
  call Hloop_AV_Q(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(22),n2h1(18))
  call Hloop_AV_Q(ntryL,G1H2(37),ex3(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(19))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(2),11,ex3(:),4,G2tensor(24),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(38),0,ex3(:),4,G2tensor(25),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(41),11,ex3(:),4,G2tensor(26),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hloop_WA_Q(ntryL,G1H2(42),ex2(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(27),n2h1(21))
  call Hloop_WA_Q(ntryL,G1H2(43),ex2(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,0,G2tensor(28),n2h1(22))
  call Hloop_WA_Q(ntryL,G1H2(46),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(29),n2h1(23))
  call ol_merge_tensors(G2tensor(12),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(2)])
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(2),mass4set(:,5),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(3),mass4set(:,5),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),2)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,2),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,3),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,4),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(3),mass4set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(3),mass4set(:,3),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(3),mass4set(:,4),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(1),mass4set(:,6),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(3),mass4set(:,5),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(1),mass4set(:,1),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,2),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,3),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,4),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,2),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(3),mass4set(:,3),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(3),mass4set(:,4),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,6),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  Gcoeff(:)%j = (-(c(12)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(15),h0tab(:,15),[12,1,2],[nMW,0,nMW],4,0)
  call Hloop_VWW_V(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(1),m4h2x2x4(:,1),heltab3x16(:,:,1))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(16),h0tab(:,16),[8,3,4],[nME,nME,nME],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,15),heltab2x16(:,:,15))
  call Hloop_A_Q(ntryL,G0H8(3),8,nME,G1H8(1),n2h8(10))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(17),h0tab(:,17),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,16),heltab2x16(:,:,16))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMM,G1H8(6),n2h8(11))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(18),h0tab(:,18),[8,3,4],[nML,nML,nML],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,17),heltab2x16(:,:,17))
  call Hloop_A_Q(ntryL,G0H8(2),8,nML,G1H8(4),n2h8(12))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(19),h0tab(:,19),[8,3,4],[nME,nME,nME],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,18),heltab2x16(:,:,18))
  call Hloop_Q_A(ntryL,G0H8(3),8,nME,G1H8(2),n2h8(13))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(20),h0tab(:,20),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,19),heltab2x16(:,:,19))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMM,G1H8(3),n2h8(14))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(21),h0tab(:,21),[8,3,4],[nML,nML,nML],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,20),heltab2x16(:,:,20))
  call Hloop_Q_A(ntryL,G0H8(2),8,nML,G1H8(5),n2h8(15))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(22),h0tab(:,22),[8,3,4],[0,0,0],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,21),heltab2x16(:,:,21))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(9),n2h8(16))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(23),h0tab(:,23),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,22),heltab2x16(:,:,22))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMT,G1H8(7),n2h8(17))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(24),h0tab(:,24),[8,3,4],[0,0,0],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,23),heltab2x16(:,:,23))
  call Hloop_Q_A(ntryL,G0H8(2),8,0,G1H8(8),n2h8(18))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(25),h0tab(:,25),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,24),heltab2x16(:,:,24))
  call Hloop_Q_A(ntryL,G0H8(3),8,nMT,G1H8(10),n2h8(19))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(26),h0tab(:,26),[8,3,4],[0,0,0],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,25),heltab2x16(:,:,25))
  call Hloop_A_Q(ntryL,G0H8(1),8,0,G1H8(11),n2h8(20))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(27),h0tab(:,27),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,21))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,26),heltab2x16(:,:,26))
  call Hloop_A_Q(ntryL,G0H8(2),8,nMB,G1H8(12),n2h8(21))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(28),h0tab(:,28),[8,3,4],[0,0,0],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,27),heltab2x16(:,:,27))
  call Hloop_Q_A(ntryL,G0H8(3),8,0,G1H8(13),n2h8(22))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(29),h0tab(:,29),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,21))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,28),heltab2x16(:,:,28))
  call Hloop_Q_A(ntryL,G0H8(1),8,nMB,G1H8(14),n2h8(23))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(30),h0tab(:,30),[8,3,4],[nME,nME,nME],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,29),heltab2x16(:,:,29))
  call Hloop_A_Q(ntryL,G0H8(2),8,nME,G1H8(15),n2h8(24))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(31),h0tab(:,31),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,30),heltab2x16(:,:,30))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMM,G1H8(16),n2h8(25))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(32),h0tab(:,32),[8,3,4],[nML,nML,nML],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,31),heltab2x16(:,:,31))
  call Hloop_A_Q(ntryL,G0H8(1),8,nML,G1H8(17),n2h8(26))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(33),h0tab(:,33),[8,3,4],[nME,nME,nME],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,32),heltab2x16(:,:,32))
  call Hloop_Q_A(ntryL,G0H8(2),8,nME,G1H8(18),n2h8(27))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(34),h0tab(:,34),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,33),heltab2x16(:,:,33))
  call Hloop_Q_A(ntryL,G0H8(3),8,nMM,G1H8(19),n2h8(28))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(35),h0tab(:,35),[8,3,4],[nML,nML,nML],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,34),heltab2x16(:,:,34))
  call Hloop_Q_A(ntryL,G0H8(1),8,nML,G1H8(20),n2h8(29))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(36),h0tab(:,36),[8,3,4],[0,0,0],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,35),heltab2x16(:,:,35))
  call Hloop_A_Q(ntryL,G0H8(2),8,0,G1H8(21),n2h8(30))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(37),h0tab(:,37),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,36),heltab2x16(:,:,36))
  call Hloop_A_Q(ntryL,G0H8(3),8,nMT,G1H8(22),n2h8(31))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(38),h0tab(:,38),[8,3,4],[0,0,0],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,37),heltab2x16(:,:,37))
  call Hloop_Q_A(ntryL,G0H8(1),8,0,G1H8(23),n2h8(32))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(39),h0tab(:,39),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,38),heltab2x16(:,:,38))
  call Hloop_Q_A(ntryL,G0H8(2),8,nMT,G1H8(24),n2h8(33))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(40),h0tab(:,40),[8,3,4],[0,0,0],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,39),heltab2x16(:,:,39))
  call Hloop_A_Q(ntryL,G0H8(3),8,0,G1H8(25),n2h8(34))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(41),h0tab(:,41),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,22))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,40),heltab2x16(:,:,40))
  call Hloop_A_Q(ntryL,G0H8(1),8,nMB,G1H8(26),n2h8(35))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(42),h0tab(:,42),[8,3,4],[0,0,0],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,41),heltab2x16(:,:,41))
  call Hloop_Q_A(ntryL,G0H8(2),8,0,G1H8(27),n2h8(36))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(43),h0tab(:,43),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,22))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,42),heltab2x16(:,:,42))
  call Hloop_Q_A(ntryL,G0H8(3),8,nMB,G1H8(28),n2h8(37))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(44),h0tab(:,44),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_T(ntryL,G0H16(1),0,ex4(:),8,G1H8(29),m3h2x8(:,43),heltab2x16(:,:,43))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(45),h0tab(:,45),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(30),m3h2x8(:,44),heltab2x16(:,:,44))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(46),h0tab(:,46),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_T(ntryL,G0H16(1),0,ex4(:),8,G1H8(31),m3h2x8(:,45),heltab2x16(:,:,45))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(47),h0tab(:,47),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(32),m3h2x8(:,46),heltab2x16(:,:,46))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(48),h0tab(:,48),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(33),m3h2x8(:,47),heltab2x16(:,:,47))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(49),h0tab(:,49),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(34),m3h2x8(:,48),heltab2x16(:,:,48))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(50),h0tab(:,50),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(35),m3h2x8(:,49),heltab2x16(:,:,49))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(51),h0tab(:,51),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(36),m3h2x8(:,50),heltab2x16(:,:,50))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(52),h0tab(:,52),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(37),m3h2x8(:,51),heltab2x16(:,:,51))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(53),h0tab(:,53),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(38),m3h2x8(:,52),heltab2x16(:,:,52))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(54),h0tab(:,54),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_DV_C(ntryL,G0H16(1),0,ex4(:),G1H8(39),m3h2x8(:,53),heltab2x16(:,:,53))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(55),h0tab(:,55),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_CV_D(ntryL,G0H16(1),0,ex4(:),8,G1H8(40),m3h2x8(:,54),heltab2x16(:,:,54))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(56),h0tab(:,56),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(41),m3h2x8(:,55),heltab2x16(:,:,55))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(57),h0tab(:,57),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(42),m3h2x8(:,56),heltab2x16(:,:,56))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(58),h0tab(:,58),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(43),m3h2x8(:,57),heltab2x16(:,:,57))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(59),h0tab(:,59),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(44),m3h2x8(:,58),heltab2x16(:,:,58))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(60),h0tab(:,60),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(1),m3h2x8(:,59),heltab2x16(:,:,59))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(61),h0tab(:,61),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(2),m3h2x8(:,60),heltab2x16(:,:,60))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(62),h0tab(:,62),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(3),m3h2x8(:,61),heltab2x16(:,:,61))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(63),h0tab(:,63),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(4),m3h2x8(:,62),heltab2x16(:,:,62))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(64),h0tab(:,64),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_T(ntryL,G0H16(1),0,ex4(:),8,G1H8(45),m3h2x8(:,63),heltab2x16(:,:,63))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(65),h0tab(:,65),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(46),m3h2x8(:,64),heltab2x16(:,:,64))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(66),h0tab(:,66),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_T(ntryL,G0H16(1),0,ex4(:),8,G1H8(47),m3h2x8(:,65),heltab2x16(:,:,65))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(67),h0tab(:,67),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(48),m3h2x8(:,66),heltab2x16(:,:,66))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(68),h0tab(:,68),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(5),m3h2x8(:,67),heltab2x16(:,:,67))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(69),h0tab(:,69),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(6),m3h2x8(:,68),heltab2x16(:,:,68))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(70),h0tab(:,70),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(7),m3h2x8(:,69),heltab2x16(:,:,69))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(71),h0tab(:,71),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(8),m3h2x8(:,70),heltab2x16(:,:,70))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(72),h0tab(:,72),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(9),m3h2x8(:,71),heltab2x16(:,:,71))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(73),h0tab(:,73),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(10),m3h2x8(:,72),heltab2x16(:,:,72))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(74),h0tab(:,74),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(11),m3h2x8(:,73),heltab2x16(:,:,73))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(75),h0tab(:,75),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_SV_V(ntryL,G0H16(1),ex4(:),G0H8(12),m3h2x8(:,74),heltab2x16(:,:,74))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(76),h0tab(:,76),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(49),m3h2x8(:,75),heltab2x16(:,:,75))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(77),h0tab(:,77),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(50),m3h2x8(:,76),heltab2x16(:,:,76))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(78),h0tab(:,78),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(51),m3h2x8(:,77),heltab2x16(:,:,77))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(79),h0tab(:,79),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(52),m3h2x8(:,78),heltab2x16(:,:,78))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(80),h0tab(:,80),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(13),m3h2x8(:,79),heltab2x16(:,:,79))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(81),h0tab(:,81),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,21))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(14),m3h2x8(:,80),heltab2x16(:,:,80))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(82),h0tab(:,82),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(15),m3h2x8(:,81),heltab2x16(:,:,81))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(83),h0tab(:,83),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,22))
  call Hloop_VV_S(ntryL,G0H16(1),ex4(:),G0H8(16),m3h2x8(:,82),heltab2x16(:,:,82))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(84),h0tab(:,84),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,83),heltab2x16(:,:,83))
  call Hloop_Q_A(ntryL,G0H8(17),8,0,G1H8(53),n2h8(38))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(85),h0tab(:,85),[8,2,5],[0,nMZ,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,84),heltab2x16(:,:,84))
  call Hloop_Q_A(ntryL,G0H8(17),8,0,G1H8(54),n2h8(39))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(86),h0tab(:,86),[8,2,5],[0,nMW,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,85),heltab2x16(:,:,85))
  call Hloop_Q_A(ntryL,G0H8(17),8,0,G1H8(55),n2h8(40))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(87),h0tab(:,87),[8,2,5],[0,0,0],3,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,86),heltab2x16(:,:,86))
  call Hloop_Q_A(ntryL,G0H8(17),8,0,G1H8(56),n2h8(41))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(88),h0tab(:,88),[8,2,5],[nMW,0,nMW],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(57),m3h2x8(:,87),heltab2x16(:,:,87))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(89),h0tab(:,89),[8,1,6],[0,0,0],3,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,88),heltab2x16(:,:,88))
  call Hloop_A_Q(ntryL,G0H8(17),8,0,G1H8(58),n2h8(42))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(90),h0tab(:,90),[8,1,6],[0,nMZ,0],3,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,89),heltab2x16(:,:,89))
  call Hloop_A_Q(ntryL,G0H8(17),8,0,G1H8(59),n2h8(43))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(91),h0tab(:,91),[8,1,6],[0,nMW,0],3,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,90),heltab2x16(:,:,90))
  call Hloop_A_Q(ntryL,G0H8(17),8,0,G1H8(60),n2h8(44))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(92),h0tab(:,92),[8,1,6],[0,0,0],3,1,wf4(:,12))
  call Hloop_AV_Q(ntryL,G0H16(1),ex4(:),G0H8(17),m3h2x8(:,91),heltab2x16(:,:,91))
  call Hloop_A_Q(ntryL,G0H8(17),8,0,G1H8(61),n2h8(45))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(93),h0tab(:,93),[8,1,6],[nMW,0,nMW],3,1,wf4(:,12))
  call Hloop_UW_V(ntryL,G0H16(1),0,ex4(:),8,G1H8(62),m3h2x8(:,92),heltab2x16(:,:,92))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(94),h0tab(:,94),[9,2,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,6),G0H4(2),m3h4x4(:,1),heltab2x16(:,:,93))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(95),h0tab(:,95),[9,2,4],[nMZ,0,0],3,1,wf4(:,6))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,6),G0H4(3),ngZd,m3h4x4(:,2),heltab2x16(:,:,94))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(96),h0tab(:,96),[9,2,4],[nMW,0,0],3,1,wf4(:,6))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,6),G0H4(4),m3h4x4(:,3),heltab2x16(:,:,95))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(97),h0tab(:,97),[9,2,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,6),G0H4(5),m3h4x4(:,4),heltab2x16(:,:,96))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(98),h0tab(:,98),[9,2,4],[0,nMW,nMW],3,1,wf4(:,6))
  call Hloop_WQ_A(ntryL,G0H16(1),wf4(:,6),G0H4(6),m3h4x4(:,5),heltab2x16(:,:,97))
  call Hloop_Q_A(ntryL,G0H4(6),9,0,G1H4(6),n2h4(7))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(99),h0tab(:,99),[10,1,4],[0,0,0],3,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,15),G0H4(6),m3h4x4(:,6),heltab2x16(:,:,98))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(100),h0tab(:,100),[10,1,4],[nMZ,0,0],3,1,wf4(:,15))
  call Hloop_QA_Z(ntryL,G0H16(1),wf4(:,15),G0H4(7),ngZd,m3h4x4(:,7),heltab2x16(:,:,99))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(101),h0tab(:,101),[10,1,4],[nMW,0,0],3,1,wf4(:,15))
  call Hloop_QA_W(ntryL,G0H16(1),wf4(:,15),G0H4(8),m3h4x4(:,8),heltab2x16(:,:,100))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(102),h0tab(:,102),[10,1,4],[0,0,0],3,1,wf4(:,15))
  call Hloop_QA_V(ntryL,G0H16(1),wf4(:,15),G0H4(9),m3h4x4(:,9),heltab2x16(:,:,101))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(103),h0tab(:,103),[10,1,4],[0,nMW,nMW],3,1,wf4(:,15))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(10),m3h4x4(:,10),heltab2x16(:,:,102))
  call Hloop_A_Q(ntryL,G0H4(10),10,0,G1H4(7),n2h4(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(11),[G1H8(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(13),[G1H8(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(35),[G1H8(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(36),[G1H8(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(39),[G1H8(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(40),[G1H8(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(46),[G1H8(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(48),[G1H8(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(50),[G1H8(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(52),[G1H8(51)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(56),[G1H8(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H8(61),[G1H8(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(5),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(6)])
  call Hloop_QV_A(ntryL,G1H4(3),ex3(:),G1H2(4),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(4),13,0,G2H2(1),n2h2(10))
  call Hloop_WQ_A(ntryL,G0H4(1),ex1(:),G0H2(1),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G0H2(1),13,0,G1H2(5),n2h2(11))
  call Hloop_AV_Q(ntryL,G1H8(1),wf4(:,21),G1H2(8),m3h4x2(:,1),heltab2x8(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(8),11,nME,G2H2(2),n2h2(12))
  call Hloop_AV_Q(ntryL,G1H8(6),wf4(:,21),G1H2(9),m3h4x2(:,2),heltab2x8(:,:,14))
  call Hloop_A_Q(ntryL,G1H2(9),11,nMM,G2H2(3),n2h2(13))
  call Hloop_AV_Q(ntryL,G1H8(4),wf4(:,21),G1H2(10),m3h4x2(:,3),heltab2x8(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(10),11,nML,G2H2(4),n2h2(14))
  call Hloop_QV_A(ntryL,G1H8(2),wf4(:,21),G1H2(13),m3h4x2(:,4),heltab2x8(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(13),11,nME,G2H2(5),n2h2(15))
  call Hloop_QV_A(ntryL,G1H8(3),wf4(:,21),G1H2(14),m3h4x2(:,5),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(14),11,nMM,G2H2(6),n2h2(16))
  call Hloop_QV_A(ntryL,G1H8(5),wf4(:,21),G1H2(15),m3h4x2(:,6),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(15),11,nML,G2H2(7),n2h2(17))
  call Hloop_AV_Q(ntryL,G1H8(11),wf4(:,21),G1H2(18),m3h4x2(:,7),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(18),11,0,G2H2(8),n2h2(18))
  call Hloop_AV_Q(ntryL,G1H8(7),wf4(:,21),G1H2(1),m3h4x2(:,8),heltab2x8(:,:,20))
  call Hloop_A_Q(ntryL,G1H2(1),11,nMT,G2H2(9),n2h2(19))
  call Hloop_QV_A(ntryL,G1H8(13),wf4(:,21),G1H2(19),m3h4x2(:,9),heltab2x8(:,:,21))
  call Hloop_Q_A(ntryL,G1H2(19),11,0,G2H2(10),n2h2(20))
  call Hloop_QV_A(ntryL,G1H8(10),wf4(:,21),G1H2(22),m3h4x2(:,10),heltab2x8(:,:,22))
  call Hloop_Q_A(ntryL,G1H2(22),11,nMT,G2H2(12),n2h2(21))
  call Hloop_AV_Q(ntryL,G1H8(12),wf4(:,21),G1H2(23),m3h4x2(:,11),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(23),11,nMB,G2H2(13),n2h2(22))
  call Hloop_QV_A(ntryL,G1H8(14),wf4(:,21),G1H2(24),m3h4x2(:,12),heltab2x8(:,:,24))
  call Hloop_Q_A(ntryL,G1H2(24),11,nMB,G2H2(14),n2h2(23))
  call Hloop_AZ_Q(ntryL,G1H8(15),wf4(:,22),G1H2(27),ngZl,m3h4x2(:,13),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(27),11,nME,G2H2(15),n2h2(24))
  call Hloop_AZ_Q(ntryL,G1H8(16),wf4(:,22),G1H2(28),ngZl,m3h4x2(:,14),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(28),11,nMM,G2H2(16),n2h2(25))
  call Hloop_AZ_Q(ntryL,G1H8(17),wf4(:,22),G1H2(29),ngZl,m3h4x2(:,15),heltab2x8(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(29),11,nML,G2H2(17),n2h2(26))
  call Hloop_QZ_A(ntryL,G1H8(18),wf4(:,22),G1H2(32),ngZl,m3h4x2(:,16),heltab2x8(:,:,28))
  call Hloop_Q_A(ntryL,G1H2(32),11,nME,G2H2(18),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H8(19),wf4(:,22),G1H2(33),ngZl,m3h4x2(:,17),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H2(33),11,nMM,G2H2(19),n2h2(28))
  call Hloop_QZ_A(ntryL,G1H8(20),wf4(:,22),G1H2(34),ngZl,m3h4x2(:,18),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H2(34),11,nML,G2H2(20),n2h2(29))
  call Hloop_AZ_Q(ntryL,G1H8(21),wf4(:,22),G1H2(37),ngZu,m3h4x2(:,19),heltab2x8(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(37),11,0,G2H2(21),n2h2(30))
  call Hloop_AZ_Q(ntryL,G1H8(22),wf4(:,22),G1H2(2),ngZu,m3h4x2(:,20),heltab2x8(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(2),11,nMT,G2H2(22),n2h2(31))
  call Hloop_QZ_A(ntryL,G1H8(23),wf4(:,22),G1H2(38),ngZu,m3h4x2(:,21),heltab2x8(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(38),11,0,G2H2(23),n2h2(32))
  call Hloop_QZ_A(ntryL,G1H8(24),wf4(:,22),G1H2(41),ngZu,m3h4x2(:,22),heltab2x8(:,:,34))
  call Hloop_Q_A(ntryL,G1H2(41),11,nMT,G2H2(24),n2h2(33))
  call Hloop_AZ_Q(ntryL,G1H8(25),wf4(:,22),G1H2(42),ngZd,m3h4x2(:,23),heltab2x8(:,:,35))
  call Hloop_A_Q(ntryL,G1H2(42),11,0,G2H2(25),n2h2(34))
  call Hloop_AZ_Q(ntryL,G1H8(26),wf4(:,22),G1H2(43),ngZd,m3h4x2(:,24),heltab2x8(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(43),11,nMB,G2H2(26),n2h2(35))
  call Hloop_QZ_A(ntryL,G1H8(27),wf4(:,22),G1H2(46),ngZd,m3h4x2(:,25),heltab2x8(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(46),11,0,G2H2(27),n2h2(36))
  call Hloop_QZ_A(ntryL,G1H8(28),wf4(:,22),G1H2(4),ngZd,m3h4x2(:,26),heltab2x8(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(4),11,nMB,G2H2(28),n2h2(37))
  call Hloop_SV_T(ntryL,G1H8(29),8,wf4(:,21),3,G2H2(29),m3h4x2(:,27),heltab2x8(:,:,39))
  call Hloop_TV_S(ntryL,G1H8(30),8,wf4(:,21),3,G2H2(30),m3h4x2(:,28),heltab2x8(:,:,40))
  call Hloop_SV_T(ntryL,G1H8(31),8,wf4(:,22),3,G2H2(31),m3h4x2(:,29),heltab2x8(:,:,41))
  call Hloop_TV_S(ntryL,G1H8(32),8,wf4(:,22),3,G2H2(32),m3h4x2(:,30),heltab2x8(:,:,42))
  call Hloop_DV_C(ntryL,G1H8(35),8,wf4(:,21),G2H2(33),m3h4x2(:,31),heltab2x8(:,:,43))
  call Hloop_CV_D(ntryL,G1H8(36),8,wf4(:,21),3,G2H2(34),m3h4x2(:,32),heltab2x8(:,:,44))
  call Hloop_DV_C(ntryL,G1H8(39),8,wf4(:,22),G2H2(35),m3h4x2(:,33),heltab2x8(:,:,45))
  call Hloop_CV_D(ntryL,G1H8(40),8,wf4(:,22),3,G2H2(36),m3h4x2(:,34),heltab2x8(:,:,46))
  call Hloop_UW_V(ntryL,G1H8(41),8,wf4(:,21),3,G2H2(37),m3h4x2(:,35),heltab2x8(:,:,47))
  call Hloop_UV_W(ntryL,G1H8(42),8,wf4(:,21),3,G2H2(38),m3h4x2(:,36),heltab2x8(:,:,48))
  call Hloop_UW_V(ntryL,G1H8(43),8,wf4(:,22),3,G2H2(39),m3h4x2(:,37),heltab2x8(:,:,49))
  call Hloop_UV_W(ntryL,G1H8(44),8,wf4(:,22),3,G2H2(40),m3h4x2(:,38),heltab2x8(:,:,50))
  call Hloop_VV_S(ntryL,G0H8(1),wf4(:,21),G0H2(1),m3h4x2(:,39),heltab2x8(:,:,51))
  call Hloop_VV_S(ntryL,G0H8(2),wf4(:,21),G0H2(2),m3h4x2(:,40),heltab2x8(:,:,52))
  call Hloop_VV_S(ntryL,G0H8(3),wf4(:,22),G0H2(3),m3h4x2(:,41),heltab2x8(:,:,53))
  call Hloop_VV_S(ntryL,G0H8(4),wf4(:,22),G0H2(4),m3h4x2(:,42),heltab2x8(:,:,54))
  call Hloop_SV_V(ntryL,G1H8(46),wf4(:,21),G1H2(8),m3h4x2(:,43),heltab2x8(:,:,55))
  call Hloop_SV_V(ntryL,G1H8(48),wf4(:,22),G1H2(9),m3h4x2(:,44),heltab2x8(:,:,56))
  call Hloop_SV_T(ntryL,G0H8(5),8,wf4(:,21),3,G1H2(10),m3h4x2(:,45),heltab2x8(:,:,57))
  call Hloop_TV_S(ntryL,G0H8(6),8,wf4(:,21),3,G1H2(13),m3h4x2(:,46),heltab2x8(:,:,58))
  call Hloop_SV_T(ntryL,G0H8(7),8,wf4(:,22),3,G1H2(14),m3h4x2(:,47),heltab2x8(:,:,59))
  call Hloop_TV_S(ntryL,G0H8(8),8,wf4(:,22),3,G1H2(15),m3h4x2(:,48),heltab2x8(:,:,60))
  call Hloop_UW_V(ntryL,G0H8(9),8,wf4(:,21),3,G1H2(18),m3h4x2(:,49),heltab2x8(:,:,61))
  call Hloop_UV_W(ntryL,G0H8(10),8,wf4(:,21),3,G1H2(1),m3h4x2(:,50),heltab2x8(:,:,62))
  call Hloop_UW_V(ntryL,G0H8(11),8,wf4(:,22),3,G1H2(19),m3h4x2(:,51),heltab2x8(:,:,63))
  call Hloop_UV_W(ntryL,G0H8(12),8,wf4(:,22),3,G1H2(22),m3h4x2(:,52),heltab2x8(:,:,64))
  call Hloop_VV_S(ntryL,G1H8(50),wf4(:,21),G1H2(23),m3h4x2(:,53),heltab2x8(:,:,65))
  call Hloop_VV_S(ntryL,G1H8(52),wf4(:,22),G1H2(24),m3h4x2(:,54),heltab2x8(:,:,66))
  call Hloop_SV_V(ntryL,G0H8(13),wf4(:,21),G0H2(5),m3h4x2(:,55),heltab2x8(:,:,67))
  call Hloop_SV_V(ntryL,G0H8(14),wf4(:,21),G0H2(6),m3h4x2(:,56),heltab2x8(:,:,68))
  call Hloop_SV_V(ntryL,G0H8(15),wf4(:,22),G0H2(7),m3h4x2(:,57),heltab2x8(:,:,69))
  call Hloop_SV_V(ntryL,G0H8(16),wf4(:,22),G0H2(8),m3h4x2(:,58),heltab2x8(:,:,70))
  call Hloop_QA_V(ntryL,G1H8(56),ex2(:),G1H4(8),m3h2x4(:,13),heltab2x8(:,:,71))
  call Hloop_QA_Z(ntryL,G1H8(54),ex2(:),G1H4(9),ngZd,m3h2x4(:,14),heltab2x8(:,:,72))
  call Hloop_QA_W(ntryL,G1H8(55),ex2(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,73))
  call Hloop_WA_Q(ntryL,G1H8(57),ex2(:),G1H4(2),m3h2x4(:,16),heltab2x8(:,:,74))
  call Hloop_A_Q(ntryL,G1H4(2),10,0,G2H4(1),n2h4(9))
  call Hloop_AQ_V(ntryL,G1H8(61),ex1(:),G1H4(4),m3h2x4(:,17),heltab2x8(:,:,75))
  call Hloop_AQ_Z(ntryL,G1H8(59),ex1(:),G1H4(5),ngZd,m3h2x4(:,18),heltab2x8(:,:,76))
  call Hloop_AQ_W(ntryL,G1H8(60),ex1(:),G1H4(3),m3h2x4(:,19),heltab2x8(:,:,77))
  call Hloop_WQ_A(ntryL,G1H8(62),ex1(:),G1H4(2),m3h2x4(:,20),heltab2x8(:,:,78))
  call Hloop_Q_A(ntryL,G1H4(2),9,0,G2H4(2),n2h4(10))
  call Hloop_VA_Q(ntryL,G0H4(5),ex2(:),G0H2(9),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_A_Q(ntryL,G0H2(9),11,0,G1H2(27),n2h2(38))
  call Hloop_ZA_Q(ntryL,G0H4(3),ex2(:),G0H2(9),ngZd,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_A_Q(ntryL,G0H2(9),11,0,G1H2(28),n2h2(39))
  call Hloop_WA_Q(ntryL,G0H4(4),ex2(:),G0H2(9),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_A_Q(ntryL,G0H2(9),11,0,G1H2(29),n2h2(40))
  call Hloop_QA_W(ntryL,G1H4(6),ex2(:),G1H2(32),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_VQ_A(ntryL,G0H4(9),ex1(:),G0H2(9),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G0H2(9),11,0,G1H2(33),n2h2(41))
  call Hloop_ZQ_A(ntryL,G0H4(7),ex1(:),G0H2(9),ngZd,m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_Q_A(ntryL,G0H2(9),11,0,G1H2(34),n2h2(42))
  call Hloop_WQ_A(ntryL,G0H4(8),ex1(:),G0H2(9),m3h2x2(:,24),heltab2x4(:,:,24))
  call Hloop_Q_A(ntryL,G0H2(9),11,0,G1H2(37),n2h2(43))
  call Hloop_AQ_W(ntryL,G1H4(7),ex1(:),G1H2(2),m3h2x2(:,25),heltab2x4(:,:,25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(37),[G1H2(16)])
call HGT_w2_OLR(G1H2(3),1,1,2)
call HGT_w2_invQ_OLR(G1H2(3),2,5,2)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(3),[G1H2(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(33),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(27),[G2H2(23),G2H2(10),G1H2(17),G1H2(12),G1H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(34),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(40),[G2H2(38),G1H2(21),G0H2(8),G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(27),[G1H2(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(25),[G2H2(21),G2H2(8),G1H2(36),G1H2(31),G1H2(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(28),[G1H2(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(29),[G1H2(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(32),[G1H2(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(39),[G2H2(37),G1H2(40),G0H2(7),G0H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(15),[G2H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G2H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(17),[G2H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(18),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(19),[G2H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(20),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(22),[G2H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(24),[G2H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(26),[G2H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(28),[G2H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(31),[G2H2(29),G0H2(3),G0H2(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(32),[G2H2(30),G0H2(4),G0H2(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(35),[G2H2(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(36),[G2H2(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(22),[G1H2(19),G1H2(1),G1H2(18),G1H2(9),G1H2(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(24),[G1H2(23),G1H2(15),G1H2(14),G1H2(13),G1H2(10)])
  call Hloop_QV_A(ntryL,G1H2(3),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(24))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(24),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hloop_QV_A(ntryL,G1H2(33),ex3(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(25))
  call Hloop_QV_A(ntryL,G2H2(27),ex3(:),G2H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(1),n2h1(26))
  call Hloop_QV_A(ntryL,G1H2(34),ex3(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(27))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H2(2),11,ex3(:),4,G2tensor(6),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H2(40),11,ex3(:),4,G3tensor(2),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hloop_AV_Q(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(28))
  call Hloop_AV_Q(ntryL,G2H2(25),ex3(:),G2H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(3),n2h1(29))
  call Hloop_AV_Q(ntryL,G1H2(28),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(30))
  call Hloop_AV_Q(ntryL,G1H2(29),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(31))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H2(32),11,ex3(:),4,G2tensor(21),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H2(39),11,ex3(:),4,G3tensor(4),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hloop_WA_Q(ntryL,G1H2(44),ex2(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(27),n2h1(32))
  call Hloop_WA_Q(ntryL,G1H2(45),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(30),n2h1(33))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(31),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H2(5),ex2(:),G1tensor(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hloop_AV_Q(ntryL,G2H2(15),ex3(:),G2H1(1),m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nME,G3tensor(5),n2h1(34))
  call Hloop_AV_Q(ntryL,G2H2(16),ex3(:),G2H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(6),n2h1(35))
  call Hloop_AV_Q(ntryL,G2H2(17),ex3(:),G2H1(1),m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nML,G3tensor(7),n2h1(36))
  call Hloop_QV_A(ntryL,G2H2(18),ex3(:),G2H1(1),m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nME,G3tensor(8),n2h1(37))
  call Hloop_QV_A(ntryL,G2H2(19),ex3(:),G2H1(1),m3h2x1(:,53),heltab2x2(:,:,53))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(9),n2h1(38))
  call Hloop_QV_A(ntryL,G2H2(20),ex3(:),G2H1(1),m3h2x1(:,54),heltab2x2(:,:,54))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nML,G3tensor(10),n2h1(39))
  call Hloop_AV_Q(ntryL,G2H2(22),ex3(:),G2H1(1),m3h2x1(:,55),heltab2x2(:,:,55))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(11),n2h1(40))
  call Hloop_QV_A(ntryL,G2H2(24),ex3(:),G2H1(1),m3h2x1(:,56),heltab2x2(:,:,56))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(12),n2h1(41))
  call Hloop_AV_Q(ntryL,G2H2(26),ex3(:),G2H1(1),m3h2x1(:,57),heltab2x2(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(13),n2h1(42))
  call Hloop_QV_A(ntryL,G2H2(28),ex3(:),G2H1(1),m3h2x1(:,58),heltab2x2(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(14),n2h1(43))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H2(31),11,ex3(:),4,G3tensor(15),m3h2x1(:,59),heltab2x2(:,:,59))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H2(32),11,ex3(:),4,G3tensor(16),m3h2x1(:,60),heltab2x2(:,:,60))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H2(35),11,ex3(:),G3tensor(17),m3h2x1(:,61),heltab2x2(:,:,61))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H2(36),11,ex3(:),4,G3tensor(18),m3h2x1(:,62),heltab2x2(:,:,62))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H2(22),ex3(:),G1tensor(6),m3h2x1(:,63),heltab2x2(:,:,63))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H2(24),ex3(:),G1tensor(11),m3h2x1(:,64),heltab2x2(:,:,64))
  call Hloop_VQ_A(ntryL,G1H4(8),wf4(:,3),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,26))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(32),n2h1(44))
  call Hloop_ZQ_A(ntryL,G1H4(9),wf4(:,3),G1H1(1),ngZd,m3h4x1(:,2),heltab2x4(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(33),n2h1(45))
  call Hloop_WQ_A(ntryL,G1H4(1),wf4(:,3),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(34),n2h1(46))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H4(1),wf4(:,3),G2tensor(35),m3h4x1(:,4),heltab2x4(:,:,29))
  call Hloop_VA_Q(ntryL,G1H4(4),wf4(:,12),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(36),n2h1(47))
  call Hloop_ZA_Q(ntryL,G1H4(5),wf4(:,12),G1H1(1),ngZd,m3h4x1(:,6),heltab2x4(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(37),n2h1(48))
  call Hloop_WA_Q(ntryL,G1H4(3),wf4(:,12),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(38),n2h1(49))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H4(2),wf4(:,12),G2tensor(39),m3h4x1(:,8),heltab2x4(:,:,33))
  call ol_merge_tensors(G2tensor(39),[G2tensor(26),G2tensor(2),G1tensor(15),G1tensor(10),G0tensor(15),G0tensor(10)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(5),G1tensor(20),G0tensor(20)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(33),[G2tensor(8),G1tensor(25),G0tensor(25)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(11),G1tensor(30),G0tensor(30)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(14),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(32),G0tensor(32)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(17),G1tensor(35),G0tensor(35)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(37),G0tensor(37)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(20),G1tensor(40),G0tensor(40)])
  call ol_merge_tensors(G2tensor(22),[G1tensor(42),G0tensor(42)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(29),G2tensor(23),G1tensor(50),G1tensor(45),G0tensor(50),G0tensor(45)])
  call ol_merge_tensors(G2tensor(25),[G1tensor(1),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(6),[G2tensor(28),G1tensor(47),G1tensor(3),G0tensor(47),G0tensor(3)])
  call ol_merge_tensors(G3tensor(18),[G3tensor(17),G3tensor(16),G3tensor(15),G3tensor(4),G3tensor(2),G1tensor(11),G1tensor(6) &
    ,G1tensor(9),G1tensor(4),G0tensor(9),G0tensor(4)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(8),G0tensor(8)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(28),G1tensor(12),G0tensor(28),G0tensor(12)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(14),G0tensor(14)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(18),G0tensor(18)])
  call ol_merge_tensors(G3tensor(3),[G3tensor(1),G1tensor(44),G1tensor(39),G1tensor(34),G1tensor(29),G1tensor(24),G1tensor(19) &
    ,G0tensor(44),G0tensor(39),G0tensor(34),G0tensor(29),G0tensor(24),G0tensor(19)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(23),G0tensor(23)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(43),G0tensor(43)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G3tensor(8),[G3tensor(5)])
  call ol_merge_tensors(G3tensor(9),[G3tensor(6)])
  call ol_merge_tensors(G3tensor(10),[G3tensor(7)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(13)])
  call TI_triangle_red(G2tensor(39),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(4),RedBasis(8),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(4),mass3set(:,2),G0tensor(46),G0tensor(15),G0tensor(10),G0tensor(17),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(8),mass3set(:,3),G0tensor(20),G0tensor(22),G0tensor(25),G0tensor(27),M2L1R1,[nMZ], &
    G0tensor(30))
  call TI_triangle_red(G2tensor(33),RedBasis(4),mass3set(:,3),G0tensor(2),G0tensor(5),G0tensor(32),G0tensor(35),M2L1R1,[nMZ], &
    G0tensor(37))
  call TI_triangle_red(G2tensor(10),RedBasis(8),mass3set(:,4),G0tensor(40),G0tensor(42),G0tensor(50),G0tensor(45),M2L1R1,[nMW], &
    G0tensor(7))
  call TI_triangle_red(G2tensor(34),RedBasis(4),mass3set(:,4),G0tensor(47),G0tensor(3),G0tensor(9),G0tensor(4),M2L1R1,[nMW], &
    G0tensor(8))
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,1),G0tensor(28),G0tensor(12),G0tensor(13),G0tensor(14),M2L1R1,[nMW], &
    G0tensor(18))
  call TI_triangle_red(G2tensor(35),RedBasis(4),mass3set(:,1),G0tensor(44),G0tensor(39),G0tensor(34),G0tensor(29),M2L1R1,[nMW], &
    G0tensor(24))
  call TI_triangle_red(G2tensor(16),RedBasis(9),mass3set(:,2),G0tensor(19),G0tensor(23),G0tensor(33),G0tensor(38),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(1),mass3set(:,2),G0tensor(43),G0tensor(48),G0tensor(49),G0tensor(51),M2L1R1)
  call TI_triangle_red(G2tensor(19),RedBasis(9),mass3set(:,3),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55),M2L1R1,[nMZ], &
    G0tensor(56))
  call TI_triangle_red(G2tensor(37),RedBasis(1),mass3set(:,3),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1,[nMZ], &
    G0tensor(61))
  call TI_triangle_red(G2tensor(22),RedBasis(9),mass3set(:,4),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65),M2L1R1,[nMW], &
    G0tensor(66))
  call TI_triangle_red(G2tensor(38),RedBasis(1),mass3set(:,4),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70),M2L1R1,[nMW], &
    G0tensor(71))
  call TI_triangle_red(G2tensor(25),RedBasis(9),mass3set(:,1),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),M2L1R1,[nMW], &
    G0tensor(76))
  call TI_triangle_red(G2tensor(6),RedBasis(6),mass3set(:,5),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80),M2L1R1,[nMW], &
    G0tensor(81))
  call TI_triangle_red(G3tensor(18),RedBasis(5),mass3set(:,6),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85),M2L1R1,[nMW], &
    G0tensor(86))
  call TI_triangle_red(G2tensor(21),RedBasis(7),mass3set(:,5),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90),M2L1R1,[nMW], &
    G0tensor(91))
  call TI_triangle_red(G2tensor(12),RedBasis(6),mass3set(:,7),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95),M2L1R1,[nMW], &
    G0tensor(96))
  call TI_triangle_red(G2tensor(31),RedBasis(3),mass3set(:,8),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMW], &
    G0tensor(101))
  call TI_triangle_red(G2tensor(24),RedBasis(2),mass3set(:,1),G0tensor(102),G0tensor(103),G0tensor(104), &
    G0tensor(105),M2L1R1,[nMW],G0tensor(106))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,2),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110),M2L1R1)
  call TI_triangle_red(G3tensor(3),RedBasis(5),mass3set(:,2),G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),M2L1R1)
  call TI_triangle_red(G2tensor(3),RedBasis(6),mass3set(:,9),G0tensor(115),G0tensor(116),G0tensor(117),G0tensor(118),M2L1R1,[nMZ], &
    G0tensor(119))
  call TI_triangle_red(G2tensor(9),RedBasis(7),mass3set(:,2),G0tensor(120),G0tensor(121),G0tensor(122),G0tensor(123),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(7),mass3set(:,9),G0tensor(124),G0tensor(125),G0tensor(126), &
    G0tensor(127),M2L1R1,[nMZ],G0tensor(128))
  call TI_triangle_red(G2tensor(18),RedBasis(7),mass3set(:,7),G0tensor(129),G0tensor(130),G0tensor(131), &
    G0tensor(132),M2L1R1,[nMW],G0tensor(133))
  call TI_triangle_red(G2tensor(27),RedBasis(3),mass3set(:,10),G0tensor(134),G0tensor(135),G0tensor(136), &
    G0tensor(137),M2L1R1,[nMW],G0tensor(138))
  call TI_triangle_red(G2tensor(30),RedBasis(2),mass3set(:,4),G0tensor(139),G0tensor(140),G0tensor(141), &
    G0tensor(142),M2L1R1,[nMW],G0tensor(143))
  call TI_triangle_red(G3tensor(8),RedBasis(5),mass3set(:,11),G0tensor(144),G0tensor(145),G0tensor(146), &
    G0tensor(147),M2L1R1,[nME],G0tensor(148))
  call TI_triangle_red(G3tensor(9),RedBasis(5),mass3set(:,12),G0tensor(149),G0tensor(150),G0tensor(151), &
    G0tensor(152),M2L1R1,[nMM],G0tensor(153))
  call TI_triangle_red(G3tensor(10),RedBasis(5),mass3set(:,13),G0tensor(154),G0tensor(155),G0tensor(156), &
    G0tensor(157),M2L1R1,[nML],G0tensor(158))
  call TI_triangle_red(G3tensor(12),RedBasis(5),mass3set(:,14),G0tensor(159),G0tensor(160),G0tensor(161), &
    G0tensor(162),M2L1R1,[nMT],G0tensor(163))
  call TI_triangle_red(G3tensor(14),RedBasis(5),mass3set(:,15),G0tensor(164),G0tensor(165),G0tensor(166), &
    G0tensor(167),M2L1R1,[nMB],G0tensor(168))
  call ol_merge_tensors(T0sum(11),[G0tensor(1)])
  call ol_merge_tensors(T0sum(12),[G0tensor(26)])
  call ol_merge_tensors(T0sum(13),[G0tensor(46)])
  call ol_merge_tensors(T0sum(14),[G0tensor(20)])
  call ol_merge_tensors(T0sum(15),[G0tensor(2)])
  call ol_merge_tensors(T0sum(16),[G0tensor(40)])
  call ol_merge_tensors(T0sum(17),[G0tensor(47)])
  call ol_merge_tensors(T0sum(18),[G0tensor(28)])
  call ol_merge_tensors(T0sum(19),[G0tensor(44)])
  call ol_merge_tensors(T0sum(20),[G0tensor(19)])
  call ol_merge_tensors(T0sum(21),[G0tensor(43)])
  call ol_merge_tensors(T0sum(22),[G0tensor(52)])
  call ol_merge_tensors(T0sum(23),[G0tensor(57)])
  call ol_merge_tensors(T0sum(24),[G0tensor(62)])
  call ol_merge_tensors(T0sum(25),[G0tensor(67)])
  call ol_merge_tensors(T0sum(26),[G0tensor(72)])
  call ol_merge_tensors(T0sum(27),[G0tensor(77)])
  call ol_merge_tensors(T0sum(28),[G0tensor(82)])
  call ol_merge_tensors(T0sum(29),[G0tensor(87)])
  call ol_merge_tensors(T0sum(30),[G0tensor(92)])
  call ol_merge_tensors(T0sum(31),[G0tensor(97)])
  call ol_merge_tensors(T0sum(32),[G0tensor(102)])
  call ol_merge_tensors(T0sum(33),[G0tensor(107)])
  call ol_merge_tensors(T0sum(34),[G0tensor(111)])
  call ol_merge_tensors(T0sum(35),[G0tensor(115)])
  call ol_merge_tensors(T0sum(36),[G0tensor(120)])
  call ol_merge_tensors(T0sum(37),[G0tensor(124)])
  call ol_merge_tensors(T0sum(38),[G0tensor(129)])
  call ol_merge_tensors(T0sum(39),[G0tensor(134)])
  call ol_merge_tensors(T0sum(40),[G0tensor(139)])
  call ol_merge_tensors(T0sum(41),[G0tensor(144)])
  call ol_merge_tensors(T0sum(42),[G0tensor(149)])
  call ol_merge_tensors(T0sum(43),[G0tensor(154)])
  call ol_merge_tensors(T0sum(44),[G0tensor(159)])
  call ol_merge_tensors(T0sum(45),[G0tensor(164)])
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(104),h0tab(:,104),[11,4],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_SVV_S(ntryL,G0H16(1),ex4(:),wf4(:,21),G0H2(9),m4h2x4x2(:,1),heltab3x16(:,:,2))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(105),h0tab(:,105),[11,4],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_SVV_S(ntryL,G0H16(1),ex4(:),wf4(:,22),G0H2(8),m4h2x4x2(:,2),heltab3x16(:,:,3))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(106),h0tab(:,106),[11,4],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_VWW_V(ntryL,G0H16(1),ex4(:),wf4(:,21),G0H2(6),m4h2x4x2(:,3),heltab3x16(:,:,4))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(107),h0tab(:,107),[11,4],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_VWW_V(ntryL,G0H16(1),ex4(:),wf4(:,22),G0H2(7),m4h2x4x2(:,4),heltab3x16(:,:,5))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(108),h0tab(:,108),[8,7],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(9),m3h2x8(:,93),heltab2x16(:,:,103))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(109),h0tab(:,109),[8,7],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_TV_S(ntryL,G0H16(1),0,ex4(:),8,G1H8(8),m3h2x8(:,94),heltab2x16(:,:,104))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(110),h0tab(:,110),[8,7],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(33),m3h2x8(:,95),heltab2x16(:,:,105))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(111),h0tab(:,111),[8,7],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_UV_W(ntryL,G0H16(1),0,ex4(:),8,G1H8(34),m3h2x8(:,96),heltab2x16(:,:,106))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(112),h0tab(:,112),[12,3],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_SVV_S(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(10),m4h2x2x4(:,2),heltab3x16(:,:,6))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(113),h0tab(:,113),[12,3],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_SVV_S(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(2),m4h2x2x4(:,3),heltab3x16(:,:,7))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(114),h0tab(:,114),[12,3],[nMW,nMW],3,1,wf4(:,21))
  call Hloop_VWW_V(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(6),m4h2x2x4(:,4),heltab3x16(:,:,8))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(115),h0tab(:,115),[12,3],[nMW,nMW],3,1,wf4(:,22))
  call Hloop_VWW_V(ntryL,G0H16(1),ex4(:),ex3(:),G0H4(1),m4h2x2x4(:,5),heltab3x16(:,:,9))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(116),h0tab(:,116),[10,5],[0,0],2,2,wf4(:,15),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(5),m3h4x4(:,11),heltab2x16(:,:,107))
  call Hloop_A_Q(ntryL,G0H4(5),10,0,G1H4(2),n2h4(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(117),h0tab(:,117),[10,5],[0,nMZ],2,2,wf4(:,15),wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(3),ngZd,m3h4x4(:,12),heltab2x16(:,:,108))
  call Hloop_A_Q(ntryL,G0H4(3),10,0,G1H4(6),n2h4(12))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(118),h0tab(:,118),[10,5],[0,nMW],2,2,wf4(:,15),wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(4),m3h4x4(:,13),heltab2x16(:,:,109))
  call Hloop_A_Q(ntryL,G0H4(4),10,0,G1H4(7),n2h4(13))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(119),h0tab(:,119),[10,5],[0,0],2,2,wf4(:,15),wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H16(1),wf4(:,15),G0H4(9),m3h4x4(:,14),heltab2x16(:,:,110))
  call Hloop_A_Q(ntryL,G0H4(9),10,0,G1H4(8),n2h4(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(120),h0tab(:,120),[9,6],[0,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,6),G0H4(7),m3h4x4(:,15),heltab2x16(:,:,111))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(121),h0tab(:,121),[9,6],[nMZ,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_AQ_Z(ntryL,G0H16(1),wf4(:,6),G0H4(8),ngZd,m3h4x4(:,16),heltab2x16(:,:,112))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(122),h0tab(:,122),[9,6],[nMW,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_AQ_W(ntryL,G0H16(1),wf4(:,6),G0H4(5),m3h4x4(:,17),heltab2x16(:,:,113))
  Gcoeff(:)%j = (c(5)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H16(1),m0h(123),h0tab(:,123),[9,6],[0,0],2,2,wf4(:,6),wf4(:,12))
  call Hloop_AQ_V(ntryL,G0H16(1),wf4(:,6),G0H4(3),m3h4x4(:,18),heltab2x16(:,:,114))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(8),[G0H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H2(7),[G0H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(3),[G0H4(7)])
  call Hcheck_last_TV_S(ntryL,l_switch,G0H2(8),11,ex3(:),4,G1tensor(16),m3h2x1(:,65),heltab2x2(:,:,65))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H2(7),11,ex3(:),4,G1tensor(21),m3h2x1(:,66),heltab2x2(:,:,66))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(9),ex3(:),wf4(:,21),G1tensor(26),m4h2x4x1(:,1),heltab3x8(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H8(8),ex3(:),wf4(:,22),G1tensor(31),m4h2x4x1(:,2),heltab3x8(:,:,2))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(33),ex3(:),wf4(:,21),G1tensor(36),m4h2x4x1(:,3),heltab3x8(:,:,3))
  call Hcheck_last_VWW_V(ntryL,l_switch,G1H8(34),ex3(:),wf4(:,22),G1tensor(41),m4h2x4x1(:,4),heltab3x8(:,:,4))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(10),12,wf4(:,21),3,G1tensor(46),m3h4x1(:,9),heltab2x4(:,:,34))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H4(2),12,wf4(:,22),3,G1tensor(15),m3h4x1(:,10),heltab2x4(:,:,35))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(6),12,wf4(:,21),3,G1tensor(10),m3h4x1(:,11),heltab2x4(:,:,36))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H4(1),12,wf4(:,22),3,G1tensor(17),m3h4x1(:,12),heltab2x4(:,:,37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H4(8),wf4(:,3),G1tensor(20),m3h4x1(:,13),heltab2x4(:,:,38))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H4(6),wf4(:,3),G1tensor(22),ngZd,m3h4x1(:,14),heltab2x4(:,:,39))
  call Hcheck_last_AQ_W(ntryL,l_switch,G1H4(7),wf4(:,3),G1tensor(25),m3h4x1(:,15),heltab2x4(:,:,40))
  call Hloop_VA_Q(ntryL,G0H4(3),wf4(:,12),G0H1(1),m3h4x1(:,16),heltab2x4(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(27),n2h1(50))
  call Hloop_ZA_Q(ntryL,G0H4(8),wf4(:,12),G0H1(1),ngZd,m3h4x1(:,17),heltab2x4(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(30),n2h1(51))
  call Hloop_WA_Q(ntryL,G0H4(5),wf4(:,12),G0H1(1),m3h4x1(:,18),heltab2x4(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,0,G1tensor(2),n2h1(52))
  call ol_merge_tensors(G0tensor(93),[G0tensor(73),G0tensor(50),G0tensor(6)])
  call ol_merge_tensors(G0tensor(100),[G0tensor(90),G0tensor(11)])
  call ol_merge_tensors(G1tensor(41),[G1tensor(36),G1tensor(31),G1tensor(26),G0tensor(105),G0tensor(85),G0tensor(29) &
    ,G0tensor(16)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(138),G0tensor(133),G0tensor(106),G0tensor(101),G0tensor(96),G0tensor(91) &
    ,G0tensor(86),G0tensor(81),G0tensor(76),G0tensor(71),G0tensor(66),G0tensor(24),G0tensor(18),G0tensor(8),G0tensor(7) &
    ,G0tensor(21)])
  call ol_merge_tensors(G0tensor(121),[G0tensor(33),G0tensor(15),G0tensor(31)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(48),G0tensor(23),G0tensor(36)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(65),G0tensor(55),G0tensor(38),G0tensor(45),G0tensor(27),G0tensor(41)])
  call ol_merge_tensors(G1tensor(20),[G0tensor(110),G0tensor(10)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(114),G0tensor(70),G0tensor(60),G0tensor(51),G0tensor(4),G0tensor(35) &
    ,G0tensor(17)])
  call ol_merge_tensors(G0tensor(5),[G0tensor(22)])
  call ol_merge_tensors(G0tensor(116),[G0tensor(25)])
  call ol_merge_tensors(G0tensor(128),[G0tensor(119),G0tensor(61),G0tensor(56),G0tensor(37),G0tensor(30)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(32)])
  call ol_merge_tensors(G0tensor(104),[G0tensor(99),G0tensor(88),G0tensor(74),G0tensor(3),G0tensor(42)])
  call ol_merge_tensors(G0tensor(103),[G0tensor(95),G0tensor(9)])
  call ol_merge_tensors(G0tensor(141),[G0tensor(136),G0tensor(130),G0tensor(64),G0tensor(39),G0tensor(12)])
  call ol_merge_tensors(G0tensor(78),[G0tensor(68),G0tensor(63),G0tensor(13)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(10),G1tensor(15),G1tensor(46),G0tensor(83),G0tensor(75),G0tensor(14)])
  call ol_merge_tensors(G1tensor(25),[G0tensor(140),G0tensor(80),G0tensor(34)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(123),G0tensor(49)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(53)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(54)])
  call ol_merge_tensors(G1tensor(30),[G0tensor(127),G0tensor(59)])
  call ol_merge_tensors(G1tensor(2),[G0tensor(137),G0tensor(132),G0tensor(69)])
  call ol_merge_tensors(G1tensor(21),[G1tensor(16),G0tensor(135),G0tensor(89),G0tensor(84),G0tensor(79)])
  call ol_merge_tensors(G0tensor(131),[G0tensor(126),G0tensor(122),G0tensor(117),G0tensor(113),G0tensor(109),G0tensor(98) &
    ,G0tensor(94)])
call TI_bubble_red(G1tensor(41),8,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(26))
call TI_bubble_red(G1tensor(20),10,mass2set(:,2),G0tensor(46),M2L1R1)
call TI_bubble_red(G1tensor(17),12,mass2set(:,1),G0tensor(20),M2L1R1,G0tensor(2))
call TI_bubble_red(G1tensor(25),10,mass2set(:,3),G0tensor(40),M2L1R1,G0tensor(47))
call TI_bubble_red(G1tensor(27),9,mass2set(:,2),G0tensor(28),M2L1R1)
call TI_bubble_red(G1tensor(30),9,mass2set(:,4),G0tensor(44),M2L1R1,G0tensor(19))
call TI_bubble_red(G1tensor(2),9,mass2set(:,5),G0tensor(43),M2L1R1,G0tensor(52))
call TI_bubble_red(G1tensor(21),11,mass2set(:,1),G0tensor(57),M2L1R1,G0tensor(62))
call TI_bubble_red(G1tensor(22),10,mass2set(:,6),G0tensor(67),M2L1R1,G0tensor(72))
  call ol_merge_tensors(G0tensor(62),[G0tensor(52),G0tensor(47),G0tensor(2),G0tensor(143),G0tensor(26)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(19),G0tensor(128)])
  call ol_merge_tensors(T0sum(46),[G0tensor(93)])
  call ol_merge_tensors(T0sum(47),[G0tensor(100)])
  call ol_merge_tensors(T0sum(48),[G0tensor(1)])
  call ol_merge_tensors(T0sum(49),[G0tensor(62)])
  call ol_merge_tensors(T0sum(50),[G0tensor(121)])
  call ol_merge_tensors(T0sum(51),[G0tensor(108)])
  call ol_merge_tensors(T0sum(52),[G0tensor(112)])
  call ol_merge_tensors(T0sum(53),[G0tensor(46)])
  call ol_merge_tensors(T0sum(54),[G0tensor(142)])
  call ol_merge_tensors(T0sum(55),[G0tensor(5)])
  call ol_merge_tensors(T0sum(56),[G0tensor(116)])
  call ol_merge_tensors(T0sum(57),[G0tensor(72)])
  call ol_merge_tensors(T0sum(58),[G0tensor(118)])
  call ol_merge_tensors(T0sum(59),[G0tensor(104)])
  call ol_merge_tensors(T0sum(60),[G0tensor(103)])
  call ol_merge_tensors(T0sum(61),[G0tensor(141)])
  call ol_merge_tensors(T0sum(62),[G0tensor(78)])
  call ol_merge_tensors(T0sum(63),[G0tensor(20)])
  call ol_merge_tensors(T0sum(64),[G0tensor(40)])
  call ol_merge_tensors(T0sum(65),[G0tensor(28)])
  call ol_merge_tensors(T0sum(66),[G0tensor(58)])
  call ol_merge_tensors(T0sum(67),[G0tensor(125)])
  call ol_merge_tensors(T0sum(68),[G0tensor(44)])
  call ol_merge_tensors(T0sum(69),[G0tensor(43)])
  call ol_merge_tensors(T0sum(70),[G0tensor(57)])
  call ol_merge_tensors(T0sum(71),[G0tensor(131)])
  call ol_merge_tensors(T0sum(72),[G0tensor(145)])
  call ol_merge_tensors(T0sum(73),[G0tensor(146)])
  call ol_merge_tensors(T0sum(74),[G0tensor(147)])
  call ol_merge_tensors(T0sum(75),[G0tensor(148)])
  call ol_merge_tensors(T0sum(76),[G0tensor(150)])
  call ol_merge_tensors(T0sum(77),[G0tensor(151)])
  call ol_merge_tensors(T0sum(78),[G0tensor(152)])
  call ol_merge_tensors(T0sum(79),[G0tensor(153)])
  call ol_merge_tensors(T0sum(80),[G0tensor(155)])
  call ol_merge_tensors(T0sum(81),[G0tensor(156)])
  call ol_merge_tensors(T0sum(82),[G0tensor(157)])
  call ol_merge_tensors(T0sum(83),[G0tensor(158)])
  call ol_merge_tensors(T0sum(84),[G0tensor(160)])
  call ol_merge_tensors(T0sum(85),[G0tensor(161)])
  call ol_merge_tensors(T0sum(86),[G0tensor(162)])
  call ol_merge_tensors(T0sum(87),[G0tensor(163)])
  call ol_merge_tensors(T0sum(88),[G0tensor(165)])
  call ol_merge_tensors(T0sum(89),[G0tensor(166)])
  call ol_merge_tensors(T0sum(90),[G0tensor(167)])
  call ol_merge_tensors(T0sum(91),[G0tensor(168)])
  call ol_merge_tensors(T0sum(92),[G0tensor(67)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvv_ew_ddxaa_1_/**/REALKIND
