
module ol_vamp_1_ppvv_ew_bbxwwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvv_ew_bbxwwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvv_ew_bbxwwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvv_ew_bbxwwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvv_ew_bbxwwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvv_ew_bbxwwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvv_ew_bbxwwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(36)
  type(Hpolcont), intent(in) :: M(2,36)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMT,nMW,nMT,nMB],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMT,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMH,nMB,nMH,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(2),m3h3x12(:,2),heltab2x36(:,:,2))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(3),m3h3x12(:,3),heltab2x36(:,:,3))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(4),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(5),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMT,nMW,nMT,nMB],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,6),heltab2x36(:,:,6))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMT,G1H12(6),n2h12(2))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[8,2,1,4],[nMH,nMB,nMH,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,7),heltab2x36(:,:,7))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[8,2,1,4],[0,nMB,nMH,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,8),heltab2x36(:,:,8))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[8,2,1,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,9),heltab2x36(:,:,9))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[8,2,1,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,10),heltab2x36(:,:,10))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[8,2,1,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,11),heltab2x36(:,:,11))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[8,2,1,4],[nMH,nMB,0,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(7),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[8,2,1,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(8),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[8,2,1,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(9),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[8,2,1,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(10),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (c(74)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[8,2,1,4],[0,nMB,nMH,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(11),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[8,2,1,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(12),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(74)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[8,2,1,4],[nMH,nMB,0,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[8,2,1,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[8,2,1,4],[0,nMB,0,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,20),heltab2x36(:,:,20))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[8,2,1,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,21),heltab2x36(:,:,21))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[8,2,1,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(10),m3h3x12(:,22),heltab2x36(:,:,22))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[8,2,1,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(11),m3h3x12(:,23),heltab2x36(:,:,23))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[8,2,1,4],[0,nMB,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(13),m3h3x12(:,24),heltab2x36(:,:,24))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[8,2,1,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(14),m3h3x12(:,25),heltab2x36(:,:,25))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[8,2,1,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(15),m3h3x12(:,26),heltab2x36(:,:,26))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[8,2,1,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(16),m3h3x12(:,27),heltab2x36(:,:,27))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[8,1,2,4],[nMB,nMH,nMB,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,28),heltab2x36(:,:,28))
  call Hloop_A_Q(ntryL,G0H12(12),8,nMB,G1H12(17),n2h12(3))
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[8,1,2,4],[nMB,nMZ,nMB,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,29),heltab2x36(:,:,29))
  call Hloop_A_Q(ntryL,G0H12(12),8,nMB,G1H12(18),n2h12(4))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[8,1,2,4],[nMH,nMB,nMH,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(19),m3h3x12(:,30),heltab2x36(:,:,30))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[8,1,2,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(20),m3h3x12(:,31),heltab2x36(:,:,31))
  Gcoeff(:)%j = (c(27)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[8,1,2,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(21),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[8,1,2,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(22),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[8,1,2,4],[nMW,nMT,nMW,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(23),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[8,1,2,4],[nMW,nMT,nMW,nMZ],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(24),m3h3x12(:,35),heltab2x36(:,:,35))
  Gcoeff(:)%j = (c(62)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[8,1,2,4],[nMB,0,nMB,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,36),heltab2x36(:,:,36))
  call Hloop_A_Q(ntryL,G0H12(12),8,nMB,G1H12(25),n2h12(5))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[8,1,2,4],[nMB,nMZ,nMB,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,37),heltab2x36(:,:,37))
  call Hloop_A_Q(ntryL,G0H12(12),8,nMB,G1H12(26),n2h12(6))
  Gcoeff(:)%j = (c(71)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[8,1,2,4],[nMB,0,nMB,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,38),heltab2x36(:,:,38))
  call Hloop_A_Q(ntryL,G0H12(12),8,nMB,G1H12(27),n2h12(7))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[8,1,2,4],[nMW,nMT,nMW,0],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,39),heltab2x36(:,:,39))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[8,1,2,4],[nMW,nMT,nMW,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(13),m3h3x12(:,40),heltab2x36(:,:,40))
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[8,1,2,4],[nMH,nMB,nMH,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(14),m3h3x12(:,41),heltab2x36(:,:,41))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[8,1,2,4],[nMH,nMB,0,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(28),m3h3x12(:,42),heltab2x36(:,:,42))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[8,1,2,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(29),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[8,1,2,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(30),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[8,1,2,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(31),m3h3x12(:,45),heltab2x36(:,:,45))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[8,1,2,4],[nMW,nMT,nMW,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(32),m3h3x12(:,46),heltab2x36(:,:,46))
  Gcoeff(:)%j = (c(73)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[8,1,2,4],[0,nMB,nMH,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(15),m3h3x12(:,47),heltab2x36(:,:,47))
  Gcoeff(:)%j = (-(c(73)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[8,1,2,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(16),m3h3x12(:,48),heltab2x36(:,:,48))
  Gcoeff(:)%j = (c(94)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[8,1,2,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(17),m3h3x12(:,49),heltab2x36(:,:,49))
  Gcoeff(:)%j = (-(c(94)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[8,1,2,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(18),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[8,1,2,4],[nMW,nMT,nMW,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(19),m3h3x12(:,51),heltab2x36(:,:,51))
  Gcoeff(:)%j = (c(74)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[8,1,2,4],[nMH,nMB,0,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(20),m3h3x12(:,52),heltab2x36(:,:,52))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[8,1,2,4],[nMW,nMT,nMW,0],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(21),m3h3x12(:,53),heltab2x36(:,:,53))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[8,1,2,4],[nMH,nMB,nMZ,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(22),m3h3x12(:,54),heltab2x36(:,:,54))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[8,1,2,4],[nMW,nMT,nMW,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(23),m3h3x12(:,55),heltab2x36(:,:,55))
  Gcoeff(:)%j = (c(74)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[8,1,2,4],[0,nMB,nMH,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(33),m3h3x12(:,56),heltab2x36(:,:,56))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[8,1,2,4],[nMW,nMT,nMW,0],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(34),m3h3x12(:,57),heltab2x36(:,:,57))
  Gcoeff(:)%j = (-(c(55)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[8,1,2,4],[nMZ,nMB,nMH,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(35),m3h3x12(:,58),heltab2x36(:,:,58))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[8,1,2,4],[nMW,nMT,nMW,nMZ],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(36),m3h3x12(:,59),heltab2x36(:,:,59))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[8,1,2,4],[0,nMB,0,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(24),m3h3x12(:,60),heltab2x36(:,:,60))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[8,1,2,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(25),m3h3x12(:,61),heltab2x36(:,:,61))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[8,1,2,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(26),m3h3x12(:,62),heltab2x36(:,:,62))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[8,1,2,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(27),m3h3x12(:,63),heltab2x36(:,:,63))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[8,1,2,4],[nMW,nMT,nMW,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(28),m3h3x12(:,64),heltab2x36(:,:,64))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[8,1,2,4],[0,nMB,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(37),m3h3x12(:,65),heltab2x36(:,:,65))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[8,1,2,4],[0,nMB,nMZ,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(38),m3h3x12(:,66),heltab2x36(:,:,66))
  Gcoeff(:)%j = (-(c(91)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[8,1,2,4],[nMZ,nMB,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(39),m3h3x12(:,67),heltab2x36(:,:,67))
  Gcoeff(:)%j = (c(70)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[8,1,2,4],[nMZ,nMB,nMZ,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(40),m3h3x12(:,68),heltab2x36(:,:,68))
  Gcoeff(:)%j = (c(68)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[8,1,2,4],[nMW,nMT,nMW,0],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(41),m3h3x12(:,69),heltab2x36(:,:,69))
  Gcoeff(:)%j = (c(13)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[8,1,2,4],[nMW,nMT,nMW,nMZ],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(42),m3h3x12(:,70),heltab2x36(:,:,70))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[8,1,4,2],[nMW,nMT,nMB,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(43),m3h3x12(:,71),heltab2x36(:,:,71))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[8,1,4,2],[nMW,nMT,nMB,nMZ],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(44),m3h3x12(:,72),heltab2x36(:,:,72))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[8,1,4,2],[nMB,nMH,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,73),heltab2x36(:,:,73))
  call Hloop_A_Q(ntryL,G0H12(29),8,nMB,G1H12(45),n2h12(8))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[8,1,4,2],[nMB,nMZ,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,74),heltab2x36(:,:,74))
  call Hloop_A_Q(ntryL,G0H12(29),8,nMB,G1H12(46),n2h12(9))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[8,1,4,2],[nMW,nMT,nMB,0],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,75),heltab2x36(:,:,75))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[8,1,4,2],[nMW,nMT,nMB,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(30),m3h3x12(:,76),heltab2x36(:,:,76))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[8,1,4,2],[nMW,nMT,nMB,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(31),m3h3x12(:,77),heltab2x36(:,:,77))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[8,1,4,2],[nMB,nMH,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,78),heltab2x36(:,:,78))
  call Hloop_A_Q(ntryL,G0H12(32),8,nMB,G1H12(47),n2h12(10))
  Gcoeff(:)%j = (c(65)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[8,1,4,2],[nMB,0,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,79),heltab2x36(:,:,79))
  call Hloop_A_Q(ntryL,G0H12(32),8,nMB,G1H12(48),n2h12(11))
  Gcoeff(:)%j = (c(89)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[8,1,4,2],[nMB,nMZ,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,80),heltab2x36(:,:,80))
  call Hloop_A_Q(ntryL,G0H12(32),8,nMB,G1H12(49),n2h12(12))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[8,1,4,2],[nMW,nMT,nMB,0],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(50),m3h3x12(:,81),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[8,1,4,2],[nMW,nMT,nMB,nMZ],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(51),m3h3x12(:,82),heltab2x36(:,:,82))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[8,1,4,2],[nMB,0,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,83),heltab2x36(:,:,83))
  call Hloop_A_Q(ntryL,G0H12(32),8,nMB,G1H12(52),n2h12(13))
  Gcoeff(:)%j = (c(50)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[8,1,4,2],[nMB,nMZ,nMW,nMT],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,84),heltab2x36(:,:,84))
  call Hloop_A_Q(ntryL,G0H12(32),8,nMB,G1H12(53),n2h12(14))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(25)])
  call Hloop_QA_S(ntryL,G1H12(1),ex2(:),G1H6(1),ngPbt,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_SA_Q(ntryL,G1H12(2),ex2(:),G1H6(2),ngH,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_A_Q(ntryL,G1H6(2),10,nMB,G2H6(1),n2h6(1))
  call Hloop_SA_Q(ntryL,G1H12(3),ex2(:),G1H6(2),ngX,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G1H6(2),10,nMB,G2H6(2),n2h6(2))
  call Hloop_SA_Q(ntryL,G1H12(4),ex2(:),G1H6(2),ngH,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G1H6(2),10,nMB,G2H6(3),n2h6(3))
  call Hloop_SA_Q(ntryL,G1H12(5),ex2(:),G1H6(2),ngX,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H6(2),10,nMB,G2H6(4),n2h6(4))
  call Hloop_QA_W(ntryL,G1H12(6),ex2(:),G1H6(2),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_SA_Q(ntryL,G0H12(1),ex2(:),G0H6(1),ngH,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(3),n2h6(5))
  call Hloop_VA_Q(ntryL,G0H12(2),ex2(:),G0H6(1),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(4),n2h6(6))
  call Hloop_VA_Q(ntryL,G0H12(3),ex2(:),G0H6(1),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(5),n2h6(7))
  call Hloop_ZA_Q(ntryL,G0H12(4),ex2(:),G0H6(1),ngZd,m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(6),n2h6(8))
  call Hloop_ZA_Q(ntryL,G0H12(5),ex2(:),G0H6(1),ngZd,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(7),n2h6(9))
  call Hloop_SA_Q(ntryL,G1H12(7),ex2(:),G1H6(8),ngH,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(5),n2h6(10))
  call Hloop_SA_Q(ntryL,G1H12(8),ex2(:),G1H6(8),ngX,m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(6),n2h6(11))
  call Hloop_SA_Q(ntryL,G1H12(9),ex2(:),G1H6(8),ngH,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(7),n2h6(12))
  call Hloop_SA_Q(ntryL,G1H12(10),ex2(:),G1H6(8),ngX,m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(8),n2h6(13))
  call Hloop_VA_Q(ntryL,G1H12(11),ex2(:),G1H6(8),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(9),n2h6(14))
  call Hloop_ZA_Q(ntryL,G1H12(12),ex2(:),G1H6(8),ngZd,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(8),10,nMB,G2H6(10),n2h6(15))
  call Hloop_SA_Q(ntryL,G0H12(6),ex2(:),G0H6(1),ngH,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(8),n2h6(16))
  call Hloop_SA_Q(ntryL,G0H12(7),ex2(:),G0H6(1),ngH,m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(9),n2h6(17))
  call Hloop_VA_Q(ntryL,G0H12(8),ex2(:),G0H6(1),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(10),n2h6(18))
  call Hloop_ZA_Q(ntryL,G0H12(9),ex2(:),G0H6(1),ngZd,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(11),n2h6(19))
  call Hloop_VA_Q(ntryL,G0H12(10),ex2(:),G0H6(1),m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(12),n2h6(20))
  call Hloop_ZA_Q(ntryL,G0H12(11),ex2(:),G0H6(1),ngZd,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(13),n2h6(21))
  call Hloop_VA_Q(ntryL,G1H12(13),ex2(:),G1H6(14),m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_A_Q(ntryL,G1H6(14),10,nMB,G2H6(11),n2h6(22))
  call Hloop_ZA_Q(ntryL,G1H12(14),ex2(:),G1H6(14),ngZd,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G1H6(14),10,nMB,G2H6(12),n2h6(23))
  call Hloop_VA_Q(ntryL,G1H12(15),ex2(:),G1H6(14),m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_A_Q(ntryL,G1H6(14),10,nMB,G2H6(13),n2h6(24))
  call Hloop_ZA_Q(ntryL,G1H12(16),ex2(:),G1H6(14),ngZd,m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_A_Q(ntryL,G1H6(14),10,nMB,G2H6(14),n2h6(25))
  call Hloop_AQ_S(ntryL,G1H12(17),ex1(:),G1H6(14),ngH,m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_AQ_S(ntryL,G1H12(18),ex1(:),G1H6(15),ngX,m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_SQ_A(ntryL,G1H12(19),ex1(:),G1H6(16),ngH,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMB,G2H6(15),n2h6(26))
  call Hloop_SQ_A(ntryL,G1H12(20),ex1(:),G1H6(16),ngH,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMB,G2H6(16),n2h6(27))
  call Hloop_SQ_A(ntryL,G1H12(21),ex1(:),G1H6(16),ngX,m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMB,G2H6(17),n2h6(28))
  call Hloop_SQ_A(ntryL,G1H12(22),ex1(:),G1H6(16),ngX,m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMB,G2H6(18),n2h6(29))
  call Hloop_SQ_A(ntryL,G1H12(23),ex1(:),G1H6(16),ngPtb,m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMT,G2H6(19),n2h6(30))
  call Hloop_SQ_A(ntryL,G1H12(24),ex1(:),G1H6(16),ngPtb,m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G1H6(16),9,nMT,G2H6(20),n2h6(31))
  call Hloop_AQ_V(ntryL,G1H12(27),ex1(:),G1H6(16),m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_AQ_Z(ntryL,G1H12(26),ex1(:),G1H6(17),ngZd,m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_SQ_A(ntryL,G0H12(12),ex1(:),G0H6(1),ngPtb,m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(18),n2h6(32))
  call Hloop_SQ_A(ntryL,G0H12(13),ex1(:),G0H6(1),ngPtb,m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(19),n2h6(33))
  call Hloop_SQ_A(ntryL,G0H12(14),ex1(:),G0H6(1),ngH,m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(20),n2h6(34))
  call Hloop_SQ_A(ntryL,G1H12(28),ex1(:),G1H6(21),ngH,m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(21),9,nMB,G2H6(21),n2h6(35))
  call Hloop_SQ_A(ntryL,G1H12(29),ex1(:),G1H6(21),ngX,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(21),9,nMB,G2H6(22),n2h6(36))
  call Hloop_SQ_A(ntryL,G1H12(30),ex1(:),G1H6(21),ngH,m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(21),9,nMB,G2H6(23),n2h6(37))
  call Hloop_SQ_A(ntryL,G1H12(31),ex1(:),G1H6(21),ngX,m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H6(21),9,nMB,G2H6(24),n2h6(38))
  call Hloop_SQ_A(ntryL,G1H12(32),ex1(:),G1H6(21),ngPtb,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H6(21),9,nMT,G2H6(25),n2h6(39))
  call Hloop_VQ_A(ntryL,G0H12(15),ex1(:),G0H6(1),m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(21),n2h6(40))
  call Hloop_VQ_A(ntryL,G0H12(16),ex1(:),G0H6(1),m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(22),n2h6(41))
  call Hloop_ZQ_A(ntryL,G0H12(17),ex1(:),G0H6(1),ngZd,m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(23),n2h6(42))
  call Hloop_ZQ_A(ntryL,G0H12(18),ex1(:),G0H6(1),ngZd,m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(24),n2h6(43))
  call Hloop_WQ_A(ntryL,G0H12(19),ex1(:),G0H6(1),m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(25),n2h6(44))
  call Hloop_SQ_A(ntryL,G0H12(20),ex1(:),G0H6(1),ngH,m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(26),n2h6(45))
  call Hloop_SQ_A(ntryL,G0H12(21),ex1(:),G0H6(1),ngPtb,m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(27),n2h6(46))
  call Hloop_SQ_A(ntryL,G0H12(22),ex1(:),G0H6(1),ngH,m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(28),n2h6(47))
  call Hloop_SQ_A(ntryL,G0H12(23),ex1(:),G0H6(1),ngPtb,m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(29),n2h6(48))
  call Hloop_VQ_A(ntryL,G1H12(33),ex1(:),G1H6(30),m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(30),9,nMB,G2H6(26),n2h6(49))
  call Hloop_WQ_A(ntryL,G1H12(34),ex1(:),G1H6(30),m3h2x6(:,56),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H6(30),9,nMT,G2H6(27),n2h6(50))
  call Hloop_ZQ_A(ntryL,G1H12(35),ex1(:),G1H6(30),ngZd,m3h2x6(:,57),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(30),9,nMB,G2H6(28),n2h6(51))
  call Hloop_WQ_A(ntryL,G1H12(36),ex1(:),G1H6(30),m3h2x6(:,58),heltab2x12(:,:,58))
  call Hloop_Q_A(ntryL,G1H6(30),9,nMT,G2H6(29),n2h6(52))
  call Hloop_VQ_A(ntryL,G0H12(24),ex1(:),G0H6(1),m3h2x6(:,59),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(30),n2h6(53))
  call Hloop_VQ_A(ntryL,G0H12(25),ex1(:),G0H6(1),m3h2x6(:,60),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(31),n2h6(54))
  call Hloop_ZQ_A(ntryL,G0H12(26),ex1(:),G0H6(1),ngZd,m3h2x6(:,61),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(32),n2h6(55))
  call Hloop_ZQ_A(ntryL,G0H12(27),ex1(:),G0H6(1),ngZd,m3h2x6(:,62),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(33),n2h6(56))
  call Hloop_WQ_A(ntryL,G0H12(28),ex1(:),G0H6(1),m3h2x6(:,63),heltab2x12(:,:,63))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(34),n2h6(57))
  call Hloop_VQ_A(ntryL,G1H12(37),ex1(:),G1H6(35),m3h2x6(:,64),heltab2x12(:,:,64))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMB,G2H6(30),n2h6(58))
  call Hloop_VQ_A(ntryL,G1H12(38),ex1(:),G1H6(35),m3h2x6(:,65),heltab2x12(:,:,65))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMB,G2H6(31),n2h6(59))
  call Hloop_ZQ_A(ntryL,G1H12(39),ex1(:),G1H6(35),ngZd,m3h2x6(:,66),heltab2x12(:,:,66))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMB,G2H6(32),n2h6(60))
  call Hloop_ZQ_A(ntryL,G1H12(40),ex1(:),G1H6(35),ngZd,m3h2x6(:,67),heltab2x12(:,:,67))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMB,G2H6(33),n2h6(61))
  call Hloop_WQ_A(ntryL,G1H12(41),ex1(:),G1H6(35),m3h2x6(:,68),heltab2x12(:,:,68))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMT,G2H6(34),n2h6(62))
  call Hloop_WQ_A(ntryL,G1H12(42),ex1(:),G1H6(35),m3h2x6(:,69),heltab2x12(:,:,69))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMT,G2H6(35),n2h6(63))
  call Hloop_SQ_A(ntryL,G1H12(43),ex1(:),G1H6(35),ngPtb,m3h2x6(:,70),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMT,G2H6(36),n2h6(64))
  call Hloop_SQ_A(ntryL,G1H12(44),ex1(:),G1H6(35),ngPtb,m3h2x6(:,71),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMT,G2H6(37),n2h6(65))
  call Hloop_AQ_S(ntryL,G1H12(45),ex1(:),G1H6(35),ngH,m3h2x6(:,72),heltab2x12(:,:,72))
  call Hloop_AQ_S(ntryL,G1H12(46),ex1(:),G1H6(36),ngX,m3h2x6(:,73),heltab2x12(:,:,73))
  call Hloop_SQ_A(ntryL,G0H12(29),ex1(:),G0H6(1),ngPtb,m3h2x6(:,74),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(37),n2h6(66))
  call Hloop_SQ_A(ntryL,G0H12(30),ex1(:),G0H6(1),ngPtb,m3h2x6(:,75),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(38),n2h6(67))
  call Hloop_WQ_A(ntryL,G0H12(31),ex1(:),G0H6(1),m3h2x6(:,76),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(39),n2h6(68))
  call Hloop_AQ_S(ntryL,G1H12(47),ex1(:),G1H6(40),ngH,m3h2x6(:,77),heltab2x12(:,:,77))
  call Hloop_AQ_V(ntryL,G1H12(48),ex1(:),G1H6(41),m3h2x6(:,78),heltab2x12(:,:,78))
  call Hloop_AQ_Z(ntryL,G1H12(49),ex1(:),G1H6(42),ngZd,m3h2x6(:,79),heltab2x12(:,:,79))
  call Hloop_WQ_A(ntryL,G1H12(50),ex1(:),G1H6(43),m3h2x6(:,80),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H6(43),9,nMT,G2H6(38),n2h6(69))
  call Hloop_WQ_A(ntryL,G1H12(51),ex1(:),G1H6(43),m3h2x6(:,81),heltab2x12(:,:,81))
  call Hloop_Q_A(ntryL,G1H6(43),9,nMT,G2H6(39),n2h6(70))
  call Hloop_AQ_V(ntryL,G1H12(52),ex1(:),G1H6(43),m3h2x6(:,82),heltab2x12(:,:,82))
  call Hloop_AQ_Z(ntryL,G1H12(53),ex1(:),G1H6(44),ngZd,m3h2x6(:,83),heltab2x12(:,:,83))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(19),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(27),[G1H6(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(29),[G1H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(22),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(24),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(25),[G1H6(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(34),[G1H6(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(35),[G1H6(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(36),[G1H6(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(38),[G1H6(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(39),[G1H6(38)])
  call Hloop_SQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),ngPtb,m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMT,G2H3(1),n2h3(1))
  call Hloop_AQ_S(ntryL,G2H6(1),ex1(:),G2H3(2),ngH,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_AQ_S(ntryL,G2H6(2),ex1(:),G2H3(3),ngH,m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_AQ_S(ntryL,G2H6(3),ex1(:),G2H3(4),ngX,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_AQ_S(ntryL,G2H6(4),ex1(:),G2H3(5),ngX,m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_WQ_A(ntryL,G1H6(2),ex1(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMT,G2H3(6),n2h3(2))
  call Hloop_AQ_S(ntryL,G1H6(3),ex1(:),G1H3(1),ngH,m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_AQ_S(ntryL,G1H6(4),ex1(:),G1H3(2),ngH,m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_AQ_S(ntryL,G1H6(5),ex1(:),G1H3(3),ngX,m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_AQ_V(ntryL,G2H6(5),ex1(:),G2H3(7),m3h2x3(:,10),heltab2x6(:,:,10))
  call Hloop_AQ_V(ntryL,G2H6(6),ex1(:),G2H3(8),m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H6(7),ex1(:),G2H3(9),ngZd,m3h2x3(:,12),heltab2x6(:,:,12))
  call Hloop_AQ_Z(ntryL,G2H6(8),ex1(:),G2H3(10),ngZd,m3h2x3(:,13),heltab2x6(:,:,13))
  call Hloop_AQ_S(ntryL,G2H6(9),ex1(:),G2H3(11),ngH,m3h2x3(:,14),heltab2x6(:,:,14))
  call Hloop_AQ_S(ntryL,G2H6(10),ex1(:),G2H3(12),ngH,m3h2x3(:,15),heltab2x6(:,:,15))
  call Hloop_AQ_V(ntryL,G1H6(8),ex1(:),G1H3(4),m3h2x3(:,16),heltab2x6(:,:,16))
  call Hloop_AQ_Z(ntryL,G1H6(9),ex1(:),G1H3(5),ngZd,m3h2x3(:,17),heltab2x6(:,:,17))
  call Hloop_AQ_V(ntryL,G1H6(10),ex1(:),G1H3(6),m3h2x3(:,18),heltab2x6(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H6(12),ex1(:),G1H3(7),ngZd,m3h2x3(:,19),heltab2x6(:,:,19))
  call Hloop_AQ_V(ntryL,G2H6(11),ex1(:),G2H3(13),m3h2x3(:,20),heltab2x6(:,:,20))
  call Hloop_AQ_V(ntryL,G2H6(12),ex1(:),G2H3(14),m3h2x3(:,21),heltab2x6(:,:,21))
  call Hloop_AQ_Z(ntryL,G2H6(13),ex1(:),G2H3(15),ngZd,m3h2x3(:,22),heltab2x6(:,:,22))
  call Hloop_AQ_Z(ntryL,G2H6(14),ex1(:),G2H3(16),ngZd,m3h2x3(:,23),heltab2x6(:,:,23))
  call Hloop_SA_Q(ntryL,G1H6(14),ex2(:),G1H3(8),ngH,m3h2x3(:,24),heltab2x6(:,:,24))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMB,G2H3(17),n2h3(3))
  call Hloop_SA_Q(ntryL,G1H6(15),ex2(:),G1H3(8),ngX,m3h2x3(:,25),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMB,G2H3(18),n2h3(4))
  call Hloop_QA_S(ntryL,G2H6(15),ex2(:),G2H3(19),ngH,m3h2x3(:,26),heltab2x6(:,:,26))
  call Hloop_QA_S(ntryL,G2H6(16),ex2(:),G2H3(20),ngX,m3h2x3(:,27),heltab2x6(:,:,27))
  call Hloop_QA_S(ntryL,G2H6(17),ex2(:),G2H3(21),ngH,m3h2x3(:,28),heltab2x6(:,:,28))
  call Hloop_QA_S(ntryL,G2H6(18),ex2(:),G2H3(22),ngX,m3h2x3(:,29),heltab2x6(:,:,29))
  call Hloop_QA_S(ntryL,G2H6(19),ex2(:),G2H3(23),ngPbt,m3h2x3(:,30),heltab2x6(:,:,30))
  call Hloop_QA_S(ntryL,G2H6(20),ex2(:),G2H3(24),ngPbt,m3h2x3(:,31),heltab2x6(:,:,31))
  call Hloop_VA_Q(ntryL,G1H6(16),ex2(:),G1H3(8),m3h2x3(:,32),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMB,G2H3(25),n2h3(5))
  call Hloop_ZA_Q(ntryL,G1H6(17),ex2(:),G1H3(8),ngZd,m3h2x3(:,33),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMB,G2H3(26),n2h3(6))
  call Hloop_QA_S(ntryL,G2H6(27),ex2(:),G2H3(27),ngPbt,m3h2x3(:,34),heltab2x6(:,:,34))
  call Hloop_QA_S(ntryL,G2H6(29),ex2(:),G2H3(28),ngPbt,m3h2x3(:,35),heltab2x6(:,:,35))
  call Hloop_QA_S(ntryL,G1H6(20),ex2(:),G1H3(8),ngH,m3h2x3(:,36),heltab2x6(:,:,36))
  call Hloop_QA_V(ntryL,G2H6(21),ex2(:),G2H3(29),m3h2x3(:,37),heltab2x6(:,:,37))
  call Hloop_QA_V(ntryL,G2H6(22),ex2(:),G2H3(30),m3h2x3(:,38),heltab2x6(:,:,38))
  call Hloop_QA_Z(ntryL,G2H6(23),ex2(:),G2H3(31),ngZd,m3h2x3(:,39),heltab2x6(:,:,39))
  call Hloop_QA_Z(ntryL,G2H6(24),ex2(:),G2H3(32),ngZd,m3h2x3(:,40),heltab2x6(:,:,40))
  call Hloop_QA_W(ntryL,G2H6(25),ex2(:),G2H3(33),m3h2x3(:,41),heltab2x6(:,:,41))
  call Hloop_QA_S(ntryL,G1H6(21),ex2(:),G1H3(9),ngH,m3h2x3(:,42),heltab2x6(:,:,42))
  call Hloop_QA_S(ntryL,G1H6(22),ex2(:),G1H3(10),ngX,m3h2x3(:,43),heltab2x6(:,:,43))
  call Hloop_QA_V(ntryL,G1H6(26),ex2(:),G1H3(11),m3h2x3(:,44),heltab2x6(:,:,44))
  call Hloop_QA_W(ntryL,G2H6(34),ex2(:),G2H3(34),m3h2x3(:,45),heltab2x6(:,:,45))
  call Hloop_QA_Z(ntryL,G1H6(28),ex2(:),G1H3(12),ngZd,m3h2x3(:,46),heltab2x6(:,:,46))
  call Hloop_QA_W(ntryL,G2H6(35),ex2(:),G2H3(35),m3h2x3(:,47),heltab2x6(:,:,47))
  call Hloop_QA_S(ntryL,G2H6(26),ex2(:),G2H3(36),ngH,m3h2x3(:,48),heltab2x6(:,:,48))
  call Hloop_QA_S(ntryL,G2H6(28),ex2(:),G2H3(37),ngH,m3h2x3(:,49),heltab2x6(:,:,49))
  call Hloop_QA_V(ntryL,G1H6(30),ex2(:),G1H3(13),m3h2x3(:,50),heltab2x6(:,:,50))
  call Hloop_QA_Z(ntryL,G1H6(31),ex2(:),G1H3(14),ngZd,m3h2x3(:,51),heltab2x6(:,:,51))
  call Hloop_QA_V(ntryL,G2H6(30),ex2(:),G2H3(38),m3h2x3(:,52),heltab2x6(:,:,52))
  call Hloop_QA_Z(ntryL,G2H6(31),ex2(:),G2H3(39),ngZd,m3h2x3(:,53),heltab2x6(:,:,53))
  call Hloop_QA_V(ntryL,G2H6(32),ex2(:),G2H3(40),m3h2x3(:,54),heltab2x6(:,:,54))
  call Hloop_QA_Z(ntryL,G2H6(33),ex2(:),G2H3(41),ngZd,m3h2x3(:,55),heltab2x6(:,:,55))
  call Hotf_4pt_reduction(G2H6(36),RedSet_4(1),mass4set(:,1),  & 
G1H6(6),G1H6(7),G1H6(11),G1H6(13),G1H6(23),6)
  call HG1shiftOLR(G1H6(7),2,6)
  call Hotf_4pt_reduction(G2H6(37),RedSet_4(1),mass4set(:,2),  & 
G1H6(24),G1H6(25),G1H6(18),G1H6(19),G1H6(32),6)
  call HG1shiftOLR(G1H6(25),2,6)
  call Hloop_TV_S(ntryL,G1H6(35),9,ex3(:),4,G2H2(1),m3h3x2(:,1),heltab2x6(:,:,56))
  call Hloop_TV_S(ntryL,G1H6(36),9,ex3(:),4,G2H2(2),m3h3x2(:,2),heltab2x6(:,:,57))
  call Hotf_4pt_reduction(G2H6(38),RedSet_4(1),mass4set(:,3),  & 
G1H6(33),G1H6(34),G1H6(27),G1H6(29),G1H6(39),6)
  call HG1shiftOLR(G1H6(34),2,6)
  call Hotf_4pt_reduction(G2H6(39),RedSet_4(1),mass4set(:,2),  & 
G1H6(37),G1H6(38),G1H6(1),G1H6(2),G1H6(3),6)
  call HG1shiftOLR(G1H6(38),2,6)
  call Hloop_SV_V(ntryL,G1H6(40),ex3(:),G1H2(1),m3h3x2(:,3),heltab2x6(:,:,58))
  call Hloop_VV_S(ntryL,G1H6(41),ex3(:),G1H2(2),m3h3x2(:,4),heltab2x6(:,:,59))
  call Hloop_VV_S(ntryL,G1H6(42),ex3(:),G1H2(3),m3h3x2(:,5),heltab2x6(:,:,60))
  call Hloop_UW_V(ntryL,G1H6(43),9,ex3(:),4,G2H2(3),m3h3x2(:,6),heltab2x6(:,:,61))
  call Hloop_UW_V(ntryL,G1H6(44),9,ex3(:),4,G2H2(4),m3h3x2(:,7),heltab2x6(:,:,62))
  call Hloop_QW_A(ntryL,G1H6(6),ex3(:),G1H2(4),m3h3x2(:,8),heltab2x6(:,:,63))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(5),n2h2(1))
call HGT_OLR(G1H6(7),1,1,6)
call HGT_invQ_OLR(G1H6(7),2,5,6)
  call Hloop_SA_Q(ntryL,G1H6(7),ex2(:),G1H3(15),ngH,m3h2x3(:,56),heltab2x6(:,:,64))
  call Hloop_QW_A(ntryL,G1H6(13),ex3(:),G1H2(4),m3h3x2(:,9),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(6),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(23),ex3(:),G1H2(4),m3h3x2(:,10),heltab2x6(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(7),n2h2(3))
  call Hloop_QW_A(ntryL,G1H6(24),ex3(:),G1H2(4),m3h3x2(:,11),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(8),n2h2(4))
call HGT_OLR(G1H6(25),1,1,6)
call HGT_invQ_OLR(G1H6(25),2,5,6)
  call Hloop_SA_Q(ntryL,G1H6(25),ex2(:),G1H3(16),ngX,m3h2x3(:,57),heltab2x6(:,:,68))
  call Hloop_QW_A(ntryL,G1H6(19),ex3(:),G1H2(4),m3h3x2(:,12),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(9),n2h2(5))
  call Hloop_QW_A(ntryL,G1H6(32),ex3(:),G1H2(4),m3h3x2(:,13),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(10),n2h2(6))
  call Hloop_QW_A(ntryL,G1H6(33),ex3(:),G1H2(4),m3h3x2(:,14),heltab2x6(:,:,71))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(11),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(34),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(34),ex2(:),G1H3(17),m3h2x3(:,58),heltab2x6(:,:,72))
  call Hloop_QW_A(ntryL,G1H6(29),ex3(:),G1H2(4),m3h3x2(:,15),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(12),n2h2(8))
  call Hloop_QW_A(ntryL,G1H6(39),ex3(:),G1H2(4),m3h3x2(:,16),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(13),n2h2(9))
  call Hloop_QW_A(ntryL,G1H6(37),ex3(:),G1H2(4),m3h3x2(:,17),heltab2x6(:,:,75))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(14),n2h2(10))
call HGT_raise_alpha_OLR(G1H6(38),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(38),2,5,6)
  call Hloop_ZA_Q(ntryL,G1H6(38),ex2(:),G1H3(18),ngZd,m3h2x3(:,59),heltab2x6(:,:,76))
  call Hloop_QW_A(ntryL,G1H6(2),ex3(:),G1H2(4),m3h3x2(:,18),heltab2x6(:,:,77))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(15),n2h2(11))
  call Hloop_QW_A(ntryL,G1H6(3),ex3(:),G1H2(4),m3h3x2(:,19),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(16),n2h2(12))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(6),[G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(3)])
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(2),mass4set(:,4),  & 
G1H3(19),G1H3(20),G1H3(21),G1H3(22),G1H3(23),3)
  call HG1shiftOLR(G1H3(20),4,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,5),  & 
G1H3(24),G1H3(25),G1H3(26),G1H3(27),G1H3(28),3)
  call HG1shiftOLR(G1H3(25),4,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(2),mass4set(:,6),  & 
G1H3(29),G1H3(30),G1H3(31),G1H3(32),G1H3(33),3)
  call HG1shiftOLR(G1H3(30),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(2),mass4set(:,7),  & 
G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),3)
  call HG1shiftOLR(G1H3(35),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(2),mass4set(:,8),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),3)
  call HG1shiftOLR(G1H3(40),4,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(1),ex3(:),G1tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(2),11,ex3(:),4,G2tensor(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(3),11,ex3(:),4,G2tensor(2),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(7),ex3(:),G2tensor(3),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(8),ex3(:),G2tensor(4),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(9),ex3(:),G2tensor(5),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex3(:),G2tensor(6),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(11),ex3(:),G2tensor(7),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(12),ex3(:),G2tensor(8),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(4),11,ex3(:),4,G2tensor(9),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(5),11,ex3(:),4,G2tensor(10),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(6),ex3(:),G1tensor(2),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(7),ex3(:),G1tensor(3),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(2),mass4set(:,9),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(4),G1H3(5),3)
  call HG1shiftOLR(G1H3(2),4,3)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(2),mass4set(:,10),  & 
G1H3(6),G1H3(7),G1H3(44),G1H3(45),G1H3(46),3)
  call HG1shiftOLR(G1H3(7),4,3)
  call Hotf_4pt_reduction(G2H3(15),RedSet_4(2),mass4set(:,11),  & 
G1H3(47),G1H3(48),G1H3(49),G1H3(50),G1H3(51),3)
  call HG1shiftOLR(G1H3(48),4,3)
  call Hotf_4pt_reduction(G2H3(16),RedSet_4(2),mass4set(:,8),  & 
G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
  call HG1shiftOLR(G1H3(53),4,3)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(3),mass4set(:,12),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),3)
  call HG1shiftOLR(G1H3(58),4,3)
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(3),mass4set(:,13),  & 
G1H3(62),G1H3(63),G1H3(64),G1H3(65),G1H3(66),3)
  call HG1shiftOLR(G1H3(63),4,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(3),mass4set(:,5),  & 
G1H3(67),G1H3(68),G1H3(69),G1H3(70),G1H3(71),3)
  call HG1shiftOLR(G1H3(68),4,3)
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(3),mass4set(:,7),  & 
G1H3(72),G1H3(73),G1H3(74),G1H3(75),G1H3(76),3)
  call HG1shiftOLR(G1H3(73),4,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(3),mass4set(:,6),  & 
G1H3(77),G1H3(78),G1H3(79),G1H3(80),G1H3(81),3)
  call HG1shiftOLR(G1H3(78),4,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(3),mass4set(:,8),  & 
G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),3)
  call HG1shiftOLR(G1H3(83),4,3)
  call Hotf_4pt_reduction(G2H3(23),RedSet_4(3),mass4set(:,14),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),3)
  call HG1shiftOLR(G1H3(88),4,3)
  call Hotf_4pt_reduction(G2H3(24),RedSet_4(3),mass4set(:,15),  & 
G1H3(92),G1H3(93),G1H3(94),G1H3(95),G1H3(96),3)
  call HG1shiftOLR(G1H3(93),4,3)
  call Hotf_4pt_reduction(G2H3(25),RedSet_4(3),mass4set(:,16),  & 
G1H3(97),G1H3(98),G1H3(99),G1H3(100),G1H3(101),3)
  call HG1shiftOLR(G1H3(98),4,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(27),ex3(:),G2tensor(11),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(28),ex3(:),G2tensor(12),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(8),ex3(:),G1tensor(4),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(29),ex3(:),G2tensor(13),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(30),ex3(:),G2tensor(14),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(31),ex3(:),G2tensor(15),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(32),ex3(:),G2tensor(16),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(33),ex3(:),G2tensor(17),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(9),11,ex3(:),4,G2tensor(18),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(10),11,ex3(:),4,G2tensor(19),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(11),11,ex3(:),4,G2tensor(20),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hotf_4pt_reduction(G2H3(34),RedSet_4(3),mass4set(:,17),  & 
G1H3(8),G1H3(9),G1H3(10),G1H3(11),G1H3(102),3)
  call HG1shiftOLR(G1H3(9),4,3)
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(12),11,ex3(:),4,G2tensor(21),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hotf_4pt_reduction(G2H3(35),RedSet_4(3),mass4set(:,15),  & 
G1H3(12),G1H3(103),G1H3(104),G1H3(105),G1H3(106),3)
  call HG1shiftOLR(G1H3(103),4,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(36),ex3(:),G2tensor(22),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(37),ex3(:),G2tensor(23),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(13),ex3(:),G1tensor(5),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(14),ex3(:),G1tensor(6),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hotf_4pt_reduction(G2H3(38),RedSet_4(3),mass4set(:,9),  & 
G1H3(13),G1H3(14),G1H3(107),G1H3(108),G1H3(109),3)
  call HG1shiftOLR(G1H3(14),4,3)
  call Hotf_4pt_reduction(G2H3(39),RedSet_4(3),mass4set(:,11),  & 
G1H3(110),G1H3(111),G1H3(112),G1H3(113),G1H3(114),3)
  call HG1shiftOLR(G1H3(111),4,3)
  call Hotf_4pt_reduction(G2H3(40),RedSet_4(3),mass4set(:,10),  & 
G1H3(115),G1H3(116),G1H3(117),G1H3(118),G1H3(119),3)
  call HG1shiftOLR(G1H3(116),4,3)
  call Hotf_4pt_reduction(G2H3(41),RedSet_4(3),mass4set(:,8),  & 
G1H3(120),G1H3(121),G1H3(122),G1H3(123),G1H3(124),3)
  call HG1shiftOLR(G1H3(121),4,3)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(1),mass4set(:,18),  & 
G1H2(4),G1H2(3),G1H2(5),G1H2(6),G1H2(7),2)
  call HG1shiftOLR(G1H2(3),2,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(1),mass4set(:,19),  & 
G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(9),2,2)
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(24),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngPbt,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(25),n2h1(2))
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(1),mass4set(:,20),  & 
G1H2(1),G1H2(2),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(2),2,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(1),mass4set(:,19),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(26),ngH,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(27),ngH,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(28),ngX,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(29),ngX,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(30),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(31),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(32),ngZd,m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(16),ex2(:),G2tensor(33),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hloop_QW_A(ntryL,G1H3(19),ex3(:),G1H1(1),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(34),n2h1(3))
  call Hloop_QW_A(ntryL,G1H3(20),ex3(:),G1H1(1),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(35),n2h1(4))
  call Hloop_QW_A(ntryL,G1H3(23),ex3(:),G1H1(1),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(36),n2h1(5))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(24),11,ex3(:),4,G2tensor(37),m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(25),0,ex3(:),4,G2tensor(38),m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(28),11,ex3(:),4,G2tensor(39),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(29),11,ex3(:),4,G2tensor(40),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(30),0,ex3(:),4,G2tensor(41),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(33),11,ex3(:),4,G2tensor(42),m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(34),11,ex3(:),4,G2tensor(43),m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(35),0,ex3(:),4,G2tensor(44),m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(38),11,ex3(:),4,G2tensor(45),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(39),11,ex3(:),4,G2tensor(46),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(40),0,ex3(:),4,G2tensor(47),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(43),11,ex3(:),4,G2tensor(48),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(1),11,ex3(:),4,G2tensor(49),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(2),0,ex3(:),4,G2tensor(50),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(5),11,ex3(:),4,G2tensor(51),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(6),11,ex3(:),4,G2tensor(52),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(7),0,ex3(:),4,G2tensor(53),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(46),11,ex3(:),4,G2tensor(54),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(47),11,ex3(:),4,G2tensor(55),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(48),0,ex3(:),4,G2tensor(56),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(51),11,ex3(:),4,G2tensor(57),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(52),11,ex3(:),4,G2tensor(58),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(53),0,ex3(:),4,G2tensor(59),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(56),11,ex3(:),4,G2tensor(60),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hloop_AW_Q(ntryL,G1H3(57),ex3(:),G1H1(1),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(61),n2h1(14))
  call Hloop_AW_Q(ntryL,G1H3(58),ex3(:),G1H1(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(62),n2h1(15))
  call Hloop_AW_Q(ntryL,G1H3(61),ex3(:),G1H1(1),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(63),n2h1(16))
  call Hloop_AW_Q(ntryL,G1H3(62),ex3(:),G1H1(1),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(64),n2h1(17))
  call Hloop_AW_Q(ntryL,G1H3(63),ex3(:),G1H1(1),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(65),n2h1(18))
  call Hloop_AW_Q(ntryL,G1H3(66),ex3(:),G1H1(1),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(66),n2h1(19))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(67),11,ex3(:),4,G2tensor(67),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(68),0,ex3(:),4,G2tensor(68),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(71),11,ex3(:),4,G2tensor(69),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(72),11,ex3(:),4,G2tensor(70),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(73),0,ex3(:),4,G2tensor(71),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(76),11,ex3(:),4,G2tensor(72),m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(77),11,ex3(:),4,G2tensor(73),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(78),0,ex3(:),4,G2tensor(74),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(81),11,ex3(:),4,G2tensor(75),m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(82),11,ex3(:),4,G2tensor(76),m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(83),0,ex3(:),4,G2tensor(77),m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(86),11,ex3(:),4,G2tensor(78),m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(87),11,ex3(:),4,G2tensor(79),m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(88),0,ex3(:),4,G2tensor(80),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(91),11,ex3(:),4,G2tensor(81),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(92),11,ex3(:),4,G2tensor(82),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(93),0,ex3(:),4,G2tensor(83),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(96),11,ex3(:),4,G2tensor(84),m3h3x1(:,80),heltab2x3(:,:,80))
  call Hloop_AW_Q(ntryL,G1H3(97),ex3(:),G1H1(1),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(85),n2h1(26))
  call Hloop_AW_Q(ntryL,G1H3(98),ex3(:),G1H1(1),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(86),n2h1(27))
  call Hloop_AW_Q(ntryL,G1H3(101),ex3(:),G1H1(1),m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(87),n2h1(28))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(8),11,ex3(:),4,G2tensor(88),m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(9),0,ex3(:),4,G2tensor(89),m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(102),11,ex3(:),4,G2tensor(90),m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(12),11,ex3(:),4,G2tensor(91),m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(103),0,ex3(:),4,G2tensor(92),m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(106),11,ex3(:),4,G2tensor(93),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(13),11,ex3(:),4,G2tensor(94),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(14),0,ex3(:),4,G2tensor(95),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(109),11,ex3(:),4,G2tensor(96),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(110),11,ex3(:),4,G2tensor(97),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(111),0,ex3(:),4,G2tensor(98),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(114),11,ex3(:),4,G2tensor(99),m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(115),11,ex3(:),4,G2tensor(100),m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(116),0,ex3(:),4,G2tensor(101),m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(119),11,ex3(:),4,G2tensor(102),m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(120),11,ex3(:),4,G2tensor(103),m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(121),0,ex3(:),4,G2tensor(104),m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(124),11,ex3(:),4,G2tensor(105),m3h3x1(:,101),heltab2x3(:,:,101))
  call Hloop_SA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),ngPbt,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(106),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngPbt,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(107),n2h1(36))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngPbt,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(108),n2h1(37))
  call Hloop_SA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),ngPbt,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(109),n2h1(38))
  call Hloop_SA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),ngPbt,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(110),n2h1(39))
  call Hloop_SA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),ngPbt,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(111),n2h1(40))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(112),n2h1(41))
  call Hloop_WA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(113),n2h1(42))
  call Hloop_WA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(114),n2h1(43))
  call Hloop_WA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(115),n2h1(44))
  call Hloop_WA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(116),n2h1(45))
  call Hloop_WA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(117),n2h1(46))
  call ol_merge_tensors(G2tensor(37),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(7),[G2tensor(1)])
  call ol_merge_tensors(G2tensor(55),[G2tensor(2),G1tensor(3)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(4)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(10),G2tensor(5)])
  call ol_merge_tensors(G2tensor(58),[G2tensor(46),G2tensor(6)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(11)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(82),G2tensor(12)])
  call ol_merge_tensors(G2tensor(67),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(14)])
  call ol_merge_tensors(G2tensor(70),[G2tensor(21),G2tensor(15)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(76),G2tensor(16)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(17)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(18)])
  call ol_merge_tensors(G2tensor(97),[G2tensor(19),G1tensor(6)])
  call ol_merge_tensors(G2tensor(73),[G2tensor(23)])
  call ol_merge_tensors(G2tensor(94),[G1tensor(5)])
  call ol_merge_tensors(G2tensor(106),[G2tensor(24)])
  call ol_merge_tensors(G2tensor(112),[G2tensor(25)])
  call ol_merge_tensors(G2tensor(32),[G2tensor(28)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(109)])
  call Hotf_4pt_reduction_last(G2tensor(37),RedSet_4(2),mass4set(:,5),  & 
G1tensor(1),G1tensor(3),G1tensor(2),G1tensor(4),G1tensor(6))
  call G_TensorShift(G1tensor(3),4)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(2),mass4set(:,21),  & 
G1tensor(5),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(55),RedSet_4(2),mass4set(:,11),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,22),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(52),RedSet_4(2),mass4set(:,10),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(43),RedSet_4(2),mass4set(:,7),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(58),RedSet_4(2),mass4set(:,8),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),4)
  call Hotf_4pt_reduction_last(G2tensor(40),RedSet_4(2),mass4set(:,6),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),4)
  call Hotf_4pt_reduction_last(G2tensor(49),RedSet_4(2),mass4set(:,9),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),4)
  call Hotf_4pt_reduction_last(G2tensor(88),RedSet_4(3),mass4set(:,17),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),4)
  call Hotf_4pt_reduction_last(G2tensor(91),RedSet_4(3),mass4set(:,15),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(67),RedSet_4(3),mass4set(:,5),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(3),mass4set(:,22),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_4pt_reduction_last(G2tensor(100),RedSet_4(3),mass4set(:,10),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(70),RedSet_4(3),mass4set(:,7),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(103),RedSet_4(3),mass4set(:,8),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(79),RedSet_4(3),mass4set(:,14),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(22),RedSet_4(3),mass4set(:,21),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(97),RedSet_4(3),mass4set(:,11),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),4)
  call Hotf_4pt_reduction_last(G2tensor(73),RedSet_4(3),mass4set(:,6),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),4)
  call Hotf_4pt_reduction_last(G2tensor(94),RedSet_4(3),mass4set(:,9),  & 
G1tensor(101),G1tensor(102),G1tensor(103),G1tensor(104),G1tensor(105))
  call G_TensorShift(G1tensor(102),4)
  call Hotf_4pt_reduction_last(G2tensor(106),RedSet_4(1),mass4set(:,18),  & 
G1tensor(106),G1tensor(107),G1tensor(108),G1tensor(109),G1tensor(110))
  call G_TensorShift(G1tensor(107),2)
  call Hotf_4pt_reduction_last(G2tensor(112),RedSet_4(1),mass4set(:,20),  & 
G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114),G1tensor(115))
  call G_TensorShift(G1tensor(112),2)
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(1),mass4set(:,1),  & 
G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
  call G_TensorShift(G1tensor(117),2)
  call Hotf_4pt_reduction_last(G2tensor(32),RedSet_4(1),mass4set(:,2),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125))
  call G_TensorShift(G1tensor(122),2)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(1),mass4set(:,3),  & 
G1tensor(126),G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130))
  call G_TensorShift(G1tensor(127),2)
  call Hotf_4pt_reduction_last(G2tensor(34),RedSet_4(2),mass4set(:,4),  & 
G1tensor(131),G1tensor(132),G1tensor(133),G1tensor(134),G1tensor(135))
  call G_TensorShift(G1tensor(132),4)
  call Hotf_4pt_reduction_last(G2tensor(61),RedSet_4(3),mass4set(:,12),  & 
G1tensor(136),G1tensor(137),G1tensor(138),G1tensor(139),G1tensor(140))
  call G_TensorShift(G1tensor(137),4)
  call Hotf_4pt_reduction_last(G2tensor(64),RedSet_4(3),mass4set(:,13),  & 
G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144),G1tensor(145))
  call G_TensorShift(G1tensor(142),4)
  call Hotf_4pt_reduction_last(G2tensor(85),RedSet_4(3),mass4set(:,16),  & 
G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
  call G_TensorShift(G1tensor(147),4)
  call Hotf_4pt_reduction_last(G2tensor(115),RedSet_4(1),mass4set(:,19),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155))
  call G_TensorShift(G1tensor(152),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,5),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(2),mass4set(:,21),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(2),mass4set(:,11),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(2),mass4set(:,22),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(2),mass4set(:,10),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,7),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(2),mass4set(:,8),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(2),mass4set(:,6),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(2),mass4set(:,9),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(3),mass4set(:,17),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(3),mass4set(:,15),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(3),mass4set(:,5),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(3),mass4set(:,22),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(3),mass4set(:,10),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(3),mass4set(:,7),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(3),mass4set(:,8),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,14),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,21),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(3),mass4set(:,11),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(3),mass4set(:,6),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call Hotf_4pt_reduction_last(G1tensor(101),RedSet_4(3),mass4set(:,9),  & 
G0tensor(101),G0tensor(102),G0tensor(103),G0tensor(104),G0tensor(105))
  call Hotf_4pt_reduction_last(G1tensor(106),RedSet_4(1),mass4set(:,18),  & 
G0tensor(106),G0tensor(107),G0tensor(108),G0tensor(109),G0tensor(110))
  call Hotf_4pt_reduction_last(G1tensor(111),RedSet_4(1),mass4set(:,20),  & 
G0tensor(111),G0tensor(112),G0tensor(113),G0tensor(114),G0tensor(115))
  call Hotf_4pt_reduction_last(G1tensor(116),RedSet_4(1),mass4set(:,1),  & 
G0tensor(116),G0tensor(117),G0tensor(118),G0tensor(119),G0tensor(120))
  call Hotf_4pt_reduction_last(G1tensor(121),RedSet_4(1),mass4set(:,2),  & 
G0tensor(121),G0tensor(122),G0tensor(123),G0tensor(124),G0tensor(125))
  call Hotf_4pt_reduction_last(G1tensor(126),RedSet_4(1),mass4set(:,3),  & 
G0tensor(126),G0tensor(127),G0tensor(128),G0tensor(129),G0tensor(130))
  call Hotf_4pt_reduction_last(G1tensor(131),RedSet_4(2),mass4set(:,4),  & 
G0tensor(131),G0tensor(132),G0tensor(133),G0tensor(134),G0tensor(135))
  call Hotf_4pt_reduction_last(G1tensor(136),RedSet_4(3),mass4set(:,12),  & 
G0tensor(136),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140))
  call Hotf_4pt_reduction_last(G1tensor(141),RedSet_4(3),mass4set(:,13),  & 
G0tensor(141),G0tensor(142),G0tensor(143),G0tensor(144),G0tensor(145))
  call Hotf_4pt_reduction_last(G1tensor(146),RedSet_4(3),mass4set(:,16),  & 
G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),G0tensor(150))
  call Hotf_4pt_reduction_last(G1tensor(151),RedSet_4(1),mass4set(:,19),  & 
G0tensor(151),G0tensor(152),G0tensor(153),G0tensor(154),G0tensor(155))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  call ol_merge_tensors(T0sum(21),[G0tensor(101)])
  call ol_merge_tensors(T0sum(22),[G0tensor(106)])
  call ol_merge_tensors(T0sum(23),[G0tensor(111)])
  call ol_merge_tensors(T0sum(24),[G0tensor(116)])
  call ol_merge_tensors(T0sum(25),[G0tensor(121)])
  call ol_merge_tensors(T0sum(26),[G0tensor(126)])
  call ol_merge_tensors(T0sum(27),[G0tensor(131)])
  call ol_merge_tensors(T0sum(28),[G0tensor(136)])
  call ol_merge_tensors(T0sum(29),[G0tensor(141)])
  call ol_merge_tensors(T0sum(30),[G0tensor(146)])
  call ol_merge_tensors(T0sum(31),[G0tensor(151)])
  Gcoeff(:)%j = (c(28)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[12,1,2],[nMH,nMB,nMH],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[12,1,2],[nMZ,nMB,nMZ],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (-(c(25)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[12,1,2],[nMW,nMT,nMW],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(3),m4h3x3x4(:,3),heltab3x36(:,:,3))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[12,1,2],[0,nMB,0],4,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(4),m4h3x3x4(:,4),heltab3x36(:,:,4))
  Gcoeff(:)%j = (c(91)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[12,1,2],[0,nMB,nMZ],4,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(5),m4h3x3x4(:,5),heltab3x36(:,:,5))
  Gcoeff(:)%j = (c(91)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[12,1,2],[nMZ,nMB,0],4,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(6),m4h3x3x4(:,6),heltab3x36(:,:,6))
  Gcoeff(:)%j = (-(c(70)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[12,1,2],[nMZ,nMB,nMZ],4,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(7),m4h3x3x4(:,7),heltab3x36(:,:,7))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[12,1,2],[nMW,nMT,nMW],4,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(8),m4h3x3x4(:,8),heltab3x36(:,:,8))
  Gcoeff(:)%j = (c(122)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[8,3,4],[nME,nME,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,85),heltab2x36(:,:,85))
  call Hloop_A_Q(ntryL,G0H12(32),8,nME,G1H12(25),n2h12(15))
  Gcoeff(:)%j = (c(126)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[8,3,4],[nMM,nMM,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,86),heltab2x36(:,:,86))
  call Hloop_A_Q(ntryL,G0H12(1),8,nMM,G1H12(1),n2h12(16))
  Gcoeff(:)%j = (c(124)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[8,3,4],[nML,nML,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,87),heltab2x36(:,:,87))
  call Hloop_A_Q(ntryL,G0H12(2),8,nML,G1H12(2),n2h12(17))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[8,3,4],[nMT,nMT,nMB],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,88),heltab2x36(:,:,88))
  call Hloop_Q_A(ntryL,G0H12(3),8,nMT,G1H12(3),n2h12(18))
  Gcoeff(:)%j = (c(120)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[8,3,4],[nMB,nMB,nMT],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,89),heltab2x36(:,:,89))
  call Hloop_A_Q(ntryL,G0H12(4),8,nMB,G1H12(4),n2h12(19))
  Gcoeff(:)%j = (-(c(122)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[8,3,4],[nME,nME,0],3,1,wf4(:,11))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,90),heltab2x36(:,:,90))
  call Hloop_A_Q(ntryL,G0H12(5),8,nME,G1H12(5),n2h12(20))
  Gcoeff(:)%j = (-(c(126)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[8,3,4],[nMM,nMM,0],3,1,wf4(:,11))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,91),heltab2x36(:,:,91))
  call Hloop_A_Q(ntryL,G0H12(6),8,nMM,G1H12(6),n2h12(21))
  Gcoeff(:)%j = (-(c(124)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[8,3,4],[nML,nML,0],3,1,wf4(:,11))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,92),heltab2x36(:,:,92))
  call Hloop_A_Q(ntryL,G0H12(7),8,nML,G1H12(7),n2h12(22))
  Gcoeff(:)%j = (c(128)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[8,3,4],[nMT,nMT,nMB],3,1,wf4(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,93),heltab2x36(:,:,93))
  call Hloop_Q_A(ntryL,G0H12(8),8,nMT,G1H12(8),n2h12(23))
  Gcoeff(:)%j = (-(c(120)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[8,3,4],[nMB,nMB,nMT],3,1,wf4(:,11))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,94),heltab2x36(:,:,94))
  call Hloop_A_Q(ntryL,G0H12(9),8,nMB,G1H12(9),n2h12(24))
  Gcoeff(:)%j = (c(33)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[8,3,4],[nMH,nMH,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(10),m3h3x12(:,95),heltab2x36(:,:,95))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(11),m3h3x12(:,96),heltab2x36(:,:,96))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(12),m3h3x12(:,97),heltab2x36(:,:,97))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(13),m3h3x12(:,98),heltab2x36(:,:,98))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(14),m3h3x12(:,99),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(15),m3h3x12(:,100),heltab2x36(:,:,100))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(16),m3h3x12(:,101),heltab2x36(:,:,101))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(17),m3h3x12(:,102),heltab2x36(:,:,102))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(18),m3h3x12(:,103),heltab2x36(:,:,103))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(19),m3h3x12(:,104),heltab2x36(:,:,104))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(20),m3h3x12(:,105),heltab2x36(:,:,105))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(21),m3h3x12(:,106),heltab2x36(:,:,106))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[8,3,4],[nMW,nMW,0],3,1,wf4(:,11))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(22),m3h3x12(:,107),heltab2x36(:,:,107))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,11))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(23),m3h3x12(:,108),heltab2x36(:,:,108))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[8,3,4],[nMW,nMW,0],3,1,wf4(:,11))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(24),m3h3x12(:,109),heltab2x36(:,:,109))
  Gcoeff(:)%j = (c(19)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,11))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(27),m3h3x12(:,110),heltab2x36(:,:,110))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(26),m3h3x12(:,111),heltab2x36(:,:,111))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(28),m3h3x12(:,112),heltab2x36(:,:,112))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(29),m3h3x12(:,113),heltab2x36(:,:,113))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(10),m3h3x12(:,114),heltab2x36(:,:,114))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(11),m3h3x12(:,115),heltab2x36(:,:,115))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,116),heltab2x36(:,:,116))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,11))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(13),m3h3x12(:,117),heltab2x36(:,:,117))
  Gcoeff(:)%j = (-(c(77)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(30),m3h3x12(:,118),heltab2x36(:,:,118))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(31),m3h3x12(:,119),heltab2x36(:,:,119))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,11))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(32),m3h3x12(:,120),heltab2x36(:,:,120))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,11))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(33),m3h3x12(:,121),heltab2x36(:,:,121))
  Gcoeff(:)%j = (c(80)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(14),m3h3x12(:,122),heltab2x36(:,:,122))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(15),m3h3x12(:,123),heltab2x36(:,:,123))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[8,3,4],[nMH,nMH,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(16),m3h3x12(:,124),heltab2x36(:,:,124))
  Gcoeff(:)%j = (c(10)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[8,3,4],[nMZ,nMZ,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(17),m3h3x12(:,125),heltab2x36(:,:,125))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(18),m3h3x12(:,126),heltab2x36(:,:,126))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(34),m3h3x12(:,127),heltab2x36(:,:,127))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(35),m3h3x12(:,128),heltab2x36(:,:,128))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[8,3,4],[nMW,nMW,0],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(36),m3h3x12(:,129),heltab2x36(:,:,129))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(37),m3h3x12(:,130),heltab2x36(:,:,130))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(38),m3h3x12(:,131),heltab2x36(:,:,131))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(140),h0tab(:,140),[8,3,4],[nMW,nMW,0],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(19),m3h3x12(:,132),heltab2x36(:,:,132))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(141),h0tab(:,141),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(20),m3h3x12(:,133),heltab2x36(:,:,133))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(142),h0tab(:,142),[8,3,4],[nMW,nMW,0],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(21),m3h3x12(:,134),heltab2x36(:,:,134))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(143),h0tab(:,143),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(22),m3h3x12(:,135),heltab2x36(:,:,135))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(144),h0tab(:,144),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,11))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(23),m3h3x12(:,136),heltab2x36(:,:,136))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(145),h0tab(:,145),[8,3,4],[nME,nME,0],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(24),m3h3x12(:,137),heltab2x36(:,:,137))
  call Hloop_A_Q(ntryL,G0H12(24),8,nME,G1H12(39),n2h12(25))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(146),h0tab(:,146),[8,3,4],[nMM,nMM,0],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(25),m3h3x12(:,138),heltab2x36(:,:,138))
  call Hloop_A_Q(ntryL,G0H12(25),8,nMM,G1H12(40),n2h12(26))
  Gcoeff(:)%j = (-(c(137)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(147),h0tab(:,147),[8,3,4],[nML,nML,0],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(26),m3h3x12(:,139),heltab2x36(:,:,139))
  call Hloop_A_Q(ntryL,G0H12(26),8,nML,G1H12(41),n2h12(27))
  Gcoeff(:)%j = (c(138)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(148),h0tab(:,148),[8,3,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(27),m3h3x12(:,140),heltab2x36(:,:,140))
  call Hloop_Q_A(ntryL,G0H12(27),8,0,G1H12(42),n2h12(28))
  Gcoeff(:)%j = (c(136)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(149),h0tab(:,149),[8,3,4],[nMT,nMT,nMB],3,1,wf4(:,2))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(28),m3h3x12(:,141),heltab2x36(:,:,141))
  call Hloop_Q_A(ntryL,G0H12(28),8,nMT,G1H12(43),n2h12(29))
  Gcoeff(:)%j = (-(c(136)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(150),h0tab(:,150),[8,3,4],[0,0,0],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,142),heltab2x36(:,:,142))
  call Hloop_A_Q(ntryL,G0H12(29),8,0,G1H12(44),n2h12(30))
  Gcoeff(:)%j = (-(c(135)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(151),h0tab(:,151),[8,3,4],[nMB,nMB,nMT],3,1,wf4(:,2))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(30),m3h3x12(:,143),heltab2x36(:,:,143))
  call Hloop_A_Q(ntryL,G0H12(30),8,nMB,G1H12(45),n2h12(31))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(152),h0tab(:,152),[8,3,4],[0,0,nME],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(31),m3h3x12(:,144),heltab2x36(:,:,144))
  call Hloop_Q_A(ntryL,G0H12(31),8,0,G1H12(46),n2h12(32))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(153),h0tab(:,153),[8,3,4],[0,0,nMM],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,145),heltab2x36(:,:,145))
  call Hloop_Q_A(ntryL,G0H12(32),8,0,G1H12(47),n2h12(33))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(154),h0tab(:,154),[8,3,4],[0,0,nML],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,146),heltab2x36(:,:,146))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(48),n2h12(34))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(155),h0tab(:,155),[8,3,4],[nME,nME,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,147),heltab2x36(:,:,147))
  call Hloop_A_Q(ntryL,G0H12(2),8,nME,G1H12(49),n2h12(35))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(156),h0tab(:,156),[8,3,4],[nMM,nMM,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,148),heltab2x36(:,:,148))
  call Hloop_A_Q(ntryL,G0H12(3),8,nMM,G1H12(50),n2h12(36))
  Gcoeff(:)%j = (-(c(139)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(157),h0tab(:,157),[8,3,4],[nML,nML,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,149),heltab2x36(:,:,149))
  call Hloop_A_Q(ntryL,G0H12(4),8,nML,G1H12(51),n2h12(37))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(158),h0tab(:,158),[8,3,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,150),heltab2x36(:,:,150))
  call Hloop_Q_A(ntryL,G0H12(5),8,0,G1H12(52),n2h12(38))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(159),h0tab(:,159),[8,3,4],[nMT,nMT,nMB],3,1,wf4(:,3))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,151),heltab2x36(:,:,151))
  call Hloop_Q_A(ntryL,G0H12(6),8,nMT,G1H12(53),n2h12(39))
  Gcoeff(:)%j = (-(c(141)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(160),h0tab(:,160),[8,3,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,152),heltab2x36(:,:,152))
  call Hloop_A_Q(ntryL,G0H12(7),8,0,G1H12(54),n2h12(40))
  Gcoeff(:)%j = (-(c(140)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(161),h0tab(:,161),[8,3,4],[nMB,nMB,nMT],3,1,wf4(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,153),heltab2x36(:,:,153))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(55),n2h12(41))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(162),h0tab(:,162),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(56),m3h3x12(:,154),heltab2x36(:,:,154))
  Gcoeff(:)%j = (c(63)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(163),h0tab(:,163),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(57),m3h3x12(:,155),heltab2x36(:,:,155))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(164),h0tab(:,164),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(58),m3h3x12(:,156),heltab2x36(:,:,156))
  Gcoeff(:)%j = (c(48)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(165),h0tab(:,165),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(59),m3h3x12(:,157),heltab2x36(:,:,157))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(166),h0tab(:,166),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(60),m3h3x12(:,158),heltab2x36(:,:,158))
  Gcoeff(:)%j = (c(104)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(167),h0tab(:,167),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(61),m3h3x12(:,159),heltab2x36(:,:,159))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(168),h0tab(:,168),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(62),m3h3x12(:,160),heltab2x36(:,:,160))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(169),h0tab(:,169),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(63),m3h3x12(:,161),heltab2x36(:,:,161))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(170),h0tab(:,170),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(64),m3h3x12(:,162),heltab2x36(:,:,162))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(171),h0tab(:,171),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(65),m3h3x12(:,163),heltab2x36(:,:,163))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(172),h0tab(:,172),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(66),m3h3x12(:,164),heltab2x36(:,:,164))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(173),h0tab(:,173),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(67),m3h3x12(:,165),heltab2x36(:,:,165))
  Gcoeff(:)%j = (-(c(92)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(174),h0tab(:,174),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(68),m3h3x12(:,166),heltab2x36(:,:,166))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(175),h0tab(:,175),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(69),m3h3x12(:,167),heltab2x36(:,:,167))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(176),h0tab(:,176),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(70),m3h3x12(:,168),heltab2x36(:,:,168))
  Gcoeff(:)%j = (-(c(69)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(177),h0tab(:,177),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(71),m3h3x12(:,169),heltab2x36(:,:,169))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(178),h0tab(:,178),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(72),m3h3x12(:,170),heltab2x36(:,:,170))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(179),h0tab(:,179),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(73),m3h3x12(:,171),heltab2x36(:,:,171))
  Gcoeff(:)%j = (c(85)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(180),h0tab(:,180),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,172),heltab2x36(:,:,172))
  Gcoeff(:)%j = (c(95)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(181),h0tab(:,181),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(24),m3h3x12(:,173),heltab2x36(:,:,173))
  Gcoeff(:)%j = (c(96)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(182),h0tab(:,182),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(25),m3h3x12(:,174),heltab2x36(:,:,174))
  Gcoeff(:)%j = (-(c(85)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(183),h0tab(:,183),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(74),m3h3x12(:,175),heltab2x36(:,:,175))
  Gcoeff(:)%j = (-(c(95)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(184),h0tab(:,184),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(75),m3h3x12(:,176),heltab2x36(:,:,176))
  Gcoeff(:)%j = (-(c(96)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(185),h0tab(:,185),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(76),m3h3x12(:,177),heltab2x36(:,:,177))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(186),h0tab(:,186),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(26),m3h3x12(:,178),heltab2x36(:,:,178))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(187),h0tab(:,187),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(27),m3h3x12(:,179),heltab2x36(:,:,179))
  Gcoeff(:)%j = (c(109)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(188),h0tab(:,188),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(28),m3h3x12(:,180),heltab2x36(:,:,180))
  Gcoeff(:)%j = (c(110)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(189),h0tab(:,189),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,181),heltab2x36(:,:,181))
  Gcoeff(:)%j = (c(86)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(190),h0tab(:,190),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(30),m3h3x12(:,182),heltab2x36(:,:,182))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(191),h0tab(:,191),[8,3,4],[nMW,nMW,nMH],3,1,wf4(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(31),m3h3x12(:,183),heltab2x36(:,:,183))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(192),h0tab(:,192),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(77),m3h3x12(:,184),heltab2x36(:,:,184))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(193),h0tab(:,193),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(78),m3h3x12(:,185),heltab2x36(:,:,185))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(194),h0tab(:,194),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(79),m3h3x12(:,186),heltab2x36(:,:,186))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(195),h0tab(:,195),[8,3,4],[nMZ,nMH,nMW],3,1,wf4(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(80),m3h3x12(:,187),heltab2x36(:,:,187))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(196),h0tab(:,196),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(81),m3h3x12(:,188),heltab2x36(:,:,188))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(197),h0tab(:,197),[8,3,4],[nMW,nMW,0],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,189),heltab2x36(:,:,189))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(198),h0tab(:,198),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,190),heltab2x36(:,:,190))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(199),h0tab(:,199),[8,3,4],[nMW,nMW,0],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,191),heltab2x36(:,:,191))
  Gcoeff(:)%j = (-(c(59)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(200),h0tab(:,200),[8,3,4],[nMH,nMZ,nMW],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,192),heltab2x36(:,:,192))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(201),h0tab(:,201),[8,3,4],[nMW,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,193),heltab2x36(:,:,193))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(202),h0tab(:,202),[8,1,6],[nMB,nMH,nMT],3,1,wf6(:,6))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,194),heltab2x36(:,:,194))
  call Hloop_A_Q(ntryL,G0H12(5),8,nMB,G1H12(82),n2h12(42))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(203),h0tab(:,203),[8,1,6],[nMB,nMZ,nMT],3,1,wf6(:,6))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,195),heltab2x36(:,:,195))
  call Hloop_A_Q(ntryL,G0H12(6),8,nMB,G1H12(83),n2h12(43))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(204),h0tab(:,204),[8,1,6],[nMW,nMT,nMH],3,1,wf6(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(84),m3h3x12(:,196),heltab2x36(:,:,196))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(205),h0tab(:,205),[8,1,6],[nMH,nMB,nMW],3,1,wf6(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(85),m3h3x12(:,197),heltab2x36(:,:,197))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(206),h0tab(:,206),[8,1,6],[nMW,nMT,nMZ],3,1,wf6(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(86),m3h3x12(:,198),heltab2x36(:,:,198))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(207),h0tab(:,207),[8,1,6],[nMZ,nMB,nMW],3,1,wf6(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(87),m3h3x12(:,199),heltab2x36(:,:,199))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(208),h0tab(:,208),[8,1,6],[nMB,0,nMT],3,1,wf6(:,6))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,200),heltab2x36(:,:,200))
  call Hloop_A_Q(ntryL,G0H12(7),8,nMB,G1H12(88),n2h12(44))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(209),h0tab(:,209),[8,1,6],[nMB,nMZ,nMT],3,1,wf6(:,6))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,201),heltab2x36(:,:,201))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(89),n2h12(45))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(210),h0tab(:,210),[8,1,6],[nMB,0,nMT],3,1,wf6(:,6))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,202),heltab2x36(:,:,202))
  call Hloop_A_Q(ntryL,G0H12(5),8,nMB,G1H12(90),n2h12(46))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(211),h0tab(:,211),[8,1,6],[nMW,nMT,0],3,1,wf6(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,203),heltab2x36(:,:,203))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(212),h0tab(:,212),[8,1,6],[nMW,nMT,nMZ],3,1,wf6(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,204),heltab2x36(:,:,204))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(213),h0tab(:,213),[8,1,6],[nMH,nMB,nMW],3,1,wf6(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,205),heltab2x36(:,:,205))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(214),h0tab(:,214),[8,1,6],[0,nMB,nMW],3,1,wf6(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,206),heltab2x36(:,:,206))
  Gcoeff(:)%j = (-(c(89)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(215),h0tab(:,215),[8,1,6],[nMZ,nMB,nMW],3,1,wf6(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(33),m3h3x12(:,207),heltab2x36(:,:,207))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(216),h0tab(:,216),[8,1,6],[nMW,nMT,nMH],3,1,wf6(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(34),m3h3x12(:,208),heltab2x36(:,:,208))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(217),h0tab(:,217),[8,1,6],[nMW,nMT,0],3,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(91),m3h3x12(:,209),heltab2x36(:,:,209))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(218),h0tab(:,218),[8,1,6],[0,nMB,nMW],3,1,wf6(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(92),m3h3x12(:,210),heltab2x36(:,:,210))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(219),h0tab(:,219),[8,1,6],[nMW,nMT,nMZ],3,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(93),m3h3x12(:,211),heltab2x36(:,:,211))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(220),h0tab(:,220),[8,1,6],[nMZ,nMB,nMW],3,1,wf6(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(94),m3h3x12(:,212),heltab2x36(:,:,212))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(221),h0tab(:,221),[9,2,4],[nMH,nMB,nMT],3,1,wf6(:,3))
  call Hloop_AQ_S(ntryL,G0H36(1),wf6(:,3),G0H6(1),ngH,m3h6x6(:,1),heltab2x36(:,:,213))
  Gcoeff(:)%j = (-(c(41)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(222),h0tab(:,222),[9,2,4],[nMZ,nMB,nMT],3,1,wf6(:,3))
  call Hloop_AQ_S(ntryL,G0H36(1),wf6(:,3),G0H6(2),ngX,m3h6x6(:,2),heltab2x36(:,:,214))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(223),h0tab(:,223),[9,2,4],[nMT,nMW,nMH],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(3),ngH,m3h6x6(:,3),heltab2x36(:,:,215))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMT,G1H6(4),n2h6(75))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(224),h0tab(:,224),[9,2,4],[nMB,nMH,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(3),ngPbt,m3h6x6(:,4),heltab2x36(:,:,216))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMB,G1H6(5),n2h6(76))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(225),h0tab(:,225),[9,2,4],[nMT,nMW,nMZ],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(3),ngX,m3h6x6(:,5),heltab2x36(:,:,217))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMT,G1H6(8),n2h6(77))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(226),h0tab(:,226),[9,2,4],[nMB,nMZ,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(3),ngPbt,m3h6x6(:,6),heltab2x36(:,:,218))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMB,G1H6(9),n2h6(78))
  Gcoeff(:)%j = (-(c(64)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(227),h0tab(:,227),[9,2,4],[0,nMB,nMT],3,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,3),G0H6(3),m3h6x6(:,7),heltab2x36(:,:,219))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(228),h0tab(:,228),[9,2,4],[nMZ,nMB,nMT],3,1,wf6(:,3))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,3),G0H6(4),ngZu,m3h6x6(:,8),heltab2x36(:,:,220))
  Gcoeff(:)%j = (c(71)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(229),h0tab(:,229),[9,2,4],[0,nMB,nMT],3,1,wf6(:,3))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,3),G0H6(5),m3h6x6(:,9),heltab2x36(:,:,221))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(230),h0tab(:,230),[9,2,4],[nMT,nMW,0],3,1,wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),m3h6x6(:,10),heltab2x36(:,:,222))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(10),n2h6(79))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(231),h0tab(:,231),[9,2,4],[nMT,nMW,nMZ],3,1,wf6(:,3))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),ngZu,m3h6x6(:,11),heltab2x36(:,:,223))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(12),n2h6(80))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(232),h0tab(:,232),[9,2,4],[nMB,nMH,nMW],3,1,wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),m3h6x6(:,12),heltab2x36(:,:,224))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(14),n2h6(81))
  Gcoeff(:)%j = (c(65)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(233),h0tab(:,233),[9,2,4],[nMB,0,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),ngPbt,m3h6x6(:,13),heltab2x36(:,:,225))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(15),n2h6(82))
  Gcoeff(:)%j = (c(89)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(234),h0tab(:,234),[9,2,4],[nMB,nMZ,nMW],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),ngPbt,m3h6x6(:,14),heltab2x36(:,:,226))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(16),n2h6(83))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(235),h0tab(:,235),[9,2,4],[nMT,nMW,nMH],3,1,wf6(:,3))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),ngH,m3h6x6(:,15),heltab2x36(:,:,227))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(17),n2h6(84))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(236),h0tab(:,236),[9,2,4],[nMT,nMW,0],3,1,wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),m3h6x6(:,16),heltab2x36(:,:,228))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(20),n2h6(85))
  Gcoeff(:)%j = (-(c(65)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(237),h0tab(:,237),[9,2,4],[nMB,0,nMW],3,1,wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),m3h6x6(:,17),heltab2x36(:,:,229))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(21),n2h6(86))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(238),h0tab(:,238),[9,2,4],[nMT,nMW,nMZ],3,1,wf6(:,3))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),ngZu,m3h6x6(:,18),heltab2x36(:,:,230))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(22),n2h6(87))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(239),h0tab(:,239),[9,2,4],[nMB,nMZ,nMW],3,1,wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,3),G0H6(6),m3h6x6(:,19),heltab2x36(:,:,231))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(26),n2h6(88))
  Gcoeff(:)%j = (c(29)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(240),h0tab(:,240),[12,1,2],[nMB,nMH,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(9),ngH,m3h9x4(:,1),heltab2x36(:,:,232))
  call Hloop_A_Q(ntryL,G0H4(9),12,nMB,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(241),h0tab(:,241),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(9),ngH,m3h9x4(:,2),heltab2x36(:,:,233))
  call Hloop_A_Q(ntryL,G0H4(9),12,nMB,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(40)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(242),h0tab(:,242),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(9),ngH,m3h9x4(:,3),heltab2x36(:,:,234))
  call Hloop_A_Q(ntryL,G0H4(9),12,nMT,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(243),h0tab(:,243),[12,1,2],[nMH,nMB,nMH],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,4),heltab2x36(:,:,235))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(244),h0tab(:,244),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(10),m3h9x4(:,5),heltab2x36(:,:,236))
  Gcoeff(:)%j = (-(c(30)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(245),h0tab(:,245),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,6),heltab2x36(:,:,237))
  Gcoeff(:)%j = (-(c(72)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(246),h0tab(:,246),[12,1,2],[nMB,0,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(12),ngH,m3h9x4(:,7),heltab2x36(:,:,238))
  call Hloop_A_Q(ntryL,G0H4(12),12,nMB,G1H4(4),n2h4(4))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(247),h0tab(:,247),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(12),ngH,m3h9x4(:,8),heltab2x36(:,:,239))
  call Hloop_A_Q(ntryL,G0H4(12),12,nMB,G1H4(5),n2h4(5))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(248),h0tab(:,248),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(12),ngH,m3h9x4(:,9),heltab2x36(:,:,240))
  call Hloop_A_Q(ntryL,G0H4(12),12,nMT,G1H4(6),n2h4(6))
  Gcoeff(:)%j = (-(c(78)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(249),h0tab(:,249),[12,1,2],[nMB,0,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(12),ngH,m3h9x4(:,10),heltab2x36(:,:,241))
  call Hloop_A_Q(ntryL,G0H4(12),12,nMB,G1H4(7),n2h4(7))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(250),h0tab(:,250),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(8),m3h9x4(:,11),heltab2x36(:,:,242))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(251),h0tab(:,251),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(9),m3h9x4(:,12),heltab2x36(:,:,243))
  Gcoeff(:)%j = (c(53)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(252),h0tab(:,252),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(10),m3h9x4(:,13),heltab2x36(:,:,244))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(253),h0tab(:,253),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(11),m3h9x4(:,14),heltab2x36(:,:,245))
  Gcoeff(:)%j = (-(c(87)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(254),h0tab(:,254),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(12),m3h9x4(:,15),heltab2x36(:,:,246))
  Gcoeff(:)%j = (-(c(43)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(255),h0tab(:,255),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(13),m3h9x4(:,16),heltab2x36(:,:,247))
  Gcoeff(:)%j = (c(83)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(256),h0tab(:,256),[12,1,2],[nMB,nMH,nMB],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,17),heltab2x36(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(12),n2h4(8))
  Gcoeff(:)%j = (-(c(83)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(257),h0tab(:,257),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,18),heltab2x36(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(13),n2h4(9))
  Gcoeff(:)%j = (c(81)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(258),h0tab(:,258),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,19),heltab2x36(:,:,250))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMT,G1H4(14),n2h4(10))
  Gcoeff(:)%j = (-(c(57)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(259),h0tab(:,259),[12,1,2],[nMB,nMH,nMB],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZd,m3h9x4(:,20),heltab2x36(:,:,251))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(15),n2h4(11))
  Gcoeff(:)%j = (c(57)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(260),h0tab(:,260),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZd,m3h9x4(:,21),heltab2x36(:,:,252))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(16),n2h4(12))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(261),h0tab(:,261),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZu,m3h9x4(:,22),heltab2x36(:,:,253))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMT,G1H4(17),n2h4(13))
  Gcoeff(:)%j = (c(82)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(262),h0tab(:,262),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(18),m3h9x4(:,23),heltab2x36(:,:,254))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(263),h0tab(:,263),[12,1,2],[nMH,nMB,nMZ],3,1,wf9(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(19),m3h9x4(:,24),heltab2x36(:,:,255))
  Gcoeff(:)%j = (c(28)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(264),h0tab(:,264),[12,1,2],[nMZ,nMB,nMH],3,1,wf9(:,2))
  call Hloop_TV_S(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(20),m3h9x4(:,25),heltab2x36(:,:,256))
  Gcoeff(:)%j = (-(c(102)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(265),h0tab(:,265),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(21),m3h9x4(:,26),heltab2x36(:,:,257))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(266),h0tab(:,266),[12,1,2],[nMB,0,nMB],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,27),heltab2x36(:,:,258))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(22),n2h4(14))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(267),h0tab(:,267),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,28),heltab2x36(:,:,259))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(23),n2h4(15))
  Gcoeff(:)%j = (c(67)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(268),h0tab(:,268),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,29),heltab2x36(:,:,260))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMT,G1H4(24),n2h4(16))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(269),h0tab(:,269),[12,1,2],[nMB,0,nMB],3,1,wf9(:,2))
  call Hloop_AV_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,30),heltab2x36(:,:,261))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(25),n2h4(17))
  Gcoeff(:)%j = (c(90)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(270),h0tab(:,270),[12,1,2],[nMB,0,nMB],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZd,m3h9x4(:,31),heltab2x36(:,:,262))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(26),n2h4(18))
  Gcoeff(:)%j = (c(92)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(271),h0tab(:,271),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZd,m3h9x4(:,32),heltab2x36(:,:,263))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(27),n2h4(19))
  Gcoeff(:)%j = (c(50)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(272),h0tab(:,272),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZu,m3h9x4(:,33),heltab2x36(:,:,264))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMT,G1H4(28),n2h4(20))
  Gcoeff(:)%j = (c(93)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(273),h0tab(:,273),[12,1,2],[nMB,0,nMB],3,1,wf9(:,2))
  call Hloop_AZ_Q(ntryL,G0H36(1),wf9(:,2),G0H4(14),ngZd,m3h9x4(:,34),heltab2x36(:,:,265))
  call Hloop_A_Q(ntryL,G0H4(14),12,nMB,G1H4(29),n2h4(21))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(274),h0tab(:,274),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(14),m3h9x4(:,35),heltab2x36(:,:,266))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(275),h0tab(:,275),[12,1,2],[nMH,nMB,nMZ],3,1,wf9(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(15),m3h9x4(:,36),heltab2x36(:,:,267))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(276),h0tab(:,276),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,2),G0H4(16),m3h9x4(:,37),heltab2x36(:,:,268))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(277),h0tab(:,277),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(17),m3h9x4(:,38),heltab2x36(:,:,269))
  Gcoeff(:)%j = (-(c(54)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(278),h0tab(:,278),[12,1,2],[nMZ,nMB,nMH],3,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(18),m3h9x4(:,39),heltab2x36(:,:,270))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(279),h0tab(:,279),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_SV_V(ntryL,G0H36(1),wf9(:,2),G0H4(19),m3h9x4(:,40),heltab2x36(:,:,271))
  Gcoeff(:)%j = (c(68)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(280),h0tab(:,280),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(30),m3h9x4(:,41),heltab2x36(:,:,272))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(281),h0tab(:,281),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,2))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,2),12,G1H4(31),m3h9x4(:,42),heltab2x36(:,:,273))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(10),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(21),[G1H4(18),G0H4(11),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(12),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(31),[G1H4(30),G0H4(13),G0H4(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(90),[G1H12(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(5),[G0H6(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(15),[G1H4(12),G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G1H4(13),G1H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G1H4(14),G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(29),[G1H4(26),G1H4(25),G1H4(22),G1H4(7),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(27),[G1H4(23),G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(28),[G1H4(24),G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G0H4(16),G0H4(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G0H4(19),G0H4(17)])
  call Hloop_QW_A(ntryL,G1H6(11),ex3(:),G1H2(4),m3h3x2(:,20),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G1H2(4),13,nMB,G2H2(1),n2h2(13))
  call Hloop_QW_A(ntryL,G1H6(18),ex3(:),G1H2(3),m3h3x2(:,21),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G1H2(3),13,nMB,G2H2(2),n2h2(14))
  call Hloop_QW_A(ntryL,G1H6(27),ex3(:),G1H2(7),m3h3x2(:,22),heltab2x6(:,:,81))
  call Hloop_Q_A(ntryL,G1H2(7),13,nMB,G2H2(3),n2h2(15))
  call Hloop_QW_A(ntryL,G1H6(1),ex3(:),G1H2(8),m3h3x2(:,23),heltab2x6(:,:,82))
  call Hloop_Q_A(ntryL,G1H2(8),13,nMB,G2H2(4),n2h2(16))
  call Hloop_SQ_A(ntryL,G0H4(9),ex1(:),G0H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(9),n2h2(17))
  call Hloop_SQ_A(ntryL,G0H4(10),ex1(:),G0H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(12),n2h2(18))
  call Hloop_SQ_A(ntryL,G1H4(21),ex1(:),G1H2(1),ngPtb,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMT,G2H2(5),n2h2(19))
  call Hloop_VQ_A(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(2),n2h2(20))
  call Hloop_VQ_A(ntryL,G0H4(5),ex1(:),G0H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(15),n2h2(21))
  call Hloop_ZQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),ngZd,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(16),n2h2(22))
  call Hloop_ZQ_A(ntryL,G0H4(12),ex1(:),G0H2(1),ngZd,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(17),n2h2(23))
  call Hloop_WQ_A(ntryL,G1H4(31),ex1(:),G1H2(20),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_Q_A(ntryL,G1H2(20),13,nMT,G2H2(7),n2h2(24))
  call Hloop_AS_Q(ntryL,G1H12(25),wf4(:,1),G1H3(19),ngH,m3h4x3(:,1),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H3(19),11,nME,G2H3(1),n2h3(7))
  call Hloop_AS_Q(ntryL,G1H12(1),wf4(:,1),G1H3(20),ngH,m3h4x3(:,2),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H3(20),11,nMM,G2H3(18),n2h3(8))
  call Hloop_AS_Q(ntryL,G1H12(2),wf4(:,1),G1H3(23),ngH,m3h4x3(:,3),heltab2x12(:,:,86))
  call Hloop_A_Q(ntryL,G1H3(23),11,nML,G2H3(6),n2h3(9))
  call Hloop_QS_A(ntryL,G1H12(3),wf4(:,1),G1H3(24),ngH,m3h4x3(:,4),heltab2x12(:,:,87))
  call Hloop_Q_A(ntryL,G1H3(24),11,nMT,G2H3(2),n2h3(10))
  call Hloop_AS_Q(ntryL,G1H12(4),wf4(:,1),G1H3(25),ngH,m3h4x3(:,5),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H3(25),11,nMB,G2H3(3),n2h3(11))
  call Hloop_AS_Q(ntryL,G1H12(5),wf4(:,11),G1H3(28),ngX,m3h4x3(:,6),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H3(28),11,nME,G2H3(4),n2h3(12))
  call Hloop_AS_Q(ntryL,G1H12(6),wf4(:,11),G1H3(29),ngX,m3h4x3(:,7),heltab2x12(:,:,90))
  call Hloop_A_Q(ntryL,G1H3(29),11,nMM,G2H3(5),n2h3(13))
  call Hloop_AS_Q(ntryL,G1H12(7),wf4(:,11),G1H3(30),ngX,m3h4x3(:,8),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H3(30),11,nML,G2H3(7),n2h3(14))
  call Hloop_QS_A(ntryL,G1H12(8),wf4(:,11),G1H3(33),ngX,m3h4x3(:,9),heltab2x12(:,:,92))
  call Hloop_Q_A(ntryL,G1H3(33),11,nMT,G2H3(8),n2h3(15))
  call Hloop_AS_Q(ntryL,G1H12(9),wf4(:,11),G1H3(34),ngX,m3h4x3(:,10),heltab2x12(:,:,93))
  call Hloop_A_Q(ntryL,G1H3(34),11,nMB,G2H3(9),n2h3(16))
  call Hloop_SS_S(ntryL,G1H12(10),wf4(:,1),G1H3(35),m3h4x3(:,11),heltab2x12(:,:,94))
  call Hloop_SS_S(ntryL,G1H12(11),wf4(:,1),G1H3(38),m3h4x3(:,12),heltab2x12(:,:,95))
  call Hloop_SS_S(ntryL,G1H12(12),wf4(:,1),G1H3(39),m3h4x3(:,13),heltab2x12(:,:,96))
  call Hloop_SS_S(ntryL,G1H12(13),wf4(:,1),G1H3(40),m3h4x3(:,14),heltab2x12(:,:,97))
  call Hloop_SS_S(ntryL,G1H12(14),wf4(:,11),G1H3(43),m3h4x3(:,15),heltab2x12(:,:,98))
  call Hloop_SS_S(ntryL,G1H12(15),wf4(:,11),G1H3(1),m3h4x3(:,16),heltab2x12(:,:,99))
  call Hloop_SS_S(ntryL,G1H12(16),wf4(:,1),G1H3(2),m3h4x3(:,17),heltab2x12(:,:,100))
  call Hloop_SS_S(ntryL,G1H12(17),wf4(:,1),G1H3(5),m3h4x3(:,18),heltab2x12(:,:,101))
  call Hloop_SS_S(ntryL,G1H12(18),wf4(:,1),G1H3(6),m3h4x3(:,19),heltab2x12(:,:,102))
  call Hloop_SS_S(ntryL,G1H12(19),wf4(:,1),G1H3(7),m3h4x3(:,20),heltab2x12(:,:,103))
  call Hloop_SS_S(ntryL,G1H12(20),wf4(:,1),G1H3(46),m3h4x3(:,21),heltab2x12(:,:,104))
  call Hloop_SS_S(ntryL,G1H12(21),wf4(:,1),G1H3(47),m3h4x3(:,22),heltab2x12(:,:,105))
  call Hloop_SS_S(ntryL,G1H12(22),wf4(:,11),G1H3(48),m3h4x3(:,23),heltab2x12(:,:,106))
  call Hloop_SS_S(ntryL,G1H12(23),wf4(:,11),G1H3(51),m3h4x3(:,24),heltab2x12(:,:,107))
  call Hloop_SS_S(ntryL,G1H12(24),wf4(:,11),G1H3(52),m3h4x3(:,25),heltab2x12(:,:,108))
  call Hloop_SS_S(ntryL,G1H12(27),wf4(:,11),G1H3(53),m3h4x3(:,26),heltab2x12(:,:,109))
  call Hloop_VS_V(ntryL,G1H12(26),wf4(:,1),G1H3(56),m3h4x3(:,27),heltab2x12(:,:,110))
  call Hloop_VS_V(ntryL,G1H12(28),wf4(:,1),G1H3(57),m3h4x3(:,28),heltab2x12(:,:,111))
  call Hloop_VS_V(ntryL,G1H12(29),wf4(:,1),G1H3(58),m3h4x3(:,29),heltab2x12(:,:,112))
  call Hloop_VT_S(ntryL,G0H12(10),8,wf4(:,1),3,G1H3(61),m3h4x3(:,30),heltab2x12(:,:,113))
  call Hloop_VT_S(ntryL,G0H12(11),8,wf4(:,1),3,G1H3(62),m3h4x3(:,31),heltab2x12(:,:,114))
  call Hloop_VS_T(ntryL,G0H12(12),8,wf4(:,11),3,G1H3(63),m3h4x3(:,32),heltab2x12(:,:,115))
  call Hloop_VT_S(ntryL,G0H12(13),8,wf4(:,11),3,G1H3(66),m3h4x3(:,33),heltab2x12(:,:,116))
  call Hloop_ST_V(ntryL,G1H12(30),8,wf4(:,1),3,G2H3(10),m3h4x3(:,34),heltab2x12(:,:,117))
  call Hloop_ST_V(ntryL,G1H12(31),8,wf4(:,1),3,G2H3(11),m3h4x3(:,35),heltab2x12(:,:,118))
  call Hloop_TS_V(ntryL,G1H12(32),8,wf4(:,11),3,G2H3(12),m3h4x3(:,36),heltab2x12(:,:,119))
  call Hloop_ST_V(ntryL,G1H12(33),8,wf4(:,11),3,G2H3(13),m3h4x3(:,37),heltab2x12(:,:,120))
  call Hloop_SS_S(ntryL,G0H12(14),wf4(:,1),G0H3(1),m3h4x3(:,38),heltab2x12(:,:,121))
  call Hloop_SS_S(ntryL,G0H12(15),wf4(:,1),G0H3(2),m3h4x3(:,39),heltab2x12(:,:,122))
  call Hloop_SS_S(ntryL,G0H12(16),wf4(:,1),G0H3(3),m3h4x3(:,40),heltab2x12(:,:,123))
  call Hloop_VS_V(ntryL,G0H12(17),wf4(:,1),G0H3(4),m3h4x3(:,41),heltab2x12(:,:,124))
  call Hloop_VS_V(ntryL,G0H12(18),wf4(:,1),G0H3(5),m3h4x3(:,42),heltab2x12(:,:,125))
  call Hloop_VT_S(ntryL,G1H12(34),8,wf4(:,1),3,G2H3(14),m3h4x3(:,43),heltab2x12(:,:,126))
  call Hloop_VT_S(ntryL,G1H12(35),8,wf4(:,1),3,G2H3(15),m3h4x3(:,44),heltab2x12(:,:,127))
  call Hloop_VT_S(ntryL,G1H12(36),8,wf4(:,11),3,G2H3(16),m3h4x3(:,45),heltab2x12(:,:,128))
  call Hloop_VS_T(ntryL,G1H12(37),8,wf4(:,11),3,G2H3(17),m3h4x3(:,46),heltab2x12(:,:,129))
  call Hloop_VT_S(ntryL,G1H12(38),8,wf4(:,11),3,G2H3(26),m3h4x3(:,47),heltab2x12(:,:,130))
  call Hloop_ST_V(ntryL,G0H12(19),8,wf4(:,1),3,G1H3(67),m3h4x3(:,48),heltab2x12(:,:,131))
  call Hloop_ST_V(ntryL,G0H12(20),8,wf4(:,1),3,G1H3(68),m3h4x3(:,49),heltab2x12(:,:,132))
  call Hloop_ST_V(ntryL,G0H12(21),8,wf4(:,11),3,G1H3(71),m3h4x3(:,50),heltab2x12(:,:,133))
  call Hloop_TS_V(ntryL,G0H12(22),8,wf4(:,11),3,G1H3(72),m3h4x3(:,51),heltab2x12(:,:,134))
  call Hloop_ST_V(ntryL,G0H12(23),8,wf4(:,11),3,G1H3(73),m3h4x3(:,52),heltab2x12(:,:,135))
  call Hloop_AV_Q(ntryL,G1H12(39),wf4(:,2),G1H3(76),m3h4x3(:,53),heltab2x12(:,:,136))
  call Hloop_A_Q(ntryL,G1H3(76),11,nME,G2H3(19),n2h3(17))
  call Hloop_AV_Q(ntryL,G1H12(40),wf4(:,2),G1H3(77),m3h4x3(:,54),heltab2x12(:,:,137))
  call Hloop_A_Q(ntryL,G1H3(77),11,nMM,G2H3(20),n2h3(18))
  call Hloop_AV_Q(ntryL,G1H12(41),wf4(:,2),G1H3(78),m3h4x3(:,55),heltab2x12(:,:,138))
  call Hloop_A_Q(ntryL,G1H3(78),11,nML,G2H3(21),n2h3(19))
  call Hloop_QV_A(ntryL,G1H12(42),wf4(:,2),G1H3(81),m3h4x3(:,56),heltab2x12(:,:,139))
  call Hloop_Q_A(ntryL,G1H3(81),11,0,G2H3(22),n2h3(20))
  call Hloop_QV_A(ntryL,G1H12(43),wf4(:,2),G1H3(82),m3h4x3(:,57),heltab2x12(:,:,140))
  call Hloop_Q_A(ntryL,G1H3(82),11,nMT,G2H3(23),n2h3(21))
  call Hloop_AV_Q(ntryL,G1H12(44),wf4(:,2),G1H3(83),m3h4x3(:,58),heltab2x12(:,:,141))
  call Hloop_A_Q(ntryL,G1H3(83),11,0,G2H3(24),n2h3(22))
  call Hloop_AV_Q(ntryL,G1H12(45),wf4(:,2),G1H3(86),m3h4x3(:,59),heltab2x12(:,:,142))
  call Hloop_A_Q(ntryL,G1H3(86),11,nMB,G2H3(25),n2h3(23))
  call Hloop_QZ_A(ntryL,G1H12(46),wf4(:,3),G1H3(87),ngZn,m3h4x3(:,60),heltab2x12(:,:,143))
  call Hloop_Q_A(ntryL,G1H3(87),11,0,G2H3(27),n2h3(24))
  call Hloop_QZ_A(ntryL,G1H12(47),wf4(:,3),G1H3(88),ngZn,m3h4x3(:,61),heltab2x12(:,:,144))
  call Hloop_Q_A(ntryL,G1H3(88),11,0,G2H3(28),n2h3(25))
  call Hloop_QZ_A(ntryL,G1H12(48),wf4(:,3),G1H3(91),ngZn,m3h4x3(:,62),heltab2x12(:,:,145))
  call Hloop_Q_A(ntryL,G1H3(91),11,0,G2H3(29),n2h3(26))
  call Hloop_AZ_Q(ntryL,G1H12(49),wf4(:,3),G1H3(92),ngZl,m3h4x3(:,63),heltab2x12(:,:,146))
  call Hloop_A_Q(ntryL,G1H3(92),11,nME,G2H3(30),n2h3(27))
  call Hloop_AZ_Q(ntryL,G1H12(50),wf4(:,3),G1H3(93),ngZl,m3h4x3(:,64),heltab2x12(:,:,147))
  call Hloop_A_Q(ntryL,G1H3(93),11,nMM,G2H3(31),n2h3(28))
  call Hloop_AZ_Q(ntryL,G1H12(51),wf4(:,3),G1H3(96),ngZl,m3h4x3(:,65),heltab2x12(:,:,148))
  call Hloop_A_Q(ntryL,G1H3(96),11,nML,G2H3(32),n2h3(29))
  call Hloop_QZ_A(ntryL,G1H12(52),wf4(:,3),G1H3(97),ngZu,m3h4x3(:,66),heltab2x12(:,:,149))
  call Hloop_Q_A(ntryL,G1H3(97),11,0,G2H3(33),n2h3(30))
  call Hloop_QZ_A(ntryL,G1H12(53),wf4(:,3),G1H3(98),ngZu,m3h4x3(:,67),heltab2x12(:,:,150))
  call Hloop_Q_A(ntryL,G1H3(98),11,nMT,G2H3(34),n2h3(31))
  call Hloop_AZ_Q(ntryL,G1H12(54),wf4(:,3),G1H3(101),ngZd,m3h4x3(:,68),heltab2x12(:,:,151))
  call Hloop_A_Q(ntryL,G1H3(101),11,0,G2H3(35),n2h3(32))
  call Hloop_AZ_Q(ntryL,G1H12(55),wf4(:,3),G1H3(8),ngZd,m3h4x3(:,69),heltab2x12(:,:,152))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMB,G2H3(36),n2h3(33))
  call Hloop_SV_T(ntryL,G1H12(56),8,wf4(:,2),3,G2H3(37),m3h4x3(:,70),heltab2x12(:,:,153))
  call Hloop_SV_T(ntryL,G1H12(57),8,wf4(:,2),3,G2H3(38),m3h4x3(:,71),heltab2x12(:,:,154))
  call Hloop_SV_T(ntryL,G1H12(58),8,wf4(:,3),3,G2H3(39),m3h4x3(:,72),heltab2x12(:,:,155))
  call Hloop_TV_S(ntryL,G1H12(59),8,wf4(:,3),3,G2H3(40),m3h4x3(:,73),heltab2x12(:,:,156))
  call Hloop_SV_T(ntryL,G1H12(60),8,wf4(:,3),3,G2H3(41),m3h4x3(:,74),heltab2x12(:,:,157))
  call Hloop_SV_T(ntryL,G1H12(61),8,wf4(:,3),3,G2H3(42),m3h4x3(:,75),heltab2x12(:,:,158))
  call Hloop_DV_C(ntryL,G1H12(62),8,wf4(:,2),G2H3(43),m3h4x3(:,76),heltab2x12(:,:,159))
  call Hloop_DV_C(ntryL,G1H12(63),8,wf4(:,2),G2H3(44),m3h4x3(:,77),heltab2x12(:,:,160))
  call Hloop_CV_D(ntryL,G1H12(64),8,wf4(:,2),3,G2H3(45),m3h4x3(:,78),heltab2x12(:,:,161))
  call Hloop_CV_D(ntryL,G1H12(65),8,wf4(:,2),3,G2H3(46),m3h4x3(:,79),heltab2x12(:,:,162))
  call Hloop_DV_C(ntryL,G1H12(66),8,wf4(:,3),G2H3(47),m3h4x3(:,80),heltab2x12(:,:,163))
  call Hloop_DV_C(ntryL,G1H12(67),8,wf4(:,3),G2H3(48),m3h4x3(:,81),heltab2x12(:,:,164))
  call Hloop_CV_D(ntryL,G1H12(68),8,wf4(:,3),3,G2H3(49),m3h4x3(:,82),heltab2x12(:,:,165))
  call Hloop_CV_D(ntryL,G1H12(69),8,wf4(:,3),3,G2H3(50),m3h4x3(:,83),heltab2x12(:,:,166))
  call Hloop_UW_V(ntryL,G1H12(70),8,wf4(:,2),3,G2H3(51),m3h4x3(:,84),heltab2x12(:,:,167))
  call Hloop_UW_V(ntryL,G1H12(71),8,wf4(:,2),3,G2H3(52),m3h4x3(:,85),heltab2x12(:,:,168))
  call Hloop_UW_V(ntryL,G1H12(72),8,wf4(:,3),3,G2H3(53),m3h4x3(:,86),heltab2x12(:,:,169))
  call Hloop_UW_V(ntryL,G1H12(73),8,wf4(:,3),3,G2H3(54),m3h4x3(:,87),heltab2x12(:,:,170))
  call Hloop_VV_S(ntryL,G0H12(9),wf4(:,2),G0H3(6),m3h4x3(:,88),heltab2x12(:,:,171))
  call Hloop_VV_S(ntryL,G0H12(24),wf4(:,3),G0H3(7),m3h4x3(:,89),heltab2x12(:,:,172))
  call Hloop_VV_S(ntryL,G0H12(25),wf4(:,3),G0H3(8),m3h4x3(:,90),heltab2x12(:,:,173))
  call Hloop_SV_V(ntryL,G1H12(74),wf4(:,2),G1H3(9),m3h4x3(:,91),heltab2x12(:,:,174))
  call Hloop_SV_V(ntryL,G1H12(75),wf4(:,3),G1H3(102),m3h4x3(:,92),heltab2x12(:,:,175))
  call Hloop_SV_V(ntryL,G1H12(76),wf4(:,3),G1H3(12),m3h4x3(:,93),heltab2x12(:,:,176))
  call Hloop_SV_T(ntryL,G0H12(26),8,wf4(:,2),3,G1H3(103),m3h4x3(:,94),heltab2x12(:,:,177))
  call Hloop_SV_T(ntryL,G0H12(27),8,wf4(:,2),3,G1H3(106),m3h4x3(:,95),heltab2x12(:,:,178))
  call Hloop_SV_T(ntryL,G0H12(28),8,wf4(:,3),3,G1H3(13),m3h4x3(:,96),heltab2x12(:,:,179))
  call Hloop_SV_T(ntryL,G0H12(29),8,wf4(:,3),3,G1H3(14),m3h4x3(:,97),heltab2x12(:,:,180))
  call Hloop_UW_V(ntryL,G0H12(30),8,wf4(:,2),3,G1H3(109),m3h4x3(:,98),heltab2x12(:,:,181))
  call Hloop_UW_V(ntryL,G0H12(31),8,wf4(:,3),3,G1H3(110),m3h4x3(:,99),heltab2x12(:,:,182))
  call Hloop_VV_S(ntryL,G1H12(77),wf4(:,2),G1H3(111),m3h4x3(:,100),heltab2x12(:,:,183))
  call Hloop_VV_S(ntryL,G1H12(78),wf4(:,2),G1H3(114),m3h4x3(:,101),heltab2x12(:,:,184))
  call Hloop_VV_S(ntryL,G1H12(79),wf4(:,3),G1H3(115),m3h4x3(:,102),heltab2x12(:,:,185))
  call Hloop_VV_S(ntryL,G1H12(80),wf4(:,3),G1H3(116),m3h4x3(:,103),heltab2x12(:,:,186))
  call Hloop_VV_S(ntryL,G1H12(81),wf4(:,3),G1H3(119),m3h4x3(:,104),heltab2x12(:,:,187))
  call Hloop_SV_V(ntryL,G0H12(32),wf4(:,2),G0H3(9),m3h4x3(:,105),heltab2x12(:,:,188))
  call Hloop_SV_V(ntryL,G0H12(1),wf4(:,2),G0H3(10),m3h4x3(:,106),heltab2x12(:,:,189))
  call Hloop_SV_V(ntryL,G0H12(2),wf4(:,3),G0H3(11),m3h4x3(:,107),heltab2x12(:,:,190))
  call Hloop_SV_V(ntryL,G0H12(3),wf4(:,3),G0H3(12),m3h4x3(:,108),heltab2x12(:,:,191))
  call Hloop_SV_V(ntryL,G0H12(4),wf4(:,3),G0H3(13),m3h4x3(:,109),heltab2x12(:,:,192))
  call Hloop_AQ_S(ntryL,G1H12(82),ex1(:),G1H6(28),ngH,m3h2x6(:,84),heltab2x12(:,:,193))
  call Hloop_AQ_S(ntryL,G1H12(83),ex1(:),G1H6(30),ngX,m3h2x6(:,85),heltab2x12(:,:,194))
  call Hloop_SQ_A(ntryL,G1H12(84),ex1(:),G1H6(31),ngPtb,m3h2x6(:,86),heltab2x12(:,:,195))
  call Hloop_Q_A(ntryL,G1H6(31),9,nMT,G2H6(1),n2h6(89))
  call Hloop_SQ_A(ntryL,G1H12(85),ex1(:),G1H6(35),ngH,m3h2x6(:,87),heltab2x12(:,:,196))
  call Hloop_Q_A(ntryL,G1H6(35),9,nMB,G2H6(2),n2h6(90))
  call Hloop_SQ_A(ntryL,G1H12(86),ex1(:),G1H6(36),ngPtb,m3h2x6(:,88),heltab2x12(:,:,197))
  call Hloop_Q_A(ntryL,G1H6(36),9,nMT,G2H6(3),n2h6(91))
  call Hloop_SQ_A(ntryL,G1H12(87),ex1(:),G1H6(40),ngX,m3h2x6(:,89),heltab2x12(:,:,198))
  call Hloop_Q_A(ntryL,G1H6(40),9,nMB,G2H6(4),n2h6(92))
  call Hloop_AQ_V(ntryL,G1H12(90),ex1(:),G1H6(41),m3h2x6(:,90),heltab2x12(:,:,199))
  call Hloop_AQ_Z(ntryL,G1H12(89),ex1(:),G1H6(42),ngZd,m3h2x6(:,91),heltab2x12(:,:,200))
  call Hloop_SQ_A(ntryL,G0H12(6),ex1(:),G0H6(6),ngPtb,m3h2x6(:,92),heltab2x12(:,:,201))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMT,G1H6(43),n2h6(93))
  call Hloop_SQ_A(ntryL,G0H12(7),ex1(:),G0H6(3),ngPtb,m3h2x6(:,93),heltab2x12(:,:,202))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMT,G1H6(44),n2h6(94))
  call Hloop_SQ_A(ntryL,G0H12(8),ex1(:),G0H6(6),ngH,m3h2x6(:,94),heltab2x12(:,:,203))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(6),n2h6(95))
  call Hloop_VQ_A(ntryL,G0H12(5),ex1(:),G0H6(3),m3h2x6(:,95),heltab2x12(:,:,204))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMB,G1H6(7),n2h6(96))
  call Hloop_ZQ_A(ntryL,G0H12(33),ex1(:),G0H6(6),ngZd,m3h2x6(:,96),heltab2x12(:,:,205))
  call Hloop_Q_A(ntryL,G0H6(6),9,nMB,G1H6(13),n2h6(97))
  call Hloop_WQ_A(ntryL,G0H12(34),ex1(:),G0H6(3),m3h2x6(:,97),heltab2x12(:,:,206))
  call Hloop_Q_A(ntryL,G0H6(3),9,nMT,G1H6(23),n2h6(98))
  call Hloop_WQ_A(ntryL,G1H12(91),ex1(:),G1H6(24),m3h2x6(:,98),heltab2x12(:,:,207))
  call Hloop_Q_A(ntryL,G1H6(24),9,nMT,G2H6(5),n2h6(99))
  call Hloop_VQ_A(ntryL,G1H12(92),ex1(:),G1H6(25),m3h2x6(:,99),heltab2x12(:,:,208))
  call Hloop_Q_A(ntryL,G1H6(25),9,nMB,G2H6(6),n2h6(100))
  call Hloop_WQ_A(ntryL,G1H12(93),ex1(:),G1H6(19),m3h2x6(:,100),heltab2x12(:,:,209))
  call Hloop_Q_A(ntryL,G1H6(19),9,nMT,G2H6(7),n2h6(101))
  call Hloop_ZQ_A(ntryL,G1H12(94),ex1(:),G1H6(32),ngZd,m3h2x6(:,101),heltab2x12(:,:,210))
  call Hloop_Q_A(ntryL,G1H6(32),9,nMB,G2H6(8),n2h6(102))
  call Hloop_SA_Q(ntryL,G0H6(1),ex2(:),G0H3(14),ngH,m3h2x3(:,60),heltab2x6(:,:,83))
  call Hloop_A_Q(ntryL,G0H3(14),11,nMB,G1H3(120),n2h3(34))
  call Hloop_SA_Q(ntryL,G0H6(2),ex2(:),G0H3(14),ngX,m3h2x3(:,61),heltab2x6(:,:,84))
  call Hloop_A_Q(ntryL,G0H3(14),11,nMB,G1H3(121),n2h3(35))
  call Hloop_QA_S(ntryL,G1H6(4),ex2(:),G1H3(124),ngPbt,m3h2x3(:,62),heltab2x6(:,:,85))
  call Hloop_QA_S(ntryL,G1H6(5),ex2(:),G1H3(19),ngH,m3h2x3(:,63),heltab2x6(:,:,86))
  call Hloop_QA_S(ntryL,G1H6(8),ex2(:),G1H3(20),ngPbt,m3h2x3(:,64),heltab2x6(:,:,87))
  call Hloop_QA_S(ntryL,G1H6(9),ex2(:),G1H3(23),ngX,m3h2x3(:,65),heltab2x6(:,:,88))
  call Hloop_VA_Q(ntryL,G0H6(5),ex2(:),G0H3(14),m3h2x3(:,66),heltab2x6(:,:,89))
  call Hloop_A_Q(ntryL,G0H3(14),11,nMB,G1H3(24),n2h3(36))
  call Hloop_ZA_Q(ntryL,G0H6(4),ex2(:),G0H3(14),ngZd,m3h2x3(:,67),heltab2x6(:,:,90))
  call Hloop_A_Q(ntryL,G0H3(14),11,nMB,G1H3(25),n2h3(37))
  call Hloop_QA_S(ntryL,G1H6(10),ex2(:),G1H3(28),ngPbt,m3h2x3(:,68),heltab2x6(:,:,91))
  call Hloop_QA_S(ntryL,G1H6(12),ex2(:),G1H3(29),ngPbt,m3h2x3(:,69),heltab2x6(:,:,92))
  call Hloop_QA_S(ntryL,G1H6(14),ex2(:),G1H3(30),ngH,m3h2x3(:,70),heltab2x6(:,:,93))
  call Hloop_QA_V(ntryL,G1H6(15),ex2(:),G1H3(33),m3h2x3(:,71),heltab2x6(:,:,94))
  call Hloop_QA_Z(ntryL,G1H6(16),ex2(:),G1H3(34),ngZd,m3h2x3(:,72),heltab2x6(:,:,95))
  call Hloop_QA_W(ntryL,G1H6(17),ex2(:),G1H3(76),m3h2x3(:,73),heltab2x6(:,:,96))
  call Hloop_QA_W(ntryL,G1H6(20),ex2(:),G1H3(77),m3h2x3(:,74),heltab2x6(:,:,97))
  call Hloop_QA_V(ntryL,G1H6(21),ex2(:),G1H3(78),m3h2x3(:,75),heltab2x6(:,:,98))
  call Hloop_QA_W(ntryL,G1H6(22),ex2(:),G1H3(81),m3h2x3(:,76),heltab2x6(:,:,99))
  call Hloop_QA_Z(ntryL,G1H6(26),ex2(:),G1H3(82),ngZd,m3h2x3(:,77),heltab2x6(:,:,100))
  call Hloop_AQ_S(ntryL,G1H4(15),ex1(:),G1H2(4),ngH,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_S(ntryL,G1H4(16),ex1(:),G1H2(3),ngX,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_AQ_S(ntryL,G1H4(17),ex1(:),G1H2(7),ngPtb,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_AQ_V(ntryL,G1H4(29),ex1(:),G1H2(8),m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_AQ_Z(ntryL,G1H4(27),ex1(:),G1H2(1),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_W(ntryL,G1H4(28),ex1(:),G1H2(20),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_SQ_A(ntryL,G1H4(8),ex1(:),G1H2(21),ngX,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMB,G2H2(8),n2h2(25))
  call Hloop_SQ_A(ntryL,G1H4(9),ex1(:),G1H2(21),ngPtb,m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMT,G2H2(10),n2h2(26))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex1(:),G1H2(21),ngZd,m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMB,G2H2(11),n2h2(27))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(21),m3h2x2(:,18),heltab2x4(:,:,18))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMT,G2H2(13),n2h2(28))
  call Hloop_SQ_A(ntryL,G1H4(19),ex1(:),G1H2(21),ngH,m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMB,G2H2(14),n2h2(29))
  call Hloop_SQ_A(ntryL,G1H4(20),ex1(:),G1H2(21),ngX,m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_Q_A(ntryL,G1H2(21),13,nMB,G2H2(16),n2h2(30))
  call Hloop_SQ_A(ntryL,G0H4(15),ex1(:),G0H2(1),ngH,m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(21),n2h2(31))
  call Hloop_ZQ_A(ntryL,G0H4(18),ex1(:),G0H2(1),ngZd,m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(22),n2h2(32))
call ol_merge_last(G1H3(17), G1H3(17)) 
call ol_merge_last(G1H3(18), G1H3(18)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(17),G1H3(16),G1H3(15)])
call HGT_OLR(G1H3(18),1,1,3)
call HGT_invQ_OLR(G1H3(18),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(34),[G2H3(23),G2H3(8),G2H3(2),G1H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(31),[G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(35),[G1H3(70),G1H3(27)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(39),[G1H3(63),G1H3(43),G1H3(80),G1H3(32),G0H3(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(41),[G1H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(40),[G1H3(1),G1H3(75),G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(61),[G1H3(38),G1H3(85),G1H3(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(44),[G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(108),[G1H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(118),[G1H3(45)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(54),[G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(113),[G1H3(50)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(123),G1H3(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(120),[G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(36),[G2H3(25),G2H3(9),G2H3(3),G1H3(100),G1H3(65) &
    ,G1H3(60)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(25),[G1H3(121),G1H3(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(19),[G1H3(79),G1H3(69)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(23),[G1H3(84),G1H3(74)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(124),[G1H3(89)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(41),[G2H3(37),G1H3(66),G1H3(62),G1H3(39),G1H3(90),G0H3(8) &
    ,G0H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(20),[G1H3(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(38),G1H3(40),G1H3(95)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(24),[G1H3(99)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(77),[G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G2H3(51),G1H3(71),G1H3(67),G1H3(57),G1H3(11) &
    ,G0H3(11),G0H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(81),[G1H3(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G2H3(52),G1H3(73),G1H3(68),G1H3(58),G1H3(105) &
    ,G0H3(13),G0H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(78),[G1H3(117),G1H3(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(82),[G1H3(122),G1H3(112)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(11),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(19),[G1H2(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(11),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(13),[G2H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(17)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(10),[G2H2(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(30),[G2H3(19),G2H3(4),G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(31),[G2H3(20),G2H3(5),G2H3(18)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(32),[G2H3(21),G2H3(7),G2H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G2H3(43),G1H3(48),G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(44),G1H3(51),G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G2H3(45),G1H3(52),G1H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G2H3(46),G1H3(53),G1H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(10),[G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(13),[G2H3(11),G1H3(110),G1H3(109),G1H3(12),G1H3(9) &
    ,G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(12),[G1H3(102)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(16),[G2H3(14),G1H3(115),G1H3(111),G1H3(13),G1H3(103) &
    ,G0H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(26),[G2H3(15),G1H3(119),G1H3(114),G1H3(14),G1H3(106) &
    ,G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(17),[G1H3(116)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(72),[G0H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(33),[G2H3(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(35),[G2H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(1),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(44)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(16),[G1H2(22)])
  call Hloop_QW_A(ntryL,G1H3(18),ex3(:),G1H1(1),m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(47))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(2),ngH,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(3),ngX,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(4),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(10),ngZd,m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_QW_A(ntryL,G2H3(34),ex3(:),G2H1(1),m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(1),n2h1(48))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(31),11,ex3(:),4,G2tensor(5),m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(35),11,ex3(:),4,G2tensor(46),m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(39),11,ex3(:),4,G3tensor(2),m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(41),11,ex3(:),4,G2tensor(6),m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(40),11,ex3(:),4,G3tensor(3),m3h3x1(:,108),heltab2x3(:,:,108))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(61),11,ex3(:),4,G2tensor(8),m3h3x1(:,109),heltab2x3(:,:,109))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(44),11,ex3(:),4,G2tensor(11),m3h3x1(:,110),heltab2x3(:,:,110))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(108),11,ex3(:),4,G2tensor(82),m3h3x1(:,111),heltab2x3(:,:,111))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(118),11,ex3(:),4,G2tensor(12),m3h3x1(:,112),heltab2x3(:,:,112))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(54),11,ex3(:),4,G2tensor(13),m3h3x1(:,113),heltab2x3(:,:,113))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(113),11,ex3(:),4,G2tensor(14),m3h3x1(:,114),heltab2x3(:,:,114))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(56),11,ex3(:),4,G2tensor(21),m3h3x1(:,115),heltab2x3(:,:,115))
  call Hloop_AW_Q(ntryL,G1H3(120),ex3(:),G1H1(1),m3h3x1(:,116),heltab2x3(:,:,116))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(15),n2h1(49))
  call Hloop_AW_Q(ntryL,G2H3(36),ex3(:),G2H1(1),m3h3x1(:,117),heltab2x3(:,:,117))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(4),n2h1(50))
  call Hloop_AW_Q(ntryL,G1H3(25),ex3(:),G1H1(1),m3h3x1(:,118),heltab2x3(:,:,118))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(76),n2h1(51))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(19),11,ex3(:),4,G2tensor(16),m3h3x1(:,119),heltab2x3(:,:,119))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(23),11,ex3(:),4,G2tensor(17),m3h3x1(:,120),heltab2x3(:,:,120))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(124),11,ex3(:),4,G2tensor(18),m3h3x1(:,121),heltab2x3(:,:,121))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(41),11,ex3(:),4,G3tensor(5),m3h3x1(:,122),heltab2x3(:,:,122))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(20),11,ex3(:),4,G2tensor(19),m3h3x1(:,123),heltab2x3(:,:,123))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(42),11,ex3(:),4,G3tensor(6),m3h3x1(:,124),heltab2x3(:,:,124))
  call Hloop_AW_Q(ntryL,G1H3(24),ex3(:),G1H1(1),m3h3x1(:,125),heltab2x3(:,:,125))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(23),n2h1(52))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(77),11,ex3(:),4,G2tensor(24),m3h3x1(:,126),heltab2x3(:,:,126))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(53),11,ex3(:),4,G3tensor(7),m3h3x1(:,127),heltab2x3(:,:,127))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(81),11,ex3(:),4,G2tensor(25),m3h3x1(:,128),heltab2x3(:,:,128))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(54),11,ex3(:),4,G3tensor(8),m3h3x1(:,129),heltab2x3(:,:,129))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(78),11,ex3(:),4,G2tensor(28),m3h3x1(:,130),heltab2x3(:,:,130))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(82),11,ex3(:),4,G2tensor(109),m3h3x1(:,131),heltab2x3(:,:,131))
  call Hloop_SA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngPbt,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(37),n2h1(53))
  call Hloop_SA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),ngPbt,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(7),n2h1(54))
  call Hloop_SA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),ngPbt,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(55),n2h1(55))
  call Hloop_WA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(9),n2h1(56))
  call Hloop_WA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(52),n2h1(57))
  call Hloop_WA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(43),n2h1(58))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(58),ngH,m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(40),ngX,m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(49),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(88),ngZd,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(9),ex2(:),G1tensor(1),ngH,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(91),ngX,m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(67),ngPbt,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H2(2),ex2(:),G1tensor(5),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(15),ex2(:),G1tensor(11),ngZd,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H2(16),ex2(:),G1tensor(16),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(20),ngZd,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(100),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hloop_AW_Q(ntryL,G2H3(30),ex3(:),G2H1(1),m3h3x1(:,132),heltab2x3(:,:,132))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(9),n2h1(59))
  call Hloop_AW_Q(ntryL,G2H3(31),ex3(:),G2H1(1),m3h3x1(:,133),heltab2x3(:,:,133))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(10),n2h1(60))
  call Hloop_AW_Q(ntryL,G2H3(32),ex3(:),G2H1(1),m3h3x1(:,134),heltab2x3(:,:,134))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(11),n2h1(61))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H3(2),11,ex3(:),4,G2tensor(70),m3h3x1(:,135),heltab2x3(:,:,135))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(47),11,ex3(:),G3tensor(12),m3h3x1(:,136),heltab2x3(:,:,136))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(48),11,ex3(:),G3tensor(13),m3h3x1(:,137),heltab2x3(:,:,137))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H3(7),11,ex3(:),G2tensor(103),m3h3x1(:,138),heltab2x3(:,:,138))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(49),11,ex3(:),4,G3tensor(14),m3h3x1(:,139),heltab2x3(:,:,139))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(50),11,ex3(:),4,G3tensor(15),m3h3x1(:,140),heltab2x3(:,:,140))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(10),ex3(:),G2tensor(79),m3h3x1(:,141),heltab2x3(:,:,141))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(13),ex3(:),G2tensor(22),m3h3x1(:,142),heltab2x3(:,:,142))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(12),ex3(:),G2tensor(97),m3h3x1(:,143),heltab2x3(:,:,143))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(16),ex3(:),G2tensor(73),m3h3x1(:,144),heltab2x3(:,:,144))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(26),ex3(:),G2tensor(94),m3h3x1(:,145),heltab2x3(:,:,145))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(3),ex3(:),G0tensor(1),m3h3x1(:,146),heltab2x3(:,:,146))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(17),ex3(:),G2tensor(106),m3h3x1(:,147),heltab2x3(:,:,147))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(72),11,ex3(:),4,G2tensor(112),m3h3x1(:,148),heltab2x3(:,:,148))
  call Hloop_QW_A(ntryL,G2H3(33),ex3(:),G2H1(1),m3h3x1(:,149),heltab2x3(:,:,149))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(16),n2h1(62))
  call Hloop_AW_Q(ntryL,G2H3(35),ex3(:),G2H1(1),m3h3x1(:,150),heltab2x3(:,:,150))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(17),n2h1(63))
  call Hloop_QW_A(ntryL,G2H3(27),ex3(:),G2H1(1),m3h3x1(:,151),heltab2x3(:,:,151))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nME,G3tensor(18),n2h1(64))
  call Hloop_QW_A(ntryL,G2H3(28),ex3(:),G2H1(1),m3h3x1(:,152),heltab2x3(:,:,152))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(19),n2h1(65))
  call Hloop_QW_A(ntryL,G2H3(29),ex3(:),G2H1(1),m3h3x1(:,153),heltab2x3(:,:,153))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nML,G3tensor(20),n2h1(66))
  call Hloop_SA_Q(ntryL,G1H6(28),wf6(:,6),G1H1(1),ngH,m3h6x1(:,1),heltab2x6(:,:,101))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(26),n2h1(67))
  call Hloop_SA_Q(ntryL,G1H6(30),wf6(:,6),G1H1(1),ngX,m3h6x1(:,2),heltab2x6(:,:,102))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(32),n2h1(68))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(1),wf6(:,6),G2tensor(30),ngH,m3h6x1(:,3),heltab2x6(:,:,103))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(2),wf6(:,6),G2tensor(34),ngPtb,m3h6x1(:,4),heltab2x6(:,:,104))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(3),wf6(:,6),G2tensor(61),ngX,m3h6x1(:,5),heltab2x6(:,:,105))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(4),wf6(:,6),G2tensor(64),ngPtb,m3h6x1(:,6),heltab2x6(:,:,106))
  call Hloop_VA_Q(ntryL,G1H6(41),wf6(:,6),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,107))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(85),n2h1(69))
  call Hloop_ZA_Q(ntryL,G1H6(42),wf6(:,6),G1H1(1),ngZu,m3h6x1(:,8),heltab2x6(:,:,108))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(115),n2h1(70))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(5),wf6(:,6),G2tensor(118),m3h6x1(:,9),heltab2x6(:,:,109))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(7),wf6(:,6),G2tensor(119),ngZu,m3h6x1(:,10),heltab2x6(:,:,110))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(6),wf6(:,6),G1tensor(21),m3h6x1(:,11),heltab2x6(:,:,111))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H6(7),wf6(:,6),G1tensor(26),ngPtb,m3h6x1(:,12),heltab2x6(:,:,112))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(6),wf6(:,6),G2tensor(120),m3h6x1(:,13),heltab2x6(:,:,113))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(8),wf6(:,6),G2tensor(121),m3h6x1(:,14),heltab2x6(:,:,114))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(28),ex3(:),G1tensor(31),m3h3x1(:,154),heltab2x3(:,:,154))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(29),ex3(:),G1tensor(36),m3h3x1(:,155),heltab2x3(:,:,155))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(30),ex3(:),G1tensor(41),m3h3x1(:,156),heltab2x3(:,:,156))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(33),ex3(:),G1tensor(46),m3h3x1(:,157),heltab2x3(:,:,157))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(34),ex3(:),G1tensor(51),m3h3x1(:,158),heltab2x3(:,:,158))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(76),ex3(:),G1tensor(56),m3h3x1(:,159),heltab2x3(:,:,159))
  call Hloop_SA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),ngH,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(122),n2h1(71))
  call Hloop_SA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngX,m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(123),n2h1(72))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngPbt,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(124),n2h1(73))
  call Hloop_VA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(125),n2h1(74))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(126),n2h1(75))
  call Hloop_WA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,50),heltab2x2(:,:,50))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(127),n2h1(76))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(128),ngX,m3h2x1(:,51),heltab2x2(:,:,51))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(16),ex2(:),G2tensor(129),ngH,m3h2x1(:,52),heltab2x2(:,:,52))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(21),ex2(:),G1tensor(61),ngZd,m3h2x1(:,53),heltab2x2(:,:,53))
  call ol_merge_tensors(G2tensor(30),[G2tensor(81),G2tensor(27),G1tensor(120),G1tensor(85),G0tensor(120),G0tensor(85)])
  call ol_merge_tensors(G2tensor(119),[G2tensor(61),G2tensor(93),G2tensor(84),G2tensor(33),G2tensor(29),G1tensor(125),G1tensor(55) &
    ,G0tensor(125),G0tensor(55)])
  call ol_merge_tensors(G2tensor(118),[G2tensor(90),G2tensor(31),G1tensor(130),G1tensor(50),G0tensor(130),G0tensor(50)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(132),G0tensor(132)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(135),G0tensor(135)])
  call ol_merge_tensors(G2tensor(38),[G1tensor(3),G0tensor(2)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(39),G1tensor(30),G1tensor(20),G1tensor(6),G0tensor(30),G0tensor(20),G0tensor(5)])
  call ol_merge_tensors(G2tensor(41),[G1tensor(37),G0tensor(37)])
  call ol_merge_tensors(G2tensor(60),[G2tensor(54),G2tensor(48),G2tensor(42),G1tensor(40),G1tensor(35),G1tensor(25),G0tensor(40) &
    ,G0tensor(35),G0tensor(25)])
  call ol_merge_tensors(G2tensor(44),[G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(47),G1tensor(32),G0tensor(32)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(42),G0tensor(42)])
  call ol_merge_tensors(G2tensor(57),[G2tensor(51),G1tensor(45),G1tensor(15),G1tensor(10),G0tensor(45),G0tensor(15) &
    ,G0tensor(10)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(122),[G2tensor(62),G1tensor(137),G0tensor(137)])
  call ol_merge_tensors(G2tensor(26),[G2tensor(108),G2tensor(63),G1tensor(140),G1tensor(110),G0tensor(140),G0tensor(110)])
  call ol_merge_tensors(G2tensor(126),[G2tensor(123),G2tensor(65),G1tensor(142),G0tensor(142)])
  call ol_merge_tensors(G2tensor(115),[G2tensor(32),G2tensor(117),G2tensor(111),G2tensor(66),G1tensor(155),G1tensor(145) &
    ,G0tensor(155),G0tensor(145)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(1),G1tensor(57),G0tensor(57)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(72),G2tensor(69),G1tensor(21),G1tensor(75),G1tensor(65),G1tensor(60),G0tensor(75) &
    ,G0tensor(65),G0tensor(60)])
  call ol_merge_tensors(G2tensor(128),[G2tensor(71),G1tensor(61),G1tensor(72),G0tensor(72)])
  call ol_merge_tensors(G2tensor(129),[G2tensor(74),G1tensor(97),G0tensor(97)])
  call ol_merge_tensors(G2tensor(121),[G2tensor(64),G2tensor(105),G2tensor(102),G2tensor(78),G2tensor(75),G1tensor(100) &
    ,G1tensor(80),G1tensor(70),G0tensor(100),G0tensor(80),G0tensor(70)])
  call ol_merge_tensors(G2tensor(20),[G2tensor(91),G2tensor(104),G2tensor(77),G1tensor(77),G0tensor(77)])
  call ol_merge_tensors(G2tensor(100),[G2tensor(67),G2tensor(92),G2tensor(89),G2tensor(83),G2tensor(80),G1tensor(82),G1tensor(52) &
    ,G1tensor(47),G0tensor(82),G0tensor(52),G0tensor(47)])
  call ol_merge_tensors(G2tensor(125),[G2tensor(86),G1tensor(147),G0tensor(147)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(114),G2tensor(87),G1tensor(150),G1tensor(115),G0tensor(150),G0tensor(115)])
  call ol_merge_tensors(G2tensor(95),[G1tensor(5),G1tensor(102),G0tensor(102)])
  call ol_merge_tensors(G2tensor(120),[G2tensor(99),G2tensor(96),G1tensor(26),G1tensor(105),G1tensor(95),G1tensor(90) &
    ,G0tensor(105),G0tensor(95),G0tensor(90)])
  call ol_merge_tensors(G2tensor(98),[G1tensor(11),G1tensor(92),G0tensor(92)])
  call ol_merge_tensors(G2tensor(101),[G1tensor(16),G1tensor(67),G0tensor(67)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(107),G1tensor(107),G1tensor(38),G1tensor(8),G1tensor(2),G0tensor(107),G0tensor(38) &
    ,G0tensor(8),G0tensor(3)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(6),G2tensor(116),G2tensor(110),G1tensor(152),G1tensor(33),G1tensor(28),G1tensor(13) &
    ,G0tensor(152),G0tensor(33),G0tensor(28),G0tensor(13)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(113),G1tensor(112),G1tensor(43),G1tensor(23),G1tensor(18),G0tensor(112) &
    ,G0tensor(43),G0tensor(23),G0tensor(18)])
  call ol_merge_tensors(G2tensor(46),[G1tensor(59),G1tensor(4),G0tensor(1),G0tensor(59),G0tensor(4)])
  call ol_merge_tensors(G1tensor(7),[G0tensor(7)])
  call ol_merge_tensors(G1tensor(89),[G1tensor(9),G0tensor(89),G0tensor(9)])
  call ol_merge_tensors(G2tensor(14),[G1tensor(94),G1tensor(14),G0tensor(94),G0tensor(14)])
  call ol_merge_tensors(G1tensor(17),[G0tensor(17)])
  call ol_merge_tensors(G1tensor(64),[G1tensor(19),G0tensor(64),G0tensor(19)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(69),G1tensor(24),G0tensor(69),G0tensor(24)])
  call ol_merge_tensors(G3tensor(3),[G2tensor(112),G2tensor(97),G1tensor(74),G1tensor(29),G0tensor(74),G0tensor(29)])
  call ol_merge_tensors(G2tensor(79),[G2tensor(103),G2tensor(70),G2tensor(21),G2tensor(8),G1tensor(79),G1tensor(34),G0tensor(79) &
    ,G0tensor(34)])
  call ol_merge_tensors(G3tensor(2),[G2tensor(106),G1tensor(99),G1tensor(39),G0tensor(99),G0tensor(39)])
  call ol_merge_tensors(G2tensor(82),[G1tensor(104),G1tensor(44),G0tensor(104),G0tensor(44)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(31),G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(12),G3tensor(7),G2tensor(73),G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(19),G1tensor(36),G1tensor(53),G0tensor(53)])
  call ol_merge_tensors(G3tensor(15),[G3tensor(13),G3tensor(8),G3tensor(6),G2tensor(94),G1tensor(54),G0tensor(54)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(41),G1tensor(98),G1tensor(88),G1tensor(58),G0tensor(98),G0tensor(88) &
    ,G0tensor(58)])
  call ol_merge_tensors(G1tensor(62),[G0tensor(62)])
  call ol_merge_tensors(G2tensor(28),[G1tensor(46),G1tensor(103),G1tensor(68),G1tensor(63),G0tensor(103),G0tensor(68) &
    ,G0tensor(63)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(17),G1tensor(51),G1tensor(93),G1tensor(78),G1tensor(73),G0tensor(93),G0tensor(78) &
    ,G0tensor(73)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(56),G1tensor(83),G0tensor(83)])
  call ol_merge_tensors(G3tensor(5),[G2tensor(22),G1tensor(84),G0tensor(84)])
  call ol_merge_tensors(G1tensor(87),[G0tensor(87)])
  call ol_merge_tensors(G2tensor(37),[G1tensor(108),G0tensor(108)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(7),G1tensor(154),G1tensor(114),G1tensor(109),G0tensor(154),G0tensor(114) &
    ,G0tensor(109)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(113),G0tensor(113)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(133),G1tensor(127),G1tensor(122),G1tensor(117),G0tensor(133),G0tensor(127) &
    ,G0tensor(122),G0tensor(117)])
  call ol_merge_tensors(G2tensor(58),[G1tensor(118),G0tensor(118)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(119),G0tensor(119)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(40),G1tensor(123),G0tensor(123)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(3),G1tensor(124),G0tensor(124)])
  call ol_merge_tensors(G2tensor(49),[G1tensor(128),G0tensor(128)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(129),G0tensor(129)])
  call ol_merge_tensors(G3tensor(1),[G1tensor(134),G0tensor(134)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(138),G0tensor(138)])
  call ol_merge_tensors(G3tensor(4),[G1tensor(149),G1tensor(144),G1tensor(139),G0tensor(149),G0tensor(144),G0tensor(139)])
  call ol_merge_tensors(G2tensor(76),[G1tensor(143),G0tensor(143)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(148),G0tensor(148)])
  call ol_merge_tensors(G2tensor(43),[G2tensor(55),G1tensor(153),G0tensor(153)])
  call ol_merge_tensors(G3tensor(17),[G3tensor(16)])
  call ol_merge_tensors(G2tensor(127),[G2tensor(124)])
  call TI_triangle_red(G2tensor(30),RedBasis(1),mass3set(:,1),G0tensor(6),G0tensor(11),G0tensor(16), &
    G0tensor(21),M2L1R1,[nMH,nMW,nMT],G0tensor(26),G0tensor(31),G0tensor(36))
  call TI_triangle_red(G2tensor(119),RedBasis(1),mass3set(:,2),G0tensor(41),G0tensor(46),G0tensor(51), &
    G0tensor(56),M2L1R1,[nMZ,nMW,nMT],G0tensor(61),G0tensor(66),G0tensor(71))
  call TI_triangle_red(G2tensor(118),RedBasis(1),mass3set(:,3),G0tensor(76),G0tensor(81),G0tensor(86), &
    G0tensor(91),M2L1R1,[nMW,nMT],G0tensor(96),G0tensor(101))
  call TI_triangle_red(G2tensor(35),RedBasis(8),mass3set(:,4),G0tensor(106),G0tensor(111),G0tensor(116), &
    G0tensor(121),M2L1R1,[nMT,nMW],G0tensor(126),G0tensor(131))
  call TI_triangle_red(G2tensor(36),RedBasis(4),mass3set(:,5),G0tensor(136),G0tensor(141),G0tensor(146), &
    G0tensor(151),M2L1R1,[nMB,nMT,nMW],G0tensor(120),G0tensor(85),G0tensor(125))
  call TI_triangle_red(G2tensor(38),RedBasis(8),mass3set(:,6),G0tensor(55),G0tensor(130),G0tensor(50), &
    G0tensor(132),M2L1R1,[nMH,nMB],G0tensor(135),G0tensor(2))
  call TI_triangle_red(G2tensor(45),RedBasis(4),mass3set(:,7),G0tensor(30),G0tensor(20),G0tensor(5), &
    G0tensor(37),M2L1R1,[nMW,nMH,nMB],G0tensor(40),G0tensor(35),G0tensor(25))
  call TI_triangle_red(G2tensor(41),RedBasis(8),mass3set(:,8),G0tensor(27),G0tensor(32),G0tensor(42), &
    G0tensor(45),M2L1R1,[nMH,nMZ,nMB],G0tensor(15),G0tensor(10),G0tensor(22))
  call TI_triangle_red(G2tensor(60),RedBasis(4),mass3set(:,9),G0tensor(12),G0tensor(137),G0tensor(140), &
    G0tensor(110),M2L1R1,[nMW,nMZ,nMB],G0tensor(142),G0tensor(155),G0tensor(145))
  call TI_triangle_red(G2tensor(44),RedBasis(8),mass3set(:,10),G0tensor(57),G0tensor(75),G0tensor(65), &
    G0tensor(60),M2L1R1,[nMZ,nMH,nMB],G0tensor(72),G0tensor(97),G0tensor(100))
  call TI_triangle_red(G2tensor(59),RedBasis(8),mass3set(:,11),G0tensor(80),G0tensor(70),G0tensor(77), &
    G0tensor(82),M2L1R1,[nMZ,nMB],G0tensor(52),G0tensor(47))
  call TI_triangle_red(G2tensor(50),RedBasis(8),mass3set(:,12),G0tensor(147),G0tensor(150),G0tensor(115), &
    G0tensor(102),M2L1R1,[nMB],G0tensor(105))
  call TI_triangle_red(G2tensor(57),RedBasis(4),mass3set(:,13),G0tensor(95),G0tensor(90),G0tensor(92), &
    G0tensor(67),M2L1R1,[nMW,nMB],G0tensor(107),G0tensor(38))
  call TI_triangle_red(G2tensor(53),RedBasis(8),mass3set(:,14),G0tensor(8),G0tensor(3),G0tensor(152), &
    G0tensor(33),M2L1R1,[nMZ,nMB],G0tensor(28),G0tensor(13))
  call TI_triangle_red(G2tensor(56),RedBasis(8),mass3set(:,15),G0tensor(112),G0tensor(43),G0tensor(23), &
    G0tensor(18),M2L1R1,[nMZ,nMB],G0tensor(1),G0tensor(59))
  call TI_triangle_red(G2tensor(122),RedBasis(9),mass3set(:,16),G0tensor(4),G0tensor(7),G0tensor(89),G0tensor(9),M2L1R1,[nMB,nMH], &
    G0tensor(94),G0tensor(14))
  call TI_triangle_red(G2tensor(26),RedBasis(1),mass3set(:,17),G0tensor(17),G0tensor(64),G0tensor(19), &
    G0tensor(69),M2L1R1,[nMT,nMB,nMH],G0tensor(24),G0tensor(74),G0tensor(29))
  call TI_triangle_red(G2tensor(126),RedBasis(9),mass3set(:,18),G0tensor(79),G0tensor(34),G0tensor(99), &
    G0tensor(39),M2L1R1,[nMB,nMZ],G0tensor(104),G0tensor(44))
  call TI_triangle_red(G2tensor(115),RedBasis(1),mass3set(:,19),G0tensor(48),G0tensor(49),G0tensor(53), &
    G0tensor(54),M2L1R1,[nMT,nMB,nMZ],G0tensor(98),G0tensor(88),G0tensor(58))
  call TI_triangle_red(G2tensor(68),RedBasis(9),mass3set(:,6),G0tensor(62),G0tensor(103),G0tensor(68), &
    G0tensor(63),M2L1R1,[nMH,nMB],G0tensor(93),G0tensor(78))
  call TI_triangle_red(G2tensor(34),RedBasis(1),mass3set(:,7),G0tensor(73),G0tensor(83),G0tensor(84), &
    G0tensor(87),M2L1R1,[nMW,nMH,nMB],G0tensor(108),G0tensor(154),G0tensor(114))
  call TI_triangle_red(G2tensor(128),RedBasis(9),mass3set(:,10),G0tensor(109),G0tensor(113),G0tensor(133), &
    G0tensor(127),M2L1R1,[nMZ,nMH,nMB],G0tensor(122),G0tensor(117),G0tensor(118))
  call TI_triangle_red(G2tensor(129),RedBasis(9),mass3set(:,8),G0tensor(119),G0tensor(123),G0tensor(124), &
    G0tensor(128),M2L1R1,[nMH,nMZ,nMB],G0tensor(129),G0tensor(134),G0tensor(138))
  call TI_triangle_red(G2tensor(121),RedBasis(1),mass3set(:,9),G0tensor(149),G0tensor(144),G0tensor(139), &
    G0tensor(143),M2L1R1,[nMW,nMZ,nMB],G0tensor(148),G0tensor(153),G0tensor(156))
  call TI_triangle_red(G2tensor(20),RedBasis(9),mass3set(:,11),G0tensor(157),G0tensor(158),G0tensor(159), &
    G0tensor(160),M2L1R1,[nMZ,nMB],G0tensor(161),G0tensor(162))
  call TI_triangle_red(G2tensor(100),RedBasis(9),mass3set(:,20),G0tensor(163),G0tensor(164),G0tensor(165), &
    G0tensor(166),M2L1R1,[nMW,nMT],G0tensor(167),G0tensor(168))
  call TI_triangle_red(G2tensor(125),RedBasis(9),mass3set(:,21),G0tensor(169),G0tensor(170),G0tensor(171), &
    G0tensor(172),M2L1R1,[nMB],G0tensor(173))
  call TI_triangle_red(G2tensor(85),RedBasis(1),mass3set(:,22),G0tensor(174),G0tensor(175),G0tensor(176), &
    G0tensor(177),M2L1R1,[nMT,nMB],G0tensor(178),G0tensor(179))
  call TI_triangle_red(G2tensor(95),RedBasis(9),mass3set(:,12),G0tensor(180),G0tensor(181),G0tensor(182), &
    G0tensor(183),M2L1R1,[nMB],G0tensor(184))
  call TI_triangle_red(G2tensor(120),RedBasis(1),mass3set(:,13),G0tensor(185),G0tensor(186),G0tensor(187), &
    G0tensor(188),M2L1R1,[nMW,nMB],G0tensor(189),G0tensor(190))
  call TI_triangle_red(G2tensor(98),RedBasis(9),mass3set(:,15),G0tensor(191),G0tensor(192),G0tensor(193), &
    G0tensor(194),M2L1R1,[nMZ,nMB],G0tensor(195),G0tensor(196))
  call TI_triangle_red(G2tensor(101),RedBasis(9),mass3set(:,14),G0tensor(197),G0tensor(198),G0tensor(199), &
    G0tensor(200),M2L1R1,[nMZ,nMB],G0tensor(201),G0tensor(202))
  call TI_triangle_red(G2tensor(5),RedBasis(6),mass3set(:,23),G0tensor(203),G0tensor(204),G0tensor(205), &
    G0tensor(206),M2L1R1,[nMW,nMB,nMH],G0tensor(207),G0tensor(208),G0tensor(209))
  call TI_triangle_red(G2tensor(13),RedBasis(6),mass3set(:,24),G0tensor(210),G0tensor(211),G0tensor(212), &
    G0tensor(213),M2L1R1,[nMW,nMB,nMZ],G0tensor(214),G0tensor(215),G0tensor(216))
  call TI_triangle_red(G2tensor(11),RedBasis(6),mass3set(:,25),G0tensor(217),G0tensor(218),G0tensor(219), &
    G0tensor(220),M2L1R1,[nMW,nMB],G0tensor(221),G0tensor(222))
  call TI_triangle_red(G2tensor(46),RedBasis(5),mass3set(:,26),G0tensor(223),G0tensor(224),G0tensor(225), &
    G0tensor(226),M2L1R1,[nMW,nMH],G0tensor(227),G0tensor(228))
  call TI_triangle_red(G2tensor(14),RedBasis(5),mass3set(:,27),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nMW,nMZ],G0tensor(233),G0tensor(234))
  call TI_triangle_red(G2tensor(12),RedBasis(5),mass3set(:,28),G0tensor(235),G0tensor(236),G0tensor(237), &
    G0tensor(238),M2L1R1,[nMW,nMZ],G0tensor(239),G0tensor(240))
  call TI_triangle_red(G3tensor(3),RedBasis(5),mass3set(:,29),G0tensor(241),G0tensor(242),G0tensor(243), &
    G0tensor(244),M2L1R1,[nMW,nMH,nMZ],G0tensor(245),G0tensor(246),G0tensor(247))
  call TI_triangle_red(G2tensor(79),RedBasis(5),mass3set(:,30),G0tensor(248),G0tensor(249),G0tensor(250), &
    G0tensor(251),M2L1R1,[nMW,nMZ],G0tensor(252),G0tensor(253))
  call TI_triangle_red(G3tensor(2),RedBasis(5),mass3set(:,31),G0tensor(254),G0tensor(255),G0tensor(256), &
    G0tensor(257),M2L1R1,[nMW,nMZ,nMH],G0tensor(258),G0tensor(259),G0tensor(260))



end subroutine vamp_1

end module ol_vamp_1_ppvv_ew_bbxwwx_1_/**/REALKIND
