
module ol_vamp_1_ppvv_ew_uxdzwx_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvv_ew_uxdzwx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvv_ew_uxdzwx_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvv_ew_uxdzwx_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvv_ew_uxdzwx_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvv_ew_uxdzwx_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvv_ew_uxdzwx_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(36)
  type(Hpolcont), intent(in) :: M(2,36)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMZ,0,0],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[8,2,1,4],[0,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMW,0,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMZ,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,6),heltab2x36(:,:,6))
  Gcoeff(:)%j = (c(16)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[8,2,1,4],[0,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(4),m3h3x12(:,7),heltab2x36(:,:,7))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMZ,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(5),m3h3x12(:,8),heltab2x36(:,:,8))
  Gcoeff(:)%j = (c(25)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,9),heltab2x36(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(4),8,0,G1H12(6),n2h12(4))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[8,1,2,4],[0,nMZ,0,0],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,10),heltab2x36(:,:,10))
  call Hloop_Q_A(ntryL,G0H12(4),8,0,G1H12(7),n2h12(5))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,11),heltab2x36(:,:,11))
  call Hloop_Q_A(ntryL,G0H12(4),8,0,G1H12(8),n2h12(6))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[8,1,2,4],[0,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (c(12)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[8,1,2,4],[nMW,0,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (c(31)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[8,1,2,4],[nMZ,0,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[8,1,2,4],[0,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(9),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[8,1,2,4],[nMZ,0,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(10),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[8,1,4,2],[0,0,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(11),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(26)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[8,1,4,2],[nMW,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(12),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[8,1,4,2],[nMZ,0,0,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(13),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[8,1,4,2],[nMW,0,0,nMZ],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(14),m3h3x12(:,20),heltab2x36(:,:,20))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(8),[G1H12(6)])
  call Hloop_AQ_V(ntryL,G1H12(3),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H12(2),ex2(:),G1H6(2),ngZd,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G0H12(1),ex2(:),G0H6(1),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G0H6(1),10,0,G1H6(3),n2h6(1))
  call Hloop_WQ_A(ntryL,G0H12(2),ex2(:),G0H6(1),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_Q_A(ntryL,G0H6(1),10,0,G1H6(4),n2h6(2))
  call Hloop_ZQ_A(ntryL,G0H12(3),ex2(:),G0H6(1),ngZd,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_Q_A(ntryL,G0H6(1),10,0,G1H6(5),n2h6(3))
  call Hloop_VQ_A(ntryL,G1H12(4),ex2(:),G1H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_Q_A(ntryL,G1H6(6),10,0,G2H6(1),n2h6(4))
  call Hloop_ZQ_A(ntryL,G1H12(5),ex2(:),G1H6(6),ngZd,m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(6),10,0,G2H6(2),n2h6(5))
  call Hloop_QA_V(ntryL,G1H12(8),ex1(:),G1H6(6),m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_QA_Z(ntryL,G1H12(7),ex1(:),G1H6(7),ngZu,m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_VA_Q(ntryL,G0H12(4),ex1(:),G0H6(1),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G0H6(1),9,0,G1H6(8),n2h6(6))
  call Hloop_WA_Q(ntryL,G0H12(5),ex1(:),G0H6(1),m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G0H6(1),9,0,G1H6(9),n2h6(7))
  call Hloop_ZA_Q(ntryL,G0H12(6),ex1(:),G0H6(1),ngZu,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G0H6(1),9,0,G1H6(10),n2h6(8))
  call Hloop_VA_Q(ntryL,G1H12(9),ex1(:),G1H6(11),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(3),n2h6(9))
  call Hloop_ZA_Q(ntryL,G1H12(10),ex1(:),G1H6(11),ngZu,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(4),n2h6(10))
  call Hloop_VA_Q(ntryL,G1H12(11),ex1(:),G1H6(11),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(5),n2h6(11))
  call Hloop_WA_Q(ntryL,G1H12(12),ex1(:),G1H6(11),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(6),n2h6(12))
  call Hloop_ZA_Q(ntryL,G1H12(13),ex1(:),G1H6(11),ngZu,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(7),n2h6(13))
  call Hloop_WA_Q(ntryL,G1H12(14),ex1(:),G1H6(11),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G1H6(11),9,0,G2H6(8),n2h6(14))
  call Hloop_VA_Q(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),11,0,G2H3(1),n2h3(1))
  call Hloop_ZA_Q(ntryL,G1H6(2),ex1(:),G1H3(1),ngZu,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_A_Q(ntryL,G1H3(1),11,0,G2H3(2),n2h3(2))
  call Hloop_QA_W(ntryL,G1H6(3),ex1(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_QA_Z(ntryL,G1H6(4),ex1(:),G1H3(2),ngZu,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_QA_W(ntryL,G1H6(5),ex1(:),G1H3(3),m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_QA_W(ntryL,G2H6(1),ex1(:),G2H3(3),m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_QA_W(ntryL,G2H6(2),ex1(:),G2H3(4),m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_VQ_A(ntryL,G1H6(6),ex2(:),G1H3(4),m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(4),11,0,G2H3(5),n2h3(3))
  call Hloop_ZQ_A(ntryL,G1H6(7),ex2(:),G1H3(4),ngZd,m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(4),11,0,G2H3(6),n2h3(4))
  call Hloop_AQ_W(ntryL,G1H6(8),ex2(:),G1H3(4),m3h2x3(:,10),heltab2x6(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H6(9),ex2(:),G1H3(5),ngZd,m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_AQ_W(ntryL,G1H6(10),ex2(:),G1H3(6),m3h2x3(:,12),heltab2x6(:,:,12))
  call Hloop_AQ_W(ntryL,G2H6(3),ex2(:),G2H3(7),m3h2x3(:,13),heltab2x6(:,:,13))
  call Hloop_AQ_W(ntryL,G2H6(4),ex2(:),G2H3(8),m3h2x3(:,14),heltab2x6(:,:,14))
  call Hotf_4pt_reduction(G2H6(5),RedSet_4(1),mass4set(:,1),  & 
G1H6(11),G1H6(1),G1H6(2),G1H6(3),G1H6(4),6)
  call HG1shiftOLR(G1H6(1),2,6)
  call Hotf_4pt_reduction(G2H6(6),RedSet_4(1),mass4set(:,2),  & 
G1H6(5),G1H6(6),G1H6(7),G1H6(8),G1H6(9),6)
  call HG1shiftOLR(G1H6(6),2,6)
  call Hotf_4pt_reduction(G2H6(7),RedSet_4(1),mass4set(:,3),  & 
G1H6(10),G1H6(12),G1H6(13),G1H6(14),G1H6(15),6)
  call HG1shiftOLR(G1H6(12),2,6)
  call Hotf_4pt_reduction(G2H6(8),RedSet_4(1),mass4set(:,4),  & 
G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
  call HG1shiftOLR(G1H6(17),2,6)
  call Hloop_AZ_Q(ntryL,G1H6(11),ex3(:),G1H2(1),ngZu,m3h3x2(:,1),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(1),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(1),ex2(:),G1H3(7),m3h2x3(:,15),heltab2x6(:,:,16))
  call Hloop_AZ_Q(ntryL,G1H6(3),ex3(:),G1H2(1),ngZu,m3h3x2(:,2),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(2),n2h2(2))
  call Hloop_AZ_Q(ntryL,G1H6(4),ex3(:),G1H2(1),ngZu,m3h3x2(:,3),heltab2x6(:,:,18))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(3),n2h2(3))
  call Hloop_AZ_Q(ntryL,G1H6(5),ex3(:),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,19))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(4),n2h2(4))
call HGT_raise_alpha_OLR(G1H6(6),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(6),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(6),ex2(:),G1H3(8),m3h2x3(:,16),heltab2x6(:,:,20))
  call Hloop_AZ_Q(ntryL,G1H6(8),ex3(:),G1H2(1),ngZd,m3h3x2(:,5),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(5),n2h2(5))
  call Hloop_AZ_Q(ntryL,G1H6(9),ex3(:),G1H2(1),ngZd,m3h3x2(:,6),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(6),n2h2(6))
  call Hloop_AZ_Q(ntryL,G1H6(10),ex3(:),G1H2(1),ngZu,m3h3x2(:,7),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(7),n2h2(7))
call HGT_raise_alpha_OLR(G1H6(12),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(12),2,5,6)
  call Hloop_WQ_A(ntryL,G1H6(12),ex2(:),G1H3(9),m3h2x3(:,17),heltab2x6(:,:,24))
  call Hloop_AZ_Q(ntryL,G1H6(14),ex3(:),G1H2(1),ngZu,m3h3x2(:,8),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(8),n2h2(8))
  call Hloop_AZ_Q(ntryL,G1H6(15),ex3(:),G1H2(1),ngZu,m3h3x2(:,9),heltab2x6(:,:,26))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(9),n2h2(9))
  call Hloop_AZ_Q(ntryL,G1H6(16),ex3(:),G1H2(1),ngZd,m3h3x2(:,10),heltab2x6(:,:,27))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(10),n2h2(10))
call HGT_raise_alpha_OLR(G1H6(17),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(17),2,5,6)
  call Hloop_ZQ_A(ntryL,G1H6(17),ex2(:),G1H3(10),ngZd,m3h2x3(:,18),heltab2x6(:,:,28))
  call Hloop_AZ_Q(ntryL,G1H6(19),ex3(:),G1H2(1),ngZd,m3h3x2(:,11),heltab2x6(:,:,29))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(11),n2h2(11))
  call Hloop_AZ_Q(ntryL,G1H6(20),ex3(:),G1H2(1),ngZd,m3h3x2(:,12),heltab2x6(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(12),n2h2(12))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(2),mass4set(:,5),  & 
G1H3(11),G1H3(12),G1H3(13),G1H3(14),G1H3(15),3)
  call HG1shiftOLR(G1H3(12),4,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,6),  & 
G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
  call HG1shiftOLR(G1H3(17),4,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(1),ex3(:),G1tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(2),ex3(:),G1tensor(2),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(3),ex3(:),G1tensor(3),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(2),mass4set(:,7),  & 
G1H3(1),G1H3(2),G1H3(3),G1H3(21),G1H3(22),3)
  call HG1shiftOLR(G1H3(2),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(2),mass4set(:,8),  & 
G1H3(23),G1H3(24),G1H3(25),G1H3(26),G1H3(27),3)
  call HG1shiftOLR(G1H3(24),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(3),mass4set(:,5),  & 
G1H3(28),G1H3(29),G1H3(30),G1H3(31),G1H3(32),3)
  call HG1shiftOLR(G1H3(29),4,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(3),mass4set(:,6),  & 
G1H3(33),G1H3(34),G1H3(35),G1H3(36),G1H3(37),3)
  call HG1shiftOLR(G1H3(34),4,3)
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(4),ex3(:),G1tensor(4),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(5),ex3(:),G1tensor(5),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(6),ex3(:),G1tensor(6),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(3),mass4set(:,7),  & 
G1H3(4),G1H3(5),G1H3(6),G1H3(38),G1H3(39),3)
  call HG1shiftOLR(G1H3(5),4,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(3),mass4set(:,8),  & 
G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
  call HG1shiftOLR(G1H3(41),4,3)
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(7),ngZd,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(8),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hloop_AZ_Q(ntryL,G1H3(11),ex3(:),G1H1(1),ngZu,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(1))
  call Hloop_AZ_Q(ntryL,G1H3(12),ex3(:),G1H1(1),ngZu,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(2))
  call Hloop_AZ_Q(ntryL,G1H3(15),ex3(:),G1H1(1),ngZu,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(3))
  call Hloop_AZ_Q(ntryL,G1H3(16),ex3(:),G1H1(1),ngZu,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(4))
  call Hloop_AZ_Q(ntryL,G1H3(17),ex3(:),G1H1(1),ngZu,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(13),n2h1(5))
  call Hloop_AZ_Q(ntryL,G1H3(20),ex3(:),G1H1(1),ngZu,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(14),n2h1(6))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(1),11,ex3(:),4,G2tensor(15),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(2),0,ex3(:),4,G2tensor(16),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(22),11,ex3(:),4,G2tensor(17),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(23),11,ex3(:),4,G2tensor(18),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(24),0,ex3(:),4,G2tensor(19),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(27),11,ex3(:),4,G2tensor(20),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hloop_QZ_A(ntryL,G1H3(28),ex3(:),G1H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H3(29),ex3(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(22),n2h1(10))
  call Hloop_QZ_A(ntryL,G1H3(32),ex3(:),G1H1(1),ngZd,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(11))
  call Hloop_QZ_A(ntryL,G1H3(33),ex3(:),G1H1(1),ngZd,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(24),n2h1(12))
  call Hloop_QZ_A(ntryL,G1H3(34),ex3(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(25),n2h1(13))
  call Hloop_QZ_A(ntryL,G1H3(37),ex3(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(26),n2h1(14))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(4),11,ex3(:),4,G2tensor(27),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(5),0,ex3(:),4,G2tensor(28),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(39),11,ex3(:),4,G2tensor(29),m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(40),11,ex3(:),4,G2tensor(30),m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(41),0,ex3(:),4,G2tensor(31),m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(44),11,ex3(:),4,G2tensor(32),m3h3x1(:,30),heltab2x3(:,:,30))
  call ol_merge_tensors(G2tensor(15),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(6)])
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(2),mass4set(:,7),  & 
G1tensor(1),G1tensor(3),G1tensor(4),G1tensor(6),G1tensor(7))
  call G_TensorShift(G1tensor(3),4)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(2),mass4set(:,8),  & 
G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(9),4)
  call Hotf_4pt_reduction_last(G2tensor(27),RedSet_4(3),mass4set(:,7),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17))
  call G_TensorShift(G1tensor(14),4)
  call Hotf_4pt_reduction_last(G2tensor(30),RedSet_4(3),mass4set(:,8),  & 
G1tensor(18),G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22))
  call G_TensorShift(G1tensor(19),4)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(23),G1tensor(24),G1tensor(25),G1tensor(26),G1tensor(27))
  call G_TensorShift(G1tensor(24),2)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(1),mass4set(:,2),  & 
G1tensor(28),G1tensor(29),G1tensor(30),G1tensor(31),G1tensor(32))
  call G_TensorShift(G1tensor(29),2)
  call Hotf_4pt_reduction_last(G2tensor(5),RedSet_4(1),mass4set(:,3),  & 
G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36),G1tensor(37))
  call G_TensorShift(G1tensor(34),2)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(1),mass4set(:,4),  & 
G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
  call G_TensorShift(G1tensor(39),2)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(2),mass4set(:,5),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47))
  call G_TensorShift(G1tensor(44),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(2),mass4set(:,6),  & 
G1tensor(48),G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52))
  call G_TensorShift(G1tensor(49),4)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(3),mass4set(:,5),  & 
G1tensor(53),G1tensor(54),G1tensor(55),G1tensor(56),G1tensor(57))
  call G_TensorShift(G1tensor(54),4)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(3),mass4set(:,6),  & 
G1tensor(58),G1tensor(59),G1tensor(60),G1tensor(61),G1tensor(62))
  call G_TensorShift(G1tensor(59),4)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,7),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(2),RedSet_4(2),mass4set(:,9),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(8),RedSet_4(2),mass4set(:,8),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(13),RedSet_4(3),mass4set(:,7),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(5),RedSet_4(3),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(18),RedSet_4(3),mass4set(:,8),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(23),RedSet_4(1),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(28),RedSet_4(1),mass4set(:,2),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(33),RedSet_4(1),mass4set(:,3),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(38),RedSet_4(1),mass4set(:,4),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(43),RedSet_4(2),mass4set(:,5),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(48),RedSet_4(2),mass4set(:,6),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(53),RedSet_4(3),mass4set(:,5),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(58),RedSet_4(3),mass4set(:,6),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[12,1,2],[0,0,nMW],4,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[12,1,2],[nMW,0,0],4,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex4(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[12,1,2],[nMZ,0,nMW],4,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(3),m4h3x3x4(:,3),heltab3x36(:,:,3))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[12,1,2],[nMW,0,nMZ],4,0)
  call Hloop_WWV_V(ntryL,G0H36(1),ex3(:),ex4(:),G0H4(4),m4h3x3x4(:,4),heltab3x36(:,:,4))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[8,3,4],[nME,0,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,21),heltab2x36(:,:,21))
  call Hloop_A_Q(ntryL,G0H12(1),8,nME,G1H12(1),n2h12(7))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[8,3,4],[nMM,0,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,22),heltab2x36(:,:,22))
  call Hloop_A_Q(ntryL,G0H12(2),8,nMM,G1H12(6),n2h12(8))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[8,3,4],[nML,0,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,23),heltab2x36(:,:,23))
  call Hloop_A_Q(ntryL,G0H12(3),8,nML,G1H12(3),n2h12(9))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[8,3,4],[0,nME,nME],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,24),heltab2x36(:,:,24))
  call Hloop_Q_A(ntryL,G0H12(4),8,0,G1H12(2),n2h12(10))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[8,3,4],[0,nMM,nMM],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,25),heltab2x36(:,:,25))
  call Hloop_Q_A(ntryL,G0H12(5),8,0,G1H12(4),n2h12(11))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[8,3,4],[0,nML,nML],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,26),heltab2x36(:,:,26))
  call Hloop_Q_A(ntryL,G0H12(6),8,0,G1H12(5),n2h12(12))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,27),heltab2x36(:,:,27))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(8),n2h12(13))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[8,3,4],[nMB,nMT,nMT],3,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,28),heltab2x36(:,:,28))
  call Hloop_A_Q(ntryL,G0H12(2),8,nMB,G1H12(7),n2h12(14))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[8,3,4],[0,0,0],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,29),heltab2x36(:,:,29))
  call Hloop_Q_A(ntryL,G0H12(3),8,0,G1H12(9),n2h12(15))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[8,3,4],[nMT,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,30),heltab2x36(:,:,30))
  call Hloop_Q_A(ntryL,G0H12(4),8,nMT,G1H12(10),n2h12(16))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[8,3,4],[nMW,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(11),m3h3x12(:,31),heltab2x36(:,:,31))
  Gcoeff(:)%j = (c(4)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[8,3,4],[nMW,nMH,nMZ],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(12),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[8,3,4],[nMH,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(13),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(14),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(15),m3h3x12(:,35),heltab2x36(:,:,35))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(16),m3h3x12(:,36),heltab2x36(:,:,36))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(17),m3h3x12(:,37),heltab2x36(:,:,37))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(18),m3h3x12(:,38),heltab2x36(:,:,38))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(19),m3h3x12(:,39),heltab2x36(:,:,39))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(20),m3h3x12(:,40),heltab2x36(:,:,40))
  Gcoeff(:)%j = (c(34)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,41),heltab2x36(:,:,41))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,42),heltab2x36(:,:,42))
  Gcoeff(:)%j = (c(21)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[8,3,4],[nMW,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(21),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[8,3,4],[nMH,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(22),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[8,3,4],[nMW,nMH,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,45),heltab2x36(:,:,45))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[8,3,4],[nMH,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,46),heltab2x36(:,:,46))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,47),heltab2x36(:,:,47))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[8,3,4],[nMW,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,48),heltab2x36(:,:,48))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,49),heltab2x36(:,:,49))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[8,3,4],[0,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(23),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[8,3,4],[nMW,nMH,nMZ],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(24),m3h3x12(:,51),heltab2x36(:,:,51))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[8,3,4],[nMZ,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(25),m3h3x12(:,52),heltab2x36(:,:,52))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[8,3,4],[nMH,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,53),heltab2x36(:,:,53))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[8,2,5],[0,0,0],3,1,wf6(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,54),heltab2x36(:,:,54))
  call Hloop_A_Q(ntryL,G0H12(9),8,0,G1H12(26),n2h12(17))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[8,2,5],[0,nMZ,0],3,1,wf6(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,55),heltab2x36(:,:,55))
  call Hloop_A_Q(ntryL,G0H12(9),8,0,G1H12(27),n2h12(18))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[8,2,5],[0,0,0],3,1,wf6(:,3))
  call Hloop_AW_Q(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,56),heltab2x36(:,:,56))
  call Hloop_A_Q(ntryL,G0H12(9),8,0,G1H12(28),n2h12(19))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[8,2,5],[nMW,0,0],3,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(29),m3h3x12(:,57),heltab2x36(:,:,57))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[8,2,5],[0,0,nMW],3,1,wf6(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(30),m3h3x12(:,58),heltab2x36(:,:,58))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[8,2,5],[nMW,0,nMZ],3,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(31),m3h3x12(:,59),heltab2x36(:,:,59))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[8,2,5],[nMZ,0,nMW],3,1,wf6(:,3))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(32),m3h3x12(:,60),heltab2x36(:,:,60))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[8,1,6],[0,0,0],3,1,wf6(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,61),heltab2x36(:,:,61))
  call Hloop_Q_A(ntryL,G0H12(9),8,0,G1H12(33),n2h12(20))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[8,1,6],[0,nMZ,0],3,1,wf6(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,62),heltab2x36(:,:,62))
  call Hloop_Q_A(ntryL,G0H12(9),8,0,G1H12(34),n2h12(21))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[8,1,6],[0,0,0],3,1,wf6(:,11))
  call Hloop_QW_A(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,63),heltab2x36(:,:,63))
  call Hloop_Q_A(ntryL,G0H12(9),8,0,G1H12(35),n2h12(22))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[8,1,6],[0,0,nMW],3,1,wf6(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(36),m3h3x12(:,64),heltab2x36(:,:,64))
  Gcoeff(:)%j = (c(26)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[8,1,6],[nMW,0,0],3,1,wf6(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(37),m3h3x12(:,65),heltab2x36(:,:,65))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[8,1,6],[nMZ,0,nMW],3,1,wf6(:,11))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(38),m3h3x12(:,66),heltab2x36(:,:,66))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[8,1,6],[nMW,0,nMZ],3,1,wf6(:,11))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(39),m3h3x12(:,67),heltab2x36(:,:,67))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[9,2,4],[0,0,0],3,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(1),m3h6x6(:,1),heltab2x36(:,:,68))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[9,2,4],[nMZ,0,0],3,1,wf6(:,6))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(2),ngZd,m3h6x6(:,2),heltab2x36(:,:,69))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[9,2,4],[nMW,0,0],3,1,wf6(:,6))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(3),m3h6x6(:,3),heltab2x36(:,:,70))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[9,2,4],[0,0,0],3,1,wf6(:,6))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(4),m3h6x6(:,4),heltab2x36(:,:,71))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[9,2,4],[0,nMW,nMW],3,1,wf6(:,6))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,6),G0H6(5),m3h6x6(:,5),heltab2x36(:,:,72))
  call Hloop_A_Q(ntryL,G0H6(5),9,0,G1H6(11),n2h6(19))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[10,1,4],[0,0,0],3,1,wf6(:,13))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,13),G0H6(5),m3h6x6(:,6),heltab2x36(:,:,73))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[10,1,4],[nMZ,0,0],3,1,wf6(:,13))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,13),G0H6(6),ngZu,m3h6x6(:,7),heltab2x36(:,:,74))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[10,1,4],[nMW,0,0],3,1,wf6(:,13))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,13),G0H6(7),m3h6x6(:,8),heltab2x36(:,:,75))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[10,1,4],[0,0,0],3,1,wf6(:,13))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,13),G0H6(8),m3h6x6(:,9),heltab2x36(:,:,76))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[10,1,4],[0,nMW,nMW],3,1,wf6(:,13))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,13),G0H6(9),m3h6x6(:,10),heltab2x36(:,:,77))
  call Hloop_Q_A(ntryL,G0H6(9),10,0,G1H6(1),n2h6(20))
  Gcoeff(:)%j = (-(c(2)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[12,1,2],[0,0,nMW],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(5),m3h9x4(:,1),heltab2x36(:,:,78))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[12,1,2],[nMW,0,0],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(6),m3h9x4(:,2),heltab2x36(:,:,79))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[12,1,2],[nMZ,0,nMW],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(7),m3h9x4(:,3),heltab2x36(:,:,80))
  Gcoeff(:)%j = (c(31)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[12,1,2],[nMW,0,nMZ],3,1,wf9(:,3))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(8),m3h9x4(:,4),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[12,1,2],[0,0,0],3,1,wf9(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,5),heltab2x36(:,:,82))
  call Hloop_Q_A(ntryL,G0H4(9),12,0,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[12,1,2],[0,nMZ,0],3,1,wf9(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,6),heltab2x36(:,:,83))
  call Hloop_Q_A(ntryL,G0H4(9),12,0,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(19)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[12,1,2],[0,0,0],3,1,wf9(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,7),heltab2x36(:,:,84))
  call Hloop_Q_A(ntryL,G0H4(9),12,0,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (-(c(17)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[12,1,2],[0,0,nMW],3,1,wf9(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(4),m3h9x4(:,8),heltab2x36(:,:,85))
  Gcoeff(:)%j = (c(16)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[12,1,2],[nMW,0,0],3,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(5),m3h9x4(:,9),heltab2x36(:,:,86))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[12,1,2],[nMZ,0,nMW],3,1,wf9(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(6),m3h9x4(:,10),heltab2x36(:,:,87))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[12,1,2],[nMW,0,nMZ],3,1,wf9(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(7),m3h9x4(:,11),heltab2x36(:,:,88))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G0H4(5),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(5),[G0H4(6),G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G0H4(7),G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G0H4(8),G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(35),[G1H12(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(4),[G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(8),[G0H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G1H4(1)])
  call Hloop_AZ_Q(ntryL,G1H6(13),ex3(:),G1H2(1),ngZu,m3h3x2(:,13),heltab2x6(:,:,31))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(1),n2h2(13))
  call Hloop_AZ_Q(ntryL,G1H6(7),ex3(:),G1H2(1),ngZd,m3h3x2(:,14),heltab2x6(:,:,32))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(3),n2h2(14))
  call Hloop_AZ_Q(ntryL,G1H6(18),ex3(:),G1H2(1),ngZd,m3h3x2(:,15),heltab2x6(:,:,33))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(4),n2h2(15))
  call Hloop_VA_Q(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(6),n2h2(16))
  call Hloop_WA_Q(ntryL,G1H4(5),ex1(:),G1H2(1),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(7),n2h2(17))
  call Hloop_ZA_Q(ntryL,G1H4(6),ex1(:),G1H2(1),ngZu,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(9),n2h2(18))
  call Hloop_WA_Q(ntryL,G1H4(7),ex1(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(10),n2h2(19))
  call Hloop_AW_Q(ntryL,G1H12(1),wf4(:,1),G1H3(11),m3h4x3(:,1),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G1H3(11),11,0,G2H3(1),n2h3(5))
  call Hloop_AW_Q(ntryL,G1H12(6),wf4(:,1),G1H3(12),m3h4x3(:,2),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(12),11,0,G2H3(2),n2h3(6))
  call Hloop_AW_Q(ntryL,G1H12(3),wf4(:,1),G1H3(15),m3h4x3(:,3),heltab2x12(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(15),11,0,G2H3(3),n2h3(7))
  call Hloop_QW_A(ntryL,G1H12(2),wf4(:,1),G1H3(16),m3h4x3(:,4),heltab2x12(:,:,22))
  call Hloop_Q_A(ntryL,G1H3(16),11,nME,G2H3(4),n2h3(8))
  call Hloop_QW_A(ntryL,G1H12(4),wf4(:,1),G1H3(17),m3h4x3(:,5),heltab2x12(:,:,23))
  call Hloop_Q_A(ntryL,G1H3(17),11,nMM,G2H3(5),n2h3(9))
  call Hloop_QW_A(ntryL,G1H12(5),wf4(:,1),G1H3(20),m3h4x3(:,6),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H3(20),11,nML,G2H3(6),n2h3(10))
  call Hloop_AW_Q(ntryL,G1H12(8),wf4(:,1),G1H3(1),m3h4x3(:,7),heltab2x12(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),11,0,G2H3(7),n2h3(11))
  call Hloop_AW_Q(ntryL,G1H12(7),wf4(:,1),G1H3(2),m3h4x3(:,8),heltab2x12(:,:,26))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMT,G2H3(8),n2h3(12))
  call Hloop_QW_A(ntryL,G1H12(9),wf4(:,1),G1H3(22),m3h4x3(:,9),heltab2x12(:,:,27))
  call Hloop_Q_A(ntryL,G1H3(22),11,0,G2H3(9),n2h3(13))
  call Hloop_QW_A(ntryL,G1H12(10),wf4(:,1),G1H3(23),m3h4x3(:,10),heltab2x12(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(23),11,nMB,G2H3(10),n2h3(14))
  call Hloop_SV_T(ntryL,G1H12(11),8,wf4(:,1),3,G2H3(11),m3h4x3(:,11),heltab2x12(:,:,29))
  call Hloop_SV_T(ntryL,G1H12(12),8,wf4(:,1),3,G2H3(12),m3h4x3(:,12),heltab2x12(:,:,30))
  call Hloop_TV_S(ntryL,G1H12(13),8,wf4(:,1),3,G2H3(13),m3h4x3(:,13),heltab2x12(:,:,31))
  call Hloop_TV_S(ntryL,G1H12(14),8,wf4(:,1),3,G2H3(14),m3h4x3(:,14),heltab2x12(:,:,32))
  call Hloop_CV_D(ntryL,G1H12(15),8,wf4(:,1),3,G2H3(15),m3h4x3(:,15),heltab2x12(:,:,33))
  call Hloop_CV_D(ntryL,G1H12(16),8,wf4(:,1),3,G2H3(16),m3h4x3(:,16),heltab2x12(:,:,34))
  call Hloop_DV_C(ntryL,G1H12(17),8,wf4(:,1),G2H3(17),m3h4x3(:,17),heltab2x12(:,:,35))
  call Hloop_DV_C(ntryL,G1H12(18),8,wf4(:,1),G2H3(18),m3h4x3(:,18),heltab2x12(:,:,36))
  call Hloop_UW_V(ntryL,G1H12(19),8,wf4(:,1),3,G2H3(19),m3h4x3(:,19),heltab2x12(:,:,37))
  call Hloop_UW_V(ntryL,G1H12(20),8,wf4(:,1),3,G2H3(20),m3h4x3(:,20),heltab2x12(:,:,38))
  call Hloop_VV_S(ntryL,G0H12(5),wf4(:,1),G0H3(1),m3h4x3(:,21),heltab2x12(:,:,39))
  call Hloop_VV_S(ntryL,G0H12(6),wf4(:,1),G0H3(2),m3h4x3(:,22),heltab2x12(:,:,40))
  call Hloop_SV_V(ntryL,G1H12(21),wf4(:,1),G1H3(24),m3h4x3(:,23),heltab2x12(:,:,41))
  call Hloop_SV_V(ntryL,G1H12(22),wf4(:,1),G1H3(27),m3h4x3(:,24),heltab2x12(:,:,42))
  call Hloop_SV_T(ntryL,G0H12(1),8,wf4(:,1),3,G1H3(28),m3h4x3(:,25),heltab2x12(:,:,43))
  call Hloop_TV_S(ntryL,G0H12(2),8,wf4(:,1),3,G1H3(29),m3h4x3(:,26),heltab2x12(:,:,44))
  call Hloop_UW_V(ntryL,G0H12(3),8,wf4(:,1),3,G1H3(32),m3h4x3(:,27),heltab2x12(:,:,45))
  call Hloop_UV_W(ntryL,G0H12(4),8,wf4(:,1),3,G1H3(33),m3h4x3(:,28),heltab2x12(:,:,46))
  call Hloop_UW_V(ntryL,G0H12(7),8,wf4(:,1),3,G1H3(34),m3h4x3(:,29),heltab2x12(:,:,47))
  call Hloop_VV_S(ntryL,G1H12(23),wf4(:,1),G1H3(37),m3h4x3(:,30),heltab2x12(:,:,48))
  call Hloop_VV_S(ntryL,G1H12(24),wf4(:,1),G1H3(4),m3h4x3(:,31),heltab2x12(:,:,49))
  call Hloop_VV_S(ntryL,G1H12(25),wf4(:,1),G1H3(5),m3h4x3(:,32),heltab2x12(:,:,50))
  call Hloop_SV_V(ntryL,G0H12(8),wf4(:,1),G0H3(3),m3h4x3(:,33),heltab2x12(:,:,51))
  call Hloop_AQ_V(ntryL,G1H12(28),ex2(:),G1H6(3),m3h2x6(:,19),heltab2x12(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H12(27),ex2(:),G1H6(4),ngZd,m3h2x6(:,20),heltab2x12(:,:,53))
  call Hloop_WQ_A(ntryL,G1H12(29),ex2(:),G1H6(5),m3h2x6(:,21),heltab2x12(:,:,54))
  call Hloop_Q_A(ntryL,G1H6(5),10,0,G2H6(1),n2h6(21))
  call Hloop_VQ_A(ntryL,G1H12(30),ex2(:),G1H6(6),m3h2x6(:,22),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(6),10,0,G2H6(2),n2h6(22))
  call Hloop_WQ_A(ntryL,G1H12(31),ex2(:),G1H6(8),m3h2x6(:,23),heltab2x12(:,:,56))
  call Hloop_Q_A(ntryL,G1H6(8),10,0,G2H6(3),n2h6(23))
  call Hloop_ZQ_A(ntryL,G1H12(32),ex2(:),G1H6(9),ngZd,m3h2x6(:,24),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(9),10,0,G2H6(4),n2h6(24))
  call Hloop_QA_V(ntryL,G1H12(35),ex1(:),G1H6(10),m3h2x6(:,25),heltab2x12(:,:,58))
  call Hloop_QA_Z(ntryL,G1H12(34),ex1(:),G1H6(12),ngZu,m3h2x6(:,26),heltab2x12(:,:,59))
  call Hloop_VA_Q(ntryL,G1H12(36),ex1(:),G1H6(14),m3h2x6(:,27),heltab2x12(:,:,60))
  call Hloop_A_Q(ntryL,G1H6(14),9,0,G2H6(5),n2h6(25))
  call Hloop_WA_Q(ntryL,G1H12(37),ex1(:),G1H6(15),m3h2x6(:,28),heltab2x12(:,:,61))
  call Hloop_A_Q(ntryL,G1H6(15),9,0,G2H6(6),n2h6(26))
  call Hloop_ZA_Q(ntryL,G1H12(38),ex1(:),G1H6(16),ngZu,m3h2x6(:,29),heltab2x12(:,:,62))
  call Hloop_A_Q(ntryL,G1H6(16),9,0,G2H6(7),n2h6(27))
  call Hloop_WA_Q(ntryL,G1H12(39),ex1(:),G1H6(17),m3h2x6(:,30),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H6(17),9,0,G2H6(8),n2h6(28))
  call Hloop_VQ_A(ntryL,G0H6(4),ex2(:),G0H3(4),m3h2x3(:,19),heltab2x6(:,:,34))
  call Hloop_Q_A(ntryL,G0H3(4),11,0,G1H3(39),n2h3(15))
  call Hloop_ZQ_A(ntryL,G0H6(2),ex2(:),G0H3(4),ngZd,m3h2x3(:,20),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G0H3(4),11,0,G1H3(40),n2h3(16))
  call Hloop_WQ_A(ntryL,G0H6(3),ex2(:),G0H3(4),m3h2x3(:,21),heltab2x6(:,:,36))
  call Hloop_Q_A(ntryL,G0H3(4),11,0,G1H3(41),n2h3(17))
  call Hloop_AQ_W(ntryL,G1H6(11),ex2(:),G1H3(44),m3h2x3(:,22),heltab2x6(:,:,37))
  call Hloop_VA_Q(ntryL,G0H6(8),ex1(:),G0H3(4),m3h2x3(:,23),heltab2x6(:,:,38))
  call Hloop_A_Q(ntryL,G0H3(4),11,0,G1H3(11),n2h3(18))
  call Hloop_ZA_Q(ntryL,G0H6(6),ex1(:),G0H3(4),ngZu,m3h2x3(:,24),heltab2x6(:,:,39))
  call Hloop_A_Q(ntryL,G0H3(4),11,0,G1H3(12),n2h3(19))
  call Hloop_WA_Q(ntryL,G0H6(7),ex1(:),G0H3(4),m3h2x3(:,25),heltab2x6(:,:,40))
  call Hloop_A_Q(ntryL,G0H3(4),11,0,G1H3(15),n2h3(20))
  call Hloop_QA_W(ntryL,G1H6(1),ex1(:),G1H3(16),m3h2x3(:,26),heltab2x6(:,:,41))
  call Hloop_QA_V(ntryL,G1H4(3),ex1(:),G1H2(1),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_QA_Z(ntryL,G1H4(2),ex1(:),G1H2(2),ngZu,m3h2x2(:,6),heltab2x4(:,:,6))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(11),[G1H3(13)])
call HGT_w2_OLR(G1H3(7),1,1,3)
call HGT_w2_invQ_OLR(G1H3(7),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(7),[G1H3(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(8)])
call HGT_w2_OLR(G1H3(10),1,1,3)
call HGT_w2_invQ_OLR(G1H3(10),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(18)])
call HGT_w2_OLR(G1H3(9),1,1,3)
call HGT_w2_invQ_OLR(G1H3(9),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(9),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(7),[G1H3(19),G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(16),[G1H3(25),G1H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G1H3(38),G1H3(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(20),[G1H3(43),G1H3(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(39),[G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G1H3(36),G1H3(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(40),[G1H3(35)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(44),[G1H3(42),G1H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(14),[G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(33),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(4),[G1H3(28)])
  call Hloop_AZ_Q(ntryL,G1H3(7),ex3(:),G1H1(1),ngZu,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(18),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hloop_AZ_Q(ntryL,G1H3(10),ex3(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(27),n2h1(18))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(30),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hloop_AZ_Q(ntryL,G1H3(9),ex3(:),G1H1(1),ngZu,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(19))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(3),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(5),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_AZ_Q(ntryL,G2H3(7),ex3(:),G2H1(1),ngZu,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(1),n2h1(20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(16),11,ex3(:),4,G2tensor(7),m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(19),11,ex3(:),4,G3tensor(2),m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(20),11,ex3(:),4,G3tensor(3),m3h3x1(:,37),heltab2x3(:,:,37))
  call Hloop_QZ_A(ntryL,G1H3(39),ex3(:),G1H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(21))
  call Hloop_QZ_A(ntryL,G2H3(9),ex3(:),G2H1(1),ngZd,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(4),n2h1(22))
  call Hloop_QZ_A(ntryL,G1H3(40),ex3(:),G1H1(1),ngZd,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(23))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(44),11,ex3(:),4,G2tensor(21),m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(24),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(33),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(34),ngZd,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(35),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(36),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(37),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(38),ngZd,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hloop_AZ_Q(ntryL,G2H3(1),ex3(:),G2H1(1),ngZn,m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(5),n2h1(24))
  call Hloop_AZ_Q(ntryL,G2H3(2),ex3(:),G2H1(1),ngZn,m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(6),n2h1(25))
  call Hloop_AZ_Q(ntryL,G2H3(3),ex3(:),G2H1(1),ngZn,m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(7),n2h1(26))
  call Hloop_QZ_A(ntryL,G2H3(4),ex3(:),G2H1(1),ngZl,m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nME,G3tensor(8),n2h1(27))
  call Hloop_QZ_A(ntryL,G2H3(5),ex3(:),G2H1(1),ngZl,m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(9),n2h1(28))
  call Hloop_QZ_A(ntryL,G2H3(6),ex3(:),G2H1(1),ngZl,m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nML,G3tensor(10),n2h1(29))
  call Hloop_AZ_Q(ntryL,G2H3(8),ex3(:),G2H1(1),ngZu,m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(11),n2h1(30))
  call Hloop_QZ_A(ntryL,G2H3(10),ex3(:),G2H1(1),ngZd,m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(12),n2h1(31))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(11),11,ex3(:),4,G3tensor(13),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(12),11,ex3(:),4,G3tensor(14),m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(13),11,ex3(:),4,G3tensor(15),m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(14),11,ex3(:),4,G3tensor(16),m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(15),11,ex3(:),4,G3tensor(17),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(16),11,ex3(:),4,G3tensor(18),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(17),11,ex3(:),G3tensor(19),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(18),11,ex3(:),G3tensor(20),m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(1),11,ex3(:),4,G1tensor(1),m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(33),ex3(:),G1tensor(2),m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(27),ex3(:),G1tensor(8),m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(4),ex3(:),G1tensor(13),m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(29),ex3(:),G1tensor(5),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(32),ex3(:),G1tensor(18),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(34),ex3(:),G1tensor(23),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(37),ex3(:),G1tensor(28),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(5),ex3(:),G1tensor(33),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(3),11,ex3(:),4,G1tensor(38),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hloop_VA_Q(ntryL,G1H6(3),wf6(:,3),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,42))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(39),n2h1(32))
  call Hloop_ZA_Q(ntryL,G1H6(4),wf6(:,3),G1H1(1),ngZu,m3h6x1(:,2),heltab2x6(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(40),n2h1(33))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,3),G2tensor(41),m3h6x1(:,3),heltab2x6(:,:,44))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(2),wf6(:,3),G2tensor(42),m3h6x1(:,4),heltab2x6(:,:,45))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H6(3),wf6(:,3),G2tensor(43),ngZu,m3h6x1(:,5),heltab2x6(:,:,46))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(4),wf6(:,3),G2tensor(44),m3h6x1(:,6),heltab2x6(:,:,47))
  call Hloop_VQ_A(ntryL,G1H6(10),wf6(:,11),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,48))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(45),n2h1(34))
  call Hloop_ZQ_A(ntryL,G1H6(12),wf6(:,11),G1H1(1),ngZd,m3h6x1(:,8),heltab2x6(:,:,49))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(46),n2h1(35))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(5),wf6(:,11),G2tensor(47),m3h6x1(:,9),heltab2x6(:,:,50))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(6),wf6(:,11),G2tensor(48),m3h6x1(:,10),heltab2x6(:,:,51))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(7),wf6(:,11),G2tensor(49),m3h6x1(:,11),heltab2x6(:,:,52))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G2H6(8),wf6(:,11),G2tensor(50),ngZd,m3h6x1(:,12),heltab2x6(:,:,53))
  call Hloop_QZ_A(ntryL,G1H3(41),ex3(:),G1H1(1),ngZu,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(51),n2h1(36))
  call Hloop_VQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(52),n2h1(37))
  call Hloop_ZQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(53),n2h1(38))
  call ol_merge_tensors(G2tensor(47),[G2tensor(29),G2tensor(2),G1tensor(27),G1tensor(17),G0tensor(35),G0tensor(20)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(4),G1tensor(32),G0tensor(40)])
  call ol_merge_tensors(G2tensor(49),[G2tensor(32),G2tensor(6),G1tensor(37),G1tensor(22),G0tensor(45),G0tensor(30)])
  call ol_merge_tensors(G2tensor(50),[G2tensor(8),G1tensor(42),G0tensor(50)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(44),G0tensor(52)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(11),G1tensor(47),G0tensor(55)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(49),G0tensor(57)])
  call ol_merge_tensors(G2tensor(40),[G2tensor(14),G1tensor(52),G0tensor(60)])
  call ol_merge_tensors(G2tensor(16),[G1tensor(3),G0tensor(2)])
  call ol_merge_tensors(G2tensor(42),[G2tensor(17),G1tensor(7),G0tensor(5)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(9),G0tensor(12)])
  call ol_merge_tensors(G2tensor(44),[G2tensor(20),G1tensor(12),G0tensor(15)])
  call ol_merge_tensors(G2tensor(52),[G2tensor(22),G1tensor(54),G0tensor(62)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(23),G1tensor(57),G0tensor(65)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(25),G1tensor(59),G0tensor(67)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(26),G1tensor(62),G0tensor(70)])
  call ol_merge_tensors(G2tensor(35),[G2tensor(28),G1tensor(14),G0tensor(17)])
  call ol_merge_tensors(G2tensor(37),[G2tensor(31),G1tensor(19),G0tensor(27)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(10),G1tensor(4),G0tensor(13),G0tensor(3)])
  call ol_merge_tensors(G3tensor(19),[G3tensor(17),G3tensor(2),G1tensor(28),G1tensor(18),G1tensor(1),G1tensor(16),G1tensor(6) &
    ,G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G3tensor(20),[G3tensor(18),G3tensor(16),G3tensor(3),G1tensor(33),G1tensor(23),G1tensor(21),G1tensor(11) &
    ,G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(20),G1tensor(15),G0tensor(28),G0tensor(18)])
  call ol_merge_tensors(G2tensor(15),[G1tensor(45),G1tensor(24),G0tensor(53),G0tensor(32)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(35),G1tensor(25),G0tensor(43),G0tensor(33)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(26),G0tensor(34)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(39),G1tensor(29),G0tensor(47),G0tensor(37)])
  call ol_merge_tensors(G2tensor(33),[G1tensor(30),G0tensor(38)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(31),G0tensor(39)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(50),G1tensor(34),G0tensor(58),G0tensor(42)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(36),G0tensor(44)])
  call ol_merge_tensors(G2tensor(34),[G1tensor(40),G0tensor(48)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(41),G0tensor(49)])
  call ol_merge_tensors(G3tensor(4),[G3tensor(1),G1tensor(61),G1tensor(56),G1tensor(51),G1tensor(46),G0tensor(69),G0tensor(64) &
    ,G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(55),G0tensor(63)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(60),G0tensor(68)])
  call ol_merge_tensors(G3tensor(13),[G1tensor(2),G0tensor(24),G0tensor(9)])
  call ol_merge_tensors(G2tensor(38),[G0tensor(22)])
  call ol_merge_tensors(G3tensor(14),[G1tensor(13)])
  call ol_merge_tensors(G3tensor(15),[G1tensor(38),G1tensor(5),G1tensor(8)])
  call TI_triangle_red(G2tensor(47),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMW], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(48),RedBasis(1),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36),G0tensor(41),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(49),RedBasis(1),mass3set(:,3),G0tensor(51),G0tensor(56),G0tensor(61), &
    G0tensor(66),M2L1R1,[nMW,nMZ],G0tensor(35),G0tensor(20))
  call TI_triangle_red(G2tensor(50),RedBasis(1),mass3set(:,4),G0tensor(40),G0tensor(45),G0tensor(30), &
    G0tensor(50),M2L1R1,[nMZ,nMW],G0tensor(52),G0tensor(55))
  call TI_triangle_red(G2tensor(10),RedBasis(8),mass3set(:,5),G0tensor(57),G0tensor(60),G0tensor(2),G0tensor(5),M2L1R1)
  call TI_triangle_red(G2tensor(39),RedBasis(4),mass3set(:,5),G0tensor(12),G0tensor(15),G0tensor(62),G0tensor(65),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(8),mass3set(:,6),G0tensor(67),G0tensor(70),G0tensor(17),G0tensor(27),M2L1R1,[nMZ], &
    G0tensor(13))
  call TI_triangle_red(G2tensor(40),RedBasis(4),mass3set(:,6),G0tensor(3),G0tensor(19),G0tensor(4),G0tensor(29),M2L1R1,[nMZ], &
    G0tensor(14))
  call TI_triangle_red(G2tensor(16),RedBasis(8),mass3set(:,1),G0tensor(28),G0tensor(18),G0tensor(53),G0tensor(32),M2L1R1,[nMW], &
    G0tensor(43))
  call TI_triangle_red(G2tensor(42),RedBasis(4),mass3set(:,1),G0tensor(33),G0tensor(34),G0tensor(47),G0tensor(37),M2L1R1,[nMW], &
    G0tensor(38))
  call TI_triangle_red(G2tensor(19),RedBasis(8),mass3set(:,3),G0tensor(39),G0tensor(58),G0tensor(42), &
    G0tensor(44),M2L1R1,[nMW,nMZ],G0tensor(48),G0tensor(49))
  call TI_triangle_red(G2tensor(44),RedBasis(4),mass3set(:,3),G0tensor(69),G0tensor(64),G0tensor(59), &
    G0tensor(54),M2L1R1,[nMW,nMZ],G0tensor(63),G0tensor(68))
  call TI_triangle_red(G2tensor(52),RedBasis(9),mass3set(:,5),G0tensor(24),G0tensor(9),G0tensor(22),G0tensor(71),M2L1R1)
  call TI_triangle_red(G2tensor(45),RedBasis(1),mass3set(:,5),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),M2L1R1)
  call TI_triangle_red(G2tensor(53),RedBasis(9),mass3set(:,6),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),M2L1R1,[nMZ], &
    G0tensor(80))
  call TI_triangle_red(G2tensor(46),RedBasis(1),mass3set(:,6),G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),M2L1R1,[nMZ], &
    G0tensor(85))
  call TI_triangle_red(G2tensor(35),RedBasis(9),mass3set(:,1),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),M2L1R1,[nMW], &
    G0tensor(90))
  call TI_triangle_red(G2tensor(37),RedBasis(9),mass3set(:,3),G0tensor(91),G0tensor(92),G0tensor(93), &
    G0tensor(94),M2L1R1,[nMW,nMZ],G0tensor(95),G0tensor(96))
  call TI_triangle_red(G2tensor(7),RedBasis(6),mass3set(:,7),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100),M2L1R1,[nMW], &
    G0tensor(101))
  call TI_triangle_red(G3tensor(19),RedBasis(5),mass3set(:,7),G0tensor(102),G0tensor(103),G0tensor(104), &
    G0tensor(105),M2L1R1,[nMW],G0tensor(106))
  call TI_triangle_red(G3tensor(20),RedBasis(5),mass3set(:,8),G0tensor(107),G0tensor(108),G0tensor(109), &
    G0tensor(110),M2L1R1,[nMW,nMZ],G0tensor(111),G0tensor(112))
  call TI_triangle_red(G2tensor(21),RedBasis(7),mass3set(:,7),G0tensor(113),G0tensor(114),G0tensor(115), &
    G0tensor(116),M2L1R1,[nMW],G0tensor(117))
  call TI_triangle_red(G2tensor(15),RedBasis(6),mass3set(:,5),G0tensor(118),G0tensor(119),G0tensor(120),G0tensor(121),M2L1R1)
  call TI_triangle_red(G2tensor(24),RedBasis(3),mass3set(:,1),G0tensor(122),G0tensor(123),G0tensor(124), &
    G0tensor(125),M2L1R1,[nMW],G0tensor(126))
  call TI_triangle_red(G2tensor(18),RedBasis(2),mass3set(:,1),G0tensor(127),G0tensor(128),G0tensor(129), &
    G0tensor(130),M2L1R1,[nMW],G0tensor(131))
  call TI_triangle_red(G2tensor(27),RedBasis(6),mass3set(:,2),G0tensor(132),G0tensor(133),G0tensor(134), &
    G0tensor(135),M2L1R1,[nMW],G0tensor(136))
  call TI_triangle_red(G2tensor(33),RedBasis(3),mass3set(:,5),G0tensor(137),G0tensor(138),G0tensor(139),G0tensor(140),M2L1R1)
  call TI_triangle_red(G2tensor(30),RedBasis(2),mass3set(:,2),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMW],G0tensor(145))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,9),G0tensor(146),G0tensor(147),G0tensor(148),G0tensor(149),M2L1R1,[nMZ], &
    G0tensor(150))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,3),G0tensor(151),G0tensor(152),G0tensor(153), &
    G0tensor(154),M2L1R1,[nMW,nMZ],G0tensor(155),G0tensor(156))
  call TI_triangle_red(G2tensor(34),RedBasis(3),mass3set(:,10),G0tensor(157),G0tensor(158),G0tensor(159), &
    G0tensor(160),M2L1R1,[nMZ],G0tensor(161))
  call TI_triangle_red(G2tensor(5),RedBasis(2),mass3set(:,4),G0tensor(162),G0tensor(163),G0tensor(164), &
    G0tensor(165),M2L1R1,[nMZ,nMW],G0tensor(166),G0tensor(167))
  call TI_triangle_red(G3tensor(4),RedBasis(5),mass3set(:,5),G0tensor(168),G0tensor(169),G0tensor(170),G0tensor(171),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(7),mass3set(:,5),G0tensor(172),G0tensor(173),G0tensor(174),G0tensor(175),M2L1R1)
  call TI_triangle_red(G2tensor(12),RedBasis(7),mass3set(:,9),G0tensor(176),G0tensor(177),G0tensor(178), &
    G0tensor(179),M2L1R1,[nMZ],G0tensor(180))
  call TI_triangle_red(G3tensor(13),RedBasis(5),mass3set(:,11),G0tensor(181),G0tensor(182),G0tensor(183), &
    G0tensor(184),M2L1R1,[nMH,nMW,nMZ],G0tensor(185),G0tensor(186),G0tensor(187))
  call TI_triangle_red(G2tensor(38),RedBasis(9),mass3set(:,4),G0tensor(188),G0tensor(189),G0tensor(190), &
    G0tensor(191),M2L1R1,[nMZ,nMW],G0tensor(192),G0tensor(193))
  call TI_triangle_red(G2tensor(36),RedBasis(9),mass3set(:,2),G0tensor(194),G0tensor(195),G0tensor(196), &
    G0tensor(197),M2L1R1,[nMW],G0tensor(198))
  call TI_triangle_red(G3tensor(5),RedBasis(5),mass3set(:,12),G0tensor(199),G0tensor(200),G0tensor(201), &
    G0tensor(202),M2L1R1,[nME],G0tensor(203))
  call TI_triangle_red(G3tensor(6),RedBasis(5),mass3set(:,13),G0tensor(204),G0tensor(205),G0tensor(206), &
    G0tensor(207),M2L1R1,[nMM],G0tensor(208))
  call TI_triangle_red(G3tensor(7),RedBasis(5),mass3set(:,14),G0tensor(209),G0tensor(210),G0tensor(211), &
    G0tensor(212),M2L1R1,[nML],G0tensor(213))
  call TI_triangle_red(G3tensor(8),RedBasis(5),mass3set(:,15),G0tensor(214),G0tensor(215),G0tensor(216), &
    G0tensor(217),M2L1R1,[nME],G0tensor(218))
  call TI_triangle_red(G3tensor(9),RedBasis(5),mass3set(:,16),G0tensor(219),G0tensor(220),G0tensor(221), &
    G0tensor(222),M2L1R1,[nMM],G0tensor(223))
  call TI_triangle_red(G3tensor(10),RedBasis(5),mass3set(:,17),G0tensor(224),G0tensor(225),G0tensor(226), &
    G0tensor(227),M2L1R1,[nML],G0tensor(228))
  call TI_triangle_red(G3tensor(11),RedBasis(5),mass3set(:,18),G0tensor(229),G0tensor(230),G0tensor(231), &
    G0tensor(232),M2L1R1,[nMT,nMB],G0tensor(233),G0tensor(234))
  call TI_triangle_red(G3tensor(12),RedBasis(5),mass3set(:,19),G0tensor(235),G0tensor(236),G0tensor(237), &
    G0tensor(238),M2L1R1,[nMB,nMT],G0tensor(239),G0tensor(240))
  call TI_triangle_red(G3tensor(14),RedBasis(5),mass3set(:,20),G0tensor(241),G0tensor(242),G0tensor(243), &
    G0tensor(244),M2L1R1,[nMZ,nMW,nMH],G0tensor(245),G0tensor(246),G0tensor(247))
  call TI_triangle_red(G3tensor(15),RedBasis(5),mass3set(:,21),G0tensor(248),G0tensor(249),G0tensor(250), &
    G0tensor(251),M2L1R1,[nMW,nMH],G0tensor(252),G0tensor(253))
  call TI_triangle_red(G2tensor(41),RedBasis(4),mass3set(:,2),G0tensor(254),G0tensor(255),G0tensor(256), &
    G0tensor(257),M2L1R1,[nMW],G0tensor(258))
  call TI_triangle_red(G2tensor(43),RedBasis(4),mass3set(:,4),G0tensor(259),G0tensor(260),G0tensor(261), &
    G0tensor(262),M2L1R1,[nMZ,nMW],G0tensor(263),G0tensor(264))
  call TI_triangle_red(G2tensor(51),RedBasis(7),mass3set(:,2),G0tensor(265),G0tensor(266),G0tensor(267), &
    G0tensor(268),M2L1R1,[nMW],G0tensor(269))
  call ol_merge_tensors(T0sum(15),[G0tensor(1)])
  call ol_merge_tensors(T0sum(16),[G0tensor(26)])
  call ol_merge_tensors(T0sum(17),[G0tensor(51)])
  call ol_merge_tensors(T0sum(18),[G0tensor(40)])
  call ol_merge_tensors(T0sum(19),[G0tensor(57)])
  call ol_merge_tensors(T0sum(20),[G0tensor(12)])
  call ol_merge_tensors(T0sum(21),[G0tensor(67)])
  call ol_merge_tensors(T0sum(22),[G0tensor(3)])
  call ol_merge_tensors(T0sum(23),[G0tensor(28)])
  call ol_merge_tensors(T0sum(24),[G0tensor(33)])
  call ol_merge_tensors(T0sum(25),[G0tensor(39)])
  call ol_merge_tensors(T0sum(26),[G0tensor(69)])
  call ol_merge_tensors(T0sum(27),[G0tensor(24)])
  call ol_merge_tensors(T0sum(28),[G0tensor(72)])
  call ol_merge_tensors(T0sum(29),[G0tensor(76)])
  call ol_merge_tensors(T0sum(30),[G0tensor(81)])
  call ol_merge_tensors(T0sum(31),[G0tensor(86)])
  call ol_merge_tensors(T0sum(32),[G0tensor(91)])
  call ol_merge_tensors(T0sum(33),[G0tensor(97)])
  call ol_merge_tensors(T0sum(34),[G0tensor(102)])
  call ol_merge_tensors(T0sum(35),[G0tensor(107)])
  call ol_merge_tensors(T0sum(36),[G0tensor(113)])
  call ol_merge_tensors(T0sum(37),[G0tensor(118)])
  call ol_merge_tensors(T0sum(38),[G0tensor(122)])
  call ol_merge_tensors(T0sum(39),[G0tensor(127)])
  call ol_merge_tensors(T0sum(40),[G0tensor(132)])
  call ol_merge_tensors(T0sum(41),[G0tensor(137)])
  call ol_merge_tensors(T0sum(42),[G0tensor(141)])
  call ol_merge_tensors(T0sum(43),[G0tensor(146)])
  call ol_merge_tensors(T0sum(44),[G0tensor(151)])
  call ol_merge_tensors(T0sum(45),[G0tensor(157)])
  call ol_merge_tensors(T0sum(46),[G0tensor(162)])
  call ol_merge_tensors(T0sum(47),[G0tensor(168)])
  call ol_merge_tensors(T0sum(48),[G0tensor(172)])
  call ol_merge_tensors(T0sum(49),[G0tensor(176)])
  call ol_merge_tensors(T0sum(50),[G0tensor(7)])
  call ol_merge_tensors(T0sum(51),[G0tensor(8)])
  call ol_merge_tensors(T0sum(52),[G0tensor(181)])
  call ol_merge_tensors(T0sum(53),[G0tensor(10)])
  call ol_merge_tensors(T0sum(54),[G0tensor(188)])
  call ol_merge_tensors(T0sum(55),[G0tensor(23)])
  call ol_merge_tensors(T0sum(56),[G0tensor(25)])
  call ol_merge_tensors(T0sum(57),[G0tensor(194)])
  call ol_merge_tensors(T0sum(58),[G0tensor(199)])
  call ol_merge_tensors(T0sum(59),[G0tensor(204)])
  call ol_merge_tensors(T0sum(60),[G0tensor(209)])
  call ol_merge_tensors(T0sum(61),[G0tensor(214)])
  call ol_merge_tensors(T0sum(62),[G0tensor(219)])
  call ol_merge_tensors(T0sum(63),[G0tensor(224)])
  call ol_merge_tensors(T0sum(64),[G0tensor(229)])
  call ol_merge_tensors(T0sum(65),[G0tensor(235)])
  call ol_merge_tensors(T0sum(66),[G0tensor(241)])
  call ol_merge_tensors(T0sum(67),[G0tensor(248)])
  call ol_merge_tensors(T0sum(68),[G0tensor(254)])
  call ol_merge_tensors(T0sum(69),[G0tensor(259)])
  call ol_merge_tensors(T0sum(70),[G0tensor(265)])
  Gcoeff(:)%j = (-(c(33)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf4(:,1),G0H3(4),m4h3x4x3(:,1),heltab3x36(:,:,5))
  Gcoeff(:)%j = (-(c(6)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),wf4(:,1),ex4(:),G0H3(2),m4h4x3x3(:,1),heltab3x36(:,:,6))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[8,7],[nMW,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(26),m3h3x12(:,68),heltab2x36(:,:,89))
  Gcoeff(:)%j = (c(14)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[8,7],[nMW,nMZ],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(33),m3h3x12(:,69),heltab2x36(:,:,90))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[8,7],[nMW,0],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(1),m3h3x12(:,70),heltab2x36(:,:,91))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[8,7],[nMW,nMZ],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(6),m3h3x12(:,71),heltab2x36(:,:,92))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[12,3],[nMH,nMW],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(9),m4h3x3x4(:,5),heltab3x36(:,:,7))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[12,3],[nMZ,nMW],3,1,wf4(:,1))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(5),m4h3x3x4(:,6),heltab3x36(:,:,8))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[12,3],[0,nMW],3,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(1),m4h3x3x4(:,7),heltab3x36(:,:,9))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[12,3],[nMZ,nMW],3,1,wf4(:,1))
  call Hloop_WWV_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(6),m4h3x3x4(:,8),heltab3x36(:,:,10))
  Gcoeff(:)%j = (c(43)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[12,3],[0,nME],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(2),ngPnl,m3h9x4(:,12),heltab2x36(:,:,93))
  call Hloop_Q_A(ntryL,G0H4(2),12,0,G1H4(1),n2h4(4))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[12,3],[0,nMM],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(7),ngPnl,m3h9x4(:,13),heltab2x36(:,:,94))
  call Hloop_Q_A(ntryL,G0H4(7),12,0,G1H4(4),n2h4(5))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[12,3],[0,nML],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(3),ngPnl,m3h9x4(:,14),heltab2x36(:,:,95))
  call Hloop_Q_A(ntryL,G0H4(3),12,0,G1H4(5),n2h4(6))
  Gcoeff(:)%j = (-(c(42)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[12,3],[nMT,nMB],2,2,wf9(:,3),wf4(:,1))
  call Hloop_QS_A(ntryL,G0H36(1),wf9(:,3),G0H4(8),ngPtb,m3h9x4(:,15),heltab2x36(:,:,96))
  call Hloop_Q_A(ntryL,G0H4(8),12,nMT,G1H4(6),n2h4(7))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[12,3],[nMH,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(4),m3h9x4(:,16),heltab2x36(:,:,97))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[12,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(2),m3h9x4(:,17),heltab2x36(:,:,98))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[12,3],[0,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(7),m3h9x4(:,18),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(34)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[12,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,3),G0H4(3),m3h9x4(:,19),heltab2x36(:,:,100))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[12,3],[0,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(8),m3h9x4(:,20),heltab2x36(:,:,101))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[12,3],[nMZ,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,3),G0H4(10),m3h9x4(:,21),heltab2x36(:,:,102))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[12,3],[nMW,0],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),12,G1H4(7),m3h9x4(:,22),heltab2x36(:,:,103))
  Gcoeff(:)%j = (-(c(35)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[12,3],[nMW,nMZ],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),12,G1H4(3),m3h9x4(:,23),heltab2x36(:,:,104))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[12,3],[nMH,nMW],2,2,wf9(:,3),wf4(:,1))
  call Hloop_VS_T(ntryL,G0H36(1),0,wf9(:,3),12,G1H4(2),m3h9x4(:,24),heltab2x36(:,:,105))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[12,3],[0,nME],2,2,wf9(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,25),heltab2x36(:,:,106))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(8),n2h4(8))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[12,3],[0,nMM],2,2,wf9(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,26),heltab2x36(:,:,107))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(9),n2h4(9))
  Gcoeff(:)%j = (c(36)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[12,3],[0,nML],2,2,wf9(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,27),heltab2x36(:,:,108))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(10),n2h4(10))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[12,3],[0,0],2,2,wf9(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,28),heltab2x36(:,:,109))
  call Hloop_Q_A(ntryL,G0H4(11),12,0,G1H4(11),n2h4(11))
  Gcoeff(:)%j = (c(37)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[12,3],[nMT,nMB],2,2,wf9(:,1),wf4(:,1))
  call Hloop_QW_A(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,29),heltab2x36(:,:,110))
  call Hloop_Q_A(ntryL,G0H4(11),12,nMT,G1H4(12),n2h4(12))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[12,3],[nMH,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(13),m3h9x4(:,30),heltab2x36(:,:,111))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[12,3],[nMZ,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(14),m3h9x4(:,31),heltab2x36(:,:,112))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[12,3],[0,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(15),m3h9x4(:,32),heltab2x36(:,:,113))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[12,3],[nMZ,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(16),m3h9x4(:,33),heltab2x36(:,:,114))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[12,3],[0,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,1),G1H4(17),m3h9x4(:,34),heltab2x36(:,:,115))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[12,3],[nMZ,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,wf9(:,1),G1H4(18),m3h9x4(:,35),heltab2x36(:,:,116))
  Gcoeff(:)%j = (-(c(18)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[12,3],[0,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(19),m3h9x4(:,36),heltab2x36(:,:,117))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[12,3],[nMZ,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(20),m3h9x4(:,37),heltab2x36(:,:,118))
  Gcoeff(:)%j = (c(23)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[12,3],[nMW,0],2,2,wf9(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,1),G0H4(11),m3h9x4(:,38),heltab2x36(:,:,119))
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[12,3],[nMW,nMZ],2,2,wf9(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,1),G0H4(12),m3h9x4(:,39),heltab2x36(:,:,120))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[12,3],[nMH,nMW],2,2,wf9(:,1),wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),wf9(:,1),G0H4(13),m3h9x4(:,40),heltab2x36(:,:,121))
  Gcoeff(:)%j = (-(c(27)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[10,5],[0,0],2,2,wf6(:,13),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,13),G0H6(9),m3h6x6(:,11),heltab2x36(:,:,122))
  call Hloop_Q_A(ntryL,G0H6(9),10,0,G1H6(19),n2h6(29))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[10,5],[0,nMZ],2,2,wf6(:,13),wf6(:,3))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,13),G0H6(1),ngZu,m3h6x6(:,12),heltab2x36(:,:,123))
  call Hloop_Q_A(ntryL,G0H6(1),10,0,G1H6(20),n2h6(30))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[10,5],[0,nMW],2,2,wf6(:,13),wf6(:,3))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,13),G0H6(5),m3h6x6(:,13),heltab2x36(:,:,124))
  call Hloop_Q_A(ntryL,G0H6(5),10,0,G1H6(2),n2h6(31))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[10,5],[0,0],2,2,wf6(:,13),wf6(:,3))
  call Hloop_VQ_A(ntryL,G0H36(1),wf6(:,13),G0H6(4),m3h6x6(:,14),heltab2x36(:,:,125))
  call Hloop_Q_A(ntryL,G0H6(4),10,0,G1H6(13),n2h6(32))
  Gcoeff(:)%j = (-(c(24)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[9,6],[0,0],2,2,wf6(:,6),wf6(:,11))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(2),m3h6x6(:,15),heltab2x36(:,:,126))
  Gcoeff(:)%j = (-(c(29)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[9,6],[nMZ,0],2,2,wf6(:,6),wf6(:,11))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,6),G0H6(3),ngZd,m3h6x6(:,16),heltab2x36(:,:,127))
  Gcoeff(:)%j = (-(c(13)*M(1,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[9,6],[nMW,0],2,2,wf6(:,6),wf6(:,11))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,6),G0H6(8),m3h6x6(:,17),heltab2x36(:,:,128))
  Gcoeff(:)%j = (-(c(30)*M(2,:)%j)) * den(9)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[9,6],[0,0],2,2,wf6(:,6),wf6(:,11))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,6),G0H6(6),m3h6x6(:,18),heltab2x36(:,:,129))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(13),[G0H4(4),G0H4(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(14),[G0H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(19),[G0H4(8),G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(20),[G0H4(10),G0H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(16),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(17),[G0H4(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(18),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G0H4(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(3),[G0H4(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(2),[G0H4(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(13),[G1H6(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(6),[G0H6(2)])
  call Hcheck_last_TV_S(ntryL,l_switch,G0H3(4),11,ex3(:),4,G1tensor(43),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G0H3(2),11,ex3(:),4,G1tensor(48),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(26),ex3(:),wf4(:,1),G1tensor(53),m4h3x4x1(:,1),heltab3x12(:,:,1))
  call Hcheck_last_SVV_S(ntryL,l_switch,G1H12(33),ex3(:),wf4(:,1),G1tensor(58),m4h3x4x1(:,2),heltab3x12(:,:,2))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(1),wf4(:,1),ex3(:),G1tensor(27),m4h4x3x1(:,1),heltab3x12(:,:,3))
  call Hcheck_last_WWV_V(ntryL,l_switch,G1H12(6),wf4(:,1),ex3(:),G1tensor(17),m4h4x3x1(:,2),heltab3x12(:,:,4))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(13),12,wf4(:,1),3,G2tensor(29),m3h4x1(:,1),heltab2x4(:,:,7))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H4(14),12,wf4(:,1),3,G2tensor(2),m3h4x1(:,2),heltab2x4(:,:,8))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(19),12,wf4(:,1),3,G2tensor(4),m3h4x1(:,3),heltab2x4(:,:,9))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H4(20),12,wf4(:,1),3,G2tensor(32),m3h4x1(:,4),heltab2x4(:,:,10))
  call Hloop_QW_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nME,G2tensor(6),n2h1(39))
  call Hloop_QW_A(ntryL,G1H4(9),wf4(:,1),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMM,G2tensor(8),n2h1(40))
  call Hloop_QW_A(ntryL,G1H4(10),wf4(:,1),G1H1(1),m3h4x1(:,7),heltab2x4(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nML,G2tensor(11),n2h1(41))
  call Hloop_QW_A(ntryL,G1H4(12),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(14),n2h1(42))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(16),12,wf4(:,1),3,G2tensor(17),m3h4x1(:,9),heltab2x4(:,:,15))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(17),12,wf4(:,1),G2tensor(20),m3h4x1(:,10),heltab2x4(:,:,16))
  call Hcheck_last_DV_C(ntryL,l_switch,G1H4(18),12,wf4(:,1),G2tensor(22),m3h4x1(:,11),heltab2x4(:,:,17))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(7),wf4(:,1),G1tensor(32),m3h4x1(:,12),heltab2x4(:,:,18))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(3),wf4(:,1),G1tensor(37),m3h4x1(:,13),heltab2x4(:,:,19))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H4(2),wf4(:,1),G1tensor(22),m3h4x1(:,14),heltab2x4(:,:,20))
  call Hloop_QW_A(ntryL,G1H4(11),wf4(:,1),G1H1(1),m3h4x1(:,15),heltab2x4(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(43))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(15),12,wf4(:,1),3,G2tensor(25),m3h4x1(:,16),heltab2x4(:,:,22))
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(13),wf6(:,3),G1tensor(42),m3h6x1(:,13),heltab2x6(:,:,54))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(20),wf6(:,3),G1tensor(44),ngZu,m3h6x1(:,14),heltab2x6(:,:,55))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(2),wf6(:,3),G1tensor(47),m3h6x1(:,15),heltab2x6(:,:,56))
  call Hloop_VQ_A(ntryL,G0H6(6),wf6(:,11),G0H1(1),m3h6x1(:,16),heltab2x6(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(49),n2h1(44))
  call Hloop_ZQ_A(ntryL,G0H6(3),wf6(:,11),G0H1(1),ngZd,m3h6x1(:,17),heltab2x6(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(52),n2h1(45))
  call Hloop_WQ_A(ntryL,G0H6(8),wf6(:,11),G0H1(1),m3h6x1(:,18),heltab2x6(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(3),n2h1(46))
  call ol_merge_tensors(G0tensor(119),[G0tensor(87),G0tensor(73),G0tensor(9),G0tensor(2),G0tensor(6)])
  call ol_merge_tensors(G0tensor(125),[G0tensor(116),G0tensor(61),G0tensor(11)])
  call ol_merge_tensors(G0tensor(130),[G0tensor(105),G0tensor(37),G0tensor(16)])
  call ol_merge_tensors(G0tensor(269),[G0tensor(264),G0tensor(258),G0tensor(252),G0tensor(246),G0tensor(198),G0tensor(193) &
    ,G0tensor(186),G0tensor(167),G0tensor(155),G0tensor(145),G0tensor(136),G0tensor(131),G0tensor(126),G0tensor(117),G0tensor(111) &
    ,G0tensor(106),G0tensor(101),G0tensor(95),G0tensor(90),G0tensor(63),G0tensor(48),G0tensor(38),G0tensor(43),G0tensor(55) &
    ,G0tensor(35),G0tensor(46),G0tensor(21)])
  call ol_merge_tensors(G0tensor(195),[G0tensor(189),G0tensor(133),G0tensor(45),G0tensor(31)])
  call ol_merge_tensors(G1tensor(49),[G0tensor(175),G0tensor(140),G0tensor(74),G0tensor(36)])
  call ol_merge_tensors(G1tensor(27),[G0tensor(257),G0tensor(144),G0tensor(41)])
  call ol_merge_tensors(G0tensor(147),[G0tensor(92),G0tensor(17),G0tensor(56)])
  call ol_merge_tensors(G0tensor(154),[G0tensor(110),G0tensor(54),G0tensor(66)])
  call ol_merge_tensors(G0tensor(263),[G0tensor(245),G0tensor(192),G0tensor(187),G0tensor(180),G0tensor(166),G0tensor(161) &
    ,G0tensor(156),G0tensor(150),G0tensor(112),G0tensor(96),G0tensor(85),G0tensor(80),G0tensor(68),G0tensor(49),G0tensor(14) &
    ,G0tensor(13),G0tensor(52),G0tensor(20)])
  call ol_merge_tensors(G0tensor(160),[G0tensor(30)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(58),G0tensor(262),G0tensor(244),G0tensor(165),G0tensor(50)])
  call ol_merge_tensors(G0tensor(196),[G0tensor(173),G0tensor(143),G0tensor(139),G0tensor(22),G0tensor(34),G0tensor(18) &
    ,G0tensor(15),G0tensor(60)])
  call ol_merge_tensors(G2tensor(23),[G0tensor(169),G0tensor(79),G0tensor(71),G0tensor(27),G0tensor(5)])
  call ol_merge_tensors(G1tensor(42),[G0tensor(256),G0tensor(128),G0tensor(121),G0tensor(62)])
  call ol_merge_tensors(G0tensor(171),[G0tensor(84),G0tensor(75),G0tensor(29),G0tensor(65)])
  call ol_merge_tensors(G0tensor(190),[G0tensor(164),G0tensor(159),G0tensor(19),G0tensor(70)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(149),G0tensor(4)])
  call ol_merge_tensors(G0tensor(98),[G0tensor(42),G0tensor(53)])
  call ol_merge_tensors(G2tensor(25),[G2tensor(20),G2tensor(4),G0tensor(103),G0tensor(89),G0tensor(32)])
  call ol_merge_tensors(G1tensor(47),[G0tensor(100),G0tensor(59),G0tensor(47)])
  call ol_merge_tensors(G0tensor(177),[G0tensor(78),G0tensor(64),G0tensor(58)])
  call ol_merge_tensors(G2tensor(22),[G2tensor(17),G2tensor(32),G2tensor(2),G0tensor(108),G0tensor(94),G0tensor(44)])
  call ol_merge_tensors(G0tensor(82),[G0tensor(77)])
  call ol_merge_tensors(G1tensor(52),[G0tensor(179),G0tensor(83)])
  call ol_merge_tensors(G0tensor(153),[G0tensor(129),G0tensor(124),G0tensor(114),G0tensor(93),G0tensor(88)])
  call ol_merge_tensors(G1tensor(48),[G1tensor(43),G0tensor(250),G0tensor(115),G0tensor(109),G0tensor(104),G0tensor(99)])
  call ol_merge_tensors(G0tensor(267),[G0tensor(211),G0tensor(206),G0tensor(201),G0tensor(178),G0tensor(174),G0tensor(170) &
    ,G0tensor(158),G0tensor(148),G0tensor(138),G0tensor(134),G0tensor(123),G0tensor(120)])
  call ol_merge_tensors(G0tensor(163),[G0tensor(142),G0tensor(135)])
  call ol_merge_tensors(G1tensor(37),[G0tensor(191),G0tensor(182)])
  call ol_merge_tensors(G1tensor(53),[G0tensor(184)])
  call ol_merge_tensors(G0tensor(253),[G0tensor(247),G0tensor(185)])
  call ol_merge_tensors(G1tensor(32),[G0tensor(197)])
  call ol_merge_tensors(G0tensor(218),[G0tensor(203)])
  call ol_merge_tensors(G0tensor(223),[G0tensor(208)])
  call ol_merge_tensors(G0tensor(228),[G0tensor(213)])
  call ol_merge_tensors(G2tensor(6),[G0tensor(215)])
  call ol_merge_tensors(G2tensor(8),[G0tensor(220)])
  call ol_merge_tensors(G2tensor(11),[G0tensor(225)])
  call ol_merge_tensors(G0tensor(240),[G0tensor(233)])
  call ol_merge_tensors(G0tensor(239),[G0tensor(234)])
  call ol_merge_tensors(G2tensor(14),[G0tensor(236)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(22),G0tensor(249)])
  call ol_merge_tensors(G0tensor(266),[G0tensor(260),G0tensor(255)])
  call ol_merge_tensors(G1tensor(44),[G0tensor(261)])
  call ol_merge_tensors(G1tensor(3),[G0tensor(268)])
call TI_bubble_red(G2tensor(23),12,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(25),12,mass2set(:,2),G0tensor(26),M2L1R1,G0tensor(51))
call TI_bubble_red(G2tensor(22),12,mass2set(:,3),G0tensor(40),M2L1R1,G0tensor(57),G0tensor(12))
call TI_bubble_red(G2tensor(6),12,mass2set(:,4),G0tensor(67),M2L1R1,G0tensor(3))
call TI_bubble_red(G2tensor(8),12,mass2set(:,5),G0tensor(28),M2L1R1,G0tensor(33))
call TI_bubble_red(G2tensor(11),12,mass2set(:,6),G0tensor(39),M2L1R1,G0tensor(69))
call TI_bubble_red(G2tensor(14),12,mass2set(:,7),G0tensor(24),M2L1R1,G0tensor(72),G0tensor(76))
call TI_bubble_red(G2tensor(29),12,mass2set(:,8),G0tensor(81),M2L1R1,G0tensor(86),G0tensor(91))
  call ol_merge_tensors(G0tensor(86),[G0tensor(57),G0tensor(51),G0tensor(269)])
  call ol_merge_tensors(G0tensor(12),[G0tensor(263)])
  call ol_merge_tensors(G0tensor(91),[G0tensor(253)])
  call ol_merge_tensors(G0tensor(3),[G0tensor(218)])
  call ol_merge_tensors(G0tensor(33),[G0tensor(223)])
  call ol_merge_tensors(G0tensor(69),[G0tensor(228)])
  call ol_merge_tensors(G0tensor(76),[G0tensor(240)])
  call ol_merge_tensors(G0tensor(72),[G0tensor(239)])
call TI_bubble_red(G1tensor(49),9,mass2set(:,1),G0tensor(97),M2L1R1)
call TI_bubble_red(G1tensor(27),8,mass2set(:,9),G0tensor(102),M2L1R1,G0tensor(107))
call TI_bubble_red(G1tensor(17),8,mass2set(:,10),G0tensor(113),M2L1R1,G0tensor(118),G0tensor(122))
call TI_bubble_red(G1tensor(42),10,mass2set(:,1),G0tensor(127),M2L1R1)
call TI_bubble_red(G1tensor(47),10,mass2set(:,2),G0tensor(132),M2L1R1,G0tensor(137))
call TI_bubble_red(G1tensor(52),9,mass2set(:,11),G0tensor(141),M2L1R1,G0tensor(146))
call TI_bubble_red(G1tensor(48),11,mass2set(:,12),G0tensor(151),M2L1R1,G0tensor(157))
call TI_bubble_red(G1tensor(37),12,mass2set(:,10),G0tensor(162),M2L1R1,G0tensor(168),G0tensor(172))
call TI_bubble_red(G1tensor(53),8,mass2set(:,13),G0tensor(176),M2L1R1,G0tensor(7),G0tensor(8))
call TI_bubble_red(G1tensor(32),12,mass2set(:,9),G0tensor(181),M2L1R1,G0tensor(10))
call TI_bubble_red(G1tensor(44),10,mass2set(:,14),G0tensor(188),M2L1R1,G0tensor(23))
call TI_bubble_red(G1tensor(3),9,mass2set(:,9),G0tensor(25),M2L1R1,G0tensor(194))
  call ol_merge_tensors(G0tensor(194),[G0tensor(10),G0tensor(8),G0tensor(172),G0tensor(157),G0tensor(137),G0tensor(122) &
    ,G0tensor(107),G0tensor(86)])
  call ol_merge_tensors(G0tensor(23),[G0tensor(168),G0tensor(146),G0tensor(118),G0tensor(12)])
  call ol_merge_tensors(G0tensor(91),[G0tensor(7)])
  call ol_merge_tensors(T0sum(71),[G0tensor(119)])
  call ol_merge_tensors(T0sum(72),[G0tensor(125)])
  call ol_merge_tensors(T0sum(73),[G0tensor(130)])
  call ol_merge_tensors(T0sum(74),[G0tensor(194)])
  call ol_merge_tensors(T0sum(75),[G0tensor(195)])
  call ol_merge_tensors(T0sum(76),[G0tensor(97)])
  call ol_merge_tensors(T0sum(77),[G0tensor(102)])
  call ol_merge_tensors(T0sum(78),[G0tensor(147)])
  call ol_merge_tensors(T0sum(79),[G0tensor(154)])
  call ol_merge_tensors(T0sum(80),[G0tensor(23)])
  call ol_merge_tensors(T0sum(81),[G0tensor(160)])
  call ol_merge_tensors(T0sum(82),[G0tensor(113)])
  call ol_merge_tensors(T0sum(83),[G0tensor(196)])
  call ol_merge_tensors(T0sum(84),[G0tensor(1)])
  call ol_merge_tensors(T0sum(85),[G0tensor(127)])
  call ol_merge_tensors(T0sum(86),[G0tensor(171)])
  call ol_merge_tensors(T0sum(87),[G0tensor(190)])
  call ol_merge_tensors(T0sum(88),[G0tensor(152)])
  call ol_merge_tensors(T0sum(89),[G0tensor(98)])
  call ol_merge_tensors(T0sum(90),[G0tensor(26)])
  call ol_merge_tensors(T0sum(91),[G0tensor(132)])
  call ol_merge_tensors(T0sum(92),[G0tensor(177)])
  call ol_merge_tensors(T0sum(93),[G0tensor(40)])
  call ol_merge_tensors(T0sum(94),[G0tensor(82)])
  call ol_merge_tensors(T0sum(95),[G0tensor(141)])
  call ol_merge_tensors(T0sum(96),[G0tensor(153)])
  call ol_merge_tensors(T0sum(97),[G0tensor(151)])
  call ol_merge_tensors(T0sum(98),[G0tensor(267)])
  call ol_merge_tensors(T0sum(99),[G0tensor(163)])
  call ol_merge_tensors(T0sum(100),[G0tensor(162)])
  call ol_merge_tensors(T0sum(101),[G0tensor(183)])
  call ol_merge_tensors(T0sum(102),[G0tensor(176)])
  call ol_merge_tensors(T0sum(103),[G0tensor(91)])
  call ol_merge_tensors(T0sum(104),[G0tensor(181)])
  call ol_merge_tensors(T0sum(105),[G0tensor(200)])
  call ol_merge_tensors(T0sum(106),[G0tensor(202)])
  call ol_merge_tensors(T0sum(107),[G0tensor(3)])
  call ol_merge_tensors(T0sum(108),[G0tensor(205)])
  call ol_merge_tensors(T0sum(109),[G0tensor(207)])
  call ol_merge_tensors(T0sum(110),[G0tensor(33)])
  call ol_merge_tensors(T0sum(111),[G0tensor(210)])
  call ol_merge_tensors(T0sum(112),[G0tensor(212)])
  call ol_merge_tensors(T0sum(113),[G0tensor(69)])
  call ol_merge_tensors(T0sum(114),[G0tensor(67)])
  call ol_merge_tensors(T0sum(115),[G0tensor(216)])
  call ol_merge_tensors(T0sum(116),[G0tensor(217)])
  call ol_merge_tensors(T0sum(117),[G0tensor(28)])
  call ol_merge_tensors(T0sum(118),[G0tensor(221)])
  call ol_merge_tensors(T0sum(119),[G0tensor(222)])
  call ol_merge_tensors(T0sum(120),[G0tensor(39)])
  call ol_merge_tensors(T0sum(121),[G0tensor(226)])
  call ol_merge_tensors(T0sum(122),[G0tensor(227)])
  call ol_merge_tensors(T0sum(123),[G0tensor(230)])
  call ol_merge_tensors(T0sum(124),[G0tensor(231)])
  call ol_merge_tensors(T0sum(125),[G0tensor(232)])
  call ol_merge_tensors(T0sum(126),[G0tensor(76)])
  call ol_merge_tensors(T0sum(127),[G0tensor(72)])
  call ol_merge_tensors(T0sum(128),[G0tensor(24)])
  call ol_merge_tensors(T0sum(129),[G0tensor(237)])
  call ol_merge_tensors(T0sum(130),[G0tensor(238)])
  call ol_merge_tensors(T0sum(131),[G0tensor(242)])
  call ol_merge_tensors(T0sum(132),[G0tensor(243)])
  call ol_merge_tensors(T0sum(133),[G0tensor(81)])
  call ol_merge_tensors(T0sum(134),[G0tensor(251)])
  call ol_merge_tensors(T0sum(135),[G0tensor(266)])
  call ol_merge_tensors(T0sum(136),[G0tensor(188)])
  call ol_merge_tensors(T0sum(137),[G0tensor(25)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvv_ew_uxdzwx_1_/**/REALKIND
