
module ol_vamp_1_ppvv_ew_bbxzz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvv_ew_bbxzz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvv_ew_bbxzz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvv_ew_bbxzz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvv_ew_bbxzz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvv_ew_bbxzz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvv_ew_bbxzz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(36)
  type(Hpolcont), intent(in) :: M(2,36)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMB,nMH,nMB,nMB],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZd,m3h3x12(:,1),heltab2x36(:,:,1))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(2),h0tab(:,2),[8,2,1,4],[nMB,nMZ,nMB,nMB],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZd,m3h3x12(:,2),heltab2x36(:,:,2))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(3),h0tab(:,3),[8,2,1,4],[nMT,nMW,nMT,nMT],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZu,m3h3x12(:,3),heltab2x36(:,:,3))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMT,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(4),h0tab(:,4),[8,2,1,4],[nMH,nMB,nMH,nMZ],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(4),m3h3x12(:,4),heltab2x36(:,:,4))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(5),h0tab(:,5),[8,2,1,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(5),m3h3x12(:,5),heltab2x36(:,:,5))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(6),h0tab(:,6),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(6),m3h3x12(:,6),heltab2x36(:,:,6))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(7),h0tab(:,7),[8,2,1,4],[nMB,0,nMB,nMB],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZd,m3h3x12(:,7),heltab2x36(:,:,7))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(7),n2h12(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(8),h0tab(:,8),[8,2,1,4],[nMB,nMZ,nMB,nMB],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZd,m3h3x12(:,8),heltab2x36(:,:,8))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(8),n2h12(5))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(9),h0tab(:,9),[8,2,1,4],[nMT,nMW,nMT,nMT],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZu,m3h3x12(:,9),heltab2x36(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMT,G1H12(9),n2h12(6))
  Gcoeff(:)%j = (c(4)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(10),h0tab(:,10),[8,2,1,4],[nMB,0,nMB,nMB],4,0)
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(1),ngZd,m3h3x12(:,10),heltab2x36(:,:,10))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(10),n2h12(7))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(11),h0tab(:,11),[8,2,1,4],[nMH,nMB,nMH,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,11),heltab2x36(:,:,11))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(12),h0tab(:,12),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,12),heltab2x36(:,:,12))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(13),h0tab(:,13),[8,2,1,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,13),heltab2x36(:,:,13))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(14),h0tab(:,14),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,14),heltab2x36(:,:,14))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(15),h0tab(:,15),[8,2,1,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(11),m3h3x12(:,15),heltab2x36(:,:,15))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(16),h0tab(:,16),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(12),m3h3x12(:,16),heltab2x36(:,:,16))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(17),h0tab(:,17),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(13),m3h3x12(:,17),heltab2x36(:,:,17))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(18),h0tab(:,18),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,18),heltab2x36(:,:,18))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(19),h0tab(:,19),[8,2,1,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,19),heltab2x36(:,:,19))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(20),h0tab(:,20),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,20),heltab2x36(:,:,20))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(21),h0tab(:,21),[8,2,1,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(14),m3h3x12(:,21),heltab2x36(:,:,21))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(22),h0tab(:,22),[8,1,2,4],[nMB,nMH,nMB,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,22),heltab2x36(:,:,22))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(15),n2h12(8))
  Gcoeff(:)%j = (c(52)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(23),h0tab(:,23),[8,1,2,4],[nMB,nMZ,nMB,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,23),heltab2x36(:,:,23))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(16),n2h12(9))
  Gcoeff(:)%j = (c(51)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(24),h0tab(:,24),[8,1,2,4],[nMT,nMW,nMT,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZu,m3h3x12(:,24),heltab2x36(:,:,24))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMT,G1H12(17),n2h12(10))
  Gcoeff(:)%j = (c(20)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(25),h0tab(:,25),[8,1,2,4],[nMH,nMB,nMH,nMZ],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(18),m3h3x12(:,25),heltab2x36(:,:,25))
  Gcoeff(:)%j = (-(c(20)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(26),h0tab(:,26),[8,1,2,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(19),m3h3x12(:,26),heltab2x36(:,:,26))
  Gcoeff(:)%j = (-(c(62)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(27),h0tab(:,27),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(20),m3h3x12(:,27),heltab2x36(:,:,27))
  Gcoeff(:)%j = (c(1)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(28),h0tab(:,28),[8,1,2,4],[nMB,0,nMB,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,28),heltab2x36(:,:,28))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(21),n2h12(11))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(29),h0tab(:,29),[8,1,2,4],[nMB,nMZ,nMB,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,29),heltab2x36(:,:,29))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(22),n2h12(12))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(30),h0tab(:,30),[8,1,2,4],[nMT,nMW,nMT,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZu,m3h3x12(:,30),heltab2x36(:,:,30))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMT,G1H12(23),n2h12(13))
  Gcoeff(:)%j = (c(4)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(31),h0tab(:,31),[8,1,2,4],[nMB,0,nMB,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,31),heltab2x36(:,:,31))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(24),n2h12(14))
  Gcoeff(:)%j = (c(17)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(32),h0tab(:,32),[8,1,2,4],[nMH,nMB,nMH,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,32),heltab2x36(:,:,32))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(33),h0tab(:,33),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,33),heltab2x36(:,:,33))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(34),h0tab(:,34),[8,1,2,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(25),m3h3x12(:,34),heltab2x36(:,:,34))
  Gcoeff(:)%j = (-(c(60)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(35),h0tab(:,35),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(26),m3h3x12(:,35),heltab2x36(:,:,35))
  Gcoeff(:)%j = (c(40)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(36),h0tab(:,36),[8,1,2,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(10),m3h3x12(:,36),heltab2x36(:,:,36))
  Gcoeff(:)%j = (c(60)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(37),h0tab(:,37),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(11),m3h3x12(:,37),heltab2x36(:,:,37))
  Gcoeff(:)%j = (-(c(44)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(38),h0tab(:,38),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,38),heltab2x36(:,:,38))
  Gcoeff(:)%j = (c(44)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(39),h0tab(:,39),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(27),m3h3x12(:,39),heltab2x36(:,:,39))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(40),h0tab(:,40),[8,1,2,4],[nMZ,nMB,nMZ,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(13),m3h3x12(:,40),heltab2x36(:,:,40))
  Gcoeff(:)%j = (-(c(8)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(41),h0tab(:,41),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(14),m3h3x12(:,41),heltab2x36(:,:,41))
  Gcoeff(:)%j = (c(11)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(42),h0tab(:,42),[8,1,2,4],[nMW,nMT,nMW,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(28),m3h3x12(:,42),heltab2x36(:,:,42))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(43),h0tab(:,43),[8,1,4,2],[nMH,nMB,nMB,nMZ],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(29),m3h3x12(:,43),heltab2x36(:,:,43))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(44),h0tab(:,44),[8,1,4,2],[nMZ,nMB,nMB,nMH],4,0)
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(30),m3h3x12(:,44),heltab2x36(:,:,44))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(45),h0tab(:,45),[8,1,4,2],[nMW,nMT,nMT,nMW],4,0)
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(31),m3h3x12(:,45),heltab2x36(:,:,45))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(46),h0tab(:,46),[8,1,4,2],[nMB,nMH,nMZ,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(15),ngZd,m3h3x12(:,46),heltab2x36(:,:,46))
  call Hloop_A_Q(ntryL,G0H12(15),8,nMB,G1H12(32),n2h12(15))
  Gcoeff(:)%j = (c(41)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(47),h0tab(:,47),[8,1,4,2],[nMB,nMZ,nMH,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(15),ngZd,m3h3x12(:,47),heltab2x36(:,:,47))
  call Hloop_A_Q(ntryL,G0H12(15),8,nMB,G1H12(33),n2h12(16))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(48),h0tab(:,48),[8,1,4,2],[nMT,nMW,nMW,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(15),ngZu,m3h3x12(:,48),heltab2x36(:,:,48))
  call Hloop_A_Q(ntryL,G0H12(15),8,nMT,G1H12(34),n2h12(17))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(49),h0tab(:,49),[8,1,4,2],[nMH,nMB,nMB,nMZ],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(15),m3h3x12(:,49),heltab2x36(:,:,49))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(50),h0tab(:,50),[8,1,4,2],[nMW,nMT,nMT,nMW],4,0)
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(16),m3h3x12(:,50),heltab2x36(:,:,50))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(51),h0tab(:,51),[8,1,4,2],[nMZ,nMB,nMB,nMH],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(17),m3h3x12(:,51),heltab2x36(:,:,51))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(52),h0tab(:,52),[8,1,4,2],[nMW,nMT,nMT,nMW],4,0)
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(18),m3h3x12(:,52),heltab2x36(:,:,52))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(53),h0tab(:,53),[8,1,4,2],[nMB,nMH,nMZ,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZd,m3h3x12(:,53),heltab2x36(:,:,53))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMB,G1H12(35),n2h12(18))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(54),h0tab(:,54),[8,1,4,2],[nMT,nMW,nMW,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZu,m3h3x12(:,54),heltab2x36(:,:,54))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMT,G1H12(36),n2h12(19))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(55),h0tab(:,55),[8,1,4,2],[nMB,nMZ,nMH,nMB],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZd,m3h3x12(:,55),heltab2x36(:,:,55))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMB,G1H12(37),n2h12(20))
  Gcoeff(:)%j = (c(56)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(56),h0tab(:,56),[8,1,4,2],[nMT,nMW,nMW,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZu,m3h3x12(:,56),heltab2x36(:,:,56))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMT,G1H12(38),n2h12(21))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(57),h0tab(:,57),[8,1,4,2],[nMW,nMT,nMT,nMW],4,0)
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(39),m3h3x12(:,57),heltab2x36(:,:,57))
  Gcoeff(:)%j = (c(38)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(58),h0tab(:,58),[8,1,4,2],[nMT,nMW,nMW,nMT],4,0)
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZu,m3h3x12(:,58),heltab2x36(:,:,58))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMT,G1H12(40),n2h12(22))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(10),[G1H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(24),[G1H12(21)])
  call Hloop_QA_S(ntryL,G1H12(1),ex2(:),G1H6(1),ngH,m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_S(ntryL,G1H12(2),ex2(:),G1H6(2),ngX,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_QA_S(ntryL,G1H12(3),ex2(:),G1H6(3),ngPbt,m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_SA_Q(ntryL,G1H12(4),ex2(:),G1H6(4),ngH,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G1H6(4),10,nMB,G2H6(1),n2h6(1))
  call Hloop_SA_Q(ntryL,G1H12(5),ex2(:),G1H6(4),ngX,m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H6(4),10,nMB,G2H6(2),n2h6(2))
  call Hloop_SA_Q(ntryL,G1H12(6),ex2(:),G1H6(4),ngPbt,m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_A_Q(ntryL,G1H6(4),10,nMT,G2H6(3),n2h6(3))
  call Hloop_QA_V(ntryL,G1H12(10),ex2(:),G1H6(4),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_QA_Z(ntryL,G1H12(8),ex2(:),G1H6(5),ngZd,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_QA_W(ntryL,G1H12(9),ex2(:),G1H6(6),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_SA_Q(ntryL,G0H12(1),ex2(:),G0H6(1),ngH,m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(7),n2h6(4))
  call Hloop_SA_Q(ntryL,G0H12(2),ex2(:),G0H6(1),ngPbt,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMT,G1H6(8),n2h6(5))
  call Hloop_ZA_Q(ntryL,G0H12(3),ex2(:),G0H6(1),ngZd,m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(9),n2h6(6))
  call Hloop_WA_Q(ntryL,G0H12(4),ex2(:),G0H6(1),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMT,G1H6(10),n2h6(7))
  call Hloop_SA_Q(ntryL,G1H12(11),ex2(:),G1H6(11),ngX,m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_A_Q(ntryL,G1H6(11),10,nMB,G2H6(4),n2h6(8))
  call Hloop_SA_Q(ntryL,G1H12(12),ex2(:),G1H6(11),ngPbt,m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_A_Q(ntryL,G1H6(11),10,nMT,G2H6(5),n2h6(9))
  call Hloop_WA_Q(ntryL,G1H12(13),ex2(:),G1H6(11),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_A_Q(ntryL,G1H6(11),10,nMT,G2H6(6),n2h6(10))
  call Hloop_SA_Q(ntryL,G0H12(5),ex2(:),G0H6(1),ngPbt,m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMT,G1H6(11),n2h6(11))
  call Hloop_ZA_Q(ntryL,G0H12(6),ex2(:),G0H6(1),ngZd,m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(12),n2h6(12))
  call Hloop_WA_Q(ntryL,G0H12(7),ex2(:),G0H6(1),m3h2x6(:,19),heltab2x12(:,:,19))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMT,G1H6(13),n2h6(13))
  call Hloop_WA_Q(ntryL,G1H12(14),ex2(:),G1H6(14),m3h2x6(:,20),heltab2x12(:,:,20))
  call Hloop_A_Q(ntryL,G1H6(14),10,nMT,G2H6(7),n2h6(14))
  call Hloop_AQ_S(ntryL,G1H12(15),ex1(:),G1H6(14),ngH,m3h2x6(:,21),heltab2x12(:,:,21))
  call Hloop_AQ_S(ntryL,G1H12(16),ex1(:),G1H6(15),ngX,m3h2x6(:,22),heltab2x12(:,:,22))
  call Hloop_AQ_S(ntryL,G1H12(17),ex1(:),G1H6(16),ngPtb,m3h2x6(:,23),heltab2x12(:,:,23))
  call Hloop_SQ_A(ntryL,G1H12(18),ex1(:),G1H6(17),ngH,m3h2x6(:,24),heltab2x12(:,:,24))
  call Hloop_Q_A(ntryL,G1H6(17),9,nMB,G2H6(8),n2h6(15))
  call Hloop_SQ_A(ntryL,G1H12(19),ex1(:),G1H6(17),ngX,m3h2x6(:,25),heltab2x12(:,:,25))
  call Hloop_Q_A(ntryL,G1H6(17),9,nMB,G2H6(9),n2h6(16))
  call Hloop_SQ_A(ntryL,G1H12(20),ex1(:),G1H6(17),ngPtb,m3h2x6(:,26),heltab2x12(:,:,26))
  call Hloop_Q_A(ntryL,G1H6(17),9,nMT,G2H6(10),n2h6(17))
  call Hloop_AQ_V(ntryL,G1H12(24),ex1(:),G1H6(17),m3h2x6(:,27),heltab2x12(:,:,27))
  call Hloop_AQ_Z(ntryL,G1H12(22),ex1(:),G1H6(18),ngZd,m3h2x6(:,28),heltab2x12(:,:,28))
  call Hloop_AQ_W(ntryL,G1H12(23),ex1(:),G1H6(19),m3h2x6(:,29),heltab2x12(:,:,29))
  call Hloop_SQ_A(ntryL,G0H12(8),ex1(:),G0H6(1),ngH,m3h2x6(:,30),heltab2x12(:,:,30))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(20),n2h6(18))
  call Hloop_SQ_A(ntryL,G0H12(9),ex1(:),G0H6(1),ngPtb,m3h2x6(:,31),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(21),n2h6(19))
  call Hloop_SQ_A(ntryL,G1H12(25),ex1(:),G1H6(22),ngX,m3h2x6(:,32),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(22),9,nMB,G2H6(11),n2h6(20))
  call Hloop_SQ_A(ntryL,G1H12(26),ex1(:),G1H6(22),ngPtb,m3h2x6(:,33),heltab2x12(:,:,33))
  call Hloop_Q_A(ntryL,G1H6(22),9,nMT,G2H6(12),n2h6(21))
  call Hloop_ZQ_A(ntryL,G0H12(10),ex1(:),G0H6(1),ngZd,m3h2x6(:,34),heltab2x12(:,:,34))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(22),n2h6(22))
  call Hloop_WQ_A(ntryL,G0H12(11),ex1(:),G0H6(1),m3h2x6(:,35),heltab2x12(:,:,35))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(23),n2h6(23))
  call Hloop_SQ_A(ntryL,G0H12(12),ex1(:),G0H6(1),ngPtb,m3h2x6(:,36),heltab2x12(:,:,36))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(24),n2h6(24))
  call Hloop_WQ_A(ntryL,G1H12(27),ex1(:),G1H6(25),m3h2x6(:,37),heltab2x12(:,:,37))
  call Hloop_Q_A(ntryL,G1H6(25),9,nMT,G2H6(13),n2h6(25))
  call Hloop_ZQ_A(ntryL,G0H12(13),ex1(:),G0H6(1),ngZd,m3h2x6(:,38),heltab2x12(:,:,38))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(25),n2h6(26))
  call Hloop_WQ_A(ntryL,G0H12(14),ex1(:),G0H6(1),m3h2x6(:,39),heltab2x12(:,:,39))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(26),n2h6(27))
  call Hloop_WQ_A(ntryL,G1H12(28),ex1(:),G1H6(27),m3h2x6(:,40),heltab2x12(:,:,40))
  call Hloop_Q_A(ntryL,G1H6(27),9,nMT,G2H6(14),n2h6(28))
  call Hloop_SQ_A(ntryL,G1H12(29),ex1(:),G1H6(27),ngH,m3h2x6(:,41),heltab2x12(:,:,41))
  call Hloop_Q_A(ntryL,G1H6(27),9,nMB,G2H6(15),n2h6(29))
  call Hloop_SQ_A(ntryL,G1H12(30),ex1(:),G1H6(27),ngX,m3h2x6(:,42),heltab2x12(:,:,42))
  call Hloop_Q_A(ntryL,G1H6(27),9,nMB,G2H6(16),n2h6(30))
  call Hloop_SQ_A(ntryL,G1H12(31),ex1(:),G1H6(27),ngPtb,m3h2x6(:,43),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H6(27),9,nMT,G2H6(17),n2h6(31))
  call Hloop_AQ_S(ntryL,G1H12(32),ex1(:),G1H6(27),ngH,m3h2x6(:,44),heltab2x12(:,:,44))
  call Hloop_AQ_S(ntryL,G1H12(33),ex1(:),G1H6(28),ngX,m3h2x6(:,45),heltab2x12(:,:,45))
  call Hloop_AQ_S(ntryL,G1H12(34),ex1(:),G1H6(29),ngPtb,m3h2x6(:,46),heltab2x12(:,:,46))
  call Hloop_SQ_A(ntryL,G0H12(15),ex1(:),G0H6(1),ngH,m3h2x6(:,47),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(30),n2h6(32))
  call Hloop_SQ_A(ntryL,G0H12(16),ex1(:),G0H6(1),ngPtb,m3h2x6(:,48),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(31),n2h6(33))
  call Hloop_ZQ_A(ntryL,G0H12(17),ex1(:),G0H6(1),ngZd,m3h2x6(:,49),heltab2x12(:,:,49))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMB,G1H6(32),n2h6(34))
  call Hloop_WQ_A(ntryL,G0H12(18),ex1(:),G0H6(1),m3h2x6(:,50),heltab2x12(:,:,50))
  call Hloop_Q_A(ntryL,G0H6(1),9,nMT,G1H6(33),n2h6(35))
  call Hloop_AQ_S(ntryL,G1H12(35),ex1(:),G1H6(34),ngH,m3h2x6(:,51),heltab2x12(:,:,51))
  call Hloop_AQ_S(ntryL,G1H12(36),ex1(:),G1H6(35),ngPtb,m3h2x6(:,52),heltab2x12(:,:,52))
  call Hloop_AQ_Z(ntryL,G1H12(37),ex1(:),G1H6(36),ngZd,m3h2x6(:,53),heltab2x12(:,:,53))
  call Hloop_AQ_W(ntryL,G1H12(38),ex1(:),G1H6(37),m3h2x6(:,54),heltab2x12(:,:,54))
  call Hloop_WQ_A(ntryL,G1H12(39),ex1(:),G1H6(38),m3h2x6(:,55),heltab2x12(:,:,55))
  call Hloop_Q_A(ntryL,G1H6(38),9,nMT,G2H6(18),n2h6(36))
  call Hloop_AQ_W(ntryL,G1H12(40),ex1(:),G1H6(38),m3h2x6(:,56),heltab2x12(:,:,56))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(4),[G1H6(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(9),[G1H6(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(10),[G1H6(23)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(13),[G1H6(21)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(11),[G1H6(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(12),[G1H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(14),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(16),[G1H6(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(17),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(18),[G1H6(31)])
  call Hloop_SQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),ngH,m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMB,G2H3(1),n2h3(1))
  call Hloop_SQ_A(ntryL,G1H6(2),ex1(:),G1H3(1),ngX,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMB,G2H3(2),n2h3(2))
  call Hloop_SQ_A(ntryL,G1H6(3),ex1(:),G1H3(1),ngPtb,m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMT,G2H3(3),n2h3(3))
  call Hloop_AQ_S(ntryL,G2H6(1),ex1(:),G2H3(4),ngH,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_AQ_S(ntryL,G2H6(2),ex1(:),G2H3(5),ngX,m3h2x3(:,5),heltab2x6(:,:,5))
  call Hloop_AQ_S(ntryL,G2H6(3),ex1(:),G2H3(6),ngPtb,m3h2x3(:,6),heltab2x6(:,:,6))
  call Hloop_VQ_A(ntryL,G1H6(4),ex1(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMB,G2H3(7),n2h3(4))
  call Hloop_ZQ_A(ntryL,G1H6(5),ex1(:),G1H3(1),ngZd,m3h2x3(:,8),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMB,G2H3(8),n2h3(5))
  call Hloop_WQ_A(ntryL,G1H6(6),ex1(:),G1H3(1),m3h2x3(:,9),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMT,G2H3(9),n2h3(6))
  call Hloop_AQ_S(ntryL,G1H6(7),ex1(:),G1H3(1),ngH,m3h2x3(:,10),heltab2x6(:,:,10))
  call Hloop_AQ_S(ntryL,G2H6(6),ex1(:),G2H3(10),ngPtb,m3h2x3(:,11),heltab2x6(:,:,11))
  call Hloop_AQ_Z(ntryL,G2H6(4),ex1(:),G2H3(11),ngZd,m3h2x3(:,12),heltab2x6(:,:,12))
  call Hloop_AQ_W(ntryL,G2H6(5),ex1(:),G2H3(12),m3h2x3(:,13),heltab2x6(:,:,13))
  call Hloop_AQ_W(ntryL,G2H6(7),ex1(:),G2H3(13),m3h2x3(:,14),heltab2x6(:,:,14))
  call Hloop_SA_Q(ntryL,G1H6(14),ex2(:),G1H3(2),ngH,m3h2x3(:,15),heltab2x6(:,:,15))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMB,G2H3(14),n2h3(7))
  call Hloop_SA_Q(ntryL,G1H6(15),ex2(:),G1H3(2),ngX,m3h2x3(:,16),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMB,G2H3(15),n2h3(8))
  call Hloop_SA_Q(ntryL,G1H6(16),ex2(:),G1H3(2),ngPbt,m3h2x3(:,17),heltab2x6(:,:,17))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMT,G2H3(16),n2h3(9))
  call Hloop_QA_S(ntryL,G2H6(8),ex2(:),G2H3(17),ngH,m3h2x3(:,18),heltab2x6(:,:,18))
  call Hloop_QA_S(ntryL,G2H6(9),ex2(:),G2H3(18),ngX,m3h2x3(:,19),heltab2x6(:,:,19))
  call Hloop_QA_S(ntryL,G2H6(10),ex2(:),G2H3(19),ngPbt,m3h2x3(:,20),heltab2x6(:,:,20))
  call Hloop_VA_Q(ntryL,G1H6(17),ex2(:),G1H3(2),m3h2x3(:,21),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMB,G2H3(20),n2h3(10))
  call Hloop_ZA_Q(ntryL,G1H6(18),ex2(:),G1H3(2),ngZd,m3h2x3(:,22),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMB,G2H3(21),n2h3(11))
  call Hloop_WA_Q(ntryL,G1H6(19),ex2(:),G1H3(2),m3h2x3(:,23),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(2),11,nMT,G2H3(22),n2h3(12))
  call Hloop_QA_S(ntryL,G1H6(20),ex2(:),G1H3(2),ngH,m3h2x3(:,24),heltab2x6(:,:,24))
  call Hloop_QA_S(ntryL,G2H6(13),ex2(:),G2H3(23),ngPbt,m3h2x3(:,25),heltab2x6(:,:,25))
  call Hloop_QA_Z(ntryL,G2H6(11),ex2(:),G2H3(24),ngZd,m3h2x3(:,26),heltab2x6(:,:,26))
  call Hloop_QA_W(ntryL,G2H6(12),ex2(:),G2H3(25),m3h2x3(:,27),heltab2x6(:,:,27))
  call Hloop_QA_W(ntryL,G2H6(14),ex2(:),G2H3(26),m3h2x3(:,28),heltab2x6(:,:,28))
  call Hotf_4pt_reduction(G2H6(15),RedSet_4(1),mass4set(:,1),  & 
G1H6(9),G1H6(10),G1H6(8),G1H6(12),G1H6(13),6)
  call HG1shiftOLR(G1H6(10),2,6)
  call Hotf_4pt_reduction(G2H6(16),RedSet_4(1),mass4set(:,2),  & 
G1H6(11),G1H6(22),G1H6(23),G1H6(21),G1H6(25),6)
  call HG1shiftOLR(G1H6(22),2,6)
  call Hotf_4pt_reduction(G2H6(17),RedSet_4(1),mass4set(:,3),  & 
G1H6(26),G1H6(24),G1H6(32),G1H6(33),G1H6(31),6)
  call HG1shiftOLR(G1H6(24),2,6)
  call Hloop_TV_S(ntryL,G1H6(27),9,ex3(:),4,G2H2(1),m3h3x2(:,1),heltab2x6(:,:,29))
  call Hloop_SV_T(ntryL,G1H6(28),9,ex3(:),4,G2H2(2),m3h3x2(:,2),heltab2x6(:,:,30))
  call Hloop_TV_S(ntryL,G1H6(29),9,ex3(:),4,G2H2(3),m3h3x2(:,3),heltab2x6(:,:,31))
  call Hloop_QZ_A(ntryL,G1H6(30),ex3(:),G1H2(1),ngZd,m3h3x2(:,4),heltab2x6(:,:,32))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMB,G2H2(4),n2h2(1))
  call Hotf_4pt_reduction(G2H6(18),RedSet_4(1),mass4set(:,3),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(5),6)
  call HG1shiftOLR(G1H6(2),2,6)
  call Hloop_SV_V(ntryL,G1H6(34),ex3(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,33))
  call Hloop_SV_V(ntryL,G1H6(35),ex3(:),G1H2(2),m3h3x2(:,6),heltab2x6(:,:,34))
  call Hloop_VV_S(ntryL,G1H6(36),ex3(:),G1H2(3),m3h3x2(:,7),heltab2x6(:,:,35))
  call Hloop_VV_S(ntryL,G1H6(37),ex3(:),G1H2(4),m3h3x2(:,8),heltab2x6(:,:,36))
  call Hloop_UV_W(ntryL,G1H6(38),9,ex3(:),4,G2H2(5),m3h3x2(:,9),heltab2x6(:,:,37))
  call Hloop_QZ_A(ntryL,G1H6(9),ex3(:),G1H2(5),ngZd,m3h3x2(:,10),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(6),n2h2(2))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_SA_Q(ntryL,G1H6(10),ex2(:),G1H3(3),ngX,m3h2x3(:,29),heltab2x6(:,:,39))
  call Hloop_QZ_A(ntryL,G1H6(12),ex3(:),G1H2(5),ngZd,m3h3x2(:,11),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(7),n2h2(3))
  call Hloop_QZ_A(ntryL,G1H6(13),ex3(:),G1H2(5),ngZd,m3h3x2(:,12),heltab2x6(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(8),n2h2(4))
  call Hloop_QZ_A(ntryL,G1H6(11),ex3(:),G1H2(5),ngZd,m3h3x2(:,13),heltab2x6(:,:,42))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(9),n2h2(5))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_SA_Q(ntryL,G1H6(22),ex2(:),G1H3(4),ngH,m3h2x3(:,30),heltab2x6(:,:,43))
  call Hloop_QZ_A(ntryL,G1H6(21),ex3(:),G1H2(5),ngZd,m3h3x2(:,14),heltab2x6(:,:,44))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(10),n2h2(6))
  call Hloop_QZ_A(ntryL,G1H6(25),ex3(:),G1H2(5),ngZd,m3h3x2(:,15),heltab2x6(:,:,45))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(11),n2h2(7))
  call Hloop_QZ_A(ntryL,G1H6(26),ex3(:),G1H2(5),ngZu,m3h3x2(:,16),heltab2x6(:,:,46))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(12),n2h2(8))
call HGT_OLR(G1H6(24),1,1,6)
call HGT_invQ_OLR(G1H6(24),2,5,6)
  call Hloop_SA_Q(ntryL,G1H6(24),ex2(:),G1H3(5),ngPbt,m3h2x3(:,31),heltab2x6(:,:,47))
  call Hloop_QZ_A(ntryL,G1H6(33),ex3(:),G1H2(5),ngZu,m3h3x2(:,17),heltab2x6(:,:,48))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(13),n2h2(9))
  call Hloop_QZ_A(ntryL,G1H6(31),ex3(:),G1H2(5),ngZu,m3h3x2(:,18),heltab2x6(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(14),n2h2(10))
  call Hloop_QZ_A(ntryL,G1H6(1),ex3(:),G1H2(5),ngZu,m3h3x2(:,19),heltab2x6(:,:,50))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(15),n2h2(11))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_WA_Q(ntryL,G1H6(2),ex2(:),G1H3(6),m3h2x3(:,32),heltab2x6(:,:,51))
  call Hloop_QZ_A(ntryL,G1H6(4),ex3(:),G1H2(5),ngZu,m3h3x2(:,20),heltab2x6(:,:,52))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(16),n2h2(12))
  call Hloop_QZ_A(ntryL,G1H6(5),ex3(:),G1H2(5),ngZu,m3h3x2(:,21),heltab2x6(:,:,53))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMT,G2H2(17),n2h2(13))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(8),[G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(9),[G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(21),[G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(22),[G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(2)])
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(2),mass4set(:,4),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),4,3)
  call Hotf_4pt_reduction(G2H3(8),RedSet_4(2),mass4set(:,5),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),3)
  call HG1shiftOLR(G1H3(13),4,3)
  call Hotf_4pt_reduction(G2H3(9),RedSet_4(2),mass4set(:,6),  & 
G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),3)
  call HG1shiftOLR(G1H3(18),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(2),mass4set(:,7),  & 
G1H3(22),G1H3(23),G1H3(24),G1H3(25),G1H3(26),3)
  call HG1shiftOLR(G1H3(23),4,3)
  call Hotf_4pt_reduction(G2H3(5),RedSet_4(2),mass4set(:,8),  & 
G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),3)
  call HG1shiftOLR(G1H3(28),4,3)
  call Hotf_4pt_reduction(G2H3(6),RedSet_4(2),mass4set(:,9),  & 
G1H3(32),G1H3(33),G1H3(34),G1H3(35),G1H3(36),3)
  call HG1shiftOLR(G1H3(33),4,3)
  call Hotf_4pt_reduction(G2H3(7),RedSet_4(2),mass4set(:,10),  & 
G1H3(37),G1H3(38),G1H3(39),G1H3(40),G1H3(41),3)
  call HG1shiftOLR(G1H3(38),4,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(1),ex3(:),G1tensor(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(10),ex3(:),G2tensor(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(11),ex3(:),G2tensor(2),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(12),ex3(:),G2tensor(3),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hotf_4pt_reduction(G2H3(13),RedSet_4(2),mass4set(:,9),  & 
G1H3(1),G1H3(42),G1H3(43),G1H3(44),G1H3(45),3)
  call HG1shiftOLR(G1H3(42),4,3)
  call Hotf_4pt_reduction(G2H3(14),RedSet_4(3),mass4set(:,4),  & 
G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
  call HG1shiftOLR(G1H3(47),4,3)
  call Hotf_4pt_reduction(G2H3(21),RedSet_4(3),mass4set(:,5),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),3)
  call HG1shiftOLR(G1H3(52),4,3)
  call Hotf_4pt_reduction(G2H3(22),RedSet_4(3),mass4set(:,6),  & 
G1H3(56),G1H3(57),G1H3(58),G1H3(59),G1H3(60),3)
  call HG1shiftOLR(G1H3(57),4,3)
  call Hotf_4pt_reduction(G2H3(17),RedSet_4(3),mass4set(:,7),  & 
G1H3(61),G1H3(62),G1H3(63),G1H3(64),G1H3(65),3)
  call HG1shiftOLR(G1H3(62),4,3)
  call Hotf_4pt_reduction(G2H3(18),RedSet_4(3),mass4set(:,8),  & 
G1H3(66),G1H3(67),G1H3(68),G1H3(69),G1H3(70),3)
  call HG1shiftOLR(G1H3(67),4,3)
  call Hotf_4pt_reduction(G2H3(19),RedSet_4(3),mass4set(:,9),  & 
G1H3(71),G1H3(72),G1H3(73),G1H3(74),G1H3(75),3)
  call HG1shiftOLR(G1H3(72),4,3)
  call Hotf_4pt_reduction(G2H3(20),RedSet_4(3),mass4set(:,10),  & 
G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),3)
  call HG1shiftOLR(G1H3(77),4,3)
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(2),ex3(:),G1tensor(2),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(23),ex3(:),G2tensor(4),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(24),ex3(:),G2tensor(5),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(25),ex3(:),G2tensor(6),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hotf_4pt_reduction(G2H3(26),RedSet_4(3),mass4set(:,9),  & 
G1H3(2),G1H3(81),G1H3(82),G1H3(83),G1H3(84),3)
  call HG1shiftOLR(G1H3(81),4,3)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(1),mass4set(:,11),  & 
G1H2(5),G1H2(3),G1H2(4),G1H2(2),G1H2(6),2)
  call HG1shiftOLR(G1H2(3),2,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(1),mass4set(:,12),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),2)
  call HG1shiftOLR(G1H2(8),2,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(1),mass4set(:,13),  & 
G1H2(12),G1H2(13),G1H2(14),G1H2(15),G1H2(16),2)
  call HG1shiftOLR(G1H2(13),2,2)
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(7),ngZd,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hloop_ZA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngZd,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(8),n2h1(1))
  call Hotf_4pt_reduction(G2H2(5),RedSet_4(1),mass4set(:,13),  & 
G1H2(1),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(9),ngX,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(10),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(11),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(11),ex2(:),G2tensor(12),ngH,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(12),ex2(:),G2tensor(13),ngPbt,m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(14),ex2(:),G2tensor(14),ngPbt,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(15),ex2(:),G2tensor(15),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(17),ex2(:),G2tensor(16),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hloop_QZ_A(ntryL,G1H3(7),ex3(:),G1H1(1),ngZd,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(2))
  call Hloop_QZ_A(ntryL,G1H3(8),ex3(:),G1H1(1),ngZd,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(18),n2h1(3))
  call Hloop_QZ_A(ntryL,G1H3(11),ex3(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(19),n2h1(4))
  call Hloop_QZ_A(ntryL,G1H3(12),ex3(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(20),n2h1(5))
  call Hloop_QZ_A(ntryL,G1H3(13),ex3(:),G1H1(1),ngZd,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(21),n2h1(6))
  call Hloop_QZ_A(ntryL,G1H3(16),ex3(:),G1H1(1),ngZd,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(22),n2h1(7))
  call Hloop_QZ_A(ntryL,G1H3(17),ex3(:),G1H1(1),ngZu,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(23),n2h1(8))
  call Hloop_QZ_A(ntryL,G1H3(18),ex3(:),G1H1(1),ngZu,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(24),n2h1(9))
  call Hloop_QZ_A(ntryL,G1H3(21),ex3(:),G1H1(1),ngZu,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(25),n2h1(10))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(22),11,ex3(:),4,G2tensor(26),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(23),0,ex3(:),4,G2tensor(27),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(26),11,ex3(:),4,G2tensor(28),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(27),11,ex3(:),4,G2tensor(29),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(28),0,ex3(:),4,G2tensor(30),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(31),11,ex3(:),4,G2tensor(31),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(32),11,ex3(:),4,G2tensor(32),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(33),0,ex3(:),4,G2tensor(33),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(36),11,ex3(:),4,G2tensor(34),m3h3x1(:,26),heltab2x3(:,:,26))
  call Hloop_QZ_A(ntryL,G1H3(37),ex3(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(35),n2h1(14))
  call Hloop_QZ_A(ntryL,G1H3(38),ex3(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(36),n2h1(15))
  call Hloop_QZ_A(ntryL,G1H3(41),ex3(:),G1H1(1),ngZd,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(37),n2h1(16))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(1),11,ex3(:),4,G2tensor(38),m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(42),0,ex3(:),4,G2tensor(39),m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(45),11,ex3(:),4,G2tensor(40),m3h3x1(:,32),heltab2x3(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H3(46),ex3(:),G1H1(1),ngZd,m3h3x1(:,33),heltab2x3(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(41),n2h1(18))
  call Hloop_AZ_Q(ntryL,G1H3(47),ex3(:),G1H1(1),ngZd,m3h3x1(:,34),heltab2x3(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(42),n2h1(19))
  call Hloop_AZ_Q(ntryL,G1H3(50),ex3(:),G1H1(1),ngZd,m3h3x1(:,35),heltab2x3(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(43),n2h1(20))
  call Hloop_AZ_Q(ntryL,G1H3(51),ex3(:),G1H1(1),ngZd,m3h3x1(:,36),heltab2x3(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(44),n2h1(21))
  call Hloop_AZ_Q(ntryL,G1H3(52),ex3(:),G1H1(1),ngZd,m3h3x1(:,37),heltab2x3(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(45),n2h1(22))
  call Hloop_AZ_Q(ntryL,G1H3(55),ex3(:),G1H1(1),ngZd,m3h3x1(:,38),heltab2x3(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(46),n2h1(23))
  call Hloop_AZ_Q(ntryL,G1H3(56),ex3(:),G1H1(1),ngZu,m3h3x1(:,39),heltab2x3(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(47),n2h1(24))
  call Hloop_AZ_Q(ntryL,G1H3(57),ex3(:),G1H1(1),ngZu,m3h3x1(:,40),heltab2x3(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(48),n2h1(25))
  call Hloop_AZ_Q(ntryL,G1H3(60),ex3(:),G1H1(1),ngZu,m3h3x1(:,41),heltab2x3(:,:,41))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(49),n2h1(26))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(61),11,ex3(:),4,G2tensor(50),m3h3x1(:,42),heltab2x3(:,:,42))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(62),0,ex3(:),4,G2tensor(51),m3h3x1(:,43),heltab2x3(:,:,43))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(65),11,ex3(:),4,G2tensor(52),m3h3x1(:,44),heltab2x3(:,:,44))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(66),11,ex3(:),4,G2tensor(53),m3h3x1(:,45),heltab2x3(:,:,45))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(67),0,ex3(:),4,G2tensor(54),m3h3x1(:,46),heltab2x3(:,:,46))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(70),11,ex3(:),4,G2tensor(55),m3h3x1(:,47),heltab2x3(:,:,47))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(71),11,ex3(:),4,G2tensor(56),m3h3x1(:,48),heltab2x3(:,:,48))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(72),0,ex3(:),4,G2tensor(57),m3h3x1(:,49),heltab2x3(:,:,49))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(75),11,ex3(:),4,G2tensor(58),m3h3x1(:,50),heltab2x3(:,:,50))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex3(:),G1H1(1),ngZd,m3h3x1(:,51),heltab2x3(:,:,51))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(59),n2h1(30))
  call Hloop_AZ_Q(ntryL,G1H3(77),ex3(:),G1H1(1),ngZd,m3h3x1(:,52),heltab2x3(:,:,52))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(60),n2h1(31))
  call Hloop_AZ_Q(ntryL,G1H3(80),ex3(:),G1H1(1),ngZd,m3h3x1(:,53),heltab2x3(:,:,53))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(61),n2h1(32))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(2),11,ex3(:),4,G2tensor(62),m3h3x1(:,54),heltab2x3(:,:,54))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(81),0,ex3(:),4,G2tensor(63),m3h3x1(:,55),heltab2x3(:,:,55))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(84),11,ex3(:),4,G2tensor(64),m3h3x1(:,56),heltab2x3(:,:,56))
  call Hloop_SA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngX,m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(65),n2h1(34))
  call Hloop_SA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngX,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(66),n2h1(35))
  call Hloop_SA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),ngX,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(67),n2h1(36))
  call Hloop_SA_Q(ntryL,G1H2(7),ex2(:),G1H1(1),ngH,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(68),n2h1(37))
  call Hloop_SA_Q(ntryL,G1H2(8),ex2(:),G1H1(1),ngH,m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMB,G2tensor(69),n2h1(38))
  call Hloop_SA_Q(ntryL,G1H2(11),ex2(:),G1H1(1),ngH,m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(70),n2h1(39))
  call Hloop_SA_Q(ntryL,G1H2(12),ex2(:),G1H1(1),ngPbt,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(71),n2h1(40))
  call Hloop_SA_Q(ntryL,G1H2(13),ex2(:),G1H1(1),ngPbt,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(72),n2h1(41))
  call Hloop_SA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),ngPbt,m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(73),n2h1(42))
  call Hloop_WA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(74),n2h1(43))
  call Hloop_WA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),2,nMT,G2tensor(75),n2h1(44))
  call Hloop_WA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(76),n2h1(45))
  call ol_merge_tensors(G2tensor(26),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(32),G2tensor(3),G2tensor(1)])
  call ol_merge_tensors(G2tensor(29),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(2)])
  call ol_merge_tensors(G2tensor(62),[G2tensor(56),G2tensor(6),G2tensor(4)])
  call ol_merge_tensors(G2tensor(53),[G2tensor(5)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(7)])
  call ol_merge_tensors(G2tensor(65),[G2tensor(8)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(74),[G2tensor(71)])
  call Hotf_4pt_reduction_last(G2tensor(26),RedSet_4(2),mass4set(:,7),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),4)
  call Hotf_4pt_reduction_last(G2tensor(38),RedSet_4(2),mass4set(:,9),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(29),RedSet_4(2),mass4set(:,8),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(50),RedSet_4(3),mass4set(:,7),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(62),RedSet_4(3),mass4set(:,9),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(53),RedSet_4(3),mass4set(:,8),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(1),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_4pt_reduction_last(G2tensor(65),RedSet_4(1),mass4set(:,11),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),2)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(1),mass4set(:,2),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),2)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(1),mass4set(:,3),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),2)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(2),mass4set(:,4),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),4)
  call Hotf_4pt_reduction_last(G2tensor(20),RedSet_4(2),mass4set(:,5),  & 
G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
  call G_TensorShift(G1tensor(57),4)
  call Hotf_4pt_reduction_last(G2tensor(23),RedSet_4(2),mass4set(:,6),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65))
  call G_TensorShift(G1tensor(62),4)
  call Hotf_4pt_reduction_last(G2tensor(35),RedSet_4(2),mass4set(:,10),  & 
G1tensor(66),G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70))
  call G_TensorShift(G1tensor(67),4)
  call Hotf_4pt_reduction_last(G2tensor(41),RedSet_4(3),mass4set(:,4),  & 
G1tensor(71),G1tensor(72),G1tensor(73),G1tensor(74),G1tensor(75))
  call G_TensorShift(G1tensor(72),4)
  call Hotf_4pt_reduction_last(G2tensor(44),RedSet_4(3),mass4set(:,5),  & 
G1tensor(76),G1tensor(77),G1tensor(78),G1tensor(79),G1tensor(80))
  call G_TensorShift(G1tensor(77),4)
  call Hotf_4pt_reduction_last(G2tensor(47),RedSet_4(3),mass4set(:,6),  & 
G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84),G1tensor(85))
  call G_TensorShift(G1tensor(82),4)
  call Hotf_4pt_reduction_last(G2tensor(59),RedSet_4(3),mass4set(:,10),  & 
G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
  call G_TensorShift(G1tensor(87),4)
  call Hotf_4pt_reduction_last(G2tensor(68),RedSet_4(1),mass4set(:,12),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95))
  call G_TensorShift(G1tensor(92),2)
  call Hotf_4pt_reduction_last(G2tensor(74),RedSet_4(1),mass4set(:,13),  & 
G1tensor(96),G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100))
  call G_TensorShift(G1tensor(97),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(2),mass4set(:,7),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,9),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(2),mass4set(:,8),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(3),mass4set(:,7),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(3),mass4set(:,9),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(3),mass4set(:,8),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(1),mass4set(:,11),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,2),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(1),mass4set(:,3),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(2),mass4set(:,4),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call Hotf_4pt_reduction_last(G1tensor(56),RedSet_4(2),mass4set(:,5),  & 
G0tensor(56),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60))
  call Hotf_4pt_reduction_last(G1tensor(61),RedSet_4(2),mass4set(:,6),  & 
G0tensor(61),G0tensor(62),G0tensor(63),G0tensor(64),G0tensor(65))
  call Hotf_4pt_reduction_last(G1tensor(66),RedSet_4(2),mass4set(:,10),  & 
G0tensor(66),G0tensor(67),G0tensor(68),G0tensor(69),G0tensor(70))
  call Hotf_4pt_reduction_last(G1tensor(71),RedSet_4(3),mass4set(:,4),  & 
G0tensor(71),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75))
  call Hotf_4pt_reduction_last(G1tensor(76),RedSet_4(3),mass4set(:,5),  & 
G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),G0tensor(80))
  call Hotf_4pt_reduction_last(G1tensor(81),RedSet_4(3),mass4set(:,6),  & 
G0tensor(81),G0tensor(82),G0tensor(83),G0tensor(84),G0tensor(85))
  call Hotf_4pt_reduction_last(G1tensor(86),RedSet_4(3),mass4set(:,10),  & 
G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),G0tensor(90))
  call Hotf_4pt_reduction_last(G1tensor(91),RedSet_4(1),mass4set(:,12),  & 
G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),G0tensor(95))
  call Hotf_4pt_reduction_last(G1tensor(96),RedSet_4(1),mass4set(:,13),  & 
G0tensor(96),G0tensor(97),G0tensor(98),G0tensor(99),G0tensor(100))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  call ol_merge_tensors(T0sum(12),[G0tensor(56)])
  call ol_merge_tensors(T0sum(13),[G0tensor(61)])
  call ol_merge_tensors(T0sum(14),[G0tensor(66)])
  call ol_merge_tensors(T0sum(15),[G0tensor(71)])
  call ol_merge_tensors(T0sum(16),[G0tensor(76)])
  call ol_merge_tensors(T0sum(17),[G0tensor(81)])
  call ol_merge_tensors(T0sum(18),[G0tensor(86)])
  call ol_merge_tensors(T0sum(19),[G0tensor(91)])
  call ol_merge_tensors(T0sum(20),[G0tensor(96)])
  Gcoeff(:)%j = (c(21)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(59),h0tab(:,59),[12,1,2],[nMH,nMB,nMH],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(1),m4h3x3x4(:,1),heltab3x36(:,:,1))
  Gcoeff(:)%j = (-(c(21)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(60),h0tab(:,60),[12,1,2],[nMZ,nMB,nMZ],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(2),m4h3x3x4(:,2),heltab3x36(:,:,2))
  Gcoeff(:)%j = (c(63)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(61),h0tab(:,61),[12,1,2],[nMW,nMT,nMW],4,0)
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(3),m4h3x3x4(:,3),heltab3x36(:,:,3))
  Gcoeff(:)%j = (-(c(11)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(62),h0tab(:,62),[12,1,2],[nMW,nMT,nMW],4,0)
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),ex3(:),G0H4(4),m4h3x3x4(:,4),heltab3x36(:,:,4))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(63),h0tab(:,63),[8,3,4],[nME,nME,nME],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZl,m3h3x12(:,59),heltab2x36(:,:,59))
  call Hloop_A_Q(ntryL,G0H12(19),8,nME,G1H12(7),n2h12(23))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(64),h0tab(:,64),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(1),ngZl,m3h3x12(:,60),heltab2x36(:,:,60))
  call Hloop_A_Q(ntryL,G0H12(1),8,nMM,G1H12(21),n2h12(24))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(65),h0tab(:,65),[8,3,4],[nML,nML,nML],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(2),ngZl,m3h3x12(:,61),heltab2x36(:,:,61))
  call Hloop_A_Q(ntryL,G0H12(2),8,nML,G1H12(1),n2h12(25))
  Gcoeff(:)%j = (c(98)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(66),h0tab(:,66),[8,3,4],[nME,nME,nME],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(3),ngZl,m3h3x12(:,62),heltab2x36(:,:,62))
  call Hloop_Q_A(ntryL,G0H12(3),8,nME,G1H12(2),n2h12(26))
  Gcoeff(:)%j = (c(100)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(67),h0tab(:,67),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(4),ngZl,m3h3x12(:,63),heltab2x36(:,:,63))
  call Hloop_Q_A(ntryL,G0H12(4),8,nMM,G1H12(3),n2h12(27))
  Gcoeff(:)%j = (c(99)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(68),h0tab(:,68),[8,3,4],[nML,nML,nML],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(5),ngZl,m3h3x12(:,64),heltab2x36(:,:,64))
  call Hloop_Q_A(ntryL,G0H12(5),8,nML,G1H12(4),n2h12(28))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(69),h0tab(:,69),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(6),ngZu,m3h3x12(:,65),heltab2x36(:,:,65))
  call Hloop_A_Q(ntryL,G0H12(6),8,nMT,G1H12(5),n2h12(29))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(70),h0tab(:,70),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(7),ngZu,m3h3x12(:,66),heltab2x36(:,:,66))
  call Hloop_Q_A(ntryL,G0H12(7),8,nMT,G1H12(6),n2h12(30))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(71),h0tab(:,71),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(8),ngZd,m3h3x12(:,67),heltab2x36(:,:,67))
  call Hloop_A_Q(ntryL,G0H12(8),8,nMB,G1H12(10),n2h12(31))
  Gcoeff(:)%j = (c(97)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(72),h0tab(:,72),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,1))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(9),ngZd,m3h3x12(:,68),heltab2x36(:,:,68))
  call Hloop_Q_A(ntryL,G0H12(9),8,nMB,G1H12(8),n2h12(32))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(73),h0tab(:,73),[8,3,4],[nME,nME,nME],3,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(10),ngZl,m3h3x12(:,69),heltab2x36(:,:,69))
  call Hloop_A_Q(ntryL,G0H12(10),8,nME,G1H12(9),n2h12(33))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(74),h0tab(:,74),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(11),ngZl,m3h3x12(:,70),heltab2x36(:,:,70))
  call Hloop_A_Q(ntryL,G0H12(11),8,nMM,G1H12(11),n2h12(34))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(75),h0tab(:,75),[8,3,4],[nML,nML,nML],3,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(12),ngZl,m3h3x12(:,71),heltab2x36(:,:,71))
  call Hloop_A_Q(ntryL,G0H12(12),8,nML,G1H12(12),n2h12(35))
  Gcoeff(:)%j = (-(c(98)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(76),h0tab(:,76),[8,3,4],[nME,nME,nME],3,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(13),ngZl,m3h3x12(:,72),heltab2x36(:,:,72))
  call Hloop_Q_A(ntryL,G0H12(13),8,nME,G1H12(13),n2h12(36))
  Gcoeff(:)%j = (-(c(100)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(77),h0tab(:,77),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(14),ngZl,m3h3x12(:,73),heltab2x36(:,:,73))
  call Hloop_Q_A(ntryL,G0H12(14),8,nMM,G1H12(14),n2h12(37))
  Gcoeff(:)%j = (-(c(99)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(78),h0tab(:,78),[8,3,4],[nML,nML,nML],3,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(15),ngZl,m3h3x12(:,74),heltab2x36(:,:,74))
  call Hloop_Q_A(ntryL,G0H12(15),8,nML,G1H12(15),n2h12(38))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(79),h0tab(:,79),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(16),ngZu,m3h3x12(:,75),heltab2x36(:,:,75))
  call Hloop_A_Q(ntryL,G0H12(16),8,nMT,G1H12(16),n2h12(39))
  Gcoeff(:)%j = (c(101)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(80),h0tab(:,80),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZu,m3h3x12(:,76),heltab2x36(:,:,76))
  call Hloop_Q_A(ntryL,G0H12(17),8,nMT,G1H12(17),n2h12(40))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(81),h0tab(:,81),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,5))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZd,m3h3x12(:,77),heltab2x36(:,:,77))
  call Hloop_A_Q(ntryL,G0H12(18),8,nMB,G1H12(18),n2h12(41))
  Gcoeff(:)%j = (-(c(97)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(82),h0tab(:,82),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,5))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(19),ngZd,m3h3x12(:,78),heltab2x36(:,:,78))
  call Hloop_Q_A(ntryL,G0H12(19),8,nMB,G1H12(19),n2h12(42))
  Gcoeff(:)%j = (c(25)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(83),h0tab(:,83),[8,3,4],[nMH,nMH,nMZ],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(20),m3h3x12(:,79),heltab2x36(:,:,79))
  Gcoeff(:)%j = (c(24)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(84),h0tab(:,84),[8,3,4],[nMZ,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(24),m3h3x12(:,80),heltab2x36(:,:,80))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(85),h0tab(:,85),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(22),m3h3x12(:,81),heltab2x36(:,:,81))
  Gcoeff(:)%j = (c(64)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(86),h0tab(:,86),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(23),m3h3x12(:,82),heltab2x36(:,:,82))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(87),h0tab(:,87),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(25),m3h3x12(:,83),heltab2x36(:,:,83))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(88),h0tab(:,88),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(26),m3h3x12(:,84),heltab2x36(:,:,84))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(89),h0tab(:,89),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(27),m3h3x12(:,85),heltab2x36(:,:,85))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(90),h0tab(:,90),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(28),m3h3x12(:,86),heltab2x36(:,:,86))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(91),h0tab(:,91),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(29),m3h3x12(:,87),heltab2x36(:,:,87))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(92),h0tab(:,92),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(30),m3h3x12(:,88),heltab2x36(:,:,88))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(93),h0tab(:,93),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(31),m3h3x12(:,89),heltab2x36(:,:,89))
  Gcoeff(:)%j = (c(15)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(94),h0tab(:,94),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(32),m3h3x12(:,90),heltab2x36(:,:,90))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(95),h0tab(:,95),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(33),m3h3x12(:,91),heltab2x36(:,:,91))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(96),h0tab(:,96),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(34),m3h3x12(:,92),heltab2x36(:,:,92))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(97),h0tab(:,97),[8,3,4],[nMZ,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,93),heltab2x36(:,:,93))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(98),h0tab(:,98),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,94),heltab2x36(:,:,94))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(99),h0tab(:,99),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,95),heltab2x36(:,:,95))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(100),h0tab(:,100),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(4),m3h3x12(:,96),heltab2x36(:,:,96))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(101),h0tab(:,101),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(5),m3h3x12(:,97),heltab2x36(:,:,97))
  Gcoeff(:)%j = (c(12)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(102),h0tab(:,102),[8,3,4],[nMZ,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(35),m3h3x12(:,98),heltab2x36(:,:,98))
  Gcoeff(:)%j = (c(61)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(103),h0tab(:,103),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(36),m3h3x12(:,99),heltab2x36(:,:,99))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(104),h0tab(:,104),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(37),m3h3x12(:,100),heltab2x36(:,:,100))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(105),h0tab(:,105),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(38),m3h3x12(:,101),heltab2x36(:,:,101))
  Gcoeff(:)%j = (-(c(61)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(106),h0tab(:,106),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(39),m3h3x12(:,102),heltab2x36(:,:,102))
  Gcoeff(:)%j = (c(18)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(107),h0tab(:,107),[8,3,4],[nMH,nMH,nMZ],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(6),m3h3x12(:,103),heltab2x36(:,:,103))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(108),h0tab(:,108),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,104),heltab2x36(:,:,104))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(109),h0tab(:,109),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(8),m3h3x12(:,105),heltab2x36(:,:,105))
  Gcoeff(:)%j = (c(35)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(110),h0tab(:,110),[8,3,4],[nMZ,nMZ,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(9),m3h3x12(:,106),heltab2x36(:,:,106))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(111),h0tab(:,111),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(10),m3h3x12(:,107),heltab2x36(:,:,107))
  Gcoeff(:)%j = (c(9)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(112),h0tab(:,112),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(11),m3h3x12(:,108),heltab2x36(:,:,108))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(113),h0tab(:,113),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(40),m3h3x12(:,109),heltab2x36(:,:,109))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(114),h0tab(:,114),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(41),m3h3x12(:,110),heltab2x36(:,:,110))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(115),h0tab(:,115),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(42),m3h3x12(:,111),heltab2x36(:,:,111))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(116),h0tab(:,116),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(43),m3h3x12(:,112),heltab2x36(:,:,112))
  Gcoeff(:)%j = (c(46)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(117),h0tab(:,117),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(12),m3h3x12(:,113),heltab2x36(:,:,113))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(118),h0tab(:,118),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,1))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(13),m3h3x12(:,114),heltab2x36(:,:,114))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(119),h0tab(:,119),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(14),m3h3x12(:,115),heltab2x36(:,:,115))
  Gcoeff(:)%j = (-(c(46)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(120),h0tab(:,120),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,5))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(15),m3h3x12(:,116),heltab2x36(:,:,116))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(121),h0tab(:,121),[8,3,4],[nME,nME,nME],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(16),ngZl,m3h3x12(:,117),heltab2x36(:,:,117))
  call Hloop_A_Q(ntryL,G0H12(16),8,nME,G1H12(44),n2h12(43))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(122),h0tab(:,122),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(17),ngZl,m3h3x12(:,118),heltab2x36(:,:,118))
  call Hloop_A_Q(ntryL,G0H12(17),8,nMM,G1H12(45),n2h12(44))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(123),h0tab(:,123),[8,3,4],[nML,nML,nML],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZl,m3h3x12(:,119),heltab2x36(:,:,119))
  call Hloop_A_Q(ntryL,G0H12(18),8,nML,G1H12(46),n2h12(45))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(124),h0tab(:,124),[8,3,4],[nME,nME,nME],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(19),ngZl,m3h3x12(:,120),heltab2x36(:,:,120))
  call Hloop_Q_A(ntryL,G0H12(19),8,nME,G1H12(47),n2h12(46))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(125),h0tab(:,125),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZl,m3h3x12(:,121),heltab2x36(:,:,121))
  call Hloop_Q_A(ntryL,G0H12(16),8,nMM,G1H12(48),n2h12(47))
  Gcoeff(:)%j = (-(c(76)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(126),h0tab(:,126),[8,3,4],[nML,nML,nML],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZl,m3h3x12(:,122),heltab2x36(:,:,122))
  call Hloop_Q_A(ntryL,G0H12(17),8,nML,G1H12(49),n2h12(48))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(127),h0tab(:,127),[8,3,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZu,m3h3x12(:,123),heltab2x36(:,:,123))
  call Hloop_A_Q(ntryL,G0H12(18),8,0,G1H12(50),n2h12(49))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(128),h0tab(:,128),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZu,m3h3x12(:,124),heltab2x36(:,:,124))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMT,G1H12(51),n2h12(50))
  Gcoeff(:)%j = (c(77)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(129),h0tab(:,129),[8,3,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZu,m3h3x12(:,125),heltab2x36(:,:,125))
  call Hloop_Q_A(ntryL,G0H12(16),8,0,G1H12(52),n2h12(51))
  Gcoeff(:)%j = (c(75)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(130),h0tab(:,130),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZu,m3h3x12(:,126),heltab2x36(:,:,126))
  call Hloop_Q_A(ntryL,G0H12(17),8,nMT,G1H12(53),n2h12(52))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(131),h0tab(:,131),[8,3,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZd,m3h3x12(:,127),heltab2x36(:,:,127))
  call Hloop_A_Q(ntryL,G0H12(18),8,0,G1H12(54),n2h12(53))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(132),h0tab(:,132),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,6))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZd,m3h3x12(:,128),heltab2x36(:,:,128))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMB,G1H12(55),n2h12(54))
  Gcoeff(:)%j = (-(c(75)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(133),h0tab(:,133),[8,3,4],[0,0,0],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZd,m3h3x12(:,129),heltab2x36(:,:,129))
  call Hloop_Q_A(ntryL,G0H12(16),8,0,G1H12(56),n2h12(55))
  Gcoeff(:)%j = (-(c(74)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(134),h0tab(:,134),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,6))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZd,m3h3x12(:,130),heltab2x36(:,:,130))
  call Hloop_Q_A(ntryL,G0H12(17),8,nMB,G1H12(57),n2h12(56))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(135),h0tab(:,135),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZn,m3h3x12(:,131),heltab2x36(:,:,131))
  call Hloop_A_Q(ntryL,G0H12(18),8,0,G1H12(58),n2h12(57))
  Gcoeff(:)%j = (-(c(81)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(136),h0tab(:,136),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(19),ngZn,m3h3x12(:,132),heltab2x36(:,:,132))
  call Hloop_Q_A(ntryL,G0H12(19),8,0,G1H12(59),n2h12(58))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(137),h0tab(:,137),[8,3,4],[nME,nME,nME],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(16),ngZl,m3h3x12(:,133),heltab2x36(:,:,133))
  call Hloop_A_Q(ntryL,G0H12(16),8,nME,G1H12(60),n2h12(59))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(138),h0tab(:,138),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(17),ngZl,m3h3x12(:,134),heltab2x36(:,:,134))
  call Hloop_A_Q(ntryL,G0H12(17),8,nMM,G1H12(61),n2h12(60))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(139),h0tab(:,139),[8,3,4],[nML,nML,nML],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZl,m3h3x12(:,135),heltab2x36(:,:,135))
  call Hloop_A_Q(ntryL,G0H12(18),8,nML,G1H12(62),n2h12(61))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(140),h0tab(:,140),[8,3,4],[nME,nME,nME],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(19),ngZl,m3h3x12(:,136),heltab2x36(:,:,136))
  call Hloop_Q_A(ntryL,G0H12(19),8,nME,G1H12(63),n2h12(62))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(141),h0tab(:,141),[8,3,4],[nMM,nMM,nMM],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZl,m3h3x12(:,137),heltab2x36(:,:,137))
  call Hloop_Q_A(ntryL,G0H12(16),8,nMM,G1H12(64),n2h12(63))
  Gcoeff(:)%j = (-(c(78)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(142),h0tab(:,142),[8,3,4],[nML,nML,nML],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZl,m3h3x12(:,138),heltab2x36(:,:,138))
  call Hloop_Q_A(ntryL,G0H12(17),8,nML,G1H12(65),n2h12(64))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(143),h0tab(:,143),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZu,m3h3x12(:,139),heltab2x36(:,:,139))
  call Hloop_A_Q(ntryL,G0H12(18),8,0,G1H12(66),n2h12(65))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(144),h0tab(:,144),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZu,m3h3x12(:,140),heltab2x36(:,:,140))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMT,G1H12(67),n2h12(66))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(145),h0tab(:,145),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZu,m3h3x12(:,141),heltab2x36(:,:,141))
  call Hloop_Q_A(ntryL,G0H12(16),8,0,G1H12(68),n2h12(67))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(146),h0tab(:,146),[8,3,4],[nMT,nMT,nMT],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZu,m3h3x12(:,142),heltab2x36(:,:,142))
  call Hloop_Q_A(ntryL,G0H12(17),8,nMT,G1H12(69),n2h12(68))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(147),h0tab(:,147),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(18),ngZd,m3h3x12(:,143),heltab2x36(:,:,143))
  call Hloop_A_Q(ntryL,G0H12(18),8,0,G1H12(70),n2h12(69))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(148),h0tab(:,148),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,7))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(19),ngZd,m3h3x12(:,144),heltab2x36(:,:,144))
  call Hloop_A_Q(ntryL,G0H12(19),8,nMB,G1H12(71),n2h12(70))
  Gcoeff(:)%j = (-(c(80)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(149),h0tab(:,149),[8,3,4],[0,0,0],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(16),ngZd,m3h3x12(:,145),heltab2x36(:,:,145))
  call Hloop_Q_A(ntryL,G0H12(16),8,0,G1H12(72),n2h12(71))
  Gcoeff(:)%j = (-(c(79)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(150),h0tab(:,150),[8,3,4],[nMB,nMB,nMB],3,1,wf4(:,7))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(17),ngZd,m3h3x12(:,146),heltab2x36(:,:,146))
  call Hloop_Q_A(ntryL,G0H12(17),8,nMB,G1H12(73),n2h12(72))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(151),h0tab(:,151),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(74),m3h3x12(:,147),heltab2x36(:,:,147))
  Gcoeff(:)%j = (-(c(68)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(152),h0tab(:,152),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(75),m3h3x12(:,148),heltab2x36(:,:,148))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(153),h0tab(:,153),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(76),m3h3x12(:,149),heltab2x36(:,:,149))
  Gcoeff(:)%j = (-(c(71)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(154),h0tab(:,154),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(77),m3h3x12(:,150),heltab2x36(:,:,150))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(155),h0tab(:,155),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(78),m3h3x12(:,151),heltab2x36(:,:,151))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(156),h0tab(:,156),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(79),m3h3x12(:,152),heltab2x36(:,:,152))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(157),h0tab(:,157),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(80),m3h3x12(:,153),heltab2x36(:,:,153))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(158),h0tab(:,158),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(81),m3h3x12(:,154),heltab2x36(:,:,154))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(159),h0tab(:,159),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(82),m3h3x12(:,155),heltab2x36(:,:,155))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(160),h0tab(:,160),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(83),m3h3x12(:,156),heltab2x36(:,:,156))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(161),h0tab(:,161),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_DV_C(ntryL,G0H36(1),0,ex4(:),G1H12(84),m3h3x12(:,157),heltab2x36(:,:,157))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(162),h0tab(:,162),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_CV_D(ntryL,G0H36(1),0,ex4(:),8,G1H12(85),m3h3x12(:,158),heltab2x36(:,:,158))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(163),h0tab(:,163),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(86),m3h3x12(:,159),heltab2x36(:,:,159))
  Gcoeff(:)%j = (-(c(45)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(164),h0tab(:,164),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(87),m3h3x12(:,160),heltab2x36(:,:,160))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(165),h0tab(:,165),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(88),m3h3x12(:,161),heltab2x36(:,:,161))
  Gcoeff(:)%j = (c(39)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(166),h0tab(:,166),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(89),m3h3x12(:,162),heltab2x36(:,:,162))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(167),h0tab(:,167),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(18),m3h3x12(:,163),heltab2x36(:,:,163))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(168),h0tab(:,168),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(19),m3h3x12(:,164),heltab2x36(:,:,164))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(169),h0tab(:,169),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(16),m3h3x12(:,165),heltab2x36(:,:,165))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(170),h0tab(:,170),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(17),m3h3x12(:,166),heltab2x36(:,:,166))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(171),h0tab(:,171),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(90),m3h3x12(:,167),heltab2x36(:,:,167))
  Gcoeff(:)%j = (c(70)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(172),h0tab(:,172),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(91),m3h3x12(:,168),heltab2x36(:,:,168))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(173),h0tab(:,173),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(92),m3h3x12(:,169),heltab2x36(:,:,169))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(174),h0tab(:,174),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(93),m3h3x12(:,170),heltab2x36(:,:,170))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(175),h0tab(:,175),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(20),m3h3x12(:,171),heltab2x36(:,:,171))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(176),h0tab(:,176),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(21),m3h3x12(:,172),heltab2x36(:,:,172))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(177),h0tab(:,177),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(22),m3h3x12(:,173),heltab2x36(:,:,173))
  Gcoeff(:)%j = (c(73)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(178),h0tab(:,178),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(23),m3h3x12(:,174),heltab2x36(:,:,174))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(179),h0tab(:,179),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(24),m3h3x12(:,175),heltab2x36(:,:,175))
  Gcoeff(:)%j = (c(59)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(180),h0tab(:,180),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(25),m3h3x12(:,176),heltab2x36(:,:,176))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(181),h0tab(:,181),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(26),m3h3x12(:,177),heltab2x36(:,:,177))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(182),h0tab(:,182),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(27),m3h3x12(:,178),heltab2x36(:,:,178))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(183),h0tab(:,183),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(94),m3h3x12(:,179),heltab2x36(:,:,179))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(184),h0tab(:,184),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(95),m3h3x12(:,180),heltab2x36(:,:,180))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(185),h0tab(:,185),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(96),m3h3x12(:,181),heltab2x36(:,:,181))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(186),h0tab(:,186),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(97),m3h3x12(:,182),heltab2x36(:,:,182))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(187),h0tab(:,187),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(28),m3h3x12(:,183),heltab2x36(:,:,183))
  Gcoeff(:)%j = (-(c(7)*M(1,:)%j)) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(188),h0tab(:,188),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,6))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(29),m3h3x12(:,184),heltab2x36(:,:,184))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(189),h0tab(:,189),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(30),m3h3x12(:,185),heltab2x36(:,:,185))
  Gcoeff(:)%j = (-(c(58)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(190),h0tab(:,190),[8,3,4],[nMW,nMW,nMW],3,1,wf4(:,7))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(31),m3h3x12(:,186),heltab2x36(:,:,186))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(191),h0tab(:,191),[8,2,5],[nMB,nMH,nMB],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZd,m3h3x12(:,187),heltab2x36(:,:,187))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMB,G1H12(98),n2h12(73))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(192),h0tab(:,192),[8,2,5],[nMB,nMZ,nMB],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZd,m3h3x12(:,188),heltab2x36(:,:,188))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMB,G1H12(99),n2h12(74))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(193),h0tab(:,193),[8,2,5],[nMT,nMW,nMT],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZu,m3h3x12(:,189),heltab2x36(:,:,189))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMT,G1H12(100),n2h12(75))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(194),h0tab(:,194),[8,2,5],[nMH,nMB,nMZ],3,1,wf6(:,3))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(101),m3h3x12(:,190),heltab2x36(:,:,190))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(195),h0tab(:,195),[8,2,5],[nMZ,nMB,nMH],3,1,wf6(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(102),m3h3x12(:,191),heltab2x36(:,:,191))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(196),h0tab(:,196),[8,2,5],[nMW,nMT,nMW],3,1,wf6(:,3))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(103),m3h3x12(:,192),heltab2x36(:,:,192))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(197),h0tab(:,197),[8,2,5],[nMB,0,nMB],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZd,m3h3x12(:,193),heltab2x36(:,:,193))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMB,G1H12(104),n2h12(76))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(198),h0tab(:,198),[8,2,5],[nMB,nMZ,nMB],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZd,m3h3x12(:,194),heltab2x36(:,:,194))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMB,G1H12(105),n2h12(77))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(199),h0tab(:,199),[8,2,5],[nMT,nMW,nMT],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZu,m3h3x12(:,195),heltab2x36(:,:,195))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMT,G1H12(106),n2h12(78))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(200),h0tab(:,200),[8,2,5],[nMB,0,nMB],3,1,wf6(:,3))
  call Hloop_QZ_A(ntryL,G0H36(1),ex4(:),G0H12(32),ngZd,m3h3x12(:,196),heltab2x36(:,:,196))
  call Hloop_Q_A(ntryL,G0H12(32),8,nMB,G1H12(107),n2h12(79))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(201),h0tab(:,201),[8,2,5],[nMH,nMB,nMZ],3,1,wf6(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(32),m3h3x12(:,197),heltab2x36(:,:,197))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(202),h0tab(:,202),[8,2,5],[nMW,nMT,nMW],3,1,wf6(:,3))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(33),m3h3x12(:,198),heltab2x36(:,:,198))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(203),h0tab(:,203),[8,2,5],[nMZ,nMB,nMH],3,1,wf6(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(34),m3h3x12(:,199),heltab2x36(:,:,199))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(204),h0tab(:,204),[8,2,5],[nMW,nMT,nMW],3,1,wf6(:,3))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(35),m3h3x12(:,200),heltab2x36(:,:,200))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(205),h0tab(:,205),[8,2,5],[nMW,nMT,nMW],3,1,wf6(:,3))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(108),m3h3x12(:,201),heltab2x36(:,:,201))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(206),h0tab(:,206),[8,1,6],[nMB,nMH,nMB],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZd,m3h3x12(:,202),heltab2x36(:,:,202))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMB,G1H12(109),n2h12(80))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(207),h0tab(:,207),[8,1,6],[nMB,nMZ,nMB],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZd,m3h3x12(:,203),heltab2x36(:,:,203))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMB,G1H12(110),n2h12(81))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(208),h0tab(:,208),[8,1,6],[nMT,nMW,nMT],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZu,m3h3x12(:,204),heltab2x36(:,:,204))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMT,G1H12(111),n2h12(82))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(209),h0tab(:,209),[8,1,6],[nMH,nMB,nMZ],3,1,wf6(:,12))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(112),m3h3x12(:,205),heltab2x36(:,:,205))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(210),h0tab(:,210),[8,1,6],[nMZ,nMB,nMH],3,1,wf6(:,12))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(113),m3h3x12(:,206),heltab2x36(:,:,206))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(211),h0tab(:,211),[8,1,6],[nMW,nMT,nMW],3,1,wf6(:,12))
  call Hloop_SV_T(ntryL,G0H36(1),0,ex4(:),8,G1H12(114),m3h3x12(:,207),heltab2x36(:,:,207))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(212),h0tab(:,212),[8,1,6],[nMB,0,nMB],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZd,m3h3x12(:,208),heltab2x36(:,:,208))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMB,G1H12(115),n2h12(83))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(213),h0tab(:,213),[8,1,6],[nMB,nMZ,nMB],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZd,m3h3x12(:,209),heltab2x36(:,:,209))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMB,G1H12(116),n2h12(84))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(214),h0tab(:,214),[8,1,6],[nMT,nMW,nMT],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZu,m3h3x12(:,210),heltab2x36(:,:,210))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMT,G1H12(117),n2h12(85))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(215),h0tab(:,215),[8,1,6],[nMB,0,nMB],3,1,wf6(:,12))
  call Hloop_AZ_Q(ntryL,G0H36(1),ex4(:),G0H12(36),ngZd,m3h3x12(:,211),heltab2x36(:,:,211))
  call Hloop_A_Q(ntryL,G0H12(36),8,nMB,G1H12(118),n2h12(86))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(216),h0tab(:,216),[8,1,6],[nMH,nMB,nMZ],3,1,wf6(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(36),m3h3x12(:,212),heltab2x36(:,:,212))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(217),h0tab(:,217),[8,1,6],[nMW,nMT,nMW],3,1,wf6(:,12))
  call Hloop_VV_S(ntryL,G0H36(1),ex4(:),G0H12(37),m3h3x12(:,213),heltab2x36(:,:,213))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(218),h0tab(:,218),[8,1,6],[nMZ,nMB,nMH],3,1,wf6(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(38),m3h3x12(:,214),heltab2x36(:,:,214))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(219),h0tab(:,219),[8,1,6],[nMW,nMT,nMW],3,1,wf6(:,12))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(39),m3h3x12(:,215),heltab2x36(:,:,215))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(220),h0tab(:,220),[8,1,6],[nMW,nMT,nMW],3,1,wf6(:,12))
  call Hloop_UW_V(ntryL,G0H36(1),0,ex4(:),8,G1H12(119),m3h3x12(:,216),heltab2x36(:,:,216))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(221),h0tab(:,221),[9,2,4],[nMH,nMB,nMB],3,1,wf6(:,6))
  call Hloop_AQ_S(ntryL,G0H36(1),wf6(:,6),G0H6(1),ngH,m3h6x6(:,1),heltab2x36(:,:,217))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(222),h0tab(:,222),[9,2,4],[nMZ,nMB,nMB],3,1,wf6(:,6))
  call Hloop_AQ_S(ntryL,G0H36(1),wf6(:,6),G0H6(2),ngX,m3h6x6(:,2),heltab2x36(:,:,218))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(223),h0tab(:,223),[9,2,4],[nMW,nMT,nMT],3,1,wf6(:,6))
  call Hloop_AQ_S(ntryL,G0H36(1),wf6(:,6),G0H6(3),ngPtb,m3h6x6(:,3),heltab2x36(:,:,219))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(224),h0tab(:,224),[9,2,4],[nMB,nMH,nMZ],3,1,wf6(:,6))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(4),ngX,m3h6x6(:,4),heltab2x36(:,:,220))
  call Hloop_Q_A(ntryL,G0H6(4),9,nMB,G1H6(6),n2h6(41))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(225),h0tab(:,225),[9,2,4],[nMB,nMZ,nMH],3,1,wf6(:,6))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(4),ngH,m3h6x6(:,5),heltab2x36(:,:,221))
  call Hloop_Q_A(ntryL,G0H6(4),9,nMB,G1H6(7),n2h6(42))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(226),h0tab(:,226),[9,2,4],[nMT,nMW,nMW],3,1,wf6(:,6))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(4),ngPtb,m3h6x6(:,6),heltab2x36(:,:,222))
  call Hloop_Q_A(ntryL,G0H6(4),9,nMT,G1H6(14),n2h6(43))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(227),h0tab(:,227),[9,2,4],[0,nMB,nMB],3,1,wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(4),m3h6x6(:,7),heltab2x36(:,:,223))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(228),h0tab(:,228),[9,2,4],[nMZ,nMB,nMB],3,1,wf6(:,6))
  call Hloop_AQ_Z(ntryL,G0H36(1),wf6(:,6),G0H6(5),ngZd,m3h6x6(:,8),heltab2x36(:,:,224))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(229),h0tab(:,229),[9,2,4],[nMW,nMT,nMT],3,1,wf6(:,6))
  call Hloop_AQ_W(ntryL,G0H36(1),wf6(:,6),G0H6(6),m3h6x6(:,9),heltab2x36(:,:,225))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(230),h0tab(:,230),[9,2,4],[0,nMB,nMB],3,1,wf6(:,6))
  call Hloop_AQ_V(ntryL,G0H36(1),wf6(:,6),G0H6(7),m3h6x6(:,10),heltab2x36(:,:,226))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(231),h0tab(:,231),[9,2,4],[nMB,nMH,nMZ],3,1,wf6(:,6))
  call Hloop_ZQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(8),ngZd,m3h6x6(:,11),heltab2x36(:,:,227))
  call Hloop_Q_A(ntryL,G0H6(8),9,nMB,G1H6(15),n2h6(44))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(232),h0tab(:,232),[9,2,4],[nMT,nMW,nMW],3,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(8),m3h6x6(:,12),heltab2x36(:,:,228))
  call Hloop_Q_A(ntryL,G0H6(8),9,nMT,G1H6(16),n2h6(45))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(233),h0tab(:,233),[9,2,4],[nMB,nMZ,nMH],3,1,wf6(:,6))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(8),ngH,m3h6x6(:,13),heltab2x36(:,:,229))
  call Hloop_Q_A(ntryL,G0H6(8),9,nMB,G1H6(17),n2h6(46))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(234),h0tab(:,234),[9,2,4],[nMT,nMW,nMW],3,1,wf6(:,6))
  call Hloop_SQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(8),ngPtb,m3h6x6(:,14),heltab2x36(:,:,230))
  call Hloop_Q_A(ntryL,G0H6(8),9,nMT,G1H6(18),n2h6(47))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(235),h0tab(:,235),[9,2,4],[nMT,nMW,nMW],3,1,wf6(:,6))
  call Hloop_WQ_A(ntryL,G0H36(1),wf6(:,6),G0H6(8),m3h6x6(:,15),heltab2x36(:,:,231))
  call Hloop_Q_A(ntryL,G0H6(8),9,nMT,G1H6(19),n2h6(48))
  Gcoeff(:)%j = (-(c(52)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(236),h0tab(:,236),[10,1,4],[nMH,nMB,nMB],3,1,wf6(:,15))
  call Hloop_QA_S(ntryL,G0H36(1),wf6(:,15),G0H6(8),ngH,m3h6x6(:,16),heltab2x36(:,:,232))
  Gcoeff(:)%j = (c(52)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(237),h0tab(:,237),[10,1,4],[nMZ,nMB,nMB],3,1,wf6(:,15))
  call Hloop_QA_S(ntryL,G0H36(1),wf6(:,15),G0H6(9),ngX,m3h6x6(:,17),heltab2x36(:,:,233))
  Gcoeff(:)%j = (c(51)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(238),h0tab(:,238),[10,1,4],[nMW,nMT,nMT],3,1,wf6(:,15))
  call Hloop_QA_S(ntryL,G0H36(1),wf6(:,15),G0H6(10),ngPbt,m3h6x6(:,18),heltab2x36(:,:,234))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(239),h0tab(:,239),[10,1,4],[nMB,nMH,nMZ],3,1,wf6(:,15))
  call Hloop_SA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(11),ngX,m3h6x6(:,19),heltab2x36(:,:,235))
  call Hloop_A_Q(ntryL,G0H6(11),10,nMB,G1H6(20),n2h6(49))
  Gcoeff(:)%j = (c(41)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(240),h0tab(:,240),[10,1,4],[nMB,nMZ,nMH],3,1,wf6(:,15))
  call Hloop_SA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(11),ngH,m3h6x6(:,20),heltab2x36(:,:,236))
  call Hloop_A_Q(ntryL,G0H6(11),10,nMB,G1H6(27),n2h6(50))
  Gcoeff(:)%j = (-(c(67)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(241),h0tab(:,241),[10,1,4],[nMT,nMW,nMW],3,1,wf6(:,15))
  call Hloop_SA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(11),ngPbt,m3h6x6(:,21),heltab2x36(:,:,237))
  call Hloop_A_Q(ntryL,G0H6(11),10,nMT,G1H6(28),n2h6(51))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(242),h0tab(:,242),[10,1,4],[0,nMB,nMB],3,1,wf6(:,15))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,15),G0H6(11),m3h6x6(:,22),heltab2x36(:,:,238))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(243),h0tab(:,243),[10,1,4],[nMZ,nMB,nMB],3,1,wf6(:,15))
  call Hloop_QA_Z(ntryL,G0H36(1),wf6(:,15),G0H6(12),ngZd,m3h6x6(:,23),heltab2x36(:,:,239))
  Gcoeff(:)%j = (c(44)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(244),h0tab(:,244),[10,1,4],[nMW,nMT,nMT],3,1,wf6(:,15))
  call Hloop_QA_W(ntryL,G0H36(1),wf6(:,15),G0H6(13),m3h6x6(:,24),heltab2x36(:,:,240))
  Gcoeff(:)%j = (c(4)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(245),h0tab(:,245),[10,1,4],[0,nMB,nMB],3,1,wf6(:,15))
  call Hloop_QA_V(ntryL,G0H36(1),wf6(:,15),G0H6(14),m3h6x6(:,25),heltab2x36(:,:,241))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(246),h0tab(:,246),[10,1,4],[nMB,nMH,nMZ],3,1,wf6(:,15))
  call Hloop_ZA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(15),ngZd,m3h6x6(:,26),heltab2x36(:,:,242))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMB,G1H6(29),n2h6(52))
  Gcoeff(:)%j = (-(c(56)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(247),h0tab(:,247),[10,1,4],[nMT,nMW,nMW],3,1,wf6(:,15))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(15),m3h6x6(:,27),heltab2x36(:,:,243))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMT,G1H6(30),n2h6(53))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(248),h0tab(:,248),[10,1,4],[nMB,nMZ,nMH],3,1,wf6(:,15))
  call Hloop_SA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(15),ngH,m3h6x6(:,28),heltab2x36(:,:,244))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMB,G1H6(34),n2h6(54))
  Gcoeff(:)%j = (c(56)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(249),h0tab(:,249),[10,1,4],[nMT,nMW,nMW],3,1,wf6(:,15))
  call Hloop_SA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(15),ngPbt,m3h6x6(:,29),heltab2x36(:,:,245))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMT,G1H6(35),n2h6(55))
  Gcoeff(:)%j = (c(38)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(250),h0tab(:,250),[10,1,4],[nMT,nMW,nMW],3,1,wf6(:,15))
  call Hloop_WA_Q(ntryL,G0H36(1),wf6(:,15),G0H6(15),m3h6x6(:,30),heltab2x36(:,:,246))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMT,G1H6(36),n2h6(56))
  Gcoeff(:)%j = (c(22)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(251),h0tab(:,251),[12,1,2],[nMB,nMH,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(5),ngH,m3h9x4(:,1),heltab2x36(:,:,247))
  call Hloop_A_Q(ntryL,G0H4(5),12,nMB,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(22)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(252),h0tab(:,252),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(5),ngH,m3h9x4(:,2),heltab2x36(:,:,248))
  call Hloop_A_Q(ntryL,G0H4(5),12,nMB,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(31)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(253),h0tab(:,253),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(5),ngH,m3h9x4(:,3),heltab2x36(:,:,249))
  call Hloop_A_Q(ntryL,G0H4(5),12,nMT,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (c(27)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(254),h0tab(:,254),[12,1,2],[nMH,nMB,nMH],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(5),m3h9x4(:,4),heltab2x36(:,:,250))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(255),h0tab(:,255),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(6),m3h9x4(:,5),heltab2x36(:,:,251))
  Gcoeff(:)%j = (-(c(23)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(256),h0tab(:,256),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_SS_S(ntryL,G0H36(1),wf9(:,1),G0H4(7),m3h9x4(:,6),heltab2x36(:,:,252))
  Gcoeff(:)%j = (-(c(47)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(257),h0tab(:,257),[12,1,2],[nMB,0,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(8),ngH,m3h9x4(:,7),heltab2x36(:,:,253))
  call Hloop_A_Q(ntryL,G0H4(8),12,nMB,G1H4(4),n2h4(4))
  Gcoeff(:)%j = (-(c(48)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(258),h0tab(:,258),[12,1,2],[nMB,nMZ,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(8),ngH,m3h9x4(:,8),heltab2x36(:,:,254))
  call Hloop_A_Q(ntryL,G0H4(8),12,nMB,G1H4(5),n2h4(5))
  Gcoeff(:)%j = (-(c(19)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(259),h0tab(:,259),[12,1,2],[nMT,nMW,nMT],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(8),ngH,m3h9x4(:,9),heltab2x36(:,:,255))
  call Hloop_A_Q(ntryL,G0H4(8),12,nMT,G1H4(6),n2h4(6))
  Gcoeff(:)%j = (-(c(49)*M(2,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(260),h0tab(:,260),[12,1,2],[nMB,0,nMB],3,1,wf9(:,1))
  call Hloop_AS_Q(ntryL,G0H36(1),wf9(:,1),G0H4(8),ngH,m3h9x4(:,10),heltab2x36(:,:,256))
  call Hloop_A_Q(ntryL,G0H4(8),12,nMB,G1H4(7),n2h4(7))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(261),h0tab(:,261),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(8),m3h9x4(:,11),heltab2x36(:,:,257))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(262),h0tab(:,262),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_VT_S(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(9),m3h9x4(:,12),heltab2x36(:,:,258))
  Gcoeff(:)%j = (c(40)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(263),h0tab(:,263),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(10),m3h9x4(:,13),heltab2x36(:,:,259))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(264),h0tab(:,264),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_ST_V(ntryL,G0H36(1),0,wf9(:,1),12,G1H4(11),m3h9x4(:,14),heltab2x36(:,:,260))
  Gcoeff(:)%j = (-(c(53)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(265),h0tab(:,265),[12,1,2],[nMZ,nMB,nMZ],3,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(8),m3h9x4(:,15),heltab2x36(:,:,261))
  Gcoeff(:)%j = (-(c(32)*M(1,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(266),h0tab(:,266),[12,1,2],[nMW,nMT,nMW],3,1,wf9(:,1))
  call Hloop_VS_V(ntryL,G0H36(1),wf9(:,1),G0H4(9),m3h9x4(:,16),heltab2x36(:,:,262))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(5),[G0H4(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(6),[G0H4(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(7),[G0H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H4(9),[G0H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(27),[G1H12(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(28),[G1H12(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(31),[G1H12(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(32),[G1H12(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(37),[G1H12(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(39),[G1H12(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(8),[G0H12(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H12(11),[G0H12(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(41),[G1H12(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(43),[G1H12(42)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(80),[G1H12(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(81),[G1H12(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(84),[G1H12(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(85),[G1H12(83)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(91),[G1H12(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(93),[G1H12(92)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(95),[G1H12(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(97),[G1H12(96)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(107),[G1H12(104)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(118),[G1H12(115)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(7),[G0H6(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(14),[G0H6(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(7),[G1H4(4)])
  call Hloop_QZ_A(ntryL,G1H6(8),ex3(:),G1H2(5),ngZd,m3h3x2(:,22),heltab2x6(:,:,54))
  call Hloop_Q_A(ntryL,G1H2(5),13,nMB,G2H2(1),n2h2(14))
  call Hloop_QZ_A(ntryL,G1H6(23),ex3(:),G1H2(3),ngZd,m3h3x2(:,23),heltab2x6(:,:,55))
  call Hloop_Q_A(ntryL,G1H2(3),13,nMB,G2H2(2),n2h2(15))
  call Hloop_QZ_A(ntryL,G1H6(32),ex3(:),G1H2(6),ngZu,m3h3x2(:,24),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H2(6),13,nMT,G2H2(3),n2h2(16))
  call Hloop_QZ_A(ntryL,G1H6(3),ex3(:),G1H2(7),ngZu,m3h3x2(:,25),heltab2x6(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(7),13,nMT,G2H2(4),n2h2(17))
  call Hloop_SQ_A(ntryL,G0H4(5),ex1(:),G0H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(8),n2h2(18))
  call Hloop_SQ_A(ntryL,G0H4(6),ex1(:),G0H2(1),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(11),n2h2(19))
  call Hloop_SQ_A(ntryL,G0H4(7),ex1(:),G0H2(1),ngPtb,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMT,G1H2(12),n2h2(20))
  call Hloop_WQ_A(ntryL,G0H4(9),ex1(:),G0H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMT,G1H2(13),n2h2(21))
  call Hloop_AS_Q(ntryL,G1H12(7),wf4(:,1),G1H3(7),ngH,m3h4x3(:,1),heltab2x12(:,:,57))
  call Hloop_A_Q(ntryL,G1H3(7),11,nME,G2H3(2),n2h3(13))
  call Hloop_AS_Q(ntryL,G1H12(21),wf4(:,1),G1H3(8),ngH,m3h4x3(:,2),heltab2x12(:,:,58))
  call Hloop_A_Q(ntryL,G1H3(8),11,nMM,G2H3(3),n2h3(14))
  call Hloop_AS_Q(ntryL,G1H12(1),wf4(:,1),G1H3(11),ngH,m3h4x3(:,3),heltab2x12(:,:,59))
  call Hloop_A_Q(ntryL,G1H3(11),11,nML,G2H3(15),n2h3(15))
  call Hloop_QS_A(ntryL,G1H12(2),wf4(:,1),G1H3(12),ngH,m3h4x3(:,4),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H3(12),11,nME,G2H3(16),n2h3(16))
  call Hloop_QS_A(ntryL,G1H12(3),wf4(:,1),G1H3(13),ngH,m3h4x3(:,5),heltab2x12(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(13),11,nMM,G2H3(1),n2h3(17))
  call Hloop_QS_A(ntryL,G1H12(4),wf4(:,1),G1H3(16),ngH,m3h4x3(:,6),heltab2x12(:,:,62))
  call Hloop_Q_A(ntryL,G1H3(16),11,nML,G2H3(8),n2h3(18))
  call Hloop_AS_Q(ntryL,G1H12(5),wf4(:,1),G1H3(17),ngH,m3h4x3(:,7),heltab2x12(:,:,63))
  call Hloop_A_Q(ntryL,G1H3(17),11,nMT,G2H3(9),n2h3(19))
  call Hloop_QS_A(ntryL,G1H12(6),wf4(:,1),G1H3(18),ngH,m3h4x3(:,8),heltab2x12(:,:,64))
  call Hloop_Q_A(ntryL,G1H3(18),11,nMT,G2H3(4),n2h3(20))
  call Hloop_AS_Q(ntryL,G1H12(10),wf4(:,1),G1H3(21),ngH,m3h4x3(:,9),heltab2x12(:,:,65))
  call Hloop_A_Q(ntryL,G1H3(21),11,nMB,G2H3(5),n2h3(21))
  call Hloop_QS_A(ntryL,G1H12(8),wf4(:,1),G1H3(22),ngH,m3h4x3(:,10),heltab2x12(:,:,66))
  call Hloop_Q_A(ntryL,G1H3(22),11,nMB,G2H3(6),n2h3(22))
  call Hloop_AS_Q(ntryL,G1H12(9),wf4(:,5),G1H3(23),ngX,m3h4x3(:,11),heltab2x12(:,:,67))
  call Hloop_A_Q(ntryL,G1H3(23),11,nME,G2H3(7),n2h3(23))
  call Hloop_AS_Q(ntryL,G1H12(11),wf4(:,5),G1H3(26),ngX,m3h4x3(:,12),heltab2x12(:,:,68))
  call Hloop_A_Q(ntryL,G1H3(26),11,nMM,G2H3(10),n2h3(24))
  call Hloop_AS_Q(ntryL,G1H12(12),wf4(:,5),G1H3(27),ngX,m3h4x3(:,13),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H3(27),11,nML,G2H3(11),n2h3(25))
  call Hloop_QS_A(ntryL,G1H12(13),wf4(:,5),G1H3(28),ngX,m3h4x3(:,14),heltab2x12(:,:,70))
  call Hloop_Q_A(ntryL,G1H3(28),11,nME,G2H3(12),n2h3(26))
  call Hloop_QS_A(ntryL,G1H12(14),wf4(:,5),G1H3(31),ngX,m3h4x3(:,15),heltab2x12(:,:,71))
  call Hloop_Q_A(ntryL,G1H3(31),11,nMM,G2H3(13),n2h3(27))
  call Hloop_QS_A(ntryL,G1H12(15),wf4(:,5),G1H3(32),ngX,m3h4x3(:,16),heltab2x12(:,:,72))
  call Hloop_Q_A(ntryL,G1H3(32),11,nML,G2H3(14),n2h3(28))
  call Hloop_AS_Q(ntryL,G1H12(16),wf4(:,5),G1H3(33),ngX,m3h4x3(:,17),heltab2x12(:,:,73))
  call Hloop_A_Q(ntryL,G1H3(33),11,nMT,G2H3(21),n2h3(29))
  call Hloop_QS_A(ntryL,G1H12(17),wf4(:,5),G1H3(36),ngX,m3h4x3(:,18),heltab2x12(:,:,74))
  call Hloop_Q_A(ntryL,G1H3(36),11,nMT,G2H3(22),n2h3(30))
  call Hloop_AS_Q(ntryL,G1H12(18),wf4(:,5),G1H3(37),ngX,m3h4x3(:,19),heltab2x12(:,:,75))
  call Hloop_A_Q(ntryL,G1H3(37),11,nMB,G2H3(17),n2h3(31))
  call Hloop_QS_A(ntryL,G1H12(19),wf4(:,5),G1H3(38),ngX,m3h4x3(:,20),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H3(38),11,nMB,G2H3(18),n2h3(32))
  call Hloop_SS_S(ntryL,G1H12(20),wf4(:,1),G1H3(41),m3h4x3(:,21),heltab2x12(:,:,77))
  call Hloop_SS_S(ntryL,G1H12(24),wf4(:,1),G1H3(1),m3h4x3(:,22),heltab2x12(:,:,78))
  call Hloop_SS_S(ntryL,G1H12(22),wf4(:,1),G1H3(42),m3h4x3(:,23),heltab2x12(:,:,79))
  call Hloop_SS_S(ntryL,G1H12(23),wf4(:,1),G1H3(45),m3h4x3(:,24),heltab2x12(:,:,80))
  call Hloop_SS_S(ntryL,G1H12(27),wf4(:,1),G1H3(46),m3h4x3(:,25),heltab2x12(:,:,81))
  call Hloop_SS_S(ntryL,G1H12(28),wf4(:,1),G1H3(47),m3h4x3(:,26),heltab2x12(:,:,82))
  call Hloop_SS_S(ntryL,G1H12(31),wf4(:,5),G1H3(50),m3h4x3(:,27),heltab2x12(:,:,83))
  call Hloop_SS_S(ntryL,G1H12(32),wf4(:,5),G1H3(51),m3h4x3(:,28),heltab2x12(:,:,84))
  call Hloop_VS_V(ntryL,G1H12(33),wf4(:,1),G1H3(52),m3h4x3(:,29),heltab2x12(:,:,85))
  call Hloop_VS_V(ntryL,G1H12(34),wf4(:,1),G1H3(55),m3h4x3(:,30),heltab2x12(:,:,86))
  call Hloop_VT_S(ntryL,G0H12(1),8,wf4(:,1),3,G1H3(56),m3h4x3(:,31),heltab2x12(:,:,87))
  call Hloop_VT_S(ntryL,G0H12(2),8,wf4(:,1),3,G1H3(57),m3h4x3(:,32),heltab2x12(:,:,88))
  call Hloop_VT_S(ntryL,G0H12(3),8,wf4(:,1),3,G1H3(60),m3h4x3(:,33),heltab2x12(:,:,89))
  call Hloop_VT_S(ntryL,G0H12(4),8,wf4(:,5),3,G1H3(61),m3h4x3(:,34),heltab2x12(:,:,90))
  call Hloop_VT_S(ntryL,G0H12(5),8,wf4(:,5),3,G1H3(62),m3h4x3(:,35),heltab2x12(:,:,91))
  call Hloop_ST_V(ntryL,G1H12(35),8,wf4(:,1),3,G2H3(19),m3h4x3(:,36),heltab2x12(:,:,92))
  call Hloop_ST_V(ntryL,G1H12(37),8,wf4(:,1),3,G2H3(20),m3h4x3(:,37),heltab2x12(:,:,93))
  call Hloop_ST_V(ntryL,G1H12(39),8,wf4(:,5),3,G2H3(23),m3h4x3(:,38),heltab2x12(:,:,94))
  call Hloop_SS_S(ntryL,G0H12(6),wf4(:,1),G0H3(1),m3h4x3(:,39),heltab2x12(:,:,95))
  call Hloop_SS_S(ntryL,G0H12(8),wf4(:,1),G0H3(2),m3h4x3(:,40),heltab2x12(:,:,96))
  call Hloop_VS_V(ntryL,G0H12(9),wf4(:,1),G0H3(3),m3h4x3(:,41),heltab2x12(:,:,97))
  call Hloop_VS_V(ntryL,G0H12(11),wf4(:,1),G0H3(4),m3h4x3(:,42),heltab2x12(:,:,98))
  call Hloop_VT_S(ntryL,G1H12(41),8,wf4(:,1),3,G2H3(24),m3h4x3(:,43),heltab2x12(:,:,99))
  call Hloop_VT_S(ntryL,G1H12(43),8,wf4(:,5),3,G2H3(25),m3h4x3(:,44),heltab2x12(:,:,100))
  call Hloop_ST_V(ntryL,G0H12(12),8,wf4(:,1),3,G1H3(65),m3h4x3(:,45),heltab2x12(:,:,101))
  call Hloop_ST_V(ntryL,G0H12(13),8,wf4(:,1),3,G1H3(66),m3h4x3(:,46),heltab2x12(:,:,102))
  call Hloop_ST_V(ntryL,G0H12(14),8,wf4(:,5),3,G1H3(67),m3h4x3(:,47),heltab2x12(:,:,103))
  call Hloop_ST_V(ntryL,G0H12(15),8,wf4(:,5),3,G1H3(70),m3h4x3(:,48),heltab2x12(:,:,104))
  call Hloop_AV_Q(ntryL,G1H12(44),wf4(:,6),G1H3(71),m3h4x3(:,49),heltab2x12(:,:,105))
  call Hloop_A_Q(ntryL,G1H3(71),11,nME,G2H3(26),n2h3(33))
  call Hloop_AV_Q(ntryL,G1H12(45),wf4(:,6),G1H3(72),m3h4x3(:,50),heltab2x12(:,:,106))
  call Hloop_A_Q(ntryL,G1H3(72),11,nMM,G2H3(27),n2h3(34))
  call Hloop_AV_Q(ntryL,G1H12(46),wf4(:,6),G1H3(75),m3h4x3(:,51),heltab2x12(:,:,107))
  call Hloop_A_Q(ntryL,G1H3(75),11,nML,G2H3(28),n2h3(35))
  call Hloop_QV_A(ntryL,G1H12(47),wf4(:,6),G1H3(76),m3h4x3(:,52),heltab2x12(:,:,108))
  call Hloop_Q_A(ntryL,G1H3(76),11,nME,G2H3(29),n2h3(36))
  call Hloop_QV_A(ntryL,G1H12(48),wf4(:,6),G1H3(77),m3h4x3(:,53),heltab2x12(:,:,109))
  call Hloop_Q_A(ntryL,G1H3(77),11,nMM,G2H3(30),n2h3(37))
  call Hloop_QV_A(ntryL,G1H12(49),wf4(:,6),G1H3(80),m3h4x3(:,54),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G1H3(80),11,nML,G2H3(31),n2h3(38))
  call Hloop_AV_Q(ntryL,G1H12(50),wf4(:,6),G1H3(2),m3h4x3(:,55),heltab2x12(:,:,111))
  call Hloop_A_Q(ntryL,G1H3(2),11,0,G2H3(32),n2h3(39))
  call Hloop_AV_Q(ntryL,G1H12(51),wf4(:,6),G1H3(81),m3h4x3(:,56),heltab2x12(:,:,112))
  call Hloop_A_Q(ntryL,G1H3(81),11,nMT,G2H3(33),n2h3(40))
  call Hloop_QV_A(ntryL,G1H12(52),wf4(:,6),G1H3(84),m3h4x3(:,57),heltab2x12(:,:,113))
  call Hloop_Q_A(ntryL,G1H3(84),11,0,G2H3(34),n2h3(41))
  call Hloop_QV_A(ntryL,G1H12(53),wf4(:,6),G1H3(7),m3h4x3(:,58),heltab2x12(:,:,114))
  call Hloop_Q_A(ntryL,G1H3(7),11,nMT,G2H3(35),n2h3(42))
  call Hloop_AV_Q(ntryL,G1H12(54),wf4(:,6),G1H3(8),m3h4x3(:,59),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G1H3(8),11,0,G2H3(36),n2h3(43))
  call Hloop_AV_Q(ntryL,G1H12(55),wf4(:,6),G1H3(11),m3h4x3(:,60),heltab2x12(:,:,116))
  call Hloop_A_Q(ntryL,G1H3(11),11,nMB,G2H3(37),n2h3(44))
  call Hloop_QV_A(ntryL,G1H12(56),wf4(:,6),G1H3(12),m3h4x3(:,61),heltab2x12(:,:,117))
  call Hloop_Q_A(ntryL,G1H3(12),11,0,G2H3(38),n2h3(45))
  call Hloop_QV_A(ntryL,G1H12(57),wf4(:,6),G1H3(13),m3h4x3(:,62),heltab2x12(:,:,118))
  call Hloop_Q_A(ntryL,G1H3(13),11,nMB,G2H3(39),n2h3(46))
  call Hloop_AZ_Q(ntryL,G1H12(58),wf4(:,7),G1H3(16),ngZn,m3h4x3(:,63),heltab2x12(:,:,119))
  call Hloop_A_Q(ntryL,G1H3(16),11,0,G2H3(40),n2h3(47))
  call Hloop_QZ_A(ntryL,G1H12(59),wf4(:,7),G1H3(17),ngZn,m3h4x3(:,64),heltab2x12(:,:,120))
  call Hloop_Q_A(ntryL,G1H3(17),11,0,G2H3(41),n2h3(48))
  call Hloop_AZ_Q(ntryL,G1H12(60),wf4(:,7),G1H3(18),ngZl,m3h4x3(:,65),heltab2x12(:,:,121))
  call Hloop_A_Q(ntryL,G1H3(18),11,nME,G2H3(42),n2h3(49))
  call Hloop_AZ_Q(ntryL,G1H12(61),wf4(:,7),G1H3(21),ngZl,m3h4x3(:,66),heltab2x12(:,:,122))
  call Hloop_A_Q(ntryL,G1H3(21),11,nMM,G2H3(43),n2h3(50))
  call Hloop_AZ_Q(ntryL,G1H12(62),wf4(:,7),G1H3(22),ngZl,m3h4x3(:,67),heltab2x12(:,:,123))
  call Hloop_A_Q(ntryL,G1H3(22),11,nML,G2H3(44),n2h3(51))
  call Hloop_QZ_A(ntryL,G1H12(63),wf4(:,7),G1H3(23),ngZl,m3h4x3(:,68),heltab2x12(:,:,124))
  call Hloop_Q_A(ntryL,G1H3(23),11,nME,G2H3(45),n2h3(52))
  call Hloop_QZ_A(ntryL,G1H12(64),wf4(:,7),G1H3(26),ngZl,m3h4x3(:,69),heltab2x12(:,:,125))
  call Hloop_Q_A(ntryL,G1H3(26),11,nMM,G2H3(46),n2h3(53))
  call Hloop_QZ_A(ntryL,G1H12(65),wf4(:,7),G1H3(27),ngZl,m3h4x3(:,70),heltab2x12(:,:,126))
  call Hloop_Q_A(ntryL,G1H3(27),11,nML,G2H3(47),n2h3(54))
  call Hloop_AZ_Q(ntryL,G1H12(66),wf4(:,7),G1H3(28),ngZu,m3h4x3(:,71),heltab2x12(:,:,127))
  call Hloop_A_Q(ntryL,G1H3(28),11,0,G2H3(48),n2h3(55))
  call Hloop_AZ_Q(ntryL,G1H12(67),wf4(:,7),G1H3(31),ngZu,m3h4x3(:,72),heltab2x12(:,:,128))
  call Hloop_A_Q(ntryL,G1H3(31),11,nMT,G2H3(49),n2h3(56))
  call Hloop_QZ_A(ntryL,G1H12(68),wf4(:,7),G1H3(32),ngZu,m3h4x3(:,73),heltab2x12(:,:,129))
  call Hloop_Q_A(ntryL,G1H3(32),11,0,G2H3(50),n2h3(57))
  call Hloop_QZ_A(ntryL,G1H12(69),wf4(:,7),G1H3(33),ngZu,m3h4x3(:,74),heltab2x12(:,:,130))
  call Hloop_Q_A(ntryL,G1H3(33),11,nMT,G2H3(51),n2h3(58))
  call Hloop_AZ_Q(ntryL,G1H12(70),wf4(:,7),G1H3(36),ngZd,m3h4x3(:,75),heltab2x12(:,:,131))
  call Hloop_A_Q(ntryL,G1H3(36),11,0,G2H3(52),n2h3(59))
  call Hloop_AZ_Q(ntryL,G1H12(71),wf4(:,7),G1H3(37),ngZd,m3h4x3(:,76),heltab2x12(:,:,132))
  call Hloop_A_Q(ntryL,G1H3(37),11,nMB,G2H3(53),n2h3(60))
  call Hloop_QZ_A(ntryL,G1H12(72),wf4(:,7),G1H3(38),ngZd,m3h4x3(:,77),heltab2x12(:,:,133))
  call Hloop_Q_A(ntryL,G1H3(38),11,0,G2H3(54),n2h3(61))
  call Hloop_QZ_A(ntryL,G1H12(73),wf4(:,7),G1H3(71),ngZd,m3h4x3(:,78),heltab2x12(:,:,134))
  call Hloop_Q_A(ntryL,G1H3(71),11,nMB,G2H3(55),n2h3(62))
  call Hloop_SV_T(ntryL,G1H12(74),8,wf4(:,6),3,G2H3(56),m3h4x3(:,79),heltab2x12(:,:,135))
  call Hloop_TV_S(ntryL,G1H12(75),8,wf4(:,6),3,G2H3(57),m3h4x3(:,80),heltab2x12(:,:,136))
  call Hloop_SV_T(ntryL,G1H12(76),8,wf4(:,7),3,G2H3(58),m3h4x3(:,81),heltab2x12(:,:,137))
  call Hloop_TV_S(ntryL,G1H12(77),8,wf4(:,7),3,G2H3(59),m3h4x3(:,82),heltab2x12(:,:,138))
  call Hloop_DV_C(ntryL,G1H12(80),8,wf4(:,6),G2H3(60),m3h4x3(:,83),heltab2x12(:,:,139))
  call Hloop_CV_D(ntryL,G1H12(81),8,wf4(:,6),3,G2H3(61),m3h4x3(:,84),heltab2x12(:,:,140))
  call Hloop_DV_C(ntryL,G1H12(84),8,wf4(:,7),G2H3(62),m3h4x3(:,85),heltab2x12(:,:,141))
  call Hloop_CV_D(ntryL,G1H12(85),8,wf4(:,7),3,G2H3(63),m3h4x3(:,86),heltab2x12(:,:,142))
  call Hloop_UW_V(ntryL,G1H12(86),8,wf4(:,6),3,G2H3(64),m3h4x3(:,87),heltab2x12(:,:,143))
  call Hloop_UV_W(ntryL,G1H12(87),8,wf4(:,6),3,G2H3(65),m3h4x3(:,88),heltab2x12(:,:,144))
  call Hloop_UW_V(ntryL,G1H12(88),8,wf4(:,7),3,G2H3(66),m3h4x3(:,89),heltab2x12(:,:,145))
  call Hloop_UV_W(ntryL,G1H12(89),8,wf4(:,7),3,G2H3(67),m3h4x3(:,90),heltab2x12(:,:,146))
  call Hloop_VV_S(ntryL,G0H12(18),wf4(:,6),G0H3(5),m3h4x3(:,91),heltab2x12(:,:,147))
  call Hloop_VV_S(ntryL,G0H12(19),wf4(:,6),G0H3(6),m3h4x3(:,92),heltab2x12(:,:,148))
  call Hloop_VV_S(ntryL,G0H12(16),wf4(:,7),G0H3(7),m3h4x3(:,93),heltab2x12(:,:,149))
  call Hloop_VV_S(ntryL,G0H12(17),wf4(:,7),G0H3(8),m3h4x3(:,94),heltab2x12(:,:,150))
  call Hloop_SV_V(ntryL,G1H12(91),wf4(:,6),G1H3(72),m3h4x3(:,95),heltab2x12(:,:,151))
  call Hloop_SV_V(ntryL,G1H12(93),wf4(:,7),G1H3(75),m3h4x3(:,96),heltab2x12(:,:,152))
  call Hloop_SV_T(ntryL,G0H12(20),8,wf4(:,6),3,G1H3(76),m3h4x3(:,97),heltab2x12(:,:,153))
  call Hloop_TV_S(ntryL,G0H12(21),8,wf4(:,6),3,G1H3(77),m3h4x3(:,98),heltab2x12(:,:,154))
  call Hloop_SV_T(ntryL,G0H12(22),8,wf4(:,7),3,G1H3(80),m3h4x3(:,99),heltab2x12(:,:,155))
  call Hloop_TV_S(ntryL,G0H12(23),8,wf4(:,7),3,G1H3(2),m3h4x3(:,100),heltab2x12(:,:,156))
  call Hloop_UW_V(ntryL,G0H12(24),8,wf4(:,6),3,G1H3(81),m3h4x3(:,101),heltab2x12(:,:,157))
  call Hloop_UV_W(ntryL,G0H12(25),8,wf4(:,6),3,G1H3(84),m3h4x3(:,102),heltab2x12(:,:,158))
  call Hloop_UW_V(ntryL,G0H12(26),8,wf4(:,7),3,G1H3(7),m3h4x3(:,103),heltab2x12(:,:,159))
  call Hloop_UV_W(ntryL,G0H12(27),8,wf4(:,7),3,G1H3(8),m3h4x3(:,104),heltab2x12(:,:,160))
  call Hloop_VV_S(ntryL,G1H12(95),wf4(:,6),G1H3(11),m3h4x3(:,105),heltab2x12(:,:,161))
  call Hloop_VV_S(ntryL,G1H12(97),wf4(:,7),G1H3(12),m3h4x3(:,106),heltab2x12(:,:,162))
  call Hloop_SV_V(ntryL,G0H12(28),wf4(:,6),G0H3(9),m3h4x3(:,107),heltab2x12(:,:,163))
  call Hloop_SV_V(ntryL,G0H12(29),wf4(:,6),G0H3(10),m3h4x3(:,108),heltab2x12(:,:,164))
  call Hloop_SV_V(ntryL,G0H12(30),wf4(:,7),G0H3(11),m3h4x3(:,109),heltab2x12(:,:,165))
  call Hloop_SV_V(ntryL,G0H12(31),wf4(:,7),G0H3(12),m3h4x3(:,110),heltab2x12(:,:,166))
  call Hloop_QA_S(ntryL,G1H12(98),ex2(:),G1H6(37),ngH,m3h2x6(:,57),heltab2x12(:,:,167))
  call Hloop_QA_S(ntryL,G1H12(99),ex2(:),G1H6(38),ngX,m3h2x6(:,58),heltab2x12(:,:,168))
  call Hloop_QA_S(ntryL,G1H12(100),ex2(:),G1H6(9),ngPbt,m3h2x6(:,59),heltab2x12(:,:,169))
  call Hloop_SA_Q(ntryL,G1H12(101),ex2(:),G1H6(10),ngH,m3h2x6(:,60),heltab2x12(:,:,170))
  call Hloop_A_Q(ntryL,G1H6(10),10,nMB,G2H6(1),n2h6(57))
  call Hloop_SA_Q(ntryL,G1H12(102),ex2(:),G1H6(12),ngX,m3h2x6(:,61),heltab2x12(:,:,171))
  call Hloop_A_Q(ntryL,G1H6(12),10,nMB,G2H6(2),n2h6(58))
  call Hloop_SA_Q(ntryL,G1H12(103),ex2(:),G1H6(13),ngPbt,m3h2x6(:,62),heltab2x12(:,:,172))
  call Hloop_A_Q(ntryL,G1H6(13),10,nMT,G2H6(3),n2h6(59))
  call Hloop_QA_V(ntryL,G1H12(107),ex2(:),G1H6(11),m3h2x6(:,63),heltab2x12(:,:,173))
  call Hloop_QA_Z(ntryL,G1H12(105),ex2(:),G1H6(22),ngZd,m3h2x6(:,64),heltab2x12(:,:,174))
  call Hloop_QA_W(ntryL,G1H12(106),ex2(:),G1H6(21),m3h2x6(:,65),heltab2x12(:,:,175))
  call Hloop_SA_Q(ntryL,G0H12(32),ex2(:),G0H6(15),ngH,m3h2x6(:,66),heltab2x12(:,:,176))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMB,G1H6(25),n2h6(60))
  call Hloop_SA_Q(ntryL,G0H12(33),ex2(:),G0H6(4),ngPbt,m3h2x6(:,67),heltab2x12(:,:,177))
  call Hloop_A_Q(ntryL,G0H6(4),10,nMT,G1H6(26),n2h6(61))
  call Hloop_ZA_Q(ntryL,G0H12(34),ex2(:),G0H6(11),ngZd,m3h2x6(:,68),heltab2x12(:,:,178))
  call Hloop_A_Q(ntryL,G0H6(11),10,nMB,G1H6(24),n2h6(62))
  call Hloop_WA_Q(ntryL,G0H12(35),ex2(:),G0H6(15),m3h2x6(:,69),heltab2x12(:,:,179))
  call Hloop_A_Q(ntryL,G0H6(15),10,nMT,G1H6(33),n2h6(63))
  call Hloop_WA_Q(ntryL,G1H12(108),ex2(:),G1H6(31),m3h2x6(:,70),heltab2x12(:,:,180))
  call Hloop_A_Q(ntryL,G1H6(31),10,nMT,G2H6(6),n2h6(64))
  call Hloop_AQ_S(ntryL,G1H12(109),ex1(:),G1H6(1),ngH,m3h2x6(:,71),heltab2x12(:,:,181))
  call Hloop_AQ_S(ntryL,G1H12(110),ex1(:),G1H6(2),ngX,m3h2x6(:,72),heltab2x12(:,:,182))
  call Hloop_AQ_S(ntryL,G1H12(111),ex1(:),G1H6(4),ngPtb,m3h2x6(:,73),heltab2x12(:,:,183))
  call Hloop_SQ_A(ntryL,G1H12(112),ex1(:),G1H6(5),ngH,m3h2x6(:,74),heltab2x12(:,:,184))
  call Hloop_Q_A(ntryL,G1H6(5),9,nMB,G2H6(4),n2h6(65))
  call Hloop_SQ_A(ntryL,G1H12(113),ex1(:),G1H6(8),ngX,m3h2x6(:,75),heltab2x12(:,:,185))
  call Hloop_Q_A(ntryL,G1H6(8),9,nMB,G2H6(5),n2h6(66))
  call Hloop_SQ_A(ntryL,G1H12(114),ex1(:),G1H6(23),ngPtb,m3h2x6(:,76),heltab2x12(:,:,186))
  call Hloop_Q_A(ntryL,G1H6(23),9,nMT,G2H6(7),n2h6(67))
  call Hloop_AQ_V(ntryL,G1H12(118),ex1(:),G1H6(32),m3h2x6(:,77),heltab2x12(:,:,187))
  call Hloop_AQ_Z(ntryL,G1H12(116),ex1(:),G1H6(3),ngZd,m3h2x6(:,78),heltab2x12(:,:,188))
  call Hloop_AQ_W(ntryL,G1H12(117),ex1(:),G1H6(10),m3h2x6(:,79),heltab2x12(:,:,189))
  call Hloop_SQ_A(ntryL,G0H12(36),ex1(:),G0H6(4),ngH,m3h2x6(:,80),heltab2x12(:,:,190))
  call Hloop_Q_A(ntryL,G0H6(4),9,nMB,G1H6(12),n2h6(68))
  call Hloop_SQ_A(ntryL,G0H12(37),ex1(:),G0H6(11),ngPtb,m3h2x6(:,81),heltab2x12(:,:,191))
  call Hloop_Q_A(ntryL,G0H6(11),9,nMT,G1H6(13),n2h6(69))
  call Hloop_ZQ_A(ntryL,G0H12(38),ex1(:),G0H6(15),ngZd,m3h2x6(:,82),heltab2x12(:,:,192))
  call Hloop_Q_A(ntryL,G0H6(15),9,nMB,G1H6(31),n2h6(70))
  call Hloop_WQ_A(ntryL,G0H12(39),ex1(:),G0H6(4),m3h2x6(:,83),heltab2x12(:,:,193))
  call Hloop_Q_A(ntryL,G0H6(4),9,nMT,G1H6(5),n2h6(71))
  call Hloop_WQ_A(ntryL,G1H12(119),ex1(:),G1H6(8),m3h2x6(:,84),heltab2x12(:,:,194))
  call Hloop_Q_A(ntryL,G1H6(8),9,nMT,G2H6(8),n2h6(72))
  call Hloop_SA_Q(ntryL,G0H6(1),ex2(:),G0H3(13),ngH,m3h2x3(:,33),heltab2x6(:,:,58))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMB,G1H3(13),n2h3(63))
  call Hloop_SA_Q(ntryL,G0H6(2),ex2(:),G0H3(13),ngX,m3h2x3(:,34),heltab2x6(:,:,59))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMB,G1H3(16),n2h3(64))
  call Hloop_SA_Q(ntryL,G0H6(3),ex2(:),G0H3(13),ngPbt,m3h2x3(:,35),heltab2x6(:,:,60))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMT,G1H3(17),n2h3(65))
  call Hloop_QA_S(ntryL,G1H6(6),ex2(:),G1H3(18),ngH,m3h2x3(:,36),heltab2x6(:,:,61))
  call Hloop_QA_S(ntryL,G1H6(7),ex2(:),G1H3(21),ngX,m3h2x3(:,37),heltab2x6(:,:,62))
  call Hloop_QA_S(ntryL,G1H6(14),ex2(:),G1H3(22),ngPbt,m3h2x3(:,38),heltab2x6(:,:,63))
  call Hloop_VA_Q(ntryL,G0H6(7),ex2(:),G0H3(13),m3h2x3(:,39),heltab2x6(:,:,64))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMB,G1H3(23),n2h3(66))
  call Hloop_ZA_Q(ntryL,G0H6(5),ex2(:),G0H3(13),ngZd,m3h2x3(:,40),heltab2x6(:,:,65))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMB,G1H3(26),n2h3(67))
  call Hloop_WA_Q(ntryL,G0H6(6),ex2(:),G0H3(13),m3h2x3(:,41),heltab2x6(:,:,66))
  call Hloop_A_Q(ntryL,G0H3(13),11,nMT,G1H3(27),n2h3(68))
  call Hloop_QA_S(ntryL,G1H6(15),ex2(:),G1H3(28),ngH,m3h2x3(:,42),heltab2x6(:,:,67))
  call Hloop_QA_S(ntryL,G1H6(16),ex2(:),G1H3(31),ngPbt,m3h2x3(:,43),heltab2x6(:,:,68))
  call Hloop_QA_Z(ntryL,G1H6(17),ex2(:),G1H3(32),ngZd,m3h2x3(:,44),heltab2x6(:,:,69))
  call Hloop_QA_W(ntryL,G1H6(18),ex2(:),G1H3(33),m3h2x3(:,45),heltab2x6(:,:,70))
  call Hloop_QA_W(ntryL,G1H6(19),ex2(:),G1H3(36),m3h2x3(:,46),heltab2x6(:,:,71))
  call Hloop_SQ_A(ntryL,G0H6(8),ex1(:),G0H3(13),ngH,m3h2x3(:,47),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMB,G1H3(37),n2h3(69))
  call Hloop_SQ_A(ntryL,G0H6(9),ex1(:),G0H3(13),ngX,m3h2x3(:,48),heltab2x6(:,:,73))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMB,G1H3(38),n2h3(70))
  call Hloop_SQ_A(ntryL,G0H6(10),ex1(:),G0H3(13),ngPtb,m3h2x3(:,49),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMT,G1H3(71),n2h3(71))
  call Hloop_AQ_S(ntryL,G1H6(20),ex1(:),G1H3(85),ngH,m3h2x3(:,50),heltab2x6(:,:,75))
  call Hloop_AQ_S(ntryL,G1H6(27),ex1(:),G1H3(86),ngX,m3h2x3(:,51),heltab2x6(:,:,76))
  call Hloop_AQ_S(ntryL,G1H6(28),ex1(:),G1H3(87),ngPtb,m3h2x3(:,52),heltab2x6(:,:,77))
  call Hloop_VQ_A(ntryL,G0H6(14),ex1(:),G0H3(13),m3h2x3(:,53),heltab2x6(:,:,78))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMB,G1H3(88),n2h3(72))
  call Hloop_ZQ_A(ntryL,G0H6(12),ex1(:),G0H3(13),ngZd,m3h2x3(:,54),heltab2x6(:,:,79))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMB,G1H3(89),n2h3(73))
  call Hloop_WQ_A(ntryL,G0H6(13),ex1(:),G0H3(13),m3h2x3(:,55),heltab2x6(:,:,80))
  call Hloop_Q_A(ntryL,G0H3(13),11,nMT,G1H3(90),n2h3(74))
  call Hloop_AQ_S(ntryL,G1H6(29),ex1(:),G1H3(91),ngH,m3h2x3(:,56),heltab2x6(:,:,81))
  call Hloop_AQ_S(ntryL,G1H6(30),ex1(:),G1H3(92),ngPtb,m3h2x3(:,57),heltab2x6(:,:,82))
  call Hloop_AQ_Z(ntryL,G1H6(34),ex1(:),G1H3(93),ngZd,m3h2x3(:,58),heltab2x6(:,:,83))
  call Hloop_AQ_W(ntryL,G1H6(35),ex1(:),G1H3(94),m3h2x3(:,59),heltab2x6(:,:,84))
  call Hloop_AQ_W(ntryL,G1H6(36),ex1(:),G1H3(95),m3h2x3(:,60),heltab2x6(:,:,85))
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(16),ngH,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_S(ntryL,G1H4(2),ex1(:),G1H2(1),ngX,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(17),ngPtb,m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_V(ntryL,G1H4(7),ex1(:),G1H2(20),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_Z(ntryL,G1H4(5),ex1(:),G1H2(5),ngZd,m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_AQ_W(ntryL,G1H4(6),ex1(:),G1H2(3),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_SQ_A(ntryL,G1H4(8),ex1(:),G1H2(6),ngX,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G1H2(6),13,nMB,G2H2(5),n2h2(22))
  call Hloop_SQ_A(ntryL,G1H4(9),ex1(:),G1H2(7),ngPtb,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(7),13,nMT,G2H2(6),n2h2(23))
  call Hloop_ZQ_A(ntryL,G1H4(10),ex1(:),G1H2(6),ngZd,m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G1H2(6),13,nMB,G2H2(8),n2h2(24))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(7),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(7),13,nMT,G2H2(9),n2h2(25))
  call Hloop_ZQ_A(ntryL,G0H4(8),ex1(:),G0H2(1),ngZd,m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_Q_A(ntryL,G0H2(1),13,nMB,G1H2(6),n2h2(26))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(37),[G1H3(9)])
call HGT_OLR(G1H3(3),1,1,3)
call HGT_invQ_OLR(G1H3(3),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(3),[G1H3(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(89),[G1H3(38),G1H3(14)])
call HGT_OLR(G1H3(4),1,1,3)
call HGT_invQ_OLR(G1H3(4),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(4),[G1H3(89)])
call ol_merge_last(G1H3(6), G1H3(6)) 
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(6),[G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(90),[G1H3(71),G1H3(19)])
call HGT_OLR(G1H3(6),1,1,3)
call HGT_invQ_OLR(G1H3(6),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(6),[G1H3(90)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(55),[G2H3(39),G2H3(18),G2H3(6),G1H3(40),G1H3(15) &
    ,G1H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(51),[G2H3(35),G2H3(22),G2H3(4),G1H3(20)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(85),[G1H3(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(41),[G1H3(64),G1H3(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(86),[G1H3(29)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(56),[G1H3(1),G1H3(69),G1H3(30)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(87),[G1H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(59),[G2H3(57),G1H3(62),G1H3(60),G1H3(45),G1H3(35),G0H3(8) &
    ,G0H3(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(88),[G1H3(39)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(95),[G1H3(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(67),[G2H3(65),G1H3(70),G1H3(66),G1H3(55),G1H3(44) &
    ,G0H3(12),G0H3(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(48)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(53),[G2H3(37),G2H3(17),G2H3(5),G1H3(79),G1H3(54) &
    ,G1H3(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(26),[G1H3(16),G1H3(53)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(27),[G1H3(17),G1H3(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(49),[G2H3(33),G2H3(21),G2H3(9),G1H3(59)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(18),[G1H3(63)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(21),[G1H3(68)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(22),[G1H3(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(58),[G2H3(56),G1H3(61),G1H3(57),G1H3(42),G1H3(74),G0H3(7) &
    ,G0H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(23),[G1H3(78)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(36),[G1H3(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(66),[G2H3(64),G1H3(67),G1H3(65),G1H3(52),G1H3(83) &
    ,G0H3(11),G0H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(8),[G1H2(11)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(9),[G1H2(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(6),[G1H2(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(42),[G2H3(26),G2H3(7),G2H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(43),[G2H3(27),G2H3(10),G2H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(44),[G2H3(28),G2H3(11),G2H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(45),[G2H3(29),G2H3(12),G2H3(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(46),[G2H3(30),G2H3(13),G2H3(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(47),[G2H3(31),G2H3(14),G2H3(8)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(62),[G2H3(60),G1H3(50),G1H3(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(63),[G2H3(61),G1H3(51),G1H3(47)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(19),[G0H3(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(23),[G2H3(20),G1H3(8),G1H3(7),G1H3(84),G1H3(81),G1H3(75) &
    ,G1H3(72),G0H3(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(25),[G2H3(24),G1H3(12),G1H3(11),G1H3(2),G1H3(80),G1H3(77) &
    ,G1H3(76),G0H3(2)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(48),[G2H3(32)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(50),[G2H3(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(52),[G2H3(36)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H3(54),[G2H3(38)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(2),[G1H6(24)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(3),[G1H6(33)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(6),[G1H6(26)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(5),[G1H6(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(7),[G1H6(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H6(8),[G1H6(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(5),[G1H2(6)])
  call Hloop_QZ_A(ntryL,G1H3(3),ex3(:),G1H1(1),ngZd,m3h3x1(:,57),heltab2x3(:,:,57))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(32),n2h1(46))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(3),ngX,m3h2x1(:,23),heltab2x2(:,:,23))
  call Hloop_QZ_A(ntryL,G1H3(4),ex3(:),G1H1(1),ngZd,m3h3x1(:,58),heltab2x3(:,:,58))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(47))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(10),ex2(:),G2tensor(2),ngH,m3h2x1(:,24),heltab2x2(:,:,24))
  call Hloop_QZ_A(ntryL,G1H3(6),ex3(:),G1H1(1),ngZu,m3h3x1(:,59),heltab2x3(:,:,59))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(56),n2h1(48))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(13),ex2(:),G2tensor(6),ngPbt,m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(16),ex2(:),G2tensor(4),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hloop_QZ_A(ntryL,G2H3(55),ex3(:),G2H1(1),ngZd,m3h3x1(:,60),heltab2x3(:,:,60))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(1),n2h1(49))
  call Hloop_QZ_A(ntryL,G2H3(51),ex3(:),G2H1(1),ngZu,m3h3x1(:,61),heltab2x3(:,:,61))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(2),n2h1(50))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(85),11,ex3(:),4,G2tensor(5),m3h3x1(:,62),heltab2x3(:,:,62))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(41),11,ex3(:),4,G2tensor(7),m3h3x1(:,63),heltab2x3(:,:,63))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(86),11,ex3(:),4,G2tensor(8),m3h3x1(:,64),heltab2x3(:,:,64))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(56),11,ex3(:),4,G2tensor(13),m3h3x1(:,65),heltab2x3(:,:,65))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(87),11,ex3(:),4,G2tensor(71),m3h3x1(:,66),heltab2x3(:,:,66))
  call Hcheck_last_TV_S(ntryL,l_switch,G2H3(59),11,ex3(:),4,G3tensor(3),m3h3x1(:,67),heltab2x3(:,:,67))
  call Hloop_QZ_A(ntryL,G1H3(88),ex3(:),G1H1(1),ngZd,m3h3x1(:,68),heltab2x3(:,:,68))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(26),n2h1(51))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(95),11,ex3(:),4,G2tensor(38),m3h3x1(:,69),heltab2x3(:,:,69))
  call Hcheck_last_UV_W(ntryL,l_switch,G2H3(67),11,ex3(:),4,G3tensor(4),m3h3x1(:,70),heltab2x3(:,:,70))
  call Hloop_AZ_Q(ntryL,G1H3(13),ex3(:),G1H1(1),ngZd,m3h3x1(:,71),heltab2x3(:,:,71))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(29),n2h1(52))
  call Hloop_AZ_Q(ntryL,G2H3(53),ex3(:),G2H1(1),ngZd,m3h3x1(:,72),heltab2x3(:,:,72))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMB,G3tensor(5),n2h1(53))
  call Hloop_AZ_Q(ntryL,G1H3(26),ex3(:),G1H1(1),ngZd,m3h3x1(:,73),heltab2x3(:,:,73))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(50),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex3(:),G1H1(1),ngZu,m3h3x1(:,74),heltab2x3(:,:,74))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(62),n2h1(55))
  call Hloop_AZ_Q(ntryL,G2H3(49),ex3(:),G2H1(1),ngZu,m3h3x1(:,75),heltab2x3(:,:,75))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMT,G3tensor(6),n2h1(56))
  call Hcheck_last_TV_S(ntryL,l_switch,G1H3(18),11,ex3(:),4,G2tensor(53),m3h3x1(:,76),heltab2x3(:,:,76))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(21),11,ex3(:),4,G2tensor(9),m3h3x1(:,77),heltab2x3(:,:,77))
  call Hcheck_last_SV_T(ntryL,l_switch,G1H3(22),11,ex3(:),4,G2tensor(65),m3h3x1(:,78),heltab2x3(:,:,78))
  call Hcheck_last_SV_T(ntryL,l_switch,G2H3(58),11,ex3(:),4,G3tensor(7),m3h3x1(:,79),heltab2x3(:,:,79))
  call Hloop_AZ_Q(ntryL,G1H3(23),ex3(:),G1H1(1),ngZd,m3h3x1(:,80),heltab2x3(:,:,80))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(11),n2h1(57))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(36),11,ex3(:),4,G2tensor(15),m3h3x1(:,81),heltab2x3(:,:,81))
  call Hcheck_last_UW_V(ntryL,l_switch,G2H3(66),11,ex3(:),4,G3tensor(8),m3h3x1(:,82),heltab2x3(:,:,82))
  call Hloop_SA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),ngX,m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(17),n2h1(58))
  call Hloop_SA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngX,m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(20),n2h1(59))
  call Hloop_SA_Q(ntryL,G1H2(9),ex2(:),G1H1(1),ngH,m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(23),n2h1(60))
  call Hloop_SA_Q(ntryL,G1H2(10),ex2(:),G1H1(1),ngH,m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(35),n2h1(61))
  call Hloop_SA_Q(ntryL,G1H2(14),ex2(:),G1H1(1),ngPbt,m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(41),n2h1(62))
  call Hloop_SA_Q(ntryL,G1H2(15),ex2(:),G1H1(1),ngPbt,m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(44),n2h1(63))
  call Hloop_WA_Q(ntryL,G1H2(18),ex2(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(47),n2h1(64))
  call Hloop_WA_Q(ntryL,G1H2(19),ex2(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(59),n2h1(65))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(68),ngX,m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(74),ngH,m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(77),ngPbt,m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(78),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_QA_S(ntryL,l_switch,G1H2(8),ex2(:),G1tensor(1),ngH,m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(8),ex2(:),G2tensor(79),ngX,m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(9),ex2(:),G2tensor(80),ngPbt,m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(81),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hloop_AZ_Q(ntryL,G2H3(42),ex3(:),G2H1(1),ngZl,m3h3x1(:,83),heltab2x3(:,:,83))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nME,G3tensor(9),n2h1(66))
  call Hloop_AZ_Q(ntryL,G2H3(43),ex3(:),G2H1(1),ngZl,m3h3x1(:,84),heltab2x3(:,:,84))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(10),n2h1(67))
  call Hloop_AZ_Q(ntryL,G2H3(44),ex3(:),G2H1(1),ngZl,m3h3x1(:,85),heltab2x3(:,:,85))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,nML,G3tensor(11),n2h1(68))
  call Hloop_QZ_A(ntryL,G2H3(45),ex3(:),G2H1(1),ngZl,m3h3x1(:,86),heltab2x3(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nME,G3tensor(12),n2h1(69))
  call Hloop_QZ_A(ntryL,G2H3(46),ex3(:),G2H1(1),ngZl,m3h3x1(:,87),heltab2x3(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nMM,G3tensor(13),n2h1(70))
  call Hloop_QZ_A(ntryL,G2H3(47),ex3(:),G2H1(1),ngZl,m3h3x1(:,88),heltab2x3(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,nML,G3tensor(14),n2h1(71))
  call Hcheck_last_DV_C(ntryL,l_switch,G2H3(62),11,ex3(:),G3tensor(15),m3h3x1(:,89),heltab2x3(:,:,89))
  call Hcheck_last_CV_D(ntryL,l_switch,G2H3(63),11,ex3(:),4,G3tensor(16),m3h3x1(:,90),heltab2x3(:,:,90))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(19),ex3(:),G2tensor(82),m3h3x1(:,91),heltab2x3(:,:,91))
  call Hcheck_last_VV_S(ntryL,l_switch,G2H3(23),ex3(:),G2tensor(83),m3h3x1(:,92),heltab2x3(:,:,92))
  call Hcheck_last_SV_V(ntryL,l_switch,G0H3(1),ex3(:),G0tensor(1),m3h3x1(:,93),heltab2x3(:,:,93))
  call Hcheck_last_SV_V(ntryL,l_switch,G2H3(25),ex3(:),G2tensor(84),m3h3x1(:,94),heltab2x3(:,:,94))
  call Hloop_AZ_Q(ntryL,G2H3(48),ex3(:),G2H1(1),ngZu,m3h3x1(:,95),heltab2x3(:,:,95))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(17),n2h1(72))
  call Hloop_QZ_A(ntryL,G2H3(50),ex3(:),G2H1(1),ngZu,m3h3x1(:,96),heltab2x3(:,:,96))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(18),n2h1(73))
  call Hloop_AZ_Q(ntryL,G2H3(52),ex3(:),G2H1(1),ngZd,m3h3x1(:,97),heltab2x3(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(19),n2h1(74))
  call Hloop_QZ_A(ntryL,G2H3(54),ex3(:),G2H1(1),ngZd,m3h3x1(:,98),heltab2x3(:,:,98))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(20),n2h1(75))
  call Hloop_AZ_Q(ntryL,G2H3(40),ex3(:),G2H1(1),ngZn,m3h3x1(:,99),heltab2x3(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G2H1(1),15,0,G3tensor(21),n2h1(76))
  call Hloop_QZ_A(ntryL,G2H3(41),ex3(:),G2H1(1),ngZn,m3h3x1(:,100),heltab2x3(:,:,100))
  call Hcheck_last_Q_A(ntryL,l_switch,G2H1(1),15,0,G3tensor(22),n2h1(77))
  call Hloop_SQ_A(ntryL,G1H6(37),wf6(:,3),G1H1(1),ngH,m3h6x1(:,1),heltab2x6(:,:,86))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(85),n2h1(78))
  call Hloop_SQ_A(ntryL,G1H6(38),wf6(:,3),G1H1(1),ngX,m3h6x1(:,2),heltab2x6(:,:,87))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(86),n2h1(79))
  call Hloop_SQ_A(ntryL,G1H6(9),wf6(:,3),G1H1(1),ngPtb,m3h6x1(:,3),heltab2x6(:,:,88))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(87),n2h1(80))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H6(1),wf6(:,3),G2tensor(88),ngX,m3h6x1(:,4),heltab2x6(:,:,89))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H6(2),wf6(:,3),G2tensor(89),ngH,m3h6x1(:,5),heltab2x6(:,:,90))
  call Hcheck_last_AQ_S(ntryL,l_switch,G2H6(3),wf6(:,3),G2tensor(90),ngPtb,m3h6x1(:,6),heltab2x6(:,:,91))
  call Hloop_VQ_A(ntryL,G1H6(11),wf6(:,3),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,92))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(91),n2h1(81))
  call Hloop_ZQ_A(ntryL,G1H6(22),wf6(:,3),G1H1(1),ngZd,m3h6x1(:,8),heltab2x6(:,:,93))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(92),n2h1(82))
  call Hloop_WQ_A(ntryL,G1H6(21),wf6(:,3),G1H1(1),m3h6x1(:,9),heltab2x6(:,:,94))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(93),n2h1(83))
  call Hcheck_last_AQ_Z(ntryL,l_switch,G1H6(25),wf6(:,3),G1tensor(6),ngZd,m3h6x1(:,10),heltab2x6(:,:,95))
  call Hcheck_last_AQ_W(ntryL,l_switch,G2H6(6),wf6(:,3),G2tensor(94),m3h6x1(:,11),heltab2x6(:,:,96))
  call Hloop_SA_Q(ntryL,G1H6(1),wf6(:,12),G1H1(1),ngH,m3h6x1(:,12),heltab2x6(:,:,97))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(95),n2h1(84))
  call Hloop_SA_Q(ntryL,G1H6(2),wf6(:,12),G1H1(1),ngX,m3h6x1(:,13),heltab2x6(:,:,98))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(96),n2h1(85))
  call Hloop_SA_Q(ntryL,G1H6(4),wf6(:,12),G1H1(1),ngPbt,m3h6x1(:,14),heltab2x6(:,:,99))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(97),n2h1(86))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(4),wf6(:,12),G2tensor(98),ngX,m3h6x1(:,15),heltab2x6(:,:,100))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(5),wf6(:,12),G2tensor(99),ngH,m3h6x1(:,16),heltab2x6(:,:,101))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H6(7),wf6(:,12),G2tensor(100),ngPbt,m3h6x1(:,17),heltab2x6(:,:,102))
  call Hloop_VA_Q(ntryL,G1H6(32),wf6(:,12),G1H1(1),m3h6x1(:,18),heltab2x6(:,:,103))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(101),n2h1(87))
  call Hloop_ZA_Q(ntryL,G1H6(3),wf6(:,12),G1H1(1),ngZd,m3h6x1(:,19),heltab2x6(:,:,104))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(102),n2h1(88))
  call Hloop_WA_Q(ntryL,G1H6(10),wf6(:,12),G1H1(1),m3h6x1(:,20),heltab2x6(:,:,105))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(103),n2h1(89))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(12),wf6(:,12),G1tensor(11),ngZd,m3h6x1(:,21),heltab2x6(:,:,106))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H6(8),wf6(:,12),G2tensor(104),m3h6x1(:,22),heltab2x6(:,:,107))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(28),ex3(:),G1tensor(16),m3h3x1(:,101),heltab2x3(:,:,101))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(31),ex3(:),G1tensor(21),m3h3x1(:,102),heltab2x3(:,:,102))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(32),ex3(:),G1tensor(26),m3h3x1(:,103),heltab2x3(:,:,103))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(33),ex3(:),G1tensor(31),m3h3x1(:,104),heltab2x3(:,:,104))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(91),ex3(:),G1tensor(36),m3h3x1(:,105),heltab2x3(:,:,105))
  call Hcheck_last_SV_V(ntryL,l_switch,G1H3(92),ex3(:),G1tensor(41),m3h3x1(:,106),heltab2x3(:,:,106))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(93),ex3(:),G1tensor(46),m3h3x1(:,107),heltab2x3(:,:,107))
  call Hcheck_last_VV_S(ntryL,l_switch,G1H3(94),ex3(:),G1tensor(51),m3h3x1(:,108),heltab2x3(:,:,108))
  call Hloop_SA_Q(ntryL,G1H2(16),ex2(:),G1H1(1),ngH,m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(105),n2h1(90))
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngX,m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(106),n2h1(91))
  call Hloop_SA_Q(ntryL,G1H2(17),ex2(:),G1H1(1),ngPbt,m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(107),n2h1(92))
  call Hloop_VA_Q(ntryL,G1H2(20),ex2(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(108),n2h1(93))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngZd,m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(109),n2h1(94))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(110),n2h1(95))
  call Hcheck_last_QA_Z(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(111),ngZd,m3h2x1(:,49),heltab2x2(:,:,49))
  call ol_merge_tensors(G2tensor(98),[G2tensor(52),G2tensor(10),G1tensor(11),G1tensor(35),G1tensor(20),G0tensor(35) &
    ,G0tensor(20)])
  call ol_merge_tensors(G2tensor(99),[G2tensor(55),G2tensor(12),G1tensor(45),G1tensor(30),G0tensor(45),G0tensor(30)])
  call ol_merge_tensors(G2tensor(104),[G2tensor(100),G2tensor(64),G2tensor(58),G2tensor(16),G2tensor(14),G1tensor(50),G1tensor(25) &
    ,G0tensor(50),G0tensor(25)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G2tensor(85),[G2tensor(19),G1tensor(55),G0tensor(55)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(57),G0tensor(57)])
  call ol_merge_tensors(G2tensor(92),[G2tensor(86),G2tensor(22),G1tensor(60),G0tensor(60)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(62),G0tensor(62)])
  call ol_merge_tensors(G2tensor(93),[G2tensor(87),G2tensor(25),G1tensor(65),G0tensor(65)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(2),G0tensor(2)])
  call ol_merge_tensors(G2tensor(88),[G2tensor(28),G1tensor(6),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(89),[G2tensor(31),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(33),G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(94),[G2tensor(90),G2tensor(40),G2tensor(34),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(36),[G1tensor(67),G0tensor(67)])
  call ol_merge_tensors(G2tensor(91),[G2tensor(37),G1tensor(70),G0tensor(70)])
  call ol_merge_tensors(G2tensor(105),[G2tensor(42),G1tensor(72),G0tensor(72)])
  call ol_merge_tensors(G2tensor(95),[G2tensor(67),G2tensor(43),G1tensor(75),G1tensor(40),G0tensor(75),G0tensor(40)])
  call ol_merge_tensors(G2tensor(109),[G2tensor(106),G2tensor(45),G1tensor(77),G0tensor(77)])
  call ol_merge_tensors(G2tensor(102),[G2tensor(96),G2tensor(70),G2tensor(46),G1tensor(95),G1tensor(80),G0tensor(95) &
    ,G0tensor(80)])
  call ol_merge_tensors(G2tensor(110),[G2tensor(107),G2tensor(48),G1tensor(82),G0tensor(82)])
  call ol_merge_tensors(G2tensor(103),[G2tensor(97),G2tensor(76),G2tensor(73),G2tensor(49),G1tensor(100),G1tensor(85) &
    ,G0tensor(100),G0tensor(85)])
  call ol_merge_tensors(G2tensor(51),[G1tensor(1),G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G2tensor(111),[G2tensor(79),G2tensor(54),G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(81),[G2tensor(80),G2tensor(63),G2tensor(57),G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(108),[G2tensor(60),G1tensor(87),G0tensor(87)])
  call ol_merge_tensors(G2tensor(101),[G2tensor(61),G1tensor(90),G0tensor(90)])
  call ol_merge_tensors(G2tensor(5),[G2tensor(66),G1tensor(36),G1tensor(37),G1tensor(3),G0tensor(37),G0tensor(3)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(69),G1tensor(46),G1tensor(92),G1tensor(13),G0tensor(92),G0tensor(13)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(71),G2tensor(75),G2tensor(72),G1tensor(51),G1tensor(41),G1tensor(97),G1tensor(8) &
    ,G0tensor(97),G0tensor(8)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(19),G1tensor(4),G0tensor(1),G0tensor(19),G0tensor(4)])
  call ol_merge_tensors(G3tensor(16),[G3tensor(15),G3tensor(8),G3tensor(7),G3tensor(4),G3tensor(3),G2tensor(84),G2tensor(83) &
    ,G1tensor(24),G1tensor(9),G0tensor(24),G0tensor(9)])
  call ol_merge_tensors(G2tensor(82),[G2tensor(13),G1tensor(29),G1tensor(14),G0tensor(29),G0tensor(14)])
  call ol_merge_tensors(G2tensor(53),[G1tensor(16),G1tensor(18),G0tensor(18)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(65),G1tensor(31),G1tensor(21),G1tensor(23),G0tensor(23)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(26),G1tensor(28),G0tensor(28)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(53),G1tensor(32),G0tensor(53),G0tensor(32)])
  call ol_merge_tensors(G2tensor(68),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(34),G0tensor(34)])
  call ol_merge_tensors(G2tensor(17),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(20),[G1tensor(39),G0tensor(39)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(58),G1tensor(42),G0tensor(58),G0tensor(42)])
  call ol_merge_tensors(G2tensor(74),[G1tensor(43),G0tensor(43)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(44),G0tensor(44)])
  call ol_merge_tensors(G2tensor(56),[G1tensor(63),G1tensor(47),G0tensor(63),G0tensor(47)])
  call ol_merge_tensors(G2tensor(78),[G2tensor(77),G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(4),[G2tensor(6),G1tensor(49),G0tensor(49)])
  call ol_merge_tensors(G3tensor(5),[G3tensor(1),G1tensor(89),G1tensor(79),G1tensor(74),G1tensor(69),G1tensor(59),G1tensor(54) &
    ,G0tensor(89),G0tensor(79),G0tensor(74),G0tensor(69),G0tensor(59),G0tensor(54)])
  call ol_merge_tensors(G3tensor(6),[G3tensor(2),G1tensor(84),G1tensor(64),G0tensor(84),G0tensor(64)])
  call ol_merge_tensors(G2tensor(26),[G1tensor(68),G0tensor(68)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(73),G0tensor(73)])
  call ol_merge_tensors(G2tensor(50),[G1tensor(78),G0tensor(78)])
  call ol_merge_tensors(G2tensor(62),[G1tensor(83),G0tensor(83)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(88),G0tensor(88)])
  call ol_merge_tensors(G2tensor(23),[G1tensor(93),G0tensor(93)])
  call ol_merge_tensors(G2tensor(35),[G1tensor(94),G0tensor(94)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(41),G1tensor(98),G0tensor(98)])
  call ol_merge_tensors(G2tensor(59),[G2tensor(44),G1tensor(99),G0tensor(99)])
  call ol_merge_tensors(G3tensor(12),[G3tensor(9)])
  call ol_merge_tensors(G3tensor(13),[G3tensor(10)])
  call ol_merge_tensors(G3tensor(14),[G3tensor(11)])
  call ol_merge_tensors(G3tensor(22),[G3tensor(21),G3tensor(20),G3tensor(19),G3tensor(18),G3tensor(17)])
  call TI_triangle_red(G2tensor(98),RedBasis(1),mass3set(:,1),G0tensor(6),G0tensor(11),G0tensor(16), &
    G0tensor(21),M2L1R1,[nMZ,nMH,nMB],G0tensor(26),G0tensor(31),G0tensor(36))
  call TI_triangle_red(G2tensor(99),RedBasis(1),mass3set(:,2),G0tensor(41),G0tensor(46),G0tensor(51), &
    G0tensor(56),M2L1R1,[nMH,nMZ,nMB],G0tensor(61),G0tensor(66),G0tensor(71))
  call TI_triangle_red(G2tensor(104),RedBasis(1),mass3set(:,3),G0tensor(76),G0tensor(81),G0tensor(86), &
    G0tensor(91),M2L1R1,[nMW,nMT],G0tensor(96),G0tensor(35))
  call TI_triangle_red(G2tensor(18),RedBasis(8),mass3set(:,4),G0tensor(20),G0tensor(45),G0tensor(30), &
    G0tensor(50),M2L1R1,[nMB,nMH],G0tensor(25),G0tensor(52))
  call TI_triangle_red(G2tensor(85),RedBasis(4),mass3set(:,4),G0tensor(55),G0tensor(57),G0tensor(60), &
    G0tensor(62),M2L1R1,[nMB,nMH],G0tensor(65),G0tensor(2))
  call TI_triangle_red(G2tensor(21),RedBasis(8),mass3set(:,5),G0tensor(5),G0tensor(12),G0tensor(15),G0tensor(7),M2L1R1,[nMB,nMZ], &
    G0tensor(10),G0tensor(67))
  call TI_triangle_red(G2tensor(92),RedBasis(4),mass3set(:,5),G0tensor(70),G0tensor(72),G0tensor(75), &
    G0tensor(40),M2L1R1,[nMB,nMZ],G0tensor(77),G0tensor(95))
  call TI_triangle_red(G2tensor(24),RedBasis(8),mass3set(:,6),G0tensor(80),G0tensor(82),G0tensor(100), &
    G0tensor(85),M2L1R1,[nMT,nMW],G0tensor(17),G0tensor(27))
  call TI_triangle_red(G2tensor(93),RedBasis(4),mass3set(:,6),G0tensor(22),G0tensor(87),G0tensor(90), &
    G0tensor(37),M2L1R1,[nMT,nMW],G0tensor(3),G0tensor(92))
  call TI_triangle_red(G2tensor(27),RedBasis(8),mass3set(:,7),G0tensor(13),G0tensor(97),G0tensor(8),G0tensor(1),M2L1R1,[nMH,nMB], &
    G0tensor(19),G0tensor(4))
  call TI_triangle_red(G2tensor(88),RedBasis(4),mass3set(:,1),G0tensor(24),G0tensor(9),G0tensor(29), &
    G0tensor(14),M2L1R1,[nMZ,nMH,nMB],G0tensor(18),G0tensor(23),G0tensor(28))
  call TI_triangle_red(G2tensor(30),RedBasis(8),mass3set(:,8),G0tensor(53),G0tensor(32),G0tensor(33), &
    G0tensor(34),M2L1R1,[nMZ,nMB],G0tensor(38),G0tensor(39))
  call TI_triangle_red(G2tensor(89),RedBasis(4),mass3set(:,2),G0tensor(58),G0tensor(42),G0tensor(43), &
    G0tensor(44),M2L1R1,[nMH,nMZ,nMB],G0tensor(63),G0tensor(47),G0tensor(48))
  call TI_triangle_red(G2tensor(39),RedBasis(8),mass3set(:,3),G0tensor(49),G0tensor(89),G0tensor(79), &
    G0tensor(74),M2L1R1,[nMW,nMT],G0tensor(69),G0tensor(59))
  call TI_triangle_red(G2tensor(94),RedBasis(4),mass3set(:,3),G0tensor(54),G0tensor(84),G0tensor(64), &
    G0tensor(68),M2L1R1,[nMW,nMT],G0tensor(73),G0tensor(78))
  call TI_triangle_red(G2tensor(36),RedBasis(8),mass3set(:,9),G0tensor(83),G0tensor(88),G0tensor(93),G0tensor(94),M2L1R1,[nMB], &
    G0tensor(98))
  call TI_triangle_red(G2tensor(91),RedBasis(4),mass3set(:,9),G0tensor(99),G0tensor(101),G0tensor(102),G0tensor(103),M2L1R1,[nMB], &
    G0tensor(104))
  call TI_triangle_red(G2tensor(105),RedBasis(9),mass3set(:,4),G0tensor(105),G0tensor(106),G0tensor(107), &
    G0tensor(108),M2L1R1,[nMB,nMH],G0tensor(109),G0tensor(110))
  call TI_triangle_red(G2tensor(95),RedBasis(1),mass3set(:,4),G0tensor(111),G0tensor(112),G0tensor(113), &
    G0tensor(114),M2L1R1,[nMB,nMH],G0tensor(115),G0tensor(116))
  call TI_triangle_red(G2tensor(109),RedBasis(9),mass3set(:,5),G0tensor(117),G0tensor(118),G0tensor(119), &
    G0tensor(120),M2L1R1,[nMB,nMZ],G0tensor(121),G0tensor(122))
  call TI_triangle_red(G2tensor(102),RedBasis(1),mass3set(:,5),G0tensor(123),G0tensor(124),G0tensor(125), &
    G0tensor(126),M2L1R1,[nMB,nMZ],G0tensor(127),G0tensor(128))
  call TI_triangle_red(G2tensor(110),RedBasis(9),mass3set(:,6),G0tensor(129),G0tensor(130),G0tensor(131), &
    G0tensor(132),M2L1R1,[nMT,nMW],G0tensor(133),G0tensor(134))
  call TI_triangle_red(G2tensor(103),RedBasis(1),mass3set(:,6),G0tensor(135),G0tensor(136),G0tensor(137), &
    G0tensor(138),M2L1R1,[nMT,nMW],G0tensor(139),G0tensor(140))
  call TI_triangle_red(G2tensor(51),RedBasis(9),mass3set(:,7),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMH,nMB],G0tensor(145),G0tensor(146))
  call TI_triangle_red(G2tensor(111),RedBasis(9),mass3set(:,8),G0tensor(147),G0tensor(148),G0tensor(149), &
    G0tensor(150),M2L1R1,[nMZ,nMB],G0tensor(151),G0tensor(152))
  call TI_triangle_red(G2tensor(81),RedBasis(9),mass3set(:,3),G0tensor(153),G0tensor(154),G0tensor(155), &
    G0tensor(156),M2L1R1,[nMW,nMT],G0tensor(157),G0tensor(158))
  call TI_triangle_red(G2tensor(108),RedBasis(9),mass3set(:,9),G0tensor(159),G0tensor(160),G0tensor(161), &
    G0tensor(162),M2L1R1,[nMB],G0tensor(163))
  call TI_triangle_red(G2tensor(101),RedBasis(1),mass3set(:,9),G0tensor(164),G0tensor(165),G0tensor(166), &
    G0tensor(167),M2L1R1,[nMB],G0tensor(168))
  call TI_triangle_red(G2tensor(5),RedBasis(6),mass3set(:,10),G0tensor(169),G0tensor(170),G0tensor(171), &
    G0tensor(172),M2L1R1,[nMZ,nMB,nMH],G0tensor(173),G0tensor(174),G0tensor(175))
  call TI_triangle_red(G2tensor(8),RedBasis(6),mass3set(:,11),G0tensor(176),G0tensor(177),G0tensor(178), &
    G0tensor(179),M2L1R1,[nMH,nMB,nMZ],G0tensor(180),G0tensor(181),G0tensor(182))
  call TI_triangle_red(G2tensor(38),RedBasis(6),mass3set(:,12),G0tensor(183),G0tensor(184),G0tensor(185), &
    G0tensor(186),M2L1R1,[nMW,nMT],G0tensor(187),G0tensor(188))
  call TI_triangle_red(G2tensor(7),RedBasis(5),mass3set(:,13),G0tensor(189),G0tensor(190),G0tensor(191), &
    G0tensor(192),M2L1R1,[nMZ,nMH],G0tensor(193),G0tensor(194))
  call TI_triangle_red(G3tensor(16),RedBasis(5),mass3set(:,14),G0tensor(195),G0tensor(196),G0tensor(197), &
    G0tensor(198),M2L1R1,[nMW],G0tensor(199))
  call TI_triangle_red(G2tensor(82),RedBasis(5),mass3set(:,15),G0tensor(200),G0tensor(201),G0tensor(202), &
    G0tensor(203),M2L1R1,[nMH,nMZ],G0tensor(204),G0tensor(205))
  call TI_triangle_red(G2tensor(53),RedBasis(7),mass3set(:,10),G0tensor(206),G0tensor(207),G0tensor(208), &
    G0tensor(209),M2L1R1,[nMZ,nMB,nMH],G0tensor(210),G0tensor(211),G0tensor(212))
  call TI_triangle_red(G2tensor(15),RedBasis(7),mass3set(:,12),G0tensor(213),G0tensor(214),G0tensor(215), &
    G0tensor(216),M2L1R1,[nMW,nMT],G0tensor(217),G0tensor(218))
  call TI_triangle_red(G2tensor(9),RedBasis(7),mass3set(:,11),G0tensor(219),G0tensor(220),G0tensor(221), &
    G0tensor(222),M2L1R1,[nMH,nMB,nMZ],G0tensor(223),G0tensor(224),G0tensor(225))
  call TI_triangle_red(G2tensor(32),RedBasis(6),mass3set(:,16),G0tensor(226),G0tensor(227),G0tensor(228), &
    G0tensor(229),M2L1R1,[nMB,nMH],G0tensor(230),G0tensor(231))
  call TI_triangle_red(G2tensor(68),RedBasis(3),mass3set(:,17),G0tensor(232),G0tensor(233),G0tensor(234), &
    G0tensor(235),M2L1R1,[nMZ,nMB],G0tensor(236),G0tensor(237))
  call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,1),G0tensor(238),G0tensor(239),G0tensor(240), &
    G0tensor(241),M2L1R1,[nMZ,nMH,nMB],G0tensor(242),G0tensor(243),G0tensor(244))
  call TI_triangle_red(G2tensor(17),RedBasis(3),mass3set(:,18),G0tensor(245),G0tensor(246),G0tensor(247), &
    G0tensor(248),M2L1R1,[nMB,nMH,nMZ],G0tensor(249),G0tensor(250),G0tensor(251))
  call TI_triangle_red(G2tensor(20),RedBasis(2),mass3set(:,5),G0tensor(252),G0tensor(253),G0tensor(254), &
    G0tensor(255),M2L1R1,[nMB,nMZ],G0tensor(256),G0tensor(257))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,19),G0tensor(258),G0tensor(259),G0tensor(260), &
    G0tensor(261),M2L1R1,[nMB,nMZ],G0tensor(262),G0tensor(263))
  call TI_triangle_red(G2tensor(74),RedBasis(3),mass3set(:,20),G0tensor(264),G0tensor(265),G0tensor(266), &
    G0tensor(267),M2L1R1,[nMH,nMB],G0tensor(268),G0tensor(269))
  call TI_triangle_red(G2tensor(2),RedBasis(2),mass3set(:,2),G0tensor(270),G0tensor(271),G0tensor(272), &
    G0tensor(273),M2L1R1,[nMH,nMZ,nMB],G0tensor(274),G0tensor(275),G0tensor(276))
  call TI_triangle_red(G2tensor(56),RedBasis(6),mass3set(:,21),G0tensor(277),G0tensor(278),G0tensor(279), &
    G0tensor(280),M2L1R1,[nMT,nMW],G0tensor(281),G0tensor(282))
  call TI_triangle_red(G2tensor(78),RedBasis(3),mass3set(:,22),G0tensor(283),G0tensor(284),G0tensor(285), &
    G0tensor(286),M2L1R1,[nMW,nMT],G0tensor(287),G0tensor(288))
  call TI_triangle_red(G2tensor(4),RedBasis(2),mass3set(:,3),G0tensor(289),G0tensor(290),G0tensor(291), &
    G0tensor(292),M2L1R1,[nMW,nMT],G0tensor(293),G0tensor(294))
  call TI_triangle_red(G3tensor(5),RedBasis(5),mass3set(:,23),G0tensor(295),G0tensor(296),G0tensor(297), &
    G0tensor(298),M2L1R1,[nMB],G0tensor(299))
  call TI_triangle_red(G3tensor(6),RedBasis(5),mass3set(:,24),G0tensor(300),G0tensor(301),G0tensor(302), &
    G0tensor(303),M2L1R1,[nMT],G0tensor(304))
  call TI_triangle_red(G2tensor(26),RedBasis(6),mass3set(:,25),G0tensor(305),G0tensor(306),G0tensor(307), &
    G0tensor(308),M2L1R1,[nMB],G0tensor(309))
  call TI_triangle_red(G2tensor(29),RedBasis(7),mass3set(:,16),G0tensor(310),G0tensor(311),G0tensor(312), &
    G0tensor(313),M2L1R1,[nMB,nMH],G0tensor(314),G0tensor(315))
  call TI_triangle_red(G2tensor(50),RedBasis(7),mass3set(:,19),G0tensor(316),G0tensor(317),G0tensor(318), &
    G0tensor(319),M2L1R1,[nMB,nMZ],G0tensor(320),G0tensor(321))
  call TI_triangle_red(G2tensor(62),RedBasis(7),mass3set(:,21),G0tensor(322),G0tensor(323),G0tensor(324), &
    G0tensor(325),M2L1R1,[nMT,nMW],G0tensor(326),G0tensor(327))
  call TI_triangle_red(G2tensor(11),RedBasis(7),mass3set(:,25),G0tensor(328),G0tensor(329),G0tensor(330), &
    G0tensor(331),M2L1R1,[nMB],G0tensor(332))
  call TI_triangle_red(G2tensor(23),RedBasis(3),mass3set(:,26),G0tensor(333),G0tensor(334),G0tensor(335), &
    G0tensor(336),M2L1R1,[nMB,nMZ,nMH],G0tensor(337),G0tensor(338),G0tensor(339))
  call TI_triangle_red(G2tensor(35),RedBasis(2),mass3set(:,4),G0tensor(340),G0tensor(341),G0tensor(342), &
    G0tensor(343),M2L1R1,[nMB,nMH],G0tensor(344),G0tensor(345))
  call TI_triangle_red(G2tensor(47),RedBasis(3),mass3set(:,27),G0tensor(346),G0tensor(347),G0tensor(348), &
    G0tensor(349),M2L1R1,[nMT,nMW],G0tensor(350),G0tensor(351))
  call TI_triangle_red(G2tensor(59),RedBasis(2),mass3set(:,6),G0tensor(352),G0tensor(353),G0tensor(354), &
    G0tensor(355),M2L1R1,[nMT,nMW],G0tensor(356),G0tensor(357))
  call TI_triangle_red(G3tensor(12),RedBasis(5),mass3set(:,28),G0tensor(358),G0tensor(359),G0tensor(360), &
    G0tensor(361),M2L1R1,[nME],G0tensor(362))
  call TI_triangle_red(G3tensor(13),RedBasis(5),mass3set(:,29),G0tensor(363),G0tensor(364),G0tensor(365), &
    G0tensor(366),M2L1R1,[nMM],G0tensor(367))
  call TI_triangle_red(G3tensor(14),RedBasis(5),mass3set(:,30),G0tensor(368),G0tensor(369),G0tensor(370), &
    G0tensor(371),M2L1R1,[nML],G0tensor(372))
  call TI_triangle_red(G3tensor(22),RedBasis(5),mass3set(:,31),G0tensor(373),G0tensor(374),G0tensor(375),G0tensor(376),M2L1R1)
  call ol_merge_tensors(T0sum(21),[G0tensor(6)])
  call ol_merge_tensors(T0sum(22),[G0tensor(41)])
  call ol_merge_tensors(T0sum(23),[G0tensor(76)])
  call ol_merge_tensors(T0sum(24),[G0tensor(20)])
  call ol_merge_tensors(T0sum(25),[G0tensor(55)])
  call ol_merge_tensors(T0sum(26),[G0tensor(5)])
  call ol_merge_tensors(T0sum(27),[G0tensor(70)])
  call ol_merge_tensors(T0sum(28),[G0tensor(80)])
  call ol_merge_tensors(T0sum(29),[G0tensor(22)])
  call ol_merge_tensors(T0sum(30),[G0tensor(13)])
  call ol_merge_tensors(T0sum(31),[G0tensor(24)])
  call ol_merge_tensors(T0sum(32),[G0tensor(53)])
  call ol_merge_tensors(T0sum(33),[G0tensor(58)])
  call ol_merge_tensors(T0sum(34),[G0tensor(49)])
  call ol_merge_tensors(T0sum(35),[G0tensor(54)])
  call ol_merge_tensors(T0sum(36),[G0tensor(83)])
  call ol_merge_tensors(T0sum(37),[G0tensor(99)])
  call ol_merge_tensors(T0sum(38),[G0tensor(105)])
  call ol_merge_tensors(T0sum(39),[G0tensor(111)])
  call ol_merge_tensors(T0sum(40),[G0tensor(117)])
  call ol_merge_tensors(T0sum(41),[G0tensor(123)])
  call ol_merge_tensors(T0sum(42),[G0tensor(129)])
  call ol_merge_tensors(T0sum(43),[G0tensor(135)])
  call ol_merge_tensors(T0sum(44),[G0tensor(141)])
  call ol_merge_tensors(T0sum(45),[G0tensor(147)])
  call ol_merge_tensors(T0sum(46),[G0tensor(153)])
  call ol_merge_tensors(T0sum(47),[G0tensor(159)])
  call ol_merge_tensors(T0sum(48),[G0tensor(164)])
  call ol_merge_tensors(T0sum(49),[G0tensor(169)])
  call ol_merge_tensors(T0sum(50),[G0tensor(176)])
  call ol_merge_tensors(T0sum(51),[G0tensor(183)])
  call ol_merge_tensors(T0sum(52),[G0tensor(189)])
  call ol_merge_tensors(T0sum(53),[G0tensor(195)])
  call ol_merge_tensors(T0sum(54),[G0tensor(200)])
  call ol_merge_tensors(T0sum(55),[G0tensor(206)])
  call ol_merge_tensors(T0sum(56),[G0tensor(213)])
  call ol_merge_tensors(T0sum(57),[G0tensor(219)])
  call ol_merge_tensors(T0sum(58),[G0tensor(226)])
  call ol_merge_tensors(T0sum(59),[G0tensor(232)])
  call ol_merge_tensors(T0sum(60),[G0tensor(238)])
  call ol_merge_tensors(T0sum(61),[G0tensor(245)])
  call ol_merge_tensors(T0sum(62),[G0tensor(252)])
  call ol_merge_tensors(T0sum(63),[G0tensor(258)])
  call ol_merge_tensors(T0sum(64),[G0tensor(264)])
  call ol_merge_tensors(T0sum(65),[G0tensor(270)])
  call ol_merge_tensors(T0sum(66),[G0tensor(277)])
  call ol_merge_tensors(T0sum(67),[G0tensor(283)])
  call ol_merge_tensors(T0sum(68),[G0tensor(289)])
  call ol_merge_tensors(T0sum(69),[G0tensor(295)])
  call ol_merge_tensors(T0sum(70),[G0tensor(300)])
  call ol_merge_tensors(T0sum(71),[G0tensor(305)])
  call ol_merge_tensors(T0sum(72),[G0tensor(310)])
  call ol_merge_tensors(T0sum(73),[G0tensor(316)])
  call ol_merge_tensors(T0sum(74),[G0tensor(322)])
  call ol_merge_tensors(T0sum(75),[G0tensor(328)])
  call ol_merge_tensors(T0sum(76),[G0tensor(333)])
  call ol_merge_tensors(T0sum(77),[G0tensor(340)])
  call ol_merge_tensors(T0sum(78),[G0tensor(346)])
  call ol_merge_tensors(T0sum(79),[G0tensor(352)])
  call ol_merge_tensors(T0sum(80),[G0tensor(358)])
  call ol_merge_tensors(T0sum(81),[G0tensor(363)])
  call ol_merge_tensors(T0sum(82),[G0tensor(368)])
  call ol_merge_tensors(T0sum(83),[G0tensor(373)])
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(267),h0tab(:,267),[11,4],[nMH,nMZ],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf4(:,1),G0H3(13),m4h3x4x3(:,1),heltab3x36(:,:,5))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(268),h0tab(:,268),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf4(:,1),G0H3(8),m4h3x4x3(:,2),heltab3x36(:,:,6))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(269),h0tab(:,269),[11,4],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf4(:,1),G0H3(6),m4h3x4x3(:,3),heltab3x36(:,:,7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(270),h0tab(:,270),[11,4],[nMW,nMW],3,1,wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf4(:,5),G0H3(12),m4h3x4x3(:,4),heltab3x36(:,:,8))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(271),h0tab(:,271),[11,4],[nMW,nMW],3,1,wf4(:,5))
  call Hloop_VVS_S(ntryL,G0H36(1),ex4(:),wf4(:,5),G0H3(10),m4h3x4x3(:,5),heltab3x36(:,:,9))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(272),h0tab(:,272),[11,4],[nMW,nMW],3,1,wf4(:,6))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf4(:,6),G0H3(7),m4h3x4x3(:,6),heltab3x36(:,:,10))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(273),h0tab(:,273),[11,4],[nMW,nMW],3,1,wf4(:,7))
  call Hloop_SVV_S(ntryL,G0H36(1),ex4(:),wf4(:,7),G0H3(5),m4h3x4x3(:,7),heltab3x36(:,:,11))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(274),h0tab(:,274),[11,4],[nMW,nMW],3,1,wf4(:,6))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf4(:,6),G0H3(11),m4h3x4x3(:,8),heltab3x36(:,:,12))
  Gcoeff(:)%j = (-(c(39)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(275),h0tab(:,275),[11,4],[nMW,nMW],3,1,wf4(:,7))
  call Hloop_VWW_V(ntryL,G0H36(1),ex4(:),wf4(:,7),G0H3(9),m4h3x4x3(:,9),heltab3x36(:,:,13))
  Gcoeff(:)%j = (c(13)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(276),h0tab(:,276),[8,7],[nMZ,nMH],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(7),m3h3x12(:,217),heltab2x36(:,:,263))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(277),h0tab(:,277),[8,7],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(10),m3h3x12(:,218),heltab2x36(:,:,264))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(278),h0tab(:,278),[8,7],[nMW,nMW],3,1,wf4(:,1))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(1),m3h3x12(:,219),heltab2x36(:,:,265))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(279),h0tab(:,279),[8,7],[nMW,nMW],3,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(2),m3h3x12(:,220),heltab2x36(:,:,266))
  Gcoeff(:)%j = (c(5)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(280),h0tab(:,280),[8,7],[nMW,nMW],3,1,wf4(:,5))
  call Hloop_SV_V(ntryL,G0H36(1),ex4(:),G0H12(3),m3h3x12(:,221),heltab2x36(:,:,267))
  Gcoeff(:)%j = (c(69)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(281),h0tab(:,281),[8,7],[nMW,nMW],3,1,wf4(:,6))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(25),m3h3x12(:,222),heltab2x36(:,:,268))
  Gcoeff(:)%j = (c(72)*M(1,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(282),h0tab(:,282),[8,7],[nMW,nMW],3,1,wf4(:,7))
  call Hloop_TV_S(ntryL,G0H36(1),0,ex4(:),8,G1H12(26),m3h3x12(:,223),heltab2x36(:,:,269))
  Gcoeff(:)%j = (c(45)*M(1,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H36(1),m0h(283),h0tab(:,283),[8,7],[nMW,nMW],3,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H36(1),0,ex4(:),8,G1H12(29),m3h3x12(:,224),heltab2x36(:,:,270))



end subroutine vamp_1

end module ol_vamp_1_ppvv_ew_bbxzz_1_/**/REALKIND
