
! **********************************************************************
module ol_tables_storage_ppvv_ew_bbxzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  ! helicity tables for the 1-loop recursion
integer(intkind2), save :: h0tab(36,353)
integer(intkind2), save :: heltab2x2(2,2,49)
integer(intkind2), save :: heltab2x3(2,3,112)
integer(intkind2), save :: heltab2x4(2,4,54)
integer(intkind2), save :: heltab2x6(2,6,119)
integer(intkind2), save :: heltab2x12(2,12,194)
integer(intkind2), save :: heltab3x12(3,12,7)
integer(intkind2), save :: heltab2x36(2,36,332)
integer(intkind2), save :: heltab3x36(3,36,21)


  ! number of helicity states for openloops recursion steps
integer(intkind2), save :: m0h(353)
integer(intkind2), save :: m3h2x1(3,49)
integer(intkind2), save :: m3h3x1(3,112)
integer(intkind2), save :: m3h4x1(3,39)
integer(intkind2), save :: m3h6x1(3,34)
integer(intkind2), save :: m3h2x2(3,15)
integer(intkind2), save :: m3h3x2(3,25)
integer(intkind2), save :: m3h2x3(3,60)
integer(intkind2), save :: m3h4x3(3,110)
integer(intkind2), save :: m3h9x4(3,63)
integer(intkind2), save :: m3h2x6(3,84)
integer(intkind2), save :: m3h6x6(3,44)
integer(intkind2), save :: m3h3x12(3,225)
integer(intkind2), save :: m4h3x4x1(4,7)
integer(intkind2), save :: m4h3x4x3(4,9)
integer(intkind2), save :: m4h3x3x4(4,12)

integer(intkind2), save :: n2h1(121)
integer(intkind2), save :: n2h2(26)
integer(intkind2), save :: n2h3(74)
integer(intkind2), save :: n2h4(27)
integer(intkind2), save :: n2h6(79)
integer(intkind2), save :: n2h12(86)


contains

!**********************************************************************
subroutine HOL_m3_init()
!**********************************************************************
! initialize m3 arrays for helicity summation
!**********************************************************************
  use KIND_TYPES, only: REALKIND, intkind2

m3h2x1(1,:)=2
m3h2x1(2,:)=1
m3h2x1(3,:)=2
m3h3x1(1,:)=3
m3h3x1(2,:)=1
m3h3x1(3,:)=3
m3h4x1(1,:)=4
m3h4x1(2,:)=1
m3h4x1(3,:)=4
m3h6x1(1,:)=6
m3h6x1(2,:)=1
m3h6x1(3,:)=6
m3h2x2(1,:)=2
m3h2x2(2,:)=2
m3h2x2(3,:)=4
m3h3x2(1,:)=3
m3h3x2(2,:)=2
m3h3x2(3,:)=6
m3h2x3(1,:)=2
m3h2x3(2,:)=3
m3h2x3(3,:)=6
m3h4x3(1,:)=4
m3h4x3(2,:)=3
m3h4x3(3,:)=12
m3h9x4(1,:)=9
m3h9x4(2,:)=4
m3h9x4(3,:)=36
m3h2x6(1,:)=2
m3h2x6(2,:)=6
m3h2x6(3,:)=12
m3h6x6(1,:)=6
m3h6x6(2,:)=6
m3h6x6(3,:)=36
m3h3x12(1,:)=3
m3h3x12(2,:)=12
m3h3x12(3,:)=36
m4h3x4x1(1,:)=3
m4h3x4x1(2,:)=4
m4h3x4x1(3,:)=1
m4h3x4x1(4,:)=12
m4h3x4x3(1,:)=3
m4h3x4x3(2,:)=4
m4h3x4x3(3,:)=3
m4h3x4x3(4,:)=36
m4h3x3x4(1,:)=3
m4h3x3x4(2,:)=3
m4h3x3x4(3,:)=4
m4h3x3x4(4,:)=36

n2h1(:)=1
n2h2(:)=2
n2h3(:)=3
n2h4(:)=4
n2h6(:)=6
n2h12(:)=12


end subroutine HOL_m3_init

!**********************************************************************

end module ol_tables_storage_ppvv_ew_bbxzz_1_/**/REALKIND

! **********************************************************************
module ol_tensor_sum_storage_ppvv_ew_bbxzz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_data_types_/**/REALKIND, only: hol, hcl, met
  use ol_data_types_/**/REALKIND, only: basis, redset4, redset5
  implicit none

  type(met), save :: M2L1R1

  ! Declarations of loop wave function tensors

  type(hol), save :: G0H1(1)
  type(hol), save :: G1H1(1)
  type(hol), save :: G2H1(1)
  type(hol), save :: G0H2(1)
  type(hol), save :: G1H2(20)
  type(hol), save :: G2H2(17)
  type(hol), save :: G0H3(13)
  type(hol), save :: G1H3(95)
  type(hol), save :: G2H3(67)
  type(hol), save :: G0H4(26)
  type(hol), save :: G1H4(29)
  type(hol), save :: G0H6(15)
  type(hol), save :: G1H6(38)
  type(hol), save :: G2H6(18)
  type(hol), save :: G0H12(39)
  type(hol), save :: G1H12(119)
  type(hol), save :: G0H36(1)
  type(hcl), save, dimension(376) :: G0tensor
  type(hcl), save, dimension(100) :: G1tensor
  type(hcl), save, dimension(111) :: G2tensor
  type(hcl), save, dimension(22) :: G3tensor



  ! Declarations for on-the-fly tensor reduction
type (basis),      save :: RedBasis(9)
type (redset4),    save :: RedSet_4(3)
integer, save :: mass2set(0:1,15)
integer, save :: mass3set(0:2,31)
integer, save :: mass4set(0:3,13)



  ! Declarations for TI calls

  integer, save :: momenta_1(2)
  integer, save :: momenta_2(2)
  integer, save :: momenta_3(2)
  integer, save :: momenta_4(2)
  integer, save :: momenta_5(2)
  integer, save :: momenta_6(2)
  integer, save :: momenta_7(2)
  integer, save :: momenta_8(2)
  integer, save :: momenta_9(3)
  integer, save :: momenta_10(3)
  integer, save :: momenta_11(3)
  integer, save :: momenta_12(3)
  integer, save :: momenta_13(3)
  integer, save :: momenta_14(3)
  integer, save :: momenta_15(3)
  integer, save :: momenta_16(3)
  integer, save :: momenta_17(3)
  integer, save :: momenta_18(4)
  integer, save :: momenta_19(4)
  integer, save :: momenta_20(4)

  integer, save :: masses2_1(2)
  integer, save :: masses2_2(2)
  integer, save :: masses2_3(2)
  integer, save :: masses2_4(2)
  integer, save :: masses2_5(2)
  integer, save :: masses2_6(2)
  integer, save :: masses2_7(2)
  integer, save :: masses2_8(2)
  integer, save :: masses2_9(2)
  integer, save :: masses2_10(2)
  integer, save :: masses2_11(2)
  integer, save :: masses2_12(2)
  integer, save :: masses2_13(2)
  integer, save :: masses2_14(2)
  integer, save :: masses2_15(2)
  integer, save :: masses2_16(2)
  integer, save :: masses2_17(2)
  integer, save :: masses2_18(2)
  integer, save :: masses2_19(2)
  integer, save :: masses2_20(2)
  integer, save :: masses2_21(2)
  integer, save :: masses2_22(2)
  integer, save :: masses2_23(2)
  integer, save :: masses2_24(2)
  integer, save :: masses2_25(2)
  integer, save :: masses2_26(2)
  integer, save :: masses2_27(3)
  integer, save :: masses2_28(3)
  integer, save :: masses2_29(3)
  integer, save :: masses2_30(3)
  integer, save :: masses2_31(3)
  integer, save :: masses2_32(3)
  integer, save :: masses2_33(3)
  integer, save :: masses2_34(3)
  integer, save :: masses2_35(3)
  integer, save :: masses2_36(3)
  integer, save :: masses2_37(3)
  integer, save :: masses2_38(3)
  integer, save :: masses2_39(3)
  integer, save :: masses2_40(3)
  integer, save :: masses2_41(3)
  integer, save :: masses2_42(3)
  integer, save :: masses2_43(3)
  integer, save :: masses2_44(3)
  integer, save :: masses2_45(3)
  integer, save :: masses2_46(3)
  integer, save :: masses2_47(3)
  integer, save :: masses2_48(3)
  integer, save :: masses2_49(3)
  integer, save :: masses2_50(3)
  integer, save :: masses2_51(3)
  integer, save :: masses2_52(3)
  integer, save :: masses2_53(3)
  integer, save :: masses2_54(3)
  integer, save :: masses2_55(3)
  integer, save :: masses2_56(3)
  integer, save :: masses2_57(3)
  integer, save :: masses2_58(4)
  integer, save :: masses2_59(4)
  integer, save :: masses2_60(4)
  integer, save :: masses2_61(4)
  integer, save :: masses2_62(4)
  integer, save :: masses2_63(4)
  integer, save :: masses2_64(4)
  integer, save :: masses2_65(4)
  integer, save :: masses2_66(4)
  integer, save :: masses2_67(4)
  integer, save :: masses2_68(4)
  integer, save :: masses2_69(4)
  integer, save :: masses2_70(4)



  type(hcl), save, dimension(149) :: T0sum


  contains

!**********************************************************************
subroutine HOL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_allocation
  implicit none

    call hol_allocation(4,1,4,1,G0H1,1)
  call hol_allocation(4,5,4,1,G1H1,1)
  call hol_allocation(4,15,4,1,G2H1,1)
  call hol_allocation(4,1,4,2,G0H2,1)
  call hol_allocation(4,5,4,2,G1H2,20)
  call hol_allocation(4,15,4,2,G2H2,17)
  call hol_allocation(4,1,4,3,G0H3,13)
  call hol_allocation(4,5,4,3,G1H3,95)
  call hol_allocation(4,15,4,3,G2H3,67)
  call hol_allocation(4,1,4,4,G0H4,26)
  call hol_allocation(4,5,4,4,G1H4,29)
  call hol_allocation(4,1,4,6,G0H6,15)
  call hol_allocation(4,5,4,6,G1H6,38)
  call hol_allocation(4,15,4,6,G2H6,18)
  call hol_allocation(4,1,4,12,G0H12,39)
  call hol_allocation(4,5,4,12,G1H12,119)
  call hol_allocation(4,1,4,36,G0H36,1)


end subroutine HOL_memory_allocation


!**********************************************************************
subroutine HOL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! allocation of memory for the types hol
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hol
  use hol_initialisation_/**/REALKIND, only: hol_deallocation
  implicit none
  integer,   intent(in)    :: dmode

    call hol_deallocation(G0H1,1,dmode)
  call hol_deallocation(G1H1,1,dmode)
  call hol_deallocation(G2H1,1,dmode)
  call hol_deallocation(G0H2,1,dmode)
  call hol_deallocation(G1H2,20,dmode)
  call hol_deallocation(G2H2,17,dmode)
  call hol_deallocation(G0H3,13,dmode)
  call hol_deallocation(G1H3,95,dmode)
  call hol_deallocation(G2H3,67,dmode)
  call hol_deallocation(G0H4,26,dmode)
  call hol_deallocation(G1H4,29,dmode)
  call hol_deallocation(G0H6,15,dmode)
  call hol_deallocation(G1H6,38,dmode)
  call hol_deallocation(G2H6,18,dmode)
  call hol_deallocation(G0H12,39,dmode)
  call hol_deallocation(G1H12,119,dmode)
  call hol_deallocation(G0H36,1,dmode)


end subroutine HOL_memory_deallocation_/**/REALKIND

!**********************************************************************
subroutine HCL_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

  call hcl_allocation(1,G0tensor, 376)
call hcl_allocation(5,G1tensor, 100)
call hcl_allocation(15,G2tensor, 111)
call hcl_allocation(35,G3tensor, 22)


end subroutine HCL_memory_allocation


!**********************************************************************
subroutine HCL_memory_deallocation_/**/REALKIND(dmode)
!**********************************************************************
! deallocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_deallocation
  implicit none
  integer,   intent(in)    :: dmode

  call hcl_deallocation(G0tensor, 376,dmode)
call hcl_deallocation(G1tensor, 100,dmode)
call hcl_deallocation(G2tensor, 111,dmode)
call hcl_deallocation(G3tensor, 22,dmode)

    call hcl_deallocation(T0sum,149,dmode)


end subroutine HCL_memory_deallocation_/**/REALKIND


!**********************************************************************
subroutine Tsum_memory_allocation()
!**********************************************************************
! allocation of memory for the types hcl
!**********************************************************************
  use KIND_TYPES, only: REALKIND
  use ol_data_types_/**/REALKIND, only: hcl
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  implicit none

    call hcl_allocation(1,T0sum,149)


end subroutine Tsum_memory_allocation


#ifdef PRECISION_dp
subroutine max_point(r) &
    & bind(c,name="ol_f_max_point_ppvv_ew_bbxzz_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 4
end subroutine max_point

subroutine tensor_rank(r) &
    & bind(c,name="ol_f_tensor_rank_ppvv_ew_bbxzz_1")
  ! Return the number maximal tensor rank
  implicit none
  integer, intent(out) :: r
  r = 0
end subroutine tensor_rank
#endif

subroutine reset_tensor_sum()
  use hol_initialisation_/**/REALKIND, only: hcl_allocation
  use ol_parameters_init_/**/REALKIND, only: init_hcl
  implicit none
  integer :: i

  do i = 1,149
    call init_hcl(T0sum(i))
  end do

end subroutine reset_tensor_sum


subroutine scale_one_tsum(tsum, spow)
  use ol_parameters_decl_/**/REALKIND, only: scalefactor
  implicit none
  complex(REALKIND), intent(inout) :: tsum(:)
  integer, intent(in) :: spow ! rank 0 scale power
  real(REALKIND) :: sfinv, sfac
  integer :: sz
  sfinv = 1/scalefactor
  sfac = scalefactor**spow
  sz = size(tsum)
  tsum(1) = sfac*tsum(1)
  if (sz > 1) then ! rank 1
    sfac = sfac*sfinv
    tsum(2:5) = sfac*tsum(2:5)
  end if
  if (sz > 5) then ! rank 2
    sfac = sfac*sfinv
    tsum(6:15) = sfac*tsum(6:15)
  end if
  if (sz > 15) then ! rank 3
    sfac = sfac*sfinv
    tsum(16:35) = sfac*tsum(16:35)
  end if
  if (sz > 35) then ! rank 4
    sfac = sfac*sfinv
    tsum(36:70) = sfac*tsum(36:70)
  end if
  if (sz > 70) then ! rank 5
    sfac = sfac*sfinv
    tsum(71:126) = sfac*tsum(71:126)
  end if
  if (sz > 126) then ! rank 6
    sfac = sfac*sfinv
    tsum(127:210) = sfac*tsum(127:210)
  end if
  if (sz > 210) then ! rank 7
    sfac = sfac*sfinv
    tsum(211:330) = sfac*tsum(211:330)
  end if
end subroutine scale_one_tsum


subroutine scale_tensor_sum()
  implicit none
  call scale_one_tsum(T0sum(1)%cmp, 4)
  call scale_one_tsum(T0sum(2)%cmp, 4)
  call scale_one_tsum(T0sum(3)%cmp, 4)
  call scale_one_tsum(T0sum(4)%cmp, 4)
  call scale_one_tsum(T0sum(5)%cmp, 4)
  call scale_one_tsum(T0sum(6)%cmp, 4)
  call scale_one_tsum(T0sum(7)%cmp, 4)
  call scale_one_tsum(T0sum(8)%cmp, 4)
  call scale_one_tsum(T0sum(9)%cmp, 4)
  call scale_one_tsum(T0sum(10)%cmp, 4)
  call scale_one_tsum(T0sum(11)%cmp, 4)
  call scale_one_tsum(T0sum(12)%cmp, 4)
  call scale_one_tsum(T0sum(13)%cmp, 4)
  call scale_one_tsum(T0sum(14)%cmp, 4)
  call scale_one_tsum(T0sum(15)%cmp, 4)
  call scale_one_tsum(T0sum(16)%cmp, 4)
  call scale_one_tsum(T0sum(17)%cmp, 4)
  call scale_one_tsum(T0sum(18)%cmp, 4)
  call scale_one_tsum(T0sum(19)%cmp, 4)
  call scale_one_tsum(T0sum(20)%cmp, 4)
  call scale_one_tsum(T0sum(21)%cmp, 2)
  call scale_one_tsum(T0sum(22)%cmp, 2)
  call scale_one_tsum(T0sum(23)%cmp, 2)
  call scale_one_tsum(T0sum(24)%cmp, 2)
  call scale_one_tsum(T0sum(25)%cmp, 2)
  call scale_one_tsum(T0sum(26)%cmp, 2)
  call scale_one_tsum(T0sum(27)%cmp, 2)
  call scale_one_tsum(T0sum(28)%cmp, 2)
  call scale_one_tsum(T0sum(29)%cmp, 2)
  call scale_one_tsum(T0sum(30)%cmp, 2)
  call scale_one_tsum(T0sum(31)%cmp, 2)
  call scale_one_tsum(T0sum(32)%cmp, 2)
  call scale_one_tsum(T0sum(33)%cmp, 2)
  call scale_one_tsum(T0sum(34)%cmp, 2)
  call scale_one_tsum(T0sum(35)%cmp, 2)
  call scale_one_tsum(T0sum(36)%cmp, 2)
  call scale_one_tsum(T0sum(37)%cmp, 2)
  call scale_one_tsum(T0sum(38)%cmp, 2)
  call scale_one_tsum(T0sum(39)%cmp, 2)
  call scale_one_tsum(T0sum(40)%cmp, 2)
  call scale_one_tsum(T0sum(41)%cmp, 2)
  call scale_one_tsum(T0sum(42)%cmp, 2)
  call scale_one_tsum(T0sum(43)%cmp, 2)
  call scale_one_tsum(T0sum(44)%cmp, 2)
  call scale_one_tsum(T0sum(45)%cmp, 2)
  call scale_one_tsum(T0sum(46)%cmp, 2)
  call scale_one_tsum(T0sum(47)%cmp, 2)
  call scale_one_tsum(T0sum(48)%cmp, 2)
  call scale_one_tsum(T0sum(49)%cmp, 2)
  call scale_one_tsum(T0sum(50)%cmp, 2)
  call scale_one_tsum(T0sum(51)%cmp, 2)
  call scale_one_tsum(T0sum(52)%cmp, 2)
  call scale_one_tsum(T0sum(53)%cmp, 2)
  call scale_one_tsum(T0sum(54)%cmp, 2)
  call scale_one_tsum(T0sum(55)%cmp, 2)
  call scale_one_tsum(T0sum(56)%cmp, 2)
  call scale_one_tsum(T0sum(57)%cmp, 2)
  call scale_one_tsum(T0sum(58)%cmp, 2)
  call scale_one_tsum(T0sum(59)%cmp, 2)
  call scale_one_tsum(T0sum(60)%cmp, 2)
  call scale_one_tsum(T0sum(61)%cmp, 2)
  call scale_one_tsum(T0sum(62)%cmp, 2)
  call scale_one_tsum(T0sum(63)%cmp, 2)
  call scale_one_tsum(T0sum(64)%cmp, 2)
  call scale_one_tsum(T0sum(65)%cmp, 2)
  call scale_one_tsum(T0sum(66)%cmp, 2)
  call scale_one_tsum(T0sum(67)%cmp, 2)
  call scale_one_tsum(T0sum(68)%cmp, 2)
  call scale_one_tsum(T0sum(69)%cmp, 2)
  call scale_one_tsum(T0sum(70)%cmp, 2)
  call scale_one_tsum(T0sum(71)%cmp, 2)
  call scale_one_tsum(T0sum(72)%cmp, 2)
  call scale_one_tsum(T0sum(73)%cmp, 2)
  call scale_one_tsum(T0sum(74)%cmp, 2)
  call scale_one_tsum(T0sum(75)%cmp, 2)
  call scale_one_tsum(T0sum(76)%cmp, 2)
  call scale_one_tsum(T0sum(77)%cmp, 2)
  call scale_one_tsum(T0sum(78)%cmp, 2)
  call scale_one_tsum(T0sum(79)%cmp, 2)
  call scale_one_tsum(T0sum(80)%cmp, 2)
  call scale_one_tsum(T0sum(81)%cmp, 2)
  call scale_one_tsum(T0sum(82)%cmp, 2)
  call scale_one_tsum(T0sum(83)%cmp, 2)
  call scale_one_tsum(T0sum(84)%cmp, 0)
  call scale_one_tsum(T0sum(85)%cmp, 0)
  call scale_one_tsum(T0sum(86)%cmp, 0)
  call scale_one_tsum(T0sum(87)%cmp, 0)
  call scale_one_tsum(T0sum(88)%cmp, 0)
  call scale_one_tsum(T0sum(89)%cmp, 0)
  call scale_one_tsum(T0sum(90)%cmp, 0)
  call scale_one_tsum(T0sum(91)%cmp, 0)
  call scale_one_tsum(T0sum(92)%cmp, 0)
  call scale_one_tsum(T0sum(93)%cmp, 0)
  call scale_one_tsum(T0sum(94)%cmp, 0)
  call scale_one_tsum(T0sum(95)%cmp, 0)
  call scale_one_tsum(T0sum(96)%cmp, 0)
  call scale_one_tsum(T0sum(97)%cmp, 0)
  call scale_one_tsum(T0sum(98)%cmp, 0)
  call scale_one_tsum(T0sum(99)%cmp, 0)
  call scale_one_tsum(T0sum(100)%cmp, 0)
  call scale_one_tsum(T0sum(101)%cmp, 0)
  call scale_one_tsum(T0sum(102)%cmp, 0)
  call scale_one_tsum(T0sum(103)%cmp, 0)
  call scale_one_tsum(T0sum(104)%cmp, 0)
  call scale_one_tsum(T0sum(105)%cmp, 0)
  call scale_one_tsum(T0sum(106)%cmp, 0)
  call scale_one_tsum(T0sum(107)%cmp, 0)
  call scale_one_tsum(T0sum(108)%cmp, 0)
  call scale_one_tsum(T0sum(109)%cmp, 0)
  call scale_one_tsum(T0sum(110)%cmp, 0)
  call scale_one_tsum(T0sum(111)%cmp, 0)
  call scale_one_tsum(T0sum(112)%cmp, 0)
  call scale_one_tsum(T0sum(113)%cmp, 0)
  call scale_one_tsum(T0sum(114)%cmp, 0)
  call scale_one_tsum(T0sum(115)%cmp, 0)
  call scale_one_tsum(T0sum(116)%cmp, 0)
  call scale_one_tsum(T0sum(117)%cmp, 0)
  call scale_one_tsum(T0sum(118)%cmp, 0)
  call scale_one_tsum(T0sum(119)%cmp, 0)
  call scale_one_tsum(T0sum(120)%cmp, 0)
  call scale_one_tsum(T0sum(121)%cmp, 0)
  call scale_one_tsum(T0sum(122)%cmp, 0)
  call scale_one_tsum(T0sum(123)%cmp, 0)
  call scale_one_tsum(T0sum(124)%cmp, 0)
  call scale_one_tsum(T0sum(125)%cmp, 0)
  call scale_one_tsum(T0sum(126)%cmp, 0)
  call scale_one_tsum(T0sum(127)%cmp, 0)
  call scale_one_tsum(T0sum(128)%cmp, 0)
  call scale_one_tsum(T0sum(129)%cmp, 0)
  call scale_one_tsum(T0sum(130)%cmp, 0)
  call scale_one_tsum(T0sum(131)%cmp, 0)
  call scale_one_tsum(T0sum(132)%cmp, 0)
  call scale_one_tsum(T0sum(133)%cmp, 0)
  call scale_one_tsum(T0sum(134)%cmp, 0)
  call scale_one_tsum(T0sum(135)%cmp, 0)
  call scale_one_tsum(T0sum(136)%cmp, 0)
  call scale_one_tsum(T0sum(137)%cmp, 0)
  call scale_one_tsum(T0sum(138)%cmp, 0)
  call scale_one_tsum(T0sum(139)%cmp, 0)
  call scale_one_tsum(T0sum(140)%cmp, 0)
  call scale_one_tsum(T0sum(141)%cmp, 0)
  call scale_one_tsum(T0sum(142)%cmp, 0)
  call scale_one_tsum(T0sum(143)%cmp, 0)
  call scale_one_tsum(T0sum(144)%cmp, 0)
  call scale_one_tsum(T0sum(145)%cmp, 0)
  call scale_one_tsum(T0sum(146)%cmp, 0)
  call scale_one_tsum(T0sum(147)%cmp, 0)
  call scale_one_tsum(T0sum(148)%cmp, 0)
  call scale_one_tsum(T0sum(149)%cmp, 0)

end subroutine scale_tensor_sum

! **********************************************************************
subroutine set_integral_masses_and_momenta()
! **********************************************************************

  use ol_parameters_decl_/**/REALKIND
  momenta_1 = [ 0, 0 ]
  momenta_2 = [ 8, 7 ]
  momenta_3 = [ 9, 6 ]
  momenta_4 = [ 10, 5 ]
  momenta_5 = [ 11, 4 ]
  momenta_6 = [ 12, 3 ]
  momenta_7 = [ 13, 2 ]
  momenta_8 = [ 14, 1 ]
  momenta_9 = [ 8, 1, 6 ]
  momenta_10 = [ 8, 2, 5 ]
  momenta_11 = [ 8, 3, 4 ]
  momenta_12 = [ 8, 5, 2 ]
  momenta_13 = [ 9, 2, 4 ]
  momenta_14 = [ 9, 4, 2 ]
  momenta_15 = [ 10, 1, 4 ]
  momenta_16 = [ 12, 1, 2 ]
  momenta_17 = [ 12, 2, 1 ]
  momenta_18 = [ 8, 1, 2, 4 ]
  momenta_19 = [ 8, 1, 4, 2 ]
  momenta_20 = [ 8, 2, 1, 4 ]

  masses2_1 = [ 0, 0 ]
  masses2_2 = [ nMB, 0 ]
  masses2_3 = [ nME, 0 ]
  masses2_4 = [ nMH, 0 ]
  masses2_5 = [ nML, 0 ]
  masses2_6 = [ nMM, 0 ]
  masses2_7 = [ nMT, 0 ]
  masses2_8 = [ nMW, 0 ]
  masses2_9 = [ nMZ, 0 ]
  masses2_10 = [ 0, nMB ]
  masses2_11 = [ nMB, nMB ]
  masses2_12 = [ nMH, nMB ]
  masses2_13 = [ nMZ, nMB ]
  masses2_14 = [ nME, nME ]
  masses2_15 = [ nMB, nMH ]
  masses2_16 = [ nMH, nMH ]
  masses2_17 = [ nMZ, nMH ]
  masses2_18 = [ nML, nML ]
  masses2_19 = [ nMM, nMM ]
  masses2_20 = [ nMT, nMT ]
  masses2_21 = [ nMW, nMT ]
  masses2_22 = [ nMT, nMW ]
  masses2_23 = [ nMW, nMW ]
  masses2_24 = [ nMB, nMZ ]
  masses2_25 = [ nMH, nMZ ]
  masses2_26 = [ nMZ, nMZ ]
  masses2_27 = [ 0, 0, 0 ]
  masses2_28 = [ nMB, 0, nMB ]
  masses2_29 = [ nMB, nMB, 0 ]
  masses2_30 = [ nMB, nMB, nMB ]
  masses2_31 = [ nMH, nMB, nMB ]
  masses2_32 = [ nMZ, nMB, nMB ]
  masses2_33 = [ nMB, nMB, nMH ]
  masses2_34 = [ nMZ, nMB, nMH ]
  masses2_35 = [ nMB, nMB, nMZ ]
  masses2_36 = [ nMH, nMB, nMZ ]
  masses2_37 = [ nME, nME, nME ]
  masses2_38 = [ nMB, nMH, nMB ]
  masses2_39 = [ nMH, nMH, nMB ]
  masses2_40 = [ nMZ, nMH, nMB ]
  masses2_41 = [ nMZ, nMH, nMH ]
  masses2_42 = [ nMB, nMH, nMZ ]
  masses2_43 = [ nML, nML, nML ]
  masses2_44 = [ nMM, nMM, nMM ]
  masses2_45 = [ nMT, nMT, nMT ]
  masses2_46 = [ nMW, nMT, nMT ]
  masses2_47 = [ nMT, nMT, nMW ]
  masses2_48 = [ nMW, nMT, nMW ]
  masses2_49 = [ nMT, nMW, nMT ]
  masses2_50 = [ nMW, nMW, nMT ]
  masses2_51 = [ nMT, nMW, nMW ]
  masses2_52 = [ nMW, nMW, nMW ]
  masses2_53 = [ nMB, nMZ, nMB ]
  masses2_54 = [ nMH, nMZ, nMB ]
  masses2_55 = [ nMZ, nMZ, nMB ]
  masses2_56 = [ nMB, nMZ, nMH ]
  masses2_57 = [ nMH, nMZ, nMZ ]
  masses2_58 = [ nMB, nMB, 0, nMB ]
  masses2_59 = [ nMB, nMB, nMH, nMB ]
  masses2_60 = [ nMB, nMB, nMH, nMZ ]
  masses2_61 = [ nMB, nMB, nMZ, nMB ]
  masses2_62 = [ nMB, nMB, nMZ, nMH ]
  masses2_63 = [ nMZ, nMH, nMB, nMB ]
  masses2_64 = [ nMZ, nMH, nMB, nMH ]
  masses2_65 = [ nMT, nMT, nMW, nMT ]
  masses2_66 = [ nMT, nMT, nMW, nMW ]
  masses2_67 = [ nMW, nMW, nMT, nMT ]
  masses2_68 = [ nMW, nMW, nMT, nMW ]
  masses2_69 = [ nMH, nMZ, nMB, nMB ]
  masses2_70 = [ nMH, nMZ, nMB, nMZ ]


end subroutine  set_integral_masses_and_momenta

! **********************************************************************
subroutine integrate_tensor_sum(M2out)
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! only: ZERO, masses
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: a_switch
#endif
  use ol_parameters_init_/**/REALKIND, only: init_met, add_met, met_to_real
  use ol_loop_routines_/**/REALKIND, only: TI_call_OL
  implicit none
  real(REALKIND), intent(out) :: M2out
  type(met) :: M2
  call init_met(M2)



#ifdef LOOPSQUARED
  if (a_switch == 1 .or. a_switch == 7) then
#endif
  call TI_call_OL(0,0, momenta_20, masses2_64, T0sum(1), M2)
  call TI_call_OL(0,0, momenta_20, masses2_68, T0sum(2), M2)
  call TI_call_OL(0,0, momenta_20, masses2_70, T0sum(3), M2)
  call TI_call_OL(0,0, momenta_18, masses2_64, T0sum(4), M2)
  call TI_call_OL(0,0, momenta_18, masses2_68, T0sum(5), M2)
  call TI_call_OL(0,0, momenta_18, masses2_70, T0sum(6), M2)
  call TI_call_OL(0,0, momenta_19, masses2_63, T0sum(7), M2)
  call TI_call_OL(0,0, momenta_19, masses2_60, T0sum(8), M2)
  call TI_call_OL(0,0, momenta_19, masses2_69, T0sum(9), M2)
  call TI_call_OL(0,0, momenta_19, masses2_67, T0sum(10), M2)
  call TI_call_OL(0,0, momenta_20, masses2_59, T0sum(11), M2)
  call TI_call_OL(0,0, momenta_20, masses2_61, T0sum(12), M2)
  call TI_call_OL(0,0, momenta_20, masses2_65, T0sum(13), M2)
  call TI_call_OL(0,0, momenta_20, masses2_58, T0sum(14), M2)
  call TI_call_OL(0,0, momenta_18, masses2_59, T0sum(15), M2)
  call TI_call_OL(0,0, momenta_18, masses2_61, T0sum(16), M2)
  call TI_call_OL(0,0, momenta_18, masses2_65, T0sum(17), M2)
  call TI_call_OL(0,0, momenta_18, masses2_58, T0sum(18), M2)
  call TI_call_OL(0,0, momenta_19, masses2_62, T0sum(19), M2)
  call TI_call_OL(0,0, momenta_19, masses2_66, T0sum(20), M2)
  call TI_call_OL(0,0, momenta_9, masses2_40, T0sum(21), M2)
  call TI_call_OL(0,0, momenta_9, masses2_54, T0sum(22), M2)
  call TI_call_OL(0,0, momenta_9, masses2_50, T0sum(23), M2)
  call TI_call_OL(0,0, momenta_17, masses2_33, T0sum(24), M2)
  call TI_call_OL(0,0, momenta_10, masses2_33, T0sum(25), M2)
  call TI_call_OL(0,0, momenta_17, masses2_35, T0sum(26), M2)
  call TI_call_OL(0,0, momenta_10, masses2_35, T0sum(27), M2)
  call TI_call_OL(0,0, momenta_17, masses2_47, T0sum(28), M2)
  call TI_call_OL(0,0, momenta_10, masses2_47, T0sum(29), M2)
  call TI_call_OL(0,0, momenta_17, masses2_39, T0sum(30), M2)
  call TI_call_OL(0,0, momenta_10, masses2_40, T0sum(31), M2)
  call TI_call_OL(0,0, momenta_17, masses2_55, T0sum(32), M2)
  call TI_call_OL(0,0, momenta_10, masses2_54, T0sum(33), M2)
  call TI_call_OL(0,0, momenta_17, masses2_50, T0sum(34), M2)
  call TI_call_OL(0,0, momenta_10, masses2_50, T0sum(35), M2)
  call TI_call_OL(0,0, momenta_17, masses2_29, T0sum(36), M2)
  call TI_call_OL(0,0, momenta_10, masses2_29, T0sum(37), M2)
  call TI_call_OL(0,0, momenta_16, masses2_33, T0sum(38), M2)
  call TI_call_OL(0,0, momenta_9, masses2_33, T0sum(39), M2)
  call TI_call_OL(0,0, momenta_16, masses2_35, T0sum(40), M2)
  call TI_call_OL(0,0, momenta_9, masses2_35, T0sum(41), M2)
  call TI_call_OL(0,0, momenta_16, masses2_47, T0sum(42), M2)
  call TI_call_OL(0,0, momenta_9, masses2_47, T0sum(43), M2)
  call TI_call_OL(0,0, momenta_16, masses2_39, T0sum(44), M2)
  call TI_call_OL(0,0, momenta_16, masses2_55, T0sum(45), M2)
  call TI_call_OL(0,0, momenta_16, masses2_50, T0sum(46), M2)
  call TI_call_OL(0,0, momenta_16, masses2_29, T0sum(47), M2)
  call TI_call_OL(0,0, momenta_9, masses2_29, T0sum(48), M2)
  call TI_call_OL(0,0, momenta_15, masses2_34, T0sum(49), M2)
  call TI_call_OL(0,0, momenta_15, masses2_36, T0sum(50), M2)
  call TI_call_OL(0,0, momenta_15, masses2_48, T0sum(51), M2)
  call TI_call_OL(0,0, momenta_11, masses2_41, T0sum(52), M2)
  call TI_call_OL(0,0, momenta_11, masses2_52, T0sum(53), M2)
  call TI_call_OL(0,0, momenta_11, masses2_57, T0sum(54), M2)
  call TI_call_OL(0,0, momenta_13, masses2_34, T0sum(55), M2)
  call TI_call_OL(0,0, momenta_13, masses2_48, T0sum(56), M2)
  call TI_call_OL(0,0, momenta_13, masses2_36, T0sum(57), M2)
  call TI_call_OL(0,0, momenta_15, masses2_38, T0sum(58), M2)
  call TI_call_OL(0,0, momenta_14, masses2_32, T0sum(59), M2)
  call TI_call_OL(0,0, momenta_12, masses2_40, T0sum(60), M2)
  call TI_call_OL(0,0, momenta_14, masses2_42, T0sum(61), M2)
  call TI_call_OL(0,0, momenta_12, masses2_35, T0sum(62), M2)
  call TI_call_OL(0,0, momenta_15, masses2_53, T0sum(63), M2)
  call TI_call_OL(0,0, momenta_14, masses2_31, T0sum(64), M2)
  call TI_call_OL(0,0, momenta_12, masses2_54, T0sum(65), M2)
  call TI_call_OL(0,0, momenta_15, masses2_49, T0sum(66), M2)
  call TI_call_OL(0,0, momenta_14, masses2_46, T0sum(67), M2)
  call TI_call_OL(0,0, momenta_12, masses2_50, T0sum(68), M2)
  call TI_call_OL(0,0, momenta_11, masses2_30, T0sum(69), M2)
  call TI_call_OL(0,0, momenta_11, masses2_45, T0sum(70), M2)
  call TI_call_OL(0,0, momenta_15, masses2_28, T0sum(71), M2)
  call TI_call_OL(0,0, momenta_13, masses2_38, T0sum(72), M2)
  call TI_call_OL(0,0, momenta_13, masses2_53, T0sum(73), M2)
  call TI_call_OL(0,0, momenta_13, masses2_49, T0sum(74), M2)
  call TI_call_OL(0,0, momenta_13, masses2_28, T0sum(75), M2)
  call TI_call_OL(0,0, momenta_14, masses2_56, T0sum(76), M2)
  call TI_call_OL(0,0, momenta_12, masses2_33, T0sum(77), M2)
  call TI_call_OL(0,0, momenta_14, masses2_51, T0sum(78), M2)
  call TI_call_OL(0,0, momenta_12, masses2_47, T0sum(79), M2)
  call TI_call_OL(0,0, momenta_11, masses2_37, T0sum(80), M2)
  call TI_call_OL(0,0, momenta_11, masses2_44, T0sum(81), M2)
  call TI_call_OL(0,0, momenta_11, masses2_43, T0sum(82), M2)
  call TI_call_OL(0,0, momenta_11, masses2_27, T0sum(83), M2)
  call TI_call_OL(0,0, momenta_8, masses2_15, T0sum(84), M2)
  call TI_call_OL(0,0, momenta_3, masses2_13, T0sum(85), M2)
  call TI_call_OL(0,0, momenta_2, masses2_17, T0sum(86), M2)
  call TI_call_OL(0,0, momenta_1, masses2_9, T0sum(87), M2)
  call TI_call_OL(0,0, momenta_1, masses2_4, T0sum(88), M2)
  call TI_call_OL(0,0, momenta_1, masses2_2, T0sum(89), M2)
  call TI_call_OL(0,0, momenta_8, masses2_24, T0sum(90), M2)
  call TI_call_OL(0,0, momenta_3, masses2_12, T0sum(91), M2)
  call TI_call_OL(0,0, momenta_2, masses2_25, T0sum(92), M2)
  call TI_call_OL(0,0, momenta_8, masses2_22, T0sum(93), M2)
  call TI_call_OL(0,0, momenta_3, masses2_21, T0sum(94), M2)
  call TI_call_OL(0,0, momenta_2, masses2_23, T0sum(95), M2)
  call TI_call_OL(0,0, momenta_1, masses2_8, T0sum(96), M2)
  call TI_call_OL(0,0, momenta_1, masses2_7, T0sum(97), M2)
  call TI_call_OL(0,0, momenta_7, masses2_12, T0sum(98), M2)
  call TI_call_OL(0,0, momenta_6, masses2_11, T0sum(99), M2)
  call TI_call_OL(0,0, momenta_4, masses2_15, T0sum(100), M2)
  call TI_call_OL(0,0, momenta_2, masses2_11, T0sum(101), M2)
  call TI_call_OL(0,0, momenta_7, masses2_13, T0sum(102), M2)
  call TI_call_OL(0,0, momenta_4, masses2_24, T0sum(103), M2)
  call TI_call_OL(0,0, momenta_7, masses2_21, T0sum(104), M2)
  call TI_call_OL(0,0, momenta_6, masses2_20, T0sum(105), M2)
  call TI_call_OL(0,0, momenta_4, masses2_22, T0sum(106), M2)
  call TI_call_OL(0,0, momenta_2, masses2_20, T0sum(107), M2)
  call TI_call_OL(0,0, momenta_7, masses2_15, T0sum(108), M2)
  call TI_call_OL(0,0, momenta_8, masses2_12, T0sum(109), M2)
  call TI_call_OL(0,0, momenta_6, masses2_16, T0sum(110), M2)
  call TI_call_OL(0,0, momenta_4, masses2_13, T0sum(111), M2)
  call TI_call_OL(0,0, momenta_7, masses2_24, T0sum(112), M2)
  call TI_call_OL(0,0, momenta_8, masses2_13, T0sum(113), M2)
  call TI_call_OL(0,0, momenta_6, masses2_26, T0sum(114), M2)
  call TI_call_OL(0,0, momenta_4, masses2_12, T0sum(115), M2)
  call TI_call_OL(0,0, momenta_7, masses2_22, T0sum(116), M2)
  call TI_call_OL(0,0, momenta_8, masses2_21, T0sum(117), M2)
  call TI_call_OL(0,0, momenta_6, masses2_23, T0sum(118), M2)
  call TI_call_OL(0,0, momenta_4, masses2_21, T0sum(119), M2)
  call TI_call_OL(0,0, momenta_7, masses2_10, T0sum(120), M2)
  call TI_call_OL(0,0, momenta_8, masses2_2, T0sum(121), M2)
  call TI_call_OL(0,0, momenta_4, masses2_2, T0sum(122), M2)
  call TI_call_OL(0,0, momenta_3, masses2_15, T0sum(123), M2)
  call TI_call_OL(0,0, momenta_3, masses2_24, T0sum(124), M2)
  call TI_call_OL(0,0, momenta_3, masses2_22, T0sum(125), M2)
  call TI_call_OL(0,0, momenta_8, masses2_10, T0sum(126), M2)
  call TI_call_OL(0,0, momenta_7, masses2_2, T0sum(127), M2)
  call TI_call_OL(0,0, momenta_3, masses2_2, T0sum(128), M2)
  call TI_call_OL(0,0, momenta_5, masses2_17, T0sum(129), M2)
  call TI_call_OL(0,0, momenta_5, masses2_25, T0sum(130), M2)
  call TI_call_OL(0,0, momenta_5, masses2_23, T0sum(131), M2)
  call TI_call_OL(0,0, momenta_5, masses2_11, T0sum(132), M2)
  call TI_call_OL(0,0, momenta_5, masses2_20, T0sum(133), M2)
  call TI_call_OL(0,0, momenta_6, masses2_14, T0sum(134), M2)
  call TI_call_OL(0,0, momenta_1, masses2_3, T0sum(135), M2)
  call TI_call_OL(0,0, momenta_5, masses2_14, T0sum(136), M2)
  call TI_call_OL(0,0, momenta_2, masses2_14, T0sum(137), M2)
  call TI_call_OL(0,0, momenta_6, masses2_19, T0sum(138), M2)
  call TI_call_OL(0,0, momenta_1, masses2_6, T0sum(139), M2)
  call TI_call_OL(0,0, momenta_5, masses2_19, T0sum(140), M2)
  call TI_call_OL(0,0, momenta_2, masses2_19, T0sum(141), M2)
  call TI_call_OL(0,0, momenta_6, masses2_18, T0sum(142), M2)
  call TI_call_OL(0,0, momenta_1, masses2_5, T0sum(143), M2)
  call TI_call_OL(0,0, momenta_5, masses2_18, T0sum(144), M2)
  call TI_call_OL(0,0, momenta_2, masses2_18, T0sum(145), M2)
  call TI_call_OL(0,0, momenta_6, masses2_1, T0sum(146), M2)
  call TI_call_OL(0,0, momenta_5, masses2_1, T0sum(147), M2)
  call TI_call_OL(0,0, momenta_2, masses2_1, T0sum(148), M2)
  call TI_call_OL(0,0, momenta_4, masses2_10, T0sum(149), M2)

  call add_met(M2,M2L1R1)

#ifdef LOOPSQUARED
  end if
#endif

  call met_to_real(M2out,M2)

#ifdef PRECISION_dp
  call HOL_memory_deallocation_/**/REALKIND(1)
  call HCL_memory_deallocation_/**/REALKIND(1)
#endif

end subroutine integrate_tensor_sum

end module ol_tensor_sum_storage_ppvv_ew_bbxzz_1_/**/REALKIND
