
module ol_colourmatrix_ppvv2_zzgg_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(0,0), K2(0,2), KL(0,2), KL2(24,2), KL2ct(24,2), KL2ct2(24,2)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  KL2( 1,:) = [  0,  2]
  KL2( 2,:) = [  2,  0]
  KL2( 3,:) = [  0,  0]
  KL2( 4,:) = [  0,  0]
  KL2( 5,:) = [  0,  0]
  KL2( 6,:) = [  0,  0]
  KL2( 7,:) = [  0,  0]
  KL2( 8,:) = [  0,  0]
  KL2( 9,:) = [  0,  0]
  KL2(10,:) = [  0,  0]
  KL2(11,:) = [  0,  0]
  KL2(12,:) = [  0,  0]
  KL2(13,:) = [  0,  6]
  KL2(14,:) = [  6,  0]
  KL2(15,:) = [  0,  0]
  KL2(16,:) = [  0,  0]
  KL2(17,:) = [  0,  0]
  KL2(18,:) = [  0,  0]
  KL2(19,:) = [  0, -6]
  KL2(20,:) = [ -6,  0]
  KL2(21,:) = [  0,  6]
  KL2(22,:) = [  6,  0]
  KL2(23,:) = [  0,  0]
  KL2(24,:) = [  0,  0]

  KL2ct( 1,:) = [  2,  0]
  KL2ct( 2,:) = [  0,  2]
  KL2ct( 3,:) = [  0,  0]
  KL2ct( 4,:) = [  0,  0]
  KL2ct( 5,:) = [  0,  0]
  KL2ct( 6,:) = [  0,  0]
  KL2ct( 7,:) = [  0,  0]
  KL2ct( 8,:) = [  0,  0]
  KL2ct( 9,:) = [  0,  0]
  KL2ct(10,:) = [  0,  0]
  KL2ct(11,:) = [  0,  0]
  KL2ct(12,:) = [  0,  0]
  KL2ct(13,:) = [  6,  0]
  KL2ct(14,:) = [  0,  6]
  KL2ct(15,:) = [  0,  0]
  KL2ct(16,:) = [  0,  0]
  KL2ct(17,:) = [  0,  0]
  KL2ct(18,:) = [  0,  0]
  KL2ct(19,:) = [ -6,  0]
  KL2ct(20,:) = [  0, -6]
  KL2ct(21,:) = [  6,  0]
  KL2ct(22,:) = [  0,  6]
  KL2ct(23,:) = [  0,  0]
  KL2ct(24,:) = [  0,  0]

  KL2ct2( 1,:) = [  0,  2]
  KL2ct2( 2,:) = [  2,  0]
  KL2ct2( 3,:) = [  0,  0]
  KL2ct2( 4,:) = [  0,  0]
  KL2ct2( 5,:) = [  0,  0]
  KL2ct2( 6,:) = [  0,  0]
  KL2ct2( 7,:) = [  0,  0]
  KL2ct2( 8,:) = [  0,  0]
  KL2ct2( 9,:) = [  0,  0]
  KL2ct2(10,:) = [  0,  0]
  KL2ct2(11,:) = [  0,  0]
  KL2ct2(12,:) = [  0,  0]
  KL2ct2(13,:) = [  0,  6]
  KL2ct2(14,:) = [  6,  0]
  KL2ct2(15,:) = [  0,  0]
  KL2ct2(16,:) = [  0,  0]
  KL2ct2(17,:) = [  0,  0]
  KL2ct2(18,:) = [  0,  0]
  KL2ct2(19,:) = [  0, -6]
  KL2ct2(20,:) = [ -6,  0]
  KL2ct2(21,:) = [  0,  6]
  KL2ct2(22,:) = [  6,  0]
  KL2ct2(23,:) = [  0,  0]
  KL2ct2(24,:) = [  0,  0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvv2_zzgg_3_/**/REALKIND



module ol_forced_parameters_ppvv2_zzgg_3_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (YU /= 0) write(*,101) 'YU = 0'
  if (YD /= 0) write(*,101) 'YD = 0'
  if (YS /= 0) write(*,101) 'YS = 0'
  if (YC /= 0) write(*,101) 'YC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvv2_zzgg_3_/**/REALKIND

module ol_loop_ppvv2_zzgg_3_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(7), c(0)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-4+1:3)
  ! denominators
  complex(REALKIND), save :: den(1)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(0,36), Mct(2,36), Mcol_loop(2,36)
  ! zero helicity identifier
  logical,           save :: zerohel(36) = .true., zerohel_ct(36) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f(1) = CI*countertermnorm*ctZZGG*eQED**2*gQCD**2
    f(2) = eQED**2*gQCD**2*integralnorm*SwF
    f(3) = 2*eQED**2*gQCD**2*integralnorm*SwF
    f(4) = (CI*countertermnorm*ctHGGsel*eQED**2*gQCD**2*lambdaHZZ*MB*MW*YB)/(cw**2*sw)
    f(5) = (eQED**2*gQCD**2*integralnorm*lambdaHZZ*SwF*YB)/(cw**2*sw**2*2._/**/REALKIND)
    f(6) = (CI*countertermnorm*ctHGGsel*eQED**2*gQCD**2*lambdaHZZ*MT*MW*YT)/(cw**2*sw)
    f(7) = (eQED**2*gQCD**2*integralnorm*lambdaHZZ*SwF*YT)/(cw**2*sw**2*2._/**/REALKIND)


end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,4)
  integer,           intent(in)  :: H(4)
  integer,           intent(in), optional  :: POLSEL(4)
  complex(REALKIND), intent(out) :: M1(0), M2(2)
  complex(REALKIND) :: A(3)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_V(P(:,1), rMZ, H(1), wf(:,0), POLSEL(1))
    call pol_wf_V(P(:,2), rMZ, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), POLSEL(4))

  else
    call pol_wf_V(P(:,1), rMZ, H(1), wf(:,0), 0)
    call pol_wf_V(P(:,2), rMZ, H(2), wf(:,-1), 0)
    call pol_wf_V(P(:,3), rZERO, H(3), wf(:,-2), 0)
    call pol_wf_V(P(:,4), rZERO, H(4), wf(:,-3), 0)

  end if

  ! internal WFs
  call counter_VVG_G(wf(:,0),wf(:,-1),wf(:,-2),wf(:,1))
  call vert_VV_S(wf(:,0),wf(:,-1),wf(:,2))
  call counter_GG_S(wf(:,-2),wf(:,-3),wf(:,3))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3) - MH2)

  ! denominators

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(3)


  A(1) = cont_VV(wf(:,-3),wf(:,1))
  A(2) = cont_SS(wf(:,2),wf(:,3)) * den(1)
  A(3) = cont_SS(wf(:,2),wf(:,3)) * den(1)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(3)
  complex(REALKIND), intent(out) :: M1(0), M2(2)


  M2(1) = 2*A(1)*f(1)
  M2(2) = -2*A(3)*f(4)-2*A(2)*f(6)

end subroutine colourvectors

end module ol_loop_ppvv2_zzgg_3_/**/REALKIND
