
module ol_vamp_1_ppvj_ew_bbxz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvj_ew_bbxz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvj_ew_bbxz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvj_ew_bbxz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvj_ew_bbxz_1_/**/REALKIND
! no reduction 

  use ol_loop_storage_ppvj_ew_bbxz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvj_ew_bbxz_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(1),h0tab(:,1),[4,1,2],[nMB,nMH,nMB],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,1),heltab2x12(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMB,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(2),h0tab(:,2),[4,1,2],[nMB,nMZ,nMB],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,2),heltab2x12(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMB,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(8)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(3),h0tab(:,3),[4,1,2],[nMT,nMW,nMT],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZu,m3h3x4(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMT,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(4),h0tab(:,4),[4,1,2],[nMH,nMB,nMZ],3,0)
  call Hloop_SV_T(ntryL,G0H12(1),0,ex3(:),4,G1H4(4),m3h3x4(:,4),heltab2x12(:,:,4))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(5),h0tab(:,5),[4,1,2],[nMZ,nMB,nMH],3,0)
  call Hloop_TV_S(ntryL,G0H12(1),0,ex3(:),4,G1H4(5),m3h3x4(:,5),heltab2x12(:,:,5))
  Gcoeff(:)%j = (c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(6),h0tab(:,6),[4,1,2],[nMW,nMT,nMW],3,0)
  call Hloop_SV_T(ntryL,G0H12(1),0,ex3(:),4,G1H4(6),m3h3x4(:,6),heltab2x12(:,:,6))
  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(7),h0tab(:,7),[4,1,2],[nMB,0,nMB],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,7),heltab2x12(:,:,7))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMB,G1H4(7),n2h4(4))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(8),h0tab(:,8),[4,1,2],[nMB,nMZ,nMB],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,8),heltab2x12(:,:,8))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMB,G1H4(8),n2h4(5))
  Gcoeff(:)%j = (-(c(6)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(9),h0tab(:,9),[4,1,2],[nMT,nMW,nMT],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZu,m3h3x4(:,9),heltab2x12(:,:,9))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMT,G1H4(9),n2h4(6))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(10),h0tab(:,10),[4,1,2],[nMB,0,nMB],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,10),heltab2x12(:,:,10))
  call Hloop_A_Q(ntryL,G0H4(1),4,nMB,G1H4(10),n2h4(7))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(11),h0tab(:,11),[4,1,2],[nMH,nMB,nMZ],3,0)
  call Hloop_VV_S(ntryL,G0H12(1),ex3(:),G0H4(1),m3h3x4(:,11),heltab2x12(:,:,11))
  Gcoeff(:)%j = (c(10)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(12),h0tab(:,12),[4,1,2],[nMW,nMT,nMW],3,0)
  call Hloop_VV_S(ntryL,G0H12(1),ex3(:),G0H4(2),m3h3x4(:,12),heltab2x12(:,:,12))
  Gcoeff(:)%j = (c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(13),h0tab(:,13),[4,1,2],[nMZ,nMB,nMH],3,0)
  call Hloop_SV_V(ntryL,G0H12(1),ex3(:),G0H4(3),m3h3x4(:,13),heltab2x12(:,:,13))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(14),h0tab(:,14),[4,1,2],[nMW,nMT,nMW],3,0)
  call Hloop_SV_V(ntryL,G0H12(1),ex3(:),G0H4(4),m3h3x4(:,14),heltab2x12(:,:,14))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(15),h0tab(:,15),[4,1,2],[nMW,nMT,nMW],3,0)
  call Hloop_UW_V(ntryL,G0H12(1),0,ex3(:),4,G1H4(11),m3h3x4(:,15),heltab2x12(:,:,15))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(7)])
  call Hloop_AQ_S(ntryL,G1H4(1),ex1(:),G1H2(1),ngH,m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_S(ntryL,G1H4(2),ex1(:),G1H2(2),ngX,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_S(ntryL,G1H4(3),ex1(:),G1H2(3),ngPtb,m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_SQ_A(ntryL,G1H4(4),ex1(:),G1H2(4),ngH,m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(4),5,nMB,G2H2(1),n2h2(1))
  call Hloop_SQ_A(ntryL,G1H4(5),ex1(:),G1H2(4),ngX,m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(4),5,nMB,G2H2(2),n2h2(2))
  call Hloop_SQ_A(ntryL,G1H4(6),ex1(:),G1H2(4),ngPtb,m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(4),5,nMT,G2H2(3),n2h2(3))
  call Hloop_AQ_V(ntryL,G1H4(10),ex1(:),G1H2(4),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_AQ_Z(ntryL,G1H4(8),ex1(:),G1H2(5),ngZd,m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_AQ_W(ntryL,G1H4(9),ex1(:),G1H2(6),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_SQ_A(ntryL,G0H4(1),ex1(:),G0H2(1),ngH,m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_Q_A(ntryL,G0H2(1),5,nMB,G1H2(7),n2h2(4))
  call Hloop_SQ_A(ntryL,G0H4(2),ex1(:),G0H2(1),ngPtb,m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_Q_A(ntryL,G0H2(1),5,nMT,G1H2(8),n2h2(5))
  call Hloop_ZQ_A(ntryL,G0H4(3),ex1(:),G0H2(1),ngZd,m3h2x2(:,12),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G0H2(1),5,nMB,G1H2(9),n2h2(6))
  call Hloop_WQ_A(ntryL,G0H4(4),ex1(:),G0H2(1),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_Q_A(ntryL,G0H2(1),5,nMT,G1H2(10),n2h2(7))
  call Hloop_WQ_A(ntryL,G1H4(11),ex1(:),G1H2(11),m3h2x2(:,14),heltab2x4(:,:,14))
  call Hloop_Q_A(ntryL,G1H2(11),5,nMT,G2H2(4),n2h2(8))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(3),[G1H2(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(4),[G1H2(8)])
  call Hloop_SA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),ngH,m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMB,G2tensor(1),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngX,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMB,G2tensor(2),n2h1(2))
  call Hloop_SA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),ngPbt,m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMT,G2tensor(3),n2h1(3))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(4),ngX,m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(5),ngH,m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_QA_S(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(6),ngPbt,m3h2x1(:,6),heltab2x2(:,:,6))
  call Hloop_VA_Q(ntryL,G1H2(4),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMB,G2tensor(7),n2h1(4))
  call Hloop_ZA_Q(ntryL,G1H2(5),ex2(:),G1H1(1),ngZd,m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMB,G2tensor(8),n2h1(5))
  call Hloop_WA_Q(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,nMT,G2tensor(9),n2h1(6))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H2(7),ex2(:),G1tensor(1),ngZd,m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(10),m3h2x1(:,11),heltab2x2(:,:,11))
  call ol_merge_tensors(G2tensor(8),[G2tensor(2)])
  call ol_merge_tensors(G2tensor(9),[G2tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(1)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(6)])
  call ol_merge_tensors(T2sum(1),[G2tensor(1)])
  call ol_merge_tensors(T2sum(2),[G2tensor(8)])
  call ol_merge_tensors(T2sum(3),[G2tensor(9)])
  call ol_merge_tensors(T2sum(4),[G2tensor(4)])
  call ol_merge_tensors(T2sum(5),[G2tensor(5)])
  call ol_merge_tensors(T2sum(6),[G2tensor(10)])
  call ol_merge_tensors(T2sum(7),[G2tensor(7)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvj_ew_bbxz_1_/**/REALKIND
