
module ol_vamp_1_ppvj_ew_uxdwxg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvj_ew_uxdwxg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvj_ew_uxdwxg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvj_ew_uxdwxg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvj_ew_uxdwxg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvj_ew_uxdwxg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvj_ew_uxdwxg_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(24)
  type(Hpolcont), intent(in) :: M(2,24)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(1),n2h12(1))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[8,2,1,4],[0,nMZ,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(2),n2h12(2))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[8,2,1,4],[0,0,0,0],4,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(3),n2h12(3))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(4),n2h12(4))
  Gcoeff(:)%j = (c(8)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[8,1,2,4],[0,nMZ,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(5),n2h12(5))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[8,1,2,4],[0,0,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(6),n2h12(6))
  Gcoeff(:)%j = (c(9)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[8,1,4,2],[0,0,0,0],4,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(7),m3h2x12(:,7),heltab2x24(:,:,7))
  Gcoeff(:)%j = (c(7)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[8,1,4,2],[0,0,nMW,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(8),n2h12(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[8,1,4,2],[0,nMW,0,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(9),n2h12(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[8,1,4,2],[0,nMZ,nMW,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(10),n2h12(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[8,1,4,2],[0,nMW,nMZ,0],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(11),n2h12(10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(3),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(6),[G1H12(4)])
  call Hloop_AQ_V(ntryL,G1H12(3),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H12(2),ex2(:),G1H6(2),ngZd,m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_QA_V(ntryL,G1H12(6),ex1(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_QA_Z(ntryL,G1H12(5),ex1(:),G1H6(4),ngZu,m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_VA_Q(ntryL,G1H12(7),ex1(:),G1H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H6(5),9,0,G2H6(1),n2h6(1))
  call Hloop_QA_V(ntryL,G1H12(8),ex1(:),G1H6(5),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_QA_W(ntryL,G1H12(9),ex1(:),G1H6(6),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_QA_Z(ntryL,G1H12(10),ex1(:),G1H6(7),ngZu,m3h2x6(:,8),heltab2x12(:,:,8))
  call Hloop_QA_W(ntryL,G1H12(11),ex1(:),G1H6(8),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_VA_Q(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_A_Q(ntryL,G1H3(1),11,0,G2H3(1),n2h3(1))
  call Hloop_ZA_Q(ntryL,G1H6(2),ex1(:),G1H3(1),ngZu,m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_A_Q(ntryL,G1H3(1),11,0,G2H3(2),n2h3(2))
  call Hloop_VQ_A(ntryL,G1H6(3),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H3(1),11,0,G2H3(3),n2h3(3))
  call Hloop_ZQ_A(ntryL,G1H6(4),ex2(:),G1H3(1),ngZd,m3h2x3(:,4),heltab2x6(:,:,4))
  call Hloop_Q_A(ntryL,G1H3(1),11,0,G2H3(4),n2h3(4))
  call Hotf_4pt_reduction(G2H6(1),RedSet_4(1),mass4set(:,1),  & 
G1H6(1),G1H6(2),G1H6(3),G1H6(4),G1H6(9),6)
  call HG1shiftOLR(G1H6(2),2,6)
  call Hloop_UV_W(ntryL,G1H6(5),9,ex3(:),4,G2H2(1),m3h3x2(:,1),heltab2x6(:,:,5))
  call Hloop_UW_V(ntryL,G1H6(6),9,ex3(:),4,G2H2(2),m3h3x2(:,2),heltab2x6(:,:,6))
  call Hloop_UV_W(ntryL,G1H6(7),9,ex3(:),4,G2H2(3),m3h3x2(:,3),heltab2x6(:,:,7))
  call Hloop_UW_V(ntryL,G1H6(8),9,ex3(:),4,G2H2(4),m3h3x2(:,4),heltab2x6(:,:,8))
  call Hloop_AW_Q(ntryL,G1H6(1),ex3(:),G1H2(1),m3h3x2(:,5),heltab2x6(:,:,9))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(5),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(2),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(2),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(2),ex2(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,10))
  call Hloop_AW_Q(ntryL,G1H6(4),ex3(:),G1H2(1),m3h3x2(:,6),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(6),n2h2(2))
  call Hloop_AW_Q(ntryL,G1H6(9),ex3(:),G1H2(1),m3h3x2(:,7),heltab2x6(:,:,12))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(7),n2h2(3))
  call Hotf_4pt_reduction(G2H3(1),RedSet_4(2),mass4set(:,1),  & 
G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
  call HG1shiftOLR(G1H3(3),4,3)
  call Hotf_4pt_reduction(G2H3(2),RedSet_4(2),mass4set(:,2),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
  call HG1shiftOLR(G1H3(8),4,3)
  call Hotf_4pt_reduction(G2H3(3),RedSet_4(3),mass4set(:,1),  & 
G1H3(12),G1H3(13),G1H3(14),G1H3(15),G1H3(16),3)
  call HG1shiftOLR(G1H3(13),4,3)
  call Hotf_4pt_reduction(G2H3(4),RedSet_4(3),mass4set(:,2),  & 
G1H3(17),G1H3(18),G1H3(19),G1H3(20),G1H3(21),3)
  call HG1shiftOLR(G1H3(18),4,3)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(1),mass4set(:,3),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),2)
  call HG1shiftOLR(G1H2(2),2,2)
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(1),mass4set(:,4),  & 
G1H2(6),G1H2(7),G1H2(8),G1H2(9),G1H2(10),2)
  call HG1shiftOLR(G1H2(7),2,2)
  call Hotf_4pt_reduction(G2H2(3),RedSet_4(1),mass4set(:,5),  & 
G1H2(11),G1H2(12),G1H2(13),G1H2(14),G1H2(15),2)
  call HG1shiftOLR(G1H2(12),2,2)
  call Hotf_4pt_reduction(G2H2(4),RedSet_4(1),mass4set(:,6),  & 
G1H2(16),G1H2(17),G1H2(18),G1H2(19),G1H2(20),2)
  call HG1shiftOLR(G1H2(17),2,2)
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(5),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(7),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_AW_Q(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(3),n2h1(1))
  call Hloop_AW_Q(ntryL,G1H3(3),ex3(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(4),n2h1(2))
  call Hloop_AW_Q(ntryL,G1H3(6),ex3(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(5),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H3(7),ex3(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(4))
  call Hloop_AW_Q(ntryL,G1H3(8),ex3(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,0,G2tensor(7),n2h1(5))
  call Hloop_AW_Q(ntryL,G1H3(11),ex3(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(8),n2h1(6))
  call Hloop_QW_A(ntryL,G1H3(12),ex3(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(7))
  call Hloop_QW_A(ntryL,G1H3(13),ex3(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(10),n2h1(8))
  call Hloop_QW_A(ntryL,G1H3(16),ex3(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(11),n2h1(9))
  call Hloop_QW_A(ntryL,G1H3(17),ex3(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(10))
  call Hloop_QW_A(ntryL,G1H3(18),ex3(:),G1H1(1),m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(13),n2h1(11))
  call Hloop_QW_A(ntryL,G1H3(21),ex3(:),G1H1(1),m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(14),n2h1(12))
  call Hloop_WQ_A(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(13))
  call Hloop_WQ_A(ntryL,G1H2(2),ex2(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(16),n2h1(14))
  call Hloop_WQ_A(ntryL,G1H2(5),ex2(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(17),n2h1(15))
  call Hloop_VQ_A(ntryL,G1H2(6),ex2(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(16))
  call Hloop_VQ_A(ntryL,G1H2(7),ex2(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(19),n2h1(17))
  call Hloop_VQ_A(ntryL,G1H2(10),ex2(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(20),n2h1(18))
  call Hloop_WQ_A(ntryL,G1H2(11),ex2(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(19))
  call Hloop_WQ_A(ntryL,G1H2(12),ex2(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(22),n2h1(20))
  call Hloop_WQ_A(ntryL,G1H2(15),ex2(:),G1H1(1),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(23),n2h1(21))
  call Hloop_ZQ_A(ntryL,G1H2(16),ex2(:),G1H1(1),ngZd,m3h2x1(:,12),heltab2x2(:,:,12))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(24),n2h1(22))
  call Hloop_ZQ_A(ntryL,G1H2(17),ex2(:),G1H1(1),ngZd,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),2,0,G2tensor(25),n2h1(23))
  call Hloop_ZQ_A(ntryL,G1H2(20),ex2(:),G1H1(1),ngZd,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(26),n2h1(24))
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
  call G_TensorShift(G1tensor(2),2)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,1),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(2),mass4set(:,2),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(12),4)
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(3),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),4)
  call Hotf_4pt_reduction_last(G2tensor(12),RedSet_4(3),mass4set(:,2),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),4)
  call Hotf_4pt_reduction_last(G2tensor(15),RedSet_4(1),mass4set(:,3),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),2)
  call Hotf_4pt_reduction_last(G2tensor(18),RedSet_4(1),mass4set(:,4),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),2)
  call Hotf_4pt_reduction_last(G2tensor(21),RedSet_4(1),mass4set(:,5),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),2)
  call Hotf_4pt_reduction_last(G2tensor(24),RedSet_4(1),mass4set(:,6),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),2)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(2),mass4set(:,2),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(3),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(3),mass4set(:,2),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(1),mass4set(:,3),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(1),mass4set(:,4),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(1),mass4set(:,5),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(1),mass4set(:,6),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(12),h0tab(:,12),[8,2,5],[0,0,0],3,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(1),n2h12(11))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(13),h0tab(:,13),[8,2,5],[0,nMZ,0],3,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(4),n2h12(12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(14),h0tab(:,14),[8,2,5],[0,nMW,0],3,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(3),n2h12(13))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(15),h0tab(:,15),[8,2,5],[0,0,0],3,1,wf6(:,2))
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_A_Q(ntryL,G0H12(1),8,0,G1H12(2),n2h12(14))
  Gcoeff(:)%j = (-(c(9)*M(2,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(16),h0tab(:,16),[8,2,5],[0,0,0],3,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(6),m3h2x12(:,16),heltab2x24(:,:,16))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(17),h0tab(:,17),[8,1,6],[0,0,0],3,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(5),n2h12(15))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(18),h0tab(:,18),[8,1,6],[0,nMZ,0],3,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(7),n2h12(16))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(19),h0tab(:,19),[8,1,6],[0,nMW,0],3,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(8),n2h12(17))
  Gcoeff(:)%j = (-(c(10)*M(2,:)%j)) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(20),h0tab(:,20),[8,1,6],[0,0,0],3,1,wf6(:,5))
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G0H12(1),8,0,G1H12(9),n2h12(18))
  Gcoeff(:)%j = (c(9)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(21),h0tab(:,21),[8,1,6],[0,0,0],3,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(10),m3h2x12(:,21),heltab2x24(:,:,21))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(22),h0tab(:,22),[9,2,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(1),m3h4x6(:,1),heltab2x24(:,:,22))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(23),h0tab(:,23),[9,2,4],[nMZ,0,0],3,1,wf4(:,3))
  call Hloop_QA_Z(ntryL,G0H24(1),wf4(:,3),G0H6(2),ngZu,m3h4x6(:,2),heltab2x24(:,:,23))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(24),h0tab(:,24),[9,2,4],[0,0,0],3,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(3),m3h4x6(:,3),heltab2x24(:,:,24))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(25),h0tab(:,25),[9,2,4],[0,nMW,0],3,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H24(1),wf4(:,3),G0H6(4),m3h4x6(:,4),heltab2x24(:,:,25))
  call Hloop_A_Q(ntryL,G0H6(4),9,0,G1H6(5),n2h6(3))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(26),h0tab(:,26),[9,2,4],[0,0,nMW],3,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf4(:,3),G0H6(4),m3h4x6(:,5),heltab2x24(:,:,26))
  call Hloop_A_Q(ntryL,G0H6(4),9,0,G1H6(6),n2h6(4))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(27),h0tab(:,27),[9,2,4],[0,nMW,nMZ],3,1,wf4(:,3))
  call Hloop_ZA_Q(ntryL,G0H24(1),wf4(:,3),G0H6(4),ngZu,m3h4x6(:,6),heltab2x24(:,:,27))
  call Hloop_A_Q(ntryL,G0H6(4),9,0,G1H6(7),n2h6(5))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(28),h0tab(:,28),[9,2,4],[0,nMZ,nMW],3,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H24(1),wf4(:,3),G0H6(4),m3h4x6(:,7),heltab2x24(:,:,28))
  call Hloop_A_Q(ntryL,G0H6(4),9,0,G1H6(8),n2h6(6))
  Gcoeff(:)%j = (-(c(4)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(29),h0tab(:,29),[10,1,4],[0,0,0],3,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,8),G0H6(4),m3h4x6(:,8),heltab2x24(:,:,29))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(30),h0tab(:,30),[10,1,4],[nMZ,0,0],3,1,wf4(:,8))
  call Hloop_AQ_Z(ntryL,G0H24(1),wf4(:,8),G0H6(5),ngZd,m3h4x6(:,9),heltab2x24(:,:,30))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(31),h0tab(:,31),[10,1,4],[0,0,0],3,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,8),G0H6(6),m3h4x6(:,10),heltab2x24(:,:,31))
  Gcoeff(:)%j = (c(7)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(32),h0tab(:,32),[10,1,4],[0,0,nMW],3,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(7),m3h4x6(:,11),heltab2x24(:,:,32))
  call Hloop_Q_A(ntryL,G0H6(7),10,0,G1H6(1),n2h6(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(33),h0tab(:,33),[10,1,4],[0,nMW,0],3,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(7),m3h4x6(:,12),heltab2x24(:,:,33))
  call Hloop_Q_A(ntryL,G0H6(7),10,0,G1H6(2),n2h6(8))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(34),h0tab(:,34),[10,1,4],[0,nMZ,nMW],3,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(7),m3h4x6(:,13),heltab2x24(:,:,34))
  call Hloop_Q_A(ntryL,G0H6(7),10,0,G1H6(4),n2h6(9))
  Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(35),h0tab(:,35),[10,1,4],[0,nMW,nMZ],3,1,wf4(:,8))
  call Hloop_ZQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(7),ngZd,m3h4x6(:,14),heltab2x24(:,:,35))
  call Hloop_Q_A(ntryL,G0H6(7),10,0,G1H6(9),n2h6(10))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(2),[G1H12(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H12(9),[G1H12(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(3),[G0H6(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(6),[G0H6(4)])
  call Hloop_AW_Q(ntryL,G1H6(3),ex3(:),G1H2(1),m3h3x2(:,8),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H2(1),13,0,G2H2(1),n2h2(4))
  call Hloop_AQ_V(ntryL,G1H12(2),ex2(:),G1H6(3),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_AQ_Z(ntryL,G1H12(4),ex2(:),G1H6(10),ngZd,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_AQ_W(ntryL,G1H12(3),ex2(:),G1H6(11),m3h2x6(:,12),heltab2x12(:,:,12))
  call Hloop_VQ_A(ntryL,G1H12(6),ex2(:),G1H6(12),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_Q_A(ntryL,G1H6(12),10,0,G2H6(1),n2h6(11))
  call Hloop_QA_V(ntryL,G1H12(9),ex1(:),G1H6(12),m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_QA_Z(ntryL,G1H12(7),ex1(:),G1H6(13),ngZu,m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_QA_W(ntryL,G1H12(8),ex1(:),G1H6(14),m3h2x6(:,16),heltab2x12(:,:,16))
  call Hloop_VA_Q(ntryL,G1H12(10),ex1(:),G1H6(15),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_A_Q(ntryL,G1H6(15),9,0,G2H6(2),n2h6(12))
  call Hloop_VQ_A(ntryL,G0H6(3),ex2(:),G0H3(1),m3h2x3(:,6),heltab2x6(:,:,14))
  call Hloop_Q_A(ntryL,G0H3(1),11,0,G1H3(2),n2h3(5))
  call Hloop_ZQ_A(ntryL,G0H6(2),ex2(:),G0H3(1),ngZd,m3h2x3(:,7),heltab2x6(:,:,15))
  call Hloop_Q_A(ntryL,G0H3(1),11,0,G1H3(3),n2h3(6))
  call Hloop_AQ_W(ntryL,G1H6(5),ex2(:),G1H3(6),m3h2x3(:,8),heltab2x6(:,:,16))
  call Hloop_AQ_V(ntryL,G1H6(6),ex2(:),G1H3(7),m3h2x3(:,9),heltab2x6(:,:,17))
  call Hloop_AQ_W(ntryL,G1H6(7),ex2(:),G1H3(8),m3h2x3(:,10),heltab2x6(:,:,18))
  call Hloop_AQ_Z(ntryL,G1H6(8),ex2(:),G1H3(11),ngZd,m3h2x3(:,11),heltab2x6(:,:,19))
  call Hloop_VA_Q(ntryL,G0H6(6),ex1(:),G0H3(1),m3h2x3(:,12),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G0H3(1),11,0,G1H3(12),n2h3(7))
  call Hloop_ZA_Q(ntryL,G0H6(5),ex1(:),G0H3(1),ngZu,m3h2x3(:,13),heltab2x6(:,:,21))
  call Hloop_A_Q(ntryL,G0H3(1),11,0,G1H3(13),n2h3(8))
  call Hloop_QA_V(ntryL,G1H6(1),ex1(:),G1H3(16),m3h2x3(:,14),heltab2x6(:,:,22))
  call Hloop_QA_W(ntryL,G1H6(2),ex1(:),G1H3(17),m3h2x3(:,15),heltab2x6(:,:,23))
  call Hloop_QA_Z(ntryL,G1H6(4),ex1(:),G1H3(18),ngZu,m3h2x3(:,16),heltab2x6(:,:,24))
  call Hloop_QA_W(ntryL,G1H6(9),ex1(:),G1H3(21),m3h2x3(:,17),heltab2x6(:,:,25))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(12),[G1H3(4)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(1),[G1H3(12)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(10),[G1H3(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(13),[G1H3(9)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(2),[G1H3(14)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(20),[G1H3(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H3(3),[G1H3(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(14),[G1H2(4)])
  call Hloop_AW_Q(ntryL,G1H3(1),ex3(:),G1H1(1),m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(1),n2h1(25))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(6),ex2(:),G2tensor(3),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hloop_AW_Q(ntryL,G1H3(10),ex3(:),G1H1(1),m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(6),n2h1(26))
  call Hloop_AW_Q(ntryL,G1H3(13),ex3(:),G1H1(1),m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(9),n2h1(27))
  call Hloop_QW_A(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(12),n2h1(28))
  call Hloop_QW_A(ntryL,G1H3(20),ex3(:),G1H1(1),m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(15),n2h1(29))
  call Hloop_QW_A(ntryL,G1H3(3),ex3(:),G1H1(1),m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(18),n2h1(30))
  call Hloop_WQ_A(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(21),n2h1(31))
  call Hloop_WQ_A(ntryL,G1H2(14),ex2(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(24),n2h1(32))
  call Hloop_VQ_A(ntryL,G1H2(8),ex2(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(27),n2h1(33))
  call Hloop_VQ_A(ntryL,G1H2(9),ex2(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(28),n2h1(34))
  call Hloop_WQ_A(ntryL,G1H2(13),ex2(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(29),n2h1(35))
  call Hloop_ZQ_A(ntryL,G1H2(18),ex2(:),G1H1(1),ngZd,m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(30),n2h1(36))
  call Hloop_ZQ_A(ntryL,G1H2(19),ex2(:),G1H1(1),ngZd,m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(31),n2h1(37))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(32),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hloop_VA_Q(ntryL,G1H6(3),wf6(:,2),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(33),n2h1(38))
  call Hloop_ZA_Q(ntryL,G1H6(10),wf6(:,2),G1H1(1),ngZd,m3h6x1(:,2),heltab2x6(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(34),n2h1(39))
  call Hloop_WA_Q(ntryL,G1H6(11),wf6(:,2),G1H1(1),m3h6x1(:,3),heltab2x6(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,0,G2tensor(35),n2h1(40))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(1),wf6(:,2),G2tensor(36),m3h6x1(:,4),heltab2x6(:,:,29))
  call Hloop_VQ_A(ntryL,G1H6(12),wf6(:,5),G1H1(1),m3h6x1(:,5),heltab2x6(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(37),n2h1(41))
  call Hloop_ZQ_A(ntryL,G1H6(13),wf6(:,5),G1H1(1),ngZu,m3h6x1(:,6),heltab2x6(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(38),n2h1(42))
  call Hloop_WQ_A(ntryL,G1H6(14),wf6(:,5),G1H1(1),m3h6x1(:,7),heltab2x6(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,0,G2tensor(39),n2h1(43))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(2),wf6(:,5),G2tensor(40),m3h6x1(:,8),heltab2x6(:,:,33))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(6),11,ex3(:),4,G2tensor(41),m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(7),11,ex3(:),4,G2tensor(42),m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(8),11,ex3(:),4,G2tensor(43),m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(11),11,ex3(:),4,G2tensor(44),m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(16),11,ex3(:),4,G2tensor(45),m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(17),11,ex3(:),4,G2tensor(46),m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H3(18),11,ex3(:),4,G2tensor(47),m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_UW_V(ntryL,l_switch,G1H3(21),11,ex3(:),4,G2tensor(48),m3h3x1(:,26),heltab2x3(:,:,26))
  call ol_merge_tensors(G2tensor(40),[G2tensor(37),G2tensor(17),G2tensor(11),G2tensor(2),G1tensor(30),G1tensor(20),G1tensor(5) &
    ,G0tensor(30),G0tensor(20),G0tensor(5)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(36),[G2tensor(33),G2tensor(5),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(34),[G2tensor(8),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(17),G0tensor(17)])
  call ol_merge_tensors(G2tensor(13),[G1tensor(22),G0tensor(22)])
  call ol_merge_tensors(G2tensor(38),[G2tensor(23),G2tensor(14),G1tensor(40),G1tensor(25),G0tensor(40),G0tensor(25)])
  call ol_merge_tensors(G2tensor(45),[G2tensor(16),G1tensor(27),G0tensor(27)])
  call ol_merge_tensors(G2tensor(46),[G2tensor(19),G1tensor(32),G0tensor(32)])
  call ol_merge_tensors(G2tensor(39),[G2tensor(26),G2tensor(20),G1tensor(45),G1tensor(35),G0tensor(45),G0tensor(35)])
  call ol_merge_tensors(G2tensor(47),[G2tensor(22),G1tensor(37),G0tensor(37)])
  call ol_merge_tensors(G2tensor(48),[G2tensor(25),G1tensor(42),G0tensor(42)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(8),G1tensor(2),G0tensor(8),G0tensor(2)])
  call ol_merge_tensors(G2tensor(32),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(28),[G2tensor(3),G1tensor(34),G1tensor(4),G0tensor(34),G0tensor(4)])
  call ol_merge_tensors(G2tensor(15),[G2tensor(6),G1tensor(24),G1tensor(19),G1tensor(14),G1tensor(9),G0tensor(24),G0tensor(19) &
    ,G0tensor(14),G0tensor(9)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(12),[G1tensor(18),G0tensor(18)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(23),G0tensor(23)])
  call ol_merge_tensors(G2tensor(21),[G1tensor(28),G0tensor(28)])
  call ol_merge_tensors(G2tensor(24),[G1tensor(39),G1tensor(29),G0tensor(39),G0tensor(29)])
  call ol_merge_tensors(G2tensor(27),[G1tensor(33),G0tensor(33)])
  call ol_merge_tensors(G2tensor(29),[G1tensor(38),G0tensor(38)])
  call ol_merge_tensors(G2tensor(30),[G1tensor(43),G0tensor(43)])
  call ol_merge_tensors(G2tensor(31),[G1tensor(44),G0tensor(44)])
  call TI_triangle_red(G2tensor(40),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1)
  call TI_triangle_red(G2tensor(4),RedBasis(8),mass3set(:,1),G0tensor(21),G0tensor(26),G0tensor(31),G0tensor(36),M2L1R1)
  call TI_triangle_red(G2tensor(36),RedBasis(4),mass3set(:,1),G0tensor(41),G0tensor(30),G0tensor(20),G0tensor(5),M2L1R1)
  call TI_triangle_red(G2tensor(7),RedBasis(8),mass3set(:,2),G0tensor(7),G0tensor(10),G0tensor(12),G0tensor(15),M2L1R1,[nMZ], &
    G0tensor(17))
  call TI_triangle_red(G2tensor(34),RedBasis(4),mass3set(:,2),G0tensor(22),G0tensor(40),G0tensor(25),G0tensor(27),M2L1R1,[nMZ], &
    G0tensor(32))
  call TI_triangle_red(G2tensor(10),RedBasis(9),mass3set(:,1),G0tensor(45),G0tensor(35),G0tensor(37),G0tensor(42),M2L1R1)
  call TI_triangle_red(G2tensor(13),RedBasis(9),mass3set(:,2),G0tensor(8),G0tensor(2),G0tensor(3),G0tensor(34),M2L1R1,[nMZ], &
    G0tensor(4))
  call TI_triangle_red(G2tensor(38),RedBasis(1),mass3set(:,2),G0tensor(24),G0tensor(19),G0tensor(14),G0tensor(9),M2L1R1,[nMZ], &
    G0tensor(13))
  call TI_triangle_red(G2tensor(45),RedBasis(6),mass3set(:,3),G0tensor(18),G0tensor(23),G0tensor(28),G0tensor(39),M2L1R1,[nMW], &
    G0tensor(29))
  call TI_triangle_red(G2tensor(46),RedBasis(6),mass3set(:,4),G0tensor(33),G0tensor(38),G0tensor(43),G0tensor(44),M2L1R1,[nMW], &
    G0tensor(46))
  call TI_triangle_red(G2tensor(39),RedBasis(1),mass3set(:,4),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50),M2L1R1,[nMW], &
    G0tensor(51))
  call TI_triangle_red(G2tensor(47),RedBasis(6),mass3set(:,5),G0tensor(52),G0tensor(53),G0tensor(54), &
    G0tensor(55),M2L1R1,[nMW,nMZ],G0tensor(56),G0tensor(57))
  call TI_triangle_red(G2tensor(48),RedBasis(6),mass3set(:,6),G0tensor(58),G0tensor(59),G0tensor(60), &
    G0tensor(61),M2L1R1,[nMZ,nMW],G0tensor(62),G0tensor(63))
  call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,1),G0tensor(64),G0tensor(65),G0tensor(66),G0tensor(67),M2L1R1)
  call TI_triangle_red(G2tensor(32),RedBasis(3),mass3set(:,1),G0tensor(68),G0tensor(69),G0tensor(70),G0tensor(71),M2L1R1)
  call TI_triangle_red(G2tensor(28),RedBasis(2),mass3set(:,1),G0tensor(72),G0tensor(73),G0tensor(74),G0tensor(75),M2L1R1)
  call TI_triangle_red(G2tensor(15),RedBasis(5),mass3set(:,1),G0tensor(76),G0tensor(77),G0tensor(78),G0tensor(79),M2L1R1)
  call TI_triangle_red(G2tensor(9),RedBasis(6),mass3set(:,7),G0tensor(80),G0tensor(81),G0tensor(82),G0tensor(83),M2L1R1,[nMZ], &
    G0tensor(84))
  call TI_triangle_red(G2tensor(12),RedBasis(7),mass3set(:,1),G0tensor(85),G0tensor(86),G0tensor(87),G0tensor(88),M2L1R1)
  call TI_triangle_red(G2tensor(18),RedBasis(7),mass3set(:,7),G0tensor(89),G0tensor(90),G0tensor(91),G0tensor(92),M2L1R1,[nMZ], &
    G0tensor(93))
  call TI_triangle_red(G2tensor(21),RedBasis(3),mass3set(:,4),G0tensor(94),G0tensor(95),G0tensor(96),G0tensor(97),M2L1R1,[nMW], &
    G0tensor(98))
  call TI_triangle_red(G2tensor(24),RedBasis(2),mass3set(:,4),G0tensor(99),G0tensor(100),G0tensor(101),G0tensor(102),M2L1R1,[nMW], &
    G0tensor(103))
  call TI_triangle_red(G2tensor(27),RedBasis(3),mass3set(:,8),G0tensor(104),G0tensor(105),G0tensor(106), &
    G0tensor(107),M2L1R1,[nMW],G0tensor(108))
  call TI_triangle_red(G2tensor(29),RedBasis(3),mass3set(:,9),G0tensor(109),G0tensor(110),G0tensor(111), &
    G0tensor(112),M2L1R1,[nMZ,nMW],G0tensor(113),G0tensor(114))
  call TI_triangle_red(G2tensor(30),RedBasis(3),mass3set(:,10),G0tensor(115),G0tensor(116),G0tensor(117), &
    G0tensor(118),M2L1R1,[nMW,nMZ],G0tensor(119),G0tensor(120))
  call TI_triangle_red(G2tensor(31),RedBasis(2),mass3set(:,2),G0tensor(121),G0tensor(122),G0tensor(123), &
    G0tensor(124),M2L1R1,[nMZ],G0tensor(125))
  call TI_triangle_red(G2tensor(35),RedBasis(4),mass3set(:,4),G0tensor(126),G0tensor(127),G0tensor(128), &
    G0tensor(129),M2L1R1,[nMW],G0tensor(130))
  call TI_triangle_red(G2tensor(41),RedBasis(7),mass3set(:,4),G0tensor(131),G0tensor(132),G0tensor(133), &
    G0tensor(134),M2L1R1,[nMW],G0tensor(135))
  call TI_triangle_red(G2tensor(42),RedBasis(7),mass3set(:,3),G0tensor(136),G0tensor(137),G0tensor(138), &
    G0tensor(139),M2L1R1,[nMW],G0tensor(140))
  call TI_triangle_red(G2tensor(43),RedBasis(7),mass3set(:,6),G0tensor(141),G0tensor(142),G0tensor(143), &
    G0tensor(144),M2L1R1,[nMZ,nMW],G0tensor(145),G0tensor(146))
  call TI_triangle_red(G2tensor(44),RedBasis(7),mass3set(:,5),G0tensor(147),G0tensor(148),G0tensor(149), &
    G0tensor(150),M2L1R1,[nMW,nMZ],G0tensor(151),G0tensor(152))
  call ol_merge_tensors(T0sum(10),[G0tensor(1)])
  call ol_merge_tensors(T0sum(11),[G0tensor(21)])
  call ol_merge_tensors(T0sum(12),[G0tensor(41)])
  call ol_merge_tensors(T0sum(13),[G0tensor(7)])
  call ol_merge_tensors(T0sum(14),[G0tensor(22)])
  call ol_merge_tensors(T0sum(15),[G0tensor(45)])
  call ol_merge_tensors(T0sum(16),[G0tensor(8)])
  call ol_merge_tensors(T0sum(17),[G0tensor(24)])
  call ol_merge_tensors(T0sum(18),[G0tensor(18)])
  call ol_merge_tensors(T0sum(19),[G0tensor(33)])
  call ol_merge_tensors(T0sum(20),[G0tensor(47)])
  call ol_merge_tensors(T0sum(21),[G0tensor(52)])
  call ol_merge_tensors(T0sum(22),[G0tensor(58)])
  call ol_merge_tensors(T0sum(23),[G0tensor(64)])
  call ol_merge_tensors(T0sum(24),[G0tensor(68)])
  call ol_merge_tensors(T0sum(25),[G0tensor(72)])
  call ol_merge_tensors(T0sum(26),[G0tensor(76)])
  call ol_merge_tensors(T0sum(27),[G0tensor(80)])
  call ol_merge_tensors(T0sum(28),[G0tensor(85)])
  call ol_merge_tensors(T0sum(29),[G0tensor(89)])
  call ol_merge_tensors(T0sum(30),[G0tensor(94)])
  call ol_merge_tensors(T0sum(31),[G0tensor(99)])
  call ol_merge_tensors(T0sum(32),[G0tensor(104)])
  call ol_merge_tensors(T0sum(33),[G0tensor(109)])
  call ol_merge_tensors(T0sum(34),[G0tensor(115)])
  call ol_merge_tensors(T0sum(35),[G0tensor(121)])
  call ol_merge_tensors(T0sum(36),[G0tensor(126)])
  call ol_merge_tensors(T0sum(37),[G0tensor(131)])
  call ol_merge_tensors(T0sum(38),[G0tensor(136)])
  call ol_merge_tensors(T0sum(39),[G0tensor(141)])
  call ol_merge_tensors(T0sum(40),[G0tensor(147)])
  Gcoeff(:)%j = (c(3)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(36),h0tab(:,36),[10,5],[0,0],2,2,wf4(:,8),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(7),m3h4x6(:,15),heltab2x24(:,:,36))
  call Hloop_Q_A(ntryL,G0H6(7),10,0,G1H6(15),n2h6(13))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(37),h0tab(:,37),[10,5],[0,nMZ],2,2,wf4(:,8),wf6(:,2))
  call Hloop_ZQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(1),ngZd,m3h4x6(:,16),heltab2x24(:,:,37))
  call Hloop_Q_A(ntryL,G0H6(1),10,0,G1H6(5),n2h6(14))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(38),h0tab(:,38),[10,5],[0,nMW],2,2,wf4(:,8),wf6(:,2))
  call Hloop_WQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(4),m3h4x6(:,17),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G0H6(4),10,0,G1H6(6),n2h6(15))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(39),h0tab(:,39),[10,5],[0,0],2,2,wf4(:,8),wf6(:,2))
  call Hloop_VQ_A(ntryL,G0H24(1),wf4(:,8),G0H6(3),m3h4x6(:,18),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G0H6(3),10,0,G1H6(7),n2h6(16))
  Gcoeff(:)%j = (c(6)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(40),h0tab(:,40),[9,6],[0,0],2,2,wf4(:,3),wf6(:,5))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(2),m3h4x6(:,19),heltab2x24(:,:,40))
  Gcoeff(:)%j = (c(8)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(41),h0tab(:,41),[9,6],[nMZ,0],2,2,wf4(:,3),wf6(:,5))
  call Hloop_QA_Z(ntryL,G0H24(1),wf4(:,3),G0H6(6),ngZu,m3h4x6(:,20),heltab2x24(:,:,41))
  Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(42),h0tab(:,42),[9,6],[nMW,0],2,2,wf4(:,3),wf6(:,5))
  call Hloop_QA_W(ntryL,G0H24(1),wf4(:,3),G0H6(5),m3h4x6(:,21),heltab2x24(:,:,42))
  Gcoeff(:)%j = (c(11)*M(2,:)%j) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(43),h0tab(:,43),[9,6],[0,0],2,2,wf4(:,3),wf6(:,5))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,3),G0H6(7),m3h4x6(:,22),heltab2x24(:,:,43))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H6(7),[G1H6(15)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G0H6(7),[G0H6(2)])
  call Hcheck_last_QA_V(ntryL,l_switch,G1H6(7),wf6(:,2),G1tensor(1),m3h6x1(:,9),heltab2x6(:,:,34))
  call Hcheck_last_QA_Z(ntryL,l_switch,G1H6(5),wf6(:,2),G1tensor(6),ngZd,m3h6x1(:,10),heltab2x6(:,:,35))
  call Hcheck_last_QA_W(ntryL,l_switch,G1H6(6),wf6(:,2),G1tensor(11),m3h6x1(:,11),heltab2x6(:,:,36))
  call Hloop_VQ_A(ntryL,G0H6(7),wf6(:,5),G0H1(1),m3h6x1(:,12),heltab2x6(:,:,37))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(16),n2h1(44))
  call Hloop_ZQ_A(ntryL,G0H6(6),wf6(:,5),G0H1(1),ngZu,m3h6x1(:,13),heltab2x6(:,:,38))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(21),n2h1(45))
  call Hloop_WQ_A(ntryL,G0H6(5),wf6(:,5),G0H1(1),m3h6x1(:,14),heltab2x6(:,:,39))
  call Hcheck_last_Q_A(ntryL,l_switch,G0H1(1),15,0,G1tensor(26),n2h1(46))
  call ol_merge_tensors(G0tensor(65),[G0tensor(23),G0tensor(35),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G1tensor(16),[G0tensor(134),G0tensor(97),G0tensor(88),G0tensor(71),G0tensor(11)])
  call ol_merge_tensors(G0tensor(129),[G0tensor(124),G0tensor(102),G0tensor(79),G0tensor(75),G0tensor(50),G0tensor(9),G0tensor(27) &
    ,G0tensor(5),G0tensor(16)])
  call ol_merge_tensors(G0tensor(137),[G0tensor(106),G0tensor(86),G0tensor(74),G0tensor(70),G0tensor(37),G0tensor(30) &
    ,G0tensor(26)])
  call ol_merge_tensors(G0tensor(77),[G0tensor(34),G0tensor(42),G0tensor(15),G0tensor(36)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(73),G0tensor(67),G0tensor(44),G0tensor(20)])
  call ol_merge_tensors(G0tensor(148),[G0tensor(40),G0tensor(10)])
  call ol_merge_tensors(G0tensor(81),[G0tensor(12)])
  call ol_merge_tensors(G0tensor(152),[G0tensor(145),G0tensor(125),G0tensor(120),G0tensor(113),G0tensor(93),G0tensor(84) &
    ,G0tensor(62),G0tensor(57),G0tensor(13),G0tensor(4),G0tensor(32),G0tensor(17)])
  call ol_merge_tensors(G0tensor(83),[G0tensor(25)])
  call ol_merge_tensors(G0tensor(53),[G0tensor(19),G0tensor(2)])
  call ol_merge_tensors(G0tensor(123),[G0tensor(117),G0tensor(90),G0tensor(3)])
  call ol_merge_tensors(G1tensor(21),[G0tensor(112),G0tensor(92),G0tensor(14)])
  call ol_merge_tensors(G0tensor(138),[G0tensor(95),G0tensor(28)])
  call ol_merge_tensors(G1tensor(11),[G0tensor(100),G0tensor(55),G0tensor(39)])
  call ol_merge_tensors(G0tensor(151),[G0tensor(146),G0tensor(140),G0tensor(135),G0tensor(130),G0tensor(119),G0tensor(114) &
    ,G0tensor(108),G0tensor(103),G0tensor(98),G0tensor(63),G0tensor(56),G0tensor(51),G0tensor(46),G0tensor(29)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(48),G0tensor(38)])
  call ol_merge_tensors(G0tensor(133),[G0tensor(105),G0tensor(43)])
  call ol_merge_tensors(G1tensor(26),[G0tensor(118),G0tensor(107),G0tensor(49)])
  call ol_merge_tensors(G0tensor(149),[G0tensor(110),G0tensor(54)])
  call ol_merge_tensors(G0tensor(143),[G0tensor(116),G0tensor(60)])
  call ol_merge_tensors(G1tensor(6),[G0tensor(122),G0tensor(61)])
  call ol_merge_tensors(G0tensor(91),[G0tensor(87),G0tensor(82),G0tensor(78),G0tensor(69),G0tensor(66)])
  call ol_merge_tensors(G0tensor(111),[G0tensor(101),G0tensor(96)])
  call ol_merge_tensors(G0tensor(142),[G0tensor(132),G0tensor(127)])
  call ol_merge_tensors(G0tensor(150),[G0tensor(139)])
call TI_bubble_red(G1tensor(16),9,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G1tensor(1),10,mass2set(:,1),G0tensor(21),M2L1R1)
call TI_bubble_red(G1tensor(21),9,mass2set(:,2),G0tensor(41),M2L1R1,G0tensor(7))
call TI_bubble_red(G1tensor(11),10,mass2set(:,3),G0tensor(22),M2L1R1,G0tensor(45))
call TI_bubble_red(G1tensor(26),9,mass2set(:,4),G0tensor(8),M2L1R1,G0tensor(24))
call TI_bubble_red(G1tensor(6),10,mass2set(:,5),G0tensor(18),M2L1R1,G0tensor(33))
  call ol_merge_tensors(G0tensor(33),[G0tensor(7),G0tensor(152)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(151),G0tensor(45)])
  call ol_merge_tensors(T0sum(41),[G0tensor(65)])
  call ol_merge_tensors(T0sum(42),[G0tensor(1)])
  call ol_merge_tensors(T0sum(43),[G0tensor(129)])
  call ol_merge_tensors(T0sum(44),[G0tensor(137)])
  call ol_merge_tensors(T0sum(45),[G0tensor(77)])
  call ol_merge_tensors(T0sum(46),[G0tensor(21)])
  call ol_merge_tensors(T0sum(47),[G0tensor(148)])
  call ol_merge_tensors(T0sum(48),[G0tensor(81)])
  call ol_merge_tensors(T0sum(49),[G0tensor(33)])
  call ol_merge_tensors(T0sum(50),[G0tensor(83)])
  call ol_merge_tensors(T0sum(51),[G0tensor(53)])
  call ol_merge_tensors(T0sum(52),[G0tensor(123)])
  call ol_merge_tensors(T0sum(53),[G0tensor(41)])
  call ol_merge_tensors(T0sum(54),[G0tensor(138)])
  call ol_merge_tensors(T0sum(55),[G0tensor(22)])
  call ol_merge_tensors(T0sum(56),[G0tensor(24)])
  call ol_merge_tensors(T0sum(57),[G0tensor(59)])
  call ol_merge_tensors(T0sum(58),[G0tensor(133)])
  call ol_merge_tensors(T0sum(59),[G0tensor(8)])
  call ol_merge_tensors(T0sum(60),[G0tensor(149)])
  call ol_merge_tensors(T0sum(61),[G0tensor(143)])
  call ol_merge_tensors(T0sum(62),[G0tensor(18)])
  call ol_merge_tensors(T0sum(63),[G0tensor(91)])
  call ol_merge_tensors(T0sum(64),[G0tensor(111)])
  call ol_merge_tensors(T0sum(65),[G0tensor(142)])
  call ol_merge_tensors(T0sum(66),[G0tensor(128)])
  call ol_merge_tensors(T0sum(67),[G0tensor(150)])
  call ol_merge_tensors(T0sum(68),[G0tensor(144)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvj_ew_uxdwxg_1_/**/REALKIND
