
module ol_vamp_1_ppvj_ew_uuxz_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppvj_ew_uuxz_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppvj_ew_uuxz_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppvj_ew_uuxz_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppvj_ew_uuxz_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_ppvj_ew_uuxz_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppvj_ew_uuxz_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(12)
  type(Hpolcont), intent(in) :: M(2,12)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(1)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(1),h0tab(:,1),[4,1,2],[0,0,0],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZu,m3h3x4(:,1),heltab2x12(:,:,1))
  call Hloop_A_Q(ntryL,G0H4(1),4,0,G1H4(1),n2h4(1))
  Gcoeff(:)%j = (-(c(2)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(2),h0tab(:,2),[4,1,2],[0,nMZ,0],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZu,m3h3x4(:,2),heltab2x12(:,:,2))
  call Hloop_A_Q(ntryL,G0H4(1),4,0,G1H4(2),n2h4(2))
  Gcoeff(:)%j = (-(c(5)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(3),h0tab(:,3),[4,1,2],[0,nMW,0],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZd,m3h3x4(:,3),heltab2x12(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),4,0,G1H4(3),n2h4(3))
  Gcoeff(:)%j = (-(c(3)*M(1,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(4),h0tab(:,4),[4,1,2],[0,0,0],3,0)
  call Hloop_AZ_Q(ntryL,G0H12(1),ex3(:),G0H4(1),ngZu,m3h3x4(:,4),heltab2x12(:,:,4))
  call Hloop_A_Q(ntryL,G0H4(1),4,0,G1H4(4),n2h4(4))
  Gcoeff(:)%j = (-(c(4)*M(2,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H12(1),m0h(5),h0tab(:,5),[4,1,2],[nMW,0,nMW],3,0)
  call Hloop_UV_W(ntryL,G0H12(1),0,ex3(:),4,G1H4(5),m3h3x4(:,5),heltab2x12(:,:,5))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(1)])
  call Hloop_AQ_V(ntryL,G1H4(4),ex1(:),G1H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_Z(ntryL,G1H4(2),ex1(:),G1H2(2),ngZu,m3h2x2(:,2),heltab2x4(:,:,2))
  call Hloop_AQ_W(ntryL,G1H4(3),ex1(:),G1H2(3),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_WQ_A(ntryL,G1H4(5),ex1(:),G1H2(4),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_Q_A(ntryL,G1H2(4),5,0,G2H2(1),n2h2(1))
  call Hloop_VA_Q(ntryL,G1H2(1),ex2(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,0,G2tensor(1),n2h1(1))
  call Hloop_ZA_Q(ntryL,G1H2(2),ex2(:),G1H1(1),ngZu,m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,0,G2tensor(2),n2h1(2))
  call Hloop_WA_Q(ntryL,G1H2(3),ex2(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),7,0,G2tensor(3),n2h1(3))
  call Hcheck_last_QA_W(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
  call TI_triangle_red(G2tensor(1),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(1),mass3set(:,2),G0tensor(5),G0tensor(6),G0tensor(7),G0tensor(8),M2L1R1,[nMZ], &
    G0tensor(9))
  call TI_triangle_red(G2tensor(3),RedBasis(1),mass3set(:,3),G0tensor(10),G0tensor(11),G0tensor(12),G0tensor(13),M2L1R1,[nMW], &
    G0tensor(14))
  call TI_triangle_red(G2tensor(4),RedBasis(1),mass3set(:,4),G0tensor(15),G0tensor(16),G0tensor(17),G0tensor(18),M2L1R1,[nMW], &
    G0tensor(19))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(5)])
  call ol_merge_tensors(T0sum(3),[G0tensor(10)])
  call ol_merge_tensors(T0sum(4),[G0tensor(15)])
  call ol_merge_tensors(G0tensor(13),[G0tensor(8),G0tensor(4)])
  call ol_merge_tensors(G0tensor(19),[G0tensor(14)])
  call ol_merge_tensors(T0sum(5),[G0tensor(2)])
  call ol_merge_tensors(T0sum(6),[G0tensor(3)])
  call ol_merge_tensors(T0sum(7),[G0tensor(13)])
  call ol_merge_tensors(T0sum(8),[G0tensor(6)])
  call ol_merge_tensors(T0sum(9),[G0tensor(7)])
  call ol_merge_tensors(T0sum(10),[G0tensor(9)])
  call ol_merge_tensors(T0sum(11),[G0tensor(11)])
  call ol_merge_tensors(T0sum(12),[G0tensor(12)])
  call ol_merge_tensors(T0sum(13),[G0tensor(19)])
  call ol_merge_tensors(T0sum(14),[G0tensor(16)])
  call ol_merge_tensors(T0sum(15),[G0tensor(17)])
  call ol_merge_tensors(T0sum(16),[G0tensor(18)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_ppvj_ew_uuxz_1_/**/REALKIND
