
module ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(12,1), K2(1,2), KL(1,2), Cas(4) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [ 3]
  K1( 2,:) = [ 0]
  K1( 3,:) = [ 0]
  K1( 4,:) = [ 0]
  K1( 5,:) = [ 0]
  K1( 6,:) = [ 0]
  K1( 7,:) = [ 0]
  K1( 8,:) = [ 0]
  K1( 9,:) = [ 0]
  K1(10,:) = [ 0]
  K1(11,:) = [ 0]
  K1(12,:) = [ 3]

  K2(1,:) = [ 0, 3]

  KL(1,:) = [ 3, 0]

#if 1 > 0
    co = 0
    do k = 1, 4
      co = co + k
      Cas(k) = K1(1+1*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND



module ol_forced_parameters_ppvj_ew_uxdawx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMW /= 0) write(*,101) 'wMW = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_ppvj_ew_uxdawx_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_ppvj_ew_uxdawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 24 ! number of helicity configurations
  integer(intkind2), save :: nhel = 24 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(24) ! physical helicity states
#endif

  complex(REALKIND), save :: den(9)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,15), wf6(6,11), wf24(24,21)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(58), c(42)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,24), M0M1_hel_cc(2,24,11)
  complex(REALKIND), save :: M2ctcc(11)

end module ol_loop_storage_ppvj_ew_uxdawx_1_/**/REALKIND






! **********************************************************************
module ol_loop_ppvj_ew_uxdawx_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_ppvj_ew_uxdawx_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (CI*eQED**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 2) = (2*CI*eQED**2)/(3._/**/REALKIND*sqrt2*sw)
    f( 3) = (CI*eQED**2)/(sqrt2*sw)
    f( 4) = (CI*countertermnorm*eQED**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 5) = (2*CI*countertermnorm*eQED**4)/(3._/**/REALKIND*sqrt2*sw)
    f( 6) = (CI*countertermnorm*eQED**4)/(sqrt2*sw)
    f( 7) = (CI*countertermnorm*eQED**4*EWctAWW)/(sqrt2*sw)
    f( 8) = (CI*countertermnorm*eQED**4*EWctVud)/(3._/**/REALKIND*sqrt2*sw)
    f( 9) = (2*CI*countertermnorm*eQED**4*EWctVud)/(3._/**/REALKIND*sqrt2*sw)
    f(10) = (CI*countertermnorm*eQED**4*EWctVud)/(sqrt2*sw)
    f(11) = (CI*countertermnorm*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f(12) = (2*CI*countertermnorm*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f(13) = (CI*countertermnorm*ctSqq*eQED**2*gQCD**2)/(sqrt2*sw)
    f(14) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f(15) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**2)/(3._/**/REALKIND*sqrt2*sw)
    f(16) = (CI*countertermnorm*ctVqq*eQED**2*gQCD**2)/(sqrt2*sw)
    f(17) = (CI*countertermnorm*eQED**4*MW)/(sqrt2*sw)
    f(18) = (eQED**4*integralnorm*MW**2*SwB)/(cw*sqrt2)
    f(19) = (eQED**4*integralnorm*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(20) = (eQED**4*integralnorm*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(21) = (eQED**4*integralnorm*SwB)/(sqrt2*sw**3)
    f(22) = (cw**2*eQED**4*integralnorm*SwB)/(sqrt2*sw**3)
    f(23) = (eQED**4*integralnorm*MH**2*SwB)/(sqrt2*sw**3*4._/**/REALKIND)
    f(24) = (eQED**4*integralnorm*MW**2*SwB)/(sqrt2*sw**3*2._/**/REALKIND)
    f(25) = (eQED**4*integralnorm*MW**2*SwB)/(sqrt2*sw**3)
    f(26) = (eQED**4*integralnorm*sqrt2*SwB)/(sw**3*12._/**/REALKIND)
    f(27) = (eQED**4*integralnorm*sqrt2*SwB)/(sw**3*6._/**/REALKIND)
    f(28) = (eQED**4*integralnorm*sqrt2*SwB)/(sw**3*4._/**/REALKIND)
    f(29) = (cw*eQED**4*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(30) = (2*cw*eQED**4*integralnorm*SwB)/(sqrt2*sw**2*3._/**/REALKIND)
    f(31) = (cw*eQED**4*integralnorm*SwB)/(sqrt2*sw**2)
    f(32) = (eQED**4*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(33) = (2*eQED**4*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(34) = (eQED**4*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(35) = (4*eQED**4*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(36) = (2*eQED**4*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(37) = (8*eQED**4*integralnorm*SwB)/(sqrt2*sw*27._/**/REALKIND)
    f(38) = (eQED**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(39) = (4*eQED**4*integralnorm*SwB)/(sqrt2*sw*9._/**/REALKIND)
    f(40) = (2*eQED**4*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(41) = (eQED**4*integralnorm*SwB)/(sqrt2*sw)
    f(42) = (eQED**2*gQCD**2*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(43) = (2*eQED**2*gQCD**2*integralnorm*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(44) = (eQED**2*gQCD**2*integralnorm*SwB)/(sqrt2*sw)
    f(45) = (eQED**4*integralnorm*MW**2*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(46) = (2*eQED**4*integralnorm*MW**2*SwB)/(sqrt2*sw*3._/**/REALKIND)
    f(47) = (eQED**4*integralnorm*MW**2*SwB)/(sqrt2*sw)
    f(48) = (eQED**4*integralnorm*MW**2*sw*SwB)/(cw**2*sqrt2)
    f(49) = -((eQED**4*integralnorm*MW**2*(cw - sw)*(cw + sw)*SwB)/(sqrt2*sw**3*2._/**/REALKIND))
    f(50) = (eQED**4*integralnorm*MW**2*(-cw + sw)*(cw + sw)*SwB)/(cw**2*sqrt2*sw*2._/**/REALKIND)
    f(51) = (eQED**4*integralnorm*sqrt2*SwF)/(sw**3*12._/**/REALKIND)
    f(52) = (eQED**4*integralnorm*sqrt2*SwF)/(sw**3*6._/**/REALKIND)
    f(53) = (eQED**4*integralnorm*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(54) = (eQED**4*integralnorm*sqrt2*SwF)/(sw**3*3._/**/REALKIND)
    f(55) = (eQED**4*integralnorm*sqrt2*SwF)/(sw**3*2._/**/REALKIND)
    f(56) = (eQED**4*integralnorm*ME*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(57) = (eQED**4*integralnorm*ML*sqrt2*SwF)/(sw**3*4._/**/REALKIND)
    f(58) = (eQED**4*integralnorm*MM*sqrt2*SwF)/(sw**3*4._/**/REALKIND)

  c = [ 3*f(18), 3*f(19), 3*f(20), 3*f(21), 3*f(22), 3*f(23), 3*f(24), 3*f(25), 3*f(26), 3*f(27), 3*f(28), 3*f(29), 3*f(30) &
    , 3*f(31), 3*f(32), 3*f(33), 3*f(34), 3*f(35), 3*f(36), 3*f(37), 3*f(38), 3*f(39), 3*f(40), 3*f(41), 4*f(42), 4*f(43), 4*f(44) &
    , 3*f(45), 3*f(46), 3*f(47), 3*f(48), 3*f(49), 3*f(50), 9*f(51), 9*f(52), 3*f(53), 9*f(53), 9*f(54), 9*f(55), 3*f(56), 3*f(57) &
    , 3*f(58) ]
  c = (1._/**/REALKIND / 3) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,3) - MW2)+L(6,3))
  den(2) = 1 /((L(5,5))+L(6,5))
  den(3) = 1 /((L(5,9))+L(6,9))
  den(4) = 1 /((L(5,6))+L(6,6))
  den(5) = 1 /((L(5,10))+L(6,10))
  den(6) = 1 /((L(5,12) - MW2)+L(6,12))

  ! denominators
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(5)
  den(9) = den(3)*den(4)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_ppvj_ew_uxdawx_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for anti-up down gamma W+ -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_ppvj_ew_uxdawx_1, only: &
    & external_perm_ppvj_ew_uxdawx_1, &
    & external_perm_inv_ppvj_ew_uxdawx_1, &
    & extcomb_perm_ppvj_ew_uxdawx_1, &
    & average_factor_ppvj_ew_uxdawx_1, &
    & photonid_ppvj_ew_uxdawx_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_ppvj_ew_uxdawx_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_ppvj_ew_uxdawx_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_ppvj_ew_uxdawx_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,4)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(11)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,4)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,4)
#endif
  integer           :: extmasses2(4)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(11)
  complex(REALKIND) :: M1(1), M2(2)
  real(REALKIND)    :: P_scatt_intern(0:3,4)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,24)
  type(Hpolcont) :: M1helarray_ct(2,24)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(11), nextcombs
#if 4 > 3
  integer :: ind_cc_comb(2)
#endif
  type(Hpolcont) :: A(24,21)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(21)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 1)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, 0, 0, nMW ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_ppvj_ew_uxdawx_1, 4, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_A(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rZERO, H2, ex2, POLSEL(2),2)
  call pol_wf_V(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_V(P(:,4), rMW, H4, ex4, POLSEL(4),4)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex2(:), ex1(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf6(:,1), n3(:,2), t3x6(:,:,1))
  call vert_AV_Q(ntry, ex1(:), ex3(:), wf4(:,2), n3(:,3), t3x4(:,:,2))
  call vert_WQ_A(ntry, ex4(:), ex2(:), wf6(:,2), n3(:,4), t3x6(:,:,2))
  call prop_A_Q(ntry, wf4(:,2), 5, ZERO, 0_intkind1, wf4(:,3), n2(1))
  call vert_AW_Q(ntry, ex1(:), ex4(:), wf6(:,3), n3(:,5), t3x6(:,:,3))
  call vert_VQ_A(ntry, ex3(:), ex2(:), wf4(:,4), n3(:,6), t3x4(:,:,3))
  call prop_A_Q(ntry, wf6(:,3), 9, ZERO, 0_intkind1, wf6(:,4), n2(2))
  call counter_UV_W(ntry, ex3(:), 4, ex4(:), 8, wf6(:,5), n3(:,7), t3x6(:,:,4))
  call counter_WQ_A(ntry, ex4(:), ex2(:), wf6(:,6), n3(:,8), t3x6(:,:,5))
  call counter_VQ_A(ntry, ex3(:), ex2(:), wf4(:,5), n3(:,9), t3x4(:,:,4))
  call counter_VQ_A_LR(EWctAdd,ntry, ex3(:), ex2(:), wf4(:,6), n3(:,10), t3x4(:,:,5))
  call counter_AW_Q(ntry, ex1(:), ex4(:), wf6(:,7), n3(:,11), t3x6(:,:,6))
  call prop_Q_A(ntry, wf4(:,4), 6, ZERO, 0_intkind1, wf4(:,7), n2(3))
  call counter_AV_Q(ntry, ex1(:), ex3(:), wf4(:,8), n3(:,12), t3x4(:,:,6))
  call prop_Q_A(ntry, wf6(:,2), 10, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call counter_AV_Q_LR(EWctAuu,ntry, ex1(:), ex3(:), wf4(:,9), n3(:,13), t3x4(:,:,7))
  call vert_VV_S(ntry, ex3(:), ex4(:), wf6(:,9), n3(:,14), t3x6(:,:,7))
  call counter_AQ_S(gPud,ntry, ex1(:), ex2(:), wf4(:,10), n3(:,15), t3x4(:,:,8))
  call counter_QA_W(ntry, ex2(:), ex1(:), wf4(:,11), n3(:,16), t3x4(:,:,9))
  call counter_V_S(EWctPW,ntry, wf4(:,1), 3, wf4(:,12), n2(5))
  call counter_V_V(EWctWW,ntry, wf4(:,1), 3, wf4(:,13), n2(6))
  call counter_A_Q(ctqq,2,ntry, wf4(:,3), 5, wf4(:,14), n2(7))
  call counter_A_Q_LR(EWctuu,ntry, wf4(:,3), 5, wf4(:,15), n2(8))
  call counter_A_Q(ctqq,1,ntry, wf6(:,4), 9, wf6(:,10), n2(9))
  call counter_A_Q_LR(EWctdd,ntry, wf6(:,4), 9, wf6(:,11), n2(10))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_ppvj_ew_uxdawx_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 11-1)]
  nextcombs = 4*(4+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_ppvj_ew_uxdawx_1(extcombs(k))
  end do

#if 1 > 0 && 4 > 3
  !!Born-loop colour correlators interference
ind_cc_comb = [8,9]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 2
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4
integer :: n

n=0

do i4= 1, 3
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf
 end if
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,1), wf6(:,1), A(:,1), n3(:,17), t3x24(:,:,1), nhel, den(1))
    call Hcont_QA(nsync, wf6(:,2), wf4(:,3), A(:,2), n3(:,18), t3x24(:,:,2), nhel, den(2))
    call Hcont_QA(nsync, wf4(:,4), wf6(:,4), A(:,3), n3(:,19), t3x24(:,:,3), nhel, den(3))

    call Hcont_VV(nsync, wf4(:,1), wf6(:,5), A(:,4), n3(:,20), t3x24(:,:,4), nhel, den(1))
    call Hcont_QA(nsync, wf4(:,3), wf6(:,6), A(:,5), n3(:,21), t3x24(:,:,5), nhel, den(2))
    call Hcont_QA(nsync, wf4(:,3), wf6(:,6), A(:,6), n3(:,22), t3x24(:,:,6), nhel, den(2))
    call Hcont_QA(nsync, wf6(:,4), wf4(:,5), A(:,7), n3(:,23), t3x24(:,:,7), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,4), wf4(:,6), A(:,8), n3(:,24), t3x24(:,:,8), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,7), wf4(:,7), A(:,9), n3(:,25), t3x24(:,:,9), nhel, den(4))
    call Hcont_QA(nsync, wf6(:,7), wf4(:,7), A(:,10), n3(:,26), t3x24(:,:,10), nhel, den(4))
    call Hcont_QA(nsync, wf4(:,8), wf6(:,8), A(:,11), n3(:,27), t3x24(:,:,11), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,8), wf4(:,9), A(:,12), n3(:,28), t3x24(:,:,12), nhel, den(5))
    call Hcont_SS(nsync, wf6(:,9), wf4(:,10), A(:,13), n3(:,29), t3x24(:,:,13), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,1), wf4(:,11), A(:,14), n3(:,30), t3x24(:,:,14), nhel, den(6))
    call Hcont_VV(nsync, wf6(:,1), wf4(:,11), A(:,15), n3(:,31), t3x24(:,:,15), nhel, den(6))
    call Hcont_SS(nsync, wf6(:,9), wf4(:,12), A(:,16), n3(:,32), t3x24(:,:,16), nhel, den(7))
    call Hcont_VV(nsync, wf6(:,1), wf4(:,13), A(:,17), n3(:,33), t3x24(:,:,17), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,8), wf4(:,14), A(:,18), n3(:,34), t3x24(:,:,18), nhel, den(8))
    call Hcont_QA(nsync, wf6(:,8), wf4(:,15), A(:,19), n3(:,35), t3x24(:,:,19), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,7), wf6(:,10), A(:,20), n3(:,36), t3x24(:,:,20), nhel, den(9))
    call Hcont_QA(nsync, wf4(:,7), wf6(:,11), A(:,21), n3(:,37), t3x24(:,:,21), nhel, den(9))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(2) ! M1helarray(2,24)
  integer :: empty(0), i

  M1(1)%j = -(A(j,3)%j*f(1))+A(j,2)%j*f(2)+A(j,1)%j*f(3)

  M2(1)%j = A(j,20)%j*f(11)-A(j,18)%j*f(12)+A(j,13)%j*f(13)+(-A(j,7)%j-A(j,9)%j)*f(14)+(A(j,5)%j+A(j,11)%j)*f(15)+A(j,14)%j*f(16)
  M2(2)%j = A(j,21)%j*f(4)-A(j,19)%j*f(5)+(-A(j,8)%j-A(j,12)%j-A(j,17)%j)*f(6)+A(j,4)%j*f(7)-A(j,10)%j*f(8)+A(j,6)%j*f(9) &
       +A(j,15)%j*f(10)+A(j,16)%j*f(17)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(2)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 2
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(11)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 12-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_ppvj_ew_uxdawx_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_ppvj_ew_uxdawx_1_/**/REALKIND
