
module ol_vamp_1_pptzjj_uxtdbxzg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptzjj_uxtdbxzg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptzjj_uxtdbxzg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptzjj_uxtdbxzg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptzjj_uxtdbxzg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pptzjj_uxtdbxzg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptzjj_uxtdbxzg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(96)
  type(Hpolcont), intent(in) :: M(4,96)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(1),h0tab(:,1),[32,8,4,1,2,16],[nMT,nMW,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,1),heltab2x96(:,:,1))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(1),n2h48(1))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(2),h0tab(:,2),[32,8,4,1,2,16],[nMB,0,0,nMW,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,2),heltab2x96(:,:,2))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(2),n2h48(2))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(3),h0tab(:,3),[32,4,1,2,16,8],[0,0,nMW,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(3),m3h2x48(:,3),heltab2x96(:,:,3))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(4),h0tab(:,4),[32,2,1,4,8,16],[nMT,0,0,nMW,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,4),heltab2x96(:,:,4))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(3))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(5),h0tab(:,5),[32,2,1,4,8,16],[nMB,nMW,0,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,5),heltab2x96(:,:,5))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(5),n2h48(4))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(6),h0tab(:,6),[32,2,1,4,16,8],[nMT,0,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,6),heltab2x96(:,:,6))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(6),n2h48(5))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(7),h0tab(:,7),[32,2,1,4,16,8],[nMT,0,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,7),heltab2x96(:,:,7))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(7),n2h48(6))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(8),h0tab(:,8),[32,4,8,2,1,16],[0,nMW,nMT,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,8),heltab2x96(:,:,8))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(8),n2h48(7))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(9),h0tab(:,9),[32,4,8,2,1,16],[0,0,nMB,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,9),heltab2x96(:,:,9))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(8))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(10),h0tab(:,10),[32,4,16,1,2,8],[0,0,0,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(10),m3h2x48(:,10),heltab2x96(:,:,10))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(11),h0tab(:,11),[32,2,1,16,4,8],[nMT,0,0,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,11),heltab2x96(:,:,11))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(11),n2h48(9))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(12),h0tab(:,12),[32,2,1,16,4,8],[nMB,nMW,0,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,12),heltab2x96(:,:,12))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(12),n2h48(10))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(13),h0tab(:,13),[32,1,2,8,4,16],[0,0,nMT,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,13),heltab2x96(:,:,13))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(13),n2h48(11))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(14),h0tab(:,14),[32,1,2,8,4,16],[0,nMW,nMB,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,14),heltab2x96(:,:,14))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(14),n2h48(12))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(15),h0tab(:,15),[32,1,2,8,16,4],[0,0,nMT,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,15),heltab2x96(:,:,15))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(15),n2h48(13))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(16),h0tab(:,16),[32,1,2,8,16,4],[0,0,nMT,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,16),heltab2x96(:,:,16))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(16),n2h48(14))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(17),h0tab(:,17),[32,1,2,16,8,4],[0,0,nMT,nMT,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,17),heltab2x96(:,:,17))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(17),n2h48(15))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(18),h0tab(:,18),[32,1,2,16,8,4],[0,nMW,nMB,nMB,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,18),heltab2x96(:,:,18))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(18),n2h48(16))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(19),h0tab(:,19),[32,8,1,4,2,16],[nMT,nMW,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,19),heltab2x96(:,:,19))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(19),n2h48(17))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(20),h0tab(:,20),[32,8,1,4,2,16],[nMB,0,0,nMW,nMB,nMB],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,20),heltab2x96(:,:,20))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(20),n2h48(18))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(21),h0tab(:,21),[32,2,4,1,8,16],[nMT,0,0,nMW,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,21),heltab2x96(:,:,21))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(21),n2h48(19))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(22),h0tab(:,22),[32,2,4,1,8,16],[nMB,nMW,0,0,nMB,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,22),heltab2x96(:,:,22))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(22),n2h48(20))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(23),h0tab(:,23),[32,2,16,4,1,8],[nMB,nMW,nMW,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,23),heltab2x96(:,:,23))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(23),n2h48(21))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(24),h0tab(:,24),[32,2,16,4,1,8],[nMB,nMW,nMW,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,24),heltab2x96(:,:,24))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(24),n2h48(22))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(25),h0tab(:,25),[32,2,16,8,1,4],[0,nMT,nMT,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(25),m3h2x48(:,25),heltab2x96(:,:,25))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(26),h0tab(:,26),[32,2,4,1,16,8],[nMT,0,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,26),heltab2x96(:,:,26))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(26),n2h48(23))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(27),h0tab(:,27),[32,2,4,1,16,8],[nMT,0,0,nMW,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,27),heltab2x96(:,:,27))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(27),n2h48(24))
Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(28),h0tab(:,28),[32,4,1,16,2,8],[0,0,nMW,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(28),m3h2x48(:,28),heltab2x96(:,:,28))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(29),h0tab(:,29),[32,4,1,16,2,8],[0,0,nMW,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,29),heltab2x96(:,:,29))
Gcoeff(:)%j = (c(11)*(M(1,:)%j-M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(30),h0tab(:,30),[32,2,8,16,1,4],[0,nMT,nMW,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(30),m3h2x48(:,30),heltab2x96(:,:,30))
Gcoeff(:)%j = (c(1)*(M(1,:)%j-M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(31),h0tab(:,31),[32,2,8,16,1,4],[0,nMT,nMW,nMW,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(31),m3h2x48(:,31),heltab2x96(:,:,31))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(32),h0tab(:,32),[32,2,16,1,4,8],[nMB,nMW,nMW,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,32),heltab2x96(:,:,32))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(32),n2h48(25))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(33),h0tab(:,33),[32,2,16,1,4,8],[nMB,nMW,nMW,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,33),heltab2x96(:,:,33))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(33),n2h48(26))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(34),h0tab(:,34),[32,1,4,2,16,8],[0,0,nMW,nMB,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(34),m3h2x48(:,34),heltab2x96(:,:,34))
Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(35),h0tab(:,35),[32,1,4,16,2,8],[0,0,nMW,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(35),m3h2x48(:,35),heltab2x96(:,:,35))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(36),h0tab(:,36),[32,1,4,16,2,8],[0,0,nMW,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(36),m3h2x48(:,36),heltab2x96(:,:,36))
Gcoeff(:)%j = (c(11)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(37),h0tab(:,37),[32,1,4,16,8,2],[0,0,nMW,nMW,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(37),m3h2x48(:,37),heltab2x96(:,:,37))
Gcoeff(:)%j = (c(1)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(38),h0tab(:,38),[32,1,4,16,8,2],[0,0,nMW,nMW,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(38),m3h2x48(:,38),heltab2x96(:,:,38))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(39),h0tab(:,39),[32,1,4,8,16,2],[0,0,nMW,nMT,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(39),m3h2x48(:,39),heltab2x96(:,:,39))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(40),h0tab(:,40),[32,4,2,8,1,16],[0,nMW,nMB,0,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,40),heltab2x96(:,:,40))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(40),n2h48(27))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(41),h0tab(:,41),[32,4,2,8,1,16],[0,0,nMT,nMW,0,0],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,41),heltab2x96(:,:,41))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(41),n2h48(28))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(42),h0tab(:,42),[32,2,4,16,1,8],[nMT,0,0,0,nMW,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,42),heltab2x96(:,:,42))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(42),n2h48(29))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(43),h0tab(:,43),[32,2,4,16,1,8],[nMB,nMW,0,0,0,nMB],6,0)
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,43),heltab2x96(:,:,43))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(43),n2h48(30))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(44),h0tab(:,44),[32,2,8,1,16,4],[0,nMT,nMW,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(44),m3h2x48(:,44),heltab2x96(:,:,44))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(45),h0tab(:,45),[32,1,8,2,4,16],[0,0,nMB,nMW,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,45),heltab2x96(:,:,45))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(45),n2h48(31))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(46),h0tab(:,46),[32,1,8,2,4,16],[0,nMW,nMT,0,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,46),heltab2x96(:,:,46))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(46),n2h48(32))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(47),h0tab(:,47),[32,1,8,16,2,4],[0,nMW,nMT,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,47),heltab2x96(:,:,47))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(47),n2h48(33))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(48),h0tab(:,48),[32,1,8,16,2,4],[0,0,nMB,nMB,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,48),heltab2x96(:,:,48))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(48),n2h48(34))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(49),h0tab(:,49),[32,1,8,2,16,4],[0,0,nMB,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,49),heltab2x96(:,:,49))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(49),n2h48(35))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(50),h0tab(:,50),[32,1,8,2,16,4],[0,0,nMB,nMW,nMW,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,50),heltab2x96(:,:,50))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(50),n2h48(36))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(51),h0tab(:,51),[32,1,16,4,2,8],[0,0,0,nMW,nMB,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(51),m3h2x48(:,51),heltab2x96(:,:,51))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(52),h0tab(:,52),[32,1,16,8,2,4],[0,nMW,nMW,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,52),heltab2x96(:,:,52))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(52),n2h48(37))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(53),h0tab(:,53),[32,1,16,8,2,4],[0,nMW,nMW,nMT,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,53),heltab2x96(:,:,53))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(53),n2h48(38))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(54),h0tab(:,54),[32,1,16,2,8,4],[0,nMW,nMW,nMB,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,54),heltab2x96(:,:,54))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(54),n2h48(39))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(55),h0tab(:,55),[32,1,16,2,8,4],[0,nMW,nMW,nMB,0,0],6,0)
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,55),heltab2x96(:,:,55))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(55),n2h48(40))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j))
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(56),h0tab(:,56),[32,1,16,4,8,2],[0,0,0,nMW,nMT,0],6,0)
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(56),m3h2x48(:,56),heltab2x96(:,:,56))
  call Hloop_QA_W(ntryL,G1H48(1),ex4(:),G1H24(1),m3h2x24(:,1),heltab2x48(:,:,1))
  call Hloop_QA_V(ntryL,G1H48(2),ex4(:),G1H24(2),m3h2x24(:,2),heltab2x48(:,:,2))
  call Hloop_VQ_A(ntryL,G1H48(3),ex3(:),G1H24(3),m3h2x24(:,3),heltab2x48(:,:,3))
  call Hloop_Q_A(ntryL,G1H24(3),36,0,G2H24(1),n2h24(1))
  call Hloop_AQ_V(ntryL,G1H48(4),ex2(:),G1H24(3),m3h2x24(:,4),heltab2x48(:,:,4))
  call Hloop_AQ_W(ntryL,G1H48(5),ex2(:),G1H24(4),m3h2x24(:,5),heltab2x48(:,:,5))
  call Hloop_AQ_V(ntryL,G1H48(6),ex2(:),G1H24(5),m3h2x24(:,6),heltab2x48(:,:,6))
  call Hloop_AQ_V(ntryL,G1H48(7),ex2(:),G1H24(6),m3h2x24(:,7),heltab2x48(:,:,7))
  call Hloop_AQ_W(ntryL,G1H48(8),ex3(:),G1H24(7),m3h2x24(:,8),heltab2x48(:,:,8))
  call Hloop_AQ_V(ntryL,G1H48(9),ex3(:),G1H24(8),m3h2x24(:,9),heltab2x48(:,:,9))
  call Hloop_VQ_A(ntryL,G1H48(10),ex3(:),G1H24(9),m3h2x24(:,10),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G1H24(9),36,0,G2H24(2),n2h24(2))
  call Hloop_AQ_V(ntryL,G1H48(11),ex2(:),G1H24(9),m3h2x24(:,11),heltab2x48(:,:,11))
  call Hloop_AQ_W(ntryL,G1H48(12),ex2(:),G1H24(10),m3h2x24(:,12),heltab2x48(:,:,12))
  call Hloop_QA_V(ntryL,G1H48(13),ex1(:),G1H24(11),m3h2x24(:,13),heltab2x48(:,:,13))
  call Hloop_QA_W(ntryL,G1H48(14),ex1(:),G1H24(12),m3h2x24(:,14),heltab2x48(:,:,14))
  call Hloop_QA_V(ntryL,G1H48(15),ex1(:),G1H24(13),m3h2x24(:,15),heltab2x48(:,:,15))
  call Hloop_QA_V(ntryL,G1H48(16),ex1(:),G1H24(14),m3h2x24(:,16),heltab2x48(:,:,16))
  call Hloop_QA_V(ntryL,G1H48(17),ex1(:),G1H24(15),m3h2x24(:,17),heltab2x48(:,:,17))
  call Hloop_QA_W(ntryL,G1H48(18),ex1(:),G1H24(16),m3h2x24(:,18),heltab2x48(:,:,18))
  call Hloop_QA_W(ntryL,G1H48(19),ex4(:),G1H24(17),m3h2x24(:,19),heltab2x48(:,:,19))
  call Hloop_QA_V(ntryL,G1H48(20),ex4(:),G1H24(18),m3h2x24(:,20),heltab2x48(:,:,20))
  call Hloop_AQ_V(ntryL,G1H48(21),ex2(:),G1H24(19),m3h2x24(:,21),heltab2x48(:,:,21))
  call Hloop_AQ_W(ntryL,G1H48(22),ex2(:),G1H24(20),m3h2x24(:,22),heltab2x48(:,:,22))
  call Hloop_AQ_S(ntryL,G1H48(23),ex2(:),G1H24(21),ngPbt,m3h2x24(:,23),heltab2x48(:,:,23))
  call Hloop_AQ_W(ntryL,G1H48(24),ex2(:),G1H24(22),m3h2x24(:,24),heltab2x48(:,:,24))
  call Hloop_VQ_A(ntryL,G1H48(25),ex2(:),G1H24(23),m3h2x24(:,25),heltab2x48(:,:,25))
  call Hloop_Q_A(ntryL,G1H24(23),34,nMT,G2H24(3),n2h24(3))
  call Hloop_AQ_V(ntryL,G1H48(26),ex2(:),G1H24(23),m3h2x24(:,26),heltab2x48(:,:,26))
  call Hloop_AQ_V(ntryL,G1H48(27),ex2(:),G1H24(24),m3h2x24(:,27),heltab2x48(:,:,27))
  call Hloop_VQ_A(ntryL,G1H48(28),ex3(:),G1H24(25),m3h2x24(:,28),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G1H24(25),36,0,G2H24(4),n2h24(4))
  call Hloop_VQ_A(ntryL,G1H48(29),ex3(:),G1H24(25),m3h2x24(:,29),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G1H24(25),36,0,G2H24(5),n2h24(5))
  call Hloop_VQ_A(ntryL,G1H48(30),ex2(:),G1H24(25),m3h2x24(:,30),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G1H24(25),34,nMT,G2H24(6),n2h24(6))
  call Hloop_VQ_A(ntryL,G1H48(31),ex2(:),G1H24(25),m3h2x24(:,31),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G1H24(25),34,nMT,G2H24(7),n2h24(7))
  call Hloop_AQ_S(ntryL,G1H48(32),ex2(:),G1H24(25),ngPbt,m3h2x24(:,32),heltab2x48(:,:,32))
  call Hloop_AQ_W(ntryL,G1H48(33),ex2(:),G1H24(26),m3h2x24(:,33),heltab2x48(:,:,33))
  call Hloop_VA_Q(ntryL,G1H48(34),ex1(:),G1H24(27),m3h2x24(:,34),heltab2x48(:,:,34))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(8),n2h24(8))
  call Hloop_VA_Q(ntryL,G1H48(35),ex1(:),G1H24(27),m3h2x24(:,35),heltab2x48(:,:,35))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(9),n2h24(9))
  call Hloop_VA_Q(ntryL,G1H48(36),ex1(:),G1H24(27),m3h2x24(:,36),heltab2x48(:,:,36))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(10),n2h24(10))
  call Hloop_VA_Q(ntryL,G1H48(37),ex1(:),G1H24(27),m3h2x24(:,37),heltab2x48(:,:,37))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(11),n2h24(11))
  call Hloop_VA_Q(ntryL,G1H48(38),ex1(:),G1H24(27),m3h2x24(:,38),heltab2x48(:,:,38))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(12),n2h24(12))
  call Hloop_VA_Q(ntryL,G1H48(39),ex1(:),G1H24(27),m3h2x24(:,39),heltab2x48(:,:,39))
  call Hloop_A_Q(ntryL,G1H24(27),33,0,G2H24(13),n2h24(13))
  call Hloop_AQ_W(ntryL,G1H48(40),ex3(:),G1H24(27),m3h2x24(:,40),heltab2x48(:,:,40))
  call Hloop_AQ_V(ntryL,G1H48(41),ex3(:),G1H24(28),m3h2x24(:,41),heltab2x48(:,:,41))
  call Hloop_AQ_V(ntryL,G1H48(42),ex2(:),G1H24(29),m3h2x24(:,42),heltab2x48(:,:,42))
  call Hloop_AQ_W(ntryL,G1H48(43),ex2(:),G1H24(30),m3h2x24(:,43),heltab2x48(:,:,43))
  call Hloop_VQ_A(ntryL,G1H48(44),ex2(:),G1H24(31),m3h2x24(:,44),heltab2x48(:,:,44))
  call Hloop_Q_A(ntryL,G1H24(31),34,nMT,G2H24(14),n2h24(14))
  call Hloop_QA_V(ntryL,G1H48(45),ex1(:),G1H24(31),m3h2x24(:,45),heltab2x48(:,:,45))
  call Hloop_QA_W(ntryL,G1H48(46),ex1(:),G1H24(32),m3h2x24(:,46),heltab2x48(:,:,46))
  call Hloop_QA_W(ntryL,G1H48(47),ex1(:),G1H24(33),m3h2x24(:,47),heltab2x48(:,:,47))
  call Hloop_QA_V(ntryL,G1H48(48),ex1(:),G1H24(34),m3h2x24(:,48),heltab2x48(:,:,48))
  call Hloop_QA_V(ntryL,G1H48(49),ex1(:),G1H24(35),m3h2x24(:,49),heltab2x48(:,:,49))
  call Hloop_QA_V(ntryL,G1H48(50),ex1(:),G1H24(36),m3h2x24(:,50),heltab2x48(:,:,50))
  call Hloop_VA_Q(ntryL,G1H48(51),ex1(:),G1H24(37),m3h2x24(:,51),heltab2x48(:,:,51))
  call Hloop_A_Q(ntryL,G1H24(37),33,0,G2H24(15),n2h24(15))
  call Hloop_QA_W(ntryL,G1H48(52),ex1(:),G1H24(37),m3h2x24(:,52),heltab2x48(:,:,52))
  call Hloop_QA_W(ntryL,G1H48(53),ex1(:),G1H24(38),m3h2x24(:,53),heltab2x48(:,:,53))
  call Hloop_QA_W(ntryL,G1H48(54),ex1(:),G1H24(39),m3h2x24(:,54),heltab2x48(:,:,54))
  call Hloop_QA_W(ntryL,G1H48(55),ex1(:),G1H24(40),m3h2x24(:,55),heltab2x48(:,:,55))
  call Hloop_VA_Q(ntryL,G1H48(56),ex1(:),G1H24(41),m3h2x24(:,56),heltab2x48(:,:,56))
  call Hloop_A_Q(ntryL,G1H24(41),33,0,G2H24(16),n2h24(16))
  call Hloop_WQ_A(ntryL,G1H24(1),ex3(:),G1H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(1),n2h12(1))
  call Hloop_VQ_A(ntryL,G1H24(2),ex3(:),G1H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_Q_A(ntryL,G1H12(1),44,0,G2H12(2),n2h12(2))
  call Hloop_QA_W(ntryL,G2H24(1),ex1(:),G2H12(3),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_VA_Q(ntryL,G1H24(3),ex1(:),G1H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(4),n2h12(3))
  call Hloop_WA_Q(ntryL,G1H24(4),ex1(:),G1H12(1),m3h2x12(:,5),heltab2x24(:,:,5))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(5),n2h12(4))
  call Hloop_VA_Q(ntryL,G1H24(5),ex1(:),G1H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(6),n2h12(5))
  call Hloop_VA_Q(ntryL,G1H24(6),ex1(:),G1H12(1),m3h2x12(:,7),heltab2x24(:,:,7))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(7),n2h12(6))
  call Hloop_WA_Q(ntryL,G1H24(7),ex4(:),G1H12(1),m3h2x12(:,8),heltab2x24(:,:,8))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMT,G2H12(8),n2h12(7))
  call Hloop_VA_Q(ntryL,G1H24(8),ex4(:),G1H12(1),m3h2x12(:,9),heltab2x24(:,:,9))
  call Hloop_A_Q(ntryL,G1H12(1),44,nMB,G2H12(9),n2h12(8))
call Hotf_5pt_reduction(G2H24(2),RedSet_5(1),mass5set(:,1),  & 
G1H24(41),G1H24(1),G1H24(2),G1H24(3),G1H24(4),G1H24(5),24)
call HG1shiftOLR(G1H24(1),8,24)
  call Hloop_VA_Q(ntryL,G1H24(9),ex1(:),G1H12(1),m3h2x12(:,10),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(10),n2h12(9))
  call Hloop_WA_Q(ntryL,G1H24(10),ex1(:),G1H12(1),m3h2x12(:,11),heltab2x24(:,:,11))
  call Hloop_A_Q(ntryL,G1H12(1),35,0,G2H12(11),n2h12(10))
  call Hloop_VQ_A(ntryL,G1H24(11),ex2(:),G1H12(1),m3h2x12(:,12),heltab2x24(:,:,12))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(12),n2h12(11))
  call Hloop_WQ_A(ntryL,G1H24(12),ex2(:),G1H12(1),m3h2x12(:,13),heltab2x24(:,:,13))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(13),n2h12(12))
  call Hloop_VQ_A(ntryL,G1H24(13),ex2(:),G1H12(1),m3h2x12(:,14),heltab2x24(:,:,14))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(14),n2h12(13))
  call Hloop_VQ_A(ntryL,G1H24(14),ex2(:),G1H12(1),m3h2x12(:,15),heltab2x24(:,:,15))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(15),n2h12(14))
  call Hloop_VQ_A(ntryL,G1H24(15),ex2(:),G1H12(1),m3h2x12(:,16),heltab2x24(:,:,16))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMT,G2H12(16),n2h12(15))
  call Hloop_WQ_A(ntryL,G1H24(16),ex2(:),G1H12(1),m3h2x12(:,17),heltab2x24(:,:,17))
  call Hloop_Q_A(ntryL,G1H12(1),35,nMB,G2H12(17),n2h12(16))
  call Hloop_WA_Q(ntryL,G1H24(17),ex1(:),G1H12(1),m3h2x12(:,18),heltab2x24(:,:,18))
  call Hloop_A_Q(ntryL,G1H12(1),41,0,G2H12(18),n2h12(17))
  call Hloop_VA_Q(ntryL,G1H24(18),ex1(:),G1H12(1),m3h2x12(:,19),heltab2x24(:,:,19))
  call Hloop_A_Q(ntryL,G1H12(1),41,0,G2H12(19),n2h12(18))
  call Hloop_VQ_A(ntryL,G1H24(19),ex3(:),G1H12(1),m3h2x12(:,20),heltab2x24(:,:,20))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(20),n2h12(19))
  call Hloop_WQ_A(ntryL,G1H24(20),ex3(:),G1H12(1),m3h2x12(:,21),heltab2x24(:,:,21))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(21),n2h12(20))
  call Hloop_SV_V(ntryL,G1H24(21),ex5(:),G1H8(1),m3h3x8(:,1),heltab2x24(:,:,22))
  call Hloop_UW_V(ntryL,G1H24(22),34,ex5(:),16,G2H8(1),m3h3x8(:,2),heltab2x24(:,:,23))
call Hotf_5pt_reduction(G2H24(3),RedSet_5(2),mass5set(:,2),  & 
G1H24(6),G1H24(7),G1H24(8),G1H24(9),G1H24(10),G1H24(11),24)
call HG1shiftOLR(G1H24(7),4,24)
  call Hloop_VQ_A(ntryL,G1H24(23),ex3(:),G1H12(1),m3h2x12(:,22),heltab2x24(:,:,24))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(22),n2h12(21))
  call Hloop_VQ_A(ntryL,G1H24(24),ex3(:),G1H12(1),m3h2x12(:,23),heltab2x24(:,:,25))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(23),n2h12(22))
  call Hloop_QA_W(ntryL,G2H24(4),ex1(:),G2H12(24),m3h2x12(:,24),heltab2x24(:,:,26))
  call Hloop_QA_W(ntryL,G2H24(5),ex1(:),G2H12(25),m3h2x12(:,25),heltab2x24(:,:,27))
  call Hloop_QA_S(ntryL,G2H24(6),ex4(:),G2H12(26),ngPbt,m3h2x12(:,26),heltab2x24(:,:,28))
  call Hloop_QA_W(ntryL,G2H24(7),ex4(:),G2H12(27),m3h2x12(:,27),heltab2x24(:,:,29))
  call Hloop_SV_V(ntryL,G1H24(25),ex5(:),G1H8(2),m3h3x8(:,3),heltab2x24(:,:,30))
  call Hloop_UW_V(ntryL,G1H24(26),34,ex5(:),16,G2H8(2),m3h3x8(:,4),heltab2x24(:,:,31))
  call Hloop_AQ_W(ntryL,G2H24(8),ex3(:),G2H12(28),m3h2x12(:,28),heltab2x24(:,:,32))
  call Hloop_AQ_W(ntryL,G2H24(9),ex3(:),G2H12(29),m3h2x12(:,29),heltab2x24(:,:,33))
  call Hloop_AQ_W(ntryL,G2H24(10),ex3(:),G2H12(30),m3h2x12(:,30),heltab2x24(:,:,34))
  call Hloop_AQ_W(ntryL,G2H24(11),ex3(:),G2H12(31),m3h2x12(:,31),heltab2x24(:,:,35))
  call Hloop_AQ_W(ntryL,G2H24(12),ex3(:),G2H12(32),m3h2x12(:,32),heltab2x24(:,:,36))
  call Hloop_AQ_W(ntryL,G2H24(13),ex3(:),G2H12(33),m3h2x12(:,33),heltab2x24(:,:,37))
  call Hloop_WQ_A(ntryL,G1H24(27),ex2(:),G1H12(1),m3h2x12(:,34),heltab2x24(:,:,38))
  call Hloop_Q_A(ntryL,G1H12(1),38,nMB,G2H12(34),n2h12(23))
  call Hloop_VQ_A(ntryL,G1H24(28),ex2(:),G1H12(1),m3h2x12(:,35),heltab2x24(:,:,39))
  call Hloop_Q_A(ntryL,G1H12(1),38,nMT,G2H12(35),n2h12(24))
  call Hloop_VQ_A(ntryL,G1H24(29),ex3(:),G1H12(1),m3h2x12(:,36),heltab2x24(:,:,40))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(36),n2h12(25))
  call Hloop_WQ_A(ntryL,G1H24(30),ex3(:),G1H12(1),m3h2x12(:,37),heltab2x24(:,:,41))
  call Hloop_Q_A(ntryL,G1H12(1),38,0,G2H12(37),n2h12(26))
  call Hloop_QA_W(ntryL,G2H24(14),ex4(:),G2H12(38),m3h2x12(:,38),heltab2x24(:,:,42))
  call Hloop_VA_Q(ntryL,G1H24(31),ex4(:),G1H12(1),m3h2x12(:,39),heltab2x24(:,:,43))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(39),n2h12(27))
  call Hloop_WA_Q(ntryL,G1H24(32),ex4(:),G1H12(1),m3h2x12(:,40),heltab2x24(:,:,44))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMT,G2H12(40),n2h12(28))
  call Hloop_WA_Q(ntryL,G1H24(33),ex4(:),G1H12(1),m3h2x12(:,41),heltab2x24(:,:,45))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMT,G2H12(41),n2h12(29))
  call Hloop_VA_Q(ntryL,G1H24(34),ex4(:),G1H12(1),m3h2x12(:,42),heltab2x24(:,:,46))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(42),n2h12(30))
  call Hloop_VA_Q(ntryL,G1H24(35),ex4(:),G1H12(1),m3h2x12(:,43),heltab2x24(:,:,47))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(43),n2h12(31))
  call Hloop_VA_Q(ntryL,G1H24(36),ex4(:),G1H12(1),m3h2x12(:,44),heltab2x24(:,:,48))
  call Hloop_A_Q(ntryL,G1H12(1),41,nMB,G2H12(44),n2h12(32))
call Hotf_5pt_reduction(G2H24(15),RedSet_5(3),mass5set(:,1),  & 
G1H24(12),G1H24(13),G1H24(14),G1H24(15),G1H24(16),G1H24(17),24)
call HG1shiftOLR(G1H24(13),8,24)
  call Hloop_VV_S(ntryL,G1H24(37),ex5(:),G1H8(3),m3h3x8(:,5),heltab2x24(:,:,49))
  call Hloop_UV_W(ntryL,G1H24(38),33,ex5(:),16,G2H8(3),m3h3x8(:,6),heltab2x24(:,:,50))
  call Hloop_VV_S(ntryL,G1H24(39),ex5(:),G1H8(4),m3h3x8(:,7),heltab2x24(:,:,51))
  call Hloop_UV_W(ntryL,G1H24(40),33,ex5(:),16,G2H8(4),m3h3x8(:,8),heltab2x24(:,:,52))
call Hotf_5pt_reduction(G2H24(16),RedSet_5(3),mass5set(:,1),  & 
G1H24(18),G1H24(19),G1H24(20),G1H24(21),G1H24(22),G1H24(23),24)
call HG1shiftOLR(G1H24(19),2,24)
  call Hloop_QZ_A(ntryL,G1H24(41),ex5(:),G1H8(5),ngZd,m3h3x8(:,9),heltab2x24(:,:,53))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(5),n2h8(1))
call HGT_raise_alpha_OLR(G1H24(1),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(1),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(1),ex4(:),G1H12(1),m3h2x12(:,45),heltab2x24(:,:,54))
  call Hloop_QZ_A(ntryL,G1H24(3),ex5(:),G1H8(5),ngZd,m3h3x8(:,10),heltab2x24(:,:,55))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(6),n2h8(2))
  call Hloop_QZ_A(ntryL,G1H24(4),ex5(:),G1H8(5),ngZd,m3h3x8(:,11),heltab2x24(:,:,56))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(7),n2h8(3))
  call Hloop_QZ_A(ntryL,G1H24(5),ex5(:),G1H8(5),ngZd,m3h3x8(:,12),heltab2x24(:,:,57))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(8),n2h8(4))
  call Hloop_QZ_A(ntryL,G1H24(6),ex5(:),G1H8(5),ngZu,m3h3x8(:,13),heltab2x24(:,:,58))
  call Hloop_Q_A(ntryL,G1H8(5),50,nMT,G2H8(9),n2h8(5))
call HGT_raise_alpha_OLR(G1H24(7),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(7),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(7),ex3(:),G1H12(2),m3h2x12(:,46),heltab2x24(:,:,59))
  call Hloop_QZ_A(ntryL,G1H24(9),ex5(:),G1H8(5),ngZu,m3h3x8(:,14),heltab2x24(:,:,60))
  call Hloop_Q_A(ntryL,G1H8(5),50,nMT,G2H8(10),n2h8(6))
  call Hloop_QZ_A(ntryL,G1H24(10),ex5(:),G1H8(5),ngZu,m3h3x8(:,15),heltab2x24(:,:,61))
  call Hloop_Q_A(ntryL,G1H8(5),50,nMT,G2H8(11),n2h8(7))
  call Hloop_QZ_A(ntryL,G1H24(11),ex5(:),G1H8(5),ngZu,m3h3x8(:,16),heltab2x24(:,:,62))
  call Hloop_Q_A(ntryL,G1H8(5),50,nMT,G2H8(12),n2h8(8))
  call Hloop_AZ_Q(ntryL,G1H24(12),ex5(:),G1H8(5),ngZu,m3h3x8(:,17),heltab2x24(:,:,63))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(13),n2h8(9))
call HGT_raise_alpha_OLR(G1H24(13),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(13),2,5,24)
  call Hloop_VA_Q(ntryL,G1H24(13),ex4(:),G1H12(3),m3h2x12(:,47),heltab2x24(:,:,64))
  call Hloop_AZ_Q(ntryL,G1H24(15),ex5(:),G1H8(5),ngZu,m3h3x8(:,18),heltab2x24(:,:,65))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(14),n2h8(10))
  call Hloop_AZ_Q(ntryL,G1H24(16),ex5(:),G1H8(5),ngZu,m3h3x8(:,19),heltab2x24(:,:,66))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(15),n2h8(11))
  call Hloop_AZ_Q(ntryL,G1H24(17),ex5(:),G1H8(5),ngZu,m3h3x8(:,20),heltab2x24(:,:,67))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(16),n2h8(12))
  call Hloop_AZ_Q(ntryL,G1H24(18),ex5(:),G1H8(5),ngZu,m3h3x8(:,21),heltab2x24(:,:,68))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(17),n2h8(13))
call HGT_raise_alpha_OLR(G1H24(19),1,1,24)
call HGT_raise_alpha_invQ_OLR(G1H24(19),2,5,24)
  call Hloop_VQ_A(ntryL,G1H24(19),ex2(:),G1H12(4),m3h2x12(:,48),heltab2x24(:,:,69))
  call Hloop_AZ_Q(ntryL,G1H24(21),ex5(:),G1H8(5),ngZu,m3h3x8(:,22),heltab2x24(:,:,70))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(18),n2h8(14))
  call Hloop_AZ_Q(ntryL,G1H24(22),ex5(:),G1H8(5),ngZu,m3h3x8(:,23),heltab2x24(:,:,71))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(19),n2h8(15))
  call Hloop_AZ_Q(ntryL,G1H24(23),ex5(:),G1H8(5),ngZu,m3h3x8(:,24),heltab2x24(:,:,72))
  call Hloop_A_Q(ntryL,G1H8(5),49,0,G2H8(20),n2h8(16))
  call ol_merge(ntryL,G2H8(1),[G1H8(1)])
  call ol_merge(ntryL,G2H8(2),[G1H8(2)])
  call Hloop_QA_V(ntryL,G2H12(1),ex1(:),G2H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_QA_W(ntryL,G2H12(2),ex1(:),G2H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
call Hotf_5pt_reduction(G2H12(3),RedSet_5(4),mass5set(:,3),  & 
G1H12(5),G1H12(6),G1H12(7),G1H12(8),G1H12(9),G1H12(10),12)
call HG1shiftOLR(G1H12(6),8,12)
  call Hloop_AQ_W(ntryL,G2H12(4),ex3(:),G2H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_AQ_V(ntryL,G2H12(5),ex3(:),G2H6(4),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_AQ_W(ntryL,G2H12(6),ex3(:),G2H6(5),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_AQ_W(ntryL,G2H12(7),ex3(:),G2H6(6),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_AQ_V(ntryL,G2H12(8),ex2(:),G2H6(7),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_AQ_W(ntryL,G2H12(9),ex2(:),G2H6(8),m3h2x6(:,8),heltab2x12(:,:,8))
call Hotf_5pt_reduction(G2H12(10),RedSet_5(5),mass5set(:,4),  & 
G1H12(11),G1H12(12),G1H12(13),G1H12(14),G1H12(15),G1H12(16),12)
call HG1shiftOLR(G1H12(12),8,12)
call Hotf_5pt_reduction(G2H12(11),RedSet_5(5),mass5set(:,5),  & 
G1H12(17),G1H12(18),G1H12(19),G1H12(20),G1H12(21),G1H12(22),12)
call HG1shiftOLR(G1H12(18),8,12)
  call Hloop_QA_W(ntryL,G2H12(12),ex4(:),G2H6(9),m3h2x6(:,9),heltab2x12(:,:,9))
  call Hloop_QA_V(ntryL,G2H12(13),ex4(:),G2H6(10),m3h2x6(:,10),heltab2x12(:,:,10))
  call Hloop_QA_S(ntryL,G2H12(14),ex4(:),G2H6(11),ngPbt,m3h2x6(:,11),heltab2x12(:,:,11))
  call Hloop_QA_W(ntryL,G2H12(15),ex4(:),G2H6(12),m3h2x6(:,12),heltab2x12(:,:,12))
call Hotf_5pt_reduction(G2H12(16),RedSet_5(6),mass5set(:,6),  & 
G1H12(23),G1H12(24),G1H12(25),G1H12(26),G1H12(27),G1H12(28),12)
call HG1shiftOLR(G1H12(24),4,12)
call Hotf_5pt_reduction(G2H12(17),RedSet_5(6),mass5set(:,7),  & 
G1H12(29),G1H12(30),G1H12(31),G1H12(32),G1H12(33),G1H12(34),12)
call HG1shiftOLR(G1H12(30),4,12)
  call Hloop_AQ_V(ntryL,G2H12(18),ex3(:),G2H6(13),m3h2x6(:,13),heltab2x12(:,:,13))
  call Hloop_AQ_W(ntryL,G2H12(19),ex3(:),G2H6(14),m3h2x6(:,14),heltab2x12(:,:,14))
  call Hloop_QA_W(ntryL,G2H12(20),ex1(:),G2H6(15),m3h2x6(:,15),heltab2x12(:,:,15))
  call Hloop_QA_V(ntryL,G2H12(21),ex1(:),G2H6(16),m3h2x6(:,16),heltab2x12(:,:,16))
call Hotf_5pt_reduction(G2H8(1),RedSet_5(7),mass5set(:,8),  & 
G1H8(5),G1H8(1),G1H8(2),G1H8(6),G1H8(7),G1H8(8),8)
call HG1shiftOLR(G1H8(1),8,8)
  call Hloop_QA_W(ntryL,G2H12(22),ex1(:),G2H6(17),m3h2x6(:,17),heltab2x12(:,:,17))
  call Hloop_QA_W(ntryL,G2H12(23),ex1(:),G2H6(18),m3h2x6(:,18),heltab2x12(:,:,18))
  call Hloop_VV_S(ntryL,G2H12(24),ex5(:),G2H4(1),m3h3x4(:,1),heltab2x12(:,:,19))
call Hotf_5pt_reduction(G2H12(25),RedSet_5(8),mass5set(:,9),  & 
G1H12(35),G1H12(36),G1H12(37),G1H12(38),G1H12(39),G1H12(40),12)
call HG1shiftOLR(G1H12(36),8,12)
  call Hloop_SV_V(ntryL,G2H12(26),ex5(:),G2H4(2),m3h3x4(:,2),heltab2x12(:,:,20))
call Hotf_5pt_reduction(G2H12(27),RedSet_5(9),mass5set(:,10),  & 
G1H12(41),G1H12(42),G1H12(43),G1H12(44),G1H12(45),G1H12(46),12)
call HG1shiftOLR(G1H12(42),4,12)
call Hotf_5pt_reduction(G2H8(2),RedSet_5(10),mass5set(:,8),  & 
G1H8(9),G1H8(10),G1H8(11),G1H8(12),G1H8(13),G1H8(14),8)
call HG1shiftOLR(G1H8(10),8,8)
call Hotf_5pt_reduction(G2H12(28),RedSet_5(11),mass5set(:,3),  & 
G1H12(47),G1H12(48),G1H12(49),G1H12(50),G1H12(51),G1H12(52),12)
call HG1shiftOLR(G1H12(48),8,12)
  call Hloop_VV_S(ntryL,G2H12(29),ex5(:),G2H4(3),m3h3x4(:,3),heltab2x12(:,:,21))
call Hotf_5pt_reduction(G2H12(30),RedSet_5(12),mass5set(:,9),  & 
G1H12(53),G1H12(54),G1H12(55),G1H12(56),G1H12(57),G1H12(58),12)
call HG1shiftOLR(G1H12(54),8,12)
  call Hloop_VV_S(ntryL,G2H12(31),ex5(:),G2H4(4),m3h3x4(:,4),heltab2x12(:,:,22))
call Hotf_5pt_reduction(G2H12(32),RedSet_5(12),mass5set(:,9),  & 
G1H12(59),G1H12(60),G1H12(61),G1H12(62),G1H12(63),G1H12(64),12)
call HG1shiftOLR(G1H12(60),2,12)
call Hotf_5pt_reduction(G2H12(33),RedSet_5(13),mass5set(:,11),  & 
G1H12(65),G1H12(66),G1H12(67),G1H12(68),G1H12(69),G1H12(70),12)
call HG1shiftOLR(G1H12(66),2,12)
  call Hloop_QA_V(ntryL,G2H12(34),ex4(:),G2H6(19),m3h2x6(:,19),heltab2x12(:,:,23))
  call Hloop_QA_W(ntryL,G2H12(35),ex4(:),G2H6(20),m3h2x6(:,20),heltab2x12(:,:,24))
call Hotf_5pt_reduction(G2H12(36),RedSet_5(14),mass5set(:,4),  & 
G1H12(71),G1H12(72),G1H12(73),G1H12(74),G1H12(75),G1H12(76),12)
call HG1shiftOLR(G1H12(72),8,12)
call Hotf_5pt_reduction(G2H12(37),RedSet_5(14),mass5set(:,5),  & 
G1H12(77),G1H12(78),G1H12(79),G1H12(80),G1H12(81),G1H12(82),12)
call HG1shiftOLR(G1H12(78),8,12)
call Hotf_5pt_reduction(G2H12(38),RedSet_5(15),mass5set(:,12),  & 
G1H12(83),G1H12(84),G1H12(85),G1H12(86),G1H12(87),G1H12(88),12)
call HG1shiftOLR(G1H12(84),4,12)
  call Hloop_AQ_W(ntryL,G2H12(39),ex2(:),G2H6(21),m3h2x6(:,21),heltab2x12(:,:,25))
  call Hloop_AQ_V(ntryL,G2H12(40),ex2(:),G2H6(22),m3h2x6(:,22),heltab2x12(:,:,26))
call Hotf_5pt_reduction(G2H12(41),RedSet_5(16),mass5set(:,13),  & 
G1H12(89),G1H12(90),G1H12(91),G1H12(92),G1H12(93),G1H12(94),12)
call HG1shiftOLR(G1H12(90),4,12)
call Hotf_5pt_reduction(G2H12(42),RedSet_5(16),mass5set(:,14),  & 
G1H12(95),G1H12(96),G1H12(97),G1H12(98),G1H12(99),G1H12(100),12)
call HG1shiftOLR(G1H12(96),4,12)
  call Hloop_AQ_S(ntryL,G2H12(43),ex2(:),G2H6(23),ngPbt,m3h2x6(:,23),heltab2x12(:,:,27))
  call Hloop_AQ_W(ntryL,G2H12(44),ex2(:),G2H6(24),m3h2x6(:,24),heltab2x12(:,:,28))
  call Hloop_SA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),ngPbt,m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(5),n2h4(1))
call Hotf_5pt_reduction(G2H8(3),RedSet_5(17),mass5set(:,15),  & 
G1H8(3),G1H8(15),G1H8(16),G1H8(17),G1H8(18),G1H8(19),8)
call HG1shiftOLR(G1H8(15),4,8)
  call Hloop_SQ_A(ntryL,G1H8(4),ex2(:),G1H4(1),ngPbt,m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(6),n2h4(2))
call Hotf_5pt_reduction(G2H8(4),RedSet_5(18),mass5set(:,16),  & 
G1H8(4),G1H8(20),G1H8(21),G1H8(22),G1H8(23),G1H8(24),8)
call HG1shiftOLR(G1H8(20),4,8)
  call Hloop_QA_W(ntryL,G2H8(5),ex1(:),G2H4(7),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_QA_W(ntryL,G2H8(7),ex1(:),G2H4(8),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_QA_W(ntryL,G2H8(8),ex1(:),G2H4(9),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_QA_W(ntryL,G2H8(9),ex4(:),G2H4(10),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_QA_W(ntryL,G2H8(11),ex4(:),G2H4(11),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_QA_W(ntryL,G2H8(12),ex4(:),G2H4(12),m3h2x4(:,8),heltab2x8(:,:,8))
  call Hloop_AQ_W(ntryL,G2H8(13),ex3(:),G2H4(13),m3h2x4(:,9),heltab2x8(:,:,9))
  call Hloop_AQ_W(ntryL,G2H8(15),ex3(:),G2H4(14),m3h2x4(:,10),heltab2x8(:,:,10))
  call Hloop_AQ_W(ntryL,G2H8(16),ex3(:),G2H4(15),m3h2x4(:,11),heltab2x8(:,:,11))
  call Hloop_AQ_W(ntryL,G2H8(17),ex3(:),G2H4(16),m3h2x4(:,12),heltab2x8(:,:,12))
  call Hloop_AQ_W(ntryL,G2H8(19),ex3(:),G2H4(17),m3h2x4(:,13),heltab2x8(:,:,13))
  call Hloop_AQ_W(ntryL,G2H8(20),ex3(:),G2H4(18),m3h2x4(:,14),heltab2x8(:,:,14))
  call Hloop_WQ_A(ntryL,G1H12(5),ex2(:),G1H6(1),m3h2x6(:,25),heltab2x12(:,:,29))
  call Hloop_Q_A(ntryL,G1H6(1),39,nMB,G2H6(25),n2h6(1))
call HGT_raise_alpha_OLR(G1H12(6),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(6),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(6),ex4(:),G1H6(1),m3h2x6(:,26),heltab2x12(:,:,30))
  call Hloop_WQ_A(ntryL,G1H12(9),ex2(:),G1H6(2),m3h2x6(:,27),heltab2x12(:,:,31))
  call Hloop_Q_A(ntryL,G1H6(2),39,nMB,G2H6(26),n2h6(2))
  call Hloop_WQ_A(ntryL,G1H12(10),ex2(:),G1H6(2),m3h2x6(:,28),heltab2x12(:,:,32))
  call Hloop_Q_A(ntryL,G1H6(2),39,nMB,G2H6(27),n2h6(3))
  call Hloop_AZ_Q(ntryL,G1H12(11),ex5(:),G1H4(1),ngZu,m3h3x4(:,5),heltab2x12(:,:,33))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(19),n2h4(3))
call HGT_OLR(G1H12(12),1,1,12)
call HGT_invQ_OLR(G1H12(12),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(12),-8,nMT,G2H12(1),n2h12(34))
  call Hloop_QA_W(ntryL,G2H12(1),ex4(:),G2H6(28),m3h2x6(:,29),heltab2x12(:,:,34))
  call Hloop_AZ_Q(ntryL,G1H12(15),ex5(:),G1H4(1),ngZu,m3h3x4(:,6),heltab2x12(:,:,35))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(20),n2h4(4))
  call Hloop_AZ_Q(ntryL,G1H12(16),ex5(:),G1H4(1),ngZu,m3h3x4(:,7),heltab2x12(:,:,36))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(21),n2h4(5))
  call Hloop_AZ_Q(ntryL,G1H12(17),ex5(:),G1H4(1),ngZd,m3h3x4(:,8),heltab2x12(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(22),n2h4(6))
call HGT_OLR(G1H12(18),1,1,12)
call HGT_invQ_OLR(G1H12(18),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(18),-8,nMB,G2H12(2),n2h12(35))
  call Hloop_QA_V(ntryL,G2H12(2),ex4(:),G2H6(29),m3h2x6(:,30),heltab2x12(:,:,38))
  call Hloop_AZ_Q(ntryL,G1H12(21),ex5(:),G1H4(1),ngZd,m3h3x4(:,9),heltab2x12(:,:,39))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(23),n2h4(7))
  call Hloop_AZ_Q(ntryL,G1H12(22),ex5(:),G1H4(1),ngZd,m3h3x4(:,10),heltab2x12(:,:,40))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(24),n2h4(8))
  call Hloop_QZ_A(ntryL,G1H12(23),ex5(:),G1H4(1),ngZu,m3h3x4(:,11),heltab2x12(:,:,41))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(25),n2h4(9))
call HGT_OLR(G1H12(24),1,1,12)
call HGT_invQ_OLR(G1H12(24),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(24),-4,0,G2H12(3),n2h12(36))
  call Hloop_AQ_W(ntryL,G2H12(3),ex3(:),G2H6(30),m3h2x6(:,31),heltab2x12(:,:,42))
  call Hloop_QZ_A(ntryL,G1H12(27),ex5(:),G1H4(1),ngZu,m3h3x4(:,12),heltab2x12(:,:,43))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(26),n2h4(10))
  call Hloop_QZ_A(ntryL,G1H12(28),ex5(:),G1H4(1),ngZu,m3h3x4(:,13),heltab2x12(:,:,44))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(27),n2h4(11))
  call Hloop_QZ_A(ntryL,G1H12(29),ex5(:),G1H4(1),ngZd,m3h3x4(:,14),heltab2x12(:,:,45))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(28),n2h4(12))
call HGT_OLR(G1H12(30),1,1,12)
call HGT_invQ_OLR(G1H12(30),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(30),-4,0,G2H12(4),n2h12(37))
  call Hloop_AQ_V(ntryL,G2H12(4),ex3(:),G2H6(31),m3h2x6(:,32),heltab2x12(:,:,46))
  call Hloop_QZ_A(ntryL,G1H12(33),ex5(:),G1H4(1),ngZd,m3h3x4(:,15),heltab2x12(:,:,47))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(29),n2h4(13))
  call Hloop_QZ_A(ntryL,G1H12(34),ex5(:),G1H4(1),ngZd,m3h3x4(:,16),heltab2x12(:,:,48))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(30),n2h4(14))
  call Hloop_WQ_A(ntryL,G1H8(5),ex3(:),G1H4(1),m3h2x4(:,15),heltab2x8(:,:,15))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(31),n2h4(15))
call HGT_OLR(G1H8(1),1,1,8)
call HGT_invQ_OLR(G1H8(1),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(1),-8,nMB,G2H8(1),n2h8(17))
  call Hloop_QA_V(ntryL,G2H8(1),ex4(:),G2H4(32),m3h2x4(:,16),heltab2x8(:,:,16))
  call Hloop_WQ_A(ntryL,G1H8(7),ex3(:),G1H4(1),m3h2x4(:,17),heltab2x8(:,:,17))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(33),n2h4(16))
  call Hloop_WQ_A(ntryL,G1H8(8),ex3(:),G1H4(1),m3h2x4(:,18),heltab2x8(:,:,18))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(34),n2h4(17))
  call Hloop_UV_W(ntryL,G1H12(35),37,ex5(:),16,G2H4(35),m3h3x4(:,17),heltab2x12(:,:,49))
call HGT_raise_alpha_OLR(G1H12(36),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(36),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(36),ex4(:),G1H6(2),m3h2x6(:,33),heltab2x12(:,:,50))
  call Hloop_UV_W(ntryL,G1H12(39),37,ex5(:),16,G2H4(36),m3h3x4(:,18),heltab2x12(:,:,51))
  call Hloop_UV_W(ntryL,G1H12(40),37,ex5(:),16,G2H4(37),m3h3x4(:,19),heltab2x12(:,:,52))
  call Hloop_UW_V(ntryL,G1H12(41),42,ex5(:),16,G2H4(38),m3h3x4(:,20),heltab2x12(:,:,53))
call HGT_raise_alpha_OLR(G1H12(42),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(42),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(42),ex3(:),G1H6(3),m3h2x6(:,34),heltab2x12(:,:,54))
  call Hloop_UW_V(ntryL,G1H12(45),42,ex5(:),16,G2H4(39),m3h3x4(:,21),heltab2x12(:,:,55))
  call Hloop_UW_V(ntryL,G1H12(46),42,ex5(:),16,G2H4(40),m3h3x4(:,22),heltab2x12(:,:,56))
  call Hloop_WA_Q(ntryL,G1H8(9),ex1(:),G1H4(1),m3h2x4(:,19),heltab2x8(:,:,19))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(41),n2h4(18))
call HGT_OLR(G1H8(10),1,1,8)
call HGT_invQ_OLR(G1H8(10),2,5,8)
  call Hloop_Q_A(ntryL,G1H8(10),-8,nMB,G2H8(2),n2h8(18))
  call Hloop_QA_V(ntryL,G2H8(2),ex4(:),G2H4(42),m3h2x4(:,20),heltab2x8(:,:,20))
  call Hloop_WA_Q(ntryL,G1H8(13),ex1(:),G1H4(1),m3h2x4(:,21),heltab2x8(:,:,21))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(43),n2h4(19))
  call Hloop_WA_Q(ntryL,G1H8(14),ex1(:),G1H4(1),m3h2x4(:,22),heltab2x8(:,:,22))
  call Hloop_A_Q(ntryL,G1H4(1),51,0,G2H4(44),n2h4(20))
  call Hloop_WQ_A(ntryL,G1H12(47),ex2(:),G1H6(4),m3h2x6(:,35),heltab2x12(:,:,57))
  call Hloop_Q_A(ntryL,G1H6(4),39,nMB,G2H6(32),n2h6(4))
call HGT_raise_alpha_OLR(G1H12(48),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(48),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(48),ex4(:),G1H6(4),m3h2x6(:,36),heltab2x12(:,:,58))
  call Hloop_WQ_A(ntryL,G1H12(51),ex2(:),G1H6(5),m3h2x6(:,37),heltab2x12(:,:,59))
  call Hloop_Q_A(ntryL,G1H6(5),39,nMB,G2H6(33),n2h6(5))
  call Hloop_WQ_A(ntryL,G1H12(52),ex2(:),G1H6(5),m3h2x6(:,38),heltab2x12(:,:,60))
  call Hloop_Q_A(ntryL,G1H6(5),39,nMB,G2H6(34),n2h6(6))
  call Hloop_UV_W(ntryL,G1H12(53),37,ex5(:),16,G2H4(45),m3h3x4(:,23),heltab2x12(:,:,61))
call HGT_raise_alpha_OLR(G1H12(54),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(54),2,5,12)
  call Hloop_VA_Q(ntryL,G1H12(54),ex4(:),G1H6(5),m3h2x6(:,39),heltab2x12(:,:,62))
  call Hloop_UV_W(ntryL,G1H12(57),37,ex5(:),16,G2H4(46),m3h3x4(:,24),heltab2x12(:,:,63))
  call Hloop_UV_W(ntryL,G1H12(58),37,ex5(:),16,G2H4(47),m3h3x4(:,25),heltab2x12(:,:,64))
  call Hloop_UV_W(ntryL,G1H12(59),37,ex5(:),16,G2H4(48),m3h3x4(:,26),heltab2x12(:,:,65))
call HGT_raise_alpha_OLR(G1H12(60),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(60),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(60),ex2(:),G1H6(6),m3h2x6(:,40),heltab2x12(:,:,66))
  call Hloop_UV_W(ntryL,G1H12(63),37,ex5(:),16,G2H4(49),m3h3x4(:,27),heltab2x12(:,:,67))
  call Hloop_UV_W(ntryL,G1H12(64),37,ex5(:),16,G2H4(50),m3h3x4(:,28),heltab2x12(:,:,68))
  call Hloop_WA_Q(ntryL,G1H12(65),ex4(:),G1H6(7),m3h2x6(:,41),heltab2x12(:,:,69))
  call Hloop_A_Q(ntryL,G1H6(7),45,nMT,G2H6(35),n2h6(7))
call HGT_raise_alpha_OLR(G1H12(66),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(66),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(66),ex2(:),G1H6(7),m3h2x6(:,42),heltab2x12(:,:,70))
  call Hloop_WA_Q(ntryL,G1H12(69),ex4(:),G1H6(8),m3h2x6(:,43),heltab2x12(:,:,71))
  call Hloop_A_Q(ntryL,G1H6(8),45,nMT,G2H6(36),n2h6(8))
  call Hloop_WA_Q(ntryL,G1H12(70),ex4(:),G1H6(8),m3h2x6(:,44),heltab2x12(:,:,72))
  call Hloop_A_Q(ntryL,G1H6(8),45,nMT,G2H6(37),n2h6(9))
  call Hloop_QZ_A(ntryL,G1H12(71),ex5(:),G1H4(1),ngZd,m3h3x4(:,29),heltab2x12(:,:,73))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(51),n2h4(21))
call HGT_OLR(G1H12(72),1,1,12)
call HGT_invQ_OLR(G1H12(72),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(72),-8,nMT,G2H12(5),n2h12(44))
  call Hloop_QA_W(ntryL,G2H12(5),ex4(:),G2H6(38),m3h2x6(:,45),heltab2x12(:,:,74))
  call Hloop_QZ_A(ntryL,G1H12(75),ex5(:),G1H4(1),ngZd,m3h3x4(:,30),heltab2x12(:,:,75))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(52),n2h4(22))
  call Hloop_QZ_A(ntryL,G1H12(76),ex5(:),G1H4(1),ngZd,m3h3x4(:,31),heltab2x12(:,:,76))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(53),n2h4(23))
  call Hloop_QZ_A(ntryL,G1H12(77),ex5(:),G1H4(1),ngZu,m3h3x4(:,32),heltab2x12(:,:,77))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(54),n2h4(24))
call HGT_OLR(G1H12(78),1,1,12)
call HGT_invQ_OLR(G1H12(78),2,5,12)
  call Hloop_Q_A(ntryL,G1H12(78),-8,nMB,G2H12(6),n2h12(45))
  call Hloop_QA_V(ntryL,G2H12(6),ex4(:),G2H6(39),m3h2x6(:,46),heltab2x12(:,:,78))
  call Hloop_QZ_A(ntryL,G1H12(81),ex5(:),G1H4(1),ngZu,m3h3x4(:,33),heltab2x12(:,:,79))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(55),n2h4(25))
  call Hloop_QZ_A(ntryL,G1H12(82),ex5(:),G1H4(1),ngZu,m3h3x4(:,34),heltab2x12(:,:,80))
  call Hloop_Q_A(ntryL,G1H4(1),54,0,G2H4(56),n2h4(26))
  call Hloop_WA_Q(ntryL,G1H12(83),ex1(:),G1H6(8),m3h2x6(:,47),heltab2x12(:,:,81))
  call Hloop_A_Q(ntryL,G1H6(8),43,0,G2H6(40),n2h6(10))
call HGT_raise_alpha_OLR(G1H12(84),1,1,12)
call HGT_raise_alpha_invQ_OLR(G1H12(84),2,5,12)
  call Hloop_VQ_A(ntryL,G1H12(84),ex3(:),G1H6(8),m3h2x6(:,48),heltab2x12(:,:,82))
  call Hloop_WA_Q(ntryL,G1H12(87),ex1(:),G1H6(9),m3h2x6(:,49),heltab2x12(:,:,83))
  call Hloop_A_Q(ntryL,G1H6(9),43,0,G2H6(41),n2h6(11))
  call Hloop_WA_Q(ntryL,G1H12(88),ex1(:),G1H6(9),m3h2x6(:,50),heltab2x12(:,:,84))
  call Hloop_A_Q(ntryL,G1H6(9),43,0,G2H6(42),n2h6(12))
  call Hloop_AZ_Q(ntryL,G1H12(89),ex5(:),G1H4(1),ngZu,m3h3x4(:,35),heltab2x12(:,:,85))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(57),n2h4(27))
call HGT_OLR(G1H12(90),1,1,12)
call HGT_invQ_OLR(G1H12(90),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(90),-4,0,G2H12(7),n2h12(47))
  call Hloop_AQ_V(ntryL,G2H12(7),ex3(:),G2H6(43),m3h2x6(:,51),heltab2x12(:,:,86))
  call Hloop_AZ_Q(ntryL,G1H12(93),ex5(:),G1H4(1),ngZu,m3h3x4(:,36),heltab2x12(:,:,87))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(58),n2h4(28))
  call Hloop_AZ_Q(ntryL,G1H12(94),ex5(:),G1H4(1),ngZu,m3h3x4(:,37),heltab2x12(:,:,88))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(59),n2h4(29))
  call Hloop_AZ_Q(ntryL,G1H12(95),ex5(:),G1H4(1),ngZd,m3h3x4(:,38),heltab2x12(:,:,89))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(60),n2h4(30))
call HGT_OLR(G1H12(96),1,1,12)
call HGT_invQ_OLR(G1H12(96),2,5,12)
  call Hloop_A_Q(ntryL,G1H12(96),-4,0,G2H12(8),n2h12(48))
  call Hloop_AQ_W(ntryL,G2H12(8),ex3(:),G2H6(44),m3h2x6(:,52),heltab2x12(:,:,90))
  call Hloop_AZ_Q(ntryL,G1H12(99),ex5(:),G1H4(1),ngZd,m3h3x4(:,39),heltab2x12(:,:,91))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(61),n2h4(31))
  call Hloop_AZ_Q(ntryL,G1H12(100),ex5(:),G1H4(1),ngZd,m3h3x4(:,40),heltab2x12(:,:,92))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMB,G2H4(62),n2h4(32))
  call Hloop_WA_Q(ntryL,G1H8(3),ex4(:),G1H4(1),m3h2x4(:,23),heltab2x8(:,:,23))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(63),n2h4(33))
call HGT_OLR(G1H8(15),1,1,8)
call HGT_invQ_OLR(G1H8(15),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(15),-4,0,G2H8(3),n2h8(19))
  call Hloop_AQ_V(ntryL,G2H8(3),ex3(:),G2H4(64),m3h2x4(:,24),heltab2x8(:,:,24))
  call Hloop_WA_Q(ntryL,G1H8(18),ex4(:),G1H4(1),m3h2x4(:,25),heltab2x8(:,:,25))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(65),n2h4(34))
  call Hloop_WA_Q(ntryL,G1H8(19),ex4(:),G1H4(1),m3h2x4(:,26),heltab2x8(:,:,26))
  call Hloop_A_Q(ntryL,G1H4(1),57,nMT,G2H4(66),n2h4(35))
  call Hloop_WQ_A(ntryL,G1H8(4),ex2(:),G1H4(1),m3h2x4(:,27),heltab2x8(:,:,27))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(67),n2h4(36))
call HGT_OLR(G1H8(20),1,1,8)
call HGT_invQ_OLR(G1H8(20),2,5,8)
  call Hloop_A_Q(ntryL,G1H8(20),-4,0,G2H8(4),n2h8(20))
  call Hloop_AQ_V(ntryL,G2H8(4),ex3(:),G2H4(68),m3h2x4(:,28),heltab2x8(:,:,28))
  call Hloop_WQ_A(ntryL,G1H8(23),ex2(:),G1H4(1),m3h2x4(:,29),heltab2x8(:,:,29))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(69),n2h4(37))
  call Hloop_WQ_A(ntryL,G1H8(24),ex2(:),G1H4(1),m3h2x4(:,30),heltab2x8(:,:,30))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMB,G2H4(70),n2h4(38))
  call ol_merge(ntryL,G2H4(38),[G2H4(2)])
  call ol_merge(ntryL,G2H4(63),[G2H4(5)])
  call ol_merge(ntryL,G2H4(67),[G2H4(6)])
call Hotf_5pt_reduction(G2H6(1),RedSet_5(19),mass5set(:,17),  & 
G1H6(9),G1H6(10),G1H6(11),G1H6(12),G1H6(13),G1H6(14),6)
call HG1shiftOLR(G1H6(10),16,6)
call Hotf_5pt_reduction(G2H6(2),RedSet_5(19),mass5set(:,18),  & 
G1H6(15),G1H6(16),G1H6(17),G1H6(18),G1H6(19),G1H6(20),6)
call HG1shiftOLR(G1H6(16),16,6)
call Hotf_5pt_reduction(G2H6(3),RedSet_5(20),mass5set(:,19),  & 
G1H6(21),G1H6(22),G1H6(23),G1H6(24),G1H6(25),G1H6(26),6)
call HG1shiftOLR(G1H6(22),16,6)
call Hotf_5pt_reduction(G2H6(4),RedSet_5(20),mass5set(:,5),  & 
G1H6(27),G1H6(28),G1H6(29),G1H6(30),G1H6(31),G1H6(32),6)
call HG1shiftOLR(G1H6(28),16,6)
  call Hloop_VV_S(ntryL,G2H6(5),ex5(:),G2H2(1),m3h3x2(:,1),heltab2x6(:,:,1))
call Hotf_5pt_reduction(G2H6(6),RedSet_5(20),mass5set(:,19),  & 
G1H6(33),G1H6(34),G1H6(35),G1H6(36),G1H6(37),G1H6(38),6)
call HG1shiftOLR(G1H6(34),8,6)
call Hotf_5pt_reduction(G2H6(7),RedSet_5(21),mass5set(:,20),  & 
G1H6(39),G1H6(40),G1H6(41),G1H6(42),G1H6(43),G1H6(44),6)
call HG1shiftOLR(G1H6(40),16,6)
call Hotf_5pt_reduction(G2H6(8),RedSet_5(21),mass5set(:,21),  & 
G1H6(45),G1H6(46),G1H6(47),G1H6(48),G1H6(49),G1H6(50),6)
call HG1shiftOLR(G1H6(46),16,6)
call Hotf_5pt_reduction(G2H6(9),RedSet_5(22),mass5set(:,22),  & 
G1H6(51),G1H6(52),G1H6(53),G1H6(54),G1H6(55),G1H6(56),6)
call HG1shiftOLR(G1H6(52),16,6)
call Hotf_5pt_reduction(G2H6(10),RedSet_5(22),mass5set(:,23),  & 
G1H6(57),G1H6(58),G1H6(59),G1H6(60),G1H6(61),G1H6(62),6)
call HG1shiftOLR(G1H6(58),16,6)
  call Hloop_SV_V(ntryL,G2H6(11),ex5(:),G2H2(2),m3h3x2(:,2),heltab2x6(:,:,2))
call Hotf_5pt_reduction(G2H6(12),RedSet_5(22),mass5set(:,22),  & 
G1H6(63),G1H6(64),G1H6(65),G1H6(66),G1H6(67),G1H6(68),6)
call HG1shiftOLR(G1H6(64),4,6)
call Hotf_5pt_reduction(G2H6(13),RedSet_5(23),mass5set(:,17),  & 
G1H6(69),G1H6(70),G1H6(71),G1H6(72),G1H6(73),G1H6(74),6)
call HG1shiftOLR(G1H6(70),16,6)
call Hotf_5pt_reduction(G2H6(14),RedSet_5(23),mass5set(:,18),  & 
G1H6(75),G1H6(76),G1H6(77),G1H6(78),G1H6(79),G1H6(80),6)
call HG1shiftOLR(G1H6(76),16,6)
call Hotf_5pt_reduction(G2H6(15),RedSet_5(24),mass5set(:,19),  & 
G1H6(81),G1H6(82),G1H6(83),G1H6(84),G1H6(85),G1H6(86),6)
call HG1shiftOLR(G1H6(82),16,6)
call Hotf_5pt_reduction(G2H6(16),RedSet_5(24),mass5set(:,5),  & 
G1H6(87),G1H6(88),G1H6(89),G1H6(90),G1H6(91),G1H6(92),6)
call HG1shiftOLR(G1H6(88),16,6)
  call Hloop_VV_S(ntryL,G2H6(17),ex5(:),G2H2(3),m3h3x2(:,3),heltab2x6(:,:,3))
call Hotf_5pt_reduction(G2H6(18),RedSet_5(24),mass5set(:,19),  & 
G1H6(93),G1H6(94),G1H6(95),G1H6(96),G1H6(97),G1H6(98),6)
call HG1shiftOLR(G1H6(94),8,6)
call Hotf_5pt_reduction(G2H4(1),RedSet_5(8),mass5set(:,9),  & 
G1H4(1),G1H4(2),G1H4(3),G1H4(4),G1H4(5),G1H4(6),4)
call HG1shiftOLR(G1H4(2),8,4)
call Hotf_5pt_reduction(G2H4(38),RedSet_5(9),mass5set(:,10),  & 
G1H4(7),G1H4(8),G1H4(9),G1H4(10),G1H4(11),G1H4(12),4)
call HG1shiftOLR(G1H4(8),4,4)
call Hotf_5pt_reduction(G2H4(3),RedSet_5(12),mass5set(:,9),  & 
G1H4(13),G1H4(14),G1H4(15),G1H4(16),G1H4(17),G1H4(18),4)
call HG1shiftOLR(G1H4(14),8,4)
call Hotf_5pt_reduction(G2H4(4),RedSet_5(12),mass5set(:,9),  & 
G1H4(19),G1H4(20),G1H4(21),G1H4(22),G1H4(23),G1H4(24),4)
call HG1shiftOLR(G1H4(20),2,4)
call Hotf_5pt_reduction(G2H6(19),RedSet_5(25),mass5set(:,23),  & 
G1H6(99),G1H6(100),G1H6(101),G1H6(102),G1H6(103),G1H6(104),6)
call HG1shiftOLR(G1H6(100),16,6)
call Hotf_5pt_reduction(G2H6(20),RedSet_5(25),mass5set(:,22),  & 
G1H6(105),G1H6(106),G1H6(107),G1H6(108),G1H6(109),G1H6(110),6)
call HG1shiftOLR(G1H6(106),16,6)
call Hotf_5pt_reduction(G2H6(21),RedSet_5(26),mass5set(:,21),  & 
G1H6(111),G1H6(112),G1H6(113),G1H6(114),G1H6(115),G1H6(116),6)
call HG1shiftOLR(G1H6(112),16,6)
call Hotf_5pt_reduction(G2H6(22),RedSet_5(26),mass5set(:,20),  & 
G1H6(117),G1H6(118),G1H6(119),G1H6(120),G1H6(121),G1H6(122),6)
call HG1shiftOLR(G1H6(118),16,6)
  call Hloop_SV_V(ntryL,G2H6(23),ex5(:),G2H2(4),m3h3x2(:,4),heltab2x6(:,:,4))
call Hotf_5pt_reduction(G2H6(24),RedSet_5(26),mass5set(:,21),  & 
G1H6(123),G1H6(124),G1H6(125),G1H6(126),G1H6(127),G1H6(128),6)
call HG1shiftOLR(G1H6(124),4,6)
  call Hloop_AQ_V(ntryL,G2H4(63),ex2(:),G2H2(5),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_QA_V(ntryL,G2H4(67),ex4(:),G2H2(6),m3h2x2(:,2),heltab2x4(:,:,2))
call Hotf_5pt_reduction(G2H4(7),RedSet_5(1),mass5set(:,1),  & 
G1H4(25),G1H4(26),G1H4(27),G1H4(28),G1H4(29),G1H4(30),4)
call HG1shiftOLR(G1H4(26),8,4)
call Hotf_5pt_reduction(G2H4(9),RedSet_5(27),mass5set(:,24),  & 
G1H4(31),G1H4(32),G1H4(33),G1H4(34),G1H4(35),G1H4(36),4)
call HG1shiftOLR(G1H4(32),8,4)
call Hotf_5pt_reduction(G2H4(10),RedSet_5(2),mass5set(:,2),  & 
G1H4(37),G1H4(38),G1H4(39),G1H4(40),G1H4(41),G1H4(42),4)
call HG1shiftOLR(G1H4(38),4,4)
call Hotf_5pt_reduction(G2H4(12),RedSet_5(28),mass5set(:,25),  & 
G1H4(43),G1H4(44),G1H4(45),G1H4(46),G1H4(47),G1H4(48),4)
call HG1shiftOLR(G1H4(44),4,4)
call Hotf_5pt_reduction(G2H4(13),RedSet_5(3),mass5set(:,1),  & 
G1H4(49),G1H4(50),G1H4(51),G1H4(52),G1H4(53),G1H4(54),4)
call HG1shiftOLR(G1H4(50),8,4)
call Hotf_5pt_reduction(G2H4(15),RedSet_5(29),mass5set(:,24),  & 
G1H4(55),G1H4(56),G1H4(57),G1H4(58),G1H4(59),G1H4(60),4)
call HG1shiftOLR(G1H4(56),8,4)
call Hotf_5pt_reduction(G2H4(16),RedSet_5(3),mass5set(:,1),  & 
G1H4(61),G1H4(62),G1H4(63),G1H4(64),G1H4(65),G1H4(66),4)
call HG1shiftOLR(G1H4(62),2,4)
call Hotf_5pt_reduction(G2H4(18),RedSet_5(30),mass5set(:,26),  & 
G1H4(67),G1H4(68),G1H4(69),G1H4(70),G1H4(71),G1H4(72),4)
call HG1shiftOLR(G1H4(68),2,4)
call Hotf_5pt_reduction(G2H6(25),RedSet_5(4),mass5set(:,3),  & 
G1H6(129),G1H6(130),G1H6(131),G1H6(132),G1H6(133),G1H6(134),6)
call HG1shiftOLR(G1H6(130),8,6)
call Hotf_5pt_reduction(G2H6(27),RedSet_5(31),mass5set(:,3),  & 
G1H6(135),G1H6(136),G1H6(137),G1H6(138),G1H6(139),G1H6(140),6)
call HG1shiftOLR(G1H6(136),8,6)
  call Hloop_AQ_W(ntryL,G2H4(19),ex3(:),G2H2(7),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_AQ_W(ntryL,G2H4(21),ex3(:),G2H2(8),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_AQ_V(ntryL,G2H4(22),ex3(:),G2H2(9),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_AQ_V(ntryL,G2H4(24),ex3(:),G2H2(10),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_QA_W(ntryL,G2H4(25),ex4(:),G2H2(11),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_QA_W(ntryL,G2H4(27),ex4(:),G2H2(12),m3h2x2(:,8),heltab2x4(:,:,8))
  call Hloop_QA_V(ntryL,G2H4(28),ex4(:),G2H2(13),m3h2x2(:,9),heltab2x4(:,:,9))
  call Hloop_QA_V(ntryL,G2H4(30),ex4(:),G2H2(14),m3h2x2(:,10),heltab2x4(:,:,10))
  call Hloop_QA_V(ntryL,G2H4(31),ex1(:),G2H2(15),m3h2x2(:,11),heltab2x4(:,:,11))
  call Hloop_QA_V(ntryL,G2H4(34),ex1(:),G2H2(16),m3h2x2(:,12),heltab2x4(:,:,12))
call Hotf_5pt_reduction(G2H4(35),RedSet_5(8),mass5set(:,9),  & 
G1H4(73),G1H4(74),G1H4(75),G1H4(76),G1H4(77),G1H4(78),4)
call HG1shiftOLR(G1H4(74),8,4)
call Hotf_5pt_reduction(G2H4(37),RedSet_5(31),mass5set(:,3),  & 
G1H4(79),G1H4(80),G1H4(81),G1H4(82),G1H4(83),G1H4(84),4)
call HG1shiftOLR(G1H4(80),8,4)
call Hotf_5pt_reduction(G2H4(40),RedSet_5(32),mass5set(:,12),  & 
G1H4(85),G1H4(86),G1H4(87),G1H4(88),G1H4(89),G1H4(90),4)
call HG1shiftOLR(G1H4(86),4,4)
  call Hloop_AQ_V(ntryL,G2H4(41),ex3(:),G2H2(17),m3h2x2(:,13),heltab2x4(:,:,13))
  call Hloop_AQ_V(ntryL,G2H4(44),ex3(:),G2H2(18),m3h2x2(:,14),heltab2x4(:,:,14))
call Hotf_5pt_reduction(G2H6(32),RedSet_5(11),mass5set(:,3),  & 
G1H6(141),G1H6(142),G1H6(143),G1H6(144),G1H6(145),G1H6(146),6)
call HG1shiftOLR(G1H6(142),8,6)
call Hotf_5pt_reduction(G2H6(34),RedSet_5(33),mass5set(:,3),  & 
G1H6(147),G1H6(148),G1H6(149),G1H6(150),G1H6(151),G1H6(152),6)
call HG1shiftOLR(G1H6(148),8,6)
call Hotf_5pt_reduction(G2H4(45),RedSet_5(12),mass5set(:,9),  & 
G1H4(91),G1H4(92),G1H4(93),G1H4(94),G1H4(95),G1H4(96),4)
call HG1shiftOLR(G1H4(92),8,4)
call Hotf_5pt_reduction(G2H4(47),RedSet_5(33),mass5set(:,3),  & 
G1H4(97),G1H4(98),G1H4(99),G1H4(100),G1H4(101),G1H4(102),4)
call HG1shiftOLR(G1H4(98),8,4)
call Hotf_5pt_reduction(G2H4(48),RedSet_5(12),mass5set(:,9),  & 
G1H4(103),G1H4(104),G1H4(105),G1H4(106),G1H4(107),G1H4(108),4)
call HG1shiftOLR(G1H4(104),2,4)
call Hotf_5pt_reduction(G2H4(50),RedSet_5(34),mass5set(:,11),  & 
G1H4(109),G1H4(110),G1H4(111),G1H4(112),G1H4(113),G1H4(114),4)
call HG1shiftOLR(G1H4(110),2,4)
call Hotf_5pt_reduction(G2H6(35),RedSet_5(13),mass5set(:,11),  & 
G1H6(153),G1H6(154),G1H6(155),G1H6(156),G1H6(157),G1H6(158),6)
call HG1shiftOLR(G1H6(154),2,6)
call Hotf_5pt_reduction(G2H6(37),RedSet_5(34),mass5set(:,11),  & 
G1H6(159),G1H6(160),G1H6(161),G1H6(162),G1H6(163),G1H6(164),6)
call HG1shiftOLR(G1H6(160),2,6)
  call Hloop_QA_W(ntryL,G2H4(51),ex1(:),G2H2(19),m3h2x2(:,15),heltab2x4(:,:,15))
  call Hloop_QA_W(ntryL,G2H4(53),ex1(:),G2H2(20),m3h2x2(:,16),heltab2x4(:,:,16))
  call Hloop_QA_V(ntryL,G2H4(54),ex1(:),G2H2(21),m3h2x2(:,17),heltab2x4(:,:,17))
  call Hloop_QA_V(ntryL,G2H4(56),ex1(:),G2H2(22),m3h2x2(:,18),heltab2x4(:,:,18))
call Hotf_5pt_reduction(G2H6(40),RedSet_5(15),mass5set(:,12),  & 
G1H6(165),G1H6(166),G1H6(167),G1H6(168),G1H6(169),G1H6(170),6)
call HG1shiftOLR(G1H6(166),4,6)
call Hotf_5pt_reduction(G2H6(42),RedSet_5(32),mass5set(:,12),  & 
G1H6(171),G1H6(172),G1H6(173),G1H6(174),G1H6(175),G1H6(176),6)
call HG1shiftOLR(G1H6(172),4,6)
  call Hloop_AQ_V(ntryL,G2H4(57),ex2(:),G2H2(23),m3h2x2(:,19),heltab2x4(:,:,19))
  call Hloop_AQ_V(ntryL,G2H4(59),ex2(:),G2H2(24),m3h2x2(:,20),heltab2x4(:,:,20))
  call Hloop_AQ_W(ntryL,G2H4(60),ex2(:),G2H2(25),m3h2x2(:,21),heltab2x4(:,:,21))
  call Hloop_AQ_W(ntryL,G2H4(62),ex2(:),G2H2(26),m3h2x2(:,22),heltab2x4(:,:,22))
  call Hloop_AQ_V(ntryL,G2H4(66),ex2(:),G2H2(27),m3h2x2(:,23),heltab2x4(:,:,23))
  call Hloop_QA_V(ntryL,G2H4(70),ex4(:),G2H2(28),m3h2x2(:,24),heltab2x4(:,:,24))
  call ol_merge(ntryL,G1H4(85),[G1H4(12)])
  call ol_merge(ntryL,G1H4(31),[G1H4(30)])
  call ol_merge(ntryL,G1H4(43),[G1H4(42)])
  call ol_merge(ntryL,G1H4(55),[G1H4(54)])
  call ol_merge(ntryL,G1H4(67),[G1H4(66)])
  call ol_merge(ntryL,G1H6(135),[G1H6(134)])
  call ol_merge(ntryL,G1H4(79),[G1H4(78)])
  call ol_merge(ntryL,G1H6(147),[G1H6(146)])
  call ol_merge(ntryL,G1H4(97),[G1H4(96)])
  call ol_merge(ntryL,G1H4(109),[G1H4(108)])
  call ol_merge(ntryL,G1H6(159),[G1H6(158)])
  call ol_merge(ntryL,G1H6(171),[G1H6(170)])
  call Hloop_VQ_A(ntryL,G1H6(9),ex2(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(1),n2h3(1))
call HGT_OLR(G1H6(10),1,1,6)
call HGT_invQ_OLR(G1H6(10),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(10),-16,nMT,G2H6(1),n2h6(13))
  call Hloop_AZ_Q(ntryL,G2H6(1),ex5(:),G2H2(29),ngZu,m3h3x2(:,5),heltab2x6(:,:,6))
  call Hloop_VQ_A(ntryL,G1H6(14),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(2),n2h3(2))
  call Hloop_WQ_A(ntryL,G1H6(15),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,8))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(3),n2h3(3))
call HGT_OLR(G1H6(16),1,1,6)
call HGT_invQ_OLR(G1H6(16),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(16),-16,nMB,G2H6(2),n2h6(14))
  call Hloop_AZ_Q(ntryL,G2H6(2),ex5(:),G2H2(30),ngZd,m3h3x2(:,6),heltab2x6(:,:,9))
  call Hloop_WQ_A(ntryL,G1H6(20),ex2(:),G1H3(1),m3h2x3(:,4),heltab2x6(:,:,10))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(4),n2h3(4))
  call Hloop_WA_Q(ntryL,G1H6(21),ex4(:),G1H3(1),m3h2x3(:,5),heltab2x6(:,:,11))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(5),n2h3(5))
call HGT_OLR(G1H6(22),1,1,6)
call HGT_invQ_OLR(G1H6(22),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(22),-16,nMT,G2H6(3),n2h6(15))
  call Hloop_QZ_A(ntryL,G2H6(3),ex5(:),G2H2(31),ngZu,m3h3x2(:,7),heltab2x6(:,:,12))
  call Hloop_WA_Q(ntryL,G1H6(26),ex4(:),G1H3(1),m3h2x3(:,6),heltab2x6(:,:,13))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(6),n2h3(6))
  call Hloop_VA_Q(ntryL,G1H6(27),ex4(:),G1H3(1),m3h2x3(:,7),heltab2x6(:,:,14))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(7),n2h3(7))
call HGT_OLR(G1H6(28),1,1,6)
call HGT_invQ_OLR(G1H6(28),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(28),-16,nMB,G2H6(4),n2h6(16))
  call Hloop_QZ_A(ntryL,G2H6(4),ex5(:),G2H2(32),ngZd,m3h3x2(:,8),heltab2x6(:,:,15))
  call Hloop_VA_Q(ntryL,G1H6(32),ex4(:),G1H3(1),m3h2x3(:,8),heltab2x6(:,:,16))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(8),n2h3(8))
  call Hloop_UV_W(ntryL,G1H6(33),39,ex5(:),16,G2H2(33),m3h3x2(:,9),heltab2x6(:,:,17))
call HGT_OLR(G1H6(34),1,1,6)
call HGT_invQ_OLR(G1H6(34),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(34),-8,nMT,G2H6(5),n2h6(17))
  call Hloop_QA_W(ntryL,G2H6(5),ex4(:),G2H3(9),m3h2x3(:,9),heltab2x6(:,:,18))
  call Hloop_UV_W(ntryL,G1H6(38),39,ex5(:),16,G2H2(34),m3h3x2(:,10),heltab2x6(:,:,19))
  call Hloop_VA_Q(ntryL,G1H6(39),ex1(:),G1H3(1),m3h2x3(:,10),heltab2x6(:,:,20))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(10),n2h3(9))
call HGT_OLR(G1H6(40),1,1,6)
call HGT_invQ_OLR(G1H6(40),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(40),-16,0,G2H6(6),n2h6(18))
  call Hloop_QZ_A(ntryL,G2H6(6),ex5(:),G2H2(35),ngZu,m3h3x2(:,11),heltab2x6(:,:,21))
  call Hloop_VA_Q(ntryL,G1H6(44),ex1(:),G1H3(1),m3h2x3(:,11),heltab2x6(:,:,22))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(11),n2h3(10))
  call Hloop_WA_Q(ntryL,G1H6(45),ex1(:),G1H3(1),m3h2x3(:,12),heltab2x6(:,:,23))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(12),n2h3(11))
call HGT_OLR(G1H6(46),1,1,6)
call HGT_invQ_OLR(G1H6(46),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(46),-16,0,G2H6(7),n2h6(19))
  call Hloop_QZ_A(ntryL,G2H6(7),ex5(:),G2H2(36),ngZd,m3h3x2(:,12),heltab2x6(:,:,24))
  call Hloop_WA_Q(ntryL,G1H6(50),ex1(:),G1H3(1),m3h2x3(:,13),heltab2x6(:,:,25))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(13),n2h3(12))
  call Hloop_WQ_A(ntryL,G1H6(51),ex3(:),G1H3(1),m3h2x3(:,14),heltab2x6(:,:,26))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(14),n2h3(13))
call HGT_OLR(G1H6(52),1,1,6)
call HGT_invQ_OLR(G1H6(52),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(52),-16,0,G2H6(8),n2h6(20))
  call Hloop_AZ_Q(ntryL,G2H6(8),ex5(:),G2H2(37),ngZu,m3h3x2(:,13),heltab2x6(:,:,27))
  call Hloop_WQ_A(ntryL,G1H6(56),ex3(:),G1H3(1),m3h2x3(:,15),heltab2x6(:,:,28))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(15),n2h3(14))
  call Hloop_VQ_A(ntryL,G1H6(57),ex3(:),G1H3(1),m3h2x3(:,16),heltab2x6(:,:,29))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(16),n2h3(15))
call HGT_OLR(G1H6(58),1,1,6)
call HGT_invQ_OLR(G1H6(58),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(58),-16,0,G2H6(9),n2h6(21))
  call Hloop_AZ_Q(ntryL,G2H6(9),ex5(:),G2H2(38),ngZd,m3h3x2(:,14),heltab2x6(:,:,30))
  call Hloop_VQ_A(ntryL,G1H6(62),ex3(:),G1H3(1),m3h2x3(:,17),heltab2x6(:,:,31))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(17),n2h3(16))
  call Hloop_UW_V(ntryL,G1H6(63),43,ex5(:),16,G2H2(39),m3h3x2(:,15),heltab2x6(:,:,32))
call HGT_OLR(G1H6(64),1,1,6)
call HGT_invQ_OLR(G1H6(64),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(64),-4,0,G2H6(10),n2h6(22))
  call Hloop_AQ_W(ntryL,G2H6(10),ex3(:),G2H3(18),m3h2x3(:,18),heltab2x6(:,:,33))
  call Hloop_UW_V(ntryL,G1H6(68),43,ex5(:),16,G2H2(40),m3h3x2(:,16),heltab2x6(:,:,34))
  call Hloop_VQ_A(ntryL,G1H6(69),ex2(:),G1H3(1),m3h2x3(:,19),heltab2x6(:,:,35))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(19),n2h3(17))
call HGT_OLR(G1H6(70),1,1,6)
call HGT_invQ_OLR(G1H6(70),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(70),-16,nMT,G2H6(11),n2h6(23))
  call Hloop_AZ_Q(ntryL,G2H6(11),ex5(:),G2H2(41),ngZu,m3h3x2(:,17),heltab2x6(:,:,36))
  call Hloop_VQ_A(ntryL,G1H6(74),ex2(:),G1H3(1),m3h2x3(:,20),heltab2x6(:,:,37))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMT,G2H3(20),n2h3(18))
  call Hloop_WQ_A(ntryL,G1H6(75),ex2(:),G1H3(1),m3h2x3(:,21),heltab2x6(:,:,38))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(21),n2h3(19))
call HGT_OLR(G1H6(76),1,1,6)
call HGT_invQ_OLR(G1H6(76),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(76),-16,nMB,G2H6(12),n2h6(24))
  call Hloop_AZ_Q(ntryL,G2H6(12),ex5(:),G2H2(42),ngZd,m3h3x2(:,18),heltab2x6(:,:,39))
  call Hloop_WQ_A(ntryL,G1H6(80),ex2(:),G1H3(1),m3h2x3(:,22),heltab2x6(:,:,40))
  call Hloop_Q_A(ntryL,G1H3(1),47,nMB,G2H3(22),n2h3(20))
  call Hloop_WA_Q(ntryL,G1H6(81),ex4(:),G1H3(1),m3h2x3(:,23),heltab2x6(:,:,41))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(23),n2h3(21))
call HGT_OLR(G1H6(82),1,1,6)
call HGT_invQ_OLR(G1H6(82),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(82),-16,nMT,G2H6(13),n2h6(25))
  call Hloop_QZ_A(ntryL,G2H6(13),ex5(:),G2H2(43),ngZu,m3h3x2(:,19),heltab2x6(:,:,42))
  call Hloop_WA_Q(ntryL,G1H6(86),ex4(:),G1H3(1),m3h2x3(:,24),heltab2x6(:,:,43))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMT,G2H3(24),n2h3(22))
  call Hloop_VA_Q(ntryL,G1H6(87),ex4(:),G1H3(1),m3h2x3(:,25),heltab2x6(:,:,44))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(25),n2h3(23))
call HGT_OLR(G1H6(88),1,1,6)
call HGT_invQ_OLR(G1H6(88),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(88),-16,nMB,G2H6(14),n2h6(26))
  call Hloop_QZ_A(ntryL,G2H6(14),ex5(:),G2H2(44),ngZd,m3h3x2(:,20),heltab2x6(:,:,45))
  call Hloop_VA_Q(ntryL,G1H6(92),ex4(:),G1H3(1),m3h2x3(:,26),heltab2x6(:,:,46))
  call Hloop_A_Q(ntryL,G1H3(1),47,nMB,G2H3(26),n2h3(24))
  call Hloop_UV_W(ntryL,G1H6(93),39,ex5(:),16,G2H2(45),m3h3x2(:,21),heltab2x6(:,:,47))
call HGT_OLR(G1H6(94),1,1,6)
call HGT_invQ_OLR(G1H6(94),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(94),-8,nMT,G2H6(15),n2h6(27))
  call Hloop_QA_W(ntryL,G2H6(15),ex4(:),G2H3(27),m3h2x3(:,27),heltab2x6(:,:,48))
  call Hloop_UV_W(ntryL,G1H6(98),39,ex5(:),16,G2H2(46),m3h3x2(:,22),heltab2x6(:,:,49))
  call Hloop_SQ_A(ntryL,G1H4(1),ex2(:),G1H2(1),ngPbt,m3h2x2(:,25),heltab2x4(:,:,25))
  call Hloop_Q_A(ntryL,G1H2(1),55,nMB,G2H2(47),n2h2(1))
call HGT_raise_alpha_OLR(G1H4(2),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(2),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(2),ex4(:),G1H2(1),m3h2x2(:,26),heltab2x4(:,:,26))
  call Hloop_SQ_A(ntryL,G1H4(6),ex2(:),G1H2(2),ngPbt,m3h2x2(:,27),heltab2x4(:,:,27))
  call Hloop_Q_A(ntryL,G1H2(2),55,nMB,G2H2(48),n2h2(2))
  call Hloop_WA_Q(ntryL,G1H4(7),ex1(:),G1H2(2),m3h2x2(:,28),heltab2x4(:,:,28))
  call Hloop_A_Q(ntryL,G1H2(2),59,0,G2H2(49),n2h2(3))
call HGT_raise_alpha_OLR(G1H4(8),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(8),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(8),ex3(:),G1H2(2),m3h2x2(:,29),heltab2x4(:,:,29))
  call Hloop_WA_Q(ntryL,G1H4(85),ex1(:),G1H2(3),m3h2x2(:,30),heltab2x4(:,:,30))
  call Hloop_A_Q(ntryL,G1H2(3),59,0,G2H2(50),n2h2(4))
  call Hloop_SQ_A(ntryL,G1H4(13),ex2(:),G1H2(3),ngPbt,m3h2x2(:,31),heltab2x4(:,:,31))
  call Hloop_Q_A(ntryL,G1H2(3),55,nMB,G2H2(51),n2h2(5))
call HGT_raise_alpha_OLR(G1H4(14),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(14),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(14),ex4(:),G1H2(3),m3h2x2(:,32),heltab2x4(:,:,32))
  call Hloop_SQ_A(ntryL,G1H4(18),ex2(:),G1H2(4),ngPbt,m3h2x2(:,33),heltab2x4(:,:,33))
  call Hloop_Q_A(ntryL,G1H2(4),55,nMB,G2H2(52),n2h2(6))
  call Hloop_SA_Q(ntryL,G1H4(19),ex4(:),G1H2(4),ngPbt,m3h2x2(:,34),heltab2x4(:,:,34))
  call Hloop_A_Q(ntryL,G1H2(4),61,nMT,G2H2(53),n2h2(7))
call HGT_raise_alpha_OLR(G1H4(20),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(20),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(20),ex2(:),G1H2(4),m3h2x2(:,35),heltab2x4(:,:,35))
  call Hloop_SA_Q(ntryL,G1H4(24),ex4(:),G1H2(5),ngPbt,m3h2x2(:,36),heltab2x4(:,:,36))
  call Hloop_A_Q(ntryL,G1H2(5),61,nMT,G2H2(54),n2h2(8))
  call Hloop_VA_Q(ntryL,G1H6(99),ex1(:),G1H3(1),m3h2x3(:,28),heltab2x6(:,:,50))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(28),n2h3(25))
call HGT_OLR(G1H6(100),1,1,6)
call HGT_invQ_OLR(G1H6(100),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(100),-16,0,G2H6(16),n2h6(28))
  call Hloop_QZ_A(ntryL,G2H6(16),ex5(:),G2H2(55),ngZu,m3h3x2(:,23),heltab2x6(:,:,51))
  call Hloop_VA_Q(ntryL,G1H6(104),ex1(:),G1H3(1),m3h2x3(:,29),heltab2x6(:,:,52))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(29),n2h3(26))
  call Hloop_WA_Q(ntryL,G1H6(105),ex1(:),G1H3(1),m3h2x3(:,30),heltab2x6(:,:,53))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(30),n2h3(27))
call HGT_OLR(G1H6(106),1,1,6)
call HGT_invQ_OLR(G1H6(106),2,5,6)
  call Hloop_Q_A(ntryL,G1H6(106),-16,0,G2H6(17),n2h6(29))
  call Hloop_QZ_A(ntryL,G2H6(17),ex5(:),G2H2(56),ngZd,m3h3x2(:,24),heltab2x6(:,:,54))
  call Hloop_WA_Q(ntryL,G1H6(110),ex1(:),G1H3(1),m3h2x3(:,31),heltab2x6(:,:,55))
  call Hloop_A_Q(ntryL,G1H3(1),47,0,G2H3(31),n2h3(28))
  call Hloop_WQ_A(ntryL,G1H6(111),ex3(:),G1H3(1),m3h2x3(:,32),heltab2x6(:,:,56))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(32),n2h3(29))
call HGT_OLR(G1H6(112),1,1,6)
call HGT_invQ_OLR(G1H6(112),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(112),-16,0,G2H6(18),n2h6(30))
  call Hloop_AZ_Q(ntryL,G2H6(18),ex5(:),G2H2(57),ngZu,m3h3x2(:,25),heltab2x6(:,:,57))
  call Hloop_WQ_A(ntryL,G1H6(116),ex3(:),G1H3(1),m3h2x3(:,33),heltab2x6(:,:,58))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(33),n2h3(30))
  call Hloop_VQ_A(ntryL,G1H6(117),ex3(:),G1H3(1),m3h2x3(:,34),heltab2x6(:,:,59))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(34),n2h3(31))
call HGT_OLR(G1H6(118),1,1,6)
call HGT_invQ_OLR(G1H6(118),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(118),-16,0,G2H6(19),n2h6(31))
  call Hloop_AZ_Q(ntryL,G2H6(19),ex5(:),G2H2(58),ngZd,m3h3x2(:,26),heltab2x6(:,:,60))
  call Hloop_VQ_A(ntryL,G1H6(122),ex3(:),G1H3(1),m3h2x3(:,35),heltab2x6(:,:,61))
  call Hloop_Q_A(ntryL,G1H3(1),47,0,G2H3(35),n2h3(32))
  call Hloop_UW_V(ntryL,G1H6(123),43,ex5(:),16,G2H2(59),m3h3x2(:,27),heltab2x6(:,:,62))
call HGT_OLR(G1H6(124),1,1,6)
call HGT_invQ_OLR(G1H6(124),2,5,6)
  call Hloop_A_Q(ntryL,G1H6(124),-4,0,G2H6(20),n2h6(32))
  call Hloop_AQ_W(ntryL,G2H6(20),ex3(:),G2H3(36),m3h2x3(:,36),heltab2x6(:,:,63))
  call Hloop_UW_V(ntryL,G1H6(128),43,ex5(:),16,G2H2(60),m3h3x2(:,28),heltab2x6(:,:,64))
  call Hloop_WQ_A(ntryL,G1H4(25),ex2(:),G1H2(5),m3h2x2(:,37),heltab2x4(:,:,37))
  call Hloop_Q_A(ntryL,G1H2(5),55,nMB,G2H2(61),n2h2(9))
call HGT_raise_alpha_OLR(G1H4(26),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(26),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(26),ex4(:),G1H2(5),m3h2x2(:,38),heltab2x4(:,:,38))
  call Hloop_WQ_A(ntryL,G1H4(31),ex2(:),G1H2(6),m3h2x2(:,39),heltab2x4(:,:,39))
  call Hloop_Q_A(ntryL,G1H2(6),55,nMB,G2H2(62),n2h2(10))
call HGT_raise_alpha_OLR(G1H4(32),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(32),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(32),ex4(:),G1H2(6),m3h2x2(:,40),heltab2x4(:,:,40))
  call Hloop_WQ_A(ntryL,G1H4(36),ex2(:),G1H2(7),m3h2x2(:,41),heltab2x4(:,:,41))
  call Hloop_Q_A(ntryL,G1H2(7),55,nMB,G2H2(63),n2h2(11))
  call Hloop_WA_Q(ntryL,G1H4(37),ex1(:),G1H2(7),m3h2x2(:,42),heltab2x4(:,:,42))
  call Hloop_A_Q(ntryL,G1H2(7),59,0,G2H2(64),n2h2(12))
call HGT_raise_alpha_OLR(G1H4(38),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(38),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(38),ex3(:),G1H2(7),m3h2x2(:,43),heltab2x4(:,:,43))
  call Hloop_WA_Q(ntryL,G1H4(43),ex1(:),G1H2(8),m3h2x2(:,44),heltab2x4(:,:,44))
  call Hloop_A_Q(ntryL,G1H2(8),59,0,G2H2(65),n2h2(13))
call HGT_raise_alpha_OLR(G1H4(44),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(44),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(44),ex3(:),G1H2(8),m3h2x2(:,45),heltab2x4(:,:,45))
  call Hloop_WA_Q(ntryL,G1H4(48),ex1(:),G1H2(9),m3h2x2(:,46),heltab2x4(:,:,46))
  call Hloop_A_Q(ntryL,G1H2(9),59,0,G2H2(66),n2h2(14))
  call Hloop_WQ_A(ntryL,G1H4(49),ex2(:),G1H2(9),m3h2x2(:,47),heltab2x4(:,:,47))
  call Hloop_Q_A(ntryL,G1H2(9),55,nMB,G2H2(67),n2h2(15))
call HGT_raise_alpha_OLR(G1H4(50),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(50),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(50),ex4(:),G1H2(9),m3h2x2(:,48),heltab2x4(:,:,48))
  call Hloop_WQ_A(ntryL,G1H4(55),ex2(:),G1H2(10),m3h2x2(:,49),heltab2x4(:,:,49))
  call Hloop_Q_A(ntryL,G1H2(10),55,nMB,G2H2(68),n2h2(16))
call HGT_raise_alpha_OLR(G1H4(56),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(56),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(56),ex4(:),G1H2(10),m3h2x2(:,50),heltab2x4(:,:,50))
  call Hloop_WQ_A(ntryL,G1H4(60),ex2(:),G1H2(11),m3h2x2(:,51),heltab2x4(:,:,51))
  call Hloop_Q_A(ntryL,G1H2(11),55,nMB,G2H2(69),n2h2(17))
  call Hloop_WA_Q(ntryL,G1H4(61),ex4(:),G1H2(11),m3h2x2(:,52),heltab2x4(:,:,52))
  call Hloop_A_Q(ntryL,G1H2(11),61,nMT,G2H2(70),n2h2(18))
call HGT_raise_alpha_OLR(G1H4(62),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(62),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(62),ex2(:),G1H2(11),m3h2x2(:,53),heltab2x4(:,:,53))
  call Hloop_WA_Q(ntryL,G1H4(67),ex4(:),G1H2(12),m3h2x2(:,54),heltab2x4(:,:,54))
  call Hloop_A_Q(ntryL,G1H2(12),61,nMT,G2H2(71),n2h2(19))
call HGT_raise_alpha_OLR(G1H4(68),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(68),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(68),ex2(:),G1H2(12),m3h2x2(:,55),heltab2x4(:,:,55))
  call Hloop_WA_Q(ntryL,G1H4(72),ex4(:),G1H2(13),m3h2x2(:,56),heltab2x4(:,:,56))
  call Hloop_A_Q(ntryL,G1H2(13),61,nMT,G2H2(72),n2h2(20))
  call Hloop_QZ_A(ntryL,G1H6(129),ex5(:),G1H2(13),ngZd,m3h3x2(:,29),heltab2x6(:,:,65))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMB,G2H2(73),n2h2(21))
call HGT_raise_alpha_OLR(G1H6(130),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(130),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(130),ex4(:),G1H3(1),m3h2x3(:,37),heltab2x6(:,:,66))
  call Hloop_QZ_A(ntryL,G1H6(135),ex5(:),G1H2(13),ngZd,m3h3x2(:,30),heltab2x6(:,:,67))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMB,G2H2(74),n2h2(22))
call HGT_raise_alpha_OLR(G1H6(136),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(136),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(136),ex4(:),G1H3(2),m3h2x3(:,38),heltab2x6(:,:,68))
  call Hloop_QZ_A(ntryL,G1H6(140),ex5(:),G1H2(13),ngZd,m3h3x2(:,31),heltab2x6(:,:,69))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMB,G2H2(75),n2h2(23))
  call Hloop_WQ_A(ntryL,G1H4(73),ex2(:),G1H2(13),m3h2x2(:,57),heltab2x4(:,:,57))
  call Hloop_Q_A(ntryL,G1H2(13),55,nMB,G2H2(76),n2h2(24))
call HGT_raise_alpha_OLR(G1H4(74),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(74),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(74),ex4(:),G1H2(13),m3h2x2(:,58),heltab2x4(:,:,58))
  call Hloop_WQ_A(ntryL,G1H4(79),ex2(:),G1H2(14),m3h2x2(:,59),heltab2x4(:,:,59))
  call Hloop_Q_A(ntryL,G1H2(14),55,nMB,G2H2(77),n2h2(25))
call HGT_raise_alpha_OLR(G1H4(80),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(80),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(80),ex4(:),G1H2(14),m3h2x2(:,60),heltab2x4(:,:,60))
  call Hloop_WQ_A(ntryL,G1H4(84),ex2(:),G1H2(15),m3h2x2(:,61),heltab2x4(:,:,61))
  call Hloop_Q_A(ntryL,G1H2(15),55,nMB,G2H2(78),n2h2(26))
call HGT_raise_alpha_OLR(G1H4(86),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(86),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(86),ex3(:),G1H2(15),m3h2x2(:,62),heltab2x4(:,:,62))
  call Hloop_WA_Q(ntryL,G1H4(90),ex1(:),G1H2(16),m3h2x2(:,63),heltab2x4(:,:,63))
  call Hloop_A_Q(ntryL,G1H2(16),59,0,G2H2(79),n2h2(27))
  call Hloop_QZ_A(ntryL,G1H6(141),ex5(:),G1H2(16),ngZd,m3h3x2(:,32),heltab2x6(:,:,70))
  call Hloop_Q_A(ntryL,G1H2(16),55,nMB,G2H2(80),n2h2(28))
call HGT_raise_alpha_OLR(G1H6(142),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(142),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(142),ex4(:),G1H3(3),m3h2x3(:,39),heltab2x6(:,:,71))
  call Hloop_QZ_A(ntryL,G1H6(147),ex5(:),G1H2(16),ngZd,m3h3x2(:,33),heltab2x6(:,:,72))
  call Hloop_Q_A(ntryL,G1H2(16),55,nMB,G2H2(81),n2h2(29))
call HGT_raise_alpha_OLR(G1H6(148),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(148),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(148),ex4(:),G1H3(4),m3h2x3(:,40),heltab2x6(:,:,73))
  call Hloop_QZ_A(ntryL,G1H6(152),ex5(:),G1H2(16),ngZd,m3h3x2(:,34),heltab2x6(:,:,74))
  call Hloop_Q_A(ntryL,G1H2(16),55,nMB,G2H2(82),n2h2(30))
  call Hloop_WQ_A(ntryL,G1H4(91),ex2(:),G1H2(16),m3h2x2(:,64),heltab2x4(:,:,64))
  call Hloop_Q_A(ntryL,G1H2(16),55,nMB,G2H2(83),n2h2(31))
call HGT_raise_alpha_OLR(G1H4(92),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(92),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(92),ex4(:),G1H2(16),m3h2x2(:,65),heltab2x4(:,:,65))
  call Hloop_WQ_A(ntryL,G1H4(97),ex2(:),G1H2(17),m3h2x2(:,66),heltab2x4(:,:,66))
  call Hloop_Q_A(ntryL,G1H2(17),55,nMB,G2H2(84),n2h2(32))
call HGT_raise_alpha_OLR(G1H4(98),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(98),2,5,4)
  call Hloop_VA_Q(ntryL,G1H4(98),ex4(:),G1H2(17),m3h2x2(:,67),heltab2x4(:,:,67))
  call Hloop_WQ_A(ntryL,G1H4(102),ex2(:),G1H2(18),m3h2x2(:,68),heltab2x4(:,:,68))
  call Hloop_Q_A(ntryL,G1H2(18),55,nMB,G2H2(85),n2h2(33))
  call Hloop_WA_Q(ntryL,G1H4(103),ex4(:),G1H2(18),m3h2x2(:,69),heltab2x4(:,:,69))
  call Hloop_A_Q(ntryL,G1H2(18),61,nMT,G2H2(86),n2h2(34))
call HGT_raise_alpha_OLR(G1H4(104),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(104),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(104),ex2(:),G1H2(18),m3h2x2(:,70),heltab2x4(:,:,70))
  call Hloop_WA_Q(ntryL,G1H4(109),ex4(:),G1H2(19),m3h2x2(:,71),heltab2x4(:,:,71))
  call Hloop_A_Q(ntryL,G1H2(19),61,nMT,G2H2(87),n2h2(35))
call HGT_raise_alpha_OLR(G1H4(110),1,1,4)
call HGT_raise_alpha_invQ_OLR(G1H4(110),2,5,4)
  call Hloop_VQ_A(ntryL,G1H4(110),ex2(:),G1H2(19),m3h2x2(:,72),heltab2x4(:,:,72))
  call Hloop_WA_Q(ntryL,G1H4(114),ex4(:),G1H2(20),m3h2x2(:,73),heltab2x4(:,:,73))
  call Hloop_A_Q(ntryL,G1H2(20),61,nMT,G2H2(88),n2h2(36))
  call Hloop_AZ_Q(ntryL,G1H6(153),ex5(:),G1H2(20),ngZu,m3h3x2(:,35),heltab2x6(:,:,75))
  call Hloop_A_Q(ntryL,G1H2(20),61,nMT,G2H2(89),n2h2(37))
call HGT_raise_alpha_OLR(G1H6(154),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(154),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(154),ex2(:),G1H3(5),m3h2x3(:,41),heltab2x6(:,:,76))
  call Hloop_AZ_Q(ntryL,G1H6(159),ex5(:),G1H2(20),ngZu,m3h3x2(:,36),heltab2x6(:,:,77))
  call Hloop_A_Q(ntryL,G1H2(20),61,nMT,G2H2(90),n2h2(38))
call HGT_raise_alpha_OLR(G1H6(160),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(160),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(160),ex2(:),G1H3(6),m3h2x3(:,42),heltab2x6(:,:,78))
  call Hloop_AZ_Q(ntryL,G1H6(164),ex5(:),G1H2(20),ngZu,m3h3x2(:,37),heltab2x6(:,:,79))
  call Hloop_A_Q(ntryL,G1H2(20),61,nMT,G2H2(91),n2h2(39))
  call Hloop_AZ_Q(ntryL,G1H6(165),ex5(:),G1H2(20),ngZd,m3h3x2(:,38),heltab2x6(:,:,80))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(92),n2h2(40))
call HGT_raise_alpha_OLR(G1H6(166),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(166),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(166),ex3(:),G1H3(7),m3h2x3(:,43),heltab2x6(:,:,81))
  call Hloop_AZ_Q(ntryL,G1H6(171),ex5(:),G1H2(20),ngZd,m3h3x2(:,39),heltab2x6(:,:,82))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(93),n2h2(41))
call HGT_raise_alpha_OLR(G1H6(172),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(172),2,5,6)
  call Hloop_VQ_A(ntryL,G1H6(172),ex3(:),G1H3(8),m3h2x3(:,44),heltab2x6(:,:,83))
  call Hloop_AZ_Q(ntryL,G1H6(176),ex5(:),G1H2(20),ngZd,m3h3x2(:,40),heltab2x6(:,:,84))
  call Hloop_A_Q(ntryL,G1H2(20),59,0,G2H2(94),n2h2(42))
  call ol_merge(ntryL,G2H2(39),[G2H2(2)])
  call ol_merge(ntryL,G2H2(59),[G2H2(4)])
  call ol_merge(ntryL,G2H2(76),[G2H2(47)])
  call ol_merge(ntryL,G2H2(83),[G2H2(51)])
  call ol_merge(ntryL,G2H2(86),[G2H2(53)])
call Hotf_5pt_reduction(G2H2(1),RedSet_5(20),mass5set(:,19),  & 
G1H2(20),G1H2(21),G1H2(22),G1H2(23),G1H2(24),G1H2(25),2)
call HG1shiftOLR(G1H2(21),8,2)
call Hotf_5pt_reduction(G2H2(39),RedSet_5(22),mass5set(:,22),  & 
G1H2(26),G1H2(27),G1H2(28),G1H2(29),G1H2(30),G1H2(31),2)
call HG1shiftOLR(G1H2(27),4,2)
call Hotf_5pt_reduction(G2H2(3),RedSet_5(24),mass5set(:,19),  & 
G1H2(32),G1H2(33),G1H2(34),G1H2(35),G1H2(36),G1H2(37),2)
call HG1shiftOLR(G1H2(33),8,2)
call Hotf_5pt_reduction(G2H2(59),RedSet_5(26),mass5set(:,21),  & 
G1H2(38),G1H2(39),G1H2(40),G1H2(41),G1H2(42),G1H2(43),2)
call HG1shiftOLR(G1H2(39),4,2)
call Hotf_5pt_reduction(G2H2(5),RedSet_5(17),mass5set(:,15),  & 
G1H2(44),G1H2(45),G1H2(46),G1H2(47),G1H2(48),G1H2(49),2)
call HG1shiftOLR(G1H2(45),4,2)
call Hotf_5pt_reduction(G2H2(6),RedSet_5(18),mass5set(:,16),  & 
G1H2(50),G1H2(51),G1H2(52),G1H2(53),G1H2(54),G1H2(55),2)
call HG1shiftOLR(G1H2(51),4,2)
call Hotf_5pt_reduction(G2H2(7),RedSet_5(5),mass5set(:,4),  & 
G1H2(56),G1H2(57),G1H2(58),G1H2(59),G1H2(60),G1H2(61),2)
call HG1shiftOLR(G1H2(57),8,2)
call Hotf_5pt_reduction(G2H2(9),RedSet_5(5),mass5set(:,5),  & 
G1H2(62),G1H2(63),G1H2(64),G1H2(65),G1H2(66),G1H2(67),2)
call HG1shiftOLR(G1H2(63),8,2)
call Hotf_5pt_reduction(G2H2(11),RedSet_5(6),mass5set(:,6),  & 
G1H2(68),G1H2(69),G1H2(70),G1H2(71),G1H2(72),G1H2(73),2)
call HG1shiftOLR(G1H2(69),4,2)
call Hotf_5pt_reduction(G2H2(13),RedSet_5(6),mass5set(:,7),  & 
G1H2(74),G1H2(75),G1H2(76),G1H2(77),G1H2(78),G1H2(79),2)
call HG1shiftOLR(G1H2(75),4,2)
call Hotf_5pt_reduction(G2H2(15),RedSet_5(7),mass5set(:,8),  & 
G1H2(80),G1H2(81),G1H2(82),G1H2(83),G1H2(84),G1H2(85),2)
call HG1shiftOLR(G1H2(81),8,2)
call Hotf_5pt_reduction(G2H2(17),RedSet_5(10),mass5set(:,8),  & 
G1H2(86),G1H2(87),G1H2(88),G1H2(89),G1H2(90),G1H2(91),2)
call HG1shiftOLR(G1H2(87),8,2)
call Hotf_5pt_reduction(G2H2(19),RedSet_5(14),mass5set(:,4),  & 
G1H2(92),G1H2(93),G1H2(94),G1H2(95),G1H2(96),G1H2(97),2)
call HG1shiftOLR(G1H2(93),8,2)
call Hotf_5pt_reduction(G2H2(21),RedSet_5(14),mass5set(:,5),  & 
G1H2(98),G1H2(99),G1H2(100),G1H2(101),G1H2(102),G1H2(103),2)
call HG1shiftOLR(G1H2(99),8,2)
call Hotf_5pt_reduction(G2H2(23),RedSet_5(16),mass5set(:,13),  & 
G1H2(104),G1H2(105),G1H2(106),G1H2(107),G1H2(108),G1H2(109),2)
call HG1shiftOLR(G1H2(105),4,2)
call Hotf_5pt_reduction(G2H2(25),RedSet_5(16),mass5set(:,14),  & 
G1H2(110),G1H2(111),G1H2(112),G1H2(113),G1H2(114),G1H2(115),2)
call HG1shiftOLR(G1H2(111),4,2)
call Hotf_5pt_reduction(G2H3(1),RedSet_5(19),mass5set(:,17),  & 
G1H3(9),G1H3(10),G1H3(11),G1H3(12),G1H3(13),G1H3(14),3)
call HG1shiftOLR(G1H3(10),16,3)
call Hotf_5pt_reduction(G2H3(3),RedSet_5(19),mass5set(:,18),  & 
G1H3(15),G1H3(16),G1H3(17),G1H3(18),G1H3(19),G1H3(20),3)
call HG1shiftOLR(G1H3(16),16,3)
call Hotf_5pt_reduction(G2H3(5),RedSet_5(20),mass5set(:,19),  & 
G1H3(21),G1H3(22),G1H3(23),G1H3(24),G1H3(25),G1H3(26),3)
call HG1shiftOLR(G1H3(22),16,3)
call Hotf_5pt_reduction(G2H3(7),RedSet_5(20),mass5set(:,5),  & 
G1H3(27),G1H3(28),G1H3(29),G1H3(30),G1H3(31),G1H3(32),3)
call HG1shiftOLR(G1H3(28),16,3)
call Hotf_5pt_reduction(G2H2(33),RedSet_5(20),mass5set(:,19),  & 
G1H2(116),G1H2(117),G1H2(118),G1H2(119),G1H2(120),G1H2(121),2)
call HG1shiftOLR(G1H2(117),8,2)
call Hotf_5pt_reduction(G2H3(10),RedSet_5(21),mass5set(:,20),  & 
G1H3(33),G1H3(34),G1H3(35),G1H3(36),G1H3(37),G1H3(38),3)
call HG1shiftOLR(G1H3(34),16,3)
call Hotf_5pt_reduction(G2H3(12),RedSet_5(21),mass5set(:,21),  & 
G1H3(39),G1H3(40),G1H3(41),G1H3(42),G1H3(43),G1H3(44),3)
call HG1shiftOLR(G1H3(40),16,3)
call Hotf_5pt_reduction(G2H3(14),RedSet_5(22),mass5set(:,22),  & 
G1H3(45),G1H3(46),G1H3(47),G1H3(48),G1H3(49),G1H3(50),3)
call HG1shiftOLR(G1H3(46),16,3)
call Hotf_5pt_reduction(G2H3(16),RedSet_5(22),mass5set(:,23),  & 
G1H3(51),G1H3(52),G1H3(53),G1H3(54),G1H3(55),G1H3(56),3)
call HG1shiftOLR(G1H3(52),16,3)
call Hotf_5pt_reduction(G2H3(19),RedSet_5(23),mass5set(:,17),  & 
G1H3(57),G1H3(58),G1H3(59),G1H3(60),G1H3(61),G1H3(62),3)
call HG1shiftOLR(G1H3(58),16,3)
call Hotf_5pt_reduction(G2H3(21),RedSet_5(23),mass5set(:,18),  & 
G1H3(63),G1H3(64),G1H3(65),G1H3(66),G1H3(67),G1H3(68),3)
call HG1shiftOLR(G1H3(64),16,3)
call Hotf_5pt_reduction(G2H3(23),RedSet_5(24),mass5set(:,19),  & 
G1H3(69),G1H3(70),G1H3(71),G1H3(72),G1H3(73),G1H3(74),3)
call HG1shiftOLR(G1H3(70),16,3)
call Hotf_5pt_reduction(G2H3(25),RedSet_5(24),mass5set(:,5),  & 
G1H3(75),G1H3(76),G1H3(77),G1H3(78),G1H3(79),G1H3(80),3)
call HG1shiftOLR(G1H3(76),16,3)
call Hotf_5pt_reduction(G2H2(45),RedSet_5(24),mass5set(:,19),  & 
G1H2(122),G1H2(123),G1H2(124),G1H2(125),G1H2(126),G1H2(127),2)
call HG1shiftOLR(G1H2(123),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(76),ex4(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(49),ex3(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(83),ex4(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(86),ex2(:),G2tensor(4),m3h2x1(:,4),heltab2x2(:,:,4))
call Hotf_5pt_reduction(G2H3(28),RedSet_5(25),mass5set(:,23),  & 
G1H3(81),G1H3(82),G1H3(83),G1H3(84),G1H3(85),G1H3(86),3)
call HG1shiftOLR(G1H3(82),16,3)
call Hotf_5pt_reduction(G2H3(30),RedSet_5(25),mass5set(:,22),  & 
G1H3(87),G1H3(88),G1H3(89),G1H3(90),G1H3(91),G1H3(92),3)
call HG1shiftOLR(G1H3(88),16,3)
call Hotf_5pt_reduction(G2H3(32),RedSet_5(26),mass5set(:,21),  & 
G1H3(93),G1H3(94),G1H3(95),G1H3(96),G1H3(97),G1H3(98),3)
call HG1shiftOLR(G1H3(94),16,3)
call Hotf_5pt_reduction(G2H3(34),RedSet_5(26),mass5set(:,20),  & 
G1H3(99),G1H3(100),G1H3(101),G1H3(102),G1H3(103),G1H3(104),3)
call HG1shiftOLR(G1H3(100),16,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(61),ex4(:),G2tensor(5),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(64),ex3(:),G2tensor(6),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(67),ex4(:),G2tensor(7),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(70),ex2(:),G2tensor(8),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(73),ex4(:),G2tensor(9),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(80),ex4(:),G2tensor(10),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(89),ex2(:),G2tensor(11),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(92),ex3(:),G2tensor(12),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_SA_Q(ntryL,G1H2(20),ex4(:),G1H1(1),ngPbt,m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(13),n2h1(1))
  call Hloop_SA_Q(ntryL,G1H2(21),ex4(:),G1H1(1),ngPbt,m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(14),n2h1(2))
  call Hloop_WQ_A(ntryL,G1H2(26),ex3(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(15),n2h1(3))
  call Hloop_WQ_A(ntryL,G1H2(27),ex3(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(16),n2h1(4))
  call Hloop_SA_Q(ntryL,G1H2(32),ex4(:),G1H1(1),ngPbt,m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(17),n2h1(5))
  call Hloop_SA_Q(ntryL,G1H2(33),ex4(:),G1H1(1),ngPbt,m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(18),n2h1(6))
  call Hloop_WQ_A(ntryL,G1H2(38),ex3(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(19),n2h1(7))
  call Hloop_WQ_A(ntryL,G1H2(39),ex3(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(20),n2h1(8))
  call Hloop_VQ_A(ntryL,G1H2(44),ex3(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(21),n2h1(9))
  call Hloop_VQ_A(ntryL,G1H2(45),ex3(:),G1H1(1),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(22),n2h1(10))
  call Hloop_VQ_A(ntryL,G1H2(50),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(23),n2h1(11))
  call Hloop_VQ_A(ntryL,G1H2(51),ex3(:),G1H1(1),m3h2x1(:,24),heltab2x2(:,:,24))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(24),n2h1(12))
  call Hloop_WA_Q(ntryL,G1H2(56),ex4(:),G1H1(1),m3h2x1(:,25),heltab2x2(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(25),n2h1(13))
  call Hloop_WA_Q(ntryL,G1H2(57),ex4(:),G1H1(1),m3h2x1(:,26),heltab2x2(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(26),n2h1(14))
  call Hloop_VA_Q(ntryL,G1H2(62),ex4(:),G1H1(1),m3h2x1(:,27),heltab2x2(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(27),n2h1(15))
  call Hloop_VA_Q(ntryL,G1H2(63),ex4(:),G1H1(1),m3h2x1(:,28),heltab2x2(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(28),n2h1(16))
  call Hloop_WQ_A(ntryL,G1H2(68),ex3(:),G1H1(1),m3h2x1(:,29),heltab2x2(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(29),n2h1(17))
  call Hloop_WQ_A(ntryL,G1H2(69),ex3(:),G1H1(1),m3h2x1(:,30),heltab2x2(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(30),n2h1(18))
  call Hloop_VQ_A(ntryL,G1H2(74),ex3(:),G1H1(1),m3h2x1(:,31),heltab2x2(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(31),n2h1(19))
  call Hloop_VQ_A(ntryL,G1H2(75),ex3(:),G1H1(1),m3h2x1(:,32),heltab2x2(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(32),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(80),ex4(:),G1H1(1),m3h2x1(:,33),heltab2x2(:,:,33))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(33),n2h1(21))
  call Hloop_VA_Q(ntryL,G1H2(81),ex4(:),G1H1(1),m3h2x1(:,34),heltab2x2(:,:,34))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(34),n2h1(22))
  call Hloop_VA_Q(ntryL,G1H2(86),ex4(:),G1H1(1),m3h2x1(:,35),heltab2x2(:,:,35))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(35),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(87),ex4(:),G1H1(1),m3h2x1(:,36),heltab2x2(:,:,36))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(36),n2h1(24))
  call Hloop_WA_Q(ntryL,G1H2(92),ex4(:),G1H1(1),m3h2x1(:,37),heltab2x2(:,:,37))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(37),n2h1(25))
  call Hloop_WA_Q(ntryL,G1H2(93),ex4(:),G1H1(1),m3h2x1(:,38),heltab2x2(:,:,38))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(38),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(98),ex4(:),G1H1(1),m3h2x1(:,39),heltab2x2(:,:,39))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(39),n2h1(27))
  call Hloop_VA_Q(ntryL,G1H2(99),ex4(:),G1H1(1),m3h2x1(:,40),heltab2x2(:,:,40))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(40),n2h1(28))
  call Hloop_VQ_A(ntryL,G1H2(104),ex3(:),G1H1(1),m3h2x1(:,41),heltab2x2(:,:,41))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(41),n2h1(29))
  call Hloop_VQ_A(ntryL,G1H2(105),ex3(:),G1H1(1),m3h2x1(:,42),heltab2x2(:,:,42))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(42),n2h1(30))
  call Hloop_WQ_A(ntryL,G1H2(110),ex3(:),G1H1(1),m3h2x1(:,43),heltab2x2(:,:,43))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(43),n2h1(31))
  call Hloop_WQ_A(ntryL,G1H2(111),ex3(:),G1H1(1),m3h2x1(:,44),heltab2x2(:,:,44))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,0,G2tensor(44),n2h1(32))
  call Hloop_QZ_A(ntryL,G1H3(9),ex5(:),G1H1(1),ngZu,m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(45),n2h1(33))
  call Hloop_QZ_A(ntryL,G1H3(10),ex5(:),G1H1(1),ngZu,m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(46),n2h1(34))
  call Hloop_QZ_A(ntryL,G1H3(15),ex5(:),G1H1(1),ngZd,m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(47),n2h1(35))
  call Hloop_QZ_A(ntryL,G1H3(16),ex5(:),G1H1(1),ngZd,m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(48),n2h1(36))
  call Hloop_AZ_Q(ntryL,G1H3(21),ex5(:),G1H1(1),ngZu,m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(49),n2h1(37))
  call Hloop_AZ_Q(ntryL,G1H3(22),ex5(:),G1H1(1),ngZu,m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(50),n2h1(38))
  call Hloop_AZ_Q(ntryL,G1H3(27),ex5(:),G1H1(1),ngZd,m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(51),n2h1(39))
  call Hloop_AZ_Q(ntryL,G1H3(28),ex5(:),G1H1(1),ngZd,m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(52),n2h1(40))
  call Hloop_WA_Q(ntryL,G1H2(116),ex4(:),G1H1(1),m3h2x1(:,45),heltab2x2(:,:,45))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(53),n2h1(41))
  call Hloop_WA_Q(ntryL,G1H2(117),ex4(:),G1H1(1),m3h2x1(:,46),heltab2x2(:,:,46))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(54),n2h1(42))
  call Hloop_AZ_Q(ntryL,G1H3(33),ex5(:),G1H1(1),ngZu,m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(55),n2h1(43))
  call Hloop_AZ_Q(ntryL,G1H3(34),ex5(:),G1H1(1),ngZu,m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(56),n2h1(44))
  call Hloop_AZ_Q(ntryL,G1H3(39),ex5(:),G1H1(1),ngZd,m3h3x1(:,11),heltab2x3(:,:,11))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(57),n2h1(45))
  call Hloop_AZ_Q(ntryL,G1H3(40),ex5(:),G1H1(1),ngZd,m3h3x1(:,12),heltab2x3(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(58),n2h1(46))
  call Hloop_QZ_A(ntryL,G1H3(45),ex5(:),G1H1(1),ngZu,m3h3x1(:,13),heltab2x3(:,:,13))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(59),n2h1(47))
  call Hloop_QZ_A(ntryL,G1H3(46),ex5(:),G1H1(1),ngZu,m3h3x1(:,14),heltab2x3(:,:,14))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(60),n2h1(48))
  call Hloop_QZ_A(ntryL,G1H3(51),ex5(:),G1H1(1),ngZd,m3h3x1(:,15),heltab2x3(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(61),n2h1(49))
  call Hloop_QZ_A(ntryL,G1H3(52),ex5(:),G1H1(1),ngZd,m3h3x1(:,16),heltab2x3(:,:,16))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(62),n2h1(50))
  call Hloop_QZ_A(ntryL,G1H3(57),ex5(:),G1H1(1),ngZu,m3h3x1(:,17),heltab2x3(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(63),n2h1(51))
  call Hloop_QZ_A(ntryL,G1H3(58),ex5(:),G1H1(1),ngZu,m3h3x1(:,18),heltab2x3(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(64),n2h1(52))
  call Hloop_QZ_A(ntryL,G1H3(63),ex5(:),G1H1(1),ngZd,m3h3x1(:,19),heltab2x3(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(65),n2h1(53))
  call Hloop_QZ_A(ntryL,G1H3(64),ex5(:),G1H1(1),ngZd,m3h3x1(:,20),heltab2x3(:,:,20))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(66),n2h1(54))
  call Hloop_AZ_Q(ntryL,G1H3(69),ex5(:),G1H1(1),ngZu,m3h3x1(:,21),heltab2x3(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(67),n2h1(55))
  call Hloop_AZ_Q(ntryL,G1H3(70),ex5(:),G1H1(1),ngZu,m3h3x1(:,22),heltab2x3(:,:,22))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMT,G2tensor(68),n2h1(56))
  call Hloop_AZ_Q(ntryL,G1H3(75),ex5(:),G1H1(1),ngZd,m3h3x1(:,23),heltab2x3(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMB,G2tensor(69),n2h1(57))
  call Hloop_AZ_Q(ntryL,G1H3(76),ex5(:),G1H1(1),ngZd,m3h3x1(:,24),heltab2x3(:,:,24))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,nMB,G2tensor(70),n2h1(58))
  call Hloop_WA_Q(ntryL,G1H2(122),ex4(:),G1H1(1),m3h2x1(:,47),heltab2x2(:,:,47))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,nMT,G2tensor(71),n2h1(59))
  call Hloop_WA_Q(ntryL,G1H2(123),ex4(:),G1H1(1),m3h2x1(:,48),heltab2x2(:,:,48))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMT,G2tensor(72),n2h1(60))
  call Hloop_AZ_Q(ntryL,G1H3(81),ex5(:),G1H1(1),ngZu,m3h3x1(:,25),heltab2x3(:,:,25))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(73),n2h1(61))
  call Hloop_AZ_Q(ntryL,G1H3(82),ex5(:),G1H1(1),ngZu,m3h3x1(:,26),heltab2x3(:,:,26))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(74),n2h1(62))
  call Hloop_AZ_Q(ntryL,G1H3(87),ex5(:),G1H1(1),ngZd,m3h3x1(:,27),heltab2x3(:,:,27))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),63,0,G2tensor(75),n2h1(63))
  call Hloop_AZ_Q(ntryL,G1H3(88),ex5(:),G1H1(1),ngZd,m3h3x1(:,28),heltab2x3(:,:,28))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),16,0,G2tensor(76),n2h1(64))
  call Hloop_QZ_A(ntryL,G1H3(93),ex5(:),G1H1(1),ngZu,m3h3x1(:,29),heltab2x3(:,:,29))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(77),n2h1(65))
  call Hloop_QZ_A(ntryL,G1H3(94),ex5(:),G1H1(1),ngZu,m3h3x1(:,30),heltab2x3(:,:,30))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(78),n2h1(66))
  call Hloop_QZ_A(ntryL,G1H3(99),ex5(:),G1H1(1),ngZd,m3h3x1(:,31),heltab2x3(:,:,31))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),63,0,G2tensor(79),n2h1(67))
  call Hloop_QZ_A(ntryL,G1H3(100),ex5(:),G1H1(1),ngZd,m3h3x1(:,32),heltab2x3(:,:,32))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),16,0,G2tensor(80),n2h1(68))
  call ol_merge_tensors(G2tensor(53),[G2tensor(13)])
  call ol_merge_tensors(G2tensor(71),[G2tensor(17)])
call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(8),mass5set(:,9),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
call G_TensorShift(G1tensor(2),8)
call Hotf_5pt_reduction_last(G2tensor(2),RedSet_5(9),mass5set(:,10),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
call G_TensorShift(G1tensor(8),4)
call Hotf_5pt_reduction_last(G2tensor(3),RedSet_5(12),mass5set(:,9),  & 
G1tensor(13),G1tensor(14),G1tensor(15),G1tensor(16),G1tensor(17),G1tensor(18))
call G_TensorShift(G1tensor(14),8)
call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(12),mass5set(:,9),  & 
G1tensor(19),G1tensor(20),G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24))
call G_TensorShift(G1tensor(20),2)
call Hotf_5pt_reduction_last(G2tensor(5),RedSet_5(1),mass5set(:,1),  & 
G1tensor(25),G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
call G_TensorShift(G1tensor(26),8)
call Hotf_5pt_reduction_last(G2tensor(6),RedSet_5(2),mass5set(:,2),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35),G1tensor(36))
call G_TensorShift(G1tensor(32),4)
call Hotf_5pt_reduction_last(G2tensor(7),RedSet_5(3),mass5set(:,1),  & 
G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40),G1tensor(41),G1tensor(42))
call G_TensorShift(G1tensor(38),8)
call Hotf_5pt_reduction_last(G2tensor(8),RedSet_5(3),mass5set(:,1),  & 
G1tensor(43),G1tensor(44),G1tensor(45),G1tensor(46),G1tensor(47),G1tensor(48))
call G_TensorShift(G1tensor(44),2)
call Hotf_5pt_reduction_last(G2tensor(9),RedSet_5(4),mass5set(:,3),  & 
G1tensor(49),G1tensor(50),G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54))
call G_TensorShift(G1tensor(50),8)
call Hotf_5pt_reduction_last(G2tensor(10),RedSet_5(11),mass5set(:,3),  & 
G1tensor(55),G1tensor(56),G1tensor(57),G1tensor(58),G1tensor(59),G1tensor(60))
call G_TensorShift(G1tensor(56),8)
call Hotf_5pt_reduction_last(G2tensor(11),RedSet_5(13),mass5set(:,11),  & 
G1tensor(61),G1tensor(62),G1tensor(63),G1tensor(64),G1tensor(65),G1tensor(66))
call G_TensorShift(G1tensor(62),2)
call Hotf_5pt_reduction_last(G2tensor(12),RedSet_5(15),mass5set(:,12),  & 
G1tensor(67),G1tensor(68),G1tensor(69),G1tensor(70),G1tensor(71),G1tensor(72))
call G_TensorShift(G1tensor(68),4)
call Hotf_5pt_reduction_last(G2tensor(53),RedSet_5(20),mass5set(:,19),  & 
G1tensor(73),G1tensor(74),G1tensor(75),G1tensor(76),G1tensor(77),G1tensor(78))
call G_TensorShift(G1tensor(74),8)
call Hotf_5pt_reduction_last(G2tensor(15),RedSet_5(22),mass5set(:,22),  & 
G1tensor(79),G1tensor(80),G1tensor(81),G1tensor(82),G1tensor(83),G1tensor(84))
call G_TensorShift(G1tensor(80),4)
call Hotf_5pt_reduction_last(G2tensor(71),RedSet_5(24),mass5set(:,19),  & 
G1tensor(85),G1tensor(86),G1tensor(87),G1tensor(88),G1tensor(89),G1tensor(90))
call G_TensorShift(G1tensor(86),8)
call Hotf_5pt_reduction_last(G2tensor(19),RedSet_5(26),mass5set(:,21),  & 
G1tensor(91),G1tensor(92),G1tensor(93),G1tensor(94),G1tensor(95),G1tensor(96))
call G_TensorShift(G1tensor(92),4)
call Hotf_5pt_reduction_last(G2tensor(21),RedSet_5(17),mass5set(:,15),  & 
G1tensor(97),G1tensor(98),G1tensor(99),G1tensor(100),G1tensor(101),G1tensor(102))
call G_TensorShift(G1tensor(98),4)
call Hotf_5pt_reduction_last(G2tensor(23),RedSet_5(18),mass5set(:,16),  & 
G1tensor(103),G1tensor(104),G1tensor(105),G1tensor(106),G1tensor(107),G1tensor(108))
call G_TensorShift(G1tensor(104),4)
call Hotf_5pt_reduction_last(G2tensor(25),RedSet_5(5),mass5set(:,4),  & 
G1tensor(109),G1tensor(110),G1tensor(111),G1tensor(112),G1tensor(113),G1tensor(114))
call G_TensorShift(G1tensor(110),8)
call Hotf_5pt_reduction_last(G2tensor(27),RedSet_5(5),mass5set(:,5),  & 
G1tensor(115),G1tensor(116),G1tensor(117),G1tensor(118),G1tensor(119),G1tensor(120))
call G_TensorShift(G1tensor(116),8)
call Hotf_5pt_reduction_last(G2tensor(29),RedSet_5(6),mass5set(:,6),  & 
G1tensor(121),G1tensor(122),G1tensor(123),G1tensor(124),G1tensor(125),G1tensor(126))
call G_TensorShift(G1tensor(122),4)
call Hotf_5pt_reduction_last(G2tensor(31),RedSet_5(6),mass5set(:,7),  & 
G1tensor(127),G1tensor(128),G1tensor(129),G1tensor(130),G1tensor(131),G1tensor(132))
call G_TensorShift(G1tensor(128),4)
call Hotf_5pt_reduction_last(G2tensor(33),RedSet_5(7),mass5set(:,8),  & 
G1tensor(133),G1tensor(134),G1tensor(135),G1tensor(136),G1tensor(137),G1tensor(138))
call G_TensorShift(G1tensor(134),8)
call Hotf_5pt_reduction_last(G2tensor(35),RedSet_5(10),mass5set(:,8),  & 
G1tensor(139),G1tensor(140),G1tensor(141),G1tensor(142),G1tensor(143),G1tensor(144))
call G_TensorShift(G1tensor(140),8)
call Hotf_5pt_reduction_last(G2tensor(37),RedSet_5(14),mass5set(:,4),  & 
G1tensor(145),G1tensor(146),G1tensor(147),G1tensor(148),G1tensor(149),G1tensor(150))
call G_TensorShift(G1tensor(146),8)
call Hotf_5pt_reduction_last(G2tensor(39),RedSet_5(14),mass5set(:,5),  & 
G1tensor(151),G1tensor(152),G1tensor(153),G1tensor(154),G1tensor(155),G1tensor(156))
call G_TensorShift(G1tensor(152),8)
call Hotf_5pt_reduction_last(G2tensor(41),RedSet_5(16),mass5set(:,13),  & 
G1tensor(157),G1tensor(158),G1tensor(159),G1tensor(160),G1tensor(161),G1tensor(162))
call G_TensorShift(G1tensor(158),4)
call Hotf_5pt_reduction_last(G2tensor(43),RedSet_5(16),mass5set(:,14),  & 
G1tensor(163),G1tensor(164),G1tensor(165),G1tensor(166),G1tensor(167),G1tensor(168))
call G_TensorShift(G1tensor(164),4)
call Hotf_5pt_reduction_last(G2tensor(45),RedSet_5(19),mass5set(:,17),  & 
G1tensor(169),G1tensor(170),G1tensor(171),G1tensor(172),G1tensor(173),G1tensor(174))
call G_TensorShift(G1tensor(170),16)
call Hotf_5pt_reduction_last(G2tensor(47),RedSet_5(19),mass5set(:,18),  & 
G1tensor(175),G1tensor(176),G1tensor(177),G1tensor(178),G1tensor(179),G1tensor(180))
call G_TensorShift(G1tensor(176),16)
call Hotf_5pt_reduction_last(G2tensor(49),RedSet_5(20),mass5set(:,19),  & 
G1tensor(181),G1tensor(182),G1tensor(183),G1tensor(184),G1tensor(185),G1tensor(186))
call G_TensorShift(G1tensor(182),16)
call Hotf_5pt_reduction_last(G2tensor(51),RedSet_5(20),mass5set(:,5),  & 
G1tensor(187),G1tensor(188),G1tensor(189),G1tensor(190),G1tensor(191),G1tensor(192))
call G_TensorShift(G1tensor(188),16)
call Hotf_5pt_reduction_last(G2tensor(55),RedSet_5(21),mass5set(:,20),  & 
G1tensor(193),G1tensor(194),G1tensor(195),G1tensor(196),G1tensor(197),G1tensor(198))
call G_TensorShift(G1tensor(194),16)
call Hotf_5pt_reduction_last(G2tensor(57),RedSet_5(21),mass5set(:,21),  & 
G1tensor(199),G1tensor(200),G1tensor(201),G1tensor(202),G1tensor(203),G1tensor(204))
call G_TensorShift(G1tensor(200),16)
call Hotf_5pt_reduction_last(G2tensor(59),RedSet_5(22),mass5set(:,22),  & 
G1tensor(205),G1tensor(206),G1tensor(207),G1tensor(208),G1tensor(209),G1tensor(210))
call G_TensorShift(G1tensor(206),16)
call Hotf_5pt_reduction_last(G2tensor(61),RedSet_5(22),mass5set(:,23),  & 
G1tensor(211),G1tensor(212),G1tensor(213),G1tensor(214),G1tensor(215),G1tensor(216))
call G_TensorShift(G1tensor(212),16)
call Hotf_5pt_reduction_last(G2tensor(63),RedSet_5(23),mass5set(:,17),  & 
G1tensor(217),G1tensor(218),G1tensor(219),G1tensor(220),G1tensor(221),G1tensor(222))
call G_TensorShift(G1tensor(218),16)
call Hotf_5pt_reduction_last(G2tensor(65),RedSet_5(23),mass5set(:,18),  & 
G1tensor(223),G1tensor(224),G1tensor(225),G1tensor(226),G1tensor(227),G1tensor(228))
call G_TensorShift(G1tensor(224),16)
call Hotf_5pt_reduction_last(G2tensor(67),RedSet_5(24),mass5set(:,19),  & 
G1tensor(229),G1tensor(230),G1tensor(231),G1tensor(232),G1tensor(233),G1tensor(234))
call G_TensorShift(G1tensor(230),16)
call Hotf_5pt_reduction_last(G2tensor(69),RedSet_5(24),mass5set(:,5),  & 
G1tensor(235),G1tensor(236),G1tensor(237),G1tensor(238),G1tensor(239),G1tensor(240))
call G_TensorShift(G1tensor(236),16)
call Hotf_5pt_reduction_last(G2tensor(73),RedSet_5(25),mass5set(:,23),  & 
G1tensor(241),G1tensor(242),G1tensor(243),G1tensor(244),G1tensor(245),G1tensor(246))
call G_TensorShift(G1tensor(242),16)
call Hotf_5pt_reduction_last(G2tensor(75),RedSet_5(25),mass5set(:,22),  & 
G1tensor(247),G1tensor(248),G1tensor(249),G1tensor(250),G1tensor(251),G1tensor(252))
call G_TensorShift(G1tensor(248),16)
call Hotf_5pt_reduction_last(G2tensor(77),RedSet_5(26),mass5set(:,21),  & 
G1tensor(253),G1tensor(254),G1tensor(255),G1tensor(256),G1tensor(257),G1tensor(258))
call G_TensorShift(G1tensor(254),16)
call Hotf_5pt_reduction_last(G2tensor(79),RedSet_5(26),mass5set(:,20),  & 
G1tensor(259),G1tensor(260),G1tensor(261),G1tensor(262),G1tensor(263),G1tensor(264))
call G_TensorShift(G1tensor(260),16)
call ol_merge_tensors(T1sum(1),[G1tensor(1)])
call ol_merge_tensors(T1sum(2),[G1tensor(7)])
call ol_merge_tensors(T1sum(3),[G1tensor(13)])
call ol_merge_tensors(T1sum(4),[G1tensor(19)])
call ol_merge_tensors(T1sum(5),[G1tensor(25)])
call ol_merge_tensors(T1sum(6),[G1tensor(31)])
call ol_merge_tensors(T1sum(7),[G1tensor(37)])
call ol_merge_tensors(T1sum(8),[G1tensor(43)])
call ol_merge_tensors(T1sum(9),[G1tensor(49)])
call ol_merge_tensors(T1sum(10),[G1tensor(55)])
call ol_merge_tensors(T1sum(11),[G1tensor(61)])
call ol_merge_tensors(T1sum(12),[G1tensor(67)])
call ol_merge_tensors(T1sum(13),[G1tensor(73)])
call ol_merge_tensors(T1sum(14),[G1tensor(79)])
call ol_merge_tensors(T1sum(15),[G1tensor(85)])
call ol_merge_tensors(T1sum(16),[G1tensor(91)])
call ol_merge_tensors(T1sum(17),[G1tensor(97)])
call ol_merge_tensors(T1sum(18),[G1tensor(103)])
call ol_merge_tensors(T1sum(19),[G1tensor(109)])
call ol_merge_tensors(T1sum(20),[G1tensor(115)])
call ol_merge_tensors(T1sum(21),[G1tensor(121)])
call ol_merge_tensors(T1sum(22),[G1tensor(127)])
call ol_merge_tensors(T1sum(23),[G1tensor(133)])
call ol_merge_tensors(T1sum(24),[G1tensor(139)])
call ol_merge_tensors(T1sum(25),[G1tensor(145)])
call ol_merge_tensors(T1sum(26),[G1tensor(151)])
call ol_merge_tensors(T1sum(27),[G1tensor(157)])
call ol_merge_tensors(T1sum(28),[G1tensor(163)])
call ol_merge_tensors(T1sum(29),[G1tensor(169)])
call ol_merge_tensors(T1sum(30),[G1tensor(175)])
call ol_merge_tensors(T1sum(31),[G1tensor(181)])
call ol_merge_tensors(T1sum(32),[G1tensor(187)])
call ol_merge_tensors(T1sum(33),[G1tensor(193)])
call ol_merge_tensors(T1sum(34),[G1tensor(199)])
call ol_merge_tensors(T1sum(35),[G1tensor(205)])
call ol_merge_tensors(T1sum(36),[G1tensor(211)])
call ol_merge_tensors(T1sum(37),[G1tensor(217)])
call ol_merge_tensors(T1sum(38),[G1tensor(223)])
call ol_merge_tensors(T1sum(39),[G1tensor(229)])
call ol_merge_tensors(T1sum(40),[G1tensor(235)])
call ol_merge_tensors(T1sum(41),[G1tensor(241)])
call ol_merge_tensors(T1sum(42),[G1tensor(247)])
call ol_merge_tensors(T1sum(43),[G1tensor(253)])
call ol_merge_tensors(T1sum(44),[G1tensor(259)])
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(57),h0tab(:,57),[32,5,16,2,8],[nMB,nMT,nMT,0,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,57),heltab2x96(:,:,57))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(1),n2h48(41))
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(58),h0tab(:,58),[32,5,8,2,16],[nMT,nMB,0,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,58),heltab2x96(:,:,58))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(2),n2h48(42))
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(59),h0tab(:,59),[32,2,8,16,5],[nMT,0,nMB,nMB,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,59),heltab2x96(:,:,59))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(3),n2h48(43))
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(60),h0tab(:,60),[32,2,8,5,16],[nMT,0,nMB,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,60),heltab2x96(:,:,60))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(4),n2h48(44))
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(61),h0tab(:,61),[32,5,2,8,16],[nMB,nMT,0,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,61),heltab2x96(:,:,61))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(5),n2h48(45))
Gcoeff(:)%j = (c(8)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(62),h0tab(:,62),[32,8,2,5,16],[nMB,0,nMT,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,62),heltab2x96(:,:,62))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(6),n2h48(46))
Gcoeff(:)%j = (c(7)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(63),h0tab(:,63),[32,2,16,5,8],[0,nMT,nMT,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(7),m3h2x48(:,63),heltab2x96(:,:,63))
Gcoeff(:)%j = (c(7)*M(3,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(64),h0tab(:,64),[32,2,5,16,8],[0,nMT,nMB,nMB,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(8),m3h2x48(:,64),heltab2x96(:,:,64))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(65),h0tab(:,65),[32,4,1,16,10],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,65),heltab2x96(:,:,65))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(9),n2h48(47))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(66),h0tab(:,66),[32,10,4,1,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,66),heltab2x96(:,:,66))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(10),n2h48(48))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(67),h0tab(:,67),[32,1,4,16,10],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,67),heltab2x96(:,:,67))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(11),n2h48(49))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(68),h0tab(:,68),[32,1,4,10,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,68),heltab2x96(:,:,68))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(12),n2h48(50))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(69),h0tab(:,69),[32,10,1,4,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,69),heltab2x96(:,:,69))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(13),n2h48(51))
Gcoeff(:)%j = (c(8)*M(2,:)%j) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(70),h0tab(:,70),[32,4,1,10,16],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,70),heltab2x96(:,:,70))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(14),n2h48(52))
Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(71),h0tab(:,71),[32,1,16,10,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(15),m3h2x48(:,71),heltab2x96(:,:,71))
Gcoeff(:)%j = (-(c(7)*M(2,:)%j)) * den(24)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(72),h0tab(:,72),[32,1,10,16,4],[0,0,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(16),m3h2x48(:,72),heltab2x96(:,:,72))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(73),h0tab(:,73),[32,4,2,8,17],[0,nMW,nMB,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,73),heltab2x96(:,:,73))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(17),n2h48(53))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(74),h0tab(:,74),[32,4,2,8,17],[0,0,nMT,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,74),heltab2x96(:,:,74))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(18),n2h48(54))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(75),h0tab(:,75),[32,8,2,4,17],[0,nMB,nMW,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(19),m3h2x48(:,75),heltab2x96(:,:,75))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(76),h0tab(:,76),[32,2,4,17,8],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,76),heltab2x96(:,:,76))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(20),n2h48(55))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(77),h0tab(:,77),[32,2,4,17,8],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,77),heltab2x96(:,:,77))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(21),n2h48(56))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(78),h0tab(:,78),[32,2,8,4,17],[0,nMT,nMW,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(22),m3h2x48(:,78),heltab2x96(:,:,78))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(79),h0tab(:,79),[32,2,8,17,4],[0,nMT,nMW,0,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(23),m3h2x48(:,79),heltab2x96(:,:,79))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(80),h0tab(:,80),[32,4,8,2,17],[0,nMW,nMT,0,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,80),heltab2x96(:,:,80))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(24),n2h48(57))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(81),h0tab(:,81),[32,4,8,2,17],[0,0,nMB,nMW,0],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,81),heltab2x96(:,:,81))
  call Hloop_A_Q(ntryL,G0H48(1),32,0,G1H48(25),n2h48(58))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(82),h0tab(:,82),[32,4,17,2,8],[0,0,nMW,nMB,0],5,1,wf6(:,6))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(26),m3h2x48(:,82),heltab2x96(:,:,82))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(83),h0tab(:,83),[32,2,17,4,8],[nMT,0,0,nMW,nMT],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,83),heltab2x96(:,:,83))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(27),n2h48(59))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(23)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(84),h0tab(:,84),[32,2,17,4,8],[nMB,nMW,0,0,nMB],5,1,wf6(:,6))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,84),heltab2x96(:,:,84))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(28),n2h48(60))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(85),h0tab(:,85),[32,4,1,8,18],[0,0,nMW,nMT,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(29),m3h2x48(:,85),heltab2x96(:,:,85))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(86),h0tab(:,86),[32,8,1,4,18],[nMT,nMW,0,0,nMT],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,86),heltab2x96(:,:,86))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(30),n2h48(61))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(87),h0tab(:,87),[32,8,1,4,18],[nMB,0,0,nMW,nMB],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,87),heltab2x96(:,:,87))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(31),n2h48(62))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(88),h0tab(:,88),[32,1,4,8,18],[0,0,nMW,nMT,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(32),m3h2x48(:,88),heltab2x96(:,:,88))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(89),h0tab(:,89),[32,1,4,18,8],[0,0,nMW,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(33),m3h2x48(:,89),heltab2x96(:,:,89))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(90),h0tab(:,90),[32,8,4,1,18],[nMT,nMW,0,0,nMT],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,90),heltab2x96(:,:,90))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMT,G1H48(34),n2h48(63))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(91),h0tab(:,91),[32,8,4,1,18],[nMB,0,0,nMW,nMB],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,91),heltab2x96(:,:,91))
  call Hloop_Q_A(ntryL,G0H48(1),32,nMB,G1H48(35),n2h48(64))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(92),h0tab(:,92),[32,4,1,18,8],[0,0,nMW,nMB,0],5,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(36),m3h2x48(:,92),heltab2x96(:,:,92))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(93),h0tab(:,93),[32,1,8,18,4],[0,0,nMB,nMW,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,93),heltab2x96(:,:,93))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(37),n2h48(65))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(94),h0tab(:,94),[32,1,8,18,4],[0,nMW,nMT,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,94),heltab2x96(:,:,94))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(38),n2h48(66))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(95),h0tab(:,95),[32,1,18,8,4],[0,0,nMT,nMW,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,95),heltab2x96(:,:,95))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(39),n2h48(67))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(96),h0tab(:,96),[32,1,18,8,4],[0,nMW,nMB,0,0],5,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,96),heltab2x96(:,:,96))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(40),n2h48(68))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(97),h0tab(:,97),[32,1,2,8,20],[0,0,nMT,nMW,0],5,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,97),heltab2x96(:,:,97))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(41),n2h48(69))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(98),h0tab(:,98),[32,1,2,8,20],[0,nMW,nMB,0,0],5,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,98),heltab2x96(:,:,98))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(42),n2h48(70))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(99),h0tab(:,99),[32,8,2,1,20],[0,nMB,nMW,0,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(43),m3h2x48(:,99),heltab2x96(:,:,99))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(100),h0tab(:,100),[32,2,1,20,8],[nMT,0,0,nMW,nMT],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,100),heltab2x96(:,:,100))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(44),n2h48(71))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(101),h0tab(:,101),[32,2,1,20,8],[nMB,nMW,0,0,nMB],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,101),heltab2x96(:,:,101))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(45),n2h48(72))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(102),h0tab(:,102),[32,1,8,2,20],[0,0,nMB,nMW,0],5,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,102),heltab2x96(:,:,102))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(46),n2h48(73))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(103),h0tab(:,103),[32,1,8,2,20],[0,nMW,nMT,0,0],5,1,wf6(:,8))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,103),heltab2x96(:,:,103))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(47),n2h48(74))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(104),h0tab(:,104),[32,2,8,1,20],[0,nMT,nMW,0,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(48),m3h2x48(:,104),heltab2x96(:,:,104))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(105),h0tab(:,105),[32,2,20,1,8],[nMT,0,0,nMW,nMT],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,105),heltab2x96(:,:,105))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(49),n2h48(75))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(106),h0tab(:,106),[32,2,20,1,8],[nMB,nMW,0,0,nMB],5,1,wf6(:,8))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,106),heltab2x96(:,:,106))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(50),n2h48(76))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(107),h0tab(:,107),[32,1,20,8,2],[0,0,nMW,nMT,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(51),m3h2x48(:,107),heltab2x96(:,:,107))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(32)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(108),h0tab(:,108),[32,1,20,2,8],[0,0,nMW,nMB,0],5,1,wf6(:,8))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(52),m3h2x48(:,108),heltab2x96(:,:,108))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(109),h0tab(:,109),[32,2,1,4,24],[nMT,0,0,nMW,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,109),heltab2x96(:,:,109))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(53),n2h48(77))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(110),h0tab(:,110),[32,2,1,4,24],[nMB,nMW,0,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,110),heltab2x96(:,:,110))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(54),n2h48(78))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(111),h0tab(:,111),[32,4,1,2,24],[0,0,nMW,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(55),m3h2x48(:,111),heltab2x96(:,:,111))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(112),h0tab(:,112),[32,1,2,24,4],[0,0,nMT,nMW,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,112),heltab2x96(:,:,112))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(56),n2h48(79))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(113),h0tab(:,113),[32,1,2,24,4],[0,nMW,nMB,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,113),heltab2x96(:,:,113))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(57),n2h48(80))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(114),h0tab(:,114),[32,1,4,2,24],[0,0,nMW,nMB,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(58),m3h2x48(:,114),heltab2x96(:,:,114))
Gcoeff(:)%j = (c(6)*(-M(1,:)%j+M(4,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(115),h0tab(:,115),[32,1,4,24,2],[0,0,nMW,nMT,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(59),m3h2x48(:,115),heltab2x96(:,:,115))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(116),h0tab(:,116),[32,2,4,1,24],[nMT,0,0,nMW,nMT],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,116),heltab2x96(:,:,116))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMT,G1H48(60),n2h48(81))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(117),h0tab(:,117),[32,2,4,1,24],[nMB,nMW,0,0,nMB],5,1,wf6(:,4))
  call Hloop_AV_Q(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,117),heltab2x96(:,:,117))
  call Hloop_A_Q(ntryL,G0H48(1),32,nMB,G1H48(61),n2h48(82))
Gcoeff(:)%j = (c(6)*(M(1,:)%j-M(4,:)%j)) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(118),h0tab(:,118),[32,2,24,1,4],[0,nMT,nMW,0,0],5,1,wf6(:,4))
  call Hloop_UV_W(ntryL,G0H96(1),0,ex6(:),32,G1H48(62),m3h2x48(:,118),heltab2x96(:,:,118))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(119),h0tab(:,119),[32,1,24,2,4],[0,0,nMB,nMW,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,119),heltab2x96(:,:,119))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(63),n2h48(83))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(10)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(120),h0tab(:,120),[32,1,24,2,4],[0,nMW,nMT,0,0],5,1,wf6(:,4))
  call Hloop_QV_A(ntryL,G0H96(1),ex6(:),G0H48(1),m3h2x48(:,120),heltab2x96(:,:,120))
  call Hloop_Q_A(ntryL,G0H48(1),32,0,G1H48(64),n2h48(84))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(121),h0tab(:,121),[33,8,2,4,16],[0,nMB,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(1),m3h4x24(:,1),heltab2x96(:,:,121))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(122),h0tab(:,122),[33,8,2,4,16],[nMW,nMT,0,0,0],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(2),m3h4x24(:,2),heltab2x96(:,:,122))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(123),h0tab(:,123),[33,4,2,8,16],[0,0,nMT,nMW,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,3),heltab2x96(:,:,123))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(24),n2h24(21))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(124),h0tab(:,124),[33,4,2,8,16],[0,0,nMT,nMW,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,4),heltab2x96(:,:,124))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(25),n2h24(22))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(125),h0tab(:,125),[33,4,2,16,8],[0,0,nMT,nMT,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,5),heltab2x96(:,:,125))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(26),n2h24(23))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(126),h0tab(:,126),[33,4,2,16,8],[0,nMW,nMB,nMB,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,6),heltab2x96(:,:,126))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(27),n2h24(24))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(127),h0tab(:,127),[33,4,8,2,16],[0,0,nMB,nMW,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,7),heltab2x96(:,:,127))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(28),n2h24(25))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(128),h0tab(:,128),[33,4,8,2,16],[0,0,nMB,nMW,nMW],5,1,wf4(:,10))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,8),heltab2x96(:,:,128))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(29),n2h24(26))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(129),h0tab(:,129),[33,4,16,2,8],[0,nMW,nMW,nMB,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,9),heltab2x96(:,:,129))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(30),n2h24(27))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(130),h0tab(:,130),[33,4,16,2,8],[0,nMW,nMW,nMB,0],5,1,wf4(:,10))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,10),heltab2x96(:,:,130))
  call Hloop_A_Q(ntryL,G0H24(3),33,0,G1H24(31),n2h24(28))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(131),h0tab(:,131),[33,2,8,4,16],[0,nMT,nMW,0,0],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(3),m3h4x24(:,11),heltab2x96(:,:,131))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(132),h0tab(:,132),[33,2,8,4,16],[nMW,nMB,0,0,0],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(4),m3h4x24(:,12),heltab2x96(:,:,132))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(133),h0tab(:,133),[33,2,8,16,4],[0,nMT,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(5),m3h4x24(:,13),heltab2x96(:,:,133))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(134),h0tab(:,134),[33,2,8,16,4],[0,nMT,nMW,nMW,0],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(6),m3h4x24(:,14),heltab2x96(:,:,134))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(135),h0tab(:,135),[33,2,16,8,4],[0,nMT,nMT,nMW,0],5,1,wf4(:,10))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,10),G0H24(7),m3h4x24(:,15),heltab2x96(:,:,135))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(2,:)%j) * den(31)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(136),h0tab(:,136),[33,2,16,8,4],[nMW,nMB,nMB,0,0],5,1,wf4(:,10))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,10),G0H24(8),m3h4x24(:,16),heltab2x96(:,:,136))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(137),h0tab(:,137),[34,8,1,4,16],[nMB,0,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,5),G0H24(9),ngPbt,m3h4x24(:,17),heltab2x96(:,:,137))
  call Hloop_Q_A(ntryL,G0H24(9),34,nMB,G1H24(32),n2h24(29))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(138),h0tab(:,138),[34,8,1,4,16],[nMB,0,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,5),G0H24(9),m3h4x24(:,18),heltab2x96(:,:,138))
  call Hloop_Q_A(ntryL,G0H24(9),34,nMB,G1H24(33),n2h24(30))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(139),h0tab(:,139),[34,4,1,8,16],[0,0,nMW,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(9),m3h4x24(:,19),heltab2x96(:,:,139))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(140),h0tab(:,140),[34,4,1,8,16],[nMW,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,5),G0H24(10),m3h4x24(:,20),heltab2x96(:,:,140))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(141),h0tab(:,141),[34,8,4,1,16],[nMB,0,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_SQ_A(ntryL,G0H96(1),wf4(:,5),G0H24(11),ngPbt,m3h4x24(:,21),heltab2x96(:,:,141))
  call Hloop_Q_A(ntryL,G0H24(11),34,nMB,G1H24(34),n2h24(31))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(142),h0tab(:,142),[34,8,4,1,16],[nMB,0,0,nMW,nMW],5,1,wf4(:,5))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,5),G0H24(11),m3h4x24(:,22),heltab2x96(:,:,142))
  call Hloop_Q_A(ntryL,G0H24(11),34,nMB,G1H24(35),n2h24(32))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(143),h0tab(:,143),[34,4,1,16,8],[0,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(11),m3h4x24(:,23),heltab2x96(:,:,143))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(144),h0tab(:,144),[34,4,1,16,8],[0,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(12),m3h4x24(:,24),heltab2x96(:,:,144))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(145),h0tab(:,145),[34,1,4,8,16],[0,0,nMW,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(13),m3h4x24(:,25),heltab2x96(:,:,145))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(146),h0tab(:,146),[34,1,4,8,16],[nMW,0,0,nMB,nMB],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,5),G0H24(14),m3h4x24(:,26),heltab2x96(:,:,146))
Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(13)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(147),h0tab(:,147),[34,1,4,16,8],[0,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(15),m3h4x24(:,27),heltab2x96(:,:,147))
Gcoeff(:)%j = (-(c(4)*M(1,:)%j)+c(3)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(148),h0tab(:,148),[34,1,4,16,8],[0,0,nMW,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(16),m3h4x24(:,28),heltab2x96(:,:,148))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(149),h0tab(:,149),[34,4,16,1,8],[nMW,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,5),G0H24(17),m3h4x24(:,29),heltab2x96(:,:,149))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(150),h0tab(:,150),[34,4,16,1,8],[0,0,0,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(18),m3h4x24(:,30),heltab2x96(:,:,150))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(151),h0tab(:,151),[34,1,16,4,8],[0,0,0,nMW,nMT],5,1,wf4(:,5))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,5),G0H24(19),m3h4x24(:,31),heltab2x96(:,:,151))
Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(8)*M(3,:)%j) * den(9)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(152),h0tab(:,152),[34,1,16,4,8],[nMW,0,0,0,nMB],5,1,wf4(:,5))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,5),G0H24(20),m3h4x24(:,32),heltab2x96(:,:,152))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(153),h0tab(:,153),[36,8,2,1,16],[nMW,nMT,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,8),G0H24(21),m3h4x24(:,33),heltab2x96(:,:,153))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(154),h0tab(:,154),[36,8,2,1,16],[0,nMB,nMW,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,8),G0H24(22),m3h4x24(:,34),heltab2x96(:,:,154))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(155),h0tab(:,155),[36,1,2,8,16],[0,0,nMT,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(23),m3h4x24(:,35),heltab2x96(:,:,155))
  call Hloop_Q_A(ntryL,G0H24(23),36,0,G1H24(36),n2h24(33))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(156),h0tab(:,156),[36,1,2,8,16],[0,0,nMT,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(23),m3h4x24(:,36),heltab2x96(:,:,156))
  call Hloop_Q_A(ntryL,G0H24(23),36,0,G1H24(37),n2h24(34))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(157),h0tab(:,157),[36,1,2,16,8],[0,0,nMT,nMT,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(23),m3h4x24(:,37),heltab2x96(:,:,157))
  call Hloop_Q_A(ntryL,G0H24(23),36,0,G1H24(38),n2h24(35))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(158),h0tab(:,158),[36,1,2,16,8],[0,nMW,nMB,nMB,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(23),m3h4x24(:,38),heltab2x96(:,:,158))
  call Hloop_Q_A(ntryL,G0H24(23),36,0,G1H24(39),n2h24(36))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(159),h0tab(:,159),[36,2,8,1,16],[nMW,nMB,0,0,0],5,1,wf4(:,8))
  call Hloop_AQ_W(ntryL,G0H96(1),wf4(:,8),G0H24(23),m3h4x24(:,39),heltab2x96(:,:,159))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(160),h0tab(:,160),[36,2,8,1,16],[0,nMT,nMW,0,0],5,1,wf4(:,8))
  call Hloop_AQ_V(ntryL,G0H96(1),wf4(:,8),G0H24(24),m3h4x24(:,40),heltab2x96(:,:,160))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(161),h0tab(:,161),[36,1,8,2,16],[0,0,nMB,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,41),heltab2x96(:,:,161))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(40),n2h24(37))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(162),h0tab(:,162),[36,1,8,2,16],[0,0,nMB,nMW,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,42),heltab2x96(:,:,162))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(41),n2h24(38))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(163),h0tab(:,163),[36,1,8,16,2],[0,nMW,nMT,nMT,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,43),heltab2x96(:,:,163))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(1),n2h24(39))
Gcoeff(:)%j = (c(8)*M(2,:)%j-c(9)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(164),h0tab(:,164),[36,1,8,16,2],[0,0,nMB,nMB,nMW],5,1,wf4(:,8))
  call Hloop_WQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,44),heltab2x96(:,:,164))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(3),n2h24(40))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(165),h0tab(:,165),[36,1,16,2,8],[0,nMW,nMW,nMB,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,45),heltab2x96(:,:,165))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(4),n2h24(41))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(166),h0tab(:,166),[36,1,16,2,8],[0,nMW,nMW,nMB,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,46),heltab2x96(:,:,166))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(5),n2h24(42))
Gcoeff(:)%j = (c(13)*M(2,:)%j-c(14)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(167),h0tab(:,167),[36,1,16,8,2],[0,nMW,nMW,nMT,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,47),heltab2x96(:,:,167))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(6),n2h24(43))
Gcoeff(:)%j = (c(3)*M(2,:)%j-c(4)*M(4,:)%j) * den(25)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(168),h0tab(:,168),[36,1,16,8,2],[0,nMW,nMW,nMT,0],5,1,wf4(:,8))
  call Hloop_VQ_A(ntryL,G0H96(1),wf4(:,8),G0H24(25),m3h4x24(:,48),heltab2x96(:,:,168))
  call Hloop_Q_A(ntryL,G0H24(25),36,0,G1H24(7),n2h24(44))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(169),h0tab(:,169),[40,4,1,2,16],[nMW,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,3),G0H24(25),m3h4x24(:,49),heltab2x96(:,:,169))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(170),h0tab(:,170),[40,4,1,2,16],[0,0,nMW,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(26),m3h4x24(:,50),heltab2x96(:,:,170))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(171),h0tab(:,171),[40,2,1,4,16],[nMT,0,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),ngPbt,m3h4x24(:,51),heltab2x96(:,:,171))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMT,G1H24(9),n2h24(45))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(172),h0tab(:,172),[40,2,1,4,16],[nMT,0,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,52),heltab2x96(:,:,172))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMT,G1H24(10),n2h24(46))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(173),h0tab(:,173),[40,2,1,16,4],[nMT,0,0,0,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,53),heltab2x96(:,:,173))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMT,G1H24(11),n2h24(47))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(174),h0tab(:,174),[40,2,1,16,4],[nMB,nMW,0,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,54),heltab2x96(:,:,174))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMB,G1H24(12),n2h24(48))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(175),h0tab(:,175),[40,2,4,1,16],[nMT,0,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_SA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),ngPbt,m3h4x24(:,55),heltab2x96(:,:,175))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMT,G1H24(13),n2h24(49))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(176),h0tab(:,176),[40,2,4,1,16],[nMT,0,0,nMW,nMW],5,1,wf4(:,3))
  call Hloop_WA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,56),heltab2x96(:,:,176))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMT,G1H24(15),n2h24(50))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(177),h0tab(:,177),[40,2,16,1,4],[nMB,nMW,nMW,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,57),heltab2x96(:,:,177))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMB,G1H24(16),n2h24(51))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(178),h0tab(:,178),[40,2,16,1,4],[nMB,nMW,nMW,0,0],5,1,wf4(:,3))
  call Hloop_VA_Q(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,58),heltab2x96(:,:,178))
  call Hloop_A_Q(ntryL,G0H24(27),40,nMB,G1H24(17),n2h24(52))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(179),h0tab(:,179),[40,1,4,2,16],[nMW,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,3),G0H24(27),m3h4x24(:,59),heltab2x96(:,:,179))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(180),h0tab(:,180),[40,1,4,2,16],[0,0,nMW,nMB,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(28),m3h4x24(:,60),heltab2x96(:,:,180))
Gcoeff(:)%j = (c(13)*M(3,:)%j-c(14)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(181),h0tab(:,181),[40,1,4,16,2],[0,0,nMW,nMW,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(29),m3h4x24(:,61),heltab2x96(:,:,181))
Gcoeff(:)%j = (c(3)*M(3,:)%j-c(4)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(182),h0tab(:,182),[40,1,4,16,2],[0,0,nMW,nMW,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(30),m3h4x24(:,62),heltab2x96(:,:,182))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(183),h0tab(:,183),[40,1,16,4,2],[0,0,0,nMW,nMB],5,1,wf4(:,3))
  call Hloop_QA_V(ntryL,G0H96(1),wf4(:,3),G0H24(31),m3h4x24(:,63),heltab2x96(:,:,183))
Gcoeff(:)%j = (c(8)*M(3,:)%j-c(9)*M(4,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H96(1),m0h(184),h0tab(:,184),[40,1,16,4,2],[nMW,0,0,0,nMT],5,1,wf4(:,3))
  call Hloop_QA_W(ntryL,G0H96(1),wf4(:,3),G0H24(32),m3h4x24(:,64),heltab2x96(:,:,184))
  call Hloop_QZ_A(ntryL,G1H24(2),ex5(:),G1H8(5),ngZd,m3h3x8(:,25),heltab2x24(:,:,73))
  call Hloop_Q_A(ntryL,G1H8(5),52,0,G2H8(5),n2h8(21))
  call Hloop_QZ_A(ntryL,G1H24(8),ex5(:),G1H8(1),ngZu,m3h3x8(:,26),heltab2x24(:,:,74))
  call Hloop_Q_A(ntryL,G1H8(1),50,nMT,G2H8(7),n2h8(22))
  call Hloop_AZ_Q(ntryL,G1H24(14),ex5(:),G1H8(7),ngZu,m3h3x8(:,27),heltab2x24(:,:,75))
  call Hloop_A_Q(ntryL,G1H8(7),49,0,G2H8(8),n2h8(23))
  call Hloop_AZ_Q(ntryL,G1H24(20),ex5(:),G1H8(8),ngZu,m3h3x8(:,28),heltab2x24(:,:,76))
  call Hloop_A_Q(ntryL,G1H8(8),49,0,G2H8(9),n2h8(24))
  call Hloop_AW_Q(ntryL,G1H48(1),wf4(:,1),G1H12(5),m3h4x12(:,1),heltab2x48(:,:,57))
  call Hloop_A_Q(ntryL,G1H12(5),37,nMT,G2H12(9),n2h12(49))
  call Hloop_QW_A(ntryL,G1H48(2),wf4(:,1),G1H12(6),m3h4x12(:,2),heltab2x48(:,:,58))
  call Hloop_Q_A(ntryL,G1H12(6),37,nMB,G2H12(10),n2h12(50))
  call Hloop_AQ_V(ntryL,G1H48(3),ex2(:),G1H24(18),m3h2x24(:,57),heltab2x48(:,:,59))
  call Hloop_AQ_V(ntryL,G1H48(4),ex2(:),G1H24(19),m3h2x24(:,58),heltab2x48(:,:,60))
  call Hloop_AW_Q(ntryL,G1H48(5),wf4(:,1),G1H12(9),m3h4x12(:,3),heltab2x48(:,:,61))
  call Hloop_A_Q(ntryL,G1H12(9),37,nMT,G2H12(11),n2h12(51))
  call Hloop_QA_V(ntryL,G1H48(6),ex4(:),G1H24(21),m3h2x24(:,59),heltab2x48(:,:,62))
  call Hloop_VQ_A(ntryL,G1H48(7),ex2(:),G1H24(22),m3h2x24(:,60),heltab2x48(:,:,63))
  call Hloop_Q_A(ntryL,G1H24(22),34,nMT,G2H24(1),n2h24(53))
  call Hloop_VQ_A(ntryL,G1H48(8),ex2(:),G1H24(23),m3h2x24(:,61),heltab2x48(:,:,64))
  call Hloop_Q_A(ntryL,G1H24(23),34,nMT,G2H24(2),n2h24(54))
  call Hloop_AQ_V(ntryL,G1H48(9),ex3(:),G1H24(2),m3h2x24(:,62),heltab2x48(:,:,65))
  call Hloop_AW_Q(ntryL,G1H48(10),wf4(:,6),G1H12(10),m3h4x12(:,4),heltab2x48(:,:,66))
  call Hloop_A_Q(ntryL,G1H12(10),42,0,G2H12(12),n2h12(52))
  call Hloop_QA_V(ntryL,G1H48(11),ex1(:),G1H24(8),m3h2x24(:,63),heltab2x48(:,:,67))
  call Hloop_QA_V(ntryL,G1H48(12),ex1(:),G1H24(14),m3h2x24(:,64),heltab2x48(:,:,68))
  call Hloop_QW_A(ntryL,G1H48(13),wf4(:,6),G1H12(11),m3h4x12(:,5),heltab2x48(:,:,69))
  call Hloop_Q_A(ntryL,G1H12(11),42,0,G2H12(13),n2h12(53))
  call Hloop_AQ_V(ntryL,G1H48(14),ex3(:),G1H24(20),m3h2x24(:,65),heltab2x48(:,:,70))
  call Hloop_VA_Q(ntryL,G1H48(15),ex1(:),G1H24(22),m3h2x24(:,66),heltab2x48(:,:,71))
  call Hloop_A_Q(ntryL,G1H24(22),33,0,G2H24(3),n2h24(55))
  call Hloop_VA_Q(ntryL,G1H48(16),ex1(:),G1H24(23),m3h2x24(:,67),heltab2x48(:,:,72))
  call Hloop_A_Q(ntryL,G1H24(23),33,0,G2H24(4),n2h24(56))
  call Hloop_AQ_W(ntryL,G1H48(17),ex3(:),G1H24(22),m3h2x24(:,68),heltab2x48(:,:,73))
  call Hloop_AQ_V(ntryL,G1H48(18),ex3(:),G1H24(23),m3h2x24(:,69),heltab2x48(:,:,74))
  call Hloop_VA_Q(ntryL,G1H48(19),ex4(:),G1H24(42),m3h2x24(:,70),heltab2x48(:,:,75))
  call Hloop_A_Q(ntryL,G1H24(42),40,nMB,G2H24(5),n2h24(57))
  call Hloop_AQ_V(ntryL,G1H48(20),ex2(:),G1H24(42),m3h2x24(:,71),heltab2x48(:,:,76))
  call Hloop_AQ_W(ntryL,G1H48(21),ex2(:),G1H24(43),m3h2x24(:,72),heltab2x48(:,:,77))
  call Hloop_VQ_A(ntryL,G1H48(22),ex2(:),G1H24(44),m3h2x24(:,73),heltab2x48(:,:,78))
  call Hloop_Q_A(ntryL,G1H24(44),34,nMT,G2H24(6),n2h24(58))
  call Hloop_VQ_A(ntryL,G1H48(23),ex2(:),G1H24(44),m3h2x24(:,74),heltab2x48(:,:,79))
  call Hloop_Q_A(ntryL,G1H24(44),34,nMT,G2H24(7),n2h24(59))
  call Hloop_AQ_W(ntryL,G1H48(24),ex3(:),G1H24(44),m3h2x24(:,75),heltab2x48(:,:,80))
  call Hloop_AQ_V(ntryL,G1H48(25),ex3(:),G1H24(45),m3h2x24(:,76),heltab2x48(:,:,81))
  call Hloop_VQ_A(ntryL,G1H48(26),ex3(:),G1H24(46),m3h2x24(:,77),heltab2x48(:,:,82))
  call Hloop_Q_A(ntryL,G1H24(46),36,0,G2H24(8),n2h24(60))
  call Hloop_AQ_V(ntryL,G1H48(27),ex2(:),G1H24(46),m3h2x24(:,78),heltab2x48(:,:,83))
  call Hloop_AQ_W(ntryL,G1H48(28),ex2(:),G1H24(47),m3h2x24(:,79),heltab2x48(:,:,84))
  call Hloop_VQ_A(ntryL,G1H48(29),ex3(:),G1H24(48),m3h2x24(:,80),heltab2x48(:,:,85))
  call Hloop_Q_A(ntryL,G1H24(48),36,0,G2H24(9),n2h24(61))
  call Hloop_QA_W(ntryL,G1H48(30),ex4(:),G1H24(48),m3h2x24(:,81),heltab2x48(:,:,86))
  call Hloop_QA_V(ntryL,G1H48(31),ex4(:),G1H24(49),m3h2x24(:,82),heltab2x48(:,:,87))
  call Hloop_VA_Q(ntryL,G1H48(32),ex1(:),G1H24(50),m3h2x24(:,83),heltab2x48(:,:,88))
  call Hloop_A_Q(ntryL,G1H24(50),33,0,G2H24(10),n2h24(62))
  call Hloop_VA_Q(ntryL,G1H48(33),ex1(:),G1H24(50),m3h2x24(:,84),heltab2x48(:,:,89))
  call Hloop_A_Q(ntryL,G1H24(50),33,0,G2H24(11),n2h24(63))
  call Hloop_QA_W(ntryL,G1H48(34),ex4(:),G1H24(50),m3h2x24(:,85),heltab2x48(:,:,90))
  call Hloop_QA_V(ntryL,G1H48(35),ex4(:),G1H24(51),m3h2x24(:,86),heltab2x48(:,:,91))
  call Hloop_VQ_A(ntryL,G1H48(36),ex3(:),G1H24(52),m3h2x24(:,87),heltab2x48(:,:,92))
  call Hloop_Q_A(ntryL,G1H24(52),36,0,G2H24(12),n2h24(64))
  call Hloop_QA_V(ntryL,G1H48(37),ex1(:),G1H24(52),m3h2x24(:,88),heltab2x48(:,:,93))
  call Hloop_QA_W(ntryL,G1H48(38),ex1(:),G1H24(53),m3h2x24(:,89),heltab2x48(:,:,94))
  call Hloop_QA_V(ntryL,G1H48(39),ex1(:),G1H24(54),m3h2x24(:,90),heltab2x48(:,:,95))
  call Hloop_QA_W(ntryL,G1H48(40),ex1(:),G1H24(55),m3h2x24(:,91),heltab2x48(:,:,96))
  call Hloop_QA_V(ntryL,G1H48(41),ex1(:),G1H24(56),m3h2x24(:,92),heltab2x48(:,:,97))
  call Hloop_QA_W(ntryL,G1H48(42),ex1(:),G1H24(57),m3h2x24(:,93),heltab2x48(:,:,98))
  call Hloop_VA_Q(ntryL,G1H48(43),ex4(:),G1H24(58),m3h2x24(:,94),heltab2x48(:,:,99))
  call Hloop_A_Q(ntryL,G1H24(58),40,nMB,G2H24(13),n2h24(65))
  call Hloop_AQ_V(ntryL,G1H48(44),ex2(:),G1H24(58),m3h2x24(:,95),heltab2x48(:,:,100))
  call Hloop_AQ_W(ntryL,G1H48(45),ex2(:),G1H24(59),m3h2x24(:,96),heltab2x48(:,:,101))
  call Hloop_QA_V(ntryL,G1H48(46),ex1(:),G1H24(60),m3h2x24(:,97),heltab2x48(:,:,102))
  call Hloop_QA_W(ntryL,G1H48(47),ex1(:),G1H24(61),m3h2x24(:,98),heltab2x48(:,:,103))
  call Hloop_VQ_A(ntryL,G1H48(48),ex2(:),G1H24(62),m3h2x24(:,99),heltab2x48(:,:,104))
  call Hloop_Q_A(ntryL,G1H24(62),34,nMT,G2H24(14),n2h24(66))
  call Hloop_AQ_V(ntryL,G1H48(49),ex2(:),G1H24(62),m3h2x24(:,100),heltab2x48(:,:,105))
  call Hloop_AQ_W(ntryL,G1H48(50),ex2(:),G1H24(63),m3h2x24(:,101),heltab2x48(:,:,106))
  call Hloop_VA_Q(ntryL,G1H48(51),ex1(:),G1H24(64),m3h2x24(:,102),heltab2x48(:,:,107))
  call Hloop_A_Q(ntryL,G1H24(64),33,0,G2H24(15),n2h24(67))
  call Hloop_VA_Q(ntryL,G1H48(52),ex1(:),G1H24(64),m3h2x24(:,103),heltab2x48(:,:,108))
  call Hloop_A_Q(ntryL,G1H24(64),33,0,G2H24(16),n2h24(68))
  call Hloop_AQ_V(ntryL,G1H48(53),ex2(:),G1H24(64),m3h2x24(:,104),heltab2x48(:,:,109))
  call Hloop_AQ_W(ntryL,G1H48(54),ex2(:),G1H24(65),m3h2x24(:,105),heltab2x48(:,:,110))
  call Hloop_VQ_A(ntryL,G1H48(55),ex3(:),G1H24(66),m3h2x24(:,106),heltab2x48(:,:,111))
  call Hloop_Q_A(ntryL,G1H24(66),36,0,G2H24(17),n2h24(69))
  call Hloop_QA_V(ntryL,G1H48(56),ex1(:),G1H24(66),m3h2x24(:,107),heltab2x48(:,:,112))
  call Hloop_QA_W(ntryL,G1H48(57),ex1(:),G1H24(67),m3h2x24(:,108),heltab2x48(:,:,113))
  call Hloop_VA_Q(ntryL,G1H48(58),ex1(:),G1H24(68),m3h2x24(:,109),heltab2x48(:,:,114))
  call Hloop_A_Q(ntryL,G1H24(68),33,0,G2H24(18),n2h24(70))
  call Hloop_VA_Q(ntryL,G1H48(59),ex1(:),G1H24(68),m3h2x24(:,110),heltab2x48(:,:,115))
  call Hloop_A_Q(ntryL,G1H24(68),33,0,G2H24(19),n2h24(71))
  call Hloop_AQ_V(ntryL,G1H48(60),ex2(:),G1H24(68),m3h2x24(:,111),heltab2x48(:,:,116))
  call Hloop_AQ_W(ntryL,G1H48(61),ex2(:),G1H24(69),m3h2x24(:,112),heltab2x48(:,:,117))
  call Hloop_VQ_A(ntryL,G1H48(62),ex2(:),G1H24(70),m3h2x24(:,113),heltab2x48(:,:,118))
  call Hloop_Q_A(ntryL,G1H24(70),34,nMT,G2H24(20),n2h24(72))
  call Hloop_QA_V(ntryL,G1H48(63),ex1(:),G1H24(70),m3h2x24(:,114),heltab2x48(:,:,119))
  call Hloop_QA_W(ntryL,G1H48(64),ex1(:),G1H24(71),m3h2x24(:,115),heltab2x48(:,:,120))
  call Hloop_VA_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,49),heltab2x24(:,:,77))
  call Hloop_A_Q(ntryL,G0H12(1),41,nMB,G1H12(12),n2h12(54))
  call Hloop_WA_Q(ntryL,G0H24(2),ex4(:),G0H12(1),m3h2x12(:,50),heltab2x24(:,:,78))
  call Hloop_A_Q(ntryL,G0H12(1),41,nMT,G1H12(15),n2h12(55))
  call Hloop_AQ_V(ntryL,G1H24(24),ex3(:),G1H12(16),m3h2x12(:,51),heltab2x24(:,:,79))
  call Hloop_AQ_V(ntryL,G1H24(25),ex3(:),G1H12(17),m3h2x12(:,52),heltab2x24(:,:,80))
  call Hloop_AQ_V(ntryL,G1H24(26),ex3(:),G1H12(18),m3h2x12(:,53),heltab2x24(:,:,81))
  call Hloop_AQ_W(ntryL,G1H24(27),ex3(:),G1H12(21),m3h2x12(:,54),heltab2x24(:,:,82))
  call Hloop_AQ_V(ntryL,G1H24(28),ex3(:),G1H12(22),m3h2x12(:,55),heltab2x24(:,:,83))
  call Hloop_AQ_V(ntryL,G1H24(29),ex3(:),G1H12(23),m3h2x12(:,56),heltab2x24(:,:,84))
  call Hloop_AQ_W(ntryL,G1H24(30),ex3(:),G1H12(24),m3h2x12(:,57),heltab2x24(:,:,85))
  call Hloop_AQ_W(ntryL,G1H24(31),ex3(:),G1H12(27),m3h2x12(:,58),heltab2x24(:,:,86))
  call Hloop_VQ_A(ntryL,G0H24(3),ex2(:),G0H12(1),m3h2x12(:,59),heltab2x24(:,:,87))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(28),n2h12(56))
  call Hloop_WQ_A(ntryL,G0H24(4),ex2(:),G0H12(1),m3h2x12(:,60),heltab2x24(:,:,88))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMB,G1H12(29),n2h12(57))
  call Hloop_VQ_A(ntryL,G0H24(5),ex2(:),G0H12(1),m3h2x12(:,61),heltab2x24(:,:,89))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(30),n2h12(58))
  call Hloop_VQ_A(ntryL,G0H24(6),ex2(:),G0H12(1),m3h2x12(:,62),heltab2x24(:,:,90))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(33),n2h12(59))
  call Hloop_VQ_A(ntryL,G0H24(7),ex2(:),G0H12(1),m3h2x12(:,63),heltab2x24(:,:,91))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMT,G1H12(34),n2h12(60))
  call Hloop_WQ_A(ntryL,G0H24(8),ex2(:),G0H12(1),m3h2x12(:,64),heltab2x24(:,:,92))
  call Hloop_Q_A(ntryL,G0H12(1),35,nMB,G1H12(35),n2h12(61))
  call Hloop_QA_V(ntryL,G1H24(32),ex4(:),G1H12(36),m3h2x12(:,65),heltab2x24(:,:,93))
  call Hloop_QA_V(ntryL,G1H24(33),ex4(:),G1H12(39),m3h2x12(:,66),heltab2x24(:,:,94))
  call Hloop_VQ_A(ntryL,G0H24(9),ex3(:),G0H12(1),m3h2x12(:,67),heltab2x24(:,:,95))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(40),n2h12(62))
  call Hloop_WQ_A(ntryL,G0H24(10),ex3(:),G0H12(1),m3h2x12(:,68),heltab2x24(:,:,96))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(41),n2h12(63))
  call Hloop_QA_V(ntryL,G1H24(34),ex4(:),G1H12(42),m3h2x12(:,69),heltab2x24(:,:,97))
  call Hloop_QA_V(ntryL,G1H24(35),ex4(:),G1H12(45),m3h2x12(:,70),heltab2x24(:,:,98))
  call Hloop_VQ_A(ntryL,G0H24(11),ex3(:),G0H12(1),m3h2x12(:,71),heltab2x24(:,:,99))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(46),n2h12(64))
  call Hloop_VQ_A(ntryL,G0H24(12),ex3(:),G0H12(1),m3h2x12(:,72),heltab2x24(:,:,100))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(47),n2h12(65))
  call Hloop_VA_Q(ntryL,G0H24(13),ex1(:),G0H12(1),m3h2x12(:,73),heltab2x24(:,:,101))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(48),n2h12(66))
  call Hloop_WA_Q(ntryL,G0H24(14),ex1(:),G0H12(1),m3h2x12(:,74),heltab2x24(:,:,102))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(51),n2h12(67))
  call Hloop_VA_Q(ntryL,G0H24(15),ex1(:),G0H12(1),m3h2x12(:,75),heltab2x24(:,:,103))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(52),n2h12(68))
  call Hloop_VA_Q(ntryL,G0H24(16),ex1(:),G0H12(1),m3h2x12(:,76),heltab2x24(:,:,104))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(53),n2h12(69))
  call Hloop_WQ_A(ntryL,G0H24(17),ex3(:),G0H12(1),m3h2x12(:,77),heltab2x24(:,:,105))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(54),n2h12(70))
  call Hloop_VQ_A(ntryL,G0H24(18),ex3(:),G0H12(1),m3h2x12(:,78),heltab2x24(:,:,106))
  call Hloop_Q_A(ntryL,G0H12(1),38,0,G1H12(57),n2h12(71))
  call Hloop_VA_Q(ntryL,G0H24(19),ex1(:),G0H12(1),m3h2x12(:,79),heltab2x24(:,:,107))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(58),n2h12(72))
  call Hloop_WA_Q(ntryL,G0H24(20),ex1(:),G0H12(1),m3h2x12(:,80),heltab2x24(:,:,108))
  call Hloop_A_Q(ntryL,G0H12(1),35,0,G1H12(59),n2h12(73))
  call Hloop_WA_Q(ntryL,G0H24(21),ex4(:),G0H12(1),m3h2x12(:,81),heltab2x24(:,:,109))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMT,G1H12(60),n2h12(74))
  call Hloop_VA_Q(ntryL,G0H24(22),ex4(:),G0H12(1),m3h2x12(:,82),heltab2x24(:,:,110))
  call Hloop_A_Q(ntryL,G0H12(1),44,nMB,G1H12(63),n2h12(75))
  call Hloop_QA_V(ntryL,G1H24(36),ex1(:),G1H12(64),m3h2x12(:,83),heltab2x24(:,:,111))
  call Hloop_QA_V(ntryL,G1H24(37),ex1(:),G1H12(65),m3h2x12(:,84),heltab2x24(:,:,112))
  call Hloop_QA_V(ntryL,G1H24(38),ex1(:),G1H12(66),m3h2x12(:,85),heltab2x24(:,:,113))
  call Hloop_QA_W(ntryL,G1H24(39),ex1(:),G1H12(69),m3h2x12(:,86),heltab2x24(:,:,114))
  call Hloop_WQ_A(ntryL,G0H24(23),ex2(:),G0H12(1),m3h2x12(:,87),heltab2x24(:,:,115))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMB,G1H12(70),n2h12(76))
  call Hloop_VQ_A(ntryL,G0H24(24),ex2(:),G0H12(1),m3h2x12(:,88),heltab2x24(:,:,116))
  call Hloop_Q_A(ntryL,G0H12(1),38,nMT,G1H12(71),n2h12(77))
  call Hloop_QA_V(ntryL,G1H24(40),ex1(:),G1H12(72),m3h2x12(:,89),heltab2x24(:,:,117))
  call Hloop_QA_V(ntryL,G1H24(41),ex1(:),G1H12(75),m3h2x12(:,90),heltab2x24(:,:,118))
  call Hloop_QA_W(ntryL,G1H24(1),ex1(:),G1H12(76),m3h2x12(:,91),heltab2x24(:,:,119))
  call Hloop_QA_V(ntryL,G1H24(3),ex1(:),G1H12(77),m3h2x12(:,92),heltab2x24(:,:,120))
  call Hloop_QA_W(ntryL,G1H24(4),ex1(:),G1H12(78),m3h2x12(:,93),heltab2x24(:,:,121))
  call Hloop_QA_W(ntryL,G1H24(5),ex1(:),G1H12(81),m3h2x12(:,94),heltab2x24(:,:,122))
  call Hloop_QA_W(ntryL,G1H24(6),ex1(:),G1H12(82),m3h2x12(:,95),heltab2x24(:,:,123))
  call Hloop_QA_W(ntryL,G1H24(7),ex1(:),G1H12(83),m3h2x12(:,96),heltab2x24(:,:,124))
  call Hloop_WQ_A(ntryL,G0H24(25),ex3(:),G0H12(1),m3h2x12(:,97),heltab2x24(:,:,125))
  call Hloop_Q_A(ntryL,G0H12(1),44,0,G1H12(84),n2h12(78))
  call Hloop_VQ_A(ntryL,G0H24(26),ex3(:),G0H12(1),m3h2x12(:,98),heltab2x24(:,:,126))
  call Hloop_Q_A(ntryL,G0H12(1),44,0,G1H12(87),n2h12(79))
  call Hloop_AQ_V(ntryL,G1H24(9),ex2(:),G1H12(88),m3h2x12(:,99),heltab2x24(:,:,127))
  call Hloop_AQ_V(ntryL,G1H24(10),ex2(:),G1H12(89),m3h2x12(:,100),heltab2x24(:,:,128))
  call Hloop_AQ_V(ntryL,G1H24(11),ex2(:),G1H12(90),m3h2x12(:,101),heltab2x24(:,:,129))
  call Hloop_AQ_W(ntryL,G1H24(12),ex2(:),G1H12(93),m3h2x12(:,102),heltab2x24(:,:,130))
  call Hloop_AQ_V(ntryL,G1H24(13),ex2(:),G1H12(94),m3h2x12(:,103),heltab2x24(:,:,131))
  call Hloop_AQ_V(ntryL,G1H24(15),ex2(:),G1H12(95),m3h2x12(:,104),heltab2x24(:,:,132))
  call Hloop_AQ_S(ntryL,G1H24(16),ex2(:),G1H12(96),ngPbt,m3h2x12(:,105),heltab2x24(:,:,133))
  call Hloop_AQ_W(ntryL,G1H24(17),ex2(:),G1H12(99),m3h2x12(:,106),heltab2x24(:,:,134))
  call Hloop_WA_Q(ntryL,G0H24(27),ex1(:),G0H12(1),m3h2x12(:,107),heltab2x24(:,:,135))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(100),n2h12(80))
  call Hloop_VA_Q(ntryL,G0H24(28),ex1(:),G0H12(1),m3h2x12(:,108),heltab2x24(:,:,136))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(5),n2h12(81))
  call Hloop_VA_Q(ntryL,G0H24(29),ex1(:),G0H12(1),m3h2x12(:,109),heltab2x24(:,:,137))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(6),n2h12(82))
  call Hloop_VA_Q(ntryL,G0H24(30),ex1(:),G0H12(1),m3h2x12(:,110),heltab2x24(:,:,138))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(9),n2h12(83))
  call Hloop_VA_Q(ntryL,G0H24(31),ex1(:),G0H12(1),m3h2x12(:,111),heltab2x24(:,:,139))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(10),n2h12(84))
  call Hloop_WA_Q(ntryL,G0H24(32),ex1(:),G0H12(1),m3h2x12(:,112),heltab2x24(:,:,140))
  call Hloop_A_Q(ntryL,G0H12(1),41,0,G1H12(11),n2h12(85))
call HGT_w2_OLR(G1H12(3),1,1,12)
call HGT_w2_invQ_OLR(G1H12(3),2,5,12)
  call ol_merge(ntryL,G1H12(3),[G1H12(10)])
  call ol_merge(ntryL,G1H12(58),[G1H12(13)])
call HGT_w2_OLR(G1H12(4),1,1,12)
call HGT_w2_invQ_OLR(G1H12(4),2,5,12)
  call ol_merge(ntryL,G1H12(4),[G1H12(58)])
  call ol_merge(ntryL,G1H12(69),[G1H12(7)])
  call ol_merge(ntryL,G1H12(50),[G1H12(8)])
  call ol_merge(ntryL,G1H12(59),[G1H12(19)])
  call ol_merge(ntryL,G1H12(34),[G1H12(25)])
  call ol_merge(ntryL,G1H12(35),[G1H12(31)])
  call ol_merge(ntryL,G1H12(81),[G1H12(37)])
  call ol_merge(ntryL,G1H12(56),[G1H12(38)])
  call ol_merge(ntryL,G1H12(21),[G1H12(49)])
  call ol_merge(ntryL,G1H12(27),[G1H12(55)])
  call ol_merge(ntryL,G1H12(57),[G1H12(73)])
  call ol_merge(ntryL,G1H12(54),[G1H12(79)])
call HGT_w2_OLR(G1H12(1),1,1,12)
call HGT_w2_invQ_OLR(G1H12(1),2,5,12)
  call Hloop_QZ_A(ntryL,G1H12(1),ex5(:),G1H4(12),ngZd,m3h3x4(:,41),heltab2x12(:,:,93))
  call Hloop_Q_A(ntryL,G1H4(12),60,0,G2H4(2),n2h4(58))
  call Hloop_QA_W(ntryL,G2H8(6),ex1(:),G2H4(5),m3h2x4(:,31),heltab2x8(:,:,31))
call HGT_w2_OLR(G1H12(2),1,1,12)
call HGT_w2_invQ_OLR(G1H12(2),2,5,12)
  call Hloop_QZ_A(ntryL,G1H12(2),ex5(:),G1H4(30),ngZu,m3h3x4(:,42),heltab2x12(:,:,94))
  call Hloop_Q_A(ntryL,G1H4(30),54,nMT,G2H4(6),n2h4(59))
  call Hloop_QA_W(ntryL,G2H8(10),ex4(:),G2H4(1),m3h2x4(:,32),heltab2x8(:,:,32))
  call Hloop_AZ_Q(ntryL,G1H12(3),ex5(:),G1H4(42),ngZu,m3h3x4(:,43),heltab2x12(:,:,95))
  call Hloop_A_Q(ntryL,G1H4(42),57,0,G2H4(38),n2h4(60))
  call Hloop_AQ_W(ntryL,G2H8(14),ex3(:),G2H4(3),m3h2x4(:,33),heltab2x8(:,:,33))
  call Hloop_AZ_Q(ntryL,G1H12(4),ex5(:),G1H4(54),ngZu,m3h3x4(:,44),heltab2x12(:,:,96))
  call Hloop_A_Q(ntryL,G1H4(54),51,0,G2H4(4),n2h4(61))
  call Hloop_AQ_W(ntryL,G2H8(18),ex3(:),G2H4(63),m3h2x4(:,34),heltab2x8(:,:,34))
  call Hloop_WQ_A(ntryL,G1H12(69),ex2(:),G1H6(134),m3h2x6(:,53),heltab2x12(:,:,97))
  call Hloop_Q_A(ntryL,G1H6(134),39,nMB,G2H6(21),n2h6(41))
  call Hloop_WQ_A(ntryL,G1H12(50),ex2(:),G1H6(146),m3h2x6(:,54),heltab2x12(:,:,98))
  call Hloop_Q_A(ntryL,G1H6(146),39,nMB,G2H6(22),n2h6(42))
  call Hloop_AZ_Q(ntryL,G1H12(14),ex5(:),G1H4(66),ngZu,m3h3x4(:,45),heltab2x12(:,:,99))
  call Hloop_A_Q(ntryL,G1H4(66),51,0,G2H4(67),n2h4(62))
  call Hloop_AZ_Q(ntryL,G1H12(59),ex5(:),G1H4(78),ngZd,m3h3x4(:,46),heltab2x12(:,:,100))
  call Hloop_A_Q(ntryL,G1H4(78),51,0,G2H4(7),n2h4(63))
  call Hloop_AZ_Q(ntryL,G1H12(20),ex5(:),G1H4(96),ngZd,m3h3x4(:,47),heltab2x12(:,:,101))
  call Hloop_A_Q(ntryL,G1H4(96),51,0,G2H4(9),n2h4(64))
  call Hloop_QZ_A(ntryL,G1H12(34),ex5(:),G1H4(108),ngZu,m3h3x4(:,48),heltab2x12(:,:,102))
  call Hloop_Q_A(ntryL,G1H4(108),51,nMT,G2H4(10),n2h4(65))
  call Hloop_QZ_A(ntryL,G1H12(26),ex5(:),G1H4(1),ngZu,m3h3x4(:,49),heltab2x12(:,:,103))
  call Hloop_Q_A(ntryL,G1H4(1),51,nMT,G2H4(12),n2h4(66))
  call Hloop_QZ_A(ntryL,G1H12(35),ex5(:),G1H4(2),ngZd,m3h3x4(:,50),heltab2x12(:,:,104))
  call Hloop_Q_A(ntryL,G1H4(2),51,nMB,G2H4(13),n2h4(67))
  call Hloop_QZ_A(ntryL,G1H12(32),ex5(:),G1H4(6),ngZd,m3h3x4(:,51),heltab2x12(:,:,105))
  call Hloop_Q_A(ntryL,G1H4(6),51,nMB,G2H4(15),n2h4(68))
  call Hloop_WQ_A(ntryL,G1H8(2),ex3(:),G1H4(7),m3h2x4(:,35),heltab2x8(:,:,35))
  call Hloop_Q_A(ntryL,G1H4(7),54,0,G2H4(16),n2h4(69))
  call Hloop_WQ_A(ntryL,G1H8(6),ex3(:),G1H4(8),m3h2x4(:,36),heltab2x8(:,:,36))
  call Hloop_Q_A(ntryL,G1H4(8),54,0,G2H4(18),n2h4(70))
  call Hloop_UV_W(ntryL,G1H12(81),37,ex5(:),16,G2H4(19),m3h3x4(:,52),heltab2x12(:,:,106))
  call Hloop_UV_W(ntryL,G1H12(56),37,ex5(:),16,G2H4(21),m3h3x4(:,53),heltab2x12(:,:,107))
  call Hloop_UW_V(ntryL,G1H12(43),42,ex5(:),16,G2H4(22),m3h3x4(:,54),heltab2x12(:,:,108))
  call Hloop_UW_V(ntryL,G1H12(44),42,ex5(:),16,G2H4(24),m3h3x4(:,55),heltab2x12(:,:,109))
  call Hloop_WA_Q(ntryL,G1H8(11),ex1(:),G1H4(85),m3h2x4(:,37),heltab2x8(:,:,37))
  call Hloop_A_Q(ntryL,G1H4(85),51,0,G2H4(25),n2h4(71))
  call Hloop_WA_Q(ntryL,G1H8(12),ex1(:),G1H4(13),m3h2x4(:,38),heltab2x8(:,:,38))
  call Hloop_A_Q(ntryL,G1H4(13),51,0,G2H4(27),n2h4(72))
  call Hloop_WQ_A(ntryL,G1H12(21),ex2(:),G1H6(158),m3h2x6(:,55),heltab2x12(:,:,110))
  call Hloop_Q_A(ntryL,G1H6(158),39,nMB,G2H6(23),n2h6(43))
  call Hloop_UV_W(ntryL,G1H12(27),37,ex5(:),16,G2H4(28),m3h3x4(:,56),heltab2x12(:,:,111))
  call Hloop_UV_W(ntryL,G1H12(61),37,ex5(:),16,G2H4(30),m3h3x4(:,57),heltab2x12(:,:,112))
  call Hloop_UV_W(ntryL,G1H12(62),37,ex5(:),16,G2H4(31),m3h3x4(:,58),heltab2x12(:,:,113))
  call Hloop_WA_Q(ntryL,G1H12(67),ex4(:),G1H6(170),m3h2x6(:,56),heltab2x12(:,:,114))
  call Hloop_A_Q(ntryL,G1H6(170),45,nMT,G2H6(24),n2h6(44))
  call Hloop_WA_Q(ntryL,G1H12(68),ex4(:),G1H6(9),m3h2x6(:,57),heltab2x12(:,:,115))
  call Hloop_A_Q(ntryL,G1H6(9),45,nMT,G2H6(25),n2h6(45))
  call Hloop_QZ_A(ntryL,G1H12(57),ex5(:),G1H4(14),ngZd,m3h3x4(:,59),heltab2x12(:,:,116))
  call Hloop_Q_A(ntryL,G1H4(14),54,0,G2H4(34),n2h4(73))
  call Hloop_QZ_A(ntryL,G1H12(74),ex5(:),G1H4(18),ngZd,m3h3x4(:,60),heltab2x12(:,:,117))



end subroutine vamp_1

end module ol_vamp_1_pptzjj_uxtdbxzg_1_/**/REALKIND
