
module ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(17,1), K2(17,1), KL(17,2), Cas(5)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
  integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [   9]
  K1( 2,:) = [  12]
  K1( 3,:) = [   0]
  K1( 4,:) = [  12]
  K1( 5,:) = [ -12]
  K1( 6,:) = [   0]
  K1( 7,:) = [  12]
  K1( 8,:) = [   0]
  K1( 9,:) = [ -12]
  K1(10,:) = [   0]
  K1(11,:) = [  12]
  K1(12,:) = [   0]
  K1(13,:) = [   0]
  K1(14,:) = [   0]
  K1(15,:) = [   0]
  K1(16,:) = [   0]
  K1(17,:) = [   0]

  K2( 1,:) = [   9]
  K2( 2,:) = [  12]
  K2( 3,:) = [   0]
  K2( 4,:) = [  12]
  K2( 5,:) = [ -12]
  K2( 6,:) = [   0]
  K2( 7,:) = [  12]
  K2( 8,:) = [   0]
  K2( 9,:) = [ -12]
  K2(10,:) = [   0]
  K2(11,:) = [  12]
  K2(12,:) = [   0]
  K2(13,:) = [   0]
  K2(14,:) = [   0]
  K2(15,:) = [   0]
  K2(16,:) = [   0]
  K2(17,:) = [   0]

  KL( 1,:) = [   9,   3]
  KL( 2,:) = [  12,   4]
  KL( 3,:) = [   0,  -4]
  KL( 4,:) = [  12,   4]
  KL( 5,:) = [ -12,  -4]
  KL( 6,:) = [   0,   4]
  KL( 7,:) = [  12,   4]
  KL( 8,:) = [   0,   4]
  KL( 9,:) = [ -12,  -4]
  KL(10,:) = [   0,  -4]
  KL(11,:) = [  12,   4]
  KL(12,:) = [   0,   0]
  KL(13,:) = [   0,   0]
  KL(14,:) = [   0,   0]
  KL(15,:) = [   0,   0]
  KL(16,:) = [   0,   0]
  KL(17,:) = [   0,   0]

  co = 0
  do k = 1, 5
    co = co + k
    Cas(k) = K1(1+1*co,1)/K1(1,1)
  end do

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND



module ol_forced_parameters_pptzj_utxdxbz_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMZ /= 0) write(*,101) 'wMZ = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptzj_utxdxbz_1_/**/REALKIND
! **********************************************************************
module ol_loop_storage_pptzj_utxdxbz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1, ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer(intkind2), parameter :: nheltot = 48 ! number of helicity configurations
  integer(intkind2), save :: nhel = 48 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(48) ! physical helicity states
#endif

  complex(REALKIND), save :: den(31)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(3)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,7), wf6(6,20), wf8(8,17), wf12(12,15), wf48(48,32)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(18), c(9)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(2,48), M0M1_hel_cc(2,48,16)
  complex(REALKIND), save :: M2ctcc(16)

end module ol_loop_storage_pptzj_utxdxbz_1_/**/REALKIND






! **********************************************************************
module ol_loop_pptzj_utxdxbz_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptzj_utxdxbz_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = -(CI*countertermnorm*ctSqq*eQED**3*gQCD**2*(cw - sw)*(cw + sw))/(4._/**/REALKIND*cw*MW**2*sw**3)
    f( 2) = (CI*cw*eQED**3)/(2._/**/REALKIND*sw**3)
    f( 3) = (CI*countertermnorm*ctVbt*cw*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 4) = (CI*countertermnorm*ctVqq*cw*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**3)
    f( 5) = (CI*eQED**3)/(2._/**/REALKIND*sw**2)
    f( 6) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 7) = (CI*countertermnorm*ctVbb*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 8) = (CI*countertermnorm*ctVbt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f( 9) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(10) = (CI*countertermnorm*ctVtt*eQED**3*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(11) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(12) = (CI*eQED**3)/(2._/**/REALKIND*cw*sw)
    f(13) = (CI*countertermnorm*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(14) = (CI*countertermnorm*ctSqq*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(15) = (CI*countertermnorm*ctVqq*eQED**3*gQCD**2)/(2._/**/REALKIND*cw*sw)
    f(16) = (cw*eQED**3*gQCD**2*integralnorm*SwB)/(sw**3*2._/**/REALKIND)
    f(17) = (eQED**3*gQCD**2*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(18) = (eQED**3*gQCD**2*integralnorm*SwB)/(cw*sw*2._/**/REALKIND)

  c = [ f(16), 3*f(16), 8*f(16), f(17), 3*f(17), 8*f(17), f(18), 3*f(18), 8*f(18) ]
  c = (1._/**/REALKIND / 6) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5) - MW2)+L(6,5))
  den(2) = 1 /((L(5,10) - MW2)+L(6,10))
  den(4) = 1 /((L(5,18) - MT2)+L(6,18))
  den(6) = 1 /((L(5,24) - MB2)+L(6,24))
  den(8) = 1 /((L(5,17))+L(6,17))
  den(10) = 1 /((L(5,20))+L(6,20))
  den(12) = 1 /((L(5,13) - MT2)+L(6,13))
  den(15) = 1 /((L(5,7) - MB2)+L(6,7))
  den(18) = 1 /((L(5,14))+L(6,14))
  den(21) = 1 /((L(5,11))+L(6,11))
  den(24) = 1 /((L(5,21) - MW2)+L(6,21))
  den(26) = 1 /((L(5,26) - MW2)+L(6,26))

  ! denominators
  den(3) = den(1)*den(2)
  den(5) = den(1)*den(4)
  den(7) = den(1)*den(6)
  den(9) = den(2)*den(8)
  den(11) = den(2)*den(10)
  den(13) = den(1)*den(12)
  den(14) = den(4)*den(13)
  den(16) = den(1)*den(15)
  den(17) = den(6)*den(16)
  den(19) = den(2)*den(18)
  den(20) = den(8)*den(19)
  den(22) = den(2)*den(21)
  den(23) = den(10)*den(22)
  den(25) = den(1)*den(24)
  den(27) = den(2)*den(26)
  den(28) = den(8)*den(24)
  den(29) = den(4)*den(26)
  den(30) = den(10)*den(24)
  den(31) = den(6)*den(26)

end subroutine denominators

!
!
!
!
!
! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptzj_utxdxbz_1_/**/DREALKIND, only: ntry, nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for up anti-top anti-down bottom Z -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptzj_utxdxbz_1, only: external_perm_pptzj_utxdxbz_1, &
    & external_perm_inv_pptzj_utxdxbz_1, extcomb_perm_pptzj_utxdxbz_1, &
    & average_factor_pptzj_utxdxbz_1
  use ol_external_pptzj_utxdxbz_1, only: H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptzj_utxdxbz_1_/**/REALKIND, only: check_forced_parameters
  use ol_heltables_OLR_pptzj_utxdxbz_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,5)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(16)
  logical, intent(in) :: qp_kinematics

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,5)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,5)
#endif
  integer           :: extmasses2(5)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(16)
  complex(REALKIND) :: M1(1), M2(1)
  real(REALKIND)    :: P_scatt_intern(0:3,5)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(1,48)
  type(Hpolcont) :: M1helarray_ct(1,48)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(16), nextcombs, ind_cc_comb(5)

  type(Hpolcont) :: A(48,32)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(32)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ 0, nMT, 0, nMB, nMZ ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, external_perm_inv_pptzj_utxdxbz_1, 5, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rZERO, H1, ex1, POLSEL(1),1)
  call pol_wf_A(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rZERO, H3, ex3, POLSEL(3),3)
  call pol_wf_Q(P(:,4), rMB, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rMZ, H5, ex5, POLSEL(5),5)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_W(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gPtb,ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_VV_S(ntry, wf4(:,1), ex5(:), wf12(:,1), n3(:,3), t3x12(:,:,1))
  call vert_QA_W(ntry, ex4(:), ex2(:), wf4(:,3), n3(:,4), t3x4(:,:,3))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,1), 5, wf12(:,2), n3(:,5), t3x12(:,:,2))
  call vert_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,1), n3(:,6), t3x6(:,:,1))
  call prop_A_Q(ntry, wf6(:,1), 18, MT, 1_intkind1, wf6(:,2), n2(1))
  call vert_WQ_A(ntry, wf4(:,1), ex4(:), wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_ZQ_A(gZd,ntry, ex5(:), ex4(:), wf6(:,3), n3(:,8), t3x6(:,:,2))
  call prop_Q_A(ntry, wf6(:,3), 24, MB, 1_intkind1, wf6(:,4), n2(2))
  call vert_AW_Q(ntry, ex2(:), wf4(:,1), wf8(:,2), n3(:,9), t3x8(:,:,2))
  call vert_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,5), n3(:,10), t3x6(:,:,3))
  call prop_Q_A(ntry, wf6(:,5), 17, ZERO, 0_intkind1, wf6(:,6), n2(3))
  call vert_QA_W(ntry, wf6(:,6), ex3(:), wf12(:,3), n3(:,11), t3x12(:,:,3))
  call vert_AZ_Q(gZd,ntry, ex3(:), ex5(:), wf6(:,7), n3(:,12), t3x6(:,:,4))
  call prop_A_Q(ntry, wf6(:,7), 20, ZERO, 0_intkind1, wf6(:,8), n2(4))
  call vert_WQ_A(ntry, wf4(:,3), ex1(:), wf8(:,3), n3(:,13), t3x8(:,:,3))
  call counter_WQ_A(ntry, wf4(:,1), ex4(:), wf8(:,4), n3(:,14), t3x8(:,:,4))
  call counter_ZQ_A(gZd,ntry, ex5(:), ex4(:), wf6(:,9), n3(:,15), t3x6(:,:,5))
  call prop_Q_A(ntry, wf6(:,9), 24, MB, 1_intkind1, wf6(:,10), n2(5))
  call counter_AQ_S(gPdu,ntry, ex3(:), wf6(:,6), wf12(:,4), n3(:,16), t3x12(:,:,4))
  call counter_QA_W(ntry, wf6(:,6), ex3(:), wf12(:,5), n3(:,17), t3x12(:,:,5))
  call counter_AZ_Q(gZd,ntry, ex3(:), ex5(:), wf6(:,11), n3(:,18), t3x6(:,:,6))
  call prop_A_Q(ntry, wf6(:,11), 20, ZERO, 0_intkind1, wf6(:,12), n2(6))
  call counter_AW_Q(ntry, ex2(:), wf4(:,1), wf8(:,5), n3(:,19), t3x8(:,:,5))
  call counter_AZ_Q(gZu,ntry, ex2(:), ex5(:), wf6(:,13), n3(:,20), t3x6(:,:,7))
  call prop_A_Q(ntry, wf6(:,13), 18, MT, 1_intkind1, wf6(:,14), n2(7))
  call counter_AQ_S(ctStb,ntry, ex2(:), ex4(:), wf4(:,4), n3(:,21), t3x4(:,:,4))
  call counter_QA_W(ntry, ex4(:), ex2(:), wf4(:,5), n3(:,22), t3x4(:,:,5))
  call vert_WQ_A(ntry, wf4(:,5), ex1(:), wf8(:,6), n3(:,23), t3x8(:,:,6))
  call counter_QS_A(gPdu,ntry, ex1(:), wf4(:,2), wf8(:,7), n3(:,24), t3x8(:,:,7))
  call counter_WQ_A(ntry, wf4(:,3), ex1(:), wf8(:,8), n3(:,25), t3x8(:,:,8))
  call counter_ZQ_A(gZu,ntry, ex5(:), ex1(:), wf6(:,15), n3(:,26), t3x6(:,:,8))
  call prop_Q_A(ntry, wf6(:,15), 17, ZERO, 0_intkind1, wf6(:,16), n2(8))
  call vert_QA_W(ntry, wf6(:,16), ex3(:), wf12(:,6), n3(:,27), t3x12(:,:,6))
  call counter_AQ_S(gPdu,ntry, ex3(:), ex1(:), wf4(:,6), n3(:,28), t3x4(:,:,6))
  call vert_VS_T(ntry, ex5(:), 16, wf4(:,6), 5, wf12(:,7), n3(:,29), t3x12(:,:,7))
  call vert_SV_V(ntry, wf4(:,6), ex5(:), wf12(:,8), n3(:,30), t3x12(:,:,8))
  call counter_QA_W(ntry, ex1(:), ex3(:), wf4(:,7), n3(:,31), t3x4(:,:,7))
  call vert_VV_S(ntry, wf4(:,7), ex5(:), wf12(:,9), n3(:,32), t3x12(:,:,9))
  call vert_UV_W(ntry, ex5(:), 16, wf4(:,7), 5, wf12(:,10), n3(:,33), t3x12(:,:,10))
  call vert_QS_A(gPtb,ntry, ex4(:), wf4(:,6), wf8(:,9), n3(:,34), t3x8(:,:,9))
  call vert_WQ_A(ntry, wf4(:,7), ex4(:), wf8(:,10), n3(:,35), t3x8(:,:,10))
  call vert_SA_Q(gPtb,ntry, wf4(:,6), ex2(:), wf8(:,11), n3(:,36), t3x8(:,:,11))
  call vert_AW_Q(ntry, ex2(:), wf4(:,7), wf8(:,12), n3(:,37), t3x8(:,:,12))
  call counter_A_Q(cttt,6,ntry, wf6(:,2), 18, wf6(:,17), n2(9))
  call prop_Q_A(ntry, wf8(:,1), 13, MT, 1_intkind1, wf8(:,13), n2(10))
  call counter_Q_A(ctbb,5,ntry, wf6(:,4), 24, wf6(:,18), n2(11))
  call prop_A_Q(ntry, wf8(:,2), 7, MB, 1_intkind1, wf8(:,14), n2(12))
  call vert_AW_Q(ntry, ex3(:), wf4(:,3), wf8(:,15), n3(:,38), t3x8(:,:,13))
  call counter_Q_A(ctqq,2,ntry, wf6(:,6), 17, wf6(:,19), n2(13))
  call prop_A_Q(ntry, wf8(:,15), 14, ZERO, 0_intkind1, wf8(:,16), n2(14))
  call counter_A_Q(ctqq,1,ntry, wf6(:,8), 20, wf6(:,20), n2(15))
  call prop_Q_A(ntry, wf8(:,3), 11, ZERO, 0_intkind1, wf8(:,17), n2(16))
  call vert_SV_V(ntry, wf4(:,2), ex5(:), wf12(:,11), n3(:,39), t3x12(:,:,11))
  call vert_UV_W(ntry, wf4(:,3), 10, ex5(:), 16, wf12(:,12), n3(:,40), t3x12(:,:,12))
  call vert_QA_W(ntry, ex4(:), wf6(:,2), wf12(:,13), n3(:,41), t3x12(:,:,13))
  call vert_QA_W(ntry, ex1(:), wf6(:,8), wf12(:,14), n3(:,42), t3x12(:,:,14))
  call vert_QA_W(ntry, wf6(:,4), ex2(:), wf12(:,15), n3(:,43), t3x12(:,:,15))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf6)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf12)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 16-1)]
  nextcombs = 5*(5+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptzj_utxdxbz_1(extcombs(k))
  end do

  !!Born-loop colour correlators interference
  ind_cc_comb = [8,12,9,13,14]
  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 5
    M2add_ct = 0 
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5
integer :: n

n=0

do i5= 1, 3
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf
 end if
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_SS(nsync, wf4(:,2), wf12(:,1), A(:,1), n3(:,44), t3x48(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,2), A(:,2), n3(:,45), t3x48(:,:,2), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,1), A(:,3), n3(:,46), t3x48(:,:,3), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,2), A(:,4), n3(:,47), t3x48(:,:,4), nhel, den(7))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,3), A(:,5), n3(:,48), t3x48(:,:,5), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,3), A(:,6), n3(:,49), t3x48(:,:,6), nhel, den(11))

    call Hcont_QA(nsync, wf6(:,2), wf8(:,4), A(:,7), n3(:,50), t3x48(:,:,7), nhel, den(5))
    call Hcont_QA(nsync, wf8(:,2), wf6(:,10), A(:,8), n3(:,51), t3x48(:,:,8), nhel, den(7))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,4), A(:,9), n3(:,52), t3x48(:,:,9), nhel, den(9))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,5), A(:,10), n3(:,53), t3x48(:,:,10), nhel, den(9))
    call Hcont_QA(nsync, wf8(:,3), wf6(:,12), A(:,11), n3(:,54), t3x48(:,:,11), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,5), A(:,12), n3(:,55), t3x48(:,:,12), nhel, den(7))
    call Hcont_QA(nsync, wf8(:,1), wf6(:,14), A(:,13), n3(:,56), t3x48(:,:,13), nhel, den(5))
    call Hcont_SS(nsync, wf12(:,1), wf4(:,4), A(:,14), n3(:,57), t3x48(:,:,14), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,2), wf4(:,5), A(:,15), n3(:,58), t3x48(:,:,15), nhel, den(3))
    call Hcont_VV(nsync, wf12(:,3), wf4(:,5), A(:,16), n3(:,59), t3x48(:,:,16), nhel, den(9))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,6), A(:,17), n3(:,60), t3x48(:,:,17), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,7), A(:,18), n3(:,61), t3x48(:,:,18), nhel, den(11))
    call Hcont_QA(nsync, wf6(:,8), wf8(:,8), A(:,19), n3(:,62), t3x48(:,:,19), nhel, den(11))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,6), A(:,20), n3(:,63), t3x48(:,:,20), nhel, den(9))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,7), A(:,21), n3(:,64), t3x48(:,:,21), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,8), A(:,22), n3(:,65), t3x48(:,:,22), nhel, den(3))
    call Hcont_SS(nsync, wf4(:,2), wf12(:,9), A(:,23), n3(:,66), t3x48(:,:,23), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,3), wf12(:,10), A(:,24), n3(:,67), t3x48(:,:,24), nhel, den(3))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,9), A(:,25), n3(:,68), t3x48(:,:,25), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,2), wf8(:,10), A(:,26), n3(:,69), t3x48(:,:,26), nhel, den(5))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,11), A(:,27), n3(:,70), t3x48(:,:,27), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,4), wf8(:,12), A(:,28), n3(:,71), t3x48(:,:,28), nhel, den(7))
    call Hcont_QA(nsync, wf6(:,17), wf8(:,13), A(:,29), n3(:,72), t3x48(:,:,29), nhel, den(14))
    call Hcont_QA(nsync, wf6(:,18), wf8(:,14), A(:,30), n3(:,73), t3x48(:,:,30), nhel, den(17))
    call Hcont_QA(nsync, wf6(:,19), wf8(:,16), A(:,31), n3(:,74), t3x48(:,:,31), nhel, den(20))
    call Hcont_QA(nsync, wf6(:,20), wf8(:,17), A(:,32), n3(:,75), t3x48(:,:,32), nhel, den(23))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(1), M2(1) ! M1helarray(1,48)
  integer :: empty(0), i

  M1(1)%j = -(A(j,2)%j*f(2))+(-A(j,3)%j-A(j,4)%j-A(j,5)%j-A(j,6)%j)*f(5)+A(j,1)%j*f(12)

  M2(1)%j = A(j,21)%j*f(1)-A(j,15)%j*f(3)-A(j,24)%j*f(4)+(A(j,29)%j+A(j,30)%j+A(j,31)%j+A(j,32)%j)*f(6)-A(j,8)%j*f(7)+(-A(j,7)%j &
       -A(j,12)%j-A(j,16)%j-A(j,17)%j)*f(8)+(-A(j,10)%j-A(j,11)%j-A(j,19)%j-A(j,20)%j-A(j,26)%j-A(j,28)%j)*f(9)-A(j,13)%j*f(10)+( &
       -A(j,9)%j-A(j,18)%j-A(j,25)%j-A(j,27)%j)*f(11)+A(j,14)%j*f(13)-A(j,22)%j*f(14)+A(j,23)%j*f(15)


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 1
      do j = 1, 1
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(1), Mct(1)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 1
    do j = 1, 1
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+1*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(1)
  real(REALKIND),    intent(out) :: M2IRadd(16)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 17-1
    colmatpos = 1*k
    do i = 1, 1
      do j = 1, 1
	      M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(1)
  complex(REALKIND), intent(in)  :: M2(1)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 1
    do j = 1, 1
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptzj_utxdxbz_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(1)
  type(Hpolcont), intent(out)  :: M0_col(2)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 2 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 1 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+1*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptzj_utxdxbz_1_/**/REALKIND
