
module ol_vamp_1_pptwj_tddxbxw_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptwj_tddxbxw_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptwj_tddxbxw_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptwj_tddxbxw_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptwj_tddxbxw_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_pptwj_tddxbxw_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptwj_tddxbxw_1_/**/DREALKIND, only: &
    & p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels, ntryL, hel_states
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(hel_states)
  type(Hpolcont), intent(in) :: M(2,hel_states)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel(1:hel_states)
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel(1:hel_states)
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(1),h0tab(:,1),[16,1,2,4,8],[nMT,0,0,0,nMB],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,1),heltab2x48(:,:,1))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(1))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(2),h0tab(:,2),[16,1,4,2,8],[nMT,0,0,0,nMB],5,0)
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,2),heltab2x48(:,:,2))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(2))
  call Hloop_AQ_V(ntryL,G1H16(1),ex1(:),G1H8(1),m3h2x8(:,1),heltab2x16(:,:,1))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(2),m3h2x8(:,2),heltab2x16(:,:,2))
  call Hloop_VQ_A(ntryL,G1H8(1),ex2(:),G1H4(1),m3h2x4(:,1),heltab2x8(:,:,1))
  call Hloop_Q_A(ntryL,G1H4(1),19,0,G2H4(1),n2h4(1))
  call Hloop_VA_Q(ntryL,G1H8(2),ex3(:),G1H4(1),m3h2x4(:,2),heltab2x8(:,:,2))
  call Hloop_A_Q(ntryL,G1H4(1),21,0,G2H4(2),n2h4(2))
  call Hloop_QA_V(ntryL,G2H4(1),ex3(:),G2H2(1),m3h2x2(:,1),heltab2x4(:,:,1))
  call Hloop_AQ_V(ntryL,G2H4(2),ex2(:),G2H2(2),m3h2x2(:,2),heltab2x4(:,:,2))
  call Hotf_5pt_reduction(G2H2(1),RedSet_5(1),mass5set(:,1),  & 
G1H2(1),G1H2(2),G1H2(3),G1H2(4),G1H2(5),G1H2(6),2)
  call HG1shiftOLR(G1H2(2),8,2)
  call Hotf_5pt_reduction(G2H2(2),RedSet_5(2),mass5set(:,1),  & 
G1H2(7),G1H2(8),G1H2(9),G1H2(10),G1H2(11),G1H2(12),2)
  call HG1shiftOLR(G1H2(8),8,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(1))
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(2),n2h1(2))
  call Hloop_VA_Q(ntryL,G1H2(6),ex4(:),G1H1(1),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(3))
  call Hloop_VA_Q(ntryL,G1H2(7),ex4(:),G1H1(1),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(4))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,5),heltab2x2(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(5),n2h1(5))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,6),heltab2x2(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(6),n2h1(6))
  call Hotf_5pt_reduction_last(G2tensor(1),RedSet_5(1),mass5set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5),G1tensor(6))
  call G_TensorShift(G1tensor(2),8)
  call Hotf_5pt_reduction_last(G2tensor(4),RedSet_5(2),mass5set(:,1),  & 
G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10),G1tensor(11),G1tensor(12))
  call G_TensorShift(G1tensor(8),8)
  call ol_merge_tensors(T1sum(1),[G1tensor(1)])
  call ol_merge_tensors(T1sum(2),[G1tensor(7)])
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(3),h0tab(:,3),[16,1,8,6],[nMT,0,nMB,nMB],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,3),heltab2x48(:,:,3))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(3))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(4),h0tab(:,4),[16,6,1,8],[nMT,nMT,0,nMB],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,4),heltab2x48(:,:,4))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(4))
  Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(5),h0tab(:,5),[16,1,6,8],[nMT,0,0,nMB],4,1,wf4(:,1))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,5),heltab2x48(:,:,5))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(3),n2h16(5))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(6),h0tab(:,6),[17,4,2,8],[0,0,0,nMB],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(1),m3h6x8(:,1),heltab2x48(:,:,6))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(7),h0tab(:,7),[17,2,4,8],[0,0,0,nMB],4,1,wf6(:,2))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(2),m3h6x8(:,2),heltab2x48(:,:,7))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(7)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(8),h0tab(:,8),[24,1,2,4],[nMT,0,0,0],4,1,wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(3),m3h6x8(:,3),heltab2x48(:,:,8))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(1),n2h8(1))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)-c(11)*M(2,:)%j) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(9),h0tab(:,9),[24,1,4,2],[nMT,0,0,0],4,1,wf6(:,4))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(3),m3h6x8(:,4),heltab2x48(:,:,9))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(2),n2h8(2))
  call Hloop_AQ_V(ntryL,G1H16(1),ex1(:),G1H8(3),m3h2x8(:,3),heltab2x16(:,:,3))
  call Hloop_AV_Q(ntryL,G1H16(2),wf4(:,1),G1H4(1),m3h4x4(:,1),heltab2x16(:,:,4))
  call Hloop_A_Q(ntryL,G1H4(1),22,nMT,G2H4(1),n2h4(3))
  call Hloop_AQ_V(ntryL,G1H16(3),ex1(:),G1H8(4),m3h2x8(:,4),heltab2x16(:,:,5))
  call Hloop_VA_Q(ntryL,G0H8(1),ex3(:),G0H4(1),m3h2x4(:,3),heltab2x8(:,:,3))
  call Hloop_A_Q(ntryL,G0H4(1),21,0,G1H4(1),n2h4(4))
  call Hloop_VQ_A(ntryL,G0H8(2),ex2(:),G0H4(1),m3h2x4(:,4),heltab2x8(:,:,4))
  call Hloop_Q_A(ntryL,G0H4(1),19,0,G1H4(2),n2h4(5))
  call Hloop_AQ_V(ntryL,G1H8(1),ex1(:),G1H4(3),m3h2x4(:,5),heltab2x8(:,:,5))
  call Hloop_AQ_V(ntryL,G1H8(2),ex1(:),G1H4(4),m3h2x4(:,6),heltab2x8(:,:,6))
  call Hloop_VA_Q(ntryL,G1H8(3),ex4(:),G1H4(5),m3h2x4(:,7),heltab2x8(:,:,7))
  call Hloop_A_Q(ntryL,G1H4(5),25,nMB,G2H4(2),n2h4(6))
  call Hloop_AQ_V(ntryL,G2H4(1),ex1(:),G2H2(1),m3h2x2(:,3),heltab2x4(:,:,3))
  call Hloop_UV_W(ntryL,G1H8(4),17,wf4(:,1),6,G2H2(2),m3h4x2(:,1),heltab2x8(:,:,8))
  call Hloop_AQ_V(ntryL,G1H4(1),ex2(:),G1H2(1),m3h2x2(:,4),heltab2x4(:,:,4))
  call Hloop_QA_V(ntryL,G1H4(2),ex3(:),G1H2(2),m3h2x2(:,5),heltab2x4(:,:,5))
  call Hloop_VQ_A(ntryL,G1H4(3),ex2(:),G1H2(6),m3h2x2(:,6),heltab2x4(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(6),27,0,G2H2(3),n2h2(1))
  call Hloop_VA_Q(ntryL,G1H4(4),ex3(:),G1H2(7),m3h2x2(:,7),heltab2x4(:,:,7))
  call Hloop_A_Q(ntryL,G1H2(7),29,0,G2H2(4),n2h2(2))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(2),[G1H2(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G2H2(2),[G1H2(11),G1H2(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(1),[G1H2(9)])
  call Hloop_VA_Q(ntryL,G1H2(2),ex4(:),G1H1(1),m3h2x1(:,7),heltab2x2(:,:,7))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(1),n2h1(7))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,8),heltab2x2(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(4),n2h1(8))
  call Hotf_4pt_reduction(G2H2(2),RedSet_4(3),mass4set(:,1),  & 
G1H2(8),G1H2(12),G1H2(6),G1H2(7),G1H2(3),2)
  call HG1shiftOLR(G1H2(12),8,2)
  call Hloop_VA_Q(ntryL,G1H2(1),ex4(:),G1H1(1),m3h2x1(:,9),heltab2x2(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(7),n2h1(9))
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,10),heltab2x2(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(8),n2h1(10))
  call Hotf_4pt_reduction(G2H4(2),RedSet_4(10),mass4set(:,2),  & 
G1H4(5),G1H4(1),G1H4(2),G1H4(3),G1H4(4),4)
  call HG1shiftOLR(G1H4(1),6,4)
  call Hotf_4pt_reduction(G2H2(1),RedSet_4(11),mass4set(:,3),  & 
G1H2(11),G1H2(5),G1H2(9),G1H2(2),G1H2(4),2)
  call HG1shiftOLR(G1H2(5),8,2)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex3(:),G2tensor(9),m3h2x1(:,11),heltab2x2(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H2(4),ex2(:),G2tensor(10),m3h2x1(:,12),heltab2x2(:,:,12))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,13),heltab2x2(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(11))
  call Hloop_VA_Q(ntryL,G1H2(12),ex4(:),G1H1(1),m3h2x1(:,14),heltab2x2(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(12),n2h1(12))
  call Hloop_VA_Q(ntryL,G1H2(3),ex4(:),G1H1(1),m3h2x1(:,15),heltab2x2(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(13),n2h1(13))
  call Hloop_AV_Q(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,1),heltab2x4(:,:,8))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(14),n2h1(14))
  call Hloop_AV_Q(ntryL,G1H4(1),wf4(:,1),G1H1(1),m3h4x1(:,2),heltab2x4(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),6,nMB,G2tensor(15),n2h1(15))
  call Hloop_AV_Q(ntryL,G1H4(4),wf4(:,1),G1H1(1),m3h4x1(:,3),heltab2x4(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(16),n2h1(16))
  call Hloop_VA_Q(ntryL,G1H2(11),ex4(:),G1H1(1),m3h2x1(:,16),heltab2x2(:,:,16))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(17),n2h1(17))
  call Hloop_VA_Q(ntryL,G1H2(5),ex4(:),G1H1(1),m3h2x1(:,17),heltab2x2(:,:,17))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),8,nMB,G2tensor(18),n2h1(18))
  call Hloop_VA_Q(ntryL,G1H2(4),ex4(:),G1H1(1),m3h2x1(:,18),heltab2x2(:,:,18))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(19),n2h1(19))
  call ol_merge_tensors(G2tensor(9),[G2tensor(2),G1tensor(2)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(6)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(5),G1tensor(8)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(12)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(3)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(4)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(11),G1tensor(5)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(9)])
  call ol_merge_tensors(G2tensor(8),[G1tensor(10)])
  call Hotf_4pt_reduction_last(G2tensor(9),RedSet_4(12),mass4set(:,4),  & 
G1tensor(1),G1tensor(7),G1tensor(2),G1tensor(6),G1tensor(8))
  call G_TensorShift(G1tensor(7),4)
  call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(4),mass4set(:,1),  & 
G1tensor(12),G1tensor(3),G1tensor(4),G1tensor(11),G1tensor(5))
  call G_TensorShift(G1tensor(3),12)
  call Hotf_4pt_reduction_last(G2tensor(10),RedSet_4(13),mass4set(:,4),  & 
G1tensor(9),G1tensor(10),G1tensor(13),G1tensor(14),G1tensor(15))
  call G_TensorShift(G1tensor(10),2)
  call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(8),mass4set(:,1),  & 
G1tensor(16),G1tensor(17),G1tensor(18),G1tensor(19),G1tensor(20))
  call G_TensorShift(G1tensor(17),10)
  call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,5),  & 
G1tensor(21),G1tensor(22),G1tensor(23),G1tensor(24),G1tensor(25))
  call G_TensorShift(G1tensor(22),8)
  call Hotf_4pt_reduction_last(G2tensor(4),RedSet_4(2),mass4set(:,1),  & 
G1tensor(26),G1tensor(27),G1tensor(28),G1tensor(29),G1tensor(30))
  call G_TensorShift(G1tensor(27),8)
  call Hotf_4pt_reduction_last(G2tensor(11),RedSet_4(3),mass4set(:,1),  & 
G1tensor(31),G1tensor(32),G1tensor(33),G1tensor(34),G1tensor(35))
  call G_TensorShift(G1tensor(32),8)
  call Hotf_4pt_reduction_last(G2tensor(7),RedSet_4(6),mass4set(:,5),  & 
G1tensor(36),G1tensor(37),G1tensor(38),G1tensor(39),G1tensor(40))
  call G_TensorShift(G1tensor(37),8)
  call Hotf_4pt_reduction_last(G2tensor(8),RedSet_4(7),mass4set(:,1),  & 
G1tensor(41),G1tensor(42),G1tensor(43),G1tensor(44),G1tensor(45))
  call G_TensorShift(G1tensor(42),8)
  call Hotf_4pt_reduction_last(G2tensor(14),RedSet_4(10),mass4set(:,2),  & 
G1tensor(46),G1tensor(47),G1tensor(48),G1tensor(49),G1tensor(50))
  call G_TensorShift(G1tensor(47),6)
  call Hotf_4pt_reduction_last(G2tensor(17),RedSet_4(11),mass4set(:,3),  & 
G1tensor(51),G1tensor(52),G1tensor(53),G1tensor(54),G1tensor(55))
  call G_TensorShift(G1tensor(52),8)
  call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(12),mass4set(:,4),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
  call Hotf_4pt_reduction_last(G1tensor(12),RedSet_4(4),mass4set(:,1),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
  call Hotf_4pt_reduction_last(G1tensor(9),RedSet_4(13),mass4set(:,4),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
  call Hotf_4pt_reduction_last(G1tensor(16),RedSet_4(8),mass4set(:,1),  & 
G0tensor(16),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20))
  call Hotf_4pt_reduction_last(G1tensor(21),RedSet_4(1),mass4set(:,5),  & 
G0tensor(21),G0tensor(22),G0tensor(23),G0tensor(24),G0tensor(25))
  call Hotf_4pt_reduction_last(G1tensor(26),RedSet_4(2),mass4set(:,1),  & 
G0tensor(26),G0tensor(27),G0tensor(28),G0tensor(29),G0tensor(30))
  call Hotf_4pt_reduction_last(G1tensor(31),RedSet_4(3),mass4set(:,1),  & 
G0tensor(31),G0tensor(32),G0tensor(33),G0tensor(34),G0tensor(35))
  call Hotf_4pt_reduction_last(G1tensor(36),RedSet_4(6),mass4set(:,5),  & 
G0tensor(36),G0tensor(37),G0tensor(38),G0tensor(39),G0tensor(40))
  call Hotf_4pt_reduction_last(G1tensor(41),RedSet_4(7),mass4set(:,1),  & 
G0tensor(41),G0tensor(42),G0tensor(43),G0tensor(44),G0tensor(45))
  call Hotf_4pt_reduction_last(G1tensor(46),RedSet_4(10),mass4set(:,2),  & 
G0tensor(46),G0tensor(47),G0tensor(48),G0tensor(49),G0tensor(50))
  call Hotf_4pt_reduction_last(G1tensor(51),RedSet_4(11),mass4set(:,3),  & 
G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),G0tensor(55))
  call ol_merge_tensors(T0sum(1),[G0tensor(1)])
  call ol_merge_tensors(T0sum(2),[G0tensor(6)])
  call ol_merge_tensors(T0sum(3),[G0tensor(11)])
  call ol_merge_tensors(T0sum(4),[G0tensor(16)])
  call ol_merge_tensors(T0sum(5),[G0tensor(21)])
  call ol_merge_tensors(T0sum(6),[G0tensor(26)])
  call ol_merge_tensors(T0sum(7),[G0tensor(31)])
  call ol_merge_tensors(T0sum(8),[G0tensor(36)])
  call ol_merge_tensors(T0sum(9),[G0tensor(41)])
  call ol_merge_tensors(T0sum(10),[G0tensor(46)])
  call ol_merge_tensors(T0sum(11),[G0tensor(51)])
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(10),h0tab(:,10),[17,6,8],[nMB,nMB,0],3,2,wf6(:,2),wf4(:,1))
  call Hloop_VQ_A(ntryL,G0H48(1),wf6(:,2),G0H8(3),m3h6x8(:,5),heltab2x48(:,:,10))
  call Hloop_Q_A(ntryL,G0H8(3),17,nMB,G1H8(1),n2h8(3))
  Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(3)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(11),h0tab(:,11),[17,6,8],[0,0,nMB],3,2,wf6(:,2),wf4(:,1))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(1),m3h6x8(:,6),heltab2x48(:,:,11))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(12),h0tab(:,12),[24,1,6],[0,nMT,nMT],3,2,wf6(:,4),wf4(:,1))
  call Hloop_QA_V(ntryL,G0H48(1),wf6(:,4),G0H8(2),m3h6x8(:,7),heltab2x48(:,:,12))
  Gcoeff(:)%j = (c(1)*M(1,:)%j-c(2)*M(2,:)%j) * den(5)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(13),h0tab(:,13),[24,1,6],[nMT,0,0],3,2,wf6(:,4),wf4(:,1))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(3),m3h6x8(:,8),heltab2x48(:,:,13))
  call Hloop_A_Q(ntryL,G0H8(3),24,nMT,G1H8(2),n2h8(4))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(15)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(14),h0tab(:,14),[16,7,8],[nMT,0,nMB],3,1,wf8(:,6))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,6),heltab2x48(:,:,14))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(1),n2h16(6))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(7)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(15),h0tab(:,15),[16,1,14],[nMT,0,nMB],3,1,wf8(:,5))
  call Hloop_AW_Q(ntryL,G0H48(1),ex5(:),G0H16(1),m3h3x16(:,7),heltab2x48(:,:,15))
  call Hloop_A_Q(ntryL,G0H16(1),16,nMT,G1H16(2),n2h16(7))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(16),h0tab(:,16),[25,2,4],[0,0,0],3,1,wf12(:,1))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,1),G0H4(1),m3h12x4(:,1),heltab2x48(:,:,16))
  call Hloop_A_Q(ntryL,G0H4(1),25,0,G1H4(5),n2h4(7))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(17),h0tab(:,17),[25,2,4],[0,0,0],3,1,wf12(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,1),25,G1H4(1),m3h12x4(:,2),heltab2x48(:,:,17))
  Gcoeff(:)%j = (-(c(5)*M(1,:)%j)+c(6)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(18),h0tab(:,18),[25,2,4],[0,0,0],3,1,wf12(:,4))
  call Hloop_AV_Q(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,3),heltab2x48(:,:,18))
  call Hloop_A_Q(ntryL,G0H4(1),25,0,G1H4(4),n2h4(8))
  Gcoeff(:)%j = (-(c(1)*M(1,:)%j)+c(2)*M(2,:)%j) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(19),h0tab(:,19),[25,2,4],[0,0,0],3,1,wf12(:,4))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,4),25,G1H4(6),m3h12x4(:,4),heltab2x48(:,:,19))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(4),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(6),[G1H4(1)])
  call Hloop_QV_A(ntryL,G1H8(1),wf4(:,1),G1H2(1),m3h4x2(:,2),heltab2x8(:,:,9))
  call Hloop_Q_A(ntryL,G1H2(1),23,nMB,G2H2(2),n2h2(3))
  call Hloop_UV_W(ntryL,G0H8(1),17,wf4(:,1),6,G1H2(10),m3h4x2(:,3),heltab2x8(:,:,10))
  call Hloop_VQ_A(ntryL,G0H8(2),ex1(:),G0H4(1),m3h2x4(:,8),heltab2x8(:,:,11))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(5),n2h4(9))
  call Hloop_AQ_V(ntryL,G1H8(2),ex1(:),G1H4(1),m3h2x4(:,9),heltab2x8(:,:,12))
  call Hloop_AQ_V(ntryL,G1H16(1),wf8(:,6),G1H2(8),m3h8x2(:,1),heltab2x16(:,:,6))
  call Hloop_AQ_V(ntryL,G1H16(2),ex1(:),G1H8(3),m3h2x8(:,5),heltab2x16(:,:,7))
  call Hloop_AQ_V(ntryL,G1H4(4),ex2(:),G1H2(12),m3h2x2(:,8),heltab2x4(:,:,11))
  call Hloop_VQ_A(ntryL,G1H4(6),ex2(:),G1H2(3),m3h2x2(:,9),heltab2x4(:,:,12))
  call Hloop_Q_A(ntryL,G1H2(3),27,0,G2H2(1),n2h2(4))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(10),[G1H2(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H2(8),[G1H2(2),G1H2(7)])
  call Hloop_VA_Q(ntryL,G1H2(10),ex4(:),G1H1(1),m3h2x1(:,19),heltab2x2(:,:,19))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(2),n2h1(20))
  call Hloop_VA_Q(ntryL,G1H2(8),ex4(:),G1H1(1),m3h2x1(:,20),heltab2x2(:,:,20))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(5),n2h1(21))
  call Hloop_AV_Q(ntryL,G1H4(2),wf4(:,1),G1H1(1),m3h4x1(:,4),heltab2x4(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(9),n2h1(22))
  call Hloop_AV_Q(ntryL,G1H4(3),wf4(:,1),G1H1(1),m3h4x1(:,5),heltab2x4(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(3),n2h1(23))
  call Hloop_VA_Q(ntryL,G1H2(9),ex4(:),G1H1(1),m3h2x1(:,21),heltab2x2(:,:,21))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(10),n2h1(24))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex4(:),G2tensor(6),m3h2x1(:,22),heltab2x2(:,:,22))
  call Hloop_QV_A(ntryL,G1H4(5),wf4(:,1),G1H1(1),m3h4x1(:,6),heltab2x4(:,:,15))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(1),n2h1(25))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(1),25,wf4(:,1),6,G2tensor(4),m3h4x1(:,7),heltab2x4(:,:,16))
  call Hloop_VA_Q(ntryL,G1H8(3),wf8(:,5),G1H1(1),m3h8x1(:,1),heltab2x8(:,:,13))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(11),n2h1(26))
  call Hloop_VA_Q(ntryL,G1H2(12),ex3(:),G1H1(1),m3h2x1(:,23),heltab2x2(:,:,23))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),31,0,G2tensor(7),n2h1(27))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex3(:),G2tensor(8),m3h2x1(:,24),heltab2x2(:,:,24))
  call ol_merge_tensors(G2tensor(4),[G2tensor(12),G1tensor(32),G1tensor(15),G1tensor(8),G0tensor(32),G0tensor(15),G0tensor(5)])
  call ol_merge_tensors(G2tensor(11),[G2tensor(16),G2tensor(13),G1tensor(50),G1tensor(35),G1tensor(20),G1tensor(5),G0tensor(50) &
    ,G0tensor(35),G0tensor(20),G0tensor(10)])
  call ol_merge_tensors(G2tensor(10),[G2tensor(15),G1tensor(53),G1tensor(47),G0tensor(53),G0tensor(47)])
  call ol_merge_tensors(G2tensor(18),[G1tensor(52),G0tensor(52)])
  call ol_merge_tensors(G2tensor(19),[G1tensor(55),G0tensor(55)])
  call ol_merge_tensors(G1tensor(3),[G1tensor(7),G0tensor(7),G0tensor(2)])
  call ol_merge_tensors(G2tensor(8),[G2tensor(7),G1tensor(22),G1tensor(2),G0tensor(22),G0tensor(3)])
  call ol_merge_tensors(G1tensor(27),[G1tensor(6),G0tensor(27),G0tensor(4)])
  call ol_merge_tensors(G1tensor(25),[G1tensor(4),G0tensor(25),G0tensor(8)])
  call ol_merge_tensors(G1tensor(30),[G1tensor(11),G0tensor(30),G0tensor(9)])
  call ol_merge_tensors(G1tensor(17),[G1tensor(10),G0tensor(17),G0tensor(12)])
  call ol_merge_tensors(G1tensor(37),[G1tensor(13),G0tensor(37),G0tensor(13)])
  call ol_merge_tensors(G1tensor(42),[G1tensor(14),G0tensor(42),G0tensor(14)])
  call ol_merge_tensors(G1tensor(40),[G1tensor(18),G0tensor(40),G0tensor(18)])
  call ol_merge_tensors(G1tensor(45),[G1tensor(19),G0tensor(45),G0tensor(19)])
  call ol_merge_tensors(G1tensor(28),[G1tensor(23),G0tensor(28),G0tensor(23)])
  call ol_merge_tensors(G2tensor(2),[G1tensor(39),G1tensor(33),G1tensor(24),G0tensor(39),G0tensor(33),G0tensor(24)])
  call ol_merge_tensors(G2tensor(5),[G1tensor(54),G1tensor(44),G1tensor(34),G1tensor(29),G0tensor(54),G0tensor(44),G0tensor(34) &
    ,G0tensor(29)])
  call ol_merge_tensors(G1tensor(43),[G1tensor(38),G0tensor(43),G0tensor(38)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(48),G0tensor(48)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(49),G0tensor(49)])
  call TI_triangle_red(G2tensor(4),RedBasis(19),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(16),M2L1R1,[nMT], &
    G0tensor(21))
  call TI_triangle_red(G2tensor(11),RedBasis(1),mass3set(:,2),G0tensor(26),G0tensor(31),G0tensor(36), &
    G0tensor(41),M2L1R1,[nMB,nMT],G0tensor(46),G0tensor(51))
  call TI_triangle_red(G2tensor(10),RedBasis(18),mass3set(:,2),G0tensor(32),G0tensor(15),G0tensor(5), &
    G0tensor(50),M2L1R1,[nMB,nMT],G0tensor(35),G0tensor(20))
  call TI_triangle_red(G2tensor(18),RedBasis(24),mass3set(:,3),G0tensor(10),G0tensor(53),G0tensor(47),G0tensor(52),M2L1R1,[nMT], &
    G0tensor(55))
  call TI_triangle_red(G2tensor(19),RedBasis(17),mass3set(:,4),G0tensor(7),G0tensor(2),G0tensor(22),G0tensor(3),M2L1R1,[nMB,nMT], &
    G0tensor(27),G0tensor(4))
  call TI_triangle_red(G2tensor(8),RedBasis(21),mass3set(:,5),G0tensor(25),G0tensor(8),G0tensor(30),G0tensor(9),M2L1R1)
  call TI_triangle_red(G2tensor(2),RedBasis(5),mass3set(:,6),G0tensor(17),G0tensor(12),G0tensor(37),G0tensor(13),M2L1R1,[nMB], &
    G0tensor(42))
  call TI_triangle_red(G2tensor(5),RedBasis(3),mass3set(:,2),G0tensor(14),G0tensor(40),G0tensor(18),G0tensor(45),M2L1R1,[nMB,nMT], &
    G0tensor(19),G0tensor(28))
  call TI_triangle_red(G2tensor(9),RedBasis(16),mass3set(:,7),G0tensor(23),G0tensor(39),G0tensor(33),G0tensor(24),M2L1R1,[nMB], &
    G0tensor(54))
  call TI_triangle_red(G2tensor(3),RedBasis(15),mass3set(:,8),G0tensor(44),G0tensor(34),G0tensor(29), &
    G0tensor(43),M2L1R1,[nMB,nMT],G0tensor(38),G0tensor(48))
  call TI_triangle_red(G2tensor(6),RedBasis(5),mass3set(:,9),G0tensor(49),G0tensor(56),G0tensor(57),G0tensor(58),M2L1R1,[nMB], &
    G0tensor(59))
  call TI_triangle_red(G2tensor(1),RedBasis(19),mass3set(:,10),G0tensor(60),G0tensor(61),G0tensor(62),G0tensor(63),M2L1R1,[nMT], &
    G0tensor(64))
  call TI_triangle_red(G1tensor(3),RedBasis(25),mass3set(:,1),G0tensor(65),G0tensor(66),G0tensor(67),G0tensor(68),M2L1R1,[nMT], &
    G0tensor(69))
  call TI_triangle_red(G1tensor(27),RedBasis(20),mass3set(:,1),G0tensor(70),G0tensor(71),G0tensor(72),G0tensor(73),M2L1R1,[nMT], &
    G0tensor(74))
  call TI_triangle_red(G1tensor(25),RedBasis(4),mass3set(:,6),G0tensor(75),G0tensor(76),G0tensor(77),G0tensor(78),M2L1R1,[nMB], &
    G0tensor(79))
  call TI_triangle_red(G1tensor(30),RedBasis(2),mass3set(:,2),G0tensor(80),G0tensor(81),G0tensor(82), &
    G0tensor(83),M2L1R1,[nMB,nMT],G0tensor(84),G0tensor(85))
  call TI_triangle_red(G1tensor(17),RedBasis(26),mass3set(:,1),G0tensor(86),G0tensor(87),G0tensor(88),G0tensor(89),M2L1R1,[nMT], &
    G0tensor(90))
  call TI_triangle_red(G1tensor(37),RedBasis(23),mass3set(:,5),G0tensor(91),G0tensor(92),G0tensor(93),G0tensor(94),M2L1R1)
  call TI_triangle_red(G1tensor(42),RedBasis(22),mass3set(:,1),G0tensor(95),G0tensor(96),G0tensor(97),G0tensor(98),M2L1R1,[nMT], &
    G0tensor(99))
  call TI_triangle_red(G1tensor(40),RedBasis(8),mass3set(:,6),G0tensor(100),G0tensor(101),G0tensor(102), &
    G0tensor(103),M2L1R1,[nMB],G0tensor(104))
  call TI_triangle_red(G1tensor(45),RedBasis(7),mass3set(:,2),G0tensor(105),G0tensor(106),G0tensor(107), &
    G0tensor(108),M2L1R1,[nMB,nMT],G0tensor(109),G0tensor(110))
  call TI_triangle_red(G1tensor(28),RedBasis(6),mass3set(:,6),G0tensor(111),G0tensor(112),G0tensor(113), &
    G0tensor(114),M2L1R1,[nMB],G0tensor(115))
  call TI_triangle_red(G1tensor(43),RedBasis(9),mass3set(:,6),G0tensor(116),G0tensor(117),G0tensor(118), &
    G0tensor(119),M2L1R1,[nMB],G0tensor(120))
  call ol_merge_tensors(T0sum(12),[G0tensor(1)])
  call ol_merge_tensors(T0sum(13),[G0tensor(26)])
  call ol_merge_tensors(T0sum(14),[G0tensor(32)])
  call ol_merge_tensors(T0sum(15),[G0tensor(10)])
  call ol_merge_tensors(T0sum(16),[G0tensor(7)])
  call ol_merge_tensors(T0sum(17),[G0tensor(65)])
  call ol_merge_tensors(T0sum(18),[G0tensor(25)])
  call ol_merge_tensors(T0sum(19),[G0tensor(70)])
  call ol_merge_tensors(T0sum(20),[G0tensor(75)])
  call ol_merge_tensors(T0sum(21),[G0tensor(80)])
  call ol_merge_tensors(T0sum(22),[G0tensor(86)])
  call ol_merge_tensors(T0sum(23),[G0tensor(91)])
  call ol_merge_tensors(T0sum(24),[G0tensor(95)])
  call ol_merge_tensors(T0sum(25),[G0tensor(100)])
  call ol_merge_tensors(T0sum(26),[G0tensor(105)])
  call ol_merge_tensors(T0sum(27),[G0tensor(111)])
  call ol_merge_tensors(T0sum(28),[G0tensor(17)])
  call ol_merge_tensors(T0sum(29),[G0tensor(14)])
  call ol_merge_tensors(T0sum(30),[G0tensor(116)])
  call ol_merge_tensors(T0sum(31),[G0tensor(23)])
  call ol_merge_tensors(T0sum(32),[G0tensor(44)])
  call ol_merge_tensors(T0sum(33),[G0tensor(49)])
  call ol_merge_tensors(T0sum(34),[G0tensor(60)])
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(20),h0tab(:,20),[25,6],[0,0],2,2,wf12(:,1),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,1),G0H4(1),m3h12x4(:,5),heltab2x48(:,:,20))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(4),n2h4(10))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(21),h0tab(:,21),[25,6],[nMT,nMT],2,2,wf12(:,1),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,1),G0H4(1),m3h12x4(:,6),heltab2x48(:,:,21))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(6),n2h4(11))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(22),h0tab(:,22),[25,6],[0,0],2,2,wf12(:,1),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,1),G0H4(1),m3h12x4(:,7),heltab2x48(:,:,22))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(2),n2h4(12))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(23),h0tab(:,23),[25,6],[nMB,nMB],2,2,wf12(:,1),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,1),G0H4(1),m3h12x4(:,8),heltab2x48(:,:,23))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(3),n2h4(13))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(13)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(24),h0tab(:,24),[25,6],[0,0],2,2,wf12(:,1),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf12(:,1),25,G1H4(5),m3h12x4(:,9),heltab2x48(:,:,24))
  Gcoeff(:)%j = (c(3)*M(1,:)%j-c(4)*M(2,:)%j) * den(11)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(25),h0tab(:,25),[25,6],[0,0],2,2,wf12(:,1),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,1),25,G1H4(1),m3h12x4(:,10),heltab2x48(:,:,25))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(8)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(26),h0tab(:,26),[17,14],[0,nMB],2,2,wf6(:,2),wf8(:,5))
  call Hloop_AQ_V(ntryL,G0H48(1),wf6(:,2),G0H8(3),m3h6x8(:,9),heltab2x48(:,:,26))
  Gcoeff(:)%j = (c(8)*M(1,:)%j-c(12)*M(2,:)%j) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(27),h0tab(:,27),[24,7],[nMT,0],2,2,wf6(:,4),wf8(:,6))
  call Hloop_VA_Q(ntryL,G0H48(1),wf6(:,4),G0H8(1),m3h6x8(:,10),heltab2x48(:,:,27))
  call Hloop_A_Q(ntryL,G0H8(1),24,nMT,G1H8(4),n2h8(5))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(28),h0tab(:,28),[25,6],[0,0],2,2,wf12(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,11),heltab2x48(:,:,28))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(7),n2h4(14))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(29),h0tab(:,29),[25,6],[nMT,nMT],2,2,wf12(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,12),heltab2x48(:,:,29))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMT,G1H4(8),n2h4(15))
  Gcoeff(:)%j = (-(c(16)*M(1,:)%j)+c(17)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(30),h0tab(:,30),[25,6],[0,0],2,2,wf12(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,13),heltab2x48(:,:,30))
  call Hloop_Q_A(ntryL,G0H4(1),25,0,G1H4(9),n2h4(16))
  Gcoeff(:)%j = (-(c(14)*M(1,:)%j)+c(15)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(31),h0tab(:,31),[25,6],[nMB,nMB],2,2,wf12(:,4),wf4(:,1))
  call Hloop_QV_A(ntryL,G0H48(1),wf12(:,4),G0H4(1),m3h12x4(:,14),heltab2x48(:,:,31))
  call Hloop_Q_A(ntryL,G0H4(1),25,nMB,G1H4(10),n2h4(17))
  Gcoeff(:)%j = (-(c(10)*M(1,:)%j)+c(13)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(32),h0tab(:,32),[25,6],[0,0],2,2,wf12(:,4),wf4(:,1))
  call Hloop_CV_D(ntryL,G0H48(1),0,wf12(:,4),25,G1H4(11),m3h12x4(:,15),heltab2x48(:,:,32))
  Gcoeff(:)%j = (c(3)*M(1,:)%j-c(4)*M(2,:)%j) * den(13)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H48(1),m0h(33),h0tab(:,33),[25,6],[0,0],2,2,wf12(:,4),wf4(:,1))
  call Hloop_UV_W(ntryL,G0H48(1),0,wf12(:,4),25,G1H4(12),m3h12x4(:,16),heltab2x48(:,:,33))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(9),[G1H4(7),G1H4(2),G1H4(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(8),[G1H4(6)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(10),[G1H4(3)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(11),[G1H4(5)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H4(12),[G1H4(1)])
  call Hloop_QV_A(ntryL,G1H4(9),wf4(:,1),G1H1(1),m3h4x1(:,8),heltab2x4(:,:,17))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,0,G2tensor(14),n2h1(28))
  call Hloop_QV_A(ntryL,G1H4(8),wf4(:,1),G1H1(1),m3h4x1(:,9),heltab2x4(:,:,18))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMT,G2tensor(17),n2h1(29))
  call Hloop_QV_A(ntryL,G1H4(10),wf4(:,1),G1H1(1),m3h4x1(:,10),heltab2x4(:,:,19))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),31,nMB,G2tensor(12),n2h1(30))
  call Hcheck_last_CV_D(ntryL,l_switch,G1H4(11),25,wf4(:,1),6,G2tensor(16),m3h4x1(:,11),heltab2x4(:,:,20))
  call Hcheck_last_UV_W(ntryL,l_switch,G1H4(12),25,wf4(:,1),6,G2tensor(13),m3h4x1(:,12),heltab2x4(:,:,21))
  call Hloop_VA_Q(ntryL,G0H8(3),wf8(:,5),G0H1(1),m3h8x1(:,2),heltab2x8(:,:,14))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),31,nMB,G1tensor(1),n2h1(31))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H8(4),wf8(:,6),G1tensor(12),m3h8x1(:,3),heltab2x8(:,:,15))
  call ol_merge_tensors(G0tensor(87),[G0tensor(66),G0tensor(47),G0tensor(15),G0tensor(31),G0tensor(6)])
  call ol_merge_tensors(G2tensor(13),[G2tensor(16),G2tensor(14),G0tensor(94),G0tensor(12),G0tensor(9),G0tensor(11)])
  call ol_merge_tensors(G1tensor(12),[G0tensor(98),G0tensor(73),G0tensor(40),G0tensor(52),G0tensor(16)])
  call ol_merge_tensors(G0tensor(110),[G0tensor(99),G0tensor(90),G0tensor(85),G0tensor(74),G0tensor(69),G0tensor(64),G0tensor(48) &
    ,G0tensor(28),G0tensor(4),G0tensor(55),G0tensor(20),G0tensor(51),G0tensor(21)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(103),G0tensor(78),G0tensor(24),G0tensor(13),G0tensor(36)])
  call ol_merge_tensors(G0tensor(108),[G0tensor(83),G0tensor(43),G0tensor(45),G0tensor(3),G0tensor(41)])
  call ol_merge_tensors(G0tensor(120),[G0tensor(115),G0tensor(109),G0tensor(104),G0tensor(84),G0tensor(79),G0tensor(59) &
    ,G0tensor(38),G0tensor(54),G0tensor(19),G0tensor(42),G0tensor(27),G0tensor(35),G0tensor(46)])
  call ol_merge_tensors(G0tensor(118),[G0tensor(113),G0tensor(39),G0tensor(18),G0tensor(37),G0tensor(5)])
  call ol_merge_tensors(G0tensor(34),[G0tensor(22),G0tensor(50)])
  call ol_merge_tensors(G2tensor(17),[G0tensor(62),G0tensor(2),G0tensor(53)])
  call ol_merge_tensors(G0tensor(117),[G0tensor(97),G0tensor(93),G0tensor(76),G0tensor(67),G0tensor(8)])
  call ol_merge_tensors(G0tensor(112),[G0tensor(101),G0tensor(92),G0tensor(88),G0tensor(72),G0tensor(30)])
  call ol_merge_tensors(G2tensor(12),[G0tensor(56),G0tensor(29),G0tensor(33)])
  call ol_merge_tensors(G0tensor(81),[G0tensor(71),G0tensor(68)])
  call ol_merge_tensors(G0tensor(114),[G0tensor(82),G0tensor(77)])
  call ol_merge_tensors(G0tensor(106),[G0tensor(96),G0tensor(89)])
  call ol_merge_tensors(G0tensor(119),[G0tensor(107),G0tensor(102)])
call TI_bubble_red(G2tensor(13),25,mass2set(:,1),G0tensor(1),M2L1R1)
call TI_bubble_red(G2tensor(17),25,mass2set(:,2),G0tensor(26),M2L1R1,G0tensor(32))
call TI_bubble_red(G2tensor(12),25,mass2set(:,3),G0tensor(10),M2L1R1,G0tensor(7))
  call ol_merge_tensors(G0tensor(32),[G0tensor(110)])
  call ol_merge_tensors(G0tensor(7),[G0tensor(120)])
call TI_bubble_red(G1tensor(12),24,mass2set(:,4),G0tensor(65),M2L1R1,G0tensor(25))
call TI_bubble_red(G1tensor(1),17,mass2set(:,5),G0tensor(70),M2L1R1,G0tensor(75))
  call ol_merge_tensors(G0tensor(32),[G0tensor(25)])
  call ol_merge_tensors(G0tensor(7),[G0tensor(75)])
  call ol_merge_tensors(T0sum(35),[G0tensor(87)])
  call ol_merge_tensors(T0sum(36),[G0tensor(1)])
  call ol_merge_tensors(T0sum(37),[G0tensor(65)])
  call ol_merge_tensors(T0sum(38),[G0tensor(32)])
  call ol_merge_tensors(T0sum(39),[G0tensor(70)])
  call ol_merge_tensors(T0sum(40),[G0tensor(7)])
  call ol_merge_tensors(T0sum(41),[G0tensor(108)])
  call ol_merge_tensors(T0sum(42),[G0tensor(118)])
  call ol_merge_tensors(T0sum(43),[G0tensor(34)])
  call ol_merge_tensors(T0sum(44),[G0tensor(26)])
  call ol_merge_tensors(T0sum(45),[G0tensor(117)])
  call ol_merge_tensors(T0sum(46),[G0tensor(112)])
  call ol_merge_tensors(T0sum(47),[G0tensor(10)])
  call ol_merge_tensors(T0sum(48),[G0tensor(57)])
  call ol_merge_tensors(T0sum(49),[G0tensor(58)])
  call ol_merge_tensors(T0sum(50),[G0tensor(61)])
  call ol_merge_tensors(T0sum(51),[G0tensor(63)])
  call ol_merge_tensors(T0sum(52),[G0tensor(81)])
  call ol_merge_tensors(T0sum(53),[G0tensor(114)])
  call ol_merge_tensors(T0sum(54),[G0tensor(106)])
  call ol_merge_tensors(T0sum(55),[G0tensor(119)])


! Compute scalar Master integrals 

  call compute_scalar_box([ 17, 19, 23 ],masses2_19,RedSet_4(1),ScalarBoxes(1))
  call compute_scalar_box([ 16, 19, 23 ],masses2_22,RedSet_4(2),ScalarBoxes(2))
  call compute_scalar_box([ 16, 17, 23 ],masses2_22,RedSet_4(3),ScalarBoxes(3))
  call compute_scalar_box([ 16, 17, 19 ],masses2_22,RedSet_4(4),ScalarBoxes(4))
  call compute_scalar_box([ 1, 3, 7 ],masses2_20,RedSet_4(5),ScalarBoxes(5))
  call compute_scalar_box([ 17, 21, 23 ],masses2_19,RedSet_4(6),ScalarBoxes(6))
  call compute_scalar_box([ 16, 21, 23 ],masses2_22,RedSet_4(7),ScalarBoxes(7))
  call compute_scalar_box([ 16, 17, 21 ],masses2_22,RedSet_4(8),ScalarBoxes(8))
  call compute_scalar_box([ 1, 5, 7 ],masses2_20,RedSet_4(9),ScalarBoxes(9))
! end of process


end subroutine vamp_1

end module ol_vamp_1_pptwj_tddxbxw_1_/**/REALKIND
