
module ol_vamp_1_pptw_tbxwg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_1(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptw_tbxwg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptw_tbxwg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_pptw_tbxwg_1_/**/DREALKIND
  use ol_tensor_sum_storage_pptw_tbxwg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red

  use ol_loop_storage_pptw_tbxwg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_pptw_tbxwg_1_/**/DREALKIND, only: ntryL, p_switch, Hel
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(24)
  type(Hpolcont), intent(in) :: M(1,24)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================


! Dressing, otf merging and otf reduction calls to build loop structures

Gcoeff(:)%j = (c(2)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(1),h0tab(:,1),[8,2,1,4],[nMB,0,nMT,nMB],4,0)
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,1),heltab2x24(:,:,1))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(1),n2h12(1))
Gcoeff(:)%j = (c(2)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(2),h0tab(:,2),[8,1,2,4],[nMT,0,nMB,nMT],4,0)
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,2),heltab2x24(:,:,2))
  call Hloop_A_Q(ntryL,G0H12(1),8,nMT,G1H12(2),n2h12(2))
Gcoeff(:)%j = (c(1)*M(1,:)%j)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(3),h0tab(:,3),[8,1,4,2],[0,nMT,nMB,0],4,0)
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(3),m3h2x12(:,3),heltab2x24(:,:,3))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(1),m3h2x6(:,1),heltab2x12(:,:,1))
  call Hloop_AQ_V(ntryL,G1H12(2),ex1(:),G1H6(2),m3h2x6(:,2),heltab2x12(:,:,2))
  call Hloop_VQ_A(ntryL,G1H12(3),ex1(:),G1H6(3),m3h2x6(:,3),heltab2x12(:,:,3))
  call Hloop_Q_A(ntryL,G1H6(3),9,nMT,G2H6(1),n2h6(1))
  call Hloop_VQ_A(ntryL,G1H6(1),ex1(:),G1H3(1),m3h2x3(:,1),heltab2x6(:,:,1))
  call Hloop_Q_A(ntryL,G1H3(1),11,nMT,G2H3(1),n2h3(1))
  call Hloop_VA_Q(ntryL,G1H6(2),ex2(:),G1H3(1),m3h2x3(:,2),heltab2x6(:,:,2))
  call Hloop_A_Q(ntryL,G1H3(1),11,nMB,G2H3(2),n2h3(2))
call Hotf_4pt_reduction(G2H6(1),RedSet_4(1),mass4set(:,1),  & 
G1H6(3),G1H6(1),G1H6(2),G1H6(4),G1H6(5),6)
call HG1shiftOLR(G1H6(1),2,6)
  call Hloop_QW_A(ntryL,G1H6(3),ex3(:),G1H2(1),m3h3x2(:,1),heltab2x6(:,:,3))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMB,G2H2(1),n2h2(1))
call HGT_raise_alpha_OLR(G1H6(1),1,1,6)
call HGT_raise_alpha_invQ_OLR(G1H6(1),2,5,6)
  call Hloop_VA_Q(ntryL,G1H6(1),ex2(:),G1H3(1),m3h2x3(:,3),heltab2x6(:,:,4))
  call Hloop_QW_A(ntryL,G1H6(4),ex3(:),G1H2(1),m3h3x2(:,2),heltab2x6(:,:,5))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMB,G2H2(2),n2h2(2))
  call Hloop_QW_A(ntryL,G1H6(5),ex3(:),G1H2(1),m3h3x2(:,3),heltab2x6(:,:,6))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMB,G2H2(3),n2h2(3))
call Hotf_4pt_reduction(G2H3(1),RedSet_4(2),mass4set(:,2),  & 
G1H3(2),G1H3(3),G1H3(4),G1H3(5),G1H3(6),3)
call HG1shiftOLR(G1H3(3),4,3)
call Hotf_4pt_reduction(G2H3(2),RedSet_4(3),mass4set(:,3),  & 
G1H3(7),G1H3(8),G1H3(9),G1H3(10),G1H3(11),3)
call HG1shiftOLR(G1H3(8),4,3)
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(1),m3h2x1(:,1),heltab2x2(:,:,1))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(3),ex2(:),G2tensor(2),m3h2x1(:,2),heltab2x2(:,:,2))
  call Hloop_QW_A(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,1),heltab2x3(:,:,1))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(3),n2h1(1))
  call Hloop_QW_A(ntryL,G1H3(3),ex3(:),G1H1(1),m3h3x1(:,2),heltab2x3(:,:,2))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),4,nMB,G2tensor(4),n2h1(2))
  call Hloop_QW_A(ntryL,G1H3(6),ex3(:),G1H1(1),m3h3x1(:,3),heltab2x3(:,:,3))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(5),n2h1(3))
  call Hloop_AW_Q(ntryL,G1H3(7),ex3(:),G1H1(1),m3h3x1(:,4),heltab2x3(:,:,4))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(6),n2h1(4))
  call Hloop_AW_Q(ntryL,G1H3(8),ex3(:),G1H1(1),m3h3x1(:,5),heltab2x3(:,:,5))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),4,nMT,G2tensor(7),n2h1(5))
  call Hloop_AW_Q(ntryL,G1H3(11),ex3(:),G1H1(1),m3h3x1(:,6),heltab2x3(:,:,6))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(8),n2h1(6))
call Hotf_4pt_reduction_last(G2tensor(1),RedSet_4(1),mass4set(:,1),  & 
G1tensor(1),G1tensor(2),G1tensor(3),G1tensor(4),G1tensor(5))
call G_TensorShift(G1tensor(2),2)
call Hotf_4pt_reduction_last(G2tensor(3),RedSet_4(2),mass4set(:,2),  & 
G1tensor(6),G1tensor(7),G1tensor(8),G1tensor(9),G1tensor(10))
call G_TensorShift(G1tensor(7),4)
call Hotf_4pt_reduction_last(G2tensor(6),RedSet_4(3),mass4set(:,3),  & 
G1tensor(11),G1tensor(12),G1tensor(13),G1tensor(14),G1tensor(15))
call G_TensorShift(G1tensor(12),4)
call Hotf_4pt_reduction_last(G1tensor(1),RedSet_4(1),mass4set(:,1),  & 
G0tensor(1),G0tensor(2),G0tensor(3),G0tensor(4),G0tensor(5))
call Hotf_4pt_reduction_last(G1tensor(6),RedSet_4(2),mass4set(:,2),  & 
G0tensor(6),G0tensor(7),G0tensor(8),G0tensor(9),G0tensor(10))
call Hotf_4pt_reduction_last(G1tensor(11),RedSet_4(3),mass4set(:,3),  & 
G0tensor(11),G0tensor(12),G0tensor(13),G0tensor(14),G0tensor(15))
call ol_merge_tensors(T0sum(1),[G0tensor(1)])
call ol_merge_tensors(T0sum(2),[G0tensor(6)])
call ol_merge_tensors(T0sum(3),[G0tensor(11)])
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(4),h0tab(:,4),[8,2,5],[nMB,0,nMB],3,1,wf6(:,2))
  call Hloop_QV_A(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,4),heltab2x24(:,:,4))
  call Hloop_Q_A(ntryL,G0H12(1),8,nMB,G1H12(1),n2h12(3))
Gcoeff(:)%j = (-(c(1)*M(1,:)%j)) * den(1)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(5),h0tab(:,5),[8,2,5],[0,nMB,0],3,1,wf6(:,2))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(2),m3h2x12(:,5),heltab2x24(:,:,5))
Gcoeff(:)%j = (c(2)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(6),h0tab(:,6),[8,1,6],[nMT,0,nMT],3,1,wf6(:,5))
  call Hloop_AV_Q(ntryL,G0H24(1),ex4(:),G0H12(1),m3h2x12(:,6),heltab2x24(:,:,6))
  call Hloop_A_Q(ntryL,G0H12(1),8,nMT,G1H12(3),n2h12(4))
Gcoeff(:)%j = (c(1)*M(1,:)%j) * den(3)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(7),h0tab(:,7),[8,1,6],[0,nMT,0],3,1,wf6(:,5))
  call Hloop_UV_W(ntryL,G0H24(1),0,ex4(:),8,G1H12(4),m3h2x12(:,7),heltab2x24(:,:,7))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(2)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(8),h0tab(:,8),[9,2,4],[0,nMB,nMT],3,1,wf4(:,3))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,3),G0H6(1),m3h4x6(:,1),heltab2x24(:,:,8))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(4)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(9),h0tab(:,9),[10,1,4],[0,nMT,nMB],3,1,wf4(:,6))
  call Hloop_QA_V(ntryL,G0H24(1),wf4(:,6),G0H6(2),m3h4x6(:,2),heltab2x24(:,:,9))
  call Hloop_QW_A(ntryL,G1H6(2),ex3(:),G1H2(1),m3h3x2(:,4),heltab2x6(:,:,7))
  call Hloop_Q_A(ntryL,G1H2(1),13,nMB,G2H2(1),n2h2(4))
  call Hloop_QA_V(ntryL,G1H12(1),ex2(:),G1H6(3),m3h2x6(:,4),heltab2x12(:,:,4))
  call Hloop_VA_Q(ntryL,G1H12(2),ex2(:),G1H6(1),m3h2x6(:,5),heltab2x12(:,:,5))
  call Hloop_A_Q(ntryL,G1H6(1),10,nMB,G2H6(1),n2h6(3))
  call Hloop_AQ_V(ntryL,G1H12(3),ex1(:),G1H6(4),m3h2x6(:,6),heltab2x12(:,:,6))
  call Hloop_VQ_A(ntryL,G1H12(4),ex1(:),G1H6(5),m3h2x6(:,7),heltab2x12(:,:,7))
  call Hloop_Q_A(ntryL,G1H6(5),9,nMT,G2H6(2),n2h6(4))
  call Hloop_VA_Q(ntryL,G0H6(1),ex2(:),G0H3(1),m3h2x3(:,4),heltab2x6(:,:,8))
  call Hloop_A_Q(ntryL,G0H3(1),11,nMB,G1H3(2),n2h3(3))
  call Hloop_VQ_A(ntryL,G0H6(2),ex1(:),G0H3(1),m3h2x3(:,5),heltab2x6(:,:,9))
  call Hloop_Q_A(ntryL,G0H3(1),11,nMT,G1H3(3),n2h3(4))
  call ol_merge(ntryL,G1H3(3),[G1H3(4)])
call HGT_w2_OLR(G1H3(1),1,1,3)
call HGT_w2_invQ_OLR(G1H3(1),2,5,3)
  call ol_merge(ntryL,G1H3(1),[G1H3(3)])
  call ol_merge(ntryL,G1H3(2),[G1H3(9)])
  call Hloop_QW_A(ntryL,G1H3(1),ex3(:),G1H1(1),m3h3x1(:,7),heltab2x3(:,:,7))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(1),n2h1(7))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(2),ex2(:),G2tensor(3),m3h2x1(:,3),heltab2x2(:,:,3))
  call Hloop_QW_A(ntryL,G1H3(5),ex3(:),G1H1(1),m3h3x1(:,8),heltab2x3(:,:,8))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(6),n2h1(8))
  call Hloop_AW_Q(ntryL,G1H3(2),ex3(:),G1H1(1),m3h3x1(:,9),heltab2x3(:,:,9))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(9),n2h1(9))
  call Hloop_AW_Q(ntryL,G1H3(10),ex3(:),G1H1(1),m3h3x1(:,10),heltab2x3(:,:,10))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(10),n2h1(10))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H2(1),ex2(:),G2tensor(11),m3h2x1(:,4),heltab2x2(:,:,4))
  call Hloop_VQ_A(ntryL,G1H6(3),wf6(:,2),G1H1(1),m3h6x1(:,1),heltab2x6(:,:,10))
  call Hcheck_last_Q_A(ntryL,l_switch,G1H1(1),15,nMB,G2tensor(12),n2h1(11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G2H6(1),wf6(:,2),G2tensor(13),m3h6x1(:,2),heltab2x6(:,:,11))
  call Hloop_VA_Q(ntryL,G1H6(4),wf6(:,5),G1H1(1),m3h6x1(:,3),heltab2x6(:,:,12))
  call Hcheck_last_A_Q(ntryL,l_switch,G1H1(1),15,nMT,G2tensor(14),n2h1(12))
  call Hcheck_last_QA_V(ntryL,l_switch,G2H6(2),wf6(:,5),G2tensor(15),m3h6x1(:,4),heltab2x6(:,:,13))
  call ol_merge_tensors(G2tensor(15),[G2tensor(2),G1tensor(5),G0tensor(5)])
  call ol_merge_tensors(G2tensor(4),[G1tensor(7),G0tensor(7)])
  call ol_merge_tensors(G2tensor(12),[G2tensor(5),G1tensor(10),G0tensor(10)])
  call ol_merge_tensors(G2tensor(7),[G1tensor(12),G0tensor(12)])
  call ol_merge_tensors(G2tensor(14),[G2tensor(8),G1tensor(15),G0tensor(15)])
  call ol_merge_tensors(G2tensor(1),[G1tensor(8),G1tensor(2),G0tensor(8),G0tensor(2)])
  call ol_merge_tensors(G2tensor(11),[G1tensor(3),G0tensor(3)])
  call ol_merge_tensors(G2tensor(3),[G1tensor(4),G0tensor(4)])
  call ol_merge_tensors(G2tensor(6),[G1tensor(9),G0tensor(9)])
  call ol_merge_tensors(G2tensor(9),[G1tensor(13),G0tensor(13)])
  call ol_merge_tensors(G2tensor(10),[G1tensor(14),G0tensor(14)])
call TI_triangle_red(G2tensor(15),RedBasis(1),mass3set(:,1),G0tensor(1),G0tensor(6),G0tensor(11),G0tensor(5),M2L1R1,[nMT], &
    G0tensor(7))
call TI_triangle_red(G2tensor(4),RedBasis(8),mass3set(:,2),G0tensor(10),G0tensor(12),G0tensor(15),G0tensor(8),M2L1R1,[nMT,nMB], &
    G0tensor(2),G0tensor(3))
call TI_triangle_red(G2tensor(12),RedBasis(4),mass3set(:,3),G0tensor(4),G0tensor(9),G0tensor(13),G0tensor(14),M2L1R1,[nMB], &
    G0tensor(16))
call TI_triangle_red(G2tensor(7),RedBasis(9),mass3set(:,4),G0tensor(17),G0tensor(18),G0tensor(19),G0tensor(20),M2L1R1,[nMB,nMT], &
    G0tensor(21),G0tensor(22))
call TI_triangle_red(G2tensor(14),RedBasis(1),mass3set(:,5),G0tensor(23),G0tensor(24),G0tensor(25),G0tensor(26),M2L1R1,[nMT], &
    G0tensor(27))
call TI_triangle_red(G2tensor(1),RedBasis(6),mass3set(:,6),G0tensor(28),G0tensor(29),G0tensor(30),G0tensor(31),M2L1R1,[nMB,nMT], &
    G0tensor(32),G0tensor(33))
call TI_triangle_red(G2tensor(11),RedBasis(3),mass3set(:,7),G0tensor(34),G0tensor(35),G0tensor(36),G0tensor(37),M2L1R1,[nMT,nMB], &
    G0tensor(38),G0tensor(39))
call TI_triangle_red(G2tensor(3),RedBasis(2),mass3set(:,8),G0tensor(40),G0tensor(41),G0tensor(42),G0tensor(43),M2L1R1,[nMB], &
    G0tensor(44))
call TI_triangle_red(G2tensor(6),RedBasis(5),mass3set(:,9),G0tensor(45),G0tensor(46),G0tensor(47),G0tensor(48),M2L1R1,[nMB,nMT], &
    G0tensor(49),G0tensor(50))
call TI_triangle_red(G2tensor(9),RedBasis(7),mass3set(:,10),G0tensor(51),G0tensor(52),G0tensor(53),G0tensor(54),M2L1R1,[nMT,nMB], &
    G0tensor(55),G0tensor(56))
call TI_triangle_red(G2tensor(10),RedBasis(5),mass3set(:,11),G0tensor(57),G0tensor(58),G0tensor(59),G0tensor(60),M2L1R1,[nMT,nMB], &
    G0tensor(61),G0tensor(62))
call TI_triangle_red(G2tensor(13),RedBasis(4),mass3set(:,8),G0tensor(63),G0tensor(64),G0tensor(65),G0tensor(66),M2L1R1,[nMB], &
    G0tensor(67))
call ol_merge_tensors(T0sum(4),[G0tensor(1)])
call ol_merge_tensors(T0sum(5),[G0tensor(10)])
call ol_merge_tensors(T0sum(6),[G0tensor(4)])
call ol_merge_tensors(T0sum(7),[G0tensor(17)])
call ol_merge_tensors(T0sum(8),[G0tensor(23)])
call ol_merge_tensors(T0sum(9),[G0tensor(28)])
call ol_merge_tensors(T0sum(10),[G0tensor(34)])
call ol_merge_tensors(T0sum(11),[G0tensor(40)])
call ol_merge_tensors(T0sum(12),[G0tensor(45)])
call ol_merge_tensors(T0sum(13),[G0tensor(51)])
call ol_merge_tensors(T0sum(14),[G0tensor(57)])
call ol_merge_tensors(T0sum(15),[G0tensor(63)])
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(5)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(10),h0tab(:,10),[10,5],[nMB,0],2,2,wf4(:,6),wf6(:,2))
  call Hloop_VA_Q(ntryL,G0H24(1),wf4(:,6),G0H6(1),m3h4x6(:,3),heltab2x24(:,:,10))
  call Hloop_A_Q(ntryL,G0H6(1),10,nMB,G1H6(2),n2h6(5))
Gcoeff(:)%j = (-(c(3)*M(1,:)%j)) * den(6)
call G0_hol_initialisation(ntryL,Gcoeff,G0H24(1),m0h(11),h0tab(:,11),[9,6],[0,nMT],2,2,wf4(:,3),wf6(:,5))
  call Hloop_AQ_V(ntryL,G0H24(1),wf4(:,3),G0H6(2),m3h4x6(:,4),heltab2x24(:,:,11))
  call Hcheck_last_AQ_V(ntryL,l_switch,G1H6(2),wf6(:,2),G1tensor(1),m3h6x1(:,5),heltab2x6(:,:,14))
  call Hloop_VA_Q(ntryL,G0H6(2),wf6(:,5),G0H1(1),m3h6x1(:,6),heltab2x6(:,:,15))
  call Hcheck_last_A_Q(ntryL,l_switch,G0H1(1),15,nMT,G1tensor(6),n2h1(13))
  call ol_merge_tensors(G0tensor(29),[G0tensor(15),G0tensor(6)])
  call ol_merge_tensors(G0tensor(37),[G0tensor(11)])
  call ol_merge_tensors(G0tensor(66),[G0tensor(43),G0tensor(5)])
  call ol_merge_tensors(G0tensor(61),[G0tensor(55),G0tensor(50),G0tensor(38),G0tensor(33),G0tensor(27),G0tensor(22),G0tensor(2) &
    ,G0tensor(7)])
  call ol_merge_tensors(G0tensor(42),[G0tensor(36),G0tensor(9),G0tensor(12)])
  call ol_merge_tensors(G0tensor(46),[G0tensor(8)])
  call ol_merge_tensors(G0tensor(67),[G0tensor(62),G0tensor(56),G0tensor(49),G0tensor(44),G0tensor(39),G0tensor(32),G0tensor(21) &
    ,G0tensor(16),G0tensor(3)])
  call ol_merge_tensors(G0tensor(41),[G0tensor(31),G0tensor(13)])
  call ol_merge_tensors(G0tensor(48),[G0tensor(14)])
  call ol_merge_tensors(G0tensor(24),[G0tensor(18)])
  call ol_merge_tensors(G0tensor(64),[G0tensor(52),G0tensor(19)])
  call ol_merge_tensors(G0tensor(58),[G0tensor(20)])
  call ol_merge_tensors(G1tensor(6),[G0tensor(54),G0tensor(25)])
  call ol_merge_tensors(G0tensor(60),[G0tensor(26)])
  call ol_merge_tensors(G0tensor(47),[G0tensor(35),G0tensor(30)])
  call ol_merge_tensors(G0tensor(59),[G0tensor(53)])
  call ol_merge_tensors(G1tensor(1),[G0tensor(65)])
call TI_bubble_red(G1tensor(6),9,mass2set(:,1),G0tensor(1),M2L1R1,G0tensor(10))
call TI_bubble_red(G1tensor(1),10,mass2set(:,2),G0tensor(4),M2L1R1,G0tensor(17))
  call ol_merge_tensors(G0tensor(10),[G0tensor(61)])
  call ol_merge_tensors(G0tensor(17),[G0tensor(67)])
call ol_merge_tensors(T0sum(16),[G0tensor(29)])
call ol_merge_tensors(T0sum(17),[G0tensor(37)])
call ol_merge_tensors(T0sum(18),[G0tensor(66)])
call ol_merge_tensors(T0sum(19),[G0tensor(10)])
call ol_merge_tensors(T0sum(20),[G0tensor(42)])
call ol_merge_tensors(T0sum(21),[G0tensor(46)])
call ol_merge_tensors(T0sum(22),[G0tensor(17)])
call ol_merge_tensors(T0sum(23),[G0tensor(41)])
call ol_merge_tensors(T0sum(24),[G0tensor(48)])
call ol_merge_tensors(T0sum(25),[G0tensor(24)])
call ol_merge_tensors(T0sum(26),[G0tensor(64)])
call ol_merge_tensors(T0sum(27),[G0tensor(58)])
call ol_merge_tensors(T0sum(28),[G0tensor(1)])
call ol_merge_tensors(T0sum(29),[G0tensor(60)])
call ol_merge_tensors(T0sum(30),[G0tensor(47)])
call ol_merge_tensors(T0sum(31),[G0tensor(59)])
call ol_merge_tensors(T0sum(32),[G0tensor(4)])
! end of process


end subroutine vamp_1

end module ol_vamp_1_pptw_tbxwg_1_/**/REALKIND
