
module ol_vamp_6_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_uuxtttxtx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_uuxtttxtx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_uuxtttxtx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,42) :: G0
  complex(REALKIND), dimension(4,5,4,72) :: G1
  complex(REALKIND), dimension(5,8) :: G1tensor
  complex(REALKIND), dimension(15,39) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,534),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,60),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,1),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),MT,G2tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,534),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,60),MB,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,1),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),MB,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,60),ZERO,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,1),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),ZERO,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,60),MT,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,1),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),MT,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,60),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,1),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MB,G2tensor(:,5))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,534),Q(:,60),G1(:,:,:,11))
  call check_last_CV_D(l_switch,G1(:,:,:,11),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,536),Q(:,60),G1(:,:,:,12))
  call check_last_CV_D(l_switch,G1(:,:,:,12),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,521),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,43),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,2),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),ZERO,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,521),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,43),MT,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,2),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,63),MT,G2tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,521),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,43),MB,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,2),G1(:,:,:,18))
  call check_last_Q_A(l_switch,G1(:,:,:,18),Q(:,63),MB,G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,522),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,43),ZERO,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,2),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,63),ZERO,G2tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,522),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,43),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,2),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),MT,G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,522),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,43),MB,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,2),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),MB,G2tensor(:,13))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,521),Q(:,43),G1(:,:,:,25))
  call check_last_CV_D(l_switch,G1(:,:,:,25),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,522),Q(:,43),G1(:,:,:,26))
  call check_last_CV_D(l_switch,G1(:,:,:,26),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,43),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,2),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),ZERO,G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,43),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,2),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,63),MT,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,43),MB,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,2),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,63),MB,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,43),ZERO,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,2),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),ZERO,G2tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,43),MT,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,2),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),MT,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,43),MB,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,2),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,63),MB,G2tensor(:,21))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,524),Q(:,43),G1(:,:,:,39))
  call check_last_CV_D(l_switch,G1(:,:,:,39),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,22))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,526),Q(:,43),G1(:,:,:,40))
  call check_last_CV_D(l_switch,G1(:,:,:,40),Q(:,43),wf(:,2),Q(:,20),G2tensor(:,23))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,322),G0(:,:,:,19),gZu)
  call loop_A_Q(G0(:,:,:,19),Q(:,42),ZERO,G1(:,:,:,41))
  call check_last_AQ_Z(l_switch,G1(:,:,:,41),wf(:,83),G1tensor(:,1),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,322),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,42),ZERO,G1(:,:,:,42))
  call check_last_AQ_W(l_switch,G1(:,:,:,42),wf(:,83),G1tensor(:,2))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,89),G0(:,:,:,21),gZu)
  call loop_ZA_Q(G0(:,:,:,21),wf(:,327),G0(:,:,:,22),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,22),Q(:,63),ZERO,G1tensor(:,3))
  call loop_AQ_W(G0(:,:,:,1),wf(:,89),G0(:,:,:,23))
  call loop_WA_Q(G0(:,:,:,23),wf(:,327),G0(:,:,:,24))
  call check_last_A_Q(l_switch,G0(:,:,:,24),Q(:,63),ZERO,G1tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,505),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,39),ZERO,G1(:,:,:,43))
  call loop_QV_A(G1(:,:,:,43),wf(:,28),G1(:,:,:,44))
  call check_last_Q_A(l_switch,G1(:,:,:,44),Q(:,63),ZERO,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,505),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,39),MT,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,28),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,63),MT,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,505),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,39),MB,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,28),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,63),MB,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,39),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,28),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),ZERO,G2tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,39),MT,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,28),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),MT,G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,39),MB,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,28),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),MB,G2tensor(:,29))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,505),Q(:,39),G1(:,:,:,55))
  call check_last_CV_D(l_switch,G1(:,:,:,55),Q(:,39),wf(:,28),Q(:,24),G2tensor(:,30))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,506),Q(:,39),G1(:,:,:,56))
  call check_last_CV_D(l_switch,G1(:,:,:,56),Q(:,39),wf(:,28),Q(:,24),G2tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,508),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,39),ZERO,G1(:,:,:,57))
  call loop_QV_A(G1(:,:,:,57),wf(:,28),G1(:,:,:,58))
  call check_last_Q_A(l_switch,G1(:,:,:,58),Q(:,63),ZERO,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,508),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,39),MT,G1(:,:,:,59))
  call loop_QV_A(G1(:,:,:,59),wf(:,28),G1(:,:,:,60))
  call check_last_Q_A(l_switch,G1(:,:,:,60),Q(:,63),MT,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,508),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,39),MB,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,28),G1(:,:,:,62))
  call check_last_Q_A(l_switch,G1(:,:,:,62),Q(:,63),MB,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,39),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,28),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,63),ZERO,G2tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,39),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,28),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),MT,G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,39),MB,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,28),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),MB,G2tensor(:,37))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,508),Q(:,39),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,39),wf(:,28),Q(:,24),G2tensor(:,38))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,510),Q(:,39),G1(:,:,:,70))
  call check_last_CV_D(l_switch,G1(:,:,:,70),Q(:,39),wf(:,28),Q(:,24),G2tensor(:,39))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,95),G0(:,:,:,37),gZu)
  call loop_ZA_Q(G0(:,:,:,37),wf(:,332),G0(:,:,:,38),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,38),Q(:,63),ZERO,G1tensor(:,5))
  call loop_AQ_W(G0(:,:,:,1),wf(:,95),G0(:,:,:,39))
  call loop_WA_Q(G0(:,:,:,39),wf(:,332),G0(:,:,:,40))
  call check_last_A_Q(l_switch,G0(:,:,:,40),Q(:,63),ZERO,G1tensor(:,6))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,337),G0(:,:,:,41),gZu)
  call loop_A_Q(G0(:,:,:,41),Q(:,38),ZERO,G1(:,:,:,71))
  call check_last_AQ_Z(l_switch,G1(:,:,:,71),wf(:,101),G1tensor(:,7),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,337),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,38),ZERO,G1(:,:,:,72))
  call check_last_AQ_W(l_switch,G1(:,:,:,72),wf(:,101),G1tensor(:,8))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(475)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(475)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(474)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(474)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(474)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(474)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(92)*M(4)+c(91)*(-M(8)-M(10))+c(89)*M(12)) * den(475)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(92)*M(4)+c(91)*(-M(8)-M(10))+c(89)*M(12)) * den(475)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(16)*M(9)-c(13)*M(11)) * den(475)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(28)*M(9)-c(25)*M(11)) * den(474)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(54)*M(4)+c(50)*(-M(8)-M(10))+c(45)*M(12)) * den(475)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(82)*M(9)-c(81)*M(11)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(478)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(82)*M(9)-c(81)*M(11)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(478)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(479)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(479)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(479)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(479)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(96)*M(4)+c(95)*(-M(2)-M(10))+c(93)*M(12)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(92)*M(4)+c(91)*(-M(2)-M(10))+c(89)*M(12)) * den(478)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(96)*M(4)+c(95)*(-M(2)-M(10))+c(93)*M(12)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(92)*M(4)+c(91)*(-M(2)-M(10))+c(89)*M(12)) * den(478)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(16)*M(9)-c(13)*M(11)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(28)*M(9)-c(25)*M(11)) * den(479)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(54)*M(4)+c(50)*(-M(2)-M(10))+c(45)*M(12)) * den(478)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(82)*M(9)-c(81)*M(11)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(482)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(82)*M(9)-c(81)*M(11)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(80)*M(9)-c(79)*M(11)) * den(482)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(483)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(483)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(86)*M(9)-c(85)*M(11)) * den(483)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(84)*M(9)-c(83)*M(11)) * den(483)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(96)*M(6)+c(95)*(-M(2)-M(10))+c(93)*M(12)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(92)*M(6)+c(91)*(-M(2)-M(10))+c(89)*M(12)) * den(482)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(96)*M(6)+c(95)*(-M(2)-M(10))+c(93)*M(12)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(92)*M(6)+c(91)*(-M(2)-M(10))+c(89)*M(12)) * den(482)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(16)*M(9)-c(13)*M(11)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(28)*M(9)-c(25)*M(11)) * den(483)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(54)*M(6)+c(50)*(-M(2)-M(10))+c(45)*M(12)) * den(482)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(285)
  T1sum(1:5,18) = T1sum(1:5,18) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(58)*M(5))+c(57)*(M(1)+M(9))-c(56)*M(11)) * den(285)
  T1sum(1:5,19) = T1sum(1:5,19) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(288)
  T1sum(1:5,21) = T1sum(1:5,21) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(58)*M(3))+c(57)*(M(1)+M(9))-c(56)*M(11)) * den(288)
  T1sum(1:5,22) = T1sum(1:5,22) + Gcoeff * G1tensor(:,4)
  Gcoeff = (-(c(82)*M(5))+c(81)*M(7)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(7)) * den(484)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(82)*M(5))+c(81)*M(7)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(7)) * den(484)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(86)*M(5))+c(85)*M(7)) * den(485)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(84)*M(5))+c(83)*M(7)) * den(485)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(86)*M(5))+c(85)*M(7)) * den(485)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(84)*M(5))+c(83)*M(7)) * den(485)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(96)*M(2))+c(95)*(M(4)+M(6))-c(93)*M(8)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(92)*M(2))+c(91)*(M(4)+M(6))-c(89)*M(8)) * den(484)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(96)*M(2))+c(95)*(M(4)+M(6))-c(93)*M(8)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(92)*M(2))+c(91)*(M(4)+M(6))-c(89)*M(8)) * den(484)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(16)*M(5))+c(13)*M(7)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(28)*M(5))+c(25)*M(7)) * den(485)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(54)*M(2))+c(50)*(M(4)+M(6))-c(45)*M(8)) * den(484)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(82)*M(5))+c(81)*M(7)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(7)) * den(488)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(82)*M(5))+c(81)*M(7)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(7)) * den(488)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(86)*M(5))+c(85)*M(7)) * den(489)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(84)*M(5))+c(83)*M(7)) * den(489)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(86)*M(5))+c(85)*M(7)) * den(489)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(84)*M(5))+c(83)*M(7)) * den(489)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(95)*(M(4)+M(6))-c(93)*M(8)-c(96)*M(10)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(91)*(M(4)+M(6))-c(89)*M(8)-c(92)*M(10)) * den(488)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(95)*(M(4)+M(6))-c(93)*M(8)-c(96)*M(10)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(91)*(M(4)+M(6))-c(89)*M(8)-c(92)*M(10)) * den(488)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(16)*M(5))+c(13)*M(7)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(28)*M(5))+c(25)*M(7)) * den(489)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(50)*(M(4)+M(6))-c(45)*M(8)-c(54)*M(10)) * den(488)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7)) * den(299)
  T1sum(1:5,24) = T1sum(1:5,24) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(58)*M(1)+c(57)*(-M(3)-M(5))+c(56)*M(7)) * den(299)
  T1sum(1:5,25) = T1sum(1:5,25) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9)) * den(302)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(57)*(-M(3)-M(5))+c(56)*M(7)+c(58)*M(9)) * den(302)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,8)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_6_pptttt_ew_uuxtttxtx_1_/**/REALKIND
