
module ol_vamp_6_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_6(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxddx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxddx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,149) :: G0
  complex(REALKIND), dimension(4,5,4,254) :: G1
  complex(REALKIND), dimension(5,46) :: G1tensor
  complex(REALKIND), dimension(15,136) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,443),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,53),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),ZERO,G2tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,443),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,53),MT,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,2),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),MT,G2tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,443),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,53),MB,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,2),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),MB,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,444),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,53),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,2),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),ZERO,G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,444),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,53),MT,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,2),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MT,G2tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,444),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,53),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,2),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MB,G2tensor(:,6))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,443),Q(:,53),G1(:,:,:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,7))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,444),Q(:,53),G1(:,:,:,14))
  call check_last_CV_D(l_switch,G1(:,:,:,14),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,8))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,118),G0(:,:,:,8),gZd)
  call loop_A_Q(G0(:,:,:,8),Q(:,37),ZERO,G1(:,:,:,15))
  call check_last_AQ_Z(l_switch,G1(:,:,:,15),wf(:,15),G1tensor(:,1),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,118),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,37),ZERO,G1(:,:,:,16))
  call check_last_AQ_W(l_switch,G1(:,:,:,16),wf(:,15),G1tensor(:,2))
  call loop_QV_A(G0(:,:,:,1),wf(:,446),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,53),ZERO,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,2),G1(:,:,:,18))
  call check_last_Q_A(l_switch,G1(:,:,:,18),Q(:,63),ZERO,G2tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,446),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,53),MT,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,2),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,63),MT,G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,446),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,53),MB,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,2),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),MB,G2tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,447),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,53),ZERO,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,2),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),ZERO,G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,447),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,53),MT,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,2),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),MT,G2tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,447),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,53),MB,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,2),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),MB,G2tensor(:,14))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,446),Q(:,53),G1(:,:,:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,29),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,15))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,447),Q(:,53),G1(:,:,:,30))
  call check_last_CV_D(l_switch,G1(:,:,:,30),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,491),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,58),ZERO,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,1),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,63),ZERO,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,491),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,58),MT,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,1),G1(:,:,:,34))
  call check_last_Q_A(l_switch,G1(:,:,:,34),Q(:,63),MT,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,491),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,58),MB,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,1),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),MB,G2tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,492),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,58),ZERO,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,1),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,63),ZERO,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,492),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,58),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,1),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),MT,G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,492),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,58),MB,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,1),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),MB,G2tensor(:,22))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,491),Q(:,58),G1(:,:,:,43))
  call check_last_CV_D(l_switch,G1(:,:,:,43),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,23))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,492),Q(:,58),G1(:,:,:,44))
  call check_last_CV_D(l_switch,G1(:,:,:,44),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,494),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,58),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,1),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,63),ZERO,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,494),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,58),MT,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,1),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,63),MT,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,494),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,58),MB,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,1),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),MB,G2tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,495),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,58),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,1),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),ZERO,G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,495),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,58),MT,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,1),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),MT,G2tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,495),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,58),MB,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,1),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),MB,G2tensor(:,30))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,494),Q(:,58),G1(:,:,:,57))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,31))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,495),Q(:,58),G1(:,:,:,58))
  call check_last_CV_D(l_switch,G1(:,:,:,58),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,32))
  call loop_SA_Q(G0(:,:,:,1),wf(:,204),G0(:,:,:,28),gH)
  call loop_A_Q(G0(:,:,:,28),Q(:,56),MT,G1(:,:,:,59))
  call check_last_AQ_S(l_switch,G1(:,:,:,59),wf(:,27),G1tensor(:,3),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,59),wf(:,64),G1tensor(:,4),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,204),G0(:,:,:,29),gX)
  call loop_A_Q(G0(:,:,:,29),Q(:,56),MT,G1(:,:,:,60))
  call check_last_AQ_S(l_switch,G1(:,:,:,60),wf(:,27),G1tensor(:,5),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,60),wf(:,64),G1tensor(:,6),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,204),G0(:,:,:,30),gPtb)
  call loop_A_Q(G0(:,:,:,30),Q(:,56),MB,G1(:,:,:,61))
  call check_last_AQ_S(l_switch,G1(:,:,:,61),wf(:,27),G1tensor(:,7),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,61),wf(:,64),G1tensor(:,8),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,204),G0(:,:,:,31),gZu)
  call loop_A_Q(G0(:,:,:,31),Q(:,56),MT,G1(:,:,:,62))
  call check_last_AQ_Z(l_switch,G1(:,:,:,62),wf(:,27),G1tensor(:,9),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,62),wf(:,64),G1tensor(:,10),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,204),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,56),MB,G1(:,:,:,63))
  call check_last_AQ_W(l_switch,G1(:,:,:,63),wf(:,27),G1tensor(:,11))
  call check_last_AQ_W(l_switch,G1(:,:,:,63),wf(:,64),G1tensor(:,12))
  call loop_AQ_S(G0(:,:,:,1),wf(:,34),G0(:,:,:,33),gH)
  call loop_SA_Q(G0(:,:,:,33),wf(:,199),G0(:,:,:,34),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,34),Q(:,63),MT,G1tensor(:,13))
  call loop_SA_Q(G0(:,:,:,33),wf(:,226),G0(:,:,:,35),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,35),Q(:,63),MT,G1tensor(:,14))
  call loop_AQ_S(G0(:,:,:,1),wf(:,34),G0(:,:,:,36),gX)
  call loop_SA_Q(G0(:,:,:,36),wf(:,199),G0(:,:,:,37),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,37),Q(:,63),MT,G1tensor(:,15))
  call loop_SA_Q(G0(:,:,:,36),wf(:,226),G0(:,:,:,38),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,38),Q(:,63),MT,G1tensor(:,16))
  call loop_AQ_S(G0(:,:,:,1),wf(:,34),G0(:,:,:,39),gPbt)
  call loop_SA_Q(G0(:,:,:,39),wf(:,199),G0(:,:,:,40),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,40),Q(:,63),MB,G1tensor(:,17))
  call loop_SA_Q(G0(:,:,:,39),wf(:,226),G0(:,:,:,41),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,41),Q(:,63),MB,G1tensor(:,18))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,34),G0(:,:,:,42),gZu)
  call loop_ZA_Q(G0(:,:,:,42),wf(:,199),G0(:,:,:,43),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,43),Q(:,63),MT,G1tensor(:,19))
  call loop_ZA_Q(G0(:,:,:,42),wf(:,226),G0(:,:,:,44),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,44),Q(:,63),MT,G1tensor(:,20))
  call loop_AQ_W(G0(:,:,:,1),wf(:,34),G0(:,:,:,45))
  call loop_WA_Q(G0(:,:,:,45),wf(:,199),G0(:,:,:,46))
  call check_last_A_Q(l_switch,G0(:,:,:,46),Q(:,63),MB,G1tensor(:,21))
  call loop_WA_Q(G0(:,:,:,45),wf(:,226),G0(:,:,:,47))
  call check_last_A_Q(l_switch,G0(:,:,:,47),Q(:,63),MB,G1tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,529),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,58),ZERO,G1(:,:,:,64))
  call loop_QV_A(G1(:,:,:,64),wf(:,1),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,529),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,58),MT,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,1),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,63),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,529),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,58),MB,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,1),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,63),MB,G2tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,530),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,58),ZERO,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,1),G1(:,:,:,71))
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,63),ZERO,G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,530),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,58),MT,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,1),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,63),MT,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,530),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,58),MB,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,1),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),MB,G2tensor(:,38))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,529),Q(:,58),G1(:,:,:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,39))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,530),Q(:,58),G1(:,:,:,77))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,534),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,58),ZERO,G1(:,:,:,78))
  call loop_QV_A(G1(:,:,:,78),wf(:,1),G1(:,:,:,79))
  call check_last_Q_A(l_switch,G1(:,:,:,79),Q(:,63),ZERO,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,534),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,58),MT,G1(:,:,:,80))
  call loop_QV_A(G1(:,:,:,80),wf(:,1),G1(:,:,:,81))
  call check_last_Q_A(l_switch,G1(:,:,:,81),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,534),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,58),MB,G1(:,:,:,82))
  call loop_QV_A(G1(:,:,:,82),wf(:,1),G1(:,:,:,83))
  call check_last_Q_A(l_switch,G1(:,:,:,83),Q(:,63),MB,G2tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,58),ZERO,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,1),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,63),ZERO,G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,58),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,1),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),MT,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,536),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,58),MB,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,1),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),MB,G2tensor(:,46))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,534),Q(:,58),G1(:,:,:,90))
  call check_last_CV_D(l_switch,G1(:,:,:,90),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,536),Q(:,58),G1(:,:,:,91))
  call check_last_CV_D(l_switch,G1(:,:,:,91),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,395),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,57),ZERO,G1(:,:,:,92))
  call loop_QV_A(G1(:,:,:,92),wf(:,41),G1(:,:,:,93))
  call check_last_Q_A(l_switch,G1(:,:,:,93),Q(:,63),ZERO,G2tensor(:,49))
  call loop_QV_A(G0(:,:,:,1),wf(:,395),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,57),MT,G1(:,:,:,94))
  call loop_QV_A(G1(:,:,:,94),wf(:,41),G1(:,:,:,95))
  call check_last_Q_A(l_switch,G1(:,:,:,95),Q(:,63),MT,G2tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,395),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,57),MB,G1(:,:,:,96))
  call loop_QV_A(G1(:,:,:,96),wf(:,41),G1(:,:,:,97))
  call check_last_Q_A(l_switch,G1(:,:,:,97),Q(:,63),MB,G2tensor(:,51))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,395),Q(:,57),G1(:,:,:,98))
  call check_last_CV_D(l_switch,G1(:,:,:,98),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,54),ZERO,G1(:,:,:,99))
  call loop_QV_A(G1(:,:,:,99),wf(:,40),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),ZERO,G2tensor(:,53))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,64))
  call loop_Q_A(G0(:,:,:,64),Q(:,54),MT,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,40),G1(:,:,:,102))
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),MT,G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,393),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,54),MB,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,40),G1(:,:,:,104))
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,63),MB,G2tensor(:,55))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,393),Q(:,54),G1(:,:,:,105))
  call check_last_CV_D(l_switch,G1(:,:,:,105),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,56))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,165),G0(:,:,:,66),gZd)
  call loop_A_Q(G0(:,:,:,66),Q(:,38),ZERO,G1(:,:,:,106))
  call check_last_AQ_Z(l_switch,G1(:,:,:,106),wf(:,45),G1tensor(:,23),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,165),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,38),ZERO,G1(:,:,:,107))
  call check_last_AQ_W(l_switch,G1(:,:,:,107),wf(:,45),G1tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,475),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,57),ZERO,G1(:,:,:,108))
  call loop_QV_A(G1(:,:,:,108),wf(:,41),G1(:,:,:,109))
  call check_last_Q_A(l_switch,G1(:,:,:,109),Q(:,63),ZERO,G2tensor(:,57))
  call loop_QV_A(G0(:,:,:,1),wf(:,475),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,57),MT,G1(:,:,:,110))
  call loop_QV_A(G1(:,:,:,110),wf(:,41),G1(:,:,:,111))
  call check_last_Q_A(l_switch,G1(:,:,:,111),Q(:,63),MT,G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,475),G0(:,:,:,70))
  call loop_Q_A(G0(:,:,:,70),Q(:,57),MB,G1(:,:,:,112))
  call loop_QV_A(G1(:,:,:,112),wf(:,41),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,63),MB,G2tensor(:,59))
  call loop_QV_A(G0(:,:,:,1),wf(:,476),G0(:,:,:,71))
  call loop_Q_A(G0(:,:,:,71),Q(:,57),ZERO,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,41),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,63),ZERO,G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,476),G0(:,:,:,72))
  call loop_Q_A(G0(:,:,:,72),Q(:,57),MT,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,41),G1(:,:,:,117))
  call check_last_Q_A(l_switch,G1(:,:,:,117),Q(:,63),MT,G2tensor(:,61))
  call loop_QV_A(G0(:,:,:,1),wf(:,476),G0(:,:,:,73))
  call loop_Q_A(G0(:,:,:,73),Q(:,57),MB,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,41),G1(:,:,:,119))
  call check_last_Q_A(l_switch,G1(:,:,:,119),Q(:,63),MB,G2tensor(:,62))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,475),Q(:,57),G1(:,:,:,120))
  call check_last_CV_D(l_switch,G1(:,:,:,120),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,63))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,476),Q(:,57),G1(:,:,:,121))
  call check_last_CV_D(l_switch,G1(:,:,:,121),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,64))
  call loop_ZA_Q(G0(:,:,:,1),wf(:,160),G0(:,:,:,74),gZd)
  call loop_A_Q(G0(:,:,:,74),Q(:,41),ZERO,G1(:,:,:,122))
  call check_last_AQ_Z(l_switch,G1(:,:,:,122),wf(:,53),G1tensor(:,25),gZd)
  call loop_WA_Q(G0(:,:,:,1),wf(:,160),G0(:,:,:,75))
  call loop_A_Q(G0(:,:,:,75),Q(:,41),ZERO,G1(:,:,:,123))
  call check_last_AQ_W(l_switch,G1(:,:,:,123),wf(:,53),G1tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,478),G0(:,:,:,76))
  call loop_Q_A(G0(:,:,:,76),Q(:,57),ZERO,G1(:,:,:,124))
  call loop_QV_A(G1(:,:,:,124),wf(:,41),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),ZERO,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,478),G0(:,:,:,77))
  call loop_Q_A(G0(:,:,:,77),Q(:,57),MT,G1(:,:,:,126))
  call loop_QV_A(G1(:,:,:,126),wf(:,41),G1(:,:,:,127))
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),MT,G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,478),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,57),MB,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,41),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),MB,G2tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,479),G0(:,:,:,79))
  call loop_Q_A(G0(:,:,:,79),Q(:,57),ZERO,G1(:,:,:,130))
  call loop_QV_A(G1(:,:,:,130),wf(:,41),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,63),ZERO,G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,479),G0(:,:,:,80))
  call loop_Q_A(G0(:,:,:,80),Q(:,57),MT,G1(:,:,:,132))
  call loop_QV_A(G1(:,:,:,132),wf(:,41),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),MT,G2tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,479),G0(:,:,:,81))
  call loop_Q_A(G0(:,:,:,81),Q(:,57),MB,G1(:,:,:,134))
  call loop_QV_A(G1(:,:,:,134),wf(:,41),G1(:,:,:,135))
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),MB,G2tensor(:,70))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,478),Q(:,57),G1(:,:,:,136))
  call check_last_CV_D(l_switch,G1(:,:,:,136),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,71))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,479),Q(:,57),G1(:,:,:,137))
  call check_last_CV_D(l_switch,G1(:,:,:,137),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,459),G0(:,:,:,82))
  call loop_Q_A(G0(:,:,:,82),Q(:,54),ZERO,G1(:,:,:,138))
  call loop_QV_A(G1(:,:,:,138),wf(:,40),G1(:,:,:,139))
  call check_last_Q_A(l_switch,G1(:,:,:,139),Q(:,63),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,459),G0(:,:,:,83))
  call loop_Q_A(G0(:,:,:,83),Q(:,54),MT,G1(:,:,:,140))
  call loop_QV_A(G1(:,:,:,140),wf(:,40),G1(:,:,:,141))
  call check_last_Q_A(l_switch,G1(:,:,:,141),Q(:,63),MT,G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,459),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,54),MB,G1(:,:,:,142))
  call loop_QV_A(G1(:,:,:,142),wf(:,40),G1(:,:,:,143))
  call check_last_Q_A(l_switch,G1(:,:,:,143),Q(:,63),MB,G2tensor(:,75))
  call loop_QV_A(G0(:,:,:,1),wf(:,460),G0(:,:,:,85))
  call loop_Q_A(G0(:,:,:,85),Q(:,54),ZERO,G1(:,:,:,144))
  call loop_QV_A(G1(:,:,:,144),wf(:,40),G1(:,:,:,145))
  call check_last_Q_A(l_switch,G1(:,:,:,145),Q(:,63),ZERO,G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,460),G0(:,:,:,86))
  call loop_Q_A(G0(:,:,:,86),Q(:,54),MT,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,40),G1(:,:,:,147))
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,63),MT,G2tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,460),G0(:,:,:,87))
  call loop_Q_A(G0(:,:,:,87),Q(:,54),MB,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,40),G1(:,:,:,149))
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,63),MB,G2tensor(:,78))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,459),Q(:,54),G1(:,:,:,150))
  call check_last_CV_D(l_switch,G1(:,:,:,150),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,79))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,460),Q(:,54),G1(:,:,:,151))
  call check_last_CV_D(l_switch,G1(:,:,:,151),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,462),G0(:,:,:,88))
  call loop_Q_A(G0(:,:,:,88),Q(:,54),ZERO,G1(:,:,:,152))
  call loop_QV_A(G1(:,:,:,152),wf(:,40),G1(:,:,:,153))
  call check_last_Q_A(l_switch,G1(:,:,:,153),Q(:,63),ZERO,G2tensor(:,81))
  call loop_QV_A(G0(:,:,:,1),wf(:,462),G0(:,:,:,89))
  call loop_Q_A(G0(:,:,:,89),Q(:,54),MT,G1(:,:,:,154))
  call loop_QV_A(G1(:,:,:,154),wf(:,40),G1(:,:,:,155))
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,63),MT,G2tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,462),G0(:,:,:,90))
  call loop_Q_A(G0(:,:,:,90),Q(:,54),MB,G1(:,:,:,156))
  call loop_QV_A(G1(:,:,:,156),wf(:,40),G1(:,:,:,157))
  call check_last_Q_A(l_switch,G1(:,:,:,157),Q(:,63),MB,G2tensor(:,83))
  call loop_QV_A(G0(:,:,:,1),wf(:,463),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,54),ZERO,G1(:,:,:,158))
  call loop_QV_A(G1(:,:,:,158),wf(:,40),G1(:,:,:,159))
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,63),ZERO,G2tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,463),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,54),MT,G1(:,:,:,160))
  call loop_QV_A(G1(:,:,:,160),wf(:,40),G1(:,:,:,161))
  call check_last_Q_A(l_switch,G1(:,:,:,161),Q(:,63),MT,G2tensor(:,85))
  call loop_QV_A(G0(:,:,:,1),wf(:,463),G0(:,:,:,93))
  call loop_Q_A(G0(:,:,:,93),Q(:,54),MB,G1(:,:,:,162))
  call loop_QV_A(G1(:,:,:,162),wf(:,40),G1(:,:,:,163))
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),MB,G2tensor(:,86))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,462),Q(:,54),G1(:,:,:,164))
  call check_last_CV_D(l_switch,G1(:,:,:,164),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,87))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,463),Q(:,54),G1(:,:,:,165))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,509),G0(:,:,:,94))
  call loop_Q_A(G0(:,:,:,94),Q(:,57),ZERO,G1(:,:,:,166))
  call loop_QV_A(G1(:,:,:,166),wf(:,41),G1(:,:,:,167))
  call check_last_Q_A(l_switch,G1(:,:,:,167),Q(:,63),ZERO,G2tensor(:,89))
  call loop_QV_A(G0(:,:,:,1),wf(:,509),G0(:,:,:,95))
  call loop_Q_A(G0(:,:,:,95),Q(:,57),MT,G1(:,:,:,168))
  call loop_QV_A(G1(:,:,:,168),wf(:,41),G1(:,:,:,169))
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,63),MT,G2tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,509),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,57),MB,G1(:,:,:,170))
  call loop_QV_A(G1(:,:,:,170),wf(:,41),G1(:,:,:,171))
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,63),MB,G2tensor(:,91))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,97))
  call loop_Q_A(G0(:,:,:,97),Q(:,57),ZERO,G1(:,:,:,172))
  call loop_QV_A(G1(:,:,:,172),wf(:,41),G1(:,:,:,173))
  call check_last_Q_A(l_switch,G1(:,:,:,173),Q(:,63),ZERO,G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,98))
  call loop_Q_A(G0(:,:,:,98),Q(:,57),MT,G1(:,:,:,174))
  call loop_QV_A(G1(:,:,:,174),wf(:,41),G1(:,:,:,175))
  call check_last_Q_A(l_switch,G1(:,:,:,175),Q(:,63),MT,G2tensor(:,93))
  call loop_QV_A(G0(:,:,:,1),wf(:,510),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,57),MB,G1(:,:,:,176))
  call loop_QV_A(G1(:,:,:,176),wf(:,41),G1(:,:,:,177))
  call check_last_Q_A(l_switch,G1(:,:,:,177),Q(:,63),MB,G2tensor(:,94))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,509),Q(:,57),G1(:,:,:,178))
  call check_last_CV_D(l_switch,G1(:,:,:,178),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,95))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,510),Q(:,57),G1(:,:,:,179))
  call check_last_CV_D(l_switch,G1(:,:,:,179),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,514),G0(:,:,:,100))
  call loop_Q_A(G0(:,:,:,100),Q(:,57),ZERO,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,41),G1(:,:,:,181))
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),ZERO,G2tensor(:,97))
  call loop_QV_A(G0(:,:,:,1),wf(:,514),G0(:,:,:,101))
  call loop_Q_A(G0(:,:,:,101),Q(:,57),MT,G1(:,:,:,182))
  call loop_QV_A(G1(:,:,:,182),wf(:,41),G1(:,:,:,183))
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,63),MT,G2tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,514),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,57),MB,G1(:,:,:,184))
  call loop_QV_A(G1(:,:,:,184),wf(:,41),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),MB,G2tensor(:,99))
  call loop_QV_A(G0(:,:,:,1),wf(:,516),G0(:,:,:,103))
  call loop_Q_A(G0(:,:,:,103),Q(:,57),ZERO,G1(:,:,:,186))
  call loop_QV_A(G1(:,:,:,186),wf(:,41),G1(:,:,:,187))
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,63),ZERO,G2tensor(:,100))
  call loop_QV_A(G0(:,:,:,1),wf(:,516),G0(:,:,:,104))
  call loop_Q_A(G0(:,:,:,104),Q(:,57),MT,G1(:,:,:,188))
  call loop_QV_A(G1(:,:,:,188),wf(:,41),G1(:,:,:,189))
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,63),MT,G2tensor(:,101))
  call loop_QV_A(G0(:,:,:,1),wf(:,516),G0(:,:,:,105))
  call loop_Q_A(G0(:,:,:,105),Q(:,57),MB,G1(:,:,:,190))
  call loop_QV_A(G1(:,:,:,190),wf(:,41),G1(:,:,:,191))
  call check_last_Q_A(l_switch,G1(:,:,:,191),Q(:,63),MB,G2tensor(:,102))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,514),Q(:,57),G1(:,:,:,192))
  call check_last_CV_D(l_switch,G1(:,:,:,192),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,103))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,516),Q(:,57),G1(:,:,:,193))
  call check_last_CV_D(l_switch,G1(:,:,:,193),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,104))
  call loop_AQ_S(G0(:,:,:,1),wf(:,69),G0(:,:,:,106),gH)
  call loop_SA_Q(G0(:,:,:,106),wf(:,291),G0(:,:,:,107),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,107),Q(:,63),MT,G1tensor(:,27))
  call loop_SA_Q(G0(:,:,:,106),wf(:,316),G0(:,:,:,108),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,108),Q(:,63),MT,G1tensor(:,28))
  call loop_AQ_S(G0(:,:,:,1),wf(:,69),G0(:,:,:,109),gX)
  call loop_SA_Q(G0(:,:,:,109),wf(:,291),G0(:,:,:,110),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,110),Q(:,63),MT,G1tensor(:,29))
  call loop_SA_Q(G0(:,:,:,109),wf(:,316),G0(:,:,:,111),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,111),Q(:,63),MT,G1tensor(:,30))
  call loop_AQ_S(G0(:,:,:,1),wf(:,69),G0(:,:,:,112),gPbt)
  call loop_SA_Q(G0(:,:,:,112),wf(:,291),G0(:,:,:,113),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,113),Q(:,63),MB,G1tensor(:,31))
  call loop_SA_Q(G0(:,:,:,112),wf(:,316),G0(:,:,:,114),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,114),Q(:,63),MB,G1tensor(:,32))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,69),G0(:,:,:,115),gZu)
  call loop_ZA_Q(G0(:,:,:,115),wf(:,291),G0(:,:,:,116),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,116),Q(:,63),MT,G1tensor(:,33))
  call loop_ZA_Q(G0(:,:,:,115),wf(:,316),G0(:,:,:,117),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,117),Q(:,63),MT,G1tensor(:,34))
  call loop_AQ_W(G0(:,:,:,1),wf(:,69),G0(:,:,:,118))
  call loop_WA_Q(G0(:,:,:,118),wf(:,291),G0(:,:,:,119))
  call check_last_A_Q(l_switch,G0(:,:,:,119),Q(:,63),MB,G1tensor(:,35))
  call loop_WA_Q(G0(:,:,:,118),wf(:,316),G0(:,:,:,120))
  call check_last_A_Q(l_switch,G0(:,:,:,120),Q(:,63),MB,G1tensor(:,36))
  call loop_SA_Q(G0(:,:,:,1),wf(:,229),G0(:,:,:,121),gH)
  call loop_A_Q(G0(:,:,:,121),Q(:,52),MT,G1(:,:,:,194))
  call check_last_AQ_S(l_switch,G1(:,:,:,194),wf(:,83),G1tensor(:,37),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,194),wf(:,98),G1tensor(:,38),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,229),G0(:,:,:,122),gX)
  call loop_A_Q(G0(:,:,:,122),Q(:,52),MT,G1(:,:,:,195))
  call check_last_AQ_S(l_switch,G1(:,:,:,195),wf(:,83),G1tensor(:,39),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,195),wf(:,98),G1tensor(:,40),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,229),G0(:,:,:,123),gPtb)
  call loop_A_Q(G0(:,:,:,123),Q(:,52),MB,G1(:,:,:,196))
  call check_last_AQ_S(l_switch,G1(:,:,:,196),wf(:,83),G1tensor(:,41),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,196),wf(:,98),G1tensor(:,42),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,229),G0(:,:,:,124),gZu)
  call loop_A_Q(G0(:,:,:,124),Q(:,52),MT,G1(:,:,:,197))
  call check_last_AQ_Z(l_switch,G1(:,:,:,197),wf(:,83),G1tensor(:,43),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,197),wf(:,98),G1tensor(:,44),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,229),G0(:,:,:,125))
  call loop_A_Q(G0(:,:,:,125),Q(:,52),MB,G1(:,:,:,198))
  call check_last_AQ_W(l_switch,G1(:,:,:,198),wf(:,83),G1tensor(:,45))
  call check_last_AQ_W(l_switch,G1(:,:,:,198),wf(:,98),G1tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,519),G0(:,:,:,126))
  call loop_Q_A(G0(:,:,:,126),Q(:,54),ZERO,G1(:,:,:,199))
  call loop_QV_A(G1(:,:,:,199),wf(:,40),G1(:,:,:,200))
  call check_last_Q_A(l_switch,G1(:,:,:,200),Q(:,63),ZERO,G2tensor(:,105))
  call loop_QV_A(G0(:,:,:,1),wf(:,519),G0(:,:,:,127))
  call loop_Q_A(G0(:,:,:,127),Q(:,54),MT,G1(:,:,:,201))
  call loop_QV_A(G1(:,:,:,201),wf(:,40),G1(:,:,:,202))
  call check_last_Q_A(l_switch,G1(:,:,:,202),Q(:,63),MT,G2tensor(:,106))
  call loop_QV_A(G0(:,:,:,1),wf(:,519),G0(:,:,:,128))
  call loop_Q_A(G0(:,:,:,128),Q(:,54),MB,G1(:,:,:,203))
  call loop_QV_A(G1(:,:,:,203),wf(:,40),G1(:,:,:,204))
  call check_last_Q_A(l_switch,G1(:,:,:,204),Q(:,63),MB,G2tensor(:,107))
  call loop_QV_A(G0(:,:,:,1),wf(:,520),G0(:,:,:,129))
  call loop_Q_A(G0(:,:,:,129),Q(:,54),ZERO,G1(:,:,:,205))
  call loop_QV_A(G1(:,:,:,205),wf(:,40),G1(:,:,:,206))
  call check_last_Q_A(l_switch,G1(:,:,:,206),Q(:,63),ZERO,G2tensor(:,108))
  call loop_QV_A(G0(:,:,:,1),wf(:,520),G0(:,:,:,130))
  call loop_Q_A(G0(:,:,:,130),Q(:,54),MT,G1(:,:,:,207))
  call loop_QV_A(G1(:,:,:,207),wf(:,40),G1(:,:,:,208))
  call check_last_Q_A(l_switch,G1(:,:,:,208),Q(:,63),MT,G2tensor(:,109))
  call loop_QV_A(G0(:,:,:,1),wf(:,520),G0(:,:,:,131))
  call loop_Q_A(G0(:,:,:,131),Q(:,54),MB,G1(:,:,:,209))
  call loop_QV_A(G1(:,:,:,209),wf(:,40),G1(:,:,:,210))
  call check_last_Q_A(l_switch,G1(:,:,:,210),Q(:,63),MB,G2tensor(:,110))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,519),Q(:,54),G1(:,:,:,211))
  call check_last_CV_D(l_switch,G1(:,:,:,211),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,111))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,520),Q(:,54),G1(:,:,:,212))
  call check_last_CV_D(l_switch,G1(:,:,:,212),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,112))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,132))
  call loop_Q_A(G0(:,:,:,132),Q(:,54),ZERO,G1(:,:,:,213))
  call loop_QV_A(G1(:,:,:,213),wf(:,40),G1(:,:,:,214))
  call check_last_Q_A(l_switch,G1(:,:,:,214),Q(:,63),ZERO,G2tensor(:,113))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,133))
  call loop_Q_A(G0(:,:,:,133),Q(:,54),MT,G1(:,:,:,215))
  call loop_QV_A(G1(:,:,:,215),wf(:,40),G1(:,:,:,216))
  call check_last_Q_A(l_switch,G1(:,:,:,216),Q(:,63),MT,G2tensor(:,114))
  call loop_QV_A(G0(:,:,:,1),wf(:,524),G0(:,:,:,134))
  call loop_Q_A(G0(:,:,:,134),Q(:,54),MB,G1(:,:,:,217))
  call loop_QV_A(G1(:,:,:,217),wf(:,40),G1(:,:,:,218))
  call check_last_Q_A(l_switch,G1(:,:,:,218),Q(:,63),MB,G2tensor(:,115))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,135))
  call loop_Q_A(G0(:,:,:,135),Q(:,54),ZERO,G1(:,:,:,219))
  call loop_QV_A(G1(:,:,:,219),wf(:,40),G1(:,:,:,220))
  call check_last_Q_A(l_switch,G1(:,:,:,220),Q(:,63),ZERO,G2tensor(:,116))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,136))
  call loop_Q_A(G0(:,:,:,136),Q(:,54),MT,G1(:,:,:,221))
  call loop_QV_A(G1(:,:,:,221),wf(:,40),G1(:,:,:,222))
  call check_last_Q_A(l_switch,G1(:,:,:,222),Q(:,63),MT,G2tensor(:,117))
  call loop_QV_A(G0(:,:,:,1),wf(:,526),G0(:,:,:,137))
  call loop_Q_A(G0(:,:,:,137),Q(:,54),MB,G1(:,:,:,223))
  call loop_QV_A(G1(:,:,:,223),wf(:,40),G1(:,:,:,224))
  call check_last_Q_A(l_switch,G1(:,:,:,224),Q(:,63),MB,G2tensor(:,118))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,524),Q(:,54),G1(:,:,:,225))
  call check_last_CV_D(l_switch,G1(:,:,:,225),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,119))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,526),Q(:,54),G1(:,:,:,226))
  call check_last_CV_D(l_switch,G1(:,:,:,226),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,120))
  call loop_QV_A(G0(:,:,:,1),wf(:,499),G0(:,:,:,138))
  call loop_Q_A(G0(:,:,:,138),Q(:,53),ZERO,G1(:,:,:,227))
  call loop_QV_A(G1(:,:,:,227),wf(:,2),G1(:,:,:,228))
  call check_last_Q_A(l_switch,G1(:,:,:,228),Q(:,63),ZERO,G2tensor(:,121))
  call loop_QV_A(G0(:,:,:,1),wf(:,499),G0(:,:,:,139))
  call loop_Q_A(G0(:,:,:,139),Q(:,53),MT,G1(:,:,:,229))
  call loop_QV_A(G1(:,:,:,229),wf(:,2),G1(:,:,:,230))
  call check_last_Q_A(l_switch,G1(:,:,:,230),Q(:,63),MT,G2tensor(:,122))
  call loop_QV_A(G0(:,:,:,1),wf(:,499),G0(:,:,:,140))
  call loop_Q_A(G0(:,:,:,140),Q(:,53),MB,G1(:,:,:,231))
  call loop_QV_A(G1(:,:,:,231),wf(:,2),G1(:,:,:,232))
  call check_last_Q_A(l_switch,G1(:,:,:,232),Q(:,63),MB,G2tensor(:,123))
  call loop_QV_A(G0(:,:,:,1),wf(:,500),G0(:,:,:,141))
  call loop_Q_A(G0(:,:,:,141),Q(:,53),ZERO,G1(:,:,:,233))
  call loop_QV_A(G1(:,:,:,233),wf(:,2),G1(:,:,:,234))
  call check_last_Q_A(l_switch,G1(:,:,:,234),Q(:,63),ZERO,G2tensor(:,124))
  call loop_QV_A(G0(:,:,:,1),wf(:,500),G0(:,:,:,142))
  call loop_Q_A(G0(:,:,:,142),Q(:,53),MT,G1(:,:,:,235))
  call loop_QV_A(G1(:,:,:,235),wf(:,2),G1(:,:,:,236))
  call check_last_Q_A(l_switch,G1(:,:,:,236),Q(:,63),MT,G2tensor(:,125))
  call loop_QV_A(G0(:,:,:,1),wf(:,500),G0(:,:,:,143))
  call loop_Q_A(G0(:,:,:,143),Q(:,53),MB,G1(:,:,:,237))
  call loop_QV_A(G1(:,:,:,237),wf(:,2),G1(:,:,:,238))
  call check_last_Q_A(l_switch,G1(:,:,:,238),Q(:,63),MB,G2tensor(:,126))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,499),Q(:,53),G1(:,:,:,239))
  call check_last_CV_D(l_switch,G1(:,:,:,239),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,127))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,500),Q(:,53),G1(:,:,:,240))
  call check_last_CV_D(l_switch,G1(:,:,:,240),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,128))
  call loop_QV_A(G0(:,:,:,1),wf(:,504),G0(:,:,:,144))
  call loop_Q_A(G0(:,:,:,144),Q(:,53),ZERO,G1(:,:,:,241))
  call loop_QV_A(G1(:,:,:,241),wf(:,2),G1(:,:,:,242))
  call check_last_Q_A(l_switch,G1(:,:,:,242),Q(:,63),ZERO,G2tensor(:,129))
  call loop_QV_A(G0(:,:,:,1),wf(:,504),G0(:,:,:,145))
  call loop_Q_A(G0(:,:,:,145),Q(:,53),MT,G1(:,:,:,243))
  call loop_QV_A(G1(:,:,:,243),wf(:,2),G1(:,:,:,244))
  call check_last_Q_A(l_switch,G1(:,:,:,244),Q(:,63),MT,G2tensor(:,130))
  call loop_QV_A(G0(:,:,:,1),wf(:,504),G0(:,:,:,146))
  call loop_Q_A(G0(:,:,:,146),Q(:,53),MB,G1(:,:,:,245))
  call loop_QV_A(G1(:,:,:,245),wf(:,2),G1(:,:,:,246))
  call check_last_Q_A(l_switch,G1(:,:,:,246),Q(:,63),MB,G2tensor(:,131))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,147))
  call loop_Q_A(G0(:,:,:,147),Q(:,53),ZERO,G1(:,:,:,247))
  call loop_QV_A(G1(:,:,:,247),wf(:,2),G1(:,:,:,248))
  call check_last_Q_A(l_switch,G1(:,:,:,248),Q(:,63),ZERO,G2tensor(:,132))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,148))
  call loop_Q_A(G0(:,:,:,148),Q(:,53),MT,G1(:,:,:,249))
  call loop_QV_A(G1(:,:,:,249),wf(:,2),G1(:,:,:,250))
  call check_last_Q_A(l_switch,G1(:,:,:,250),Q(:,63),MT,G2tensor(:,133))
  call loop_QV_A(G0(:,:,:,1),wf(:,506),G0(:,:,:,149))
  call loop_Q_A(G0(:,:,:,149),Q(:,53),MB,G1(:,:,:,251))
  call loop_QV_A(G1(:,:,:,251),wf(:,2),G1(:,:,:,252))
  call check_last_Q_A(l_switch,G1(:,:,:,252),Q(:,63),MB,G2tensor(:,134))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,504),Q(:,53),G1(:,:,:,253))
  call check_last_CV_D(l_switch,G1(:,:,:,253),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,135))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,506),Q(:,53),G1(:,:,:,254))
  call check_last_CV_D(l_switch,G1(:,:,:,254),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,136))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(440)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(440)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(441)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(441)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(441)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(441)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(440)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(440)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(22)*M(7))+c(19)*M(11)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(44)*M(7)-c(41)*M(11)) * den(441)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(70)*M(6)+c(66)*(-M(2)-M(8))+c(61)*M(12)) * den(440)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(213)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(74)*M(3))+c(73)*(M(1)+M(7))-c(72)*M(11)) * den(213)
  T1sum(1:5,6) = T1sum(1:5,6) + Gcoeff * G1tensor(:,2)
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(442)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(442)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(443)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(443)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(443)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(443)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(442)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(442)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(22)*M(7))+c(19)*M(11)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(44)*M(7)-c(41)*M(11)) * den(443)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(70)*M(4)+c(66)*(-M(2)-M(8))+c(61)*M(12)) * den(442)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(444)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(444)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(445)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(445)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(445)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(445)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(444)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(444)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(22)*M(1))+c(19)*M(11)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(44)*M(1)-c(41)*M(11)) * den(445)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(70)*M(4)+c(66)*(-M(2)-M(8))+c(61)*M(12)) * den(444)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(446)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(446)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(447)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(447)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(447)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(447)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(446)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8))+c(111)*M(12)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8))+c(107)*M(12)) * den(446)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(22)*M(1))+c(19)*M(11)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(44)*M(1)-c(41)*M(11)) * den(447)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(70)*M(6)+c(66)*(-M(2)-M(8))+c(61)*M(12)) * den(446)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(87)*M(3)+c(84)*(-M(7)-M(9))+c(83)*M(11)) * den(222)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(87)*M(3))+c(84)*(M(7)+M(9))-c(83)*M(11)) * den(222)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(78)*M(3))+c(77)*(M(7)+M(9))-c(76)*M(11)) * den(222)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(222)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(74)*M(3))+c(73)*(M(7)+M(9))-c(72)*M(11)) * den(222)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(7)-M(9))+c(83)*M(11)) * den(226)
  T1sum(1:5,12) = T1sum(1:5,12) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(7)+M(9))-c(83)*M(11)) * den(226)
  T1sum(1:5,13) = T1sum(1:5,13) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(78)*M(5))+c(77)*(M(7)+M(9))-c(76)*M(11)) * den(226)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(226)
  T1sum(1:5,13) = T1sum(1:5,13) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(74)*M(5))+c(73)*(M(7)+M(9))-c(72)*M(11)) * den(226)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(454)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(454)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(455)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(455)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(455)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(455)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(8)-M(10))+c(111)*M(12)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(8)-M(10))+c(107)*M(12)) * den(454)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(8)-M(10))+c(111)*M(12)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(8)-M(10))+c(107)*M(12)) * den(454)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(455)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(70)*M(6)+c(66)*(-M(8)-M(10))+c(61)*M(12)) * den(454)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(456)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(456)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(457)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(457)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(457)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(457)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(8)-M(10))+c(111)*M(12)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(8)-M(10))+c(107)*M(12)) * den(456)
  T2sum(1:15,278) = T2sum(1:15,278) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(8)-M(10))+c(111)*M(12)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(8)-M(10))+c(107)*M(12)) * den(456)
  T2sum(1:15,279) = T2sum(1:15,279) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(457)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(70)*M(4)+c(66)*(-M(8)-M(10))+c(61)*M(12)) * den(456)
  T2sum(1:15,269) = T2sum(1:15,269) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(106)*(-M(2)+M(8))) * den(242)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(105)*(-M(2)+M(8))) * den(242)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(106)*(-M(2)+M(8))) * den(242)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(105)*(-M(2)+M(8))) * den(242)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(51)*(-M(2)+M(8))) * den(242)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(106)*(M(2)-M(8))) * den(238)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(105)*(M(2)-M(8))) * den(238)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(106)*(M(2)-M(8))) * den(238)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(105)*(M(2)-M(8))) * den(238)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(51)*(M(2)-M(8))) * den(238)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(255)
  T1sum(1:5,16) = T1sum(1:5,16) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(73)*(-M(3)-M(5))+c(74)*M(7)+c(72)*M(9)) * den(255)
  T1sum(1:5,17) = T1sum(1:5,17) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(98)*M(5)-c(97)*M(9)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(96)*M(5)-c(95)*M(9)) * den(458)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(98)*M(5)-c(97)*M(9)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(96)*M(5)-c(95)*M(9)) * den(458)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(104)*M(5))+c(103)*M(9)) * den(459)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(102)*M(5))+c(101)*M(9)) * den(459)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(104)*M(5))+c(103)*M(9)) * den(459)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(102)*M(5))+c(101)*M(9)) * den(459)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(113)*(M(4)+M(6))-c(114)*M(8)-c(111)*M(10)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(109)*(M(4)+M(6))-c(110)*M(8)-c(107)*M(10)) * den(458)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(113)*(M(4)+M(6))-c(114)*M(8)-c(111)*M(10)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(109)*(M(4)+M(6))-c(110)*M(8)-c(107)*M(10)) * den(458)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(22)*M(5)-c(19)*M(9)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(44)*M(5))+c(41)*M(9)) * den(459)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(66)*(M(4)+M(6))-c(70)*M(8)-c(61)*M(10)) * den(458)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(258)
  T1sum(1:5,19) = T1sum(1:5,19) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(74)*M(1)+c(73)*(-M(3)-M(5))+c(72)*M(9)) * den(258)
  T1sum(1:5,20) = T1sum(1:5,20) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(98)*M(5)-c(97)*M(9)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(96)*M(5)-c(95)*M(9)) * den(460)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(98)*M(5)-c(97)*M(9)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(96)*M(5)-c(95)*M(9)) * den(460)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(104)*M(5))+c(103)*M(9)) * den(461)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(102)*M(5))+c(101)*M(9)) * den(461)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(104)*M(5))+c(103)*M(9)) * den(461)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(102)*M(5))+c(101)*M(9)) * den(461)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(114)*M(2))+c(113)*(M(4)+M(6))-c(111)*M(10)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(110)*M(2))+c(109)*(M(4)+M(6))-c(107)*M(10)) * den(460)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(114)*M(2))+c(113)*(M(4)+M(6))-c(111)*M(10)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(110)*M(2))+c(109)*(M(4)+M(6))-c(107)*M(10)) * den(460)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(22)*M(5)-c(19)*M(9)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(44)*M(5))+c(41)*M(9)) * den(461)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(70)*M(2))+c(66)*(M(4)+M(6))-c(61)*M(10)) * den(460)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(98)*M(3)-c(97)*M(9)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(96)*M(3)-c(95)*M(9)) * den(462)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(98)*M(3)-c(97)*M(9)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(96)*M(3)-c(95)*M(9)) * den(462)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(104)*M(3))+c(103)*M(9)) * den(463)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(102)*M(3))+c(101)*M(9)) * den(463)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(104)*M(3))+c(103)*M(9)) * den(463)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(102)*M(3))+c(101)*M(9)) * den(463)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(114)*M(2))+c(113)*(M(4)+M(6))-c(111)*M(10)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(110)*M(2))+c(109)*(M(4)+M(6))-c(107)*M(10)) * den(462)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(114)*M(2))+c(113)*(M(4)+M(6))-c(111)*M(10)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(110)*M(2))+c(109)*(M(4)+M(6))-c(107)*M(10)) * den(462)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(22)*M(3)-c(19)*M(9)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(44)*M(3))+c(41)*M(9)) * den(463)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(70)*M(2))+c(66)*(M(4)+M(6))-c(61)*M(10)) * den(462)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(98)*M(3)-c(97)*M(9)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(96)*M(3)-c(95)*M(9)) * den(464)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(98)*M(3)-c(97)*M(9)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(96)*M(3)-c(95)*M(9)) * den(464)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(104)*M(3))+c(103)*M(9)) * den(465)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(102)*M(3))+c(101)*M(9)) * den(465)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(104)*M(3))+c(103)*M(9)) * den(465)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(102)*M(3))+c(101)*M(9)) * den(465)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(113)*(M(4)+M(6))-c(114)*M(8)-c(111)*M(10)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(109)*(M(4)+M(6))-c(110)*M(8)-c(107)*M(10)) * den(464)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(113)*(M(4)+M(6))-c(114)*M(8)-c(111)*M(10)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(109)*(M(4)+M(6))-c(110)*M(8)-c(107)*M(10)) * den(464)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(22)*M(3)-c(19)*M(9)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(44)*M(3))+c(41)*M(9)) * den(465)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(66)*(M(4)+M(6))-c(70)*M(8)-c(61)*M(10)) * den(464)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(87)*M(7))-c(83)*M(9)+c(84)*(M(3)+M(11))) * den(265)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(87)*M(7)+c(83)*M(9)+c(84)*(-M(3)-M(11))) * den(265)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(78)*M(7)+c(76)*M(9)+c(77)*(-M(3)-M(11))) * den(265)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(265)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(74)*M(7)+c(72)*M(9)+c(73)*(-M(3)-M(11))) * den(265)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(469)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(469)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(470)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(470)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(470)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(470)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(114)*M(2))-c(111)*M(10)+c(113)*(M(4)+M(12))) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(110)*M(2))-c(107)*M(10)+c(109)*(M(4)+M(12))) * den(469)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(114)*M(2))-c(111)*M(10)+c(113)*(M(4)+M(12))) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(110)*M(2))-c(107)*M(10)+c(109)*(M(4)+M(12))) * den(469)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(470)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(70)*M(2))-c(61)*M(10)+c(66)*(M(4)+M(12))) * den(469)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(474)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(474)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(475)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(475)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(475)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(475)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,102)
  Gcoeff = (-(c(114)*M(8))-c(111)*M(10)+c(113)*(M(4)+M(12))) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(110)*M(8))-c(107)*M(10)+c(109)*(M(4)+M(12))) * den(474)
  T2sum(1:15,280) = T2sum(1:15,280) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(114)*M(8))-c(111)*M(10)+c(113)*(M(4)+M(12))) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(110)*M(8))-c(107)*M(10)+c(109)*(M(4)+M(12))) * den(474)
  T2sum(1:15,281) = T2sum(1:15,281) + Gcoeff * G2tensor(:,99)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(475)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(70)*M(8))-c(61)*M(10)+c(66)*(M(4)+M(12))) * den(474)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(87)*M(1))-c(83)*M(9)+c(84)*(M(3)+M(11))) * den(269)
  T1sum(1:5,22) = T1sum(1:5,22) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(87)*M(1)+c(83)*M(9)+c(84)*(-M(3)-M(11))) * den(269)
  T1sum(1:5,23) = T1sum(1:5,23) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(78)*M(1)+c(76)*M(9)+c(77)*(-M(3)-M(11))) * den(269)
  T1sum(1:5,24) = T1sum(1:5,24) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(269)
  T1sum(1:5,23) = T1sum(1:5,23) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(74)*M(1)+c(72)*M(9)+c(73)*(-M(3)-M(11))) * den(269)
  T1sum(1:5,24) = T1sum(1:5,24) + Gcoeff * G1tensor(:,35)
  Gcoeff = (-(c(87)*M(1))-c(83)*M(9)+c(84)*(M(5)+M(11))) * den(285)
  T1sum(1:5,26) = T1sum(1:5,26) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(87)*M(1)+c(83)*M(9)+c(84)*(-M(5)-M(11))) * den(285)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(78)*M(1)+c(76)*M(9)+c(77)*(-M(5)-M(11))) * den(285)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(285)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(74)*M(1)+c(72)*M(9)+c(73)*(-M(5)-M(11))) * den(285)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,45)
  Gcoeff = (-(c(87)*M(7))-c(83)*M(9)+c(84)*(M(5)+M(11))) * den(289)
  T1sum(1:5,12) = T1sum(1:5,12) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(87)*M(7)+c(83)*M(9)+c(84)*(-M(5)-M(11))) * den(289)
  T1sum(1:5,13) = T1sum(1:5,13) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(78)*M(7)+c(76)*M(9)+c(77)*(-M(5)-M(11))) * den(289)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(289)
  T1sum(1:5,13) = T1sum(1:5,13) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(74)*M(7)+c(72)*M(9)+c(73)*(-M(5)-M(11))) * den(289)
  T1sum(1:5,14) = T1sum(1:5,14) + Gcoeff * G1tensor(:,22)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(482)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(482)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(483)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(483)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(483)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(483)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(114)*M(8))-c(111)*M(10)+c(113)*(M(6)+M(12))) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(110)*M(8))-c(107)*M(10)+c(109)*(M(6)+M(12))) * den(482)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(114)*M(8))-c(111)*M(10)+c(113)*(M(6)+M(12))) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(110)*M(8))-c(107)*M(10)+c(109)*(M(6)+M(12))) * den(482)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,107)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(483)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(70)*M(8))-c(61)*M(10)+c(66)*(M(6)+M(12))) * den(482)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(484)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(97)*M(9))+c(98)*M(11)) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(95)*M(9))+c(96)*M(11)) * den(484)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(485)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(485)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(485)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(101)*M(9)-c(102)*M(11)) * den(485)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(114)*M(2))-c(111)*M(10)+c(113)*(M(6)+M(12))) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(110)*M(2))-c(107)*M(10)+c(109)*(M(6)+M(12))) * den(484)
  T2sum(1:15,282) = T2sum(1:15,282) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(114)*M(2))-c(111)*M(10)+c(113)*(M(6)+M(12))) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(110)*M(2))-c(107)*M(10)+c(109)*(M(6)+M(12))) * den(484)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(485)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(70)*M(2))-c(61)*M(10)+c(66)*(M(6)+M(12))) * den(484)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(1)-M(9))+c(83)*M(11)) * den(301)
  T1sum(1:5,26) = T1sum(1:5,26) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(1)+M(9))-c(83)*M(11)) * den(301)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,40)
  Gcoeff = (-(c(78)*M(5))+c(77)*(M(1)+M(9))-c(76)*M(11)) * den(301)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,42)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(301)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(74)*M(5))+c(73)*(M(1)+M(9))-c(72)*M(11)) * den(301)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,46)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,121)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(489)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,121)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(489)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(490)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(490)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,125)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(490)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(490)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(10))+c(111)*M(12)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(10))+c(107)*M(12)) * den(489)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(10))+c(111)*M(12)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(10))+c(107)*M(12)) * den(489)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,123)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(490)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(70)*M(4)+c(66)*(-M(2)-M(10))+c(61)*M(12)) * den(489)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,127)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,129)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(494)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,130)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,129)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(494)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(495)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(495)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(495)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(495)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(10))+c(111)*M(12)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(10))+c(107)*M(12)) * den(494)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(10))+c(111)*M(12)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(10))+c(107)*M(12)) * den(494)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(495)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(70)*M(6)+c(66)*(-M(2)-M(10))+c(61)*M(12)) * den(494)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,135)
  Gcoeff = (c(87)*M(3)+c(84)*(-M(1)-M(9))+c(83)*M(11)) * den(305)
  T1sum(1:5,22) = T1sum(1:5,22) + Gcoeff * G1tensor(:,28)
  Gcoeff = (-(c(87)*M(3))+c(84)*(M(1)+M(9))-c(83)*M(11)) * den(305)
  T1sum(1:5,23) = T1sum(1:5,23) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(78)*M(3))+c(77)*(M(1)+M(9))-c(76)*M(11)) * den(305)
  T1sum(1:5,24) = T1sum(1:5,24) + Gcoeff * G1tensor(:,32)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(305)
  T1sum(1:5,23) = T1sum(1:5,23) + Gcoeff * G1tensor(:,34)
  Gcoeff = (-(c(74)*M(3))+c(73)*(M(1)+M(9))-c(72)*M(11)) * den(305)
  T1sum(1:5,24) = T1sum(1:5,24) + Gcoeff * G1tensor(:,36)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_6

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_6_pptttt_ew_tttxtxddx_1_/**/REALKIND
