
module ol_vamp_5_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_5(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxbbx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,3) :: G0
  complex(REALKIND), dimension(4,5,4,212) :: G1
  complex(REALKIND), dimension(4,15,4,331) :: G2
  complex(REALKIND), dimension(4,35,4,105) :: G3
  complex(REALKIND), dimension(5,2) :: G1tensor
  complex(REALKIND), dimension(15,158) :: G2tensor
  complex(REALKIND), dimension(35,125) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),MT,G1(:,:,:,1))
  call loop_AQ_V(G1(:,:,:,1),wf(:,257),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,2))
  call loop_AQ_V(G1(:,:,:,1),wf(:,258),G1(:,:,:,4))
  call check_last_UV_W(l_switch,G1(:,:,:,4),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,4))
  call loop_AS_Q(G1(:,:,:,1),wf(:,45),G1(:,:,:,6),gPtb)
  call loop_A_Q(G1(:,:,:,6),Q(:,42),MB,G2(:,:,:,3))
  call loop_AQ_V(G2(:,:,:,3),wf(:,-4),G2(:,:,:,4))
  call check_last_UV_W(l_switch,G2(:,:,:,4),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,1))
  call loop_VA_Q(G2(:,:,:,4),wf(:,-2),G2(:,:,:,5))
  call loop_A_Q(G2(:,:,:,5),Q(:,62),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,2))
  call loop_AW_Q(G1(:,:,:,1),wf(:,49),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,42),MB,G2(:,:,:,6))
  call loop_AQ_V(G2(:,:,:,6),wf(:,-4),G2(:,:,:,7))
  call check_last_UV_W(l_switch,G2(:,:,:,7),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,3))
  call loop_VA_Q(G2(:,:,:,7),wf(:,-2),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,62),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,56),MT,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,57),G2tensor(:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,59),G2tensor(:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,38),G2tensor(:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,65),G2tensor(:,8))
  call loop_AS_Q(G2(:,:,:,9),wf(:,5),G2(:,:,:,10),gH)
  call loop_A_Q(G2(:,:,:,10),Q(:,61),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-1),G3tensor(:,5))
  call loop_AS_Q(G2(:,:,:,9),wf(:,9),G2(:,:,:,11),gX)
  call loop_A_Q(G2(:,:,:,11),Q(:,61),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-1),G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,61),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-1),G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,18),G2(:,:,:,13),gZu)
  call loop_A_Q(G2(:,:,:,13),Q(:,61),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,8))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,129),G2tensor(:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,131),G2tensor(:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,113),G2tensor(:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,133),G2tensor(:,12))
  call loop_AS_Q(G2(:,:,:,9),wf(:,89),G2(:,:,:,14),gH)
  call loop_A_Q(G2(:,:,:,14),Q(:,62),MT,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,9))
  call loop_AS_Q(G2(:,:,:,9),wf(:,93),G2(:,:,:,15),gX)
  call loop_A_Q(G2(:,:,:,15),Q(:,62),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,10))
  call loop_AV_Q(G2(:,:,:,9),wf(:,80),G2(:,:,:,16))
  call loop_A_Q(G2(:,:,:,16),Q(:,62),MT,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,9),wf(:,98),G2(:,:,:,17),gZu)
  call loop_A_Q(G2(:,:,:,17),Q(:,62),MT,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,12))
  call loop_AQ_S(G2(:,:,:,9),wf(:,-1),G2(:,:,:,18),gH)
  call loop_SQ_A(G2(:,:,:,18),wf(:,0),G2(:,:,:,19),gH)
  call loop_Q_A(G2(:,:,:,19),Q(:,59),MT,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,13))
  call loop_SA_Q(G2(:,:,:,18),wf(:,-2),G2(:,:,:,20),gH)
  call loop_A_Q(G2(:,:,:,20),Q(:,62),MT,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,14))
  call loop_AQ_S(G2(:,:,:,9),wf(:,-1),G2(:,:,:,21),gX)
  call loop_SQ_A(G2(:,:,:,21),wf(:,0),G2(:,:,:,22),gX)
  call loop_Q_A(G2(:,:,:,22),Q(:,59),MT,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,15))
  call loop_SA_Q(G2(:,:,:,21),wf(:,-2),G2(:,:,:,23),gX)
  call loop_A_Q(G2(:,:,:,23),Q(:,62),MT,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,16))
  call loop_AQ_Z(G2(:,:,:,9),wf(:,-1),G2(:,:,:,24),gZu)
  call loop_ZQ_A(G2(:,:,:,24),wf(:,0),G2(:,:,:,25),gZu)
  call loop_Q_A(G2(:,:,:,25),Q(:,59),MT,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,17))
  call loop_ZA_Q(G2(:,:,:,24),wf(:,-2),G2(:,:,:,26),gZu)
  call loop_A_Q(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,18))
  call loop_AQ_S(G2(:,:,:,9),wf(:,0),G2(:,:,:,27),gH)
  call loop_SQ_A(G2(:,:,:,27),wf(:,-1),G2(:,:,:,28),gH)
  call loop_Q_A(G2(:,:,:,28),Q(:,59),MT,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-2),G3tensor(:,19))
  call loop_SA_Q(G2(:,:,:,27),wf(:,-2),G2(:,:,:,29),gH)
  call loop_A_Q(G2(:,:,:,29),Q(:,61),MT,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-1),G3tensor(:,20))
  call loop_AQ_S(G2(:,:,:,9),wf(:,0),G2(:,:,:,30),gX)
  call loop_SQ_A(G2(:,:,:,30),wf(:,-1),G2(:,:,:,31),gX)
  call loop_Q_A(G2(:,:,:,31),Q(:,59),MT,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,21))
  call loop_SA_Q(G2(:,:,:,30),wf(:,-2),G2(:,:,:,32),gX)
  call loop_A_Q(G2(:,:,:,32),Q(:,61),MT,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-1),G3tensor(:,22))
  call loop_AQ_Z(G2(:,:,:,9),wf(:,0),G2(:,:,:,33),gZu)
  call loop_ZQ_A(G2(:,:,:,33),wf(:,-1),G2(:,:,:,34),gZu)
  call loop_Q_A(G2(:,:,:,34),Q(:,59),MT,G3(:,:,:,21))
  call check_last_QA_V(l_switch,G3(:,:,:,21),wf(:,-2),G3tensor(:,23))
  call loop_ZA_Q(G2(:,:,:,33),wf(:,-2),G2(:,:,:,35),gZu)
  call loop_A_Q(G2(:,:,:,35),Q(:,61),MT,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-1),G3tensor(:,24))
  call loop_AQ_V(G2(:,:,:,9),wf(:,-1),G2(:,:,:,36))
  call loop_VA_Q(G2(:,:,:,36),wf(:,-2),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,62),MT,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,0),G3tensor(:,25))
  call loop_AS_Q(G1(:,:,:,1),wf(:,60),G1(:,:,:,9),gH)
  call loop_A_Q(G1(:,:,:,9),Q(:,56),MT,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,38),G2tensor(:,13))
  call loop_AV_Q(G2(:,:,:,38),wf(:,1),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,61),MT,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-1),G3tensor(:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,113),G2tensor(:,14))
  call loop_AV_Q(G2(:,:,:,38),wf(:,80),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,62),MT,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,0),G3tensor(:,27))
  call loop_AQ_V(G2(:,:,:,38),wf(:,-1),G2(:,:,:,41))
  call loop_VA_Q(G2(:,:,:,41),wf(:,-2),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,62),MT,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,28))
  call loop_AS_Q(G1(:,:,:,1),wf(:,62),G1(:,:,:,10),gX)
  call loop_A_Q(G1(:,:,:,10),Q(:,56),MT,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,38),G2tensor(:,15))
  call loop_AV_Q(G2(:,:,:,43),wf(:,1),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,61),MT,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,-1),G3tensor(:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,113),G2tensor(:,16))
  call loop_AV_Q(G2(:,:,:,43),wf(:,80),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,62),MT,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,30))
  call loop_AQ_V(G2(:,:,:,43),wf(:,-1),G2(:,:,:,46))
  call loop_VA_Q(G2(:,:,:,46),wf(:,-2),G2(:,:,:,47))
  call loop_A_Q(G2(:,:,:,47),Q(:,62),MT,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,31))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,66),G1(:,:,:,11),gZu)
  call loop_A_Q(G1(:,:,:,11),Q(:,56),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,38),G2tensor(:,17))
  call loop_AV_Q(G2(:,:,:,48),wf(:,1),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,61),MT,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,-1),G3tensor(:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,113),G2tensor(:,18))
  call loop_AV_Q(G2(:,:,:,48),wf(:,80),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,62),MT,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,33))
  call loop_AQ_V(G2(:,:,:,48),wf(:,-1),G2(:,:,:,51))
  call loop_VA_Q(G2(:,:,:,51),wf(:,-2),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,62),MT,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,0),G3tensor(:,34))
  call loop_AQ_V(G1(:,:,:,1),wf(:,73),G1(:,:,:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,12),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,12),wf(:,-2),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,62),MT,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,0),G2tensor(:,20))
  call loop_AQ_V(G1(:,:,:,1),wf(:,75),G1(:,:,:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,14),wf(:,-2),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MT,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,0),G2tensor(:,22))
  call loop_AQ_V(G1(:,:,:,1),wf(:,70),G1(:,:,:,16))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,16),wf(:,-2),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,0),G2tensor(:,24))
  call loop_AQ_V(G1(:,:,:,1),wf(:,78),G1(:,:,:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,18),wf(:,-2),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,0),G2tensor(:,26))
  call loop_AV_Q(G1(:,:,:,1),wf(:,614),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,61),MT,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,-1),G2tensor(:,27))
  call loop_AS_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,21),gH)
  call loop_A_Q(G1(:,:,:,21),Q(:,13),MT,G2(:,:,:,58))
  call loop_AV_Q(G2(:,:,:,58),wf(:,3),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,61),MT,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,-1),G3tensor(:,35))
  call loop_AS_Q(G1(:,:,:,1),wf(:,9),G1(:,:,:,22),gX)
  call loop_A_Q(G1(:,:,:,22),Q(:,13),MT,G2(:,:,:,60))
  call loop_AV_Q(G2(:,:,:,60),wf(:,3),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,61),MT,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-1),G3tensor(:,36))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,13),MT,G2(:,:,:,62))
  call loop_AS_Q(G2(:,:,:,62),wf(:,60),G2(:,:,:,63),gH)
  call loop_A_Q(G2(:,:,:,63),Q(:,61),MT,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-1),G3tensor(:,37))
  call loop_AS_Q(G2(:,:,:,62),wf(:,62),G2(:,:,:,64),gX)
  call loop_A_Q(G2(:,:,:,64),Q(:,61),MT,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,-1),G3tensor(:,38))
  call loop_AV_Q(G2(:,:,:,62),wf(:,3),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,61),MT,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,-1),G3tensor(:,39))
  call loop_AZ_Q(G2(:,:,:,62),wf(:,66),G2(:,:,:,66),gZu)
  call loop_A_Q(G2(:,:,:,66),Q(:,61),MT,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,-1),G3tensor(:,40))
  call loop_AQ_S(G2(:,:,:,62),wf(:,-4),G2(:,:,:,67),gPtb)
  call loop_SA_Q(G2(:,:,:,67),wf(:,-5),G2(:,:,:,68),gPbt)
  call loop_A_Q(G2(:,:,:,68),Q(:,61),MT,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,-1),G3tensor(:,41))
  call loop_AQ_W(G2(:,:,:,62),wf(:,-4),G2(:,:,:,69))
  call loop_WA_Q(G2(:,:,:,69),wf(:,-5),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,61),MT,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,-1),G3tensor(:,42))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,18),G1(:,:,:,24),gZu)
  call loop_A_Q(G1(:,:,:,24),Q(:,13),MT,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,3),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,61),MT,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,-1),G3tensor(:,43))
  call loop_AQ_S(G1(:,:,:,1),wf(:,-4),G1(:,:,:,25),gPtb)
  call loop_SA_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,26),gPbt)
  call loop_A_Q(G1(:,:,:,26),Q(:,56),MT,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,38),G2tensor(:,28))
  call loop_AV_Q(G2(:,:,:,73),wf(:,1),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,61),MT,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,-1),G3tensor(:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,113),G2tensor(:,29))
  call loop_AV_Q(G2(:,:,:,73),wf(:,80),G2(:,:,:,75))
  call loop_A_Q(G2(:,:,:,75),Q(:,62),MT,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,45))
  call loop_AQ_V(G2(:,:,:,73),wf(:,-1),G2(:,:,:,76))
  call loop_VA_Q(G2(:,:,:,76),wf(:,-2),G2(:,:,:,77))
  call loop_A_Q(G2(:,:,:,77),Q(:,62),MT,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,0),G3tensor(:,46))
  call loop_SA_Q(G1(:,:,:,25),wf(:,216),G1(:,:,:,27),gPbt)
  call loop_A_Q(G1(:,:,:,27),Q(:,61),MT,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,-1),G2tensor(:,30))
  call loop_SQ_A(G1(:,:,:,25),wf(:,-1),G1(:,:,:,28),gPbt)
  call loop_Q_A(G1(:,:,:,28),Q(:,26),MB,G2(:,:,:,79))
  call loop_QA_V(G2(:,:,:,79),wf(:,-5),G2(:,:,:,80))
  call check_last_UV_W(l_switch,G2(:,:,:,80),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,47))
  call loop_VA_Q(G2(:,:,:,80),wf(:,-2),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,62),MT,G3(:,:,:,45))
  call check_last_AQ_V(l_switch,G3(:,:,:,45),wf(:,0),G3tensor(:,48))
  call loop_SA_Q(G1(:,:,:,25),wf(:,303),G1(:,:,:,29),gPbt)
  call loop_A_Q(G1(:,:,:,29),Q(:,62),MT,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,31))
  call loop_SQ_A(G1(:,:,:,25),wf(:,0),G1(:,:,:,30),gPbt)
  call loop_Q_A(G1(:,:,:,30),Q(:,25),MB,G2(:,:,:,83))
  call loop_QA_V(G2(:,:,:,83),wf(:,-5),G2(:,:,:,84))
  call check_last_UV_W(l_switch,G2(:,:,:,84),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,49))
  call loop_VA_Q(G2(:,:,:,84),wf(:,-2),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,61),MT,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,-1),G3tensor(:,50))
  call loop_AQ_W(G1(:,:,:,1),wf(:,-4),G1(:,:,:,31))
  call loop_WA_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,56),MT,G2(:,:,:,86))
  call check_last_AQ_V(l_switch,G2(:,:,:,86),wf(:,38),G2tensor(:,32))
  call loop_AV_Q(G2(:,:,:,86),wf(:,1),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,61),MT,G3(:,:,:,47))
  call check_last_AQ_V(l_switch,G3(:,:,:,47),wf(:,-1),G3tensor(:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,86),wf(:,113),G2tensor(:,33))
  call loop_AV_Q(G2(:,:,:,86),wf(:,80),G2(:,:,:,88))
  call loop_A_Q(G2(:,:,:,88),Q(:,62),MT,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,0),G3tensor(:,52))
  call loop_AQ_V(G2(:,:,:,86),wf(:,-1),G2(:,:,:,89))
  call loop_VA_Q(G2(:,:,:,89),wf(:,-2),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,62),MT,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,0),G3tensor(:,53))
  call loop_WA_Q(G1(:,:,:,31),wf(:,216),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,61),MT,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,-1),G2tensor(:,34))
  call loop_WQ_A(G1(:,:,:,31),wf(:,-1),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,26),MB,G2(:,:,:,92))
  call loop_QA_V(G2(:,:,:,92),wf(:,-5),G2(:,:,:,93))
  call check_last_UV_W(l_switch,G2(:,:,:,93),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,54))
  call loop_VA_Q(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,62),MT,G3(:,:,:,50))
  call check_last_AQ_V(l_switch,G3(:,:,:,50),wf(:,0),G3tensor(:,55))
  call loop_WA_Q(G1(:,:,:,31),wf(:,303),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,62),MT,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,0),G2tensor(:,35))
  call loop_WQ_A(G1(:,:,:,31),wf(:,0),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,25),MB,G2(:,:,:,96))
  call loop_QA_V(G2(:,:,:,96),wf(:,-5),G2(:,:,:,97))
  call check_last_UV_W(l_switch,G2(:,:,:,97),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,56))
  call loop_VA_Q(G2(:,:,:,97),wf(:,-2),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,61),MT,G3(:,:,:,51))
  call check_last_AQ_V(l_switch,G3(:,:,:,51),wf(:,-1),G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,1),wf(:,731),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,61),MT,G2(:,:,:,99))
  call check_last_AQ_V(l_switch,G2(:,:,:,99),wf(:,-1),G2tensor(:,36))
  call loop_AV_Q(G1(:,:,:,1),wf(:,732),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,61),MT,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,-1),G2tensor(:,37))
  call loop_AS_Q(G1(:,:,:,1),wf(:,733),G1(:,:,:,39),gH)
  call loop_A_Q(G1(:,:,:,39),Q(:,61),MT,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-1),G2tensor(:,38))
  call loop_AS_Q(G1(:,:,:,1),wf(:,734),G1(:,:,:,40),gX)
  call loop_A_Q(G1(:,:,:,40),Q(:,61),MT,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-1),G2tensor(:,39))
  call loop_AV_Q(G1(:,:,:,1),wf(:,735),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,61),MT,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,-1),G2tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,736),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,61),MT,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,-1),G2tensor(:,41))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,737),G1(:,:,:,43),gZu)
  call loop_A_Q(G1(:,:,:,43),Q(:,61),MT,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,-1),G2tensor(:,42))
  call loop_AQ_S(G1(:,:,:,1),wf(:,15),G1(:,:,:,44),gPtb)
  call loop_SA_Q(G1(:,:,:,44),wf(:,-5),G1(:,:,:,45),gPbt)
  call loop_A_Q(G1(:,:,:,45),Q(:,61),MT,G2(:,:,:,106))
  call check_last_AQ_V(l_switch,G2(:,:,:,106),wf(:,-1),G2tensor(:,43))
  call loop_AQ_W(G1(:,:,:,1),wf(:,15),G1(:,:,:,46))
  call loop_WA_Q(G1(:,:,:,46),wf(:,-5),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,61),MT,G2(:,:,:,107))
  call check_last_AQ_V(l_switch,G2(:,:,:,107),wf(:,-1),G2tensor(:,44))
  call loop_AV_Q(G1(:,:,:,1),wf(:,740),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,61),MT,G2(:,:,:,108))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,-1),G2tensor(:,45))
  call loop_AV_Q(G1(:,:,:,1),wf(:,741),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,61),MT,G2(:,:,:,109))
  call check_last_AQ_V(l_switch,G2(:,:,:,109),wf(:,-1),G2tensor(:,46))
  call loop_AS_Q(G1(:,:,:,1),wf(:,742),G1(:,:,:,50),gH)
  call loop_A_Q(G1(:,:,:,50),Q(:,61),MT,G2(:,:,:,110))
  call check_last_AQ_V(l_switch,G2(:,:,:,110),wf(:,-1),G2tensor(:,47))
  call loop_AS_Q(G1(:,:,:,1),wf(:,743),G1(:,:,:,51),gX)
  call loop_A_Q(G1(:,:,:,51),Q(:,61),MT,G2(:,:,:,111))
  call check_last_AQ_V(l_switch,G2(:,:,:,111),wf(:,-1),G2tensor(:,48))
  call loop_AV_Q(G1(:,:,:,1),wf(:,744),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,61),MT,G2(:,:,:,112))
  call check_last_AQ_V(l_switch,G2(:,:,:,112),wf(:,-1),G2tensor(:,49))
  call loop_AV_Q(G1(:,:,:,1),wf(:,745),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,61),MT,G2(:,:,:,113))
  call check_last_AQ_V(l_switch,G2(:,:,:,113),wf(:,-1),G2tensor(:,50))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,746),G1(:,:,:,54),gZu)
  call loop_A_Q(G1(:,:,:,54),Q(:,61),MT,G2(:,:,:,114))
  call check_last_AQ_V(l_switch,G2(:,:,:,114),wf(:,-1),G2tensor(:,51))
  call loop_AQ_S(G1(:,:,:,1),wf(:,-1),G1(:,:,:,55),gH)
  call loop_SQ_A(G1(:,:,:,55),wf(:,-4),G1(:,:,:,56),gH)
  call loop_Q_A(G1(:,:,:,56),Q(:,26),MB,G2(:,:,:,115))
  call loop_QA_V(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call check_last_UV_W(l_switch,G2(:,:,:,116),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,58))
  call loop_VA_Q(G2(:,:,:,116),wf(:,-2),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,62),MT,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,0),G3tensor(:,59))
  call loop_SA_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,57),gH)
  call loop_A_Q(G1(:,:,:,57),Q(:,42),MB,G2(:,:,:,118))
  call loop_AQ_V(G2(:,:,:,118),wf(:,-4),G2(:,:,:,119))
  call check_last_UV_W(l_switch,G2(:,:,:,119),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,60))
  call loop_VA_Q(G2(:,:,:,119),wf(:,-2),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,62),MT,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,61))
  call loop_SQ_A(G1(:,:,:,55),wf(:,140),G1(:,:,:,58),gH)
  call loop_Q_A(G1(:,:,:,58),Q(:,59),MT,G2(:,:,:,121))
  call check_last_QA_V(l_switch,G2(:,:,:,121),wf(:,-2),G2tensor(:,52))
  call loop_SA_Q(G1(:,:,:,55),wf(:,434),G1(:,:,:,59),gH)
  call loop_A_Q(G1(:,:,:,59),Q(:,62),MT,G2(:,:,:,122))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,0),G2tensor(:,53))
  call loop_SQ_A(G1(:,:,:,55),wf(:,0),G1(:,:,:,60),gH)
  call loop_Q_A(G1(:,:,:,60),Q(:,11),MT,G2(:,:,:,123))
  call loop_QV_A(G2(:,:,:,123),wf(:,3),G2(:,:,:,124))
  call loop_Q_A(G2(:,:,:,124),Q(:,59),MT,G3(:,:,:,54))
  call check_last_QA_V(l_switch,G3(:,:,:,54),wf(:,-2),G3tensor(:,62))
  call loop_SA_Q(G1(:,:,:,55),wf(:,-2),G1(:,:,:,61),gH)
  call loop_A_Q(G1(:,:,:,61),Q(:,14),MT,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,3),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,62),MT,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,0),G3tensor(:,63))
  call loop_AQ_S(G1(:,:,:,1),wf(:,-1),G1(:,:,:,62),gX)
  call loop_SQ_A(G1(:,:,:,62),wf(:,-4),G1(:,:,:,63),gX)
  call loop_Q_A(G1(:,:,:,63),Q(:,26),MB,G2(:,:,:,127))
  call loop_QA_V(G2(:,:,:,127),wf(:,-5),G2(:,:,:,128))
  call check_last_UV_W(l_switch,G2(:,:,:,128),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,64))
  call loop_VA_Q(G2(:,:,:,128),wf(:,-2),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,62),MT,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,65))
  call loop_SA_Q(G1(:,:,:,62),wf(:,-5),G1(:,:,:,64),gX)
  call loop_A_Q(G1(:,:,:,64),Q(:,42),MB,G2(:,:,:,130))
  call loop_AQ_V(G2(:,:,:,130),wf(:,-4),G2(:,:,:,131))
  call check_last_UV_W(l_switch,G2(:,:,:,131),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,66))
  call loop_VA_Q(G2(:,:,:,131),wf(:,-2),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,62),MT,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,67))
  call loop_SQ_A(G1(:,:,:,62),wf(:,140),G1(:,:,:,65),gX)
  call loop_Q_A(G1(:,:,:,65),Q(:,59),MT,G2(:,:,:,133))
  call check_last_QA_V(l_switch,G2(:,:,:,133),wf(:,-2),G2tensor(:,54))
  call loop_SA_Q(G1(:,:,:,62),wf(:,434),G1(:,:,:,66),gX)
  call loop_A_Q(G1(:,:,:,66),Q(:,62),MT,G2(:,:,:,134))
  call check_last_AQ_V(l_switch,G2(:,:,:,134),wf(:,0),G2tensor(:,55))
  call loop_SQ_A(G1(:,:,:,62),wf(:,0),G1(:,:,:,67),gX)
  call loop_Q_A(G1(:,:,:,67),Q(:,11),MT,G2(:,:,:,135))
  call loop_QV_A(G2(:,:,:,135),wf(:,3),G2(:,:,:,136))
  call loop_Q_A(G2(:,:,:,136),Q(:,59),MT,G3(:,:,:,58))
  call check_last_QA_V(l_switch,G3(:,:,:,58),wf(:,-2),G3tensor(:,68))
  call loop_SA_Q(G1(:,:,:,62),wf(:,-2),G1(:,:,:,68),gX)
  call loop_A_Q(G1(:,:,:,68),Q(:,14),MT,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,3),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,62),MT,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,0),G3tensor(:,69))
  call loop_AQ_Z(G1(:,:,:,1),wf(:,-1),G1(:,:,:,69),gZu)
  call loop_ZQ_A(G1(:,:,:,69),wf(:,-4),G1(:,:,:,70),gZd)
  call loop_Q_A(G1(:,:,:,70),Q(:,26),MB,G2(:,:,:,139))
  call loop_QA_V(G2(:,:,:,139),wf(:,-5),G2(:,:,:,140))
  call check_last_UV_W(l_switch,G2(:,:,:,140),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,70))
  call loop_VA_Q(G2(:,:,:,140),wf(:,-2),G2(:,:,:,141))
  call loop_A_Q(G2(:,:,:,141),Q(:,62),MT,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,0),G3tensor(:,71))
  call loop_ZA_Q(G1(:,:,:,69),wf(:,-5),G1(:,:,:,71),gZd)
  call loop_A_Q(G1(:,:,:,71),Q(:,42),MB,G2(:,:,:,142))
  call loop_AQ_V(G2(:,:,:,142),wf(:,-4),G2(:,:,:,143))
  call check_last_UV_W(l_switch,G2(:,:,:,143),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,72))
  call loop_VA_Q(G2(:,:,:,143),wf(:,-2),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,62),MT,G3(:,:,:,61))
  call check_last_AQ_V(l_switch,G3(:,:,:,61),wf(:,0),G3tensor(:,73))
  call loop_ZQ_A(G1(:,:,:,69),wf(:,140),G1(:,:,:,72),gZu)
  call loop_Q_A(G1(:,:,:,72),Q(:,59),MT,G2(:,:,:,145))
  call check_last_QA_V(l_switch,G2(:,:,:,145),wf(:,-2),G2tensor(:,56))
  call loop_ZA_Q(G1(:,:,:,69),wf(:,434),G1(:,:,:,73),gZu)
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,146))
  call check_last_AQ_V(l_switch,G2(:,:,:,146),wf(:,0),G2tensor(:,57))
  call loop_ZQ_A(G1(:,:,:,69),wf(:,0),G1(:,:,:,74),gZu)
  call loop_Q_A(G1(:,:,:,74),Q(:,11),MT,G2(:,:,:,147))
  call loop_QV_A(G2(:,:,:,147),wf(:,3),G2(:,:,:,148))
  call loop_Q_A(G2(:,:,:,148),Q(:,59),MT,G3(:,:,:,62))
  call check_last_QA_V(l_switch,G3(:,:,:,62),wf(:,-2),G3tensor(:,74))
  call loop_ZA_Q(G1(:,:,:,69),wf(:,-2),G1(:,:,:,75),gZu)
  call loop_A_Q(G1(:,:,:,75),Q(:,14),MT,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,3),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,62),MT,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,0),G3tensor(:,75))
  call loop_AQ_V(G1(:,:,:,1),wf(:,324),G1(:,:,:,76))
  call check_last_UV_W(l_switch,G1(:,:,:,76),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,58))
  call loop_VA_Q(G1(:,:,:,76),wf(:,-2),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,61),MT,G2(:,:,:,151))
  call check_last_AQ_V(l_switch,G2(:,:,:,151),wf(:,-1),G2tensor(:,59))
  call loop_AQ_V(G1(:,:,:,1),wf(:,325),G1(:,:,:,78))
  call check_last_UV_W(l_switch,G1(:,:,:,78),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,60))
  call loop_VA_Q(G1(:,:,:,78),wf(:,-2),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,61),MT,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,-1),G2tensor(:,61))
  call loop_AS_Q(G1(:,:,:,1),wf(:,118),G1(:,:,:,80),gPtb)
  call loop_A_Q(G1(:,:,:,80),Q(:,41),MB,G2(:,:,:,153))
  call loop_AQ_V(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154))
  call check_last_UV_W(l_switch,G2(:,:,:,154),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,76))
  call loop_VA_Q(G2(:,:,:,154),wf(:,-2),G2(:,:,:,155))
  call loop_A_Q(G2(:,:,:,155),Q(:,61),MT,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,-1),G3tensor(:,77))
  call loop_AW_Q(G1(:,:,:,1),wf(:,121),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,41),MB,G2(:,:,:,156))
  call loop_AQ_V(G2(:,:,:,156),wf(:,-4),G2(:,:,:,157))
  call check_last_UV_W(l_switch,G2(:,:,:,157),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,78))
  call loop_VA_Q(G2(:,:,:,157),wf(:,-2),G2(:,:,:,158))
  call loop_A_Q(G2(:,:,:,158),Q(:,61),MT,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,-1),G3tensor(:,79))
  call loop_AQ_V(G1(:,:,:,1),wf(:,135),G1(:,:,:,82))
  call check_last_UV_W(l_switch,G1(:,:,:,82),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,62))
  call loop_VA_Q(G1(:,:,:,82),wf(:,-2),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,61),MT,G2(:,:,:,159))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,-1),G2tensor(:,63))
  call loop_AQ_V(G1(:,:,:,1),wf(:,137),G1(:,:,:,84))
  call check_last_UV_W(l_switch,G1(:,:,:,84),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,64))
  call loop_VA_Q(G1(:,:,:,84),wf(:,-2),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,61),MT,G2(:,:,:,160))
  call check_last_AQ_V(l_switch,G2(:,:,:,160),wf(:,-1),G2tensor(:,65))
  call loop_AQ_V(G1(:,:,:,1),wf(:,140),G1(:,:,:,86))
  call check_last_UV_W(l_switch,G1(:,:,:,86),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,66))
  call loop_VA_Q(G1(:,:,:,86),wf(:,-2),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,61),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,-1),G2tensor(:,67))
  call loop_AQ_V(G1(:,:,:,1),wf(:,143),G1(:,:,:,88))
  call check_last_UV_W(l_switch,G1(:,:,:,88),Q(:,57),wf(:,80),Q(:,6),G2tensor(:,68))
  call loop_VA_Q(G1(:,:,:,88),wf(:,-2),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,61),MT,G2(:,:,:,162))
  call check_last_AQ_V(l_switch,G2(:,:,:,162),wf(:,-1),G2tensor(:,69))
  call loop_AV_Q(G1(:,:,:,1),wf(:,650),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,163))
  call check_last_AQ_V(l_switch,G2(:,:,:,163),wf(:,0),G2tensor(:,70))
  call loop_AS_Q(G1(:,:,:,1),wf(:,89),G1(:,:,:,91),gH)
  call loop_A_Q(G1(:,:,:,91),Q(:,14),MT,G2(:,:,:,164))
  call loop_AV_Q(G2(:,:,:,164),wf(:,3),G2(:,:,:,165))
  call loop_A_Q(G2(:,:,:,165),Q(:,62),MT,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,0),G3tensor(:,80))
  call loop_AS_Q(G1(:,:,:,1),wf(:,93),G1(:,:,:,92),gX)
  call loop_A_Q(G1(:,:,:,92),Q(:,14),MT,G2(:,:,:,166))
  call loop_AV_Q(G2(:,:,:,166),wf(:,3),G2(:,:,:,167))
  call loop_A_Q(G2(:,:,:,167),Q(:,62),MT,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,0),G3tensor(:,81))
  call loop_AV_Q(G1(:,:,:,1),wf(:,80),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,14),MT,G2(:,:,:,168))
  call loop_AS_Q(G2(:,:,:,168),wf(:,60),G2(:,:,:,169),gH)
  call loop_A_Q(G2(:,:,:,169),Q(:,62),MT,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,0),G3tensor(:,82))
  call loop_AS_Q(G2(:,:,:,168),wf(:,62),G2(:,:,:,170),gX)
  call loop_A_Q(G2(:,:,:,170),Q(:,62),MT,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,0),G3tensor(:,83))
  call loop_AV_Q(G2(:,:,:,168),wf(:,3),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,62),MT,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,0),G3tensor(:,84))
  call loop_AZ_Q(G2(:,:,:,168),wf(:,66),G2(:,:,:,172),gZu)
  call loop_A_Q(G2(:,:,:,172),Q(:,62),MT,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,0),G3tensor(:,85))
  call loop_AQ_S(G2(:,:,:,168),wf(:,-4),G2(:,:,:,173),gPtb)
  call loop_SA_Q(G2(:,:,:,173),wf(:,-5),G2(:,:,:,174),gPbt)
  call loop_A_Q(G2(:,:,:,174),Q(:,62),MT,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,0),G3tensor(:,86))
  call loop_AQ_W(G2(:,:,:,168),wf(:,-4),G2(:,:,:,175))
  call loop_WA_Q(G2(:,:,:,175),wf(:,-5),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,62),MT,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,0),G3tensor(:,87))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,98),G1(:,:,:,94),gZu)
  call loop_A_Q(G1(:,:,:,94),Q(:,14),MT,G2(:,:,:,177))
  call loop_AV_Q(G2(:,:,:,177),wf(:,3),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,62),MT,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,0),G3tensor(:,88))
  call loop_AV_Q(G1(:,:,:,1),wf(:,769),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,62),MT,G2(:,:,:,179))
  call check_last_AQ_V(l_switch,G2(:,:,:,179),wf(:,0),G2tensor(:,71))
  call loop_AV_Q(G1(:,:,:,1),wf(:,770),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,180))
  call check_last_AQ_V(l_switch,G2(:,:,:,180),wf(:,0),G2tensor(:,72))
  call loop_AS_Q(G1(:,:,:,1),wf(:,771),G1(:,:,:,97),gH)
  call loop_A_Q(G1(:,:,:,97),Q(:,62),MT,G2(:,:,:,181))
  call check_last_AQ_V(l_switch,G2(:,:,:,181),wf(:,0),G2tensor(:,73))
  call loop_AS_Q(G1(:,:,:,1),wf(:,772),G1(:,:,:,98),gX)
  call loop_A_Q(G1(:,:,:,98),Q(:,62),MT,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,0),G2tensor(:,74))
  call loop_AV_Q(G1(:,:,:,1),wf(:,773),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,62),MT,G2(:,:,:,183))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,0),G2tensor(:,75))
  call loop_AV_Q(G1(:,:,:,1),wf(:,774),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,62),MT,G2(:,:,:,184))
  call check_last_AQ_V(l_switch,G2(:,:,:,184),wf(:,0),G2tensor(:,76))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,775),G1(:,:,:,101),gZu)
  call loop_A_Q(G1(:,:,:,101),Q(:,62),MT,G2(:,:,:,185))
  call check_last_AQ_V(l_switch,G2(:,:,:,185),wf(:,0),G2tensor(:,77))
  call loop_AQ_S(G1(:,:,:,1),wf(:,102),G1(:,:,:,102),gPtb)
  call loop_SA_Q(G1(:,:,:,102),wf(:,-5),G1(:,:,:,103),gPbt)
  call loop_A_Q(G1(:,:,:,103),Q(:,62),MT,G2(:,:,:,186))
  call check_last_AQ_V(l_switch,G2(:,:,:,186),wf(:,0),G2tensor(:,78))
  call loop_AQ_W(G1(:,:,:,1),wf(:,102),G1(:,:,:,104))
  call loop_WA_Q(G1(:,:,:,104),wf(:,-5),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,62),MT,G2(:,:,:,187))
  call check_last_AQ_V(l_switch,G2(:,:,:,187),wf(:,0),G2tensor(:,79))
  call loop_AV_Q(G1(:,:,:,1),wf(:,776),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,62),MT,G2(:,:,:,188))
  call check_last_AQ_V(l_switch,G2(:,:,:,188),wf(:,0),G2tensor(:,80))
  call loop_AV_Q(G1(:,:,:,1),wf(:,777),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,189))
  call check_last_AQ_V(l_switch,G2(:,:,:,189),wf(:,0),G2tensor(:,81))
  call loop_AS_Q(G1(:,:,:,1),wf(:,778),G1(:,:,:,108),gH)
  call loop_A_Q(G1(:,:,:,108),Q(:,62),MT,G2(:,:,:,190))
  call check_last_AQ_V(l_switch,G2(:,:,:,190),wf(:,0),G2tensor(:,82))
  call loop_AS_Q(G1(:,:,:,1),wf(:,779),G1(:,:,:,109),gX)
  call loop_A_Q(G1(:,:,:,109),Q(:,62),MT,G2(:,:,:,191))
  call check_last_AQ_V(l_switch,G2(:,:,:,191),wf(:,0),G2tensor(:,83))
  call loop_AV_Q(G1(:,:,:,1),wf(:,780),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,62),MT,G2(:,:,:,192))
  call check_last_AQ_V(l_switch,G2(:,:,:,192),wf(:,0),G2tensor(:,84))
  call loop_AV_Q(G1(:,:,:,1),wf(:,781),G1(:,:,:,111))
  call loop_A_Q(G1(:,:,:,111),Q(:,62),MT,G2(:,:,:,193))
  call check_last_AQ_V(l_switch,G2(:,:,:,193),wf(:,0),G2tensor(:,85))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,782),G1(:,:,:,112),gZu)
  call loop_A_Q(G1(:,:,:,112),Q(:,62),MT,G2(:,:,:,194))
  call check_last_AQ_V(l_switch,G2(:,:,:,194),wf(:,0),G2tensor(:,86))
  call loop_AQ_S(G1(:,:,:,1),wf(:,0),G1(:,:,:,113),gH)
  call loop_SQ_A(G1(:,:,:,113),wf(:,-4),G1(:,:,:,114),gH)
  call loop_Q_A(G1(:,:,:,114),Q(:,25),MB,G2(:,:,:,195))
  call loop_QA_V(G2(:,:,:,195),wf(:,-5),G2(:,:,:,196))
  call check_last_UV_W(l_switch,G2(:,:,:,196),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,89))
  call loop_VA_Q(G2(:,:,:,196),wf(:,-2),G2(:,:,:,197))
  call loop_A_Q(G2(:,:,:,197),Q(:,61),MT,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,-1),G3tensor(:,90))
  call loop_SA_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,115),gH)
  call loop_A_Q(G1(:,:,:,115),Q(:,41),MB,G2(:,:,:,198))
  call loop_AQ_V(G2(:,:,:,198),wf(:,-4),G2(:,:,:,199))
  call check_last_UV_W(l_switch,G2(:,:,:,199),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,91))
  call loop_VA_Q(G2(:,:,:,199),wf(:,-2),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,61),MT,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,-1),G3tensor(:,92))
  call loop_SQ_A(G1(:,:,:,113),wf(:,70),G1(:,:,:,116),gH)
  call loop_Q_A(G1(:,:,:,116),Q(:,59),MT,G2(:,:,:,201))
  call check_last_QA_V(l_switch,G2(:,:,:,201),wf(:,-2),G2tensor(:,87))
  call loop_SA_Q(G1(:,:,:,113),wf(:,434),G1(:,:,:,117),gH)
  call loop_A_Q(G1(:,:,:,117),Q(:,61),MT,G2(:,:,:,202))
  call check_last_AQ_V(l_switch,G2(:,:,:,202),wf(:,-1),G2tensor(:,88))
  call loop_SQ_A(G1(:,:,:,113),wf(:,-1),G1(:,:,:,118),gH)
  call loop_Q_A(G1(:,:,:,118),Q(:,11),MT,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,3),G2(:,:,:,204))
  call loop_Q_A(G2(:,:,:,204),Q(:,59),MT,G3(:,:,:,77))
  call check_last_QA_V(l_switch,G3(:,:,:,77),wf(:,-2),G3tensor(:,93))
  call loop_SA_Q(G1(:,:,:,113),wf(:,-2),G1(:,:,:,119),gH)
  call loop_A_Q(G1(:,:,:,119),Q(:,13),MT,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,3),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,61),MT,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,-1),G3tensor(:,94))
  call loop_AQ_S(G1(:,:,:,1),wf(:,0),G1(:,:,:,120),gX)
  call loop_SQ_A(G1(:,:,:,120),wf(:,-4),G1(:,:,:,121),gX)
  call loop_Q_A(G1(:,:,:,121),Q(:,25),MB,G2(:,:,:,207))
  call loop_QA_V(G2(:,:,:,207),wf(:,-5),G2(:,:,:,208))
  call check_last_UV_W(l_switch,G2(:,:,:,208),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,95))
  call loop_VA_Q(G2(:,:,:,208),wf(:,-2),G2(:,:,:,209))
  call loop_A_Q(G2(:,:,:,209),Q(:,61),MT,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,-1),G3tensor(:,96))
  call loop_SA_Q(G1(:,:,:,120),wf(:,-5),G1(:,:,:,122),gX)
  call loop_A_Q(G1(:,:,:,122),Q(:,41),MB,G2(:,:,:,210))
  call loop_AQ_V(G2(:,:,:,210),wf(:,-4),G2(:,:,:,211))
  call check_last_UV_W(l_switch,G2(:,:,:,211),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,97))
  call loop_VA_Q(G2(:,:,:,211),wf(:,-2),G2(:,:,:,212))
  call loop_A_Q(G2(:,:,:,212),Q(:,61),MT,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,-1),G3tensor(:,98))
  call loop_SQ_A(G1(:,:,:,120),wf(:,70),G1(:,:,:,123),gX)
  call loop_Q_A(G1(:,:,:,123),Q(:,59),MT,G2(:,:,:,213))
  call check_last_QA_V(l_switch,G2(:,:,:,213),wf(:,-2),G2tensor(:,89))
  call loop_SA_Q(G1(:,:,:,120),wf(:,434),G1(:,:,:,124),gX)
  call loop_A_Q(G1(:,:,:,124),Q(:,61),MT,G2(:,:,:,214))
  call check_last_AQ_V(l_switch,G2(:,:,:,214),wf(:,-1),G2tensor(:,90))
  call loop_SQ_A(G1(:,:,:,120),wf(:,-1),G1(:,:,:,125),gX)
  call loop_Q_A(G1(:,:,:,125),Q(:,11),MT,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,3),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,59),MT,G3(:,:,:,81))
  call check_last_QA_V(l_switch,G3(:,:,:,81),wf(:,-2),G3tensor(:,99))
  call loop_SA_Q(G1(:,:,:,120),wf(:,-2),G1(:,:,:,126),gX)
  call loop_A_Q(G1(:,:,:,126),Q(:,13),MT,G2(:,:,:,217))
  call loop_AV_Q(G2(:,:,:,217),wf(:,3),G2(:,:,:,218))
  call loop_A_Q(G2(:,:,:,218),Q(:,61),MT,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,-1),G3tensor(:,100))
  call loop_AQ_Z(G1(:,:,:,1),wf(:,0),G1(:,:,:,127),gZu)
  call loop_ZQ_A(G1(:,:,:,127),wf(:,-4),G1(:,:,:,128),gZd)
  call loop_Q_A(G1(:,:,:,128),Q(:,25),MB,G2(:,:,:,219))
  call loop_QA_V(G2(:,:,:,219),wf(:,-5),G2(:,:,:,220))
  call check_last_UV_W(l_switch,G2(:,:,:,220),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,101))
  call loop_VA_Q(G2(:,:,:,220),wf(:,-2),G2(:,:,:,221))
  call loop_A_Q(G2(:,:,:,221),Q(:,61),MT,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,-1),G3tensor(:,102))
  call loop_ZA_Q(G1(:,:,:,127),wf(:,-5),G1(:,:,:,129),gZd)
  call loop_A_Q(G1(:,:,:,129),Q(:,41),MB,G2(:,:,:,222))
  call loop_AQ_V(G2(:,:,:,222),wf(:,-4),G2(:,:,:,223))
  call check_last_UV_W(l_switch,G2(:,:,:,223),Q(:,57),wf(:,80),Q(:,6),G3tensor(:,103))
  call loop_VA_Q(G2(:,:,:,223),wf(:,-2),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,61),MT,G3(:,:,:,84))
  call check_last_AQ_V(l_switch,G3(:,:,:,84),wf(:,-1),G3tensor(:,104))
  call loop_ZQ_A(G1(:,:,:,127),wf(:,70),G1(:,:,:,130),gZu)
  call loop_Q_A(G1(:,:,:,130),Q(:,59),MT,G2(:,:,:,225))
  call check_last_QA_V(l_switch,G2(:,:,:,225),wf(:,-2),G2tensor(:,91))
  call loop_ZA_Q(G1(:,:,:,127),wf(:,434),G1(:,:,:,131),gZu)
  call loop_A_Q(G1(:,:,:,131),Q(:,61),MT,G2(:,:,:,226))
  call check_last_AQ_V(l_switch,G2(:,:,:,226),wf(:,-1),G2tensor(:,92))
  call loop_ZQ_A(G1(:,:,:,127),wf(:,-1),G1(:,:,:,132),gZu)
  call loop_Q_A(G1(:,:,:,132),Q(:,11),MT,G2(:,:,:,227))
  call loop_QV_A(G2(:,:,:,227),wf(:,3),G2(:,:,:,228))
  call loop_Q_A(G2(:,:,:,228),Q(:,59),MT,G3(:,:,:,85))
  call check_last_QA_V(l_switch,G3(:,:,:,85),wf(:,-2),G3tensor(:,105))
  call loop_ZA_Q(G1(:,:,:,127),wf(:,-2),G1(:,:,:,133),gZu)
  call loop_A_Q(G1(:,:,:,133),Q(:,13),MT,G2(:,:,:,229))
  call loop_AV_Q(G2(:,:,:,229),wf(:,3),G2(:,:,:,230))
  call loop_A_Q(G2(:,:,:,230),Q(:,61),MT,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,-1),G3tensor(:,106))
  call loop_AV_Q(G1(:,:,:,1),wf(:,855),G1(:,:,:,134))
  call loop_A_Q(G1(:,:,:,134),Q(:,61),MT,G2(:,:,:,231))
  call check_last_AQ_V(l_switch,G2(:,:,:,231),wf(:,-1),G2tensor(:,93))
  call loop_AV_Q(G1(:,:,:,1),wf(:,856),G1(:,:,:,135))
  call loop_A_Q(G1(:,:,:,135),Q(:,61),MT,G2(:,:,:,232))
  call check_last_AQ_V(l_switch,G2(:,:,:,232),wf(:,-1),G2tensor(:,94))
  call loop_AV_Q(G1(:,:,:,1),wf(:,857),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,61),MT,G2(:,:,:,233))
  call check_last_AQ_V(l_switch,G2(:,:,:,233),wf(:,-1),G2tensor(:,95))
  call loop_AV_Q(G1(:,:,:,1),wf(:,858),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,61),MT,G2(:,:,:,234))
  call check_last_AQ_V(l_switch,G2(:,:,:,234),wf(:,-1),G2tensor(:,96))
  call loop_AV_Q(G1(:,:,:,1),wf(:,859),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,62),MT,G2(:,:,:,235))
  call check_last_AQ_V(l_switch,G2(:,:,:,235),wf(:,0),G2tensor(:,97))
  call loop_AV_Q(G1(:,:,:,1),wf(:,860),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,62),MT,G2(:,:,:,236))
  call check_last_AQ_V(l_switch,G2(:,:,:,236),wf(:,0),G2tensor(:,98))
  call loop_AV_Q(G1(:,:,:,1),wf(:,861),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,62),MT,G2(:,:,:,237))
  call check_last_AQ_V(l_switch,G2(:,:,:,237),wf(:,0),G2tensor(:,99))
  call loop_AV_Q(G1(:,:,:,1),wf(:,862),G1(:,:,:,141))
  call loop_A_Q(G1(:,:,:,141),Q(:,62),MT,G2(:,:,:,238))
  call check_last_AQ_V(l_switch,G2(:,:,:,238),wf(:,0),G2tensor(:,100))
  call loop_AQ_V(G1(:,:,:,1),wf(:,-1),G1(:,:,:,142))
  call loop_VA_Q(G1(:,:,:,142),wf(:,428),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,62),MT,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,0),G2tensor(:,101))
  call loop_VA_Q(G1(:,:,:,142),wf(:,429),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,62),MT,G2(:,:,:,240))
  call check_last_AQ_V(l_switch,G2(:,:,:,240),wf(:,0),G2tensor(:,102))
  call loop_VA_Q(G1(:,:,:,142),wf(:,-5),G1(:,:,:,145))
  call loop_A_Q(G1(:,:,:,145),Q(:,42),MB,G2(:,:,:,241))
  call loop_AS_Q(G2(:,:,:,241),wf(:,145),G2(:,:,:,242),gPbt)
  call loop_A_Q(G2(:,:,:,242),Q(:,62),MT,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,0),G3tensor(:,107))
  call loop_AW_Q(G2(:,:,:,241),wf(:,149),G2(:,:,:,243))
  call loop_A_Q(G2(:,:,:,243),Q(:,62),MT,G3(:,:,:,88))
  call check_last_AQ_V(l_switch,G3(:,:,:,88),wf(:,0),G3tensor(:,108))
  call loop_AQ_S(G2(:,:,:,241),wf(:,-4),G2(:,:,:,244),gH)
  call loop_SA_Q(G2(:,:,:,244),wf(:,-2),G2(:,:,:,245),gH)
  call loop_A_Q(G2(:,:,:,245),Q(:,62),MT,G3(:,:,:,89))
  call check_last_AQ_V(l_switch,G3(:,:,:,89),wf(:,0),G3tensor(:,109))
  call loop_AQ_S(G2(:,:,:,241),wf(:,-4),G2(:,:,:,246),gX)
  call loop_SA_Q(G2(:,:,:,246),wf(:,-2),G2(:,:,:,247),gX)
  call loop_A_Q(G2(:,:,:,247),Q(:,62),MT,G3(:,:,:,90))
  call check_last_AQ_V(l_switch,G3(:,:,:,90),wf(:,0),G3tensor(:,110))
  call loop_AQ_V(G2(:,:,:,241),wf(:,-4),G2(:,:,:,248))
  call loop_VA_Q(G2(:,:,:,248),wf(:,-2),G2(:,:,:,249))
  call loop_A_Q(G2(:,:,:,249),Q(:,62),MT,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,0),G3tensor(:,111))
  call loop_AQ_Z(G2(:,:,:,241),wf(:,-4),G2(:,:,:,250),gZd)
  call loop_ZA_Q(G2(:,:,:,250),wf(:,-2),G2(:,:,:,251),gZu)
  call loop_A_Q(G2(:,:,:,251),Q(:,62),MT,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,0),G3tensor(:,112))
  call loop_VA_Q(G1(:,:,:,142),wf(:,436),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,62),MT,G2(:,:,:,252))
  call check_last_AQ_V(l_switch,G2(:,:,:,252),wf(:,0),G2tensor(:,103))
  call loop_VA_Q(G1(:,:,:,142),wf(:,437),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,62),MT,G2(:,:,:,253))
  call check_last_AQ_V(l_switch,G2(:,:,:,253),wf(:,0),G2tensor(:,104))
  call loop_VA_Q(G1(:,:,:,142),wf(:,434),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,62),MT,G2(:,:,:,254))
  call check_last_AQ_V(l_switch,G2(:,:,:,254),wf(:,0),G2tensor(:,105))
  call loop_VA_Q(G1(:,:,:,142),wf(:,439),G1(:,:,:,149))
  call loop_A_Q(G1(:,:,:,149),Q(:,62),MT,G2(:,:,:,255))
  call check_last_AQ_V(l_switch,G2(:,:,:,255),wf(:,0),G2tensor(:,106))
  call loop_UV_W(G1(:,:,:,142),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,256))
  call loop_VA_Q(G2(:,:,:,256),wf(:,-2),G2(:,:,:,257))
  call loop_A_Q(G2(:,:,:,257),Q(:,62),MT,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,0),G3tensor(:,113))
  call loop_VA_Q(G1(:,:,:,142),wf(:,-2),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,14),MT,G2(:,:,:,258))
  call loop_AS_Q(G2(:,:,:,258),wf(:,60),G2(:,:,:,259),gH)
  call loop_A_Q(G2(:,:,:,259),Q(:,62),MT,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,0),G3tensor(:,114))
  call loop_AS_Q(G2(:,:,:,258),wf(:,62),G2(:,:,:,260),gX)
  call loop_A_Q(G2(:,:,:,260),Q(:,62),MT,G3(:,:,:,95))
  call check_last_AQ_V(l_switch,G3(:,:,:,95),wf(:,0),G3tensor(:,115))
  call loop_AV_Q(G2(:,:,:,258),wf(:,3),G2(:,:,:,261))
  call loop_A_Q(G2(:,:,:,261),Q(:,62),MT,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,0),G3tensor(:,116))
  call loop_AZ_Q(G2(:,:,:,258),wf(:,66),G2(:,:,:,262),gZu)
  call loop_A_Q(G2(:,:,:,262),Q(:,62),MT,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,0),G3tensor(:,117))
  call loop_AQ_S(G2(:,:,:,258),wf(:,-4),G2(:,:,:,263),gPtb)
  call loop_SA_Q(G2(:,:,:,263),wf(:,-5),G2(:,:,:,264),gPbt)
  call loop_A_Q(G2(:,:,:,264),Q(:,62),MT,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,0),G3tensor(:,118))
  call loop_AQ_W(G2(:,:,:,258),wf(:,-4),G2(:,:,:,265))
  call loop_WA_Q(G2(:,:,:,265),wf(:,-5),G2(:,:,:,266))
  call loop_A_Q(G2(:,:,:,266),Q(:,62),MT,G3(:,:,:,99))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,0),G3tensor(:,119))
  call loop_VQ_A(G1(:,:,:,142),wf(:,-4),G1(:,:,:,151))
  call loop_Q_A(G1(:,:,:,151),Q(:,26),MB,G2(:,:,:,267))
  call loop_QA_S(G2(:,:,:,267),wf(:,-5),G2(:,:,:,268),gH)
  call loop_SA_Q(G2(:,:,:,268),wf(:,-2),G2(:,:,:,269),gH)
  call loop_A_Q(G2(:,:,:,269),Q(:,62),MT,G3(:,:,:,100))
  call check_last_AQ_V(l_switch,G3(:,:,:,100),wf(:,0),G3tensor(:,120))
  call loop_QA_S(G2(:,:,:,267),wf(:,-5),G2(:,:,:,270),gX)
  call loop_SA_Q(G2(:,:,:,270),wf(:,-2),G2(:,:,:,271),gX)
  call loop_A_Q(G2(:,:,:,271),Q(:,62),MT,G3(:,:,:,101))
  call check_last_AQ_V(l_switch,G3(:,:,:,101),wf(:,0),G3tensor(:,121))
  call loop_QA_V(G2(:,:,:,267),wf(:,-5),G2(:,:,:,272))
  call loop_VA_Q(G2(:,:,:,272),wf(:,-2),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,62),MT,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,122))
  call loop_QA_Z(G2(:,:,:,267),wf(:,-5),G2(:,:,:,274),gZd)
  call loop_ZA_Q(G2(:,:,:,274),wf(:,-2),G2(:,:,:,275),gZu)
  call loop_A_Q(G2(:,:,:,275),Q(:,62),MT,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,123))
  call loop_QA_S(G2(:,:,:,267),wf(:,-2),G2(:,:,:,276),gPtb)
  call loop_SA_Q(G2(:,:,:,276),wf(:,-5),G2(:,:,:,277),gPbt)
  call loop_A_Q(G2(:,:,:,277),Q(:,62),MT,G3(:,:,:,104))
  call check_last_AQ_V(l_switch,G3(:,:,:,104),wf(:,0),G3tensor(:,124))
  call loop_QA_W(G2(:,:,:,267),wf(:,-2),G2(:,:,:,278))
  call loop_WA_Q(G2(:,:,:,278),wf(:,-5),G2(:,:,:,279))
  call loop_A_Q(G2(:,:,:,279),Q(:,62),MT,G3(:,:,:,105))
  call check_last_AQ_V(l_switch,G3(:,:,:,105),wf(:,0),G3tensor(:,125))
  call loop_AV_Q(G1(:,:,:,1),wf(:,871),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,61),MT,G2(:,:,:,280))
  call check_last_AQ_V(l_switch,G2(:,:,:,280),wf(:,-1),G2tensor(:,107))
  call loop_AV_Q(G1(:,:,:,1),wf(:,872),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,61),MT,G2(:,:,:,281))
  call check_last_AQ_V(l_switch,G2(:,:,:,281),wf(:,-1),G2tensor(:,108))
  call loop_AV_Q(G1(:,:,:,1),wf(:,875),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,61),MT,G2(:,:,:,282))
  call check_last_AQ_V(l_switch,G2(:,:,:,282),wf(:,-1),G2tensor(:,109))
  call loop_AV_Q(G1(:,:,:,1),wf(:,876),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,61),MT,G2(:,:,:,283))
  call check_last_AQ_V(l_switch,G2(:,:,:,283),wf(:,-1),G2tensor(:,110))
  call loop_AV_Q(G1(:,:,:,1),wf(:,879),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,62),MT,G2(:,:,:,284))
  call check_last_AQ_V(l_switch,G2(:,:,:,284),wf(:,0),G2tensor(:,111))
  call loop_AV_Q(G1(:,:,:,1),wf(:,880),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,62),MT,G2(:,:,:,285))
  call check_last_AQ_V(l_switch,G2(:,:,:,285),wf(:,0),G2tensor(:,112))
  call loop_AV_Q(G1(:,:,:,1),wf(:,883),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,62),MT,G2(:,:,:,286))
  call check_last_AQ_V(l_switch,G2(:,:,:,286),wf(:,0),G2tensor(:,113))
  call loop_AV_Q(G1(:,:,:,1),wf(:,884),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,62),MT,G2(:,:,:,287))
  call check_last_AQ_V(l_switch,G2(:,:,:,287),wf(:,0),G2tensor(:,114))
  call loop_AV_Q(G1(:,:,:,1),wf(:,887),G1(:,:,:,160))
  call loop_A_Q(G1(:,:,:,160),Q(:,61),MT,G2(:,:,:,288))
  call check_last_AQ_V(l_switch,G2(:,:,:,288),wf(:,-1),G2tensor(:,115))
  call loop_AV_Q(G1(:,:,:,1),wf(:,888),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,61),MT,G2(:,:,:,289))
  call check_last_AQ_V(l_switch,G2(:,:,:,289),wf(:,-1),G2tensor(:,116))
  call loop_AS_Q(G1(:,:,:,1),wf(:,889),G1(:,:,:,162),gH)
  call loop_A_Q(G1(:,:,:,162),Q(:,61),MT,G2(:,:,:,290))
  call check_last_AQ_V(l_switch,G2(:,:,:,290),wf(:,-1),G2tensor(:,117))
  call loop_AS_Q(G1(:,:,:,1),wf(:,890),G1(:,:,:,163),gX)
  call loop_A_Q(G1(:,:,:,163),Q(:,61),MT,G2(:,:,:,291))
  call check_last_AQ_V(l_switch,G2(:,:,:,291),wf(:,-1),G2tensor(:,118))
  call loop_AV_Q(G1(:,:,:,1),wf(:,891),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,61),MT,G2(:,:,:,292))
  call check_last_AQ_V(l_switch,G2(:,:,:,292),wf(:,-1),G2tensor(:,119))
  call loop_AV_Q(G1(:,:,:,1),wf(:,892),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,61),MT,G2(:,:,:,293))
  call check_last_AQ_V(l_switch,G2(:,:,:,293),wf(:,-1),G2tensor(:,120))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,893),G1(:,:,:,166),gZu)
  call loop_A_Q(G1(:,:,:,166),Q(:,61),MT,G2(:,:,:,294))
  call check_last_AQ_V(l_switch,G2(:,:,:,294),wf(:,-1),G2tensor(:,121))
  call loop_AS_Q(G1(:,:,:,1),wf(:,894),G1(:,:,:,167),gH)
  call loop_A_Q(G1(:,:,:,167),Q(:,61),MT,G2(:,:,:,295))
  call check_last_AQ_V(l_switch,G2(:,:,:,295),wf(:,-1),G2tensor(:,122))
  call loop_AS_Q(G1(:,:,:,1),wf(:,895),G1(:,:,:,168),gX)
  call loop_A_Q(G1(:,:,:,168),Q(:,61),MT,G2(:,:,:,296))
  call check_last_AQ_V(l_switch,G2(:,:,:,296),wf(:,-1),G2tensor(:,123))
  call loop_AV_Q(G1(:,:,:,1),wf(:,896),G1(:,:,:,169))
  call loop_A_Q(G1(:,:,:,169),Q(:,61),MT,G2(:,:,:,297))
  call check_last_AQ_V(l_switch,G2(:,:,:,297),wf(:,-1),G2tensor(:,124))
  call loop_AV_Q(G1(:,:,:,1),wf(:,897),G1(:,:,:,170))
  call loop_A_Q(G1(:,:,:,170),Q(:,61),MT,G2(:,:,:,298))
  call check_last_AQ_V(l_switch,G2(:,:,:,298),wf(:,-1),G2tensor(:,125))
  call loop_AV_Q(G1(:,:,:,1),wf(:,898),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,61),MT,G2(:,:,:,299))
  call check_last_AQ_V(l_switch,G2(:,:,:,299),wf(:,-1),G2tensor(:,126))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,899),G1(:,:,:,172),gZu)
  call loop_A_Q(G1(:,:,:,172),Q(:,61),MT,G2(:,:,:,300))
  call check_last_AQ_V(l_switch,G2(:,:,:,300),wf(:,-1),G2tensor(:,127))
  call loop_AV_Q(G1(:,:,:,1),wf(:,900),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,61),MT,G2(:,:,:,301))
  call check_last_AQ_V(l_switch,G2(:,:,:,301),wf(:,-1),G2tensor(:,128))
  call loop_AQ_S(G1(:,:,:,1),wf(:,140),G1(:,:,:,174),gH)
  call loop_SA_Q(G1(:,:,:,174),wf(:,-2),G1(:,:,:,175),gH)
  call loop_A_Q(G1(:,:,:,175),Q(:,61),MT,G2(:,:,:,302))
  call check_last_AQ_V(l_switch,G2(:,:,:,302),wf(:,-1),G2tensor(:,129))
  call loop_SQ_A(G1(:,:,:,174),wf(:,-1),G1(:,:,:,176),gH)
  call loop_Q_A(G1(:,:,:,176),Q(:,59),MT,G2(:,:,:,303))
  call check_last_QA_V(l_switch,G2(:,:,:,303),wf(:,-2),G2tensor(:,130))
  call loop_AQ_S(G1(:,:,:,1),wf(:,140),G1(:,:,:,177),gX)
  call loop_SA_Q(G1(:,:,:,177),wf(:,-2),G1(:,:,:,178),gX)
  call loop_A_Q(G1(:,:,:,178),Q(:,61),MT,G2(:,:,:,304))
  call check_last_AQ_V(l_switch,G2(:,:,:,304),wf(:,-1),G2tensor(:,131))
  call loop_SQ_A(G1(:,:,:,177),wf(:,-1),G1(:,:,:,179),gX)
  call loop_Q_A(G1(:,:,:,179),Q(:,59),MT,G2(:,:,:,305))
  call check_last_QA_V(l_switch,G2(:,:,:,305),wf(:,-2),G2tensor(:,132))
  call loop_AQ_Z(G1(:,:,:,1),wf(:,140),G1(:,:,:,180),gZu)
  call loop_ZA_Q(G1(:,:,:,180),wf(:,-2),G1(:,:,:,181),gZu)
  call loop_A_Q(G1(:,:,:,181),Q(:,61),MT,G2(:,:,:,306))
  call check_last_AQ_V(l_switch,G2(:,:,:,306),wf(:,-1),G2tensor(:,133))
  call loop_ZQ_A(G1(:,:,:,180),wf(:,-1),G1(:,:,:,182),gZu)
  call loop_Q_A(G1(:,:,:,182),Q(:,59),MT,G2(:,:,:,307))
  call check_last_QA_V(l_switch,G2(:,:,:,307),wf(:,-2),G2tensor(:,134))
  call loop_AV_Q(G1(:,:,:,1),wf(:,915),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,62),MT,G2(:,:,:,308))
  call check_last_AQ_V(l_switch,G2(:,:,:,308),wf(:,0),G2tensor(:,135))
  call loop_AV_Q(G1(:,:,:,1),wf(:,916),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,62),MT,G2(:,:,:,309))
  call check_last_AQ_V(l_switch,G2(:,:,:,309),wf(:,0),G2tensor(:,136))
  call loop_AS_Q(G1(:,:,:,1),wf(:,917),G1(:,:,:,185),gH)
  call loop_A_Q(G1(:,:,:,185),Q(:,62),MT,G2(:,:,:,310))
  call check_last_AQ_V(l_switch,G2(:,:,:,310),wf(:,0),G2tensor(:,137))
  call loop_AS_Q(G1(:,:,:,1),wf(:,918),G1(:,:,:,186),gX)
  call loop_A_Q(G1(:,:,:,186),Q(:,62),MT,G2(:,:,:,311))
  call check_last_AQ_V(l_switch,G2(:,:,:,311),wf(:,0),G2tensor(:,138))
  call loop_AV_Q(G1(:,:,:,1),wf(:,919),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,62),MT,G2(:,:,:,312))
  call check_last_AQ_V(l_switch,G2(:,:,:,312),wf(:,0),G2tensor(:,139))
  call loop_AV_Q(G1(:,:,:,1),wf(:,920),G1(:,:,:,188))
  call loop_A_Q(G1(:,:,:,188),Q(:,62),MT,G2(:,:,:,313))
  call check_last_AQ_V(l_switch,G2(:,:,:,313),wf(:,0),G2tensor(:,140))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,921),G1(:,:,:,189),gZu)
  call loop_A_Q(G1(:,:,:,189),Q(:,62),MT,G2(:,:,:,314))
  call check_last_AQ_V(l_switch,G2(:,:,:,314),wf(:,0),G2tensor(:,141))
  call loop_AS_Q(G1(:,:,:,1),wf(:,922),G1(:,:,:,190),gH)
  call loop_A_Q(G1(:,:,:,190),Q(:,62),MT,G2(:,:,:,315))
  call check_last_AQ_V(l_switch,G2(:,:,:,315),wf(:,0),G2tensor(:,142))
  call loop_AS_Q(G1(:,:,:,1),wf(:,923),G1(:,:,:,191),gX)
  call loop_A_Q(G1(:,:,:,191),Q(:,62),MT,G2(:,:,:,316))
  call check_last_AQ_V(l_switch,G2(:,:,:,316),wf(:,0),G2tensor(:,143))
  call loop_AV_Q(G1(:,:,:,1),wf(:,924),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,317))
  call check_last_AQ_V(l_switch,G2(:,:,:,317),wf(:,0),G2tensor(:,144))
  call loop_AV_Q(G1(:,:,:,1),wf(:,925),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,62),MT,G2(:,:,:,318))
  call check_last_AQ_V(l_switch,G2(:,:,:,318),wf(:,0),G2tensor(:,145))
  call loop_AV_Q(G1(:,:,:,1),wf(:,926),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,62),MT,G2(:,:,:,319))
  call check_last_AQ_V(l_switch,G2(:,:,:,319),wf(:,0),G2tensor(:,146))
  call loop_AZ_Q(G1(:,:,:,1),wf(:,927),G1(:,:,:,195),gZu)
  call loop_A_Q(G1(:,:,:,195),Q(:,62),MT,G2(:,:,:,320))
  call check_last_AQ_V(l_switch,G2(:,:,:,320),wf(:,0),G2tensor(:,147))
  call loop_AV_Q(G1(:,:,:,1),wf(:,928),G1(:,:,:,196))
  call loop_A_Q(G1(:,:,:,196),Q(:,62),MT,G2(:,:,:,321))
  call check_last_AQ_V(l_switch,G2(:,:,:,321),wf(:,0),G2tensor(:,148))
  call loop_AQ_S(G1(:,:,:,1),wf(:,70),G1(:,:,:,197),gH)
  call loop_SA_Q(G1(:,:,:,197),wf(:,-2),G1(:,:,:,198),gH)
  call loop_A_Q(G1(:,:,:,198),Q(:,62),MT,G2(:,:,:,322))
  call check_last_AQ_V(l_switch,G2(:,:,:,322),wf(:,0),G2tensor(:,149))
  call loop_SQ_A(G1(:,:,:,197),wf(:,0),G1(:,:,:,199),gH)
  call loop_Q_A(G1(:,:,:,199),Q(:,59),MT,G2(:,:,:,323))
  call check_last_QA_V(l_switch,G2(:,:,:,323),wf(:,-2),G2tensor(:,150))
  call loop_AQ_S(G1(:,:,:,1),wf(:,70),G1(:,:,:,200),gX)
  call loop_SA_Q(G1(:,:,:,200),wf(:,-2),G1(:,:,:,201),gX)
  call loop_A_Q(G1(:,:,:,201),Q(:,62),MT,G2(:,:,:,324))
  call check_last_AQ_V(l_switch,G2(:,:,:,324),wf(:,0),G2tensor(:,151))
  call loop_SQ_A(G1(:,:,:,200),wf(:,0),G1(:,:,:,202),gX)
  call loop_Q_A(G1(:,:,:,202),Q(:,59),MT,G2(:,:,:,325))
  call check_last_QA_V(l_switch,G2(:,:,:,325),wf(:,-2),G2tensor(:,152))
  call loop_AQ_Z(G1(:,:,:,1),wf(:,70),G1(:,:,:,203),gZu)
  call loop_ZA_Q(G1(:,:,:,203),wf(:,-2),G1(:,:,:,204),gZu)
  call loop_A_Q(G1(:,:,:,204),Q(:,62),MT,G2(:,:,:,326))
  call check_last_AQ_V(l_switch,G2(:,:,:,326),wf(:,0),G2tensor(:,153))
  call loop_ZQ_A(G1(:,:,:,203),wf(:,0),G1(:,:,:,205),gZu)
  call loop_Q_A(G1(:,:,:,205),Q(:,59),MT,G2(:,:,:,327))
  call check_last_QA_V(l_switch,G2(:,:,:,327),wf(:,-2),G2tensor(:,154))
  call loop_VQ_A(G0(:,:,:,1),wf(:,258),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,50),MT,G1(:,:,:,206))
  call loop_QV_A(G1(:,:,:,206),wf(:,1),G1(:,:,:,207))
  call loop_Q_A(G1(:,:,:,207),Q(:,55),MT,G2(:,:,:,328))
  call check_last_QA_V(l_switch,G2(:,:,:,328),wf(:,-3),G2tensor(:,155))
  call loop_QV_A(G1(:,:,:,206),wf(:,79),G1(:,:,:,208))
  call loop_Q_A(G1(:,:,:,208),Q(:,59),MT,G2(:,:,:,329))
  call check_last_QA_V(l_switch,G2(:,:,:,329),wf(:,-2),G2tensor(:,156))
  call loop_QA_V(G1(:,:,:,206),wf(:,-3),G1(:,:,:,209))
  call loop_VA_Q(G1(:,:,:,209),wf(:,-2),G1(:,:,:,210))
  call loop_A_Q(G1(:,:,:,210),Q(:,62),MT,G2(:,:,:,330))
  call check_last_AQ_V(l_switch,G2(:,:,:,330),wf(:,0),G2tensor(:,157))
  call loop_QA_V(G1(:,:,:,206),wf(:,-2),G1(:,:,:,211))
  call loop_VA_Q(G1(:,:,:,211),wf(:,-3),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,62),MT,G2(:,:,:,331))
  call check_last_AQ_V(l_switch,G2(:,:,:,331),wf(:,0),G2tensor(:,158))
  call check_last_QA_V(l_switch,G1(:,:,:,206),wf(:,48),G1tensor(:,1))
  call check_last_QA_V(l_switch,G1(:,:,:,206),wf(:,156),G1tensor(:,2))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(86)*M(5)-c(85)*M(7)) * den(184)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(76)*M(5))+c(75)*M(7)) * den(184)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,155)
  Gcoeff = (c(72)*M(5)-c(71)*M(7)) * den(184)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(86)*M(5)-c(85)*M(7)) * den(648)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(72)*M(5)-c(71)*M(7)) * den(648)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(122)*M(7))+c(121)*M(11)) * den(42)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(122)*M(7)-c(121)*M(11)) * den(44)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(115)*M(9)-c(110)*M(11)) * den(46)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(115)*M(9)-c(110)*M(11)) * den(48)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(24)*M(7)-c(23)*M(11)) * den(49)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(44)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(21)*M(9)-c(16)*M(11)) * den(49)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(43)*M(9))+c(38)*M(11)) * den(48)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(49)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(59)*M(4)+c(56)*(-M(8)-M(10))+c(55)*M(12)) * den(49)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(55)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(57)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(58)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(57)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(50)*M(6))+c(48)*(M(8)+M(10))-c(47)*M(12)) * den(58)
  T2sum(1:15,37) = T2sum(1:15,37) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(4)*(-M(3)+M(5))) * den(290)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(47)*(M(4)-M(6))) * den(290)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(122)*M(7))+c(121)*M(11)) * den(649)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(122)*M(7)-c(121)*M(11)) * den(650)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(651)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(652)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(24)*M(7)-c(23)*M(11)) * den(288)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(650)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(14)*M(9))+c(13)*M(11)) * den(288)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(36)*M(9)-c(35)*M(11)) * den(652)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,32)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(288)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(64)*M(2))+c(59)*M(4)+c(56)*(-M(8)-M(10))+c(60)*M(12)) * den(288)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(122)*M(7))+c(121)*M(11)) * den(649)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(122)*M(7)-c(121)*M(11)) * den(650)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,36)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(651)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,37)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(652)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(24)*M(7)-c(23)*M(11)) * den(288)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(650)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(14)*M(9))+c(13)*M(11)) * den(288)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(36)*M(9)-c(35)*M(11)) * den(652)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(288)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,39)
  Gcoeff = (-(c(64)*M(2))+c(59)*M(6)+c(56)*(-M(8)-M(10))+c(60)*M(12)) * den(288)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(89)*M(7)+c(93)*M(9)+c(90)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(75)*M(7)+c(79)*M(9)+c(76)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(491)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(492)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(494)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(496)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(14)*M(7))+c(13)*M(11)) * den(497)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(492)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(21)*M(1)-c(16)*M(11)) * den(497)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(496)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(7))-c(23)*M(11)) * den(497)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(59)*M(6)+c(56)*(-M(2)-M(8))+c(55)*M(12)) * den(497)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(5)-M(11))) * den(14)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(5)-M(11))) * den(14)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(499)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(500)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(501)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(502)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(14)*M(7))+c(13)*M(11)) * den(503)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(500)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(21)*M(1)-c(16)*M(11)) * den(503)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(502)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(1)+M(7))-c(23)*M(11)) * den(503)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(59)*M(4)+c(56)*(-M(2)-M(8))+c(55)*M(12)) * den(503)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,113) = T2sum(1:15,113) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,113) = T2sum(1:15,113) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,39) = T3sum(1:35,39) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,49) = T3sum(1:35,49) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,49) = T3sum(1:35,49) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,50) = T3sum(1:35,50) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,51) = T3sum(1:35,51) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(1)
  T3sum(1:35,51) = T3sum(1:35,51) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,54) = T3sum(1:35,54) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,54) = T3sum(1:35,54) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(85)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,61) = T3sum(1:35,61) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(71)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,61) = T3sum(1:35,61) + Gcoeff * G3tensor(:,54)
  Gcoeff = (-(c(86)*M(1))+c(85)*M(3)) * den(212)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(72)*M(1))+c(71)*M(3)) * den(212)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(86)*M(1))+c(85)*M(3)) * den(661)
  T3sum(1:35,98) = T3sum(1:35,98) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(72)*M(1))+c(71)*M(3)) * den(661)
  T3sum(1:35,98) = T3sum(1:35,98) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(122)*M(3)-c(121)*M(9)) * den(97)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(122)*M(3))+c(121)*M(9)) * den(99)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(110)*M(9)-c(115)*M(11)) * den(100)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(110)*M(9)-c(115)*M(11)) * den(101)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(9)) * den(102)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(36)*M(3))+c(35)*M(9)) * den(99)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(16)*M(9)-c(21)*M(11)) * den(102)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(38)*M(9))+c(43)*M(11)) * den(101)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(27)*M(7)+c(23)*M(9)+c(24)*(-M(3)-M(11))) * den(102)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(59)*M(8))-c(55)*M(10)+c(56)*(M(4)+M(12))) * den(102)
  T2sum(1:15,38) = T2sum(1:15,38) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(105)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(103)*M(9)-c(104)*M(11)) * den(107)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(2)*M(9)-c(3)*M(11)) * den(111)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(6)*M(9))+c(7)*M(11)) * den(107)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(50)*M(2)+c(47)*M(10)+c(48)*(-M(4)-M(12))) * den(111)
  T2sum(1:15,140) = T2sum(1:15,140) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(4)*(-M(1)+M(7))) * den(352)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(47)*(M(2)-M(8))) * den(352)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(122)*M(3)-c(121)*M(9)) * den(662)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(122)*M(3))+c(121)*M(9)) * den(663)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(664)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(665)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(9)) * den(350)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(36)*M(3))+c(35)*M(9)) * den(663)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(13)*M(9))+c(14)*M(11)) * den(350)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(35)*M(9)-c(36)*M(11)) * den(665)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(27)*M(7)+c(23)*M(9)+c(24)*(-M(3)-M(11))) * den(350)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(64)*M(6)-c(59)*M(8)-c(60)*M(10)+c(56)*(M(4)+M(12))) * den(350)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(122)*M(3)-c(121)*M(9)) * den(662)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,80)
  Gcoeff = (-(c(122)*M(3))+c(121)*M(9)) * den(663)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(664)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,82)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(665)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(24)*M(3))+c(23)*M(9)) * den(350)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,84)
  Gcoeff = (-(c(36)*M(3))+c(35)*M(9)) * den(663)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,88)
  Gcoeff = (-(c(13)*M(9))+c(14)*M(11)) * den(350)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(35)*M(9)-c(36)*M(11)) * den(665)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(27)*M(1)+c(23)*M(9)+c(24)*(-M(3)-M(11))) * den(350)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,84)
  Gcoeff = (-(c(59)*M(2))+c(64)*M(6)-c(60)*M(10)+c(56)*(M(4)+M(12))) * den(350)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,84)
  Gcoeff = (-(c(89)*M(3))+c(90)*(M(7)+M(9))-c(93)*M(11)) * den(85)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(75)*M(3))+c(76)*(M(7)+M(9))-c(79)*M(11)) * den(85)
  T2sum(1:15,63) = T2sum(1:15,63) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(108)*M(3)-c(107)*M(9)) * den(519)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(108)*M(3)-c(107)*M(9)) * den(520)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(115)*M(5))+c(110)*M(9)) * den(522)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(115)*M(5))+c(110)*M(9)) * den(524)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(14)*M(3)-c(13)*M(9)) * den(525)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(36)*M(3))+c(35)*M(9)) * den(520)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(21)*M(5))+c(16)*M(9)) * den(525)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(43)*M(5)-c(38)*M(9)) * den(524)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(27)*M(1)+c(24)*(-M(3)-M(5))+c(23)*M(9)) * den(525)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(59)*M(2))+c(56)*(M(4)+M(6))-c(55)*M(10)) * den(525)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(89)*M(3))-c(93)*M(5)+c(90)*(M(1)+M(9))) * den(77)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(75)*M(3))-c(79)*M(5)+c(76)*(M(1)+M(9))) * den(77)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(108)*M(3)-c(107)*M(9)) * den(526)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(108)*M(3)-c(107)*M(9)) * den(527)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(115)*M(5))+c(110)*M(9)) * den(528)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(115)*M(5))+c(110)*M(9)) * den(529)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(14)*M(3)-c(13)*M(9)) * den(530)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(36)*M(3))+c(35)*M(9)) * den(527)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(21)*M(5))+c(16)*M(9)) * den(530)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(43)*M(5)-c(38)*M(9)) * den(529)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(24)*(-M(3)-M(5))+c(27)*M(7)+c(23)*M(9)) * den(530)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(56)*(M(4)+M(6))-c(59)*M(8)-c(55)*M(10)) * den(530)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(89)*M(3))-c(93)*M(5)+c(90)*(M(7)+M(9))) * den(203)
  T2sum(1:15,198) = T2sum(1:15,198) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(75)*M(3))-c(79)*M(5)+c(76)*(M(7)+M(9))) * den(203)
  T2sum(1:15,198) = T2sum(1:15,198) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(103)*(-M(1)+M(7))) * den(60)
  T3sum(1:35,116) = T3sum(1:35,116) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(103)*(-M(1)+M(7))) * den(60)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(6)*(M(1)-M(7))) * den(60)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,101)
  Gcoeff = (-(c(89)*M(3))-c(93)*M(5)+c(90)*(M(1)+M(9))) * den(60)
  T3sum(1:35,126) = T3sum(1:35,126) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(75)*M(3))-c(79)*M(5)+c(76)*(M(1)+M(9))) * den(60)
  T3sum(1:35,126) = T3sum(1:35,126) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(103)*(-M(1)+M(7))) * den(60)
  T3sum(1:35,127) = T3sum(1:35,127) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(103)*(-M(1)+M(7))) * den(60)
  T3sum(1:35,128) = T3sum(1:35,128) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(6)*(M(1)-M(7))) * den(60)
  T3sum(1:35,128) = T3sum(1:35,128) + Gcoeff * G3tensor(:,103)
  Gcoeff = (-(c(89)*M(3))-c(93)*M(5)+c(90)*(M(7)+M(9))) * den(60)
  T3sum(1:35,131) = T3sum(1:35,131) + Gcoeff * G3tensor(:,45)
  Gcoeff = (-(c(75)*M(3))-c(79)*M(5)+c(76)*(M(7)+M(9))) * den(60)
  T3sum(1:35,131) = T3sum(1:35,131) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(85)*(M(5)-M(11))) * den(60)
  T3sum(1:35,138) = T3sum(1:35,138) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(71)*(M(5)-M(11))) * den(60)
  T3sum(1:35,138) = T3sum(1:35,138) + Gcoeff * G3tensor(:,56)
  Gcoeff = (-(c(75)*M(5))+c(76)*M(7)) * den(215)
  T2sum(1:15,206) = T2sum(1:15,206) + Gcoeff * G2tensor(:,156)
  Gcoeff = (c(89)*M(1)-c(90)*M(5)) * den(584)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(75)*M(1)-c(76)*M(5)) * den(584)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(89)*M(1)-c(90)*M(5)) * den(585)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(75)*M(1)-c(76)*M(5)) * den(585)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(90)*M(1)-c(89)*M(5)) * den(586)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(76)*M(1)-c(75)*M(5)) * den(586)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(90)*M(1)-c(89)*M(5)) * den(587)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(76)*M(1)-c(75)*M(5)) * den(587)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(89)*M(1)+c(96)*M(5)) * den(239)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(75)*M(1)+c(82)*M(5)) * den(239)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(89)*M(1)+c(96)*M(5)) * den(112)
  T3sum(1:35,282) = T3sum(1:35,282) + Gcoeff * G3tensor(:,107)
  Gcoeff = (c(75)*M(1)+c(82)*M(5)) * den(112)
  T3sum(1:35,282) = T3sum(1:35,282) + Gcoeff * G3tensor(:,108)
  Gcoeff = (c(89)*M(1)-c(90)*M(3)) * den(592)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(75)*M(1)-c(76)*M(3)) * den(592)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(89)*M(1)-c(90)*M(3)) * den(594)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(75)*M(1)-c(76)*M(3)) * den(594)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(96)*M(1))-c(89)*M(3)) * den(211)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(82)*M(1))-c(75)*M(3)) * den(211)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(96)*M(1))-c(89)*M(3)) * den(89)
  T3sum(1:35,287) = T3sum(1:35,287) + Gcoeff * G3tensor(:,77)
  Gcoeff = (-(c(82)*M(1))-c(75)*M(3)) * den(89)
  T3sum(1:35,287) = T3sum(1:35,287) + Gcoeff * G3tensor(:,79)
  Gcoeff = (-(c(89)*M(5))+c(90)*M(7)) * den(596)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(75)*M(5))+c(76)*M(7)) * den(596)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(89)*M(5))+c(90)*M(7)) * den(598)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(75)*M(5))+c(76)*M(7)) * den(598)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(96)*M(5)+c(89)*M(7)) * den(183)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(82)*M(5)+c(75)*M(7)) * den(183)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(77)*M(5))+c(80)*M(7)) * den(183)
  T2sum(1:15,324) = T2sum(1:15,324) + Gcoeff * G2tensor(:,157)
  Gcoeff = (-(c(80)*M(5))+c(77)*M(7)) * den(183)
  T2sum(1:15,325) = T2sum(1:15,325) + Gcoeff * G2tensor(:,158)
  Gcoeff = (c(96)*M(5)+c(89)*M(7)) * den(34)
  T3sum(1:35,291) = T3sum(1:35,291) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(82)*M(5)+c(75)*M(7)) * den(34)
  T3sum(1:35,291) = T3sum(1:35,291) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(600)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(601)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(129)*M(1)-c(124)*M(11)) * den(602)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,117)
  Gcoeff = (-(c(129)*M(1))+c(124)*M(11)) * den(603)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(14)*M(9))+c(13)*M(11)) * den(604)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(36)*M(9)-c(35)*M(11)) * den(601)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(31)*M(1))+c(26)*M(11)) * den(604)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(603)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,121)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(604)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(59)*M(4)+c(56)*(-M(2)-M(10))+c(55)*M(12)) * den(604)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(129)*M(1)-c(124)*M(11)) * den(605)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(129)*M(1))+c(124)*M(11)) * den(606)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,123)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(607)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,124)
  Gcoeff = (-(c(108)*M(9))+c(107)*M(11)) * den(608)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,125)
  Gcoeff = (-(c(31)*M(1))+c(26)*M(11)) * den(609)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,126)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(606)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,127)
  Gcoeff = (-(c(14)*M(9))+c(13)*M(11)) * den(609)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(36)*M(9)-c(35)*M(11)) * den(608)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,128)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(609)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(59)*M(6)+c(56)*(-M(2)-M(10))+c(55)*M(12)) * den(609)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,126)
  Gcoeff = (-(c(107)*M(9))-c(114)*M(11)) * den(104)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(107)*M(9))-c(114)*M(11)) * den(106)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(3)+M(11))) * den(108)
  T2sum(1:15,328) = T2sum(1:15,328) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,329) = T2sum(1:15,329) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(13)*M(9))-c(20)*M(11)) * den(108)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(35)*M(9)+c(42)*M(11)) * den(106)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(27)*M(1)+c(23)*M(9)+c(24)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(27)*M(1)+c(23)*M(9)+c(24)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,329) = T2sum(1:15,329) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(67)*M(2)+c(56)*M(4)-c(55)*M(10)-c(62)*M(12)) * den(108)
  T2sum(1:15,318) = T2sum(1:15,318) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(3)+M(11))) * den(108)
  T2sum(1:15,334) = T2sum(1:15,334) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,335) = T2sum(1:15,335) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(108)
  T2sum(1:15,335) = T2sum(1:15,335) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(125)*M(3)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(108)
  T2sum(1:15,338) = T2sum(1:15,338) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(125)*M(3))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(108)
  T2sum(1:15,339) = T2sum(1:15,339) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(108)
  T2sum(1:15,339) = T2sum(1:15,339) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(620)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,135)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(621)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,136)
  Gcoeff = (-(c(129)*M(5))+c(124)*M(9)) * den(622)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(129)*M(5)-c(124)*M(9)) * den(623)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,138)
  Gcoeff = (-(c(13)*M(9))+c(14)*M(11)) * den(624)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(35)*M(9)-c(36)*M(11)) * den(621)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(31)*M(5)-c(26)*M(9)) * den(624)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(43)*M(5)-c(38)*M(9)) * den(623)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(27)*M(7)+c(23)*M(9)+c(24)*(-M(5)-M(11))) * den(624)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,139)
  Gcoeff = (-(c(59)*M(8))-c(55)*M(10)+c(56)*(M(6)+M(12))) * den(624)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,139)
  Gcoeff = (-(c(129)*M(5))+c(124)*M(9)) * den(625)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(129)*M(5)-c(124)*M(9)) * den(626)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,143)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(627)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,144)
  Gcoeff = (-(c(107)*M(9))+c(108)*M(11)) * den(628)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(31)*M(5)-c(26)*M(9)) * den(629)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(43)*M(5)-c(38)*M(9)) * den(626)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,147)
  Gcoeff = (-(c(13)*M(9))+c(14)*M(11)) * den(629)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(35)*M(9)-c(36)*M(11)) * den(628)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(27)*M(1)+c(23)*M(9)+c(24)*(-M(5)-M(11))) * den(629)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,146)
  Gcoeff = (-(c(59)*M(2))-c(55)*M(10)+c(56)*(M(6)+M(12))) * den(629)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(54)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(56)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(7)-M(9))+c(121)*M(11)) * den(51)
  T2sum(1:15,344) = T2sum(1:15,344) + Gcoeff * G2tensor(:,149)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(7)+M(9))-c(121)*M(11)) * den(51)
  T2sum(1:15,345) = T2sum(1:15,345) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(20)*M(9)+c(13)*M(11)) * den(51)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(42)*M(9))-c(35)*M(11)) * den(56)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(51)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(51)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(51)
  T2sum(1:15,345) = T2sum(1:15,345) + Gcoeff * G2tensor(:,153)
  Gcoeff = (-(c(67)*M(6))-c(56)*M(8)+c(62)*M(10)+c(55)*M(12)) * den(51)
  T2sum(1:15,322) = T2sum(1:15,322) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(7)-M(9))+c(121)*M(11)) * den(51)
  T2sum(1:15,350) = T2sum(1:15,350) + Gcoeff * G2tensor(:,150)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(7)+M(9))-c(121)*M(11)) * den(51)
  T2sum(1:15,351) = T2sum(1:15,351) + Gcoeff * G2tensor(:,152)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(51)
  T2sum(1:15,351) = T2sum(1:15,351) + Gcoeff * G2tensor(:,154)
  Gcoeff = (-(c(125)*M(7))-c(121)*M(9)+c(122)*(M(5)+M(11))) * den(51)
  T2sum(1:15,354) = T2sum(1:15,354) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(125)*M(7)+c(121)*M(9)+c(122)*(-M(5)-M(11))) * den(51)
  T2sum(1:15,355) = T2sum(1:15,355) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(51)
  T2sum(1:15,355) = T2sum(1:15,355) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(251)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(253)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(5)+M(11))) * den(248)
  T2sum(1:15,366) = T2sum(1:15,366) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(5)-M(11))) * den(248)
  T2sum(1:15,367) = T2sum(1:15,367) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(248)
  T2sum(1:15,372) = T2sum(1:15,372) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(248)
  T2sum(1:15,373) = T2sum(1:15,373) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(248)
  T2sum(1:15,367) = T2sum(1:15,367) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(20)*M(9)+c(13)*M(11)) * den(248)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(42)*M(9))-c(35)*M(11)) * den(253)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(248)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(248)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(248)
  T2sum(1:15,373) = T2sum(1:15,373) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(56)*M(2))-c(67)*M(6)+c(62)*M(10)+c(55)*M(12)) * den(248)
  T2sum(1:15,313) = T2sum(1:15,313) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(7)-M(9))+c(121)*M(11)) * den(3)
  T3sum(1:35,299) = T3sum(1:35,299) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(7)+M(9))-c(121)*M(11)) * den(3)
  T3sum(1:35,300) = T3sum(1:35,300) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(3)
  T3sum(1:35,300) = T3sum(1:35,300) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(125)*M(7))-c(121)*M(9)+c(122)*(M(5)+M(11))) * den(3)
  T3sum(1:35,307) = T3sum(1:35,307) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(125)*M(7)+c(121)*M(9)+c(122)*(-M(5)-M(11))) * den(3)
  T3sum(1:35,308) = T3sum(1:35,308) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(3)
  T3sum(1:35,308) = T3sum(1:35,308) + Gcoeff * G3tensor(:,105)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(3)+M(11))) * den(3)
  T3sum(1:35,312) = T3sum(1:35,312) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(3)-M(11))) * den(3)
  T3sum(1:35,313) = T3sum(1:35,313) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(3)
  T3sum(1:35,313) = T3sum(1:35,313) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(125)*M(3)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(3)
  T3sum(1:35,317) = T3sum(1:35,317) + Gcoeff * G3tensor(:,62)
  Gcoeff = (-(c(125)*M(3))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(3)
  T3sum(1:35,318) = T3sum(1:35,318) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(3)
  T3sum(1:35,318) = T3sum(1:35,318) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(45)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(47)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(7)-M(9))+c(121)*M(11)) * den(3)
  T3sum(1:35,324) = T3sum(1:35,324) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(7)+M(9))-c(121)*M(11)) * den(3)
  T3sum(1:35,325) = T3sum(1:35,325) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(20)*M(9)+c(13)*M(11)) * den(3)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(42)*M(9))-c(35)*M(11)) * den(47)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,34)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(3)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(7)+M(9))-c(23)*M(11)) * den(3)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(3)
  T3sum(1:35,325) = T3sum(1:35,325) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(59)*(M(4)+M(6))-c(56)*M(8)-c(57)*M(10)+c(55)*M(12)) * den(3)
  T3sum(1:35,321) = T3sum(1:35,321) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(5)+M(11))) * den(3)
  T3sum(1:35,330) = T3sum(1:35,330) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(5)-M(11))) * den(3)
  T3sum(1:35,331) = T3sum(1:35,331) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(3)
  T3sum(1:35,331) = T3sum(1:35,331) + Gcoeff * G3tensor(:,106)
  Gcoeff = (c(4)*(M(3)-M(5))) * den(3)
  T3sum(1:35,336) = T3sum(1:35,336) + Gcoeff * G3tensor(:,113)
  Gcoeff = (-(c(47)*M(4))-c(49)*M(6)+c(48)*M(10)) * den(3)
  T3sum(1:35,336) = T3sum(1:35,336) + Gcoeff * G3tensor(:,113)
  Gcoeff = (-(c(125)*M(1))-c(121)*M(9)+c(122)*(M(3)+M(11))) * den(3)
  T3sum(1:35,338) = T3sum(1:35,338) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(125)*M(1)+c(121)*M(9)+c(122)*(-M(3)-M(11))) * den(3)
  T3sum(1:35,339) = T3sum(1:35,339) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(3)
  T3sum(1:35,339) = T3sum(1:35,339) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(45)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(114)*M(9)+c(107)*M(11)) * den(47)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(3)
  T3sum(1:35,351) = T3sum(1:35,351) + Gcoeff * G3tensor(:,63)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(3)
  T3sum(1:35,352) = T3sum(1:35,352) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(20)*M(9)+c(13)*M(11)) * den(3)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,116)
  Gcoeff = (-(c(42)*M(9))-c(35)*M(11)) * den(47)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,117)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(3)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,116)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(9))-c(23)*M(11)) * den(3)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,116)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(3)
  T3sum(1:35,352) = T3sum(1:35,352) + Gcoeff * G3tensor(:,75)
  Gcoeff = (-(c(56)*M(2))+c(59)*(M(4)+M(6))-c(57)*M(10)+c(55)*M(12)) * den(3)
  T3sum(1:35,348) = T3sum(1:35,348) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(90)*(-M(3)-M(5))+c(89)*M(7)+c(93)*M(9))
  T3sum(1:35,402) = T3sum(1:35,402) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(76)*(-M(3)-M(5))+c(75)*M(7)+c(79)*M(9))
  T3sum(1:35,402) = T3sum(1:35,402) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(9))+c(107)*M(11))
  T3sum(1:35,412) = T3sum(1:35,412) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(9))+c(107)*M(11))
  T3sum(1:35,413) = T3sum(1:35,413) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(7)-M(9))+c(107)*M(11))
  T3sum(1:35,414) = T3sum(1:35,414) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(7)-M(9))+c(107)*M(11))
  T3sum(1:35,415) = T3sum(1:35,415) + Gcoeff * G3tensor(:,121)
  Gcoeff = (-(c(27)*M(3))+c(24)*(M(1)+M(7))-c(23)*M(11))
  T3sum(1:35,416) = T3sum(1:35,416) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(9))+c(13)*M(11))
  T3sum(1:35,416) = T3sum(1:35,416) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11))
  T3sum(1:35,416) = T3sum(1:35,416) + Gcoeff * G3tensor(:,122)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11))
  T3sum(1:35,413) = T3sum(1:35,413) + Gcoeff * G3tensor(:,71)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11))
  T3sum(1:35,415) = T3sum(1:35,415) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(59)*M(4)+c(61)*M(6)+c(56)*(-M(2)-M(8))-c(65)*M(10)+c(55)*M(12))
  T3sum(1:35,416) = T3sum(1:35,416) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(9))+c(107)*M(11))
  T3sum(1:35,419) = T3sum(1:35,419) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(9))+c(107)*M(11))
  T3sum(1:35,420) = T3sum(1:35,420) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(7)-M(9))+c(107)*M(11))
  T3sum(1:35,421) = T3sum(1:35,421) + Gcoeff * G3tensor(:,109)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(7)-M(9))+c(107)*M(11))
  T3sum(1:35,422) = T3sum(1:35,422) + Gcoeff * G3tensor(:,110)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(7))-c(23)*M(11))
  T3sum(1:35,424) = T3sum(1:35,424) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(9))+c(13)*M(11))
  T3sum(1:35,424) = T3sum(1:35,424) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11))
  T3sum(1:35,424) = T3sum(1:35,424) + Gcoeff * G3tensor(:,111)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11))
  T3sum(1:35,420) = T3sum(1:35,420) + Gcoeff * G3tensor(:,73)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11))
  T3sum(1:35,422) = T3sum(1:35,422) + Gcoeff * G3tensor(:,112)
  Gcoeff = (-(c(66)*M(6))+c(56)*(-M(2)-M(8)-M(10))+c(55)*M(12))
  T3sum(1:35,424) = T3sum(1:35,424) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(90)*(-M(3)-M(5))+c(89)*M(7)+c(93)*M(9))
  T3sum(1:35,426) = T3sum(1:35,426) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(76)*(-M(3)-M(5))+c(75)*M(7)+c(79)*M(9))
  T3sum(1:35,426) = T3sum(1:35,426) + Gcoeff * G3tensor(:,55)
  Gcoeff = (-(c(111)*M(1))-c(107)*M(9)+c(108)*(M(5)+M(11)))
  T3sum(1:35,463) = T3sum(1:35,463) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(111)*M(1))-c(107)*M(9)+c(108)*(M(5)+M(11)))
  T3sum(1:35,464) = T3sum(1:35,464) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11)))
  T3sum(1:35,464) = T3sum(1:35,464) + Gcoeff * G3tensor(:,102)
  Gcoeff = (-(c(111)*M(1))-c(107)*M(9)+c(108)*(M(5)+M(11)))
  T3sum(1:35,479) = T3sum(1:35,479) + Gcoeff * G3tensor(:,92)
  Gcoeff = (-(c(111)*M(1))-c(107)*M(9)+c(108)*(M(5)+M(11)))
  T3sum(1:35,480) = T3sum(1:35,480) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(89)*M(1)+c(90)*(-M(3)-M(5))+c(93)*M(9))
  T3sum(1:35,485) = T3sum(1:35,485) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11)))
  T3sum(1:35,480) = T3sum(1:35,480) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(75)*M(1)+c(76)*(-M(3)-M(5))+c(79)*M(9))
  T3sum(1:35,485) = T3sum(1:35,485) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(89)*M(1)+c(90)*(-M(3)-M(5))+c(93)*M(9))
  T3sum(1:35,497) = T3sum(1:35,497) + Gcoeff * G3tensor(:,124)
  Gcoeff = (c(75)*M(1)+c(76)*(-M(3)-M(5))+c(79)*M(9))
  T3sum(1:35,497) = T3sum(1:35,497) + Gcoeff * G3tensor(:,125)
  Gcoeff = (-(c(89)*M(3))+c(90)*(M(1)+M(7))-c(93)*M(11))
  T3sum(1:35,500) = T3sum(1:35,500) + Gcoeff * G3tensor(:,50)
  Gcoeff = (-(c(75)*M(3))+c(76)*(M(1)+M(7))-c(79)*M(11))
  T3sum(1:35,500) = T3sum(1:35,500) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(83)*M(5)-c(78)*M(7)) * den(325)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(78)*M(5)-c(83)*M(7)) * den(420)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,2)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_5

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_5_pptttt_ew_tttxtxbbx_1_/**/REALKIND
