
module ol_vamp_4_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_4(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxbbx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,74) :: G0
  complex(REALKIND), dimension(4,5,4,282) :: G1
  complex(REALKIND), dimension(4,15,4,131) :: G2
  complex(REALKIND), dimension(4,35,4,19) :: G3
  complex(REALKIND), dimension(5,26) :: G1tensor
  complex(REALKIND), dimension(15,186) :: G2tensor
  complex(REALKIND), dimension(35,19) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,8),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,21),MB,G1(:,:,:,1))
  call loop_QA_V(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,61),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-1),G2tensor(:,2))
  call loop_VQ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,21),MB,G1(:,:,:,4))
  call loop_QA_V(G1(:,:,:,4),wf(:,-5),G1(:,:,:,5))
  call check_last_UV_W(l_switch,G1(:,:,:,5),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,5),wf(:,-3),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,61),MT,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,-1),G2tensor(:,4))
  call loop_AQ_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,4),gH)
  call loop_SA_Q(G0(:,:,:,4),wf(:,-5),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,53),MB,G1(:,:,:,7))
  call loop_AV_Q(G1(:,:,:,7),wf(:,2),G1(:,:,:,8))
  call check_last_A_Q(l_switch,G1(:,:,:,8),Q(:,63),MB,G2tensor(:,5))
  call loop_AQ_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,6),gX)
  call loop_SA_Q(G0(:,:,:,6),wf(:,-5),G0(:,:,:,7),gX)
  call loop_A_Q(G0(:,:,:,7),Q(:,53),MB,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,2),G1(:,:,:,10))
  call check_last_A_Q(l_switch,G1(:,:,:,10),Q(:,63),MB,G2tensor(:,6))
  call loop_AQ_S(G0(:,:,:,1),wf(:,15),G0(:,:,:,8),gPtb)
  call loop_SA_Q(G0(:,:,:,8),wf(:,-5),G0(:,:,:,9),gPbt)
  call loop_A_Q(G0(:,:,:,9),Q(:,53),MT,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,2),G1(:,:,:,12))
  call check_last_A_Q(l_switch,G1(:,:,:,12),Q(:,63),MT,G2tensor(:,7))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,15),G0(:,:,:,10),gZd)
  call loop_ZA_Q(G0(:,:,:,10),wf(:,-5),G0(:,:,:,11),gZd)
  call loop_A_Q(G0(:,:,:,11),Q(:,53),MB,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,2),G1(:,:,:,14))
  call check_last_A_Q(l_switch,G1(:,:,:,14),Q(:,63),MB,G2tensor(:,8))
  call loop_AQ_W(G0(:,:,:,1),wf(:,15),G0(:,:,:,12))
  call loop_WA_Q(G0(:,:,:,12),wf(:,-5),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,53),MT,G1(:,:,:,15))
  call loop_AV_Q(G1(:,:,:,15),wf(:,2),G1(:,:,:,16))
  call check_last_A_Q(l_switch,G1(:,:,:,16),Q(:,63),MT,G2tensor(:,9))
  call loop_VQ_A(G0(:,:,:,1),wf(:,15),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,21),MB,G1(:,:,:,17))
  call loop_QA_V(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,18),wf(:,-3),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,61),MT,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-1),G2tensor(:,11))
  call loop_QS_A(G1(:,:,:,17),wf(:,45),G1(:,:,:,20),gPtb)
  call loop_Q_A(G1(:,:,:,20),Q(:,55),MT,G2(:,:,:,4))
  call check_last_QA_V(l_switch,G2(:,:,:,4),wf(:,-3),G2tensor(:,12))
  call loop_QW_A(G1(:,:,:,17),wf(:,49),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,55),MT,G2(:,:,:,5))
  call check_last_QA_V(l_switch,G2(:,:,:,5),wf(:,-3),G2tensor(:,13))
  call loop_QA_S(G1(:,:,:,17),wf(:,-5),G1(:,:,:,22),gH)
  call loop_SQ_A(G1(:,:,:,22),wf(:,-1),G1(:,:,:,23),gH)
  call loop_Q_A(G1(:,:,:,23),Q(:,55),MT,G2(:,:,:,6))
  call check_last_QA_V(l_switch,G2(:,:,:,6),wf(:,-3),G2tensor(:,14))
  call loop_SA_Q(G1(:,:,:,22),wf(:,-3),G1(:,:,:,24),gH)
  call loop_A_Q(G1(:,:,:,24),Q(:,61),MT,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,-1),G2tensor(:,15))
  call loop_QA_S(G1(:,:,:,17),wf(:,-5),G1(:,:,:,25),gX)
  call loop_SQ_A(G1(:,:,:,25),wf(:,-1),G1(:,:,:,26),gX)
  call loop_Q_A(G1(:,:,:,26),Q(:,55),MT,G2(:,:,:,8))
  call check_last_QA_V(l_switch,G2(:,:,:,8),wf(:,-3),G2tensor(:,16))
  call loop_SA_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,27),gX)
  call loop_A_Q(G1(:,:,:,27),Q(:,61),MT,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,17))
  call loop_QA_Z(G1(:,:,:,17),wf(:,-5),G1(:,:,:,28),gZd)
  call loop_ZQ_A(G1(:,:,:,28),wf(:,-1),G1(:,:,:,29),gZu)
  call loop_Q_A(G1(:,:,:,29),Q(:,55),MT,G2(:,:,:,10))
  call check_last_QA_V(l_switch,G2(:,:,:,10),wf(:,-3),G2tensor(:,18))
  call loop_ZA_Q(G1(:,:,:,28),wf(:,-3),G1(:,:,:,30),gZu)
  call loop_A_Q(G1(:,:,:,30),Q(:,61),MT,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,-1),G2tensor(:,19))
  call loop_QA_S(G1(:,:,:,17),wf(:,-3),G1(:,:,:,31),gPtb)
  call loop_SA_Q(G1(:,:,:,31),wf(:,-5),G1(:,:,:,32),gPbt)
  call loop_A_Q(G1(:,:,:,32),Q(:,61),MT,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,-1),G2tensor(:,20))
  call loop_QA_W(G1(:,:,:,17),wf(:,-3),G1(:,:,:,33))
  call loop_WA_Q(G1(:,:,:,33),wf(:,-5),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,61),MT,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,-1),G2tensor(:,21))
  call loop_VQ_A(G0(:,:,:,1),wf(:,20),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,21),MB,G1(:,:,:,35))
  call loop_QA_V(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,36),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,36),wf(:,-3),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,61),MT,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,-1),G2tensor(:,23))
  call loop_VA_Q(G0(:,:,:,1),wf(:,213),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,37),MB,G1(:,:,:,38))
  call loop_AV_Q(G1(:,:,:,38),wf(:,2),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,47),MB,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,-4),G2tensor(:,24))
  call loop_AQ_V(G1(:,:,:,38),wf(:,-4),G1(:,:,:,40))
  call loop_VA_Q(G1(:,:,:,40),wf(:,-3),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,61),MT,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-1),G2tensor(:,25))
  call check_last_AQ_V(l_switch,G1(:,:,:,38),wf(:,25),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,1),wf(:,214),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,37),MB,G1(:,:,:,42))
  call loop_AV_Q(G1(:,:,:,42),wf(:,2),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,47),MB,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,-4),G2tensor(:,26))
  call loop_AQ_V(G1(:,:,:,42),wf(:,-4),G1(:,:,:,44))
  call loop_VA_Q(G1(:,:,:,44),wf(:,-3),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,61),MT,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,-1),G2tensor(:,27))
  call check_last_AQ_V(l_switch,G1(:,:,:,42),wf(:,25),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,216),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,37),MB,G1(:,:,:,46))
  call loop_AS_Q(G1(:,:,:,46),wf(:,12),G1(:,:,:,47),gH)
  call loop_A_Q(G1(:,:,:,47),Q(:,47),MB,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,-4),G2tensor(:,28))
  call loop_AS_Q(G1(:,:,:,46),wf(:,16),G1(:,:,:,48),gX)
  call loop_A_Q(G1(:,:,:,48),Q(:,47),MB,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,-4),G2tensor(:,29))
  call loop_AV_Q(G1(:,:,:,46),wf(:,2),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,47),MB,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,-4),G2tensor(:,30))
  call loop_AZ_Q(G1(:,:,:,46),wf(:,21),G1(:,:,:,50),gZd)
  call loop_A_Q(G1(:,:,:,50),Q(:,47),MB,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,-4),G2tensor(:,31))
  call loop_AS_Q(G1(:,:,:,46),wf(:,35),G1(:,:,:,51),gPbt)
  call loop_A_Q(G1(:,:,:,51),Q(:,61),MT,G2(:,:,:,23))
  call check_last_AQ_V(l_switch,G2(:,:,:,23),wf(:,-1),G2tensor(:,32))
  call loop_AW_Q(G1(:,:,:,46),wf(:,39),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,61),MT,G2(:,:,:,24))
  call check_last_AQ_V(l_switch,G2(:,:,:,24),wf(:,-1),G2tensor(:,33))
  call loop_AQ_S(G1(:,:,:,46),wf(:,-4),G1(:,:,:,53),gH)
  call loop_SQ_A(G1(:,:,:,53),wf(:,-1),G1(:,:,:,54),gH)
  call loop_Q_A(G1(:,:,:,54),Q(:,55),MT,G2(:,:,:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,25),wf(:,-3),G2tensor(:,34))
  call loop_SA_Q(G1(:,:,:,53),wf(:,-3),G1(:,:,:,55),gH)
  call loop_A_Q(G1(:,:,:,55),Q(:,61),MT,G2(:,:,:,26))
  call check_last_AQ_V(l_switch,G2(:,:,:,26),wf(:,-1),G2tensor(:,35))
  call loop_AQ_S(G1(:,:,:,46),wf(:,-4),G1(:,:,:,56),gX)
  call loop_SQ_A(G1(:,:,:,56),wf(:,-1),G1(:,:,:,57),gX)
  call loop_Q_A(G1(:,:,:,57),Q(:,55),MT,G2(:,:,:,27))
  call check_last_QA_V(l_switch,G2(:,:,:,27),wf(:,-3),G2tensor(:,36))
  call loop_SA_Q(G1(:,:,:,56),wf(:,-3),G1(:,:,:,58),gX)
  call loop_A_Q(G1(:,:,:,58),Q(:,61),MT,G2(:,:,:,28))
  call check_last_AQ_V(l_switch,G2(:,:,:,28),wf(:,-1),G2tensor(:,37))
  call loop_AQ_Z(G1(:,:,:,46),wf(:,-4),G1(:,:,:,59),gZd)
  call loop_ZQ_A(G1(:,:,:,59),wf(:,-1),G1(:,:,:,60),gZu)
  call loop_Q_A(G1(:,:,:,60),Q(:,55),MT,G2(:,:,:,29))
  call check_last_QA_V(l_switch,G2(:,:,:,29),wf(:,-3),G2tensor(:,38))
  call loop_ZA_Q(G1(:,:,:,59),wf(:,-3),G1(:,:,:,61),gZu)
  call loop_A_Q(G1(:,:,:,61),Q(:,61),MT,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,-1),G2tensor(:,39))
  call loop_AQ_S(G1(:,:,:,46),wf(:,-1),G1(:,:,:,62),gPbt)
  call loop_SA_Q(G1(:,:,:,62),wf(:,-3),G1(:,:,:,63),gPtb)
  call loop_A_Q(G1(:,:,:,63),Q(:,47),MB,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,-4),G2tensor(:,40))
  call loop_SQ_A(G1(:,:,:,62),wf(:,-4),G1(:,:,:,64),gPtb)
  call loop_Q_A(G1(:,:,:,64),Q(:,55),MT,G2(:,:,:,32))
  call check_last_QA_V(l_switch,G2(:,:,:,32),wf(:,-3),G2tensor(:,41))
  call loop_AQ_V(G1(:,:,:,46),wf(:,-4),G1(:,:,:,65))
  call loop_VA_Q(G1(:,:,:,65),wf(:,-3),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,61),MT,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,-1),G2tensor(:,42))
  call loop_AQ_W(G1(:,:,:,46),wf(:,-1),G1(:,:,:,67))
  call loop_WA_Q(G1(:,:,:,67),wf(:,-3),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,47),MB,G2(:,:,:,34))
  call check_last_AQ_V(l_switch,G2(:,:,:,34),wf(:,-4),G2tensor(:,43))
  call loop_WQ_A(G1(:,:,:,67),wf(:,-4),G1(:,:,:,69))
  call loop_Q_A(G1(:,:,:,69),Q(:,55),MT,G2(:,:,:,35))
  call check_last_QA_V(l_switch,G2(:,:,:,35),wf(:,-3),G2tensor(:,44))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,29),G1tensor(:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,31),G1tensor(:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,25),G1tensor(:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,34),G1tensor(:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,42),G1tensor(:,7))
  call check_last_AQ_V(l_switch,G1(:,:,:,46),wf(:,44),G1tensor(:,8))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,19),gH)
  call loop_SA_Q(G0(:,:,:,19),wf(:,216),G0(:,:,:,20),gH)
  call loop_A_Q(G0(:,:,:,20),Q(:,53),MB,G1(:,:,:,70))
  call loop_AV_Q(G1(:,:,:,70),wf(:,2),G1(:,:,:,71))
  call check_last_A_Q(l_switch,G1(:,:,:,71),Q(:,63),MB,G2tensor(:,45))
  call loop_SA_Q(G0(:,:,:,19),wf(:,222),G0(:,:,:,21),gH)
  call loop_A_Q(G0(:,:,:,21),Q(:,58),MB,G1(:,:,:,72))
  call loop_AV_Q(G1(:,:,:,72),wf(:,1),G1(:,:,:,73))
  call check_last_A_Q(l_switch,G1(:,:,:,73),Q(:,63),MB,G2tensor(:,46))
  call loop_SA_Q(G0(:,:,:,19),wf(:,-5),G0(:,:,:,22),gH)
  call loop_A_Q(G0(:,:,:,22),Q(:,48),MB,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,4),G1(:,:,:,75))
  call check_last_A_Q(l_switch,G1(:,:,:,75),Q(:,63),MB,G2tensor(:,47))
  call loop_AV_Q(G1(:,:,:,74),wf(:,715),G1(:,:,:,76))
  call check_last_A_Q(l_switch,G1(:,:,:,76),Q(:,63),MB,G2tensor(:,48))
  call loop_AV_Q(G1(:,:,:,74),wf(:,724),G1(:,:,:,77))
  call check_last_A_Q(l_switch,G1(:,:,:,77),Q(:,63),MB,G2tensor(:,49))
  call loop_AV_Q(G1(:,:,:,74),wf(:,81),G1(:,:,:,78))
  call check_last_A_Q(l_switch,G1(:,:,:,78),Q(:,63),MB,G2tensor(:,50))
  call loop_AV_Q(G1(:,:,:,74),wf(:,751),G1(:,:,:,79))
  call check_last_A_Q(l_switch,G1(:,:,:,79),Q(:,63),MB,G2tensor(:,51))
  call loop_AV_Q(G1(:,:,:,74),wf(:,760),G1(:,:,:,80))
  call check_last_A_Q(l_switch,G1(:,:,:,80),Q(:,63),MB,G2tensor(:,52))
  call loop_AV_Q(G1(:,:,:,74),wf(:,787),G1(:,:,:,81))
  call check_last_A_Q(l_switch,G1(:,:,:,81),Q(:,63),MB,G2tensor(:,53))
  call loop_AV_Q(G1(:,:,:,74),wf(:,796),G1(:,:,:,82))
  call check_last_A_Q(l_switch,G1(:,:,:,82),Q(:,63),MB,G2tensor(:,54))
  call loop_AV_Q(G1(:,:,:,74),wf(:,823),G1(:,:,:,83))
  call check_last_A_Q(l_switch,G1(:,:,:,83),Q(:,63),MB,G2tensor(:,55))
  call loop_AV_Q(G1(:,:,:,74),wf(:,832),G1(:,:,:,84))
  call check_last_A_Q(l_switch,G1(:,:,:,84),Q(:,63),MB,G2tensor(:,56))
  call loop_SA_Q(G0(:,:,:,19),wf(:,297),G0(:,:,:,23),gH)
  call loop_A_Q(G0(:,:,:,23),Q(:,57),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,80),G1(:,:,:,86))
  call check_last_A_Q(l_switch,G1(:,:,:,86),Q(:,63),MB,G2tensor(:,57))
  call loop_SA_Q(G0(:,:,:,19),wf(:,303),G0(:,:,:,24),gH)
  call loop_A_Q(G0(:,:,:,24),Q(:,54),MB,G1(:,:,:,87))
  call loop_AV_Q(G1(:,:,:,87),wf(:,79),G1(:,:,:,88))
  call check_last_A_Q(l_switch,G1(:,:,:,88),Q(:,63),MB,G2tensor(:,58))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,25),gX)
  call loop_SA_Q(G0(:,:,:,25),wf(:,216),G0(:,:,:,26),gX)
  call loop_A_Q(G0(:,:,:,26),Q(:,53),MB,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,2),G1(:,:,:,90))
  call check_last_A_Q(l_switch,G1(:,:,:,90),Q(:,63),MB,G2tensor(:,59))
  call loop_SA_Q(G0(:,:,:,25),wf(:,222),G0(:,:,:,27),gX)
  call loop_A_Q(G0(:,:,:,27),Q(:,58),MB,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,1),G1(:,:,:,92))
  call check_last_A_Q(l_switch,G1(:,:,:,92),Q(:,63),MB,G2tensor(:,60))
  call loop_SA_Q(G0(:,:,:,25),wf(:,-5),G0(:,:,:,28),gX)
  call loop_A_Q(G0(:,:,:,28),Q(:,48),MB,G1(:,:,:,93))
  call loop_AV_Q(G1(:,:,:,93),wf(:,4),G1(:,:,:,94))
  call check_last_A_Q(l_switch,G1(:,:,:,94),Q(:,63),MB,G2tensor(:,61))
  call loop_AV_Q(G1(:,:,:,93),wf(:,715),G1(:,:,:,95))
  call check_last_A_Q(l_switch,G1(:,:,:,95),Q(:,63),MB,G2tensor(:,62))
  call loop_AV_Q(G1(:,:,:,93),wf(:,724),G1(:,:,:,96))
  call check_last_A_Q(l_switch,G1(:,:,:,96),Q(:,63),MB,G2tensor(:,63))
  call loop_AV_Q(G1(:,:,:,93),wf(:,81),G1(:,:,:,97))
  call check_last_A_Q(l_switch,G1(:,:,:,97),Q(:,63),MB,G2tensor(:,64))
  call loop_AV_Q(G1(:,:,:,93),wf(:,751),G1(:,:,:,98))
  call check_last_A_Q(l_switch,G1(:,:,:,98),Q(:,63),MB,G2tensor(:,65))
  call loop_AV_Q(G1(:,:,:,93),wf(:,760),G1(:,:,:,99))
  call check_last_A_Q(l_switch,G1(:,:,:,99),Q(:,63),MB,G2tensor(:,66))
  call loop_AV_Q(G1(:,:,:,93),wf(:,787),G1(:,:,:,100))
  call check_last_A_Q(l_switch,G1(:,:,:,100),Q(:,63),MB,G2tensor(:,67))
  call loop_AV_Q(G1(:,:,:,93),wf(:,796),G1(:,:,:,101))
  call check_last_A_Q(l_switch,G1(:,:,:,101),Q(:,63),MB,G2tensor(:,68))
  call loop_AV_Q(G1(:,:,:,93),wf(:,823),G1(:,:,:,102))
  call check_last_A_Q(l_switch,G1(:,:,:,102),Q(:,63),MB,G2tensor(:,69))
  call loop_AV_Q(G1(:,:,:,93),wf(:,832),G1(:,:,:,103))
  call check_last_A_Q(l_switch,G1(:,:,:,103),Q(:,63),MB,G2tensor(:,70))
  call loop_SA_Q(G0(:,:,:,25),wf(:,297),G0(:,:,:,29),gX)
  call loop_A_Q(G0(:,:,:,29),Q(:,57),MB,G1(:,:,:,104))
  call loop_AV_Q(G1(:,:,:,104),wf(:,80),G1(:,:,:,105))
  call check_last_A_Q(l_switch,G1(:,:,:,105),Q(:,63),MB,G2tensor(:,71))
  call loop_SA_Q(G0(:,:,:,25),wf(:,303),G0(:,:,:,30),gX)
  call loop_A_Q(G0(:,:,:,30),Q(:,54),MB,G1(:,:,:,106))
  call loop_AV_Q(G1(:,:,:,106),wf(:,79),G1(:,:,:,107))
  call check_last_A_Q(l_switch,G1(:,:,:,107),Q(:,63),MB,G2tensor(:,72))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-4),G0(:,:,:,31),gPtb)
  call loop_SA_Q(G0(:,:,:,31),wf(:,216),G0(:,:,:,32),gPbt)
  call loop_A_Q(G0(:,:,:,32),Q(:,53),MT,G1(:,:,:,108))
  call loop_AV_Q(G1(:,:,:,108),wf(:,2),G1(:,:,:,109))
  call check_last_A_Q(l_switch,G1(:,:,:,109),Q(:,63),MT,G2tensor(:,73))
  call loop_SA_Q(G0(:,:,:,31),wf(:,222),G0(:,:,:,33),gPbt)
  call loop_A_Q(G0(:,:,:,33),Q(:,58),MT,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,1),G1(:,:,:,111))
  call check_last_A_Q(l_switch,G1(:,:,:,111),Q(:,63),MT,G2tensor(:,74))
  call loop_SA_Q(G0(:,:,:,31),wf(:,-5),G0(:,:,:,34),gPbt)
  call loop_A_Q(G0(:,:,:,34),Q(:,48),MT,G1(:,:,:,112))
  call loop_AV_Q(G1(:,:,:,112),wf(:,4),G1(:,:,:,113))
  call check_last_A_Q(l_switch,G1(:,:,:,113),Q(:,63),MT,G2tensor(:,75))
  call loop_AV_Q(G1(:,:,:,112),wf(:,715),G1(:,:,:,114))
  call check_last_A_Q(l_switch,G1(:,:,:,114),Q(:,63),MT,G2tensor(:,76))
  call loop_AV_Q(G1(:,:,:,112),wf(:,724),G1(:,:,:,115))
  call check_last_A_Q(l_switch,G1(:,:,:,115),Q(:,63),MT,G2tensor(:,77))
  call loop_AV_Q(G1(:,:,:,112),wf(:,81),G1(:,:,:,116))
  call check_last_A_Q(l_switch,G1(:,:,:,116),Q(:,63),MT,G2tensor(:,78))
  call loop_AV_Q(G1(:,:,:,112),wf(:,751),G1(:,:,:,117))
  call check_last_A_Q(l_switch,G1(:,:,:,117),Q(:,63),MT,G2tensor(:,79))
  call loop_AV_Q(G1(:,:,:,112),wf(:,760),G1(:,:,:,118))
  call check_last_A_Q(l_switch,G1(:,:,:,118),Q(:,63),MT,G2tensor(:,80))
  call loop_AV_Q(G1(:,:,:,112),wf(:,787),G1(:,:,:,119))
  call check_last_A_Q(l_switch,G1(:,:,:,119),Q(:,63),MT,G2tensor(:,81))
  call loop_AV_Q(G1(:,:,:,112),wf(:,796),G1(:,:,:,120))
  call check_last_A_Q(l_switch,G1(:,:,:,120),Q(:,63),MT,G2tensor(:,82))
  call loop_AV_Q(G1(:,:,:,112),wf(:,823),G1(:,:,:,121))
  call check_last_A_Q(l_switch,G1(:,:,:,121),Q(:,63),MT,G2tensor(:,83))
  call loop_AV_Q(G1(:,:,:,112),wf(:,832),G1(:,:,:,122))
  call check_last_A_Q(l_switch,G1(:,:,:,122),Q(:,63),MT,G2tensor(:,84))
  call loop_SA_Q(G0(:,:,:,31),wf(:,297),G0(:,:,:,35),gPbt)
  call loop_A_Q(G0(:,:,:,35),Q(:,57),MT,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,80),G1(:,:,:,124))
  call check_last_A_Q(l_switch,G1(:,:,:,124),Q(:,63),MT,G2tensor(:,85))
  call loop_SA_Q(G0(:,:,:,31),wf(:,303),G0(:,:,:,36),gPbt)
  call loop_A_Q(G0(:,:,:,36),Q(:,54),MT,G1(:,:,:,125))
  call loop_AV_Q(G1(:,:,:,125),wf(:,79),G1(:,:,:,126))
  call check_last_A_Q(l_switch,G1(:,:,:,126),Q(:,63),MT,G2tensor(:,86))
  call loop_VA_Q(G0(:,:,:,1),wf(:,218),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,37),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,2),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,47),MB,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,-4),G2tensor(:,87))
  call loop_AQ_V(G1(:,:,:,127),wf(:,-4),G1(:,:,:,129))
  call loop_VA_Q(G1(:,:,:,129),wf(:,-3),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,61),MT,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,-1),G2tensor(:,88))
  call check_last_AQ_V(l_switch,G1(:,:,:,127),wf(:,25),G1tensor(:,9))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-4),G0(:,:,:,38),gZd)
  call loop_ZA_Q(G0(:,:,:,38),wf(:,216),G0(:,:,:,39),gZd)
  call loop_A_Q(G0(:,:,:,39),Q(:,53),MB,G1(:,:,:,131))
  call loop_AV_Q(G1(:,:,:,131),wf(:,2),G1(:,:,:,132))
  call check_last_A_Q(l_switch,G1(:,:,:,132),Q(:,63),MB,G2tensor(:,89))
  call loop_ZA_Q(G0(:,:,:,38),wf(:,222),G0(:,:,:,40),gZd)
  call loop_A_Q(G0(:,:,:,40),Q(:,58),MB,G1(:,:,:,133))
  call loop_AV_Q(G1(:,:,:,133),wf(:,1),G1(:,:,:,134))
  call check_last_A_Q(l_switch,G1(:,:,:,134),Q(:,63),MB,G2tensor(:,90))
  call loop_ZA_Q(G0(:,:,:,38),wf(:,-5),G0(:,:,:,41),gZd)
  call loop_A_Q(G0(:,:,:,41),Q(:,48),MB,G1(:,:,:,135))
  call loop_AV_Q(G1(:,:,:,135),wf(:,4),G1(:,:,:,136))
  call check_last_A_Q(l_switch,G1(:,:,:,136),Q(:,63),MB,G2tensor(:,91))
  call loop_AV_Q(G1(:,:,:,135),wf(:,715),G1(:,:,:,137))
  call check_last_A_Q(l_switch,G1(:,:,:,137),Q(:,63),MB,G2tensor(:,92))
  call loop_AV_Q(G1(:,:,:,135),wf(:,724),G1(:,:,:,138))
  call check_last_A_Q(l_switch,G1(:,:,:,138),Q(:,63),MB,G2tensor(:,93))
  call loop_AV_Q(G1(:,:,:,135),wf(:,81),G1(:,:,:,139))
  call check_last_A_Q(l_switch,G1(:,:,:,139),Q(:,63),MB,G2tensor(:,94))
  call loop_AV_Q(G1(:,:,:,135),wf(:,751),G1(:,:,:,140))
  call check_last_A_Q(l_switch,G1(:,:,:,140),Q(:,63),MB,G2tensor(:,95))
  call loop_AV_Q(G1(:,:,:,135),wf(:,760),G1(:,:,:,141))
  call check_last_A_Q(l_switch,G1(:,:,:,141),Q(:,63),MB,G2tensor(:,96))
  call loop_AV_Q(G1(:,:,:,135),wf(:,787),G1(:,:,:,142))
  call check_last_A_Q(l_switch,G1(:,:,:,142),Q(:,63),MB,G2tensor(:,97))
  call loop_AV_Q(G1(:,:,:,135),wf(:,796),G1(:,:,:,143))
  call check_last_A_Q(l_switch,G1(:,:,:,143),Q(:,63),MB,G2tensor(:,98))
  call loop_AV_Q(G1(:,:,:,135),wf(:,823),G1(:,:,:,144))
  call check_last_A_Q(l_switch,G1(:,:,:,144),Q(:,63),MB,G2tensor(:,99))
  call loop_AV_Q(G1(:,:,:,135),wf(:,832),G1(:,:,:,145))
  call check_last_A_Q(l_switch,G1(:,:,:,145),Q(:,63),MB,G2tensor(:,100))
  call loop_ZA_Q(G0(:,:,:,38),wf(:,297),G0(:,:,:,42),gZd)
  call loop_A_Q(G0(:,:,:,42),Q(:,57),MB,G1(:,:,:,146))
  call loop_AV_Q(G1(:,:,:,146),wf(:,80),G1(:,:,:,147))
  call check_last_A_Q(l_switch,G1(:,:,:,147),Q(:,63),MB,G2tensor(:,101))
  call loop_ZA_Q(G0(:,:,:,38),wf(:,303),G0(:,:,:,43),gZd)
  call loop_A_Q(G0(:,:,:,43),Q(:,54),MB,G1(:,:,:,148))
  call loop_AV_Q(G1(:,:,:,148),wf(:,79),G1(:,:,:,149))
  call check_last_A_Q(l_switch,G1(:,:,:,149),Q(:,63),MB,G2tensor(:,102))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-4),G0(:,:,:,44))
  call loop_WA_Q(G0(:,:,:,44),wf(:,216),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,53),MT,G1(:,:,:,150))
  call loop_AV_Q(G1(:,:,:,150),wf(:,2),G1(:,:,:,151))
  call check_last_A_Q(l_switch,G1(:,:,:,151),Q(:,63),MT,G2tensor(:,103))
  call loop_WA_Q(G0(:,:,:,44),wf(:,222),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,58),MT,G1(:,:,:,152))
  call loop_AV_Q(G1(:,:,:,152),wf(:,1),G1(:,:,:,153))
  call check_last_A_Q(l_switch,G1(:,:,:,153),Q(:,63),MT,G2tensor(:,104))
  call loop_WA_Q(G0(:,:,:,44),wf(:,-5),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,48),MT,G1(:,:,:,154))
  call loop_AV_Q(G1(:,:,:,154),wf(:,4),G1(:,:,:,155))
  call check_last_A_Q(l_switch,G1(:,:,:,155),Q(:,63),MT,G2tensor(:,105))
  call loop_AV_Q(G1(:,:,:,154),wf(:,715),G1(:,:,:,156))
  call check_last_A_Q(l_switch,G1(:,:,:,156),Q(:,63),MT,G2tensor(:,106))
  call loop_AV_Q(G1(:,:,:,154),wf(:,724),G1(:,:,:,157))
  call check_last_A_Q(l_switch,G1(:,:,:,157),Q(:,63),MT,G2tensor(:,107))
  call loop_AV_Q(G1(:,:,:,154),wf(:,81),G1(:,:,:,158))
  call check_last_A_Q(l_switch,G1(:,:,:,158),Q(:,63),MT,G2tensor(:,108))
  call loop_AV_Q(G1(:,:,:,154),wf(:,751),G1(:,:,:,159))
  call check_last_A_Q(l_switch,G1(:,:,:,159),Q(:,63),MT,G2tensor(:,109))
  call loop_AV_Q(G1(:,:,:,154),wf(:,760),G1(:,:,:,160))
  call check_last_A_Q(l_switch,G1(:,:,:,160),Q(:,63),MT,G2tensor(:,110))
  call loop_AV_Q(G1(:,:,:,154),wf(:,787),G1(:,:,:,161))
  call check_last_A_Q(l_switch,G1(:,:,:,161),Q(:,63),MT,G2tensor(:,111))
  call loop_AV_Q(G1(:,:,:,154),wf(:,796),G1(:,:,:,162))
  call check_last_A_Q(l_switch,G1(:,:,:,162),Q(:,63),MT,G2tensor(:,112))
  call loop_AV_Q(G1(:,:,:,154),wf(:,823),G1(:,:,:,163))
  call check_last_A_Q(l_switch,G1(:,:,:,163),Q(:,63),MT,G2tensor(:,113))
  call loop_AV_Q(G1(:,:,:,154),wf(:,832),G1(:,:,:,164))
  call check_last_A_Q(l_switch,G1(:,:,:,164),Q(:,63),MT,G2tensor(:,114))
  call loop_WA_Q(G0(:,:,:,44),wf(:,297),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,57),MT,G1(:,:,:,165))
  call loop_AV_Q(G1(:,:,:,165),wf(:,80),G1(:,:,:,166))
  call check_last_A_Q(l_switch,G1(:,:,:,166),Q(:,63),MT,G2tensor(:,115))
  call loop_WA_Q(G0(:,:,:,44),wf(:,303),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,54),MT,G1(:,:,:,167))
  call loop_AV_Q(G1(:,:,:,167),wf(:,79),G1(:,:,:,168))
  call check_last_A_Q(l_switch,G1(:,:,:,168),Q(:,63),MT,G2tensor(:,116))
  call loop_VQ_A(G0(:,:,:,1),wf(:,29),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,26),MB,G1(:,:,:,169))
  call loop_QA_V(G1(:,:,:,169),wf(:,-5),G1(:,:,:,170))
  call check_last_UV_W(l_switch,G1(:,:,:,170),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,117))
  call loop_VA_Q(G1(:,:,:,170),wf(:,-2),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,62),MT,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,118))
  call loop_VQ_A(G0(:,:,:,1),wf(:,31),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,26),MB,G1(:,:,:,172))
  call loop_QA_V(G1(:,:,:,172),wf(:,-5),G1(:,:,:,173))
  call check_last_UV_W(l_switch,G1(:,:,:,173),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,119))
  call loop_VA_Q(G1(:,:,:,173),wf(:,-2),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,62),MT,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,0),G2tensor(:,120))
  call loop_AQ_S(G0(:,:,:,1),wf(:,25),G0(:,:,:,52),gH)
  call loop_SA_Q(G0(:,:,:,52),wf(:,-5),G0(:,:,:,53),gH)
  call loop_A_Q(G0(:,:,:,53),Q(:,58),MB,G1(:,:,:,175))
  call loop_AV_Q(G1(:,:,:,175),wf(:,1),G1(:,:,:,176))
  call check_last_A_Q(l_switch,G1(:,:,:,176),Q(:,63),MB,G2tensor(:,121))
  call loop_AQ_S(G0(:,:,:,1),wf(:,25),G0(:,:,:,54),gX)
  call loop_SA_Q(G0(:,:,:,54),wf(:,-5),G0(:,:,:,55),gX)
  call loop_A_Q(G0(:,:,:,55),Q(:,58),MB,G1(:,:,:,177))
  call loop_AV_Q(G1(:,:,:,177),wf(:,1),G1(:,:,:,178))
  call check_last_A_Q(l_switch,G1(:,:,:,178),Q(:,63),MB,G2tensor(:,122))
  call loop_AQ_S(G0(:,:,:,1),wf(:,25),G0(:,:,:,56),gPtb)
  call loop_SA_Q(G0(:,:,:,56),wf(:,-5),G0(:,:,:,57),gPbt)
  call loop_A_Q(G0(:,:,:,57),Q(:,58),MT,G1(:,:,:,179))
  call loop_AV_Q(G1(:,:,:,179),wf(:,1),G1(:,:,:,180))
  call check_last_A_Q(l_switch,G1(:,:,:,180),Q(:,63),MT,G2tensor(:,123))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,25),G0(:,:,:,58),gZd)
  call loop_ZA_Q(G0(:,:,:,58),wf(:,-5),G0(:,:,:,59),gZd)
  call loop_A_Q(G0(:,:,:,59),Q(:,58),MB,G1(:,:,:,181))
  call loop_AV_Q(G1(:,:,:,181),wf(:,1),G1(:,:,:,182))
  call check_last_A_Q(l_switch,G1(:,:,:,182),Q(:,63),MB,G2tensor(:,124))
  call loop_AQ_W(G0(:,:,:,1),wf(:,25),G0(:,:,:,60))
  call loop_WA_Q(G0(:,:,:,60),wf(:,-5),G0(:,:,:,61))
  call loop_A_Q(G0(:,:,:,61),Q(:,58),MT,G1(:,:,:,183))
  call loop_AV_Q(G1(:,:,:,183),wf(:,1),G1(:,:,:,184))
  call check_last_A_Q(l_switch,G1(:,:,:,184),Q(:,63),MT,G2tensor(:,125))
  call loop_VQ_A(G0(:,:,:,1),wf(:,25),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,26),MB,G1(:,:,:,185))
  call loop_QA_V(G1(:,:,:,185),wf(:,-5),G1(:,:,:,186))
  call check_last_UV_W(l_switch,G1(:,:,:,186),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,126))
  call loop_VA_Q(G1(:,:,:,186),wf(:,-2),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,62),MT,G2(:,:,:,40))
  call check_last_AQ_V(l_switch,G2(:,:,:,40),wf(:,0),G2tensor(:,127))
  call loop_QS_A(G1(:,:,:,185),wf(:,118),G1(:,:,:,188),gPtb)
  call loop_Q_A(G1(:,:,:,188),Q(:,59),MT,G2(:,:,:,41))
  call check_last_QA_V(l_switch,G2(:,:,:,41),wf(:,-2),G2tensor(:,128))
  call loop_QW_A(G1(:,:,:,185),wf(:,121),G1(:,:,:,189))
  call loop_Q_A(G1(:,:,:,189),Q(:,59),MT,G2(:,:,:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,42),wf(:,-2),G2tensor(:,129))
  call loop_QA_S(G1(:,:,:,185),wf(:,-5),G1(:,:,:,190),gH)
  call loop_SQ_A(G1(:,:,:,190),wf(:,0),G1(:,:,:,191),gH)
  call loop_Q_A(G1(:,:,:,191),Q(:,59),MT,G2(:,:,:,43))
  call check_last_QA_V(l_switch,G2(:,:,:,43),wf(:,-2),G2tensor(:,130))
  call loop_SA_Q(G1(:,:,:,190),wf(:,-2),G1(:,:,:,192),gH)
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,131))
  call loop_QA_S(G1(:,:,:,185),wf(:,-5),G1(:,:,:,193),gX)
  call loop_SQ_A(G1(:,:,:,193),wf(:,0),G1(:,:,:,194),gX)
  call loop_Q_A(G1(:,:,:,194),Q(:,59),MT,G2(:,:,:,45))
  call check_last_QA_V(l_switch,G2(:,:,:,45),wf(:,-2),G2tensor(:,132))
  call loop_SA_Q(G1(:,:,:,193),wf(:,-2),G1(:,:,:,195),gX)
  call loop_A_Q(G1(:,:,:,195),Q(:,62),MT,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,0),G2tensor(:,133))
  call loop_QA_Z(G1(:,:,:,185),wf(:,-5),G1(:,:,:,196),gZd)
  call loop_ZQ_A(G1(:,:,:,196),wf(:,0),G1(:,:,:,197),gZu)
  call loop_Q_A(G1(:,:,:,197),Q(:,59),MT,G2(:,:,:,47))
  call check_last_QA_V(l_switch,G2(:,:,:,47),wf(:,-2),G2tensor(:,134))
  call loop_ZA_Q(G1(:,:,:,196),wf(:,-2),G1(:,:,:,198),gZu)
  call loop_A_Q(G1(:,:,:,198),Q(:,62),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,0),G2tensor(:,135))
  call loop_QA_S(G1(:,:,:,185),wf(:,-2),G1(:,:,:,199),gPtb)
  call loop_SA_Q(G1(:,:,:,199),wf(:,-5),G1(:,:,:,200),gPbt)
  call loop_A_Q(G1(:,:,:,200),Q(:,62),MT,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,0),G2tensor(:,136))
  call loop_QA_W(G1(:,:,:,185),wf(:,-2),G1(:,:,:,201))
  call loop_WA_Q(G1(:,:,:,201),wf(:,-5),G1(:,:,:,202))
  call loop_A_Q(G1(:,:,:,202),Q(:,62),MT,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,137))
  call loop_VQ_A(G0(:,:,:,1),wf(:,34),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,26),MB,G1(:,:,:,203))
  call loop_QA_V(G1(:,:,:,203),wf(:,-5),G1(:,:,:,204))
  call check_last_UV_W(l_switch,G1(:,:,:,204),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,138))
  call loop_VA_Q(G1(:,:,:,204),wf(:,-2),G1(:,:,:,205))
  call loop_A_Q(G1(:,:,:,205),Q(:,62),MT,G2(:,:,:,51))
  call check_last_AQ_V(l_switch,G2(:,:,:,51),wf(:,0),G2tensor(:,139))
  call loop_VA_Q(G0(:,:,:,1),wf(:,222),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,42),MB,G1(:,:,:,206))
  call loop_AS_Q(G1(:,:,:,206),wf(:,5),G1(:,:,:,207),gH)
  call loop_A_Q(G1(:,:,:,207),Q(:,47),MB,G2(:,:,:,52))
  call check_last_AQ_V(l_switch,G2(:,:,:,52),wf(:,-4),G2tensor(:,140))
  call loop_AS_Q(G1(:,:,:,206),wf(:,9),G1(:,:,:,208),gX)
  call loop_A_Q(G1(:,:,:,208),Q(:,47),MB,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,-4),G2tensor(:,141))
  call loop_AV_Q(G1(:,:,:,206),wf(:,1),G1(:,:,:,209))
  call loop_A_Q(G1(:,:,:,209),Q(:,47),MB,G2(:,:,:,54))
  call check_last_AQ_V(l_switch,G2(:,:,:,54),wf(:,-4),G2tensor(:,142))
  call loop_AZ_Q(G1(:,:,:,206),wf(:,18),G1(:,:,:,210),gZd)
  call loop_A_Q(G1(:,:,:,210),Q(:,47),MB,G2(:,:,:,55))
  call check_last_AQ_V(l_switch,G2(:,:,:,55),wf(:,-4),G2tensor(:,143))
  call loop_AS_Q(G1(:,:,:,206),wf(:,145),G1(:,:,:,211),gPbt)
  call loop_A_Q(G1(:,:,:,211),Q(:,62),MT,G2(:,:,:,56))
  call check_last_AQ_V(l_switch,G2(:,:,:,56),wf(:,0),G2tensor(:,144))
  call loop_AW_Q(G1(:,:,:,206),wf(:,149),G1(:,:,:,212))
  call loop_A_Q(G1(:,:,:,212),Q(:,62),MT,G2(:,:,:,57))
  call check_last_AQ_V(l_switch,G2(:,:,:,57),wf(:,0),G2tensor(:,145))
  call loop_AQ_S(G1(:,:,:,206),wf(:,-4),G1(:,:,:,213),gH)
  call loop_SQ_A(G1(:,:,:,213),wf(:,0),G1(:,:,:,214),gH)
  call loop_Q_A(G1(:,:,:,214),Q(:,59),MT,G2(:,:,:,58))
  call check_last_QA_V(l_switch,G2(:,:,:,58),wf(:,-2),G2tensor(:,146))
  call loop_SA_Q(G1(:,:,:,213),wf(:,-2),G1(:,:,:,215),gH)
  call loop_A_Q(G1(:,:,:,215),Q(:,62),MT,G2(:,:,:,59))
  call check_last_AQ_V(l_switch,G2(:,:,:,59),wf(:,0),G2tensor(:,147))
  call loop_AQ_S(G1(:,:,:,206),wf(:,-4),G1(:,:,:,216),gX)
  call loop_SQ_A(G1(:,:,:,216),wf(:,0),G1(:,:,:,217),gX)
  call loop_Q_A(G1(:,:,:,217),Q(:,59),MT,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,-2),G2tensor(:,148))
  call loop_SA_Q(G1(:,:,:,216),wf(:,-2),G1(:,:,:,218),gX)
  call loop_A_Q(G1(:,:,:,218),Q(:,62),MT,G2(:,:,:,61))
  call check_last_AQ_V(l_switch,G2(:,:,:,61),wf(:,0),G2tensor(:,149))
  call loop_AQ_Z(G1(:,:,:,206),wf(:,-4),G1(:,:,:,219),gZd)
  call loop_ZQ_A(G1(:,:,:,219),wf(:,0),G1(:,:,:,220),gZu)
  call loop_Q_A(G1(:,:,:,220),Q(:,59),MT,G2(:,:,:,62))
  call check_last_QA_V(l_switch,G2(:,:,:,62),wf(:,-2),G2tensor(:,150))
  call loop_ZA_Q(G1(:,:,:,219),wf(:,-2),G1(:,:,:,221),gZu)
  call loop_A_Q(G1(:,:,:,221),Q(:,62),MT,G2(:,:,:,63))
  call check_last_AQ_V(l_switch,G2(:,:,:,63),wf(:,0),G2tensor(:,151))
  call loop_AQ_S(G1(:,:,:,206),wf(:,0),G1(:,:,:,222),gPbt)
  call loop_SA_Q(G1(:,:,:,222),wf(:,-2),G1(:,:,:,223),gPtb)
  call loop_A_Q(G1(:,:,:,223),Q(:,47),MB,G2(:,:,:,64))
  call check_last_AQ_V(l_switch,G2(:,:,:,64),wf(:,-4),G2tensor(:,152))
  call loop_SQ_A(G1(:,:,:,222),wf(:,-4),G1(:,:,:,224),gPtb)
  call loop_Q_A(G1(:,:,:,224),Q(:,59),MT,G2(:,:,:,65))
  call check_last_QA_V(l_switch,G2(:,:,:,65),wf(:,-2),G2tensor(:,153))
  call loop_AQ_V(G1(:,:,:,206),wf(:,-4),G1(:,:,:,225))
  call loop_VA_Q(G1(:,:,:,225),wf(:,-2),G1(:,:,:,226))
  call loop_A_Q(G1(:,:,:,226),Q(:,62),MT,G2(:,:,:,66))
  call check_last_AQ_V(l_switch,G2(:,:,:,66),wf(:,0),G2tensor(:,154))
  call loop_AQ_W(G1(:,:,:,206),wf(:,0),G1(:,:,:,227))
  call loop_WA_Q(G1(:,:,:,227),wf(:,-2),G1(:,:,:,228))
  call loop_A_Q(G1(:,:,:,228),Q(:,47),MB,G2(:,:,:,67))
  call check_last_AQ_V(l_switch,G2(:,:,:,67),wf(:,-4),G2tensor(:,155))
  call loop_WQ_A(G1(:,:,:,227),wf(:,-4),G1(:,:,:,229))
  call loop_Q_A(G1(:,:,:,229),Q(:,59),MT,G2(:,:,:,68))
  call check_last_QA_V(l_switch,G2(:,:,:,68),wf(:,-2),G2tensor(:,156))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,8),G1tensor(:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,11),G1tensor(:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,15),G1tensor(:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,20),G1tensor(:,13))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,177),G1tensor(:,14))
  call check_last_AQ_V(l_switch,G1(:,:,:,206),wf(:,179),G1tensor(:,15))
  call loop_VA_Q(G0(:,:,:,1),wf(:,225),G0(:,:,:,65))
  call loop_A_Q(G0(:,:,:,65),Q(:,42),MB,G1(:,:,:,230))
  call loop_AV_Q(G1(:,:,:,230),wf(:,1),G1(:,:,:,231))
  call loop_A_Q(G1(:,:,:,231),Q(:,47),MB,G2(:,:,:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,69),wf(:,-4),G2tensor(:,157))
  call loop_AQ_V(G1(:,:,:,230),wf(:,-4),G1(:,:,:,232))
  call loop_VA_Q(G1(:,:,:,232),wf(:,-2),G1(:,:,:,233))
  call loop_A_Q(G1(:,:,:,233),Q(:,62),MT,G2(:,:,:,70))
  call check_last_AQ_V(l_switch,G2(:,:,:,70),wf(:,0),G2tensor(:,158))
  call check_last_AQ_V(l_switch,G1(:,:,:,230),wf(:,15),G1tensor(:,16))
  call loop_VA_Q(G0(:,:,:,1),wf(:,226),G0(:,:,:,66))
  call loop_A_Q(G0(:,:,:,66),Q(:,42),MB,G1(:,:,:,234))
  call loop_AV_Q(G1(:,:,:,234),wf(:,1),G1(:,:,:,235))
  call loop_A_Q(G1(:,:,:,235),Q(:,47),MB,G2(:,:,:,71))
  call check_last_AQ_V(l_switch,G2(:,:,:,71),wf(:,-4),G2tensor(:,159))
  call loop_AQ_V(G1(:,:,:,234),wf(:,-4),G1(:,:,:,236))
  call loop_VA_Q(G1(:,:,:,236),wf(:,-2),G1(:,:,:,237))
  call loop_A_Q(G1(:,:,:,237),Q(:,62),MT,G2(:,:,:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,72),wf(:,0),G2tensor(:,160))
  call check_last_AQ_V(l_switch,G1(:,:,:,234),wf(:,15),G1tensor(:,17))
  call loop_VA_Q(G0(:,:,:,1),wf(:,228),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,42),MB,G1(:,:,:,238))
  call loop_AV_Q(G1(:,:,:,238),wf(:,1),G1(:,:,:,239))
  call loop_A_Q(G1(:,:,:,239),Q(:,47),MB,G2(:,:,:,73))
  call check_last_AQ_V(l_switch,G2(:,:,:,73),wf(:,-4),G2tensor(:,161))
  call loop_AQ_V(G1(:,:,:,238),wf(:,-4),G1(:,:,:,240))
  call loop_VA_Q(G1(:,:,:,240),wf(:,-2),G1(:,:,:,241))
  call loop_A_Q(G1(:,:,:,241),Q(:,62),MT,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,162))
  call check_last_AQ_V(l_switch,G1(:,:,:,238),wf(:,15),G1tensor(:,18))
  call loop_VQ_A(G0(:,:,:,1),wf(:,42),G0(:,:,:,68))
  call loop_Q_A(G0(:,:,:,68),Q(:,26),MB,G1(:,:,:,242))
  call loop_QA_V(G1(:,:,:,242),wf(:,-5),G1(:,:,:,243))
  call check_last_UV_W(l_switch,G1(:,:,:,243),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,163))
  call loop_VA_Q(G1(:,:,:,243),wf(:,-2),G1(:,:,:,244))
  call loop_A_Q(G1(:,:,:,244),Q(:,62),MT,G2(:,:,:,75))
  call check_last_AQ_V(l_switch,G2(:,:,:,75),wf(:,0),G2tensor(:,164))
  call loop_VQ_A(G0(:,:,:,1),wf(:,44),G0(:,:,:,69))
  call loop_Q_A(G0(:,:,:,69),Q(:,26),MB,G1(:,:,:,245))
  call loop_QA_V(G1(:,:,:,245),wf(:,-5),G1(:,:,:,246))
  call check_last_UV_W(l_switch,G1(:,:,:,246),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,165))
  call loop_VA_Q(G1(:,:,:,246),wf(:,-2),G1(:,:,:,247))
  call loop_A_Q(G1(:,:,:,247),Q(:,62),MT,G2(:,:,:,76))
  call check_last_AQ_V(l_switch,G2(:,:,:,76),wf(:,0),G2tensor(:,166))
  call loop_VA_Q(G0(:,:,:,1),wf(:,377),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,56),MT,G1(:,:,:,248))
  call loop_AV_Q(G1(:,:,:,248),wf(:,1),G1(:,:,:,249))
  call loop_A_Q(G1(:,:,:,249),Q(:,61),MT,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,-1),G2tensor(:,167))
  call loop_AV_Q(G1(:,:,:,248),wf(:,80),G1(:,:,:,250))
  call loop_A_Q(G1(:,:,:,250),Q(:,62),MT,G2(:,:,:,78))
  call check_last_AQ_V(l_switch,G2(:,:,:,78),wf(:,0),G2tensor(:,168))
  call loop_AQ_V(G1(:,:,:,248),wf(:,-1),G1(:,:,:,251))
  call loop_VA_Q(G1(:,:,:,251),wf(:,-2),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,62),MT,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,169))
  call check_last_AQ_V(l_switch,G1(:,:,:,248),wf(:,38),G1tensor(:,19))
  call check_last_AQ_V(l_switch,G1(:,:,:,248),wf(:,113),G1tensor(:,20))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,1),Q(:,5),G1(:,:,:,253))
  call loop_VA_Q(G1(:,:,:,253),wf(:,377),G1(:,:,:,254))
  call loop_A_Q(G1(:,:,:,254),Q(:,61),MT,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,-1),G2tensor(:,170))
  call loop_VA_Q(G1(:,:,:,253),wf(:,378),G1(:,:,:,255))
  call loop_A_Q(G1(:,:,:,255),Q(:,61),MT,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,-1),G2tensor(:,171))
  call loop_VA_Q(G1(:,:,:,253),wf(:,-5),G1(:,:,:,256))
  call loop_A_Q(G1(:,:,:,256),Q(:,37),MB,G2(:,:,:,82))
  call loop_AS_Q(G2(:,:,:,82),wf(:,35),G2(:,:,:,83),gPbt)
  call loop_A_Q(G2(:,:,:,83),Q(:,61),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-1),G3tensor(:,1))
  call loop_AW_Q(G2(:,:,:,82),wf(:,39),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,61),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-1),G3tensor(:,2))
  call loop_AQ_S(G2(:,:,:,82),wf(:,-4),G2(:,:,:,85),gH)
  call loop_SA_Q(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86),gH)
  call loop_A_Q(G2(:,:,:,86),Q(:,61),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-1),G3tensor(:,3))
  call loop_AQ_S(G2(:,:,:,82),wf(:,-4),G2(:,:,:,87),gX)
  call loop_SA_Q(G2(:,:,:,87),wf(:,-3),G2(:,:,:,88),gX)
  call loop_A_Q(G2(:,:,:,88),Q(:,61),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-1),G3tensor(:,4))
  call loop_AQ_V(G2(:,:,:,82),wf(:,-4),G2(:,:,:,89))
  call loop_VA_Q(G2(:,:,:,89),wf(:,-3),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,61),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,-1),G3tensor(:,5))
  call loop_AQ_Z(G2(:,:,:,82),wf(:,-4),G2(:,:,:,91),gZd)
  call loop_ZA_Q(G2(:,:,:,91),wf(:,-3),G2(:,:,:,92),gZu)
  call loop_A_Q(G2(:,:,:,92),Q(:,61),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,6))
  call loop_VA_Q(G1(:,:,:,253),wf(:,390),G1(:,:,:,257))
  call loop_A_Q(G1(:,:,:,257),Q(:,61),MT,G2(:,:,:,93))
  call check_last_AQ_V(l_switch,G2(:,:,:,93),wf(:,-1),G2tensor(:,172))
  call loop_VA_Q(G1(:,:,:,253),wf(:,391),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,61),MT,G2(:,:,:,94))
  call check_last_AQ_V(l_switch,G2(:,:,:,94),wf(:,-1),G2tensor(:,173))
  call loop_VA_Q(G1(:,:,:,253),wf(:,388),G1(:,:,:,259))
  call loop_A_Q(G1(:,:,:,259),Q(:,61),MT,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,-1),G2tensor(:,174))
  call loop_VA_Q(G1(:,:,:,253),wf(:,393),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,61),MT,G2(:,:,:,96))
  call check_last_AQ_V(l_switch,G2(:,:,:,96),wf(:,-1),G2tensor(:,175))
  call loop_UV_W(G1(:,:,:,253),Q(:,5),wf(:,3),Q(:,48),G2(:,:,:,97))
  call loop_VA_Q(G2(:,:,:,97),wf(:,-3),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,61),MT,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,7))
  call loop_VA_Q(G1(:,:,:,253),wf(:,-3),G1(:,:,:,261))
  call loop_A_Q(G1(:,:,:,261),Q(:,13),MT,G2(:,:,:,99))
  call loop_AS_Q(G2(:,:,:,99),wf(:,60),G2(:,:,:,100),gH)
  call loop_A_Q(G2(:,:,:,100),Q(:,61),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,-1),G3tensor(:,8))
  call loop_AS_Q(G2(:,:,:,99),wf(:,62),G2(:,:,:,101),gX)
  call loop_A_Q(G2(:,:,:,101),Q(:,61),MT,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,-1),G3tensor(:,9))
  call loop_AV_Q(G2(:,:,:,99),wf(:,3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,61),MT,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,-1),G3tensor(:,10))
  call loop_AZ_Q(G2(:,:,:,99),wf(:,66),G2(:,:,:,103),gZu)
  call loop_A_Q(G2(:,:,:,103),Q(:,61),MT,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,-1),G3tensor(:,11))
  call loop_AQ_S(G2(:,:,:,99),wf(:,-4),G2(:,:,:,104),gPtb)
  call loop_SA_Q(G2(:,:,:,104),wf(:,-5),G2(:,:,:,105),gPbt)
  call loop_A_Q(G2(:,:,:,105),Q(:,61),MT,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,-1),G3tensor(:,12))
  call loop_AQ_W(G2(:,:,:,99),wf(:,-4),G2(:,:,:,106))
  call loop_WA_Q(G2(:,:,:,106),wf(:,-5),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,61),MT,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-1),G3tensor(:,13))
  call loop_VQ_A(G1(:,:,:,253),wf(:,-4),G1(:,:,:,262))
  call loop_Q_A(G1(:,:,:,262),Q(:,21),MB,G2(:,:,:,108))
  call loop_QA_S(G2(:,:,:,108),wf(:,-5),G2(:,:,:,109),gH)
  call loop_SA_Q(G2(:,:,:,109),wf(:,-3),G2(:,:,:,110),gH)
  call loop_A_Q(G2(:,:,:,110),Q(:,61),MT,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,-1),G3tensor(:,14))
  call loop_QA_S(G2(:,:,:,108),wf(:,-5),G2(:,:,:,111),gX)
  call loop_SA_Q(G2(:,:,:,111),wf(:,-3),G2(:,:,:,112),gX)
  call loop_A_Q(G2(:,:,:,112),Q(:,61),MT,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,-1),G3tensor(:,15))
  call loop_QA_V(G2(:,:,:,108),wf(:,-5),G2(:,:,:,113))
  call loop_VA_Q(G2(:,:,:,113),wf(:,-3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,61),MT,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-1),G3tensor(:,16))
  call loop_QA_Z(G2(:,:,:,108),wf(:,-5),G2(:,:,:,115),gZd)
  call loop_ZA_Q(G2(:,:,:,115),wf(:,-3),G2(:,:,:,116),gZu)
  call loop_A_Q(G2(:,:,:,116),Q(:,61),MT,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,-1),G3tensor(:,17))
  call loop_QA_S(G2(:,:,:,108),wf(:,-3),G2(:,:,:,117),gPtb)
  call loop_SA_Q(G2(:,:,:,117),wf(:,-5),G2(:,:,:,118),gPbt)
  call loop_A_Q(G2(:,:,:,118),Q(:,61),MT,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-1),G3tensor(:,18))
  call loop_QA_W(G2(:,:,:,108),wf(:,-3),G2(:,:,:,119))
  call loop_WA_Q(G2(:,:,:,119),wf(:,-5),G2(:,:,:,120))
  call loop_A_Q(G2(:,:,:,120),Q(:,61),MT,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,-1),G3tensor(:,19))
  call loop_VA_Q(G0(:,:,:,1),wf(:,378),G0(:,:,:,71))
  call loop_A_Q(G0(:,:,:,71),Q(:,56),MT,G1(:,:,:,263))
  call loop_AV_Q(G1(:,:,:,263),wf(:,1),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,61),MT,G2(:,:,:,121))
  call check_last_AQ_V(l_switch,G2(:,:,:,121),wf(:,-1),G2tensor(:,176))
  call loop_AV_Q(G1(:,:,:,263),wf(:,80),G1(:,:,:,265))
  call loop_A_Q(G1(:,:,:,265),Q(:,62),MT,G2(:,:,:,122))
  call check_last_AQ_V(l_switch,G2(:,:,:,122),wf(:,0),G2tensor(:,177))
  call loop_AQ_V(G1(:,:,:,263),wf(:,-1),G1(:,:,:,266))
  call loop_VA_Q(G1(:,:,:,266),wf(:,-2),G1(:,:,:,267))
  call loop_A_Q(G1(:,:,:,267),Q(:,62),MT,G2(:,:,:,123))
  call check_last_AQ_V(l_switch,G2(:,:,:,123),wf(:,0),G2tensor(:,178))
  call check_last_AQ_V(l_switch,G1(:,:,:,263),wf(:,38),G1tensor(:,21))
  call check_last_AQ_V(l_switch,G1(:,:,:,263),wf(:,113),G1tensor(:,22))
  call loop_VA_Q(G0(:,:,:,1),wf(:,52),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,42),MB,G1(:,:,:,268))
  call loop_AV_Q(G1(:,:,:,268),wf(:,1),G1(:,:,:,269))
  call loop_A_Q(G1(:,:,:,269),Q(:,47),MB,G2(:,:,:,124))
  call check_last_AQ_V(l_switch,G2(:,:,:,124),wf(:,-4),G2tensor(:,179))
  call loop_AQ_V(G1(:,:,:,268),wf(:,-4),G1(:,:,:,270))
  call loop_VA_Q(G1(:,:,:,270),wf(:,-2),G1(:,:,:,271))
  call loop_A_Q(G1(:,:,:,271),Q(:,62),MT,G2(:,:,:,125))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,0),G2tensor(:,180))
  call check_last_AQ_V(l_switch,G1(:,:,:,268),wf(:,15),G1tensor(:,23))
  call loop_VA_Q(G0(:,:,:,1),wf(:,54),G0(:,:,:,73))
  call loop_A_Q(G0(:,:,:,73),Q(:,42),MB,G1(:,:,:,272))
  call loop_AV_Q(G1(:,:,:,272),wf(:,1),G1(:,:,:,273))
  call loop_A_Q(G1(:,:,:,273),Q(:,47),MB,G2(:,:,:,126))
  call check_last_AQ_V(l_switch,G2(:,:,:,126),wf(:,-4),G2tensor(:,181))
  call loop_AQ_V(G1(:,:,:,272),wf(:,-4),G1(:,:,:,274))
  call loop_VA_Q(G1(:,:,:,274),wf(:,-2),G1(:,:,:,275))
  call loop_A_Q(G1(:,:,:,275),Q(:,62),MT,G2(:,:,:,127))
  call check_last_AQ_V(l_switch,G2(:,:,:,127),wf(:,0),G2tensor(:,182))
  call check_last_AQ_V(l_switch,G1(:,:,:,272),wf(:,15),G1tensor(:,24))
  call loop_VQ_A(G0(:,:,:,1),wf(:,257),G0(:,:,:,74))
  call loop_Q_A(G0(:,:,:,74),Q(:,50),MT,G1(:,:,:,276))
  call loop_QV_A(G1(:,:,:,276),wf(:,1),G1(:,:,:,277))
  call loop_Q_A(G1(:,:,:,277),Q(:,55),MT,G2(:,:,:,128))
  call check_last_QA_V(l_switch,G2(:,:,:,128),wf(:,-3),G2tensor(:,183))
  call loop_QV_A(G1(:,:,:,276),wf(:,79),G1(:,:,:,278))
  call loop_Q_A(G1(:,:,:,278),Q(:,59),MT,G2(:,:,:,129))
  call check_last_QA_V(l_switch,G2(:,:,:,129),wf(:,-2),G2tensor(:,184))
  call loop_QA_V(G1(:,:,:,276),wf(:,-3),G1(:,:,:,279))
  call loop_VA_Q(G1(:,:,:,279),wf(:,-2),G1(:,:,:,280))
  call loop_A_Q(G1(:,:,:,280),Q(:,62),MT,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,0),G2tensor(:,185))
  call loop_QA_V(G1(:,:,:,276),wf(:,-2),G1(:,:,:,281))
  call loop_VA_Q(G1(:,:,:,281),wf(:,-3),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,62),MT,G2(:,:,:,131))
  call check_last_AQ_V(l_switch,G2(:,:,:,131),wf(:,0),G2tensor(:,186))
  call check_last_QA_V(l_switch,G1(:,:,:,276),wf(:,48),G1tensor(:,25))
  call check_last_QA_V(l_switch,G1(:,:,:,276),wf(:,156),G1tensor(:,26))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(104)*M(7))+c(103)*M(11)) * den(9)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(104)*M(7))+c(103)*M(11)) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(102)*M(5)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(18)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(102)*M(5))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(18)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(18)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(18)
  T2sum(1:15,9) = T2sum(1:15,9) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(18)
  T2sum(1:15,10) = T2sum(1:15,10) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(3)*M(7))+c(2)*M(11)) * den(18)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(7)*M(7)-c(6)*M(11)) * den(12)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(50)*M(6)+c(48)*(-M(2)-M(8))+c(47)*M(12)) * den(18)
  T2sum(1:15,7) = T2sum(1:15,7) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(167)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(108)*M(7))+c(107)*M(11)) * den(169)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(171)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(172)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(102)*M(3)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(173)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(102)*M(3))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(173)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(173)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(14)*M(7))+c(13)*M(11)) * den(173)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(36)*M(7)-c(35)*M(11)) * den(169)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(21)*M(1)-c(16)*M(11)) * den(173)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(172)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(10)*M(3))+c(9)*(M(1)+M(7))-c(8)*M(11)) * den(173)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(173)
  T2sum(1:15,14) = T2sum(1:15,14) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(173)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(59)*M(4)+c(56)*(-M(2)-M(8))+c(55)*M(12)) * den(173)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(104)*M(1))+c(103)*M(11)) * den(24)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,117)
  Gcoeff = (-(c(104)*M(1))+c(103)*M(11)) * den(26)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(102)*M(3)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(27)
  T2sum(1:15,18) = T2sum(1:15,18) + Gcoeff * G2tensor(:,121)
  Gcoeff = (-(c(102)*M(3))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(27)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(27)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,123)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(27)
  T2sum(1:15,19) = T2sum(1:15,19) + Gcoeff * G2tensor(:,124)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(27)
  T2sum(1:15,20) = T2sum(1:15,20) + Gcoeff * G2tensor(:,125)
  Gcoeff = (-(c(3)*M(1))+c(2)*M(11)) * den(27)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(7)*M(1)-c(6)*M(11)) * den(26)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,138)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(2)-M(8))+c(47)*M(12)) * den(27)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,126)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(175)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(176)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,141)
  Gcoeff = (-(c(108)*M(1))+c(107)*M(11)) * den(178)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,157)
  Gcoeff = (-(c(108)*M(1))+c(107)*M(11)) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,159)
  Gcoeff = (c(102)*M(5)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(181)
  T2sum(1:15,23) = T2sum(1:15,23) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(102)*M(5))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(181)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(181)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(21)*M(7)-c(16)*M(11)) * den(181)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,142)
  Gcoeff = (-(c(43)*M(7))+c(38)*M(11)) * den(176)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,143)
  Gcoeff = (-(c(14)*M(1))+c(13)*M(11)) * den(181)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(36)*M(1)-c(35)*M(11)) * den(180)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,161)
  Gcoeff = (-(c(10)*M(5))+c(9)*(M(1)+M(7))-c(8)*M(11)) * den(181)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,142)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(181)
  T2sum(1:15,24) = T2sum(1:15,24) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(181)
  T2sum(1:15,25) = T2sum(1:15,25) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(59)*M(6)+c(56)*(-M(2)-M(8))+c(55)*M(12)) * den(181)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(99)*(-M(3)+M(5))) * den(293)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(99)*(M(3)-M(5))) * den(293)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(85)*(M(3)-M(5))) * den(293)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(293)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(71)*(M(3)-M(5))) * den(293)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(97)*M(3)-c(92)*M(7)) * den(218)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(83)*M(3)-c(78)*M(7)) * den(218)
  T2sum(1:15,31) = T2sum(1:15,31) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(86)*M(3))+c(85)*M(7)) * den(33)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,163)
  Gcoeff = (-(c(72)*M(3))+c(71)*M(7)) * den(33)
  T2sum(1:15,17) = T2sum(1:15,17) + Gcoeff * G2tensor(:,165)
  Gcoeff = (-(c(90)*M(3))+c(89)*M(7)) * den(221)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,167)
  Gcoeff = (c(86)*M(3)-c(85)*M(7)) * den(221)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,170)
  Gcoeff = (-(c(76)*M(3))+c(75)*M(7)) * den(221)
  T2sum(1:15,32) = T2sum(1:15,32) + Gcoeff * G2tensor(:,176)
  Gcoeff = (c(72)*M(3)-c(71)*M(7)) * den(221)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,171)
  Gcoeff = (c(86)*M(3)-c(85)*M(7)) * den(647)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(72)*M(3)-c(71)*M(7)) * den(647)
  T3sum(1:35,18) = T3sum(1:35,18) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(97)*M(5)-c(92)*M(7)) * den(182)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(83)*M(5)-c(78)*M(7)) * den(182)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(90)*M(5))+c(89)*M(7)) * den(40)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,179)
  Gcoeff = (-(c(76)*M(5))+c(75)*M(7)) * den(40)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,181)
  Gcoeff = (-(c(90)*M(5))+c(89)*M(7)) * den(184)
  T2sum(1:15,36) = T2sum(1:15,36) + Gcoeff * G2tensor(:,183)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(233)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,172)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(235)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,173)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(236)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,174)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(235)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,175)
  Gcoeff = (-(c(50)*M(4))+c(48)*(M(8)+M(10))-c(47)*M(12)) * den(236)
  T2sum(1:15,33) = T2sum(1:15,33) + Gcoeff * G2tensor(:,174)
  Gcoeff = (-(c(69)*M(4))+c(64)*(-M(2)+M(8)+M(10))) * den(288)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(651)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(652)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(288)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(652)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(48)*M(2)-c(47)*M(12)) * den(288)
  T3sum(1:35,33) = T3sum(1:35,33) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(102)*M(3)+c(101)*(-M(7)-M(9))+c(100)*M(11)) * den(480)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(102)*M(3))+c(101)*(M(7)+M(9))-c(100)*M(11)) * den(480)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(7)+M(9))-c(89)*M(11)) * den(480)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(480)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(7)+M(9))-c(75)*M(11)) * den(480)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(102)*M(5)+c(101)*(-M(7)-M(9))+c(100)*M(11)) * den(487)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(102)*M(5))+c(101)*(M(7)+M(9))-c(100)*M(11)) * den(487)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(7)+M(9))-c(89)*M(11)) * den(487)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(487)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(7)+M(9))-c(75)*M(11)) * den(487)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(14)
  T2sum(1:15,89) = T2sum(1:15,89) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(14)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(14)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(109)*M(7))+c(112)*M(11)) * den(8)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(109)*M(7))+c(112)*M(11)) * den(11)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(14)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(14)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(15)*M(7))+c(18)*M(11)) * den(14)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(11)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(14)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(14)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(14)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(65)*M(2))+c(61)*M(6)-c(57)*M(8)+c(60)*M(12)) * den(14)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(5)-M(11))) * den(14)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(5)-M(11))) * den(14)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(170)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(170)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(170)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(114)*M(7)+c(107)*M(11)) * den(166)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(114)*M(7)+c(107)*M(11)) * den(168)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(170)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(170)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(20)*M(7)+c(13)*M(11)) * den(170)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(42)*M(7))-c(35)*M(11)) * den(168)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(170)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(170)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(170)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(56)*M(2))-c(67)*M(4)+c(62)*M(8)+c(55)*M(12)) * den(170)
  T2sum(1:15,107) = T2sum(1:15,107) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(93)*M(1)+c(89)*M(7)+c(90)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(79)*M(1)+c(75)*M(7)+c(76)*(-M(3)-M(11))) * den(170)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(103)*(M(3)-M(5))) * den(1)
  T3sum(1:35,55) = T3sum(1:35,55) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(103)*(M(3)-M(5))) * den(1)
  T3sum(1:35,56) = T3sum(1:35,56) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(2)*(M(3)-M(5))) * den(1)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(6)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,56) = T3sum(1:35,56) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(49)*M(4))-c(47)*M(6)+c(48)*M(8)) * den(1)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(103)*(M(3)-M(5))) * den(1)
  T3sum(1:35,58) = T3sum(1:35,58) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(103)*(M(3)-M(5))) * den(1)
  T3sum(1:35,59) = T3sum(1:35,59) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(2)*(M(3)-M(5))) * den(1)
  T3sum(1:35,60) = T3sum(1:35,60) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(6)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,59) = T3sum(1:35,59) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(47)*(M(4)-M(6))+c(48)*(M(2)-M(10))) * den(1)
  T3sum(1:35,60) = T3sum(1:35,60) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(85)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(71)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(85)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,77) = T3sum(1:35,77) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(71)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,77) = T3sum(1:35,77) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(102)*M(1))+c(101)*(M(3)+M(5))-c(100)*M(9)) * den(202)
  T2sum(1:15,123) = T2sum(1:15,123) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(102)*M(1)+c(101)*(-M(3)-M(5))+c(100)*M(9)) * den(202)
  T2sum(1:15,124) = T2sum(1:15,124) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(93)*M(1)+c(90)*(-M(3)-M(5))+c(89)*M(9)) * den(202)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(202)
  T2sum(1:15,124) = T2sum(1:15,124) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(79)*M(1)+c(76)*(-M(3)-M(5))+c(75)*M(9)) * den(202)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(101)*(M(3)+M(5))-c(102)*M(7)-c(100)*M(9)) * den(210)
  T2sum(1:15,133) = T2sum(1:15,133) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(101)*(-M(3)-M(5))+c(102)*M(7)+c(100)*M(9)) * den(210)
  T2sum(1:15,134) = T2sum(1:15,134) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(90)*(-M(3)-M(5))+c(93)*M(7)+c(89)*M(9)) * den(210)
  T2sum(1:15,135) = T2sum(1:15,135) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(210)
  T2sum(1:15,134) = T2sum(1:15,134) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(76)*(-M(3)-M(5))+c(79)*M(7)+c(75)*M(9)) * den(210)
  T2sum(1:15,135) = T2sum(1:15,135) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(99)*(-M(1)+M(7))) * den(358)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(99)*(M(1)-M(7))) * den(358)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(85)*(M(1)-M(7))) * den(358)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(6)*(M(1)-M(7))) * den(358)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(71)*(M(1)-M(7))) * den(358)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(89)*M(3))+c(90)*M(7)) * den(256)
  T2sum(1:15,137) = T2sum(1:15,137) + Gcoeff * G2tensor(:,168)
  Gcoeff = (-(c(75)*M(3))+c(76)*M(7)) * den(256)
  T2sum(1:15,137) = T2sum(1:15,137) + Gcoeff * G2tensor(:,177)
  Gcoeff = (-(c(102)*M(7))-c(100)*M(9)+c(101)*(M(3)+M(11))) * den(508)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(102)*M(7)+c(100)*M(9)+c(101)*(-M(3)-M(11))) * den(508)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(93)*M(7)+c(89)*M(9)+c(90)*(-M(3)-M(11))) * den(508)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(508)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(79)*M(7)+c(75)*M(9)+c(76)*(-M(3)-M(11))) * den(508)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(102)*M(1))-c(100)*M(9)+c(101)*(M(3)+M(11))) * den(514)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(102)*M(1)+c(100)*M(9)+c(101)*(-M(3)-M(11))) * den(514)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(93)*M(1)+c(89)*M(9)+c(90)*(-M(3)-M(11))) * den(514)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(514)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(79)*M(1)+c(75)*M(9)+c(76)*(-M(3)-M(11))) * den(514)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(89)*M(5))+c(90)*M(7)) * den(215)
  T2sum(1:15,206) = T2sum(1:15,206) + Gcoeff * G2tensor(:,184)
  Gcoeff = (-(c(102)*M(1))-c(100)*M(9)+c(101)*(M(5)+M(11))) * den(535)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(102)*M(1)+c(100)*M(9)+c(101)*(-M(5)-M(11))) * den(535)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(93)*M(1)+c(89)*M(9)+c(90)*(-M(5)-M(11))) * den(535)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(535)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(79)*M(1)+c(75)*M(9)+c(76)*(-M(5)-M(11))) * den(535)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(102)*M(7))-c(100)*M(9)+c(101)*(M(5)+M(11))) * den(542)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(102)*M(7)+c(100)*M(9)+c(101)*(-M(5)-M(11))) * den(542)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(93)*M(7)+c(89)*M(9)+c(90)*(-M(5)-M(11))) * den(542)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(542)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(79)*M(7)+c(75)*M(9)+c(76)*(-M(5)-M(11))) * den(542)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(92)*M(1))+c(97)*M(5)) * den(271)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,144)
  Gcoeff = (-(c(78)*M(1))+c(83)*M(5)) * den(271)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,145)
  Gcoeff = (-(c(92)*M(1))+c(97)*M(3)) * den(217)
  T2sum(1:15,271) = T2sum(1:15,271) + Gcoeff * G2tensor(:,128)
  Gcoeff = (-(c(78)*M(1))+c(83)*M(3)) * den(217)
  T2sum(1:15,271) = T2sum(1:15,271) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(102)*M(5)+c(101)*(-M(1)-M(9))+c(100)*M(11)) * den(562)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(102)*M(5))+c(101)*(M(1)+M(9))-c(100)*M(11)) * den(562)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(1)+M(9))-c(89)*M(11)) * den(562)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(562)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,99)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(1)+M(9))-c(75)*M(11)) * den(562)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(102)*M(3)+c(101)*(-M(1)-M(9))+c(100)*M(11)) * den(568)
  T2sum(1:15,26) = T2sum(1:15,26) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(102)*M(3))+c(101)*(M(1)+M(9))-c(100)*M(11)) * den(568)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(1)+M(9))-c(89)*M(11)) * den(568)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(568)
  T2sum(1:15,27) = T2sum(1:15,27) + Gcoeff * G2tensor(:,100)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(1)+M(9))-c(75)*M(11)) * den(568)
  T2sum(1:15,28) = T2sum(1:15,28) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(20)
  T2sum(1:15,283) = T2sum(1:15,283) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(20)
  T2sum(1:15,284) = T2sum(1:15,284) + Gcoeff * G2tensor(:,132)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(20)
  T2sum(1:15,284) = T2sum(1:15,284) + Gcoeff * G2tensor(:,134)
  Gcoeff = (-(c(109)*M(1))+c(112)*M(11)) * den(23)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(109)*M(1))+c(112)*M(11)) * den(25)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(20)
  T2sum(1:15,292) = T2sum(1:15,292) + Gcoeff * G2tensor(:,131)
  Gcoeff = (c(111)*M(3)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(20)
  T2sum(1:15,293) = T2sum(1:15,293) + Gcoeff * G2tensor(:,133)
  Gcoeff = (-(c(15)*M(1))+c(18)*M(11)) * den(20)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(37)*M(1)-c(40)*M(11)) * den(25)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,139)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(20)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(20)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,127)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(20)
  T2sum(1:15,293) = T2sum(1:15,293) + Gcoeff * G2tensor(:,135)
  Gcoeff = (-(c(57)*M(2))+c(61)*M(4)-c(65)*M(8)+c(60)*M(12)) * den(20)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(89)*M(1)+c(93)*M(7)+c(90)*(-M(3)-M(11))) * den(20)
  T2sum(1:15,295) = T2sum(1:15,295) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(75)*M(1)+c(79)*M(7)+c(76)*(-M(3)-M(11))) * den(20)
  T2sum(1:15,295) = T2sum(1:15,295) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(174)
  T2sum(1:15,297) = T2sum(1:15,297) + Gcoeff * G2tensor(:,146)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(174)
  T2sum(1:15,298) = T2sum(1:15,298) + Gcoeff * G2tensor(:,148)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(174)
  T2sum(1:15,298) = T2sum(1:15,298) + Gcoeff * G2tensor(:,150)
  Gcoeff = (c(114)*M(1)+c(107)*M(11)) * den(177)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,158)
  Gcoeff = (c(114)*M(1)+c(107)*M(11)) * den(179)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,160)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(174)
  T2sum(1:15,304) = T2sum(1:15,304) + Gcoeff * G2tensor(:,147)
  Gcoeff = (c(111)*M(5)+c(108)*(-M(1)-M(7))+c(107)*M(11)) * den(174)
  T2sum(1:15,305) = T2sum(1:15,305) + Gcoeff * G2tensor(:,149)
  Gcoeff = (c(89)*M(1)+c(93)*M(7)+c(90)*(-M(5)-M(11))) * den(174)
  T2sum(1:15,306) = T2sum(1:15,306) + Gcoeff * G2tensor(:,152)
  Gcoeff = (c(20)*M(1)+c(13)*M(11)) * den(174)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,154)
  Gcoeff = (-(c(42)*M(1))-c(35)*M(11)) * den(179)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,162)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(174)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,154)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(174)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,154)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(174)
  T2sum(1:15,305) = T2sum(1:15,305) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(62)*M(2)-c(67)*M(6)-c(56)*M(8)+c(55)*M(12)) * den(174)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,154)
  Gcoeff = (c(75)*M(1)+c(79)*M(7)+c(76)*(-M(5)-M(11))) * den(174)
  T2sum(1:15,306) = T2sum(1:15,306) + Gcoeff * G2tensor(:,155)
  Gcoeff = (c(89)*M(1)+c(93)*M(7)+c(90)*(-M(5)-M(11))) * den(174)
  T2sum(1:15,308) = T2sum(1:15,308) + Gcoeff * G2tensor(:,153)
  Gcoeff = (c(75)*M(1)+c(79)*M(7)+c(76)*(-M(5)-M(11))) * den(174)
  T2sum(1:15,308) = T2sum(1:15,308) + Gcoeff * G2tensor(:,156)
  Gcoeff = (-(c(91)*M(3))+c(94)*M(7)) * den(32)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,164)
  Gcoeff = (-(c(77)*M(3))+c(80)*M(7)) * den(32)
  T2sum(1:15,289) = T2sum(1:15,289) + Gcoeff * G2tensor(:,166)
  Gcoeff = (c(96)*M(3)+c(89)*M(7)) * den(220)
  T2sum(1:15,316) = T2sum(1:15,316) + Gcoeff * G2tensor(:,169)
  Gcoeff = (c(82)*M(3)+c(75)*M(7)) * den(220)
  T2sum(1:15,316) = T2sum(1:15,316) + Gcoeff * G2tensor(:,178)
  Gcoeff = (c(96)*M(5)+c(89)*M(7)) * den(39)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,180)
  Gcoeff = (c(82)*M(5)+c(75)*M(7)) * den(39)
  T2sum(1:15,301) = T2sum(1:15,301) + Gcoeff * G2tensor(:,182)
  Gcoeff = (-(c(91)*M(5))+c(94)*M(7)) * den(183)
  T2sum(1:15,324) = T2sum(1:15,324) + Gcoeff * G2tensor(:,185)
  Gcoeff = (-(c(94)*M(5))+c(91)*M(7)) * den(183)
  T2sum(1:15,325) = T2sum(1:15,325) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(309)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(310)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(311)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(312)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(21)*M(7)-c(16)*M(11)) * den(313)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(43)*M(7))+c(38)*M(11)) * den(310)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(21)*M(1)-c(16)*M(11)) * den(313)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(312)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,18)
  Gcoeff = (-(c(10)*M(5))+c(9)*(M(1)+M(7))-c(8)*M(11)) * den(313)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (-(c(68)*M(6))+c(63)*(M(2)+M(8))-c(58)*M(12)) * den(313)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(314)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(115)*M(7)-c(110)*M(11)) * den(315)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(316)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(115)*M(1)-c(110)*M(11)) * den(317)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(21)*M(7)-c(16)*M(11)) * den(318)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(43)*M(7))+c(38)*M(11)) * den(315)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(21)*M(1)-c(16)*M(11)) * den(318)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(43)*M(1))+c(38)*M(11)) * den(317)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(10)*M(3))+c(9)*(M(1)+M(7))-c(8)*M(11)) * den(318)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(68)*M(4))+c(63)*(M(2)+M(8))-c(58)*M(12)) * den(318)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(97)*M(3)-c(92)*M(7)) * den(321)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(83)*M(3)-c(78)*M(7)) * den(321)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(97)*M(3)-c(92)*M(7)) * den(322)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(83)*M(3)-c(78)*M(7)) * den(322)
  T1sum(1:5,5) = T1sum(1:5,5) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(97)*M(5)-c(92)*M(7)) * den(325)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(97)*M(5)-c(92)*M(7)) * den(326)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(83)*M(5)-c(78)*M(7)) * den(326)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(92)*M(3)-c(97)*M(7)) * den(385)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(78)*M(3)-c(83)*M(7)) * den(385)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(92)*M(5)-c(97)*M(7)) * den(420)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,26)
  Gcoeff = (-(c(92)*M(1))+c(97)*M(5)) * den(446)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(78)*M(1))+c(83)*M(5)) * den(446)
  T1sum(1:5,1) = T1sum(1:5,1) + Gcoeff * G1tensor(:,15)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_4

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_4_pptttt_ew_tttxtxbbx_1_/**/REALKIND
