
module ol_vamp_3_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_uuxtttxtx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_uuxtttxtx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_uuxtttxtx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,35) :: G0
  complex(REALKIND), dimension(4,5,4,311) :: G1
  complex(REALKIND), dimension(4,15,4,424) :: G2
  complex(REALKIND), dimension(4,35,4,128) :: G3
  complex(REALKIND), dimension(5,3) :: G1tensor
  complex(REALKIND), dimension(15,191) :: G2tensor
  complex(REALKIND), dimension(35,174) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,-2),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,4),MT,G1(:,:,:,1))
  call loop_QA_V(G1(:,:,:,1),wf(:,214),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-1),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,62),ZERO,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,2))
  call loop_QA_V(G1(:,:,:,1),wf(:,215),G1(:,:,:,4))
  call check_last_UV_W(l_switch,G1(:,:,:,4),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,3))
  call loop_VA_Q(G1(:,:,:,4),wf(:,-1),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),ZERO,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,4))
  call loop_QA_V(G1(:,:,:,1),wf(:,216),G1(:,:,:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,5))
  call loop_VA_Q(G1(:,:,:,6),wf(:,-1),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,62),ZERO,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,6))
  call loop_QA_V(G1(:,:,:,1),wf(:,218),G1(:,:,:,8))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,8),wf(:,-1),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),ZERO,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,8))
  call loop_QA_V(G1(:,:,:,1),wf(:,-5),G1(:,:,:,10))
  call loop_UV_W(G1(:,:,:,10),Q(:,36),wf(:,28),Q(:,24),G2(:,:,:,5))
  call check_last_UV_W(l_switch,G2(:,:,:,5),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,1))
  call loop_VA_Q(G2(:,:,:,5),wf(:,-1),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,62),ZERO,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,2))
  call loop_VQ_A(G1(:,:,:,10),wf(:,-3),G1(:,:,:,11))
  call loop_Q_A(G1(:,:,:,11),Q(:,44),MT,G2(:,:,:,7))
  call loop_QA_V(G2(:,:,:,7),wf(:,-4),G2(:,:,:,8))
  call check_last_UV_W(l_switch,G2(:,:,:,8),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,3))
  call loop_VA_Q(G2(:,:,:,8),wf(:,-1),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,62),ZERO,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,4))
  call loop_QA_Z(G2(:,:,:,7),wf(:,-4),G2(:,:,:,10),gZu)
  call loop_ZA_Q(G2(:,:,:,10),wf(:,-1),G2(:,:,:,11),gZu)
  call loop_A_Q(G2(:,:,:,11),Q(:,62),ZERO,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,5))
  call loop_ZQ_A(G2(:,:,:,10),wf(:,0),G2(:,:,:,12),gZu)
  call loop_Q_A(G2(:,:,:,12),Q(:,61),ZERO,G3(:,:,:,4))
  call check_last_QA_V(l_switch,G3(:,:,:,4),wf(:,-1),G3tensor(:,6))
  call loop_VA_Q(G1(:,:,:,10),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,52),MT,G2(:,:,:,13))
  call loop_AQ_V(G2(:,:,:,13),wf(:,-3),G2(:,:,:,14))
  call check_last_UV_W(l_switch,G2(:,:,:,14),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,7))
  call loop_VA_Q(G2(:,:,:,14),wf(:,-1),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,62),ZERO,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,8))
  call loop_AQ_Z(G2(:,:,:,13),wf(:,-3),G2(:,:,:,16),gZu)
  call loop_ZA_Q(G2(:,:,:,16),wf(:,-1),G2(:,:,:,17),gZu)
  call loop_A_Q(G2(:,:,:,17),Q(:,62),ZERO,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,9))
  call loop_ZQ_A(G2(:,:,:,16),wf(:,0),G2(:,:,:,18),gZu)
  call loop_Q_A(G2(:,:,:,18),Q(:,61),ZERO,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-1),G3tensor(:,10))
  call loop_VQ_A(G1(:,:,:,10),wf(:,101),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,61),ZERO,G2(:,:,:,19))
  call check_last_QA_V(l_switch,G2(:,:,:,19),wf(:,-1),G2tensor(:,9))
  call loop_VQ_A(G1(:,:,:,10),wf(:,103),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,61),ZERO,G2(:,:,:,20))
  call check_last_QA_V(l_switch,G2(:,:,:,20),wf(:,-1),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,10),wf(:,332),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),ZERO,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,0),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,10),wf(:,334),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,62),ZERO,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,0),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,10),wf(:,-1),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,38),ZERO,G2(:,:,:,23))
  call loop_AV_Q(G2(:,:,:,23),wf(:,28),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,62),ZERO,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,11))
  call loop_AZ_Q(G2(:,:,:,23),wf(:,39),G2(:,:,:,25),gZu)
  call loop_A_Q(G2(:,:,:,25),Q(:,62),ZERO,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,12))
  call loop_QS_A(G1(:,:,:,1),wf(:,30),G1(:,:,:,18),gH)
  call loop_Q_A(G1(:,:,:,18),Q(:,28),MT,G2(:,:,:,26))
  call loop_QA_V(G2(:,:,:,26),wf(:,-5),G2(:,:,:,27))
  call check_last_UV_W(l_switch,G2(:,:,:,27),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,13))
  call loop_VA_Q(G2(:,:,:,27),wf(:,-1),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,62),ZERO,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,14))
  call loop_QS_A(G1(:,:,:,1),wf(:,34),G1(:,:,:,19),gX)
  call loop_Q_A(G1(:,:,:,19),Q(:,28),MT,G2(:,:,:,29))
  call loop_QA_V(G2(:,:,:,29),wf(:,-5),G2(:,:,:,30))
  call check_last_UV_W(l_switch,G2(:,:,:,30),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,15))
  call loop_VA_Q(G2(:,:,:,30),wf(:,-1),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,62),ZERO,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,16))
  call loop_QV_A(G1(:,:,:,1),wf(:,28),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,28),MT,G2(:,:,:,32))
  call loop_QA_V(G2(:,:,:,32),wf(:,-5),G2(:,:,:,33))
  call check_last_UV_W(l_switch,G2(:,:,:,33),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,17))
  call loop_VA_Q(G2(:,:,:,33),wf(:,-1),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,62),ZERO,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,18))
  call loop_QA_Z(G2(:,:,:,32),wf(:,-5),G2(:,:,:,35),gZu)
  call loop_ZA_Q(G2(:,:,:,35),wf(:,-1),G2(:,:,:,36),gZu)
  call loop_A_Q(G2(:,:,:,36),Q(:,62),ZERO,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,19))
  call loop_ZQ_A(G2(:,:,:,35),wf(:,0),G2(:,:,:,37),gZu)
  call loop_Q_A(G2(:,:,:,37),Q(:,61),ZERO,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,-1),G3tensor(:,20))
  call loop_QZ_A(G1(:,:,:,1),wf(:,39),G1(:,:,:,21),gZu)
  call loop_Q_A(G1(:,:,:,21),Q(:,28),MT,G2(:,:,:,38))
  call loop_QA_V(G2(:,:,:,38),wf(:,-5),G2(:,:,:,39))
  call check_last_UV_W(l_switch,G2(:,:,:,39),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,21))
  call loop_VA_Q(G2(:,:,:,39),wf(:,-1),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,62),ZERO,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,0),G3tensor(:,22))
  call loop_QA_V(G1(:,:,:,1),wf(:,229),G1(:,:,:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,22),wf(:,-1),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,62),ZERO,G2(:,:,:,41))
  call check_last_AQ_V(l_switch,G2(:,:,:,41),wf(:,0),G2tensor(:,14))
  call loop_QA_V(G1(:,:,:,1),wf(:,230),G1(:,:,:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,24),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-1),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,62),ZERO,G2(:,:,:,42))
  call check_last_AQ_V(l_switch,G2(:,:,:,42),wf(:,0),G2tensor(:,16))
  call loop_QA_V(G1(:,:,:,1),wf(:,231),G1(:,:,:,26))
  call check_last_UV_W(l_switch,G1(:,:,:,26),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,26),wf(:,-1),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,62),ZERO,G2(:,:,:,43))
  call check_last_AQ_V(l_switch,G2(:,:,:,43),wf(:,0),G2tensor(:,18))
  call loop_QA_V(G1(:,:,:,1),wf(:,232),G1(:,:,:,28))
  call check_last_UV_W(l_switch,G1(:,:,:,28),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,28),wf(:,-1),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,62),ZERO,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,0),G2tensor(:,20))
  call loop_QA_V(G1(:,:,:,1),wf(:,-4),G1(:,:,:,30))
  call loop_UV_W(G1(:,:,:,30),Q(:,20),wf(:,3),Q(:,40),G2(:,:,:,45))
  call check_last_UV_W(l_switch,G2(:,:,:,45),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,23))
  call loop_VA_Q(G2(:,:,:,45),wf(:,-1),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,62),ZERO,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,0),G3tensor(:,24))
  call loop_VQ_A(G1(:,:,:,30),wf(:,-3),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,28),MT,G2(:,:,:,47))
  call loop_QA_V(G2(:,:,:,47),wf(:,-5),G2(:,:,:,48))
  call check_last_UV_W(l_switch,G2(:,:,:,48),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,25))
  call loop_VA_Q(G2(:,:,:,48),wf(:,-1),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,62),ZERO,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,0),G3tensor(:,26))
  call loop_QA_Z(G2(:,:,:,47),wf(:,-5),G2(:,:,:,50),gZu)
  call loop_ZA_Q(G2(:,:,:,50),wf(:,-1),G2(:,:,:,51),gZu)
  call loop_A_Q(G2(:,:,:,51),Q(:,62),ZERO,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,0),G3tensor(:,27))
  call loop_ZQ_A(G2(:,:,:,50),wf(:,0),G2(:,:,:,52),gZu)
  call loop_Q_A(G2(:,:,:,52),Q(:,61),ZERO,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-1),G3tensor(:,28))
  call loop_VA_Q(G1(:,:,:,30),wf(:,-5),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,52),MT,G2(:,:,:,53))
  call loop_AQ_V(G2(:,:,:,53),wf(:,-3),G2(:,:,:,54))
  call check_last_UV_W(l_switch,G2(:,:,:,54),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,29))
  call loop_VA_Q(G2(:,:,:,54),wf(:,-1),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,62),ZERO,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,0),G3tensor(:,30))
  call loop_AQ_Z(G2(:,:,:,53),wf(:,-3),G2(:,:,:,56),gZu)
  call loop_ZA_Q(G2(:,:,:,56),wf(:,-1),G2(:,:,:,57),gZu)
  call loop_A_Q(G2(:,:,:,57),Q(:,62),ZERO,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,0),G3tensor(:,31))
  call loop_ZQ_A(G2(:,:,:,56),wf(:,0),G2(:,:,:,58),gZu)
  call loop_Q_A(G2(:,:,:,58),Q(:,61),ZERO,G3(:,:,:,22))
  call check_last_QA_V(l_switch,G3(:,:,:,22),wf(:,-1),G3tensor(:,32))
  call loop_VQ_A(G1(:,:,:,30),wf(:,89),G1(:,:,:,33))
  call loop_Q_A(G1(:,:,:,33),Q(:,61),ZERO,G2(:,:,:,59))
  call check_last_QA_V(l_switch,G2(:,:,:,59),wf(:,-1),G2tensor(:,21))
  call loop_VQ_A(G1(:,:,:,30),wf(:,91),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,61),ZERO,G2(:,:,:,60))
  call check_last_QA_V(l_switch,G2(:,:,:,60),wf(:,-1),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,30),wf(:,322),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,62),ZERO,G2(:,:,:,61))
  call check_last_AQ_V(l_switch,G2(:,:,:,61),wf(:,0),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,30),wf(:,324),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,62),ZERO,G2(:,:,:,62))
  call check_last_AQ_V(l_switch,G2(:,:,:,62),wf(:,0),G2tensor(:,24))
  call loop_VA_Q(G1(:,:,:,30),wf(:,-1),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,22),ZERO,G2(:,:,:,63))
  call loop_AV_Q(G2(:,:,:,63),wf(:,3),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,62),ZERO,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,0),G3tensor(:,33))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,71),G2(:,:,:,65),gZu)
  call loop_A_Q(G2(:,:,:,65),Q(:,62),ZERO,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,0),G3tensor(:,34))
  call loop_QS_A(G1(:,:,:,1),wf(:,66),G1(:,:,:,38),gH)
  call loop_Q_A(G1(:,:,:,38),Q(:,44),MT,G2(:,:,:,66))
  call loop_QA_V(G2(:,:,:,66),wf(:,-4),G2(:,:,:,67))
  call check_last_UV_W(l_switch,G2(:,:,:,67),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,35))
  call loop_VA_Q(G2(:,:,:,67),wf(:,-1),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,62),ZERO,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,0),G3tensor(:,36))
  call loop_QS_A(G1(:,:,:,1),wf(:,68),G1(:,:,:,39),gX)
  call loop_Q_A(G1(:,:,:,39),Q(:,44),MT,G2(:,:,:,69))
  call loop_QA_V(G2(:,:,:,69),wf(:,-4),G2(:,:,:,70))
  call check_last_UV_W(l_switch,G2(:,:,:,70),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,37))
  call loop_VA_Q(G2(:,:,:,70),wf(:,-1),G2(:,:,:,71))
  call loop_A_Q(G2(:,:,:,71),Q(:,62),ZERO,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,38))
  call loop_QV_A(G1(:,:,:,1),wf(:,3),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,44),MT,G2(:,:,:,72))
  call loop_QA_V(G2(:,:,:,72),wf(:,-4),G2(:,:,:,73))
  call check_last_UV_W(l_switch,G2(:,:,:,73),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,39))
  call loop_VA_Q(G2(:,:,:,73),wf(:,-1),G2(:,:,:,74))
  call loop_A_Q(G2(:,:,:,74),Q(:,62),ZERO,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,0),G3tensor(:,40))
  call loop_QA_Z(G2(:,:,:,72),wf(:,-4),G2(:,:,:,75),gZu)
  call loop_ZA_Q(G2(:,:,:,75),wf(:,-1),G2(:,:,:,76),gZu)
  call loop_A_Q(G2(:,:,:,76),Q(:,62),ZERO,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,41))
  call loop_ZQ_A(G2(:,:,:,75),wf(:,0),G2(:,:,:,77),gZu)
  call loop_Q_A(G2(:,:,:,77),Q(:,61),ZERO,G3(:,:,:,29))
  call check_last_QA_V(l_switch,G3(:,:,:,29),wf(:,-1),G3tensor(:,42))
  call loop_QZ_A(G1(:,:,:,1),wf(:,71),G1(:,:,:,41),gZu)
  call loop_Q_A(G1(:,:,:,41),Q(:,44),MT,G2(:,:,:,78))
  call loop_QA_V(G2(:,:,:,78),wf(:,-4),G2(:,:,:,79))
  call check_last_UV_W(l_switch,G2(:,:,:,79),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,43))
  call loop_VA_Q(G2(:,:,:,79),wf(:,-1),G2(:,:,:,80))
  call loop_A_Q(G2(:,:,:,80),Q(:,62),ZERO,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,0),G3tensor(:,44))
  call loop_QA_S(G1(:,:,:,1),wf(:,-4),G1(:,:,:,42),gH)
  call loop_SQ_A(G1(:,:,:,42),wf(:,-3),G1(:,:,:,43),gH)
  call loop_Q_A(G1(:,:,:,43),Q(:,28),MT,G2(:,:,:,81))
  call loop_QA_V(G2(:,:,:,81),wf(:,-5),G2(:,:,:,82))
  call check_last_UV_W(l_switch,G2(:,:,:,82),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,45))
  call loop_VA_Q(G2(:,:,:,82),wf(:,-1),G2(:,:,:,83))
  call loop_A_Q(G2(:,:,:,83),Q(:,62),ZERO,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,46))
  call loop_SA_Q(G1(:,:,:,42),wf(:,-5),G1(:,:,:,44),gH)
  call loop_A_Q(G1(:,:,:,44),Q(:,52),MT,G2(:,:,:,84))
  call loop_AQ_V(G2(:,:,:,84),wf(:,-3),G2(:,:,:,85))
  call check_last_UV_W(l_switch,G2(:,:,:,85),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,47))
  call loop_VA_Q(G2(:,:,:,85),wf(:,-1),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,62),ZERO,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,0),G3tensor(:,48))
  call loop_QA_S(G1(:,:,:,1),wf(:,-4),G1(:,:,:,45),gX)
  call loop_SQ_A(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46),gX)
  call loop_Q_A(G1(:,:,:,46),Q(:,28),MT,G2(:,:,:,87))
  call loop_QA_V(G2(:,:,:,87),wf(:,-5),G2(:,:,:,88))
  call check_last_UV_W(l_switch,G2(:,:,:,88),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,49))
  call loop_VA_Q(G2(:,:,:,88),wf(:,-1),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,62),ZERO,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,0),G3tensor(:,50))
  call loop_SA_Q(G1(:,:,:,45),wf(:,-5),G1(:,:,:,47),gX)
  call loop_A_Q(G1(:,:,:,47),Q(:,52),MT,G2(:,:,:,90))
  call loop_AQ_V(G2(:,:,:,90),wf(:,-3),G2(:,:,:,91))
  call check_last_UV_W(l_switch,G2(:,:,:,91),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,51))
  call loop_VA_Q(G2(:,:,:,91),wf(:,-1),G2(:,:,:,92))
  call loop_A_Q(G2(:,:,:,92),Q(:,62),ZERO,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,0),G3tensor(:,52))
  call loop_QA_Z(G1(:,:,:,1),wf(:,-4),G1(:,:,:,48),gZu)
  call loop_ZQ_A(G1(:,:,:,48),wf(:,-3),G1(:,:,:,49),gZu)
  call loop_Q_A(G1(:,:,:,49),Q(:,28),MT,G2(:,:,:,93))
  call loop_QA_V(G2(:,:,:,93),wf(:,-5),G2(:,:,:,94))
  call check_last_UV_W(l_switch,G2(:,:,:,94),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,53))
  call loop_VA_Q(G2(:,:,:,94),wf(:,-1),G2(:,:,:,95))
  call loop_A_Q(G2(:,:,:,95),Q(:,62),ZERO,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,0),G3tensor(:,54))
  call loop_ZA_Q(G1(:,:,:,48),wf(:,-5),G1(:,:,:,50),gZu)
  call loop_A_Q(G1(:,:,:,50),Q(:,52),MT,G2(:,:,:,96))
  call loop_AQ_V(G2(:,:,:,96),wf(:,-3),G2(:,:,:,97))
  call check_last_UV_W(l_switch,G2(:,:,:,97),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,55))
  call loop_VA_Q(G2(:,:,:,97),wf(:,-1),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,62),ZERO,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,0),G3tensor(:,56))
  call loop_ZQ_A(G1(:,:,:,48),wf(:,89),G1(:,:,:,51),gZu)
  call loop_Q_A(G1(:,:,:,51),Q(:,61),ZERO,G2(:,:,:,99))
  call check_last_QA_V(l_switch,G2(:,:,:,99),wf(:,-1),G2tensor(:,25))
  call loop_ZA_Q(G1(:,:,:,48),wf(:,322),G1(:,:,:,52),gZu)
  call loop_A_Q(G1(:,:,:,52),Q(:,62),ZERO,G2(:,:,:,100))
  call check_last_AQ_V(l_switch,G2(:,:,:,100),wf(:,0),G2tensor(:,26))
  call loop_ZA_Q(G1(:,:,:,48),wf(:,-1),G1(:,:,:,53),gZu)
  call loop_A_Q(G1(:,:,:,53),Q(:,22),ZERO,G2(:,:,:,101))
  call loop_AV_Q(G2(:,:,:,101),wf(:,3),G2(:,:,:,102))
  call loop_A_Q(G2(:,:,:,102),Q(:,62),ZERO,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,0),G3tensor(:,57))
  call loop_ZQ_A(G1(:,:,:,48),wf(:,0),G1(:,:,:,54),gZu)
  call loop_Q_A(G1(:,:,:,54),Q(:,21),ZERO,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,3),G2(:,:,:,104))
  call loop_Q_A(G2(:,:,:,104),Q(:,61),ZERO,G3(:,:,:,38))
  call check_last_QA_V(l_switch,G3(:,:,:,38),wf(:,-1),G3tensor(:,58))
  call loop_QA_S(G1(:,:,:,1),wf(:,-5),G1(:,:,:,55),gH)
  call loop_SQ_A(G1(:,:,:,55),wf(:,-3),G1(:,:,:,56),gH)
  call loop_Q_A(G1(:,:,:,56),Q(:,44),MT,G2(:,:,:,105))
  call loop_QA_V(G2(:,:,:,105),wf(:,-4),G2(:,:,:,106))
  call check_last_UV_W(l_switch,G2(:,:,:,106),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,59))
  call loop_VA_Q(G2(:,:,:,106),wf(:,-1),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,62),ZERO,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,0),G3tensor(:,60))
  call loop_SA_Q(G1(:,:,:,55),wf(:,-4),G1(:,:,:,57),gH)
  call loop_A_Q(G1(:,:,:,57),Q(:,52),MT,G2(:,:,:,108))
  call loop_AQ_V(G2(:,:,:,108),wf(:,-3),G2(:,:,:,109))
  call check_last_UV_W(l_switch,G2(:,:,:,109),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,61))
  call loop_VA_Q(G2(:,:,:,109),wf(:,-1),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,62),ZERO,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,62))
  call loop_QA_S(G1(:,:,:,1),wf(:,-5),G1(:,:,:,58),gX)
  call loop_SQ_A(G1(:,:,:,58),wf(:,-3),G1(:,:,:,59),gX)
  call loop_Q_A(G1(:,:,:,59),Q(:,44),MT,G2(:,:,:,111))
  call loop_QA_V(G2(:,:,:,111),wf(:,-4),G2(:,:,:,112))
  call check_last_UV_W(l_switch,G2(:,:,:,112),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,63))
  call loop_VA_Q(G2(:,:,:,112),wf(:,-1),G2(:,:,:,113))
  call loop_A_Q(G2(:,:,:,113),Q(:,62),ZERO,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,64))
  call loop_SA_Q(G1(:,:,:,58),wf(:,-4),G1(:,:,:,60),gX)
  call loop_A_Q(G1(:,:,:,60),Q(:,52),MT,G2(:,:,:,114))
  call loop_AQ_V(G2(:,:,:,114),wf(:,-3),G2(:,:,:,115))
  call check_last_UV_W(l_switch,G2(:,:,:,115),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,65))
  call loop_VA_Q(G2(:,:,:,115),wf(:,-1),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),ZERO,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,66))
  call loop_QA_Z(G1(:,:,:,1),wf(:,-5),G1(:,:,:,61),gZu)
  call loop_ZQ_A(G1(:,:,:,61),wf(:,-3),G1(:,:,:,62),gZu)
  call loop_Q_A(G1(:,:,:,62),Q(:,44),MT,G2(:,:,:,117))
  call loop_QA_V(G2(:,:,:,117),wf(:,-4),G2(:,:,:,118))
  call check_last_UV_W(l_switch,G2(:,:,:,118),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,118),wf(:,-1),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,62),ZERO,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,68))
  call loop_ZA_Q(G1(:,:,:,61),wf(:,-4),G1(:,:,:,63),gZu)
  call loop_A_Q(G1(:,:,:,63),Q(:,52),MT,G2(:,:,:,120))
  call loop_AQ_V(G2(:,:,:,120),wf(:,-3),G2(:,:,:,121))
  call check_last_UV_W(l_switch,G2(:,:,:,121),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,69))
  call loop_VA_Q(G2(:,:,:,121),wf(:,-1),G2(:,:,:,122))
  call loop_A_Q(G2(:,:,:,122),Q(:,62),ZERO,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,0),G3tensor(:,70))
  call loop_ZQ_A(G1(:,:,:,61),wf(:,101),G1(:,:,:,64),gZu)
  call loop_Q_A(G1(:,:,:,64),Q(:,61),ZERO,G2(:,:,:,123))
  call check_last_QA_V(l_switch,G2(:,:,:,123),wf(:,-1),G2tensor(:,27))
  call loop_ZA_Q(G1(:,:,:,61),wf(:,332),G1(:,:,:,65),gZu)
  call loop_A_Q(G1(:,:,:,65),Q(:,62),ZERO,G2(:,:,:,124))
  call check_last_AQ_V(l_switch,G2(:,:,:,124),wf(:,0),G2tensor(:,28))
  call loop_ZA_Q(G1(:,:,:,61),wf(:,-1),G1(:,:,:,66),gZu)
  call loop_A_Q(G1(:,:,:,66),Q(:,38),ZERO,G2(:,:,:,125))
  call loop_AV_Q(G2(:,:,:,125),wf(:,28),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,62),ZERO,G3(:,:,:,45))
  call check_last_AQ_V(l_switch,G3(:,:,:,45),wf(:,0),G3tensor(:,71))
  call loop_ZQ_A(G1(:,:,:,61),wf(:,0),G1(:,:,:,67),gZu)
  call loop_Q_A(G1(:,:,:,67),Q(:,37),ZERO,G2(:,:,:,127))
  call loop_QV_A(G2(:,:,:,127),wf(:,28),G2(:,:,:,128))
  call loop_Q_A(G2(:,:,:,128),Q(:,61),ZERO,G3(:,:,:,46))
  call check_last_QA_V(l_switch,G3(:,:,:,46),wf(:,-1),G3tensor(:,72))
  call loop_QA_Z(G1(:,:,:,1),wf(:,216),G1(:,:,:,68),gZu)
  call loop_ZA_Q(G1(:,:,:,68),wf(:,-1),G1(:,:,:,69),gZu)
  call loop_A_Q(G1(:,:,:,69),Q(:,62),ZERO,G2(:,:,:,129))
  call check_last_AQ_V(l_switch,G2(:,:,:,129),wf(:,0),G2tensor(:,29))
  call loop_ZQ_A(G1(:,:,:,68),wf(:,0),G1(:,:,:,70),gZu)
  call loop_Q_A(G1(:,:,:,70),Q(:,61),ZERO,G2(:,:,:,130))
  call check_last_QA_V(l_switch,G2(:,:,:,130),wf(:,-1),G2tensor(:,30))
  call loop_QA_Z(G1(:,:,:,1),wf(:,231),G1(:,:,:,71),gZu)
  call loop_ZA_Q(G1(:,:,:,71),wf(:,-1),G1(:,:,:,72),gZu)
  call loop_A_Q(G1(:,:,:,72),Q(:,62),ZERO,G2(:,:,:,131))
  call check_last_AQ_V(l_switch,G2(:,:,:,131),wf(:,0),G2tensor(:,31))
  call loop_ZQ_A(G1(:,:,:,71),wf(:,0),G1(:,:,:,73),gZu)
  call loop_Q_A(G1(:,:,:,73),Q(:,61),ZERO,G2(:,:,:,132))
  call check_last_QA_V(l_switch,G2(:,:,:,132),wf(:,-1),G2tensor(:,32))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-2),G0(:,:,:,3),gH)
  call loop_SA_Q(G0(:,:,:,3),wf(:,216),G0(:,:,:,4),gH)
  call loop_A_Q(G0(:,:,:,4),Q(:,60),MT,G1(:,:,:,74))
  call loop_AV_Q(G1(:,:,:,74),wf(:,1),G1(:,:,:,75))
  call check_last_A_Q(l_switch,G1(:,:,:,75),Q(:,63),MT,G2tensor(:,33))
  call loop_SA_Q(G0(:,:,:,3),wf(:,-5),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,36),MT,G1(:,:,:,76))
  call loop_AV_Q(G1(:,:,:,76),wf(:,28),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,60),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,1),G2(:,:,:,134))
  call check_last_A_Q(l_switch,G2(:,:,:,134),Q(:,63),MT,G3tensor(:,73))
  call loop_SA_Q(G0(:,:,:,3),wf(:,231),G0(:,:,:,6),gH)
  call loop_A_Q(G0(:,:,:,6),Q(:,60),MT,G1(:,:,:,78))
  call loop_AV_Q(G1(:,:,:,78),wf(:,1),G1(:,:,:,79))
  call check_last_A_Q(l_switch,G1(:,:,:,79),Q(:,63),MT,G2tensor(:,34))
  call loop_SA_Q(G0(:,:,:,3),wf(:,-4),G0(:,:,:,7),gH)
  call loop_A_Q(G0(:,:,:,7),Q(:,20),MT,G1(:,:,:,80))
  call loop_AV_Q(G1(:,:,:,80),wf(:,3),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,60),MT,G2(:,:,:,135))
  call loop_AV_Q(G2(:,:,:,135),wf(:,1),G2(:,:,:,136))
  call check_last_A_Q(l_switch,G2(:,:,:,136),Q(:,63),MT,G3tensor(:,74))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-2),G0(:,:,:,8),gX)
  call loop_SA_Q(G0(:,:,:,8),wf(:,216),G0(:,:,:,9),gX)
  call loop_A_Q(G0(:,:,:,9),Q(:,60),MT,G1(:,:,:,82))
  call loop_AV_Q(G1(:,:,:,82),wf(:,1),G1(:,:,:,83))
  call check_last_A_Q(l_switch,G1(:,:,:,83),Q(:,63),MT,G2tensor(:,35))
  call loop_SA_Q(G0(:,:,:,8),wf(:,-5),G0(:,:,:,10),gX)
  call loop_A_Q(G0(:,:,:,10),Q(:,36),MT,G1(:,:,:,84))
  call loop_AV_Q(G1(:,:,:,84),wf(:,28),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,60),MT,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,1),G2(:,:,:,138))
  call check_last_A_Q(l_switch,G2(:,:,:,138),Q(:,63),MT,G3tensor(:,75))
  call loop_SA_Q(G0(:,:,:,8),wf(:,231),G0(:,:,:,11),gX)
  call loop_A_Q(G0(:,:,:,11),Q(:,60),MT,G1(:,:,:,86))
  call loop_AV_Q(G1(:,:,:,86),wf(:,1),G1(:,:,:,87))
  call check_last_A_Q(l_switch,G1(:,:,:,87),Q(:,63),MT,G2tensor(:,36))
  call loop_SA_Q(G0(:,:,:,8),wf(:,-4),G0(:,:,:,12),gX)
  call loop_A_Q(G0(:,:,:,12),Q(:,20),MT,G1(:,:,:,88))
  call loop_AV_Q(G1(:,:,:,88),wf(:,3),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,60),MT,G2(:,:,:,139))
  call loop_AV_Q(G2(:,:,:,139),wf(:,1),G2(:,:,:,140))
  call check_last_A_Q(l_switch,G2(:,:,:,140),Q(:,63),MT,G3tensor(:,76))
  call loop_AQ_S(G0(:,:,:,1),wf(:,-2),G0(:,:,:,13),gPbt)
  call loop_SA_Q(G0(:,:,:,13),wf(:,216),G0(:,:,:,14),gPtb)
  call loop_A_Q(G0(:,:,:,14),Q(:,60),MB,G1(:,:,:,90))
  call loop_AV_Q(G1(:,:,:,90),wf(:,1),G1(:,:,:,91))
  call check_last_A_Q(l_switch,G1(:,:,:,91),Q(:,63),MB,G2tensor(:,37))
  call loop_SA_Q(G0(:,:,:,13),wf(:,-5),G0(:,:,:,15),gPtb)
  call loop_A_Q(G0(:,:,:,15),Q(:,36),MB,G1(:,:,:,92))
  call loop_AV_Q(G1(:,:,:,92),wf(:,28),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,60),MB,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,1),G2(:,:,:,142))
  call check_last_A_Q(l_switch,G2(:,:,:,142),Q(:,63),MB,G3tensor(:,77))
  call loop_SA_Q(G0(:,:,:,13),wf(:,231),G0(:,:,:,16),gPtb)
  call loop_A_Q(G0(:,:,:,16),Q(:,60),MB,G1(:,:,:,94))
  call loop_AV_Q(G1(:,:,:,94),wf(:,1),G1(:,:,:,95))
  call check_last_A_Q(l_switch,G1(:,:,:,95),Q(:,63),MB,G2tensor(:,38))
  call loop_SA_Q(G0(:,:,:,13),wf(:,-4),G0(:,:,:,17),gPtb)
  call loop_A_Q(G0(:,:,:,17),Q(:,20),MB,G1(:,:,:,96))
  call loop_AV_Q(G1(:,:,:,96),wf(:,3),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,60),MB,G2(:,:,:,143))
  call loop_AV_Q(G2(:,:,:,143),wf(:,1),G2(:,:,:,144))
  call check_last_A_Q(l_switch,G2(:,:,:,144),Q(:,63),MB,G3tensor(:,78))
  call loop_VA_Q(G0(:,:,:,1),wf(:,216),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,56),MT,G1(:,:,:,98))
  call loop_AV_Q(G1(:,:,:,98),wf(:,1),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,59),MT,G2(:,:,:,145))
  call check_last_AQ_V(l_switch,G2(:,:,:,145),wf(:,-2),G2tensor(:,39))
  call loop_AZ_Q(G1(:,:,:,98),wf(:,12),G1(:,:,:,100),gZu)
  call loop_A_Q(G1(:,:,:,100),Q(:,59),MT,G2(:,:,:,146))
  call check_last_AQ_V(l_switch,G2(:,:,:,146),wf(:,-2),G2tensor(:,40))
  call loop_AQ_Z(G1(:,:,:,98),wf(:,-2),G1(:,:,:,101),gZu)
  call loop_ZQ_A(G1(:,:,:,101),wf(:,0),G1(:,:,:,102),gZu)
  call loop_Q_A(G1(:,:,:,102),Q(:,61),ZERO,G2(:,:,:,147))
  call check_last_QA_V(l_switch,G2(:,:,:,147),wf(:,-1),G2tensor(:,41))
  call loop_ZA_Q(G1(:,:,:,101),wf(:,-1),G1(:,:,:,103),gZu)
  call loop_A_Q(G1(:,:,:,103),Q(:,62),ZERO,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,0),G2tensor(:,42))
  call loop_AQ_V(G1(:,:,:,98),wf(:,-2),G1(:,:,:,104))
  call loop_VA_Q(G1(:,:,:,104),wf(:,-1),G1(:,:,:,105))
  call loop_A_Q(G1(:,:,:,105),Q(:,62),ZERO,G2(:,:,:,149))
  call check_last_AQ_V(l_switch,G2(:,:,:,149),wf(:,0),G2tensor(:,43))
  call check_last_AQ_V(l_switch,G1(:,:,:,98),wf(:,33),G1tensor(:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,98),wf(:,38),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,1),wf(:,218),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,56),MT,G1(:,:,:,106))
  call loop_AV_Q(G1(:,:,:,106),wf(:,1),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,59),MT,G2(:,:,:,150))
  call check_last_AQ_V(l_switch,G2(:,:,:,150),wf(:,-2),G2tensor(:,44))
  call loop_AQ_V(G1(:,:,:,106),wf(:,-2),G1(:,:,:,108))
  call loop_VA_Q(G1(:,:,:,108),wf(:,-1),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,62),ZERO,G2(:,:,:,151))
  call check_last_AQ_V(l_switch,G2(:,:,:,151),wf(:,0),G2tensor(:,45))
  call check_last_AQ_V(l_switch,G1(:,:,:,106),wf(:,33),G1tensor(:,3))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,-2),G0(:,:,:,20),gZu)
  call loop_ZA_Q(G0(:,:,:,20),wf(:,216),G0(:,:,:,21),gZu)
  call loop_A_Q(G0(:,:,:,21),Q(:,60),MT,G1(:,:,:,110))
  call loop_AV_Q(G1(:,:,:,110),wf(:,1),G1(:,:,:,111))
  call check_last_A_Q(l_switch,G1(:,:,:,111),Q(:,63),MT,G2tensor(:,46))
  call loop_ZA_Q(G0(:,:,:,20),wf(:,-5),G0(:,:,:,22),gZu)
  call loop_A_Q(G0(:,:,:,22),Q(:,36),MT,G1(:,:,:,112))
  call loop_AV_Q(G1(:,:,:,112),wf(:,28),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,60),MT,G2(:,:,:,152))
  call loop_AV_Q(G2(:,:,:,152),wf(:,1),G2(:,:,:,153))
  call check_last_A_Q(l_switch,G2(:,:,:,153),Q(:,63),MT,G3tensor(:,79))
  call loop_ZA_Q(G0(:,:,:,20),wf(:,231),G0(:,:,:,23),gZu)
  call loop_A_Q(G0(:,:,:,23),Q(:,60),MT,G1(:,:,:,114))
  call loop_AV_Q(G1(:,:,:,114),wf(:,1),G1(:,:,:,115))
  call check_last_A_Q(l_switch,G1(:,:,:,115),Q(:,63),MT,G2tensor(:,47))
  call loop_ZA_Q(G0(:,:,:,20),wf(:,-4),G0(:,:,:,24),gZu)
  call loop_A_Q(G0(:,:,:,24),Q(:,20),MT,G1(:,:,:,116))
  call loop_AV_Q(G1(:,:,:,116),wf(:,3),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,60),MT,G2(:,:,:,154))
  call loop_AV_Q(G2(:,:,:,154),wf(:,1),G2(:,:,:,155))
  call check_last_A_Q(l_switch,G2(:,:,:,155),Q(:,63),MT,G3tensor(:,80))
  call loop_AQ_W(G0(:,:,:,1),wf(:,-2),G0(:,:,:,25))
  call loop_WA_Q(G0(:,:,:,25),wf(:,216),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,60),MB,G1(:,:,:,118))
  call loop_AV_Q(G1(:,:,:,118),wf(:,1),G1(:,:,:,119))
  call check_last_A_Q(l_switch,G1(:,:,:,119),Q(:,63),MB,G2tensor(:,48))
  call loop_WA_Q(G0(:,:,:,25),wf(:,-5),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,36),MB,G1(:,:,:,120))
  call loop_AV_Q(G1(:,:,:,120),wf(:,28),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,60),MB,G2(:,:,:,156))
  call loop_AV_Q(G2(:,:,:,156),wf(:,1),G2(:,:,:,157))
  call check_last_A_Q(l_switch,G2(:,:,:,157),Q(:,63),MB,G3tensor(:,81))
  call loop_WA_Q(G0(:,:,:,25),wf(:,231),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,60),MB,G1(:,:,:,122))
  call loop_AV_Q(G1(:,:,:,122),wf(:,1),G1(:,:,:,123))
  call check_last_A_Q(l_switch,G1(:,:,:,123),Q(:,63),MB,G2tensor(:,49))
  call loop_WA_Q(G0(:,:,:,25),wf(:,-4),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,20),MB,G1(:,:,:,124))
  call loop_AV_Q(G1(:,:,:,124),wf(:,3),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,60),MB,G2(:,:,:,158))
  call loop_AV_Q(G2(:,:,:,158),wf(:,1),G2(:,:,:,159))
  call check_last_A_Q(l_switch,G2(:,:,:,159),Q(:,63),MB,G3tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,384),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,27),MT,G1(:,:,:,126))
  call loop_QA_S(G1(:,:,:,126),wf(:,-5),G1(:,:,:,127),gH)
  call loop_SQ_A(G1(:,:,:,127),wf(:,-2),G1(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,63),MT,G2tensor(:,50))
  call loop_QA_S(G1(:,:,:,126),wf(:,-5),G1(:,:,:,129),gX)
  call loop_SQ_A(G1(:,:,:,129),wf(:,-2),G1(:,:,:,130),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MT,G2tensor(:,51))
  call loop_QA_Z(G1(:,:,:,126),wf(:,-5),G1(:,:,:,131),gZu)
  call loop_ZQ_A(G1(:,:,:,131),wf(:,-2),G1(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,132),Q(:,63),MT,G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,384),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,27),MB,G1(:,:,:,133))
  call loop_QA_S(G1(:,:,:,133),wf(:,-5),G1(:,:,:,134),gPtb)
  call loop_SQ_A(G1(:,:,:,134),wf(:,-2),G1(:,:,:,135),gPbt)
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),MB,G2tensor(:,53))
  call loop_QA_W(G1(:,:,:,133),wf(:,-5),G1(:,:,:,136))
  call loop_WQ_A(G1(:,:,:,136),wf(:,-2),G1(:,:,:,137))
  call check_last_Q_A(l_switch,G1(:,:,:,137),Q(:,63),MB,G2tensor(:,54))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,384),Q(:,27),G1(:,:,:,138))
  call loop_VA_Q(G1(:,:,:,138),wf(:,-5),G1(:,:,:,139))
  call loop_A_Q(G1(:,:,:,139),Q(:,59),MT,G2(:,:,:,160))
  call check_last_AQ_V(l_switch,G2(:,:,:,160),wf(:,-2),G2tensor(:,55))
  call loop_VA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,16),MT,G1(:,:,:,140))
  call loop_AS_Q(G1(:,:,:,140),wf(:,49),G1(:,:,:,141),gH)
  call loop_A_Q(G1(:,:,:,141),Q(:,52),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,8),G2tensor(:,56))
  call loop_AV_Q(G2(:,:,:,161),wf(:,1),G2(:,:,:,162))
  call loop_A_Q(G2(:,:,:,162),Q(:,55),MT,G3(:,:,:,47))
  call check_last_AQ_V(l_switch,G3(:,:,:,47),wf(:,-3),G3tensor(:,83))
  call loop_AQ_V(G2(:,:,:,161),wf(:,-3),G2(:,:,:,163))
  call loop_VA_Q(G2(:,:,:,163),wf(:,-1),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,62),ZERO,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,0),G3tensor(:,84))
  call loop_AS_Q(G1(:,:,:,140),wf(:,51),G1(:,:,:,142),gX)
  call loop_A_Q(G1(:,:,:,142),Q(:,52),MT,G2(:,:,:,165))
  call check_last_AQ_V(l_switch,G2(:,:,:,165),wf(:,8),G2tensor(:,57))
  call loop_AV_Q(G2(:,:,:,165),wf(:,1),G2(:,:,:,166))
  call loop_A_Q(G2(:,:,:,166),Q(:,55),MT,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,-3),G3tensor(:,85))
  call loop_AQ_V(G2(:,:,:,165),wf(:,-3),G2(:,:,:,167))
  call loop_VA_Q(G2(:,:,:,167),wf(:,-1),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,62),ZERO,G3(:,:,:,50))
  call check_last_AQ_V(l_switch,G3(:,:,:,50),wf(:,0),G3tensor(:,86))
  call loop_AV_Q(G1(:,:,:,140),wf(:,27),G1(:,:,:,143))
  call loop_A_Q(G1(:,:,:,143),Q(:,52),MT,G2(:,:,:,169))
  call check_last_AQ_V(l_switch,G2(:,:,:,169),wf(:,8),G2tensor(:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,169),wf(:,14),G2tensor(:,59))
  call loop_AV_Q(G2(:,:,:,169),wf(:,1),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,55),MT,G3(:,:,:,51))
  call check_last_AQ_V(l_switch,G3(:,:,:,51),wf(:,-3),G3tensor(:,87))
  call loop_AZ_Q(G2(:,:,:,169),wf(:,12),G2(:,:,:,171),gZu)
  call loop_A_Q(G2(:,:,:,171),Q(:,55),MT,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,-3),G3tensor(:,88))
  call loop_AQ_Z(G2(:,:,:,169),wf(:,-3),G2(:,:,:,172),gZu)
  call loop_ZQ_A(G2(:,:,:,172),wf(:,0),G2(:,:,:,173),gZu)
  call loop_Q_A(G2(:,:,:,173),Q(:,61),ZERO,G3(:,:,:,53))
  call check_last_QA_V(l_switch,G3(:,:,:,53),wf(:,-1),G3tensor(:,89))
  call loop_ZA_Q(G2(:,:,:,172),wf(:,-1),G2(:,:,:,174),gZu)
  call loop_A_Q(G2(:,:,:,174),Q(:,62),ZERO,G3(:,:,:,54))
  call check_last_AQ_V(l_switch,G3(:,:,:,54),wf(:,0),G3tensor(:,90))
  call loop_AQ_V(G2(:,:,:,169),wf(:,-3),G2(:,:,:,175))
  call loop_VA_Q(G2(:,:,:,175),wf(:,-1),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,62),ZERO,G3(:,:,:,55))
  call check_last_AQ_V(l_switch,G3(:,:,:,55),wf(:,0),G3tensor(:,91))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,54),G1(:,:,:,144),gZu)
  call loop_A_Q(G1(:,:,:,144),Q(:,52),MT,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,8),G2tensor(:,60))
  call loop_AV_Q(G2(:,:,:,177),wf(:,1),G2(:,:,:,178))
  call loop_A_Q(G2(:,:,:,178),Q(:,55),MT,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,-3),G3tensor(:,92))
  call loop_AQ_V(G2(:,:,:,177),wf(:,-3),G2(:,:,:,179))
  call loop_VA_Q(G2(:,:,:,179),wf(:,-1),G2(:,:,:,180))
  call loop_A_Q(G2(:,:,:,180),Q(:,62),ZERO,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,93))
  call loop_AQ_V(G1(:,:,:,140),wf(:,58),G1(:,:,:,145))
  call check_last_UV_W(l_switch,G1(:,:,:,145),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,61))
  call loop_VA_Q(G1(:,:,:,145),wf(:,-1),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,62),ZERO,G2(:,:,:,181))
  call check_last_AQ_V(l_switch,G2(:,:,:,181),wf(:,0),G2tensor(:,62))
  call loop_AQ_V(G1(:,:,:,140),wf(:,60),G1(:,:,:,147))
  call check_last_UV_W(l_switch,G1(:,:,:,147),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,63))
  call loop_VA_Q(G1(:,:,:,147),wf(:,-1),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,62),ZERO,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,0),G2tensor(:,64))
  call loop_AQ_V(G1(:,:,:,140),wf(:,62),G1(:,:,:,149))
  call check_last_UV_W(l_switch,G1(:,:,:,149),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,65))
  call loop_VA_Q(G1(:,:,:,149),wf(:,-1),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,62),ZERO,G2(:,:,:,183))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,0),G2tensor(:,66))
  call loop_AQ_V(G1(:,:,:,140),wf(:,65),G1(:,:,:,151))
  call check_last_UV_W(l_switch,G1(:,:,:,151),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,67))
  call loop_VA_Q(G1(:,:,:,151),wf(:,-1),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,62),ZERO,G2(:,:,:,184))
  call check_last_AQ_V(l_switch,G2(:,:,:,184),wf(:,0),G2tensor(:,68))
  call loop_AV_Q(G1(:,:,:,140),wf(:,29),G1(:,:,:,153))
  call loop_A_Q(G1(:,:,:,153),Q(:,55),MT,G2(:,:,:,185))
  call check_last_AQ_V(l_switch,G2(:,:,:,185),wf(:,-3),G2tensor(:,69))
  call loop_AV_Q(G1(:,:,:,140),wf(:,1),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,19),MT,G2(:,:,:,186))
  call loop_AS_Q(G2(:,:,:,186),wf(:,49),G2(:,:,:,187),gH)
  call loop_A_Q(G2(:,:,:,187),Q(:,55),MT,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,-3),G3tensor(:,94))
  call loop_AS_Q(G2(:,:,:,186),wf(:,51),G2(:,:,:,188),gX)
  call loop_A_Q(G2(:,:,:,188),Q(:,55),MT,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,-3),G3tensor(:,95))
  call loop_AV_Q(G2(:,:,:,186),wf(:,27),G2(:,:,:,189))
  call loop_A_Q(G2(:,:,:,189),Q(:,55),MT,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,-3),G3tensor(:,96))
  call loop_AZ_Q(G2(:,:,:,186),wf(:,54),G2(:,:,:,190),gZu)
  call loop_A_Q(G2(:,:,:,190),Q(:,55),MT,G3(:,:,:,61))
  call check_last_AQ_V(l_switch,G3(:,:,:,61),wf(:,-3),G3tensor(:,97))
  call loop_AS_Q(G2(:,:,:,186),wf(:,66),G2(:,:,:,191),gH)
  call loop_A_Q(G2(:,:,:,191),Q(:,59),MT,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,-2),G3tensor(:,98))
  call loop_AS_Q(G2(:,:,:,186),wf(:,68),G2(:,:,:,192),gX)
  call loop_A_Q(G2(:,:,:,192),Q(:,59),MT,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,-2),G3tensor(:,99))
  call loop_AV_Q(G2(:,:,:,186),wf(:,3),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,59),MT,G3(:,:,:,64))
  call check_last_AQ_V(l_switch,G3(:,:,:,64),wf(:,-2),G3tensor(:,100))
  call loop_AZ_Q(G2(:,:,:,186),wf(:,71),G2(:,:,:,194),gZu)
  call loop_A_Q(G2(:,:,:,194),Q(:,59),MT,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,-2),G3tensor(:,101))
  call loop_AQ_S(G2(:,:,:,186),wf(:,-3),G2(:,:,:,195),gH)
  call loop_SA_Q(G2(:,:,:,195),wf(:,-5),G2(:,:,:,196),gH)
  call loop_A_Q(G2(:,:,:,196),Q(:,59),MT,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,-2),G3tensor(:,102))
  call loop_AQ_S(G2(:,:,:,186),wf(:,-3),G2(:,:,:,197),gX)
  call loop_SA_Q(G2(:,:,:,197),wf(:,-5),G2(:,:,:,198),gX)
  call loop_A_Q(G2(:,:,:,198),Q(:,59),MT,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,-2),G3tensor(:,103))
  call loop_AQ_V(G2(:,:,:,186),wf(:,-3),G2(:,:,:,199))
  call loop_VA_Q(G2(:,:,:,199),wf(:,-5),G2(:,:,:,200))
  call loop_A_Q(G2(:,:,:,200),Q(:,59),MT,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,-2),G3tensor(:,104))
  call loop_AQ_Z(G2(:,:,:,186),wf(:,-3),G2(:,:,:,201),gZu)
  call loop_ZA_Q(G2(:,:,:,201),wf(:,-5),G2(:,:,:,202),gZu)
  call loop_A_Q(G2(:,:,:,202),Q(:,59),MT,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,-2),G3tensor(:,105))
  call loop_AQ_S(G2(:,:,:,186),wf(:,-2),G2(:,:,:,203),gH)
  call loop_SA_Q(G2(:,:,:,203),wf(:,-5),G2(:,:,:,204),gH)
  call loop_A_Q(G2(:,:,:,204),Q(:,55),MT,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,-3),G3tensor(:,106))
  call loop_AQ_S(G2(:,:,:,186),wf(:,-2),G2(:,:,:,205),gX)
  call loop_SA_Q(G2(:,:,:,205),wf(:,-5),G2(:,:,:,206),gX)
  call loop_A_Q(G2(:,:,:,206),Q(:,55),MT,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,-3),G3tensor(:,107))
  call loop_AQ_Z(G2(:,:,:,186),wf(:,-2),G2(:,:,:,207),gZu)
  call loop_ZA_Q(G2(:,:,:,207),wf(:,-5),G2(:,:,:,208),gZu)
  call loop_A_Q(G2(:,:,:,208),Q(:,55),MT,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,-3),G3tensor(:,108))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,12),G1(:,:,:,155),gZu)
  call loop_A_Q(G1(:,:,:,155),Q(:,19),MT,G2(:,:,:,209))
  call loop_AV_Q(G2(:,:,:,209),wf(:,27),G2(:,:,:,210))
  call loop_A_Q(G2(:,:,:,210),Q(:,55),MT,G3(:,:,:,73))
  call check_last_AQ_V(l_switch,G3(:,:,:,73),wf(:,-3),G3tensor(:,109))
  call loop_AV_Q(G2(:,:,:,209),wf(:,3),G2(:,:,:,211))
  call loop_A_Q(G2(:,:,:,211),Q(:,59),MT,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,-2),G3tensor(:,110))
  call loop_AQ_V(G2(:,:,:,209),wf(:,-3),G2(:,:,:,212))
  call loop_VA_Q(G2(:,:,:,212),wf(:,-5),G2(:,:,:,213))
  call loop_A_Q(G2(:,:,:,213),Q(:,59),MT,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,-2),G3tensor(:,111))
  call loop_AQ_V(G1(:,:,:,140),wf(:,-3),G1(:,:,:,156))
  call loop_UV_W(G1(:,:,:,156),Q(:,24),wf(:,27),Q(:,36),G2(:,:,:,214))
  call check_last_UV_W(l_switch,G2(:,:,:,214),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,112))
  call loop_VA_Q(G2(:,:,:,214),wf(:,-1),G2(:,:,:,215))
  call loop_A_Q(G2(:,:,:,215),Q(:,62),ZERO,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,113))
  call loop_VA_Q(G1(:,:,:,156),wf(:,-5),G1(:,:,:,157))
  call loop_A_Q(G1(:,:,:,157),Q(:,56),MT,G2(:,:,:,216))
  call check_last_AQ_V(l_switch,G2(:,:,:,216),wf(:,33),G2tensor(:,70))
  call check_last_AQ_V(l_switch,G2(:,:,:,216),wf(:,38),G2tensor(:,71))
  call loop_AV_Q(G2(:,:,:,216),wf(:,1),G2(:,:,:,217))
  call loop_A_Q(G2(:,:,:,217),Q(:,59),MT,G3(:,:,:,77))
  call check_last_AQ_V(l_switch,G3(:,:,:,77),wf(:,-2),G3tensor(:,114))
  call loop_AZ_Q(G2(:,:,:,216),wf(:,12),G2(:,:,:,218),gZu)
  call loop_A_Q(G2(:,:,:,218),Q(:,59),MT,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,-2),G3tensor(:,115))
  call loop_AQ_Z(G2(:,:,:,216),wf(:,-2),G2(:,:,:,219),gZu)
  call loop_ZQ_A(G2(:,:,:,219),wf(:,0),G2(:,:,:,220),gZu)
  call loop_Q_A(G2(:,:,:,220),Q(:,61),ZERO,G3(:,:,:,79))
  call check_last_QA_V(l_switch,G3(:,:,:,79),wf(:,-1),G3tensor(:,116))
  call loop_ZA_Q(G2(:,:,:,219),wf(:,-1),G2(:,:,:,221),gZu)
  call loop_A_Q(G2(:,:,:,221),Q(:,62),ZERO,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,117))
  call loop_AQ_V(G2(:,:,:,216),wf(:,-2),G2(:,:,:,222))
  call loop_VA_Q(G2(:,:,:,222),wf(:,-1),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,62),ZERO,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,0),G3tensor(:,118))
  call loop_VA_Q(G1(:,:,:,156),wf(:,144),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,59),MT,G2(:,:,:,224))
  call check_last_AQ_V(l_switch,G2(:,:,:,224),wf(:,-2),G2tensor(:,72))
  call loop_VA_Q(G1(:,:,:,156),wf(:,147),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,59),MT,G2(:,:,:,225))
  call check_last_AQ_V(l_switch,G2(:,:,:,225),wf(:,-2),G2tensor(:,73))
  call loop_VQ_A(G1(:,:,:,156),wf(:,-2),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,28),MT,G2(:,:,:,226))
  call loop_QA_V(G2(:,:,:,226),wf(:,-5),G2(:,:,:,227))
  call check_last_UV_W(l_switch,G2(:,:,:,227),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,119))
  call loop_VA_Q(G2(:,:,:,227),wf(:,-1),G2(:,:,:,228))
  call loop_A_Q(G2(:,:,:,228),Q(:,62),ZERO,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,0),G3tensor(:,120))
  call loop_QA_Z(G2(:,:,:,226),wf(:,-5),G2(:,:,:,229),gZu)
  call loop_ZA_Q(G2(:,:,:,229),wf(:,-1),G2(:,:,:,230),gZu)
  call loop_A_Q(G2(:,:,:,230),Q(:,62),ZERO,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,0),G3tensor(:,121))
  call loop_ZQ_A(G2(:,:,:,229),wf(:,0),G2(:,:,:,231),gZu)
  call loop_Q_A(G2(:,:,:,231),Q(:,61),ZERO,G3(:,:,:,84))
  call check_last_QA_V(l_switch,G3(:,:,:,84),wf(:,-1),G3tensor(:,122))
  call loop_VQ_A(G1(:,:,:,156),wf(:,95),G1(:,:,:,161))
  call loop_Q_A(G1(:,:,:,161),Q(:,61),ZERO,G2(:,:,:,232))
  call check_last_QA_V(l_switch,G2(:,:,:,232),wf(:,-1),G2tensor(:,74))
  call loop_VQ_A(G1(:,:,:,156),wf(:,97),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,61),ZERO,G2(:,:,:,233))
  call check_last_QA_V(l_switch,G2(:,:,:,233),wf(:,-1),G2tensor(:,75))
  call loop_VA_Q(G1(:,:,:,156),wf(:,337),G1(:,:,:,163))
  call loop_A_Q(G1(:,:,:,163),Q(:,62),ZERO,G2(:,:,:,234))
  call check_last_AQ_V(l_switch,G2(:,:,:,234),wf(:,0),G2tensor(:,76))
  call loop_VA_Q(G1(:,:,:,156),wf(:,339),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,62),ZERO,G2(:,:,:,235))
  call check_last_AQ_V(l_switch,G2(:,:,:,235),wf(:,0),G2tensor(:,77))
  call loop_VA_Q(G1(:,:,:,156),wf(:,-1),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,26),ZERO,G2(:,:,:,236))
  call loop_AV_Q(G2(:,:,:,236),wf(:,27),G2(:,:,:,237))
  call loop_A_Q(G2(:,:,:,237),Q(:,62),ZERO,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,0),G3tensor(:,123))
  call loop_AZ_Q(G2(:,:,:,236),wf(:,54),G2(:,:,:,238),gZu)
  call loop_A_Q(G2(:,:,:,238),Q(:,62),ZERO,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,0),G3tensor(:,124))
  call loop_AS_Q(G1(:,:,:,140),wf(:,66),G1(:,:,:,166),gH)
  call loop_A_Q(G1(:,:,:,166),Q(:,56),MT,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,33),G2tensor(:,78))
  call loop_AV_Q(G2(:,:,:,239),wf(:,1),G2(:,:,:,240))
  call loop_A_Q(G2(:,:,:,240),Q(:,59),MT,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,-2),G3tensor(:,125))
  call loop_AQ_V(G2(:,:,:,239),wf(:,-2),G2(:,:,:,241))
  call loop_VA_Q(G2(:,:,:,241),wf(:,-1),G2(:,:,:,242))
  call loop_A_Q(G2(:,:,:,242),Q(:,62),ZERO,G3(:,:,:,88))
  call check_last_AQ_V(l_switch,G3(:,:,:,88),wf(:,0),G3tensor(:,126))
  call loop_AS_Q(G1(:,:,:,140),wf(:,68),G1(:,:,:,167),gX)
  call loop_A_Q(G1(:,:,:,167),Q(:,56),MT,G2(:,:,:,243))
  call check_last_AQ_V(l_switch,G2(:,:,:,243),wf(:,33),G2tensor(:,79))
  call loop_AV_Q(G2(:,:,:,243),wf(:,1),G2(:,:,:,244))
  call loop_A_Q(G2(:,:,:,244),Q(:,59),MT,G3(:,:,:,89))
  call check_last_AQ_V(l_switch,G3(:,:,:,89),wf(:,-2),G3tensor(:,127))
  call loop_AQ_V(G2(:,:,:,243),wf(:,-2),G2(:,:,:,245))
  call loop_VA_Q(G2(:,:,:,245),wf(:,-1),G2(:,:,:,246))
  call loop_A_Q(G2(:,:,:,246),Q(:,62),ZERO,G3(:,:,:,90))
  call check_last_AQ_V(l_switch,G3(:,:,:,90),wf(:,0),G3tensor(:,128))
  call loop_AV_Q(G1(:,:,:,140),wf(:,3),G1(:,:,:,168))
  call loop_A_Q(G1(:,:,:,168),Q(:,56),MT,G2(:,:,:,247))
  call check_last_AQ_V(l_switch,G2(:,:,:,247),wf(:,33),G2tensor(:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,247),wf(:,38),G2tensor(:,81))
  call loop_AV_Q(G2(:,:,:,247),wf(:,1),G2(:,:,:,248))
  call loop_A_Q(G2(:,:,:,248),Q(:,59),MT,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,-2),G3tensor(:,129))
  call loop_AZ_Q(G2(:,:,:,247),wf(:,12),G2(:,:,:,249),gZu)
  call loop_A_Q(G2(:,:,:,249),Q(:,59),MT,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,-2),G3tensor(:,130))
  call loop_AQ_Z(G2(:,:,:,247),wf(:,-2),G2(:,:,:,250),gZu)
  call loop_ZQ_A(G2(:,:,:,250),wf(:,0),G2(:,:,:,251),gZu)
  call loop_Q_A(G2(:,:,:,251),Q(:,61),ZERO,G3(:,:,:,93))
  call check_last_QA_V(l_switch,G3(:,:,:,93),wf(:,-1),G3tensor(:,131))
  call loop_ZA_Q(G2(:,:,:,250),wf(:,-1),G2(:,:,:,252),gZu)
  call loop_A_Q(G2(:,:,:,252),Q(:,62),ZERO,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,0),G3tensor(:,132))
  call loop_AQ_V(G2(:,:,:,247),wf(:,-2),G2(:,:,:,253))
  call loop_VA_Q(G2(:,:,:,253),wf(:,-1),G2(:,:,:,254))
  call loop_A_Q(G2(:,:,:,254),Q(:,62),ZERO,G3(:,:,:,95))
  call check_last_AQ_V(l_switch,G3(:,:,:,95),wf(:,0),G3tensor(:,133))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,71),G1(:,:,:,169),gZu)
  call loop_A_Q(G1(:,:,:,169),Q(:,56),MT,G2(:,:,:,255))
  call check_last_AQ_V(l_switch,G2(:,:,:,255),wf(:,33),G2tensor(:,82))
  call loop_AV_Q(G2(:,:,:,255),wf(:,1),G2(:,:,:,256))
  call loop_A_Q(G2(:,:,:,256),Q(:,59),MT,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,-2),G3tensor(:,134))
  call loop_AQ_V(G2(:,:,:,255),wf(:,-2),G2(:,:,:,257))
  call loop_VA_Q(G2(:,:,:,257),wf(:,-1),G2(:,:,:,258))
  call loop_A_Q(G2(:,:,:,258),Q(:,62),ZERO,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,0),G3tensor(:,135))
  call loop_AQ_V(G1(:,:,:,140),wf(:,74),G1(:,:,:,170))
  call check_last_UV_W(l_switch,G1(:,:,:,170),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,83))
  call loop_VA_Q(G1(:,:,:,170),wf(:,-1),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,62),ZERO,G2(:,:,:,259))
  call check_last_AQ_V(l_switch,G2(:,:,:,259),wf(:,0),G2tensor(:,84))
  call loop_AQ_V(G1(:,:,:,140),wf(:,76),G1(:,:,:,172))
  call check_last_UV_W(l_switch,G1(:,:,:,172),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,85))
  call loop_VA_Q(G1(:,:,:,172),wf(:,-1),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,62),ZERO,G2(:,:,:,260))
  call check_last_AQ_V(l_switch,G2(:,:,:,260),wf(:,0),G2tensor(:,86))
  call loop_AQ_V(G1(:,:,:,140),wf(:,78),G1(:,:,:,174))
  call check_last_UV_W(l_switch,G1(:,:,:,174),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,87))
  call loop_VA_Q(G1(:,:,:,174),wf(:,-1),G1(:,:,:,175))
  call loop_A_Q(G1(:,:,:,175),Q(:,62),ZERO,G2(:,:,:,261))
  call check_last_AQ_V(l_switch,G2(:,:,:,261),wf(:,0),G2tensor(:,88))
  call loop_AQ_V(G1(:,:,:,140),wf(:,80),G1(:,:,:,176))
  call check_last_UV_W(l_switch,G1(:,:,:,176),Q(:,60),wf(:,1),Q(:,3),G2tensor(:,89))
  call loop_VA_Q(G1(:,:,:,176),wf(:,-1),G1(:,:,:,177))
  call loop_A_Q(G1(:,:,:,177),Q(:,62),ZERO,G2(:,:,:,262))
  call check_last_AQ_V(l_switch,G2(:,:,:,262),wf(:,0),G2tensor(:,90))
  call loop_AV_Q(G1(:,:,:,140),wf(:,368),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,59),MT,G2(:,:,:,263))
  call check_last_AQ_V(l_switch,G2(:,:,:,263),wf(:,-2),G2tensor(:,91))
  call loop_AQ_V(G1(:,:,:,140),wf(:,-2),G1(:,:,:,179))
  call loop_UV_W(G1(:,:,:,179),Q(:,20),wf(:,3),Q(:,40),G2(:,:,:,264))
  call check_last_UV_W(l_switch,G2(:,:,:,264),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,136))
  call loop_VA_Q(G2(:,:,:,264),wf(:,-1),G2(:,:,:,265))
  call loop_A_Q(G2(:,:,:,265),Q(:,62),ZERO,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,0),G3tensor(:,137))
  call loop_VQ_A(G1(:,:,:,179),wf(:,-3),G1(:,:,:,180))
  call loop_Q_A(G1(:,:,:,180),Q(:,28),MT,G2(:,:,:,266))
  call loop_QA_V(G2(:,:,:,266),wf(:,-5),G2(:,:,:,267))
  call check_last_UV_W(l_switch,G2(:,:,:,267),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,138))
  call loop_VA_Q(G2(:,:,:,267),wf(:,-1),G2(:,:,:,268))
  call loop_A_Q(G2(:,:,:,268),Q(:,62),ZERO,G3(:,:,:,99))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,0),G3tensor(:,139))
  call loop_QA_Z(G2(:,:,:,266),wf(:,-5),G2(:,:,:,269),gZu)
  call loop_ZA_Q(G2(:,:,:,269),wf(:,-1),G2(:,:,:,270),gZu)
  call loop_A_Q(G2(:,:,:,270),Q(:,62),ZERO,G3(:,:,:,100))
  call check_last_AQ_V(l_switch,G3(:,:,:,100),wf(:,0),G3tensor(:,140))
  call loop_ZQ_A(G2(:,:,:,269),wf(:,0),G2(:,:,:,271),gZu)
  call loop_Q_A(G2(:,:,:,271),Q(:,61),ZERO,G3(:,:,:,101))
  call check_last_QA_V(l_switch,G3(:,:,:,101),wf(:,-1),G3tensor(:,141))
  call loop_VQ_A(G1(:,:,:,179),wf(:,89),G1(:,:,:,181))
  call loop_Q_A(G1(:,:,:,181),Q(:,61),ZERO,G2(:,:,:,272))
  call check_last_QA_V(l_switch,G2(:,:,:,272),wf(:,-1),G2tensor(:,92))
  call loop_VQ_A(G1(:,:,:,179),wf(:,91),G1(:,:,:,182))
  call loop_Q_A(G1(:,:,:,182),Q(:,61),ZERO,G2(:,:,:,273))
  call check_last_QA_V(l_switch,G2(:,:,:,273),wf(:,-1),G2tensor(:,93))
  call loop_VA_Q(G1(:,:,:,179),wf(:,322),G1(:,:,:,183))
  call loop_A_Q(G1(:,:,:,183),Q(:,62),ZERO,G2(:,:,:,274))
  call check_last_AQ_V(l_switch,G2(:,:,:,274),wf(:,0),G2tensor(:,94))
  call loop_VA_Q(G1(:,:,:,179),wf(:,324),G1(:,:,:,184))
  call loop_A_Q(G1(:,:,:,184),Q(:,62),ZERO,G2(:,:,:,275))
  call check_last_AQ_V(l_switch,G2(:,:,:,275),wf(:,0),G2tensor(:,95))
  call loop_VA_Q(G1(:,:,:,179),wf(:,-1),G1(:,:,:,185))
  call loop_A_Q(G1(:,:,:,185),Q(:,22),ZERO,G2(:,:,:,276))
  call loop_AV_Q(G2(:,:,:,276),wf(:,3),G2(:,:,:,277))
  call loop_A_Q(G2(:,:,:,277),Q(:,62),ZERO,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,0),G3tensor(:,142))
  call loop_AZ_Q(G2(:,:,:,276),wf(:,71),G2(:,:,:,278),gZu)
  call loop_A_Q(G2(:,:,:,278),Q(:,62),ZERO,G3(:,:,:,103))
  call check_last_AQ_V(l_switch,G3(:,:,:,103),wf(:,0),G3tensor(:,143))
  call loop_VA_Q(G1(:,:,:,179),wf(:,-5),G1(:,:,:,186))
  call loop_A_Q(G1(:,:,:,186),Q(:,52),MT,G2(:,:,:,279))
  call loop_AQ_Z(G2(:,:,:,279),wf(:,-3),G2(:,:,:,280),gZu)
  call loop_ZQ_A(G2(:,:,:,280),wf(:,0),G2(:,:,:,281),gZu)
  call loop_Q_A(G2(:,:,:,281),Q(:,61),ZERO,G3(:,:,:,104))
  call check_last_QA_V(l_switch,G3(:,:,:,104),wf(:,-1),G3tensor(:,144))
  call loop_ZA_Q(G2(:,:,:,280),wf(:,-1),G2(:,:,:,282),gZu)
  call loop_A_Q(G2(:,:,:,282),Q(:,62),ZERO,G3(:,:,:,105))
  call check_last_AQ_V(l_switch,G3(:,:,:,105),wf(:,0),G3tensor(:,145))
  call loop_AQ_V(G2(:,:,:,279),wf(:,-3),G2(:,:,:,283))
  call loop_VA_Q(G2(:,:,:,283),wf(:,-1),G2(:,:,:,284))
  call loop_A_Q(G2(:,:,:,284),Q(:,62),ZERO,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,0),G3tensor(:,146))
  call loop_AS_Q(G1(:,:,:,140),wf(:,438),G1(:,:,:,187),gH)
  call loop_A_Q(G1(:,:,:,187),Q(:,55),MT,G2(:,:,:,285))
  call check_last_AQ_V(l_switch,G2(:,:,:,285),wf(:,-3),G2tensor(:,96))
  call loop_AS_Q(G1(:,:,:,140),wf(:,439),G1(:,:,:,188),gX)
  call loop_A_Q(G1(:,:,:,188),Q(:,55),MT,G2(:,:,:,286))
  call check_last_AQ_V(l_switch,G2(:,:,:,286),wf(:,-3),G2tensor(:,97))
  call loop_AV_Q(G1(:,:,:,140),wf(:,440),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,55),MT,G2(:,:,:,287))
  call check_last_AQ_V(l_switch,G2(:,:,:,287),wf(:,-3),G2tensor(:,98))
  call loop_AV_Q(G1(:,:,:,140),wf(:,441),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,55),MT,G2(:,:,:,288))
  call check_last_AQ_V(l_switch,G2(:,:,:,288),wf(:,-3),G2tensor(:,99))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,442),G1(:,:,:,191),gZu)
  call loop_A_Q(G1(:,:,:,191),Q(:,55),MT,G2(:,:,:,289))
  call check_last_AQ_V(l_switch,G2(:,:,:,289),wf(:,-3),G2tensor(:,100))
  call loop_AQ_S(G1(:,:,:,140),wf(:,-3),G1(:,:,:,192),gH)
  call loop_SA_Q(G1(:,:,:,192),wf(:,-5),G1(:,:,:,193),gH)
  call loop_A_Q(G1(:,:,:,193),Q(:,56),MT,G2(:,:,:,290))
  call check_last_AQ_V(l_switch,G2(:,:,:,290),wf(:,33),G2tensor(:,101))
  call loop_AV_Q(G2(:,:,:,290),wf(:,1),G2(:,:,:,291))
  call loop_A_Q(G2(:,:,:,291),Q(:,59),MT,G3(:,:,:,107))
  call check_last_AQ_V(l_switch,G3(:,:,:,107),wf(:,-2),G3tensor(:,147))
  call loop_AQ_V(G2(:,:,:,290),wf(:,-2),G2(:,:,:,292))
  call loop_VA_Q(G2(:,:,:,292),wf(:,-1),G2(:,:,:,293))
  call loop_A_Q(G2(:,:,:,293),Q(:,62),ZERO,G3(:,:,:,108))
  call check_last_AQ_V(l_switch,G3(:,:,:,108),wf(:,0),G3tensor(:,148))
  call loop_SA_Q(G1(:,:,:,192),wf(:,144),G1(:,:,:,194),gH)
  call loop_A_Q(G1(:,:,:,194),Q(:,59),MT,G2(:,:,:,294))
  call check_last_AQ_V(l_switch,G2(:,:,:,294),wf(:,-2),G2tensor(:,102))
  call loop_SQ_A(G1(:,:,:,192),wf(:,-2),G1(:,:,:,195),gH)
  call loop_Q_A(G1(:,:,:,195),Q(:,28),MT,G2(:,:,:,295))
  call loop_QA_V(G2(:,:,:,295),wf(:,-5),G2(:,:,:,296))
  call check_last_UV_W(l_switch,G2(:,:,:,296),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,149))
  call loop_VA_Q(G2(:,:,:,296),wf(:,-1),G2(:,:,:,297))
  call loop_A_Q(G2(:,:,:,297),Q(:,62),ZERO,G3(:,:,:,109))
  call check_last_AQ_V(l_switch,G3(:,:,:,109),wf(:,0),G3tensor(:,150))
  call loop_AQ_S(G1(:,:,:,140),wf(:,-3),G1(:,:,:,196),gX)
  call loop_SA_Q(G1(:,:,:,196),wf(:,-5),G1(:,:,:,197),gX)
  call loop_A_Q(G1(:,:,:,197),Q(:,56),MT,G2(:,:,:,298))
  call check_last_AQ_V(l_switch,G2(:,:,:,298),wf(:,33),G2tensor(:,103))
  call loop_AV_Q(G2(:,:,:,298),wf(:,1),G2(:,:,:,299))
  call loop_A_Q(G2(:,:,:,299),Q(:,59),MT,G3(:,:,:,110))
  call check_last_AQ_V(l_switch,G3(:,:,:,110),wf(:,-2),G3tensor(:,151))
  call loop_AQ_V(G2(:,:,:,298),wf(:,-2),G2(:,:,:,300))
  call loop_VA_Q(G2(:,:,:,300),wf(:,-1),G2(:,:,:,301))
  call loop_A_Q(G2(:,:,:,301),Q(:,62),ZERO,G3(:,:,:,111))
  call check_last_AQ_V(l_switch,G3(:,:,:,111),wf(:,0),G3tensor(:,152))
  call loop_SA_Q(G1(:,:,:,196),wf(:,144),G1(:,:,:,198),gX)
  call loop_A_Q(G1(:,:,:,198),Q(:,59),MT,G2(:,:,:,302))
  call check_last_AQ_V(l_switch,G2(:,:,:,302),wf(:,-2),G2tensor(:,104))
  call loop_SQ_A(G1(:,:,:,196),wf(:,-2),G1(:,:,:,199),gX)
  call loop_Q_A(G1(:,:,:,199),Q(:,28),MT,G2(:,:,:,303))
  call loop_QA_V(G2(:,:,:,303),wf(:,-5),G2(:,:,:,304))
  call check_last_UV_W(l_switch,G2(:,:,:,304),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,153))
  call loop_VA_Q(G2(:,:,:,304),wf(:,-1),G2(:,:,:,305))
  call loop_A_Q(G2(:,:,:,305),Q(:,62),ZERO,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,0),G3tensor(:,154))
  call loop_AQ_S(G1(:,:,:,140),wf(:,33),G1(:,:,:,200),gH)
  call loop_SA_Q(G1(:,:,:,200),wf(:,-5),G1(:,:,:,201),gH)
  call loop_A_Q(G1(:,:,:,201),Q(:,55),MT,G2(:,:,:,306))
  call check_last_AQ_V(l_switch,G2(:,:,:,306),wf(:,-3),G2tensor(:,105))
  call loop_AQ_S(G1(:,:,:,140),wf(:,33),G1(:,:,:,202),gX)
  call loop_SA_Q(G1(:,:,:,202),wf(:,-5),G1(:,:,:,203),gX)
  call loop_A_Q(G1(:,:,:,203),Q(:,55),MT,G2(:,:,:,307))
  call check_last_AQ_V(l_switch,G2(:,:,:,307),wf(:,-3),G2tensor(:,106))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,-3),G1(:,:,:,204),gZu)
  call loop_ZA_Q(G1(:,:,:,204),wf(:,-5),G1(:,:,:,205),gZu)
  call loop_A_Q(G1(:,:,:,205),Q(:,56),MT,G2(:,:,:,308))
  call check_last_AQ_V(l_switch,G2(:,:,:,308),wf(:,33),G2tensor(:,107))
  call loop_AV_Q(G2(:,:,:,308),wf(:,1),G2(:,:,:,309))
  call loop_A_Q(G2(:,:,:,309),Q(:,59),MT,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,-2),G3tensor(:,155))
  call loop_AQ_V(G2(:,:,:,308),wf(:,-2),G2(:,:,:,310))
  call loop_VA_Q(G2(:,:,:,310),wf(:,-1),G2(:,:,:,311))
  call loop_A_Q(G2(:,:,:,311),Q(:,62),ZERO,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,0),G3tensor(:,156))
  call loop_ZA_Q(G1(:,:,:,204),wf(:,144),G1(:,:,:,206),gZu)
  call loop_A_Q(G1(:,:,:,206),Q(:,59),MT,G2(:,:,:,312))
  call check_last_AQ_V(l_switch,G2(:,:,:,312),wf(:,-2),G2tensor(:,108))
  call loop_ZQ_A(G1(:,:,:,204),wf(:,-2),G1(:,:,:,207),gZu)
  call loop_Q_A(G1(:,:,:,207),Q(:,28),MT,G2(:,:,:,313))
  call loop_QA_V(G2(:,:,:,313),wf(:,-5),G2(:,:,:,314))
  call check_last_UV_W(l_switch,G2(:,:,:,314),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,157))
  call loop_VA_Q(G2(:,:,:,314),wf(:,-1),G2(:,:,:,315))
  call loop_A_Q(G2(:,:,:,315),Q(:,62),ZERO,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,0),G3tensor(:,158))
  call loop_ZQ_A(G1(:,:,:,204),wf(:,95),G1(:,:,:,208),gZu)
  call loop_Q_A(G1(:,:,:,208),Q(:,61),ZERO,G2(:,:,:,316))
  call check_last_QA_V(l_switch,G2(:,:,:,316),wf(:,-1),G2tensor(:,109))
  call loop_ZA_Q(G1(:,:,:,204),wf(:,337),G1(:,:,:,209),gZu)
  call loop_A_Q(G1(:,:,:,209),Q(:,62),ZERO,G2(:,:,:,317))
  call check_last_AQ_V(l_switch,G2(:,:,:,317),wf(:,0),G2tensor(:,110))
  call loop_ZQ_A(G1(:,:,:,204),wf(:,0),G1(:,:,:,210),gZu)
  call loop_Q_A(G1(:,:,:,210),Q(:,25),ZERO,G2(:,:,:,318))
  call loop_QV_A(G2(:,:,:,318),wf(:,27),G2(:,:,:,319))
  call loop_Q_A(G2(:,:,:,319),Q(:,61),ZERO,G3(:,:,:,116))
  call check_last_QA_V(l_switch,G3(:,:,:,116),wf(:,-1),G3tensor(:,159))
  call loop_ZA_Q(G1(:,:,:,204),wf(:,-1),G1(:,:,:,211),gZu)
  call loop_A_Q(G1(:,:,:,211),Q(:,26),ZERO,G2(:,:,:,320))
  call loop_AV_Q(G2(:,:,:,320),wf(:,27),G2(:,:,:,321))
  call loop_A_Q(G2(:,:,:,321),Q(:,62),ZERO,G3(:,:,:,117))
  call check_last_AQ_V(l_switch,G3(:,:,:,117),wf(:,0),G3tensor(:,160))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,33),G1(:,:,:,212),gZu)
  call loop_ZA_Q(G1(:,:,:,212),wf(:,-5),G1(:,:,:,213),gZu)
  call loop_A_Q(G1(:,:,:,213),Q(:,55),MT,G2(:,:,:,322))
  call check_last_AQ_V(l_switch,G2(:,:,:,322),wf(:,-3),G2tensor(:,111))
  call loop_AS_Q(G1(:,:,:,140),wf(:,448),G1(:,:,:,214),gH)
  call loop_A_Q(G1(:,:,:,214),Q(:,59),MT,G2(:,:,:,323))
  call check_last_AQ_V(l_switch,G2(:,:,:,323),wf(:,-2),G2tensor(:,112))
  call loop_AS_Q(G1(:,:,:,140),wf(:,449),G1(:,:,:,215),gX)
  call loop_A_Q(G1(:,:,:,215),Q(:,59),MT,G2(:,:,:,324))
  call check_last_AQ_V(l_switch,G2(:,:,:,324),wf(:,-2),G2tensor(:,113))
  call loop_AV_Q(G1(:,:,:,140),wf(:,450),G1(:,:,:,216))
  call loop_A_Q(G1(:,:,:,216),Q(:,59),MT,G2(:,:,:,325))
  call check_last_AQ_V(l_switch,G2(:,:,:,325),wf(:,-2),G2tensor(:,114))
  call loop_AV_Q(G1(:,:,:,140),wf(:,451),G1(:,:,:,217))
  call loop_A_Q(G1(:,:,:,217),Q(:,59),MT,G2(:,:,:,326))
  call check_last_AQ_V(l_switch,G2(:,:,:,326),wf(:,-2),G2tensor(:,115))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,452),G1(:,:,:,218),gZu)
  call loop_A_Q(G1(:,:,:,218),Q(:,59),MT,G2(:,:,:,327))
  call check_last_AQ_V(l_switch,G2(:,:,:,327),wf(:,-2),G2tensor(:,116))
  call loop_AQ_S(G1(:,:,:,140),wf(:,-2),G1(:,:,:,219),gH)
  call loop_SA_Q(G1(:,:,:,219),wf(:,-5),G1(:,:,:,220),gH)
  call loop_A_Q(G1(:,:,:,220),Q(:,52),MT,G2(:,:,:,328))
  call check_last_AQ_V(l_switch,G2(:,:,:,328),wf(:,8),G2tensor(:,117))
  call loop_AV_Q(G2(:,:,:,328),wf(:,1),G2(:,:,:,329))
  call loop_A_Q(G2(:,:,:,329),Q(:,55),MT,G3(:,:,:,118))
  call check_last_AQ_V(l_switch,G3(:,:,:,118),wf(:,-3),G3tensor(:,161))
  call loop_AQ_V(G2(:,:,:,328),wf(:,-3),G2(:,:,:,330))
  call loop_VA_Q(G2(:,:,:,330),wf(:,-1),G2(:,:,:,331))
  call loop_A_Q(G2(:,:,:,331),Q(:,62),ZERO,G3(:,:,:,119))
  call check_last_AQ_V(l_switch,G3(:,:,:,119),wf(:,0),G3tensor(:,162))
  call loop_SA_Q(G1(:,:,:,219),wf(:,144),G1(:,:,:,221),gH)
  call loop_A_Q(G1(:,:,:,221),Q(:,55),MT,G2(:,:,:,332))
  call check_last_AQ_V(l_switch,G2(:,:,:,332),wf(:,-3),G2tensor(:,118))
  call loop_SQ_A(G1(:,:,:,219),wf(:,-3),G1(:,:,:,222),gH)
  call loop_Q_A(G1(:,:,:,222),Q(:,28),MT,G2(:,:,:,333))
  call loop_QA_V(G2(:,:,:,333),wf(:,-5),G2(:,:,:,334))
  call check_last_UV_W(l_switch,G2(:,:,:,334),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,163))
  call loop_VA_Q(G2(:,:,:,334),wf(:,-1),G2(:,:,:,335))
  call loop_A_Q(G2(:,:,:,335),Q(:,62),ZERO,G3(:,:,:,120))
  call check_last_AQ_V(l_switch,G3(:,:,:,120),wf(:,0),G3tensor(:,164))
  call loop_AQ_S(G1(:,:,:,140),wf(:,-2),G1(:,:,:,223),gX)
  call loop_SA_Q(G1(:,:,:,223),wf(:,-5),G1(:,:,:,224),gX)
  call loop_A_Q(G1(:,:,:,224),Q(:,52),MT,G2(:,:,:,336))
  call check_last_AQ_V(l_switch,G2(:,:,:,336),wf(:,8),G2tensor(:,119))
  call loop_AV_Q(G2(:,:,:,336),wf(:,1),G2(:,:,:,337))
  call loop_A_Q(G2(:,:,:,337),Q(:,55),MT,G3(:,:,:,121))
  call check_last_AQ_V(l_switch,G3(:,:,:,121),wf(:,-3),G3tensor(:,165))
  call loop_AQ_V(G2(:,:,:,336),wf(:,-3),G2(:,:,:,338))
  call loop_VA_Q(G2(:,:,:,338),wf(:,-1),G2(:,:,:,339))
  call loop_A_Q(G2(:,:,:,339),Q(:,62),ZERO,G3(:,:,:,122))
  call check_last_AQ_V(l_switch,G3(:,:,:,122),wf(:,0),G3tensor(:,166))
  call loop_SA_Q(G1(:,:,:,223),wf(:,144),G1(:,:,:,225),gX)
  call loop_A_Q(G1(:,:,:,225),Q(:,55),MT,G2(:,:,:,340))
  call check_last_AQ_V(l_switch,G2(:,:,:,340),wf(:,-3),G2tensor(:,120))
  call loop_SQ_A(G1(:,:,:,223),wf(:,-3),G1(:,:,:,226),gX)
  call loop_Q_A(G1(:,:,:,226),Q(:,28),MT,G2(:,:,:,341))
  call loop_QA_V(G2(:,:,:,341),wf(:,-5),G2(:,:,:,342))
  call check_last_UV_W(l_switch,G2(:,:,:,342),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,167))
  call loop_VA_Q(G2(:,:,:,342),wf(:,-1),G2(:,:,:,343))
  call loop_A_Q(G2(:,:,:,343),Q(:,62),ZERO,G3(:,:,:,123))
  call check_last_AQ_V(l_switch,G3(:,:,:,123),wf(:,0),G3tensor(:,168))
  call loop_AQ_S(G1(:,:,:,140),wf(:,8),G1(:,:,:,227),gH)
  call loop_SA_Q(G1(:,:,:,227),wf(:,-5),G1(:,:,:,228),gH)
  call loop_A_Q(G1(:,:,:,228),Q(:,59),MT,G2(:,:,:,344))
  call check_last_AQ_V(l_switch,G2(:,:,:,344),wf(:,-2),G2tensor(:,121))
  call loop_AQ_S(G1(:,:,:,140),wf(:,8),G1(:,:,:,229),gX)
  call loop_SA_Q(G1(:,:,:,229),wf(:,-5),G1(:,:,:,230),gX)
  call loop_A_Q(G1(:,:,:,230),Q(:,59),MT,G2(:,:,:,345))
  call check_last_AQ_V(l_switch,G2(:,:,:,345),wf(:,-2),G2tensor(:,122))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,-2),G1(:,:,:,231),gZu)
  call loop_ZA_Q(G1(:,:,:,231),wf(:,-5),G1(:,:,:,232),gZu)
  call loop_A_Q(G1(:,:,:,232),Q(:,52),MT,G2(:,:,:,346))
  call check_last_AQ_V(l_switch,G2(:,:,:,346),wf(:,8),G2tensor(:,123))
  call loop_AV_Q(G2(:,:,:,346),wf(:,1),G2(:,:,:,347))
  call loop_A_Q(G2(:,:,:,347),Q(:,55),MT,G3(:,:,:,124))
  call check_last_AQ_V(l_switch,G3(:,:,:,124),wf(:,-3),G3tensor(:,169))
  call loop_AQ_V(G2(:,:,:,346),wf(:,-3),G2(:,:,:,348))
  call loop_VA_Q(G2(:,:,:,348),wf(:,-1),G2(:,:,:,349))
  call loop_A_Q(G2(:,:,:,349),Q(:,62),ZERO,G3(:,:,:,125))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,0),G3tensor(:,170))
  call loop_ZA_Q(G1(:,:,:,231),wf(:,144),G1(:,:,:,233),gZu)
  call loop_A_Q(G1(:,:,:,233),Q(:,55),MT,G2(:,:,:,350))
  call check_last_AQ_V(l_switch,G2(:,:,:,350),wf(:,-3),G2tensor(:,124))
  call loop_ZQ_A(G1(:,:,:,231),wf(:,-3),G1(:,:,:,234),gZu)
  call loop_Q_A(G1(:,:,:,234),Q(:,28),MT,G2(:,:,:,351))
  call loop_QA_V(G2(:,:,:,351),wf(:,-5),G2(:,:,:,352))
  call check_last_UV_W(l_switch,G2(:,:,:,352),Q(:,60),wf(:,1),Q(:,3),G3tensor(:,171))
  call loop_VA_Q(G2(:,:,:,352),wf(:,-1),G2(:,:,:,353))
  call loop_A_Q(G2(:,:,:,353),Q(:,62),ZERO,G3(:,:,:,126))
  call check_last_AQ_V(l_switch,G3(:,:,:,126),wf(:,0),G3tensor(:,172))
  call loop_ZQ_A(G1(:,:,:,231),wf(:,89),G1(:,:,:,235),gZu)
  call loop_Q_A(G1(:,:,:,235),Q(:,61),ZERO,G2(:,:,:,354))
  call check_last_QA_V(l_switch,G2(:,:,:,354),wf(:,-1),G2tensor(:,125))
  call loop_ZA_Q(G1(:,:,:,231),wf(:,322),G1(:,:,:,236),gZu)
  call loop_A_Q(G1(:,:,:,236),Q(:,62),ZERO,G2(:,:,:,355))
  call check_last_AQ_V(l_switch,G2(:,:,:,355),wf(:,0),G2tensor(:,126))
  call loop_ZQ_A(G1(:,:,:,231),wf(:,0),G1(:,:,:,237),gZu)
  call loop_Q_A(G1(:,:,:,237),Q(:,21),ZERO,G2(:,:,:,356))
  call loop_QV_A(G2(:,:,:,356),wf(:,3),G2(:,:,:,357))
  call loop_Q_A(G2(:,:,:,357),Q(:,61),ZERO,G3(:,:,:,127))
  call check_last_QA_V(l_switch,G3(:,:,:,127),wf(:,-1),G3tensor(:,173))
  call loop_ZA_Q(G1(:,:,:,231),wf(:,-1),G1(:,:,:,238),gZu)
  call loop_A_Q(G1(:,:,:,238),Q(:,22),ZERO,G2(:,:,:,358))
  call loop_AV_Q(G2(:,:,:,358),wf(:,3),G2(:,:,:,359))
  call loop_A_Q(G2(:,:,:,359),Q(:,62),ZERO,G3(:,:,:,128))
  call check_last_AQ_V(l_switch,G3(:,:,:,128),wf(:,0),G3tensor(:,174))
  call loop_AQ_V(G1(:,:,:,140),wf(:,8),G1(:,:,:,239))
  call loop_VA_Q(G1(:,:,:,239),wf(:,-5),G1(:,:,:,240))
  call loop_A_Q(G1(:,:,:,240),Q(:,59),MT,G2(:,:,:,360))
  call check_last_AQ_V(l_switch,G2(:,:,:,360),wf(:,-2),G2tensor(:,127))
  call loop_AQ_V(G1(:,:,:,140),wf(:,14),G1(:,:,:,241))
  call loop_VA_Q(G1(:,:,:,241),wf(:,-5),G1(:,:,:,242))
  call loop_A_Q(G1(:,:,:,242),Q(:,59),MT,G2(:,:,:,361))
  call check_last_AQ_V(l_switch,G2(:,:,:,361),wf(:,-2),G2tensor(:,128))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,8),G1(:,:,:,243),gZu)
  call loop_ZA_Q(G1(:,:,:,243),wf(:,-5),G1(:,:,:,244),gZu)
  call loop_A_Q(G1(:,:,:,244),Q(:,59),MT,G2(:,:,:,362))
  call check_last_AQ_V(l_switch,G2(:,:,:,362),wf(:,-2),G2tensor(:,129))
  call loop_AS_Q(G1(:,:,:,140),wf(:,463),G1(:,:,:,245),gH)
  call loop_A_Q(G1(:,:,:,245),Q(:,55),MT,G2(:,:,:,363))
  call check_last_AQ_V(l_switch,G2(:,:,:,363),wf(:,-3),G2tensor(:,130))
  call loop_AS_Q(G1(:,:,:,140),wf(:,464),G1(:,:,:,246),gX)
  call loop_A_Q(G1(:,:,:,246),Q(:,55),MT,G2(:,:,:,364))
  call check_last_AQ_V(l_switch,G2(:,:,:,364),wf(:,-3),G2tensor(:,131))
  call loop_AV_Q(G1(:,:,:,140),wf(:,465),G1(:,:,:,247))
  call loop_A_Q(G1(:,:,:,247),Q(:,55),MT,G2(:,:,:,365))
  call check_last_AQ_V(l_switch,G2(:,:,:,365),wf(:,-3),G2tensor(:,132))
  call loop_AV_Q(G1(:,:,:,140),wf(:,466),G1(:,:,:,248))
  call loop_A_Q(G1(:,:,:,248),Q(:,55),MT,G2(:,:,:,366))
  call check_last_AQ_V(l_switch,G2(:,:,:,366),wf(:,-3),G2tensor(:,133))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,467),G1(:,:,:,249),gZu)
  call loop_A_Q(G1(:,:,:,249),Q(:,55),MT,G2(:,:,:,367))
  call check_last_AQ_V(l_switch,G2(:,:,:,367),wf(:,-3),G2tensor(:,134))
  call loop_AS_Q(G1(:,:,:,140),wf(:,468),G1(:,:,:,250),gH)
  call loop_A_Q(G1(:,:,:,250),Q(:,59),MT,G2(:,:,:,368))
  call check_last_AQ_V(l_switch,G2(:,:,:,368),wf(:,-2),G2tensor(:,135))
  call loop_AS_Q(G1(:,:,:,140),wf(:,469),G1(:,:,:,251),gX)
  call loop_A_Q(G1(:,:,:,251),Q(:,59),MT,G2(:,:,:,369))
  call check_last_AQ_V(l_switch,G2(:,:,:,369),wf(:,-2),G2tensor(:,136))
  call loop_AV_Q(G1(:,:,:,140),wf(:,470),G1(:,:,:,252))
  call loop_A_Q(G1(:,:,:,252),Q(:,59),MT,G2(:,:,:,370))
  call check_last_AQ_V(l_switch,G2(:,:,:,370),wf(:,-2),G2tensor(:,137))
  call loop_AV_Q(G1(:,:,:,140),wf(:,471),G1(:,:,:,253))
  call loop_A_Q(G1(:,:,:,253),Q(:,59),MT,G2(:,:,:,371))
  call check_last_AQ_V(l_switch,G2(:,:,:,371),wf(:,-2),G2tensor(:,138))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,472),G1(:,:,:,254),gZu)
  call loop_A_Q(G1(:,:,:,254),Q(:,59),MT,G2(:,:,:,372))
  call check_last_AQ_V(l_switch,G2(:,:,:,372),wf(:,-2),G2tensor(:,139))
  call loop_AV_Q(G1(:,:,:,140),wf(:,505),G1(:,:,:,255))
  call loop_A_Q(G1(:,:,:,255),Q(:,55),MT,G2(:,:,:,373))
  call check_last_AQ_V(l_switch,G2(:,:,:,373),wf(:,-3),G2tensor(:,140))
  call loop_AV_Q(G1(:,:,:,140),wf(:,506),G1(:,:,:,256))
  call loop_A_Q(G1(:,:,:,256),Q(:,55),MT,G2(:,:,:,374))
  call check_last_AQ_V(l_switch,G2(:,:,:,374),wf(:,-3),G2tensor(:,141))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,507),G1(:,:,:,257),gZu)
  call loop_A_Q(G1(:,:,:,257),Q(:,55),MT,G2(:,:,:,375))
  call check_last_AQ_V(l_switch,G2(:,:,:,375),wf(:,-3),G2tensor(:,142))
  call loop_AV_Q(G1(:,:,:,140),wf(:,508),G1(:,:,:,258))
  call loop_A_Q(G1(:,:,:,258),Q(:,55),MT,G2(:,:,:,376))
  call check_last_AQ_V(l_switch,G2(:,:,:,376),wf(:,-3),G2tensor(:,143))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,509),G1(:,:,:,259),gZu)
  call loop_A_Q(G1(:,:,:,259),Q(:,55),MT,G2(:,:,:,377))
  call check_last_AQ_V(l_switch,G2(:,:,:,377),wf(:,-3),G2tensor(:,144))
  call loop_AV_Q(G1(:,:,:,140),wf(:,510),G1(:,:,:,260))
  call loop_A_Q(G1(:,:,:,260),Q(:,55),MT,G2(:,:,:,378))
  call check_last_AQ_V(l_switch,G2(:,:,:,378),wf(:,-3),G2tensor(:,145))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,62),G1(:,:,:,261),gZu)
  call loop_ZA_Q(G1(:,:,:,261),wf(:,-1),G1(:,:,:,262),gZu)
  call loop_A_Q(G1(:,:,:,262),Q(:,62),ZERO,G2(:,:,:,379))
  call check_last_AQ_V(l_switch,G2(:,:,:,379),wf(:,0),G2tensor(:,146))
  call loop_ZQ_A(G1(:,:,:,261),wf(:,0),G1(:,:,:,263),gZu)
  call loop_Q_A(G1(:,:,:,263),Q(:,61),ZERO,G2(:,:,:,380))
  call check_last_QA_V(l_switch,G2(:,:,:,380),wf(:,-1),G2tensor(:,147))
  call loop_AV_Q(G1(:,:,:,140),wf(:,521),G1(:,:,:,264))
  call loop_A_Q(G1(:,:,:,264),Q(:,59),MT,G2(:,:,:,381))
  call check_last_AQ_V(l_switch,G2(:,:,:,381),wf(:,-2),G2tensor(:,148))
  call loop_AV_Q(G1(:,:,:,140),wf(:,522),G1(:,:,:,265))
  call loop_A_Q(G1(:,:,:,265),Q(:,59),MT,G2(:,:,:,382))
  call check_last_AQ_V(l_switch,G2(:,:,:,382),wf(:,-2),G2tensor(:,149))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,523),G1(:,:,:,266),gZu)
  call loop_A_Q(G1(:,:,:,266),Q(:,59),MT,G2(:,:,:,383))
  call check_last_AQ_V(l_switch,G2(:,:,:,383),wf(:,-2),G2tensor(:,150))
  call loop_AV_Q(G1(:,:,:,140),wf(:,524),G1(:,:,:,267))
  call loop_A_Q(G1(:,:,:,267),Q(:,59),MT,G2(:,:,:,384))
  call check_last_AQ_V(l_switch,G2(:,:,:,384),wf(:,-2),G2tensor(:,151))
  call loop_AZ_Q(G1(:,:,:,140),wf(:,525),G1(:,:,:,268),gZu)
  call loop_A_Q(G1(:,:,:,268),Q(:,59),MT,G2(:,:,:,385))
  call check_last_AQ_V(l_switch,G2(:,:,:,385),wf(:,-2),G2tensor(:,152))
  call loop_AV_Q(G1(:,:,:,140),wf(:,526),G1(:,:,:,269))
  call loop_A_Q(G1(:,:,:,269),Q(:,59),MT,G2(:,:,:,386))
  call check_last_AQ_V(l_switch,G2(:,:,:,386),wf(:,-2),G2tensor(:,153))
  call loop_AQ_Z(G1(:,:,:,140),wf(:,78),G1(:,:,:,270),gZu)
  call loop_ZA_Q(G1(:,:,:,270),wf(:,-1),G1(:,:,:,271),gZu)
  call loop_A_Q(G1(:,:,:,271),Q(:,62),ZERO,G2(:,:,:,387))
  call check_last_AQ_V(l_switch,G2(:,:,:,387),wf(:,0),G2tensor(:,154))
  call loop_ZQ_A(G1(:,:,:,270),wf(:,0),G1(:,:,:,272),gZu)
  call loop_Q_A(G1(:,:,:,272),Q(:,61),ZERO,G2(:,:,:,388))
  call check_last_QA_V(l_switch,G2(:,:,:,388),wf(:,-1),G2tensor(:,155))
  call loop_SA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,33),gH)
  call loop_A_Q(G0(:,:,:,33),Q(:,16),MT,G1(:,:,:,273))
  call loop_AV_Q(G1(:,:,:,273),wf(:,27),G1(:,:,:,274))
  call loop_A_Q(G1(:,:,:,274),Q(:,52),MT,G2(:,:,:,389))
  call check_last_AQ_S(l_switch,G2(:,:,:,389),wf(:,8),G2tensor(:,156),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,29),G1(:,:,:,275))
  call loop_A_Q(G1(:,:,:,275),Q(:,55),MT,G2(:,:,:,390))
  call check_last_AQ_S(l_switch,G2(:,:,:,390),wf(:,-3),G2tensor(:,157),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,3),G1(:,:,:,276))
  call loop_A_Q(G1(:,:,:,276),Q(:,56),MT,G2(:,:,:,391))
  call check_last_AQ_S(l_switch,G2(:,:,:,391),wf(:,33),G2tensor(:,158),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,368),G1(:,:,:,277))
  call loop_A_Q(G1(:,:,:,277),Q(:,59),MT,G2(:,:,:,392))
  call check_last_AQ_S(l_switch,G2(:,:,:,392),wf(:,-2),G2tensor(:,159),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,440),G1(:,:,:,278))
  call loop_A_Q(G1(:,:,:,278),Q(:,55),MT,G2(:,:,:,393))
  call check_last_AQ_S(l_switch,G2(:,:,:,393),wf(:,-3),G2tensor(:,160),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,450),G1(:,:,:,279))
  call loop_A_Q(G1(:,:,:,279),Q(:,59),MT,G2(:,:,:,394))
  call check_last_AQ_S(l_switch,G2(:,:,:,394),wf(:,-2),G2tensor(:,161),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,465),G1(:,:,:,280))
  call loop_A_Q(G1(:,:,:,280),Q(:,55),MT,G2(:,:,:,395))
  call check_last_AQ_S(l_switch,G2(:,:,:,395),wf(:,-3),G2tensor(:,162),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,470),G1(:,:,:,281))
  call loop_A_Q(G1(:,:,:,281),Q(:,59),MT,G2(:,:,:,396))
  call check_last_AQ_S(l_switch,G2(:,:,:,396),wf(:,-2),G2tensor(:,163),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,505),G1(:,:,:,282))
  call loop_A_Q(G1(:,:,:,282),Q(:,55),MT,G2(:,:,:,397))
  call check_last_AQ_S(l_switch,G2(:,:,:,397),wf(:,-3),G2tensor(:,164),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,508),G1(:,:,:,283))
  call loop_A_Q(G1(:,:,:,283),Q(:,55),MT,G2(:,:,:,398))
  call check_last_AQ_S(l_switch,G2(:,:,:,398),wf(:,-3),G2tensor(:,165),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,521),G1(:,:,:,284))
  call loop_A_Q(G1(:,:,:,284),Q(:,59),MT,G2(:,:,:,399))
  call check_last_AQ_S(l_switch,G2(:,:,:,399),wf(:,-2),G2tensor(:,166),gH)
  call loop_AV_Q(G1(:,:,:,273),wf(:,524),G1(:,:,:,285))
  call loop_A_Q(G1(:,:,:,285),Q(:,59),MT,G2(:,:,:,400))
  call check_last_AQ_S(l_switch,G2(:,:,:,400),wf(:,-2),G2tensor(:,167),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,34),gX)
  call loop_A_Q(G0(:,:,:,34),Q(:,16),MT,G1(:,:,:,286))
  call loop_AV_Q(G1(:,:,:,286),wf(:,27),G1(:,:,:,287))
  call loop_A_Q(G1(:,:,:,287),Q(:,52),MT,G2(:,:,:,401))
  call check_last_AQ_S(l_switch,G2(:,:,:,401),wf(:,8),G2tensor(:,168),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,29),G1(:,:,:,288))
  call loop_A_Q(G1(:,:,:,288),Q(:,55),MT,G2(:,:,:,402))
  call check_last_AQ_S(l_switch,G2(:,:,:,402),wf(:,-3),G2tensor(:,169),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,3),G1(:,:,:,289))
  call loop_A_Q(G1(:,:,:,289),Q(:,56),MT,G2(:,:,:,403))
  call check_last_AQ_S(l_switch,G2(:,:,:,403),wf(:,33),G2tensor(:,170),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,368),G1(:,:,:,290))
  call loop_A_Q(G1(:,:,:,290),Q(:,59),MT,G2(:,:,:,404))
  call check_last_AQ_S(l_switch,G2(:,:,:,404),wf(:,-2),G2tensor(:,171),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,440),G1(:,:,:,291))
  call loop_A_Q(G1(:,:,:,291),Q(:,55),MT,G2(:,:,:,405))
  call check_last_AQ_S(l_switch,G2(:,:,:,405),wf(:,-3),G2tensor(:,172),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,450),G1(:,:,:,292))
  call loop_A_Q(G1(:,:,:,292),Q(:,59),MT,G2(:,:,:,406))
  call check_last_AQ_S(l_switch,G2(:,:,:,406),wf(:,-2),G2tensor(:,173),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,465),G1(:,:,:,293))
  call loop_A_Q(G1(:,:,:,293),Q(:,55),MT,G2(:,:,:,407))
  call check_last_AQ_S(l_switch,G2(:,:,:,407),wf(:,-3),G2tensor(:,174),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,470),G1(:,:,:,294))
  call loop_A_Q(G1(:,:,:,294),Q(:,59),MT,G2(:,:,:,408))
  call check_last_AQ_S(l_switch,G2(:,:,:,408),wf(:,-2),G2tensor(:,175),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,505),G1(:,:,:,295))
  call loop_A_Q(G1(:,:,:,295),Q(:,55),MT,G2(:,:,:,409))
  call check_last_AQ_S(l_switch,G2(:,:,:,409),wf(:,-3),G2tensor(:,176),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,508),G1(:,:,:,296))
  call loop_A_Q(G1(:,:,:,296),Q(:,55),MT,G2(:,:,:,410))
  call check_last_AQ_S(l_switch,G2(:,:,:,410),wf(:,-3),G2tensor(:,177),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,521),G1(:,:,:,297))
  call loop_A_Q(G1(:,:,:,297),Q(:,59),MT,G2(:,:,:,411))
  call check_last_AQ_S(l_switch,G2(:,:,:,411),wf(:,-2),G2tensor(:,178),gX)
  call loop_AV_Q(G1(:,:,:,286),wf(:,524),G1(:,:,:,298))
  call loop_A_Q(G1(:,:,:,298),Q(:,59),MT,G2(:,:,:,412))
  call check_last_AQ_S(l_switch,G2(:,:,:,412),wf(:,-2),G2tensor(:,179),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,-4),G0(:,:,:,35),gPtb)
  call loop_A_Q(G0(:,:,:,35),Q(:,16),MB,G1(:,:,:,299))
  call loop_AV_Q(G1(:,:,:,299),wf(:,27),G1(:,:,:,300))
  call loop_A_Q(G1(:,:,:,300),Q(:,52),MB,G2(:,:,:,413))
  call check_last_AQ_S(l_switch,G2(:,:,:,413),wf(:,8),G2tensor(:,180),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,29),G1(:,:,:,301))
  call loop_A_Q(G1(:,:,:,301),Q(:,55),MB,G2(:,:,:,414))
  call check_last_AQ_S(l_switch,G2(:,:,:,414),wf(:,-3),G2tensor(:,181),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,3),G1(:,:,:,302))
  call loop_A_Q(G1(:,:,:,302),Q(:,56),MB,G2(:,:,:,415))
  call check_last_AQ_S(l_switch,G2(:,:,:,415),wf(:,33),G2tensor(:,182),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,368),G1(:,:,:,303))
  call loop_A_Q(G1(:,:,:,303),Q(:,59),MB,G2(:,:,:,416))
  call check_last_AQ_S(l_switch,G2(:,:,:,416),wf(:,-2),G2tensor(:,183),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,440),G1(:,:,:,304))
  call loop_A_Q(G1(:,:,:,304),Q(:,55),MB,G2(:,:,:,417))
  call check_last_AQ_S(l_switch,G2(:,:,:,417),wf(:,-3),G2tensor(:,184),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,450),G1(:,:,:,305))
  call loop_A_Q(G1(:,:,:,305),Q(:,59),MB,G2(:,:,:,418))
  call check_last_AQ_S(l_switch,G2(:,:,:,418),wf(:,-2),G2tensor(:,185),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,465),G1(:,:,:,306))
  call loop_A_Q(G1(:,:,:,306),Q(:,55),MB,G2(:,:,:,419))
  call check_last_AQ_S(l_switch,G2(:,:,:,419),wf(:,-3),G2tensor(:,186),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,470),G1(:,:,:,307))
  call loop_A_Q(G1(:,:,:,307),Q(:,59),MB,G2(:,:,:,420))
  call check_last_AQ_S(l_switch,G2(:,:,:,420),wf(:,-2),G2tensor(:,187),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,505),G1(:,:,:,308))
  call loop_A_Q(G1(:,:,:,308),Q(:,55),MB,G2(:,:,:,421))
  call check_last_AQ_S(l_switch,G2(:,:,:,421),wf(:,-3),G2tensor(:,188),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,508),G1(:,:,:,309))
  call loop_A_Q(G1(:,:,:,309),Q(:,55),MB,G2(:,:,:,422))
  call check_last_AQ_S(l_switch,G2(:,:,:,422),wf(:,-3),G2tensor(:,189),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,521),G1(:,:,:,310))
  call loop_A_Q(G1(:,:,:,310),Q(:,59),MB,G2(:,:,:,423))
  call check_last_AQ_S(l_switch,G2(:,:,:,423),wf(:,-2),G2tensor(:,190),gPbt)
  call loop_AV_Q(G1(:,:,:,299),wf(:,524),G1(:,:,:,311))
  call loop_A_Q(G1(:,:,:,311),Q(:,59),MB,G2(:,:,:,424))
  call check_last_AQ_S(l_switch,G2(:,:,:,424),wf(:,-2),G2tensor(:,191),gPbt)

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(64)*M(3)-c(63)*M(7)) * den(146)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(64)*M(3))+c(63)*M(7)) * den(148)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(67)*M(7))-c(71)*M(9)+c(68)*(M(3)+M(11))) * den(150)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(67)*M(7)+c(71)*M(9)+c(68)*(-M(3)-M(11))) * den(150)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(60)*M(7)+c(62)*M(9)+c(61)*(-M(3)-M(11))) * den(150)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(10)*M(7))+c(15)*M(11)) * den(150)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(22)*M(7))+c(27)*M(11)) * den(151)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(8)*M(3))+c(7)*M(7)) * den(150)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(7)) * den(148)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(150)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(150)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(56)*M(7)+c(58)*M(9)+c(57)*(-M(3)-M(11))) * den(150)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(39)*M(8))-c(43)*M(10)+c(40)*(M(4)+M(12))) * den(150)
  T2sum(1:15,40) = T2sum(1:15,40) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(2)*M(3))+c(1)*M(7)) * den(150)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(4)*M(3))+c(3)*M(7)) * den(148)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(31)*M(8))-c(34)*M(10)+c(32)*(M(4)+M(12))) * den(150)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(63)*(M(1)-M(9))) * den(223)
  T2sum(1:15,45) = T2sum(1:15,45) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(63)*(-M(1)+M(9))) * den(223)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(59)*(-M(1)+M(9))) * den(223)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(3)*(-M(1)+M(9))) * den(223)
  T2sum(1:15,46) = T2sum(1:15,46) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(55)*(-M(1)+M(9))) * den(223)
  T2sum(1:15,47) = T2sum(1:15,47) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(53)*(-M(2)+M(10))) * den(223)
  T2sum(1:15,2) = T2sum(1:15,2) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(67)*M(7))-c(71)*M(9)+c(68)*(M(3)+M(11))) * den(221)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(67)*M(7)+c(71)*M(9)+c(68)*(-M(3)-M(11))) * den(221)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(60)*M(7)+c(62)*M(9)+c(61)*(-M(3)-M(11))) * den(221)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(221)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(56)*M(7)+c(58)*M(9)+c(57)*(-M(3)-M(11))) * den(221)
  T3sum(1:35,22) = T3sum(1:35,22) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(53)*M(10)+c(48)*(-M(4)+M(6)-M(12))) * den(221)
  T3sum(1:35,23) = T3sum(1:35,23) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(64)*M(3)-c(63)*M(7)) * den(422)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(64)*M(3))+c(63)*M(7)) * den(423)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(2)*M(3))+c(1)*M(7)) * den(221)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(4)*M(3))+c(3)*M(7)) * den(423)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(32)*M(6)-c(31)*M(8)) * den(221)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(75)*M(5))+c(70)*M(7)) * den(45)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(75)*M(5)-c(70)*M(7)) * den(47)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(5)+M(11))) * den(48)
  T2sum(1:15,50) = T2sum(1:15,50) + Gcoeff * G2tensor(:,156)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(5)-M(11))) * den(48)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,168)
  Gcoeff = (c(62)*M(1)+c(60)*M(7)+c(61)*(-M(5)-M(11))) * den(48)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,180)
  Gcoeff = (c(7)*M(7)-c(8)*M(11)) * den(48)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(49)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(15)*M(5)-c(10)*M(7)) * den(48)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(27)*M(5)-c(22)*M(7)) * den(47)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(48)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(43)*M(2))-c(39)*M(8)+c(40)*(M(6)+M(12))) * den(48)
  T2sum(1:15,49) = T2sum(1:15,49) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(64)*M(5))+c(63)*M(7)) * den(52)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(64)*M(5)-c(63)*M(7)) * den(54)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(2)*M(5)-c(1)*M(7)) * den(56)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(4)*M(5)-c(3)*M(7)) * den(54)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(31)*M(8)+c(34)*M(10)+c(32)*(-M(6)-M(12))) * den(56)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(63)*(-M(1)+M(9))) * den(226)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,157)
  Gcoeff = (c(63)*(M(1)-M(9))) * den(226)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,169)
  Gcoeff = (c(59)*(M(1)-M(9))) * den(226)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,181)
  Gcoeff = (c(1)*(M(1)-M(9))) * den(226)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(31)*(-M(2)+M(10))) * den(226)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(68)*M(5)-c(67)*M(7)) * den(103)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(68)*M(5))+c(67)*M(7)) * den(108)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(7)*M(7)-c(8)*M(11)) * den(26)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(106)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,88)
  Gcoeff = (-(c(8)*M(5))+c(7)*M(7)) * den(26)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,87)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(7)) * den(108)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,92)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(26)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,87)
  Gcoeff = (-(c(43)*M(2))+c(48)*M(4)-c(44)*M(8)+c(40)*(M(6)+M(12))) * den(26)
  T3sum(1:35,31) = T3sum(1:35,31) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(68)*M(5)-c(67)*M(7)) * den(103)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,94)
  Gcoeff = (-(c(68)*M(5))+c(67)*M(7)) * den(108)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(7)*M(7)-c(8)*M(11)) * den(26)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(106)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,109)
  Gcoeff = (-(c(8)*M(5))+c(7)*M(7)) * den(26)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,96)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(7)) * den(108)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11))) * den(26)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(48)*M(4)-c(44)*M(8)-c(43)*M(10)+c(40)*(M(6)+M(12))) * den(26)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(53)*M(10)+c(48)*(M(4)-M(6)-M(12))) * den(26)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(75)*M(9)-c(70)*M(11)) * den(59)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(75)*M(9))+c(70)*M(11)) * den(61)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(7)-M(9))+c(67)*M(11)) * den(62)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,158)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(7)+M(9))-c(67)*M(11)) * den(62)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,170)
  Gcoeff = (-(c(62)*M(3))+c(61)*(M(7)+M(9))-c(60)*M(11)) * den(62)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,182)
  Gcoeff = (c(8)*M(7)-c(7)*M(11)) * den(62)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(20)*M(7)-c(19)*M(11)) * den(63)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(15)*M(9))+c(10)*M(11)) * den(62)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(27)*M(9))+c(22)*M(11)) * den(61)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(62)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(43)*M(4)+c(40)*(-M(8)-M(10))+c(39)*M(12)) * den(62)
  T2sum(1:15,68) = T2sum(1:15,68) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(64)*M(9)-c(63)*M(11)) * den(65)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,83)
  Gcoeff = (-(c(64)*M(9))+c(63)*M(11)) * den(67)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(2)*M(9))+c(1)*M(11)) * den(69)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(4)*M(9))+c(3)*M(11)) * den(67)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(34)*M(6))+c(32)*(M(8)+M(10))-c(31)*M(12)) * den(69)
  T2sum(1:15,60) = T2sum(1:15,60) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(64)*M(9))+c(63)*M(11)) * den(157)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(64)*M(9)-c(63)*M(11)) * den(159)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(7)-M(9))+c(67)*M(11)) * den(161)
  T2sum(1:15,42) = T2sum(1:15,42) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(7)+M(9))-c(67)*M(11)) * den(161)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(62)*M(3))+c(61)*(M(7)+M(9))-c(60)*M(11)) * den(161)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(161)
  T2sum(1:15,43) = T2sum(1:15,43) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(58)*M(3))+c(57)*(M(7)+M(9))-c(56)*M(11)) * den(161)
  T2sum(1:15,44) = T2sum(1:15,44) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(2)*M(9)-c(1)*M(11)) * den(161)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(4)*M(9)-c(3)*M(11)) * den(159)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(34)*M(4)+c(32)*(-M(8)-M(10))+c(31)*M(12)) * den(161)
  T2sum(1:15,41) = T2sum(1:15,41) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(63)*(M(3)-M(5))) * den(193)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,159)
  Gcoeff = (c(63)*(-M(3)+M(5))) * den(193)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,171)
  Gcoeff = (c(59)*(-M(3)+M(5))) * den(193)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,183)
  Gcoeff = (c(1)*(-M(3)+M(5))) * den(193)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(31)*(M(4)-M(6))) * den(193)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(68)*M(9))+c(67)*M(11)) * den(425)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(68)*M(9)-c(67)*M(11)) * den(426)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,127)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(7)-M(9))+c(67)*M(11)) * den(191)
  T3sum(1:35,44) = T3sum(1:35,44) + Gcoeff * G3tensor(:,74)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(7)+M(9))-c(67)*M(11)) * den(191)
  T3sum(1:35,45) = T3sum(1:35,45) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(62)*M(3))+c(61)*(M(7)+M(9))-c(60)*M(11)) * den(191)
  T3sum(1:35,46) = T3sum(1:35,46) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(8)*M(7)-c(7)*M(11)) * den(191)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(20)*M(7)-c(19)*M(11)) * den(427)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,130)
  Gcoeff = (c(8)*M(9)-c(7)*M(11)) * den(191)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(20)*M(9)-c(19)*M(11)) * den(426)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,134)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(191)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,129)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(191)
  T3sum(1:35,45) = T3sum(1:35,45) + Gcoeff * G3tensor(:,80)
  Gcoeff = (-(c(58)*M(3))+c(57)*(M(7)+M(9))-c(56)*M(11)) * den(191)
  T3sum(1:35,46) = T3sum(1:35,46) + Gcoeff * G3tensor(:,82)
  Gcoeff = (-(c(48)*M(2))+c(43)*M(4)+c(40)*(-M(8)-M(10))+c(44)*M(12)) * den(191)
  T3sum(1:35,43) = T3sum(1:35,43) + Gcoeff * G3tensor(:,129)
  Gcoeff = (-(c(53)*M(4))+c(48)*(-M(2)+M(8)+M(10))) * den(191)
  T3sum(1:35,47) = T3sum(1:35,47) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(68)*M(9))+c(67)*M(11)) * den(425)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(68)*M(9)-c(67)*M(11)) * den(426)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(8)*M(7)-c(7)*M(11)) * den(191)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(20)*M(7)-c(19)*M(11)) * den(427)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(8)*M(9)-c(7)*M(11)) * den(191)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(20)*M(9)-c(19)*M(11)) * den(426)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,101)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(191)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,100)
  Gcoeff = (-(c(48)*M(2))+c(43)*M(6)+c(40)*(-M(8)-M(10))+c(44)*M(12)) * den(191)
  T3sum(1:35,48) = T3sum(1:35,48) + Gcoeff * G3tensor(:,100)
  Gcoeff = (-(c(53)*M(6))+c(48)*(-M(2)+M(8)+M(10))) * den(191)
  T3sum(1:35,52) = T3sum(1:35,52) + Gcoeff * G3tensor(:,136)
  Gcoeff = (-(c(64)*M(9))+c(63)*M(11)) * den(425)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(64)*M(9)-c(63)*M(11)) * den(426)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(2)*M(9)-c(1)*M(11)) * den(191)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(4)*M(9)-c(3)*M(11)) * den(426)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(32)*M(2))+c(31)*M(12)) * den(191)
  T3sum(1:35,53) = T3sum(1:35,53) + Gcoeff * G3tensor(:,39)
  Gcoeff = (-(c(75)*M(3))+c(70)*M(7)) * den(320)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(75)*M(3)-c(70)*M(7)) * den(322)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(67)*M(7))-c(71)*M(9)+c(68)*(M(3)+M(11))) * den(323)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,160)
  Gcoeff = (c(67)*M(7)+c(71)*M(9)+c(68)*(-M(3)-M(11))) * den(323)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,172)
  Gcoeff = (c(60)*M(7)+c(62)*M(9)+c(61)*(-M(3)-M(11))) * den(323)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,184)
  Gcoeff = (c(7)*M(7)-c(8)*M(11)) * den(323)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(324)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(15)*M(3)-c(10)*M(7)) * den(323)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(27)*M(3)-c(22)*M(7)) * den(322)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(323)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(39)*M(8))-c(43)*M(10)+c(40)*(M(4)+M(12))) * den(323)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(67)*M(7))-c(71)*M(9)+c(68)*(M(3)+M(11))) * den(30)
  T2sum(1:15,82) = T2sum(1:15,82) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(67)*M(7)+c(71)*M(9)+c(68)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,83) = T2sum(1:15,83) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(7)-M(9))+c(67)*M(11)) * den(30)
  T2sum(1:15,88) = T2sum(1:15,88) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(7)+M(9))-c(67)*M(11)) * den(30)
  T2sum(1:15,89) = T2sum(1:15,89) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(7)*M(7)+c(14)*M(11)) * den(30)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(19)*M(7)+c(26)*M(11)) * den(35)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(30)
  T2sum(1:15,83) = T2sum(1:15,83) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(40)*M(4)-c(39)*M(8)+c(51)*M(10)-c(46)*M(12)) * den(30)
  T2sum(1:15,90) = T2sum(1:15,90) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(30)
  T2sum(1:15,89) = T2sum(1:15,89) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(75)*M(1)-c(70)*M(11)) * den(332)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(75)*M(1))+c(70)*M(11)) * den(334)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(7))+c(67)*M(11)) * den(335)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,161)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(7))-c(67)*M(11)) * den(335)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,173)
  Gcoeff = (-(c(62)*M(5))+c(61)*(M(1)+M(7))-c(60)*M(11)) * den(335)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,185)
  Gcoeff = (c(8)*M(7)-c(7)*M(11)) * den(335)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(20)*M(7)-c(19)*M(11)) * den(336)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(15)*M(1))+c(10)*M(11)) * den(335)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(27)*M(1))+c(22)*M(11)) * den(334)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,116)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(7))-c(7)*M(11)) * den(335)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(43)*M(6)+c(40)*(-M(2)-M(8))+c(39)*M(12)) * den(335)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(7))+c(67)*M(11)) * den(8)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,117)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(7))-c(67)*M(11)) * den(8)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(5)+M(11))) * den(8)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(5)-M(11))) * den(8)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,122)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(7))-c(19)*M(11)) * den(8)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(7)*M(7)+c(14)*M(11)) * den(8)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(19)*M(7)+c(26)*M(11)) * den(14)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,128)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(8)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(8)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,127)
  Gcoeff = (c(23)*M(1)+c(19)*M(7)+c(20)*(-M(5)-M(11))) * den(8)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,129)
  Gcoeff = (c(51)*M(2)+c(40)*M(6)-c(39)*M(8)-c(46)*M(12)) * den(8)
  T2sum(1:15,111) = T2sum(1:15,111) + Gcoeff * G2tensor(:,127)
  Gcoeff = (-(c(75)*M(3))+c(70)*M(7)) * den(345)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,130)
  Gcoeff = (c(75)*M(3)-c(70)*M(7)) * den(346)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,131)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(3)+M(11))) * den(347)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,162)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(3)-M(11))) * den(347)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,174)
  Gcoeff = (c(62)*M(1)+c(60)*M(7)+c(61)*(-M(3)-M(11))) * den(347)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,186)
  Gcoeff = (c(7)*M(7)-c(8)*M(11)) * den(347)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(348)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,133)
  Gcoeff = (c(15)*M(3)-c(10)*M(7)) * den(347)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(27)*M(3)-c(22)*M(7)) * den(346)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,134)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11))) * den(347)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,132)
  Gcoeff = (-(c(43)*M(2))-c(39)*M(8)+c(40)*(M(4)+M(12))) * den(347)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,132)
  Gcoeff = (c(75)*M(1)-c(70)*M(11)) * den(349)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,135)
  Gcoeff = (-(c(75)*M(1))+c(70)*M(11)) * den(350)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,136)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(1)-M(7))+c(67)*M(11)) * den(351)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,163)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(1)+M(7))-c(67)*M(11)) * den(351)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,175)
  Gcoeff = (-(c(62)*M(3))+c(61)*(M(1)+M(7))-c(60)*M(11)) * den(351)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,187)
  Gcoeff = (c(8)*M(7)-c(7)*M(11)) * den(351)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(20)*M(7)-c(19)*M(11)) * den(352)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,138)
  Gcoeff = (-(c(15)*M(1))+c(10)*M(11)) * den(351)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,137)
  Gcoeff = (-(c(27)*M(1))+c(22)*M(11)) * den(350)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,139)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(7))-c(7)*M(11)) * den(351)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(43)*M(4)+c(40)*(-M(2)-M(8))+c(39)*M(12)) * den(351)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,137)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(1)-M(7))+c(67)*M(11)) * den(112)
  T2sum(1:15,152) = T2sum(1:15,152) + Gcoeff * G2tensor(:,118)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(1)+M(7))-c(67)*M(11)) * den(112)
  T2sum(1:15,153) = T2sum(1:15,153) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(3)+M(11))) * den(112)
  T2sum(1:15,158) = T2sum(1:15,158) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(3)-M(11))) * den(112)
  T2sum(1:15,159) = T2sum(1:15,159) + Gcoeff * G2tensor(:,104)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(7))-c(19)*M(11)) * den(112)
  T2sum(1:15,153) = T2sum(1:15,153) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(7)*M(7)+c(14)*M(11)) * den(112)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(19)*M(7)+c(26)*M(11)) * den(116)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11))) * den(112)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11))) * den(112)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(23)*M(1)+c(19)*M(7)+c(20)*(-M(3)-M(11))) * den(112)
  T2sum(1:15,159) = T2sum(1:15,159) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(51)*M(2)+c(40)*M(4)-c(39)*M(8)-c(46)*M(12)) * den(112)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(63)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,55) = T3sum(1:35,55) + Gcoeff * G3tensor(:,163)
  Gcoeff = (c(63)*(M(3)-M(5))) * den(1)
  T3sum(1:35,56) = T3sum(1:35,56) + Gcoeff * G3tensor(:,167)
  Gcoeff = (c(1)*(M(3)-M(5))) * den(1)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(3)*(M(3)-M(5))) * den(1)
  T3sum(1:35,56) = T3sum(1:35,56) + Gcoeff * G3tensor(:,171)
  Gcoeff = (c(31)*(-M(4)+M(6))+c(32)*(M(2)-M(10))) * den(1)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(63)*(M(1)-M(9))) * den(1)
  T3sum(1:35,63) = T3sum(1:35,63) + Gcoeff * G3tensor(:,149)
  Gcoeff = (c(63)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,153)
  Gcoeff = (c(1)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,65) = T3sum(1:35,65) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(3)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,64) = T3sum(1:35,64) + Gcoeff * G3tensor(:,157)
  Gcoeff = (c(32)*(-M(4)+M(6))+c(31)*(M(2)-M(10))) * den(1)
  T3sum(1:35,65) = T3sum(1:35,65) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(1)-M(7))+c(67)*M(11)) * den(1)
  T3sum(1:35,81) = T3sum(1:35,81) + Gcoeff * G3tensor(:,161)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(1)+M(7))-c(67)*M(11)) * den(1)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,165)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(7))-c(19)*M(11)) * den(1)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,169)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(5)+M(11))) * den(1)
  T3sum(1:35,91) = T3sum(1:35,91) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,92) = T3sum(1:35,92) + Gcoeff * G3tensor(:,103)
  Gcoeff = (c(7)*M(7)+c(14)*M(11)) * den(1)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(19)*M(7)+c(26)*M(11)) * den(13)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(23)*M(1)+c(19)*M(7)+c(20)*(-M(5)-M(11))) * den(1)
  T3sum(1:35,92) = T3sum(1:35,92) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(40)*M(6)-c(39)*M(8)+c(43)*(-M(2)-M(10))+c(41)*M(12)) * den(1)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,104)
  Gcoeff = (-(c(71)*M(1))-c(67)*M(7)+c(68)*(M(3)+M(11))) * den(1)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,147)
  Gcoeff = (c(71)*M(1)+c(67)*M(7)+c(68)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,151)
  Gcoeff = (c(7)*M(7)+c(14)*M(11)) * den(1)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(19)*M(7)+c(26)*M(11)) * den(13)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(23)*M(1)+c(19)*M(7)+c(20)*(-M(3)-M(11))) * den(1)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,155)
  Gcoeff = (c(40)*M(4)-c(39)*M(8)+c(43)*(-M(2)-M(10))+c(41)*M(12)) * den(1)
  T3sum(1:35,101) = T3sum(1:35,101) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(63)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,102) = T3sum(1:35,102) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(63)*(M(3)-M(5))) * den(1)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(1)*(M(3)-M(5))) * den(1)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(3)*(M(3)-M(5))) * den(1)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(33)*M(4)+c(31)*M(6)-c(32)*M(8)) * den(1)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(63)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,105) = T3sum(1:35,105) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(63)*(M(3)-M(5))) * den(1)
  T3sum(1:35,106) = T3sum(1:35,106) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(1)*(M(3)-M(5))) * den(1)
  T3sum(1:35,107) = T3sum(1:35,107) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(3)*(M(3)-M(5))) * den(1)
  T3sum(1:35,106) = T3sum(1:35,106) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(31)*(-M(4)+M(6))+c(32)*(-M(2)+M(10))) * den(1)
  T3sum(1:35,107) = T3sum(1:35,107) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(7)-M(9))+c(67)*M(11)) * den(1)
  T3sum(1:35,108) = T3sum(1:35,108) + Gcoeff * G3tensor(:,106)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(7)+M(9))-c(67)*M(11)) * den(1)
  T3sum(1:35,109) = T3sum(1:35,109) + Gcoeff * G3tensor(:,107)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(1)
  T3sum(1:35,109) = T3sum(1:35,109) + Gcoeff * G3tensor(:,108)
  Gcoeff = (c(63)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,113) = T3sum(1:35,113) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(63)*(M(1)-M(9))) * den(1)
  T3sum(1:35,114) = T3sum(1:35,114) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(1)*(M(1)-M(9))) * den(1)
  T3sum(1:35,115) = T3sum(1:35,115) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(3)*(M(1)-M(9))) * den(1)
  T3sum(1:35,114) = T3sum(1:35,114) + Gcoeff * G3tensor(:,67)
  Gcoeff = (-(c(31)*M(2))-c(33)*M(10)+c(32)*M(12)) * den(1)
  T3sum(1:35,115) = T3sum(1:35,115) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(63)*(-M(1)+M(9))) * den(1)
  T3sum(1:35,116) = T3sum(1:35,116) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(63)*(M(1)-M(9))) * den(1)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(1)*(M(1)-M(9))) * den(1)
  T3sum(1:35,118) = T3sum(1:35,118) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(3)*(M(1)-M(9))) * den(1)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(32)*(-M(4)+M(6))+c(31)*(-M(2)+M(10))) * den(1)
  T3sum(1:35,118) = T3sum(1:35,118) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(14)*M(3)+c(7)*M(7)) * den(90)
  T2sum(1:15,221) = T2sum(1:15,221) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(26)*M(3)+c(19)*M(7)) * den(92)
  T2sum(1:15,221) = T2sum(1:15,221) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(90)
  T2sum(1:15,221) = T2sum(1:15,221) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(90)
  T2sum(1:15,221) = T2sum(1:15,221) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9)) * den(90)
  T2sum(1:15,223) = T2sum(1:15,223) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(46)*M(4))+c(40)*M(6)-c(39)*M(8)+c(51)*M(10)) * den(90)
  T2sum(1:15,221) = T2sum(1:15,221) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(9)*M(3))+c(12)*M(7)) * den(176)
  T2sum(1:15,227) = T2sum(1:15,227) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(21)*M(3))+c(24)*M(7)) * den(179)
  T2sum(1:15,227) = T2sum(1:15,227) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(176)
  T2sum(1:15,227) = T2sum(1:15,227) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(176)
  T2sum(1:15,227) = T2sum(1:15,227) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7)) * den(176)
  T2sum(1:15,229) = T2sum(1:15,229) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(45)*M(2))+c(41)*M(4)+c(49)*M(6)-c(44)*M(8)) * den(176)
  T2sum(1:15,227) = T2sum(1:15,227) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(69)*M(3)-c(72)*M(7)) * den(145)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(69)*M(3))+c(72)*M(7)) * den(147)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(9)*M(3))+c(12)*M(7)) * den(149)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(21)*M(3))+c(24)*M(7)) * den(147)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,234) = T2sum(1:15,234) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(41)*M(4)-c(44)*M(8)-c(45)*M(10)+c(49)*M(12)) * den(149)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(14)*M(3)+c(7)*M(7)) * den(149)
  T2sum(1:15,236) = T2sum(1:15,236) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(26)*M(3)+c(19)*M(7)) * den(147)
  T2sum(1:15,236) = T2sum(1:15,236) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,236) = T2sum(1:15,236) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,236) = T2sum(1:15,236) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,237) = T2sum(1:15,237) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(149)
  T2sum(1:15,238) = T2sum(1:15,238) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(46)*M(4))-c(39)*M(8)+c(51)*M(10)+c(40)*M(12)) * den(149)
  T2sum(1:15,236) = T2sum(1:15,236) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(69)*M(3)-c(72)*M(7)) * den(28)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(69)*M(3))+c(72)*M(7)) * den(32)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,16)
  Gcoeff = (-(c(9)*M(3))+c(12)*M(7)) * den(25)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(21)*M(3))+c(24)*M(7)) * den(32)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11))) * den(25)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(25)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(25)
  T3sum(1:35,161) = T3sum(1:35,161) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(41)*M(4)+c(48)*M(6)-c(44)*M(8)+c(43)*(-M(2)-M(10))+c(40)*M(12)) * den(25)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(1)*(M(1)-M(9))) * den(25)
  T3sum(1:35,162) = T3sum(1:35,162) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(31)*(-M(2)+M(10))+c(32)*(M(6)-M(12))) * den(25)
  T3sum(1:35,162) = T3sum(1:35,162) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11))) * den(25)
  T3sum(1:35,165) = T3sum(1:35,165) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(9)*M(3))+c(12)*M(7)) * den(25)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(21)*M(3))+c(24)*M(7)) * den(32)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(25)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(25)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7)) * den(25)
  T3sum(1:35,175) = T3sum(1:35,175) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(41)*M(4)+c(40)*M(6)-c(44)*M(8)+c(43)*(-M(2)-M(10))+c(48)*M(12)) * den(25)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9)) * den(25)
  T3sum(1:35,177) = T3sum(1:35,177) + Gcoeff * G3tensor(:,72)
  Gcoeff = (-(c(71)*M(1))+c(68)*(M(3)+M(5))-c(67)*M(7)) * den(382)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,164)
  Gcoeff = (c(71)*M(1)+c(68)*(-M(3)-M(5))+c(67)*M(7)) * den(382)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,176)
  Gcoeff = (c(62)*M(1)+c(61)*(-M(3)-M(5))+c(60)*M(7)) * den(382)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,188)
  Gcoeff = (-(c(8)*M(5))+c(7)*M(7)) * den(382)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,140)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(7)) * den(383)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,141)
  Gcoeff = (c(15)*M(3)-c(10)*M(7)) * den(382)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(27)*M(3)-c(22)*M(7)) * den(384)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,142)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(382)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,140)
  Gcoeff = (-(c(43)*M(2))+c(40)*(M(4)+M(6))-c(39)*M(8)) * den(382)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,140)
  Gcoeff = (c(68)*(M(3)+M(5))-c(67)*M(7)-c(71)*M(9)) * den(385)
  T2sum(1:15,64) = T2sum(1:15,64) + Gcoeff * G2tensor(:,165)
  Gcoeff = (c(68)*(-M(3)-M(5))+c(67)*M(7)+c(71)*M(9)) * den(385)
  T2sum(1:15,65) = T2sum(1:15,65) + Gcoeff * G2tensor(:,177)
  Gcoeff = (c(61)*(-M(3)-M(5))+c(60)*M(7)+c(62)*M(9)) * den(385)
  T2sum(1:15,66) = T2sum(1:15,66) + Gcoeff * G2tensor(:,189)
  Gcoeff = (c(15)*M(3)-c(10)*M(7)) * den(385)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(27)*M(3)-c(22)*M(7)) * den(386)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,144)
  Gcoeff = (-(c(8)*M(5))+c(7)*M(7)) * den(385)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,143)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(7)) * den(387)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,145)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(385)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,143)
  Gcoeff = (c(40)*(M(4)+M(6))-c(39)*M(8)-c(43)*M(10)) * den(385)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,143)
  Gcoeff = (-(c(9)*M(5))+c(12)*M(7)) * den(84)
  T2sum(1:15,242) = T2sum(1:15,242) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(21)*M(5))+c(24)*M(7)) * den(86)
  T2sum(1:15,242) = T2sum(1:15,242) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(84)
  T2sum(1:15,242) = T2sum(1:15,242) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(84)
  T2sum(1:15,242) = T2sum(1:15,242) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7)) * den(84)
  T2sum(1:15,244) = T2sum(1:15,244) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(45)*M(2))+c(49)*M(4)+c(41)*M(6)-c(44)*M(8)) * den(84)
  T2sum(1:15,242) = T2sum(1:15,242) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(14)*M(5)+c(7)*M(7)) * den(182)
  T2sum(1:15,248) = T2sum(1:15,248) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(26)*M(5)+c(19)*M(7)) * den(185)
  T2sum(1:15,248) = T2sum(1:15,248) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(182)
  T2sum(1:15,248) = T2sum(1:15,248) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(182)
  T2sum(1:15,248) = T2sum(1:15,248) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9)) * den(182)
  T2sum(1:15,250) = T2sum(1:15,250) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(40)*M(4)-c(46)*M(6)-c(39)*M(8)+c(51)*M(10)) * den(182)
  T2sum(1:15,248) = T2sum(1:15,248) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(74)*M(5))-c(67)*M(7)) * den(51)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(74)*M(5)+c(67)*M(7)) * den(53)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(14)*M(5)+c(7)*M(7)) * den(55)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(26)*M(5)+c(19)*M(7)) * den(53)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11))) * den(55)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11))) * den(55)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11))) * den(55)
  T2sum(1:15,253) = T2sum(1:15,253) + Gcoeff * G2tensor(:,146)
  Gcoeff = (-(c(46)*M(6))-c(39)*M(8)+c(51)*M(10)+c(40)*M(12)) * den(55)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11))) * den(55)
  T2sum(1:15,255) = T2sum(1:15,255) + Gcoeff * G2tensor(:,147)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11))) * den(24)
  T3sum(1:35,180) = T3sum(1:35,180) + Gcoeff * G3tensor(:,89)
  Gcoeff = (-(c(74)*M(5))-c(67)*M(7)) * den(44)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(74)*M(5)+c(67)*M(7)) * den(46)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(14)*M(5)+c(7)*M(7)) * den(24)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(26)*M(5)+c(19)*M(7)) * den(46)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11))) * den(24)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11))) * den(24)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11))) * den(24)
  T3sum(1:35,186) = T3sum(1:35,186) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(41)*M(6)-c(39)*M(8)+c(43)*(-M(2)-M(10))+c(40)*M(12)) * den(24)
  T3sum(1:35,184) = T3sum(1:35,184) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(1)*(-M(1)+M(9))) * den(24)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(31)*M(2)-c(32)*M(6)+c(33)*M(10)) * den(24)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7)) * den(24)
  T3sum(1:35,194) = T3sum(1:35,194) + Gcoeff * G3tensor(:,159)
  Gcoeff = (c(14)*M(5)+c(7)*M(7)) * den(24)
  T3sum(1:35,196) = T3sum(1:35,196) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(26)*M(5)+c(19)*M(7)) * den(46)
  T3sum(1:35,196) = T3sum(1:35,196) + Gcoeff * G3tensor(:,124)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7)) * den(24)
  T3sum(1:35,196) = T3sum(1:35,196) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9)) * den(24)
  T3sum(1:35,196) = T3sum(1:35,196) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9)) * den(24)
  T3sum(1:35,198) = T3sum(1:35,198) + Gcoeff * G3tensor(:,160)
  Gcoeff = (c(40)*M(4)+c(41)*M(6)-c(39)*M(8)+c(43)*(-M(2)-M(10))) * den(24)
  T3sum(1:35,196) = T3sum(1:35,196) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(71)*M(3)+c(68)*(-M(1)-M(9))+c(67)*M(11)) * den(396)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,166)
  Gcoeff = (-(c(71)*M(3))+c(68)*(M(1)+M(9))-c(67)*M(11)) * den(396)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,178)
  Gcoeff = (-(c(62)*M(3))+c(61)*(M(1)+M(9))-c(60)*M(11)) * den(396)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,190)
  Gcoeff = (c(8)*M(9)-c(7)*M(11)) * den(396)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(20)*M(9)-c(19)*M(11)) * den(397)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,149)
  Gcoeff = (-(c(15)*M(1))+c(10)*M(11)) * den(396)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,148)
  Gcoeff = (-(c(27)*M(1))+c(22)*M(11)) * den(398)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,150)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(396)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(43)*M(4)+c(40)*(-M(2)-M(10))+c(39)*M(12)) * den(396)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,148)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(9))+c(67)*M(11)) * den(399)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,167)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(9))-c(67)*M(11)) * den(399)
  T2sum(1:15,79) = T2sum(1:15,79) + Gcoeff * G2tensor(:,179)
  Gcoeff = (-(c(62)*M(5))+c(61)*(M(1)+M(9))-c(60)*M(11)) * den(399)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,191)
  Gcoeff = (-(c(15)*M(1))+c(10)*M(11)) * den(399)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,151)
  Gcoeff = (-(c(27)*M(1))+c(22)*M(11)) * den(400)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,152)
  Gcoeff = (c(8)*M(9)-c(7)*M(11)) * den(399)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(20)*M(9)-c(19)*M(11)) * den(401)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,153)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(399)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,151)
  Gcoeff = (c(43)*M(6)+c(40)*(-M(2)-M(10))+c(39)*M(12)) * den(399)
  T2sum(1:15,81) = T2sum(1:15,81) + Gcoeff * G2tensor(:,151)
  Gcoeff = (-(c(14)*M(9))-c(7)*M(11)) * den(78)
  T2sum(1:15,257) = T2sum(1:15,257) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(26)*M(9))-c(19)*M(11)) * den(80)
  T2sum(1:15,257) = T2sum(1:15,257) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(78)
  T2sum(1:15,257) = T2sum(1:15,257) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(78)
  T2sum(1:15,257) = T2sum(1:15,257) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(78)
  T2sum(1:15,259) = T2sum(1:15,259) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(40)*M(2))-c(51)*M(4)+c(46)*M(10)+c(39)*M(12)) * den(78)
  T2sum(1:15,257) = T2sum(1:15,257) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(9)*M(9)-c(12)*M(11)) * den(78)
  T2sum(1:15,260) = T2sum(1:15,260) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(21)*M(9)-c(24)*M(11)) * den(80)
  T2sum(1:15,260) = T2sum(1:15,260) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(78)
  T2sum(1:15,260) = T2sum(1:15,260) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(78)
  T2sum(1:15,260) = T2sum(1:15,260) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(78)
  T2sum(1:15,262) = T2sum(1:15,262) + Gcoeff * G2tensor(:,125)
  Gcoeff = (-(c(49)*M(2))+c(45)*M(4)-c(41)*M(10)+c(44)*M(12)) * den(78)
  T2sum(1:15,260) = T2sum(1:15,260) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(9)*M(9)-c(12)*M(11)) * den(164)
  T2sum(1:15,263) = T2sum(1:15,263) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(21)*M(9)-c(24)*M(11)) * den(167)
  T2sum(1:15,263) = T2sum(1:15,263) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(164)
  T2sum(1:15,263) = T2sum(1:15,263) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(164)
  T2sum(1:15,263) = T2sum(1:15,263) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(164)
  T2sum(1:15,265) = T2sum(1:15,265) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(49)*M(2))+c(45)*M(6)-c(41)*M(10)+c(44)*M(12)) * den(164)
  T2sum(1:15,263) = T2sum(1:15,263) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(14)*M(9))-c(7)*M(11)) * den(164)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(26)*M(9))-c(19)*M(11)) * den(167)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(164)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(164)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(164)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,126)
  Gcoeff = (-(c(40)*M(2))-c(51)*M(6)+c(46)*M(10)+c(39)*M(12)) * den(164)
  T2sum(1:15,266) = T2sum(1:15,266) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(74)*M(9)+c(67)*M(11)) * den(64)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(74)*M(9))-c(67)*M(11)) * den(66)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,86)
  Gcoeff = (-(c(14)*M(9))-c(7)*M(11)) * den(68)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(26)*M(9))-c(19)*M(11)) * den(66)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(68)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(68)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(68)
  T2sum(1:15,253) = T2sum(1:15,253) + Gcoeff * G2tensor(:,154)
  Gcoeff = (-(c(51)*M(6))-c(40)*M(8)+c(46)*M(10)+c(39)*M(12)) * den(68)
  T2sum(1:15,251) = T2sum(1:15,251) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(68)
  T2sum(1:15,255) = T2sum(1:15,255) + Gcoeff * G2tensor(:,155)
  Gcoeff = (-(c(69)*M(9))+c(72)*M(11)) * den(156)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(69)*M(9)-c(72)*M(11)) * den(158)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(9)*M(9)-c(12)*M(11)) * den(160)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(21)*M(9)-c(24)*M(11)) * den(158)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(160)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(160)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(160)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(45)*M(4)-c(49)*M(8)-c(41)*M(10)+c(44)*M(12)) * den(160)
  T2sum(1:15,233) = T2sum(1:15,233) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(160)
  T2sum(1:15,237) = T2sum(1:15,237) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(69)*M(9))+c(72)*M(11)) * den(58)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(69)*M(9)-c(72)*M(11)) * den(60)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(9)*M(9)-c(12)*M(11)) * den(3)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(21)*M(9)-c(24)*M(11)) * den(60)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,200) = T3sum(1:35,200) + Gcoeff * G3tensor(:,131)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,201) = T3sum(1:35,201) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(48)*M(2))+c(43)*(M(4)+M(6))-c(40)*M(8)-c(41)*M(10)+c(44)*M(12)) * den(3)
  T3sum(1:35,199) = T3sum(1:35,199) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(1)*(M(3)-M(5))) * den(3)
  T3sum(1:35,202) = T3sum(1:35,202) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(31)*(-M(4)+M(6))+c(32)*(-M(2)+M(8))) * den(3)
  T3sum(1:35,202) = T3sum(1:35,202) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(74)*M(9)+c(67)*M(11)) * den(58)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,126)
  Gcoeff = (-(c(74)*M(9))-c(67)*M(11)) * den(60)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,128)
  Gcoeff = (-(c(14)*M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,133)
  Gcoeff = (-(c(26)*M(9))-c(19)*M(11)) * den(60)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,135)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,133)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,133)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,205) = T3sum(1:35,205) + Gcoeff * G3tensor(:,42)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,206) = T3sum(1:35,206) + Gcoeff * G3tensor(:,132)
  Gcoeff = (c(43)*(M(4)+M(6))-c(40)*M(8)-c(41)*M(10)+c(39)*M(12)) * den(3)
  T3sum(1:35,204) = T3sum(1:35,204) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(1)*(M(3)-M(5))) * den(3)
  T3sum(1:35,207) = T3sum(1:35,207) + Gcoeff * G3tensor(:,137)
  Gcoeff = (-(c(31)*M(4))-c(33)*M(6)+c(32)*M(10)) * den(3)
  T3sum(1:35,207) = T3sum(1:35,207) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(9)*M(9)-c(12)*M(11)) * den(3)
  T3sum(1:35,213) = T3sum(1:35,213) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(21)*M(9)-c(24)*M(11)) * den(60)
  T3sum(1:35,213) = T3sum(1:35,213) + Gcoeff * G3tensor(:,34)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,213) = T3sum(1:35,213) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,213) = T3sum(1:35,213) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,214) = T3sum(1:35,214) + Gcoeff * G3tensor(:,173)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,215) = T3sum(1:35,215) + Gcoeff * G3tensor(:,57)
  Gcoeff = (-(c(40)*M(2))+c(43)*(M(4)+M(6))-c(48)*M(8)-c(41)*M(10)+c(44)*M(12)) * den(3)
  T3sum(1:35,213) = T3sum(1:35,213) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(14)*M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,142)
  Gcoeff = (-(c(26)*M(9))-c(19)*M(11)) * den(60)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,143)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,142)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11)) * den(3)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,142)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,217) = T3sum(1:35,217) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11)) * den(3)
  T3sum(1:35,218) = T3sum(1:35,218) + Gcoeff * G3tensor(:,174)
  Gcoeff = (-(c(40)*M(2))+c(43)*(M(4)+M(6))-c(41)*M(10)+c(39)*M(12)) * den(3)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(9))+c(67)*M(11))
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,48)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(9))-c(67)*M(11))
  T3sum(1:35,220) = T3sum(1:35,220) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(7))-c(7)*M(11))
  T3sum(1:35,221) = T3sum(1:35,221) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11))
  T3sum(1:35,221) = T3sum(1:35,221) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11))
  T3sum(1:35,221) = T3sum(1:35,221) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,223) = T3sum(1:35,223) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11))
  T3sum(1:35,220) = T3sum(1:35,220) + Gcoeff * G3tensor(:,56)
  Gcoeff = (-(c(49)*M(2))+c(43)*M(4)+c(45)*M(6)+c(40)*(-M(8)-M(10))+c(39)*M(12))
  T3sum(1:35,221) = T3sum(1:35,221) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(71)*M(1))+c(68)*(M(3)+M(5))-c(67)*M(7))
  T3sum(1:35,224) = T3sum(1:35,224) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(71)*M(1)+c(68)*(-M(3)-M(5))+c(67)*M(7))
  T3sum(1:35,225) = T3sum(1:35,225) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(5)-M(11)))
  T3sum(1:35,226) = T3sum(1:35,226) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11)))
  T3sum(1:35,226) = T3sum(1:35,226) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7))
  T3sum(1:35,226) = T3sum(1:35,226) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11)))
  T3sum(1:35,228) = T3sum(1:35,228) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7))
  T3sum(1:35,225) = T3sum(1:35,225) + Gcoeff * G3tensor(:,70)
  Gcoeff = (-(c(45)*M(2))+c(49)*M(6)-c(39)*M(8)-c(43)*M(10)+c(40)*(M(4)+M(12)))
  T3sum(1:35,226) = T3sum(1:35,226) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(71)*M(1))+c(68)*(M(3)+M(5))-c(67)*M(7))
  T3sum(1:35,229) = T3sum(1:35,229) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(71)*M(1)+c(68)*(-M(3)-M(5))+c(67)*M(7))
  T3sum(1:35,230) = T3sum(1:35,230) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11)))
  T3sum(1:35,231) = T3sum(1:35,231) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11)))
  T3sum(1:35,231) = T3sum(1:35,231) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(11)*M(1)+c(8)*(-M(3)-M(5))+c(7)*M(7))
  T3sum(1:35,231) = T3sum(1:35,231) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11)))
  T3sum(1:35,232) = T3sum(1:35,232) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11)))
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(23)*M(1)+c(20)*(-M(3)-M(5))+c(19)*M(7))
  T3sum(1:35,230) = T3sum(1:35,230) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(43)*M(2))+c(40)*(M(4)+M(6))-c(39)*M(8)-c(45)*M(10)+c(49)*M(12))
  T3sum(1:35,231) = T3sum(1:35,231) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(9))+c(67)*M(11))
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(9))-c(67)*M(11))
  T3sum(1:35,235) = T3sum(1:35,235) + Gcoeff * G3tensor(:,50)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(7))-c(7)*M(11))
  T3sum(1:35,236) = T3sum(1:35,236) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(7)+M(9))-c(7)*M(11))
  T3sum(1:35,236) = T3sum(1:35,236) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11))
  T3sum(1:35,236) = T3sum(1:35,236) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,238) = T3sum(1:35,238) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11))
  T3sum(1:35,235) = T3sum(1:35,235) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(45)*M(4)+c(43)*M(6)-c(49)*M(8)+c(40)*(-M(2)-M(10))+c(39)*M(12))
  T3sum(1:35,236) = T3sum(1:35,236) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,242) = T3sum(1:35,242) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11)))
  T3sum(1:35,247) = T3sum(1:35,247) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,252) = T3sum(1:35,252) + Gcoeff * G3tensor(:,144)
  Gcoeff = (c(68)*(M(3)+M(5))-c(67)*M(7)-c(71)*M(9))
  T3sum(1:35,259) = T3sum(1:35,259) + Gcoeff * G3tensor(:,148)
  Gcoeff = (c(68)*(-M(3)-M(5))+c(67)*M(7)+c(71)*M(9))
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,152)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11)))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11)))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(3)-M(11)))
  T3sum(1:35,262) = T3sum(1:35,262) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11)))
  T3sum(1:35,263) = T3sum(1:35,263) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9))
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,156)
  Gcoeff = (-(c(39)*M(8))+c(50)*M(10)+c(40)*(M(4)+M(6)+M(12)))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(9))+c(67)*M(11))
  T3sum(1:35,264) = T3sum(1:35,264) + Gcoeff * G3tensor(:,162)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(9))-c(67)*M(11))
  T3sum(1:35,265) = T3sum(1:35,265) + Gcoeff * G3tensor(:,166)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(7))-c(7)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,268) = T3sum(1:35,268) + Gcoeff * G3tensor(:,145)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11))
  T3sum(1:35,265) = T3sum(1:35,265) + Gcoeff * G3tensor(:,170)
  Gcoeff = (-(c(50)*M(6))+c(40)*(-M(2)-M(8)-M(10))+c(39)*M(12))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,146)
  Gcoeff = (c(71)*M(5)+c(68)*(-M(1)-M(9))+c(67)*M(11))
  T3sum(1:35,269) = T3sum(1:35,269) + Gcoeff * G3tensor(:,164)
  Gcoeff = (-(c(71)*M(5))+c(68)*(M(1)+M(9))-c(67)*M(11))
  T3sum(1:35,270) = T3sum(1:35,270) + Gcoeff * G3tensor(:,168)
  Gcoeff = (-(c(11)*M(3))+c(8)*(M(1)+M(7))-c(7)*M(11))
  T3sum(1:35,271) = T3sum(1:35,271) + Gcoeff * G3tensor(:,139)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(7)+M(9))-c(7)*M(11))
  T3sum(1:35,271) = T3sum(1:35,271) + Gcoeff * G3tensor(:,139)
  Gcoeff = (-(c(11)*M(5))+c(8)*(M(1)+M(9))-c(7)*M(11))
  T3sum(1:35,271) = T3sum(1:35,271) + Gcoeff * G3tensor(:,139)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,273) = T3sum(1:35,273) + Gcoeff * G3tensor(:,140)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(1)+M(9))-c(19)*M(11))
  T3sum(1:35,270) = T3sum(1:35,270) + Gcoeff * G3tensor(:,172)
  Gcoeff = (c(43)*M(4)+c(45)*M(6)+c(40)*(-M(2)-M(8))-c(49)*M(10)+c(39)*M(12))
  T3sum(1:35,271) = T3sum(1:35,271) + Gcoeff * G3tensor(:,139)
  Gcoeff = (c(68)*(M(3)+M(5))-c(67)*M(7)-c(71)*M(9))
  T3sum(1:35,274) = T3sum(1:35,274) + Gcoeff * G3tensor(:,150)
  Gcoeff = (c(68)*(-M(3)-M(5))+c(67)*M(7)+c(71)*M(9))
  T3sum(1:35,275) = T3sum(1:35,275) + Gcoeff * G3tensor(:,154)
  Gcoeff = (c(11)*M(1)+c(7)*M(7)+c(8)*(-M(3)-M(11)))
  T3sum(1:35,276) = T3sum(1:35,276) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(5)-M(11)))
  T3sum(1:35,276) = T3sum(1:35,276) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(8)*(-M(3)-M(5))+c(7)*M(7)+c(11)*M(9))
  T3sum(1:35,276) = T3sum(1:35,276) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11)))
  T3sum(1:35,278) = T3sum(1:35,278) + Gcoeff * G3tensor(:,121)
  Gcoeff = (c(20)*(-M(3)-M(5))+c(19)*M(7)+c(23)*M(9))
  T3sum(1:35,275) = T3sum(1:35,275) + Gcoeff * G3tensor(:,158)
  Gcoeff = (-(c(43)*M(2))+c(49)*M(6)-c(39)*M(8)-c(45)*M(10)+c(40)*(M(4)+M(12)))
  T3sum(1:35,276) = T3sum(1:35,276) + Gcoeff * G3tensor(:,120)
  Gcoeff = (-(c(23)*M(3))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,282) = T3sum(1:35,282) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(23)*M(5))+c(20)*(M(7)+M(9))-c(19)*M(11))
  T3sum(1:35,292) = T3sum(1:35,292) + Gcoeff * G3tensor(:,141)
  Gcoeff = (c(19)*M(7)+c(23)*M(9)+c(20)*(-M(5)-M(11)))
  T3sum(1:35,297) = T3sum(1:35,297) + Gcoeff * G3tensor(:,122)
  Gcoeff = (-(c(10)*M(7))+c(15)*M(11)) * den(239)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(22)*M(7))+c(27)*M(11)) * den(240)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(15)*M(3)-c(10)*M(7)) * den(239)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(27)*M(3)-c(22)*M(7)) * den(238)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(7)*M(7)+c(11)*M(9)+c(8)*(-M(3)-M(11))) * den(239)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(42)*M(8)+c(52)*M(10)+c(47)*(-M(4)-M(12))) * den(239)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,1)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_3_pptttt_ew_uuxtttxtx_1_/**/REALKIND
