
module ol_vamp_2_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(28)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,55) :: G0
  complex(REALKIND), dimension(4,5,4,81) :: G1
  complex(REALKIND), dimension(4,15,4,49) :: G2
  complex(REALKIND), dimension(4,35,4,22) :: G3
  complex(REALKIND), dimension(4,70,4,6) :: G4
  complex(REALKIND), dimension(1,9) :: G0tensor
  complex(REALKIND), dimension(5,45) :: G1tensor
  complex(REALKIND), dimension(15,36) :: G2tensor
  complex(REALKIND), dimension(35,11) :: G3tensor
  complex(REALKIND), dimension(70,8) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,2),G0(:,:,:,2))
  call loop_UV_W(G0(:,:,:,2),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,1))
  call check_last_UV_W(l_switch,G1(:,:,:,1),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,1))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,62),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,0),G2tensor(:,2))
  call loop_VQ_A(G0(:,:,:,2),wf(:,88),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,59),MT,G1(:,:,:,3))
  call check_last_QA_V(l_switch,G1(:,:,:,3),wf(:,-2),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,2),wf(:,109),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,62),MT,G1(:,:,:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,0),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-5),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,62),MT,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,0),G2tensor(:,3))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,6))
  call loop_UV_W(G0(:,:,:,6),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,7))
  call check_last_UV_W(l_switch,G1(:,:,:,7),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,4))
  call loop_VA_Q(G1(:,:,:,7),wf(:,-2),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,0),G2tensor(:,5))
  call loop_VQ_A(G0(:,:,:,6),wf(:,88),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,59),MT,G1(:,:,:,9))
  call check_last_QA_V(l_switch,G1(:,:,:,9),wf(:,-2),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,6),wf(:,109),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,62),MT,G1(:,:,:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,10),wf(:,0),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,11))
  call loop_AV_Q(G1(:,:,:,11),wf(:,-5),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,6))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,2),G0(:,:,:,10))
  call loop_UV_W(G0(:,:,:,10),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,13))
  call check_last_UV_W(l_switch,G1(:,:,:,13),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,62),MT,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,0),G2tensor(:,8))
  call loop_VQ_A(G0(:,:,:,10),wf(:,88),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,59),MT,G1(:,:,:,15))
  call check_last_QA_V(l_switch,G1(:,:,:,15),wf(:,-2),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,10),wf(:,109),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,62),MT,G1(:,:,:,16))
  call check_last_AQ_V(l_switch,G1(:,:,:,16),wf(:,0),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,10),wf(:,-2),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,30),MT,G1(:,:,:,17))
  call loop_AV_Q(G1(:,:,:,17),wf(:,-5),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,62),MT,G2(:,:,:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,9))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,14))
  call loop_UV_W(G0(:,:,:,14),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,19))
  call check_last_UV_W(l_switch,G1(:,:,:,19),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,19),wf(:,-3),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,61),MT,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,-1),G2tensor(:,11))
  call loop_VQ_A(G0(:,:,:,14),wf(:,40),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,55),MT,G1(:,:,:,21))
  call check_last_QA_V(l_switch,G1(:,:,:,21),wf(:,-3),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,14),wf(:,21),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,61),MT,G1(:,:,:,22))
  call check_last_AQ_V(l_switch,G1(:,:,:,22),wf(:,-1),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,14),wf(:,-3),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,29),MT,G1(:,:,:,23))
  call loop_AV_Q(G1(:,:,:,23),wf(:,-5),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,61),MT,G2(:,:,:,8))
  call check_last_AQ_V(l_switch,G2(:,:,:,8),wf(:,-1),G2tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,18))
  call loop_UV_W(G0(:,:,:,18),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,25),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,25),wf(:,-3),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,61),MT,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,-1),G2tensor(:,14))
  call loop_VQ_A(G0(:,:,:,18),wf(:,40),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,55),MT,G1(:,:,:,27))
  call check_last_QA_V(l_switch,G1(:,:,:,27),wf(:,-3),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,18),wf(:,21),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,61),MT,G1(:,:,:,28))
  call check_last_AQ_V(l_switch,G1(:,:,:,28),wf(:,-1),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,18),wf(:,-3),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,29),MT,G1(:,:,:,29))
  call loop_AV_Q(G1(:,:,:,29),wf(:,-5),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,61),MT,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,-1),G2tensor(:,15))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,22))
  call loop_UV_W(G0(:,:,:,22),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,31))
  call check_last_UV_W(l_switch,G1(:,:,:,31),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,31),wf(:,-3),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,61),MT,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,-1),G2tensor(:,17))
  call loop_VQ_A(G0(:,:,:,22),wf(:,40),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,55),MT,G1(:,:,:,33))
  call check_last_QA_V(l_switch,G1(:,:,:,33),wf(:,-3),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,22),wf(:,21),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,61),MT,G1(:,:,:,34))
  call check_last_AQ_V(l_switch,G1(:,:,:,34),wf(:,-1),G1tensor(:,12))
  call loop_VA_Q(G0(:,:,:,22),wf(:,-3),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,29),MT,G1(:,:,:,35))
  call loop_AV_Q(G1(:,:,:,35),wf(:,-5),G1(:,:,:,36))
  call loop_A_Q(G1(:,:,:,36),Q(:,61),MT,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,-1),G2tensor(:,18))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,37))
  call loop_GGG_G_12(G1(:,:,:,37),wf(:,-5),wf(:,-4),G1(:,:,:,38))
  call check_last_UV_W(l_switch,G1(:,:,:,38),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,38),wf(:,-2),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,62),MT,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,0),G2tensor(:,20))
  call loop_GGG_G_12(G1(:,:,:,37),wf(:,-4),wf(:,-5),G1(:,:,:,40))
  call check_last_UV_W(l_switch,G1(:,:,:,40),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,40),wf(:,-2),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,62),MT,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,0),G2tensor(:,22))
  call loop_GGG_G_23(G1(:,:,:,37),wf(:,-5),wf(:,-4),G1(:,:,:,42))
  call check_last_UV_W(l_switch,G1(:,:,:,42),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,42),wf(:,-2),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,62),MT,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,0),G2tensor(:,24))
  call loop_UV_W(G1(:,:,:,37),Q(:,10),wf(:,11),Q(:,48),G2(:,:,:,16))
  call check_last_UV_W(l_switch,G2(:,:,:,16),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,1))
  call loop_VA_Q(G2(:,:,:,16),wf(:,-2),G2(:,:,:,17))
  call loop_A_Q(G2(:,:,:,17),Q(:,62),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,2))
  call loop_UV_W(G1(:,:,:,37),Q(:,10),wf(:,-5),Q(:,32),G2(:,:,:,18))
  call loop_UV_W(G2(:,:,:,18),Q(:,42),wf(:,-4),Q(:,16),G3(:,:,:,2))
  call check_last_UV_W(l_switch,G3(:,:,:,2),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,1))
  call loop_VA_Q(G3(:,:,:,2),wf(:,-2),G3(:,:,:,3))
  call loop_A_Q(G3(:,:,:,3),Q(:,62),MT,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,2))
  call loop_VQ_A(G2(:,:,:,18),wf(:,70),G2(:,:,:,19))
  call loop_Q_A(G2(:,:,:,19),Q(:,59),MT,G3(:,:,:,4))
  call check_last_QA_V(l_switch,G3(:,:,:,4),wf(:,-2),G3tensor(:,3))
  call loop_VA_Q(G2(:,:,:,18),wf(:,126),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,62),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,4))
  call loop_VA_Q(G2(:,:,:,18),wf(:,-2),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,46),MT,G3(:,:,:,6))
  call loop_AV_Q(G3(:,:,:,6),wf(:,-4),G3(:,:,:,7))
  call loop_A_Q(G3(:,:,:,7),Q(:,62),MT,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,3))
  call loop_UV_W(G1(:,:,:,37),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,22))
  call loop_UV_W(G2(:,:,:,22),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,8))
  call check_last_UV_W(l_switch,G3(:,:,:,8),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,4))
  call loop_VA_Q(G3(:,:,:,8),wf(:,-2),G3(:,:,:,9))
  call loop_A_Q(G3(:,:,:,9),Q(:,62),MT,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,5))
  call loop_VQ_A(G2(:,:,:,22),wf(:,88),G2(:,:,:,23))
  call loop_Q_A(G2(:,:,:,23),Q(:,59),MT,G3(:,:,:,10))
  call check_last_QA_V(l_switch,G3(:,:,:,10),wf(:,-2),G3tensor(:,5))
  call loop_VA_Q(G2(:,:,:,22),wf(:,109),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,62),MT,G3(:,:,:,11))
  call check_last_AQ_V(l_switch,G3(:,:,:,11),wf(:,0),G3tensor(:,6))
  call loop_VA_Q(G2(:,:,:,22),wf(:,-2),G2(:,:,:,25))
  call loop_A_Q(G2(:,:,:,25),Q(:,30),MT,G3(:,:,:,12))
  call loop_AV_Q(G3(:,:,:,12),wf(:,-5),G3(:,:,:,13))
  call loop_A_Q(G3(:,:,:,13),Q(:,62),MT,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,6))
  call loop_VQ_A(G1(:,:,:,37),wf(:,398),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,59),MT,G2(:,:,:,26))
  call check_last_QA_V(l_switch,G2(:,:,:,26),wf(:,-2),G2tensor(:,25))
  call loop_VQ_A(G1(:,:,:,37),wf(:,70),G1(:,:,:,45))
  call loop_Q_A(G1(:,:,:,45),Q(:,27),MT,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,-5),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,59),MT,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,-2),G3tensor(:,7))
  call loop_VA_Q(G1(:,:,:,37),wf(:,584),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,62),MT,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,26))
  call loop_VA_Q(G1(:,:,:,37),wf(:,126),G1(:,:,:,47))
  call loop_A_Q(G1(:,:,:,47),Q(:,30),MT,G2(:,:,:,30))
  call loop_AV_Q(G2(:,:,:,30),wf(:,-5),G2(:,:,:,31))
  call loop_A_Q(G2(:,:,:,31),Q(:,62),MT,G3(:,:,:,15))
  call check_last_AQ_V(l_switch,G3(:,:,:,15),wf(:,0),G3tensor(:,8))
  call loop_VQ_A(G1(:,:,:,37),wf(:,405),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,59),MT,G2(:,:,:,32))
  call check_last_QA_V(l_switch,G2(:,:,:,32),wf(:,-2),G2tensor(:,27))
  call loop_VQ_A(G1(:,:,:,37),wf(:,88),G1(:,:,:,49))
  call loop_Q_A(G1(:,:,:,49),Q(:,43),MT,G2(:,:,:,33))
  call loop_QV_A(G2(:,:,:,33),wf(:,-4),G2(:,:,:,34))
  call loop_Q_A(G2(:,:,:,34),Q(:,59),MT,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,9))
  call loop_VA_Q(G1(:,:,:,37),wf(:,596),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,62),MT,G2(:,:,:,35))
  call check_last_AQ_V(l_switch,G2(:,:,:,35),wf(:,0),G2tensor(:,28))
  call loop_VA_Q(G1(:,:,:,37),wf(:,109),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,46),MT,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,-4),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,62),MT,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,0),G3tensor(:,10))
  call loop_VQ_A(G1(:,:,:,37),wf(:,106),G1(:,:,:,52))
  call loop_Q_A(G1(:,:,:,52),Q(:,59),MT,G2(:,:,:,38))
  call check_last_QA_V(l_switch,G2(:,:,:,38),wf(:,-2),G2tensor(:,29))
  call loop_VA_Q(G1(:,:,:,37),wf(:,597),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,62),MT,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,0),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,37),wf(:,-2),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,14),MT,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,11),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,62),MT,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,0),G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-5),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,46),MT,G3(:,:,:,19))
  call loop_AV_Q(G3(:,:,:,19),wf(:,-4),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,62),MT,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,7))
  call loop_AV_Q(G2(:,:,:,40),wf(:,-4),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,30),MT,G3(:,:,:,21))
  call loop_AV_Q(G3(:,:,:,21),wf(:,-5),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,62),MT,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,26))
  call loop_VQ_A(G0(:,:,:,26),wf(:,20),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,55),MT,G1(:,:,:,55))
  call check_last_QA_V(l_switch,G1(:,:,:,55),wf(:,-3),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,26),wf(:,41),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,61),MT,G1(:,:,:,56))
  call check_last_AQ_V(l_switch,G1(:,:,:,56),wf(:,-1),G1tensor(:,14))
  call loop_UV_W(G0(:,:,:,26),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,57))
  call loop_VA_Q(G1(:,:,:,57),wf(:,-3),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,61),MT,G2(:,:,:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,44),wf(:,-1),G2tensor(:,31))
  call loop_VA_Q(G0(:,:,:,26),wf(:,-3),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,45),MT,G1(:,:,:,59))
  call loop_AV_Q(G1(:,:,:,59),wf(:,-4),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,61),MT,G2(:,:,:,45))
  call check_last_AQ_V(l_switch,G2(:,:,:,45),wf(:,-1),G2tensor(:,32))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,2),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,2),wf(:,-4),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,2),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,37),Q(:,26),G1tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,55),Q(:,26),G1tensor(:,17))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-5),G0(:,:,:,30))
  call loop_VQ_A(G0(:,:,:,30),wf(:,20),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,55),MT,G1(:,:,:,61))
  call check_last_QA_V(l_switch,G1(:,:,:,61),wf(:,-3),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,30),wf(:,41),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,61),MT,G1(:,:,:,62))
  call check_last_AQ_V(l_switch,G1(:,:,:,62),wf(:,-1),G1tensor(:,19))
  call loop_UV_W(G0(:,:,:,30),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,63))
  call loop_VA_Q(G1(:,:,:,63),wf(:,-3),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,61),MT,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,-1),G2tensor(:,33))
  call loop_VA_Q(G0(:,:,:,30),wf(:,-3),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,45),MT,G1(:,:,:,65))
  call loop_AV_Q(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,61),MT,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,-1),G2tensor(:,34))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-4),wf(:,2),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,2),wf(:,-4),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,30),wf(:,-4),wf(:,2),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,37),Q(:,26),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,55),Q(:,26),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,34))
  call loop_VQ_A(G0(:,:,:,34),wf(:,20),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,55),MT,G1(:,:,:,67))
  call check_last_QA_V(l_switch,G1(:,:,:,67),wf(:,-3),G1tensor(:,23))
  call loop_VA_Q(G0(:,:,:,34),wf(:,41),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,61),MT,G1(:,:,:,68))
  call check_last_AQ_V(l_switch,G1(:,:,:,68),wf(:,-1),G1tensor(:,24))
  call loop_UV_W(G0(:,:,:,34),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,69))
  call loop_VA_Q(G1(:,:,:,69),wf(:,-3),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,61),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,-1),G2tensor(:,35))
  call loop_VA_Q(G0(:,:,:,34),wf(:,-3),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,45),MT,G1(:,:,:,71))
  call loop_AV_Q(G1(:,:,:,71),wf(:,-4),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,61),MT,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-1),G2tensor(:,36))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,2),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,2),wf(:,-4),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,2),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,37),Q(:,26),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,55),Q(:,26),G1tensor(:,27))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,11),G0(:,:,:,38))
  call loop_VA_Q(G0(:,:,:,38),wf(:,-3),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,61),MT,G1(:,:,:,73))
  call check_last_AQ_V(l_switch,G1(:,:,:,73),wf(:,-1),G1tensor(:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,29))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,1),G0(:,:,:,40))
  call loop_VA_Q(G0(:,:,:,40),wf(:,-3),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,61),MT,G1(:,:,:,74))
  call check_last_AQ_V(l_switch,G1(:,:,:,74),wf(:,-1),G1tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,31))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,11),G0(:,:,:,42))
  call loop_VA_Q(G0(:,:,:,42),wf(:,-3),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,61),MT,G1(:,:,:,75))
  call check_last_AQ_V(l_switch,G1(:,:,:,75),wf(:,-1),G1tensor(:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,33))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,44))
  call loop_VA_Q(G0(:,:,:,44),wf(:,-3),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,61),MT,G1(:,:,:,76))
  call check_last_AQ_V(l_switch,G1(:,:,:,76),wf(:,-1),G1tensor(:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-5),G0(:,:,:,46))
  call loop_VA_Q(G0(:,:,:,46),wf(:,-3),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,61),MT,G1(:,:,:,77))
  call check_last_AQ_V(l_switch,G1(:,:,:,77),wf(:,-1),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,37))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,48))
  call loop_VA_Q(G0(:,:,:,48),wf(:,-3),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,61),MT,G1(:,:,:,78))
  call check_last_AQ_V(l_switch,G1(:,:,:,78),wf(:,-1),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,50))
  call loop_VA_Q(G0(:,:,:,50),wf(:,-3),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,61),MT,G1(:,:,:,79))
  call check_last_AQ_V(l_switch,G1(:,:,:,79),wf(:,-1),G1tensor(:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,41))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,-4),G0(:,:,:,52))
  call loop_VA_Q(G0(:,:,:,52),wf(:,-3),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,61),MT,G1(:,:,:,80))
  call check_last_AQ_V(l_switch,G1(:,:,:,80),wf(:,-1),G1tensor(:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,43))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,54))
  call loop_VA_Q(G0(:,:,:,54),wf(:,-3),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,61),MT,G1(:,:,:,81))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,-1),G1tensor(:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,45))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(51)*(-M(4)-M(6))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(51)*(-M(14)-M(20))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(51)*(M(4)+M(6)-M(14)-M(20))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(51)*(-M(4)-M(6))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(51)*(-M(12)-M(22))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(51)*(M(4)+M(6)-M(12)-M(22))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(51)*(-M(12)-M(22))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(51)*(-M(14)-M(20))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(51)*(M(12)-M(14)-M(20)+M(22))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(51)*M(6))+c(46)*(-M(2)+M(24))) * den(23)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(51)*M(20))+c(46)*(-M(2)+M(24))) * den(23)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(51)*(M(6)-M(20))) * den(23)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(51)*M(4))+c(46)*(-M(2)+M(16))) * den(666)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(51)*M(14))+c(46)*(-M(2)+M(16))) * den(666)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(51)*(M(4)-M(14))) * den(666)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(36)*(M(14)-M(22))+c(31)*(M(10)-M(16)-M(18)+M(24))) * den(611)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(36)*(M(12)-M(20))+c(31)*(M(10)-M(16)-M(18)+M(24))) * den(611)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(36)*(M(12)-M(14)-M(20)+M(22))) * den(611)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(36)*(-M(4)+M(12))+c(31)*(M(10)-M(18))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(31)*(M(10)-M(18))+c(36)*(M(6)-M(22))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(36)*(M(4)+M(6)-M(12)-M(22))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(36)*M(4))+c(31)*(-M(2)-M(8)+M(10)+M(16)-M(26))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(36)*M(14))+c(31)*(-M(2)-M(8)+M(16)+M(18)-M(26))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(36)*(M(4)-M(14))+c(31)*(-M(10)+M(18))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(46)*(M(8)-M(10)+M(26))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(46)*(M(8)-M(18)+M(26))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(46)*(M(10)-M(18))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(51)*M(4))+c(46)*(-M(8)+M(16))) * den(40)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(51)*M(12))+c(46)*(-M(8)+M(16))) * den(40)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(51)*(M(4)-M(12))) * den(40)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(51)*M(6))+c(46)*(-M(8)+M(24))) * den(635)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(51)*M(22))+c(46)*(-M(8)+M(24))) * den(635)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(51)*(M(6)-M(22))) * den(635)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(31)*(-M(10)+M(18))+c(36)*(-M(6)+M(20))) * den(334)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(36)*(M(4)-M(14))+c(31)*(-M(10)+M(18))) * den(334)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(36)*(M(4)+M(6)-M(14)-M(20))) * den(334)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(36)*M(6))+c(31)*(-M(2)-M(8)+M(18)+M(24)-M(26))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(36)*M(22))+c(31)*(-M(2)-M(8)+M(10)+M(24)-M(26))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(31)*(M(10)-M(18))+c(36)*(M(6)-M(22))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(46)*(M(2)-M(18)+M(26))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(46)*(M(2)-M(10)+M(26))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(46)*(-M(10)+M(18))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(51)*M(6))+c(46)*(-M(2)+M(10))) * den(199)
  T2sum(1:5,35) = T2sum(1:5,35) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(46)*(-M(2)+M(10))-c(51)*M(14)) * den(199)
  T2sum(1:5,35) = T2sum(1:5,35) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(51)*(M(6)-M(14))) * den(199)
  T2sum(1:5,35) = T2sum(1:5,35) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(51)*M(4))+c(46)*(-M(2)+M(18))) * den(934)
  T2sum(1:5,36) = T2sum(1:5,36) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(46)*(-M(2)+M(18))-c(51)*M(20)) * den(934)
  T2sum(1:5,36) = T2sum(1:5,36) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(51)*(M(4)-M(20))) * den(934)
  T2sum(1:5,36) = T2sum(1:5,36) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(36)*M(4))+c(31)*(-M(2)-M(8)+M(18)+M(24)-M(26))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(36)*M(20))+c(31)*(-M(2)-M(8)+M(16)+M(18)-M(26))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(36)*(M(4)-M(20))+c(31)*(M(16)-M(24))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(46)*(M(8)-M(24)+M(26))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(46)*(M(8)-M(16)+M(26))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(46)*(-M(16)+M(24))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(36)*M(12))+c(31)*(-M(2)-M(8)+M(10)+M(24)-M(26))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(36)*M(20))+c(31)*(-M(2)-M(8)+M(16)+M(18)-M(26))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(36)*(M(12)-M(20))+c(31)*(-M(10)+M(16)+M(18)-M(24))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(51)*(M(12)-M(14)-M(20)+M(22))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(51)*(-M(12)-M(22))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(51)*(-M(14)-M(20))+c(46)*(M(10)+M(16)+M(18)+M(24))+c(48)*(-M(2)-M(8)-M(26))) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(31)*M(18))+c(36)*M(22)) * den(490)
  T2sum(1:15,254) = T2sum(1:15,254) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(31)*M(8))) * den(185)
  T3sum(1:35,373) = T3sum(1:35,373) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(46)*(-M(8)+M(18))-c(51)*M(22)) * den(185)
  T3sum(1:35,378) = T3sum(1:35,378) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(31)*M(10)-c(36)*M(12)) * den(572)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(31)*M(8)) * den(962)
  T3sum(1:35,380) = T3sum(1:35,380) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(46)*(-M(8)+M(10))-c(51)*M(12)) * den(962)
  T3sum(1:35,390) = T3sum(1:35,390) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(31)*M(10))+c(36)*M(14)) * den(494)
  T2sum(1:15,254) = T2sum(1:15,254) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(31)*M(2))) * den(199)
  T3sum(1:35,397) = T3sum(1:35,397) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(46)*(-M(2)+M(10))-c(51)*M(14)) * den(199)
  T3sum(1:35,402) = T3sum(1:35,402) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(31)*M(18)-c(36)*M(20)) * den(576)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(31)*M(2)) * den(934)
  T3sum(1:35,404) = T3sum(1:35,404) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(46)*(-M(2)+M(18))-c(51)*M(20)) * den(934)
  T3sum(1:35,414) = T3sum(1:35,414) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(46)*(M(10)-M(18))+c(51)*(-M(14)+M(22))) * den(225)
  T2sum(1:15,254) = T2sum(1:15,254) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(46)*(-M(10)+M(18))+c(51)*(M(12)-M(20))) * den(580)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(36)*(M(12)-M(20))+c(31)*(-M(10)+M(16)+M(18)-M(24))) * den(608)
  T3sum(1:35,45) = T3sum(1:35,45) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(46)*(-M(16)+M(24))) * den(608)
  T3sum(1:35,423) = T3sum(1:35,423) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(36)*M(12))+c(31)*(-M(2)-M(8)+M(10)+M(24)-M(26))) * den(2)
  T4sum(1:70,169) = T4sum(1:70,169) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(36)*M(20))+c(31)*(-M(2)-M(8)+M(16)+M(18)-M(26))) * den(2)
  T4sum(1:70,174) = T4sum(1:70,174) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(46)*(M(2)-M(24)+M(26))) * den(2)
  T4sum(1:70,180) = T4sum(1:70,180) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(31)*(M(24)-M(26))) * den(2)
  T4sum(1:70,182) = T4sum(1:70,182) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(46)*(M(8)-M(16)+M(26))) * den(2)
  T4sum(1:70,184) = T4sum(1:70,184) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(31)*(M(16)-M(26))) * den(2)
  T4sum(1:70,186) = T4sum(1:70,186) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(40)*(-M(4)-M(6))+c(38)*(M(10)+M(16)+M(18)+M(24))+c(39)*(-M(2)-M(8)-M(26))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(40)*(-M(14)-M(20))+c(38)*(M(10)+M(16)+M(18)+M(24))+c(39)*(-M(2)-M(8)-M(26))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(40)*(M(4)+M(6)-M(14)-M(20))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(40)*(-M(14)-M(20))+c(38)*(M(10)+M(16)+M(18)+M(24))+c(39)*(-M(2)-M(8)-M(26))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(40)*(-M(4)-M(6))+c(38)*(M(10)+M(16)+M(18)+M(24))+c(39)*(-M(2)-M(8)-M(26))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(40)*(-M(4)-M(6)+M(14)+M(20))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(40)*(M(4)+M(6)-M(14)-M(20))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(40)*(-M(4)-M(6)+M(14)+M(20))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(41)*(-M(4)-M(6)+M(14)+M(20))) * den(3)
  T2sum(1:1,603) = T2sum(1:1,603) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(40)*(-M(12)+M(14)+M(20)-M(22))) * den(1499)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(40)*(M(12)-M(14)-M(20)+M(22))) * den(1499)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(41)*(M(12)-M(14)-M(20)+M(22))) * den(1499)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(40)*(-M(4)-M(6)+M(12)+M(22))) * den(11)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(40)*(M(4)+M(6)-M(12)-M(22))) * den(11)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(41)*(M(4)+M(6)-M(12)-M(22))) * den(11)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(40)*(M(4)+M(6)-M(14)-M(20))) * den(14)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(40)*(-M(4)-M(6)+M(14)+M(20))) * den(14)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(41)*(-M(4)-M(6)+M(14)+M(20))) * den(14)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(40)*(-M(4)-M(6)+M(14)+M(20))) * den(337)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(40)*(M(4)+M(6)-M(14)-M(20))) * den(337)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(41)*(M(4)+M(6)-M(14)-M(20))) * den(337)
  T2sum(1:5,607) = T2sum(1:5,607) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(25)*(M(6)-M(20))) * den(33)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(25)*(-M(6)+M(20))) * den(33)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(26)*(-M(6)+M(20))) * den(33)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(25)*(-M(4)+M(14))) * den(50)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(25)*(M(4)-M(14))) * den(50)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(26)*(M(4)-M(14))) * den(50)
  T2sum(1:5,603) = T2sum(1:5,603) + Gcoeff * G1tensor(:,27)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_pptttt_ew_tttxtxgg_1_/**/REALKIND
