
module ol_vamp_2_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxbbx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,47) :: G0
  complex(REALKIND), dimension(4,5,4,130) :: G1
  complex(REALKIND), dimension(4,15,4,173) :: G2
  complex(REALKIND), dimension(4,35,4,29) :: G3
  complex(REALKIND), dimension(5,24) :: G1tensor
  complex(REALKIND), dimension(15,22) :: G2tensor
  complex(REALKIND), dimension(35,98) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-3),G0(:,:,:,3))
  call loop_A_Q(G0(:,:,:,3),Q(:,61),MT,G1(:,:,:,1))
  call check_last_AQ_V(l_switch,G1(:,:,:,1),wf(:,-1),G1tensor(:,1))
  call check_last_UV_W(l_switch,G0(:,:,:,2),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,2))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,1),G0(:,:,:,4))
  call loop_VA_Q(G0(:,:,:,4),wf(:,-3),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,61),MT,G1(:,:,:,2))
  call check_last_AQ_V(l_switch,G1(:,:,:,2),wf(:,-1),G1tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,4),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,4))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,6))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-3),G0(:,:,:,7))
  call loop_A_Q(G0(:,:,:,7),Q(:,61),MT,G1(:,:,:,3))
  call check_last_AQ_V(l_switch,G1(:,:,:,3),wf(:,-1),G1tensor(:,5))
  call check_last_UV_W(l_switch,G0(:,:,:,6),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,6))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,80),G0(:,:,:,8))
  call loop_VA_Q(G0(:,:,:,8),wf(:,-3),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,62),MT,G1(:,:,:,4))
  call check_last_AQ_V(l_switch,G1(:,:,:,4),wf(:,0),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,8),Q(:,54),wf(:,79),Q(:,9),G1tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,80),wf(:,3),G0(:,:,:,10))
  call loop_VA_Q(G0(:,:,:,10),wf(:,-3),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,62),MT,G1(:,:,:,5))
  call check_last_AQ_V(l_switch,G1(:,:,:,5),wf(:,0),G1tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,10),Q(:,54),wf(:,79),Q(:,9),G1tensor(:,10))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,80),G0(:,:,:,12))
  call loop_VA_Q(G0(:,:,:,12),wf(:,-3),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,62),MT,G1(:,:,:,6))
  call check_last_AQ_V(l_switch,G1(:,:,:,6),wf(:,0),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,12),Q(:,54),wf(:,79),Q(:,9),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,79),G0(:,:,:,14))
  call loop_VA_Q(G0(:,:,:,14),wf(:,-2),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,61),MT,G1(:,:,:,7))
  call check_last_AQ_V(l_switch,G1(:,:,:,7),wf(:,-1),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,14),Q(:,57),wf(:,80),Q(:,6),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,79),wf(:,3),G0(:,:,:,16))
  call loop_VA_Q(G0(:,:,:,16),wf(:,-2),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,61),MT,G1(:,:,:,8))
  call check_last_AQ_V(l_switch,G1(:,:,:,8),wf(:,-1),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,16),Q(:,57),wf(:,80),Q(:,6),G1tensor(:,16))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,79),G0(:,:,:,18))
  call loop_VA_Q(G0(:,:,:,18),wf(:,-2),G0(:,:,:,19))
  call loop_A_Q(G0(:,:,:,19),Q(:,61),MT,G1(:,:,:,9))
  call check_last_AQ_V(l_switch,G1(:,:,:,9),wf(:,-1),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,18),Q(:,57),wf(:,80),Q(:,6),G1tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,20))
  call loop_VA_Q(G0(:,:,:,20),wf(:,-2),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,62),MT,G1(:,:,:,10))
  call check_last_AQ_V(l_switch,G1(:,:,:,10),wf(:,0),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,20),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,2),G0(:,:,:,22))
  call loop_VA_Q(G0(:,:,:,22),wf(:,-2),G0(:,:,:,23))
  call loop_A_Q(G0(:,:,:,23),Q(:,62),MT,G1(:,:,:,11))
  call check_last_AQ_V(l_switch,G1(:,:,:,11),wf(:,0),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,22),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,24))
  call loop_VA_Q(G0(:,:,:,24),wf(:,-2),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,62),MT,G1(:,:,:,12))
  call check_last_AQ_V(l_switch,G1(:,:,:,12),wf(:,0),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,24),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,24))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,10),MT,G1(:,:,:,13))
  call loop_AV_Q(G1(:,:,:,13),wf(:,3),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,58),MT,G2(:,:,:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,5),G2(:,:,:,2),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,2),Q(:,63),MT,G3tensor(:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,9),G2(:,:,:,3),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,3),Q(:,63),MT,G3tensor(:,2))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,4))
  call check_last_A_Q(l_switch,G2(:,:,:,4),Q(:,63),MT,G3tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,18),G2(:,:,:,5),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,5),Q(:,63),MT,G3tensor(:,4))
  call loop_AS_Q(G1(:,:,:,13),wf(:,60),G1(:,:,:,15),gH)
  call loop_A_Q(G1(:,:,:,15),Q(:,58),MT,G2(:,:,:,6))
  call loop_AV_Q(G2(:,:,:,6),wf(:,1),G2(:,:,:,7))
  call check_last_A_Q(l_switch,G2(:,:,:,7),Q(:,63),MT,G3tensor(:,5))
  call loop_AS_Q(G1(:,:,:,13),wf(:,62),G1(:,:,:,16),gX)
  call loop_A_Q(G1(:,:,:,16),Q(:,58),MT,G2(:,:,:,8))
  call loop_AV_Q(G2(:,:,:,8),wf(:,1),G2(:,:,:,9))
  call check_last_A_Q(l_switch,G2(:,:,:,9),Q(:,63),MT,G3tensor(:,6))
  call loop_AZ_Q(G1(:,:,:,13),wf(:,66),G1(:,:,:,17),gZu)
  call loop_A_Q(G1(:,:,:,17),Q(:,58),MT,G2(:,:,:,10))
  call loop_AV_Q(G2(:,:,:,10),wf(:,1),G2(:,:,:,11))
  call check_last_A_Q(l_switch,G2(:,:,:,11),Q(:,63),MT,G3tensor(:,7))
  call loop_AQ_S(G1(:,:,:,13),wf(:,-4),G1(:,:,:,18),gPtb)
  call loop_SA_Q(G1(:,:,:,18),wf(:,-5),G1(:,:,:,19),gPbt)
  call loop_A_Q(G1(:,:,:,19),Q(:,58),MT,G2(:,:,:,12))
  call loop_AV_Q(G2(:,:,:,12),wf(:,1),G2(:,:,:,13))
  call check_last_A_Q(l_switch,G2(:,:,:,13),Q(:,63),MT,G3tensor(:,8))
  call loop_AQ_W(G1(:,:,:,13),wf(:,-4),G1(:,:,:,20))
  call loop_WA_Q(G1(:,:,:,20),wf(:,-5),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,58),MT,G2(:,:,:,14))
  call loop_AV_Q(G2(:,:,:,14),wf(:,1),G2(:,:,:,15))
  call check_last_A_Q(l_switch,G2(:,:,:,15),Q(:,63),MT,G3tensor(:,9))
  call loop_AQ_S(G1(:,:,:,13),wf(:,140),G1(:,:,:,22),gH)
  call loop_SA_Q(G1(:,:,:,22),wf(:,-2),G1(:,:,:,23),gH)
  call check_last_A_Q(l_switch,G1(:,:,:,23),Q(:,63),MT,G2tensor(:,1))
  call loop_AQ_S(G1(:,:,:,13),wf(:,140),G1(:,:,:,24),gX)
  call loop_SA_Q(G1(:,:,:,24),wf(:,-2),G1(:,:,:,25),gX)
  call check_last_A_Q(l_switch,G1(:,:,:,25),Q(:,63),MT,G2tensor(:,2))
  call loop_AQ_Z(G1(:,:,:,13),wf(:,140),G1(:,:,:,26),gZu)
  call loop_ZA_Q(G1(:,:,:,26),wf(:,-2),G1(:,:,:,27),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,27),Q(:,63),MT,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,10),MT,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,3),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,58),MT,G2(:,:,:,16))
  call loop_QS_A(G2(:,:,:,16),wf(:,5),G2(:,:,:,17),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,17),Q(:,63),MT,G3tensor(:,10))
  call loop_QS_A(G2(:,:,:,16),wf(:,9),G2(:,:,:,18),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,18),Q(:,63),MT,G3tensor(:,11))
  call loop_QV_A(G2(:,:,:,16),wf(:,1),G2(:,:,:,19))
  call check_last_Q_A(l_switch,G2(:,:,:,19),Q(:,63),MT,G3tensor(:,12))
  call loop_QZ_A(G2(:,:,:,16),wf(:,18),G2(:,:,:,20),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,20),Q(:,63),MT,G3tensor(:,13))
  call loop_QS_A(G1(:,:,:,28),wf(:,60),G1(:,:,:,30),gH)
  call loop_Q_A(G1(:,:,:,30),Q(:,58),MT,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),MT,G3tensor(:,14))
  call loop_QS_A(G1(:,:,:,28),wf(:,62),G1(:,:,:,31),gX)
  call loop_Q_A(G1(:,:,:,31),Q(:,58),MT,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,1),G2(:,:,:,24))
  call check_last_Q_A(l_switch,G2(:,:,:,24),Q(:,63),MT,G3tensor(:,15))
  call loop_QZ_A(G1(:,:,:,28),wf(:,66),G1(:,:,:,32),gZu)
  call loop_Q_A(G1(:,:,:,32),Q(:,58),MT,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,1),G2(:,:,:,26))
  call check_last_Q_A(l_switch,G2(:,:,:,26),Q(:,63),MT,G3tensor(:,16))
  call loop_QA_S(G1(:,:,:,28),wf(:,-5),G1(:,:,:,33),gPbt)
  call loop_SQ_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,34),gPtb)
  call loop_Q_A(G1(:,:,:,34),Q(:,58),MT,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,1),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,17))
  call loop_QA_W(G1(:,:,:,28),wf(:,-5),G1(:,:,:,35))
  call loop_WQ_A(G1(:,:,:,35),wf(:,-4),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,58),MT,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,1),G2(:,:,:,30))
  call check_last_Q_A(l_switch,G2(:,:,:,30),Q(:,63),MT,G3tensor(:,18))
  call loop_QA_S(G1(:,:,:,28),wf(:,434),G1(:,:,:,37),gH)
  call loop_SQ_A(G1(:,:,:,37),wf(:,0),G1(:,:,:,38),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,63),MT,G2tensor(:,4))
  call loop_QA_S(G1(:,:,:,28),wf(:,434),G1(:,:,:,39),gX)
  call loop_SQ_A(G1(:,:,:,39),wf(:,0),G1(:,:,:,40),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),MT,G2tensor(:,5))
  call loop_QA_Z(G1(:,:,:,28),wf(:,434),G1(:,:,:,41),gZu)
  call loop_ZQ_A(G1(:,:,:,41),wf(:,0),G1(:,:,:,42),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),MT,G2tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,10),MB,G1(:,:,:,43))
  call loop_AV_Q(G1(:,:,:,43),wf(:,3),G1(:,:,:,44))
  call loop_A_Q(G1(:,:,:,44),Q(:,58),MB,G2(:,:,:,31))
  call loop_AS_Q(G2(:,:,:,31),wf(:,5),G2(:,:,:,32),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,32),Q(:,63),MB,G3tensor(:,19))
  call loop_AS_Q(G2(:,:,:,31),wf(:,9),G2(:,:,:,33),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,33),Q(:,63),MB,G3tensor(:,20))
  call loop_AV_Q(G2(:,:,:,31),wf(:,1),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),MB,G3tensor(:,21))
  call loop_AZ_Q(G2(:,:,:,31),wf(:,18),G2(:,:,:,35),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,35),Q(:,63),MB,G3tensor(:,22))
  call loop_AS_Q(G1(:,:,:,43),wf(:,60),G1(:,:,:,45),gH)
  call loop_A_Q(G1(:,:,:,45),Q(:,58),MB,G2(:,:,:,36))
  call loop_AV_Q(G2(:,:,:,36),wf(:,1),G2(:,:,:,37))
  call check_last_A_Q(l_switch,G2(:,:,:,37),Q(:,63),MB,G3tensor(:,23))
  call loop_AS_Q(G1(:,:,:,43),wf(:,62),G1(:,:,:,46),gX)
  call loop_A_Q(G1(:,:,:,46),Q(:,58),MB,G2(:,:,:,38))
  call loop_AV_Q(G2(:,:,:,38),wf(:,1),G2(:,:,:,39))
  call check_last_A_Q(l_switch,G2(:,:,:,39),Q(:,63),MB,G3tensor(:,24))
  call loop_AZ_Q(G1(:,:,:,43),wf(:,66),G1(:,:,:,47),gZd)
  call loop_A_Q(G1(:,:,:,47),Q(:,58),MB,G2(:,:,:,40))
  call loop_AV_Q(G2(:,:,:,40),wf(:,1),G2(:,:,:,41))
  call check_last_A_Q(l_switch,G2(:,:,:,41),Q(:,63),MB,G3tensor(:,25))
  call loop_AQ_S(G1(:,:,:,43),wf(:,-4),G1(:,:,:,48),gH)
  call loop_SA_Q(G1(:,:,:,48),wf(:,-5),G1(:,:,:,49),gH)
  call loop_A_Q(G1(:,:,:,49),Q(:,58),MB,G2(:,:,:,42))
  call loop_AV_Q(G2(:,:,:,42),wf(:,1),G2(:,:,:,43))
  call check_last_A_Q(l_switch,G2(:,:,:,43),Q(:,63),MB,G3tensor(:,26))
  call loop_AQ_S(G1(:,:,:,43),wf(:,-4),G1(:,:,:,50),gX)
  call loop_SA_Q(G1(:,:,:,50),wf(:,-5),G1(:,:,:,51),gX)
  call loop_A_Q(G1(:,:,:,51),Q(:,58),MB,G2(:,:,:,44))
  call loop_AV_Q(G2(:,:,:,44),wf(:,1),G2(:,:,:,45))
  call check_last_A_Q(l_switch,G2(:,:,:,45),Q(:,63),MB,G3tensor(:,27))
  call loop_AQ_Z(G1(:,:,:,43),wf(:,-4),G1(:,:,:,52),gZd)
  call loop_ZA_Q(G1(:,:,:,52),wf(:,-5),G1(:,:,:,53),gZd)
  call loop_A_Q(G1(:,:,:,53),Q(:,58),MB,G2(:,:,:,46))
  call loop_AV_Q(G2(:,:,:,46),wf(:,1),G2(:,:,:,47))
  call check_last_A_Q(l_switch,G2(:,:,:,47),Q(:,63),MB,G3tensor(:,28))
  call loop_AQ_S(G1(:,:,:,43),wf(:,140),G1(:,:,:,54),gPbt)
  call loop_SA_Q(G1(:,:,:,54),wf(:,-2),G1(:,:,:,55),gPtb)
  call check_last_A_Q(l_switch,G1(:,:,:,55),Q(:,63),MB,G2tensor(:,7))
  call loop_AQ_W(G1(:,:,:,43),wf(:,140),G1(:,:,:,56))
  call loop_WA_Q(G1(:,:,:,56),wf(:,-2),G1(:,:,:,57))
  call check_last_A_Q(l_switch,G1(:,:,:,57),Q(:,63),MB,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,10),MB,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,3),G1(:,:,:,59))
  call loop_Q_A(G1(:,:,:,59),Q(:,58),MB,G2(:,:,:,48))
  call loop_QS_A(G2(:,:,:,48),wf(:,5),G2(:,:,:,49),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,49),Q(:,63),MB,G3tensor(:,29))
  call loop_QS_A(G2(:,:,:,48),wf(:,9),G2(:,:,:,50),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,50),Q(:,63),MB,G3tensor(:,30))
  call loop_QV_A(G2(:,:,:,48),wf(:,1),G2(:,:,:,51))
  call check_last_Q_A(l_switch,G2(:,:,:,51),Q(:,63),MB,G3tensor(:,31))
  call loop_QZ_A(G2(:,:,:,48),wf(:,18),G2(:,:,:,52),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,32))
  call loop_QS_A(G1(:,:,:,58),wf(:,60),G1(:,:,:,60),gH)
  call loop_Q_A(G1(:,:,:,60),Q(:,58),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,1),G2(:,:,:,54))
  call check_last_Q_A(l_switch,G2(:,:,:,54),Q(:,63),MB,G3tensor(:,33))
  call loop_QS_A(G1(:,:,:,58),wf(:,62),G1(:,:,:,61),gX)
  call loop_Q_A(G1(:,:,:,61),Q(:,58),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,1),G2(:,:,:,56))
  call check_last_Q_A(l_switch,G2(:,:,:,56),Q(:,63),MB,G3tensor(:,34))
  call loop_QZ_A(G1(:,:,:,58),wf(:,66),G1(:,:,:,62),gZd)
  call loop_Q_A(G1(:,:,:,62),Q(:,58),MB,G2(:,:,:,57))
  call loop_QV_A(G2(:,:,:,57),wf(:,1),G2(:,:,:,58))
  call check_last_Q_A(l_switch,G2(:,:,:,58),Q(:,63),MB,G3tensor(:,35))
  call loop_QA_S(G1(:,:,:,58),wf(:,-5),G1(:,:,:,63),gH)
  call loop_SQ_A(G1(:,:,:,63),wf(:,-4),G1(:,:,:,64),gH)
  call loop_Q_A(G1(:,:,:,64),Q(:,58),MB,G2(:,:,:,59))
  call loop_QV_A(G2(:,:,:,59),wf(:,1),G2(:,:,:,60))
  call check_last_Q_A(l_switch,G2(:,:,:,60),Q(:,63),MB,G3tensor(:,36))
  call loop_QA_S(G1(:,:,:,58),wf(:,-5),G1(:,:,:,65),gX)
  call loop_SQ_A(G1(:,:,:,65),wf(:,-4),G1(:,:,:,66),gX)
  call loop_Q_A(G1(:,:,:,66),Q(:,58),MB,G2(:,:,:,61))
  call loop_QV_A(G2(:,:,:,61),wf(:,1),G2(:,:,:,62))
  call check_last_Q_A(l_switch,G2(:,:,:,62),Q(:,63),MB,G3tensor(:,37))
  call loop_QA_Z(G1(:,:,:,58),wf(:,-5),G1(:,:,:,67),gZd)
  call loop_ZQ_A(G1(:,:,:,67),wf(:,-4),G1(:,:,:,68),gZd)
  call loop_Q_A(G1(:,:,:,68),Q(:,58),MB,G2(:,:,:,63))
  call loop_QV_A(G2(:,:,:,63),wf(:,1),G2(:,:,:,64))
  call check_last_Q_A(l_switch,G2(:,:,:,64),Q(:,63),MB,G3tensor(:,38))
  call loop_QA_S(G1(:,:,:,58),wf(:,434),G1(:,:,:,69),gPtb)
  call loop_SQ_A(G1(:,:,:,69),wf(:,0),G1(:,:,:,70),gPbt)
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,63),MB,G2tensor(:,9))
  call loop_QA_W(G1(:,:,:,58),wf(:,434),G1(:,:,:,71))
  call loop_WQ_A(G1(:,:,:,71),wf(:,0),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),MB,G2tensor(:,10))
  call loop_AS_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,30),gH)
  call loop_A_Q(G0(:,:,:,30),Q(:,10),MT,G1(:,:,:,73))
  call loop_AV_Q(G1(:,:,:,73),wf(:,3),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,58),MT,G2(:,:,:,65))
  call loop_AV_Q(G2(:,:,:,65),wf(:,1),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,39))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,31),gH)
  call loop_Q_A(G0(:,:,:,31),Q(:,10),MT,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,3),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,58),MT,G2(:,:,:,67))
  call loop_QV_A(G2(:,:,:,67),wf(:,1),G2(:,:,:,68))
  call check_last_Q_A(l_switch,G2(:,:,:,68),Q(:,63),MT,G3tensor(:,40))
  call loop_AS_Q(G0(:,:,:,1),wf(:,12),G0(:,:,:,32),gH)
  call loop_A_Q(G0(:,:,:,32),Q(:,10),MB,G1(:,:,:,77))
  call loop_AV_Q(G1(:,:,:,77),wf(:,3),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,58),MB,G2(:,:,:,69))
  call loop_AV_Q(G2(:,:,:,69),wf(:,1),G2(:,:,:,70))
  call check_last_A_Q(l_switch,G2(:,:,:,70),Q(:,63),MB,G3tensor(:,41))
  call loop_QS_A(G0(:,:,:,1),wf(:,12),G0(:,:,:,33),gH)
  call loop_Q_A(G0(:,:,:,33),Q(:,10),MB,G1(:,:,:,79))
  call loop_QV_A(G1(:,:,:,79),wf(:,3),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,58),MB,G2(:,:,:,71))
  call loop_QV_A(G2(:,:,:,71),wf(:,1),G2(:,:,:,72))
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MB,G3tensor(:,42))
  call loop_AS_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,34),gX)
  call loop_A_Q(G0(:,:,:,34),Q(:,10),MT,G1(:,:,:,81))
  call loop_AV_Q(G1(:,:,:,81),wf(:,3),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,58),MT,G2(:,:,:,73))
  call loop_AV_Q(G2(:,:,:,73),wf(:,1),G2(:,:,:,74))
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MT,G3tensor(:,43))
  call loop_QS_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,35),gX)
  call loop_Q_A(G0(:,:,:,35),Q(:,10),MT,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,3),G1(:,:,:,84))
  call loop_Q_A(G1(:,:,:,84),Q(:,58),MT,G2(:,:,:,75))
  call loop_QV_A(G2(:,:,:,75),wf(:,1),G2(:,:,:,76))
  call check_last_Q_A(l_switch,G2(:,:,:,76),Q(:,63),MT,G3tensor(:,44))
  call loop_AS_Q(G0(:,:,:,1),wf(:,16),G0(:,:,:,36),gX)
  call loop_A_Q(G0(:,:,:,36),Q(:,10),MB,G1(:,:,:,85))
  call loop_AV_Q(G1(:,:,:,85),wf(:,3),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,58),MB,G2(:,:,:,77))
  call loop_AV_Q(G2(:,:,:,77),wf(:,1),G2(:,:,:,78))
  call check_last_A_Q(l_switch,G2(:,:,:,78),Q(:,63),MB,G3tensor(:,45))
  call loop_QS_A(G0(:,:,:,1),wf(:,16),G0(:,:,:,37),gX)
  call loop_Q_A(G0(:,:,:,37),Q(:,10),MB,G1(:,:,:,87))
  call loop_QV_A(G1(:,:,:,87),wf(:,3),G1(:,:,:,88))
  call loop_Q_A(G1(:,:,:,88),Q(:,58),MB,G2(:,:,:,79))
  call loop_QV_A(G2(:,:,:,79),wf(:,1),G2(:,:,:,80))
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MB,G3tensor(:,46))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,10),ZERO,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,3),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,58),ZERO,G2(:,:,:,81))
  call loop_AV_Q(G2(:,:,:,81),wf(:,1),G2(:,:,:,82))
  call check_last_A_Q(l_switch,G2(:,:,:,82),Q(:,63),ZERO,G3tensor(:,47))
  call loop_AZ_Q(G2(:,:,:,81),wf(:,18),G2(:,:,:,83),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,83),Q(:,63),ZERO,G3tensor(:,48))
  call loop_AZ_Q(G2(:,:,:,81),wf(:,18),G2(:,:,:,84),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,49))
  call loop_AZ_Q(G1(:,:,:,89),wf(:,66),G1(:,:,:,91),gZu)
  call loop_A_Q(G1(:,:,:,91),Q(:,58),ZERO,G2(:,:,:,85))
  call loop_AV_Q(G2(:,:,:,85),wf(:,1),G2(:,:,:,86))
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,50))
  call loop_AZ_Q(G1(:,:,:,89),wf(:,66),G1(:,:,:,92),gZd)
  call loop_A_Q(G1(:,:,:,92),Q(:,58),ZERO,G2(:,:,:,87))
  call loop_AV_Q(G2(:,:,:,87),wf(:,1),G2(:,:,:,88))
  call check_last_A_Q(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,51))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,10),ZERO,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,3),G1(:,:,:,94))
  call loop_Q_A(G1(:,:,:,94),Q(:,58),ZERO,G2(:,:,:,89))
  call loop_QV_A(G2(:,:,:,89),wf(:,1),G2(:,:,:,90))
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,52))
  call loop_QZ_A(G2(:,:,:,89),wf(:,18),G2(:,:,:,91),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,91),Q(:,63),ZERO,G3tensor(:,53))
  call loop_QZ_A(G2(:,:,:,89),wf(:,18),G2(:,:,:,92),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,92),Q(:,63),ZERO,G3tensor(:,54))
  call loop_QZ_A(G1(:,:,:,93),wf(:,66),G1(:,:,:,95),gZu)
  call loop_Q_A(G1(:,:,:,95),Q(:,58),ZERO,G2(:,:,:,93))
  call loop_QV_A(G2(:,:,:,93),wf(:,1),G2(:,:,:,94))
  call check_last_Q_A(l_switch,G2(:,:,:,94),Q(:,63),ZERO,G3tensor(:,55))
  call loop_QZ_A(G1(:,:,:,93),wf(:,66),G1(:,:,:,96),gZd)
  call loop_Q_A(G1(:,:,:,96),Q(:,58),ZERO,G2(:,:,:,95))
  call loop_QV_A(G2(:,:,:,95),wf(:,1),G2(:,:,:,96))
  call check_last_Q_A(l_switch,G2(:,:,:,96),Q(:,63),ZERO,G3tensor(:,56))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,40),gZu)
  call loop_A_Q(G0(:,:,:,40),Q(:,10),ZERO,G1(:,:,:,97))
  call loop_AV_Q(G1(:,:,:,97),wf(:,3),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,58),ZERO,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,1),G2(:,:,:,98))
  call check_last_A_Q(l_switch,G2(:,:,:,98),Q(:,63),ZERO,G3tensor(:,57))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,41),gZu)
  call loop_A_Q(G0(:,:,:,41),Q(:,10),MT,G1(:,:,:,99))
  call loop_AV_Q(G1(:,:,:,99),wf(:,3),G1(:,:,:,100))
  call loop_A_Q(G1(:,:,:,100),Q(:,58),MT,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,1),G2(:,:,:,100))
  call check_last_A_Q(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,58))
  call loop_QZ_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,42),gZu)
  call loop_Q_A(G0(:,:,:,42),Q(:,10),ZERO,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,3),G1(:,:,:,102))
  call loop_Q_A(G1(:,:,:,102),Q(:,58),ZERO,G2(:,:,:,101))
  call loop_QV_A(G2(:,:,:,101),wf(:,1),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),ZERO,G3tensor(:,59))
  call loop_QZ_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,43),gZu)
  call loop_Q_A(G0(:,:,:,43),Q(:,10),MT,G1(:,:,:,103))
  call loop_QV_A(G1(:,:,:,103),wf(:,3),G1(:,:,:,104))
  call loop_Q_A(G1(:,:,:,104),Q(:,58),MT,G2(:,:,:,103))
  call loop_QV_A(G2(:,:,:,103),wf(:,1),G2(:,:,:,104))
  call check_last_Q_A(l_switch,G2(:,:,:,104),Q(:,63),MT,G3tensor(:,60))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,44),gZd)
  call loop_A_Q(G0(:,:,:,44),Q(:,10),ZERO,G1(:,:,:,105))
  call loop_AV_Q(G1(:,:,:,105),wf(:,3),G1(:,:,:,106))
  call loop_A_Q(G1(:,:,:,106),Q(:,58),ZERO,G2(:,:,:,105))
  call loop_AV_Q(G2(:,:,:,105),wf(:,1),G2(:,:,:,106))
  call check_last_A_Q(l_switch,G2(:,:,:,106),Q(:,63),ZERO,G3tensor(:,61))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,21),G0(:,:,:,45),gZd)
  call loop_A_Q(G0(:,:,:,45),Q(:,10),MB,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,3),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,58),MB,G2(:,:,:,107))
  call loop_AV_Q(G2(:,:,:,107),wf(:,1),G2(:,:,:,108))
  call check_last_A_Q(l_switch,G2(:,:,:,108),Q(:,63),MB,G3tensor(:,62))
  call loop_QZ_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,46),gZd)
  call loop_Q_A(G0(:,:,:,46),Q(:,10),ZERO,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,3),G1(:,:,:,110))
  call loop_Q_A(G1(:,:,:,110),Q(:,58),ZERO,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,1),G2(:,:,:,110))
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),ZERO,G3tensor(:,63))
  call loop_QZ_A(G0(:,:,:,1),wf(:,21),G0(:,:,:,47),gZd)
  call loop_Q_A(G0(:,:,:,47),Q(:,10),MB,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,3),G1(:,:,:,112))
  call loop_Q_A(G1(:,:,:,112),Q(:,58),MB,G2(:,:,:,111))
  call loop_QV_A(G2(:,:,:,111),wf(:,1),G2(:,:,:,112))
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,63),MB,G3tensor(:,64))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,113))
  call loop_DV_C(G1(:,:,:,113),Q(:,10),wf(:,3),G2(:,:,:,113))
  call check_last_DV_C(l_switch,G2(:,:,:,113),Q(:,58),wf(:,1),G3tensor(:,65))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,114))
  call loop_CV_D(G1(:,:,:,114),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,114))
  call check_last_CV_D(l_switch,G2(:,:,:,114),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,66))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,115))
  call loop_UV_W(G1(:,:,:,115),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,115))
  call check_last_UV_W(l_switch,G2(:,:,:,115),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,115),wf(:,-2),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,68))
  call loop_VA_Q(G1(:,:,:,115),wf(:,-5),G1(:,:,:,116))
  call loop_A_Q(G1(:,:,:,116),Q(:,42),MB,G2(:,:,:,117))
  call loop_AQ_V(G2(:,:,:,117),wf(:,-4),G2(:,:,:,118))
  call check_last_UV_W(l_switch,G2(:,:,:,118),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,69))
  call loop_VA_Q(G2(:,:,:,118),wf(:,-2),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,62),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,70))
  call loop_AS_Q(G2(:,:,:,117),wf(:,145),G2(:,:,:,120),gPbt)
  call loop_A_Q(G2(:,:,:,120),Q(:,62),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,0),G3tensor(:,71))
  call loop_AW_Q(G2(:,:,:,117),wf(:,149),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,62),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,0),G3tensor(:,72))
  call loop_AQ_S(G2(:,:,:,117),wf(:,-4),G2(:,:,:,122),gH)
  call loop_SQ_A(G2(:,:,:,122),wf(:,0),G2(:,:,:,123),gH)
  call loop_Q_A(G2(:,:,:,123),Q(:,59),MT,G3(:,:,:,5))
  call check_last_QA_V(l_switch,G3(:,:,:,5),wf(:,-2),G3tensor(:,73))
  call loop_SA_Q(G2(:,:,:,122),wf(:,-2),G2(:,:,:,124),gH)
  call loop_A_Q(G2(:,:,:,124),Q(:,62),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,74))
  call loop_AQ_S(G2(:,:,:,117),wf(:,-4),G2(:,:,:,125),gX)
  call loop_SQ_A(G2(:,:,:,125),wf(:,0),G2(:,:,:,126),gX)
  call loop_Q_A(G2(:,:,:,126),Q(:,59),MT,G3(:,:,:,7))
  call check_last_QA_V(l_switch,G3(:,:,:,7),wf(:,-2),G3tensor(:,75))
  call loop_SA_Q(G2(:,:,:,125),wf(:,-2),G2(:,:,:,127),gX)
  call loop_A_Q(G2(:,:,:,127),Q(:,62),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,76))
  call loop_AQ_Z(G2(:,:,:,117),wf(:,-4),G2(:,:,:,128),gZd)
  call loop_ZQ_A(G2(:,:,:,128),wf(:,0),G2(:,:,:,129),gZu)
  call loop_Q_A(G2(:,:,:,129),Q(:,59),MT,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,77))
  call loop_ZA_Q(G2(:,:,:,128),wf(:,-2),G2(:,:,:,130),gZu)
  call loop_A_Q(G2(:,:,:,130),Q(:,62),MT,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,78))
  call loop_AQ_S(G2(:,:,:,117),wf(:,0),G2(:,:,:,131),gPbt)
  call loop_SQ_A(G2(:,:,:,131),wf(:,-4),G2(:,:,:,132),gPtb)
  call loop_Q_A(G2(:,:,:,132),Q(:,59),MT,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,79))
  call loop_AQ_W(G2(:,:,:,117),wf(:,0),G2(:,:,:,133))
  call loop_WQ_A(G2(:,:,:,133),wf(:,-4),G2(:,:,:,134))
  call loop_Q_A(G2(:,:,:,134),Q(:,59),MT,G3(:,:,:,12))
  call check_last_QA_V(l_switch,G3(:,:,:,12),wf(:,-2),G3tensor(:,80))
  call loop_VQ_A(G1(:,:,:,115),wf(:,-4),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,26),MB,G2(:,:,:,135))
  call loop_QA_V(G2(:,:,:,135),wf(:,-5),G2(:,:,:,136))
  call check_last_UV_W(l_switch,G2(:,:,:,136),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,81))
  call loop_VA_Q(G2(:,:,:,136),wf(:,-2),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,62),MT,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,82))
  call loop_QS_A(G2(:,:,:,135),wf(:,118),G2(:,:,:,138),gPtb)
  call loop_Q_A(G2(:,:,:,138),Q(:,59),MT,G3(:,:,:,14))
  call check_last_QA_V(l_switch,G3(:,:,:,14),wf(:,-2),G3tensor(:,83))
  call loop_QW_A(G2(:,:,:,135),wf(:,121),G2(:,:,:,139))
  call loop_Q_A(G2(:,:,:,139),Q(:,59),MT,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,84))
  call loop_QA_S(G2(:,:,:,135),wf(:,-5),G2(:,:,:,140),gH)
  call loop_SQ_A(G2(:,:,:,140),wf(:,0),G2(:,:,:,141),gH)
  call loop_Q_A(G2(:,:,:,141),Q(:,59),MT,G3(:,:,:,16))
  call check_last_QA_V(l_switch,G3(:,:,:,16),wf(:,-2),G3tensor(:,85))
  call loop_SA_Q(G2(:,:,:,140),wf(:,-2),G2(:,:,:,142),gH)
  call loop_A_Q(G2(:,:,:,142),Q(:,62),MT,G3(:,:,:,17))
  call check_last_AQ_V(l_switch,G3(:,:,:,17),wf(:,0),G3tensor(:,86))
  call loop_QA_S(G2(:,:,:,135),wf(:,-5),G2(:,:,:,143),gX)
  call loop_SQ_A(G2(:,:,:,143),wf(:,0),G2(:,:,:,144),gX)
  call loop_Q_A(G2(:,:,:,144),Q(:,59),MT,G3(:,:,:,18))
  call check_last_QA_V(l_switch,G3(:,:,:,18),wf(:,-2),G3tensor(:,87))
  call loop_SA_Q(G2(:,:,:,143),wf(:,-2),G2(:,:,:,145),gX)
  call loop_A_Q(G2(:,:,:,145),Q(:,62),MT,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,0),G3tensor(:,88))
  call loop_QA_Z(G2(:,:,:,135),wf(:,-5),G2(:,:,:,146),gZd)
  call loop_ZQ_A(G2(:,:,:,146),wf(:,0),G2(:,:,:,147),gZu)
  call loop_Q_A(G2(:,:,:,147),Q(:,59),MT,G3(:,:,:,20))
  call check_last_QA_V(l_switch,G3(:,:,:,20),wf(:,-2),G3tensor(:,89))
  call loop_ZA_Q(G2(:,:,:,146),wf(:,-2),G2(:,:,:,148),gZu)
  call loop_A_Q(G2(:,:,:,148),Q(:,62),MT,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,0),G3tensor(:,90))
  call loop_QA_S(G2(:,:,:,135),wf(:,-2),G2(:,:,:,149),gPtb)
  call loop_SA_Q(G2(:,:,:,149),wf(:,-5),G2(:,:,:,150),gPbt)
  call loop_A_Q(G2(:,:,:,150),Q(:,62),MT,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,0),G3tensor(:,91))
  call loop_QA_W(G2(:,:,:,135),wf(:,-2),G2(:,:,:,151))
  call loop_WA_Q(G2(:,:,:,151),wf(:,-5),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,62),MT,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,0),G3tensor(:,92))
  call loop_VA_Q(G1(:,:,:,115),wf(:,428),G1(:,:,:,118))
  call loop_A_Q(G1(:,:,:,118),Q(:,62),MT,G2(:,:,:,153))
  call check_last_AQ_V(l_switch,G2(:,:,:,153),wf(:,0),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,115),wf(:,429),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,154))
  call check_last_AQ_V(l_switch,G2(:,:,:,154),wf(:,0),G2tensor(:,12))
  call loop_VQ_A(G1(:,:,:,115),wf(:,324),G1(:,:,:,120))
  call loop_Q_A(G1(:,:,:,120),Q(:,59),MT,G2(:,:,:,155))
  call check_last_QA_V(l_switch,G2(:,:,:,155),wf(:,-2),G2tensor(:,13))
  call loop_VQ_A(G1(:,:,:,115),wf(:,325),G1(:,:,:,121))
  call loop_Q_A(G1(:,:,:,121),Q(:,59),MT,G2(:,:,:,156))
  call check_last_QA_V(l_switch,G2(:,:,:,156),wf(:,-2),G2tensor(:,14))
  call loop_VQ_A(G1(:,:,:,115),wf(:,135),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,59),MT,G2(:,:,:,157))
  call check_last_QA_V(l_switch,G2(:,:,:,157),wf(:,-2),G2tensor(:,15))
  call loop_VQ_A(G1(:,:,:,115),wf(:,137),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,59),MT,G2(:,:,:,158))
  call check_last_QA_V(l_switch,G2(:,:,:,158),wf(:,-2),G2tensor(:,16))
  call loop_VQ_A(G1(:,:,:,115),wf(:,140),G1(:,:,:,124))
  call loop_Q_A(G1(:,:,:,124),Q(:,59),MT,G2(:,:,:,159))
  call check_last_QA_V(l_switch,G2(:,:,:,159),wf(:,-2),G2tensor(:,17))
  call loop_VQ_A(G1(:,:,:,115),wf(:,143),G1(:,:,:,125))
  call loop_Q_A(G1(:,:,:,125),Q(:,59),MT,G2(:,:,:,160))
  call check_last_QA_V(l_switch,G2(:,:,:,160),wf(:,-2),G2tensor(:,18))
  call loop_VA_Q(G1(:,:,:,115),wf(:,436),G1(:,:,:,126))
  call loop_A_Q(G1(:,:,:,126),Q(:,62),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,0),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,115),wf(:,437),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,62),MT,G2(:,:,:,162))
  call check_last_AQ_V(l_switch,G2(:,:,:,162),wf(:,0),G2tensor(:,20))
  call loop_VA_Q(G1(:,:,:,115),wf(:,434),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,163))
  call check_last_AQ_V(l_switch,G2(:,:,:,163),wf(:,0),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,115),wf(:,439),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,62),MT,G2(:,:,:,164))
  call check_last_AQ_V(l_switch,G2(:,:,:,164),wf(:,0),G2tensor(:,22))
  call loop_VA_Q(G1(:,:,:,115),wf(:,-2),G1(:,:,:,130))
  call loop_A_Q(G1(:,:,:,130),Q(:,14),MT,G2(:,:,:,165))
  call loop_AS_Q(G2(:,:,:,165),wf(:,60),G2(:,:,:,166),gH)
  call loop_A_Q(G2(:,:,:,166),Q(:,62),MT,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,0),G3tensor(:,93))
  call loop_AS_Q(G2(:,:,:,165),wf(:,62),G2(:,:,:,167),gX)
  call loop_A_Q(G2(:,:,:,167),Q(:,62),MT,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,0),G3tensor(:,94))
  call loop_AV_Q(G2(:,:,:,165),wf(:,3),G2(:,:,:,168))
  call loop_A_Q(G2(:,:,:,168),Q(:,62),MT,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,0),G3tensor(:,95))
  call loop_AZ_Q(G2(:,:,:,165),wf(:,66),G2(:,:,:,169),gZu)
  call loop_A_Q(G2(:,:,:,169),Q(:,62),MT,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,0),G3tensor(:,96))
  call loop_AQ_S(G2(:,:,:,165),wf(:,-4),G2(:,:,:,170),gPtb)
  call loop_SA_Q(G2(:,:,:,170),wf(:,-5),G2(:,:,:,171),gPbt)
  call loop_A_Q(G2(:,:,:,171),Q(:,62),MT,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,0),G3tensor(:,97))
  call loop_AQ_W(G2(:,:,:,165),wf(:,-4),G2(:,:,:,172))
  call loop_WA_Q(G2(:,:,:,172),wf(:,-5),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,62),MT,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,98))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(69)*M(4))+c(64)*(-M(2)+M(8)+M(10))) * den(288)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(69)*M(6))+c(64)*(-M(2)+M(8)+M(10))) * den(288)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(69)*(M(4)-M(6))) * den(288)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(69)*M(2)+c(64)*(-M(4)+M(6)-M(12))) * den(350)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(69)*M(8)+c(64)*(-M(4)+M(6)-M(12))) * den(350)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(69)*(-M(2)+M(8))) * den(350)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(69)*M(8)+c(64)*(M(4)-M(6)-M(12))) * den(354)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(69)*M(2)+c(64)*(M(4)-M(6)-M(12))) * den(354)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(69)*(M(2)-M(8))) * den(354)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,17)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)-M(8)+M(10))) * den(284)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,19)
  Gcoeff = (-(c(69)*M(4))+c(64)*(M(2)-M(8)+M(10))) * den(284)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(69)*(-M(4)+M(6))) * den(284)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(168)*M(7))+c(167)*M(11)) * den(640)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(168)*M(7))+c(167)*M(11)) * den(640)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(164)*M(7))+c(163)*M(11)) * den(640)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(164)*M(7))+c(163)*M(11)) * den(640)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(168)*M(7)-c(167)*M(11)) * den(641)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(168)*M(7)-c(167)*M(11)) * den(641)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(164)*M(7))+c(163)*M(11)) * den(641)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(164)*M(7))+c(163)*M(11)) * den(641)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,30)
  Gcoeff = (-(c(168)*M(1))+c(167)*M(11)) * den(642)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,39)
  Gcoeff = (-(c(168)*M(1))+c(167)*M(11)) * den(642)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(164)*M(1))+c(163)*M(11)) * den(642)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(164)*M(1))+c(163)*M(11)) * den(642)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(168)*M(1)-c(167)*M(11)) * den(643)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(168)*M(1)-c(167)*M(11)) * den(643)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(164)*M(1))+c(163)*M(11)) * den(643)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,45)
  Gcoeff = (-(c(164)*M(1))+c(163)*M(11)) * den(643)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(644)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(644)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(162)*M(9))+c(161)*M(11)) * den(644)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(162)*M(9))+c(161)*M(11)) * den(644)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(645)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(645)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(162)*M(9)-c(161)*M(11)) * den(645)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(162)*M(9)-c(161)*M(11)) * den(645)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(138)*M(7)-c(137)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(136)*M(7)-c(135)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(138)*M(7)-c(137)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(136)*M(7)-c(135)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(136)*M(7))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(134)*M(7))+c(133)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(136)*M(7))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(134)*M(7))+c(133)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(142)*M(7)-c(141)*M(11)) * den(641)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(140)*M(7)-c(139)*M(11)) * den(641)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(142)*M(7)-c(141)*M(11)) * den(641)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(140)*M(7)-c(139)*M(11)) * den(641)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(142)*M(7)-c(141)*M(11)) * den(641)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(140)*M(7)-c(139)*M(11)) * den(641)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(142)*M(7)-c(141)*M(11)) * den(641)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(140)*M(7)-c(139)*M(11)) * den(641)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(138)*M(1)-c(137)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(136)*M(1)-c(135)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(138)*M(1)-c(137)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(136)*M(1)-c(135)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,12)
  Gcoeff = (-(c(136)*M(1))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(134)*M(1))+c(133)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(136)*M(1))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(134)*M(1))+c(133)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(142)*M(1)-c(141)*M(11)) * den(643)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(140)*M(1)-c(139)*M(11)) * den(643)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(142)*M(1)-c(141)*M(11)) * den(643)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(140)*M(1)-c(139)*M(11)) * den(643)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(142)*M(1)-c(141)*M(11)) * den(643)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(140)*M(1)-c(139)*M(11)) * den(643)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(142)*M(1)-c(141)*M(11)) * den(643)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(140)*M(1)-c(139)*M(11)) * den(643)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,64)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(134)*M(9)-c(133)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(132)*M(9)-c(131)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(134)*M(9)-c(133)*M(11)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(132)*M(9)-c(131)*M(11)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(645)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(645)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(645)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(645)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(645)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(645)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(645)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(645)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(152)*M(4)+c(151)*(-M(2)-M(8)-M(10))+c(150)*M(12)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(148)*M(4)+c(147)*(-M(2)-M(8)-M(10))+c(146)*M(12)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(152)*M(6)+c(151)*(-M(2)-M(8)-M(10))+c(150)*M(12)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(148)*M(6)+c(147)*(-M(2)-M(8)-M(10))+c(146)*M(12)) * den(646)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(152)*M(4)+c(151)*(-M(2)-M(8)-M(10))+c(150)*M(12)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(148)*M(4)+c(147)*(-M(2)-M(8)-M(10))+c(146)*M(12)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(152)*M(6)+c(151)*(-M(2)-M(8)-M(10))+c(150)*M(12)) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(148)*M(6)+c(147)*(-M(2)-M(8)-M(10))+c(146)*M(12)) * den(646)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(50)*(-M(4)+M(6))) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(50)*(M(4)-M(6))) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(50)*(M(4)-M(6))) * den(646)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(102)*M(5)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(4)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,36)
  Gcoeff = (-(c(102)*M(5))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(4)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,37)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(4)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(4)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,38)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(4)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T3sum(1:35,8) = T3sum(1:35,8) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(102)*M(3)+c(101)*(-M(1)-M(7))+c(100)*M(11)) * den(4)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(102)*M(3))+c(101)*(M(1)+M(7))-c(100)*M(11)) * den(4)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(1)+M(7))-c(89)*M(11)) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(4)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(1)+M(7))-c(75)*M(11)) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(69)*M(4))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(85)*M(1))+c(86)*M(5)) * den(270)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(71)*M(1))+c(72)*M(5)) * den(270)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(85)*M(1))+c(86)*M(5)) * den(672)
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,71)
  Gcoeff = (-(c(71)*M(1))+c(72)*M(5)) * den(672)
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(85)*M(1)-c(86)*M(3)) * den(216)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(71)*M(1)-c(72)*M(3)) * den(216)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(85)*M(1)-c(86)*M(3)) * den(673)
  T3sum(1:35,222) = T3sum(1:35,222) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(71)*M(1)-c(72)*M(3)) * den(673)
  T3sum(1:35,222) = T3sum(1:35,222) + Gcoeff * G3tensor(:,84)
  Gcoeff = (-(c(104)*M(9))+c(103)*M(11)) * den(151)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(104)*M(9))+c(103)*M(11)) * den(152)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(125)*M(3)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(155)
  T2sum(1:15,272) = T2sum(1:15,272) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(125)*M(3))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(155)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(93)*M(3))+c(90)*(M(1)+M(9))-c(89)*M(11)) * den(155)
  T2sum(1:15,274) = T2sum(1:15,274) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(155)
  T2sum(1:15,273) = T2sum(1:15,273) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(79)*M(3))+c(76)*(M(1)+M(9))-c(75)*M(11)) * den(155)
  T2sum(1:15,274) = T2sum(1:15,274) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(3)*M(9))+c(2)*M(11)) * den(155)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(7)*M(9)-c(6)*M(11)) * den(152)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(2)-M(10))+c(47)*M(12)) * den(155)
  T2sum(1:15,270) = T2sum(1:15,270) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(274)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(275)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(125)*M(5)+c(122)*(-M(1)-M(9))+c(121)*M(11)) * den(276)
  T2sum(1:15,275) = T2sum(1:15,275) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(125)*M(5))+c(122)*(M(1)+M(9))-c(121)*M(11)) * den(276)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(93)*M(5))+c(90)*(M(1)+M(9))-c(89)*M(11)) * den(276)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(276)
  T2sum(1:15,276) = T2sum(1:15,276) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(79)*M(5))+c(76)*(M(1)+M(9))-c(75)*M(11)) * den(276)
  T2sum(1:15,277) = T2sum(1:15,277) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(276)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(275)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(50)*M(6))+c(48)*(M(2)+M(10))-c(47)*M(12)) * den(276)
  T2sum(1:15,268) = T2sum(1:15,268) + Gcoeff * G2tensor(:,21)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)-M(8)+M(10))) * den(284)
  T3sum(1:35,227) = T3sum(1:35,227) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(676)
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(677)
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(284)
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,95)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(677)
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(48)*M(8)-c(47)*M(12)) * den(284)
  T3sum(1:35,234) = T3sum(1:35,234) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,240) = T3sum(1:35,240) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,241) = T3sum(1:35,241) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,241) = T3sum(1:35,241) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,251) = T3sum(1:35,251) + Gcoeff * G3tensor(:,85)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,252) = T3sum(1:35,252) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,252) = T3sum(1:35,252) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,256) = T3sum(1:35,256) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,257) = T3sum(1:35,257) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(2)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,258) = T3sum(1:35,258) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,257) = T3sum(1:35,257) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(48)*M(2)-c(47)*M(4)-c(49)*M(6)) * den(2)
  T3sum(1:35,258) = T3sum(1:35,258) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,259) = T3sum(1:35,259) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(103)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(2)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(47)*(-M(4)+M(6))+c(48)*(M(8)-M(10))) * den(2)
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(85)*(M(7)-M(9))) * den(2)
  T3sum(1:35,262) = T3sum(1:35,262) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(71)*(M(7)-M(9))) * den(2)
  T3sum(1:35,262) = T3sum(1:35,262) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(85)*(-M(7)+M(9))) * den(2)
  T3sum(1:35,272) = T3sum(1:35,272) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(71)*(-M(7)+M(9))) * den(2)
  T3sum(1:35,272) = T3sum(1:35,272) + Gcoeff * G3tensor(:,92)
  Gcoeff = (c(85)*(-M(7)+M(9))) * den(2)
  T3sum(1:35,278) = T3sum(1:35,278) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(71)*(-M(7)+M(9))) * den(2)
  T3sum(1:35,278) = T3sum(1:35,278) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(45)*(M(4)-M(6))) * den(678)
  T2sum(1:5,390) = T2sum(1:5,390) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(45)*(-M(4)+M(6))) * den(678)
  T2sum(1:5,390) = T2sum(1:5,390) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(46)*(-M(4)+M(6))) * den(678)
  T2sum(1:5,390) = T2sum(1:5,390) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(45)*(-M(4)+M(6))) * den(679)
  T2sum(1:5,391) = T2sum(1:5,391) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(45)*(M(4)-M(6))) * den(679)
  T2sum(1:5,391) = T2sum(1:5,391) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(46)*(M(4)-M(6))) * den(679)
  T2sum(1:5,391) = T2sum(1:5,391) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(45)*(M(2)-M(8))) * den(680)
  T2sum(1:5,393) = T2sum(1:5,393) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(45)*(-M(2)+M(8))) * den(680)
  T2sum(1:5,393) = T2sum(1:5,393) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(46)*(-M(2)+M(8))) * den(680)
  T2sum(1:5,393) = T2sum(1:5,393) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(45)*(-M(2)+M(8))) * den(681)
  T2sum(1:5,394) = T2sum(1:5,394) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(45)*(M(2)-M(8))) * den(681)
  T2sum(1:5,394) = T2sum(1:5,394) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(46)*(M(2)-M(8))) * den(681)
  T2sum(1:5,394) = T2sum(1:5,394) + Gcoeff * G1tensor(:,18)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_pptttt_ew_tttxtxbbx_1_/**/REALKIND
