
module ol_vamp_27_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_27(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(28)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,223) :: G0
  complex(REALKIND), dimension(4,5,4,226) :: G1
  complex(REALKIND), dimension(5,150) :: G1tensor
  complex(REALKIND), dimension(15,100) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,143),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,38),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,64),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),ZERO,G2tensor(:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,77),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,63),ZERO,G2tensor(:,2))
  call loop_QV_A(G1(:,:,:,1),wf(:,101),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),ZERO,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,143),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,38),MT,G1(:,:,:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,64),G1(:,:,:,6))
  call check_last_Q_A(l_switch,G1(:,:,:,6),Q(:,63),MT,G2tensor(:,4))
  call loop_QV_A(G1(:,:,:,5),wf(:,77),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,63),MT,G2tensor(:,5))
  call loop_QV_A(G1(:,:,:,5),wf(:,101),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),MT,G2tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,143),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,38),MB,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,64),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MB,G2tensor(:,7))
  call loop_QV_A(G1(:,:,:,9),wf(:,77),G1(:,:,:,11))
  call check_last_Q_A(l_switch,G1(:,:,:,11),Q(:,63),MB,G2tensor(:,8))
  call loop_QV_A(G1(:,:,:,9),wf(:,101),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MB,G2tensor(:,9))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,143),Q(:,38),G1(:,:,:,13))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,38),wf(:,64),Q(:,25),G2tensor(:,10))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,38),wf(:,77),Q(:,25),G2tensor(:,11))
  call check_last_CV_D(l_switch,G1(:,:,:,13),Q(:,38),wf(:,101),Q(:,25),G2tensor(:,12))
  call loop_SA_Q(G0(:,:,:,1),wf(:,109),G0(:,:,:,5),gH)
  call loop_A_Q(G0(:,:,:,5),Q(:,36),MT,G1(:,:,:,14))
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1345),G1tensor(:,1),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1385),G1tensor(:,2),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1438),G1tensor(:,3),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1477),G1tensor(:,4),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1565),G1tensor(:,5),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,14),wf(:,1573),G1tensor(:,6),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,109),G0(:,:,:,6),gX)
  call loop_A_Q(G0(:,:,:,6),Q(:,36),MT,G1(:,:,:,15))
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1345),G1tensor(:,7),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1385),G1tensor(:,8),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1438),G1tensor(:,9),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1477),G1tensor(:,10),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1565),G1tensor(:,11),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,15),wf(:,1573),G1tensor(:,12),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,109),G0(:,:,:,7),gPtb)
  call loop_A_Q(G0(:,:,:,7),Q(:,36),MB,G1(:,:,:,16))
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1345),G1tensor(:,13),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1385),G1tensor(:,14),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1438),G1tensor(:,15),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1477),G1tensor(:,16),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1565),G1tensor(:,17),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,16),wf(:,1573),G1tensor(:,18),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,109),G0(:,:,:,8),gZu)
  call loop_A_Q(G0(:,:,:,8),Q(:,36),MT,G1(:,:,:,17))
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1345),G1tensor(:,19),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1385),G1tensor(:,20),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1438),G1tensor(:,21),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1477),G1tensor(:,22),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1565),G1tensor(:,23),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,17),wf(:,1573),G1tensor(:,24),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,109),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,36),MB,G1(:,:,:,18))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1345),G1tensor(:,25))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1385),G1tensor(:,26))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1438),G1tensor(:,27))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1477),G1tensor(:,28))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1565),G1tensor(:,29))
  call check_last_AQ_W(l_switch,G1(:,:,:,18),wf(:,1573),G1tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,1723),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,54),ZERO,G1(:,:,:,19))
  call loop_QV_A(G1(:,:,:,19),wf(:,6),G1(:,:,:,20))
  call check_last_Q_A(l_switch,G1(:,:,:,20),Q(:,63),ZERO,G2tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,1723),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,54),MT,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,6),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),MT,G2tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,1723),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,54),MB,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,6),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),MB,G2tensor(:,15))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1723),Q(:,54),G1(:,:,:,25))
  call check_last_CV_D(l_switch,G1(:,:,:,25),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,1726),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,54),ZERO,G1(:,:,:,26))
  call loop_QV_A(G1(:,:,:,26),wf(:,6),G1(:,:,:,27))
  call check_last_Q_A(l_switch,G1(:,:,:,27),Q(:,63),ZERO,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,1726),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,54),MT,G1(:,:,:,28))
  call loop_QV_A(G1(:,:,:,28),wf(:,6),G1(:,:,:,29))
  call check_last_Q_A(l_switch,G1(:,:,:,29),Q(:,63),MT,G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,1726),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,54),MB,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,6),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,63),MB,G2tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1726),Q(:,54),G1(:,:,:,32))
  call check_last_CV_D(l_switch,G1(:,:,:,32),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,20))
  call loop_SA_Q(G0(:,:,:,1),wf(:,597),G0(:,:,:,16),gH)
  call loop_A_Q(G0(:,:,:,16),Q(:,52),MT,G1(:,:,:,33))
  call check_last_AQ_S(l_switch,G1(:,:,:,33),wf(:,137),G1tensor(:,31),gH)
  call check_last_AQ_S(l_switch,G1(:,:,:,33),wf(:,170),G1tensor(:,32),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,597),G0(:,:,:,17),gX)
  call loop_A_Q(G0(:,:,:,17),Q(:,52),MT,G1(:,:,:,34))
  call check_last_AQ_S(l_switch,G1(:,:,:,34),wf(:,137),G1tensor(:,33),gX)
  call check_last_AQ_S(l_switch,G1(:,:,:,34),wf(:,170),G1tensor(:,34),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,597),G0(:,:,:,18),gPtb)
  call loop_A_Q(G0(:,:,:,18),Q(:,52),MB,G1(:,:,:,35))
  call check_last_AQ_S(l_switch,G1(:,:,:,35),wf(:,137),G1tensor(:,35),gPbt)
  call check_last_AQ_S(l_switch,G1(:,:,:,35),wf(:,170),G1tensor(:,36),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,597),G0(:,:,:,19),gZu)
  call loop_A_Q(G0(:,:,:,19),Q(:,52),MT,G1(:,:,:,36))
  call check_last_AQ_Z(l_switch,G1(:,:,:,36),wf(:,137),G1tensor(:,37),gZu)
  call check_last_AQ_Z(l_switch,G1(:,:,:,36),wf(:,170),G1tensor(:,38),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,597),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,52),MB,G1(:,:,:,37))
  call check_last_AQ_W(l_switch,G1(:,:,:,37),wf(:,137),G1tensor(:,39))
  call check_last_AQ_W(l_switch,G1(:,:,:,37),wf(:,170),G1tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,1788),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,54),ZERO,G1(:,:,:,38))
  call loop_QV_A(G1(:,:,:,38),wf(:,6),G1(:,:,:,39))
  call check_last_Q_A(l_switch,G1(:,:,:,39),Q(:,63),ZERO,G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,1788),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,54),MT,G1(:,:,:,40))
  call loop_QV_A(G1(:,:,:,40),wf(:,6),G1(:,:,:,41))
  call check_last_Q_A(l_switch,G1(:,:,:,41),Q(:,63),MT,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,1788),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,54),MB,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,6),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,63),MB,G2tensor(:,23))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1788),Q(:,54),G1(:,:,:,44))
  call check_last_CV_D(l_switch,G1(:,:,:,44),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,1792),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,54),ZERO,G1(:,:,:,45))
  call loop_QV_A(G1(:,:,:,45),wf(:,6),G1(:,:,:,46))
  call check_last_Q_A(l_switch,G1(:,:,:,46),Q(:,63),ZERO,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,1792),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,54),MT,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,6),G1(:,:,:,48))
  call check_last_Q_A(l_switch,G1(:,:,:,48),Q(:,63),MT,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,1792),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,54),MB,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,6),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),MB,G2tensor(:,27))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1792),Q(:,54),G1(:,:,:,51))
  call check_last_CV_D(l_switch,G1(:,:,:,51),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,1096),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,53),ZERO,G1(:,:,:,52))
  call loop_QV_A(G1(:,:,:,52),wf(:,2),G1(:,:,:,53))
  call check_last_Q_A(l_switch,G1(:,:,:,53),Q(:,63),ZERO,G2tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,1096),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,53),MT,G1(:,:,:,54))
  call loop_QV_A(G1(:,:,:,54),wf(:,2),G1(:,:,:,55))
  call check_last_Q_A(l_switch,G1(:,:,:,55),Q(:,63),MT,G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,1096),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,53),MB,G1(:,:,:,56))
  call loop_QV_A(G1(:,:,:,56),wf(:,2),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,63),MB,G2tensor(:,31))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1096),Q(:,53),G1(:,:,:,58))
  call check_last_CV_D(l_switch,G1(:,:,:,58),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,32))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1093),G0(:,:,:,30),gH)
  call loop_A_Q(G0(:,:,:,30),Q(:,46),MT,G1(:,:,:,59))
  call check_last_AQ_S(l_switch,G1(:,:,:,59),wf(:,70),G1tensor(:,41),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1093),G0(:,:,:,31),gX)
  call loop_A_Q(G0(:,:,:,31),Q(:,46),MT,G1(:,:,:,60))
  call check_last_AQ_S(l_switch,G1(:,:,:,60),wf(:,70),G1tensor(:,42),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1093),G0(:,:,:,32),gPtb)
  call loop_A_Q(G0(:,:,:,32),Q(:,46),MB,G1(:,:,:,61))
  call check_last_AQ_S(l_switch,G1(:,:,:,61),wf(:,70),G1tensor(:,43),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1093),G0(:,:,:,33),gZu)
  call loop_A_Q(G0(:,:,:,33),Q(:,46),MT,G1(:,:,:,62))
  call check_last_AQ_Z(l_switch,G1(:,:,:,62),wf(:,70),G1tensor(:,44),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1093),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,46),MB,G1(:,:,:,63))
  call check_last_AQ_W(l_switch,G1(:,:,:,63),wf(:,70),G1tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,1432),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,53),ZERO,G1(:,:,:,64))
  call loop_QV_A(G1(:,:,:,64),wf(:,2),G1(:,:,:,65))
  call check_last_Q_A(l_switch,G1(:,:,:,65),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,1432),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,53),MT,G1(:,:,:,66))
  call loop_QV_A(G1(:,:,:,66),wf(:,2),G1(:,:,:,67))
  call check_last_Q_A(l_switch,G1(:,:,:,67),Q(:,63),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,1432),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,53),MB,G1(:,:,:,68))
  call loop_QV_A(G1(:,:,:,68),wf(:,2),G1(:,:,:,69))
  call check_last_Q_A(l_switch,G1(:,:,:,69),Q(:,63),MB,G2tensor(:,35))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1432),Q(:,53),G1(:,:,:,70))
  call check_last_CV_D(l_switch,G1(:,:,:,70),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,1452),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,53),ZERO,G1(:,:,:,71))
  call loop_QV_A(G1(:,:,:,71),wf(:,2),G1(:,:,:,72))
  call check_last_Q_A(l_switch,G1(:,:,:,72),Q(:,63),ZERO,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,1452),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,53),MT,G1(:,:,:,73))
  call loop_QV_A(G1(:,:,:,73),wf(:,2),G1(:,:,:,74))
  call check_last_Q_A(l_switch,G1(:,:,:,74),Q(:,63),MT,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,1452),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,53),MB,G1(:,:,:,75))
  call loop_QV_A(G1(:,:,:,75),wf(:,2),G1(:,:,:,76))
  call check_last_Q_A(l_switch,G1(:,:,:,76),Q(:,63),MB,G2tensor(:,39))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1452),Q(:,53),G1(:,:,:,77))
  call check_last_CV_D(l_switch,G1(:,:,:,77),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,40))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1401),G0(:,:,:,41),gH)
  call loop_A_Q(G0(:,:,:,41),Q(:,46),MT,G1(:,:,:,78))
  call check_last_AQ_S(l_switch,G1(:,:,:,78),wf(:,70),G1tensor(:,46),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1401),G0(:,:,:,42),gX)
  call loop_A_Q(G0(:,:,:,42),Q(:,46),MT,G1(:,:,:,79))
  call check_last_AQ_S(l_switch,G1(:,:,:,79),wf(:,70),G1tensor(:,47),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1401),G0(:,:,:,43),gPtb)
  call loop_A_Q(G0(:,:,:,43),Q(:,46),MB,G1(:,:,:,80))
  call check_last_AQ_S(l_switch,G1(:,:,:,80),wf(:,70),G1tensor(:,48),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1401),G0(:,:,:,44),gZu)
  call loop_A_Q(G0(:,:,:,44),Q(:,46),MT,G1(:,:,:,81))
  call check_last_AQ_Z(l_switch,G1(:,:,:,81),wf(:,70),G1tensor(:,49),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1401),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,46),MB,G1(:,:,:,82))
  call check_last_AQ_W(l_switch,G1(:,:,:,82),wf(:,70),G1tensor(:,50))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1408),G0(:,:,:,46),gH)
  call loop_A_Q(G0(:,:,:,46),Q(:,46),MT,G1(:,:,:,83))
  call check_last_AQ_S(l_switch,G1(:,:,:,83),wf(:,70),G1tensor(:,51),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1408),G0(:,:,:,47),gX)
  call loop_A_Q(G0(:,:,:,47),Q(:,46),MT,G1(:,:,:,84))
  call check_last_AQ_S(l_switch,G1(:,:,:,84),wf(:,70),G1tensor(:,52),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1408),G0(:,:,:,48),gPtb)
  call loop_A_Q(G0(:,:,:,48),Q(:,46),MB,G1(:,:,:,85))
  call check_last_AQ_S(l_switch,G1(:,:,:,85),wf(:,70),G1tensor(:,53),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1408),G0(:,:,:,49),gZu)
  call loop_A_Q(G0(:,:,:,49),Q(:,46),MT,G1(:,:,:,86))
  call check_last_AQ_Z(l_switch,G1(:,:,:,86),wf(:,70),G1tensor(:,54),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1408),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,46),MB,G1(:,:,:,87))
  call check_last_AQ_W(l_switch,G1(:,:,:,87),wf(:,70),G1tensor(:,55))
  call loop_SQ_A(G0(:,:,:,1),wf(:,1121),G0(:,:,:,51),gH)
  call loop_Q_A(G0(:,:,:,51),Q(:,43),MT,G1(:,:,:,88))
  call check_last_QA_S(l_switch,G1(:,:,:,88),wf(:,126),G1tensor(:,56),gH)
  call loop_SQ_A(G0(:,:,:,1),wf(:,1121),G0(:,:,:,52),gX)
  call loop_Q_A(G0(:,:,:,52),Q(:,43),MT,G1(:,:,:,89))
  call check_last_QA_S(l_switch,G1(:,:,:,89),wf(:,126),G1tensor(:,57),gX)
  call loop_SQ_A(G0(:,:,:,1),wf(:,1121),G0(:,:,:,53),gPbt)
  call loop_Q_A(G0(:,:,:,53),Q(:,43),MB,G1(:,:,:,90))
  call check_last_QA_S(l_switch,G1(:,:,:,90),wf(:,126),G1tensor(:,58),gPtb)
  call loop_ZQ_A(G0(:,:,:,1),wf(:,1121),G0(:,:,:,54),gZu)
  call loop_Q_A(G0(:,:,:,54),Q(:,43),MT,G1(:,:,:,91))
  call check_last_QA_Z(l_switch,G1(:,:,:,91),wf(:,126),G1tensor(:,59),gZu)
  call loop_WQ_A(G0(:,:,:,1),wf(:,1121),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,43),MB,G1(:,:,:,92))
  call check_last_QA_W(l_switch,G1(:,:,:,92),wf(:,126),G1tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,1118),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,53),ZERO,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,2),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,1118),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,53),MT,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,2),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,1118),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,53),MB,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,2),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),MB,G2tensor(:,43))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1118),Q(:,53),G1(:,:,:,99))
  call check_last_CV_D(l_switch,G1(:,:,:,99),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,44))
  call loop_SQ_A(G0(:,:,:,1),wf(:,1374),G0(:,:,:,59),gH)
  call loop_Q_A(G0(:,:,:,59),Q(:,43),MT,G1(:,:,:,100))
  call check_last_QA_S(l_switch,G1(:,:,:,100),wf(:,126),G1tensor(:,61),gH)
  call loop_SQ_A(G0(:,:,:,1),wf(:,1374),G0(:,:,:,60),gX)
  call loop_Q_A(G0(:,:,:,60),Q(:,43),MT,G1(:,:,:,101))
  call check_last_QA_S(l_switch,G1(:,:,:,101),wf(:,126),G1tensor(:,62),gX)
  call loop_SQ_A(G0(:,:,:,1),wf(:,1374),G0(:,:,:,61),gPbt)
  call loop_Q_A(G0(:,:,:,61),Q(:,43),MB,G1(:,:,:,102))
  call check_last_QA_S(l_switch,G1(:,:,:,102),wf(:,126),G1tensor(:,63),gPtb)
  call loop_ZQ_A(G0(:,:,:,1),wf(:,1374),G0(:,:,:,62),gZu)
  call loop_Q_A(G0(:,:,:,62),Q(:,43),MT,G1(:,:,:,103))
  call check_last_QA_Z(l_switch,G1(:,:,:,103),wf(:,126),G1tensor(:,64),gZu)
  call loop_WQ_A(G0(:,:,:,1),wf(:,1374),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,43),MB,G1(:,:,:,104))
  call check_last_QA_W(l_switch,G1(:,:,:,104),wf(:,126),G1tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,1536),G0(:,:,:,64))
  call loop_Q_A(G0(:,:,:,64),Q(:,53),ZERO,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,2),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),ZERO,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,1536),G0(:,:,:,65))
  call loop_Q_A(G0(:,:,:,65),Q(:,53),MT,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,2),G1(:,:,:,108))
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,63),MT,G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,1536),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,53),MB,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,2),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),MB,G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1536),Q(:,53),G1(:,:,:,111))
  call check_last_CV_D(l_switch,G1(:,:,:,111),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,48))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1387),G0(:,:,:,67),gH)
  call loop_SA_Q(G0(:,:,:,67),wf(:,126),G0(:,:,:,68),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,68),Q(:,63),MT,G1tensor(:,66))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1387),G0(:,:,:,69),gX)
  call loop_SA_Q(G0(:,:,:,69),wf(:,126),G0(:,:,:,70),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,70),Q(:,63),MT,G1tensor(:,67))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1387),G0(:,:,:,71),gPbt)
  call loop_SA_Q(G0(:,:,:,71),wf(:,126),G0(:,:,:,72),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,72),Q(:,63),MB,G1tensor(:,68))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1387),G0(:,:,:,73),gZu)
  call loop_ZA_Q(G0(:,:,:,73),wf(:,126),G0(:,:,:,74),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,74),Q(:,63),MT,G1tensor(:,69))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1387),G0(:,:,:,75))
  call loop_WA_Q(G0(:,:,:,75),wf(:,126),G0(:,:,:,76))
  call check_last_A_Q(l_switch,G0(:,:,:,76),Q(:,63),MB,G1tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,1539),G0(:,:,:,77))
  call loop_Q_A(G0(:,:,:,77),Q(:,53),ZERO,G1(:,:,:,112))
  call loop_QV_A(G1(:,:,:,112),wf(:,2),G1(:,:,:,113))
  call check_last_Q_A(l_switch,G1(:,:,:,113),Q(:,63),ZERO,G2tensor(:,49))
  call loop_QV_A(G0(:,:,:,1),wf(:,1539),G0(:,:,:,78))
  call loop_Q_A(G0(:,:,:,78),Q(:,53),MT,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,2),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,63),MT,G2tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,1539),G0(:,:,:,79))
  call loop_Q_A(G0(:,:,:,79),Q(:,53),MB,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,2),G1(:,:,:,117))
  call check_last_Q_A(l_switch,G1(:,:,:,117),Q(:,63),MB,G2tensor(:,51))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1539),Q(:,53),G1(:,:,:,118))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,174),G0(:,:,:,80))
  call loop_Q_A(G0(:,:,:,80),Q(:,37),ZERO,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,15),G1(:,:,:,120))
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),ZERO,G2tensor(:,53))
  call loop_QV_A(G1(:,:,:,119),wf(:,37),G1(:,:,:,121))
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,63),ZERO,G2tensor(:,54))
  call loop_QV_A(G1(:,:,:,119),wf(:,55),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),ZERO,G2tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,174),G0(:,:,:,81))
  call loop_Q_A(G0(:,:,:,81),Q(:,37),MT,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,15),G1(:,:,:,124))
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),MT,G2tensor(:,56))
  call loop_QV_A(G1(:,:,:,123),wf(:,37),G1(:,:,:,125))
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),MT,G2tensor(:,57))
  call loop_QV_A(G1(:,:,:,123),wf(:,55),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),MT,G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,174),G0(:,:,:,82))
  call loop_Q_A(G0(:,:,:,82),Q(:,37),MB,G1(:,:,:,127))
  call loop_QV_A(G1(:,:,:,127),wf(:,15),G1(:,:,:,128))
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,63),MB,G2tensor(:,59))
  call loop_QV_A(G1(:,:,:,127),wf(:,37),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),MB,G2tensor(:,60))
  call loop_QV_A(G1(:,:,:,127),wf(:,55),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MB,G2tensor(:,61))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,174),Q(:,37),G1(:,:,:,131))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,37),wf(:,15),Q(:,26),G2tensor(:,62))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,37),wf(:,37),Q(:,26),G2tensor(:,63))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,37),wf(:,55),Q(:,26),G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,1618),G0(:,:,:,83))
  call loop_Q_A(G0(:,:,:,83),Q(:,53),ZERO,G1(:,:,:,132))
  call loop_QV_A(G1(:,:,:,132),wf(:,2),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),ZERO,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,1618),G0(:,:,:,84))
  call loop_Q_A(G0(:,:,:,84),Q(:,53),MT,G1(:,:,:,134))
  call loop_QV_A(G1(:,:,:,134),wf(:,2),G1(:,:,:,135))
  call check_last_Q_A(l_switch,G1(:,:,:,135),Q(:,63),MT,G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,1618),G0(:,:,:,85))
  call loop_Q_A(G0(:,:,:,85),Q(:,53),MB,G1(:,:,:,136))
  call loop_QV_A(G1(:,:,:,136),wf(:,2),G1(:,:,:,137))
  call check_last_Q_A(l_switch,G1(:,:,:,137),Q(:,63),MB,G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1618),Q(:,53),G1(:,:,:,138))
  call check_last_CV_D(l_switch,G1(:,:,:,138),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,1638),G0(:,:,:,86))
  call loop_Q_A(G0(:,:,:,86),Q(:,53),ZERO,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,2),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,1638),G0(:,:,:,87))
  call loop_Q_A(G0(:,:,:,87),Q(:,53),MT,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,2),G1(:,:,:,142))
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,63),MT,G2tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,1638),G0(:,:,:,88))
  call loop_Q_A(G0(:,:,:,88),Q(:,53),MB,G1(:,:,:,143))
  call loop_QV_A(G1(:,:,:,143),wf(:,2),G1(:,:,:,144))
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,63),MB,G2tensor(:,71))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1638),Q(:,53),G1(:,:,:,145))
  call check_last_CV_D(l_switch,G1(:,:,:,145),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,1710),G0(:,:,:,89))
  call loop_Q_A(G0(:,:,:,89),Q(:,53),ZERO,G1(:,:,:,146))
  call loop_QV_A(G1(:,:,:,146),wf(:,2),G1(:,:,:,147))
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,63),ZERO,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,1710),G0(:,:,:,90))
  call loop_Q_A(G0(:,:,:,90),Q(:,53),MT,G1(:,:,:,148))
  call loop_QV_A(G1(:,:,:,148),wf(:,2),G1(:,:,:,149))
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,63),MT,G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,1710),G0(:,:,:,91))
  call loop_Q_A(G0(:,:,:,91),Q(:,53),MB,G1(:,:,:,150))
  call loop_QV_A(G1(:,:,:,150),wf(:,2),G1(:,:,:,151))
  call check_last_Q_A(l_switch,G1(:,:,:,151),Q(:,63),MB,G2tensor(:,75))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1710),Q(:,53),G1(:,:,:,152))
  call check_last_CV_D(l_switch,G1(:,:,:,152),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,175),G0(:,:,:,92))
  call loop_Q_A(G0(:,:,:,92),Q(:,37),ZERO,G1(:,:,:,153))
  call loop_QV_A(G1(:,:,:,153),wf(:,15),G1(:,:,:,154))
  call check_last_Q_A(l_switch,G1(:,:,:,154),Q(:,63),ZERO,G2tensor(:,77))
  call loop_QV_A(G1(:,:,:,153),wf(:,37),G1(:,:,:,155))
  call check_last_Q_A(l_switch,G1(:,:,:,155),Q(:,63),ZERO,G2tensor(:,78))
  call loop_QV_A(G1(:,:,:,153),wf(:,55),G1(:,:,:,156))
  call check_last_Q_A(l_switch,G1(:,:,:,156),Q(:,63),ZERO,G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,175),G0(:,:,:,93))
  call loop_Q_A(G0(:,:,:,93),Q(:,37),MT,G1(:,:,:,157))
  call loop_QV_A(G1(:,:,:,157),wf(:,15),G1(:,:,:,158))
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,63),MT,G2tensor(:,80))
  call loop_QV_A(G1(:,:,:,157),wf(:,37),G1(:,:,:,159))
  call check_last_Q_A(l_switch,G1(:,:,:,159),Q(:,63),MT,G2tensor(:,81))
  call loop_QV_A(G1(:,:,:,157),wf(:,55),G1(:,:,:,160))
  call check_last_Q_A(l_switch,G1(:,:,:,160),Q(:,63),MT,G2tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,175),G0(:,:,:,94))
  call loop_Q_A(G0(:,:,:,94),Q(:,37),MB,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,15),G1(:,:,:,162))
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,63),MB,G2tensor(:,83))
  call loop_QV_A(G1(:,:,:,161),wf(:,37),G1(:,:,:,163))
  call check_last_Q_A(l_switch,G1(:,:,:,163),Q(:,63),MB,G2tensor(:,84))
  call loop_QV_A(G1(:,:,:,161),wf(:,55),G1(:,:,:,164))
  call check_last_Q_A(l_switch,G1(:,:,:,164),Q(:,63),MB,G2tensor(:,85))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,175),Q(:,37),G1(:,:,:,165))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,37),wf(:,15),Q(:,26),G2tensor(:,86))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,37),wf(:,37),Q(:,26),G2tensor(:,87))
  call check_last_CV_D(l_switch,G1(:,:,:,165),Q(:,37),wf(:,55),Q(:,26),G2tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,1713),G0(:,:,:,95))
  call loop_Q_A(G0(:,:,:,95),Q(:,53),ZERO,G1(:,:,:,166))
  call loop_QV_A(G1(:,:,:,166),wf(:,2),G1(:,:,:,167))
  call check_last_Q_A(l_switch,G1(:,:,:,167),Q(:,63),ZERO,G2tensor(:,89))
  call loop_QV_A(G0(:,:,:,1),wf(:,1713),G0(:,:,:,96))
  call loop_Q_A(G0(:,:,:,96),Q(:,53),MT,G1(:,:,:,168))
  call loop_QV_A(G1(:,:,:,168),wf(:,2),G1(:,:,:,169))
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,63),MT,G2tensor(:,90))
  call loop_QV_A(G0(:,:,:,1),wf(:,1713),G0(:,:,:,97))
  call loop_Q_A(G0(:,:,:,97),Q(:,53),MB,G1(:,:,:,170))
  call loop_QV_A(G1(:,:,:,170),wf(:,2),G1(:,:,:,171))
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,63),MB,G2tensor(:,91))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1713),Q(:,53),G1(:,:,:,172))
  call check_last_CV_D(l_switch,G1(:,:,:,172),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,92))
  call loop_QV_A(G0(:,:,:,1),wf(:,1772),G0(:,:,:,98))
  call loop_Q_A(G0(:,:,:,98),Q(:,53),ZERO,G1(:,:,:,173))
  call loop_QV_A(G1(:,:,:,173),wf(:,2),G1(:,:,:,174))
  call check_last_Q_A(l_switch,G1(:,:,:,174),Q(:,63),ZERO,G2tensor(:,93))
  call loop_QV_A(G0(:,:,:,1),wf(:,1772),G0(:,:,:,99))
  call loop_Q_A(G0(:,:,:,99),Q(:,53),MT,G1(:,:,:,175))
  call loop_QV_A(G1(:,:,:,175),wf(:,2),G1(:,:,:,176))
  call check_last_Q_A(l_switch,G1(:,:,:,176),Q(:,63),MT,G2tensor(:,94))
  call loop_QV_A(G0(:,:,:,1),wf(:,1772),G0(:,:,:,100))
  call loop_Q_A(G0(:,:,:,100),Q(:,53),MB,G1(:,:,:,177))
  call loop_QV_A(G1(:,:,:,177),wf(:,2),G1(:,:,:,178))
  call check_last_Q_A(l_switch,G1(:,:,:,178),Q(:,63),MB,G2tensor(:,95))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1772),Q(:,53),G1(:,:,:,179))
  call check_last_CV_D(l_switch,G1(:,:,:,179),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,96))
  call loop_QV_A(G0(:,:,:,1),wf(:,1776),G0(:,:,:,101))
  call loop_Q_A(G0(:,:,:,101),Q(:,53),ZERO,G1(:,:,:,180))
  call loop_QV_A(G1(:,:,:,180),wf(:,2),G1(:,:,:,181))
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),ZERO,G2tensor(:,97))
  call loop_QV_A(G0(:,:,:,1),wf(:,1776),G0(:,:,:,102))
  call loop_Q_A(G0(:,:,:,102),Q(:,53),MT,G1(:,:,:,182))
  call loop_QV_A(G1(:,:,:,182),wf(:,2),G1(:,:,:,183))
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,63),MT,G2tensor(:,98))
  call loop_QV_A(G0(:,:,:,1),wf(:,1776),G0(:,:,:,103))
  call loop_Q_A(G0(:,:,:,103),Q(:,53),MB,G1(:,:,:,184))
  call loop_QV_A(G1(:,:,:,184),wf(:,2),G1(:,:,:,185))
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),MB,G2tensor(:,99))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,1776),Q(:,53),G1(:,:,:,186))
  call check_last_CV_D(l_switch,G1(:,:,:,186),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,100))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1665),G0(:,:,:,104),gH)
  call loop_A_Q(G0(:,:,:,104),Q(:,46),MT,G1(:,:,:,187))
  call check_last_AQ_S(l_switch,G1(:,:,:,187),wf(:,70),G1tensor(:,71),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1665),G0(:,:,:,105),gX)
  call loop_A_Q(G0(:,:,:,105),Q(:,46),MT,G1(:,:,:,188))
  call check_last_AQ_S(l_switch,G1(:,:,:,188),wf(:,70),G1tensor(:,72),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1665),G0(:,:,:,106),gPtb)
  call loop_A_Q(G0(:,:,:,106),Q(:,46),MB,G1(:,:,:,189))
  call check_last_AQ_S(l_switch,G1(:,:,:,189),wf(:,70),G1tensor(:,73),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1665),G0(:,:,:,107),gZu)
  call loop_A_Q(G0(:,:,:,107),Q(:,46),MT,G1(:,:,:,190))
  call check_last_AQ_Z(l_switch,G1(:,:,:,190),wf(:,70),G1tensor(:,74),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1665),G0(:,:,:,108))
  call loop_A_Q(G0(:,:,:,108),Q(:,46),MB,G1(:,:,:,191))
  call check_last_AQ_W(l_switch,G1(:,:,:,191),wf(:,70),G1tensor(:,75))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1674),G0(:,:,:,109),gH)
  call loop_A_Q(G0(:,:,:,109),Q(:,46),MT,G1(:,:,:,192))
  call check_last_AQ_S(l_switch,G1(:,:,:,192),wf(:,70),G1tensor(:,76),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1674),G0(:,:,:,110),gX)
  call loop_A_Q(G0(:,:,:,110),Q(:,46),MT,G1(:,:,:,193))
  call check_last_AQ_S(l_switch,G1(:,:,:,193),wf(:,70),G1tensor(:,77),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1674),G0(:,:,:,111),gPtb)
  call loop_A_Q(G0(:,:,:,111),Q(:,46),MB,G1(:,:,:,194))
  call check_last_AQ_S(l_switch,G1(:,:,:,194),wf(:,70),G1tensor(:,78),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1674),G0(:,:,:,112),gZu)
  call loop_A_Q(G0(:,:,:,112),Q(:,46),MT,G1(:,:,:,195))
  call check_last_AQ_Z(l_switch,G1(:,:,:,195),wf(:,70),G1tensor(:,79),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1674),G0(:,:,:,113))
  call loop_A_Q(G0(:,:,:,113),Q(:,46),MB,G1(:,:,:,196))
  call check_last_AQ_W(l_switch,G1(:,:,:,196),wf(:,70),G1tensor(:,80))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1720),G0(:,:,:,114),gH)
  call loop_A_Q(G0(:,:,:,114),Q(:,46),MT,G1(:,:,:,197))
  call check_last_AQ_S(l_switch,G1(:,:,:,197),wf(:,70),G1tensor(:,81),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1720),G0(:,:,:,115),gX)
  call loop_A_Q(G0(:,:,:,115),Q(:,46),MT,G1(:,:,:,198))
  call check_last_AQ_S(l_switch,G1(:,:,:,198),wf(:,70),G1tensor(:,82),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1720),G0(:,:,:,116),gPtb)
  call loop_A_Q(G0(:,:,:,116),Q(:,46),MB,G1(:,:,:,199))
  call check_last_AQ_S(l_switch,G1(:,:,:,199),wf(:,70),G1tensor(:,83),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1720),G0(:,:,:,117),gZu)
  call loop_A_Q(G0(:,:,:,117),Q(:,46),MT,G1(:,:,:,200))
  call check_last_AQ_Z(l_switch,G1(:,:,:,200),wf(:,70),G1tensor(:,84),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1720),G0(:,:,:,118))
  call loop_A_Q(G0(:,:,:,118),Q(:,46),MB,G1(:,:,:,201))
  call check_last_AQ_W(l_switch,G1(:,:,:,201),wf(:,70),G1tensor(:,85))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1762),G0(:,:,:,119),gH)
  call loop_A_Q(G0(:,:,:,119),Q(:,46),MT,G1(:,:,:,202))
  call check_last_AQ_S(l_switch,G1(:,:,:,202),wf(:,70),G1tensor(:,86),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1762),G0(:,:,:,120),gX)
  call loop_A_Q(G0(:,:,:,120),Q(:,46),MT,G1(:,:,:,203))
  call check_last_AQ_S(l_switch,G1(:,:,:,203),wf(:,70),G1tensor(:,87),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1762),G0(:,:,:,121),gPtb)
  call loop_A_Q(G0(:,:,:,121),Q(:,46),MB,G1(:,:,:,204))
  call check_last_AQ_S(l_switch,G1(:,:,:,204),wf(:,70),G1tensor(:,88),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1762),G0(:,:,:,122),gZu)
  call loop_A_Q(G0(:,:,:,122),Q(:,46),MT,G1(:,:,:,205))
  call check_last_AQ_Z(l_switch,G1(:,:,:,205),wf(:,70),G1tensor(:,89),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1762),G0(:,:,:,123))
  call loop_A_Q(G0(:,:,:,123),Q(:,46),MB,G1(:,:,:,206))
  call check_last_AQ_W(l_switch,G1(:,:,:,206),wf(:,70),G1tensor(:,90))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1615),G0(:,:,:,124),gH)
  call loop_A_Q(G0(:,:,:,124),Q(:,45),MT,G1(:,:,:,207))
  call check_last_AQ_S(l_switch,G1(:,:,:,207),wf(:,20),G1tensor(:,91),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1615),G0(:,:,:,125),gX)
  call loop_A_Q(G0(:,:,:,125),Q(:,45),MT,G1(:,:,:,208))
  call check_last_AQ_S(l_switch,G1(:,:,:,208),wf(:,20),G1tensor(:,92),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1615),G0(:,:,:,126),gPtb)
  call loop_A_Q(G0(:,:,:,126),Q(:,45),MB,G1(:,:,:,209))
  call check_last_AQ_S(l_switch,G1(:,:,:,209),wf(:,20),G1tensor(:,93),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1615),G0(:,:,:,127),gZu)
  call loop_A_Q(G0(:,:,:,127),Q(:,45),MT,G1(:,:,:,210))
  call check_last_AQ_Z(l_switch,G1(:,:,:,210),wf(:,20),G1tensor(:,94),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1615),G0(:,:,:,128))
  call loop_A_Q(G0(:,:,:,128),Q(:,45),MB,G1(:,:,:,211))
  call check_last_AQ_W(l_switch,G1(:,:,:,211),wf(:,20),G1tensor(:,95))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1632),G0(:,:,:,129),gH)
  call loop_A_Q(G0(:,:,:,129),Q(:,45),MT,G1(:,:,:,212))
  call check_last_AQ_S(l_switch,G1(:,:,:,212),wf(:,20),G1tensor(:,96),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1632),G0(:,:,:,130),gX)
  call loop_A_Q(G0(:,:,:,130),Q(:,45),MT,G1(:,:,:,213))
  call check_last_AQ_S(l_switch,G1(:,:,:,213),wf(:,20),G1tensor(:,97),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1632),G0(:,:,:,131),gPtb)
  call loop_A_Q(G0(:,:,:,131),Q(:,45),MB,G1(:,:,:,214))
  call check_last_AQ_S(l_switch,G1(:,:,:,214),wf(:,20),G1tensor(:,98),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1632),G0(:,:,:,132),gZu)
  call loop_A_Q(G0(:,:,:,132),Q(:,45),MT,G1(:,:,:,215))
  call check_last_AQ_Z(l_switch,G1(:,:,:,215),wf(:,20),G1tensor(:,99),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1632),G0(:,:,:,133))
  call loop_A_Q(G0(:,:,:,133),Q(:,45),MB,G1(:,:,:,216))
  call check_last_AQ_W(l_switch,G1(:,:,:,216),wf(:,20),G1tensor(:,100))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1707),G0(:,:,:,134),gH)
  call loop_A_Q(G0(:,:,:,134),Q(:,45),MT,G1(:,:,:,217))
  call check_last_AQ_S(l_switch,G1(:,:,:,217),wf(:,20),G1tensor(:,101),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1707),G0(:,:,:,135),gX)
  call loop_A_Q(G0(:,:,:,135),Q(:,45),MT,G1(:,:,:,218))
  call check_last_AQ_S(l_switch,G1(:,:,:,218),wf(:,20),G1tensor(:,102),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1707),G0(:,:,:,136),gPtb)
  call loop_A_Q(G0(:,:,:,136),Q(:,45),MB,G1(:,:,:,219))
  call check_last_AQ_S(l_switch,G1(:,:,:,219),wf(:,20),G1tensor(:,103),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1707),G0(:,:,:,137),gZu)
  call loop_A_Q(G0(:,:,:,137),Q(:,45),MT,G1(:,:,:,220))
  call check_last_AQ_Z(l_switch,G1(:,:,:,220),wf(:,20),G1tensor(:,104),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1707),G0(:,:,:,138))
  call loop_A_Q(G0(:,:,:,138),Q(:,45),MB,G1(:,:,:,221))
  call check_last_AQ_W(l_switch,G1(:,:,:,221),wf(:,20),G1tensor(:,105))
  call loop_SA_Q(G0(:,:,:,1),wf(:,1749),G0(:,:,:,139),gH)
  call loop_A_Q(G0(:,:,:,139),Q(:,45),MT,G1(:,:,:,222))
  call check_last_AQ_S(l_switch,G1(:,:,:,222),wf(:,20),G1tensor(:,106),gH)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1749),G0(:,:,:,140),gX)
  call loop_A_Q(G0(:,:,:,140),Q(:,45),MT,G1(:,:,:,223))
  call check_last_AQ_S(l_switch,G1(:,:,:,223),wf(:,20),G1tensor(:,107),gX)
  call loop_SA_Q(G0(:,:,:,1),wf(:,1749),G0(:,:,:,141),gPtb)
  call loop_A_Q(G0(:,:,:,141),Q(:,45),MB,G1(:,:,:,224))
  call check_last_AQ_S(l_switch,G1(:,:,:,224),wf(:,20),G1tensor(:,108),gPbt)
  call loop_ZA_Q(G0(:,:,:,1),wf(:,1749),G0(:,:,:,142),gZu)
  call loop_A_Q(G0(:,:,:,142),Q(:,45),MT,G1(:,:,:,225))
  call check_last_AQ_Z(l_switch,G1(:,:,:,225),wf(:,20),G1tensor(:,109),gZu)
  call loop_WA_Q(G0(:,:,:,1),wf(:,1749),G0(:,:,:,143))
  call loop_A_Q(G0(:,:,:,143),Q(:,45),MB,G1(:,:,:,226))
  call check_last_AQ_W(l_switch,G1(:,:,:,226),wf(:,20),G1tensor(:,110))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1624),G0(:,:,:,144),gH)
  call loop_SA_Q(G0(:,:,:,144),wf(:,126),G0(:,:,:,145),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,145),Q(:,63),MT,G1tensor(:,111))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1624),G0(:,:,:,146),gX)
  call loop_SA_Q(G0(:,:,:,146),wf(:,126),G0(:,:,:,147),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,147),Q(:,63),MT,G1tensor(:,112))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1624),G0(:,:,:,148),gPbt)
  call loop_SA_Q(G0(:,:,:,148),wf(:,126),G0(:,:,:,149),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,149),Q(:,63),MB,G1tensor(:,113))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1624),G0(:,:,:,150),gZu)
  call loop_ZA_Q(G0(:,:,:,150),wf(:,126),G0(:,:,:,151),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,151),Q(:,63),MT,G1tensor(:,114))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1624),G0(:,:,:,152))
  call loop_WA_Q(G0(:,:,:,152),wf(:,126),G0(:,:,:,153))
  call check_last_A_Q(l_switch,G0(:,:,:,153),Q(:,63),MB,G1tensor(:,115))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1657),G0(:,:,:,154),gH)
  call loop_SA_Q(G0(:,:,:,154),wf(:,126),G0(:,:,:,155),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,155),Q(:,63),MT,G1tensor(:,116))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1657),G0(:,:,:,156),gX)
  call loop_SA_Q(G0(:,:,:,156),wf(:,126),G0(:,:,:,157),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,157),Q(:,63),MT,G1tensor(:,117))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1657),G0(:,:,:,158),gPbt)
  call loop_SA_Q(G0(:,:,:,158),wf(:,126),G0(:,:,:,159),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,159),Q(:,63),MB,G1tensor(:,118))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1657),G0(:,:,:,160),gZu)
  call loop_ZA_Q(G0(:,:,:,160),wf(:,126),G0(:,:,:,161),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,161),Q(:,63),MT,G1tensor(:,119))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1657),G0(:,:,:,162))
  call loop_WA_Q(G0(:,:,:,162),wf(:,126),G0(:,:,:,163))
  call check_last_A_Q(l_switch,G0(:,:,:,163),Q(:,63),MB,G1tensor(:,120))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1733),G0(:,:,:,164),gH)
  call loop_SA_Q(G0(:,:,:,164),wf(:,126),G0(:,:,:,165),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,165),Q(:,63),MT,G1tensor(:,121))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1733),G0(:,:,:,166),gX)
  call loop_SA_Q(G0(:,:,:,166),wf(:,126),G0(:,:,:,167),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,167),Q(:,63),MT,G1tensor(:,122))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1733),G0(:,:,:,168),gPbt)
  call loop_SA_Q(G0(:,:,:,168),wf(:,126),G0(:,:,:,169),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,169),Q(:,63),MB,G1tensor(:,123))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1733),G0(:,:,:,170),gZu)
  call loop_ZA_Q(G0(:,:,:,170),wf(:,126),G0(:,:,:,171),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,171),Q(:,63),MT,G1tensor(:,124))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1733),G0(:,:,:,172))
  call loop_WA_Q(G0(:,:,:,172),wf(:,126),G0(:,:,:,173))
  call check_last_A_Q(l_switch,G0(:,:,:,173),Q(:,63),MB,G1tensor(:,125))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1741),G0(:,:,:,174),gH)
  call loop_SA_Q(G0(:,:,:,174),wf(:,126),G0(:,:,:,175),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,175),Q(:,63),MT,G1tensor(:,126))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1741),G0(:,:,:,176),gX)
  call loop_SA_Q(G0(:,:,:,176),wf(:,126),G0(:,:,:,177),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,177),Q(:,63),MT,G1tensor(:,127))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1741),G0(:,:,:,178),gPbt)
  call loop_SA_Q(G0(:,:,:,178),wf(:,126),G0(:,:,:,179),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,179),Q(:,63),MB,G1tensor(:,128))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1741),G0(:,:,:,180),gZu)
  call loop_ZA_Q(G0(:,:,:,180),wf(:,126),G0(:,:,:,181),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,181),Q(:,63),MT,G1tensor(:,129))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1741),G0(:,:,:,182))
  call loop_WA_Q(G0(:,:,:,182),wf(:,126),G0(:,:,:,183))
  call check_last_A_Q(l_switch,G0(:,:,:,183),Q(:,63),MB,G1tensor(:,130))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1607),G0(:,:,:,184),gH)
  call loop_SA_Q(G0(:,:,:,184),wf(:,41),G0(:,:,:,185),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,185),Q(:,63),MT,G1tensor(:,131))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1607),G0(:,:,:,186),gX)
  call loop_SA_Q(G0(:,:,:,186),wf(:,41),G0(:,:,:,187),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,187),Q(:,63),MT,G1tensor(:,132))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1607),G0(:,:,:,188),gPbt)
  call loop_SA_Q(G0(:,:,:,188),wf(:,41),G0(:,:,:,189),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,189),Q(:,63),MB,G1tensor(:,133))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1607),G0(:,:,:,190),gZu)
  call loop_ZA_Q(G0(:,:,:,190),wf(:,41),G0(:,:,:,191),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,191),Q(:,63),MT,G1tensor(:,134))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1607),G0(:,:,:,192))
  call loop_WA_Q(G0(:,:,:,192),wf(:,41),G0(:,:,:,193))
  call check_last_A_Q(l_switch,G0(:,:,:,193),Q(:,63),MB,G1tensor(:,135))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1649),G0(:,:,:,194),gH)
  call loop_SA_Q(G0(:,:,:,194),wf(:,41),G0(:,:,:,195),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,195),Q(:,63),MT,G1tensor(:,136))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1649),G0(:,:,:,196),gX)
  call loop_SA_Q(G0(:,:,:,196),wf(:,41),G0(:,:,:,197),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,197),Q(:,63),MT,G1tensor(:,137))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1649),G0(:,:,:,198),gPbt)
  call loop_SA_Q(G0(:,:,:,198),wf(:,41),G0(:,:,:,199),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,199),Q(:,63),MB,G1tensor(:,138))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1649),G0(:,:,:,200),gZu)
  call loop_ZA_Q(G0(:,:,:,200),wf(:,41),G0(:,:,:,201),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,201),Q(:,63),MT,G1tensor(:,139))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1649),G0(:,:,:,202))
  call loop_WA_Q(G0(:,:,:,202),wf(:,41),G0(:,:,:,203))
  call check_last_A_Q(l_switch,G0(:,:,:,203),Q(:,63),MB,G1tensor(:,140))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1691),G0(:,:,:,204),gH)
  call loop_SA_Q(G0(:,:,:,204),wf(:,41),G0(:,:,:,205),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,205),Q(:,63),MT,G1tensor(:,141))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1691),G0(:,:,:,206),gX)
  call loop_SA_Q(G0(:,:,:,206),wf(:,41),G0(:,:,:,207),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,207),Q(:,63),MT,G1tensor(:,142))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1691),G0(:,:,:,208),gPbt)
  call loop_SA_Q(G0(:,:,:,208),wf(:,41),G0(:,:,:,209),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,209),Q(:,63),MB,G1tensor(:,143))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1691),G0(:,:,:,210),gZu)
  call loop_ZA_Q(G0(:,:,:,210),wf(:,41),G0(:,:,:,211),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,211),Q(:,63),MT,G1tensor(:,144))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1691),G0(:,:,:,212))
  call loop_WA_Q(G0(:,:,:,212),wf(:,41),G0(:,:,:,213))
  call check_last_A_Q(l_switch,G0(:,:,:,213),Q(:,63),MB,G1tensor(:,145))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1699),G0(:,:,:,214),gH)
  call loop_SA_Q(G0(:,:,:,214),wf(:,41),G0(:,:,:,215),gH)
  call check_last_A_Q(l_switch,G0(:,:,:,215),Q(:,63),MT,G1tensor(:,146))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1699),G0(:,:,:,216),gX)
  call loop_SA_Q(G0(:,:,:,216),wf(:,41),G0(:,:,:,217),gX)
  call check_last_A_Q(l_switch,G0(:,:,:,217),Q(:,63),MT,G1tensor(:,147))
  call loop_AQ_S(G0(:,:,:,1),wf(:,1699),G0(:,:,:,218),gPbt)
  call loop_SA_Q(G0(:,:,:,218),wf(:,41),G0(:,:,:,219),gPtb)
  call check_last_A_Q(l_switch,G0(:,:,:,219),Q(:,63),MB,G1tensor(:,148))
  call loop_AQ_Z(G0(:,:,:,1),wf(:,1699),G0(:,:,:,220),gZu)
  call loop_ZA_Q(G0(:,:,:,220),wf(:,41),G0(:,:,:,221),gZu)
  call check_last_A_Q(l_switch,G0(:,:,:,221),Q(:,63),MT,G1tensor(:,149))
  call loop_AQ_W(G0(:,:,:,1),wf(:,1699),G0(:,:,:,222))
  call loop_WA_Q(G0(:,:,:,222),wf(:,41),G0(:,:,:,223))
  call check_last_A_Q(l_switch,G0(:,:,:,223),Q(:,63),MB,G1tensor(:,150))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(90)*(M(2)-M(18))) * den(910)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(88)*(M(2)-M(18))) * den(910)
  T2sum(1:15,624) = T2sum(1:15,624) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(90)*(M(2)-M(18))) * den(910)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(88)*(M(2)-M(18))) * den(910)
  T2sum(1:15,625) = T2sum(1:15,625) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(37)*(M(2)-M(18))) * den(910)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(64)*(M(1)-M(17))) * den(1595)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(64)*(-M(1)+M(17))) * den(1595)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(58)*(-M(1)+M(17))) * den(1595)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(11)*(-M(1)+M(17))) * den(1595)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(54)*(-M(1)+M(17))) * den(1595)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(90)*(M(2)-M(18))) * den(1596)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(88)*(M(2)-M(18))) * den(1596)
  T2sum(1:15,614) = T2sum(1:15,614) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(90)*(M(2)-M(18))) * den(1596)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(88)*(M(2)-M(18))) * den(1596)
  T2sum(1:15,615) = T2sum(1:15,615) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(37)*(M(2)-M(18))) * den(1596)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(96)*M(18))+c(95)*M(20)) * den(1597)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(93)*M(18))+c(92)*M(20)) * den(1597)
  T2sum(1:15,614) = T2sum(1:15,614) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(96)*M(18))+c(95)*M(20)) * den(1597)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,17)
  Gcoeff = (-(c(93)*M(18))+c(92)*M(20)) * den(1597)
  T2sum(1:15,615) = T2sum(1:15,615) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(52)*M(18))+c(48)*M(20)) * den(1597)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(64)*(M(9)-M(17))+c(63)*(-M(11)+M(19))) * den(918)
  T1sum(1:5,60) = T1sum(1:5,60) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(64)*(-M(9)+M(17))+c(63)*(M(11)-M(19))) * den(918)
  T1sum(1:5,61) = T1sum(1:5,61) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(58)*(-M(9)+M(17))+c(57)*(M(11)-M(19))) * den(918)
  T1sum(1:5,62) = T1sum(1:5,62) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(11)*(-M(9)+M(17))+c(10)*(M(11)-M(19))) * den(918)
  T1sum(1:5,61) = T1sum(1:5,61) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(54)*(-M(9)+M(17))+c(53)*(M(11)-M(19))) * den(918)
  T1sum(1:5,62) = T1sum(1:5,62) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(89)*(-M(12)+M(20))+c(90)*(M(16)-M(24))) * den(1604)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(87)*(-M(12)+M(20))+c(88)*(M(16)-M(24))) * den(1604)
  T2sum(1:15,614) = T2sum(1:15,614) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(89)*(-M(12)+M(20))+c(90)*(M(16)-M(24))) * den(1604)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(87)*(-M(12)+M(20))+c(88)*(M(16)-M(24))) * den(1604)
  T2sum(1:15,615) = T2sum(1:15,615) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(33)*(-M(12)+M(20))+c(37)*(M(16)-M(24))) * den(1604)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(90)*(M(10)-M(18))+c(89)*(-M(12)+M(20))) * den(1605)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(88)*(M(10)-M(18))+c(87)*(-M(12)+M(20))) * den(1605)
  T2sum(1:15,614) = T2sum(1:15,614) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(90)*(M(10)-M(18))+c(89)*(-M(12)+M(20))) * den(1605)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(88)*(M(10)-M(18))+c(87)*(-M(12)+M(20))) * den(1605)
  T2sum(1:15,615) = T2sum(1:15,615) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(37)*(M(10)-M(18))+c(33)*(-M(12)+M(20))) * den(1605)
  T2sum(1:15,612) = T2sum(1:15,612) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(96)*M(4)-c(95)*M(18)) * den(939)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(93)*M(4)-c(92)*M(18)) * den(939)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(96)*M(4)-c(95)*M(18)) * den(939)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(93)*M(4)-c(92)*M(18)) * den(939)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(52)*M(4)-c(48)*M(18)) * den(939)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(69)*M(3)-c(68)*M(17)) * den(936)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,41)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(17)) * den(936)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,42)
  Gcoeff = (-(c(60)*M(3))+c(59)*M(17)) * den(936)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,43)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(17)) * den(936)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(56)*M(3))+c(55)*M(17)) * den(936)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(90)*(-M(4)+M(22))) * den(1606)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(88)*(-M(4)+M(22))) * den(1606)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(90)*(-M(4)+M(22))) * den(1606)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(88)*(-M(4)+M(22))) * den(1606)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(37)*(-M(4)+M(22))) * den(1606)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(95)*M(18))+c(96)*M(22)) * den(1607)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(92)*M(18))+c(93)*M(22)) * den(1607)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(95)*M(18))+c(96)*M(22)) * den(1607)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(92)*M(18))+c(93)*M(22)) * den(1607)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,39)
  Gcoeff = (-(c(48)*M(18))+c(52)*M(22)) * den(1607)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,40)
  Gcoeff = (-(c(68)*M(17))+c(69)*M(21)) * den(1610)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(68)*M(17)-c(69)*M(21)) * den(1610)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(59)*M(17)-c(60)*M(21)) * den(1610)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(19)*M(17)-c(20)*M(21)) * den(1610)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(55)*M(17)-c(56)*M(21)) * den(1610)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(64)*(M(3)-M(21))) * den(1611)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(64)*(-M(3)+M(21))) * den(1611)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(58)*(-M(3)+M(21))) * den(1611)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(11)*(-M(3)+M(21))) * den(1611)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(54)*(-M(3)+M(21))) * den(1611)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(69)*M(5)-c(68)*M(9)) * den(973)
  T1sum(1:5,56) = T1sum(1:5,56) + Gcoeff * G1tensor(:,56)
  Gcoeff = (-(c(69)*M(5))+c(68)*M(9)) * den(973)
  T1sum(1:5,57) = T1sum(1:5,57) + Gcoeff * G1tensor(:,57)
  Gcoeff = (-(c(60)*M(5))+c(59)*M(9)) * den(973)
  T1sum(1:5,58) = T1sum(1:5,58) + Gcoeff * G1tensor(:,58)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(9)) * den(973)
  T1sum(1:5,57) = T1sum(1:5,57) + Gcoeff * G1tensor(:,59)
  Gcoeff = (-(c(56)*M(5))+c(55)*M(9)) * den(973)
  T1sum(1:5,58) = T1sum(1:5,58) + Gcoeff * G1tensor(:,60)
  Gcoeff = (c(96)*M(6)-c(95)*M(10)) * den(967)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(93)*M(6)-c(92)*M(10)) * den(967)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(96)*M(6)-c(95)*M(10)) * den(967)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(93)*M(6)-c(92)*M(10)) * den(967)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(52)*M(6)-c(48)*M(10)) * den(967)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(68)*M(9))+c(69)*M(11)) * den(1614)
  T1sum(1:5,56) = T1sum(1:5,56) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(68)*M(9)-c(69)*M(11)) * den(1614)
  T1sum(1:5,57) = T1sum(1:5,57) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(59)*M(9)-c(60)*M(11)) * den(1614)
  T1sum(1:5,58) = T1sum(1:5,58) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(19)*M(9)-c(20)*M(11)) * den(1614)
  T1sum(1:5,57) = T1sum(1:5,57) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(55)*M(9)-c(56)*M(11)) * den(1614)
  T1sum(1:5,58) = T1sum(1:5,58) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(90)*(M(6)-M(12))) * den(1615)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(88)*(M(6)-M(12))) * den(1615)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(90)*(M(6)-M(12))) * den(1615)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(88)*(M(6)-M(12))) * den(1615)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(37)*(M(6)-M(12))) * den(1615)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(64)*(-M(5)+M(11))) * den(1616)
  T1sum(1:5,63) = T1sum(1:5,63) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(64)*(M(5)-M(11))) * den(1616)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(58)*(M(5)-M(11))) * den(1616)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(11)*(M(5)-M(11))) * den(1616)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(54)*(M(5)-M(11))) * den(1616)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,70)
  Gcoeff = (-(c(95)*M(10))+c(96)*M(12)) * den(1617)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(92)*M(10))+c(93)*M(12)) * den(1617)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(95)*M(10))+c(96)*M(12)) * den(1617)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(92)*M(10))+c(93)*M(12)) * den(1617)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(48)*M(10))+c(52)*M(12)) * den(1617)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(90)*(M(6)-M(14))) * den(990)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(88)*(M(6)-M(14))) * den(990)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(90)*(M(6)-M(14))) * den(990)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(88)*(M(6)-M(14))) * den(990)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(37)*(M(6)-M(14))) * den(990)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(90)*(M(6)-M(14))) * den(1618)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(88)*(M(6)-M(14))) * den(1618)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(90)*(M(6)-M(14))) * den(1618)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(88)*(M(6)-M(14))) * den(1618)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(37)*(M(6)-M(14))) * den(1618)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(95)*M(10))+c(96)*M(14)) * den(1619)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(92)*M(10))+c(93)*M(14)) * den(1619)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(95)*M(10))+c(96)*M(14)) * den(1619)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(92)*M(10))+c(93)*M(14)) * den(1619)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(48)*M(10))+c(52)*M(14)) * den(1619)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(90)*(-M(4)+M(20))) * den(1627)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(88)*(-M(4)+M(20))) * den(1627)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(90)*(-M(4)+M(20))) * den(1627)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(88)*(-M(4)+M(20))) * den(1627)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(37)*(-M(4)+M(20))) * den(1627)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(90)*(-M(4)+M(20))) * den(999)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(88)*(-M(4)+M(20))) * den(999)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(90)*(-M(4)+M(20))) * den(999)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(88)*(-M(4)+M(20))) * den(999)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(37)*(-M(4)+M(20))) * den(999)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(64)*(-M(3)+M(19))) * den(1628)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(64)*(M(3)-M(19))) * den(1628)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(58)*(M(3)-M(19))) * den(1628)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(11)*(M(3)-M(19))) * den(1628)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(54)*(M(3)-M(19))) * den(1628)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,26)
  Gcoeff = (-(c(95)*M(18))+c(96)*M(20)) * den(1629)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(92)*M(18))+c(93)*M(20)) * den(1629)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(95)*M(18))+c(96)*M(20)) * den(1629)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(92)*M(18))+c(93)*M(20)) * den(1629)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(48)*M(18))+c(52)*M(20)) * den(1629)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(63)*(M(9)-M(17))+c(64)*(-M(11)+M(19))) * den(1007)
  T1sum(1:5,60) = T1sum(1:5,60) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(63)*(-M(9)+M(17))+c(64)*(M(11)-M(19))) * den(1007)
  T1sum(1:5,61) = T1sum(1:5,61) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(57)*(-M(9)+M(17))+c(58)*(M(11)-M(19))) * den(1007)
  T1sum(1:5,62) = T1sum(1:5,62) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(10)*(-M(9)+M(17))+c(11)*(M(11)-M(19))) * den(1007)
  T1sum(1:5,61) = T1sum(1:5,61) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(53)*(-M(9)+M(17))+c(54)*(M(11)-M(19))) * den(1007)
  T1sum(1:5,62) = T1sum(1:5,62) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(14)+M(22))) * den(1633)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(14)+M(22))) * den(1633)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(14)+M(22))) * den(1633)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(14)+M(22))) * den(1633)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(33)*(M(10)-M(18))+c(37)*(-M(14)+M(22))) * den(1633)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(12)+M(20))) * den(1637)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(12)+M(20))) * den(1637)
  T2sum(1:15,610) = T2sum(1:15,610) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(12)+M(20))) * den(1637)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(12)+M(20))) * den(1637)
  T2sum(1:15,611) = T2sum(1:15,611) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(33)*(M(10)-M(18))+c(37)*(-M(12)+M(20))) * den(1637)
  T2sum(1:15,607) = T2sum(1:15,607) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(68)*M(3)-c(69)*M(7)) * den(1646)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,71)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(7)) * den(1646)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,72)
  Gcoeff = (-(c(59)*M(3))+c(60)*M(7)) * den(1646)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,73)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(7)) * den(1646)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,74)
  Gcoeff = (-(c(55)*M(3))+c(56)*M(7)) * den(1646)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(69)*M(3)-c(68)*M(7)) * den(1649)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,76)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(7)) * den(1649)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,77)
  Gcoeff = (-(c(60)*M(3))+c(59)*M(7)) * den(1649)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,78)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(7)) * den(1649)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,79)
  Gcoeff = (-(c(56)*M(3))+c(55)*M(7)) * den(1649)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,80)
  Gcoeff = (c(95)*M(4)-c(96)*M(18)) * den(1038)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(92)*M(4)-c(93)*M(18)) * den(1038)
  T2sum(1:15,624) = T2sum(1:15,624) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(95)*M(4)-c(96)*M(18)) * den(1038)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(92)*M(4)-c(93)*M(18)) * den(1038)
  T2sum(1:15,625) = T2sum(1:15,625) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(48)*M(4)-c(52)*M(18)) * den(1038)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(68)*M(3)-c(69)*M(17)) * den(1652)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(17)) * den(1652)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,9)
  Gcoeff = (-(c(59)*M(3))+c(60)*M(17)) * den(1652)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,15)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(17)) * den(1652)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,21)
  Gcoeff = (-(c(55)*M(3))+c(56)*M(17)) * den(1652)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(68)*M(3)-c(69)*M(17)) * den(1655)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,81)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(17)) * den(1655)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,82)
  Gcoeff = (-(c(59)*M(3))+c(60)*M(17)) * den(1655)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,83)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(17)) * den(1655)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,84)
  Gcoeff = (-(c(55)*M(3))+c(56)*M(17)) * den(1655)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,85)
  Gcoeff = (-(c(68)*M(7))+c(69)*M(21)) * den(1661)
  T1sum(1:5,37) = T1sum(1:5,37) + Gcoeff * G1tensor(:,86)
  Gcoeff = (c(68)*M(7)-c(69)*M(21)) * den(1661)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,87)
  Gcoeff = (c(59)*M(7)-c(60)*M(21)) * den(1661)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,88)
  Gcoeff = (c(19)*M(7)-c(20)*M(21)) * den(1661)
  T1sum(1:5,38) = T1sum(1:5,38) + Gcoeff * G1tensor(:,89)
  Gcoeff = (c(55)*M(7)-c(56)*M(21)) * den(1661)
  T1sum(1:5,39) = T1sum(1:5,39) + Gcoeff * G1tensor(:,90)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(6)) * den(1058)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(6)) * den(1058)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(6)) * den(1058)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(6)) * den(1058)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(48)*M(2))+c(52)*M(6)) * den(1058)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(5)) * den(1664)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,91)
  Gcoeff = (c(68)*M(1)-c(69)*M(5)) * den(1664)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,92)
  Gcoeff = (c(59)*M(1)-c(60)*M(5)) * den(1664)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,93)
  Gcoeff = (c(19)*M(1)-c(20)*M(5)) * den(1664)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,94)
  Gcoeff = (c(55)*M(1)-c(56)*M(5)) * den(1664)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,95)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(5)) * den(1667)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,96)
  Gcoeff = (c(69)*M(1)-c(68)*M(5)) * den(1667)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,97)
  Gcoeff = (c(60)*M(1)-c(59)*M(5)) * den(1667)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,98)
  Gcoeff = (c(20)*M(1)-c(19)*M(5)) * den(1667)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,99)
  Gcoeff = (c(56)*M(1)-c(55)*M(5)) * den(1667)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,100)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(19)) * den(1676)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,101)
  Gcoeff = (c(68)*M(1)-c(69)*M(19)) * den(1676)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,102)
  Gcoeff = (c(59)*M(1)-c(60)*M(19)) * den(1676)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,103)
  Gcoeff = (c(19)*M(1)-c(20)*M(19)) * den(1676)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,104)
  Gcoeff = (c(55)*M(1)-c(56)*M(19)) * den(1676)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,105)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(20)) * den(1063)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(20)) * den(1063)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(20)) * den(1063)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(20)) * den(1063)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(48)*M(2))+c(52)*M(20)) * den(1063)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(19)) * den(1679)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(68)*M(1)-c(69)*M(19)) * den(1679)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(59)*M(1)-c(60)*M(19)) * den(1679)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(19)*M(1)-c(20)*M(19)) * den(1679)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(55)*M(1)-c(56)*M(19)) * den(1679)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(68)*M(5)-c(69)*M(23)) * den(1682)
  T1sum(1:5,8) = T1sum(1:5,8) + Gcoeff * G1tensor(:,106)
  Gcoeff = (-(c(68)*M(5))+c(69)*M(23)) * den(1682)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,107)
  Gcoeff = (-(c(59)*M(5))+c(60)*M(23)) * den(1682)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,108)
  Gcoeff = (-(c(19)*M(5))+c(20)*M(23)) * den(1682)
  T1sum(1:5,9) = T1sum(1:5,9) + Gcoeff * G1tensor(:,109)
  Gcoeff = (-(c(55)*M(5))+c(56)*M(23)) * den(1682)
  T1sum(1:5,10) = T1sum(1:5,10) + Gcoeff * G1tensor(:,110)
  Gcoeff = (c(68)*M(5)-c(69)*M(9)) * den(1688)
  T1sum(1:5,63) = T1sum(1:5,63) + Gcoeff * G1tensor(:,111)
  Gcoeff = (-(c(68)*M(5))+c(69)*M(9)) * den(1688)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,112)
  Gcoeff = (-(c(59)*M(5))+c(60)*M(9)) * den(1688)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,113)
  Gcoeff = (-(c(19)*M(5))+c(20)*M(9)) * den(1688)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,114)
  Gcoeff = (-(c(55)*M(5))+c(56)*M(9)) * den(1688)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,115)
  Gcoeff = (-(c(68)*M(7))+c(69)*M(11)) * den(1697)
  T1sum(1:5,63) = T1sum(1:5,63) + Gcoeff * G1tensor(:,116)
  Gcoeff = (c(68)*M(7)-c(69)*M(11)) * den(1697)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,117)
  Gcoeff = (c(59)*M(7)-c(60)*M(11)) * den(1697)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,118)
  Gcoeff = (c(19)*M(7)-c(20)*M(11)) * den(1697)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,119)
  Gcoeff = (c(55)*M(7)-c(56)*M(11)) * den(1697)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,120)
  Gcoeff = (c(68)*M(5)-c(69)*M(7)) * den(1703)
  T1sum(1:5,63) = T1sum(1:5,63) + Gcoeff * G1tensor(:,121)
  Gcoeff = (-(c(68)*M(5))+c(69)*M(7)) * den(1703)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,122)
  Gcoeff = (-(c(59)*M(5))+c(60)*M(7)) * den(1703)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,123)
  Gcoeff = (-(c(19)*M(5))+c(20)*M(7)) * den(1703)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,124)
  Gcoeff = (-(c(55)*M(5))+c(56)*M(7)) * den(1703)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,125)
  Gcoeff = (c(69)*M(5)-c(68)*M(7)) * den(1709)
  T1sum(1:5,63) = T1sum(1:5,63) + Gcoeff * G1tensor(:,126)
  Gcoeff = (-(c(69)*M(5))+c(68)*M(7)) * den(1709)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,127)
  Gcoeff = (-(c(60)*M(5))+c(59)*M(7)) * den(1709)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,128)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(7)) * den(1709)
  T1sum(1:5,64) = T1sum(1:5,64) + Gcoeff * G1tensor(:,129)
  Gcoeff = (-(c(56)*M(5))+c(55)*M(7)) * den(1709)
  T1sum(1:5,65) = T1sum(1:5,65) + Gcoeff * G1tensor(:,130)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(13)) * den(1712)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,131)
  Gcoeff = (c(68)*M(1)-c(69)*M(13)) * den(1712)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,132)
  Gcoeff = (c(59)*M(1)-c(60)*M(13)) * den(1712)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,133)
  Gcoeff = (c(19)*M(1)-c(20)*M(13)) * den(1712)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,134)
  Gcoeff = (c(55)*M(1)-c(56)*M(13)) * den(1712)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,135)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(14)) * den(1105)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(14)) * den(1105)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(14)) * den(1105)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(14)) * den(1105)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(48)*M(2))+c(52)*M(14)) * den(1105)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(68)*M(3)-c(69)*M(15)) * den(1721)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,136)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(15)) * den(1721)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,137)
  Gcoeff = (-(c(59)*M(3))+c(60)*M(15)) * den(1721)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,138)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(15)) * den(1721)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,139)
  Gcoeff = (-(c(55)*M(3))+c(56)*M(15)) * den(1721)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,140)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(3)) * den(1724)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,141)
  Gcoeff = (c(68)*M(1)-c(69)*M(3)) * den(1724)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,142)
  Gcoeff = (c(59)*M(1)-c(60)*M(3)) * den(1724)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,143)
  Gcoeff = (c(19)*M(1)-c(20)*M(3)) * den(1724)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,144)
  Gcoeff = (c(55)*M(1)-c(56)*M(3)) * den(1724)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,145)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(3)) * den(1727)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(69)*M(1)-c(68)*M(3)) * den(1727)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(60)*M(1)-c(59)*M(3)) * den(1727)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(20)*M(1)-c(19)*M(3)) * den(1727)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(56)*M(1)-c(55)*M(3)) * den(1727)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(3)) * den(1730)
  T1sum(1:5,27) = T1sum(1:5,27) + Gcoeff * G1tensor(:,146)
  Gcoeff = (c(69)*M(1)-c(68)*M(3)) * den(1730)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,147)
  Gcoeff = (c(60)*M(1)-c(59)*M(3)) * den(1730)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,148)
  Gcoeff = (c(20)*M(1)-c(19)*M(3)) * den(1730)
  T1sum(1:5,28) = T1sum(1:5,28) + Gcoeff * G1tensor(:,149)
  Gcoeff = (c(56)*M(1)-c(55)*M(3)) * den(1730)
  T1sum(1:5,29) = T1sum(1:5,29) + Gcoeff * G1tensor(:,150)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(3)) * den(1733)
  T1sum(1:5,66) = T1sum(1:5,66) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(68)*M(1)-c(69)*M(3)) * den(1733)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(59)*M(1)-c(60)*M(3)) * den(1733)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(19)*M(1)-c(20)*M(3)) * den(1733)
  T1sum(1:5,67) = T1sum(1:5,67) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(55)*M(1)-c(56)*M(3)) * den(1733)
  T1sum(1:5,68) = T1sum(1:5,68) + Gcoeff * G1tensor(:,30)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(4)) * den(1116)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(4)) * den(1116)
  T2sum(1:15,622) = T2sum(1:15,622) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(95)*M(2))+c(96)*M(4)) * den(1116)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(92)*M(2))+c(93)*M(4)) * den(1116)
  T2sum(1:15,623) = T2sum(1:15,623) + Gcoeff * G2tensor(:,85)
  Gcoeff = (-(c(48)*M(2))+c(52)*M(4)) * den(1116)
  T2sum(1:15,603) = T2sum(1:15,603) + Gcoeff * G2tensor(:,88)
  Gcoeff = (-(c(96)*M(2))+c(95)*M(4)) * den(1117)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(93)*M(2))+c(92)*M(4)) * den(1117)
  T2sum(1:15,624) = T2sum(1:15,624) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(96)*M(2))+c(95)*M(4)) * den(1117)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(93)*M(2))+c(92)*M(4)) * den(1117)
  T2sum(1:15,625) = T2sum(1:15,625) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(52)*M(2))+c(48)*M(4)) * den(1117)
  T2sum(1:15,604) = T2sum(1:15,604) + Gcoeff * G2tensor(:,12)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_27

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_27_pptttt_ew_tttxtxgg_1_/**/REALKIND
