
module ol_vamp_1_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxddx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxddx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,48) :: G0
  complex(REALKIND), dimension(4,5,4,180) :: G1
  complex(REALKIND), dimension(4,15,4,292) :: G2
  complex(REALKIND), dimension(4,35,4,87) :: G3
  complex(REALKIND), dimension(5,30) :: G1tensor
  complex(REALKIND), dimension(15,120) :: G2tensor
  complex(REALKIND), dimension(35,150) :: G3tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VQ_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,16),ZERO,G1(:,:,:,1))
  call loop_QA_V(G1(:,:,:,1),wf(:,-5),G1(:,:,:,2))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,1),wf(:,2),G1tensor(:,1))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,2),wf(:,1),G1tensor(:,2))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,1),wf(:,2),G1tensor(:,3))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,40),wf(:,41),G1tensor(:,4))
  call check_last_GGG_G_12(l_switch,G1(:,:,:,2),wf(:,41),wf(:,40),G1tensor(:,5))
  call check_last_GGG_G_23(l_switch,G1(:,:,:,2),wf(:,40),wf(:,41),G1tensor(:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,4),Q(:,15),G2tensor(:,1))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,433),Q(:,15),G2tensor(:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,434),Q(:,15),G2tensor(:,3))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,435),Q(:,15),G2tensor(:,4))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,436),Q(:,15),G2tensor(:,5))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-3),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,56),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,22),G2tensor(:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,25),G2tensor(:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,27),G2tensor(:,8))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,29),G2tensor(:,9))
  call loop_AS_Q(G2(:,:,:,1),wf(:,19),G2(:,:,:,2),gH)
  call loop_A_Q(G2(:,:,:,2),Q(:,61),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,-1),G3tensor(:,1))
  call loop_AS_Q(G2(:,:,:,1),wf(:,23),G2(:,:,:,3),gX)
  call loop_A_Q(G2(:,:,:,3),Q(:,61),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,-1),G3tensor(:,2))
  call loop_AV_Q(G2(:,:,:,1),wf(:,1),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,61),MT,G3(:,:,:,3))
  call check_last_AQ_V(l_switch,G3(:,:,:,3),wf(:,-1),G3tensor(:,3))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,8),G2(:,:,:,5),gZu)
  call loop_A_Q(G2(:,:,:,5),Q(:,61),MT,G3(:,:,:,4))
  call check_last_AQ_V(l_switch,G3(:,:,:,4),wf(:,-1),G3tensor(:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,59),G2tensor(:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,62),G2tensor(:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,64),G2tensor(:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,66),G2tensor(:,13))
  call loop_AS_Q(G2(:,:,:,1),wf(:,57),G2(:,:,:,6),gH)
  call loop_A_Q(G2(:,:,:,6),Q(:,62),MT,G3(:,:,:,5))
  call check_last_AQ_V(l_switch,G3(:,:,:,5),wf(:,0),G3tensor(:,5))
  call loop_AS_Q(G2(:,:,:,1),wf(:,60),G2(:,:,:,7),gX)
  call loop_A_Q(G2(:,:,:,7),Q(:,62),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,0),G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,1),wf(:,41),G2(:,:,:,8))
  call loop_A_Q(G2(:,:,:,8),Q(:,62),MT,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,7))
  call loop_AZ_Q(G2(:,:,:,1),wf(:,49),G2(:,:,:,9),gZu)
  call loop_A_Q(G2(:,:,:,9),Q(:,62),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,8))
  call loop_AQ_S(G2(:,:,:,1),wf(:,-1),G2(:,:,:,10),gH)
  call loop_SQ_A(G2(:,:,:,10),wf(:,0),G2(:,:,:,11),gH)
  call loop_Q_A(G2(:,:,:,11),Q(:,59),MT,G3(:,:,:,9))
  call check_last_QA_V(l_switch,G3(:,:,:,9),wf(:,-2),G3tensor(:,9))
  call loop_SA_Q(G2(:,:,:,10),wf(:,-2),G2(:,:,:,12),gH)
  call loop_A_Q(G2(:,:,:,12),Q(:,62),MT,G3(:,:,:,10))
  call check_last_AQ_V(l_switch,G3(:,:,:,10),wf(:,0),G3tensor(:,10))
  call loop_AQ_S(G2(:,:,:,1),wf(:,-1),G2(:,:,:,13),gX)
  call loop_SQ_A(G2(:,:,:,13),wf(:,0),G2(:,:,:,14),gX)
  call loop_Q_A(G2(:,:,:,14),Q(:,59),MT,G3(:,:,:,11))
  call check_last_QA_V(l_switch,G3(:,:,:,11),wf(:,-2),G3tensor(:,11))
  call loop_SA_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,15),gX)
  call loop_A_Q(G2(:,:,:,15),Q(:,62),MT,G3(:,:,:,12))
  call check_last_AQ_V(l_switch,G3(:,:,:,12),wf(:,0),G3tensor(:,12))
  call loop_AQ_Z(G2(:,:,:,1),wf(:,-1),G2(:,:,:,16),gZu)
  call loop_ZQ_A(G2(:,:,:,16),wf(:,0),G2(:,:,:,17),gZu)
  call loop_Q_A(G2(:,:,:,17),Q(:,59),MT,G3(:,:,:,13))
  call check_last_QA_V(l_switch,G3(:,:,:,13),wf(:,-2),G3tensor(:,13))
  call loop_ZA_Q(G2(:,:,:,16),wf(:,-2),G2(:,:,:,18),gZu)
  call loop_A_Q(G2(:,:,:,18),Q(:,62),MT,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,14))
  call loop_AQ_S(G2(:,:,:,1),wf(:,0),G2(:,:,:,19),gH)
  call loop_SQ_A(G2(:,:,:,19),wf(:,-1),G2(:,:,:,20),gH)
  call loop_Q_A(G2(:,:,:,20),Q(:,59),MT,G3(:,:,:,15))
  call check_last_QA_V(l_switch,G3(:,:,:,15),wf(:,-2),G3tensor(:,15))
  call loop_SA_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,21),gH)
  call loop_A_Q(G2(:,:,:,21),Q(:,61),MT,G3(:,:,:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,16),wf(:,-1),G3tensor(:,16))
  call loop_AQ_S(G2(:,:,:,1),wf(:,0),G2(:,:,:,22),gX)
  call loop_SQ_A(G2(:,:,:,22),wf(:,-1),G2(:,:,:,23),gX)
  call loop_Q_A(G2(:,:,:,23),Q(:,59),MT,G3(:,:,:,17))
  call check_last_QA_V(l_switch,G3(:,:,:,17),wf(:,-2),G3tensor(:,17))
  call loop_SA_Q(G2(:,:,:,22),wf(:,-2),G2(:,:,:,24),gX)
  call loop_A_Q(G2(:,:,:,24),Q(:,61),MT,G3(:,:,:,18))
  call check_last_AQ_V(l_switch,G3(:,:,:,18),wf(:,-1),G3tensor(:,18))
  call loop_AQ_Z(G2(:,:,:,1),wf(:,0),G2(:,:,:,25),gZu)
  call loop_ZQ_A(G2(:,:,:,25),wf(:,-1),G2(:,:,:,26),gZu)
  call loop_Q_A(G2(:,:,:,26),Q(:,59),MT,G3(:,:,:,19))
  call check_last_QA_V(l_switch,G3(:,:,:,19),wf(:,-2),G3tensor(:,19))
  call loop_ZA_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,27),gZu)
  call loop_A_Q(G2(:,:,:,27),Q(:,61),MT,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,-1),G3tensor(:,20))
  call loop_AQ_V(G2(:,:,:,1),wf(:,-1),G2(:,:,:,28))
  call loop_VA_Q(G2(:,:,:,28),wf(:,-2),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,62),MT,G3(:,:,:,21))
  call check_last_AQ_V(l_switch,G3(:,:,:,21),wf(:,0),G3tensor(:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,438),Q(:,15),G2tensor(:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,439),Q(:,15),G2tensor(:,15))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,440),Q(:,15),G2tensor(:,16))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,441),Q(:,15),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,2),wf(:,197),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,61),MT,G2(:,:,:,30))
  call check_last_AQ_V(l_switch,G2(:,:,:,30),wf(:,-1),G2tensor(:,18))
  call loop_VA_Q(G1(:,:,:,2),wf(:,198),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,61),MT,G2(:,:,:,31))
  call check_last_AQ_V(l_switch,G2(:,:,:,31),wf(:,-1),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,2),wf(:,199),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,61),MT,G2(:,:,:,32))
  call check_last_AQ_V(l_switch,G2(:,:,:,32),wf(:,-1),G2tensor(:,20))
  call loop_VA_Q(G1(:,:,:,2),wf(:,200),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,61),MT,G2(:,:,:,33))
  call check_last_AQ_V(l_switch,G2(:,:,:,33),wf(:,-1),G2tensor(:,21))
  call loop_UV_W(G1(:,:,:,2),Q(:,48),wf(:,1),Q(:,5),G2(:,:,:,34))
  call loop_VA_Q(G2(:,:,:,34),wf(:,-3),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,61),MT,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,-1),G3tensor(:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,42),Q(:,15),G2tensor(:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,449),Q(:,15),G2tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,450),Q(:,15),G2tensor(:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,451),Q(:,15),G2tensor(:,25))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,452),Q(:,15),G2tensor(:,26))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,454),Q(:,15),G2tensor(:,27))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,455),Q(:,15),G2tensor(:,28))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,456),Q(:,15),G2tensor(:,29))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,458),Q(:,15),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,2),wf(:,289),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,62),MT,G2(:,:,:,36))
  call check_last_AQ_V(l_switch,G2(:,:,:,36),wf(:,0),G2tensor(:,31))
  call loop_VA_Q(G1(:,:,:,2),wf(:,290),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,62),MT,G2(:,:,:,37))
  call check_last_AQ_V(l_switch,G2(:,:,:,37),wf(:,0),G2tensor(:,32))
  call loop_VA_Q(G1(:,:,:,2),wf(:,291),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,62),MT,G2(:,:,:,38))
  call check_last_AQ_V(l_switch,G2(:,:,:,38),wf(:,0),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,2),wf(:,293),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,62),MT,G2(:,:,:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,39),wf(:,0),G2tensor(:,34))
  call loop_UV_W(G1(:,:,:,2),Q(:,48),wf(:,41),Q(:,6),G2(:,:,:,40))
  call loop_VA_Q(G2(:,:,:,40),wf(:,-3),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,62),MT,G3(:,:,:,23))
  call check_last_AQ_V(l_switch,G3(:,:,:,23),wf(:,0),G3tensor(:,23))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,465),Q(:,15),G2tensor(:,35))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,466),Q(:,15),G2tensor(:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,467),Q(:,15),G2tensor(:,37))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,468),Q(:,15),G2tensor(:,38))
  call loop_VQ_A(G1(:,:,:,2),wf(:,78),G1(:,:,:,12))
  call loop_Q_A(G1(:,:,:,12),Q(:,59),MT,G2(:,:,:,42))
  call check_last_QA_V(l_switch,G2(:,:,:,42),wf(:,-2),G2tensor(:,39))
  call loop_VQ_A(G1(:,:,:,2),wf(:,81),G1(:,:,:,13))
  call loop_Q_A(G1(:,:,:,13),Q(:,59),MT,G2(:,:,:,43))
  call check_last_QA_V(l_switch,G2(:,:,:,43),wf(:,-2),G2tensor(:,40))
  call loop_VQ_A(G1(:,:,:,2),wf(:,83),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,59),MT,G2(:,:,:,44))
  call check_last_QA_V(l_switch,G2(:,:,:,44),wf(:,-2),G2tensor(:,41))
  call loop_VQ_A(G1(:,:,:,2),wf(:,85),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,59),MT,G2(:,:,:,45))
  call check_last_QA_V(l_switch,G2(:,:,:,45),wf(:,-2),G2tensor(:,42))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,470),Q(:,15),G2tensor(:,43))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,471),Q(:,15),G2tensor(:,44))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,472),Q(:,15),G2tensor(:,45))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,473),Q(:,15),G2tensor(:,46))
  call loop_VA_Q(G1(:,:,:,2),wf(:,224),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,61),MT,G2(:,:,:,46))
  call check_last_AQ_V(l_switch,G2(:,:,:,46),wf(:,-1),G2tensor(:,47))
  call loop_VA_Q(G1(:,:,:,2),wf(:,225),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,61),MT,G2(:,:,:,47))
  call check_last_AQ_V(l_switch,G2(:,:,:,47),wf(:,-1),G2tensor(:,48))
  call loop_VA_Q(G1(:,:,:,2),wf(:,226),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,61),MT,G2(:,:,:,48))
  call check_last_AQ_V(l_switch,G2(:,:,:,48),wf(:,-1),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,2),wf(:,227),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,61),MT,G2(:,:,:,49))
  call check_last_AQ_V(l_switch,G2(:,:,:,49),wf(:,-1),G2tensor(:,50))
  call loop_UV_W(G1(:,:,:,2),Q(:,48),wf(:,40),Q(:,9),G2(:,:,:,50))
  call loop_VA_Q(G2(:,:,:,50),wf(:,-2),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,61),MT,G3(:,:,:,24))
  call check_last_AQ_V(l_switch,G3(:,:,:,24),wf(:,-1),G3tensor(:,24))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-2),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,52),MT,G2(:,:,:,52))
  call loop_AS_Q(G2(:,:,:,52),wf(:,75),G2(:,:,:,53),gH)
  call loop_A_Q(G2(:,:,:,53),Q(:,61),MT,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-1),G3tensor(:,25))
  call loop_AS_Q(G2(:,:,:,52),wf(:,79),G2(:,:,:,54),gX)
  call loop_A_Q(G2(:,:,:,54),Q(:,61),MT,G3(:,:,:,26))
  call check_last_AQ_V(l_switch,G3(:,:,:,26),wf(:,-1),G3tensor(:,26))
  call loop_AV_Q(G2(:,:,:,52),wf(:,40),G2(:,:,:,55))
  call loop_A_Q(G2(:,:,:,55),Q(:,61),MT,G3(:,:,:,27))
  call check_last_AQ_V(l_switch,G3(:,:,:,27),wf(:,-1),G3tensor(:,27))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,46),G2(:,:,:,56),gZu)
  call loop_A_Q(G2(:,:,:,56),Q(:,61),MT,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,-1),G3tensor(:,28))
  call loop_AS_Q(G2(:,:,:,52),wf(:,91),G2(:,:,:,57),gH)
  call loop_A_Q(G2(:,:,:,57),Q(:,62),MT,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,29))
  call loop_AS_Q(G2(:,:,:,52),wf(:,94),G2(:,:,:,58),gX)
  call loop_A_Q(G2(:,:,:,58),Q(:,62),MT,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,0),G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,52),wf(:,2),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,62),MT,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,52),wf(:,11),G2(:,:,:,60),gZu)
  call loop_A_Q(G2(:,:,:,60),Q(:,62),MT,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,0),G3tensor(:,32))
  call loop_AQ_S(G2(:,:,:,52),wf(:,0),G2(:,:,:,61),gH)
  call loop_SA_Q(G2(:,:,:,61),wf(:,-3),G2(:,:,:,62),gH)
  call loop_A_Q(G2(:,:,:,62),Q(:,61),MT,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,-1),G3tensor(:,33))
  call loop_AQ_S(G2(:,:,:,52),wf(:,0),G2(:,:,:,63),gX)
  call loop_SA_Q(G2(:,:,:,63),wf(:,-3),G2(:,:,:,64),gX)
  call loop_A_Q(G2(:,:,:,64),Q(:,61),MT,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-1),G3tensor(:,34))
  call loop_AQ_Z(G2(:,:,:,52),wf(:,0),G2(:,:,:,65),gZu)
  call loop_ZA_Q(G2(:,:,:,65),wf(:,-3),G2(:,:,:,66),gZu)
  call loop_A_Q(G2(:,:,:,66),Q(:,61),MT,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,-1),G3tensor(:,35))
  call loop_AQ_S(G2(:,:,:,52),wf(:,-1),G2(:,:,:,67),gH)
  call loop_SA_Q(G2(:,:,:,67),wf(:,-3),G2(:,:,:,68),gH)
  call loop_A_Q(G2(:,:,:,68),Q(:,62),MT,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,0),G3tensor(:,36))
  call loop_AQ_S(G2(:,:,:,52),wf(:,-1),G2(:,:,:,69),gX)
  call loop_SA_Q(G2(:,:,:,69),wf(:,-3),G2(:,:,:,70),gX)
  call loop_A_Q(G2(:,:,:,70),Q(:,62),MT,G3(:,:,:,37))
  call check_last_AQ_V(l_switch,G3(:,:,:,37),wf(:,0),G3tensor(:,37))
  call loop_AQ_V(G2(:,:,:,52),wf(:,-1),G2(:,:,:,71))
  call loop_VA_Q(G2(:,:,:,71),wf(:,-3),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,62),MT,G3(:,:,:,38))
  call check_last_AQ_V(l_switch,G3(:,:,:,38),wf(:,0),G3tensor(:,38))
  call loop_AQ_Z(G2(:,:,:,52),wf(:,-1),G2(:,:,:,73),gZu)
  call loop_ZA_Q(G2(:,:,:,73),wf(:,-3),G2(:,:,:,74),gZu)
  call loop_A_Q(G2(:,:,:,74),Q(:,62),MT,G3(:,:,:,39))
  call check_last_AQ_V(l_switch,G3(:,:,:,39),wf(:,0),G3tensor(:,39))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,481),Q(:,15),G2tensor(:,51))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,482),Q(:,15),G2tensor(:,52))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,483),Q(:,15),G2tensor(:,53))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,484),Q(:,15),G2tensor(:,54))
  call loop_VQ_A(G1(:,:,:,2),wf(:,93),G1(:,:,:,21))
  call loop_Q_A(G1(:,:,:,21),Q(:,59),MT,G2(:,:,:,75))
  call check_last_QA_V(l_switch,G2(:,:,:,75),wf(:,-2),G2tensor(:,55))
  call loop_VQ_A(G1(:,:,:,2),wf(:,96),G1(:,:,:,22))
  call loop_Q_A(G1(:,:,:,22),Q(:,59),MT,G2(:,:,:,76))
  call check_last_QA_V(l_switch,G2(:,:,:,76),wf(:,-2),G2tensor(:,56))
  call loop_VQ_A(G1(:,:,:,2),wf(:,98),G1(:,:,:,23))
  call loop_Q_A(G1(:,:,:,23),Q(:,59),MT,G2(:,:,:,77))
  call check_last_QA_V(l_switch,G2(:,:,:,77),wf(:,-2),G2tensor(:,57))
  call loop_VQ_A(G1(:,:,:,2),wf(:,100),G1(:,:,:,24))
  call loop_Q_A(G1(:,:,:,24),Q(:,59),MT,G2(:,:,:,78))
  call check_last_QA_V(l_switch,G2(:,:,:,78),wf(:,-2),G2tensor(:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,486),Q(:,15),G2tensor(:,59))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,487),Q(:,15),G2tensor(:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,488),Q(:,15),G2tensor(:,61))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,48),wf(:,490),Q(:,15),G2tensor(:,62))
  call loop_VA_Q(G1(:,:,:,2),wf(:,314),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,62),MT,G2(:,:,:,79))
  call check_last_AQ_V(l_switch,G2(:,:,:,79),wf(:,0),G2tensor(:,63))
  call loop_VA_Q(G1(:,:,:,2),wf(:,315),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),MT,G2(:,:,:,80))
  call check_last_AQ_V(l_switch,G2(:,:,:,80),wf(:,0),G2tensor(:,64))
  call loop_VA_Q(G1(:,:,:,2),wf(:,316),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,62),MT,G2(:,:,:,81))
  call check_last_AQ_V(l_switch,G2(:,:,:,81),wf(:,0),G2tensor(:,65))
  call loop_VA_Q(G1(:,:,:,2),wf(:,317),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,62),MT,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,66))
  call loop_UV_W(G1(:,:,:,2),Q(:,48),wf(:,2),Q(:,10),G2(:,:,:,83))
  call loop_VA_Q(G2(:,:,:,83),wf(:,-2),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,62),MT,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,40))
  call loop_VQ_A(G1(:,:,:,2),wf(:,-1),G1(:,:,:,29))
  call loop_Q_A(G1(:,:,:,29),Q(:,50),MT,G2(:,:,:,85))
  call loop_QA_S(G2(:,:,:,85),wf(:,-3),G2(:,:,:,86),gH)
  call loop_SA_Q(G2(:,:,:,86),wf(:,-2),G2(:,:,:,87),gH)
  call loop_A_Q(G2(:,:,:,87),Q(:,62),MT,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,41))
  call loop_QA_S(G2(:,:,:,85),wf(:,-3),G2(:,:,:,88),gX)
  call loop_SA_Q(G2(:,:,:,88),wf(:,-2),G2(:,:,:,89),gX)
  call loop_A_Q(G2(:,:,:,89),Q(:,62),MT,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,42))
  call loop_QA_V(G2(:,:,:,85),wf(:,-3),G2(:,:,:,90))
  call loop_VA_Q(G2(:,:,:,90),wf(:,-2),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,62),MT,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,43))
  call loop_QA_Z(G2(:,:,:,85),wf(:,-3),G2(:,:,:,92),gZu)
  call loop_ZA_Q(G2(:,:,:,92),wf(:,-2),G2(:,:,:,93),gZu)
  call loop_A_Q(G2(:,:,:,93),Q(:,62),MT,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,0),G3tensor(:,44))
  call loop_QA_S(G2(:,:,:,85),wf(:,-2),G2(:,:,:,94),gH)
  call loop_SA_Q(G2(:,:,:,94),wf(:,-3),G2(:,:,:,95),gH)
  call loop_A_Q(G2(:,:,:,95),Q(:,62),MT,G3(:,:,:,45))
  call check_last_AQ_V(l_switch,G3(:,:,:,45),wf(:,0),G3tensor(:,45))
  call loop_QA_S(G2(:,:,:,85),wf(:,-2),G2(:,:,:,96),gX)
  call loop_SA_Q(G2(:,:,:,96),wf(:,-3),G2(:,:,:,97),gX)
  call loop_A_Q(G2(:,:,:,97),Q(:,62),MT,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,0),G3tensor(:,46))
  call loop_QA_V(G2(:,:,:,85),wf(:,-2),G2(:,:,:,98))
  call loop_VA_Q(G2(:,:,:,98),wf(:,-3),G2(:,:,:,99))
  call loop_A_Q(G2(:,:,:,99),Q(:,62),MT,G3(:,:,:,47))
  call check_last_AQ_V(l_switch,G3(:,:,:,47),wf(:,0),G3tensor(:,47))
  call loop_QA_Z(G2(:,:,:,85),wf(:,-2),G2(:,:,:,100),gZu)
  call loop_ZA_Q(G2(:,:,:,100),wf(:,-3),G2(:,:,:,101),gZu)
  call loop_A_Q(G2(:,:,:,101),Q(:,62),MT,G3(:,:,:,48))
  call check_last_AQ_V(l_switch,G3(:,:,:,48),wf(:,0),G3tensor(:,48))
  call loop_QA_V(G1(:,:,:,1),wf(:,118),G1(:,:,:,30))
  call check_last_UV_W(l_switch,G1(:,:,:,30),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,67))
  call loop_VA_Q(G1(:,:,:,30),wf(:,-3),G1(:,:,:,31))
  call loop_A_Q(G1(:,:,:,31),Q(:,61),MT,G2(:,:,:,102))
  call check_last_AQ_V(l_switch,G2(:,:,:,102),wf(:,-1),G2tensor(:,68))
  call loop_QA_V(G1(:,:,:,1),wf(:,119),G1(:,:,:,32))
  call check_last_UV_W(l_switch,G1(:,:,:,32),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,69))
  call loop_VA_Q(G1(:,:,:,32),wf(:,-3),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,61),MT,G2(:,:,:,103))
  call check_last_AQ_V(l_switch,G2(:,:,:,103),wf(:,-1),G2tensor(:,70))
  call loop_QA_V(G1(:,:,:,1),wf(:,123),G1(:,:,:,34))
  call check_last_UV_W(l_switch,G1(:,:,:,34),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,71))
  call loop_VA_Q(G1(:,:,:,34),wf(:,-2),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,62),MT,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,0),G2tensor(:,72))
  call loop_QA_V(G1(:,:,:,1),wf(:,125),G1(:,:,:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,36),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,73))
  call loop_VA_Q(G1(:,:,:,36),wf(:,-2),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,62),MT,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,0),G2tensor(:,74))
  call loop_QV_A(G1(:,:,:,1),wf(:,1),G1(:,:,:,38))
  call loop_Q_A(G1(:,:,:,38),Q(:,21),ZERO,G2(:,:,:,106))
  call loop_QA_V(G2(:,:,:,106),wf(:,-5),G2(:,:,:,107))
  call check_last_UV_W(l_switch,G2(:,:,:,107),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,49))
  call loop_VA_Q(G2(:,:,:,107),wf(:,-3),G2(:,:,:,108))
  call loop_A_Q(G2(:,:,:,108),Q(:,61),MT,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,-1),G3tensor(:,50))
  call loop_QA_Z(G2(:,:,:,106),wf(:,-5),G2(:,:,:,109),gZd)
  call loop_ZA_Q(G2(:,:,:,109),wf(:,-3),G2(:,:,:,110),gZu)
  call loop_A_Q(G2(:,:,:,110),Q(:,61),MT,G3(:,:,:,50))
  call check_last_AQ_V(l_switch,G3(:,:,:,50),wf(:,-1),G3tensor(:,51))
  call loop_ZQ_A(G2(:,:,:,109),wf(:,-1),G2(:,:,:,111),gZu)
  call loop_Q_A(G2(:,:,:,111),Q(:,55),MT,G3(:,:,:,51))
  call check_last_QA_V(l_switch,G3(:,:,:,51),wf(:,-3),G3tensor(:,52))
  call loop_QZ_A(G1(:,:,:,1),wf(:,8),G1(:,:,:,39),gZd)
  call loop_Q_A(G1(:,:,:,39),Q(:,21),ZERO,G2(:,:,:,112))
  call loop_QA_V(G2(:,:,:,112),wf(:,-5),G2(:,:,:,113))
  call check_last_UV_W(l_switch,G2(:,:,:,113),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,53))
  call loop_VA_Q(G2(:,:,:,113),wf(:,-3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,61),MT,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,-1),G3tensor(:,54))
  call loop_QV_A(G1(:,:,:,1),wf(:,2),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,26),ZERO,G2(:,:,:,115))
  call loop_QA_V(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call check_last_UV_W(l_switch,G2(:,:,:,116),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,55))
  call loop_VA_Q(G2(:,:,:,116),wf(:,-2),G2(:,:,:,117))
  call loop_A_Q(G2(:,:,:,117),Q(:,62),MT,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,56))
  call loop_QA_Z(G2(:,:,:,115),wf(:,-5),G2(:,:,:,118),gZd)
  call loop_ZA_Q(G2(:,:,:,118),wf(:,-2),G2(:,:,:,119),gZu)
  call loop_A_Q(G2(:,:,:,119),Q(:,62),MT,G3(:,:,:,54))
  call check_last_AQ_V(l_switch,G3(:,:,:,54),wf(:,0),G3tensor(:,57))
  call loop_ZQ_A(G2(:,:,:,118),wf(:,0),G2(:,:,:,120),gZu)
  call loop_Q_A(G2(:,:,:,120),Q(:,59),MT,G3(:,:,:,55))
  call check_last_QA_V(l_switch,G3(:,:,:,55),wf(:,-2),G3tensor(:,58))
  call loop_QZ_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,41),gZd)
  call loop_Q_A(G1(:,:,:,41),Q(:,26),ZERO,G2(:,:,:,121))
  call loop_QA_V(G2(:,:,:,121),wf(:,-5),G2(:,:,:,122))
  call check_last_UV_W(l_switch,G2(:,:,:,122),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,59))
  call loop_VA_Q(G2(:,:,:,122),wf(:,-2),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,62),MT,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,0),G3tensor(:,60))
  call loop_QA_Z(G1(:,:,:,1),wf(:,-5),G1(:,:,:,42),gZd)
  call loop_ZQ_A(G1(:,:,:,42),wf(:,27),G1(:,:,:,43),gZu)
  call loop_Q_A(G1(:,:,:,43),Q(:,55),MT,G2(:,:,:,124))
  call check_last_QA_V(l_switch,G2(:,:,:,124),wf(:,-3),G2tensor(:,75))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,-3),G1(:,:,:,44),gZu)
  call loop_A_Q(G1(:,:,:,44),Q(:,56),MT,G2(:,:,:,125))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,27),G2tensor(:,76))
  call loop_AV_Q(G2(:,:,:,125),wf(:,1),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,61),MT,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,-1),G3tensor(:,61))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,64),G2tensor(:,77))
  call loop_AV_Q(G2(:,:,:,125),wf(:,41),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,62),MT,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,0),G3tensor(:,62))
  call loop_AQ_V(G2(:,:,:,125),wf(:,-1),G2(:,:,:,128))
  call loop_VA_Q(G2(:,:,:,128),wf(:,-2),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,62),MT,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,0),G3tensor(:,63))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,199),G1(:,:,:,45),gZu)
  call loop_A_Q(G1(:,:,:,45),Q(:,61),MT,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,-1),G2tensor(:,78))
  call loop_ZQ_A(G1(:,:,:,42),wf(:,-1),G1(:,:,:,46),gZu)
  call loop_Q_A(G1(:,:,:,46),Q(:,50),MT,G2(:,:,:,131))
  call check_last_QA_V(l_switch,G2(:,:,:,131),wf(:,199),G2tensor(:,79))
  call loop_QV_A(G2(:,:,:,131),wf(:,1),G2(:,:,:,132))
  call loop_Q_A(G2(:,:,:,132),Q(:,55),MT,G3(:,:,:,60))
  call check_last_QA_V(l_switch,G3(:,:,:,60),wf(:,-3),G3tensor(:,64))
  call check_last_QA_V(l_switch,G2(:,:,:,131),wf(:,226),G2tensor(:,80))
  call loop_QV_A(G2(:,:,:,131),wf(:,40),G2(:,:,:,133))
  call loop_Q_A(G2(:,:,:,133),Q(:,59),MT,G3(:,:,:,61))
  call check_last_QA_V(l_switch,G3(:,:,:,61),wf(:,-2),G3tensor(:,65))
  call loop_QA_V(G2(:,:,:,131),wf(:,-3),G2(:,:,:,134))
  call loop_VA_Q(G2(:,:,:,134),wf(:,-2),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,62),MT,G3(:,:,:,62))
  call check_last_AQ_V(l_switch,G3(:,:,:,62),wf(:,0),G3tensor(:,66))
  call loop_QA_V(G2(:,:,:,131),wf(:,-2),G2(:,:,:,136))
  call loop_VA_Q(G2(:,:,:,136),wf(:,-3),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,62),MT,G3(:,:,:,63))
  call check_last_AQ_V(l_switch,G3(:,:,:,63),wf(:,0),G3tensor(:,67))
  call loop_ZQ_A(G1(:,:,:,42),wf(:,64),G1(:,:,:,47),gZu)
  call loop_Q_A(G1(:,:,:,47),Q(:,55),MT,G2(:,:,:,138))
  call check_last_QA_V(l_switch,G2(:,:,:,138),wf(:,-3),G2tensor(:,81))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,291),G1(:,:,:,48),gZu)
  call loop_A_Q(G1(:,:,:,48),Q(:,62),MT,G2(:,:,:,139))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,0),G2tensor(:,82))
  call loop_ZQ_A(G1(:,:,:,42),wf(:,0),G1(:,:,:,49),gZu)
  call loop_Q_A(G1(:,:,:,49),Q(:,49),MT,G2(:,:,:,140))
  call check_last_QA_V(l_switch,G2(:,:,:,140),wf(:,291),G2tensor(:,83))
  call loop_QV_A(G2(:,:,:,140),wf(:,41),G2(:,:,:,141))
  call loop_Q_A(G2(:,:,:,141),Q(:,55),MT,G3(:,:,:,64))
  call check_last_QA_V(l_switch,G3(:,:,:,64),wf(:,-3),G3tensor(:,68))
  call check_last_QA_V(l_switch,G2(:,:,:,140),wf(:,316),G2tensor(:,84))
  call loop_QV_A(G2(:,:,:,140),wf(:,2),G2(:,:,:,142))
  call loop_Q_A(G2(:,:,:,142),Q(:,59),MT,G3(:,:,:,65))
  call check_last_QA_V(l_switch,G3(:,:,:,65),wf(:,-2),G3tensor(:,69))
  call loop_QA_V(G2(:,:,:,140),wf(:,-2),G2(:,:,:,143))
  call loop_VA_Q(G2(:,:,:,143),wf(:,-3),G2(:,:,:,144))
  call loop_A_Q(G2(:,:,:,144),Q(:,61),MT,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,-1),G3tensor(:,70))
  call loop_QA_V(G2(:,:,:,140),wf(:,-3),G2(:,:,:,145))
  call loop_VA_Q(G2(:,:,:,145),wf(:,-2),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,61),MT,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,-1),G3tensor(:,71))
  call loop_ZQ_A(G1(:,:,:,42),wf(:,83),G1(:,:,:,50),gZu)
  call loop_Q_A(G1(:,:,:,50),Q(:,59),MT,G2(:,:,:,147))
  call check_last_QA_V(l_switch,G2(:,:,:,147),wf(:,-2),G2tensor(:,85))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,-2),G1(:,:,:,51),gZu)
  call loop_A_Q(G1(:,:,:,51),Q(:,52),MT,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,83),G2tensor(:,86))
  call loop_AV_Q(G2(:,:,:,148),wf(:,40),G2(:,:,:,149))
  call loop_A_Q(G2(:,:,:,149),Q(:,61),MT,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,-1),G3tensor(:,72))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,98),G2tensor(:,87))
  call loop_AV_Q(G2(:,:,:,148),wf(:,2),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,62),MT,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,0),G3tensor(:,73))
  call loop_AQ_V(G2(:,:,:,148),wf(:,-1),G2(:,:,:,151))
  call loop_VA_Q(G2(:,:,:,151),wf(:,-3),G2(:,:,:,152))
  call loop_A_Q(G2(:,:,:,152),Q(:,62),MT,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,0),G3tensor(:,74))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,226),G1(:,:,:,52),gZu)
  call loop_A_Q(G1(:,:,:,52),Q(:,61),MT,G2(:,:,:,153))
  call check_last_AQ_V(l_switch,G2(:,:,:,153),wf(:,-1),G2tensor(:,88))
  call loop_ZQ_A(G1(:,:,:,42),wf(:,98),G1(:,:,:,53),gZu)
  call loop_Q_A(G1(:,:,:,53),Q(:,59),MT,G2(:,:,:,154))
  call check_last_QA_V(l_switch,G2(:,:,:,154),wf(:,-2),G2tensor(:,89))
  call loop_ZA_Q(G1(:,:,:,42),wf(:,316),G1(:,:,:,54),gZu)
  call loop_A_Q(G1(:,:,:,54),Q(:,62),MT,G2(:,:,:,155))
  call check_last_AQ_V(l_switch,G2(:,:,:,155),wf(:,0),G2tensor(:,90))
  call loop_QA_Z(G1(:,:,:,1),wf(:,118),G1(:,:,:,55),gZd)
  call loop_ZA_Q(G1(:,:,:,55),wf(:,-3),G1(:,:,:,56),gZu)
  call loop_A_Q(G1(:,:,:,56),Q(:,61),MT,G2(:,:,:,156))
  call check_last_AQ_V(l_switch,G2(:,:,:,156),wf(:,-1),G2tensor(:,91))
  call loop_ZQ_A(G1(:,:,:,55),wf(:,-1),G1(:,:,:,57),gZu)
  call loop_Q_A(G1(:,:,:,57),Q(:,55),MT,G2(:,:,:,157))
  call check_last_QA_V(l_switch,G2(:,:,:,157),wf(:,-3),G2tensor(:,92))
  call loop_QA_V(G1(:,:,:,1),wf(:,160),G1(:,:,:,58))
  call check_last_UV_W(l_switch,G1(:,:,:,58),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,93))
  call loop_VA_Q(G1(:,:,:,58),wf(:,-2),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,61),MT,G2(:,:,:,158))
  call check_last_AQ_V(l_switch,G2(:,:,:,158),wf(:,-1),G2tensor(:,94))
  call loop_QA_V(G1(:,:,:,1),wf(:,161),G1(:,:,:,60))
  call check_last_UV_W(l_switch,G1(:,:,:,60),Q(:,57),wf(:,41),Q(:,6),G2tensor(:,95))
  call loop_VA_Q(G1(:,:,:,60),wf(:,-2),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,61),MT,G2(:,:,:,159))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,-1),G2tensor(:,96))
  call loop_QA_V(G1(:,:,:,1),wf(:,165),G1(:,:,:,62))
  call check_last_UV_W(l_switch,G1(:,:,:,62),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,97))
  call loop_VA_Q(G1(:,:,:,62),wf(:,-3),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,62),MT,G2(:,:,:,160))
  call check_last_AQ_V(l_switch,G2(:,:,:,160),wf(:,0),G2tensor(:,98))
  call loop_QA_V(G1(:,:,:,1),wf(:,167),G1(:,:,:,64))
  call check_last_UV_W(l_switch,G1(:,:,:,64),Q(:,54),wf(:,40),Q(:,9),G2tensor(:,99))
  call loop_VA_Q(G1(:,:,:,64),wf(:,-3),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,62),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,0),G2tensor(:,100))
  call loop_QV_A(G1(:,:,:,1),wf(:,40),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,25),ZERO,G2(:,:,:,162))
  call loop_QA_V(G2(:,:,:,162),wf(:,-5),G2(:,:,:,163))
  call check_last_UV_W(l_switch,G2(:,:,:,163),Q(:,57),wf(:,41),Q(:,6),G3tensor(:,75))
  call loop_VA_Q(G2(:,:,:,163),wf(:,-2),G2(:,:,:,164))
  call loop_A_Q(G2(:,:,:,164),Q(:,61),MT,G3(:,:,:,71))
  call check_last_AQ_V(l_switch,G3(:,:,:,71),wf(:,-1),G3tensor(:,76))
  call loop_QA_Z(G2(:,:,:,162),wf(:,-5),G2(:,:,:,165),gZd)
  call loop_ZA_Q(G2(:,:,:,165),wf(:,-2),G2(:,:,:,166),gZu)
  call loop_A_Q(G2(:,:,:,166),Q(:,61),MT,G3(:,:,:,72))
  call check_last_AQ_V(l_switch,G3(:,:,:,72),wf(:,-1),G3tensor(:,77))
  call loop_ZQ_A(G2(:,:,:,165),wf(:,-1),G2(:,:,:,167),gZu)
  call loop_Q_A(G2(:,:,:,167),Q(:,59),MT,G3(:,:,:,73))
  call check_last_QA_V(l_switch,G3(:,:,:,73),wf(:,-2),G3tensor(:,78))
  call loop_QZ_A(G1(:,:,:,1),wf(:,46),G1(:,:,:,67),gZd)
  call loop_Q_A(G1(:,:,:,67),Q(:,25),ZERO,G2(:,:,:,168))
  call loop_QA_V(G2(:,:,:,168),wf(:,-5),G2(:,:,:,169))
  call check_last_UV_W(l_switch,G2(:,:,:,169),Q(:,57),wf(:,41),Q(:,6),G3tensor(:,79))
  call loop_VA_Q(G2(:,:,:,169),wf(:,-2),G2(:,:,:,170))
  call loop_A_Q(G2(:,:,:,170),Q(:,61),MT,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,-1),G3tensor(:,80))
  call loop_QV_A(G1(:,:,:,1),wf(:,41),G1(:,:,:,68))
  call loop_Q_A(G1(:,:,:,68),Q(:,22),ZERO,G2(:,:,:,171))
  call loop_QA_V(G2(:,:,:,171),wf(:,-5),G2(:,:,:,172))
  call check_last_UV_W(l_switch,G2(:,:,:,172),Q(:,54),wf(:,40),Q(:,9),G3tensor(:,81))
  call loop_VA_Q(G2(:,:,:,172),wf(:,-3),G2(:,:,:,173))
  call loop_A_Q(G2(:,:,:,173),Q(:,62),MT,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,0),G3tensor(:,82))
  call loop_QA_Z(G2(:,:,:,171),wf(:,-5),G2(:,:,:,174),gZd)
  call loop_ZA_Q(G2(:,:,:,174),wf(:,-3),G2(:,:,:,175),gZu)
  call loop_A_Q(G2(:,:,:,175),Q(:,62),MT,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,83))
  call loop_ZQ_A(G2(:,:,:,174),wf(:,0),G2(:,:,:,176),gZu)
  call loop_Q_A(G2(:,:,:,176),Q(:,55),MT,G3(:,:,:,77))
  call check_last_QA_V(l_switch,G3(:,:,:,77),wf(:,-3),G3tensor(:,84))
  call loop_QZ_A(G1(:,:,:,1),wf(:,49),G1(:,:,:,69),gZd)
  call loop_Q_A(G1(:,:,:,69),Q(:,22),ZERO,G2(:,:,:,177))
  call loop_QA_V(G2(:,:,:,177),wf(:,-5),G2(:,:,:,178))
  call check_last_UV_W(l_switch,G2(:,:,:,178),Q(:,54),wf(:,40),Q(:,9),G3tensor(:,85))
  call loop_VA_Q(G2(:,:,:,178),wf(:,-3),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,62),MT,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,0),G3tensor(:,86))
  call loop_QA_Z(G1(:,:,:,1),wf(:,165),G1(:,:,:,70),gZd)
  call loop_ZA_Q(G1(:,:,:,70),wf(:,-3),G1(:,:,:,71),gZu)
  call loop_A_Q(G1(:,:,:,71),Q(:,62),MT,G2(:,:,:,180))
  call check_last_AQ_V(l_switch,G2(:,:,:,180),wf(:,0),G2tensor(:,101))
  call loop_ZQ_A(G1(:,:,:,70),wf(:,0),G1(:,:,:,72),gZu)
  call loop_Q_A(G1(:,:,:,72),Q(:,55),MT,G2(:,:,:,181))
  call check_last_QA_V(l_switch,G2(:,:,:,181),wf(:,-3),G2tensor(:,102))
  call loop_QA_Z(G1(:,:,:,1),wf(:,160),G1(:,:,:,73),gZd)
  call loop_ZA_Q(G1(:,:,:,73),wf(:,-2),G1(:,:,:,74),gZu)
  call loop_A_Q(G1(:,:,:,74),Q(:,61),MT,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,-1),G2tensor(:,103))
  call loop_ZQ_A(G1(:,:,:,73),wf(:,-1),G1(:,:,:,75),gZu)
  call loop_Q_A(G1(:,:,:,75),Q(:,59),MT,G2(:,:,:,183))
  call check_last_QA_V(l_switch,G2(:,:,:,183),wf(:,-2),G2tensor(:,104))
  call loop_QA_Z(G1(:,:,:,1),wf(:,123),G1(:,:,:,76),gZd)
  call loop_ZA_Q(G1(:,:,:,76),wf(:,-2),G1(:,:,:,77),gZu)
  call loop_A_Q(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,184))
  call check_last_AQ_V(l_switch,G2(:,:,:,184),wf(:,0),G2tensor(:,105))
  call loop_ZQ_A(G1(:,:,:,76),wf(:,0),G1(:,:,:,78),gZu)
  call loop_Q_A(G1(:,:,:,78),Q(:,59),MT,G2(:,:,:,185))
  call check_last_QA_V(l_switch,G2(:,:,:,185),wf(:,-2),G2tensor(:,106))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,3))
  call loop_VA_Q(G0(:,:,:,3),wf(:,-3),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,61),MT,G1(:,:,:,79))
  call check_last_AQ_V(l_switch,G1(:,:,:,79),wf(:,-1),G1tensor(:,7))
  call check_last_UV_W(l_switch,G0(:,:,:,3),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,8))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,1),G0(:,:,:,5))
  call loop_VA_Q(G0(:,:,:,5),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,61),MT,G1(:,:,:,80))
  call check_last_AQ_V(l_switch,G1(:,:,:,80),wf(:,-1),G1tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,5),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,10))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,3),G0(:,:,:,7))
  call loop_VA_Q(G0(:,:,:,7),wf(:,-3),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,61),MT,G1(:,:,:,81))
  call check_last_AQ_V(l_switch,G1(:,:,:,81),wf(:,-1),G1tensor(:,11))
  call check_last_UV_W(l_switch,G0(:,:,:,7),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,12))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,41),G0(:,:,:,9))
  call loop_VA_Q(G0(:,:,:,9),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,62),MT,G1(:,:,:,82))
  call check_last_AQ_V(l_switch,G1(:,:,:,82),wf(:,0),G1tensor(:,13))
  call check_last_UV_W(l_switch,G0(:,:,:,9),Q(:,54),wf(:,40),Q(:,9),G1tensor(:,14))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,41),wf(:,3),G0(:,:,:,11))
  call loop_VA_Q(G0(:,:,:,11),wf(:,-3),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,62),MT,G1(:,:,:,83))
  call check_last_AQ_V(l_switch,G1(:,:,:,83),wf(:,0),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,11),Q(:,54),wf(:,40),Q(:,9),G1tensor(:,16))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,41),G0(:,:,:,13))
  call loop_VA_Q(G0(:,:,:,13),wf(:,-3),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,62),MT,G1(:,:,:,84))
  call check_last_AQ_V(l_switch,G1(:,:,:,84),wf(:,0),G1tensor(:,17))
  call check_last_UV_W(l_switch,G0(:,:,:,13),Q(:,54),wf(:,40),Q(:,9),G1tensor(:,18))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,40),G0(:,:,:,15))
  call loop_VA_Q(G0(:,:,:,15),wf(:,-2),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,61),MT,G1(:,:,:,85))
  call check_last_AQ_V(l_switch,G1(:,:,:,85),wf(:,-1),G1tensor(:,19))
  call check_last_UV_W(l_switch,G0(:,:,:,15),Q(:,57),wf(:,41),Q(:,6),G1tensor(:,20))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,40),wf(:,3),G0(:,:,:,17))
  call loop_VA_Q(G0(:,:,:,17),wf(:,-2),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,61),MT,G1(:,:,:,86))
  call check_last_AQ_V(l_switch,G1(:,:,:,86),wf(:,-1),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,17),Q(:,57),wf(:,41),Q(:,6),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,3),wf(:,40),G0(:,:,:,19))
  call loop_VA_Q(G0(:,:,:,19),wf(:,-2),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,61),MT,G1(:,:,:,87))
  call check_last_AQ_V(l_switch,G1(:,:,:,87),wf(:,-1),G1tensor(:,23))
  call check_last_UV_W(l_switch,G0(:,:,:,19),Q(:,57),wf(:,41),Q(:,6),G1tensor(:,24))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,21))
  call loop_VA_Q(G0(:,:,:,21),wf(:,-2),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,62),MT,G1(:,:,:,88))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,0),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,21),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,26))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,3),wf(:,2),G0(:,:,:,23))
  call loop_VA_Q(G0(:,:,:,23),wf(:,-2),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,62),MT,G1(:,:,:,89))
  call check_last_AQ_V(l_switch,G1(:,:,:,89),wf(:,0),G1tensor(:,27))
  call check_last_UV_W(l_switch,G0(:,:,:,23),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,28))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,2),wf(:,3),G0(:,:,:,25))
  call loop_VA_Q(G0(:,:,:,25),wf(:,-2),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,62),MT,G1(:,:,:,90))
  call check_last_AQ_V(l_switch,G1(:,:,:,90),wf(:,0),G1tensor(:,29))
  call check_last_UV_W(l_switch,G0(:,:,:,25),Q(:,58),wf(:,1),Q(:,5),G1tensor(:,30))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,27))
  call loop_A_Q(G0(:,:,:,27),Q(:,10),MT,G1(:,:,:,91))
  call loop_AV_Q(G1(:,:,:,91),wf(:,3),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,58),MT,G2(:,:,:,186))
  call loop_AS_Q(G2(:,:,:,186),wf(:,19),G2(:,:,:,187),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,187),Q(:,63),MT,G3tensor(:,87))
  call loop_AS_Q(G2(:,:,:,186),wf(:,23),G2(:,:,:,188),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,88))
  call loop_AV_Q(G2(:,:,:,186),wf(:,1),G2(:,:,:,189))
  call check_last_A_Q(l_switch,G2(:,:,:,189),Q(:,63),MT,G3tensor(:,89))
  call loop_AZ_Q(G2(:,:,:,186),wf(:,8),G2(:,:,:,190),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,90))
  call loop_AZ_Q(G1(:,:,:,91),wf(:,30),G1(:,:,:,93),gZu)
  call loop_A_Q(G1(:,:,:,93),Q(:,58),MT,G2(:,:,:,191))
  call loop_AV_Q(G2(:,:,:,191),wf(:,1),G2(:,:,:,192))
  call check_last_A_Q(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,91))
  call loop_AQ_S(G1(:,:,:,91),wf(:,69),G1(:,:,:,94),gH)
  call loop_SA_Q(G1(:,:,:,94),wf(:,-2),G1(:,:,:,95),gH)
  call check_last_A_Q(l_switch,G1(:,:,:,95),Q(:,63),MT,G2tensor(:,107))
  call loop_AQ_S(G1(:,:,:,91),wf(:,69),G1(:,:,:,96),gX)
  call loop_SA_Q(G1(:,:,:,96),wf(:,-2),G1(:,:,:,97),gX)
  call check_last_A_Q(l_switch,G1(:,:,:,97),Q(:,63),MT,G2tensor(:,108))
  call loop_AQ_Z(G1(:,:,:,91),wf(:,69),G1(:,:,:,98),gZu)
  call loop_ZA_Q(G1(:,:,:,98),wf(:,-2),G1(:,:,:,99),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,99),Q(:,63),MT,G2tensor(:,109))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,10),MT,G1(:,:,:,100))
  call loop_QV_A(G1(:,:,:,100),wf(:,3),G1(:,:,:,101))
  call loop_Q_A(G1(:,:,:,101),Q(:,58),MT,G2(:,:,:,193))
  call loop_QS_A(G2(:,:,:,193),wf(:,19),G2(:,:,:,194),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,63),MT,G3tensor(:,92))
  call loop_QS_A(G2(:,:,:,193),wf(:,23),G2(:,:,:,195),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,195),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G2(:,:,:,193),wf(:,1),G2(:,:,:,196))
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,94))
  call loop_QZ_A(G2(:,:,:,193),wf(:,8),G2(:,:,:,197),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,197),Q(:,63),MT,G3tensor(:,95))
  call loop_QZ_A(G1(:,:,:,100),wf(:,30),G1(:,:,:,102),gZu)
  call loop_Q_A(G1(:,:,:,102),Q(:,58),MT,G2(:,:,:,198))
  call loop_QV_A(G2(:,:,:,198),wf(:,1),G2(:,:,:,199))
  call check_last_Q_A(l_switch,G2(:,:,:,199),Q(:,63),MT,G3tensor(:,96))
  call loop_QA_S(G1(:,:,:,100),wf(:,229),G1(:,:,:,103),gH)
  call loop_SQ_A(G1(:,:,:,103),wf(:,0),G1(:,:,:,104),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,104),Q(:,63),MT,G2tensor(:,110))
  call loop_QA_S(G1(:,:,:,100),wf(:,229),G1(:,:,:,105),gX)
  call loop_SQ_A(G1(:,:,:,105),wf(:,0),G1(:,:,:,106),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),MT,G2tensor(:,111))
  call loop_QA_Z(G1(:,:,:,100),wf(:,229),G1(:,:,:,107),gZu)
  call loop_ZQ_A(G1(:,:,:,107),wf(:,0),G1(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,63),MT,G2tensor(:,112))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,10),MB,G1(:,:,:,109))
  call loop_AV_Q(G1(:,:,:,109),wf(:,3),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,58),MB,G2(:,:,:,200))
  call loop_AS_Q(G2(:,:,:,200),wf(:,19),G2(:,:,:,201),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,201),Q(:,63),MB,G3tensor(:,97))
  call loop_AS_Q(G2(:,:,:,200),wf(:,23),G2(:,:,:,202),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,202),Q(:,63),MB,G3tensor(:,98))
  call loop_AV_Q(G2(:,:,:,200),wf(:,1),G2(:,:,:,203))
  call check_last_A_Q(l_switch,G2(:,:,:,203),Q(:,63),MB,G3tensor(:,99))
  call loop_AZ_Q(G2(:,:,:,200),wf(:,8),G2(:,:,:,204),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,204),Q(:,63),MB,G3tensor(:,100))
  call loop_AZ_Q(G1(:,:,:,109),wf(:,30),G1(:,:,:,111),gZd)
  call loop_A_Q(G1(:,:,:,111),Q(:,58),MB,G2(:,:,:,205))
  call loop_AV_Q(G2(:,:,:,205),wf(:,1),G2(:,:,:,206))
  call check_last_A_Q(l_switch,G2(:,:,:,206),Q(:,63),MB,G3tensor(:,101))
  call loop_AQ_S(G1(:,:,:,109),wf(:,69),G1(:,:,:,112),gPbt)
  call loop_SA_Q(G1(:,:,:,112),wf(:,-2),G1(:,:,:,113),gPtb)
  call check_last_A_Q(l_switch,G1(:,:,:,113),Q(:,63),MB,G2tensor(:,113))
  call loop_AQ_W(G1(:,:,:,109),wf(:,69),G1(:,:,:,114))
  call loop_WA_Q(G1(:,:,:,114),wf(:,-2),G1(:,:,:,115))
  call check_last_A_Q(l_switch,G1(:,:,:,115),Q(:,63),MB,G2tensor(:,114))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,10),MB,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,3),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,58),MB,G2(:,:,:,207))
  call loop_QS_A(G2(:,:,:,207),wf(:,19),G2(:,:,:,208),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MB,G3tensor(:,102))
  call loop_QS_A(G2(:,:,:,207),wf(:,23),G2(:,:,:,209),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,63),MB,G3tensor(:,103))
  call loop_QV_A(G2(:,:,:,207),wf(:,1),G2(:,:,:,210))
  call check_last_Q_A(l_switch,G2(:,:,:,210),Q(:,63),MB,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,207),wf(:,8),G2(:,:,:,211),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,211),Q(:,63),MB,G3tensor(:,105))
  call loop_QZ_A(G1(:,:,:,116),wf(:,30),G1(:,:,:,118),gZd)
  call loop_Q_A(G1(:,:,:,118),Q(:,58),MB,G2(:,:,:,212))
  call loop_QV_A(G2(:,:,:,212),wf(:,1),G2(:,:,:,213))
  call check_last_Q_A(l_switch,G2(:,:,:,213),Q(:,63),MB,G3tensor(:,106))
  call loop_QA_S(G1(:,:,:,116),wf(:,229),G1(:,:,:,119),gPtb)
  call loop_SQ_A(G1(:,:,:,119),wf(:,0),G1(:,:,:,120),gPbt)
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),MB,G2tensor(:,115))
  call loop_QA_W(G1(:,:,:,116),wf(:,229),G1(:,:,:,121))
  call loop_WQ_A(G1(:,:,:,121),wf(:,0),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),MB,G2tensor(:,116))
  call loop_AS_Q(G0(:,:,:,1),wf(:,91),G0(:,:,:,31),gH)
  call loop_A_Q(G0(:,:,:,31),Q(:,10),MT,G1(:,:,:,123))
  call loop_AV_Q(G1(:,:,:,123),wf(:,3),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,58),MT,G2(:,:,:,214))
  call loop_AV_Q(G2(:,:,:,214),wf(:,1),G2(:,:,:,215))
  call check_last_A_Q(l_switch,G2(:,:,:,215),Q(:,63),MT,G3tensor(:,107))
  call loop_QS_A(G0(:,:,:,1),wf(:,91),G0(:,:,:,32),gH)
  call loop_Q_A(G0(:,:,:,32),Q(:,10),MT,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,3),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,58),MT,G2(:,:,:,216))
  call loop_QV_A(G2(:,:,:,216),wf(:,1),G2(:,:,:,217))
  call check_last_Q_A(l_switch,G2(:,:,:,217),Q(:,63),MT,G3tensor(:,108))
  call loop_AS_Q(G0(:,:,:,1),wf(:,91),G0(:,:,:,33),gH)
  call loop_A_Q(G0(:,:,:,33),Q(:,10),MB,G1(:,:,:,127))
  call loop_AV_Q(G1(:,:,:,127),wf(:,3),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,58),MB,G2(:,:,:,218))
  call loop_AV_Q(G2(:,:,:,218),wf(:,1),G2(:,:,:,219))
  call check_last_A_Q(l_switch,G2(:,:,:,219),Q(:,63),MB,G3tensor(:,109))
  call loop_QS_A(G0(:,:,:,1),wf(:,91),G0(:,:,:,34),gH)
  call loop_Q_A(G0(:,:,:,34),Q(:,10),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,3),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,58),MB,G2(:,:,:,220))
  call loop_QV_A(G2(:,:,:,220),wf(:,1),G2(:,:,:,221))
  call check_last_Q_A(l_switch,G2(:,:,:,221),Q(:,63),MB,G3tensor(:,110))
  call loop_AS_Q(G0(:,:,:,1),wf(:,94),G0(:,:,:,35),gX)
  call loop_A_Q(G0(:,:,:,35),Q(:,10),MT,G1(:,:,:,131))
  call loop_AV_Q(G1(:,:,:,131),wf(:,3),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,58),MT,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,1),G2(:,:,:,223))
  call check_last_A_Q(l_switch,G2(:,:,:,223),Q(:,63),MT,G3tensor(:,111))
  call loop_QS_A(G0(:,:,:,1),wf(:,94),G0(:,:,:,36),gX)
  call loop_Q_A(G0(:,:,:,36),Q(:,10),MT,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,3),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,58),MT,G2(:,:,:,224))
  call loop_QV_A(G2(:,:,:,224),wf(:,1),G2(:,:,:,225))
  call check_last_Q_A(l_switch,G2(:,:,:,225),Q(:,63),MT,G3tensor(:,112))
  call loop_AS_Q(G0(:,:,:,1),wf(:,94),G0(:,:,:,37),gX)
  call loop_A_Q(G0(:,:,:,37),Q(:,10),MB,G1(:,:,:,135))
  call loop_AV_Q(G1(:,:,:,135),wf(:,3),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,58),MB,G2(:,:,:,226))
  call loop_AV_Q(G2(:,:,:,226),wf(:,1),G2(:,:,:,227))
  call check_last_A_Q(l_switch,G2(:,:,:,227),Q(:,63),MB,G3tensor(:,113))
  call loop_QS_A(G0(:,:,:,1),wf(:,94),G0(:,:,:,38),gX)
  call loop_Q_A(G0(:,:,:,38),Q(:,10),MB,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,3),G1(:,:,:,138))
  call loop_Q_A(G1(:,:,:,138),Q(:,58),MB,G2(:,:,:,228))
  call loop_QV_A(G2(:,:,:,228),wf(:,1),G2(:,:,:,229))
  call check_last_Q_A(l_switch,G2(:,:,:,229),Q(:,63),MB,G3tensor(:,114))
  call loop_AV_Q(G0(:,:,:,1),wf(:,2),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,10),ZERO,G1(:,:,:,139))
  call loop_AV_Q(G1(:,:,:,139),wf(:,3),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,58),ZERO,G2(:,:,:,230))
  call loop_AV_Q(G2(:,:,:,230),wf(:,1),G2(:,:,:,231))
  call check_last_A_Q(l_switch,G2(:,:,:,231),Q(:,63),ZERO,G3tensor(:,115))
  call loop_AZ_Q(G2(:,:,:,230),wf(:,8),G2(:,:,:,232),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,232),Q(:,63),ZERO,G3tensor(:,116))
  call loop_AZ_Q(G2(:,:,:,230),wf(:,8),G2(:,:,:,233),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,233),Q(:,63),ZERO,G3tensor(:,117))
  call loop_AZ_Q(G1(:,:,:,139),wf(:,30),G1(:,:,:,141),gZu)
  call loop_A_Q(G1(:,:,:,141),Q(:,58),ZERO,G2(:,:,:,234))
  call loop_AV_Q(G2(:,:,:,234),wf(:,1),G2(:,:,:,235))
  call check_last_A_Q(l_switch,G2(:,:,:,235),Q(:,63),ZERO,G3tensor(:,118))
  call loop_AZ_Q(G1(:,:,:,139),wf(:,30),G1(:,:,:,142),gZd)
  call loop_A_Q(G1(:,:,:,142),Q(:,58),ZERO,G2(:,:,:,236))
  call loop_AV_Q(G2(:,:,:,236),wf(:,1),G2(:,:,:,237))
  call check_last_A_Q(l_switch,G2(:,:,:,237),Q(:,63),ZERO,G3tensor(:,119))
  call loop_AQ_Z(G1(:,:,:,139),wf(:,-4),G1(:,:,:,143),gZd)
  call loop_ZA_Q(G1(:,:,:,143),wf(:,-5),G1(:,:,:,144),gZd)
  call loop_A_Q(G1(:,:,:,144),Q(:,58),ZERO,G2(:,:,:,238))
  call loop_AV_Q(G2(:,:,:,238),wf(:,1),G2(:,:,:,239))
  call check_last_A_Q(l_switch,G2(:,:,:,239),Q(:,63),ZERO,G3tensor(:,120))
  call loop_AQ_W(G1(:,:,:,139),wf(:,-4),G1(:,:,:,145))
  call loop_WA_Q(G1(:,:,:,145),wf(:,-5),G1(:,:,:,146))
  call loop_A_Q(G1(:,:,:,146),Q(:,58),ZERO,G2(:,:,:,240))
  call loop_AV_Q(G2(:,:,:,240),wf(:,1),G2(:,:,:,241))
  call check_last_A_Q(l_switch,G2(:,:,:,241),Q(:,63),ZERO,G3tensor(:,121))
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,10),ZERO,G1(:,:,:,147))
  call loop_QV_A(G1(:,:,:,147),wf(:,3),G1(:,:,:,148))
  call loop_Q_A(G1(:,:,:,148),Q(:,58),ZERO,G2(:,:,:,242))
  call loop_QV_A(G2(:,:,:,242),wf(:,1),G2(:,:,:,243))
  call check_last_Q_A(l_switch,G2(:,:,:,243),Q(:,63),ZERO,G3tensor(:,122))
  call loop_QZ_A(G2(:,:,:,242),wf(:,8),G2(:,:,:,244),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),ZERO,G3tensor(:,123))
  call loop_QZ_A(G2(:,:,:,242),wf(:,8),G2(:,:,:,245),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,245),Q(:,63),ZERO,G3tensor(:,124))
  call loop_QZ_A(G1(:,:,:,147),wf(:,30),G1(:,:,:,149),gZu)
  call loop_Q_A(G1(:,:,:,149),Q(:,58),ZERO,G2(:,:,:,246))
  call loop_QV_A(G2(:,:,:,246),wf(:,1),G2(:,:,:,247))
  call check_last_Q_A(l_switch,G2(:,:,:,247),Q(:,63),ZERO,G3tensor(:,125))
  call loop_QZ_A(G1(:,:,:,147),wf(:,30),G1(:,:,:,150),gZd)
  call loop_Q_A(G1(:,:,:,150),Q(:,58),ZERO,G2(:,:,:,248))
  call loop_QV_A(G2(:,:,:,248),wf(:,1),G2(:,:,:,249))
  call check_last_Q_A(l_switch,G2(:,:,:,249),Q(:,63),ZERO,G3tensor(:,126))
  call loop_QA_Z(G1(:,:,:,147),wf(:,-5),G1(:,:,:,151),gZd)
  call loop_ZQ_A(G1(:,:,:,151),wf(:,-4),G1(:,:,:,152),gZd)
  call loop_Q_A(G1(:,:,:,152),Q(:,58),ZERO,G2(:,:,:,250))
  call loop_QV_A(G2(:,:,:,250),wf(:,1),G2(:,:,:,251))
  call check_last_Q_A(l_switch,G2(:,:,:,251),Q(:,63),ZERO,G3tensor(:,127))
  call loop_QA_W(G1(:,:,:,147),wf(:,-5),G1(:,:,:,153))
  call loop_WQ_A(G1(:,:,:,153),wf(:,-4),G1(:,:,:,154))
  call loop_Q_A(G1(:,:,:,154),Q(:,58),ZERO,G2(:,:,:,252))
  call loop_QV_A(G2(:,:,:,252),wf(:,1),G2(:,:,:,253))
  call check_last_Q_A(l_switch,G2(:,:,:,253),Q(:,63),ZERO,G3tensor(:,128))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,41),gZu)
  call loop_A_Q(G0(:,:,:,41),Q(:,10),ZERO,G1(:,:,:,155))
  call loop_AV_Q(G1(:,:,:,155),wf(:,3),G1(:,:,:,156))
  call loop_A_Q(G1(:,:,:,156),Q(:,58),ZERO,G2(:,:,:,254))
  call loop_AV_Q(G2(:,:,:,254),wf(:,1),G2(:,:,:,255))
  call check_last_A_Q(l_switch,G2(:,:,:,255),Q(:,63),ZERO,G3tensor(:,129))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,42),gZu)
  call loop_A_Q(G0(:,:,:,42),Q(:,10),MT,G1(:,:,:,157))
  call loop_AV_Q(G1(:,:,:,157),wf(:,3),G1(:,:,:,158))
  call loop_A_Q(G1(:,:,:,158),Q(:,58),MT,G2(:,:,:,256))
  call loop_AV_Q(G2(:,:,:,256),wf(:,1),G2(:,:,:,257))
  call check_last_A_Q(l_switch,G2(:,:,:,257),Q(:,63),MT,G3tensor(:,130))
  call loop_QZ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,43),gZu)
  call loop_Q_A(G0(:,:,:,43),Q(:,10),ZERO,G1(:,:,:,159))
  call loop_QV_A(G1(:,:,:,159),wf(:,3),G1(:,:,:,160))
  call loop_Q_A(G1(:,:,:,160),Q(:,58),ZERO,G2(:,:,:,258))
  call loop_QV_A(G2(:,:,:,258),wf(:,1),G2(:,:,:,259))
  call check_last_Q_A(l_switch,G2(:,:,:,259),Q(:,63),ZERO,G3tensor(:,131))
  call loop_QZ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,44),gZu)
  call loop_Q_A(G0(:,:,:,44),Q(:,10),MT,G1(:,:,:,161))
  call loop_QV_A(G1(:,:,:,161),wf(:,3),G1(:,:,:,162))
  call loop_Q_A(G1(:,:,:,162),Q(:,58),MT,G2(:,:,:,260))
  call loop_QV_A(G2(:,:,:,260),wf(:,1),G2(:,:,:,261))
  call check_last_Q_A(l_switch,G2(:,:,:,261),Q(:,63),MT,G3tensor(:,132))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,45),gZd)
  call loop_A_Q(G0(:,:,:,45),Q(:,10),ZERO,G1(:,:,:,163))
  call loop_AV_Q(G1(:,:,:,163),wf(:,3),G1(:,:,:,164))
  call loop_A_Q(G1(:,:,:,164),Q(:,58),ZERO,G2(:,:,:,262))
  call loop_AV_Q(G2(:,:,:,262),wf(:,1),G2(:,:,:,263))
  call check_last_A_Q(l_switch,G2(:,:,:,263),Q(:,63),ZERO,G3tensor(:,133))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,11),G0(:,:,:,46),gZd)
  call loop_A_Q(G0(:,:,:,46),Q(:,10),MB,G1(:,:,:,165))
  call loop_AV_Q(G1(:,:,:,165),wf(:,3),G1(:,:,:,166))
  call loop_A_Q(G1(:,:,:,166),Q(:,58),MB,G2(:,:,:,264))
  call loop_AV_Q(G2(:,:,:,264),wf(:,1),G2(:,:,:,265))
  call check_last_A_Q(l_switch,G2(:,:,:,265),Q(:,63),MB,G3tensor(:,134))
  call loop_QZ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,47),gZd)
  call loop_Q_A(G0(:,:,:,47),Q(:,10),ZERO,G1(:,:,:,167))
  call loop_QV_A(G1(:,:,:,167),wf(:,3),G1(:,:,:,168))
  call loop_Q_A(G1(:,:,:,168),Q(:,58),ZERO,G2(:,:,:,266))
  call loop_QV_A(G2(:,:,:,266),wf(:,1),G2(:,:,:,267))
  call check_last_Q_A(l_switch,G2(:,:,:,267),Q(:,63),ZERO,G3tensor(:,135))
  call loop_QZ_A(G0(:,:,:,1),wf(:,11),G0(:,:,:,48),gZd)
  call loop_Q_A(G0(:,:,:,48),Q(:,10),MB,G1(:,:,:,169))
  call loop_QV_A(G1(:,:,:,169),wf(:,3),G1(:,:,:,170))
  call loop_Q_A(G1(:,:,:,170),Q(:,58),MB,G2(:,:,:,268))
  call loop_QV_A(G2(:,:,:,268),wf(:,1),G2(:,:,:,269))
  call check_last_Q_A(l_switch,G2(:,:,:,269),Q(:,63),MB,G3tensor(:,136))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,171))
  call loop_DV_C(G1(:,:,:,171),Q(:,10),wf(:,3),G2(:,:,:,270))
  call check_last_DV_C(l_switch,G2(:,:,:,270),Q(:,58),wf(:,1),G3tensor(:,137))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,172))
  call loop_CV_D(G1(:,:,:,172),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,271))
  call check_last_CV_D(l_switch,G2(:,:,:,271),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,138))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,173))
  call loop_UV_W(G1(:,:,:,173),Q(:,10),wf(:,3),Q(:,48),G2(:,:,:,272))
  call check_last_UV_W(l_switch,G2(:,:,:,272),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,139))
  call loop_VA_Q(G2(:,:,:,272),wf(:,-2),G2(:,:,:,273))
  call loop_A_Q(G2(:,:,:,273),Q(:,62),MT,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,0),G3tensor(:,140))
  call loop_VA_Q(G1(:,:,:,173),wf(:,-5),G1(:,:,:,174))
  call loop_A_Q(G1(:,:,:,174),Q(:,42),ZERO,G2(:,:,:,274))
  call loop_AQ_V(G2(:,:,:,274),wf(:,-4),G2(:,:,:,275))
  call check_last_UV_W(l_switch,G2(:,:,:,275),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,141))
  call loop_VA_Q(G2(:,:,:,275),wf(:,-2),G2(:,:,:,276))
  call loop_A_Q(G2(:,:,:,276),Q(:,62),MT,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,0),G3tensor(:,142))
  call loop_AQ_Z(G2(:,:,:,274),wf(:,-4),G2(:,:,:,277),gZd)
  call loop_ZQ_A(G2(:,:,:,277),wf(:,0),G2(:,:,:,278),gZu)
  call loop_Q_A(G2(:,:,:,278),Q(:,59),MT,G3(:,:,:,81))
  call check_last_QA_V(l_switch,G3(:,:,:,81),wf(:,-2),G3tensor(:,143))
  call loop_ZA_Q(G2(:,:,:,277),wf(:,-2),G2(:,:,:,279),gZu)
  call loop_A_Q(G2(:,:,:,279),Q(:,62),MT,G3(:,:,:,82))
  call check_last_AQ_V(l_switch,G3(:,:,:,82),wf(:,0),G3tensor(:,144))
  call loop_VQ_A(G1(:,:,:,173),wf(:,-4),G1(:,:,:,175))
  call loop_Q_A(G1(:,:,:,175),Q(:,26),ZERO,G2(:,:,:,280))
  call loop_QA_V(G2(:,:,:,280),wf(:,-5),G2(:,:,:,281))
  call check_last_UV_W(l_switch,G2(:,:,:,281),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,145))
  call loop_VA_Q(G2(:,:,:,281),wf(:,-2),G2(:,:,:,282))
  call loop_A_Q(G2(:,:,:,282),Q(:,62),MT,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,0),G3tensor(:,146))
  call loop_QA_Z(G2(:,:,:,280),wf(:,-5),G2(:,:,:,283),gZd)
  call loop_ZQ_A(G2(:,:,:,283),wf(:,0),G2(:,:,:,284),gZu)
  call loop_Q_A(G2(:,:,:,284),Q(:,59),MT,G3(:,:,:,84))
  call check_last_QA_V(l_switch,G3(:,:,:,84),wf(:,-2),G3tensor(:,147))
  call loop_ZA_Q(G2(:,:,:,283),wf(:,-2),G2(:,:,:,285),gZu)
  call loop_A_Q(G2(:,:,:,285),Q(:,62),MT,G3(:,:,:,85))
  call check_last_AQ_V(l_switch,G3(:,:,:,85),wf(:,0),G3tensor(:,148))
  call loop_VQ_A(G1(:,:,:,173),wf(:,69),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,59),MT,G2(:,:,:,286))
  call check_last_QA_V(l_switch,G2(:,:,:,286),wf(:,-2),G2tensor(:,117))
  call loop_VQ_A(G1(:,:,:,173),wf(:,73),G1(:,:,:,177))
  call loop_Q_A(G1(:,:,:,177),Q(:,59),MT,G2(:,:,:,287))
  call check_last_QA_V(l_switch,G2(:,:,:,287),wf(:,-2),G2tensor(:,118))
  call loop_VA_Q(G1(:,:,:,173),wf(:,229),G1(:,:,:,178))
  call loop_A_Q(G1(:,:,:,178),Q(:,62),MT,G2(:,:,:,288))
  call check_last_AQ_V(l_switch,G2(:,:,:,288),wf(:,0),G2tensor(:,119))
  call loop_VA_Q(G1(:,:,:,173),wf(:,233),G1(:,:,:,179))
  call loop_A_Q(G1(:,:,:,179),Q(:,62),MT,G2(:,:,:,289))
  call check_last_AQ_V(l_switch,G2(:,:,:,289),wf(:,0),G2tensor(:,120))
  call loop_VA_Q(G1(:,:,:,173),wf(:,-2),G1(:,:,:,180))
  call loop_A_Q(G1(:,:,:,180),Q(:,14),MT,G2(:,:,:,290))
  call loop_AV_Q(G2(:,:,:,290),wf(:,3),G2(:,:,:,291))
  call loop_A_Q(G2(:,:,:,291),Q(:,62),MT,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,0),G3tensor(:,149))
  call loop_AZ_Q(G2(:,:,:,290),wf(:,30),G2(:,:,:,292),gZu)
  call loop_A_Q(G2(:,:,:,292),Q(:,62),MT,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,0),G3tensor(:,150))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (-(c(69)*M(4))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,1)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(69)*(M(4)-M(6))) * den(4)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,3)
  Gcoeff = (-(c(69)*M(4))+c(64)*(-M(2)+M(8)+M(10))) * den(193)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(69)*M(6))+c(64)*(-M(2)+M(8)+M(10))) * den(193)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(69)*(M(4)-M(6))) * den(193)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(69)*M(2)+c(64)*(-M(4)-M(6)+M(12))) * den(39)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(69)*M(8)+c(64)*(-M(4)-M(6)+M(12))) * den(39)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(69)*(-M(2)+M(8))) * den(39)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(69)*M(2)+c(64)*(-M(4)+M(6)-M(12))) * den(235)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(69)*M(8)+c(64)*(-M(4)+M(6)-M(12))) * den(235)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(69)*(-M(2)+M(8))) * den(235)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(69)*M(8)+c(64)*(M(4)-M(6)-M(12))) * den(239)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(69)*M(2)+c(64)*(M(4)-M(6)-M(12))) * den(239)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(69)*(M(2)-M(8))) * den(239)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)-M(8)+M(10))) * den(189)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,25)
  Gcoeff = (-(c(69)*M(4))+c(64)*(M(2)-M(8)+M(10))) * den(189)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(69)*(-M(4)+M(6))) * den(189)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,29)
  Gcoeff = (-(c(118)*M(7))+c(117)*M(11)) * den(412)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,87)
  Gcoeff = (-(c(118)*M(7))+c(117)*M(11)) * den(412)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,92)
  Gcoeff = (-(c(116)*M(7))+c(115)*M(11)) * den(412)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,97)
  Gcoeff = (-(c(116)*M(7))+c(115)*M(11)) * den(412)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(118)*M(7)-c(117)*M(11)) * den(413)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(118)*M(7)-c(117)*M(11)) * den(413)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,93)
  Gcoeff = (-(c(116)*M(7))+c(115)*M(11)) * den(413)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,98)
  Gcoeff = (-(c(116)*M(7))+c(115)*M(11)) * den(413)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,103)
  Gcoeff = (-(c(118)*M(1))+c(117)*M(11)) * den(414)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,107)
  Gcoeff = (-(c(118)*M(1))+c(117)*M(11)) * den(414)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,108)
  Gcoeff = (-(c(116)*M(1))+c(115)*M(11)) * den(414)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,109)
  Gcoeff = (-(c(116)*M(1))+c(115)*M(11)) * den(414)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(118)*M(1)-c(117)*M(11)) * den(415)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,111)
  Gcoeff = (c(118)*M(1)-c(117)*M(11)) * den(415)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,112)
  Gcoeff = (-(c(116)*M(1))+c(115)*M(11)) * den(415)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,113)
  Gcoeff = (-(c(116)*M(1))+c(115)*M(11)) * den(415)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(100)*M(7)-c(99)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(98)*M(7)-c(97)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(100)*M(7)-c(99)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(98)*M(7)-c(97)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,94)
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,99)
  Gcoeff = (-(c(98)*M(7))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (-(c(96)*M(7))+c(95)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(413)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(413)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(413)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(413)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(413)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,117)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(413)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(104)*M(7)-c(103)*M(11)) * den(413)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,124)
  Gcoeff = (c(102)*M(7)-c(101)*M(11)) * den(413)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(100)*M(1)-c(99)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(98)*M(1)-c(97)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(100)*M(1)-c(99)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(98)*M(1)-c(97)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,94)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,99)
  Gcoeff = (-(c(98)*M(1))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (-(c(96)*M(1))+c(95)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(415)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(415)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,130)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(415)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,131)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(415)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,132)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(415)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(415)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,134)
  Gcoeff = (c(104)*M(1)-c(103)*M(11)) * den(415)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,135)
  Gcoeff = (c(102)*M(1)-c(101)*M(11)) * den(415)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,136)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,89)
  Gcoeff = (-(c(98)*M(9))+c(97)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (-(c(96)*M(9))+c(95)*M(11)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(96)*M(9)-c(95)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(94)*M(9)-c(93)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(96)*M(9)-c(95)*M(11)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(94)*M(9)-c(93)*M(11)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(417)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(417)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(417)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(417)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(417)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,119)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(417)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,101)
  Gcoeff = (c(104)*M(9)-c(103)*M(11)) * den(417)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,126)
  Gcoeff = (c(102)*M(9)-c(101)*M(11)) * den(417)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,106)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8)-M(10))+c(112)*M(12)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8)-M(10))+c(108)*M(12)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,89)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8)-M(10))+c(112)*M(12)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8)-M(10))+c(108)*M(12)) * den(416)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(114)*M(4)+c(113)*(-M(2)-M(8)-M(10))+c(112)*M(12)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(110)*M(4)+c(109)*(-M(2)-M(8)-M(10))+c(108)*M(12)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(114)*M(6)+c(113)*(-M(2)-M(8)-M(10))+c(112)*M(12)) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(110)*M(6)+c(109)*(-M(2)-M(8)-M(10))+c(108)*M(12)) * den(416)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(50)*(-M(4)+M(6))) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(50)*(M(4)-M(6))) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(50)*(M(4)-M(6))) * den(416)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,139)
  Gcoeff = (-(c(3)*M(7))+c(2)*M(11)) * den(106)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(7)*M(7)-c(6)*M(11)) * den(108)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(2)-M(8))+c(47)*M(12)) * den(106)
  T2sum(1:15,13) = T2sum(1:15,13) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(3)*M(1))+c(2)*M(11)) * den(112)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(7)*M(1)-c(6)*M(11)) * den(115)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(50)*M(6)+c(48)*(-M(2)-M(8))+c(47)*M(12)) * den(112)
  T2sum(1:15,21) = T2sum(1:15,21) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(69)*(-M(4)+M(6))) * den(198)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(4)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,127)
  Gcoeff = (-(c(74)*M(5))+c(73)*(M(1)+M(7))-c(72)*M(11)) * den(4)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,128)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,141)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(4)
  T3sum(1:35,9) = T3sum(1:35,9) + Gcoeff * G3tensor(:,120)
  Gcoeff = (-(c(74)*M(3))+c(73)*(M(1)+M(7))-c(72)*M(11)) * den(4)
  T3sum(1:35,10) = T3sum(1:35,10) + Gcoeff * G3tensor(:,121)
  Gcoeff = (-(c(69)*M(4))+c(64)*(M(2)+M(8)-M(10))) * den(4)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,145)
  Gcoeff = (-(c(3)*M(7))+c(2)*M(11)) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(7)*M(7)-c(6)*M(11)) * den(99)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,53)
  Gcoeff = (-(c(48)*M(10))+c(47)*M(12)) * den(4)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,49)
  Gcoeff = (-(c(3)*M(1))+c(2)*M(11)) * den(4)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(7)*M(1)-c(6)*M(11)) * den(101)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,59)
  Gcoeff = (-(c(48)*M(10))+c(47)*M(12)) * den(4)
  T3sum(1:35,13) = T3sum(1:35,13) + Gcoeff * G3tensor(:,55)
  Gcoeff = (-(c(80)*M(7))+c(79)*M(11)) * den(315)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(80)*M(7)-c(79)*M(11)) * den(316)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(5)*M(7)-c(4)*M(11)) * den(317)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(7)*M(7)-c(6)*M(11)) * den(316)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(8)-M(10))+c(47)*M(12)) * den(317)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(26)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(85)*M(7))+c(88)*M(11)) * den(22)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(85)*M(7)-c(88)*M(11)) * den(24)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(25)*M(7)-c(28)*M(11)) * den(26)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(24)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(26)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(26)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(26)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(61)*M(4)-c(57)*M(8)-c(65)*M(10)+c(60)*M(12)) * den(26)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(80)*M(7))+c(79)*M(11)) * den(320)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(80)*M(7)-c(79)*M(11)) * den(321)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(5)*M(7)-c(4)*M(11)) * den(322)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(7)*M(7)-c(6)*M(11)) * den(321)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(50)*M(6)+c(48)*(-M(8)-M(10))+c(47)*M(12)) * den(322)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(85)*M(7))+c(88)*M(11)) * den(138)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(85)*M(7)-c(88)*M(11)) * den(140)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(25)*M(7)-c(28)*M(11)) * den(142)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(140)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(142)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(142)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(142)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(61)*M(6)-c(57)*M(8)-c(65)*M(10)+c(60)*M(12)) * den(142)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(142)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(15)*M(7))+c(18)*M(11)) * den(105)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(107)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(105)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(105)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(105)
  T2sum(1:15,69) = T2sum(1:15,69) + Gcoeff * G2tensor(:,91)
  Gcoeff = (-(c(65)*M(2))+c(61)*M(4)-c(57)*M(8)+c(60)*M(12)) * den(105)
  T2sum(1:15,67) = T2sum(1:15,67) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(105)
  T2sum(1:15,71) = T2sum(1:15,71) + Gcoeff * G2tensor(:,92)
  Gcoeff = (-(c(15)*M(7))+c(18)*M(11)) * den(1)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(9)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(1)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(1)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,50)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(1)
  T3sum(1:35,28) = T3sum(1:35,28) + Gcoeff * G3tensor(:,51)
  Gcoeff = (-(c(56)*M(2))+c(59)*(M(4)+M(6))-c(57)*M(8)-c(64)*M(10)+c(60)*M(12)) * den(1)
  T3sum(1:35,26) = T3sum(1:35,26) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(2)*(-M(3)+M(5))) * den(1)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(47)*(-M(4)+M(6))+c(48)*(M(2)-M(10))) * den(1)
  T3sum(1:35,29) = T3sum(1:35,29) + Gcoeff * G3tensor(:,22)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(1)
  T3sum(1:35,32) = T3sum(1:35,32) + Gcoeff * G3tensor(:,52)
  Gcoeff = (-(c(85)*M(7))+c(88)*M(11)) * den(20)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(85)*M(7)-c(88)*M(11)) * den(9)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(25)*M(7)-c(28)*M(11)) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(37)*M(7)-c(40)*M(11)) * den(9)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11)) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(1)
  T3sum(1:35,42) = T3sum(1:35,42) + Gcoeff * G3tensor(:,61)
  Gcoeff = (-(c(64)*M(2))+c(59)*(M(4)+M(6))-c(57)*M(8)-c(56)*M(10)+c(60)*M(12)) * den(1)
  T3sum(1:35,40) = T3sum(1:35,40) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(7)+M(9))-c(35)*M(11)) * den(1)
  T3sum(1:35,44) = T3sum(1:35,44) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(3)*M(5)-c(2)*M(9)) * den(127)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,93)
  Gcoeff = (-(c(7)*M(5))+c(6)*M(9)) * den(129)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,95)
  Gcoeff = (-(c(50)*M(2))+c(48)*(M(4)+M(6))-c(47)*M(10)) * den(127)
  T2sum(1:15,80) = T2sum(1:15,80) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(3)*M(3)-c(2)*M(9)) * den(133)
  T2sum(1:15,88) = T2sum(1:15,88) + Gcoeff * G2tensor(:,97)
  Gcoeff = (-(c(7)*M(3))+c(6)*M(9)) * den(136)
  T2sum(1:15,88) = T2sum(1:15,88) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(48)*(M(4)+M(6))-c(50)*M(8)-c(47)*M(10)) * den(133)
  T2sum(1:15,88) = T2sum(1:15,88) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(69)*(-M(2)+M(8))) * den(243)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(3)*M(5)-c(2)*M(9)) * den(39)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,75)
  Gcoeff = (-(c(7)*M(5))+c(6)*M(9)) * den(120)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,79)
  Gcoeff = (-(c(47)*M(10))+c(48)*M(12)) * den(39)
  T3sum(1:35,57) = T3sum(1:35,57) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(3)*M(3)-c(2)*M(9)) * den(39)
  T3sum(1:35,58) = T3sum(1:35,58) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(7)*M(3))+c(6)*M(9)) * den(122)
  T3sum(1:35,58) = T3sum(1:35,58) + Gcoeff * G3tensor(:,85)
  Gcoeff = (-(c(47)*M(10))+c(48)*M(12)) * den(39)
  T3sum(1:35,58) = T3sum(1:35,58) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(80)*M(3)-c(79)*M(9)) * den(331)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(80)*M(3))+c(79)*M(9)) * den(332)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,24)
  Gcoeff = (-(c(5)*M(3))+c(4)*M(9)) * den(333)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (-(c(7)*M(3))+c(6)*M(9)) * den(332)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,26)
  Gcoeff = (-(c(50)*M(8))-c(47)*M(10)+c(48)*(M(4)+M(12))) * den(333)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(60)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(85)*M(3)-c(88)*M(9)) * den(56)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(85)*M(3))+c(88)*M(9)) * den(58)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(25)*M(3))+c(28)*M(9)) * den(60)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(37)*M(3))+c(40)*M(9)) * den(58)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(60)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(60)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(60)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(57)*M(4)-c(61)*M(8)-c(60)*M(10)+c(65)*M(12)) * den(60)
  T2sum(1:15,52) = T2sum(1:15,52) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(80)*M(3)-c(79)*M(9)) * den(335)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,27)
  Gcoeff = (-(c(80)*M(3))+c(79)*M(9)) * den(336)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(5)*M(3))+c(4)*M(9)) * den(337)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (-(c(7)*M(3))+c(6)*M(9)) * den(336)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(50)*M(2))-c(47)*M(10)+c(48)*(M(4)+M(12))) * den(337)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(85)*M(3)-c(88)*M(9)) * den(171)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,31)
  Gcoeff = (-(c(85)*M(3))+c(88)*M(9)) * den(173)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(25)*M(3))+c(28)*M(9)) * den(175)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(37)*M(3))+c(40)*M(9)) * den(173)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(175)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(175)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(175)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,82)
  Gcoeff = (-(c(61)*M(2))+c(57)*M(4)-c(60)*M(10)+c(65)*M(12)) * den(175)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(175)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(15)*M(3)-c(18)*M(9)) * den(132)
  T2sum(1:15,120) = T2sum(1:15,120) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(37)*M(3))+c(40)*M(9)) * den(135)
  T2sum(1:15,120) = T2sum(1:15,120) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(14)*(M(3)+M(5))-c(17)*M(7)-c(13)*M(9)) * den(132)
  T2sum(1:15,120) = T2sum(1:15,120) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(14)*(M(3)+M(5))-c(17)*M(7)-c(13)*M(9)) * den(132)
  T2sum(1:15,120) = T2sum(1:15,120) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(132)
  T2sum(1:15,122) = T2sum(1:15,122) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(57)*M(4)+c(65)*M(6)-c(61)*M(8)-c(60)*M(10)) * den(132)
  T2sum(1:15,120) = T2sum(1:15,120) + Gcoeff * G2tensor(:,98)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(132)
  T2sum(1:15,124) = T2sum(1:15,124) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(15)*M(3)-c(18)*M(9)) * den(38)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,82)
  Gcoeff = (-(c(37)*M(3))+c(40)*M(9)) * den(47)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(17)*M(1))+c(14)*(M(3)+M(5))-c(13)*M(9)) * den(38)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(14)*(M(3)+M(5))-c(17)*M(7)-c(13)*M(9)) * den(38)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(38)
  T3sum(1:35,73) = T3sum(1:35,73) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(57)*M(4)+c(56)*M(6)+c(59)*(-M(2)-M(8))-c(60)*M(10)+c(64)*M(12)) * den(38)
  T3sum(1:35,71) = T3sum(1:35,71) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(2)*(-M(1)+M(7))) * den(38)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(47)*(-M(2)+M(8))+c(48)*(-M(6)+M(12))) * den(38)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9)) * den(38)
  T3sum(1:35,77) = T3sum(1:35,77) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(85)*M(3)-c(88)*M(9)) * den(55)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(85)*M(3))+c(88)*M(9)) * den(47)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,6)
  Gcoeff = (-(c(25)*M(3))+c(28)*M(9)) * den(38)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(37)*M(3))+c(40)*M(9)) * den(47)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(38)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(3)+M(11))) * den(38)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(38)
  T3sum(1:35,87) = T3sum(1:35,87) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(57)*M(4)+c(64)*M(6)+c(59)*(-M(2)-M(8))-c(60)*M(10)+c(56)*M(12)) * den(38)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(3)-M(11))) * den(38)
  T3sum(1:35,89) = T3sum(1:35,89) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(80)*M(5)-c(79)*M(9)) * den(346)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(9)) * den(347)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,36)
  Gcoeff = (-(c(5)*M(5))+c(4)*M(9)) * den(348)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(7)*M(5))+c(6)*M(9)) * den(347)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,38)
  Gcoeff = (-(c(50)*M(2))-c(47)*M(10)+c(48)*(M(6)+M(12))) * den(348)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,37)
  Gcoeff = (-(c(90)*M(5))-c(83)*M(9)) * den(72)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(90)*M(5)+c(83)*M(9)) * den(74)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(30)*M(5)+c(23)*M(9)) * den(76)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(42)*M(5)+c(35)*M(9)) * den(74)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(76)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(76)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(76)
  T2sum(1:15,147) = T2sum(1:15,147) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(67)*M(2)-c(62)*M(6)-c(55)*M(10)+c(56)*M(12)) * den(76)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(76)
  T2sum(1:15,149) = T2sum(1:15,149) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(80)*M(5)-c(79)*M(9)) * den(350)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,43)
  Gcoeff = (-(c(80)*M(5))+c(79)*M(9)) * den(351)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(5)*M(5))+c(4)*M(9)) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(7)*M(5))+c(6)*M(9)) * den(351)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(50)*M(8))-c(47)*M(10)+c(48)*(M(6)+M(12))) * den(352)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(85)*M(5)-c(88)*M(9)) * den(152)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(85)*M(5))+c(88)*M(9)) * den(154)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(25)*M(5))+c(28)*M(9)) * den(156)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(37)*M(5))+c(40)*M(9)) * den(154)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,50)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(156)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(156)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(156)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(57)*M(6)-c(61)*M(8)-c(60)*M(10)+c(65)*M(12)) * den(156)
  T2sum(1:15,55) = T2sum(1:15,55) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(156)
  T2sum(1:15,59) = T2sum(1:15,59) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(15)*M(5)-c(18)*M(9)) * den(126)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(37)*M(5))+c(40)*M(9)) * den(128)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(17)*M(1))+c(14)*(M(3)+M(5))-c(13)*M(9)) * den(126)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(17)*M(1))+c(14)*(M(3)+M(5))-c(13)*M(9)) * den(126)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(126)
  T2sum(1:15,159) = T2sum(1:15,159) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(61)*M(2))+c(65)*M(4)+c(57)*M(6)-c(60)*M(10)) * den(126)
  T2sum(1:15,157) = T2sum(1:15,157) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(126)
  T2sum(1:15,161) = T2sum(1:15,161) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(15)*M(5)-c(18)*M(9)) * den(37)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(37)*M(5))+c(40)*M(9)) * den(44)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(14)*(M(3)+M(5))-c(17)*M(7)-c(13)*M(9)) * den(37)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(17)*M(1))+c(14)*(M(3)+M(5))-c(13)*M(9)) * den(37)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(37)
  T3sum(1:35,105) = T3sum(1:35,105) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(56)*M(4)+c(57)*M(6)+c(59)*(-M(2)-M(8))-c(60)*M(10)+c(64)*M(12)) * den(37)
  T3sum(1:35,103) = T3sum(1:35,103) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(2)*(M(1)-M(7))) * den(37)
  T3sum(1:35,106) = T3sum(1:35,106) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(47)*(M(2)-M(8))+c(48)*(-M(4)+M(12))) * den(37)
  T3sum(1:35,106) = T3sum(1:35,106) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9)) * den(37)
  T3sum(1:35,109) = T3sum(1:35,109) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(85)*M(5)-c(88)*M(9)) * den(70)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(85)*M(5))+c(88)*M(9)) * den(44)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,26)
  Gcoeff = (-(c(25)*M(5))+c(28)*M(9)) * den(37)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(37)*M(5))+c(40)*M(9)) * den(44)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,28)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(37)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(5)+M(11))) * den(37)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(37)
  T3sum(1:35,119) = T3sum(1:35,119) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(64)*M(4)+c(57)*M(6)+c(59)*(-M(2)-M(8))-c(60)*M(10)+c(56)*M(12)) * den(37)
  T3sum(1:35,117) = T3sum(1:35,117) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(5)-M(11))) * den(37)
  T3sum(1:35,121) = T3sum(1:35,121) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(87)*M(3)+c(84)*(-M(1)-M(9))+c(83)*M(11)) * den(93)
  T2sum(1:15,164) = T2sum(1:15,164) + Gcoeff * G2tensor(:,107)
  Gcoeff = (-(c(87)*M(3))+c(84)*(M(1)+M(9))-c(83)*M(11)) * den(93)
  T2sum(1:15,165) = T2sum(1:15,165) + Gcoeff * G2tensor(:,108)
  Gcoeff = (-(c(78)*M(3))+c(77)*(M(1)+M(9))-c(76)*M(11)) * den(93)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,113)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(93)
  T2sum(1:15,165) = T2sum(1:15,165) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(74)*M(3))+c(73)*(M(1)+M(9))-c(72)*M(11)) * den(93)
  T2sum(1:15,166) = T2sum(1:15,166) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(3)*M(9))+c(2)*M(11)) * den(93)
  T2sum(1:15,167) = T2sum(1:15,167) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(7)*M(9)-c(6)*M(11)) * den(94)
  T2sum(1:15,167) = T2sum(1:15,167) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(2)-M(10))+c(47)*M(12)) * den(93)
  T2sum(1:15,167) = T2sum(1:15,167) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(1)-M(9))+c(83)*M(11)) * den(180)
  T2sum(1:15,169) = T2sum(1:15,169) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(1)+M(9))-c(83)*M(11)) * den(180)
  T2sum(1:15,170) = T2sum(1:15,170) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(78)*M(5))+c(77)*(M(1)+M(9))-c(76)*M(11)) * den(180)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,115)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(180)
  T2sum(1:15,170) = T2sum(1:15,170) + Gcoeff * G2tensor(:,112)
  Gcoeff = (-(c(74)*M(5))+c(73)*(M(1)+M(9))-c(72)*M(11)) * den(180)
  T2sum(1:15,171) = T2sum(1:15,171) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(180)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(181)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,120)
  Gcoeff = (-(c(50)*M(6))+c(48)*(M(2)+M(10))-c(47)*M(12)) * den(180)
  T2sum(1:15,172) = T2sum(1:15,172) + Gcoeff * G2tensor(:,119)
  Gcoeff = (-(c(69)*M(6))+c(64)*(M(2)-M(8)+M(10))) * den(189)
  T3sum(1:35,127) = T3sum(1:35,127) + Gcoeff * G3tensor(:,140)
  Gcoeff = (c(3)*M(9)-c(2)*M(11)) * den(189)
  T3sum(1:35,134) = T3sum(1:35,134) + Gcoeff * G3tensor(:,149)
  Gcoeff = (-(c(7)*M(9))+c(6)*M(11)) * den(435)
  T3sum(1:35,134) = T3sum(1:35,134) + Gcoeff * G3tensor(:,150)
  Gcoeff = (c(48)*M(8)-c(47)*M(12)) * den(189)
  T3sum(1:35,134) = T3sum(1:35,134) + Gcoeff * G3tensor(:,149)
  Gcoeff = (-(c(80)*M(1))+c(79)*M(11)) * den(361)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(80)*M(1)-c(79)*M(11)) * den(362)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(5)*M(1)-c(4)*M(11)) * den(363)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(7)*M(1)-c(6)*M(11)) * den(362)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(50)*M(6)+c(48)*(-M(2)-M(10))+c(47)*M(12)) * den(363)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(90)*M(1)+c(83)*M(11)) * den(84)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(90)*M(1))-c(83)*M(11)) * den(86)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(30)*M(1))-c(23)*M(11)) * den(88)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(42)*M(1))-c(35)*M(11)) * den(86)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(88)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(88)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(88)
  T2sum(1:15,147) = T2sum(1:15,147) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(62)*M(2)-c(67)*M(6)-c(56)*M(10)+c(55)*M(12)) * den(88)
  T2sum(1:15,145) = T2sum(1:15,145) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(88)
  T2sum(1:15,149) = T2sum(1:15,149) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(80)*M(1))+c(79)*M(11)) * den(365)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(80)*M(1)-c(79)*M(11)) * den(366)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(5)*M(1)-c(4)*M(11)) * den(367)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(7)*M(1)-c(6)*M(11)) * den(366)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(50)*M(4)+c(48)*(-M(2)-M(10))+c(47)*M(12)) * den(367)
  T2sum(1:15,1) = T2sum(1:15,1) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(85)*M(1))+c(88)*M(11)) * den(182)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(85)*M(1)-c(88)*M(11)) * den(184)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(25)*M(1)-c(28)*M(11)) * den(186)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(37)*M(1)-c(40)*M(11)) * den(184)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(186)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(186)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(186)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,90)
  Gcoeff = (-(c(57)*M(2))+c(61)*M(4)-c(65)*M(10)+c(60)*M(12)) * den(186)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,65)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(186)
  T2sum(1:15,112) = T2sum(1:15,112) + Gcoeff * G2tensor(:,84)
  Gcoeff = (-(c(15)*M(1))+c(18)*M(11)) * den(111)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(37)*M(1)-c(40)*M(11)) * den(114)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(111)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(111)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(111)
  T2sum(1:15,185) = T2sum(1:15,185) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(57)*M(2))+c(61)*M(6)-c(65)*M(8)+c(60)*M(12)) * den(111)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(111)
  T2sum(1:15,187) = T2sum(1:15,187) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(15)*M(1))+c(18)*M(11)) * den(2)
  T3sum(1:35,135) = T3sum(1:35,135) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(37)*M(1)-c(40)*M(11)) * den(12)
  T3sum(1:35,135) = T3sum(1:35,135) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(2)
  T3sum(1:35,135) = T3sum(1:35,135) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(7))+c(13)*M(11)) * den(2)
  T3sum(1:35,135) = T3sum(1:35,135) + Gcoeff * G3tensor(:,56)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(2)
  T3sum(1:35,137) = T3sum(1:35,137) + Gcoeff * G3tensor(:,57)
  Gcoeff = (-(c(57)*M(2))+c(59)*(M(4)+M(6))-c(56)*M(8)-c(64)*M(10)+c(60)*M(12)) * den(2)
  T3sum(1:35,135) = T3sum(1:35,135) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(2)*(M(3)-M(5))) * den(2)
  T3sum(1:35,138) = T3sum(1:35,138) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,139) = T3sum(1:35,139) + Gcoeff * G3tensor(:,143)
  Gcoeff = (c(47)*(M(4)-M(6))+c(48)*(M(8)-M(10))) * den(2)
  T3sum(1:35,138) = T3sum(1:35,138) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11)) * den(2)
  T3sum(1:35,141) = T3sum(1:35,141) + Gcoeff * G3tensor(:,58)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,144) = T3sum(1:35,144) + Gcoeff * G3tensor(:,147)
  Gcoeff = (c(2)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,145) = T3sum(1:35,145) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,146) = T3sum(1:35,146) + Gcoeff * G3tensor(:,144)
  Gcoeff = (c(48)*M(2)-c(47)*M(4)-c(49)*M(6)) * den(2)
  T3sum(1:35,145) = T3sum(1:35,145) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(2)*(-M(3)+M(5))) * den(2)
  T3sum(1:35,147) = T3sum(1:35,147) + Gcoeff * G3tensor(:,146)
  Gcoeff = (c(6)*(M(3)-M(5))) * den(2)
  T3sum(1:35,148) = T3sum(1:35,148) + Gcoeff * G3tensor(:,148)
  Gcoeff = (c(47)*(-M(4)+M(6))+c(48)*(M(8)-M(10))) * den(2)
  T3sum(1:35,147) = T3sum(1:35,147) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(85)*M(1))+c(88)*M(11)) * den(83)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(85)*M(1)-c(88)*M(11)) * den(12)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(25)*M(1)-c(28)*M(11)) * den(2)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(37)*M(1)-c(40)*M(11)) * den(12)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(2)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(9))+c(13)*M(11)) * den(2)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(2)
  T3sum(1:35,151) = T3sum(1:35,151) + Gcoeff * G3tensor(:,73)
  Gcoeff = (-(c(57)*M(2))+c(59)*(M(4)+M(6))-c(64)*M(8)-c(56)*M(10)+c(60)*M(12)) * den(2)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(9))-c(35)*M(11)) * den(2)
  T3sum(1:35,153) = T3sum(1:35,153) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(1)-M(7))+c(83)*M(11))
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,9)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(1)+M(7))-c(83)*M(11))
  T3sum(1:35,220) = T3sum(1:35,220) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11))
  T3sum(1:35,220) = T3sum(1:35,220) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(87)*M(1))+c(84)*(M(3)+M(5))-c(83)*M(9))
  T3sum(1:35,229) = T3sum(1:35,229) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(87)*M(1)+c(84)*(-M(3)-M(5))+c(83)*M(9))
  T3sum(1:35,230) = T3sum(1:35,230) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9))
  T3sum(1:35,230) = T3sum(1:35,230) + Gcoeff * G3tensor(:,19)
  Gcoeff = (-(c(87)*M(1))+c(84)*(M(3)+M(5))-c(83)*M(9))
  T3sum(1:35,239) = T3sum(1:35,239) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(87)*M(1)+c(84)*(-M(3)-M(5))+c(83)*M(9))
  T3sum(1:35,240) = T3sum(1:35,240) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(39)*M(1)+c(36)*(-M(3)-M(5))+c(35)*M(9))
  T3sum(1:35,240) = T3sum(1:35,240) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(87)*M(3)+c(84)*(-M(1)-M(7))+c(83)*M(11))
  T3sum(1:35,249) = T3sum(1:35,249) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(87)*M(3))+c(84)*(M(1)+M(7))-c(83)*M(11))
  T3sum(1:35,250) = T3sum(1:35,250) + Gcoeff * G3tensor(:,34)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(7))-c(35)*M(11))
  T3sum(1:35,250) = T3sum(1:35,250) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(1)-M(7))+c(83)*M(11))
  T3sum(1:35,259) = T3sum(1:35,259) + Gcoeff * G3tensor(:,10)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(1)+M(7))-c(83)*M(11))
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(7)-M(9))+c(13)*M(11))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(7))-c(23)*M(11))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(9))+c(13)*M(11))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,21)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11))
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,14)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11))
  T3sum(1:35,263) = T3sum(1:35,263) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(61)*M(4)+c(59)*M(6)+c(56)*(-M(2)-M(8))-c(65)*M(10)+c(55)*M(12))
  T3sum(1:35,261) = T3sum(1:35,261) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(87)*M(5)+c(84)*(-M(1)-M(7))+c(83)*M(11))
  T3sum(1:35,264) = T3sum(1:35,264) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(87)*M(5))+c(84)*(M(1)+M(7))-c(83)*M(11))
  T3sum(1:35,265) = T3sum(1:35,265) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(17)*M(5)+c(14)*(-M(7)-M(9))+c(13)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(17)*M(3)+c(14)*(-M(1)-M(9))+c(13)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(27)*M(5))+c(24)*(M(1)+M(7))-c(23)*M(11))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(39)*M(3))+c(36)*(M(1)+M(9))-c(35)*M(11))
  T3sum(1:35,268) = T3sum(1:35,268) + Gcoeff * G3tensor(:,66)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(1)+M(7))-c(35)*M(11))
  T3sum(1:35,265) = T3sum(1:35,265) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(59)*M(4)+c(61)*M(6)-c(65)*M(8)+c(56)*(-M(2)-M(10))+c(55)*M(12))
  T3sum(1:35,266) = T3sum(1:35,266) + Gcoeff * G3tensor(:,43)
  Gcoeff = (-(c(39)*M(5))+c(36)*(M(7)+M(9))-c(35)*M(11))
  T3sum(1:35,277) = T3sum(1:35,277) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(84)*(M(3)+M(5))-c(87)*M(7)-c(83)*M(9))
  T3sum(1:35,279) = T3sum(1:35,279) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(84)*(-M(3)-M(5))+c(87)*M(7)+c(83)*M(9))
  T3sum(1:35,280) = T3sum(1:35,280) + Gcoeff * G3tensor(:,37)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(5)+M(11)))
  T3sum(1:35,281) = T3sum(1:35,281) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(24)*(-M(3)-M(5))+c(27)*M(7)+c(23)*M(9))
  T3sum(1:35,281) = T3sum(1:35,281) + Gcoeff * G3tensor(:,38)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(3)+M(11)))
  T3sum(1:35,281) = T3sum(1:35,281) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9))
  T3sum(1:35,280) = T3sum(1:35,280) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11)))
  T3sum(1:35,283) = T3sum(1:35,283) + Gcoeff * G3tensor(:,74)
  Gcoeff = (-(c(61)*M(2))+c(56)*(M(4)+M(6))-c(59)*M(8)-c(55)*M(10)+c(65)*M(12))
  T3sum(1:35,281) = T3sum(1:35,281) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(84)*(M(3)+M(5))-c(87)*M(7)-c(83)*M(9))
  T3sum(1:35,284) = T3sum(1:35,284) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(84)*(-M(3)-M(5))+c(87)*M(7)+c(83)*M(9))
  T3sum(1:35,285) = T3sum(1:35,285) + Gcoeff * G3tensor(:,46)
  Gcoeff = (-(c(17)*M(7))-c(13)*M(9)+c(14)*(M(5)+M(11)))
  T3sum(1:35,286) = T3sum(1:35,286) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(17)*M(1))-c(13)*M(9)+c(14)*(M(3)+M(11)))
  T3sum(1:35,286) = T3sum(1:35,286) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(24)*(-M(3)-M(5))+c(27)*M(7)+c(23)*M(9))
  T3sum(1:35,286) = T3sum(1:35,286) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(39)*M(1)+c(35)*M(9)+c(36)*(-M(3)-M(11)))
  T3sum(1:35,288) = T3sum(1:35,288) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(36)*(-M(3)-M(5))+c(39)*M(7)+c(35)*M(9))
  T3sum(1:35,285) = T3sum(1:35,285) + Gcoeff * G3tensor(:,48)
  Gcoeff = (-(c(59)*M(2))+c(65)*M(6)-c(61)*M(8)-c(55)*M(10)+c(56)*(M(4)+M(12)))
  T3sum(1:35,286) = T3sum(1:35,286) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(39)*M(7)+c(35)*M(9)+c(36)*(-M(5)-M(11)))
  T3sum(1:35,297) = T3sum(1:35,297) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(45)*(M(4)-M(6))) * den(436)
  T2sum(1:5,269) = T2sum(1:5,269) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(45)*(-M(4)+M(6))) * den(436)
  T2sum(1:5,269) = T2sum(1:5,269) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(46)*(-M(4)+M(6))) * den(436)
  T2sum(1:5,269) = T2sum(1:5,269) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(45)*(-M(4)+M(6))) * den(437)
  T2sum(1:5,270) = T2sum(1:5,270) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(45)*(M(4)-M(6))) * den(437)
  T2sum(1:5,270) = T2sum(1:5,270) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(46)*(M(4)-M(6))) * den(437)
  T2sum(1:5,270) = T2sum(1:5,270) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(45)*(M(2)-M(8))) * den(438)
  T2sum(1:5,272) = T2sum(1:5,272) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(45)*(-M(2)+M(8))) * den(438)
  T2sum(1:5,272) = T2sum(1:5,272) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(46)*(-M(2)+M(8))) * den(438)
  T2sum(1:5,272) = T2sum(1:5,272) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(45)*(-M(2)+M(8))) * den(439)
  T2sum(1:5,273) = T2sum(1:5,273) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(45)*(M(2)-M(8))) * den(439)
  T2sum(1:5,273) = T2sum(1:5,273) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(46)*(M(2)-M(8))) * den(439)
  T2sum(1:5,273) = T2sum(1:5,273) + Gcoeff * G1tensor(:,24)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pptttt_ew_tttxtxddx_1_/**/REALKIND
