
module ol_vamp_12_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_12(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(28)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,17) :: G0
  complex(REALKIND), dimension(4,5,4,271) :: G1
  complex(REALKIND), dimension(4,15,4,319) :: G2
  complex(REALKIND), dimension(4,35,4,68) :: G3
  complex(REALKIND), dimension(15,84) :: G2tensor
  complex(REALKIND), dimension(35,188) :: G3tensor
  complex(REALKIND), dimension(70,40) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,2),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,10),ZERO,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,11),G1(:,:,:,2))
  call loop_Q_A(G1(:,:,:,2),Q(:,58),ZERO,G2(:,:,:,1))
  call loop_QV_A(G2(:,:,:,1),wf(:,1),G2(:,:,:,2))
  call check_last_Q_A(l_switch,G2(:,:,:,2),Q(:,63),ZERO,G3tensor(:,1))
  call loop_QZ_A(G2(:,:,:,1),wf(:,26),G2(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,3),Q(:,63),ZERO,G3tensor(:,2))
  call loop_QZ_A(G2(:,:,:,1),wf(:,26),G2(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,4),Q(:,63),ZERO,G3tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,-5),G1(:,:,:,3))
  call loop_Q_A(G1(:,:,:,3),Q(:,42),ZERO,G2(:,:,:,5))
  call loop_QV_A(G2(:,:,:,5),wf(:,-4),G2(:,:,:,6))
  call loop_Q_A(G2(:,:,:,6),Q(:,58),ZERO,G3(:,:,:,1))
  call loop_QV_A(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call check_last_Q_A(l_switch,G3(:,:,:,2),Q(:,63),ZERO,G4tensor(:,1))
  call loop_QZ_A(G3(:,:,:,1),wf(:,26),G3(:,:,:,3),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,3),Q(:,63),ZERO,G4tensor(:,2))
  call loop_QZ_A(G3(:,:,:,1),wf(:,26),G3(:,:,:,4),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,4),Q(:,63),ZERO,G4tensor(:,3))
  call loop_QV_A(G1(:,:,:,1),wf(:,-4),G1(:,:,:,4))
  call loop_Q_A(G1(:,:,:,4),Q(:,26),ZERO,G2(:,:,:,7))
  call loop_QV_A(G2(:,:,:,7),wf(:,-5),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,58),ZERO,G3(:,:,:,5))
  call loop_QV_A(G3(:,:,:,5),wf(:,1),G3(:,:,:,6))
  call check_last_Q_A(l_switch,G3(:,:,:,6),Q(:,63),ZERO,G4tensor(:,4))
  call loop_QZ_A(G3(:,:,:,5),wf(:,26),G3(:,:,:,7),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,7),Q(:,63),ZERO,G4tensor(:,5))
  call loop_QZ_A(G3(:,:,:,5),wf(:,26),G3(:,:,:,8),gZd)
  call check_last_Q_A(l_switch,G3(:,:,:,8),Q(:,63),ZERO,G4tensor(:,6))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,150),G0(:,:,:,3),gZu)
  call loop_A_Q(G0(:,:,:,3),Q(:,10),ZERO,G1(:,:,:,5))
  call loop_AV_Q(G1(:,:,:,5),wf(:,11),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,58),ZERO,G2(:,:,:,9))
  call loop_AV_Q(G2(:,:,:,9),wf(:,1),G2(:,:,:,10))
  call check_last_A_Q(l_switch,G2(:,:,:,10),Q(:,63),ZERO,G3tensor(:,4))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-5),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,42),ZERO,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-4),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,58),ZERO,G3(:,:,:,9))
  call loop_AV_Q(G3(:,:,:,9),wf(:,1),G3(:,:,:,10))
  call check_last_A_Q(l_switch,G3(:,:,:,10),Q(:,63),ZERO,G4tensor(:,7))
  call loop_AV_Q(G1(:,:,:,5),wf(:,-4),G1(:,:,:,8))
  call loop_A_Q(G1(:,:,:,8),Q(:,26),ZERO,G2(:,:,:,13))
  call loop_AV_Q(G2(:,:,:,13),wf(:,-5),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,58),ZERO,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,1),G3(:,:,:,12))
  call check_last_A_Q(l_switch,G3(:,:,:,12),Q(:,63),ZERO,G4tensor(:,8))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,150),G0(:,:,:,4),gZu)
  call loop_A_Q(G0(:,:,:,4),Q(:,10),MT,G1(:,:,:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,11),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,58),MT,G2(:,:,:,15))
  call loop_AV_Q(G2(:,:,:,15),wf(:,1),G2(:,:,:,16))
  call check_last_A_Q(l_switch,G2(:,:,:,16),Q(:,63),MT,G3tensor(:,5))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-5),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,42),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,58),MT,G3(:,:,:,13))
  call loop_AV_Q(G3(:,:,:,13),wf(:,1),G3(:,:,:,14))
  call check_last_A_Q(l_switch,G3(:,:,:,14),Q(:,63),MT,G4tensor(:,9))
  call loop_AV_Q(G1(:,:,:,9),wf(:,-4),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,26),MT,G2(:,:,:,19))
  call loop_AV_Q(G2(:,:,:,19),wf(:,-5),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,58),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,1),G3(:,:,:,16))
  call check_last_A_Q(l_switch,G3(:,:,:,16),Q(:,63),MT,G4tensor(:,10))
  call loop_QZ_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,5),gZu)
  call loop_Q_A(G0(:,:,:,5),Q(:,10),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,11),G1(:,:,:,14))
  call loop_Q_A(G1(:,:,:,14),Q(:,58),ZERO,G2(:,:,:,21))
  call loop_QV_A(G2(:,:,:,21),wf(:,1),G2(:,:,:,22))
  call check_last_Q_A(l_switch,G2(:,:,:,22),Q(:,63),ZERO,G3tensor(:,6))
  call loop_QV_A(G1(:,:,:,13),wf(:,-5),G1(:,:,:,15))
  call loop_Q_A(G1(:,:,:,15),Q(:,42),ZERO,G2(:,:,:,23))
  call loop_QV_A(G2(:,:,:,23),wf(:,-4),G2(:,:,:,24))
  call loop_Q_A(G2(:,:,:,24),Q(:,58),ZERO,G3(:,:,:,17))
  call loop_QV_A(G3(:,:,:,17),wf(:,1),G3(:,:,:,18))
  call check_last_Q_A(l_switch,G3(:,:,:,18),Q(:,63),ZERO,G4tensor(:,11))
  call loop_QV_A(G1(:,:,:,13),wf(:,-4),G1(:,:,:,16))
  call loop_Q_A(G1(:,:,:,16),Q(:,26),ZERO,G2(:,:,:,25))
  call loop_QV_A(G2(:,:,:,25),wf(:,-5),G2(:,:,:,26))
  call loop_Q_A(G2(:,:,:,26),Q(:,58),ZERO,G3(:,:,:,19))
  call loop_QV_A(G3(:,:,:,19),wf(:,1),G3(:,:,:,20))
  call check_last_Q_A(l_switch,G3(:,:,:,20),Q(:,63),ZERO,G4tensor(:,12))
  call loop_QZ_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,6),gZu)
  call loop_Q_A(G0(:,:,:,6),Q(:,10),MT,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,11),G1(:,:,:,18))
  call loop_Q_A(G1(:,:,:,18),Q(:,58),MT,G2(:,:,:,27))
  call loop_QV_A(G2(:,:,:,27),wf(:,1),G2(:,:,:,28))
  call check_last_Q_A(l_switch,G2(:,:,:,28),Q(:,63),MT,G3tensor(:,7))
  call loop_QV_A(G1(:,:,:,17),wf(:,-5),G1(:,:,:,19))
  call loop_Q_A(G1(:,:,:,19),Q(:,42),MT,G2(:,:,:,29))
  call loop_QV_A(G2(:,:,:,29),wf(:,-4),G2(:,:,:,30))
  call loop_Q_A(G2(:,:,:,30),Q(:,58),MT,G3(:,:,:,21))
  call loop_QV_A(G3(:,:,:,21),wf(:,1),G3(:,:,:,22))
  call check_last_Q_A(l_switch,G3(:,:,:,22),Q(:,63),MT,G4tensor(:,13))
  call loop_QV_A(G1(:,:,:,17),wf(:,-4),G1(:,:,:,20))
  call loop_Q_A(G1(:,:,:,20),Q(:,26),MT,G2(:,:,:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,-5),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,58),MT,G3(:,:,:,23))
  call loop_QV_A(G3(:,:,:,23),wf(:,1),G3(:,:,:,24))
  call check_last_Q_A(l_switch,G3(:,:,:,24),Q(:,63),MT,G4tensor(:,14))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,150),G0(:,:,:,7),gZd)
  call loop_A_Q(G0(:,:,:,7),Q(:,10),ZERO,G1(:,:,:,21))
  call loop_AV_Q(G1(:,:,:,21),wf(:,11),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,58),ZERO,G2(:,:,:,33))
  call loop_AV_Q(G2(:,:,:,33),wf(:,1),G2(:,:,:,34))
  call check_last_A_Q(l_switch,G2(:,:,:,34),Q(:,63),ZERO,G3tensor(:,8))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,42),ZERO,G2(:,:,:,35))
  call loop_AV_Q(G2(:,:,:,35),wf(:,-4),G2(:,:,:,36))
  call loop_A_Q(G2(:,:,:,36),Q(:,58),ZERO,G3(:,:,:,25))
  call loop_AV_Q(G3(:,:,:,25),wf(:,1),G3(:,:,:,26))
  call check_last_A_Q(l_switch,G3(:,:,:,26),Q(:,63),ZERO,G4tensor(:,15))
  call loop_AV_Q(G1(:,:,:,21),wf(:,-4),G1(:,:,:,24))
  call loop_A_Q(G1(:,:,:,24),Q(:,26),ZERO,G2(:,:,:,37))
  call loop_AV_Q(G2(:,:,:,37),wf(:,-5),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,58),ZERO,G3(:,:,:,27))
  call loop_AV_Q(G3(:,:,:,27),wf(:,1),G3(:,:,:,28))
  call check_last_A_Q(l_switch,G3(:,:,:,28),Q(:,63),ZERO,G4tensor(:,16))
  call loop_AZ_Q(G0(:,:,:,1),wf(:,150),G0(:,:,:,8),gZd)
  call loop_A_Q(G0(:,:,:,8),Q(:,10),MB,G1(:,:,:,25))
  call loop_AV_Q(G1(:,:,:,25),wf(:,11),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,58),MB,G2(:,:,:,39))
  call loop_AV_Q(G2(:,:,:,39),wf(:,1),G2(:,:,:,40))
  call check_last_A_Q(l_switch,G2(:,:,:,40),Q(:,63),MB,G3tensor(:,9))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-5),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,42),MB,G2(:,:,:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-4),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,58),MB,G3(:,:,:,29))
  call loop_AV_Q(G3(:,:,:,29),wf(:,1),G3(:,:,:,30))
  call check_last_A_Q(l_switch,G3(:,:,:,30),Q(:,63),MB,G4tensor(:,17))
  call loop_AV_Q(G1(:,:,:,25),wf(:,-4),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,26),MB,G2(:,:,:,43))
  call loop_AV_Q(G2(:,:,:,43),wf(:,-5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,58),MB,G3(:,:,:,31))
  call loop_AV_Q(G3(:,:,:,31),wf(:,1),G3(:,:,:,32))
  call check_last_A_Q(l_switch,G3(:,:,:,32),Q(:,63),MB,G4tensor(:,18))
  call loop_QZ_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,9),gZd)
  call loop_Q_A(G0(:,:,:,9),Q(:,10),ZERO,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,11),G1(:,:,:,30))
  call loop_Q_A(G1(:,:,:,30),Q(:,58),ZERO,G2(:,:,:,45))
  call loop_QV_A(G2(:,:,:,45),wf(:,1),G2(:,:,:,46))
  call check_last_Q_A(l_switch,G2(:,:,:,46),Q(:,63),ZERO,G3tensor(:,10))
  call loop_QV_A(G1(:,:,:,29),wf(:,-5),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,42),ZERO,G2(:,:,:,47))
  call loop_QV_A(G2(:,:,:,47),wf(:,-4),G2(:,:,:,48))
  call loop_Q_A(G2(:,:,:,48),Q(:,58),ZERO,G3(:,:,:,33))
  call loop_QV_A(G3(:,:,:,33),wf(:,1),G3(:,:,:,34))
  call check_last_Q_A(l_switch,G3(:,:,:,34),Q(:,63),ZERO,G4tensor(:,19))
  call loop_QV_A(G1(:,:,:,29),wf(:,-4),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,26),ZERO,G2(:,:,:,49))
  call loop_QV_A(G2(:,:,:,49),wf(:,-5),G2(:,:,:,50))
  call loop_Q_A(G2(:,:,:,50),Q(:,58),ZERO,G3(:,:,:,35))
  call loop_QV_A(G3(:,:,:,35),wf(:,1),G3(:,:,:,36))
  call check_last_Q_A(l_switch,G3(:,:,:,36),Q(:,63),ZERO,G4tensor(:,20))
  call loop_QZ_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,10),gZd)
  call loop_Q_A(G0(:,:,:,10),Q(:,10),MB,G1(:,:,:,33))
  call loop_QV_A(G1(:,:,:,33),wf(:,11),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,58),MB,G2(:,:,:,51))
  call loop_QV_A(G2(:,:,:,51),wf(:,1),G2(:,:,:,52))
  call check_last_Q_A(l_switch,G2(:,:,:,52),Q(:,63),MB,G3tensor(:,11))
  call loop_QV_A(G1(:,:,:,33),wf(:,-5),G1(:,:,:,35))
  call loop_Q_A(G1(:,:,:,35),Q(:,42),MB,G2(:,:,:,53))
  call loop_QV_A(G2(:,:,:,53),wf(:,-4),G2(:,:,:,54))
  call loop_Q_A(G2(:,:,:,54),Q(:,58),MB,G3(:,:,:,37))
  call loop_QV_A(G3(:,:,:,37),wf(:,1),G3(:,:,:,38))
  call check_last_Q_A(l_switch,G3(:,:,:,38),Q(:,63),MB,G4tensor(:,21))
  call loop_QV_A(G1(:,:,:,33),wf(:,-4),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,26),MB,G2(:,:,:,55))
  call loop_QV_A(G2(:,:,:,55),wf(:,-5),G2(:,:,:,56))
  call loop_Q_A(G2(:,:,:,56),Q(:,58),MB,G3(:,:,:,39))
  call loop_QV_A(G3(:,:,:,39),wf(:,1),G3(:,:,:,40))
  call check_last_Q_A(l_switch,G3(:,:,:,40),Q(:,63),MB,G4tensor(:,22))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,2),G1(:,:,:,37))
  call loop_DV_C(G1(:,:,:,37),Q(:,10),wf(:,11),G2(:,:,:,57))
  call check_last_DV_C(l_switch,G2(:,:,:,57),Q(:,58),wf(:,1),G3tensor(:,12))
  call loop_DV_C(G1(:,:,:,37),Q(:,10),wf(:,-5),G2(:,:,:,58))
  call loop_DV_C(G2(:,:,:,58),Q(:,42),wf(:,-4),G3(:,:,:,41))
  call check_last_DV_C(l_switch,G3(:,:,:,41),Q(:,58),wf(:,1),G4tensor(:,23))
  call loop_DV_C(G1(:,:,:,37),Q(:,10),wf(:,-4),G2(:,:,:,59))
  call loop_DV_C(G2(:,:,:,59),Q(:,26),wf(:,-5),G3(:,:,:,42))
  call check_last_DV_C(l_switch,G3(:,:,:,42),Q(:,58),wf(:,1),G4tensor(:,24))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,38))
  call loop_CV_D(G1(:,:,:,38),Q(:,10),wf(:,11),Q(:,48),G2(:,:,:,60))
  call check_last_CV_D(l_switch,G2(:,:,:,60),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,13))
  call loop_CV_D(G1(:,:,:,38),Q(:,10),wf(:,-5),Q(:,32),G2(:,:,:,61))
  call loop_CV_D(G2(:,:,:,61),Q(:,42),wf(:,-4),Q(:,16),G3(:,:,:,43))
  call check_last_CV_D(l_switch,G3(:,:,:,43),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,25))
  call loop_CV_D(G1(:,:,:,38),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,62))
  call loop_CV_D(G2(:,:,:,62),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,44))
  call check_last_CV_D(l_switch,G3(:,:,:,44),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,26))
  call loop_AV_Q(G0(:,:,:,1),wf(:,13),G0(:,:,:,11))
  call loop_A_Q(G0(:,:,:,11),Q(:,21),MT,G1(:,:,:,39))
  call loop_AV_Q(G1(:,:,:,39),wf(:,-5),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,53),MT,G2(:,:,:,63))
  call loop_AS_Q(G2(:,:,:,63),wf(:,145),G2(:,:,:,64),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,64),Q(:,63),MT,G3tensor(:,14))
  call loop_AS_Q(G2(:,:,:,63),wf(:,147),G2(:,:,:,65),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,65),Q(:,63),MT,G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,63),wf(:,2),G2(:,:,:,66))
  call check_last_A_Q(l_switch,G2(:,:,:,66),Q(:,63),MT,G3tensor(:,16))
  call loop_AZ_Q(G2(:,:,:,63),wf(:,150),G2(:,:,:,67),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,67),Q(:,63),MT,G3tensor(:,17))
  call loop_AQ_S(G1(:,:,:,39),wf(:,40),G1(:,:,:,41),gH)
  call loop_SA_Q(G1(:,:,:,41),wf(:,-3),G1(:,:,:,42),gH)
  call check_last_A_Q(l_switch,G1(:,:,:,42),Q(:,63),MT,G2tensor(:,1))
  call loop_AQ_S(G1(:,:,:,39),wf(:,40),G1(:,:,:,43),gX)
  call loop_SA_Q(G1(:,:,:,43),wf(:,-3),G1(:,:,:,44),gX)
  call check_last_A_Q(l_switch,G1(:,:,:,44),Q(:,63),MT,G2tensor(:,2))
  call loop_AQ_Z(G1(:,:,:,39),wf(:,40),G1(:,:,:,45),gZu)
  call loop_ZA_Q(G1(:,:,:,45),wf(:,-3),G1(:,:,:,46),gZu)
  call check_last_A_Q(l_switch,G1(:,:,:,46),Q(:,63),MT,G2tensor(:,3))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,21),MT,G1(:,:,:,47))
  call loop_QV_A(G1(:,:,:,47),wf(:,-5),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,53),MT,G2(:,:,:,68))
  call loop_QS_A(G2(:,:,:,68),wf(:,145),G2(:,:,:,69),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,69),Q(:,63),MT,G3tensor(:,18))
  call loop_QS_A(G2(:,:,:,68),wf(:,147),G2(:,:,:,70),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,70),Q(:,63),MT,G3tensor(:,19))
  call loop_QV_A(G2(:,:,:,68),wf(:,2),G2(:,:,:,71))
  call check_last_Q_A(l_switch,G2(:,:,:,71),Q(:,63),MT,G3tensor(:,20))
  call loop_QZ_A(G2(:,:,:,68),wf(:,150),G2(:,:,:,72),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,72),Q(:,63),MT,G3tensor(:,21))
  call loop_QA_S(G1(:,:,:,47),wf(:,21),G1(:,:,:,49),gH)
  call loop_SQ_A(G1(:,:,:,49),wf(:,-1),G1(:,:,:,50),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),MT,G2tensor(:,4))
  call loop_QA_S(G1(:,:,:,47),wf(:,21),G1(:,:,:,51),gX)
  call loop_SQ_A(G1(:,:,:,51),wf(:,-1),G1(:,:,:,52),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),MT,G2tensor(:,5))
  call loop_QA_Z(G1(:,:,:,47),wf(:,21),G1(:,:,:,53),gZu)
  call loop_ZQ_A(G1(:,:,:,53),wf(:,-1),G1(:,:,:,54),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),MT,G2tensor(:,6))
  call loop_AV_Q(G0(:,:,:,1),wf(:,13),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,21),MB,G1(:,:,:,55))
  call loop_AV_Q(G1(:,:,:,55),wf(:,-5),G1(:,:,:,56))
  call loop_A_Q(G1(:,:,:,56),Q(:,53),MB,G2(:,:,:,73))
  call loop_AS_Q(G2(:,:,:,73),wf(:,145),G2(:,:,:,74),gH)
  call check_last_A_Q(l_switch,G2(:,:,:,74),Q(:,63),MB,G3tensor(:,22))
  call loop_AS_Q(G2(:,:,:,73),wf(:,147),G2(:,:,:,75),gX)
  call check_last_A_Q(l_switch,G2(:,:,:,75),Q(:,63),MB,G3tensor(:,23))
  call loop_AV_Q(G2(:,:,:,73),wf(:,2),G2(:,:,:,76))
  call check_last_A_Q(l_switch,G2(:,:,:,76),Q(:,63),MB,G3tensor(:,24))
  call loop_AZ_Q(G2(:,:,:,73),wf(:,150),G2(:,:,:,77),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,77),Q(:,63),MB,G3tensor(:,25))
  call loop_AQ_S(G1(:,:,:,55),wf(:,40),G1(:,:,:,57),gPbt)
  call loop_SA_Q(G1(:,:,:,57),wf(:,-3),G1(:,:,:,58),gPtb)
  call check_last_A_Q(l_switch,G1(:,:,:,58),Q(:,63),MB,G2tensor(:,7))
  call loop_AQ_W(G1(:,:,:,55),wf(:,40),G1(:,:,:,59))
  call loop_WA_Q(G1(:,:,:,59),wf(:,-3),G1(:,:,:,60))
  call check_last_A_Q(l_switch,G1(:,:,:,60),Q(:,63),MB,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,21),MB,G1(:,:,:,61))
  call loop_QV_A(G1(:,:,:,61),wf(:,-5),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,53),MB,G2(:,:,:,78))
  call loop_QS_A(G2(:,:,:,78),wf(:,145),G2(:,:,:,79),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,79),Q(:,63),MB,G3tensor(:,26))
  call loop_QS_A(G2(:,:,:,78),wf(:,147),G2(:,:,:,80),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,80),Q(:,63),MB,G3tensor(:,27))
  call loop_QV_A(G2(:,:,:,78),wf(:,2),G2(:,:,:,81))
  call check_last_Q_A(l_switch,G2(:,:,:,81),Q(:,63),MB,G3tensor(:,28))
  call loop_QZ_A(G2(:,:,:,78),wf(:,150),G2(:,:,:,82),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,82),Q(:,63),MB,G3tensor(:,29))
  call loop_QA_S(G1(:,:,:,61),wf(:,21),G1(:,:,:,63),gPtb)
  call loop_SQ_A(G1(:,:,:,63),wf(:,-1),G1(:,:,:,64),gPbt)
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,63),MB,G2tensor(:,9))
  call loop_QA_W(G1(:,:,:,61),wf(:,21),G1(:,:,:,65))
  call loop_WQ_A(G1(:,:,:,65),wf(:,-1),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),MB,G2tensor(:,10))
  call loop_AV_Q(G0(:,:,:,1),wf(:,13),G0(:,:,:,15))
  call loop_A_Q(G0(:,:,:,15),Q(:,21),ZERO,G1(:,:,:,67))
  call loop_AV_Q(G1(:,:,:,67),wf(:,-5),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,53),ZERO,G2(:,:,:,83))
  call loop_AV_Q(G2(:,:,:,83),wf(:,2),G2(:,:,:,84))
  call check_last_A_Q(l_switch,G2(:,:,:,84),Q(:,63),ZERO,G3tensor(:,30))
  call loop_AZ_Q(G2(:,:,:,83),wf(:,150),G2(:,:,:,85),gZu)
  call check_last_A_Q(l_switch,G2(:,:,:,85),Q(:,63),ZERO,G3tensor(:,31))
  call loop_AZ_Q(G2(:,:,:,83),wf(:,150),G2(:,:,:,86),gZd)
  call check_last_A_Q(l_switch,G2(:,:,:,86),Q(:,63),ZERO,G3tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,13),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,21),ZERO,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,-5),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,53),ZERO,G2(:,:,:,87))
  call loop_QV_A(G2(:,:,:,87),wf(:,2),G2(:,:,:,88))
  call check_last_Q_A(l_switch,G2(:,:,:,88),Q(:,63),ZERO,G3tensor(:,33))
  call loop_QZ_A(G2(:,:,:,87),wf(:,150),G2(:,:,:,89),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,89),Q(:,63),ZERO,G3tensor(:,34))
  call loop_QZ_A(G2(:,:,:,87),wf(:,150),G2(:,:,:,90),gZd)
  call check_last_Q_A(l_switch,G2(:,:,:,90),Q(:,63),ZERO,G3tensor(:,35))
  call loop_DV_C(G0(:,:,:,1),Q(:,0),wf(:,13),G1(:,:,:,71))
  call loop_DV_C(G1(:,:,:,71),Q(:,21),wf(:,-5),G2(:,:,:,91))
  call check_last_DV_C(l_switch,G2(:,:,:,91),Q(:,53),wf(:,2),G3tensor(:,36))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,21),G1(:,:,:,72))
  call loop_CV_D(G1(:,:,:,72),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,92))
  call check_last_CV_D(l_switch,G2(:,:,:,92),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,37))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,13),Q(:,21),G1(:,:,:,73))
  call loop_UV_W(G1(:,:,:,73),Q(:,21),wf(:,-5),Q(:,32),G2(:,:,:,93))
  call check_last_UV_W(l_switch,G2(:,:,:,93),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,38))
  call loop_VA_Q(G2(:,:,:,93),wf(:,-3),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,61),MT,G3(:,:,:,45))
  call check_last_AQ_V(l_switch,G3(:,:,:,45),wf(:,-1),G3tensor(:,39))
  call loop_VQ_A(G1(:,:,:,73),wf(:,40),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,55),MT,G2(:,:,:,95))
  call check_last_QA_V(l_switch,G2(:,:,:,95),wf(:,-3),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,73),wf(:,21),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,61),MT,G2(:,:,:,96))
  call check_last_AQ_V(l_switch,G2(:,:,:,96),wf(:,-1),G2tensor(:,12))
  call loop_VA_Q(G1(:,:,:,73),wf(:,-3),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,29),MT,G2(:,:,:,97))
  call loop_AV_Q(G2(:,:,:,97),wf(:,-5),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,61),MT,G3(:,:,:,46))
  call check_last_AQ_V(l_switch,G3(:,:,:,46),wf(:,-1),G3tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,-4),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,16),MT,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,16),G1(:,:,:,78))
  call loop_Q_A(G1(:,:,:,78),Q(:,53),MT,G2(:,:,:,99))
  call loop_QS_A(G2(:,:,:,99),wf(:,145),G2(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,100),Q(:,63),MT,G3tensor(:,41))
  call loop_QS_A(G2(:,:,:,99),wf(:,147),G2(:,:,:,101),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,101),Q(:,63),MT,G3tensor(:,42))
  call loop_QV_A(G2(:,:,:,99),wf(:,2),G2(:,:,:,102))
  call check_last_Q_A(l_switch,G2(:,:,:,102),Q(:,63),MT,G3tensor(:,43))
  call loop_QZ_A(G2(:,:,:,99),wf(:,150),G2(:,:,:,103),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,103),Q(:,63),MT,G3tensor(:,44))
  call loop_QV_A(G1(:,:,:,77),wf(:,14),G1(:,:,:,79))
  call loop_Q_A(G1(:,:,:,79),Q(:,58),MT,G2(:,:,:,104))
  call loop_QS_A(G2(:,:,:,104),wf(:,17),G2(:,:,:,105),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,105),Q(:,63),MT,G3tensor(:,45))
  call loop_QS_A(G2(:,:,:,104),wf(:,23),G2(:,:,:,106),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,106),Q(:,63),MT,G3tensor(:,46))
  call loop_QV_A(G2(:,:,:,104),wf(:,1),G2(:,:,:,107))
  call check_last_Q_A(l_switch,G2(:,:,:,107),Q(:,63),MT,G3tensor(:,47))
  call loop_QZ_A(G2(:,:,:,104),wf(:,26),G2(:,:,:,108),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,108),Q(:,63),MT,G3tensor(:,48))
  call loop_QV_A(G1(:,:,:,77),wf(:,-5),G1(:,:,:,80))
  call loop_Q_A(G1(:,:,:,80),Q(:,48),MT,G2(:,:,:,109))
  call loop_QV_A(G2(:,:,:,109),wf(:,12),G2(:,:,:,110))
  call check_last_Q_A(l_switch,G2(:,:,:,110),Q(:,63),MT,G3tensor(:,49))
  call loop_QV_A(G2(:,:,:,109),wf(:,1186),G2(:,:,:,111))
  call check_last_Q_A(l_switch,G2(:,:,:,111),Q(:,63),MT,G3tensor(:,50))
  call loop_QV_A(G2(:,:,:,109),wf(:,1187),G2(:,:,:,112))
  call check_last_Q_A(l_switch,G2(:,:,:,112),Q(:,63),MT,G3tensor(:,51))
  call loop_QS_A(G2(:,:,:,109),wf(:,1188),G2(:,:,:,113),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,113),Q(:,63),MT,G3tensor(:,52))
  call loop_QS_A(G2(:,:,:,109),wf(:,1189),G2(:,:,:,114),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,114),Q(:,63),MT,G3tensor(:,53))
  call loop_QV_A(G2(:,:,:,109),wf(:,1190),G2(:,:,:,115))
  call check_last_Q_A(l_switch,G2(:,:,:,115),Q(:,63),MT,G3tensor(:,54))
  call loop_QV_A(G2(:,:,:,109),wf(:,1191),G2(:,:,:,116))
  call check_last_Q_A(l_switch,G2(:,:,:,116),Q(:,63),MT,G3tensor(:,55))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1192),G2(:,:,:,117),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,117),Q(:,63),MT,G3tensor(:,56))
  call loop_QV_A(G2(:,:,:,109),wf(:,1209),G2(:,:,:,118))
  call check_last_Q_A(l_switch,G2(:,:,:,118),Q(:,63),MT,G3tensor(:,57))
  call loop_QV_A(G2(:,:,:,109),wf(:,1210),G2(:,:,:,119))
  call check_last_Q_A(l_switch,G2(:,:,:,119),Q(:,63),MT,G3tensor(:,58))
  call loop_QS_A(G2(:,:,:,109),wf(:,1211),G2(:,:,:,120),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,120),Q(:,63),MT,G3tensor(:,59))
  call loop_QS_A(G2(:,:,:,109),wf(:,1212),G2(:,:,:,121),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,121),Q(:,63),MT,G3tensor(:,60))
  call loop_QV_A(G2(:,:,:,109),wf(:,1213),G2(:,:,:,122))
  call check_last_Q_A(l_switch,G2(:,:,:,122),Q(:,63),MT,G3tensor(:,61))
  call loop_QV_A(G2(:,:,:,109),wf(:,1214),G2(:,:,:,123))
  call check_last_Q_A(l_switch,G2(:,:,:,123),Q(:,63),MT,G3tensor(:,62))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1215),G2(:,:,:,124),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,124),Q(:,63),MT,G3tensor(:,63))
  call loop_QV_A(G2(:,:,:,109),wf(:,63),G2(:,:,:,125))
  call check_last_Q_A(l_switch,G2(:,:,:,125),Q(:,63),MT,G3tensor(:,64))
  call loop_QV_A(G2(:,:,:,109),wf(:,1242),G2(:,:,:,126))
  call check_last_Q_A(l_switch,G2(:,:,:,126),Q(:,63),MT,G3tensor(:,65))
  call loop_QV_A(G2(:,:,:,109),wf(:,1243),G2(:,:,:,127))
  call check_last_Q_A(l_switch,G2(:,:,:,127),Q(:,63),MT,G3tensor(:,66))
  call loop_QS_A(G2(:,:,:,109),wf(:,1244),G2(:,:,:,128),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,128),Q(:,63),MT,G3tensor(:,67))
  call loop_QS_A(G2(:,:,:,109),wf(:,1245),G2(:,:,:,129),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,129),Q(:,63),MT,G3tensor(:,68))
  call loop_QV_A(G2(:,:,:,109),wf(:,1246),G2(:,:,:,130))
  call check_last_Q_A(l_switch,G2(:,:,:,130),Q(:,63),MT,G3tensor(:,69))
  call loop_QV_A(G2(:,:,:,109),wf(:,1247),G2(:,:,:,131))
  call check_last_Q_A(l_switch,G2(:,:,:,131),Q(:,63),MT,G3tensor(:,70))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1248),G2(:,:,:,132),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,132),Q(:,63),MT,G3tensor(:,71))
  call loop_QS_A(G2(:,:,:,109),wf(:,1265),G2(:,:,:,133),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,133),Q(:,63),MT,G3tensor(:,72))
  call loop_QS_A(G2(:,:,:,109),wf(:,1266),G2(:,:,:,134),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,134),Q(:,63),MT,G3tensor(:,73))
  call loop_QV_A(G2(:,:,:,109),wf(:,1267),G2(:,:,:,135))
  call check_last_Q_A(l_switch,G2(:,:,:,135),Q(:,63),MT,G3tensor(:,74))
  call loop_QV_A(G2(:,:,:,109),wf(:,1268),G2(:,:,:,136))
  call check_last_Q_A(l_switch,G2(:,:,:,136),Q(:,63),MT,G3tensor(:,75))
  call loop_QV_A(G2(:,:,:,109),wf(:,1269),G2(:,:,:,137))
  call check_last_Q_A(l_switch,G2(:,:,:,137),Q(:,63),MT,G3tensor(:,76))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1270),G2(:,:,:,138),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,138),Q(:,63),MT,G3tensor(:,77))
  call loop_QV_A(G2(:,:,:,109),wf(:,1271),G2(:,:,:,139))
  call check_last_Q_A(l_switch,G2(:,:,:,139),Q(:,63),MT,G3tensor(:,78))
  call loop_QV_A(G2(:,:,:,109),wf(:,1298),G2(:,:,:,140))
  call check_last_Q_A(l_switch,G2(:,:,:,140),Q(:,63),MT,G3tensor(:,79))
  call loop_QV_A(G2(:,:,:,109),wf(:,1299),G2(:,:,:,141))
  call check_last_Q_A(l_switch,G2(:,:,:,141),Q(:,63),MT,G3tensor(:,80))
  call loop_QS_A(G2(:,:,:,109),wf(:,1300),G2(:,:,:,142),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,142),Q(:,63),MT,G3tensor(:,81))
  call loop_QS_A(G2(:,:,:,109),wf(:,1301),G2(:,:,:,143),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,143),Q(:,63),MT,G3tensor(:,82))
  call loop_QV_A(G2(:,:,:,109),wf(:,1302),G2(:,:,:,144))
  call check_last_Q_A(l_switch,G2(:,:,:,144),Q(:,63),MT,G3tensor(:,83))
  call loop_QV_A(G2(:,:,:,109),wf(:,1303),G2(:,:,:,145))
  call check_last_Q_A(l_switch,G2(:,:,:,145),Q(:,63),MT,G3tensor(:,84))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1304),G2(:,:,:,146),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,146),Q(:,63),MT,G3tensor(:,85))
  call loop_QV_A(G2(:,:,:,109),wf(:,1321),G2(:,:,:,147))
  call check_last_Q_A(l_switch,G2(:,:,:,147),Q(:,63),MT,G3tensor(:,86))
  call loop_QV_A(G2(:,:,:,109),wf(:,1322),G2(:,:,:,148))
  call check_last_Q_A(l_switch,G2(:,:,:,148),Q(:,63),MT,G3tensor(:,87))
  call loop_QS_A(G2(:,:,:,109),wf(:,1323),G2(:,:,:,149),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,149),Q(:,63),MT,G3tensor(:,88))
  call loop_QS_A(G2(:,:,:,109),wf(:,1324),G2(:,:,:,150),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,150),Q(:,63),MT,G3tensor(:,89))
  call loop_QV_A(G2(:,:,:,109),wf(:,1325),G2(:,:,:,151))
  call check_last_Q_A(l_switch,G2(:,:,:,151),Q(:,63),MT,G3tensor(:,90))
  call loop_QV_A(G2(:,:,:,109),wf(:,1326),G2(:,:,:,152))
  call check_last_Q_A(l_switch,G2(:,:,:,152),Q(:,63),MT,G3tensor(:,91))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1327),G2(:,:,:,153),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,153),Q(:,63),MT,G3tensor(:,92))
  call loop_QV_A(G2(:,:,:,109),wf(:,1354),G2(:,:,:,154))
  call check_last_Q_A(l_switch,G2(:,:,:,154),Q(:,63),MT,G3tensor(:,93))
  call loop_QV_A(G2(:,:,:,109),wf(:,1355),G2(:,:,:,155))
  call check_last_Q_A(l_switch,G2(:,:,:,155),Q(:,63),MT,G3tensor(:,94))
  call loop_QS_A(G2(:,:,:,109),wf(:,1356),G2(:,:,:,156),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,156),Q(:,63),MT,G3tensor(:,95))
  call loop_QS_A(G2(:,:,:,109),wf(:,1357),G2(:,:,:,157),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,157),Q(:,63),MT,G3tensor(:,96))
  call loop_QV_A(G2(:,:,:,109),wf(:,1358),G2(:,:,:,158))
  call check_last_Q_A(l_switch,G2(:,:,:,158),Q(:,63),MT,G3tensor(:,97))
  call loop_QV_A(G2(:,:,:,109),wf(:,1359),G2(:,:,:,159))
  call check_last_Q_A(l_switch,G2(:,:,:,159),Q(:,63),MT,G3tensor(:,98))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1360),G2(:,:,:,160),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,160),Q(:,63),MT,G3tensor(:,99))
  call loop_QS_A(G2(:,:,:,109),wf(:,1377),G2(:,:,:,161),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,161),Q(:,63),MT,G3tensor(:,100))
  call loop_QS_A(G2(:,:,:,109),wf(:,1378),G2(:,:,:,162),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,162),Q(:,63),MT,G3tensor(:,101))
  call loop_QV_A(G2(:,:,:,109),wf(:,1379),G2(:,:,:,163))
  call check_last_Q_A(l_switch,G2(:,:,:,163),Q(:,63),MT,G3tensor(:,102))
  call loop_QV_A(G2(:,:,:,109),wf(:,1380),G2(:,:,:,164))
  call check_last_Q_A(l_switch,G2(:,:,:,164),Q(:,63),MT,G3tensor(:,103))
  call loop_QV_A(G2(:,:,:,109),wf(:,1381),G2(:,:,:,165))
  call check_last_Q_A(l_switch,G2(:,:,:,165),Q(:,63),MT,G3tensor(:,104))
  call loop_QZ_A(G2(:,:,:,109),wf(:,1382),G2(:,:,:,166),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,166),Q(:,63),MT,G3tensor(:,105))
  call loop_QV_A(G2(:,:,:,109),wf(:,1383),G2(:,:,:,167))
  call check_last_Q_A(l_switch,G2(:,:,:,167),Q(:,63),MT,G3tensor(:,106))
  call loop_QV_A(G1(:,:,:,77),wf(:,2),G1(:,:,:,81))
  call loop_Q_A(G1(:,:,:,81),Q(:,26),MT,G2(:,:,:,168))
  call loop_QV_A(G2(:,:,:,168),wf(:,-5),G2(:,:,:,169))
  call loop_Q_A(G2(:,:,:,169),Q(:,58),MT,G3(:,:,:,47))
  call loop_QS_A(G3(:,:,:,47),wf(:,17),G3(:,:,:,48),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,48),Q(:,63),MT,G4tensor(:,27))
  call loop_QS_A(G3(:,:,:,47),wf(:,23),G3(:,:,:,49),gX)
  call check_last_Q_A(l_switch,G3(:,:,:,49),Q(:,63),MT,G4tensor(:,28))
  call loop_QV_A(G3(:,:,:,47),wf(:,1),G3(:,:,:,50))
  call check_last_Q_A(l_switch,G3(:,:,:,50),Q(:,63),MT,G4tensor(:,29))
  call loop_QZ_A(G3(:,:,:,47),wf(:,26),G3(:,:,:,51),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,51),Q(:,63),MT,G4tensor(:,30))
  call loop_QA_S(G2(:,:,:,168),wf(:,109),G2(:,:,:,170),gH)
  call loop_SQ_A(G2(:,:,:,170),wf(:,0),G2(:,:,:,171),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,171),Q(:,63),MT,G3tensor(:,107))
  call loop_QA_S(G2(:,:,:,168),wf(:,109),G2(:,:,:,172),gX)
  call loop_SQ_A(G2(:,:,:,172),wf(:,0),G2(:,:,:,173),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,173),Q(:,63),MT,G3tensor(:,108))
  call loop_QA_Z(G2(:,:,:,168),wf(:,109),G2(:,:,:,174),gZu)
  call loop_ZQ_A(G2(:,:,:,174),wf(:,0),G2(:,:,:,175),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,175),Q(:,63),MT,G3tensor(:,109))
  call loop_QS_A(G1(:,:,:,77),wf(:,145),G1(:,:,:,82),gH)
  call loop_Q_A(G1(:,:,:,82),Q(:,26),MT,G2(:,:,:,176))
  call loop_QV_A(G2(:,:,:,176),wf(:,-5),G2(:,:,:,177))
  call loop_Q_A(G2(:,:,:,177),Q(:,58),MT,G3(:,:,:,52))
  call loop_QV_A(G3(:,:,:,52),wf(:,1),G3(:,:,:,53))
  call check_last_Q_A(l_switch,G3(:,:,:,53),Q(:,63),MT,G4tensor(:,31))
  call loop_QS_A(G1(:,:,:,77),wf(:,147),G1(:,:,:,83),gX)
  call loop_Q_A(G1(:,:,:,83),Q(:,26),MT,G2(:,:,:,178))
  call loop_QV_A(G2(:,:,:,178),wf(:,-5),G2(:,:,:,179))
  call loop_Q_A(G2(:,:,:,179),Q(:,58),MT,G3(:,:,:,54))
  call loop_QV_A(G3(:,:,:,54),wf(:,1),G3(:,:,:,55))
  call check_last_Q_A(l_switch,G3(:,:,:,55),Q(:,63),MT,G4tensor(:,32))
  call loop_QZ_A(G1(:,:,:,77),wf(:,150),G1(:,:,:,84),gZu)
  call loop_Q_A(G1(:,:,:,84),Q(:,26),MT,G2(:,:,:,180))
  call loop_QV_A(G2(:,:,:,180),wf(:,-5),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,58),MT,G3(:,:,:,56))
  call loop_QV_A(G3(:,:,:,56),wf(:,1),G3(:,:,:,57))
  call check_last_Q_A(l_switch,G3(:,:,:,57),Q(:,63),MT,G4tensor(:,33))
  call loop_QV_A(G1(:,:,:,77),wf(:,57),G1(:,:,:,85))
  call loop_Q_A(G1(:,:,:,85),Q(:,58),MT,G2(:,:,:,182))
  call loop_QS_A(G2(:,:,:,182),wf(:,17),G2(:,:,:,183),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,183),Q(:,63),MT,G3tensor(:,110))
  call loop_QS_A(G2(:,:,:,182),wf(:,23),G2(:,:,:,184),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,184),Q(:,63),MT,G3tensor(:,111))
  call loop_QV_A(G2(:,:,:,182),wf(:,1),G2(:,:,:,185))
  call check_last_Q_A(l_switch,G2(:,:,:,185),Q(:,63),MT,G3tensor(:,112))
  call loop_QZ_A(G2(:,:,:,182),wf(:,26),G2(:,:,:,186),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,186),Q(:,63),MT,G3tensor(:,113))
  call loop_QS_A(G1(:,:,:,77),wf(:,177),G1(:,:,:,86),gH)
  call loop_Q_A(G1(:,:,:,86),Q(:,58),MT,G2(:,:,:,187))
  call loop_QV_A(G2(:,:,:,187),wf(:,1),G2(:,:,:,188))
  call check_last_Q_A(l_switch,G2(:,:,:,188),Q(:,63),MT,G3tensor(:,114))
  call loop_QS_A(G1(:,:,:,77),wf(:,179),G1(:,:,:,87),gX)
  call loop_Q_A(G1(:,:,:,87),Q(:,58),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,1),G2(:,:,:,190))
  call check_last_Q_A(l_switch,G2(:,:,:,190),Q(:,63),MT,G3tensor(:,115))
  call loop_QZ_A(G1(:,:,:,77),wf(:,181),G1(:,:,:,88),gZu)
  call loop_Q_A(G1(:,:,:,88),Q(:,58),MT,G2(:,:,:,191))
  call loop_QV_A(G2(:,:,:,191),wf(:,1),G2(:,:,:,192))
  call check_last_Q_A(l_switch,G2(:,:,:,192),Q(:,63),MT,G3tensor(:,116))
  call loop_QA_S(G1(:,:,:,77),wf(:,-3),G1(:,:,:,89),gH)
  call loop_SQ_A(G1(:,:,:,89),wf(:,40),G1(:,:,:,90),gH)
  call loop_Q_A(G1(:,:,:,90),Q(:,58),MT,G2(:,:,:,193))
  call loop_QV_A(G2(:,:,:,193),wf(:,1),G2(:,:,:,194))
  call check_last_Q_A(l_switch,G2(:,:,:,194),Q(:,63),MT,G3tensor(:,117))
  call loop_SQ_A(G1(:,:,:,89),wf(:,88),G1(:,:,:,91),gH)
  call loop_Q_A(G1(:,:,:,91),Q(:,57),MT,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,7),G2(:,:,:,196))
  call check_last_Q_A(l_switch,G2(:,:,:,196),Q(:,63),MT,G3tensor(:,118))
  call loop_QA_S(G1(:,:,:,77),wf(:,-3),G1(:,:,:,92),gX)
  call loop_SQ_A(G1(:,:,:,92),wf(:,40),G1(:,:,:,93),gX)
  call loop_Q_A(G1(:,:,:,93),Q(:,58),MT,G2(:,:,:,197))
  call loop_QV_A(G2(:,:,:,197),wf(:,1),G2(:,:,:,198))
  call check_last_Q_A(l_switch,G2(:,:,:,198),Q(:,63),MT,G3tensor(:,119))
  call loop_SQ_A(G1(:,:,:,92),wf(:,88),G1(:,:,:,94),gX)
  call loop_Q_A(G1(:,:,:,94),Q(:,57),MT,G2(:,:,:,199))
  call loop_QV_A(G2(:,:,:,199),wf(:,7),G2(:,:,:,200))
  call check_last_Q_A(l_switch,G2(:,:,:,200),Q(:,63),MT,G3tensor(:,120))
  call loop_QA_Z(G1(:,:,:,77),wf(:,-3),G1(:,:,:,95),gZu)
  call loop_ZQ_A(G1(:,:,:,95),wf(:,40),G1(:,:,:,96),gZu)
  call loop_Q_A(G1(:,:,:,96),Q(:,58),MT,G2(:,:,:,201))
  call loop_QV_A(G2(:,:,:,201),wf(:,1),G2(:,:,:,202))
  call check_last_Q_A(l_switch,G2(:,:,:,202),Q(:,63),MT,G3tensor(:,121))
  call loop_ZQ_A(G1(:,:,:,95),wf(:,88),G1(:,:,:,97),gZu)
  call loop_Q_A(G1(:,:,:,97),Q(:,57),MT,G2(:,:,:,203))
  call loop_QV_A(G2(:,:,:,203),wf(:,7),G2(:,:,:,204))
  call check_last_Q_A(l_switch,G2(:,:,:,204),Q(:,63),MT,G3tensor(:,122))
  call loop_QA_S(G1(:,:,:,77),wf(:,21),G1(:,:,:,98),gH)
  call loop_SQ_A(G1(:,:,:,98),wf(:,52),G1(:,:,:,99),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,99),Q(:,63),MT,G2tensor(:,13))
  call loop_SQ_A(G1(:,:,:,98),wf(:,98),G1(:,:,:,100),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),MT,G2tensor(:,14))
  call loop_QA_S(G1(:,:,:,77),wf(:,21),G1(:,:,:,101),gX)
  call loop_SQ_A(G1(:,:,:,101),wf(:,52),G1(:,:,:,102),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),MT,G2tensor(:,15))
  call loop_SQ_A(G1(:,:,:,101),wf(:,98),G1(:,:,:,103),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,63),MT,G2tensor(:,16))
  call loop_QA_Z(G1(:,:,:,77),wf(:,21),G1(:,:,:,104),gZu)
  call loop_ZQ_A(G1(:,:,:,104),wf(:,52),G1(:,:,:,105),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,63),MT,G2tensor(:,17))
  call loop_ZQ_A(G1(:,:,:,104),wf(:,98),G1(:,:,:,106),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),MT,G2tensor(:,18))
  call loop_QV_A(G1(:,:,:,77),wf(:,59),G1(:,:,:,107))
  call loop_Q_A(G1(:,:,:,107),Q(:,58),MT,G2(:,:,:,205))
  call loop_QS_A(G2(:,:,:,205),wf(:,17),G2(:,:,:,206),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,206),Q(:,63),MT,G3tensor(:,123))
  call loop_QS_A(G2(:,:,:,205),wf(:,23),G2(:,:,:,207),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,207),Q(:,63),MT,G3tensor(:,124))
  call loop_QV_A(G2(:,:,:,205),wf(:,1),G2(:,:,:,208))
  call check_last_Q_A(l_switch,G2(:,:,:,208),Q(:,63),MT,G3tensor(:,125))
  call loop_QZ_A(G2(:,:,:,205),wf(:,26),G2(:,:,:,209),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,209),Q(:,63),MT,G3tensor(:,126))
  call loop_QS_A(G1(:,:,:,77),wf(:,191),G1(:,:,:,108),gH)
  call loop_Q_A(G1(:,:,:,108),Q(:,58),MT,G2(:,:,:,210))
  call loop_QV_A(G2(:,:,:,210),wf(:,1),G2(:,:,:,211))
  call check_last_Q_A(l_switch,G2(:,:,:,211),Q(:,63),MT,G3tensor(:,127))
  call loop_QS_A(G1(:,:,:,77),wf(:,192),G1(:,:,:,109),gX)
  call loop_Q_A(G1(:,:,:,109),Q(:,58),MT,G2(:,:,:,212))
  call loop_QV_A(G2(:,:,:,212),wf(:,1),G2(:,:,:,213))
  call check_last_Q_A(l_switch,G2(:,:,:,213),Q(:,63),MT,G3tensor(:,128))
  call loop_QZ_A(G1(:,:,:,77),wf(:,193),G1(:,:,:,110),gZu)
  call loop_Q_A(G1(:,:,:,110),Q(:,58),MT,G2(:,:,:,214))
  call loop_QV_A(G2(:,:,:,214),wf(:,1),G2(:,:,:,215))
  call check_last_Q_A(l_switch,G2(:,:,:,215),Q(:,63),MT,G3tensor(:,129))
  call loop_QA_S(G1(:,:,:,77),wf(:,881),G1(:,:,:,111),gH)
  call loop_SQ_A(G1(:,:,:,111),wf(:,-1),G1(:,:,:,112),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),MT,G2tensor(:,19))
  call loop_QA_S(G1(:,:,:,77),wf(:,881),G1(:,:,:,113),gX)
  call loop_SQ_A(G1(:,:,:,113),wf(:,-1),G1(:,:,:,114),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,114),Q(:,63),MT,G2tensor(:,20))
  call loop_QA_Z(G1(:,:,:,77),wf(:,881),G1(:,:,:,115),gZu)
  call loop_ZQ_A(G1(:,:,:,115),wf(:,-1),G1(:,:,:,116),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),MT,G2tensor(:,21))
  call loop_QV_A(G1(:,:,:,77),wf(:,1),G1(:,:,:,117))
  call loop_Q_A(G1(:,:,:,117),Q(:,21),MT,G2(:,:,:,216))
  call loop_QA_S(G2(:,:,:,216),wf(:,21),G2(:,:,:,217),gH)
  call loop_SQ_A(G2(:,:,:,217),wf(:,-1),G2(:,:,:,218),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,218),Q(:,63),MT,G3tensor(:,130))
  call loop_QA_S(G2(:,:,:,216),wf(:,21),G2(:,:,:,219),gX)
  call loop_SQ_A(G2(:,:,:,219),wf(:,-1),G2(:,:,:,220),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,220),Q(:,63),MT,G3tensor(:,131))
  call loop_QA_Z(G2(:,:,:,216),wf(:,21),G2(:,:,:,221),gZu)
  call loop_ZQ_A(G2(:,:,:,221),wf(:,-1),G2(:,:,:,222),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,222),Q(:,63),MT,G3tensor(:,132))
  call loop_QA_S(G1(:,:,:,77),wf(:,1229),G1(:,:,:,118),gH)
  call loop_SQ_A(G1(:,:,:,118),wf(:,-1),G1(:,:,:,119),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,119),Q(:,63),MT,G2tensor(:,22))
  call loop_QA_S(G1(:,:,:,77),wf(:,1229),G1(:,:,:,120),gX)
  call loop_SQ_A(G1(:,:,:,120),wf(:,-1),G1(:,:,:,121),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,121),Q(:,63),MT,G2tensor(:,23))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1229),G1(:,:,:,122),gZu)
  call loop_ZQ_A(G1(:,:,:,122),wf(:,-1),G1(:,:,:,123),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,123),Q(:,63),MT,G2tensor(:,24))
  call loop_QA_S(G1(:,:,:,77),wf(:,1240),G1(:,:,:,124),gH)
  call loop_SQ_A(G1(:,:,:,124),wf(:,-1),G1(:,:,:,125),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,125),Q(:,63),MT,G2tensor(:,25))
  call loop_QA_S(G1(:,:,:,77),wf(:,1240),G1(:,:,:,126),gX)
  call loop_SQ_A(G1(:,:,:,126),wf(:,-1),G1(:,:,:,127),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,127),Q(:,63),MT,G2tensor(:,26))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1240),G1(:,:,:,128),gZu)
  call loop_ZQ_A(G1(:,:,:,128),wf(:,-1),G1(:,:,:,129),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),MT,G2tensor(:,27))
  call loop_QV_A(G1(:,:,:,77),wf(:,67),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,57),MT,G2(:,:,:,223))
  call loop_QS_A(G2(:,:,:,223),wf(:,69),G2(:,:,:,224),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,224),Q(:,63),MT,G3tensor(:,133))
  call loop_QS_A(G2(:,:,:,223),wf(:,72),G2(:,:,:,225),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,225),Q(:,63),MT,G3tensor(:,134))
  call loop_QV_A(G2(:,:,:,223),wf(:,7),G2(:,:,:,226))
  call check_last_Q_A(l_switch,G2(:,:,:,226),Q(:,63),MT,G3tensor(:,135))
  call loop_QZ_A(G2(:,:,:,223),wf(:,75),G2(:,:,:,227),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,227),Q(:,63),MT,G3tensor(:,136))
  call loop_QV_A(G1(:,:,:,77),wf(:,65),G1(:,:,:,131))
  call loop_Q_A(G1(:,:,:,131),Q(:,54),MT,G2(:,:,:,228))
  call loop_QS_A(G2(:,:,:,228),wf(:,107),G2(:,:,:,229),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,229),Q(:,63),MT,G3tensor(:,137))
  call loop_QS_A(G2(:,:,:,228),wf(:,111),G2(:,:,:,230),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,230),Q(:,63),MT,G3tensor(:,138))
  call loop_QV_A(G2(:,:,:,228),wf(:,6),G2(:,:,:,231))
  call check_last_Q_A(l_switch,G2(:,:,:,231),Q(:,63),MT,G3tensor(:,139))
  call loop_QZ_A(G2(:,:,:,228),wf(:,114),G2(:,:,:,232),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,232),Q(:,63),MT,G3tensor(:,140))
  call loop_QS_A(G1(:,:,:,77),wf(:,107),G1(:,:,:,132),gH)
  call loop_Q_A(G1(:,:,:,132),Q(:,25),MT,G2(:,:,:,233))
  call loop_QV_A(G2(:,:,:,233),wf(:,-5),G2(:,:,:,234))
  call loop_Q_A(G2(:,:,:,234),Q(:,57),MT,G3(:,:,:,58))
  call loop_QV_A(G3(:,:,:,58),wf(:,7),G3(:,:,:,59))
  call check_last_Q_A(l_switch,G3(:,:,:,59),Q(:,63),MT,G4tensor(:,34))
  call loop_QS_A(G1(:,:,:,77),wf(:,111),G1(:,:,:,133),gX)
  call loop_Q_A(G1(:,:,:,133),Q(:,25),MT,G2(:,:,:,235))
  call loop_QV_A(G2(:,:,:,235),wf(:,-5),G2(:,:,:,236))
  call loop_Q_A(G2(:,:,:,236),Q(:,57),MT,G3(:,:,:,60))
  call loop_QV_A(G3(:,:,:,60),wf(:,7),G3(:,:,:,61))
  call check_last_Q_A(l_switch,G3(:,:,:,61),Q(:,63),MT,G4tensor(:,35))
  call loop_QV_A(G1(:,:,:,77),wf(:,6),G1(:,:,:,134))
  call loop_Q_A(G1(:,:,:,134),Q(:,25),MT,G2(:,:,:,237))
  call loop_QV_A(G2(:,:,:,237),wf(:,-5),G2(:,:,:,238))
  call loop_Q_A(G2(:,:,:,238),Q(:,57),MT,G3(:,:,:,62))
  call loop_QS_A(G3(:,:,:,62),wf(:,69),G3(:,:,:,63),gH)
  call check_last_Q_A(l_switch,G3(:,:,:,63),Q(:,63),MT,G4tensor(:,36))
  call loop_QS_A(G3(:,:,:,62),wf(:,72),G3(:,:,:,64),gX)
  call check_last_Q_A(l_switch,G3(:,:,:,64),Q(:,63),MT,G4tensor(:,37))
  call loop_QV_A(G3(:,:,:,62),wf(:,7),G3(:,:,:,65))
  call check_last_Q_A(l_switch,G3(:,:,:,65),Q(:,63),MT,G4tensor(:,38))
  call loop_QZ_A(G3(:,:,:,62),wf(:,75),G3(:,:,:,66),gZu)
  call check_last_Q_A(l_switch,G3(:,:,:,66),Q(:,63),MT,G4tensor(:,39))
  call loop_QA_S(G2(:,:,:,237),wf(:,109),G2(:,:,:,239),gH)
  call loop_SQ_A(G2(:,:,:,239),wf(:,-1),G2(:,:,:,240),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,240),Q(:,63),MT,G3tensor(:,141))
  call loop_QA_S(G2(:,:,:,237),wf(:,109),G2(:,:,:,241),gX)
  call loop_SQ_A(G2(:,:,:,241),wf(:,-1),G2(:,:,:,242),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,242),Q(:,63),MT,G3tensor(:,142))
  call loop_QA_Z(G2(:,:,:,237),wf(:,109),G2(:,:,:,243),gZu)
  call loop_ZQ_A(G2(:,:,:,243),wf(:,-1),G2(:,:,:,244),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,244),Q(:,63),MT,G3tensor(:,143))
  call loop_QZ_A(G1(:,:,:,77),wf(:,114),G1(:,:,:,135),gZu)
  call loop_Q_A(G1(:,:,:,135),Q(:,25),MT,G2(:,:,:,245))
  call loop_QV_A(G2(:,:,:,245),wf(:,-5),G2(:,:,:,246))
  call loop_Q_A(G2(:,:,:,246),Q(:,57),MT,G3(:,:,:,67))
  call loop_QV_A(G3(:,:,:,67),wf(:,7),G3(:,:,:,68))
  call check_last_Q_A(l_switch,G3(:,:,:,68),Q(:,63),MT,G4tensor(:,40))
  call loop_QV_A(G1(:,:,:,77),wf(:,102),G1(:,:,:,136))
  call loop_Q_A(G1(:,:,:,136),Q(:,57),MT,G2(:,:,:,247))
  call loop_QS_A(G2(:,:,:,247),wf(:,69),G2(:,:,:,248),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,248),Q(:,63),MT,G3tensor(:,144))
  call loop_QS_A(G2(:,:,:,247),wf(:,72),G2(:,:,:,249),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,249),Q(:,63),MT,G3tensor(:,145))
  call loop_QV_A(G2(:,:,:,247),wf(:,7),G2(:,:,:,250))
  call check_last_Q_A(l_switch,G2(:,:,:,250),Q(:,63),MT,G3tensor(:,146))
  call loop_QZ_A(G2(:,:,:,247),wf(:,75),G2(:,:,:,251),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,251),Q(:,63),MT,G3tensor(:,147))
  call loop_QS_A(G1(:,:,:,77),wf(:,201),G1(:,:,:,137),gH)
  call loop_Q_A(G1(:,:,:,137),Q(:,57),MT,G2(:,:,:,252))
  call loop_QV_A(G2(:,:,:,252),wf(:,7),G2(:,:,:,253))
  call check_last_Q_A(l_switch,G2(:,:,:,253),Q(:,63),MT,G3tensor(:,148))
  call loop_QS_A(G1(:,:,:,77),wf(:,203),G1(:,:,:,138),gX)
  call loop_Q_A(G1(:,:,:,138),Q(:,57),MT,G2(:,:,:,254))
  call loop_QV_A(G2(:,:,:,254),wf(:,7),G2(:,:,:,255))
  call check_last_Q_A(l_switch,G2(:,:,:,255),Q(:,63),MT,G3tensor(:,149))
  call loop_QZ_A(G1(:,:,:,77),wf(:,205),G1(:,:,:,139),gZu)
  call loop_Q_A(G1(:,:,:,139),Q(:,57),MT,G2(:,:,:,256))
  call loop_QV_A(G2(:,:,:,256),wf(:,7),G2(:,:,:,257))
  call check_last_Q_A(l_switch,G2(:,:,:,257),Q(:,63),MT,G3tensor(:,150))
  call loop_QS_A(G1(:,:,:,77),wf(:,209),G1(:,:,:,140),gH)
  call loop_Q_A(G1(:,:,:,140),Q(:,57),MT,G2(:,:,:,258))
  call loop_QV_A(G2(:,:,:,258),wf(:,7),G2(:,:,:,259))
  call check_last_Q_A(l_switch,G2(:,:,:,259),Q(:,63),MT,G3tensor(:,151))
  call loop_QS_A(G1(:,:,:,77),wf(:,210),G1(:,:,:,141),gX)
  call loop_Q_A(G1(:,:,:,141),Q(:,57),MT,G2(:,:,:,260))
  call loop_QV_A(G2(:,:,:,260),wf(:,7),G2(:,:,:,261))
  call check_last_Q_A(l_switch,G2(:,:,:,261),Q(:,63),MT,G3tensor(:,152))
  call loop_QV_A(G1(:,:,:,77),wf(:,104),G1(:,:,:,142))
  call loop_Q_A(G1(:,:,:,142),Q(:,57),MT,G2(:,:,:,262))
  call loop_QS_A(G2(:,:,:,262),wf(:,69),G2(:,:,:,263),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,263),Q(:,63),MT,G3tensor(:,153))
  call loop_QS_A(G2(:,:,:,262),wf(:,72),G2(:,:,:,264),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,264),Q(:,63),MT,G3tensor(:,154))
  call loop_QV_A(G2(:,:,:,262),wf(:,7),G2(:,:,:,265))
  call check_last_Q_A(l_switch,G2(:,:,:,265),Q(:,63),MT,G3tensor(:,155))
  call loop_QZ_A(G2(:,:,:,262),wf(:,75),G2(:,:,:,266),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,266),Q(:,63),MT,G3tensor(:,156))
  call loop_QZ_A(G1(:,:,:,77),wf(:,211),G1(:,:,:,143),gZu)
  call loop_Q_A(G1(:,:,:,143),Q(:,57),MT,G2(:,:,:,267))
  call loop_QV_A(G2(:,:,:,267),wf(:,7),G2(:,:,:,268))
  call check_last_Q_A(l_switch,G2(:,:,:,268),Q(:,63),MT,G3tensor(:,157))
  call loop_QA_S(G1(:,:,:,77),wf(:,966),G1(:,:,:,144),gH)
  call loop_SQ_A(G1(:,:,:,144),wf(:,0),G1(:,:,:,145),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,145),Q(:,63),MT,G2tensor(:,28))
  call loop_QA_S(G1(:,:,:,77),wf(:,966),G1(:,:,:,146),gX)
  call loop_SQ_A(G1(:,:,:,146),wf(:,0),G1(:,:,:,147),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,147),Q(:,63),MT,G2tensor(:,29))
  call loop_QA_Z(G1(:,:,:,77),wf(:,966),G1(:,:,:,148),gZu)
  call loop_ZQ_A(G1(:,:,:,148),wf(:,0),G1(:,:,:,149),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,149),Q(:,63),MT,G2tensor(:,30))
  call loop_QV_A(G1(:,:,:,77),wf(:,7),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,22),MT,G2(:,:,:,269))
  call loop_QA_S(G2(:,:,:,269),wf(:,21),G2(:,:,:,270),gH)
  call loop_SQ_A(G2(:,:,:,270),wf(:,0),G2(:,:,:,271),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,271),Q(:,63),MT,G3tensor(:,158))
  call loop_QA_S(G2(:,:,:,269),wf(:,21),G2(:,:,:,272),gX)
  call loop_SQ_A(G2(:,:,:,272),wf(:,0),G2(:,:,:,273),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,273),Q(:,63),MT,G3tensor(:,159))
  call loop_QA_Z(G2(:,:,:,269),wf(:,21),G2(:,:,:,274),gZu)
  call loop_ZQ_A(G2(:,:,:,274),wf(:,0),G2(:,:,:,275),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,275),Q(:,63),MT,G3tensor(:,160))
  call loop_QA_S(G1(:,:,:,77),wf(:,1289),G1(:,:,:,151),gH)
  call loop_SQ_A(G1(:,:,:,151),wf(:,0),G1(:,:,:,152),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,152),Q(:,63),MT,G2tensor(:,31))
  call loop_QA_S(G1(:,:,:,77),wf(:,1289),G1(:,:,:,153),gX)
  call loop_SQ_A(G1(:,:,:,153),wf(:,0),G1(:,:,:,154),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,154),Q(:,63),MT,G2tensor(:,32))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1289),G1(:,:,:,155),gZu)
  call loop_ZQ_A(G1(:,:,:,155),wf(:,0),G1(:,:,:,156),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,156),Q(:,63),MT,G2tensor(:,33))
  call loop_QA_S(G1(:,:,:,77),wf(:,1296),G1(:,:,:,157),gH)
  call loop_SQ_A(G1(:,:,:,157),wf(:,0),G1(:,:,:,158),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,158),Q(:,63),MT,G2tensor(:,34))
  call loop_QA_S(G1(:,:,:,77),wf(:,1296),G1(:,:,:,159),gX)
  call loop_SQ_A(G1(:,:,:,159),wf(:,0),G1(:,:,:,160),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,160),Q(:,63),MT,G2tensor(:,35))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1296),G1(:,:,:,161),gZu)
  call loop_ZQ_A(G1(:,:,:,161),wf(:,0),G1(:,:,:,162),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,162),Q(:,63),MT,G2tensor(:,36))
  call loop_QV_A(G1(:,:,:,77),wf(:,141),G1(:,:,:,163))
  call loop_Q_A(G1(:,:,:,163),Q(:,54),MT,G2(:,:,:,276))
  call loop_QS_A(G2(:,:,:,276),wf(:,107),G2(:,:,:,277),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,277),Q(:,63),MT,G3tensor(:,161))
  call loop_QS_A(G2(:,:,:,276),wf(:,111),G2(:,:,:,278),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,278),Q(:,63),MT,G3tensor(:,162))
  call loop_QV_A(G2(:,:,:,276),wf(:,6),G2(:,:,:,279))
  call check_last_Q_A(l_switch,G2(:,:,:,279),Q(:,63),MT,G3tensor(:,163))
  call loop_QZ_A(G2(:,:,:,276),wf(:,114),G2(:,:,:,280),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,280),Q(:,63),MT,G3tensor(:,164))
  call loop_QS_A(G1(:,:,:,77),wf(:,182),G1(:,:,:,164),gH)
  call loop_Q_A(G1(:,:,:,164),Q(:,54),MT,G2(:,:,:,281))
  call loop_QV_A(G2(:,:,:,281),wf(:,6),G2(:,:,:,282))
  call check_last_Q_A(l_switch,G2(:,:,:,282),Q(:,63),MT,G3tensor(:,165))
  call loop_QS_A(G1(:,:,:,77),wf(:,184),G1(:,:,:,165),gX)
  call loop_Q_A(G1(:,:,:,165),Q(:,54),MT,G2(:,:,:,283))
  call loop_QV_A(G2(:,:,:,283),wf(:,6),G2(:,:,:,284))
  call check_last_Q_A(l_switch,G2(:,:,:,284),Q(:,63),MT,G3tensor(:,166))
  call loop_QZ_A(G1(:,:,:,77),wf(:,186),G1(:,:,:,166),gZu)
  call loop_Q_A(G1(:,:,:,166),Q(:,54),MT,G2(:,:,:,285))
  call loop_QV_A(G2(:,:,:,285),wf(:,6),G2(:,:,:,286))
  call check_last_Q_A(l_switch,G2(:,:,:,286),Q(:,63),MT,G3tensor(:,167))
  call loop_QA_S(G1(:,:,:,77),wf(:,109),G1(:,:,:,167),gH)
  call loop_SQ_A(G1(:,:,:,167),wf(:,137),G1(:,:,:,168),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,168),Q(:,63),MT,G2tensor(:,37))
  call loop_SQ_A(G1(:,:,:,167),wf(:,170),G1(:,:,:,169),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,169),Q(:,63),MT,G2tensor(:,38))
  call loop_QA_S(G1(:,:,:,77),wf(:,109),G1(:,:,:,170),gX)
  call loop_SQ_A(G1(:,:,:,170),wf(:,137),G1(:,:,:,171),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,171),Q(:,63),MT,G2tensor(:,39))
  call loop_SQ_A(G1(:,:,:,170),wf(:,170),G1(:,:,:,172),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,172),Q(:,63),MT,G2tensor(:,40))
  call loop_QA_Z(G1(:,:,:,77),wf(:,109),G1(:,:,:,173),gZu)
  call loop_ZQ_A(G1(:,:,:,173),wf(:,137),G1(:,:,:,174),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,174),Q(:,63),MT,G2tensor(:,41))
  call loop_ZQ_A(G1(:,:,:,173),wf(:,170),G1(:,:,:,175),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,175),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G1(:,:,:,77),wf(:,143),G1(:,:,:,176))
  call loop_Q_A(G1(:,:,:,176),Q(:,54),MT,G2(:,:,:,287))
  call loop_QS_A(G2(:,:,:,287),wf(:,107),G2(:,:,:,288),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,288),Q(:,63),MT,G3tensor(:,168))
  call loop_QS_A(G2(:,:,:,287),wf(:,111),G2(:,:,:,289),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,289),Q(:,63),MT,G3tensor(:,169))
  call loop_QV_A(G2(:,:,:,287),wf(:,6),G2(:,:,:,290))
  call check_last_Q_A(l_switch,G2(:,:,:,290),Q(:,63),MT,G3tensor(:,170))
  call loop_QZ_A(G2(:,:,:,287),wf(:,114),G2(:,:,:,291),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,291),Q(:,63),MT,G3tensor(:,171))
  call loop_QS_A(G1(:,:,:,77),wf(:,188),G1(:,:,:,177),gH)
  call loop_Q_A(G1(:,:,:,177),Q(:,54),MT,G2(:,:,:,292))
  call loop_QV_A(G2(:,:,:,292),wf(:,6),G2(:,:,:,293))
  call check_last_Q_A(l_switch,G2(:,:,:,293),Q(:,63),MT,G3tensor(:,172))
  call loop_QS_A(G1(:,:,:,77),wf(:,189),G1(:,:,:,178),gX)
  call loop_Q_A(G1(:,:,:,178),Q(:,54),MT,G2(:,:,:,294))
  call loop_QV_A(G2(:,:,:,294),wf(:,6),G2(:,:,:,295))
  call check_last_Q_A(l_switch,G2(:,:,:,295),Q(:,63),MT,G3tensor(:,173))
  call loop_QZ_A(G1(:,:,:,77),wf(:,190),G1(:,:,:,179),gZu)
  call loop_Q_A(G1(:,:,:,179),Q(:,54),MT,G2(:,:,:,296))
  call loop_QV_A(G2(:,:,:,296),wf(:,6),G2(:,:,:,297))
  call check_last_Q_A(l_switch,G2(:,:,:,297),Q(:,63),MT,G3tensor(:,174))
  call loop_QA_S(G1(:,:,:,77),wf(:,1031),G1(:,:,:,180),gH)
  call loop_SQ_A(G1(:,:,:,180),wf(:,-1),G1(:,:,:,181),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,181),Q(:,63),MT,G2tensor(:,43))
  call loop_QA_S(G1(:,:,:,77),wf(:,1031),G1(:,:,:,182),gX)
  call loop_SQ_A(G1(:,:,:,182),wf(:,-1),G1(:,:,:,183),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,183),Q(:,63),MT,G2tensor(:,44))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1031),G1(:,:,:,184),gZu)
  call loop_ZQ_A(G1(:,:,:,184),wf(:,-1),G1(:,:,:,185),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,185),Q(:,63),MT,G2tensor(:,45))
  call loop_QA_S(G1(:,:,:,77),wf(:,1341),G1(:,:,:,186),gH)
  call loop_SQ_A(G1(:,:,:,186),wf(:,-1),G1(:,:,:,187),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,187),Q(:,63),MT,G2tensor(:,46))
  call loop_QA_S(G1(:,:,:,77),wf(:,1341),G1(:,:,:,188),gX)
  call loop_SQ_A(G1(:,:,:,188),wf(:,-1),G1(:,:,:,189),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,189),Q(:,63),MT,G2tensor(:,47))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1341),G1(:,:,:,190),gZu)
  call loop_ZQ_A(G1(:,:,:,190),wf(:,-1),G1(:,:,:,191),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,191),Q(:,63),MT,G2tensor(:,48))
  call loop_QA_S(G1(:,:,:,77),wf(:,1352),G1(:,:,:,192),gH)
  call loop_SQ_A(G1(:,:,:,192),wf(:,-1),G1(:,:,:,193),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,193),Q(:,63),MT,G2tensor(:,49))
  call loop_QA_S(G1(:,:,:,77),wf(:,1352),G1(:,:,:,194),gX)
  call loop_SQ_A(G1(:,:,:,194),wf(:,-1),G1(:,:,:,195),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,195),Q(:,63),MT,G2tensor(:,50))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1352),G1(:,:,:,196),gZu)
  call loop_ZQ_A(G1(:,:,:,196),wf(:,-1),G1(:,:,:,197),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,197),Q(:,63),MT,G2tensor(:,51))
  call loop_QV_A(G1(:,:,:,77),wf(:,174),G1(:,:,:,198))
  call loop_Q_A(G1(:,:,:,198),Q(:,53),MT,G2(:,:,:,298))
  call loop_QS_A(G2(:,:,:,298),wf(:,145),G2(:,:,:,299),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,299),Q(:,63),MT,G3tensor(:,175))
  call loop_QS_A(G2(:,:,:,298),wf(:,147),G2(:,:,:,300),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,300),Q(:,63),MT,G3tensor(:,176))
  call loop_QV_A(G2(:,:,:,298),wf(:,2),G2(:,:,:,301))
  call check_last_Q_A(l_switch,G2(:,:,:,301),Q(:,63),MT,G3tensor(:,177))
  call loop_QZ_A(G2(:,:,:,298),wf(:,150),G2(:,:,:,302),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,302),Q(:,63),MT,G3tensor(:,178))
  call loop_QS_A(G1(:,:,:,77),wf(:,194),G1(:,:,:,199),gH)
  call loop_Q_A(G1(:,:,:,199),Q(:,53),MT,G2(:,:,:,303))
  call loop_QV_A(G2(:,:,:,303),wf(:,2),G2(:,:,:,304))
  call check_last_Q_A(l_switch,G2(:,:,:,304),Q(:,63),MT,G3tensor(:,179))
  call loop_QS_A(G1(:,:,:,77),wf(:,196),G1(:,:,:,200),gX)
  call loop_Q_A(G1(:,:,:,200),Q(:,53),MT,G2(:,:,:,305))
  call loop_QV_A(G2(:,:,:,305),wf(:,2),G2(:,:,:,306))
  call check_last_Q_A(l_switch,G2(:,:,:,306),Q(:,63),MT,G3tensor(:,180))
  call loop_QZ_A(G1(:,:,:,77),wf(:,198),G1(:,:,:,201),gZu)
  call loop_Q_A(G1(:,:,:,201),Q(:,53),MT,G2(:,:,:,307))
  call loop_QV_A(G2(:,:,:,307),wf(:,2),G2(:,:,:,308))
  call check_last_Q_A(l_switch,G2(:,:,:,308),Q(:,63),MT,G3tensor(:,181))
  call loop_QS_A(G1(:,:,:,77),wf(:,206),G1(:,:,:,202),gH)
  call loop_Q_A(G1(:,:,:,202),Q(:,53),MT,G2(:,:,:,309))
  call loop_QV_A(G2(:,:,:,309),wf(:,2),G2(:,:,:,310))
  call check_last_Q_A(l_switch,G2(:,:,:,310),Q(:,63),MT,G3tensor(:,182))
  call loop_QS_A(G1(:,:,:,77),wf(:,207),G1(:,:,:,203),gX)
  call loop_Q_A(G1(:,:,:,203),Q(:,53),MT,G2(:,:,:,311))
  call loop_QV_A(G2(:,:,:,311),wf(:,2),G2(:,:,:,312))
  call check_last_Q_A(l_switch,G2(:,:,:,312),Q(:,63),MT,G3tensor(:,183))
  call loop_QV_A(G1(:,:,:,77),wf(:,175),G1(:,:,:,204))
  call loop_Q_A(G1(:,:,:,204),Q(:,53),MT,G2(:,:,:,313))
  call loop_QS_A(G2(:,:,:,313),wf(:,145),G2(:,:,:,314),gH)
  call check_last_Q_A(l_switch,G2(:,:,:,314),Q(:,63),MT,G3tensor(:,184))
  call loop_QS_A(G2(:,:,:,313),wf(:,147),G2(:,:,:,315),gX)
  call check_last_Q_A(l_switch,G2(:,:,:,315),Q(:,63),MT,G3tensor(:,185))
  call loop_QV_A(G2(:,:,:,313),wf(:,2),G2(:,:,:,316))
  call check_last_Q_A(l_switch,G2(:,:,:,316),Q(:,63),MT,G3tensor(:,186))
  call loop_QZ_A(G2(:,:,:,313),wf(:,150),G2(:,:,:,317),gZu)
  call check_last_Q_A(l_switch,G2(:,:,:,317),Q(:,63),MT,G3tensor(:,187))
  call loop_QZ_A(G1(:,:,:,77),wf(:,208),G1(:,:,:,205),gZu)
  call loop_Q_A(G1(:,:,:,205),Q(:,53),MT,G2(:,:,:,318))
  call loop_QV_A(G2(:,:,:,318),wf(:,2),G2(:,:,:,319))
  call check_last_Q_A(l_switch,G2(:,:,:,319),Q(:,63),MT,G3tensor(:,188))
  call loop_QA_S(G1(:,:,:,77),wf(:,1093),G1(:,:,:,206),gH)
  call loop_SQ_A(G1(:,:,:,206),wf(:,0),G1(:,:,:,207),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,207),Q(:,63),MT,G2tensor(:,52))
  call loop_QA_S(G1(:,:,:,77),wf(:,1093),G1(:,:,:,208),gX)
  call loop_SQ_A(G1(:,:,:,208),wf(:,0),G1(:,:,:,209),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,209),Q(:,63),MT,G2tensor(:,53))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1093),G1(:,:,:,210),gZu)
  call loop_ZQ_A(G1(:,:,:,210),wf(:,0),G1(:,:,:,211),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,211),Q(:,63),MT,G2tensor(:,54))
  call loop_QA_S(G1(:,:,:,77),wf(:,1401),G1(:,:,:,212),gH)
  call loop_SQ_A(G1(:,:,:,212),wf(:,0),G1(:,:,:,213),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,213),Q(:,63),MT,G2tensor(:,55))
  call loop_QA_S(G1(:,:,:,77),wf(:,1401),G1(:,:,:,214),gX)
  call loop_SQ_A(G1(:,:,:,214),wf(:,0),G1(:,:,:,215),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,215),Q(:,63),MT,G2tensor(:,56))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1401),G1(:,:,:,216),gZu)
  call loop_ZQ_A(G1(:,:,:,216),wf(:,0),G1(:,:,:,217),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,217),Q(:,63),MT,G2tensor(:,57))
  call loop_QA_S(G1(:,:,:,77),wf(:,1408),G1(:,:,:,218),gH)
  call loop_SQ_A(G1(:,:,:,218),wf(:,0),G1(:,:,:,219),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,219),Q(:,63),MT,G2tensor(:,58))
  call loop_QA_S(G1(:,:,:,77),wf(:,1408),G1(:,:,:,220),gX)
  call loop_SQ_A(G1(:,:,:,220),wf(:,0),G1(:,:,:,221),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,221),Q(:,63),MT,G2tensor(:,59))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1408),G1(:,:,:,222),gZu)
  call loop_ZQ_A(G1(:,:,:,222),wf(:,0),G1(:,:,:,223),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,223),Q(:,63),MT,G2tensor(:,60))
  call loop_QA_S(G1(:,:,:,77),wf(:,1615),G1(:,:,:,224),gH)
  call loop_SQ_A(G1(:,:,:,224),wf(:,-1),G1(:,:,:,225),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,225),Q(:,63),MT,G2tensor(:,61))
  call loop_QA_S(G1(:,:,:,77),wf(:,1615),G1(:,:,:,226),gX)
  call loop_SQ_A(G1(:,:,:,226),wf(:,-1),G1(:,:,:,227),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,227),Q(:,63),MT,G2tensor(:,62))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1615),G1(:,:,:,228),gZu)
  call loop_ZQ_A(G1(:,:,:,228),wf(:,-1),G1(:,:,:,229),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,229),Q(:,63),MT,G2tensor(:,63))
  call loop_QA_S(G1(:,:,:,77),wf(:,1632),G1(:,:,:,230),gH)
  call loop_SQ_A(G1(:,:,:,230),wf(:,-1),G1(:,:,:,231),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,231),Q(:,63),MT,G2tensor(:,64))
  call loop_QA_S(G1(:,:,:,77),wf(:,1632),G1(:,:,:,232),gX)
  call loop_SQ_A(G1(:,:,:,232),wf(:,-1),G1(:,:,:,233),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,233),Q(:,63),MT,G2tensor(:,65))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1632),G1(:,:,:,234),gZu)
  call loop_ZQ_A(G1(:,:,:,234),wf(:,-1),G1(:,:,:,235),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,235),Q(:,63),MT,G2tensor(:,66))
  call loop_QA_S(G1(:,:,:,77),wf(:,1665),G1(:,:,:,236),gH)
  call loop_SQ_A(G1(:,:,:,236),wf(:,0),G1(:,:,:,237),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,237),Q(:,63),MT,G2tensor(:,67))
  call loop_QA_S(G1(:,:,:,77),wf(:,1665),G1(:,:,:,238),gX)
  call loop_SQ_A(G1(:,:,:,238),wf(:,0),G1(:,:,:,239),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,239),Q(:,63),MT,G2tensor(:,68))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1665),G1(:,:,:,240),gZu)
  call loop_ZQ_A(G1(:,:,:,240),wf(:,0),G1(:,:,:,241),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,241),Q(:,63),MT,G2tensor(:,69))
  call loop_QA_S(G1(:,:,:,77),wf(:,1674),G1(:,:,:,242),gH)
  call loop_SQ_A(G1(:,:,:,242),wf(:,0),G1(:,:,:,243),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,243),Q(:,63),MT,G2tensor(:,70))
  call loop_QA_S(G1(:,:,:,77),wf(:,1674),G1(:,:,:,244),gX)
  call loop_SQ_A(G1(:,:,:,244),wf(:,0),G1(:,:,:,245),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,245),Q(:,63),MT,G2tensor(:,71))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1674),G1(:,:,:,246),gZu)
  call loop_ZQ_A(G1(:,:,:,246),wf(:,0),G1(:,:,:,247),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,247),Q(:,63),MT,G2tensor(:,72))
  call loop_QA_S(G1(:,:,:,77),wf(:,1707),G1(:,:,:,248),gH)
  call loop_SQ_A(G1(:,:,:,248),wf(:,-1),G1(:,:,:,249),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,249),Q(:,63),MT,G2tensor(:,73))
  call loop_QA_S(G1(:,:,:,77),wf(:,1707),G1(:,:,:,250),gX)
  call loop_SQ_A(G1(:,:,:,250),wf(:,-1),G1(:,:,:,251),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,251),Q(:,63),MT,G2tensor(:,74))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1707),G1(:,:,:,252),gZu)
  call loop_ZQ_A(G1(:,:,:,252),wf(:,-1),G1(:,:,:,253),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,253),Q(:,63),MT,G2tensor(:,75))
  call loop_QA_S(G1(:,:,:,77),wf(:,1720),G1(:,:,:,254),gH)
  call loop_SQ_A(G1(:,:,:,254),wf(:,0),G1(:,:,:,255),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,255),Q(:,63),MT,G2tensor(:,76))
  call loop_QA_S(G1(:,:,:,77),wf(:,1720),G1(:,:,:,256),gX)
  call loop_SQ_A(G1(:,:,:,256),wf(:,0),G1(:,:,:,257),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,257),Q(:,63),MT,G2tensor(:,77))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1720),G1(:,:,:,258),gZu)
  call loop_ZQ_A(G1(:,:,:,258),wf(:,0),G1(:,:,:,259),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,259),Q(:,63),MT,G2tensor(:,78))
  call loop_QA_S(G1(:,:,:,77),wf(:,1749),G1(:,:,:,260),gH)
  call loop_SQ_A(G1(:,:,:,260),wf(:,-1),G1(:,:,:,261),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,261),Q(:,63),MT,G2tensor(:,79))
  call loop_QA_S(G1(:,:,:,77),wf(:,1749),G1(:,:,:,262),gX)
  call loop_SQ_A(G1(:,:,:,262),wf(:,-1),G1(:,:,:,263),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,263),Q(:,63),MT,G2tensor(:,80))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1749),G1(:,:,:,264),gZu)
  call loop_ZQ_A(G1(:,:,:,264),wf(:,-1),G1(:,:,:,265),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,265),Q(:,63),MT,G2tensor(:,81))
  call loop_QA_S(G1(:,:,:,77),wf(:,1762),G1(:,:,:,266),gH)
  call loop_SQ_A(G1(:,:,:,266),wf(:,0),G1(:,:,:,267),gH)
  call check_last_Q_A(l_switch,G1(:,:,:,267),Q(:,63),MT,G2tensor(:,82))
  call loop_QA_S(G1(:,:,:,77),wf(:,1762),G1(:,:,:,268),gX)
  call loop_SQ_A(G1(:,:,:,268),wf(:,0),G1(:,:,:,269),gX)
  call check_last_Q_A(l_switch,G1(:,:,:,269),Q(:,63),MT,G2tensor(:,83))
  call loop_QA_Z(G1(:,:,:,77),wf(:,1762),G1(:,:,:,270),gZu)
  call loop_ZQ_A(G1(:,:,:,270),wf(:,0),G1(:,:,:,271),gZu)
  call check_last_Q_A(l_switch,G1(:,:,:,271),Q(:,63),MT,G2tensor(:,84))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(74)*(-M(15)+M(23))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(73)*(M(15)-M(23))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(76)*(-M(15)+M(23))) * den(1453)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(76)*(-M(15)+M(23))) * den(1453)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(74)*(-M(9)+M(17))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(73)*(M(9)-M(17))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,72) = T3sum(1:35,72) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,72) = T3sum(1:35,72) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,73) = T3sum(1:35,73) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(1455)
  T3sum(1:35,73) = T3sum(1:35,73) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(90)*(-M(12)+M(20))+c(89)*(M(10)+M(16)-M(18)-M(24))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(90)*(-M(12)+M(20))+c(89)*(M(10)+M(16)-M(18)-M(24))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(51)*(-M(12)+M(14)+M(20)-M(22))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(51)*(M(12)-M(14)-M(20)+M(22))) * den(1456)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(100)*(M(9)-M(17))) * den(324)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(100)*(M(9)-M(17))) * den(324)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(97)*(M(9)-M(17))) * den(324)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(97)*(M(9)-M(17))) * den(324)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(100)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,15)
  Gcoeff = (c(100)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(97)*(M(9)-M(17))) * den(325)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,23)
  Gcoeff = (c(97)*(M(9)-M(17))) * den(325)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,27)
  Gcoeff = (c(74)*(-M(9)+M(17))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(73)*(-M(9)+M(17))) * den(11)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(74)*(-M(9)+M(17))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(73)*(-M(9)+M(17))) * den(11)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(73)*(M(9)-M(17))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(72)*(M(9)-M(17))) * den(11)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(73)*(M(9)-M(17))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(72)*(M(9)-M(17))) * den(11)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,31)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,25)
  Gcoeff = (c(76)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(75)*(-M(9)+M(17))) * den(325)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(90)*(M(4)-M(12))+c(89)*(M(10)-M(18))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(88)*(M(4)-M(12))+c(87)*(M(10)-M(18))) * den(11)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(6)+M(22))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(6)+M(22))) * den(11)
  T3sum(1:35,74) = T3sum(1:35,74) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(90)*(M(4)-M(12))+c(89)*(M(10)-M(18))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(88)*(M(4)-M(12))+c(87)*(M(10)-M(18))) * den(11)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(89)*(M(10)-M(18))+c(90)*(-M(6)+M(22))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,33)
  Gcoeff = (c(87)*(M(10)-M(18))+c(88)*(-M(6)+M(22))) * den(11)
  T3sum(1:35,75) = T3sum(1:35,75) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(51)*(-M(4)-M(6)+M(12)+M(22))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(51)*(M(4)+M(6)-M(12)-M(22))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(51)*(M(4)+M(6)-M(12)-M(22))) * den(11)
  T3sum(1:35,5) = T3sum(1:35,5) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(100)*(-M(9)+M(17))) * den(335)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(100)*(M(9)-M(17))) * den(336)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(73)*(M(9)-M(17))) * den(337)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(75)*(M(9)-M(17))) * den(336)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(87)*(-M(10)+M(18))+c(88)*(M(6)-M(20))) * den(337)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(100)*(-M(15)+M(23))) * den(339)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(100)*(M(15)-M(23))) * den(340)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(73)*(M(15)-M(23))) * den(341)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(75)*(M(15)-M(23))) * den(340)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(88)*(M(4)-M(22))+c(87)*(-M(16)+M(24))) * den(341)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,47)
  Gcoeff = (c(88)*(M(20)-M(22))) * den(615)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(82)*M(15)-c(81)*M(27)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(80)*M(15))+c(79)*M(27)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(86)*M(15)-c(85)*M(27)) * den(314)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(86)*M(15)-c(85)*M(27)) * den(314)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(82)*M(9)-c(81)*M(27)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (-(c(80)*M(9))+c(79)*M(27)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(86)*M(9)-c(85)*M(27)) * den(315)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(84)*M(9)-c(83)*M(27)) * den(315)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(86)*M(17)-c(85)*M(27)) * den(315)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(315)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(86)*M(9)-c(85)*M(27)) * den(315)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,19)
  Gcoeff = (c(84)*M(9)-c(83)*M(27)) * den(315)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(86)*M(17)-c(85)*M(27)) * den(315)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(315)
  T4sum(1:70,2) = T4sum(1:70,2) + Gcoeff * G4tensor(:,17)
  Gcoeff = (c(96)*M(12)+c(95)*(-M(10)-M(16))+c(94)*M(28)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(96)*M(12)+c(95)*(-M(10)-M(16))+c(94)*M(28)) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(51)*(M(12)+M(22))+c(46)*(-M(10)-M(16)-M(18)-M(24))+c(48)*(M(2)+M(8)+M(26))) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,25)
  Gcoeff = (c(51)*(M(12)+M(22))+c(46)*(-M(10)-M(16)-M(18)-M(24))+c(48)*(M(2)+M(8)+M(26))) * den(3)
  T4sum(1:70,3) = T4sum(1:70,3) + Gcoeff * G4tensor(:,23)
  Gcoeff = (c(82)*M(23)-c(81)*M(27)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(80)*M(23))+c(79)*M(27)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(86)*M(23)-c(85)*M(27)) * den(314)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(86)*M(23)-c(85)*M(27)) * den(314)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(82)*M(17)-c(81)*M(27)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (-(c(80)*M(17))+c(79)*M(27)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(86)*M(9)-c(85)*M(27)) * den(315)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(84)*M(9)-c(83)*M(27)) * den(315)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,10)
  Gcoeff = (c(86)*M(17)-c(85)*M(27)) * den(315)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(315)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,14)
  Gcoeff = (c(86)*M(9)-c(85)*M(27)) * den(315)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(84)*M(9)-c(83)*M(27)) * den(315)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(86)*M(17)-c(85)*M(27)) * den(315)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(315)
  T4sum(1:70,5) = T4sum(1:70,5) + Gcoeff * G4tensor(:,22)
  Gcoeff = (c(96)*M(20)+c(95)*(-M(18)-M(24))+c(94)*M(28)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(96)*M(20)+c(95)*(-M(18)-M(24))+c(94)*M(28)) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(51)*(M(14)+M(20))+c(46)*(-M(10)-M(16)-M(18)-M(24))+c(48)*(M(2)+M(8)+M(26))) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(51)*(M(14)+M(20))+c(46)*(-M(10)-M(16)-M(18)-M(24))+c(48)*(M(2)+M(8)+M(26))) * den(3)
  T4sum(1:70,6) = T4sum(1:70,6) + Gcoeff * G4tensor(:,26)
  Gcoeff = (-(c(103)*M(15))+c(102)*M(27)) * den(318)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,27)
  Gcoeff = (c(103)*M(15)-c(102)*M(27)) * den(314)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,28)
  Gcoeff = (-(c(103)*M(17))+c(102)*M(27)) * den(320)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(103)*M(17)-c(102)*M(27)) * den(315)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,32)
  Gcoeff = (c(80)*M(15)-c(79)*M(27)) * den(3)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(84)*M(15)-c(83)*M(27)) * den(314)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,30)
  Gcoeff = (c(80)*M(17)-c(79)*M(27)) * den(3)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(315)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,33)
  Gcoeff = (c(93)*M(4)+c(92)*(-M(16)-M(18))+c(91)*M(28)) * den(3)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(64)*(M(3)-M(11))) * den(375)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(64)*(-M(3)+M(11))) * den(375)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(58)*(-M(3)+M(11))) * den(375)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(11)*(-M(3)+M(11))) * den(375)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(54)*(-M(3)+M(11))) * den(375)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(51)*(M(4)-M(12))) * den(375)
  T2sum(1:15,4) = T2sum(1:15,4) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(103)*M(15))) * den(352)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,110)
  Gcoeff = (c(103)*M(15)) * den(355)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,111)
  Gcoeff = (-(c(103)*M(7))) * den(354)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,114)
  Gcoeff = (c(103)*M(7)) * den(357)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,115)
  Gcoeff = (c(80)*M(15)) * den(56)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(84)*M(15)) * den(355)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,113)
  Gcoeff = (c(80)*M(7)) * den(56)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(84)*M(7)) * den(357)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,116)
  Gcoeff = (c(93)*M(4)+c(92)*(-M(8)-M(16))) * den(56)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,112)
  Gcoeff = (c(69)*M(3)-c(68)*M(15)) * den(40)
  T3sum(1:35,111) = T3sum(1:35,111) + Gcoeff * G3tensor(:,117)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(15)) * den(40)
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,119)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(15)) * den(40)
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,121)
  Gcoeff = (c(69)*M(21)-c(68)*M(23)) * den(59)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(69)*M(21))+c(68)*M(23)) * den(59)
  T2sum(1:15,106) = T2sum(1:15,106) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(20)*M(21))+c(19)*M(23)) * den(59)
  T2sum(1:15,106) = T2sum(1:15,106) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(64)*(-M(5)+M(21))) * den(514)
  T2sum(1:15,108) = T2sum(1:15,108) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(64)*(M(5)-M(21))) * den(514)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(58)*(M(5)-M(21))) * den(514)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(11)*(M(5)-M(21))) * den(514)
  T2sum(1:15,109) = T2sum(1:15,109) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(54)*(M(5)-M(21))) * den(514)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(51)*(M(6)-M(22))) * den(514)
  T2sum(1:15,5) = T2sum(1:15,5) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(103)*M(23))) * den(358)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,123)
  Gcoeff = (c(103)*M(23)) * den(360)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,124)
  Gcoeff = (-(c(103)*M(7))) * den(359)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,127)
  Gcoeff = (c(103)*M(7)) * den(361)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,128)
  Gcoeff = (c(80)*M(23)) * den(61)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(84)*M(23)) * den(360)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,126)
  Gcoeff = (c(80)*M(7)) * den(61)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(84)*M(7)) * den(361)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,129)
  Gcoeff = (c(93)*M(22)+c(92)*(-M(8)-M(24))) * den(61)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,125)
  Gcoeff = (c(69)*M(5)-c(68)*M(23)) * den(636)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,19)
  Gcoeff = (-(c(69)*M(5))+c(68)*M(23)) * den(636)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(23)) * den(636)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(69)*M(5)-c(68)*M(23)) * den(635)
  T3sum(1:35,123) = T3sum(1:35,123) + Gcoeff * G3tensor(:,130)
  Gcoeff = (-(c(69)*M(5))+c(68)*M(23)) * den(635)
  T3sum(1:35,124) = T3sum(1:35,124) + Gcoeff * G3tensor(:,131)
  Gcoeff = (-(c(20)*M(5))+c(19)*M(23)) * den(635)
  T3sum(1:35,124) = T3sum(1:35,124) + Gcoeff * G3tensor(:,132)
  Gcoeff = (-(c(103)*M(23))+c(102)*M(27)) * den(1130)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(103)*M(23)-c(102)*M(27)) * den(1131)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,51)
  Gcoeff = (-(c(103)*M(25))+c(102)*M(27)) * den(1133)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(103)*M(25)-c(102)*M(27)) * den(1135)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(80)*M(23)-c(79)*M(27)) * den(1136)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(84)*M(23)-c(83)*M(27)) * den(1131)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(80)*M(25)-c(79)*M(27)) * den(1136)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(84)*M(25)-c(83)*M(27)) * den(1135)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(93)*M(22)+c(92)*(-M(24)-M(26))+c(91)*M(28)) * den(1136)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,54)
  Gcoeff = (-(c(103)*M(23))+c(102)*M(27)) * den(1143)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(103)*M(23)-c(102)*M(27)) * den(1144)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(103)*M(25))+c(102)*M(27)) * den(1145)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(103)*M(25)-c(102)*M(27)) * den(1146)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(80)*M(23)-c(79)*M(27)) * den(1147)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(84)*M(23)-c(83)*M(27)) * den(1144)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(80)*M(25)-c(79)*M(27)) * den(1147)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(84)*M(25)-c(83)*M(27)) * den(1146)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(93)*M(20)+c(92)*(-M(24)-M(26))+c(91)*M(28)) * den(1147)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(69)*M(19)-c(68)*M(23)) * den(1153)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,22)
  Gcoeff = (-(c(69)*M(19))+c(68)*M(23)) * den(1153)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,23)
  Gcoeff = (-(c(20)*M(19))+c(19)*M(23)) * den(1153)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(31)*(M(10)-M(18))+c(36)*(M(6)-M(22))) * den(10)
  T3sum(1:35,11) = T3sum(1:35,11) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(46)*(-M(10)+M(18))) * den(10)
  T3sum(1:35,12) = T3sum(1:35,12) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(64)*(M(5)-M(19))) * den(1158)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(64)*(-M(5)+M(19))) * den(1158)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(11)*(-M(5)+M(19))) * den(1158)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(100)*(M(13)-M(21))) * den(397)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,133)
  Gcoeff = (c(100)*(-M(13)+M(21))) * den(398)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,134)
  Gcoeff = (c(73)*(-M(13)+M(21))) * den(399)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,135)
  Gcoeff = (c(75)*(-M(13)+M(21))) * den(398)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,136)
  Gcoeff = (c(87)*(M(14)-M(22))+c(88)*(-M(2)+M(24))) * den(399)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,135)
  Gcoeff = (c(100)*(M(11)-M(19))) * den(401)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,137)
  Gcoeff = (c(100)*(-M(11)+M(19))) * den(402)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,138)
  Gcoeff = (c(73)*(-M(11)+M(19))) * den(403)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,139)
  Gcoeff = (c(75)*(-M(11)+M(19))) * den(402)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,140)
  Gcoeff = (c(88)*(-M(8)+M(18))+c(87)*(M(12)-M(20))) * den(403)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,139)
  Gcoeff = (c(88)*(-M(18)+M(24))) * den(730)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(103)*M(19)-c(102)*M(25)) * den(380)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,34)
  Gcoeff = (-(c(103)*M(19))+c(102)*M(25)) * den(316)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,35)
  Gcoeff = (c(103)*M(13)-c(102)*M(25)) * den(382)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,36)
  Gcoeff = (-(c(103)*M(13))+c(102)*M(25)) * den(317)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,37)
  Gcoeff = (-(c(80)*M(19))+c(79)*M(25)) * den(6)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,38)
  Gcoeff = (-(c(84)*M(19))+c(83)*M(25)) * den(316)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,40)
  Gcoeff = (-(c(80)*M(13))+c(79)*M(25)) * den(6)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,38)
  Gcoeff = (-(c(84)*M(13))+c(83)*M(25)) * den(317)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,39)
  Gcoeff = (-(c(93)*M(2))+c(92)*(M(14)+M(20))-c(91)*M(26)) * den(6)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(103)*M(13)) * den(414)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,144)
  Gcoeff = (-(c(103)*M(13))) * den(417)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,145)
  Gcoeff = (c(103)*M(5)) * den(416)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,148)
  Gcoeff = (-(c(103)*M(5))) * den(419)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,149)
  Gcoeff = (-(c(80)*M(13))) * den(112)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(84)*M(13))) * den(417)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,147)
  Gcoeff = (-(c(80)*M(5))) * den(112)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(84)*M(5))) * den(419)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,150)
  Gcoeff = (-(c(93)*M(2))+c(92)*(M(6)+M(14))) * den(112)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,146)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(13)) * den(100)
  T3sum(1:35,218) = T3sum(1:35,218) + Gcoeff * G3tensor(:,118)
  Gcoeff = (c(69)*M(1)-c(68)*M(13)) * den(100)
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,120)
  Gcoeff = (c(20)*M(1)-c(19)*M(13)) * den(100)
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,122)
  Gcoeff = (c(68)*M(21)-c(69)*M(23)) * den(118)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(68)*M(21))+c(69)*M(23)) * den(118)
  T2sum(1:15,106) = T2sum(1:15,106) + Gcoeff * G2tensor(:,16)
  Gcoeff = (-(c(19)*M(21))+c(20)*M(23)) * den(118)
  T2sum(1:15,106) = T2sum(1:15,106) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(103)*M(5)) * den(420)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,151)
  Gcoeff = (-(c(103)*M(5))) * den(422)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,152)
  Gcoeff = (c(103)*M(21)) * den(421)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,153)
  Gcoeff = (-(c(103)*M(21))) * den(423)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,154)
  Gcoeff = (-(c(80)*M(5))) * den(120)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,155)
  Gcoeff = (-(c(84)*M(5))) * den(422)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,157)
  Gcoeff = (-(c(80)*M(21))) * den(120)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,155)
  Gcoeff = (-(c(84)*M(21))) * den(423)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,156)
  Gcoeff = (c(92)*(M(6)+M(22))-c(93)*M(24)) * den(120)
  T3sum(1:35,187) = T3sum(1:35,187) + Gcoeff * G3tensor(:,155)
  Gcoeff = (-(c(69)*M(7))+c(68)*M(21)) * den(748)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(69)*M(7)-c(68)*M(21)) * den(748)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(20)*M(7)-c(19)*M(21)) * den(748)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(69)*M(7))+c(68)*M(21)) * den(747)
  T3sum(1:35,232) = T3sum(1:35,232) + Gcoeff * G3tensor(:,158)
  Gcoeff = (c(69)*M(7)-c(68)*M(21)) * den(747)
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,159)
  Gcoeff = (c(20)*M(7)-c(19)*M(21)) * den(747)
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,160)
  Gcoeff = (c(103)*M(21)-c(102)*M(25)) * den(1160)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,65)
  Gcoeff = (-(c(103)*M(21))+c(102)*M(25)) * den(1161)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,66)
  Gcoeff = (-(c(102)*M(25))+c(103)*M(27)) * den(1162)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(102)*M(25)-c(103)*M(27)) * den(1163)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(80)*M(21))+c(79)*M(25)) * den(1164)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,69)
  Gcoeff = (-(c(84)*M(21))+c(83)*M(25)) * den(1161)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(79)*M(25)-c(80)*M(27)) * den(1164)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(83)*M(25)-c(84)*M(27)) * den(1163)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,71)
  Gcoeff = (-(c(93)*M(24))-c(91)*M(26)+c(92)*(M(22)+M(28))) * den(1164)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,69)
  Gcoeff = (-(c(102)*M(25))+c(103)*M(27)) * den(1171)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(102)*M(25)-c(103)*M(27)) * den(1172)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(103)*M(21)-c(102)*M(25)) * den(1173)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,74)
  Gcoeff = (-(c(103)*M(21))+c(102)*M(25)) * den(1174)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(79)*M(25)-c(80)*M(27)) * den(1175)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(83)*M(25)-c(84)*M(27)) * den(1172)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,77)
  Gcoeff = (-(c(80)*M(21))+c(79)*M(25)) * den(1175)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(84)*M(21))+c(83)*M(25)) * den(1174)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,78)
  Gcoeff = (-(c(93)*M(18))-c(91)*M(26)+c(92)*(M(22)+M(28))) * den(1175)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,76)
  Gcoeff = (-(c(69)*M(17))+c(68)*M(21)) * den(1183)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(69)*M(17)-c(68)*M(21)) * den(1183)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(20)*M(17)-c(19)*M(21)) * den(1183)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(64)*(-M(7)+M(17))) * den(1186)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(64)*(M(7)-M(17))) * den(1186)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(11)*(M(7)-M(17))) * den(1186)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(103)*M(11)) * den(448)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,161)
  Gcoeff = (-(c(103)*M(11))) * den(450)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,162)
  Gcoeff = (c(103)*M(3)) * den(449)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,165)
  Gcoeff = (-(c(103)*M(3))) * den(451)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,166)
  Gcoeff = (-(c(80)*M(11))) * den(167)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,163)
  Gcoeff = (-(c(84)*M(11))) * den(450)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,164)
  Gcoeff = (-(c(80)*M(3))) * den(167)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,163)
  Gcoeff = (-(c(84)*M(3))) * den(451)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,167)
  Gcoeff = (-(c(93)*M(8))+c(92)*(M(4)+M(12))) * den(167)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,163)
  Gcoeff = (-(c(69)*M(17))+c(68)*M(19)) * den(170)
  T2sum(1:15,234) = T2sum(1:15,234) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(69)*M(17)-c(68)*M(19)) * den(170)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(20)*M(17)-c(19)*M(19)) * den(170)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(103)*M(19)) * den(452)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,168)
  Gcoeff = (-(c(103)*M(19))) * den(454)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,169)
  Gcoeff = (c(103)*M(3)) * den(453)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,172)
  Gcoeff = (-(c(103)*M(3))) * den(455)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,173)
  Gcoeff = (-(c(80)*M(19))) * den(172)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,170)
  Gcoeff = (-(c(84)*M(19))) * den(454)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,171)
  Gcoeff = (-(c(80)*M(3))) * den(172)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,170)
  Gcoeff = (-(c(84)*M(3))) * den(455)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,174)
  Gcoeff = (-(c(93)*M(18))+c(92)*(M(4)+M(20))) * den(172)
  T3sum(1:35,191) = T3sum(1:35,191) + Gcoeff * G3tensor(:,170)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(19)) * den(844)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(69)*M(1)-c(68)*M(19)) * den(844)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(20)*M(1)-c(19)*M(19)) * den(844)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(19)) * den(843)
  T3sum(1:35,319) = T3sum(1:35,319) + Gcoeff * G3tensor(:,141)
  Gcoeff = (c(69)*M(1)-c(68)*M(19)) * den(843)
  T3sum(1:35,320) = T3sum(1:35,320) + Gcoeff * G3tensor(:,142)
  Gcoeff = (c(20)*M(1)-c(19)*M(19)) * den(843)
  T3sum(1:35,320) = T3sum(1:35,320) + Gcoeff * G3tensor(:,143)
  Gcoeff = (c(103)*M(19)-c(102)*M(25)) * den(1188)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,79)
  Gcoeff = (-(c(103)*M(19))+c(102)*M(25)) * den(1189)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,80)
  Gcoeff = (-(c(102)*M(25))+c(103)*M(27)) * den(1190)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,81)
  Gcoeff = (c(102)*M(25)-c(103)*M(27)) * den(1191)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,82)
  Gcoeff = (-(c(80)*M(19))+c(79)*M(25)) * den(1192)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(84)*M(19))+c(83)*M(25)) * den(1189)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(79)*M(25)-c(80)*M(27)) * den(1192)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(83)*M(25)-c(84)*M(27)) * den(1191)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,85)
  Gcoeff = (-(c(93)*M(18))-c(91)*M(26)+c(92)*(M(20)+M(28))) * den(1192)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,83)
  Gcoeff = (c(103)*M(19)-c(102)*M(25)) * den(1199)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,86)
  Gcoeff = (-(c(103)*M(19))+c(102)*M(25)) * den(1200)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,87)
  Gcoeff = (-(c(102)*M(25))+c(103)*M(27)) * den(1201)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(102)*M(25)-c(103)*M(27)) * den(1202)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,89)
  Gcoeff = (-(c(80)*M(19))+c(79)*M(25)) * den(1203)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(84)*M(19))+c(83)*M(25)) * den(1200)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(79)*M(25)-c(80)*M(27)) * den(1203)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(83)*M(25)-c(84)*M(27)) * den(1202)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,92)
  Gcoeff = (-(c(93)*M(24))-c(91)*M(26)+c(92)*(M(20)+M(28))) * den(1203)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,90)
  Gcoeff = (c(68)*M(19)-c(69)*M(23)) * den(1209)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(68)*M(19))+c(69)*M(23)) * den(1209)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,47)
  Gcoeff = (-(c(19)*M(19))+c(20)*M(23)) * den(1209)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(64)*(-M(1)+M(23))) * den(1214)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(64)*(M(1)-M(23))) * den(1214)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(11)*(M(1)-M(23))) * den(1214)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,51)
  Gcoeff = (-(c(103)*M(9))) * den(468)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,175)
  Gcoeff = (c(103)*M(9)) * den(470)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,176)
  Gcoeff = (-(c(103)*M(1))) * den(469)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,179)
  Gcoeff = (c(103)*M(1)) * den(471)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,180)
  Gcoeff = (c(80)*M(9)) * den(211)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,177)
  Gcoeff = (c(84)*M(9)) * den(470)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,178)
  Gcoeff = (c(80)*M(1)) * den(211)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,177)
  Gcoeff = (c(84)*M(1)) * den(471)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,181)
  Gcoeff = (c(93)*M(6)+c(92)*(-M(2)-M(10))) * den(211)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,177)
  Gcoeff = (-(c(68)*M(17))+c(69)*M(19)) * den(217)
  T2sum(1:15,234) = T2sum(1:15,234) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(68)*M(17)-c(69)*M(19)) * den(217)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(19)*M(17)-c(20)*M(19)) * den(217)
  T2sum(1:15,235) = T2sum(1:15,235) + Gcoeff * G2tensor(:,42)
  Gcoeff = (-(c(103)*M(1))) * den(472)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,182)
  Gcoeff = (c(103)*M(1)) * den(474)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,183)
  Gcoeff = (-(c(103)*M(17))) * den(473)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,184)
  Gcoeff = (c(103)*M(17)) * den(475)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,185)
  Gcoeff = (c(80)*M(1)) * den(219)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,186)
  Gcoeff = (c(84)*M(1)) * den(474)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,188)
  Gcoeff = (c(80)*M(17)) * den(219)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,186)
  Gcoeff = (c(84)*M(17)) * den(475)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,187)
  Gcoeff = (c(92)*(-M(2)-M(18))+c(93)*M(20)) * den(219)
  T3sum(1:35,76) = T3sum(1:35,76) + Gcoeff * G3tensor(:,186)
  Gcoeff = (c(69)*M(3)-c(68)*M(17)) * den(935)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(17)) * den(935)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(17)) * den(935)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(69)*M(3)-c(68)*M(17)) * den(934)
  T3sum(1:35,406) = T3sum(1:35,406) + Gcoeff * G3tensor(:,107)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(17)) * den(934)
  T3sum(1:35,407) = T3sum(1:35,407) + Gcoeff * G3tensor(:,108)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(17)) * den(934)
  T3sum(1:35,407) = T3sum(1:35,407) + Gcoeff * G3tensor(:,109)
  Gcoeff = (-(c(103)*M(17))+c(102)*M(27)) * den(1216)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(103)*M(17)-c(102)*M(27)) * den(1217)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,94)
  Gcoeff = (-(c(103)*M(25))+c(102)*M(27)) * den(1218)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(103)*M(25)-c(102)*M(27)) * den(1219)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(80)*M(17)-c(79)*M(27)) * den(1220)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(1217)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(80)*M(25)-c(79)*M(27)) * den(1220)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(84)*M(25)-c(83)*M(27)) * den(1219)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(93)*M(20)+c(92)*(-M(18)-M(26))+c(91)*M(28)) * den(1220)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,97)
  Gcoeff = (-(c(103)*M(25))+c(102)*M(27)) * den(1227)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(103)*M(25)-c(102)*M(27)) * den(1228)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,101)
  Gcoeff = (-(c(103)*M(17))+c(102)*M(27)) * den(1229)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(103)*M(17)-c(102)*M(27)) * den(1230)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,103)
  Gcoeff = (c(80)*M(25)-c(79)*M(27)) * den(1231)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(84)*M(25)-c(83)*M(27)) * den(1228)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(80)*M(17)-c(79)*M(27)) * den(1231)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(84)*M(17)-c(83)*M(27)) * den(1230)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,106)
  Gcoeff = (c(93)*M(22)+c(92)*(-M(18)-M(26))+c(91)*M(28)) * den(1231)
  T3sum(1:35,82) = T3sum(1:35,82) + Gcoeff * G3tensor(:,104)
  Gcoeff = (-(c(68)*M(17))+c(69)*M(21)) * den(1239)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(68)*M(17)-c(69)*M(21)) * den(1239)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(19)*M(17)-c(20)*M(21)) * den(1239)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,57)
  Gcoeff = (c(64)*(M(3)-M(21))) * den(1242)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(64)*(-M(3)+M(21))) * den(1242)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(11)*(-M(3)+M(21))) * den(1242)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(5)) * den(1353)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(68)*M(1)-c(69)*M(5)) * den(1353)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(19)*M(1)-c(20)*M(5)) * den(1353)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(69)*M(1))+c(68)*M(5)) * den(1360)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(69)*M(1)-c(68)*M(5)) * den(1360)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(20)*M(1)-c(19)*M(5)) * den(1360)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(68)*M(3)-c(69)*M(7)) * den(1376)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(7)) * den(1376)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(7)) * den(1376)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(69)*M(3)-c(68)*M(7)) * den(1380)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(69)*M(3))+c(68)*M(7)) * den(1380)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(20)*M(3))+c(19)*M(7)) * den(1380)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(68)*M(1))+c(69)*M(19)) * den(1396)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(68)*M(1)-c(69)*M(19)) * den(1396)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(19)*M(1)-c(20)*M(19)) * den(1396)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(68)*M(3)-c(69)*M(17)) * den(1403)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(68)*M(3))+c(69)*M(17)) * den(1403)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(19)*M(3))+c(20)*M(17)) * den(1403)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(68)*M(5)-c(69)*M(23)) * den(1416)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(68)*M(5))+c(69)*M(23)) * den(1416)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(19)*M(5))+c(20)*M(23)) * den(1416)
  T2sum(1:15,115) = T2sum(1:15,115) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(68)*M(7))+c(69)*M(21)) * den(1423)
  T2sum(1:15,178) = T2sum(1:15,178) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(68)*M(7)-c(69)*M(21)) * den(1423)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(19)*M(7)-c(20)*M(21)) * den(1423)
  T2sum(1:15,179) = T2sum(1:15,179) + Gcoeff * G2tensor(:,84)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_12

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_12_pptttt_ew_tttxtxgg_1_/**/REALKIND
