
module ol_vamp_11_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_11(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_ew_tttxtxbbx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_ew_tttxtxbbx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(12)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,63) :: G0
  complex(REALKIND), dimension(4,5,4,146) :: G1
  complex(REALKIND), dimension(15,84) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_QV_A(G0(:,:,:,1),wf(:,920),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,54),MT,G1(:,:,:,1))
  call loop_QV_A(G1(:,:,:,1),wf(:,79),G1(:,:,:,2))
  call check_last_Q_A(l_switch,G1(:,:,:,2),Q(:,63),MT,G2tensor(:,1))
  call loop_QV_A(G0(:,:,:,1),wf(:,920),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,54),MB,G1(:,:,:,3))
  call loop_QV_A(G1(:,:,:,3),wf(:,79),G1(:,:,:,4))
  call check_last_Q_A(l_switch,G1(:,:,:,4),Q(:,63),MB,G2tensor(:,2))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,919),Q(:,54),G1(:,:,:,5))
  call check_last_CV_D(l_switch,G1(:,:,:,5),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,3))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,920),Q(:,54),G1(:,:,:,6))
  call check_last_CV_D(l_switch,G1(:,:,:,6),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,4))
  call loop_QV_A(G0(:,:,:,1),wf(:,924),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,54),ZERO,G1(:,:,:,7))
  call loop_QV_A(G1(:,:,:,7),wf(:,79),G1(:,:,:,8))
  call check_last_Q_A(l_switch,G1(:,:,:,8),Q(:,63),ZERO,G2tensor(:,5))
  call loop_QV_A(G0(:,:,:,1),wf(:,924),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,54),MT,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,79),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),MT,G2tensor(:,6))
  call loop_QV_A(G0(:,:,:,1),wf(:,924),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,54),MB,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,79),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MB,G2tensor(:,7))
  call loop_QV_A(G0(:,:,:,1),wf(:,925),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,54),ZERO,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,79),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),ZERO,G2tensor(:,8))
  call loop_QV_A(G0(:,:,:,1),wf(:,925),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,54),MT,G1(:,:,:,15))
  call loop_QV_A(G1(:,:,:,15),wf(:,79),G1(:,:,:,16))
  call check_last_Q_A(l_switch,G1(:,:,:,16),Q(:,63),MT,G2tensor(:,9))
  call loop_QV_A(G0(:,:,:,1),wf(:,925),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,54),MB,G1(:,:,:,17))
  call loop_QV_A(G1(:,:,:,17),wf(:,79),G1(:,:,:,18))
  call check_last_Q_A(l_switch,G1(:,:,:,18),Q(:,63),MB,G2tensor(:,10))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,924),Q(:,54),G1(:,:,:,19))
  call check_last_CV_D(l_switch,G1(:,:,:,19),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,11))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,925),Q(:,54),G1(:,:,:,20))
  call check_last_CV_D(l_switch,G1(:,:,:,20),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,926),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,54),ZERO,G1(:,:,:,21))
  call loop_QV_A(G1(:,:,:,21),wf(:,79),G1(:,:,:,22))
  call check_last_Q_A(l_switch,G1(:,:,:,22),Q(:,63),ZERO,G2tensor(:,13))
  call loop_QV_A(G0(:,:,:,1),wf(:,926),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,54),MT,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,79),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),MT,G2tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,926),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,54),MB,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,79),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),MB,G2tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,928),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,54),ZERO,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,79),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),ZERO,G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,928),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,54),MT,G1(:,:,:,29))
  call loop_QV_A(G1(:,:,:,29),wf(:,79),G1(:,:,:,30))
  call check_last_Q_A(l_switch,G1(:,:,:,30),Q(:,63),MT,G2tensor(:,17))
  call loop_QV_A(G0(:,:,:,1),wf(:,928),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,54),MB,G1(:,:,:,31))
  call loop_QV_A(G1(:,:,:,31),wf(:,79),G1(:,:,:,32))
  call check_last_Q_A(l_switch,G1(:,:,:,32),Q(:,63),MB,G2tensor(:,18))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,926),Q(:,54),G1(:,:,:,33))
  call check_last_CV_D(l_switch,G1(:,:,:,33),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,19))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,928),Q(:,54),G1(:,:,:,34))
  call check_last_CV_D(l_switch,G1(:,:,:,34),Q(:,54),wf(:,79),Q(:,9),G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,855),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,53),ZERO,G1(:,:,:,35))
  call loop_QV_A(G1(:,:,:,35),wf(:,2),G1(:,:,:,36))
  call check_last_Q_A(l_switch,G1(:,:,:,36),Q(:,63),ZERO,G2tensor(:,21))
  call loop_QV_A(G0(:,:,:,1),wf(:,855),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,53),MT,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,2),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,63),MT,G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,855),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,53),MB,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,2),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),MB,G2tensor(:,23))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,855),Q(:,53),G1(:,:,:,41))
  call check_last_CV_D(l_switch,G1(:,:,:,41),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,856),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,53),ZERO,G1(:,:,:,42))
  call loop_QV_A(G1(:,:,:,42),wf(:,2),G1(:,:,:,43))
  call check_last_Q_A(l_switch,G1(:,:,:,43),Q(:,63),ZERO,G2tensor(:,25))
  call loop_QV_A(G0(:,:,:,1),wf(:,856),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,53),MT,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,2),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,63),MT,G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,856),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,53),MB,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,2),G1(:,:,:,47))
  call check_last_Q_A(l_switch,G1(:,:,:,47),Q(:,63),MB,G2tensor(:,27))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,856),Q(:,53),G1(:,:,:,48))
  call check_last_CV_D(l_switch,G1(:,:,:,48),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,857),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,53),ZERO,G1(:,:,:,49))
  call loop_QV_A(G1(:,:,:,49),wf(:,2),G1(:,:,:,50))
  call check_last_Q_A(l_switch,G1(:,:,:,50),Q(:,63),ZERO,G2tensor(:,29))
  call loop_QV_A(G0(:,:,:,1),wf(:,857),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,53),MT,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,2),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),MT,G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,857),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,53),MB,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,2),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),MB,G2tensor(:,31))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,857),Q(:,53),G1(:,:,:,55))
  call check_last_CV_D(l_switch,G1(:,:,:,55),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,858),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,53),ZERO,G1(:,:,:,56))
  call loop_QV_A(G1(:,:,:,56),wf(:,2),G1(:,:,:,57))
  call check_last_Q_A(l_switch,G1(:,:,:,57),Q(:,63),ZERO,G2tensor(:,33))
  call loop_QV_A(G0(:,:,:,1),wf(:,858),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,53),MT,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,2),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),MT,G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,858),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,53),MB,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,2),G1(:,:,:,61))
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,63),MB,G2tensor(:,35))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,858),Q(:,53),G1(:,:,:,62))
  call check_last_CV_D(l_switch,G1(:,:,:,62),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,871),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,53),ZERO,G1(:,:,:,63))
  call loop_QV_A(G1(:,:,:,63),wf(:,2),G1(:,:,:,64))
  call check_last_Q_A(l_switch,G1(:,:,:,64),Q(:,63),ZERO,G2tensor(:,37))
  call loop_QV_A(G0(:,:,:,1),wf(:,871),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,53),MT,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,2),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),MT,G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,871),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,53),MB,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,2),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),MB,G2tensor(:,39))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,871),Q(:,53),G1(:,:,:,69))
  call check_last_CV_D(l_switch,G1(:,:,:,69),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,872),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,53),ZERO,G1(:,:,:,70))
  call loop_QV_A(G1(:,:,:,70),wf(:,2),G1(:,:,:,71))
  call check_last_Q_A(l_switch,G1(:,:,:,71),Q(:,63),ZERO,G2tensor(:,41))
  call loop_QV_A(G0(:,:,:,1),wf(:,872),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,53),MT,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,2),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,63),MT,G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,872),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,53),MB,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,2),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),MB,G2tensor(:,43))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,872),Q(:,53),G1(:,:,:,76))
  call check_last_CV_D(l_switch,G1(:,:,:,76),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,875),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,53),ZERO,G1(:,:,:,77))
  call loop_QV_A(G1(:,:,:,77),wf(:,2),G1(:,:,:,78))
  call check_last_Q_A(l_switch,G1(:,:,:,78),Q(:,63),ZERO,G2tensor(:,45))
  call loop_QV_A(G0(:,:,:,1),wf(:,875),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,53),MT,G1(:,:,:,79))
  call loop_QV_A(G1(:,:,:,79),wf(:,2),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,63),MT,G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,875),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,53),MB,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,2),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,63),MB,G2tensor(:,47))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,875),Q(:,53),G1(:,:,:,83))
  call check_last_CV_D(l_switch,G1(:,:,:,83),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,876),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,53),ZERO,G1(:,:,:,84))
  call loop_QV_A(G1(:,:,:,84),wf(:,2),G1(:,:,:,85))
  call check_last_Q_A(l_switch,G1(:,:,:,85),Q(:,63),ZERO,G2tensor(:,49))
  call loop_QV_A(G0(:,:,:,1),wf(:,876),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,53),MT,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,2),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),MT,G2tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,876),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,53),MB,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,2),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),MB,G2tensor(:,51))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,876),Q(:,53),G1(:,:,:,90))
  call check_last_CV_D(l_switch,G1(:,:,:,90),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,887),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,53),ZERO,G1(:,:,:,91))
  call loop_QV_A(G1(:,:,:,91),wf(:,2),G1(:,:,:,92))
  call check_last_Q_A(l_switch,G1(:,:,:,92),Q(:,63),ZERO,G2tensor(:,53))
  call loop_QV_A(G0(:,:,:,1),wf(:,887),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,53),MT,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,2),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),MT,G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,887),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,53),MB,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,2),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),MB,G2tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,888),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,53),ZERO,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,2),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),ZERO,G2tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,888),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,53),MT,G1(:,:,:,99))
  call loop_QV_A(G1(:,:,:,99),wf(:,2),G1(:,:,:,100))
  call check_last_Q_A(l_switch,G1(:,:,:,100),Q(:,63),MT,G2tensor(:,57))
  call loop_QV_A(G0(:,:,:,1),wf(:,888),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,53),MB,G1(:,:,:,101))
  call loop_QV_A(G1(:,:,:,101),wf(:,2),G1(:,:,:,102))
  call check_last_Q_A(l_switch,G1(:,:,:,102),Q(:,63),MB,G2tensor(:,58))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,887),Q(:,53),G1(:,:,:,103))
  call check_last_CV_D(l_switch,G1(:,:,:,103),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,59))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,888),Q(:,53),G1(:,:,:,104))
  call check_last_CV_D(l_switch,G1(:,:,:,104),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,891),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,53),ZERO,G1(:,:,:,105))
  call loop_QV_A(G1(:,:,:,105),wf(:,2),G1(:,:,:,106))
  call check_last_Q_A(l_switch,G1(:,:,:,106),Q(:,63),ZERO,G2tensor(:,61))
  call loop_QV_A(G0(:,:,:,1),wf(:,891),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,53),MT,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,2),G1(:,:,:,108))
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,63),MT,G2tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,891),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,53),MB,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,2),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),MB,G2tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,892),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,53),ZERO,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,2),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),ZERO,G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,892),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,53),MT,G1(:,:,:,113))
  call loop_QV_A(G1(:,:,:,113),wf(:,2),G1(:,:,:,114))
  call check_last_Q_A(l_switch,G1(:,:,:,114),Q(:,63),MT,G2tensor(:,65))
  call loop_QV_A(G0(:,:,:,1),wf(:,892),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,53),MB,G1(:,:,:,115))
  call loop_QV_A(G1(:,:,:,115),wf(:,2),G1(:,:,:,116))
  call check_last_Q_A(l_switch,G1(:,:,:,116),Q(:,63),MB,G2tensor(:,66))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,891),Q(:,53),G1(:,:,:,117))
  call check_last_CV_D(l_switch,G1(:,:,:,117),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,67))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,892),Q(:,53),G1(:,:,:,118))
  call check_last_CV_D(l_switch,G1(:,:,:,118),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,896),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,53),ZERO,G1(:,:,:,119))
  call loop_QV_A(G1(:,:,:,119),wf(:,2),G1(:,:,:,120))
  call check_last_Q_A(l_switch,G1(:,:,:,120),Q(:,63),ZERO,G2tensor(:,69))
  call loop_QV_A(G0(:,:,:,1),wf(:,896),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,53),MT,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,2),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),MT,G2tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,896),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,53),MB,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,2),G1(:,:,:,124))
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),MB,G2tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,897),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,53),ZERO,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,2),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),ZERO,G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,897),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,53),MT,G1(:,:,:,127))
  call loop_QV_A(G1(:,:,:,127),wf(:,2),G1(:,:,:,128))
  call check_last_Q_A(l_switch,G1(:,:,:,128),Q(:,63),MT,G2tensor(:,73))
  call loop_QV_A(G0(:,:,:,1),wf(:,897),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,53),MB,G1(:,:,:,129))
  call loop_QV_A(G1(:,:,:,129),wf(:,2),G1(:,:,:,130))
  call check_last_Q_A(l_switch,G1(:,:,:,130),Q(:,63),MB,G2tensor(:,74))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,896),Q(:,53),G1(:,:,:,131))
  call check_last_CV_D(l_switch,G1(:,:,:,131),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,75))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,897),Q(:,53),G1(:,:,:,132))
  call check_last_CV_D(l_switch,G1(:,:,:,132),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,898),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,53),ZERO,G1(:,:,:,133))
  call loop_QV_A(G1(:,:,:,133),wf(:,2),G1(:,:,:,134))
  call check_last_Q_A(l_switch,G1(:,:,:,134),Q(:,63),ZERO,G2tensor(:,77))
  call loop_QV_A(G0(:,:,:,1),wf(:,898),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,53),MT,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,2),G1(:,:,:,136))
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,63),MT,G2tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,898),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,53),MB,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,2),G1(:,:,:,138))
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,63),MB,G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,900),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,53),ZERO,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,2),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),ZERO,G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,900),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,53),MT,G1(:,:,:,141))
  call loop_QV_A(G1(:,:,:,141),wf(:,2),G1(:,:,:,142))
  call check_last_Q_A(l_switch,G1(:,:,:,142),Q(:,63),MT,G2tensor(:,81))
  call loop_QV_A(G0(:,:,:,1),wf(:,900),G0(:,:,:,63))
  call loop_Q_A(G0(:,:,:,63),Q(:,53),MB,G1(:,:,:,143))
  call loop_QV_A(G1(:,:,:,143),wf(:,2),G1(:,:,:,144))
  call check_last_Q_A(l_switch,G1(:,:,:,144),Q(:,63),MB,G2tensor(:,82))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,898),Q(:,53),G1(:,:,:,145))
  call check_last_CV_D(l_switch,G1(:,:,:,145),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,83))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,900),Q(:,53),G1(:,:,:,146))
  call check_last_CV_D(l_switch,G1(:,:,:,146),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,84))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(139)*M(9)-c(140)*M(11)) * den(749)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(139)*M(9)-c(140)*M(11)) * den(749)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,2)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(750)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(749)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,4)
  Gcoeff = (-(c(70)*M(8))-c(61)*M(10)+c(66)*(M(6)+M(12))) * den(750)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,3)
  Gcoeff = (-(c(165)*M(9))+c(166)*M(11)) * den(751)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(163)*M(9))+c(164)*M(11)) * den(751)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(165)*M(9))+c(166)*M(11)) * den(751)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(163)*M(9))+c(164)*M(11)) * den(751)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(165)*M(9))+c(166)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(163)*M(9))+c(164)*M(11)) * den(752)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(165)*M(9))+c(166)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(163)*M(9))+c(164)*M(11)) * den(752)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(113)*M(9))+c(116)*M(11)) * den(751)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(113)*M(9))+c(116)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(135)*M(9))+c(136)*M(11)) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(133)*M(9))+c(134)*M(11)) * den(753)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(135)*M(9))+c(136)*M(11)) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(133)*M(9))+c(134)*M(11)) * den(753)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(141)*M(9)-c(142)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(139)*M(9)-c(140)*M(11)) * den(752)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(141)*M(9)-c(142)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(139)*M(9)-c(140)*M(11)) * den(752)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(152)*M(2))-c(149)*M(10)+c(151)*(M(6)+M(12))) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(148)*M(2))-c(145)*M(10)+c(147)*(M(6)+M(12))) * den(753)
  T2sum(1:15,403) = T2sum(1:15,403) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(152)*M(2))-c(149)*M(10)+c(151)*(M(6)+M(12))) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,13)
  Gcoeff = (-(c(148)*M(2))-c(145)*M(10)+c(147)*(M(6)+M(12))) * den(753)
  T2sum(1:15,404) = T2sum(1:15,404) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(19)*M(9))+c(22)*M(11)) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(41)*M(9)-c(44)*M(11)) * den(752)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,20)
  Gcoeff = (-(c(70)*M(2))-c(61)*M(10)+c(66)*(M(6)+M(12))) * den(753)
  T2sum(1:15,393) = T2sum(1:15,393) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(159)*M(1)-c(160)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(157)*M(1)-c(158)*M(5)) * den(754)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(159)*M(1)-c(160)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(157)*M(1)-c(158)*M(5)) * den(754)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(95)*M(1)-c(98)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(155)*M(1)-c(156)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(153)*M(1)-c(154)*M(5)) * den(754)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(155)*M(1)-c(156)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(153)*M(1)-c(154)*M(5)) * den(754)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(81)*M(1)-c(84)*M(5)) * den(754)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(159)*M(1)-c(160)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(157)*M(1)-c(158)*M(5)) * den(755)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(159)*M(1)-c(160)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(157)*M(1)-c(158)*M(5)) * den(755)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(95)*M(1)-c(98)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(155)*M(1)-c(156)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(153)*M(1)-c(154)*M(5)) * den(755)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(155)*M(1)-c(156)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(153)*M(1)-c(154)*M(5)) * den(755)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(81)*M(1)-c(84)*M(5)) * den(755)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(159)*M(1)-c(160)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(157)*M(1)-c(158)*M(3)) * den(756)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(159)*M(1)-c(160)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(157)*M(1)-c(158)*M(3)) * den(756)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(95)*M(1)-c(98)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(155)*M(1)-c(156)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(153)*M(1)-c(154)*M(3)) * den(756)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(155)*M(1)-c(156)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(153)*M(1)-c(154)*M(3)) * den(756)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(81)*M(1)-c(84)*M(3)) * den(756)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(159)*M(1)-c(160)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(157)*M(1)-c(158)*M(3)) * den(757)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(159)*M(1)-c(160)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(157)*M(1)-c(158)*M(3)) * den(757)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(95)*M(1)-c(98)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(155)*M(1)-c(156)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(153)*M(1)-c(154)*M(3)) * den(757)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(155)*M(1)-c(156)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(153)*M(1)-c(154)*M(3)) * den(757)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(81)*M(1)-c(84)*M(3)) * den(757)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(761)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(761)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(761)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(761)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(762)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(762)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(116)*M(9))+c(113)*M(11)) * den(761)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(116)*M(9))+c(113)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(763)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,62)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(763)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(762)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(762)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(152)*M(4)+c(151)*(-M(2)-M(10))+c(149)*M(12)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(148)*M(4)+c(147)*(-M(2)-M(10))+c(145)*M(12)) * den(763)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(152)*M(4)+c(151)*(-M(2)-M(10))+c(149)*M(12)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(148)*M(4)+c(147)*(-M(2)-M(10))+c(145)*M(12)) * den(763)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,63)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(762)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(70)*M(4)+c(66)*(-M(2)-M(10))+c(61)*M(12)) * den(763)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(767)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(767)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(767)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(767)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(768)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(166)*M(9))+c(165)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(164)*M(9))+c(163)*M(11)) * den(768)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(116)*M(9))+c(113)*M(11)) * den(767)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(116)*M(9))+c(113)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(769)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(136)*M(9))+c(135)*M(11)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(134)*M(9))+c(133)*M(11)) * den(769)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(768)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(142)*M(9)-c(141)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(140)*M(9)-c(139)*M(11)) * den(768)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(152)*M(6)+c(151)*(-M(2)-M(10))+c(149)*M(12)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(148)*M(6)+c(147)*(-M(2)-M(10))+c(145)*M(12)) * den(769)
  T2sum(1:15,397) = T2sum(1:15,397) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(152)*M(6)+c(151)*(-M(2)-M(10))+c(149)*M(12)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(148)*M(6)+c(147)*(-M(2)-M(10))+c(145)*M(12)) * den(769)
  T2sum(1:15,398) = T2sum(1:15,398) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(22)*M(9))+c(19)*M(11)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(44)*M(9)-c(41)*M(11)) * den(768)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(70)*M(6)+c(66)*(-M(2)-M(10))+c(61)*M(12)) * den(769)
  T2sum(1:15,391) = T2sum(1:15,391) + Gcoeff * G2tensor(:,83)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_11

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_11_pptttt_ew_tttxtxbbx_1_/**/REALKIND
