
module ol_colourmatrix_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,12), KL(12,12)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  2,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(  3,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  4,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(  5,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  6,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(  7,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  8,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(  9,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 10,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1( 11,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 12,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]
  K1( 13,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 14,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 15,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 16,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 17,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 18,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 19,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 20,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 21,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 22,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 23,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 24,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 25,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1( 26,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 27,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1( 28,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1( 29,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1( 30,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1( 31,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1( 32,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1( 33,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1( 34,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1( 35,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1( 36,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1( 37,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 38,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 39,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 40,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 41,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 42,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 43,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 44,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 45,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 46,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 47,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 48,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 49,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1( 51,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1( 52,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1( 53,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1( 54,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1( 55,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1( 56,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1( 57,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1( 58,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1( 59,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1( 60,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1( 61,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1( 62,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1( 63,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1( 64,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1( 65,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1( 66,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1( 67,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1( 68,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1( 69,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1( 70,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1( 71,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1( 72,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1( 73,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 74,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 75,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 76,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 77,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 78,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 79,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 80,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 81,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 82,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 83,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 84,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 85,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1( 86,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1( 87,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1( 88,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1( 89,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1( 90,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1( 91,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1( 92,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1( 93,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1( 94,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1( 95,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1( 96,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1( 97,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1( 98,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 99,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(100,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(101,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(102,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(103,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1(104,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1(105,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(106,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(107,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(108,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(109,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(110,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(111,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(112,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(113,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(114,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(115,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(116,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(117,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(118,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(120,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(121,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(122,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(123,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(124,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(125,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(126,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(127,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(128,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(129,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(130,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(131,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(132,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(133,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1(134,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1(136,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1(137,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(138,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(139,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1(140,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1(141,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1(142,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1(143,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1(144,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1(145,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(146,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(147,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(148,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(149,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1(150,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1(151,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1(152,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1(153,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1(154,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1(155,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1(156,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1(157,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(158,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(159,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(160,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(161,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(162,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(163,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(164,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(165,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1(166,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1(167,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(168,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(169,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1(170,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1(171,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(172,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(173,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1(174,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1(175,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(176,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(177,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(178,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(179,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(180,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(181,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(182,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(183,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(184,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(185,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(186,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(187,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(188,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(189,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(190,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(191,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(192,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(193,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(194,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(195,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(196,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(197,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(198,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(199,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1(200,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1(201,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(202,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(203,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(204,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(205,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1(206,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1(207,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1(208,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1(209,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(210,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(211,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1(212,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1(213,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(214,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(215,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1(216,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1(217,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1(218,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1(219,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1(220,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1(221,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(222,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(223,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(224,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(225,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(226,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(227,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(228,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(229,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1(230,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1(231,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1(232,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1(233,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1(234,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1(235,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(236,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(237,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1(238,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1(239,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(240,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(241,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1(242,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1(243,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1(244,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1(245,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1(246,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1(247,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(248,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(249,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1(250,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1(251,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(252,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(253,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(254,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(255,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(256,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(257,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(258,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(259,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(260,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(261,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(262,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(263,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(264,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(265,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(266,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(267,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(268,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(269,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(270,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(271,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(272,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(273,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(274,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1(275,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(276,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]

  K2( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  K2( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  K2( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  K2( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  K2( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  K2( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  K2( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  K2( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  K2( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  K2(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  K2(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  K2(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]

  KL( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  KL( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  KL( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  KL( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  KL( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  KL( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  KL( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  KL( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  KL( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  KL(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  KL(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  KL(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_ew_uuxtttxtx_1_/**/REALKIND



module ol_forced_parameters_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_ew_uuxtttxtx_1_/**/REALKIND

module ol_loop_pptttt_ew_uuxtttxtx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(58), c(102)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:536)
  ! denominators
  complex(REALKIND), save :: den(491)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(12,64), Mct(12,64), Mcol_loop(12,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 2) = CI*eQED**2*gQCD**2
    f( 3) = CI*gQCD**4
    f( 4) = gQCD**4
    f( 5) = (4*CI*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 6) = CI*countertermnorm*eQED**2*gQCD**4
    f( 7) = countertermnorm*eQED**2*gQCD**4
    f( 8) = (4*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 9) = CI*countertermnorm*ctGqq*eQED**2*gQCD**4
    f(10) = (4*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(11) = CI*countertermnorm*ctGtt*eQED**2*gQCD**4
    f(12) = (4*CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f(13) = CI*countertermnorm*ctVqq*eQED**2*gQCD**4
    f(14) = (4*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(15) = CI*countertermnorm*ctVtt*eQED**2*gQCD**4
    f(16) = countertermnorm*ctZGG*eQED**2*gQCD**4
    f(17) = CI*countertermnorm*gQCD**6
    f(18) = countertermnorm*gQCD**6
    f(19) = CI*countertermnorm*ctGqq*gQCD**6
    f(20) = countertermnorm*ctGqq*gQCD**6
    f(21) = CI*countertermnorm*ctGtt*gQCD**6
    f(22) = countertermnorm*ctGtt*gQCD**6
    f(23) = countertermnorm*ctVVV*gQCD**6
    f(24) = (CI*eQED**2*gQCD**2*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(25) = (CI*countertermnorm*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(26) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(27) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(28) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(29) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(30) = (4*CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(31) = CI*eQED**2*gQCD**4*integralnorm*SwB
    f(32) = (2*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(33) = (4*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(34) = (eQED**2*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f(35) = eQED**2*gQCD**4*integralnorm*SwB
    f(36) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(37) = CI*gQCD**6*integralnorm*SwB
    f(38) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(39) = gQCD**6*integralnorm*SwB
    f(40) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(41) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(42) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(43) = (eQED**2*gQCD**4*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(44) = (CI*eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(45) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*8._/**/REALKIND)
    f(46) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(47) = (2*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(48) = (4*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(49) = (8*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(50) = eQED**2*gQCD**4*integralnorm*SwF
    f(51) = 2*eQED**2*gQCD**4*integralnorm*SwF
    f(52) = CI*gQCD**6*integralnorm*SwF
    f(53) = 2*CI*gQCD**6*integralnorm*SwF
    f(54) = gQCD**6*integralnorm*SwF
    f(55) = 2*gQCD**6*integralnorm*SwF
    f(56) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(57) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(58) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*2._/**/REALKIND)

  c = [ 54*CI*f(30), 162*CI*f(30), 54*CI*f(31), 162*CI*f(31), 108*f(32), 324*f(32), 6*f(33), 18*f(33), 36*f(33), 48*f(33) &
    , 54*f(33), 60*f(33), 108*f(33), 126*f(33), 144*f(33), 324*f(33), 108*f(34), 324*f(34), 6*f(35), 18*f(35), 36*f(35), 48*f(35) &
    , 54*f(35), 60*f(35), 108*f(35), 126*f(35), 144*f(35), 324*f(35), 81*CI*f(36), 162*CI*f(36), 9*CI*f(37), 27*CI*f(37) &
    , 72*CI*f(37), 81*CI*f(37), 162*CI*f(37), 18*f(38), 54*f(38), 162*f(38), f(39), 3*f(39), 6*f(39), 8*f(39), 9*f(39), 10*f(39) &
    , 18*f(39), 21*f(39), 24*f(39), 27*f(39), 30*f(39), 54*f(39), 63*f(39), 72*f(39), 81*f(39), 162*f(39), 54*CI*f(40), 6*f(41) &
    , 18*f(41), 54*f(41), 54*CI*f(42), 6*f(43), 18*f(43), 54*f(43), 54*CI*f(44), 162*CI*f(44), 108*f(45), 324*f(45), 6*f(46) &
    , 18*f(46), 36*f(46), 48*f(46), 54*f(46), 60*f(46), 108*f(46), 126*f(46), 144*f(46), 324*f(46), 18*f(47), 54*f(47), 18*f(48) &
    , 54*f(48), 18*f(49), 54*f(49), 18*f(50), 54*f(50), 18*f(51), 54*f(51), 27*CI*f(52), 27*CI*f(53), 3*f(54), 6*f(54), 9*f(54) &
    , 27*f(54), 3*f(55), 6*f(55), 9*f(55), 27*f(55), 18*f(56), 54*f(56), 18*f(57), 54*f(57), 18*f(58), 54*f(58) ]
  c = (1._/**/REALKIND / 216) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(12), M2(12)
  complex(REALKIND) :: A(636)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), POLSEL(1))
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_Q(P(:,3), rMT, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_Q(P(:,4), rMT, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_A(P(:,5), rMT, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_A(P(:,6), rMT, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rZERO, H(1), wf(:,0), 0)
    call pol_wf_A(P(:,2), rZERO, H(2), wf(:,-1), 0)
    call pol_wf_Q(P(:,3), rMT, H(3), wf(:,-2), 0)
    call pol_wf_Q(P(:,4), rMT, H(4), wf(:,-3), 0)
    call pol_wf_A(P(:,5), rMT, H(5), wf(:,-4), 0)
    call pol_wf_A(P(:,6), rMT, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-1),wf(:,1))
  call vert_QA_V(wf(:,-2),wf(:,-4),wf(:,2))
  call vert_QA_V(wf(:,-3),wf(:,-5),wf(:,3))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,2),Q(:,20),wf(:,4))
  call vert_AQ_S(gH,wf(:,-4),wf(:,-2),wf(:,5))
  call vert_VQ_A(wf(:,1),wf(:,-3),wf(:,6))
  call vert_SA_Q(gH,wf(:,5),wf(:,-5),wf(:,7))
  call prop_Q_A(wf(:,6),Q(:,11),MT,1_intkind1,wf(:,8))
  call vert_AQ_S(gX,wf(:,-4),wf(:,-2),wf(:,9))
  call vert_SA_Q(gX,wf(:,9),wf(:,-5),wf(:,10))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,11))
  call vert_QA_Z(gZu,wf(:,0),wf(:,-1),wf(:,12))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,-3),wf(:,13))
  call prop_Q_A(wf(:,13),Q(:,11),MT,1_intkind1,wf(:,14))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,-4),wf(:,15))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,15),wf(:,16))
  call vert_QS_A(gH,wf(:,-3),wf(:,5),wf(:,17))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,28),MT,1_intkind1,wf(:,19))
  call vert_QS_A(gX,wf(:,-3),wf(:,9),wf(:,20))
  call prop_Q_A(wf(:,20),Q(:,28),MT,1_intkind1,wf(:,21))
  call vert_VQ_A(wf(:,2),wf(:,-3),wf(:,22))
  call prop_Q_A(wf(:,22),Q(:,28),MT,1_intkind1,wf(:,23))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,12),wf(:,24))
  call vert_ZQ_A(gZu,wf(:,15),wf(:,-3),wf(:,25))
  call prop_Q_A(wf(:,25),Q(:,28),MT,1_intkind1,wf(:,26))
  call vert_QA_V(wf(:,-2),wf(:,-5),wf(:,27))
  call vert_QA_V(wf(:,-3),wf(:,-4),wf(:,28))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,27),Q(:,36),wf(:,29))
  call vert_AQ_S(gH,wf(:,-4),wf(:,-3),wf(:,30))
  call vert_VQ_A(wf(:,1),wf(:,-2),wf(:,31))
  call vert_SA_Q(gH,wf(:,30),wf(:,-5),wf(:,32))
  call prop_Q_A(wf(:,31),Q(:,7),MT,1_intkind1,wf(:,33))
  call vert_AQ_S(gX,wf(:,-4),wf(:,-3),wf(:,34))
  call vert_SA_Q(gX,wf(:,34),wf(:,-5),wf(:,35))
  call vert_AV_Q(wf(:,-5),wf(:,28),wf(:,36))
  call vert_ZQ_A(gZu,wf(:,12),wf(:,-2),wf(:,37))
  call prop_Q_A(wf(:,37),Q(:,7),MT,1_intkind1,wf(:,38))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,-4),wf(:,39))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,39),wf(:,40))
  call vert_QS_A(gH,wf(:,-2),wf(:,30),wf(:,41))
  call prop_Q_A(wf(:,41),Q(:,28),MT,1_intkind1,wf(:,42))
  call vert_QS_A(gX,wf(:,-2),wf(:,34),wf(:,43))
  call prop_Q_A(wf(:,43),Q(:,28),MT,1_intkind1,wf(:,44))
  call vert_VQ_A(wf(:,28),wf(:,-2),wf(:,45))
  call prop_Q_A(wf(:,45),Q(:,28),MT,1_intkind1,wf(:,46))
  call vert_ZQ_A(gZu,wf(:,39),wf(:,-2),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,28),MT,1_intkind1,wf(:,48))
  call vert_AQ_S(gH,wf(:,-5),wf(:,-2),wf(:,49))
  call vert_SA_Q(gH,wf(:,49),wf(:,-4),wf(:,50))
  call vert_AQ_S(gX,wf(:,-5),wf(:,-2),wf(:,51))
  call vert_SA_Q(gX,wf(:,51),wf(:,-4),wf(:,52))
  call vert_AV_Q(wf(:,-4),wf(:,27),wf(:,53))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,-5),wf(:,54))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,54),wf(:,55))
  call vert_QS_A(gH,wf(:,-3),wf(:,49),wf(:,56))
  call vert_AV_Q(wf(:,-4),wf(:,1),wf(:,57))
  call prop_Q_A(wf(:,56),Q(:,44),MT,1_intkind1,wf(:,58))
  call vert_QS_A(gX,wf(:,-3),wf(:,51),wf(:,59))
  call prop_Q_A(wf(:,59),Q(:,44),MT,1_intkind1,wf(:,60))
  call vert_VQ_A(wf(:,27),wf(:,-3),wf(:,61))
  call prop_Q_A(wf(:,61),Q(:,44),MT,1_intkind1,wf(:,62))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,12),wf(:,63))
  call vert_ZQ_A(gZu,wf(:,54),wf(:,-3),wf(:,64))
  call prop_Q_A(wf(:,64),Q(:,44),MT,1_intkind1,wf(:,65))
  call vert_AQ_S(gH,wf(:,-5),wf(:,-3),wf(:,66))
  call vert_SA_Q(gH,wf(:,66),wf(:,-4),wf(:,67))
  call vert_AQ_S(gX,wf(:,-5),wf(:,-3),wf(:,68))
  call vert_SA_Q(gX,wf(:,68),wf(:,-4),wf(:,69))
  call vert_AV_Q(wf(:,-4),wf(:,3),wf(:,70))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,-5),wf(:,71))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,71),wf(:,72))
  call vert_QS_A(gH,wf(:,-2),wf(:,66),wf(:,73))
  call prop_Q_A(wf(:,73),Q(:,44),MT,1_intkind1,wf(:,74))
  call vert_QS_A(gX,wf(:,-2),wf(:,68),wf(:,75))
  call prop_Q_A(wf(:,75),Q(:,44),MT,1_intkind1,wf(:,76))
  call vert_VQ_A(wf(:,3),wf(:,-2),wf(:,77))
  call prop_Q_A(wf(:,77),Q(:,44),MT,1_intkind1,wf(:,78))
  call vert_ZQ_A(gZu,wf(:,71),wf(:,-2),wf(:,79))
  call prop_Q_A(wf(:,79),Q(:,44),MT,1_intkind1,wf(:,80))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,81))
  call vert_AV_Q(wf(:,-1),wf(:,3),wf(:,82))
  call prop_Q_A(wf(:,81),Q(:,21),ZERO,0_intkind1,wf(:,83))
  call vert_ZQ_A(gZu,wf(:,15),wf(:,0),wf(:,84))
  call prop_Q_A(wf(:,84),Q(:,21),ZERO,0_intkind1,wf(:,85))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,71),wf(:,86))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,87))
  call vert_AV_Q(wf(:,-1),wf(:,2),wf(:,88))
  call prop_Q_A(wf(:,87),Q(:,41),ZERO,0_intkind1,wf(:,89))
  call vert_ZQ_A(gZu,wf(:,71),wf(:,0),wf(:,90))
  call prop_Q_A(wf(:,90),Q(:,41),ZERO,0_intkind1,wf(:,91))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,15),wf(:,92))
  call vert_VQ_A(wf(:,27),wf(:,0),wf(:,93))
  call vert_AV_Q(wf(:,-1),wf(:,28),wf(:,94))
  call prop_Q_A(wf(:,93),Q(:,37),ZERO,0_intkind1,wf(:,95))
  call vert_ZQ_A(gZu,wf(:,54),wf(:,0),wf(:,96))
  call prop_Q_A(wf(:,96),Q(:,37),ZERO,0_intkind1,wf(:,97))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,39),wf(:,98))
  call vert_VQ_A(wf(:,28),wf(:,0),wf(:,99))
  call vert_AV_Q(wf(:,-1),wf(:,27),wf(:,100))
  call prop_Q_A(wf(:,99),Q(:,25),ZERO,0_intkind1,wf(:,101))
  call vert_ZQ_A(gZu,wf(:,39),wf(:,0),wf(:,102))
  call prop_Q_A(wf(:,102),Q(:,25),ZERO,0_intkind1,wf(:,103))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,54),wf(:,104))
  call counter_SG_G(wf(:,5),wf(:,1),wf(:,105))
  call counter_GG_S(wf(:,1),wf(:,2),wf(:,106))
  call counter_VG_G(wf(:,12),wf(:,2),Q(:,20),wf(:,107),Q(:,23))
  call counter_VG_G(wf(:,15),wf(:,1),Q(:,3),wf(:,108),Q(:,23))
  call counter_GG_V(wf(:,1),Q(:,3),wf(:,2),Q(:,20),wf(:,109))
  call counter_UV_W(wf(:,1),Q(:,3),wf(:,2),Q(:,20),wf(:,110))
  call counter_SA_Q(gH,wf(:,5),wf(:,-5),wf(:,111))
  call counter_SA_Q(gX,wf(:,9),wf(:,-5),wf(:,112))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,113))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,15),wf(:,114))
  call counter_AV_Q_LR(EWctGtt,wf(:,-5),wf(:,2),wf(:,115))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,116))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,12),wf(:,117))
  call counter_AV_Q_LR(EWctGtt,wf(:,-5),wf(:,1),wf(:,118))
  call counter_SG_G(wf(:,49),wf(:,1),wf(:,119))
  call counter_GG_S(wf(:,1),wf(:,27),wf(:,120))
  call counter_VG_G(wf(:,12),wf(:,27),Q(:,36),wf(:,121),Q(:,39))
  call counter_VG_G(wf(:,54),wf(:,1),Q(:,3),wf(:,122),Q(:,39))
  call counter_GG_V(wf(:,1),Q(:,3),wf(:,27),Q(:,36),wf(:,123))
  call counter_UV_W(wf(:,1),Q(:,3),wf(:,27),Q(:,36),wf(:,124))
  call counter_SA_Q(gH,wf(:,30),wf(:,-5),wf(:,125))
  call counter_SA_Q(gX,wf(:,34),wf(:,-5),wf(:,126))
  call counter_AV_Q(wf(:,-5),wf(:,28),wf(:,127))
  call counter_AZ_Q(gZu,wf(:,-5),wf(:,39),wf(:,128))
  call counter_AV_Q_LR(EWctGtt,wf(:,-5),wf(:,28),wf(:,129))
  call counter_SA_Q(gH,wf(:,49),wf(:,-4),wf(:,130))
  call counter_SA_Q(gX,wf(:,51),wf(:,-4),wf(:,131))
  call counter_AV_Q(wf(:,-4),wf(:,27),wf(:,132))
  call counter_AZ_Q(gZu,wf(:,-4),wf(:,54),wf(:,133))
  call counter_AV_Q_LR(EWctGtt,wf(:,-4),wf(:,27),wf(:,134))
  call counter_AV_Q(wf(:,-4),wf(:,1),wf(:,135))
  call counter_AZ_Q(gZu,wf(:,-4),wf(:,12),wf(:,136))
  call counter_AV_Q_LR(EWctGtt,wf(:,-4),wf(:,1),wf(:,137))
  call counter_SA_Q(gH,wf(:,66),wf(:,-4),wf(:,138))
  call counter_SA_Q(gX,wf(:,68),wf(:,-4),wf(:,139))
  call counter_AV_Q(wf(:,-4),wf(:,3),wf(:,140))
  call counter_AZ_Q(gZu,wf(:,-4),wf(:,71),wf(:,141))
  call counter_AV_Q_LR(EWctGtt,wf(:,-4),wf(:,3),wf(:,142))
  call counter_QS_A(gH,wf(:,-3),wf(:,5),wf(:,143))
  call prop_A_Q(wf(:,18),Q(:,35),MT,1_intkind1,wf(:,144))
  call counter_QS_A(gX,wf(:,-3),wf(:,9),wf(:,145))
  call counter_VQ_A(wf(:,2),wf(:,-3),wf(:,146))
  call prop_A_Q(wf(:,24),Q(:,35),MT,1_intkind1,wf(:,147))
  call counter_ZQ_A(gZu,wf(:,15),wf(:,-3),wf(:,148))
  call counter_VQ_A_LR(EWctGtt,wf(:,2),wf(:,-3),wf(:,149))
  call counter_VQ_A(wf(:,1),wf(:,-3),wf(:,150))
  call prop_A_Q(wf(:,7),Q(:,52),MT,1_intkind1,wf(:,151))
  call prop_A_Q(wf(:,10),Q(:,52),MT,1_intkind1,wf(:,152))
  call prop_A_Q(wf(:,11),Q(:,52),MT,1_intkind1,wf(:,153))
  call counter_ZQ_A(gZu,wf(:,12),wf(:,-3),wf(:,154))
  call prop_A_Q(wf(:,16),Q(:,52),MT,1_intkind1,wf(:,155))
  call counter_VQ_A_LR(EWctGtt,wf(:,1),wf(:,-3),wf(:,156))
  call counter_QA_V(wf(:,-3),wf(:,-5),wf(:,157))
  call counter_QA_V_LR(EWctGtt,wf(:,-3),wf(:,-5),wf(:,158))
  call counter_QS_A(gH,wf(:,-3),wf(:,49),wf(:,159))
  call prop_A_Q(wf(:,57),Q(:,19),MT,1_intkind1,wf(:,160))
  call counter_QS_A(gX,wf(:,-3),wf(:,51),wf(:,161))
  call counter_VQ_A(wf(:,27),wf(:,-3),wf(:,162))
  call prop_A_Q(wf(:,63),Q(:,19),MT,1_intkind1,wf(:,163))
  call counter_ZQ_A(gZu,wf(:,54),wf(:,-3),wf(:,164))
  call counter_VQ_A_LR(EWctGtt,wf(:,27),wf(:,-3),wf(:,165))
  call prop_A_Q(wf(:,50),Q(:,52),MT,1_intkind1,wf(:,166))
  call prop_A_Q(wf(:,52),Q(:,52),MT,1_intkind1,wf(:,167))
  call prop_A_Q(wf(:,53),Q(:,52),MT,1_intkind1,wf(:,168))
  call prop_A_Q(wf(:,55),Q(:,52),MT,1_intkind1,wf(:,169))
  call counter_AQ_S(gH,wf(:,-5),wf(:,-3),wf(:,170))
  call vert_SA_Q(gH,wf(:,170),wf(:,-4),wf(:,171))
  call counter_AQ_S(gX,wf(:,-5),wf(:,-3),wf(:,172))
  call vert_SA_Q(gX,wf(:,172),wf(:,-4),wf(:,173))
  call vert_AV_Q(wf(:,-4),wf(:,157),wf(:,174))
  call counter_QA_Z(gZu,wf(:,-3),wf(:,-5),wf(:,175))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,175),wf(:,176))
  call vert_AV_Q(wf(:,-4),wf(:,158),wf(:,177))
  call vert_QS_A(gH,wf(:,-2),wf(:,170),wf(:,178))
  call prop_Q_A(wf(:,178),Q(:,44),MT,1_intkind1,wf(:,179))
  call vert_QS_A(gX,wf(:,-2),wf(:,172),wf(:,180))
  call prop_Q_A(wf(:,180),Q(:,44),MT,1_intkind1,wf(:,181))
  call vert_VQ_A(wf(:,157),wf(:,-2),wf(:,182))
  call prop_Q_A(wf(:,182),Q(:,44),MT,1_intkind1,wf(:,183))
  call vert_ZQ_A(gZu,wf(:,175),wf(:,-2),wf(:,184))
  call prop_Q_A(wf(:,184),Q(:,44),MT,1_intkind1,wf(:,185))
  call vert_VQ_A(wf(:,158),wf(:,-2),wf(:,186))
  call prop_Q_A(wf(:,186),Q(:,44),MT,1_intkind1,wf(:,187))
  call counter_QA_V(wf(:,-3),wf(:,-4),wf(:,188))
  call counter_QA_V_LR(EWctGtt,wf(:,-3),wf(:,-4),wf(:,189))
  call counter_AQ_S(gH,wf(:,-4),wf(:,-3),wf(:,190))
  call vert_SA_Q(gH,wf(:,190),wf(:,-5),wf(:,191))
  call counter_AQ_S(gX,wf(:,-4),wf(:,-3),wf(:,192))
  call vert_SA_Q(gX,wf(:,192),wf(:,-5),wf(:,193))
  call vert_AV_Q(wf(:,-5),wf(:,188),wf(:,194))
  call counter_QA_Z(gZu,wf(:,-3),wf(:,-4),wf(:,195))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,195),wf(:,196))
  call vert_AV_Q(wf(:,-5),wf(:,189),wf(:,197))
  call vert_QS_A(gH,wf(:,-2),wf(:,190),wf(:,198))
  call prop_Q_A(wf(:,198),Q(:,28),MT,1_intkind1,wf(:,199))
  call vert_QS_A(gX,wf(:,-2),wf(:,192),wf(:,200))
  call prop_Q_A(wf(:,200),Q(:,28),MT,1_intkind1,wf(:,201))
  call vert_VQ_A(wf(:,188),wf(:,-2),wf(:,202))
  call prop_Q_A(wf(:,202),Q(:,28),MT,1_intkind1,wf(:,203))
  call vert_ZQ_A(gZu,wf(:,195),wf(:,-2),wf(:,204))
  call prop_Q_A(wf(:,204),Q(:,28),MT,1_intkind1,wf(:,205))
  call vert_VQ_A(wf(:,189),wf(:,-2),wf(:,206))
  call prop_Q_A(wf(:,206),Q(:,28),MT,1_intkind1,wf(:,207))
  call counter_QS_A(gH,wf(:,-2),wf(:,30),wf(:,208))
  call counter_QS_A(gX,wf(:,-2),wf(:,34),wf(:,209))
  call counter_VQ_A(wf(:,28),wf(:,-2),wf(:,210))
  call counter_ZQ_A(gZu,wf(:,39),wf(:,-2),wf(:,211))
  call counter_VQ_A_LR(EWctGtt,wf(:,28),wf(:,-2),wf(:,212))
  call counter_VQ_A(wf(:,1),wf(:,-2),wf(:,213))
  call prop_A_Q(wf(:,32),Q(:,56),MT,1_intkind1,wf(:,214))
  call prop_A_Q(wf(:,35),Q(:,56),MT,1_intkind1,wf(:,215))
  call prop_A_Q(wf(:,36),Q(:,56),MT,1_intkind1,wf(:,216))
  call counter_ZQ_A(gZu,wf(:,12),wf(:,-2),wf(:,217))
  call prop_A_Q(wf(:,40),Q(:,56),MT,1_intkind1,wf(:,218))
  call counter_VQ_A_LR(EWctGtt,wf(:,1),wf(:,-2),wf(:,219))
  call counter_QA_V(wf(:,-2),wf(:,-5),wf(:,220))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,220),Q(:,36),wf(:,221))
  call counter_QA_V_LR(EWctGtt,wf(:,-2),wf(:,-5),wf(:,222))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,222),Q(:,36),wf(:,223))
  call counter_QS_A(gH,wf(:,-2),wf(:,66),wf(:,224))
  call counter_QS_A(gX,wf(:,-2),wf(:,68),wf(:,225))
  call counter_VQ_A(wf(:,3),wf(:,-2),wf(:,226))
  call counter_ZQ_A(gZu,wf(:,71),wf(:,-2),wf(:,227))
  call counter_VQ_A_LR(EWctGtt,wf(:,3),wf(:,-2),wf(:,228))
  call prop_A_Q(wf(:,67),Q(:,56),MT,1_intkind1,wf(:,229))
  call prop_A_Q(wf(:,69),Q(:,56),MT,1_intkind1,wf(:,230))
  call prop_A_Q(wf(:,70),Q(:,56),MT,1_intkind1,wf(:,231))
  call prop_A_Q(wf(:,72),Q(:,56),MT,1_intkind1,wf(:,232))
  call counter_AQ_S(gH,wf(:,-5),wf(:,-2),wf(:,233))
  call vert_SA_Q(gH,wf(:,233),wf(:,-4),wf(:,234))
  call counter_AQ_S(gX,wf(:,-5),wf(:,-2),wf(:,235))
  call vert_SA_Q(gX,wf(:,235),wf(:,-4),wf(:,236))
  call vert_AV_Q(wf(:,-4),wf(:,220),wf(:,237))
  call counter_QA_Z(gZu,wf(:,-2),wf(:,-5),wf(:,238))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,238),wf(:,239))
  call vert_AV_Q(wf(:,-4),wf(:,222),wf(:,240))
  call vert_QS_A(gH,wf(:,-3),wf(:,233),wf(:,241))
  call prop_Q_A(wf(:,241),Q(:,44),MT,1_intkind1,wf(:,242))
  call vert_QS_A(gX,wf(:,-3),wf(:,235),wf(:,243))
  call prop_Q_A(wf(:,243),Q(:,44),MT,1_intkind1,wf(:,244))
  call vert_VQ_A(wf(:,220),wf(:,-3),wf(:,245))
  call prop_Q_A(wf(:,245),Q(:,44),MT,1_intkind1,wf(:,246))
  call vert_ZQ_A(gZu,wf(:,238),wf(:,-3),wf(:,247))
  call prop_Q_A(wf(:,247),Q(:,44),MT,1_intkind1,wf(:,248))
  call vert_VQ_A(wf(:,222),wf(:,-3),wf(:,249))
  call prop_Q_A(wf(:,249),Q(:,44),MT,1_intkind1,wf(:,250))
  call counter_QA_V(wf(:,-2),wf(:,-4),wf(:,251))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,251),Q(:,20),wf(:,252))
  call counter_QA_V_LR(EWctGtt,wf(:,-2),wf(:,-4),wf(:,253))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,253),Q(:,20),wf(:,254))
  call counter_AQ_S(gH,wf(:,-4),wf(:,-2),wf(:,255))
  call vert_SA_Q(gH,wf(:,255),wf(:,-5),wf(:,256))
  call counter_AQ_S(gX,wf(:,-4),wf(:,-2),wf(:,257))
  call vert_SA_Q(gX,wf(:,257),wf(:,-5),wf(:,258))
  call vert_AV_Q(wf(:,-5),wf(:,251),wf(:,259))
  call counter_QA_Z(gZu,wf(:,-2),wf(:,-4),wf(:,260))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,260),wf(:,261))
  call vert_AV_Q(wf(:,-5),wf(:,253),wf(:,262))
  call vert_QS_A(gH,wf(:,-3),wf(:,255),wf(:,263))
  call prop_Q_A(wf(:,263),Q(:,28),MT,1_intkind1,wf(:,264))
  call vert_QS_A(gX,wf(:,-3),wf(:,257),wf(:,265))
  call prop_Q_A(wf(:,265),Q(:,28),MT,1_intkind1,wf(:,266))
  call vert_VQ_A(wf(:,251),wf(:,-3),wf(:,267))
  call prop_Q_A(wf(:,267),Q(:,28),MT,1_intkind1,wf(:,268))
  call vert_ZQ_A(gZu,wf(:,260),wf(:,-3),wf(:,269))
  call prop_Q_A(wf(:,269),Q(:,28),MT,1_intkind1,wf(:,270))
  call vert_VQ_A(wf(:,253),wf(:,-3),wf(:,271))
  call prop_Q_A(wf(:,271),Q(:,28),MT,1_intkind1,wf(:,272))
  call vert_AV_Q(wf(:,-1),wf(:,157),wf(:,273))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,175),wf(:,274))
  call vert_AV_Q(wf(:,-1),wf(:,158),wf(:,275))
  call vert_VQ_A(wf(:,157),wf(:,0),wf(:,276))
  call prop_Q_A(wf(:,276),Q(:,41),ZERO,0_intkind1,wf(:,277))
  call vert_ZQ_A(gZu,wf(:,175),wf(:,0),wf(:,278))
  call prop_Q_A(wf(:,278),Q(:,41),ZERO,0_intkind1,wf(:,279))
  call vert_VQ_A(wf(:,158),wf(:,0),wf(:,280))
  call prop_Q_A(wf(:,280),Q(:,41),ZERO,0_intkind1,wf(:,281))
  call vert_AV_Q(wf(:,-1),wf(:,188),wf(:,282))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,195),wf(:,283))
  call vert_AV_Q(wf(:,-1),wf(:,189),wf(:,284))
  call vert_VQ_A(wf(:,188),wf(:,0),wf(:,285))
  call prop_Q_A(wf(:,285),Q(:,25),ZERO,0_intkind1,wf(:,286))
  call vert_ZQ_A(gZu,wf(:,195),wf(:,0),wf(:,287))
  call prop_Q_A(wf(:,287),Q(:,25),ZERO,0_intkind1,wf(:,288))
  call vert_VQ_A(wf(:,189),wf(:,0),wf(:,289))
  call prop_Q_A(wf(:,289),Q(:,25),ZERO,0_intkind1,wf(:,290))
  call vert_AV_Q(wf(:,-1),wf(:,220),wf(:,291))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,238),wf(:,292))
  call vert_AV_Q(wf(:,-1),wf(:,222),wf(:,293))
  call vert_VQ_A(wf(:,220),wf(:,0),wf(:,294))
  call prop_Q_A(wf(:,294),Q(:,37),ZERO,0_intkind1,wf(:,295))
  call vert_ZQ_A(gZu,wf(:,238),wf(:,0),wf(:,296))
  call prop_Q_A(wf(:,296),Q(:,37),ZERO,0_intkind1,wf(:,297))
  call vert_VQ_A(wf(:,222),wf(:,0),wf(:,298))
  call prop_Q_A(wf(:,298),Q(:,37),ZERO,0_intkind1,wf(:,299))
  call vert_AV_Q(wf(:,-1),wf(:,251),wf(:,300))
  call vert_AZ_Q(gZu,wf(:,-1),wf(:,260),wf(:,301))
  call vert_AV_Q(wf(:,-1),wf(:,253),wf(:,302))
  call vert_VQ_A(wf(:,251),wf(:,0),wf(:,303))
  call prop_Q_A(wf(:,303),Q(:,21),ZERO,0_intkind1,wf(:,304))
  call vert_ZQ_A(gZu,wf(:,260),wf(:,0),wf(:,305))
  call prop_Q_A(wf(:,305),Q(:,21),ZERO,0_intkind1,wf(:,306))
  call vert_VQ_A(wf(:,253),wf(:,0),wf(:,307))
  call prop_Q_A(wf(:,307),Q(:,21),ZERO,0_intkind1,wf(:,308))
  call counter_AV_Q(wf(:,-1),wf(:,3),wf(:,309))
  call counter_AZ_Q(gZu,wf(:,-1),wf(:,71),wf(:,310))
  call counter_AV_Q_LR(EWctGuu,wf(:,-1),wf(:,3),wf(:,311))
  call counter_AV_Q(wf(:,-1),wf(:,2),wf(:,312))
  call counter_AZ_Q(gZu,wf(:,-1),wf(:,15),wf(:,313))
  call counter_AV_Q_LR(EWctGuu,wf(:,-1),wf(:,2),wf(:,314))
  call counter_AV_Q(wf(:,-1),wf(:,28),wf(:,315))
  call counter_AZ_Q(gZu,wf(:,-1),wf(:,39),wf(:,316))
  call counter_AV_Q_LR(EWctGuu,wf(:,-1),wf(:,28),wf(:,317))
  call counter_AV_Q(wf(:,-1),wf(:,27),wf(:,318))
  call counter_AZ_Q(gZu,wf(:,-1),wf(:,54),wf(:,319))
  call counter_AV_Q_LR(EWctGuu,wf(:,-1),wf(:,27),wf(:,320))
  call counter_VQ_A(wf(:,2),wf(:,0),wf(:,321))
  call prop_A_Q(wf(:,82),Q(:,42),ZERO,0_intkind1,wf(:,322))
  call counter_ZQ_A(gZu,wf(:,15),wf(:,0),wf(:,323))
  call prop_A_Q(wf(:,86),Q(:,42),ZERO,0_intkind1,wf(:,324))
  call counter_VQ_A_LR(EWctGuu,wf(:,2),wf(:,0),wf(:,325))
  call counter_VQ_A(wf(:,3),wf(:,0),wf(:,326))
  call prop_A_Q(wf(:,88),Q(:,22),ZERO,0_intkind1,wf(:,327))
  call counter_ZQ_A(gZu,wf(:,71),wf(:,0),wf(:,328))
  call prop_A_Q(wf(:,92),Q(:,22),ZERO,0_intkind1,wf(:,329))
  call counter_VQ_A_LR(EWctGuu,wf(:,3),wf(:,0),wf(:,330))
  call counter_VQ_A(wf(:,27),wf(:,0),wf(:,331))
  call prop_A_Q(wf(:,94),Q(:,26),ZERO,0_intkind1,wf(:,332))
  call counter_ZQ_A(gZu,wf(:,54),wf(:,0),wf(:,333))
  call prop_A_Q(wf(:,98),Q(:,26),ZERO,0_intkind1,wf(:,334))
  call counter_VQ_A_LR(EWctGuu,wf(:,27),wf(:,0),wf(:,335))
  call counter_VQ_A(wf(:,28),wf(:,0),wf(:,336))
  call prop_A_Q(wf(:,100),Q(:,38),ZERO,0_intkind1,wf(:,337))
  call counter_ZQ_A(gZu,wf(:,39),wf(:,0),wf(:,338))
  call prop_A_Q(wf(:,104),Q(:,38),ZERO,0_intkind1,wf(:,339))
  call counter_VQ_A_LR(EWctGuu,wf(:,28),wf(:,0),wf(:,340))
  call counter_QA_V(wf(:,0),wf(:,-1),wf(:,341))
  call vert_UV_W(wf(:,341),Q(:,3),wf(:,2),Q(:,20),wf(:,342))
  call counter_QA_V_LR(EWctGuu,wf(:,0),wf(:,-1),wf(:,343))
  call vert_UV_W(wf(:,343),Q(:,3),wf(:,2),Q(:,20),wf(:,344))
  call vert_VQ_A(wf(:,341),wf(:,-3),wf(:,345))
  call prop_Q_A(wf(:,345),Q(:,11),MT,1_intkind1,wf(:,346))
  call counter_QA_Z(gZu,wf(:,0),wf(:,-1),wf(:,347))
  call vert_ZQ_A(gZu,wf(:,347),wf(:,-3),wf(:,348))
  call prop_Q_A(wf(:,348),Q(:,11),MT,1_intkind1,wf(:,349))
  call vert_VQ_A(wf(:,343),wf(:,-3),wf(:,350))
  call prop_Q_A(wf(:,350),Q(:,11),MT,1_intkind1,wf(:,351))
  call vert_AV_Q(wf(:,-5),wf(:,341),wf(:,352))
  call vert_AZ_Q(gZu,wf(:,-5),wf(:,347),wf(:,353))
  call vert_AV_Q(wf(:,-5),wf(:,343),wf(:,354))
  call vert_UV_W(wf(:,341),Q(:,3),wf(:,27),Q(:,36),wf(:,355))
  call vert_UV_W(wf(:,343),Q(:,3),wf(:,27),Q(:,36),wf(:,356))
  call vert_VQ_A(wf(:,341),wf(:,-2),wf(:,357))
  call prop_Q_A(wf(:,357),Q(:,7),MT,1_intkind1,wf(:,358))
  call vert_ZQ_A(gZu,wf(:,347),wf(:,-2),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,7),MT,1_intkind1,wf(:,360))
  call vert_VQ_A(wf(:,343),wf(:,-2),wf(:,361))
  call prop_Q_A(wf(:,361),Q(:,7),MT,1_intkind1,wf(:,362))
  call vert_AV_Q(wf(:,-4),wf(:,341),wf(:,363))
  call vert_AZ_Q(gZu,wf(:,-4),wf(:,347),wf(:,364))
  call vert_AV_Q(wf(:,-4),wf(:,343),wf(:,365))
  call vert_UV_W(wf(:,2),Q(:,20),wf(:,3),Q(:,40),wf(:,366))
  call counter_V_V(ctGG,21,wf(:,1),Q(:,3),wf(:,367))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,3),Q(:,40),wf(:,368))
  call counter_V_V(ctGG,21,wf(:,2),Q(:,20),wf(:,369))
  call counter_V_V(ctGG,21,wf(:,3),Q(:,40),wf(:,370))
  call vert_VQ_A(wf(:,367),wf(:,-3),wf(:,371))
  call vert_AV_Q(wf(:,-5),wf(:,367),wf(:,372))
  call vert_VQ_A(wf(:,369),wf(:,-3),wf(:,373))
  call vert_AV_Q(wf(:,-5),wf(:,369),wf(:,374))
  call counter_Q_A(cttt,6,wf(:,8),Q(:,11),wf(:,375))
  call counter_Q_A(cttt,6,wf(:,14),Q(:,11),wf(:,376))
  call counter_Q_A_LR(EWcttt,wf(:,8),Q(:,11),wf(:,377))
  call counter_Q_A(cttt,6,wf(:,19),Q(:,28),wf(:,378))
  call counter_Q_A(cttt,6,wf(:,21),Q(:,28),wf(:,379))
  call counter_Q_A(cttt,6,wf(:,23),Q(:,28),wf(:,380))
  call counter_Q_A(cttt,6,wf(:,26),Q(:,28),wf(:,381))
  call counter_Q_A_LR(EWcttt,wf(:,23),Q(:,28),wf(:,382))
  call vert_UV_W(wf(:,28),Q(:,24),wf(:,27),Q(:,36),wf(:,383))
  call vert_UV_W(wf(:,1),Q(:,3),wf(:,28),Q(:,24),wf(:,384))
  call counter_V_V(ctGG,21,wf(:,27),Q(:,36),wf(:,385))
  call counter_V_V(ctGG,21,wf(:,28),Q(:,24),wf(:,386))
  call vert_VQ_A(wf(:,367),wf(:,-2),wf(:,387))
  call vert_VQ_A(wf(:,386),wf(:,-2),wf(:,388))
  call counter_Q_A(cttt,6,wf(:,33),Q(:,7),wf(:,389))
  call counter_Q_A(cttt,6,wf(:,38),Q(:,7),wf(:,390))
  call counter_Q_A_LR(EWcttt,wf(:,33),Q(:,7),wf(:,391))
  call counter_Q_A(cttt,6,wf(:,42),Q(:,28),wf(:,392))
  call counter_Q_A(cttt,6,wf(:,44),Q(:,28),wf(:,393))
  call counter_Q_A(cttt,6,wf(:,46),Q(:,28),wf(:,394))
  call counter_Q_A(cttt,6,wf(:,48),Q(:,28),wf(:,395))
  call counter_Q_A_LR(EWcttt,wf(:,46),Q(:,28),wf(:,396))
  call vert_AV_Q(wf(:,-5),wf(:,386),wf(:,397))
  call vert_AV_Q(wf(:,-4),wf(:,367),wf(:,398))
  call vert_VQ_A(wf(:,385),wf(:,-3),wf(:,399))
  call vert_AV_Q(wf(:,-4),wf(:,385),wf(:,400))
  call counter_Q_A(cttt,6,wf(:,58),Q(:,44),wf(:,401))
  call counter_Q_A(cttt,6,wf(:,60),Q(:,44),wf(:,402))
  call counter_Q_A(cttt,6,wf(:,62),Q(:,44),wf(:,403))
  call counter_Q_A(cttt,6,wf(:,65),Q(:,44),wf(:,404))
  call counter_Q_A_LR(EWcttt,wf(:,62),Q(:,44),wf(:,405))
  call vert_VQ_A(wf(:,370),wf(:,-2),wf(:,406))
  call counter_Q_A(cttt,6,wf(:,74),Q(:,44),wf(:,407))
  call counter_Q_A(cttt,6,wf(:,76),Q(:,44),wf(:,408))
  call counter_Q_A(cttt,6,wf(:,78),Q(:,44),wf(:,409))
  call counter_Q_A(cttt,6,wf(:,80),Q(:,44),wf(:,410))
  call counter_Q_A_LR(EWcttt,wf(:,78),Q(:,44),wf(:,411))
  call vert_AV_Q(wf(:,-4),wf(:,370),wf(:,412))
  call counter_Q_A(ctqq,2,wf(:,83),Q(:,21),wf(:,413))
  call counter_Q_A(ctqq,2,wf(:,85),Q(:,21),wf(:,414))
  call counter_Q_A_LR(EWctuu,wf(:,83),Q(:,21),wf(:,415))
  call counter_Q_A(ctqq,2,wf(:,89),Q(:,41),wf(:,416))
  call counter_Q_A(ctqq,2,wf(:,91),Q(:,41),wf(:,417))
  call counter_Q_A_LR(EWctuu,wf(:,89),Q(:,41),wf(:,418))
  call vert_VQ_A(wf(:,369),wf(:,0),wf(:,419))
  call vert_VQ_A(wf(:,370),wf(:,0),wf(:,420))
  call vert_AV_Q(wf(:,-1),wf(:,369),wf(:,421))
  call vert_AV_Q(wf(:,-1),wf(:,370),wf(:,422))
  call counter_Q_A(ctqq,2,wf(:,95),Q(:,37),wf(:,423))
  call counter_Q_A(ctqq,2,wf(:,97),Q(:,37),wf(:,424))
  call counter_Q_A_LR(EWctuu,wf(:,95),Q(:,37),wf(:,425))
  call counter_Q_A(ctqq,2,wf(:,101),Q(:,25),wf(:,426))
  call counter_Q_A(ctqq,2,wf(:,103),Q(:,25),wf(:,427))
  call counter_Q_A_LR(EWctuu,wf(:,101),Q(:,25),wf(:,428))
  call vert_VQ_A(wf(:,385),wf(:,0),wf(:,429))
  call vert_VQ_A(wf(:,386),wf(:,0),wf(:,430))
  call vert_AV_Q(wf(:,-1),wf(:,385),wf(:,431))
  call vert_AV_Q(wf(:,-1),wf(:,386),wf(:,432))
  call vert_AQ_S(gH,wf(:,-4),wf(:,33),wf(:,433))
  call vert_AQ_S(gX,wf(:,-4),wf(:,33),wf(:,434))
  call vert_QA_V(wf(:,33),wf(:,-4),wf(:,435))
  call vert_QA_V(wf(:,38),wf(:,-4),wf(:,436))
  call vert_QA_Z(gZu,wf(:,33),wf(:,-4),wf(:,437))
  call vert_AQ_S(gH,wf(:,-5),wf(:,33),wf(:,438))
  call vert_AQ_S(gX,wf(:,-5),wf(:,33),wf(:,439))
  call vert_QA_V(wf(:,33),wf(:,-5),wf(:,440))
  call vert_QA_V(wf(:,38),wf(:,-5),wf(:,441))
  call vert_QA_Z(gZu,wf(:,33),wf(:,-5),wf(:,442))
  call vert_AQ_S(gH,wf(:,-4),wf(:,8),wf(:,443))
  call vert_AQ_S(gX,wf(:,-4),wf(:,8),wf(:,444))
  call vert_QA_V(wf(:,8),wf(:,-4),wf(:,445))
  call vert_QA_V(wf(:,14),wf(:,-4),wf(:,446))
  call vert_QA_Z(gZu,wf(:,8),wf(:,-4),wf(:,447))
  call vert_AQ_S(gH,wf(:,-5),wf(:,8),wf(:,448))
  call vert_AQ_S(gX,wf(:,-5),wf(:,8),wf(:,449))
  call vert_QA_V(wf(:,8),wf(:,-5),wf(:,450))
  call vert_QA_V(wf(:,14),wf(:,-5),wf(:,451))
  call vert_QA_Z(gZu,wf(:,8),wf(:,-5),wf(:,452))
  call vert_AQ_S(gH,wf(:,160),wf(:,-2),wf(:,453))
  call vert_AQ_S(gX,wf(:,160),wf(:,-2),wf(:,454))
  call vert_QA_V(wf(:,-2),wf(:,160),wf(:,455))
  call vert_QA_V(wf(:,-2),wf(:,163),wf(:,456))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,160),wf(:,457))
  call vert_AQ_S(gH,wf(:,160),wf(:,-3),wf(:,458))
  call vert_AQ_S(gX,wf(:,160),wf(:,-3),wf(:,459))
  call vert_QA_V(wf(:,-3),wf(:,160),wf(:,460))
  call vert_QA_V(wf(:,-3),wf(:,163),wf(:,461))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,160),wf(:,462))
  call vert_AQ_S(gH,wf(:,144),wf(:,-2),wf(:,463))
  call vert_AQ_S(gX,wf(:,144),wf(:,-2),wf(:,464))
  call vert_QA_V(wf(:,-2),wf(:,144),wf(:,465))
  call vert_QA_V(wf(:,-2),wf(:,147),wf(:,466))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,144),wf(:,467))
  call vert_AQ_S(gH,wf(:,144),wf(:,-3),wf(:,468))
  call vert_AQ_S(gX,wf(:,144),wf(:,-3),wf(:,469))
  call vert_QA_V(wf(:,-3),wf(:,144),wf(:,470))
  call vert_QA_V(wf(:,-3),wf(:,147),wf(:,471))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,144),wf(:,472))
  call vert_QA_V(wf(:,83),wf(:,-1),wf(:,473))
  call vert_QA_V(wf(:,85),wf(:,-1),wf(:,474))
  call vert_QA_Z(gZu,wf(:,83),wf(:,-1),wf(:,475))
  call vert_QA_V(wf(:,0),wf(:,327),wf(:,476))
  call vert_QA_Z(gZu,wf(:,0),wf(:,327),wf(:,477))
  call vert_QA_V(wf(:,0),wf(:,329),wf(:,478))
  call vert_QA_V(wf(:,19),wf(:,-5),wf(:,479))
  call vert_QA_V(wf(:,21),wf(:,-5),wf(:,480))
  call vert_QA_V(wf(:,23),wf(:,-5),wf(:,481))
  call vert_QA_V(wf(:,26),wf(:,-5),wf(:,482))
  call vert_QA_Z(gZu,wf(:,23),wf(:,-5),wf(:,483))
  call vert_QA_V(wf(:,-3),wf(:,151),wf(:,484))
  call vert_QA_V(wf(:,-3),wf(:,152),wf(:,485))
  call vert_QA_V(wf(:,-3),wf(:,153),wf(:,486))
  call vert_QA_V(wf(:,-3),wf(:,155),wf(:,487))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,153),wf(:,488))
  call vert_QA_V(wf(:,101),wf(:,-1),wf(:,489))
  call vert_QA_V(wf(:,103),wf(:,-1),wf(:,490))
  call vert_QA_Z(gZu,wf(:,101),wf(:,-1),wf(:,491))
  call vert_QA_V(wf(:,0),wf(:,332),wf(:,492))
  call vert_QA_Z(gZu,wf(:,0),wf(:,332),wf(:,493))
  call vert_QA_V(wf(:,0),wf(:,334),wf(:,494))
  call vert_QA_V(wf(:,42),wf(:,-5),wf(:,495))
  call vert_QA_V(wf(:,44),wf(:,-5),wf(:,496))
  call vert_QA_V(wf(:,46),wf(:,-5),wf(:,497))
  call vert_QA_V(wf(:,48),wf(:,-5),wf(:,498))
  call vert_QA_Z(gZu,wf(:,46),wf(:,-5),wf(:,499))
  call vert_QA_V(wf(:,-2),wf(:,214),wf(:,500))
  call vert_QA_V(wf(:,-2),wf(:,215),wf(:,501))
  call vert_QA_V(wf(:,-2),wf(:,216),wf(:,502))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,216),wf(:,503))
  call vert_QA_V(wf(:,-2),wf(:,218),wf(:,504))
  call vert_QA_V(wf(:,95),wf(:,-1),wf(:,505))
  call vert_QA_V(wf(:,97),wf(:,-1),wf(:,506))
  call vert_QA_Z(gZu,wf(:,95),wf(:,-1),wf(:,507))
  call vert_QA_V(wf(:,0),wf(:,337),wf(:,508))
  call vert_QA_Z(gZu,wf(:,0),wf(:,337),wf(:,509))
  call vert_QA_V(wf(:,0),wf(:,339),wf(:,510))
  call vert_QA_V(wf(:,58),wf(:,-4),wf(:,511))
  call vert_QA_V(wf(:,60),wf(:,-4),wf(:,512))
  call vert_QA_V(wf(:,62),wf(:,-4),wf(:,513))
  call vert_QA_V(wf(:,65),wf(:,-4),wf(:,514))
  call vert_QA_Z(gZu,wf(:,62),wf(:,-4),wf(:,515))
  call vert_QA_V(wf(:,-3),wf(:,166),wf(:,516))
  call vert_QA_V(wf(:,-3),wf(:,167),wf(:,517))
  call vert_QA_V(wf(:,-3),wf(:,168),wf(:,518))
  call vert_QA_V(wf(:,-3),wf(:,169),wf(:,519))
  call vert_QA_Z(gZu,wf(:,-3),wf(:,168),wf(:,520))
  call vert_QA_V(wf(:,89),wf(:,-1),wf(:,521))
  call vert_QA_V(wf(:,91),wf(:,-1),wf(:,522))
  call vert_QA_Z(gZu,wf(:,89),wf(:,-1),wf(:,523))
  call vert_QA_V(wf(:,0),wf(:,322),wf(:,524))
  call vert_QA_Z(gZu,wf(:,0),wf(:,322),wf(:,525))
  call vert_QA_V(wf(:,0),wf(:,324),wf(:,526))
  call vert_QA_V(wf(:,74),wf(:,-4),wf(:,527))
  call vert_QA_V(wf(:,76),wf(:,-4),wf(:,528))
  call vert_QA_V(wf(:,78),wf(:,-4),wf(:,529))
  call vert_QA_V(wf(:,80),wf(:,-4),wf(:,530))
  call vert_QA_Z(gZu,wf(:,78),wf(:,-4),wf(:,531))
  call vert_QA_V(wf(:,-2),wf(:,229),wf(:,532))
  call vert_QA_V(wf(:,-2),wf(:,230),wf(:,533))
  call vert_QA_V(wf(:,-2),wf(:,231),wf(:,534))
  call vert_QA_Z(gZu,wf(:,-2),wf(:,231),wf(:,535))
  call vert_QA_V(wf(:,-2),wf(:,232),wf(:,536))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,3))
  den(2) = 1 / (Q(5,20))
  den(3) = 1 / (Q(5,40))
  den(6) = 1 / (Q(5,20) - MH2)
  den(7) = 1 / (Q(5,11) - MT2)
  den(10) = 1 / (Q(5,20) - MZ2)
  den(13) = 1 / (Q(5,3) - MZ2)
  den(16) = 1 / (Q(5,28) - MT2)
  den(24) = 1 / (Q(5,36))
  den(25) = 1 / (Q(5,24))
  den(28) = 1 / (Q(5,24) - MH2)
  den(29) = 1 / (Q(5,7) - MT2)
  den(32) = 1 / (Q(5,24) - MZ2)
  den(44) = 1 / (Q(5,36) - MH2)
  den(46) = 1 / (Q(5,36) - MZ2)
  den(50) = 1 / (Q(5,44) - MT2)
  den(58) = 1 / (Q(5,40) - MH2)
  den(60) = 1 / (Q(5,40) - MZ2)
  den(71) = 1 / (Q(5,21))
  den(77) = 1 / (Q(5,41))
  den(83) = 1 / (Q(5,37))
  den(89) = 1 / (Q(5,25))
  den(111) = 1 / (Q(5,35) - MT2)
  den(118) = 1 / (Q(5,52) - MT2)
  den(126) = 1 / (Q(5,19) - MT2)
  den(144) = 1 / (Q(5,56) - MT2)
  den(163) = 1 / (Q(5,42))
  den(169) = 1 / (Q(5,22))
  den(175) = 1 / (Q(5,26))
  den(181) = 1 / (Q(5,38))
  den(188) = 1 / (Q(5,60))
  den(192) = 1 / (Q(5,43))
  den(195) = 1 / (Q(5,23))
  den(222) = 1 / (Q(5,27))
  den(225) = 1 / (Q(5,39))
  den(313) = 1 / (Q(5,23) - MH2)
  den(315) = 1 / (Q(5,23) - MZ2)
  den(319) = 1 / (Q(5,39) - MH2)
  den(321) = 1 / (Q(5,39) - MZ2)
  den(325) = 1 / (Q(5,27) - MH2)
  den(327) = 1 / (Q(5,27) - MZ2)
  den(331) = 1 / (Q(5,43) - MH2)
  den(333) = 1 / (Q(5,43) - MZ2)
  den(362) = 1 / (Q(5,60) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(1)*den(7)
  den(9) = den(6)*den(8)
  den(11) = den(8)*den(10)
  den(12) = den(2)*den(8)
  den(14) = den(7)*den(13)
  den(15) = den(2)*den(14)
  den(17) = den(6)*den(16)
  den(18) = den(1)*den(17)
  den(19) = den(10)*den(16)
  den(20) = den(1)*den(19)
  den(21) = den(2)*den(16)
  den(22) = den(1)*den(21)
  den(23) = den(13)*den(21)
  den(26) = den(1)*den(24)
  den(27) = den(25)*den(26)
  den(30) = den(1)*den(29)
  den(31) = den(28)*den(30)
  den(33) = den(30)*den(32)
  den(34) = den(25)*den(30)
  den(35) = den(13)*den(29)
  den(36) = den(25)*den(35)
  den(37) = den(16)*den(28)
  den(38) = den(1)*den(37)
  den(39) = den(16)*den(32)
  den(40) = den(1)*den(39)
  den(41) = den(16)*den(25)
  den(42) = den(1)*den(41)
  den(43) = den(13)*den(41)
  den(45) = den(8)*den(44)
  den(47) = den(8)*den(46)
  den(48) = den(8)*den(24)
  den(49) = den(14)*den(24)
  den(51) = den(44)*den(50)
  den(52) = den(1)*den(51)
  den(53) = den(46)*den(50)
  den(54) = den(1)*den(53)
  den(55) = den(24)*den(50)
  den(56) = den(1)*den(55)
  den(57) = den(13)*den(55)
  den(59) = den(30)*den(58)
  den(61) = den(30)*den(60)
  den(62) = den(3)*den(30)
  den(63) = den(3)*den(35)
  den(64) = den(50)*den(58)
  den(65) = den(1)*den(64)
  den(66) = den(50)*den(60)
  den(67) = den(1)*den(66)
  den(68) = den(3)*den(50)
  den(69) = den(1)*den(68)
  den(70) = den(13)*den(68)
  den(72) = den(2)*den(71)
  den(73) = den(3)*den(72)
  den(74) = den(10)*den(71)
  den(75) = den(3)*den(74)
  den(76) = den(60)*den(72)
  den(78) = den(3)*den(77)
  den(79) = den(2)*den(78)
  den(80) = den(60)*den(77)
  den(81) = den(2)*den(80)
  den(82) = den(10)*den(78)
  den(84) = den(24)*den(83)
  den(85) = den(25)*den(84)
  den(86) = den(46)*den(83)
  den(87) = den(25)*den(86)
  den(88) = den(32)*den(84)
  den(90) = den(25)*den(89)
  den(91) = den(24)*den(90)
  den(92) = den(32)*den(89)
  den(93) = den(24)*den(92)
  den(94) = den(46)*den(90)
  den(95) = den(1)*den(6)
  den(96) = den(3)*den(95)
  den(97) = den(4)*den(58)
  den(98) = den(2)*den(13)
  den(99) = den(3)*den(98)
  den(100) = den(1)*den(10)
  den(101) = den(3)*den(100)
  den(102) = den(4)*den(60)
  den(103) = den(1)*den(44)
  den(104) = den(25)*den(103)
  den(105) = den(26)*den(28)
  den(106) = den(13)*den(24)
  den(107) = den(25)*den(106)
  den(108) = den(1)*den(46)
  den(109) = den(25)*den(108)
  den(110) = den(26)*den(32)
  den(112) = den(1)*den(111)
  den(113) = den(6)*den(112)
  den(114) = den(10)*den(112)
  den(115) = den(2)*den(112)
  den(116) = den(13)*den(111)
  den(117) = den(2)*den(116)
  den(119) = den(6)*den(118)
  den(120) = den(1)*den(119)
  den(121) = den(10)*den(118)
  den(122) = den(1)*den(121)
  den(123) = den(2)*den(118)
  den(124) = den(1)*den(123)
  den(125) = den(13)*den(123)
  den(127) = den(1)*den(126)
  den(128) = den(44)*den(127)
  den(129) = den(46)*den(127)
  den(130) = den(24)*den(127)
  den(131) = den(13)*den(126)
  den(132) = den(24)*den(131)
  den(133) = den(44)*den(118)
  den(134) = den(1)*den(133)
  den(135) = den(46)*den(118)
  den(136) = den(1)*den(135)
  den(137) = den(24)*den(118)
  den(138) = den(1)*den(137)
  den(139) = den(13)*den(137)
  den(140) = den(28)*den(112)
  den(141) = den(32)*den(112)
  den(142) = den(25)*den(112)
  den(143) = den(25)*den(116)
  den(145) = den(28)*den(144)
  den(146) = den(1)*den(145)
  den(147) = den(32)*den(144)
  den(148) = den(1)*den(147)
  den(149) = den(25)*den(144)
  den(150) = den(1)*den(149)
  den(151) = den(13)*den(149)
  den(152) = den(58)*den(127)
  den(153) = den(60)*den(127)
  den(154) = den(3)*den(127)
  den(155) = den(3)*den(131)
  den(156) = den(58)*den(144)
  den(157) = den(1)*den(156)
  den(158) = den(60)*den(144)
  den(159) = den(1)*den(158)
  den(160) = den(3)*den(144)
  den(161) = den(1)*den(160)
  den(162) = den(13)*den(160)
  den(164) = den(3)*den(163)
  den(165) = den(2)*den(164)
  den(166) = den(10)*den(164)
  den(167) = den(60)*den(163)
  den(168) = den(2)*den(167)
  den(170) = den(2)*den(169)
  den(171) = den(3)*den(170)
  den(172) = den(60)*den(170)
  den(173) = den(10)*den(169)
  den(174) = den(3)*den(173)
  den(176) = den(25)*den(175)
  den(177) = den(24)*den(176)
  den(178) = den(46)*den(176)
  den(179) = den(32)*den(175)
  den(180) = den(24)*den(179)
  den(182) = den(24)*den(181)
  den(183) = den(25)*den(182)
  den(184) = den(32)*den(182)
  den(185) = den(46)*den(181)
  den(186) = den(25)*den(185)
  den(187) = den(2)*den(3)
  den(189) = den(187)*den(188)
  den(190) = den(1)*den(189)
  den(191) = den(1)*den(3)
  den(193) = den(191)*den(192)
  den(194) = den(2)*den(193)
  den(196) = den(4)*den(195)
  den(197) = den(3)*den(196)
  den(198) = den(1)**2
  den(199) = den(119)*den(198)
  den(200) = den(121)*den(198)
  den(201) = den(123)*den(198)
  den(202) = den(17)*den(198)
  den(203) = den(19)*den(198)
  den(204) = den(21)*den(198)
  den(205) = den(2)**2
  den(206) = den(112)*den(205)
  den(207) = den(116)*den(205)
  den(208) = den(8)*den(205)
  den(209) = den(14)*den(205)
  den(210) = den(8)*den(119)
  den(211) = den(8)*den(121)
  den(212) = den(8)*den(123)
  den(213) = den(14)*den(123)
  den(214) = den(17)*den(112)
  den(215) = den(19)*den(112)
  den(216) = den(21)*den(112)
  den(217) = den(21)*den(116)
  den(218) = den(24)*den(25)
  den(219) = den(188)*den(218)
  den(220) = den(1)*den(219)
  den(221) = den(1)*den(25)
  den(223) = den(221)*den(222)
  den(224) = den(24)*den(223)
  den(226) = den(26)*den(225)
  den(227) = den(25)*den(226)
  den(228) = den(145)*den(198)
  den(229) = den(147)*den(198)
  den(230) = den(149)*den(198)
  den(231) = den(37)*den(198)
  den(232) = den(39)*den(198)
  den(233) = den(41)*den(198)
  den(234) = den(25)**2
  den(235) = den(112)*den(234)
  den(236) = den(116)*den(234)
  den(237) = den(30)*den(145)
  den(238) = den(30)*den(147)
  den(239) = den(30)*den(149)
  den(240) = den(35)*den(149)
  den(241) = den(37)*den(112)
  den(242) = den(39)*den(112)
  den(243) = den(41)*den(112)
  den(244) = den(41)*den(116)
  den(245) = den(30)*den(234)
  den(246) = den(35)*den(234)
  den(247) = den(133)*den(198)
  den(248) = den(135)*den(198)
  den(249) = den(137)*den(198)
  den(250) = den(51)*den(198)
  den(251) = den(53)*den(198)
  den(252) = den(55)*den(198)
  den(253) = den(24)**2
  den(254) = den(127)*den(253)
  den(255) = den(131)*den(253)
  den(256) = den(8)*den(253)
  den(257) = den(14)*den(253)
  den(258) = den(8)*den(133)
  den(259) = den(8)*den(135)
  den(260) = den(8)*den(137)
  den(261) = den(14)*den(137)
  den(262) = den(51)*den(127)
  den(263) = den(53)*den(127)
  den(264) = den(55)*den(127)
  den(265) = den(55)*den(131)
  den(266) = den(156)*den(198)
  den(267) = den(158)*den(198)
  den(268) = den(160)*den(198)
  den(269) = den(64)*den(198)
  den(270) = den(66)*den(198)
  den(271) = den(68)*den(198)
  den(272) = den(3)**2
  den(273) = den(127)*den(272)
  den(274) = den(131)*den(272)
  den(275) = den(30)*den(156)
  den(276) = den(30)*den(158)
  den(277) = den(30)*den(160)
  den(278) = den(35)*den(160)
  den(279) = den(64)*den(127)
  den(280) = den(66)*den(127)
  den(281) = den(68)*den(127)
  den(282) = den(68)*den(131)
  den(283) = den(30)*den(272)
  den(284) = den(35)*den(272)
  den(285) = den(72)*den(164)
  den(286) = den(74)*den(164)
  den(287) = den(72)*den(167)
  den(288) = den(78)*den(170)
  den(289) = den(80)*den(170)
  den(290) = den(78)*den(173)
  den(291) = den(164)*den(205)
  den(292) = den(167)*den(205)
  den(293) = den(170)*den(272)
  den(294) = den(173)*den(272)
  den(295) = den(78)*den(205)
  den(296) = den(80)*den(205)
  den(297) = den(72)*den(272)
  den(298) = den(74)*den(272)
  den(299) = den(84)*den(176)
  den(300) = den(86)*den(176)
  den(301) = den(84)*den(179)
  den(302) = den(90)*den(182)
  den(303) = den(92)*den(182)
  den(304) = den(90)*den(185)
  den(305) = den(176)*den(253)
  den(306) = den(179)*den(253)
  den(307) = den(182)*den(234)
  den(308) = den(185)*den(234)
  den(309) = den(90)*den(253)
  den(310) = den(92)*den(253)
  den(311) = den(84)*den(234)
  den(312) = den(86)*den(234)
  den(314) = den(30)*den(313)
  den(316) = den(30)*den(315)
  den(317) = den(30)*den(195)
  den(318) = den(35)*den(195)
  den(320) = den(30)*den(319)
  den(322) = den(30)*den(321)
  den(323) = den(30)*den(225)
  den(324) = den(35)*den(225)
  den(326) = den(8)*den(325)
  den(328) = den(8)*den(327)
  den(329) = den(8)*den(222)
  den(330) = den(14)*den(222)
  den(332) = den(8)*den(331)
  den(334) = den(8)*den(333)
  den(335) = den(8)*den(192)
  den(336) = den(14)*den(192)
  den(337) = den(127)*den(313)
  den(338) = den(127)*den(315)
  den(339) = den(127)*den(195)
  den(340) = den(131)*den(195)
  den(341) = den(127)*den(325)
  den(342) = den(127)*den(327)
  den(343) = den(127)*den(222)
  den(344) = den(131)*den(222)
  den(345) = den(112)*den(319)
  den(346) = den(112)*den(321)
  den(347) = den(112)*den(225)
  den(348) = den(116)*den(225)
  den(349) = den(112)*den(331)
  den(350) = den(112)*den(333)
  den(351) = den(112)*den(192)
  den(352) = den(116)*den(192)
  den(353) = den(72)*den(195)
  den(354) = den(74)*den(195)
  den(355) = den(72)*den(315)
  den(356) = den(170)*den(195)
  den(357) = den(170)*den(315)
  den(358) = den(173)*den(195)
  den(359) = den(17)*den(188)
  den(360) = den(19)*den(188)
  den(361) = den(21)*den(188)
  den(363) = den(21)*den(362)
  den(364) = den(119)*den(188)
  den(365) = den(121)*den(188)
  den(366) = den(123)*den(188)
  den(367) = den(123)*den(362)
  den(368) = den(90)*den(222)
  den(369) = den(92)*den(222)
  den(370) = den(90)*den(327)
  den(371) = den(176)*den(222)
  den(372) = den(176)*den(327)
  den(373) = den(179)*den(222)
  den(374) = den(37)*den(188)
  den(375) = den(39)*den(188)
  den(376) = den(41)*den(188)
  den(377) = den(41)*den(362)
  den(378) = den(145)*den(188)
  den(379) = den(147)*den(188)
  den(380) = den(149)*den(188)
  den(381) = den(149)*den(362)
  den(382) = den(84)*den(225)
  den(383) = den(86)*den(225)
  den(384) = den(84)*den(321)
  den(385) = den(182)*den(225)
  den(386) = den(182)*den(321)
  den(387) = den(185)*den(225)
  den(388) = den(51)*den(188)
  den(389) = den(53)*den(188)
  den(390) = den(55)*den(188)
  den(391) = den(55)*den(362)
  den(392) = den(133)*den(188)
  den(393) = den(135)*den(188)
  den(394) = den(137)*den(188)
  den(395) = den(137)*den(362)
  den(396) = den(78)*den(192)
  den(397) = den(80)*den(192)
  den(398) = den(78)*den(333)
  den(399) = den(164)*den(192)
  den(400) = den(164)*den(333)
  den(401) = den(167)*den(192)
  den(402) = den(64)*den(188)
  den(403) = den(66)*den(188)
  den(404) = den(68)*den(188)
  den(405) = den(68)*den(362)
  den(406) = den(156)*den(188)
  den(407) = den(158)*den(188)
  den(408) = den(160)*den(188)
  den(409) = den(160)*den(362)
  den(410) = den(1)*den(3)*den(6)
  den(411) = den(1)*den(3)*den(10)
  den(412) = den(1)*den(2)*den(58)
  den(413) = den(1)*den(2)*den(60)
  den(414) = den(1)*den(2)*den(3)
  den(415) = den(2)*den(3)*den(13)
  den(416) = den(1)*den(25)*den(44)
  den(417) = den(1)*den(25)*den(46)
  den(418) = den(1)*den(24)*den(28)
  den(419) = den(1)*den(24)*den(32)
  den(420) = den(1)*den(24)*den(25)
  den(421) = den(13)*den(24)*den(25)
  den(422) = den(1)*den(28)
  den(423) = den(1)*den(32)
  den(424) = den(13)*den(25)
  den(425) = den(1)*den(58)
  den(426) = den(1)*den(60)
  den(427) = den(3)*den(13)
  den(428) = den(3)*den(10)
  den(429) = den(2)*den(60)
  den(430) = den(25)*den(46)
  den(431) = den(24)*den(32)
  den(432) = den(1)*den(187)
  den(433) = den(2)*den(191)
  den(434) = den(1)*den(218)
  den(435) = den(24)*den(221)
  den(436) = den(2)*den(335)
  den(437) = den(2)*den(336)
  den(438) = den(2)*den(351)
  den(439) = den(2)*den(352)
  den(440) = den(1)*den(359)
  den(441) = den(1)*den(360)
  den(442) = den(1)*den(361)
  den(443) = den(1)*den(364)
  den(444) = den(1)*den(365)
  den(445) = den(1)*den(366)
  den(446) = den(25)*den(323)
  den(447) = den(25)*den(324)
  den(448) = den(25)*den(347)
  den(449) = den(25)*den(348)
  den(450) = den(1)*den(374)
  den(451) = den(1)*den(375)
  den(452) = den(1)*den(376)
  den(453) = den(1)*den(378)
  den(454) = den(1)*den(379)
  den(455) = den(1)*den(380)
  den(456) = den(24)*den(329)
  den(457) = den(24)*den(330)
  den(458) = den(24)*den(343)
  den(459) = den(24)*den(344)
  den(460) = den(1)*den(388)
  den(461) = den(1)*den(389)
  den(462) = den(1)*den(390)
  den(463) = den(1)*den(392)
  den(464) = den(1)*den(393)
  den(465) = den(1)*den(394)
  den(466) = den(3)*den(317)
  den(467) = den(3)*den(318)
  den(468) = den(3)*den(339)
  den(469) = den(3)*den(340)
  den(470) = den(1)*den(402)
  den(471) = den(1)*den(403)
  den(472) = den(1)*den(404)
  den(473) = den(1)*den(406)
  den(474) = den(1)*den(407)
  den(475) = den(1)*den(408)
  den(476) = den(3)*den(353)
  den(477) = den(3)*den(354)
  den(478) = den(2)*den(396)
  den(479) = den(2)*den(397)
  den(480) = den(3)*den(356)
  den(481) = den(3)*den(358)
  den(482) = den(2)*den(399)
  den(483) = den(2)*den(401)
  den(484) = den(25)*den(382)
  den(485) = den(25)*den(383)
  den(486) = den(24)*den(368)
  den(487) = den(24)*den(369)
  den(488) = den(25)*den(385)
  den(489) = den(25)*den(387)
  den(490) = den(24)*den(371)
  den(491) = den(24)*den(373)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(636)

  A(1) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_QA(wf(:,7),wf(:,8)) * den(9)
  A(3) = cont_QA(wf(:,8),wf(:,10)) * den(11)
  A(4) = cont_QA(wf(:,8),wf(:,11)) * den(12)
  A(5) = cont_QA(wf(:,11),wf(:,14)) * den(15)
  A(6) = cont_QA(wf(:,8),wf(:,11)) * den(12)
  A(7) = cont_QA(wf(:,8),wf(:,16)) * den(11)
  A(8) = cont_QA(wf(:,8),wf(:,11)) * den(12)
  A(9) = cont_QA(wf(:,18),wf(:,19)) * den(18)
  A(10) = cont_QA(wf(:,18),wf(:,21)) * den(20)
  A(11) = cont_QA(wf(:,18),wf(:,23)) * den(22)
  A(12) = cont_QA(wf(:,23),wf(:,24)) * den(23)
  A(13) = cont_QA(wf(:,18),wf(:,23)) * den(22)
  A(14) = cont_QA(wf(:,18),wf(:,26)) * den(20)
  A(15) = cont_QA(wf(:,18),wf(:,23)) * den(22)
  A(16) = cont_VV(wf(:,28),wf(:,29)) * den(27)
  A(17) = cont_QA(wf(:,32),wf(:,33)) * den(31)
  A(18) = cont_QA(wf(:,33),wf(:,35)) * den(33)
  A(19) = cont_QA(wf(:,33),wf(:,36)) * den(34)
  A(20) = cont_QA(wf(:,36),wf(:,38)) * den(36)
  A(21) = cont_QA(wf(:,33),wf(:,36)) * den(34)
  A(22) = cont_QA(wf(:,33),wf(:,40)) * den(33)
  A(23) = cont_QA(wf(:,33),wf(:,36)) * den(34)
  A(24) = cont_QA(wf(:,18),wf(:,42)) * den(38)
  A(25) = cont_QA(wf(:,18),wf(:,44)) * den(40)
  A(26) = cont_QA(wf(:,18),wf(:,46)) * den(42)
  A(27) = cont_QA(wf(:,24),wf(:,46)) * den(43)
  A(28) = cont_QA(wf(:,18),wf(:,46)) * den(42)
  A(29) = cont_QA(wf(:,18),wf(:,48)) * den(40)
  A(30) = cont_QA(wf(:,18),wf(:,46)) * den(42)
  A(31) = cont_QA(wf(:,8),wf(:,50)) * den(45)
  A(32) = cont_QA(wf(:,8),wf(:,52)) * den(47)
  A(33) = cont_QA(wf(:,8),wf(:,53)) * den(48)
  A(34) = cont_QA(wf(:,14),wf(:,53)) * den(49)
  A(35) = cont_QA(wf(:,8),wf(:,53)) * den(48)
  A(36) = cont_QA(wf(:,8),wf(:,55)) * den(47)
  A(37) = cont_QA(wf(:,8),wf(:,53)) * den(48)
  A(38) = cont_QA(wf(:,57),wf(:,58)) * den(52)
  A(39) = cont_QA(wf(:,57),wf(:,60)) * den(54)
  A(40) = cont_QA(wf(:,57),wf(:,62)) * den(56)
  A(41) = cont_QA(wf(:,62),wf(:,63)) * den(57)
  A(42) = cont_QA(wf(:,57),wf(:,62)) * den(56)
  A(43) = cont_QA(wf(:,57),wf(:,65)) * den(54)
  A(44) = cont_QA(wf(:,57),wf(:,62)) * den(56)
  A(45) = cont_QA(wf(:,33),wf(:,67)) * den(59)
  A(46) = cont_QA(wf(:,33),wf(:,69)) * den(61)
  A(47) = cont_QA(wf(:,33),wf(:,70)) * den(62)
  A(48) = cont_QA(wf(:,38),wf(:,70)) * den(63)
  A(49) = cont_QA(wf(:,33),wf(:,70)) * den(62)
  A(50) = cont_QA(wf(:,33),wf(:,72)) * den(61)
  A(51) = cont_QA(wf(:,33),wf(:,70)) * den(62)
  A(52) = cont_QA(wf(:,57),wf(:,74)) * den(65)
  A(53) = cont_QA(wf(:,57),wf(:,76)) * den(67)
  A(54) = cont_QA(wf(:,57),wf(:,78)) * den(69)
  A(55) = cont_QA(wf(:,63),wf(:,78)) * den(70)
  A(56) = cont_QA(wf(:,57),wf(:,78)) * den(69)
  A(57) = cont_QA(wf(:,57),wf(:,80)) * den(67)
  A(58) = cont_QA(wf(:,57),wf(:,78)) * den(69)
  A(59) = cont_QA(wf(:,82),wf(:,83)) * den(73)
  A(60) = cont_QA(wf(:,82),wf(:,85)) * den(75)
  A(61) = cont_QA(wf(:,82),wf(:,83)) * den(73)
  A(62) = cont_QA(wf(:,83),wf(:,86)) * den(76)
  A(63) = cont_QA(wf(:,82),wf(:,83)) * den(73)
  A(64) = cont_QA(wf(:,88),wf(:,89)) * den(79)
  A(65) = cont_QA(wf(:,88),wf(:,91)) * den(81)
  A(66) = cont_QA(wf(:,88),wf(:,89)) * den(79)
  A(67) = cont_QA(wf(:,89),wf(:,92)) * den(82)
  A(68) = cont_QA(wf(:,88),wf(:,89)) * den(79)
  A(69) = cont_QA(wf(:,94),wf(:,95)) * den(85)
  A(70) = cont_QA(wf(:,94),wf(:,97)) * den(87)
  A(71) = cont_QA(wf(:,94),wf(:,95)) * den(85)
  A(72) = cont_QA(wf(:,95),wf(:,98)) * den(88)
  A(73) = cont_QA(wf(:,94),wf(:,95)) * den(85)
  A(74) = cont_QA(wf(:,100),wf(:,101)) * den(91)
  A(75) = cont_QA(wf(:,100),wf(:,103)) * den(93)
  A(76) = cont_QA(wf(:,100),wf(:,101)) * den(91)
  A(77) = cont_QA(wf(:,101),wf(:,104)) * den(94)
  A(78) = cont_QA(wf(:,100),wf(:,101)) * den(91)

  A(79) = cont_VV(wf(:,3),wf(:,105)) * den(96)
  A(80) = cont_SS(wf(:,66),wf(:,106)) * den(97)
  A(81) = cont_VV(wf(:,3),wf(:,107)) * den(99)
  A(82) = cont_VV(wf(:,3),wf(:,108)) * den(101)
  A(83) = cont_VV(wf(:,71),wf(:,109)) * den(102)
  A(84) = cont_VV(wf(:,3),wf(:,110)) * den(5)
  A(85) = cont_QA(wf(:,8),wf(:,111)) * den(9)
  A(86) = cont_QA(wf(:,8),wf(:,112)) * den(11)
  A(87) = cont_QA(wf(:,8),wf(:,113)) * den(12)
  A(88) = cont_QA(wf(:,14),wf(:,113)) * den(15)
  A(89) = cont_QA(wf(:,8),wf(:,113)) * den(12)
  A(90) = cont_QA(wf(:,8),wf(:,114)) * den(11)
  A(91) = cont_QA(wf(:,8),wf(:,113)) * den(12)
  A(92) = cont_QA(wf(:,8),wf(:,115)) * den(12)
  A(93) = cont_QA(wf(:,19),wf(:,116)) * den(18)
  A(94) = cont_QA(wf(:,21),wf(:,116)) * den(20)
  A(95) = cont_QA(wf(:,23),wf(:,116)) * den(22)
  A(96) = cont_QA(wf(:,23),wf(:,117)) * den(23)
  A(97) = cont_QA(wf(:,23),wf(:,116)) * den(22)
  A(98) = cont_QA(wf(:,26),wf(:,116)) * den(20)
  A(99) = cont_QA(wf(:,23),wf(:,116)) * den(22)
  A(100) = cont_QA(wf(:,23),wf(:,118)) * den(22)
  A(101) = cont_VV(wf(:,28),wf(:,119)) * den(104)
  A(102) = cont_SS(wf(:,30),wf(:,120)) * den(105)
  A(103) = cont_VV(wf(:,28),wf(:,121)) * den(107)
  A(104) = cont_VV(wf(:,28),wf(:,122)) * den(109)
  A(105) = cont_VV(wf(:,39),wf(:,123)) * den(110)
  A(106) = cont_VV(wf(:,28),wf(:,124)) * den(27)
  A(107) = cont_QA(wf(:,33),wf(:,125)) * den(31)
  A(108) = cont_QA(wf(:,33),wf(:,126)) * den(33)
  A(109) = cont_QA(wf(:,33),wf(:,127)) * den(34)
  A(110) = cont_QA(wf(:,38),wf(:,127)) * den(36)
  A(111) = cont_QA(wf(:,33),wf(:,127)) * den(34)
  A(112) = cont_QA(wf(:,33),wf(:,128)) * den(33)
  A(113) = cont_QA(wf(:,33),wf(:,127)) * den(34)
  A(114) = cont_QA(wf(:,33),wf(:,129)) * den(34)
  A(115) = cont_QA(wf(:,42),wf(:,116)) * den(38)
  A(116) = cont_QA(wf(:,44),wf(:,116)) * den(40)
  A(117) = cont_QA(wf(:,46),wf(:,116)) * den(42)
  A(118) = cont_QA(wf(:,46),wf(:,117)) * den(43)
  A(119) = cont_QA(wf(:,46),wf(:,116)) * den(42)
  A(120) = cont_QA(wf(:,48),wf(:,116)) * den(40)
  A(121) = cont_QA(wf(:,46),wf(:,116)) * den(42)
  A(122) = cont_QA(wf(:,46),wf(:,118)) * den(42)
  A(123) = cont_QA(wf(:,8),wf(:,130)) * den(45)
  A(124) = cont_QA(wf(:,8),wf(:,131)) * den(47)
  A(125) = cont_QA(wf(:,8),wf(:,132)) * den(48)
  A(126) = cont_QA(wf(:,14),wf(:,132)) * den(49)
  A(127) = cont_QA(wf(:,8),wf(:,132)) * den(48)
  A(128) = cont_QA(wf(:,8),wf(:,133)) * den(47)
  A(129) = cont_QA(wf(:,8),wf(:,132)) * den(48)
  A(130) = cont_QA(wf(:,8),wf(:,134)) * den(48)
  A(131) = cont_QA(wf(:,58),wf(:,135)) * den(52)
  A(132) = cont_QA(wf(:,60),wf(:,135)) * den(54)
  A(133) = cont_QA(wf(:,62),wf(:,135)) * den(56)
  A(134) = cont_QA(wf(:,62),wf(:,136)) * den(57)
  A(135) = cont_QA(wf(:,62),wf(:,135)) * den(56)
  A(136) = cont_QA(wf(:,65),wf(:,135)) * den(54)
  A(137) = cont_QA(wf(:,62),wf(:,135)) * den(56)
  A(138) = cont_QA(wf(:,62),wf(:,137)) * den(56)
  A(139) = cont_QA(wf(:,33),wf(:,138)) * den(59)
  A(140) = cont_QA(wf(:,33),wf(:,139)) * den(61)
  A(141) = cont_QA(wf(:,33),wf(:,140)) * den(62)
  A(142) = cont_QA(wf(:,38),wf(:,140)) * den(63)
  A(143) = cont_QA(wf(:,33),wf(:,140)) * den(62)
  A(144) = cont_QA(wf(:,33),wf(:,141)) * den(61)
  A(145) = cont_QA(wf(:,33),wf(:,140)) * den(62)
  A(146) = cont_QA(wf(:,33),wf(:,142)) * den(62)
  A(147) = cont_QA(wf(:,74),wf(:,135)) * den(65)
  A(148) = cont_QA(wf(:,76),wf(:,135)) * den(67)
  A(149) = cont_QA(wf(:,78),wf(:,135)) * den(69)
  A(150) = cont_QA(wf(:,78),wf(:,136)) * den(70)
  A(151) = cont_QA(wf(:,78),wf(:,135)) * den(69)
  A(152) = cont_QA(wf(:,80),wf(:,135)) * den(67)
  A(153) = cont_QA(wf(:,78),wf(:,135)) * den(69)
  A(154) = cont_QA(wf(:,78),wf(:,137)) * den(69)
  A(155) = cont_QA(wf(:,143),wf(:,144)) * den(113)
  A(156) = cont_QA(wf(:,144),wf(:,145)) * den(114)
  A(157) = cont_QA(wf(:,144),wf(:,146)) * den(115)
  A(158) = cont_QA(wf(:,146),wf(:,147)) * den(117)
  A(159) = cont_QA(wf(:,144),wf(:,146)) * den(115)
  A(160) = cont_QA(wf(:,144),wf(:,148)) * den(114)
  A(161) = cont_QA(wf(:,144),wf(:,146)) * den(115)
  A(162) = cont_QA(wf(:,144),wf(:,149)) * den(115)
  A(163) = cont_QA(wf(:,150),wf(:,151)) * den(120)
  A(164) = cont_QA(wf(:,150),wf(:,152)) * den(122)
  A(165) = cont_QA(wf(:,150),wf(:,153)) * den(124)
  A(166) = cont_QA(wf(:,153),wf(:,154)) * den(125)
  A(167) = cont_QA(wf(:,150),wf(:,153)) * den(124)
  A(168) = cont_QA(wf(:,150),wf(:,155)) * den(122)
  A(169) = cont_QA(wf(:,150),wf(:,153)) * den(124)
  A(170) = cont_QA(wf(:,153),wf(:,156)) * den(124)
  A(171) = cont_VV(wf(:,4),wf(:,157)) * den(5)
  A(172) = cont_VV(wf(:,4),wf(:,158)) * den(5)
  A(173) = cont_QA(wf(:,159),wf(:,160)) * den(128)
  A(174) = cont_QA(wf(:,160),wf(:,161)) * den(129)
  A(175) = cont_QA(wf(:,160),wf(:,162)) * den(130)
  A(176) = cont_QA(wf(:,162),wf(:,163)) * den(132)
  A(177) = cont_QA(wf(:,160),wf(:,162)) * den(130)
  A(178) = cont_QA(wf(:,160),wf(:,164)) * den(129)
  A(179) = cont_QA(wf(:,160),wf(:,162)) * den(130)
  A(180) = cont_QA(wf(:,160),wf(:,165)) * den(130)
  A(181) = cont_QA(wf(:,150),wf(:,166)) * den(134)
  A(182) = cont_QA(wf(:,150),wf(:,167)) * den(136)
  A(183) = cont_QA(wf(:,150),wf(:,168)) * den(138)
  A(184) = cont_QA(wf(:,154),wf(:,168)) * den(139)
  A(185) = cont_QA(wf(:,150),wf(:,168)) * den(138)
  A(186) = cont_QA(wf(:,150),wf(:,169)) * den(136)
  A(187) = cont_QA(wf(:,150),wf(:,168)) * den(138)
  A(188) = cont_QA(wf(:,156),wf(:,168)) * den(138)
  A(189) = cont_QA(wf(:,33),wf(:,171)) * den(59)
  A(190) = cont_QA(wf(:,33),wf(:,173)) * den(61)
  A(191) = cont_QA(wf(:,33),wf(:,174)) * den(62)
  A(192) = cont_QA(wf(:,38),wf(:,174)) * den(63)
  A(193) = cont_QA(wf(:,33),wf(:,174)) * den(62)
  A(194) = cont_QA(wf(:,33),wf(:,176)) * den(61)
  A(195) = cont_QA(wf(:,33),wf(:,174)) * den(62)
  A(196) = cont_QA(wf(:,33),wf(:,177)) * den(62)
  A(197) = cont_QA(wf(:,57),wf(:,179)) * den(65)
  A(198) = cont_QA(wf(:,57),wf(:,181)) * den(67)
  A(199) = cont_QA(wf(:,57),wf(:,183)) * den(69)
  A(200) = cont_QA(wf(:,63),wf(:,183)) * den(70)
  A(201) = cont_QA(wf(:,57),wf(:,183)) * den(69)
  A(202) = cont_QA(wf(:,57),wf(:,185)) * den(67)
  A(203) = cont_QA(wf(:,57),wf(:,183)) * den(69)
  A(204) = cont_QA(wf(:,57),wf(:,187)) * den(69)
  A(205) = cont_VV(wf(:,29),wf(:,188)) * den(27)
  A(206) = cont_VV(wf(:,29),wf(:,189)) * den(27)
  A(207) = cont_QA(wf(:,33),wf(:,191)) * den(31)
  A(208) = cont_QA(wf(:,33),wf(:,193)) * den(33)
  A(209) = cont_QA(wf(:,33),wf(:,194)) * den(34)
  A(210) = cont_QA(wf(:,38),wf(:,194)) * den(36)
  A(211) = cont_QA(wf(:,33),wf(:,194)) * den(34)
  A(212) = cont_QA(wf(:,33),wf(:,196)) * den(33)
  A(213) = cont_QA(wf(:,33),wf(:,194)) * den(34)
  A(214) = cont_QA(wf(:,33),wf(:,197)) * den(34)
  A(215) = cont_QA(wf(:,18),wf(:,199)) * den(38)
  A(216) = cont_QA(wf(:,18),wf(:,201)) * den(40)
  A(217) = cont_QA(wf(:,18),wf(:,203)) * den(42)
  A(218) = cont_QA(wf(:,24),wf(:,203)) * den(43)
  A(219) = cont_QA(wf(:,18),wf(:,203)) * den(42)
  A(220) = cont_QA(wf(:,18),wf(:,205)) * den(40)
  A(221) = cont_QA(wf(:,18),wf(:,203)) * den(42)
  A(222) = cont_QA(wf(:,18),wf(:,207)) * den(42)
  A(223) = cont_QA(wf(:,144),wf(:,208)) * den(140)
  A(224) = cont_QA(wf(:,144),wf(:,209)) * den(141)
  A(225) = cont_QA(wf(:,144),wf(:,210)) * den(142)
  A(226) = cont_QA(wf(:,147),wf(:,210)) * den(143)
  A(227) = cont_QA(wf(:,144),wf(:,210)) * den(142)
  A(228) = cont_QA(wf(:,144),wf(:,211)) * den(141)
  A(229) = cont_QA(wf(:,144),wf(:,210)) * den(142)
  A(230) = cont_QA(wf(:,144),wf(:,212)) * den(142)
  A(231) = cont_QA(wf(:,213),wf(:,214)) * den(146)
  A(232) = cont_QA(wf(:,213),wf(:,215)) * den(148)
  A(233) = cont_QA(wf(:,213),wf(:,216)) * den(150)
  A(234) = cont_QA(wf(:,216),wf(:,217)) * den(151)
  A(235) = cont_QA(wf(:,213),wf(:,216)) * den(150)
  A(236) = cont_QA(wf(:,213),wf(:,218)) * den(148)
  A(237) = cont_QA(wf(:,213),wf(:,216)) * den(150)
  A(238) = cont_QA(wf(:,216),wf(:,219)) * den(150)
  A(239) = cont_VV(wf(:,28),wf(:,221)) * den(27)
  A(240) = cont_VV(wf(:,28),wf(:,223)) * den(27)
  A(241) = cont_QA(wf(:,160),wf(:,224)) * den(152)
  A(242) = cont_QA(wf(:,160),wf(:,225)) * den(153)
  A(243) = cont_QA(wf(:,160),wf(:,226)) * den(154)
  A(244) = cont_QA(wf(:,163),wf(:,226)) * den(155)
  A(245) = cont_QA(wf(:,160),wf(:,226)) * den(154)
  A(246) = cont_QA(wf(:,160),wf(:,227)) * den(153)
  A(247) = cont_QA(wf(:,160),wf(:,226)) * den(154)
  A(248) = cont_QA(wf(:,160),wf(:,228)) * den(154)
  A(249) = cont_QA(wf(:,213),wf(:,229)) * den(157)
  A(250) = cont_QA(wf(:,213),wf(:,230)) * den(159)
  A(251) = cont_QA(wf(:,213),wf(:,231)) * den(161)
  A(252) = cont_QA(wf(:,217),wf(:,231)) * den(162)
  A(253) = cont_QA(wf(:,213),wf(:,231)) * den(161)
  A(254) = cont_QA(wf(:,213),wf(:,232)) * den(159)
  A(255) = cont_QA(wf(:,213),wf(:,231)) * den(161)
  A(256) = cont_QA(wf(:,219),wf(:,231)) * den(161)
  A(257) = cont_QA(wf(:,8),wf(:,234)) * den(45)
  A(258) = cont_QA(wf(:,8),wf(:,236)) * den(47)
  A(259) = cont_QA(wf(:,8),wf(:,237)) * den(48)
  A(260) = cont_QA(wf(:,14),wf(:,237)) * den(49)
  A(261) = cont_QA(wf(:,8),wf(:,237)) * den(48)
  A(262) = cont_QA(wf(:,8),wf(:,239)) * den(47)
  A(263) = cont_QA(wf(:,8),wf(:,237)) * den(48)
  A(264) = cont_QA(wf(:,8),wf(:,240)) * den(48)
  A(265) = cont_QA(wf(:,57),wf(:,242)) * den(52)
  A(266) = cont_QA(wf(:,57),wf(:,244)) * den(54)
  A(267) = cont_QA(wf(:,57),wf(:,246)) * den(56)
  A(268) = cont_QA(wf(:,63),wf(:,246)) * den(57)
  A(269) = cont_QA(wf(:,57),wf(:,246)) * den(56)
  A(270) = cont_QA(wf(:,57),wf(:,248)) * den(54)
  A(271) = cont_QA(wf(:,57),wf(:,246)) * den(56)
  A(272) = cont_QA(wf(:,57),wf(:,250)) * den(56)
  A(273) = cont_VV(wf(:,3),wf(:,252)) * den(5)
  A(274) = cont_VV(wf(:,3),wf(:,254)) * den(5)
  A(275) = cont_QA(wf(:,8),wf(:,256)) * den(9)
  A(276) = cont_QA(wf(:,8),wf(:,258)) * den(11)
  A(277) = cont_QA(wf(:,8),wf(:,259)) * den(12)
  A(278) = cont_QA(wf(:,14),wf(:,259)) * den(15)
  A(279) = cont_QA(wf(:,8),wf(:,259)) * den(12)
  A(280) = cont_QA(wf(:,8),wf(:,261)) * den(11)
  A(281) = cont_QA(wf(:,8),wf(:,259)) * den(12)
  A(282) = cont_QA(wf(:,8),wf(:,262)) * den(12)
  A(283) = cont_QA(wf(:,18),wf(:,264)) * den(18)
  A(284) = cont_QA(wf(:,18),wf(:,266)) * den(20)
  A(285) = cont_QA(wf(:,18),wf(:,268)) * den(22)
  A(286) = cont_QA(wf(:,24),wf(:,268)) * den(23)
  A(287) = cont_QA(wf(:,18),wf(:,268)) * den(22)
  A(288) = cont_QA(wf(:,18),wf(:,270)) * den(20)
  A(289) = cont_QA(wf(:,18),wf(:,268)) * den(22)
  A(290) = cont_QA(wf(:,18),wf(:,272)) * den(22)
  A(291) = cont_QA(wf(:,83),wf(:,273)) * den(73)
  A(292) = cont_QA(wf(:,85),wf(:,273)) * den(75)
  A(293) = cont_QA(wf(:,83),wf(:,273)) * den(73)
  A(294) = cont_QA(wf(:,83),wf(:,274)) * den(76)
  A(295) = cont_QA(wf(:,83),wf(:,273)) * den(73)
  A(296) = cont_QA(wf(:,83),wf(:,275)) * den(73)
  A(297) = cont_QA(wf(:,88),wf(:,277)) * den(79)
  A(298) = cont_QA(wf(:,88),wf(:,279)) * den(81)
  A(299) = cont_QA(wf(:,88),wf(:,277)) * den(79)
  A(300) = cont_QA(wf(:,92),wf(:,277)) * den(82)
  A(301) = cont_QA(wf(:,88),wf(:,277)) * den(79)
  A(302) = cont_QA(wf(:,88),wf(:,281)) * den(79)
  A(303) = cont_QA(wf(:,95),wf(:,282)) * den(85)
  A(304) = cont_QA(wf(:,97),wf(:,282)) * den(87)
  A(305) = cont_QA(wf(:,95),wf(:,282)) * den(85)
  A(306) = cont_QA(wf(:,95),wf(:,283)) * den(88)
  A(307) = cont_QA(wf(:,95),wf(:,282)) * den(85)
  A(308) = cont_QA(wf(:,95),wf(:,284)) * den(85)
  A(309) = cont_QA(wf(:,100),wf(:,286)) * den(91)
  A(310) = cont_QA(wf(:,100),wf(:,288)) * den(93)
  A(311) = cont_QA(wf(:,100),wf(:,286)) * den(91)
  A(312) = cont_QA(wf(:,104),wf(:,286)) * den(94)
  A(313) = cont_QA(wf(:,100),wf(:,286)) * den(91)
  A(314) = cont_QA(wf(:,100),wf(:,290)) * den(91)
  A(315) = cont_QA(wf(:,101),wf(:,291)) * den(91)
  A(316) = cont_QA(wf(:,103),wf(:,291)) * den(93)
  A(317) = cont_QA(wf(:,101),wf(:,291)) * den(91)
  A(318) = cont_QA(wf(:,101),wf(:,292)) * den(94)
  A(319) = cont_QA(wf(:,101),wf(:,291)) * den(91)
  A(320) = cont_QA(wf(:,101),wf(:,293)) * den(91)
  A(321) = cont_QA(wf(:,94),wf(:,295)) * den(85)
  A(322) = cont_QA(wf(:,94),wf(:,297)) * den(87)
  A(323) = cont_QA(wf(:,94),wf(:,295)) * den(85)
  A(324) = cont_QA(wf(:,98),wf(:,295)) * den(88)
  A(325) = cont_QA(wf(:,94),wf(:,295)) * den(85)
  A(326) = cont_QA(wf(:,94),wf(:,299)) * den(85)
  A(327) = cont_QA(wf(:,89),wf(:,300)) * den(79)
  A(328) = cont_QA(wf(:,91),wf(:,300)) * den(81)
  A(329) = cont_QA(wf(:,89),wf(:,300)) * den(79)
  A(330) = cont_QA(wf(:,89),wf(:,301)) * den(82)
  A(331) = cont_QA(wf(:,89),wf(:,300)) * den(79)
  A(332) = cont_QA(wf(:,89),wf(:,302)) * den(79)
  A(333) = cont_QA(wf(:,82),wf(:,304)) * den(73)
  A(334) = cont_QA(wf(:,82),wf(:,306)) * den(75)
  A(335) = cont_QA(wf(:,82),wf(:,304)) * den(73)
  A(336) = cont_QA(wf(:,86),wf(:,304)) * den(76)
  A(337) = cont_QA(wf(:,82),wf(:,304)) * den(73)
  A(338) = cont_QA(wf(:,82),wf(:,308)) * den(73)
  A(339) = cont_QA(wf(:,83),wf(:,309)) * den(73)
  A(340) = cont_QA(wf(:,85),wf(:,309)) * den(75)
  A(341) = cont_QA(wf(:,83),wf(:,309)) * den(73)
  A(342) = cont_QA(wf(:,83),wf(:,310)) * den(76)
  A(343) = cont_QA(wf(:,83),wf(:,309)) * den(73)
  A(344) = cont_QA(wf(:,83),wf(:,311)) * den(73)
  A(345) = cont_QA(wf(:,89),wf(:,312)) * den(79)
  A(346) = cont_QA(wf(:,91),wf(:,312)) * den(81)
  A(347) = cont_QA(wf(:,89),wf(:,312)) * den(79)
  A(348) = cont_QA(wf(:,89),wf(:,313)) * den(82)
  A(349) = cont_QA(wf(:,89),wf(:,312)) * den(79)
  A(350) = cont_QA(wf(:,89),wf(:,314)) * den(79)
  A(351) = cont_QA(wf(:,95),wf(:,315)) * den(85)
  A(352) = cont_QA(wf(:,97),wf(:,315)) * den(87)
  A(353) = cont_QA(wf(:,95),wf(:,315)) * den(85)
  A(354) = cont_QA(wf(:,95),wf(:,316)) * den(88)
  A(355) = cont_QA(wf(:,95),wf(:,315)) * den(85)
  A(356) = cont_QA(wf(:,95),wf(:,317)) * den(85)
  A(357) = cont_QA(wf(:,101),wf(:,318)) * den(91)
  A(358) = cont_QA(wf(:,103),wf(:,318)) * den(93)
  A(359) = cont_QA(wf(:,101),wf(:,318)) * den(91)
  A(360) = cont_QA(wf(:,101),wf(:,319)) * den(94)
  A(361) = cont_QA(wf(:,101),wf(:,318)) * den(91)
  A(362) = cont_QA(wf(:,101),wf(:,320)) * den(91)
  A(363) = cont_QA(wf(:,321),wf(:,322)) * den(165)
  A(364) = cont_QA(wf(:,322),wf(:,323)) * den(166)
  A(365) = cont_QA(wf(:,321),wf(:,322)) * den(165)
  A(366) = cont_QA(wf(:,321),wf(:,324)) * den(168)
  A(367) = cont_QA(wf(:,321),wf(:,322)) * den(165)
  A(368) = cont_QA(wf(:,322),wf(:,325)) * den(165)
  A(369) = cont_QA(wf(:,326),wf(:,327)) * den(171)
  A(370) = cont_QA(wf(:,327),wf(:,328)) * den(172)
  A(371) = cont_QA(wf(:,326),wf(:,327)) * den(171)
  A(372) = cont_QA(wf(:,326),wf(:,329)) * den(174)
  A(373) = cont_QA(wf(:,326),wf(:,327)) * den(171)
  A(374) = cont_QA(wf(:,327),wf(:,330)) * den(171)
  A(375) = cont_QA(wf(:,331),wf(:,332)) * den(177)
  A(376) = cont_QA(wf(:,332),wf(:,333)) * den(178)
  A(377) = cont_QA(wf(:,331),wf(:,332)) * den(177)
  A(378) = cont_QA(wf(:,331),wf(:,334)) * den(180)
  A(379) = cont_QA(wf(:,331),wf(:,332)) * den(177)
  A(380) = cont_QA(wf(:,332),wf(:,335)) * den(177)
  A(381) = cont_QA(wf(:,336),wf(:,337)) * den(183)
  A(382) = cont_QA(wf(:,337),wf(:,338)) * den(184)
  A(383) = cont_QA(wf(:,336),wf(:,337)) * den(183)
  A(384) = cont_QA(wf(:,336),wf(:,339)) * den(186)
  A(385) = cont_QA(wf(:,336),wf(:,337)) * den(183)
  A(386) = cont_QA(wf(:,337),wf(:,340)) * den(183)
  A(387) = cont_VV(wf(:,3),wf(:,342)) * den(5)
  A(388) = cont_VV(wf(:,3),wf(:,344)) * den(5)
  A(389) = cont_QA(wf(:,7),wf(:,346)) * den(9)
  A(390) = cont_QA(wf(:,10),wf(:,346)) * den(11)
  A(391) = cont_QA(wf(:,11),wf(:,346)) * den(12)
  A(392) = cont_QA(wf(:,11),wf(:,349)) * den(15)
  A(393) = cont_QA(wf(:,11),wf(:,346)) * den(12)
  A(394) = cont_QA(wf(:,16),wf(:,346)) * den(11)
  A(395) = cont_QA(wf(:,11),wf(:,346)) * den(12)
  A(396) = cont_QA(wf(:,11),wf(:,351)) * den(12)
  A(397) = cont_QA(wf(:,19),wf(:,352)) * den(18)
  A(398) = cont_QA(wf(:,21),wf(:,352)) * den(20)
  A(399) = cont_QA(wf(:,23),wf(:,352)) * den(22)
  A(400) = cont_QA(wf(:,23),wf(:,353)) * den(23)
  A(401) = cont_QA(wf(:,23),wf(:,352)) * den(22)
  A(402) = cont_QA(wf(:,26),wf(:,352)) * den(20)
  A(403) = cont_QA(wf(:,23),wf(:,352)) * den(22)
  A(404) = cont_QA(wf(:,23),wf(:,354)) * den(22)
  A(405) = cont_VV(wf(:,28),wf(:,355)) * den(27)
  A(406) = cont_VV(wf(:,28),wf(:,356)) * den(27)
  A(407) = cont_QA(wf(:,32),wf(:,358)) * den(31)
  A(408) = cont_QA(wf(:,35),wf(:,358)) * den(33)
  A(409) = cont_QA(wf(:,36),wf(:,358)) * den(34)
  A(410) = cont_QA(wf(:,36),wf(:,360)) * den(36)
  A(411) = cont_QA(wf(:,36),wf(:,358)) * den(34)
  A(412) = cont_QA(wf(:,40),wf(:,358)) * den(33)
  A(413) = cont_QA(wf(:,36),wf(:,358)) * den(34)
  A(414) = cont_QA(wf(:,36),wf(:,362)) * den(34)
  A(415) = cont_QA(wf(:,42),wf(:,352)) * den(38)
  A(416) = cont_QA(wf(:,44),wf(:,352)) * den(40)
  A(417) = cont_QA(wf(:,46),wf(:,352)) * den(42)
  A(418) = cont_QA(wf(:,46),wf(:,353)) * den(43)
  A(419) = cont_QA(wf(:,46),wf(:,352)) * den(42)
  A(420) = cont_QA(wf(:,48),wf(:,352)) * den(40)
  A(421) = cont_QA(wf(:,46),wf(:,352)) * den(42)
  A(422) = cont_QA(wf(:,46),wf(:,354)) * den(42)
  A(423) = cont_QA(wf(:,50),wf(:,346)) * den(45)
  A(424) = cont_QA(wf(:,52),wf(:,346)) * den(47)
  A(425) = cont_QA(wf(:,53),wf(:,346)) * den(48)
  A(426) = cont_QA(wf(:,53),wf(:,349)) * den(49)
  A(427) = cont_QA(wf(:,53),wf(:,346)) * den(48)
  A(428) = cont_QA(wf(:,55),wf(:,346)) * den(47)
  A(429) = cont_QA(wf(:,53),wf(:,346)) * den(48)
  A(430) = cont_QA(wf(:,53),wf(:,351)) * den(48)
  A(431) = cont_QA(wf(:,58),wf(:,363)) * den(52)
  A(432) = cont_QA(wf(:,60),wf(:,363)) * den(54)
  A(433) = cont_QA(wf(:,62),wf(:,363)) * den(56)
  A(434) = cont_QA(wf(:,62),wf(:,364)) * den(57)
  A(435) = cont_QA(wf(:,62),wf(:,363)) * den(56)
  A(436) = cont_QA(wf(:,65),wf(:,363)) * den(54)
  A(437) = cont_QA(wf(:,62),wf(:,363)) * den(56)
  A(438) = cont_QA(wf(:,62),wf(:,365)) * den(56)
  A(439) = cont_QA(wf(:,67),wf(:,358)) * den(59)
  A(440) = cont_QA(wf(:,69),wf(:,358)) * den(61)
  A(441) = cont_QA(wf(:,70),wf(:,358)) * den(62)
  A(442) = cont_QA(wf(:,70),wf(:,360)) * den(63)
  A(443) = cont_QA(wf(:,70),wf(:,358)) * den(62)
  A(444) = cont_QA(wf(:,72),wf(:,358)) * den(61)
  A(445) = cont_QA(wf(:,70),wf(:,358)) * den(62)
  A(446) = cont_QA(wf(:,70),wf(:,362)) * den(62)
  A(447) = cont_QA(wf(:,74),wf(:,363)) * den(65)
  A(448) = cont_QA(wf(:,76),wf(:,363)) * den(67)
  A(449) = cont_QA(wf(:,78),wf(:,363)) * den(69)
  A(450) = cont_QA(wf(:,78),wf(:,364)) * den(70)
  A(451) = cont_QA(wf(:,78),wf(:,363)) * den(69)
  A(452) = cont_QA(wf(:,80),wf(:,363)) * den(67)
  A(453) = cont_QA(wf(:,78),wf(:,363)) * den(69)
  A(454) = cont_QA(wf(:,78),wf(:,365)) * den(69)
  A(455) = cont_VV(wf(:,366),wf(:,367)) * den(190)
  A(456) = cont_VV(wf(:,368),wf(:,369)) * den(194)
  A(457) = cont_VV(wf(:,4),wf(:,370)) * den(197)
  A(458) = cont_QA(wf(:,151),wf(:,371)) * den(199)
  A(459) = cont_QA(wf(:,152),wf(:,371)) * den(200)
  A(460) = cont_QA(wf(:,153),wf(:,371)) * den(201)
  A(461) = cont_QA(wf(:,155),wf(:,371)) * den(200)
  A(462) = cont_QA(wf(:,153),wf(:,371)) * den(201)
  A(463) = cont_QA(wf(:,19),wf(:,372)) * den(202)
  A(464) = cont_QA(wf(:,21),wf(:,372)) * den(203)
  A(465) = cont_QA(wf(:,23),wf(:,372)) * den(204)
  A(466) = cont_QA(wf(:,26),wf(:,372)) * den(203)
  A(467) = cont_QA(wf(:,23),wf(:,372)) * den(204)
  A(468) = cont_QA(wf(:,144),wf(:,373)) * den(206)
  A(469) = cont_QA(wf(:,147),wf(:,373)) * den(207)
  A(470) = cont_QA(wf(:,144),wf(:,373)) * den(206)
  A(471) = cont_QA(wf(:,8),wf(:,374)) * den(208)
  A(472) = cont_QA(wf(:,14),wf(:,374)) * den(209)
  A(473) = cont_QA(wf(:,8),wf(:,374)) * den(208)
  A(474) = cont_QA(wf(:,151),wf(:,375)) * den(210)
  A(475) = cont_QA(wf(:,152),wf(:,375)) * den(211)
  A(476) = cont_QA(wf(:,153),wf(:,375)) * den(212)
  A(477) = cont_QA(wf(:,153),wf(:,376)) * den(213)
  A(478) = cont_QA(wf(:,153),wf(:,375)) * den(212)
  A(479) = cont_QA(wf(:,155),wf(:,375)) * den(211)
  A(480) = cont_QA(wf(:,153),wf(:,375)) * den(212)
  A(481) = cont_QA(wf(:,153),wf(:,377)) * den(212)
  A(482) = cont_QA(wf(:,144),wf(:,378)) * den(214)
  A(483) = cont_QA(wf(:,144),wf(:,379)) * den(215)
  A(484) = cont_QA(wf(:,144),wf(:,380)) * den(216)
  A(485) = cont_QA(wf(:,147),wf(:,380)) * den(217)
  A(486) = cont_QA(wf(:,144),wf(:,380)) * den(216)
  A(487) = cont_QA(wf(:,144),wf(:,381)) * den(215)
  A(488) = cont_QA(wf(:,144),wf(:,380)) * den(216)
  A(489) = cont_QA(wf(:,144),wf(:,382)) * den(216)
  A(490) = cont_VV(wf(:,367),wf(:,383)) * den(220)
  A(491) = cont_VV(wf(:,384),wf(:,385)) * den(224)
  A(492) = cont_VV(wf(:,29),wf(:,386)) * den(227)
  A(493) = cont_QA(wf(:,214),wf(:,387)) * den(228)
  A(494) = cont_QA(wf(:,215),wf(:,387)) * den(229)
  A(495) = cont_QA(wf(:,216),wf(:,387)) * den(230)
  A(496) = cont_QA(wf(:,218),wf(:,387)) * den(229)
  A(497) = cont_QA(wf(:,216),wf(:,387)) * den(230)
  A(498) = cont_QA(wf(:,42),wf(:,372)) * den(231)
  A(499) = cont_QA(wf(:,44),wf(:,372)) * den(232)
  A(500) = cont_QA(wf(:,46),wf(:,372)) * den(233)
  A(501) = cont_QA(wf(:,48),wf(:,372)) * den(232)
  A(502) = cont_QA(wf(:,46),wf(:,372)) * den(233)
  A(503) = cont_QA(wf(:,144),wf(:,388)) * den(235)
  A(504) = cont_QA(wf(:,147),wf(:,388)) * den(236)
  A(505) = cont_QA(wf(:,144),wf(:,388)) * den(235)
  A(506) = cont_QA(wf(:,214),wf(:,389)) * den(237)
  A(507) = cont_QA(wf(:,215),wf(:,389)) * den(238)
  A(508) = cont_QA(wf(:,216),wf(:,389)) * den(239)
  A(509) = cont_QA(wf(:,216),wf(:,390)) * den(240)
  A(510) = cont_QA(wf(:,216),wf(:,389)) * den(239)
  A(511) = cont_QA(wf(:,218),wf(:,389)) * den(238)
  A(512) = cont_QA(wf(:,216),wf(:,389)) * den(239)
  A(513) = cont_QA(wf(:,216),wf(:,391)) * den(239)
  A(514) = cont_QA(wf(:,144),wf(:,392)) * den(241)
  A(515) = cont_QA(wf(:,144),wf(:,393)) * den(242)
  A(516) = cont_QA(wf(:,144),wf(:,394)) * den(243)
  A(517) = cont_QA(wf(:,147),wf(:,394)) * den(244)
  A(518) = cont_QA(wf(:,144),wf(:,394)) * den(243)
  A(519) = cont_QA(wf(:,144),wf(:,395)) * den(242)
  A(520) = cont_QA(wf(:,144),wf(:,394)) * den(243)
  A(521) = cont_QA(wf(:,144),wf(:,396)) * den(243)
  A(522) = cont_QA(wf(:,33),wf(:,397)) * den(245)
  A(523) = cont_QA(wf(:,38),wf(:,397)) * den(246)
  A(524) = cont_QA(wf(:,33),wf(:,397)) * den(245)
  A(525) = cont_QA(wf(:,166),wf(:,371)) * den(247)
  A(526) = cont_QA(wf(:,167),wf(:,371)) * den(248)
  A(527) = cont_QA(wf(:,168),wf(:,371)) * den(249)
  A(528) = cont_QA(wf(:,169),wf(:,371)) * den(248)
  A(529) = cont_QA(wf(:,168),wf(:,371)) * den(249)
  A(530) = cont_QA(wf(:,58),wf(:,398)) * den(250)
  A(531) = cont_QA(wf(:,60),wf(:,398)) * den(251)
  A(532) = cont_QA(wf(:,62),wf(:,398)) * den(252)
  A(533) = cont_QA(wf(:,65),wf(:,398)) * den(251)
  A(534) = cont_QA(wf(:,62),wf(:,398)) * den(252)
  A(535) = cont_QA(wf(:,160),wf(:,399)) * den(254)
  A(536) = cont_QA(wf(:,163),wf(:,399)) * den(255)
  A(537) = cont_QA(wf(:,160),wf(:,399)) * den(254)
  A(538) = cont_QA(wf(:,8),wf(:,400)) * den(256)
  A(539) = cont_QA(wf(:,14),wf(:,400)) * den(257)
  A(540) = cont_QA(wf(:,8),wf(:,400)) * den(256)
  A(541) = cont_QA(wf(:,166),wf(:,375)) * den(258)
  A(542) = cont_QA(wf(:,167),wf(:,375)) * den(259)
  A(543) = cont_QA(wf(:,168),wf(:,375)) * den(260)
  A(544) = cont_QA(wf(:,168),wf(:,376)) * den(261)
  A(545) = cont_QA(wf(:,168),wf(:,375)) * den(260)
  A(546) = cont_QA(wf(:,169),wf(:,375)) * den(259)
  A(547) = cont_QA(wf(:,168),wf(:,375)) * den(260)
  A(548) = cont_QA(wf(:,168),wf(:,377)) * den(260)
  A(549) = cont_QA(wf(:,160),wf(:,401)) * den(262)
  A(550) = cont_QA(wf(:,160),wf(:,402)) * den(263)
  A(551) = cont_QA(wf(:,160),wf(:,403)) * den(264)
  A(552) = cont_QA(wf(:,163),wf(:,403)) * den(265)
  A(553) = cont_QA(wf(:,160),wf(:,403)) * den(264)
  A(554) = cont_QA(wf(:,160),wf(:,404)) * den(263)
  A(555) = cont_QA(wf(:,160),wf(:,403)) * den(264)
  A(556) = cont_QA(wf(:,160),wf(:,405)) * den(264)
  A(557) = cont_QA(wf(:,229),wf(:,387)) * den(266)
  A(558) = cont_QA(wf(:,230),wf(:,387)) * den(267)
  A(559) = cont_QA(wf(:,231),wf(:,387)) * den(268)
  A(560) = cont_QA(wf(:,232),wf(:,387)) * den(267)
  A(561) = cont_QA(wf(:,231),wf(:,387)) * den(268)
  A(562) = cont_QA(wf(:,74),wf(:,398)) * den(269)
  A(563) = cont_QA(wf(:,76),wf(:,398)) * den(270)
  A(564) = cont_QA(wf(:,78),wf(:,398)) * den(271)
  A(565) = cont_QA(wf(:,80),wf(:,398)) * den(270)
  A(566) = cont_QA(wf(:,78),wf(:,398)) * den(271)
  A(567) = cont_QA(wf(:,160),wf(:,406)) * den(273)
  A(568) = cont_QA(wf(:,163),wf(:,406)) * den(274)
  A(569) = cont_QA(wf(:,160),wf(:,406)) * den(273)
  A(570) = cont_QA(wf(:,229),wf(:,389)) * den(275)
  A(571) = cont_QA(wf(:,230),wf(:,389)) * den(276)
  A(572) = cont_QA(wf(:,231),wf(:,389)) * den(277)
  A(573) = cont_QA(wf(:,231),wf(:,390)) * den(278)
  A(574) = cont_QA(wf(:,231),wf(:,389)) * den(277)
  A(575) = cont_QA(wf(:,232),wf(:,389)) * den(276)
  A(576) = cont_QA(wf(:,231),wf(:,389)) * den(277)
  A(577) = cont_QA(wf(:,231),wf(:,391)) * den(277)
  A(578) = cont_QA(wf(:,160),wf(:,407)) * den(279)
  A(579) = cont_QA(wf(:,160),wf(:,408)) * den(280)
  A(580) = cont_QA(wf(:,160),wf(:,409)) * den(281)
  A(581) = cont_QA(wf(:,163),wf(:,409)) * den(282)
  A(582) = cont_QA(wf(:,160),wf(:,409)) * den(281)
  A(583) = cont_QA(wf(:,160),wf(:,410)) * den(280)
  A(584) = cont_QA(wf(:,160),wf(:,409)) * den(281)
  A(585) = cont_QA(wf(:,160),wf(:,411)) * den(281)
  A(586) = cont_QA(wf(:,33),wf(:,412)) * den(283)
  A(587) = cont_QA(wf(:,38),wf(:,412)) * den(284)
  A(588) = cont_QA(wf(:,33),wf(:,412)) * den(283)
  A(589) = cont_QA(wf(:,322),wf(:,413)) * den(285)
  A(590) = cont_QA(wf(:,322),wf(:,414)) * den(286)
  A(591) = cont_QA(wf(:,322),wf(:,413)) * den(285)
  A(592) = cont_QA(wf(:,324),wf(:,413)) * den(287)
  A(593) = cont_QA(wf(:,322),wf(:,413)) * den(285)
  A(594) = cont_QA(wf(:,322),wf(:,415)) * den(285)
  A(595) = cont_QA(wf(:,327),wf(:,416)) * den(288)
  A(596) = cont_QA(wf(:,327),wf(:,417)) * den(289)
  A(597) = cont_QA(wf(:,327),wf(:,416)) * den(288)
  A(598) = cont_QA(wf(:,329),wf(:,416)) * den(290)
  A(599) = cont_QA(wf(:,327),wf(:,416)) * den(288)
  A(600) = cont_QA(wf(:,327),wf(:,418)) * den(288)
  A(601) = cont_QA(wf(:,322),wf(:,419)) * den(291)
  A(602) = cont_QA(wf(:,324),wf(:,419)) * den(292)
  A(603) = cont_QA(wf(:,322),wf(:,419)) * den(291)
  A(604) = cont_QA(wf(:,327),wf(:,420)) * den(293)
  A(605) = cont_QA(wf(:,329),wf(:,420)) * den(294)
  A(606) = cont_QA(wf(:,327),wf(:,420)) * den(293)
  A(607) = cont_QA(wf(:,89),wf(:,421)) * den(295)
  A(608) = cont_QA(wf(:,91),wf(:,421)) * den(296)
  A(609) = cont_QA(wf(:,89),wf(:,421)) * den(295)
  A(610) = cont_QA(wf(:,83),wf(:,422)) * den(297)
  A(611) = cont_QA(wf(:,85),wf(:,422)) * den(298)
  A(612) = cont_QA(wf(:,83),wf(:,422)) * den(297)
  A(613) = cont_QA(wf(:,332),wf(:,423)) * den(299)
  A(614) = cont_QA(wf(:,332),wf(:,424)) * den(300)
  A(615) = cont_QA(wf(:,332),wf(:,423)) * den(299)
  A(616) = cont_QA(wf(:,334),wf(:,423)) * den(301)
  A(617) = cont_QA(wf(:,332),wf(:,423)) * den(299)
  A(618) = cont_QA(wf(:,332),wf(:,425)) * den(299)
  A(619) = cont_QA(wf(:,337),wf(:,426)) * den(302)
  A(620) = cont_QA(wf(:,337),wf(:,427)) * den(303)
  A(621) = cont_QA(wf(:,337),wf(:,426)) * den(302)
  A(622) = cont_QA(wf(:,339),wf(:,426)) * den(304)
  A(623) = cont_QA(wf(:,337),wf(:,426)) * den(302)
  A(624) = cont_QA(wf(:,337),wf(:,428)) * den(302)
  A(625) = cont_QA(wf(:,332),wf(:,429)) * den(305)
  A(626) = cont_QA(wf(:,334),wf(:,429)) * den(306)
  A(627) = cont_QA(wf(:,332),wf(:,429)) * den(305)
  A(628) = cont_QA(wf(:,337),wf(:,430)) * den(307)
  A(629) = cont_QA(wf(:,339),wf(:,430)) * den(308)
  A(630) = cont_QA(wf(:,337),wf(:,430)) * den(307)
  A(631) = cont_QA(wf(:,101),wf(:,431)) * den(309)
  A(632) = cont_QA(wf(:,103),wf(:,431)) * den(310)
  A(633) = cont_QA(wf(:,101),wf(:,431)) * den(309)
  A(634) = cont_QA(wf(:,95),wf(:,432)) * den(311)
  A(635) = cont_QA(wf(:,97),wf(:,432)) * den(312)
  A(636) = cont_QA(wf(:,95),wf(:,432)) * den(311)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(636)
  complex(REALKIND), intent(out) :: M1(12), M2(12)

  M1( 1) = ((-A(6)-A(13)-A(59)-A(66))*f(1))/2._/**/REALKIND+((-A(7)-A(14)-A(60)-A(67))*f(2))/2._/**/REALKIND+((A(2)-A(3)+A(9) &
        -A(10))*f(24))/2._/**/REALKIND
  M1( 2) = ((A(8)+A(15)+A(63)+A(68))*f(3))/12._/**/REALKIND+((A(30)+A(37)+A(73))*f(3))/4._/**/REALKIND &
        -(CI*A(16)*f(4))/4._/**/REALKIND
  M1( 3) = ((A(21)+A(28)+A(71)+A(74))*f(1))/2._/**/REALKIND+((A(22)+A(29)+A(72)+A(75))*f(2))/2._/**/REALKIND+((-A(17)+A(18)-A(24) &
        +A(25))*f(24))/2._/**/REALKIND
  M1( 4) = ((-A(15)-A(51)-A(68))*f(3))/4._/**/REALKIND+((-A(23)-A(30)-A(73)-A(78))*f(3))/12._/**/REALKIND &
        -(CI*A(1)*f(4))/4._/**/REALKIND
  M1( 5) = ((A(35)+A(42)+A(69)+A(76))*f(1))/2._/**/REALKIND+((A(36)+A(43)+A(70)+A(77))*f(2))/2._/**/REALKIND+((-A(31)+A(32)-A(38) &
        +A(39))*f(24))/2._/**/REALKIND
  M1( 6) = ((-A(8)-A(58)-A(63))*f(3))/4._/**/REALKIND+((-A(37)-A(44)-A(73)-A(78))*f(3))/12._/**/REALKIND &
        +(CI*A(1)*f(4))/4._/**/REALKIND
  M1( 7) = ((-A(4)-A(11)-A(47)-A(54))*f(1))/2._/**/REALKIND+((-A(19)-A(21)-A(26)-A(28)-A(33)-A(35)-A(40)-A(42)-A(69)-A(71)-A(74) &
        -A(76))*f(1))/6._/**/REALKIND+((-A(5)-A(12)-A(48)-A(55))*f(2))/2._/**/REALKIND+((-A(20)-A(22)-A(27)-A(29)-A(34)-A(36) &
        -A(41)-A(43)-A(70)-A(72)-A(75)-A(77))*f(2))/6._/**/REALKIND+((A(17)-A(18)+A(24)-A(25)+A(31)-A(32)+A(38) &
        -A(39))*f(24))/6._/**/REALKIND
  M1( 8) = ((A(8)+A(15)+A(51)+A(58))*f(3))/12._/**/REALKIND+((A(23)+A(30)+A(37)+A(44)+A(73)+A(78))*f(3))/36._/**/REALKIND
  M1( 9) = ((-A(49)-A(56)-A(61)-A(64))*f(1))/2._/**/REALKIND+((-A(50)-A(57)-A(62)-A(65))*f(2))/2._/**/REALKIND+((A(45)-A(46)+A(52) &
        -A(53))*f(24))/2._/**/REALKIND
  M1(10) = ((A(51)+A(58)+A(63)+A(68))*f(3))/12._/**/REALKIND+((A(23)+A(44)+A(78))*f(3))/4._/**/REALKIND &
        +(CI*A(16)*f(4))/4._/**/REALKIND
  M1(11) = ((A(19)+A(26)+A(33)+A(40))*f(1))/2._/**/REALKIND+((A(4)+A(6)+A(11)+A(13)+A(47)+A(49)+A(54)+A(56)+A(59)+A(61)+A(64) &
        +A(66))*f(1))/6._/**/REALKIND+((A(20)+A(27)+A(34)+A(41))*f(2))/2._/**/REALKIND+((A(5)+A(7)+A(12)+A(14)+A(48)+A(50)+A(55) &
        +A(57)+A(60)+A(62)+A(65)+A(67))*f(2))/6._/**/REALKIND+((-A(2)+A(3)-A(9)+A(10)-A(45)+A(46)-A(52) &
        +A(53))*f(24))/6._/**/REALKIND
  M1(12) = ((-A(23)-A(30)-A(37)-A(44))*f(3))/12._/**/REALKIND+((-A(8)-A(15)-A(51)-A(58)-A(63)-A(68))*f(3))/36._/**/REALKIND

  M2( 1) = ((A(460)+A(465)+A(478)+A(486)+A(589)+A(597)+A(604)+A(610))*f(5))/2._/**/REALKIND+((A(92)+A(100)+A(162)+A(170)+A(282) &
        +A(290)+A(296)+A(302)+A(332)+A(338)+A(344)+A(350)+A(368)+A(374)+A(396)+A(404)-A(481)-A(489)-A(594) &
        -A(600))*f(6))/12._/**/REALKIND+((A(461)+A(466)+A(479)+A(487)+A(590)+A(598)+A(605)+A(611))*f(6))/2._/**/REALKIND+((A(122) &
        +A(130)+A(188)+A(222)+A(230)+A(264)+A(308)+A(326)+A(356)+A(380)+A(422)+A(430)-A(521)-A(548)-A(618))*f(6))/4._/**/REALKIND &
        +(CI*(-A(206)-A(240)-A(406))*f(7))/4._/**/REALKIND+((-A(339)-A(371)-A(393)-A(401))*f(8))/2._/**/REALKIND+((-A(340)-A(372) &
        -A(394)-A(402))*f(9))/2._/**/REALKIND+((-A(97)-A(167)-A(291)-A(299))*f(10))/2._/**/REALKIND+((-A(98)-A(168)-A(292) &
        -A(300))*f(11))/2._/**/REALKIND+((-A(347)-A(363))*f(12))/2._/**/REALKIND+((-A(348)-A(364))*f(13))/2._/**/REALKIND+((-A(89) &
        -A(159)-A(279)-A(287)-A(329)-A(333))*f(14))/2._/**/REALKIND+((-A(90)-A(160)-A(280)-A(288)-A(330) &
        -A(334))*f(15))/2._/**/REALKIND+(A(82)*f(16))/2._/**/REALKIND+((-A(458)+A(459)-A(463)+A(464)-A(474)+A(475)-A(482) &
        +A(483))*f(25))/2._/**/REALKIND+((A(389)-A(390)+A(397)-A(398))*f(26))/2._/**/REALKIND+((A(93)-A(94)+A(163) &
        -A(164))*f(27))/2._/**/REALKIND+((A(85)-A(86)+A(155)-A(156)+A(275)-A(276)+A(283)-A(284))*f(28))/2._/**/REALKIND &
        +(A(79)*f(29))/2._/**/REALKIND
  M2( 2) = ((-A(462)-A(467)-A(470)-A(473)-A(480)-A(488)-A(593)-A(599)-A(603)-A(606)-A(609)-A(612))*f(17))/12._/**/REALKIND+(( &
        -A(502)-A(505)-A(520)-A(529)-A(540)-A(547)-A(617)-A(627)-A(636))*f(17))/4._/**/REALKIND+(CI*(-A(490)-A(491) &
        +A(492))*f(18))/4._/**/REALKIND+((A(343)+A(349)+A(367)+A(373)+A(395)+A(403))*f(19))/12._/**/REALKIND+((A(355)+A(379) &
        +A(421)+A(429))*f(19))/4._/**/REALKIND-(CI*A(405)*f(20))/4._/**/REALKIND+((A(121)+A(129)+A(187)+A(221)+A(229)+A(263) &
        +A(307)+A(325))*f(21))/4._/**/REALKIND+((A(91)+A(99)+A(161)+A(169)+A(281)+A(289)+A(295)+A(301)+A(331) &
        +A(337))*f(21))/12._/**/REALKIND+(CI*(-A(205)-A(239))*f(22))/4._/**/REALKIND-(CI*A(106)*f(23))/4._/**/REALKIND
  M2( 3) = ((-A(495)-A(500)-A(510)-A(518)-A(615)-A(619)-A(625)-A(631))*f(5))/2._/**/REALKIND+((-A(100)-A(146)-A(162)-A(196)-A(256) &
        -A(290)-A(302)-A(332)-A(350)-A(374)-A(404)-A(446)+A(489)+A(577)+A(600))*f(6))/4._/**/REALKIND+((-A(114)-A(122)-A(214) &
        -A(222)-A(230)-A(238)-A(308)-A(314)-A(320)-A(326)-A(356)-A(362)-A(380)-A(386)-A(414)-A(422)+A(513)+A(521)+A(618) &
        +A(624))*f(6))/12._/**/REALKIND+((-A(496)-A(501)-A(511)-A(519)-A(616)-A(620)-A(626)-A(632))*f(6))/2._/**/REALKIND+(CI*( &
        -A(172)-A(274)-A(388))*f(7))/4._/**/REALKIND+((A(357)+A(377)+A(411)+A(419))*f(8))/2._/**/REALKIND+((A(358)+A(378)+A(412) &
        +A(420))*f(9))/2._/**/REALKIND+((A(119)+A(235)+A(315)+A(323))*f(10))/2._/**/REALKIND+((A(120)+A(236)+A(316) &
        +A(324))*f(11))/2._/**/REALKIND+((A(353)+A(381))*f(12))/2._/**/REALKIND+((A(354)+A(382))*f(13))/2._/**/REALKIND+((A(111) &
        +A(211)+A(219)+A(227)+A(305)+A(309))*f(14))/2._/**/REALKIND+((A(112)+A(212)+A(220)+A(228)+A(306) &
        +A(310))*f(15))/2._/**/REALKIND-(A(105)*f(16))/2._/**/REALKIND+((A(493)-A(494)+A(498)-A(499)+A(506)-A(507)+A(514) &
        -A(515))*f(25))/2._/**/REALKIND+((-A(407)+A(408)-A(415)+A(416))*f(26))/2._/**/REALKIND+((-A(115)+A(116)-A(231) &
        +A(232))*f(27))/2._/**/REALKIND+((-A(107)+A(108)-A(207)+A(208)-A(215)+A(216)-A(223)+A(224))*f(28))/2._/**/REALKIND &
        -(A(102)*f(29))/2._/**/REALKIND
  M2( 4) = ((A(467)+A(470)+A(488)+A(561)+A(576)+A(588)+A(599)+A(606)+A(609))*f(17))/4._/**/REALKIND+((A(497)+A(502)+A(505)+A(512) &
        +A(520)+A(524)+A(617)+A(623)+A(627)+A(630)+A(633)+A(636))*f(17))/12._/**/REALKIND+(CI*(A(455)-A(456) &
        +A(457))*f(18))/4._/**/REALKIND+((-A(355)-A(361)-A(379)-A(385)-A(413)-A(421))*f(19))/12._/**/REALKIND+((-A(349)-A(373) &
        -A(403)-A(445))*f(19))/4._/**/REALKIND-(CI*A(387)*f(20))/4._/**/REALKIND+((-A(113)-A(121)-A(213)-A(221)-A(229)-A(237) &
        -A(307)-A(313)-A(319)-A(325))*f(21))/12._/**/REALKIND+((-A(99)-A(145)-A(161)-A(195)-A(255)-A(289)-A(301) &
        -A(331))*f(21))/4._/**/REALKIND+(CI*(-A(171)-A(273))*f(22))/4._/**/REALKIND-(CI*A(84)*f(23))/4._/**/REALKIND
  M2( 5) = ((-A(527)-A(532)-A(545)-A(553)-A(613)-A(621)-A(628)-A(634))*f(5))/2._/**/REALKIND+((-A(92)-A(154)-A(170)-A(204)-A(248) &
        -A(282)-A(296)-A(338)-A(344)-A(368)-A(396)-A(454)+A(481)+A(585)+A(594))*f(6))/4._/**/REALKIND+((-A(130)-A(138)-A(180) &
        -A(188)-A(264)-A(272)-A(308)-A(314)-A(320)-A(326)-A(356)-A(362)-A(380)-A(386)-A(430)-A(438)+A(548)+A(556)+A(618) &
        +A(624))*f(6))/12._/**/REALKIND+((-A(528)-A(533)-A(546)-A(554)-A(614)-A(622)-A(629)-A(635))*f(6))/2._/**/REALKIND &
        +(CI*(A(172)+A(274)+A(388))*f(7))/4._/**/REALKIND+((A(351)+A(383)+A(427)+A(435))*f(8))/2._/**/REALKIND+((A(352)+A(384) &
        +A(428)+A(436))*f(9))/2._/**/REALKIND+((A(135)+A(185)+A(303)+A(311))*f(10))/2._/**/REALKIND+((A(136)+A(186)+A(304) &
        +A(312))*f(11))/2._/**/REALKIND+((A(359)+A(375))*f(12))/2._/**/REALKIND+((A(360)+A(376))*f(13))/2._/**/REALKIND+((A(127) &
        +A(177)+A(261)+A(269)+A(317)+A(321))*f(14))/2._/**/REALKIND+((A(128)+A(178)+A(262)+A(270)+A(318) &
        +A(322))*f(15))/2._/**/REALKIND-(A(104)*f(16))/2._/**/REALKIND+((A(525)-A(526)+A(530)-A(531)+A(541)-A(542)+A(549) &
        -A(550))*f(25))/2._/**/REALKIND+((-A(423)+A(424)-A(431)+A(432))*f(26))/2._/**/REALKIND+((-A(131)+A(132)-A(181) &
        +A(182))*f(27))/2._/**/REALKIND+((-A(123)+A(124)-A(173)+A(174)-A(257)+A(258)-A(265)+A(266))*f(28))/2._/**/REALKIND &
        -(A(101)*f(29))/2._/**/REALKIND
  M2( 6) = ((A(462)+A(473)+A(480)+A(566)+A(569)+A(584)+A(593)+A(603)+A(612))*f(17))/4._/**/REALKIND+((A(529)+A(534)+A(537)+A(540) &
        +A(547)+A(555)+A(617)+A(623)+A(627)+A(630)+A(633)+A(636))*f(17))/12._/**/REALKIND+(CI*(-A(455)+A(456) &
        -A(457))*f(18))/4._/**/REALKIND+((-A(355)-A(361)-A(379)-A(385)-A(429)-A(437))*f(19))/12._/**/REALKIND+((-A(343)-A(367) &
        -A(395)-A(453))*f(19))/4._/**/REALKIND+(CI*A(387)*f(20))/4._/**/REALKIND+((-A(129)-A(137)-A(179)-A(187)-A(263)-A(271) &
        -A(307)-A(313)-A(319)-A(325))*f(21))/12._/**/REALKIND+((-A(91)-A(153)-A(169)-A(203)-A(247)-A(281)-A(295) &
        -A(337))*f(21))/4._/**/REALKIND+(CI*(A(171)+A(273))*f(22))/4._/**/REALKIND+(CI*A(84)*f(23))/4._/**/REALKIND
  M2( 7) = ((A(468)+A(471)+A(476)+A(484)+A(567)+A(572)+A(580)+A(586))*f(5))/2._/**/REALKIND+((A(495)+A(500)+A(503)+A(508)+A(510) &
        +A(516)+A(518)+A(522)+A(527)+A(532)+A(535)+A(538)+A(543)+A(545)+A(551)+A(553)+A(613)+A(615)+A(619)+A(621)+A(625)+A(628) &
        +A(631)+A(634))*f(5))/6._/**/REALKIND+((A(92)+A(100)+A(146)+A(154)+A(162)+A(170)+A(196)+A(204)+A(248)+A(256)+A(282)+A(290) &
        +A(396)+A(404)+A(446)+A(454)-A(481)-A(489)-A(577)-A(585))*f(6))/12._/**/REALKIND+((A(469)+A(472)+A(477)+A(485)+A(568) &
        +A(573)+A(581)+A(587))*f(6))/2._/**/REALKIND+((A(114)+A(122)+A(130)+A(138)+A(180)+A(188)+A(214)+A(222)+A(230)+A(238) &
        +A(264)+A(272)+A(308)+A(314)+A(320)+A(326)+A(356)+A(362)+A(380)+A(386)+A(414)+A(422)+A(430)+A(438)-A(513)-A(521)-A(548) &
        -A(556)-A(618)-A(624))*f(6))/36._/**/REALKIND+((A(496)+A(501)+A(504)+A(509)+A(511)+A(517)+A(519)+A(523)+A(528)+A(533) &
        +A(536)+A(539)+A(544)+A(546)+A(552)+A(554)+A(614)+A(616)+A(620)+A(622)+A(626)+A(629)+A(632)+A(635))*f(6))/6._/**/REALKIND &
        +((-A(351)-A(357)-A(377)-A(383)-A(411)-A(419)-A(427)-A(435))*f(8))/6._/**/REALKIND+((-A(352)-A(358)-A(378)-A(384)-A(412) &
        -A(420)-A(428)-A(436))*f(9))/6._/**/REALKIND+((-A(87)-A(141)-A(157)-A(191)-A(199)-A(243)-A(277) &
        -A(285))*f(10))/2._/**/REALKIND+((-A(109)-A(119)-A(125)-A(135)-A(175)-A(185)-A(209)-A(217)-A(225)-A(235)-A(259)-A(267) &
        -A(303)-A(311)-A(315)-A(323))*f(10))/6._/**/REALKIND+((-A(88)-A(142)-A(158)-A(192)-A(200)-A(244)-A(278) &
        -A(286))*f(11))/2._/**/REALKIND+((-A(110)-A(120)-A(126)-A(136)-A(176)-A(186)-A(210)-A(218)-A(226)-A(236)-A(260)-A(268) &
        -A(304)-A(312)-A(316)-A(324))*f(11))/6._/**/REALKIND+((-A(353)-A(359)-A(375)-A(381)-A(409)-A(417)-A(425) &
        -A(433))*f(12))/6._/**/REALKIND+((-A(391)-A(399)-A(441)-A(449))*f(12))/2._/**/REALKIND+((-A(354)-A(360)-A(376)-A(382) &
        -A(410)-A(418)-A(426)-A(434))*f(13))/6._/**/REALKIND+((-A(392)-A(400)-A(442)-A(450))*f(13))/2._/**/REALKIND+((-A(95) &
        -A(149)-A(165)-A(251))*f(14))/2._/**/REALKIND+((-A(111)-A(117)-A(127)-A(133)-A(177)-A(183)-A(211)-A(219)-A(227)-A(233) &
        -A(261)-A(269)-A(305)-A(309)-A(317)-A(321))*f(14))/6._/**/REALKIND+((-A(96)-A(150)-A(166)-A(252))*f(15))/2._/**/REALKIND &
        +((-A(112)-A(118)-A(128)-A(134)-A(178)-A(184)-A(212)-A(220)-A(228)-A(234)-A(262)-A(270)-A(306)-A(310)-A(318) &
        -A(322))*f(15))/6._/**/REALKIND+(A(81)*f(16))/2._/**/REALKIND+((A(103)+A(104)+A(105))*f(16))/6._/**/REALKIND+((-A(493) &
        +A(494)-A(498)+A(499)-A(506)+A(507)-A(514)+A(515)-A(525)+A(526)-A(530)+A(531)-A(541)+A(542)-A(549) &
        +A(550))*f(25))/6._/**/REALKIND+((A(407)-A(408)+A(415)-A(416)+A(423)-A(424)+A(431)-A(432))*f(26))/6._/**/REALKIND+((A(115) &
        -A(116)+A(131)-A(132)+A(181)-A(182)+A(231)-A(232))*f(27))/6._/**/REALKIND+((A(107)-A(108)+A(123)-A(124)+A(173)-A(174) &
        +A(207)-A(208)+A(215)-A(216)+A(223)-A(224)+A(257)-A(258)+A(265)-A(266))*f(28))/6._/**/REALKIND+((A(101) &
        +A(102))*f(29))/6._/**/REALKIND
  M2( 8) = ((-A(462)-A(467)-A(470)-A(473)-A(480)-A(488)-A(561)-A(566)-A(569)-A(576)-A(584)-A(588))*f(17))/12._/**/REALKIND+(( &
        -A(497)-A(502)-A(505)-A(512)-A(520)-A(524)-A(529)-A(534)-A(537)-A(540)-A(547)-A(555)-A(617)-A(623)-A(627)-A(630)-A(633) &
        -A(636))*f(17))/36._/**/REALKIND+((A(355)+A(361)+A(379)+A(385)+A(413)+A(421)+A(429)+A(437))*f(19))/36._/**/REALKIND &
        +((A(395)+A(403)+A(445)+A(453))*f(19))/12._/**/REALKIND+((A(91)+A(99)+A(145)+A(153)+A(161)+A(169)+A(195)+A(203)+A(247) &
        +A(255)+A(281)+A(289))*f(21))/12._/**/REALKIND+((A(113)+A(121)+A(129)+A(137)+A(179)+A(187)+A(213)+A(221)+A(229)+A(237) &
        +A(263)+A(271)+A(307)+A(313)+A(319)+A(325))*f(21))/36._/**/REALKIND
  M2( 9) = ((A(559)+A(564)+A(574)+A(582)+A(591)+A(595)+A(601)+A(607))*f(5))/2._/**/REALKIND+((A(146)+A(154)+A(196)+A(204)+A(248) &
        +A(256)+A(296)+A(302)+A(332)+A(338)+A(344)+A(350)+A(368)+A(374)+A(446)+A(454)-A(577)-A(585)-A(594) &
        -A(600))*f(6))/12._/**/REALKIND+((A(560)+A(565)+A(575)+A(583)+A(592)+A(596)+A(602)+A(608))*f(6))/2._/**/REALKIND+((A(114) &
        +A(138)+A(180)+A(214)+A(238)+A(272)+A(314)+A(320)+A(362)+A(386)+A(414)+A(438)-A(513)-A(556)-A(624))*f(6))/4._/**/REALKIND &
        +(CI*(A(206)+A(240)+A(406))*f(7))/4._/**/REALKIND+((-A(345)-A(365)-A(443)-A(451))*f(8))/2._/**/REALKIND+((-A(346)-A(366) &
        -A(444)-A(452))*f(9))/2._/**/REALKIND+((-A(151)-A(253)-A(327)-A(335))*f(10))/2._/**/REALKIND+((-A(152)-A(254)-A(328) &
        -A(336))*f(11))/2._/**/REALKIND+((-A(341)-A(369))*f(12))/2._/**/REALKIND+((-A(342)-A(370))*f(13))/2._/**/REALKIND+(( &
        -A(143)-A(193)-A(201)-A(245)-A(293)-A(297))*f(14))/2._/**/REALKIND+((-A(144)-A(194)-A(202)-A(246)-A(294) &
        -A(298))*f(15))/2._/**/REALKIND+(A(83)*f(16))/2._/**/REALKIND+((-A(557)+A(558)-A(562)+A(563)-A(570)+A(571)-A(578) &
        +A(579))*f(25))/2._/**/REALKIND+((A(439)-A(440)+A(447)-A(448))*f(26))/2._/**/REALKIND+((A(147)-A(148)+A(249) &
        -A(250))*f(27))/2._/**/REALKIND+((A(139)-A(140)+A(189)-A(190)+A(197)-A(198)+A(241)-A(242))*f(28))/2._/**/REALKIND &
        +(A(80)*f(29))/2._/**/REALKIND
  M2(10) = ((-A(561)-A(566)-A(569)-A(576)-A(584)-A(588)-A(593)-A(599)-A(603)-A(606)-A(609)-A(612))*f(17))/12._/**/REALKIND+(( &
        -A(497)-A(512)-A(524)-A(534)-A(537)-A(555)-A(623)-A(630)-A(633))*f(17))/4._/**/REALKIND+(CI*(A(490)+A(491) &
        -A(492))*f(18))/4._/**/REALKIND+((A(361)+A(385)+A(413)+A(437))*f(19))/4._/**/REALKIND+((A(343)+A(349)+A(367)+A(373)+A(445) &
        +A(453))*f(19))/12._/**/REALKIND+(CI*A(405)*f(20))/4._/**/REALKIND+((A(113)+A(137)+A(179)+A(213)+A(237)+A(271)+A(313) &
        +A(319))*f(21))/4._/**/REALKIND+((A(145)+A(153)+A(195)+A(203)+A(247)+A(255)+A(295)+A(301)+A(331) &
        +A(337))*f(21))/12._/**/REALKIND+(CI*(A(205)+A(239))*f(22))/4._/**/REALKIND+(CI*A(106)*f(23))/4._/**/REALKIND
  M2(11) = ((-A(503)-A(508)-A(516)-A(522)-A(535)-A(538)-A(543)-A(551))*f(5))/2._/**/REALKIND+((-A(460)-A(465)-A(468)-A(471)-A(476) &
        -A(478)-A(484)-A(486)-A(559)-A(564)-A(567)-A(572)-A(574)-A(580)-A(582)-A(586)-A(589)-A(591)-A(595)-A(597)-A(601)-A(604) &
        -A(607)-A(610))*f(5))/6._/**/REALKIND+((-A(504)-A(509)-A(517)-A(523)-A(536)-A(539)-A(544)-A(552))*f(6))/2._/**/REALKIND+(( &
        -A(114)-A(122)-A(130)-A(138)-A(180)-A(188)-A(214)-A(222)-A(230)-A(238)-A(264)-A(272)-A(414)-A(422)-A(430)-A(438)+A(513) &
        +A(521)+A(548)+A(556))*f(6))/12._/**/REALKIND+((-A(92)-A(100)-A(146)-A(154)-A(162)-A(170)-A(196)-A(204)-A(248)-A(256) &
        -A(282)-A(290)-A(296)-A(302)-A(332)-A(338)-A(344)-A(350)-A(368)-A(374)-A(396)-A(404)-A(446)-A(454)+A(481)+A(489)+A(577) &
        +A(585)+A(594)+A(600))*f(6))/36._/**/REALKIND+((-A(461)-A(466)-A(469)-A(472)-A(477)-A(479)-A(485)-A(487)-A(560)-A(565) &
        -A(568)-A(573)-A(575)-A(581)-A(583)-A(587)-A(590)-A(592)-A(596)-A(598)-A(602)-A(605)-A(608)-A(611))*f(6))/6._/**/REALKIND &
        +((A(339)+A(345)+A(365)+A(371)+A(393)+A(401)+A(443)+A(451))*f(8))/6._/**/REALKIND+((A(340)+A(346)+A(366)+A(372)+A(394) &
        +A(402)+A(444)+A(452))*f(9))/6._/**/REALKIND+((A(109)+A(125)+A(175)+A(209)+A(217)+A(225)+A(259) &
        +A(267))*f(10))/2._/**/REALKIND+((A(87)+A(97)+A(141)+A(151)+A(157)+A(167)+A(191)+A(199)+A(243)+A(253)+A(277)+A(285)+A(291) &
        +A(299)+A(327)+A(335))*f(10))/6._/**/REALKIND+((A(110)+A(126)+A(176)+A(210)+A(218)+A(226)+A(260) &
        +A(268))*f(11))/2._/**/REALKIND+((A(88)+A(98)+A(142)+A(152)+A(158)+A(168)+A(192)+A(200)+A(244)+A(254)+A(278)+A(286)+A(292) &
        +A(300)+A(328)+A(336))*f(11))/6._/**/REALKIND+((A(409)+A(417)+A(425)+A(433))*f(12))/2._/**/REALKIND+((A(341)+A(347)+A(363) &
        +A(369)+A(391)+A(399)+A(441)+A(449))*f(12))/6._/**/REALKIND+((A(410)+A(418)+A(426)+A(434))*f(13))/2._/**/REALKIND+((A(342) &
        +A(348)+A(364)+A(370)+A(392)+A(400)+A(442)+A(450))*f(13))/6._/**/REALKIND+((A(117)+A(133)+A(183) &
        +A(233))*f(14))/2._/**/REALKIND+((A(89)+A(95)+A(143)+A(149)+A(159)+A(165)+A(193)+A(201)+A(245)+A(251)+A(279)+A(287)+A(293) &
        +A(297)+A(329)+A(333))*f(14))/6._/**/REALKIND+((A(118)+A(134)+A(184)+A(234))*f(15))/2._/**/REALKIND+((A(90)+A(96)+A(144) &
        +A(150)+A(160)+A(166)+A(194)+A(202)+A(246)+A(252)+A(280)+A(288)+A(294)+A(298)+A(330)+A(334))*f(15))/6._/**/REALKIND+(( &
        -A(81)-A(82)-A(83))*f(16))/6._/**/REALKIND-(A(103)*f(16))/2._/**/REALKIND+((A(458)-A(459)+A(463)-A(464)+A(474)-A(475) &
        +A(482)-A(483)+A(557)-A(558)+A(562)-A(563)+A(570)-A(571)+A(578)-A(579))*f(25))/6._/**/REALKIND+((-A(389)+A(390)-A(397) &
        +A(398)-A(439)+A(440)-A(447)+A(448))*f(26))/6._/**/REALKIND+((-A(93)+A(94)-A(147)+A(148)-A(163)+A(164)-A(249) &
        +A(250))*f(27))/6._/**/REALKIND+((-A(85)+A(86)-A(139)+A(140)-A(155)+A(156)-A(189)+A(190)-A(197)+A(198)-A(241)+A(242) &
        -A(275)+A(276)-A(283)+A(284))*f(28))/6._/**/REALKIND+((-A(79)-A(80))*f(29))/6._/**/REALKIND
  M2(12) = ((A(497)+A(502)+A(505)+A(512)+A(520)+A(524)+A(529)+A(534)+A(537)+A(540)+A(547)+A(555))*f(17))/12._/**/REALKIND+((A(462) &
        +A(467)+A(470)+A(473)+A(480)+A(488)+A(561)+A(566)+A(569)+A(576)+A(584)+A(588)+A(593)+A(599)+A(603)+A(606)+A(609) &
        +A(612))*f(17))/36._/**/REALKIND+((-A(413)-A(421)-A(429)-A(437))*f(19))/12._/**/REALKIND+((-A(343)-A(349)-A(367)-A(373) &
        -A(395)-A(403)-A(445)-A(453))*f(19))/36._/**/REALKIND+((-A(113)-A(121)-A(129)-A(137)-A(179)-A(187)-A(213)-A(221)-A(229) &
        -A(237)-A(263)-A(271))*f(21))/12._/**/REALKIND+((-A(91)-A(99)-A(145)-A(153)-A(161)-A(169)-A(195)-A(203)-A(247)-A(255) &
        -A(281)-A(289)-A(295)-A(301)-A(331)-A(337))*f(21))/36._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pptttt_ew_uuxtttxtx_1_/**/REALKIND
