
module ol_colourmatrix_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,12), KL(12,12)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  2,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(  3,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  4,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(  5,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  6,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(  7,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  8,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(  9,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 10,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1( 11,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 12,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]
  K1( 13,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 14,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 15,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 16,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 17,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 18,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 19,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 20,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 21,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 22,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 23,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 24,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 25,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1( 26,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1( 27,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1( 28,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1( 29,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1( 30,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1( 31,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1( 32,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1( 33,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1( 34,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1( 35,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1( 36,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1( 37,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 38,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 39,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 40,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 41,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 42,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 43,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 44,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 45,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 46,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 47,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 48,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 49,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1( 50,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 51,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1( 52,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1( 53,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1( 54,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1( 55,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1( 56,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1( 57,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1( 58,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1( 59,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1( 60,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1( 61,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1( 62,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1( 63,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1( 64,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1( 65,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1( 66,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1( 67,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1( 68,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1( 69,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1( 70,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1( 71,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1( 72,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1( 73,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 74,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 75,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 76,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 77,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 78,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 79,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 80,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 81,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 82,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 83,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 84,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 85,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1( 86,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1( 87,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1( 88,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1( 89,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1( 90,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1( 91,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1( 92,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1( 93,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1( 94,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1( 95,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1( 96,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1( 97,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1( 98,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 99,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(100,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(101,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(102,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(103,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(104,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(105,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1(106,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1(107,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(108,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(109,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(110,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(111,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(112,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(113,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1(114,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1(115,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1(116,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1(117,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1(118,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1(119,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1(120,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1(121,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(122,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(123,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(124,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(125,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(126,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(127,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(128,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(129,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(130,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(131,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(132,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(133,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1(134,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1(136,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1(137,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1(138,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1(139,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1(140,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1(141,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1(142,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1(143,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1(144,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1(145,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(146,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(147,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(148,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(149,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(150,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(151,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(152,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(153,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(154,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(155,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(156,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(157,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(158,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(159,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(160,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(161,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(162,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(163,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1(164,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1(165,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(166,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(167,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(168,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(169,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1(170,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1(171,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(172,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(173,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1(174,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1(175,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(176,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(177,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(178,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(179,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(180,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(181,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(182,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(183,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(184,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(185,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(186,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(187,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(188,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(189,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(190,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(191,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(192,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(193,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(194,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(195,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(196,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(197,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(198,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(199,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1(200,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1(201,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(202,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(203,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(204,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(205,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1(206,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1(207,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1(208,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1(209,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(210,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(211,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(212,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(213,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(214,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(215,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(216,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(217,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1(218,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1(219,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1(220,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1(221,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(222,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(223,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1(224,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1(225,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(226,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(227,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1(228,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1(229,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1(230,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1(231,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1(232,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1(233,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1(234,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1(235,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(236,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(237,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1(238,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1(239,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(240,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(241,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1(242,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1(243,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1(244,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1(245,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1(246,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1(247,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(248,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(249,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1(250,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1(251,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(252,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(253,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(254,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(255,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(256,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(257,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(258,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(259,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(260,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(261,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(262,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(263,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(264,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(265,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(266,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(267,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(268,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(269,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(270,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(271,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(272,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(273,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(274,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1(275,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(276,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]

  K2( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  K2( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  K2( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  K2( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  K2( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  K2( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  K2( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  K2( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  K2( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  K2(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  K2(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  K2(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]

  KL( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  KL( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  KL( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  KL( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  KL( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  KL( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  KL( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  KL( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  KL( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  KL(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  KL(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  KL(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_ew_tttxtxddx_1_/**/REALKIND



module ol_forced_parameters_pptttt_ew_tttxtxddx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_ew_tttxtxddx_1_/**/REALKIND

module ol_loop_pptttt_ew_tttxtxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(67), c(120)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:536)
  ! denominators
  complex(REALKIND), save :: den(495)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(12,64), Mct(12,64), Mcol_loop(12,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 2) = (4*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 3) = CI*eQED**2*gQCD**2
    f( 4) = CI*gQCD**4
    f( 5) = gQCD**4
    f( 6) = (2*CI*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 7) = (4*CI*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 8) = CI*countertermnorm*eQED**2*gQCD**4
    f( 9) = countertermnorm*eQED**2*gQCD**4
    f(10) = (2*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f(11) = (4*CI*countertermnorm*ctGqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f(12) = CI*countertermnorm*ctGqq*eQED**2*gQCD**4
    f(13) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(14) = (4*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(15) = CI*countertermnorm*ctGtt*eQED**2*gQCD**4
    f(16) = (2*CI*countertermnorm*ctVqq*eQED**2*gQCD**4)/9._/**/REALKIND
    f(17) = CI*countertermnorm*ctVqq*eQED**2*gQCD**4
    f(18) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(19) = (4*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(20) = CI*countertermnorm*ctVtt*eQED**2*gQCD**4
    f(21) = countertermnorm*ctZGG*eQED**2*gQCD**4
    f(22) = CI*countertermnorm*gQCD**6
    f(23) = countertermnorm*gQCD**6
    f(24) = CI*countertermnorm*ctGqq*gQCD**6
    f(25) = countertermnorm*ctGqq*gQCD**6
    f(26) = CI*countertermnorm*ctGtt*gQCD**6
    f(27) = countertermnorm*ctGtt*gQCD**6
    f(28) = countertermnorm*ctVVV*gQCD**6
    f(29) = (CI*eQED**2*gQCD**2*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(30) = (CI*countertermnorm*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(31) = (CI*countertermnorm*ctGqq*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(32) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(33) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(34) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(35) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(36) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(37) = (4*CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(38) = CI*eQED**2*gQCD**4*integralnorm*SwB
    f(39) = (eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(40) = (2*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(41) = (4*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(42) = (eQED**2*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f(43) = eQED**2*gQCD**4*integralnorm*SwB
    f(44) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(45) = CI*gQCD**6*integralnorm*SwB
    f(46) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(47) = gQCD**6*integralnorm*SwB
    f(48) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(49) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(50) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(51) = (eQED**2*gQCD**4*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(52) = (CI*eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(53) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*8._/**/REALKIND)
    f(54) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(55) = (eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(56) = (2*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(57) = (4*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(58) = (8*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(59) = eQED**2*gQCD**4*integralnorm*SwF
    f(60) = 2*eQED**2*gQCD**4*integralnorm*SwF
    f(61) = CI*gQCD**6*integralnorm*SwF
    f(62) = 2*CI*gQCD**6*integralnorm*SwF
    f(63) = gQCD**6*integralnorm*SwF
    f(64) = 2*gQCD**6*integralnorm*SwF
    f(65) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(66) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(67) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*2._/**/REALKIND)

  c = [ 54*CI*f(35), 54*CI*f(36), 162*CI*f(36), 54*CI*f(37), 162*CI*f(37), 54*CI*f(38), 162*CI*f(38), 6*f(39), 18*f(39), 54*f(39) &
    , 108*f(39), 324*f(39), 6*f(40), 18*f(40), 36*f(40), 48*f(40), 54*f(40), 60*f(40), 108*f(40), 126*f(40), 144*f(40), 324*f(40) &
    , 6*f(41), 18*f(41), 36*f(41), 48*f(41), 54*f(41), 60*f(41), 108*f(41), 126*f(41), 144*f(41), 324*f(41), 108*f(42), 324*f(42) &
    , 6*f(43), 18*f(43), 36*f(43), 48*f(43), 54*f(43), 60*f(43), 108*f(43), 126*f(43), 144*f(43), 324*f(43), 81*CI*f(44) &
    , 162*CI*f(44), 9*CI*f(45), 27*CI*f(45), 72*CI*f(45), 81*CI*f(45), 162*CI*f(45), 18*f(46), 54*f(46), 162*f(46), f(47), 3*f(47) &
    , 6*f(47), 8*f(47), 9*f(47), 10*f(47), 18*f(47), 21*f(47), 24*f(47), 27*f(47), 30*f(47), 54*f(47), 63*f(47), 72*f(47) &
    , 81*f(47), 162*f(47), 54*CI*f(48), 6*f(49), 18*f(49), 54*f(49), 54*CI*f(50), 6*f(51), 18*f(51), 54*f(51), 54*CI*f(52) &
    , 162*CI*f(52), 108*f(53), 324*f(53), 6*f(54), 18*f(54), 36*f(54), 48*f(54), 54*f(54), 60*f(54), 108*f(54), 126*f(54) &
    , 144*f(54), 324*f(54), 18*f(55), 54*f(55), 18*f(56), 54*f(56), 18*f(57), 54*f(57), 18*f(58), 54*f(58), 18*f(59), 54*f(59) &
    , 18*f(60), 54*f(60), 27*CI*f(61), 27*CI*f(62), 3*f(63), 6*f(63), 9*f(63), 27*f(63), 3*f(64), 6*f(64), 9*f(64), 27*f(64) &
    , 18*f(65), 54*f(65), 18*f(66), 54*f(66), 18*f(67), 54*f(67) ]
  c = (1._/**/REALKIND / 216) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(12), M2(12)
  complex(REALKIND) :: A(636)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_Q(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_A(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), 0)
    call pol_wf_Q(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_A(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,3))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,4))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,5))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,6))
  call prop_Q_A(wf(:,5),Q(:,21),ZERO,0_intkind1,wf(:,7))
  call vert_QA_Z(gZu,wf(:,0),wf(:,-2),wf(:,8))
  call vert_ZQ_A(gZd,wf(:,8),wf(:,-4),wf(:,9))
  call prop_Q_A(wf(:,9),Q(:,21),ZERO,0_intkind1,wf(:,10))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,-3),wf(:,11))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,11),wf(:,12))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,13))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,14))
  call prop_Q_A(wf(:,13),Q(:,26),ZERO,0_intkind1,wf(:,15))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,8),wf(:,16))
  call vert_ZQ_A(gZd,wf(:,11),wf(:,-4),wf(:,17))
  call prop_Q_A(wf(:,17),Q(:,26),ZERO,0_intkind1,wf(:,18))
  call vert_AQ_S(gH,wf(:,-2),wf(:,0),wf(:,19))
  call vert_QS_A(gH,wf(:,-1),wf(:,19),wf(:,20))
  call vert_AV_Q(wf(:,-3),wf(:,3),wf(:,21))
  call prop_Q_A(wf(:,20),Q(:,7),MT,1_intkind1,wf(:,22))
  call vert_AQ_S(gX,wf(:,-2),wf(:,0),wf(:,23))
  call vert_QS_A(gX,wf(:,-1),wf(:,23),wf(:,24))
  call prop_Q_A(wf(:,24),Q(:,7),MT,1_intkind1,wf(:,25))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,26))
  call prop_Q_A(wf(:,26),Q(:,7),MT,1_intkind1,wf(:,27))
  call vert_ZQ_A(gZu,wf(:,8),wf(:,-1),wf(:,28))
  call prop_Q_A(wf(:,28),Q(:,7),MT,1_intkind1,wf(:,29))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,-5),wf(:,30))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,30),wf(:,31))
  call vert_VQ_A(wf(:,3),wf(:,-1),wf(:,32))
  call vert_SA_Q(gH,wf(:,19),wf(:,-3),wf(:,33))
  call prop_Q_A(wf(:,32),Q(:,50),MT,1_intkind1,wf(:,34))
  call vert_SA_Q(gX,wf(:,23),wf(:,-3),wf(:,35))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,36))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,8),wf(:,37))
  call vert_ZQ_A(gZu,wf(:,30),wf(:,-1),wf(:,38))
  call prop_Q_A(wf(:,38),Q(:,50),MT,1_intkind1,wf(:,39))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,40))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,41))
  call vert_UV_W(wf(:,41),Q(:,6),wf(:,40),Q(:,9),wf(:,42))
  call vert_VQ_A(wf(:,40),wf(:,-4),wf(:,43))
  call vert_AV_Q(wf(:,-5),wf(:,41),wf(:,44))
  call prop_Q_A(wf(:,43),Q(:,25),ZERO,0_intkind1,wf(:,45))
  call vert_QA_Z(gZu,wf(:,0),wf(:,-3),wf(:,46))
  call vert_ZQ_A(gZd,wf(:,46),wf(:,-4),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,25),ZERO,0_intkind1,wf(:,48))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,-2),wf(:,49))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,49),wf(:,50))
  call vert_VQ_A(wf(:,41),wf(:,-4),wf(:,51))
  call vert_AV_Q(wf(:,-5),wf(:,40),wf(:,52))
  call prop_Q_A(wf(:,51),Q(:,22),ZERO,0_intkind1,wf(:,53))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,46),wf(:,54))
  call vert_ZQ_A(gZd,wf(:,49),wf(:,-4),wf(:,55))
  call prop_Q_A(wf(:,55),Q(:,22),ZERO,0_intkind1,wf(:,56))
  call vert_AQ_S(gH,wf(:,-2),wf(:,-1),wf(:,57))
  call vert_QS_A(gH,wf(:,0),wf(:,57),wf(:,58))
  call prop_Q_A(wf(:,58),Q(:,7),MT,1_intkind1,wf(:,59))
  call vert_AQ_S(gX,wf(:,-2),wf(:,-1),wf(:,60))
  call vert_QS_A(gX,wf(:,0),wf(:,60),wf(:,61))
  call prop_Q_A(wf(:,61),Q(:,7),MT,1_intkind1,wf(:,62))
  call vert_VQ_A(wf(:,41),wf(:,0),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,7),MT,1_intkind1,wf(:,64))
  call vert_ZQ_A(gZu,wf(:,49),wf(:,0),wf(:,65))
  call prop_Q_A(wf(:,65),Q(:,7),MT,1_intkind1,wf(:,66))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,67))
  call vert_SA_Q(gH,wf(:,57),wf(:,-3),wf(:,68))
  call prop_Q_A(wf(:,67),Q(:,49),MT,1_intkind1,wf(:,69))
  call vert_SA_Q(gX,wf(:,60),wf(:,-3),wf(:,70))
  call vert_AV_Q(wf(:,-3),wf(:,41),wf(:,71))
  call vert_ZQ_A(gZu,wf(:,30),wf(:,0),wf(:,72))
  call prop_Q_A(wf(:,72),Q(:,49),MT,1_intkind1,wf(:,73))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,49),wf(:,74))
  call vert_AQ_S(gH,wf(:,-3),wf(:,0),wf(:,75))
  call vert_QS_A(gH,wf(:,-1),wf(:,75),wf(:,76))
  call vert_AV_Q(wf(:,-2),wf(:,3),wf(:,77))
  call prop_Q_A(wf(:,76),Q(:,11),MT,1_intkind1,wf(:,78))
  call vert_AQ_S(gX,wf(:,-3),wf(:,0),wf(:,79))
  call vert_QS_A(gX,wf(:,-1),wf(:,79),wf(:,80))
  call prop_Q_A(wf(:,80),Q(:,11),MT,1_intkind1,wf(:,81))
  call vert_VQ_A(wf(:,40),wf(:,-1),wf(:,82))
  call prop_Q_A(wf(:,82),Q(:,11),MT,1_intkind1,wf(:,83))
  call vert_ZQ_A(gZu,wf(:,46),wf(:,-1),wf(:,84))
  call prop_Q_A(wf(:,84),Q(:,11),MT,1_intkind1,wf(:,85))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,30),wf(:,86))
  call vert_SA_Q(gH,wf(:,75),wf(:,-2),wf(:,87))
  call vert_SA_Q(gX,wf(:,79),wf(:,-2),wf(:,88))
  call vert_AV_Q(wf(:,-2),wf(:,40),wf(:,89))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,46),wf(:,90))
  call vert_AQ_S(gH,wf(:,-3),wf(:,-1),wf(:,91))
  call vert_QS_A(gH,wf(:,0),wf(:,91),wf(:,92))
  call prop_Q_A(wf(:,92),Q(:,11),MT,1_intkind1,wf(:,93))
  call vert_AQ_S(gX,wf(:,-3),wf(:,-1),wf(:,94))
  call vert_QS_A(gX,wf(:,0),wf(:,94),wf(:,95))
  call prop_Q_A(wf(:,95),Q(:,11),MT,1_intkind1,wf(:,96))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,97))
  call prop_Q_A(wf(:,97),Q(:,11),MT,1_intkind1,wf(:,98))
  call vert_ZQ_A(gZu,wf(:,11),wf(:,0),wf(:,99))
  call prop_Q_A(wf(:,99),Q(:,11),MT,1_intkind1,wf(:,100))
  call vert_SA_Q(gH,wf(:,91),wf(:,-2),wf(:,101))
  call vert_SA_Q(gX,wf(:,94),wf(:,-2),wf(:,102))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,103))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,11),wf(:,104))
  call counter_SG_G(wf(:,19),wf(:,2),wf(:,105))
  call counter_SG_G(wf(:,91),wf(:,1),wf(:,106))
  call counter_VG_G(wf(:,8),wf(:,2),Q(:,10),wf(:,107),Q(:,15))
  call counter_VG_G(wf(:,11),wf(:,1),Q(:,5),wf(:,108),Q(:,15))
  call counter_GG_V(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,109))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,110))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,111))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,11),wf(:,112))
  call counter_AV_Q_LR(EWctGdd,wf(:,-5),wf(:,2),wf(:,113))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,114))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,8),wf(:,115))
  call counter_AV_Q_LR(EWctGdd,wf(:,-5),wf(:,1),wf(:,116))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,117))
  call prop_A_Q(wf(:,14),Q(:,37),ZERO,0_intkind1,wf(:,118))
  call prop_A_Q(wf(:,16),Q(:,37),ZERO,0_intkind1,wf(:,119))
  call counter_ZQ_A(gZd,wf(:,11),wf(:,-4),wf(:,120))
  call counter_VQ_A_LR(EWctGdd,wf(:,2),wf(:,-4),wf(:,121))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,122))
  call prop_A_Q(wf(:,6),Q(:,42),ZERO,0_intkind1,wf(:,123))
  call counter_ZQ_A(gZd,wf(:,8),wf(:,-4),wf(:,124))
  call prop_A_Q(wf(:,12),Q(:,42),ZERO,0_intkind1,wf(:,125))
  call counter_VQ_A_LR(EWctGdd,wf(:,1),wf(:,-4),wf(:,126))
  call counter_QA_V(wf(:,-4),wf(:,-5),wf(:,127))
  call counter_QA_V_LR(EWctGdd,wf(:,-4),wf(:,-5),wf(:,128))
  call vert_AV_Q(wf(:,-3),wf(:,127),wf(:,129))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,-5),wf(:,130))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,130),wf(:,131))
  call vert_AV_Q(wf(:,-3),wf(:,128),wf(:,132))
  call vert_VQ_A(wf(:,127),wf(:,-1),wf(:,133))
  call prop_Q_A(wf(:,133),Q(:,50),MT,1_intkind1,wf(:,134))
  call vert_ZQ_A(gZu,wf(:,130),wf(:,-1),wf(:,135))
  call prop_Q_A(wf(:,135),Q(:,50),MT,1_intkind1,wf(:,136))
  call vert_VQ_A(wf(:,128),wf(:,-1),wf(:,137))
  call prop_Q_A(wf(:,137),Q(:,50),MT,1_intkind1,wf(:,138))
  call counter_AV_Q(wf(:,-3),wf(:,3),wf(:,139))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,30),wf(:,140))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,3),wf(:,141))
  call counter_SA_Q(gH,wf(:,19),wf(:,-3),wf(:,142))
  call counter_SA_Q(gX,wf(:,23),wf(:,-3),wf(:,143))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,144))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,8),wf(:,145))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,1),wf(:,146))
  call counter_SG_G(wf(:,75),wf(:,41),wf(:,147))
  call counter_SG_G(wf(:,57),wf(:,40),wf(:,148))
  call counter_VG_G(wf(:,46),wf(:,41),Q(:,6),wf(:,149),Q(:,15))
  call counter_VG_G(wf(:,49),wf(:,40),Q(:,9),wf(:,150),Q(:,15))
  call counter_GG_V(wf(:,41),Q(:,6),wf(:,40),Q(:,9),wf(:,151))
  call counter_UV_W(wf(:,41),Q(:,6),wf(:,40),Q(:,9),wf(:,152))
  call counter_AV_Q(wf(:,-5),wf(:,41),wf(:,153))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,49),wf(:,154))
  call counter_AV_Q_LR(EWctGdd,wf(:,-5),wf(:,41),wf(:,155))
  call counter_AV_Q(wf(:,-5),wf(:,40),wf(:,156))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,46),wf(:,157))
  call counter_AV_Q_LR(EWctGdd,wf(:,-5),wf(:,40),wf(:,158))
  call counter_VQ_A(wf(:,41),wf(:,-4),wf(:,159))
  call prop_A_Q(wf(:,52),Q(:,41),ZERO,0_intkind1,wf(:,160))
  call prop_A_Q(wf(:,54),Q(:,41),ZERO,0_intkind1,wf(:,161))
  call counter_ZQ_A(gZd,wf(:,49),wf(:,-4),wf(:,162))
  call counter_VQ_A_LR(EWctGdd,wf(:,41),wf(:,-4),wf(:,163))
  call counter_VQ_A(wf(:,40),wf(:,-4),wf(:,164))
  call prop_A_Q(wf(:,44),Q(:,38),ZERO,0_intkind1,wf(:,165))
  call counter_ZQ_A(gZd,wf(:,46),wf(:,-4),wf(:,166))
  call prop_A_Q(wf(:,50),Q(:,38),ZERO,0_intkind1,wf(:,167))
  call counter_VQ_A_LR(EWctGdd,wf(:,40),wf(:,-4),wf(:,168))
  call vert_VQ_A(wf(:,127),wf(:,0),wf(:,169))
  call prop_Q_A(wf(:,169),Q(:,49),MT,1_intkind1,wf(:,170))
  call vert_ZQ_A(gZu,wf(:,130),wf(:,0),wf(:,171))
  call prop_Q_A(wf(:,171),Q(:,49),MT,1_intkind1,wf(:,172))
  call vert_VQ_A(wf(:,128),wf(:,0),wf(:,173))
  call prop_Q_A(wf(:,173),Q(:,49),MT,1_intkind1,wf(:,174))
  call counter_SA_Q(gH,wf(:,57),wf(:,-3),wf(:,175))
  call counter_SA_Q(gX,wf(:,60),wf(:,-3),wf(:,176))
  call counter_AV_Q(wf(:,-3),wf(:,41),wf(:,177))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,49),wf(:,178))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,41),wf(:,179))
  call vert_AV_Q(wf(:,-2),wf(:,127),wf(:,180))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,130),wf(:,181))
  call vert_AV_Q(wf(:,-2),wf(:,128),wf(:,182))
  call counter_AV_Q(wf(:,-2),wf(:,3),wf(:,183))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,30),wf(:,184))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,3),wf(:,185))
  call counter_SA_Q(gH,wf(:,75),wf(:,-2),wf(:,186))
  call counter_SA_Q(gX,wf(:,79),wf(:,-2),wf(:,187))
  call counter_AV_Q(wf(:,-2),wf(:,40),wf(:,188))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,46),wf(:,189))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,40),wf(:,190))
  call counter_SA_Q(gH,wf(:,91),wf(:,-2),wf(:,191))
  call counter_SA_Q(gX,wf(:,94),wf(:,-2),wf(:,192))
  call counter_AV_Q(wf(:,-2),wf(:,2),wf(:,193))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,11),wf(:,194))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,2),wf(:,195))
  call counter_VQ_A(wf(:,3),wf(:,-1),wf(:,196))
  call prop_A_Q(wf(:,33),Q(:,13),MT,1_intkind1,wf(:,197))
  call prop_A_Q(wf(:,35),Q(:,13),MT,1_intkind1,wf(:,198))
  call prop_A_Q(wf(:,36),Q(:,13),MT,1_intkind1,wf(:,199))
  call prop_A_Q(wf(:,37),Q(:,13),MT,1_intkind1,wf(:,200))
  call counter_ZQ_A(gZu,wf(:,30),wf(:,-1),wf(:,201))
  call counter_VQ_A_LR(EWctGtt,wf(:,3),wf(:,-1),wf(:,202))
  call counter_QS_A(gH,wf(:,-1),wf(:,19),wf(:,203))
  call prop_A_Q(wf(:,21),Q(:,56),MT,1_intkind1,wf(:,204))
  call counter_QS_A(gX,wf(:,-1),wf(:,23),wf(:,205))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,206))
  call counter_ZQ_A(gZu,wf(:,8),wf(:,-1),wf(:,207))
  call prop_A_Q(wf(:,31),Q(:,56),MT,1_intkind1,wf(:,208))
  call counter_VQ_A_LR(EWctGtt,wf(:,1),wf(:,-1),wf(:,209))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,210))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,210),Q(:,10),wf(:,211))
  call counter_QA_V_LR(EWctGtt,wf(:,-1),wf(:,-3),wf(:,212))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,212),Q(:,10),wf(:,213))
  call vert_AV_Q(wf(:,-5),wf(:,210),wf(:,214))
  call counter_QA_Z(gZu,wf(:,-1),wf(:,-3),wf(:,215))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,215),wf(:,216))
  call vert_AV_Q(wf(:,-5),wf(:,212),wf(:,217))
  call vert_VQ_A(wf(:,210),wf(:,-4),wf(:,218))
  call prop_Q_A(wf(:,218),Q(:,26),ZERO,0_intkind1,wf(:,219))
  call vert_ZQ_A(gZd,wf(:,215),wf(:,-4),wf(:,220))
  call prop_Q_A(wf(:,220),Q(:,26),ZERO,0_intkind1,wf(:,221))
  call vert_VQ_A(wf(:,212),wf(:,-4),wf(:,222))
  call prop_Q_A(wf(:,222),Q(:,26),ZERO,0_intkind1,wf(:,223))
  call prop_A_Q(wf(:,87),Q(:,13),MT,1_intkind1,wf(:,224))
  call prop_A_Q(wf(:,88),Q(:,13),MT,1_intkind1,wf(:,225))
  call prop_A_Q(wf(:,89),Q(:,13),MT,1_intkind1,wf(:,226))
  call prop_A_Q(wf(:,90),Q(:,13),MT,1_intkind1,wf(:,227))
  call counter_QS_A(gH,wf(:,-1),wf(:,75),wf(:,228))
  call prop_A_Q(wf(:,77),Q(:,52),MT,1_intkind1,wf(:,229))
  call counter_QS_A(gX,wf(:,-1),wf(:,79),wf(:,230))
  call counter_VQ_A(wf(:,40),wf(:,-1),wf(:,231))
  call counter_ZQ_A(gZu,wf(:,46),wf(:,-1),wf(:,232))
  call prop_A_Q(wf(:,86),Q(:,52),MT,1_intkind1,wf(:,233))
  call counter_VQ_A_LR(EWctGtt,wf(:,40),wf(:,-1),wf(:,234))
  call counter_AQ_S(gH,wf(:,-3),wf(:,-1),wf(:,235))
  call vert_SA_Q(gH,wf(:,235),wf(:,-2),wf(:,236))
  call counter_AQ_S(gX,wf(:,-3),wf(:,-1),wf(:,237))
  call vert_SA_Q(gX,wf(:,237),wf(:,-2),wf(:,238))
  call vert_AV_Q(wf(:,-2),wf(:,210),wf(:,239))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,215),wf(:,240))
  call vert_AV_Q(wf(:,-2),wf(:,212),wf(:,241))
  call vert_QS_A(gH,wf(:,0),wf(:,235),wf(:,242))
  call prop_Q_A(wf(:,242),Q(:,11),MT,1_intkind1,wf(:,243))
  call vert_QS_A(gX,wf(:,0),wf(:,237),wf(:,244))
  call prop_Q_A(wf(:,244),Q(:,11),MT,1_intkind1,wf(:,245))
  call vert_VQ_A(wf(:,210),wf(:,0),wf(:,246))
  call prop_Q_A(wf(:,246),Q(:,11),MT,1_intkind1,wf(:,247))
  call vert_ZQ_A(gZu,wf(:,215),wf(:,0),wf(:,248))
  call prop_Q_A(wf(:,248),Q(:,11),MT,1_intkind1,wf(:,249))
  call vert_VQ_A(wf(:,212),wf(:,0),wf(:,250))
  call prop_Q_A(wf(:,250),Q(:,11),MT,1_intkind1,wf(:,251))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,252))
  call vert_UV_W(wf(:,252),Q(:,6),wf(:,40),Q(:,9),wf(:,253))
  call counter_QA_V_LR(EWctGtt,wf(:,-1),wf(:,-2),wf(:,254))
  call vert_UV_W(wf(:,254),Q(:,6),wf(:,40),Q(:,9),wf(:,255))
  call vert_AV_Q(wf(:,-5),wf(:,252),wf(:,256))
  call counter_QA_Z(gZu,wf(:,-1),wf(:,-2),wf(:,257))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,257),wf(:,258))
  call vert_AV_Q(wf(:,-5),wf(:,254),wf(:,259))
  call vert_VQ_A(wf(:,252),wf(:,-4),wf(:,260))
  call prop_Q_A(wf(:,260),Q(:,22),ZERO,0_intkind1,wf(:,261))
  call vert_ZQ_A(gZd,wf(:,257),wf(:,-4),wf(:,262))
  call prop_Q_A(wf(:,262),Q(:,22),ZERO,0_intkind1,wf(:,263))
  call vert_VQ_A(wf(:,254),wf(:,-4),wf(:,264))
  call prop_Q_A(wf(:,264),Q(:,22),ZERO,0_intkind1,wf(:,265))
  call counter_AQ_S(gH,wf(:,-2),wf(:,-1),wf(:,266))
  call vert_SA_Q(gH,wf(:,266),wf(:,-3),wf(:,267))
  call counter_AQ_S(gX,wf(:,-2),wf(:,-1),wf(:,268))
  call vert_SA_Q(gX,wf(:,268),wf(:,-3),wf(:,269))
  call vert_AV_Q(wf(:,-3),wf(:,252),wf(:,270))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,257),wf(:,271))
  call vert_AV_Q(wf(:,-3),wf(:,254),wf(:,272))
  call vert_QS_A(gH,wf(:,0),wf(:,266),wf(:,273))
  call prop_Q_A(wf(:,273),Q(:,7),MT,1_intkind1,wf(:,274))
  call vert_QS_A(gX,wf(:,0),wf(:,268),wf(:,275))
  call prop_Q_A(wf(:,275),Q(:,7),MT,1_intkind1,wf(:,276))
  call vert_VQ_A(wf(:,252),wf(:,0),wf(:,277))
  call prop_Q_A(wf(:,277),Q(:,7),MT,1_intkind1,wf(:,278))
  call vert_ZQ_A(gZu,wf(:,257),wf(:,0),wf(:,279))
  call prop_Q_A(wf(:,279),Q(:,7),MT,1_intkind1,wf(:,280))
  call vert_VQ_A(wf(:,254),wf(:,0),wf(:,281))
  call prop_Q_A(wf(:,281),Q(:,7),MT,1_intkind1,wf(:,282))
  call counter_QS_A(gH,wf(:,0),wf(:,57),wf(:,283))
  call counter_QS_A(gX,wf(:,0),wf(:,60),wf(:,284))
  call counter_VQ_A(wf(:,41),wf(:,0),wf(:,285))
  call counter_ZQ_A(gZu,wf(:,49),wf(:,0),wf(:,286))
  call counter_VQ_A_LR(EWctGtt,wf(:,41),wf(:,0),wf(:,287))
  call counter_VQ_A(wf(:,3),wf(:,0),wf(:,288))
  call prop_A_Q(wf(:,68),Q(:,14),MT,1_intkind1,wf(:,289))
  call prop_A_Q(wf(:,70),Q(:,14),MT,1_intkind1,wf(:,290))
  call prop_A_Q(wf(:,71),Q(:,14),MT,1_intkind1,wf(:,291))
  call counter_ZQ_A(gZu,wf(:,30),wf(:,0),wf(:,292))
  call prop_A_Q(wf(:,74),Q(:,14),MT,1_intkind1,wf(:,293))
  call counter_VQ_A_LR(EWctGtt,wf(:,3),wf(:,0),wf(:,294))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,295))
  call vert_UV_W(wf(:,41),Q(:,6),wf(:,295),Q(:,9),wf(:,296))
  call counter_QA_V_LR(EWctGtt,wf(:,0),wf(:,-3),wf(:,297))
  call vert_UV_W(wf(:,41),Q(:,6),wf(:,297),Q(:,9),wf(:,298))
  call vert_VQ_A(wf(:,295),wf(:,-4),wf(:,299))
  call prop_Q_A(wf(:,299),Q(:,25),ZERO,0_intkind1,wf(:,300))
  call counter_QA_Z(gZu,wf(:,0),wf(:,-3),wf(:,301))
  call vert_ZQ_A(gZd,wf(:,301),wf(:,-4),wf(:,302))
  call prop_Q_A(wf(:,302),Q(:,25),ZERO,0_intkind1,wf(:,303))
  call vert_VQ_A(wf(:,297),wf(:,-4),wf(:,304))
  call prop_Q_A(wf(:,304),Q(:,25),ZERO,0_intkind1,wf(:,305))
  call vert_AV_Q(wf(:,-5),wf(:,295),wf(:,306))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,301),wf(:,307))
  call vert_AV_Q(wf(:,-5),wf(:,297),wf(:,308))
  call counter_QS_A(gH,wf(:,0),wf(:,91),wf(:,309))
  call counter_QS_A(gX,wf(:,0),wf(:,94),wf(:,310))
  call counter_VQ_A(wf(:,2),wf(:,0),wf(:,311))
  call counter_ZQ_A(gZu,wf(:,11),wf(:,0),wf(:,312))
  call counter_VQ_A_LR(EWctGtt,wf(:,2),wf(:,0),wf(:,313))
  call prop_A_Q(wf(:,101),Q(:,14),MT,1_intkind1,wf(:,314))
  call prop_A_Q(wf(:,102),Q(:,14),MT,1_intkind1,wf(:,315))
  call prop_A_Q(wf(:,103),Q(:,14),MT,1_intkind1,wf(:,316))
  call prop_A_Q(wf(:,104),Q(:,14),MT,1_intkind1,wf(:,317))
  call counter_AQ_S(gH,wf(:,-3),wf(:,0),wf(:,318))
  call vert_QS_A(gH,wf(:,-1),wf(:,318),wf(:,319))
  call prop_Q_A(wf(:,319),Q(:,11),MT,1_intkind1,wf(:,320))
  call counter_AQ_S(gX,wf(:,-3),wf(:,0),wf(:,321))
  call vert_QS_A(gX,wf(:,-1),wf(:,321),wf(:,322))
  call prop_Q_A(wf(:,322),Q(:,11),MT,1_intkind1,wf(:,323))
  call vert_VQ_A(wf(:,295),wf(:,-1),wf(:,324))
  call prop_Q_A(wf(:,324),Q(:,11),MT,1_intkind1,wf(:,325))
  call vert_ZQ_A(gZu,wf(:,301),wf(:,-1),wf(:,326))
  call prop_Q_A(wf(:,326),Q(:,11),MT,1_intkind1,wf(:,327))
  call vert_VQ_A(wf(:,297),wf(:,-1),wf(:,328))
  call prop_Q_A(wf(:,328),Q(:,11),MT,1_intkind1,wf(:,329))
  call vert_SA_Q(gH,wf(:,318),wf(:,-2),wf(:,330))
  call vert_SA_Q(gX,wf(:,321),wf(:,-2),wf(:,331))
  call vert_AV_Q(wf(:,-2),wf(:,295),wf(:,332))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,301),wf(:,333))
  call vert_AV_Q(wf(:,-2),wf(:,297),wf(:,334))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,335))
  call vert_UV_W(wf(:,335),Q(:,5),wf(:,2),Q(:,10),wf(:,336))
  call counter_QA_V_LR(EWctGtt,wf(:,0),wf(:,-2),wf(:,337))
  call vert_UV_W(wf(:,337),Q(:,5),wf(:,2),Q(:,10),wf(:,338))
  call vert_VQ_A(wf(:,335),wf(:,-4),wf(:,339))
  call prop_Q_A(wf(:,339),Q(:,21),ZERO,0_intkind1,wf(:,340))
  call counter_QA_Z(gZu,wf(:,0),wf(:,-2),wf(:,341))
  call vert_ZQ_A(gZd,wf(:,341),wf(:,-4),wf(:,342))
  call prop_Q_A(wf(:,342),Q(:,21),ZERO,0_intkind1,wf(:,343))
  call vert_VQ_A(wf(:,337),wf(:,-4),wf(:,344))
  call prop_Q_A(wf(:,344),Q(:,21),ZERO,0_intkind1,wf(:,345))
  call vert_AV_Q(wf(:,-5),wf(:,335),wf(:,346))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,341),wf(:,347))
  call vert_AV_Q(wf(:,-5),wf(:,337),wf(:,348))
  call counter_AQ_S(gH,wf(:,-2),wf(:,0),wf(:,349))
  call vert_QS_A(gH,wf(:,-1),wf(:,349),wf(:,350))
  call prop_Q_A(wf(:,350),Q(:,7),MT,1_intkind1,wf(:,351))
  call counter_AQ_S(gX,wf(:,-2),wf(:,0),wf(:,352))
  call vert_QS_A(gX,wf(:,-1),wf(:,352),wf(:,353))
  call prop_Q_A(wf(:,353),Q(:,7),MT,1_intkind1,wf(:,354))
  call vert_VQ_A(wf(:,335),wf(:,-1),wf(:,355))
  call prop_Q_A(wf(:,355),Q(:,7),MT,1_intkind1,wf(:,356))
  call vert_ZQ_A(gZu,wf(:,341),wf(:,-1),wf(:,357))
  call prop_Q_A(wf(:,357),Q(:,7),MT,1_intkind1,wf(:,358))
  call vert_VQ_A(wf(:,337),wf(:,-1),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,7),MT,1_intkind1,wf(:,360))
  call vert_SA_Q(gH,wf(:,349),wf(:,-3),wf(:,361))
  call vert_SA_Q(gX,wf(:,352),wf(:,-3),wf(:,362))
  call vert_AV_Q(wf(:,-3),wf(:,335),wf(:,363))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,341),wf(:,364))
  call vert_AV_Q(wf(:,-3),wf(:,337),wf(:,365))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,3),Q(:,48),wf(:,366))
  call counter_V_V(ctGG,21,wf(:,1),Q(:,5),wf(:,367))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,3),Q(:,48),wf(:,368))
  call counter_V_V(ctGG,21,wf(:,2),Q(:,10),wf(:,369))
  call counter_V_V(ctGG,21,wf(:,3),Q(:,48),wf(:,370))
  call vert_VQ_A(wf(:,367),wf(:,-4),wf(:,371))
  call vert_AV_Q(wf(:,-5),wf(:,367),wf(:,372))
  call vert_VQ_A(wf(:,369),wf(:,-4),wf(:,373))
  call vert_AV_Q(wf(:,-5),wf(:,369),wf(:,374))
  call counter_Q_A(ctqq,1,wf(:,7),Q(:,21),wf(:,375))
  call counter_Q_A(ctqq,1,wf(:,10),Q(:,21),wf(:,376))
  call counter_Q_A_LR(EWctdd,wf(:,7),Q(:,21),wf(:,377))
  call counter_Q_A(ctqq,1,wf(:,15),Q(:,26),wf(:,378))
  call counter_Q_A(ctqq,1,wf(:,18),Q(:,26),wf(:,379))
  call counter_Q_A_LR(EWctdd,wf(:,15),Q(:,26),wf(:,380))
  call vert_VQ_A(wf(:,367),wf(:,-1),wf(:,381))
  call vert_AV_Q(wf(:,-3),wf(:,367),wf(:,382))
  call counter_Q_A(cttt,6,wf(:,22),Q(:,7),wf(:,383))
  call counter_Q_A(cttt,6,wf(:,25),Q(:,7),wf(:,384))
  call counter_Q_A(cttt,6,wf(:,27),Q(:,7),wf(:,385))
  call counter_Q_A(cttt,6,wf(:,29),Q(:,7),wf(:,386))
  call counter_Q_A_LR(EWcttt,wf(:,27),Q(:,7),wf(:,387))
  call counter_Q_A(cttt,6,wf(:,34),Q(:,50),wf(:,388))
  call counter_Q_A(cttt,6,wf(:,39),Q(:,50),wf(:,389))
  call counter_Q_A_LR(EWcttt,wf(:,34),Q(:,50),wf(:,390))
  call vert_VQ_A(wf(:,370),wf(:,-1),wf(:,391))
  call vert_AV_Q(wf(:,-3),wf(:,370),wf(:,392))
  call vert_UV_W(wf(:,41),Q(:,6),wf(:,3),Q(:,48),wf(:,393))
  call counter_V_V(ctGG,21,wf(:,40),Q(:,9),wf(:,394))
  call vert_UV_W(wf(:,40),Q(:,9),wf(:,3),Q(:,48),wf(:,395))
  call counter_V_V(ctGG,21,wf(:,41),Q(:,6),wf(:,396))
  call vert_VQ_A(wf(:,394),wf(:,-4),wf(:,397))
  call vert_AV_Q(wf(:,-5),wf(:,394),wf(:,398))
  call vert_VQ_A(wf(:,396),wf(:,-4),wf(:,399))
  call vert_AV_Q(wf(:,-5),wf(:,396),wf(:,400))
  call counter_Q_A(ctqq,1,wf(:,45),Q(:,25),wf(:,401))
  call counter_Q_A(ctqq,1,wf(:,48),Q(:,25),wf(:,402))
  call counter_Q_A_LR(EWctdd,wf(:,45),Q(:,25),wf(:,403))
  call counter_Q_A(ctqq,1,wf(:,53),Q(:,22),wf(:,404))
  call counter_Q_A(ctqq,1,wf(:,56),Q(:,22),wf(:,405))
  call counter_Q_A_LR(EWctdd,wf(:,53),Q(:,22),wf(:,406))
  call vert_VQ_A(wf(:,396),wf(:,0),wf(:,407))
  call counter_Q_A(cttt,6,wf(:,59),Q(:,7),wf(:,408))
  call counter_Q_A(cttt,6,wf(:,62),Q(:,7),wf(:,409))
  call counter_Q_A(cttt,6,wf(:,64),Q(:,7),wf(:,410))
  call counter_Q_A(cttt,6,wf(:,66),Q(:,7),wf(:,411))
  call counter_Q_A_LR(EWcttt,wf(:,64),Q(:,7),wf(:,412))
  call counter_Q_A(cttt,6,wf(:,69),Q(:,49),wf(:,413))
  call counter_Q_A(cttt,6,wf(:,73),Q(:,49),wf(:,414))
  call counter_Q_A_LR(EWcttt,wf(:,69),Q(:,49),wf(:,415))
  call vert_VQ_A(wf(:,370),wf(:,0),wf(:,416))
  call vert_AV_Q(wf(:,-3),wf(:,396),wf(:,417))
  call vert_VQ_A(wf(:,394),wf(:,-1),wf(:,418))
  call vert_AV_Q(wf(:,-2),wf(:,394),wf(:,419))
  call counter_Q_A(cttt,6,wf(:,78),Q(:,11),wf(:,420))
  call counter_Q_A(cttt,6,wf(:,81),Q(:,11),wf(:,421))
  call counter_Q_A(cttt,6,wf(:,83),Q(:,11),wf(:,422))
  call counter_Q_A(cttt,6,wf(:,85),Q(:,11),wf(:,423))
  call counter_Q_A_LR(EWcttt,wf(:,83),Q(:,11),wf(:,424))
  call vert_AV_Q(wf(:,-2),wf(:,370),wf(:,425))
  call vert_VQ_A(wf(:,369),wf(:,0),wf(:,426))
  call counter_Q_A(cttt,6,wf(:,93),Q(:,11),wf(:,427))
  call counter_Q_A(cttt,6,wf(:,96),Q(:,11),wf(:,428))
  call counter_Q_A(cttt,6,wf(:,98),Q(:,11),wf(:,429))
  call counter_Q_A(cttt,6,wf(:,100),Q(:,11),wf(:,430))
  call counter_Q_A_LR(EWcttt,wf(:,98),Q(:,11),wf(:,431))
  call vert_AV_Q(wf(:,-2),wf(:,369),wf(:,432))
  call vert_QA_V(wf(:,22),wf(:,-3),wf(:,433))
  call vert_QA_V(wf(:,25),wf(:,-3),wf(:,434))
  call vert_QA_V(wf(:,27),wf(:,-3),wf(:,435))
  call vert_QA_V(wf(:,29),wf(:,-3),wf(:,436))
  call vert_QA_Z(gZu,wf(:,27),wf(:,-3),wf(:,437))
  call vert_QA_V(wf(:,-1),wf(:,197),wf(:,438))
  call vert_QA_V(wf(:,-1),wf(:,198),wf(:,439))
  call vert_QA_V(wf(:,-1),wf(:,199),wf(:,440))
  call vert_QA_V(wf(:,-1),wf(:,200),wf(:,441))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,199),wf(:,442))
  call vert_QA_V(wf(:,7),wf(:,-5),wf(:,443))
  call vert_QA_V(wf(:,10),wf(:,-5),wf(:,444))
  call vert_QA_Z(gZd,wf(:,7),wf(:,-5),wf(:,445))
  call vert_QA_V(wf(:,-4),wf(:,118),wf(:,446))
  call vert_QA_V(wf(:,-4),wf(:,119),wf(:,447))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,118),wf(:,448))
  call vert_QA_V(wf(:,59),wf(:,-3),wf(:,449))
  call vert_QA_V(wf(:,62),wf(:,-3),wf(:,450))
  call vert_QA_V(wf(:,64),wf(:,-3),wf(:,451))
  call vert_QA_V(wf(:,66),wf(:,-3),wf(:,452))
  call vert_QA_Z(gZu,wf(:,64),wf(:,-3),wf(:,453))
  call vert_QA_V(wf(:,0),wf(:,289),wf(:,454))
  call vert_QA_V(wf(:,0),wf(:,290),wf(:,455))
  call vert_QA_V(wf(:,0),wf(:,291),wf(:,456))
  call vert_QA_Z(gZu,wf(:,0),wf(:,291),wf(:,457))
  call vert_QA_V(wf(:,0),wf(:,293),wf(:,458))
  call vert_QA_V(wf(:,53),wf(:,-5),wf(:,459))
  call vert_QA_V(wf(:,56),wf(:,-5),wf(:,460))
  call vert_QA_Z(gZd,wf(:,53),wf(:,-5),wf(:,461))
  call vert_QA_V(wf(:,-4),wf(:,165),wf(:,462))
  call vert_QA_V(wf(:,-4),wf(:,167),wf(:,463))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,165),wf(:,464))
  call vert_QA_V(wf(:,78),wf(:,-2),wf(:,465))
  call vert_QA_V(wf(:,81),wf(:,-2),wf(:,466))
  call vert_QA_V(wf(:,83),wf(:,-2),wf(:,467))
  call vert_QA_V(wf(:,85),wf(:,-2),wf(:,468))
  call vert_QA_Z(gZu,wf(:,83),wf(:,-2),wf(:,469))
  call vert_QA_V(wf(:,-1),wf(:,224),wf(:,470))
  call vert_QA_V(wf(:,-1),wf(:,225),wf(:,471))
  call vert_QA_V(wf(:,-1),wf(:,226),wf(:,472))
  call vert_QA_V(wf(:,-1),wf(:,227),wf(:,473))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,226),wf(:,474))
  call vert_QA_V(wf(:,45),wf(:,-5),wf(:,475))
  call vert_QA_V(wf(:,48),wf(:,-5),wf(:,476))
  call vert_QA_Z(gZd,wf(:,45),wf(:,-5),wf(:,477))
  call vert_QA_V(wf(:,-4),wf(:,160),wf(:,478))
  call vert_QA_V(wf(:,-4),wf(:,161),wf(:,479))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,160),wf(:,480))
  call vert_QA_V(wf(:,93),wf(:,-2),wf(:,481))
  call vert_QA_V(wf(:,96),wf(:,-2),wf(:,482))
  call vert_QA_V(wf(:,98),wf(:,-2),wf(:,483))
  call vert_QA_V(wf(:,100),wf(:,-2),wf(:,484))
  call vert_QA_Z(gZu,wf(:,98),wf(:,-2),wf(:,485))
  call vert_QA_V(wf(:,0),wf(:,314),wf(:,486))
  call vert_QA_V(wf(:,0),wf(:,315),wf(:,487))
  call vert_QA_V(wf(:,0),wf(:,316),wf(:,488))
  call vert_QA_Z(gZu,wf(:,0),wf(:,316),wf(:,489))
  call vert_QA_V(wf(:,0),wf(:,317),wf(:,490))
  call vert_QA_V(wf(:,15),wf(:,-5),wf(:,491))
  call vert_QA_V(wf(:,18),wf(:,-5),wf(:,492))
  call vert_QA_Z(gZd,wf(:,15),wf(:,-5),wf(:,493))
  call vert_QA_V(wf(:,-4),wf(:,123),wf(:,494))
  call vert_QA_V(wf(:,-4),wf(:,125),wf(:,495))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,123),wf(:,496))
  call vert_AQ_S(gH,wf(:,-2),wf(:,69),wf(:,497))
  call vert_AQ_S(gX,wf(:,-2),wf(:,69),wf(:,498))
  call vert_QA_V(wf(:,69),wf(:,-2),wf(:,499))
  call vert_QA_V(wf(:,73),wf(:,-2),wf(:,500))
  call vert_QA_Z(gZu,wf(:,69),wf(:,-2),wf(:,501))
  call vert_AQ_S(gH,wf(:,229),wf(:,0),wf(:,502))
  call vert_AQ_S(gX,wf(:,229),wf(:,0),wf(:,503))
  call vert_QA_V(wf(:,0),wf(:,229),wf(:,504))
  call vert_QA_Z(gZu,wf(:,0),wf(:,229),wf(:,505))
  call vert_QA_V(wf(:,0),wf(:,233),wf(:,506))
  call vert_AQ_S(gH,wf(:,-3),wf(:,69),wf(:,507))
  call vert_AQ_S(gX,wf(:,-3),wf(:,69),wf(:,508))
  call vert_QA_V(wf(:,69),wf(:,-3),wf(:,509))
  call vert_QA_V(wf(:,73),wf(:,-3),wf(:,510))
  call vert_QA_Z(gZu,wf(:,69),wf(:,-3),wf(:,511))
  call vert_AQ_S(gH,wf(:,204),wf(:,0),wf(:,512))
  call vert_AQ_S(gX,wf(:,204),wf(:,0),wf(:,513))
  call vert_QA_V(wf(:,0),wf(:,204),wf(:,514))
  call vert_QA_Z(gZu,wf(:,0),wf(:,204),wf(:,515))
  call vert_QA_V(wf(:,0),wf(:,208),wf(:,516))
  call vert_AQ_S(gH,wf(:,-2),wf(:,34),wf(:,517))
  call vert_AQ_S(gX,wf(:,-2),wf(:,34),wf(:,518))
  call vert_QA_V(wf(:,34),wf(:,-2),wf(:,519))
  call vert_QA_V(wf(:,39),wf(:,-2),wf(:,520))
  call vert_QA_Z(gZu,wf(:,34),wf(:,-2),wf(:,521))
  call vert_AQ_S(gH,wf(:,229),wf(:,-1),wf(:,522))
  call vert_AQ_S(gX,wf(:,229),wf(:,-1),wf(:,523))
  call vert_QA_V(wf(:,-1),wf(:,229),wf(:,524))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,229),wf(:,525))
  call vert_QA_V(wf(:,-1),wf(:,233),wf(:,526))
  call vert_AQ_S(gH,wf(:,-3),wf(:,34),wf(:,527))
  call vert_AQ_S(gX,wf(:,-3),wf(:,34),wf(:,528))
  call vert_QA_V(wf(:,34),wf(:,-3),wf(:,529))
  call vert_QA_V(wf(:,39),wf(:,-3),wf(:,530))
  call vert_QA_Z(gZu,wf(:,34),wf(:,-3),wf(:,531))
  call vert_AQ_S(gH,wf(:,204),wf(:,-1),wf(:,532))
  call vert_AQ_S(gX,wf(:,204),wf(:,-1),wf(:,533))
  call vert_QA_V(wf(:,-1),wf(:,204),wf(:,534))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,204),wf(:,535))
  call vert_QA_V(wf(:,-1),wf(:,208),wf(:,536))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,10))
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,21))
  den(9) = 1 / (Q(5,5) - MZ2)
  den(12) = 1 / (Q(5,10) - MZ2)
  den(14) = 1 / (Q(5,26))
  den(20) = 1 / (Q(5,5) - MH2)
  den(21) = 1 / (Q(5,7) - MT2)
  den(28) = 1 / (Q(5,48) - MZ2)
  den(30) = 1 / (Q(5,50) - MT2)
  den(37) = 1 / (Q(5,9))
  den(38) = 1 / (Q(5,6))
  den(41) = 1 / (Q(5,25))
  den(44) = 1 / (Q(5,9) - MZ2)
  den(47) = 1 / (Q(5,6) - MZ2)
  den(49) = 1 / (Q(5,22))
  den(55) = 1 / (Q(5,6) - MH2)
  den(63) = 1 / (Q(5,49) - MT2)
  den(70) = 1 / (Q(5,9) - MH2)
  den(71) = 1 / (Q(5,11) - MT2)
  den(83) = 1 / (Q(5,10) - MH2)
  den(104) = 1 / (Q(5,37))
  den(110) = 1 / (Q(5,42))
  den(125) = 1 / (Q(5,41))
  den(131) = 1 / (Q(5,38))
  den(137) = 1 / (Q(5,13) - MT2)
  den(145) = 1 / (Q(5,56) - MT2)
  den(159) = 1 / (Q(5,52) - MT2)
  den(170) = 1 / (Q(5,14) - MT2)
  den(190) = 1 / (Q(5,58))
  den(194) = 1 / (Q(5,53))
  den(197) = 1 / (Q(5,15))
  den(236) = 1 / (Q(5,54))
  den(240) = 1 / (Q(5,57))
  den(318) = 1 / (Q(5,15) - MZ2)
  den(326) = 1 / (Q(5,53) - MZ2)
  den(341) = 1 / (Q(5,54) - MZ2)
  den(356) = 1 / (Q(5,57) - MZ2)
  den(371) = 1 / (Q(5,58) - MZ2)
  den(376) = 1 / (Q(5,53) - MH2)
  den(385) = 1 / (Q(5,57) - MH2)
  den(394) = 1 / (Q(5,54) - MH2)
  den(403) = 1 / (Q(5,58) - MH2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(6)*den(9)
  den(11) = den(2)*den(10)
  den(13) = den(7)*den(12)
  den(15) = den(2)*den(14)
  den(16) = den(1)*den(15)
  den(17) = den(9)*den(15)
  den(18) = den(12)*den(14)
  den(19) = den(1)*den(18)
  den(22) = den(20)*den(21)
  den(23) = den(3)*den(22)
  den(24) = den(9)*den(21)
  den(25) = den(3)*den(24)
  den(26) = den(1)*den(21)
  den(27) = den(3)*den(26)
  den(29) = den(26)*den(28)
  den(31) = den(3)*den(30)
  den(32) = den(20)*den(31)
  den(33) = den(9)*den(31)
  den(34) = den(1)*den(31)
  den(35) = den(28)*den(30)
  den(36) = den(1)*den(35)
  den(39) = den(37)*den(38)
  den(40) = den(3)*den(39)
  den(42) = den(37)*den(41)
  den(43) = den(38)*den(42)
  den(45) = den(41)*den(44)
  den(46) = den(38)*den(45)
  den(48) = den(42)*den(47)
  den(50) = den(38)*den(49)
  den(51) = den(37)*den(50)
  den(52) = den(44)*den(50)
  den(53) = den(47)*den(49)
  den(54) = den(37)*den(53)
  den(56) = den(21)*den(55)
  den(57) = den(3)*den(56)
  den(58) = den(21)*den(47)
  den(59) = den(3)*den(58)
  den(60) = den(21)*den(38)
  den(61) = den(3)*den(60)
  den(62) = den(28)*den(60)
  den(64) = den(3)*den(63)
  den(65) = den(55)*den(64)
  den(66) = den(47)*den(64)
  den(67) = den(38)*den(64)
  den(68) = den(28)*den(63)
  den(69) = den(38)*den(68)
  den(72) = den(70)*den(71)
  den(73) = den(3)*den(72)
  den(74) = den(44)*den(71)
  den(75) = den(3)*den(74)
  den(76) = den(37)*den(71)
  den(77) = den(3)*den(76)
  den(78) = den(28)*den(76)
  den(79) = den(31)*den(70)
  den(80) = den(31)*den(44)
  den(81) = den(31)*den(37)
  den(82) = den(35)*den(37)
  den(84) = den(71)*den(83)
  den(85) = den(3)*den(84)
  den(86) = den(12)*den(71)
  den(87) = den(3)*den(86)
  den(88) = den(2)*den(71)
  den(89) = den(3)*den(88)
  den(90) = den(28)*den(88)
  den(91) = den(64)*den(83)
  den(92) = den(12)*den(64)
  den(93) = den(2)*den(64)
  den(94) = den(2)*den(68)
  den(95) = den(2)*den(20)
  den(96) = den(3)*den(95)
  den(97) = den(1)*den(83)
  den(98) = den(3)*den(97)
  den(99) = den(2)*den(9)
  den(100) = den(3)*den(99)
  den(101) = den(1)*den(12)
  den(102) = den(3)*den(101)
  den(103) = den(4)*den(28)
  den(105) = den(1)*den(104)
  den(106) = den(2)*den(105)
  den(107) = den(9)*den(104)
  den(108) = den(2)*den(107)
  den(109) = den(12)*den(105)
  den(111) = den(2)*den(110)
  den(112) = den(1)*den(111)
  den(113) = den(9)*den(111)
  den(114) = den(12)*den(110)
  den(115) = den(1)*den(114)
  den(116) = den(38)*den(70)
  den(117) = den(3)*den(116)
  den(118) = den(37)*den(55)
  den(119) = den(3)*den(118)
  den(120) = den(38)*den(44)
  den(121) = den(3)*den(120)
  den(122) = den(37)*den(47)
  den(123) = den(3)*den(122)
  den(124) = den(28)*den(39)
  den(126) = den(37)*den(125)
  den(127) = den(38)*den(126)
  den(128) = den(44)*den(125)
  den(129) = den(38)*den(128)
  den(130) = den(47)*den(126)
  den(132) = den(38)*den(131)
  den(133) = den(37)*den(132)
  den(134) = den(44)*den(132)
  den(135) = den(47)*den(131)
  den(136) = den(37)*den(135)
  den(138) = den(20)*den(137)
  den(139) = den(3)*den(138)
  den(140) = den(9)*den(137)
  den(141) = den(3)*den(140)
  den(142) = den(1)*den(137)
  den(143) = den(3)*den(142)
  den(144) = den(28)*den(142)
  den(146) = den(3)*den(145)
  den(147) = den(20)*den(146)
  den(148) = den(9)*den(146)
  den(149) = den(1)*den(146)
  den(150) = den(28)*den(145)
  den(151) = den(1)*den(150)
  den(152) = den(70)*den(137)
  den(153) = den(3)*den(152)
  den(154) = den(44)*den(137)
  den(155) = den(3)*den(154)
  den(156) = den(37)*den(137)
  den(157) = den(3)*den(156)
  den(158) = den(28)*den(156)
  den(160) = den(3)*den(159)
  den(161) = den(70)*den(160)
  den(162) = den(44)*den(160)
  den(163) = den(37)*den(160)
  den(164) = den(28)*den(159)
  den(165) = den(37)*den(164)
  den(166) = den(55)*den(146)
  den(167) = den(47)*den(146)
  den(168) = den(38)*den(146)
  den(169) = den(38)*den(150)
  den(171) = den(55)*den(170)
  den(172) = den(3)*den(171)
  den(173) = den(47)*den(170)
  den(174) = den(3)*den(173)
  den(175) = den(38)*den(170)
  den(176) = den(3)*den(175)
  den(177) = den(28)*den(175)
  den(178) = den(83)*den(160)
  den(179) = den(12)*den(160)
  den(180) = den(2)*den(160)
  den(181) = den(2)*den(164)
  den(182) = den(83)*den(170)
  den(183) = den(3)*den(182)
  den(184) = den(12)*den(170)
  den(185) = den(3)*den(184)
  den(186) = den(2)*den(170)
  den(187) = den(3)*den(186)
  den(188) = den(28)*den(186)
  den(189) = den(2)*den(3)
  den(191) = den(189)*den(190)
  den(192) = den(1)*den(191)
  den(193) = den(1)*den(3)
  den(195) = den(193)*den(194)
  den(196) = den(2)*den(195)
  den(198) = den(4)*den(197)
  den(199) = den(3)*den(198)
  den(200) = den(1)**2
  den(201) = den(111)*den(200)
  den(202) = den(114)*den(200)
  den(203) = den(15)*den(200)
  den(204) = den(18)*den(200)
  den(205) = den(2)**2
  den(206) = den(105)*den(205)
  den(207) = den(107)*den(205)
  den(208) = den(7)*den(205)
  den(209) = den(10)*den(205)
  den(210) = den(7)*den(111)
  den(211) = den(10)*den(111)
  den(212) = den(7)*den(114)
  den(213) = den(15)*den(105)
  den(214) = den(15)*den(107)
  den(215) = den(18)*den(105)
  den(216) = den(146)*den(200)
  den(217) = den(150)*den(200)
  den(218) = den(31)*den(200)
  den(219) = den(35)*den(200)
  den(220) = den(22)*den(146)
  den(221) = den(24)*den(146)
  den(222) = den(26)*den(146)
  den(223) = den(26)*den(150)
  den(224) = den(31)*den(138)
  den(225) = den(31)*den(140)
  den(226) = den(31)*den(142)
  den(227) = den(35)*den(142)
  den(228) = den(3)**2
  den(229) = den(138)*den(228)
  den(230) = den(140)*den(228)
  den(231) = den(142)*den(228)
  den(232) = den(22)*den(228)
  den(233) = den(24)*den(228)
  den(234) = den(26)*den(228)
  den(235) = den(3)*den(38)
  den(237) = den(235)*den(236)
  den(238) = den(37)*den(237)
  den(239) = den(3)*den(37)
  den(241) = den(239)*den(240)
  den(242) = den(38)*den(241)
  den(243) = den(39)*den(197)
  den(244) = den(3)*den(243)
  den(245) = den(37)**2
  den(246) = den(132)*den(245)
  den(247) = den(135)*den(245)
  den(248) = den(50)*den(245)
  den(249) = den(53)*den(245)
  den(250) = den(38)**2
  den(251) = den(126)*den(250)
  den(252) = den(128)*den(250)
  den(253) = den(42)*den(250)
  den(254) = den(45)*den(250)
  den(255) = den(42)*den(132)
  den(256) = den(45)*den(132)
  den(257) = den(42)*den(135)
  den(258) = den(50)*den(126)
  den(259) = den(50)*den(128)
  den(260) = den(53)*den(126)
  den(261) = den(146)*den(250)
  den(262) = den(150)*den(250)
  den(263) = den(56)*den(146)
  den(264) = den(58)*den(146)
  den(265) = den(60)*den(146)
  den(266) = den(60)*den(150)
  den(267) = den(64)*den(171)
  den(268) = den(64)*den(173)
  den(269) = den(64)*den(175)
  den(270) = den(68)*den(175)
  den(271) = den(171)*den(228)
  den(272) = den(173)*den(228)
  den(273) = den(175)*den(228)
  den(274) = den(64)*den(250)
  den(275) = den(68)*den(250)
  den(276) = den(56)*den(228)
  den(277) = den(58)*den(228)
  den(278) = den(60)*den(228)
  den(279) = den(160)*den(245)
  den(280) = den(164)*den(245)
  den(281) = den(31)*den(245)
  den(282) = den(35)*den(245)
  den(283) = den(72)*den(160)
  den(284) = den(74)*den(160)
  den(285) = den(76)*den(160)
  den(286) = den(76)*den(164)
  den(287) = den(31)*den(152)
  den(288) = den(31)*den(154)
  den(289) = den(31)*den(156)
  den(290) = den(35)*den(156)
  den(291) = den(152)*den(228)
  den(292) = den(154)*den(228)
  den(293) = den(156)*den(228)
  den(294) = den(72)*den(228)
  den(295) = den(74)*den(228)
  den(296) = den(76)*den(228)
  den(297) = den(160)*den(205)
  den(298) = den(164)*den(205)
  den(299) = den(84)*den(160)
  den(300) = den(86)*den(160)
  den(301) = den(88)*den(160)
  den(302) = den(88)*den(164)
  den(303) = den(64)*den(182)
  den(304) = den(64)*den(184)
  den(305) = den(64)*den(186)
  den(306) = den(68)*den(186)
  den(307) = den(182)*den(228)
  den(308) = den(184)*den(228)
  den(309) = den(186)*den(228)
  den(310) = den(64)*den(205)
  den(311) = den(68)*den(205)
  den(312) = den(84)*den(228)
  den(313) = den(86)*den(228)
  den(314) = den(88)*den(228)
  den(315) = den(22)*den(197)
  den(316) = den(24)*den(197)
  den(317) = den(26)*den(197)
  den(319) = den(26)*den(318)
  den(320) = den(138)*den(197)
  den(321) = den(140)*den(197)
  den(322) = den(142)*den(197)
  den(323) = den(142)*den(318)
  den(324) = den(7)*den(194)
  den(325) = den(10)*den(194)
  den(327) = den(7)*den(326)
  den(328) = den(105)*den(194)
  den(329) = den(107)*den(194)
  den(330) = den(105)*den(326)
  den(331) = den(56)*den(197)
  den(332) = den(58)*den(197)
  den(333) = den(60)*den(197)
  den(334) = den(60)*den(318)
  den(335) = den(171)*den(197)
  den(336) = den(173)*den(197)
  den(337) = den(175)*den(197)
  den(338) = den(175)*den(318)
  den(339) = den(50)*den(236)
  den(340) = den(53)*den(236)
  den(342) = den(50)*den(341)
  den(343) = den(132)*den(236)
  den(344) = den(135)*den(236)
  den(345) = den(132)*den(341)
  den(346) = den(72)*den(197)
  den(347) = den(74)*den(197)
  den(348) = den(76)*den(197)
  den(349) = den(76)*den(318)
  den(350) = den(152)*den(197)
  den(351) = den(154)*den(197)
  den(352) = den(156)*den(197)
  den(353) = den(156)*den(318)
  den(354) = den(42)*den(240)
  den(355) = den(45)*den(240)
  den(357) = den(42)*den(356)
  den(358) = den(126)*den(240)
  den(359) = den(128)*den(240)
  den(360) = den(126)*den(356)
  den(361) = den(84)*den(197)
  den(362) = den(86)*den(197)
  den(363) = den(88)*den(197)
  den(364) = den(88)*den(318)
  den(365) = den(182)*den(197)
  den(366) = den(184)*den(197)
  den(367) = den(186)*den(197)
  den(368) = den(186)*den(318)
  den(369) = den(15)*den(190)
  den(370) = den(18)*den(190)
  den(372) = den(15)*den(371)
  den(373) = den(111)*den(190)
  den(374) = den(114)*den(190)
  den(375) = den(111)*den(371)
  den(377) = den(64)*den(376)
  den(378) = den(64)*den(326)
  den(379) = den(64)*den(194)
  den(380) = den(68)*den(194)
  den(381) = den(160)*den(376)
  den(382) = den(160)*den(326)
  den(383) = den(160)*den(194)
  den(384) = den(164)*den(194)
  den(386) = den(64)*den(385)
  den(387) = den(64)*den(356)
  den(388) = den(64)*den(240)
  den(389) = den(68)*den(240)
  den(390) = den(146)*den(385)
  den(391) = den(146)*den(356)
  den(392) = den(146)*den(240)
  den(393) = den(150)*den(240)
  den(395) = den(31)*den(394)
  den(396) = den(31)*den(341)
  den(397) = den(31)*den(236)
  den(398) = den(35)*den(236)
  den(399) = den(160)*den(394)
  den(400) = den(160)*den(341)
  den(401) = den(160)*den(236)
  den(402) = den(164)*den(236)
  den(404) = den(31)*den(403)
  den(405) = den(31)*den(371)
  den(406) = den(31)*den(190)
  den(407) = den(35)*den(190)
  den(408) = den(146)*den(403)
  den(409) = den(146)*den(371)
  den(410) = den(146)*den(190)
  den(411) = den(150)*den(190)
  den(412) = den(2)*den(3)*den(20)
  den(413) = den(2)*den(3)*den(9)
  den(414) = den(1)*den(3)*den(83)
  den(415) = den(1)*den(3)*den(12)
  den(416) = den(1)*den(2)*den(3)
  den(417) = den(1)*den(2)*den(28)
  den(418) = den(3)*den(20)
  den(419) = den(3)*den(9)
  den(420) = den(1)*den(28)
  den(421) = den(3)*den(38)*den(70)
  den(422) = den(3)*den(38)*den(44)
  den(423) = den(3)*den(37)*den(55)
  den(424) = den(3)*den(37)*den(47)
  den(425) = den(3)*den(37)*den(38)
  den(426) = den(28)*den(37)*den(38)
  den(427) = den(3)*den(55)
  den(428) = den(3)*den(47)
  den(429) = den(28)*den(38)
  den(430) = den(3)*den(70)
  den(431) = den(3)*den(44)
  den(432) = den(28)*den(37)
  den(433) = den(3)*den(83)
  den(434) = den(3)*den(12)
  den(435) = den(2)*den(28)
  den(436) = den(1)*den(189)
  den(437) = den(2)*den(193)
  den(438) = den(37)*den(235)
  den(439) = den(38)*den(239)
  den(440) = den(2)*den(324)
  den(441) = den(2)*den(325)
  den(442) = den(2)*den(328)
  den(443) = den(2)*den(329)
  den(444) = den(1)*den(369)
  den(445) = den(1)*den(370)
  den(446) = den(1)*den(373)
  den(447) = den(1)*den(374)
  den(448) = den(3)*den(315)
  den(449) = den(3)*den(316)
  den(450) = den(3)*den(317)
  den(451) = den(3)*den(320)
  den(452) = den(3)*den(321)
  den(453) = den(3)*den(322)
  den(454) = den(1)*den(406)
  den(455) = den(1)*den(407)
  den(456) = den(1)*den(410)
  den(457) = den(1)*den(411)
  den(458) = den(38)*den(354)
  den(459) = den(38)*den(355)
  den(460) = den(38)*den(358)
  den(461) = den(38)*den(359)
  den(462) = den(37)*den(339)
  den(463) = den(37)*den(340)
  den(464) = den(37)*den(343)
  den(465) = den(37)*den(344)
  den(466) = den(3)*den(331)
  den(467) = den(3)*den(332)
  den(468) = den(3)*den(333)
  den(469) = den(38)*den(388)
  den(470) = den(38)*den(389)
  den(471) = den(3)*den(335)
  den(472) = den(3)*den(336)
  den(473) = den(3)*den(337)
  den(474) = den(38)*den(392)
  den(475) = den(38)*den(393)
  den(476) = den(3)*den(346)
  den(477) = den(3)*den(347)
  den(478) = den(3)*den(348)
  den(479) = den(3)*den(350)
  den(480) = den(3)*den(351)
  den(481) = den(3)*den(352)
  den(482) = den(37)*den(397)
  den(483) = den(37)*den(398)
  den(484) = den(37)*den(401)
  den(485) = den(37)*den(402)
  den(486) = den(3)*den(361)
  den(487) = den(3)*den(362)
  den(488) = den(3)*den(363)
  den(489) = den(2)*den(379)
  den(490) = den(2)*den(380)
  den(491) = den(3)*den(365)
  den(492) = den(3)*den(366)
  den(493) = den(3)*den(367)
  den(494) = den(2)*den(383)
  den(495) = den(2)*den(384)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(636)

  A(1) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_QA(wf(:,6),wf(:,7)) * den(8)
  A(3) = cont_QA(wf(:,6),wf(:,10)) * den(11)
  A(4) = cont_QA(wf(:,6),wf(:,7)) * den(8)
  A(5) = cont_QA(wf(:,7),wf(:,12)) * den(13)
  A(6) = cont_QA(wf(:,6),wf(:,7)) * den(8)
  A(7) = cont_QA(wf(:,14),wf(:,15)) * den(16)
  A(8) = cont_QA(wf(:,15),wf(:,16)) * den(17)
  A(9) = cont_QA(wf(:,14),wf(:,15)) * den(16)
  A(10) = cont_QA(wf(:,14),wf(:,18)) * den(19)
  A(11) = cont_QA(wf(:,14),wf(:,15)) * den(16)
  A(12) = cont_QA(wf(:,21),wf(:,22)) * den(23)
  A(13) = cont_QA(wf(:,21),wf(:,25)) * den(25)
  A(14) = cont_QA(wf(:,21),wf(:,27)) * den(27)
  A(15) = cont_QA(wf(:,21),wf(:,29)) * den(25)
  A(16) = cont_QA(wf(:,21),wf(:,27)) * den(27)
  A(17) = cont_QA(wf(:,27),wf(:,31)) * den(29)
  A(18) = cont_QA(wf(:,21),wf(:,27)) * den(27)
  A(19) = cont_QA(wf(:,33),wf(:,34)) * den(32)
  A(20) = cont_QA(wf(:,34),wf(:,35)) * den(33)
  A(21) = cont_QA(wf(:,34),wf(:,36)) * den(34)
  A(22) = cont_QA(wf(:,34),wf(:,37)) * den(33)
  A(23) = cont_QA(wf(:,34),wf(:,36)) * den(34)
  A(24) = cont_QA(wf(:,36),wf(:,39)) * den(36)
  A(25) = cont_QA(wf(:,34),wf(:,36)) * den(34)
  A(26) = cont_VV(wf(:,3),wf(:,42)) * den(40)
  A(27) = cont_QA(wf(:,44),wf(:,45)) * den(43)
  A(28) = cont_QA(wf(:,44),wf(:,48)) * den(46)
  A(29) = cont_QA(wf(:,44),wf(:,45)) * den(43)
  A(30) = cont_QA(wf(:,45),wf(:,50)) * den(48)
  A(31) = cont_QA(wf(:,44),wf(:,45)) * den(43)
  A(32) = cont_QA(wf(:,52),wf(:,53)) * den(51)
  A(33) = cont_QA(wf(:,53),wf(:,54)) * den(52)
  A(34) = cont_QA(wf(:,52),wf(:,53)) * den(51)
  A(35) = cont_QA(wf(:,52),wf(:,56)) * den(54)
  A(36) = cont_QA(wf(:,52),wf(:,53)) * den(51)
  A(37) = cont_QA(wf(:,21),wf(:,59)) * den(57)
  A(38) = cont_QA(wf(:,21),wf(:,62)) * den(59)
  A(39) = cont_QA(wf(:,21),wf(:,64)) * den(61)
  A(40) = cont_QA(wf(:,21),wf(:,66)) * den(59)
  A(41) = cont_QA(wf(:,21),wf(:,64)) * den(61)
  A(42) = cont_QA(wf(:,31),wf(:,64)) * den(62)
  A(43) = cont_QA(wf(:,21),wf(:,64)) * den(61)
  A(44) = cont_QA(wf(:,68),wf(:,69)) * den(65)
  A(45) = cont_QA(wf(:,69),wf(:,70)) * den(66)
  A(46) = cont_QA(wf(:,69),wf(:,71)) * den(67)
  A(47) = cont_QA(wf(:,71),wf(:,73)) * den(69)
  A(48) = cont_QA(wf(:,69),wf(:,71)) * den(67)
  A(49) = cont_QA(wf(:,69),wf(:,74)) * den(66)
  A(50) = cont_QA(wf(:,69),wf(:,71)) * den(67)
  A(51) = cont_QA(wf(:,77),wf(:,78)) * den(73)
  A(52) = cont_QA(wf(:,77),wf(:,81)) * den(75)
  A(53) = cont_QA(wf(:,77),wf(:,83)) * den(77)
  A(54) = cont_QA(wf(:,77),wf(:,85)) * den(75)
  A(55) = cont_QA(wf(:,77),wf(:,83)) * den(77)
  A(56) = cont_QA(wf(:,83),wf(:,86)) * den(78)
  A(57) = cont_QA(wf(:,77),wf(:,83)) * den(77)
  A(58) = cont_QA(wf(:,34),wf(:,87)) * den(79)
  A(59) = cont_QA(wf(:,34),wf(:,88)) * den(80)
  A(60) = cont_QA(wf(:,34),wf(:,89)) * den(81)
  A(61) = cont_QA(wf(:,34),wf(:,90)) * den(80)
  A(62) = cont_QA(wf(:,34),wf(:,89)) * den(81)
  A(63) = cont_QA(wf(:,39),wf(:,89)) * den(82)
  A(64) = cont_QA(wf(:,34),wf(:,89)) * den(81)
  A(65) = cont_QA(wf(:,77),wf(:,93)) * den(85)
  A(66) = cont_QA(wf(:,77),wf(:,96)) * den(87)
  A(67) = cont_QA(wf(:,77),wf(:,98)) * den(89)
  A(68) = cont_QA(wf(:,77),wf(:,100)) * den(87)
  A(69) = cont_QA(wf(:,77),wf(:,98)) * den(89)
  A(70) = cont_QA(wf(:,86),wf(:,98)) * den(90)
  A(71) = cont_QA(wf(:,77),wf(:,98)) * den(89)
  A(72) = cont_QA(wf(:,69),wf(:,101)) * den(91)
  A(73) = cont_QA(wf(:,69),wf(:,102)) * den(92)
  A(74) = cont_QA(wf(:,69),wf(:,103)) * den(93)
  A(75) = cont_QA(wf(:,73),wf(:,103)) * den(94)
  A(76) = cont_QA(wf(:,69),wf(:,103)) * den(93)
  A(77) = cont_QA(wf(:,69),wf(:,104)) * den(92)
  A(78) = cont_QA(wf(:,69),wf(:,103)) * den(93)

  A(79) = cont_VV(wf(:,3),wf(:,105)) * den(96)
  A(80) = cont_VV(wf(:,3),wf(:,106)) * den(98)
  A(81) = cont_VV(wf(:,3),wf(:,107)) * den(100)
  A(82) = cont_VV(wf(:,3),wf(:,108)) * den(102)
  A(83) = cont_VV(wf(:,30),wf(:,109)) * den(103)
  A(84) = cont_VV(wf(:,3),wf(:,110)) * den(5)
  A(85) = cont_QA(wf(:,7),wf(:,111)) * den(8)
  A(86) = cont_QA(wf(:,10),wf(:,111)) * den(11)
  A(87) = cont_QA(wf(:,7),wf(:,111)) * den(8)
  A(88) = cont_QA(wf(:,7),wf(:,112)) * den(13)
  A(89) = cont_QA(wf(:,7),wf(:,111)) * den(8)
  A(90) = cont_QA(wf(:,7),wf(:,113)) * den(8)
  A(91) = cont_QA(wf(:,15),wf(:,114)) * den(16)
  A(92) = cont_QA(wf(:,15),wf(:,115)) * den(17)
  A(93) = cont_QA(wf(:,15),wf(:,114)) * den(16)
  A(94) = cont_QA(wf(:,18),wf(:,114)) * den(19)
  A(95) = cont_QA(wf(:,15),wf(:,114)) * den(16)
  A(96) = cont_QA(wf(:,15),wf(:,116)) * den(16)
  A(97) = cont_QA(wf(:,117),wf(:,118)) * den(106)
  A(98) = cont_QA(wf(:,117),wf(:,119)) * den(108)
  A(99) = cont_QA(wf(:,117),wf(:,118)) * den(106)
  A(100) = cont_QA(wf(:,118),wf(:,120)) * den(109)
  A(101) = cont_QA(wf(:,117),wf(:,118)) * den(106)
  A(102) = cont_QA(wf(:,118),wf(:,121)) * den(106)
  A(103) = cont_QA(wf(:,122),wf(:,123)) * den(112)
  A(104) = cont_QA(wf(:,123),wf(:,124)) * den(113)
  A(105) = cont_QA(wf(:,122),wf(:,123)) * den(112)
  A(106) = cont_QA(wf(:,122),wf(:,125)) * den(115)
  A(107) = cont_QA(wf(:,122),wf(:,123)) * den(112)
  A(108) = cont_QA(wf(:,123),wf(:,126)) * den(112)
  A(109) = cont_VV(wf(:,4),wf(:,127)) * den(5)
  A(110) = cont_VV(wf(:,4),wf(:,128)) * den(5)
  A(111) = cont_QA(wf(:,22),wf(:,129)) * den(23)
  A(112) = cont_QA(wf(:,25),wf(:,129)) * den(25)
  A(113) = cont_QA(wf(:,27),wf(:,129)) * den(27)
  A(114) = cont_QA(wf(:,29),wf(:,129)) * den(25)
  A(115) = cont_QA(wf(:,27),wf(:,129)) * den(27)
  A(116) = cont_QA(wf(:,27),wf(:,131)) * den(29)
  A(117) = cont_QA(wf(:,27),wf(:,129)) * den(27)
  A(118) = cont_QA(wf(:,27),wf(:,132)) * den(27)
  A(119) = cont_QA(wf(:,33),wf(:,134)) * den(32)
  A(120) = cont_QA(wf(:,35),wf(:,134)) * den(33)
  A(121) = cont_QA(wf(:,36),wf(:,134)) * den(34)
  A(122) = cont_QA(wf(:,37),wf(:,134)) * den(33)
  A(123) = cont_QA(wf(:,36),wf(:,134)) * den(34)
  A(124) = cont_QA(wf(:,36),wf(:,136)) * den(36)
  A(125) = cont_QA(wf(:,36),wf(:,134)) * den(34)
  A(126) = cont_QA(wf(:,36),wf(:,138)) * den(34)
  A(127) = cont_QA(wf(:,22),wf(:,139)) * den(23)
  A(128) = cont_QA(wf(:,25),wf(:,139)) * den(25)
  A(129) = cont_QA(wf(:,27),wf(:,139)) * den(27)
  A(130) = cont_QA(wf(:,29),wf(:,139)) * den(25)
  A(131) = cont_QA(wf(:,27),wf(:,139)) * den(27)
  A(132) = cont_QA(wf(:,27),wf(:,140)) * den(29)
  A(133) = cont_QA(wf(:,27),wf(:,139)) * den(27)
  A(134) = cont_QA(wf(:,27),wf(:,141)) * den(27)
  A(135) = cont_QA(wf(:,34),wf(:,142)) * den(32)
  A(136) = cont_QA(wf(:,34),wf(:,143)) * den(33)
  A(137) = cont_QA(wf(:,34),wf(:,144)) * den(34)
  A(138) = cont_QA(wf(:,34),wf(:,145)) * den(33)
  A(139) = cont_QA(wf(:,34),wf(:,144)) * den(34)
  A(140) = cont_QA(wf(:,39),wf(:,144)) * den(36)
  A(141) = cont_QA(wf(:,34),wf(:,144)) * den(34)
  A(142) = cont_QA(wf(:,34),wf(:,146)) * den(34)
  A(143) = cont_VV(wf(:,3),wf(:,147)) * den(117)
  A(144) = cont_VV(wf(:,3),wf(:,148)) * den(119)
  A(145) = cont_VV(wf(:,3),wf(:,149)) * den(121)
  A(146) = cont_VV(wf(:,3),wf(:,150)) * den(123)
  A(147) = cont_VV(wf(:,30),wf(:,151)) * den(124)
  A(148) = cont_VV(wf(:,3),wf(:,152)) * den(40)
  A(149) = cont_QA(wf(:,45),wf(:,153)) * den(43)
  A(150) = cont_QA(wf(:,48),wf(:,153)) * den(46)
  A(151) = cont_QA(wf(:,45),wf(:,153)) * den(43)
  A(152) = cont_QA(wf(:,45),wf(:,154)) * den(48)
  A(153) = cont_QA(wf(:,45),wf(:,153)) * den(43)
  A(154) = cont_QA(wf(:,45),wf(:,155)) * den(43)
  A(155) = cont_QA(wf(:,53),wf(:,156)) * den(51)
  A(156) = cont_QA(wf(:,53),wf(:,157)) * den(52)
  A(157) = cont_QA(wf(:,53),wf(:,156)) * den(51)
  A(158) = cont_QA(wf(:,56),wf(:,156)) * den(54)
  A(159) = cont_QA(wf(:,53),wf(:,156)) * den(51)
  A(160) = cont_QA(wf(:,53),wf(:,158)) * den(51)
  A(161) = cont_QA(wf(:,159),wf(:,160)) * den(127)
  A(162) = cont_QA(wf(:,159),wf(:,161)) * den(129)
  A(163) = cont_QA(wf(:,159),wf(:,160)) * den(127)
  A(164) = cont_QA(wf(:,160),wf(:,162)) * den(130)
  A(165) = cont_QA(wf(:,159),wf(:,160)) * den(127)
  A(166) = cont_QA(wf(:,160),wf(:,163)) * den(127)
  A(167) = cont_QA(wf(:,164),wf(:,165)) * den(133)
  A(168) = cont_QA(wf(:,165),wf(:,166)) * den(134)
  A(169) = cont_QA(wf(:,164),wf(:,165)) * den(133)
  A(170) = cont_QA(wf(:,164),wf(:,167)) * den(136)
  A(171) = cont_QA(wf(:,164),wf(:,165)) * den(133)
  A(172) = cont_QA(wf(:,165),wf(:,168)) * den(133)
  A(173) = cont_VV(wf(:,42),wf(:,127)) * den(40)
  A(174) = cont_VV(wf(:,42),wf(:,128)) * den(40)
  A(175) = cont_QA(wf(:,59),wf(:,129)) * den(57)
  A(176) = cont_QA(wf(:,62),wf(:,129)) * den(59)
  A(177) = cont_QA(wf(:,64),wf(:,129)) * den(61)
  A(178) = cont_QA(wf(:,66),wf(:,129)) * den(59)
  A(179) = cont_QA(wf(:,64),wf(:,129)) * den(61)
  A(180) = cont_QA(wf(:,64),wf(:,131)) * den(62)
  A(181) = cont_QA(wf(:,64),wf(:,129)) * den(61)
  A(182) = cont_QA(wf(:,64),wf(:,132)) * den(61)
  A(183) = cont_QA(wf(:,68),wf(:,170)) * den(65)
  A(184) = cont_QA(wf(:,70),wf(:,170)) * den(66)
  A(185) = cont_QA(wf(:,71),wf(:,170)) * den(67)
  A(186) = cont_QA(wf(:,71),wf(:,172)) * den(69)
  A(187) = cont_QA(wf(:,71),wf(:,170)) * den(67)
  A(188) = cont_QA(wf(:,74),wf(:,170)) * den(66)
  A(189) = cont_QA(wf(:,71),wf(:,170)) * den(67)
  A(190) = cont_QA(wf(:,71),wf(:,174)) * den(67)
  A(191) = cont_QA(wf(:,59),wf(:,139)) * den(57)
  A(192) = cont_QA(wf(:,62),wf(:,139)) * den(59)
  A(193) = cont_QA(wf(:,64),wf(:,139)) * den(61)
  A(194) = cont_QA(wf(:,66),wf(:,139)) * den(59)
  A(195) = cont_QA(wf(:,64),wf(:,139)) * den(61)
  A(196) = cont_QA(wf(:,64),wf(:,140)) * den(62)
  A(197) = cont_QA(wf(:,64),wf(:,139)) * den(61)
  A(198) = cont_QA(wf(:,64),wf(:,141)) * den(61)
  A(199) = cont_QA(wf(:,69),wf(:,175)) * den(65)
  A(200) = cont_QA(wf(:,69),wf(:,176)) * den(66)
  A(201) = cont_QA(wf(:,69),wf(:,177)) * den(67)
  A(202) = cont_QA(wf(:,73),wf(:,177)) * den(69)
  A(203) = cont_QA(wf(:,69),wf(:,177)) * den(67)
  A(204) = cont_QA(wf(:,69),wf(:,178)) * den(66)
  A(205) = cont_QA(wf(:,69),wf(:,177)) * den(67)
  A(206) = cont_QA(wf(:,69),wf(:,179)) * den(67)
  A(207) = cont_QA(wf(:,78),wf(:,180)) * den(73)
  A(208) = cont_QA(wf(:,81),wf(:,180)) * den(75)
  A(209) = cont_QA(wf(:,83),wf(:,180)) * den(77)
  A(210) = cont_QA(wf(:,85),wf(:,180)) * den(75)
  A(211) = cont_QA(wf(:,83),wf(:,180)) * den(77)
  A(212) = cont_QA(wf(:,83),wf(:,181)) * den(78)
  A(213) = cont_QA(wf(:,83),wf(:,180)) * den(77)
  A(214) = cont_QA(wf(:,83),wf(:,182)) * den(77)
  A(215) = cont_QA(wf(:,87),wf(:,134)) * den(79)
  A(216) = cont_QA(wf(:,88),wf(:,134)) * den(80)
  A(217) = cont_QA(wf(:,89),wf(:,134)) * den(81)
  A(218) = cont_QA(wf(:,90),wf(:,134)) * den(80)
  A(219) = cont_QA(wf(:,89),wf(:,134)) * den(81)
  A(220) = cont_QA(wf(:,89),wf(:,136)) * den(82)
  A(221) = cont_QA(wf(:,89),wf(:,134)) * den(81)
  A(222) = cont_QA(wf(:,89),wf(:,138)) * den(81)
  A(223) = cont_QA(wf(:,93),wf(:,180)) * den(85)
  A(224) = cont_QA(wf(:,96),wf(:,180)) * den(87)
  A(225) = cont_QA(wf(:,98),wf(:,180)) * den(89)
  A(226) = cont_QA(wf(:,100),wf(:,180)) * den(87)
  A(227) = cont_QA(wf(:,98),wf(:,180)) * den(89)
  A(228) = cont_QA(wf(:,98),wf(:,181)) * den(90)
  A(229) = cont_QA(wf(:,98),wf(:,180)) * den(89)
  A(230) = cont_QA(wf(:,98),wf(:,182)) * den(89)
  A(231) = cont_QA(wf(:,101),wf(:,170)) * den(91)
  A(232) = cont_QA(wf(:,102),wf(:,170)) * den(92)
  A(233) = cont_QA(wf(:,103),wf(:,170)) * den(93)
  A(234) = cont_QA(wf(:,103),wf(:,172)) * den(94)
  A(235) = cont_QA(wf(:,103),wf(:,170)) * den(93)
  A(236) = cont_QA(wf(:,104),wf(:,170)) * den(92)
  A(237) = cont_QA(wf(:,103),wf(:,170)) * den(93)
  A(238) = cont_QA(wf(:,103),wf(:,174)) * den(93)
  A(239) = cont_QA(wf(:,78),wf(:,183)) * den(73)
  A(240) = cont_QA(wf(:,81),wf(:,183)) * den(75)
  A(241) = cont_QA(wf(:,83),wf(:,183)) * den(77)
  A(242) = cont_QA(wf(:,85),wf(:,183)) * den(75)
  A(243) = cont_QA(wf(:,83),wf(:,183)) * den(77)
  A(244) = cont_QA(wf(:,83),wf(:,184)) * den(78)
  A(245) = cont_QA(wf(:,83),wf(:,183)) * den(77)
  A(246) = cont_QA(wf(:,83),wf(:,185)) * den(77)
  A(247) = cont_QA(wf(:,34),wf(:,186)) * den(79)
  A(248) = cont_QA(wf(:,34),wf(:,187)) * den(80)
  A(249) = cont_QA(wf(:,34),wf(:,188)) * den(81)
  A(250) = cont_QA(wf(:,34),wf(:,189)) * den(80)
  A(251) = cont_QA(wf(:,34),wf(:,188)) * den(81)
  A(252) = cont_QA(wf(:,39),wf(:,188)) * den(82)
  A(253) = cont_QA(wf(:,34),wf(:,188)) * den(81)
  A(254) = cont_QA(wf(:,34),wf(:,190)) * den(81)
  A(255) = cont_QA(wf(:,93),wf(:,183)) * den(85)
  A(256) = cont_QA(wf(:,96),wf(:,183)) * den(87)
  A(257) = cont_QA(wf(:,98),wf(:,183)) * den(89)
  A(258) = cont_QA(wf(:,100),wf(:,183)) * den(87)
  A(259) = cont_QA(wf(:,98),wf(:,183)) * den(89)
  A(260) = cont_QA(wf(:,98),wf(:,184)) * den(90)
  A(261) = cont_QA(wf(:,98),wf(:,183)) * den(89)
  A(262) = cont_QA(wf(:,98),wf(:,185)) * den(89)
  A(263) = cont_QA(wf(:,69),wf(:,191)) * den(91)
  A(264) = cont_QA(wf(:,69),wf(:,192)) * den(92)
  A(265) = cont_QA(wf(:,69),wf(:,193)) * den(93)
  A(266) = cont_QA(wf(:,73),wf(:,193)) * den(94)
  A(267) = cont_QA(wf(:,69),wf(:,193)) * den(93)
  A(268) = cont_QA(wf(:,69),wf(:,194)) * den(92)
  A(269) = cont_QA(wf(:,69),wf(:,193)) * den(93)
  A(270) = cont_QA(wf(:,69),wf(:,195)) * den(93)
  A(271) = cont_QA(wf(:,196),wf(:,197)) * den(139)
  A(272) = cont_QA(wf(:,196),wf(:,198)) * den(141)
  A(273) = cont_QA(wf(:,196),wf(:,199)) * den(143)
  A(274) = cont_QA(wf(:,196),wf(:,200)) * den(141)
  A(275) = cont_QA(wf(:,196),wf(:,199)) * den(143)
  A(276) = cont_QA(wf(:,199),wf(:,201)) * den(144)
  A(277) = cont_QA(wf(:,196),wf(:,199)) * den(143)
  A(278) = cont_QA(wf(:,199),wf(:,202)) * den(143)
  A(279) = cont_QA(wf(:,203),wf(:,204)) * den(147)
  A(280) = cont_QA(wf(:,204),wf(:,205)) * den(148)
  A(281) = cont_QA(wf(:,204),wf(:,206)) * den(149)
  A(282) = cont_QA(wf(:,204),wf(:,207)) * den(148)
  A(283) = cont_QA(wf(:,204),wf(:,206)) * den(149)
  A(284) = cont_QA(wf(:,206),wf(:,208)) * den(151)
  A(285) = cont_QA(wf(:,204),wf(:,206)) * den(149)
  A(286) = cont_QA(wf(:,204),wf(:,209)) * den(149)
  A(287) = cont_VV(wf(:,3),wf(:,211)) * den(5)
  A(288) = cont_VV(wf(:,3),wf(:,213)) * den(5)
  A(289) = cont_QA(wf(:,7),wf(:,214)) * den(8)
  A(290) = cont_QA(wf(:,10),wf(:,214)) * den(11)
  A(291) = cont_QA(wf(:,7),wf(:,214)) * den(8)
  A(292) = cont_QA(wf(:,7),wf(:,216)) * den(13)
  A(293) = cont_QA(wf(:,7),wf(:,214)) * den(8)
  A(294) = cont_QA(wf(:,7),wf(:,217)) * den(8)
  A(295) = cont_QA(wf(:,14),wf(:,219)) * den(16)
  A(296) = cont_QA(wf(:,16),wf(:,219)) * den(17)
  A(297) = cont_QA(wf(:,14),wf(:,219)) * den(16)
  A(298) = cont_QA(wf(:,14),wf(:,221)) * den(19)
  A(299) = cont_QA(wf(:,14),wf(:,219)) * den(16)
  A(300) = cont_QA(wf(:,14),wf(:,223)) * den(16)
  A(301) = cont_QA(wf(:,196),wf(:,224)) * den(153)
  A(302) = cont_QA(wf(:,196),wf(:,225)) * den(155)
  A(303) = cont_QA(wf(:,196),wf(:,226)) * den(157)
  A(304) = cont_QA(wf(:,196),wf(:,227)) * den(155)
  A(305) = cont_QA(wf(:,196),wf(:,226)) * den(157)
  A(306) = cont_QA(wf(:,201),wf(:,226)) * den(158)
  A(307) = cont_QA(wf(:,196),wf(:,226)) * den(157)
  A(308) = cont_QA(wf(:,202),wf(:,226)) * den(157)
  A(309) = cont_QA(wf(:,228),wf(:,229)) * den(161)
  A(310) = cont_QA(wf(:,229),wf(:,230)) * den(162)
  A(311) = cont_QA(wf(:,229),wf(:,231)) * den(163)
  A(312) = cont_QA(wf(:,229),wf(:,232)) * den(162)
  A(313) = cont_QA(wf(:,229),wf(:,231)) * den(163)
  A(314) = cont_QA(wf(:,231),wf(:,233)) * den(165)
  A(315) = cont_QA(wf(:,229),wf(:,231)) * den(163)
  A(316) = cont_QA(wf(:,229),wf(:,234)) * den(163)
  A(317) = cont_QA(wf(:,69),wf(:,236)) * den(91)
  A(318) = cont_QA(wf(:,69),wf(:,238)) * den(92)
  A(319) = cont_QA(wf(:,69),wf(:,239)) * den(93)
  A(320) = cont_QA(wf(:,73),wf(:,239)) * den(94)
  A(321) = cont_QA(wf(:,69),wf(:,239)) * den(93)
  A(322) = cont_QA(wf(:,69),wf(:,240)) * den(92)
  A(323) = cont_QA(wf(:,69),wf(:,239)) * den(93)
  A(324) = cont_QA(wf(:,69),wf(:,241)) * den(93)
  A(325) = cont_QA(wf(:,77),wf(:,243)) * den(85)
  A(326) = cont_QA(wf(:,77),wf(:,245)) * den(87)
  A(327) = cont_QA(wf(:,77),wf(:,247)) * den(89)
  A(328) = cont_QA(wf(:,77),wf(:,249)) * den(87)
  A(329) = cont_QA(wf(:,77),wf(:,247)) * den(89)
  A(330) = cont_QA(wf(:,86),wf(:,247)) * den(90)
  A(331) = cont_QA(wf(:,77),wf(:,247)) * den(89)
  A(332) = cont_QA(wf(:,77),wf(:,251)) * den(89)
  A(333) = cont_VV(wf(:,3),wf(:,253)) * den(40)
  A(334) = cont_VV(wf(:,3),wf(:,255)) * den(40)
  A(335) = cont_QA(wf(:,45),wf(:,256)) * den(43)
  A(336) = cont_QA(wf(:,48),wf(:,256)) * den(46)
  A(337) = cont_QA(wf(:,45),wf(:,256)) * den(43)
  A(338) = cont_QA(wf(:,45),wf(:,258)) * den(48)
  A(339) = cont_QA(wf(:,45),wf(:,256)) * den(43)
  A(340) = cont_QA(wf(:,45),wf(:,259)) * den(43)
  A(341) = cont_QA(wf(:,52),wf(:,261)) * den(51)
  A(342) = cont_QA(wf(:,54),wf(:,261)) * den(52)
  A(343) = cont_QA(wf(:,52),wf(:,261)) * den(51)
  A(344) = cont_QA(wf(:,52),wf(:,263)) * den(54)
  A(345) = cont_QA(wf(:,52),wf(:,261)) * den(51)
  A(346) = cont_QA(wf(:,52),wf(:,265)) * den(51)
  A(347) = cont_QA(wf(:,69),wf(:,267)) * den(65)
  A(348) = cont_QA(wf(:,69),wf(:,269)) * den(66)
  A(349) = cont_QA(wf(:,69),wf(:,270)) * den(67)
  A(350) = cont_QA(wf(:,73),wf(:,270)) * den(69)
  A(351) = cont_QA(wf(:,69),wf(:,270)) * den(67)
  A(352) = cont_QA(wf(:,69),wf(:,271)) * den(66)
  A(353) = cont_QA(wf(:,69),wf(:,270)) * den(67)
  A(354) = cont_QA(wf(:,69),wf(:,272)) * den(67)
  A(355) = cont_QA(wf(:,21),wf(:,274)) * den(57)
  A(356) = cont_QA(wf(:,21),wf(:,276)) * den(59)
  A(357) = cont_QA(wf(:,21),wf(:,278)) * den(61)
  A(358) = cont_QA(wf(:,21),wf(:,280)) * den(59)
  A(359) = cont_QA(wf(:,21),wf(:,278)) * den(61)
  A(360) = cont_QA(wf(:,31),wf(:,278)) * den(62)
  A(361) = cont_QA(wf(:,21),wf(:,278)) * den(61)
  A(362) = cont_QA(wf(:,21),wf(:,282)) * den(61)
  A(363) = cont_QA(wf(:,204),wf(:,283)) * den(166)
  A(364) = cont_QA(wf(:,204),wf(:,284)) * den(167)
  A(365) = cont_QA(wf(:,204),wf(:,285)) * den(168)
  A(366) = cont_QA(wf(:,204),wf(:,286)) * den(167)
  A(367) = cont_QA(wf(:,204),wf(:,285)) * den(168)
  A(368) = cont_QA(wf(:,208),wf(:,285)) * den(169)
  A(369) = cont_QA(wf(:,204),wf(:,285)) * den(168)
  A(370) = cont_QA(wf(:,204),wf(:,287)) * den(168)
  A(371) = cont_QA(wf(:,288),wf(:,289)) * den(172)
  A(372) = cont_QA(wf(:,288),wf(:,290)) * den(174)
  A(373) = cont_QA(wf(:,288),wf(:,291)) * den(176)
  A(374) = cont_QA(wf(:,291),wf(:,292)) * den(177)
  A(375) = cont_QA(wf(:,288),wf(:,291)) * den(176)
  A(376) = cont_QA(wf(:,288),wf(:,293)) * den(174)
  A(377) = cont_QA(wf(:,288),wf(:,291)) * den(176)
  A(378) = cont_QA(wf(:,291),wf(:,294)) * den(176)
  A(379) = cont_VV(wf(:,3),wf(:,296)) * den(40)
  A(380) = cont_VV(wf(:,3),wf(:,298)) * den(40)
  A(381) = cont_QA(wf(:,44),wf(:,300)) * den(43)
  A(382) = cont_QA(wf(:,44),wf(:,303)) * den(46)
  A(383) = cont_QA(wf(:,44),wf(:,300)) * den(43)
  A(384) = cont_QA(wf(:,50),wf(:,300)) * den(48)
  A(385) = cont_QA(wf(:,44),wf(:,300)) * den(43)
  A(386) = cont_QA(wf(:,44),wf(:,305)) * den(43)
  A(387) = cont_QA(wf(:,53),wf(:,306)) * den(51)
  A(388) = cont_QA(wf(:,53),wf(:,307)) * den(52)
  A(389) = cont_QA(wf(:,53),wf(:,306)) * den(51)
  A(390) = cont_QA(wf(:,56),wf(:,306)) * den(54)
  A(391) = cont_QA(wf(:,53),wf(:,306)) * den(51)
  A(392) = cont_QA(wf(:,53),wf(:,308)) * den(51)
  A(393) = cont_QA(wf(:,229),wf(:,309)) * den(178)
  A(394) = cont_QA(wf(:,229),wf(:,310)) * den(179)
  A(395) = cont_QA(wf(:,229),wf(:,311)) * den(180)
  A(396) = cont_QA(wf(:,229),wf(:,312)) * den(179)
  A(397) = cont_QA(wf(:,229),wf(:,311)) * den(180)
  A(398) = cont_QA(wf(:,233),wf(:,311)) * den(181)
  A(399) = cont_QA(wf(:,229),wf(:,311)) * den(180)
  A(400) = cont_QA(wf(:,229),wf(:,313)) * den(180)
  A(401) = cont_QA(wf(:,288),wf(:,314)) * den(183)
  A(402) = cont_QA(wf(:,288),wf(:,315)) * den(185)
  A(403) = cont_QA(wf(:,288),wf(:,316)) * den(187)
  A(404) = cont_QA(wf(:,292),wf(:,316)) * den(188)
  A(405) = cont_QA(wf(:,288),wf(:,316)) * den(187)
  A(406) = cont_QA(wf(:,288),wf(:,317)) * den(185)
  A(407) = cont_QA(wf(:,288),wf(:,316)) * den(187)
  A(408) = cont_QA(wf(:,294),wf(:,316)) * den(187)
  A(409) = cont_QA(wf(:,77),wf(:,320)) * den(73)
  A(410) = cont_QA(wf(:,77),wf(:,323)) * den(75)
  A(411) = cont_QA(wf(:,77),wf(:,325)) * den(77)
  A(412) = cont_QA(wf(:,77),wf(:,327)) * den(75)
  A(413) = cont_QA(wf(:,77),wf(:,325)) * den(77)
  A(414) = cont_QA(wf(:,86),wf(:,325)) * den(78)
  A(415) = cont_QA(wf(:,77),wf(:,325)) * den(77)
  A(416) = cont_QA(wf(:,77),wf(:,329)) * den(77)
  A(417) = cont_QA(wf(:,34),wf(:,330)) * den(79)
  A(418) = cont_QA(wf(:,34),wf(:,331)) * den(80)
  A(419) = cont_QA(wf(:,34),wf(:,332)) * den(81)
  A(420) = cont_QA(wf(:,34),wf(:,333)) * den(80)
  A(421) = cont_QA(wf(:,34),wf(:,332)) * den(81)
  A(422) = cont_QA(wf(:,39),wf(:,332)) * den(82)
  A(423) = cont_QA(wf(:,34),wf(:,332)) * den(81)
  A(424) = cont_QA(wf(:,34),wf(:,334)) * den(81)
  A(425) = cont_VV(wf(:,3),wf(:,336)) * den(5)
  A(426) = cont_VV(wf(:,3),wf(:,338)) * den(5)
  A(427) = cont_QA(wf(:,6),wf(:,340)) * den(8)
  A(428) = cont_QA(wf(:,6),wf(:,343)) * den(11)
  A(429) = cont_QA(wf(:,6),wf(:,340)) * den(8)
  A(430) = cont_QA(wf(:,12),wf(:,340)) * den(13)
  A(431) = cont_QA(wf(:,6),wf(:,340)) * den(8)
  A(432) = cont_QA(wf(:,6),wf(:,345)) * den(8)
  A(433) = cont_QA(wf(:,15),wf(:,346)) * den(16)
  A(434) = cont_QA(wf(:,15),wf(:,347)) * den(17)
  A(435) = cont_QA(wf(:,15),wf(:,346)) * den(16)
  A(436) = cont_QA(wf(:,18),wf(:,346)) * den(19)
  A(437) = cont_QA(wf(:,15),wf(:,346)) * den(16)
  A(438) = cont_QA(wf(:,15),wf(:,348)) * den(16)
  A(439) = cont_QA(wf(:,21),wf(:,351)) * den(23)
  A(440) = cont_QA(wf(:,21),wf(:,354)) * den(25)
  A(441) = cont_QA(wf(:,21),wf(:,356)) * den(27)
  A(442) = cont_QA(wf(:,21),wf(:,358)) * den(25)
  A(443) = cont_QA(wf(:,21),wf(:,356)) * den(27)
  A(444) = cont_QA(wf(:,31),wf(:,356)) * den(29)
  A(445) = cont_QA(wf(:,21),wf(:,356)) * den(27)
  A(446) = cont_QA(wf(:,21),wf(:,360)) * den(27)
  A(447) = cont_QA(wf(:,34),wf(:,361)) * den(32)
  A(448) = cont_QA(wf(:,34),wf(:,362)) * den(33)
  A(449) = cont_QA(wf(:,34),wf(:,363)) * den(34)
  A(450) = cont_QA(wf(:,34),wf(:,364)) * den(33)
  A(451) = cont_QA(wf(:,34),wf(:,363)) * den(34)
  A(452) = cont_QA(wf(:,39),wf(:,363)) * den(36)
  A(453) = cont_QA(wf(:,34),wf(:,363)) * den(34)
  A(454) = cont_QA(wf(:,34),wf(:,365)) * den(34)
  A(455) = cont_VV(wf(:,366),wf(:,367)) * den(192)
  A(456) = cont_VV(wf(:,368),wf(:,369)) * den(196)
  A(457) = cont_VV(wf(:,4),wf(:,370)) * den(199)
  A(458) = cont_QA(wf(:,123),wf(:,371)) * den(201)
  A(459) = cont_QA(wf(:,125),wf(:,371)) * den(202)
  A(460) = cont_QA(wf(:,123),wf(:,371)) * den(201)
  A(461) = cont_QA(wf(:,15),wf(:,372)) * den(203)
  A(462) = cont_QA(wf(:,18),wf(:,372)) * den(204)
  A(463) = cont_QA(wf(:,15),wf(:,372)) * den(203)
  A(464) = cont_QA(wf(:,118),wf(:,373)) * den(206)
  A(465) = cont_QA(wf(:,119),wf(:,373)) * den(207)
  A(466) = cont_QA(wf(:,118),wf(:,373)) * den(206)
  A(467) = cont_QA(wf(:,7),wf(:,374)) * den(208)
  A(468) = cont_QA(wf(:,10),wf(:,374)) * den(209)
  A(469) = cont_QA(wf(:,7),wf(:,374)) * den(208)
  A(470) = cont_QA(wf(:,123),wf(:,375)) * den(210)
  A(471) = cont_QA(wf(:,123),wf(:,376)) * den(211)
  A(472) = cont_QA(wf(:,123),wf(:,375)) * den(210)
  A(473) = cont_QA(wf(:,125),wf(:,375)) * den(212)
  A(474) = cont_QA(wf(:,123),wf(:,375)) * den(210)
  A(475) = cont_QA(wf(:,123),wf(:,377)) * den(210)
  A(476) = cont_QA(wf(:,118),wf(:,378)) * den(213)
  A(477) = cont_QA(wf(:,119),wf(:,378)) * den(214)
  A(478) = cont_QA(wf(:,118),wf(:,378)) * den(213)
  A(479) = cont_QA(wf(:,118),wf(:,379)) * den(215)
  A(480) = cont_QA(wf(:,118),wf(:,378)) * den(213)
  A(481) = cont_QA(wf(:,118),wf(:,380)) * den(213)
  A(482) = cont_QA(wf(:,204),wf(:,381)) * den(216)
  A(483) = cont_QA(wf(:,208),wf(:,381)) * den(217)
  A(484) = cont_QA(wf(:,204),wf(:,381)) * den(216)
  A(485) = cont_QA(wf(:,34),wf(:,382)) * den(218)
  A(486) = cont_QA(wf(:,39),wf(:,382)) * den(219)
  A(487) = cont_QA(wf(:,34),wf(:,382)) * den(218)
  A(488) = cont_QA(wf(:,204),wf(:,383)) * den(220)
  A(489) = cont_QA(wf(:,204),wf(:,384)) * den(221)
  A(490) = cont_QA(wf(:,204),wf(:,385)) * den(222)
  A(491) = cont_QA(wf(:,204),wf(:,386)) * den(221)
  A(492) = cont_QA(wf(:,204),wf(:,385)) * den(222)
  A(493) = cont_QA(wf(:,208),wf(:,385)) * den(223)
  A(494) = cont_QA(wf(:,204),wf(:,385)) * den(222)
  A(495) = cont_QA(wf(:,204),wf(:,387)) * den(222)
  A(496) = cont_QA(wf(:,197),wf(:,388)) * den(224)
  A(497) = cont_QA(wf(:,198),wf(:,388)) * den(225)
  A(498) = cont_QA(wf(:,199),wf(:,388)) * den(226)
  A(499) = cont_QA(wf(:,200),wf(:,388)) * den(225)
  A(500) = cont_QA(wf(:,199),wf(:,388)) * den(226)
  A(501) = cont_QA(wf(:,199),wf(:,389)) * den(227)
  A(502) = cont_QA(wf(:,199),wf(:,388)) * den(226)
  A(503) = cont_QA(wf(:,199),wf(:,390)) * den(226)
  A(504) = cont_QA(wf(:,197),wf(:,391)) * den(229)
  A(505) = cont_QA(wf(:,198),wf(:,391)) * den(230)
  A(506) = cont_QA(wf(:,199),wf(:,391)) * den(231)
  A(507) = cont_QA(wf(:,200),wf(:,391)) * den(230)
  A(508) = cont_QA(wf(:,199),wf(:,391)) * den(231)
  A(509) = cont_QA(wf(:,22),wf(:,392)) * den(232)
  A(510) = cont_QA(wf(:,25),wf(:,392)) * den(233)
  A(511) = cont_QA(wf(:,27),wf(:,392)) * den(234)
  A(512) = cont_QA(wf(:,29),wf(:,392)) * den(233)
  A(513) = cont_QA(wf(:,27),wf(:,392)) * den(234)
  A(514) = cont_VV(wf(:,393),wf(:,394)) * den(238)
  A(515) = cont_VV(wf(:,395),wf(:,396)) * den(242)
  A(516) = cont_VV(wf(:,42),wf(:,370)) * den(244)
  A(517) = cont_QA(wf(:,165),wf(:,397)) * den(246)
  A(518) = cont_QA(wf(:,167),wf(:,397)) * den(247)
  A(519) = cont_QA(wf(:,165),wf(:,397)) * den(246)
  A(520) = cont_QA(wf(:,53),wf(:,398)) * den(248)
  A(521) = cont_QA(wf(:,56),wf(:,398)) * den(249)
  A(522) = cont_QA(wf(:,53),wf(:,398)) * den(248)
  A(523) = cont_QA(wf(:,160),wf(:,399)) * den(251)
  A(524) = cont_QA(wf(:,161),wf(:,399)) * den(252)
  A(525) = cont_QA(wf(:,160),wf(:,399)) * den(251)
  A(526) = cont_QA(wf(:,45),wf(:,400)) * den(253)
  A(527) = cont_QA(wf(:,48),wf(:,400)) * den(254)
  A(528) = cont_QA(wf(:,45),wf(:,400)) * den(253)
  A(529) = cont_QA(wf(:,165),wf(:,401)) * den(255)
  A(530) = cont_QA(wf(:,165),wf(:,402)) * den(256)
  A(531) = cont_QA(wf(:,165),wf(:,401)) * den(255)
  A(532) = cont_QA(wf(:,167),wf(:,401)) * den(257)
  A(533) = cont_QA(wf(:,165),wf(:,401)) * den(255)
  A(534) = cont_QA(wf(:,165),wf(:,403)) * den(255)
  A(535) = cont_QA(wf(:,160),wf(:,404)) * den(258)
  A(536) = cont_QA(wf(:,161),wf(:,404)) * den(259)
  A(537) = cont_QA(wf(:,160),wf(:,404)) * den(258)
  A(538) = cont_QA(wf(:,160),wf(:,405)) * den(260)
  A(539) = cont_QA(wf(:,160),wf(:,404)) * den(258)
  A(540) = cont_QA(wf(:,160),wf(:,406)) * den(258)
  A(541) = cont_QA(wf(:,204),wf(:,407)) * den(261)
  A(542) = cont_QA(wf(:,208),wf(:,407)) * den(262)
  A(543) = cont_QA(wf(:,204),wf(:,407)) * den(261)
  A(544) = cont_QA(wf(:,204),wf(:,408)) * den(263)
  A(545) = cont_QA(wf(:,204),wf(:,409)) * den(264)
  A(546) = cont_QA(wf(:,204),wf(:,410)) * den(265)
  A(547) = cont_QA(wf(:,204),wf(:,411)) * den(264)
  A(548) = cont_QA(wf(:,204),wf(:,410)) * den(265)
  A(549) = cont_QA(wf(:,208),wf(:,410)) * den(266)
  A(550) = cont_QA(wf(:,204),wf(:,410)) * den(265)
  A(551) = cont_QA(wf(:,204),wf(:,412)) * den(265)
  A(552) = cont_QA(wf(:,289),wf(:,413)) * den(267)
  A(553) = cont_QA(wf(:,290),wf(:,413)) * den(268)
  A(554) = cont_QA(wf(:,291),wf(:,413)) * den(269)
  A(555) = cont_QA(wf(:,291),wf(:,414)) * den(270)
  A(556) = cont_QA(wf(:,291),wf(:,413)) * den(269)
  A(557) = cont_QA(wf(:,293),wf(:,413)) * den(268)
  A(558) = cont_QA(wf(:,291),wf(:,413)) * den(269)
  A(559) = cont_QA(wf(:,291),wf(:,415)) * den(269)
  A(560) = cont_QA(wf(:,289),wf(:,416)) * den(271)
  A(561) = cont_QA(wf(:,290),wf(:,416)) * den(272)
  A(562) = cont_QA(wf(:,291),wf(:,416)) * den(273)
  A(563) = cont_QA(wf(:,293),wf(:,416)) * den(272)
  A(564) = cont_QA(wf(:,291),wf(:,416)) * den(273)
  A(565) = cont_QA(wf(:,69),wf(:,417)) * den(274)
  A(566) = cont_QA(wf(:,73),wf(:,417)) * den(275)
  A(567) = cont_QA(wf(:,69),wf(:,417)) * den(274)
  A(568) = cont_QA(wf(:,59),wf(:,392)) * den(276)
  A(569) = cont_QA(wf(:,62),wf(:,392)) * den(277)
  A(570) = cont_QA(wf(:,64),wf(:,392)) * den(278)
  A(571) = cont_QA(wf(:,66),wf(:,392)) * den(277)
  A(572) = cont_QA(wf(:,64),wf(:,392)) * den(278)
  A(573) = cont_QA(wf(:,229),wf(:,418)) * den(279)
  A(574) = cont_QA(wf(:,233),wf(:,418)) * den(280)
  A(575) = cont_QA(wf(:,229),wf(:,418)) * den(279)
  A(576) = cont_QA(wf(:,34),wf(:,419)) * den(281)
  A(577) = cont_QA(wf(:,39),wf(:,419)) * den(282)
  A(578) = cont_QA(wf(:,34),wf(:,419)) * den(281)
  A(579) = cont_QA(wf(:,229),wf(:,420)) * den(283)
  A(580) = cont_QA(wf(:,229),wf(:,421)) * den(284)
  A(581) = cont_QA(wf(:,229),wf(:,422)) * den(285)
  A(582) = cont_QA(wf(:,229),wf(:,423)) * den(284)
  A(583) = cont_QA(wf(:,229),wf(:,422)) * den(285)
  A(584) = cont_QA(wf(:,233),wf(:,422)) * den(286)
  A(585) = cont_QA(wf(:,229),wf(:,422)) * den(285)
  A(586) = cont_QA(wf(:,229),wf(:,424)) * den(285)
  A(587) = cont_QA(wf(:,224),wf(:,388)) * den(287)
  A(588) = cont_QA(wf(:,225),wf(:,388)) * den(288)
  A(589) = cont_QA(wf(:,226),wf(:,388)) * den(289)
  A(590) = cont_QA(wf(:,227),wf(:,388)) * den(288)
  A(591) = cont_QA(wf(:,226),wf(:,388)) * den(289)
  A(592) = cont_QA(wf(:,226),wf(:,389)) * den(290)
  A(593) = cont_QA(wf(:,226),wf(:,388)) * den(289)
  A(594) = cont_QA(wf(:,226),wf(:,390)) * den(289)
  A(595) = cont_QA(wf(:,224),wf(:,391)) * den(291)
  A(596) = cont_QA(wf(:,225),wf(:,391)) * den(292)
  A(597) = cont_QA(wf(:,226),wf(:,391)) * den(293)
  A(598) = cont_QA(wf(:,227),wf(:,391)) * den(292)
  A(599) = cont_QA(wf(:,226),wf(:,391)) * den(293)
  A(600) = cont_QA(wf(:,78),wf(:,425)) * den(294)
  A(601) = cont_QA(wf(:,81),wf(:,425)) * den(295)
  A(602) = cont_QA(wf(:,83),wf(:,425)) * den(296)
  A(603) = cont_QA(wf(:,85),wf(:,425)) * den(295)
  A(604) = cont_QA(wf(:,83),wf(:,425)) * den(296)
  A(605) = cont_QA(wf(:,229),wf(:,426)) * den(297)
  A(606) = cont_QA(wf(:,233),wf(:,426)) * den(298)
  A(607) = cont_QA(wf(:,229),wf(:,426)) * den(297)
  A(608) = cont_QA(wf(:,229),wf(:,427)) * den(299)
  A(609) = cont_QA(wf(:,229),wf(:,428)) * den(300)
  A(610) = cont_QA(wf(:,229),wf(:,429)) * den(301)
  A(611) = cont_QA(wf(:,229),wf(:,430)) * den(300)
  A(612) = cont_QA(wf(:,229),wf(:,429)) * den(301)
  A(613) = cont_QA(wf(:,233),wf(:,429)) * den(302)
  A(614) = cont_QA(wf(:,229),wf(:,429)) * den(301)
  A(615) = cont_QA(wf(:,229),wf(:,431)) * den(301)
  A(616) = cont_QA(wf(:,314),wf(:,413)) * den(303)
  A(617) = cont_QA(wf(:,315),wf(:,413)) * den(304)
  A(618) = cont_QA(wf(:,316),wf(:,413)) * den(305)
  A(619) = cont_QA(wf(:,316),wf(:,414)) * den(306)
  A(620) = cont_QA(wf(:,316),wf(:,413)) * den(305)
  A(621) = cont_QA(wf(:,317),wf(:,413)) * den(304)
  A(622) = cont_QA(wf(:,316),wf(:,413)) * den(305)
  A(623) = cont_QA(wf(:,316),wf(:,415)) * den(305)
  A(624) = cont_QA(wf(:,314),wf(:,416)) * den(307)
  A(625) = cont_QA(wf(:,315),wf(:,416)) * den(308)
  A(626) = cont_QA(wf(:,316),wf(:,416)) * den(309)
  A(627) = cont_QA(wf(:,317),wf(:,416)) * den(308)
  A(628) = cont_QA(wf(:,316),wf(:,416)) * den(309)
  A(629) = cont_QA(wf(:,69),wf(:,432)) * den(310)
  A(630) = cont_QA(wf(:,73),wf(:,432)) * den(311)
  A(631) = cont_QA(wf(:,69),wf(:,432)) * den(310)
  A(632) = cont_QA(wf(:,93),wf(:,425)) * den(312)
  A(633) = cont_QA(wf(:,96),wf(:,425)) * den(313)
  A(634) = cont_QA(wf(:,98),wf(:,425)) * den(314)
  A(635) = cont_QA(wf(:,100),wf(:,425)) * den(313)
  A(636) = cont_QA(wf(:,98),wf(:,425)) * den(314)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(636)
  complex(REALKIND), intent(out) :: M1(12), M2(12)

  M1( 1) = ((A(4)+A(9))*f(1))/2._/**/REALKIND+((-A(67)-A(76))*f(2))/2._/**/REALKIND+((-A(5)-A(10)-A(68) &
        -A(77))*f(3))/2._/**/REALKIND+((A(65)-A(66)+A(72)-A(73))*f(29))/2._/**/REALKIND
  M1( 2) = ((A(36)+A(50)+A(57))*f(4))/4._/**/REALKIND+((A(6)+A(11)+A(71)+A(78))*f(4))/12._/**/REALKIND &
        -(CI*A(26)*f(5))/4._/**/REALKIND
  M1( 3) = ((-A(29)-A(34))*f(1))/2._/**/REALKIND+((A(39)+A(48))*f(2))/2._/**/REALKIND+((A(30)+A(35)+A(40) &
        +A(49))*f(3))/2._/**/REALKIND+((-A(37)+A(38)-A(44)+A(45))*f(29))/2._/**/REALKIND
  M1( 4) = ((-A(31)-A(36)-A(43)-A(50))*f(4))/12._/**/REALKIND+((-A(11)-A(18)-A(78))*f(4))/4._/**/REALKIND &
        -(CI*A(1)*f(5))/4._/**/REALKIND
  M1( 5) = ((-A(27)-A(32))*f(1))/2._/**/REALKIND+((A(53)+A(60))*f(2))/2._/**/REALKIND+((A(28)+A(33)+A(54) &
        +A(61))*f(3))/2._/**/REALKIND+((-A(51)+A(52)-A(58)+A(59))*f(29))/2._/**/REALKIND
  M1( 6) = ((-A(31)-A(36)-A(57)-A(64))*f(4))/12._/**/REALKIND+((-A(6)-A(25)-A(71))*f(4))/4._/**/REALKIND &
        +(CI*A(1)*f(5))/4._/**/REALKIND
  M1( 7) = ((A(2)+A(7))*f(1))/2._/**/REALKIND+((-A(14)-A(21))*f(2))/2._/**/REALKIND+((-A(3)-A(8)-A(15) &
        -A(22))*f(3))/2._/**/REALKIND+((A(12)-A(13)+A(19)-A(20))*f(29))/2._/**/REALKIND
  M1( 8) = ((A(6)+A(11)+A(18)+A(25))*f(4))/12._/**/REALKIND+((A(31)+A(43)+A(64))*f(4))/4._/**/REALKIND &
        +(CI*A(26)*f(5))/4._/**/REALKIND
  M1( 9) = ((A(27)+A(29)+A(32)+A(34)+A(41)+A(46)+A(55)+A(62))*f(1))/6._/**/REALKIND+((A(16)+A(23)+A(69) &
        +A(74))*f(1))/2._/**/REALKIND+((-A(39)-A(48)-A(53)-A(60))*f(2))/6._/**/REALKIND+((-A(28)-A(30)-A(33)-A(35)-A(40)-A(42) &
        -A(47)-A(49)-A(54)-A(56)-A(61)-A(63))*f(3))/6._/**/REALKIND+((-A(17)-A(24)-A(70)-A(75))*f(3))/2._/**/REALKIND+((A(37) &
        -A(38)+A(44)-A(45)+A(51)-A(52)+A(58)-A(59))*f(29))/6._/**/REALKIND
  M1(10) = ((A(31)+A(36)+A(43)+A(50)+A(57)+A(64))*f(4))/36._/**/REALKIND+((A(18)+A(25)+A(71)+A(78))*f(4))/12._/**/REALKIND
  M1(11) = ((-A(41)-A(46)-A(55)-A(62))*f(1))/2._/**/REALKIND+((-A(2)-A(4)-A(7)-A(9)-A(16)-A(23)-A(69)-A(74))*f(1))/6._/**/REALKIND &
        +((A(14)+A(21)+A(67)+A(76))*f(2))/6._/**/REALKIND+((A(42)+A(47)+A(56)+A(63))*f(3))/2._/**/REALKIND+((A(3)+A(5)+A(8)+A(10) &
        +A(15)+A(17)+A(22)+A(24)+A(68)+A(70)+A(75)+A(77))*f(3))/6._/**/REALKIND+((-A(12)+A(13)-A(19)+A(20)-A(65)+A(66)-A(72) &
        +A(73))*f(29))/6._/**/REALKIND
  M1(12) = ((-A(43)-A(50)-A(57)-A(64))*f(4))/12._/**/REALKIND+((-A(6)-A(11)-A(18)-A(25)-A(71)-A(78))*f(4))/36._/**/REALKIND

  M2( 1) = ((-A(458)-A(461)-A(472)-A(478))*f(6))/2._/**/REALKIND+((A(610)+A(620)+A(626)+A(634))*f(7))/2._/**/REALKIND+((A(160) &
        +A(166)+A(190)+A(206)+A(214)+A(246)+A(316)+A(346)+A(354)+A(378)+A(392)+A(416)-A(540)-A(559)-A(586))*f(8))/4._/**/REALKIND &
        +((A(90)+A(96)+A(102)+A(108)+A(230)+A(238)+A(262)+A(270)+A(294)+A(300)+A(324)+A(332)+A(400)+A(408)+A(432)+A(438)-A(475) &
        -A(481)-A(615)-A(623))*f(8))/12._/**/REALKIND+((A(459)+A(462)+A(473)+A(479)+A(611)+A(621)+A(627) &
        +A(635))*f(8))/2._/**/REALKIND+(CI*(-A(174)-A(334)-A(380))*f(9))/4._/**/REALKIND+((A(93)+A(105))*f(10))/2._/**/REALKIND+(( &
        -A(225)-A(235))*f(11))/2._/**/REALKIND+((-A(94)-A(106)-A(226)-A(236))*f(12))/2._/**/REALKIND+((A(429) &
        +A(435))*f(13))/2._/**/REALKIND+((-A(257)-A(405))*f(14))/2._/**/REALKIND+((-A(258)-A(406)-A(430) &
        -A(436))*f(15))/2._/**/REALKIND+((A(87)+A(99))*f(16))/2._/**/REALKIND+((-A(88)-A(100))*f(17))/2._/**/REALKIND+((A(291) &
        +A(297))*f(18))/2._/**/REALKIND+((-A(267)-A(321)-A(327)-A(395))*f(19))/2._/**/REALKIND+((-A(268)-A(292)-A(298)-A(322) &
        -A(328)-A(396))*f(20))/2._/**/REALKIND+(A(82)*f(21))/2._/**/REALKIND+((-A(608)+A(609)-A(616)+A(617)-A(624)+A(625)-A(632) &
        +A(633))*f(30))/2._/**/REALKIND+((A(223)-A(224)+A(231)-A(232))*f(31))/2._/**/REALKIND+((A(255)-A(256)+A(401) &
        -A(402))*f(32))/2._/**/REALKIND+((A(263)-A(264)+A(317)-A(318)+A(325)-A(326)+A(393)-A(394))*f(33))/2._/**/REALKIND &
        +(A(80)*f(34))/2._/**/REALKIND
  M2( 2) = ((-A(522)-A(525)-A(539)-A(558)-A(564)-A(567)-A(575)-A(585)-A(604))*f(22))/4._/**/REALKIND+((-A(460)-A(463)-A(466) &
        -A(469)-A(474)-A(480)-A(607)-A(614)-A(622)-A(628)-A(631)-A(636))*f(22))/12._/**/REALKIND+(CI*(-A(514)+A(515) &
        +A(516))*f(23))/4._/**/REALKIND+((A(159)+A(165)+A(189)+A(213))*f(24))/4._/**/REALKIND+((A(89)+A(95)+A(101)+A(107)+A(229) &
        +A(237))*f(24))/12._/**/REALKIND-(CI*A(173)*f(25))/4._/**/REALKIND+((A(205)+A(245)+A(315)+A(345)+A(353)+A(377)+A(391) &
        +A(415))*f(26))/4._/**/REALKIND+((A(261)+A(269)+A(293)+A(299)+A(323)+A(331)+A(399)+A(407)+A(431) &
        +A(437))*f(26))/12._/**/REALKIND+(CI*(-A(333)-A(379))*f(27))/4._/**/REALKIND-(CI*A(148)*f(28))/4._/**/REALKIND
  M2( 3) = ((A(517)+A(520)+A(531)+A(537))*f(6))/2._/**/REALKIND+((-A(546)-A(556)-A(562)-A(570))*f(7))/2._/**/REALKIND+((-A(154) &
        -A(160)-A(166)-A(172)-A(182)-A(190)-A(198)-A(206)-A(340)-A(346)-A(354)-A(362)-A(370)-A(378)-A(386)-A(392)+A(534)+A(540) &
        +A(551)+A(559))*f(8))/12._/**/REALKIND+((-A(518)-A(521)-A(532)-A(538)-A(547)-A(557)-A(563)-A(571))*f(8))/2._/**/REALKIND &
        +((-A(96)-A(102)-A(118)-A(134)-A(238)-A(270)-A(286)-A(300)-A(324)-A(408)-A(438)-A(446)+A(481)+A(495) &
        +A(623))*f(8))/4._/**/REALKIND+(CI*(-A(110)-A(288)-A(426))*f(9))/4._/**/REALKIND+((-A(157)-A(169))*f(10))/2._/**/REALKIND &
        +((A(177)+A(187))*f(11))/2._/**/REALKIND+((A(158)+A(170)+A(178)+A(188))*f(12))/2._/**/REALKIND+((-A(383) &
        -A(389))*f(13))/2._/**/REALKIND+((A(193)+A(375))*f(14))/2._/**/REALKIND+((A(194)+A(376)+A(384) &
        +A(390))*f(15))/2._/**/REALKIND+((-A(151)-A(163))*f(16))/2._/**/REALKIND+((A(152)+A(164))*f(17))/2._/**/REALKIND+((-A(337) &
        -A(343))*f(18))/2._/**/REALKIND+((A(203)+A(351)+A(357)+A(365))*f(19))/2._/**/REALKIND+((A(204)+A(338)+A(344)+A(352)+A(358) &
        +A(366))*f(20))/2._/**/REALKIND-(A(146)*f(21))/2._/**/REALKIND+((A(544)-A(545)+A(552)-A(553)+A(560)-A(561)+A(568) &
        -A(569))*f(30))/2._/**/REALKIND+((-A(175)+A(176)-A(183)+A(184))*f(31))/2._/**/REALKIND+((-A(191)+A(192)-A(371) &
        +A(372))*f(32))/2._/**/REALKIND+((-A(199)+A(200)-A(347)+A(348)-A(355)+A(356)-A(363)+A(364))*f(33))/2._/**/REALKIND &
        -(A(144)*f(34))/2._/**/REALKIND
  M2( 4) = ((A(519)+A(522)+A(525)+A(528)+A(533)+A(539)+A(543)+A(550)+A(558)+A(564)+A(567)+A(572))*f(22))/12._/**/REALKIND+((A(463) &
        +A(466)+A(480)+A(484)+A(494)+A(513)+A(622)+A(628)+A(631))*f(22))/4._/**/REALKIND+(CI*(A(455)-A(456) &
        +A(457))*f(23))/4._/**/REALKIND+((-A(153)-A(159)-A(165)-A(171)-A(181)-A(189))*f(24))/12._/**/REALKIND+((-A(95)-A(101) &
        -A(117)-A(237))*f(24))/4._/**/REALKIND-(CI*A(109)*f(25))/4._/**/REALKIND+((-A(197)-A(205)-A(339)-A(345)-A(353)-A(361) &
        -A(369)-A(377)-A(385)-A(391))*f(26))/12._/**/REALKIND+((-A(133)-A(269)-A(285)-A(299)-A(323)-A(407)-A(437) &
        -A(445))*f(26))/4._/**/REALKIND+(CI*(-A(287)-A(425))*f(27))/4._/**/REALKIND-(CI*A(84)*f(28))/4._/**/REALKIND
  M2( 5) = ((A(523)+A(526)+A(529)+A(535))*f(6))/2._/**/REALKIND+((-A(581)-A(589)-A(597)-A(602))*f(7))/2._/**/REALKIND+((-A(154) &
        -A(160)-A(166)-A(172)-A(214)-A(222)-A(246)-A(254)-A(308)-A(316)-A(340)-A(346)-A(386)-A(392)-A(416)-A(424)+A(534)+A(540) &
        +A(586)+A(594))*f(8))/12._/**/REALKIND+((-A(524)-A(527)-A(530)-A(536)-A(582)-A(590)-A(598)-A(603))*f(8))/2._/**/REALKIND &
        +((-A(90)-A(108)-A(126)-A(142)-A(230)-A(262)-A(278)-A(294)-A(332)-A(400)-A(432)-A(454)+A(475)+A(503) &
        +A(615))*f(8))/4._/**/REALKIND+(CI*(A(110)+A(288)+A(426))*f(9))/4._/**/REALKIND+((-A(149)-A(161))*f(10))/2._/**/REALKIND &
        +((A(209)+A(217))*f(11))/2._/**/REALKIND+((A(150)+A(162)+A(210)+A(218))*f(12))/2._/**/REALKIND+((-A(335) &
        -A(341))*f(13))/2._/**/REALKIND+((A(241)+A(303))*f(14))/2._/**/REALKIND+((A(242)+A(304)+A(336) &
        +A(342))*f(15))/2._/**/REALKIND+((-A(155)-A(167))*f(16))/2._/**/REALKIND+((A(156)+A(168))*f(17))/2._/**/REALKIND+((-A(381) &
        -A(387))*f(18))/2._/**/REALKIND+((A(249)+A(311)+A(411)+A(419))*f(19))/2._/**/REALKIND+((A(250)+A(312)+A(382)+A(388)+A(412) &
        +A(420))*f(20))/2._/**/REALKIND-(A(145)*f(21))/2._/**/REALKIND+((A(579)-A(580)+A(587)-A(588)+A(595)-A(596)+A(600) &
        -A(601))*f(30))/2._/**/REALKIND+((-A(207)+A(208)-A(215)+A(216))*f(31))/2._/**/REALKIND+((-A(239)+A(240)-A(301) &
        +A(302))*f(32))/2._/**/REALKIND+((-A(247)+A(248)-A(309)+A(310)-A(409)+A(410)-A(417)+A(418))*f(33))/2._/**/REALKIND &
        -(A(143)*f(34))/2._/**/REALKIND
  M2( 6) = ((A(519)+A(522)+A(525)+A(528)+A(533)+A(539)+A(575)+A(578)+A(585)+A(593)+A(599)+A(604))*f(22))/12._/**/REALKIND+((A(460) &
        +A(469)+A(474)+A(487)+A(502)+A(508)+A(607)+A(614)+A(636))*f(22))/4._/**/REALKIND+(CI*(-A(455)+A(456) &
        -A(457))*f(23))/4._/**/REALKIND+((-A(153)-A(159)-A(165)-A(171)-A(213)-A(221))*f(24))/12._/**/REALKIND+((-A(89)-A(107) &
        -A(125)-A(229))*f(24))/4._/**/REALKIND+(CI*A(109)*f(25))/4._/**/REALKIND+((-A(245)-A(253)-A(307)-A(315)-A(339)-A(345) &
        -A(385)-A(391)-A(415)-A(423))*f(26))/12._/**/REALKIND+((-A(141)-A(261)-A(277)-A(293)-A(331)-A(399)-A(431) &
        -A(453))*f(26))/4._/**/REALKIND+(CI*(A(287)+A(425))*f(27))/4._/**/REALKIND+(CI*A(84)*f(28))/4._/**/REALKIND
  M2( 7) = ((-A(464)-A(467)-A(470)-A(476))*f(6))/2._/**/REALKIND+((A(490)+A(498)+A(506)+A(511))*f(7))/2._/**/REALKIND+((A(90) &
        +A(96)+A(102)+A(108)+A(118)+A(126)+A(134)+A(142)+A(278)+A(286)+A(294)+A(300)+A(432)+A(438)+A(446)+A(454)-A(475)-A(481) &
        -A(495)-A(503))*f(8))/12._/**/REALKIND+((A(465)+A(468)+A(471)+A(477)+A(491)+A(499)+A(507)+A(512))*f(8))/2._/**/REALKIND &
        +((A(154)+A(172)+A(182)+A(198)+A(222)+A(254)+A(308)+A(340)+A(362)+A(370)+A(386)+A(424)-A(534)-A(551) &
        -A(594))*f(8))/4._/**/REALKIND+(CI*(A(174)+A(334)+A(380))*f(9))/4._/**/REALKIND+((A(85)+A(97))*f(10))/2._/**/REALKIND+(( &
        -A(113)-A(121))*f(11))/2._/**/REALKIND+((-A(86)-A(98)-A(114)-A(122))*f(12))/2._/**/REALKIND+((A(289) &
        +A(295))*f(13))/2._/**/REALKIND+((-A(129)-A(273))*f(14))/2._/**/REALKIND+((-A(130)-A(274)-A(290) &
        -A(296))*f(15))/2._/**/REALKIND+((A(91)+A(103))*f(16))/2._/**/REALKIND+((-A(92)-A(104))*f(17))/2._/**/REALKIND+((A(427) &
        +A(433))*f(18))/2._/**/REALKIND+((-A(137)-A(281)-A(441)-A(449))*f(19))/2._/**/REALKIND+((-A(138)-A(282)-A(428)-A(434) &
        -A(442)-A(450))*f(20))/2._/**/REALKIND+(A(81)*f(21))/2._/**/REALKIND+((-A(488)+A(489)-A(496)+A(497)-A(504)+A(505)-A(509) &
        +A(510))*f(30))/2._/**/REALKIND+((A(111)-A(112)+A(119)-A(120))*f(31))/2._/**/REALKIND+((A(127)-A(128)+A(271) &
        -A(272))*f(32))/2._/**/REALKIND+((A(135)-A(136)+A(279)-A(280)+A(439)-A(440)+A(447)-A(448))*f(33))/2._/**/REALKIND &
        +(A(79)*f(34))/2._/**/REALKIND
  M2( 8) = ((-A(460)-A(463)-A(466)-A(469)-A(474)-A(480)-A(484)-A(487)-A(494)-A(502)-A(508)-A(513))*f(22))/12._/**/REALKIND+(( &
        -A(519)-A(528)-A(533)-A(543)-A(550)-A(572)-A(578)-A(593)-A(599))*f(22))/4._/**/REALKIND+(CI*(A(514)-A(515) &
        -A(516))*f(23))/4._/**/REALKIND+((A(89)+A(95)+A(101)+A(107)+A(117)+A(125))*f(24))/12._/**/REALKIND+((A(153)+A(171)+A(181) &
        +A(221))*f(24))/4._/**/REALKIND+(CI*A(173)*f(25))/4._/**/REALKIND+((A(197)+A(253)+A(307)+A(339)+A(361)+A(369)+A(385) &
        +A(423))*f(26))/4._/**/REALKIND+((A(133)+A(141)+A(277)+A(285)+A(293)+A(299)+A(431)+A(437)+A(445) &
        +A(453))*f(26))/12._/**/REALKIND+(CI*(A(333)+A(379))*f(27))/4._/**/REALKIND+(CI*A(148)*f(28))/4._/**/REALKIND
  M2( 9) = ((-A(517)-A(520)-A(523)-A(526)-A(529)-A(531)-A(535)-A(537)-A(541)-A(548)-A(554)-A(565)-A(573)-A(576)-A(583) &
        -A(591))*f(6))/6._/**/REALKIND+((-A(482)-A(485)-A(492)-A(500)-A(605)-A(612)-A(618)-A(629))*f(6))/2._/**/REALKIND+((A(546) &
        +A(556)+A(562)+A(570)+A(581)+A(589)+A(597)+A(602))*f(7))/6._/**/REALKIND+((A(154)+A(160)+A(166)+A(172)+A(182)+A(190) &
        +A(198)+A(206)+A(214)+A(222)+A(246)+A(254)+A(308)+A(316)+A(340)+A(346)+A(354)+A(362)+A(370)+A(378)+A(386)+A(392)+A(416) &
        +A(424)-A(534)-A(540)-A(551)-A(559)-A(586)-A(594))*f(8))/36._/**/REALKIND+((A(518)+A(521)+A(524)+A(527)+A(530)+A(532) &
        +A(536)+A(538)+A(542)+A(547)+A(549)+A(555)+A(557)+A(563)+A(566)+A(571)+A(574)+A(577)+A(582)+A(584)+A(590)+A(592)+A(598) &
        +A(603))*f(8))/6._/**/REALKIND+((A(118)+A(126)+A(134)+A(142)+A(230)+A(238)+A(262)+A(270)+A(278)+A(286)+A(324)+A(332) &
        +A(400)+A(408)+A(446)+A(454)-A(495)-A(503)-A(615)-A(623))*f(8))/12._/**/REALKIND+((A(483)+A(486)+A(493)+A(501)+A(606) &
        +A(613)+A(619)+A(630))*f(8))/2._/**/REALKIND+((A(149)+A(157)+A(161)+A(169))*f(10))/6._/**/REALKIND+((-A(177)-A(187)-A(209) &
        -A(217))*f(11))/6._/**/REALKIND+((-A(150)-A(158)-A(162)-A(170)-A(178)-A(188)-A(210)-A(218))*f(12))/6._/**/REALKIND &
        +((A(201)+A(251)+A(313)+A(335)+A(341)+A(349)+A(359)+A(367)+A(383)+A(389)+A(413)+A(421))*f(13))/6._/**/REALKIND+((A(139) &
        +A(265)+A(283)+A(319)+A(329)+A(397)+A(443)+A(451))*f(13))/2._/**/REALKIND+((-A(193)-A(241)-A(303) &
        -A(375))*f(14))/6._/**/REALKIND+((-A(194)-A(202)-A(242)-A(252)-A(304)-A(314)-A(336)-A(342)-A(350)-A(360)-A(368)-A(376) &
        -A(384)-A(390)-A(414)-A(422))*f(15))/6._/**/REALKIND+((-A(140)-A(266)-A(284)-A(320)-A(330)-A(398)-A(444) &
        -A(452))*f(15))/2._/**/REALKIND+((A(151)+A(155)+A(163)+A(167)+A(179)+A(185)+A(211)+A(219))*f(16))/6._/**/REALKIND+((A(115) &
        +A(123)+A(227)+A(233))*f(16))/2._/**/REALKIND+((-A(152)-A(156)-A(164)-A(168)-A(180)-A(186)-A(212) &
        -A(220))*f(17))/6._/**/REALKIND+((-A(116)-A(124)-A(228)-A(234))*f(17))/2._/**/REALKIND+((A(195)+A(243)+A(305)+A(337) &
        +A(343)+A(373)+A(381)+A(387))*f(18))/6._/**/REALKIND+((A(131)+A(259)+A(275)+A(403))*f(18))/2._/**/REALKIND+((-A(203) &
        -A(249)-A(311)-A(351)-A(357)-A(365)-A(411)-A(419))*f(19))/6._/**/REALKIND+((-A(132)-A(260)-A(276) &
        -A(404))*f(20))/2._/**/REALKIND+((-A(196)-A(204)-A(244)-A(250)-A(306)-A(312)-A(338)-A(344)-A(352)-A(358)-A(366)-A(374) &
        -A(382)-A(388)-A(412)-A(420))*f(20))/6._/**/REALKIND+(A(83)*f(21))/2._/**/REALKIND+((A(145)+A(146) &
        +A(147))*f(21))/6._/**/REALKIND+((-A(544)+A(545)-A(552)+A(553)-A(560)+A(561)-A(568)+A(569)-A(579)+A(580)-A(587)+A(588) &
        -A(595)+A(596)-A(600)+A(601))*f(30))/6._/**/REALKIND+((A(175)-A(176)+A(183)-A(184)+A(207)-A(208)+A(215) &
        -A(216))*f(31))/6._/**/REALKIND+((A(191)-A(192)+A(239)-A(240)+A(301)-A(302)+A(371)-A(372))*f(32))/6._/**/REALKIND+((A(199) &
        -A(200)+A(247)-A(248)+A(309)-A(310)+A(347)-A(348)+A(355)-A(356)+A(363)-A(364)+A(409)-A(410)+A(417) &
        -A(418))*f(33))/6._/**/REALKIND+((A(143)+A(144))*f(34))/6._/**/REALKIND
  M2(10) = ((-A(519)-A(522)-A(525)-A(528)-A(533)-A(539)-A(543)-A(550)-A(558)-A(564)-A(567)-A(572)-A(575)-A(578)-A(585)-A(593) &
        -A(599)-A(604))*f(22))/36._/**/REALKIND+((-A(484)-A(487)-A(494)-A(502)-A(508)-A(513)-A(607)-A(614)-A(622)-A(628)-A(631) &
        -A(636))*f(22))/12._/**/REALKIND+((A(153)+A(159)+A(165)+A(171)+A(181)+A(189)+A(213)+A(221))*f(24))/36._/**/REALKIND &
        +((A(117)+A(125)+A(229)+A(237))*f(24))/12._/**/REALKIND+((A(197)+A(205)+A(245)+A(253)+A(307)+A(315)+A(339)+A(345)+A(353) &
        +A(361)+A(369)+A(377)+A(385)+A(391)+A(415)+A(423))*f(26))/36._/**/REALKIND+((A(133)+A(141)+A(261)+A(269)+A(277)+A(285) &
        +A(323)+A(331)+A(399)+A(407)+A(445)+A(453))*f(26))/12._/**/REALKIND
  M2(11) = ((A(541)+A(548)+A(554)+A(565)+A(573)+A(576)+A(583)+A(591))*f(6))/2._/**/REALKIND+((A(458)+A(461)+A(464)+A(467)+A(470) &
        +A(472)+A(476)+A(478)+A(482)+A(485)+A(492)+A(500)+A(605)+A(612)+A(618)+A(629))*f(6))/6._/**/REALKIND+((-A(490)-A(498) &
        -A(506)-A(511)-A(610)-A(620)-A(626)-A(634))*f(7))/6._/**/REALKIND+((-A(542)-A(549)-A(555)-A(566)-A(574)-A(577)-A(584) &
        -A(592))*f(8))/2._/**/REALKIND+((-A(182)-A(190)-A(198)-A(206)-A(214)-A(222)-A(246)-A(254)-A(308)-A(316)-A(354)-A(362) &
        -A(370)-A(378)-A(416)-A(424)+A(551)+A(559)+A(586)+A(594))*f(8))/12._/**/REALKIND+((-A(90)-A(96)-A(102)-A(108)-A(118) &
        -A(126)-A(134)-A(142)-A(230)-A(238)-A(262)-A(270)-A(278)-A(286)-A(294)-A(300)-A(324)-A(332)-A(400)-A(408)-A(432)-A(438) &
        -A(446)-A(454)+A(475)+A(481)+A(495)+A(503)+A(615)+A(623))*f(8))/36._/**/REALKIND+((-A(459)-A(462)-A(465)-A(468)-A(471) &
        -A(473)-A(477)-A(479)-A(483)-A(486)-A(491)-A(493)-A(499)-A(501)-A(507)-A(512)-A(606)-A(611)-A(613)-A(619)-A(621)-A(627) &
        -A(630)-A(635))*f(8))/6._/**/REALKIND+((-A(85)-A(93)-A(97)-A(105))*f(10))/6._/**/REALKIND+((A(113)+A(121)+A(225) &
        +A(235))*f(11))/6._/**/REALKIND+((A(86)+A(94)+A(98)+A(106)+A(114)+A(122)+A(226)+A(236))*f(12))/6._/**/REALKIND+((-A(201) &
        -A(251)-A(313)-A(349)-A(359)-A(367)-A(413)-A(421))*f(13))/2._/**/REALKIND+((-A(139)-A(265)-A(283)-A(289)-A(295)-A(319) &
        -A(329)-A(397)-A(429)-A(435)-A(443)-A(451))*f(13))/6._/**/REALKIND+((A(129)+A(257)+A(273)+A(405))*f(14))/6._/**/REALKIND &
        +((A(202)+A(252)+A(314)+A(350)+A(360)+A(368)+A(414)+A(422))*f(15))/2._/**/REALKIND+((A(130)+A(140)+A(258)+A(266)+A(274) &
        +A(284)+A(290)+A(296)+A(320)+A(330)+A(398)+A(406)+A(430)+A(436)+A(444)+A(452))*f(15))/6._/**/REALKIND+((-A(179)-A(185) &
        -A(211)-A(219))*f(16))/2._/**/REALKIND+((-A(87)-A(91)-A(99)-A(103)-A(115)-A(123)-A(227)-A(233))*f(16))/6._/**/REALKIND &
        +((A(180)+A(186)+A(212)+A(220))*f(17))/2._/**/REALKIND+((A(88)+A(92)+A(100)+A(104)+A(116)+A(124)+A(228) &
        +A(234))*f(17))/6._/**/REALKIND+((-A(195)-A(243)-A(305)-A(373))*f(18))/2._/**/REALKIND+((-A(131)-A(259)-A(275)-A(291) &
        -A(297)-A(403)-A(427)-A(433))*f(18))/6._/**/REALKIND+((A(137)+A(267)+A(281)+A(321)+A(327)+A(395)+A(441) &
        +A(449))*f(19))/6._/**/REALKIND+((A(196)+A(244)+A(306)+A(374))*f(20))/2._/**/REALKIND+((A(132)+A(138)+A(260)+A(268)+A(276) &
        +A(282)+A(292)+A(298)+A(322)+A(328)+A(396)+A(404)+A(428)+A(434)+A(442)+A(450))*f(20))/6._/**/REALKIND+((-A(81)-A(82) &
        -A(83))*f(21))/6._/**/REALKIND-(A(147)*f(21))/2._/**/REALKIND+((A(488)-A(489)+A(496)-A(497)+A(504)-A(505)+A(509)-A(510) &
        +A(608)-A(609)+A(616)-A(617)+A(624)-A(625)+A(632)-A(633))*f(30))/6._/**/REALKIND+((-A(111)+A(112)-A(119)+A(120)-A(223) &
        +A(224)-A(231)+A(232))*f(31))/6._/**/REALKIND+((-A(127)+A(128)-A(255)+A(256)-A(271)+A(272)-A(401) &
        +A(402))*f(32))/6._/**/REALKIND+((-A(135)+A(136)-A(263)+A(264)-A(279)+A(280)-A(317)+A(318)-A(325)+A(326)-A(393)+A(394) &
        -A(439)+A(440)-A(447)+A(448))*f(33))/6._/**/REALKIND+((-A(79)-A(80))*f(34))/6._/**/REALKIND
  M2(12) = ((A(543)+A(550)+A(558)+A(564)+A(567)+A(572)+A(575)+A(578)+A(585)+A(593)+A(599)+A(604))*f(22))/12._/**/REALKIND+((A(460) &
        +A(463)+A(466)+A(469)+A(474)+A(480)+A(484)+A(487)+A(494)+A(502)+A(508)+A(513)+A(607)+A(614)+A(622)+A(628)+A(631) &
        +A(636))*f(22))/36._/**/REALKIND+((-A(181)-A(189)-A(213)-A(221))*f(24))/12._/**/REALKIND+((-A(89)-A(95)-A(101)-A(107) &
        -A(117)-A(125)-A(229)-A(237))*f(24))/36._/**/REALKIND+((-A(197)-A(205)-A(245)-A(253)-A(307)-A(315)-A(353)-A(361)-A(369) &
        -A(377)-A(415)-A(423))*f(26))/12._/**/REALKIND+((-A(133)-A(141)-A(261)-A(269)-A(277)-A(285)-A(293)-A(299)-A(323)-A(331) &
        -A(399)-A(407)-A(431)-A(437)-A(445)-A(453))*f(26))/36._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pptttt_ew_tttxtxddx_1_/**/REALKIND
