
module ol_colourmatrix_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,12), KL(12,12)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  2,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(  3,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  4,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(  5,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  6,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(  7,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(  8,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(  9,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 10,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1( 11,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 12,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]
  K1( 13,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 14,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 15,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 16,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 17,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 18,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 19,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 20,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 21,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 22,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 23,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 24,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 25,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1( 26,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1( 27,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1( 28,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1( 29,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1( 30,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1( 31,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1( 32,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1( 33,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1( 34,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1( 35,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1( 36,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1( 37,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 38,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 39,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 40,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 41,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 42,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 43,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 44,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 45,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 46,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 47,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 48,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 49,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1( 50,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 51,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1( 52,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1( 53,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1( 54,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1( 55,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1( 56,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1( 57,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1( 58,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1( 59,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1( 60,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1( 61,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1( 62,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1( 63,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1( 64,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1( 65,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1( 66,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1( 67,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1( 68,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1( 69,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1( 70,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1( 71,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1( 72,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1( 73,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1( 74,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1( 75,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1( 76,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1( 77,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1( 78,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1( 79,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1( 80,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1( 81,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1( 82,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1( 83,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1( 84,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1( 85,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1( 86,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1( 87,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1( 88,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1( 89,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1( 90,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1( 91,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1( 92,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1( 93,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1( 94,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1( 95,:) = [   0,   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0]
  K1( 96,:) = [   0,   0,  -4,   0,  -4,   0,   0,   0, -12,   0,   0,   0]
  K1( 97,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1( 98,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1( 99,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(100,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(101,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(102,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(103,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(104,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(105,:) = [   0,  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12]
  K1(106,:) = [  -4,   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0]
  K1(107,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(108,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(109,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(110,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(111,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(112,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(113,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1(114,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1(115,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1(116,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1(117,:) = [   0,   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12]
  K1(118,:) = [   4,   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0]
  K1(119,:) = [   0,   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0]
  K1(120,:) = [   0,   0,   4,   0,   4,   0,   0,   0,  12,   0,   0,   0]
  K1(121,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(122,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(123,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(124,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(125,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(126,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(127,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(128,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(129,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(130,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(131,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(132,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(133,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1(134,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1(136,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1(137,:) = [   0,   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4]
  K1(138,:) = [   0,   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0]
  K1(139,:) = [   0,   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0]
  K1(140,:) = [   4,   0,   0,   0,  12,   0,   0,   0,   4,   0,   0,   0]
  K1(141,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1(142,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1(143,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1(144,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1(145,:) = [   0,   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0]
  K1(146,:) = [   0,   0,  12,   0,   0,   0,   4,   0,   4,   0,   0,   0]
  K1(147,:) = [   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4]
  K1(148,:) = [  12,   0,   0,   0,   4,   0,   0,   0,   0,   0,   4,   0]
  K1(149,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(150,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(151,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(152,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(153,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(154,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(155,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(156,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(157,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(158,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(159,:) = [   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4]
  K1(160,:) = [ -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0,  -4,   0]
  K1(161,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(162,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(163,:) = [   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0]
  K1(164,:) = [  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0,   0,   0]
  K1(165,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(166,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(167,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(168,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(169,:) = [   0,   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0]
  K1(170,:) = [   0,   0, -12,   0,   0,   0,  -4,   0,  -4,   0,   0,   0]
  K1(171,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(172,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(173,:) = [   0,   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4]
  K1(174,:) = [   0,   0,  -4,   0,   0,   0, -12,   0,   0,   0,  -4,   0]
  K1(175,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(176,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(177,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(178,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(179,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(180,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(181,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(182,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(183,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(184,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(185,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(186,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(187,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(188,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(189,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(190,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(191,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(192,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(193,:) = [   0, -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12]
  K1(194,:) = [ -36,   0, -12,   0, -12,   0,  -4,   0,  -4,   0, -12,   0]
  K1(195,:) = [   0, -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4]
  K1(196,:) = [ -12,   0, -36,   0,  -4,   0, -12,   0, -12,   0,  -4,   0]
  K1(197,:) = [   0, -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4]
  K1(198,:) = [ -12,   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0]
  K1(199,:) = [   0,  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0]
  K1(200,:) = [  -4,   0, -12,   0,   0,   0,   0,   0,  -4,   0,   0,   0]
  K1(201,:) = [   0,  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0]
  K1(202,:) = [  -4,   0, -12,   0,   0,   0,  -4,   0,   0,   0,   0,   0]
  K1(203,:) = [   0, -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0]
  K1(204,:) = [ -12,   0,  -4,   0,  -4,   0,   0,   0,   0,   0,   0,   0]
  K1(205,:) = [   0,   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0]
  K1(206,:) = [   0,   0,   0,   0, -12,   0,  -4,   0,  -4,   0,   0,   0]
  K1(207,:) = [   0,   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4]
  K1(208,:) = [   0,   0,   0,   0,  -4,   0, -12,   0,   0,   0,  -4,   0]
  K1(209,:) = [   0, -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4]
  K1(210,:) = [ -12,   0,  -4,   0, -36,   0, -12,   0, -12,   0,  -4,   0]
  K1(211,:) = [   0,  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12]
  K1(212,:) = [  -4,   0, -12,   0, -12,   0, -36,   0,  -4,   0, -12,   0]
  K1(213,:) = [   0,  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0]
  K1(214,:) = [  -4,   0,   0,   0, -12,   0,  -4,   0,   0,   0,   0,   0]
  K1(215,:) = [   0,   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0]
  K1(216,:) = [   0,   0,  -4,   0,  -4,   0, -12,   0,   0,   0,   0,   0]
  K1(217,:) = [   0,   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12]
  K1(218,:) = [   0,   0,   0,   0,   0,   0,   4,   0,   4,   0,  12,   0]
  K1(219,:) = [   0,   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4]
  K1(220,:) = [   0,   0,   0,   0,   4,   0,  12,   0,   0,   0,   4,   0]
  K1(221,:) = [   0,   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4]
  K1(222,:) = [   0,   0,   4,   0,   0,   0,   0,   0,  12,   0,   4,   0]
  K1(223,:) = [   0,   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0]
  K1(224,:) = [   4,   0,  12,   0,   0,   0,   0,   0,   4,   0,   0,   0]
  K1(225,:) = [   0,   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0]
  K1(226,:) = [   4,   0,   0,   0,  12,   0,   4,   0,   0,   0,   0,   0]
  K1(227,:) = [   0,  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0]
  K1(228,:) = [  12,   0,   4,   0,   4,   0,   0,   0,   0,   0,   0,   0]
  K1(229,:) = [   0,   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0]
  K1(230,:) = [   0,   0,   0,   0,  12,   0,   4,   0,   4,   0,   0,   0]
  K1(231,:) = [   0,   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4]
  K1(232,:) = [   0,   0,   0,   0,   4,   0,   0,   0,  12,   0,   4,   0]
  K1(233,:) = [   0,  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4]
  K1(234,:) = [  12,   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0]
  K1(235,:) = [   0,   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12]
  K1(236,:) = [   4,   0,   0,   0,   0,   0,   0,   0,   4,   0,  12,   0]
  K1(237,:) = [   0,   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0]
  K1(238,:) = [   4,   0,  12,   0,   0,   0,   4,   0,   0,   0,   0,   0]
  K1(239,:) = [   0,   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0]
  K1(240,:) = [   0,   0,   4,   0,   4,   0,  12,   0,   0,   0,   0,   0]
  K1(241,:) = [   0,   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12]
  K1(242,:) = [   0,   0,   0,   0,   0,   0,  -4,   0,  -4,   0, -12,   0]
  K1(243,:) = [   0,   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4]
  K1(244,:) = [   0,   0,   0,   0,  -4,   0,   0,   0, -12,   0,  -4,   0]
  K1(245,:) = [   0,   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4]
  K1(246,:) = [   0,   0,  -4,   0,   0,   0,   0,   0, -12,   0,  -4,   0]
  K1(247,:) = [   0,  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12]
  K1(248,:) = [  -4,   0,   0,   0,   0,   0,   0,   0,  -4,   0, -12,   0]
  K1(249,:) = [   0,  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12]
  K1(250,:) = [  -4,   0, -12,   0, -12,   0,  -4,   0, -36,   0, -12,   0]
  K1(251,:) = [   0, -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36]
  K1(252,:) = [ -12,   0,  -4,   0,  -4,   0, -12,   0, -12,   0, -36,   0]
  K1(253,:) = [   0,  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12]
  K1(254,:) = [  36,   0,  12,   0,  12,   0,   4,   0,   4,   0,  12,   0]
  K1(255,:) = [   0,  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4]
  K1(256,:) = [  12,   0,  36,   0,   4,   0,  12,   0,  12,   0,   4,   0]
  K1(257,:) = [   0,  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4]
  K1(258,:) = [  12,   0,   4,   0,  36,   0,  12,   0,  12,   0,   4,   0]
  K1(259,:) = [   0,   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12]
  K1(260,:) = [   4,   0,  12,   0,  12,   0,  36,   0,   4,   0,  12,   0]
  K1(261,:) = [   0,   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12]
  K1(262,:) = [   4,   0,  12,   0,  12,   0,   4,   0,  36,   0,  12,   0]
  K1(263,:) = [   0,  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36]
  K1(264,:) = [  12,   0,   4,   0,   4,   0,  12,   0,  12,   0,  36,   0]
  K1(265,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(266,:) = [   0,  27,   0,   9,   0,   9,   0,   3,   0,   3,   0,   9]
  K1(267,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(268,:) = [   0,   9,   0,  27,   0,   3,   0,   9,   0,   9,   0,   3]
  K1(269,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(270,:) = [   0,   9,   0,   3,   0,  27,   0,   9,   0,   9,   0,   3]
  K1(271,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(272,:) = [   0,   3,   0,   9,   0,   9,   0,  27,   0,   3,   0,   9]
  K1(273,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(274,:) = [   0,   3,   0,   9,   0,   9,   0,   3,   0,  27,   0,   9]
  K1(275,:) = [   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0]
  K1(276,:) = [   0,   9,   0,   3,   0,   3,   0,   9,   0,   9,   0,  27]

  K2( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  K2( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  K2( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  K2( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  K2( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  K2( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  K2( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  K2( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  K2( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  K2(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  K2(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  K2(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]

  KL( 1,:) = [  0, 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9]
  KL( 2,:) = [ 27,  0,  9,  0,  9,  0,  3,  0,  3,  0,  9,  0]
  KL( 3,:) = [  0,  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3]
  KL( 4,:) = [  9,  0, 27,  0,  3,  0,  9,  0,  9,  0,  3,  0]
  KL( 5,:) = [  0,  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3]
  KL( 6,:) = [  9,  0,  3,  0, 27,  0,  9,  0,  9,  0,  3,  0]
  KL( 7,:) = [  0,  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9]
  KL( 8,:) = [  3,  0,  9,  0,  9,  0, 27,  0,  3,  0,  9,  0]
  KL( 9,:) = [  0,  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9]
  KL(10,:) = [  3,  0,  9,  0,  9,  0,  3,  0, 27,  0,  9,  0]
  KL(11,:) = [  0,  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27]
  KL(12,:) = [  9,  0,  3,  0,  3,  0,  9,  0,  9,  0, 27,  0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_ew_tttxtxbbx_1_/**/REALKIND



module ol_forced_parameters_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'
  if (wMB /= 0) write(*,101) 'wMB = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_ew_tttxtxbbx_1_/**/REALKIND

module ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(96), c(170)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:942)
  ! denominators
  complex(REALKIND), save :: den(769)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(12,64), Mct(12,64), Mcol_loop(12,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 1)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 2) = (4*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 3) = CI*eQED**2*gQCD**2
    f( 4) = CI*gQCD**4
    f( 5) = gQCD**4
    f( 6) = (2*CI*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 7) = (4*CI*countertermnorm*eQED**2*gQCD**4)/9._/**/REALKIND
    f( 8) = CI*countertermnorm*eQED**2*gQCD**4
    f( 9) = countertermnorm*eQED**2*gQCD**4
    f(10) = (2*CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/9._/**/REALKIND
    f(11) = (4*CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/9._/**/REALKIND
    f(12) = CI*countertermnorm*ctGbb*eQED**2*gQCD**4
    f(13) = (2*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(14) = (4*CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(15) = CI*countertermnorm*ctGtt*eQED**2*gQCD**4
    f(16) = (2*CI*countertermnorm*ctVbb*eQED**2*gQCD**4)/9._/**/REALKIND
    f(17) = CI*countertermnorm*ctVbb*eQED**2*gQCD**4
    f(18) = (2*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(19) = (4*CI*countertermnorm*ctVtt*eQED**2*gQCD**4)/9._/**/REALKIND
    f(20) = CI*countertermnorm*ctVtt*eQED**2*gQCD**4
    f(21) = countertermnorm*ctZGG*eQED**2*gQCD**4
    f(22) = CI*countertermnorm*gQCD**6
    f(23) = countertermnorm*gQCD**6
    f(24) = CI*countertermnorm*ctGbb*gQCD**6
    f(25) = countertermnorm*ctGbb*gQCD**6
    f(26) = CI*countertermnorm*ctGtt*gQCD**6
    f(27) = countertermnorm*ctGtt*gQCD**6
    f(28) = countertermnorm*ctVVV*gQCD**6
    f(29) = (CI*eQED**2*gQCD**2)/(2._/**/REALKIND*sw**2)
    f(30) = (CI*countertermnorm*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(31) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(32) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(33) = (CI*countertermnorm*ctVbt*eQED**2*gQCD**4)/(2._/**/REALKIND*sw**2)
    f(34) = (CI*eQED**2*gQCD**2)/(2._/**/REALKIND*MW**2*sw**2)
    f(35) = (CI*countertermnorm*eQED**2*gQCD**4)/(2._/**/REALKIND*MW**2*sw**2)
    f(36) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4)/(2._/**/REALKIND*MW**2*sw**2)
    f(37) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4)/(2._/**/REALKIND*MW**2*sw**2)
    f(38) = (CI*eQED**2*gQCD**2*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(39) = (CI*countertermnorm*eQED**2*gQCD**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(40) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(41) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(42) = (CI*countertermnorm*ctSbb*eQED**2*gQCD**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(43) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MB*MT)/(4._/**/REALKIND*MW**2*sw**2)
    f(44) = (CI*eQED**2*gQCD**2*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(45) = (CI*countertermnorm*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(46) = (CI*countertermnorm*ctGbb*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(47) = (CI*countertermnorm*ctGtt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(48) = (CI*countertermnorm*ctStt*eQED**2*gQCD**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(49) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MB)/(2._/**/REALKIND*MW*sw)
    f(50) = (CI*countertermnorm*ctHGG*eQED**2*gQCD**4*MT)/(2._/**/REALKIND*MW*sw)
    f(51) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(52) = (2*CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(53) = (4*CI*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(54) = CI*eQED**2*gQCD**4*integralnorm*SwB
    f(55) = (eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(56) = (2*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(57) = (4*eQED**2*gQCD**4*integralnorm*SwB)/9._/**/REALKIND
    f(58) = (eQED**2*gQCD**4*integralnorm*SwB)/2._/**/REALKIND
    f(59) = eQED**2*gQCD**4*integralnorm*SwB
    f(60) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(61) = CI*gQCD**6*integralnorm*SwB
    f(62) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(63) = gQCD**6*integralnorm*SwB
    f(64) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*sw**2)
    f(65) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*4._/**/REALKIND)
    f(66) = (eQED**2*gQCD**4*integralnorm*SwB)/(sw**2*2._/**/REALKIND)
    f(67) = (CI*eQED**2*gQCD**4*integralnorm*SwB)/(2._/**/REALKIND*MW**2*sw**2)
    f(68) = (eQED**2*gQCD**4*integralnorm*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(69) = (eQED**2*gQCD**4*integralnorm*SwB)/(MW**2*sw**2*2._/**/REALKIND)
    f(70) = (CI*eQED**2*gQCD**4*integralnorm*MB**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(71) = (eQED**2*gQCD**4*integralnorm*MB**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(72) = (CI*eQED**2*gQCD**4*integralnorm*MB*MT*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(73) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*8._/**/REALKIND)
    f(74) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(75) = (CI*eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(4._/**/REALKIND*MW**2*sw**2)
    f(76) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*8._/**/REALKIND)
    f(77) = (eQED**2*gQCD**4*integralnorm*MT**2*SwB)/(MW**2*sw**2*4._/**/REALKIND)
    f(78) = (eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(79) = (2*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(80) = (4*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(81) = (8*eQED**2*gQCD**4*integralnorm*SwF)/9._/**/REALKIND
    f(82) = eQED**2*gQCD**4*integralnorm*SwF
    f(83) = 2*eQED**2*gQCD**4*integralnorm*SwF
    f(84) = CI*gQCD**6*integralnorm*SwF
    f(85) = 2*CI*gQCD**6*integralnorm*SwF
    f(86) = gQCD**6*integralnorm*SwF
    f(87) = 2*gQCD**6*integralnorm*SwF
    f(88) = (eQED**2*gQCD**4*integralnorm*SwF)/(sw**2*2._/**/REALKIND)
    f(89) = (eQED**2*gQCD**4*integralnorm*SwF)/sw**2
    f(90) = (eQED**2*gQCD**4*integralnorm*SwF)/(MW**2*sw**2*2._/**/REALKIND)
    f(91) = (eQED**2*gQCD**4*integralnorm*SwF)/(MW**2*sw**2)
    f(92) = (eQED**2*gQCD**4*integralnorm*MB**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(93) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(94) = (eQED**2*gQCD**4*integralnorm*MB*MT*SwF)/(MW**2*sw**2*2._/**/REALKIND)
    f(95) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*4._/**/REALKIND)
    f(96) = (eQED**2*gQCD**4*integralnorm*MT**2*SwF)/(MW**2*sw**2*2._/**/REALKIND)

  c = [ 54*CI*f(51), 54*CI*f(52), 162*CI*f(52), 54*CI*f(53), 162*CI*f(53), 54*CI*f(54), 162*CI*f(54), 6*f(55), 18*f(55), 54*f(55) &
    , 108*f(55), 324*f(55), 6*f(56), 18*f(56), 36*f(56), 48*f(56), 54*f(56), 60*f(56), 108*f(56), 126*f(56), 144*f(56), 324*f(56) &
    , 6*f(57), 18*f(57), 36*f(57), 48*f(57), 54*f(57), 60*f(57), 108*f(57), 126*f(57), 144*f(57), 324*f(57), 108*f(58), 324*f(58) &
    , 6*f(59), 18*f(59), 36*f(59), 48*f(59), 54*f(59), 60*f(59), 108*f(59), 126*f(59), 144*f(59), 324*f(59), 81*CI*f(60) &
    , 162*CI*f(60), 9*CI*f(61), 27*CI*f(61), 72*CI*f(61), 81*CI*f(61), 162*CI*f(61), 18*f(62), 54*f(62), 162*f(62), f(63), 3*f(63) &
    , 6*f(63), 8*f(63), 9*f(63), 10*f(63), 18*f(63), 21*f(63), 24*f(63), 27*f(63), 30*f(63), 54*f(63), 63*f(63), 72*f(63) &
    , 81*f(63), 162*f(63), 54*CI*f(64), 162*CI*f(64), 108*f(65), 324*f(65), 6*f(66), 18*f(66), 36*f(66), 48*f(66), 54*f(66) &
    , 60*f(66), 108*f(66), 126*f(66), 144*f(66), 324*f(66), 54*CI*f(67), 162*CI*f(67), 108*f(68), 324*f(68), 6*f(69), 18*f(69) &
    , 36*f(69), 48*f(69), 54*f(69), 60*f(69), 108*f(69), 126*f(69), 144*f(69), 324*f(69), 54*CI*f(70), 6*f(71), 18*f(71), 54*f(71) &
    , 54*CI*f(72), 162*CI*f(72), 108*f(73), 324*f(73), 6*f(74), 18*f(74), 36*f(74), 48*f(74), 54*f(74), 60*f(74), 108*f(74) &
    , 126*f(74), 144*f(74), 324*f(74), 54*CI*f(75), 162*CI*f(75), 108*f(76), 324*f(76), 6*f(77), 18*f(77), 36*f(77), 48*f(77) &
    , 54*f(77), 60*f(77), 108*f(77), 126*f(77), 144*f(77), 324*f(77), 18*f(78), 54*f(78), 18*f(79), 54*f(79), 18*f(80), 54*f(80) &
    , 18*f(81), 54*f(81), 18*f(82), 54*f(82), 18*f(83), 54*f(83), 27*CI*f(84), 27*CI*f(85), 3*f(86), 6*f(86), 9*f(86), 27*f(86) &
    , 3*f(87), 6*f(87), 9*f(87), 27*f(87), 18*f(88), 54*f(88), 18*f(89), 54*f(89), 18*f(90), 54*f(90), 18*f(91), 54*f(91) &
    , 18*f(92), 54*f(92), 18*f(93), 54*f(93), 18*f(94), 54*f(94), 18*f(95), 54*f(95), 18*f(96), 54*f(96) ]
  c = (1._/**/REALKIND / 216) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(12), M2(12)
  complex(REALKIND) :: A(1086)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_Q(P(:,5), rMB, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_A(P(:,6), rMB, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), 0)
    call pol_wf_Q(P(:,5), rMB, H(5), wf(:,-4), 0)
    call pol_wf_A(P(:,6), rMB, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_QA_V(wf(:,-4),wf(:,-5),wf(:,3))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,4))
  call vert_AQ_S(gH,wf(:,-2),wf(:,0),wf(:,5))
  call vert_QS_A(gH,wf(:,-4),wf(:,5),wf(:,6))
  call vert_AV_Q(wf(:,-5),wf(:,2),wf(:,7))
  call prop_Q_A(wf(:,6),Q(:,21),MB,1_intkind1,wf(:,8))
  call vert_AQ_S(gX,wf(:,-2),wf(:,0),wf(:,9))
  call vert_QS_A(gX,wf(:,-4),wf(:,9),wf(:,10))
  call prop_Q_A(wf(:,10),Q(:,21),MB,1_intkind1,wf(:,11))
  call vert_AQ_S(gH,wf(:,-3),wf(:,-1),wf(:,12))
  call vert_VQ_A(wf(:,1),wf(:,-4),wf(:,13))
  call vert_SA_Q(gH,wf(:,12),wf(:,-5),wf(:,14))
  call prop_Q_A(wf(:,13),Q(:,21),MB,1_intkind1,wf(:,15))
  call vert_AQ_S(gX,wf(:,-3),wf(:,-1),wf(:,16))
  call vert_SA_Q(gX,wf(:,16),wf(:,-5),wf(:,17))
  call vert_QA_Z(gZu,wf(:,0),wf(:,-2),wf(:,18))
  call vert_ZQ_A(gZd,wf(:,18),wf(:,-4),wf(:,19))
  call prop_Q_A(wf(:,19),Q(:,21),MB,1_intkind1,wf(:,20))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,-3),wf(:,21))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,21),wf(:,22))
  call vert_VQ_A(wf(:,2),wf(:,-4),wf(:,23))
  call vert_SA_Q(gH,wf(:,5),wf(:,-5),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,26),MB,1_intkind1,wf(:,25))
  call vert_SA_Q(gX,wf(:,9),wf(:,-5),wf(:,26))
  call vert_QS_A(gH,wf(:,-4),wf(:,12),wf(:,27))
  call vert_AV_Q(wf(:,-5),wf(:,1),wf(:,28))
  call prop_Q_A(wf(:,27),Q(:,26),MB,1_intkind1,wf(:,29))
  call vert_QS_A(gX,wf(:,-4),wf(:,16),wf(:,30))
  call prop_Q_A(wf(:,30),Q(:,26),MB,1_intkind1,wf(:,31))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,18),wf(:,32))
  call vert_ZQ_A(gZd,wf(:,21),wf(:,-4),wf(:,33))
  call prop_Q_A(wf(:,33),Q(:,26),MB,1_intkind1,wf(:,34))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,-4),wf(:,35))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,36))
  call vert_SA_Q(gPbt,wf(:,35),wf(:,-5),wf(:,37))
  call prop_Q_A(wf(:,36),Q(:,7),MT,1_intkind1,wf(:,38))
  call vert_QA_W(wf(:,-4),wf(:,-3),wf(:,39))
  call vert_AW_Q(wf(:,-5),wf(:,39),wf(:,40))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,35),wf(:,41))
  call prop_Q_A(wf(:,41),Q(:,26),MB,1_intkind1,wf(:,42))
  call vert_WQ_A(wf(:,39),wf(:,-1),wf(:,43))
  call prop_Q_A(wf(:,43),Q(:,26),MB,1_intkind1,wf(:,44))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,-1),wf(:,45))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,46))
  call vert_QS_A(gPtb,wf(:,-4),wf(:,45),wf(:,47))
  call prop_A_Q(wf(:,46),Q(:,13),MT,1_intkind1,wf(:,48))
  call vert_QA_W(wf(:,-1),wf(:,-5),wf(:,49))
  call vert_WQ_A(wf(:,49),wf(:,-4),wf(:,50))
  call vert_SA_Q(gPtb,wf(:,45),wf(:,-3),wf(:,51))
  call prop_A_Q(wf(:,51),Q(:,42),MB,1_intkind1,wf(:,52))
  call vert_AW_Q(wf(:,-3),wf(:,49),wf(:,53))
  call prop_A_Q(wf(:,53),Q(:,42),MB,1_intkind1,wf(:,54))
  call vert_QS_A(gH,wf(:,-1),wf(:,5),wf(:,55))
  call vert_AV_Q(wf(:,-3),wf(:,3),wf(:,56))
  call prop_Q_A(wf(:,55),Q(:,7),MT,1_intkind1,wf(:,57))
  call vert_QS_A(gX,wf(:,-1),wf(:,9),wf(:,58))
  call prop_Q_A(wf(:,58),Q(:,7),MT,1_intkind1,wf(:,59))
  call vert_AQ_S(gH,wf(:,-5),wf(:,-4),wf(:,60))
  call vert_SA_Q(gH,wf(:,60),wf(:,-3),wf(:,61))
  call vert_AQ_S(gX,wf(:,-5),wf(:,-4),wf(:,62))
  call vert_SA_Q(gX,wf(:,62),wf(:,-3),wf(:,63))
  call vert_ZQ_A(gZu,wf(:,18),wf(:,-1),wf(:,64))
  call prop_Q_A(wf(:,64),Q(:,7),MT,1_intkind1,wf(:,65))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,-5),wf(:,66))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,66),wf(:,67))
  call vert_VQ_A(wf(:,3),wf(:,-1),wf(:,68))
  call vert_SA_Q(gH,wf(:,5),wf(:,-3),wf(:,69))
  call prop_Q_A(wf(:,68),Q(:,50),MT,1_intkind1,wf(:,70))
  call vert_SA_Q(gX,wf(:,9),wf(:,-3),wf(:,71))
  call vert_QS_A(gH,wf(:,-1),wf(:,60),wf(:,72))
  call prop_Q_A(wf(:,72),Q(:,50),MT,1_intkind1,wf(:,73))
  call vert_QS_A(gX,wf(:,-1),wf(:,62),wf(:,74))
  call prop_Q_A(wf(:,74),Q(:,50),MT,1_intkind1,wf(:,75))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,18),wf(:,76))
  call vert_ZQ_A(gZu,wf(:,66),wf(:,-1),wf(:,77))
  call prop_Q_A(wf(:,77),Q(:,50),MT,1_intkind1,wf(:,78))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,79))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,80))
  call vert_UV_W(wf(:,80),Q(:,6),wf(:,79),Q(:,9),wf(:,81))
  call vert_AQ_S(gH,wf(:,-3),wf(:,0),wf(:,82))
  call vert_QS_A(gH,wf(:,-4),wf(:,82),wf(:,83))
  call vert_AV_Q(wf(:,-5),wf(:,80),wf(:,84))
  call prop_Q_A(wf(:,83),Q(:,25),MB,1_intkind1,wf(:,85))
  call vert_AQ_S(gX,wf(:,-3),wf(:,0),wf(:,86))
  call vert_QS_A(gX,wf(:,-4),wf(:,86),wf(:,87))
  call prop_Q_A(wf(:,87),Q(:,25),MB,1_intkind1,wf(:,88))
  call vert_AQ_S(gH,wf(:,-2),wf(:,-1),wf(:,89))
  call vert_VQ_A(wf(:,79),wf(:,-4),wf(:,90))
  call vert_SA_Q(gH,wf(:,89),wf(:,-5),wf(:,91))
  call prop_Q_A(wf(:,90),Q(:,25),MB,1_intkind1,wf(:,92))
  call vert_AQ_S(gX,wf(:,-2),wf(:,-1),wf(:,93))
  call vert_SA_Q(gX,wf(:,93),wf(:,-5),wf(:,94))
  call vert_QA_Z(gZu,wf(:,0),wf(:,-3),wf(:,95))
  call vert_ZQ_A(gZd,wf(:,95),wf(:,-4),wf(:,96))
  call prop_Q_A(wf(:,96),Q(:,25),MB,1_intkind1,wf(:,97))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,-2),wf(:,98))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,98),wf(:,99))
  call vert_VQ_A(wf(:,80),wf(:,-4),wf(:,100))
  call vert_SA_Q(gH,wf(:,82),wf(:,-5),wf(:,101))
  call prop_Q_A(wf(:,100),Q(:,22),MB,1_intkind1,wf(:,102))
  call vert_SA_Q(gX,wf(:,86),wf(:,-5),wf(:,103))
  call vert_QS_A(gH,wf(:,-4),wf(:,89),wf(:,104))
  call vert_AV_Q(wf(:,-5),wf(:,79),wf(:,105))
  call prop_Q_A(wf(:,104),Q(:,22),MB,1_intkind1,wf(:,106))
  call vert_QS_A(gX,wf(:,-4),wf(:,93),wf(:,107))
  call prop_Q_A(wf(:,107),Q(:,22),MB,1_intkind1,wf(:,108))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,95),wf(:,109))
  call vert_ZQ_A(gZd,wf(:,98),wf(:,-4),wf(:,110))
  call prop_Q_A(wf(:,110),Q(:,22),MB,1_intkind1,wf(:,111))
  call vert_VQ_A(wf(:,80),wf(:,0),wf(:,112))
  call prop_Q_A(wf(:,112),Q(:,7),MT,1_intkind1,wf(:,113))
  call vert_QS_A(gPbt,wf(:,0),wf(:,35),wf(:,114))
  call prop_Q_A(wf(:,114),Q(:,25),MB,1_intkind1,wf(:,115))
  call vert_WQ_A(wf(:,39),wf(:,0),wf(:,116))
  call prop_Q_A(wf(:,116),Q(:,25),MB,1_intkind1,wf(:,117))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,0),wf(:,118))
  call vert_SA_Q(gPtb,wf(:,118),wf(:,-3),wf(:,119))
  call prop_A_Q(wf(:,119),Q(:,41),MB,1_intkind1,wf(:,120))
  call vert_QA_W(wf(:,0),wf(:,-5),wf(:,121))
  call vert_AW_Q(wf(:,-3),wf(:,121),wf(:,122))
  call prop_A_Q(wf(:,122),Q(:,41),MB,1_intkind1,wf(:,123))
  call vert_AV_Q(wf(:,-3),wf(:,80),wf(:,124))
  call vert_QS_A(gPtb,wf(:,-4),wf(:,118),wf(:,125))
  call prop_A_Q(wf(:,124),Q(:,14),MT,1_intkind1,wf(:,126))
  call vert_WQ_A(wf(:,121),wf(:,-4),wf(:,127))
  call vert_QS_A(gH,wf(:,0),wf(:,89),wf(:,128))
  call prop_Q_A(wf(:,128),Q(:,7),MT,1_intkind1,wf(:,129))
  call vert_QS_A(gX,wf(:,0),wf(:,93),wf(:,130))
  call prop_Q_A(wf(:,130),Q(:,7),MT,1_intkind1,wf(:,131))
  call vert_ZQ_A(gZu,wf(:,98),wf(:,0),wf(:,132))
  call prop_Q_A(wf(:,132),Q(:,7),MT,1_intkind1,wf(:,133))
  call vert_QS_A(gH,wf(:,0),wf(:,60),wf(:,134))
  call prop_Q_A(wf(:,134),Q(:,49),MT,1_intkind1,wf(:,135))
  call vert_QS_A(gX,wf(:,0),wf(:,62),wf(:,136))
  call prop_Q_A(wf(:,136),Q(:,49),MT,1_intkind1,wf(:,137))
  call vert_VQ_A(wf(:,3),wf(:,0),wf(:,138))
  call vert_SA_Q(gH,wf(:,89),wf(:,-3),wf(:,139))
  call prop_Q_A(wf(:,138),Q(:,49),MT,1_intkind1,wf(:,140))
  call vert_SA_Q(gX,wf(:,93),wf(:,-3),wf(:,141))
  call vert_ZQ_A(gZu,wf(:,66),wf(:,0),wf(:,142))
  call prop_Q_A(wf(:,142),Q(:,49),MT,1_intkind1,wf(:,143))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,98),wf(:,144))
  call vert_AQ_S(gPtb,wf(:,-2),wf(:,-4),wf(:,145))
  call vert_VQ_A(wf(:,79),wf(:,-1),wf(:,146))
  call vert_SA_Q(gPbt,wf(:,145),wf(:,-5),wf(:,147))
  call prop_Q_A(wf(:,146),Q(:,11),MT,1_intkind1,wf(:,148))
  call vert_QA_W(wf(:,-4),wf(:,-2),wf(:,149))
  call vert_AW_Q(wf(:,-5),wf(:,149),wf(:,150))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,145),wf(:,151))
  call prop_Q_A(wf(:,151),Q(:,22),MB,1_intkind1,wf(:,152))
  call vert_WQ_A(wf(:,149),wf(:,-1),wf(:,153))
  call prop_Q_A(wf(:,153),Q(:,22),MB,1_intkind1,wf(:,154))
  call vert_AV_Q(wf(:,-2),wf(:,79),wf(:,155))
  call prop_A_Q(wf(:,155),Q(:,13),MT,1_intkind1,wf(:,156))
  call vert_SA_Q(gPtb,wf(:,45),wf(:,-2),wf(:,157))
  call prop_A_Q(wf(:,157),Q(:,38),MB,1_intkind1,wf(:,158))
  call vert_AW_Q(wf(:,-2),wf(:,49),wf(:,159))
  call prop_A_Q(wf(:,159),Q(:,38),MB,1_intkind1,wf(:,160))
  call vert_QS_A(gH,wf(:,-1),wf(:,82),wf(:,161))
  call vert_AV_Q(wf(:,-2),wf(:,3),wf(:,162))
  call prop_Q_A(wf(:,161),Q(:,11),MT,1_intkind1,wf(:,163))
  call vert_QS_A(gX,wf(:,-1),wf(:,86),wf(:,164))
  call prop_Q_A(wf(:,164),Q(:,11),MT,1_intkind1,wf(:,165))
  call vert_SA_Q(gH,wf(:,60),wf(:,-2),wf(:,166))
  call vert_SA_Q(gX,wf(:,62),wf(:,-2),wf(:,167))
  call vert_ZQ_A(gZu,wf(:,95),wf(:,-1),wf(:,168))
  call prop_Q_A(wf(:,168),Q(:,11),MT,1_intkind1,wf(:,169))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,66),wf(:,170))
  call vert_SA_Q(gH,wf(:,82),wf(:,-2),wf(:,171))
  call vert_SA_Q(gX,wf(:,86),wf(:,-2),wf(:,172))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,95),wf(:,173))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,174))
  call prop_Q_A(wf(:,174),Q(:,11),MT,1_intkind1,wf(:,175))
  call vert_QS_A(gPbt,wf(:,0),wf(:,145),wf(:,176))
  call prop_Q_A(wf(:,176),Q(:,21),MB,1_intkind1,wf(:,177))
  call vert_WQ_A(wf(:,149),wf(:,0),wf(:,178))
  call prop_Q_A(wf(:,178),Q(:,21),MB,1_intkind1,wf(:,179))
  call vert_SA_Q(gPtb,wf(:,118),wf(:,-2),wf(:,180))
  call prop_A_Q(wf(:,180),Q(:,37),MB,1_intkind1,wf(:,181))
  call vert_AW_Q(wf(:,-2),wf(:,121),wf(:,182))
  call prop_A_Q(wf(:,182),Q(:,37),MB,1_intkind1,wf(:,183))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,184))
  call prop_A_Q(wf(:,184),Q(:,14),MT,1_intkind1,wf(:,185))
  call vert_QS_A(gH,wf(:,0),wf(:,12),wf(:,186))
  call prop_Q_A(wf(:,186),Q(:,11),MT,1_intkind1,wf(:,187))
  call vert_QS_A(gX,wf(:,0),wf(:,16),wf(:,188))
  call prop_Q_A(wf(:,188),Q(:,11),MT,1_intkind1,wf(:,189))
  call vert_ZQ_A(gZu,wf(:,21),wf(:,0),wf(:,190))
  call prop_Q_A(wf(:,190),Q(:,11),MT,1_intkind1,wf(:,191))
  call vert_SA_Q(gH,wf(:,12),wf(:,-2),wf(:,192))
  call vert_SA_Q(gX,wf(:,16),wf(:,-2),wf(:,193))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,21),wf(:,194))
  call counter_SG_G(wf(:,5),wf(:,2),wf(:,195))
  call counter_SG_G(wf(:,12),wf(:,1),wf(:,196))
  call counter_GG_S(wf(:,1),wf(:,2),wf(:,197))
  call counter_VG_G(wf(:,18),wf(:,2),Q(:,10),wf(:,198),Q(:,15))
  call counter_VG_G(wf(:,21),wf(:,1),Q(:,5),wf(:,199),Q(:,15))
  call counter_GG_V(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,200))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,201))
  call counter_AV_Q(wf(:,-5),wf(:,2),wf(:,202))
  call counter_SA_Q(gH,wf(:,12),wf(:,-5),wf(:,203))
  call counter_SA_Q(gX,wf(:,16),wf(:,-5),wf(:,204))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,21),wf(:,205))
  call counter_AV_Q_LR(EWctGbb,wf(:,-5),wf(:,2),wf(:,206))
  call counter_SA_Q(gH,wf(:,5),wf(:,-5),wf(:,207))
  call counter_SA_Q(gX,wf(:,9),wf(:,-5),wf(:,208))
  call counter_AV_Q(wf(:,-5),wf(:,1),wf(:,209))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,18),wf(:,210))
  call counter_AV_Q_LR(EWctGbb,wf(:,-5),wf(:,1),wf(:,211))
  call counter_VQ_A(wf(:,2),wf(:,-4),wf(:,212))
  call prop_A_Q(wf(:,24),Q(:,37),MB,1_intkind1,wf(:,213))
  call prop_A_Q(wf(:,26),Q(:,37),MB,1_intkind1,wf(:,214))
  call counter_QS_A(gH,wf(:,-4),wf(:,12),wf(:,215))
  call prop_A_Q(wf(:,28),Q(:,37),MB,1_intkind1,wf(:,216))
  call counter_QS_A(gX,wf(:,-4),wf(:,16),wf(:,217))
  call prop_A_Q(wf(:,32),Q(:,37),MB,1_intkind1,wf(:,218))
  call counter_ZQ_A(gZd,wf(:,21),wf(:,-4),wf(:,219))
  call counter_VQ_A_LR(EWctGbb,wf(:,2),wf(:,-4),wf(:,220))
  call counter_QS_A(gH,wf(:,-4),wf(:,5),wf(:,221))
  call prop_A_Q(wf(:,7),Q(:,42),MB,1_intkind1,wf(:,222))
  call counter_QS_A(gX,wf(:,-4),wf(:,9),wf(:,223))
  call counter_VQ_A(wf(:,1),wf(:,-4),wf(:,224))
  call prop_A_Q(wf(:,14),Q(:,42),MB,1_intkind1,wf(:,225))
  call prop_A_Q(wf(:,17),Q(:,42),MB,1_intkind1,wf(:,226))
  call counter_ZQ_A(gZd,wf(:,18),wf(:,-4),wf(:,227))
  call prop_A_Q(wf(:,22),Q(:,42),MB,1_intkind1,wf(:,228))
  call counter_VQ_A_LR(EWctGbb,wf(:,1),wf(:,-4),wf(:,229))
  call counter_QA_V(wf(:,-4),wf(:,-5),wf(:,230))
  call counter_QA_V_LR(EWctGbb,wf(:,-4),wf(:,-5),wf(:,231))
  call counter_SA_Q(ctSbt,wf(:,35),wf(:,-5),wf(:,232))
  call counter_AW_Q(wf(:,-5),wf(:,39),wf(:,233))
  call counter_QS_A(ctStb,wf(:,-4),wf(:,45),wf(:,234))
  call counter_WQ_A(wf(:,49),wf(:,-4),wf(:,235))
  call vert_AV_Q(wf(:,-3),wf(:,230),wf(:,236))
  call counter_AQ_S(gH,wf(:,-5),wf(:,-4),wf(:,237))
  call vert_SA_Q(gH,wf(:,237),wf(:,-3),wf(:,238))
  call counter_AQ_S(gX,wf(:,-5),wf(:,-4),wf(:,239))
  call vert_SA_Q(gX,wf(:,239),wf(:,-3),wf(:,240))
  call counter_QA_Z(gZd,wf(:,-4),wf(:,-5),wf(:,241))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,241),wf(:,242))
  call vert_AV_Q(wf(:,-3),wf(:,231),wf(:,243))
  call vert_VQ_A(wf(:,230),wf(:,-1),wf(:,244))
  call prop_Q_A(wf(:,244),Q(:,50),MT,1_intkind1,wf(:,245))
  call vert_QS_A(gH,wf(:,-1),wf(:,237),wf(:,246))
  call prop_Q_A(wf(:,246),Q(:,50),MT,1_intkind1,wf(:,247))
  call vert_QS_A(gX,wf(:,-1),wf(:,239),wf(:,248))
  call prop_Q_A(wf(:,248),Q(:,50),MT,1_intkind1,wf(:,249))
  call vert_ZQ_A(gZu,wf(:,241),wf(:,-1),wf(:,250))
  call prop_Q_A(wf(:,250),Q(:,50),MT,1_intkind1,wf(:,251))
  call vert_VQ_A(wf(:,231),wf(:,-1),wf(:,252))
  call prop_Q_A(wf(:,252),Q(:,50),MT,1_intkind1,wf(:,253))
  call counter_SA_Q(ctStb,wf(:,45),wf(:,-3),wf(:,254))
  call counter_AW_Q(wf(:,-3),wf(:,49),wf(:,255))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,256))
  call prop_Q_A(wf(:,47),Q(:,50),MT,1_intkind1,wf(:,257))
  call prop_Q_A(wf(:,50),Q(:,50),MT,1_intkind1,wf(:,258))
  call counter_AV_Q(wf(:,-3),wf(:,3),wf(:,259))
  call counter_SA_Q(gH,wf(:,60),wf(:,-3),wf(:,260))
  call counter_SA_Q(gX,wf(:,62),wf(:,-3),wf(:,261))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,66),wf(:,262))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,3),wf(:,263))
  call counter_SA_Q(gH,wf(:,5),wf(:,-3),wf(:,264))
  call counter_SA_Q(gX,wf(:,9),wf(:,-3),wf(:,265))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,18),wf(:,266))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,1),wf(:,267))
  call counter_AQ_S(ctStb,wf(:,-3),wf(:,-4),wf(:,268))
  call vert_SA_Q(gPbt,wf(:,268),wf(:,-5),wf(:,269))
  call counter_QA_W(wf(:,-4),wf(:,-3),wf(:,270))
  call vert_AW_Q(wf(:,-5),wf(:,270),wf(:,271))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,268),wf(:,272))
  call prop_Q_A(wf(:,272),Q(:,26),MB,1_intkind1,wf(:,273))
  call vert_WQ_A(wf(:,270),wf(:,-1),wf(:,274))
  call prop_Q_A(wf(:,274),Q(:,26),MB,1_intkind1,wf(:,275))
  call counter_SG_G(wf(:,82),wf(:,80),wf(:,276))
  call counter_SG_G(wf(:,89),wf(:,79),wf(:,277))
  call counter_GG_S(wf(:,80),wf(:,79),wf(:,278))
  call counter_VG_G(wf(:,95),wf(:,80),Q(:,6),wf(:,279),Q(:,15))
  call counter_VG_G(wf(:,98),wf(:,79),Q(:,9),wf(:,280),Q(:,15))
  call counter_GG_V(wf(:,80),Q(:,6),wf(:,79),Q(:,9),wf(:,281))
  call counter_UV_W(wf(:,80),Q(:,6),wf(:,79),Q(:,9),wf(:,282))
  call counter_AV_Q(wf(:,-5),wf(:,80),wf(:,283))
  call counter_SA_Q(gH,wf(:,89),wf(:,-5),wf(:,284))
  call counter_SA_Q(gX,wf(:,93),wf(:,-5),wf(:,285))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,98),wf(:,286))
  call counter_AV_Q_LR(EWctGbb,wf(:,-5),wf(:,80),wf(:,287))
  call counter_SA_Q(gH,wf(:,82),wf(:,-5),wf(:,288))
  call counter_SA_Q(gX,wf(:,86),wf(:,-5),wf(:,289))
  call counter_AV_Q(wf(:,-5),wf(:,79),wf(:,290))
  call counter_AZ_Q(gZd,wf(:,-5),wf(:,95),wf(:,291))
  call counter_AV_Q_LR(EWctGbb,wf(:,-5),wf(:,79),wf(:,292))
  call counter_VQ_A(wf(:,80),wf(:,-4),wf(:,293))
  call prop_A_Q(wf(:,101),Q(:,41),MB,1_intkind1,wf(:,294))
  call prop_A_Q(wf(:,103),Q(:,41),MB,1_intkind1,wf(:,295))
  call counter_QS_A(gH,wf(:,-4),wf(:,89),wf(:,296))
  call prop_A_Q(wf(:,105),Q(:,41),MB,1_intkind1,wf(:,297))
  call counter_QS_A(gX,wf(:,-4),wf(:,93),wf(:,298))
  call prop_A_Q(wf(:,109),Q(:,41),MB,1_intkind1,wf(:,299))
  call counter_ZQ_A(gZd,wf(:,98),wf(:,-4),wf(:,300))
  call counter_VQ_A_LR(EWctGbb,wf(:,80),wf(:,-4),wf(:,301))
  call counter_QS_A(gH,wf(:,-4),wf(:,82),wf(:,302))
  call prop_A_Q(wf(:,84),Q(:,38),MB,1_intkind1,wf(:,303))
  call counter_QS_A(gX,wf(:,-4),wf(:,86),wf(:,304))
  call counter_VQ_A(wf(:,79),wf(:,-4),wf(:,305))
  call prop_A_Q(wf(:,91),Q(:,38),MB,1_intkind1,wf(:,306))
  call prop_A_Q(wf(:,94),Q(:,38),MB,1_intkind1,wf(:,307))
  call counter_ZQ_A(gZd,wf(:,95),wf(:,-4),wf(:,308))
  call prop_A_Q(wf(:,99),Q(:,38),MB,1_intkind1,wf(:,309))
  call counter_VQ_A_LR(EWctGbb,wf(:,79),wf(:,-4),wf(:,310))
  call counter_QS_A(ctStb,wf(:,-4),wf(:,118),wf(:,311))
  call counter_WQ_A(wf(:,121),wf(:,-4),wf(:,312))
  call vert_QS_A(gH,wf(:,0),wf(:,237),wf(:,313))
  call prop_Q_A(wf(:,313),Q(:,49),MT,1_intkind1,wf(:,314))
  call vert_QS_A(gX,wf(:,0),wf(:,239),wf(:,315))
  call prop_Q_A(wf(:,315),Q(:,49),MT,1_intkind1,wf(:,316))
  call vert_VQ_A(wf(:,230),wf(:,0),wf(:,317))
  call prop_Q_A(wf(:,317),Q(:,49),MT,1_intkind1,wf(:,318))
  call vert_ZQ_A(gZu,wf(:,241),wf(:,0),wf(:,319))
  call prop_Q_A(wf(:,319),Q(:,49),MT,1_intkind1,wf(:,320))
  call vert_VQ_A(wf(:,231),wf(:,0),wf(:,321))
  call prop_Q_A(wf(:,321),Q(:,49),MT,1_intkind1,wf(:,322))
  call counter_AV_Q(wf(:,-3),wf(:,80),wf(:,323))
  call prop_Q_A(wf(:,125),Q(:,49),MT,1_intkind1,wf(:,324))
  call prop_Q_A(wf(:,127),Q(:,49),MT,1_intkind1,wf(:,325))
  call counter_SA_Q(ctStb,wf(:,118),wf(:,-3),wf(:,326))
  call counter_AW_Q(wf(:,-3),wf(:,121),wf(:,327))
  call counter_SA_Q(gH,wf(:,89),wf(:,-3),wf(:,328))
  call counter_SA_Q(gX,wf(:,93),wf(:,-3),wf(:,329))
  call counter_AZ_Q(gZu,wf(:,-3),wf(:,98),wf(:,330))
  call counter_AV_Q_LR(EWctGtt,wf(:,-3),wf(:,80),wf(:,331))
  call vert_QS_A(gPbt,wf(:,0),wf(:,268),wf(:,332))
  call prop_Q_A(wf(:,332),Q(:,25),MB,1_intkind1,wf(:,333))
  call vert_WQ_A(wf(:,270),wf(:,0),wf(:,334))
  call prop_Q_A(wf(:,334),Q(:,25),MB,1_intkind1,wf(:,335))
  call counter_SA_Q(ctSbt,wf(:,145),wf(:,-5),wf(:,336))
  call counter_AW_Q(wf(:,-5),wf(:,149),wf(:,337))
  call vert_AV_Q(wf(:,-2),wf(:,230),wf(:,338))
  call vert_SA_Q(gH,wf(:,237),wf(:,-2),wf(:,339))
  call vert_SA_Q(gX,wf(:,239),wf(:,-2),wf(:,340))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,241),wf(:,341))
  call vert_AV_Q(wf(:,-2),wf(:,231),wf(:,342))
  call counter_SA_Q(ctStb,wf(:,45),wf(:,-2),wf(:,343))
  call counter_AW_Q(wf(:,-2),wf(:,49),wf(:,344))
  call counter_AV_Q(wf(:,-2),wf(:,79),wf(:,345))
  call counter_AV_Q(wf(:,-2),wf(:,3),wf(:,346))
  call counter_SA_Q(gH,wf(:,60),wf(:,-2),wf(:,347))
  call counter_SA_Q(gX,wf(:,62),wf(:,-2),wf(:,348))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,66),wf(:,349))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,3),wf(:,350))
  call counter_SA_Q(gH,wf(:,82),wf(:,-2),wf(:,351))
  call counter_SA_Q(gX,wf(:,86),wf(:,-2),wf(:,352))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,95),wf(:,353))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,79),wf(:,354))
  call counter_AQ_S(ctStb,wf(:,-2),wf(:,-4),wf(:,355))
  call vert_SA_Q(gPbt,wf(:,355),wf(:,-5),wf(:,356))
  call counter_QA_W(wf(:,-4),wf(:,-2),wf(:,357))
  call vert_AW_Q(wf(:,-5),wf(:,357),wf(:,358))
  call vert_QS_A(gPbt,wf(:,-1),wf(:,355),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,22),MB,1_intkind1,wf(:,360))
  call vert_WQ_A(wf(:,357),wf(:,-1),wf(:,361))
  call prop_Q_A(wf(:,361),Q(:,22),MB,1_intkind1,wf(:,362))
  call counter_AV_Q(wf(:,-2),wf(:,2),wf(:,363))
  call counter_SA_Q(ctStb,wf(:,118),wf(:,-2),wf(:,364))
  call counter_AW_Q(wf(:,-2),wf(:,121),wf(:,365))
  call counter_SA_Q(gH,wf(:,12),wf(:,-2),wf(:,366))
  call counter_SA_Q(gX,wf(:,16),wf(:,-2),wf(:,367))
  call counter_AZ_Q(gZu,wf(:,-2),wf(:,21),wf(:,368))
  call counter_AV_Q_LR(EWctGtt,wf(:,-2),wf(:,2),wf(:,369))
  call vert_QS_A(gPbt,wf(:,0),wf(:,355),wf(:,370))
  call prop_Q_A(wf(:,370),Q(:,21),MB,1_intkind1,wf(:,371))
  call vert_WQ_A(wf(:,357),wf(:,0),wf(:,372))
  call prop_Q_A(wf(:,372),Q(:,21),MB,1_intkind1,wf(:,373))
  call counter_QS_A(ctSbt,wf(:,-1),wf(:,35),wf(:,374))
  call counter_WQ_A(wf(:,39),wf(:,-1),wf(:,375))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,376))
  call prop_A_Q(wf(:,37),Q(:,56),MT,1_intkind1,wf(:,377))
  call prop_A_Q(wf(:,40),Q(:,56),MT,1_intkind1,wf(:,378))
  call counter_VQ_A(wf(:,3),wf(:,-1),wf(:,379))
  call prop_A_Q(wf(:,69),Q(:,13),MT,1_intkind1,wf(:,380))
  call prop_A_Q(wf(:,71),Q(:,13),MT,1_intkind1,wf(:,381))
  call counter_QS_A(gH,wf(:,-1),wf(:,60),wf(:,382))
  call counter_QS_A(gX,wf(:,-1),wf(:,62),wf(:,383))
  call prop_A_Q(wf(:,76),Q(:,13),MT,1_intkind1,wf(:,384))
  call counter_ZQ_A(gZu,wf(:,66),wf(:,-1),wf(:,385))
  call counter_VQ_A_LR(EWctGtt,wf(:,3),wf(:,-1),wf(:,386))
  call counter_QS_A(gH,wf(:,-1),wf(:,5),wf(:,387))
  call prop_A_Q(wf(:,56),Q(:,56),MT,1_intkind1,wf(:,388))
  call counter_QS_A(gX,wf(:,-1),wf(:,9),wf(:,389))
  call prop_A_Q(wf(:,61),Q(:,56),MT,1_intkind1,wf(:,390))
  call prop_A_Q(wf(:,63),Q(:,56),MT,1_intkind1,wf(:,391))
  call counter_ZQ_A(gZu,wf(:,18),wf(:,-1),wf(:,392))
  call prop_A_Q(wf(:,67),Q(:,56),MT,1_intkind1,wf(:,393))
  call counter_VQ_A_LR(EWctGtt,wf(:,1),wf(:,-1),wf(:,394))
  call counter_AQ_S(ctSbt,wf(:,-5),wf(:,-1),wf(:,395))
  call vert_QS_A(gPtb,wf(:,-4),wf(:,395),wf(:,396))
  call counter_QA_W(wf(:,-1),wf(:,-5),wf(:,397))
  call vert_WQ_A(wf(:,397),wf(:,-4),wf(:,398))
  call vert_SA_Q(gPtb,wf(:,395),wf(:,-3),wf(:,399))
  call prop_A_Q(wf(:,399),Q(:,42),MB,1_intkind1,wf(:,400))
  call vert_AW_Q(wf(:,-3),wf(:,397),wf(:,401))
  call prop_A_Q(wf(:,401),Q(:,42),MB,1_intkind1,wf(:,402))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,403))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,403),Q(:,10),wf(:,404))
  call counter_QA_V_LR(EWctGtt,wf(:,-1),wf(:,-3),wf(:,405))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,405),Q(:,10),wf(:,406))
  call vert_AV_Q(wf(:,-5),wf(:,403),wf(:,407))
  call counter_AQ_S(gH,wf(:,-3),wf(:,-1),wf(:,408))
  call vert_SA_Q(gH,wf(:,408),wf(:,-5),wf(:,409))
  call counter_AQ_S(gX,wf(:,-3),wf(:,-1),wf(:,410))
  call vert_SA_Q(gX,wf(:,410),wf(:,-5),wf(:,411))
  call counter_QA_Z(gZu,wf(:,-1),wf(:,-3),wf(:,412))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,412),wf(:,413))
  call vert_AV_Q(wf(:,-5),wf(:,405),wf(:,414))
  call vert_VQ_A(wf(:,403),wf(:,-4),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,26),MB,1_intkind1,wf(:,416))
  call vert_QS_A(gH,wf(:,-4),wf(:,408),wf(:,417))
  call prop_Q_A(wf(:,417),Q(:,26),MB,1_intkind1,wf(:,418))
  call vert_QS_A(gX,wf(:,-4),wf(:,410),wf(:,419))
  call prop_Q_A(wf(:,419),Q(:,26),MB,1_intkind1,wf(:,420))
  call vert_ZQ_A(gZd,wf(:,412),wf(:,-4),wf(:,421))
  call prop_Q_A(wf(:,421),Q(:,26),MB,1_intkind1,wf(:,422))
  call vert_VQ_A(wf(:,405),wf(:,-4),wf(:,423))
  call prop_Q_A(wf(:,423),Q(:,26),MB,1_intkind1,wf(:,424))
  call counter_QS_A(ctSbt,wf(:,-1),wf(:,145),wf(:,425))
  call counter_WQ_A(wf(:,149),wf(:,-1),wf(:,426))
  call counter_VQ_A(wf(:,79),wf(:,-1),wf(:,427))
  call prop_A_Q(wf(:,147),Q(:,52),MT,1_intkind1,wf(:,428))
  call prop_A_Q(wf(:,150),Q(:,52),MT,1_intkind1,wf(:,429))
  call prop_A_Q(wf(:,171),Q(:,13),MT,1_intkind1,wf(:,430))
  call prop_A_Q(wf(:,172),Q(:,13),MT,1_intkind1,wf(:,431))
  call prop_A_Q(wf(:,173),Q(:,13),MT,1_intkind1,wf(:,432))
  call counter_QS_A(gH,wf(:,-1),wf(:,82),wf(:,433))
  call prop_A_Q(wf(:,162),Q(:,52),MT,1_intkind1,wf(:,434))
  call counter_QS_A(gX,wf(:,-1),wf(:,86),wf(:,435))
  call prop_A_Q(wf(:,166),Q(:,52),MT,1_intkind1,wf(:,436))
  call prop_A_Q(wf(:,167),Q(:,52),MT,1_intkind1,wf(:,437))
  call counter_ZQ_A(gZu,wf(:,95),wf(:,-1),wf(:,438))
  call prop_A_Q(wf(:,170),Q(:,52),MT,1_intkind1,wf(:,439))
  call counter_VQ_A_LR(EWctGtt,wf(:,79),wf(:,-1),wf(:,440))
  call vert_SA_Q(gPtb,wf(:,395),wf(:,-2),wf(:,441))
  call prop_A_Q(wf(:,441),Q(:,38),MB,1_intkind1,wf(:,442))
  call vert_AW_Q(wf(:,-2),wf(:,397),wf(:,443))
  call prop_A_Q(wf(:,443),Q(:,38),MB,1_intkind1,wf(:,444))
  call vert_VQ_A(wf(:,403),wf(:,0),wf(:,445))
  call prop_Q_A(wf(:,445),Q(:,11),MT,1_intkind1,wf(:,446))
  call vert_AV_Q(wf(:,-2),wf(:,403),wf(:,447))
  call prop_A_Q(wf(:,447),Q(:,14),MT,1_intkind1,wf(:,448))
  call vert_SA_Q(gH,wf(:,408),wf(:,-2),wf(:,449))
  call vert_SA_Q(gX,wf(:,410),wf(:,-2),wf(:,450))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,412),wf(:,451))
  call vert_AV_Q(wf(:,-2),wf(:,405),wf(:,452))
  call vert_QS_A(gH,wf(:,0),wf(:,408),wf(:,453))
  call prop_Q_A(wf(:,453),Q(:,11),MT,1_intkind1,wf(:,454))
  call vert_QS_A(gX,wf(:,0),wf(:,410),wf(:,455))
  call prop_Q_A(wf(:,455),Q(:,11),MT,1_intkind1,wf(:,456))
  call vert_ZQ_A(gZu,wf(:,412),wf(:,0),wf(:,457))
  call prop_Q_A(wf(:,457),Q(:,11),MT,1_intkind1,wf(:,458))
  call vert_VQ_A(wf(:,405),wf(:,0),wf(:,459))
  call prop_Q_A(wf(:,459),Q(:,11),MT,1_intkind1,wf(:,460))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,461))
  call vert_UV_W(wf(:,461),Q(:,6),wf(:,79),Q(:,9),wf(:,462))
  call counter_QA_V_LR(EWctGtt,wf(:,-1),wf(:,-2),wf(:,463))
  call vert_UV_W(wf(:,463),Q(:,6),wf(:,79),Q(:,9),wf(:,464))
  call vert_AV_Q(wf(:,-5),wf(:,461),wf(:,465))
  call counter_AQ_S(gH,wf(:,-2),wf(:,-1),wf(:,466))
  call vert_SA_Q(gH,wf(:,466),wf(:,-5),wf(:,467))
  call counter_AQ_S(gX,wf(:,-2),wf(:,-1),wf(:,468))
  call vert_SA_Q(gX,wf(:,468),wf(:,-5),wf(:,469))
  call counter_QA_Z(gZu,wf(:,-1),wf(:,-2),wf(:,470))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,470),wf(:,471))
  call vert_AV_Q(wf(:,-5),wf(:,463),wf(:,472))
  call vert_VQ_A(wf(:,461),wf(:,-4),wf(:,473))
  call prop_Q_A(wf(:,473),Q(:,22),MB,1_intkind1,wf(:,474))
  call vert_QS_A(gH,wf(:,-4),wf(:,466),wf(:,475))
  call prop_Q_A(wf(:,475),Q(:,22),MB,1_intkind1,wf(:,476))
  call vert_QS_A(gX,wf(:,-4),wf(:,468),wf(:,477))
  call prop_Q_A(wf(:,477),Q(:,22),MB,1_intkind1,wf(:,478))
  call vert_ZQ_A(gZd,wf(:,470),wf(:,-4),wf(:,479))
  call prop_Q_A(wf(:,479),Q(:,22),MB,1_intkind1,wf(:,480))
  call vert_VQ_A(wf(:,463),wf(:,-4),wf(:,481))
  call prop_Q_A(wf(:,481),Q(:,22),MB,1_intkind1,wf(:,482))
  call vert_VQ_A(wf(:,461),wf(:,0),wf(:,483))
  call prop_Q_A(wf(:,483),Q(:,7),MT,1_intkind1,wf(:,484))
  call vert_AV_Q(wf(:,-3),wf(:,461),wf(:,485))
  call prop_A_Q(wf(:,485),Q(:,14),MT,1_intkind1,wf(:,486))
  call vert_SA_Q(gH,wf(:,466),wf(:,-3),wf(:,487))
  call vert_SA_Q(gX,wf(:,468),wf(:,-3),wf(:,488))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,470),wf(:,489))
  call vert_AV_Q(wf(:,-3),wf(:,463),wf(:,490))
  call vert_QS_A(gH,wf(:,0),wf(:,466),wf(:,491))
  call prop_Q_A(wf(:,491),Q(:,7),MT,1_intkind1,wf(:,492))
  call vert_QS_A(gX,wf(:,0),wf(:,468),wf(:,493))
  call prop_Q_A(wf(:,493),Q(:,7),MT,1_intkind1,wf(:,494))
  call vert_ZQ_A(gZu,wf(:,470),wf(:,0),wf(:,495))
  call prop_Q_A(wf(:,495),Q(:,7),MT,1_intkind1,wf(:,496))
  call vert_VQ_A(wf(:,463),wf(:,0),wf(:,497))
  call prop_Q_A(wf(:,497),Q(:,7),MT,1_intkind1,wf(:,498))
  call counter_VQ_A(wf(:,80),wf(:,0),wf(:,499))
  call counter_QS_A(ctSbt,wf(:,0),wf(:,35),wf(:,500))
  call counter_WQ_A(wf(:,39),wf(:,0),wf(:,501))
  call counter_QS_A(gH,wf(:,0),wf(:,89),wf(:,502))
  call counter_QS_A(gX,wf(:,0),wf(:,93),wf(:,503))
  call counter_ZQ_A(gZu,wf(:,98),wf(:,0),wf(:,504))
  call counter_VQ_A_LR(EWctGtt,wf(:,80),wf(:,0),wf(:,505))
  call counter_QS_A(gH,wf(:,0),wf(:,60),wf(:,506))
  call counter_QS_A(gX,wf(:,0),wf(:,62),wf(:,507))
  call counter_VQ_A(wf(:,3),wf(:,0),wf(:,508))
  call prop_A_Q(wf(:,139),Q(:,14),MT,1_intkind1,wf(:,509))
  call prop_A_Q(wf(:,141),Q(:,14),MT,1_intkind1,wf(:,510))
  call counter_ZQ_A(gZu,wf(:,66),wf(:,0),wf(:,511))
  call prop_A_Q(wf(:,144),Q(:,14),MT,1_intkind1,wf(:,512))
  call counter_VQ_A_LR(EWctGtt,wf(:,3),wf(:,0),wf(:,513))
  call counter_AQ_S(ctSbt,wf(:,-5),wf(:,0),wf(:,514))
  call vert_SA_Q(gPtb,wf(:,514),wf(:,-3),wf(:,515))
  call prop_A_Q(wf(:,515),Q(:,41),MB,1_intkind1,wf(:,516))
  call counter_QA_W(wf(:,0),wf(:,-5),wf(:,517))
  call vert_AW_Q(wf(:,-3),wf(:,517),wf(:,518))
  call prop_A_Q(wf(:,518),Q(:,41),MB,1_intkind1,wf(:,519))
  call vert_QS_A(gPtb,wf(:,-4),wf(:,514),wf(:,520))
  call vert_WQ_A(wf(:,517),wf(:,-4),wf(:,521))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,522))
  call vert_UV_W(wf(:,80),Q(:,6),wf(:,522),Q(:,9),wf(:,523))
  call counter_QA_V_LR(EWctGtt,wf(:,0),wf(:,-3),wf(:,524))
  call vert_UV_W(wf(:,80),Q(:,6),wf(:,524),Q(:,9),wf(:,525))
  call counter_AQ_S(gH,wf(:,-3),wf(:,0),wf(:,526))
  call vert_QS_A(gH,wf(:,-4),wf(:,526),wf(:,527))
  call prop_Q_A(wf(:,527),Q(:,25),MB,1_intkind1,wf(:,528))
  call counter_AQ_S(gX,wf(:,-3),wf(:,0),wf(:,529))
  call vert_QS_A(gX,wf(:,-4),wf(:,529),wf(:,530))
  call prop_Q_A(wf(:,530),Q(:,25),MB,1_intkind1,wf(:,531))
  call vert_VQ_A(wf(:,522),wf(:,-4),wf(:,532))
  call prop_Q_A(wf(:,532),Q(:,25),MB,1_intkind1,wf(:,533))
  call counter_QA_Z(gZu,wf(:,0),wf(:,-3),wf(:,534))
  call vert_ZQ_A(gZd,wf(:,534),wf(:,-4),wf(:,535))
  call prop_Q_A(wf(:,535),Q(:,25),MB,1_intkind1,wf(:,536))
  call vert_VQ_A(wf(:,524),wf(:,-4),wf(:,537))
  call prop_Q_A(wf(:,537),Q(:,25),MB,1_intkind1,wf(:,538))
  call vert_SA_Q(gH,wf(:,526),wf(:,-5),wf(:,539))
  call vert_SA_Q(gX,wf(:,529),wf(:,-5),wf(:,540))
  call vert_AV_Q(wf(:,-5),wf(:,522),wf(:,541))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,534),wf(:,542))
  call vert_AV_Q(wf(:,-5),wf(:,524),wf(:,543))
  call counter_VQ_A(wf(:,2),wf(:,0),wf(:,544))
  call counter_QS_A(ctSbt,wf(:,0),wf(:,145),wf(:,545))
  call counter_WQ_A(wf(:,149),wf(:,0),wf(:,546))
  call counter_QS_A(gH,wf(:,0),wf(:,12),wf(:,547))
  call counter_QS_A(gX,wf(:,0),wf(:,16),wf(:,548))
  call counter_ZQ_A(gZu,wf(:,21),wf(:,0),wf(:,549))
  call counter_VQ_A_LR(EWctGtt,wf(:,2),wf(:,0),wf(:,550))
  call prop_A_Q(wf(:,192),Q(:,14),MT,1_intkind1,wf(:,551))
  call prop_A_Q(wf(:,193),Q(:,14),MT,1_intkind1,wf(:,552))
  call prop_A_Q(wf(:,194),Q(:,14),MT,1_intkind1,wf(:,553))
  call vert_SA_Q(gPtb,wf(:,514),wf(:,-2),wf(:,554))
  call prop_A_Q(wf(:,554),Q(:,37),MB,1_intkind1,wf(:,555))
  call vert_AW_Q(wf(:,-2),wf(:,517),wf(:,556))
  call prop_A_Q(wf(:,556),Q(:,37),MB,1_intkind1,wf(:,557))
  call vert_VQ_A(wf(:,522),wf(:,-1),wf(:,558))
  call prop_Q_A(wf(:,558),Q(:,11),MT,1_intkind1,wf(:,559))
  call vert_AV_Q(wf(:,-2),wf(:,522),wf(:,560))
  call prop_A_Q(wf(:,560),Q(:,13),MT,1_intkind1,wf(:,561))
  call vert_QS_A(gH,wf(:,-1),wf(:,526),wf(:,562))
  call prop_Q_A(wf(:,562),Q(:,11),MT,1_intkind1,wf(:,563))
  call vert_QS_A(gX,wf(:,-1),wf(:,529),wf(:,564))
  call prop_Q_A(wf(:,564),Q(:,11),MT,1_intkind1,wf(:,565))
  call vert_ZQ_A(gZu,wf(:,534),wf(:,-1),wf(:,566))
  call prop_Q_A(wf(:,566),Q(:,11),MT,1_intkind1,wf(:,567))
  call vert_VQ_A(wf(:,524),wf(:,-1),wf(:,568))
  call prop_Q_A(wf(:,568),Q(:,11),MT,1_intkind1,wf(:,569))
  call vert_SA_Q(gH,wf(:,526),wf(:,-2),wf(:,570))
  call vert_SA_Q(gX,wf(:,529),wf(:,-2),wf(:,571))
  call vert_AZ_Q(gZu,wf(:,-2),wf(:,534),wf(:,572))
  call vert_AV_Q(wf(:,-2),wf(:,524),wf(:,573))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,574))
  call vert_UV_W(wf(:,574),Q(:,5),wf(:,2),Q(:,10),wf(:,575))
  call counter_QA_V_LR(EWctGtt,wf(:,0),wf(:,-2),wf(:,576))
  call vert_UV_W(wf(:,576),Q(:,5),wf(:,2),Q(:,10),wf(:,577))
  call counter_AQ_S(gH,wf(:,-2),wf(:,0),wf(:,578))
  call vert_QS_A(gH,wf(:,-4),wf(:,578),wf(:,579))
  call prop_Q_A(wf(:,579),Q(:,21),MB,1_intkind1,wf(:,580))
  call counter_AQ_S(gX,wf(:,-2),wf(:,0),wf(:,581))
  call vert_QS_A(gX,wf(:,-4),wf(:,581),wf(:,582))
  call prop_Q_A(wf(:,582),Q(:,21),MB,1_intkind1,wf(:,583))
  call vert_VQ_A(wf(:,574),wf(:,-4),wf(:,584))
  call prop_Q_A(wf(:,584),Q(:,21),MB,1_intkind1,wf(:,585))
  call counter_QA_Z(gZu,wf(:,0),wf(:,-2),wf(:,586))
  call vert_ZQ_A(gZd,wf(:,586),wf(:,-4),wf(:,587))
  call prop_Q_A(wf(:,587),Q(:,21),MB,1_intkind1,wf(:,588))
  call vert_VQ_A(wf(:,576),wf(:,-4),wf(:,589))
  call prop_Q_A(wf(:,589),Q(:,21),MB,1_intkind1,wf(:,590))
  call vert_SA_Q(gH,wf(:,578),wf(:,-5),wf(:,591))
  call vert_SA_Q(gX,wf(:,581),wf(:,-5),wf(:,592))
  call vert_AV_Q(wf(:,-5),wf(:,574),wf(:,593))
  call vert_AZ_Q(gZd,wf(:,-5),wf(:,586),wf(:,594))
  call vert_AV_Q(wf(:,-5),wf(:,576),wf(:,595))
  call vert_VQ_A(wf(:,574),wf(:,-1),wf(:,596))
  call prop_Q_A(wf(:,596),Q(:,7),MT,1_intkind1,wf(:,597))
  call vert_AV_Q(wf(:,-3),wf(:,574),wf(:,598))
  call prop_A_Q(wf(:,598),Q(:,13),MT,1_intkind1,wf(:,599))
  call vert_QS_A(gH,wf(:,-1),wf(:,578),wf(:,600))
  call prop_Q_A(wf(:,600),Q(:,7),MT,1_intkind1,wf(:,601))
  call vert_QS_A(gX,wf(:,-1),wf(:,581),wf(:,602))
  call prop_Q_A(wf(:,602),Q(:,7),MT,1_intkind1,wf(:,603))
  call vert_ZQ_A(gZu,wf(:,586),wf(:,-1),wf(:,604))
  call prop_Q_A(wf(:,604),Q(:,7),MT,1_intkind1,wf(:,605))
  call vert_VQ_A(wf(:,576),wf(:,-1),wf(:,606))
  call prop_Q_A(wf(:,606),Q(:,7),MT,1_intkind1,wf(:,607))
  call vert_SA_Q(gH,wf(:,578),wf(:,-3),wf(:,608))
  call vert_SA_Q(gX,wf(:,581),wf(:,-3),wf(:,609))
  call vert_AZ_Q(gZu,wf(:,-3),wf(:,586),wf(:,610))
  call vert_AV_Q(wf(:,-3),wf(:,576),wf(:,611))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,3),Q(:,48),wf(:,612))
  call counter_V_V(ctGG,21,wf(:,1),Q(:,5),wf(:,613))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,3),Q(:,48),wf(:,614))
  call counter_V_V(ctGG,21,wf(:,2),Q(:,10),wf(:,615))
  call counter_V_V(ctGG,21,wf(:,3),Q(:,48),wf(:,616))
  call vert_VQ_A(wf(:,613),wf(:,-4),wf(:,617))
  call vert_AV_Q(wf(:,-5),wf(:,613),wf(:,618))
  call vert_VQ_A(wf(:,615),wf(:,-4),wf(:,619))
  call vert_AV_Q(wf(:,-5),wf(:,615),wf(:,620))
  call counter_Q_A(ctbb,5,wf(:,8),Q(:,21),wf(:,621))
  call counter_Q_A(ctbb,5,wf(:,11),Q(:,21),wf(:,622))
  call counter_Q_A(ctbb,5,wf(:,15),Q(:,21),wf(:,623))
  call counter_Q_A(ctbb,5,wf(:,20),Q(:,21),wf(:,624))
  call counter_Q_A_LR(EWctbb,wf(:,15),Q(:,21),wf(:,625))
  call counter_Q_A(ctbb,5,wf(:,25),Q(:,26),wf(:,626))
  call counter_Q_A(ctbb,5,wf(:,29),Q(:,26),wf(:,627))
  call counter_Q_A(ctbb,5,wf(:,31),Q(:,26),wf(:,628))
  call counter_Q_A(ctbb,5,wf(:,34),Q(:,26),wf(:,629))
  call counter_Q_A_LR(EWctbb,wf(:,25),Q(:,26),wf(:,630))
  call vert_VQ_A(wf(:,613),wf(:,-1),wf(:,631))
  call counter_Q_A(cttt,6,wf(:,38),Q(:,7),wf(:,632))
  call counter_Q_A(ctbb,5,wf(:,42),Q(:,26),wf(:,633))
  call counter_Q_A(ctbb,5,wf(:,44),Q(:,26),wf(:,634))
  call vert_AV_Q(wf(:,-3),wf(:,613),wf(:,635))
  call counter_A_Q(cttt,6,wf(:,48),Q(:,13),wf(:,636))
  call counter_A_Q(ctbb,5,wf(:,52),Q(:,42),wf(:,637))
  call counter_A_Q(ctbb,5,wf(:,54),Q(:,42),wf(:,638))
  call counter_Q_A(cttt,6,wf(:,57),Q(:,7),wf(:,639))
  call counter_Q_A(cttt,6,wf(:,59),Q(:,7),wf(:,640))
  call counter_Q_A(cttt,6,wf(:,65),Q(:,7),wf(:,641))
  call counter_Q_A_LR(EWcttt,wf(:,38),Q(:,7),wf(:,642))
  call counter_Q_A(cttt,6,wf(:,70),Q(:,50),wf(:,643))
  call counter_Q_A(cttt,6,wf(:,73),Q(:,50),wf(:,644))
  call counter_Q_A(cttt,6,wf(:,75),Q(:,50),wf(:,645))
  call counter_Q_A(cttt,6,wf(:,78),Q(:,50),wf(:,646))
  call counter_Q_A_LR(EWcttt,wf(:,70),Q(:,50),wf(:,647))
  call vert_VQ_A(wf(:,616),wf(:,-1),wf(:,648))
  call vert_AV_Q(wf(:,-3),wf(:,616),wf(:,649))
  call vert_UV_W(wf(:,80),Q(:,6),wf(:,3),Q(:,48),wf(:,650))
  call counter_V_V(ctGG,21,wf(:,79),Q(:,9),wf(:,651))
  call vert_UV_W(wf(:,79),Q(:,9),wf(:,3),Q(:,48),wf(:,652))
  call counter_V_V(ctGG,21,wf(:,80),Q(:,6),wf(:,653))
  call vert_VQ_A(wf(:,651),wf(:,-4),wf(:,654))
  call vert_AV_Q(wf(:,-5),wf(:,651),wf(:,655))
  call vert_VQ_A(wf(:,653),wf(:,-4),wf(:,656))
  call vert_AV_Q(wf(:,-5),wf(:,653),wf(:,657))
  call counter_Q_A(ctbb,5,wf(:,85),Q(:,25),wf(:,658))
  call counter_Q_A(ctbb,5,wf(:,88),Q(:,25),wf(:,659))
  call counter_Q_A(ctbb,5,wf(:,92),Q(:,25),wf(:,660))
  call counter_Q_A(ctbb,5,wf(:,97),Q(:,25),wf(:,661))
  call counter_Q_A_LR(EWctbb,wf(:,92),Q(:,25),wf(:,662))
  call counter_Q_A(ctbb,5,wf(:,102),Q(:,22),wf(:,663))
  call counter_Q_A(ctbb,5,wf(:,106),Q(:,22),wf(:,664))
  call counter_Q_A(ctbb,5,wf(:,108),Q(:,22),wf(:,665))
  call counter_Q_A(ctbb,5,wf(:,111),Q(:,22),wf(:,666))
  call counter_Q_A_LR(EWctbb,wf(:,102),Q(:,22),wf(:,667))
  call vert_VQ_A(wf(:,653),wf(:,0),wf(:,668))
  call counter_Q_A(cttt,6,wf(:,113),Q(:,7),wf(:,669))
  call counter_Q_A(ctbb,5,wf(:,115),Q(:,25),wf(:,670))
  call counter_Q_A(ctbb,5,wf(:,117),Q(:,25),wf(:,671))
  call vert_AV_Q(wf(:,-3),wf(:,653),wf(:,672))
  call counter_A_Q(ctbb,5,wf(:,120),Q(:,41),wf(:,673))
  call counter_A_Q(ctbb,5,wf(:,123),Q(:,41),wf(:,674))
  call counter_A_Q(cttt,6,wf(:,126),Q(:,14),wf(:,675))
  call counter_Q_A(cttt,6,wf(:,129),Q(:,7),wf(:,676))
  call counter_Q_A(cttt,6,wf(:,131),Q(:,7),wf(:,677))
  call counter_Q_A(cttt,6,wf(:,133),Q(:,7),wf(:,678))
  call counter_Q_A_LR(EWcttt,wf(:,113),Q(:,7),wf(:,679))
  call counter_Q_A(cttt,6,wf(:,135),Q(:,49),wf(:,680))
  call counter_Q_A(cttt,6,wf(:,137),Q(:,49),wf(:,681))
  call counter_Q_A(cttt,6,wf(:,140),Q(:,49),wf(:,682))
  call counter_Q_A(cttt,6,wf(:,143),Q(:,49),wf(:,683))
  call counter_Q_A_LR(EWcttt,wf(:,140),Q(:,49),wf(:,684))
  call vert_VQ_A(wf(:,616),wf(:,0),wf(:,685))
  call vert_VQ_A(wf(:,651),wf(:,-1),wf(:,686))
  call counter_Q_A(cttt,6,wf(:,148),Q(:,11),wf(:,687))
  call counter_Q_A(ctbb,5,wf(:,152),Q(:,22),wf(:,688))
  call counter_Q_A(ctbb,5,wf(:,154),Q(:,22),wf(:,689))
  call vert_AV_Q(wf(:,-2),wf(:,651),wf(:,690))
  call counter_A_Q(cttt,6,wf(:,156),Q(:,13),wf(:,691))
  call counter_A_Q(ctbb,5,wf(:,158),Q(:,38),wf(:,692))
  call counter_A_Q(ctbb,5,wf(:,160),Q(:,38),wf(:,693))
  call counter_Q_A(cttt,6,wf(:,163),Q(:,11),wf(:,694))
  call counter_Q_A(cttt,6,wf(:,165),Q(:,11),wf(:,695))
  call counter_Q_A(cttt,6,wf(:,169),Q(:,11),wf(:,696))
  call counter_Q_A_LR(EWcttt,wf(:,148),Q(:,11),wf(:,697))
  call vert_AV_Q(wf(:,-2),wf(:,616),wf(:,698))
  call vert_VQ_A(wf(:,615),wf(:,0),wf(:,699))
  call counter_Q_A(cttt,6,wf(:,175),Q(:,11),wf(:,700))
  call counter_Q_A(ctbb,5,wf(:,177),Q(:,21),wf(:,701))
  call counter_Q_A(ctbb,5,wf(:,179),Q(:,21),wf(:,702))
  call vert_AV_Q(wf(:,-2),wf(:,615),wf(:,703))
  call counter_A_Q(ctbb,5,wf(:,181),Q(:,37),wf(:,704))
  call counter_A_Q(ctbb,5,wf(:,183),Q(:,37),wf(:,705))
  call counter_A_Q(cttt,6,wf(:,185),Q(:,14),wf(:,706))
  call counter_Q_A(cttt,6,wf(:,187),Q(:,11),wf(:,707))
  call counter_Q_A(cttt,6,wf(:,189),Q(:,11),wf(:,708))
  call counter_Q_A(cttt,6,wf(:,191),Q(:,11),wf(:,709))
  call counter_Q_A_LR(EWcttt,wf(:,175),Q(:,11),wf(:,710))
  call vert_QA_V(wf(:,57),wf(:,-3),wf(:,711))
  call vert_QA_V(wf(:,59),wf(:,-3),wf(:,712))
  call vert_AQ_S(gH,wf(:,-3),wf(:,38),wf(:,713))
  call vert_AQ_S(gX,wf(:,-3),wf(:,38),wf(:,714))
  call vert_QA_V(wf(:,38),wf(:,-3),wf(:,715))
  call vert_QA_V(wf(:,65),wf(:,-3),wf(:,716))
  call vert_QA_Z(gZu,wf(:,38),wf(:,-3),wf(:,717))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,38),wf(:,718))
  call vert_QA_W(wf(:,38),wf(:,-5),wf(:,719))
  call vert_QA_V(wf(:,-1),wf(:,380),wf(:,720))
  call vert_QA_V(wf(:,-1),wf(:,381),wf(:,721))
  call vert_AQ_S(gH,wf(:,48),wf(:,-1),wf(:,722))
  call vert_AQ_S(gX,wf(:,48),wf(:,-1),wf(:,723))
  call vert_QA_V(wf(:,-1),wf(:,48),wf(:,724))
  call vert_QA_V(wf(:,-1),wf(:,384),wf(:,725))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,48),wf(:,726))
  call vert_AQ_S(gPtb,wf(:,48),wf(:,-4),wf(:,727))
  call vert_QA_W(wf(:,-4),wf(:,48),wf(:,728))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,15),wf(:,729))
  call vert_QA_W(wf(:,15),wf(:,-3),wf(:,730))
  call vert_QA_V(wf(:,8),wf(:,-5),wf(:,731))
  call vert_QA_V(wf(:,11),wf(:,-5),wf(:,732))
  call vert_AQ_S(gH,wf(:,-5),wf(:,15),wf(:,733))
  call vert_AQ_S(gX,wf(:,-5),wf(:,15),wf(:,734))
  call vert_QA_V(wf(:,15),wf(:,-5),wf(:,735))
  call vert_QA_V(wf(:,20),wf(:,-5),wf(:,736))
  call vert_QA_Z(gZd,wf(:,15),wf(:,-5),wf(:,737))
  call vert_AQ_S(gPbt,wf(:,216),wf(:,-1),wf(:,738))
  call vert_QA_W(wf(:,-1),wf(:,216),wf(:,739))
  call vert_QA_V(wf(:,-4),wf(:,213),wf(:,740))
  call vert_QA_V(wf(:,-4),wf(:,214),wf(:,741))
  call vert_AQ_S(gH,wf(:,216),wf(:,-4),wf(:,742))
  call vert_AQ_S(gX,wf(:,216),wf(:,-4),wf(:,743))
  call vert_QA_V(wf(:,-4),wf(:,216),wf(:,744))
  call vert_QA_V(wf(:,-4),wf(:,218),wf(:,745))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,216),wf(:,746))
  call vert_QA_V(wf(:,129),wf(:,-3),wf(:,747))
  call vert_QA_V(wf(:,131),wf(:,-3),wf(:,748))
  call vert_AQ_S(gH,wf(:,-3),wf(:,113),wf(:,749))
  call vert_AQ_S(gX,wf(:,-3),wf(:,113),wf(:,750))
  call vert_QA_V(wf(:,113),wf(:,-3),wf(:,751))
  call vert_QA_V(wf(:,133),wf(:,-3),wf(:,752))
  call vert_QA_Z(gZu,wf(:,113),wf(:,-3),wf(:,753))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,113),wf(:,754))
  call vert_QA_W(wf(:,113),wf(:,-5),wf(:,755))
  call vert_AQ_S(gH,wf(:,126),wf(:,0),wf(:,756))
  call vert_AQ_S(gX,wf(:,126),wf(:,0),wf(:,757))
  call vert_QA_V(wf(:,0),wf(:,509),wf(:,758))
  call vert_QA_V(wf(:,0),wf(:,510),wf(:,759))
  call vert_QA_V(wf(:,0),wf(:,126),wf(:,760))
  call vert_QA_Z(gZu,wf(:,0),wf(:,126),wf(:,761))
  call vert_QA_V(wf(:,0),wf(:,512),wf(:,762))
  call vert_AQ_S(gPbt,wf(:,303),wf(:,0),wf(:,763))
  call vert_QA_W(wf(:,0),wf(:,303),wf(:,764))
  call vert_AQ_S(gPtb,wf(:,126),wf(:,-4),wf(:,765))
  call vert_QA_W(wf(:,-4),wf(:,126),wf(:,766))
  call vert_AQ_S(gPtb,wf(:,-3),wf(:,102),wf(:,767))
  call vert_QA_W(wf(:,102),wf(:,-3),wf(:,768))
  call vert_QA_V(wf(:,106),wf(:,-5),wf(:,769))
  call vert_QA_V(wf(:,108),wf(:,-5),wf(:,770))
  call vert_AQ_S(gH,wf(:,-5),wf(:,102),wf(:,771))
  call vert_AQ_S(gX,wf(:,-5),wf(:,102),wf(:,772))
  call vert_QA_V(wf(:,102),wf(:,-5),wf(:,773))
  call vert_QA_V(wf(:,111),wf(:,-5),wf(:,774))
  call vert_QA_Z(gZd,wf(:,102),wf(:,-5),wf(:,775))
  call vert_QA_V(wf(:,-4),wf(:,306),wf(:,776))
  call vert_QA_V(wf(:,-4),wf(:,307),wf(:,777))
  call vert_AQ_S(gH,wf(:,303),wf(:,-4),wf(:,778))
  call vert_AQ_S(gX,wf(:,303),wf(:,-4),wf(:,779))
  call vert_QA_V(wf(:,-4),wf(:,303),wf(:,780))
  call vert_QA_V(wf(:,-4),wf(:,309),wf(:,781))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,303),wf(:,782))
  call vert_QA_V(wf(:,163),wf(:,-2),wf(:,783))
  call vert_QA_V(wf(:,165),wf(:,-2),wf(:,784))
  call vert_AQ_S(gH,wf(:,-2),wf(:,148),wf(:,785))
  call vert_AQ_S(gX,wf(:,-2),wf(:,148),wf(:,786))
  call vert_QA_V(wf(:,148),wf(:,-2),wf(:,787))
  call vert_QA_V(wf(:,169),wf(:,-2),wf(:,788))
  call vert_QA_Z(gZu,wf(:,148),wf(:,-2),wf(:,789))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,148),wf(:,790))
  call vert_QA_W(wf(:,148),wf(:,-5),wf(:,791))
  call vert_QA_V(wf(:,-1),wf(:,430),wf(:,792))
  call vert_QA_V(wf(:,-1),wf(:,431),wf(:,793))
  call vert_AQ_S(gH,wf(:,156),wf(:,-1),wf(:,794))
  call vert_AQ_S(gX,wf(:,156),wf(:,-1),wf(:,795))
  call vert_QA_V(wf(:,-1),wf(:,156),wf(:,796))
  call vert_QA_V(wf(:,-1),wf(:,432),wf(:,797))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,156),wf(:,798))
  call vert_AQ_S(gPtb,wf(:,156),wf(:,-4),wf(:,799))
  call vert_QA_W(wf(:,-4),wf(:,156),wf(:,800))
  call vert_AQ_S(gPtb,wf(:,-2),wf(:,92),wf(:,801))
  call vert_QA_W(wf(:,92),wf(:,-2),wf(:,802))
  call vert_QA_V(wf(:,85),wf(:,-5),wf(:,803))
  call vert_QA_V(wf(:,88),wf(:,-5),wf(:,804))
  call vert_AQ_S(gH,wf(:,-5),wf(:,92),wf(:,805))
  call vert_AQ_S(gX,wf(:,-5),wf(:,92),wf(:,806))
  call vert_QA_V(wf(:,92),wf(:,-5),wf(:,807))
  call vert_QA_V(wf(:,97),wf(:,-5),wf(:,808))
  call vert_QA_Z(gZd,wf(:,92),wf(:,-5),wf(:,809))
  call vert_AQ_S(gPbt,wf(:,297),wf(:,-1),wf(:,810))
  call vert_QA_W(wf(:,-1),wf(:,297),wf(:,811))
  call vert_QA_V(wf(:,-4),wf(:,294),wf(:,812))
  call vert_QA_V(wf(:,-4),wf(:,295),wf(:,813))
  call vert_AQ_S(gH,wf(:,297),wf(:,-4),wf(:,814))
  call vert_AQ_S(gX,wf(:,297),wf(:,-4),wf(:,815))
  call vert_QA_V(wf(:,-4),wf(:,297),wf(:,816))
  call vert_QA_V(wf(:,-4),wf(:,299),wf(:,817))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,297),wf(:,818))
  call vert_QA_V(wf(:,187),wf(:,-2),wf(:,819))
  call vert_QA_V(wf(:,189),wf(:,-2),wf(:,820))
  call vert_AQ_S(gH,wf(:,-2),wf(:,175),wf(:,821))
  call vert_AQ_S(gX,wf(:,-2),wf(:,175),wf(:,822))
  call vert_QA_V(wf(:,175),wf(:,-2),wf(:,823))
  call vert_QA_V(wf(:,191),wf(:,-2),wf(:,824))
  call vert_QA_Z(gZu,wf(:,175),wf(:,-2),wf(:,825))
  call vert_AQ_S(gPbt,wf(:,-5),wf(:,175),wf(:,826))
  call vert_QA_W(wf(:,175),wf(:,-5),wf(:,827))
  call vert_AQ_S(gH,wf(:,185),wf(:,0),wf(:,828))
  call vert_AQ_S(gX,wf(:,185),wf(:,0),wf(:,829))
  call vert_QA_V(wf(:,0),wf(:,551),wf(:,830))
  call vert_QA_V(wf(:,0),wf(:,552),wf(:,831))
  call vert_QA_V(wf(:,0),wf(:,185),wf(:,832))
  call vert_QA_Z(gZu,wf(:,0),wf(:,185),wf(:,833))
  call vert_QA_V(wf(:,0),wf(:,553),wf(:,834))
  call vert_AQ_S(gPbt,wf(:,222),wf(:,0),wf(:,835))
  call vert_QA_W(wf(:,0),wf(:,222),wf(:,836))
  call vert_AQ_S(gPtb,wf(:,185),wf(:,-4),wf(:,837))
  call vert_QA_W(wf(:,-4),wf(:,185),wf(:,838))
  call vert_AQ_S(gPtb,wf(:,-2),wf(:,25),wf(:,839))
  call vert_QA_W(wf(:,25),wf(:,-2),wf(:,840))
  call vert_QA_V(wf(:,29),wf(:,-5),wf(:,841))
  call vert_QA_V(wf(:,31),wf(:,-5),wf(:,842))
  call vert_AQ_S(gH,wf(:,-5),wf(:,25),wf(:,843))
  call vert_AQ_S(gX,wf(:,-5),wf(:,25),wf(:,844))
  call vert_QA_V(wf(:,25),wf(:,-5),wf(:,845))
  call vert_QA_V(wf(:,34),wf(:,-5),wf(:,846))
  call vert_QA_Z(gZd,wf(:,25),wf(:,-5),wf(:,847))
  call vert_QA_V(wf(:,-4),wf(:,225),wf(:,848))
  call vert_QA_V(wf(:,-4),wf(:,226),wf(:,849))
  call vert_AQ_S(gH,wf(:,222),wf(:,-4),wf(:,850))
  call vert_AQ_S(gX,wf(:,222),wf(:,-4),wf(:,851))
  call vert_QA_V(wf(:,-4),wf(:,222),wf(:,852))
  call vert_QA_V(wf(:,-4),wf(:,228),wf(:,853))
  call vert_QA_Z(gZd,wf(:,-4),wf(:,222),wf(:,854))
  call vert_QA_V(wf(:,177),wf(:,-5),wf(:,855))
  call vert_QA_V(wf(:,179),wf(:,-5),wf(:,856))
  call vert_QA_V(wf(:,0),wf(:,428),wf(:,857))
  call vert_QA_V(wf(:,0),wf(:,429),wf(:,858))
  call vert_QA_V(wf(:,152),wf(:,-5),wf(:,859))
  call vert_QA_V(wf(:,154),wf(:,-5),wf(:,860))
  call vert_QA_V(wf(:,-1),wf(:,428),wf(:,861))
  call vert_QA_V(wf(:,-1),wf(:,429),wf(:,862))
  call vert_QA_V(wf(:,115),wf(:,-5),wf(:,863))
  call vert_QA_V(wf(:,117),wf(:,-5),wf(:,864))
  call vert_QA_V(wf(:,0),wf(:,377),wf(:,865))
  call vert_QA_V(wf(:,0),wf(:,378),wf(:,866))
  call vert_QA_V(wf(:,42),wf(:,-5),wf(:,867))
  call vert_QA_V(wf(:,44),wf(:,-5),wf(:,868))
  call vert_QA_V(wf(:,-1),wf(:,377),wf(:,869))
  call vert_QA_V(wf(:,-1),wf(:,378),wf(:,870))
  call vert_QA_V(wf(:,-4),wf(:,181),wf(:,871))
  call vert_QA_V(wf(:,-4),wf(:,183),wf(:,872))
  call vert_QA_V(wf(:,-4),wf(:,120),wf(:,873))
  call vert_QA_V(wf(:,-4),wf(:,123),wf(:,874))
  call vert_QA_V(wf(:,324),wf(:,-2),wf(:,875))
  call vert_QA_V(wf(:,325),wf(:,-2),wf(:,876))
  call vert_QA_V(wf(:,324),wf(:,-3),wf(:,877))
  call vert_QA_V(wf(:,325),wf(:,-3),wf(:,878))
  call vert_QA_V(wf(:,-4),wf(:,158),wf(:,879))
  call vert_QA_V(wf(:,-4),wf(:,160),wf(:,880))
  call vert_QA_V(wf(:,-4),wf(:,52),wf(:,881))
  call vert_QA_V(wf(:,-4),wf(:,54),wf(:,882))
  call vert_QA_V(wf(:,257),wf(:,-2),wf(:,883))
  call vert_QA_V(wf(:,258),wf(:,-2),wf(:,884))
  call vert_QA_V(wf(:,257),wf(:,-3),wf(:,885))
  call vert_QA_V(wf(:,258),wf(:,-3),wf(:,886))
  call vert_QA_V(wf(:,135),wf(:,-2),wf(:,887))
  call vert_QA_V(wf(:,137),wf(:,-2),wf(:,888))
  call vert_AQ_S(gH,wf(:,-2),wf(:,140),wf(:,889))
  call vert_AQ_S(gX,wf(:,-2),wf(:,140),wf(:,890))
  call vert_QA_V(wf(:,140),wf(:,-2),wf(:,891))
  call vert_QA_V(wf(:,143),wf(:,-2),wf(:,892))
  call vert_QA_Z(gZu,wf(:,140),wf(:,-2),wf(:,893))
  call vert_AQ_S(gH,wf(:,434),wf(:,0),wf(:,894))
  call vert_AQ_S(gX,wf(:,434),wf(:,0),wf(:,895))
  call vert_QA_V(wf(:,0),wf(:,436),wf(:,896))
  call vert_QA_V(wf(:,0),wf(:,437),wf(:,897))
  call vert_QA_V(wf(:,0),wf(:,434),wf(:,898))
  call vert_QA_Z(gZu,wf(:,0),wf(:,434),wf(:,899))
  call vert_QA_V(wf(:,0),wf(:,439),wf(:,900))
  call vert_QA_V(wf(:,135),wf(:,-3),wf(:,901))
  call vert_QA_V(wf(:,137),wf(:,-3),wf(:,902))
  call vert_AQ_S(gH,wf(:,-3),wf(:,140),wf(:,903))
  call vert_AQ_S(gX,wf(:,-3),wf(:,140),wf(:,904))
  call vert_QA_V(wf(:,140),wf(:,-3),wf(:,905))
  call vert_QA_V(wf(:,143),wf(:,-3),wf(:,906))
  call vert_QA_Z(gZu,wf(:,140),wf(:,-3),wf(:,907))
  call vert_AQ_S(gH,wf(:,388),wf(:,0),wf(:,908))
  call vert_AQ_S(gX,wf(:,388),wf(:,0),wf(:,909))
  call vert_QA_V(wf(:,0),wf(:,390),wf(:,910))
  call vert_QA_V(wf(:,0),wf(:,391),wf(:,911))
  call vert_QA_V(wf(:,0),wf(:,388),wf(:,912))
  call vert_QA_Z(gZu,wf(:,0),wf(:,388),wf(:,913))
  call vert_QA_V(wf(:,0),wf(:,393),wf(:,914))
  call vert_QA_V(wf(:,73),wf(:,-2),wf(:,915))
  call vert_QA_V(wf(:,75),wf(:,-2),wf(:,916))
  call vert_AQ_S(gH,wf(:,-2),wf(:,70),wf(:,917))
  call vert_AQ_S(gX,wf(:,-2),wf(:,70),wf(:,918))
  call vert_QA_V(wf(:,70),wf(:,-2),wf(:,919))
  call vert_QA_V(wf(:,78),wf(:,-2),wf(:,920))
  call vert_QA_Z(gZu,wf(:,70),wf(:,-2),wf(:,921))
  call vert_AQ_S(gH,wf(:,434),wf(:,-1),wf(:,922))
  call vert_AQ_S(gX,wf(:,434),wf(:,-1),wf(:,923))
  call vert_QA_V(wf(:,-1),wf(:,436),wf(:,924))
  call vert_QA_V(wf(:,-1),wf(:,437),wf(:,925))
  call vert_QA_V(wf(:,-1),wf(:,434),wf(:,926))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,434),wf(:,927))
  call vert_QA_V(wf(:,-1),wf(:,439),wf(:,928))
  call vert_QA_V(wf(:,73),wf(:,-3),wf(:,929))
  call vert_QA_V(wf(:,75),wf(:,-3),wf(:,930))
  call vert_AQ_S(gH,wf(:,-3),wf(:,70),wf(:,931))
  call vert_AQ_S(gX,wf(:,-3),wf(:,70),wf(:,932))
  call vert_QA_V(wf(:,70),wf(:,-3),wf(:,933))
  call vert_QA_V(wf(:,78),wf(:,-3),wf(:,934))
  call vert_QA_Z(gZu,wf(:,70),wf(:,-3),wf(:,935))
  call vert_AQ_S(gH,wf(:,388),wf(:,-1),wf(:,936))
  call vert_AQ_S(gX,wf(:,388),wf(:,-1),wf(:,937))
  call vert_QA_V(wf(:,-1),wf(:,390),wf(:,938))
  call vert_QA_V(wf(:,-1),wf(:,391),wf(:,939))
  call vert_QA_V(wf(:,-1),wf(:,388),wf(:,940))
  call vert_QA_Z(gZu,wf(:,-1),wf(:,388),wf(:,941))
  call vert_QA_V(wf(:,-1),wf(:,393),wf(:,942))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,10))
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,5) - MH2)
  den(7) = 1 / (Q(5,21) - MB2)
  den(10) = 1 / (Q(5,5) - MZ2)
  den(13) = 1 / (Q(5,10) - MH2)
  den(16) = 1 / (Q(5,10) - MZ2)
  den(19) = 1 / (Q(5,26) - MB2)
  den(28) = 1 / (Q(5,24) - MW2)
  den(29) = 1 / (Q(5,7) - MT2)
  den(34) = 1 / (Q(5,34) - MW2)
  den(35) = 1 / (Q(5,13) - MT2)
  den(38) = 1 / (Q(5,42) - MB2)
  den(45) = 1 / (Q(5,48) - MH2)
  den(47) = 1 / (Q(5,48) - MZ2)
  den(50) = 1 / (Q(5,50) - MT2)
  den(59) = 1 / (Q(5,9))
  den(60) = 1 / (Q(5,6))
  den(63) = 1 / (Q(5,9) - MH2)
  den(64) = 1 / (Q(5,25) - MB2)
  den(67) = 1 / (Q(5,9) - MZ2)
  den(70) = 1 / (Q(5,6) - MH2)
  den(73) = 1 / (Q(5,6) - MZ2)
  den(76) = 1 / (Q(5,22) - MB2)
  den(89) = 1 / (Q(5,33) - MW2)
  den(90) = 1 / (Q(5,41) - MB2)
  den(93) = 1 / (Q(5,14) - MT2)
  den(103) = 1 / (Q(5,49) - MT2)
  den(112) = 1 / (Q(5,20) - MW2)
  den(113) = 1 / (Q(5,11) - MT2)
  den(120) = 1 / (Q(5,38) - MB2)
  den(139) = 1 / (Q(5,37) - MB2)
  den(219) = 1 / (Q(5,56) - MT2)
  den(238) = 1 / (Q(5,52) - MT2)
  den(285) = 1 / (Q(5,58))
  den(289) = 1 / (Q(5,53))
  den(292) = 1 / (Q(5,15))
  den(351) = 1 / (Q(5,54))
  den(355) = 1 / (Q(5,57))
  den(476) = 1 / (Q(5,15) - MH2)
  den(478) = 1 / (Q(5,15) - MZ2)
  den(481) = 1 / (Q(5,39) - MW2)
  den(488) = 1 / (Q(5,29) - MW2)
  den(493) = 1 / (Q(5,53) - MH2)
  den(495) = 1 / (Q(5,53) - MZ2)
  den(516) = 1 / (Q(5,30) - MW2)
  den(521) = 1 / (Q(5,54) - MH2)
  den(523) = 1 / (Q(5,54) - MZ2)
  den(536) = 1 / (Q(5,43) - MW2)
  den(547) = 1 / (Q(5,57) - MH2)
  den(549) = 1 / (Q(5,57) - MZ2)
  den(574) = 1 / (Q(5,58) - MH2)
  den(576) = 1 / (Q(5,58) - MZ2)

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(2)*den(8)
  den(11) = den(7)*den(10)
  den(12) = den(2)*den(11)
  den(14) = den(1)*den(7)
  den(15) = den(13)*den(14)
  den(17) = den(14)*den(16)
  den(18) = den(2)*den(14)
  den(20) = den(2)*den(19)
  den(21) = den(6)*den(20)
  den(22) = den(10)*den(20)
  den(23) = den(13)*den(19)
  den(24) = den(1)*den(23)
  den(25) = den(16)*den(19)
  den(26) = den(1)*den(25)
  den(27) = den(1)*den(20)
  den(30) = den(1)*den(29)
  den(31) = den(28)*den(30)
  den(32) = den(19)*den(28)
  den(33) = den(1)*den(32)
  den(36) = den(1)*den(35)
  den(37) = den(34)*den(36)
  den(39) = den(34)*den(38)
  den(40) = den(1)*den(39)
  den(41) = den(6)*den(29)
  den(42) = den(3)*den(41)
  den(43) = den(10)*den(29)
  den(44) = den(3)*den(43)
  den(46) = den(30)*den(45)
  den(48) = den(30)*den(47)
  den(49) = den(3)*den(30)
  den(51) = den(3)*den(50)
  den(52) = den(6)*den(51)
  den(53) = den(10)*den(51)
  den(54) = den(45)*den(50)
  den(55) = den(1)*den(54)
  den(56) = den(47)*den(50)
  den(57) = den(1)*den(56)
  den(58) = den(1)*den(51)
  den(61) = den(59)*den(60)
  den(62) = den(3)*den(61)
  den(65) = den(63)*den(64)
  den(66) = den(60)*den(65)
  den(68) = den(64)*den(67)
  den(69) = den(60)*den(68)
  den(71) = den(59)*den(64)
  den(72) = den(70)*den(71)
  den(74) = den(71)*den(73)
  den(75) = den(60)*den(71)
  den(77) = den(60)*den(76)
  den(78) = den(63)*den(77)
  den(79) = den(67)*den(77)
  den(80) = den(70)*den(76)
  den(81) = den(59)*den(80)
  den(82) = den(73)*den(76)
  den(83) = den(59)*den(82)
  den(84) = den(59)*den(77)
  den(85) = den(29)*den(60)
  den(86) = den(28)*den(85)
  den(87) = den(28)*den(64)
  den(88) = den(60)*den(87)
  den(91) = den(89)*den(90)
  den(92) = den(60)*den(91)
  den(94) = den(60)*den(93)
  den(95) = den(89)*den(94)
  den(96) = den(29)*den(70)
  den(97) = den(3)*den(96)
  den(98) = den(29)*den(73)
  den(99) = den(3)*den(98)
  den(100) = den(45)*den(85)
  den(101) = den(47)*den(85)
  den(102) = den(3)*den(85)
  den(104) = den(45)*den(103)
  den(105) = den(60)*den(104)
  den(106) = den(47)*den(103)
  den(107) = den(60)*den(106)
  den(108) = den(3)*den(103)
  den(109) = den(70)*den(108)
  den(110) = den(73)*den(108)
  den(111) = den(60)*den(108)
  den(114) = den(59)*den(113)
  den(115) = den(112)*den(114)
  den(116) = den(76)*den(112)
  den(117) = den(59)*den(116)
  den(118) = den(35)*den(59)
  den(119) = den(34)*den(118)
  den(121) = den(34)*den(120)
  den(122) = den(59)*den(121)
  den(123) = den(63)*den(113)
  den(124) = den(3)*den(123)
  den(125) = den(67)*den(113)
  den(126) = den(3)*den(125)
  den(127) = den(45)*den(114)
  den(128) = den(47)*den(114)
  den(129) = den(3)*den(114)
  den(130) = den(51)*den(63)
  den(131) = den(51)*den(67)
  den(132) = den(54)*den(59)
  den(133) = den(56)*den(59)
  den(134) = den(51)*den(59)
  den(135) = den(2)*den(113)
  den(136) = den(112)*den(135)
  den(137) = den(7)*den(112)
  den(138) = den(2)*den(137)
  den(140) = den(89)*den(139)
  den(141) = den(2)*den(140)
  den(142) = den(2)*den(93)
  den(143) = den(89)*den(142)
  den(144) = den(13)*den(113)
  den(145) = den(3)*den(144)
  den(146) = den(16)*den(113)
  den(147) = den(3)*den(146)
  den(148) = den(45)*den(135)
  den(149) = den(47)*den(135)
  den(150) = den(3)*den(135)
  den(151) = den(2)*den(104)
  den(152) = den(2)*den(106)
  den(153) = den(13)*den(108)
  den(154) = den(16)*den(108)
  den(155) = den(2)*den(108)
  den(156) = den(2)*den(6)
  den(157) = den(3)*den(156)
  den(158) = den(1)*den(13)
  den(159) = den(3)*den(158)
  den(160) = den(4)*den(45)
  den(161) = den(2)*den(10)
  den(162) = den(3)*den(161)
  den(163) = den(1)*den(16)
  den(164) = den(3)*den(163)
  den(165) = den(4)*den(47)
  den(166) = den(6)*den(139)
  den(167) = den(2)*den(166)
  den(168) = den(10)*den(139)
  den(169) = den(2)*den(168)
  den(170) = den(1)*den(139)
  den(171) = den(13)*den(170)
  den(172) = den(16)*den(170)
  den(173) = den(2)*den(170)
  den(174) = den(2)*den(38)
  den(175) = den(6)*den(174)
  den(176) = den(10)*den(174)
  den(177) = den(13)*den(38)
  den(178) = den(1)*den(177)
  den(179) = den(16)*den(38)
  den(180) = den(1)*den(179)
  den(181) = den(1)*den(174)
  den(182) = den(14)*den(34)
  den(183) = den(34)*den(50)
  den(184) = den(1)*den(183)
  den(185) = den(60)*den(63)
  den(186) = den(3)*den(185)
  den(187) = den(59)*den(70)
  den(188) = den(3)*den(187)
  den(189) = den(45)*den(61)
  den(190) = den(60)*den(67)
  den(191) = den(3)*den(190)
  den(192) = den(59)*den(73)
  den(193) = den(3)*den(192)
  den(194) = den(47)*den(61)
  den(195) = den(63)*den(90)
  den(196) = den(60)*den(195)
  den(197) = den(67)*den(90)
  den(198) = den(60)*den(197)
  den(199) = den(59)*den(90)
  den(200) = den(70)*den(199)
  den(201) = den(73)*den(199)
  den(202) = den(60)*den(199)
  den(203) = den(60)*den(120)
  den(204) = den(63)*den(203)
  den(205) = den(67)*den(203)
  den(206) = den(70)*den(120)
  den(207) = den(59)*den(206)
  den(208) = den(73)*den(120)
  den(209) = den(59)*den(208)
  den(210) = den(59)*den(203)
  den(211) = den(89)*den(103)
  den(212) = den(60)*den(211)
  den(213) = den(77)*den(89)
  den(214) = den(34)*den(71)
  den(215) = den(59)*den(183)
  den(216) = den(2)*den(211)
  den(217) = den(20)*den(89)
  den(218) = den(28)*den(170)
  den(220) = den(28)*den(219)
  den(221) = den(1)*den(220)
  den(222) = den(6)*den(35)
  den(223) = den(3)*den(222)
  den(224) = den(10)*den(35)
  den(225) = den(3)*den(224)
  den(226) = den(36)*den(45)
  den(227) = den(36)*den(47)
  den(228) = den(3)*den(36)
  den(229) = den(3)*den(219)
  den(230) = den(6)*den(229)
  den(231) = den(10)*den(229)
  den(232) = den(45)*den(219)
  den(233) = den(1)*den(232)
  den(234) = den(47)*den(219)
  den(235) = den(1)*den(234)
  den(236) = den(1)*den(229)
  den(237) = den(112)*den(199)
  den(239) = den(112)*den(238)
  den(240) = den(59)*den(239)
  den(241) = den(35)*den(63)
  den(242) = den(3)*den(241)
  den(243) = den(35)*den(67)
  den(244) = den(3)*den(243)
  den(245) = den(45)*den(118)
  den(246) = den(47)*den(118)
  den(247) = den(3)*den(118)
  den(248) = den(3)*den(238)
  den(249) = den(63)*den(248)
  den(250) = den(67)*den(248)
  den(251) = den(45)*den(238)
  den(252) = den(59)*den(251)
  den(253) = den(47)*den(238)
  den(254) = den(59)*den(253)
  den(255) = den(59)*den(248)
  den(256) = den(60)*den(220)
  den(257) = den(28)*den(203)
  den(258) = den(70)*den(229)
  den(259) = den(73)*den(229)
  den(260) = den(60)*den(232)
  den(261) = den(60)*den(234)
  den(262) = den(60)*den(229)
  den(263) = den(45)*den(94)
  den(264) = den(47)*den(94)
  den(265) = den(70)*den(93)
  den(266) = den(3)*den(265)
  den(267) = den(73)*den(93)
  den(268) = den(3)*den(267)
  den(269) = den(3)*den(94)
  den(270) = den(2)*den(239)
  den(271) = den(112)*den(174)
  den(272) = den(13)*den(248)
  den(273) = den(16)*den(248)
  den(274) = den(2)*den(251)
  den(275) = den(2)*den(253)
  den(276) = den(2)*den(248)
  den(277) = den(45)*den(142)
  den(278) = den(47)*den(142)
  den(279) = den(13)*den(93)
  den(280) = den(3)*den(279)
  den(281) = den(16)*den(93)
  den(282) = den(3)*den(281)
  den(283) = den(3)*den(142)
  den(284) = den(2)*den(3)
  den(286) = den(284)*den(285)
  den(287) = den(1)*den(286)
  den(288) = den(1)*den(3)
  den(290) = den(288)*den(289)
  den(291) = den(2)*den(290)
  den(293) = den(4)*den(292)
  den(294) = den(3)*den(293)
  den(295) = den(1)**2
  den(296) = den(177)*den(295)
  den(297) = den(179)*den(295)
  den(298) = den(174)*den(295)
  den(299) = den(23)*den(295)
  den(300) = den(25)*den(295)
  den(301) = den(20)*den(295)
  den(302) = den(2)**2
  den(303) = den(166)*den(302)
  den(304) = den(168)*den(302)
  den(305) = den(170)*den(302)
  den(306) = den(8)*den(302)
  den(307) = den(11)*den(302)
  den(308) = den(14)*den(302)
  den(309) = den(8)*den(174)
  den(310) = den(11)*den(174)
  den(311) = den(14)*den(177)
  den(312) = den(14)*den(179)
  den(313) = den(14)*den(174)
  den(314) = den(20)*den(166)
  den(315) = den(20)*den(168)
  den(316) = den(23)*den(170)
  den(317) = den(25)*den(170)
  den(318) = den(20)*den(170)
  den(319) = den(220)*den(295)
  den(320) = den(32)*den(295)
  den(321) = den(30)*den(220)
  den(322) = den(32)*den(170)
  den(323) = den(183)*den(295)
  den(324) = den(39)*den(295)
  den(325) = den(36)*den(183)
  den(326) = den(14)*den(39)
  den(327) = den(232)*den(295)
  den(328) = den(234)*den(295)
  den(329) = den(229)*den(295)
  den(330) = den(54)*den(295)
  den(331) = den(56)*den(295)
  den(332) = den(51)*den(295)
  den(333) = den(41)*den(229)
  den(334) = den(43)*den(229)
  den(335) = den(30)*den(232)
  den(336) = den(30)*den(234)
  den(337) = den(30)*den(229)
  den(338) = den(51)*den(222)
  den(339) = den(51)*den(224)
  den(340) = den(36)*den(54)
  den(341) = den(36)*den(56)
  den(342) = den(36)*den(51)
  den(343) = den(3)**2
  den(344) = den(222)*den(343)
  den(345) = den(224)*den(343)
  den(346) = den(36)*den(343)
  den(347) = den(41)*den(343)
  den(348) = den(43)*den(343)
  den(349) = den(30)*den(343)
  den(350) = den(3)*den(60)
  den(352) = den(350)*den(351)
  den(353) = den(59)*den(352)
  den(354) = den(3)*den(59)
  den(356) = den(354)*den(355)
  den(357) = den(60)*den(356)
  den(358) = den(61)*den(292)
  den(359) = den(3)*den(358)
  den(360) = den(59)**2
  den(361) = den(206)*den(360)
  den(362) = den(208)*den(360)
  den(363) = den(203)*den(360)
  den(364) = den(80)*den(360)
  den(365) = den(82)*den(360)
  den(366) = den(77)*den(360)
  den(367) = den(60)**2
  den(368) = den(195)*den(367)
  den(369) = den(197)*den(367)
  den(370) = den(199)*den(367)
  den(371) = den(65)*den(367)
  den(372) = den(68)*den(367)
  den(373) = den(71)*den(367)
  den(374) = den(65)*den(203)
  den(375) = den(68)*den(203)
  den(376) = den(71)*den(206)
  den(377) = den(71)*den(208)
  den(378) = den(71)*den(203)
  den(379) = den(77)*den(195)
  den(380) = den(77)*den(197)
  den(381) = den(80)*den(199)
  den(382) = den(82)*den(199)
  den(383) = den(77)*den(199)
  den(384) = den(220)*den(367)
  den(385) = den(85)*den(220)
  den(386) = den(87)*den(203)
  den(387) = den(87)*den(367)
  den(388) = den(211)*den(367)
  den(389) = den(91)*den(367)
  den(390) = den(77)*den(91)
  den(391) = den(94)*den(211)
  den(392) = den(232)*den(367)
  den(393) = den(234)*den(367)
  den(394) = den(229)*den(367)
  den(395) = den(96)*den(229)
  den(396) = den(98)*den(229)
  den(397) = den(85)*den(232)
  den(398) = den(85)*den(234)
  den(399) = den(85)*den(229)
  den(400) = den(94)*den(104)
  den(401) = den(94)*den(106)
  den(402) = den(108)*den(265)
  den(403) = den(108)*den(267)
  den(404) = den(94)*den(108)
  den(405) = den(265)*den(343)
  den(406) = den(267)*den(343)
  den(407) = den(94)*den(343)
  den(408) = den(104)*den(367)
  den(409) = den(106)*den(367)
  den(410) = den(108)*den(367)
  den(411) = den(96)*den(343)
  den(412) = den(98)*den(343)
  den(413) = den(85)*den(343)
  den(414) = den(239)*den(360)
  den(415) = den(116)*den(360)
  den(416) = den(114)*den(239)
  den(417) = den(116)*den(199)
  den(418) = den(183)*den(360)
  den(419) = den(121)*den(360)
  den(420) = den(118)*den(183)
  den(421) = den(71)*den(121)
  den(422) = den(251)*den(360)
  den(423) = den(253)*den(360)
  den(424) = den(248)*den(360)
  den(425) = den(54)*den(360)
  den(426) = den(56)*den(360)
  den(427) = den(51)*den(360)
  den(428) = den(123)*den(248)
  den(429) = den(125)*den(248)
  den(430) = den(114)*den(251)
  den(431) = den(114)*den(253)
  den(432) = den(114)*den(248)
  den(433) = den(51)*den(241)
  den(434) = den(51)*den(243)
  den(435) = den(54)*den(118)
  den(436) = den(56)*den(118)
  den(437) = den(51)*den(118)
  den(438) = den(241)*den(343)
  den(439) = den(243)*den(343)
  den(440) = den(118)*den(343)
  den(441) = den(123)*den(343)
  den(442) = den(125)*den(343)
  den(443) = den(114)*den(343)
  den(444) = den(239)*den(302)
  den(445) = den(135)*den(239)
  den(446) = den(137)*den(174)
  den(447) = den(137)*den(302)
  den(448) = den(211)*den(302)
  den(449) = den(140)*den(302)
  den(450) = den(20)*den(140)
  den(451) = den(142)*den(211)
  den(452) = den(251)*den(302)
  den(453) = den(253)*den(302)
  den(454) = den(248)*den(302)
  den(455) = den(144)*den(248)
  den(456) = den(146)*den(248)
  den(457) = den(135)*den(251)
  den(458) = den(135)*den(253)
  den(459) = den(135)*den(248)
  den(460) = den(104)*den(142)
  den(461) = den(106)*den(142)
  den(462) = den(108)*den(279)
  den(463) = den(108)*den(281)
  den(464) = den(108)*den(142)
  den(465) = den(279)*den(343)
  den(466) = den(281)*den(343)
  den(467) = den(142)*den(343)
  den(468) = den(104)*den(302)
  den(469) = den(106)*den(302)
  den(470) = den(108)*den(302)
  den(471) = den(144)*den(343)
  den(472) = den(146)*den(343)
  den(473) = den(135)*den(343)
  den(474) = den(41)*den(292)
  den(475) = den(43)*den(292)
  den(477) = den(30)*den(476)
  den(479) = den(30)*den(478)
  den(480) = den(30)*den(292)
  den(482) = den(30)*den(481)
  den(483) = den(222)*den(292)
  den(484) = den(224)*den(292)
  den(485) = den(36)*den(476)
  den(486) = den(36)*den(478)
  den(487) = den(36)*den(292)
  den(489) = den(36)*den(488)
  den(490) = den(14)*den(488)
  den(491) = den(8)*den(289)
  den(492) = den(11)*den(289)
  den(494) = den(14)*den(493)
  den(496) = den(14)*den(495)
  den(497) = den(14)*den(289)
  den(498) = den(170)*den(481)
  den(499) = den(166)*den(289)
  den(500) = den(168)*den(289)
  den(501) = den(170)*den(493)
  den(502) = den(170)*den(495)
  den(503) = den(170)*den(289)
  den(504) = den(96)*den(292)
  den(505) = den(98)*den(292)
  den(506) = den(85)*den(476)
  den(507) = den(85)*den(478)
  den(508) = den(85)*den(292)
  den(509) = den(85)*den(481)
  den(510) = den(94)*den(476)
  den(511) = den(94)*den(478)
  den(512) = den(265)*den(292)
  den(513) = den(267)*den(292)
  den(514) = den(94)*den(292)
  den(515) = den(203)*den(481)
  den(517) = den(94)*den(516)
  den(518) = den(77)*den(516)
  den(519) = den(80)*den(351)
  den(520) = den(82)*den(351)
  den(522) = den(77)*den(521)
  den(524) = den(77)*den(523)
  den(525) = den(77)*den(351)
  den(526) = den(206)*den(351)
  den(527) = den(208)*den(351)
  den(528) = den(203)*den(521)
  den(529) = den(203)*den(523)
  den(530) = den(203)*den(351)
  den(531) = den(123)*den(292)
  den(532) = den(125)*den(292)
  den(533) = den(114)*den(476)
  den(534) = den(114)*den(478)
  den(535) = den(114)*den(292)
  den(537) = den(114)*den(536)
  den(538) = den(241)*den(292)
  den(539) = den(243)*den(292)
  den(540) = den(118)*den(476)
  den(541) = den(118)*den(478)
  den(542) = den(118)*den(292)
  den(543) = den(118)*den(488)
  den(544) = den(71)*den(488)
  den(545) = den(65)*den(355)
  den(546) = den(68)*den(355)
  den(548) = den(71)*den(547)
  den(550) = den(71)*den(549)
  den(551) = den(71)*den(355)
  den(552) = den(199)*den(536)
  den(553) = den(195)*den(355)
  den(554) = den(197)*den(355)
  den(555) = den(199)*den(547)
  den(556) = den(199)*den(549)
  den(557) = den(199)*den(355)
  den(558) = den(144)*den(292)
  den(559) = den(146)*den(292)
  den(560) = den(135)*den(476)
  den(561) = den(135)*den(478)
  den(562) = den(135)*den(292)
  den(563) = den(135)*den(536)
  den(564) = den(142)*den(476)
  den(565) = den(142)*den(478)
  den(566) = den(279)*den(292)
  den(567) = den(281)*den(292)
  den(568) = den(142)*den(292)
  den(569) = den(174)*den(536)
  den(570) = den(142)*den(516)
  den(571) = den(20)*den(516)
  den(572) = den(23)*den(285)
  den(573) = den(25)*den(285)
  den(575) = den(20)*den(574)
  den(577) = den(20)*den(576)
  den(578) = den(20)*den(285)
  den(579) = den(177)*den(285)
  den(580) = den(179)*den(285)
  den(581) = den(174)*den(574)
  den(582) = den(174)*den(576)
  den(583) = den(174)*den(285)
  den(584) = den(137)*den(289)
  den(585) = den(239)*den(289)
  den(586) = den(116)*den(351)
  den(587) = den(239)*den(351)
  den(588) = den(87)*den(355)
  den(589) = den(220)*den(355)
  den(590) = den(32)*den(285)
  den(591) = den(220)*den(285)
  den(592) = den(140)*den(289)
  den(593) = den(91)*den(355)
  den(594) = den(211)*den(289)
  den(595) = den(211)*den(355)
  den(596) = den(121)*den(351)
  den(597) = den(39)*den(285)
  den(598) = den(183)*den(351)
  den(599) = den(183)*den(285)
  den(600) = den(104)*den(289)
  den(601) = den(106)*den(289)
  den(602) = den(108)*den(493)
  den(603) = den(108)*den(495)
  den(604) = den(108)*den(289)
  den(605) = den(248)*den(493)
  den(606) = den(248)*den(495)
  den(607) = den(251)*den(289)
  den(608) = den(253)*den(289)
  den(609) = den(248)*den(289)
  den(610) = den(104)*den(355)
  den(611) = den(106)*den(355)
  den(612) = den(108)*den(547)
  den(613) = den(108)*den(549)
  den(614) = den(108)*den(355)
  den(615) = den(229)*den(547)
  den(616) = den(229)*den(549)
  den(617) = den(232)*den(355)
  den(618) = den(234)*den(355)
  den(619) = den(229)*den(355)
  den(620) = den(54)*den(351)
  den(621) = den(56)*den(351)
  den(622) = den(51)*den(521)
  den(623) = den(51)*den(523)
  den(624) = den(51)*den(351)
  den(625) = den(248)*den(521)
  den(626) = den(248)*den(523)
  den(627) = den(251)*den(351)
  den(628) = den(253)*den(351)
  den(629) = den(248)*den(351)
  den(630) = den(54)*den(285)
  den(631) = den(56)*den(285)
  den(632) = den(51)*den(574)
  den(633) = den(51)*den(576)
  den(634) = den(51)*den(285)
  den(635) = den(229)*den(574)
  den(636) = den(229)*den(576)
  den(637) = den(232)*den(285)
  den(638) = den(234)*den(285)
  den(639) = den(229)*den(285)
  den(640) = den(2)*den(3)*den(6)
  den(641) = den(2)*den(3)*den(10)
  den(642) = den(1)*den(3)*den(13)
  den(643) = den(1)*den(3)*den(16)
  den(644) = den(1)*den(2)*den(45)
  den(645) = den(1)*den(2)*den(47)
  den(646) = den(1)*den(2)*den(3)
  den(647) = den(1)*den(28)
  den(648) = den(1)*den(34)
  den(649) = den(3)*den(6)
  den(650) = den(3)*den(10)
  den(651) = den(1)*den(45)
  den(652) = den(1)*den(47)
  den(653) = den(3)*den(60)*den(63)
  den(654) = den(3)*den(60)*den(67)
  den(655) = den(3)*den(59)*den(70)
  den(656) = den(3)*den(59)*den(73)
  den(657) = den(45)*den(59)*den(60)
  den(658) = den(47)*den(59)*den(60)
  den(659) = den(3)*den(59)*den(60)
  den(660) = den(28)*den(60)
  den(661) = den(60)*den(89)
  den(662) = den(3)*den(70)
  den(663) = den(3)*den(73)
  den(664) = den(45)*den(60)
  den(665) = den(47)*den(60)
  den(666) = den(59)*den(112)
  den(667) = den(34)*den(59)
  den(668) = den(3)*den(63)
  den(669) = den(3)*den(67)
  den(670) = den(45)*den(59)
  den(671) = den(47)*den(59)
  den(672) = den(2)*den(112)
  den(673) = den(2)*den(89)
  den(674) = den(3)*den(13)
  den(675) = den(3)*den(16)
  den(676) = den(2)*den(45)
  den(677) = den(2)*den(47)
  den(678) = den(1)*den(284)
  den(679) = den(2)*den(288)
  den(680) = den(59)*den(350)
  den(681) = den(60)*den(354)
  den(682) = den(2)*den(491)
  den(683) = den(2)*den(492)
  den(684) = den(2)*den(497)
  den(685) = den(2)*den(499)
  den(686) = den(2)*den(500)
  den(687) = den(2)*den(503)
  den(688) = den(1)*den(572)
  den(689) = den(1)*den(573)
  den(690) = den(1)*den(578)
  den(691) = den(1)*den(579)
  den(692) = den(1)*den(580)
  den(693) = den(1)*den(583)
  den(694) = den(1)*den(590)
  den(695) = den(1)*den(591)
  den(696) = den(1)*den(597)
  den(697) = den(1)*den(599)
  den(698) = den(3)*den(474)
  den(699) = den(3)*den(475)
  den(700) = den(3)*den(480)
  den(701) = den(3)*den(483)
  den(702) = den(3)*den(484)
  den(703) = den(3)*den(487)
  den(704) = den(1)*den(630)
  den(705) = den(1)*den(631)
  den(706) = den(1)*den(634)
  den(707) = den(1)*den(637)
  den(708) = den(1)*den(638)
  den(709) = den(1)*den(639)
  den(710) = den(60)*den(545)
  den(711) = den(60)*den(546)
  den(712) = den(60)*den(551)
  den(713) = den(60)*den(553)
  den(714) = den(60)*den(554)
  den(715) = den(60)*den(557)
  den(716) = den(59)*den(519)
  den(717) = den(59)*den(520)
  den(718) = den(59)*den(525)
  den(719) = den(59)*den(526)
  den(720) = den(59)*den(527)
  den(721) = den(59)*den(530)
  den(722) = den(60)*den(588)
  den(723) = den(60)*den(589)
  den(724) = den(60)*den(593)
  den(725) = den(60)*den(595)
  den(726) = den(3)*den(504)
  den(727) = den(3)*den(505)
  den(728) = den(3)*den(508)
  den(729) = den(60)*den(610)
  den(730) = den(60)*den(611)
  den(731) = den(60)*den(614)
  den(732) = den(3)*den(512)
  den(733) = den(3)*den(513)
  den(734) = den(3)*den(514)
  den(735) = den(60)*den(617)
  den(736) = den(60)*den(618)
  den(737) = den(60)*den(619)
  den(738) = den(59)*den(586)
  den(739) = den(59)*den(587)
  den(740) = den(59)*den(596)
  den(741) = den(59)*den(598)
  den(742) = den(3)*den(531)
  den(743) = den(3)*den(532)
  den(744) = den(3)*den(535)
  den(745) = den(3)*den(538)
  den(746) = den(3)*den(539)
  den(747) = den(3)*den(542)
  den(748) = den(59)*den(620)
  den(749) = den(59)*den(621)
  den(750) = den(59)*den(624)
  den(751) = den(59)*den(627)
  den(752) = den(59)*den(628)
  den(753) = den(59)*den(629)
  den(754) = den(2)*den(584)
  den(755) = den(2)*den(585)
  den(756) = den(2)*den(592)
  den(757) = den(2)*den(594)
  den(758) = den(3)*den(558)
  den(759) = den(3)*den(559)
  den(760) = den(3)*den(562)
  den(761) = den(2)*den(600)
  den(762) = den(2)*den(601)
  den(763) = den(2)*den(604)
  den(764) = den(3)*den(566)
  den(765) = den(3)*den(567)
  den(766) = den(3)*den(568)
  den(767) = den(2)*den(607)
  den(768) = den(2)*den(608)
  den(769) = den(2)*den(609)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(1086)

  A(1) = cont_VV(wf(:,3),wf(:,4)) * den(5)
  A(2) = cont_QA(wf(:,7),wf(:,8)) * den(9)
  A(3) = cont_QA(wf(:,7),wf(:,11)) * den(12)
  A(4) = cont_QA(wf(:,14),wf(:,15)) * den(15)
  A(5) = cont_QA(wf(:,15),wf(:,17)) * den(17)
  A(6) = cont_QA(wf(:,7),wf(:,15)) * den(18)
  A(7) = cont_QA(wf(:,7),wf(:,20)) * den(12)
  A(8) = cont_QA(wf(:,7),wf(:,15)) * den(18)
  A(9) = cont_QA(wf(:,15),wf(:,22)) * den(17)
  A(10) = cont_QA(wf(:,7),wf(:,15)) * den(18)
  A(11) = cont_QA(wf(:,24),wf(:,25)) * den(21)
  A(12) = cont_QA(wf(:,25),wf(:,26)) * den(22)
  A(13) = cont_QA(wf(:,28),wf(:,29)) * den(24)
  A(14) = cont_QA(wf(:,28),wf(:,31)) * den(26)
  A(15) = cont_QA(wf(:,25),wf(:,28)) * den(27)
  A(16) = cont_QA(wf(:,25),wf(:,32)) * den(22)
  A(17) = cont_QA(wf(:,25),wf(:,28)) * den(27)
  A(18) = cont_QA(wf(:,28),wf(:,34)) * den(26)
  A(19) = cont_QA(wf(:,25),wf(:,28)) * den(27)
  A(20) = cont_QA(wf(:,37),wf(:,38)) * den(31)
  A(21) = cont_QA(wf(:,38),wf(:,40)) * den(31)
  A(22) = cont_QA(wf(:,28),wf(:,42)) * den(33)
  A(23) = cont_QA(wf(:,28),wf(:,44)) * den(33)
  A(24) = cont_QA(wf(:,47),wf(:,48)) * den(37)
  A(25) = cont_QA(wf(:,48),wf(:,50)) * den(37)
  A(26) = cont_QA(wf(:,13),wf(:,52)) * den(40)
  A(27) = cont_QA(wf(:,13),wf(:,54)) * den(40)
  A(28) = cont_QA(wf(:,56),wf(:,57)) * den(42)
  A(29) = cont_QA(wf(:,56),wf(:,59)) * den(44)
  A(30) = cont_QA(wf(:,38),wf(:,61)) * den(46)
  A(31) = cont_QA(wf(:,38),wf(:,63)) * den(48)
  A(32) = cont_QA(wf(:,38),wf(:,56)) * den(49)
  A(33) = cont_QA(wf(:,56),wf(:,65)) * den(44)
  A(34) = cont_QA(wf(:,38),wf(:,56)) * den(49)
  A(35) = cont_QA(wf(:,38),wf(:,67)) * den(48)
  A(36) = cont_QA(wf(:,38),wf(:,56)) * den(49)
  A(37) = cont_QA(wf(:,69),wf(:,70)) * den(52)
  A(38) = cont_QA(wf(:,70),wf(:,71)) * den(53)
  A(39) = cont_QA(wf(:,46),wf(:,73)) * den(55)
  A(40) = cont_QA(wf(:,46),wf(:,75)) * den(57)
  A(41) = cont_QA(wf(:,46),wf(:,70)) * den(58)
  A(42) = cont_QA(wf(:,70),wf(:,76)) * den(53)
  A(43) = cont_QA(wf(:,46),wf(:,70)) * den(58)
  A(44) = cont_QA(wf(:,46),wf(:,78)) * den(57)
  A(45) = cont_QA(wf(:,46),wf(:,70)) * den(58)
  A(46) = cont_VV(wf(:,3),wf(:,81)) * den(62)
  A(47) = cont_QA(wf(:,84),wf(:,85)) * den(66)
  A(48) = cont_QA(wf(:,84),wf(:,88)) * den(69)
  A(49) = cont_QA(wf(:,91),wf(:,92)) * den(72)
  A(50) = cont_QA(wf(:,92),wf(:,94)) * den(74)
  A(51) = cont_QA(wf(:,84),wf(:,92)) * den(75)
  A(52) = cont_QA(wf(:,84),wf(:,97)) * den(69)
  A(53) = cont_QA(wf(:,84),wf(:,92)) * den(75)
  A(54) = cont_QA(wf(:,92),wf(:,99)) * den(74)
  A(55) = cont_QA(wf(:,84),wf(:,92)) * den(75)
  A(56) = cont_QA(wf(:,101),wf(:,102)) * den(78)
  A(57) = cont_QA(wf(:,102),wf(:,103)) * den(79)
  A(58) = cont_QA(wf(:,105),wf(:,106)) * den(81)
  A(59) = cont_QA(wf(:,105),wf(:,108)) * den(83)
  A(60) = cont_QA(wf(:,102),wf(:,105)) * den(84)
  A(61) = cont_QA(wf(:,102),wf(:,109)) * den(79)
  A(62) = cont_QA(wf(:,102),wf(:,105)) * den(84)
  A(63) = cont_QA(wf(:,105),wf(:,111)) * den(83)
  A(64) = cont_QA(wf(:,102),wf(:,105)) * den(84)
  A(65) = cont_QA(wf(:,37),wf(:,113)) * den(86)
  A(66) = cont_QA(wf(:,40),wf(:,113)) * den(86)
  A(67) = cont_QA(wf(:,84),wf(:,115)) * den(88)
  A(68) = cont_QA(wf(:,84),wf(:,117)) * den(88)
  A(69) = cont_QA(wf(:,100),wf(:,120)) * den(92)
  A(70) = cont_QA(wf(:,100),wf(:,123)) * den(92)
  A(71) = cont_QA(wf(:,125),wf(:,126)) * den(95)
  A(72) = cont_QA(wf(:,126),wf(:,127)) * den(95)
  A(73) = cont_QA(wf(:,56),wf(:,129)) * den(97)
  A(74) = cont_QA(wf(:,56),wf(:,131)) * den(99)
  A(75) = cont_QA(wf(:,61),wf(:,113)) * den(100)
  A(76) = cont_QA(wf(:,63),wf(:,113)) * den(101)
  A(77) = cont_QA(wf(:,56),wf(:,113)) * den(102)
  A(78) = cont_QA(wf(:,56),wf(:,133)) * den(99)
  A(79) = cont_QA(wf(:,56),wf(:,113)) * den(102)
  A(80) = cont_QA(wf(:,67),wf(:,113)) * den(101)
  A(81) = cont_QA(wf(:,56),wf(:,113)) * den(102)
  A(82) = cont_QA(wf(:,124),wf(:,135)) * den(105)
  A(83) = cont_QA(wf(:,124),wf(:,137)) * den(107)
  A(84) = cont_QA(wf(:,139),wf(:,140)) * den(109)
  A(85) = cont_QA(wf(:,140),wf(:,141)) * den(110)
  A(86) = cont_QA(wf(:,124),wf(:,140)) * den(111)
  A(87) = cont_QA(wf(:,124),wf(:,143)) * den(107)
  A(88) = cont_QA(wf(:,124),wf(:,140)) * den(111)
  A(89) = cont_QA(wf(:,140),wf(:,144)) * den(110)
  A(90) = cont_QA(wf(:,124),wf(:,140)) * den(111)
  A(91) = cont_QA(wf(:,147),wf(:,148)) * den(115)
  A(92) = cont_QA(wf(:,148),wf(:,150)) * den(115)
  A(93) = cont_QA(wf(:,105),wf(:,152)) * den(117)
  A(94) = cont_QA(wf(:,105),wf(:,154)) * den(117)
  A(95) = cont_QA(wf(:,47),wf(:,156)) * den(119)
  A(96) = cont_QA(wf(:,50),wf(:,156)) * den(119)
  A(97) = cont_QA(wf(:,90),wf(:,158)) * den(122)
  A(98) = cont_QA(wf(:,90),wf(:,160)) * den(122)
  A(99) = cont_QA(wf(:,162),wf(:,163)) * den(124)
  A(100) = cont_QA(wf(:,162),wf(:,165)) * den(126)
  A(101) = cont_QA(wf(:,148),wf(:,166)) * den(127)
  A(102) = cont_QA(wf(:,148),wf(:,167)) * den(128)
  A(103) = cont_QA(wf(:,148),wf(:,162)) * den(129)
  A(104) = cont_QA(wf(:,162),wf(:,169)) * den(126)
  A(105) = cont_QA(wf(:,148),wf(:,162)) * den(129)
  A(106) = cont_QA(wf(:,148),wf(:,170)) * den(128)
  A(107) = cont_QA(wf(:,148),wf(:,162)) * den(129)
  A(108) = cont_QA(wf(:,70),wf(:,171)) * den(130)
  A(109) = cont_QA(wf(:,70),wf(:,172)) * den(131)
  A(110) = cont_QA(wf(:,73),wf(:,155)) * den(132)
  A(111) = cont_QA(wf(:,75),wf(:,155)) * den(133)
  A(112) = cont_QA(wf(:,70),wf(:,155)) * den(134)
  A(113) = cont_QA(wf(:,70),wf(:,173)) * den(131)
  A(114) = cont_QA(wf(:,70),wf(:,155)) * den(134)
  A(115) = cont_QA(wf(:,78),wf(:,155)) * den(133)
  A(116) = cont_QA(wf(:,70),wf(:,155)) * den(134)
  A(117) = cont_QA(wf(:,147),wf(:,175)) * den(136)
  A(118) = cont_QA(wf(:,150),wf(:,175)) * den(136)
  A(119) = cont_QA(wf(:,7),wf(:,177)) * den(138)
  A(120) = cont_QA(wf(:,7),wf(:,179)) * den(138)
  A(121) = cont_QA(wf(:,23),wf(:,181)) * den(141)
  A(122) = cont_QA(wf(:,23),wf(:,183)) * den(141)
  A(123) = cont_QA(wf(:,125),wf(:,185)) * den(143)
  A(124) = cont_QA(wf(:,127),wf(:,185)) * den(143)
  A(125) = cont_QA(wf(:,162),wf(:,187)) * den(145)
  A(126) = cont_QA(wf(:,162),wf(:,189)) * den(147)
  A(127) = cont_QA(wf(:,166),wf(:,175)) * den(148)
  A(128) = cont_QA(wf(:,167),wf(:,175)) * den(149)
  A(129) = cont_QA(wf(:,162),wf(:,175)) * den(150)
  A(130) = cont_QA(wf(:,162),wf(:,191)) * den(147)
  A(131) = cont_QA(wf(:,162),wf(:,175)) * den(150)
  A(132) = cont_QA(wf(:,170),wf(:,175)) * den(149)
  A(133) = cont_QA(wf(:,162),wf(:,175)) * den(150)
  A(134) = cont_QA(wf(:,135),wf(:,184)) * den(151)
  A(135) = cont_QA(wf(:,137),wf(:,184)) * den(152)
  A(136) = cont_QA(wf(:,140),wf(:,192)) * den(153)
  A(137) = cont_QA(wf(:,140),wf(:,193)) * den(154)
  A(138) = cont_QA(wf(:,140),wf(:,184)) * den(155)
  A(139) = cont_QA(wf(:,143),wf(:,184)) * den(152)
  A(140) = cont_QA(wf(:,140),wf(:,184)) * den(155)
  A(141) = cont_QA(wf(:,140),wf(:,194)) * den(154)
  A(142) = cont_QA(wf(:,140),wf(:,184)) * den(155)

  A(143) = cont_VV(wf(:,3),wf(:,195)) * den(157)
  A(144) = cont_VV(wf(:,3),wf(:,196)) * den(159)
  A(145) = cont_SS(wf(:,60),wf(:,197)) * den(160)
  A(146) = cont_VV(wf(:,3),wf(:,198)) * den(162)
  A(147) = cont_VV(wf(:,3),wf(:,199)) * den(164)
  A(148) = cont_VV(wf(:,66),wf(:,200)) * den(165)
  A(149) = cont_VV(wf(:,3),wf(:,201)) * den(5)
  A(150) = cont_QA(wf(:,8),wf(:,202)) * den(9)
  A(151) = cont_QA(wf(:,11),wf(:,202)) * den(12)
  A(152) = cont_QA(wf(:,15),wf(:,203)) * den(15)
  A(153) = cont_QA(wf(:,15),wf(:,204)) * den(17)
  A(154) = cont_QA(wf(:,15),wf(:,202)) * den(18)
  A(155) = cont_QA(wf(:,20),wf(:,202)) * den(12)
  A(156) = cont_QA(wf(:,15),wf(:,202)) * den(18)
  A(157) = cont_QA(wf(:,15),wf(:,205)) * den(17)
  A(158) = cont_QA(wf(:,15),wf(:,202)) * den(18)
  A(159) = cont_QA(wf(:,15),wf(:,206)) * den(18)
  A(160) = cont_QA(wf(:,25),wf(:,207)) * den(21)
  A(161) = cont_QA(wf(:,25),wf(:,208)) * den(22)
  A(162) = cont_QA(wf(:,29),wf(:,209)) * den(24)
  A(163) = cont_QA(wf(:,31),wf(:,209)) * den(26)
  A(164) = cont_QA(wf(:,25),wf(:,209)) * den(27)
  A(165) = cont_QA(wf(:,25),wf(:,210)) * den(22)
  A(166) = cont_QA(wf(:,25),wf(:,209)) * den(27)
  A(167) = cont_QA(wf(:,34),wf(:,209)) * den(26)
  A(168) = cont_QA(wf(:,25),wf(:,209)) * den(27)
  A(169) = cont_QA(wf(:,25),wf(:,211)) * den(27)
  A(170) = cont_QA(wf(:,212),wf(:,213)) * den(167)
  A(171) = cont_QA(wf(:,212),wf(:,214)) * den(169)
  A(172) = cont_QA(wf(:,215),wf(:,216)) * den(171)
  A(173) = cont_QA(wf(:,216),wf(:,217)) * den(172)
  A(174) = cont_QA(wf(:,212),wf(:,216)) * den(173)
  A(175) = cont_QA(wf(:,212),wf(:,218)) * den(169)
  A(176) = cont_QA(wf(:,212),wf(:,216)) * den(173)
  A(177) = cont_QA(wf(:,216),wf(:,219)) * den(172)
  A(178) = cont_QA(wf(:,212),wf(:,216)) * den(173)
  A(179) = cont_QA(wf(:,216),wf(:,220)) * den(173)
  A(180) = cont_QA(wf(:,221),wf(:,222)) * den(175)
  A(181) = cont_QA(wf(:,222),wf(:,223)) * den(176)
  A(182) = cont_QA(wf(:,224),wf(:,225)) * den(178)
  A(183) = cont_QA(wf(:,224),wf(:,226)) * den(180)
  A(184) = cont_QA(wf(:,222),wf(:,224)) * den(181)
  A(185) = cont_QA(wf(:,222),wf(:,227)) * den(176)
  A(186) = cont_QA(wf(:,222),wf(:,224)) * den(181)
  A(187) = cont_QA(wf(:,224),wf(:,228)) * den(180)
  A(188) = cont_QA(wf(:,222),wf(:,224)) * den(181)
  A(189) = cont_QA(wf(:,222),wf(:,229)) * den(181)
  A(190) = cont_VV(wf(:,4),wf(:,230)) * den(5)
  A(191) = cont_VV(wf(:,4),wf(:,231)) * den(5)
  A(192) = cont_QA(wf(:,38),wf(:,232)) * den(31)
  A(193) = cont_QA(wf(:,38),wf(:,233)) * den(31)
  A(194) = cont_QA(wf(:,42),wf(:,209)) * den(33)
  A(195) = cont_QA(wf(:,44),wf(:,209)) * den(33)
  A(196) = cont_QA(wf(:,48),wf(:,234)) * den(37)
  A(197) = cont_QA(wf(:,48),wf(:,235)) * den(37)
  A(198) = cont_QA(wf(:,52),wf(:,224)) * den(40)
  A(199) = cont_QA(wf(:,54),wf(:,224)) * den(40)
  A(200) = cont_QA(wf(:,57),wf(:,236)) * den(42)
  A(201) = cont_QA(wf(:,59),wf(:,236)) * den(44)
  A(202) = cont_QA(wf(:,38),wf(:,238)) * den(46)
  A(203) = cont_QA(wf(:,38),wf(:,240)) * den(48)
  A(204) = cont_QA(wf(:,38),wf(:,236)) * den(49)
  A(205) = cont_QA(wf(:,65),wf(:,236)) * den(44)
  A(206) = cont_QA(wf(:,38),wf(:,236)) * den(49)
  A(207) = cont_QA(wf(:,38),wf(:,242)) * den(48)
  A(208) = cont_QA(wf(:,38),wf(:,236)) * den(49)
  A(209) = cont_QA(wf(:,38),wf(:,243)) * den(49)
  A(210) = cont_QA(wf(:,69),wf(:,245)) * den(52)
  A(211) = cont_QA(wf(:,71),wf(:,245)) * den(53)
  A(212) = cont_QA(wf(:,46),wf(:,247)) * den(55)
  A(213) = cont_QA(wf(:,46),wf(:,249)) * den(57)
  A(214) = cont_QA(wf(:,46),wf(:,245)) * den(58)
  A(215) = cont_QA(wf(:,76),wf(:,245)) * den(53)
  A(216) = cont_QA(wf(:,46),wf(:,245)) * den(58)
  A(217) = cont_QA(wf(:,46),wf(:,251)) * den(57)
  A(218) = cont_QA(wf(:,46),wf(:,245)) * den(58)
  A(219) = cont_QA(wf(:,46),wf(:,253)) * den(58)
  A(220) = cont_QA(wf(:,15),wf(:,254)) * den(182)
  A(221) = cont_QA(wf(:,15),wf(:,255)) * den(182)
  A(222) = cont_QA(wf(:,256),wf(:,257)) * den(184)
  A(223) = cont_QA(wf(:,256),wf(:,258)) * den(184)
  A(224) = cont_QA(wf(:,57),wf(:,259)) * den(42)
  A(225) = cont_QA(wf(:,59),wf(:,259)) * den(44)
  A(226) = cont_QA(wf(:,38),wf(:,260)) * den(46)
  A(227) = cont_QA(wf(:,38),wf(:,261)) * den(48)
  A(228) = cont_QA(wf(:,38),wf(:,259)) * den(49)
  A(229) = cont_QA(wf(:,65),wf(:,259)) * den(44)
  A(230) = cont_QA(wf(:,38),wf(:,259)) * den(49)
  A(231) = cont_QA(wf(:,38),wf(:,262)) * den(48)
  A(232) = cont_QA(wf(:,38),wf(:,259)) * den(49)
  A(233) = cont_QA(wf(:,38),wf(:,263)) * den(49)
  A(234) = cont_QA(wf(:,70),wf(:,264)) * den(52)
  A(235) = cont_QA(wf(:,70),wf(:,265)) * den(53)
  A(236) = cont_QA(wf(:,73),wf(:,256)) * den(55)
  A(237) = cont_QA(wf(:,75),wf(:,256)) * den(57)
  A(238) = cont_QA(wf(:,70),wf(:,256)) * den(58)
  A(239) = cont_QA(wf(:,70),wf(:,266)) * den(53)
  A(240) = cont_QA(wf(:,70),wf(:,256)) * den(58)
  A(241) = cont_QA(wf(:,78),wf(:,256)) * den(57)
  A(242) = cont_QA(wf(:,70),wf(:,256)) * den(58)
  A(243) = cont_QA(wf(:,70),wf(:,267)) * den(58)
  A(244) = cont_QA(wf(:,38),wf(:,269)) * den(31)
  A(245) = cont_QA(wf(:,38),wf(:,271)) * den(31)
  A(246) = cont_QA(wf(:,28),wf(:,273)) * den(33)
  A(247) = cont_QA(wf(:,28),wf(:,275)) * den(33)
  A(248) = cont_VV(wf(:,3),wf(:,276)) * den(186)
  A(249) = cont_VV(wf(:,3),wf(:,277)) * den(188)
  A(250) = cont_SS(wf(:,60),wf(:,278)) * den(189)
  A(251) = cont_VV(wf(:,3),wf(:,279)) * den(191)
  A(252) = cont_VV(wf(:,3),wf(:,280)) * den(193)
  A(253) = cont_VV(wf(:,66),wf(:,281)) * den(194)
  A(254) = cont_VV(wf(:,3),wf(:,282)) * den(62)
  A(255) = cont_QA(wf(:,85),wf(:,283)) * den(66)
  A(256) = cont_QA(wf(:,88),wf(:,283)) * den(69)
  A(257) = cont_QA(wf(:,92),wf(:,284)) * den(72)
  A(258) = cont_QA(wf(:,92),wf(:,285)) * den(74)
  A(259) = cont_QA(wf(:,92),wf(:,283)) * den(75)
  A(260) = cont_QA(wf(:,97),wf(:,283)) * den(69)
  A(261) = cont_QA(wf(:,92),wf(:,283)) * den(75)
  A(262) = cont_QA(wf(:,92),wf(:,286)) * den(74)
  A(263) = cont_QA(wf(:,92),wf(:,283)) * den(75)
  A(264) = cont_QA(wf(:,92),wf(:,287)) * den(75)
  A(265) = cont_QA(wf(:,102),wf(:,288)) * den(78)
  A(266) = cont_QA(wf(:,102),wf(:,289)) * den(79)
  A(267) = cont_QA(wf(:,106),wf(:,290)) * den(81)
  A(268) = cont_QA(wf(:,108),wf(:,290)) * den(83)
  A(269) = cont_QA(wf(:,102),wf(:,290)) * den(84)
  A(270) = cont_QA(wf(:,102),wf(:,291)) * den(79)
  A(271) = cont_QA(wf(:,102),wf(:,290)) * den(84)
  A(272) = cont_QA(wf(:,111),wf(:,290)) * den(83)
  A(273) = cont_QA(wf(:,102),wf(:,290)) * den(84)
  A(274) = cont_QA(wf(:,102),wf(:,292)) * den(84)
  A(275) = cont_QA(wf(:,293),wf(:,294)) * den(196)
  A(276) = cont_QA(wf(:,293),wf(:,295)) * den(198)
  A(277) = cont_QA(wf(:,296),wf(:,297)) * den(200)
  A(278) = cont_QA(wf(:,297),wf(:,298)) * den(201)
  A(279) = cont_QA(wf(:,293),wf(:,297)) * den(202)
  A(280) = cont_QA(wf(:,293),wf(:,299)) * den(198)
  A(281) = cont_QA(wf(:,293),wf(:,297)) * den(202)
  A(282) = cont_QA(wf(:,297),wf(:,300)) * den(201)
  A(283) = cont_QA(wf(:,293),wf(:,297)) * den(202)
  A(284) = cont_QA(wf(:,297),wf(:,301)) * den(202)
  A(285) = cont_QA(wf(:,302),wf(:,303)) * den(204)
  A(286) = cont_QA(wf(:,303),wf(:,304)) * den(205)
  A(287) = cont_QA(wf(:,305),wf(:,306)) * den(207)
  A(288) = cont_QA(wf(:,305),wf(:,307)) * den(209)
  A(289) = cont_QA(wf(:,303),wf(:,305)) * den(210)
  A(290) = cont_QA(wf(:,303),wf(:,308)) * den(205)
  A(291) = cont_QA(wf(:,303),wf(:,305)) * den(210)
  A(292) = cont_QA(wf(:,305),wf(:,309)) * den(209)
  A(293) = cont_QA(wf(:,303),wf(:,305)) * den(210)
  A(294) = cont_QA(wf(:,303),wf(:,310)) * den(210)
  A(295) = cont_VV(wf(:,81),wf(:,230)) * den(62)
  A(296) = cont_VV(wf(:,81),wf(:,231)) * den(62)
  A(297) = cont_QA(wf(:,113),wf(:,232)) * den(86)
  A(298) = cont_QA(wf(:,113),wf(:,233)) * den(86)
  A(299) = cont_QA(wf(:,115),wf(:,283)) * den(88)
  A(300) = cont_QA(wf(:,117),wf(:,283)) * den(88)
  A(301) = cont_QA(wf(:,120),wf(:,293)) * den(92)
  A(302) = cont_QA(wf(:,123),wf(:,293)) * den(92)
  A(303) = cont_QA(wf(:,126),wf(:,311)) * den(95)
  A(304) = cont_QA(wf(:,126),wf(:,312)) * den(95)
  A(305) = cont_QA(wf(:,129),wf(:,236)) * den(97)
  A(306) = cont_QA(wf(:,131),wf(:,236)) * den(99)
  A(307) = cont_QA(wf(:,113),wf(:,238)) * den(100)
  A(308) = cont_QA(wf(:,113),wf(:,240)) * den(101)
  A(309) = cont_QA(wf(:,113),wf(:,236)) * den(102)
  A(310) = cont_QA(wf(:,133),wf(:,236)) * den(99)
  A(311) = cont_QA(wf(:,113),wf(:,236)) * den(102)
  A(312) = cont_QA(wf(:,113),wf(:,242)) * den(101)
  A(313) = cont_QA(wf(:,113),wf(:,236)) * den(102)
  A(314) = cont_QA(wf(:,113),wf(:,243)) * den(102)
  A(315) = cont_QA(wf(:,124),wf(:,314)) * den(105)
  A(316) = cont_QA(wf(:,124),wf(:,316)) * den(107)
  A(317) = cont_QA(wf(:,139),wf(:,318)) * den(109)
  A(318) = cont_QA(wf(:,141),wf(:,318)) * den(110)
  A(319) = cont_QA(wf(:,124),wf(:,318)) * den(111)
  A(320) = cont_QA(wf(:,124),wf(:,320)) * den(107)
  A(321) = cont_QA(wf(:,124),wf(:,318)) * den(111)
  A(322) = cont_QA(wf(:,144),wf(:,318)) * den(110)
  A(323) = cont_QA(wf(:,124),wf(:,318)) * den(111)
  A(324) = cont_QA(wf(:,124),wf(:,322)) * den(111)
  A(325) = cont_QA(wf(:,323),wf(:,324)) * den(212)
  A(326) = cont_QA(wf(:,323),wf(:,325)) * den(212)
  A(327) = cont_QA(wf(:,102),wf(:,326)) * den(213)
  A(328) = cont_QA(wf(:,102),wf(:,327)) * den(213)
  A(329) = cont_QA(wf(:,129),wf(:,259)) * den(97)
  A(330) = cont_QA(wf(:,131),wf(:,259)) * den(99)
  A(331) = cont_QA(wf(:,113),wf(:,260)) * den(100)
  A(332) = cont_QA(wf(:,113),wf(:,261)) * den(101)
  A(333) = cont_QA(wf(:,113),wf(:,259)) * den(102)
  A(334) = cont_QA(wf(:,133),wf(:,259)) * den(99)
  A(335) = cont_QA(wf(:,113),wf(:,259)) * den(102)
  A(336) = cont_QA(wf(:,113),wf(:,262)) * den(101)
  A(337) = cont_QA(wf(:,113),wf(:,259)) * den(102)
  A(338) = cont_QA(wf(:,113),wf(:,263)) * den(102)
  A(339) = cont_QA(wf(:,135),wf(:,323)) * den(105)
  A(340) = cont_QA(wf(:,137),wf(:,323)) * den(107)
  A(341) = cont_QA(wf(:,140),wf(:,328)) * den(109)
  A(342) = cont_QA(wf(:,140),wf(:,329)) * den(110)
  A(343) = cont_QA(wf(:,140),wf(:,323)) * den(111)
  A(344) = cont_QA(wf(:,143),wf(:,323)) * den(107)
  A(345) = cont_QA(wf(:,140),wf(:,323)) * den(111)
  A(346) = cont_QA(wf(:,140),wf(:,330)) * den(110)
  A(347) = cont_QA(wf(:,140),wf(:,323)) * den(111)
  A(348) = cont_QA(wf(:,140),wf(:,331)) * den(111)
  A(349) = cont_QA(wf(:,113),wf(:,269)) * den(86)
  A(350) = cont_QA(wf(:,113),wf(:,271)) * den(86)
  A(351) = cont_QA(wf(:,84),wf(:,333)) * den(88)
  A(352) = cont_QA(wf(:,84),wf(:,335)) * den(88)
  A(353) = cont_QA(wf(:,148),wf(:,336)) * den(115)
  A(354) = cont_QA(wf(:,148),wf(:,337)) * den(115)
  A(355) = cont_QA(wf(:,152),wf(:,290)) * den(117)
  A(356) = cont_QA(wf(:,154),wf(:,290)) * den(117)
  A(357) = cont_QA(wf(:,156),wf(:,234)) * den(119)
  A(358) = cont_QA(wf(:,156),wf(:,235)) * den(119)
  A(359) = cont_QA(wf(:,158),wf(:,305)) * den(122)
  A(360) = cont_QA(wf(:,160),wf(:,305)) * den(122)
  A(361) = cont_QA(wf(:,163),wf(:,338)) * den(124)
  A(362) = cont_QA(wf(:,165),wf(:,338)) * den(126)
  A(363) = cont_QA(wf(:,148),wf(:,339)) * den(127)
  A(364) = cont_QA(wf(:,148),wf(:,340)) * den(128)
  A(365) = cont_QA(wf(:,148),wf(:,338)) * den(129)
  A(366) = cont_QA(wf(:,169),wf(:,338)) * den(126)
  A(367) = cont_QA(wf(:,148),wf(:,338)) * den(129)
  A(368) = cont_QA(wf(:,148),wf(:,341)) * den(128)
  A(369) = cont_QA(wf(:,148),wf(:,338)) * den(129)
  A(370) = cont_QA(wf(:,148),wf(:,342)) * den(129)
  A(371) = cont_QA(wf(:,171),wf(:,245)) * den(130)
  A(372) = cont_QA(wf(:,172),wf(:,245)) * den(131)
  A(373) = cont_QA(wf(:,155),wf(:,247)) * den(132)
  A(374) = cont_QA(wf(:,155),wf(:,249)) * den(133)
  A(375) = cont_QA(wf(:,155),wf(:,245)) * den(134)
  A(376) = cont_QA(wf(:,173),wf(:,245)) * den(131)
  A(377) = cont_QA(wf(:,155),wf(:,245)) * den(134)
  A(378) = cont_QA(wf(:,155),wf(:,251)) * den(133)
  A(379) = cont_QA(wf(:,155),wf(:,245)) * den(134)
  A(380) = cont_QA(wf(:,155),wf(:,253)) * den(134)
  A(381) = cont_QA(wf(:,175),wf(:,336)) * den(136)
  A(382) = cont_QA(wf(:,175),wf(:,337)) * den(136)
  A(383) = cont_QA(wf(:,177),wf(:,202)) * den(138)
  A(384) = cont_QA(wf(:,179),wf(:,202)) * den(138)
  A(385) = cont_QA(wf(:,181),wf(:,212)) * den(141)
  A(386) = cont_QA(wf(:,183),wf(:,212)) * den(141)
  A(387) = cont_QA(wf(:,185),wf(:,311)) * den(143)
  A(388) = cont_QA(wf(:,185),wf(:,312)) * den(143)
  A(389) = cont_QA(wf(:,187),wf(:,338)) * den(145)
  A(390) = cont_QA(wf(:,189),wf(:,338)) * den(147)
  A(391) = cont_QA(wf(:,175),wf(:,339)) * den(148)
  A(392) = cont_QA(wf(:,175),wf(:,340)) * den(149)
  A(393) = cont_QA(wf(:,175),wf(:,338)) * den(150)
  A(394) = cont_QA(wf(:,191),wf(:,338)) * den(147)
  A(395) = cont_QA(wf(:,175),wf(:,338)) * den(150)
  A(396) = cont_QA(wf(:,175),wf(:,341)) * den(149)
  A(397) = cont_QA(wf(:,175),wf(:,338)) * den(150)
  A(398) = cont_QA(wf(:,175),wf(:,342)) * den(150)
  A(399) = cont_QA(wf(:,184),wf(:,314)) * den(151)
  A(400) = cont_QA(wf(:,184),wf(:,316)) * den(152)
  A(401) = cont_QA(wf(:,192),wf(:,318)) * den(153)
  A(402) = cont_QA(wf(:,193),wf(:,318)) * den(154)
  A(403) = cont_QA(wf(:,184),wf(:,318)) * den(155)
  A(404) = cont_QA(wf(:,184),wf(:,320)) * den(152)
  A(405) = cont_QA(wf(:,184),wf(:,318)) * den(155)
  A(406) = cont_QA(wf(:,194),wf(:,318)) * den(154)
  A(407) = cont_QA(wf(:,184),wf(:,318)) * den(155)
  A(408) = cont_QA(wf(:,184),wf(:,322)) * den(155)
  A(409) = cont_QA(wf(:,92),wf(:,343)) * den(214)
  A(410) = cont_QA(wf(:,92),wf(:,344)) * den(214)
  A(411) = cont_QA(wf(:,257),wf(:,345)) * den(215)
  A(412) = cont_QA(wf(:,258),wf(:,345)) * den(215)
  A(413) = cont_QA(wf(:,163),wf(:,346)) * den(124)
  A(414) = cont_QA(wf(:,165),wf(:,346)) * den(126)
  A(415) = cont_QA(wf(:,148),wf(:,347)) * den(127)
  A(416) = cont_QA(wf(:,148),wf(:,348)) * den(128)
  A(417) = cont_QA(wf(:,148),wf(:,346)) * den(129)
  A(418) = cont_QA(wf(:,169),wf(:,346)) * den(126)
  A(419) = cont_QA(wf(:,148),wf(:,346)) * den(129)
  A(420) = cont_QA(wf(:,148),wf(:,349)) * den(128)
  A(421) = cont_QA(wf(:,148),wf(:,346)) * den(129)
  A(422) = cont_QA(wf(:,148),wf(:,350)) * den(129)
  A(423) = cont_QA(wf(:,70),wf(:,351)) * den(130)
  A(424) = cont_QA(wf(:,70),wf(:,352)) * den(131)
  A(425) = cont_QA(wf(:,73),wf(:,345)) * den(132)
  A(426) = cont_QA(wf(:,75),wf(:,345)) * den(133)
  A(427) = cont_QA(wf(:,70),wf(:,345)) * den(134)
  A(428) = cont_QA(wf(:,70),wf(:,353)) * den(131)
  A(429) = cont_QA(wf(:,70),wf(:,345)) * den(134)
  A(430) = cont_QA(wf(:,78),wf(:,345)) * den(133)
  A(431) = cont_QA(wf(:,70),wf(:,345)) * den(134)
  A(432) = cont_QA(wf(:,70),wf(:,354)) * den(134)
  A(433) = cont_QA(wf(:,148),wf(:,356)) * den(115)
  A(434) = cont_QA(wf(:,148),wf(:,358)) * den(115)
  A(435) = cont_QA(wf(:,105),wf(:,360)) * den(117)
  A(436) = cont_QA(wf(:,105),wf(:,362)) * den(117)
  A(437) = cont_QA(wf(:,324),wf(:,363)) * den(216)
  A(438) = cont_QA(wf(:,325),wf(:,363)) * den(216)
  A(439) = cont_QA(wf(:,25),wf(:,364)) * den(217)
  A(440) = cont_QA(wf(:,25),wf(:,365)) * den(217)
  A(441) = cont_QA(wf(:,187),wf(:,346)) * den(145)
  A(442) = cont_QA(wf(:,189),wf(:,346)) * den(147)
  A(443) = cont_QA(wf(:,175),wf(:,347)) * den(148)
  A(444) = cont_QA(wf(:,175),wf(:,348)) * den(149)
  A(445) = cont_QA(wf(:,175),wf(:,346)) * den(150)
  A(446) = cont_QA(wf(:,191),wf(:,346)) * den(147)
  A(447) = cont_QA(wf(:,175),wf(:,346)) * den(150)
  A(448) = cont_QA(wf(:,175),wf(:,349)) * den(149)
  A(449) = cont_QA(wf(:,175),wf(:,346)) * den(150)
  A(450) = cont_QA(wf(:,175),wf(:,350)) * den(150)
  A(451) = cont_QA(wf(:,135),wf(:,363)) * den(151)
  A(452) = cont_QA(wf(:,137),wf(:,363)) * den(152)
  A(453) = cont_QA(wf(:,140),wf(:,366)) * den(153)
  A(454) = cont_QA(wf(:,140),wf(:,367)) * den(154)
  A(455) = cont_QA(wf(:,140),wf(:,363)) * den(155)
  A(456) = cont_QA(wf(:,143),wf(:,363)) * den(152)
  A(457) = cont_QA(wf(:,140),wf(:,363)) * den(155)
  A(458) = cont_QA(wf(:,140),wf(:,368)) * den(154)
  A(459) = cont_QA(wf(:,140),wf(:,363)) * den(155)
  A(460) = cont_QA(wf(:,140),wf(:,369)) * den(155)
  A(461) = cont_QA(wf(:,175),wf(:,356)) * den(136)
  A(462) = cont_QA(wf(:,175),wf(:,358)) * den(136)
  A(463) = cont_QA(wf(:,7),wf(:,371)) * den(138)
  A(464) = cont_QA(wf(:,7),wf(:,373)) * den(138)
  A(465) = cont_QA(wf(:,216),wf(:,374)) * den(218)
  A(466) = cont_QA(wf(:,216),wf(:,375)) * den(218)
  A(467) = cont_QA(wf(:,376),wf(:,377)) * den(221)
  A(468) = cont_QA(wf(:,376),wf(:,378)) * den(221)
  A(469) = cont_QA(wf(:,379),wf(:,380)) * den(223)
  A(470) = cont_QA(wf(:,379),wf(:,381)) * den(225)
  A(471) = cont_QA(wf(:,48),wf(:,382)) * den(226)
  A(472) = cont_QA(wf(:,48),wf(:,383)) * den(227)
  A(473) = cont_QA(wf(:,48),wf(:,379)) * den(228)
  A(474) = cont_QA(wf(:,379),wf(:,384)) * den(225)
  A(475) = cont_QA(wf(:,48),wf(:,379)) * den(228)
  A(476) = cont_QA(wf(:,48),wf(:,385)) * den(227)
  A(477) = cont_QA(wf(:,48),wf(:,379)) * den(228)
  A(478) = cont_QA(wf(:,48),wf(:,386)) * den(228)
  A(479) = cont_QA(wf(:,387),wf(:,388)) * den(230)
  A(480) = cont_QA(wf(:,388),wf(:,389)) * den(231)
  A(481) = cont_QA(wf(:,376),wf(:,390)) * den(233)
  A(482) = cont_QA(wf(:,376),wf(:,391)) * den(235)
  A(483) = cont_QA(wf(:,376),wf(:,388)) * den(236)
  A(484) = cont_QA(wf(:,388),wf(:,392)) * den(231)
  A(485) = cont_QA(wf(:,376),wf(:,388)) * den(236)
  A(486) = cont_QA(wf(:,376),wf(:,393)) * den(235)
  A(487) = cont_QA(wf(:,376),wf(:,388)) * den(236)
  A(488) = cont_QA(wf(:,388),wf(:,394)) * den(236)
  A(489) = cont_QA(wf(:,48),wf(:,396)) * den(37)
  A(490) = cont_QA(wf(:,48),wf(:,398)) * den(37)
  A(491) = cont_QA(wf(:,13),wf(:,400)) * den(40)
  A(492) = cont_QA(wf(:,13),wf(:,402)) * den(40)
  A(493) = cont_VV(wf(:,3),wf(:,404)) * den(5)
  A(494) = cont_VV(wf(:,3),wf(:,406)) * den(5)
  A(495) = cont_QA(wf(:,8),wf(:,407)) * den(9)
  A(496) = cont_QA(wf(:,11),wf(:,407)) * den(12)
  A(497) = cont_QA(wf(:,15),wf(:,409)) * den(15)
  A(498) = cont_QA(wf(:,15),wf(:,411)) * den(17)
  A(499) = cont_QA(wf(:,15),wf(:,407)) * den(18)
  A(500) = cont_QA(wf(:,20),wf(:,407)) * den(12)
  A(501) = cont_QA(wf(:,15),wf(:,407)) * den(18)
  A(502) = cont_QA(wf(:,15),wf(:,413)) * den(17)
  A(503) = cont_QA(wf(:,15),wf(:,407)) * den(18)
  A(504) = cont_QA(wf(:,15),wf(:,414)) * den(18)
  A(505) = cont_QA(wf(:,24),wf(:,416)) * den(21)
  A(506) = cont_QA(wf(:,26),wf(:,416)) * den(22)
  A(507) = cont_QA(wf(:,28),wf(:,418)) * den(24)
  A(508) = cont_QA(wf(:,28),wf(:,420)) * den(26)
  A(509) = cont_QA(wf(:,28),wf(:,416)) * den(27)
  A(510) = cont_QA(wf(:,32),wf(:,416)) * den(22)
  A(511) = cont_QA(wf(:,28),wf(:,416)) * den(27)
  A(512) = cont_QA(wf(:,28),wf(:,422)) * den(26)
  A(513) = cont_QA(wf(:,28),wf(:,416)) * den(27)
  A(514) = cont_QA(wf(:,28),wf(:,424)) * den(27)
  A(515) = cont_QA(wf(:,297),wf(:,425)) * den(237)
  A(516) = cont_QA(wf(:,297),wf(:,426)) * den(237)
  A(517) = cont_QA(wf(:,427),wf(:,428)) * den(240)
  A(518) = cont_QA(wf(:,427),wf(:,429)) * den(240)
  A(519) = cont_QA(wf(:,379),wf(:,430)) * den(242)
  A(520) = cont_QA(wf(:,379),wf(:,431)) * den(244)
  A(521) = cont_QA(wf(:,156),wf(:,382)) * den(245)
  A(522) = cont_QA(wf(:,156),wf(:,383)) * den(246)
  A(523) = cont_QA(wf(:,156),wf(:,379)) * den(247)
  A(524) = cont_QA(wf(:,379),wf(:,432)) * den(244)
  A(525) = cont_QA(wf(:,156),wf(:,379)) * den(247)
  A(526) = cont_QA(wf(:,156),wf(:,385)) * den(246)
  A(527) = cont_QA(wf(:,156),wf(:,379)) * den(247)
  A(528) = cont_QA(wf(:,156),wf(:,386)) * den(247)
  A(529) = cont_QA(wf(:,433),wf(:,434)) * den(249)
  A(530) = cont_QA(wf(:,434),wf(:,435)) * den(250)
  A(531) = cont_QA(wf(:,427),wf(:,436)) * den(252)
  A(532) = cont_QA(wf(:,427),wf(:,437)) * den(254)
  A(533) = cont_QA(wf(:,427),wf(:,434)) * den(255)
  A(534) = cont_QA(wf(:,434),wf(:,438)) * den(250)
  A(535) = cont_QA(wf(:,427),wf(:,434)) * den(255)
  A(536) = cont_QA(wf(:,427),wf(:,439)) * den(254)
  A(537) = cont_QA(wf(:,427),wf(:,434)) * den(255)
  A(538) = cont_QA(wf(:,434),wf(:,440)) * den(255)
  A(539) = cont_QA(wf(:,156),wf(:,396)) * den(119)
  A(540) = cont_QA(wf(:,156),wf(:,398)) * den(119)
  A(541) = cont_QA(wf(:,90),wf(:,442)) * den(122)
  A(542) = cont_QA(wf(:,90),wf(:,444)) * den(122)
  A(543) = cont_QA(wf(:,177),wf(:,407)) * den(138)
  A(544) = cont_QA(wf(:,179),wf(:,407)) * den(138)
  A(545) = cont_QA(wf(:,147),wf(:,446)) * den(136)
  A(546) = cont_QA(wf(:,150),wf(:,446)) * den(136)
  A(547) = cont_QA(wf(:,181),wf(:,415)) * den(141)
  A(548) = cont_QA(wf(:,183),wf(:,415)) * den(141)
  A(549) = cont_QA(wf(:,125),wf(:,448)) * den(143)
  A(550) = cont_QA(wf(:,127),wf(:,448)) * den(143)
  A(551) = cont_QA(wf(:,135),wf(:,447)) * den(151)
  A(552) = cont_QA(wf(:,137),wf(:,447)) * den(152)
  A(553) = cont_QA(wf(:,140),wf(:,449)) * den(153)
  A(554) = cont_QA(wf(:,140),wf(:,450)) * den(154)
  A(555) = cont_QA(wf(:,140),wf(:,447)) * den(155)
  A(556) = cont_QA(wf(:,143),wf(:,447)) * den(152)
  A(557) = cont_QA(wf(:,140),wf(:,447)) * den(155)
  A(558) = cont_QA(wf(:,140),wf(:,451)) * den(154)
  A(559) = cont_QA(wf(:,140),wf(:,447)) * den(155)
  A(560) = cont_QA(wf(:,140),wf(:,452)) * den(155)
  A(561) = cont_QA(wf(:,162),wf(:,454)) * den(145)
  A(562) = cont_QA(wf(:,162),wf(:,456)) * den(147)
  A(563) = cont_QA(wf(:,166),wf(:,446)) * den(148)
  A(564) = cont_QA(wf(:,167),wf(:,446)) * den(149)
  A(565) = cont_QA(wf(:,162),wf(:,446)) * den(150)
  A(566) = cont_QA(wf(:,162),wf(:,458)) * den(147)
  A(567) = cont_QA(wf(:,162),wf(:,446)) * den(150)
  A(568) = cont_QA(wf(:,170),wf(:,446)) * den(149)
  A(569) = cont_QA(wf(:,162),wf(:,446)) * den(150)
  A(570) = cont_QA(wf(:,162),wf(:,460)) * den(150)
  A(571) = cont_VV(wf(:,3),wf(:,462)) * den(62)
  A(572) = cont_VV(wf(:,3),wf(:,464)) * den(62)
  A(573) = cont_QA(wf(:,85),wf(:,465)) * den(66)
  A(574) = cont_QA(wf(:,88),wf(:,465)) * den(69)
  A(575) = cont_QA(wf(:,92),wf(:,467)) * den(72)
  A(576) = cont_QA(wf(:,92),wf(:,469)) * den(74)
  A(577) = cont_QA(wf(:,92),wf(:,465)) * den(75)
  A(578) = cont_QA(wf(:,97),wf(:,465)) * den(69)
  A(579) = cont_QA(wf(:,92),wf(:,465)) * den(75)
  A(580) = cont_QA(wf(:,92),wf(:,471)) * den(74)
  A(581) = cont_QA(wf(:,92),wf(:,465)) * den(75)
  A(582) = cont_QA(wf(:,92),wf(:,472)) * den(75)
  A(583) = cont_QA(wf(:,101),wf(:,474)) * den(78)
  A(584) = cont_QA(wf(:,103),wf(:,474)) * den(79)
  A(585) = cont_QA(wf(:,105),wf(:,476)) * den(81)
  A(586) = cont_QA(wf(:,105),wf(:,478)) * den(83)
  A(587) = cont_QA(wf(:,105),wf(:,474)) * den(84)
  A(588) = cont_QA(wf(:,109),wf(:,474)) * den(79)
  A(589) = cont_QA(wf(:,105),wf(:,474)) * den(84)
  A(590) = cont_QA(wf(:,105),wf(:,480)) * den(83)
  A(591) = cont_QA(wf(:,105),wf(:,474)) * den(84)
  A(592) = cont_QA(wf(:,105),wf(:,482)) * den(84)
  A(593) = cont_QA(wf(:,115),wf(:,465)) * den(88)
  A(594) = cont_QA(wf(:,117),wf(:,465)) * den(88)
  A(595) = cont_QA(wf(:,37),wf(:,484)) * den(86)
  A(596) = cont_QA(wf(:,40),wf(:,484)) * den(86)
  A(597) = cont_QA(wf(:,120),wf(:,473)) * den(92)
  A(598) = cont_QA(wf(:,123),wf(:,473)) * den(92)
  A(599) = cont_QA(wf(:,125),wf(:,486)) * den(95)
  A(600) = cont_QA(wf(:,127),wf(:,486)) * den(95)
  A(601) = cont_QA(wf(:,135),wf(:,485)) * den(105)
  A(602) = cont_QA(wf(:,137),wf(:,485)) * den(107)
  A(603) = cont_QA(wf(:,140),wf(:,487)) * den(109)
  A(604) = cont_QA(wf(:,140),wf(:,488)) * den(110)
  A(605) = cont_QA(wf(:,140),wf(:,485)) * den(111)
  A(606) = cont_QA(wf(:,143),wf(:,485)) * den(107)
  A(607) = cont_QA(wf(:,140),wf(:,485)) * den(111)
  A(608) = cont_QA(wf(:,140),wf(:,489)) * den(110)
  A(609) = cont_QA(wf(:,140),wf(:,485)) * den(111)
  A(610) = cont_QA(wf(:,140),wf(:,490)) * den(111)
  A(611) = cont_QA(wf(:,56),wf(:,492)) * den(97)
  A(612) = cont_QA(wf(:,56),wf(:,494)) * den(99)
  A(613) = cont_QA(wf(:,61),wf(:,484)) * den(100)
  A(614) = cont_QA(wf(:,63),wf(:,484)) * den(101)
  A(615) = cont_QA(wf(:,56),wf(:,484)) * den(102)
  A(616) = cont_QA(wf(:,56),wf(:,496)) * den(99)
  A(617) = cont_QA(wf(:,56),wf(:,484)) * den(102)
  A(618) = cont_QA(wf(:,67),wf(:,484)) * den(101)
  A(619) = cont_QA(wf(:,56),wf(:,484)) * den(102)
  A(620) = cont_QA(wf(:,56),wf(:,498)) * den(102)
  A(621) = cont_QA(wf(:,377),wf(:,499)) * den(256)
  A(622) = cont_QA(wf(:,378),wf(:,499)) * den(256)
  A(623) = cont_QA(wf(:,303),wf(:,500)) * den(257)
  A(624) = cont_QA(wf(:,303),wf(:,501)) * den(257)
  A(625) = cont_QA(wf(:,388),wf(:,502)) * den(258)
  A(626) = cont_QA(wf(:,388),wf(:,503)) * den(259)
  A(627) = cont_QA(wf(:,390),wf(:,499)) * den(260)
  A(628) = cont_QA(wf(:,391),wf(:,499)) * den(261)
  A(629) = cont_QA(wf(:,388),wf(:,499)) * den(262)
  A(630) = cont_QA(wf(:,388),wf(:,504)) * den(259)
  A(631) = cont_QA(wf(:,388),wf(:,499)) * den(262)
  A(632) = cont_QA(wf(:,393),wf(:,499)) * den(261)
  A(633) = cont_QA(wf(:,388),wf(:,499)) * den(262)
  A(634) = cont_QA(wf(:,388),wf(:,505)) * den(262)
  A(635) = cont_QA(wf(:,126),wf(:,506)) * den(263)
  A(636) = cont_QA(wf(:,126),wf(:,507)) * den(264)
  A(637) = cont_QA(wf(:,508),wf(:,509)) * den(266)
  A(638) = cont_QA(wf(:,508),wf(:,510)) * den(268)
  A(639) = cont_QA(wf(:,126),wf(:,508)) * den(269)
  A(640) = cont_QA(wf(:,126),wf(:,511)) * den(264)
  A(641) = cont_QA(wf(:,126),wf(:,508)) * den(269)
  A(642) = cont_QA(wf(:,508),wf(:,512)) * den(268)
  A(643) = cont_QA(wf(:,126),wf(:,508)) * den(269)
  A(644) = cont_QA(wf(:,126),wf(:,513)) * den(269)
  A(645) = cont_QA(wf(:,100),wf(:,516)) * den(92)
  A(646) = cont_QA(wf(:,100),wf(:,519)) * den(92)
  A(647) = cont_QA(wf(:,126),wf(:,520)) * den(95)
  A(648) = cont_QA(wf(:,126),wf(:,521)) * den(95)
  A(649) = cont_VV(wf(:,3),wf(:,523)) * den(62)
  A(650) = cont_VV(wf(:,3),wf(:,525)) * den(62)
  A(651) = cont_QA(wf(:,84),wf(:,528)) * den(66)
  A(652) = cont_QA(wf(:,84),wf(:,531)) * den(69)
  A(653) = cont_QA(wf(:,91),wf(:,533)) * den(72)
  A(654) = cont_QA(wf(:,94),wf(:,533)) * den(74)
  A(655) = cont_QA(wf(:,84),wf(:,533)) * den(75)
  A(656) = cont_QA(wf(:,84),wf(:,536)) * den(69)
  A(657) = cont_QA(wf(:,84),wf(:,533)) * den(75)
  A(658) = cont_QA(wf(:,99),wf(:,533)) * den(74)
  A(659) = cont_QA(wf(:,84),wf(:,533)) * den(75)
  A(660) = cont_QA(wf(:,84),wf(:,538)) * den(75)
  A(661) = cont_QA(wf(:,102),wf(:,539)) * den(78)
  A(662) = cont_QA(wf(:,102),wf(:,540)) * den(79)
  A(663) = cont_QA(wf(:,106),wf(:,541)) * den(81)
  A(664) = cont_QA(wf(:,108),wf(:,541)) * den(83)
  A(665) = cont_QA(wf(:,102),wf(:,541)) * den(84)
  A(666) = cont_QA(wf(:,102),wf(:,542)) * den(79)
  A(667) = cont_QA(wf(:,102),wf(:,541)) * den(84)
  A(668) = cont_QA(wf(:,111),wf(:,541)) * den(83)
  A(669) = cont_QA(wf(:,102),wf(:,541)) * den(84)
  A(670) = cont_QA(wf(:,102),wf(:,543)) * den(84)
  A(671) = cont_QA(wf(:,428),wf(:,544)) * den(270)
  A(672) = cont_QA(wf(:,429),wf(:,544)) * den(270)
  A(673) = cont_QA(wf(:,222),wf(:,545)) * den(271)
  A(674) = cont_QA(wf(:,222),wf(:,546)) * den(271)
  A(675) = cont_QA(wf(:,434),wf(:,547)) * den(272)
  A(676) = cont_QA(wf(:,434),wf(:,548)) * den(273)
  A(677) = cont_QA(wf(:,436),wf(:,544)) * den(274)
  A(678) = cont_QA(wf(:,437),wf(:,544)) * den(275)
  A(679) = cont_QA(wf(:,434),wf(:,544)) * den(276)
  A(680) = cont_QA(wf(:,434),wf(:,549)) * den(273)
  A(681) = cont_QA(wf(:,434),wf(:,544)) * den(276)
  A(682) = cont_QA(wf(:,439),wf(:,544)) * den(275)
  A(683) = cont_QA(wf(:,434),wf(:,544)) * den(276)
  A(684) = cont_QA(wf(:,434),wf(:,550)) * den(276)
  A(685) = cont_QA(wf(:,185),wf(:,506)) * den(277)
  A(686) = cont_QA(wf(:,185),wf(:,507)) * den(278)
  A(687) = cont_QA(wf(:,508),wf(:,551)) * den(280)
  A(688) = cont_QA(wf(:,508),wf(:,552)) * den(282)
  A(689) = cont_QA(wf(:,185),wf(:,508)) * den(283)
  A(690) = cont_QA(wf(:,185),wf(:,511)) * den(278)
  A(691) = cont_QA(wf(:,185),wf(:,508)) * den(283)
  A(692) = cont_QA(wf(:,508),wf(:,553)) * den(282)
  A(693) = cont_QA(wf(:,185),wf(:,508)) * den(283)
  A(694) = cont_QA(wf(:,185),wf(:,513)) * den(283)
  A(695) = cont_QA(wf(:,23),wf(:,555)) * den(141)
  A(696) = cont_QA(wf(:,23),wf(:,557)) * den(141)
  A(697) = cont_QA(wf(:,185),wf(:,520)) * den(143)
  A(698) = cont_QA(wf(:,185),wf(:,521)) * den(143)
  A(699) = cont_QA(wf(:,147),wf(:,559)) * den(115)
  A(700) = cont_QA(wf(:,150),wf(:,559)) * den(115)
  A(701) = cont_QA(wf(:,152),wf(:,541)) * den(117)
  A(702) = cont_QA(wf(:,154),wf(:,541)) * den(117)
  A(703) = cont_QA(wf(:,47),wf(:,561)) * den(119)
  A(704) = cont_QA(wf(:,50),wf(:,561)) * den(119)
  A(705) = cont_QA(wf(:,158),wf(:,532)) * den(122)
  A(706) = cont_QA(wf(:,160),wf(:,532)) * den(122)
  A(707) = cont_QA(wf(:,162),wf(:,563)) * den(124)
  A(708) = cont_QA(wf(:,162),wf(:,565)) * den(126)
  A(709) = cont_QA(wf(:,166),wf(:,559)) * den(127)
  A(710) = cont_QA(wf(:,167),wf(:,559)) * den(128)
  A(711) = cont_QA(wf(:,162),wf(:,559)) * den(129)
  A(712) = cont_QA(wf(:,162),wf(:,567)) * den(126)
  A(713) = cont_QA(wf(:,162),wf(:,559)) * den(129)
  A(714) = cont_QA(wf(:,170),wf(:,559)) * den(128)
  A(715) = cont_QA(wf(:,162),wf(:,559)) * den(129)
  A(716) = cont_QA(wf(:,162),wf(:,569)) * den(129)
  A(717) = cont_QA(wf(:,70),wf(:,570)) * den(130)
  A(718) = cont_QA(wf(:,70),wf(:,571)) * den(131)
  A(719) = cont_QA(wf(:,73),wf(:,560)) * den(132)
  A(720) = cont_QA(wf(:,75),wf(:,560)) * den(133)
  A(721) = cont_QA(wf(:,70),wf(:,560)) * den(134)
  A(722) = cont_QA(wf(:,70),wf(:,572)) * den(131)
  A(723) = cont_QA(wf(:,70),wf(:,560)) * den(134)
  A(724) = cont_QA(wf(:,78),wf(:,560)) * den(133)
  A(725) = cont_QA(wf(:,70),wf(:,560)) * den(134)
  A(726) = cont_QA(wf(:,70),wf(:,573)) * den(134)
  A(727) = cont_VV(wf(:,3),wf(:,575)) * den(5)
  A(728) = cont_VV(wf(:,3),wf(:,577)) * den(5)
  A(729) = cont_QA(wf(:,7),wf(:,580)) * den(9)
  A(730) = cont_QA(wf(:,7),wf(:,583)) * den(12)
  A(731) = cont_QA(wf(:,14),wf(:,585)) * den(15)
  A(732) = cont_QA(wf(:,17),wf(:,585)) * den(17)
  A(733) = cont_QA(wf(:,7),wf(:,585)) * den(18)
  A(734) = cont_QA(wf(:,7),wf(:,588)) * den(12)
  A(735) = cont_QA(wf(:,7),wf(:,585)) * den(18)
  A(736) = cont_QA(wf(:,22),wf(:,585)) * den(17)
  A(737) = cont_QA(wf(:,7),wf(:,585)) * den(18)
  A(738) = cont_QA(wf(:,7),wf(:,590)) * den(18)
  A(739) = cont_QA(wf(:,25),wf(:,591)) * den(21)
  A(740) = cont_QA(wf(:,25),wf(:,592)) * den(22)
  A(741) = cont_QA(wf(:,29),wf(:,593)) * den(24)
  A(742) = cont_QA(wf(:,31),wf(:,593)) * den(26)
  A(743) = cont_QA(wf(:,25),wf(:,593)) * den(27)
  A(744) = cont_QA(wf(:,25),wf(:,594)) * den(22)
  A(745) = cont_QA(wf(:,25),wf(:,593)) * den(27)
  A(746) = cont_QA(wf(:,34),wf(:,593)) * den(26)
  A(747) = cont_QA(wf(:,25),wf(:,593)) * den(27)
  A(748) = cont_QA(wf(:,25),wf(:,595)) * den(27)
  A(749) = cont_QA(wf(:,37),wf(:,597)) * den(31)
  A(750) = cont_QA(wf(:,40),wf(:,597)) * den(31)
  A(751) = cont_QA(wf(:,42),wf(:,593)) * den(33)
  A(752) = cont_QA(wf(:,44),wf(:,593)) * den(33)
  A(753) = cont_QA(wf(:,47),wf(:,599)) * den(37)
  A(754) = cont_QA(wf(:,50),wf(:,599)) * den(37)
  A(755) = cont_QA(wf(:,52),wf(:,584)) * den(40)
  A(756) = cont_QA(wf(:,54),wf(:,584)) * den(40)
  A(757) = cont_QA(wf(:,56),wf(:,601)) * den(42)
  A(758) = cont_QA(wf(:,56),wf(:,603)) * den(44)
  A(759) = cont_QA(wf(:,61),wf(:,597)) * den(46)
  A(760) = cont_QA(wf(:,63),wf(:,597)) * den(48)
  A(761) = cont_QA(wf(:,56),wf(:,597)) * den(49)
  A(762) = cont_QA(wf(:,56),wf(:,605)) * den(44)
  A(763) = cont_QA(wf(:,56),wf(:,597)) * den(49)
  A(764) = cont_QA(wf(:,67),wf(:,597)) * den(48)
  A(765) = cont_QA(wf(:,56),wf(:,597)) * den(49)
  A(766) = cont_QA(wf(:,56),wf(:,607)) * den(49)
  A(767) = cont_QA(wf(:,70),wf(:,608)) * den(52)
  A(768) = cont_QA(wf(:,70),wf(:,609)) * den(53)
  A(769) = cont_QA(wf(:,73),wf(:,598)) * den(55)
  A(770) = cont_QA(wf(:,75),wf(:,598)) * den(57)
  A(771) = cont_QA(wf(:,70),wf(:,598)) * den(58)
  A(772) = cont_QA(wf(:,70),wf(:,610)) * den(53)
  A(773) = cont_QA(wf(:,70),wf(:,598)) * den(58)
  A(774) = cont_QA(wf(:,78),wf(:,598)) * den(57)
  A(775) = cont_QA(wf(:,70),wf(:,598)) * den(58)
  A(776) = cont_QA(wf(:,70),wf(:,611)) * den(58)
  A(777) = cont_VV(wf(:,612),wf(:,613)) * den(287)
  A(778) = cont_VV(wf(:,614),wf(:,615)) * den(291)
  A(779) = cont_VV(wf(:,4),wf(:,616)) * den(294)
  A(780) = cont_QA(wf(:,225),wf(:,617)) * den(296)
  A(781) = cont_QA(wf(:,226),wf(:,617)) * den(297)
  A(782) = cont_QA(wf(:,222),wf(:,617)) * den(298)
  A(783) = cont_QA(wf(:,228),wf(:,617)) * den(297)
  A(784) = cont_QA(wf(:,222),wf(:,617)) * den(298)
  A(785) = cont_QA(wf(:,29),wf(:,618)) * den(299)
  A(786) = cont_QA(wf(:,31),wf(:,618)) * den(300)
  A(787) = cont_QA(wf(:,25),wf(:,618)) * den(301)
  A(788) = cont_QA(wf(:,34),wf(:,618)) * den(300)
  A(789) = cont_QA(wf(:,25),wf(:,618)) * den(301)
  A(790) = cont_QA(wf(:,213),wf(:,619)) * den(303)
  A(791) = cont_QA(wf(:,214),wf(:,619)) * den(304)
  A(792) = cont_QA(wf(:,216),wf(:,619)) * den(305)
  A(793) = cont_QA(wf(:,218),wf(:,619)) * den(304)
  A(794) = cont_QA(wf(:,216),wf(:,619)) * den(305)
  A(795) = cont_QA(wf(:,8),wf(:,620)) * den(306)
  A(796) = cont_QA(wf(:,11),wf(:,620)) * den(307)
  A(797) = cont_QA(wf(:,15),wf(:,620)) * den(308)
  A(798) = cont_QA(wf(:,20),wf(:,620)) * den(307)
  A(799) = cont_QA(wf(:,15),wf(:,620)) * den(308)
  A(800) = cont_QA(wf(:,222),wf(:,621)) * den(309)
  A(801) = cont_QA(wf(:,222),wf(:,622)) * den(310)
  A(802) = cont_QA(wf(:,225),wf(:,623)) * den(311)
  A(803) = cont_QA(wf(:,226),wf(:,623)) * den(312)
  A(804) = cont_QA(wf(:,222),wf(:,623)) * den(313)
  A(805) = cont_QA(wf(:,222),wf(:,624)) * den(310)
  A(806) = cont_QA(wf(:,222),wf(:,623)) * den(313)
  A(807) = cont_QA(wf(:,228),wf(:,623)) * den(312)
  A(808) = cont_QA(wf(:,222),wf(:,623)) * den(313)
  A(809) = cont_QA(wf(:,222),wf(:,625)) * den(313)
  A(810) = cont_QA(wf(:,213),wf(:,626)) * den(314)
  A(811) = cont_QA(wf(:,214),wf(:,626)) * den(315)
  A(812) = cont_QA(wf(:,216),wf(:,627)) * den(316)
  A(813) = cont_QA(wf(:,216),wf(:,628)) * den(317)
  A(814) = cont_QA(wf(:,216),wf(:,626)) * den(318)
  A(815) = cont_QA(wf(:,218),wf(:,626)) * den(315)
  A(816) = cont_QA(wf(:,216),wf(:,626)) * den(318)
  A(817) = cont_QA(wf(:,216),wf(:,629)) * den(317)
  A(818) = cont_QA(wf(:,216),wf(:,626)) * den(318)
  A(819) = cont_QA(wf(:,216),wf(:,630)) * den(318)
  A(820) = cont_QA(wf(:,377),wf(:,631)) * den(319)
  A(821) = cont_QA(wf(:,378),wf(:,631)) * den(319)
  A(822) = cont_QA(wf(:,42),wf(:,618)) * den(320)
  A(823) = cont_QA(wf(:,44),wf(:,618)) * den(320)
  A(824) = cont_QA(wf(:,377),wf(:,632)) * den(321)
  A(825) = cont_QA(wf(:,378),wf(:,632)) * den(321)
  A(826) = cont_QA(wf(:,216),wf(:,633)) * den(322)
  A(827) = cont_QA(wf(:,216),wf(:,634)) * den(322)
  A(828) = cont_QA(wf(:,257),wf(:,635)) * den(323)
  A(829) = cont_QA(wf(:,258),wf(:,635)) * den(323)
  A(830) = cont_QA(wf(:,52),wf(:,617)) * den(324)
  A(831) = cont_QA(wf(:,54),wf(:,617)) * den(324)
  A(832) = cont_QA(wf(:,257),wf(:,636)) * den(325)
  A(833) = cont_QA(wf(:,258),wf(:,636)) * den(325)
  A(834) = cont_QA(wf(:,15),wf(:,637)) * den(326)
  A(835) = cont_QA(wf(:,15),wf(:,638)) * den(326)
  A(836) = cont_QA(wf(:,390),wf(:,631)) * den(327)
  A(837) = cont_QA(wf(:,391),wf(:,631)) * den(328)
  A(838) = cont_QA(wf(:,388),wf(:,631)) * den(329)
  A(839) = cont_QA(wf(:,393),wf(:,631)) * den(328)
  A(840) = cont_QA(wf(:,388),wf(:,631)) * den(329)
  A(841) = cont_QA(wf(:,73),wf(:,635)) * den(330)
  A(842) = cont_QA(wf(:,75),wf(:,635)) * den(331)
  A(843) = cont_QA(wf(:,70),wf(:,635)) * den(332)
  A(844) = cont_QA(wf(:,78),wf(:,635)) * den(331)
  A(845) = cont_QA(wf(:,70),wf(:,635)) * den(332)
  A(846) = cont_QA(wf(:,388),wf(:,639)) * den(333)
  A(847) = cont_QA(wf(:,388),wf(:,640)) * den(334)
  A(848) = cont_QA(wf(:,390),wf(:,632)) * den(335)
  A(849) = cont_QA(wf(:,391),wf(:,632)) * den(336)
  A(850) = cont_QA(wf(:,388),wf(:,632)) * den(337)
  A(851) = cont_QA(wf(:,388),wf(:,641)) * den(334)
  A(852) = cont_QA(wf(:,388),wf(:,632)) * den(337)
  A(853) = cont_QA(wf(:,393),wf(:,632)) * den(336)
  A(854) = cont_QA(wf(:,388),wf(:,632)) * den(337)
  A(855) = cont_QA(wf(:,388),wf(:,642)) * den(337)
  A(856) = cont_QA(wf(:,380),wf(:,643)) * den(338)
  A(857) = cont_QA(wf(:,381),wf(:,643)) * den(339)
  A(858) = cont_QA(wf(:,48),wf(:,644)) * den(340)
  A(859) = cont_QA(wf(:,48),wf(:,645)) * den(341)
  A(860) = cont_QA(wf(:,48),wf(:,643)) * den(342)
  A(861) = cont_QA(wf(:,384),wf(:,643)) * den(339)
  A(862) = cont_QA(wf(:,48),wf(:,643)) * den(342)
  A(863) = cont_QA(wf(:,48),wf(:,646)) * den(341)
  A(864) = cont_QA(wf(:,48),wf(:,643)) * den(342)
  A(865) = cont_QA(wf(:,48),wf(:,647)) * den(342)
  A(866) = cont_QA(wf(:,380),wf(:,648)) * den(344)
  A(867) = cont_QA(wf(:,381),wf(:,648)) * den(345)
  A(868) = cont_QA(wf(:,48),wf(:,648)) * den(346)
  A(869) = cont_QA(wf(:,384),wf(:,648)) * den(345)
  A(870) = cont_QA(wf(:,48),wf(:,648)) * den(346)
  A(871) = cont_QA(wf(:,57),wf(:,649)) * den(347)
  A(872) = cont_QA(wf(:,59),wf(:,649)) * den(348)
  A(873) = cont_QA(wf(:,38),wf(:,649)) * den(349)
  A(874) = cont_QA(wf(:,65),wf(:,649)) * den(348)
  A(875) = cont_QA(wf(:,38),wf(:,649)) * den(349)
  A(876) = cont_VV(wf(:,650),wf(:,651)) * den(353)
  A(877) = cont_VV(wf(:,652),wf(:,653)) * den(357)
  A(878) = cont_VV(wf(:,81),wf(:,616)) * den(359)
  A(879) = cont_QA(wf(:,306),wf(:,654)) * den(361)
  A(880) = cont_QA(wf(:,307),wf(:,654)) * den(362)
  A(881) = cont_QA(wf(:,303),wf(:,654)) * den(363)
  A(882) = cont_QA(wf(:,309),wf(:,654)) * den(362)
  A(883) = cont_QA(wf(:,303),wf(:,654)) * den(363)
  A(884) = cont_QA(wf(:,106),wf(:,655)) * den(364)
  A(885) = cont_QA(wf(:,108),wf(:,655)) * den(365)
  A(886) = cont_QA(wf(:,102),wf(:,655)) * den(366)
  A(887) = cont_QA(wf(:,111),wf(:,655)) * den(365)
  A(888) = cont_QA(wf(:,102),wf(:,655)) * den(366)
  A(889) = cont_QA(wf(:,294),wf(:,656)) * den(368)
  A(890) = cont_QA(wf(:,295),wf(:,656)) * den(369)
  A(891) = cont_QA(wf(:,297),wf(:,656)) * den(370)
  A(892) = cont_QA(wf(:,299),wf(:,656)) * den(369)
  A(893) = cont_QA(wf(:,297),wf(:,656)) * den(370)
  A(894) = cont_QA(wf(:,85),wf(:,657)) * den(371)
  A(895) = cont_QA(wf(:,88),wf(:,657)) * den(372)
  A(896) = cont_QA(wf(:,92),wf(:,657)) * den(373)
  A(897) = cont_QA(wf(:,97),wf(:,657)) * den(372)
  A(898) = cont_QA(wf(:,92),wf(:,657)) * den(373)
  A(899) = cont_QA(wf(:,303),wf(:,658)) * den(374)
  A(900) = cont_QA(wf(:,303),wf(:,659)) * den(375)
  A(901) = cont_QA(wf(:,306),wf(:,660)) * den(376)
  A(902) = cont_QA(wf(:,307),wf(:,660)) * den(377)
  A(903) = cont_QA(wf(:,303),wf(:,660)) * den(378)
  A(904) = cont_QA(wf(:,303),wf(:,661)) * den(375)
  A(905) = cont_QA(wf(:,303),wf(:,660)) * den(378)
  A(906) = cont_QA(wf(:,309),wf(:,660)) * den(377)
  A(907) = cont_QA(wf(:,303),wf(:,660)) * den(378)
  A(908) = cont_QA(wf(:,303),wf(:,662)) * den(378)
  A(909) = cont_QA(wf(:,294),wf(:,663)) * den(379)
  A(910) = cont_QA(wf(:,295),wf(:,663)) * den(380)
  A(911) = cont_QA(wf(:,297),wf(:,664)) * den(381)
  A(912) = cont_QA(wf(:,297),wf(:,665)) * den(382)
  A(913) = cont_QA(wf(:,297),wf(:,663)) * den(383)
  A(914) = cont_QA(wf(:,299),wf(:,663)) * den(380)
  A(915) = cont_QA(wf(:,297),wf(:,663)) * den(383)
  A(916) = cont_QA(wf(:,297),wf(:,666)) * den(382)
  A(917) = cont_QA(wf(:,297),wf(:,663)) * den(383)
  A(918) = cont_QA(wf(:,297),wf(:,667)) * den(383)
  A(919) = cont_QA(wf(:,377),wf(:,668)) * den(384)
  A(920) = cont_QA(wf(:,378),wf(:,668)) * den(384)
  A(921) = cont_QA(wf(:,377),wf(:,669)) * den(385)
  A(922) = cont_QA(wf(:,378),wf(:,669)) * den(385)
  A(923) = cont_QA(wf(:,303),wf(:,670)) * den(386)
  A(924) = cont_QA(wf(:,303),wf(:,671)) * den(386)
  A(925) = cont_QA(wf(:,115),wf(:,657)) * den(387)
  A(926) = cont_QA(wf(:,117),wf(:,657)) * den(387)
  A(927) = cont_QA(wf(:,324),wf(:,672)) * den(388)
  A(928) = cont_QA(wf(:,325),wf(:,672)) * den(388)
  A(929) = cont_QA(wf(:,120),wf(:,656)) * den(389)
  A(930) = cont_QA(wf(:,123),wf(:,656)) * den(389)
  A(931) = cont_QA(wf(:,102),wf(:,673)) * den(390)
  A(932) = cont_QA(wf(:,102),wf(:,674)) * den(390)
  A(933) = cont_QA(wf(:,324),wf(:,675)) * den(391)
  A(934) = cont_QA(wf(:,325),wf(:,675)) * den(391)
  A(935) = cont_QA(wf(:,390),wf(:,668)) * den(392)
  A(936) = cont_QA(wf(:,391),wf(:,668)) * den(393)
  A(937) = cont_QA(wf(:,388),wf(:,668)) * den(394)
  A(938) = cont_QA(wf(:,393),wf(:,668)) * den(393)
  A(939) = cont_QA(wf(:,388),wf(:,668)) * den(394)
  A(940) = cont_QA(wf(:,388),wf(:,676)) * den(395)
  A(941) = cont_QA(wf(:,388),wf(:,677)) * den(396)
  A(942) = cont_QA(wf(:,390),wf(:,669)) * den(397)
  A(943) = cont_QA(wf(:,391),wf(:,669)) * den(398)
  A(944) = cont_QA(wf(:,388),wf(:,669)) * den(399)
  A(945) = cont_QA(wf(:,388),wf(:,678)) * den(396)
  A(946) = cont_QA(wf(:,388),wf(:,669)) * den(399)
  A(947) = cont_QA(wf(:,393),wf(:,669)) * den(398)
  A(948) = cont_QA(wf(:,388),wf(:,669)) * den(399)
  A(949) = cont_QA(wf(:,388),wf(:,679)) * den(399)
  A(950) = cont_QA(wf(:,126),wf(:,680)) * den(400)
  A(951) = cont_QA(wf(:,126),wf(:,681)) * den(401)
  A(952) = cont_QA(wf(:,509),wf(:,682)) * den(402)
  A(953) = cont_QA(wf(:,510),wf(:,682)) * den(403)
  A(954) = cont_QA(wf(:,126),wf(:,682)) * den(404)
  A(955) = cont_QA(wf(:,126),wf(:,683)) * den(401)
  A(956) = cont_QA(wf(:,126),wf(:,682)) * den(404)
  A(957) = cont_QA(wf(:,512),wf(:,682)) * den(403)
  A(958) = cont_QA(wf(:,126),wf(:,682)) * den(404)
  A(959) = cont_QA(wf(:,126),wf(:,684)) * den(404)
  A(960) = cont_QA(wf(:,509),wf(:,685)) * den(405)
  A(961) = cont_QA(wf(:,510),wf(:,685)) * den(406)
  A(962) = cont_QA(wf(:,126),wf(:,685)) * den(407)
  A(963) = cont_QA(wf(:,512),wf(:,685)) * den(406)
  A(964) = cont_QA(wf(:,126),wf(:,685)) * den(407)
  A(965) = cont_QA(wf(:,135),wf(:,672)) * den(408)
  A(966) = cont_QA(wf(:,137),wf(:,672)) * den(409)
  A(967) = cont_QA(wf(:,140),wf(:,672)) * den(410)
  A(968) = cont_QA(wf(:,143),wf(:,672)) * den(409)
  A(969) = cont_QA(wf(:,140),wf(:,672)) * den(410)
  A(970) = cont_QA(wf(:,129),wf(:,649)) * den(411)
  A(971) = cont_QA(wf(:,131),wf(:,649)) * den(412)
  A(972) = cont_QA(wf(:,113),wf(:,649)) * den(413)
  A(973) = cont_QA(wf(:,133),wf(:,649)) * den(412)
  A(974) = cont_QA(wf(:,113),wf(:,649)) * den(413)
  A(975) = cont_QA(wf(:,428),wf(:,686)) * den(414)
  A(976) = cont_QA(wf(:,429),wf(:,686)) * den(414)
  A(977) = cont_QA(wf(:,152),wf(:,655)) * den(415)
  A(978) = cont_QA(wf(:,154),wf(:,655)) * den(415)
  A(979) = cont_QA(wf(:,428),wf(:,687)) * den(416)
  A(980) = cont_QA(wf(:,429),wf(:,687)) * den(416)
  A(981) = cont_QA(wf(:,297),wf(:,688)) * den(417)
  A(982) = cont_QA(wf(:,297),wf(:,689)) * den(417)
  A(983) = cont_QA(wf(:,257),wf(:,690)) * den(418)
  A(984) = cont_QA(wf(:,258),wf(:,690)) * den(418)
  A(985) = cont_QA(wf(:,158),wf(:,654)) * den(419)
  A(986) = cont_QA(wf(:,160),wf(:,654)) * den(419)
  A(987) = cont_QA(wf(:,257),wf(:,691)) * den(420)
  A(988) = cont_QA(wf(:,258),wf(:,691)) * den(420)
  A(989) = cont_QA(wf(:,92),wf(:,692)) * den(421)
  A(990) = cont_QA(wf(:,92),wf(:,693)) * den(421)
  A(991) = cont_QA(wf(:,436),wf(:,686)) * den(422)
  A(992) = cont_QA(wf(:,437),wf(:,686)) * den(423)
  A(993) = cont_QA(wf(:,434),wf(:,686)) * den(424)
  A(994) = cont_QA(wf(:,439),wf(:,686)) * den(423)
  A(995) = cont_QA(wf(:,434),wf(:,686)) * den(424)
  A(996) = cont_QA(wf(:,73),wf(:,690)) * den(425)
  A(997) = cont_QA(wf(:,75),wf(:,690)) * den(426)
  A(998) = cont_QA(wf(:,70),wf(:,690)) * den(427)
  A(999) = cont_QA(wf(:,78),wf(:,690)) * den(426)
  A(1000) = cont_QA(wf(:,70),wf(:,690)) * den(427)
  A(1001) = cont_QA(wf(:,434),wf(:,694)) * den(428)
  A(1002) = cont_QA(wf(:,434),wf(:,695)) * den(429)
  A(1003) = cont_QA(wf(:,436),wf(:,687)) * den(430)
  A(1004) = cont_QA(wf(:,437),wf(:,687)) * den(431)
  A(1005) = cont_QA(wf(:,434),wf(:,687)) * den(432)
  A(1006) = cont_QA(wf(:,434),wf(:,696)) * den(429)
  A(1007) = cont_QA(wf(:,434),wf(:,687)) * den(432)
  A(1008) = cont_QA(wf(:,439),wf(:,687)) * den(431)
  A(1009) = cont_QA(wf(:,434),wf(:,687)) * den(432)
  A(1010) = cont_QA(wf(:,434),wf(:,697)) * den(432)
  A(1011) = cont_QA(wf(:,430),wf(:,643)) * den(433)
  A(1012) = cont_QA(wf(:,431),wf(:,643)) * den(434)
  A(1013) = cont_QA(wf(:,156),wf(:,644)) * den(435)
  A(1014) = cont_QA(wf(:,156),wf(:,645)) * den(436)
  A(1015) = cont_QA(wf(:,156),wf(:,643)) * den(437)
  A(1016) = cont_QA(wf(:,432),wf(:,643)) * den(434)
  A(1017) = cont_QA(wf(:,156),wf(:,643)) * den(437)
  A(1018) = cont_QA(wf(:,156),wf(:,646)) * den(436)
  A(1019) = cont_QA(wf(:,156),wf(:,643)) * den(437)
  A(1020) = cont_QA(wf(:,156),wf(:,647)) * den(437)
  A(1021) = cont_QA(wf(:,430),wf(:,648)) * den(438)
  A(1022) = cont_QA(wf(:,431),wf(:,648)) * den(439)
  A(1023) = cont_QA(wf(:,156),wf(:,648)) * den(440)
  A(1024) = cont_QA(wf(:,432),wf(:,648)) * den(439)
  A(1025) = cont_QA(wf(:,156),wf(:,648)) * den(440)
  A(1026) = cont_QA(wf(:,163),wf(:,698)) * den(441)
  A(1027) = cont_QA(wf(:,165),wf(:,698)) * den(442)
  A(1028) = cont_QA(wf(:,148),wf(:,698)) * den(443)
  A(1029) = cont_QA(wf(:,169),wf(:,698)) * den(442)
  A(1030) = cont_QA(wf(:,148),wf(:,698)) * den(443)
  A(1031) = cont_QA(wf(:,428),wf(:,699)) * den(444)
  A(1032) = cont_QA(wf(:,429),wf(:,699)) * den(444)
  A(1033) = cont_QA(wf(:,428),wf(:,700)) * den(445)
  A(1034) = cont_QA(wf(:,429),wf(:,700)) * den(445)
  A(1035) = cont_QA(wf(:,222),wf(:,701)) * den(446)
  A(1036) = cont_QA(wf(:,222),wf(:,702)) * den(446)
  A(1037) = cont_QA(wf(:,177),wf(:,620)) * den(447)
  A(1038) = cont_QA(wf(:,179),wf(:,620)) * den(447)
  A(1039) = cont_QA(wf(:,324),wf(:,703)) * den(448)
  A(1040) = cont_QA(wf(:,325),wf(:,703)) * den(448)
  A(1041) = cont_QA(wf(:,181),wf(:,619)) * den(449)
  A(1042) = cont_QA(wf(:,183),wf(:,619)) * den(449)
  A(1043) = cont_QA(wf(:,25),wf(:,704)) * den(450)
  A(1044) = cont_QA(wf(:,25),wf(:,705)) * den(450)
  A(1045) = cont_QA(wf(:,324),wf(:,706)) * den(451)
  A(1046) = cont_QA(wf(:,325),wf(:,706)) * den(451)
  A(1047) = cont_QA(wf(:,436),wf(:,699)) * den(452)
  A(1048) = cont_QA(wf(:,437),wf(:,699)) * den(453)
  A(1049) = cont_QA(wf(:,434),wf(:,699)) * den(454)
  A(1050) = cont_QA(wf(:,439),wf(:,699)) * den(453)
  A(1051) = cont_QA(wf(:,434),wf(:,699)) * den(454)
  A(1052) = cont_QA(wf(:,434),wf(:,707)) * den(455)
  A(1053) = cont_QA(wf(:,434),wf(:,708)) * den(456)
  A(1054) = cont_QA(wf(:,436),wf(:,700)) * den(457)
  A(1055) = cont_QA(wf(:,437),wf(:,700)) * den(458)
  A(1056) = cont_QA(wf(:,434),wf(:,700)) * den(459)
  A(1057) = cont_QA(wf(:,434),wf(:,709)) * den(456)
  A(1058) = cont_QA(wf(:,434),wf(:,700)) * den(459)
  A(1059) = cont_QA(wf(:,439),wf(:,700)) * den(458)
  A(1060) = cont_QA(wf(:,434),wf(:,700)) * den(459)
  A(1061) = cont_QA(wf(:,434),wf(:,710)) * den(459)
  A(1062) = cont_QA(wf(:,185),wf(:,680)) * den(460)
  A(1063) = cont_QA(wf(:,185),wf(:,681)) * den(461)
  A(1064) = cont_QA(wf(:,551),wf(:,682)) * den(462)
  A(1065) = cont_QA(wf(:,552),wf(:,682)) * den(463)
  A(1066) = cont_QA(wf(:,185),wf(:,682)) * den(464)
  A(1067) = cont_QA(wf(:,185),wf(:,683)) * den(461)
  A(1068) = cont_QA(wf(:,185),wf(:,682)) * den(464)
  A(1069) = cont_QA(wf(:,553),wf(:,682)) * den(463)
  A(1070) = cont_QA(wf(:,185),wf(:,682)) * den(464)
  A(1071) = cont_QA(wf(:,185),wf(:,684)) * den(464)
  A(1072) = cont_QA(wf(:,551),wf(:,685)) * den(465)
  A(1073) = cont_QA(wf(:,552),wf(:,685)) * den(466)
  A(1074) = cont_QA(wf(:,185),wf(:,685)) * den(467)
  A(1075) = cont_QA(wf(:,553),wf(:,685)) * den(466)
  A(1076) = cont_QA(wf(:,185),wf(:,685)) * den(467)
  A(1077) = cont_QA(wf(:,135),wf(:,703)) * den(468)
  A(1078) = cont_QA(wf(:,137),wf(:,703)) * den(469)
  A(1079) = cont_QA(wf(:,140),wf(:,703)) * den(470)
  A(1080) = cont_QA(wf(:,143),wf(:,703)) * den(469)
  A(1081) = cont_QA(wf(:,140),wf(:,703)) * den(470)
  A(1082) = cont_QA(wf(:,187),wf(:,698)) * den(471)
  A(1083) = cont_QA(wf(:,189),wf(:,698)) * den(472)
  A(1084) = cont_QA(wf(:,175),wf(:,698)) * den(473)
  A(1085) = cont_QA(wf(:,191),wf(:,698)) * den(472)
  A(1086) = cont_QA(wf(:,175),wf(:,698)) * den(473)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(1086)
  complex(REALKIND), intent(out) :: M1(12), M2(12)

  M1( 1) = ((A(8)+A(17))*f(1))/2._/**/REALKIND+((-A(129)-A(140))*f(2))/2._/**/REALKIND+((-A(9)-A(18)-A(130) &
        -A(141))*f(3))/2._/**/REALKIND+((-A(70)-A(72)-A(92)-A(94))*f(29))/2._/**/REALKIND+((-A(118)-A(120)-A(122) &
        -A(124))*f(29))/6._/**/REALKIND+((-A(69)-A(71)-A(91)-A(93))*f(34))/2._/**/REALKIND+((-A(117)-A(119)-A(121) &
        -A(123))*f(34))/6._/**/REALKIND+((A(4)+A(5)+A(13)+A(14))*f(38))/2._/**/REALKIND+((A(125)-A(126)+A(136) &
        -A(137))*f(44))/2._/**/REALKIND
  M1( 2) = ((A(64)+A(90)+A(107))*f(4))/4._/**/REALKIND+((A(10)+A(19)+A(133)+A(142))*f(4))/12._/**/REALKIND &
        -(CI*A(46)*f(5))/4._/**/REALKIND
  M1( 3) = ((-A(53)-A(62))*f(1))/2._/**/REALKIND+((A(77)+A(88))*f(2))/2._/**/REALKIND+((A(54)+A(63)+A(78) &
        +A(89))*f(3))/2._/**/REALKIND+((A(66)+A(68)+A(70)+A(72))*f(29))/6._/**/REALKIND+((A(21)+A(23)+A(122) &
        +A(124))*f(29))/2._/**/REALKIND+((A(65)+A(67)+A(69)+A(71))*f(34))/6._/**/REALKIND+((A(20)+A(22)+A(121) &
        +A(123))*f(34))/2._/**/REALKIND+((-A(49)-A(50)-A(58)-A(59))*f(38))/2._/**/REALKIND+((-A(73)+A(74)-A(84) &
        +A(85))*f(44))/2._/**/REALKIND
  M1( 4) = ((-A(55)-A(64)-A(81)-A(90))*f(4))/12._/**/REALKIND+((-A(19)-A(36)-A(142))*f(4))/4._/**/REALKIND &
        -(CI*A(1)*f(5))/4._/**/REALKIND
  M1( 5) = ((-A(51)-A(60))*f(1))/2._/**/REALKIND+((A(103)+A(112))*f(2))/2._/**/REALKIND+((A(52)+A(61)+A(104) &
        +A(113))*f(3))/2._/**/REALKIND+((A(92)+A(94)+A(96)+A(98))*f(29))/6._/**/REALKIND+((A(25)+A(27)+A(118) &
        +A(120))*f(29))/2._/**/REALKIND+((A(91)+A(93)+A(95)+A(97))*f(34))/6._/**/REALKIND+((A(24)+A(26)+A(117) &
        +A(119))*f(34))/2._/**/REALKIND+((-A(47)-A(48)-A(56)-A(57))*f(38))/2._/**/REALKIND+((-A(99)+A(100)-A(108) &
        +A(109))*f(44))/2._/**/REALKIND
  M1( 6) = ((-A(55)-A(64)-A(107)-A(116))*f(4))/12._/**/REALKIND+((-A(10)-A(45)-A(133))*f(4))/4._/**/REALKIND &
        +(CI*A(1)*f(5))/4._/**/REALKIND
  M1( 7) = ((A(6)+A(15))*f(1))/2._/**/REALKIND+((-A(32)-A(41))*f(2))/2._/**/REALKIND+((-A(7)-A(16)-A(33) &
        -A(42))*f(3))/2._/**/REALKIND+((-A(21)-A(23)-A(25)-A(27))*f(29))/6._/**/REALKIND+((-A(66)-A(68)-A(96) &
        -A(98))*f(29))/2._/**/REALKIND+((-A(20)-A(22)-A(24)-A(26))*f(34))/6._/**/REALKIND+((-A(65)-A(67)-A(95) &
        -A(97))*f(34))/2._/**/REALKIND+((A(2)+A(3)+A(11)+A(12))*f(38))/2._/**/REALKIND+((A(28)-A(29)+A(37) &
        -A(38))*f(44))/2._/**/REALKIND
  M1( 8) = ((A(10)+A(19)+A(36)+A(45))*f(4))/12._/**/REALKIND+((A(55)+A(81)+A(116))*f(4))/4._/**/REALKIND &
        +(CI*A(46)*f(5))/4._/**/REALKIND
  M1( 9) = ((A(51)+A(53)+A(60)+A(62)+A(79)+A(86)+A(105)+A(114))*f(1))/6._/**/REALKIND+((A(34)+A(43)+A(131) &
        +A(138))*f(1))/2._/**/REALKIND+((-A(77)-A(88)-A(103)-A(112))*f(2))/6._/**/REALKIND+((-A(52)-A(54)-A(61)-A(63)-A(78)-A(80) &
        -A(87)-A(89)-A(104)-A(106)-A(113)-A(115))*f(3))/6._/**/REALKIND+((-A(35)-A(44)-A(132)-A(139))*f(3))/2._/**/REALKIND &
        +((A(47)+A(48)+A(49)+A(50)+A(56)+A(57)+A(58)+A(59)+A(75)+A(76)+A(82)+A(83)+A(101)+A(102)+A(110) &
        +A(111))*f(38))/6._/**/REALKIND+((A(30)+A(31)+A(39)+A(40)+A(127)+A(128)+A(134)+A(135))*f(38))/2._/**/REALKIND+((A(73) &
        -A(74)+A(84)-A(85)+A(99)-A(100)+A(108)-A(109))*f(44))/6._/**/REALKIND
  M1(10) = ((A(55)+A(64)+A(81)+A(90)+A(107)+A(116))*f(4))/36._/**/REALKIND+((A(36)+A(45)+A(133)+A(142))*f(4))/12._/**/REALKIND
  M1(11) = ((-A(79)-A(86)-A(105)-A(114))*f(1))/2._/**/REALKIND+((-A(6)-A(8)-A(15)-A(17)-A(34)-A(43)-A(131) &
        -A(138))*f(1))/6._/**/REALKIND+((A(32)+A(41)+A(129)+A(140))*f(2))/6._/**/REALKIND+((A(80)+A(87)+A(106) &
        +A(115))*f(3))/2._/**/REALKIND+((A(7)+A(9)+A(16)+A(18)+A(33)+A(35)+A(42)+A(44)+A(130)+A(132)+A(139) &
        +A(141))*f(3))/6._/**/REALKIND+((-A(75)-A(76)-A(82)-A(83)-A(101)-A(102)-A(110)-A(111))*f(38))/2._/**/REALKIND+((-A(2)-A(3) &
        -A(4)-A(5)-A(11)-A(12)-A(13)-A(14)-A(30)-A(31)-A(39)-A(40)-A(127)-A(128)-A(134)-A(135))*f(38))/6._/**/REALKIND+((-A(28) &
        +A(29)-A(37)+A(38)-A(125)+A(126)-A(136)+A(137))*f(44))/6._/**/REALKIND
  M1(12) = ((-A(81)-A(90)-A(107)-A(116))*f(4))/12._/**/REALKIND+((-A(10)-A(19)-A(36)-A(45)-A(133)-A(142))*f(4))/36._/**/REALKIND

  M2( 1) = ((-A(782)-A(787)-A(806)-A(816))*f(6))/2._/**/REALKIND+((A(1056)+A(1068)+A(1074)+A(1084))*f(7))/2._/**/REALKIND+((A(274) &
        +A(284)+A(324)+A(348)+A(370)+A(422)+A(538)+A(592)+A(610)+A(644)+A(670)+A(716)-A(918)-A(959)-A(1010))*f(8))/4._/**/REALKIND &
        +((A(159)+A(169)+A(179)+A(189)+A(398)+A(408)+A(450)+A(460)+A(504)+A(514)+A(560)+A(570)+A(684)+A(694)+A(738)+A(748)-A(809) &
        -A(819)-A(1061)-A(1071))*f(8))/12._/**/REALKIND+((A(783)+A(788)+A(807)+A(817)+A(1057)+A(1069)+A(1075) &
        +A(1085))*f(8))/2._/**/REALKIND+(CI*(-A(296)-A(572)-A(650))*f(9))/4._/**/REALKIND+((A(166)+A(186))*f(10))/2._/**/REALKIND &
        +((-A(393)-A(405))*f(11))/2._/**/REALKIND+((-A(167)-A(187)-A(394)-A(406))*f(12))/2._/**/REALKIND+((A(735) &
        +A(745))*f(13))/2._/**/REALKIND+((-A(445)-A(691))*f(14))/2._/**/REALKIND+((-A(446)-A(692)-A(736) &
        -A(746))*f(15))/2._/**/REALKIND+((A(156)+A(176))*f(16))/2._/**/REALKIND+((-A(157)-A(177))*f(17))/2._/**/REALKIND+((A(501) &
        +A(511))*f(18))/2._/**/REALKIND+((-A(457)-A(557)-A(565)-A(679))*f(19))/2._/**/REALKIND+((-A(458)-A(502)-A(512)-A(558) &
        -A(566)-A(680))*f(20))/2._/**/REALKIND+(A(147)*f(21))/2._/**/REALKIND+((A(928)+A(930)+A(932)+A(934)+A(976)+A(978)+A(980) &
        +A(982))*f(30))/2._/**/REALKIND+((A(1032)+A(1034)+A(1036)+A(1038)+A(1040)+A(1042)+A(1044)+A(1046))*f(30))/6._/**/REALKIND &
        +((-A(302)-A(356))*f(31))/2._/**/REALKIND+((-A(384)-A(386))*f(31))/6._/**/REALKIND+((-A(438)-A(544)-A(546)-A(548)-A(550) &
        -A(672))*f(32))/6._/**/REALKIND+((-A(326)-A(518)-A(598)-A(600)-A(700)-A(702))*f(32))/2._/**/REALKIND+((-A(304)-A(328) &
        -A(354)-A(434)-A(436)-A(516)-A(646)-A(648))*f(33))/2._/**/REALKIND+((-A(382)-A(388)-A(440)-A(462)-A(464)-A(674)-A(696) &
        -A(698))*f(33))/6._/**/REALKIND+((-A(303)-A(327)-A(353)-A(433)-A(435)-A(515)-A(645)-A(647)+A(927)+A(929)+A(931)+A(933) &
        +A(975)+A(977)+A(979)+A(981))*f(35))/2._/**/REALKIND+((-A(381)-A(387)-A(439)-A(461)-A(463)-A(673)-A(695)-A(697)+A(1031) &
        +A(1033)+A(1035)+A(1037)+A(1039)+A(1041)+A(1043)+A(1045))*f(35))/6._/**/REALKIND+((-A(301)-A(355))*f(36))/2._/**/REALKIND &
        +((-A(383)-A(385))*f(36))/6._/**/REALKIND+((-A(437)-A(543)-A(545)-A(547)-A(549)-A(671))*f(37))/6._/**/REALKIND+((-A(325) &
        -A(517)-A(597)-A(599)-A(699)-A(701))*f(37))/2._/**/REALKIND+((-A(780)-A(781)-A(785)-A(786)-A(802)-A(803)-A(812) &
        -A(813))*f(39))/2._/**/REALKIND+((A(162)+A(163)+A(182)+A(183))*f(40))/2._/**/REALKIND+((A(731)+A(732)+A(741) &
        +A(742))*f(41))/2._/**/REALKIND+((A(152)+A(153)+A(172)+A(173))*f(42))/2._/**/REALKIND+((A(497)+A(498)+A(507) &
        +A(508))*f(43))/2._/**/REALKIND+((-A(1052)+A(1053)-A(1064)+A(1065)-A(1072)+A(1073)-A(1082)+A(1083))*f(45))/2._/**/REALKIND &
        +((A(389)-A(390)+A(401)-A(402))*f(46))/2._/**/REALKIND+((A(441)-A(442)+A(687)-A(688))*f(47))/2._/**/REALKIND+((A(453) &
        -A(454)+A(553)-A(554)+A(561)-A(562)+A(675)-A(676))*f(48))/2._/**/REALKIND+(A(144)*f(50))/2._/**/REALKIND
  M2( 2) = ((-A(888)-A(893)-A(917)-A(958)-A(964)-A(969)-A(995)-A(1009)-A(1030))*f(22))/4._/**/REALKIND+((-A(784)-A(789)-A(794) &
        -A(799)-A(808)-A(818)-A(1051)-A(1060)-A(1070)-A(1076)-A(1081)-A(1086))*f(22))/12._/**/REALKIND+(CI*(-A(876)+A(877) &
        +A(878))*f(23))/4._/**/REALKIND+((A(273)+A(283)+A(323)+A(369))*f(24))/4._/**/REALKIND+((A(158)+A(168)+A(178)+A(188)+A(397) &
        +A(407))*f(24))/12._/**/REALKIND-(CI*A(295)*f(25))/4._/**/REALKIND+((A(347)+A(421)+A(537)+A(591)+A(609)+A(643)+A(669) &
        +A(715))*f(26))/4._/**/REALKIND+((A(449)+A(459)+A(503)+A(513)+A(559)+A(569)+A(683)+A(693)+A(737) &
        +A(747))*f(26))/12._/**/REALKIND+(CI*(-A(571)-A(649))*f(27))/4._/**/REALKIND-(CI*A(254)*f(28))/4._/**/REALKIND
  M2( 3) = ((A(881)+A(886)+A(905)+A(915))*f(6))/2._/**/REALKIND+((-A(944)-A(956)-A(962)-A(972))*f(7))/2._/**/REALKIND+((-A(264) &
        -A(274)-A(284)-A(294)-A(314)-A(324)-A(338)-A(348)-A(582)-A(592)-A(610)-A(620)-A(634)-A(644)-A(660)-A(670)+A(908)+A(918) &
        +A(949)+A(959))*f(8))/12._/**/REALKIND+((-A(882)-A(887)-A(906)-A(916)-A(945)-A(957)-A(963)-A(973))*f(8))/2._/**/REALKIND &
        +((-A(169)-A(179)-A(209)-A(233)-A(408)-A(460)-A(488)-A(514)-A(560)-A(694)-A(748)-A(766)+A(819)+A(855) &
        +A(1071))*f(8))/4._/**/REALKIND+(CI*(-A(191)-A(494)-A(728))*f(9))/4._/**/REALKIND+((-A(271)-A(291))*f(10))/2._/**/REALKIND &
        +((A(309)+A(321))*f(11))/2._/**/REALKIND+((A(272)+A(292)+A(310)+A(322))*f(12))/2._/**/REALKIND+((-A(657) &
        -A(667))*f(13))/2._/**/REALKIND+((A(333)+A(641))*f(14))/2._/**/REALKIND+((A(334)+A(642)+A(658) &
        +A(668))*f(15))/2._/**/REALKIND+((-A(261)-A(281))*f(16))/2._/**/REALKIND+((A(262)+A(282))*f(17))/2._/**/REALKIND+((-A(579) &
        -A(589))*f(18))/2._/**/REALKIND+((A(345)+A(607)+A(615)+A(629))*f(19))/2._/**/REALKIND+((A(346)+A(580)+A(590)+A(608)+A(616) &
        +A(630))*f(20))/2._/**/REALKIND-(A(252)*f(21))/2._/**/REALKIND+((-A(920)-A(922)-A(924)-A(926)-A(928)-A(930)-A(932) &
        -A(934))*f(30))/6._/**/REALKIND+((-A(821)-A(823)-A(825)-A(827)-A(1040)-A(1042)-A(1044)-A(1046))*f(30))/2._/**/REALKIND &
        +((A(300)+A(302))*f(31))/6._/**/REALKIND+((A(195)+A(386))*f(31))/2._/**/REALKIND+((A(326)+A(594)+A(596)+A(598)+A(600) &
        +A(622))*f(32))/6._/**/REALKIND+((A(438)+A(468)+A(548)+A(550)+A(750)+A(752))*f(32))/2._/**/REALKIND+((A(298)+A(304)+A(328) &
        +A(350)+A(352)+A(624)+A(646)+A(648))*f(33))/6._/**/REALKIND+((A(193)+A(245)+A(247)+A(388)+A(440)+A(466)+A(696) &
        +A(698))*f(33))/2._/**/REALKIND+((A(297)+A(303)+A(327)+A(349)+A(351)+A(623)+A(645)+A(647)-A(919)-A(921)-A(923)-A(925) &
        -A(927)-A(929)-A(931)-A(933))*f(35))/6._/**/REALKIND+((A(192)+A(244)+A(246)+A(387)+A(439)+A(465)+A(695)+A(697)-A(820) &
        -A(822)-A(824)-A(826)-A(1039)-A(1041)-A(1043)-A(1045))*f(35))/2._/**/REALKIND+((A(299)+A(301))*f(36))/6._/**/REALKIND &
        +((A(194)+A(385))*f(36))/2._/**/REALKIND+((A(325)+A(593)+A(595)+A(597)+A(599)+A(621))*f(37))/6._/**/REALKIND+((A(437) &
        +A(467)+A(547)+A(549)+A(749)+A(751))*f(37))/2._/**/REALKIND+((A(879)+A(880)+A(884)+A(885)+A(901)+A(902)+A(911) &
        +A(912))*f(39))/2._/**/REALKIND+((-A(267)-A(268)-A(287)-A(288))*f(40))/2._/**/REALKIND+((-A(653)-A(654)-A(663) &
        -A(664))*f(41))/2._/**/REALKIND+((-A(257)-A(258)-A(277)-A(278))*f(42))/2._/**/REALKIND+((-A(575)-A(576)-A(585) &
        -A(586))*f(43))/2._/**/REALKIND+((A(940)-A(941)+A(952)-A(953)+A(960)-A(961)+A(970)-A(971))*f(45))/2._/**/REALKIND+(( &
        -A(305)+A(306)-A(317)+A(318))*f(46))/2._/**/REALKIND+((-A(329)+A(330)-A(637)+A(638))*f(47))/2._/**/REALKIND+((-A(341) &
        +A(342)-A(603)+A(604)-A(611)+A(612)-A(625)+A(626))*f(48))/2._/**/REALKIND-(A(249)*f(50))/2._/**/REALKIND
  M2( 4) = ((A(883)+A(888)+A(893)+A(898)+A(907)+A(917)+A(939)+A(948)+A(958)+A(964)+A(969)+A(974))*f(22))/12._/**/REALKIND+((A(789) &
        +A(794)+A(818)+A(840)+A(854)+A(875)+A(1070)+A(1076)+A(1081))*f(22))/4._/**/REALKIND+(CI*(A(777)-A(778) &
        +A(779))*f(23))/4._/**/REALKIND+((-A(263)-A(273)-A(283)-A(293)-A(313)-A(323))*f(24))/12._/**/REALKIND+((-A(168)-A(178) &
        -A(208)-A(407))*f(24))/4._/**/REALKIND-(CI*A(190)*f(25))/4._/**/REALKIND+((-A(337)-A(347)-A(581)-A(591)-A(609)-A(619) &
        -A(633)-A(643)-A(659)-A(669))*f(26))/12._/**/REALKIND+((-A(232)-A(459)-A(487)-A(513)-A(559)-A(693)-A(747) &
        -A(765))*f(26))/4._/**/REALKIND+(CI*(-A(493)-A(727))*f(27))/4._/**/REALKIND-(CI*A(149)*f(28))/4._/**/REALKIND
  M2( 5) = ((A(891)+A(896)+A(903)+A(913))*f(6))/2._/**/REALKIND+((-A(1005)-A(1015)-A(1023)-A(1028))*f(7))/2._/**/REALKIND+(( &
        -A(264)-A(274)-A(284)-A(294)-A(370)-A(380)-A(422)-A(432)-A(528)-A(538)-A(582)-A(592)-A(660)-A(670)-A(716)-A(726)+A(908) &
        +A(918)+A(1010)+A(1020))*f(8))/12._/**/REALKIND+((-A(892)-A(897)-A(904)-A(914)-A(1006)-A(1016)-A(1024) &
        -A(1029))*f(8))/2._/**/REALKIND+((-A(159)-A(189)-A(219)-A(243)-A(398)-A(450)-A(478)-A(504)-A(570)-A(684)-A(738)-A(776) &
        +A(809)+A(865)+A(1061))*f(8))/4._/**/REALKIND+(CI*(A(191)+A(494)+A(728))*f(9))/4._/**/REALKIND+((-A(259) &
        -A(279))*f(10))/2._/**/REALKIND+((A(365)+A(375))*f(11))/2._/**/REALKIND+((A(260)+A(280)+A(366) &
        +A(376))*f(12))/2._/**/REALKIND+((-A(577)-A(587))*f(13))/2._/**/REALKIND+((A(417)+A(523))*f(14))/2._/**/REALKIND+((A(418) &
        +A(524)+A(578)+A(588))*f(15))/2._/**/REALKIND+((-A(269)-A(289))*f(16))/2._/**/REALKIND+((A(270) &
        +A(290))*f(17))/2._/**/REALKIND+((-A(655)-A(665))*f(18))/2._/**/REALKIND+((A(427)+A(533)+A(711) &
        +A(721))*f(19))/2._/**/REALKIND+((A(428)+A(534)+A(656)+A(666)+A(712)+A(722))*f(20))/2._/**/REALKIND &
        -(A(251)*f(21))/2._/**/REALKIND+((-A(976)-A(978)-A(980)-A(982)-A(984)-A(986)-A(988)-A(990))*f(30))/6._/**/REALKIND+(( &
        -A(829)-A(831)-A(833)-A(835)-A(1032)-A(1034)-A(1036)-A(1038))*f(30))/2._/**/REALKIND+((A(356) &
        +A(360))*f(31))/6._/**/REALKIND+((A(199)+A(384))*f(31))/2._/**/REALKIND+((A(412)+A(518)+A(700)+A(702)+A(704) &
        +A(706))*f(32))/6._/**/REALKIND+((A(223)+A(544)+A(546)+A(672)+A(754)+A(756))*f(32))/2._/**/REALKIND+((A(354)+A(358)+A(410) &
        +A(434)+A(436)+A(516)+A(540)+A(542))*f(33))/6._/**/REALKIND+((A(197)+A(221)+A(382)+A(462)+A(464)+A(490)+A(492) &
        +A(674))*f(33))/2._/**/REALKIND+((A(353)+A(357)+A(409)+A(433)+A(435)+A(515)+A(539)+A(541)-A(975)-A(977)-A(979)-A(981) &
        -A(983)-A(985)-A(987)-A(989))*f(35))/6._/**/REALKIND+((A(196)+A(220)+A(381)+A(461)+A(463)+A(489)+A(491)+A(673)-A(828) &
        -A(830)-A(832)-A(834)-A(1031)-A(1033)-A(1035)-A(1037))*f(35))/2._/**/REALKIND+((A(355)+A(359))*f(36))/6._/**/REALKIND &
        +((A(198)+A(383))*f(36))/2._/**/REALKIND+((A(411)+A(517)+A(699)+A(701)+A(703)+A(705))*f(37))/6._/**/REALKIND+((A(222) &
        +A(543)+A(545)+A(671)+A(753)+A(755))*f(37))/2._/**/REALKIND+((A(889)+A(890)+A(894)+A(895)+A(899)+A(900)+A(909) &
        +A(910))*f(39))/2._/**/REALKIND+((-A(255)-A(256)-A(275)-A(276))*f(40))/2._/**/REALKIND+((-A(573)-A(574)-A(583) &
        -A(584))*f(41))/2._/**/REALKIND+((-A(265)-A(266)-A(285)-A(286))*f(42))/2._/**/REALKIND+((-A(651)-A(652)-A(661) &
        -A(662))*f(43))/2._/**/REALKIND+((A(1001)-A(1002)+A(1011)-A(1012)+A(1021)-A(1022)+A(1026)-A(1027))*f(45))/2._/**/REALKIND &
        +((-A(361)+A(362)-A(371)+A(372))*f(46))/2._/**/REALKIND+((-A(413)+A(414)-A(519)+A(520))*f(47))/2._/**/REALKIND+((-A(423) &
        +A(424)-A(529)+A(530)-A(707)+A(708)-A(717)+A(718))*f(48))/2._/**/REALKIND-(A(248)*f(50))/2._/**/REALKIND
  M2( 6) = ((A(883)+A(888)+A(893)+A(898)+A(907)+A(917)+A(995)+A(1000)+A(1009)+A(1019)+A(1025)+A(1030))*f(22))/12._/**/REALKIND &
        +((A(784)+A(799)+A(808)+A(845)+A(864)+A(870)+A(1051)+A(1060)+A(1086))*f(22))/4._/**/REALKIND+(CI*(-A(777)+A(778) &
        -A(779))*f(23))/4._/**/REALKIND+((-A(263)-A(273)-A(283)-A(293)-A(369)-A(379))*f(24))/12._/**/REALKIND+((-A(158)-A(188) &
        -A(218)-A(397))*f(24))/4._/**/REALKIND+(CI*A(190)*f(25))/4._/**/REALKIND+((-A(421)-A(431)-A(527)-A(537)-A(581)-A(591) &
        -A(659)-A(669)-A(715)-A(725))*f(26))/12._/**/REALKIND+((-A(242)-A(449)-A(477)-A(503)-A(569)-A(683)-A(737) &
        -A(775))*f(26))/4._/**/REALKIND+(CI*(A(493)+A(727))*f(27))/4._/**/REALKIND+(CI*A(149)*f(28))/4._/**/REALKIND
  M2( 7) = ((-A(792)-A(797)-A(804)-A(814))*f(6))/2._/**/REALKIND+((A(850)+A(860)+A(868)+A(873))*f(7))/2._/**/REALKIND+((A(159) &
        +A(169)+A(179)+A(189)+A(209)+A(219)+A(233)+A(243)+A(478)+A(488)+A(504)+A(514)+A(738)+A(748)+A(766)+A(776)-A(809)-A(819) &
        -A(855)-A(865))*f(8))/12._/**/REALKIND+((A(793)+A(798)+A(805)+A(815)+A(851)+A(861)+A(869)+A(874))*f(8))/2._/**/REALKIND &
        +((A(264)+A(294)+A(314)+A(338)+A(380)+A(432)+A(528)+A(582)+A(620)+A(634)+A(660)+A(726)-A(908)-A(949) &
        -A(1020))*f(8))/4._/**/REALKIND+(CI*(A(296)+A(572)+A(650))*f(9))/4._/**/REALKIND+((A(154)+A(174))*f(10))/2._/**/REALKIND &
        +((-A(204)-A(214))*f(11))/2._/**/REALKIND+((-A(155)-A(175)-A(205)-A(215))*f(12))/2._/**/REALKIND+((A(499) &
        +A(509))*f(13))/2._/**/REALKIND+((-A(228)-A(473))*f(14))/2._/**/REALKIND+((-A(229)-A(474)-A(500) &
        -A(510))*f(15))/2._/**/REALKIND+((A(164)+A(184))*f(16))/2._/**/REALKIND+((-A(165)-A(185))*f(17))/2._/**/REALKIND+((A(733) &
        +A(743))*f(18))/2._/**/REALKIND+((-A(238)-A(483)-A(761)-A(771))*f(19))/2._/**/REALKIND+((-A(239)-A(484)-A(734)-A(744) &
        -A(762)-A(772))*f(20))/2._/**/REALKIND+(A(146)*f(21))/2._/**/REALKIND+((A(821)+A(823)+A(825)+A(827)+A(829)+A(831)+A(833) &
        +A(835))*f(30))/6._/**/REALKIND+((A(920)+A(922)+A(924)+A(926)+A(984)+A(986)+A(988)+A(990))*f(30))/2._/**/REALKIND+(( &
        -A(195)-A(199))*f(31))/6._/**/REALKIND+((-A(300)-A(360))*f(31))/2._/**/REALKIND+((-A(412)-A(594)-A(596)-A(622)-A(704) &
        -A(706))*f(32))/2._/**/REALKIND+((-A(223)-A(468)-A(750)-A(752)-A(754)-A(756))*f(32))/6._/**/REALKIND+((-A(193)-A(197) &
        -A(221)-A(245)-A(247)-A(466)-A(490)-A(492))*f(33))/6._/**/REALKIND+((-A(298)-A(350)-A(352)-A(358)-A(410)-A(540)-A(542) &
        -A(624))*f(33))/2._/**/REALKIND+((-A(192)-A(196)-A(220)-A(244)-A(246)-A(465)-A(489)-A(491)+A(820)+A(822)+A(824)+A(826) &
        +A(828)+A(830)+A(832)+A(834))*f(35))/6._/**/REALKIND+((-A(297)-A(349)-A(351)-A(357)-A(409)-A(539)-A(541)-A(623)+A(919) &
        +A(921)+A(923)+A(925)+A(983)+A(985)+A(987)+A(989))*f(35))/2._/**/REALKIND+((-A(194)-A(198))*f(36))/6._/**/REALKIND+(( &
        -A(299)-A(359))*f(36))/2._/**/REALKIND+((-A(411)-A(593)-A(595)-A(621)-A(703)-A(705))*f(37))/2._/**/REALKIND+((-A(222) &
        -A(467)-A(749)-A(751)-A(753)-A(755))*f(37))/6._/**/REALKIND+((-A(790)-A(791)-A(795)-A(796)-A(800)-A(801)-A(810) &
        -A(811))*f(39))/2._/**/REALKIND+((A(150)+A(151)+A(170)+A(171))*f(40))/2._/**/REALKIND+((A(495)+A(496)+A(505) &
        +A(506))*f(41))/2._/**/REALKIND+((A(160)+A(161)+A(180)+A(181))*f(42))/2._/**/REALKIND+((A(729)+A(730)+A(739) &
        +A(740))*f(43))/2._/**/REALKIND+((-A(846)+A(847)-A(856)+A(857)-A(866)+A(867)-A(871)+A(872))*f(45))/2._/**/REALKIND &
        +((A(200)-A(201)+A(210)-A(211))*f(46))/2._/**/REALKIND+((A(224)-A(225)+A(469)-A(470))*f(47))/2._/**/REALKIND+((A(234) &
        -A(235)+A(479)-A(480)+A(757)-A(758)+A(767)-A(768))*f(48))/2._/**/REALKIND+(A(143)*f(50))/2._/**/REALKIND
  M2( 8) = ((-A(784)-A(789)-A(794)-A(799)-A(808)-A(818)-A(840)-A(845)-A(854)-A(864)-A(870)-A(875))*f(22))/12._/**/REALKIND+(( &
        -A(883)-A(898)-A(907)-A(939)-A(948)-A(974)-A(1000)-A(1019)-A(1025))*f(22))/4._/**/REALKIND+(CI*(A(876)-A(877) &
        -A(878))*f(23))/4._/**/REALKIND+((A(158)+A(168)+A(178)+A(188)+A(208)+A(218))*f(24))/12._/**/REALKIND+((A(263)+A(293) &
        +A(313)+A(379))*f(24))/4._/**/REALKIND+(CI*A(295)*f(25))/4._/**/REALKIND+((A(337)+A(431)+A(527)+A(581)+A(619)+A(633) &
        +A(659)+A(725))*f(26))/4._/**/REALKIND+((A(232)+A(242)+A(477)+A(487)+A(503)+A(513)+A(737)+A(747)+A(765) &
        +A(775))*f(26))/12._/**/REALKIND+(CI*(A(571)+A(649))*f(27))/4._/**/REALKIND+(CI*A(254)*f(28))/4._/**/REALKIND
  M2( 9) = ((-A(881)-A(886)-A(891)-A(896)-A(903)-A(905)-A(913)-A(915)-A(937)-A(946)-A(954)-A(967)-A(993)-A(998)-A(1007) &
        -A(1017))*f(6))/6._/**/REALKIND+((-A(838)-A(843)-A(852)-A(862)-A(1049)-A(1058)-A(1066)-A(1079))*f(6))/2._/**/REALKIND &
        +((A(944)+A(956)+A(962)+A(972)+A(1005)+A(1015)+A(1023)+A(1028))*f(7))/6._/**/REALKIND+((A(264)+A(274)+A(284)+A(294)+A(314) &
        +A(324)+A(338)+A(348)+A(370)+A(380)+A(422)+A(432)+A(528)+A(538)+A(582)+A(592)+A(610)+A(620)+A(634)+A(644)+A(660)+A(670) &
        +A(716)+A(726)-A(908)-A(918)-A(949)-A(959)-A(1010)-A(1020))*f(8))/36._/**/REALKIND+((A(882)+A(887)+A(892)+A(897)+A(904) &
        +A(906)+A(914)+A(916)+A(938)+A(945)+A(947)+A(955)+A(957)+A(963)+A(968)+A(973)+A(994)+A(999)+A(1006)+A(1008)+A(1016) &
        +A(1018)+A(1024)+A(1029))*f(8))/6._/**/REALKIND+((A(209)+A(219)+A(233)+A(243)+A(398)+A(408)+A(450)+A(460)+A(478)+A(488) &
        +A(560)+A(570)+A(684)+A(694)+A(766)+A(776)-A(855)-A(865)-A(1061)-A(1071))*f(8))/12._/**/REALKIND+((A(839)+A(844)+A(853) &
        +A(863)+A(1050)+A(1059)+A(1067)+A(1080))*f(8))/2._/**/REALKIND+((A(259)+A(271)+A(279)+A(291))*f(10))/6._/**/REALKIND+(( &
        -A(309)-A(321)-A(365)-A(375))*f(11))/6._/**/REALKIND+((-A(260)-A(272)-A(280)-A(292)-A(310)-A(322)-A(366) &
        -A(376))*f(12))/6._/**/REALKIND+((A(343)+A(429)+A(535)+A(577)+A(587)+A(605)+A(617)+A(631)+A(657)+A(667)+A(713) &
        +A(723))*f(13))/6._/**/REALKIND+((A(240)+A(455)+A(485)+A(555)+A(567)+A(681)+A(763)+A(773))*f(13))/2._/**/REALKIND+(( &
        -A(333)-A(417)-A(523)-A(641))*f(14))/6._/**/REALKIND+((-A(334)-A(344)-A(418)-A(430)-A(524)-A(536)-A(578)-A(588)-A(606) &
        -A(618)-A(632)-A(642)-A(658)-A(668)-A(714)-A(724))*f(15))/6._/**/REALKIND+((-A(241)-A(456)-A(486)-A(556)-A(568)-A(682) &
        -A(764)-A(774))*f(15))/2._/**/REALKIND+((A(261)+A(269)+A(281)+A(289)+A(311)+A(319)+A(367)+A(377))*f(16))/6._/**/REALKIND &
        +((A(206)+A(216)+A(395)+A(403))*f(16))/2._/**/REALKIND+((-A(262)-A(270)-A(282)-A(290)-A(312)-A(320)-A(368) &
        -A(378))*f(17))/6._/**/REALKIND+((-A(207)-A(217)-A(396)-A(404))*f(17))/2._/**/REALKIND+((A(335)+A(419)+A(525)+A(579) &
        +A(589)+A(639)+A(655)+A(665))*f(18))/6._/**/REALKIND+((A(230)+A(447)+A(475)+A(689))*f(18))/2._/**/REALKIND+((-A(345) &
        -A(427)-A(533)-A(607)-A(615)-A(629)-A(711)-A(721))*f(19))/6._/**/REALKIND+((-A(231)-A(448)-A(476) &
        -A(690))*f(20))/2._/**/REALKIND+((-A(336)-A(346)-A(420)-A(428)-A(526)-A(534)-A(580)-A(590)-A(608)-A(616)-A(630)-A(640) &
        -A(656)-A(666)-A(712)-A(722))*f(20))/6._/**/REALKIND+(A(148)*f(21))/2._/**/REALKIND+((A(251)+A(252) &
        +A(253))*f(21))/6._/**/REALKIND+((-A(879)-A(880)-A(884)-A(885)-A(889)-A(890)-A(894)-A(895)-A(899)-A(900)-A(901)-A(902) &
        -A(909)-A(910)-A(911)-A(912)-A(935)-A(936)-A(942)-A(943)-A(950)-A(951)-A(965)-A(966)-A(991)-A(992)-A(996)-A(997)-A(1003) &
        -A(1004)-A(1013)-A(1014))*f(39))/6._/**/REALKIND+((-A(836)-A(837)-A(841)-A(842)-A(848)-A(849)-A(858)-A(859)-A(1047) &
        -A(1048)-A(1054)-A(1055)-A(1062)-A(1063)-A(1077)-A(1078))*f(39))/2._/**/REALKIND+((A(255)+A(256)+A(267)+A(268)+A(275) &
        +A(276)+A(287)+A(288))*f(40))/6._/**/REALKIND+((A(339)+A(340)+A(425)+A(426)+A(531)+A(532)+A(573)+A(574)+A(583)+A(584) &
        +A(601)+A(602)+A(613)+A(614)+A(627)+A(628)+A(653)+A(654)+A(663)+A(664)+A(709)+A(710)+A(719)+A(720))*f(41))/6._/**/REALKIND &
        +((A(236)+A(237)+A(451)+A(452)+A(481)+A(482)+A(551)+A(552)+A(563)+A(564)+A(677)+A(678)+A(759)+A(760)+A(769) &
        +A(770))*f(41))/2._/**/REALKIND+((A(257)+A(258)+A(265)+A(266)+A(277)+A(278)+A(285)+A(286)+A(307)+A(308)+A(315)+A(316) &
        +A(363)+A(364)+A(373)+A(374))*f(42))/6._/**/REALKIND+((A(202)+A(203)+A(212)+A(213)+A(391)+A(392)+A(399) &
        +A(400))*f(42))/2._/**/REALKIND+((A(331)+A(332)+A(415)+A(416)+A(521)+A(522)+A(575)+A(576)+A(585)+A(586)+A(635)+A(636) &
        +A(651)+A(652)+A(661)+A(662))*f(43))/6._/**/REALKIND+((A(226)+A(227)+A(443)+A(444)+A(471)+A(472)+A(685) &
        +A(686))*f(43))/2._/**/REALKIND+((-A(940)+A(941)-A(952)+A(953)-A(960)+A(961)-A(970)+A(971)-A(1001)+A(1002)-A(1011)+A(1012) &
        -A(1021)+A(1022)-A(1026)+A(1027))*f(45))/6._/**/REALKIND+((A(305)-A(306)+A(317)-A(318)+A(361)-A(362)+A(371) &
        -A(372))*f(46))/6._/**/REALKIND+((A(329)-A(330)+A(413)-A(414)+A(519)-A(520)+A(637)-A(638))*f(47))/6._/**/REALKIND+((A(341) &
        -A(342)+A(423)-A(424)+A(529)-A(530)+A(603)-A(604)+A(611)-A(612)+A(625)-A(626)+A(707)-A(708)+A(717) &
        -A(718))*f(48))/6._/**/REALKIND+(A(145)*f(49))/2._/**/REALKIND+(A(250)*f(49))/6._/**/REALKIND+((A(248) &
        +A(249))*f(50))/6._/**/REALKIND
  M2(10) = ((-A(883)-A(888)-A(893)-A(898)-A(907)-A(917)-A(939)-A(948)-A(958)-A(964)-A(969)-A(974)-A(995)-A(1000)-A(1009)-A(1019) &
        -A(1025)-A(1030))*f(22))/36._/**/REALKIND+((-A(840)-A(845)-A(854)-A(864)-A(870)-A(875)-A(1051)-A(1060)-A(1070)-A(1076) &
        -A(1081)-A(1086))*f(22))/12._/**/REALKIND+((A(263)+A(273)+A(283)+A(293)+A(313)+A(323)+A(369) &
        +A(379))*f(24))/36._/**/REALKIND+((A(208)+A(218)+A(397)+A(407))*f(24))/12._/**/REALKIND+((A(337)+A(347)+A(421)+A(431) &
        +A(527)+A(537)+A(581)+A(591)+A(609)+A(619)+A(633)+A(643)+A(659)+A(669)+A(715)+A(725))*f(26))/36._/**/REALKIND+((A(232) &
        +A(242)+A(449)+A(459)+A(477)+A(487)+A(559)+A(569)+A(683)+A(693)+A(765)+A(775))*f(26))/12._/**/REALKIND
  M2(11) = ((A(937)+A(946)+A(954)+A(967)+A(993)+A(998)+A(1007)+A(1017))*f(6))/2._/**/REALKIND+((A(782)+A(787)+A(792)+A(797)+A(804) &
        +A(806)+A(814)+A(816)+A(838)+A(843)+A(852)+A(862)+A(1049)+A(1058)+A(1066)+A(1079))*f(6))/6._/**/REALKIND+((-A(850)-A(860) &
        -A(868)-A(873)-A(1056)-A(1068)-A(1074)-A(1084))*f(7))/6._/**/REALKIND+((-A(938)-A(947)-A(955)-A(968)-A(994)-A(999)-A(1008) &
        -A(1018))*f(8))/2._/**/REALKIND+((-A(314)-A(324)-A(338)-A(348)-A(370)-A(380)-A(422)-A(432)-A(528)-A(538)-A(610)-A(620) &
        -A(634)-A(644)-A(716)-A(726)+A(949)+A(959)+A(1010)+A(1020))*f(8))/12._/**/REALKIND+((-A(159)-A(169)-A(179)-A(189)-A(209) &
        -A(219)-A(233)-A(243)-A(398)-A(408)-A(450)-A(460)-A(478)-A(488)-A(504)-A(514)-A(560)-A(570)-A(684)-A(694)-A(738)-A(748) &
        -A(766)-A(776)+A(809)+A(819)+A(855)+A(865)+A(1061)+A(1071))*f(8))/36._/**/REALKIND+((-A(783)-A(788)-A(793)-A(798)-A(805) &
        -A(807)-A(815)-A(817)-A(839)-A(844)-A(851)-A(853)-A(861)-A(863)-A(869)-A(874)-A(1050)-A(1057)-A(1059)-A(1067)-A(1069) &
        -A(1075)-A(1080)-A(1085))*f(8))/6._/**/REALKIND+((-A(154)-A(166)-A(174)-A(186))*f(10))/6._/**/REALKIND+((A(204)+A(214) &
        +A(393)+A(405))*f(11))/6._/**/REALKIND+((A(155)+A(167)+A(175)+A(187)+A(205)+A(215)+A(394)+A(406))*f(12))/6._/**/REALKIND &
        +((-A(343)-A(429)-A(535)-A(605)-A(617)-A(631)-A(713)-A(723))*f(13))/2._/**/REALKIND+((-A(240)-A(455)-A(485)-A(499)-A(509) &
        -A(555)-A(567)-A(681)-A(735)-A(745)-A(763)-A(773))*f(13))/6._/**/REALKIND+((A(228)+A(445)+A(473) &
        +A(691))*f(14))/6._/**/REALKIND+((A(344)+A(430)+A(536)+A(606)+A(618)+A(632)+A(714)+A(724))*f(15))/2._/**/REALKIND+((A(229) &
        +A(241)+A(446)+A(456)+A(474)+A(486)+A(500)+A(510)+A(556)+A(568)+A(682)+A(692)+A(736)+A(746)+A(764) &
        +A(774))*f(15))/6._/**/REALKIND+((-A(311)-A(319)-A(367)-A(377))*f(16))/2._/**/REALKIND+((-A(156)-A(164)-A(176)-A(184) &
        -A(206)-A(216)-A(395)-A(403))*f(16))/6._/**/REALKIND+((A(312)+A(320)+A(368)+A(378))*f(17))/2._/**/REALKIND+((A(157)+A(165) &
        +A(177)+A(185)+A(207)+A(217)+A(396)+A(404))*f(17))/6._/**/REALKIND+((-A(335)-A(419)-A(525)-A(639))*f(18))/2._/**/REALKIND &
        +((-A(230)-A(447)-A(475)-A(501)-A(511)-A(689)-A(733)-A(743))*f(18))/6._/**/REALKIND+((A(238)+A(457)+A(483)+A(557)+A(565) &
        +A(679)+A(761)+A(771))*f(19))/6._/**/REALKIND+((A(336)+A(420)+A(526)+A(640))*f(20))/2._/**/REALKIND+((A(231)+A(239)+A(448) &
        +A(458)+A(476)+A(484)+A(502)+A(512)+A(558)+A(566)+A(680)+A(690)+A(734)+A(744)+A(762)+A(772))*f(20))/6._/**/REALKIND+(( &
        -A(146)-A(147)-A(148))*f(21))/6._/**/REALKIND-(A(253)*f(21))/2._/**/REALKIND+((A(935)+A(936)+A(942)+A(943)+A(950)+A(951) &
        +A(965)+A(966)+A(991)+A(992)+A(996)+A(997)+A(1003)+A(1004)+A(1013)+A(1014))*f(39))/2._/**/REALKIND+((A(780)+A(781)+A(785) &
        +A(786)+A(790)+A(791)+A(795)+A(796)+A(800)+A(801)+A(802)+A(803)+A(810)+A(811)+A(812)+A(813)+A(836)+A(837)+A(841)+A(842) &
        +A(848)+A(849)+A(858)+A(859)+A(1047)+A(1048)+A(1054)+A(1055)+A(1062)+A(1063)+A(1077)+A(1078))*f(39))/6._/**/REALKIND+(( &
        -A(150)-A(151)-A(162)-A(163)-A(170)-A(171)-A(182)-A(183))*f(40))/6._/**/REALKIND+((-A(339)-A(340)-A(425)-A(426)-A(531) &
        -A(532)-A(601)-A(602)-A(613)-A(614)-A(627)-A(628)-A(709)-A(710)-A(719)-A(720))*f(41))/2._/**/REALKIND+((-A(236)-A(237) &
        -A(451)-A(452)-A(481)-A(482)-A(495)-A(496)-A(505)-A(506)-A(551)-A(552)-A(563)-A(564)-A(677)-A(678)-A(731)-A(732)-A(741) &
        -A(742)-A(759)-A(760)-A(769)-A(770))*f(41))/6._/**/REALKIND+((-A(307)-A(308)-A(315)-A(316)-A(363)-A(364)-A(373) &
        -A(374))*f(42))/2._/**/REALKIND+((-A(152)-A(153)-A(160)-A(161)-A(172)-A(173)-A(180)-A(181)-A(202)-A(203)-A(212)-A(213) &
        -A(391)-A(392)-A(399)-A(400))*f(42))/6._/**/REALKIND+((-A(331)-A(332)-A(415)-A(416)-A(521)-A(522)-A(635) &
        -A(636))*f(43))/2._/**/REALKIND+((-A(226)-A(227)-A(443)-A(444)-A(471)-A(472)-A(497)-A(498)-A(507)-A(508)-A(685)-A(686) &
        -A(729)-A(730)-A(739)-A(740))*f(43))/6._/**/REALKIND+((A(846)-A(847)+A(856)-A(857)+A(866)-A(867)+A(871)-A(872)+A(1052) &
        -A(1053)+A(1064)-A(1065)+A(1072)-A(1073)+A(1082)-A(1083))*f(45))/6._/**/REALKIND+((-A(200)+A(201)-A(210)+A(211)-A(389) &
        +A(390)-A(401)+A(402))*f(46))/6._/**/REALKIND+((-A(224)+A(225)-A(441)+A(442)-A(469)+A(470)-A(687) &
        +A(688))*f(47))/6._/**/REALKIND+((-A(234)+A(235)-A(453)+A(454)-A(479)+A(480)-A(553)+A(554)-A(561)+A(562)-A(675)+A(676) &
        -A(757)+A(758)-A(767)+A(768))*f(48))/6._/**/REALKIND-(A(145)*f(49))/6._/**/REALKIND-(A(250)*f(49))/2._/**/REALKIND+(( &
        -A(143)-A(144))*f(50))/6._/**/REALKIND
  M2(12) = ((A(939)+A(948)+A(958)+A(964)+A(969)+A(974)+A(995)+A(1000)+A(1009)+A(1019)+A(1025)+A(1030))*f(22))/12._/**/REALKIND &
        +((A(784)+A(789)+A(794)+A(799)+A(808)+A(818)+A(840)+A(845)+A(854)+A(864)+A(870)+A(875)+A(1051)+A(1060)+A(1070)+A(1076) &
        +A(1081)+A(1086))*f(22))/36._/**/REALKIND+((-A(313)-A(323)-A(369)-A(379))*f(24))/12._/**/REALKIND+((-A(158)-A(168)-A(178) &
        -A(188)-A(208)-A(218)-A(397)-A(407))*f(24))/36._/**/REALKIND+((-A(337)-A(347)-A(421)-A(431)-A(527)-A(537)-A(609)-A(619) &
        -A(633)-A(643)-A(715)-A(725))*f(26))/12._/**/REALKIND+((-A(232)-A(242)-A(449)-A(459)-A(477)-A(487)-A(503)-A(513)-A(559) &
        -A(569)-A(683)-A(693)-A(737)-A(747)-A(765)-A(775))*f(26))/36._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pptttt_ew_tttxtxbbx_1_/**/REALKIND
