
module ol_colourmatrix_pptttt_ew_tttxtxag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(92,4), K2(4,4), KL(4,4)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1( 1,:) = [  36,  12,  12,   0]
  K1( 2,:) = [  12,  36,   0,  12]
  K1( 3,:) = [  12,   0,  36,  12]
  K1( 4,:) = [   0,  12,  12,  36]
  K1( 5,:) = [  48,  16,  16,   0]
  K1( 6,:) = [  16,  48,   0,  16]
  K1( 7,:) = [  16,   0,  48,  16]
  K1( 8,:) = [   0,  16,  16,  48]
  K1( 9,:) = [   0,  16,  -2,   6]
  K1(10,:) = [  16,   0,   6,  -2]
  K1(11,:) = [  -2,   6,   0,  16]
  K1(12,:) = [   6,  -2,  16,   0]
  K1(13,:) = [  48,  16,  16,   0]
  K1(14,:) = [  16,  48,   0,  16]
  K1(15,:) = [  16,   0,  48,  16]
  K1(16,:) = [   0,  16,  16,  48]
  K1(17,:) = [   6,   2,   2,   0]
  K1(18,:) = [   2,   0,  -6, -16]
  K1(19,:) = [   2,  -6,   0, -16]
  K1(20,:) = [   0, -16, -16, -48]
  K1(21,:) = [   0,   2, -16,  -6]
  K1(22,:) = [   2,   6,   0,   2]
  K1(23,:) = [ -16,   0, -48, -16]
  K1(24,:) = [  -6,   2, -16,   0]
  K1(25,:) = [  48,  16,  16,   0]
  K1(26,:) = [  16,  48,   0,  16]
  K1(27,:) = [  16,   0,  48,  16]
  K1(28,:) = [   0,  16,  16,  48]
  K1(29,:) = [   0, -16,   2,  -6]
  K1(30,:) = [ -16, -48,   0, -16]
  K1(31,:) = [   2,   0,   6,   2]
  K1(32,:) = [  -6, -16,   2,   0]
  K1(33,:) = [ -48, -16, -16,   0]
  K1(34,:) = [ -16,   0,  -6,   2]
  K1(35,:) = [ -16,  -6,   0,   2]
  K1(36,:) = [   0,   2,   2,   6]
  K1(37,:) = [   0,  -2,  16,   6]
  K1(38,:) = [  -2,   0,   6,  16]
  K1(39,:) = [  16,   6,   0,  -2]
  K1(40,:) = [   6,  16,  -2,   0]
  K1(41,:) = [  48,  16,  16,   0]
  K1(42,:) = [  16,  48,   0,  16]
  K1(43,:) = [  16,   0,  48,  16]
  K1(44,:) = [   0,  16,  16,  48]
  K1(45,:) = [   0,   0,   0,   0]
  K1(46,:) = [   0,   0,   0,   0]
  K1(47,:) = [   0,   0,   0,   0]
  K1(48,:) = [   0,   0,   0,   0]
  K1(49,:) = [   0,   0,   0,   0]
  K1(50,:) = [   0,   0,   0,   0]
  K1(51,:) = [   0,   0,   0,   0]
  K1(52,:) = [   0,   0,   0,   0]
  K1(53,:) = [   0,   0,   0,   0]
  K1(54,:) = [   0,   0,   0,   0]
  K1(55,:) = [   0,   0,   0,   0]
  K1(56,:) = [   0,   0,   0,   0]
  K1(57,:) = [   0,   0,   0,   0]
  K1(58,:) = [   0,   0,   0,   0]
  K1(59,:) = [   0,   0,   0,   0]
  K1(60,:) = [   0,   0,   0,   0]
  K1(61,:) = [   0,   0,   0,   0]
  K1(62,:) = [   0,   0,   0,   0]
  K1(63,:) = [   0,   0,   0,   0]
  K1(64,:) = [   0,   0,   0,   0]
  K1(65,:) = [ -54, -18, -18,   0]
  K1(66,:) = [ -18,   0,   0,  18]
  K1(67,:) = [ -18,   0, -54, -18]
  K1(68,:) = [   0,  18, -18,   0]
  K1(69,:) = [   0, -18,  18,   0]
  K1(70,:) = [ -18, -54,   0, -18]
  K1(71,:) = [  18,   0,   0, -18]
  K1(72,:) = [   0, -18, -18, -54]
  K1(73,:) = [ -54, -18, -18,   0]
  K1(74,:) = [ -18, -54,   0, -18]
  K1(75,:) = [ -18,   0,   0,  18]
  K1(76,:) = [   0, -18,  18,   0]
  K1(77,:) = [   0,  18, -18,   0]
  K1(78,:) = [  18,   0,   0, -18]
  K1(79,:) = [ -18,   0, -54, -18]
  K1(80,:) = [   0, -18, -18, -54]
  K1(81,:) = [   0,   0,   0,   0]
  K1(82,:) = [   0,   0,   0,   0]
  K1(83,:) = [   0,   0,   0,   0]
  K1(84,:) = [   0,   0,   0,   0]
  K1(85,:) = [ 108,  36,  36,   0]
  K1(86,:) = [  36, 108,   0,  36]
  K1(87,:) = [  36,   0, 108,  36]
  K1(88,:) = [   0,  36,  36, 108]
  K1(89,:) = [   0,   0,   0,   0]
  K1(90,:) = [   0,   0,   0,   0]
  K1(91,:) = [   0,   0,   0,   0]
  K1(92,:) = [   0,   0,   0,   0]
  K1 = (1._/**/REALKIND / 3) * K1

  K2(1,:) = [ 12,  4,  4,  0]
  K2(2,:) = [  4, 12,  0,  4]
  K2(3,:) = [  4,  0, 12,  4]
  K2(4,:) = [  0,  4,  4, 12]

  KL(1,:) = [ 12,  4,  4,  0]
  KL(2,:) = [  4, 12,  0,  4]
  KL(3,:) = [  4,  0, 12,  4]
  KL(4,:) = [  0,  4,  4, 12]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_ew_tttxtxag_1_/**/REALKIND



module ol_forced_parameters_pptttt_ew_tttxtxag_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_ew_tttxtxag_1_/**/REALKIND

module ol_loop_pptttt_ew_tttxtxag_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(20), c(29)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:464)
  ! denominators
  complex(REALKIND), save :: den(565)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(4,64), Mct(4,64), Mcol_loop(4,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = (2*CI*eQED*gQCD**3)/3._/**/REALKIND
    f( 2) = (2*eQED*gQCD**3)/3._/**/REALKIND
    f( 3) = (2*CI*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 4) = CI*countertermnorm*eQED*gQCD**5
    f( 5) = (2*countertermnorm*eQED*gQCD**5)/3._/**/REALKIND
    f( 6) = (2*CI*countertermnorm*ctGtt*eQED*gQCD**5)/3._/**/REALKIND
    f( 7) = (2*countertermnorm*ctGtt*eQED*gQCD**5)/3._/**/REALKIND
    f( 8) = (2*CI*countertermnorm*ctVtt*eQED*gQCD**5)/3._/**/REALKIND
    f( 9) = (2*countertermnorm*ctVtt*eQED*gQCD**5)/3._/**/REALKIND
    f(10) = (2*countertermnorm*ctVVV*eQED*gQCD**5)/3._/**/REALKIND
    f(11) = (CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(12) = (2*CI*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(13) = (eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(14) = (2*eQED*gQCD**5*integralnorm*SwB)/3._/**/REALKIND
    f(15) = (CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(16) = (2*CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(17) = (4*CI*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(18) = (eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(19) = (2*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND
    f(20) = (4*eQED*gQCD**5*integralnorm*SwF)/3._/**/REALKIND

  c = [ 27*CI*f(11), 54*CI*f(11), 3*CI*f(12), 9*CI*f(12), 24*CI*f(12), 27*CI*f(12), 54*CI*f(12), 18*f(13), 54*f(13), f(14) &
    , 3*f(14), 6*f(14), 8*f(14), 9*f(14), 10*f(14), 18*f(14), 21*f(14), 24*f(14), 27*f(14), 54*f(14), 9*CI*f(15), 9*CI*f(16) &
    , 9*CI*f(17), 3*f(18), 9*f(18), 3*f(19), 9*f(19), 3*f(20), 9*f(20) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(4), M2(4)
  complex(REALKIND) :: A(388)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_VQ_A(wf(:,-4),wf(:,-1),wf(:,2))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,3))
  call prop_Q_A(wf(:,2),Q(:,18),MT,1_intkind1,wf(:,4))
  call prop_A_Q(wf(:,3),Q(:,40),MT,1_intkind1,wf(:,5))
  call vert_VQ_A(wf(:,1),wf(:,4),wf(:,6))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,7))
  call vert_VQ_A(wf(:,-5),wf(:,4),wf(:,8))
  call prop_A_Q(wf(:,7),Q(:,13),MT,1_intkind1,wf(:,9))
  call vert_QA_V(wf(:,4),wf(:,-3),wf(:,10))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,11))
  call vert_VQ_A(wf(:,-5),wf(:,-1),wf(:,12))
  call vert_AV_Q(wf(:,-3),wf(:,-4),wf(:,13))
  call prop_Q_A(wf(:,12),Q(:,34),MT,1_intkind1,wf(:,14))
  call prop_A_Q(wf(:,13),Q(:,24),MT,1_intkind1,wf(:,15))
  call vert_VQ_A(wf(:,1),wf(:,14),wf(:,16))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,17))
  call vert_AV_Q(wf(:,15),wf(:,-5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,7),MT,1_intkind1,wf(:,19))
  call vert_QA_V(wf(:,-1),wf(:,15),wf(:,20))
  call vert_VQ_A(wf(:,-4),wf(:,14),wf(:,21))
  call vert_AV_Q(wf(:,5),wf(:,-4),wf(:,22))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,23))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,24))
  call prop_Q_A(wf(:,23),Q(:,17),MT,1_intkind1,wf(:,25))
  call vert_VQ_A(wf(:,24),wf(:,25),wf(:,26))
  call vert_QA_V(wf(:,25),wf(:,-3),wf(:,27))
  call vert_UV_W(wf(:,24),Q(:,6),wf(:,-5),Q(:,32),wf(:,28))
  call vert_AV_Q(wf(:,-3),wf(:,24),wf(:,29))
  call vert_VQ_A(wf(:,-5),wf(:,25),wf(:,30))
  call prop_A_Q(wf(:,29),Q(:,14),MT,1_intkind1,wf(:,31))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,32))
  call prop_Q_A(wf(:,32),Q(:,33),MT,1_intkind1,wf(:,33))
  call vert_VQ_A(wf(:,24),wf(:,33),wf(:,34))
  call vert_VQ_A(wf(:,24),wf(:,0),wf(:,35))
  call prop_Q_A(wf(:,35),Q(:,7),MT,1_intkind1,wf(:,36))
  call vert_QA_V(wf(:,0),wf(:,15),wf(:,37))
  call vert_VQ_A(wf(:,-4),wf(:,33),wf(:,38))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,39))
  call vert_AV_Q(wf(:,-2),wf(:,-5),wf(:,40))
  call prop_A_Q(wf(:,40),Q(:,36),MT,1_intkind1,wf(:,41))
  call vert_VQ_A(wf(:,39),wf(:,4),wf(:,42))
  call vert_AV_Q(wf(:,-2),wf(:,39),wf(:,43))
  call prop_A_Q(wf(:,43),Q(:,13),MT,1_intkind1,wf(:,44))
  call vert_QA_V(wf(:,4),wf(:,-2),wf(:,45))
  call vert_UV_W(wf(:,39),Q(:,9),wf(:,-5),Q(:,32),wf(:,46))
  call vert_AV_Q(wf(:,-2),wf(:,-4),wf(:,47))
  call prop_A_Q(wf(:,47),Q(:,20),MT,1_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,39),wf(:,14),wf(:,49))
  call vert_VQ_A(wf(:,39),wf(:,-1),wf(:,50))
  call vert_AV_Q(wf(:,48),wf(:,-5),wf(:,51))
  call prop_Q_A(wf(:,50),Q(:,11),MT,1_intkind1,wf(:,52))
  call vert_QA_V(wf(:,-1),wf(:,48),wf(:,53))
  call vert_AV_Q(wf(:,41),wf(:,-4),wf(:,54))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,55))
  call vert_VQ_A(wf(:,55),wf(:,25),wf(:,56))
  call vert_QA_V(wf(:,25),wf(:,-2),wf(:,57))
  call vert_UV_W(wf(:,55),Q(:,10),wf(:,-5),Q(:,32),wf(:,58))
  call vert_AV_Q(wf(:,-2),wf(:,55),wf(:,59))
  call prop_A_Q(wf(:,59),Q(:,14),MT,1_intkind1,wf(:,60))
  call vert_VQ_A(wf(:,55),wf(:,33),wf(:,61))
  call vert_VQ_A(wf(:,55),wf(:,0),wf(:,62))
  call prop_Q_A(wf(:,62),Q(:,11),MT,1_intkind1,wf(:,63))
  call vert_QA_V(wf(:,0),wf(:,48),wf(:,64))
  call vert_QA_V(wf(:,14),wf(:,-3),wf(:,65))
  call vert_QA_V(wf(:,14),wf(:,-2),wf(:,66))
  call vert_QA_V(wf(:,-1),wf(:,41),wf(:,67))
  call vert_QA_V(wf(:,-1),wf(:,5),wf(:,68))
  call vert_QA_V(wf(:,33),wf(:,-2),wf(:,69))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,70))
  call vert_QA_V(wf(:,0),wf(:,41),wf(:,71))
  call vert_QA_V(wf(:,0),wf(:,5),wf(:,72))
  call counter_VGG_G(ctAGGG,wf(:,-4),wf(:,1),wf(:,-5),wf(:,73))
  call counter_VGG_G(ctAGGG,wf(:,-4),wf(:,-5),wf(:,1),wf(:,74))
  call counter_VGG_G(ctAGGG,wf(:,-4),wf(:,39),wf(:,-5),wf(:,75))
  call counter_VGG_G(ctAGGG,wf(:,-4),wf(:,-5),wf(:,39),wf(:,76))
  call counter_VQ_A(wf(:,1),wf(:,4),wf(:,77))
  call counter_VQ_A(wf(:,-5),wf(:,4),wf(:,78))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,79))
  call counter_VQ_A(wf(:,1),wf(:,14),wf(:,80))
  call counter_AV_Q(wf(:,15),wf(:,-5),wf(:,81))
  call counter_VQ_A(wf(:,-4),wf(:,14),wf(:,82))
  call counter_AV_Q(wf(:,5),wf(:,-4),wf(:,83))
  call counter_QA_V(wf(:,4),wf(:,-3),wf(:,84))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,85))
  call prop_Q_A(wf(:,8),Q(:,50),MT,1_intkind1,wf(:,86))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,87))
  call prop_A_Q(wf(:,87),Q(:,40),MT,1_intkind1,wf(:,88))
  call prop_Q_A(wf(:,21),Q(:,50),MT,1_intkind1,wf(:,89))
  call vert_AV_Q(wf(:,88),wf(:,-4),wf(:,90))
  call counter_AV_Q(wf(:,-3),wf(:,-4),wf(:,91))
  call prop_A_Q(wf(:,91),Q(:,24),MT,1_intkind1,wf(:,92))
  call vert_AV_Q(wf(:,92),wf(:,-5),wf(:,93))
  call vert_QA_V(wf(:,-1),wf(:,92),wf(:,94))
  call counter_VQ_A(wf(:,24),wf(:,25),wf(:,95))
  call counter_UV_W(wf(:,24),Q(:,6),wf(:,-5),Q(:,32),wf(:,96))
  call counter_VQ_A(wf(:,-5),wf(:,25),wf(:,97))
  call counter_VQ_A(wf(:,24),wf(:,33),wf(:,98))
  call counter_VQ_A(wf(:,-4),wf(:,33),wf(:,99))
  call counter_AV_Q(wf(:,-3),wf(:,24),wf(:,100))
  call prop_Q_A(wf(:,30),Q(:,49),MT,1_intkind1,wf(:,101))
  call counter_QA_V(wf(:,25),wf(:,-3),wf(:,102))
  call prop_Q_A(wf(:,38),Q(:,49),MT,1_intkind1,wf(:,103))
  call vert_QA_V(wf(:,0),wf(:,92),wf(:,104))
  call counter_VQ_A(wf(:,39),wf(:,4),wf(:,105))
  call counter_UV_W(wf(:,39),Q(:,9),wf(:,-5),Q(:,32),wf(:,106))
  call counter_VQ_A(wf(:,39),wf(:,14),wf(:,107))
  call counter_AV_Q(wf(:,48),wf(:,-5),wf(:,108))
  call counter_AV_Q(wf(:,41),wf(:,-4),wf(:,109))
  call counter_VQ_A(wf(:,55),wf(:,25),wf(:,110))
  call counter_UV_W(wf(:,55),Q(:,10),wf(:,-5),Q(:,32),wf(:,111))
  call counter_VQ_A(wf(:,55),wf(:,33),wf(:,112))
  call counter_QA_V(wf(:,14),wf(:,-3),wf(:,113))
  call vert_QA_V(wf(:,-1),wf(:,88),wf(:,114))
  call counter_QA_V(wf(:,33),wf(:,-3),wf(:,115))
  call vert_QA_V(wf(:,0),wf(:,88),wf(:,116))
  call counter_QA_V(wf(:,4),wf(:,-2),wf(:,117))
  call counter_AV_Q(wf(:,-2),wf(:,39),wf(:,118))
  call counter_AV_Q(wf(:,-2),wf(:,-5),wf(:,119))
  call prop_A_Q(wf(:,119),Q(:,36),MT,1_intkind1,wf(:,120))
  call vert_AV_Q(wf(:,120),wf(:,-4),wf(:,121))
  call counter_AV_Q(wf(:,-2),wf(:,-4),wf(:,122))
  call prop_A_Q(wf(:,122),Q(:,20),MT,1_intkind1,wf(:,123))
  call vert_AV_Q(wf(:,123),wf(:,-5),wf(:,124))
  call vert_QA_V(wf(:,-1),wf(:,123),wf(:,125))
  call counter_AV_Q(wf(:,-2),wf(:,55),wf(:,126))
  call counter_QA_V(wf(:,25),wf(:,-2),wf(:,127))
  call vert_QA_V(wf(:,0),wf(:,123),wf(:,128))
  call counter_QA_V(wf(:,14),wf(:,-2),wf(:,129))
  call vert_QA_V(wf(:,-1),wf(:,120),wf(:,130))
  call counter_QA_V(wf(:,33),wf(:,-2),wf(:,131))
  call vert_QA_V(wf(:,0),wf(:,120),wf(:,132))
  call counter_QA_V(wf(:,-1),wf(:,15),wf(:,133))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,134))
  call prop_A_Q(wf(:,18),Q(:,56),MT,1_intkind1,wf(:,135))
  call counter_VQ_A(wf(:,-5),wf(:,-1),wf(:,136))
  call prop_Q_A(wf(:,136),Q(:,34),MT,1_intkind1,wf(:,137))
  call vert_VQ_A(wf(:,1),wf(:,137),wf(:,138))
  call prop_A_Q(wf(:,22),Q(:,56),MT,1_intkind1,wf(:,139))
  call vert_VQ_A(wf(:,-4),wf(:,137),wf(:,140))
  call counter_VQ_A(wf(:,-4),wf(:,-1),wf(:,141))
  call prop_Q_A(wf(:,141),Q(:,18),MT,1_intkind1,wf(:,142))
  call vert_VQ_A(wf(:,1),wf(:,142),wf(:,143))
  call vert_VQ_A(wf(:,-5),wf(:,142),wf(:,144))
  call vert_QA_V(wf(:,142),wf(:,-3),wf(:,145))
  call counter_QA_V(wf(:,-1),wf(:,48),wf(:,146))
  call counter_VQ_A(wf(:,39),wf(:,-1),wf(:,147))
  call prop_A_Q(wf(:,51),Q(:,52),MT,1_intkind1,wf(:,148))
  call vert_VQ_A(wf(:,39),wf(:,137),wf(:,149))
  call prop_A_Q(wf(:,54),Q(:,52),MT,1_intkind1,wf(:,150))
  call vert_VQ_A(wf(:,39),wf(:,142),wf(:,151))
  call vert_QA_V(wf(:,142),wf(:,-2),wf(:,152))
  call counter_QA_V(wf(:,-1),wf(:,41),wf(:,153))
  call counter_QA_V(wf(:,-1),wf(:,5),wf(:,154))
  call vert_QA_V(wf(:,137),wf(:,-3),wf(:,155))
  call vert_QA_V(wf(:,137),wf(:,-2),wf(:,156))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,157))
  call vert_VQ_A(wf(:,157),wf(:,25),wf(:,158))
  call vert_UV_W(wf(:,157),Q(:,10),wf(:,-5),Q(:,32),wf(:,159))
  call vert_AV_Q(wf(:,-2),wf(:,157),wf(:,160))
  call prop_A_Q(wf(:,160),Q(:,14),MT,1_intkind1,wf(:,161))
  call vert_VQ_A(wf(:,157),wf(:,33),wf(:,162))
  call vert_VQ_A(wf(:,157),wf(:,0),wf(:,163))
  call prop_Q_A(wf(:,163),Q(:,11),MT,1_intkind1,wf(:,164))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,165))
  call vert_VQ_A(wf(:,165),wf(:,25),wf(:,166))
  call vert_UV_W(wf(:,165),Q(:,6),wf(:,-5),Q(:,32),wf(:,167))
  call vert_AV_Q(wf(:,-3),wf(:,165),wf(:,168))
  call prop_A_Q(wf(:,168),Q(:,14),MT,1_intkind1,wf(:,169))
  call vert_VQ_A(wf(:,165),wf(:,33),wf(:,170))
  call vert_VQ_A(wf(:,165),wf(:,0),wf(:,171))
  call prop_Q_A(wf(:,171),Q(:,7),MT,1_intkind1,wf(:,172))
  call counter_VQ_A(wf(:,24),wf(:,0),wf(:,173))
  call counter_QA_V(wf(:,0),wf(:,15),wf(:,174))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,175))
  call prop_Q_A(wf(:,175),Q(:,33),MT,1_intkind1,wf(:,176))
  call vert_VQ_A(wf(:,24),wf(:,176),wf(:,177))
  call vert_VQ_A(wf(:,-4),wf(:,176),wf(:,178))
  call counter_VQ_A(wf(:,-4),wf(:,0),wf(:,179))
  call prop_Q_A(wf(:,179),Q(:,17),MT,1_intkind1,wf(:,180))
  call vert_VQ_A(wf(:,24),wf(:,180),wf(:,181))
  call vert_QA_V(wf(:,180),wf(:,-3),wf(:,182))
  call vert_VQ_A(wf(:,-5),wf(:,180),wf(:,183))
  call counter_VQ_A(wf(:,55),wf(:,0),wf(:,184))
  call counter_QA_V(wf(:,0),wf(:,48),wf(:,185))
  call vert_VQ_A(wf(:,55),wf(:,176),wf(:,186))
  call vert_VQ_A(wf(:,55),wf(:,180),wf(:,187))
  call vert_QA_V(wf(:,180),wf(:,-2),wf(:,188))
  call counter_QA_V(wf(:,0),wf(:,41),wf(:,189))
  call counter_QA_V(wf(:,0),wf(:,5),wf(:,190))
  call vert_QA_V(wf(:,176),wf(:,-2),wf(:,191))
  call vert_QA_V(wf(:,176),wf(:,-3),wf(:,192))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,193))
  call vert_VQ_A(wf(:,193),wf(:,4),wf(:,194))
  call vert_AV_Q(wf(:,-2),wf(:,193),wf(:,195))
  call prop_A_Q(wf(:,195),Q(:,13),MT,1_intkind1,wf(:,196))
  call vert_UV_W(wf(:,193),Q(:,9),wf(:,-5),Q(:,32),wf(:,197))
  call vert_VQ_A(wf(:,193),wf(:,14),wf(:,198))
  call vert_VQ_A(wf(:,193),wf(:,-1),wf(:,199))
  call prop_Q_A(wf(:,199),Q(:,11),MT,1_intkind1,wf(:,200))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,201))
  call vert_VQ_A(wf(:,201),wf(:,4),wf(:,202))
  call vert_AV_Q(wf(:,-3),wf(:,201),wf(:,203))
  call prop_A_Q(wf(:,203),Q(:,13),MT,1_intkind1,wf(:,204))
  call vert_UV_W(wf(:,201),Q(:,5),wf(:,-5),Q(:,32),wf(:,205))
  call vert_VQ_A(wf(:,201),wf(:,14),wf(:,206))
  call vert_VQ_A(wf(:,201),wf(:,-1),wf(:,207))
  call prop_Q_A(wf(:,207),Q(:,7),MT,1_intkind1,wf(:,208))
  call vert_QA_V(wf(:,4),wf(:,5),wf(:,209))
  call counter_V_V(ctGG,21,wf(:,1),Q(:,5),wf(:,210))
  call vert_AV_Q(wf(:,5),wf(:,1),wf(:,211))
  call counter_Q_A(cttt,6,wf(:,4),Q(:,18),wf(:,212))
  call prop_A_Q(wf(:,211),Q(:,45),MT,1_intkind1,wf(:,213))
  call counter_A_Q(cttt,6,wf(:,5),Q(:,40),wf(:,214))
  call prop_Q_A(wf(:,6),Q(:,23),MT,1_intkind1,wf(:,215))
  call vert_AV_Q(wf(:,-3),wf(:,210),wf(:,216))
  call vert_UV_W(wf(:,210),Q(:,5),wf(:,-5),Q(:,32),wf(:,217))
  call prop_Q_A(wf(:,212),Q(:,18),MT,1_intkind1,wf(:,218))
  call vert_QA_V(wf(:,218),wf(:,-3),wf(:,219))
  call vert_VQ_A(wf(:,-5),wf(:,218),wf(:,220))
  call counter_A_Q(cttt,6,wf(:,9),Q(:,13),wf(:,221))
  call counter_V_V(ctGG,21,wf(:,10),Q(:,26),wf(:,222))
  call vert_QA_V(wf(:,14),wf(:,15),wf(:,223))
  call vert_AV_Q(wf(:,15),wf(:,1),wf(:,224))
  call counter_Q_A(cttt,6,wf(:,14),Q(:,34),wf(:,225))
  call prop_A_Q(wf(:,224),Q(:,29),MT,1_intkind1,wf(:,226))
  call counter_A_Q(cttt,6,wf(:,15),Q(:,24),wf(:,227))
  call prop_Q_A(wf(:,16),Q(:,39),MT,1_intkind1,wf(:,228))
  call vert_VQ_A(wf(:,210),wf(:,-1),wf(:,229))
  call prop_A_Q(wf(:,227),Q(:,24),MT,1_intkind1,wf(:,230))
  call vert_QA_V(wf(:,-1),wf(:,230),wf(:,231))
  call counter_Q_A(cttt,6,wf(:,19),Q(:,7),wf(:,232))
  call counter_V_V(ctGG,21,wf(:,20),Q(:,26),wf(:,233))
  call vert_AV_Q(wf(:,230),wf(:,-5),wf(:,234))
  call prop_Q_A(wf(:,225),Q(:,34),MT,1_intkind1,wf(:,235))
  call vert_VQ_A(wf(:,-4),wf(:,235),wf(:,236))
  call prop_A_Q(wf(:,214),Q(:,40),MT,1_intkind1,wf(:,237))
  call vert_AV_Q(wf(:,237),wf(:,-4),wf(:,238))
  call vert_AV_Q(wf(:,5),wf(:,24),wf(:,239))
  call counter_Q_A(cttt,6,wf(:,25),Q(:,17),wf(:,240))
  call prop_A_Q(wf(:,239),Q(:,46),MT,1_intkind1,wf(:,241))
  call vert_QA_V(wf(:,25),wf(:,5),wf(:,242))
  call counter_V_V(ctGG,21,wf(:,24),Q(:,6),wf(:,243))
  call prop_Q_A(wf(:,26),Q(:,23),MT,1_intkind1,wf(:,244))
  call prop_Q_A(wf(:,240),Q(:,17),MT,1_intkind1,wf(:,245))
  call vert_QA_V(wf(:,245),wf(:,-3),wf(:,246))
  call vert_VQ_A(wf(:,-5),wf(:,245),wf(:,247))
  call vert_AV_Q(wf(:,-3),wf(:,243),wf(:,248))
  call vert_UV_W(wf(:,243),Q(:,6),wf(:,-5),Q(:,32),wf(:,249))
  call counter_V_V(ctGG,21,wf(:,27),Q(:,25),wf(:,250))
  call counter_A_Q(cttt,6,wf(:,31),Q(:,14),wf(:,251))
  call vert_AV_Q(wf(:,15),wf(:,24),wf(:,252))
  call counter_Q_A(cttt,6,wf(:,33),Q(:,33),wf(:,253))
  call prop_A_Q(wf(:,252),Q(:,30),MT,1_intkind1,wf(:,254))
  call vert_QA_V(wf(:,33),wf(:,15),wf(:,255))
  call prop_Q_A(wf(:,34),Q(:,39),MT,1_intkind1,wf(:,256))
  call vert_VQ_A(wf(:,243),wf(:,0),wf(:,257))
  call vert_QA_V(wf(:,0),wf(:,230),wf(:,258))
  call counter_Q_A(cttt,6,wf(:,36),Q(:,7),wf(:,259))
  call counter_V_V(ctGG,21,wf(:,37),Q(:,25),wf(:,260))
  call prop_Q_A(wf(:,253),Q(:,33),MT,1_intkind1,wf(:,261))
  call vert_VQ_A(wf(:,-4),wf(:,261),wf(:,262))
  call vert_QA_V(wf(:,4),wf(:,41),wf(:,263))
  call counter_V_V(ctGG,21,wf(:,39),Q(:,9),wf(:,264))
  call vert_AV_Q(wf(:,41),wf(:,39),wf(:,265))
  call prop_A_Q(wf(:,265),Q(:,45),MT,1_intkind1,wf(:,266))
  call counter_A_Q(cttt,6,wf(:,41),Q(:,36),wf(:,267))
  call prop_Q_A(wf(:,42),Q(:,27),MT,1_intkind1,wf(:,268))
  call vert_AV_Q(wf(:,-2),wf(:,264),wf(:,269))
  call vert_UV_W(wf(:,264),Q(:,9),wf(:,-5),Q(:,32),wf(:,270))
  call vert_QA_V(wf(:,218),wf(:,-2),wf(:,271))
  call counter_A_Q(cttt,6,wf(:,44),Q(:,13),wf(:,272))
  call counter_V_V(ctGG,21,wf(:,45),Q(:,22),wf(:,273))
  call vert_QA_V(wf(:,14),wf(:,48),wf(:,274))
  call vert_AV_Q(wf(:,48),wf(:,39),wf(:,275))
  call prop_A_Q(wf(:,275),Q(:,29),MT,1_intkind1,wf(:,276))
  call counter_A_Q(cttt,6,wf(:,48),Q(:,20),wf(:,277))
  call prop_Q_A(wf(:,49),Q(:,43),MT,1_intkind1,wf(:,278))
  call vert_VQ_A(wf(:,264),wf(:,-1),wf(:,279))
  call prop_A_Q(wf(:,277),Q(:,20),MT,1_intkind1,wf(:,280))
  call vert_QA_V(wf(:,-1),wf(:,280),wf(:,281))
  call counter_Q_A(cttt,6,wf(:,52),Q(:,11),wf(:,282))
  call counter_V_V(ctGG,21,wf(:,53),Q(:,22),wf(:,283))
  call vert_AV_Q(wf(:,280),wf(:,-5),wf(:,284))
  call prop_A_Q(wf(:,267),Q(:,36),MT,1_intkind1,wf(:,285))
  call vert_AV_Q(wf(:,285),wf(:,-4),wf(:,286))
  call vert_AV_Q(wf(:,41),wf(:,55),wf(:,287))
  call prop_A_Q(wf(:,287),Q(:,46),MT,1_intkind1,wf(:,288))
  call vert_QA_V(wf(:,25),wf(:,41),wf(:,289))
  call counter_V_V(ctGG,21,wf(:,55),Q(:,10),wf(:,290))
  call prop_Q_A(wf(:,56),Q(:,27),MT,1_intkind1,wf(:,291))
  call vert_QA_V(wf(:,245),wf(:,-2),wf(:,292))
  call vert_AV_Q(wf(:,-2),wf(:,290),wf(:,293))
  call vert_UV_W(wf(:,290),Q(:,10),wf(:,-5),Q(:,32),wf(:,294))
  call counter_V_V(ctGG,21,wf(:,57),Q(:,21),wf(:,295))
  call counter_A_Q(cttt,6,wf(:,60),Q(:,14),wf(:,296))
  call vert_AV_Q(wf(:,48),wf(:,55),wf(:,297))
  call prop_A_Q(wf(:,297),Q(:,30),MT,1_intkind1,wf(:,298))
  call vert_QA_V(wf(:,33),wf(:,48),wf(:,299))
  call prop_Q_A(wf(:,61),Q(:,43),MT,1_intkind1,wf(:,300))
  call vert_VQ_A(wf(:,290),wf(:,0),wf(:,301))
  call vert_QA_V(wf(:,0),wf(:,280),wf(:,302))
  call counter_Q_A(cttt,6,wf(:,63),Q(:,11),wf(:,303))
  call counter_V_V(ctGG,21,wf(:,64),Q(:,21),wf(:,304))
  call vert_QA_V(wf(:,235),wf(:,-2),wf(:,305))
  call vert_QA_V(wf(:,235),wf(:,-3),wf(:,306))
  call counter_V_V(ctGG,21,wf(:,66),Q(:,38),wf(:,307))
  call vert_QA_V(wf(:,-1),wf(:,285),wf(:,308))
  call counter_V_V(ctGG,21,wf(:,67),Q(:,38),wf(:,309))
  call counter_V_V(ctGG,21,wf(:,68),Q(:,42),wf(:,310))
  call vert_QA_V(wf(:,-1),wf(:,237),wf(:,311))
  call vert_QA_V(wf(:,261),wf(:,-2),wf(:,312))
  call vert_QA_V(wf(:,261),wf(:,-3),wf(:,313))
  call counter_V_V(ctGG,21,wf(:,69),Q(:,37),wf(:,314))
  call vert_QA_V(wf(:,0),wf(:,285),wf(:,315))
  call counter_V_V(ctGG,21,wf(:,71),Q(:,37),wf(:,316))
  call counter_V_V(ctGG,21,wf(:,72),Q(:,41),wf(:,317))
  call vert_QA_V(wf(:,0),wf(:,237),wf(:,318))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,55),Q(:,10),wf(:,319))
  call vert_QA_V(wf(:,19),wf(:,-3),wf(:,320))
  call vert_VQ_A(wf(:,-4),wf(:,19),wf(:,321))
  call prop_Q_A(wf(:,321),Q(:,23),MT,1_intkind1,wf(:,322))
  call vert_VQ_A(wf(:,-5),wf(:,19),wf(:,323))
  call prop_Q_A(wf(:,323),Q(:,39),MT,1_intkind1,wf(:,324))
  call vert_QA_V(wf(:,-1),wf(:,9),wf(:,325))
  call vert_AV_Q(wf(:,9),wf(:,-4),wf(:,326))
  call prop_A_Q(wf(:,326),Q(:,29),MT,1_intkind1,wf(:,327))
  call vert_AV_Q(wf(:,9),wf(:,-5),wf(:,328))
  call prop_A_Q(wf(:,328),Q(:,45),MT,1_intkind1,wf(:,329))
  call vert_VQ_A(wf(:,11),wf(:,-1),wf(:,330))
  call prop_Q_A(wf(:,330),Q(:,39),MT,1_intkind1,wf(:,331))
  call vert_AV_Q(wf(:,-3),wf(:,11),wf(:,332))
  call prop_A_Q(wf(:,332),Q(:,45),MT,1_intkind1,wf(:,333))
  call vert_UV_W(wf(:,24),Q(:,6),wf(:,39),Q(:,9),wf(:,334))
  call vert_QA_V(wf(:,36),wf(:,-3),wf(:,335))
  call vert_VQ_A(wf(:,-4),wf(:,36),wf(:,336))
  call prop_Q_A(wf(:,336),Q(:,23),MT,1_intkind1,wf(:,337))
  call vert_VQ_A(wf(:,-5),wf(:,36),wf(:,338))
  call prop_Q_A(wf(:,338),Q(:,39),MT,1_intkind1,wf(:,339))
  call vert_QA_V(wf(:,0),wf(:,31),wf(:,340))
  call vert_VQ_A(wf(:,28),wf(:,0),wf(:,341))
  call prop_Q_A(wf(:,341),Q(:,39),MT,1_intkind1,wf(:,342))
  call vert_AV_Q(wf(:,31),wf(:,-4),wf(:,343))
  call prop_A_Q(wf(:,343),Q(:,30),MT,1_intkind1,wf(:,344))
  call vert_AV_Q(wf(:,31),wf(:,-5),wf(:,345))
  call prop_A_Q(wf(:,345),Q(:,46),MT,1_intkind1,wf(:,346))
  call vert_AV_Q(wf(:,-3),wf(:,28),wf(:,347))
  call prop_A_Q(wf(:,347),Q(:,46),MT,1_intkind1,wf(:,348))
  call vert_QA_V(wf(:,52),wf(:,-2),wf(:,349))
  call vert_VQ_A(wf(:,-4),wf(:,52),wf(:,350))
  call prop_Q_A(wf(:,350),Q(:,27),MT,1_intkind1,wf(:,351))
  call vert_VQ_A(wf(:,-5),wf(:,52),wf(:,352))
  call prop_Q_A(wf(:,352),Q(:,43),MT,1_intkind1,wf(:,353))
  call vert_QA_V(wf(:,-1),wf(:,44),wf(:,354))
  call vert_AV_Q(wf(:,44),wf(:,-4),wf(:,355))
  call prop_A_Q(wf(:,355),Q(:,29),MT,1_intkind1,wf(:,356))
  call vert_AV_Q(wf(:,44),wf(:,-5),wf(:,357))
  call prop_A_Q(wf(:,357),Q(:,45),MT,1_intkind1,wf(:,358))
  call vert_VQ_A(wf(:,46),wf(:,-1),wf(:,359))
  call prop_Q_A(wf(:,359),Q(:,43),MT,1_intkind1,wf(:,360))
  call vert_AV_Q(wf(:,-2),wf(:,46),wf(:,361))
  call prop_A_Q(wf(:,361),Q(:,45),MT,1_intkind1,wf(:,362))
  call vert_QA_V(wf(:,63),wf(:,-2),wf(:,363))
  call vert_VQ_A(wf(:,-4),wf(:,63),wf(:,364))
  call prop_Q_A(wf(:,364),Q(:,27),MT,1_intkind1,wf(:,365))
  call vert_VQ_A(wf(:,-5),wf(:,63),wf(:,366))
  call prop_Q_A(wf(:,366),Q(:,43),MT,1_intkind1,wf(:,367))
  call vert_QA_V(wf(:,0),wf(:,60),wf(:,368))
  call vert_VQ_A(wf(:,58),wf(:,0),wf(:,369))
  call prop_Q_A(wf(:,369),Q(:,43),MT,1_intkind1,wf(:,370))
  call vert_AV_Q(wf(:,60),wf(:,-4),wf(:,371))
  call prop_A_Q(wf(:,371),Q(:,30),MT,1_intkind1,wf(:,372))
  call vert_AV_Q(wf(:,60),wf(:,-5),wf(:,373))
  call prop_A_Q(wf(:,373),Q(:,46),MT,1_intkind1,wf(:,374))
  call vert_AV_Q(wf(:,-2),wf(:,58),wf(:,375))
  call prop_A_Q(wf(:,375),Q(:,46),MT,1_intkind1,wf(:,376))
  call vert_VQ_A(wf(:,57),wf(:,-1),wf(:,377))
  call prop_Q_A(wf(:,377),Q(:,23),MT,1_intkind1,wf(:,378))
  call vert_AV_Q(wf(:,-3),wf(:,57),wf(:,379))
  call prop_A_Q(wf(:,379),Q(:,29),MT,1_intkind1,wf(:,380))
  call vert_UV_W(wf(:,57),Q(:,21),wf(:,-5),Q(:,32),wf(:,381))
  call vert_VQ_A(wf(:,27),wf(:,-1),wf(:,382))
  call prop_Q_A(wf(:,382),Q(:,27),MT,1_intkind1,wf(:,383))
  call vert_AV_Q(wf(:,-2),wf(:,27),wf(:,384))
  call prop_A_Q(wf(:,384),Q(:,29),MT,1_intkind1,wf(:,385))
  call vert_UV_W(wf(:,27),Q(:,25),wf(:,-5),Q(:,32),wf(:,386))
  call vert_QA_V(wf(:,101),wf(:,-2),wf(:,387))
  call vert_QA_V(wf(:,101),wf(:,-3),wf(:,388))
  call vert_VQ_A(wf(:,45),wf(:,0),wf(:,389))
  call prop_Q_A(wf(:,389),Q(:,23),MT,1_intkind1,wf(:,390))
  call vert_VQ_A(wf(:,10),wf(:,0),wf(:,391))
  call prop_Q_A(wf(:,391),Q(:,27),MT,1_intkind1,wf(:,392))
  call vert_AV_Q(wf(:,-3),wf(:,45),wf(:,393))
  call prop_A_Q(wf(:,393),Q(:,30),MT,1_intkind1,wf(:,394))
  call vert_UV_W(wf(:,45),Q(:,22),wf(:,-5),Q(:,32),wf(:,395))
  call vert_AV_Q(wf(:,-2),wf(:,10),wf(:,396))
  call prop_A_Q(wf(:,396),Q(:,30),MT,1_intkind1,wf(:,397))
  call vert_UV_W(wf(:,10),Q(:,26),wf(:,-5),Q(:,32),wf(:,398))
  call vert_QA_V(wf(:,86),wf(:,-2),wf(:,399))
  call vert_QA_V(wf(:,86),wf(:,-3),wf(:,400))
  call vert_VQ_A(wf(:,64),wf(:,-1),wf(:,401))
  call prop_Q_A(wf(:,401),Q(:,23),MT,1_intkind1,wf(:,402))
  call vert_VQ_A(wf(:,53),wf(:,0),wf(:,403))
  call prop_Q_A(wf(:,403),Q(:,23),MT,1_intkind1,wf(:,404))
  call vert_AV_Q(wf(:,-3),wf(:,64),wf(:,405))
  call prop_A_Q(wf(:,405),Q(:,29),MT,1_intkind1,wf(:,406))
  call vert_UV_W(wf(:,64),Q(:,21),wf(:,-5),Q(:,32),wf(:,407))
  call vert_QA_V(wf(:,0),wf(:,148),wf(:,408))
  call vert_AV_Q(wf(:,-3),wf(:,53),wf(:,409))
  call prop_A_Q(wf(:,409),Q(:,30),MT,1_intkind1,wf(:,410))
  call vert_UV_W(wf(:,53),Q(:,22),wf(:,-5),Q(:,32),wf(:,411))
  call vert_QA_V(wf(:,-1),wf(:,148),wf(:,412))
  call vert_VQ_A(wf(:,37),wf(:,-1),wf(:,413))
  call prop_Q_A(wf(:,413),Q(:,27),MT,1_intkind1,wf(:,414))
  call vert_VQ_A(wf(:,20),wf(:,0),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,27),MT,1_intkind1,wf(:,416))
  call vert_AV_Q(wf(:,-2),wf(:,37),wf(:,417))
  call prop_A_Q(wf(:,417),Q(:,29),MT,1_intkind1,wf(:,418))
  call vert_UV_W(wf(:,37),Q(:,25),wf(:,-5),Q(:,32),wf(:,419))
  call vert_QA_V(wf(:,0),wf(:,135),wf(:,420))
  call vert_AV_Q(wf(:,-2),wf(:,20),wf(:,421))
  call prop_A_Q(wf(:,421),Q(:,30),MT,1_intkind1,wf(:,422))
  call vert_UV_W(wf(:,20),Q(:,26),wf(:,-5),Q(:,32),wf(:,423))
  call vert_QA_V(wf(:,-1),wf(:,135),wf(:,424))
  call vert_VQ_A(wf(:,69),wf(:,-1),wf(:,425))
  call prop_Q_A(wf(:,425),Q(:,39),MT,1_intkind1,wf(:,426))
  call vert_AV_Q(wf(:,-3),wf(:,69),wf(:,427))
  call prop_A_Q(wf(:,427),Q(:,45),MT,1_intkind1,wf(:,428))
  call vert_VQ_A(wf(:,70),wf(:,-1),wf(:,429))
  call prop_Q_A(wf(:,429),Q(:,43),MT,1_intkind1,wf(:,430))
  call vert_AV_Q(wf(:,-2),wf(:,70),wf(:,431))
  call prop_A_Q(wf(:,431),Q(:,45),MT,1_intkind1,wf(:,432))
  call vert_QA_V(wf(:,103),wf(:,-2),wf(:,433))
  call vert_QA_V(wf(:,103),wf(:,-3),wf(:,434))
  call vert_VQ_A(wf(:,66),wf(:,0),wf(:,435))
  call prop_Q_A(wf(:,435),Q(:,39),MT,1_intkind1,wf(:,436))
  call vert_VQ_A(wf(:,65),wf(:,0),wf(:,437))
  call prop_Q_A(wf(:,437),Q(:,43),MT,1_intkind1,wf(:,438))
  call vert_AV_Q(wf(:,-3),wf(:,66),wf(:,439))
  call prop_A_Q(wf(:,439),Q(:,46),MT,1_intkind1,wf(:,440))
  call vert_AV_Q(wf(:,-2),wf(:,65),wf(:,441))
  call prop_A_Q(wf(:,441),Q(:,46),MT,1_intkind1,wf(:,442))
  call vert_QA_V(wf(:,89),wf(:,-2),wf(:,443))
  call vert_QA_V(wf(:,89),wf(:,-3),wf(:,444))
  call vert_VQ_A(wf(:,71),wf(:,-1),wf(:,445))
  call prop_Q_A(wf(:,445),Q(:,39),MT,1_intkind1,wf(:,446))
  call vert_VQ_A(wf(:,67),wf(:,0),wf(:,447))
  call prop_Q_A(wf(:,447),Q(:,39),MT,1_intkind1,wf(:,448))
  call vert_AV_Q(wf(:,-3),wf(:,71),wf(:,449))
  call prop_A_Q(wf(:,449),Q(:,45),MT,1_intkind1,wf(:,450))
  call vert_QA_V(wf(:,0),wf(:,150),wf(:,451))
  call vert_AV_Q(wf(:,-3),wf(:,67),wf(:,452))
  call prop_A_Q(wf(:,452),Q(:,46),MT,1_intkind1,wf(:,453))
  call vert_QA_V(wf(:,-1),wf(:,150),wf(:,454))
  call vert_VQ_A(wf(:,72),wf(:,-1),wf(:,455))
  call prop_Q_A(wf(:,455),Q(:,43),MT,1_intkind1,wf(:,456))
  call vert_VQ_A(wf(:,68),wf(:,0),wf(:,457))
  call prop_Q_A(wf(:,457),Q(:,43),MT,1_intkind1,wf(:,458))
  call vert_AV_Q(wf(:,-2),wf(:,72),wf(:,459))
  call prop_A_Q(wf(:,459),Q(:,45),MT,1_intkind1,wf(:,460))
  call vert_QA_V(wf(:,0),wf(:,139),wf(:,461))
  call vert_AV_Q(wf(:,-2),wf(:,68),wf(:,462))
  call prop_A_Q(wf(:,462),Q(:,46),MT,1_intkind1,wf(:,463))
  call vert_QA_V(wf(:,-1),wf(:,139),wf(:,464))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,18) - MT2)
  den(3) = 1 / (Q(5,40) - MT2)
  den(6) = 1 / (Q(5,13) - MT2)
  den(9) = 1 / (Q(5,26))
  den(12) = 1 / (Q(5,34) - MT2)
  den(13) = 1 / (Q(5,24) - MT2)
  den(16) = 1 / (Q(5,7) - MT2)
  den(23) = 1 / (Q(5,17) - MT2)
  den(24) = 1 / (Q(5,6))
  den(27) = 1 / (Q(5,25))
  den(30) = 1 / (Q(5,14) - MT2)
  den(33) = 1 / (Q(5,33) - MT2)
  den(42) = 1 / (Q(5,9))
  den(43) = 1 / (Q(5,36) - MT2)
  den(48) = 1 / (Q(5,22))
  den(51) = 1 / (Q(5,20) - MT2)
  den(54) = 1 / (Q(5,11) - MT2)
  den(61) = 1 / (Q(5,10))
  den(64) = 1 / (Q(5,21))
  den(78) = 1 / (Q(5,38))
  den(83) = 1 / (Q(5,42))
  den(86) = 1 / (Q(5,37))
  den(92) = 1 / (Q(5,41))
  den(107) = 1 / (Q(5,50) - MT2)
  den(112) = 1 / (Q(5,49) - MT2)
  den(134) = 1 / (Q(5,56) - MT2)
  den(140) = 1 / (Q(5,52) - MT2)
  den(164) = 1 / (Q(5,58))
  den(168) = 1 / (Q(5,45) - MT2)
  den(171) = 1 / (Q(5,23) - MT2)
  den(186) = 1 / (Q(5,29) - MT2)
  den(189) = 1 / (Q(5,39) - MT2)
  den(208) = 1 / (Q(5,46) - MT2)
  den(212) = 1 / (Q(5,57))
  den(226) = 1 / (Q(5,30) - MT2)
  den(248) = 1 / (Q(5,54))
  den(254) = 1 / (Q(5,27) - MT2)
  den(270) = 1 / (Q(5,43) - MT2)
  den(291) = 1 / (Q(5,53))
  den(371) = 1 / (Q(5,15))

  ! denominators
  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(1)*den(6)
  den(8) = den(2)*den(7)
  den(10) = den(2)*den(9)
  den(11) = den(1)*den(10)
  den(14) = den(1)*den(12)
  den(15) = den(13)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(13)*den(17)
  den(19) = den(9)*den(13)
  den(20) = den(1)*den(19)
  den(21) = den(7)*den(12)
  den(22) = den(3)*den(17)
  den(25) = den(23)*den(24)
  den(26) = den(3)*den(25)
  den(28) = den(23)*den(27)
  den(29) = den(24)*den(28)
  den(31) = den(24)*den(30)
  den(32) = den(23)*den(31)
  den(34) = den(24)*den(33)
  den(35) = den(13)*den(34)
  den(36) = den(16)*den(24)
  den(37) = den(13)*den(36)
  den(38) = den(13)*den(27)
  den(39) = den(24)*den(38)
  den(40) = den(31)*den(33)
  den(41) = den(3)*den(36)
  den(44) = den(2)*den(42)
  den(45) = den(43)*den(44)
  den(46) = den(6)*den(42)
  den(47) = den(2)*den(46)
  den(49) = den(2)*den(48)
  den(50) = den(42)*den(49)
  den(52) = den(12)*den(42)
  den(53) = den(51)*den(52)
  den(55) = den(42)*den(54)
  den(56) = den(51)*den(55)
  den(57) = den(48)*den(51)
  den(58) = den(42)*den(57)
  den(59) = den(12)*den(46)
  den(60) = den(43)*den(55)
  den(62) = den(23)*den(61)
  den(63) = den(43)*den(62)
  den(65) = den(23)*den(64)
  den(66) = den(61)*den(65)
  den(67) = den(30)*den(61)
  den(68) = den(23)*den(67)
  den(69) = den(33)*den(61)
  den(70) = den(51)*den(69)
  den(71) = den(54)*den(61)
  den(72) = den(51)*den(71)
  den(73) = den(51)*den(64)
  den(74) = den(61)*den(73)
  den(75) = den(33)*den(67)
  den(76) = den(43)*den(71)
  den(77) = den(12)*den(65)
  den(79) = den(12)*den(78)
  den(80) = den(23)*den(79)
  den(81) = den(43)*den(78)
  den(82) = den(23)*den(81)
  den(84) = den(3)*den(83)
  den(85) = den(23)*den(84)
  den(87) = den(33)*den(86)
  den(88) = den(2)*den(87)
  den(89) = den(33)*den(49)
  den(90) = den(43)*den(86)
  den(91) = den(2)*den(90)
  den(93) = den(3)*den(92)
  den(94) = den(2)*den(93)
  den(95) = den(33)*den(57)
  den(96) = den(12)*den(73)
  den(97) = den(3)*den(73)
  den(98) = den(51)*den(93)
  den(99) = den(19)*den(33)
  den(100) = den(12)*den(38)
  den(101) = den(13)*den(90)
  den(102) = den(38)*den(43)
  den(103) = den(1)*den(61)
  den(104) = den(24)*den(42)
  den(105) = den(1)*den(86)
  den(106) = den(2)*den(105)
  den(108) = den(2)*den(107)
  den(109) = den(1)*den(108)
  den(110) = den(12)*den(107)
  den(111) = den(1)*den(110)
  den(113) = den(23)*den(112)
  den(114) = den(24)*den(113)
  den(115) = den(24)*den(78)
  den(116) = den(23)*den(115)
  den(117) = den(33)*den(112)
  den(118) = den(24)*den(117)
  den(119) = den(42)*den(92)
  den(120) = den(2)*den(119)
  den(121) = den(42)*den(108)
  den(122) = den(42)*den(110)
  den(123) = den(61)*den(113)
  den(124) = den(61)*den(83)
  den(125) = den(23)*den(124)
  den(126) = den(61)*den(117)
  den(127) = den(12)*den(28)
  den(128) = den(12)*den(83)
  den(129) = den(23)*den(128)
  den(130) = den(33)*den(92)
  den(131) = den(2)*den(130)
  den(132) = den(10)*den(33)
  den(133) = den(13)*den(105)
  den(135) = den(13)*den(134)
  den(136) = den(1)*den(135)
  den(137) = den(3)*den(134)
  den(138) = den(1)*den(137)
  den(139) = den(51)*den(119)
  den(141) = den(51)*den(140)
  den(142) = den(42)*den(141)
  den(143) = den(43)*den(140)
  den(144) = den(42)*den(143)
  den(145) = den(28)*den(43)
  den(146) = den(3)*den(65)
  den(147) = den(51)*den(130)
  den(148) = den(13)*den(87)
  den(149) = den(24)*den(135)
  den(150) = den(13)*den(115)
  den(151) = den(24)*den(137)
  den(152) = den(61)*den(141)
  den(153) = den(51)*den(124)
  den(154) = den(61)*den(143)
  den(155) = den(10)*den(43)
  den(156) = den(3)*den(49)
  den(157) = den(51)*den(128)
  den(158) = den(51)*den(84)
  den(159) = den(3)*den(57)
  den(160) = den(13)*den(79)
  den(161) = den(19)*den(43)
  den(162) = den(13)*den(81)
  den(163) = den(2)*den(3)
  den(165) = den(163)*den(164)
  den(166) = den(1)*den(165)
  den(167) = den(1)*den(3)
  den(169) = den(167)*den(168)
  den(170) = den(2)*den(169)
  den(172) = den(4)*den(171)
  den(173) = den(3)*den(172)
  den(174) = den(1)**2
  den(175) = den(108)*den(174)
  den(176) = den(10)*den(174)
  den(177) = den(2)**2
  den(178) = den(105)*den(177)
  den(179) = den(7)*den(177)
  den(180) = den(7)*den(108)
  den(181) = den(10)*den(105)
  den(182) = den(12)*den(13)
  den(183) = den(164)*den(182)
  den(184) = den(1)*den(183)
  den(185) = den(1)*den(13)
  den(187) = den(185)*den(186)
  den(188) = den(12)*den(187)
  den(190) = den(14)*den(189)
  den(191) = den(13)*den(190)
  den(192) = den(135)*den(174)
  den(193) = den(19)*den(174)
  den(194) = den(13)**2
  den(195) = den(105)*den(194)
  den(196) = den(17)*den(135)
  den(197) = den(19)*den(105)
  den(198) = den(17)*den(194)
  den(199) = den(110)*den(174)
  den(200) = den(12)**2
  den(201) = den(7)*den(200)
  den(202) = den(7)*den(110)
  den(203) = den(137)*den(174)
  den(204) = den(17)*den(137)
  den(205) = den(3)**2
  den(206) = den(17)*den(205)
  den(207) = den(3)*den(24)
  den(209) = den(207)*den(208)
  den(210) = den(23)*den(209)
  den(211) = den(3)*den(23)
  den(213) = den(211)*den(212)
  den(214) = den(24)*den(213)
  den(215) = den(25)*den(171)
  den(216) = den(3)*den(215)
  den(217) = den(23)**2
  den(218) = den(115)*den(217)
  den(219) = den(31)*den(217)
  den(220) = den(24)**2
  den(221) = den(113)*den(220)
  den(222) = den(28)*den(220)
  den(223) = den(28)*den(115)
  den(224) = den(31)*den(113)
  den(225) = den(13)*den(24)
  den(227) = den(225)*den(226)
  den(228) = den(33)*den(227)
  den(229) = den(13)*den(33)
  den(230) = den(212)*den(229)
  den(231) = den(24)*den(230)
  den(232) = den(34)*den(189)
  den(233) = den(13)*den(232)
  den(234) = den(135)*den(220)
  den(235) = den(115)*den(194)
  den(236) = den(36)*den(135)
  den(237) = den(38)*den(115)
  den(238) = den(38)*den(220)
  den(239) = den(36)*den(194)
  den(240) = den(33)**2
  den(241) = den(31)*den(240)
  den(242) = den(117)*den(220)
  den(243) = den(31)*den(117)
  den(244) = den(137)*den(220)
  den(245) = den(36)*den(137)
  den(246) = den(36)*den(205)
  den(247) = den(2)*den(43)
  den(249) = den(247)*den(248)
  den(250) = den(42)*den(249)
  den(251) = den(42)*den(43)
  den(252) = den(168)*den(251)
  den(253) = den(2)*den(252)
  den(255) = den(44)*den(254)
  den(256) = den(43)*den(255)
  den(257) = den(42)**2
  den(258) = den(108)*den(257)
  den(259) = den(49)*den(257)
  den(260) = den(119)*den(177)
  den(261) = den(46)*den(177)
  den(262) = den(46)*den(108)
  den(263) = den(49)*den(119)
  den(264) = den(12)*den(51)
  den(265) = den(248)*den(264)
  den(266) = den(42)*den(265)
  den(267) = den(42)*den(51)
  den(268) = den(186)*den(267)
  den(269) = den(12)*den(268)
  den(271) = den(52)*den(270)
  den(272) = den(51)*den(271)
  den(273) = den(141)*den(257)
  den(274) = den(57)*den(257)
  den(275) = den(51)**2
  den(276) = den(119)*den(275)
  den(277) = den(55)*den(141)
  den(278) = den(57)*den(119)
  den(279) = den(55)*den(275)
  den(280) = den(110)*den(257)
  den(281) = den(46)*den(200)
  den(282) = den(46)*den(110)
  den(283) = den(143)*den(257)
  den(284) = den(55)*den(143)
  den(285) = den(43)**2
  den(286) = den(55)*den(285)
  den(287) = den(43)*den(61)
  den(288) = den(208)*den(287)
  den(289) = den(23)*den(288)
  den(290) = den(23)*den(43)
  den(292) = den(290)*den(291)
  den(293) = den(61)*den(292)
  den(294) = den(62)*den(254)
  den(295) = den(43)*den(294)
  den(296) = den(124)*den(217)
  den(297) = den(67)*den(217)
  den(298) = den(61)**2
  den(299) = den(113)*den(298)
  den(300) = den(65)*den(298)
  den(301) = den(65)*den(124)
  den(302) = den(67)*den(113)
  den(303) = den(51)*den(61)
  den(304) = den(226)*den(303)
  den(305) = den(33)*den(304)
  den(306) = den(33)*den(51)
  den(307) = den(291)*den(306)
  den(308) = den(61)*den(307)
  den(309) = den(69)*den(270)
  den(310) = den(51)*den(309)
  den(311) = den(141)*den(298)
  den(312) = den(124)*den(275)
  den(313) = den(71)*den(141)
  den(314) = den(73)*den(124)
  den(315) = den(73)*den(298)
  den(316) = den(71)*den(275)
  den(317) = den(67)*den(240)
  den(318) = den(117)*den(298)
  den(319) = den(67)*den(117)
  den(320) = den(143)*den(298)
  den(321) = den(71)*den(143)
  den(322) = den(71)*den(285)
  den(323) = den(128)*den(217)
  den(324) = den(79)*den(217)
  den(325) = den(28)*den(200)
  den(326) = den(65)*den(200)
  den(327) = den(65)*den(128)
  den(328) = den(28)*den(79)
  den(329) = den(81)*den(217)
  den(330) = den(28)*den(285)
  den(331) = den(28)*den(81)
  den(332) = den(84)*den(217)
  den(333) = den(65)*den(84)
  den(334) = den(65)*den(205)
  den(335) = den(10)*den(240)
  den(336) = den(49)*den(240)
  den(337) = den(130)*den(177)
  den(338) = den(87)*den(177)
  den(339) = den(10)*den(87)
  den(340) = den(49)*den(130)
  den(341) = den(10)*den(285)
  den(342) = den(10)*den(90)
  den(343) = den(90)*den(177)
  den(344) = den(49)*den(93)
  den(345) = den(49)*den(205)
  den(346) = den(93)*den(177)
  den(347) = den(57)*den(240)
  den(348) = den(130)*den(275)
  den(349) = den(57)*den(130)
  den(350) = den(128)*den(275)
  den(351) = den(73)*den(128)
  den(352) = den(73)*den(200)
  den(353) = den(73)*den(84)
  den(354) = den(57)*den(93)
  den(355) = den(84)*den(275)
  den(356) = den(57)*den(205)
  den(357) = den(93)*den(275)
  den(358) = den(73)*den(205)
  den(359) = den(19)*den(240)
  den(360) = den(19)*den(87)
  den(361) = den(87)*den(194)
  den(362) = den(38)*den(79)
  den(363) = den(79)*den(194)
  den(364) = den(38)*den(200)
  den(365) = den(19)*den(90)
  den(366) = den(38)*den(81)
  den(367) = den(19)*den(285)
  den(368) = den(81)*den(194)
  den(369) = den(38)*den(285)
  den(370) = den(90)*den(194)
  den(372) = den(103)*den(371)
  den(373) = den(17)*den(371)
  den(374) = den(17)*den(171)
  den(375) = den(17)*den(189)
  den(376) = den(7)*den(371)
  den(377) = den(7)*den(186)
  den(378) = den(7)*den(168)
  den(379) = den(105)*den(189)
  den(380) = den(105)*den(168)
  den(381) = den(104)*den(371)
  den(382) = den(36)*den(371)
  den(383) = den(36)*den(171)
  den(384) = den(36)*den(189)
  den(385) = den(31)*den(371)
  den(386) = den(115)*den(189)
  den(387) = den(31)*den(226)
  den(388) = den(31)*den(208)
  den(389) = den(115)*den(208)
  den(390) = den(55)*den(371)
  den(391) = den(55)*den(254)
  den(392) = den(55)*den(270)
  den(393) = den(46)*den(371)
  den(394) = den(46)*den(186)
  den(395) = den(46)*den(168)
  den(396) = den(119)*den(270)
  den(397) = den(119)*den(168)
  den(398) = den(71)*den(371)
  den(399) = den(71)*den(254)
  den(400) = den(71)*den(270)
  den(401) = den(67)*den(371)
  den(402) = den(124)*den(270)
  den(403) = den(67)*den(226)
  den(404) = den(67)*den(208)
  den(405) = den(124)*den(208)
  den(406) = den(65)*den(171)
  den(407) = den(65)*den(186)
  den(408) = den(65)*den(291)
  den(409) = den(28)*den(254)
  den(410) = den(28)*den(186)
  den(411) = den(28)*den(212)
  den(412) = den(113)*den(291)
  den(413) = den(113)*den(212)
  den(414) = den(49)*den(171)
  den(415) = den(10)*den(254)
  den(416) = den(49)*den(226)
  den(417) = den(49)*den(248)
  den(418) = den(10)*den(226)
  den(419) = den(10)*den(164)
  den(420) = den(108)*den(248)
  den(421) = den(108)*den(164)
  den(422) = den(73)*den(171)
  den(423) = den(57)*den(171)
  den(424) = den(73)*den(186)
  den(425) = den(73)*den(291)
  den(426) = den(141)*den(291)
  den(427) = den(57)*den(226)
  den(428) = den(57)*den(248)
  den(429) = den(141)*den(248)
  den(430) = den(38)*den(254)
  den(431) = den(19)*den(254)
  den(432) = den(38)*den(186)
  den(433) = den(38)*den(212)
  den(434) = den(135)*den(212)
  den(435) = den(19)*den(226)
  den(436) = den(19)*den(164)
  den(437) = den(135)*den(164)
  den(438) = den(87)*den(189)
  den(439) = den(87)*den(168)
  den(440) = den(130)*den(270)
  den(441) = den(130)*den(168)
  den(442) = den(117)*den(291)
  den(443) = den(117)*den(212)
  den(444) = den(79)*den(189)
  den(445) = den(128)*den(270)
  den(446) = den(79)*den(208)
  den(447) = den(128)*den(208)
  den(448) = den(110)*den(248)
  den(449) = den(110)*den(164)
  den(450) = den(90)*den(189)
  den(451) = den(81)*den(189)
  den(452) = den(90)*den(168)
  den(453) = den(143)*den(291)
  den(454) = den(81)*den(208)
  den(455) = den(143)*den(248)
  den(456) = den(93)*den(270)
  den(457) = den(84)*den(270)
  den(458) = den(93)*den(168)
  den(459) = den(137)*den(212)
  den(460) = den(84)*den(208)
  den(461) = den(137)*den(164)
  den(462) = den(61)*den(105)
  den(463) = den(1)*den(124)
  den(464) = den(1)*den(2)*den(3)
  den(465) = den(1)*den(12)*den(13)
  den(466) = den(1)*den(128)
  den(467) = den(1)*den(84)
  den(468) = den(24)*den(119)
  den(469) = den(42)*den(115)
  den(470) = den(3)*den(23)*den(24)
  den(471) = den(13)*den(24)*den(33)
  den(472) = den(24)*den(130)
  den(473) = den(24)*den(93)
  den(474) = den(2)*den(42)*den(43)
  den(475) = den(12)*den(42)*den(51)
  den(476) = den(42)*den(79)
  den(477) = den(42)*den(81)
  den(478) = den(23)*den(43)*den(61)
  den(479) = den(33)*den(51)*den(61)
  den(480) = den(61)*den(87)
  den(481) = den(61)*den(90)
  den(482) = den(12)*den(23)
  den(483) = den(2)*den(33)
  den(484) = den(3)*den(51)
  den(485) = den(13)*den(43)
  den(486) = den(2)*den(378)
  den(487) = den(2)*den(380)
  den(488) = den(1)*den(419)
  den(489) = den(1)*den(421)
  den(490) = den(13)*den(375)
  den(491) = den(13)*den(379)
  den(492) = den(1)*den(436)
  den(493) = den(1)*den(437)
  den(494) = den(12)*den(377)
  den(495) = den(1)*den(449)
  den(496) = den(3)*den(374)
  den(497) = den(1)*den(461)
  den(498) = den(24)*den(411)
  den(499) = den(24)*den(413)
  den(500) = den(23)*den(388)
  den(501) = den(23)*den(389)
  den(502) = den(13)*den(384)
  den(503) = den(24)*den(433)
  den(504) = den(13)*den(386)
  den(505) = den(24)*den(434)
  den(506) = den(24)*den(443)
  den(507) = den(33)*den(387)
  den(508) = den(3)*den(383)
  den(509) = den(24)*den(459)
  den(510) = den(2)*den(395)
  den(511) = den(2)*den(397)
  den(512) = den(42)*den(417)
  den(513) = den(42)*den(420)
  den(514) = den(51)*den(392)
  den(515) = den(51)*den(396)
  den(516) = den(42)*den(428)
  den(517) = den(42)*den(429)
  den(518) = den(12)*den(394)
  den(519) = den(42)*den(448)
  den(520) = den(43)*den(391)
  den(521) = den(42)*den(455)
  den(522) = den(61)*den(408)
  den(523) = den(61)*den(412)
  den(524) = den(23)*den(404)
  den(525) = den(23)*den(405)
  den(526) = den(51)*den(400)
  den(527) = den(61)*den(425)
  den(528) = den(51)*den(402)
  den(529) = den(61)*den(426)
  den(530) = den(61)*den(442)
  den(531) = den(33)*den(403)
  den(532) = den(43)*den(399)
  den(533) = den(61)*den(453)
  den(534) = den(12)*den(407)
  den(535) = den(12)*den(410)
  den(536) = den(23)*den(446)
  den(537) = den(23)*den(447)
  den(538) = den(43)*den(409)
  den(539) = den(23)*den(454)
  den(540) = den(3)*den(406)
  den(541) = den(23)*den(460)
  den(542) = den(2)*den(439)
  den(543) = den(2)*den(441)
  den(544) = den(33)*den(416)
  den(545) = den(33)*den(418)
  den(546) = den(2)*den(452)
  den(547) = den(43)*den(415)
  den(548) = den(2)*den(458)
  den(549) = den(3)*den(414)
  den(550) = den(51)*den(440)
  den(551) = den(33)*den(427)
  den(552) = den(12)*den(424)
  den(553) = den(51)*den(445)
  den(554) = den(3)*den(422)
  den(555) = den(51)*den(456)
  den(556) = den(3)*den(423)
  den(557) = den(51)*den(457)
  den(558) = den(13)*den(438)
  den(559) = den(33)*den(435)
  den(560) = den(12)*den(432)
  den(561) = den(13)*den(444)
  den(562) = den(13)*den(450)
  den(563) = den(43)*den(430)
  den(564) = den(13)*den(451)
  den(565) = den(43)*den(431)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(388)

  A(1) = cont_QA(wf(:,5),wf(:,6)) * den(5)
  A(2) = cont_QA(wf(:,8),wf(:,9)) * den(8)
  A(3) = cont_VV(wf(:,10),wf(:,11)) * den(11)
  A(4) = cont_QA(wf(:,15),wf(:,16)) * den(15)
  A(5) = cont_QA(wf(:,18),wf(:,19)) * den(18)
  A(6) = cont_VV(wf(:,11),wf(:,20)) * den(20)
  A(7) = cont_QA(wf(:,9),wf(:,21)) * den(21)
  A(8) = cont_QA(wf(:,19),wf(:,22)) * den(22)
  A(9) = cont_QA(wf(:,5),wf(:,26)) * den(26)
  A(10) = cont_VV(wf(:,27),wf(:,28)) * den(29)
  A(11) = cont_QA(wf(:,30),wf(:,31)) * den(32)
  A(12) = cont_QA(wf(:,15),wf(:,34)) * den(35)
  A(13) = cont_QA(wf(:,18),wf(:,36)) * den(37)
  A(14) = cont_VV(wf(:,28),wf(:,37)) * den(39)
  A(15) = cont_QA(wf(:,31),wf(:,38)) * den(40)
  A(16) = cont_QA(wf(:,22),wf(:,36)) * den(41)
  A(17) = cont_QA(wf(:,41),wf(:,42)) * den(45)
  A(18) = cont_QA(wf(:,8),wf(:,44)) * den(47)
  A(19) = cont_VV(wf(:,45),wf(:,46)) * den(50)
  A(20) = cont_QA(wf(:,48),wf(:,49)) * den(53)
  A(21) = cont_QA(wf(:,51),wf(:,52)) * den(56)
  A(22) = cont_VV(wf(:,46),wf(:,53)) * den(58)
  A(23) = cont_QA(wf(:,21),wf(:,44)) * den(59)
  A(24) = cont_QA(wf(:,52),wf(:,54)) * den(60)
  A(25) = cont_QA(wf(:,41),wf(:,56)) * den(63)
  A(26) = cont_VV(wf(:,57),wf(:,58)) * den(66)
  A(27) = cont_QA(wf(:,30),wf(:,60)) * den(68)
  A(28) = cont_QA(wf(:,48),wf(:,61)) * den(70)
  A(29) = cont_QA(wf(:,51),wf(:,63)) * den(72)
  A(30) = cont_VV(wf(:,58),wf(:,64)) * den(74)
  A(31) = cont_QA(wf(:,38),wf(:,60)) * den(75)
  A(32) = cont_QA(wf(:,54),wf(:,63)) * den(76)
  A(33) = cont_VV(wf(:,57),wf(:,65)) * den(77)
  A(34) = cont_VV(wf(:,27),wf(:,66)) * den(80)
  A(35) = cont_VV(wf(:,27),wf(:,67)) * den(82)
  A(36) = cont_VV(wf(:,57),wf(:,68)) * den(85)
  A(37) = cont_VV(wf(:,10),wf(:,69)) * den(88)
  A(38) = cont_VV(wf(:,45),wf(:,70)) * den(89)
  A(39) = cont_VV(wf(:,10),wf(:,71)) * den(91)
  A(40) = cont_VV(wf(:,45),wf(:,72)) * den(94)
  A(41) = cont_VV(wf(:,53),wf(:,70)) * den(95)
  A(42) = cont_VV(wf(:,64),wf(:,65)) * den(96)
  A(43) = cont_VV(wf(:,64),wf(:,68)) * den(97)
  A(44) = cont_VV(wf(:,53),wf(:,72)) * den(98)
  A(45) = cont_VV(wf(:,20),wf(:,69)) * den(99)
  A(46) = cont_VV(wf(:,37),wf(:,66)) * den(100)
  A(47) = cont_VV(wf(:,20),wf(:,71)) * den(101)
  A(48) = cont_VV(wf(:,37),wf(:,67)) * den(102)

  A(49) = cont_VV(wf(:,55),wf(:,73)) * den(103)
  A(50) = cont_VV(wf(:,55),wf(:,74)) * den(103)
  A(51) = cont_VV(wf(:,24),wf(:,75)) * den(104)
  A(52) = cont_VV(wf(:,24),wf(:,76)) * den(104)
  A(53) = cont_QA(wf(:,5),wf(:,77)) * den(5)
  A(54) = cont_QA(wf(:,9),wf(:,78)) * den(8)
  A(55) = cont_VV(wf(:,10),wf(:,79)) * den(11)
  A(56) = cont_QA(wf(:,15),wf(:,80)) * den(15)
  A(57) = cont_QA(wf(:,19),wf(:,81)) * den(18)
  A(58) = cont_VV(wf(:,20),wf(:,79)) * den(20)
  A(59) = cont_QA(wf(:,9),wf(:,82)) * den(21)
  A(60) = cont_QA(wf(:,19),wf(:,83)) * den(22)
  A(61) = cont_VV(wf(:,11),wf(:,84)) * den(106)
  A(62) = cont_QA(wf(:,85),wf(:,86)) * den(109)
  A(63) = cont_QA(wf(:,6),wf(:,88)) * den(5)
  A(64) = cont_QA(wf(:,85),wf(:,89)) * den(111)
  A(65) = cont_QA(wf(:,19),wf(:,90)) * den(22)
  A(66) = cont_QA(wf(:,16),wf(:,92)) * den(15)
  A(67) = cont_QA(wf(:,19),wf(:,93)) * den(18)
  A(68) = cont_VV(wf(:,11),wf(:,94)) * den(20)
  A(69) = cont_QA(wf(:,5),wf(:,95)) * den(26)
  A(70) = cont_VV(wf(:,27),wf(:,96)) * den(29)
  A(71) = cont_QA(wf(:,31),wf(:,97)) * den(32)
  A(72) = cont_QA(wf(:,15),wf(:,98)) * den(35)
  A(73) = cont_QA(wf(:,36),wf(:,81)) * den(37)
  A(74) = cont_VV(wf(:,37),wf(:,96)) * den(39)
  A(75) = cont_QA(wf(:,31),wf(:,99)) * den(40)
  A(76) = cont_QA(wf(:,36),wf(:,83)) * den(41)
  A(77) = cont_QA(wf(:,100),wf(:,101)) * den(114)
  A(78) = cont_VV(wf(:,28),wf(:,102)) * den(116)
  A(79) = cont_QA(wf(:,26),wf(:,88)) * den(26)
  A(80) = cont_QA(wf(:,100),wf(:,103)) * den(118)
  A(81) = cont_QA(wf(:,36),wf(:,90)) * den(41)
  A(82) = cont_QA(wf(:,34),wf(:,92)) * den(35)
  A(83) = cont_QA(wf(:,36),wf(:,93)) * den(37)
  A(84) = cont_VV(wf(:,28),wf(:,104)) * den(39)
  A(85) = cont_QA(wf(:,41),wf(:,105)) * den(45)
  A(86) = cont_QA(wf(:,44),wf(:,78)) * den(47)
  A(87) = cont_VV(wf(:,45),wf(:,106)) * den(50)
  A(88) = cont_QA(wf(:,48),wf(:,107)) * den(53)
  A(89) = cont_QA(wf(:,52),wf(:,108)) * den(56)
  A(90) = cont_VV(wf(:,53),wf(:,106)) * den(58)
  A(91) = cont_QA(wf(:,44),wf(:,82)) * den(59)
  A(92) = cont_QA(wf(:,52),wf(:,109)) * den(60)
  A(93) = cont_QA(wf(:,41),wf(:,110)) * den(63)
  A(94) = cont_VV(wf(:,57),wf(:,111)) * den(66)
  A(95) = cont_QA(wf(:,60),wf(:,97)) * den(68)
  A(96) = cont_QA(wf(:,48),wf(:,112)) * den(70)
  A(97) = cont_QA(wf(:,63),wf(:,108)) * den(72)
  A(98) = cont_VV(wf(:,64),wf(:,111)) * den(74)
  A(99) = cont_QA(wf(:,60),wf(:,99)) * den(75)
  A(100) = cont_QA(wf(:,63),wf(:,109)) * den(76)
  A(101) = cont_VV(wf(:,57),wf(:,113)) * den(77)
  A(102) = cont_VV(wf(:,66),wf(:,102)) * den(80)
  A(103) = cont_VV(wf(:,67),wf(:,102)) * den(82)
  A(104) = cont_VV(wf(:,57),wf(:,114)) * den(85)
  A(105) = cont_VV(wf(:,69),wf(:,84)) * den(88)
  A(106) = cont_VV(wf(:,45),wf(:,115)) * den(89)
  A(107) = cont_VV(wf(:,71),wf(:,84)) * den(91)
  A(108) = cont_VV(wf(:,45),wf(:,116)) * den(94)
  A(109) = cont_VV(wf(:,53),wf(:,115)) * den(95)
  A(110) = cont_VV(wf(:,64),wf(:,113)) * den(96)
  A(111) = cont_VV(wf(:,64),wf(:,114)) * den(97)
  A(112) = cont_VV(wf(:,53),wf(:,116)) * den(98)
  A(113) = cont_VV(wf(:,69),wf(:,94)) * den(99)
  A(114) = cont_VV(wf(:,66),wf(:,104)) * den(100)
  A(115) = cont_VV(wf(:,71),wf(:,94)) * den(101)
  A(116) = cont_VV(wf(:,67),wf(:,104)) * den(102)
  A(117) = cont_VV(wf(:,46),wf(:,117)) * den(120)
  A(118) = cont_QA(wf(:,86),wf(:,118)) * den(121)
  A(119) = cont_QA(wf(:,42),wf(:,120)) * den(45)
  A(120) = cont_QA(wf(:,89),wf(:,118)) * den(122)
  A(121) = cont_QA(wf(:,52),wf(:,121)) * den(60)
  A(122) = cont_QA(wf(:,49),wf(:,123)) * den(53)
  A(123) = cont_QA(wf(:,52),wf(:,124)) * den(56)
  A(124) = cont_VV(wf(:,46),wf(:,125)) * den(58)
  A(125) = cont_QA(wf(:,101),wf(:,126)) * den(123)
  A(126) = cont_VV(wf(:,58),wf(:,127)) * den(125)
  A(127) = cont_QA(wf(:,56),wf(:,120)) * den(63)
  A(128) = cont_QA(wf(:,103),wf(:,126)) * den(126)
  A(129) = cont_QA(wf(:,63),wf(:,121)) * den(76)
  A(130) = cont_QA(wf(:,61),wf(:,123)) * den(70)
  A(131) = cont_QA(wf(:,63),wf(:,124)) * den(72)
  A(132) = cont_VV(wf(:,58),wf(:,128)) * den(74)
  A(133) = cont_VV(wf(:,27),wf(:,129)) * den(127)
  A(134) = cont_VV(wf(:,65),wf(:,127)) * den(129)
  A(135) = cont_VV(wf(:,68),wf(:,127)) * den(85)
  A(136) = cont_VV(wf(:,27),wf(:,130)) * den(82)
  A(137) = cont_VV(wf(:,70),wf(:,117)) * den(131)
  A(138) = cont_VV(wf(:,10),wf(:,131)) * den(132)
  A(139) = cont_VV(wf(:,72),wf(:,117)) * den(94)
  A(140) = cont_VV(wf(:,10),wf(:,132)) * den(91)
  A(141) = cont_VV(wf(:,20),wf(:,131)) * den(99)
  A(142) = cont_VV(wf(:,37),wf(:,129)) * den(100)
  A(143) = cont_VV(wf(:,37),wf(:,130)) * den(102)
  A(144) = cont_VV(wf(:,20),wf(:,132)) * den(101)
  A(145) = cont_VV(wf(:,70),wf(:,125)) * den(95)
  A(146) = cont_VV(wf(:,65),wf(:,128)) * den(96)
  A(147) = cont_VV(wf(:,72),wf(:,125)) * den(98)
  A(148) = cont_VV(wf(:,68),wf(:,128)) * den(97)
  A(149) = cont_VV(wf(:,11),wf(:,133)) * den(133)
  A(150) = cont_QA(wf(:,134),wf(:,135)) * den(136)
  A(151) = cont_QA(wf(:,15),wf(:,138)) * den(15)
  A(152) = cont_QA(wf(:,134),wf(:,139)) * den(138)
  A(153) = cont_QA(wf(:,9),wf(:,140)) * den(21)
  A(154) = cont_QA(wf(:,5),wf(:,143)) * den(5)
  A(155) = cont_QA(wf(:,9),wf(:,144)) * den(8)
  A(156) = cont_VV(wf(:,11),wf(:,145)) * den(11)
  A(157) = cont_VV(wf(:,46),wf(:,146)) * den(139)
  A(158) = cont_QA(wf(:,147),wf(:,148)) * den(142)
  A(159) = cont_QA(wf(:,48),wf(:,149)) * den(53)
  A(160) = cont_QA(wf(:,147),wf(:,150)) * den(144)
  A(161) = cont_QA(wf(:,44),wf(:,140)) * den(59)
  A(162) = cont_QA(wf(:,41),wf(:,151)) * den(45)
  A(163) = cont_QA(wf(:,44),wf(:,144)) * den(47)
  A(164) = cont_VV(wf(:,46),wf(:,152)) * den(50)
  A(165) = cont_VV(wf(:,27),wf(:,153)) * den(145)
  A(166) = cont_VV(wf(:,57),wf(:,154)) * den(146)
  A(167) = cont_VV(wf(:,57),wf(:,155)) * den(77)
  A(168) = cont_VV(wf(:,27),wf(:,156)) * den(80)
  A(169) = cont_VV(wf(:,70),wf(:,146)) * den(147)
  A(170) = cont_VV(wf(:,64),wf(:,154)) * den(97)
  A(171) = cont_VV(wf(:,72),wf(:,146)) * den(98)
  A(172) = cont_VV(wf(:,64),wf(:,155)) * den(96)
  A(173) = cont_VV(wf(:,69),wf(:,133)) * den(148)
  A(174) = cont_VV(wf(:,71),wf(:,133)) * den(101)
  A(175) = cont_VV(wf(:,37),wf(:,153)) * den(102)
  A(176) = cont_VV(wf(:,37),wf(:,156)) * den(100)
  A(177) = cont_VV(wf(:,69),wf(:,145)) * den(88)
  A(178) = cont_VV(wf(:,70),wf(:,152)) * den(89)
  A(179) = cont_VV(wf(:,71),wf(:,145)) * den(91)
  A(180) = cont_VV(wf(:,72),wf(:,152)) * den(94)
  A(181) = cont_QA(wf(:,41),wf(:,158)) * den(63)
  A(182) = cont_VV(wf(:,57),wf(:,159)) * den(66)
  A(183) = cont_QA(wf(:,30),wf(:,161)) * den(68)
  A(184) = cont_QA(wf(:,48),wf(:,162)) * den(70)
  A(185) = cont_VV(wf(:,64),wf(:,159)) * den(74)
  A(186) = cont_QA(wf(:,51),wf(:,164)) * den(72)
  A(187) = cont_QA(wf(:,38),wf(:,161)) * den(75)
  A(188) = cont_QA(wf(:,54),wf(:,164)) * den(76)
  A(189) = cont_QA(wf(:,5),wf(:,166)) * den(26)
  A(190) = cont_VV(wf(:,27),wf(:,167)) * den(29)
  A(191) = cont_QA(wf(:,30),wf(:,169)) * den(32)
  A(192) = cont_QA(wf(:,15),wf(:,170)) * den(35)
  A(193) = cont_VV(wf(:,37),wf(:,167)) * den(39)
  A(194) = cont_QA(wf(:,18),wf(:,172)) * den(37)
  A(195) = cont_QA(wf(:,38),wf(:,169)) * den(40)
  A(196) = cont_QA(wf(:,22),wf(:,172)) * den(41)
  A(197) = cont_QA(wf(:,135),wf(:,173)) * den(149)
  A(198) = cont_VV(wf(:,28),wf(:,174)) * den(150)
  A(199) = cont_QA(wf(:,15),wf(:,177)) * den(35)
  A(200) = cont_QA(wf(:,139),wf(:,173)) * den(151)
  A(201) = cont_QA(wf(:,31),wf(:,178)) * den(40)
  A(202) = cont_QA(wf(:,5),wf(:,181)) * den(26)
  A(203) = cont_VV(wf(:,28),wf(:,182)) * den(29)
  A(204) = cont_QA(wf(:,31),wf(:,183)) * den(32)
  A(205) = cont_QA(wf(:,148),wf(:,184)) * den(152)
  A(206) = cont_VV(wf(:,58),wf(:,185)) * den(153)
  A(207) = cont_QA(wf(:,48),wf(:,186)) * den(70)
  A(208) = cont_QA(wf(:,150),wf(:,184)) * den(154)
  A(209) = cont_QA(wf(:,60),wf(:,178)) * den(75)
  A(210) = cont_QA(wf(:,41),wf(:,187)) * den(63)
  A(211) = cont_VV(wf(:,58),wf(:,188)) * den(66)
  A(212) = cont_QA(wf(:,60),wf(:,183)) * den(68)
  A(213) = cont_VV(wf(:,10),wf(:,189)) * den(155)
  A(214) = cont_VV(wf(:,45),wf(:,190)) * den(156)
  A(215) = cont_VV(wf(:,10),wf(:,191)) * den(88)
  A(216) = cont_VV(wf(:,45),wf(:,192)) * den(89)
  A(217) = cont_VV(wf(:,65),wf(:,185)) * den(157)
  A(218) = cont_VV(wf(:,68),wf(:,185)) * den(158)
  A(219) = cont_VV(wf(:,53),wf(:,190)) * den(159)
  A(220) = cont_VV(wf(:,53),wf(:,192)) * den(95)
  A(221) = cont_VV(wf(:,66),wf(:,174)) * den(160)
  A(222) = cont_VV(wf(:,20),wf(:,189)) * den(161)
  A(223) = cont_VV(wf(:,67),wf(:,174)) * den(162)
  A(224) = cont_VV(wf(:,20),wf(:,191)) * den(99)
  A(225) = cont_VV(wf(:,65),wf(:,188)) * den(77)
  A(226) = cont_VV(wf(:,66),wf(:,182)) * den(80)
  A(227) = cont_VV(wf(:,67),wf(:,182)) * den(82)
  A(228) = cont_VV(wf(:,68),wf(:,188)) * den(85)
  A(229) = cont_QA(wf(:,41),wf(:,194)) * den(45)
  A(230) = cont_QA(wf(:,8),wf(:,196)) * den(47)
  A(231) = cont_VV(wf(:,45),wf(:,197)) * den(50)
  A(232) = cont_QA(wf(:,48),wf(:,198)) * den(53)
  A(233) = cont_QA(wf(:,51),wf(:,200)) * den(56)
  A(234) = cont_VV(wf(:,53),wf(:,197)) * den(58)
  A(235) = cont_QA(wf(:,21),wf(:,196)) * den(59)
  A(236) = cont_QA(wf(:,54),wf(:,200)) * den(60)
  A(237) = cont_QA(wf(:,5),wf(:,202)) * den(5)
  A(238) = cont_QA(wf(:,8),wf(:,204)) * den(8)
  A(239) = cont_VV(wf(:,10),wf(:,205)) * den(11)
  A(240) = cont_QA(wf(:,15),wf(:,206)) * den(15)
  A(241) = cont_QA(wf(:,18),wf(:,208)) * den(18)
  A(242) = cont_VV(wf(:,20),wf(:,205)) * den(20)
  A(243) = cont_QA(wf(:,21),wf(:,204)) * den(21)
  A(244) = cont_QA(wf(:,22),wf(:,208)) * den(22)
  A(245) = cont_VV(wf(:,209),wf(:,210)) * den(166)
  A(246) = cont_QA(wf(:,212),wf(:,213)) * den(170)
  A(247) = cont_QA(wf(:,214),wf(:,215)) * den(173)
  A(248) = cont_QA(wf(:,86),wf(:,216)) * den(175)
  A(249) = cont_VV(wf(:,10),wf(:,217)) * den(176)
  A(250) = cont_VV(wf(:,11),wf(:,219)) * den(178)
  A(251) = cont_QA(wf(:,9),wf(:,220)) * den(179)
  A(252) = cont_QA(wf(:,86),wf(:,221)) * den(180)
  A(253) = cont_VV(wf(:,11),wf(:,222)) * den(181)
  A(254) = cont_VV(wf(:,210),wf(:,223)) * den(184)
  A(255) = cont_QA(wf(:,225),wf(:,226)) * den(188)
  A(256) = cont_QA(wf(:,227),wf(:,228)) * den(191)
  A(257) = cont_QA(wf(:,135),wf(:,229)) * den(192)
  A(258) = cont_VV(wf(:,20),wf(:,217)) * den(193)
  A(259) = cont_VV(wf(:,11),wf(:,231)) * den(195)
  A(260) = cont_QA(wf(:,135),wf(:,232)) * den(196)
  A(261) = cont_VV(wf(:,11),wf(:,233)) * den(197)
  A(262) = cont_QA(wf(:,19),wf(:,234)) * den(198)
  A(263) = cont_QA(wf(:,89),wf(:,216)) * den(199)
  A(264) = cont_QA(wf(:,9),wf(:,236)) * den(201)
  A(265) = cont_QA(wf(:,89),wf(:,221)) * den(202)
  A(266) = cont_QA(wf(:,139),wf(:,229)) * den(203)
  A(267) = cont_QA(wf(:,139),wf(:,232)) * den(204)
  A(268) = cont_QA(wf(:,19),wf(:,238)) * den(206)
  A(269) = cont_QA(wf(:,240),wf(:,241)) * den(210)
  A(270) = cont_VV(wf(:,242),wf(:,243)) * den(214)
  A(271) = cont_QA(wf(:,214),wf(:,244)) * den(216)
  A(272) = cont_VV(wf(:,28),wf(:,246)) * den(218)
  A(273) = cont_QA(wf(:,31),wf(:,247)) * den(219)
  A(274) = cont_QA(wf(:,101),wf(:,248)) * den(221)
  A(275) = cont_VV(wf(:,27),wf(:,249)) * den(222)
  A(276) = cont_VV(wf(:,28),wf(:,250)) * den(223)
  A(277) = cont_QA(wf(:,101),wf(:,251)) * den(224)
  A(278) = cont_QA(wf(:,253),wf(:,254)) * den(228)
  A(279) = cont_VV(wf(:,243),wf(:,255)) * den(231)
  A(280) = cont_QA(wf(:,227),wf(:,256)) * den(233)
  A(281) = cont_QA(wf(:,135),wf(:,257)) * den(234)
  A(282) = cont_VV(wf(:,28),wf(:,258)) * den(235)
  A(283) = cont_QA(wf(:,135),wf(:,259)) * den(236)
  A(284) = cont_VV(wf(:,28),wf(:,260)) * den(237)
  A(285) = cont_VV(wf(:,37),wf(:,249)) * den(238)
  A(286) = cont_QA(wf(:,36),wf(:,234)) * den(239)
  A(287) = cont_QA(wf(:,31),wf(:,262)) * den(241)
  A(288) = cont_QA(wf(:,103),wf(:,248)) * den(242)
  A(289) = cont_QA(wf(:,103),wf(:,251)) * den(243)
  A(290) = cont_QA(wf(:,139),wf(:,257)) * den(244)
  A(291) = cont_QA(wf(:,139),wf(:,259)) * den(245)
  A(292) = cont_QA(wf(:,36),wf(:,238)) * den(246)
  A(293) = cont_VV(wf(:,263),wf(:,264)) * den(250)
  A(294) = cont_QA(wf(:,212),wf(:,266)) * den(253)
  A(295) = cont_QA(wf(:,267),wf(:,268)) * den(256)
  A(296) = cont_QA(wf(:,86),wf(:,269)) * den(258)
  A(297) = cont_VV(wf(:,45),wf(:,270)) * den(259)
  A(298) = cont_VV(wf(:,46),wf(:,271)) * den(260)
  A(299) = cont_QA(wf(:,44),wf(:,220)) * den(261)
  A(300) = cont_QA(wf(:,86),wf(:,272)) * den(262)
  A(301) = cont_VV(wf(:,46),wf(:,273)) * den(263)
  A(302) = cont_VV(wf(:,264),wf(:,274)) * den(266)
  A(303) = cont_QA(wf(:,225),wf(:,276)) * den(269)
  A(304) = cont_QA(wf(:,277),wf(:,278)) * den(272)
  A(305) = cont_QA(wf(:,148),wf(:,279)) * den(273)
  A(306) = cont_VV(wf(:,53),wf(:,270)) * den(274)
  A(307) = cont_VV(wf(:,46),wf(:,281)) * den(276)
  A(308) = cont_QA(wf(:,148),wf(:,282)) * den(277)
  A(309) = cont_VV(wf(:,46),wf(:,283)) * den(278)
  A(310) = cont_QA(wf(:,52),wf(:,284)) * den(279)
  A(311) = cont_QA(wf(:,89),wf(:,269)) * den(280)
  A(312) = cont_QA(wf(:,44),wf(:,236)) * den(281)
  A(313) = cont_QA(wf(:,89),wf(:,272)) * den(282)
  A(314) = cont_QA(wf(:,150),wf(:,279)) * den(283)
  A(315) = cont_QA(wf(:,150),wf(:,282)) * den(284)
  A(316) = cont_QA(wf(:,52),wf(:,286)) * den(286)
  A(317) = cont_QA(wf(:,240),wf(:,288)) * den(289)
  A(318) = cont_VV(wf(:,289),wf(:,290)) * den(293)
  A(319) = cont_QA(wf(:,267),wf(:,291)) * den(295)
  A(320) = cont_VV(wf(:,58),wf(:,292)) * den(296)
  A(321) = cont_QA(wf(:,60),wf(:,247)) * den(297)
  A(322) = cont_QA(wf(:,101),wf(:,293)) * den(299)
  A(323) = cont_VV(wf(:,57),wf(:,294)) * den(300)
  A(324) = cont_VV(wf(:,58),wf(:,295)) * den(301)
  A(325) = cont_QA(wf(:,101),wf(:,296)) * den(302)
  A(326) = cont_QA(wf(:,253),wf(:,298)) * den(305)
  A(327) = cont_VV(wf(:,290),wf(:,299)) * den(308)
  A(328) = cont_QA(wf(:,277),wf(:,300)) * den(310)
  A(329) = cont_QA(wf(:,148),wf(:,301)) * den(311)
  A(330) = cont_VV(wf(:,58),wf(:,302)) * den(312)
  A(331) = cont_QA(wf(:,148),wf(:,303)) * den(313)
  A(332) = cont_VV(wf(:,58),wf(:,304)) * den(314)
  A(333) = cont_VV(wf(:,64),wf(:,294)) * den(315)
  A(334) = cont_QA(wf(:,63),wf(:,284)) * den(316)
  A(335) = cont_QA(wf(:,60),wf(:,262)) * den(317)
  A(336) = cont_QA(wf(:,103),wf(:,293)) * den(318)
  A(337) = cont_QA(wf(:,103),wf(:,296)) * den(319)
  A(338) = cont_QA(wf(:,150),wf(:,301)) * den(320)
  A(339) = cont_QA(wf(:,150),wf(:,303)) * den(321)
  A(340) = cont_QA(wf(:,63),wf(:,286)) * den(322)
  A(341) = cont_VV(wf(:,65),wf(:,292)) * den(323)
  A(342) = cont_VV(wf(:,66),wf(:,246)) * den(324)
  A(343) = cont_VV(wf(:,27),wf(:,305)) * den(325)
  A(344) = cont_VV(wf(:,57),wf(:,306)) * den(326)
  A(345) = cont_VV(wf(:,65),wf(:,295)) * den(327)
  A(346) = cont_VV(wf(:,27),wf(:,307)) * den(328)
  A(347) = cont_VV(wf(:,67),wf(:,246)) * den(329)
  A(348) = cont_VV(wf(:,27),wf(:,308)) * den(330)
  A(349) = cont_VV(wf(:,27),wf(:,309)) * den(331)
  A(350) = cont_VV(wf(:,68),wf(:,292)) * den(332)
  A(351) = cont_VV(wf(:,57),wf(:,310)) * den(333)
  A(352) = cont_VV(wf(:,57),wf(:,311)) * den(334)
  A(353) = cont_VV(wf(:,10),wf(:,312)) * den(335)
  A(354) = cont_VV(wf(:,45),wf(:,313)) * den(336)
  A(355) = cont_VV(wf(:,70),wf(:,271)) * den(337)
  A(356) = cont_VV(wf(:,69),wf(:,219)) * den(338)
  A(357) = cont_VV(wf(:,10),wf(:,314)) * den(339)
  A(358) = cont_VV(wf(:,70),wf(:,273)) * den(340)
  A(359) = cont_VV(wf(:,10),wf(:,315)) * den(341)
  A(360) = cont_VV(wf(:,10),wf(:,316)) * den(342)
  A(361) = cont_VV(wf(:,71),wf(:,219)) * den(343)
  A(362) = cont_VV(wf(:,45),wf(:,317)) * den(344)
  A(363) = cont_VV(wf(:,45),wf(:,318)) * den(345)
  A(364) = cont_VV(wf(:,72),wf(:,271)) * den(346)
  A(365) = cont_VV(wf(:,53),wf(:,313)) * den(347)
  A(366) = cont_VV(wf(:,70),wf(:,281)) * den(348)
  A(367) = cont_VV(wf(:,70),wf(:,283)) * den(349)
  A(368) = cont_VV(wf(:,65),wf(:,302)) * den(350)
  A(369) = cont_VV(wf(:,65),wf(:,304)) * den(351)
  A(370) = cont_VV(wf(:,64),wf(:,306)) * den(352)
  A(371) = cont_VV(wf(:,68),wf(:,304)) * den(353)
  A(372) = cont_VV(wf(:,53),wf(:,317)) * den(354)
  A(373) = cont_VV(wf(:,68),wf(:,302)) * den(355)
  A(374) = cont_VV(wf(:,53),wf(:,318)) * den(356)
  A(375) = cont_VV(wf(:,72),wf(:,281)) * den(357)
  A(376) = cont_VV(wf(:,64),wf(:,311)) * den(358)
  A(377) = cont_VV(wf(:,20),wf(:,312)) * den(359)
  A(378) = cont_VV(wf(:,69),wf(:,233)) * den(360)
  A(379) = cont_VV(wf(:,69),wf(:,231)) * den(361)
  A(380) = cont_VV(wf(:,66),wf(:,260)) * den(362)
  A(381) = cont_VV(wf(:,66),wf(:,258)) * den(363)
  A(382) = cont_VV(wf(:,37),wf(:,305)) * den(364)
  A(383) = cont_VV(wf(:,20),wf(:,316)) * den(365)
  A(384) = cont_VV(wf(:,67),wf(:,260)) * den(366)
  A(385) = cont_VV(wf(:,20),wf(:,315)) * den(367)
  A(386) = cont_VV(wf(:,67),wf(:,258)) * den(368)
  A(387) = cont_VV(wf(:,37),wf(:,308)) * den(369)
  A(388) = cont_VV(wf(:,71),wf(:,231)) * den(370)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(388)
  complex(REALKIND), intent(out) :: M1(4), M2(4)

  M1(1) = ((A(25)+A(27)+A(28)+A(29)+A(31)+A(32)+A(37)+A(39)+A(45)+A(47))*f(1))/6._/**/REALKIND+((A(11)+A(12)+A(15)+A(17)+A(21) &
       +A(24)+A(35)+A(38)+A(41)+A(48))*f(1))/2._/**/REALKIND+(CI*(A(10)+A(14)-A(19)-A(22))*f(2))/2._/**/REALKIND
  M1(2) = ((-A(2)-A(4)-A(7)-A(25)-A(29)-A(32)-A(33)-A(39)-A(42)-A(47))*f(1))/2._/**/REALKIND+((-A(17)-A(18)-A(20)-A(21)-A(23) &
       -A(24)-A(34)-A(35)-A(46)-A(48))*f(1))/6._/**/REALKIND+(CI*(-A(3)-A(6)+A(26)+A(30))*f(2))/2._/**/REALKIND
  M1(3) = ((-A(9)-A(11)-A(12)-A(13)-A(15)-A(16)-A(38)-A(40)-A(41)-A(44))*f(1))/6._/**/REALKIND+((-A(1)-A(5)-A(8)-A(27)-A(28)-A(31) &
       -A(36)-A(37)-A(43)-A(45))*f(1))/2._/**/REALKIND+(CI*(A(3)+A(6)-A(26)-A(30))*f(2))/2._/**/REALKIND
  M1(4) = ((A(1)+A(2)+A(4)+A(5)+A(7)+A(8)+A(33)+A(36)+A(42)+A(43))*f(1))/6._/**/REALKIND+((A(9)+A(13)+A(16)+A(18)+A(20)+A(23) &
       +A(34)+A(40)+A(44)+A(46))*f(1))/2._/**/REALKIND+(CI*(-A(10)-A(14)+A(19)+A(22))*f(2))/2._/**/REALKIND

  M2(1) = ((-A(273)-A(274)-A(277)-A(278)-A(279)-A(280)-A(287)-A(288)-A(289)-A(293)-A(294)-A(295)-A(305)-A(308)-A(310)-A(314) &
       -A(315)-A(316)-A(347)-A(348)-A(349)-A(354)-A(355)-A(358)-A(365)-A(366)-A(367)-A(384)-A(386)-A(387))*f(3))/2._/**/REALKIND &
       +((-A(317)-A(318)-A(319)-A(321)-A(322)-A(325)-A(326)-A(327)-A(328)-A(329)-A(331)-A(334)-A(335)-A(336)-A(337)-A(338)-A(339) &
       -A(340)-A(353)-A(356)-A(357)-A(359)-A(360)-A(361)-A(377)-A(378)-A(379)-A(383)-A(385)-A(388))*f(3))/6._/**/REALKIND+((-A(49) &
       -A(50))*f(4))/12._/**/REALKIND-(A(52)*f(4))/4._/**/REALKIND+(CI*(-A(272)-A(275)-A(276)-A(282)-A(284)-A(285)+A(297)+A(298) &
       +A(301)+A(306)+A(307)+A(309))*f(5))/2._/**/REALKIND+((A(93)+A(95)+A(96)+A(97)+A(105)+A(107)+A(125)+A(127)+A(128)+A(129) &
       +A(138)+A(140)+A(141)+A(144)+A(173)+A(174)+A(181)+A(183)+A(184)+A(186)+A(187)+A(188)+A(205)+A(207)+A(208)+A(209)+A(213) &
       +A(215)+A(222)+A(224))*f(6))/6._/**/REALKIND+((A(71)+A(72)+A(77)+A(80)+A(85)+A(89)+A(103)+A(106)+A(109)+A(119)+A(121) &
       +A(136)+A(137)+A(143)+A(158)+A(160)+A(165)+A(169)+A(175)+A(191)+A(192)+A(195)+A(199)+A(201)+A(216)+A(220)+A(223)+A(229) &
       +A(233)+A(236))*f(6))/2._/**/REALKIND+(CI*(A(78)-A(117)-A(157)+A(190)+A(193)+A(198)-A(231)-A(234))*f(7))/2._/**/REALKIND &
       +((A(99)+A(100)+A(113)+A(115)+A(130)+A(131)+A(177)+A(179)+A(210)+A(212))*f(8))/6._/**/REALKIND+((A(75)+A(82)+A(92)+A(116) &
       +A(123)+A(145)+A(162)+A(178)+A(204)+A(227))*f(8))/2._/**/REALKIND+(CI*(A(84)-A(124)-A(164)+A(203))*f(9))/2._/**/REALKIND &
       +(CI*(A(70)+A(74)-A(87)-A(90))*f(10))/2._/**/REALKIND
  M2(2) = ((A(293)+A(294)+A(295)+A(296)+A(299)+A(300)+A(302)+A(303)+A(304)+A(305)+A(308)+A(310)+A(311)+A(312)+A(313)+A(314)+A(315) &
       +A(316)+A(342)+A(343)+A(346)+A(347)+A(348)+A(349)+A(380)+A(381)+A(382)+A(384)+A(386)+A(387))*f(3))/6._/**/REALKIND+((A(248) &
       +A(251)+A(252)+A(254)+A(255)+A(256)+A(263)+A(264)+A(265)+A(317)+A(318)+A(319)+A(329)+A(331)+A(334)+A(338)+A(339)+A(340) &
       +A(341)+A(344)+A(345)+A(359)+A(360)+A(361)+A(368)+A(369)+A(370)+A(383)+A(385)+A(388))*f(3))/2._/**/REALKIND &
       +(A(49)*f(4))/4._/**/REALKIND+((A(51)+A(52))*f(4))/12._/**/REALKIND+(CI*(A(249)+A(250)+A(253)+A(258)+A(259)+A(261)-A(320) &
       -A(323)-A(324)-A(330)-A(332)-A(333))*f(5))/2._/**/REALKIND+((-A(85)-A(86)-A(88)-A(89)-A(102)-A(103)-A(118)-A(119)-A(120) &
       -A(121)-A(133)-A(136)-A(142)-A(143)-A(158)-A(159)-A(160)-A(161)-A(165)-A(168)-A(175)-A(176)-A(221)-A(223)-A(229)-A(230) &
       -A(232)-A(233)-A(235)-A(236))*f(6))/6._/**/REALKIND+((-A(54)-A(56)-A(62)-A(64)-A(93)-A(97)-A(101)-A(107)-A(110)-A(127) &
       -A(129)-A(134)-A(140)-A(144)-A(151)-A(153)-A(167)-A(172)-A(174)-A(181)-A(186)-A(188)-A(205)-A(208)-A(213)-A(217)-A(222) &
       -A(238)-A(240)-A(243))*f(6))/2._/**/REALKIND+(CI*(-A(61)+A(126)-A(149)+A(182)+A(185)+A(206)-A(239) &
       -A(242))*f(7))/2._/**/REALKIND+((-A(59)-A(66)-A(100)-A(115)-A(131)-A(146)-A(155)-A(179)-A(210) &
       -A(225))*f(8))/2._/**/REALKIND+((-A(91)-A(92)-A(114)-A(116)-A(122)-A(123)-A(162)-A(163)-A(226) &
       -A(227))*f(8))/6._/**/REALKIND+(CI*(-A(68)+A(132)-A(156)+A(211))*f(9))/2._/**/REALKIND+(CI*(-A(55)-A(58)+A(94) &
       +A(98))*f(10))/2._/**/REALKIND
  M2(3) = ((A(269)+A(270)+A(271)+A(273)+A(274)+A(277)+A(278)+A(279)+A(280)+A(281)+A(283)+A(286)+A(287)+A(288)+A(289)+A(290)+A(291) &
       +A(292)+A(354)+A(355)+A(358)+A(362)+A(363)+A(364)+A(365)+A(366)+A(367)+A(372)+A(374)+A(375))*f(3))/6._/**/REALKIND+((A(245) &
       +A(246)+A(247)+A(257)+A(260)+A(262)+A(266)+A(267)+A(268)+A(321)+A(322)+A(325)+A(326)+A(327)+A(328)+A(335)+A(336)+A(337) &
       +A(350)+A(351)+A(352)+A(353)+A(356)+A(357)+A(371)+A(373)+A(376)+A(377)+A(378)+A(379))*f(3))/2._/**/REALKIND &
       +(A(50)*f(4))/4._/**/REALKIND+((A(51)+A(52))*f(4))/12._/**/REALKIND+(CI*(-A(249)-A(250)-A(253)-A(258)-A(259)-A(261)+A(320) &
       +A(323)+A(324)+A(330)+A(332)+A(333))*f(5))/2._/**/REALKIND+((-A(69)-A(71)-A(72)-A(73)-A(77)-A(79)-A(80)-A(81)-A(106)-A(108) &
       -A(109)-A(112)-A(137)-A(139)-A(169)-A(171)-A(189)-A(191)-A(192)-A(194)-A(195)-A(196)-A(197)-A(199)-A(200)-A(201)-A(214) &
       -A(216)-A(219)-A(220))*f(6))/6._/**/REALKIND+((-A(53)-A(57)-A(63)-A(65)-A(95)-A(96)-A(104)-A(105)-A(111)-A(125)-A(128) &
       -A(135)-A(138)-A(141)-A(150)-A(152)-A(166)-A(170)-A(173)-A(183)-A(184)-A(187)-A(207)-A(209)-A(215)-A(218)-A(224)-A(237) &
       -A(241)-A(244))*f(6))/2._/**/REALKIND+(CI*(A(61)-A(126)+A(149)-A(182)-A(185)-A(206)+A(239)+A(242))*f(7))/2._/**/REALKIND+(( &
       -A(75)-A(76)-A(82)-A(83)-A(145)-A(147)-A(178)-A(180)-A(202)-A(204))*f(8))/6._/**/REALKIND+((-A(60)-A(67)-A(99)-A(113) &
       -A(130)-A(148)-A(154)-A(177)-A(212)-A(228))*f(8))/2._/**/REALKIND+(CI*(A(68)-A(132)+A(156)-A(211))*f(9))/2._/**/REALKIND &
       +(CI*(A(55)+A(58)-A(94)-A(98))*f(10))/2._/**/REALKIND
  M2(4) = ((-A(245)-A(246)-A(247)-A(248)-A(251)-A(252)-A(254)-A(255)-A(256)-A(257)-A(260)-A(262)-A(263)-A(264)-A(265)-A(266) &
       -A(267)-A(268)-A(341)-A(344)-A(345)-A(350)-A(351)-A(352)-A(368)-A(369)-A(370)-A(371)-A(373)-A(376))*f(3))/6._/**/REALKIND &
       +((-A(269)-A(270)-A(271)-A(281)-A(283)-A(286)-A(290)-A(291)-A(292)-A(296)-A(299)-A(300)-A(302)-A(303)-A(304)-A(311)-A(312) &
       -A(313)-A(342)-A(343)-A(346)-A(362)-A(363)-A(364)-A(372)-A(374)-A(375)-A(380)-A(381)-A(382))*f(3))/2._/**/REALKIND+((-A(49) &
       -A(50))*f(4))/12._/**/REALKIND-(A(51)*f(4))/4._/**/REALKIND+(CI*(A(272)+A(275)+A(276)+A(282)+A(284)+A(285)-A(297)-A(298) &
       -A(301)-A(306)-A(307)-A(309))*f(5))/2._/**/REALKIND+((A(69)+A(73)+A(79)+A(81)+A(86)+A(88)+A(102)+A(108)+A(112)+A(118) &
       +A(120)+A(133)+A(139)+A(142)+A(159)+A(161)+A(168)+A(171)+A(176)+A(189)+A(194)+A(196)+A(197)+A(200)+A(214)+A(219)+A(221) &
       +A(230)+A(232)+A(235))*f(6))/2._/**/REALKIND+((A(53)+A(54)+A(56)+A(57)+A(62)+A(63)+A(64)+A(65)+A(101)+A(104)+A(110)+A(111) &
       +A(134)+A(135)+A(150)+A(151)+A(152)+A(153)+A(166)+A(167)+A(170)+A(172)+A(217)+A(218)+A(237)+A(238)+A(240)+A(241)+A(243) &
       +A(244))*f(6))/6._/**/REALKIND+(CI*(-A(78)+A(117)+A(157)-A(190)-A(193)-A(198)+A(231)+A(234))*f(7))/2._/**/REALKIND+((A(76) &
       +A(83)+A(91)+A(114)+A(122)+A(147)+A(163)+A(180)+A(202)+A(226))*f(8))/2._/**/REALKIND+((A(59)+A(60)+A(66)+A(67)+A(146) &
       +A(148)+A(154)+A(155)+A(225)+A(228))*f(8))/6._/**/REALKIND+(CI*(-A(84)+A(124)+A(164)-A(203))*f(9))/2._/**/REALKIND+(CI*( &
       -A(70)-A(74)+A(87)+A(90))*f(10))/2._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pptttt_ew_tttxtxag_1_/**/REALKIND
