
module ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(184,8)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [   0,   0,   0,   0,   3,   0,   9,   0]
  K1(  2,:) = [   0,   0,   0,   0,   9,   0,   3,   0]
  K1(  3,:) = [   0,   0,   0,   0,   9,   0,   3,   0]
  K1(  4,:) = [   0,   0,   0,   0,   3,   0,   9,   0]
  K1(  5,:) = [   3,   9,   9,   3,   0,  27,   0,   9]
  K1(  6,:) = [   0,   0,   0,   0,  27,   0,   9,   0]
  K1(  7,:) = [   9,   3,   3,   9,   0,   9,   0,  27]
  K1(  8,:) = [   0,   0,   0,   0,   9,   0,  27,   0]
  K1(  9,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 10,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 11,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 12,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 13,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1( 14,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 15,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1( 16,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 17,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 18,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 19,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 20,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 21,:) = [   0,   0,   0,   0,   0,   0,  12,   0]
  K1( 22,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 23,:) = [   0,   0,   0,   0,  12,   0,   0,   0]
  K1( 24,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 25,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 26,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 27,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 28,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 29,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1( 30,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 31,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1( 32,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 33,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 34,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 35,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 36,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 37,:) = [   0,   0,   0,   0,   0,   0, -12,   0]
  K1( 38,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 39,:) = [   0,   0,   0,   0, -12,   0, -36,   0]
  K1( 40,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 41,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 42,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 43,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 44,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 45,:) = [   0,   0,   0,   0, -36,   0, -12,   0]
  K1( 46,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 47,:) = [   0,   0,   0,   0, -12,   0,   0,   0]
  K1( 48,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 49,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 50,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 51,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 52,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 53,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1( 54,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 55,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1( 56,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 57,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 58,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 59,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 60,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 61,:) = [   0,   0,   0,   0, -36,   0, -12,   0]
  K1( 62,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 63,:) = [   0,   0,   0,   0, -12,   0,   0,   0]
  K1( 64,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 65,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 66,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 67,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 68,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 69,:) = [   0,   0,   0,   0,   0,   0, -12,   0]
  K1( 70,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 71,:) = [   0,   0,   0,   0, -12,   0, -36,   0]
  K1( 72,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 73,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 74,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 75,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 76,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 77,:) = [   0,   0,   0,   0,   0,   0,  12,   0]
  K1( 78,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 79,:) = [   0,   0,   0,   0,  12,   0,   0,   0]
  K1( 80,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 81,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 82,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 83,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 84,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 85,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1( 86,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 87,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1( 88,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 89,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 90,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 91,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 92,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 93,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 94,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 95,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 96,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 97,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 98,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1( 99,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(100,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(101,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(102,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(103,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(104,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(105,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(106,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(107,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(108,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(109,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(110,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(111,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(112,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(113,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(114,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(115,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(116,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(117,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(118,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(119,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(120,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(121,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(122,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(123,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(124,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(125,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1(126,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(127,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1(128,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(129,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(130,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(131,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(132,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(133,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(134,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(135,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(136,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(137,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(138,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(139,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(140,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(141,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(142,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(143,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(144,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(145,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(146,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(147,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(148,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(149,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(150,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(151,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(152,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(153,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(154,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(155,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(156,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(157,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(158,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(159,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(160,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(161,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(162,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(163,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(164,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(165,:) = [   0,   0,   0,   0, -36,   0, -12,   0]
  K1(166,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(167,:) = [   0,   0,   0,   0, -12,   0, -36,   0]
  K1(168,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(169,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(170,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(171,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(172,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(173,:) = [   0,   0,   0,   0,  36,   0,  12,   0]
  K1(174,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(175,:) = [   0,   0,   0,   0,  12,   0,  36,   0]
  K1(176,:) = [   0,   0,   0,   0,   0,   0,   0,   0]
  K1(177,:) = [   0,   0,   0,   0,   3,   0,   9,   0]
  K1(178,:) = [   0,   0,   0,   0,   9,   0,   3,   0]
  K1(179,:) = [   0,   0,   0,   0,   9,   0,   3,   0]
  K1(180,:) = [   0,   0,   0,   0,   3,   0,   9,   0]
  K1(181,:) = [   3,   9,   9,   3,   0,  27,   0,   9]
  K1(182,:) = [   0,   0,   0,   0,  27,   0,   9,   0]
  K1(183,:) = [   9,   3,   3,   9,   0,   9,   0,  27]
  K1(184,:) = [   0,   0,   0,   0,   9,   0,  27,   0]


  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND



module ol_forced_parameters_pptttt_ew_tttxtxddx_4_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_ew_tttxtxddx_4_/**/REALKIND

module ol_tree_pptttt_ew_tttxtxddx_4_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(13)
  complex(REALKIND), save :: den(118)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
  complex(DREALKIND) :: M1helarr(8,64) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f( 1) = (4*CI*eQED**4)/81._/**/REALKIND
    f( 2) = (8*CI*eQED**4)/81._/**/REALKIND
    f( 3) = (2*CI*eQED**4)/9._/**/REALKIND
    f( 4) = (4*CI*eQED**4)/9._/**/REALKIND
    f( 5) = CI*eQED**4
    f( 6) = (2*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 7) = (4*CI*eQED**2*gQCD**2)/9._/**/REALKIND
    f( 8) = CI*eQED**2*gQCD**2
    f( 9) = (CI*eQED**4*MT**2)/(8._/**/REALKIND*cw*MW**2*sw**3)
    f(10) = (CI*eQED**4*MT)/(2._/**/REALKIND*cw**2*sw**2)
    f(11) = (CI*eQED**4*MT**2)/(18._/**/REALKIND*MW**2*sw**2)
    f(12) = (CI*eQED**4*MT**2)/(4._/**/REALKIND*MW**2*sw**2)
    f(13) = (CI*eQED**2*gQCD**2*MT**2)/(4._/**/REALKIND*MW**2*sw**2)

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

  den(1) = 1 / (Q(5,5) - MH2)
  den(2) = 1 / (Q(5,10) - MZ2)
  den(3) = 1 / (Q(5,48) - MZ2)
  den(6) = 1 / (Q(5,5) - MZ2)
  den(7) = 1 / (Q(5,10) - MH2)
  den(10) = 1 / (Q(5,5))
  den(11) = 1 / (Q(5,10))
  den(12) = 1 / (Q(5,21))
  den(19) = 1 / (Q(5,26))
  den(26) = 1 / (Q(5,48))
  den(27) = 1 / (Q(5,7) - MT2)
  den(37) = 1 / (Q(5,50) - MT2)
  den(46) = 1 / (Q(5,9) - MH2)
  den(47) = 1 / (Q(5,6) - MZ2)
  den(50) = 1 / (Q(5,9) - MZ2)
  den(51) = 1 / (Q(5,6) - MH2)
  den(54) = 1 / (Q(5,9))
  den(55) = 1 / (Q(5,6))
  den(56) = 1 / (Q(5,25))
  den(63) = 1 / (Q(5,22))
  den(79) = 1 / (Q(5,49) - MT2)
  den(88) = 1 / (Q(5,11) - MT2)

  ! denominators

  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(8) = den(6)*den(7)
  den(9) = den(3)*den(8)
  den(13) = den(10)*den(12)
  den(14) = den(11)*den(13)
  den(15) = den(2)*den(13)
  den(16) = den(6)*den(12)
  den(17) = den(11)*den(16)
  den(18) = den(2)*den(16)
  den(20) = den(11)*den(19)
  den(21) = den(10)*den(20)
  den(22) = den(2)*den(19)
  den(23) = den(10)*den(22)
  den(24) = den(6)*den(20)
  den(25) = den(6)*den(22)
  den(28) = den(1)*den(27)
  den(29) = den(26)*den(28)
  den(30) = den(3)*den(28)
  den(31) = den(6)*den(27)
  den(32) = den(26)*den(31)
  den(33) = den(3)*den(31)
  den(34) = den(10)*den(27)
  den(35) = den(26)*den(34)
  den(36) = den(3)*den(34)
  den(38) = den(26)*den(37)
  den(39) = den(1)*den(38)
  den(40) = den(3)*den(37)
  den(41) = den(1)*den(40)
  den(42) = den(6)*den(38)
  den(43) = den(6)*den(40)
  den(44) = den(10)*den(38)
  den(45) = den(10)*den(40)
  den(48) = den(46)*den(47)
  den(49) = den(3)*den(48)
  den(52) = den(50)*den(51)
  den(53) = den(3)*den(52)
  den(57) = den(54)*den(56)
  den(58) = den(55)*den(57)
  den(59) = den(47)*den(57)
  den(60) = den(50)*den(56)
  den(61) = den(55)*den(60)
  den(62) = den(47)*den(60)
  den(64) = den(55)*den(63)
  den(65) = den(54)*den(64)
  den(66) = den(47)*den(63)
  den(67) = den(54)*den(66)
  den(68) = den(50)*den(64)
  den(69) = den(50)*den(66)
  den(70) = den(27)*den(51)
  den(71) = den(26)*den(70)
  den(72) = den(3)*den(70)
  den(73) = den(27)*den(47)
  den(74) = den(26)*den(73)
  den(75) = den(3)*den(73)
  den(76) = den(27)*den(55)
  den(77) = den(26)*den(76)
  den(78) = den(3)*den(76)
  den(80) = den(26)*den(79)
  den(81) = den(51)*den(80)
  den(82) = den(47)*den(80)
  den(83) = den(3)*den(79)
  den(84) = den(51)*den(83)
  den(85) = den(47)*den(83)
  den(86) = den(55)*den(80)
  den(87) = den(55)*den(83)
  den(89) = den(46)*den(88)
  den(90) = den(26)*den(89)
  den(91) = den(3)*den(89)
  den(92) = den(50)*den(88)
  den(93) = den(26)*den(92)
  den(94) = den(3)*den(92)
  den(95) = den(54)*den(88)
  den(96) = den(26)*den(95)
  den(97) = den(3)*den(95)
  den(98) = den(38)*den(46)
  den(99) = den(40)*den(46)
  den(100) = den(38)*den(50)
  den(101) = den(40)*den(50)
  den(102) = den(38)*den(54)
  den(103) = den(40)*den(54)
  den(104) = den(7)*den(88)
  den(105) = den(26)*den(104)
  den(106) = den(3)*den(104)
  den(107) = den(2)*den(88)
  den(108) = den(26)*den(107)
  den(109) = den(3)*den(107)
  den(110) = den(11)*den(88)
  den(111) = den(26)*den(110)
  den(112) = den(3)*den(110)
  den(113) = den(7)*den(80)
  den(114) = den(2)*den(80)
  den(115) = den(7)*den(83)
  den(116) = den(2)*den(83)
  den(117) = den(11)*den(80)
  den(118) = den(11)*den(83)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_pptttt_ew_tttxtxddx_4_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top top anti-top anti-top down anti-down -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_pptttt_ew_tttxtxddx_4, only: &
    & external_perm_pptttt_ew_tttxtxddx_4, &
    & external_perm_inv_pptttt_ew_tttxtxddx_4, &
    & extcomb_perm_pptttt_ew_tttxtxddx_4, &
    & average_factor_pptttt_ew_tttxtxddx_4, &
    & photonid_pptttt_ew_tttxtxddx_4
  use ol_external_pptttt_ew_tttxtxddx_4, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptttt_ew_tttxtxddx_4_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_pptttt_ew_tttxtxddx_4
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,6)
  real(REALKIND)    :: extmasses2(6)
  real(REALKIND)    :: M2add(0:23-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(8), M1helarray(8,64)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0, bornphotonfactor
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,18), wf8(8,84), wf16(16,8), wf64(64,152)

  type(polcont) :: A(64,152)
  complex(REALKIND) :: Aj(152)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    call check_forced_parameters()
  end if
  call factors_init()

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rMT2, rMT2, rMT2, rMT2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, &
    & external_perm_inv_pptttt_ew_tttxtxddx_4,6)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,6)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_pptttt_ew_tttxtxddx_4(I)
  else if (I < 0) then
    JBmunu = external_perm_pptttt_ew_tttxtxddx_4(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = &
      & extcomb_perm_pptttt_ew_tttxtxddx_4(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1))
  call pol_wf_Q(P(:,2), rMT, H2, ex2, POLSEL(2))
  call pol_wf_A(P(:,3), rMT, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4))
  call pol_wf_Q(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_A(P(:,6), rZERO, H6, ex6, POLSEL(6))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rMT, H1, ex1, 0)
      call pol_wf_Q(P(:,2), rMT, H2, ex2, 0)
      call pol_wf_A(P(:,3), rMT, H3, ex3, 0)
      call pol_wf_A(P(:,4), rMT, H4, ex4, 0)
      call pol_wf_Q(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_A(P(:,6), rZERO, H6, ex6, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_AQ_S(gH,ntry, ex3, ex1, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_AQ_S(gX,ntry, ex4, ex2, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_QA_Z(gZd,ntry, ex5, ex6, wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_ST_V(ntry, wf4(:,2), Q(:,10), wf4(:,1), Q(:,5), wf16(:,1), n3(:,4), t3x16(:,:,1))
  call vert_AQ_S(gX,ntry, ex3, ex1, wf4(:,4), n3(:,5), t3x4(:,:,4))
  call vert_AQ_S(gH,ntry, ex4, ex2, wf4(:,5), n3(:,6), t3x4(:,:,5))
  call vert_ST_V(ntry, wf4(:,4), Q(:,5), wf4(:,5), Q(:,10), wf16(:,2), n3(:,7), t3x16(:,:,2))
  call vert_QA_Z(gZu,ntry, ex2, ex4, wf4(:,6), n3(:,8), t3x4(:,:,6))
  call vert_SV_V(ntry, wf4(:,1), wf4(:,6), wf16(:,3), n3(:,9), t3x16(:,:,3))
  call vert_QA_Z(gZu,ntry, ex1, ex3, wf4(:,7), n3(:,10), t3x4(:,:,7))
  call vert_SV_V(ntry, wf4(:,5), wf4(:,7), wf16(:,4), n3(:,11), t3x16(:,:,4))
  call vert_QA_V(ntry, ex1, ex3, wf4(:,8), n3(:,12), t3x4(:,:,8))
  call vert_QA_V(ntry, ex2, ex4, wf4(:,9), n3(:,13), t3x4(:,:,9))
  call vert_VQ_A(ntry, wf4(:,8), ex5, wf8(:,1), n3(:,14), t3x8(:,:,1))
  call vert_AV_Q(ntry, ex6, wf4(:,9), wf8(:,2), n3(:,15), t3x8(:,:,2))
  call prop_Q_A(ntry, wf8(:,1), Q(:,21), ZERO, 0_intkind1, wf8(:,3), n2(1))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,6), wf8(:,4), n3(:,16), t3x8(:,:,3))
  call vert_ZQ_A(gZd,ntry, wf4(:,7), ex5, wf8(:,5), n3(:,17), t3x8(:,:,4))
  call prop_Q_A(ntry, wf8(:,5), Q(:,21), ZERO, 0_intkind1, wf8(:,6), n2(2))
  call vert_VQ_A(ntry, wf4(:,9), ex5, wf8(:,7), n3(:,18), t3x8(:,:,5))
  call vert_AV_Q(ntry, ex6, wf4(:,8), wf8(:,8), n3(:,19), t3x8(:,:,6))
  call prop_Q_A(ntry, wf8(:,7), Q(:,26), ZERO, 0_intkind1, wf8(:,9), n2(3))
  call vert_ZQ_A(gZd,ntry, wf4(:,6), ex5, wf8(:,10), n3(:,20), t3x8(:,:,7))
  call prop_Q_A(ntry, wf8(:,10), Q(:,26), ZERO, 0_intkind1, wf8(:,11), n2(4))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,7), wf8(:,12), n3(:,21), t3x8(:,:,8))
  call vert_QA_V(ntry, ex5, ex6, wf4(:,10), n3(:,22), t3x4(:,:,10))
  call vert_QS_A(gH,ntry, ex2, wf4(:,1), wf8(:,13), n3(:,23), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex4, wf4(:,10), wf8(:,14), n3(:,24), t3x8(:,:,10))
  call prop_Q_A(ntry, wf8(:,13), Q(:,7), MT, 1_intkind1, wf8(:,15), n2(5))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,3), wf8(:,16), n3(:,25), t3x8(:,:,11))
  call vert_QS_A(gX,ntry, ex2, wf4(:,4), wf8(:,17), n3(:,26), t3x8(:,:,12))
  call prop_Q_A(ntry, wf8(:,17), Q(:,7), MT, 1_intkind1, wf8(:,18), n2(6))
  call vert_VQ_A(ntry, wf4(:,8), ex2, wf8(:,19), n3(:,27), t3x8(:,:,13))
  call prop_Q_A(ntry, wf8(:,19), Q(:,7), MT, 1_intkind1, wf8(:,20), n2(7))
  call vert_ZQ_A(gZu,ntry, wf4(:,7), ex2, wf8(:,21), n3(:,28), t3x8(:,:,14))
  call prop_Q_A(ntry, wf8(:,21), Q(:,7), MT, 1_intkind1, wf8(:,22), n2(8))
  call vert_VQ_A(ntry, wf4(:,10), ex2, wf8(:,23), n3(:,29), t3x8(:,:,15))
  call vert_SA_Q(gH,ntry, wf4(:,1), ex4, wf8(:,24), n3(:,30), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,23), Q(:,50), MT, 1_intkind1, wf8(:,25), n2(9))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), ex2, wf8(:,26), n3(:,31), t3x8(:,:,17))
  call prop_Q_A(ntry, wf8(:,26), Q(:,50), MT, 1_intkind1, wf8(:,27), n2(10))
  call vert_SA_Q(gX,ntry, wf4(:,4), ex4, wf8(:,28), n3(:,32), t3x8(:,:,18))
  call vert_AV_Q(ntry, ex4, wf4(:,8), wf8(:,29), n3(:,33), t3x8(:,:,19))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,7), wf8(:,30), n3(:,34), t3x8(:,:,20))
  call vert_AQ_S(gH,ntry, ex4, ex1, wf4(:,11), n3(:,35), t3x4(:,:,11))
  call vert_AQ_S(gX,ntry, ex3, ex2, wf4(:,12), n3(:,36), t3x4(:,:,12))
  call vert_ST_V(ntry, wf4(:,12), Q(:,6), wf4(:,11), Q(:,9), wf16(:,5), n3(:,37), t3x16(:,:,5))
  call vert_AQ_S(gX,ntry, ex4, ex1, wf4(:,13), n3(:,38), t3x4(:,:,13))
  call vert_AQ_S(gH,ntry, ex3, ex2, wf4(:,14), n3(:,39), t3x4(:,:,14))
  call vert_ST_V(ntry, wf4(:,13), Q(:,9), wf4(:,14), Q(:,6), wf16(:,6), n3(:,40), t3x16(:,:,6))
  call vert_QA_Z(gZu,ntry, ex2, ex3, wf4(:,15), n3(:,41), t3x4(:,:,15))
  call vert_SV_V(ntry, wf4(:,11), wf4(:,15), wf16(:,7), n3(:,42), t3x16(:,:,7))
  call vert_QA_Z(gZu,ntry, ex1, ex4, wf4(:,16), n3(:,43), t3x4(:,:,16))
  call vert_SV_V(ntry, wf4(:,14), wf4(:,16), wf16(:,8), n3(:,44), t3x16(:,:,8))
  call vert_QA_V(ntry, ex1, ex4, wf4(:,17), n3(:,45), t3x4(:,:,17))
  call vert_QA_V(ntry, ex2, ex3, wf4(:,18), n3(:,46), t3x4(:,:,18))
  call vert_VQ_A(ntry, wf4(:,17), ex5, wf8(:,31), n3(:,47), t3x8(:,:,21))
  call vert_AV_Q(ntry, ex6, wf4(:,18), wf8(:,32), n3(:,48), t3x8(:,:,22))
  call prop_Q_A(ntry, wf8(:,31), Q(:,25), ZERO, 0_intkind1, wf8(:,33), n2(11))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,15), wf8(:,34), n3(:,49), t3x8(:,:,23))
  call vert_ZQ_A(gZd,ntry, wf4(:,16), ex5, wf8(:,35), n3(:,50), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,35), Q(:,25), ZERO, 0_intkind1, wf8(:,36), n2(12))
  call vert_VQ_A(ntry, wf4(:,18), ex5, wf8(:,37), n3(:,51), t3x8(:,:,25))
  call vert_AV_Q(ntry, ex6, wf4(:,17), wf8(:,38), n3(:,52), t3x8(:,:,26))
  call prop_Q_A(ntry, wf8(:,37), Q(:,22), ZERO, 0_intkind1, wf8(:,39), n2(13))
  call vert_ZQ_A(gZd,ntry, wf4(:,15), ex5, wf8(:,40), n3(:,53), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,40), Q(:,22), ZERO, 0_intkind1, wf8(:,41), n2(14))
  call vert_AZ_Q(gZd,ntry, ex6, wf4(:,16), wf8(:,42), n3(:,54), t3x8(:,:,28))
  call vert_QS_A(gH,ntry, ex1, wf4(:,14), wf8(:,43), n3(:,55), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,43), Q(:,7), MT, 1_intkind1, wf8(:,44), n2(15))
  call vert_QS_A(gX,ntry, ex1, wf4(:,12), wf8(:,45), n3(:,56), t3x8(:,:,30))
  call prop_Q_A(ntry, wf8(:,45), Q(:,7), MT, 1_intkind1, wf8(:,46), n2(16))
  call vert_VQ_A(ntry, wf4(:,18), ex1, wf8(:,47), n3(:,57), t3x8(:,:,31))
  call prop_Q_A(ntry, wf8(:,47), Q(:,7), MT, 1_intkind1, wf8(:,48), n2(17))
  call vert_ZQ_A(gZu,ntry, wf4(:,15), ex1, wf8(:,49), n3(:,58), t3x8(:,:,32))
  call prop_Q_A(ntry, wf8(:,49), Q(:,7), MT, 1_intkind1, wf8(:,50), n2(18))
  call vert_VQ_A(ntry, wf4(:,10), ex1, wf8(:,51), n3(:,59), t3x8(:,:,33))
  call vert_SA_Q(gH,ntry, wf4(:,14), ex4, wf8(:,52), n3(:,60), t3x8(:,:,34))
  call prop_Q_A(ntry, wf8(:,51), Q(:,49), MT, 1_intkind1, wf8(:,53), n2(19))
  call vert_SA_Q(gX,ntry, wf4(:,12), ex4, wf8(:,54), n3(:,61), t3x8(:,:,35))
  call vert_ZQ_A(gZu,ntry, wf4(:,3), ex1, wf8(:,55), n3(:,62), t3x8(:,:,36))
  call prop_Q_A(ntry, wf8(:,55), Q(:,49), MT, 1_intkind1, wf8(:,56), n2(20))
  call vert_AV_Q(ntry, ex4, wf4(:,18), wf8(:,57), n3(:,63), t3x8(:,:,37))
  call vert_AZ_Q(gZu,ntry, ex4, wf4(:,15), wf8(:,58), n3(:,64), t3x8(:,:,38))
  call vert_QS_A(gH,ntry, ex2, wf4(:,11), wf8(:,59), n3(:,65), t3x8(:,:,39))
  call vert_AV_Q(ntry, ex3, wf4(:,10), wf8(:,60), n3(:,66), t3x8(:,:,40))
  call prop_Q_A(ntry, wf8(:,59), Q(:,11), MT, 1_intkind1, wf8(:,61), n2(21))
  call vert_AZ_Q(gZu,ntry, ex3, wf4(:,3), wf8(:,62), n3(:,67), t3x8(:,:,41))
  call vert_QS_A(gX,ntry, ex2, wf4(:,13), wf8(:,63), n3(:,68), t3x8(:,:,42))
  call prop_Q_A(ntry, wf8(:,63), Q(:,11), MT, 1_intkind1, wf8(:,64), n2(22))
  call vert_VQ_A(ntry, wf4(:,17), ex2, wf8(:,65), n3(:,69), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,65), Q(:,11), MT, 1_intkind1, wf8(:,66), n2(23))
  call vert_ZQ_A(gZu,ntry, wf4(:,16), ex2, wf8(:,67), n3(:,70), t3x8(:,:,44))
  call prop_Q_A(ntry, wf8(:,67), Q(:,11), MT, 1_intkind1, wf8(:,68), n2(24))
  call vert_SA_Q(gH,ntry, wf4(:,11), ex3, wf8(:,69), n3(:,71), t3x8(:,:,45))
  call vert_SA_Q(gX,ntry, wf4(:,13), ex3, wf8(:,70), n3(:,72), t3x8(:,:,46))
  call vert_AV_Q(ntry, ex3, wf4(:,17), wf8(:,71), n3(:,73), t3x8(:,:,47))
  call vert_AZ_Q(gZu,ntry, ex3, wf4(:,16), wf8(:,72), n3(:,74), t3x8(:,:,48))
  call vert_QS_A(gH,ntry, ex1, wf4(:,5), wf8(:,73), n3(:,75), t3x8(:,:,49))
  call prop_Q_A(ntry, wf8(:,73), Q(:,11), MT, 1_intkind1, wf8(:,74), n2(25))
  call vert_QS_A(gX,ntry, ex1, wf4(:,2), wf8(:,75), n3(:,76), t3x8(:,:,50))
  call prop_Q_A(ntry, wf8(:,75), Q(:,11), MT, 1_intkind1, wf8(:,76), n2(26))
  call vert_VQ_A(ntry, wf4(:,9), ex1, wf8(:,77), n3(:,77), t3x8(:,:,51))
  call prop_Q_A(ntry, wf8(:,77), Q(:,11), MT, 1_intkind1, wf8(:,78), n2(27))
  call vert_ZQ_A(gZu,ntry, wf4(:,6), ex1, wf8(:,79), n3(:,78), t3x8(:,:,52))
  call prop_Q_A(ntry, wf8(:,79), Q(:,11), MT, 1_intkind1, wf8(:,80), n2(28))
  call vert_SA_Q(gH,ntry, wf4(:,5), ex3, wf8(:,81), n3(:,79), t3x8(:,:,53))
  call vert_SA_Q(gX,ntry, wf4(:,2), ex3, wf8(:,82), n3(:,80), t3x8(:,:,54))
  call vert_AV_Q(ntry, ex3, wf4(:,9), wf8(:,83), n3(:,81), t3x8(:,:,55))
  call vert_AZ_Q(gZu,ntry, ex3, wf4(:,6), wf8(:,84), n3(:,82), t3x8(:,:,56))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEGs Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it does not vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_pptttt_ew_tttxtxddx_4
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pptttt_ew_tttxtxddx_4

  do k = 0, 23-1
    M2(k) = M2add(extcomb_perm_pptttt_ew_tttxtxddx_4(k))
  end do

  ! photon-factors
  call photon_factors(photonid_pptttt_ew_tttxtxddx_4, 0, bornphotonfactor)
  M2 = bornphotonfactor * M2
  M2munu = bornphotonfactor * M2munu

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*6-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2
  M2munu = scalebackfactor * M2munu

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf4(:,3), wf16(:,1), A(:,1), n3(:,83), t3x64(:,:,1), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf16(:,2), A(:,2), n3(:,84), t3x64(:,:,2), nhel, den(9))
    call cont_VV(nsync, wf4(:,3), wf16(:,3), A(:,3), n3(:,85), t3x64(:,:,3), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf16(:,4), A(:,4), n3(:,86), t3x64(:,:,4), nhel, den(9))
    call cont_QA(nsync, wf8(:,2), wf8(:,3), A(:,5), n3(:,87), t3x64(:,:,5), nhel, den(14))
    call cont_QA(nsync, wf8(:,3), wf8(:,4), A(:,6), n3(:,88), t3x64(:,:,6), nhel, den(15))
    call cont_QA(nsync, wf8(:,2), wf8(:,3), A(:,7), n3(:,89), t3x64(:,:,7), nhel, den(14))
    call cont_QA(nsync, wf8(:,2), wf8(:,6), A(:,8), n3(:,90), t3x64(:,:,8), nhel, den(17))
    call cont_QA(nsync, wf8(:,4), wf8(:,6), A(:,9), n3(:,91), t3x64(:,:,9), nhel, den(18))
    call cont_QA(nsync, wf8(:,2), wf8(:,6), A(:,10), n3(:,92), t3x64(:,:,10), nhel, den(17))
    call cont_QA(nsync, wf8(:,2), wf8(:,3), A(:,11), n3(:,93), t3x64(:,:,11), nhel, den(14))
    call cont_QA(nsync, wf8(:,3), wf8(:,4), A(:,12), n3(:,94), t3x64(:,:,12), nhel, den(15))
    call cont_QA(nsync, wf8(:,8), wf8(:,9), A(:,13), n3(:,95), t3x64(:,:,13), nhel, den(21))
    call cont_QA(nsync, wf8(:,8), wf8(:,11), A(:,14), n3(:,96), t3x64(:,:,14), nhel, den(23))
    call cont_QA(nsync, wf8(:,8), wf8(:,9), A(:,15), n3(:,97), t3x64(:,:,15), nhel, den(21))
    call cont_QA(nsync, wf8(:,9), wf8(:,12), A(:,16), n3(:,98), t3x64(:,:,16), nhel, den(24))
    call cont_QA(nsync, wf8(:,11), wf8(:,12), A(:,17), n3(:,99), t3x64(:,:,17), nhel, den(25))
    call cont_QA(nsync, wf8(:,9), wf8(:,12), A(:,18), n3(:,100), t3x64(:,:,18), nhel, den(24))
    call cont_QA(nsync, wf8(:,8), wf8(:,9), A(:,19), n3(:,101), t3x64(:,:,19), nhel, den(21))
    call cont_QA(nsync, wf8(:,8), wf8(:,11), A(:,20), n3(:,102), t3x64(:,:,20), nhel, den(23))
    call cont_QA(nsync, wf8(:,14), wf8(:,15), A(:,21), n3(:,103), t3x64(:,:,21), nhel, den(29))
    call cont_QA(nsync, wf8(:,15), wf8(:,16), A(:,22), n3(:,104), t3x64(:,:,22), nhel, den(30))
    call cont_QA(nsync, wf8(:,14), wf8(:,15), A(:,23), n3(:,105), t3x64(:,:,23), nhel, den(29))
    call cont_QA(nsync, wf8(:,14), wf8(:,18), A(:,24), n3(:,106), t3x64(:,:,24), nhel, den(32))
    call cont_QA(nsync, wf8(:,16), wf8(:,18), A(:,25), n3(:,107), t3x64(:,:,25), nhel, den(33))
    call cont_QA(nsync, wf8(:,14), wf8(:,18), A(:,26), n3(:,108), t3x64(:,:,26), nhel, den(32))
    call cont_QA(nsync, wf8(:,14), wf8(:,20), A(:,27), n3(:,109), t3x64(:,:,27), nhel, den(35))
    call cont_QA(nsync, wf8(:,16), wf8(:,20), A(:,28), n3(:,110), t3x64(:,:,28), nhel, den(36))
    call cont_QA(nsync, wf8(:,14), wf8(:,20), A(:,29), n3(:,111), t3x64(:,:,29), nhel, den(35))
    call cont_QA(nsync, wf8(:,14), wf8(:,22), A(:,30), n3(:,112), t3x64(:,:,30), nhel, den(32))
    call cont_QA(nsync, wf8(:,16), wf8(:,22), A(:,31), n3(:,113), t3x64(:,:,31), nhel, den(33))
    call cont_QA(nsync, wf8(:,14), wf8(:,22), A(:,32), n3(:,114), t3x64(:,:,32), nhel, den(32))
    call cont_QA(nsync, wf8(:,14), wf8(:,20), A(:,33), n3(:,115), t3x64(:,:,33), nhel, den(35))
    call cont_QA(nsync, wf8(:,16), wf8(:,20), A(:,34), n3(:,116), t3x64(:,:,34), nhel, den(36))
    call cont_QA(nsync, wf8(:,24), wf8(:,25), A(:,35), n3(:,117), t3x64(:,:,35), nhel, den(39))
    call cont_QA(nsync, wf8(:,24), wf8(:,27), A(:,36), n3(:,118), t3x64(:,:,36), nhel, den(41))
    call cont_QA(nsync, wf8(:,24), wf8(:,25), A(:,37), n3(:,119), t3x64(:,:,37), nhel, den(39))
    call cont_QA(nsync, wf8(:,25), wf8(:,28), A(:,38), n3(:,120), t3x64(:,:,38), nhel, den(42))
    call cont_QA(nsync, wf8(:,27), wf8(:,28), A(:,39), n3(:,121), t3x64(:,:,39), nhel, den(43))
    call cont_QA(nsync, wf8(:,25), wf8(:,28), A(:,40), n3(:,122), t3x64(:,:,40), nhel, den(42))
    call cont_QA(nsync, wf8(:,25), wf8(:,29), A(:,41), n3(:,123), t3x64(:,:,41), nhel, den(44))
    call cont_QA(nsync, wf8(:,27), wf8(:,29), A(:,42), n3(:,124), t3x64(:,:,42), nhel, den(45))
    call cont_QA(nsync, wf8(:,25), wf8(:,29), A(:,43), n3(:,125), t3x64(:,:,43), nhel, den(44))
    call cont_QA(nsync, wf8(:,25), wf8(:,30), A(:,44), n3(:,126), t3x64(:,:,44), nhel, den(42))
    call cont_QA(nsync, wf8(:,27), wf8(:,30), A(:,45), n3(:,127), t3x64(:,:,45), nhel, den(43))
    call cont_QA(nsync, wf8(:,25), wf8(:,30), A(:,46), n3(:,128), t3x64(:,:,46), nhel, den(42))
    call cont_QA(nsync, wf8(:,25), wf8(:,29), A(:,47), n3(:,129), t3x64(:,:,47), nhel, den(44))
    call cont_QA(nsync, wf8(:,27), wf8(:,29), A(:,48), n3(:,130), t3x64(:,:,48), nhel, den(45))
    call cont_VV(nsync, wf4(:,3), wf16(:,5), A(:,49), n3(:,131), t3x64(:,:,49), nhel, den(49))
    call cont_VV(nsync, wf4(:,3), wf16(:,6), A(:,50), n3(:,132), t3x64(:,:,50), nhel, den(53))
    call cont_VV(nsync, wf4(:,3), wf16(:,7), A(:,51), n3(:,133), t3x64(:,:,51), nhel, den(49))
    call cont_VV(nsync, wf4(:,3), wf16(:,8), A(:,52), n3(:,134), t3x64(:,:,52), nhel, den(53))
    call cont_QA(nsync, wf8(:,32), wf8(:,33), A(:,53), n3(:,135), t3x64(:,:,53), nhel, den(58))
    call cont_QA(nsync, wf8(:,33), wf8(:,34), A(:,54), n3(:,136), t3x64(:,:,54), nhel, den(59))
    call cont_QA(nsync, wf8(:,32), wf8(:,33), A(:,55), n3(:,137), t3x64(:,:,55), nhel, den(58))
    call cont_QA(nsync, wf8(:,32), wf8(:,36), A(:,56), n3(:,138), t3x64(:,:,56), nhel, den(61))
    call cont_QA(nsync, wf8(:,34), wf8(:,36), A(:,57), n3(:,139), t3x64(:,:,57), nhel, den(62))
    call cont_QA(nsync, wf8(:,32), wf8(:,36), A(:,58), n3(:,140), t3x64(:,:,58), nhel, den(61))
    call cont_QA(nsync, wf8(:,32), wf8(:,33), A(:,59), n3(:,141), t3x64(:,:,59), nhel, den(58))
    call cont_QA(nsync, wf8(:,33), wf8(:,34), A(:,60), n3(:,142), t3x64(:,:,60), nhel, den(59))
    call cont_QA(nsync, wf8(:,38), wf8(:,39), A(:,61), n3(:,143), t3x64(:,:,61), nhel, den(65))
    call cont_QA(nsync, wf8(:,38), wf8(:,41), A(:,62), n3(:,144), t3x64(:,:,62), nhel, den(67))
    call cont_QA(nsync, wf8(:,38), wf8(:,39), A(:,63), n3(:,145), t3x64(:,:,63), nhel, den(65))
    call cont_QA(nsync, wf8(:,39), wf8(:,42), A(:,64), n3(:,146), t3x64(:,:,64), nhel, den(68))
    call cont_QA(nsync, wf8(:,41), wf8(:,42), A(:,65), n3(:,147), t3x64(:,:,65), nhel, den(69))
    call cont_QA(nsync, wf8(:,39), wf8(:,42), A(:,66), n3(:,148), t3x64(:,:,66), nhel, den(68))
    call cont_QA(nsync, wf8(:,38), wf8(:,39), A(:,67), n3(:,149), t3x64(:,:,67), nhel, den(65))
    call cont_QA(nsync, wf8(:,38), wf8(:,41), A(:,68), n3(:,150), t3x64(:,:,68), nhel, den(67))
    call cont_QA(nsync, wf8(:,14), wf8(:,44), A(:,69), n3(:,151), t3x64(:,:,69), nhel, den(71))
    call cont_QA(nsync, wf8(:,16), wf8(:,44), A(:,70), n3(:,152), t3x64(:,:,70), nhel, den(72))
    call cont_QA(nsync, wf8(:,14), wf8(:,44), A(:,71), n3(:,153), t3x64(:,:,71), nhel, den(71))
    call cont_QA(nsync, wf8(:,14), wf8(:,46), A(:,72), n3(:,154), t3x64(:,:,72), nhel, den(74))
    call cont_QA(nsync, wf8(:,16), wf8(:,46), A(:,73), n3(:,155), t3x64(:,:,73), nhel, den(75))
    call cont_QA(nsync, wf8(:,14), wf8(:,46), A(:,74), n3(:,156), t3x64(:,:,74), nhel, den(74))
    call cont_QA(nsync, wf8(:,14), wf8(:,48), A(:,75), n3(:,157), t3x64(:,:,75), nhel, den(77))
    call cont_QA(nsync, wf8(:,16), wf8(:,48), A(:,76), n3(:,158), t3x64(:,:,76), nhel, den(78))
    call cont_QA(nsync, wf8(:,14), wf8(:,48), A(:,77), n3(:,159), t3x64(:,:,77), nhel, den(77))
    call cont_QA(nsync, wf8(:,14), wf8(:,50), A(:,78), n3(:,160), t3x64(:,:,78), nhel, den(74))
    call cont_QA(nsync, wf8(:,16), wf8(:,50), A(:,79), n3(:,161), t3x64(:,:,79), nhel, den(75))
    call cont_QA(nsync, wf8(:,14), wf8(:,50), A(:,80), n3(:,162), t3x64(:,:,80), nhel, den(74))
    call cont_QA(nsync, wf8(:,14), wf8(:,48), A(:,81), n3(:,163), t3x64(:,:,81), nhel, den(77))
    call cont_QA(nsync, wf8(:,16), wf8(:,48), A(:,82), n3(:,164), t3x64(:,:,82), nhel, den(78))
    call cont_QA(nsync, wf8(:,52), wf8(:,53), A(:,83), n3(:,165), t3x64(:,:,83), nhel, den(81))
    call cont_QA(nsync, wf8(:,53), wf8(:,54), A(:,84), n3(:,166), t3x64(:,:,84), nhel, den(82))
    call cont_QA(nsync, wf8(:,52), wf8(:,56), A(:,85), n3(:,167), t3x64(:,:,85), nhel, den(84))
    call cont_QA(nsync, wf8(:,54), wf8(:,56), A(:,86), n3(:,168), t3x64(:,:,86), nhel, den(85))
    call cont_QA(nsync, wf8(:,52), wf8(:,53), A(:,87), n3(:,169), t3x64(:,:,87), nhel, den(81))
    call cont_QA(nsync, wf8(:,53), wf8(:,54), A(:,88), n3(:,170), t3x64(:,:,88), nhel, den(82))
    call cont_QA(nsync, wf8(:,53), wf8(:,57), A(:,89), n3(:,171), t3x64(:,:,89), nhel, den(86))
    call cont_QA(nsync, wf8(:,53), wf8(:,58), A(:,90), n3(:,172), t3x64(:,:,90), nhel, den(82))
    call cont_QA(nsync, wf8(:,53), wf8(:,57), A(:,91), n3(:,173), t3x64(:,:,91), nhel, den(86))
    call cont_QA(nsync, wf8(:,56), wf8(:,57), A(:,92), n3(:,174), t3x64(:,:,92), nhel, den(87))
    call cont_QA(nsync, wf8(:,56), wf8(:,58), A(:,93), n3(:,175), t3x64(:,:,93), nhel, den(85))
    call cont_QA(nsync, wf8(:,56), wf8(:,57), A(:,94), n3(:,176), t3x64(:,:,94), nhel, den(87))
    call cont_QA(nsync, wf8(:,53), wf8(:,57), A(:,95), n3(:,177), t3x64(:,:,95), nhel, den(86))
    call cont_QA(nsync, wf8(:,53), wf8(:,58), A(:,96), n3(:,178), t3x64(:,:,96), nhel, den(82))
    call cont_QA(nsync, wf8(:,60), wf8(:,61), A(:,97), n3(:,179), t3x64(:,:,97), nhel, den(90))
    call cont_QA(nsync, wf8(:,61), wf8(:,62), A(:,98), n3(:,180), t3x64(:,:,98), nhel, den(91))
    call cont_QA(nsync, wf8(:,60), wf8(:,61), A(:,99), n3(:,181), t3x64(:,:,99), nhel, den(90))
    call cont_QA(nsync, wf8(:,60), wf8(:,64), A(:,100), n3(:,182), t3x64(:,:,100), nhel, den(93))
    call cont_QA(nsync, wf8(:,62), wf8(:,64), A(:,101), n3(:,183), t3x64(:,:,101), nhel, den(94))
    call cont_QA(nsync, wf8(:,60), wf8(:,64), A(:,102), n3(:,184), t3x64(:,:,102), nhel, den(93))
    call cont_QA(nsync, wf8(:,60), wf8(:,66), A(:,103), n3(:,185), t3x64(:,:,103), nhel, den(96))
    call cont_QA(nsync, wf8(:,62), wf8(:,66), A(:,104), n3(:,186), t3x64(:,:,104), nhel, den(97))
    call cont_QA(nsync, wf8(:,60), wf8(:,66), A(:,105), n3(:,187), t3x64(:,:,105), nhel, den(96))
    call cont_QA(nsync, wf8(:,60), wf8(:,68), A(:,106), n3(:,188), t3x64(:,:,106), nhel, den(93))
    call cont_QA(nsync, wf8(:,62), wf8(:,68), A(:,107), n3(:,189), t3x64(:,:,107), nhel, den(94))
    call cont_QA(nsync, wf8(:,60), wf8(:,68), A(:,108), n3(:,190), t3x64(:,:,108), nhel, den(93))
    call cont_QA(nsync, wf8(:,60), wf8(:,66), A(:,109), n3(:,191), t3x64(:,:,109), nhel, den(96))
    call cont_QA(nsync, wf8(:,62), wf8(:,66), A(:,110), n3(:,192), t3x64(:,:,110), nhel, den(97))
    call cont_QA(nsync, wf8(:,25), wf8(:,69), A(:,111), n3(:,193), t3x64(:,:,111), nhel, den(98))
    call cont_QA(nsync, wf8(:,27), wf8(:,69), A(:,112), n3(:,194), t3x64(:,:,112), nhel, den(99))
    call cont_QA(nsync, wf8(:,25), wf8(:,69), A(:,113), n3(:,195), t3x64(:,:,113), nhel, den(98))
    call cont_QA(nsync, wf8(:,25), wf8(:,70), A(:,114), n3(:,196), t3x64(:,:,114), nhel, den(100))
    call cont_QA(nsync, wf8(:,27), wf8(:,70), A(:,115), n3(:,197), t3x64(:,:,115), nhel, den(101))
    call cont_QA(nsync, wf8(:,25), wf8(:,70), A(:,116), n3(:,198), t3x64(:,:,116), nhel, den(100))
    call cont_QA(nsync, wf8(:,25), wf8(:,71), A(:,117), n3(:,199), t3x64(:,:,117), nhel, den(102))
    call cont_QA(nsync, wf8(:,27), wf8(:,71), A(:,118), n3(:,200), t3x64(:,:,118), nhel, den(103))
    call cont_QA(nsync, wf8(:,25), wf8(:,71), A(:,119), n3(:,201), t3x64(:,:,119), nhel, den(102))
    call cont_QA(nsync, wf8(:,25), wf8(:,72), A(:,120), n3(:,202), t3x64(:,:,120), nhel, den(100))
    call cont_QA(nsync, wf8(:,27), wf8(:,72), A(:,121), n3(:,203), t3x64(:,:,121), nhel, den(101))
    call cont_QA(nsync, wf8(:,25), wf8(:,72), A(:,122), n3(:,204), t3x64(:,:,122), nhel, den(100))
    call cont_QA(nsync, wf8(:,25), wf8(:,71), A(:,123), n3(:,205), t3x64(:,:,123), nhel, den(102))
    call cont_QA(nsync, wf8(:,27), wf8(:,71), A(:,124), n3(:,206), t3x64(:,:,124), nhel, den(103))
    call cont_QA(nsync, wf8(:,60), wf8(:,74), A(:,125), n3(:,207), t3x64(:,:,125), nhel, den(105))
    call cont_QA(nsync, wf8(:,62), wf8(:,74), A(:,126), n3(:,208), t3x64(:,:,126), nhel, den(106))
    call cont_QA(nsync, wf8(:,60), wf8(:,74), A(:,127), n3(:,209), t3x64(:,:,127), nhel, den(105))
    call cont_QA(nsync, wf8(:,60), wf8(:,76), A(:,128), n3(:,210), t3x64(:,:,128), nhel, den(108))
    call cont_QA(nsync, wf8(:,62), wf8(:,76), A(:,129), n3(:,211), t3x64(:,:,129), nhel, den(109))
    call cont_QA(nsync, wf8(:,60), wf8(:,76), A(:,130), n3(:,212), t3x64(:,:,130), nhel, den(108))
    call cont_QA(nsync, wf8(:,60), wf8(:,78), A(:,131), n3(:,213), t3x64(:,:,131), nhel, den(111))
    call cont_QA(nsync, wf8(:,62), wf8(:,78), A(:,132), n3(:,214), t3x64(:,:,132), nhel, den(112))
    call cont_QA(nsync, wf8(:,60), wf8(:,78), A(:,133), n3(:,215), t3x64(:,:,133), nhel, den(111))
    call cont_QA(nsync, wf8(:,60), wf8(:,80), A(:,134), n3(:,216), t3x64(:,:,134), nhel, den(108))
    call cont_QA(nsync, wf8(:,62), wf8(:,80), A(:,135), n3(:,217), t3x64(:,:,135), nhel, den(109))
    call cont_QA(nsync, wf8(:,60), wf8(:,80), A(:,136), n3(:,218), t3x64(:,:,136), nhel, den(108))
    call cont_QA(nsync, wf8(:,60), wf8(:,78), A(:,137), n3(:,219), t3x64(:,:,137), nhel, den(111))
    call cont_QA(nsync, wf8(:,62), wf8(:,78), A(:,138), n3(:,220), t3x64(:,:,138), nhel, den(112))
    call cont_QA(nsync, wf8(:,53), wf8(:,81), A(:,139), n3(:,221), t3x64(:,:,139), nhel, den(113))
    call cont_QA(nsync, wf8(:,53), wf8(:,82), A(:,140), n3(:,222), t3x64(:,:,140), nhel, den(114))
    call cont_QA(nsync, wf8(:,56), wf8(:,81), A(:,141), n3(:,223), t3x64(:,:,141), nhel, den(115))
    call cont_QA(nsync, wf8(:,56), wf8(:,82), A(:,142), n3(:,224), t3x64(:,:,142), nhel, den(116))
    call cont_QA(nsync, wf8(:,53), wf8(:,81), A(:,143), n3(:,225), t3x64(:,:,143), nhel, den(113))
    call cont_QA(nsync, wf8(:,53), wf8(:,82), A(:,144), n3(:,226), t3x64(:,:,144), nhel, den(114))
    call cont_QA(nsync, wf8(:,53), wf8(:,83), A(:,145), n3(:,227), t3x64(:,:,145), nhel, den(117))
    call cont_QA(nsync, wf8(:,53), wf8(:,84), A(:,146), n3(:,228), t3x64(:,:,146), nhel, den(114))
    call cont_QA(nsync, wf8(:,53), wf8(:,83), A(:,147), n3(:,229), t3x64(:,:,147), nhel, den(117))
    call cont_QA(nsync, wf8(:,56), wf8(:,83), A(:,148), n3(:,230), t3x64(:,:,148), nhel, den(118))
    call cont_QA(nsync, wf8(:,56), wf8(:,84), A(:,149), n3(:,231), t3x64(:,:,149), nhel, den(116))
    call cont_QA(nsync, wf8(:,56), wf8(:,83), A(:,150), n3(:,232), t3x64(:,:,150), nhel, den(118))
    call cont_QA(nsync, wf8(:,53), wf8(:,83), A(:,151), n3(:,233), t3x64(:,:,151), nhel, den(117))
    call cont_QA(nsync, wf8(:,53), wf8(:,84), A(:,152), n3(:,234), t3x64(:,:,152), nhel, den(114))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(8) ! M1helarray(8,64)
  integer :: empty(0)

  M1(1) = ((A(j,11)%j+A(j,19)%j)*f(6))/2._/**/REALKIND+((-A(j,133)%j-A(j,151)%j)*f(7))/2._/**/REALKIND+((-A(j,12)%j-A(j,20)%j &
       -A(j,136)%j-A(j,152)%j)*f(8))/2._/**/REALKIND+((A(j,127)%j-A(j,130)%j+A(j,143)%j-A(j,144)%j)*f(13))/2._/**/REALKIND
  M1(2) = ((-A(j,59)%j-A(j,67)%j)*f(6))/2._/**/REALKIND+((A(j,77)%j+A(j,95)%j)*f(7))/2._/**/REALKIND+((A(j,60)%j+A(j,68)%j &
       +A(j,80)%j+A(j,96)%j)*f(8))/2._/**/REALKIND+((-A(j,71)%j+A(j,74)%j-A(j,87)%j+A(j,88)%j)*f(13))/2._/**/REALKIND
  M1(3) = ((-A(j,55)%j-A(j,63)%j)*f(6))/2._/**/REALKIND+((A(j,105)%j+A(j,119)%j)*f(7))/2._/**/REALKIND+((A(j,58)%j+A(j,66)%j &
       +A(j,108)%j+A(j,122)%j)*f(8))/2._/**/REALKIND+((-A(j,99)%j+A(j,102)%j-A(j,113)%j+A(j,116)%j)*f(13))/2._/**/REALKIND
  M1(4) = ((A(j,7)%j+A(j,15)%j)*f(6))/2._/**/REALKIND+((-A(j,29)%j-A(j,43)%j)*f(7))/2._/**/REALKIND+((-A(j,10)%j-A(j,18)%j &
       -A(j,32)%j-A(j,46)%j)*f(8))/2._/**/REALKIND+((A(j,23)%j-A(j,26)%j+A(j,37)%j-A(j,40)%j)*f(13))/2._/**/REALKIND
  M1(5) = (A(j,53)%j+A(j,61)%j)*f(1)+(-A(j,75)%j-A(j,89)%j-A(j,103)%j-A(j,117)%j)*f(2)+(-A(j,54)%j-A(j,56)%j-A(j,62)%j-A(j,64)%j &
       -A(j,78)%j-A(j,90)%j-A(j,106)%j-A(j,120)%j)*f(3)+(A(j,76)%j+A(j,92)%j+A(j,104)%j+A(j,118)%j)*f(4)+(A(j,57)%j+A(j,65)%j &
       +A(j,79)%j+A(j,93)%j+A(j,107)%j+A(j,121)%j)*f(5)+(-A(j,49)%j-A(j,50)%j)*f(9)+(-A(j,51)%j-A(j,52)%j)*f(10)+(A(j,69)%j &
       -A(j,72)%j+A(j,83)%j-A(j,84)%j+A(j,97)%j-A(j,100)%j+A(j,111)%j-A(j,114)%j)*f(11)+(-A(j,70)%j+A(j,73)%j-A(j,85)%j+A(j,86)%j &
       -A(j,98)%j+A(j,101)%j-A(j,112)%j+A(j,115)%j)*f(12)
  M1(6) = ((A(j,55)%j+A(j,59)%j+A(j,63)%j+A(j,67)%j+A(j,81)%j+A(j,91)%j+A(j,109)%j+A(j,123)%j)*f(6))/6._/**/REALKIND+((A(j,33)%j &
       +A(j,47)%j+A(j,137)%j+A(j,147)%j)*f(6))/2._/**/REALKIND+((-A(j,77)%j-A(j,95)%j-A(j,105)%j-A(j,119)%j)*f(7))/6._/**/REALKIND &
       +((-A(j,58)%j-A(j,60)%j-A(j,66)%j-A(j,68)%j-A(j,80)%j-A(j,82)%j-A(j,94)%j-A(j,96)%j-A(j,108)%j-A(j,110)%j-A(j,122)%j &
       -A(j,124)%j)*f(8))/6._/**/REALKIND+((-A(j,34)%j-A(j,48)%j-A(j,138)%j-A(j,150)%j)*f(8))/2._/**/REALKIND+((A(j,71)%j &
       -A(j,74)%j+A(j,87)%j-A(j,88)%j+A(j,99)%j-A(j,102)%j+A(j,113)%j-A(j,116)%j)*f(13))/6._/**/REALKIND
  M1(7) = (-A(j,5)%j-A(j,13)%j)*f(1)+(A(j,27)%j+A(j,41)%j+A(j,131)%j+A(j,145)%j)*f(2)+(A(j,6)%j+A(j,8)%j+A(j,14)%j+A(j,16)%j &
       +A(j,30)%j+A(j,44)%j+A(j,134)%j+A(j,146)%j)*f(3)+(-A(j,28)%j-A(j,42)%j-A(j,132)%j-A(j,148)%j)*f(4)+(-A(j,9)%j-A(j,17)%j &
       -A(j,31)%j-A(j,45)%j-A(j,135)%j-A(j,149)%j)*f(5)+(A(j,1)%j+A(j,2)%j)*f(9)+(A(j,3)%j+A(j,4)%j)*f(10)+(-A(j,21)%j+A(j,24)%j &
       -A(j,35)%j+A(j,38)%j-A(j,125)%j+A(j,128)%j-A(j,139)%j+A(j,140)%j)*f(11)+(A(j,22)%j-A(j,25)%j+A(j,36)%j-A(j,39)%j+A(j,126)%j &
       -A(j,129)%j+A(j,141)%j-A(j,142)%j)*f(12)
  M1(8) = ((-A(j,81)%j-A(j,91)%j-A(j,109)%j-A(j,123)%j)*f(6))/2._/**/REALKIND+((-A(j,7)%j-A(j,11)%j-A(j,15)%j-A(j,19)%j-A(j,33)%j &
       -A(j,47)%j-A(j,137)%j-A(j,147)%j)*f(6))/6._/**/REALKIND+((A(j,29)%j+A(j,43)%j+A(j,133)%j+A(j,151)%j)*f(7))/6._/**/REALKIND &
       +((A(j,82)%j+A(j,94)%j+A(j,110)%j+A(j,124)%j)*f(8))/2._/**/REALKIND+((A(j,10)%j+A(j,12)%j+A(j,18)%j+A(j,20)%j+A(j,32)%j &
       +A(j,34)%j+A(j,46)%j+A(j,48)%j+A(j,136)%j+A(j,138)%j+A(j,150)%j+A(j,152)%j)*f(8))/6._/**/REALKIND+((-A(j,23)%j+A(j,26)%j &
       -A(j,37)%j+A(j,40)%j-A(j,127)%j+A(j,130)%j-A(j,143)%j+A(j,144)%j)*f(13))/6._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(8)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 8*extcomb
    do i = 1, 8
      do j = 1, 8
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(8), M2(8)
  real(REALKIND),    intent(out) :: M2colint(0:23-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 8*extcomb
    do i = 1, 8
      do j = 1, 8
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptttt_ew_tttxtxddx_4_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(8)
  complex(REALKIND), intent(in)  :: M2(8)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 8
    do j = 1, 8
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_pptttt_ew_tttxtxddx_4")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(8,64)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    23, [ (k, k = 0, 23-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_pptttt_ew_tttxtxddx_4")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,6)
  real(REALKIND),  intent(out) :: M2(6)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:23-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(6)
  do J = 1, 6
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 6,extcombs, M2munu)
  do J = 1, 6
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_pptttt_ew_tttxtxddx_4")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_pptttt_ew_tttxtxddx_4")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_pptttt_ew_tttxtxddx_4")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(0:23-1)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(0:23-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_pptttt_ew_tttxtxddx_4")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_pptttt_ew_tttxtxddx_4")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,6)
  real(c_double), intent(out) :: m2(6)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,6)
  real(DREALKIND) :: f_m2(6)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_pptttt_ew_tttxtxddx_4_/**/REALKIND
