
module ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,14), KL(12,14), Cas(6) = 0
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    integer :: k, co
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  144,   48,   48,   18,    0,   -6,   48,    0,    0,   48,   -6,    0]
  K1(  2,:) = [   48,  144,   18,   48,   -6,    0,    0,   48,   48,    0,    0,   -6]
  K1(  3,:) = [   48,   18,  144,   48,   48,    0,    0,   -6,   -6,    0,    0,   48]
  K1(  4,:) = [   18,   48,   48,  144,    0,   48,   -6,    0,    0,   -6,   48,    0]
  K1(  5,:) = [    0,   -6,   48,    0,  144,   48,   48,   18,  -18,   -6,   -6,   18]
  K1(  6,:) = [   -6,    0,    0,   48,   48,  144,   18,   48,   -6,  -18,   18,   -6]
  K1(  7,:) = [   48,    0,    0,   -6,   48,   18,  144,   48,   -6,   18,  -18,   -6]
  K1(  8,:) = [    0,   48,   -6,    0,   18,   48,   48,  144,   18,   -6,   -6,  -18]
  K1(  9,:) = [    0,   48,   -6,    0,  -18,   -6,   -6,   18,  144,   48,   48,   18]
  K1( 10,:) = [   48,    0,    0,   -6,   -6,  -18,   18,   -6,   48,  144,   18,   48]
  K1( 11,:) = [   -6,    0,    0,   48,   -6,   18,  -18,   -6,   48,   18,  144,   48]
  K1( 12,:) = [    0,   -6,   48,    0,   18,   -6,   -6,  -18,   18,   48,   48,  144]
  K1( 13,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 14,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 15,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 16,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 17,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 18,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 19,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 20,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 21,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 22,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 23,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 24,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 25,:) = [    0,   64,    1,   21,   -3,    1,   -8,   24,   24,   -8,    1,   -3]
  K1( 26,:) = [   64,    0,   21,    1,    1,   -3,   24,   -8,   -8,   24,   -3,    1]
  K1( 27,:) = [    1,   21,    0,   64,   -8,   24,   -3,    1,    1,   -3,   24,   -8]
  K1( 28,:) = [   21,    1,   64,    0,   24,   -8,    1,   -3,   -3,    1,   -8,   24]
  K1( 29,:) = [   -3,    1,   -8,   24,    0,   64,    1,   21,    0,   -8,   10,   -6]
  K1( 30,:) = [    1,   -3,   24,   -8,   64,    0,   21,    1,   -8,    0,   -6,   10]
  K1( 31,:) = [   -8,   24,   -3,    1,    1,   21,    0,   64,   10,   -6,    0,   -8]
  K1( 32,:) = [   24,   -8,    1,   -3,   21,    1,   64,    0,   -6,   10,   -8,    0]
  K1( 33,:) = [   24,   -8,    1,   -3,    0,   -8,   10,   -6,    0,   64,    1,   21]
  K1( 34,:) = [   -8,   24,   -3,    1,   -8,    0,   -6,   10,   64,    0,   21,    1]
  K1( 35,:) = [    1,   -3,   24,   -8,   10,   -6,    0,   -8,    1,   21,    0,   64]
  K1( 36,:) = [   -3,    1,   -8,   24,   -6,   10,   -8,    0,   21,    1,   64,    0]
  K1( 37,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 38,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 39,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 40,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 41,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 42,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 43,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 44,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 45,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 46,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 47,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 48,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 49,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 50,:) = [    8,    0,    6,    8,  -10,  -24,  -24,  -64,   -1,    3,    3,    8]
  K1( 51,:) = [    8,    6,    0,    8,   -1,    3,    3,    8,  -10,  -24,  -24,  -64]
  K1( 52,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1( 53,:) = [    0,  -10,   -1,    0,   -3,   -1,   -1,  -24,  -30,  -10,  -10,  -24]
  K1( 54,:) = [   -1,  -24,    3,    8,   -1,    0,  -21,  -64,  -10,    0,    6,    8]
  K1( 55,:) = [    8,  -24,    3,   -1,   -1,  -21,    0,  -64,  -10,    6,    0,    8]
  K1( 56,:) = [    0,  -64,    8,    0,  -24,  -64,  -64, -192,  -24,    8,    8,   24]
  K1( 57,:) = [    0,   -1,  -10,    0,  -30,  -10,  -10,  -24,   -3,   -1,   -1,  -24]
  K1( 58,:) = [    8,    3,  -24,   -1,  -10,    0,    6,    8,   -1,    0,  -21,  -64]
  K1( 59,:) = [   -1,    3,  -24,    8,  -10,    6,    0,    8,   -1,  -21,    0,  -64]
  K1( 60,:) = [    0,    8,  -64,    0,  -24,    8,    8,   24,  -24,  -64,  -64, -192]
  K1( 61,:) = [    0,    8,    8,    6,  -24,  -10,  -64,  -24,    3,   -1,    8,    3]
  K1( 62,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 63,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 64,:) = [    6,    8,    8,    0,    3,   -1,    8,    3,  -24,  -10,  -64,  -24]
  K1( 65,:) = [  -24,   -1,    8,    3,    0,   -1,  -64,  -21,    0,  -10,    8,    6]
  K1( 66,:) = [  -10,    0,    0,   -1,   -1,   -3,  -24,   -1,  -10,  -30,  -24,  -10]
  K1( 67,:) = [  -64,    0,    0,    8,  -64,  -24, -192,  -64,    8,  -24,   24,    8]
  K1( 68,:) = [  -24,    8,   -1,    3,  -21,   -1,  -64,    0,    6,  -10,    8,    0]
  K1( 69,:) = [    3,    8,   -1,  -24,    0,  -10,    8,    6,    0,   -1,  -64,  -21]
  K1( 70,:) = [   -1,    0,    0,  -10,  -10,  -30,  -24,  -10,   -1,   -3,  -24,   -1]
  K1( 71,:) = [    8,    0,    0,  -64,    8,  -24,   24,    8,  -64,  -24, -192,  -64]
  K1( 72,:) = [    3,   -1,    8,  -24,    6,  -10,    8,    0,  -21,   -1,  -64,    0]
  K1( 73,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 74,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 75,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 76,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 77,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 78,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 79,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 80,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 81,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 82,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 83,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 84,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 85,:) = [    0,    8,    8,    6,    3,    8,   -1,    3,  -24,  -64,  -10,  -24]
  K1( 86,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 87,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 88,:) = [    6,    8,    8,    0,  -24,  -64,  -10,  -24,    3,    8,   -1,    3]
  K1( 89,:) = [    3,   -1,    8,  -24,    0,  -64,   -1,  -21,    0,    8,  -10,    6]
  K1( 90,:) = [    8,    0,    0,  -64,  -64, -192,  -24,  -64,    8,   24,  -24,    8]
  K1( 91,:) = [   -1,    0,    0,  -10,   -1,  -24,   -3,   -1,  -10,  -24,  -30,  -10]
  K1( 92,:) = [    3,    8,   -1,  -24,  -21,  -64,   -1,    0,    6,    8,  -10,    0]
  K1( 93,:) = [  -24,    8,   -1,    3,    0,    8,  -10,    6,    0,  -64,   -1,  -21]
  K1( 94,:) = [  -64,    0,    0,    8,    8,   24,  -24,    8,  -64, -192,  -24,  -64]
  K1( 95,:) = [  -10,    0,    0,   -1,  -10,  -24,  -30,  -10,   -1,  -24,   -3,   -1]
  K1( 96,:) = [  -24,   -1,    8,    3,    6,    8,  -10,    0,  -21,  -64,   -1,    0]
  K1( 97,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 98,:) = [    8,    0,    6,    8,    8,    3,    3,   -1,  -64,  -24,  -24,  -10]
  K1( 99,:) = [    8,    6,    0,    8,  -64,  -24,  -24,  -10,    8,    3,    3,   -1]
  K1(100,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1(101,:) = [    0,    8,  -64,    0, -192,  -64,  -64,  -24,   24,    8,    8,  -24]
  K1(102,:) = [   -1,    3,  -24,    8,  -64,    0,  -21,   -1,    8,    0,    6,  -10]
  K1(103,:) = [    8,    3,  -24,   -1,  -64,  -21,    0,   -1,    8,    6,    0,  -10]
  K1(104,:) = [    0,   -1,  -10,    0,  -24,   -1,   -1,   -3,  -24,  -10,  -10,  -30]
  K1(105,:) = [    0,  -64,    8,    0,   24,    8,    8,  -24, -192,  -64,  -64,  -24]
  K1(106,:) = [    8,  -24,    3,   -1,    8,    0,    6,  -10,  -64,    0,  -21,   -1]
  K1(107,:) = [   -1,  -24,    3,    8,    8,    6,    0,  -10,  -64,  -21,    0,   -1]
  K1(108,:) = [    0,  -10,   -1,    0,  -24,  -10,  -10,  -30,  -24,   -1,   -1,   -3]
  K1(109,:) = [    0,    1,   64,   21,   24,    1,   -8,   -3,   -3,   -8,    1,   24]
  K1(110,:) = [    1,    0,   21,   64,    1,   24,   -3,   -8,   -8,   -3,   24,    1]
  K1(111,:) = [   64,   21,    0,    1,   -8,   -3,   24,    1,    1,   24,   -3,   -8]
  K1(112,:) = [   21,   64,    1,    0,   -3,   -8,    1,   24,   24,    1,   -8,   -3]
  K1(113,:) = [   24,    1,   -8,   -3,    0,    1,   64,   21,    0,   10,   -8,   -6]
  K1(114,:) = [    1,   24,   -3,   -8,    1,    0,   21,   64,   10,    0,   -6,   -8]
  K1(115,:) = [   -8,   -3,   24,    1,   64,   21,    0,    1,   -8,   -6,    0,   10]
  K1(116,:) = [   -3,   -8,    1,   24,   21,   64,    1,    0,   -6,   -8,   10,    0]
  K1(117,:) = [   -3,   -8,    1,   24,    0,   10,   -8,   -6,    0,    1,   64,   21]
  K1(118,:) = [   -8,   -3,   24,    1,   10,    0,   -6,   -8,    1,    0,   21,   64]
  K1(119,:) = [    1,   24,   -3,   -8,   -8,   -6,    0,   10,   64,   21,    0,    1]
  K1(120,:) = [   24,    1,   -8,   -3,   -6,   -8,   10,    0,   21,   64,    1,    0]
  K1(121,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1(122,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1(123,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1(124,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1(125,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1(126,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1(127,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1(128,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1(129,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1(130,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1(131,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1(132,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1(133,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(134,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(135,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(136,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(137,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(138,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(139,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(140,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(141,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(142,:) = [   72,    0,   27,    9,    9,    0,   27,   -9,  -72,    0,  -27,   -9]
  K1(143,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(144,:) = [   27,    9,   72,    0,   27,   -9,    9,    0,  -27,   -9,  -72,    0]
  K1(145,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(146,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(147,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(148,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(149,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(150,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(151,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(152,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(153,:) = [    0,   72,    9,   27,    0,    9,   -9,   27,    0,  -72,   -9,  -27]
  K1(154,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(155,:) = [    9,   27,    0,   72,   -9,   27,    0,    9,   -9,  -27,    0,  -72]
  K1(156,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(157,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(158,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(159,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(160,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(161,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(162,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(163,:) = [   72,   27,    0,    9,  -72,  -27,    0,   -9,    9,   27,    0,   -9]
  K1(164,:) = [   27,   72,    9,    0,  -27,  -72,   -9,    0,   27,    9,   -9,    0]
  K1(165,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(166,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(167,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(168,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(169,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(170,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(171,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(172,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(173,:) = [    0,    9,   72,   27,    0,   -9,  -72,  -27,    0,   -9,    9,   27]
  K1(174,:) = [    9,    0,   27,   72,   -9,    0,  -27,  -72,   -9,    0,   27,    9]
  K1(175,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(176,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(177,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(178,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(179,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(180,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(181,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(182,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(183,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(184,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(185,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(186,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(187,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(188,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(189,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(190,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(191,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(192,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(193,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(194,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(195,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(196,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(197,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(198,:) = [    9,   27,    0,   72,  -72,    0,  -27,   -9,    9,    0,   27,   -9]
  K1(199,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(200,:) = [    0,   72,    9,   27,  -27,   -9,  -72,    0,   27,   -9,    9,    0]
  K1(201,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(202,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(203,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(204,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(205,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(206,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(207,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(208,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(209,:) = [   27,    9,   72,    0,    0,  -72,   -9,  -27,    0,    9,   -9,   27]
  K1(210,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(211,:) = [   72,    0,   27,    9,   -9,  -27,    0,  -72,   -9,   27,    0,    9]
  K1(212,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(213,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(214,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(215,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(216,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(217,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(218,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(219,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(220,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(221,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(222,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(223,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(224,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(225,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(226,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(227,:) = [    9,    0,   27,   72,    9,   27,    0,   -9,  -72,  -27,    0,   -9]
  K1(228,:) = [    0,    9,   72,   27,   27,    9,   -9,    0,  -27,  -72,   -9,    0]
  K1(229,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(230,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(231,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(232,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(233,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(234,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(235,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(236,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(237,:) = [   27,   72,    9,    0,    0,   -9,    9,   27,    0,   -9,  -72,  -27]
  K1(238,:) = [   72,   27,    0,    9,   -9,    0,   27,    9,   -9,    0,  -27,  -72]
  K1(239,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(240,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(241,:) = [    0,   81,   81,   54,    0,    0,  -81,    0,    0,  -81,    0,    0]
  K1(242,:) = [   81,    0,   54,   81,    0,    0,    0,  -81,  -81,    0,    0,    0]
  K1(243,:) = [   81,   54,    0,   81,  -81,    0,    0,    0,    0,    0,    0,  -81]
  K1(244,:) = [   54,   81,   81,    0,    0,  -81,    0,    0,    0,    0,  -81,    0]
  K1(245,:) = [    0,    0,  -81,    0, -243,  -81,  -81,  -54,    0,    0,    0,  -54]
  K1(246,:) = [    0,    0,    0,  -81,  -81, -243,  -54,  -81,    0,    0,  -54,    0]
  K1(247,:) = [  -81,    0,    0,    0,  -81,  -54, -243,  -81,    0,  -54,    0,    0]
  K1(248,:) = [    0,  -81,    0,    0,  -54,  -81,  -81, -243,  -54,    0,    0,    0]
  K1(249,:) = [    0,  -81,    0,    0,    0,    0,    0,  -54, -243,  -81,  -81,  -54]
  K1(250,:) = [  -81,    0,    0,    0,    0,    0,  -54,    0,  -81, -243,  -54,  -81]
  K1(251,:) = [    0,    0,    0,  -81,    0,  -54,    0,    0,  -81,  -54, -243,  -81]
  K1(252,:) = [    0,    0,  -81,    0,  -54,    0,    0,    0,  -54,  -81,  -81, -243]
  K1(253,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(254,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(255,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(256,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(257,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(258,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(259,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(260,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(261,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(262,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(263,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(264,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(265,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(266,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(267,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(268,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(269,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(270,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(271,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(272,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(273,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(274,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(275,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(276,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  K2( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  K2( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  K2( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  K2( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  K2( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  K2( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  K2( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  K2( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  K2(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  K2(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  K2(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  K2 = (1._/**/REALKIND / 3) * K2

  KL( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  KL( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  KL( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  KL( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  KL( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  KL( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  KL( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  KL( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  KL( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  KL(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  KL(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  KL(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  KL = (1._/**/REALKIND / 3) * KL

#if -1 > 0
    co = 0
    do k = 1, 6
      co = co + k
      Cas(k) = K1(1+12*co,1)/K1(1,1)
    end do
#endif
  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND



module ol_forced_parameters_pptttt_tttxtxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_tttxtxgg_1_/**/REALKIND


! **********************************************************************
module ol_loop_storage_pptttt_tttxtxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont

#ifdef PRECISION_dp
  integer(intkind1), save :: ntryL = 1
  integer(intkind1), save :: p_switch = 0 ! switch for dp or qp. Used for memory allocation of the OL types
  ! the following are flags for memory allocation of the hol coefficients in dp or qp
  logical, save :: dp_not_alloc = .TRUE., qp_not_alloc = .TRUE.
  integer, save :: n_merge_steps  ! total number of merging steps
  integer, save :: n_merge_mism   ! number of merging mismatches
  integer, save :: merge_step = 1 ! current merging step
  integer(intkind2), save, allocatable :: merge_tables(:,:,:) ! merging tables
  integer(intkind2), save, allocatable :: merge_mism(:)       ! array of merging mismatches
  integer(intkind2), save, allocatable :: merge_hels(:)       ! array with relevant helicities for a merging step
  logical, save :: merge_tables_on = .false.
  integer(intkind2), parameter :: nheltot = 64 ! number of helicity configurations
  integer(intkind2), save :: nhel = 64 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(64) ! physical helicity states
#endif

  complex(REALKIND), save :: den(765)

  ! external wave functions ex1(h1),... for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2)

  ! wf<h>(h,n) n wave functions with h helicity configurations
  type(wfun) :: wf4(4,63), wf8(8,236), wf16(16,284), wf64(64,602)

  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(18), c(40)

  !Vector in helicity and colour space for Born-Loop interference
  type(Hpolcont),   save :: M0_col1_helarray(14,64), M0M1_hel_cc(14,64,22)
  complex(REALKIND), save :: M2ctcc(22)

end module ol_loop_storage_pptttt_tttxtxgg_1_/**/REALKIND






! **********************************************************************
module ol_loop_pptttt_tttxtxgg_1_/**/REALKIND
! **********************************************************************
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  use ol_data_types_/**/REALKIND, only: wfun, Hpolcont
  use ol_loop_storage_pptttt_tttxtxgg_1_/**/REALKIND
  implicit none

!*********************************************************************************
  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
!  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**4
    f( 2) = gQCD**4
    f( 3) = CI*countertermnorm*gQCD**6
    f( 4) = countertermnorm*gQCD**6
    f( 5) = CI*countertermnorm*ctGtt*gQCD**6
    f( 6) = countertermnorm*ctGtt*gQCD**6
    f( 7) = CI*countertermnorm*ctVVV*gQCD**6
    f( 8) = countertermnorm*ctVVV*gQCD**6
    f( 9) = CI*countertermnorm*ctVVVV*gQCD**6
    f(10) = CI*countertermnorm*gQCD**6*R2GGGG
    f(11) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(12) = CI*gQCD**6*integralnorm*SwB
    f(13) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(14) = gQCD**6*integralnorm*SwB
    f(15) = CI*gQCD**6*integralnorm*SwF
    f(16) = 2*CI*gQCD**6*integralnorm*SwF
    f(17) = gQCD**6*integralnorm*SwF
    f(18) = 2*gQCD**6*integralnorm*SwF

  c = [ 9*CI*f(11), 18*CI*f(11), 27*CI*f(11), 54*CI*f(11), CI*f(12), 3*CI*f(12), 6*CI*f(12), 8*CI*f(12), 9*CI*f(12), 10*CI*f(12) &
    , 18*CI*f(12), 21*CI*f(12), 24*CI*f(12), 27*CI*f(12), 54*CI*f(12), 9*f(13), 18*f(13), 27*f(13), 54*f(13), f(14), 3*f(14) &
    , 6*f(14), 8*f(14), 9*f(14), 10*f(14), 18*f(14), 21*f(14), 24*f(14), 27*f(14), 54*f(14), 3*CI*f(15), 9*CI*f(15), 3*CI*f(16) &
    , 9*CI*f(16), f(17), 3*f(17), 9*f(17), f(18), 3*f(18), 9*f(18) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop

subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: L
  implicit none
  ! propagators
  den(1) = 1 /((L(5,5))+L(6,5))
  den(2) = 1 /((L(5,10))+L(6,10))
  den(4) = 1 /((L(5,9))+L(6,9))
  den(5) = 1 /((L(5,6))+L(6,6))
  den(7) = 1 /((L(5,48))+L(6,48))
  den(9) = 1 /((L(5,21))+L(6,21))
  den(12) = 1 /((L(5,26))+L(6,26))
  den(15) = 1 /((L(5,18) - MT2)+L(6,18))
  den(16) = 1 /((L(5,40) - MT2)+L(6,40))
  den(19) = 1 /((L(5,13) - MT2)+L(6,13))
  den(24) = 1 /((L(5,34) - MT2)+L(6,34))
  den(25) = 1 /((L(5,24) - MT2)+L(6,24))
  den(28) = 1 /((L(5,7) - MT2)+L(6,7))
  den(34) = 1 /((L(5,42))+L(6,42))
  den(41) = 1 /((L(5,50) - MT2)+L(6,50))
  den(45) = 1 /((L(5,25))+L(6,25))
  den(48) = 1 /((L(5,22))+L(6,22))
  den(51) = 1 /((L(5,17) - MT2)+L(6,17))
  den(56) = 1 /((L(5,14) - MT2)+L(6,14))
  den(59) = 1 /((L(5,33) - MT2)+L(6,33))
  den(66) = 1 /((L(5,41))+L(6,41))
  den(74) = 1 /((L(5,49) - MT2)+L(6,49))
  den(77) = 1 /((L(5,36) - MT2)+L(6,36))
  den(84) = 1 /((L(5,20) - MT2)+L(6,20))
  den(87) = 1 /((L(5,11) - MT2)+L(6,11))
  den(93) = 1 /((L(5,38))+L(6,38))
  den(113) = 1 /((L(5,37))+L(6,37))
  den(138) = 1 /((L(5,58))+L(6,58))
  den(141) = 1 /((L(5,53))+L(6,53))
  den(154) = 1 /((L(5,54))+L(6,54))
  den(157) = 1 /((L(5,57))+L(6,57))
  den(183) = 1 /((L(5,56) - MT2)+L(6,56))
  den(193) = 1 /((L(5,52) - MT2)+L(6,52))
  den(232) = 1 /((L(5,15))+L(6,15))
  den(247) = 1 /((L(5,45) - MT2)+L(6,45))
  den(250) = 1 /((L(5,23) - MT2)+L(6,23))
  den(264) = 1 /((L(5,29) - MT2)+L(6,29))
  den(267) = 1 /((L(5,39) - MT2)+L(6,39))
  den(315) = 1 /((L(5,46) - MT2)+L(6,46))
  den(331) = 1 /((L(5,30) - MT2)+L(6,30))
  den(370) = 1 /((L(5,27) - MT2)+L(6,27))
  den(385) = 1 /((L(5,43) - MT2)+L(6,43))

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(13) = den(2)*den(12)
  den(14) = den(1)*den(13)
  den(17) = den(1)*den(15)
  den(18) = den(16)*den(17)
  den(20) = den(1)*den(19)
  den(21) = den(15)*den(20)
  den(22) = den(12)*den(15)
  den(23) = den(1)*den(22)
  den(26) = den(1)*den(24)
  den(27) = den(25)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(25)*den(29)
  den(31) = den(12)*den(25)
  den(32) = den(1)*den(31)
  den(33) = den(20)*den(24)
  den(35) = den(24)*den(34)
  den(36) = den(1)*den(35)
  den(37) = den(16)*den(29)
  den(38) = den(16)*den(34)
  den(39) = den(1)*den(38)
  den(40) = den(7)*den(29)
  den(42) = den(7)*den(41)
  den(43) = den(1)*den(42)
  den(44) = den(6)*den(7)
  den(46) = den(4)*den(45)
  den(47) = den(5)*den(46)
  den(49) = den(5)*den(48)
  den(50) = den(4)*den(49)
  den(52) = den(5)*den(51)
  den(53) = den(16)*den(52)
  den(54) = den(45)*den(51)
  den(55) = den(5)*den(54)
  den(57) = den(5)*den(56)
  den(58) = den(51)*den(57)
  den(60) = den(5)*den(59)
  den(61) = den(25)*den(60)
  den(62) = den(5)*den(28)
  den(63) = den(25)*den(62)
  den(64) = den(25)*den(45)
  den(65) = den(5)*den(64)
  den(67) = den(59)*den(66)
  den(68) = den(5)*den(67)
  den(69) = den(57)*den(59)
  den(70) = den(16)*den(62)
  den(71) = den(16)*den(66)
  den(72) = den(5)*den(71)
  den(73) = den(7)*den(62)
  den(75) = den(7)*den(74)
  den(76) = den(5)*den(75)
  den(78) = den(4)*den(15)
  den(79) = den(77)*den(78)
  den(80) = den(4)*den(19)
  den(81) = den(15)*den(80)
  den(82) = den(15)*den(48)
  den(83) = den(4)*den(82)
  den(85) = den(4)*den(24)
  den(86) = den(84)*den(85)
  den(88) = den(4)*den(87)
  den(89) = den(84)*den(88)
  den(90) = den(48)*den(84)
  den(91) = den(4)*den(90)
  den(92) = den(24)*den(80)
  den(94) = den(24)*den(93)
  den(95) = den(4)*den(94)
  den(96) = den(77)*den(88)
  den(97) = den(77)*den(93)
  den(98) = den(4)*den(97)
  den(99) = den(7)*den(88)
  den(100) = den(4)*den(42)
  den(101) = den(2)*den(51)
  den(102) = den(77)*den(101)
  den(103) = den(9)*den(51)
  den(104) = den(2)*den(103)
  den(105) = den(2)*den(56)
  den(106) = den(51)*den(105)
  den(107) = den(2)*den(59)
  den(108) = den(84)*den(107)
  den(109) = den(2)*den(87)
  den(110) = den(84)*den(109)
  den(111) = den(9)*den(84)
  den(112) = den(2)*den(111)
  den(114) = den(59)*den(113)
  den(115) = den(2)*den(114)
  den(116) = den(59)*den(105)
  den(117) = den(77)*den(109)
  den(118) = den(77)*den(113)
  den(119) = den(2)*den(118)
  den(120) = den(7)*den(109)
  den(121) = den(2)*den(75)
  den(122) = den(24)*den(103)
  den(123) = den(51)*den(94)
  den(124) = den(51)*den(97)
  den(125) = den(38)*den(51)
  den(126) = den(15)*den(114)
  den(127) = den(59)*den(82)
  den(128) = den(15)*den(118)
  den(129) = den(15)*den(71)
  den(130) = den(59)*den(90)
  den(131) = den(24)*den(111)
  den(132) = den(16)*den(111)
  den(133) = den(71)*den(84)
  den(134) = den(31)*den(59)
  den(135) = den(24)*den(64)
  den(136) = den(25)*den(118)
  den(137) = den(64)*den(77)
  den(139) = den(2)*den(138)
  den(140) = den(1)*den(139)
  den(142) = den(1)*den(141)
  den(143) = den(2)*den(142)
  den(144) = den(1)*den(113)
  den(145) = den(2)*den(144)
  den(146) = den(2)*den(34)
  den(147) = den(1)*den(146)
  den(148) = den(15)*den(144)
  den(149) = den(15)*den(41)
  den(150) = den(1)*den(149)
  den(151) = den(10)*den(24)
  den(152) = den(24)*den(41)
  den(153) = den(1)*den(152)
  den(155) = den(5)*den(154)
  den(156) = den(4)*den(155)
  den(158) = den(4)*den(157)
  den(159) = den(5)*den(158)
  den(160) = den(4)*den(66)
  den(161) = den(5)*den(160)
  den(162) = den(5)*den(93)
  den(163) = den(4)*den(162)
  den(164) = den(51)*den(74)
  den(165) = den(5)*den(164)
  den(166) = den(51)*den(162)
  den(167) = den(59)*den(74)
  den(168) = den(5)*den(167)
  den(169) = den(49)*den(59)
  den(170) = den(15)*den(160)
  den(171) = den(4)*den(149)
  den(172) = den(24)*den(46)
  den(173) = den(4)*den(152)
  den(174) = den(2)*den(164)
  den(175) = den(51)*den(146)
  den(176) = den(2)*den(167)
  den(177) = den(13)*den(59)
  den(178) = den(24)*den(54)
  den(179) = den(35)*den(51)
  den(180) = den(15)*den(67)
  den(181) = den(22)*den(59)
  den(182) = den(25)*den(144)
  den(184) = den(25)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(10)*den(16)
  den(187) = den(16)*den(183)
  den(188) = den(1)*den(187)
  den(189) = den(7)*den(20)
  den(190) = den(7)*den(183)
  den(191) = den(1)*den(190)
  den(192) = den(84)*den(160)
  den(194) = den(84)*den(193)
  den(195) = den(4)*den(194)
  den(196) = den(46)*den(77)
  den(197) = den(77)*den(193)
  den(198) = den(4)*den(197)
  den(199) = den(7)*den(80)
  den(200) = den(7)*den(193)
  den(201) = den(4)*den(200)
  den(202) = den(54)*den(77)
  den(203) = den(16)*den(103)
  den(204) = den(67)*den(84)
  den(205) = den(25)*den(114)
  den(206) = den(5)*den(184)
  den(207) = den(25)*den(162)
  den(208) = den(5)*den(187)
  den(209) = den(16)*den(49)
  den(210) = den(5)*den(190)
  den(211) = den(7)*den(57)
  den(212) = den(2)*den(194)
  den(213) = den(84)*den(146)
  den(214) = den(2)*den(197)
  den(215) = den(13)*den(77)
  den(216) = den(2)*den(200)
  den(217) = den(7)*den(105)
  den(218) = den(22)*den(77)
  den(219) = den(16)*den(82)
  den(220) = den(35)*den(84)
  den(221) = den(38)*den(84)
  den(222) = den(16)*den(90)
  den(223) = den(25)*den(94)
  den(224) = den(31)*den(77)
  den(225) = den(25)*den(97)
  den(226) = den(2)*den(7)
  den(227) = den(138)*den(226)
  den(228) = den(1)*den(227)
  den(229) = den(1)*den(7)
  den(230) = den(141)*den(229)
  den(231) = den(2)*den(230)
  den(233) = den(3)*den(232)
  den(234) = den(7)*den(233)
  den(235) = den(1)**2
  den(236) = den(146)*den(235)
  den(237) = den(13)*den(235)
  den(238) = den(2)**2
  den(239) = den(144)*den(238)
  den(240) = den(10)*den(238)
  den(241) = den(10)*den(146)
  den(242) = den(13)*den(144)
  den(243) = den(15)*den(16)
  den(244) = den(138)*den(243)
  den(245) = den(1)*den(244)
  den(246) = den(1)*den(16)
  den(248) = den(246)*den(247)
  den(249) = den(15)*den(248)
  den(251) = den(17)*den(250)
  den(252) = den(16)*den(251)
  den(253) = den(149)*den(235)
  den(254) = den(22)*den(235)
  den(255) = den(15)**2
  den(256) = den(144)*den(255)
  den(257) = den(20)*den(255)
  den(258) = den(20)*den(149)
  den(259) = den(22)*den(144)
  den(260) = den(24)*den(25)
  den(261) = den(138)*den(260)
  den(262) = den(1)*den(261)
  den(263) = den(1)*den(25)
  den(265) = den(263)*den(264)
  den(266) = den(24)*den(265)
  den(268) = den(26)*den(267)
  den(269) = den(25)*den(268)
  den(270) = den(184)*den(235)
  den(271) = den(31)*den(235)
  den(272) = den(25)**2
  den(273) = den(144)*den(272)
  den(274) = den(29)*den(184)
  den(275) = den(31)*den(144)
  den(276) = den(29)*den(272)
  den(277) = den(152)*den(235)
  den(278) = den(35)*den(235)
  den(279) = den(24)**2
  den(280) = den(10)*den(279)
  den(281) = den(20)*den(279)
  den(282) = den(20)*den(152)
  den(283) = den(10)*den(35)
  den(284) = den(187)*den(235)
  den(285) = den(38)*den(235)
  den(286) = den(16)**2
  den(287) = den(10)*den(286)
  den(288) = den(29)*den(187)
  den(289) = den(10)*den(38)
  den(290) = den(29)*den(286)
  den(291) = den(190)*den(235)
  den(292) = den(42)*den(235)
  den(293) = den(29)*den(190)
  den(294) = den(20)*den(42)
  den(295) = den(7)**2
  den(296) = den(20)*den(295)
  den(297) = den(29)*den(295)
  den(298) = den(5)*den(7)
  den(299) = den(154)*den(298)
  den(300) = den(4)*den(299)
  den(301) = den(4)*den(7)
  den(302) = den(157)*den(301)
  den(303) = den(5)*den(302)
  den(304) = den(6)*den(232)
  den(305) = den(7)*den(304)
  den(306) = den(4)**2
  den(307) = den(162)*den(306)
  den(308) = den(49)*den(306)
  den(309) = den(5)**2
  den(310) = den(160)*den(309)
  den(311) = den(46)*den(309)
  den(312) = den(46)*den(162)
  den(313) = den(49)*den(160)
  den(314) = den(5)*den(16)
  den(316) = den(314)*den(315)
  den(317) = den(51)*den(316)
  den(318) = den(16)*den(51)
  den(319) = den(157)*den(318)
  den(320) = den(5)*den(319)
  den(321) = den(52)*den(250)
  den(322) = den(16)*den(321)
  den(323) = den(51)**2
  den(324) = den(162)*den(323)
  den(325) = den(57)*den(323)
  den(326) = den(164)*den(309)
  den(327) = den(54)*den(309)
  den(328) = den(54)*den(162)
  den(329) = den(57)*den(164)
  den(330) = den(5)*den(25)
  den(332) = den(330)*den(331)
  den(333) = den(59)*den(332)
  den(334) = den(25)*den(59)
  den(335) = den(157)*den(334)
  den(336) = den(5)*den(335)
  den(337) = den(60)*den(267)
  den(338) = den(25)*den(337)
  den(339) = den(184)*den(309)
  den(340) = den(162)*den(272)
  den(341) = den(62)*den(184)
  den(342) = den(64)*den(162)
  den(343) = den(64)*den(309)
  den(344) = den(62)*den(272)
  den(345) = den(59)**2
  den(346) = den(49)*den(345)
  den(347) = den(57)*den(345)
  den(348) = den(167)*den(309)
  den(349) = den(67)*den(309)
  den(350) = den(49)*den(67)
  den(351) = den(57)*den(167)
  den(352) = den(187)*den(309)
  den(353) = den(49)*den(286)
  den(354) = den(62)*den(187)
  den(355) = den(49)*den(71)
  den(356) = den(71)*den(309)
  den(357) = den(62)*den(286)
  den(358) = den(190)*den(309)
  den(359) = den(62)*den(190)
  den(360) = den(57)*den(75)
  den(361) = den(57)*den(295)
  den(362) = den(75)*den(309)
  den(363) = den(62)*den(295)
  den(364) = den(15)*den(77)
  den(365) = den(154)*den(364)
  den(366) = den(4)*den(365)
  den(367) = den(4)*den(77)
  den(368) = den(247)*den(367)
  den(369) = den(15)*den(368)
  den(371) = den(78)*den(370)
  den(372) = den(77)*den(371)
  den(373) = den(149)*den(306)
  den(374) = den(82)*den(306)
  den(375) = den(160)*den(255)
  den(376) = den(80)*den(255)
  den(377) = den(80)*den(149)
  den(378) = den(82)*den(160)
  den(379) = den(24)*den(84)
  den(380) = den(154)*den(379)
  den(381) = den(4)*den(380)
  den(382) = den(4)*den(84)
  den(383) = den(264)*den(382)
  den(384) = den(24)*den(383)
  den(386) = den(85)*den(385)
  den(387) = den(84)*den(386)
  den(388) = den(194)*den(306)
  den(389) = den(90)*den(306)
  den(390) = den(84)**2
  den(391) = den(160)*den(390)
  den(392) = den(88)*den(194)
  den(393) = den(90)*den(160)
  den(394) = den(88)*den(390)
  den(395) = den(152)*den(306)
  den(396) = den(94)*den(306)
  den(397) = den(46)*den(279)
  den(398) = den(80)*den(279)
  den(399) = den(80)*den(152)
  den(400) = den(46)*den(94)
  den(401) = den(197)*den(306)
  den(402) = den(97)*den(306)
  den(403) = den(77)**2
  den(404) = den(46)*den(403)
  den(405) = den(88)*den(197)
  den(406) = den(46)*den(97)
  den(407) = den(88)*den(403)
  den(408) = den(200)*den(306)
  den(409) = den(42)*den(306)
  den(410) = den(88)*den(200)
  den(411) = den(42)*den(80)
  den(412) = den(80)*den(295)
  den(413) = den(88)*den(295)
  den(414) = den(2)*den(77)
  den(415) = den(315)*den(414)
  den(416) = den(51)*den(415)
  den(417) = den(51)*den(77)
  den(418) = den(141)*den(417)
  den(419) = den(2)*den(418)
  den(420) = den(101)*den(370)
  den(421) = den(77)*den(420)
  den(422) = den(146)*den(323)
  den(423) = den(105)*den(323)
  den(424) = den(164)*den(238)
  den(425) = den(103)*den(238)
  den(426) = den(103)*den(146)
  den(427) = den(105)*den(164)
  den(428) = den(2)*den(84)
  den(429) = den(331)*den(428)
  den(430) = den(59)*den(429)
  den(431) = den(59)*den(84)
  den(432) = den(141)*den(431)
  den(433) = den(2)*den(432)
  den(434) = den(107)*den(385)
  den(435) = den(84)*den(434)
  den(436) = den(194)*den(238)
  den(437) = den(146)*den(390)
  den(438) = den(109)*den(194)
  den(439) = den(111)*den(146)
  den(440) = den(111)*den(238)
  den(441) = den(109)*den(390)
  den(442) = den(13)*den(345)
  den(443) = den(105)*den(345)
  den(444) = den(167)*den(238)
  den(445) = den(114)*den(238)
  den(446) = den(13)*den(114)
  den(447) = den(105)*den(167)
  den(448) = den(197)*den(238)
  den(449) = den(13)*den(403)
  den(450) = den(109)*den(197)
  den(451) = den(13)*den(118)
  den(452) = den(118)*den(238)
  den(453) = den(109)*den(403)
  den(454) = den(200)*den(238)
  den(455) = den(109)*den(200)
  den(456) = den(75)*den(105)
  den(457) = den(105)*den(295)
  den(458) = den(75)*den(238)
  den(459) = den(109)*den(295)
  den(460) = den(35)*den(323)
  den(461) = den(94)*den(323)
  den(462) = den(54)*den(279)
  den(463) = den(103)*den(279)
  den(464) = den(35)*den(103)
  den(465) = den(54)*den(94)
  den(466) = den(97)*den(323)
  den(467) = den(54)*den(403)
  den(468) = den(54)*den(97)
  den(469) = den(38)*den(323)
  den(470) = den(38)*den(103)
  den(471) = den(103)*den(286)
  den(472) = den(22)*den(345)
  den(473) = den(82)*den(345)
  den(474) = den(67)*den(255)
  den(475) = den(114)*den(255)
  den(476) = den(22)*den(114)
  den(477) = den(67)*den(82)
  den(478) = den(22)*den(403)
  den(479) = den(22)*den(118)
  den(480) = den(118)*den(255)
  den(481) = den(71)*den(82)
  den(482) = den(82)*den(286)
  den(483) = den(71)*den(255)
  den(484) = den(90)*den(345)
  den(485) = den(67)*den(390)
  den(486) = den(67)*den(90)
  den(487) = den(35)*den(390)
  den(488) = den(35)*den(111)
  den(489) = den(111)*den(279)
  den(490) = den(38)*den(111)
  den(491) = den(71)*den(90)
  den(492) = den(38)*den(390)
  den(493) = den(90)*den(286)
  den(494) = den(71)*den(390)
  den(495) = den(111)*den(286)
  den(496) = den(31)*den(345)
  den(497) = den(31)*den(114)
  den(498) = den(114)*den(272)
  den(499) = den(64)*den(94)
  den(500) = den(94)*den(272)
  den(501) = den(64)*den(279)
  den(502) = den(31)*den(118)
  den(503) = den(64)*den(97)
  den(504) = den(31)*den(403)
  den(505) = den(97)*den(272)
  den(506) = den(64)*den(403)
  den(507) = den(118)*den(272)
  den(508) = den(29)*den(232)
  den(509) = den(29)*den(250)
  den(510) = den(29)*den(267)
  den(511) = den(20)*den(232)
  den(512) = den(20)*den(264)
  den(513) = den(20)*den(247)
  den(514) = den(10)*den(250)
  den(515) = den(10)*den(264)
  den(516) = den(10)*den(141)
  den(517) = den(144)*den(267)
  den(518) = den(144)*den(247)
  den(519) = den(141)*den(144)
  den(520) = den(62)*den(232)
  den(521) = den(62)*den(250)
  den(522) = den(62)*den(267)
  den(523) = den(57)*den(232)
  den(524) = den(49)*den(250)
  den(525) = den(162)*den(267)
  den(526) = den(57)*den(331)
  den(527) = den(57)*den(315)
  den(528) = den(49)*den(331)
  den(529) = den(49)*den(154)
  den(530) = den(162)*den(315)
  den(531) = den(154)*den(162)
  den(532) = den(88)*den(232)
  den(533) = den(88)*den(370)
  den(534) = den(88)*den(385)
  den(535) = den(80)*den(232)
  den(536) = den(80)*den(264)
  den(537) = den(80)*den(247)
  den(538) = den(46)*den(370)
  den(539) = den(46)*den(264)
  den(540) = den(46)*den(157)
  den(541) = den(160)*den(385)
  den(542) = den(160)*den(247)
  den(543) = den(157)*den(160)
  den(544) = den(109)*den(232)
  den(545) = den(109)*den(370)
  den(546) = den(109)*den(385)
  den(547) = den(105)*den(232)
  den(548) = den(13)*den(370)
  den(549) = den(146)*den(385)
  den(550) = den(105)*den(331)
  den(551) = den(105)*den(315)
  den(552) = den(13)*den(331)
  den(553) = den(13)*den(138)
  den(554) = den(146)*den(315)
  den(555) = den(138)*den(146)
  den(556) = den(103)*den(250)
  den(557) = den(103)*den(264)
  den(558) = den(103)*den(141)
  den(559) = den(54)*den(370)
  den(560) = den(54)*den(264)
  den(561) = den(54)*den(157)
  den(562) = den(141)*den(164)
  den(563) = den(157)*den(164)
  den(564) = den(82)*den(250)
  den(565) = den(22)*den(370)
  den(566) = den(82)*den(331)
  den(567) = den(82)*den(154)
  den(568) = den(22)*den(331)
  den(569) = den(22)*den(138)
  den(570) = den(149)*den(154)
  den(571) = den(138)*den(149)
  den(572) = den(111)*den(250)
  den(573) = den(90)*den(250)
  den(574) = den(111)*den(264)
  den(575) = den(111)*den(141)
  den(576) = den(141)*den(194)
  den(577) = den(90)*den(331)
  den(578) = den(90)*den(154)
  den(579) = den(154)*den(194)
  den(580) = den(64)*den(370)
  den(581) = den(31)*den(370)
  den(582) = den(64)*den(264)
  den(583) = den(64)*den(157)
  den(584) = den(157)*den(184)
  den(585) = den(31)*den(331)
  den(586) = den(31)*den(138)
  den(587) = den(138)*den(184)
  den(588) = den(114)*den(267)
  den(589) = den(114)*den(247)
  den(590) = den(114)*den(141)
  den(591) = den(67)*den(385)
  den(592) = den(67)*den(247)
  den(593) = den(67)*den(157)
  den(594) = den(141)*den(167)
  den(595) = den(157)*den(167)
  den(596) = den(94)*den(267)
  den(597) = den(35)*den(385)
  den(598) = den(94)*den(315)
  den(599) = den(94)*den(154)
  den(600) = den(35)*den(315)
  den(601) = den(35)*den(138)
  den(602) = den(152)*den(154)
  den(603) = den(138)*den(152)
  den(604) = den(118)*den(267)
  den(605) = den(97)*den(267)
  den(606) = den(118)*den(247)
  den(607) = den(118)*den(141)
  den(608) = den(141)*den(197)
  den(609) = den(97)*den(315)
  den(610) = den(97)*den(154)
  den(611) = den(154)*den(197)
  den(612) = den(71)*den(385)
  den(613) = den(38)*den(385)
  den(614) = den(71)*den(247)
  den(615) = den(71)*den(157)
  den(616) = den(157)*den(187)
  den(617) = den(38)*den(315)
  den(618) = den(38)*den(138)
  den(619) = den(138)*den(187)
  den(620) = den(75)*den(141)
  den(621) = den(141)*den(200)
  den(622) = den(75)*den(157)
  den(623) = den(157)*den(190)
  den(624) = den(42)*den(154)
  den(625) = den(154)*den(200)
  den(626) = den(42)*den(138)
  den(627) = den(138)*den(190)
  den(628) = den(1)*den(2)*den(7)
  den(629) = den(1)*den(15)*den(16)
  den(630) = den(1)*den(24)*den(25)
  den(631) = den(4)*den(5)*den(7)
  den(632) = den(5)*den(16)*den(51)
  den(633) = den(5)*den(25)*den(59)
  den(634) = den(4)*den(15)*den(77)
  den(635) = den(4)*den(24)*den(84)
  den(636) = den(2)*den(51)*den(77)
  den(637) = den(2)*den(59)*den(84)
  den(638) = den(24)*den(51)
  den(639) = den(15)*den(59)
  den(640) = den(16)*den(84)
  den(641) = den(25)*den(77)
  den(642) = den(1)*den(226)
  den(643) = den(2)*den(229)
  den(644) = den(4)*den(298)
  den(645) = den(5)*den(301)
  den(646) = den(2)*den(516)
  den(647) = den(2)*den(519)
  den(648) = den(1)*den(553)
  den(649) = den(1)*den(555)
  den(650) = den(15)*den(513)
  den(651) = den(15)*den(518)
  den(652) = den(1)*den(569)
  den(653) = den(1)*den(571)
  den(654) = den(25)*den(510)
  den(655) = den(25)*den(517)
  den(656) = den(1)*den(586)
  den(657) = den(1)*den(587)
  den(658) = den(24)*den(512)
  den(659) = den(24)*den(515)
  den(660) = den(1)*den(601)
  den(661) = den(1)*den(603)
  den(662) = den(16)*den(509)
  den(663) = den(16)*den(514)
  den(664) = den(1)*den(618)
  den(665) = den(1)*den(619)
  den(666) = den(7)*den(508)
  den(667) = den(7)*den(511)
  den(668) = den(1)*den(626)
  den(669) = den(1)*den(627)
  den(670) = den(5)*den(540)
  den(671) = den(5)*den(543)
  den(672) = den(4)*den(529)
  den(673) = den(4)*den(531)
  den(674) = den(5)*den(561)
  den(675) = den(5)*den(563)
  den(676) = den(51)*den(527)
  den(677) = den(51)*den(530)
  den(678) = den(25)*den(522)
  den(679) = den(5)*den(583)
  den(680) = den(25)*den(525)
  den(681) = den(5)*den(584)
  den(682) = den(5)*den(593)
  den(683) = den(5)*den(595)
  den(684) = den(59)*den(526)
  den(685) = den(59)*den(528)
  den(686) = den(16)*den(521)
  den(687) = den(5)*den(615)
  den(688) = den(16)*den(524)
  den(689) = den(5)*den(616)
  den(690) = den(7)*den(520)
  den(691) = den(5)*den(622)
  den(692) = den(7)*den(523)
  den(693) = den(5)*den(623)
  den(694) = den(15)*den(537)
  den(695) = den(15)*den(542)
  den(696) = den(4)*den(567)
  den(697) = den(4)*den(570)
  den(698) = den(84)*den(534)
  den(699) = den(84)*den(541)
  den(700) = den(4)*den(578)
  den(701) = den(4)*den(579)
  den(702) = den(24)*den(536)
  den(703) = den(24)*den(539)
  den(704) = den(4)*den(599)
  den(705) = den(4)*den(602)
  den(706) = den(77)*den(533)
  den(707) = den(77)*den(538)
  den(708) = den(4)*den(610)
  den(709) = den(4)*den(611)
  den(710) = den(7)*den(532)
  den(711) = den(7)*den(535)
  den(712) = den(4)*den(624)
  den(713) = den(4)*den(625)
  den(714) = den(2)*den(558)
  den(715) = den(2)*den(562)
  den(716) = den(51)*den(551)
  den(717) = den(51)*den(554)
  den(718) = den(84)*den(546)
  den(719) = den(2)*den(575)
  den(720) = den(84)*den(549)
  den(721) = den(2)*den(576)
  den(722) = den(2)*den(590)
  den(723) = den(2)*den(594)
  den(724) = den(59)*den(550)
  den(725) = den(59)*den(552)
  den(726) = den(77)*den(545)
  den(727) = den(2)*den(607)
  den(728) = den(77)*den(548)
  den(729) = den(2)*den(608)
  den(730) = den(7)*den(544)
  den(731) = den(2)*den(620)
  den(732) = den(7)*den(547)
  den(733) = den(2)*den(621)
  den(734) = den(24)*den(557)
  den(735) = den(24)*den(560)
  den(736) = den(51)*den(598)
  den(737) = den(51)*den(600)
  den(738) = den(77)*den(559)
  den(739) = den(51)*den(609)
  den(740) = den(16)*den(556)
  den(741) = den(51)*den(617)
  den(742) = den(15)*den(589)
  den(743) = den(15)*den(592)
  den(744) = den(59)*den(566)
  den(745) = den(59)*den(568)
  den(746) = den(15)*den(606)
  den(747) = den(77)*den(565)
  den(748) = den(15)*den(614)
  den(749) = den(16)*den(564)
  den(750) = den(84)*den(591)
  den(751) = den(59)*den(577)
  den(752) = den(24)*den(574)
  den(753) = den(84)*den(597)
  den(754) = den(16)*den(572)
  den(755) = den(84)*den(612)
  den(756) = den(16)*den(573)
  den(757) = den(84)*den(613)
  den(758) = den(25)*den(588)
  den(759) = den(59)*den(585)
  den(760) = den(24)*den(582)
  den(761) = den(25)*den(596)
  den(762) = den(25)*den(604)
  den(763) = den(77)*den(580)
  den(764) = den(25)*den(605)
  den(765) = den(77)*den(581)

end subroutine denominators

#ifdef PRECISION_dp
! **********************************************************************
subroutine init_merging_tables(tot_num_hels, tot_num_merge_steps)
!-----------------------------------------------------------------------
! In the first event the merging tables are fully initialised
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels, tot_num_merge_steps
  n_merge_steps = tot_num_merge_steps
  allocate(merge_tables(tot_num_hels,2,n_merge_steps))
  allocate(merge_mism(n_merge_steps+1))
  allocate(merge_hels(n_merge_steps))
  merge_tables_on = .true.
  merge_mism = 0_intkind2
  merge_tables = -1_intkind2
  merge_hels = -1_intkind2
end subroutine init_merging_tables

! **********************************************************************
subroutine update_merging_tables(tot_num_hels)
!-----------------------------------------------------------------------
! After the first evaluation the merging tables are adapted
! **********************************************************************
  implicit none
  integer, intent(in) :: tot_num_hels
  integer(intkind2), allocatable ::  merge_tables_tmp(:,:,:), merge_hels_tmp(:)

  if(merge_mism(1) == 0) then ! helicity configurations match in all merging steps
    if(allocated(merge_tables)) deallocate(merge_tables)
    if(allocated(merge_hels)) deallocate(merge_hels)
    if(allocated(merge_mism)) deallocate(merge_mism)
    allocate(merge_mism(1))
    allocate(merge_hels(1))
    allocate(merge_tables(1,1,1)) ! dummy allocation
    merge_mism = 0_intkind2
    merge_tables = -1_intkind2
    merge_hels = -1_intkind2
  else
    n_merge_mism = merge_mism(1)
    allocate(merge_tables_tmp(tot_num_hels,2,n_merge_mism))
    merge_tables_tmp(:,:,1:n_merge_mism) = merge_tables(:,:,1:n_merge_mism)
    if(allocated(merge_tables)) then
      deallocate(merge_tables)
      allocate(merge_tables(tot_num_hels,2,n_merge_mism))
    end if
    merge_tables = merge_tables_tmp
    if(allocated(merge_tables_tmp)) deallocate(merge_tables_tmp)
    allocate(merge_hels_tmp(n_merge_mism))
    merge_hels_tmp(1:n_merge_mism) = merge_hels(1:n_merge_mism)
    if(allocated(merge_hels)) then
      deallocate(merge_hels)
      allocate(merge_hels(n_merge_mism))
    end if
    merge_hels = merge_hels_tmp
    if(allocated(merge_hels_tmp)) deallocate(merge_hels_tmp)
  end if
  merge_tables_on = .true.
end subroutine update_merging_tables
#endif


!
!
!
! **********************************************************************
#ifdef PRECISION_dp
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
#else
recursive subroutine amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
  use ol_loop_storage_pptttt_tttxtxgg_1_/**/DREALKIND, only: nhel, Hel
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top top anti-top anti-top glue glue -> 0
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_kinematics_/**/REALKIND, only: init_kinematics
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_data_types_/**/REALKIND
  use ol_h_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_hel_propagators_/**/REALKIND
  use ol_hel_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_hel_vertices_/**/REALKIND
  use ol_hel_contractions_/**/REALKIND
  use ol_external_pptttt_tttxtxgg_1, only: &
    & external_perm_pptttt_tttxtxgg_1, &
    & external_perm_inv_pptttt_tttxtxgg_1, &
    & extcomb_perm_pptttt_tttxtxgg_1, &
    & average_factor_pptttt_tttxtxgg_1, &
    & photonid_pptttt_tttxtxgg_1
  use ol_ew_renormalisation_/**/REALKIND, only: photon_factors
  use ol_external_pptttt_tttxtxgg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptttt_tttxtxgg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_OLR_pptttt_tttxtxgg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  use ol_h_counterterms_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_loop_parameters_decl_/**/DREALKIND, only: IR_is_on
  use ol_init, only: set_parameter, parameters_flush
#ifdef PRECISION_dp
  use ol_kinematics_/**/QREALKIND, only: conv_mom_scatt2in_qp=>conv_mom_scatt2in, &
                                         internal_momenta_qp=>internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: L
  use ol_momenta_decl_/**/QREALKIND, only: L_qp=>L
#endif
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,6)
  real(REALKIND),  intent(out) :: M02, M2ct, M2colint(22)
  logical, intent(in) :: qp_kinematics
  integer(intkind1), save :: ntry = 0

  integer           :: shift, k, r, m, n, i
  real(REALKIND)    :: P(0:3,6)
#ifdef PRECISION_dp
  real(QREALKIND)    :: P_qp(0:3,6)
#endif
  integer           :: extmasses2(6)
  real(REALKIND)    :: M2add, M2add_ct, M2add_colint(22)
  complex(REALKIND) :: M1(12), M2(14)
  real(REALKIND)    :: P_scatt_intern(0:3,6)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  real(REALKIND)       :: bornphotonfactor
  integer(intkind1) :: nsync
  type(Hpolcont),   save :: M1helarray(12,64)
  type(Hpolcont) :: M1helarray_ct(14,64)
  integer, allocatable :: extcombs_permuted(:)
  integer              :: extcombs(22), nextcombs
  integer              :: CT_on_bak, R2_on_bak, TP_on_bak

#if 6 > 3
  integer :: ind_cc_comb(9)
#endif
  type(Hpolcont) :: A(64,602)

  !Aj are not used at the moment
  !complex(REALKIND) :: Aj(602)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  if(ntry == 0) then
    ! recursive initialization call needed for the correct helicity bokkeeping
    ntry = 1
    CT_on_bak = CT_is_on
    R2_on_bak = R2_is_on
    TP_on_bak = TP_is_on
    call set_parameter("ct_on", 1)
    call set_parameter("r2_on", 1)
    call set_parameter("tp_on", 1)
    call amp2(P_scatt, M02, M2ct, M2colint, qp_kinematics)
    call set_parameter("ct_on", CT_on_bak)
    call set_parameter("r2_on", R2_on_bak)
    call set_parameter("tp_on", TP_on_bak)
  end if


  call set_parameter("ew_renorm", 0)
  call parameters_flush()
  call ensure_mp_init()

  if (colmat_not_initialised) call colourmatrix_init()

  if (fac_status_loop1 /= parameters_status .or. fac_status_loop2 /= loop_parameters_status) then
    ! Note: if fac_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call fac_init_loop()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M02 = 0
    return
  end if

  extmasses2 = [ nMT, nMT, nMT, nMT, 0, 0 ]
  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0) and compute
  ! internal-propagator momenta in light-cone representation
  call init_kinematics(P_scatt, extmasses2, P, &
     external_perm_inv_pptttt_tttxtxgg_1, 6, qp_kinematics)

  ! denominators
  call denominators()

   if (heltables_not_init) call init_heltables()

  ! external WFs
  ! Here the external wavefunctions are initialiased
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1),1)
  call pol_wf_Q(P(:,2), rMT, H2, ex2, POLSEL(2),2)
  call pol_wf_A(P(:,3), rMT, H3, ex3, POLSEL(3),3)
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4),4)
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5),5)
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6),6)



  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1(:), ex3(:), wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2(:), ex4(:), wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_GGG_G(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,1), n4(:,1), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,1), wf16(:,2), n4(:,2), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex6(:), wf4(:,1), ex5(:), wf16(:,3), n4(:,3), t4x16(:,:,3))
  call vert_QA_V(ntry, ex1(:), ex4(:), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_QA_V(ntry, ex2(:), ex3(:), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_GGG_G(ntry, wf4(:,3), ex5(:), ex6(:), wf16(:,4), n4(:,4), t4x16(:,:,4))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,3), wf16(:,5), n4(:,5), t4x16(:,:,5))
  call vert_GGG_G(ntry, ex6(:), wf4(:,3), ex5(:), wf16(:,6), n4(:,6), t4x16(:,:,6))
  call vert_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,5), n3(:,5), t3x4(:,:,5))
  call vert_UV_W(ntry, wf4(:,1), 5, wf4(:,2), 10, wf16(:,7), n3(:,6), t3x16(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), 5, ex5(:), 16, wf8(:,1), n3(:,7), t3x8(:,:,1))
  call vert_UV_W(ntry, wf4(:,2), 10, ex6(:), 32, wf8(:,2), n3(:,8), t3x8(:,:,2))
  call vert_UV_W(ntry, wf4(:,2), 10, ex5(:), 16, wf8(:,3), n3(:,9), t3x8(:,:,3))
  call vert_UV_W(ntry, wf4(:,1), 5, ex6(:), 32, wf8(:,4), n3(:,10), t3x8(:,:,4))
  call vert_VQ_A(ntry, ex5(:), ex2(:), wf4(:,6), n3(:,11), t3x4(:,:,6))
  call vert_AV_Q(ntry, ex4(:), ex6(:), wf4(:,7), n3(:,12), t3x4(:,:,7))
  call prop_Q_A(ntry, wf4(:,6), 18, MT, 1_intkind1, wf4(:,8), n2(1))
  call prop_A_Q(ntry, wf4(:,7), 40, MT, 1_intkind1, wf4(:,9), n2(2))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,8), n3(:,13), t3x16(:,:,2))
  call vert_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,5), n3(:,14), t3x8(:,:,5))
  call vert_VQ_A(ntry, ex6(:), wf4(:,8), wf8(:,6), n3(:,15), t3x8(:,:,6))
  call prop_A_Q(ntry, wf8(:,5), 13, MT, 1_intkind1, wf8(:,7), n2(3))
  call vert_QA_V(ntry, wf4(:,8), ex4(:), wf8(:,8), n3(:,16), t3x8(:,:,7))
  call vert_VQ_A(ntry, ex6(:), ex2(:), wf4(:,10), n3(:,17), t3x4(:,:,8))
  call vert_AV_Q(ntry, ex4(:), ex5(:), wf4(:,11), n3(:,18), t3x4(:,:,9))
  call prop_Q_A(ntry, wf4(:,10), 34, MT, 1_intkind1, wf4(:,12), n2(4))
  call prop_A_Q(ntry, wf4(:,11), 24, MT, 1_intkind1, wf4(:,13), n2(5))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,12), wf16(:,9), n3(:,19), t3x16(:,:,3))
  call vert_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,9), n3(:,20), t3x8(:,:,8))
  call vert_AV_Q(ntry, wf4(:,13), ex6(:), wf8(:,10), n3(:,21), t3x8(:,:,9))
  call prop_Q_A(ntry, wf8(:,9), 7, MT, 1_intkind1, wf8(:,11), n2(6))
  call vert_QA_V(ntry, ex2(:), wf4(:,13), wf8(:,12), n3(:,22), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex5(:), wf4(:,12), wf8(:,13), n3(:,23), t3x8(:,:,11))
  call vert_QA_V(ntry, wf4(:,12), ex4(:), wf8(:,14), n3(:,24), t3x8(:,:,12))
  call vert_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,15), n3(:,25), t3x8(:,:,13))
  call vert_QA_V(ntry, ex2(:), wf4(:,9), wf8(:,16), n3(:,26), t3x8(:,:,14))
  call vert_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,17), n3(:,27), t3x8(:,:,15))
  call vert_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,18), n3(:,28), t3x8(:,:,16))
  call prop_Q_A(ntry, wf8(:,18), 50, MT, 1_intkind1, wf8(:,19), n2(7))
  call vert_UV_W(ntry, wf4(:,4), 6, wf4(:,3), 9, wf16(:,10), n3(:,29), t3x16(:,:,4))
  call vert_UV_W(ntry, wf4(:,3), 9, ex5(:), 16, wf8(:,20), n3(:,30), t3x8(:,:,17))
  call vert_UV_W(ntry, wf4(:,4), 6, ex6(:), 32, wf8(:,21), n3(:,31), t3x8(:,:,18))
  call vert_UV_W(ntry, wf4(:,4), 6, ex5(:), 16, wf8(:,22), n3(:,32), t3x8(:,:,19))
  call vert_UV_W(ntry, wf4(:,3), 9, ex6(:), 32, wf8(:,23), n3(:,33), t3x8(:,:,20))
  call vert_VQ_A(ntry, ex5(:), ex1(:), wf4(:,14), n3(:,34), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,14), 17, MT, 1_intkind1, wf4(:,15), n2(8))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,15), wf16(:,11), n3(:,35), t3x16(:,:,5))
  call vert_QA_V(ntry, wf4(:,15), ex4(:), wf8(:,24), n3(:,36), t3x8(:,:,21))
  call vert_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,25), n3(:,37), t3x8(:,:,22))
  call vert_VQ_A(ntry, ex6(:), wf4(:,15), wf8(:,26), n3(:,38), t3x8(:,:,23))
  call prop_A_Q(ntry, wf8(:,25), 14, MT, 1_intkind1, wf8(:,27), n2(9))
  call vert_VQ_A(ntry, ex6(:), ex1(:), wf4(:,16), n3(:,39), t3x4(:,:,11))
  call prop_Q_A(ntry, wf4(:,16), 33, MT, 1_intkind1, wf4(:,17), n2(10))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,17), wf16(:,12), n3(:,40), t3x16(:,:,6))
  call vert_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,28), n3(:,41), t3x8(:,:,24))
  call prop_Q_A(ntry, wf8(:,28), 7, MT, 1_intkind1, wf8(:,29), n2(11))
  call vert_QA_V(ntry, ex1(:), wf4(:,13), wf8(:,30), n3(:,42), t3x8(:,:,25))
  call vert_QA_V(ntry, wf4(:,17), ex4(:), wf8(:,31), n3(:,43), t3x8(:,:,26))
  call vert_VQ_A(ntry, ex5(:), wf4(:,17), wf8(:,32), n3(:,44), t3x8(:,:,27))
  call vert_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,33), n3(:,45), t3x8(:,:,28))
  call vert_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,34), n3(:,46), t3x8(:,:,29))
  call prop_Q_A(ntry, wf8(:,34), 49, MT, 1_intkind1, wf8(:,35), n2(12))
  call vert_AV_Q(ntry, ex3(:), ex6(:), wf4(:,18), n3(:,47), t3x4(:,:,12))
  call prop_A_Q(ntry, wf4(:,18), 36, MT, 1_intkind1, wf4(:,19), n2(13))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,8), wf16(:,13), n3(:,48), t3x16(:,:,7))
  call vert_AV_Q(ntry, ex3(:), wf4(:,3), wf8(:,36), n3(:,49), t3x8(:,:,30))
  call prop_A_Q(ntry, wf8(:,36), 13, MT, 1_intkind1, wf8(:,37), n2(14))
  call vert_QA_V(ntry, wf4(:,8), ex3(:), wf8(:,38), n3(:,50), t3x8(:,:,31))
  call vert_AV_Q(ntry, ex3(:), ex5(:), wf4(:,20), n3(:,51), t3x4(:,:,13))
  call prop_A_Q(ntry, wf4(:,20), 20, MT, 1_intkind1, wf4(:,21), n2(15))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,12), wf16(:,14), n3(:,52), t3x16(:,:,8))
  call vert_VQ_A(ntry, wf4(:,3), ex2(:), wf8(:,39), n3(:,53), t3x8(:,:,32))
  call vert_AV_Q(ntry, wf4(:,21), ex6(:), wf8(:,40), n3(:,54), t3x8(:,:,33))
  call prop_Q_A(ntry, wf8(:,39), 11, MT, 1_intkind1, wf8(:,41), n2(16))
  call vert_QA_V(ntry, ex2(:), wf4(:,21), wf8(:,42), n3(:,55), t3x8(:,:,34))
  call vert_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,43), n3(:,56), t3x8(:,:,35))
  call vert_AV_Q(ntry, wf4(:,19), ex5(:), wf8(:,44), n3(:,57), t3x8(:,:,36))
  call vert_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,45), n3(:,58), t3x8(:,:,37))
  call vert_AV_Q(ntry, ex3(:), wf4(:,5), wf8(:,46), n3(:,59), t3x8(:,:,38))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,15), wf16(:,15), n3(:,60), t3x16(:,:,9))
  call vert_QA_V(ntry, wf4(:,15), ex3(:), wf8(:,47), n3(:,61), t3x8(:,:,39))
  call vert_AV_Q(ntry, ex3(:), wf4(:,2), wf8(:,48), n3(:,62), t3x8(:,:,40))
  call prop_A_Q(ntry, wf8(:,48), 14, MT, 1_intkind1, wf8(:,49), n2(17))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,17), wf16(:,16), n3(:,63), t3x16(:,:,10))
  call vert_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,50), n3(:,64), t3x8(:,:,41))
  call prop_Q_A(ntry, wf8(:,50), 11, MT, 1_intkind1, wf8(:,51), n2(18))
  call vert_QA_V(ntry, ex1(:), wf4(:,21), wf8(:,52), n3(:,65), t3x8(:,:,42))
  call vert_QA_V(ntry, wf4(:,17), ex3(:), wf8(:,53), n3(:,66), t3x8(:,:,43))
  call vert_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,54), n3(:,67), t3x8(:,:,44))
  call counter_GGG_G(ntry, wf4(:,1), ex5(:), ex6(:), wf16(:,17), n4(:,7), t4x16(:,:,7))
  call counter_GGG_G(ntry, ex5(:), ex6(:), wf4(:,1), wf16(:,18), n4(:,8), t4x16(:,:,8))
  call counter_GGG_G(ntry, ex6(:), wf4(:,1), ex5(:), wf16(:,19), n4(:,9), t4x16(:,:,9))
  call counter_GGG_G(ntry, wf4(:,3), ex5(:), ex6(:), wf16(:,20), n4(:,10), t4x16(:,:,10))
  call counter_GGG_G(ntry, ex5(:), ex6(:), wf4(:,3), wf16(:,21), n4(:,11), t4x16(:,:,11))
  call counter_GGG_G(ntry, ex6(:), wf4(:,3), ex5(:), wf16(:,22), n4(:,12), t4x16(:,:,12))
  call counter_QA_V(ntry, ex2(:), ex4(:), wf4(:,22), n3(:,68), t3x4(:,:,14))
  call counter_QA_V(ntry, ex2(:), ex3(:), wf4(:,23), n3(:,69), t3x4(:,:,15))
  call counter_QA_V(ntry, ex1(:), ex4(:), wf4(:,24), n3(:,70), t3x4(:,:,16))
  call vert_GGG_G(ntry, wf4(:,24), ex5(:), ex6(:), wf16(:,23), n4(:,13), t4x16(:,:,13))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,24), wf16(:,24), n4(:,14), t4x16(:,:,14))
  call vert_GGG_G(ntry, ex6(:), wf4(:,24), ex5(:), wf16(:,25), n4(:,15), t4x16(:,:,15))
  call counter_QA_V(ntry, ex1(:), ex3(:), wf4(:,25), n3(:,71), t3x4(:,:,17))
  call vert_GGG_G(ntry, wf4(:,25), ex5(:), ex6(:), wf16(:,26), n4(:,16), t4x16(:,:,16))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,25), wf16(:,27), n4(:,17), t4x16(:,:,17))
  call vert_GGG_G(ntry, ex6(:), wf4(:,25), ex5(:), wf16(:,28), n4(:,18), t4x16(:,:,18))
  call counter_UV_W(ntry, wf4(:,1), 5, wf4(:,2), 10, wf16(:,29), n3(:,72), t3x16(:,:,11))
  call counter_UV_W(ntry, wf4(:,2), 10, ex6(:), 32, wf8(:,55), n3(:,73), t3x8(:,:,45))
  call counter_UV_W(ntry, wf4(:,1), 5, ex6(:), 32, wf8(:,56), n3(:,74), t3x8(:,:,46))
  call vert_GGG_G(ntry, wf4(:,2), ex5(:), ex6(:), wf16(:,30), n4(:,19), t4x16(:,:,19))
  call counter_V_V(ctGG,21,ntry, wf4(:,1), 5, wf4(:,26), n2(19))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,2), wf16(:,31), n4(:,20), t4x16(:,:,20))
  call vert_GGG_G(ntry, ex6(:), wf4(:,2), ex5(:), wf16(:,32), n4(:,21), t4x16(:,:,21))
  call counter_V_V(ctGG,21,ntry, wf4(:,2), 10, wf4(:,27), n2(20))
  call counter_UV_W(ntry, wf4(:,2), 10, ex5(:), 16, wf8(:,57), n3(:,75), t3x8(:,:,47))
  call counter_UV_W(ntry, wf4(:,1), 5, ex5(:), 16, wf8(:,58), n3(:,76), t3x8(:,:,48))
  call counter_UV_W(ntry, ex5(:), 16, ex6(:), 32, wf4(:,28), n3(:,77), t3x4(:,:,18))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,8), wf16(:,33), n3(:,78), t3x16(:,:,12))
  call counter_VQ_A(ntry, ex6(:), wf4(:,8), wf8(:,59), n3(:,79), t3x8(:,:,49))
  call counter_VQ_A(ntry, wf4(:,1), wf4(:,12), wf16(:,34), n3(:,80), t3x16(:,:,13))
  call counter_AV_Q(ntry, wf4(:,13), ex6(:), wf8(:,60), n3(:,81), t3x8(:,:,50))
  call counter_VQ_A(ntry, ex5(:), wf4(:,12), wf8(:,61), n3(:,82), t3x8(:,:,51))
  call counter_AV_Q(ntry, wf4(:,9), ex5(:), wf8(:,62), n3(:,83), t3x8(:,:,52))
  call vert_AV_Q(ntry, ex4(:), wf4(:,28), wf8(:,63), n3(:,84), t3x8(:,:,53))
  call vert_VQ_A(ntry, wf4(:,28), ex2(:), wf8(:,64), n3(:,85), t3x8(:,:,54))
  call prop_Q_A(ntry, wf8(:,64), 50, MT, 1_intkind1, wf8(:,65), n2(21))
  call counter_QA_V(ntry, wf4(:,8), ex4(:), wf8(:,66), n3(:,86), t3x8(:,:,55))
  call counter_AV_Q(ntry, ex4(:), wf4(:,1), wf8(:,67), n3(:,87), t3x8(:,:,56))
  call prop_Q_A(ntry, wf8(:,6), 50, MT, 1_intkind1, wf8(:,68), n2(22))
  call counter_AV_Q(ntry, ex4(:), ex6(:), wf4(:,29), n3(:,88), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,29), 40, MT, 1_intkind1, wf4(:,30), n2(23))
  call counter_QA_V(ntry, wf4(:,12), ex4(:), wf8(:,69), n3(:,89), t3x8(:,:,57))
  call prop_Q_A(ntry, wf8(:,13), 50, MT, 1_intkind1, wf8(:,70), n2(24))
  call counter_AV_Q(ntry, ex4(:), wf4(:,5), wf8(:,71), n3(:,90), t3x8(:,:,58))
  call vert_AV_Q(ntry, wf4(:,30), ex5(:), wf8(:,72), n3(:,91), t3x8(:,:,59))
  call vert_QA_V(ntry, ex2(:), wf4(:,30), wf8(:,73), n3(:,92), t3x8(:,:,60))
  call counter_AV_Q(ntry, ex4(:), ex5(:), wf4(:,31), n3(:,93), t3x4(:,:,20))
  call prop_A_Q(ntry, wf4(:,31), 24, MT, 1_intkind1, wf4(:,32), n2(25))
  call vert_AV_Q(ntry, wf4(:,32), ex6(:), wf8(:,74), n3(:,94), t3x8(:,:,61))
  call vert_QA_V(ntry, ex2(:), wf4(:,32), wf8(:,75), n3(:,95), t3x8(:,:,62))
  call counter_UV_W(ntry, wf4(:,4), 6, wf4(:,3), 9, wf16(:,35), n3(:,96), t3x16(:,:,14))
  call counter_UV_W(ntry, wf4(:,4), 6, ex6(:), 32, wf8(:,76), n3(:,97), t3x8(:,:,63))
  call counter_UV_W(ntry, wf4(:,3), 9, ex6(:), 32, wf8(:,77), n3(:,98), t3x8(:,:,64))
  call vert_GGG_G(ntry, wf4(:,4), ex5(:), ex6(:), wf16(:,36), n4(:,22), t4x16(:,:,22))
  call counter_V_V(ctGG,21,ntry, wf4(:,3), 9, wf4(:,33), n2(26))
  call vert_GGG_G(ntry, ex5(:), ex6(:), wf4(:,4), wf16(:,37), n4(:,23), t4x16(:,:,23))
  call vert_GGG_G(ntry, ex6(:), wf4(:,4), ex5(:), wf16(:,38), n4(:,24), t4x16(:,:,24))
  call counter_V_V(ctGG,21,ntry, wf4(:,4), 6, wf4(:,34), n2(27))
  call counter_UV_W(ntry, wf4(:,4), 6, ex5(:), 16, wf8(:,78), n3(:,99), t3x8(:,:,65))
  call counter_UV_W(ntry, wf4(:,3), 9, ex5(:), 16, wf8(:,79), n3(:,100), t3x8(:,:,66))
  call counter_VQ_A(ntry, wf4(:,4), wf4(:,15), wf16(:,39), n3(:,101), t3x16(:,:,15))
  call counter_VQ_A(ntry, ex6(:), wf4(:,15), wf8(:,80), n3(:,102), t3x8(:,:,67))
  call counter_VQ_A(ntry, wf4(:,4), wf4(:,17), wf16(:,40), n3(:,103), t3x16(:,:,16))
  call counter_VQ_A(ntry, ex5(:), wf4(:,17), wf8(:,81), n3(:,104), t3x8(:,:,68))
  call vert_VQ_A(ntry, wf4(:,28), ex1(:), wf8(:,82), n3(:,105), t3x8(:,:,69))
  call prop_Q_A(ntry, wf8(:,82), 49, MT, 1_intkind1, wf8(:,83), n2(28))
  call counter_AV_Q(ntry, ex4(:), wf4(:,4), wf8(:,84), n3(:,106), t3x8(:,:,70))
  call prop_Q_A(ntry, wf8(:,26), 49, MT, 1_intkind1, wf8(:,85), n2(29))
  call counter_QA_V(ntry, wf4(:,15), ex4(:), wf8(:,86), n3(:,107), t3x8(:,:,71))
  call prop_Q_A(ntry, wf8(:,32), 49, MT, 1_intkind1, wf8(:,87), n2(30))
  call counter_QA_V(ntry, wf4(:,17), ex4(:), wf8(:,88), n3(:,108), t3x8(:,:,72))
  call vert_QA_V(ntry, ex1(:), wf4(:,30), wf8(:,89), n3(:,109), t3x8(:,:,73))
  call vert_QA_V(ntry, ex1(:), wf4(:,32), wf8(:,90), n3(:,110), t3x8(:,:,74))
  call counter_VQ_A(ntry, wf4(:,3), wf4(:,8), wf16(:,41), n3(:,111), t3x16(:,:,17))
  call counter_VQ_A(ntry, wf4(:,3), wf4(:,12), wf16(:,42), n3(:,112), t3x16(:,:,18))
  call counter_AV_Q(ntry, wf4(:,21), ex6(:), wf8(:,91), n3(:,113), t3x8(:,:,75))
  call counter_AV_Q(ntry, wf4(:,19), ex5(:), wf8(:,92), n3(:,114), t3x8(:,:,76))
  call vert_AV_Q(ntry, ex3(:), wf4(:,28), wf8(:,93), n3(:,115), t3x8(:,:,77))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,15), wf16(:,43), n3(:,116), t3x16(:,:,19))
  call counter_VQ_A(ntry, wf4(:,2), wf4(:,17), wf16(:,44), n3(:,117), t3x16(:,:,20))
  call counter_QA_V(ntry, wf4(:,8), ex3(:), wf8(:,94), n3(:,118), t3x8(:,:,78))
  call counter_AV_Q(ntry, ex3(:), wf4(:,3), wf8(:,95), n3(:,119), t3x8(:,:,79))
  call counter_AV_Q(ntry, ex3(:), ex6(:), wf4(:,35), n3(:,120), t3x4(:,:,21))
  call prop_A_Q(ntry, wf4(:,35), 36, MT, 1_intkind1, wf4(:,36), n2(31))
  call counter_QA_V(ntry, wf4(:,12), ex3(:), wf8(:,96), n3(:,121), t3x8(:,:,80))
  call counter_AV_Q(ntry, ex3(:), wf4(:,5), wf8(:,97), n3(:,122), t3x8(:,:,81))
  call vert_AV_Q(ntry, wf4(:,36), ex5(:), wf8(:,98), n3(:,123), t3x8(:,:,82))
  call vert_QA_V(ntry, ex2(:), wf4(:,36), wf8(:,99), n3(:,124), t3x8(:,:,83))
  call counter_AV_Q(ntry, ex3(:), ex5(:), wf4(:,37), n3(:,125), t3x4(:,:,22))
  call prop_A_Q(ntry, wf4(:,37), 20, MT, 1_intkind1, wf4(:,38), n2(32))
  call vert_AV_Q(ntry, wf4(:,38), ex6(:), wf8(:,100), n3(:,126), t3x8(:,:,84))
  call vert_QA_V(ntry, ex2(:), wf4(:,38), wf8(:,101), n3(:,127), t3x8(:,:,85))
  call counter_AV_Q(ntry, ex3(:), wf4(:,2), wf8(:,102), n3(:,128), t3x8(:,:,86))
  call counter_QA_V(ntry, wf4(:,15), ex3(:), wf8(:,103), n3(:,129), t3x8(:,:,87))
  call counter_QA_V(ntry, wf4(:,17), ex3(:), wf8(:,104), n3(:,130), t3x8(:,:,88))
  call vert_QA_V(ntry, ex1(:), wf4(:,36), wf8(:,105), n3(:,131), t3x8(:,:,89))
  call vert_QA_V(ntry, ex1(:), wf4(:,38), wf8(:,106), n3(:,132), t3x8(:,:,90))
  call counter_QA_V(ntry, ex2(:), wf4(:,13), wf8(:,107), n3(:,133), t3x8(:,:,91))
  call counter_VQ_A(ntry, wf4(:,1), ex2(:), wf8(:,108), n3(:,134), t3x8(:,:,92))
  call prop_A_Q(ntry, wf8(:,10), 56, MT, 1_intkind1, wf8(:,109), n2(33))
  call counter_VQ_A(ntry, ex6(:), ex2(:), wf4(:,39), n3(:,135), t3x4(:,:,23))
  call prop_Q_A(ntry, wf4(:,39), 34, MT, 1_intkind1, wf4(:,40), n2(34))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,40), wf16(:,45), n3(:,136), t3x16(:,:,21))
  call counter_QA_V(ntry, ex2(:), wf4(:,9), wf8(:,110), n3(:,137), t3x8(:,:,93))
  call prop_A_Q(ntry, wf8(:,15), 56, MT, 1_intkind1, wf8(:,111), n2(35))
  call counter_VQ_A(ntry, wf4(:,5), ex2(:), wf8(:,112), n3(:,138), t3x8(:,:,94))
  call prop_A_Q(ntry, wf8(:,17), 56, MT, 1_intkind1, wf8(:,113), n2(36))
  call vert_VQ_A(ntry, ex5(:), wf4(:,40), wf8(:,114), n3(:,139), t3x8(:,:,95))
  call vert_QA_V(ntry, wf4(:,40), ex4(:), wf8(:,115), n3(:,140), t3x8(:,:,96))
  call counter_VQ_A(ntry, ex5(:), ex2(:), wf4(:,41), n3(:,141), t3x4(:,:,24))
  call prop_Q_A(ntry, wf4(:,41), 18, MT, 1_intkind1, wf4(:,42), n2(37))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,42), wf16(:,46), n3(:,142), t3x16(:,:,22))
  call vert_VQ_A(ntry, ex6(:), wf4(:,42), wf8(:,116), n3(:,143), t3x8(:,:,97))
  call vert_QA_V(ntry, wf4(:,42), ex4(:), wf8(:,117), n3(:,144), t3x8(:,:,98))
  call vert_UV_W(ntry, wf4(:,1), 5, wf4(:,22), 10, wf16(:,47), n3(:,145), t3x16(:,:,23))
  call vert_UV_W(ntry, wf4(:,22), 10, ex6(:), 32, wf8(:,118), n3(:,146), t3x8(:,:,99))
  call vert_UV_W(ntry, wf4(:,22), 10, ex5(:), 16, wf8(:,119), n3(:,147), t3x8(:,:,100))
  call counter_QA_V(ntry, ex2(:), wf4(:,21), wf8(:,120), n3(:,148), t3x8(:,:,101))
  call counter_VQ_A(ntry, wf4(:,3), ex2(:), wf8(:,121), n3(:,149), t3x8(:,:,102))
  call prop_A_Q(ntry, wf8(:,40), 52, MT, 1_intkind1, wf8(:,122), n2(38))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,40), wf16(:,48), n3(:,150), t3x16(:,:,24))
  call counter_QA_V(ntry, ex2(:), wf4(:,19), wf8(:,123), n3(:,151), t3x8(:,:,103))
  call prop_A_Q(ntry, wf8(:,44), 52, MT, 1_intkind1, wf8(:,124), n2(39))
  call prop_A_Q(ntry, wf8(:,46), 52, MT, 1_intkind1, wf8(:,125), n2(40))
  call vert_QA_V(ntry, wf4(:,40), ex3(:), wf8(:,126), n3(:,152), t3x8(:,:,104))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,42), wf16(:,49), n3(:,153), t3x16(:,:,25))
  call vert_QA_V(ntry, wf4(:,42), ex3(:), wf8(:,127), n3(:,154), t3x8(:,:,105))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,15), wf16(:,50), n3(:,155), t3x16(:,:,26))
  call vert_AV_Q(ntry, ex3(:), wf4(:,22), wf8(:,128), n3(:,156), t3x8(:,:,106))
  call prop_A_Q(ntry, wf8(:,128), 14, MT, 1_intkind1, wf8(:,129), n2(41))
  call vert_VQ_A(ntry, wf4(:,22), wf4(:,17), wf16(:,51), n3(:,157), t3x16(:,:,27))
  call vert_VQ_A(ntry, wf4(:,22), ex1(:), wf8(:,130), n3(:,158), t3x8(:,:,107))
  call prop_Q_A(ntry, wf8(:,130), 11, MT, 1_intkind1, wf8(:,131), n2(42))
  call vert_UV_W(ntry, wf4(:,23), 6, wf4(:,3), 9, wf16(:,52), n3(:,159), t3x16(:,:,28))
  call vert_UV_W(ntry, wf4(:,23), 6, ex6(:), 32, wf8(:,132), n3(:,160), t3x8(:,:,108))
  call vert_UV_W(ntry, wf4(:,23), 6, ex5(:), 16, wf8(:,133), n3(:,161), t3x8(:,:,109))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,15), wf16(:,53), n3(:,162), t3x16(:,:,29))
  call vert_AV_Q(ntry, ex4(:), wf4(:,23), wf8(:,134), n3(:,163), t3x8(:,:,110))
  call prop_A_Q(ntry, wf8(:,134), 14, MT, 1_intkind1, wf8(:,135), n2(43))
  call vert_VQ_A(ntry, wf4(:,23), wf4(:,17), wf16(:,54), n3(:,164), t3x16(:,:,30))
  call vert_VQ_A(ntry, wf4(:,23), ex1(:), wf8(:,136), n3(:,165), t3x8(:,:,111))
  call prop_Q_A(ntry, wf8(:,136), 7, MT, 1_intkind1, wf8(:,137), n2(44))
  call counter_VQ_A(ntry, wf4(:,4), ex1(:), wf8(:,138), n3(:,166), t3x8(:,:,112))
  call counter_QA_V(ntry, ex1(:), wf4(:,13), wf8(:,139), n3(:,167), t3x8(:,:,113))
  call counter_VQ_A(ntry, ex6(:), ex1(:), wf4(:,43), n3(:,168), t3x4(:,:,25))
  call prop_Q_A(ntry, wf4(:,43), 33, MT, 1_intkind1, wf4(:,44), n2(45))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,44), wf16(:,55), n3(:,169), t3x16(:,:,31))
  call counter_QA_V(ntry, ex1(:), wf4(:,9), wf8(:,140), n3(:,170), t3x8(:,:,114))
  call counter_VQ_A(ntry, wf4(:,5), ex1(:), wf8(:,141), n3(:,171), t3x8(:,:,115))
  call vert_QA_V(ntry, wf4(:,44), ex4(:), wf8(:,142), n3(:,172), t3x8(:,:,116))
  call vert_VQ_A(ntry, ex5(:), wf4(:,44), wf8(:,143), n3(:,173), t3x8(:,:,117))
  call counter_VQ_A(ntry, ex5(:), ex1(:), wf4(:,45), n3(:,174), t3x4(:,:,26))
  call prop_Q_A(ntry, wf4(:,45), 17, MT, 1_intkind1, wf4(:,46), n2(46))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,46), wf16(:,56), n3(:,175), t3x16(:,:,32))
  call vert_QA_V(ntry, wf4(:,46), ex4(:), wf8(:,144), n3(:,176), t3x8(:,:,118))
  call vert_VQ_A(ntry, ex6(:), wf4(:,46), wf8(:,145), n3(:,177), t3x8(:,:,119))
  call vert_UV_W(ntry, wf4(:,4), 6, wf4(:,24), 9, wf16(:,57), n3(:,178), t3x16(:,:,33))
  call vert_UV_W(ntry, wf4(:,24), 9, ex5(:), 16, wf8(:,146), n3(:,179), t3x8(:,:,120))
  call vert_UV_W(ntry, wf4(:,24), 9, ex6(:), 32, wf8(:,147), n3(:,180), t3x8(:,:,121))
  call counter_VQ_A(ntry, wf4(:,2), ex1(:), wf8(:,148), n3(:,181), t3x8(:,:,122))
  call counter_QA_V(ntry, ex1(:), wf4(:,21), wf8(:,149), n3(:,182), t3x8(:,:,123))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,44), wf16(:,58), n3(:,183), t3x16(:,:,34))
  call counter_QA_V(ntry, ex1(:), wf4(:,19), wf8(:,150), n3(:,184), t3x8(:,:,124))
  call vert_QA_V(ntry, wf4(:,44), ex3(:), wf8(:,151), n3(:,185), t3x8(:,:,125))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,46), wf16(:,59), n3(:,186), t3x16(:,:,35))
  call vert_QA_V(ntry, wf4(:,46), ex3(:), wf8(:,152), n3(:,187), t3x8(:,:,126))
  call vert_VQ_A(ntry, wf4(:,24), wf4(:,8), wf16(:,60), n3(:,188), t3x16(:,:,36))
  call vert_AV_Q(ntry, ex3(:), wf4(:,24), wf8(:,153), n3(:,189), t3x8(:,:,127))
  call prop_A_Q(ntry, wf8(:,153), 13, MT, 1_intkind1, wf8(:,154), n2(47))
  call vert_VQ_A(ntry, wf4(:,24), wf4(:,12), wf16(:,61), n3(:,190), t3x16(:,:,37))
  call vert_VQ_A(ntry, wf4(:,24), ex2(:), wf8(:,155), n3(:,191), t3x8(:,:,128))
  call prop_Q_A(ntry, wf8(:,155), 11, MT, 1_intkind1, wf8(:,156), n2(48))
  call vert_UV_W(ntry, wf4(:,25), 5, wf4(:,2), 10, wf16(:,62), n3(:,192), t3x16(:,:,38))
  call vert_UV_W(ntry, wf4(:,25), 5, ex5(:), 16, wf8(:,157), n3(:,193), t3x8(:,:,129))
  call vert_UV_W(ntry, wf4(:,25), 5, ex6(:), 32, wf8(:,158), n3(:,194), t3x8(:,:,130))
  call vert_VQ_A(ntry, wf4(:,25), wf4(:,8), wf16(:,63), n3(:,195), t3x16(:,:,39))
  call vert_AV_Q(ntry, ex4(:), wf4(:,25), wf8(:,159), n3(:,196), t3x8(:,:,131))
  call prop_A_Q(ntry, wf8(:,159), 13, MT, 1_intkind1, wf8(:,160), n2(49))
  call vert_VQ_A(ntry, wf4(:,25), wf4(:,12), wf16(:,64), n3(:,197), t3x16(:,:,40))
  call vert_VQ_A(ntry, wf4(:,25), ex2(:), wf8(:,161), n3(:,198), t3x8(:,:,132))
  call prop_Q_A(ntry, wf8(:,161), 7, MT, 1_intkind1, wf8(:,162), n2(50))
  call vert_UV_W(ntry, wf4(:,2), 10, wf4(:,5), 48, wf16(:,65), n3(:,199), t3x16(:,:,41))
  call vert_UV_W(ntry, wf4(:,1), 5, wf4(:,5), 48, wf16(:,66), n3(:,200), t3x16(:,:,42))
  call counter_V_V(ctGG,21,ntry, wf4(:,5), 48, wf4(:,47), n2(51))
  call vert_UV_W(ntry, wf4(:,26), 5, ex5(:), 16, wf8(:,163), n3(:,201), t3x8(:,:,133))
  call vert_UV_W(ntry, wf4(:,26), 5, ex6(:), 32, wf8(:,164), n3(:,202), t3x8(:,:,134))
  call vert_UV_W(ntry, wf4(:,27), 10, ex5(:), 16, wf8(:,165), n3(:,203), t3x8(:,:,135))
  call vert_UV_W(ntry, wf4(:,27), 10, ex6(:), 32, wf8(:,166), n3(:,204), t3x8(:,:,136))
  call counter_V_V(ctGG,21,ntry, wf8(:,1), 21, wf8(:,167), n2(52))
  call counter_V_V(ctGG,21,ntry, wf8(:,3), 26, wf8(:,168), n2(53))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,9), wf16(:,67), n3(:,205), t3x16(:,:,43))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,1), wf16(:,68), n3(:,206), t3x16(:,:,44))
  call counter_Q_A(cttt,6,ntry, wf4(:,8), 18, wf4(:,48), n2(54))
  call prop_A_Q(ntry, wf16(:,68), 45, MT, 1_intkind1, wf16(:,69), n2(55))
  call counter_A_Q(cttt,6,ntry, wf4(:,9), 40, wf4(:,49), n2(56))
  call prop_Q_A(ntry, wf16(:,8), 23, MT, 1_intkind1, wf16(:,70), n2(57))
  call vert_AV_Q(ntry, ex4(:), wf4(:,26), wf8(:,169), n3(:,207), t3x8(:,:,137))
  call prop_Q_A(ntry, wf4(:,48), 18, MT, 1_intkind1, wf4(:,50), n2(58))
  call vert_QA_V(ntry, wf4(:,50), ex4(:), wf8(:,170), n3(:,208), t3x8(:,:,138))
  call vert_VQ_A(ntry, ex6(:), wf4(:,50), wf8(:,171), n3(:,209), t3x8(:,:,139))
  call counter_A_Q(cttt,6,ntry, wf8(:,7), 13, wf8(:,172), n2(59))
  call counter_V_V(ctGG,21,ntry, wf8(:,8), 26, wf8(:,173), n2(60))
  call vert_QA_V(ntry, wf4(:,12), wf4(:,13), wf16(:,71), n3(:,210), t3x16(:,:,45))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,1), wf16(:,72), n3(:,211), t3x16(:,:,46))
  call counter_Q_A(cttt,6,ntry, wf4(:,12), 34, wf4(:,51), n2(61))
  call prop_A_Q(ntry, wf16(:,72), 29, MT, 1_intkind1, wf16(:,73), n2(62))
  call counter_A_Q(cttt,6,ntry, wf4(:,13), 24, wf4(:,52), n2(63))
  call prop_Q_A(ntry, wf16(:,9), 39, MT, 1_intkind1, wf16(:,74), n2(64))
  call vert_VQ_A(ntry, wf4(:,26), ex2(:), wf8(:,174), n3(:,212), t3x8(:,:,140))
  call prop_A_Q(ntry, wf4(:,52), 24, MT, 1_intkind1, wf4(:,53), n2(65))
  call vert_QA_V(ntry, ex2(:), wf4(:,53), wf8(:,175), n3(:,213), t3x8(:,:,141))
  call counter_Q_A(cttt,6,ntry, wf8(:,11), 7, wf8(:,176), n2(66))
  call counter_V_V(ctGG,21,ntry, wf8(:,12), 26, wf8(:,177), n2(67))
  call vert_AV_Q(ntry, wf4(:,53), ex6(:), wf8(:,178), n3(:,214), t3x8(:,:,142))
  call prop_Q_A(ntry, wf4(:,51), 34, MT, 1_intkind1, wf4(:,54), n2(68))
  call vert_QA_V(ntry, wf4(:,54), ex4(:), wf8(:,179), n3(:,215), t3x8(:,:,143))
  call vert_VQ_A(ntry, ex5(:), wf4(:,54), wf8(:,180), n3(:,216), t3x8(:,:,144))
  call counter_V_V(ctGG,21,ntry, wf8(:,14), 42, wf8(:,181), n2(69))
  call prop_A_Q(ntry, wf4(:,49), 40, MT, 1_intkind1, wf4(:,55), n2(70))
  call vert_QA_V(ntry, ex2(:), wf4(:,55), wf8(:,182), n3(:,217), t3x8(:,:,145))
  call counter_V_V(ctGG,21,ntry, wf8(:,16), 42, wf8(:,183), n2(71))
  call vert_AV_Q(ntry, wf4(:,55), ex5(:), wf8(:,184), n3(:,218), t3x8(:,:,146))
  call counter_Q_A(cttt,6,ntry, wf8(:,19), 50, wf8(:,185), n2(72))
  call vert_VQ_A(ntry, wf4(:,47), ex2(:), wf8(:,186), n3(:,219), t3x8(:,:,147))
  call vert_AV_Q(ntry, ex4(:), wf4(:,47), wf8(:,187), n3(:,220), t3x8(:,:,148))
  call vert_UV_W(ntry, wf4(:,4), 6, wf4(:,5), 48, wf16(:,75), n3(:,221), t3x16(:,:,47))
  call vert_UV_W(ntry, wf4(:,3), 9, wf4(:,5), 48, wf16(:,76), n3(:,222), t3x16(:,:,48))
  call vert_UV_W(ntry, wf4(:,33), 9, ex5(:), 16, wf8(:,188), n3(:,223), t3x8(:,:,149))
  call vert_UV_W(ntry, wf4(:,33), 9, ex6(:), 32, wf8(:,189), n3(:,224), t3x8(:,:,150))
  call vert_UV_W(ntry, wf4(:,34), 6, ex5(:), 16, wf8(:,190), n3(:,225), t3x8(:,:,151))
  call vert_UV_W(ntry, wf4(:,34), 6, ex6(:), 32, wf8(:,191), n3(:,226), t3x8(:,:,152))
  call counter_V_V(ctGG,21,ntry, wf8(:,20), 25, wf8(:,192), n2(73))
  call counter_V_V(ctGG,21,ntry, wf8(:,22), 22, wf8(:,193), n2(74))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,4), wf16(:,77), n3(:,227), t3x16(:,:,49))
  call counter_Q_A(cttt,6,ntry, wf4(:,15), 17, wf4(:,56), n2(75))
  call prop_A_Q(ntry, wf16(:,77), 46, MT, 1_intkind1, wf16(:,78), n2(76))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,9), wf16(:,79), n3(:,228), t3x16(:,:,50))
  call prop_Q_A(ntry, wf16(:,11), 23, MT, 1_intkind1, wf16(:,80), n2(77))
  call prop_Q_A(ntry, wf4(:,56), 17, MT, 1_intkind1, wf4(:,57), n2(78))
  call vert_QA_V(ntry, wf4(:,57), ex4(:), wf8(:,194), n3(:,229), t3x8(:,:,153))
  call vert_VQ_A(ntry, ex6(:), wf4(:,57), wf8(:,195), n3(:,230), t3x8(:,:,154))
  call vert_AV_Q(ntry, ex4(:), wf4(:,34), wf8(:,196), n3(:,231), t3x8(:,:,155))
  call counter_V_V(ctGG,21,ntry, wf8(:,24), 25, wf8(:,197), n2(79))
  call counter_A_Q(cttt,6,ntry, wf8(:,27), 14, wf8(:,198), n2(80))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,4), wf16(:,81), n3(:,232), t3x16(:,:,51))
  call counter_Q_A(cttt,6,ntry, wf4(:,17), 33, wf4(:,58), n2(81))
  call prop_A_Q(ntry, wf16(:,81), 30, MT, 1_intkind1, wf16(:,82), n2(82))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,13), wf16(:,83), n3(:,233), t3x16(:,:,52))
  call prop_Q_A(ntry, wf16(:,12), 39, MT, 1_intkind1, wf16(:,84), n2(83))
  call vert_VQ_A(ntry, wf4(:,34), ex1(:), wf8(:,199), n3(:,234), t3x8(:,:,156))
  call vert_QA_V(ntry, ex1(:), wf4(:,53), wf8(:,200), n3(:,235), t3x8(:,:,157))
  call counter_Q_A(cttt,6,ntry, wf8(:,29), 7, wf8(:,201), n2(84))
  call counter_V_V(ctGG,21,ntry, wf8(:,30), 25, wf8(:,202), n2(85))
  call prop_Q_A(ntry, wf4(:,58), 33, MT, 1_intkind1, wf4(:,59), n2(86))
  call vert_QA_V(ntry, wf4(:,59), ex4(:), wf8(:,203), n3(:,236), t3x8(:,:,158))
  call vert_VQ_A(ntry, ex5(:), wf4(:,59), wf8(:,204), n3(:,237), t3x8(:,:,159))
  call counter_V_V(ctGG,21,ntry, wf8(:,31), 41, wf8(:,205), n2(87))
  call vert_QA_V(ntry, ex1(:), wf4(:,55), wf8(:,206), n3(:,238), t3x8(:,:,160))
  call counter_V_V(ctGG,21,ntry, wf8(:,33), 41, wf8(:,207), n2(88))
  call counter_Q_A(cttt,6,ntry, wf8(:,35), 49, wf8(:,208), n2(89))
  call vert_VQ_A(ntry, wf4(:,47), ex1(:), wf8(:,209), n3(:,239), t3x8(:,:,161))
  call vert_QA_V(ntry, wf4(:,8), wf4(:,19), wf16(:,85), n3(:,240), t3x16(:,:,53))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,3), wf16(:,86), n3(:,241), t3x16(:,:,54))
  call prop_A_Q(ntry, wf16(:,86), 45, MT, 1_intkind1, wf16(:,87), n2(90))
  call counter_A_Q(cttt,6,ntry, wf4(:,19), 36, wf4(:,60), n2(91))
  call prop_Q_A(ntry, wf16(:,13), 27, MT, 1_intkind1, wf16(:,88), n2(92))
  call vert_AV_Q(ntry, ex3(:), wf4(:,33), wf8(:,210), n3(:,242), t3x8(:,:,162))
  call vert_QA_V(ntry, wf4(:,50), ex3(:), wf8(:,211), n3(:,243), t3x8(:,:,163))
  call counter_A_Q(cttt,6,ntry, wf8(:,37), 13, wf8(:,212), n2(93))
  call counter_V_V(ctGG,21,ntry, wf8(:,38), 22, wf8(:,213), n2(94))
  call vert_QA_V(ntry, wf4(:,12), wf4(:,21), wf16(:,89), n3(:,244), t3x16(:,:,55))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,3), wf16(:,90), n3(:,245), t3x16(:,:,56))
  call prop_A_Q(ntry, wf16(:,90), 29, MT, 1_intkind1, wf16(:,91), n2(95))
  call counter_A_Q(cttt,6,ntry, wf4(:,21), 20, wf4(:,61), n2(96))
  call prop_Q_A(ntry, wf16(:,14), 43, MT, 1_intkind1, wf16(:,92), n2(97))
  call vert_VQ_A(ntry, wf4(:,33), ex2(:), wf8(:,214), n3(:,246), t3x8(:,:,164))
  call prop_A_Q(ntry, wf4(:,61), 20, MT, 1_intkind1, wf4(:,62), n2(98))
  call vert_QA_V(ntry, ex2(:), wf4(:,62), wf8(:,215), n3(:,247), t3x8(:,:,165))
  call counter_Q_A(cttt,6,ntry, wf8(:,41), 11, wf8(:,216), n2(99))
  call counter_V_V(ctGG,21,ntry, wf8(:,42), 22, wf8(:,217), n2(100))
  call vert_AV_Q(ntry, wf4(:,62), ex6(:), wf8(:,218), n3(:,248), t3x8(:,:,166))
  call vert_QA_V(ntry, wf4(:,54), ex3(:), wf8(:,219), n3(:,249), t3x8(:,:,167))
  call counter_V_V(ctGG,21,ntry, wf8(:,43), 38, wf8(:,220), n2(101))
  call prop_A_Q(ntry, wf4(:,60), 36, MT, 1_intkind1, wf4(:,63), n2(102))
  call vert_QA_V(ntry, ex2(:), wf4(:,63), wf8(:,221), n3(:,250), t3x8(:,:,168))
  call counter_V_V(ctGG,21,ntry, wf8(:,45), 38, wf8(:,222), n2(103))
  call vert_AV_Q(ntry, wf4(:,63), ex5(:), wf8(:,223), n3(:,251), t3x8(:,:,169))
  call vert_AV_Q(ntry, ex3(:), wf4(:,47), wf8(:,224), n3(:,252), t3x8(:,:,170))
  call vert_AV_Q(ntry, wf4(:,19), wf4(:,2), wf16(:,93), n3(:,253), t3x16(:,:,57))
  call prop_A_Q(ntry, wf16(:,93), 46, MT, 1_intkind1, wf16(:,94), n2(104))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,19), wf16(:,95), n3(:,254), t3x16(:,:,58))
  call prop_Q_A(ntry, wf16(:,15), 27, MT, 1_intkind1, wf16(:,96), n2(105))
  call vert_QA_V(ntry, wf4(:,57), ex3(:), wf8(:,225), n3(:,255), t3x8(:,:,171))
  call vert_AV_Q(ntry, ex3(:), wf4(:,27), wf8(:,226), n3(:,256), t3x8(:,:,172))
  call counter_V_V(ctGG,21,ntry, wf8(:,47), 21, wf8(:,227), n2(106))
  call counter_A_Q(cttt,6,ntry, wf8(:,49), 14, wf8(:,228), n2(107))
  call vert_AV_Q(ntry, wf4(:,21), wf4(:,2), wf16(:,97), n3(:,257), t3x16(:,:,59))
  call prop_A_Q(ntry, wf16(:,97), 30, MT, 1_intkind1, wf16(:,98), n2(108))
  call vert_QA_V(ntry, wf4(:,17), wf4(:,21), wf16(:,99), n3(:,258), t3x16(:,:,60))
  call prop_Q_A(ntry, wf16(:,16), 43, MT, 1_intkind1, wf16(:,100), n2(109))
  call vert_VQ_A(ntry, wf4(:,27), ex1(:), wf8(:,229), n3(:,259), t3x8(:,:,173))
  call vert_QA_V(ntry, ex1(:), wf4(:,62), wf8(:,230), n3(:,260), t3x8(:,:,174))
  call counter_Q_A(cttt,6,ntry, wf8(:,51), 11, wf8(:,231), n2(110))
  call counter_V_V(ctGG,21,ntry, wf8(:,52), 21, wf8(:,232), n2(111))
  call vert_QA_V(ntry, wf4(:,59), ex3(:), wf8(:,233), n3(:,261), t3x8(:,:,175))
  call counter_V_V(ctGG,21,ntry, wf8(:,53), 37, wf8(:,234), n2(112))
  call vert_QA_V(ntry, ex1(:), wf4(:,63), wf8(:,235), n3(:,262), t3x8(:,:,176))
  call counter_V_V(ctGG,21,ntry, wf8(:,54), 37, wf8(:,236), n2(113))
  call vert_QA_V(ntry, wf8(:,11), ex4(:), wf16(:,101), n3(:,263), t3x16(:,:,61))
  call vert_VQ_A(ntry, ex5(:), wf8(:,11), wf16(:,102), n3(:,264), t3x16(:,:,62))
  call prop_Q_A(ntry, wf16(:,102), 23, MT, 1_intkind1, wf16(:,103), n2(114))
  call vert_VQ_A(ntry, ex6(:), wf8(:,11), wf16(:,104), n3(:,265), t3x16(:,:,63))
  call prop_Q_A(ntry, wf16(:,104), 39, MT, 1_intkind1, wf16(:,105), n2(115))
  call vert_QA_V(ntry, ex2(:), wf8(:,7), wf16(:,106), n3(:,266), t3x16(:,:,64))
  call vert_AV_Q(ntry, wf8(:,7), ex5(:), wf16(:,107), n3(:,267), t3x16(:,:,65))
  call prop_A_Q(ntry, wf16(:,107), 29, MT, 1_intkind1, wf16(:,108), n2(116))
  call vert_AV_Q(ntry, wf8(:,7), ex6(:), wf16(:,109), n3(:,268), t3x16(:,:,66))
  call prop_A_Q(ntry, wf16(:,109), 45, MT, 1_intkind1, wf16(:,110), n2(117))
  call vert_VQ_A(ntry, wf8(:,1), ex2(:), wf16(:,111), n3(:,269), t3x16(:,:,67))
  call prop_Q_A(ntry, wf16(:,111), 23, MT, 1_intkind1, wf16(:,112), n2(118))
  call vert_AV_Q(ntry, ex4(:), wf8(:,1), wf16(:,113), n3(:,270), t3x16(:,:,68))
  call prop_A_Q(ntry, wf16(:,113), 29, MT, 1_intkind1, wf16(:,114), n2(119))
  call vert_UV_W(ntry, wf8(:,1), 21, ex6(:), 32, wf16(:,115), n3(:,271), t3x16(:,:,69))
  call vert_VQ_A(ntry, wf8(:,4), ex2(:), wf16(:,116), n3(:,272), t3x16(:,:,70))
  call prop_Q_A(ntry, wf16(:,116), 39, MT, 1_intkind1, wf16(:,117), n2(120))
  call vert_AV_Q(ntry, ex4(:), wf8(:,4), wf16(:,118), n3(:,273), t3x16(:,:,71))
  call prop_A_Q(ntry, wf16(:,118), 45, MT, 1_intkind1, wf16(:,119), n2(121))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,4), 37, wf16(:,120), n3(:,274), t3x16(:,:,72))
  call vert_QA_V(ntry, wf8(:,29), ex4(:), wf16(:,121), n3(:,275), t3x16(:,:,73))
  call vert_VQ_A(ntry, ex5(:), wf8(:,29), wf16(:,122), n3(:,276), t3x16(:,:,74))
  call prop_Q_A(ntry, wf16(:,122), 23, MT, 1_intkind1, wf16(:,123), n2(122))
  call vert_VQ_A(ntry, ex6(:), wf8(:,29), wf16(:,124), n3(:,277), t3x16(:,:,75))
  call prop_Q_A(ntry, wf16(:,124), 39, MT, 1_intkind1, wf16(:,125), n2(123))
  call vert_QA_V(ntry, ex1(:), wf8(:,27), wf16(:,126), n3(:,278), t3x16(:,:,76))
  call vert_VQ_A(ntry, wf8(:,22), ex1(:), wf16(:,127), n3(:,279), t3x16(:,:,77))
  call prop_Q_A(ntry, wf16(:,127), 23, MT, 1_intkind1, wf16(:,128), n2(124))
  call vert_VQ_A(ntry, wf8(:,21), ex1(:), wf16(:,129), n3(:,280), t3x16(:,:,78))
  call prop_Q_A(ntry, wf16(:,129), 39, MT, 1_intkind1, wf16(:,130), n2(125))
  call vert_AV_Q(ntry, wf8(:,27), ex5(:), wf16(:,131), n3(:,281), t3x16(:,:,79))
  call prop_A_Q(ntry, wf16(:,131), 30, MT, 1_intkind1, wf16(:,132), n2(126))
  call vert_AV_Q(ntry, wf8(:,27), ex6(:), wf16(:,133), n3(:,282), t3x16(:,:,80))
  call prop_A_Q(ntry, wf16(:,133), 46, MT, 1_intkind1, wf16(:,134), n2(127))
  call vert_AV_Q(ntry, ex4(:), wf8(:,22), wf16(:,135), n3(:,283), t3x16(:,:,81))
  call prop_A_Q(ntry, wf16(:,135), 30, MT, 1_intkind1, wf16(:,136), n2(128))
  call vert_UV_W(ntry, wf8(:,22), 22, ex6(:), 32, wf16(:,137), n3(:,284), t3x16(:,:,82))
  call vert_AV_Q(ntry, ex4(:), wf8(:,21), wf16(:,138), n3(:,285), t3x16(:,:,83))
  call prop_A_Q(ntry, wf16(:,138), 46, MT, 1_intkind1, wf16(:,139), n2(129))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,21), 38, wf16(:,140), n3(:,286), t3x16(:,:,84))
  call vert_QA_V(ntry, wf8(:,41), ex3(:), wf16(:,141), n3(:,287), t3x16(:,:,85))
  call vert_VQ_A(ntry, ex5(:), wf8(:,41), wf16(:,142), n3(:,288), t3x16(:,:,86))
  call prop_Q_A(ntry, wf16(:,142), 27, MT, 1_intkind1, wf16(:,143), n2(130))
  call vert_VQ_A(ntry, ex6(:), wf8(:,41), wf16(:,144), n3(:,289), t3x16(:,:,87))
  call prop_Q_A(ntry, wf16(:,144), 43, MT, 1_intkind1, wf16(:,145), n2(131))
  call vert_QA_V(ntry, ex2(:), wf8(:,37), wf16(:,146), n3(:,290), t3x16(:,:,88))
  call vert_AV_Q(ntry, wf8(:,37), ex5(:), wf16(:,147), n3(:,291), t3x16(:,:,89))
  call prop_A_Q(ntry, wf16(:,147), 29, MT, 1_intkind1, wf16(:,148), n2(132))
  call vert_AV_Q(ntry, wf8(:,37), ex6(:), wf16(:,149), n3(:,292), t3x16(:,:,90))
  call prop_A_Q(ntry, wf16(:,149), 45, MT, 1_intkind1, wf16(:,150), n2(133))
  call vert_VQ_A(ntry, wf8(:,20), ex2(:), wf16(:,151), n3(:,293), t3x16(:,:,91))
  call prop_Q_A(ntry, wf16(:,151), 27, MT, 1_intkind1, wf16(:,152), n2(134))
  call vert_AV_Q(ntry, ex3(:), wf8(:,20), wf16(:,153), n3(:,294), t3x16(:,:,92))
  call prop_A_Q(ntry, wf16(:,153), 29, MT, 1_intkind1, wf16(:,154), n2(135))
  call vert_UV_W(ntry, wf8(:,20), 25, ex6(:), 32, wf16(:,155), n3(:,295), t3x16(:,:,93))
  call vert_VQ_A(ntry, wf8(:,23), ex2(:), wf16(:,156), n3(:,296), t3x16(:,:,94))
  call prop_Q_A(ntry, wf16(:,156), 43, MT, 1_intkind1, wf16(:,157), n2(136))
  call vert_AV_Q(ntry, ex3(:), wf8(:,23), wf16(:,158), n3(:,297), t3x16(:,:,95))
  call prop_A_Q(ntry, wf16(:,158), 45, MT, 1_intkind1, wf16(:,159), n2(137))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,23), 41, wf16(:,160), n3(:,298), t3x16(:,:,96))
  call vert_QA_V(ntry, wf8(:,51), ex3(:), wf16(:,161), n3(:,299), t3x16(:,:,97))
  call vert_VQ_A(ntry, ex5(:), wf8(:,51), wf16(:,162), n3(:,300), t3x16(:,:,98))
  call prop_Q_A(ntry, wf16(:,162), 27, MT, 1_intkind1, wf16(:,163), n2(138))
  call vert_VQ_A(ntry, ex6(:), wf8(:,51), wf16(:,164), n3(:,301), t3x16(:,:,99))
  call prop_Q_A(ntry, wf16(:,164), 43, MT, 1_intkind1, wf16(:,165), n2(139))
  call vert_QA_V(ntry, ex1(:), wf8(:,49), wf16(:,166), n3(:,302), t3x16(:,:,100))
  call vert_VQ_A(ntry, wf8(:,3), ex1(:), wf16(:,167), n3(:,303), t3x16(:,:,101))
  call prop_Q_A(ntry, wf16(:,167), 27, MT, 1_intkind1, wf16(:,168), n2(140))
  call vert_VQ_A(ntry, wf8(:,2), ex1(:), wf16(:,169), n3(:,304), t3x16(:,:,102))
  call prop_Q_A(ntry, wf16(:,169), 43, MT, 1_intkind1, wf16(:,170), n2(141))
  call vert_AV_Q(ntry, wf8(:,49), ex5(:), wf16(:,171), n3(:,305), t3x16(:,:,103))
  call prop_A_Q(ntry, wf16(:,171), 30, MT, 1_intkind1, wf16(:,172), n2(142))
  call vert_AV_Q(ntry, wf8(:,49), ex6(:), wf16(:,173), n3(:,306), t3x16(:,:,104))
  call prop_A_Q(ntry, wf16(:,173), 46, MT, 1_intkind1, wf16(:,174), n2(143))
  call vert_AV_Q(ntry, ex3(:), wf8(:,3), wf16(:,175), n3(:,307), t3x16(:,:,105))
  call prop_A_Q(ntry, wf16(:,175), 30, MT, 1_intkind1, wf16(:,176), n2(144))
  call vert_UV_W(ntry, wf8(:,3), 26, ex6(:), 32, wf16(:,177), n3(:,308), t3x16(:,:,106))
  call vert_AV_Q(ntry, ex3(:), wf8(:,2), wf16(:,178), n3(:,309), t3x16(:,:,107))
  call prop_A_Q(ntry, wf16(:,178), 46, MT, 1_intkind1, wf16(:,179), n2(145))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,2), 42, wf16(:,180), n3(:,310), t3x16(:,:,108))
  call vert_VQ_A(ntry, wf8(:,47), ex2(:), wf16(:,181), n3(:,311), t3x16(:,:,109))
  call prop_Q_A(ntry, wf16(:,181), 23, MT, 1_intkind1, wf16(:,182), n2(146))
  call vert_AV_Q(ntry, ex4(:), wf8(:,47), wf16(:,183), n3(:,312), t3x16(:,:,110))
  call prop_A_Q(ntry, wf16(:,183), 29, MT, 1_intkind1, wf16(:,184), n2(147))
  call vert_UV_W(ntry, wf8(:,47), 21, ex6(:), 32, wf16(:,185), n3(:,313), t3x16(:,:,111))
  call vert_VQ_A(ntry, wf8(:,24), ex2(:), wf16(:,186), n3(:,314), t3x16(:,:,112))
  call prop_Q_A(ntry, wf16(:,186), 27, MT, 1_intkind1, wf16(:,187), n2(148))
  call vert_AV_Q(ntry, ex3(:), wf8(:,24), wf16(:,188), n3(:,315), t3x16(:,:,113))
  call prop_A_Q(ntry, wf16(:,188), 29, MT, 1_intkind1, wf16(:,189), n2(149))
  call vert_UV_W(ntry, wf8(:,24), 25, ex6(:), 32, wf16(:,190), n3(:,316), t3x16(:,:,114))
  call vert_QA_V(ntry, wf8(:,85), ex3(:), wf16(:,191), n3(:,317), t3x16(:,:,115))
  call vert_QA_V(ntry, wf8(:,85), ex4(:), wf16(:,192), n3(:,318), t3x16(:,:,116))
  call vert_VQ_A(ntry, wf8(:,38), ex1(:), wf16(:,193), n3(:,319), t3x16(:,:,117))
  call prop_Q_A(ntry, wf16(:,193), 23, MT, 1_intkind1, wf16(:,194), n2(150))
  call vert_VQ_A(ntry, wf8(:,8), ex1(:), wf16(:,195), n3(:,320), t3x16(:,:,118))
  call prop_Q_A(ntry, wf16(:,195), 27, MT, 1_intkind1, wf16(:,196), n2(151))
  call vert_AV_Q(ntry, ex4(:), wf8(:,38), wf16(:,197), n3(:,321), t3x16(:,:,119))
  call prop_A_Q(ntry, wf16(:,197), 30, MT, 1_intkind1, wf16(:,198), n2(152))
  call vert_UV_W(ntry, wf8(:,38), 22, ex6(:), 32, wf16(:,199), n3(:,322), t3x16(:,:,120))
  call vert_AV_Q(ntry, ex3(:), wf8(:,8), wf16(:,200), n3(:,323), t3x16(:,:,121))
  call prop_A_Q(ntry, wf16(:,200), 30, MT, 1_intkind1, wf16(:,201), n2(153))
  call vert_UV_W(ntry, wf8(:,8), 26, ex6(:), 32, wf16(:,202), n3(:,324), t3x16(:,:,122))
  call vert_QA_V(ntry, wf8(:,68), ex3(:), wf16(:,203), n3(:,325), t3x16(:,:,123))
  call vert_QA_V(ntry, wf8(:,68), ex4(:), wf16(:,204), n3(:,326), t3x16(:,:,124))
  call vert_VQ_A(ntry, wf8(:,52), ex2(:), wf16(:,205), n3(:,327), t3x16(:,:,125))
  call prop_Q_A(ntry, wf16(:,205), 23, MT, 1_intkind1, wf16(:,206), n2(154))
  call vert_VQ_A(ntry, wf8(:,42), ex1(:), wf16(:,207), n3(:,328), t3x16(:,:,126))
  call prop_Q_A(ntry, wf16(:,207), 23, MT, 1_intkind1, wf16(:,208), n2(155))
  call vert_AV_Q(ntry, ex4(:), wf8(:,52), wf16(:,209), n3(:,329), t3x16(:,:,127))
  call prop_A_Q(ntry, wf16(:,209), 29, MT, 1_intkind1, wf16(:,210), n2(156))
  call vert_UV_W(ntry, wf8(:,52), 21, ex6(:), 32, wf16(:,211), n3(:,330), t3x16(:,:,128))
  call vert_QA_V(ntry, ex1(:), wf8(:,122), wf16(:,212), n3(:,331), t3x16(:,:,129))
  call vert_AV_Q(ntry, ex4(:), wf8(:,42), wf16(:,213), n3(:,332), t3x16(:,:,130))
  call prop_A_Q(ntry, wf16(:,213), 30, MT, 1_intkind1, wf16(:,214), n2(157))
  call vert_UV_W(ntry, wf8(:,42), 22, ex6(:), 32, wf16(:,215), n3(:,333), t3x16(:,:,131))
  call vert_QA_V(ntry, ex2(:), wf8(:,122), wf16(:,216), n3(:,334), t3x16(:,:,132))
  call vert_VQ_A(ntry, wf8(:,30), ex2(:), wf16(:,217), n3(:,335), t3x16(:,:,133))
  call prop_Q_A(ntry, wf16(:,217), 27, MT, 1_intkind1, wf16(:,218), n2(158))
  call vert_VQ_A(ntry, wf8(:,12), ex1(:), wf16(:,219), n3(:,336), t3x16(:,:,134))
  call prop_Q_A(ntry, wf16(:,219), 27, MT, 1_intkind1, wf16(:,220), n2(159))
  call vert_AV_Q(ntry, ex3(:), wf8(:,30), wf16(:,221), n3(:,337), t3x16(:,:,135))
  call prop_A_Q(ntry, wf16(:,221), 29, MT, 1_intkind1, wf16(:,222), n2(160))
  call vert_UV_W(ntry, wf8(:,30), 25, ex6(:), 32, wf16(:,223), n3(:,338), t3x16(:,:,136))
  call vert_QA_V(ntry, ex1(:), wf8(:,109), wf16(:,224), n3(:,339), t3x16(:,:,137))
  call vert_AV_Q(ntry, ex3(:), wf8(:,12), wf16(:,225), n3(:,340), t3x16(:,:,138))
  call prop_A_Q(ntry, wf16(:,225), 30, MT, 1_intkind1, wf16(:,226), n2(161))
  call vert_UV_W(ntry, wf8(:,12), 26, ex6(:), 32, wf16(:,227), n3(:,341), t3x16(:,:,139))
  call vert_QA_V(ntry, ex2(:), wf8(:,109), wf16(:,228), n3(:,342), t3x16(:,:,140))
  call vert_VQ_A(ntry, wf8(:,53), ex2(:), wf16(:,229), n3(:,343), t3x16(:,:,141))
  call prop_Q_A(ntry, wf16(:,229), 39, MT, 1_intkind1, wf16(:,230), n2(162))
  call vert_AV_Q(ntry, ex4(:), wf8(:,53), wf16(:,231), n3(:,344), t3x16(:,:,142))
  call prop_A_Q(ntry, wf16(:,231), 45, MT, 1_intkind1, wf16(:,232), n2(163))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,53), 37, wf16(:,233), n3(:,345), t3x16(:,:,143))
  call vert_VQ_A(ntry, wf8(:,31), ex2(:), wf16(:,234), n3(:,346), t3x16(:,:,144))
  call prop_Q_A(ntry, wf16(:,234), 43, MT, 1_intkind1, wf16(:,235), n2(164))
  call vert_AV_Q(ntry, ex3(:), wf8(:,31), wf16(:,236), n3(:,347), t3x16(:,:,145))
  call prop_A_Q(ntry, wf16(:,236), 45, MT, 1_intkind1, wf16(:,237), n2(165))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,31), 41, wf16(:,238), n3(:,348), t3x16(:,:,146))
  call vert_QA_V(ntry, wf8(:,87), ex3(:), wf16(:,239), n3(:,349), t3x16(:,:,147))
  call vert_QA_V(ntry, wf8(:,87), ex4(:), wf16(:,240), n3(:,350), t3x16(:,:,148))
  call vert_VQ_A(ntry, wf8(:,43), ex1(:), wf16(:,241), n3(:,351), t3x16(:,:,149))
  call prop_Q_A(ntry, wf16(:,241), 39, MT, 1_intkind1, wf16(:,242), n2(166))
  call vert_VQ_A(ntry, wf8(:,14), ex1(:), wf16(:,243), n3(:,352), t3x16(:,:,150))
  call prop_Q_A(ntry, wf16(:,243), 43, MT, 1_intkind1, wf16(:,244), n2(167))
  call vert_AV_Q(ntry, ex4(:), wf8(:,43), wf16(:,245), n3(:,353), t3x16(:,:,151))
  call prop_A_Q(ntry, wf16(:,245), 46, MT, 1_intkind1, wf16(:,246), n2(168))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,43), 38, wf16(:,247), n3(:,354), t3x16(:,:,152))
  call vert_AV_Q(ntry, ex3(:), wf8(:,14), wf16(:,248), n3(:,355), t3x16(:,:,153))
  call prop_A_Q(ntry, wf16(:,248), 46, MT, 1_intkind1, wf16(:,249), n2(169))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,14), 42, wf16(:,250), n3(:,356), t3x16(:,:,154))
  call vert_QA_V(ntry, wf8(:,70), ex3(:), wf16(:,251), n3(:,357), t3x16(:,:,155))
  call vert_QA_V(ntry, wf8(:,70), ex4(:), wf16(:,252), n3(:,358), t3x16(:,:,156))
  call vert_VQ_A(ntry, wf8(:,54), ex2(:), wf16(:,253), n3(:,359), t3x16(:,:,157))
  call prop_Q_A(ntry, wf16(:,253), 39, MT, 1_intkind1, wf16(:,254), n2(170))
  call vert_VQ_A(ntry, wf8(:,45), ex1(:), wf16(:,255), n3(:,360), t3x16(:,:,158))
  call prop_Q_A(ntry, wf16(:,255), 39, MT, 1_intkind1, wf16(:,256), n2(171))
  call vert_AV_Q(ntry, ex4(:), wf8(:,54), wf16(:,257), n3(:,361), t3x16(:,:,159))
  call prop_A_Q(ntry, wf16(:,257), 45, MT, 1_intkind1, wf16(:,258), n2(172))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,54), 37, wf16(:,259), n3(:,362), t3x16(:,:,160))
  call vert_QA_V(ntry, ex1(:), wf8(:,124), wf16(:,260), n3(:,363), t3x16(:,:,161))
  call vert_AV_Q(ntry, ex4(:), wf8(:,45), wf16(:,261), n3(:,364), t3x16(:,:,162))
  call prop_A_Q(ntry, wf16(:,261), 46, MT, 1_intkind1, wf16(:,262), n2(173))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,45), 38, wf16(:,263), n3(:,365), t3x16(:,:,163))
  call vert_QA_V(ntry, ex2(:), wf8(:,124), wf16(:,264), n3(:,366), t3x16(:,:,164))
  call vert_VQ_A(ntry, wf8(:,33), ex2(:), wf16(:,265), n3(:,367), t3x16(:,:,165))
  call prop_Q_A(ntry, wf16(:,265), 43, MT, 1_intkind1, wf16(:,266), n2(174))
  call vert_VQ_A(ntry, wf8(:,16), ex1(:), wf16(:,267), n3(:,368), t3x16(:,:,166))
  call prop_Q_A(ntry, wf16(:,267), 43, MT, 1_intkind1, wf16(:,268), n2(175))
  call vert_AV_Q(ntry, ex3(:), wf8(:,33), wf16(:,269), n3(:,369), t3x16(:,:,167))
  call prop_A_Q(ntry, wf16(:,269), 45, MT, 1_intkind1, wf16(:,270), n2(176))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,33), 41, wf16(:,271), n3(:,370), t3x16(:,:,168))
  call vert_QA_V(ntry, ex1(:), wf8(:,111), wf16(:,272), n3(:,371), t3x16(:,:,169))
  call vert_AV_Q(ntry, ex3(:), wf8(:,16), wf16(:,273), n3(:,372), t3x16(:,:,170))
  call prop_A_Q(ntry, wf16(:,273), 46, MT, 1_intkind1, wf16(:,274), n2(177))
  call vert_UV_W(ntry, ex5(:), 16, wf8(:,16), 42, wf16(:,275), n3(:,373), t3x16(:,:,171))
  call vert_QA_V(ntry, ex2(:), wf8(:,111), wf16(:,276), n3(:,374), t3x16(:,:,172))
  call vert_QA_V(ntry, wf8(:,35), ex3(:), wf16(:,277), n3(:,375), t3x16(:,:,173))
  call vert_QA_V(ntry, ex1(:), wf8(:,125), wf16(:,278), n3(:,376), t3x16(:,:,174))
  call vert_QA_V(ntry, wf8(:,35), ex4(:), wf16(:,279), n3(:,377), t3x16(:,:,175))
  call vert_QA_V(ntry, ex1(:), wf8(:,113), wf16(:,280), n3(:,378), t3x16(:,:,176))
  call vert_QA_V(ntry, wf8(:,19), ex3(:), wf16(:,281), n3(:,379), t3x16(:,:,177))
  call vert_QA_V(ntry, ex2(:), wf8(:,125), wf16(:,282), n3(:,380), t3x16(:,:,178))
  call vert_QA_V(ntry, wf8(:,19), ex4(:), wf16(:,283), n3(:,381), t3x16(:,:,179))
  call vert_QA_V(ntry, ex2(:), wf8(:,113), wf16(:,284), n3(:,382), t3x16(:,:,180))


  call init_hybrid_exwf(ex1)
  call init_hybrid_exwf(ex2)
  call init_hybrid_exwf(ex3)
  call init_hybrid_exwf(ex4)
  call init_hybrid_exwf(ex5)
  call init_hybrid_exwf(ex6)
  call init_hybrid_wf(wf4)
  call init_hybrid_wf(wf8)
  call init_hybrid_wf(wf16)


  if (ntry==1) then
    call physical_helicities()
  end if

  ! computation of the colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) call helsync(nsync, A, nhel, Hel)
  end do

  ! In the following loop the coefficients \Gamma_{i} of the expansion in
  ! the colour basis are computed for every helicity state and stored in M1helarray.
  ! Also the colour vector for the Born-loop interference is computed and saved in
  ! M0_col1_helarray
  do k = 1, nhel
    call colourvectors(A, k, M1helarray(:,k),M1helarray_ct(:,k))
    call colborninterf(M1helarray(:,k), M0_col1_helarray(:,k), 0)
  end do
  M1helarray(:,nhel+1:)%j = 0
  M0_col1_helarray(:,nhel+1:)%hf = -1_intkind2
  M0_col1_helarray(:,nhel+1:)%j = 0

  M2add = 0
  M2add_ct = 0
  M2add_colint = 0

  M02 = 0
  M2ct = 0
  M2colint = 0

  do k = 1, nhel
    call colint(M1helarray(:,k)%j, M2add)
    call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, 0)
    if (IR_is_on > 0) then
      call colint_IR(M1helarray(:,k)%j, M2add_colint)
    end if
    !summation over helicity configurations
    M02 = M02 + M2add
    M2ct = M2ct + M2add_ct
    M2colint = M2colint + M2add_colint
  end do

  call photon_factors(photonid_pptttt_tttxtxgg_1, &
                    &  0, bornphotonfactor)
  M02 = bornphotonfactor * M02
  M2ct = bornphotonfactor * M2ct
  M2colint = bornphotonfactor * M2colint

  !! used for born-loop colour-correlators
  extcombs = [(i, i = 0, 22-1)]
  nextcombs = 6*(6+1)/2 + 1
  if(nextcombs>0) then
    allocate(extcombs_permuted(nextcombs))
  end if
  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptttt_tttxtxgg_1(extcombs(k))
  end do

#if -1 > 0 && 6 > 3
  !!Born-loop colour correlators interference

  M0M1_hel_cc(:,:,:)%j = 0
  do n = 1, 9
    M2add_ct = 0
    m = ind_cc_comb(n)
      do k = 1, nhel
        call colint_ct(M1helarray(:,k)%j, M1helarray_ct(:,k)%j, M2add_ct, m)
        call colborninterf(M1helarray(:,k), M0M1_hel_cc(:,k,m), m)
        M2ctcc(m) = M2ctcc(m) + M2add_ct
      end do
  end do
  M0M1_hel_cc(:,nhel+1:,:)%hf = -1_intkind2
  M0M1_hel_cc(:,nhel+1:,:)%j = 0
#endif

  ntry=2


  contains

subroutine physical_helicities()
  implicit none

integer :: i1,i2,i3,i4,i5,i6
integer :: n

n=0

do i6= 1, 2
do i5= 1, 2
do i4= 1, 2
do i3= 1, 2
do i2= 1, 2
do i1= 1, 2
n = n + 1
 if((ex1(i1)%hf==-1_intkind2) .OR. (ex2(i2)%hf==-1_intkind2) .OR. (ex3(i3)%hf==-1_intkind2) .OR. (ex4(i4)%hf==-1_intkind2)  &
    .OR. (ex5(i5)%hf==-1_intkind2) .OR. (ex6(i6)%hf==-1_intkind2)) then
  Hel(n) = -1_intkind2
 else
  Hel(n) = ex1(i1)%hf + ex2(i2)%hf + ex3(i3)%hf + ex4(i4)%hf + ex5(i5)%hf + ex6(i6)%hf
 end if
end do
end do
end do
end do
end do
end do

end subroutine physical_helicities

subroutine diagrams()
  implicit none
  integer :: h
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call Hcont_VV(nsync, wf4(:,2), wf16(:,1), A(:,1), n3(:,383), t3x64(:,:,1), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,2), A(:,2), n3(:,384), t3x64(:,:,2), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,3), A(:,3), n3(:,385), t3x64(:,:,3), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,4), A(:,4), n3(:,386), t3x64(:,:,4), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,5), A(:,5), n3(:,387), t3x64(:,:,5), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,6), A(:,6), n3(:,388), t3x64(:,:,6), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,7), A(:,7), n3(:,389), t3x64(:,:,7), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,2), A(:,8), n3(:,390), t3x64(:,:,8), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,4), A(:,9), n3(:,391), t3x64(:,:,9), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,8), A(:,10), n3(:,392), t3x64(:,:,10), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,7), A(:,11), n3(:,393), t3x64(:,:,11), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,8), A(:,12), n3(:,394), t3x64(:,:,12), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,9), A(:,13), n3(:,395), t3x64(:,:,13), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,11), A(:,14), n3(:,396), t3x64(:,:,14), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,12), A(:,15), n3(:,397), t3x64(:,:,15), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,13), A(:,16), n3(:,398), t3x64(:,:,16), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,14), A(:,17), n3(:,399), t3x64(:,:,17), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,15), A(:,18), n3(:,400), t3x64(:,:,18), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,16), A(:,19), n3(:,401), t3x64(:,:,19), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,17), A(:,20), n3(:,402), t3x64(:,:,20), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,19), A(:,21), n3(:,403), t3x64(:,:,21), nhel, den(43))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,10), A(:,22), n3(:,404), t3x64(:,:,22), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,21), A(:,23), n3(:,405), t3x64(:,:,23), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,23), A(:,24), n3(:,406), t3x64(:,:,24), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,11), A(:,25), n3(:,407), t3x64(:,:,25), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,24), A(:,26), n3(:,408), t3x64(:,:,26), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,27), A(:,27), n3(:,409), t3x64(:,:,27), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,12), A(:,28), n3(:,410), t3x64(:,:,28), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,29), A(:,29), n3(:,411), t3x64(:,:,29), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,30), A(:,30), n3(:,412), t3x64(:,:,30), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,31), A(:,31), n3(:,413), t3x64(:,:,31), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,32), A(:,32), n3(:,414), t3x64(:,:,32), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,29), A(:,33), n3(:,415), t3x64(:,:,33), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,33), A(:,34), n3(:,416), t3x64(:,:,34), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,29), A(:,35), n3(:,417), t3x64(:,:,35), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,35), A(:,36), n3(:,418), t3x64(:,:,36), nhel, den(76))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,13), A(:,37), n3(:,419), t3x64(:,:,37), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,37), A(:,38), n3(:,420), t3x64(:,:,38), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,38), A(:,39), n3(:,421), t3x64(:,:,39), nhel, den(83))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,14), A(:,40), n3(:,422), t3x64(:,:,40), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,41), A(:,41), n3(:,423), t3x64(:,:,41), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,42), A(:,42), n3(:,424), t3x64(:,:,42), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,37), A(:,43), n3(:,425), t3x64(:,:,43), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,43), A(:,44), n3(:,426), t3x64(:,:,44), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,44), A(:,45), n3(:,427), t3x64(:,:,45), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,45), A(:,46), n3(:,428), t3x64(:,:,46), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,46), A(:,47), n3(:,429), t3x64(:,:,47), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,36), A(:,48), n3(:,430), t3x64(:,:,48), nhel, den(100))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,15), A(:,49), n3(:,431), t3x64(:,:,49), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,47), A(:,50), n3(:,432), t3x64(:,:,50), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,49), A(:,51), n3(:,433), t3x64(:,:,51), nhel, den(106))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,16), A(:,52), n3(:,434), t3x64(:,:,52), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,51), A(:,53), n3(:,435), t3x64(:,:,53), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,52), A(:,54), n3(:,436), t3x64(:,:,54), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,53), A(:,55), n3(:,437), t3x64(:,:,55), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,49), A(:,56), n3(:,438), t3x64(:,:,56), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,51), A(:,57), n3(:,439), t3x64(:,:,57), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,54), A(:,58), n3(:,440), t3x64(:,:,58), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,51), A(:,59), n3(:,441), t3x64(:,:,59), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,48), A(:,60), n3(:,442), t3x64(:,:,60), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,47), A(:,61), n3(:,443), t3x64(:,:,61), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,43), A(:,62), n3(:,444), t3x64(:,:,62), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,45), A(:,63), n3(:,445), t3x64(:,:,63), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,47), A(:,64), n3(:,446), t3x64(:,:,64), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,53), A(:,65), n3(:,447), t3x64(:,:,65), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,38), A(:,66), n3(:,448), t3x64(:,:,66), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,54), A(:,67), n3(:,449), t3x64(:,:,67), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,38), A(:,68), n3(:,450), t3x64(:,:,68), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,42), A(:,69), n3(:,451), t3x64(:,:,69), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,52), A(:,70), n3(:,452), t3x64(:,:,70), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,52), A(:,71), n3(:,453), t3x64(:,:,71), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,42), A(:,72), n3(:,454), t3x64(:,:,72), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,53), A(:,73), n3(:,455), t3x64(:,:,73), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,43), A(:,74), n3(:,456), t3x64(:,:,74), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,54), A(:,75), n3(:,457), t3x64(:,:,75), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,45), A(:,76), n3(:,458), t3x64(:,:,76), nhel, den(137))

    call Hcont_VV(nsync, wf4(:,2), wf16(:,17), A(:,77), n3(:,459), t3x64(:,:,77), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,18), A(:,78), n3(:,460), t3x64(:,:,78), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,19), A(:,79), n3(:,461), t3x64(:,:,79), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,17), A(:,80), n3(:,462), t3x64(:,:,80), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,18), A(:,81), n3(:,463), t3x64(:,:,81), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,19), A(:,82), n3(:,464), t3x64(:,:,82), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,20), A(:,83), n3(:,465), t3x64(:,:,83), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,21), A(:,84), n3(:,466), t3x64(:,:,84), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,22), A(:,85), n3(:,467), t3x64(:,:,85), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,20), A(:,86), n3(:,468), t3x64(:,:,86), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,21), A(:,87), n3(:,469), t3x64(:,:,87), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,22), A(:,88), n3(:,470), t3x64(:,:,88), nhel, den(6))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,22), A(:,89), n3(:,471), t3x64(:,:,89), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,22), A(:,90), n3(:,472), t3x64(:,:,90), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,22), A(:,91), n3(:,473), t3x64(:,:,91), nhel, den(3))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,23), A(:,92), n3(:,474), t3x64(:,:,92), nhel, den(6))
    call Hcont_VV(nsync, wf16(:,5), wf4(:,23), A(:,93), n3(:,475), t3x64(:,:,93), nhel, den(6))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,23), A(:,94), n3(:,476), t3x64(:,:,94), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,23), A(:,95), n3(:,477), t3x64(:,:,95), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,24), A(:,96), n3(:,478), t3x64(:,:,96), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,4), wf16(:,25), A(:,97), n3(:,479), t3x64(:,:,97), nhel, den(6))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,26), A(:,98), n3(:,480), t3x64(:,:,98), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,27), A(:,99), n3(:,481), t3x64(:,:,99), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,2), wf16(:,28), A(:,100), n3(:,482), t3x64(:,:,100), nhel, den(3))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,29), A(:,101), n3(:,483), t3x64(:,:,101), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,55), A(:,102), n3(:,484), t3x64(:,:,102), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,56), A(:,103), n3(:,485), t3x64(:,:,103), nhel, den(14))
    call Hcont_VV(nsync, wf16(:,30), wf4(:,26), A(:,104), n3(:,486), t3x64(:,:,104), nhel, den(140))
    call Hcont_VV(nsync, wf4(:,26), wf16(:,31), A(:,105), n3(:,487), t3x64(:,:,105), nhel, den(140))
    call Hcont_VV(nsync, wf4(:,26), wf16(:,32), A(:,106), n3(:,488), t3x64(:,:,106), nhel, den(140))
    call Hcont_VV(nsync, wf16(:,1), wf4(:,27), A(:,107), n3(:,489), t3x64(:,:,107), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,2), wf4(:,27), A(:,108), n3(:,490), t3x64(:,:,108), nhel, den(143))
    call Hcont_VV(nsync, wf16(:,3), wf4(:,27), A(:,109), n3(:,491), t3x64(:,:,109), nhel, den(143))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,57), A(:,110), n3(:,492), t3x64(:,:,110), nhel, den(145))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,58), A(:,111), n3(:,493), t3x64(:,:,111), nhel, den(147))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,28), A(:,112), n3(:,494), t3x64(:,:,112), nhel, den(8))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,33), A(:,113), n3(:,495), t3x64(:,:,113), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,59), A(:,114), n3(:,496), t3x64(:,:,114), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,56), A(:,115), n3(:,497), t3x64(:,:,115), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,34), A(:,116), n3(:,498), t3x64(:,:,116), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,60), A(:,117), n3(:,499), t3x64(:,:,117), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,56), A(:,118), n3(:,500), t3x64(:,:,118), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,61), A(:,119), n3(:,501), t3x64(:,:,119), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,58), A(:,120), n3(:,502), t3x64(:,:,120), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,62), A(:,121), n3(:,503), t3x64(:,:,121), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,58), A(:,122), n3(:,504), t3x64(:,:,122), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,63), A(:,123), n3(:,505), t3x64(:,:,123), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,5), wf8(:,65), A(:,124), n3(:,506), t3x64(:,:,124), nhel, den(43))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,66), A(:,125), n3(:,507), t3x64(:,:,125), nhel, den(148))
    call Hcont_QA(nsync, wf8(:,67), wf8(:,68), A(:,126), n3(:,508), t3x64(:,:,126), nhel, den(150))
    call Hcont_QA(nsync, wf16(:,8), wf4(:,30), A(:,127), n3(:,509), t3x64(:,:,127), nhel, den(18))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,69), A(:,128), n3(:,510), t3x64(:,:,128), nhel, den(151))
    call Hcont_QA(nsync, wf8(:,67), wf8(:,70), A(:,129), n3(:,511), t3x64(:,:,129), nhel, den(153))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,71), A(:,130), n3(:,512), t3x64(:,:,130), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,67), A(:,131), n3(:,513), t3x64(:,:,131), nhel, den(43))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,72), A(:,132), n3(:,514), t3x64(:,:,132), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,73), A(:,133), n3(:,515), t3x64(:,:,133), nhel, den(39))
    call Hcont_QA(nsync, wf16(:,9), wf4(:,32), A(:,134), n3(:,516), t3x64(:,:,134), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,74), A(:,135), n3(:,517), t3x64(:,:,135), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,75), A(:,136), n3(:,518), t3x64(:,:,136), nhel, den(32))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,35), A(:,137), n3(:,519), t3x64(:,:,137), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,76), A(:,138), n3(:,520), t3x64(:,:,138), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,77), A(:,139), n3(:,521), t3x64(:,:,139), nhel, den(50))
    call Hcont_VV(nsync, wf16(:,36), wf4(:,33), A(:,140), n3(:,522), t3x64(:,:,140), nhel, den(156))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,37), A(:,141), n3(:,523), t3x64(:,:,141), nhel, den(156))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,38), A(:,142), n3(:,524), t3x64(:,:,142), nhel, den(156))
    call Hcont_VV(nsync, wf16(:,4), wf4(:,34), A(:,143), n3(:,525), t3x64(:,:,143), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,5), wf4(:,34), A(:,144), n3(:,526), t3x64(:,:,144), nhel, den(159))
    call Hcont_VV(nsync, wf16(:,6), wf4(:,34), A(:,145), n3(:,527), t3x64(:,:,145), nhel, den(159))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,78), A(:,146), n3(:,528), t3x64(:,:,146), nhel, den(161))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,79), A(:,147), n3(:,529), t3x64(:,:,147), nhel, den(163))
    call Hcont_VV(nsync, wf16(:,10), wf4(:,28), A(:,148), n3(:,530), t3x64(:,:,148), nhel, den(44))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,39), A(:,149), n3(:,531), t3x64(:,:,149), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,76), A(:,150), n3(:,532), t3x64(:,:,150), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,80), A(:,151), n3(:,533), t3x64(:,:,151), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,40), A(:,152), n3(:,534), t3x64(:,:,152), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,60), A(:,153), n3(:,535), t3x64(:,:,153), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,76), A(:,154), n3(:,536), t3x64(:,:,154), nhel, den(65))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,78), A(:,155), n3(:,537), t3x64(:,:,155), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,81), A(:,156), n3(:,538), t3x64(:,:,156), nhel, den(69))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,62), A(:,157), n3(:,539), t3x64(:,:,157), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,78), A(:,158), n3(:,540), t3x64(:,:,158), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,63), A(:,159), n3(:,541), t3x64(:,:,159), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,25), wf8(:,83), A(:,160), n3(:,542), t3x64(:,:,160), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,85), A(:,161), n3(:,543), t3x64(:,:,161), nhel, den(165))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,86), A(:,162), n3(:,544), t3x64(:,:,162), nhel, den(166))
    call Hcont_QA(nsync, wf16(:,11), wf4(:,30), A(:,163), n3(:,545), t3x64(:,:,163), nhel, den(53))
    call Hcont_QA(nsync, wf8(:,84), wf8(:,87), A(:,164), n3(:,546), t3x64(:,:,164), nhel, den(168))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,88), A(:,165), n3(:,547), t3x64(:,:,165), nhel, den(169))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,71), A(:,166), n3(:,548), t3x64(:,:,166), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,84), A(:,167), n3(:,549), t3x64(:,:,167), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,72), A(:,168), n3(:,550), t3x64(:,:,168), nhel, den(70))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,89), A(:,169), n3(:,551), t3x64(:,:,169), nhel, den(72))
    call Hcont_QA(nsync, wf16(:,12), wf4(:,32), A(:,170), n3(:,552), t3x64(:,:,170), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,74), A(:,171), n3(:,553), t3x64(:,:,171), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,90), A(:,172), n3(:,554), t3x64(:,:,172), nhel, den(65))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,41), A(:,173), n3(:,555), t3x64(:,:,173), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,59), A(:,174), n3(:,556), t3x64(:,:,174), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,77), A(:,175), n3(:,557), t3x64(:,:,175), nhel, den(83))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,42), A(:,176), n3(:,558), t3x64(:,:,176), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,91), A(:,177), n3(:,559), t3x64(:,:,177), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,77), A(:,178), n3(:,560), t3x64(:,:,178), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,61), A(:,179), n3(:,561), t3x64(:,:,179), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,79), A(:,180), n3(:,562), t3x64(:,:,180), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,92), A(:,181), n3(:,563), t3x64(:,:,181), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,79), A(:,182), n3(:,564), t3x64(:,:,182), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,93), A(:,183), n3(:,565), t3x64(:,:,183), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,36), wf8(:,65), A(:,184), n3(:,566), t3x64(:,:,184), nhel, den(100))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,43), A(:,185), n3(:,567), t3x64(:,:,185), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,55), A(:,186), n3(:,568), t3x64(:,:,186), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,80), A(:,187), n3(:,569), t3x64(:,:,187), nhel, den(106))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,44), A(:,188), n3(:,570), t3x64(:,:,188), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,91), A(:,189), n3(:,571), t3x64(:,:,189), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,55), A(:,190), n3(:,572), t3x64(:,:,190), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,57), A(:,191), n3(:,573), t3x64(:,:,191), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,81), A(:,192), n3(:,574), t3x64(:,:,192), nhel, den(116))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,92), A(:,193), n3(:,575), t3x64(:,:,193), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,57), A(:,194), n3(:,576), t3x64(:,:,194), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,93), A(:,195), n3(:,577), t3x64(:,:,195), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,48), wf8(:,83), A(:,196), n3(:,578), t3x64(:,:,196), nhel, den(121))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,69), A(:,197), n3(:,579), t3x64(:,:,197), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,86), A(:,198), n3(:,580), t3x64(:,:,198), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,86), A(:,199), n3(:,581), t3x64(:,:,199), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,73), A(:,200), n3(:,582), t3x64(:,:,200), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,66), A(:,201), n3(:,583), t3x64(:,:,201), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,88), A(:,202), n3(:,584), t3x64(:,:,202), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,66), A(:,203), n3(:,585), t3x64(:,:,203), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,89), A(:,204), n3(:,586), t3x64(:,:,204), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,88), A(:,205), n3(:,587), t3x64(:,:,205), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,69), A(:,206), n3(:,588), t3x64(:,:,206), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,73), A(:,207), n3(:,589), t3x64(:,:,207), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,89), A(:,208), n3(:,590), t3x64(:,:,208), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,75), A(:,209), n3(:,591), t3x64(:,:,209), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,90), A(:,210), n3(:,592), t3x64(:,:,210), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,75), A(:,211), n3(:,593), t3x64(:,:,211), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,90), A(:,212), n3(:,594), t3x64(:,:,212), nhel, den(137))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,94), A(:,213), n3(:,595), t3x64(:,:,213), nhel, den(170))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,95), A(:,214), n3(:,596), t3x64(:,:,214), nhel, den(171))
    call Hcont_QA(nsync, wf16(:,13), wf4(:,36), A(:,215), n3(:,597), t3x64(:,:,215), nhel, den(79))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,96), A(:,216), n3(:,598), t3x64(:,:,216), nhel, den(172))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,95), A(:,217), n3(:,599), t3x64(:,:,217), nhel, den(173))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,97), A(:,218), n3(:,600), t3x64(:,:,218), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,95), A(:,219), n3(:,601), t3x64(:,:,219), nhel, den(100))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,98), A(:,220), n3(:,602), t3x64(:,:,220), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,99), A(:,221), n3(:,603), t3x64(:,:,221), nhel, den(98))
    call Hcont_QA(nsync, wf16(:,14), wf4(:,38), A(:,222), n3(:,604), t3x64(:,:,222), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,100), A(:,223), n3(:,605), t3x64(:,:,223), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,101), A(:,224), n3(:,606), t3x64(:,:,224), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,102), A(:,225), n3(:,607), t3x64(:,:,225), nhel, den(174))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,103), A(:,226), n3(:,608), t3x64(:,:,226), nhel, den(175))
    call Hcont_QA(nsync, wf16(:,15), wf4(:,36), A(:,227), n3(:,609), t3x64(:,:,227), nhel, den(102))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,102), A(:,228), n3(:,610), t3x64(:,:,228), nhel, den(176))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,104), A(:,229), n3(:,611), t3x64(:,:,229), nhel, den(177))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,97), A(:,230), n3(:,612), t3x64(:,:,230), nhel, den(120))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,102), A(:,231), n3(:,613), t3x64(:,:,231), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,98), A(:,232), n3(:,614), t3x64(:,:,232), nhel, den(117))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,105), A(:,233), n3(:,615), t3x64(:,:,233), nhel, den(119))
    call Hcont_QA(nsync, wf16(:,16), wf4(:,38), A(:,234), n3(:,616), t3x64(:,:,234), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,100), A(:,235), n3(:,617), t3x64(:,:,235), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,106), A(:,236), n3(:,618), t3x64(:,:,236), nhel, den(112))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,96), A(:,237), n3(:,619), t3x64(:,:,237), nhel, den(178))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,103), A(:,238), n3(:,620), t3x64(:,:,238), nhel, den(179))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,103), A(:,239), n3(:,621), t3x64(:,:,239), nhel, den(125))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,99), A(:,240), n3(:,622), t3x64(:,:,240), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,94), A(:,241), n3(:,623), t3x64(:,:,241), nhel, den(180))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,104), A(:,242), n3(:,624), t3x64(:,:,242), nhel, den(181))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,94), A(:,243), n3(:,625), t3x64(:,:,243), nhel, den(129))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,105), A(:,244), n3(:,626), t3x64(:,:,244), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,104), A(:,245), n3(:,627), t3x64(:,:,245), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,96), A(:,246), n3(:,628), t3x64(:,:,246), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,99), A(:,247), n3(:,629), t3x64(:,:,247), nhel, den(137))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,105), A(:,248), n3(:,630), t3x64(:,:,248), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,101), A(:,249), n3(:,631), t3x64(:,:,249), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,106), A(:,250), n3(:,632), t3x64(:,:,250), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,101), A(:,251), n3(:,633), t3x64(:,:,251), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,106), A(:,252), n3(:,634), t3x64(:,:,252), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,107), A(:,253), n3(:,635), t3x64(:,:,253), nhel, den(182))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,109), A(:,254), n3(:,636), t3x64(:,:,254), nhel, den(185))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,45), A(:,255), n3(:,637), t3x64(:,:,255), nhel, den(27))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,110), A(:,256), n3(:,638), t3x64(:,:,256), nhel, den(186))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,111), A(:,257), n3(:,639), t3x64(:,:,257), nhel, den(188))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,112), A(:,258), n3(:,640), t3x64(:,:,258), nhel, den(189))
    call Hcont_QA(nsync, wf8(:,108), wf8(:,113), A(:,259), n3(:,641), t3x64(:,:,259), nhel, den(191))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,114), A(:,260), n3(:,642), t3x64(:,:,260), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,115), A(:,261), n3(:,643), t3x64(:,:,261), nhel, den(36))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,46), A(:,262), n3(:,644), t3x64(:,:,262), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,116), A(:,263), n3(:,645), t3x64(:,:,263), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,117), A(:,264), n3(:,646), t3x64(:,:,264), nhel, den(23))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,47), A(:,265), n3(:,647), t3x64(:,:,265), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,118), A(:,266), n3(:,648), t3x64(:,:,266), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,119), A(:,267), n3(:,649), t3x64(:,:,267), nhel, den(14))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,120), A(:,268), n3(:,650), t3x64(:,:,268), nhel, den(192))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,122), A(:,269), n3(:,651), t3x64(:,:,269), nhel, den(195))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,48), A(:,270), n3(:,652), t3x64(:,:,270), nhel, den(86))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,123), A(:,271), n3(:,653), t3x64(:,:,271), nhel, den(196))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,124), A(:,272), n3(:,654), t3x64(:,:,272), nhel, den(198))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,112), A(:,273), n3(:,655), t3x64(:,:,273), nhel, den(199))
    call Hcont_QA(nsync, wf8(:,121), wf8(:,125), A(:,274), n3(:,656), t3x64(:,:,274), nhel, den(201))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,114), A(:,275), n3(:,657), t3x64(:,:,275), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,126), A(:,276), n3(:,658), t3x64(:,:,276), nhel, den(95))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,49), A(:,277), n3(:,659), t3x64(:,:,277), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,116), A(:,278), n3(:,660), t3x64(:,:,278), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,127), A(:,279), n3(:,661), t3x64(:,:,279), nhel, den(83))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,123), A(:,280), n3(:,662), t3x64(:,:,280), nhel, den(202))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,110), A(:,281), n3(:,663), t3x64(:,:,281), nhel, den(203))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,115), A(:,282), n3(:,664), t3x64(:,:,282), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,126), A(:,283), n3(:,665), t3x64(:,:,283), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,120), A(:,284), n3(:,666), t3x64(:,:,284), nhel, den(204))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,110), A(:,285), n3(:,667), t3x64(:,:,285), nhel, den(132))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,120), A(:,286), n3(:,668), t3x64(:,:,286), nhel, den(133))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,115), A(:,287), n3(:,669), t3x64(:,:,287), nhel, den(131))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,107), A(:,288), n3(:,670), t3x64(:,:,288), nhel, den(205))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,107), A(:,289), n3(:,671), t3x64(:,:,289), nhel, den(136))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,123), A(:,290), n3(:,672), t3x64(:,:,290), nhel, den(137))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,126), A(:,291), n3(:,673), t3x64(:,:,291), nhel, den(135))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,117), A(:,292), n3(:,674), t3x64(:,:,292), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,127), A(:,293), n3(:,675), t3x64(:,:,293), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,117), A(:,294), n3(:,676), t3x64(:,:,294), nhel, den(128))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,127), A(:,295), n3(:,677), t3x64(:,:,295), nhel, den(129))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,50), A(:,296), n3(:,678), t3x64(:,:,296), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,118), A(:,297), n3(:,679), t3x64(:,:,297), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,129), A(:,298), n3(:,680), t3x64(:,:,298), nhel, den(106))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,51), A(:,299), n3(:,681), t3x64(:,:,299), nhel, den(108))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,118), A(:,300), n3(:,682), t3x64(:,:,300), nhel, den(112))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,131), A(:,301), n3(:,683), t3x64(:,:,301), nhel, den(110))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,119), A(:,302), n3(:,684), t3x64(:,:,302), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,129), A(:,303), n3(:,685), t3x64(:,:,303), nhel, den(116))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,119), A(:,304), n3(:,686), t3x64(:,:,304), nhel, den(119))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,131), A(:,305), n3(:,687), t3x64(:,:,305), nhel, den(117))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,128), A(:,306), n3(:,688), t3x64(:,:,306), nhel, den(121))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,131), A(:,307), n3(:,689), t3x64(:,:,307), nhel, den(120))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,52), A(:,308), n3(:,690), t3x64(:,:,308), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,132), A(:,309), n3(:,691), t3x64(:,:,309), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,133), A(:,310), n3(:,692), t3x64(:,:,310), nhel, den(50))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,53), A(:,311), n3(:,693), t3x64(:,:,311), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,132), A(:,312), n3(:,694), t3x64(:,:,312), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,26), wf8(:,135), A(:,313), n3(:,695), t3x64(:,:,313), nhel, den(58))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,54), A(:,314), n3(:,696), t3x64(:,:,314), nhel, den(61))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,132), A(:,315), n3(:,697), t3x64(:,:,315), nhel, den(65))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,137), A(:,316), n3(:,698), t3x64(:,:,316), nhel, den(63))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,133), A(:,317), n3(:,699), t3x64(:,:,317), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,32), wf8(:,135), A(:,318), n3(:,700), t3x64(:,:,318), nhel, den(69))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,133), A(:,319), n3(:,701), t3x64(:,:,319), nhel, den(72))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,137), A(:,320), n3(:,702), t3x64(:,:,320), nhel, den(70))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,134), A(:,321), n3(:,703), t3x64(:,:,321), nhel, den(76))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,137), A(:,322), n3(:,704), t3x64(:,:,322), nhel, den(73))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,138), A(:,323), n3(:,705), t3x64(:,:,323), nhel, den(206))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,139), A(:,324), n3(:,706), t3x64(:,:,324), nhel, den(207))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,55), A(:,325), n3(:,707), t3x64(:,:,325), nhel, den(61))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,138), A(:,326), n3(:,708), t3x64(:,:,326), nhel, den(208))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,140), A(:,327), n3(:,709), t3x64(:,:,327), nhel, den(209))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,138), A(:,328), n3(:,710), t3x64(:,:,328), nhel, den(210))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,141), A(:,329), n3(:,711), t3x64(:,:,329), nhel, den(211))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,142), A(:,330), n3(:,712), t3x64(:,:,330), nhel, den(68))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,143), A(:,331), n3(:,713), t3x64(:,:,331), nhel, den(69))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,56), A(:,332), n3(:,714), t3x64(:,:,332), nhel, den(53))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,144), A(:,333), n3(:,715), t3x64(:,:,333), nhel, den(55))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,145), A(:,334), n3(:,716), t3x64(:,:,334), nhel, den(58))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,57), A(:,335), n3(:,717), t3x64(:,:,335), nhel, den(44))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,146), A(:,336), n3(:,718), t3x64(:,:,336), nhel, den(47))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,147), A(:,337), n3(:,719), t3x64(:,:,337), nhel, den(50))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,148), A(:,338), n3(:,720), t3x64(:,:,338), nhel, den(212))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,149), A(:,339), n3(:,721), t3x64(:,:,339), nhel, den(213))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,58), A(:,340), n3(:,722), t3x64(:,:,340), nhel, den(108))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,148), A(:,341), n3(:,723), t3x64(:,:,341), nhel, den(214))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,150), A(:,342), n3(:,724), t3x64(:,:,342), nhel, den(215))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,148), A(:,343), n3(:,725), t3x64(:,:,343), nhel, den(216))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,141), A(:,344), n3(:,726), t3x64(:,:,344), nhel, den(217))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,151), A(:,345), n3(:,727), t3x64(:,:,345), nhel, den(115))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,143), A(:,346), n3(:,728), t3x64(:,:,346), nhel, den(116))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,59), A(:,347), n3(:,729), t3x64(:,:,347), nhel, den(102))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,152), A(:,348), n3(:,730), t3x64(:,:,348), nhel, den(104))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,145), A(:,349), n3(:,731), t3x64(:,:,349), nhel, den(106))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,150), A(:,350), n3(:,732), t3x64(:,:,350), nhel, den(218))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,140), A(:,351), n3(:,733), t3x64(:,:,351), nhel, den(219))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,151), A(:,352), n3(:,734), t3x64(:,:,352), nhel, den(126))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,142), A(:,353), n3(:,735), t3x64(:,:,353), nhel, den(127))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,149), A(:,354), n3(:,736), t3x64(:,:,354), nhel, den(220))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,149), A(:,355), n3(:,737), t3x64(:,:,355), nhel, den(221))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,140), A(:,356), n3(:,738), t3x64(:,:,356), nhel, den(222))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,142), A(:,357), n3(:,739), t3x64(:,:,357), nhel, den(130))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,139), A(:,358), n3(:,740), t3x64(:,:,358), nhel, den(223))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,150), A(:,359), n3(:,741), t3x64(:,:,359), nhel, den(224))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,139), A(:,360), n3(:,742), t3x64(:,:,360), nhel, den(225))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,151), A(:,361), n3(:,743), t3x64(:,:,361), nhel, den(134))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,152), A(:,362), n3(:,744), t3x64(:,:,362), nhel, den(122))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,144), A(:,363), n3(:,745), t3x64(:,:,363), nhel, den(123))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,144), A(:,364), n3(:,746), t3x64(:,:,364), nhel, den(124))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,152), A(:,365), n3(:,747), t3x64(:,:,365), nhel, den(125))
    call Hcont_QA(nsync, wf4(:,19), wf16(:,60), A(:,366), n3(:,748), t3x64(:,:,366), nhel, den(79))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,154), A(:,367), n3(:,749), t3x64(:,:,367), nhel, den(81))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,147), A(:,368), n3(:,750), t3x64(:,:,368), nhel, den(83))
    call Hcont_QA(nsync, wf4(:,21), wf16(:,61), A(:,369), n3(:,751), t3x64(:,:,369), nhel, den(86))
    call Hcont_QA(nsync, wf8(:,40), wf8(:,156), A(:,370), n3(:,752), t3x64(:,:,370), nhel, den(89))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,147), A(:,371), n3(:,753), t3x64(:,:,371), nhel, den(91))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,154), A(:,372), n3(:,754), t3x64(:,:,372), nhel, den(92))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,146), A(:,373), n3(:,755), t3x64(:,:,373), nhel, den(95))
    call Hcont_QA(nsync, wf8(:,44), wf8(:,156), A(:,374), n3(:,756), t3x64(:,:,374), nhel, den(96))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,146), A(:,375), n3(:,757), t3x64(:,:,375), nhel, den(98))
    call Hcont_QA(nsync, wf8(:,46), wf8(:,156), A(:,376), n3(:,758), t3x64(:,:,376), nhel, den(99))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,153), A(:,377), n3(:,759), t3x64(:,:,377), nhel, den(100))
    call Hcont_VV(nsync, wf4(:,5), wf16(:,62), A(:,378), n3(:,760), t3x64(:,:,378), nhel, den(8))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,157), A(:,379), n3(:,761), t3x64(:,:,379), nhel, den(11))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,158), A(:,380), n3(:,762), t3x64(:,:,380), nhel, den(14))
    call Hcont_QA(nsync, wf4(:,9), wf16(:,63), A(:,381), n3(:,763), t3x64(:,:,381), nhel, den(18))
    call Hcont_QA(nsync, wf8(:,6), wf8(:,160), A(:,382), n3(:,764), t3x64(:,:,382), nhel, den(21))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,158), A(:,383), n3(:,765), t3x64(:,:,383), nhel, den(23))
    call Hcont_QA(nsync, wf4(:,13), wf16(:,64), A(:,384), n3(:,766), t3x64(:,:,384), nhel, den(27))
    call Hcont_QA(nsync, wf8(:,10), wf8(:,162), A(:,385), n3(:,767), t3x64(:,:,385), nhel, den(30))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,158), A(:,386), n3(:,768), t3x64(:,:,386), nhel, den(32))
    call Hcont_QA(nsync, wf8(:,13), wf8(:,160), A(:,387), n3(:,769), t3x64(:,:,387), nhel, den(33))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,157), A(:,388), n3(:,770), t3x64(:,:,388), nhel, den(36))
    call Hcont_QA(nsync, wf8(:,15), wf8(:,162), A(:,389), n3(:,771), t3x64(:,:,389), nhel, den(37))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,157), A(:,390), n3(:,772), t3x64(:,:,390), nhel, den(39))
    call Hcont_QA(nsync, wf8(:,17), wf8(:,162), A(:,391), n3(:,773), t3x64(:,:,391), nhel, den(40))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,159), A(:,392), n3(:,774), t3x64(:,:,392), nhel, den(43))
    call Hcont_VV(nsync, wf4(:,26), wf16(:,65), A(:,393), n3(:,775), t3x64(:,:,393), nhel, den(228))
    call Hcont_VV(nsync, wf4(:,27), wf16(:,66), A(:,394), n3(:,776), t3x64(:,:,394), nhel, den(231))
    call Hcont_VV(nsync, wf16(:,7), wf4(:,47), A(:,395), n3(:,777), t3x64(:,:,395), nhel, den(234))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,163), A(:,396), n3(:,778), t3x64(:,:,396), nhel, den(236))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,164), A(:,397), n3(:,779), t3x64(:,:,397), nhel, den(237))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,165), A(:,398), n3(:,780), t3x64(:,:,398), nhel, den(239))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,166), A(:,399), n3(:,781), t3x64(:,:,399), nhel, den(240))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,167), A(:,400), n3(:,782), t3x64(:,:,400), nhel, den(241))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,168), A(:,401), n3(:,783), t3x64(:,:,401), nhel, den(242))
    call Hcont_VV(nsync, wf4(:,26), wf16(:,67), A(:,402), n3(:,784), t3x64(:,:,402), nhel, den(245))
    call Hcont_QA(nsync, wf4(:,48), wf16(:,69), A(:,403), n3(:,785), t3x64(:,:,403), nhel, den(249))
    call Hcont_QA(nsync, wf4(:,49), wf16(:,70), A(:,404), n3(:,786), t3x64(:,:,404), nhel, den(252))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,169), A(:,405), n3(:,787), t3x64(:,:,405), nhel, den(253))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,164), A(:,406), n3(:,788), t3x64(:,:,406), nhel, den(254))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,170), A(:,407), n3(:,789), t3x64(:,:,407), nhel, den(256))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,171), A(:,408), n3(:,790), t3x64(:,:,408), nhel, den(257))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,172), A(:,409), n3(:,791), t3x64(:,:,409), nhel, den(258))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,173), A(:,410), n3(:,792), t3x64(:,:,410), nhel, den(259))
    call Hcont_VV(nsync, wf4(:,26), wf16(:,71), A(:,411), n3(:,793), t3x64(:,:,411), nhel, den(262))
    call Hcont_QA(nsync, wf4(:,51), wf16(:,73), A(:,412), n3(:,794), t3x64(:,:,412), nhel, den(266))
    call Hcont_QA(nsync, wf4(:,52), wf16(:,74), A(:,413), n3(:,795), t3x64(:,:,413), nhel, den(269))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,174), A(:,414), n3(:,796), t3x64(:,:,414), nhel, den(270))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,164), A(:,415), n3(:,797), t3x64(:,:,415), nhel, den(271))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,175), A(:,416), n3(:,798), t3x64(:,:,416), nhel, den(273))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,176), A(:,417), n3(:,799), t3x64(:,:,417), nhel, den(274))
    call Hcont_VV(nsync, wf8(:,4), wf8(:,177), A(:,418), n3(:,800), t3x64(:,:,418), nhel, den(275))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,178), A(:,419), n3(:,801), t3x64(:,:,419), nhel, den(276))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,169), A(:,420), n3(:,802), t3x64(:,:,420), nhel, den(277))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,163), A(:,421), n3(:,803), t3x64(:,:,421), nhel, den(278))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,179), A(:,422), n3(:,804), t3x64(:,:,422), nhel, den(280))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,180), A(:,423), n3(:,805), t3x64(:,:,423), nhel, den(281))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,172), A(:,424), n3(:,806), t3x64(:,:,424), nhel, den(282))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,181), A(:,425), n3(:,807), t3x64(:,:,425), nhel, den(283))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,174), A(:,426), n3(:,808), t3x64(:,:,426), nhel, den(284))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,163), A(:,427), n3(:,809), t3x64(:,:,427), nhel, den(285))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,182), A(:,428), n3(:,810), t3x64(:,:,428), nhel, den(287))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,176), A(:,429), n3(:,811), t3x64(:,:,429), nhel, den(288))
    call Hcont_VV(nsync, wf8(:,1), wf8(:,183), A(:,430), n3(:,812), t3x64(:,:,430), nhel, den(289))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,184), A(:,431), n3(:,813), t3x64(:,:,431), nhel, den(290))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,174), A(:,432), n3(:,814), t3x64(:,:,432), nhel, den(291))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,169), A(:,433), n3(:,815), t3x64(:,:,433), nhel, den(292))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,176), A(:,434), n3(:,816), t3x64(:,:,434), nhel, den(293))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,185), A(:,435), n3(:,817), t3x64(:,:,435), nhel, den(294))
    call Hcont_QA(nsync, wf8(:,7), wf8(:,186), A(:,436), n3(:,818), t3x64(:,:,436), nhel, den(296))
    call Hcont_QA(nsync, wf8(:,11), wf8(:,187), A(:,437), n3(:,819), t3x64(:,:,437), nhel, den(297))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,75), A(:,438), n3(:,820), t3x64(:,:,438), nhel, den(300))
    call Hcont_VV(nsync, wf4(:,34), wf16(:,76), A(:,439), n3(:,821), t3x64(:,:,439), nhel, den(303))
    call Hcont_VV(nsync, wf16(:,10), wf4(:,47), A(:,440), n3(:,822), t3x64(:,:,440), nhel, den(305))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,188), A(:,441), n3(:,823), t3x64(:,:,441), nhel, den(307))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,189), A(:,442), n3(:,824), t3x64(:,:,442), nhel, den(308))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,190), A(:,443), n3(:,825), t3x64(:,:,443), nhel, den(310))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,191), A(:,444), n3(:,826), t3x64(:,:,444), nhel, den(311))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,192), A(:,445), n3(:,827), t3x64(:,:,445), nhel, den(312))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,193), A(:,446), n3(:,828), t3x64(:,:,446), nhel, den(313))
    call Hcont_QA(nsync, wf4(:,56), wf16(:,78), A(:,447), n3(:,829), t3x64(:,:,447), nhel, den(317))
    call Hcont_VV(nsync, wf4(:,34), wf16(:,79), A(:,448), n3(:,830), t3x64(:,:,448), nhel, den(320))
    call Hcont_QA(nsync, wf4(:,49), wf16(:,80), A(:,449), n3(:,831), t3x64(:,:,449), nhel, den(322))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,194), A(:,450), n3(:,832), t3x64(:,:,450), nhel, den(324))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,195), A(:,451), n3(:,833), t3x64(:,:,451), nhel, den(325))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,196), A(:,452), n3(:,834), t3x64(:,:,452), nhel, den(326))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,191), A(:,453), n3(:,835), t3x64(:,:,453), nhel, den(327))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,197), A(:,454), n3(:,836), t3x64(:,:,454), nhel, den(328))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,198), A(:,455), n3(:,837), t3x64(:,:,455), nhel, den(329))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,82), A(:,456), n3(:,838), t3x64(:,:,456), nhel, den(333))
    call Hcont_VV(nsync, wf4(:,34), wf16(:,83), A(:,457), n3(:,839), t3x64(:,:,457), nhel, den(336))
    call Hcont_QA(nsync, wf4(:,52), wf16(:,84), A(:,458), n3(:,840), t3x64(:,:,458), nhel, den(338))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,199), A(:,459), n3(:,841), t3x64(:,:,459), nhel, den(339))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,200), A(:,460), n3(:,842), t3x64(:,:,460), nhel, den(340))
    call Hcont_QA(nsync, wf8(:,109), wf8(:,201), A(:,461), n3(:,843), t3x64(:,:,461), nhel, den(341))
    call Hcont_VV(nsync, wf8(:,21), wf8(:,202), A(:,462), n3(:,844), t3x64(:,:,462), nhel, den(342))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,191), A(:,463), n3(:,845), t3x64(:,:,463), nhel, den(343))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,178), A(:,464), n3(:,846), t3x64(:,:,464), nhel, den(344))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,203), A(:,465), n3(:,847), t3x64(:,:,465), nhel, den(346))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,204), A(:,466), n3(:,848), t3x64(:,:,466), nhel, den(347))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,196), A(:,467), n3(:,849), t3x64(:,:,467), nhel, den(348))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,190), A(:,468), n3(:,850), t3x64(:,:,468), nhel, den(349))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,205), A(:,469), n3(:,851), t3x64(:,:,469), nhel, den(350))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,198), A(:,470), n3(:,852), t3x64(:,:,470), nhel, den(351))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,199), A(:,471), n3(:,853), t3x64(:,:,471), nhel, den(352))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,206), A(:,472), n3(:,854), t3x64(:,:,472), nhel, den(353))
    call Hcont_QA(nsync, wf8(:,111), wf8(:,201), A(:,473), n3(:,855), t3x64(:,:,473), nhel, den(354))
    call Hcont_VV(nsync, wf8(:,22), wf8(:,207), A(:,474), n3(:,856), t3x64(:,:,474), nhel, den(355))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,190), A(:,475), n3(:,857), t3x64(:,:,475), nhel, den(356))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,184), A(:,476), n3(:,858), t3x64(:,:,476), nhel, den(357))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,199), A(:,477), n3(:,859), t3x64(:,:,477), nhel, den(358))
    call Hcont_QA(nsync, wf8(:,113), wf8(:,201), A(:,478), n3(:,860), t3x64(:,:,478), nhel, den(359))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,208), A(:,479), n3(:,861), t3x64(:,:,479), nhel, den(360))
    call Hcont_QA(nsync, wf8(:,27), wf8(:,209), A(:,480), n3(:,862), t3x64(:,:,480), nhel, den(361))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,196), A(:,481), n3(:,863), t3x64(:,:,481), nhel, den(362))
    call Hcont_QA(nsync, wf8(:,29), wf8(:,187), A(:,482), n3(:,864), t3x64(:,:,482), nhel, den(363))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,85), A(:,483), n3(:,865), t3x64(:,:,483), nhel, den(366))
    call Hcont_QA(nsync, wf4(:,48), wf16(:,87), A(:,484), n3(:,866), t3x64(:,:,484), nhel, den(369))
    call Hcont_QA(nsync, wf4(:,60), wf16(:,88), A(:,485), n3(:,867), t3x64(:,:,485), nhel, den(372))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,210), A(:,486), n3(:,868), t3x64(:,:,486), nhel, den(373))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,189), A(:,487), n3(:,869), t3x64(:,:,487), nhel, den(374))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,211), A(:,488), n3(:,870), t3x64(:,:,488), nhel, den(375))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,171), A(:,489), n3(:,871), t3x64(:,:,489), nhel, den(376))
    call Hcont_QA(nsync, wf8(:,68), wf8(:,212), A(:,490), n3(:,872), t3x64(:,:,490), nhel, den(377))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,213), A(:,491), n3(:,873), t3x64(:,:,491), nhel, den(378))
    call Hcont_VV(nsync, wf4(:,33), wf16(:,89), A(:,492), n3(:,874), t3x64(:,:,492), nhel, den(381))
    call Hcont_QA(nsync, wf4(:,51), wf16(:,91), A(:,493), n3(:,875), t3x64(:,:,493), nhel, den(384))
    call Hcont_QA(nsync, wf4(:,61), wf16(:,92), A(:,494), n3(:,876), t3x64(:,:,494), nhel, den(387))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,214), A(:,495), n3(:,877), t3x64(:,:,495), nhel, den(388))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,189), A(:,496), n3(:,878), t3x64(:,:,496), nhel, den(389))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,215), A(:,497), n3(:,879), t3x64(:,:,497), nhel, den(391))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,216), A(:,498), n3(:,880), t3x64(:,:,498), nhel, den(392))
    call Hcont_VV(nsync, wf8(:,23), wf8(:,217), A(:,499), n3(:,881), t3x64(:,:,499), nhel, den(393))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,218), A(:,500), n3(:,882), t3x64(:,:,500), nhel, den(394))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,210), A(:,501), n3(:,883), t3x64(:,:,501), nhel, den(395))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,188), A(:,502), n3(:,884), t3x64(:,:,502), nhel, den(396))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,219), A(:,503), n3(:,885), t3x64(:,:,503), nhel, den(397))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,180), A(:,504), n3(:,886), t3x64(:,:,504), nhel, den(398))
    call Hcont_QA(nsync, wf8(:,70), wf8(:,212), A(:,505), n3(:,887), t3x64(:,:,505), nhel, den(399))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,220), A(:,506), n3(:,888), t3x64(:,:,506), nhel, den(400))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,214), A(:,507), n3(:,889), t3x64(:,:,507), nhel, den(401))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,188), A(:,508), n3(:,890), t3x64(:,:,508), nhel, den(402))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,221), A(:,509), n3(:,891), t3x64(:,:,509), nhel, den(404))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,216), A(:,510), n3(:,892), t3x64(:,:,510), nhel, den(405))
    call Hcont_VV(nsync, wf8(:,20), wf8(:,222), A(:,511), n3(:,893), t3x64(:,:,511), nhel, den(406))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,223), A(:,512), n3(:,894), t3x64(:,:,512), nhel, den(407))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,214), A(:,513), n3(:,895), t3x64(:,:,513), nhel, den(408))
    call Hcont_QA(nsync, wf8(:,19), wf8(:,210), A(:,514), n3(:,896), t3x64(:,:,514), nhel, den(409))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,216), A(:,515), n3(:,897), t3x64(:,:,515), nhel, den(410))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,185), A(:,516), n3(:,898), t3x64(:,:,516), nhel, den(411))
    call Hcont_QA(nsync, wf8(:,37), wf8(:,186), A(:,517), n3(:,899), t3x64(:,:,517), nhel, den(412))
    call Hcont_QA(nsync, wf8(:,41), wf8(:,224), A(:,518), n3(:,900), t3x64(:,:,518), nhel, den(413))
    call Hcont_QA(nsync, wf4(:,56), wf16(:,94), A(:,519), n3(:,901), t3x64(:,:,519), nhel, den(416))
    call Hcont_VV(nsync, wf4(:,27), wf16(:,95), A(:,520), n3(:,902), t3x64(:,:,520), nhel, den(419))
    call Hcont_QA(nsync, wf4(:,60), wf16(:,96), A(:,521), n3(:,903), t3x64(:,:,521), nhel, den(421))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,225), A(:,522), n3(:,904), t3x64(:,:,522), nhel, den(422))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,195), A(:,523), n3(:,905), t3x64(:,:,523), nhel, den(423))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,226), A(:,524), n3(:,906), t3x64(:,:,524), nhel, den(424))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,166), A(:,525), n3(:,907), t3x64(:,:,525), nhel, den(425))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,227), A(:,526), n3(:,908), t3x64(:,:,526), nhel, den(426))
    call Hcont_QA(nsync, wf8(:,85), wf8(:,228), A(:,527), n3(:,909), t3x64(:,:,527), nhel, den(427))
    call Hcont_QA(nsync, wf4(:,58), wf16(:,98), A(:,528), n3(:,910), t3x64(:,:,528), nhel, den(430))
    call Hcont_VV(nsync, wf4(:,27), wf16(:,99), A(:,529), n3(:,911), t3x64(:,:,529), nhel, den(433))
    call Hcont_QA(nsync, wf4(:,61), wf16(:,100), A(:,530), n3(:,912), t3x64(:,:,530), nhel, den(435))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,229), A(:,531), n3(:,913), t3x64(:,:,531), nhel, den(436))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,230), A(:,532), n3(:,914), t3x64(:,:,532), nhel, den(437))
    call Hcont_QA(nsync, wf8(:,122), wf8(:,231), A(:,533), n3(:,915), t3x64(:,:,533), nhel, den(438))
    call Hcont_VV(nsync, wf8(:,2), wf8(:,232), A(:,534), n3(:,916), t3x64(:,:,534), nhel, den(439))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,166), A(:,535), n3(:,917), t3x64(:,:,535), nhel, den(440))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,218), A(:,536), n3(:,918), t3x64(:,:,536), nhel, den(441))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,233), A(:,537), n3(:,919), t3x64(:,:,537), nhel, den(442))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,204), A(:,538), n3(:,920), t3x64(:,:,538), nhel, den(443))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,226), A(:,539), n3(:,921), t3x64(:,:,539), nhel, den(444))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,165), A(:,540), n3(:,922), t3x64(:,:,540), nhel, den(445))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,234), A(:,541), n3(:,923), t3x64(:,:,541), nhel, den(446))
    call Hcont_QA(nsync, wf8(:,87), wf8(:,228), A(:,542), n3(:,924), t3x64(:,:,542), nhel, den(447))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,229), A(:,543), n3(:,925), t3x64(:,:,543), nhel, den(448))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,235), A(:,544), n3(:,926), t3x64(:,:,544), nhel, den(449))
    call Hcont_QA(nsync, wf8(:,124), wf8(:,231), A(:,545), n3(:,927), t3x64(:,:,545), nhel, den(450))
    call Hcont_VV(nsync, wf8(:,3), wf8(:,236), A(:,546), n3(:,928), t3x64(:,:,546), nhel, den(451))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,165), A(:,547), n3(:,929), t3x64(:,:,547), nhel, den(452))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,223), A(:,548), n3(:,930), t3x64(:,:,548), nhel, den(453))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,229), A(:,549), n3(:,931), t3x64(:,:,549), nhel, den(454))
    call Hcont_QA(nsync, wf8(:,125), wf8(:,231), A(:,550), n3(:,932), t3x64(:,:,550), nhel, den(455))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,208), A(:,551), n3(:,933), t3x64(:,:,551), nhel, den(456))
    call Hcont_QA(nsync, wf8(:,49), wf8(:,209), A(:,552), n3(:,934), t3x64(:,:,552), nhel, den(457))
    call Hcont_QA(nsync, wf8(:,35), wf8(:,226), A(:,553), n3(:,935), t3x64(:,:,553), nhel, den(458))
    call Hcont_QA(nsync, wf8(:,51), wf8(:,224), A(:,554), n3(:,936), t3x64(:,:,554), nhel, den(459))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,225), A(:,555), n3(:,937), t3x64(:,:,555), nhel, den(460))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,194), A(:,556), n3(:,938), t3x64(:,:,556), nhel, den(461))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,219), A(:,557), n3(:,939), t3x64(:,:,557), nhel, den(462))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,179), A(:,558), n3(:,940), t3x64(:,:,558), nhel, den(463))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,227), A(:,559), n3(:,941), t3x64(:,:,559), nhel, den(464))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,220), A(:,560), n3(:,942), t3x64(:,:,560), nhel, den(465))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,194), A(:,561), n3(:,943), t3x64(:,:,561), nhel, den(466))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,221), A(:,562), n3(:,944), t3x64(:,:,562), nhel, den(467))
    call Hcont_VV(nsync, wf8(:,24), wf8(:,222), A(:,563), n3(:,945), t3x64(:,:,563), nhel, den(468))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,225), A(:,564), n3(:,946), t3x64(:,:,564), nhel, den(469))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,183), A(:,565), n3(:,947), t3x64(:,:,565), nhel, den(470))
    call Hcont_VV(nsync, wf8(:,47), wf8(:,182), A(:,566), n3(:,948), t3x64(:,:,566), nhel, den(471))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,233), A(:,567), n3(:,949), t3x64(:,:,567), nhel, den(472))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,203), A(:,568), n3(:,950), t3x64(:,:,568), nhel, den(473))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,211), A(:,569), n3(:,951), t3x64(:,:,569), nhel, den(474))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,170), A(:,570), n3(:,952), t3x64(:,:,570), nhel, den(475))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,234), A(:,571), n3(:,953), t3x64(:,:,571), nhel, den(476))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,213), A(:,572), n3(:,954), t3x64(:,:,572), nhel, den(477))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,235), A(:,573), n3(:,955), t3x64(:,:,573), nhel, den(478))
    call Hcont_VV(nsync, wf8(:,8), wf8(:,236), A(:,574), n3(:,956), t3x64(:,:,574), nhel, den(479))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,170), A(:,575), n3(:,957), t3x64(:,:,575), nhel, den(480))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,207), A(:,576), n3(:,958), t3x64(:,:,576), nhel, den(481))
    call Hcont_VV(nsync, wf8(:,38), wf8(:,206), A(:,577), n3(:,959), t3x64(:,:,577), nhel, den(482))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,211), A(:,578), n3(:,960), t3x64(:,:,578), nhel, den(483))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,203), A(:,579), n3(:,961), t3x64(:,:,579), nhel, den(484))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,215), A(:,580), n3(:,962), t3x64(:,:,580), nhel, den(485))
    call Hcont_VV(nsync, wf8(:,31), wf8(:,217), A(:,581), n3(:,963), t3x64(:,:,581), nhel, den(486))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,230), A(:,582), n3(:,964), t3x64(:,:,582), nhel, den(487))
    call Hcont_VV(nsync, wf8(:,14), wf8(:,232), A(:,583), n3(:,965), t3x64(:,:,583), nhel, den(488))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,179), A(:,584), n3(:,966), t3x64(:,:,584), nhel, den(489))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,232), A(:,585), n3(:,967), t3x64(:,:,585), nhel, den(490))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,207), A(:,586), n3(:,968), t3x64(:,:,586), nhel, den(491))
    call Hcont_VV(nsync, wf8(:,16), wf8(:,230), A(:,587), n3(:,969), t3x64(:,:,587), nhel, den(492))
    call Hcont_VV(nsync, wf8(:,42), wf8(:,206), A(:,588), n3(:,970), t3x64(:,:,588), nhel, den(493))
    call Hcont_VV(nsync, wf8(:,33), wf8(:,215), A(:,589), n3(:,971), t3x64(:,:,589), nhel, den(494))
    call Hcont_VV(nsync, wf8(:,52), wf8(:,182), A(:,590), n3(:,972), t3x64(:,:,590), nhel, den(495))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,233), A(:,591), n3(:,973), t3x64(:,:,591), nhel, den(496))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,177), A(:,592), n3(:,974), t3x64(:,:,592), nhel, den(497))
    call Hcont_VV(nsync, wf8(:,53), wf8(:,175), A(:,593), n3(:,975), t3x64(:,:,593), nhel, den(498))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,202), A(:,594), n3(:,976), t3x64(:,:,594), nhel, den(499))
    call Hcont_VV(nsync, wf8(:,43), wf8(:,200), A(:,595), n3(:,977), t3x64(:,:,595), nhel, den(500))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,219), A(:,596), n3(:,978), t3x64(:,:,596), nhel, den(501))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,236), A(:,597), n3(:,979), t3x64(:,:,597), nhel, den(502))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,202), A(:,598), n3(:,980), t3x64(:,:,598), nhel, den(503))
    call Hcont_VV(nsync, wf8(:,12), wf8(:,235), A(:,599), n3(:,981), t3x64(:,:,599), nhel, den(504))
    call Hcont_VV(nsync, wf8(:,45), wf8(:,200), A(:,600), n3(:,982), t3x64(:,:,600), nhel, den(505))
    call Hcont_VV(nsync, wf8(:,30), wf8(:,221), A(:,601), n3(:,983), t3x64(:,:,601), nhel, den(506))
    call Hcont_VV(nsync, wf8(:,54), wf8(:,175), A(:,602), n3(:,984), t3x64(:,:,602), nhel, den(507))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvectors(A, j, M1, M2)
  implicit none
  type(Hpolcont) :: A(:,:)
  integer, intent(in) :: j
  type(Hpolcont), intent(out) :: M1(12), M2(14) ! M1helarray(14,64)
  integer :: empty(0), i

  M1( 1)%j = ((A(j,65)%j+A(j,67)%j+A(j,73)%j+A(j,75)%j)*f(1))/6._/**/REALKIND+((-A(j,4)%j+A(j,6)%j+A(j,23)%j+A(j,24)%j+A(j,28)%j &
        +A(j,37)%j+A(j,66)%j+A(j,76)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,30)%j-A(j,31)%j-A(j,39)%j+A(j,46)%j)*f(2))/2._/**/REALKIND
  M1( 2)%j = ((A(j,1)%j-A(j,3)%j-A(j,8)%j-A(j,9)%j-A(j,13)%j-A(j,49)%j-A(j,61)%j-A(j,75)%j)*f(1))/2._/**/REALKIND+((-A(j,62)%j &
        -A(j,63)%j-A(j,74)%j-A(j,76)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,15)%j+A(j,17)%j+A(j,50)%j &
        -A(j,58)%j)*f(2))/2._/**/REALKIND
  M1( 3)%j = ((A(j,1)%j-A(j,3)%j-A(j,8)%j-A(j,9)%j-A(j,10)%j-A(j,52)%j-A(j,65)%j-A(j,71)%j)*f(1))/2._/**/REALKIND+((-A(j,66)%j &
        -A(j,68)%j-A(j,69)%j-A(j,72)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,12)%j-A(j,19)%j-A(j,54)%j+A(j,55)%j)*f(2))/2._/**/REALKIND
  M1( 4)%j = ((A(j,61)%j+A(j,64)%j+A(j,70)%j+A(j,71)%j)*f(1))/6._/**/REALKIND+((-A(j,4)%j+A(j,6)%j+A(j,23)%j+A(j,24)%j+A(j,25)%j &
        +A(j,40)%j+A(j,62)%j+A(j,72)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,26)%j+A(j,34)%j+A(j,42)%j &
        -A(j,44)%j)*f(2))/2._/**/REALKIND
  M1( 5)%j = ((A(j,52)%j+A(j,53)%j+A(j,56)%j)*f(1))/6._/**/REALKIND+((A(j,5)%j-A(j,6)%j-A(j,22)%j-A(j,24)%j+A(j,32)%j+A(j,41)%j &
        +A(j,69)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,31)%j+A(j,36)%j-A(j,42)%j+A(j,47)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,59)%j &
        +A(j,60)%j)*f(2))/6._/**/REALKIND
  M1( 6)%j = ((-A(j,40)%j-A(j,41)%j-A(j,43)%j)*f(1))/6._/**/REALKIND+((-A(j,1)%j+A(j,2)%j+A(j,7)%j+A(j,8)%j-A(j,16)%j-A(j,53)%j &
        -A(j,70)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,47)%j-A(j,48)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,17)%j-A(j,21)%j+A(j,54)%j &
        -A(j,59)%j)*f(2))/2._/**/REALKIND
  M1( 7)%j = ((-A(j,28)%j-A(j,29)%j-A(j,32)%j)*f(1))/6._/**/REALKIND+((-A(j,2)%j+A(j,3)%j-A(j,7)%j+A(j,9)%j-A(j,14)%j-A(j,56)%j &
        -A(j,73)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,35)%j-A(j,36)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,15)%j-A(j,20)%j-A(j,55)%j &
        -A(j,60)%j)*f(2))/2._/**/REALKIND
  M1( 8)%j = ((A(j,13)%j+A(j,14)%j+A(j,16)%j)*f(1))/6._/**/REALKIND+((A(j,4)%j-A(j,5)%j+A(j,22)%j-A(j,23)%j+A(j,29)%j+A(j,43)%j &
        +A(j,74)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,20)%j+A(j,21)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,30)%j+A(j,35)%j+A(j,44)%j &
        +A(j,48)%j)*f(2))/2._/**/REALKIND
  M1( 9)%j = ((A(j,49)%j+A(j,51)%j+A(j,57)%j)*f(1))/6._/**/REALKIND+((A(j,4)%j-A(j,5)%j+A(j,22)%j-A(j,23)%j+A(j,27)%j+A(j,45)%j &
        +A(j,63)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,26)%j-A(j,36)%j-A(j,46)%j-A(j,47)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,59)%j &
        -A(j,60)%j)*f(2))/6._/**/REALKIND
  M1(10)%j = ((-A(j,37)%j-A(j,38)%j-A(j,45)%j)*f(1))/6._/**/REALKIND+((-A(j,2)%j+A(j,3)%j-A(j,7)%j+A(j,9)%j-A(j,11)%j-A(j,57)%j &
        -A(j,67)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,47)%j+A(j,48)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,12)%j+A(j,21)%j+A(j,58)%j &
        +A(j,59)%j)*f(2))/2._/**/REALKIND
  M1(11)%j = ((-A(j,25)%j-A(j,27)%j-A(j,33)%j)*f(1))/6._/**/REALKIND+((-A(j,1)%j+A(j,2)%j+A(j,7)%j+A(j,8)%j-A(j,18)%j-A(j,51)%j &
        -A(j,64)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,35)%j+A(j,36)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,19)%j+A(j,20)%j-A(j,50)%j &
        +A(j,60)%j)*f(2))/2._/**/REALKIND
  M1(12)%j = ((A(j,10)%j+A(j,11)%j+A(j,18)%j)*f(1))/6._/**/REALKIND+((A(j,5)%j-A(j,6)%j-A(j,22)%j-A(j,24)%j+A(j,33)%j+A(j,38)%j &
        +A(j,68)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,20)%j-A(j,21)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,34)%j-A(j,35)%j+A(j,39)%j &
        -A(j,48)%j)*f(2))/2._/**/REALKIND

  M2( 1)%j = ((A(j,140)%j-A(j,142)%j+A(j,143)%j-A(j,145)%j-A(j,441)%j-A(j,442)%j-A(j,443)%j-A(j,444)%j-A(j,445)%j-A(j,446)%j &
        -A(j,456)%j-A(j,457)%j-A(j,458)%j-A(j,483)%j-A(j,484)%j-A(j,485)%j-A(j,568)%j-A(j,569)%j-A(j,572)%j-A(j,598)%j-A(j,600)%j &
        -A(j,601)%j)*f(3))/2._/**/REALKIND+((-A(j,567)%j-A(j,570)%j-A(j,571)%j-A(j,573)%j-A(j,574)%j-A(j,575)%j-A(j,591)%j &
        -A(j,592)%j-A(j,593)%j-A(j,597)%j-A(j,599)%j-A(j,602)%j)*f(3))/6._/**/REALKIND+(CI*(-A(j,460)%j-A(j,462)%j-A(j,463)%j &
        +A(j,465)%j+A(j,468)%j+A(j,469)%j+A(j,487)%j+A(j,488)%j+A(j,491)%j-A(j,508)%j-A(j,509)%j-A(j,511)%j)*f(4))/2._/**/REALKIND &
        +((A(j,201)%j+A(j,203)%j+A(j,209)%j+A(j,211)%j+A(j,242)%j+A(j,244)%j+A(j,245)%j+A(j,248)%j+A(j,288)%j+A(j,289)%j &
        +A(j,292)%j+A(j,294)%j+A(j,350)%j+A(j,352)%j+A(j,359)%j+A(j,361)%j)*f(5))/6._/**/REALKIND+((-A(j,92)%j+A(j,94)%j-A(j,95)%j &
        +A(j,97)%j+A(j,152)%j+A(j,170)%j+A(j,173)%j+A(j,202)%j+A(j,212)%j+A(j,215)%j+A(j,241)%j+A(j,247)%j+A(j,277)%j+A(j,290)%j &
        +A(j,293)%j+A(j,309)%j+A(j,310)%j+A(j,314)%j+A(j,325)%j+A(j,336)%j+A(j,337)%j+A(j,353)%j+A(j,360)%j &
        +A(j,366)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,165)%j+A(j,172)%j-A(j,213)%j+A(j,221)%j+A(j,271)%j-A(j,279)%j+A(j,315)%j &
        -A(j,317)%j+A(j,324)%j-A(j,330)%j-A(j,368)%j+A(j,375)%j)*f(6))/2._/**/REALKIND+((A(j,138)%j+A(j,139)%j+A(j,146)%j &
        +A(j,147)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,154)%j-A(j,155)%j-A(j,175)%j+A(j,182)%j)*f(8))/2._/**/REALKIND+A(j,84)%j*f(9) &
        +((-A(j,83)%j-A(j,85)%j)*f(9))/2._/**/REALKIND+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/3._/**/REALKIND-9*A(j,87)%j*f(10) &
        +(19*(A(j,86)%j+A(j,88)%j)*f(10))/4._/**/REALKIND
  M2( 2)%j = ((A(j,556)%j+A(j,557)%j+A(j,560)%j+A(j,561)%j+A(j,562)%j+A(j,563)%j+A(j,594)%j+A(j,595)%j+A(j,596)%j+A(j,598)%j &
        +A(j,600)%j+A(j,601)%j)*f(3))/6._/**/REALKIND+((-A(j,104)%j+A(j,106)%j-A(j,107)%j+A(j,109)%j+A(j,396)%j+A(j,397)%j &
        +A(j,398)%j+A(j,399)%j+A(j,400)%j+A(j,401)%j+A(j,411)%j+A(j,412)%j+A(j,413)%j+A(j,519)%j+A(j,520)%j+A(j,521)%j+A(j,555)%j &
        +A(j,558)%j+A(j,559)%j+A(j,597)%j+A(j,599)%j+A(j,602)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,415)%j+A(j,416)%j+A(j,418)%j &
        -A(j,421)%j-A(j,422)%j-A(j,425)%j-A(j,522)%j-A(j,525)%j-A(j,526)%j+A(j,544)%j+A(j,546)%j+A(j,547)%j)*f(4))/2._/**/REALKIND &
        +((-A(j,198)%j-A(j,199)%j-A(j,210)%j-A(j,212)%j-A(j,237)%j-A(j,240)%j-A(j,246)%j-A(j,247)%j-A(j,280)%j-A(j,283)%j &
        -A(j,290)%j-A(j,291)%j-A(j,358)%j-A(j,360)%j-A(j,363)%j-A(j,364)%j)*f(5))/6._/**/REALKIND+((A(j,89)%j-A(j,91)%j+A(j,98)%j &
        -A(j,100)%j-A(j,116)%j-A(j,134)%j-A(j,185)%j-A(j,197)%j-A(j,211)%j-A(j,227)%j-A(j,238)%j-A(j,248)%j-A(j,255)%j-A(j,266)%j &
        -A(j,267)%j-A(j,282)%j-A(j,289)%j-A(j,296)%j-A(j,347)%j-A(j,359)%j-A(j,362)%j-A(j,379)%j-A(j,380)%j &
        -A(j,384)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,128)%j-A(j,136)%j+A(j,226)%j-A(j,233)%j-A(j,253)%j+A(j,261)%j+A(j,297)%j &
        -A(j,304)%j-A(j,342)%j+A(j,348)%j-A(j,386)%j+A(j,388)%j)*f(6))/2._/**/REALKIND+((-A(j,102)%j-A(j,103)%j-A(j,110)%j &
        -A(j,111)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,118)%j+A(j,120)%j+A(j,186)%j-A(j,194)%j)*f(8))/2._/**/REALKIND-A(j,78)%j*f(9) &
        +((A(j,77)%j+A(j,79)%j)*f(9))/2._/**/REALKIND+9*A(j,81)%j*f(10)+(19*(-A(j,80)%j-A(j,82)%j)*f(10))/4._/**/REALKIND+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/3._/**/REALKIND
  M2( 3)%j = ((A(j,568)%j+A(j,569)%j+A(j,572)%j+A(j,576)%j+A(j,577)%j+A(j,578)%j+A(j,579)%j+A(j,580)%j+A(j,581)%j+A(j,586)%j &
        +A(j,588)%j+A(j,589)%j)*f(3))/6._/**/REALKIND+((-A(j,104)%j+A(j,106)%j-A(j,107)%j+A(j,109)%j+A(j,396)%j+A(j,397)%j &
        +A(j,398)%j+A(j,399)%j+A(j,400)%j+A(j,401)%j+A(j,402)%j+A(j,403)%j+A(j,404)%j+A(j,528)%j+A(j,529)%j+A(j,530)%j+A(j,567)%j &
        +A(j,570)%j+A(j,571)%j+A(j,585)%j+A(j,587)%j+A(j,590)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,406)%j-A(j,407)%j-A(j,410)%j &
        +A(j,427)%j+A(j,428)%j+A(j,430)%j+A(j,532)%j+A(j,534)%j+A(j,535)%j-A(j,537)%j-A(j,540)%j-A(j,541)%j)*f(4))/2._/**/REALKIND &
        +((-A(j,202)%j-A(j,204)%j-A(j,205)%j-A(j,208)%j-A(j,241)%j-A(j,243)%j-A(j,249)%j-A(j,251)%j-A(j,284)%j-A(j,286)%j &
        -A(j,293)%j-A(j,295)%j-A(j,351)%j-A(j,353)%j-A(j,356)%j-A(j,357)%j)*f(5))/6._/**/REALKIND+((A(j,89)%j-A(j,91)%j+A(j,98)%j &
        -A(j,100)%j-A(j,113)%j-A(j,127)%j-A(j,188)%j-A(j,201)%j-A(j,207)%j-A(j,234)%j-A(j,242)%j-A(j,252)%j-A(j,262)%j-A(j,266)%j &
        -A(j,267)%j-A(j,285)%j-A(j,292)%j-A(j,299)%j-A(j,340)%j-A(j,352)%j-A(j,355)%j-A(j,379)%j-A(j,380)%j &
        -A(j,381)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,125)%j-A(j,133)%j+A(j,229)%j-A(j,236)%j-A(j,256)%j+A(j,264)%j-A(j,300)%j &
        +A(j,302)%j-A(j,339)%j+A(j,345)%j+A(j,383)%j-A(j,390)%j)*f(6))/2._/**/REALKIND+((-A(j,102)%j-A(j,103)%j-A(j,110)%j &
        -A(j,111)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,115)%j-A(j,122)%j-A(j,190)%j+A(j,191)%j)*f(8))/2._/**/REALKIND-A(j,78)%j*f(9) &
        +((A(j,77)%j+A(j,79)%j)*f(9))/2._/**/REALKIND+9*A(j,81)%j*f(10)+(19*(-A(j,80)%j-A(j,82)%j)*f(10))/4._/**/REALKIND+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/3._/**/REALKIND
  M2( 4)%j = ((A(j,140)%j-A(j,142)%j+A(j,143)%j-A(j,145)%j-A(j,441)%j-A(j,442)%j-A(j,443)%j-A(j,444)%j-A(j,445)%j-A(j,446)%j &
        -A(j,447)%j-A(j,448)%j-A(j,449)%j-A(j,492)%j-A(j,493)%j-A(j,494)%j-A(j,556)%j-A(j,557)%j-A(j,560)%j-A(j,586)%j-A(j,588)%j &
        -A(j,589)%j)*f(3))/2._/**/REALKIND+((-A(j,555)%j-A(j,558)%j-A(j,559)%j-A(j,564)%j-A(j,565)%j-A(j,566)%j-A(j,582)%j &
        -A(j,583)%j-A(j,584)%j-A(j,585)%j-A(j,587)%j-A(j,590)%j)*f(3))/6._/**/REALKIND+(CI*(A(j,450)%j+A(j,453)%j+A(j,454)%j &
        -A(j,472)%j-A(j,474)%j-A(j,475)%j-A(j,496)%j-A(j,497)%j-A(j,499)%j+A(j,502)%j+A(j,503)%j+A(j,506)%j)*f(4))/2._/**/REALKIND &
        +((A(j,197)%j+A(j,200)%j+A(j,206)%j+A(j,207)%j+A(j,238)%j+A(j,239)%j+A(j,250)%j+A(j,252)%j+A(j,281)%j+A(j,282)%j &
        +A(j,285)%j+A(j,287)%j+A(j,354)%j+A(j,355)%j+A(j,362)%j+A(j,365)%j)*f(5))/6._/**/REALKIND+((-A(j,92)%j+A(j,94)%j-A(j,95)%j &
        +A(j,97)%j+A(j,149)%j+A(j,163)%j+A(j,176)%j+A(j,198)%j+A(j,208)%j+A(j,222)%j+A(j,237)%j+A(j,251)%j+A(j,270)%j+A(j,283)%j &
        +A(j,286)%j+A(j,309)%j+A(j,310)%j+A(j,311)%j+A(j,332)%j+A(j,336)%j+A(j,337)%j+A(j,356)%j+A(j,363)%j &
        +A(j,369)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,162)%j+A(j,169)%j-A(j,216)%j+A(j,224)%j+A(j,268)%j-A(j,276)%j-A(j,312)%j &
        +A(j,319)%j+A(j,327)%j-A(j,333)%j+A(j,371)%j-A(j,373)%j)*f(6))/2._/**/REALKIND+((A(j,138)%j+A(j,139)%j+A(j,146)%j &
        +A(j,147)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,150)%j+A(j,158)%j+A(j,178)%j-A(j,180)%j)*f(8))/2._/**/REALKIND+A(j,84)%j*f(9) &
        +((-A(j,83)%j-A(j,85)%j)*f(9))/2._/**/REALKIND+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/3._/**/REALKIND-9*A(j,87)%j*f(10) &
        +(19*(A(j,86)%j+A(j,88)%j)*f(10))/4._/**/REALKIND
  M2( 5)%j = ((-A(j,528)%j-A(j,529)%j-A(j,530)%j-A(j,531)%j-A(j,533)%j-A(j,536)%j-A(j,538)%j-A(j,539)%j &
        -A(j,542)%j)*f(3))/6._/**/REALKIND+((-A(j,140)%j+A(j,141)%j-A(j,144)%j+A(j,145)%j-A(j,438)%j+A(j,439)%j+A(j,440)%j &
        +A(j,442)%j+A(j,443)%j+A(j,446)%j-A(j,466)%j-A(j,467)%j-A(j,470)%j-A(j,495)%j-A(j,498)%j-A(j,500)%j-A(j,579)%j-A(j,580)%j &
        -A(j,581)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,465)%j-A(j,468)%j-A(j,469)%j-A(j,479)%j-A(j,480)%j-A(j,481)%j+A(j,496)%j &
        +A(j,497)%j+A(j,499)%j-A(j,513)%j-A(j,515)%j-A(j,518)%j)*f(4))/2._/**/REALKIND+(CI*(-A(j,549)%j-A(j,550)%j-A(j,551)%j &
        -A(j,552)%j-A(j,553)%j-A(j,554)%j)*f(4))/6._/**/REALKIND+((A(j,188)%j+A(j,189)%j+A(j,192)%j+A(j,228)%j+A(j,234)%j &
        +A(j,235)%j+A(j,299)%j+A(j,301)%j+A(j,303)%j+A(j,338)%j+A(j,340)%j+A(j,346)%j)*f(5))/6._/**/REALKIND+((A(j,93)%j-A(j,94)%j &
        +A(j,96)%j-A(j,97)%j+A(j,156)%j+A(j,164)%j+A(j,177)%j+A(j,205)%j+A(j,223)%j+A(j,249)%j+A(j,269)%j+A(j,284)%j-A(j,308)%j &
        -A(j,310)%j+A(j,318)%j+A(j,331)%j-A(j,335)%j-A(j,337)%j+A(j,357)%j+A(j,370)%j)*f(5))/2._/**/REALKIND+(CI*(A(j,230)%j &
        +A(j,231)%j+A(j,306)%j+A(j,307)%j+A(j,343)%j+A(j,344)%j)*f(6))/6._/**/REALKIND+(CI*(A(j,165)%j+A(j,167)%j+A(j,218)%j &
        -A(j,224)%j-A(j,268)%j+A(j,274)%j+A(j,317)%j+A(j,321)%j+A(j,329)%j+A(j,330)%j-A(j,371)%j+A(j,376)%j)*f(6))/2._/**/REALKIND &
        +((-A(j,137)%j-A(j,139)%j-A(j,146)%j-A(j,148)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,155)%j+A(j,160)%j-A(j,178)%j &
        +A(j,183)%j)*f(8))/2._/**/REALKIND+(CI*(A(j,195)%j+A(j,196)%j)*f(8))/6._/**/REALKIND+A(j,83)%j*f(9)+((-A(j,84)%j &
        -A(j,85)%j)*f(9))/2._/**/REALKIND+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/6._/**/REALKIND-9*A(j,86)%j*f(10)+(19*(A(j,87)%j &
        +A(j,88)%j)*f(10))/4._/**/REALKIND
  M2( 6)%j = ((A(j,492)%j+A(j,493)%j+A(j,494)%j+A(j,495)%j+A(j,498)%j+A(j,500)%j+A(j,501)%j+A(j,504)%j &
        +A(j,505)%j)*f(3))/6._/**/REALKIND+((A(j,105)%j-A(j,106)%j+A(j,107)%j-A(j,108)%j-A(j,393)%j+A(j,394)%j-A(j,395)%j &
        -A(j,396)%j-A(j,399)%j-A(j,400)%j+A(j,420)%j+A(j,423)%j+A(j,424)%j+A(j,531)%j+A(j,533)%j+A(j,536)%j+A(j,582)%j+A(j,583)%j &
        +A(j,584)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,513)%j+A(j,514)%j+A(j,515)%j+A(j,516)%j+A(j,517)%j &
        +A(j,518)%j)*f(4))/6._/**/REALKIND+(CI*(A(j,421)%j+A(j,422)%j+A(j,425)%j+A(j,433)%j+A(j,435)%j+A(j,436)%j-A(j,532)%j &
        -A(j,534)%j-A(j,535)%j+A(j,549)%j+A(j,550)%j+A(j,554)%j)*f(4))/2._/**/REALKIND+((-A(j,176)%j-A(j,177)%j-A(j,179)%j &
        -A(j,217)%j-A(j,222)%j-A(j,223)%j-A(j,269)%j-A(j,270)%j-A(j,275)%j-A(j,369)%j-A(j,370)%j-A(j,372)%j)*f(5))/6._/**/REALKIND &
        +((-A(j,89)%j+A(j,90)%j-A(j,98)%j+A(j,99)%j-A(j,119)%j-A(j,129)%j-A(j,189)%j-A(j,206)%j-A(j,235)%j-A(j,250)%j-A(j,260)%j &
        +A(j,265)%j+A(j,266)%j-A(j,287)%j-A(j,301)%j-A(j,338)%j-A(j,354)%j+A(j,378)%j+A(j,379)%j-A(j,387)%j)*f(5))/2._/**/REALKIND &
        +(CI*(-A(j,218)%j-A(j,219)%j-A(j,273)%j-A(j,274)%j-A(j,376)%j-A(j,377)%j)*f(6))/6._/**/REALKIND+(CI*(-A(j,128)%j &
        -A(j,131)%j-A(j,230)%j+A(j,236)%j-A(j,258)%j-A(j,261)%j+A(j,300)%j-A(j,307)%j+A(j,339)%j-A(j,343)%j-A(j,388)%j &
        -A(j,392)%j)*f(6))/2._/**/REALKIND+((A(j,101)%j+A(j,102)%j+A(j,111)%j+A(j,112)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,183)%j &
        -A(j,184)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,120)%j-A(j,124)%j+A(j,190)%j-A(j,195)%j)*f(8))/2._/**/REALKIND+((A(j,77)%j &
        +A(j,78)%j)*f(9))/2._/**/REALKIND-A(j,79)%j*f(9)+(19*(-A(j,80)%j-A(j,81)%j)*f(10))/4._/**/REALKIND+9*A(j,82)%j*f(10)+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/6._/**/REALKIND
  M2( 7)%j = ((A(j,456)%j+A(j,457)%j+A(j,458)%j+A(j,459)%j+A(j,461)%j+A(j,464)%j+A(j,466)%j+A(j,467)%j &
        +A(j,470)%j)*f(3))/6._/**/REALKIND+((A(j,104)%j-A(j,105)%j+A(j,108)%j-A(j,109)%j+A(j,393)%j-A(j,394)%j+A(j,395)%j &
        -A(j,397)%j-A(j,398)%j-A(j,401)%j+A(j,414)%j+A(j,417)%j+A(j,419)%j+A(j,538)%j+A(j,539)%j+A(j,542)%j+A(j,591)%j+A(j,592)%j &
        +A(j,593)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,477)%j+A(j,478)%j+A(j,479)%j+A(j,480)%j+A(j,481)%j &
        +A(j,482)%j)*f(4))/6._/**/REALKIND+(CI*(-A(j,415)%j-A(j,416)%j-A(j,418)%j+A(j,432)%j+A(j,434)%j+A(j,437)%j+A(j,537)%j &
        +A(j,540)%j+A(j,541)%j+A(j,551)%j+A(j,552)%j+A(j,553)%j)*f(4))/2._/**/REALKIND+((-A(j,152)%j-A(j,153)%j-A(j,156)%j &
        -A(j,164)%j-A(j,170)%j-A(j,171)%j-A(j,314)%j-A(j,316)%j-A(j,318)%j-A(j,323)%j-A(j,325)%j-A(j,331)%j)*f(5))/6._/**/REALKIND &
        +((-A(j,90)%j+A(j,91)%j-A(j,99)%j+A(j,100)%j-A(j,117)%j-A(j,135)%j-A(j,192)%j-A(j,209)%j-A(j,228)%j-A(j,245)%j-A(j,254)%j &
        -A(j,265)%j+A(j,267)%j-A(j,288)%j-A(j,303)%j-A(j,346)%j-A(j,361)%j-A(j,378)%j+A(j,380)%j-A(j,385)%j)*f(5))/2._/**/REALKIND &
        +(CI*(-A(j,166)%j-A(j,167)%j-A(j,321)%j-A(j,322)%j-A(j,328)%j-A(j,329)%j)*f(6))/6._/**/REALKIND+(CI*(-A(j,130)%j &
        +A(j,136)%j-A(j,229)%j-A(j,231)%j+A(j,253)%j-A(j,259)%j-A(j,302)%j-A(j,306)%j-A(j,344)%j-A(j,345)%j+A(j,386)%j &
        -A(j,391)%j)*f(6))/2._/**/REALKIND+((-A(j,101)%j+A(j,103)%j+A(j,110)%j-A(j,112)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,159)%j &
        -A(j,160)%j)*f(8))/6._/**/REALKIND+(CI*(A(j,118)%j-A(j,123)%j-A(j,191)%j-A(j,196)%j)*f(8))/2._/**/REALKIND-A(j,77)%j*f(9) &
        +((A(j,78)%j+A(j,79)%j)*f(9))/2._/**/REALKIND+9*A(j,80)%j*f(10)+(19*(-A(j,81)%j-A(j,82)%j)*f(10))/4._/**/REALKIND+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/6._/**/REALKIND
  M2( 8)%j = ((-A(j,411)%j-A(j,412)%j-A(j,413)%j-A(j,414)%j-A(j,417)%j-A(j,419)%j-A(j,420)%j-A(j,423)%j &
        -A(j,424)%j)*f(3))/6._/**/REALKIND+((-A(j,141)%j+A(j,142)%j-A(j,143)%j+A(j,144)%j+A(j,438)%j-A(j,439)%j-A(j,440)%j &
        +A(j,441)%j+A(j,444)%j+A(j,445)%j-A(j,459)%j-A(j,461)%j-A(j,464)%j-A(j,501)%j-A(j,504)%j-A(j,505)%j-A(j,594)%j-A(j,595)%j &
        -A(j,596)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,432)%j-A(j,433)%j-A(j,434)%j-A(j,435)%j-A(j,436)%j &
        -A(j,437)%j)*f(4))/6._/**/REALKIND+(CI*(A(j,460)%j+A(j,462)%j+A(j,463)%j-A(j,477)%j-A(j,478)%j-A(j,482)%j-A(j,502)%j &
        -A(j,503)%j-A(j,506)%j-A(j,514)%j-A(j,516)%j-A(j,517)%j)*f(4))/2._/**/REALKIND+((A(j,92)%j-A(j,93)%j+A(j,95)%j-A(j,96)%j &
        +A(j,153)%j+A(j,171)%j+A(j,179)%j+A(j,210)%j+A(j,217)%j+A(j,246)%j+A(j,275)%j+A(j,291)%j+A(j,308)%j-A(j,309)%j+A(j,316)%j &
        +A(j,323)%j+A(j,335)%j-A(j,336)%j+A(j,358)%j+A(j,372)%j)*f(5))/2._/**/REALKIND+((A(j,116)%j+A(j,117)%j+A(j,119)%j &
        +A(j,129)%j+A(j,134)%j+A(j,135)%j+A(j,254)%j+A(j,255)%j+A(j,260)%j+A(j,384)%j+A(j,385)%j+A(j,387)%j)*f(5))/6._/**/REALKIND &
        +(CI*(A(j,166)%j-A(j,172)%j+A(j,216)%j+A(j,219)%j+A(j,273)%j+A(j,276)%j-A(j,315)%j+A(j,322)%j-A(j,324)%j+A(j,328)%j &
        +A(j,373)%j+A(j,377)%j)*f(6))/2._/**/REALKIND+(CI*(A(j,130)%j+A(j,131)%j+A(j,258)%j+A(j,259)%j+A(j,391)%j &
        +A(j,392)%j)*f(6))/6._/**/REALKIND+((A(j,137)%j-A(j,138)%j-A(j,147)%j+A(j,148)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,123)%j &
        +A(j,124)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,154)%j+A(j,159)%j+A(j,180)%j+A(j,184)%j)*f(8))/2._/**/REALKIND+((-A(j,83)%j &
        -A(j,84)%j)*f(9))/2._/**/REALKIND+A(j,85)%j*f(9)+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/6._/**/REALKIND+(19*(A(j,86)%j &
        +A(j,87)%j)*f(10))/4._/**/REALKIND-9*A(j,88)%j*f(10)
  M2( 9)%j = ((-A(j,519)%j-A(j,520)%j-A(j,521)%j-A(j,523)%j-A(j,524)%j-A(j,527)%j-A(j,543)%j-A(j,545)%j &
        -A(j,548)%j)*f(3))/6._/**/REALKIND+((-A(j,141)%j+A(j,142)%j-A(j,143)%j+A(j,144)%j+A(j,438)%j-A(j,439)%j-A(j,440)%j &
        +A(j,441)%j+A(j,444)%j+A(j,445)%j-A(j,451)%j-A(j,452)%j-A(j,455)%j-A(j,507)%j-A(j,510)%j-A(j,512)%j-A(j,561)%j-A(j,562)%j &
        -A(j,563)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,450)%j-A(j,453)%j-A(j,454)%j+A(j,479)%j+A(j,480)%j+A(j,481)%j+A(j,508)%j &
        +A(j,509)%j+A(j,511)%j+A(j,513)%j+A(j,515)%j+A(j,518)%j)*f(4))/2._/**/REALKIND+(CI*(A(j,549)%j+A(j,550)%j+A(j,551)%j &
        +A(j,552)%j+A(j,553)%j+A(j,554)%j)*f(4))/6._/**/REALKIND+((A(j,185)%j+A(j,187)%j+A(j,193)%j+A(j,225)%j+A(j,227)%j &
        +A(j,232)%j+A(j,296)%j+A(j,298)%j+A(j,305)%j+A(j,341)%j+A(j,347)%j+A(j,349)%j)*f(5))/6._/**/REALKIND+((A(j,92)%j-A(j,93)%j &
        +A(j,95)%j-A(j,96)%j+A(j,151)%j+A(j,161)%j+A(j,181)%j+A(j,199)%j+A(j,220)%j+A(j,240)%j+A(j,272)%j+A(j,280)%j+A(j,308)%j &
        -A(j,309)%j+A(j,313)%j+A(j,334)%j+A(j,335)%j-A(j,336)%j+A(j,364)%j+A(j,374)%j)*f(5))/2._/**/REALKIND+(CI*(-A(j,230)%j &
        -A(j,231)%j-A(j,306)%j-A(j,307)%j-A(j,343)%j-A(j,344)%j)*f(6))/6._/**/REALKIND+(CI*(A(j,162)%j-A(j,167)%j-A(j,218)%j &
        -A(j,221)%j-A(j,271)%j-A(j,274)%j+A(j,312)%j-A(j,321)%j-A(j,329)%j+A(j,333)%j-A(j,375)%j-A(j,376)%j)*f(6))/2._/**/REALKIND &
        +((A(j,137)%j-A(j,138)%j-A(j,147)%j+A(j,148)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,150)%j-A(j,160)%j-A(j,182)%j &
        -A(j,183)%j)*f(8))/2._/**/REALKIND+(CI*(-A(j,195)%j-A(j,196)%j)*f(8))/6._/**/REALKIND+((-A(j,83)%j &
        -A(j,84)%j)*f(9))/2._/**/REALKIND+A(j,85)%j*f(9)+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/6._/**/REALKIND+(19*(A(j,86)%j &
        +A(j,87)%j)*f(10))/4._/**/REALKIND-9*A(j,88)%j*f(10)
  M2(10)%j = ((A(j,483)%j+A(j,484)%j+A(j,485)%j+A(j,486)%j+A(j,489)%j+A(j,490)%j+A(j,507)%j+A(j,510)%j &
        +A(j,512)%j)*f(3))/6._/**/REALKIND+((A(j,104)%j-A(j,105)%j+A(j,108)%j-A(j,109)%j+A(j,393)%j-A(j,394)%j+A(j,395)%j &
        -A(j,397)%j-A(j,398)%j-A(j,401)%j+A(j,405)%j+A(j,408)%j+A(j,409)%j+A(j,543)%j+A(j,545)%j+A(j,548)%j+A(j,573)%j+A(j,574)%j &
        +A(j,575)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,513)%j-A(j,514)%j-A(j,515)%j-A(j,516)%j-A(j,517)%j &
        -A(j,518)%j)*f(4))/6._/**/REALKIND+(CI*(A(j,406)%j+A(j,407)%j+A(j,410)%j-A(j,433)%j-A(j,435)%j-A(j,436)%j-A(j,544)%j &
        -A(j,546)%j-A(j,547)%j-A(j,549)%j-A(j,550)%j-A(j,554)%j)*f(4))/2._/**/REALKIND+((-A(j,173)%j-A(j,174)%j-A(j,181)%j &
        -A(j,214)%j-A(j,215)%j-A(j,220)%j-A(j,272)%j-A(j,277)%j-A(j,278)%j-A(j,366)%j-A(j,367)%j-A(j,374)%j)*f(5))/6._/**/REALKIND &
        +((-A(j,90)%j+A(j,91)%j-A(j,99)%j+A(j,100)%j-A(j,114)%j-A(j,126)%j-A(j,193)%j-A(j,203)%j-A(j,232)%j-A(j,244)%j-A(j,263)%j &
        -A(j,265)%j+A(j,267)%j-A(j,294)%j-A(j,305)%j-A(j,341)%j-A(j,350)%j-A(j,378)%j+A(j,380)%j-A(j,382)%j)*f(5))/2._/**/REALKIND &
        +(CI*(A(j,218)%j+A(j,219)%j+A(j,273)%j+A(j,274)%j+A(j,376)%j+A(j,377)%j)*f(6))/6._/**/REALKIND+(CI*(-A(j,125)%j+A(j,131)%j &
        +A(j,230)%j+A(j,233)%j+A(j,258)%j-A(j,264)%j+A(j,304)%j+A(j,307)%j+A(j,342)%j+A(j,343)%j-A(j,383)%j &
        +A(j,392)%j)*f(6))/2._/**/REALKIND+((-A(j,101)%j+A(j,103)%j+A(j,110)%j-A(j,112)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,183)%j &
        +A(j,184)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,115)%j+A(j,124)%j+A(j,194)%j+A(j,195)%j)*f(8))/2._/**/REALKIND-A(j,77)%j*f(9) &
        +((A(j,78)%j+A(j,79)%j)*f(9))/2._/**/REALKIND+9*A(j,80)%j*f(10)+(19*(-A(j,81)%j-A(j,82)%j)*f(10))/4._/**/REALKIND+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/6._/**/REALKIND
  M2(11)%j = ((A(j,447)%j+A(j,448)%j+A(j,449)%j+A(j,451)%j+A(j,452)%j+A(j,455)%j+A(j,471)%j+A(j,473)%j &
        +A(j,476)%j)*f(3))/6._/**/REALKIND+((A(j,105)%j-A(j,106)%j+A(j,107)%j-A(j,108)%j-A(j,393)%j+A(j,394)%j-A(j,395)%j &
        -A(j,396)%j-A(j,399)%j-A(j,400)%j+A(j,426)%j+A(j,429)%j+A(j,431)%j+A(j,523)%j+A(j,524)%j+A(j,527)%j+A(j,564)%j+A(j,565)%j &
        +A(j,566)%j)*f(3))/2._/**/REALKIND+(CI*(-A(j,477)%j-A(j,478)%j-A(j,479)%j-A(j,480)%j-A(j,481)%j &
        -A(j,482)%j)*f(4))/6._/**/REALKIND+(CI*(-A(j,427)%j-A(j,428)%j-A(j,430)%j-A(j,432)%j-A(j,434)%j-A(j,437)%j+A(j,522)%j &
        +A(j,525)%j+A(j,526)%j-A(j,551)%j-A(j,552)%j-A(j,553)%j)*f(4))/2._/**/REALKIND+((-A(j,149)%j-A(j,151)%j-A(j,157)%j &
        -A(j,161)%j-A(j,163)%j-A(j,168)%j-A(j,311)%j-A(j,313)%j-A(j,320)%j-A(j,326)%j-A(j,332)%j-A(j,334)%j)*f(5))/6._/**/REALKIND &
        +((-A(j,89)%j+A(j,90)%j-A(j,98)%j+A(j,99)%j-A(j,121)%j-A(j,132)%j-A(j,187)%j-A(j,200)%j-A(j,225)%j-A(j,239)%j-A(j,257)%j &
        +A(j,265)%j+A(j,266)%j-A(j,281)%j-A(j,298)%j-A(j,349)%j-A(j,365)%j+A(j,378)%j+A(j,379)%j-A(j,389)%j)*f(5))/2._/**/REALKIND &
        +(CI*(A(j,166)%j+A(j,167)%j+A(j,321)%j+A(j,322)%j+A(j,328)%j+A(j,329)%j)*f(6))/6._/**/REALKIND+(CI*(A(j,130)%j+A(j,133)%j &
        -A(j,226)%j+A(j,231)%j+A(j,256)%j+A(j,259)%j-A(j,297)%j+A(j,306)%j+A(j,344)%j-A(j,348)%j+A(j,390)%j &
        +A(j,391)%j)*f(6))/2._/**/REALKIND+((A(j,101)%j+A(j,102)%j+A(j,111)%j+A(j,112)%j)*f(7))/2._/**/REALKIND+(CI*(A(j,159)%j &
        +A(j,160)%j)*f(8))/6._/**/REALKIND+(CI*(A(j,122)%j+A(j,123)%j-A(j,186)%j+A(j,196)%j)*f(8))/2._/**/REALKIND+((A(j,77)%j &
        +A(j,78)%j)*f(9))/2._/**/REALKIND-A(j,79)%j*f(9)+(19*(-A(j,80)%j-A(j,81)%j)*f(10))/4._/**/REALKIND+9*A(j,82)%j*f(10)+(( &
        -A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/6._/**/REALKIND
  M2(12)%j = ((-A(j,402)%j-A(j,403)%j-A(j,404)%j-A(j,405)%j-A(j,408)%j-A(j,409)%j-A(j,426)%j-A(j,429)%j &
        -A(j,431)%j)*f(3))/6._/**/REALKIND+((-A(j,140)%j+A(j,141)%j-A(j,144)%j+A(j,145)%j-A(j,438)%j+A(j,439)%j+A(j,440)%j &
        +A(j,442)%j+A(j,443)%j+A(j,446)%j-A(j,471)%j-A(j,473)%j-A(j,476)%j-A(j,486)%j-A(j,489)%j-A(j,490)%j-A(j,576)%j-A(j,577)%j &
        -A(j,578)%j)*f(3))/2._/**/REALKIND+(CI*(A(j,432)%j+A(j,433)%j+A(j,434)%j+A(j,435)%j+A(j,436)%j &
        +A(j,437)%j)*f(4))/6._/**/REALKIND+(CI*(A(j,472)%j+A(j,474)%j+A(j,475)%j+A(j,477)%j+A(j,478)%j+A(j,482)%j-A(j,487)%j &
        -A(j,488)%j-A(j,491)%j+A(j,514)%j+A(j,516)%j+A(j,517)%j)*f(4))/2._/**/REALKIND+((A(j,93)%j-A(j,94)%j+A(j,96)%j-A(j,97)%j &
        +A(j,157)%j+A(j,168)%j+A(j,174)%j+A(j,204)%j+A(j,214)%j+A(j,243)%j+A(j,278)%j+A(j,295)%j-A(j,308)%j-A(j,310)%j+A(j,320)%j &
        +A(j,326)%j-A(j,335)%j-A(j,337)%j+A(j,351)%j+A(j,367)%j)*f(5))/2._/**/REALKIND+((A(j,113)%j+A(j,114)%j+A(j,121)%j &
        +A(j,126)%j+A(j,127)%j+A(j,132)%j+A(j,257)%j+A(j,262)%j+A(j,263)%j+A(j,381)%j+A(j,382)%j+A(j,389)%j)*f(5))/6._/**/REALKIND &
        +(CI*(-A(j,166)%j-A(j,169)%j+A(j,213)%j-A(j,219)%j-A(j,273)%j+A(j,279)%j-A(j,319)%j-A(j,322)%j-A(j,327)%j-A(j,328)%j &
        +A(j,368)%j-A(j,377)%j)*f(6))/2._/**/REALKIND+(CI*(-A(j,130)%j-A(j,131)%j-A(j,258)%j-A(j,259)%j-A(j,391)%j &
        -A(j,392)%j)*f(6))/6._/**/REALKIND+((-A(j,137)%j-A(j,139)%j-A(j,146)%j-A(j,148)%j)*f(7))/2._/**/REALKIND+(CI*(-A(j,123)%j &
        -A(j,124)%j)*f(8))/6._/**/REALKIND+(CI*(-A(j,158)%j-A(j,159)%j+A(j,175)%j-A(j,184)%j)*f(8))/2._/**/REALKIND+A(j,83)%j*f(9) &
        +((-A(j,84)%j-A(j,85)%j)*f(9))/2._/**/REALKIND+((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/6._/**/REALKIND-9*A(j,86)%j*f(10) &
        +(19*(A(j,87)%j+A(j,88)%j)*f(10))/4._/**/REALKIND
  M2(13)%j = ((A(j,80)%j+A(j,81)%j+A(j,82)%j)*f(10))/3._/**/REALKIND+(2*(A(j,86)%j+A(j,87)%j+A(j,88)%j)*f(10))/9._/**/REALKIND
  M2(14)%j = (2*(-A(j,80)%j-A(j,81)%j-A(j,82)%j)*f(10))/9._/**/REALKIND+((-A(j,86)%j-A(j,87)%j-A(j,88)%j)*f(10))/3._/**/REALKIND


  M1(:)%hf = Hel(j)
  M2(:)%hf = Hel(j)

  !M(i) corresponds to \Gamma_{i} in Fabios thesis

end subroutine colourvectors


! **********************************************************************
subroutine colint(M, M2colint)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(12)
  real(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

    do i = 1, 12
      do j = 1, 12
        M2colint = M2colint + real(conjg(M(i))*K1(i,j)*M(j))
      end do
    end do

end subroutine colint

! **********************************************************************
subroutine colint_ct(M, Mct, M2colint_ct, l)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: K2
  implicit none
  complex(REALKIND), intent(in)  :: M(12), Mct(14)
  real(REALKIND),    intent(out) :: M2colint_ct
  integer, intent(in) :: l
  integer ::  i, j

  M2colint_ct = 0

  do i = 1, 12
    do j = 1, 14
      M2colint_ct = M2colint_ct + real(conjg(M(i))*K2(i+12*l,j)*Mct(j))
    end do
  end do

end subroutine colint_ct

! **********************************************************************
subroutine colint_IR(M, M2IRadd)
! M(i)   = <M|Ci> colour component of matrix element
! K1(i,j) = .....
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(12)
  real(REALKIND),    intent(out) :: M2IRadd(22)
  integer ::  i, j, k, colmatpos

  M2IRadd = 0

  do k = 1, 23-1
    colmatpos = 12*k
    do i = 1, 12
      do j = 1, 12
        M2IRadd(k) = M2IRadd(k) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint_IR

! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K2(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: K2
  implicit none

  complex(REALKIND), intent(in)  :: M1(12)
  complex(REALKIND), intent(in)  :: M2(12)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 12
    do j = 1, 12
      M2colint = M2colint + M1(i)*K2(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu





! **********************************************************************
subroutine colborninterf(M, M0_col, l)
! M(i)         = <M|Ci> colour component of matrix element
! M0_col(i)    = <M2|Ci> colour component of matrix element,
!                see \tilde{M}_{j} in Fabios thesis
! M2colint = Sum_{i} <M1|Ci> * <Ci|Cj>
!          = colour-summed squared matrix element
! KL(i,j) = <Ci|Cj> with elements Cj of 1-loop colour basis
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND, only: KL
  implicit none

  type(Hpolcont), intent(in)  :: M(12)
  type(Hpolcont), intent(out)  :: M0_col(14)
  integer, intent(in) :: l
  integer :: i, j

  do j = 1, 14 !size(KL(1,:))
    M0_col(j)%j = 0
    M0_col(j)%hf = M(1)%hf
    do i = 1, 12 !size(KL(:,1))
      M0_col(j)%j = M0_col(j)%j  + conjg(M(i)%j)*KL(i+12*l,j)
    end do
  end do

end subroutine colborninterf

end subroutine amp2

end module ol_loop_pptttt_tttxtxgg_1_/**/REALKIND
