
module ol_vamp_3_pptttt_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_3(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_tttxtxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_tttxtxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_tttxtxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_tttxtxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(14)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,86) :: G0
  complex(REALKIND), dimension(4,5,4,228) :: G1
  complex(REALKIND), dimension(4,15,4,242) :: G2
  complex(REALKIND), dimension(4,35,4,135) :: G3
  complex(REALKIND), dimension(4,70,4,36) :: G4
  complex(REALKIND), dimension(1,18) :: G0tensor
  complex(REALKIND), dimension(5,78) :: G1tensor
  complex(REALKIND), dimension(15,124) :: G2tensor
  complex(REALKIND), dimension(35,78) :: G3tensor
  complex(REALKIND), dimension(70,38) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_VA_Q(G0(:,:,:,1),wf(:,-3),G0(:,:,:,2))
  call loop_A_Q(G0(:,:,:,2),Q(:,8),MT,G1(:,:,:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,3),G1(:,:,:,2))
  call loop_A_Q(G1(:,:,:,2),Q(:,61),MT,G2(:,:,:,1))
  call check_last_AQ_V(l_switch,G2(:,:,:,1),wf(:,-1),G2tensor(:,1))
  call loop_AV_Q(G1(:,:,:,1),wf(:,4),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,61),MT,G2(:,:,:,2))
  call check_last_AQ_V(l_switch,G2(:,:,:,2),wf(:,-1),G2tensor(:,2))
  call loop_AV_Q(G1(:,:,:,1),wf(:,5),G1(:,:,:,4))
  call loop_A_Q(G1(:,:,:,4),Q(:,61),MT,G2(:,:,:,3))
  call check_last_AQ_V(l_switch,G2(:,:,:,3),wf(:,-1),G2tensor(:,3))
  call loop_AV_Q(G1(:,:,:,1),wf(:,145),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,4))
  call check_last_AQ_V(l_switch,G2(:,:,:,4),wf(:,0),G2tensor(:,4))
  call loop_AV_Q(G1(:,:,:,1),wf(:,147),G1(:,:,:,6))
  call loop_A_Q(G1(:,:,:,6),Q(:,62),MT,G2(:,:,:,5))
  call check_last_AQ_V(l_switch,G2(:,:,:,5),wf(:,0),G2tensor(:,5))
  call loop_AV_Q(G1(:,:,:,1),wf(:,148),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,62),MT,G2(:,:,:,6))
  call check_last_AQ_V(l_switch,G2(:,:,:,6),wf(:,0),G2tensor(:,6))
  call loop_AQ_V(G1(:,:,:,1),wf(:,-1),G1(:,:,:,8))
  call loop_GGG_G_12(G1(:,:,:,8),wf(:,-5),wf(:,-4),G1(:,:,:,9))
  call loop_VA_Q(G1(:,:,:,9),wf(:,-2),G1(:,:,:,10))
  call loop_A_Q(G1(:,:,:,10),Q(:,62),MT,G2(:,:,:,7))
  call check_last_AQ_V(l_switch,G2(:,:,:,7),wf(:,0),G2tensor(:,7))
  call loop_GGG_G_12(G1(:,:,:,8),wf(:,-4),wf(:,-5),G1(:,:,:,11))
  call loop_VA_Q(G1(:,:,:,11),wf(:,-2),G1(:,:,:,12))
  call loop_A_Q(G1(:,:,:,12),Q(:,62),MT,G2(:,:,:,8))
  call check_last_AQ_V(l_switch,G2(:,:,:,8),wf(:,0),G2tensor(:,8))
  call loop_GGG_G_23(G1(:,:,:,8),wf(:,-5),wf(:,-4),G1(:,:,:,13))
  call loop_VA_Q(G1(:,:,:,13),wf(:,-2),G1(:,:,:,14))
  call loop_A_Q(G1(:,:,:,14),Q(:,62),MT,G2(:,:,:,9))
  call check_last_AQ_V(l_switch,G2(:,:,:,9),wf(:,0),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,8),wf(:,211),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MT,G2(:,:,:,10))
  call check_last_AQ_V(l_switch,G2(:,:,:,10),wf(:,0),G2tensor(:,10))
  call loop_VA_Q(G1(:,:,:,8),wf(:,72),G1(:,:,:,16))
  call loop_A_Q(G1(:,:,:,16),Q(:,30),MT,G2(:,:,:,11))
  call loop_AV_Q(G2(:,:,:,11),wf(:,-5),G2(:,:,:,12))
  call loop_A_Q(G2(:,:,:,12),Q(:,62),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,0),G3tensor(:,1))
  call loop_UV_W(G1(:,:,:,8),Q(:,10),wf(:,-5),Q(:,32),G2(:,:,:,13))
  call loop_VA_Q(G2(:,:,:,13),wf(:,72),G2(:,:,:,14))
  call loop_A_Q(G2(:,:,:,14),Q(:,62),MT,G3(:,:,:,2))
  call check_last_AQ_V(l_switch,G3(:,:,:,2),wf(:,0),G3tensor(:,2))
  call loop_UV_W(G2(:,:,:,13),Q(:,42),wf(:,-4),Q(:,16),G3(:,:,:,3))
  call loop_VA_Q(G3(:,:,:,3),wf(:,-2),G3(:,:,:,4))
  call loop_A_Q(G3(:,:,:,4),Q(:,62),MT,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,0),G4tensor(:,1))
  call loop_VA_Q(G2(:,:,:,13),wf(:,-2),G2(:,:,:,15))
  call loop_A_Q(G2(:,:,:,15),Q(:,46),MT,G3(:,:,:,5))
  call loop_AV_Q(G3(:,:,:,5),wf(:,-4),G3(:,:,:,6))
  call loop_A_Q(G3(:,:,:,6),Q(:,62),MT,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_VA_Q(G1(:,:,:,8),wf(:,214),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,0),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,8),wf(:,66),G1(:,:,:,18))
  call loop_A_Q(G1(:,:,:,18),Q(:,46),MT,G2(:,:,:,17))
  call loop_AV_Q(G2(:,:,:,17),wf(:,-4),G2(:,:,:,18))
  call loop_A_Q(G2(:,:,:,18),Q(:,62),MT,G3(:,:,:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,7),wf(:,0),G3tensor(:,3))
  call loop_UV_W(G1(:,:,:,8),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,19))
  call loop_VA_Q(G2(:,:,:,19),wf(:,66),G2(:,:,:,20))
  call loop_A_Q(G2(:,:,:,20),Q(:,62),MT,G3(:,:,:,8))
  call check_last_AQ_V(l_switch,G3(:,:,:,8),wf(:,0),G3tensor(:,4))
  call loop_UV_W(G2(:,:,:,19),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,9))
  call loop_VA_Q(G3(:,:,:,9),wf(:,-2),G3(:,:,:,10))
  call loop_A_Q(G3(:,:,:,10),Q(:,62),MT,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call loop_VA_Q(G2(:,:,:,19),wf(:,-2),G2(:,:,:,21))
  call loop_A_Q(G2(:,:,:,21),Q(:,30),MT,G3(:,:,:,11))
  call loop_AV_Q(G3(:,:,:,11),wf(:,-5),G3(:,:,:,12))
  call loop_A_Q(G3(:,:,:,12),Q(:,62),MT,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,0),G4tensor(:,4))
  call loop_VA_Q(G1(:,:,:,8),wf(:,215),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,0),G2tensor(:,12))
  call loop_UV_W(G1(:,:,:,8),Q(:,10),wf(:,11),Q(:,48),G2(:,:,:,23))
  call loop_VA_Q(G2(:,:,:,23),wf(:,-2),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,62),MT,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,0),G3tensor(:,5))
  call loop_VA_Q(G1(:,:,:,8),wf(:,-2),G1(:,:,:,20))
  call loop_A_Q(G1(:,:,:,20),Q(:,14),MT,G2(:,:,:,25))
  call loop_AV_Q(G2(:,:,:,25),wf(:,11),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,14),wf(:,0),G3tensor(:,6))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-5),G2(:,:,:,27))
  call loop_A_Q(G2(:,:,:,27),Q(:,46),MT,G3(:,:,:,15))
  call loop_AV_Q(G3(:,:,:,15),wf(:,-4),G3(:,:,:,16))
  call loop_A_Q(G3(:,:,:,16),Q(:,62),MT,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,5))
  call loop_AV_Q(G2(:,:,:,25),wf(:,-4),G2(:,:,:,28))
  call loop_A_Q(G2(:,:,:,28),Q(:,30),MT,G3(:,:,:,17))
  call loop_AV_Q(G3(:,:,:,17),wf(:,-5),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,62),MT,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,0),G4tensor(:,6))
  call loop_AQ_V(G1(:,:,:,1),wf(:,130),G1(:,:,:,21))
  call check_last_UV_W(l_switch,G1(:,:,:,21),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,21),wf(:,-2),G1(:,:,:,22))
  call loop_A_Q(G1(:,:,:,22),Q(:,62),MT,G2(:,:,:,29))
  call check_last_AQ_V(l_switch,G2(:,:,:,29),wf(:,0),G2tensor(:,14))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-5),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,40),MT,G2(:,:,:,30))
  call loop_AQ_V(G2(:,:,:,30),wf(:,19),G2(:,:,:,31))
  call check_last_UV_W(l_switch,G2(:,:,:,31),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,7))
  call loop_VA_Q(G2(:,:,:,31),wf(:,-2),G2(:,:,:,32))
  call loop_A_Q(G2(:,:,:,32),Q(:,62),MT,G3(:,:,:,19))
  call check_last_AQ_V(l_switch,G3(:,:,:,19),wf(:,0),G3tensor(:,8))
  call loop_AV_Q(G2(:,:,:,30),wf(:,-4),G2(:,:,:,33))
  call loop_A_Q(G2(:,:,:,33),Q(:,56),MT,G3(:,:,:,20))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,33),G3tensor(:,9))
  call loop_AV_Q(G3(:,:,:,20),wf(:,1),G3(:,:,:,21))
  call loop_A_Q(G3(:,:,:,21),Q(:,61),MT,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-1),G4tensor(:,7))
  call check_last_AQ_V(l_switch,G3(:,:,:,20),wf(:,58),G3tensor(:,10))
  call loop_AV_Q(G3(:,:,:,20),wf(:,7),G3(:,:,:,22))
  call loop_A_Q(G3(:,:,:,22),Q(:,62),MT,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,8))
  call loop_AQ_V(G3(:,:,:,20),wf(:,-1),G3(:,:,:,23))
  call loop_VA_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,62),MT,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,9))
  call loop_AV_Q(G2(:,:,:,30),wf(:,13),G2(:,:,:,34))
  call loop_A_Q(G2(:,:,:,34),Q(:,61),MT,G3(:,:,:,25))
  call check_last_AQ_V(l_switch,G3(:,:,:,25),wf(:,-1),G3tensor(:,11))
  call loop_AV_Q(G2(:,:,:,30),wf(:,1),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,45),MT,G3(:,:,:,26))
  call loop_AV_Q(G3(:,:,:,26),wf(:,-4),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,61),MT,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,-1),G4tensor(:,10))
  call loop_AQ_V(G2(:,:,:,30),wf(:,48),G2(:,:,:,36))
  call check_last_UV_W(l_switch,G2(:,:,:,36),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,12))
  call loop_VA_Q(G2(:,:,:,36),wf(:,-2),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,61),MT,G3(:,:,:,28))
  call check_last_AQ_V(l_switch,G3(:,:,:,28),wf(:,-1),G3tensor(:,13))
  call loop_AV_Q(G2(:,:,:,30),wf(:,45),G2(:,:,:,38))
  call loop_A_Q(G2(:,:,:,38),Q(:,62),MT,G3(:,:,:,29))
  call check_last_AQ_V(l_switch,G3(:,:,:,29),wf(:,0),G3tensor(:,14))
  call loop_AV_Q(G2(:,:,:,30),wf(:,7),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,46),MT,G3(:,:,:,30))
  call loop_AV_Q(G3(:,:,:,30),wf(:,-4),G3(:,:,:,31))
  call loop_A_Q(G3(:,:,:,31),Q(:,62),MT,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,11))
  call loop_AV_Q(G2(:,:,:,30),wf(:,83),G2(:,:,:,40))
  call loop_A_Q(G2(:,:,:,40),Q(:,61),MT,G3(:,:,:,32))
  call check_last_AQ_V(l_switch,G3(:,:,:,32),wf(:,-1),G3tensor(:,15))
  call loop_AV_Q(G2(:,:,:,30),wf(:,70),G2(:,:,:,41))
  call loop_A_Q(G2(:,:,:,41),Q(:,62),MT,G3(:,:,:,33))
  call check_last_AQ_V(l_switch,G3(:,:,:,33),wf(:,0),G3tensor(:,16))
  call loop_AV_Q(G2(:,:,:,30),wf(:,89),G2(:,:,:,42))
  call loop_A_Q(G2(:,:,:,42),Q(:,61),MT,G3(:,:,:,34))
  call check_last_AQ_V(l_switch,G3(:,:,:,34),wf(:,-1),G3tensor(:,17))
  call loop_AV_Q(G2(:,:,:,30),wf(:,77),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,62),MT,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,0),G3tensor(:,18))
  call loop_AQ_V(G2(:,:,:,30),wf(:,-1),G2(:,:,:,44))
  call loop_VA_Q(G2(:,:,:,44),wf(:,72),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,62),MT,G3(:,:,:,36))
  call check_last_AQ_V(l_switch,G3(:,:,:,36),wf(:,0),G3tensor(:,19))
  call loop_UV_W(G2(:,:,:,44),Q(:,42),wf(:,-4),Q(:,16),G3(:,:,:,37))
  call loop_VA_Q(G3(:,:,:,37),wf(:,-2),G3(:,:,:,38))
  call loop_A_Q(G3(:,:,:,38),Q(:,62),MT,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,12))
  call loop_VA_Q(G2(:,:,:,44),wf(:,-2),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,46),MT,G3(:,:,:,39))
  call loop_AV_Q(G3(:,:,:,39),wf(:,-4),G3(:,:,:,40))
  call loop_A_Q(G3(:,:,:,40),Q(:,62),MT,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,13))
  call loop_AQ_V(G1(:,:,:,1),wf(:,19),G1(:,:,:,24))
  call loop_UV_W(G1(:,:,:,24),Q(:,26),wf(:,-5),Q(:,32),G2(:,:,:,47))
  call check_last_UV_W(l_switch,G2(:,:,:,47),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,20))
  call loop_VA_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,62),MT,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,21))
  call loop_VQ_A(G1(:,:,:,24),wf(:,55),G1(:,:,:,25))
  call loop_Q_A(G1(:,:,:,25),Q(:,59),MT,G2(:,:,:,49))
  call check_last_QA_V(l_switch,G2(:,:,:,49),wf(:,-2),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,24),wf(:,66),G1(:,:,:,26))
  call loop_A_Q(G1(:,:,:,26),Q(:,62),MT,G2(:,:,:,50))
  call check_last_AQ_V(l_switch,G2(:,:,:,50),wf(:,0),G2tensor(:,16))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-2),G1(:,:,:,27))
  call loop_A_Q(G1(:,:,:,27),Q(:,30),MT,G2(:,:,:,51))
  call loop_AV_Q(G2(:,:,:,51),wf(:,-5),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,62),MT,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,22))
  call loop_AQ_V(G1(:,:,:,1),wf(:,134),G1(:,:,:,28))
  call check_last_UV_W(l_switch,G1(:,:,:,28),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,28),wf(:,-2),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,62),MT,G2(:,:,:,53))
  call check_last_AQ_V(l_switch,G2(:,:,:,53),wf(:,0),G2tensor(:,18))
  call loop_AV_Q(G1(:,:,:,1),wf(:,-4),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,24),MT,G2(:,:,:,54))
  call loop_AQ_V(G2(:,:,:,54),wf(:,28),G2(:,:,:,55))
  call check_last_UV_W(l_switch,G2(:,:,:,55),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,23))
  call loop_VA_Q(G2(:,:,:,55),wf(:,-2),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,62),MT,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,24))
  call loop_AV_Q(G2(:,:,:,54),wf(:,-5),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,56),MT,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,33),G3tensor(:,25))
  call loop_AV_Q(G3(:,:,:,44),wf(:,1),G3(:,:,:,45))
  call loop_A_Q(G3(:,:,:,45),Q(:,61),MT,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,-1),G4tensor(:,14))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,58),G3tensor(:,26))
  call loop_AV_Q(G3(:,:,:,44),wf(:,7),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,62),MT,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,0),G4tensor(:,15))
  call loop_AQ_V(G3(:,:,:,44),wf(:,-1),G3(:,:,:,47))
  call loop_VA_Q(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,62),MT,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,16))
  call loop_AV_Q(G2(:,:,:,54),wf(:,16),G2(:,:,:,58))
  call loop_A_Q(G2(:,:,:,58),Q(:,61),MT,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,-1),G3tensor(:,27))
  call loop_AV_Q(G2(:,:,:,54),wf(:,1),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,29),MT,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-5),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,61),MT,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,-1),G4tensor(:,17))
  call loop_AQ_V(G2(:,:,:,54),wf(:,55),G2(:,:,:,60))
  call check_last_UV_W(l_switch,G2(:,:,:,60),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,28))
  call loop_VA_Q(G2(:,:,:,60),wf(:,-2),G2(:,:,:,61))
  call loop_A_Q(G2(:,:,:,61),Q(:,61),MT,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,-1),G3tensor(:,29))
  call loop_AV_Q(G2(:,:,:,54),wf(:,44),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,62),MT,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,30))
  call loop_AV_Q(G2(:,:,:,54),wf(:,7),G2(:,:,:,63))
  call loop_A_Q(G2(:,:,:,63),Q(:,30),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-5),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,62),MT,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,0),G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,54),wf(:,90),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,61),MT,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,-1),G3tensor(:,31))
  call loop_AV_Q(G2(:,:,:,54),wf(:,78),G2(:,:,:,65))
  call loop_A_Q(G2(:,:,:,65),Q(:,62),MT,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,32))
  call loop_AV_Q(G2(:,:,:,54),wf(:,91),G2(:,:,:,66))
  call loop_A_Q(G2(:,:,:,66),Q(:,61),MT,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,-1),G3tensor(:,33))
  call loop_AV_Q(G2(:,:,:,54),wf(:,80),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,62),MT,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,0),G3tensor(:,34))
  call loop_AQ_V(G2(:,:,:,54),wf(:,-1),G2(:,:,:,68))
  call loop_VA_Q(G2(:,:,:,68),wf(:,66),G2(:,:,:,69))
  call loop_A_Q(G2(:,:,:,69),Q(:,62),MT,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,0),G3tensor(:,35))
  call loop_UV_W(G2(:,:,:,68),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,61))
  call loop_VA_Q(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,62),MT,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,0),G4tensor(:,19))
  call loop_VA_Q(G2(:,:,:,68),wf(:,-2),G2(:,:,:,70))
  call loop_A_Q(G2(:,:,:,70),Q(:,30),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,62),MT,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,0),G4tensor(:,20))
  call loop_AQ_V(G1(:,:,:,1),wf(:,28),G1(:,:,:,31))
  call loop_UV_W(G1(:,:,:,31),Q(:,42),wf(:,-4),Q(:,16),G2(:,:,:,71))
  call check_last_UV_W(l_switch,G2(:,:,:,71),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,36))
  call loop_VA_Q(G2(:,:,:,71),wf(:,-2),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,62),MT,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,0),G3tensor(:,37))
  call loop_VQ_A(G1(:,:,:,31),wf(:,48),G1(:,:,:,32))
  call loop_Q_A(G1(:,:,:,32),Q(:,59),MT,G2(:,:,:,73))
  call check_last_QA_V(l_switch,G2(:,:,:,73),wf(:,-2),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,31),wf(:,72),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,62),MT,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,0),G2tensor(:,20))
  call loop_VA_Q(G1(:,:,:,31),wf(:,-2),G1(:,:,:,34))
  call loop_A_Q(G1(:,:,:,34),Q(:,46),MT,G2(:,:,:,75))
  call loop_AV_Q(G2(:,:,:,75),wf(:,-4),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,62),MT,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,0),G3tensor(:,38))
  call loop_AV_Q(G1(:,:,:,1),wf(:,11),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,56),MT,G2(:,:,:,77))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,33),G2tensor(:,21))
  call loop_AV_Q(G2(:,:,:,77),wf(:,1),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,61),MT,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,-1),G3tensor(:,39))
  call check_last_AQ_V(l_switch,G2(:,:,:,77),wf(:,58),G2tensor(:,22))
  call loop_AV_Q(G2(:,:,:,77),wf(:,7),G2(:,:,:,79))
  call loop_A_Q(G2(:,:,:,79),Q(:,62),MT,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,0),G3tensor(:,40))
  call loop_AQ_V(G2(:,:,:,77),wf(:,-1),G2(:,:,:,80))
  call loop_VA_Q(G2(:,:,:,80),wf(:,-2),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,62),MT,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,0),G3tensor(:,41))
  call loop_AQ_V(G1(:,:,:,1),wf(:,41),G1(:,:,:,36))
  call check_last_UV_W(l_switch,G1(:,:,:,36),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,36),wf(:,-2),G1(:,:,:,37))
  call loop_A_Q(G1(:,:,:,37),Q(:,62),MT,G2(:,:,:,82))
  call check_last_AQ_V(l_switch,G2(:,:,:,82),wf(:,0),G2tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,274),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,61),MT,G2(:,:,:,83))
  call check_last_AQ_V(l_switch,G2(:,:,:,83),wf(:,-1),G2tensor(:,25))
  call loop_AV_Q(G1(:,:,:,1),wf(:,1),G1(:,:,:,39))
  call loop_A_Q(G1(:,:,:,39),Q(:,13),MT,G2(:,:,:,84))
  call loop_AV_Q(G2(:,:,:,84),wf(:,11),G2(:,:,:,85))
  call loop_A_Q(G2(:,:,:,85),Q(:,61),MT,G3(:,:,:,70))
  call check_last_AQ_V(l_switch,G3(:,:,:,70),wf(:,-1),G3tensor(:,42))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-5),G2(:,:,:,86))
  call loop_A_Q(G2(:,:,:,86),Q(:,45),MT,G3(:,:,:,71))
  call loop_AV_Q(G3(:,:,:,71),wf(:,-4),G3(:,:,:,72))
  call loop_A_Q(G3(:,:,:,72),Q(:,61),MT,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,-1),G4tensor(:,21))
  call loop_AV_Q(G2(:,:,:,84),wf(:,-4),G2(:,:,:,87))
  call loop_A_Q(G2(:,:,:,87),Q(:,29),MT,G3(:,:,:,73))
  call loop_AV_Q(G3(:,:,:,73),wf(:,-5),G3(:,:,:,74))
  call loop_A_Q(G3(:,:,:,74),Q(:,61),MT,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,-1),G4tensor(:,22))
  call loop_AV_Q(G1(:,:,:,1),wf(:,414),G1(:,:,:,40))
  call loop_A_Q(G1(:,:,:,40),Q(:,61),MT,G2(:,:,:,88))
  call check_last_AQ_V(l_switch,G2(:,:,:,88),wf(:,-1),G2tensor(:,26))
  call loop_AV_Q(G1(:,:,:,1),wf(:,13),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,29),MT,G2(:,:,:,89))
  call loop_AV_Q(G2(:,:,:,89),wf(:,-5),G2(:,:,:,90))
  call loop_A_Q(G2(:,:,:,90),Q(:,61),MT,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,-1),G3tensor(:,43))
  call loop_AV_Q(G1(:,:,:,1),wf(:,419),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,61),MT,G2(:,:,:,91))
  call check_last_AQ_V(l_switch,G2(:,:,:,91),wf(:,-1),G2tensor(:,27))
  call loop_AV_Q(G1(:,:,:,1),wf(:,16),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,45),MT,G2(:,:,:,92))
  call loop_AV_Q(G2(:,:,:,92),wf(:,-4),G2(:,:,:,93))
  call loop_A_Q(G2(:,:,:,93),Q(:,61),MT,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,-1),G3tensor(:,44))
  call loop_AQ_V(G1(:,:,:,1),wf(:,159),G1(:,:,:,44))
  call check_last_UV_W(l_switch,G1(:,:,:,44),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,28))
  call loop_VA_Q(G1(:,:,:,44),wf(:,-2),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,61),MT,G2(:,:,:,94))
  call check_last_AQ_V(l_switch,G2(:,:,:,94),wf(:,-1),G2tensor(:,29))
  call loop_AQ_V(G1(:,:,:,1),wf(:,48),G1(:,:,:,46))
  call loop_UV_W(G1(:,:,:,46),Q(:,25),wf(:,-5),Q(:,32),G2(:,:,:,95))
  call check_last_UV_W(l_switch,G2(:,:,:,95),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,45))
  call loop_VA_Q(G2(:,:,:,95),wf(:,-2),G2(:,:,:,96))
  call loop_A_Q(G2(:,:,:,96),Q(:,61),MT,G3(:,:,:,77))
  call check_last_AQ_V(l_switch,G3(:,:,:,77),wf(:,-1),G3tensor(:,46))
  call loop_VQ_A(G1(:,:,:,46),wf(:,28),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,59),MT,G2(:,:,:,97))
  call check_last_QA_V(l_switch,G2(:,:,:,97),wf(:,-2),G2tensor(:,30))
  call loop_VA_Q(G1(:,:,:,46),wf(:,66),G1(:,:,:,48))
  call loop_A_Q(G1(:,:,:,48),Q(:,61),MT,G2(:,:,:,98))
  call check_last_AQ_V(l_switch,G2(:,:,:,98),wf(:,-1),G2tensor(:,31))
  call loop_VA_Q(G1(:,:,:,46),wf(:,-2),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,29),MT,G2(:,:,:,99))
  call loop_AV_Q(G2(:,:,:,99),wf(:,-5),G2(:,:,:,100))
  call loop_A_Q(G2(:,:,:,100),Q(:,61),MT,G3(:,:,:,78))
  call check_last_AQ_V(l_switch,G3(:,:,:,78),wf(:,-1),G3tensor(:,47))
  call loop_AQ_V(G1(:,:,:,1),wf(:,161),G1(:,:,:,50))
  call check_last_UV_W(l_switch,G1(:,:,:,50),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,32))
  call loop_VA_Q(G1(:,:,:,50),wf(:,-2),G1(:,:,:,51))
  call loop_A_Q(G1(:,:,:,51),Q(:,61),MT,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,-1),G2tensor(:,33))
  call loop_AQ_V(G1(:,:,:,1),wf(:,55),G1(:,:,:,52))
  call loop_UV_W(G1(:,:,:,52),Q(:,41),wf(:,-4),Q(:,16),G2(:,:,:,102))
  call check_last_UV_W(l_switch,G2(:,:,:,102),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,48))
  call loop_VA_Q(G2(:,:,:,102),wf(:,-2),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,61),MT,G3(:,:,:,79))
  call check_last_AQ_V(l_switch,G3(:,:,:,79),wf(:,-1),G3tensor(:,49))
  call loop_VQ_A(G1(:,:,:,52),wf(:,19),G1(:,:,:,53))
  call loop_Q_A(G1(:,:,:,53),Q(:,59),MT,G2(:,:,:,104))
  call check_last_QA_V(l_switch,G2(:,:,:,104),wf(:,-2),G2tensor(:,34))
  call loop_VA_Q(G1(:,:,:,52),wf(:,72),G1(:,:,:,54))
  call loop_A_Q(G1(:,:,:,54),Q(:,61),MT,G2(:,:,:,105))
  call check_last_AQ_V(l_switch,G2(:,:,:,105),wf(:,-1),G2tensor(:,35))
  call loop_VA_Q(G1(:,:,:,52),wf(:,-2),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,45),MT,G2(:,:,:,106))
  call loop_AV_Q(G2(:,:,:,106),wf(:,-4),G2(:,:,:,107))
  call loop_A_Q(G2(:,:,:,107),Q(:,61),MT,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,-1),G3tensor(:,50))
  call loop_AQ_V(G1(:,:,:,1),wf(:,64),G1(:,:,:,56))
  call check_last_UV_W(l_switch,G1(:,:,:,56),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,36))
  call loop_VA_Q(G1(:,:,:,56),wf(:,-2),G1(:,:,:,57))
  call loop_A_Q(G1(:,:,:,57),Q(:,61),MT,G2(:,:,:,108))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,-1),G2tensor(:,37))
  call loop_AV_Q(G1(:,:,:,1),wf(:,317),G1(:,:,:,58))
  call loop_A_Q(G1(:,:,:,58),Q(:,62),MT,G2(:,:,:,109))
  call check_last_AQ_V(l_switch,G2(:,:,:,109),wf(:,0),G2tensor(:,38))
  call loop_AV_Q(G1(:,:,:,1),wf(:,7),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,14),MT,G2(:,:,:,110))
  call loop_AV_Q(G2(:,:,:,110),wf(:,11),G2(:,:,:,111))
  call loop_A_Q(G2(:,:,:,111),Q(:,62),MT,G3(:,:,:,81))
  call check_last_AQ_V(l_switch,G3(:,:,:,81),wf(:,0),G3tensor(:,51))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-5),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,46),MT,G3(:,:,:,82))
  call loop_AV_Q(G3(:,:,:,82),wf(:,-4),G3(:,:,:,83))
  call loop_A_Q(G3(:,:,:,83),Q(:,62),MT,G4(:,:,:,23))
  call check_last_AQ_V(l_switch,G4(:,:,:,23),wf(:,0),G4tensor(:,23))
  call loop_AV_Q(G2(:,:,:,110),wf(:,-4),G2(:,:,:,113))
  call loop_A_Q(G2(:,:,:,113),Q(:,30),MT,G3(:,:,:,84))
  call loop_AV_Q(G3(:,:,:,84),wf(:,-5),G3(:,:,:,85))
  call loop_A_Q(G3(:,:,:,85),Q(:,62),MT,G4(:,:,:,24))
  call check_last_AQ_V(l_switch,G4(:,:,:,24),wf(:,0),G4tensor(:,24))
  call loop_AV_Q(G1(:,:,:,1),wf(:,436),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,62),MT,G2(:,:,:,114))
  call check_last_AQ_V(l_switch,G2(:,:,:,114),wf(:,0),G2tensor(:,39))
  call loop_AV_Q(G1(:,:,:,1),wf(:,45),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,30),MT,G2(:,:,:,115))
  call loop_AV_Q(G2(:,:,:,115),wf(:,-5),G2(:,:,:,116))
  call loop_A_Q(G2(:,:,:,116),Q(:,62),MT,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,0),G3tensor(:,52))
  call loop_AV_Q(G1(:,:,:,1),wf(:,439),G1(:,:,:,62))
  call loop_A_Q(G1(:,:,:,62),Q(:,62),MT,G2(:,:,:,117))
  call check_last_AQ_V(l_switch,G2(:,:,:,117),wf(:,0),G2tensor(:,40))
  call loop_AV_Q(G1(:,:,:,1),wf(:,44),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,46),MT,G2(:,:,:,118))
  call loop_AV_Q(G2(:,:,:,118),wf(:,-4),G2(:,:,:,119))
  call loop_A_Q(G2(:,:,:,119),Q(:,62),MT,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,0),G3tensor(:,53))
  call loop_AV_Q(G1(:,:,:,1),wf(:,382),G1(:,:,:,64))
  call loop_A_Q(G1(:,:,:,64),Q(:,61),MT,G2(:,:,:,120))
  call check_last_AQ_V(l_switch,G2(:,:,:,120),wf(:,-1),G2tensor(:,41))
  call loop_AV_Q(G1(:,:,:,1),wf(:,484),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,61),MT,G2(:,:,:,121))
  call check_last_AQ_V(l_switch,G2(:,:,:,121),wf(:,-1),G2tensor(:,42))
  call loop_AV_Q(G1(:,:,:,1),wf(:,83),G1(:,:,:,66))
  call loop_A_Q(G1(:,:,:,66),Q(:,29),MT,G2(:,:,:,122))
  call loop_AV_Q(G2(:,:,:,122),wf(:,-5),G2(:,:,:,123))
  call loop_A_Q(G2(:,:,:,123),Q(:,61),MT,G3(:,:,:,88))
  call check_last_AQ_V(l_switch,G3(:,:,:,88),wf(:,-1),G3tensor(:,54))
  call loop_AV_Q(G1(:,:,:,1),wf(:,490),G1(:,:,:,67))
  call loop_A_Q(G1(:,:,:,67),Q(:,61),MT,G2(:,:,:,124))
  call check_last_AQ_V(l_switch,G2(:,:,:,124),wf(:,-1),G2tensor(:,43))
  call loop_AV_Q(G1(:,:,:,1),wf(:,353),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,62),MT,G2(:,:,:,125))
  call check_last_AQ_V(l_switch,G2(:,:,:,125),wf(:,0),G2tensor(:,44))
  call loop_AV_Q(G1(:,:,:,1),wf(:,498),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,126))
  call check_last_AQ_V(l_switch,G2(:,:,:,126),wf(:,0),G2tensor(:,45))
  call loop_AV_Q(G1(:,:,:,1),wf(:,70),G1(:,:,:,70))
  call loop_A_Q(G1(:,:,:,70),Q(:,30),MT,G2(:,:,:,127))
  call loop_AV_Q(G2(:,:,:,127),wf(:,-5),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,62),MT,G3(:,:,:,89))
  call check_last_AQ_V(l_switch,G3(:,:,:,89),wf(:,0),G3tensor(:,55))
  call loop_AV_Q(G1(:,:,:,1),wf(:,502),G1(:,:,:,71))
  call loop_A_Q(G1(:,:,:,71),Q(:,62),MT,G2(:,:,:,129))
  call check_last_AQ_V(l_switch,G2(:,:,:,129),wf(:,0),G2tensor(:,46))
  call loop_AV_Q(G1(:,:,:,1),wf(:,390),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,61),MT,G2(:,:,:,130))
  call check_last_AQ_V(l_switch,G2(:,:,:,130),wf(:,-1),G2tensor(:,47))
  call loop_AV_Q(G1(:,:,:,1),wf(:,362),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,131))
  call check_last_AQ_V(l_switch,G2(:,:,:,131),wf(:,0),G2tensor(:,48))
  call loop_AV_Q(G1(:,:,:,1),wf(:,510),G1(:,:,:,74))
  call loop_A_Q(G1(:,:,:,74),Q(:,61),MT,G2(:,:,:,132))
  call check_last_AQ_V(l_switch,G2(:,:,:,132),wf(:,-1),G2tensor(:,49))
  call loop_AV_Q(G1(:,:,:,1),wf(:,89),G1(:,:,:,75))
  call loop_A_Q(G1(:,:,:,75),Q(:,29),MT,G2(:,:,:,133))
  call loop_AV_Q(G2(:,:,:,133),wf(:,-5),G2(:,:,:,134))
  call loop_A_Q(G2(:,:,:,134),Q(:,61),MT,G3(:,:,:,90))
  call check_last_AQ_V(l_switch,G3(:,:,:,90),wf(:,-1),G3tensor(:,56))
  call loop_AV_Q(G1(:,:,:,1),wf(:,511),G1(:,:,:,76))
  call loop_A_Q(G1(:,:,:,76),Q(:,61),MT,G2(:,:,:,135))
  call check_last_AQ_V(l_switch,G2(:,:,:,135),wf(:,-1),G2tensor(:,50))
  call loop_AV_Q(G1(:,:,:,1),wf(:,514),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,62),MT,G2(:,:,:,136))
  call check_last_AQ_V(l_switch,G2(:,:,:,136),wf(:,0),G2tensor(:,51))
  call loop_AV_Q(G1(:,:,:,1),wf(:,77),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,30),MT,G2(:,:,:,137))
  call loop_AV_Q(G2(:,:,:,137),wf(:,-5),G2(:,:,:,138))
  call loop_A_Q(G2(:,:,:,138),Q(:,62),MT,G3(:,:,:,91))
  call check_last_AQ_V(l_switch,G3(:,:,:,91),wf(:,0),G3tensor(:,57))
  call loop_AV_Q(G1(:,:,:,1),wf(:,515),G1(:,:,:,79))
  call loop_A_Q(G1(:,:,:,79),Q(:,62),MT,G2(:,:,:,139))
  call check_last_AQ_V(l_switch,G2(:,:,:,139),wf(:,0),G2tensor(:,52))
  call loop_AV_Q(G1(:,:,:,1),wf(:,532),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,61),MT,G2(:,:,:,140))
  call check_last_AQ_V(l_switch,G2(:,:,:,140),wf(:,-1),G2tensor(:,53))
  call loop_AV_Q(G1(:,:,:,1),wf(:,90),G1(:,:,:,81))
  call loop_A_Q(G1(:,:,:,81),Q(:,45),MT,G2(:,:,:,141))
  call loop_AV_Q(G2(:,:,:,141),wf(:,-4),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,61),MT,G3(:,:,:,92))
  call check_last_AQ_V(l_switch,G3(:,:,:,92),wf(:,-1),G3tensor(:,58))
  call loop_AV_Q(G1(:,:,:,1),wf(:,538),G1(:,:,:,82))
  call loop_A_Q(G1(:,:,:,82),Q(:,61),MT,G2(:,:,:,143))
  call check_last_AQ_V(l_switch,G2(:,:,:,143),wf(:,-1),G2tensor(:,54))
  call loop_AV_Q(G1(:,:,:,1),wf(:,546),G1(:,:,:,83))
  call loop_A_Q(G1(:,:,:,83),Q(:,62),MT,G2(:,:,:,144))
  call check_last_AQ_V(l_switch,G2(:,:,:,144),wf(:,0),G2tensor(:,55))
  call loop_AV_Q(G1(:,:,:,1),wf(:,78),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,46),MT,G2(:,:,:,145))
  call loop_AV_Q(G2(:,:,:,145),wf(:,-4),G2(:,:,:,146))
  call loop_A_Q(G2(:,:,:,146),Q(:,62),MT,G3(:,:,:,93))
  call check_last_AQ_V(l_switch,G3(:,:,:,93),wf(:,0),G3tensor(:,59))
  call loop_AV_Q(G1(:,:,:,1),wf(:,550),G1(:,:,:,85))
  call loop_A_Q(G1(:,:,:,85),Q(:,62),MT,G2(:,:,:,147))
  call check_last_AQ_V(l_switch,G2(:,:,:,147),wf(:,0),G2tensor(:,56))
  call loop_AV_Q(G1(:,:,:,1),wf(:,558),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,61),MT,G2(:,:,:,148))
  call check_last_AQ_V(l_switch,G2(:,:,:,148),wf(:,-1),G2tensor(:,57))
  call loop_AV_Q(G1(:,:,:,1),wf(:,91),G1(:,:,:,87))
  call loop_A_Q(G1(:,:,:,87),Q(:,45),MT,G2(:,:,:,149))
  call loop_AV_Q(G2(:,:,:,149),wf(:,-4),G2(:,:,:,150))
  call loop_A_Q(G2(:,:,:,150),Q(:,61),MT,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,-1),G3tensor(:,60))
  call loop_AV_Q(G1(:,:,:,1),wf(:,559),G1(:,:,:,88))
  call loop_A_Q(G1(:,:,:,88),Q(:,61),MT,G2(:,:,:,151))
  call check_last_AQ_V(l_switch,G2(:,:,:,151),wf(:,-1),G2tensor(:,58))
  call loop_AV_Q(G1(:,:,:,1),wf(:,562),G1(:,:,:,89))
  call loop_A_Q(G1(:,:,:,89),Q(:,62),MT,G2(:,:,:,152))
  call check_last_AQ_V(l_switch,G2(:,:,:,152),wf(:,0),G2tensor(:,59))
  call loop_AV_Q(G1(:,:,:,1),wf(:,80),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,46),MT,G2(:,:,:,153))
  call loop_AV_Q(G2(:,:,:,153),wf(:,-4),G2(:,:,:,154))
  call loop_A_Q(G2(:,:,:,154),Q(:,62),MT,G3(:,:,:,95))
  call check_last_AQ_V(l_switch,G3(:,:,:,95),wf(:,0),G3tensor(:,61))
  call loop_AV_Q(G1(:,:,:,1),wf(:,563),G1(:,:,:,91))
  call loop_A_Q(G1(:,:,:,91),Q(:,62),MT,G2(:,:,:,155))
  call check_last_AQ_V(l_switch,G2(:,:,:,155),wf(:,0),G2tensor(:,60))
  call loop_AV_Q(G1(:,:,:,1),wf(:,576),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,61),MT,G2(:,:,:,156))
  call check_last_AQ_V(l_switch,G2(:,:,:,156),wf(:,-1),G2tensor(:,61))
  call loop_AV_Q(G1(:,:,:,1),wf(:,577),G1(:,:,:,93))
  call loop_A_Q(G1(:,:,:,93),Q(:,61),MT,G2(:,:,:,157))
  call check_last_AQ_V(l_switch,G2(:,:,:,157),wf(:,-1),G2tensor(:,62))
  call loop_AV_Q(G1(:,:,:,1),wf(:,580),G1(:,:,:,94))
  call loop_A_Q(G1(:,:,:,94),Q(:,62),MT,G2(:,:,:,158))
  call check_last_AQ_V(l_switch,G2(:,:,:,158),wf(:,0),G2tensor(:,63))
  call loop_AV_Q(G1(:,:,:,1),wf(:,581),G1(:,:,:,95))
  call loop_A_Q(G1(:,:,:,95),Q(:,62),MT,G2(:,:,:,159))
  call check_last_AQ_V(l_switch,G2(:,:,:,159),wf(:,0),G2tensor(:,64))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,53),G1(:,:,:,96))
  call loop_VA_Q(G1(:,:,:,96),wf(:,-3),G1(:,:,:,97))
  call loop_A_Q(G1(:,:,:,97),Q(:,61),MT,G2(:,:,:,160))
  call check_last_AQ_V(l_switch,G2(:,:,:,160),wf(:,-1),G2tensor(:,65))
  call check_last_UV_W(l_switch,G1(:,:,:,96),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,66))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,4),Q(:,53),G1(:,:,:,98))
  call loop_VA_Q(G1(:,:,:,98),wf(:,-3),G1(:,:,:,99))
  call loop_A_Q(G1(:,:,:,99),Q(:,61),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,-1),G2tensor(:,67))
  call check_last_UV_W(l_switch,G1(:,:,:,98),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,68))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,5),Q(:,53),G1(:,:,:,100))
  call loop_VA_Q(G1(:,:,:,100),wf(:,-3),G1(:,:,:,101))
  call loop_A_Q(G1(:,:,:,101),Q(:,61),MT,G2(:,:,:,162))
  call check_last_AQ_V(l_switch,G2(:,:,:,162),wf(:,-1),G2tensor(:,69))
  call check_last_UV_W(l_switch,G1(:,:,:,100),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,70))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,7),G0(:,:,:,3))
  call loop_UV_W(G0(:,:,:,3),Q(:,22),wf(:,-5),Q(:,32),G1(:,:,:,102))
  call check_last_UV_W(l_switch,G1(:,:,:,102),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,71))
  call loop_VA_Q(G1(:,:,:,102),wf(:,-3),G1(:,:,:,103))
  call loop_A_Q(G1(:,:,:,103),Q(:,62),MT,G2(:,:,:,163))
  call check_last_AQ_V(l_switch,G2(:,:,:,163),wf(:,0),G2tensor(:,72))
  call loop_VQ_A(G0(:,:,:,3),wf(:,55),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,55),MT,G1(:,:,:,104))
  call check_last_QA_V(l_switch,G1(:,:,:,104),wf(:,-3),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,3),wf(:,20),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,62),MT,G1(:,:,:,105))
  call check_last_AQ_V(l_switch,G1(:,:,:,105),wf(:,0),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,3),wf(:,-3),G0(:,:,:,6))
  call loop_A_Q(G0(:,:,:,6),Q(:,30),MT,G1(:,:,:,106))
  call loop_AV_Q(G1(:,:,:,106),wf(:,-5),G1(:,:,:,107))
  call loop_A_Q(G1(:,:,:,107),Q(:,62),MT,G2(:,:,:,164))
  call check_last_AQ_V(l_switch,G2(:,:,:,164),wf(:,0),G2tensor(:,73))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,-4),G0(:,:,:,7))
  call loop_UV_W(G0(:,:,:,7),Q(:,22),wf(:,-5),Q(:,32),G1(:,:,:,108))
  call check_last_UV_W(l_switch,G1(:,:,:,108),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,74))
  call loop_VA_Q(G1(:,:,:,108),wf(:,-3),G1(:,:,:,109))
  call loop_A_Q(G1(:,:,:,109),Q(:,62),MT,G2(:,:,:,165))
  call check_last_AQ_V(l_switch,G2(:,:,:,165),wf(:,0),G2tensor(:,75))
  call loop_VQ_A(G0(:,:,:,7),wf(:,55),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,55),MT,G1(:,:,:,110))
  call check_last_QA_V(l_switch,G1(:,:,:,110),wf(:,-3),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,7),wf(:,20),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,62),MT,G1(:,:,:,111))
  call check_last_AQ_V(l_switch,G1(:,:,:,111),wf(:,0),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,7),wf(:,-3),G0(:,:,:,10))
  call loop_A_Q(G0(:,:,:,10),Q(:,30),MT,G1(:,:,:,112))
  call loop_AV_Q(G1(:,:,:,112),wf(:,-5),G1(:,:,:,113))
  call loop_A_Q(G1(:,:,:,113),Q(:,62),MT,G2(:,:,:,166))
  call check_last_AQ_V(l_switch,G2(:,:,:,166),wf(:,0),G2tensor(:,76))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,7),G0(:,:,:,11))
  call loop_UV_W(G0(:,:,:,11),Q(:,22),wf(:,-5),Q(:,32),G1(:,:,:,114))
  call check_last_UV_W(l_switch,G1(:,:,:,114),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,77))
  call loop_VA_Q(G1(:,:,:,114),wf(:,-3),G1(:,:,:,115))
  call loop_A_Q(G1(:,:,:,115),Q(:,62),MT,G2(:,:,:,167))
  call check_last_AQ_V(l_switch,G2(:,:,:,167),wf(:,0),G2tensor(:,78))
  call loop_VQ_A(G0(:,:,:,11),wf(:,55),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,55),MT,G1(:,:,:,116))
  call check_last_QA_V(l_switch,G1(:,:,:,116),wf(:,-3),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,11),wf(:,20),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,62),MT,G1(:,:,:,117))
  call check_last_AQ_V(l_switch,G1(:,:,:,117),wf(:,0),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,11),wf(:,-3),G0(:,:,:,14))
  call loop_A_Q(G0(:,:,:,14),Q(:,30),MT,G1(:,:,:,118))
  call loop_AV_Q(G1(:,:,:,118),wf(:,-5),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,168))
  call check_last_AQ_V(l_switch,G2(:,:,:,168),wf(:,0),G2tensor(:,79))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,6),G0(:,:,:,15))
  call loop_UV_W(G0(:,:,:,15),Q(:,25),wf(:,-5),Q(:,32),G1(:,:,:,120))
  call check_last_UV_W(l_switch,G1(:,:,:,120),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,80))
  call loop_VA_Q(G1(:,:,:,120),wf(:,-2),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,61),MT,G2(:,:,:,169))
  call check_last_AQ_V(l_switch,G2(:,:,:,169),wf(:,-1),G2tensor(:,81))
  call loop_VQ_A(G0(:,:,:,15),wf(:,28),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,59),MT,G1(:,:,:,122))
  call check_last_QA_V(l_switch,G1(:,:,:,122),wf(:,-2),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,15),wf(:,66),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,61),MT,G1(:,:,:,123))
  call check_last_AQ_V(l_switch,G1(:,:,:,123),wf(:,-1),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,15),wf(:,-2),G0(:,:,:,18))
  call loop_A_Q(G0(:,:,:,18),Q(:,29),MT,G1(:,:,:,124))
  call loop_AV_Q(G1(:,:,:,124),wf(:,-5),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,61),MT,G2(:,:,:,170))
  call check_last_AQ_V(l_switch,G2(:,:,:,170),wf(:,-1),G2tensor(:,82))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-4),G0(:,:,:,19))
  call loop_UV_W(G0(:,:,:,19),Q(:,25),wf(:,-5),Q(:,32),G1(:,:,:,126))
  call check_last_UV_W(l_switch,G1(:,:,:,126),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,83))
  call loop_VA_Q(G1(:,:,:,126),wf(:,-2),G1(:,:,:,127))
  call loop_A_Q(G1(:,:,:,127),Q(:,61),MT,G2(:,:,:,171))
  call check_last_AQ_V(l_switch,G2(:,:,:,171),wf(:,-1),G2tensor(:,84))
  call loop_VQ_A(G0(:,:,:,19),wf(:,28),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,59),MT,G1(:,:,:,128))
  call check_last_QA_V(l_switch,G1(:,:,:,128),wf(:,-2),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,19),wf(:,66),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,61),MT,G1(:,:,:,129))
  call check_last_AQ_V(l_switch,G1(:,:,:,129),wf(:,-1),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,19),wf(:,-2),G0(:,:,:,22))
  call loop_A_Q(G0(:,:,:,22),Q(:,29),MT,G1(:,:,:,130))
  call loop_AV_Q(G1(:,:,:,130),wf(:,-5),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,61),MT,G2(:,:,:,172))
  call check_last_AQ_V(l_switch,G2(:,:,:,172),wf(:,-1),G2tensor(:,85))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,6),G0(:,:,:,23))
  call loop_UV_W(G0(:,:,:,23),Q(:,25),wf(:,-5),Q(:,32),G1(:,:,:,132))
  call check_last_UV_W(l_switch,G1(:,:,:,132),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,86))
  call loop_VA_Q(G1(:,:,:,132),wf(:,-2),G1(:,:,:,133))
  call loop_A_Q(G1(:,:,:,133),Q(:,61),MT,G2(:,:,:,173))
  call check_last_AQ_V(l_switch,G2(:,:,:,173),wf(:,-1),G2tensor(:,87))
  call loop_VQ_A(G0(:,:,:,23),wf(:,28),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,59),MT,G1(:,:,:,134))
  call check_last_QA_V(l_switch,G1(:,:,:,134),wf(:,-2),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,23),wf(:,66),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,61),MT,G1(:,:,:,135))
  call check_last_AQ_V(l_switch,G1(:,:,:,135),wf(:,-1),G1tensor(:,12))
  call loop_VA_Q(G0(:,:,:,23),wf(:,-2),G0(:,:,:,26))
  call loop_A_Q(G0(:,:,:,26),Q(:,29),MT,G1(:,:,:,136))
  call loop_AV_Q(G1(:,:,:,136),wf(:,-5),G1(:,:,:,137))
  call loop_A_Q(G1(:,:,:,137),Q(:,61),MT,G2(:,:,:,174))
  call check_last_AQ_V(l_switch,G2(:,:,:,174),wf(:,-1),G2tensor(:,88))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,6),Q(:,9),G1(:,:,:,138))
  call loop_GGG_G_12(G1(:,:,:,138),wf(:,-5),wf(:,-4),G1(:,:,:,139))
  call check_last_UV_W(l_switch,G1(:,:,:,139),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,89))
  call loop_VA_Q(G1(:,:,:,139),wf(:,-2),G1(:,:,:,140))
  call loop_A_Q(G1(:,:,:,140),Q(:,61),MT,G2(:,:,:,175))
  call check_last_AQ_V(l_switch,G2(:,:,:,175),wf(:,-1),G2tensor(:,90))
  call loop_GGG_G_12(G1(:,:,:,138),wf(:,-4),wf(:,-5),G1(:,:,:,141))
  call check_last_UV_W(l_switch,G1(:,:,:,141),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,91))
  call loop_VA_Q(G1(:,:,:,141),wf(:,-2),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,61),MT,G2(:,:,:,176))
  call check_last_AQ_V(l_switch,G2(:,:,:,176),wf(:,-1),G2tensor(:,92))
  call loop_GGG_G_23(G1(:,:,:,138),wf(:,-5),wf(:,-4),G1(:,:,:,143))
  call check_last_UV_W(l_switch,G1(:,:,:,143),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,93))
  call loop_VA_Q(G1(:,:,:,143),wf(:,-2),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,61),MT,G2(:,:,:,177))
  call check_last_AQ_V(l_switch,G2(:,:,:,177),wf(:,-1),G2tensor(:,94))
  call loop_UV_W(G1(:,:,:,138),Q(:,9),wf(:,11),Q(:,48),G2(:,:,:,178))
  call check_last_UV_W(l_switch,G2(:,:,:,178),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,62))
  call loop_VA_Q(G2(:,:,:,178),wf(:,-2),G2(:,:,:,179))
  call loop_A_Q(G2(:,:,:,179),Q(:,61),MT,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,-1),G3tensor(:,63))
  call loop_UV_W(G1(:,:,:,138),Q(:,9),wf(:,-4),Q(:,16),G2(:,:,:,180))
  call loop_UV_W(G2(:,:,:,180),Q(:,25),wf(:,-5),Q(:,32),G3(:,:,:,97))
  call check_last_UV_W(l_switch,G3(:,:,:,97),Q(:,57),wf(:,7),Q(:,6),G4tensor(:,25))
  call loop_VA_Q(G3(:,:,:,97),wf(:,-2),G3(:,:,:,98))
  call loop_A_Q(G3(:,:,:,98),Q(:,61),MT,G4(:,:,:,25))
  call check_last_AQ_V(l_switch,G4(:,:,:,25),wf(:,-1),G4tensor(:,26))
  call loop_VQ_A(G2(:,:,:,180),wf(:,28),G2(:,:,:,181))
  call loop_Q_A(G2(:,:,:,181),Q(:,59),MT,G3(:,:,:,99))
  call check_last_QA_V(l_switch,G3(:,:,:,99),wf(:,-2),G3tensor(:,64))
  call loop_VA_Q(G2(:,:,:,180),wf(:,66),G2(:,:,:,182))
  call loop_A_Q(G2(:,:,:,182),Q(:,61),MT,G3(:,:,:,100))
  call check_last_AQ_V(l_switch,G3(:,:,:,100),wf(:,-1),G3tensor(:,65))
  call loop_VA_Q(G2(:,:,:,180),wf(:,-2),G2(:,:,:,183))
  call loop_A_Q(G2(:,:,:,183),Q(:,29),MT,G3(:,:,:,101))
  call loop_AV_Q(G3(:,:,:,101),wf(:,-5),G3(:,:,:,102))
  call loop_A_Q(G3(:,:,:,102),Q(:,61),MT,G4(:,:,:,26))
  call check_last_AQ_V(l_switch,G4(:,:,:,26),wf(:,-1),G4tensor(:,27))
  call loop_UV_W(G1(:,:,:,138),Q(:,9),wf(:,-5),Q(:,32),G2(:,:,:,184))
  call loop_UV_W(G2(:,:,:,184),Q(:,41),wf(:,-4),Q(:,16),G3(:,:,:,103))
  call check_last_UV_W(l_switch,G3(:,:,:,103),Q(:,57),wf(:,7),Q(:,6),G4tensor(:,28))
  call loop_VA_Q(G3(:,:,:,103),wf(:,-2),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,61),MT,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,-1),G4tensor(:,29))
  call loop_VQ_A(G2(:,:,:,184),wf(:,19),G2(:,:,:,185))
  call loop_Q_A(G2(:,:,:,185),Q(:,59),MT,G3(:,:,:,105))
  call check_last_QA_V(l_switch,G3(:,:,:,105),wf(:,-2),G3tensor(:,66))
  call loop_VA_Q(G2(:,:,:,184),wf(:,72),G2(:,:,:,186))
  call loop_A_Q(G2(:,:,:,186),Q(:,61),MT,G3(:,:,:,106))
  call check_last_AQ_V(l_switch,G3(:,:,:,106),wf(:,-1),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,184),wf(:,-2),G2(:,:,:,187))
  call loop_A_Q(G2(:,:,:,187),Q(:,45),MT,G3(:,:,:,107))
  call loop_AV_Q(G3(:,:,:,107),wf(:,-4),G3(:,:,:,108))
  call loop_A_Q(G3(:,:,:,108),Q(:,61),MT,G4(:,:,:,28))
  call check_last_AQ_V(l_switch,G4(:,:,:,28),wf(:,-1),G4tensor(:,30))
  call loop_VQ_A(G1(:,:,:,138),wf(:,130),G1(:,:,:,145))
  call loop_Q_A(G1(:,:,:,145),Q(:,59),MT,G2(:,:,:,188))
  call check_last_QA_V(l_switch,G2(:,:,:,188),wf(:,-2),G2tensor(:,95))
  call loop_VQ_A(G1(:,:,:,138),wf(:,19),G1(:,:,:,146))
  call loop_Q_A(G1(:,:,:,146),Q(:,27),MT,G2(:,:,:,189))
  call loop_QV_A(G2(:,:,:,189),wf(:,-5),G2(:,:,:,190))
  call loop_Q_A(G2(:,:,:,190),Q(:,59),MT,G3(:,:,:,109))
  call check_last_QA_V(l_switch,G3(:,:,:,109),wf(:,-2),G3tensor(:,68))
  call loop_VA_Q(G1(:,:,:,138),wf(:,211),G1(:,:,:,147))
  call loop_A_Q(G1(:,:,:,147),Q(:,61),MT,G2(:,:,:,191))
  call check_last_AQ_V(l_switch,G2(:,:,:,191),wf(:,-1),G2tensor(:,96))
  call loop_VA_Q(G1(:,:,:,138),wf(:,72),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,29),MT,G2(:,:,:,192))
  call loop_AV_Q(G2(:,:,:,192),wf(:,-5),G2(:,:,:,193))
  call loop_A_Q(G2(:,:,:,193),Q(:,61),MT,G3(:,:,:,110))
  call check_last_AQ_V(l_switch,G3(:,:,:,110),wf(:,-1),G3tensor(:,69))
  call loop_VQ_A(G1(:,:,:,138),wf(:,134),G1(:,:,:,149))
  call loop_Q_A(G1(:,:,:,149),Q(:,59),MT,G2(:,:,:,194))
  call check_last_QA_V(l_switch,G2(:,:,:,194),wf(:,-2),G2tensor(:,97))
  call loop_VQ_A(G1(:,:,:,138),wf(:,28),G1(:,:,:,150))
  call loop_Q_A(G1(:,:,:,150),Q(:,43),MT,G2(:,:,:,195))
  call loop_QV_A(G2(:,:,:,195),wf(:,-4),G2(:,:,:,196))
  call loop_Q_A(G2(:,:,:,196),Q(:,59),MT,G3(:,:,:,111))
  call check_last_QA_V(l_switch,G3(:,:,:,111),wf(:,-2),G3tensor(:,70))
  call loop_VA_Q(G1(:,:,:,138),wf(:,214),G1(:,:,:,151))
  call loop_A_Q(G1(:,:,:,151),Q(:,61),MT,G2(:,:,:,197))
  call check_last_AQ_V(l_switch,G2(:,:,:,197),wf(:,-1),G2tensor(:,98))
  call loop_VA_Q(G1(:,:,:,138),wf(:,66),G1(:,:,:,152))
  call loop_A_Q(G1(:,:,:,152),Q(:,45),MT,G2(:,:,:,198))
  call loop_AV_Q(G2(:,:,:,198),wf(:,-4),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,61),MT,G3(:,:,:,112))
  call check_last_AQ_V(l_switch,G3(:,:,:,112),wf(:,-1),G3tensor(:,71))
  call loop_VQ_A(G1(:,:,:,138),wf(:,41),G1(:,:,:,153))
  call loop_Q_A(G1(:,:,:,153),Q(:,59),MT,G2(:,:,:,200))
  call check_last_QA_V(l_switch,G2(:,:,:,200),wf(:,-2),G2tensor(:,99))
  call loop_VA_Q(G1(:,:,:,138),wf(:,215),G1(:,:,:,154))
  call loop_A_Q(G1(:,:,:,154),Q(:,61),MT,G2(:,:,:,201))
  call check_last_AQ_V(l_switch,G2(:,:,:,201),wf(:,-1),G2tensor(:,100))
  call loop_VA_Q(G1(:,:,:,138),wf(:,-2),G1(:,:,:,155))
  call loop_A_Q(G1(:,:,:,155),Q(:,13),MT,G2(:,:,:,202))
  call loop_AV_Q(G2(:,:,:,202),wf(:,11),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,61),MT,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,-1),G3tensor(:,72))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-5),G2(:,:,:,204))
  call loop_A_Q(G2(:,:,:,204),Q(:,45),MT,G3(:,:,:,114))
  call loop_AV_Q(G3(:,:,:,114),wf(:,-4),G3(:,:,:,115))
  call loop_A_Q(G3(:,:,:,115),Q(:,61),MT,G4(:,:,:,29))
  call check_last_AQ_V(l_switch,G4(:,:,:,29),wf(:,-1),G4tensor(:,31))
  call loop_AV_Q(G2(:,:,:,202),wf(:,-4),G2(:,:,:,205))
  call loop_A_Q(G2(:,:,:,205),Q(:,29),MT,G3(:,:,:,116))
  call loop_AV_Q(G3(:,:,:,116),wf(:,-5),G3(:,:,:,117))
  call loop_A_Q(G3(:,:,:,117),Q(:,61),MT,G4(:,:,:,30))
  call check_last_AQ_V(l_switch,G4(:,:,:,30),wf(:,-1),G4tensor(:,32))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,7),G0(:,:,:,27))
  call loop_VQ_A(G0(:,:,:,27),wf(:,48),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,55),MT,G1(:,:,:,156))
  call check_last_QA_V(l_switch,G1(:,:,:,156),wf(:,-3),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,27),wf(:,29),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,62),MT,G1(:,:,:,157))
  call check_last_AQ_V(l_switch,G1(:,:,:,157),wf(:,0),G1tensor(:,14))
  call loop_UV_W(G0(:,:,:,27),Q(:,38),wf(:,-4),Q(:,16),G1(:,:,:,158))
  call loop_VA_Q(G1(:,:,:,158),wf(:,-3),G1(:,:,:,159))
  call loop_A_Q(G1(:,:,:,159),Q(:,62),MT,G2(:,:,:,206))
  call check_last_AQ_V(l_switch,G2(:,:,:,206),wf(:,0),G2tensor(:,101))
  call loop_VA_Q(G0(:,:,:,27),wf(:,-3),G0(:,:,:,30))
  call loop_A_Q(G0(:,:,:,30),Q(:,46),MT,G1(:,:,:,160))
  call loop_AV_Q(G1(:,:,:,160),wf(:,-4),G1(:,:,:,161))
  call loop_A_Q(G1(:,:,:,161),Q(:,62),MT,G2(:,:,:,207))
  call check_last_AQ_V(l_switch,G2(:,:,:,207),wf(:,0),G2tensor(:,102))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,-4),wf(:,6),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,27),wf(:,6),wf(:,-4),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,27),wf(:,-4),wf(:,6),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,38),wf(:,43),Q(:,25),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,38),wf(:,50),Q(:,25),G1tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,27),Q(:,38),wf(:,59),Q(:,25),G1tensor(:,17))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,-5),G0(:,:,:,31))
  call loop_VQ_A(G0(:,:,:,31),wf(:,48),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,55),MT,G1(:,:,:,162))
  call check_last_QA_V(l_switch,G1(:,:,:,162),wf(:,-3),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,31),wf(:,29),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,62),MT,G1(:,:,:,163))
  call check_last_AQ_V(l_switch,G1(:,:,:,163),wf(:,0),G1tensor(:,19))
  call loop_UV_W(G0(:,:,:,31),Q(:,38),wf(:,-4),Q(:,16),G1(:,:,:,164))
  call loop_VA_Q(G1(:,:,:,164),wf(:,-3),G1(:,:,:,165))
  call loop_A_Q(G1(:,:,:,165),Q(:,62),MT,G2(:,:,:,208))
  call check_last_AQ_V(l_switch,G2(:,:,:,208),wf(:,0),G2tensor(:,103))
  call loop_VA_Q(G0(:,:,:,31),wf(:,-3),G0(:,:,:,34))
  call loop_A_Q(G0(:,:,:,34),Q(:,46),MT,G1(:,:,:,166))
  call loop_AV_Q(G1(:,:,:,166),wf(:,-4),G1(:,:,:,167))
  call loop_A_Q(G1(:,:,:,167),Q(:,62),MT,G2(:,:,:,209))
  call check_last_AQ_V(l_switch,G2(:,:,:,209),wf(:,0),G2tensor(:,104))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,-4),wf(:,6),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,31),wf(:,6),wf(:,-4),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,31),wf(:,-4),wf(:,6),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,38),wf(:,43),Q(:,25),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,38),wf(:,50),Q(:,25),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,31),Q(:,38),wf(:,59),Q(:,25),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,7),G0(:,:,:,35))
  call loop_VQ_A(G0(:,:,:,35),wf(:,48),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,55),MT,G1(:,:,:,168))
  call check_last_QA_V(l_switch,G1(:,:,:,168),wf(:,-3),G1tensor(:,23))
  call loop_VA_Q(G0(:,:,:,35),wf(:,29),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,62),MT,G1(:,:,:,169))
  call check_last_AQ_V(l_switch,G1(:,:,:,169),wf(:,0),G1tensor(:,24))
  call loop_UV_W(G0(:,:,:,35),Q(:,38),wf(:,-4),Q(:,16),G1(:,:,:,170))
  call loop_VA_Q(G1(:,:,:,170),wf(:,-3),G1(:,:,:,171))
  call loop_A_Q(G1(:,:,:,171),Q(:,62),MT,G2(:,:,:,210))
  call check_last_AQ_V(l_switch,G2(:,:,:,210),wf(:,0),G2tensor(:,105))
  call loop_VA_Q(G0(:,:,:,35),wf(:,-3),G0(:,:,:,38))
  call loop_A_Q(G0(:,:,:,38),Q(:,46),MT,G1(:,:,:,172))
  call loop_AV_Q(G1(:,:,:,172),wf(:,-4),G1(:,:,:,173))
  call loop_A_Q(G1(:,:,:,173),Q(:,62),MT,G2(:,:,:,211))
  call check_last_AQ_V(l_switch,G2(:,:,:,211),wf(:,0),G2tensor(:,106))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,6),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,35),wf(:,6),wf(:,-4),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,35),wf(:,-4),wf(:,6),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,38),wf(:,43),Q(:,25),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,38),wf(:,50),Q(:,25),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,35),Q(:,38),wf(:,59),Q(:,25),G1tensor(:,27))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,7),wf(:,11),G0(:,:,:,39))
  call loop_VA_Q(G0(:,:,:,39),wf(:,-3),G0(:,:,:,40))
  call loop_A_Q(G0(:,:,:,40),Q(:,62),MT,G1(:,:,:,174))
  call check_last_AQ_V(l_switch,G1(:,:,:,174),wf(:,0),G1tensor(:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,39),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,29))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,7),G0(:,:,:,41))
  call loop_VA_Q(G0(:,:,:,41),wf(:,-3),G0(:,:,:,42))
  call loop_A_Q(G0(:,:,:,42),Q(:,62),MT,G1(:,:,:,175))
  call check_last_AQ_V(l_switch,G1(:,:,:,175),wf(:,0),G1tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,41),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,31))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,7),wf(:,11),G0(:,:,:,43))
  call loop_VA_Q(G0(:,:,:,43),wf(:,-3),G0(:,:,:,44))
  call loop_A_Q(G0(:,:,:,44),Q(:,62),MT,G1(:,:,:,176))
  call check_last_AQ_V(l_switch,G1(:,:,:,176),wf(:,0),G1tensor(:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,43),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,33))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,45),G0(:,:,:,45))
  call loop_VA_Q(G0(:,:,:,45),wf(:,-3),G0(:,:,:,46))
  call loop_A_Q(G0(:,:,:,46),Q(:,62),MT,G1(:,:,:,177))
  call check_last_AQ_V(l_switch,G1(:,:,:,177),wf(:,0),G1tensor(:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,45),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,45),wf(:,-5),G0(:,:,:,47))
  call loop_VA_Q(G0(:,:,:,47),wf(:,-3),G0(:,:,:,48))
  call loop_A_Q(G0(:,:,:,48),Q(:,62),MT,G1(:,:,:,178))
  call check_last_AQ_V(l_switch,G1(:,:,:,178),wf(:,0),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,47),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,37))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,45),G0(:,:,:,49))
  call loop_VA_Q(G0(:,:,:,49),wf(:,-3),G0(:,:,:,50))
  call loop_A_Q(G0(:,:,:,50),Q(:,62),MT,G1(:,:,:,179))
  call check_last_AQ_V(l_switch,G1(:,:,:,179),wf(:,0),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,49),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,44),G0(:,:,:,51))
  call loop_VA_Q(G0(:,:,:,51),wf(:,-3),G0(:,:,:,52))
  call loop_A_Q(G0(:,:,:,52),Q(:,62),MT,G1(:,:,:,180))
  call check_last_AQ_V(l_switch,G1(:,:,:,180),wf(:,0),G1tensor(:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,51),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,41))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,44),wf(:,-4),G0(:,:,:,53))
  call loop_VA_Q(G0(:,:,:,53),wf(:,-3),G0(:,:,:,54))
  call loop_A_Q(G0(:,:,:,54),Q(:,62),MT,G1(:,:,:,181))
  call check_last_AQ_V(l_switch,G1(:,:,:,181),wf(:,0),G1tensor(:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,53),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,43))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,44),G0(:,:,:,55))
  call loop_VA_Q(G0(:,:,:,55),wf(:,-3),G0(:,:,:,56))
  call loop_A_Q(G0(:,:,:,56),Q(:,62),MT,G1(:,:,:,182))
  call check_last_AQ_V(l_switch,G1(:,:,:,182),wf(:,0),G1tensor(:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,55),Q(:,54),wf(:,6),Q(:,9),G1tensor(:,45))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,7),Q(:,6),G1(:,:,:,183))
  call loop_GGG_G_12(G1(:,:,:,183),wf(:,-5),wf(:,-4),G1(:,:,:,184))
  call loop_VA_Q(G1(:,:,:,184),wf(:,-3),G1(:,:,:,185))
  call loop_A_Q(G1(:,:,:,185),Q(:,62),MT,G2(:,:,:,212))
  call check_last_AQ_V(l_switch,G2(:,:,:,212),wf(:,0),G2tensor(:,107))
  call loop_GGG_G_12(G1(:,:,:,183),wf(:,-4),wf(:,-5),G1(:,:,:,186))
  call loop_VA_Q(G1(:,:,:,186),wf(:,-3),G1(:,:,:,187))
  call loop_A_Q(G1(:,:,:,187),Q(:,62),MT,G2(:,:,:,213))
  call check_last_AQ_V(l_switch,G2(:,:,:,213),wf(:,0),G2tensor(:,108))
  call loop_GGG_G_23(G1(:,:,:,183),wf(:,-5),wf(:,-4),G1(:,:,:,188))
  call loop_VA_Q(G1(:,:,:,188),wf(:,-3),G1(:,:,:,189))
  call loop_A_Q(G1(:,:,:,189),Q(:,62),MT,G2(:,:,:,214))
  call check_last_AQ_V(l_switch,G2(:,:,:,214),wf(:,0),G2tensor(:,109))
  call loop_VA_Q(G1(:,:,:,183),wf(:,191),G1(:,:,:,190))
  call loop_A_Q(G1(:,:,:,190),Q(:,62),MT,G2(:,:,:,215))
  call check_last_AQ_V(l_switch,G2(:,:,:,215),wf(:,0),G2tensor(:,110))
  call loop_VA_Q(G1(:,:,:,183),wf(:,29),G1(:,:,:,191))
  call loop_A_Q(G1(:,:,:,191),Q(:,30),MT,G2(:,:,:,216))
  call loop_AV_Q(G2(:,:,:,216),wf(:,-5),G2(:,:,:,217))
  call loop_A_Q(G2(:,:,:,217),Q(:,62),MT,G3(:,:,:,118))
  call check_last_AQ_V(l_switch,G3(:,:,:,118),wf(:,0),G3tensor(:,73))
  call loop_UV_W(G1(:,:,:,183),Q(:,6),wf(:,-5),Q(:,32),G2(:,:,:,218))
  call loop_VA_Q(G2(:,:,:,218),wf(:,29),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,62),MT,G3(:,:,:,119))
  call check_last_AQ_V(l_switch,G3(:,:,:,119),wf(:,0),G3tensor(:,74))
  call loop_UV_W(G2(:,:,:,218),Q(:,38),wf(:,-4),Q(:,16),G3(:,:,:,120))
  call loop_VA_Q(G3(:,:,:,120),wf(:,-3),G3(:,:,:,121))
  call loop_A_Q(G3(:,:,:,121),Q(:,62),MT,G4(:,:,:,31))
  call check_last_AQ_V(l_switch,G4(:,:,:,31),wf(:,0),G4tensor(:,33))
  call loop_VA_Q(G2(:,:,:,218),wf(:,-3),G2(:,:,:,220))
  call loop_A_Q(G2(:,:,:,220),Q(:,46),MT,G3(:,:,:,122))
  call loop_AV_Q(G3(:,:,:,122),wf(:,-4),G3(:,:,:,123))
  call loop_A_Q(G3(:,:,:,123),Q(:,62),MT,G4(:,:,:,32))
  call check_last_AQ_V(l_switch,G4(:,:,:,32),wf(:,0),G4tensor(:,34))
  call loop_VA_Q(G1(:,:,:,183),wf(:,196),G1(:,:,:,192))
  call loop_A_Q(G1(:,:,:,192),Q(:,62),MT,G2(:,:,:,221))
  call check_last_AQ_V(l_switch,G2(:,:,:,221),wf(:,0),G2tensor(:,111))
  call loop_VA_Q(G1(:,:,:,183),wf(:,20),G1(:,:,:,193))
  call loop_A_Q(G1(:,:,:,193),Q(:,46),MT,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-4),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,62),MT,G3(:,:,:,124))
  call check_last_AQ_V(l_switch,G3(:,:,:,124),wf(:,0),G3tensor(:,75))
  call loop_UV_W(G1(:,:,:,183),Q(:,6),wf(:,-4),Q(:,16),G2(:,:,:,224))
  call loop_VA_Q(G2(:,:,:,224),wf(:,20),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,62),MT,G3(:,:,:,125))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,0),G3tensor(:,76))
  call loop_UV_W(G2(:,:,:,224),Q(:,22),wf(:,-5),Q(:,32),G3(:,:,:,126))
  call loop_VA_Q(G3(:,:,:,126),wf(:,-3),G3(:,:,:,127))
  call loop_A_Q(G3(:,:,:,127),Q(:,62),MT,G4(:,:,:,33))
  call check_last_AQ_V(l_switch,G4(:,:,:,33),wf(:,0),G4tensor(:,35))
  call loop_VA_Q(G2(:,:,:,224),wf(:,-3),G2(:,:,:,226))
  call loop_A_Q(G2(:,:,:,226),Q(:,30),MT,G3(:,:,:,128))
  call loop_AV_Q(G3(:,:,:,128),wf(:,-5),G3(:,:,:,129))
  call loop_A_Q(G3(:,:,:,129),Q(:,62),MT,G4(:,:,:,34))
  call check_last_AQ_V(l_switch,G4(:,:,:,34),wf(:,0),G4tensor(:,36))
  call loop_VA_Q(G1(:,:,:,183),wf(:,198),G1(:,:,:,194))
  call loop_A_Q(G1(:,:,:,194),Q(:,62),MT,G2(:,:,:,227))
  call check_last_AQ_V(l_switch,G2(:,:,:,227),wf(:,0),G2tensor(:,112))
  call loop_UV_W(G1(:,:,:,183),Q(:,6),wf(:,11),Q(:,48),G2(:,:,:,228))
  call loop_VA_Q(G2(:,:,:,228),wf(:,-3),G2(:,:,:,229))
  call loop_A_Q(G2(:,:,:,229),Q(:,62),MT,G3(:,:,:,130))
  call check_last_AQ_V(l_switch,G3(:,:,:,130),wf(:,0),G3tensor(:,77))
  call loop_VA_Q(G1(:,:,:,183),wf(:,-3),G1(:,:,:,195))
  call loop_A_Q(G1(:,:,:,195),Q(:,14),MT,G2(:,:,:,230))
  call loop_AV_Q(G2(:,:,:,230),wf(:,11),G2(:,:,:,231))
  call loop_A_Q(G2(:,:,:,231),Q(:,62),MT,G3(:,:,:,131))
  call check_last_AQ_V(l_switch,G3(:,:,:,131),wf(:,0),G3tensor(:,78))
  call loop_AV_Q(G2(:,:,:,230),wf(:,-5),G2(:,:,:,232))
  call loop_A_Q(G2(:,:,:,232),Q(:,46),MT,G3(:,:,:,132))
  call loop_AV_Q(G3(:,:,:,132),wf(:,-4),G3(:,:,:,133))
  call loop_A_Q(G3(:,:,:,133),Q(:,62),MT,G4(:,:,:,35))
  call check_last_AQ_V(l_switch,G4(:,:,:,35),wf(:,0),G4tensor(:,37))
  call loop_AV_Q(G2(:,:,:,230),wf(:,-4),G2(:,:,:,233))
  call loop_A_Q(G2(:,:,:,233),Q(:,30),MT,G3(:,:,:,134))
  call loop_AV_Q(G3(:,:,:,134),wf(:,-5),G3(:,:,:,135))
  call loop_A_Q(G3(:,:,:,135),Q(:,62),MT,G4(:,:,:,36))
  call check_last_AQ_V(l_switch,G4(:,:,:,36),wf(:,0),G4tensor(:,38))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,145),Q(:,54),G1(:,:,:,196))
  call loop_VA_Q(G1(:,:,:,196),wf(:,-3),G1(:,:,:,197))
  call loop_A_Q(G1(:,:,:,197),Q(:,62),MT,G2(:,:,:,234))
  call check_last_AQ_V(l_switch,G2(:,:,:,234),wf(:,0),G2tensor(:,113))
  call check_last_UV_W(l_switch,G1(:,:,:,196),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,114))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,147),Q(:,54),G1(:,:,:,198))
  call loop_VA_Q(G1(:,:,:,198),wf(:,-3),G1(:,:,:,199))
  call loop_A_Q(G1(:,:,:,199),Q(:,62),MT,G2(:,:,:,235))
  call check_last_AQ_V(l_switch,G2(:,:,:,235),wf(:,0),G2tensor(:,115))
  call check_last_UV_W(l_switch,G1(:,:,:,198),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,116))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,148),Q(:,54),G1(:,:,:,200))
  call loop_VA_Q(G1(:,:,:,200),wf(:,-3),G1(:,:,:,201))
  call loop_A_Q(G1(:,:,:,201),Q(:,62),MT,G2(:,:,:,236))
  call check_last_AQ_V(l_switch,G2(:,:,:,236),wf(:,0),G2tensor(:,117))
  call check_last_UV_W(l_switch,G1(:,:,:,200),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,118))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,6),G0(:,:,:,57))
  call loop_VQ_A(G0(:,:,:,57),wf(:,19),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,59),MT,G1(:,:,:,202))
  call check_last_QA_V(l_switch,G1(:,:,:,202),wf(:,-2),G1tensor(:,46))
  call loop_VA_Q(G0(:,:,:,57),wf(:,72),G0(:,:,:,59))
  call loop_A_Q(G0(:,:,:,59),Q(:,61),MT,G1(:,:,:,203))
  call check_last_AQ_V(l_switch,G1(:,:,:,203),wf(:,-1),G1tensor(:,47))
  call loop_UV_W(G0(:,:,:,57),Q(:,41),wf(:,-4),Q(:,16),G1(:,:,:,204))
  call loop_VA_Q(G1(:,:,:,204),wf(:,-2),G1(:,:,:,205))
  call loop_A_Q(G1(:,:,:,205),Q(:,61),MT,G2(:,:,:,237))
  call check_last_AQ_V(l_switch,G2(:,:,:,237),wf(:,-1),G2tensor(:,119))
  call loop_VA_Q(G0(:,:,:,57),wf(:,-2),G0(:,:,:,60))
  call loop_A_Q(G0(:,:,:,60),Q(:,45),MT,G1(:,:,:,206))
  call loop_AV_Q(G1(:,:,:,206),wf(:,-4),G1(:,:,:,207))
  call loop_A_Q(G1(:,:,:,207),Q(:,61),MT,G2(:,:,:,238))
  call check_last_AQ_V(l_switch,G2(:,:,:,238),wf(:,-1),G2tensor(:,120))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,57),wf(:,-4),wf(:,7),G0tensor(:,10))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,57),wf(:,7),wf(:,-4),G0tensor(:,11))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,57),wf(:,-4),wf(:,7),G0tensor(:,12))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,41),wf(:,45),Q(:,22),G1tensor(:,48))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,41),wf(:,70),Q(:,22),G1tensor(:,49))
  call check_last_UV_W(l_switch,G0(:,:,:,57),Q(:,41),wf(:,77),Q(:,22),G1tensor(:,50))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,-5),G0(:,:,:,61))
  call loop_VQ_A(G0(:,:,:,61),wf(:,19),G0(:,:,:,62))
  call loop_Q_A(G0(:,:,:,62),Q(:,59),MT,G1(:,:,:,208))
  call check_last_QA_V(l_switch,G1(:,:,:,208),wf(:,-2),G1tensor(:,51))
  call loop_VA_Q(G0(:,:,:,61),wf(:,72),G0(:,:,:,63))
  call loop_A_Q(G0(:,:,:,63),Q(:,61),MT,G1(:,:,:,209))
  call check_last_AQ_V(l_switch,G1(:,:,:,209),wf(:,-1),G1tensor(:,52))
  call loop_UV_W(G0(:,:,:,61),Q(:,41),wf(:,-4),Q(:,16),G1(:,:,:,210))
  call loop_VA_Q(G1(:,:,:,210),wf(:,-2),G1(:,:,:,211))
  call loop_A_Q(G1(:,:,:,211),Q(:,61),MT,G2(:,:,:,239))
  call check_last_AQ_V(l_switch,G2(:,:,:,239),wf(:,-1),G2tensor(:,121))
  call loop_VA_Q(G0(:,:,:,61),wf(:,-2),G0(:,:,:,64))
  call loop_A_Q(G0(:,:,:,64),Q(:,45),MT,G1(:,:,:,212))
  call loop_AV_Q(G1(:,:,:,212),wf(:,-4),G1(:,:,:,213))
  call loop_A_Q(G1(:,:,:,213),Q(:,61),MT,G2(:,:,:,240))
  call check_last_AQ_V(l_switch,G2(:,:,:,240),wf(:,-1),G2tensor(:,122))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,61),wf(:,-4),wf(:,7),G0tensor(:,13))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,61),wf(:,7),wf(:,-4),G0tensor(:,14))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,61),wf(:,-4),wf(:,7),G0tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,41),wf(:,45),Q(:,22),G1tensor(:,53))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,41),wf(:,70),Q(:,22),G1tensor(:,54))
  call check_last_UV_W(l_switch,G0(:,:,:,61),Q(:,41),wf(:,77),Q(:,22),G1tensor(:,55))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,6),G0(:,:,:,65))
  call loop_VQ_A(G0(:,:,:,65),wf(:,19),G0(:,:,:,66))
  call loop_Q_A(G0(:,:,:,66),Q(:,59),MT,G1(:,:,:,214))
  call check_last_QA_V(l_switch,G1(:,:,:,214),wf(:,-2),G1tensor(:,56))
  call loop_VA_Q(G0(:,:,:,65),wf(:,72),G0(:,:,:,67))
  call loop_A_Q(G0(:,:,:,67),Q(:,61),MT,G1(:,:,:,215))
  call check_last_AQ_V(l_switch,G1(:,:,:,215),wf(:,-1),G1tensor(:,57))
  call loop_UV_W(G0(:,:,:,65),Q(:,41),wf(:,-4),Q(:,16),G1(:,:,:,216))
  call loop_VA_Q(G1(:,:,:,216),wf(:,-2),G1(:,:,:,217))
  call loop_A_Q(G1(:,:,:,217),Q(:,61),MT,G2(:,:,:,241))
  call check_last_AQ_V(l_switch,G2(:,:,:,241),wf(:,-1),G2tensor(:,123))
  call loop_VA_Q(G0(:,:,:,65),wf(:,-2),G0(:,:,:,68))
  call loop_A_Q(G0(:,:,:,68),Q(:,45),MT,G1(:,:,:,218))
  call loop_AV_Q(G1(:,:,:,218),wf(:,-4),G1(:,:,:,219))
  call loop_A_Q(G1(:,:,:,219),Q(:,61),MT,G2(:,:,:,242))
  call check_last_AQ_V(l_switch,G2(:,:,:,242),wf(:,-1),G2tensor(:,124))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,-4),wf(:,7),G0tensor(:,16))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,65),wf(:,7),wf(:,-4),G0tensor(:,17))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,65),wf(:,-4),wf(:,7),G0tensor(:,18))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,41),wf(:,45),Q(:,22),G1tensor(:,58))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,41),wf(:,70),Q(:,22),G1tensor(:,59))
  call check_last_UV_W(l_switch,G0(:,:,:,65),Q(:,41),wf(:,77),Q(:,22),G1tensor(:,60))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,6),wf(:,11),G0(:,:,:,69))
  call loop_VA_Q(G0(:,:,:,69),wf(:,-2),G0(:,:,:,70))
  call loop_A_Q(G0(:,:,:,70),Q(:,61),MT,G1(:,:,:,220))
  call check_last_AQ_V(l_switch,G1(:,:,:,220),wf(:,-1),G1tensor(:,61))
  call check_last_UV_W(l_switch,G0(:,:,:,69),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,62))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,6),G0(:,:,:,71))
  call loop_VA_Q(G0(:,:,:,71),wf(:,-2),G0(:,:,:,72))
  call loop_A_Q(G0(:,:,:,72),Q(:,61),MT,G1(:,:,:,221))
  call check_last_AQ_V(l_switch,G1(:,:,:,221),wf(:,-1),G1tensor(:,63))
  call check_last_UV_W(l_switch,G0(:,:,:,71),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,64))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,6),wf(:,11),G0(:,:,:,73))
  call loop_VA_Q(G0(:,:,:,73),wf(:,-2),G0(:,:,:,74))
  call loop_A_Q(G0(:,:,:,74),Q(:,61),MT,G1(:,:,:,222))
  call check_last_AQ_V(l_switch,G1(:,:,:,222),wf(:,-1),G1tensor(:,65))
  call check_last_UV_W(l_switch,G0(:,:,:,73),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,66))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,43),G0(:,:,:,75))
  call loop_VA_Q(G0(:,:,:,75),wf(:,-2),G0(:,:,:,76))
  call loop_A_Q(G0(:,:,:,76),Q(:,61),MT,G1(:,:,:,223))
  call check_last_AQ_V(l_switch,G1(:,:,:,223),wf(:,-1),G1tensor(:,67))
  call check_last_UV_W(l_switch,G0(:,:,:,75),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,68))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,43),wf(:,-5),G0(:,:,:,77))
  call loop_VA_Q(G0(:,:,:,77),wf(:,-2),G0(:,:,:,78))
  call loop_A_Q(G0(:,:,:,78),Q(:,61),MT,G1(:,:,:,224))
  call check_last_AQ_V(l_switch,G1(:,:,:,224),wf(:,-1),G1tensor(:,69))
  call check_last_UV_W(l_switch,G0(:,:,:,77),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,70))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,43),G0(:,:,:,79))
  call loop_VA_Q(G0(:,:,:,79),wf(:,-2),G0(:,:,:,80))
  call loop_A_Q(G0(:,:,:,80),Q(:,61),MT,G1(:,:,:,225))
  call check_last_AQ_V(l_switch,G1(:,:,:,225),wf(:,-1),G1tensor(:,71))
  call check_last_UV_W(l_switch,G0(:,:,:,79),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,72))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,46),G0(:,:,:,81))
  call loop_VA_Q(G0(:,:,:,81),wf(:,-2),G0(:,:,:,82))
  call loop_A_Q(G0(:,:,:,82),Q(:,61),MT,G1(:,:,:,226))
  call check_last_AQ_V(l_switch,G1(:,:,:,226),wf(:,-1),G1tensor(:,73))
  call check_last_UV_W(l_switch,G0(:,:,:,81),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,74))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,46),wf(:,-4),G0(:,:,:,83))
  call loop_VA_Q(G0(:,:,:,83),wf(:,-2),G0(:,:,:,84))
  call loop_A_Q(G0(:,:,:,84),Q(:,61),MT,G1(:,:,:,227))
  call check_last_AQ_V(l_switch,G1(:,:,:,227),wf(:,-1),G1tensor(:,75))
  call check_last_UV_W(l_switch,G0(:,:,:,83),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,76))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,46),G0(:,:,:,85))
  call loop_VA_Q(G0(:,:,:,85),wf(:,-2),G0(:,:,:,86))
  call loop_A_Q(G0(:,:,:,86),Q(:,61),MT,G1(:,:,:,228))
  call check_last_AQ_V(l_switch,G1(:,:,:,228),wf(:,-1),G1tensor(:,77))
  call check_last_UV_W(l_switch,G0(:,:,:,85),Q(:,57),wf(:,7),Q(:,6),G1tensor(:,78))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(21)*(-M(2)-M(3)+M(6)+M(11))) * den(142)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(21)*(-M(6)+M(7)+M(10)-M(11))) * den(142)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(21)*(M(2)+M(3)-M(7)-M(10))) * den(142)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(14)*(M(2)+M(3)-M(6)-M(11))) * den(142)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(14)*(M(6)-M(7)-M(10)+M(11))) * den(142)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,67)
  Gcoeff = (c(14)*(-M(2)-M(3)+M(7)+M(10))) * den(142)
  T2sum(1:15,3) = T2sum(1:15,3) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(29)*(M(1)+M(4))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,18) = T3sum(1:15,18) + Gcoeff * G2tensor(:,71)
  Gcoeff = (c(24)*(-M(6)-M(7)-M(10)-M(11))+c(29)*(M(5)+M(12))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,18) = T3sum(1:15,18) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(29)*(-M(1)-M(4)+M(5)+M(12))) * den(6)
  T3sum(1:15,18) = T3sum(1:15,18) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(29)*(M(1)+M(4))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,19) = T3sum(1:15,19) + Gcoeff * G2tensor(:,80)
  Gcoeff = (c(29)*(M(8)+M(9))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,19) = T3sum(1:15,19) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(29)*(-M(1)-M(4)+M(8)+M(9))) * den(6)
  T3sum(1:15,19) = T3sum(1:15,19) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(24)*(-M(6)-M(7)-M(10)-M(11))+c(29)*(M(5)+M(12))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,20) = T3sum(1:15,20) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(29)*(M(8)+M(9))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,20) = T3sum(1:15,20) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(29)*(-M(5)+M(8)+M(9)-M(12))) * den(6)
  T3sum(1:15,20) = T3sum(1:15,20) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(29)*M(4)+c(24)*(M(2)-M(11))) * den(52)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,13)
  Gcoeff = (c(29)*M(9)+c(24)*(M(2)-M(11))) * den(52)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(29)*(-M(4)+M(9))) * den(52)
  T2sum(1:5,9) = T2sum(1:5,9) + Gcoeff * G1tensor(:,23)
  Gcoeff = (c(29)*M(1)+c(24)*(M(2)-M(7))) * den(330)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,14)
  Gcoeff = (c(24)*(M(2)-M(7))+c(29)*M(8)) * den(330)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(29)*(-M(1)+M(8))) * den(330)
  T2sum(1:5,10) = T2sum(1:5,10) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(9)*(-M(6)+M(7)+M(10)-M(11))+c(14)*(-M(8)+M(12))) * den(298)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(-M(6)+M(7)+M(10)-M(11))) * den(298)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(14)*(-M(5)+M(8)+M(9)-M(12))) * den(298)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(14)*(M(1)-M(5))+c(9)*(-M(6)+M(10))) * den(49)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(9)*(-M(6)+M(10))+c(14)*(-M(4)+M(12))) * den(49)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(14)*(-M(1)-M(4)+M(5)+M(12))) * den(49)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,38)
  Gcoeff = (c(14)*M(1)+c(9)*(M(2)+M(3)-M(6)-M(7)+M(14))) * den(5)
  T3sum(1:15,22) = T3sum(1:15,22) + Gcoeff * G2tensor(:,101)
  Gcoeff = (c(14)*M(8)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(5)
  T3sum(1:15,22) = T3sum(1:15,22) + Gcoeff * G2tensor(:,103)
  Gcoeff = (c(14)*(-M(1)+M(8))+c(9)*(M(6)-M(10))) * den(5)
  T3sum(1:15,22) = T3sum(1:15,22) + Gcoeff * G2tensor(:,105)
  Gcoeff = (c(24)*(-M(3)+M(6)-M(14))) * den(5)
  T3sum(1:15,23) = T3sum(1:15,23) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(24)*(-M(3)+M(10)-M(14))) * den(5)
  T3sum(1:15,23) = T3sum(1:15,23) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(24)*(-M(6)+M(10))) * den(5)
  T3sum(1:15,23) = T3sum(1:15,23) + Gcoeff * G2tensor(:,106)
  Gcoeff = (c(29)*M(1)+c(24)*(M(3)-M(7))) * den(60)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(29)*M(5)+c(24)*(M(3)-M(7))) * den(60)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(29)*(-M(1)+M(5))) * den(60)
  T2sum(1:5,12) = T2sum(1:5,12) + Gcoeff * G1tensor(:,5)
  Gcoeff = (c(29)*M(4)+c(24)*(M(3)-M(11))) * den(314)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(24)*(M(3)-M(11))+c(29)*M(12)) * den(314)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(29)*(-M(4)+M(12))) * den(314)
  T2sum(1:5,13) = T2sum(1:5,13) + Gcoeff * G1tensor(:,6)
  Gcoeff = (c(14)*(M(4)-M(9))+c(9)*(M(6)-M(10))) * den(162)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(14)*(-M(1)+M(8))+c(9)*(M(6)-M(10))) * den(162)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(14)*(-M(1)-M(4)+M(8)+M(9))) * den(162)
  T2sum(1:5,11) = T2sum(1:5,11) + Gcoeff * G1tensor(:,44)
  Gcoeff = (c(14)*M(4)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(5)
  T3sum(1:15,25) = T3sum(1:15,25) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(14)*M(12)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(5)
  T3sum(1:15,25) = T3sum(1:15,25) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(9)*(-M(6)+M(10))+c(14)*(-M(4)+M(12))) * den(5)
  T3sum(1:15,25) = T3sum(1:15,25) + Gcoeff * G2tensor(:,78)
  Gcoeff = (c(24)*(-M(2)+M(10)-M(14))) * den(5)
  T3sum(1:15,26) = T3sum(1:15,26) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(24)*(-M(2)+M(6)-M(14))) * den(5)
  T3sum(1:15,26) = T3sum(1:15,26) + Gcoeff * G2tensor(:,76)
  Gcoeff = (c(24)*(M(6)-M(10))) * den(5)
  T3sum(1:15,26) = T3sum(1:15,26) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(14)*M(8)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(5)
  T3sum(1:15,27) = T3sum(1:15,27) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(14)*M(12)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(5)
  T3sum(1:15,27) = T3sum(1:15,27) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(9)*(-M(6)+M(7)+M(10)-M(11))+c(14)*(-M(8)+M(12))) * den(5)
  T3sum(1:15,27) = T3sum(1:15,27) + Gcoeff * G2tensor(:,109)
  Gcoeff = (c(21)*(M(1)+M(4)-M(5)-M(12))) * den(155)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(21)*(M(5)-M(8)-M(9)+M(12))) * den(155)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(21)*(-M(1)-M(4)+M(8)+M(9))) * den(155)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(14)*(-M(1)-M(4)+M(5)+M(12))) * den(155)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(14)*(-M(5)+M(8)+M(9)-M(12))) * den(155)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,115)
  Gcoeff = (c(14)*(M(1)+M(4)-M(8)-M(9))) * den(155)
  T2sum(1:15,11) = T2sum(1:15,11) + Gcoeff * G2tensor(:,117)
  Gcoeff = (c(29)*M(1)+c(24)*(M(3)-M(10))) * den(78)
  T2sum(1:5,16) = T2sum(1:5,16) + Gcoeff * G1tensor(:,46)
  Gcoeff = (c(24)*(M(3)-M(10))+c(29)*M(12)) * den(78)
  T2sum(1:5,16) = T2sum(1:5,16) + Gcoeff * G1tensor(:,51)
  Gcoeff = (c(29)*(-M(1)+M(12))) * den(78)
  T2sum(1:5,16) = T2sum(1:5,16) + Gcoeff * G1tensor(:,56)
  Gcoeff = (c(29)*M(4)+c(24)*(M(3)-M(6))) * den(382)
  T2sum(1:5,17) = T2sum(1:5,17) + Gcoeff * G1tensor(:,47)
  Gcoeff = (c(29)*M(5)+c(24)*(M(3)-M(6))) * den(382)
  T2sum(1:5,17) = T2sum(1:5,17) + Gcoeff * G1tensor(:,52)
  Gcoeff = (c(29)*(-M(4)+M(5))) * den(382)
  T2sum(1:5,17) = T2sum(1:5,17) + Gcoeff * G1tensor(:,57)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(M(6)-M(7)-M(10)+M(11))) * den(301)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,61)
  Gcoeff = (c(9)*(M(6)-M(7)-M(10)+M(11))+c(14)*(-M(8)+M(12))) * den(301)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,63)
  Gcoeff = (c(14)*(M(5)-M(8)-M(9)+M(12))) * den(301)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,65)
  Gcoeff = (c(14)*(M(4)-M(8))+c(9)*(-M(7)+M(11))) * den(46)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,67)
  Gcoeff = (c(14)*(-M(1)+M(9))+c(9)*(-M(7)+M(11))) * den(46)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,69)
  Gcoeff = (c(14)*(-M(1)-M(4)+M(8)+M(9))) * den(46)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,71)
  Gcoeff = (c(14)*M(4)+c(9)*(M(2)+M(3)-M(6)-M(7)+M(14))) * den(4)
  T3sum(1:15,31) = T3sum(1:15,31) + Gcoeff * G2tensor(:,119)
  Gcoeff = (c(14)*M(5)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(4)
  T3sum(1:15,31) = T3sum(1:15,31) + Gcoeff * G2tensor(:,121)
  Gcoeff = (c(14)*(-M(4)+M(5))+c(9)*(M(7)-M(11))) * den(4)
  T3sum(1:15,31) = T3sum(1:15,31) + Gcoeff * G2tensor(:,123)
  Gcoeff = (c(24)*(-M(2)+M(7)-M(14))) * den(4)
  T3sum(1:15,32) = T3sum(1:15,32) + Gcoeff * G2tensor(:,120)
  Gcoeff = (c(24)*(-M(2)+M(11)-M(14))) * den(4)
  T3sum(1:15,32) = T3sum(1:15,32) + Gcoeff * G2tensor(:,122)
  Gcoeff = (c(24)*(-M(7)+M(11))) * den(4)
  T3sum(1:15,32) = T3sum(1:15,32) + Gcoeff * G2tensor(:,124)
  Gcoeff = (c(29)*M(4)+c(24)*(M(2)-M(6))) * den(85)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,7)
  Gcoeff = (c(24)*(M(2)-M(6))+c(29)*M(8)) * den(85)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(29)*(-M(4)+M(8))) * den(85)
  T2sum(1:5,19) = T2sum(1:5,19) + Gcoeff * G1tensor(:,11)
  Gcoeff = (c(29)*M(1)+c(24)*(M(2)-M(10))) * den(367)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,8)
  Gcoeff = (c(29)*M(9)+c(24)*(M(2)-M(10))) * den(367)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(29)*(-M(1)+M(9))) * den(367)
  T2sum(1:5,20) = T2sum(1:5,20) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(9)*(M(7)-M(11))+c(14)*(M(1)-M(12))) * den(160)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,73)
  Gcoeff = (c(14)*(-M(4)+M(5))+c(9)*(M(7)-M(11))) * den(160)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,75)
  Gcoeff = (c(14)*(-M(1)-M(4)+M(5)+M(12))) * den(160)
  T2sum(1:5,18) = T2sum(1:5,18) + Gcoeff * G1tensor(:,77)
  Gcoeff = (c(14)*M(1)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(4)
  T3sum(1:15,34) = T3sum(1:15,34) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(14)*M(9)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(4)
  T3sum(1:15,34) = T3sum(1:15,34) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(14)*(-M(1)+M(9))+c(9)*(-M(7)+M(11))) * den(4)
  T3sum(1:15,34) = T3sum(1:15,34) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(24)*(-M(3)+M(11)-M(14))) * den(4)
  T3sum(1:15,35) = T3sum(1:15,35) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(24)*(-M(3)+M(7)-M(14))) * den(4)
  T3sum(1:15,35) = T3sum(1:15,35) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(24)*(M(7)-M(11))) * den(4)
  T3sum(1:15,35) = T3sum(1:15,35) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(14)*M(5)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(4)
  T3sum(1:15,36) = T3sum(1:15,36) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(14)*M(9)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(4)
  T3sum(1:15,36) = T3sum(1:15,36) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(M(6)-M(7)-M(10)+M(11))) * den(4)
  T3sum(1:15,36) = T3sum(1:15,36) + Gcoeff * G2tensor(:,94)
  Gcoeff = (-(c(28)*M(6))+c(21)*(-M(2)-M(3)+M(11))-c(24)*M(13))
  T3sum(1:15,51) = T3sum(1:15,51) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(21)*(-M(2)-M(3)+M(7))-c(28)*M(10)-c(24)*M(13))
  T3sum(1:15,51) = T3sum(1:15,51) + Gcoeff * G2tensor(:,8)
  Gcoeff = (c(28)*(M(6)-M(10))+c(21)*(M(7)-M(11)))
  T3sum(1:15,51) = T3sum(1:15,51) + Gcoeff * G2tensor(:,9)
  Gcoeff = (-(c(14)*M(10))+c(9)*M(12)) * den(150)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(9)*M(1)) * den(17)
  T3sum(1:35,68) = T3sum(1:35,68) + Gcoeff * G3tensor(:,7)
  Gcoeff = (-(c(29)*M(10))+c(24)*(-M(1)+M(12))) * den(17)
  T3sum(1:35,73) = T3sum(1:35,73) + Gcoeff * G3tensor(:,20)
  Gcoeff = (-(c(14)*M(6))+c(9)*M(8)) * den(153)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(9)*M(4)) * den(26)
  T3sum(1:35,80) = T3sum(1:35,80) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(29)*M(6))+c(24)*(-M(4)+M(8))) * den(26)
  T3sum(1:35,85) = T3sum(1:35,85) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(6)*(-M(7)+M(11))+c(5)*(M(8)-M(12))) * den(40)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(29)*(M(6)-M(10))+c(24)*(-M(8)+M(12))) * den(43)
  T2sum(1:15,35) = T2sum(1:15,35) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(21)*(M(6)-M(7)-M(10)+M(11))) * den(230)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(9)*(M(5)-M(9))+c(6)*(-M(7)+M(11))+c(5)*(M(8)-M(12))) * den(229)
  T3sum(1:35,92) = T3sum(1:35,92) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(9)*(M(5)-M(9))+c(6)*(-M(6)+M(10))+c(5)*(M(8)-M(12))) * den(229)
  T3sum(1:35,93) = T3sum(1:35,93) + Gcoeff * G3tensor(:,42)
  Gcoeff = (-(c(20)*M(8))-c(24)*M(13)+c(21)*(M(7)+M(14))) * den(29)
  T3sum(1:35,97) = T3sum(1:35,97) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(20)*M(12))-c(24)*M(13)+c(21)*(M(11)+M(14))) * den(29)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(21)*(-M(2)-M(3)+M(6)+M(11))) * den(516)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(6)*(M(2)-M(6))+c(9)*(M(5)-M(9))) * den(10)
  T3sum(1:35,107) = T3sum(1:35,107) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(9)*(M(5)-M(9))+c(6)*(-M(3)+M(11))) * den(10)
  T3sum(1:35,108) = T3sum(1:35,108) + Gcoeff * G3tensor(:,11)
  Gcoeff = (c(21)*(M(2)+M(3)-M(7)-M(10))) * den(519)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(6)*(M(3)-M(10))) * den(144)
  T3sum(1:35,110) = T3sum(1:35,110) + Gcoeff * G3tensor(:,44)
  Gcoeff = (c(6)*(-M(2)+M(7))+c(9)*(-M(5)+M(9))) * den(144)
  T3sum(1:35,111) = T3sum(1:35,111) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(24)*M(5))-c(20)*M(12)+c(21)*(M(3)+M(14))) * den(1)
  T4sum(1:70,10) = T4sum(1:70,10) + Gcoeff * G4tensor(:,10)
  Gcoeff = (-(c(24)*M(9))-c(20)*M(12)+c(21)*(M(10)+M(14))) * den(1)
  T4sum(1:70,12) = T4sum(1:70,12) + Gcoeff * G4tensor(:,21)
  Gcoeff = (-(c(20)*M(8))-c(24)*M(9)+c(21)*(M(2)+M(14))) * den(1)
  T4sum(1:70,14) = T4sum(1:70,14) + Gcoeff * G4tensor(:,17)
  Gcoeff = (-(c(24)*M(5))-c(20)*M(8)+c(21)*(M(6)+M(14))) * den(1)
  T4sum(1:70,16) = T4sum(1:70,16) + Gcoeff * G4tensor(:,22)
  Gcoeff = (-(c(24)*M(5))-c(20)*M(8)+c(21)*(M(7)+M(14))) * den(1)
  T4sum(1:70,18) = T4sum(1:70,18) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(24)*M(9))-c(20)*M(12)+c(21)*(M(11)+M(14))) * den(1)
  T4sum(1:70,20) = T4sum(1:70,20) + Gcoeff * G4tensor(:,7)
  Gcoeff = (c(29)*(-M(5)+M(8)+M(9)-M(12))) * den(631)
  T3sum(1:35,20) = T3sum(1:35,20) + Gcoeff * G3tensor(:,62)
  Gcoeff = (c(29)*(M(8)+M(9))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T4sum(1:70,34) = T4sum(1:70,34) + Gcoeff * G4tensor(:,25)
  Gcoeff = (c(24)*(-M(6)-M(7)-M(10)-M(11))+c(29)*(M(5)+M(12))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T4sum(1:70,37) = T4sum(1:70,37) + Gcoeff * G4tensor(:,28)
  Gcoeff = (c(14)*M(9)-c(9)*M(11)) * den(165)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,28)
  Gcoeff = (-(c(9)*M(2))) * den(52)
  T3sum(1:35,125) = T3sum(1:35,125) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(29)*M(9)+c(24)*(M(2)-M(11))) * den(52)
  T3sum(1:35,128) = T3sum(1:35,128) + Gcoeff * G3tensor(:,45)
  Gcoeff = (-(c(9)*M(7))+c(14)*M(8)) * den(206)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,110)
  Gcoeff = (-(c(9)*M(2))) * den(330)
  T3sum(1:35,129) = T3sum(1:35,129) + Gcoeff * G3tensor(:,73)
  Gcoeff = (c(24)*(M(2)-M(7))+c(29)*M(8)) * den(330)
  T3sum(1:35,134) = T3sum(1:35,134) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(14)*M(5)-c(9)*M(7)) * den(168)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,32)
  Gcoeff = (-(c(9)*M(3))) * den(60)
  T3sum(1:35,137) = T3sum(1:35,137) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(29)*M(5)+c(24)*(M(3)-M(7))) * den(60)
  T3sum(1:35,140) = T3sum(1:35,140) + Gcoeff * G3tensor(:,48)
  Gcoeff = (-(c(9)*M(11))+c(14)*M(12)) * den(208)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,111)
  Gcoeff = (-(c(9)*M(3))) * den(314)
  T3sum(1:35,141) = T3sum(1:35,141) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(24)*(M(3)-M(11))+c(29)*M(12)) * den(314)
  T3sum(1:35,146) = T3sum(1:35,146) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(5)*(-M(7)+M(11))+c(6)*(M(8)-M(12))) * den(73)
  T2sum(1:15,57) = T2sum(1:15,57) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(29)*(-M(5)+M(9))+c(24)*(M(7)-M(11))) * den(76)
  T2sum(1:15,62) = T2sum(1:15,62) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(24)*(M(7)-M(11))+c(29)*(-M(8)+M(12))) * den(210)
  T2sum(1:15,70) = T2sum(1:15,70) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(21)*(-M(5)+M(8)+M(9)-M(12))) * den(299)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(9)*(-M(6)+M(10))+c(5)*(-M(7)+M(11))+c(6)*(M(8)-M(12))) * den(298)
  T3sum(1:35,147) = T3sum(1:35,147) + Gcoeff * G3tensor(:,40)
  Gcoeff = (c(9)*(-M(6)+M(7)+M(10)-M(11))+c(14)*(-M(8)+M(12))) * den(298)
  T3sum(1:35,27) = T3sum(1:35,27) + Gcoeff * G3tensor(:,77)
  Gcoeff = (c(6)*(M(5)-M(9))+c(9)*(-M(6)+M(10))+c(5)*(-M(7)+M(11))) * den(298)
  T3sum(1:35,148) = T3sum(1:35,148) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(24)*(M(6)-M(10))) * den(298)
  T3sum(1:35,149) = T3sum(1:35,149) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(20)*M(7)+c(21)*(-M(8)-M(13))+c(24)*M(14)) * den(62)
  T3sum(1:35,97) = T3sum(1:35,97) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(20)*M(11)+c(21)*(-M(12)-M(13))+c(24)*M(14)) * den(62)
  T3sum(1:35,99) = T3sum(1:35,99) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(21)*(M(1)+M(4)-M(5)-M(12))) * den(529)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(6)*(-M(1)+M(5))+c(9)*(-M(6)+M(10))) * den(49)
  T3sum(1:35,156) = T3sum(1:35,156) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(9)*(-M(6)+M(10))+c(6)*(M(4)-M(12))) * den(49)
  T3sum(1:35,157) = T3sum(1:35,157) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(21)*(-M(1)-M(4)+M(8)+M(9))) * den(531)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(6)*(-M(4)+M(9))+c(9)*(M(6)-M(10))) * den(162)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(6)*(M(1)-M(8))+c(9)*(M(6)-M(10))) * den(162)
  T3sum(1:35,160) = T3sum(1:35,160) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(24)*M(6)+c(20)*M(11)+c(21)*(-M(4)-M(13))) * den(5)
  T4sum(1:70,43) = T4sum(1:70,43) + Gcoeff * G4tensor(:,11)
  Gcoeff = (c(24)*M(10)+c(20)*M(11)+c(21)*(-M(9)-M(13))) * den(5)
  T4sum(1:70,45) = T4sum(1:70,45) + Gcoeff * G4tensor(:,23)
  Gcoeff = (c(20)*M(7)+c(24)*M(10)+c(21)*(-M(1)-M(13))) * den(5)
  T4sum(1:70,47) = T4sum(1:70,47) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(24)*M(6)+c(20)*M(7)+c(21)*(-M(5)-M(13))) * den(5)
  T4sum(1:70,49) = T4sum(1:70,49) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(24)*M(6)+c(20)*M(7)+c(21)*(-M(8)-M(13))) * den(5)
  T4sum(1:70,51) = T4sum(1:70,51) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(14)*M(8)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(5)
  T4sum(1:70,52) = T4sum(1:70,52) + Gcoeff * G4tensor(:,33)
  Gcoeff = (c(24)*M(10)+c(20)*M(11)+c(21)*(-M(12)-M(13))) * den(5)
  T4sum(1:70,53) = T4sum(1:70,53) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(14)*M(12)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(5)
  T4sum(1:70,54) = T4sum(1:70,54) + Gcoeff * G4tensor(:,35)
  Gcoeff = (c(24)*(-M(3)+M(10)-M(14))) * den(5)
  T4sum(1:70,60) = T4sum(1:70,60) + Gcoeff * G4tensor(:,34)
  Gcoeff = (c(9)*(-M(10)+M(14))) * den(5)
  T4sum(1:70,61) = T4sum(1:70,61) + Gcoeff * G4tensor(:,37)
  Gcoeff = (c(24)*(-M(2)+M(6)-M(14))) * den(5)
  T4sum(1:70,64) = T4sum(1:70,64) + Gcoeff * G4tensor(:,36)
  Gcoeff = (c(9)*(-M(6)+M(14))) * den(5)
  T4sum(1:70,65) = T4sum(1:70,65) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(9)*M(10)-c(14)*M(12)) * den(171)
  T2sum(1:15,84) = T2sum(1:15,84) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(9)*M(3)) * den(78)
  T3sum(1:35,162) = T3sum(1:35,162) + Gcoeff * G3tensor(:,68)
  Gcoeff = (c(24)*(M(3)-M(10))+c(29)*M(12)) * den(78)
  T3sum(1:35,167) = T3sum(1:35,167) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(14)*M(5)-c(9)*M(6)) * den(195)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,96)
  Gcoeff = (-(c(9)*M(3))) * den(382)
  T3sum(1:35,168) = T3sum(1:35,168) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(29)*M(5)+c(24)*(M(3)-M(6))) * den(382)
  T3sum(1:35,173) = T3sum(1:35,173) + Gcoeff * G3tensor(:,67)
  Gcoeff = (c(9)*M(6)-c(14)*M(8)) * den(173)
  T2sum(1:15,84) = T2sum(1:15,84) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(9)*M(2)) * den(85)
  T3sum(1:35,174) = T3sum(1:35,174) + Gcoeff * G3tensor(:,70)
  Gcoeff = (c(24)*(M(2)-M(6))+c(29)*M(8)) * den(85)
  T3sum(1:35,179) = T3sum(1:35,179) + Gcoeff * G3tensor(:,64)
  Gcoeff = (c(14)*M(9)-c(9)*M(10)) * den(198)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(9)*M(2))) * den(367)
  T3sum(1:35,180) = T3sum(1:35,180) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(29)*M(9)+c(24)*(M(2)-M(10))) * den(367)
  T3sum(1:35,185) = T3sum(1:35,185) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(24)*(-M(6)+M(10))+c(29)*(M(8)-M(12))) * den(100)
  T2sum(1:15,84) = T2sum(1:15,84) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(29)*(-M(5)+M(9))+c(24)*(M(6)-M(10))) * den(201)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(M(6)-M(7)-M(10)+M(11))) * den(301)
  T3sum(1:35,36) = T3sum(1:35,36) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(24)*(M(7)-M(11))) * den(301)
  T3sum(1:35,188) = T3sum(1:35,188) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(14)*M(5)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(4)
  T4sum(1:70,76) = T4sum(1:70,76) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(14)*M(9)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(4)
  T4sum(1:70,78) = T4sum(1:70,78) + Gcoeff * G4tensor(:,26)
  Gcoeff = (c(24)*(-M(2)+M(11)-M(14))) * den(4)
  T4sum(1:70,84) = T4sum(1:70,84) + Gcoeff * G4tensor(:,30)
  Gcoeff = (c(9)*(-M(11)+M(14))) * den(4)
  T4sum(1:70,85) = T4sum(1:70,85) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(24)*(-M(3)+M(7)-M(14))) * den(4)
  T4sum(1:70,88) = T4sum(1:70,88) + Gcoeff * G4tensor(:,27)
  Gcoeff = (c(9)*(-M(7)+M(14))) * den(4)
  T4sum(1:70,89) = T4sum(1:70,89) + Gcoeff * G4tensor(:,32)
  Gcoeff = (c(22)*M(2)-c(25)*M(4)) * den(638)
  T2sum(1:15,113) = T2sum(1:15,113) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(25)*M(2)-c(22)*M(4)) * den(638)
  T2sum(1:15,114) = T2sum(1:15,114) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(21)*M(2)-c(20)*M(9)) * den(418)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(20)*M(2)+c(27)*M(9)) * den(417)
  T2sum(1:15,119) = T2sum(1:15,119) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(6)*(-M(2)+M(11))) * den(558)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(21)*M(2)-c(20)*M(4)-c(24)*M(9)) * den(103)
  T3sum(1:35,107) = T3sum(1:35,107) + Gcoeff * G3tensor(:,54)
  Gcoeff = (-(c(20)*M(4))-c(24)*M(9)+c(21)*M(11)) * den(103)
  T3sum(1:35,108) = T3sum(1:35,108) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(20)*M(9))+c(21)*M(11)) * den(562)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(27)*M(9)+c(20)*M(11)) * den(164)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(6)*M(4)+c(13)*M(9)) * den(51)
  T3sum(1:35,235) = T3sum(1:35,235) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(21)*(-M(4)-M(9))+c(20)*M(11)) * den(51)
  T3sum(1:35,236) = T3sum(1:35,236) + Gcoeff * G3tensor(:,13)
  Gcoeff = (c(20)*M(2)+c(21)*(-M(4)-M(9))) * den(51)
  T3sum(1:35,244) = T3sum(1:35,244) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(25)*M(1))+c(22)*M(3)) * den(639)
  T2sum(1:15,129) = T2sum(1:15,129) + Gcoeff * G2tensor(:,15)
  Gcoeff = (-(c(22)*M(1))+c(25)*M(3)) * den(639)
  T2sum(1:15,130) = T2sum(1:15,130) + Gcoeff * G2tensor(:,34)
  Gcoeff = (-(c(21)*M(1))+c(20)*M(10)) * den(365)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(20)*M(1))-c(27)*M(10)) * den(364)
  T2sum(1:15,135) = T2sum(1:15,135) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(6)*(M(1)-M(12))) * den(567)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,45)
  Gcoeff = (-(c(21)*M(1))+c(20)*M(3)+c(24)*M(10)) * den(82)
  T3sum(1:35,156) = T3sum(1:35,156) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(20)*M(3)+c(24)*M(10)-c(21)*M(12)) * den(82)
  T3sum(1:35,157) = T3sum(1:35,157) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(20)*M(10)-c(21)*M(12)) * den(570)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,46)
  Gcoeff = (-(c(27)*M(10))-c(20)*M(12)) * den(149)
  T2sum(1:15,141) = T2sum(1:15,141) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(6)*M(3))-c(13)*M(10)) * den(15)
  T3sum(1:35,251) = T3sum(1:35,251) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(21)*(M(3)+M(10))-c(20)*M(12)) * den(15)
  T3sum(1:35,252) = T3sum(1:35,252) + Gcoeff * G3tensor(:,8)
  Gcoeff = (-(c(20)*M(1))+c(21)*(M(3)+M(10))) * den(15)
  T3sum(1:35,260) = T3sum(1:35,260) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(21)*M(3)-c(20)*M(5)) * den(432)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(20)*M(3)+c(27)*M(5)) * den(431)
  T2sum(1:15,147) = T2sum(1:15,147) + Gcoeff * G2tensor(:,35)
  Gcoeff = (-(c(21)*M(4))+c(20)*M(6)) * den(380)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,48)
  Gcoeff = (-(c(20)*M(4))-c(27)*M(6)) * den(379)
  T2sum(1:15,151) = T2sum(1:15,151) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(6)*(M(3)-M(6))) * den(575)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,49)
  Gcoeff = (-(c(20)*M(4))-c(24)*M(5)+c(21)*M(6)) * den(111)
  T3sum(1:35,107) = T3sum(1:35,107) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(21)*M(3)-c(20)*M(4)-c(24)*M(5)) * den(111)
  T3sum(1:35,108) = T3sum(1:35,108) + Gcoeff * G3tensor(:,17)
  Gcoeff = (-(c(20)*M(5))+c(21)*M(6)) * den(576)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(6)*(-M(4)+M(5))) * den(578)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(20)*M(3)-c(21)*M(5)+c(24)*M(6)) * den(90)
  T3sum(1:35,156) = T3sum(1:35,156) + Gcoeff * G3tensor(:,57)
  Gcoeff = (c(20)*M(3)-c(21)*M(4)+c(24)*M(6)) * den(90)
  T3sum(1:35,157) = T3sum(1:35,157) + Gcoeff * G3tensor(:,18)
  Gcoeff = (-(c(21)*M(5))+c(20)*M(6)) * den(579)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(20)*M(5))-c(27)*M(6)) * den(194)
  T2sum(1:15,160) = T2sum(1:15,160) + Gcoeff * G2tensor(:,10)
  Gcoeff = (-(c(20)*M(5))+c(21)*(M(3)+M(6))) * den(84)
  T3sum(1:35,272) = T3sum(1:35,272) + Gcoeff * G3tensor(:,1)
  Gcoeff = (-(c(6)*M(3))-c(13)*M(6)) * den(84)
  T3sum(1:35,276) = T3sum(1:35,276) + Gcoeff * G3tensor(:,2)
  Gcoeff = (-(c(20)*M(4))+c(21)*(M(3)+M(6))) * den(84)
  T3sum(1:35,277) = T3sum(1:35,277) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(6)*(M(3)-M(7))) * den(590)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(20)*M(1))+c(21)*M(3)-c(24)*M(5)) * den(114)
  T3sum(1:35,110) = T3sum(1:35,110) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(20)*M(1))-c(24)*M(5)+c(21)*M(7)) * den(114)
  T3sum(1:35,111) = T3sum(1:35,111) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(20)*M(5))+c(21)*M(7)) * den(594)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(27)*M(5)+c(20)*M(7)) * den(167)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(6)*M(1)+c(13)*M(5)) * den(59)
  T3sum(1:35,299) = T3sum(1:35,299) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(21)*(-M(1)-M(5))+c(20)*M(7)) * den(59)
  T3sum(1:35,300) = T3sum(1:35,300) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(20)*M(3)+c(21)*(-M(1)-M(5))) * den(59)
  T3sum(1:35,308) = T3sum(1:35,308) + Gcoeff * G3tensor(:,50)
  Gcoeff = (c(6)*(-M(4)+M(8))) * den(599)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(20)*M(2)-c(21)*M(4)+c(24)*M(6)) * den(94)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,59)
  Gcoeff = (c(20)*M(2)+c(24)*M(6)-c(21)*M(8)) * den(94)
  T3sum(1:35,160) = T3sum(1:35,160) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(20)*M(6)-c(21)*M(8)) * den(602)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(27)*M(6))-c(20)*M(8)) * den(152)
  T2sum(1:15,141) = T2sum(1:15,141) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(6)*M(2))-c(13)*M(6)) * den(24)
  T3sum(1:35,315) = T3sum(1:35,315) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(21)*(M(2)+M(6))-c(20)*M(8)) * den(24)
  T3sum(1:35,316) = T3sum(1:35,316) + Gcoeff * G3tensor(:,24)
  Gcoeff = (-(c(20)*M(4))+c(21)*(M(2)+M(6))) * den(24)
  T3sum(1:35,324) = T3sum(1:35,324) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(6)*(-M(2)+M(10))) * den(607)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(20)*M(1))-c(24)*M(9)+c(21)*M(10)) * den(118)
  T3sum(1:35,110) = T3sum(1:35,110) + Gcoeff * G3tensor(:,60)
  Gcoeff = (-(c(20)*M(1))+c(21)*M(2)-c(24)*M(9)) * den(118)
  T3sum(1:35,111) = T3sum(1:35,111) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(20)*M(9))+c(21)*M(10)) * den(608)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(6)*(M(1)-M(9))) * den(610)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,59)
  Gcoeff = (c(20)*M(2)-c(21)*M(9)+c(24)*M(10)) * den(97)
  T3sum(1:35,159) = T3sum(1:35,159) + Gcoeff * G3tensor(:,61)
  Gcoeff = (-(c(21)*M(1))+c(20)*M(2)+c(24)*M(10)) * den(97)
  T3sum(1:35,160) = T3sum(1:35,160) + Gcoeff * G3tensor(:,34)
  Gcoeff = (-(c(21)*M(9))+c(20)*M(10)) * den(611)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(20)*M(9))-c(27)*M(10)) * den(197)
  T2sum(1:15,160) = T2sum(1:15,160) + Gcoeff * G2tensor(:,11)
  Gcoeff = (-(c(20)*M(9))+c(21)*(M(2)+M(10))) * den(77)
  T3sum(1:35,336) = T3sum(1:35,336) + Gcoeff * G3tensor(:,3)
  Gcoeff = (-(c(6)*M(2))-c(13)*M(10)) * den(77)
  T3sum(1:35,340) = T3sum(1:35,340) + Gcoeff * G3tensor(:,4)
  Gcoeff = (-(c(20)*M(1))+c(21)*(M(2)+M(10))) * den(77)
  T3sum(1:35,341) = T3sum(1:35,341) + Gcoeff * G3tensor(:,35)
  Gcoeff = (c(5)*(M(5)-M(9))+c(6)*(-M(7)+M(11))) * den(620)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(5)*(M(5)-M(9))+c(6)*(-M(6)+M(10))) * den(621)
  T2sum(1:15,8) = T2sum(1:15,8) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(12)*(-M(5)+M(9))+c(5)*(-M(7)+M(11))) * den(75)
  T2sum(1:15,125) = T2sum(1:15,125) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(5)*(-M(6)+M(10))+c(6)*(M(8)-M(12))) * den(624)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(6)*(M(5)-M(9))+c(5)*(-M(6)+M(10))) * den(625)
  T2sum(1:15,15) = T2sum(1:15,15) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(12)*(M(6)-M(10))+c(5)*(M(8)-M(12))) * den(42)
  T2sum(1:15,141) = T2sum(1:15,141) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(5)*(M(5)-M(9))+c(12)*(M(6)-M(10))) * den(200)
  T2sum(1:15,160) = T2sum(1:15,160) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(6)*(-M(6)-M(7)+M(10)+M(11))+c(5)*(M(8)-M(12))) * den(7)
  T3sum(1:35,366) = T3sum(1:35,366) + Gcoeff * G3tensor(:,41)
  Gcoeff = (c(28)*(M(6)-M(10))+c(21)*(M(7)-M(11))) * den(7)
  T3sum(1:35,51) = T3sum(1:35,51) + Gcoeff * G3tensor(:,5)
  Gcoeff = (c(5)*(M(5)-M(9))+c(6)*(-M(6)-M(7)+M(10)+M(11))) * den(7)
  T3sum(1:35,369) = T3sum(1:35,369) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(21)*(M(10)+M(11))-c(20)*M(12)-c(24)*M(13))
  T4sum(1:70,139) = T4sum(1:70,139) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(21)*(M(6)+M(7))-c(20)*M(8)-c(24)*M(13))
  T4sum(1:70,141) = T4sum(1:70,141) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(21)*(-M(2)-M(3)+M(7))-c(28)*M(10)-c(24)*M(13))
  T4sum(1:70,144) = T4sum(1:70,144) + Gcoeff * G4tensor(:,3)
  Gcoeff = (-(c(28)*M(6))+c(21)*(-M(2)-M(3)+M(11))-c(24)*M(13))
  T4sum(1:70,146) = T4sum(1:70,146) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(6)*(M(3)-M(11))+c(9)*M(13))
  T4sum(1:70,147) = T4sum(1:70,147) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(6)*(M(2)-M(7))+c(9)*M(13))
  T4sum(1:70,149) = T4sum(1:70,149) + Gcoeff * G4tensor(:,19)
  Gcoeff = (-(c(20)*M(9))+c(21)*(M(10)+M(11))-c(24)*M(13))
  T4sum(1:70,169) = T4sum(1:70,169) + Gcoeff * G4tensor(:,5)
  Gcoeff = (-(c(20)*M(4))+c(21)*(M(6)+M(11))-c(24)*M(13))
  T4sum(1:70,173) = T4sum(1:70,173) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(6)*(M(2)-M(11))+c(9)*M(13))
  T4sum(1:70,176) = T4sum(1:70,176) + Gcoeff * G4tensor(:,2)
  Gcoeff = (-(c(20)*M(5))+c(21)*(M(6)+M(7))-c(24)*M(13))
  T4sum(1:70,178) = T4sum(1:70,178) + Gcoeff * G4tensor(:,6)
  Gcoeff = (-(c(20)*M(1))+c(21)*(M(7)+M(10))-c(24)*M(13))
  T4sum(1:70,181) = T4sum(1:70,181) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(6)*(M(3)-M(7))+c(9)*M(13))
  T4sum(1:70,185) = T4sum(1:70,185) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(18)*(M(1)+M(4))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(18)*(M(8)+M(9))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(8)+M(9))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(18)*(M(8)+M(9))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(18)*(M(1)+M(4))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(18)*(M(1)+M(4)-M(8)-M(9))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(8)+M(9))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(18)*(M(1)+M(4)-M(8)-M(9))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(19)*(M(1)+M(4)-M(8)-M(9))) * den(6)
  T2sum(1:1,180) = T2sum(1:1,180) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(18)*(M(1)+M(4))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,10)
  Gcoeff = (c(16)*(-M(6)-M(7)-M(10)-M(11))+c(18)*(M(5)+M(12))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,11)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(5)+M(12))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,12)
  Gcoeff = (c(16)*(-M(6)-M(7)-M(10)-M(11))+c(18)*(M(5)+M(12))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,13)
  Gcoeff = (c(18)*(M(1)+M(4))+c(16)*(-M(6)-M(7)-M(10)-M(11))+c(17)*(M(2)+M(3)+M(14))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,14)
  Gcoeff = (c(18)*(M(1)+M(4)-M(5)-M(12))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,15)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(5)+M(12))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,16)
  Gcoeff = (c(18)*(M(1)+M(4)-M(5)-M(12))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,17)
  Gcoeff = (c(19)*(M(1)+M(4)-M(5)-M(12))) * den(6)
  T2sum(1:1,181) = T2sum(1:1,181) + Gcoeff * G0tensor(:,18)
  Gcoeff = (c(19)*(M(2)+M(3)-M(6)-M(11))) * den(143)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(19)*(M(6)-M(7)-M(10)+M(11))) * den(143)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,68)
  Gcoeff = (c(19)*(-M(2)-M(3)+M(7)+M(10))) * den(143)
  T2sum(1:15,183) = T2sum(1:15,183) + Gcoeff * G2tensor(:,70)
  Gcoeff = (c(18)*(M(5)-M(8)-M(9)+M(12))) * den(644)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(18)*(-M(5)+M(8)+M(9)-M(12))) * den(644)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(19)*(-M(5)+M(8)+M(9)-M(12))) * den(644)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(18)*(-M(5)+M(8)+M(9)-M(12))) * den(645)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,62)
  Gcoeff = (c(18)*(M(5)-M(8)-M(9)+M(12))) * den(645)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,64)
  Gcoeff = (c(19)*(M(5)-M(8)-M(9)+M(12))) * den(645)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,66)
  Gcoeff = (c(18)*(M(1)+M(4)-M(8)-M(9))) * den(47)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,68)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(8)+M(9))) * den(47)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,70)
  Gcoeff = (c(19)*(-M(1)-M(4)+M(8)+M(9))) * den(47)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,72)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(8)+M(9))) * den(47)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(18)*(M(1)+M(4)-M(8)-M(9))) * den(47)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(19)*(M(1)+M(4)-M(8)-M(9))) * den(47)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(18)*(M(1)+M(4)-M(5)-M(12))) * den(50)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(5)+M(12))) * den(50)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(19)*(-M(1)-M(4)+M(5)+M(12))) * den(50)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(5)+M(12))) * den(50)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,48)
  Gcoeff = (c(18)*(M(1)+M(4)-M(5)-M(12))) * den(50)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,53)
  Gcoeff = (c(19)*(M(1)+M(4)-M(5)-M(12))) * den(50)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,58)
  Gcoeff = (c(18)*(M(1)+M(4)-M(5)-M(12))) * den(161)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,74)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(5)+M(12))) * den(161)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,76)
  Gcoeff = (c(19)*(-M(1)-M(4)+M(5)+M(12))) * den(161)
  T2sum(1:5,189) = T2sum(1:5,189) + Gcoeff * G1tensor(:,78)
  Gcoeff = (c(18)*(M(1)+M(4)-M(8)-M(9))) * den(163)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(18)*(-M(1)-M(4)+M(8)+M(9))) * den(163)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(19)*(-M(1)-M(4)+M(8)+M(9))) * den(163)
  T2sum(1:5,188) = T2sum(1:5,188) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(19)*(-M(1)-M(4)+M(5)+M(12))) * den(156)
  T2sum(1:15,188) = T2sum(1:15,188) + Gcoeff * G2tensor(:,114)
  Gcoeff = (c(19)*(-M(5)+M(8)+M(9)-M(12))) * den(156)
  T2sum(1:15,188) = T2sum(1:15,188) + Gcoeff * G2tensor(:,116)
  Gcoeff = (c(19)*(M(1)+M(4)-M(8)-M(9))) * den(156)
  T2sum(1:15,188) = T2sum(1:15,188) + Gcoeff * G2tensor(:,118)
  Gcoeff = (c(3)*(-M(4)+M(9))) * den(55)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(3)*(M(4)-M(9))) * den(55)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(4)*(M(4)-M(9))) * den(55)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(3)*(M(1)-M(8))) * den(65)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(-M(1)+M(8))) * den(65)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(4)*(-M(1)+M(8))) * den(65)
  T2sum(1:5,180) = T2sum(1:5,180) + Gcoeff * G1tensor(:,27)
  Gcoeff = (c(3)*(-M(1)+M(12))) * den(83)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,49)
  Gcoeff = (c(3)*(M(1)-M(12))) * den(83)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,54)
  Gcoeff = (c(4)*(M(1)-M(12))) * den(83)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,59)
  Gcoeff = (c(3)*(M(4)-M(5))) * den(91)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,50)
  Gcoeff = (c(3)*(-M(4)+M(5))) * den(91)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,55)
  Gcoeff = (c(4)*(-M(4)+M(5))) * den(91)
  T2sum(1:5,181) = T2sum(1:5,181) + Gcoeff * G1tensor(:,60)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_3

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_3_pptttt_tttxtxgg_1_/**/REALKIND
