
module ol_vamp_2_pptttt_tttxtxddx_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_2(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_tttxtxddx_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_tttxtxddx_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_tttxtxddx_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_tttxtxddx_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(6)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,61) :: G0
  complex(REALKIND), dimension(4,5,4,141) :: G1
  complex(REALKIND), dimension(15,90) :: G2tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,3),Q(:,48),G1(:,:,:,1))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,4),Q(:,15),G2tensor(:,1))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,148),Q(:,15),G2tensor(:,2))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,149),Q(:,15),G2tensor(:,3))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,19),Q(:,15),G2tensor(:,4))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,152),Q(:,15),G2tensor(:,5))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,153),Q(:,15),G2tensor(:,6))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,156),Q(:,15),G2tensor(:,7))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,157),Q(:,15),G2tensor(:,8))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,160),Q(:,15),G2tensor(:,9))
  call check_last_CV_D(l_switch,G1(:,:,:,1),Q(:,48),wf(:,161),Q(:,15),G2tensor(:,10))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,2))
  call loop_Q_A(G0(:,:,:,2),Q(:,53),ZERO,G1(:,:,:,2))
  call loop_QV_A(G1(:,:,:,2),wf(:,2),G1(:,:,:,3))
  call check_last_Q_A(l_switch,G1(:,:,:,3),Q(:,63),ZERO,G2tensor(:,11))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,53),MT,G1(:,:,:,4))
  call loop_QV_A(G1(:,:,:,4),wf(:,2),G1(:,:,:,5))
  call check_last_Q_A(l_switch,G1(:,:,:,5),Q(:,63),MT,G2tensor(:,12))
  call loop_QV_A(G0(:,:,:,1),wf(:,111),G0(:,:,:,4))
  call loop_Q_A(G0(:,:,:,4),Q(:,53),MB,G1(:,:,:,6))
  call loop_QV_A(G1(:,:,:,6),wf(:,2),G1(:,:,:,7))
  call check_last_Q_A(l_switch,G1(:,:,:,7),Q(:,63),MB,G2tensor(:,13))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,111),Q(:,53),G1(:,:,:,8))
  call check_last_CV_D(l_switch,G1(:,:,:,8),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,14))
  call loop_QV_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,5))
  call loop_Q_A(G0(:,:,:,5),Q(:,58),ZERO,G1(:,:,:,9))
  call loop_QV_A(G1(:,:,:,9),wf(:,1),G1(:,:,:,10))
  call check_last_Q_A(l_switch,G1(:,:,:,10),Q(:,63),ZERO,G2tensor(:,15))
  call loop_QV_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,6))
  call loop_Q_A(G0(:,:,:,6),Q(:,58),MT,G1(:,:,:,11))
  call loop_QV_A(G1(:,:,:,11),wf(:,1),G1(:,:,:,12))
  call check_last_Q_A(l_switch,G1(:,:,:,12),Q(:,63),MT,G2tensor(:,16))
  call loop_QV_A(G0(:,:,:,1),wf(:,109),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,58),MB,G1(:,:,:,13))
  call loop_QV_A(G1(:,:,:,13),wf(:,1),G1(:,:,:,14))
  call check_last_Q_A(l_switch,G1(:,:,:,14),Q(:,63),MB,G2tensor(:,17))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,109),Q(:,58),G1(:,:,:,15))
  call check_last_CV_D(l_switch,G1(:,:,:,15),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,18))
  call loop_QV_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,8))
  call loop_Q_A(G0(:,:,:,8),Q(:,53),ZERO,G1(:,:,:,16))
  call loop_QV_A(G1(:,:,:,16),wf(:,2),G1(:,:,:,17))
  call check_last_Q_A(l_switch,G1(:,:,:,17),Q(:,63),ZERO,G2tensor(:,19))
  call loop_QV_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,9))
  call loop_Q_A(G0(:,:,:,9),Q(:,53),MT,G1(:,:,:,18))
  call loop_QV_A(G1(:,:,:,18),wf(:,2),G1(:,:,:,19))
  call check_last_Q_A(l_switch,G1(:,:,:,19),Q(:,63),MT,G2tensor(:,20))
  call loop_QV_A(G0(:,:,:,1),wf(:,150),G0(:,:,:,10))
  call loop_Q_A(G0(:,:,:,10),Q(:,53),MB,G1(:,:,:,20))
  call loop_QV_A(G1(:,:,:,20),wf(:,2),G1(:,:,:,21))
  call check_last_Q_A(l_switch,G1(:,:,:,21),Q(:,63),MB,G2tensor(:,21))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,150),Q(:,53),G1(:,:,:,22))
  call check_last_CV_D(l_switch,G1(:,:,:,22),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,22))
  call loop_QV_A(G0(:,:,:,1),wf(:,151),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,53),ZERO,G1(:,:,:,23))
  call loop_QV_A(G1(:,:,:,23),wf(:,2),G1(:,:,:,24))
  call check_last_Q_A(l_switch,G1(:,:,:,24),Q(:,63),ZERO,G2tensor(:,23))
  call loop_QV_A(G0(:,:,:,1),wf(:,151),G0(:,:,:,12))
  call loop_Q_A(G0(:,:,:,12),Q(:,53),MT,G1(:,:,:,25))
  call loop_QV_A(G1(:,:,:,25),wf(:,2),G1(:,:,:,26))
  call check_last_Q_A(l_switch,G1(:,:,:,26),Q(:,63),MT,G2tensor(:,24))
  call loop_QV_A(G0(:,:,:,1),wf(:,151),G0(:,:,:,13))
  call loop_Q_A(G0(:,:,:,13),Q(:,53),MB,G1(:,:,:,27))
  call loop_QV_A(G1(:,:,:,27),wf(:,2),G1(:,:,:,28))
  call check_last_Q_A(l_switch,G1(:,:,:,28),Q(:,63),MB,G2tensor(:,25))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,151),Q(:,53),G1(:,:,:,29))
  call check_last_CV_D(l_switch,G1(:,:,:,29),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,26))
  call loop_QV_A(G0(:,:,:,1),wf(:,162),G0(:,:,:,14))
  call loop_Q_A(G0(:,:,:,14),Q(:,58),ZERO,G1(:,:,:,30))
  call loop_QV_A(G1(:,:,:,30),wf(:,1),G1(:,:,:,31))
  call check_last_Q_A(l_switch,G1(:,:,:,31),Q(:,63),ZERO,G2tensor(:,27))
  call loop_QV_A(G0(:,:,:,1),wf(:,162),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,58),MT,G1(:,:,:,32))
  call loop_QV_A(G1(:,:,:,32),wf(:,1),G1(:,:,:,33))
  call check_last_Q_A(l_switch,G1(:,:,:,33),Q(:,63),MT,G2tensor(:,28))
  call loop_QV_A(G0(:,:,:,1),wf(:,162),G0(:,:,:,16))
  call loop_Q_A(G0(:,:,:,16),Q(:,58),MB,G1(:,:,:,34))
  call loop_QV_A(G1(:,:,:,34),wf(:,1),G1(:,:,:,35))
  call check_last_Q_A(l_switch,G1(:,:,:,35),Q(:,63),MB,G2tensor(:,29))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,162),Q(:,58),G1(:,:,:,36))
  call check_last_CV_D(l_switch,G1(:,:,:,36),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,30))
  call loop_QV_A(G0(:,:,:,1),wf(:,163),G0(:,:,:,17))
  call loop_Q_A(G0(:,:,:,17),Q(:,58),ZERO,G1(:,:,:,37))
  call loop_QV_A(G1(:,:,:,37),wf(:,1),G1(:,:,:,38))
  call check_last_Q_A(l_switch,G1(:,:,:,38),Q(:,63),ZERO,G2tensor(:,31))
  call loop_QV_A(G0(:,:,:,1),wf(:,163),G0(:,:,:,18))
  call loop_Q_A(G0(:,:,:,18),Q(:,58),MT,G1(:,:,:,39))
  call loop_QV_A(G1(:,:,:,39),wf(:,1),G1(:,:,:,40))
  call check_last_Q_A(l_switch,G1(:,:,:,40),Q(:,63),MT,G2tensor(:,32))
  call loop_QV_A(G0(:,:,:,1),wf(:,163),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,58),MB,G1(:,:,:,41))
  call loop_QV_A(G1(:,:,:,41),wf(:,1),G1(:,:,:,42))
  call check_last_Q_A(l_switch,G1(:,:,:,42),Q(:,63),MB,G2tensor(:,33))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,163),Q(:,58),G1(:,:,:,43))
  call check_last_CV_D(l_switch,G1(:,:,:,43),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,34))
  call loop_QV_A(G0(:,:,:,1),wf(:,170),G0(:,:,:,20))
  call loop_Q_A(G0(:,:,:,20),Q(:,58),ZERO,G1(:,:,:,44))
  call loop_QV_A(G1(:,:,:,44),wf(:,1),G1(:,:,:,45))
  call check_last_Q_A(l_switch,G1(:,:,:,45),Q(:,63),ZERO,G2tensor(:,35))
  call loop_QV_A(G0(:,:,:,1),wf(:,170),G0(:,:,:,21))
  call loop_Q_A(G0(:,:,:,21),Q(:,58),MT,G1(:,:,:,46))
  call loop_QV_A(G1(:,:,:,46),wf(:,1),G1(:,:,:,47))
  call check_last_Q_A(l_switch,G1(:,:,:,47),Q(:,63),MT,G2tensor(:,36))
  call loop_QV_A(G0(:,:,:,1),wf(:,170),G0(:,:,:,22))
  call loop_Q_A(G0(:,:,:,22),Q(:,58),MB,G1(:,:,:,48))
  call loop_QV_A(G1(:,:,:,48),wf(:,1),G1(:,:,:,49))
  call check_last_Q_A(l_switch,G1(:,:,:,49),Q(:,63),MB,G2tensor(:,37))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,170),Q(:,58),G1(:,:,:,50))
  call check_last_CV_D(l_switch,G1(:,:,:,50),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,38))
  call loop_QV_A(G0(:,:,:,1),wf(:,171),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,58),ZERO,G1(:,:,:,51))
  call loop_QV_A(G1(:,:,:,51),wf(:,1),G1(:,:,:,52))
  call check_last_Q_A(l_switch,G1(:,:,:,52),Q(:,63),ZERO,G2tensor(:,39))
  call loop_QV_A(G0(:,:,:,1),wf(:,171),G0(:,:,:,24))
  call loop_Q_A(G0(:,:,:,24),Q(:,58),MT,G1(:,:,:,53))
  call loop_QV_A(G1(:,:,:,53),wf(:,1),G1(:,:,:,54))
  call check_last_Q_A(l_switch,G1(:,:,:,54),Q(:,63),MT,G2tensor(:,40))
  call loop_QV_A(G0(:,:,:,1),wf(:,171),G0(:,:,:,25))
  call loop_Q_A(G0(:,:,:,25),Q(:,58),MB,G1(:,:,:,55))
  call loop_QV_A(G1(:,:,:,55),wf(:,1),G1(:,:,:,56))
  call check_last_Q_A(l_switch,G1(:,:,:,56),Q(:,63),MB,G2tensor(:,41))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,171),Q(:,58),G1(:,:,:,57))
  call check_last_CV_D(l_switch,G1(:,:,:,57),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,42))
  call loop_QV_A(G0(:,:,:,1),wf(:,128),G0(:,:,:,26))
  call loop_Q_A(G0(:,:,:,26),Q(:,57),ZERO,G1(:,:,:,58))
  call loop_QV_A(G1(:,:,:,58),wf(:,18),G1(:,:,:,59))
  call check_last_Q_A(l_switch,G1(:,:,:,59),Q(:,63),ZERO,G2tensor(:,43))
  call loop_QV_A(G0(:,:,:,1),wf(:,128),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,57),MT,G1(:,:,:,60))
  call loop_QV_A(G1(:,:,:,60),wf(:,18),G1(:,:,:,61))
  call check_last_Q_A(l_switch,G1(:,:,:,61),Q(:,63),MT,G2tensor(:,44))
  call loop_QV_A(G0(:,:,:,1),wf(:,128),G0(:,:,:,28))
  call loop_Q_A(G0(:,:,:,28),Q(:,57),MB,G1(:,:,:,62))
  call loop_QV_A(G1(:,:,:,62),wf(:,18),G1(:,:,:,63))
  call check_last_Q_A(l_switch,G1(:,:,:,63),Q(:,63),MB,G2tensor(:,45))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,128),Q(:,57),G1(:,:,:,64))
  call check_last_CV_D(l_switch,G1(:,:,:,64),Q(:,57),wf(:,18),Q(:,6),G2tensor(:,46))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,29))
  call loop_Q_A(G0(:,:,:,29),Q(:,54),ZERO,G1(:,:,:,65))
  call loop_QV_A(G1(:,:,:,65),wf(:,17),G1(:,:,:,66))
  call check_last_Q_A(l_switch,G1(:,:,:,66),Q(:,63),ZERO,G2tensor(:,47))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,30))
  call loop_Q_A(G0(:,:,:,30),Q(:,54),MT,G1(:,:,:,67))
  call loop_QV_A(G1(:,:,:,67),wf(:,17),G1(:,:,:,68))
  call check_last_Q_A(l_switch,G1(:,:,:,68),Q(:,63),MT,G2tensor(:,48))
  call loop_QV_A(G0(:,:,:,1),wf(:,126),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,54),MB,G1(:,:,:,69))
  call loop_QV_A(G1(:,:,:,69),wf(:,17),G1(:,:,:,70))
  call check_last_Q_A(l_switch,G1(:,:,:,70),Q(:,63),MB,G2tensor(:,49))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,126),Q(:,54),G1(:,:,:,71))
  call check_last_CV_D(l_switch,G1(:,:,:,71),Q(:,54),wf(:,17),Q(:,9),G2tensor(:,50))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,32))
  call loop_Q_A(G0(:,:,:,32),Q(:,57),ZERO,G1(:,:,:,72))
  call loop_QV_A(G1(:,:,:,72),wf(:,18),G1(:,:,:,73))
  call check_last_Q_A(l_switch,G1(:,:,:,73),Q(:,63),ZERO,G2tensor(:,51))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,33))
  call loop_Q_A(G0(:,:,:,33),Q(:,57),MT,G1(:,:,:,74))
  call loop_QV_A(G1(:,:,:,74),wf(:,18),G1(:,:,:,75))
  call check_last_Q_A(l_switch,G1(:,:,:,75),Q(:,63),MT,G2tensor(:,52))
  call loop_QV_A(G0(:,:,:,1),wf(:,158),G0(:,:,:,34))
  call loop_Q_A(G0(:,:,:,34),Q(:,57),MB,G1(:,:,:,76))
  call loop_QV_A(G1(:,:,:,76),wf(:,18),G1(:,:,:,77))
  call check_last_Q_A(l_switch,G1(:,:,:,77),Q(:,63),MB,G2tensor(:,53))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,158),Q(:,57),G1(:,:,:,78))
  call check_last_CV_D(l_switch,G1(:,:,:,78),Q(:,57),wf(:,18),Q(:,6),G2tensor(:,54))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,57),ZERO,G1(:,:,:,79))
  call loop_QV_A(G1(:,:,:,79),wf(:,18),G1(:,:,:,80))
  call check_last_Q_A(l_switch,G1(:,:,:,80),Q(:,63),ZERO,G2tensor(:,55))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,36))
  call loop_Q_A(G0(:,:,:,36),Q(:,57),MT,G1(:,:,:,81))
  call loop_QV_A(G1(:,:,:,81),wf(:,18),G1(:,:,:,82))
  call check_last_Q_A(l_switch,G1(:,:,:,82),Q(:,63),MT,G2tensor(:,56))
  call loop_QV_A(G0(:,:,:,1),wf(:,159),G0(:,:,:,37))
  call loop_Q_A(G0(:,:,:,37),Q(:,57),MB,G1(:,:,:,83))
  call loop_QV_A(G1(:,:,:,83),wf(:,18),G1(:,:,:,84))
  call check_last_Q_A(l_switch,G1(:,:,:,84),Q(:,63),MB,G2tensor(:,57))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,159),Q(:,57),G1(:,:,:,85))
  call check_last_CV_D(l_switch,G1(:,:,:,85),Q(:,57),wf(:,18),Q(:,6),G2tensor(:,58))
  call loop_QV_A(G0(:,:,:,1),wf(:,154),G0(:,:,:,38))
  call loop_Q_A(G0(:,:,:,38),Q(:,54),ZERO,G1(:,:,:,86))
  call loop_QV_A(G1(:,:,:,86),wf(:,17),G1(:,:,:,87))
  call check_last_Q_A(l_switch,G1(:,:,:,87),Q(:,63),ZERO,G2tensor(:,59))
  call loop_QV_A(G0(:,:,:,1),wf(:,154),G0(:,:,:,39))
  call loop_Q_A(G0(:,:,:,39),Q(:,54),MT,G1(:,:,:,88))
  call loop_QV_A(G1(:,:,:,88),wf(:,17),G1(:,:,:,89))
  call check_last_Q_A(l_switch,G1(:,:,:,89),Q(:,63),MT,G2tensor(:,60))
  call loop_QV_A(G0(:,:,:,1),wf(:,154),G0(:,:,:,40))
  call loop_Q_A(G0(:,:,:,40),Q(:,54),MB,G1(:,:,:,90))
  call loop_QV_A(G1(:,:,:,90),wf(:,17),G1(:,:,:,91))
  call check_last_Q_A(l_switch,G1(:,:,:,91),Q(:,63),MB,G2tensor(:,61))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,154),Q(:,54),G1(:,:,:,92))
  call check_last_CV_D(l_switch,G1(:,:,:,92),Q(:,54),wf(:,17),Q(:,9),G2tensor(:,62))
  call loop_QV_A(G0(:,:,:,1),wf(:,155),G0(:,:,:,41))
  call loop_Q_A(G0(:,:,:,41),Q(:,54),ZERO,G1(:,:,:,93))
  call loop_QV_A(G1(:,:,:,93),wf(:,17),G1(:,:,:,94))
  call check_last_Q_A(l_switch,G1(:,:,:,94),Q(:,63),ZERO,G2tensor(:,63))
  call loop_QV_A(G0(:,:,:,1),wf(:,155),G0(:,:,:,42))
  call loop_Q_A(G0(:,:,:,42),Q(:,54),MT,G1(:,:,:,95))
  call loop_QV_A(G1(:,:,:,95),wf(:,17),G1(:,:,:,96))
  call check_last_Q_A(l_switch,G1(:,:,:,96),Q(:,63),MT,G2tensor(:,64))
  call loop_QV_A(G0(:,:,:,1),wf(:,155),G0(:,:,:,43))
  call loop_Q_A(G0(:,:,:,43),Q(:,54),MB,G1(:,:,:,97))
  call loop_QV_A(G1(:,:,:,97),wf(:,17),G1(:,:,:,98))
  call check_last_Q_A(l_switch,G1(:,:,:,98),Q(:,63),MB,G2tensor(:,65))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,155),Q(:,54),G1(:,:,:,99))
  call check_last_CV_D(l_switch,G1(:,:,:,99),Q(:,54),wf(:,17),Q(:,9),G2tensor(:,66))
  call loop_QV_A(G0(:,:,:,1),wf(:,166),G0(:,:,:,44))
  call loop_Q_A(G0(:,:,:,44),Q(:,57),ZERO,G1(:,:,:,100))
  call loop_QV_A(G1(:,:,:,100),wf(:,18),G1(:,:,:,101))
  call check_last_Q_A(l_switch,G1(:,:,:,101),Q(:,63),ZERO,G2tensor(:,67))
  call loop_QV_A(G0(:,:,:,1),wf(:,166),G0(:,:,:,45))
  call loop_Q_A(G0(:,:,:,45),Q(:,57),MT,G1(:,:,:,102))
  call loop_QV_A(G1(:,:,:,102),wf(:,18),G1(:,:,:,103))
  call check_last_Q_A(l_switch,G1(:,:,:,103),Q(:,63),MT,G2tensor(:,68))
  call loop_QV_A(G0(:,:,:,1),wf(:,166),G0(:,:,:,46))
  call loop_Q_A(G0(:,:,:,46),Q(:,57),MB,G1(:,:,:,104))
  call loop_QV_A(G1(:,:,:,104),wf(:,18),G1(:,:,:,105))
  call check_last_Q_A(l_switch,G1(:,:,:,105),Q(:,63),MB,G2tensor(:,69))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,166),Q(:,57),G1(:,:,:,106))
  call check_last_CV_D(l_switch,G1(:,:,:,106),Q(:,57),wf(:,18),Q(:,6),G2tensor(:,70))
  call loop_QV_A(G0(:,:,:,1),wf(:,167),G0(:,:,:,47))
  call loop_Q_A(G0(:,:,:,47),Q(:,57),ZERO,G1(:,:,:,107))
  call loop_QV_A(G1(:,:,:,107),wf(:,18),G1(:,:,:,108))
  call check_last_Q_A(l_switch,G1(:,:,:,108),Q(:,63),ZERO,G2tensor(:,71))
  call loop_QV_A(G0(:,:,:,1),wf(:,167),G0(:,:,:,48))
  call loop_Q_A(G0(:,:,:,48),Q(:,57),MT,G1(:,:,:,109))
  call loop_QV_A(G1(:,:,:,109),wf(:,18),G1(:,:,:,110))
  call check_last_Q_A(l_switch,G1(:,:,:,110),Q(:,63),MT,G2tensor(:,72))
  call loop_QV_A(G0(:,:,:,1),wf(:,167),G0(:,:,:,49))
  call loop_Q_A(G0(:,:,:,49),Q(:,57),MB,G1(:,:,:,111))
  call loop_QV_A(G1(:,:,:,111),wf(:,18),G1(:,:,:,112))
  call check_last_Q_A(l_switch,G1(:,:,:,112),Q(:,63),MB,G2tensor(:,73))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,167),Q(:,57),G1(:,:,:,113))
  call check_last_CV_D(l_switch,G1(:,:,:,113),Q(:,57),wf(:,18),Q(:,6),G2tensor(:,74))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,50))
  call loop_Q_A(G0(:,:,:,50),Q(:,54),ZERO,G1(:,:,:,114))
  call loop_QV_A(G1(:,:,:,114),wf(:,17),G1(:,:,:,115))
  call check_last_Q_A(l_switch,G1(:,:,:,115),Q(:,63),ZERO,G2tensor(:,75))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,51))
  call loop_Q_A(G0(:,:,:,51),Q(:,54),MT,G1(:,:,:,116))
  call loop_QV_A(G1(:,:,:,116),wf(:,17),G1(:,:,:,117))
  call check_last_Q_A(l_switch,G1(:,:,:,117),Q(:,63),MT,G2tensor(:,76))
  call loop_QV_A(G0(:,:,:,1),wf(:,168),G0(:,:,:,52))
  call loop_Q_A(G0(:,:,:,52),Q(:,54),MB,G1(:,:,:,118))
  call loop_QV_A(G1(:,:,:,118),wf(:,17),G1(:,:,:,119))
  call check_last_Q_A(l_switch,G1(:,:,:,119),Q(:,63),MB,G2tensor(:,77))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,168),Q(:,54),G1(:,:,:,120))
  call check_last_CV_D(l_switch,G1(:,:,:,120),Q(:,54),wf(:,17),Q(:,9),G2tensor(:,78))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,53))
  call loop_Q_A(G0(:,:,:,53),Q(:,54),ZERO,G1(:,:,:,121))
  call loop_QV_A(G1(:,:,:,121),wf(:,17),G1(:,:,:,122))
  call check_last_Q_A(l_switch,G1(:,:,:,122),Q(:,63),ZERO,G2tensor(:,79))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,54))
  call loop_Q_A(G0(:,:,:,54),Q(:,54),MT,G1(:,:,:,123))
  call loop_QV_A(G1(:,:,:,123),wf(:,17),G1(:,:,:,124))
  call check_last_Q_A(l_switch,G1(:,:,:,124),Q(:,63),MT,G2tensor(:,80))
  call loop_QV_A(G0(:,:,:,1),wf(:,169),G0(:,:,:,55))
  call loop_Q_A(G0(:,:,:,55),Q(:,54),MB,G1(:,:,:,125))
  call loop_QV_A(G1(:,:,:,125),wf(:,17),G1(:,:,:,126))
  call check_last_Q_A(l_switch,G1(:,:,:,126),Q(:,63),MB,G2tensor(:,81))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,169),Q(:,54),G1(:,:,:,127))
  call check_last_CV_D(l_switch,G1(:,:,:,127),Q(:,54),wf(:,17),Q(:,9),G2tensor(:,82))
  call loop_QV_A(G0(:,:,:,1),wf(:,164),G0(:,:,:,56))
  call loop_Q_A(G0(:,:,:,56),Q(:,53),ZERO,G1(:,:,:,128))
  call loop_QV_A(G1(:,:,:,128),wf(:,2),G1(:,:,:,129))
  call check_last_Q_A(l_switch,G1(:,:,:,129),Q(:,63),ZERO,G2tensor(:,83))
  call loop_QV_A(G0(:,:,:,1),wf(:,164),G0(:,:,:,57))
  call loop_Q_A(G0(:,:,:,57),Q(:,53),MT,G1(:,:,:,130))
  call loop_QV_A(G1(:,:,:,130),wf(:,2),G1(:,:,:,131))
  call check_last_Q_A(l_switch,G1(:,:,:,131),Q(:,63),MT,G2tensor(:,84))
  call loop_QV_A(G0(:,:,:,1),wf(:,164),G0(:,:,:,58))
  call loop_Q_A(G0(:,:,:,58),Q(:,53),MB,G1(:,:,:,132))
  call loop_QV_A(G1(:,:,:,132),wf(:,2),G1(:,:,:,133))
  call check_last_Q_A(l_switch,G1(:,:,:,133),Q(:,63),MB,G2tensor(:,85))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,164),Q(:,53),G1(:,:,:,134))
  call check_last_CV_D(l_switch,G1(:,:,:,134),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,86))
  call loop_QV_A(G0(:,:,:,1),wf(:,165),G0(:,:,:,59))
  call loop_Q_A(G0(:,:,:,59),Q(:,53),ZERO,G1(:,:,:,135))
  call loop_QV_A(G1(:,:,:,135),wf(:,2),G1(:,:,:,136))
  call check_last_Q_A(l_switch,G1(:,:,:,136),Q(:,63),ZERO,G2tensor(:,87))
  call loop_QV_A(G0(:,:,:,1),wf(:,165),G0(:,:,:,60))
  call loop_Q_A(G0(:,:,:,60),Q(:,53),MT,G1(:,:,:,137))
  call loop_QV_A(G1(:,:,:,137),wf(:,2),G1(:,:,:,138))
  call check_last_Q_A(l_switch,G1(:,:,:,138),Q(:,63),MT,G2tensor(:,88))
  call loop_QV_A(G0(:,:,:,1),wf(:,165),G0(:,:,:,61))
  call loop_Q_A(G0(:,:,:,61),Q(:,53),MB,G1(:,:,:,139))
  call loop_QV_A(G1(:,:,:,139),wf(:,2),G1(:,:,:,140))
  call check_last_Q_A(l_switch,G1(:,:,:,140),Q(:,63),MB,G2tensor(:,89))
  call loop_CV_D(G0(:,:,:,1),Q(:,0),wf(:,165),Q(:,53),G1(:,:,:,141))
  call check_last_CV_D(l_switch,G1(:,:,:,141),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,90))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(7)*(-M(2)+M(3))) * den(80)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(28)*(M(2)-M(3))) * den(77)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(27)*(M(2)-M(3))) * den(77)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,12)
  Gcoeff = (c(28)*(M(2)-M(3))) * den(77)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(27)*(M(2)-M(3))) * den(77)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(7)*(M(2)-M(3))) * den(77)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,14)
  Gcoeff = (c(28)*(-M(2)+M(3))) * den(73)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(27)*(-M(2)+M(3))) * den(73)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(28)*(-M(2)+M(3))) * den(73)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(27)*(-M(2)+M(3))) * den(73)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(7)*(-M(2)+M(3))) * den(73)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,18)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(162)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(162)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(162)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(162)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(1)-M(4))+c(17)*M(6)) * den(162)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(163)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(163)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(163)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(163)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(1)-M(4))+c(17)*M(6)) * den(163)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(164)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(164)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(164)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(164)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(1)-M(4))+c(17)*M(6)) * den(164)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,30)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(165)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(165)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(4))+c(33)*M(6)) * den(165)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(4))+c(29)*M(6)) * den(165)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,33)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(1)-M(4))+c(17)*M(6)) * den(165)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(4)-M(5))+c(17)*M(6)) * den(166)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(4)-M(5))+c(17)*M(6)) * den(167)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(4)-M(5))+c(33)*M(6)) * den(168)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(4)-M(5))+c(29)*M(6)) * den(168)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(4)-M(5))+c(33)*M(6)) * den(168)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(4)-M(5))+c(29)*M(6)) * den(168)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(4)-M(5))+c(17)*M(6)) * den(168)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(4)-M(5))+c(33)*M(6)) * den(169)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(4)-M(5))+c(29)*M(6)) * den(169)
  T2sum(1:15,100) = T2sum(1:15,100) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(4)-M(5))+c(33)*M(6)) * den(169)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(4)-M(5))+c(29)*M(6)) * den(169)
  T2sum(1:15,101) = T2sum(1:15,101) + Gcoeff * G2tensor(:,41)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(4)-M(5))+c(17)*M(6)) * den(169)
  T2sum(1:15,91) = T2sum(1:15,91) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(7)*(-M(1)+M(4))) * den(105)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(28)*(-M(1)+M(4))) * den(103)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(27)*(-M(1)+M(4))) * den(103)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,44)
  Gcoeff = (c(28)*(-M(1)+M(4))) * den(103)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(27)*(-M(1)+M(4))) * den(103)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(7)*(-M(1)+M(4))) * den(103)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(28)*(M(1)-M(4))) * den(99)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(27)*(M(1)-M(4))) * den(99)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(28)*(M(1)-M(4))) * den(99)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(27)*(M(1)-M(4))) * den(99)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(7)*(M(1)-M(4))) * den(99)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(35)*(M(2)+M(3))-c(36)*M(4)-c(33)*M(5)) * den(170)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(31)*(M(2)+M(3))-c(32)*M(4)-c(29)*M(5)) * den(170)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,52)
  Gcoeff = (c(35)*(M(2)+M(3))-c(36)*M(4)-c(33)*M(5)) * den(170)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(31)*(M(2)+M(3))-c(32)*M(4)-c(29)*M(5)) * den(170)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,53)
  Gcoeff = (c(22)*(M(2)+M(3))-c(26)*M(4)-c(17)*M(5)) * den(170)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,54)
  Gcoeff = (-(c(36)*M(1))+c(35)*(M(2)+M(3))-c(33)*M(5)) * den(171)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(32)*M(1))+c(31)*(M(2)+M(3))-c(29)*M(5)) * den(171)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,56)
  Gcoeff = (-(c(36)*M(1))+c(35)*(M(2)+M(3))-c(33)*M(5)) * den(171)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,55)
  Gcoeff = (-(c(32)*M(1))+c(31)*(M(2)+M(3))-c(29)*M(5)) * den(171)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(26)*M(1))+c(22)*(M(2)+M(3))-c(17)*M(5)) * den(171)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,58)
  Gcoeff = (-(c(36)*M(1))+c(35)*(M(2)+M(3))-c(33)*M(5)) * den(172)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(32)*M(1))+c(31)*(M(2)+M(3))-c(29)*M(5)) * den(172)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,60)
  Gcoeff = (-(c(36)*M(1))+c(35)*(M(2)+M(3))-c(33)*M(5)) * den(172)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(32)*M(1))+c(31)*(M(2)+M(3))-c(29)*M(5)) * den(172)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,61)
  Gcoeff = (-(c(26)*M(1))+c(22)*(M(2)+M(3))-c(17)*M(5)) * den(172)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(35)*(M(2)+M(3))-c(36)*M(4)-c(33)*M(5)) * den(173)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(31)*(M(2)+M(3))-c(32)*M(4)-c(29)*M(5)) * den(173)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,64)
  Gcoeff = (c(35)*(M(2)+M(3))-c(36)*M(4)-c(33)*M(5)) * den(173)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(31)*(M(2)+M(3))-c(32)*M(4)-c(29)*M(5)) * den(173)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(22)*(M(2)+M(3))-c(26)*M(4)-c(17)*M(5)) * den(173)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,66)
  Gcoeff = (-(c(26)*M(4))-c(17)*M(5)+c(22)*(M(2)+M(6))) * den(174)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,5)
  Gcoeff = (-(c(36)*M(1))-c(33)*M(5)+c(35)*(M(2)+M(6))) * den(175)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(32)*M(1))-c(29)*M(5)+c(31)*(M(2)+M(6))) * den(175)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(36)*M(1))-c(33)*M(5)+c(35)*(M(2)+M(6))) * den(175)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(32)*M(1))-c(29)*M(5)+c(31)*(M(2)+M(6))) * den(175)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,69)
  Gcoeff = (-(c(26)*M(1))-c(17)*M(5)+c(22)*(M(2)+M(6))) * den(175)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(26)*M(1))-c(17)*M(5)+c(22)*(M(2)+M(6))) * den(176)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,6)
  Gcoeff = (-(c(36)*M(4))-c(33)*M(5)+c(35)*(M(2)+M(6))) * den(177)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(32)*M(4))-c(29)*M(5)+c(31)*(M(2)+M(6))) * den(177)
  T2sum(1:15,102) = T2sum(1:15,102) + Gcoeff * G2tensor(:,72)
  Gcoeff = (-(c(36)*M(4))-c(33)*M(5)+c(35)*(M(2)+M(6))) * den(177)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(32)*M(4))-c(29)*M(5)+c(31)*(M(2)+M(6))) * den(177)
  T2sum(1:15,103) = T2sum(1:15,103) + Gcoeff * G2tensor(:,73)
  Gcoeff = (-(c(26)*M(4))-c(17)*M(5)+c(22)*(M(2)+M(6))) * den(177)
  T2sum(1:15,95) = T2sum(1:15,95) + Gcoeff * G2tensor(:,74)
  Gcoeff = (-(c(26)*M(1))-c(17)*M(5)+c(22)*(M(3)+M(6))) * den(178)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,7)
  Gcoeff = (-(c(26)*M(4))-c(17)*M(5)+c(22)*(M(3)+M(6))) * den(179)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(36)*M(4))-c(33)*M(5)+c(35)*(M(3)+M(6))) * den(180)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(32)*M(4))-c(29)*M(5)+c(31)*(M(3)+M(6))) * den(180)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(36)*M(4))-c(33)*M(5)+c(35)*(M(3)+M(6))) * den(180)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,75)
  Gcoeff = (-(c(32)*M(4))-c(29)*M(5)+c(31)*(M(3)+M(6))) * den(180)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,77)
  Gcoeff = (-(c(26)*M(4))-c(17)*M(5)+c(22)*(M(3)+M(6))) * den(180)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(36)*M(1))-c(33)*M(5)+c(35)*(M(3)+M(6))) * den(181)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(32)*M(1))-c(29)*M(5)+c(31)*(M(3)+M(6))) * den(181)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(36)*M(1))-c(33)*M(5)+c(35)*(M(3)+M(6))) * den(181)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,79)
  Gcoeff = (-(c(32)*M(1))-c(29)*M(5)+c(31)*(M(3)+M(6))) * den(181)
  T2sum(1:15,105) = T2sum(1:15,105) + Gcoeff * G2tensor(:,81)
  Gcoeff = (-(c(26)*M(1))-c(17)*M(5)+c(22)*(M(3)+M(6))) * den(181)
  T2sum(1:15,94) = T2sum(1:15,94) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(1)-M(5))+c(17)*M(6)) * den(182)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(5))+c(33)*M(6)) * den(183)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(5))+c(29)*M(6)) * den(183)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(36)*M(2)+c(35)*(-M(1)-M(5))+c(33)*M(6)) * den(183)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(32)*M(2)+c(31)*(-M(1)-M(5))+c(29)*M(6)) * den(183)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(1)-M(5))+c(17)*M(6)) * den(183)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(26)*M(2)+c(22)*(-M(1)-M(5))+c(17)*M(6)) * den(184)
  T2sum(1:15,93) = T2sum(1:15,93) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(5))+c(33)*M(6)) * den(185)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(5))+c(29)*M(6)) * den(185)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(36)*M(3)+c(35)*(-M(1)-M(5))+c(33)*M(6)) * den(185)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,87)
  Gcoeff = (c(32)*M(3)+c(31)*(-M(1)-M(5))+c(29)*M(6)) * den(185)
  T2sum(1:15,99) = T2sum(1:15,99) + Gcoeff * G2tensor(:,89)
  Gcoeff = (c(26)*M(3)+c(22)*(-M(1)-M(5))+c(17)*M(6)) * den(185)
  T2sum(1:15,92) = T2sum(1:15,92) + Gcoeff * G2tensor(:,90)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_2

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_2_pptttt_tttxtxddx_1_/**/REALKIND
