
module ol_vamp_1_pptttt_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none

  contains

! **********************************************************************
subroutine vamp_1(M, mode, hel)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_pptttt_tttxtxgg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_pptttt_tttxtxgg_1.
! **********************************************************************
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/DREALKIND, only: stability_mode
#ifndef PRECISION_dp
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
#endif
  use ol_loop_pptttt_tttxtxgg_1_/**/REALKIND, only: c, f, wf, den
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tensor_sum_storage_pptttt_tttxtxgg_1_/**/REALKIND
  use ol_loop_routines_/**/REALKIND, only: G0initialisation, TI2_call
  implicit none

  complex(REALKIND) :: Gcoeff
  complex(REALKIND), intent(in) :: M(14)
  integer, intent(in) :: mode, hel ! recycle mode & hel conf number

  ! Declarations of loop wave function tensors
  complex(REALKIND), dimension(4,1,4,55) :: G0
  complex(REALKIND), dimension(4,5,4,159) :: G1
  complex(REALKIND), dimension(4,15,4,231) :: G2
  complex(REALKIND), dimension(4,35,4,166) :: G3
  complex(REALKIND), dimension(4,70,4,46) :: G4
  complex(REALKIND), dimension(1,9) :: G0tensor
  complex(REALKIND), dimension(5,45) :: G1tensor
  complex(REALKIND), dimension(15,114) :: G2tensor
  complex(REALKIND), dimension(35,105) :: G3tensor
  complex(REALKIND), dimension(70,50) :: G4tensor
if (mode == -1) return

  if (mode == 1 .or. stability_mode < 20 .or. stability_mode >= 30) then

  call G0initialisation(G0(:,:,:,1))

  ! Vertex and propagator calls to build loop structures
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,-4),Q(:,16),G1(:,:,:,1))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,-5),Q(:,32),G2(:,:,:,1))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,1),wf(:,1),wf(:,2),G2tensor(:,1))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,1),wf(:,2),wf(:,1),G2tensor(:,2))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,1),wf(:,1),wf(:,2),G2tensor(:,3))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,1),wf(:,6),wf(:,7),G2tensor(:,4))
  call check_last_GGG_G_12(l_switch,G2(:,:,:,1),wf(:,7),wf(:,6),G2tensor(:,5))
  call check_last_GGG_G_23(l_switch,G2(:,:,:,1),wf(:,6),wf(:,7),G2tensor(:,6))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,12),Q(:,15),G3tensor(:,1))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,400),Q(:,15),G3tensor(:,2))
  call loop_VA_Q(G2(:,:,:,1),wf(:,-3),G2(:,:,:,2))
  call loop_A_Q(G2(:,:,:,2),Q(:,56),MT,G3(:,:,:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,33),G3tensor(:,3))
  call loop_AV_Q(G3(:,:,:,1),wf(:,1),G3(:,:,:,2))
  call loop_A_Q(G3(:,:,:,2),Q(:,61),MT,G4(:,:,:,1))
  call check_last_AQ_V(l_switch,G4(:,:,:,1),wf(:,-1),G4tensor(:,1))
  call check_last_AQ_V(l_switch,G3(:,:,:,1),wf(:,58),G3tensor(:,4))
  call loop_AV_Q(G3(:,:,:,1),wf(:,7),G3(:,:,:,3))
  call loop_A_Q(G3(:,:,:,3),Q(:,62),MT,G4(:,:,:,2))
  call check_last_AQ_V(l_switch,G4(:,:,:,2),wf(:,0),G4tensor(:,2))
  call loop_AQ_V(G3(:,:,:,1),wf(:,-1),G3(:,:,:,4))
  call loop_VA_Q(G3(:,:,:,4),wf(:,-2),G3(:,:,:,5))
  call loop_A_Q(G3(:,:,:,5),Q(:,62),MT,G4(:,:,:,3))
  call check_last_AQ_V(l_switch,G4(:,:,:,3),wf(:,0),G4tensor(:,3))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,405),Q(:,15),G3tensor(:,5))
  call loop_VA_Q(G2(:,:,:,1),wf(:,24),G2(:,:,:,3))
  call loop_A_Q(G2(:,:,:,3),Q(:,61),MT,G3(:,:,:,6))
  call check_last_AQ_V(l_switch,G3(:,:,:,6),wf(:,-1),G3tensor(:,6))
  call loop_UV_W(G2(:,:,:,1),Q(:,48),wf(:,1),Q(:,5),G3(:,:,:,7))
  call loop_VA_Q(G3(:,:,:,7),wf(:,-3),G3(:,:,:,8))
  call loop_A_Q(G3(:,:,:,8),Q(:,61),MT,G4(:,:,:,4))
  call check_last_AQ_V(l_switch,G4(:,:,:,4),wf(:,-1),G4tensor(:,4))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,42),Q(:,15),G3tensor(:,7))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,420),Q(:,15),G3tensor(:,8))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,425),Q(:,15),G3tensor(:,9))
  call loop_VA_Q(G2(:,:,:,1),wf(:,53),G2(:,:,:,4))
  call loop_A_Q(G2(:,:,:,4),Q(:,62),MT,G3(:,:,:,9))
  call check_last_AQ_V(l_switch,G3(:,:,:,9),wf(:,0),G3tensor(:,10))
  call loop_UV_W(G2(:,:,:,1),Q(:,48),wf(:,7),Q(:,6),G3(:,:,:,10))
  call loop_VA_Q(G3(:,:,:,10),wf(:,-3),G3(:,:,:,11))
  call loop_A_Q(G3(:,:,:,11),Q(:,62),MT,G4(:,:,:,5))
  call check_last_AQ_V(l_switch,G4(:,:,:,5),wf(:,0),G4tensor(:,5))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,440),Q(:,15),G3tensor(:,11))
  call loop_VQ_A(G2(:,:,:,1),wf(:,76),G2(:,:,:,5))
  call loop_Q_A(G2(:,:,:,5),Q(:,59),MT,G3(:,:,:,12))
  call check_last_QA_V(l_switch,G3(:,:,:,12),wf(:,-2),G3tensor(:,12))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,445),Q(:,15),G3tensor(:,13))
  call loop_VA_Q(G2(:,:,:,1),wf(:,69),G2(:,:,:,6))
  call loop_A_Q(G2(:,:,:,6),Q(:,61),MT,G3(:,:,:,13))
  call check_last_AQ_V(l_switch,G3(:,:,:,13),wf(:,-1),G3tensor(:,14))
  call loop_UV_W(G2(:,:,:,1),Q(:,48),wf(:,6),Q(:,9),G3(:,:,:,14))
  call loop_VA_Q(G3(:,:,:,14),wf(:,-2),G3(:,:,:,15))
  call loop_A_Q(G3(:,:,:,15),Q(:,61),MT,G4(:,:,:,6))
  call check_last_AQ_V(l_switch,G4(:,:,:,6),wf(:,-1),G4tensor(:,6))
  call loop_VA_Q(G2(:,:,:,1),wf(:,-2),G2(:,:,:,7))
  call loop_A_Q(G2(:,:,:,7),Q(:,52),MT,G3(:,:,:,16))
  call loop_AV_Q(G3(:,:,:,16),wf(:,6),G3(:,:,:,17))
  call loop_A_Q(G3(:,:,:,17),Q(:,61),MT,G4(:,:,:,7))
  call check_last_AQ_V(l_switch,G4(:,:,:,7),wf(:,-1),G4tensor(:,7))
  call loop_AV_Q(G3(:,:,:,16),wf(:,2),G3(:,:,:,18))
  call loop_A_Q(G3(:,:,:,18),Q(:,62),MT,G4(:,:,:,8))
  call check_last_AQ_V(l_switch,G4(:,:,:,8),wf(:,0),G4tensor(:,8))
  call loop_AQ_V(G3(:,:,:,16),wf(:,-1),G3(:,:,:,19))
  call loop_VA_Q(G3(:,:,:,19),wf(:,-3),G3(:,:,:,20))
  call loop_A_Q(G3(:,:,:,20),Q(:,62),MT,G4(:,:,:,9))
  call check_last_AQ_V(l_switch,G4(:,:,:,9),wf(:,0),G4tensor(:,9))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,460),Q(:,15),G3tensor(:,15))
  call loop_VQ_A(G2(:,:,:,1),wf(:,88),G2(:,:,:,8))
  call loop_Q_A(G2(:,:,:,8),Q(:,59),MT,G3(:,:,:,21))
  call check_last_QA_V(l_switch,G3(:,:,:,21),wf(:,-2),G3tensor(:,16))
  call check_last_UV_W(l_switch,G2(:,:,:,1),Q(:,48),wf(:,465),Q(:,15),G3tensor(:,17))
  call loop_VA_Q(G2(:,:,:,1),wf(:,85),G2(:,:,:,9))
  call loop_A_Q(G2(:,:,:,9),Q(:,62),MT,G3(:,:,:,22))
  call check_last_AQ_V(l_switch,G3(:,:,:,22),wf(:,0),G3tensor(:,18))
  call loop_UV_W(G2(:,:,:,1),Q(:,48),wf(:,2),Q(:,10),G3(:,:,:,23))
  call loop_VA_Q(G3(:,:,:,23),wf(:,-2),G3(:,:,:,24))
  call loop_A_Q(G3(:,:,:,24),Q(:,62),MT,G4(:,:,:,10))
  call check_last_AQ_V(l_switch,G4(:,:,:,10),wf(:,0),G4tensor(:,10))
  call loop_VQ_A(G2(:,:,:,1),wf(:,-1),G2(:,:,:,10))
  call loop_Q_A(G2(:,:,:,10),Q(:,50),MT,G3(:,:,:,25))
  call loop_QA_V(G3(:,:,:,25),wf(:,-3),G3(:,:,:,26))
  call loop_VA_Q(G3(:,:,:,26),wf(:,-2),G3(:,:,:,27))
  call loop_A_Q(G3(:,:,:,27),Q(:,62),MT,G4(:,:,:,11))
  call check_last_AQ_V(l_switch,G4(:,:,:,11),wf(:,0),G4tensor(:,11))
  call loop_QA_V(G3(:,:,:,25),wf(:,-2),G3(:,:,:,28))
  call loop_VA_Q(G3(:,:,:,28),wf(:,-3),G3(:,:,:,29))
  call loop_A_Q(G3(:,:,:,29),Q(:,62),MT,G4(:,:,:,12))
  call check_last_AQ_V(l_switch,G4(:,:,:,12),wf(:,0),G4tensor(:,12))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-5),wf(:,2),G1(:,:,:,2))
  call check_last_UV_W(l_switch,G1(:,:,:,2),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,7))
  call loop_VA_Q(G1(:,:,:,2),wf(:,-2),G1(:,:,:,3))
  call loop_A_Q(G1(:,:,:,3),Q(:,62),MT,G2(:,:,:,11))
  call check_last_AQ_V(l_switch,G2(:,:,:,11),wf(:,0),G2tensor(:,8))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,2),wf(:,-5),G1(:,:,:,4))
  call check_last_UV_W(l_switch,G1(:,:,:,4),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,9))
  call loop_VA_Q(G1(:,:,:,4),wf(:,-2),G1(:,:,:,5))
  call loop_A_Q(G1(:,:,:,5),Q(:,62),MT,G2(:,:,:,12))
  call check_last_AQ_V(l_switch,G2(:,:,:,12),wf(:,0),G2tensor(:,10))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-5),wf(:,2),G1(:,:,:,6))
  call check_last_UV_W(l_switch,G1(:,:,:,6),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,11))
  call loop_VA_Q(G1(:,:,:,6),wf(:,-2),G1(:,:,:,7))
  call loop_A_Q(G1(:,:,:,7),Q(:,62),MT,G2(:,:,:,13))
  call check_last_AQ_V(l_switch,G2(:,:,:,13),wf(:,0),G2tensor(:,12))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-5),wf(:,1),G1(:,:,:,8))
  call check_last_UV_W(l_switch,G1(:,:,:,8),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,13))
  call loop_VA_Q(G1(:,:,:,8),wf(:,-3),G1(:,:,:,9))
  call loop_A_Q(G1(:,:,:,9),Q(:,61),MT,G2(:,:,:,14))
  call check_last_AQ_V(l_switch,G2(:,:,:,14),wf(:,-1),G2tensor(:,14))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,1),wf(:,-5),G1(:,:,:,10))
  call check_last_UV_W(l_switch,G1(:,:,:,10),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,15))
  call loop_VA_Q(G1(:,:,:,10),wf(:,-3),G1(:,:,:,11))
  call loop_A_Q(G1(:,:,:,11),Q(:,61),MT,G2(:,:,:,15))
  call check_last_AQ_V(l_switch,G2(:,:,:,15),wf(:,-1),G2tensor(:,16))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-5),wf(:,1),G1(:,:,:,12))
  call check_last_UV_W(l_switch,G1(:,:,:,12),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,17))
  call loop_VA_Q(G1(:,:,:,12),wf(:,-3),G1(:,:,:,13))
  call loop_A_Q(G1(:,:,:,13),Q(:,61),MT,G2(:,:,:,16))
  call check_last_AQ_V(l_switch,G2(:,:,:,16),wf(:,-1),G2tensor(:,18))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-5),wf(:,7),G1(:,:,:,14))
  call check_last_UV_W(l_switch,G1(:,:,:,14),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,19))
  call loop_VA_Q(G1(:,:,:,14),wf(:,-3),G1(:,:,:,15))
  call loop_A_Q(G1(:,:,:,15),Q(:,62),MT,G2(:,:,:,17))
  call check_last_AQ_V(l_switch,G2(:,:,:,17),wf(:,0),G2tensor(:,20))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,7),wf(:,-5),G1(:,:,:,16))
  call check_last_UV_W(l_switch,G1(:,:,:,16),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,21))
  call loop_VA_Q(G1(:,:,:,16),wf(:,-3),G1(:,:,:,17))
  call loop_A_Q(G1(:,:,:,17),Q(:,62),MT,G2(:,:,:,18))
  call check_last_AQ_V(l_switch,G2(:,:,:,18),wf(:,0),G2tensor(:,22))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-5),wf(:,7),G1(:,:,:,18))
  call check_last_UV_W(l_switch,G1(:,:,:,18),Q(:,54),wf(:,6),Q(:,9),G2tensor(:,23))
  call loop_VA_Q(G1(:,:,:,18),wf(:,-3),G1(:,:,:,19))
  call loop_A_Q(G1(:,:,:,19),Q(:,62),MT,G2(:,:,:,19))
  call check_last_AQ_V(l_switch,G2(:,:,:,19),wf(:,0),G2tensor(:,24))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,-5),wf(:,6),G1(:,:,:,20))
  call check_last_UV_W(l_switch,G1(:,:,:,20),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,25))
  call loop_VA_Q(G1(:,:,:,20),wf(:,-2),G1(:,:,:,21))
  call loop_A_Q(G1(:,:,:,21),Q(:,61),MT,G2(:,:,:,20))
  call check_last_AQ_V(l_switch,G2(:,:,:,20),wf(:,-1),G2tensor(:,26))
  call loop_GGG_G_12(G1(:,:,:,1),wf(:,6),wf(:,-5),G1(:,:,:,22))
  call check_last_UV_W(l_switch,G1(:,:,:,22),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,27))
  call loop_VA_Q(G1(:,:,:,22),wf(:,-2),G1(:,:,:,23))
  call loop_A_Q(G1(:,:,:,23),Q(:,61),MT,G2(:,:,:,21))
  call check_last_AQ_V(l_switch,G2(:,:,:,21),wf(:,-1),G2tensor(:,28))
  call loop_GGG_G_23(G1(:,:,:,1),wf(:,-5),wf(:,6),G1(:,:,:,24))
  call check_last_UV_W(l_switch,G1(:,:,:,24),Q(:,57),wf(:,7),Q(:,6),G2tensor(:,29))
  call loop_VA_Q(G1(:,:,:,24),wf(:,-2),G1(:,:,:,25))
  call loop_A_Q(G1(:,:,:,25),Q(:,61),MT,G2(:,:,:,22))
  call check_last_AQ_V(l_switch,G2(:,:,:,22),wf(:,-1),G2tensor(:,30))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,16),Q(:,37),G2(:,:,:,23))
  call check_last_UV_W(l_switch,G2(:,:,:,23),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,19))
  call loop_VA_Q(G2(:,:,:,23),wf(:,-3),G2(:,:,:,24))
  call loop_A_Q(G2(:,:,:,24),Q(:,61),MT,G3(:,:,:,30))
  call check_last_AQ_V(l_switch,G3(:,:,:,30),wf(:,-1),G3tensor(:,20))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,14),Q(:,42),G2(:,:,:,25))
  call check_last_UV_W(l_switch,G2(:,:,:,25),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,21))
  call loop_VA_Q(G2(:,:,:,25),wf(:,-2),G2(:,:,:,26))
  call loop_A_Q(G2(:,:,:,26),Q(:,62),MT,G3(:,:,:,31))
  call check_last_AQ_V(l_switch,G3(:,:,:,31),wf(:,0),G3tensor(:,22))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,2),Q(:,10),G2(:,:,:,27))
  call loop_UV_W(G2(:,:,:,27),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,32))
  call check_last_UV_W(l_switch,G3(:,:,:,32),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,13))
  call loop_VA_Q(G3(:,:,:,32),wf(:,-2),G3(:,:,:,33))
  call loop_A_Q(G3(:,:,:,33),Q(:,62),MT,G4(:,:,:,13))
  call check_last_AQ_V(l_switch,G4(:,:,:,13),wf(:,0),G4tensor(:,14))
  call loop_VQ_A(G2(:,:,:,27),wf(:,55),G2(:,:,:,28))
  call loop_Q_A(G2(:,:,:,28),Q(:,59),MT,G3(:,:,:,34))
  call check_last_QA_V(l_switch,G3(:,:,:,34),wf(:,-2),G3tensor(:,23))
  call loop_VA_Q(G2(:,:,:,27),wf(:,66),G2(:,:,:,29))
  call loop_A_Q(G2(:,:,:,29),Q(:,62),MT,G3(:,:,:,35))
  call check_last_AQ_V(l_switch,G3(:,:,:,35),wf(:,0),G3tensor(:,24))
  call loop_VA_Q(G2(:,:,:,27),wf(:,-2),G2(:,:,:,30))
  call loop_A_Q(G2(:,:,:,30),Q(:,30),MT,G3(:,:,:,36))
  call loop_AV_Q(G3(:,:,:,36),wf(:,-5),G3(:,:,:,37))
  call loop_A_Q(G3(:,:,:,37),Q(:,62),MT,G4(:,:,:,14))
  call check_last_AQ_V(l_switch,G4(:,:,:,14),wf(:,0),G4tensor(:,15))
  call loop_VQ_A(G1(:,:,:,1),wf(:,28),G1(:,:,:,26))
  call loop_Q_A(G1(:,:,:,26),Q(:,50),MT,G2(:,:,:,31))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,24),G2tensor(:,31))
  call loop_QV_A(G2(:,:,:,31),wf(:,1),G2(:,:,:,32))
  call loop_Q_A(G2(:,:,:,32),Q(:,55),MT,G3(:,:,:,38))
  call check_last_QA_V(l_switch,G3(:,:,:,38),wf(:,-3),G3tensor(:,25))
  call check_last_QA_V(l_switch,G2(:,:,:,31),wf(:,69),G2tensor(:,32))
  call loop_QV_A(G2(:,:,:,31),wf(:,6),G2(:,:,:,33))
  call loop_Q_A(G2(:,:,:,33),Q(:,59),MT,G3(:,:,:,39))
  call check_last_QA_V(l_switch,G3(:,:,:,39),wf(:,-2),G3tensor(:,26))
  call loop_QA_V(G2(:,:,:,31),wf(:,-3),G2(:,:,:,34))
  call loop_VA_Q(G2(:,:,:,34),wf(:,-2),G2(:,:,:,35))
  call loop_A_Q(G2(:,:,:,35),Q(:,62),MT,G3(:,:,:,40))
  call check_last_AQ_V(l_switch,G3(:,:,:,40),wf(:,0),G3tensor(:,27))
  call loop_QA_V(G2(:,:,:,31),wf(:,-2),G2(:,:,:,36))
  call loop_VA_Q(G2(:,:,:,36),wf(:,-3),G2(:,:,:,37))
  call loop_A_Q(G2(:,:,:,37),Q(:,62),MT,G3(:,:,:,41))
  call check_last_AQ_V(l_switch,G3(:,:,:,41),wf(:,0),G3tensor(:,28))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,36),Q(:,42),G2(:,:,:,38))
  call check_last_UV_W(l_switch,G2(:,:,:,38),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,29))
  call loop_VA_Q(G2(:,:,:,38),wf(:,-2),G2(:,:,:,39))
  call loop_A_Q(G2(:,:,:,39),Q(:,62),MT,G3(:,:,:,42))
  call check_last_AQ_V(l_switch,G3(:,:,:,42),wf(:,0),G3tensor(:,30))
  call loop_VQ_A(G1(:,:,:,1),wf(:,299),G1(:,:,:,27))
  call loop_Q_A(G1(:,:,:,27),Q(:,55),MT,G2(:,:,:,40))
  call check_last_QA_V(l_switch,G2(:,:,:,40),wf(:,-3),G2tensor(:,33))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-3),G1(:,:,:,28))
  call loop_A_Q(G1(:,:,:,28),Q(:,24),MT,G2(:,:,:,41))
  call loop_AQ_V(G2(:,:,:,41),wf(:,28),G2(:,:,:,42))
  call check_last_UV_W(l_switch,G2(:,:,:,42),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,31))
  call loop_VA_Q(G2(:,:,:,42),wf(:,-2),G2(:,:,:,43))
  call loop_A_Q(G2(:,:,:,43),Q(:,62),MT,G3(:,:,:,43))
  call check_last_AQ_V(l_switch,G3(:,:,:,43),wf(:,0),G3tensor(:,32))
  call loop_AV_Q(G2(:,:,:,41),wf(:,-5),G2(:,:,:,44))
  call loop_A_Q(G2(:,:,:,44),Q(:,56),MT,G3(:,:,:,44))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,33),G3tensor(:,33))
  call loop_AV_Q(G3(:,:,:,44),wf(:,1),G3(:,:,:,45))
  call loop_A_Q(G3(:,:,:,45),Q(:,61),MT,G4(:,:,:,15))
  call check_last_AQ_V(l_switch,G4(:,:,:,15),wf(:,-1),G4tensor(:,16))
  call check_last_AQ_V(l_switch,G3(:,:,:,44),wf(:,58),G3tensor(:,34))
  call loop_AV_Q(G3(:,:,:,44),wf(:,7),G3(:,:,:,46))
  call loop_A_Q(G3(:,:,:,46),Q(:,62),MT,G4(:,:,:,16))
  call check_last_AQ_V(l_switch,G4(:,:,:,16),wf(:,0),G4tensor(:,17))
  call loop_AQ_V(G3(:,:,:,44),wf(:,-1),G3(:,:,:,47))
  call loop_VA_Q(G3(:,:,:,47),wf(:,-2),G3(:,:,:,48))
  call loop_A_Q(G3(:,:,:,48),Q(:,62),MT,G4(:,:,:,17))
  call check_last_AQ_V(l_switch,G4(:,:,:,17),wf(:,0),G4tensor(:,18))
  call loop_AV_Q(G2(:,:,:,41),wf(:,16),G2(:,:,:,45))
  call loop_A_Q(G2(:,:,:,45),Q(:,61),MT,G3(:,:,:,49))
  call check_last_AQ_V(l_switch,G3(:,:,:,49),wf(:,-1),G3tensor(:,35))
  call loop_AV_Q(G2(:,:,:,41),wf(:,1),G2(:,:,:,46))
  call loop_A_Q(G2(:,:,:,46),Q(:,29),MT,G3(:,:,:,50))
  call loop_AV_Q(G3(:,:,:,50),wf(:,-5),G3(:,:,:,51))
  call loop_A_Q(G3(:,:,:,51),Q(:,61),MT,G4(:,:,:,18))
  call check_last_AQ_V(l_switch,G4(:,:,:,18),wf(:,-1),G4tensor(:,19))
  call loop_AQ_V(G2(:,:,:,41),wf(:,55),G2(:,:,:,47))
  call check_last_UV_W(l_switch,G2(:,:,:,47),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,36))
  call loop_VA_Q(G2(:,:,:,47),wf(:,-2),G2(:,:,:,48))
  call loop_A_Q(G2(:,:,:,48),Q(:,61),MT,G3(:,:,:,52))
  call check_last_AQ_V(l_switch,G3(:,:,:,52),wf(:,-1),G3tensor(:,37))
  call loop_AV_Q(G2(:,:,:,41),wf(:,44),G2(:,:,:,49))
  call loop_A_Q(G2(:,:,:,49),Q(:,62),MT,G3(:,:,:,53))
  call check_last_AQ_V(l_switch,G3(:,:,:,53),wf(:,0),G3tensor(:,38))
  call loop_AV_Q(G2(:,:,:,41),wf(:,7),G2(:,:,:,50))
  call loop_A_Q(G2(:,:,:,50),Q(:,30),MT,G3(:,:,:,54))
  call loop_AV_Q(G3(:,:,:,54),wf(:,-5),G3(:,:,:,55))
  call loop_A_Q(G3(:,:,:,55),Q(:,62),MT,G4(:,:,:,19))
  call check_last_AQ_V(l_switch,G4(:,:,:,19),wf(:,0),G4tensor(:,20))
  call loop_AV_Q(G2(:,:,:,41),wf(:,90),G2(:,:,:,51))
  call loop_A_Q(G2(:,:,:,51),Q(:,61),MT,G3(:,:,:,56))
  call check_last_AQ_V(l_switch,G3(:,:,:,56),wf(:,-1),G3tensor(:,39))
  call loop_AV_Q(G2(:,:,:,41),wf(:,78),G2(:,:,:,52))
  call loop_A_Q(G2(:,:,:,52),Q(:,62),MT,G3(:,:,:,57))
  call check_last_AQ_V(l_switch,G3(:,:,:,57),wf(:,0),G3tensor(:,40))
  call loop_AV_Q(G2(:,:,:,41),wf(:,91),G2(:,:,:,53))
  call loop_A_Q(G2(:,:,:,53),Q(:,61),MT,G3(:,:,:,58))
  call check_last_AQ_V(l_switch,G3(:,:,:,58),wf(:,-1),G3tensor(:,41))
  call loop_AV_Q(G2(:,:,:,41),wf(:,80),G2(:,:,:,54))
  call loop_A_Q(G2(:,:,:,54),Q(:,62),MT,G3(:,:,:,59))
  call check_last_AQ_V(l_switch,G3(:,:,:,59),wf(:,0),G3tensor(:,42))
  call loop_AQ_V(G2(:,:,:,41),wf(:,-1),G2(:,:,:,55))
  call loop_VA_Q(G2(:,:,:,55),wf(:,66),G2(:,:,:,56))
  call loop_A_Q(G2(:,:,:,56),Q(:,62),MT,G3(:,:,:,60))
  call check_last_AQ_V(l_switch,G3(:,:,:,60),wf(:,0),G3tensor(:,43))
  call loop_UV_W(G2(:,:,:,55),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,61))
  call loop_VA_Q(G3(:,:,:,61),wf(:,-2),G3(:,:,:,62))
  call loop_A_Q(G3(:,:,:,62),Q(:,62),MT,G4(:,:,:,20))
  call check_last_AQ_V(l_switch,G4(:,:,:,20),wf(:,0),G4tensor(:,21))
  call loop_VA_Q(G2(:,:,:,55),wf(:,-2),G2(:,:,:,57))
  call loop_A_Q(G2(:,:,:,57),Q(:,30),MT,G3(:,:,:,63))
  call loop_AV_Q(G3(:,:,:,63),wf(:,-5),G3(:,:,:,64))
  call loop_A_Q(G3(:,:,:,64),Q(:,62),MT,G4(:,:,:,21))
  call check_last_AQ_V(l_switch,G4(:,:,:,21),wf(:,0),G4tensor(:,22))
  call loop_VA_Q(G1(:,:,:,1),wf(:,20),G1(:,:,:,29))
  call loop_A_Q(G1(:,:,:,29),Q(:,56),MT,G2(:,:,:,58))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,33),G2tensor(:,34))
  call loop_AV_Q(G2(:,:,:,58),wf(:,1),G2(:,:,:,59))
  call loop_A_Q(G2(:,:,:,59),Q(:,61),MT,G3(:,:,:,65))
  call check_last_AQ_V(l_switch,G3(:,:,:,65),wf(:,-1),G3tensor(:,44))
  call check_last_AQ_V(l_switch,G2(:,:,:,58),wf(:,58),G2tensor(:,35))
  call loop_AV_Q(G2(:,:,:,58),wf(:,7),G2(:,:,:,60))
  call loop_A_Q(G2(:,:,:,60),Q(:,62),MT,G3(:,:,:,66))
  call check_last_AQ_V(l_switch,G3(:,:,:,66),wf(:,0),G3tensor(:,45))
  call loop_AQ_V(G2(:,:,:,58),wf(:,-1),G2(:,:,:,61))
  call loop_VA_Q(G2(:,:,:,61),wf(:,-2),G2(:,:,:,62))
  call loop_A_Q(G2(:,:,:,62),Q(:,62),MT,G3(:,:,:,67))
  call check_last_AQ_V(l_switch,G3(:,:,:,67),wf(:,0),G3tensor(:,46))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,38),Q(:,42),G2(:,:,:,63))
  call check_last_UV_W(l_switch,G2(:,:,:,63),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,47))
  call loop_VA_Q(G2(:,:,:,63),wf(:,-2),G2(:,:,:,64))
  call loop_A_Q(G2(:,:,:,64),Q(:,62),MT,G3(:,:,:,68))
  call check_last_AQ_V(l_switch,G3(:,:,:,68),wf(:,0),G3tensor(:,48))
  call loop_VA_Q(G1(:,:,:,1),wf(:,285),G1(:,:,:,30))
  call loop_A_Q(G1(:,:,:,30),Q(:,61),MT,G2(:,:,:,65))
  call check_last_AQ_V(l_switch,G2(:,:,:,65),wf(:,-1),G2tensor(:,36))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,1),Q(:,5),G2(:,:,:,66))
  call loop_VA_Q(G2(:,:,:,66),wf(:,20),G2(:,:,:,67))
  call loop_A_Q(G2(:,:,:,67),Q(:,61),MT,G3(:,:,:,69))
  call check_last_AQ_V(l_switch,G3(:,:,:,69),wf(:,-1),G3tensor(:,49))
  call loop_UV_W(G2(:,:,:,66),Q(:,21),wf(:,-5),Q(:,32),G3(:,:,:,70))
  call loop_VA_Q(G3(:,:,:,70),wf(:,-3),G3(:,:,:,71))
  call loop_A_Q(G3(:,:,:,71),Q(:,61),MT,G4(:,:,:,22))
  call check_last_AQ_V(l_switch,G4(:,:,:,22),wf(:,-1),G4tensor(:,23))
  call loop_VA_Q(G2(:,:,:,66),wf(:,-3),G2(:,:,:,68))
  call loop_A_Q(G2(:,:,:,68),Q(:,29),MT,G3(:,:,:,72))
  call loop_AV_Q(G3(:,:,:,72),wf(:,-5),G3(:,:,:,73))
  call loop_A_Q(G3(:,:,:,73),Q(:,61),MT,G4(:,:,:,23))
  call check_last_AQ_V(l_switch,G4(:,:,:,23),wf(:,-1),G4tensor(:,24))
  call loop_VQ_A(G1(:,:,:,1),wf(:,404),G1(:,:,:,31))
  call loop_Q_A(G1(:,:,:,31),Q(:,55),MT,G2(:,:,:,69))
  call check_last_QA_V(l_switch,G2(:,:,:,69),wf(:,-3),G2tensor(:,37))
  call loop_VA_Q(G1(:,:,:,1),wf(:,409),G1(:,:,:,32))
  call loop_A_Q(G1(:,:,:,32),Q(:,61),MT,G2(:,:,:,70))
  call check_last_AQ_V(l_switch,G2(:,:,:,70),wf(:,-1),G2tensor(:,38))
  call loop_VA_Q(G1(:,:,:,1),wf(:,24),G1(:,:,:,33))
  call loop_A_Q(G1(:,:,:,33),Q(:,29),MT,G2(:,:,:,71))
  call loop_AV_Q(G2(:,:,:,71),wf(:,-5),G2(:,:,:,72))
  call loop_A_Q(G2(:,:,:,72),Q(:,61),MT,G3(:,:,:,74))
  call check_last_AQ_V(l_switch,G3(:,:,:,74),wf(:,-1),G3tensor(:,50))
  call loop_VQ_A(G1(:,:,:,1),wf(:,416),G1(:,:,:,34))
  call loop_Q_A(G1(:,:,:,34),Q(:,55),MT,G2(:,:,:,73))
  call check_last_QA_V(l_switch,G2(:,:,:,73),wf(:,-3),G2tensor(:,39))
  call loop_VA_Q(G1(:,:,:,1),wf(:,418),G1(:,:,:,35))
  call loop_A_Q(G1(:,:,:,35),Q(:,61),MT,G2(:,:,:,74))
  call check_last_AQ_V(l_switch,G2(:,:,:,74),wf(:,-1),G2tensor(:,40))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,46),Q(:,41),G2(:,:,:,75))
  call check_last_UV_W(l_switch,G2(:,:,:,75),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,51))
  call loop_VA_Q(G2(:,:,:,75),wf(:,-2),G2(:,:,:,76))
  call loop_A_Q(G2(:,:,:,76),Q(:,61),MT,G3(:,:,:,75))
  call check_last_AQ_V(l_switch,G3(:,:,:,75),wf(:,-1),G3tensor(:,52))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,44),Q(:,38),G2(:,:,:,77))
  call check_last_UV_W(l_switch,G2(:,:,:,77),Q(:,54),wf(:,6),Q(:,9),G3tensor(:,53))
  call loop_VA_Q(G2(:,:,:,77),wf(:,-3),G2(:,:,:,78))
  call loop_A_Q(G2(:,:,:,78),Q(:,62),MT,G3(:,:,:,76))
  call check_last_AQ_V(l_switch,G3(:,:,:,76),wf(:,0),G3tensor(:,54))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,6),Q(:,9),G2(:,:,:,79))
  call loop_UV_W(G2(:,:,:,79),Q(:,25),wf(:,-5),Q(:,32),G3(:,:,:,77))
  call check_last_UV_W(l_switch,G3(:,:,:,77),Q(:,57),wf(:,7),Q(:,6),G4tensor(:,25))
  call loop_VA_Q(G3(:,:,:,77),wf(:,-2),G3(:,:,:,78))
  call loop_A_Q(G3(:,:,:,78),Q(:,61),MT,G4(:,:,:,24))
  call check_last_AQ_V(l_switch,G4(:,:,:,24),wf(:,-1),G4tensor(:,26))
  call loop_VQ_A(G2(:,:,:,79),wf(:,28),G2(:,:,:,80))
  call loop_Q_A(G2(:,:,:,80),Q(:,59),MT,G3(:,:,:,79))
  call check_last_QA_V(l_switch,G3(:,:,:,79),wf(:,-2),G3tensor(:,55))
  call loop_VA_Q(G2(:,:,:,79),wf(:,66),G2(:,:,:,81))
  call loop_A_Q(G2(:,:,:,81),Q(:,61),MT,G3(:,:,:,80))
  call check_last_AQ_V(l_switch,G3(:,:,:,80),wf(:,-1),G3tensor(:,56))
  call loop_VA_Q(G2(:,:,:,79),wf(:,-2),G2(:,:,:,82))
  call loop_A_Q(G2(:,:,:,82),Q(:,29),MT,G3(:,:,:,81))
  call loop_AV_Q(G3(:,:,:,81),wf(:,-5),G3(:,:,:,82))
  call loop_A_Q(G3(:,:,:,82),Q(:,61),MT,G4(:,:,:,25))
  call check_last_AQ_V(l_switch,G4(:,:,:,25),wf(:,-1),G4tensor(:,27))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,60),Q(:,41),G2(:,:,:,83))
  call check_last_UV_W(l_switch,G2(:,:,:,83),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,57))
  call loop_VA_Q(G2(:,:,:,83),wf(:,-2),G2(:,:,:,84))
  call loop_A_Q(G2(:,:,:,84),Q(:,61),MT,G3(:,:,:,83))
  call check_last_AQ_V(l_switch,G3(:,:,:,83),wf(:,-1),G3tensor(:,58))
  call loop_VQ_A(G1(:,:,:,1),wf(:,55),G1(:,:,:,36))
  call loop_Q_A(G1(:,:,:,36),Q(:,49),MT,G2(:,:,:,85))
  call check_last_QA_V(l_switch,G2(:,:,:,85),wf(:,53),G2tensor(:,41))
  call loop_QV_A(G2(:,:,:,85),wf(:,7),G2(:,:,:,86))
  call loop_Q_A(G2(:,:,:,86),Q(:,55),MT,G3(:,:,:,84))
  call check_last_QA_V(l_switch,G3(:,:,:,84),wf(:,-3),G3tensor(:,59))
  call check_last_QA_V(l_switch,G2(:,:,:,85),wf(:,85),G2tensor(:,42))
  call loop_QV_A(G2(:,:,:,85),wf(:,2),G2(:,:,:,87))
  call loop_Q_A(G2(:,:,:,87),Q(:,59),MT,G3(:,:,:,85))
  call check_last_QA_V(l_switch,G3(:,:,:,85),wf(:,-2),G3tensor(:,60))
  call loop_QA_V(G2(:,:,:,85),wf(:,-3),G2(:,:,:,88))
  call loop_VA_Q(G2(:,:,:,88),wf(:,-2),G2(:,:,:,89))
  call loop_A_Q(G2(:,:,:,89),Q(:,61),MT,G3(:,:,:,86))
  call check_last_AQ_V(l_switch,G3(:,:,:,86),wf(:,-1),G3tensor(:,61))
  call loop_QA_V(G2(:,:,:,85),wf(:,-2),G2(:,:,:,90))
  call loop_VA_Q(G2(:,:,:,90),wf(:,-3),G2(:,:,:,91))
  call loop_A_Q(G2(:,:,:,91),Q(:,61),MT,G3(:,:,:,87))
  call check_last_AQ_V(l_switch,G3(:,:,:,87),wf(:,-1),G3tensor(:,62))
  call loop_VQ_A(G1(:,:,:,1),wf(:,340),G1(:,:,:,37))
  call loop_Q_A(G1(:,:,:,37),Q(:,55),MT,G2(:,:,:,92))
  call check_last_QA_V(l_switch,G2(:,:,:,92),wf(:,-3),G2tensor(:,43))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,62),Q(:,41),G2(:,:,:,93))
  call check_last_UV_W(l_switch,G2(:,:,:,93),Q(:,57),wf(:,7),Q(:,6),G3tensor(:,63))
  call loop_VA_Q(G2(:,:,:,93),wf(:,-2),G2(:,:,:,94))
  call loop_A_Q(G2(:,:,:,94),Q(:,61),MT,G3(:,:,:,88))
  call check_last_AQ_V(l_switch,G3(:,:,:,88),wf(:,-1),G3tensor(:,64))
  call loop_VA_Q(G1(:,:,:,1),wf(:,327),G1(:,:,:,38))
  call loop_A_Q(G1(:,:,:,38),Q(:,62),MT,G2(:,:,:,95))
  call check_last_AQ_V(l_switch,G2(:,:,:,95),wf(:,0),G2tensor(:,44))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,7),Q(:,6),G2(:,:,:,96))
  call loop_VA_Q(G2(:,:,:,96),wf(:,20),G2(:,:,:,97))
  call loop_A_Q(G2(:,:,:,97),Q(:,62),MT,G3(:,:,:,89))
  call check_last_AQ_V(l_switch,G3(:,:,:,89),wf(:,0),G3tensor(:,65))
  call loop_UV_W(G2(:,:,:,96),Q(:,22),wf(:,-5),Q(:,32),G3(:,:,:,90))
  call loop_VA_Q(G3(:,:,:,90),wf(:,-3),G3(:,:,:,91))
  call loop_A_Q(G3(:,:,:,91),Q(:,62),MT,G4(:,:,:,26))
  call check_last_AQ_V(l_switch,G4(:,:,:,26),wf(:,0),G4tensor(:,28))
  call loop_VA_Q(G2(:,:,:,96),wf(:,-3),G2(:,:,:,98))
  call loop_A_Q(G2(:,:,:,98),Q(:,30),MT,G3(:,:,:,92))
  call loop_AV_Q(G3(:,:,:,92),wf(:,-5),G3(:,:,:,93))
  call loop_A_Q(G3(:,:,:,93),Q(:,62),MT,G4(:,:,:,27))
  call check_last_AQ_V(l_switch,G4(:,:,:,27),wf(:,0),G4tensor(:,29))
  call loop_VQ_A(G1(:,:,:,1),wf(:,424),G1(:,:,:,39))
  call loop_Q_A(G1(:,:,:,39),Q(:,55),MT,G2(:,:,:,99))
  call check_last_QA_V(l_switch,G2(:,:,:,99),wf(:,-3),G2tensor(:,45))
  call loop_VQ_A(G1(:,:,:,1),wf(:,429),G1(:,:,:,40))
  call loop_Q_A(G1(:,:,:,40),Q(:,55),MT,G2(:,:,:,100))
  call check_last_QA_V(l_switch,G2(:,:,:,100),wf(:,-3),G2tensor(:,46))
  call loop_VA_Q(G1(:,:,:,1),wf(:,433),G1(:,:,:,41))
  call loop_A_Q(G1(:,:,:,41),Q(:,62),MT,G2(:,:,:,101))
  call check_last_AQ_V(l_switch,G2(:,:,:,101),wf(:,0),G2tensor(:,47))
  call loop_VA_Q(G1(:,:,:,1),wf(:,53),G1(:,:,:,42))
  call loop_A_Q(G1(:,:,:,42),Q(:,30),MT,G2(:,:,:,102))
  call loop_AV_Q(G2(:,:,:,102),wf(:,-5),G2(:,:,:,103))
  call loop_A_Q(G2(:,:,:,103),Q(:,62),MT,G3(:,:,:,94))
  call check_last_AQ_V(l_switch,G3(:,:,:,94),wf(:,0),G3tensor(:,66))
  call loop_VA_Q(G1(:,:,:,1),wf(:,438),G1(:,:,:,43))
  call loop_A_Q(G1(:,:,:,43),Q(:,62),MT,G2(:,:,:,104))
  call check_last_AQ_V(l_switch,G2(:,:,:,104),wf(:,0),G2tensor(:,48))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,78),Q(:,38),G2(:,:,:,105))
  call check_last_UV_W(l_switch,G2(:,:,:,105),Q(:,54),wf(:,6),Q(:,9),G3tensor(:,67))
  call loop_VA_Q(G2(:,:,:,105),wf(:,-3),G2(:,:,:,106))
  call loop_A_Q(G2(:,:,:,106),Q(:,62),MT,G3(:,:,:,95))
  call check_last_AQ_V(l_switch,G3(:,:,:,95),wf(:,0),G3tensor(:,68))
  call loop_VQ_A(G1(:,:,:,1),wf(:,366),G1(:,:,:,44))
  call loop_Q_A(G1(:,:,:,44),Q(:,59),MT,G2(:,:,:,107))
  call check_last_QA_V(l_switch,G2(:,:,:,107),wf(:,-2),G2tensor(:,49))
  call loop_VA_Q(G1(:,:,:,1),wf(:,66),G1(:,:,:,45))
  call loop_A_Q(G1(:,:,:,45),Q(:,52),MT,G2(:,:,:,108))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,76),G2tensor(:,50))
  call loop_AV_Q(G2(:,:,:,108),wf(:,6),G2(:,:,:,109))
  call loop_A_Q(G2(:,:,:,109),Q(:,61),MT,G3(:,:,:,96))
  call check_last_AQ_V(l_switch,G3(:,:,:,96),wf(:,-1),G3tensor(:,69))
  call check_last_AQ_V(l_switch,G2(:,:,:,108),wf(:,88),G2tensor(:,51))
  call loop_AV_Q(G2(:,:,:,108),wf(:,2),G2(:,:,:,110))
  call loop_A_Q(G2(:,:,:,110),Q(:,62),MT,G3(:,:,:,97))
  call check_last_AQ_V(l_switch,G3(:,:,:,97),wf(:,0),G3tensor(:,70))
  call loop_AQ_V(G2(:,:,:,108),wf(:,-1),G2(:,:,:,111))
  call loop_VA_Q(G2(:,:,:,111),wf(:,-3),G2(:,:,:,112))
  call loop_A_Q(G2(:,:,:,112),Q(:,62),MT,G3(:,:,:,98))
  call check_last_AQ_V(l_switch,G3(:,:,:,98),wf(:,0),G3tensor(:,71))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,80),Q(:,38),G2(:,:,:,113))
  call check_last_UV_W(l_switch,G2(:,:,:,113),Q(:,54),wf(:,6),Q(:,9),G3tensor(:,72))
  call loop_VA_Q(G2(:,:,:,113),wf(:,-3),G2(:,:,:,114))
  call loop_A_Q(G2(:,:,:,114),Q(:,62),MT,G3(:,:,:,99))
  call check_last_AQ_V(l_switch,G3(:,:,:,99),wf(:,0),G3tensor(:,73))
  call loop_VA_Q(G1(:,:,:,1),wf(:,355),G1(:,:,:,46))
  call loop_A_Q(G1(:,:,:,46),Q(:,61),MT,G2(:,:,:,115))
  call check_last_AQ_V(l_switch,G2(:,:,:,115),wf(:,-1),G2tensor(:,52))
  call loop_VQ_A(G1(:,:,:,1),wf(:,444),G1(:,:,:,47))
  call loop_Q_A(G1(:,:,:,47),Q(:,59),MT,G2(:,:,:,116))
  call check_last_QA_V(l_switch,G2(:,:,:,116),wf(:,-2),G2tensor(:,53))
  call loop_VQ_A(G1(:,:,:,1),wf(:,76),G1(:,:,:,48))
  call loop_Q_A(G1(:,:,:,48),Q(:,27),MT,G2(:,:,:,117))
  call loop_QV_A(G2(:,:,:,117),wf(:,-5),G2(:,:,:,118))
  call loop_Q_A(G2(:,:,:,118),Q(:,59),MT,G3(:,:,:,100))
  call check_last_QA_V(l_switch,G3(:,:,:,100),wf(:,-2),G3tensor(:,74))
  call loop_VA_Q(G1(:,:,:,1),wf(:,449),G1(:,:,:,49))
  call loop_A_Q(G1(:,:,:,49),Q(:,61),MT,G2(:,:,:,119))
  call check_last_AQ_V(l_switch,G2(:,:,:,119),wf(:,-1),G2tensor(:,54))
  call loop_VA_Q(G1(:,:,:,1),wf(:,69),G1(:,:,:,50))
  call loop_A_Q(G1(:,:,:,50),Q(:,29),MT,G2(:,:,:,120))
  call loop_AV_Q(G2(:,:,:,120),wf(:,-5),G2(:,:,:,121))
  call loop_A_Q(G2(:,:,:,121),Q(:,61),MT,G3(:,:,:,101))
  call check_last_AQ_V(l_switch,G3(:,:,:,101),wf(:,-1),G3tensor(:,75))
  call loop_VQ_A(G1(:,:,:,1),wf(:,456),G1(:,:,:,51))
  call loop_Q_A(G1(:,:,:,51),Q(:,59),MT,G2(:,:,:,122))
  call check_last_QA_V(l_switch,G2(:,:,:,122),wf(:,-2),G2tensor(:,55))
  call loop_VA_Q(G1(:,:,:,1),wf(:,458),G1(:,:,:,52))
  call loop_A_Q(G1(:,:,:,52),Q(:,61),MT,G2(:,:,:,123))
  call check_last_AQ_V(l_switch,G2(:,:,:,123),wf(:,-1),G2tensor(:,56))
  call loop_VA_Q(G1(:,:,:,1),wf(:,-2),G1(:,:,:,53))
  call loop_A_Q(G1(:,:,:,53),Q(:,20),MT,G2(:,:,:,124))
  call loop_AV_Q(G2(:,:,:,124),wf(:,46),G2(:,:,:,125))
  call loop_A_Q(G2(:,:,:,125),Q(:,61),MT,G3(:,:,:,102))
  call check_last_AQ_V(l_switch,G3(:,:,:,102),wf(:,-1),G3tensor(:,76))
  call loop_AV_Q(G2(:,:,:,124),wf(:,6),G2(:,:,:,126))
  call loop_A_Q(G2(:,:,:,126),Q(:,29),MT,G3(:,:,:,103))
  call loop_AV_Q(G3(:,:,:,103),wf(:,-5),G3(:,:,:,104))
  call loop_A_Q(G3(:,:,:,104),Q(:,61),MT,G4(:,:,:,28))
  call check_last_AQ_V(l_switch,G4(:,:,:,28),wf(:,-1),G4tensor(:,30))
  call loop_AV_Q(G2(:,:,:,124),wf(:,-5),G2(:,:,:,127))
  call loop_A_Q(G2(:,:,:,127),Q(:,52),MT,G3(:,:,:,105))
  call loop_AV_Q(G3(:,:,:,105),wf(:,6),G3(:,:,:,106))
  call loop_A_Q(G3(:,:,:,106),Q(:,61),MT,G4(:,:,:,29))
  call check_last_AQ_V(l_switch,G4(:,:,:,29),wf(:,-1),G4tensor(:,31))
  call loop_AV_Q(G3(:,:,:,105),wf(:,2),G3(:,:,:,107))
  call loop_A_Q(G3(:,:,:,107),Q(:,62),MT,G4(:,:,:,30))
  call check_last_AQ_V(l_switch,G4(:,:,:,30),wf(:,0),G4tensor(:,32))
  call loop_AQ_V(G3(:,:,:,105),wf(:,-1),G3(:,:,:,108))
  call loop_VA_Q(G3(:,:,:,108),wf(:,-3),G3(:,:,:,109))
  call loop_A_Q(G3(:,:,:,109),Q(:,62),MT,G4(:,:,:,31))
  call check_last_AQ_V(l_switch,G4(:,:,:,31),wf(:,0),G4tensor(:,33))
  call loop_AV_Q(G2(:,:,:,124),wf(:,14),G2(:,:,:,128))
  call loop_A_Q(G2(:,:,:,128),Q(:,62),MT,G3(:,:,:,110))
  call check_last_AQ_V(l_switch,G3(:,:,:,110),wf(:,0),G3tensor(:,77))
  call loop_AV_Q(G2(:,:,:,124),wf(:,2),G2(:,:,:,129))
  call loop_A_Q(G2(:,:,:,129),Q(:,30),MT,G3(:,:,:,111))
  call loop_AV_Q(G3(:,:,:,111),wf(:,-5),G3(:,:,:,112))
  call loop_A_Q(G3(:,:,:,112),Q(:,62),MT,G4(:,:,:,32))
  call check_last_AQ_V(l_switch,G4(:,:,:,32),wf(:,0),G4tensor(:,34))
  call loop_AV_Q(G2(:,:,:,124),wf(:,60),G2(:,:,:,130))
  call loop_A_Q(G2(:,:,:,130),Q(:,61),MT,G3(:,:,:,113))
  call check_last_AQ_V(l_switch,G3(:,:,:,113),wf(:,-1),G3tensor(:,78))
  call loop_AQ_V(G2(:,:,:,124),wf(:,55),G2(:,:,:,131))
  call loop_VA_Q(G2(:,:,:,131),wf(:,-3),G2(:,:,:,132))
  call loop_A_Q(G2(:,:,:,132),Q(:,61),MT,G3(:,:,:,114))
  call check_last_AQ_V(l_switch,G3(:,:,:,114),wf(:,-1),G3tensor(:,79))
  call loop_AV_Q(G2(:,:,:,124),wf(:,36),G2(:,:,:,133))
  call loop_A_Q(G2(:,:,:,133),Q(:,62),MT,G3(:,:,:,115))
  call check_last_AQ_V(l_switch,G3(:,:,:,115),wf(:,0),G3tensor(:,80))
  call loop_AQ_V(G2(:,:,:,124),wf(:,28),G2(:,:,:,134))
  call loop_VA_Q(G2(:,:,:,134),wf(:,-3),G2(:,:,:,135))
  call loop_A_Q(G2(:,:,:,135),Q(:,62),MT,G3(:,:,:,116))
  call check_last_AQ_V(l_switch,G3(:,:,:,116),wf(:,0),G3tensor(:,81))
  call loop_AV_Q(G2(:,:,:,124),wf(:,62),G2(:,:,:,136))
  call loop_A_Q(G2(:,:,:,136),Q(:,61),MT,G3(:,:,:,117))
  call check_last_AQ_V(l_switch,G3(:,:,:,117),wf(:,-1),G3tensor(:,82))
  call loop_AV_Q(G2(:,:,:,124),wf(:,38),G2(:,:,:,137))
  call loop_A_Q(G2(:,:,:,137),Q(:,62),MT,G3(:,:,:,118))
  call check_last_AQ_V(l_switch,G3(:,:,:,118),wf(:,0),G3tensor(:,83))
  call loop_AQ_V(G2(:,:,:,124),wf(:,-1),G2(:,:,:,138))
  call loop_VA_Q(G2(:,:,:,138),wf(:,20),G2(:,:,:,139))
  call loop_A_Q(G2(:,:,:,139),Q(:,62),MT,G3(:,:,:,119))
  call check_last_AQ_V(l_switch,G3(:,:,:,119),wf(:,0),G3tensor(:,84))
  call loop_UV_W(G2(:,:,:,138),Q(:,22),wf(:,-5),Q(:,32),G3(:,:,:,120))
  call loop_VA_Q(G3(:,:,:,120),wf(:,-3),G3(:,:,:,121))
  call loop_A_Q(G3(:,:,:,121),Q(:,62),MT,G4(:,:,:,33))
  call check_last_AQ_V(l_switch,G4(:,:,:,33),wf(:,0),G4tensor(:,35))
  call loop_VA_Q(G2(:,:,:,138),wf(:,-3),G2(:,:,:,140))
  call loop_A_Q(G2(:,:,:,140),Q(:,30),MT,G3(:,:,:,122))
  call loop_AV_Q(G3(:,:,:,122),wf(:,-5),G3(:,:,:,123))
  call loop_A_Q(G3(:,:,:,123),Q(:,62),MT,G4(:,:,:,34))
  call check_last_AQ_V(l_switch,G4(:,:,:,34),wf(:,0),G4tensor(:,36))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,90),Q(:,37),G2(:,:,:,141))
  call check_last_UV_W(l_switch,G2(:,:,:,141),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,85))
  call loop_VA_Q(G2(:,:,:,141),wf(:,-3),G2(:,:,:,142))
  call loop_A_Q(G2(:,:,:,142),Q(:,61),MT,G3(:,:,:,124))
  call check_last_AQ_V(l_switch,G3(:,:,:,124),wf(:,-1),G3tensor(:,86))
  call loop_VQ_A(G1(:,:,:,1),wf(:,391),G1(:,:,:,54))
  call loop_Q_A(G1(:,:,:,54),Q(:,59),MT,G2(:,:,:,143))
  call check_last_QA_V(l_switch,G2(:,:,:,143),wf(:,-2),G2tensor(:,57))
  call loop_UV_W(G1(:,:,:,1),Q(:,16),wf(:,91),Q(:,37),G2(:,:,:,144))
  call check_last_UV_W(l_switch,G2(:,:,:,144),Q(:,53),wf(:,2),Q(:,10),G3tensor(:,87))
  call loop_VA_Q(G2(:,:,:,144),wf(:,-3),G2(:,:,:,145))
  call loop_A_Q(G2(:,:,:,145),Q(:,61),MT,G3(:,:,:,125))
  call check_last_AQ_V(l_switch,G3(:,:,:,125),wf(:,-1),G3tensor(:,88))
  call loop_VA_Q(G1(:,:,:,1),wf(:,381),G1(:,:,:,55))
  call loop_A_Q(G1(:,:,:,55),Q(:,62),MT,G2(:,:,:,146))
  call check_last_AQ_V(l_switch,G2(:,:,:,146),wf(:,0),G2tensor(:,58))
  call loop_VQ_A(G1(:,:,:,1),wf(:,464),G1(:,:,:,56))
  call loop_Q_A(G1(:,:,:,56),Q(:,59),MT,G2(:,:,:,147))
  call check_last_QA_V(l_switch,G2(:,:,:,147),wf(:,-2),G2tensor(:,59))
  call loop_VQ_A(G1(:,:,:,1),wf(:,88),G1(:,:,:,57))
  call loop_Q_A(G1(:,:,:,57),Q(:,27),MT,G2(:,:,:,148))
  call loop_QV_A(G2(:,:,:,148),wf(:,-5),G2(:,:,:,149))
  call loop_Q_A(G2(:,:,:,149),Q(:,59),MT,G3(:,:,:,126))
  call check_last_QA_V(l_switch,G3(:,:,:,126),wf(:,-2),G3tensor(:,89))
  call loop_VQ_A(G1(:,:,:,1),wf(:,469),G1(:,:,:,58))
  call loop_Q_A(G1(:,:,:,58),Q(:,59),MT,G2(:,:,:,150))
  call check_last_QA_V(l_switch,G2(:,:,:,150),wf(:,-2),G2tensor(:,60))
  call loop_VA_Q(G1(:,:,:,1),wf(:,473),G1(:,:,:,59))
  call loop_A_Q(G1(:,:,:,59),Q(:,62),MT,G2(:,:,:,151))
  call check_last_AQ_V(l_switch,G2(:,:,:,151),wf(:,0),G2tensor(:,61))
  call loop_VA_Q(G1(:,:,:,1),wf(:,85),G1(:,:,:,60))
  call loop_A_Q(G1(:,:,:,60),Q(:,30),MT,G2(:,:,:,152))
  call loop_AV_Q(G2(:,:,:,152),wf(:,-5),G2(:,:,:,153))
  call loop_A_Q(G2(:,:,:,153),Q(:,62),MT,G3(:,:,:,127))
  call check_last_AQ_V(l_switch,G3(:,:,:,127),wf(:,0),G3tensor(:,90))
  call loop_VA_Q(G1(:,:,:,1),wf(:,478),G1(:,:,:,61))
  call loop_A_Q(G1(:,:,:,61),Q(:,62),MT,G2(:,:,:,154))
  call check_last_AQ_V(l_switch,G2(:,:,:,154),wf(:,0),G2tensor(:,62))
  call loop_VQ_A(G1(:,:,:,1),wf(:,529),G1(:,:,:,62))
  call loop_Q_A(G1(:,:,:,62),Q(:,55),MT,G2(:,:,:,155))
  call check_last_QA_V(l_switch,G2(:,:,:,155),wf(:,-3),G2tensor(:,63))
  call loop_VA_Q(G1(:,:,:,1),wf(:,531),G1(:,:,:,63))
  call loop_A_Q(G1(:,:,:,63),Q(:,61),MT,G2(:,:,:,156))
  call check_last_AQ_V(l_switch,G2(:,:,:,156),wf(:,-1),G2tensor(:,64))
  call loop_VQ_A(G1(:,:,:,1),wf(:,534),G1(:,:,:,64))
  call loop_Q_A(G1(:,:,:,64),Q(:,59),MT,G2(:,:,:,157))
  call check_last_QA_V(l_switch,G2(:,:,:,157),wf(:,-2),G2tensor(:,65))
  call loop_VA_Q(G1(:,:,:,1),wf(:,536),G1(:,:,:,65))
  call loop_A_Q(G1(:,:,:,65),Q(:,61),MT,G2(:,:,:,158))
  call check_last_AQ_V(l_switch,G2(:,:,:,158),wf(:,-1),G2tensor(:,66))
  call loop_VQ_A(G1(:,:,:,1),wf(:,541),G1(:,:,:,66))
  call loop_Q_A(G1(:,:,:,66),Q(:,55),MT,G2(:,:,:,159))
  call check_last_QA_V(l_switch,G2(:,:,:,159),wf(:,-3),G2tensor(:,67))
  call loop_VQ_A(G1(:,:,:,1),wf(:,543),G1(:,:,:,67))
  call loop_Q_A(G1(:,:,:,67),Q(:,59),MT,G2(:,:,:,160))
  call check_last_QA_V(l_switch,G2(:,:,:,160),wf(:,-2),G2tensor(:,68))
  call loop_VA_Q(G1(:,:,:,1),wf(:,545),G1(:,:,:,68))
  call loop_A_Q(G1(:,:,:,68),Q(:,62),MT,G2(:,:,:,161))
  call check_last_AQ_V(l_switch,G2(:,:,:,161),wf(:,0),G2tensor(:,69))
  call loop_VA_Q(G1(:,:,:,1),wf(:,548),G1(:,:,:,69))
  call loop_A_Q(G1(:,:,:,69),Q(:,62),MT,G2(:,:,:,162))
  call check_last_AQ_V(l_switch,G2(:,:,:,162),wf(:,0),G2tensor(:,70))
  call loop_VQ_A(G1(:,:,:,1),wf(:,553),G1(:,:,:,70))
  call loop_Q_A(G1(:,:,:,70),Q(:,55),MT,G2(:,:,:,163))
  call check_last_QA_V(l_switch,G2(:,:,:,163),wf(:,-3),G2tensor(:,71))
  call loop_VQ_A(G1(:,:,:,1),wf(:,555),G1(:,:,:,71))
  call loop_Q_A(G1(:,:,:,71),Q(:,55),MT,G2(:,:,:,164))
  call check_last_QA_V(l_switch,G2(:,:,:,164),wf(:,-3),G2tensor(:,72))
  call loop_VA_Q(G1(:,:,:,1),wf(:,557),G1(:,:,:,72))
  call loop_A_Q(G1(:,:,:,72),Q(:,61),MT,G2(:,:,:,165))
  call check_last_AQ_V(l_switch,G2(:,:,:,165),wf(:,-1),G2tensor(:,73))
  call loop_VA_Q(G1(:,:,:,1),wf(:,561),G1(:,:,:,73))
  call loop_A_Q(G1(:,:,:,73),Q(:,62),MT,G2(:,:,:,166))
  call check_last_AQ_V(l_switch,G2(:,:,:,166),wf(:,0),G2tensor(:,74))
  call loop_VQ_A(G1(:,:,:,1),wf(:,-1),G1(:,:,:,74))
  call loop_Q_A(G1(:,:,:,74),Q(:,18),MT,G2(:,:,:,167))
  call loop_QA_V(G2(:,:,:,167),wf(:,66),G2(:,:,:,168))
  call loop_VA_Q(G2(:,:,:,168),wf(:,-3),G2(:,:,:,169))
  call loop_A_Q(G2(:,:,:,169),Q(:,62),MT,G3(:,:,:,128))
  call check_last_AQ_V(l_switch,G3(:,:,:,128),wf(:,0),G3tensor(:,91))
  call loop_QA_V(G2(:,:,:,167),wf(:,-3),G2(:,:,:,170))
  call loop_VA_Q(G2(:,:,:,170),wf(:,66),G2(:,:,:,171))
  call loop_A_Q(G2(:,:,:,171),Q(:,62),MT,G3(:,:,:,129))
  call check_last_AQ_V(l_switch,G3(:,:,:,129),wf(:,0),G3tensor(:,92))
  call loop_UV_W(G2(:,:,:,170),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,130))
  call loop_VA_Q(G3(:,:,:,130),wf(:,-2),G3(:,:,:,131))
  call loop_A_Q(G3(:,:,:,131),Q(:,62),MT,G4(:,:,:,35))
  call check_last_AQ_V(l_switch,G4(:,:,:,35),wf(:,0),G4tensor(:,37))
  call loop_VA_Q(G2(:,:,:,170),wf(:,-2),G2(:,:,:,172))
  call loop_A_Q(G2(:,:,:,172),Q(:,30),MT,G3(:,:,:,132))
  call loop_AV_Q(G3(:,:,:,132),wf(:,-5),G3(:,:,:,133))
  call loop_A_Q(G3(:,:,:,133),Q(:,62),MT,G4(:,:,:,36))
  call check_last_AQ_V(l_switch,G4(:,:,:,36),wf(:,0),G4tensor(:,38))
  call loop_QA_V(G2(:,:,:,167),wf(:,20),G2(:,:,:,173))
  call loop_VA_Q(G2(:,:,:,173),wf(:,-2),G2(:,:,:,174))
  call loop_A_Q(G2(:,:,:,174),Q(:,62),MT,G3(:,:,:,134))
  call check_last_AQ_V(l_switch,G3(:,:,:,134),wf(:,0),G3tensor(:,93))
  call loop_QA_V(G2(:,:,:,167),wf(:,-2),G2(:,:,:,175))
  call loop_VA_Q(G2(:,:,:,175),wf(:,20),G2(:,:,:,176))
  call loop_A_Q(G2(:,:,:,176),Q(:,62),MT,G3(:,:,:,135))
  call check_last_AQ_V(l_switch,G3(:,:,:,135),wf(:,0),G3tensor(:,94))
  call loop_UV_W(G2(:,:,:,175),Q(:,22),wf(:,-5),Q(:,32),G3(:,:,:,136))
  call loop_VA_Q(G3(:,:,:,136),wf(:,-3),G3(:,:,:,137))
  call loop_A_Q(G3(:,:,:,137),Q(:,62),MT,G4(:,:,:,37))
  call check_last_AQ_V(l_switch,G4(:,:,:,37),wf(:,0),G4tensor(:,39))
  call loop_VA_Q(G2(:,:,:,175),wf(:,-3),G2(:,:,:,177))
  call loop_A_Q(G2(:,:,:,177),Q(:,30),MT,G3(:,:,:,138))
  call loop_AV_Q(G3(:,:,:,138),wf(:,-5),G3(:,:,:,139))
  call loop_A_Q(G3(:,:,:,139),Q(:,62),MT,G4(:,:,:,38))
  call check_last_AQ_V(l_switch,G4(:,:,:,38),wf(:,0),G4tensor(:,40))
  call loop_QV_A(G2(:,:,:,167),wf(:,-5),G2(:,:,:,178))
  call loop_Q_A(G2(:,:,:,178),Q(:,50),MT,G3(:,:,:,140))
  call loop_QA_V(G3(:,:,:,140),wf(:,-3),G3(:,:,:,141))
  call loop_VA_Q(G3(:,:,:,141),wf(:,-2),G3(:,:,:,142))
  call loop_A_Q(G3(:,:,:,142),Q(:,62),MT,G4(:,:,:,39))
  call check_last_AQ_V(l_switch,G4(:,:,:,39),wf(:,0),G4tensor(:,41))
  call loop_QA_V(G3(:,:,:,140),wf(:,-2),G3(:,:,:,143))
  call loop_VA_Q(G3(:,:,:,143),wf(:,-3),G3(:,:,:,144))
  call loop_A_Q(G3(:,:,:,144),Q(:,62),MT,G4(:,:,:,40))
  call check_last_AQ_V(l_switch,G4(:,:,:,40),wf(:,0),G4tensor(:,42))
  call loop_VQ_A(G1(:,:,:,1),wf(:,565),G1(:,:,:,75))
  call loop_Q_A(G1(:,:,:,75),Q(:,59),MT,G2(:,:,:,179))
  call check_last_QA_V(l_switch,G2(:,:,:,179),wf(:,-2),G2tensor(:,75))
  call loop_VQ_A(G1(:,:,:,1),wf(:,567),G1(:,:,:,76))
  call loop_Q_A(G1(:,:,:,76),Q(:,59),MT,G2(:,:,:,180))
  call check_last_QA_V(l_switch,G2(:,:,:,180),wf(:,-2),G2tensor(:,76))
  call loop_VA_Q(G1(:,:,:,1),wf(:,569),G1(:,:,:,77))
  call loop_A_Q(G1(:,:,:,77),Q(:,61),MT,G2(:,:,:,181))
  call check_last_AQ_V(l_switch,G2(:,:,:,181),wf(:,-1),G2tensor(:,77))
  call loop_VA_Q(G1(:,:,:,1),wf(:,573),G1(:,:,:,78))
  call loop_A_Q(G1(:,:,:,78),Q(:,62),MT,G2(:,:,:,182))
  call check_last_AQ_V(l_switch,G2(:,:,:,182),wf(:,0),G2tensor(:,78))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,2),G0(:,:,:,2))
  call loop_UV_W(G0(:,:,:,2),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,79))
  call check_last_UV_W(l_switch,G1(:,:,:,79),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,79))
  call loop_VA_Q(G1(:,:,:,79),wf(:,-2),G1(:,:,:,80))
  call loop_A_Q(G1(:,:,:,80),Q(:,62),MT,G2(:,:,:,183))
  call check_last_AQ_V(l_switch,G2(:,:,:,183),wf(:,0),G2tensor(:,80))
  call loop_VQ_A(G0(:,:,:,2),wf(:,55),G0(:,:,:,3))
  call loop_Q_A(G0(:,:,:,3),Q(:,59),MT,G1(:,:,:,81))
  call check_last_QA_V(l_switch,G1(:,:,:,81),wf(:,-2),G1tensor(:,1))
  call loop_VA_Q(G0(:,:,:,2),wf(:,66),G0(:,:,:,4))
  call loop_A_Q(G0(:,:,:,4),Q(:,62),MT,G1(:,:,:,82))
  call check_last_AQ_V(l_switch,G1(:,:,:,82),wf(:,0),G1tensor(:,2))
  call loop_VA_Q(G0(:,:,:,2),wf(:,-2),G0(:,:,:,5))
  call loop_A_Q(G0(:,:,:,5),Q(:,30),MT,G1(:,:,:,83))
  call loop_AV_Q(G1(:,:,:,83),wf(:,-5),G1(:,:,:,84))
  call loop_A_Q(G1(:,:,:,84),Q(:,62),MT,G2(:,:,:,184))
  call check_last_AQ_V(l_switch,G2(:,:,:,184),wf(:,0),G2tensor(:,81))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,2),wf(:,-4),G0(:,:,:,6))
  call loop_UV_W(G0(:,:,:,6),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,85))
  call check_last_UV_W(l_switch,G1(:,:,:,85),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,82))
  call loop_VA_Q(G1(:,:,:,85),wf(:,-2),G1(:,:,:,86))
  call loop_A_Q(G1(:,:,:,86),Q(:,62),MT,G2(:,:,:,185))
  call check_last_AQ_V(l_switch,G2(:,:,:,185),wf(:,0),G2tensor(:,83))
  call loop_VQ_A(G0(:,:,:,6),wf(:,55),G0(:,:,:,7))
  call loop_Q_A(G0(:,:,:,7),Q(:,59),MT,G1(:,:,:,87))
  call check_last_QA_V(l_switch,G1(:,:,:,87),wf(:,-2),G1tensor(:,3))
  call loop_VA_Q(G0(:,:,:,6),wf(:,66),G0(:,:,:,8))
  call loop_A_Q(G0(:,:,:,8),Q(:,62),MT,G1(:,:,:,88))
  call check_last_AQ_V(l_switch,G1(:,:,:,88),wf(:,0),G1tensor(:,4))
  call loop_VA_Q(G0(:,:,:,6),wf(:,-2),G0(:,:,:,9))
  call loop_A_Q(G0(:,:,:,9),Q(:,30),MT,G1(:,:,:,89))
  call loop_AV_Q(G1(:,:,:,89),wf(:,-5),G1(:,:,:,90))
  call loop_A_Q(G1(:,:,:,90),Q(:,62),MT,G2(:,:,:,186))
  call check_last_AQ_V(l_switch,G2(:,:,:,186),wf(:,0),G2tensor(:,84))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,2),G0(:,:,:,10))
  call loop_UV_W(G0(:,:,:,10),Q(:,26),wf(:,-5),Q(:,32),G1(:,:,:,91))
  call check_last_UV_W(l_switch,G1(:,:,:,91),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,85))
  call loop_VA_Q(G1(:,:,:,91),wf(:,-2),G1(:,:,:,92))
  call loop_A_Q(G1(:,:,:,92),Q(:,62),MT,G2(:,:,:,187))
  call check_last_AQ_V(l_switch,G2(:,:,:,187),wf(:,0),G2tensor(:,86))
  call loop_VQ_A(G0(:,:,:,10),wf(:,55),G0(:,:,:,11))
  call loop_Q_A(G0(:,:,:,11),Q(:,59),MT,G1(:,:,:,93))
  call check_last_QA_V(l_switch,G1(:,:,:,93),wf(:,-2),G1tensor(:,5))
  call loop_VA_Q(G0(:,:,:,10),wf(:,66),G0(:,:,:,12))
  call loop_A_Q(G0(:,:,:,12),Q(:,62),MT,G1(:,:,:,94))
  call check_last_AQ_V(l_switch,G1(:,:,:,94),wf(:,0),G1tensor(:,6))
  call loop_VA_Q(G0(:,:,:,10),wf(:,-2),G0(:,:,:,13))
  call loop_A_Q(G0(:,:,:,13),Q(:,30),MT,G1(:,:,:,95))
  call loop_AV_Q(G1(:,:,:,95),wf(:,-5),G1(:,:,:,96))
  call loop_A_Q(G1(:,:,:,96),Q(:,62),MT,G2(:,:,:,188))
  call check_last_AQ_V(l_switch,G2(:,:,:,188),wf(:,0),G2tensor(:,87))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,14))
  call loop_UV_W(G0(:,:,:,14),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,97))
  call check_last_UV_W(l_switch,G1(:,:,:,97),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,88))
  call loop_VA_Q(G1(:,:,:,97),wf(:,-3),G1(:,:,:,98))
  call loop_A_Q(G1(:,:,:,98),Q(:,61),MT,G2(:,:,:,189))
  call check_last_AQ_V(l_switch,G2(:,:,:,189),wf(:,-1),G2tensor(:,89))
  call loop_VQ_A(G0(:,:,:,14),wf(:,28),G0(:,:,:,15))
  call loop_Q_A(G0(:,:,:,15),Q(:,55),MT,G1(:,:,:,99))
  call check_last_QA_V(l_switch,G1(:,:,:,99),wf(:,-3),G1tensor(:,7))
  call loop_VA_Q(G0(:,:,:,14),wf(:,20),G0(:,:,:,16))
  call loop_A_Q(G0(:,:,:,16),Q(:,61),MT,G1(:,:,:,100))
  call check_last_AQ_V(l_switch,G1(:,:,:,100),wf(:,-1),G1tensor(:,8))
  call loop_VA_Q(G0(:,:,:,14),wf(:,-3),G0(:,:,:,17))
  call loop_A_Q(G0(:,:,:,17),Q(:,29),MT,G1(:,:,:,101))
  call loop_AV_Q(G1(:,:,:,101),wf(:,-5),G1(:,:,:,102))
  call loop_A_Q(G1(:,:,:,102),Q(:,61),MT,G2(:,:,:,190))
  call check_last_AQ_V(l_switch,G2(:,:,:,190),wf(:,-1),G2tensor(:,90))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-4),G0(:,:,:,18))
  call loop_UV_W(G0(:,:,:,18),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,103))
  call check_last_UV_W(l_switch,G1(:,:,:,103),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,91))
  call loop_VA_Q(G1(:,:,:,103),wf(:,-3),G1(:,:,:,104))
  call loop_A_Q(G1(:,:,:,104),Q(:,61),MT,G2(:,:,:,191))
  call check_last_AQ_V(l_switch,G2(:,:,:,191),wf(:,-1),G2tensor(:,92))
  call loop_VQ_A(G0(:,:,:,18),wf(:,28),G0(:,:,:,19))
  call loop_Q_A(G0(:,:,:,19),Q(:,55),MT,G1(:,:,:,105))
  call check_last_QA_V(l_switch,G1(:,:,:,105),wf(:,-3),G1tensor(:,9))
  call loop_VA_Q(G0(:,:,:,18),wf(:,20),G0(:,:,:,20))
  call loop_A_Q(G0(:,:,:,20),Q(:,61),MT,G1(:,:,:,106))
  call check_last_AQ_V(l_switch,G1(:,:,:,106),wf(:,-1),G1tensor(:,10))
  call loop_VA_Q(G0(:,:,:,18),wf(:,-3),G0(:,:,:,21))
  call loop_A_Q(G0(:,:,:,21),Q(:,29),MT,G1(:,:,:,107))
  call loop_AV_Q(G1(:,:,:,107),wf(:,-5),G1(:,:,:,108))
  call loop_A_Q(G1(:,:,:,108),Q(:,61),MT,G2(:,:,:,192))
  call check_last_AQ_V(l_switch,G2(:,:,:,192),wf(:,-1),G2tensor(:,93))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,1),G0(:,:,:,22))
  call loop_UV_W(G0(:,:,:,22),Q(:,21),wf(:,-5),Q(:,32),G1(:,:,:,109))
  call check_last_UV_W(l_switch,G1(:,:,:,109),Q(:,53),wf(:,2),Q(:,10),G2tensor(:,94))
  call loop_VA_Q(G1(:,:,:,109),wf(:,-3),G1(:,:,:,110))
  call loop_A_Q(G1(:,:,:,110),Q(:,61),MT,G2(:,:,:,193))
  call check_last_AQ_V(l_switch,G2(:,:,:,193),wf(:,-1),G2tensor(:,95))
  call loop_VQ_A(G0(:,:,:,22),wf(:,28),G0(:,:,:,23))
  call loop_Q_A(G0(:,:,:,23),Q(:,55),MT,G1(:,:,:,111))
  call check_last_QA_V(l_switch,G1(:,:,:,111),wf(:,-3),G1tensor(:,11))
  call loop_VA_Q(G0(:,:,:,22),wf(:,20),G0(:,:,:,24))
  call loop_A_Q(G0(:,:,:,24),Q(:,61),MT,G1(:,:,:,112))
  call check_last_AQ_V(l_switch,G1(:,:,:,112),wf(:,-1),G1tensor(:,12))
  call loop_VA_Q(G0(:,:,:,22),wf(:,-3),G0(:,:,:,25))
  call loop_A_Q(G0(:,:,:,25),Q(:,29),MT,G1(:,:,:,113))
  call loop_AV_Q(G1(:,:,:,113),wf(:,-5),G1(:,:,:,114))
  call loop_A_Q(G1(:,:,:,114),Q(:,61),MT,G2(:,:,:,194))
  call check_last_AQ_V(l_switch,G2(:,:,:,194),wf(:,-1),G2tensor(:,96))
  call loop_UV_W(G0(:,:,:,1),Q(:,0),wf(:,2),Q(:,10),G1(:,:,:,115))
  call loop_GGG_G_12(G1(:,:,:,115),wf(:,-5),wf(:,-4),G1(:,:,:,116))
  call check_last_UV_W(l_switch,G1(:,:,:,116),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,97))
  call loop_VA_Q(G1(:,:,:,116),wf(:,-2),G1(:,:,:,117))
  call loop_A_Q(G1(:,:,:,117),Q(:,62),MT,G2(:,:,:,195))
  call check_last_AQ_V(l_switch,G2(:,:,:,195),wf(:,0),G2tensor(:,98))
  call loop_GGG_G_12(G1(:,:,:,115),wf(:,-4),wf(:,-5),G1(:,:,:,118))
  call check_last_UV_W(l_switch,G1(:,:,:,118),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,99))
  call loop_VA_Q(G1(:,:,:,118),wf(:,-2),G1(:,:,:,119))
  call loop_A_Q(G1(:,:,:,119),Q(:,62),MT,G2(:,:,:,196))
  call check_last_AQ_V(l_switch,G2(:,:,:,196),wf(:,0),G2tensor(:,100))
  call loop_GGG_G_23(G1(:,:,:,115),wf(:,-5),wf(:,-4),G1(:,:,:,120))
  call check_last_UV_W(l_switch,G1(:,:,:,120),Q(:,58),wf(:,1),Q(:,5),G2tensor(:,101))
  call loop_VA_Q(G1(:,:,:,120),wf(:,-2),G1(:,:,:,121))
  call loop_A_Q(G1(:,:,:,121),Q(:,62),MT,G2(:,:,:,197))
  call check_last_AQ_V(l_switch,G2(:,:,:,197),wf(:,0),G2tensor(:,102))
  call loop_UV_W(G1(:,:,:,115),Q(:,10),wf(:,11),Q(:,48),G2(:,:,:,198))
  call check_last_UV_W(l_switch,G2(:,:,:,198),Q(:,58),wf(:,1),Q(:,5),G3tensor(:,95))
  call loop_VA_Q(G2(:,:,:,198),wf(:,-2),G2(:,:,:,199))
  call loop_A_Q(G2(:,:,:,199),Q(:,62),MT,G3(:,:,:,145))
  call check_last_AQ_V(l_switch,G3(:,:,:,145),wf(:,0),G3tensor(:,96))
  call loop_UV_W(G1(:,:,:,115),Q(:,10),wf(:,-5),Q(:,32),G2(:,:,:,200))
  call loop_UV_W(G2(:,:,:,200),Q(:,42),wf(:,-4),Q(:,16),G3(:,:,:,146))
  call check_last_UV_W(l_switch,G3(:,:,:,146),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,43))
  call loop_VA_Q(G3(:,:,:,146),wf(:,-2),G3(:,:,:,147))
  call loop_A_Q(G3(:,:,:,147),Q(:,62),MT,G4(:,:,:,41))
  call check_last_AQ_V(l_switch,G4(:,:,:,41),wf(:,0),G4tensor(:,44))
  call loop_VQ_A(G2(:,:,:,200),wf(:,48),G2(:,:,:,201))
  call loop_Q_A(G2(:,:,:,201),Q(:,59),MT,G3(:,:,:,148))
  call check_last_QA_V(l_switch,G3(:,:,:,148),wf(:,-2),G3tensor(:,97))
  call loop_VA_Q(G2(:,:,:,200),wf(:,72),G2(:,:,:,202))
  call loop_A_Q(G2(:,:,:,202),Q(:,62),MT,G3(:,:,:,149))
  call check_last_AQ_V(l_switch,G3(:,:,:,149),wf(:,0),G3tensor(:,98))
  call loop_VA_Q(G2(:,:,:,200),wf(:,-2),G2(:,:,:,203))
  call loop_A_Q(G2(:,:,:,203),Q(:,46),MT,G3(:,:,:,150))
  call loop_AV_Q(G3(:,:,:,150),wf(:,-4),G3(:,:,:,151))
  call loop_A_Q(G3(:,:,:,151),Q(:,62),MT,G4(:,:,:,42))
  call check_last_AQ_V(l_switch,G4(:,:,:,42),wf(:,0),G4tensor(:,45))
  call loop_UV_W(G1(:,:,:,115),Q(:,10),wf(:,-4),Q(:,16),G2(:,:,:,204))
  call loop_UV_W(G2(:,:,:,204),Q(:,26),wf(:,-5),Q(:,32),G3(:,:,:,152))
  call check_last_UV_W(l_switch,G3(:,:,:,152),Q(:,58),wf(:,1),Q(:,5),G4tensor(:,46))
  call loop_VA_Q(G3(:,:,:,152),wf(:,-2),G3(:,:,:,153))
  call loop_A_Q(G3(:,:,:,153),Q(:,62),MT,G4(:,:,:,43))
  call check_last_AQ_V(l_switch,G4(:,:,:,43),wf(:,0),G4tensor(:,47))
  call loop_VQ_A(G2(:,:,:,204),wf(:,55),G2(:,:,:,205))
  call loop_Q_A(G2(:,:,:,205),Q(:,59),MT,G3(:,:,:,154))
  call check_last_QA_V(l_switch,G3(:,:,:,154),wf(:,-2),G3tensor(:,99))
  call loop_VA_Q(G2(:,:,:,204),wf(:,66),G2(:,:,:,206))
  call loop_A_Q(G2(:,:,:,206),Q(:,62),MT,G3(:,:,:,155))
  call check_last_AQ_V(l_switch,G3(:,:,:,155),wf(:,0),G3tensor(:,100))
  call loop_VA_Q(G2(:,:,:,204),wf(:,-2),G2(:,:,:,207))
  call loop_A_Q(G2(:,:,:,207),Q(:,30),MT,G3(:,:,:,156))
  call loop_AV_Q(G3(:,:,:,156),wf(:,-5),G3(:,:,:,157))
  call loop_A_Q(G3(:,:,:,157),Q(:,62),MT,G4(:,:,:,44))
  call check_last_AQ_V(l_switch,G4(:,:,:,44),wf(:,0),G4tensor(:,48))
  call loop_VQ_A(G1(:,:,:,115),wf(:,159),G1(:,:,:,122))
  call loop_Q_A(G1(:,:,:,122),Q(:,59),MT,G2(:,:,:,208))
  call check_last_QA_V(l_switch,G2(:,:,:,208),wf(:,-2),G2tensor(:,103))
  call loop_VQ_A(G1(:,:,:,115),wf(:,48),G1(:,:,:,123))
  call loop_Q_A(G1(:,:,:,123),Q(:,27),MT,G2(:,:,:,209))
  call loop_QV_A(G2(:,:,:,209),wf(:,-5),G2(:,:,:,210))
  call loop_Q_A(G2(:,:,:,210),Q(:,59),MT,G3(:,:,:,158))
  call check_last_QA_V(l_switch,G3(:,:,:,158),wf(:,-2),G3tensor(:,101))
  call loop_VA_Q(G1(:,:,:,115),wf(:,211),G1(:,:,:,124))
  call loop_A_Q(G1(:,:,:,124),Q(:,62),MT,G2(:,:,:,211))
  call check_last_AQ_V(l_switch,G2(:,:,:,211),wf(:,0),G2tensor(:,104))
  call loop_VA_Q(G1(:,:,:,115),wf(:,72),G1(:,:,:,125))
  call loop_A_Q(G1(:,:,:,125),Q(:,30),MT,G2(:,:,:,212))
  call loop_AV_Q(G2(:,:,:,212),wf(:,-5),G2(:,:,:,213))
  call loop_A_Q(G2(:,:,:,213),Q(:,62),MT,G3(:,:,:,159))
  call check_last_AQ_V(l_switch,G3(:,:,:,159),wf(:,0),G3tensor(:,102))
  call loop_VQ_A(G1(:,:,:,115),wf(:,161),G1(:,:,:,126))
  call loop_Q_A(G1(:,:,:,126),Q(:,59),MT,G2(:,:,:,214))
  call check_last_QA_V(l_switch,G2(:,:,:,214),wf(:,-2),G2tensor(:,105))
  call loop_VQ_A(G1(:,:,:,115),wf(:,55),G1(:,:,:,127))
  call loop_Q_A(G1(:,:,:,127),Q(:,43),MT,G2(:,:,:,215))
  call loop_QV_A(G2(:,:,:,215),wf(:,-4),G2(:,:,:,216))
  call loop_Q_A(G2(:,:,:,216),Q(:,59),MT,G3(:,:,:,160))
  call check_last_QA_V(l_switch,G3(:,:,:,160),wf(:,-2),G3tensor(:,103))
  call loop_VA_Q(G1(:,:,:,115),wf(:,214),G1(:,:,:,128))
  call loop_A_Q(G1(:,:,:,128),Q(:,62),MT,G2(:,:,:,217))
  call check_last_AQ_V(l_switch,G2(:,:,:,217),wf(:,0),G2tensor(:,106))
  call loop_VA_Q(G1(:,:,:,115),wf(:,66),G1(:,:,:,129))
  call loop_A_Q(G1(:,:,:,129),Q(:,46),MT,G2(:,:,:,218))
  call loop_AV_Q(G2(:,:,:,218),wf(:,-4),G2(:,:,:,219))
  call loop_A_Q(G2(:,:,:,219),Q(:,62),MT,G3(:,:,:,161))
  call check_last_AQ_V(l_switch,G3(:,:,:,161),wf(:,0),G3tensor(:,104))
  call loop_VQ_A(G1(:,:,:,115),wf(:,64),G1(:,:,:,130))
  call loop_Q_A(G1(:,:,:,130),Q(:,59),MT,G2(:,:,:,220))
  call check_last_QA_V(l_switch,G2(:,:,:,220),wf(:,-2),G2tensor(:,107))
  call loop_VA_Q(G1(:,:,:,115),wf(:,215),G1(:,:,:,131))
  call loop_A_Q(G1(:,:,:,131),Q(:,62),MT,G2(:,:,:,221))
  call check_last_AQ_V(l_switch,G2(:,:,:,221),wf(:,0),G2tensor(:,108))
  call loop_VA_Q(G1(:,:,:,115),wf(:,-2),G1(:,:,:,132))
  call loop_A_Q(G1(:,:,:,132),Q(:,14),MT,G2(:,:,:,222))
  call loop_AV_Q(G2(:,:,:,222),wf(:,11),G2(:,:,:,223))
  call loop_A_Q(G2(:,:,:,223),Q(:,62),MT,G3(:,:,:,162))
  call check_last_AQ_V(l_switch,G3(:,:,:,162),wf(:,0),G3tensor(:,105))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-5),G2(:,:,:,224))
  call loop_A_Q(G2(:,:,:,224),Q(:,46),MT,G3(:,:,:,163))
  call loop_AV_Q(G3(:,:,:,163),wf(:,-4),G3(:,:,:,164))
  call loop_A_Q(G3(:,:,:,164),Q(:,62),MT,G4(:,:,:,45))
  call check_last_AQ_V(l_switch,G4(:,:,:,45),wf(:,0),G4tensor(:,49))
  call loop_AV_Q(G2(:,:,:,222),wf(:,-4),G2(:,:,:,225))
  call loop_A_Q(G2(:,:,:,225),Q(:,30),MT,G3(:,:,:,165))
  call loop_AV_Q(G3(:,:,:,165),wf(:,-5),G3(:,:,:,166))
  call loop_A_Q(G3(:,:,:,166),Q(:,62),MT,G4(:,:,:,46))
  call check_last_AQ_V(l_switch,G4(:,:,:,46),wf(:,0),G4tensor(:,50))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,26))
  call loop_VQ_A(G0(:,:,:,26),wf(:,19),G0(:,:,:,27))
  call loop_Q_A(G0(:,:,:,27),Q(:,55),MT,G1(:,:,:,133))
  call check_last_QA_V(l_switch,G1(:,:,:,133),wf(:,-3),G1tensor(:,13))
  call loop_VA_Q(G0(:,:,:,26),wf(:,29),G0(:,:,:,28))
  call loop_A_Q(G0(:,:,:,28),Q(:,61),MT,G1(:,:,:,134))
  call check_last_AQ_V(l_switch,G1(:,:,:,134),wf(:,-1),G1tensor(:,14))
  call loop_UV_W(G0(:,:,:,26),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,135))
  call loop_VA_Q(G1(:,:,:,135),wf(:,-3),G1(:,:,:,136))
  call loop_A_Q(G1(:,:,:,136),Q(:,61),MT,G2(:,:,:,226))
  call check_last_AQ_V(l_switch,G2(:,:,:,226),wf(:,-1),G2tensor(:,109))
  call loop_VA_Q(G0(:,:,:,26),wf(:,-3),G0(:,:,:,29))
  call loop_A_Q(G0(:,:,:,29),Q(:,45),MT,G1(:,:,:,137))
  call loop_AV_Q(G1(:,:,:,137),wf(:,-4),G1(:,:,:,138))
  call loop_A_Q(G1(:,:,:,138),Q(:,61),MT,G2(:,:,:,227))
  call check_last_AQ_V(l_switch,G2(:,:,:,227),wf(:,-1),G2tensor(:,110))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,2),G0tensor(:,1))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,26),wf(:,2),wf(:,-4),G0tensor(:,2))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,26),wf(:,-4),wf(:,2),G0tensor(:,3))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,15))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,25),Q(:,26),G1tensor(:,16))
  call check_last_UV_W(l_switch,G0(:,:,:,26),Q(:,37),wf(:,34),Q(:,26),G1tensor(:,17))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,-5),G0(:,:,:,30))
  call loop_VQ_A(G0(:,:,:,30),wf(:,19),G0(:,:,:,31))
  call loop_Q_A(G0(:,:,:,31),Q(:,55),MT,G1(:,:,:,139))
  call check_last_QA_V(l_switch,G1(:,:,:,139),wf(:,-3),G1tensor(:,18))
  call loop_VA_Q(G0(:,:,:,30),wf(:,29),G0(:,:,:,32))
  call loop_A_Q(G0(:,:,:,32),Q(:,61),MT,G1(:,:,:,140))
  call check_last_AQ_V(l_switch,G1(:,:,:,140),wf(:,-1),G1tensor(:,19))
  call loop_UV_W(G0(:,:,:,30),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,141))
  call loop_VA_Q(G1(:,:,:,141),wf(:,-3),G1(:,:,:,142))
  call loop_A_Q(G1(:,:,:,142),Q(:,61),MT,G2(:,:,:,228))
  call check_last_AQ_V(l_switch,G2(:,:,:,228),wf(:,-1),G2tensor(:,111))
  call loop_VA_Q(G0(:,:,:,30),wf(:,-3),G0(:,:,:,33))
  call loop_A_Q(G0(:,:,:,33),Q(:,45),MT,G1(:,:,:,143))
  call loop_AV_Q(G1(:,:,:,143),wf(:,-4),G1(:,:,:,144))
  call loop_A_Q(G1(:,:,:,144),Q(:,61),MT,G2(:,:,:,229))
  call check_last_AQ_V(l_switch,G2(:,:,:,229),wf(:,-1),G2tensor(:,112))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,-4),wf(:,2),G0tensor(:,4))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,30),wf(:,2),wf(:,-4),G0tensor(:,5))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,30),wf(:,-4),wf(:,2),G0tensor(:,6))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,20))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,25),Q(:,26),G1tensor(:,21))
  call check_last_UV_W(l_switch,G0(:,:,:,30),Q(:,37),wf(:,34),Q(:,26),G1tensor(:,22))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,1),G0(:,:,:,34))
  call loop_VQ_A(G0(:,:,:,34),wf(:,19),G0(:,:,:,35))
  call loop_Q_A(G0(:,:,:,35),Q(:,55),MT,G1(:,:,:,145))
  call check_last_QA_V(l_switch,G1(:,:,:,145),wf(:,-3),G1tensor(:,23))
  call loop_VA_Q(G0(:,:,:,34),wf(:,29),G0(:,:,:,36))
  call loop_A_Q(G0(:,:,:,36),Q(:,61),MT,G1(:,:,:,146))
  call check_last_AQ_V(l_switch,G1(:,:,:,146),wf(:,-1),G1tensor(:,24))
  call loop_UV_W(G0(:,:,:,34),Q(:,37),wf(:,-4),Q(:,16),G1(:,:,:,147))
  call loop_VA_Q(G1(:,:,:,147),wf(:,-3),G1(:,:,:,148))
  call loop_A_Q(G1(:,:,:,148),Q(:,61),MT,G2(:,:,:,230))
  call check_last_AQ_V(l_switch,G2(:,:,:,230),wf(:,-1),G2tensor(:,113))
  call loop_VA_Q(G0(:,:,:,34),wf(:,-3),G0(:,:,:,37))
  call loop_A_Q(G0(:,:,:,37),Q(:,45),MT,G1(:,:,:,149))
  call loop_AV_Q(G1(:,:,:,149),wf(:,-4),G1(:,:,:,150))
  call loop_A_Q(G1(:,:,:,150),Q(:,61),MT,G2(:,:,:,231))
  call check_last_AQ_V(l_switch,G2(:,:,:,231),wf(:,-1),G2tensor(:,114))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,2),G0tensor(:,7))
  call check_last_GGG_G_12(l_switch,G0(:,:,:,34),wf(:,2),wf(:,-4),G0tensor(:,8))
  call check_last_GGG_G_23(l_switch,G0(:,:,:,34),wf(:,-4),wf(:,2),G0tensor(:,9))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,15),Q(:,26),G1tensor(:,25))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,25),Q(:,26),G1tensor(:,26))
  call check_last_UV_W(l_switch,G0(:,:,:,34),Q(:,37),wf(:,34),Q(:,26),G1tensor(:,27))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,1),wf(:,11),G0(:,:,:,38))
  call loop_VA_Q(G0(:,:,:,38),wf(:,-3),G0(:,:,:,39))
  call loop_A_Q(G0(:,:,:,39),Q(:,61),MT,G1(:,:,:,151))
  call check_last_AQ_V(l_switch,G1(:,:,:,151),wf(:,-1),G1tensor(:,28))
  call check_last_UV_W(l_switch,G0(:,:,:,38),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,29))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,11),wf(:,1),G0(:,:,:,40))
  call loop_VA_Q(G0(:,:,:,40),wf(:,-3),G0(:,:,:,41))
  call loop_A_Q(G0(:,:,:,41),Q(:,61),MT,G1(:,:,:,152))
  call check_last_AQ_V(l_switch,G1(:,:,:,152),wf(:,-1),G1tensor(:,30))
  call check_last_UV_W(l_switch,G0(:,:,:,40),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,31))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,1),wf(:,11),G0(:,:,:,42))
  call loop_VA_Q(G0(:,:,:,42),wf(:,-3),G0(:,:,:,43))
  call loop_A_Q(G0(:,:,:,43),Q(:,61),MT,G1(:,:,:,153))
  call check_last_AQ_V(l_switch,G1(:,:,:,153),wf(:,-1),G1tensor(:,32))
  call check_last_UV_W(l_switch,G0(:,:,:,42),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,33))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,44))
  call loop_VA_Q(G0(:,:,:,44),wf(:,-3),G0(:,:,:,45))
  call loop_A_Q(G0(:,:,:,45),Q(:,61),MT,G1(:,:,:,154))
  call check_last_AQ_V(l_switch,G1(:,:,:,154),wf(:,-1),G1tensor(:,34))
  call check_last_UV_W(l_switch,G0(:,:,:,44),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,35))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,13),wf(:,-5),G0(:,:,:,46))
  call loop_VA_Q(G0(:,:,:,46),wf(:,-3),G0(:,:,:,47))
  call loop_A_Q(G0(:,:,:,47),Q(:,61),MT,G1(:,:,:,155))
  call check_last_AQ_V(l_switch,G1(:,:,:,155),wf(:,-1),G1tensor(:,36))
  call check_last_UV_W(l_switch,G0(:,:,:,46),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,37))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-5),wf(:,13),G0(:,:,:,48))
  call loop_VA_Q(G0(:,:,:,48),wf(:,-3),G0(:,:,:,49))
  call loop_A_Q(G0(:,:,:,49),Q(:,61),MT,G1(:,:,:,156))
  call check_last_AQ_V(l_switch,G1(:,:,:,156),wf(:,-1),G1tensor(:,38))
  call check_last_UV_W(l_switch,G0(:,:,:,48),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,39))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,50))
  call loop_VA_Q(G0(:,:,:,50),wf(:,-3),G0(:,:,:,51))
  call loop_A_Q(G0(:,:,:,51),Q(:,61),MT,G1(:,:,:,157))
  call check_last_AQ_V(l_switch,G1(:,:,:,157),wf(:,-1),G1tensor(:,40))
  call check_last_UV_W(l_switch,G0(:,:,:,50),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,41))
  call loop_GGG_G_12(G0(:,:,:,1),wf(:,16),wf(:,-4),G0(:,:,:,52))
  call loop_VA_Q(G0(:,:,:,52),wf(:,-3),G0(:,:,:,53))
  call loop_A_Q(G0(:,:,:,53),Q(:,61),MT,G1(:,:,:,158))
  call check_last_AQ_V(l_switch,G1(:,:,:,158),wf(:,-1),G1tensor(:,42))
  call check_last_UV_W(l_switch,G0(:,:,:,52),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,43))
  call loop_GGG_G_23(G0(:,:,:,1),wf(:,-4),wf(:,16),G0(:,:,:,54))
  call loop_VA_Q(G0(:,:,:,54),wf(:,-3),G0(:,:,:,55))
  call loop_A_Q(G0(:,:,:,55),Q(:,61),MT,G1(:,:,:,159))
  call check_last_AQ_V(l_switch,G1(:,:,:,159),wf(:,-1),G1tensor(:,44))
  call check_last_UV_W(l_switch,G0(:,:,:,54),Q(:,53),wf(:,2),Q(:,10),G1tensor(:,45))

  end if

  ! add colour interference with born to the sum of coefficient tensors for the proper tensor integral
  Gcoeff = (c(29)*(-M(7)-M(10))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,1)
  Gcoeff = (c(29)*(-M(6)-M(11))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,2)
  Gcoeff = (c(29)*(-M(6)+M(7)+M(10)-M(11))) * den(3)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,3)
  Gcoeff = (c(29)*(-M(6)-M(11))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,7)
  Gcoeff = (c(29)*(-M(2)-M(3))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,9)
  Gcoeff = (c(29)*(-M(2)-M(3)+M(6)+M(11))) * den(3)
  T3sum(1:15,2) = T3sum(1:15,2) + Gcoeff * G2tensor(:,11)
  Gcoeff = (c(29)*(-M(7)-M(10))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,13)
  Gcoeff = (c(29)*(-M(2)-M(3))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,15)
  Gcoeff = (c(29)*(-M(2)-M(3)+M(7)+M(10))) * den(3)
  T3sum(1:15,3) = T3sum(1:15,3) + Gcoeff * G2tensor(:,17)
  Gcoeff = (c(29)*(-M(2)-M(3))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,79)
  Gcoeff = (c(29)*(-M(7)-M(10))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,82)
  Gcoeff = (c(29)*(M(2)+M(3)-M(7)-M(10))) * den(3)
  T3sum(1:15,4) = T3sum(1:15,4) + Gcoeff * G2tensor(:,85)
  Gcoeff = (c(29)*(-M(2)-M(3))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,88)
  Gcoeff = (c(29)*(-M(6)-M(11))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,91)
  Gcoeff = (c(29)*(M(2)+M(3)-M(6)-M(11))) * den(3)
  T3sum(1:15,5) = T3sum(1:15,5) + Gcoeff * G2tensor(:,94)
  Gcoeff = (c(29)*(-M(6)-M(11))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,97)
  Gcoeff = (c(29)*(-M(7)-M(10))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,99)
  Gcoeff = (c(29)*(M(6)-M(7)-M(10)+M(11))) * den(3)
  T3sum(1:15,6) = T3sum(1:15,6) + Gcoeff * G2tensor(:,101)
  Gcoeff = (-(c(29)*M(3))+c(24)*(-M(1)+M(12))) * den(17)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,13)
  Gcoeff = (-(c(29)*M(10))+c(24)*(-M(1)+M(12))) * den(17)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,18)
  Gcoeff = (c(29)*(M(3)-M(10))) * den(17)
  T2sum(1:5,1) = T2sum(1:5,1) + Gcoeff * G1tensor(:,23)
  Gcoeff = (-(c(29)*M(2))+c(24)*(-M(1)+M(8))) * den(263)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,14)
  Gcoeff = (-(c(29)*M(7))+c(24)*(-M(1)+M(8))) * den(263)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,19)
  Gcoeff = (c(29)*(M(2)-M(7))) * den(263)
  T2sum(1:5,2) = T2sum(1:5,2) + Gcoeff * G1tensor(:,24)
  Gcoeff = (c(14)*(M(7)-M(11))+c(9)*(M(5)-M(8)-M(9)+M(12))) * den(229)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,28)
  Gcoeff = (c(14)*(M(6)-M(10))+c(9)*(M(5)-M(8)-M(9)+M(12))) * den(229)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,30)
  Gcoeff = (c(14)*(M(6)-M(7)-M(10)+M(11))) * den(229)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,32)
  Gcoeff = (c(14)*(-M(2)+M(6))+c(9)*(M(5)-M(9))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,34)
  Gcoeff = (c(9)*(M(5)-M(9))+c(14)*(M(3)-M(11))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,36)
  Gcoeff = (c(14)*(M(2)+M(3)-M(6)-M(11))) * den(10)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,38)
  Gcoeff = (-(c(14)*M(10))+c(9)*(-M(1)-M(4)+M(5)+M(12)-M(13))) * den(1)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,14)
  Gcoeff = (-(c(14)*M(3))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(1)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,16)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(14)*(-M(3)+M(10))) * den(1)
  T3sum(1:15,7) = T3sum(1:15,7) + Gcoeff * G2tensor(:,18)
  Gcoeff = (-(c(14)*M(2))+c(9)*(-M(1)-M(4)+M(5)+M(8)-M(13))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,109)
  Gcoeff = (-(c(14)*M(7))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,111)
  Gcoeff = (c(14)*(M(2)-M(7))+c(9)*(-M(5)+M(9))) * den(1)
  T3sum(1:15,8) = T3sum(1:15,8) + Gcoeff * G2tensor(:,113)
  Gcoeff = (c(24)*(M(4)-M(5)+M(13))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,110)
  Gcoeff = (c(24)*(M(4)-M(9)+M(13))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,112)
  Gcoeff = (c(24)*(M(5)-M(9))) * den(1)
  T3sum(1:15,9) = T3sum(1:15,9) + Gcoeff * G2tensor(:,114)
  Gcoeff = (-(c(29)*M(2))+c(24)*(-M(4)+M(8))) * den(26)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,7)
  Gcoeff = (-(c(29)*M(6))+c(24)*(-M(4)+M(8))) * den(26)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,9)
  Gcoeff = (c(29)*(M(2)-M(6))) * den(26)
  T2sum(1:5,4) = T2sum(1:5,4) + Gcoeff * G1tensor(:,11)
  Gcoeff = (-(c(29)*M(3))+c(24)*(-M(4)+M(12))) * den(246)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,8)
  Gcoeff = (-(c(29)*M(11))+c(24)*(-M(4)+M(12))) * den(246)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,10)
  Gcoeff = (c(29)*(M(3)-M(11))) * den(246)
  T2sum(1:5,5) = T2sum(1:5,5) + Gcoeff * G1tensor(:,12)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(14)*(-M(3)+M(10))) * den(144)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,40)
  Gcoeff = (c(14)*(M(2)-M(7))+c(9)*(-M(5)+M(9))) * den(144)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,42)
  Gcoeff = (c(14)*(M(2)+M(3)-M(7)-M(10))) * den(144)
  T2sum(1:5,3) = T2sum(1:5,3) + Gcoeff * G1tensor(:,44)
  Gcoeff = (-(c(14)*M(3))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,89)
  Gcoeff = (-(c(14)*M(11))+c(9)*(-M(1)-M(4)+M(5)+M(12)-M(13))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,92)
  Gcoeff = (c(9)*(M(5)-M(9))+c(14)*(M(3)-M(11))) * den(1)
  T3sum(1:15,11) = T3sum(1:15,11) + Gcoeff * G2tensor(:,95)
  Gcoeff = (c(24)*(M(1)-M(9)+M(13))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,90)
  Gcoeff = (c(24)*(M(1)-M(5)+M(13))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,93)
  Gcoeff = (c(24)*(-M(5)+M(9))) * den(1)
  T3sum(1:15,12) = T3sum(1:15,12) + Gcoeff * G2tensor(:,96)
  Gcoeff = (c(24)*(-M(6)-M(7)-M(10)-M(11))+c(29)*(M(5)+M(12))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,4)
  Gcoeff = (c(29)*(M(8)+M(9))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,5)
  Gcoeff = (c(29)*(-M(5)+M(8)+M(9)-M(12))) * den(6)
  T3sum(1:15,1) = T3sum(1:15,1) + Gcoeff * G2tensor(:,6)
  Gcoeff = (c(29)*(M(8)+M(9))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,16) = T3sum(1:15,16) + Gcoeff * G2tensor(:,19)
  Gcoeff = (c(29)*(M(1)+M(4))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,16) = T3sum(1:15,16) + Gcoeff * G2tensor(:,21)
  Gcoeff = (c(29)*(M(1)+M(4)-M(8)-M(9))) * den(6)
  T3sum(1:15,16) = T3sum(1:15,16) + Gcoeff * G2tensor(:,23)
  Gcoeff = (c(24)*(-M(6)-M(7)-M(10)-M(11))+c(29)*(M(5)+M(12))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,25)
  Gcoeff = (c(29)*(M(1)+M(4))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,27)
  Gcoeff = (c(29)*(M(1)+M(4)-M(5)-M(12))) * den(6)
  T3sum(1:15,17) = T3sum(1:15,17) + Gcoeff * G2tensor(:,29)
  Gcoeff = (c(14)*M(9)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(5)
  T3sum(1:15,21) = T3sum(1:15,21) + Gcoeff * G2tensor(:,20)
  Gcoeff = (c(14)*M(4)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(5)
  T3sum(1:15,21) = T3sum(1:15,21) + Gcoeff * G2tensor(:,22)
  Gcoeff = (c(14)*(M(4)-M(9))+c(9)*(M(6)-M(10))) * den(5)
  T3sum(1:15,21) = T3sum(1:15,21) + Gcoeff * G2tensor(:,24)
  Gcoeff = (c(14)*M(12)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(4)
  T3sum(1:15,30) = T3sum(1:15,30) + Gcoeff * G2tensor(:,26)
  Gcoeff = (c(14)*M(1)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(4)
  T3sum(1:15,30) = T3sum(1:15,30) + Gcoeff * G2tensor(:,28)
  Gcoeff = (c(9)*(M(7)-M(11))+c(14)*(M(1)-M(12))) * den(4)
  T3sum(1:15,30) = T3sum(1:15,30) + Gcoeff * G2tensor(:,30)
  Gcoeff = (-(c(14)*M(11))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(2)
  T3sum(1:15,39) = T3sum(1:15,39) + Gcoeff * G2tensor(:,8)
  Gcoeff = (-(c(14)*M(2))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(2)
  T3sum(1:15,39) = T3sum(1:15,39) + Gcoeff * G2tensor(:,10)
  Gcoeff = (c(14)*(-M(2)+M(11))+c(9)*(-M(8)+M(12))) * den(2)
  T3sum(1:15,39) = T3sum(1:15,39) + Gcoeff * G2tensor(:,12)
  Gcoeff = (-(c(29)*M(3))+c(24)*(-M(1)+M(5))) * den(107)
  T2sum(1:5,26) = T2sum(1:5,26) + Gcoeff * G1tensor(:,1)
  Gcoeff = (c(24)*(-M(1)+M(5))-c(29)*M(7)) * den(107)
  T2sum(1:5,26) = T2sum(1:5,26) + Gcoeff * G1tensor(:,3)
  Gcoeff = (c(29)*(M(3)-M(7))) * den(107)
  T2sum(1:5,26) = T2sum(1:5,26) + Gcoeff * G1tensor(:,5)
  Gcoeff = (-(c(29)*M(2))+c(24)*(-M(1)+M(9))) * den(414)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,2)
  Gcoeff = (c(24)*(-M(1)+M(9))-c(29)*M(10)) * den(414)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,4)
  Gcoeff = (c(29)*(M(2)-M(10))) * den(414)
  T2sum(1:5,27) = T2sum(1:5,27) + Gcoeff * G1tensor(:,6)
  Gcoeff = (-(c(14)*M(2))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,80)
  Gcoeff = (-(c(14)*M(10))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,83)
  Gcoeff = (c(14)*(M(2)-M(10))+c(9)*(M(8)-M(12))) * den(2)
  T3sum(1:15,43) = T3sum(1:15,43) + Gcoeff * G2tensor(:,86)
  Gcoeff = (c(24)*(M(4)-M(12)+M(13))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,81)
  Gcoeff = (c(24)*(M(4)-M(8)+M(13))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,84)
  Gcoeff = (c(24)*(-M(8)+M(12))) * den(2)
  T3sum(1:15,44) = T3sum(1:15,44) + Gcoeff * G2tensor(:,87)
  Gcoeff = (-(c(14)*M(6))+c(9)*(-M(1)-M(4)+M(5)+M(12)-M(13))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,98)
  Gcoeff = (-(c(14)*M(10))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,100)
  Gcoeff = (c(14)*(M(6)-M(10))+c(9)*(-M(5)+M(8)+M(9)-M(12))) * den(2)
  T3sum(1:15,45) = T3sum(1:15,45) + Gcoeff * G2tensor(:,102)
  Gcoeff = (c(29)*(M(6)-M(7)-M(10)+M(11))) * den(628)
  T3sum(1:35,6) = T3sum(1:35,6) + Gcoeff * G3tensor(:,95)
  Gcoeff = (c(29)*(-M(2)-M(3)+M(7)+M(10))) * den(145)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,19)
  Gcoeff = (c(29)*(-M(2)-M(3)+M(6)+M(11))) * den(147)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,21)
  Gcoeff = (c(29)*(M(6)-M(7)-M(10)+M(11))) * den(233)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,1)
  Gcoeff = (c(29)*(-M(6)-M(11))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T4sum(1:70,1) = T4sum(1:70,1) + Gcoeff * G4tensor(:,43)
  Gcoeff = (c(29)*(-M(7)-M(10))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T4sum(1:70,4) = T4sum(1:70,4) + Gcoeff * G4tensor(:,46)
  Gcoeff = (c(29)*(-M(2)-M(3))+c(24)*(M(5)+M(8)+M(9)+M(12))+c(26)*(-M(1)-M(4)-M(13))) * den(3)
  T4sum(1:70,7) = T4sum(1:70,7) + Gcoeff * G4tensor(:,13)
  Gcoeff = (c(14)*M(6)-c(9)*M(8)) * den(33)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,31)
  Gcoeff = (c(14)*(-M(2)+M(6))) * den(36)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,29)
  Gcoeff = (c(14)*M(2)-c(9)*M(8)) * den(268)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,33)
  Gcoeff = (-(c(9)*M(4))) * den(26)
  T3sum(1:35,81) = T3sum(1:35,81) + Gcoeff * G3tensor(:,25)
  Gcoeff = (-(c(29)*M(2))+c(24)*(-M(4)+M(8))) * den(26)
  T3sum(1:35,83) = T3sum(1:35,83) + Gcoeff * G3tensor(:,31)
  Gcoeff = (-(c(14)*M(11))+c(9)*M(12)) * den(37)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,34)
  Gcoeff = (c(14)*(M(3)-M(11))) * den(39)
  T3sum(1:35,2) = T3sum(1:35,2) + Gcoeff * G3tensor(:,47)
  Gcoeff = (-(c(14)*M(3))+c(9)*M(12)) * den(248)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,36)
  Gcoeff = (c(9)*M(4)) * den(246)
  T3sum(1:35,87) = T3sum(1:35,87) + Gcoeff * G3tensor(:,44)
  Gcoeff = (-(c(29)*M(3))+c(24)*(-M(4)+M(12))) * den(246)
  T3sum(1:35,89) = T3sum(1:35,89) + Gcoeff * G3tensor(:,49)
  Gcoeff = (c(14)*(M(7)-M(11))+c(9)*(-M(8)+M(12))) * den(508)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,2)
  Gcoeff = (c(14)*M(7)-c(9)*M(8)) * den(510)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,37)
  Gcoeff = (c(9)*M(13)-c(6)*M(14)) * den(29)
  T3sum(1:35,96) = T3sum(1:35,96) + Gcoeff * G3tensor(:,33)
  Gcoeff = (-(c(29)*M(11))+c(24)*(M(12)-M(13))+c(21)*M(14)) * den(29)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,3)
  Gcoeff = (c(14)*(M(6)-M(10))+c(9)*(-M(8)+M(12))) * den(511)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,5)
  Gcoeff = (-(c(14)*M(10))+c(9)*M(12)) * den(513)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,38)
  Gcoeff = (c(9)*M(13)-c(6)*M(14)) * den(20)
  T3sum(1:35,102) = T3sum(1:35,102) + Gcoeff * G3tensor(:,50)
  Gcoeff = (-(c(29)*M(10))+c(24)*(M(12)-M(13))+c(21)*M(14)) * den(20)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,6)
  Gcoeff = (c(29)*(-M(2)+M(7))) * den(517)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,39)
  Gcoeff = (c(29)*(-M(3)+M(10))) * den(518)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,40)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(14)*(-M(3)+M(10))) * den(144)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,20)
  Gcoeff = (c(24)*(M(5)-M(9))) * den(144)
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,35)
  Gcoeff = (-(c(14)*M(3))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(1)
  T4sum(1:70,11) = T4sum(1:70,11) + Gcoeff * G4tensor(:,23)
  Gcoeff = (-(c(14)*M(10))+c(9)*(-M(1)-M(4)+M(5)+M(12)-M(13))) * den(1)
  T4sum(1:70,13) = T4sum(1:70,13) + Gcoeff * G4tensor(:,4)
  Gcoeff = (c(9)*(-M(1)+M(9))-c(6)*M(14)) * den(1)
  T4sum(1:70,22) = T4sum(1:70,22) + Gcoeff * G4tensor(:,19)
  Gcoeff = (c(24)*(M(1)-M(9)+M(13))) * den(1)
  T4sum(1:70,25) = T4sum(1:70,25) + Gcoeff * G4tensor(:,24)
  Gcoeff = (c(9)*(-M(1)+M(5))-c(6)*M(14)) * den(1)
  T4sum(1:70,26) = T4sum(1:70,26) + Gcoeff * G4tensor(:,16)
  Gcoeff = (c(24)*(M(1)+M(4)-M(5))+c(21)*M(14)) * den(1)
  T4sum(1:70,29) = T4sum(1:70,29) + Gcoeff * G4tensor(:,1)
  Gcoeff = (c(29)*(M(1)+M(4)-M(5)-M(12))) * den(161)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,51)
  Gcoeff = (c(29)*(M(1)+M(4)-M(8)-M(9))) * den(163)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,53)
  Gcoeff = (c(29)*(-M(5)+M(8)+M(9)-M(12))) * den(304)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,7)
  Gcoeff = (c(29)*(M(1)+M(4))+c(24)*(-M(6)-M(7)-M(10)-M(11))+c(26)*(M(2)+M(3)+M(14))) * den(6)
  T4sum(1:70,40) = T4sum(1:70,40) + Gcoeff * G4tensor(:,25)
  Gcoeff = (c(14)*(M(1)-M(5))) * den(68)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,57)
  Gcoeff = (-(c(14)*M(5))+c(9)*M(7)) * den(69)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,41)
  Gcoeff = (-(c(14)*M(1))+c(9)*M(7)) * den(337)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,43)
  Gcoeff = (c(29)*M(1)+c(24)*(M(3)-M(7))) * den(60)
  T3sum(1:35,136) = T3sum(1:35,136) + Gcoeff * G3tensor(:,36)
  Gcoeff = (c(9)*M(3)) * den(60)
  T3sum(1:35,138) = T3sum(1:35,138) + Gcoeff * G3tensor(:,59)
  Gcoeff = (-(c(9)*M(11))+c(14)*M(12)) * den(70)
  T2sum(1:15,53) = T2sum(1:15,53) + Gcoeff * G2tensor(:,35)
  Gcoeff = (c(14)*(-M(4)+M(12))) * den(72)
  T3sum(1:35,17) = T3sum(1:35,17) + Gcoeff * G3tensor(:,63)
  Gcoeff = (c(14)*M(4)-c(9)*M(11)) * den(316)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,44)
  Gcoeff = (-(c(9)*M(3))) * den(314)
  T3sum(1:35,142) = T3sum(1:35,142) + Gcoeff * G3tensor(:,45)
  Gcoeff = (c(29)*M(4)+c(24)*(M(3)-M(11))) * den(314)
  T3sum(1:35,144) = T3sum(1:35,144) + Gcoeff * G3tensor(:,65)
  Gcoeff = (c(9)*(M(7)-M(11))+c(14)*(-M(8)+M(12))) * den(520)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,8)
  Gcoeff = (c(9)*M(7)-c(14)*M(8)) * den(522)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,45)
  Gcoeff = (c(6)*M(13)-c(9)*M(14)) * den(62)
  T3sum(1:35,96) = T3sum(1:35,96) + Gcoeff * G3tensor(:,34)
  Gcoeff = (c(29)*M(12)-c(21)*M(13)+c(24)*(-M(11)+M(14))) * den(62)
  T3sum(1:35,100) = T3sum(1:35,100) + Gcoeff * G3tensor(:,4)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(M(7)-M(11))) * den(523)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,9)
  Gcoeff = (c(29)*(M(1)-M(8))) * den(525)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,46)
  Gcoeff = (c(14)*M(9)-c(9)*M(11)) * den(527)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,47)
  Gcoeff = (c(6)*M(13)-c(9)*M(14)) * den(57)
  T3sum(1:35,151) = T3sum(1:35,151) + Gcoeff * G3tensor(:,66)
  Gcoeff = (c(29)*M(9)-c(21)*M(13)+c(24)*(-M(11)+M(14))) * den(57)
  T3sum(1:35,153) = T3sum(1:35,153) + Gcoeff * G3tensor(:,10)
  Gcoeff = (c(29)*(M(4)-M(9))) * den(530)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,48)
  Gcoeff = (c(14)*(M(4)-M(9))+c(9)*(M(6)-M(10))) * den(162)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,54)
  Gcoeff = (c(24)*(-M(6)+M(10))) * den(162)
  T3sum(1:35,161) = T3sum(1:35,161) + Gcoeff * G3tensor(:,38)
  Gcoeff = (c(14)*M(4)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(5)
  T4sum(1:70,44) = T4sum(1:70,44) + Gcoeff * G4tensor(:,28)
  Gcoeff = (c(14)*M(9)+c(9)*(M(2)+M(3)-M(6)-M(11)+M(14))) * den(5)
  T4sum(1:70,46) = T4sum(1:70,46) + Gcoeff * G4tensor(:,5)
  Gcoeff = (c(9)*(M(2)-M(10))+c(6)*M(13)) * den(5)
  T4sum(1:70,55) = T4sum(1:70,55) + Gcoeff * G4tensor(:,20)
  Gcoeff = (c(24)*(-M(2)+M(10)-M(14))) * den(5)
  T4sum(1:70,58) = T4sum(1:70,58) + Gcoeff * G4tensor(:,29)
  Gcoeff = (c(9)*(M(2)-M(6))+c(6)*M(13)) * den(5)
  T4sum(1:70,59) = T4sum(1:70,59) + Gcoeff * G4tensor(:,17)
  Gcoeff = (c(24)*(-M(2)-M(3)+M(6))-c(21)*M(13)) * den(5)
  T4sum(1:70,62) = T4sum(1:70,62) + Gcoeff * G4tensor(:,2)
  Gcoeff = (c(9)*M(6)-c(14)*M(8)) * den(92)
  T2sum(1:15,48) = T2sum(1:15,48) + Gcoeff * G2tensor(:,32)
  Gcoeff = (c(14)*(M(4)-M(8))) * den(95)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,67)
  Gcoeff = (-(c(14)*M(4))+c(9)*M(6)) * den(386)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,49)
  Gcoeff = (c(9)*M(2)) * den(85)
  T3sum(1:35,175) = T3sum(1:35,175) + Gcoeff * G3tensor(:,26)
  Gcoeff = (c(29)*M(4)+c(24)*(M(2)-M(6))) * den(85)
  T3sum(1:35,177) = T3sum(1:35,177) + Gcoeff * G3tensor(:,55)
  Gcoeff = (c(14)*M(9)-c(9)*M(10)) * den(96)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,50)
  Gcoeff = (c(14)*(-M(1)+M(9))) * den(98)
  T3sum(1:35,16) = T3sum(1:35,16) + Gcoeff * G3tensor(:,72)
  Gcoeff = (c(14)*M(1)-c(9)*M(10)) * den(368)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,52)
  Gcoeff = (-(c(9)*M(2))) * den(367)
  T3sum(1:35,181) = T3sum(1:35,181) + Gcoeff * G3tensor(:,69)
  Gcoeff = (c(29)*M(1)+c(24)*(M(2)-M(10))) * den(367)
  T3sum(1:35,183) = T3sum(1:35,183) + Gcoeff * G3tensor(:,56)
  Gcoeff = (c(14)*(-M(5)+M(9))+c(9)*(M(6)-M(10))) * den(532)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,11)
  Gcoeff = (-(c(14)*M(5))+c(9)*M(6)) * den(534)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,53)
  Gcoeff = (-(c(6)*M(13))+c(9)*M(14)) * den(88)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,74)
  Gcoeff = (c(29)*M(5)-c(21)*M(13)+c(24)*(-M(6)+M(14))) * den(88)
  T3sum(1:35,192) = T3sum(1:35,192) + Gcoeff * G3tensor(:,12)
  Gcoeff = (c(9)*(M(6)-M(10))+c(14)*(-M(8)+M(12))) * den(535)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,13)
  Gcoeff = (-(c(9)*M(10))+c(14)*M(12)) * den(537)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,54)
  Gcoeff = (c(6)*M(13)-c(9)*M(14)) * den(80)
  T3sum(1:35,102) = T3sum(1:35,102) + Gcoeff * G3tensor(:,75)
  Gcoeff = (c(29)*M(12)-c(21)*M(13)+c(24)*(-M(10)+M(14))) * den(80)
  T3sum(1:35,104) = T3sum(1:35,104) + Gcoeff * G3tensor(:,14)
  Gcoeff = (c(29)*(M(4)-M(5))) * den(541)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,55)
  Gcoeff = (c(29)*(M(1)-M(12))) * den(542)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,56)
  Gcoeff = (c(9)*(M(7)-M(11))+c(14)*(M(1)-M(12))) * den(160)
  T3sum(1:35,30) = T3sum(1:35,30) + Gcoeff * G3tensor(:,52)
  Gcoeff = (c(24)*(-M(7)+M(11))) * den(160)
  T3sum(1:35,200) = T3sum(1:35,200) + Gcoeff * G3tensor(:,76)
  Gcoeff = (c(14)*M(1)+c(9)*(M(2)+M(3)-M(10)-M(11)+M(14))) * den(4)
  T4sum(1:70,68) = T4sum(1:70,68) + Gcoeff * G4tensor(:,26)
  Gcoeff = (c(14)*M(12)+c(9)*(M(2)+M(3)-M(7)-M(10)+M(14))) * den(4)
  T4sum(1:70,70) = T4sum(1:70,70) + Gcoeff * G4tensor(:,6)
  Gcoeff = (c(9)*(M(3)-M(11))+c(6)*M(13)) * den(4)
  T4sum(1:70,79) = T4sum(1:70,79) + Gcoeff * G4tensor(:,30)
  Gcoeff = (c(24)*(-M(3)+M(11)-M(14))) * den(4)
  T4sum(1:70,82) = T4sum(1:70,82) + Gcoeff * G4tensor(:,27)
  Gcoeff = (c(9)*(M(3)-M(7))+c(6)*M(13)) * den(4)
  T4sum(1:70,83) = T4sum(1:70,83) + Gcoeff * G4tensor(:,31)
  Gcoeff = (c(24)*(-M(2)-M(3)+M(7))-c(21)*M(13)) * den(4)
  T4sum(1:70,86) = T4sum(1:70,86) + Gcoeff * G4tensor(:,7)
  Gcoeff = (-(c(9)*M(9))+c(14)*M(11)) * den(174)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,103)
  Gcoeff = (-(c(9)*M(4))) * den(101)
  T3sum(1:35,203) = T3sum(1:35,203) + Gcoeff * G3tensor(:,101)
  Gcoeff = (c(24)*(-M(4)+M(9))-c(29)*M(11)) * den(101)
  T3sum(1:35,206) = T3sum(1:35,206) + Gcoeff * G3tensor(:,97)
  Gcoeff = (c(9)*M(5)-c(14)*M(6)) * den(212)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,104)
  Gcoeff = (c(9)*M(4)) * den(428)
  T3sum(1:35,207) = T3sum(1:35,207) + Gcoeff * G3tensor(:,102)
  Gcoeff = (c(24)*(-M(4)+M(5))-c(29)*M(6)) * den(428)
  T3sum(1:35,212) = T3sum(1:35,212) + Gcoeff * G3tensor(:,98)
  Gcoeff = (c(14)*(-M(3)+M(7))) * den(115)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,85)
  Gcoeff = (-(c(9)*M(5))+c(14)*M(7)) * den(176)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,105)
  Gcoeff = (-(c(9)*M(5))+c(14)*M(7)) * den(116)
  T2sum(1:15,74) = T2sum(1:15,74) + Gcoeff * G2tensor(:,42)
  Gcoeff = (c(14)*M(3)-c(9)*M(5)) * den(434)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,57)
  Gcoeff = (-(c(29)*M(3))+c(24)*(-M(1)+M(5))) * den(107)
  T3sum(1:35,214) = T3sum(1:35,214) + Gcoeff * G3tensor(:,23)
  Gcoeff = (-(c(9)*M(1))) * den(107)
  T3sum(1:35,215) = T3sum(1:35,215) + Gcoeff * G3tensor(:,103)
  Gcoeff = (-(c(9)*M(1))) * den(107)
  T3sum(1:35,216) = T3sum(1:35,216) + Gcoeff * G3tensor(:,60)
  Gcoeff = (c(24)*(-M(1)+M(5))-c(29)*M(7)) * den(107)
  T3sum(1:35,218) = T3sum(1:35,218) + Gcoeff * G3tensor(:,99)
  Gcoeff = (c(9)*M(9)-c(14)*M(10)) * den(117)
  T2sum(1:15,98) = T2sum(1:15,98) + Gcoeff * G2tensor(:,51)
  Gcoeff = (c(14)*(M(2)-M(10))) * den(119)
  T3sum(1:35,3) = T3sum(1:35,3) + Gcoeff * G3tensor(:,87)
  Gcoeff = (c(9)*M(9)-c(14)*M(10)) * den(214)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,106)
  Gcoeff = (-(c(14)*M(2))+c(9)*M(9)) * den(415)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,58)
  Gcoeff = (c(9)*M(1)) * den(414)
  T3sum(1:35,219) = T3sum(1:35,219) + Gcoeff * G3tensor(:,104)
  Gcoeff = (c(9)*M(1)) * den(414)
  T3sum(1:35,220) = T3sum(1:35,220) + Gcoeff * G3tensor(:,70)
  Gcoeff = (-(c(29)*M(2))+c(24)*(-M(1)+M(9))) * den(414)
  T3sum(1:35,222) = T3sum(1:35,222) + Gcoeff * G3tensor(:,24)
  Gcoeff = (c(24)*(-M(1)+M(9))-c(29)*M(10)) * den(414)
  T3sum(1:35,224) = T3sum(1:35,224) + Gcoeff * G3tensor(:,100)
  Gcoeff = (c(24)*(M(5)-M(9))+c(29)*(-M(7)+M(11))) * den(121)
  T2sum(1:15,104) = T2sum(1:15,104) + Gcoeff * G2tensor(:,107)
  Gcoeff = (c(24)*(-M(5)+M(9))+c(29)*(M(6)-M(10))) * den(216)
  T2sum(1:15,110) = T2sum(1:15,110) + Gcoeff * G2tensor(:,108)
  Gcoeff = (c(14)*(M(6)-M(10))+c(9)*(-M(5)+M(8)+M(9)-M(12))) * den(226)
  T3sum(1:35,45) = T3sum(1:35,45) + Gcoeff * G3tensor(:,96)
  Gcoeff = (c(24)*(-M(8)+M(12))) * den(226)
  T3sum(1:35,227) = T3sum(1:35,227) + Gcoeff * G3tensor(:,105)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(14)*(M(6)-M(10))) * den(544)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,15)
  Gcoeff = (-(c(9)*M(5))+c(14)*M(6)) * den(546)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,59)
  Gcoeff = (-(c(9)*M(13))+c(6)*M(14)) * den(109)
  T3sum(1:35,190) = T3sum(1:35,190) + Gcoeff * G3tensor(:,89)
  Gcoeff = (-(c(29)*M(6))+c(24)*(M(5)-M(13))+c(21)*M(14)) * den(109)
  T3sum(1:35,192) = T3sum(1:35,192) + Gcoeff * G3tensor(:,16)
  Gcoeff = (c(9)*(-M(5)+M(9))+c(14)*(M(7)-M(11))) * den(547)
  T3sum(1:35,1) = T3sum(1:35,1) + Gcoeff * G3tensor(:,17)
  Gcoeff = (c(29)*(-M(3)+M(6))) * den(549)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,60)
  Gcoeff = (c(9)*M(9)-c(14)*M(11)) * den(551)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,61)
  Gcoeff = (c(9)*M(13)-c(6)*M(14)) * den(105)
  T3sum(1:35,151) = T3sum(1:35,151) + Gcoeff * G3tensor(:,90)
  Gcoeff = (-(c(29)*M(11))+c(24)*(M(9)-M(13))+c(21)*M(14)) * den(105)
  T3sum(1:35,153) = T3sum(1:35,153) + Gcoeff * G3tensor(:,18)
  Gcoeff = (c(29)*(-M(2)+M(11))) * den(554)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,62)
  Gcoeff = (c(14)*(-M(2)+M(11))+c(9)*(-M(8)+M(12))) * den(146)
  T3sum(1:35,39) = T3sum(1:35,39) + Gcoeff * G3tensor(:,22)
  Gcoeff = (c(24)*(M(8)-M(12))) * den(146)
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,77)
  Gcoeff = (-(c(14)*M(2))+c(9)*(-M(1)-M(4)+M(9)+M(12)-M(13))) * den(2)
  T4sum(1:70,92) = T4sum(1:70,92) + Gcoeff * G4tensor(:,14)
  Gcoeff = (-(c(14)*M(11))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(2)
  T4sum(1:70,94) = T4sum(1:70,94) + Gcoeff * G4tensor(:,10)
  Gcoeff = (-(c(14)*M(6))+c(9)*(-M(1)-M(4)+M(5)+M(12)-M(13))) * den(2)
  T4sum(1:70,100) = T4sum(1:70,100) + Gcoeff * G4tensor(:,44)
  Gcoeff = (-(c(14)*M(10))+c(9)*(-M(1)-M(4)+M(8)+M(9)-M(13))) * den(2)
  T4sum(1:70,102) = T4sum(1:70,102) + Gcoeff * G4tensor(:,47)
  Gcoeff = (c(9)*(-M(4)+M(12))-c(6)*M(14)) * den(2)
  T4sum(1:70,103) = T4sum(1:70,103) + Gcoeff * G4tensor(:,34)
  Gcoeff = (c(24)*(M(4)-M(12)+M(13))) * den(2)
  T4sum(1:70,106) = T4sum(1:70,106) + Gcoeff * G4tensor(:,15)
  Gcoeff = (c(9)*(-M(4)+M(8))-c(6)*M(14)) * den(2)
  T4sum(1:70,107) = T4sum(1:70,107) + Gcoeff * G4tensor(:,32)
  Gcoeff = (c(24)*(M(1)-M(12)+M(13))) * den(2)
  T4sum(1:70,108) = T4sum(1:70,108) + Gcoeff * G4tensor(:,45)
  Gcoeff = (c(9)*(M(12)-M(13))) * den(2)
  T4sum(1:70,109) = T4sum(1:70,109) + Gcoeff * G4tensor(:,49)
  Gcoeff = (c(24)*(M(1)+M(4)-M(8))+c(21)*M(14)) * den(2)
  T4sum(1:70,110) = T4sum(1:70,110) + Gcoeff * G4tensor(:,8)
  Gcoeff = (c(24)*(M(4)-M(8)+M(13))) * den(2)
  T4sum(1:70,112) = T4sum(1:70,112) + Gcoeff * G4tensor(:,48)
  Gcoeff = (c(9)*(M(8)-M(13))) * den(2)
  T4sum(1:70,113) = T4sum(1:70,113) + Gcoeff * G4tensor(:,50)
  Gcoeff = (-(c(9)*M(1))+c(14)*M(7)) * den(588)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,63)
  Gcoeff = (c(9)*M(1)-c(14)*M(3)) * den(589)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,64)
  Gcoeff = (-(c(29)*M(3))+c(24)*(M(1)-M(5))) * den(114)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,86)
  Gcoeff = (c(9)*M(5)) * den(114)
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,39)
  Gcoeff = (c(9)*M(3)-c(14)*M(5)) * den(591)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,65)
  Gcoeff = (c(14)*M(1)-c(9)*M(3)) * den(592)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,66)
  Gcoeff = (c(29)*M(1)+c(24)*(-M(3)+M(7))) * den(67)
  T3sum(1:35,30) = T3sum(1:35,30) + Gcoeff * G3tensor(:,58)
  Gcoeff = (-(c(9)*M(7))) * den(67)
  T3sum(1:35,200) = T3sum(1:35,200) + Gcoeff * G3tensor(:,78)
  Gcoeff = (c(6)*(-M(1)+M(5))+c(9)*(M(3)-M(7))) * den(59)
  T3sum(1:35,302) = T3sum(1:35,302) + Gcoeff * G3tensor(:,61)
  Gcoeff = (c(13)*M(1)+c(6)*M(5)) * den(59)
  T3sum(1:35,304) = T3sum(1:35,304) + Gcoeff * G3tensor(:,37)
  Gcoeff = (c(9)*(-M(1)+M(5))+c(6)*(M(3)-M(7))) * den(59)
  T3sum(1:35,307) = T3sum(1:35,307) + Gcoeff * G3tensor(:,62)
  Gcoeff = (-(c(13)*M(3))-c(6)*M(7)) * den(59)
  T3sum(1:35,309) = T3sum(1:35,309) + Gcoeff * G3tensor(:,79)
  Gcoeff = (c(9)*M(2)-c(14)*M(8)) * den(596)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,67)
  Gcoeff = (-(c(9)*M(4))+c(14)*M(6)) * den(597)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,68)
  Gcoeff = (-(c(9)*M(2))+c(14)*M(4)) * den(598)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,69)
  Gcoeff = (c(29)*M(4)+c(24)*(-M(2)+M(6))) * den(94)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,68)
  Gcoeff = (-(c(9)*M(6))) * den(94)
  T3sum(1:35,161) = T3sum(1:35,161) + Gcoeff * G3tensor(:,40)
  Gcoeff = (-(c(14)*M(2))+c(9)*M(4)) * den(600)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,70)
  Gcoeff = (-(c(29)*M(2))+c(24)*(M(4)-M(8))) * den(35)
  T3sum(1:35,39) = T3sum(1:35,39) + Gcoeff * G3tensor(:,30)
  Gcoeff = (c(9)*M(8)) * den(35)
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,80)
  Gcoeff = (c(6)*(M(2)-M(6))+c(9)*(-M(4)+M(8))) * den(24)
  T3sum(1:35,318) = T3sum(1:35,318) + Gcoeff * G3tensor(:,27)
  Gcoeff = (-(c(13)*M(2))-c(6)*M(6)) * den(24)
  T3sum(1:35,320) = T3sum(1:35,320) + Gcoeff * G3tensor(:,32)
  Gcoeff = (c(9)*(M(2)-M(6))+c(6)*(-M(4)+M(8))) * den(24)
  T3sum(1:35,323) = T3sum(1:35,323) + Gcoeff * G3tensor(:,28)
  Gcoeff = (c(13)*M(4)+c(6)*M(8)) * den(24)
  T3sum(1:35,325) = T3sum(1:35,325) + Gcoeff * G3tensor(:,81)
  Gcoeff = (-(c(9)*M(1))+c(14)*M(2)) * den(604)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,71)
  Gcoeff = (-(c(14)*M(1))+c(9)*M(2)) * den(605)
  T2sum(1:15,51) = T2sum(1:15,51) + Gcoeff * G2tensor(:,72)
  Gcoeff = (c(9)*M(1)-c(14)*M(10)) * den(606)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,73)
  Gcoeff = (c(24)*(M(1)-M(9))-c(29)*M(10)) * den(118)
  T3sum(1:35,7) = T3sum(1:35,7) + Gcoeff * G3tensor(:,88)
  Gcoeff = (c(9)*M(9)) * den(118)
  T3sum(1:35,112) = T3sum(1:35,112) + Gcoeff * G3tensor(:,41)
  Gcoeff = (-(c(9)*M(2))+c(14)*M(9)) * den(609)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,74)
  Gcoeff = (c(29)*M(9)+c(24)*(-M(2)+M(10))) * den(97)
  T3sum(1:35,21) = T3sum(1:35,21) + Gcoeff * G3tensor(:,73)
  Gcoeff = (-(c(9)*M(10))) * den(97)
  T3sum(1:35,161) = T3sum(1:35,161) + Gcoeff * G3tensor(:,42)
  Gcoeff = (c(6)*M(1)+c(13)*M(9)) * den(77)
  T3sum(1:35,337) = T3sum(1:35,337) + Gcoeff * G3tensor(:,71)
  Gcoeff = (c(6)*(M(1)-M(9))+c(9)*(M(2)-M(10))) * den(77)
  T3sum(1:35,338) = T3sum(1:35,338) + Gcoeff * G3tensor(:,91)
  Gcoeff = (c(9)*(M(1)-M(9))+c(6)*(M(2)-M(10))) * den(77)
  T3sum(1:35,343) = T3sum(1:35,343) + Gcoeff * G3tensor(:,92)
  Gcoeff = (-(c(13)*M(2))-c(6)*M(10)) * den(77)
  T3sum(1:35,345) = T3sum(1:35,345) + Gcoeff * G3tensor(:,43)
  Gcoeff = (c(9)*M(3)-c(14)*M(4)) * den(612)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,75)
  Gcoeff = (c(14)*M(3)-c(9)*M(4)) * den(613)
  T2sum(1:15,96) = T2sum(1:15,96) + Gcoeff * G2tensor(:,76)
  Gcoeff = (-(c(9)*M(3))+c(14)*M(12)) * den(614)
  T2sum(1:15,56) = T2sum(1:15,56) + Gcoeff * G2tensor(:,77)
  Gcoeff = (c(24)*(-M(3)+M(11))+c(29)*M(12)) * den(71)
  T3sum(1:35,30) = T3sum(1:35,30) + Gcoeff * G3tensor(:,64)
  Gcoeff = (-(c(9)*M(11))) * den(71)
  T3sum(1:35,200) = T3sum(1:35,200) + Gcoeff * G3tensor(:,82)
  Gcoeff = (c(9)*M(4)-c(14)*M(11)) * den(617)
  T2sum(1:15,78) = T2sum(1:15,78) + Gcoeff * G2tensor(:,78)
  Gcoeff = (-(c(29)*M(11))+c(24)*(M(4)-M(12))) * den(38)
  T3sum(1:35,39) = T3sum(1:35,39) + Gcoeff * G3tensor(:,48)
  Gcoeff = (c(9)*M(12)) * den(38)
  T3sum(1:35,233) = T3sum(1:35,233) + Gcoeff * G3tensor(:,83)
  Gcoeff = (-(c(6)*M(3))-c(13)*M(11)) * den(16)
  T3sum(1:35,353) = T3sum(1:35,353) + Gcoeff * G3tensor(:,46)
  Gcoeff = (c(6)*(-M(3)+M(11))+c(9)*(-M(4)+M(12))) * den(16)
  T3sum(1:35,354) = T3sum(1:35,354) + Gcoeff * G3tensor(:,93)
  Gcoeff = (c(9)*(-M(3)+M(11))+c(6)*(-M(4)+M(12))) * den(16)
  T3sum(1:35,359) = T3sum(1:35,359) + Gcoeff * G3tensor(:,94)
  Gcoeff = (c(13)*M(4)+c(6)*M(12)) * den(16)
  T3sum(1:35,361) = T3sum(1:35,361) + Gcoeff * G3tensor(:,84)
  Gcoeff = (c(21)*(-M(2)-M(3)+M(6))-c(28)*M(11)-c(24)*M(13))
  T4sum(1:70,152) = T4sum(1:70,152) + Gcoeff * G4tensor(:,3)
  Gcoeff = (c(6)*(M(2)-M(6))+c(9)*M(13))
  T4sum(1:70,153) = T4sum(1:70,153) + Gcoeff * G4tensor(:,18)
  Gcoeff = (c(24)*(M(1)+M(4)-M(9)-M(12)))
  T4sum(1:70,155) = T4sum(1:70,155) + Gcoeff * G4tensor(:,37)
  Gcoeff = (c(24)*(M(1)+M(4)-M(8)-M(9))+c(21)*(-M(2)-M(3)+M(6)+M(11)))
  T4sum(1:70,156) = T4sum(1:70,156) + Gcoeff * G4tensor(:,11)
  Gcoeff = (-(c(29)*M(2))-c(24)*M(13))
  T4sum(1:70,158) = T4sum(1:70,158) + Gcoeff * G4tensor(:,21)
  Gcoeff = (c(9)*(M(1)-M(9))+c(6)*(-M(3)+M(11)))
  T4sum(1:70,159) = T4sum(1:70,159) + Gcoeff * G4tensor(:,41)
  Gcoeff = (c(21)*(M(1)+M(4)-M(8))+c(28)*M(9)+c(24)*M(14))
  T4sum(1:70,170) = T4sum(1:70,170) + Gcoeff * G4tensor(:,9)
  Gcoeff = (c(24)*(-M(2)-M(3)+M(10)+M(11)))
  T4sum(1:70,171) = T4sum(1:70,171) + Gcoeff * G4tensor(:,39)
  Gcoeff = (c(21)*(M(1)+M(4)-M(8)-M(9))+c(24)*(-M(2)-M(3)+M(6)+M(11)))
  T4sum(1:70,172) = T4sum(1:70,172) + Gcoeff * G4tensor(:,12)
  Gcoeff = (c(29)*M(4)+c(24)*M(14))
  T4sum(1:70,174) = T4sum(1:70,174) + Gcoeff * G4tensor(:,35)
  Gcoeff = (c(6)*(-M(4)+M(8))-c(9)*M(14))
  T4sum(1:70,175) = T4sum(1:70,175) + Gcoeff * G4tensor(:,33)
  Gcoeff = (c(6)*(M(1)-M(9))+c(9)*(-M(3)+M(11)))
  T4sum(1:70,177) = T4sum(1:70,177) + Gcoeff * G4tensor(:,42)
  Gcoeff = (c(6)*(-M(4)+M(12))-c(9)*M(14))
  T4sum(1:70,188) = T4sum(1:70,188) + Gcoeff * G4tensor(:,36)
  Gcoeff = (c(6)*(M(2)-M(10))+c(9)*M(13))
  T4sum(1:70,190) = T4sum(1:70,190) + Gcoeff * G4tensor(:,22)
  Gcoeff = (c(9)*(M(2)-M(10))+c(6)*(-M(4)+M(12)))
  T4sum(1:70,191) = T4sum(1:70,191) + Gcoeff * G4tensor(:,40)
  Gcoeff = (c(6)*(M(2)-M(10))+c(9)*(-M(4)+M(12)))
  T4sum(1:70,193) = T4sum(1:70,193) + Gcoeff * G4tensor(:,38)
  Gcoeff = (c(18)*(-M(2)-M(3))+c(16)*(M(5)+M(8)+M(9)+M(12))+c(17)*(-M(1)-M(4)-M(13))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,1)
  Gcoeff = (c(18)*(-M(7)-M(10))+c(16)*(M(5)+M(8)+M(9)+M(12))+c(17)*(-M(1)-M(4)-M(13))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,2)
  Gcoeff = (c(18)*(M(2)+M(3)-M(7)-M(10))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,3)
  Gcoeff = (c(18)*(-M(7)-M(10))+c(16)*(M(5)+M(8)+M(9)+M(12))+c(17)*(-M(1)-M(4)-M(13))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,4)
  Gcoeff = (c(18)*(-M(2)-M(3))+c(16)*(M(5)+M(8)+M(9)+M(12))+c(17)*(-M(1)-M(4)-M(13))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,5)
  Gcoeff = (c(18)*(-M(2)-M(3)+M(7)+M(10))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,6)
  Gcoeff = (c(18)*(M(2)+M(3)-M(7)-M(10))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,7)
  Gcoeff = (c(18)*(-M(2)-M(3)+M(7)+M(10))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,8)
  Gcoeff = (c(19)*(-M(2)-M(3)+M(7)+M(10))) * den(3)
  T2sum(1:1,179) = T2sum(1:1,179) + Gcoeff * G0tensor(:,9)
  Gcoeff = (c(18)*(-M(6)+M(7)+M(10)-M(11))) * den(643)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,29)
  Gcoeff = (c(18)*(M(6)-M(7)-M(10)+M(11))) * den(643)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,31)
  Gcoeff = (c(19)*(M(6)-M(7)-M(10)+M(11))) * den(643)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,33)
  Gcoeff = (c(18)*(-M(2)-M(3)+M(6)+M(11))) * den(11)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,35)
  Gcoeff = (c(18)*(M(2)+M(3)-M(6)-M(11))) * den(11)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,37)
  Gcoeff = (c(19)*(M(2)+M(3)-M(6)-M(11))) * den(11)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,39)
  Gcoeff = (c(18)*(M(2)+M(3)-M(7)-M(10))) * den(14)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,15)
  Gcoeff = (c(18)*(-M(2)-M(3)+M(7)+M(10))) * den(14)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,20)
  Gcoeff = (c(19)*(-M(2)-M(3)+M(7)+M(10))) * den(14)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,25)
  Gcoeff = (c(18)*(-M(2)-M(3)+M(7)+M(10))) * den(145)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,41)
  Gcoeff = (c(18)*(M(2)+M(3)-M(7)-M(10))) * den(145)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,43)
  Gcoeff = (c(19)*(M(2)+M(3)-M(7)-M(10))) * den(145)
  T2sum(1:5,183) = T2sum(1:5,183) + Gcoeff * G1tensor(:,45)
  Gcoeff = (c(3)*(M(3)-M(10))) * den(23)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,16)
  Gcoeff = (c(3)*(-M(3)+M(10))) * den(23)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,21)
  Gcoeff = (c(4)*(-M(3)+M(10))) * den(23)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,26)
  Gcoeff = (c(3)*(-M(2)+M(7))) * den(32)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,17)
  Gcoeff = (c(3)*(M(2)-M(7))) * den(32)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,22)
  Gcoeff = (c(4)*(M(2)-M(7))) * den(32)
  T2sum(1:5,179) = T2sum(1:5,179) + Gcoeff * G1tensor(:,27)

#ifdef LOOPSQUARED
#ifndef PRECISION_dp
  call gtdealloc()
#endif
#endif

end subroutine vamp_1

#ifdef LOOPSQUARED
subroutine gtdealloc()
  implicit none

end subroutine gtdealloc
#endif

end module ol_vamp_1_pptttt_tttxtxgg_1_/**/REALKIND
