
module ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(276,12), K2(12,14), KL(12,14)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(  1,:) = [  144,   48,   48,   18,    0,   -6,   48,    0,    0,   48,   -6,    0]
  K1(  2,:) = [   48,  144,   18,   48,   -6,    0,    0,   48,   48,    0,    0,   -6]
  K1(  3,:) = [   48,   18,  144,   48,   48,    0,    0,   -6,   -6,    0,    0,   48]
  K1(  4,:) = [   18,   48,   48,  144,    0,   48,   -6,    0,    0,   -6,   48,    0]
  K1(  5,:) = [    0,   -6,   48,    0,  144,   48,   48,   18,  -18,   -6,   -6,   18]
  K1(  6,:) = [   -6,    0,    0,   48,   48,  144,   18,   48,   -6,  -18,   18,   -6]
  K1(  7,:) = [   48,    0,    0,   -6,   48,   18,  144,   48,   -6,   18,  -18,   -6]
  K1(  8,:) = [    0,   48,   -6,    0,   18,   48,   48,  144,   18,   -6,   -6,  -18]
  K1(  9,:) = [    0,   48,   -6,    0,  -18,   -6,   -6,   18,  144,   48,   48,   18]
  K1( 10,:) = [   48,    0,    0,   -6,   -6,  -18,   18,   -6,   48,  144,   18,   48]
  K1( 11,:) = [   -6,    0,    0,   48,   -6,   18,  -18,   -6,   48,   18,  144,   48]
  K1( 12,:) = [    0,   -6,   48,    0,   18,   -6,   -6,  -18,   18,   48,   48,  144]
  K1( 13,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 14,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 15,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 16,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 17,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 18,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 19,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 20,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 21,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 22,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 23,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 24,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 25,:) = [    0,   64,    1,   21,   -3,    1,   -8,   24,   24,   -8,    1,   -3]
  K1( 26,:) = [   64,    0,   21,    1,    1,   -3,   24,   -8,   -8,   24,   -3,    1]
  K1( 27,:) = [    1,   21,    0,   64,   -8,   24,   -3,    1,    1,   -3,   24,   -8]
  K1( 28,:) = [   21,    1,   64,    0,   24,   -8,    1,   -3,   -3,    1,   -8,   24]
  K1( 29,:) = [   -3,    1,   -8,   24,    0,   64,    1,   21,    0,   -8,   10,   -6]
  K1( 30,:) = [    1,   -3,   24,   -8,   64,    0,   21,    1,   -8,    0,   -6,   10]
  K1( 31,:) = [   -8,   24,   -3,    1,    1,   21,    0,   64,   10,   -6,    0,   -8]
  K1( 32,:) = [   24,   -8,    1,   -3,   21,    1,   64,    0,   -6,   10,   -8,    0]
  K1( 33,:) = [   24,   -8,    1,   -3,    0,   -8,   10,   -6,    0,   64,    1,   21]
  K1( 34,:) = [   -8,   24,   -3,    1,   -8,    0,   -6,   10,   64,    0,   21,    1]
  K1( 35,:) = [    1,   -3,   24,   -8,   10,   -6,    0,   -8,    1,   21,    0,   64]
  K1( 36,:) = [   -3,    1,   -8,   24,   -6,   10,   -8,    0,   21,    1,   64,    0]
  K1( 37,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 38,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 39,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 40,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 41,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 42,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 43,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 44,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 45,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 46,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 47,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 48,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 49,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 50,:) = [    8,    0,    6,    8,  -10,  -24,  -24,  -64,   -1,    3,    3,    8]
  K1( 51,:) = [    8,    6,    0,    8,   -1,    3,    3,    8,  -10,  -24,  -24,  -64]
  K1( 52,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1( 53,:) = [    0,  -10,   -1,    0,   -3,   -1,   -1,  -24,  -30,  -10,  -10,  -24]
  K1( 54,:) = [   -1,  -24,    3,    8,   -1,    0,  -21,  -64,  -10,    0,    6,    8]
  K1( 55,:) = [    8,  -24,    3,   -1,   -1,  -21,    0,  -64,  -10,    6,    0,    8]
  K1( 56,:) = [    0,  -64,    8,    0,  -24,  -64,  -64, -192,  -24,    8,    8,   24]
  K1( 57,:) = [    0,   -1,  -10,    0,  -30,  -10,  -10,  -24,   -3,   -1,   -1,  -24]
  K1( 58,:) = [    8,    3,  -24,   -1,  -10,    0,    6,    8,   -1,    0,  -21,  -64]
  K1( 59,:) = [   -1,    3,  -24,    8,  -10,    6,    0,    8,   -1,  -21,    0,  -64]
  K1( 60,:) = [    0,    8,  -64,    0,  -24,    8,    8,   24,  -24,  -64,  -64, -192]
  K1( 61,:) = [    0,    8,    8,    6,  -24,  -10,  -64,  -24,    3,   -1,    8,    3]
  K1( 62,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 63,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 64,:) = [    6,    8,    8,    0,    3,   -1,    8,    3,  -24,  -10,  -64,  -24]
  K1( 65,:) = [  -24,   -1,    8,    3,    0,   -1,  -64,  -21,    0,  -10,    8,    6]
  K1( 66,:) = [  -10,    0,    0,   -1,   -1,   -3,  -24,   -1,  -10,  -30,  -24,  -10]
  K1( 67,:) = [  -64,    0,    0,    8,  -64,  -24, -192,  -64,    8,  -24,   24,    8]
  K1( 68,:) = [  -24,    8,   -1,    3,  -21,   -1,  -64,    0,    6,  -10,    8,    0]
  K1( 69,:) = [    3,    8,   -1,  -24,    0,  -10,    8,    6,    0,   -1,  -64,  -21]
  K1( 70,:) = [   -1,    0,    0,  -10,  -10,  -30,  -24,  -10,   -1,   -3,  -24,   -1]
  K1( 71,:) = [    8,    0,    0,  -64,    8,  -24,   24,    8,  -64,  -24, -192,  -64]
  K1( 72,:) = [    3,   -1,    8,  -24,    6,  -10,    8,    0,  -21,   -1,  -64,    0]
  K1( 73,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1( 74,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1( 75,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1( 76,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1( 77,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1( 78,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1( 79,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1( 80,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1( 81,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1( 82,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1( 83,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1( 84,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1( 85,:) = [    0,    8,    8,    6,    3,    8,   -1,    3,  -24,  -64,  -10,  -24]
  K1( 86,:) = [    8,   24,    3,    8,   -1,    0,    0,    8,    8,    0,    0,   -1]
  K1( 87,:) = [    8,    3,   24,    8,    8,    0,    0,   -1,   -1,    0,    0,    8]
  K1( 88,:) = [    6,    8,    8,    0,  -24,  -64,  -10,  -24,    3,    8,   -1,    3]
  K1( 89,:) = [    3,   -1,    8,  -24,    0,  -64,   -1,  -21,    0,    8,  -10,    6]
  K1( 90,:) = [    8,    0,    0,  -64,  -64, -192,  -24,  -64,    8,   24,  -24,    8]
  K1( 91,:) = [   -1,    0,    0,  -10,   -1,  -24,   -3,   -1,  -10,  -24,  -30,  -10]
  K1( 92,:) = [    3,    8,   -1,  -24,  -21,  -64,   -1,    0,    6,    8,  -10,    0]
  K1( 93,:) = [  -24,    8,   -1,    3,    0,    8,  -10,    6,    0,  -64,   -1,  -21]
  K1( 94,:) = [  -64,    0,    0,    8,    8,   24,  -24,    8,  -64, -192,  -24,  -64]
  K1( 95,:) = [  -10,    0,    0,   -1,  -10,  -24,  -30,  -10,   -1,  -24,   -3,   -1]
  K1( 96,:) = [  -24,   -1,    8,    3,    6,    8,  -10,    0,  -21,  -64,   -1,    0]
  K1( 97,:) = [   24,    8,    8,    3,    0,   -1,    8,    0,    0,    8,   -1,    0]
  K1( 98,:) = [    8,    0,    6,    8,    8,    3,    3,   -1,  -64,  -24,  -24,  -10]
  K1( 99,:) = [    8,    6,    0,    8,  -64,  -24,  -24,  -10,    8,    3,    3,   -1]
  K1(100,:) = [    3,    8,    8,   24,    0,    8,   -1,    0,    0,   -1,    8,    0]
  K1(101,:) = [    0,    8,  -64,    0, -192,  -64,  -64,  -24,   24,    8,    8,  -24]
  K1(102,:) = [   -1,    3,  -24,    8,  -64,    0,  -21,   -1,    8,    0,    6,  -10]
  K1(103,:) = [    8,    3,  -24,   -1,  -64,  -21,    0,   -1,    8,    6,    0,  -10]
  K1(104,:) = [    0,   -1,  -10,    0,  -24,   -1,   -1,   -3,  -24,  -10,  -10,  -30]
  K1(105,:) = [    0,  -64,    8,    0,   24,    8,    8,  -24, -192,  -64,  -64,  -24]
  K1(106,:) = [    8,  -24,    3,   -1,    8,    0,    6,  -10,  -64,    0,  -21,   -1]
  K1(107,:) = [   -1,  -24,    3,    8,    8,    6,    0,  -10,  -64,  -21,    0,   -1]
  K1(108,:) = [    0,  -10,   -1,    0,  -24,  -10,  -10,  -30,  -24,   -1,   -1,   -3]
  K1(109,:) = [    0,    1,   64,   21,   24,    1,   -8,   -3,   -3,   -8,    1,   24]
  K1(110,:) = [    1,    0,   21,   64,    1,   24,   -3,   -8,   -8,   -3,   24,    1]
  K1(111,:) = [   64,   21,    0,    1,   -8,   -3,   24,    1,    1,   24,   -3,   -8]
  K1(112,:) = [   21,   64,    1,    0,   -3,   -8,    1,   24,   24,    1,   -8,   -3]
  K1(113,:) = [   24,    1,   -8,   -3,    0,    1,   64,   21,    0,   10,   -8,   -6]
  K1(114,:) = [    1,   24,   -3,   -8,    1,    0,   21,   64,   10,    0,   -6,   -8]
  K1(115,:) = [   -8,   -3,   24,    1,   64,   21,    0,    1,   -8,   -6,    0,   10]
  K1(116,:) = [   -3,   -8,    1,   24,   21,   64,    1,    0,   -6,   -8,   10,    0]
  K1(117,:) = [   -3,   -8,    1,   24,    0,   10,   -8,   -6,    0,    1,   64,   21]
  K1(118,:) = [   -8,   -3,   24,    1,   10,    0,   -6,   -8,    1,    0,   21,   64]
  K1(119,:) = [    1,   24,   -3,   -8,   -8,   -6,    0,   10,   64,   21,    0,    1]
  K1(120,:) = [   24,    1,   -8,   -3,   -6,   -8,   10,    0,   21,   64,    1,    0]
  K1(121,:) = [  192,   64,   64,   24,    0,   -8,   64,    0,    0,   64,   -8,    0]
  K1(122,:) = [   64,  192,   24,   64,   -8,    0,    0,   64,   64,    0,    0,   -8]
  K1(123,:) = [   64,   24,  192,   64,   64,    0,    0,   -8,   -8,    0,    0,   64]
  K1(124,:) = [   24,   64,   64,  192,    0,   64,   -8,    0,    0,   -8,   64,    0]
  K1(125,:) = [    0,   -8,   64,    0,  192,   64,   64,   24,  -24,   -8,   -8,   24]
  K1(126,:) = [   -8,    0,    0,   64,   64,  192,   24,   64,   -8,  -24,   24,   -8]
  K1(127,:) = [   64,    0,    0,   -8,   64,   24,  192,   64,   -8,   24,  -24,   -8]
  K1(128,:) = [    0,   64,   -8,    0,   24,   64,   64,  192,   24,   -8,   -8,  -24]
  K1(129,:) = [    0,   64,   -8,    0,  -24,   -8,   -8,   24,  192,   64,   64,   24]
  K1(130,:) = [   64,    0,    0,   -8,   -8,  -24,   24,   -8,   64,  192,   24,   64]
  K1(131,:) = [   -8,    0,    0,   64,   -8,   24,  -24,   -8,   64,   24,  192,   64]
  K1(132,:) = [    0,   -8,   64,    0,   24,   -8,   -8,  -24,   24,   64,   64,  192]
  K1(133,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(134,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(135,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(136,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(137,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(138,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(139,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(140,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(141,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(142,:) = [   72,    0,   27,    9,    9,    0,   27,   -9,  -72,    0,  -27,   -9]
  K1(143,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(144,:) = [   27,    9,   72,    0,   27,   -9,    9,    0,  -27,   -9,  -72,    0]
  K1(145,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(146,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(147,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(148,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(149,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(150,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(151,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(152,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(153,:) = [    0,   72,    9,   27,    0,    9,   -9,   27,    0,  -72,   -9,  -27]
  K1(154,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(155,:) = [    9,   27,    0,   72,   -9,   27,    0,    9,   -9,  -27,    0,  -72]
  K1(156,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(157,:) = [    0,   -9,  -72,  -27,    0,    9,   72,   27,    0,    9,   -9,  -27]
  K1(158,:) = [   -9,    0,  -27,  -72,    9,    0,   27,   72,    9,    0,  -27,   -9]
  K1(159,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(160,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(161,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(162,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(163,:) = [   72,   27,    0,    9,  -72,  -27,    0,   -9,    9,   27,    0,   -9]
  K1(164,:) = [   27,   72,    9,    0,  -27,  -72,   -9,    0,   27,    9,   -9,    0]
  K1(165,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(166,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(167,:) = [   -9,  -27,    0,  -72,    9,  -27,    0,   -9,    9,   27,    0,   72]
  K1(168,:) = [  -27,   -9,  -72,    0,  -27,    9,   -9,    0,   27,    9,   72,    0]
  K1(169,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(170,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(171,:) = [  -72,  -27,    0,   -9,   72,   27,    0,    9,   -9,  -27,    0,    9]
  K1(172,:) = [  -27,  -72,   -9,    0,   27,   72,    9,    0,  -27,   -9,    9,    0]
  K1(173,:) = [    0,    9,   72,   27,    0,   -9,  -72,  -27,    0,   -9,    9,   27]
  K1(174,:) = [    9,    0,   27,   72,   -9,    0,  -27,  -72,   -9,    0,   27,    9]
  K1(175,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(176,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(177,:) = [    0,  -72,   -9,  -27,    0,   -9,    9,  -27,    0,   72,    9,   27]
  K1(178,:) = [  -72,    0,  -27,   -9,   -9,    0,  -27,    9,   72,    0,   27,    9]
  K1(179,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(180,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(181,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(182,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(183,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(184,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(185,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(186,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(187,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(188,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(189,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(190,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(191,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(192,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(193,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(194,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(195,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(196,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(197,:) = [    0,    9,  -72,    0, -216,  -72,  -72,  -27,   27,    9,    9,  -27]
  K1(198,:) = [    9,   27,    0,   72,  -72,    0,  -27,   -9,    9,    0,   27,   -9]
  K1(199,:) = [  -72,    0,    0,    9,  -72,  -27, -216,  -72,    9,  -27,   27,    9]
  K1(200,:) = [    0,   72,    9,   27,  -27,   -9,  -72,    0,   27,   -9,    9,    0]
  K1(201,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(202,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(203,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(204,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(205,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(206,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(207,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(208,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(209,:) = [   27,    9,   72,    0,    0,  -72,   -9,  -27,    0,    9,   -9,   27]
  K1(210,:) = [    9,    0,    0,  -72,  -72, -216,  -27,  -72,    9,   27,  -27,    9]
  K1(211,:) = [   72,    0,   27,    9,   -9,  -27,    0,  -72,   -9,   27,    0,    9]
  K1(212,:) = [    0,  -72,    9,    0,  -27,  -72,  -72, -216,  -27,    9,    9,   27]
  K1(213,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(214,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(215,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(216,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(217,:) = [ -216,  -72,  -72,  -27,    0,    9,  -72,    0,    0,  -72,    9,    0]
  K1(218,:) = [  -72, -216,  -27,  -72,    9,    0,    0,  -72,  -72,    0,    0,    9]
  K1(219,:) = [  -72,  -27,    0,   -9,    9,    0,  -27,   -9,    9,    0,   27,   72]
  K1(220,:) = [  -27,  -72,   -9,    0,    0,    9,   -9,  -27,    0,    9,   72,   27]
  K1(221,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(222,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(223,:) = [  -72,    0,  -27,   -9,    9,   27,    0,   72,    9,  -27,    0,   -9]
  K1(224,:) = [    0,  -72,   -9,  -27,   27,    9,   72,    0,  -27,    9,   -9,    0]
  K1(225,:) = [    0,  -72,    9,    0,   27,    9,    9,  -27, -216,  -72,  -72,  -27]
  K1(226,:) = [  -72,    0,    0,    9,    9,   27,  -27,    9,  -72, -216,  -27,  -72]
  K1(227,:) = [    9,    0,   27,   72,    9,   27,    0,   -9,  -72,  -27,    0,   -9]
  K1(228,:) = [    0,    9,   72,   27,   27,    9,   -9,    0,  -27,  -72,   -9,    0]
  K1(229,:) = [    0,   -9,  -72,  -27,  -27,   -9,    9,    0,   27,   72,    9,    0]
  K1(230,:) = [   -9,    0,  -27,  -72,   -9,  -27,    0,    9,   72,   27,    0,    9]
  K1(231,:) = [  -72,  -27, -216,  -72,  -72,    0,    0,    9,    9,    0,    0,  -72]
  K1(232,:) = [  -27,  -72,  -72, -216,    0,  -72,    9,    0,    0,    9,  -72,    0]
  K1(233,:) = [  -27,   -9,  -72,    0,    0,   72,    9,   27,    0,   -9,    9,  -27]
  K1(234,:) = [   -9,  -27,    0,  -72,   72,    0,   27,    9,   -9,    0,  -27,    9]
  K1(235,:) = [    9,    0,    0,    9,    9,   27,   27,    9,    9,   27,   27,    9]
  K1(236,:) = [    0,    9,    9,    0,   27,    9,    9,   27,   27,    9,    9,   27]
  K1(237,:) = [   27,   72,    9,    0,    0,   -9,    9,   27,    0,   -9,  -72,  -27]
  K1(238,:) = [   72,   27,    0,    9,   -9,    0,   27,    9,   -9,    0,  -27,  -72]
  K1(239,:) = [    9,    0,    0,  -72,    9,  -27,   27,    9,  -72,  -27, -216,  -72]
  K1(240,:) = [    0,    9,  -72,    0,  -27,    9,    9,   27,  -27,  -72,  -72, -216]
  K1(241,:) = [    0,   81,   81,   54,    0,    0,  -81,    0,    0,  -81,    0,    0]
  K1(242,:) = [   81,    0,   54,   81,    0,    0,    0,  -81,  -81,    0,    0,    0]
  K1(243,:) = [   81,   54,    0,   81,  -81,    0,    0,    0,    0,    0,    0,  -81]
  K1(244,:) = [   54,   81,   81,    0,    0,  -81,    0,    0,    0,    0,  -81,    0]
  K1(245,:) = [    0,    0,  -81,    0, -243,  -81,  -81,  -54,    0,    0,    0,  -54]
  K1(246,:) = [    0,    0,    0,  -81,  -81, -243,  -54,  -81,    0,    0,  -54,    0]
  K1(247,:) = [  -81,    0,    0,    0,  -81,  -54, -243,  -81,    0,  -54,    0,    0]
  K1(248,:) = [    0,  -81,    0,    0,  -54,  -81,  -81, -243,  -54,    0,    0,    0]
  K1(249,:) = [    0,  -81,    0,    0,    0,    0,    0,  -54, -243,  -81,  -81,  -54]
  K1(250,:) = [  -81,    0,    0,    0,    0,    0,  -54,    0,  -81, -243,  -54,  -81]
  K1(251,:) = [    0,    0,    0,  -81,    0,  -54,    0,    0,  -81,  -54, -243,  -81]
  K1(252,:) = [    0,    0,  -81,    0,  -54,    0,    0,    0,  -54,  -81,  -81, -243]
  K1(253,:) = [  432,  144,  144,   54,    0,  -18,  144,    0,    0,  144,  -18,    0]
  K1(254,:) = [  144,  432,   54,  144,  -18,    0,    0,  144,  144,    0,    0,  -18]
  K1(255,:) = [  144,   54,  432,  144,  144,    0,    0,  -18,  -18,    0,    0,  144]
  K1(256,:) = [   54,  144,  144,  432,    0,  144,  -18,    0,    0,  -18,  144,    0]
  K1(257,:) = [    0,  -18,  144,    0,  432,  144,  144,   54,  -54,  -18,  -18,   54]
  K1(258,:) = [  -18,    0,    0,  144,  144,  432,   54,  144,  -18,  -54,   54,  -18]
  K1(259,:) = [  144,    0,    0,  -18,  144,   54,  432,  144,  -18,   54,  -54,  -18]
  K1(260,:) = [    0,  144,  -18,    0,   54,  144,  144,  432,   54,  -18,  -18,  -54]
  K1(261,:) = [    0,  144,  -18,    0,  -54,  -18,  -18,   54,  432,  144,  144,   54]
  K1(262,:) = [  144,    0,    0,  -18,  -18,  -54,   54,  -18,  144,  432,   54,  144]
  K1(263,:) = [  -18,    0,    0,  144,  -18,   54,  -54,  -18,  144,   54,  432,  144]
  K1(264,:) = [    0,  -18,  144,    0,   54,  -18,  -18,  -54,   54,  144,  144,  432]
  K1(265,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(266,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(267,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(268,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(269,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(270,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(271,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(272,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(273,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(274,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(275,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1(276,:) = [    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,    0]
  K1 = (1._/**/REALKIND / 9) * K1

  K2( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  K2( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  K2( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  K2( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  K2( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  K2( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  K2( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  K2( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  K2( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  K2(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  K2(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  K2(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  K2 = (1._/**/REALKIND / 3) * K2

  KL( 1,:) = [ 48, 16, 16,  6,  0, -2, 16,  0,  0, 16, -2,  0,  6,  0]
  KL( 2,:) = [ 16, 48,  6, 16, -2,  0,  0, 16, 16,  0,  0, -2,  0,  6]
  KL( 3,:) = [ 16,  6, 48, 16, 16,  0,  0, -2, -2,  0,  0, 16,  0,  6]
  KL( 4,:) = [  6, 16, 16, 48,  0, 16, -2,  0,  0, -2, 16,  0,  6,  0]
  KL( 5,:) = [  0, -2, 16,  0, 48, 16, 16,  6, -6, -2, -2,  6,  6, 18]
  KL( 6,:) = [ -2,  0,  0, 16, 16, 48,  6, 16, -2, -6,  6, -2, 18,  6]
  KL( 7,:) = [ 16,  0,  0, -2, 16,  6, 48, 16, -2,  6, -6, -2, 18,  6]
  KL( 8,:) = [  0, 16, -2,  0,  6, 16, 16, 48,  6, -2, -2, -6,  6, 18]
  KL( 9,:) = [  0, 16, -2,  0, -6, -2, -2,  6, 48, 16, 16,  6,  6, 18]
  KL(10,:) = [ 16,  0,  0, -2, -2, -6,  6, -2, 16, 48,  6, 16, 18,  6]
  KL(11,:) = [ -2,  0,  0, 16, -2,  6, -6, -2, 16,  6, 48, 16, 18,  6]
  KL(12,:) = [  0, -2, 16,  0,  6, -2, -2, -6,  6, 16, 16, 48,  6, 18]
  KL = (1._/**/REALKIND / 3) * KL

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_tttxtxgg_1_/**/REALKIND



module ol_forced_parameters_pptttt_tttxtxgg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_tttxtxgg_1_/**/REALKIND

module ol_loop_pptttt_tttxtxgg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, intkind1
  implicit none
  ! diagram prefactors
  integer,           save :: fac_status_loop1 = -1, fac_status_loop2 = -1
  complex(REALKIND), save :: f(18), c(40)
  ! tree wavefunctions
  complex(REALKIND), save :: wf(4,-6+1:583)
  ! denominators
  complex(REALKIND), save :: den(765)
  ! Born, CT and Loop colour vector for each helicity configuration
  complex(REALKIND), save :: M0(12,64), Mct(14,64), Mcol_loop(14,64)
  ! zero helicity identifier
  logical,           save :: zerohel(64) = .true., zerohel_ct(64) = .true.

  contains

! **********************************************************************
subroutine fac_init_loop()
! Writes diagram prefactors to 'f', rsp. 'c'
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND
  use ol_parameters_decl_/**/DREALKIND, only: do_ew_renorm
  use ol_loop_parameters_decl_/**/REALKIND
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_loop_init
  use ol_init, only: set_parameter, tree_parameters_flush, parameters_flush
#ifndef PRECISION_dp
  use ol_loop_parameters_decl_/**/DREALKIND, only: SwF, SwB
  use ol_loop_parameters_decl_/**/DREALKIND, only: DOI
#endif
  implicit none
  call set_parameter("ew_renorm", 0)
  if (parameters_status == 0) call tree_parameters_flush()
  if (loop_parameters_status == 0) call parameters_flush()
  call ensure_mp_loop_init()
  fac_status_loop1 = parameters_status
  fac_status_loop2 = loop_parameters_status
  ! factors of the diagrams
    f( 1) = CI*gQCD**4
    f( 2) = gQCD**4
    f( 3) = CI*countertermnorm*gQCD**6
    f( 4) = countertermnorm*gQCD**6
    f( 5) = CI*countertermnorm*ctGtt*gQCD**6
    f( 6) = countertermnorm*ctGtt*gQCD**6
    f( 7) = CI*countertermnorm*ctVVV*gQCD**6
    f( 8) = countertermnorm*ctVVV*gQCD**6
    f( 9) = CI*countertermnorm*ctVVVV*gQCD**6
    f(10) = CI*countertermnorm*gQCD**6*R2GGGG
    f(11) = (CI*gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(12) = CI*gQCD**6*integralnorm*SwB
    f(13) = (gQCD**6*integralnorm*SwB)/2._/**/REALKIND
    f(14) = gQCD**6*integralnorm*SwB
    f(15) = CI*gQCD**6*integralnorm*SwF
    f(16) = 2*CI*gQCD**6*integralnorm*SwF
    f(17) = gQCD**6*integralnorm*SwF
    f(18) = 2*gQCD**6*integralnorm*SwF

  c = [ 9*CI*f(11), 18*CI*f(11), 27*CI*f(11), 54*CI*f(11), CI*f(12), 3*CI*f(12), 6*CI*f(12), 8*CI*f(12), 9*CI*f(12), 10*CI*f(12) &
    , 18*CI*f(12), 21*CI*f(12), 24*CI*f(12), 27*CI*f(12), 54*CI*f(12), 9*f(13), 18*f(13), 27*f(13), 54*f(13), f(14), 3*f(14) &
    , 6*f(14), 8*f(14), 9*f(14), 10*f(14), 18*f(14), 21*f(14), 24*f(14), 27*f(14), 54*f(14), 3*CI*f(15), 9*CI*f(15), 3*CI*f(16) &
    , 9*CI*f(16), f(17), 3*f(17), 9*f(17), f(18), 3*f(18), 9*f(18) ]
  c = (1._/**/REALKIND / 36) * c
end subroutine fac_init_loop


! **********************************************************************
subroutine tree_wavefunctions(P, H, M1, M2, POLSEL)
! P(0:3,npart) = 2 -> n-2 external momenta (standard representation)
! H(npart)     = external-particle helicities
! Writes the tree wave functions to 'wf', denominators to 'den'.
! Returns the Born and counterterm colour vectors M1 and M2.
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_loop_parameters_decl_/**/REALKIND ! counterterms
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_wavefunctions_/**/REALKIND
  use ol_propagators_/**/REALKIND
  use ol_vertices_/**/REALKIND
  use ol_counterterms_/**/REALKIND
  implicit none
  real(REALKIND),    intent(in)  :: P(0:3,6)
  integer,           intent(in)  :: H(6)
  integer,           intent(in), optional  :: POLSEL(6)
  complex(REALKIND), intent(out) :: M1(12), M2(14)
  complex(REALKIND) :: A(602)
  ! external WFs
  if (present(POLSEL)) then
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), POLSEL(1))
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), POLSEL(2))
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), POLSEL(3))
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), POLSEL(4))
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), POLSEL(5))
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), POLSEL(6))

  else
    call pol_wf_Q(P(:,1), rMT, H(1), wf(:,0), 0)
    call pol_wf_Q(P(:,2), rMT, H(2), wf(:,-1), 0)
    call pol_wf_A(P(:,3), rMT, H(3), wf(:,-2), 0)
    call pol_wf_A(P(:,4), rMT, H(4), wf(:,-3), 0)
    call pol_wf_V(P(:,5), rZERO, H(5), wf(:,-4), 0)
    call pol_wf_V(P(:,6), rZERO, H(6), wf(:,-5), 0)

  end if

  ! internal WFs
  call vert_QA_V(wf(:,0),wf(:,-2),wf(:,1))
  call vert_QA_V(wf(:,-1),wf(:,-3),wf(:,2))
  call vert_GGG_G(wf(:,1),wf(:,-4),wf(:,-5),wf(:,3))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,1),wf(:,4))
  call vert_GGG_G(wf(:,-5),wf(:,1),wf(:,-4),wf(:,5))
  call vert_QA_V(wf(:,0),wf(:,-3),wf(:,6))
  call vert_QA_V(wf(:,-1),wf(:,-2),wf(:,7))
  call vert_GGG_G(wf(:,6),wf(:,-4),wf(:,-5),wf(:,8))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,6),wf(:,9))
  call vert_GGG_G(wf(:,-5),wf(:,6),wf(:,-4),wf(:,10))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,11))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,12))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,-4),Q(:,16),wf(:,13))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,-5),Q(:,32),wf(:,14))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,-4),Q(:,16),wf(:,15))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,16))
  call vert_VQ_A(wf(:,-4),wf(:,-1),wf(:,17))
  call vert_AV_Q(wf(:,-3),wf(:,-5),wf(:,18))
  call prop_Q_A(wf(:,17),Q(:,18),MT,1_intkind1,wf(:,19))
  call prop_A_Q(wf(:,18),Q(:,40),MT,1_intkind1,wf(:,20))
  call vert_VQ_A(wf(:,1),wf(:,19),wf(:,21))
  call vert_AV_Q(wf(:,-3),wf(:,1),wf(:,22))
  call vert_VQ_A(wf(:,-5),wf(:,19),wf(:,23))
  call prop_A_Q(wf(:,22),Q(:,13),MT,1_intkind1,wf(:,24))
  call vert_QA_V(wf(:,19),wf(:,-3),wf(:,25))
  call vert_VQ_A(wf(:,-5),wf(:,-1),wf(:,26))
  call vert_AV_Q(wf(:,-3),wf(:,-4),wf(:,27))
  call prop_Q_A(wf(:,26),Q(:,34),MT,1_intkind1,wf(:,28))
  call prop_A_Q(wf(:,27),Q(:,24),MT,1_intkind1,wf(:,29))
  call vert_VQ_A(wf(:,1),wf(:,28),wf(:,30))
  call vert_VQ_A(wf(:,1),wf(:,-1),wf(:,31))
  call vert_AV_Q(wf(:,29),wf(:,-5),wf(:,32))
  call prop_Q_A(wf(:,31),Q(:,7),MT,1_intkind1,wf(:,33))
  call vert_QA_V(wf(:,-1),wf(:,29),wf(:,34))
  call vert_VQ_A(wf(:,-4),wf(:,28),wf(:,35))
  call vert_QA_V(wf(:,28),wf(:,-3),wf(:,36))
  call vert_AV_Q(wf(:,20),wf(:,-4),wf(:,37))
  call vert_QA_V(wf(:,-1),wf(:,20),wf(:,38))
  call vert_AV_Q(wf(:,-3),wf(:,11),wf(:,39))
  call vert_VQ_A(wf(:,11),wf(:,-1),wf(:,40))
  call prop_Q_A(wf(:,40),Q(:,50),MT,1_intkind1,wf(:,41))
  call vert_UV_W(wf(:,7),Q(:,6),wf(:,6),Q(:,9),wf(:,42))
  call vert_UV_W(wf(:,6),Q(:,9),wf(:,-4),Q(:,16),wf(:,43))
  call vert_UV_W(wf(:,7),Q(:,6),wf(:,-5),Q(:,32),wf(:,44))
  call vert_UV_W(wf(:,7),Q(:,6),wf(:,-4),Q(:,16),wf(:,45))
  call vert_UV_W(wf(:,6),Q(:,9),wf(:,-5),Q(:,32),wf(:,46))
  call vert_VQ_A(wf(:,-4),wf(:,0),wf(:,47))
  call prop_Q_A(wf(:,47),Q(:,17),MT,1_intkind1,wf(:,48))
  call vert_VQ_A(wf(:,7),wf(:,48),wf(:,49))
  call vert_QA_V(wf(:,48),wf(:,-3),wf(:,50))
  call vert_AV_Q(wf(:,-3),wf(:,7),wf(:,51))
  call vert_VQ_A(wf(:,-5),wf(:,48),wf(:,52))
  call prop_A_Q(wf(:,51),Q(:,14),MT,1_intkind1,wf(:,53))
  call vert_VQ_A(wf(:,-5),wf(:,0),wf(:,54))
  call prop_Q_A(wf(:,54),Q(:,33),MT,1_intkind1,wf(:,55))
  call vert_VQ_A(wf(:,7),wf(:,55),wf(:,56))
  call vert_VQ_A(wf(:,7),wf(:,0),wf(:,57))
  call prop_Q_A(wf(:,57),Q(:,7),MT,1_intkind1,wf(:,58))
  call vert_QA_V(wf(:,0),wf(:,29),wf(:,59))
  call vert_QA_V(wf(:,55),wf(:,-3),wf(:,60))
  call vert_VQ_A(wf(:,-4),wf(:,55),wf(:,61))
  call vert_QA_V(wf(:,0),wf(:,20),wf(:,62))
  call vert_VQ_A(wf(:,11),wf(:,0),wf(:,63))
  call prop_Q_A(wf(:,63),Q(:,49),MT,1_intkind1,wf(:,64))
  call vert_AV_Q(wf(:,-2),wf(:,-5),wf(:,65))
  call prop_A_Q(wf(:,65),Q(:,36),MT,1_intkind1,wf(:,66))
  call vert_VQ_A(wf(:,6),wf(:,19),wf(:,67))
  call vert_AV_Q(wf(:,-2),wf(:,6),wf(:,68))
  call prop_A_Q(wf(:,68),Q(:,13),MT,1_intkind1,wf(:,69))
  call vert_QA_V(wf(:,19),wf(:,-2),wf(:,70))
  call vert_AV_Q(wf(:,-2),wf(:,-4),wf(:,71))
  call prop_A_Q(wf(:,71),Q(:,20),MT,1_intkind1,wf(:,72))
  call vert_VQ_A(wf(:,6),wf(:,28),wf(:,73))
  call vert_VQ_A(wf(:,6),wf(:,-1),wf(:,74))
  call vert_AV_Q(wf(:,72),wf(:,-5),wf(:,75))
  call prop_Q_A(wf(:,74),Q(:,11),MT,1_intkind1,wf(:,76))
  call vert_QA_V(wf(:,-1),wf(:,72),wf(:,77))
  call vert_QA_V(wf(:,28),wf(:,-2),wf(:,78))
  call vert_AV_Q(wf(:,66),wf(:,-4),wf(:,79))
  call vert_QA_V(wf(:,-1),wf(:,66),wf(:,80))
  call vert_AV_Q(wf(:,-2),wf(:,11),wf(:,81))
  call vert_VQ_A(wf(:,2),wf(:,48),wf(:,82))
  call vert_QA_V(wf(:,48),wf(:,-2),wf(:,83))
  call vert_AV_Q(wf(:,-2),wf(:,2),wf(:,84))
  call prop_A_Q(wf(:,84),Q(:,14),MT,1_intkind1,wf(:,85))
  call vert_VQ_A(wf(:,2),wf(:,55),wf(:,86))
  call vert_VQ_A(wf(:,2),wf(:,0),wf(:,87))
  call prop_Q_A(wf(:,87),Q(:,11),MT,1_intkind1,wf(:,88))
  call vert_QA_V(wf(:,0),wf(:,72),wf(:,89))
  call vert_QA_V(wf(:,55),wf(:,-2),wf(:,90))
  call vert_QA_V(wf(:,0),wf(:,66),wf(:,91))
  call counter_GGG_G(wf(:,1),wf(:,-4),wf(:,-5),wf(:,92))
  call counter_GGG_G(wf(:,-4),wf(:,-5),wf(:,1),wf(:,93))
  call counter_GGG_G(wf(:,-5),wf(:,1),wf(:,-4),wf(:,94))
  call counter_GGG_G(wf(:,6),wf(:,-4),wf(:,-5),wf(:,95))
  call counter_GGG_G(wf(:,-4),wf(:,-5),wf(:,6),wf(:,96))
  call counter_GGG_G(wf(:,-5),wf(:,6),wf(:,-4),wf(:,97))
  call counter_QA_V(wf(:,-1),wf(:,-3),wf(:,98))
  call counter_QA_V(wf(:,-1),wf(:,-2),wf(:,99))
  call counter_QA_V(wf(:,0),wf(:,-3),wf(:,100))
  call vert_GGG_G(wf(:,100),wf(:,-4),wf(:,-5),wf(:,101))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,100),wf(:,102))
  call vert_GGG_G(wf(:,-5),wf(:,100),wf(:,-4),wf(:,103))
  call counter_QA_V(wf(:,0),wf(:,-2),wf(:,104))
  call vert_GGG_G(wf(:,104),wf(:,-4),wf(:,-5),wf(:,105))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,104),wf(:,106))
  call vert_GGG_G(wf(:,-5),wf(:,104),wf(:,-4),wf(:,107))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,2),Q(:,10),wf(:,108))
  call counter_UV_W(wf(:,2),Q(:,10),wf(:,-5),Q(:,32),wf(:,109))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,-5),Q(:,32),wf(:,110))
  call vert_GGG_G(wf(:,2),wf(:,-4),wf(:,-5),wf(:,111))
  call counter_V_V(ctGG,21,wf(:,1),Q(:,5),wf(:,112))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,2),wf(:,113))
  call vert_GGG_G(wf(:,-5),wf(:,2),wf(:,-4),wf(:,114))
  call counter_V_V(ctGG,21,wf(:,2),Q(:,10),wf(:,115))
  call counter_UV_W(wf(:,2),Q(:,10),wf(:,-4),Q(:,16),wf(:,116))
  call counter_UV_W(wf(:,1),Q(:,5),wf(:,-4),Q(:,16),wf(:,117))
  call counter_UV_W(wf(:,-4),Q(:,16),wf(:,-5),Q(:,32),wf(:,118))
  call counter_VQ_A(wf(:,1),wf(:,19),wf(:,119))
  call counter_VQ_A(wf(:,-5),wf(:,19),wf(:,120))
  call counter_VQ_A(wf(:,1),wf(:,28),wf(:,121))
  call counter_AV_Q(wf(:,29),wf(:,-5),wf(:,122))
  call counter_VQ_A(wf(:,-4),wf(:,28),wf(:,123))
  call counter_AV_Q(wf(:,20),wf(:,-4),wf(:,124))
  call vert_AV_Q(wf(:,-3),wf(:,118),wf(:,125))
  call vert_VQ_A(wf(:,118),wf(:,-1),wf(:,126))
  call prop_Q_A(wf(:,126),Q(:,50),MT,1_intkind1,wf(:,127))
  call counter_QA_V(wf(:,19),wf(:,-3),wf(:,128))
  call counter_AV_Q(wf(:,-3),wf(:,1),wf(:,129))
  call prop_Q_A(wf(:,23),Q(:,50),MT,1_intkind1,wf(:,130))
  call counter_AV_Q(wf(:,-3),wf(:,-5),wf(:,131))
  call prop_A_Q(wf(:,131),Q(:,40),MT,1_intkind1,wf(:,132))
  call counter_QA_V(wf(:,28),wf(:,-3),wf(:,133))
  call prop_Q_A(wf(:,35),Q(:,50),MT,1_intkind1,wf(:,134))
  call counter_AV_Q(wf(:,-3),wf(:,11),wf(:,135))
  call vert_AV_Q(wf(:,132),wf(:,-4),wf(:,136))
  call vert_QA_V(wf(:,-1),wf(:,132),wf(:,137))
  call counter_AV_Q(wf(:,-3),wf(:,-4),wf(:,138))
  call prop_A_Q(wf(:,138),Q(:,24),MT,1_intkind1,wf(:,139))
  call vert_AV_Q(wf(:,139),wf(:,-5),wf(:,140))
  call vert_QA_V(wf(:,-1),wf(:,139),wf(:,141))
  call counter_UV_W(wf(:,7),Q(:,6),wf(:,6),Q(:,9),wf(:,142))
  call counter_UV_W(wf(:,7),Q(:,6),wf(:,-5),Q(:,32),wf(:,143))
  call counter_UV_W(wf(:,6),Q(:,9),wf(:,-5),Q(:,32),wf(:,144))
  call vert_GGG_G(wf(:,7),wf(:,-4),wf(:,-5),wf(:,145))
  call counter_V_V(ctGG,21,wf(:,6),Q(:,9),wf(:,146))
  call vert_GGG_G(wf(:,-4),wf(:,-5),wf(:,7),wf(:,147))
  call vert_GGG_G(wf(:,-5),wf(:,7),wf(:,-4),wf(:,148))
  call counter_V_V(ctGG,21,wf(:,7),Q(:,6),wf(:,149))
  call counter_UV_W(wf(:,7),Q(:,6),wf(:,-4),Q(:,16),wf(:,150))
  call counter_UV_W(wf(:,6),Q(:,9),wf(:,-4),Q(:,16),wf(:,151))
  call counter_VQ_A(wf(:,7),wf(:,48),wf(:,152))
  call counter_VQ_A(wf(:,-5),wf(:,48),wf(:,153))
  call counter_VQ_A(wf(:,7),wf(:,55),wf(:,154))
  call counter_VQ_A(wf(:,-4),wf(:,55),wf(:,155))
  call vert_VQ_A(wf(:,118),wf(:,0),wf(:,156))
  call prop_Q_A(wf(:,156),Q(:,49),MT,1_intkind1,wf(:,157))
  call counter_AV_Q(wf(:,-3),wf(:,7),wf(:,158))
  call prop_Q_A(wf(:,52),Q(:,49),MT,1_intkind1,wf(:,159))
  call counter_QA_V(wf(:,48),wf(:,-3),wf(:,160))
  call prop_Q_A(wf(:,61),Q(:,49),MT,1_intkind1,wf(:,161))
  call counter_QA_V(wf(:,55),wf(:,-3),wf(:,162))
  call vert_QA_V(wf(:,0),wf(:,132),wf(:,163))
  call vert_QA_V(wf(:,0),wf(:,139),wf(:,164))
  call counter_VQ_A(wf(:,6),wf(:,19),wf(:,165))
  call counter_VQ_A(wf(:,6),wf(:,28),wf(:,166))
  call counter_AV_Q(wf(:,72),wf(:,-5),wf(:,167))
  call counter_AV_Q(wf(:,66),wf(:,-4),wf(:,168))
  call vert_AV_Q(wf(:,-2),wf(:,118),wf(:,169))
  call counter_VQ_A(wf(:,2),wf(:,48),wf(:,170))
  call counter_VQ_A(wf(:,2),wf(:,55),wf(:,171))
  call counter_QA_V(wf(:,19),wf(:,-2),wf(:,172))
  call counter_AV_Q(wf(:,-2),wf(:,6),wf(:,173))
  call counter_AV_Q(wf(:,-2),wf(:,-5),wf(:,174))
  call prop_A_Q(wf(:,174),Q(:,36),MT,1_intkind1,wf(:,175))
  call counter_QA_V(wf(:,28),wf(:,-2),wf(:,176))
  call counter_AV_Q(wf(:,-2),wf(:,11),wf(:,177))
  call vert_AV_Q(wf(:,175),wf(:,-4),wf(:,178))
  call vert_QA_V(wf(:,-1),wf(:,175),wf(:,179))
  call counter_AV_Q(wf(:,-2),wf(:,-4),wf(:,180))
  call prop_A_Q(wf(:,180),Q(:,20),MT,1_intkind1,wf(:,181))
  call vert_AV_Q(wf(:,181),wf(:,-5),wf(:,182))
  call vert_QA_V(wf(:,-1),wf(:,181),wf(:,183))
  call counter_AV_Q(wf(:,-2),wf(:,2),wf(:,184))
  call counter_QA_V(wf(:,48),wf(:,-2),wf(:,185))
  call counter_QA_V(wf(:,55),wf(:,-2),wf(:,186))
  call vert_QA_V(wf(:,0),wf(:,175),wf(:,187))
  call vert_QA_V(wf(:,0),wf(:,181),wf(:,188))
  call counter_QA_V(wf(:,-1),wf(:,29),wf(:,189))
  call counter_VQ_A(wf(:,1),wf(:,-1),wf(:,190))
  call prop_A_Q(wf(:,32),Q(:,56),MT,1_intkind1,wf(:,191))
  call counter_VQ_A(wf(:,-5),wf(:,-1),wf(:,192))
  call prop_Q_A(wf(:,192),Q(:,34),MT,1_intkind1,wf(:,193))
  call vert_VQ_A(wf(:,1),wf(:,193),wf(:,194))
  call counter_QA_V(wf(:,-1),wf(:,20),wf(:,195))
  call prop_A_Q(wf(:,37),Q(:,56),MT,1_intkind1,wf(:,196))
  call counter_VQ_A(wf(:,11),wf(:,-1),wf(:,197))
  call prop_A_Q(wf(:,39),Q(:,56),MT,1_intkind1,wf(:,198))
  call vert_VQ_A(wf(:,-4),wf(:,193),wf(:,199))
  call vert_QA_V(wf(:,193),wf(:,-3),wf(:,200))
  call counter_VQ_A(wf(:,-4),wf(:,-1),wf(:,201))
  call prop_Q_A(wf(:,201),Q(:,18),MT,1_intkind1,wf(:,202))
  call vert_VQ_A(wf(:,1),wf(:,202),wf(:,203))
  call vert_VQ_A(wf(:,-5),wf(:,202),wf(:,204))
  call vert_QA_V(wf(:,202),wf(:,-3),wf(:,205))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,98),Q(:,10),wf(:,206))
  call vert_UV_W(wf(:,98),Q(:,10),wf(:,-5),Q(:,32),wf(:,207))
  call vert_UV_W(wf(:,98),Q(:,10),wf(:,-4),Q(:,16),wf(:,208))
  call counter_QA_V(wf(:,-1),wf(:,72),wf(:,209))
  call counter_VQ_A(wf(:,6),wf(:,-1),wf(:,210))
  call prop_A_Q(wf(:,75),Q(:,52),MT,1_intkind1,wf(:,211))
  call vert_VQ_A(wf(:,6),wf(:,193),wf(:,212))
  call counter_QA_V(wf(:,-1),wf(:,66),wf(:,213))
  call prop_A_Q(wf(:,79),Q(:,52),MT,1_intkind1,wf(:,214))
  call prop_A_Q(wf(:,81),Q(:,52),MT,1_intkind1,wf(:,215))
  call vert_QA_V(wf(:,193),wf(:,-2),wf(:,216))
  call vert_VQ_A(wf(:,6),wf(:,202),wf(:,217))
  call vert_QA_V(wf(:,202),wf(:,-2),wf(:,218))
  call vert_VQ_A(wf(:,98),wf(:,48),wf(:,219))
  call vert_AV_Q(wf(:,-2),wf(:,98),wf(:,220))
  call prop_A_Q(wf(:,220),Q(:,14),MT,1_intkind1,wf(:,221))
  call vert_VQ_A(wf(:,98),wf(:,55),wf(:,222))
  call vert_VQ_A(wf(:,98),wf(:,0),wf(:,223))
  call prop_Q_A(wf(:,223),Q(:,11),MT,1_intkind1,wf(:,224))
  call vert_UV_W(wf(:,99),Q(:,6),wf(:,6),Q(:,9),wf(:,225))
  call vert_UV_W(wf(:,99),Q(:,6),wf(:,-5),Q(:,32),wf(:,226))
  call vert_UV_W(wf(:,99),Q(:,6),wf(:,-4),Q(:,16),wf(:,227))
  call vert_VQ_A(wf(:,99),wf(:,48),wf(:,228))
  call vert_AV_Q(wf(:,-3),wf(:,99),wf(:,229))
  call prop_A_Q(wf(:,229),Q(:,14),MT,1_intkind1,wf(:,230))
  call vert_VQ_A(wf(:,99),wf(:,55),wf(:,231))
  call vert_VQ_A(wf(:,99),wf(:,0),wf(:,232))
  call prop_Q_A(wf(:,232),Q(:,7),MT,1_intkind1,wf(:,233))
  call counter_VQ_A(wf(:,7),wf(:,0),wf(:,234))
  call counter_QA_V(wf(:,0),wf(:,29),wf(:,235))
  call counter_VQ_A(wf(:,-5),wf(:,0),wf(:,236))
  call prop_Q_A(wf(:,236),Q(:,33),MT,1_intkind1,wf(:,237))
  call vert_VQ_A(wf(:,7),wf(:,237),wf(:,238))
  call counter_QA_V(wf(:,0),wf(:,20),wf(:,239))
  call counter_VQ_A(wf(:,11),wf(:,0),wf(:,240))
  call vert_QA_V(wf(:,237),wf(:,-3),wf(:,241))
  call vert_VQ_A(wf(:,-4),wf(:,237),wf(:,242))
  call counter_VQ_A(wf(:,-4),wf(:,0),wf(:,243))
  call prop_Q_A(wf(:,243),Q(:,17),MT,1_intkind1,wf(:,244))
  call vert_VQ_A(wf(:,7),wf(:,244),wf(:,245))
  call vert_QA_V(wf(:,244),wf(:,-3),wf(:,246))
  call vert_VQ_A(wf(:,-5),wf(:,244),wf(:,247))
  call vert_UV_W(wf(:,7),Q(:,6),wf(:,100),Q(:,9),wf(:,248))
  call vert_UV_W(wf(:,100),Q(:,9),wf(:,-4),Q(:,16),wf(:,249))
  call vert_UV_W(wf(:,100),Q(:,9),wf(:,-5),Q(:,32),wf(:,250))
  call counter_VQ_A(wf(:,2),wf(:,0),wf(:,251))
  call counter_QA_V(wf(:,0),wf(:,72),wf(:,252))
  call vert_VQ_A(wf(:,2),wf(:,237),wf(:,253))
  call counter_QA_V(wf(:,0),wf(:,66),wf(:,254))
  call vert_QA_V(wf(:,237),wf(:,-2),wf(:,255))
  call vert_VQ_A(wf(:,2),wf(:,244),wf(:,256))
  call vert_QA_V(wf(:,244),wf(:,-2),wf(:,257))
  call vert_VQ_A(wf(:,100),wf(:,19),wf(:,258))
  call vert_AV_Q(wf(:,-2),wf(:,100),wf(:,259))
  call prop_A_Q(wf(:,259),Q(:,13),MT,1_intkind1,wf(:,260))
  call vert_VQ_A(wf(:,100),wf(:,28),wf(:,261))
  call vert_VQ_A(wf(:,100),wf(:,-1),wf(:,262))
  call prop_Q_A(wf(:,262),Q(:,11),MT,1_intkind1,wf(:,263))
  call vert_UV_W(wf(:,104),Q(:,5),wf(:,2),Q(:,10),wf(:,264))
  call vert_UV_W(wf(:,104),Q(:,5),wf(:,-4),Q(:,16),wf(:,265))
  call vert_UV_W(wf(:,104),Q(:,5),wf(:,-5),Q(:,32),wf(:,266))
  call vert_VQ_A(wf(:,104),wf(:,19),wf(:,267))
  call vert_AV_Q(wf(:,-3),wf(:,104),wf(:,268))
  call prop_A_Q(wf(:,268),Q(:,13),MT,1_intkind1,wf(:,269))
  call vert_VQ_A(wf(:,104),wf(:,28),wf(:,270))
  call vert_VQ_A(wf(:,104),wf(:,-1),wf(:,271))
  call prop_Q_A(wf(:,271),Q(:,7),MT,1_intkind1,wf(:,272))
  call vert_UV_W(wf(:,2),Q(:,10),wf(:,11),Q(:,48),wf(:,273))
  call vert_UV_W(wf(:,1),Q(:,5),wf(:,11),Q(:,48),wf(:,274))
  call counter_V_V(ctGG,21,wf(:,11),Q(:,48),wf(:,275))
  call vert_UV_W(wf(:,112),Q(:,5),wf(:,-4),Q(:,16),wf(:,276))
  call vert_UV_W(wf(:,112),Q(:,5),wf(:,-5),Q(:,32),wf(:,277))
  call vert_UV_W(wf(:,115),Q(:,10),wf(:,-4),Q(:,16),wf(:,278))
  call vert_UV_W(wf(:,115),Q(:,10),wf(:,-5),Q(:,32),wf(:,279))
  call counter_V_V(ctGG,21,wf(:,13),Q(:,21),wf(:,280))
  call counter_V_V(ctGG,21,wf(:,15),Q(:,26),wf(:,281))
  call vert_QA_V(wf(:,19),wf(:,20),wf(:,282))
  call vert_AV_Q(wf(:,20),wf(:,1),wf(:,283))
  call counter_Q_A(cttt,6,wf(:,19),Q(:,18),wf(:,284))
  call prop_A_Q(wf(:,283),Q(:,45),MT,1_intkind1,wf(:,285))
  call counter_A_Q(cttt,6,wf(:,20),Q(:,40),wf(:,286))
  call prop_Q_A(wf(:,21),Q(:,23),MT,1_intkind1,wf(:,287))
  call vert_AV_Q(wf(:,-3),wf(:,112),wf(:,288))
  call prop_Q_A(wf(:,284),Q(:,18),MT,1_intkind1,wf(:,289))
  call vert_QA_V(wf(:,289),wf(:,-3),wf(:,290))
  call vert_VQ_A(wf(:,-5),wf(:,289),wf(:,291))
  call counter_A_Q(cttt,6,wf(:,24),Q(:,13),wf(:,292))
  call counter_V_V(ctGG,21,wf(:,25),Q(:,26),wf(:,293))
  call vert_QA_V(wf(:,28),wf(:,29),wf(:,294))
  call vert_AV_Q(wf(:,29),wf(:,1),wf(:,295))
  call counter_Q_A(cttt,6,wf(:,28),Q(:,34),wf(:,296))
  call prop_A_Q(wf(:,295),Q(:,29),MT,1_intkind1,wf(:,297))
  call counter_A_Q(cttt,6,wf(:,29),Q(:,24),wf(:,298))
  call prop_Q_A(wf(:,30),Q(:,39),MT,1_intkind1,wf(:,299))
  call vert_VQ_A(wf(:,112),wf(:,-1),wf(:,300))
  call prop_A_Q(wf(:,298),Q(:,24),MT,1_intkind1,wf(:,301))
  call vert_QA_V(wf(:,-1),wf(:,301),wf(:,302))
  call counter_Q_A(cttt,6,wf(:,33),Q(:,7),wf(:,303))
  call counter_V_V(ctGG,21,wf(:,34),Q(:,26),wf(:,304))
  call vert_AV_Q(wf(:,301),wf(:,-5),wf(:,305))
  call prop_Q_A(wf(:,296),Q(:,34),MT,1_intkind1,wf(:,306))
  call vert_QA_V(wf(:,306),wf(:,-3),wf(:,307))
  call vert_VQ_A(wf(:,-4),wf(:,306),wf(:,308))
  call counter_V_V(ctGG,21,wf(:,36),Q(:,42),wf(:,309))
  call prop_A_Q(wf(:,286),Q(:,40),MT,1_intkind1,wf(:,310))
  call vert_QA_V(wf(:,-1),wf(:,310),wf(:,311))
  call counter_V_V(ctGG,21,wf(:,38),Q(:,42),wf(:,312))
  call vert_AV_Q(wf(:,310),wf(:,-4),wf(:,313))
  call counter_Q_A(cttt,6,wf(:,41),Q(:,50),wf(:,314))
  call vert_VQ_A(wf(:,275),wf(:,-1),wf(:,315))
  call vert_AV_Q(wf(:,-3),wf(:,275),wf(:,316))
  call vert_UV_W(wf(:,7),Q(:,6),wf(:,11),Q(:,48),wf(:,317))
  call vert_UV_W(wf(:,6),Q(:,9),wf(:,11),Q(:,48),wf(:,318))
  call vert_UV_W(wf(:,146),Q(:,9),wf(:,-4),Q(:,16),wf(:,319))
  call vert_UV_W(wf(:,146),Q(:,9),wf(:,-5),Q(:,32),wf(:,320))
  call vert_UV_W(wf(:,149),Q(:,6),wf(:,-4),Q(:,16),wf(:,321))
  call vert_UV_W(wf(:,149),Q(:,6),wf(:,-5),Q(:,32),wf(:,322))
  call counter_V_V(ctGG,21,wf(:,43),Q(:,25),wf(:,323))
  call counter_V_V(ctGG,21,wf(:,45),Q(:,22),wf(:,324))
  call vert_AV_Q(wf(:,20),wf(:,7),wf(:,325))
  call counter_Q_A(cttt,6,wf(:,48),Q(:,17),wf(:,326))
  call prop_A_Q(wf(:,325),Q(:,46),MT,1_intkind1,wf(:,327))
  call vert_QA_V(wf(:,48),wf(:,20),wf(:,328))
  call prop_Q_A(wf(:,49),Q(:,23),MT,1_intkind1,wf(:,329))
  call prop_Q_A(wf(:,326),Q(:,17),MT,1_intkind1,wf(:,330))
  call vert_QA_V(wf(:,330),wf(:,-3),wf(:,331))
  call vert_VQ_A(wf(:,-5),wf(:,330),wf(:,332))
  call vert_AV_Q(wf(:,-3),wf(:,149),wf(:,333))
  call counter_V_V(ctGG,21,wf(:,50),Q(:,25),wf(:,334))
  call counter_A_Q(cttt,6,wf(:,53),Q(:,14),wf(:,335))
  call vert_AV_Q(wf(:,29),wf(:,7),wf(:,336))
  call counter_Q_A(cttt,6,wf(:,55),Q(:,33),wf(:,337))
  call prop_A_Q(wf(:,336),Q(:,30),MT,1_intkind1,wf(:,338))
  call vert_QA_V(wf(:,55),wf(:,29),wf(:,339))
  call prop_Q_A(wf(:,56),Q(:,39),MT,1_intkind1,wf(:,340))
  call vert_VQ_A(wf(:,149),wf(:,0),wf(:,341))
  call vert_QA_V(wf(:,0),wf(:,301),wf(:,342))
  call counter_Q_A(cttt,6,wf(:,58),Q(:,7),wf(:,343))
  call counter_V_V(ctGG,21,wf(:,59),Q(:,25),wf(:,344))
  call prop_Q_A(wf(:,337),Q(:,33),MT,1_intkind1,wf(:,345))
  call vert_QA_V(wf(:,345),wf(:,-3),wf(:,346))
  call vert_VQ_A(wf(:,-4),wf(:,345),wf(:,347))
  call counter_V_V(ctGG,21,wf(:,60),Q(:,41),wf(:,348))
  call vert_QA_V(wf(:,0),wf(:,310),wf(:,349))
  call counter_V_V(ctGG,21,wf(:,62),Q(:,41),wf(:,350))
  call counter_Q_A(cttt,6,wf(:,64),Q(:,49),wf(:,351))
  call vert_VQ_A(wf(:,275),wf(:,0),wf(:,352))
  call vert_QA_V(wf(:,19),wf(:,66),wf(:,353))
  call vert_AV_Q(wf(:,66),wf(:,6),wf(:,354))
  call prop_A_Q(wf(:,354),Q(:,45),MT,1_intkind1,wf(:,355))
  call counter_A_Q(cttt,6,wf(:,66),Q(:,36),wf(:,356))
  call prop_Q_A(wf(:,67),Q(:,27),MT,1_intkind1,wf(:,357))
  call vert_AV_Q(wf(:,-2),wf(:,146),wf(:,358))
  call vert_QA_V(wf(:,289),wf(:,-2),wf(:,359))
  call counter_A_Q(cttt,6,wf(:,69),Q(:,13),wf(:,360))
  call counter_V_V(ctGG,21,wf(:,70),Q(:,22),wf(:,361))
  call vert_QA_V(wf(:,28),wf(:,72),wf(:,362))
  call vert_AV_Q(wf(:,72),wf(:,6),wf(:,363))
  call prop_A_Q(wf(:,363),Q(:,29),MT,1_intkind1,wf(:,364))
  call counter_A_Q(cttt,6,wf(:,72),Q(:,20),wf(:,365))
  call prop_Q_A(wf(:,73),Q(:,43),MT,1_intkind1,wf(:,366))
  call vert_VQ_A(wf(:,146),wf(:,-1),wf(:,367))
  call prop_A_Q(wf(:,365),Q(:,20),MT,1_intkind1,wf(:,368))
  call vert_QA_V(wf(:,-1),wf(:,368),wf(:,369))
  call counter_Q_A(cttt,6,wf(:,76),Q(:,11),wf(:,370))
  call counter_V_V(ctGG,21,wf(:,77),Q(:,22),wf(:,371))
  call vert_AV_Q(wf(:,368),wf(:,-5),wf(:,372))
  call vert_QA_V(wf(:,306),wf(:,-2),wf(:,373))
  call counter_V_V(ctGG,21,wf(:,78),Q(:,38),wf(:,374))
  call prop_A_Q(wf(:,356),Q(:,36),MT,1_intkind1,wf(:,375))
  call vert_QA_V(wf(:,-1),wf(:,375),wf(:,376))
  call counter_V_V(ctGG,21,wf(:,80),Q(:,38),wf(:,377))
  call vert_AV_Q(wf(:,375),wf(:,-4),wf(:,378))
  call vert_AV_Q(wf(:,-2),wf(:,275),wf(:,379))
  call vert_AV_Q(wf(:,66),wf(:,2),wf(:,380))
  call prop_A_Q(wf(:,380),Q(:,46),MT,1_intkind1,wf(:,381))
  call vert_QA_V(wf(:,48),wf(:,66),wf(:,382))
  call prop_Q_A(wf(:,82),Q(:,27),MT,1_intkind1,wf(:,383))
  call vert_QA_V(wf(:,330),wf(:,-2),wf(:,384))
  call vert_AV_Q(wf(:,-2),wf(:,115),wf(:,385))
  call counter_V_V(ctGG,21,wf(:,83),Q(:,21),wf(:,386))
  call counter_A_Q(cttt,6,wf(:,85),Q(:,14),wf(:,387))
  call vert_AV_Q(wf(:,72),wf(:,2),wf(:,388))
  call prop_A_Q(wf(:,388),Q(:,30),MT,1_intkind1,wf(:,389))
  call vert_QA_V(wf(:,55),wf(:,72),wf(:,390))
  call prop_Q_A(wf(:,86),Q(:,43),MT,1_intkind1,wf(:,391))
  call vert_VQ_A(wf(:,115),wf(:,0),wf(:,392))
  call vert_QA_V(wf(:,0),wf(:,368),wf(:,393))
  call counter_Q_A(cttt,6,wf(:,88),Q(:,11),wf(:,394))
  call counter_V_V(ctGG,21,wf(:,89),Q(:,21),wf(:,395))
  call vert_QA_V(wf(:,345),wf(:,-2),wf(:,396))
  call counter_V_V(ctGG,21,wf(:,90),Q(:,37),wf(:,397))
  call vert_QA_V(wf(:,0),wf(:,375),wf(:,398))
  call counter_V_V(ctGG,21,wf(:,91),Q(:,37),wf(:,399))
  call vert_QA_V(wf(:,33),wf(:,-3),wf(:,400))
  call vert_VQ_A(wf(:,-4),wf(:,33),wf(:,401))
  call prop_Q_A(wf(:,401),Q(:,23),MT,1_intkind1,wf(:,402))
  call vert_VQ_A(wf(:,-5),wf(:,33),wf(:,403))
  call prop_Q_A(wf(:,403),Q(:,39),MT,1_intkind1,wf(:,404))
  call vert_QA_V(wf(:,-1),wf(:,24),wf(:,405))
  call vert_AV_Q(wf(:,24),wf(:,-4),wf(:,406))
  call prop_A_Q(wf(:,406),Q(:,29),MT,1_intkind1,wf(:,407))
  call vert_AV_Q(wf(:,24),wf(:,-5),wf(:,408))
  call prop_A_Q(wf(:,408),Q(:,45),MT,1_intkind1,wf(:,409))
  call vert_VQ_A(wf(:,13),wf(:,-1),wf(:,410))
  call prop_Q_A(wf(:,410),Q(:,23),MT,1_intkind1,wf(:,411))
  call vert_AV_Q(wf(:,-3),wf(:,13),wf(:,412))
  call prop_A_Q(wf(:,412),Q(:,29),MT,1_intkind1,wf(:,413))
  call vert_UV_W(wf(:,13),Q(:,21),wf(:,-5),Q(:,32),wf(:,414))
  call vert_VQ_A(wf(:,16),wf(:,-1),wf(:,415))
  call prop_Q_A(wf(:,415),Q(:,39),MT,1_intkind1,wf(:,416))
  call vert_AV_Q(wf(:,-3),wf(:,16),wf(:,417))
  call prop_A_Q(wf(:,417),Q(:,45),MT,1_intkind1,wf(:,418))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,16),Q(:,37),wf(:,419))
  call vert_QA_V(wf(:,58),wf(:,-3),wf(:,420))
  call vert_VQ_A(wf(:,-4),wf(:,58),wf(:,421))
  call prop_Q_A(wf(:,421),Q(:,23),MT,1_intkind1,wf(:,422))
  call vert_VQ_A(wf(:,-5),wf(:,58),wf(:,423))
  call prop_Q_A(wf(:,423),Q(:,39),MT,1_intkind1,wf(:,424))
  call vert_QA_V(wf(:,0),wf(:,53),wf(:,425))
  call vert_VQ_A(wf(:,45),wf(:,0),wf(:,426))
  call prop_Q_A(wf(:,426),Q(:,23),MT,1_intkind1,wf(:,427))
  call vert_VQ_A(wf(:,44),wf(:,0),wf(:,428))
  call prop_Q_A(wf(:,428),Q(:,39),MT,1_intkind1,wf(:,429))
  call vert_AV_Q(wf(:,53),wf(:,-4),wf(:,430))
  call prop_A_Q(wf(:,430),Q(:,30),MT,1_intkind1,wf(:,431))
  call vert_AV_Q(wf(:,53),wf(:,-5),wf(:,432))
  call prop_A_Q(wf(:,432),Q(:,46),MT,1_intkind1,wf(:,433))
  call vert_AV_Q(wf(:,-3),wf(:,45),wf(:,434))
  call prop_A_Q(wf(:,434),Q(:,30),MT,1_intkind1,wf(:,435))
  call vert_UV_W(wf(:,45),Q(:,22),wf(:,-5),Q(:,32),wf(:,436))
  call vert_AV_Q(wf(:,-3),wf(:,44),wf(:,437))
  call prop_A_Q(wf(:,437),Q(:,46),MT,1_intkind1,wf(:,438))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,44),Q(:,38),wf(:,439))
  call vert_QA_V(wf(:,76),wf(:,-2),wf(:,440))
  call vert_VQ_A(wf(:,-4),wf(:,76),wf(:,441))
  call prop_Q_A(wf(:,441),Q(:,27),MT,1_intkind1,wf(:,442))
  call vert_VQ_A(wf(:,-5),wf(:,76),wf(:,443))
  call prop_Q_A(wf(:,443),Q(:,43),MT,1_intkind1,wf(:,444))
  call vert_QA_V(wf(:,-1),wf(:,69),wf(:,445))
  call vert_AV_Q(wf(:,69),wf(:,-4),wf(:,446))
  call prop_A_Q(wf(:,446),Q(:,29),MT,1_intkind1,wf(:,447))
  call vert_AV_Q(wf(:,69),wf(:,-5),wf(:,448))
  call prop_A_Q(wf(:,448),Q(:,45),MT,1_intkind1,wf(:,449))
  call vert_VQ_A(wf(:,43),wf(:,-1),wf(:,450))
  call prop_Q_A(wf(:,450),Q(:,27),MT,1_intkind1,wf(:,451))
  call vert_AV_Q(wf(:,-2),wf(:,43),wf(:,452))
  call prop_A_Q(wf(:,452),Q(:,29),MT,1_intkind1,wf(:,453))
  call vert_UV_W(wf(:,43),Q(:,25),wf(:,-5),Q(:,32),wf(:,454))
  call vert_VQ_A(wf(:,46),wf(:,-1),wf(:,455))
  call prop_Q_A(wf(:,455),Q(:,43),MT,1_intkind1,wf(:,456))
  call vert_AV_Q(wf(:,-2),wf(:,46),wf(:,457))
  call prop_A_Q(wf(:,457),Q(:,45),MT,1_intkind1,wf(:,458))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,46),Q(:,41),wf(:,459))
  call vert_QA_V(wf(:,88),wf(:,-2),wf(:,460))
  call vert_VQ_A(wf(:,-4),wf(:,88),wf(:,461))
  call prop_Q_A(wf(:,461),Q(:,27),MT,1_intkind1,wf(:,462))
  call vert_VQ_A(wf(:,-5),wf(:,88),wf(:,463))
  call prop_Q_A(wf(:,463),Q(:,43),MT,1_intkind1,wf(:,464))
  call vert_QA_V(wf(:,0),wf(:,85),wf(:,465))
  call vert_VQ_A(wf(:,15),wf(:,0),wf(:,466))
  call prop_Q_A(wf(:,466),Q(:,27),MT,1_intkind1,wf(:,467))
  call vert_VQ_A(wf(:,14),wf(:,0),wf(:,468))
  call prop_Q_A(wf(:,468),Q(:,43),MT,1_intkind1,wf(:,469))
  call vert_AV_Q(wf(:,85),wf(:,-4),wf(:,470))
  call prop_A_Q(wf(:,470),Q(:,30),MT,1_intkind1,wf(:,471))
  call vert_AV_Q(wf(:,85),wf(:,-5),wf(:,472))
  call prop_A_Q(wf(:,472),Q(:,46),MT,1_intkind1,wf(:,473))
  call vert_AV_Q(wf(:,-2),wf(:,15),wf(:,474))
  call prop_A_Q(wf(:,474),Q(:,30),MT,1_intkind1,wf(:,475))
  call vert_UV_W(wf(:,15),Q(:,26),wf(:,-5),Q(:,32),wf(:,476))
  call vert_AV_Q(wf(:,-2),wf(:,14),wf(:,477))
  call prop_A_Q(wf(:,477),Q(:,46),MT,1_intkind1,wf(:,478))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,14),Q(:,42),wf(:,479))
  call vert_VQ_A(wf(:,83),wf(:,-1),wf(:,480))
  call prop_Q_A(wf(:,480),Q(:,23),MT,1_intkind1,wf(:,481))
  call vert_AV_Q(wf(:,-3),wf(:,83),wf(:,482))
  call prop_A_Q(wf(:,482),Q(:,29),MT,1_intkind1,wf(:,483))
  call vert_UV_W(wf(:,83),Q(:,21),wf(:,-5),Q(:,32),wf(:,484))
  call vert_VQ_A(wf(:,50),wf(:,-1),wf(:,485))
  call prop_Q_A(wf(:,485),Q(:,27),MT,1_intkind1,wf(:,486))
  call vert_AV_Q(wf(:,-2),wf(:,50),wf(:,487))
  call prop_A_Q(wf(:,487),Q(:,29),MT,1_intkind1,wf(:,488))
  call vert_UV_W(wf(:,50),Q(:,25),wf(:,-5),Q(:,32),wf(:,489))
  call vert_QA_V(wf(:,159),wf(:,-2),wf(:,490))
  call vert_QA_V(wf(:,159),wf(:,-3),wf(:,491))
  call vert_VQ_A(wf(:,70),wf(:,0),wf(:,492))
  call prop_Q_A(wf(:,492),Q(:,23),MT,1_intkind1,wf(:,493))
  call vert_VQ_A(wf(:,25),wf(:,0),wf(:,494))
  call prop_Q_A(wf(:,494),Q(:,27),MT,1_intkind1,wf(:,495))
  call vert_AV_Q(wf(:,-3),wf(:,70),wf(:,496))
  call prop_A_Q(wf(:,496),Q(:,30),MT,1_intkind1,wf(:,497))
  call vert_UV_W(wf(:,70),Q(:,22),wf(:,-5),Q(:,32),wf(:,498))
  call vert_AV_Q(wf(:,-2),wf(:,25),wf(:,499))
  call prop_A_Q(wf(:,499),Q(:,30),MT,1_intkind1,wf(:,500))
  call vert_UV_W(wf(:,25),Q(:,26),wf(:,-5),Q(:,32),wf(:,501))
  call vert_QA_V(wf(:,130),wf(:,-2),wf(:,502))
  call vert_QA_V(wf(:,130),wf(:,-3),wf(:,503))
  call vert_VQ_A(wf(:,89),wf(:,-1),wf(:,504))
  call prop_Q_A(wf(:,504),Q(:,23),MT,1_intkind1,wf(:,505))
  call vert_VQ_A(wf(:,77),wf(:,0),wf(:,506))
  call prop_Q_A(wf(:,506),Q(:,23),MT,1_intkind1,wf(:,507))
  call vert_AV_Q(wf(:,-3),wf(:,89),wf(:,508))
  call prop_A_Q(wf(:,508),Q(:,29),MT,1_intkind1,wf(:,509))
  call vert_UV_W(wf(:,89),Q(:,21),wf(:,-5),Q(:,32),wf(:,510))
  call vert_QA_V(wf(:,0),wf(:,211),wf(:,511))
  call vert_AV_Q(wf(:,-3),wf(:,77),wf(:,512))
  call prop_A_Q(wf(:,512),Q(:,30),MT,1_intkind1,wf(:,513))
  call vert_UV_W(wf(:,77),Q(:,22),wf(:,-5),Q(:,32),wf(:,514))
  call vert_QA_V(wf(:,-1),wf(:,211),wf(:,515))
  call vert_VQ_A(wf(:,59),wf(:,-1),wf(:,516))
  call prop_Q_A(wf(:,516),Q(:,27),MT,1_intkind1,wf(:,517))
  call vert_VQ_A(wf(:,34),wf(:,0),wf(:,518))
  call prop_Q_A(wf(:,518),Q(:,27),MT,1_intkind1,wf(:,519))
  call vert_AV_Q(wf(:,-2),wf(:,59),wf(:,520))
  call prop_A_Q(wf(:,520),Q(:,29),MT,1_intkind1,wf(:,521))
  call vert_UV_W(wf(:,59),Q(:,25),wf(:,-5),Q(:,32),wf(:,522))
  call vert_QA_V(wf(:,0),wf(:,191),wf(:,523))
  call vert_AV_Q(wf(:,-2),wf(:,34),wf(:,524))
  call prop_A_Q(wf(:,524),Q(:,30),MT,1_intkind1,wf(:,525))
  call vert_UV_W(wf(:,34),Q(:,26),wf(:,-5),Q(:,32),wf(:,526))
  call vert_QA_V(wf(:,-1),wf(:,191),wf(:,527))
  call vert_VQ_A(wf(:,90),wf(:,-1),wf(:,528))
  call prop_Q_A(wf(:,528),Q(:,39),MT,1_intkind1,wf(:,529))
  call vert_AV_Q(wf(:,-3),wf(:,90),wf(:,530))
  call prop_A_Q(wf(:,530),Q(:,45),MT,1_intkind1,wf(:,531))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,90),Q(:,37),wf(:,532))
  call vert_VQ_A(wf(:,60),wf(:,-1),wf(:,533))
  call prop_Q_A(wf(:,533),Q(:,43),MT,1_intkind1,wf(:,534))
  call vert_AV_Q(wf(:,-2),wf(:,60),wf(:,535))
  call prop_A_Q(wf(:,535),Q(:,45),MT,1_intkind1,wf(:,536))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,60),Q(:,41),wf(:,537))
  call vert_QA_V(wf(:,161),wf(:,-2),wf(:,538))
  call vert_QA_V(wf(:,161),wf(:,-3),wf(:,539))
  call vert_VQ_A(wf(:,78),wf(:,0),wf(:,540))
  call prop_Q_A(wf(:,540),Q(:,39),MT,1_intkind1,wf(:,541))
  call vert_VQ_A(wf(:,36),wf(:,0),wf(:,542))
  call prop_Q_A(wf(:,542),Q(:,43),MT,1_intkind1,wf(:,543))
  call vert_AV_Q(wf(:,-3),wf(:,78),wf(:,544))
  call prop_A_Q(wf(:,544),Q(:,46),MT,1_intkind1,wf(:,545))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,78),Q(:,38),wf(:,546))
  call vert_AV_Q(wf(:,-2),wf(:,36),wf(:,547))
  call prop_A_Q(wf(:,547),Q(:,46),MT,1_intkind1,wf(:,548))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,36),Q(:,42),wf(:,549))
  call vert_QA_V(wf(:,134),wf(:,-2),wf(:,550))
  call vert_QA_V(wf(:,134),wf(:,-3),wf(:,551))
  call vert_VQ_A(wf(:,91),wf(:,-1),wf(:,552))
  call prop_Q_A(wf(:,552),Q(:,39),MT,1_intkind1,wf(:,553))
  call vert_VQ_A(wf(:,80),wf(:,0),wf(:,554))
  call prop_Q_A(wf(:,554),Q(:,39),MT,1_intkind1,wf(:,555))
  call vert_AV_Q(wf(:,-3),wf(:,91),wf(:,556))
  call prop_A_Q(wf(:,556),Q(:,45),MT,1_intkind1,wf(:,557))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,91),Q(:,37),wf(:,558))
  call vert_QA_V(wf(:,0),wf(:,214),wf(:,559))
  call vert_AV_Q(wf(:,-3),wf(:,80),wf(:,560))
  call prop_A_Q(wf(:,560),Q(:,46),MT,1_intkind1,wf(:,561))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,80),Q(:,38),wf(:,562))
  call vert_QA_V(wf(:,-1),wf(:,214),wf(:,563))
  call vert_VQ_A(wf(:,62),wf(:,-1),wf(:,564))
  call prop_Q_A(wf(:,564),Q(:,43),MT,1_intkind1,wf(:,565))
  call vert_VQ_A(wf(:,38),wf(:,0),wf(:,566))
  call prop_Q_A(wf(:,566),Q(:,43),MT,1_intkind1,wf(:,567))
  call vert_AV_Q(wf(:,-2),wf(:,62),wf(:,568))
  call prop_A_Q(wf(:,568),Q(:,45),MT,1_intkind1,wf(:,569))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,62),Q(:,41),wf(:,570))
  call vert_QA_V(wf(:,0),wf(:,196),wf(:,571))
  call vert_AV_Q(wf(:,-2),wf(:,38),wf(:,572))
  call prop_A_Q(wf(:,572),Q(:,46),MT,1_intkind1,wf(:,573))
  call vert_UV_W(wf(:,-4),Q(:,16),wf(:,38),Q(:,42),wf(:,574))
  call vert_QA_V(wf(:,-1),wf(:,196),wf(:,575))
  call vert_QA_V(wf(:,64),wf(:,-2),wf(:,576))
  call vert_QA_V(wf(:,0),wf(:,215),wf(:,577))
  call vert_QA_V(wf(:,64),wf(:,-3),wf(:,578))
  call vert_QA_V(wf(:,0),wf(:,198),wf(:,579))
  call vert_QA_V(wf(:,41),wf(:,-2),wf(:,580))
  call vert_QA_V(wf(:,-1),wf(:,215),wf(:,581))
  call vert_QA_V(wf(:,41),wf(:,-3),wf(:,582))
  call vert_QA_V(wf(:,-1),wf(:,198),wf(:,583))

  call denominators()
  call diagrams(A)
  call colourvectors(A, M1, M2)
end subroutine tree_wavefunctions


subroutine denominators()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none
  ! propagators
  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,10))
  den(4) = 1 / (Q(5,9))
  den(5) = 1 / (Q(5,6))
  den(7) = 1 / (Q(5,48))
  den(9) = 1 / (Q(5,21))
  den(12) = 1 / (Q(5,26))
  den(15) = 1 / (Q(5,18) - MT2)
  den(16) = 1 / (Q(5,40) - MT2)
  den(19) = 1 / (Q(5,13) - MT2)
  den(24) = 1 / (Q(5,34) - MT2)
  den(25) = 1 / (Q(5,24) - MT2)
  den(28) = 1 / (Q(5,7) - MT2)
  den(34) = 1 / (Q(5,42))
  den(41) = 1 / (Q(5,50) - MT2)
  den(45) = 1 / (Q(5,25))
  den(48) = 1 / (Q(5,22))
  den(51) = 1 / (Q(5,17) - MT2)
  den(56) = 1 / (Q(5,14) - MT2)
  den(59) = 1 / (Q(5,33) - MT2)
  den(66) = 1 / (Q(5,41))
  den(74) = 1 / (Q(5,49) - MT2)
  den(77) = 1 / (Q(5,36) - MT2)
  den(84) = 1 / (Q(5,20) - MT2)
  den(87) = 1 / (Q(5,11) - MT2)
  den(93) = 1 / (Q(5,38))
  den(113) = 1 / (Q(5,37))
  den(138) = 1 / (Q(5,58))
  den(141) = 1 / (Q(5,53))
  den(154) = 1 / (Q(5,54))
  den(157) = 1 / (Q(5,57))
  den(183) = 1 / (Q(5,56) - MT2)
  den(193) = 1 / (Q(5,52) - MT2)
  den(232) = 1 / (Q(5,15))
  den(247) = 1 / (Q(5,45) - MT2)
  den(250) = 1 / (Q(5,23) - MT2)
  den(264) = 1 / (Q(5,29) - MT2)
  den(267) = 1 / (Q(5,39) - MT2)
  den(315) = 1 / (Q(5,46) - MT2)
  den(331) = 1 / (Q(5,30) - MT2)
  den(370) = 1 / (Q(5,27) - MT2)
  den(385) = 1 / (Q(5,43) - MT2)

  ! denominators
  den(3) = den(1)*den(2)
  den(6) = den(4)*den(5)
  den(8) = den(3)*den(7)
  den(10) = den(1)*den(9)
  den(11) = den(2)*den(10)
  den(13) = den(2)*den(12)
  den(14) = den(1)*den(13)
  den(17) = den(1)*den(15)
  den(18) = den(16)*den(17)
  den(20) = den(1)*den(19)
  den(21) = den(15)*den(20)
  den(22) = den(12)*den(15)
  den(23) = den(1)*den(22)
  den(26) = den(1)*den(24)
  den(27) = den(25)*den(26)
  den(29) = den(1)*den(28)
  den(30) = den(25)*den(29)
  den(31) = den(12)*den(25)
  den(32) = den(1)*den(31)
  den(33) = den(20)*den(24)
  den(35) = den(24)*den(34)
  den(36) = den(1)*den(35)
  den(37) = den(16)*den(29)
  den(38) = den(16)*den(34)
  den(39) = den(1)*den(38)
  den(40) = den(7)*den(29)
  den(42) = den(7)*den(41)
  den(43) = den(1)*den(42)
  den(44) = den(6)*den(7)
  den(46) = den(4)*den(45)
  den(47) = den(5)*den(46)
  den(49) = den(5)*den(48)
  den(50) = den(4)*den(49)
  den(52) = den(5)*den(51)
  den(53) = den(16)*den(52)
  den(54) = den(45)*den(51)
  den(55) = den(5)*den(54)
  den(57) = den(5)*den(56)
  den(58) = den(51)*den(57)
  den(60) = den(5)*den(59)
  den(61) = den(25)*den(60)
  den(62) = den(5)*den(28)
  den(63) = den(25)*den(62)
  den(64) = den(25)*den(45)
  den(65) = den(5)*den(64)
  den(67) = den(59)*den(66)
  den(68) = den(5)*den(67)
  den(69) = den(57)*den(59)
  den(70) = den(16)*den(62)
  den(71) = den(16)*den(66)
  den(72) = den(5)*den(71)
  den(73) = den(7)*den(62)
  den(75) = den(7)*den(74)
  den(76) = den(5)*den(75)
  den(78) = den(4)*den(15)
  den(79) = den(77)*den(78)
  den(80) = den(4)*den(19)
  den(81) = den(15)*den(80)
  den(82) = den(15)*den(48)
  den(83) = den(4)*den(82)
  den(85) = den(4)*den(24)
  den(86) = den(84)*den(85)
  den(88) = den(4)*den(87)
  den(89) = den(84)*den(88)
  den(90) = den(48)*den(84)
  den(91) = den(4)*den(90)
  den(92) = den(24)*den(80)
  den(94) = den(24)*den(93)
  den(95) = den(4)*den(94)
  den(96) = den(77)*den(88)
  den(97) = den(77)*den(93)
  den(98) = den(4)*den(97)
  den(99) = den(7)*den(88)
  den(100) = den(4)*den(42)
  den(101) = den(2)*den(51)
  den(102) = den(77)*den(101)
  den(103) = den(9)*den(51)
  den(104) = den(2)*den(103)
  den(105) = den(2)*den(56)
  den(106) = den(51)*den(105)
  den(107) = den(2)*den(59)
  den(108) = den(84)*den(107)
  den(109) = den(2)*den(87)
  den(110) = den(84)*den(109)
  den(111) = den(9)*den(84)
  den(112) = den(2)*den(111)
  den(114) = den(59)*den(113)
  den(115) = den(2)*den(114)
  den(116) = den(59)*den(105)
  den(117) = den(77)*den(109)
  den(118) = den(77)*den(113)
  den(119) = den(2)*den(118)
  den(120) = den(7)*den(109)
  den(121) = den(2)*den(75)
  den(122) = den(24)*den(103)
  den(123) = den(51)*den(94)
  den(124) = den(51)*den(97)
  den(125) = den(38)*den(51)
  den(126) = den(15)*den(114)
  den(127) = den(59)*den(82)
  den(128) = den(15)*den(118)
  den(129) = den(15)*den(71)
  den(130) = den(59)*den(90)
  den(131) = den(24)*den(111)
  den(132) = den(16)*den(111)
  den(133) = den(71)*den(84)
  den(134) = den(31)*den(59)
  den(135) = den(24)*den(64)
  den(136) = den(25)*den(118)
  den(137) = den(64)*den(77)
  den(139) = den(2)*den(138)
  den(140) = den(1)*den(139)
  den(142) = den(1)*den(141)
  den(143) = den(2)*den(142)
  den(144) = den(1)*den(113)
  den(145) = den(2)*den(144)
  den(146) = den(2)*den(34)
  den(147) = den(1)*den(146)
  den(148) = den(15)*den(144)
  den(149) = den(15)*den(41)
  den(150) = den(1)*den(149)
  den(151) = den(10)*den(24)
  den(152) = den(24)*den(41)
  den(153) = den(1)*den(152)
  den(155) = den(5)*den(154)
  den(156) = den(4)*den(155)
  den(158) = den(4)*den(157)
  den(159) = den(5)*den(158)
  den(160) = den(4)*den(66)
  den(161) = den(5)*den(160)
  den(162) = den(5)*den(93)
  den(163) = den(4)*den(162)
  den(164) = den(51)*den(74)
  den(165) = den(5)*den(164)
  den(166) = den(51)*den(162)
  den(167) = den(59)*den(74)
  den(168) = den(5)*den(167)
  den(169) = den(49)*den(59)
  den(170) = den(15)*den(160)
  den(171) = den(4)*den(149)
  den(172) = den(24)*den(46)
  den(173) = den(4)*den(152)
  den(174) = den(2)*den(164)
  den(175) = den(51)*den(146)
  den(176) = den(2)*den(167)
  den(177) = den(13)*den(59)
  den(178) = den(24)*den(54)
  den(179) = den(35)*den(51)
  den(180) = den(15)*den(67)
  den(181) = den(22)*den(59)
  den(182) = den(25)*den(144)
  den(184) = den(25)*den(183)
  den(185) = den(1)*den(184)
  den(186) = den(10)*den(16)
  den(187) = den(16)*den(183)
  den(188) = den(1)*den(187)
  den(189) = den(7)*den(20)
  den(190) = den(7)*den(183)
  den(191) = den(1)*den(190)
  den(192) = den(84)*den(160)
  den(194) = den(84)*den(193)
  den(195) = den(4)*den(194)
  den(196) = den(46)*den(77)
  den(197) = den(77)*den(193)
  den(198) = den(4)*den(197)
  den(199) = den(7)*den(80)
  den(200) = den(7)*den(193)
  den(201) = den(4)*den(200)
  den(202) = den(54)*den(77)
  den(203) = den(16)*den(103)
  den(204) = den(67)*den(84)
  den(205) = den(25)*den(114)
  den(206) = den(5)*den(184)
  den(207) = den(25)*den(162)
  den(208) = den(5)*den(187)
  den(209) = den(16)*den(49)
  den(210) = den(5)*den(190)
  den(211) = den(7)*den(57)
  den(212) = den(2)*den(194)
  den(213) = den(84)*den(146)
  den(214) = den(2)*den(197)
  den(215) = den(13)*den(77)
  den(216) = den(2)*den(200)
  den(217) = den(7)*den(105)
  den(218) = den(22)*den(77)
  den(219) = den(16)*den(82)
  den(220) = den(35)*den(84)
  den(221) = den(38)*den(84)
  den(222) = den(16)*den(90)
  den(223) = den(25)*den(94)
  den(224) = den(31)*den(77)
  den(225) = den(25)*den(97)
  den(226) = den(2)*den(7)
  den(227) = den(138)*den(226)
  den(228) = den(1)*den(227)
  den(229) = den(1)*den(7)
  den(230) = den(141)*den(229)
  den(231) = den(2)*den(230)
  den(233) = den(3)*den(232)
  den(234) = den(7)*den(233)
  den(235) = den(1)**2
  den(236) = den(146)*den(235)
  den(237) = den(13)*den(235)
  den(238) = den(2)**2
  den(239) = den(144)*den(238)
  den(240) = den(10)*den(238)
  den(241) = den(10)*den(146)
  den(242) = den(13)*den(144)
  den(243) = den(15)*den(16)
  den(244) = den(138)*den(243)
  den(245) = den(1)*den(244)
  den(246) = den(1)*den(16)
  den(248) = den(246)*den(247)
  den(249) = den(15)*den(248)
  den(251) = den(17)*den(250)
  den(252) = den(16)*den(251)
  den(253) = den(149)*den(235)
  den(254) = den(22)*den(235)
  den(255) = den(15)**2
  den(256) = den(144)*den(255)
  den(257) = den(20)*den(255)
  den(258) = den(20)*den(149)
  den(259) = den(22)*den(144)
  den(260) = den(24)*den(25)
  den(261) = den(138)*den(260)
  den(262) = den(1)*den(261)
  den(263) = den(1)*den(25)
  den(265) = den(263)*den(264)
  den(266) = den(24)*den(265)
  den(268) = den(26)*den(267)
  den(269) = den(25)*den(268)
  den(270) = den(184)*den(235)
  den(271) = den(31)*den(235)
  den(272) = den(25)**2
  den(273) = den(144)*den(272)
  den(274) = den(29)*den(184)
  den(275) = den(31)*den(144)
  den(276) = den(29)*den(272)
  den(277) = den(152)*den(235)
  den(278) = den(35)*den(235)
  den(279) = den(24)**2
  den(280) = den(10)*den(279)
  den(281) = den(20)*den(279)
  den(282) = den(20)*den(152)
  den(283) = den(10)*den(35)
  den(284) = den(187)*den(235)
  den(285) = den(38)*den(235)
  den(286) = den(16)**2
  den(287) = den(10)*den(286)
  den(288) = den(29)*den(187)
  den(289) = den(10)*den(38)
  den(290) = den(29)*den(286)
  den(291) = den(190)*den(235)
  den(292) = den(42)*den(235)
  den(293) = den(29)*den(190)
  den(294) = den(20)*den(42)
  den(295) = den(7)**2
  den(296) = den(20)*den(295)
  den(297) = den(29)*den(295)
  den(298) = den(5)*den(7)
  den(299) = den(154)*den(298)
  den(300) = den(4)*den(299)
  den(301) = den(4)*den(7)
  den(302) = den(157)*den(301)
  den(303) = den(5)*den(302)
  den(304) = den(6)*den(232)
  den(305) = den(7)*den(304)
  den(306) = den(4)**2
  den(307) = den(162)*den(306)
  den(308) = den(49)*den(306)
  den(309) = den(5)**2
  den(310) = den(160)*den(309)
  den(311) = den(46)*den(309)
  den(312) = den(46)*den(162)
  den(313) = den(49)*den(160)
  den(314) = den(5)*den(16)
  den(316) = den(314)*den(315)
  den(317) = den(51)*den(316)
  den(318) = den(16)*den(51)
  den(319) = den(157)*den(318)
  den(320) = den(5)*den(319)
  den(321) = den(52)*den(250)
  den(322) = den(16)*den(321)
  den(323) = den(51)**2
  den(324) = den(162)*den(323)
  den(325) = den(57)*den(323)
  den(326) = den(164)*den(309)
  den(327) = den(54)*den(309)
  den(328) = den(54)*den(162)
  den(329) = den(57)*den(164)
  den(330) = den(5)*den(25)
  den(332) = den(330)*den(331)
  den(333) = den(59)*den(332)
  den(334) = den(25)*den(59)
  den(335) = den(157)*den(334)
  den(336) = den(5)*den(335)
  den(337) = den(60)*den(267)
  den(338) = den(25)*den(337)
  den(339) = den(184)*den(309)
  den(340) = den(162)*den(272)
  den(341) = den(62)*den(184)
  den(342) = den(64)*den(162)
  den(343) = den(64)*den(309)
  den(344) = den(62)*den(272)
  den(345) = den(59)**2
  den(346) = den(49)*den(345)
  den(347) = den(57)*den(345)
  den(348) = den(167)*den(309)
  den(349) = den(67)*den(309)
  den(350) = den(49)*den(67)
  den(351) = den(57)*den(167)
  den(352) = den(187)*den(309)
  den(353) = den(49)*den(286)
  den(354) = den(62)*den(187)
  den(355) = den(49)*den(71)
  den(356) = den(71)*den(309)
  den(357) = den(62)*den(286)
  den(358) = den(190)*den(309)
  den(359) = den(62)*den(190)
  den(360) = den(57)*den(75)
  den(361) = den(57)*den(295)
  den(362) = den(75)*den(309)
  den(363) = den(62)*den(295)
  den(364) = den(15)*den(77)
  den(365) = den(154)*den(364)
  den(366) = den(4)*den(365)
  den(367) = den(4)*den(77)
  den(368) = den(247)*den(367)
  den(369) = den(15)*den(368)
  den(371) = den(78)*den(370)
  den(372) = den(77)*den(371)
  den(373) = den(149)*den(306)
  den(374) = den(82)*den(306)
  den(375) = den(160)*den(255)
  den(376) = den(80)*den(255)
  den(377) = den(80)*den(149)
  den(378) = den(82)*den(160)
  den(379) = den(24)*den(84)
  den(380) = den(154)*den(379)
  den(381) = den(4)*den(380)
  den(382) = den(4)*den(84)
  den(383) = den(264)*den(382)
  den(384) = den(24)*den(383)
  den(386) = den(85)*den(385)
  den(387) = den(84)*den(386)
  den(388) = den(194)*den(306)
  den(389) = den(90)*den(306)
  den(390) = den(84)**2
  den(391) = den(160)*den(390)
  den(392) = den(88)*den(194)
  den(393) = den(90)*den(160)
  den(394) = den(88)*den(390)
  den(395) = den(152)*den(306)
  den(396) = den(94)*den(306)
  den(397) = den(46)*den(279)
  den(398) = den(80)*den(279)
  den(399) = den(80)*den(152)
  den(400) = den(46)*den(94)
  den(401) = den(197)*den(306)
  den(402) = den(97)*den(306)
  den(403) = den(77)**2
  den(404) = den(46)*den(403)
  den(405) = den(88)*den(197)
  den(406) = den(46)*den(97)
  den(407) = den(88)*den(403)
  den(408) = den(200)*den(306)
  den(409) = den(42)*den(306)
  den(410) = den(88)*den(200)
  den(411) = den(42)*den(80)
  den(412) = den(80)*den(295)
  den(413) = den(88)*den(295)
  den(414) = den(2)*den(77)
  den(415) = den(315)*den(414)
  den(416) = den(51)*den(415)
  den(417) = den(51)*den(77)
  den(418) = den(141)*den(417)
  den(419) = den(2)*den(418)
  den(420) = den(101)*den(370)
  den(421) = den(77)*den(420)
  den(422) = den(146)*den(323)
  den(423) = den(105)*den(323)
  den(424) = den(164)*den(238)
  den(425) = den(103)*den(238)
  den(426) = den(103)*den(146)
  den(427) = den(105)*den(164)
  den(428) = den(2)*den(84)
  den(429) = den(331)*den(428)
  den(430) = den(59)*den(429)
  den(431) = den(59)*den(84)
  den(432) = den(141)*den(431)
  den(433) = den(2)*den(432)
  den(434) = den(107)*den(385)
  den(435) = den(84)*den(434)
  den(436) = den(194)*den(238)
  den(437) = den(146)*den(390)
  den(438) = den(109)*den(194)
  den(439) = den(111)*den(146)
  den(440) = den(111)*den(238)
  den(441) = den(109)*den(390)
  den(442) = den(13)*den(345)
  den(443) = den(105)*den(345)
  den(444) = den(167)*den(238)
  den(445) = den(114)*den(238)
  den(446) = den(13)*den(114)
  den(447) = den(105)*den(167)
  den(448) = den(197)*den(238)
  den(449) = den(13)*den(403)
  den(450) = den(109)*den(197)
  den(451) = den(13)*den(118)
  den(452) = den(118)*den(238)
  den(453) = den(109)*den(403)
  den(454) = den(200)*den(238)
  den(455) = den(109)*den(200)
  den(456) = den(75)*den(105)
  den(457) = den(105)*den(295)
  den(458) = den(75)*den(238)
  den(459) = den(109)*den(295)
  den(460) = den(35)*den(323)
  den(461) = den(94)*den(323)
  den(462) = den(54)*den(279)
  den(463) = den(103)*den(279)
  den(464) = den(35)*den(103)
  den(465) = den(54)*den(94)
  den(466) = den(97)*den(323)
  den(467) = den(54)*den(403)
  den(468) = den(54)*den(97)
  den(469) = den(38)*den(323)
  den(470) = den(38)*den(103)
  den(471) = den(103)*den(286)
  den(472) = den(22)*den(345)
  den(473) = den(82)*den(345)
  den(474) = den(67)*den(255)
  den(475) = den(114)*den(255)
  den(476) = den(22)*den(114)
  den(477) = den(67)*den(82)
  den(478) = den(22)*den(403)
  den(479) = den(22)*den(118)
  den(480) = den(118)*den(255)
  den(481) = den(71)*den(82)
  den(482) = den(82)*den(286)
  den(483) = den(71)*den(255)
  den(484) = den(90)*den(345)
  den(485) = den(67)*den(390)
  den(486) = den(67)*den(90)
  den(487) = den(35)*den(390)
  den(488) = den(35)*den(111)
  den(489) = den(111)*den(279)
  den(490) = den(38)*den(111)
  den(491) = den(71)*den(90)
  den(492) = den(38)*den(390)
  den(493) = den(90)*den(286)
  den(494) = den(71)*den(390)
  den(495) = den(111)*den(286)
  den(496) = den(31)*den(345)
  den(497) = den(31)*den(114)
  den(498) = den(114)*den(272)
  den(499) = den(64)*den(94)
  den(500) = den(94)*den(272)
  den(501) = den(64)*den(279)
  den(502) = den(31)*den(118)
  den(503) = den(64)*den(97)
  den(504) = den(31)*den(403)
  den(505) = den(97)*den(272)
  den(506) = den(64)*den(403)
  den(507) = den(118)*den(272)
  den(508) = den(29)*den(232)
  den(509) = den(29)*den(250)
  den(510) = den(29)*den(267)
  den(511) = den(20)*den(232)
  den(512) = den(20)*den(264)
  den(513) = den(20)*den(247)
  den(514) = den(10)*den(250)
  den(515) = den(10)*den(264)
  den(516) = den(10)*den(141)
  den(517) = den(144)*den(267)
  den(518) = den(144)*den(247)
  den(519) = den(141)*den(144)
  den(520) = den(62)*den(232)
  den(521) = den(62)*den(250)
  den(522) = den(62)*den(267)
  den(523) = den(57)*den(232)
  den(524) = den(49)*den(250)
  den(525) = den(162)*den(267)
  den(526) = den(57)*den(331)
  den(527) = den(57)*den(315)
  den(528) = den(49)*den(331)
  den(529) = den(49)*den(154)
  den(530) = den(162)*den(315)
  den(531) = den(154)*den(162)
  den(532) = den(88)*den(232)
  den(533) = den(88)*den(370)
  den(534) = den(88)*den(385)
  den(535) = den(80)*den(232)
  den(536) = den(80)*den(264)
  den(537) = den(80)*den(247)
  den(538) = den(46)*den(370)
  den(539) = den(46)*den(264)
  den(540) = den(46)*den(157)
  den(541) = den(160)*den(385)
  den(542) = den(160)*den(247)
  den(543) = den(157)*den(160)
  den(544) = den(109)*den(232)
  den(545) = den(109)*den(370)
  den(546) = den(109)*den(385)
  den(547) = den(105)*den(232)
  den(548) = den(13)*den(370)
  den(549) = den(146)*den(385)
  den(550) = den(105)*den(331)
  den(551) = den(105)*den(315)
  den(552) = den(13)*den(331)
  den(553) = den(13)*den(138)
  den(554) = den(146)*den(315)
  den(555) = den(138)*den(146)
  den(556) = den(103)*den(250)
  den(557) = den(103)*den(264)
  den(558) = den(103)*den(141)
  den(559) = den(54)*den(370)
  den(560) = den(54)*den(264)
  den(561) = den(54)*den(157)
  den(562) = den(141)*den(164)
  den(563) = den(157)*den(164)
  den(564) = den(82)*den(250)
  den(565) = den(22)*den(370)
  den(566) = den(82)*den(331)
  den(567) = den(82)*den(154)
  den(568) = den(22)*den(331)
  den(569) = den(22)*den(138)
  den(570) = den(149)*den(154)
  den(571) = den(138)*den(149)
  den(572) = den(111)*den(250)
  den(573) = den(90)*den(250)
  den(574) = den(111)*den(264)
  den(575) = den(111)*den(141)
  den(576) = den(141)*den(194)
  den(577) = den(90)*den(331)
  den(578) = den(90)*den(154)
  den(579) = den(154)*den(194)
  den(580) = den(64)*den(370)
  den(581) = den(31)*den(370)
  den(582) = den(64)*den(264)
  den(583) = den(64)*den(157)
  den(584) = den(157)*den(184)
  den(585) = den(31)*den(331)
  den(586) = den(31)*den(138)
  den(587) = den(138)*den(184)
  den(588) = den(114)*den(267)
  den(589) = den(114)*den(247)
  den(590) = den(114)*den(141)
  den(591) = den(67)*den(385)
  den(592) = den(67)*den(247)
  den(593) = den(67)*den(157)
  den(594) = den(141)*den(167)
  den(595) = den(157)*den(167)
  den(596) = den(94)*den(267)
  den(597) = den(35)*den(385)
  den(598) = den(94)*den(315)
  den(599) = den(94)*den(154)
  den(600) = den(35)*den(315)
  den(601) = den(35)*den(138)
  den(602) = den(152)*den(154)
  den(603) = den(138)*den(152)
  den(604) = den(118)*den(267)
  den(605) = den(97)*den(267)
  den(606) = den(118)*den(247)
  den(607) = den(118)*den(141)
  den(608) = den(141)*den(197)
  den(609) = den(97)*den(315)
  den(610) = den(97)*den(154)
  den(611) = den(154)*den(197)
  den(612) = den(71)*den(385)
  den(613) = den(38)*den(385)
  den(614) = den(71)*den(247)
  den(615) = den(71)*den(157)
  den(616) = den(157)*den(187)
  den(617) = den(38)*den(315)
  den(618) = den(38)*den(138)
  den(619) = den(138)*den(187)
  den(620) = den(75)*den(141)
  den(621) = den(141)*den(200)
  den(622) = den(75)*den(157)
  den(623) = den(157)*den(190)
  den(624) = den(42)*den(154)
  den(625) = den(154)*den(200)
  den(626) = den(42)*den(138)
  den(627) = den(138)*den(190)
  den(628) = den(1)*den(2)*den(7)
  den(629) = den(1)*den(15)*den(16)
  den(630) = den(1)*den(24)*den(25)
  den(631) = den(4)*den(5)*den(7)
  den(632) = den(5)*den(16)*den(51)
  den(633) = den(5)*den(25)*den(59)
  den(634) = den(4)*den(15)*den(77)
  den(635) = den(4)*den(24)*den(84)
  den(636) = den(2)*den(51)*den(77)
  den(637) = den(2)*den(59)*den(84)
  den(638) = den(24)*den(51)
  den(639) = den(15)*den(59)
  den(640) = den(16)*den(84)
  den(641) = den(25)*den(77)
  den(642) = den(1)*den(226)
  den(643) = den(2)*den(229)
  den(644) = den(4)*den(298)
  den(645) = den(5)*den(301)
  den(646) = den(2)*den(516)
  den(647) = den(2)*den(519)
  den(648) = den(1)*den(553)
  den(649) = den(1)*den(555)
  den(650) = den(15)*den(513)
  den(651) = den(15)*den(518)
  den(652) = den(1)*den(569)
  den(653) = den(1)*den(571)
  den(654) = den(25)*den(510)
  den(655) = den(25)*den(517)
  den(656) = den(1)*den(586)
  den(657) = den(1)*den(587)
  den(658) = den(24)*den(512)
  den(659) = den(24)*den(515)
  den(660) = den(1)*den(601)
  den(661) = den(1)*den(603)
  den(662) = den(16)*den(509)
  den(663) = den(16)*den(514)
  den(664) = den(1)*den(618)
  den(665) = den(1)*den(619)
  den(666) = den(7)*den(508)
  den(667) = den(7)*den(511)
  den(668) = den(1)*den(626)
  den(669) = den(1)*den(627)
  den(670) = den(5)*den(540)
  den(671) = den(5)*den(543)
  den(672) = den(4)*den(529)
  den(673) = den(4)*den(531)
  den(674) = den(5)*den(561)
  den(675) = den(5)*den(563)
  den(676) = den(51)*den(527)
  den(677) = den(51)*den(530)
  den(678) = den(25)*den(522)
  den(679) = den(5)*den(583)
  den(680) = den(25)*den(525)
  den(681) = den(5)*den(584)
  den(682) = den(5)*den(593)
  den(683) = den(5)*den(595)
  den(684) = den(59)*den(526)
  den(685) = den(59)*den(528)
  den(686) = den(16)*den(521)
  den(687) = den(5)*den(615)
  den(688) = den(16)*den(524)
  den(689) = den(5)*den(616)
  den(690) = den(7)*den(520)
  den(691) = den(5)*den(622)
  den(692) = den(7)*den(523)
  den(693) = den(5)*den(623)
  den(694) = den(15)*den(537)
  den(695) = den(15)*den(542)
  den(696) = den(4)*den(567)
  den(697) = den(4)*den(570)
  den(698) = den(84)*den(534)
  den(699) = den(84)*den(541)
  den(700) = den(4)*den(578)
  den(701) = den(4)*den(579)
  den(702) = den(24)*den(536)
  den(703) = den(24)*den(539)
  den(704) = den(4)*den(599)
  den(705) = den(4)*den(602)
  den(706) = den(77)*den(533)
  den(707) = den(77)*den(538)
  den(708) = den(4)*den(610)
  den(709) = den(4)*den(611)
  den(710) = den(7)*den(532)
  den(711) = den(7)*den(535)
  den(712) = den(4)*den(624)
  den(713) = den(4)*den(625)
  den(714) = den(2)*den(558)
  den(715) = den(2)*den(562)
  den(716) = den(51)*den(551)
  den(717) = den(51)*den(554)
  den(718) = den(84)*den(546)
  den(719) = den(2)*den(575)
  den(720) = den(84)*den(549)
  den(721) = den(2)*den(576)
  den(722) = den(2)*den(590)
  den(723) = den(2)*den(594)
  den(724) = den(59)*den(550)
  den(725) = den(59)*den(552)
  den(726) = den(77)*den(545)
  den(727) = den(2)*den(607)
  den(728) = den(77)*den(548)
  den(729) = den(2)*den(608)
  den(730) = den(7)*den(544)
  den(731) = den(2)*den(620)
  den(732) = den(7)*den(547)
  den(733) = den(2)*den(621)
  den(734) = den(24)*den(557)
  den(735) = den(24)*den(560)
  den(736) = den(51)*den(598)
  den(737) = den(51)*den(600)
  den(738) = den(77)*den(559)
  den(739) = den(51)*den(609)
  den(740) = den(16)*den(556)
  den(741) = den(51)*den(617)
  den(742) = den(15)*den(589)
  den(743) = den(15)*den(592)
  den(744) = den(59)*den(566)
  den(745) = den(59)*den(568)
  den(746) = den(15)*den(606)
  den(747) = den(77)*den(565)
  den(748) = den(15)*den(614)
  den(749) = den(16)*den(564)
  den(750) = den(84)*den(591)
  den(751) = den(59)*den(577)
  den(752) = den(24)*den(574)
  den(753) = den(84)*den(597)
  den(754) = den(16)*den(572)
  den(755) = den(84)*den(612)
  den(756) = den(16)*den(573)
  den(757) = den(84)*den(613)
  den(758) = den(25)*den(588)
  den(759) = den(59)*den(585)
  den(760) = den(24)*den(582)
  den(761) = den(25)*den(596)
  den(762) = den(25)*den(604)
  den(763) = den(77)*den(580)
  den(764) = den(25)*den(605)
  den(765) = den(77)*den(581)

end subroutine denominators


subroutine diagrams(A)
  ! colour stripped tree amplitudes
  use ol_contractions_/**/REALKIND
  implicit none
  complex(REALKIND), intent(out) :: A(602)

  A(1) = cont_VV(wf(:,2),wf(:,3)) * den(3)
  A(2) = cont_VV(wf(:,2),wf(:,4)) * den(3)
  A(3) = cont_VV(wf(:,2),wf(:,5)) * den(3)
  A(4) = cont_VV(wf(:,7),wf(:,8)) * den(6)
  A(5) = cont_VV(wf(:,7),wf(:,9)) * den(6)
  A(6) = cont_VV(wf(:,7),wf(:,10)) * den(6)
  A(7) = cont_VV(wf(:,11),wf(:,12)) * den(8)
  A(8) = cont_VV(wf(:,13),wf(:,14)) * den(11)
  A(9) = cont_VV(wf(:,15),wf(:,16)) * den(14)
  A(10) = cont_QA(wf(:,20),wf(:,21)) * den(18)
  A(11) = cont_QA(wf(:,23),wf(:,24)) * den(21)
  A(12) = cont_VV(wf(:,16),wf(:,25)) * den(23)
  A(13) = cont_QA(wf(:,29),wf(:,30)) * den(27)
  A(14) = cont_QA(wf(:,32),wf(:,33)) * den(30)
  A(15) = cont_VV(wf(:,16),wf(:,34)) * den(32)
  A(16) = cont_QA(wf(:,24),wf(:,35)) * den(33)
  A(17) = cont_VV(wf(:,13),wf(:,36)) * den(36)
  A(18) = cont_QA(wf(:,33),wf(:,37)) * den(37)
  A(19) = cont_VV(wf(:,13),wf(:,38)) * den(39)
  A(20) = cont_QA(wf(:,33),wf(:,39)) * den(40)
  A(21) = cont_QA(wf(:,22),wf(:,41)) * den(43)
  A(22) = cont_VV(wf(:,11),wf(:,42)) * den(44)
  A(23) = cont_VV(wf(:,43),wf(:,44)) * den(47)
  A(24) = cont_VV(wf(:,45),wf(:,46)) * den(50)
  A(25) = cont_QA(wf(:,20),wf(:,49)) * den(53)
  A(26) = cont_VV(wf(:,44),wf(:,50)) * den(55)
  A(27) = cont_QA(wf(:,52),wf(:,53)) * den(58)
  A(28) = cont_QA(wf(:,29),wf(:,56)) * den(61)
  A(29) = cont_QA(wf(:,32),wf(:,58)) * den(63)
  A(30) = cont_VV(wf(:,44),wf(:,59)) * den(65)
  A(31) = cont_VV(wf(:,45),wf(:,60)) * den(68)
  A(32) = cont_QA(wf(:,53),wf(:,61)) * den(69)
  A(33) = cont_QA(wf(:,37),wf(:,58)) * den(70)
  A(34) = cont_VV(wf(:,45),wf(:,62)) * den(72)
  A(35) = cont_QA(wf(:,39),wf(:,58)) * den(73)
  A(36) = cont_QA(wf(:,51),wf(:,64)) * den(76)
  A(37) = cont_QA(wf(:,66),wf(:,67)) * den(79)
  A(38) = cont_QA(wf(:,23),wf(:,69)) * den(81)
  A(39) = cont_VV(wf(:,46),wf(:,70)) * den(83)
  A(40) = cont_QA(wf(:,72),wf(:,73)) * den(86)
  A(41) = cont_QA(wf(:,75),wf(:,76)) * den(89)
  A(42) = cont_VV(wf(:,46),wf(:,77)) * den(91)
  A(43) = cont_QA(wf(:,35),wf(:,69)) * den(92)
  A(44) = cont_VV(wf(:,43),wf(:,78)) * den(95)
  A(45) = cont_QA(wf(:,76),wf(:,79)) * den(96)
  A(46) = cont_VV(wf(:,43),wf(:,80)) * den(98)
  A(47) = cont_QA(wf(:,76),wf(:,81)) * den(99)
  A(48) = cont_QA(wf(:,41),wf(:,68)) * den(100)
  A(49) = cont_QA(wf(:,66),wf(:,82)) * den(102)
  A(50) = cont_VV(wf(:,14),wf(:,83)) * den(104)
  A(51) = cont_QA(wf(:,52),wf(:,85)) * den(106)
  A(52) = cont_QA(wf(:,72),wf(:,86)) * den(108)
  A(53) = cont_QA(wf(:,75),wf(:,88)) * den(110)
  A(54) = cont_VV(wf(:,14),wf(:,89)) * den(112)
  A(55) = cont_VV(wf(:,15),wf(:,90)) * den(115)
  A(56) = cont_QA(wf(:,61),wf(:,85)) * den(116)
  A(57) = cont_QA(wf(:,79),wf(:,88)) * den(117)
  A(58) = cont_VV(wf(:,15),wf(:,91)) * den(119)
  A(59) = cont_QA(wf(:,81),wf(:,88)) * den(120)
  A(60) = cont_QA(wf(:,64),wf(:,84)) * den(121)
  A(61) = cont_VV(wf(:,36),wf(:,83)) * den(122)
  A(62) = cont_VV(wf(:,50),wf(:,78)) * den(123)
  A(63) = cont_VV(wf(:,50),wf(:,80)) * den(124)
  A(64) = cont_VV(wf(:,38),wf(:,83)) * den(125)
  A(65) = cont_VV(wf(:,25),wf(:,90)) * den(126)
  A(66) = cont_VV(wf(:,60),wf(:,70)) * den(127)
  A(67) = cont_VV(wf(:,25),wf(:,91)) * den(128)
  A(68) = cont_VV(wf(:,62),wf(:,70)) * den(129)
  A(69) = cont_VV(wf(:,60),wf(:,77)) * den(130)
  A(70) = cont_VV(wf(:,36),wf(:,89)) * den(131)
  A(71) = cont_VV(wf(:,38),wf(:,89)) * den(132)
  A(72) = cont_VV(wf(:,62),wf(:,77)) * den(133)
  A(73) = cont_VV(wf(:,34),wf(:,90)) * den(134)
  A(74) = cont_VV(wf(:,59),wf(:,78)) * den(135)
  A(75) = cont_VV(wf(:,34),wf(:,91)) * den(136)
  A(76) = cont_VV(wf(:,59),wf(:,80)) * den(137)

  A(77) = cont_VV(wf(:,2),wf(:,92)) * den(3)
  A(78) = cont_VV(wf(:,2),wf(:,93)) * den(3)
  A(79) = cont_VV(wf(:,2),wf(:,94)) * den(3)
  A(80) = cont_VV(wf(:,2),wf(:,92)) * den(3)
  A(81) = cont_VV(wf(:,2),wf(:,93)) * den(3)
  A(82) = cont_VV(wf(:,2),wf(:,94)) * den(3)
  A(83) = cont_VV(wf(:,7),wf(:,95)) * den(6)
  A(84) = cont_VV(wf(:,7),wf(:,96)) * den(6)
  A(85) = cont_VV(wf(:,7),wf(:,97)) * den(6)
  A(86) = cont_VV(wf(:,7),wf(:,95)) * den(6)
  A(87) = cont_VV(wf(:,7),wf(:,96)) * den(6)
  A(88) = cont_VV(wf(:,7),wf(:,97)) * den(6)
  A(89) = cont_VV(wf(:,3),wf(:,98)) * den(3)
  A(90) = cont_VV(wf(:,4),wf(:,98)) * den(3)
  A(91) = cont_VV(wf(:,5),wf(:,98)) * den(3)
  A(92) = cont_VV(wf(:,8),wf(:,99)) * den(6)
  A(93) = cont_VV(wf(:,9),wf(:,99)) * den(6)
  A(94) = cont_VV(wf(:,10),wf(:,99)) * den(6)
  A(95) = cont_VV(wf(:,7),wf(:,101)) * den(6)
  A(96) = cont_VV(wf(:,7),wf(:,102)) * den(6)
  A(97) = cont_VV(wf(:,7),wf(:,103)) * den(6)
  A(98) = cont_VV(wf(:,2),wf(:,105)) * den(3)
  A(99) = cont_VV(wf(:,2),wf(:,106)) * den(3)
  A(100) = cont_VV(wf(:,2),wf(:,107)) * den(3)
  A(101) = cont_VV(wf(:,11),wf(:,108)) * den(8)
  A(102) = cont_VV(wf(:,13),wf(:,109)) * den(11)
  A(103) = cont_VV(wf(:,15),wf(:,110)) * den(14)
  A(104) = cont_VV(wf(:,111),wf(:,112)) * den(140)
  A(105) = cont_VV(wf(:,112),wf(:,113)) * den(140)
  A(106) = cont_VV(wf(:,112),wf(:,114)) * den(140)
  A(107) = cont_VV(wf(:,3),wf(:,115)) * den(143)
  A(108) = cont_VV(wf(:,4),wf(:,115)) * den(143)
  A(109) = cont_VV(wf(:,5),wf(:,115)) * den(143)
  A(110) = cont_VV(wf(:,16),wf(:,116)) * den(145)
  A(111) = cont_VV(wf(:,14),wf(:,117)) * den(147)
  A(112) = cont_VV(wf(:,12),wf(:,118)) * den(8)
  A(113) = cont_QA(wf(:,20),wf(:,119)) * den(18)
  A(114) = cont_QA(wf(:,24),wf(:,120)) * den(21)
  A(115) = cont_VV(wf(:,25),wf(:,110)) * den(23)
  A(116) = cont_QA(wf(:,29),wf(:,121)) * den(27)
  A(117) = cont_QA(wf(:,33),wf(:,122)) * den(30)
  A(118) = cont_VV(wf(:,34),wf(:,110)) * den(32)
  A(119) = cont_QA(wf(:,24),wf(:,123)) * den(33)
  A(120) = cont_VV(wf(:,36),wf(:,117)) * den(36)
  A(121) = cont_QA(wf(:,33),wf(:,124)) * den(37)
  A(122) = cont_VV(wf(:,38),wf(:,117)) * den(39)
  A(123) = cont_QA(wf(:,33),wf(:,125)) * den(40)
  A(124) = cont_QA(wf(:,22),wf(:,127)) * den(43)
  A(125) = cont_VV(wf(:,16),wf(:,128)) * den(148)
  A(126) = cont_QA(wf(:,129),wf(:,130)) * den(150)
  A(127) = cont_QA(wf(:,21),wf(:,132)) * den(18)
  A(128) = cont_VV(wf(:,13),wf(:,133)) * den(151)
  A(129) = cont_QA(wf(:,129),wf(:,134)) * den(153)
  A(130) = cont_QA(wf(:,33),wf(:,135)) * den(40)
  A(131) = cont_QA(wf(:,41),wf(:,129)) * den(43)
  A(132) = cont_QA(wf(:,33),wf(:,136)) * den(37)
  A(133) = cont_VV(wf(:,13),wf(:,137)) * den(39)
  A(134) = cont_QA(wf(:,30),wf(:,139)) * den(27)
  A(135) = cont_QA(wf(:,33),wf(:,140)) * den(30)
  A(136) = cont_VV(wf(:,16),wf(:,141)) * den(32)
  A(137) = cont_VV(wf(:,11),wf(:,142)) * den(44)
  A(138) = cont_VV(wf(:,43),wf(:,143)) * den(47)
  A(139) = cont_VV(wf(:,45),wf(:,144)) * den(50)
  A(140) = cont_VV(wf(:,145),wf(:,146)) * den(156)
  A(141) = cont_VV(wf(:,146),wf(:,147)) * den(156)
  A(142) = cont_VV(wf(:,146),wf(:,148)) * den(156)
  A(143) = cont_VV(wf(:,8),wf(:,149)) * den(159)
  A(144) = cont_VV(wf(:,9),wf(:,149)) * den(159)
  A(145) = cont_VV(wf(:,10),wf(:,149)) * den(159)
  A(146) = cont_VV(wf(:,46),wf(:,150)) * den(161)
  A(147) = cont_VV(wf(:,44),wf(:,151)) * den(163)
  A(148) = cont_VV(wf(:,42),wf(:,118)) * den(44)
  A(149) = cont_QA(wf(:,20),wf(:,152)) * den(53)
  A(150) = cont_VV(wf(:,50),wf(:,143)) * den(55)
  A(151) = cont_QA(wf(:,53),wf(:,153)) * den(58)
  A(152) = cont_QA(wf(:,29),wf(:,154)) * den(61)
  A(153) = cont_QA(wf(:,58),wf(:,122)) * den(63)
  A(154) = cont_VV(wf(:,59),wf(:,143)) * den(65)
  A(155) = cont_VV(wf(:,60),wf(:,150)) * den(68)
  A(156) = cont_QA(wf(:,53),wf(:,155)) * den(69)
  A(157) = cont_QA(wf(:,58),wf(:,124)) * den(70)
  A(158) = cont_VV(wf(:,62),wf(:,150)) * den(72)
  A(159) = cont_QA(wf(:,58),wf(:,125)) * den(73)
  A(160) = cont_QA(wf(:,51),wf(:,157)) * den(76)
  A(161) = cont_QA(wf(:,158),wf(:,159)) * den(165)
  A(162) = cont_VV(wf(:,44),wf(:,160)) * den(166)
  A(163) = cont_QA(wf(:,49),wf(:,132)) * den(53)
  A(164) = cont_QA(wf(:,158),wf(:,161)) * den(168)
  A(165) = cont_VV(wf(:,45),wf(:,162)) * den(169)
  A(166) = cont_QA(wf(:,58),wf(:,135)) * den(73)
  A(167) = cont_QA(wf(:,64),wf(:,158)) * den(76)
  A(168) = cont_QA(wf(:,58),wf(:,136)) * den(70)
  A(169) = cont_VV(wf(:,45),wf(:,163)) * den(72)
  A(170) = cont_QA(wf(:,56),wf(:,139)) * den(61)
  A(171) = cont_QA(wf(:,58),wf(:,140)) * den(63)
  A(172) = cont_VV(wf(:,44),wf(:,164)) * den(65)
  A(173) = cont_QA(wf(:,66),wf(:,165)) * den(79)
  A(174) = cont_QA(wf(:,69),wf(:,120)) * den(81)
  A(175) = cont_VV(wf(:,70),wf(:,144)) * den(83)
  A(176) = cont_QA(wf(:,72),wf(:,166)) * den(86)
  A(177) = cont_QA(wf(:,76),wf(:,167)) * den(89)
  A(178) = cont_VV(wf(:,77),wf(:,144)) * den(91)
  A(179) = cont_QA(wf(:,69),wf(:,123)) * den(92)
  A(180) = cont_VV(wf(:,78),wf(:,151)) * den(95)
  A(181) = cont_QA(wf(:,76),wf(:,168)) * den(96)
  A(182) = cont_VV(wf(:,80),wf(:,151)) * den(98)
  A(183) = cont_QA(wf(:,76),wf(:,169)) * den(99)
  A(184) = cont_QA(wf(:,68),wf(:,127)) * den(100)
  A(185) = cont_QA(wf(:,66),wf(:,170)) * den(102)
  A(186) = cont_VV(wf(:,83),wf(:,109)) * den(104)
  A(187) = cont_QA(wf(:,85),wf(:,153)) * den(106)
  A(188) = cont_QA(wf(:,72),wf(:,171)) * den(108)
  A(189) = cont_QA(wf(:,88),wf(:,167)) * den(110)
  A(190) = cont_VV(wf(:,89),wf(:,109)) * den(112)
  A(191) = cont_VV(wf(:,90),wf(:,116)) * den(115)
  A(192) = cont_QA(wf(:,85),wf(:,155)) * den(116)
  A(193) = cont_QA(wf(:,88),wf(:,168)) * den(117)
  A(194) = cont_VV(wf(:,91),wf(:,116)) * den(119)
  A(195) = cont_QA(wf(:,88),wf(:,169)) * den(120)
  A(196) = cont_QA(wf(:,84),wf(:,157)) * den(121)
  A(197) = cont_VV(wf(:,83),wf(:,133)) * den(122)
  A(198) = cont_VV(wf(:,78),wf(:,160)) * den(123)
  A(199) = cont_VV(wf(:,80),wf(:,160)) * den(124)
  A(200) = cont_VV(wf(:,83),wf(:,137)) * den(125)
  A(201) = cont_VV(wf(:,90),wf(:,128)) * den(126)
  A(202) = cont_VV(wf(:,70),wf(:,162)) * den(127)
  A(203) = cont_VV(wf(:,91),wf(:,128)) * den(128)
  A(204) = cont_VV(wf(:,70),wf(:,163)) * den(129)
  A(205) = cont_VV(wf(:,77),wf(:,162)) * den(130)
  A(206) = cont_VV(wf(:,89),wf(:,133)) * den(131)
  A(207) = cont_VV(wf(:,89),wf(:,137)) * den(132)
  A(208) = cont_VV(wf(:,77),wf(:,163)) * den(133)
  A(209) = cont_VV(wf(:,90),wf(:,141)) * den(134)
  A(210) = cont_VV(wf(:,78),wf(:,164)) * den(135)
  A(211) = cont_VV(wf(:,91),wf(:,141)) * den(136)
  A(212) = cont_VV(wf(:,80),wf(:,164)) * den(137)
  A(213) = cont_VV(wf(:,46),wf(:,172)) * den(170)
  A(214) = cont_QA(wf(:,130),wf(:,173)) * den(171)
  A(215) = cont_QA(wf(:,67),wf(:,175)) * den(79)
  A(216) = cont_VV(wf(:,43),wf(:,176)) * den(172)
  A(217) = cont_QA(wf(:,134),wf(:,173)) * den(173)
  A(218) = cont_QA(wf(:,76),wf(:,177)) * den(99)
  A(219) = cont_QA(wf(:,41),wf(:,173)) * den(100)
  A(220) = cont_QA(wf(:,76),wf(:,178)) * den(96)
  A(221) = cont_VV(wf(:,43),wf(:,179)) * den(98)
  A(222) = cont_QA(wf(:,73),wf(:,181)) * den(86)
  A(223) = cont_QA(wf(:,76),wf(:,182)) * den(89)
  A(224) = cont_VV(wf(:,46),wf(:,183)) * den(91)
  A(225) = cont_QA(wf(:,159),wf(:,184)) * den(174)
  A(226) = cont_VV(wf(:,14),wf(:,185)) * den(175)
  A(227) = cont_QA(wf(:,82),wf(:,175)) * den(102)
  A(228) = cont_QA(wf(:,161),wf(:,184)) * den(176)
  A(229) = cont_VV(wf(:,15),wf(:,186)) * den(177)
  A(230) = cont_QA(wf(:,88),wf(:,177)) * den(120)
  A(231) = cont_QA(wf(:,64),wf(:,184)) * den(121)
  A(232) = cont_QA(wf(:,88),wf(:,178)) * den(117)
  A(233) = cont_VV(wf(:,15),wf(:,187)) * den(119)
  A(234) = cont_QA(wf(:,86),wf(:,181)) * den(108)
  A(235) = cont_QA(wf(:,88),wf(:,182)) * den(110)
  A(236) = cont_VV(wf(:,14),wf(:,188)) * den(112)
  A(237) = cont_VV(wf(:,50),wf(:,176)) * den(178)
  A(238) = cont_VV(wf(:,36),wf(:,185)) * den(179)
  A(239) = cont_VV(wf(:,38),wf(:,185)) * den(125)
  A(240) = cont_VV(wf(:,50),wf(:,179)) * den(124)
  A(241) = cont_VV(wf(:,60),wf(:,172)) * den(180)
  A(242) = cont_VV(wf(:,25),wf(:,186)) * den(181)
  A(243) = cont_VV(wf(:,62),wf(:,172)) * den(129)
  A(244) = cont_VV(wf(:,25),wf(:,187)) * den(128)
  A(245) = cont_VV(wf(:,34),wf(:,186)) * den(134)
  A(246) = cont_VV(wf(:,59),wf(:,176)) * den(135)
  A(247) = cont_VV(wf(:,59),wf(:,179)) * den(137)
  A(248) = cont_VV(wf(:,34),wf(:,187)) * den(136)
  A(249) = cont_VV(wf(:,60),wf(:,183)) * den(130)
  A(250) = cont_VV(wf(:,36),wf(:,188)) * den(131)
  A(251) = cont_VV(wf(:,62),wf(:,183)) * den(133)
  A(252) = cont_VV(wf(:,38),wf(:,188)) * den(132)
  A(253) = cont_VV(wf(:,16),wf(:,189)) * den(182)
  A(254) = cont_QA(wf(:,190),wf(:,191)) * den(185)
  A(255) = cont_QA(wf(:,29),wf(:,194)) * den(27)
  A(256) = cont_VV(wf(:,13),wf(:,195)) * den(186)
  A(257) = cont_QA(wf(:,190),wf(:,196)) * den(188)
  A(258) = cont_QA(wf(:,24),wf(:,197)) * den(189)
  A(259) = cont_QA(wf(:,190),wf(:,198)) * den(191)
  A(260) = cont_QA(wf(:,24),wf(:,199)) * den(33)
  A(261) = cont_VV(wf(:,13),wf(:,200)) * den(36)
  A(262) = cont_QA(wf(:,20),wf(:,203)) * den(18)
  A(263) = cont_QA(wf(:,24),wf(:,204)) * den(21)
  A(264) = cont_VV(wf(:,16),wf(:,205)) * den(23)
  A(265) = cont_VV(wf(:,11),wf(:,206)) * den(8)
  A(266) = cont_VV(wf(:,13),wf(:,207)) * den(11)
  A(267) = cont_VV(wf(:,16),wf(:,208)) * den(14)
  A(268) = cont_VV(wf(:,46),wf(:,209)) * den(192)
  A(269) = cont_QA(wf(:,210),wf(:,211)) * den(195)
  A(270) = cont_QA(wf(:,72),wf(:,212)) * den(86)
  A(271) = cont_VV(wf(:,43),wf(:,213)) * den(196)
  A(272) = cont_QA(wf(:,210),wf(:,214)) * den(198)
  A(273) = cont_QA(wf(:,69),wf(:,197)) * den(199)
  A(274) = cont_QA(wf(:,210),wf(:,215)) * den(201)
  A(275) = cont_QA(wf(:,69),wf(:,199)) * den(92)
  A(276) = cont_VV(wf(:,43),wf(:,216)) * den(95)
  A(277) = cont_QA(wf(:,66),wf(:,217)) * den(79)
  A(278) = cont_QA(wf(:,69),wf(:,204)) * den(81)
  A(279) = cont_VV(wf(:,46),wf(:,218)) * den(83)
  A(280) = cont_VV(wf(:,50),wf(:,213)) * den(202)
  A(281) = cont_VV(wf(:,83),wf(:,195)) * den(203)
  A(282) = cont_VV(wf(:,83),wf(:,200)) * den(122)
  A(283) = cont_VV(wf(:,50),wf(:,216)) * den(123)
  A(284) = cont_VV(wf(:,60),wf(:,209)) * den(204)
  A(285) = cont_VV(wf(:,89),wf(:,195)) * den(132)
  A(286) = cont_VV(wf(:,62),wf(:,209)) * den(133)
  A(287) = cont_VV(wf(:,89),wf(:,200)) * den(131)
  A(288) = cont_VV(wf(:,90),wf(:,189)) * den(205)
  A(289) = cont_VV(wf(:,91),wf(:,189)) * den(136)
  A(290) = cont_VV(wf(:,59),wf(:,213)) * den(137)
  A(291) = cont_VV(wf(:,59),wf(:,216)) * den(135)
  A(292) = cont_VV(wf(:,90),wf(:,205)) * den(126)
  A(293) = cont_VV(wf(:,60),wf(:,218)) * den(127)
  A(294) = cont_VV(wf(:,91),wf(:,205)) * den(128)
  A(295) = cont_VV(wf(:,62),wf(:,218)) * den(129)
  A(296) = cont_QA(wf(:,66),wf(:,219)) * den(102)
  A(297) = cont_VV(wf(:,83),wf(:,207)) * den(104)
  A(298) = cont_QA(wf(:,52),wf(:,221)) * den(106)
  A(299) = cont_QA(wf(:,72),wf(:,222)) * den(108)
  A(300) = cont_VV(wf(:,89),wf(:,207)) * den(112)
  A(301) = cont_QA(wf(:,75),wf(:,224)) * den(110)
  A(302) = cont_VV(wf(:,90),wf(:,208)) * den(115)
  A(303) = cont_QA(wf(:,61),wf(:,221)) * den(116)
  A(304) = cont_VV(wf(:,91),wf(:,208)) * den(119)
  A(305) = cont_QA(wf(:,79),wf(:,224)) * den(117)
  A(306) = cont_QA(wf(:,64),wf(:,220)) * den(121)
  A(307) = cont_QA(wf(:,81),wf(:,224)) * den(120)
  A(308) = cont_VV(wf(:,11),wf(:,225)) * den(44)
  A(309) = cont_VV(wf(:,43),wf(:,226)) * den(47)
  A(310) = cont_VV(wf(:,46),wf(:,227)) * den(50)
  A(311) = cont_QA(wf(:,20),wf(:,228)) * den(53)
  A(312) = cont_VV(wf(:,50),wf(:,226)) * den(55)
  A(313) = cont_QA(wf(:,52),wf(:,230)) * den(58)
  A(314) = cont_QA(wf(:,29),wf(:,231)) * den(61)
  A(315) = cont_VV(wf(:,59),wf(:,226)) * den(65)
  A(316) = cont_QA(wf(:,32),wf(:,233)) * den(63)
  A(317) = cont_VV(wf(:,60),wf(:,227)) * den(68)
  A(318) = cont_QA(wf(:,61),wf(:,230)) * den(69)
  A(319) = cont_VV(wf(:,62),wf(:,227)) * den(72)
  A(320) = cont_QA(wf(:,37),wf(:,233)) * den(70)
  A(321) = cont_QA(wf(:,64),wf(:,229)) * den(76)
  A(322) = cont_QA(wf(:,39),wf(:,233)) * den(73)
  A(323) = cont_QA(wf(:,191),wf(:,234)) * den(206)
  A(324) = cont_VV(wf(:,44),wf(:,235)) * den(207)
  A(325) = cont_QA(wf(:,29),wf(:,238)) * den(61)
  A(326) = cont_QA(wf(:,196),wf(:,234)) * den(208)
  A(327) = cont_VV(wf(:,45),wf(:,239)) * den(209)
  A(328) = cont_QA(wf(:,198),wf(:,234)) * den(210)
  A(329) = cont_QA(wf(:,53),wf(:,240)) * den(211)
  A(330) = cont_VV(wf(:,45),wf(:,241)) * den(68)
  A(331) = cont_QA(wf(:,53),wf(:,242)) * den(69)
  A(332) = cont_QA(wf(:,20),wf(:,245)) * den(53)
  A(333) = cont_VV(wf(:,44),wf(:,246)) * den(55)
  A(334) = cont_QA(wf(:,53),wf(:,247)) * den(58)
  A(335) = cont_VV(wf(:,11),wf(:,248)) * den(44)
  A(336) = cont_VV(wf(:,44),wf(:,249)) * den(47)
  A(337) = cont_VV(wf(:,45),wf(:,250)) * den(50)
  A(338) = cont_QA(wf(:,211),wf(:,251)) * den(212)
  A(339) = cont_VV(wf(:,14),wf(:,252)) * den(213)
  A(340) = cont_QA(wf(:,72),wf(:,253)) * den(108)
  A(341) = cont_QA(wf(:,214),wf(:,251)) * den(214)
  A(342) = cont_VV(wf(:,15),wf(:,254)) * den(215)
  A(343) = cont_QA(wf(:,215),wf(:,251)) * den(216)
  A(344) = cont_QA(wf(:,85),wf(:,240)) * den(217)
  A(345) = cont_VV(wf(:,15),wf(:,255)) * den(115)
  A(346) = cont_QA(wf(:,85),wf(:,242)) * den(116)
  A(347) = cont_QA(wf(:,66),wf(:,256)) * den(102)
  A(348) = cont_VV(wf(:,14),wf(:,257)) * den(104)
  A(349) = cont_QA(wf(:,85),wf(:,247)) * den(106)
  A(350) = cont_VV(wf(:,25),wf(:,254)) * den(218)
  A(351) = cont_VV(wf(:,70),wf(:,239)) * den(219)
  A(352) = cont_VV(wf(:,25),wf(:,255)) * den(126)
  A(353) = cont_VV(wf(:,70),wf(:,241)) * den(127)
  A(354) = cont_VV(wf(:,36),wf(:,252)) * den(220)
  A(355) = cont_VV(wf(:,38),wf(:,252)) * den(221)
  A(356) = cont_VV(wf(:,77),wf(:,239)) * den(222)
  A(357) = cont_VV(wf(:,77),wf(:,241)) * den(130)
  A(358) = cont_VV(wf(:,78),wf(:,235)) * den(223)
  A(359) = cont_VV(wf(:,34),wf(:,254)) * den(224)
  A(360) = cont_VV(wf(:,80),wf(:,235)) * den(225)
  A(361) = cont_VV(wf(:,34),wf(:,255)) * den(134)
  A(362) = cont_VV(wf(:,36),wf(:,257)) * den(122)
  A(363) = cont_VV(wf(:,78),wf(:,246)) * den(123)
  A(364) = cont_VV(wf(:,80),wf(:,246)) * den(124)
  A(365) = cont_VV(wf(:,38),wf(:,257)) * den(125)
  A(366) = cont_QA(wf(:,66),wf(:,258)) * den(79)
  A(367) = cont_QA(wf(:,23),wf(:,260)) * den(81)
  A(368) = cont_VV(wf(:,70),wf(:,250)) * den(83)
  A(369) = cont_QA(wf(:,72),wf(:,261)) * den(86)
  A(370) = cont_QA(wf(:,75),wf(:,263)) * den(89)
  A(371) = cont_VV(wf(:,77),wf(:,250)) * den(91)
  A(372) = cont_QA(wf(:,35),wf(:,260)) * den(92)
  A(373) = cont_VV(wf(:,78),wf(:,249)) * den(95)
  A(374) = cont_QA(wf(:,79),wf(:,263)) * den(96)
  A(375) = cont_VV(wf(:,80),wf(:,249)) * den(98)
  A(376) = cont_QA(wf(:,81),wf(:,263)) * den(99)
  A(377) = cont_QA(wf(:,41),wf(:,259)) * den(100)
  A(378) = cont_VV(wf(:,11),wf(:,264)) * den(8)
  A(379) = cont_VV(wf(:,14),wf(:,265)) * den(11)
  A(380) = cont_VV(wf(:,15),wf(:,266)) * den(14)
  A(381) = cont_QA(wf(:,20),wf(:,267)) * den(18)
  A(382) = cont_QA(wf(:,23),wf(:,269)) * den(21)
  A(383) = cont_VV(wf(:,25),wf(:,266)) * den(23)
  A(384) = cont_QA(wf(:,29),wf(:,270)) * den(27)
  A(385) = cont_QA(wf(:,32),wf(:,272)) * den(30)
  A(386) = cont_VV(wf(:,34),wf(:,266)) * den(32)
  A(387) = cont_QA(wf(:,35),wf(:,269)) * den(33)
  A(388) = cont_VV(wf(:,36),wf(:,265)) * den(36)
  A(389) = cont_QA(wf(:,37),wf(:,272)) * den(37)
  A(390) = cont_VV(wf(:,38),wf(:,265)) * den(39)
  A(391) = cont_QA(wf(:,39),wf(:,272)) * den(40)
  A(392) = cont_QA(wf(:,41),wf(:,268)) * den(43)
  A(393) = cont_VV(wf(:,112),wf(:,273)) * den(228)
  A(394) = cont_VV(wf(:,115),wf(:,274)) * den(231)
  A(395) = cont_VV(wf(:,12),wf(:,275)) * den(234)
  A(396) = cont_VV(wf(:,14),wf(:,276)) * den(236)
  A(397) = cont_VV(wf(:,15),wf(:,277)) * den(237)
  A(398) = cont_VV(wf(:,16),wf(:,278)) * den(239)
  A(399) = cont_VV(wf(:,13),wf(:,279)) * den(240)
  A(400) = cont_VV(wf(:,14),wf(:,280)) * den(241)
  A(401) = cont_VV(wf(:,16),wf(:,281)) * den(242)
  A(402) = cont_VV(wf(:,112),wf(:,282)) * den(245)
  A(403) = cont_QA(wf(:,284),wf(:,285)) * den(249)
  A(404) = cont_QA(wf(:,286),wf(:,287)) * den(252)
  A(405) = cont_QA(wf(:,130),wf(:,288)) * den(253)
  A(406) = cont_VV(wf(:,25),wf(:,277)) * den(254)
  A(407) = cont_VV(wf(:,16),wf(:,290)) * den(256)
  A(408) = cont_QA(wf(:,24),wf(:,291)) * den(257)
  A(409) = cont_QA(wf(:,130),wf(:,292)) * den(258)
  A(410) = cont_VV(wf(:,16),wf(:,293)) * den(259)
  A(411) = cont_VV(wf(:,112),wf(:,294)) * den(262)
  A(412) = cont_QA(wf(:,296),wf(:,297)) * den(266)
  A(413) = cont_QA(wf(:,298),wf(:,299)) * den(269)
  A(414) = cont_QA(wf(:,191),wf(:,300)) * den(270)
  A(415) = cont_VV(wf(:,34),wf(:,277)) * den(271)
  A(416) = cont_VV(wf(:,16),wf(:,302)) * den(273)
  A(417) = cont_QA(wf(:,191),wf(:,303)) * den(274)
  A(418) = cont_VV(wf(:,16),wf(:,304)) * den(275)
  A(419) = cont_QA(wf(:,33),wf(:,305)) * den(276)
  A(420) = cont_QA(wf(:,134),wf(:,288)) * den(277)
  A(421) = cont_VV(wf(:,36),wf(:,276)) * den(278)
  A(422) = cont_VV(wf(:,13),wf(:,307)) * den(280)
  A(423) = cont_QA(wf(:,24),wf(:,308)) * den(281)
  A(424) = cont_QA(wf(:,134),wf(:,292)) * den(282)
  A(425) = cont_VV(wf(:,13),wf(:,309)) * den(283)
  A(426) = cont_QA(wf(:,196),wf(:,300)) * den(284)
  A(427) = cont_VV(wf(:,38),wf(:,276)) * den(285)
  A(428) = cont_VV(wf(:,13),wf(:,311)) * den(287)
  A(429) = cont_QA(wf(:,196),wf(:,303)) * den(288)
  A(430) = cont_VV(wf(:,13),wf(:,312)) * den(289)
  A(431) = cont_QA(wf(:,33),wf(:,313)) * den(290)
  A(432) = cont_QA(wf(:,198),wf(:,300)) * den(291)
  A(433) = cont_QA(wf(:,41),wf(:,288)) * den(292)
  A(434) = cont_QA(wf(:,198),wf(:,303)) * den(293)
  A(435) = cont_QA(wf(:,24),wf(:,314)) * den(294)
  A(436) = cont_QA(wf(:,24),wf(:,315)) * den(296)
  A(437) = cont_QA(wf(:,33),wf(:,316)) * den(297)
  A(438) = cont_VV(wf(:,146),wf(:,317)) * den(300)
  A(439) = cont_VV(wf(:,149),wf(:,318)) * den(303)
  A(440) = cont_VV(wf(:,42),wf(:,275)) * den(305)
  A(441) = cont_VV(wf(:,44),wf(:,319)) * den(307)
  A(442) = cont_VV(wf(:,45),wf(:,320)) * den(308)
  A(443) = cont_VV(wf(:,46),wf(:,321)) * den(310)
  A(444) = cont_VV(wf(:,43),wf(:,322)) * den(311)
  A(445) = cont_VV(wf(:,44),wf(:,323)) * den(312)
  A(446) = cont_VV(wf(:,46),wf(:,324)) * den(313)
  A(447) = cont_QA(wf(:,326),wf(:,327)) * den(317)
  A(448) = cont_VV(wf(:,149),wf(:,328)) * den(320)
  A(449) = cont_QA(wf(:,286),wf(:,329)) * den(322)
  A(450) = cont_VV(wf(:,44),wf(:,331)) * den(324)
  A(451) = cont_QA(wf(:,53),wf(:,332)) * den(325)
  A(452) = cont_QA(wf(:,159),wf(:,333)) * den(326)
  A(453) = cont_VV(wf(:,50),wf(:,322)) * den(327)
  A(454) = cont_VV(wf(:,44),wf(:,334)) * den(328)
  A(455) = cont_QA(wf(:,159),wf(:,335)) * den(329)
  A(456) = cont_QA(wf(:,337),wf(:,338)) * den(333)
  A(457) = cont_VV(wf(:,149),wf(:,339)) * den(336)
  A(458) = cont_QA(wf(:,298),wf(:,340)) * den(338)
  A(459) = cont_QA(wf(:,191),wf(:,341)) * den(339)
  A(460) = cont_VV(wf(:,44),wf(:,342)) * den(340)
  A(461) = cont_QA(wf(:,191),wf(:,343)) * den(341)
  A(462) = cont_VV(wf(:,44),wf(:,344)) * den(342)
  A(463) = cont_VV(wf(:,59),wf(:,322)) * den(343)
  A(464) = cont_QA(wf(:,58),wf(:,305)) * den(344)
  A(465) = cont_VV(wf(:,45),wf(:,346)) * den(346)
  A(466) = cont_QA(wf(:,53),wf(:,347)) * den(347)
  A(467) = cont_QA(wf(:,161),wf(:,333)) * den(348)
  A(468) = cont_VV(wf(:,60),wf(:,321)) * den(349)
  A(469) = cont_VV(wf(:,45),wf(:,348)) * den(350)
  A(470) = cont_QA(wf(:,161),wf(:,335)) * den(351)
  A(471) = cont_QA(wf(:,196),wf(:,341)) * den(352)
  A(472) = cont_VV(wf(:,45),wf(:,349)) * den(353)
  A(473) = cont_QA(wf(:,196),wf(:,343)) * den(354)
  A(474) = cont_VV(wf(:,45),wf(:,350)) * den(355)
  A(475) = cont_VV(wf(:,62),wf(:,321)) * den(356)
  A(476) = cont_QA(wf(:,58),wf(:,313)) * den(357)
  A(477) = cont_QA(wf(:,198),wf(:,341)) * den(358)
  A(478) = cont_QA(wf(:,198),wf(:,343)) * den(359)
  A(479) = cont_QA(wf(:,53),wf(:,351)) * den(360)
  A(480) = cont_QA(wf(:,53),wf(:,352)) * den(361)
  A(481) = cont_QA(wf(:,64),wf(:,333)) * den(362)
  A(482) = cont_QA(wf(:,58),wf(:,316)) * den(363)
  A(483) = cont_VV(wf(:,146),wf(:,353)) * den(366)
  A(484) = cont_QA(wf(:,284),wf(:,355)) * den(369)
  A(485) = cont_QA(wf(:,356),wf(:,357)) * den(372)
  A(486) = cont_QA(wf(:,130),wf(:,358)) * den(373)
  A(487) = cont_VV(wf(:,70),wf(:,320)) * den(374)
  A(488) = cont_VV(wf(:,46),wf(:,359)) * den(375)
  A(489) = cont_QA(wf(:,69),wf(:,291)) * den(376)
  A(490) = cont_QA(wf(:,130),wf(:,360)) * den(377)
  A(491) = cont_VV(wf(:,46),wf(:,361)) * den(378)
  A(492) = cont_VV(wf(:,146),wf(:,362)) * den(381)
  A(493) = cont_QA(wf(:,296),wf(:,364)) * den(384)
  A(494) = cont_QA(wf(:,365),wf(:,366)) * den(387)
  A(495) = cont_QA(wf(:,211),wf(:,367)) * den(388)
  A(496) = cont_VV(wf(:,77),wf(:,320)) * den(389)
  A(497) = cont_VV(wf(:,46),wf(:,369)) * den(391)
  A(498) = cont_QA(wf(:,211),wf(:,370)) * den(392)
  A(499) = cont_VV(wf(:,46),wf(:,371)) * den(393)
  A(500) = cont_QA(wf(:,76),wf(:,372)) * den(394)
  A(501) = cont_QA(wf(:,134),wf(:,358)) * den(395)
  A(502) = cont_VV(wf(:,78),wf(:,319)) * den(396)
  A(503) = cont_VV(wf(:,43),wf(:,373)) * den(397)
  A(504) = cont_QA(wf(:,69),wf(:,308)) * den(398)
  A(505) = cont_QA(wf(:,134),wf(:,360)) * den(399)
  A(506) = cont_VV(wf(:,43),wf(:,374)) * den(400)
  A(507) = cont_QA(wf(:,214),wf(:,367)) * den(401)
  A(508) = cont_VV(wf(:,80),wf(:,319)) * den(402)
  A(509) = cont_VV(wf(:,43),wf(:,376)) * den(404)
  A(510) = cont_QA(wf(:,214),wf(:,370)) * den(405)
  A(511) = cont_VV(wf(:,43),wf(:,377)) * den(406)
  A(512) = cont_QA(wf(:,76),wf(:,378)) * den(407)
  A(513) = cont_QA(wf(:,215),wf(:,367)) * den(408)
  A(514) = cont_QA(wf(:,41),wf(:,358)) * den(409)
  A(515) = cont_QA(wf(:,215),wf(:,370)) * den(410)
  A(516) = cont_QA(wf(:,69),wf(:,314)) * den(411)
  A(517) = cont_QA(wf(:,69),wf(:,315)) * den(412)
  A(518) = cont_QA(wf(:,76),wf(:,379)) * den(413)
  A(519) = cont_QA(wf(:,326),wf(:,381)) * den(416)
  A(520) = cont_VV(wf(:,115),wf(:,382)) * den(419)
  A(521) = cont_QA(wf(:,356),wf(:,383)) * den(421)
  A(522) = cont_VV(wf(:,14),wf(:,384)) * den(422)
  A(523) = cont_QA(wf(:,85),wf(:,332)) * den(423)
  A(524) = cont_QA(wf(:,159),wf(:,385)) * den(424)
  A(525) = cont_VV(wf(:,83),wf(:,279)) * den(425)
  A(526) = cont_VV(wf(:,14),wf(:,386)) * den(426)
  A(527) = cont_QA(wf(:,159),wf(:,387)) * den(427)
  A(528) = cont_QA(wf(:,337),wf(:,389)) * den(430)
  A(529) = cont_VV(wf(:,115),wf(:,390)) * den(433)
  A(530) = cont_QA(wf(:,365),wf(:,391)) * den(435)
  A(531) = cont_QA(wf(:,211),wf(:,392)) * den(436)
  A(532) = cont_VV(wf(:,14),wf(:,393)) * den(437)
  A(533) = cont_QA(wf(:,211),wf(:,394)) * den(438)
  A(534) = cont_VV(wf(:,14),wf(:,395)) * den(439)
  A(535) = cont_VV(wf(:,89),wf(:,279)) * den(440)
  A(536) = cont_QA(wf(:,88),wf(:,372)) * den(441)
  A(537) = cont_VV(wf(:,15),wf(:,396)) * den(442)
  A(538) = cont_QA(wf(:,85),wf(:,347)) * den(443)
  A(539) = cont_QA(wf(:,161),wf(:,385)) * den(444)
  A(540) = cont_VV(wf(:,90),wf(:,278)) * den(445)
  A(541) = cont_VV(wf(:,15),wf(:,397)) * den(446)
  A(542) = cont_QA(wf(:,161),wf(:,387)) * den(447)
  A(543) = cont_QA(wf(:,214),wf(:,392)) * den(448)
  A(544) = cont_VV(wf(:,15),wf(:,398)) * den(449)
  A(545) = cont_QA(wf(:,214),wf(:,394)) * den(450)
  A(546) = cont_VV(wf(:,15),wf(:,399)) * den(451)
  A(547) = cont_VV(wf(:,91),wf(:,278)) * den(452)
  A(548) = cont_QA(wf(:,88),wf(:,378)) * den(453)
  A(549) = cont_QA(wf(:,215),wf(:,392)) * den(454)
  A(550) = cont_QA(wf(:,215),wf(:,394)) * den(455)
  A(551) = cont_QA(wf(:,85),wf(:,351)) * den(456)
  A(552) = cont_QA(wf(:,85),wf(:,352)) * den(457)
  A(553) = cont_QA(wf(:,64),wf(:,385)) * den(458)
  A(554) = cont_QA(wf(:,88),wf(:,379)) * den(459)
  A(555) = cont_VV(wf(:,36),wf(:,384)) * den(460)
  A(556) = cont_VV(wf(:,78),wf(:,331)) * den(461)
  A(557) = cont_VV(wf(:,50),wf(:,373)) * den(462)
  A(558) = cont_VV(wf(:,83),wf(:,307)) * den(463)
  A(559) = cont_VV(wf(:,36),wf(:,386)) * den(464)
  A(560) = cont_VV(wf(:,50),wf(:,374)) * den(465)
  A(561) = cont_VV(wf(:,80),wf(:,331)) * den(466)
  A(562) = cont_VV(wf(:,50),wf(:,376)) * den(467)
  A(563) = cont_VV(wf(:,50),wf(:,377)) * den(468)
  A(564) = cont_VV(wf(:,38),wf(:,384)) * den(469)
  A(565) = cont_VV(wf(:,83),wf(:,312)) * den(470)
  A(566) = cont_VV(wf(:,83),wf(:,311)) * den(471)
  A(567) = cont_VV(wf(:,25),wf(:,396)) * den(472)
  A(568) = cont_VV(wf(:,70),wf(:,346)) * den(473)
  A(569) = cont_VV(wf(:,60),wf(:,359)) * den(474)
  A(570) = cont_VV(wf(:,90),wf(:,290)) * den(475)
  A(571) = cont_VV(wf(:,25),wf(:,397)) * den(476)
  A(572) = cont_VV(wf(:,60),wf(:,361)) * den(477)
  A(573) = cont_VV(wf(:,25),wf(:,398)) * den(478)
  A(574) = cont_VV(wf(:,25),wf(:,399)) * den(479)
  A(575) = cont_VV(wf(:,91),wf(:,290)) * den(480)
  A(576) = cont_VV(wf(:,70),wf(:,350)) * den(481)
  A(577) = cont_VV(wf(:,70),wf(:,349)) * den(482)
  A(578) = cont_VV(wf(:,62),wf(:,359)) * den(483)
  A(579) = cont_VV(wf(:,77),wf(:,346)) * den(484)
  A(580) = cont_VV(wf(:,60),wf(:,369)) * den(485)
  A(581) = cont_VV(wf(:,60),wf(:,371)) * den(486)
  A(582) = cont_VV(wf(:,36),wf(:,393)) * den(487)
  A(583) = cont_VV(wf(:,36),wf(:,395)) * den(488)
  A(584) = cont_VV(wf(:,89),wf(:,307)) * den(489)
  A(585) = cont_VV(wf(:,38),wf(:,395)) * den(490)
  A(586) = cont_VV(wf(:,77),wf(:,350)) * den(491)
  A(587) = cont_VV(wf(:,38),wf(:,393)) * den(492)
  A(588) = cont_VV(wf(:,77),wf(:,349)) * den(493)
  A(589) = cont_VV(wf(:,62),wf(:,369)) * den(494)
  A(590) = cont_VV(wf(:,89),wf(:,311)) * den(495)
  A(591) = cont_VV(wf(:,34),wf(:,396)) * den(496)
  A(592) = cont_VV(wf(:,90),wf(:,304)) * den(497)
  A(593) = cont_VV(wf(:,90),wf(:,302)) * den(498)
  A(594) = cont_VV(wf(:,78),wf(:,344)) * den(499)
  A(595) = cont_VV(wf(:,78),wf(:,342)) * den(500)
  A(596) = cont_VV(wf(:,59),wf(:,373)) * den(501)
  A(597) = cont_VV(wf(:,34),wf(:,399)) * den(502)
  A(598) = cont_VV(wf(:,80),wf(:,344)) * den(503)
  A(599) = cont_VV(wf(:,34),wf(:,398)) * den(504)
  A(600) = cont_VV(wf(:,80),wf(:,342)) * den(505)
  A(601) = cont_VV(wf(:,59),wf(:,376)) * den(506)
  A(602) = cont_VV(wf(:,91),wf(:,302)) * den(507)

end subroutine diagrams


subroutine colourvectors(A, M1, M2)
  ! Born and counterterm colour vectors
  use ol_parameters_decl_/**/REALKIND, only: CI
  implicit none
  complex(REALKIND), intent(in) :: A(602)
  complex(REALKIND), intent(out) :: M1(12), M2(14)

  M1( 1) = ((A(65)+A(67)+A(73)+A(75))*f(1))/6._/**/REALKIND+((-A(4)+A(6)+A(23)+A(24)+A(28)+A(37)+A(66) &
        +A(76))*f(1))/2._/**/REALKIND+(CI*(A(30)-A(31)-A(39)+A(46))*f(2))/2._/**/REALKIND
  M1( 2) = ((A(1)-A(3)-A(8)-A(9)-A(13)-A(49)-A(61)-A(75))*f(1))/2._/**/REALKIND+((-A(62)-A(63)-A(74)-A(76))*f(1))/6._/**/REALKIND &
        +(CI*(-A(15)+A(17)+A(50)-A(58))*f(2))/2._/**/REALKIND
  M1( 3) = ((A(1)-A(3)-A(8)-A(9)-A(10)-A(52)-A(65)-A(71))*f(1))/2._/**/REALKIND+((-A(66)-A(68)-A(69)-A(72))*f(1))/6._/**/REALKIND &
        +(CI*(A(12)-A(19)-A(54)+A(55))*f(2))/2._/**/REALKIND
  M1( 4) = ((A(61)+A(64)+A(70)+A(71))*f(1))/6._/**/REALKIND+((-A(4)+A(6)+A(23)+A(24)+A(25)+A(40)+A(62) &
        +A(72))*f(1))/2._/**/REALKIND+(CI*(-A(26)+A(34)+A(42)-A(44))*f(2))/2._/**/REALKIND
  M1( 5) = ((A(52)+A(53)+A(56))*f(1))/6._/**/REALKIND+((A(5)-A(6)-A(22)-A(24)+A(32)+A(41)+A(69))*f(1))/2._/**/REALKIND+(CI*(A(31) &
        +A(36)-A(42)+A(47))*f(2))/2._/**/REALKIND+(CI*(A(59)+A(60))*f(2))/6._/**/REALKIND
  M1( 6) = ((-A(40)-A(41)-A(43))*f(1))/6._/**/REALKIND+((-A(1)+A(2)+A(7)+A(8)-A(16)-A(53)-A(70))*f(1))/2._/**/REALKIND+(CI*(-A(47) &
        -A(48))*f(2))/6._/**/REALKIND+(CI*(-A(17)-A(21)+A(54)-A(59))*f(2))/2._/**/REALKIND
  M1( 7) = ((-A(28)-A(29)-A(32))*f(1))/6._/**/REALKIND+((-A(2)+A(3)-A(7)+A(9)-A(14)-A(56)-A(73))*f(1))/2._/**/REALKIND+(CI*(-A(35) &
        -A(36))*f(2))/6._/**/REALKIND+(CI*(A(15)-A(20)-A(55)-A(60))*f(2))/2._/**/REALKIND
  M1( 8) = ((A(13)+A(14)+A(16))*f(1))/6._/**/REALKIND+((A(4)-A(5)+A(22)-A(23)+A(29)+A(43)+A(74))*f(1))/2._/**/REALKIND+(CI*(A(20) &
        +A(21))*f(2))/6._/**/REALKIND+(CI*(-A(30)+A(35)+A(44)+A(48))*f(2))/2._/**/REALKIND
  M1( 9) = ((A(49)+A(51)+A(57))*f(1))/6._/**/REALKIND+((A(4)-A(5)+A(22)-A(23)+A(27)+A(45)+A(63))*f(1))/2._/**/REALKIND+(CI*(A(26) &
        -A(36)-A(46)-A(47))*f(2))/2._/**/REALKIND+(CI*(-A(59)-A(60))*f(2))/6._/**/REALKIND
  M1(10) = ((-A(37)-A(38)-A(45))*f(1))/6._/**/REALKIND+((-A(2)+A(3)-A(7)+A(9)-A(11)-A(57)-A(67))*f(1))/2._/**/REALKIND+(CI*(A(47) &
        +A(48))*f(2))/6._/**/REALKIND+(CI*(-A(12)+A(21)+A(58)+A(59))*f(2))/2._/**/REALKIND
  M1(11) = ((-A(25)-A(27)-A(33))*f(1))/6._/**/REALKIND+((-A(1)+A(2)+A(7)+A(8)-A(18)-A(51)-A(64))*f(1))/2._/**/REALKIND+(CI*(A(35) &
        +A(36))*f(2))/6._/**/REALKIND+(CI*(A(19)+A(20)-A(50)+A(60))*f(2))/2._/**/REALKIND
  M1(12) = ((A(10)+A(11)+A(18))*f(1))/6._/**/REALKIND+((A(5)-A(6)-A(22)-A(24)+A(33)+A(38)+A(68))*f(1))/2._/**/REALKIND+(CI*(-A(20) &
        -A(21))*f(2))/6._/**/REALKIND+(CI*(-A(34)-A(35)+A(39)-A(48))*f(2))/2._/**/REALKIND

  M2( 1) = ((A(140)-A(142)+A(143)-A(145)-A(441)-A(442)-A(443)-A(444)-A(445)-A(446)-A(456)-A(457)-A(458)-A(483)-A(484)-A(485) &
        -A(568)-A(569)-A(572)-A(598)-A(600)-A(601))*f(3))/2._/**/REALKIND+((-A(567)-A(570)-A(571)-A(573)-A(574)-A(575)-A(591) &
        -A(592)-A(593)-A(597)-A(599)-A(602))*f(3))/6._/**/REALKIND+(CI*(-A(460)-A(462)-A(463)+A(465)+A(468)+A(469)+A(487)+A(488) &
        +A(491)-A(508)-A(509)-A(511))*f(4))/2._/**/REALKIND+((A(201)+A(203)+A(209)+A(211)+A(242)+A(244)+A(245)+A(248)+A(288) &
        +A(289)+A(292)+A(294)+A(350)+A(352)+A(359)+A(361))*f(5))/6._/**/REALKIND+((-A(92)+A(94)-A(95)+A(97)+A(152)+A(170)+A(173) &
        +A(202)+A(212)+A(215)+A(241)+A(247)+A(277)+A(290)+A(293)+A(309)+A(310)+A(314)+A(325)+A(336)+A(337)+A(353)+A(360) &
        +A(366))*f(5))/2._/**/REALKIND+(CI*(-A(165)+A(172)-A(213)+A(221)+A(271)-A(279)+A(315)-A(317)+A(324)-A(330)-A(368) &
        +A(375))*f(6))/2._/**/REALKIND+((A(138)+A(139)+A(146)+A(147))*f(7))/2._/**/REALKIND+(CI*(A(154)-A(155)-A(175) &
        +A(182))*f(8))/2._/**/REALKIND+A(84)*f(9)+((-A(83)-A(85))*f(9))/2._/**/REALKIND+((A(80)+A(81) &
        +A(82))*f(10))/3._/**/REALKIND-9*A(87)*f(10)+(19*(A(86)+A(88))*f(10))/4._/**/REALKIND
  M2( 2) = ((A(556)+A(557)+A(560)+A(561)+A(562)+A(563)+A(594)+A(595)+A(596)+A(598)+A(600)+A(601))*f(3))/6._/**/REALKIND+((-A(104) &
        +A(106)-A(107)+A(109)+A(396)+A(397)+A(398)+A(399)+A(400)+A(401)+A(411)+A(412)+A(413)+A(519)+A(520)+A(521)+A(555)+A(558) &
        +A(559)+A(597)+A(599)+A(602))*f(3))/2._/**/REALKIND+(CI*(A(415)+A(416)+A(418)-A(421)-A(422)-A(425)-A(522)-A(525)-A(526) &
        +A(544)+A(546)+A(547))*f(4))/2._/**/REALKIND+((-A(198)-A(199)-A(210)-A(212)-A(237)-A(240)-A(246)-A(247)-A(280)-A(283) &
        -A(290)-A(291)-A(358)-A(360)-A(363)-A(364))*f(5))/6._/**/REALKIND+((A(89)-A(91)+A(98)-A(100)-A(116)-A(134)-A(185)-A(197) &
        -A(211)-A(227)-A(238)-A(248)-A(255)-A(266)-A(267)-A(282)-A(289)-A(296)-A(347)-A(359)-A(362)-A(379)-A(380) &
        -A(384))*f(5))/2._/**/REALKIND+(CI*(A(128)-A(136)+A(226)-A(233)-A(253)+A(261)+A(297)-A(304)-A(342)+A(348)-A(386) &
        +A(388))*f(6))/2._/**/REALKIND+((-A(102)-A(103)-A(110)-A(111))*f(7))/2._/**/REALKIND+(CI*(-A(118)+A(120)+A(186) &
        -A(194))*f(8))/2._/**/REALKIND-A(78)*f(9)+((A(77)+A(79))*f(9))/2._/**/REALKIND+9*A(81)*f(10)+(19*(-A(80) &
        -A(82))*f(10))/4._/**/REALKIND+((-A(86)-A(87)-A(88))*f(10))/3._/**/REALKIND
  M2( 3) = ((A(568)+A(569)+A(572)+A(576)+A(577)+A(578)+A(579)+A(580)+A(581)+A(586)+A(588)+A(589))*f(3))/6._/**/REALKIND+((-A(104) &
        +A(106)-A(107)+A(109)+A(396)+A(397)+A(398)+A(399)+A(400)+A(401)+A(402)+A(403)+A(404)+A(528)+A(529)+A(530)+A(567)+A(570) &
        +A(571)+A(585)+A(587)+A(590))*f(3))/2._/**/REALKIND+(CI*(-A(406)-A(407)-A(410)+A(427)+A(428)+A(430)+A(532)+A(534)+A(535) &
        -A(537)-A(540)-A(541))*f(4))/2._/**/REALKIND+((-A(202)-A(204)-A(205)-A(208)-A(241)-A(243)-A(249)-A(251)-A(284)-A(286) &
        -A(293)-A(295)-A(351)-A(353)-A(356)-A(357))*f(5))/6._/**/REALKIND+((A(89)-A(91)+A(98)-A(100)-A(113)-A(127)-A(188)-A(201) &
        -A(207)-A(234)-A(242)-A(252)-A(262)-A(266)-A(267)-A(285)-A(292)-A(299)-A(340)-A(352)-A(355)-A(379)-A(380) &
        -A(381))*f(5))/2._/**/REALKIND+(CI*(A(125)-A(133)+A(229)-A(236)-A(256)+A(264)-A(300)+A(302)-A(339)+A(345)+A(383) &
        -A(390))*f(6))/2._/**/REALKIND+((-A(102)-A(103)-A(110)-A(111))*f(7))/2._/**/REALKIND+(CI*(A(115)-A(122)-A(190) &
        +A(191))*f(8))/2._/**/REALKIND-A(78)*f(9)+((A(77)+A(79))*f(9))/2._/**/REALKIND+9*A(81)*f(10)+(19*(-A(80) &
        -A(82))*f(10))/4._/**/REALKIND+((-A(86)-A(87)-A(88))*f(10))/3._/**/REALKIND
  M2( 4) = ((A(140)-A(142)+A(143)-A(145)-A(441)-A(442)-A(443)-A(444)-A(445)-A(446)-A(447)-A(448)-A(449)-A(492)-A(493)-A(494) &
        -A(556)-A(557)-A(560)-A(586)-A(588)-A(589))*f(3))/2._/**/REALKIND+((-A(555)-A(558)-A(559)-A(564)-A(565)-A(566)-A(582) &
        -A(583)-A(584)-A(585)-A(587)-A(590))*f(3))/6._/**/REALKIND+(CI*(A(450)+A(453)+A(454)-A(472)-A(474)-A(475)-A(496)-A(497) &
        -A(499)+A(502)+A(503)+A(506))*f(4))/2._/**/REALKIND+((A(197)+A(200)+A(206)+A(207)+A(238)+A(239)+A(250)+A(252)+A(281) &
        +A(282)+A(285)+A(287)+A(354)+A(355)+A(362)+A(365))*f(5))/6._/**/REALKIND+((-A(92)+A(94)-A(95)+A(97)+A(149)+A(163)+A(176) &
        +A(198)+A(208)+A(222)+A(237)+A(251)+A(270)+A(283)+A(286)+A(309)+A(310)+A(311)+A(332)+A(336)+A(337)+A(356)+A(363) &
        +A(369))*f(5))/2._/**/REALKIND+(CI*(-A(162)+A(169)-A(216)+A(224)+A(268)-A(276)-A(312)+A(319)+A(327)-A(333)+A(371) &
        -A(373))*f(6))/2._/**/REALKIND+((A(138)+A(139)+A(146)+A(147))*f(7))/2._/**/REALKIND+(CI*(-A(150)+A(158)+A(178) &
        -A(180))*f(8))/2._/**/REALKIND+A(84)*f(9)+((-A(83)-A(85))*f(9))/2._/**/REALKIND+((A(80)+A(81) &
        +A(82))*f(10))/3._/**/REALKIND-9*A(87)*f(10)+(19*(A(86)+A(88))*f(10))/4._/**/REALKIND
  M2( 5) = ((-A(528)-A(529)-A(530)-A(531)-A(533)-A(536)-A(538)-A(539)-A(542))*f(3))/6._/**/REALKIND+((-A(140)+A(141)-A(144)+A(145) &
        -A(438)+A(439)+A(440)+A(442)+A(443)+A(446)-A(466)-A(467)-A(470)-A(495)-A(498)-A(500)-A(579)-A(580) &
        -A(581))*f(3))/2._/**/REALKIND+(CI*(-A(465)-A(468)-A(469)-A(479)-A(480)-A(481)+A(496)+A(497)+A(499)-A(513)-A(515) &
        -A(518))*f(4))/2._/**/REALKIND+(CI*(-A(549)-A(550)-A(551)-A(552)-A(553)-A(554))*f(4))/6._/**/REALKIND+((A(188)+A(189) &
        +A(192)+A(228)+A(234)+A(235)+A(299)+A(301)+A(303)+A(338)+A(340)+A(346))*f(5))/6._/**/REALKIND+((A(93)-A(94)+A(96)-A(97) &
        +A(156)+A(164)+A(177)+A(205)+A(223)+A(249)+A(269)+A(284)-A(308)-A(310)+A(318)+A(331)-A(335)-A(337)+A(357) &
        +A(370))*f(5))/2._/**/REALKIND+(CI*(A(230)+A(231)+A(306)+A(307)+A(343)+A(344))*f(6))/6._/**/REALKIND+(CI*(A(165)+A(167) &
        +A(218)-A(224)-A(268)+A(274)+A(317)+A(321)+A(329)+A(330)-A(371)+A(376))*f(6))/2._/**/REALKIND+((-A(137)-A(139)-A(146) &
        -A(148))*f(7))/2._/**/REALKIND+(CI*(A(155)+A(160)-A(178)+A(183))*f(8))/2._/**/REALKIND+(CI*(A(195) &
        +A(196))*f(8))/6._/**/REALKIND+A(83)*f(9)+((-A(84)-A(85))*f(9))/2._/**/REALKIND+((A(80)+A(81) &
        +A(82))*f(10))/6._/**/REALKIND-9*A(86)*f(10)+(19*(A(87)+A(88))*f(10))/4._/**/REALKIND
  M2( 6) = ((A(492)+A(493)+A(494)+A(495)+A(498)+A(500)+A(501)+A(504)+A(505))*f(3))/6._/**/REALKIND+((A(105)-A(106)+A(107)-A(108) &
        -A(393)+A(394)-A(395)-A(396)-A(399)-A(400)+A(420)+A(423)+A(424)+A(531)+A(533)+A(536)+A(582)+A(583) &
        +A(584))*f(3))/2._/**/REALKIND+(CI*(A(513)+A(514)+A(515)+A(516)+A(517)+A(518))*f(4))/6._/**/REALKIND+(CI*(A(421)+A(422) &
        +A(425)+A(433)+A(435)+A(436)-A(532)-A(534)-A(535)+A(549)+A(550)+A(554))*f(4))/2._/**/REALKIND+((-A(176)-A(177)-A(179) &
        -A(217)-A(222)-A(223)-A(269)-A(270)-A(275)-A(369)-A(370)-A(372))*f(5))/6._/**/REALKIND+((-A(89)+A(90)-A(98)+A(99)-A(119) &
        -A(129)-A(189)-A(206)-A(235)-A(250)-A(260)+A(265)+A(266)-A(287)-A(301)-A(338)-A(354)+A(378)+A(379) &
        -A(387))*f(5))/2._/**/REALKIND+(CI*(-A(218)-A(219)-A(273)-A(274)-A(376)-A(377))*f(6))/6._/**/REALKIND+(CI*(-A(128)-A(131) &
        -A(230)+A(236)-A(258)-A(261)+A(300)-A(307)+A(339)-A(343)-A(388)-A(392))*f(6))/2._/**/REALKIND+((A(101)+A(102)+A(111) &
        +A(112))*f(7))/2._/**/REALKIND+(CI*(-A(183)-A(184))*f(8))/6._/**/REALKIND+(CI*(-A(120)-A(124)+A(190) &
        -A(195))*f(8))/2._/**/REALKIND+((A(77)+A(78))*f(9))/2._/**/REALKIND-A(79)*f(9)+(19*(-A(80)-A(81))*f(10))/4._/**/REALKIND &
        +9*A(82)*f(10)+((-A(86)-A(87)-A(88))*f(10))/6._/**/REALKIND
  M2( 7) = ((A(456)+A(457)+A(458)+A(459)+A(461)+A(464)+A(466)+A(467)+A(470))*f(3))/6._/**/REALKIND+((A(104)-A(105)+A(108)-A(109) &
        +A(393)-A(394)+A(395)-A(397)-A(398)-A(401)+A(414)+A(417)+A(419)+A(538)+A(539)+A(542)+A(591)+A(592) &
        +A(593))*f(3))/2._/**/REALKIND+(CI*(A(477)+A(478)+A(479)+A(480)+A(481)+A(482))*f(4))/6._/**/REALKIND+(CI*(-A(415)-A(416) &
        -A(418)+A(432)+A(434)+A(437)+A(537)+A(540)+A(541)+A(551)+A(552)+A(553))*f(4))/2._/**/REALKIND+((-A(152)-A(153)-A(156) &
        -A(164)-A(170)-A(171)-A(314)-A(316)-A(318)-A(323)-A(325)-A(331))*f(5))/6._/**/REALKIND+((-A(90)+A(91)-A(99)+A(100)-A(117) &
        -A(135)-A(192)-A(209)-A(228)-A(245)-A(254)-A(265)+A(267)-A(288)-A(303)-A(346)-A(361)-A(378)+A(380) &
        -A(385))*f(5))/2._/**/REALKIND+(CI*(-A(166)-A(167)-A(321)-A(322)-A(328)-A(329))*f(6))/6._/**/REALKIND+(CI*(-A(130)+A(136) &
        -A(229)-A(231)+A(253)-A(259)-A(302)-A(306)-A(344)-A(345)+A(386)-A(391))*f(6))/2._/**/REALKIND+((-A(101)+A(103)+A(110) &
        -A(112))*f(7))/2._/**/REALKIND+(CI*(-A(159)-A(160))*f(8))/6._/**/REALKIND+(CI*(A(118)-A(123)-A(191) &
        -A(196))*f(8))/2._/**/REALKIND-A(77)*f(9)+((A(78)+A(79))*f(9))/2._/**/REALKIND+9*A(80)*f(10)+(19*(-A(81) &
        -A(82))*f(10))/4._/**/REALKIND+((-A(86)-A(87)-A(88))*f(10))/6._/**/REALKIND
  M2( 8) = ((-A(411)-A(412)-A(413)-A(414)-A(417)-A(419)-A(420)-A(423)-A(424))*f(3))/6._/**/REALKIND+((-A(141)+A(142)-A(143)+A(144) &
        +A(438)-A(439)-A(440)+A(441)+A(444)+A(445)-A(459)-A(461)-A(464)-A(501)-A(504)-A(505)-A(594)-A(595) &
        -A(596))*f(3))/2._/**/REALKIND+(CI*(-A(432)-A(433)-A(434)-A(435)-A(436)-A(437))*f(4))/6._/**/REALKIND+(CI*(A(460)+A(462) &
        +A(463)-A(477)-A(478)-A(482)-A(502)-A(503)-A(506)-A(514)-A(516)-A(517))*f(4))/2._/**/REALKIND+((A(92)-A(93)+A(95)-A(96) &
        +A(153)+A(171)+A(179)+A(210)+A(217)+A(246)+A(275)+A(291)+A(308)-A(309)+A(316)+A(323)+A(335)-A(336)+A(358) &
        +A(372))*f(5))/2._/**/REALKIND+((A(116)+A(117)+A(119)+A(129)+A(134)+A(135)+A(254)+A(255)+A(260)+A(384)+A(385) &
        +A(387))*f(5))/6._/**/REALKIND+(CI*(A(166)-A(172)+A(216)+A(219)+A(273)+A(276)-A(315)+A(322)-A(324)+A(328)+A(373) &
        +A(377))*f(6))/2._/**/REALKIND+(CI*(A(130)+A(131)+A(258)+A(259)+A(391)+A(392))*f(6))/6._/**/REALKIND+((A(137)-A(138) &
        -A(147)+A(148))*f(7))/2._/**/REALKIND+(CI*(A(123)+A(124))*f(8))/6._/**/REALKIND+(CI*(-A(154)+A(159)+A(180) &
        +A(184))*f(8))/2._/**/REALKIND+((-A(83)-A(84))*f(9))/2._/**/REALKIND+A(85)*f(9)+((A(80)+A(81) &
        +A(82))*f(10))/6._/**/REALKIND+(19*(A(86)+A(87))*f(10))/4._/**/REALKIND-9*A(88)*f(10)
  M2( 9) = ((-A(519)-A(520)-A(521)-A(523)-A(524)-A(527)-A(543)-A(545)-A(548))*f(3))/6._/**/REALKIND+((-A(141)+A(142)-A(143)+A(144) &
        +A(438)-A(439)-A(440)+A(441)+A(444)+A(445)-A(451)-A(452)-A(455)-A(507)-A(510)-A(512)-A(561)-A(562) &
        -A(563))*f(3))/2._/**/REALKIND+(CI*(-A(450)-A(453)-A(454)+A(479)+A(480)+A(481)+A(508)+A(509)+A(511)+A(513)+A(515) &
        +A(518))*f(4))/2._/**/REALKIND+(CI*(A(549)+A(550)+A(551)+A(552)+A(553)+A(554))*f(4))/6._/**/REALKIND+((A(185)+A(187) &
        +A(193)+A(225)+A(227)+A(232)+A(296)+A(298)+A(305)+A(341)+A(347)+A(349))*f(5))/6._/**/REALKIND+((A(92)-A(93)+A(95)-A(96) &
        +A(151)+A(161)+A(181)+A(199)+A(220)+A(240)+A(272)+A(280)+A(308)-A(309)+A(313)+A(334)+A(335)-A(336)+A(364) &
        +A(374))*f(5))/2._/**/REALKIND+(CI*(-A(230)-A(231)-A(306)-A(307)-A(343)-A(344))*f(6))/6._/**/REALKIND+(CI*(A(162)-A(167) &
        -A(218)-A(221)-A(271)-A(274)+A(312)-A(321)-A(329)+A(333)-A(375)-A(376))*f(6))/2._/**/REALKIND+((A(137)-A(138)-A(147) &
        +A(148))*f(7))/2._/**/REALKIND+(CI*(A(150)-A(160)-A(182)-A(183))*f(8))/2._/**/REALKIND+(CI*(-A(195) &
        -A(196))*f(8))/6._/**/REALKIND+((-A(83)-A(84))*f(9))/2._/**/REALKIND+A(85)*f(9)+((A(80)+A(81) &
        +A(82))*f(10))/6._/**/REALKIND+(19*(A(86)+A(87))*f(10))/4._/**/REALKIND-9*A(88)*f(10)
  M2(10) = ((A(483)+A(484)+A(485)+A(486)+A(489)+A(490)+A(507)+A(510)+A(512))*f(3))/6._/**/REALKIND+((A(104)-A(105)+A(108)-A(109) &
        +A(393)-A(394)+A(395)-A(397)-A(398)-A(401)+A(405)+A(408)+A(409)+A(543)+A(545)+A(548)+A(573)+A(574) &
        +A(575))*f(3))/2._/**/REALKIND+(CI*(-A(513)-A(514)-A(515)-A(516)-A(517)-A(518))*f(4))/6._/**/REALKIND+(CI*(A(406)+A(407) &
        +A(410)-A(433)-A(435)-A(436)-A(544)-A(546)-A(547)-A(549)-A(550)-A(554))*f(4))/2._/**/REALKIND+((-A(173)-A(174)-A(181) &
        -A(214)-A(215)-A(220)-A(272)-A(277)-A(278)-A(366)-A(367)-A(374))*f(5))/6._/**/REALKIND+((-A(90)+A(91)-A(99)+A(100)-A(114) &
        -A(126)-A(193)-A(203)-A(232)-A(244)-A(263)-A(265)+A(267)-A(294)-A(305)-A(341)-A(350)-A(378)+A(380) &
        -A(382))*f(5))/2._/**/REALKIND+(CI*(A(218)+A(219)+A(273)+A(274)+A(376)+A(377))*f(6))/6._/**/REALKIND+(CI*(-A(125)+A(131) &
        +A(230)+A(233)+A(258)-A(264)+A(304)+A(307)+A(342)+A(343)-A(383)+A(392))*f(6))/2._/**/REALKIND+((-A(101)+A(103)+A(110) &
        -A(112))*f(7))/2._/**/REALKIND+(CI*(A(183)+A(184))*f(8))/6._/**/REALKIND+(CI*(-A(115)+A(124)+A(194) &
        +A(195))*f(8))/2._/**/REALKIND-A(77)*f(9)+((A(78)+A(79))*f(9))/2._/**/REALKIND+9*A(80)*f(10)+(19*(-A(81) &
        -A(82))*f(10))/4._/**/REALKIND+((-A(86)-A(87)-A(88))*f(10))/6._/**/REALKIND
  M2(11) = ((A(447)+A(448)+A(449)+A(451)+A(452)+A(455)+A(471)+A(473)+A(476))*f(3))/6._/**/REALKIND+((A(105)-A(106)+A(107)-A(108) &
        -A(393)+A(394)-A(395)-A(396)-A(399)-A(400)+A(426)+A(429)+A(431)+A(523)+A(524)+A(527)+A(564)+A(565) &
        +A(566))*f(3))/2._/**/REALKIND+(CI*(-A(477)-A(478)-A(479)-A(480)-A(481)-A(482))*f(4))/6._/**/REALKIND+(CI*(-A(427)-A(428) &
        -A(430)-A(432)-A(434)-A(437)+A(522)+A(525)+A(526)-A(551)-A(552)-A(553))*f(4))/2._/**/REALKIND+((-A(149)-A(151)-A(157) &
        -A(161)-A(163)-A(168)-A(311)-A(313)-A(320)-A(326)-A(332)-A(334))*f(5))/6._/**/REALKIND+((-A(89)+A(90)-A(98)+A(99)-A(121) &
        -A(132)-A(187)-A(200)-A(225)-A(239)-A(257)+A(265)+A(266)-A(281)-A(298)-A(349)-A(365)+A(378)+A(379) &
        -A(389))*f(5))/2._/**/REALKIND+(CI*(A(166)+A(167)+A(321)+A(322)+A(328)+A(329))*f(6))/6._/**/REALKIND+(CI*(A(130)+A(133) &
        -A(226)+A(231)+A(256)+A(259)-A(297)+A(306)+A(344)-A(348)+A(390)+A(391))*f(6))/2._/**/REALKIND+((A(101)+A(102)+A(111) &
        +A(112))*f(7))/2._/**/REALKIND+(CI*(A(159)+A(160))*f(8))/6._/**/REALKIND+(CI*(A(122)+A(123)-A(186) &
        +A(196))*f(8))/2._/**/REALKIND+((A(77)+A(78))*f(9))/2._/**/REALKIND-A(79)*f(9)+(19*(-A(80)-A(81))*f(10))/4._/**/REALKIND &
        +9*A(82)*f(10)+((-A(86)-A(87)-A(88))*f(10))/6._/**/REALKIND
  M2(12) = ((-A(402)-A(403)-A(404)-A(405)-A(408)-A(409)-A(426)-A(429)-A(431))*f(3))/6._/**/REALKIND+((-A(140)+A(141)-A(144)+A(145) &
        -A(438)+A(439)+A(440)+A(442)+A(443)+A(446)-A(471)-A(473)-A(476)-A(486)-A(489)-A(490)-A(576)-A(577) &
        -A(578))*f(3))/2._/**/REALKIND+(CI*(A(432)+A(433)+A(434)+A(435)+A(436)+A(437))*f(4))/6._/**/REALKIND+(CI*(A(472)+A(474) &
        +A(475)+A(477)+A(478)+A(482)-A(487)-A(488)-A(491)+A(514)+A(516)+A(517))*f(4))/2._/**/REALKIND+((A(93)-A(94)+A(96)-A(97) &
        +A(157)+A(168)+A(174)+A(204)+A(214)+A(243)+A(278)+A(295)-A(308)-A(310)+A(320)+A(326)-A(335)-A(337)+A(351) &
        +A(367))*f(5))/2._/**/REALKIND+((A(113)+A(114)+A(121)+A(126)+A(127)+A(132)+A(257)+A(262)+A(263)+A(381)+A(382) &
        +A(389))*f(5))/6._/**/REALKIND+(CI*(-A(166)-A(169)+A(213)-A(219)-A(273)+A(279)-A(319)-A(322)-A(327)-A(328)+A(368) &
        -A(377))*f(6))/2._/**/REALKIND+(CI*(-A(130)-A(131)-A(258)-A(259)-A(391)-A(392))*f(6))/6._/**/REALKIND+((-A(137)-A(139) &
        -A(146)-A(148))*f(7))/2._/**/REALKIND+(CI*(-A(123)-A(124))*f(8))/6._/**/REALKIND+(CI*(-A(158)-A(159)+A(175) &
        -A(184))*f(8))/2._/**/REALKIND+A(83)*f(9)+((-A(84)-A(85))*f(9))/2._/**/REALKIND+((A(80)+A(81) &
        +A(82))*f(10))/6._/**/REALKIND-9*A(86)*f(10)+(19*(A(87)+A(88))*f(10))/4._/**/REALKIND
  M2(13) = ((A(80)+A(81)+A(82))*f(10))/3._/**/REALKIND+(2*(A(86)+A(87)+A(88))*f(10))/9._/**/REALKIND
  M2(14) = (2*(-A(80)-A(81)-A(82))*f(10))/9._/**/REALKIND+((-A(86)-A(87)-A(88))*f(10))/3._/**/REALKIND

end subroutine colourvectors

end module ol_loop_pptttt_tttxtxgg_1_/**/REALKIND
