
module ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND
  implicit none
  logical, save           :: colmat_not_initialised = .true.
  complex(REALKIND), save :: K1(1440,48)
  contains
  subroutine colourmatrix_init
    use ol_parameters_decl_/**/REALKIND, only: CI
    implicit none
    colmat_not_initialised = .false.
    ! colour matrix

  K1(   1,:) = [  1152,   384,   384,   126,   144,   384,     6,     0,  -144,   -48,   -48,   -36,   -18,   -48,   -48,     0, &
                  -18,   -48,   -48,     0,   144,     6,   384,     0,     0,   384,     6,   144,     0,   -48,   -48,   -18, &
                    0,   -48,    60,   144,     0,     6,     6,   -18,     0,     6,   384,   144,     0,    60,   -48,   144]
  K1(   2,:) = [   384,  1152,   126,   384,   384,   144,     0,     6,   -48,  -144,   -36,   -48,   -48,   -18,     0,   -48, &
                  -48,   -18,     0,   -48,     6,   144,     0,   384,   384,     0,   144,     6,   -48,     0,   -18,   -48, &
                  -48,     0,   144,    60,     6,     0,   -18,     6,     6,     0,   144,   384,    60,     0,   144,   -48]
  K1(   3,:) = [   384,   126,  1152,   384,     6,     0,   144,   384,   -48,   -36,  -144,   -48,   -48,     0,   -18,   -48, &
                  -48,     0,   -18,   -48,   384,     0,   144,     6,     6,   144,     0,   384,   -48,   -18,     0,   -48, &
                   60,   144,     0,   -48,     6,   -18,     0,     6,   384,   144,     0,     6,   -48,   144,     0,    60]
  K1(   4,:) = [   126,   384,   384,  1152,     0,     6,   384,   144,   -36,   -48,   -48,  -144,     0,   -48,   -48,   -18, &
                    0,   -48,   -48,   -18,     0,   384,     6,   144,   144,     6,   384,     0,   -18,   -48,   -48,     0, &
                  144,    60,   -48,     0,   -18,     6,     6,     0,   144,   384,     6,     0,   144,   -48,    60,     0]
  K1(   5,:) = [   144,   384,     6,     0,  1152,   384,   384,   126,   -18,   -48,   -48,     0,   144,     6,   384,     0, &
                 -144,   -48,   -48,   -36,   -18,   -48,   -48,     0,     0,   -48,   -48,   -18,     0,   384,     6,   144, &
                    0,     6,   384,   144,     0,    60,   -48,   144,     0,   -48,    60,   144,     0,     6,     6,   -18]
  K1(   6,:) = [   384,   144,     0,     6,   384,  1152,   126,   384,   -48,   -18,     0,   -48,     6,   144,     0,   384, &
                  -48,  -144,   -36,   -48,   -48,   -18,     0,   -48,   -48,     0,   -18,   -48,   384,     0,   144,     6, &
                    6,     0,   144,   384,    60,     0,   144,   -48,   -48,     0,   144,    60,     6,     0,   -18,     6]
  K1(   7,:) = [     6,     0,   144,   384,   384,   126,  1152,   384,   -48,     0,   -18,   -48,   384,     0,   144,     6, &
                  -48,   -36,  -144,   -48,   -48,     0,   -18,   -48,   -48,   -18,     0,   -48,     6,   144,     0,   384, &
                  384,   144,     0,     6,   -48,   144,     0,    60,    60,   144,     0,   -48,     6,   -18,     0,     6]
  K1(   8,:) = [     0,     6,   384,   144,   126,   384,   384,  1152,     0,   -48,   -48,   -18,     0,   384,     6,   144, &
                  -36,   -48,   -48,  -144,     0,   -48,   -48,   -18,   -18,   -48,   -48,     0,   144,     6,   384,     0, &
                  144,   384,     6,     0,   144,   -48,    60,     0,   144,    60,   -48,     0,   -18,     6,     6,     0]
  K1(   9,:) = [  -144,   -48,   -48,   -36,   -18,   -48,   -48,     0,  1152,   384,   384,   126,   144,   384,     6,     0, &
                  144,     6,   384,     0,   -18,   -48,   -48,     0,     0,   -48,    60,   144,     0,     6,     6,   -18, &
                    0,   384,     6,   144,     0,   -48,   -48,   -18,     0,    60,   -48,   144,     0,     6,   384,   144]
  K1(  10,:) = [   -48,  -144,   -36,   -48,   -48,   -18,     0,   -48,   384,  1152,   126,   384,   384,   144,     0,     6, &
                    6,   144,     0,   384,   -48,   -18,     0,   -48,   -48,     0,   144,    60,     6,     0,   -18,     6, &
                  384,     0,   144,     6,   -48,     0,   -18,   -48,    60,     0,   144,   -48,     6,     0,   144,   384]
  K1(  11,:) = [   -48,   -36,  -144,   -48,   -48,     0,   -18,   -48,   384,   126,  1152,   384,     6,     0,   144,   384, &
                  384,     0,   144,     6,   -48,     0,   -18,   -48,    60,   144,     0,   -48,     6,   -18,     0,     6, &
                    6,   144,     0,   384,   -48,   -18,     0,   -48,   -48,   144,     0,    60,   384,   144,     0,     6]
  K1(  12,:) = [   -36,   -48,   -48,  -144,     0,   -48,   -48,   -18,   126,   384,   384,  1152,     0,     6,   384,   144, &
                    0,   384,     6,   144,     0,   -48,   -48,   -18,   144,    60,   -48,     0,   -18,     6,     6,     0, &
                  144,     6,   384,     0,   -18,   -48,   -48,     0,   144,   -48,    60,     0,   144,   384,     6,     0]
  K1(  13,:) = [   -18,   -48,   -48,     0,   144,     6,   384,     0,   144,   384,     6,     0,  1152,   384,   384,   126, &
                  -18,   -48,   -48,     0,  -144,   -48,   -48,   -36,     0,     6,   384,   144,     0,    60,   -48,   144, &
                    0,   -48,   -48,   -18,     0,   384,     6,   144,     0,     6,     6,   -18,     0,   -48,    60,   144]
  K1(  14,:) = [   -48,   -18,     0,   -48,     6,   144,     0,   384,   384,   144,     0,     6,   384,  1152,   126,   384, &
                  -48,   -18,     0,   -48,   -48,  -144,   -36,   -48,     6,     0,   144,   384,    60,     0,   144,   -48, &
                  -48,     0,   -18,   -48,   384,     0,   144,     6,     6,     0,   -18,     6,   -48,     0,   144,    60]
  K1(  15,:) = [   -48,     0,   -18,   -48,   384,     0,   144,     6,     6,     0,   144,   384,   384,   126,  1152,   384, &
                  -48,     0,   -18,   -48,   -48,   -36,  -144,   -48,   384,   144,     0,     6,   -48,   144,     0,    60, &
                  -48,   -18,     0,   -48,     6,   144,     0,   384,     6,   -18,     0,     6,    60,   144,     0,   -48]
  K1(  16,:) = [     0,   -48,   -48,   -18,     0,   384,     6,   144,     0,     6,   384,   144,   126,   384,   384,  1152, &
                    0,   -48,   -48,   -18,   -36,   -48,   -48,  -144,   144,   384,     6,     0,   144,   -48,    60,     0, &
                  -18,   -48,   -48,     0,   144,     6,   384,     0,   -18,     6,     6,     0,   144,    60,   -48,     0]
  K1(  17,:) = [   -18,   -48,   -48,     0,  -144,   -48,   -48,   -36,   144,     6,   384,     0,   -18,   -48,   -48,     0, &
                 1152,   384,   384,   126,   144,   384,     6,     0,     0,     6,     6,   -18,     0,   -48,    60,   144, &
                    0,    60,   -48,   144,     0,     6,   384,   144,     0,   384,     6,   144,     0,   -48,   -48,   -18]
  K1(  18,:) = [   -48,   -18,     0,   -48,   -48,  -144,   -36,   -48,     6,   144,     0,   384,   -48,   -18,     0,   -48, &
                  384,  1152,   126,   384,   384,   144,     0,     6,     6,     0,   -18,     6,   -48,     0,   144,    60, &
                   60,     0,   144,   -48,     6,     0,   144,   384,   384,     0,   144,     6,   -48,     0,   -18,   -48]
  K1(  19,:) = [   -48,     0,   -18,   -48,   -48,   -36,  -144,   -48,   384,     0,   144,     6,   -48,     0,   -18,   -48, &
                  384,   126,  1152,   384,     6,     0,   144,   384,     6,   -18,     0,     6,    60,   144,     0,   -48, &
                  -48,   144,     0,    60,   384,   144,     0,     6,     6,   144,     0,   384,   -48,   -18,     0,   -48]
  K1(  20,:) = [     0,   -48,   -48,   -18,   -36,   -48,   -48,  -144,     0,   384,     6,   144,     0,   -48,   -48,   -18, &
                  126,   384,   384,  1152,     0,     6,   384,   144,   -18,     6,     6,     0,   144,    60,   -48,     0, &
                  144,   -48,    60,     0,   144,   384,     6,     0,   144,     6,   384,     0,   -18,   -48,   -48,     0]
  K1(  21,:) = [   144,     6,   384,     0,   -18,   -48,   -48,     0,   -18,   -48,   -48,     0,  -144,   -48,   -48,   -36, &
                  144,   384,     6,     0,  1152,   384,   384,   126,     0,    60,   -48,   144,     0,     6,   384,   144, &
                    0,     6,     6,   -18,     0,   -48,    60,   144,     0,   -48,   -48,   -18,     0,   384,     6,   144]
  K1(  22,:) = [     6,   144,     0,   384,   -48,   -18,     0,   -48,   -48,   -18,     0,   -48,   -48,  -144,   -36,   -48, &
                  384,   144,     0,     6,   384,  1152,   126,   384,    60,     0,   144,   -48,     6,     0,   144,   384, &
                    6,     0,   -18,     6,   -48,     0,   144,    60,   -48,     0,   -18,   -48,   384,     0,   144,     6]
  K1(  23,:) = [   384,     0,   144,     6,   -48,     0,   -18,   -48,   -48,     0,   -18,   -48,   -48,   -36,  -144,   -48, &
                    6,     0,   144,   384,   384,   126,  1152,   384,   -48,   144,     0,    60,   384,   144,     0,     6, &
                    6,   -18,     0,     6,    60,   144,     0,   -48,   -48,   -18,     0,   -48,     6,   144,     0,   384]
  K1(  24,:) = [     0,   384,     6,   144,     0,   -48,   -48,   -18,     0,   -48,   -48,   -18,   -36,   -48,   -48,  -144, &
                    0,     6,   384,   144,   126,   384,   384,  1152,   144,   -48,    60,     0,   144,   384,     6,     0, &
                  -18,     6,     6,     0,   144,    60,   -48,     0,   -18,   -48,   -48,     0,   144,     6,   384,     0]
  K1(  25,:) = [     0,   384,     6,   144,     0,   -48,   -48,   -18,     0,   -48,    60,   144,     0,     6,   384,   144, &
                    0,     6,     6,   -18,     0,    60,   -48,   144,  1152,   384,   384,   126,  -144,   -48,   -48,   -36, &
                 -144,   -48,   -48,   -36,    18,     6,     6,   126,    18,     6,     6,   126,   180,    60,    60,   -36]
  K1(  26,:) = [   384,     0,   144,     6,   -48,     0,   -18,   -48,   -48,     0,   144,    60,     6,     0,   144,   384, &
                    6,     0,   -18,     6,    60,     0,   144,   -48,   384,  1152,   126,   384,   -48,  -144,   -36,   -48, &
                  -48,  -144,   -36,   -48,     6,    18,   126,     6,     6,    18,   126,     6,    60,   180,   -36,    60]
  K1(  27,:) = [     6,   144,     0,   384,   -48,   -18,     0,   -48,    60,   144,     0,   -48,   384,   144,     0,     6, &
                    6,   -18,     0,     6,   -48,   144,     0,    60,   384,   126,  1152,   384,   -48,   -36,  -144,   -48, &
                  -48,   -36,  -144,   -48,     6,   126,    18,     6,     6,   126,    18,     6,    60,   -36,   180,    60]
  K1(  28,:) = [   144,     6,   384,     0,   -18,   -48,   -48,     0,   144,    60,   -48,     0,   144,   384,     6,     0, &
                  -18,     6,     6,     0,   144,   -48,    60,     0,   126,   384,   384,  1152,   -36,   -48,   -48,  -144, &
                  -36,   -48,   -48,  -144,   126,     6,     6,    18,   126,     6,     6,    18,   -36,    60,    60,   180]
  K1(  29,:) = [     0,   -48,   -48,   -18,     0,   384,     6,   144,     0,     6,     6,   -18,     0,    60,   -48,   144, &
                    0,   -48,    60,   144,     0,     6,   384,   144,  -144,   -48,   -48,   -36,  1152,   384,   384,   126, &
                   18,     6,     6,   126,   180,    60,    60,   -36,  -144,   -48,   -48,   -36,    18,     6,     6,   126]
  K1(  30,:) = [   -48,     0,   -18,   -48,   384,     0,   144,     6,     6,     0,   -18,     6,    60,     0,   144,   -48, &
                  -48,     0,   144,    60,     6,     0,   144,   384,   -48,  -144,   -36,   -48,   384,  1152,   126,   384, &
                    6,    18,   126,     6,    60,   180,   -36,    60,   -48,  -144,   -36,   -48,     6,    18,   126,     6]
  K1(  31,:) = [   -48,   -18,     0,   -48,     6,   144,     0,   384,     6,   -18,     0,     6,   -48,   144,     0,    60, &
                   60,   144,     0,   -48,   384,   144,     0,     6,   -48,   -36,  -144,   -48,   384,   126,  1152,   384, &
                    6,   126,    18,     6,    60,   -36,   180,    60,   -48,   -36,  -144,   -48,     6,   126,    18,     6]
  K1(  32,:) = [   -18,   -48,   -48,     0,   144,     6,   384,     0,   -18,     6,     6,     0,   144,   -48,    60,     0, &
                  144,    60,   -48,     0,   144,   384,     6,     0,   -36,   -48,   -48,  -144,   126,   384,   384,  1152, &
                  126,     6,     6,    18,   -36,    60,    60,   180,   -36,   -48,   -48,  -144,   126,     6,     6,    18]
  K1(  33,:) = [     0,   -48,    60,   144,     0,     6,   384,   144,     0,   384,     6,   144,     0,   -48,   -48,   -18, &
                    0,    60,   -48,   144,     0,     6,     6,   -18,  -144,   -48,   -48,   -36,    18,     6,     6,   126, &
                 1152,   384,   384,   126,  -144,   -48,   -48,   -36,   180,    60,    60,   -36,    18,     6,     6,   126]
  K1(  34,:) = [   -48,     0,   144,    60,     6,     0,   144,   384,   384,     0,   144,     6,   -48,     0,   -18,   -48, &
                   60,     0,   144,   -48,     6,     0,   -18,     6,   -48,  -144,   -36,   -48,     6,    18,   126,     6, &
                  384,  1152,   126,   384,   -48,  -144,   -36,   -48,    60,   180,   -36,    60,     6,    18,   126,     6]
  K1(  35,:) = [    60,   144,     0,   -48,   384,   144,     0,     6,     6,   144,     0,   384,   -48,   -18,     0,   -48, &
                  -48,   144,     0,    60,     6,   -18,     0,     6,   -48,   -36,  -144,   -48,     6,   126,    18,     6, &
                  384,   126,  1152,   384,   -48,   -36,  -144,   -48,    60,   -36,   180,    60,     6,   126,    18,     6]
  K1(  36,:) = [   144,    60,   -48,     0,   144,   384,     6,     0,   144,     6,   384,     0,   -18,   -48,   -48,     0, &
                  144,   -48,    60,     0,   -18,     6,     6,     0,   -36,   -48,   -48,  -144,   126,     6,     6,    18, &
                  126,   384,   384,  1152,   -36,   -48,   -48,  -144,   -36,    60,    60,   180,   126,     6,     6,    18]
  K1(  37,:) = [     0,     6,     6,   -18,     0,    60,   -48,   144,     0,   -48,   -48,   -18,     0,   384,     6,   144, &
                    0,     6,   384,   144,     0,   -48,    60,   144,    18,     6,     6,   126,   180,    60,    60,   -36, &
                 -144,   -48,   -48,   -36,  1152,   384,   384,   126,    18,     6,     6,   126,  -144,   -48,   -48,   -36]
  K1(  38,:) = [     6,     0,   -18,     6,    60,     0,   144,   -48,   -48,     0,   -18,   -48,   384,     0,   144,     6, &
                    6,     0,   144,   384,   -48,     0,   144,    60,     6,    18,   126,     6,    60,   180,   -36,    60, &
                  -48,  -144,   -36,   -48,   384,  1152,   126,   384,     6,    18,   126,     6,   -48,  -144,   -36,   -48]
  K1(  39,:) = [     6,   -18,     0,     6,   -48,   144,     0,    60,   -48,   -18,     0,   -48,     6,   144,     0,   384, &
                  384,   144,     0,     6,    60,   144,     0,   -48,     6,   126,    18,     6,    60,   -36,   180,    60, &
                  -48,   -36,  -144,   -48,   384,   126,  1152,   384,     6,   126,    18,     6,   -48,   -36,  -144,   -48]
  K1(  40,:) = [   -18,     6,     6,     0,   144,   -48,    60,     0,   -18,   -48,   -48,     0,   144,     6,   384,     0, &
                  144,   384,     6,     0,   144,    60,   -48,     0,   126,     6,     6,    18,   -36,    60,    60,   180, &
                  -36,   -48,   -48,  -144,   126,   384,   384,  1152,   126,     6,     6,    18,   -36,   -48,   -48,  -144]
  K1(  41,:) = [     0,     6,   384,   144,     0,   -48,    60,   144,     0,    60,   -48,   144,     0,     6,     6,   -18, &
                    0,   384,     6,   144,     0,   -48,   -48,   -18,    18,     6,     6,   126,  -144,   -48,   -48,   -36, &
                  180,    60,    60,   -36,    18,     6,     6,   126,  1152,   384,   384,   126,  -144,   -48,   -48,   -36]
  K1(  42,:) = [     6,     0,   144,   384,   -48,     0,   144,    60,    60,     0,   144,   -48,     6,     0,   -18,     6, &
                  384,     0,   144,     6,   -48,     0,   -18,   -48,     6,    18,   126,     6,   -48,  -144,   -36,   -48, &
                   60,   180,   -36,    60,     6,    18,   126,     6,   384,  1152,   126,   384,   -48,  -144,   -36,   -48]
  K1(  43,:) = [   384,   144,     0,     6,    60,   144,     0,   -48,   -48,   144,     0,    60,     6,   -18,     0,     6, &
                    6,   144,     0,   384,   -48,   -18,     0,   -48,     6,   126,    18,     6,   -48,   -36,  -144,   -48, &
                   60,   -36,   180,    60,     6,   126,    18,     6,   384,   126,  1152,   384,   -48,   -36,  -144,   -48]
  K1(  44,:) = [   144,   384,     6,     0,   144,    60,   -48,     0,   144,   -48,    60,     0,   -18,     6,     6,     0, &
                  144,     6,   384,     0,   -18,   -48,   -48,     0,   126,     6,     6,    18,   -36,   -48,   -48,  -144, &
                  -36,    60,    60,   180,   126,     6,     6,    18,   126,   384,   384,  1152,   -36,   -48,   -48,  -144]
  K1(  45,:) = [     0,    60,   -48,   144,     0,     6,     6,   -18,     0,     6,   384,   144,     0,   -48,    60,   144, &
                    0,   -48,   -48,   -18,     0,   384,     6,   144,   180,    60,    60,   -36,    18,     6,     6,   126, &
                   18,     6,     6,   126,  -144,   -48,   -48,   -36,  -144,   -48,   -48,   -36,  1152,   384,   384,   126]
  K1(  46,:) = [    60,     0,   144,   -48,     6,     0,   -18,     6,     6,     0,   144,   384,   -48,     0,   144,    60, &
                  -48,     0,   -18,   -48,   384,     0,   144,     6,    60,   180,   -36,    60,     6,    18,   126,     6, &
                    6,    18,   126,     6,   -48,  -144,   -36,   -48,   -48,  -144,   -36,   -48,   384,  1152,   126,   384]
  K1(  47,:) = [   -48,   144,     0,    60,     6,   -18,     0,     6,   384,   144,     0,     6,    60,   144,     0,   -48, &
                  -48,   -18,     0,   -48,     6,   144,     0,   384,    60,   -36,   180,    60,     6,   126,    18,     6, &
                    6,   126,    18,     6,   -48,   -36,  -144,   -48,   -48,   -36,  -144,   -48,   384,   126,  1152,   384]
  K1(  48,:) = [   144,   -48,    60,     0,   -18,     6,     6,     0,   144,   384,     6,     0,   144,    60,   -48,     0, &
                  -18,   -48,   -48,     0,   144,     6,   384,     0,   -36,    60,    60,   180,   126,     6,     6,    18, &
                  126,     6,     6,    18,   -36,   -48,   -48,  -144,   -36,   -48,   -48,  -144,   126,   384,   384,  1152]
  K1(  49,:) = [  1536,   512,   512,   168,   192,   512,     8,     0,  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,   -64,    80,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,    80,   -64,   192]
  K1(  50,:) = [   512,  1536,   168,   512,   512,   192,     0,     8,   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  -64,     0,   192,    80,     8,     0,   -24,     8,     8,     0,   192,   512,    80,     0,   192,   -64]
  K1(  51,:) = [   512,   168,  1536,   512,     8,     0,   192,   512,   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                   80,   192,     0,   -64,     8,   -24,     0,     8,   512,   192,     0,     8,   -64,   192,     0,    80]
  K1(  52,:) = [   168,   512,   512,  1536,     0,     8,   512,   192,   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,    80,   -64,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,   -64,    80,     0]
  K1(  53,:) = [   192,   512,     8,     0,  1536,   512,   512,   168,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                 -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,    80,   -64,   192,     0,   -64,    80,   192,     0,     8,     8,   -24]
  K1(  54,:) = [   512,   192,     0,     8,   512,  1536,   168,   512,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,    80,     0,   192,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8]
  K1(  55,:) = [     8,     0,   192,   512,   512,   168,  1536,   512,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                  -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,   -64,   192,     0,    80,    80,   192,     0,   -64,     8,   -24,     0,     8]
  K1(  56,:) = [     0,     8,   512,   192,   168,   512,   512,  1536,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                  -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,   -64,    80,     0,   192,    80,   -64,     0,   -24,     8,     8,     0]
  K1(  57,:) = [  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,  1536,   512,   512,   168,   192,   512,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,     0,   -64,    80,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,     0,    80,   -64,   192,     0,     8,   512,   192]
  K1(  58,:) = [   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   512,  1536,   168,   512,   512,   192,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,     0,   192,   -64,     8,     0,   192,   512]
  K1(  59,:) = [   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   512,   168,  1536,   512,     8,     0,   192,   512, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,   192,     0,   -64,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   192,     0,    80,   512,   192,     0,     8]
  K1(  60,:) = [   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   168,   512,   512,  1536,     0,     8,   512,   192, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,   192,    80,   -64,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   192,   -64,    80,     0,   192,   512,     8,     0]
  K1(  61,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   192,   512,     8,     0,  1536,   512,   512,   168, &
                  -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,     0,     8,   512,   192,     0,    80,   -64,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,   -64,    80,   192]
  K1(  62,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,   512,   192,     0,     8,   512,  1536,   168,   512, &
                  -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,     0,   192,   512,    80,     0,   192,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,   -64,     0,   192,    80]
  K1(  63,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   192,   512,   512,   168,  1536,   512, &
                  -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,   192,     0,     8,   -64,   192,     0,    80, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,    80,   192,     0,   -64]
  K1(  64,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,   512,   192,   168,   512,   512,  1536, &
                    0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,   192,   512,     8,     0,   192,   -64,    80,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,    80,   -64,     0]
  K1(  65,:) = [   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                 1536,   512,   512,   168,   192,   512,     8,     0,     0,     8,     8,   -24,     0,   -64,    80,   192, &
                    0,    80,   -64,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24]
  K1(  66,:) = [   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  512,  1536,   168,   512,   512,   192,     0,     8,     8,     0,   -24,     8,   -64,     0,   192,    80, &
                   80,     0,   192,   -64,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64]
  K1(  67,:) = [   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  512,   168,  1536,   512,     8,     0,   192,   512,     8,   -24,     0,     8,    80,   192,     0,   -64, &
                  -64,   192,     0,    80,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64]
  K1(  68,:) = [     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                  168,   512,   512,  1536,     0,     8,   512,   192,   -24,     8,     8,     0,   192,    80,   -64,     0, &
                  192,   -64,    80,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0]
  K1(  69,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48, &
                  192,   512,     8,     0,  1536,   512,   512,   168,     0,    80,   -64,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,   -64,    80,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192]
  K1(  70,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64, &
                  512,   192,     0,     8,   512,  1536,   168,   512,    80,     0,   192,   -64,     8,     0,   192,   512, &
                    8,     0,   -24,     8,   -64,     0,   192,    80,   -64,     0,   -24,   -64,   512,     0,   192,     8]
  K1(  71,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64, &
                    8,     0,   192,   512,   512,   168,  1536,   512,   -64,   192,     0,    80,   512,   192,     0,     8, &
                    8,   -24,     0,     8,    80,   192,     0,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512]
  K1(  72,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192, &
                    0,     8,   512,   192,   168,   512,   512,  1536,   192,   -64,    80,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,    80,   -64,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0]
  K1(  73,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,    80,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,    80,   -64,   192,  1536,   512,   512,   168,  -192,   -64,   -64,   -48, &
                 -192,   -64,   -64,   -48,    24,     8,     8,   168,    24,     8,     8,   168,   240,    80,    80,   -48]
  K1(  74,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   192,    80,     8,     0,   192,   512, &
                    8,     0,   -24,     8,    80,     0,   192,   -64,   512,  1536,   168,   512,   -64,  -192,   -48,   -64, &
                  -64,  -192,   -48,   -64,     8,    24,   168,     8,     8,    24,   168,     8,    80,   240,   -48,    80]
  K1(  75,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,    80,   192,     0,   -64,   512,   192,     0,     8, &
                    8,   -24,     0,     8,   -64,   192,     0,    80,   512,   168,  1536,   512,   -64,   -48,  -192,   -64, &
                  -64,   -48,  -192,   -64,     8,   168,    24,     8,     8,   168,    24,     8,    80,   -48,   240,    80]
  K1(  76,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   192,    80,   -64,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,   -64,    80,     0,   168,   512,   512,  1536,   -48,   -64,   -64,  -192, &
                  -48,   -64,   -64,  -192,   168,     8,     8,    24,   168,     8,     8,    24,   -48,    80,    80,   240]
  K1(  77,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,    80,   -64,   192, &
                    0,   -64,    80,   192,     0,     8,   512,   192,  -192,   -64,   -64,   -48,  1536,   512,   512,   168, &
                   24,     8,     8,   168,   240,    80,    80,   -48,  -192,   -64,   -64,   -48,    24,     8,     8,   168]
  K1(  78,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,    80,     0,   192,   -64, &
                  -64,     0,   192,    80,     8,     0,   192,   512,   -64,  -192,   -48,   -64,   512,  1536,   168,   512, &
                    8,    24,   168,     8,    80,   240,   -48,    80,   -64,  -192,   -48,   -64,     8,    24,   168,     8]
  K1(  79,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,   -64,   192,     0,    80, &
                   80,   192,     0,   -64,   512,   192,     0,     8,   -64,   -48,  -192,   -64,   512,   168,  1536,   512, &
                    8,   168,    24,     8,    80,   -48,   240,    80,   -64,   -48,  -192,   -64,     8,   168,    24,     8]
  K1(  80,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,   -64,    80,     0, &
                  192,    80,   -64,     0,   192,   512,     8,     0,   -48,   -64,   -64,  -192,   168,   512,   512,  1536, &
                  168,     8,     8,    24,   -48,    80,    80,   240,   -48,   -64,   -64,  -192,   168,     8,     8,    24]
  K1(  81,:) = [     0,   -64,    80,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,    80,   -64,   192,     0,     8,     8,   -24,  -192,   -64,   -64,   -48,    24,     8,     8,   168, &
                 1536,   512,   512,   168,  -192,   -64,   -64,   -48,   240,    80,    80,   -48,    24,     8,     8,   168]
  K1(  82,:) = [   -64,     0,   192,    80,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                   80,     0,   192,   -64,     8,     0,   -24,     8,   -64,  -192,   -48,   -64,     8,    24,   168,     8, &
                  512,  1536,   168,   512,   -64,  -192,   -48,   -64,    80,   240,   -48,    80,     8,    24,   168,     8]
  K1(  83,:) = [    80,   192,     0,   -64,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  -64,   192,     0,    80,     8,   -24,     0,     8,   -64,   -48,  -192,   -64,     8,   168,    24,     8, &
                  512,   168,  1536,   512,   -64,   -48,  -192,   -64,    80,   -48,   240,    80,     8,   168,    24,     8]
  K1(  84,:) = [   192,    80,   -64,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,   -64,    80,     0,   -24,     8,     8,     0,   -48,   -64,   -64,  -192,   168,     8,     8,    24, &
                  168,   512,   512,  1536,   -48,   -64,   -64,  -192,   -48,    80,    80,   240,   168,     8,     8,    24]
  K1(  85,:) = [     0,     8,     8,   -24,     0,    80,   -64,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,   -64,    80,   192,    24,     8,     8,   168,   240,    80,    80,   -48, &
                 -192,   -64,   -64,   -48,  1536,   512,   512,   168,    24,     8,     8,   168,  -192,   -64,   -64,   -48]
  K1(  86,:) = [     8,     0,   -24,     8,    80,     0,   192,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,   -64,     0,   192,    80,     8,    24,   168,     8,    80,   240,   -48,    80, &
                  -64,  -192,   -48,   -64,   512,  1536,   168,   512,     8,    24,   168,     8,   -64,  -192,   -48,   -64]
  K1(  87,:) = [     8,   -24,     0,     8,   -64,   192,     0,    80,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,    80,   192,     0,   -64,     8,   168,    24,     8,    80,   -48,   240,    80, &
                  -64,   -48,  -192,   -64,   512,   168,  1536,   512,     8,   168,    24,     8,   -64,   -48,  -192,   -64]
  K1(  88,:) = [   -24,     8,     8,     0,   192,   -64,    80,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,    80,   -64,     0,   168,     8,     8,    24,   -48,    80,    80,   240, &
                  -48,   -64,   -64,  -192,   168,   512,   512,  1536,   168,     8,     8,    24,   -48,   -64,   -64,  -192]
  K1(  89,:) = [     0,     8,   512,   192,     0,   -64,    80,   192,     0,    80,   -64,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,    24,     8,     8,   168,  -192,   -64,   -64,   -48, &
                  240,    80,    80,   -48,    24,     8,     8,   168,  1536,   512,   512,   168,  -192,   -64,   -64,   -48]
  K1(  90,:) = [     8,     0,   192,   512,   -64,     0,   192,    80,    80,     0,   192,   -64,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,     8,    24,   168,     8,   -64,  -192,   -48,   -64, &
                   80,   240,   -48,    80,     8,    24,   168,     8,   512,  1536,   168,   512,   -64,  -192,   -48,   -64]
  K1(  91,:) = [   512,   192,     0,     8,    80,   192,     0,   -64,   -64,   192,     0,    80,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,     8,   168,    24,     8,   -64,   -48,  -192,   -64, &
                   80,   -48,   240,    80,     8,   168,    24,     8,   512,   168,  1536,   512,   -64,   -48,  -192,   -64]
  K1(  92,:) = [   192,   512,     8,     0,   192,    80,   -64,     0,   192,   -64,    80,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   168,     8,     8,    24,   -48,   -64,   -64,  -192, &
                  -48,    80,    80,   240,   168,     8,     8,    24,   168,   512,   512,  1536,   -48,   -64,   -64,  -192]
  K1(  93,:) = [     0,    80,   -64,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,   -64,    80,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   240,    80,    80,   -48,    24,     8,     8,   168, &
                   24,     8,     8,   168,  -192,   -64,   -64,   -48,  -192,   -64,   -64,   -48,  1536,   512,   512,   168]
  K1(  94,:) = [    80,     0,   192,   -64,     8,     0,   -24,     8,     8,     0,   192,   512,   -64,     0,   192,    80, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,    80,   240,   -48,    80,     8,    24,   168,     8, &
                    8,    24,   168,     8,   -64,  -192,   -48,   -64,   -64,  -192,   -48,   -64,   512,  1536,   168,   512]
  K1(  95,:) = [   -64,   192,     0,    80,     8,   -24,     0,     8,   512,   192,     0,     8,    80,   192,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,    80,   -48,   240,    80,     8,   168,    24,     8, &
                    8,   168,    24,     8,   -64,   -48,  -192,   -64,   -64,   -48,  -192,   -64,   512,   168,  1536,   512]
  K1(  96,:) = [   192,   -64,    80,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,    80,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -48,    80,    80,   240,   168,     8,     8,    24, &
                  168,     8,     8,    24,   -48,   -64,   -64,  -192,   -48,   -64,   -64,  -192,   168,   512,   512,  1536]
  K1(  97,:) = [     0,   512,    -1,   171,   168,     8,    -1,     3,     0,   -64,   -10,   -18,   -21,    -1,     8,   -24, &
                  -21,    -1,     8,   -24,   -21,    71,   -64,   192,   192,   -64,    71,   -21,   -24,     8,    -1,   -21, &
                  -24,     8,    62,     6,     3,    -1,   -10,     6,     3,    -1,     8,   168,    30,   -10,    80,   -48]
  K1(  98,:) = [   512,     0,   171,    -1,     8,   168,     3,    -1,   -64,     0,   -18,   -10,    -1,   -21,   -24,     8, &
                   -1,   -21,   -24,     8,    71,   -21,   192,   -64,   -64,   192,   -21,    71,     8,   -24,   -21,    -1, &
                    8,   -24,     6,    62,    -1,     3,     6,   -10,    -1,     3,   168,     8,   -10,    30,   -48,    80]
  K1(  99,:) = [    -1,   171,     0,   512,    -1,     3,   168,     8,   -10,   -18,     0,   -64,     8,   -24,   -21,    -1, &
                    8,   -24,   -21,    -1,   -64,   192,   -21,    71,    71,   -21,   192,   -64,    -1,   -21,   -24,     8, &
                   62,     6,   -24,     8,   -10,     6,     3,    -1,     8,   168,     3,    -1,    80,   -48,    30,   -10]
  K1( 100,:) = [   171,    -1,   512,     0,     3,    -1,     8,   168,   -18,   -10,   -64,     0,   -24,     8,    -1,   -21, &
                  -24,     8,    -1,   -21,   192,   -64,    71,   -21,   -21,    71,   -64,   192,   -21,    -1,     8,   -24, &
                    6,    62,     8,   -24,     6,   -10,    -1,     3,   168,     8,    -1,     3,   -48,    80,   -10,    30]
  K1( 101,:) = [   168,     8,    -1,     3,     0,   512,    -1,   171,   -21,    -1,     8,   -24,   -21,    71,   -64,   192, &
                    0,   -64,   -10,   -18,   -21,    -1,     8,   -24,   -24,     8,    -1,   -21,   192,   -64,    71,   -21, &
                    3,    -1,     8,   168,    30,   -10,    80,   -48,   -24,     8,    62,     6,     3,    -1,   -10,     6]
  K1( 102,:) = [     8,   168,     3,    -1,   512,     0,   171,    -1,    -1,   -21,   -24,     8,    71,   -21,   192,   -64, &
                  -64,     0,   -18,   -10,    -1,   -21,   -24,     8,     8,   -24,   -21,    -1,   -64,   192,   -21,    71, &
                   -1,     3,   168,     8,   -10,    30,   -48,    80,     8,   -24,     6,    62,    -1,     3,     6,   -10]
  K1( 103,:) = [    -1,     3,   168,     8,    -1,   171,     0,   512,     8,   -24,   -21,    -1,   -64,   192,   -21,    71, &
                  -10,   -18,     0,   -64,     8,   -24,   -21,    -1,    -1,   -21,   -24,     8,    71,   -21,   192,   -64, &
                    8,   168,     3,    -1,    80,   -48,    30,   -10,    62,     6,   -24,     8,   -10,     6,     3,    -1]
  K1( 104,:) = [     3,    -1,     8,   168,   171,    -1,   512,     0,   -24,     8,    -1,   -21,   192,   -64,    71,   -21, &
                  -18,   -10,   -64,     0,   -24,     8,    -1,   -21,   -21,    -1,     8,   -24,   -21,    71,   -64,   192, &
                  168,     8,    -1,     3,   -48,    80,   -10,    30,     6,    62,     8,   -24,     6,   -10,    -1,     3]
  K1( 105,:) = [     0,   -64,   -10,   -18,   -21,    -1,     8,   -24,     0,   512,    -1,   171,   168,     8,    -1,     3, &
                  -21,    71,   -64,   192,   -21,    -1,     8,   -24,   -24,     8,    62,     6,     3,    -1,   -10,     6, &
                  192,   -64,    71,   -21,   -24,     8,    -1,   -21,    30,   -10,    80,   -48,     3,    -1,     8,   168]
  K1( 106,:) = [   -64,     0,   -18,   -10,    -1,   -21,   -24,     8,   512,     0,   171,    -1,     8,   168,     3,    -1, &
                   71,   -21,   192,   -64,    -1,   -21,   -24,     8,     8,   -24,     6,    62,    -1,     3,     6,   -10, &
                  -64,   192,   -21,    71,     8,   -24,   -21,    -1,   -10,    30,   -48,    80,    -1,     3,   168,     8]
  K1( 107,:) = [   -10,   -18,     0,   -64,     8,   -24,   -21,    -1,    -1,   171,     0,   512,    -1,     3,   168,     8, &
                  -64,   192,   -21,    71,     8,   -24,   -21,    -1,    62,     6,   -24,     8,   -10,     6,     3,    -1, &
                   71,   -21,   192,   -64,    -1,   -21,   -24,     8,    80,   -48,    30,   -10,     8,   168,     3,    -1]
  K1( 108,:) = [   -18,   -10,   -64,     0,   -24,     8,    -1,   -21,   171,    -1,   512,     0,     3,    -1,     8,   168, &
                  192,   -64,    71,   -21,   -24,     8,    -1,   -21,     6,    62,     8,   -24,     6,   -10,    -1,     3, &
                  -21,    71,   -64,   192,   -21,    -1,     8,   -24,   -48,    80,   -10,    30,   168,     8,    -1,     3]
  K1( 109,:) = [   -21,    -1,     8,   -24,   -21,    71,   -64,   192,   168,     8,    -1,     3,     0,   512,    -1,   171, &
                  -21,    -1,     8,   -24,     0,   -64,   -10,   -18,     3,    -1,     8,   168,    30,   -10,    80,   -48, &
                  -24,     8,    -1,   -21,   192,   -64,    71,   -21,     3,    -1,   -10,     6,   -24,     8,    62,     6]
  K1( 110,:) = [    -1,   -21,   -24,     8,    71,   -21,   192,   -64,     8,   168,     3,    -1,   512,     0,   171,    -1, &
                   -1,   -21,   -24,     8,   -64,     0,   -18,   -10,    -1,     3,   168,     8,   -10,    30,   -48,    80, &
                    8,   -24,   -21,    -1,   -64,   192,   -21,    71,    -1,     3,     6,   -10,     8,   -24,     6,    62]
  K1( 111,:) = [     8,   -24,   -21,    -1,   -64,   192,   -21,    71,    -1,     3,   168,     8,    -1,   171,     0,   512, &
                    8,   -24,   -21,    -1,   -10,   -18,     0,   -64,     8,   168,     3,    -1,    80,   -48,    30,   -10, &
                   -1,   -21,   -24,     8,    71,   -21,   192,   -64,   -10,     6,     3,    -1,    62,     6,   -24,     8]
  K1( 112,:) = [   -24,     8,    -1,   -21,   192,   -64,    71,   -21,     3,    -1,     8,   168,   171,    -1,   512,     0, &
                  -24,     8,    -1,   -21,   -18,   -10,   -64,     0,   168,     8,    -1,     3,   -48,    80,   -10,    30, &
                  -21,    -1,     8,   -24,   -21,    71,   -64,   192,     6,   -10,    -1,     3,     6,    62,     8,   -24]
  K1( 113,:) = [   -21,    -1,     8,   -24,     0,   -64,   -10,   -18,   -21,    71,   -64,   192,   -21,    -1,     8,   -24, &
                    0,   512,    -1,   171,   168,     8,    -1,     3,     3,    -1,   -10,     6,   -24,     8,    62,     6, &
                   30,   -10,    80,   -48,     3,    -1,     8,   168,   192,   -64,    71,   -21,   -24,     8,    -1,   -21]
  K1( 114,:) = [    -1,   -21,   -24,     8,   -64,     0,   -18,   -10,    71,   -21,   192,   -64,    -1,   -21,   -24,     8, &
                  512,     0,   171,    -1,     8,   168,     3,    -1,    -1,     3,     6,   -10,     8,   -24,     6,    62, &
                  -10,    30,   -48,    80,    -1,     3,   168,     8,   -64,   192,   -21,    71,     8,   -24,   -21,    -1]
  K1( 115,:) = [     8,   -24,   -21,    -1,   -10,   -18,     0,   -64,   -64,   192,   -21,    71,     8,   -24,   -21,    -1, &
                   -1,   171,     0,   512,    -1,     3,   168,     8,   -10,     6,     3,    -1,    62,     6,   -24,     8, &
                   80,   -48,    30,   -10,     8,   168,     3,    -1,    71,   -21,   192,   -64,    -1,   -21,   -24,     8]
  K1( 116,:) = [   -24,     8,    -1,   -21,   -18,   -10,   -64,     0,   192,   -64,    71,   -21,   -24,     8,    -1,   -21, &
                  171,    -1,   512,     0,     3,    -1,     8,   168,     6,   -10,    -1,     3,     6,    62,     8,   -24, &
                  -48,    80,   -10,    30,   168,     8,    -1,     3,   -21,    71,   -64,   192,   -21,    -1,     8,   -24]
  K1( 117,:) = [   -21,    71,   -64,   192,   -21,    -1,     8,   -24,   -21,    -1,     8,   -24,     0,   -64,   -10,   -18, &
                  168,     8,    -1,     3,     0,   512,    -1,   171,    30,   -10,    80,   -48,     3,    -1,     8,   168, &
                    3,    -1,   -10,     6,   -24,     8,    62,     6,   -24,     8,    -1,   -21,   192,   -64,    71,   -21]
  K1( 118,:) = [    71,   -21,   192,   -64,    -1,   -21,   -24,     8,    -1,   -21,   -24,     8,   -64,     0,   -18,   -10, &
                    8,   168,     3,    -1,   512,     0,   171,    -1,   -10,    30,   -48,    80,    -1,     3,   168,     8, &
                   -1,     3,     6,   -10,     8,   -24,     6,    62,     8,   -24,   -21,    -1,   -64,   192,   -21,    71]
  K1( 119,:) = [   -64,   192,   -21,    71,     8,   -24,   -21,    -1,     8,   -24,   -21,    -1,   -10,   -18,     0,   -64, &
                   -1,     3,   168,     8,    -1,   171,     0,   512,    80,   -48,    30,   -10,     8,   168,     3,    -1, &
                  -10,     6,     3,    -1,    62,     6,   -24,     8,    -1,   -21,   -24,     8,    71,   -21,   192,   -64]
  K1( 120,:) = [   192,   -64,    71,   -21,   -24,     8,    -1,   -21,   -24,     8,    -1,   -21,   -18,   -10,   -64,     0, &
                    3,    -1,     8,   168,   171,    -1,   512,     0,   -48,    80,   -10,    30,   168,     8,    -1,     3, &
                    6,   -10,    -1,     3,     6,    62,     8,   -24,   -21,    -1,     8,   -24,   -21,    71,   -64,   192]
  K1( 121,:) = [   192,   -64,    71,   -21,   -24,     8,    -1,   -21,   -24,     8,    62,     6,     3,    -1,     8,   168, &
                    3,    -1,   -10,     6,    30,   -10,    80,   -48,     0,   512,    -1,   171,     0,   -64,   -10,   -18, &
                    0,   -64,   -10,   -18,     0,     8,    62,   -18,     0,     8,    62,   -18,     0,    80,   -28,    36]
  K1( 122,:) = [   -64,   192,   -21,    71,     8,   -24,   -21,    -1,     8,   -24,     6,    62,    -1,     3,   168,     8, &
                   -1,     3,     6,   -10,   -10,    30,   -48,    80,   512,     0,   171,    -1,   -64,     0,   -18,   -10, &
                  -64,     0,   -18,   -10,     8,     0,   -18,    62,     8,     0,   -18,    62,    80,     0,    36,   -28]
  K1( 123,:) = [    71,   -21,   192,   -64,    -1,   -21,   -24,     8,    62,     6,   -24,     8,     8,   168,     3,    -1, &
                  -10,     6,     3,    -1,    80,   -48,    30,   -10,    -1,   171,     0,   512,   -10,   -18,     0,   -64, &
                  -10,   -18,     0,   -64,    62,   -18,     0,     8,    62,   -18,     0,     8,   -28,    36,     0,    80]
  K1( 124,:) = [   -21,    71,   -64,   192,   -21,    -1,     8,   -24,     6,    62,     8,   -24,   168,     8,    -1,     3, &
                    6,   -10,    -1,     3,   -48,    80,   -10,    30,   171,    -1,   512,     0,   -18,   -10,   -64,     0, &
                  -18,   -10,   -64,     0,   -18,    62,     8,     0,   -18,    62,     8,     0,    36,   -28,    80,     0]
  K1( 125,:) = [   -24,     8,    -1,   -21,   192,   -64,    71,   -21,     3,    -1,   -10,     6,    30,   -10,    80,   -48, &
                  -24,     8,    62,     6,     3,    -1,     8,   168,     0,   -64,   -10,   -18,     0,   512,    -1,   171, &
                    0,     8,    62,   -18,     0,    80,   -28,    36,     0,   -64,   -10,   -18,     0,     8,    62,   -18]
  K1( 126,:) = [     8,   -24,   -21,    -1,   -64,   192,   -21,    71,    -1,     3,     6,   -10,   -10,    30,   -48,    80, &
                    8,   -24,     6,    62,    -1,     3,   168,     8,   -64,     0,   -18,   -10,   512,     0,   171,    -1, &
                    8,     0,   -18,    62,    80,     0,    36,   -28,   -64,     0,   -18,   -10,     8,     0,   -18,    62]
  K1( 127,:) = [    -1,   -21,   -24,     8,    71,   -21,   192,   -64,   -10,     6,     3,    -1,    80,   -48,    30,   -10, &
                   62,     6,   -24,     8,     8,   168,     3,    -1,   -10,   -18,     0,   -64,    -1,   171,     0,   512, &
                   62,   -18,     0,     8,   -28,    36,     0,    80,   -10,   -18,     0,   -64,    62,   -18,     0,     8]
  K1( 128,:) = [   -21,    -1,     8,   -24,   -21,    71,   -64,   192,     6,   -10,    -1,     3,   -48,    80,   -10,    30, &
                    6,    62,     8,   -24,   168,     8,    -1,     3,   -18,   -10,   -64,     0,   171,    -1,   512,     0, &
                  -18,    62,     8,     0,    36,   -28,    80,     0,   -18,   -10,   -64,     0,   -18,    62,     8,     0]
  K1( 129,:) = [   -24,     8,    62,     6,     3,    -1,     8,   168,   192,   -64,    71,   -21,   -24,     8,    -1,   -21, &
                   30,   -10,    80,   -48,     3,    -1,   -10,     6,     0,   -64,   -10,   -18,     0,     8,    62,   -18, &
                    0,   512,    -1,   171,     0,   -64,   -10,   -18,     0,    80,   -28,    36,     0,     8,    62,   -18]
  K1( 130,:) = [     8,   -24,     6,    62,    -1,     3,   168,     8,   -64,   192,   -21,    71,     8,   -24,   -21,    -1, &
                  -10,    30,   -48,    80,    -1,     3,     6,   -10,   -64,     0,   -18,   -10,     8,     0,   -18,    62, &
                  512,     0,   171,    -1,   -64,     0,   -18,   -10,    80,     0,    36,   -28,     8,     0,   -18,    62]
  K1( 131,:) = [    62,     6,   -24,     8,     8,   168,     3,    -1,    71,   -21,   192,   -64,    -1,   -21,   -24,     8, &
                   80,   -48,    30,   -10,   -10,     6,     3,    -1,   -10,   -18,     0,   -64,    62,   -18,     0,     8, &
                   -1,   171,     0,   512,   -10,   -18,     0,   -64,   -28,    36,     0,    80,    62,   -18,     0,     8]
  K1( 132,:) = [     6,    62,     8,   -24,   168,     8,    -1,     3,   -21,    71,   -64,   192,   -21,    -1,     8,   -24, &
                  -48,    80,   -10,    30,     6,   -10,    -1,     3,   -18,   -10,   -64,     0,   -18,    62,     8,     0, &
                  171,    -1,   512,     0,   -18,   -10,   -64,     0,    36,   -28,    80,     0,   -18,    62,     8,     0]
  K1( 133,:) = [     3,    -1,   -10,     6,    30,   -10,    80,   -48,   -24,     8,    -1,   -21,   192,   -64,    71,   -21, &
                    3,    -1,     8,   168,   -24,     8,    62,     6,     0,     8,    62,   -18,     0,    80,   -28,    36, &
                    0,   -64,   -10,   -18,     0,   512,    -1,   171,     0,     8,    62,   -18,     0,   -64,   -10,   -18]
  K1( 134,:) = [    -1,     3,     6,   -10,   -10,    30,   -48,    80,     8,   -24,   -21,    -1,   -64,   192,   -21,    71, &
                   -1,     3,   168,     8,     8,   -24,     6,    62,     8,     0,   -18,    62,    80,     0,    36,   -28, &
                  -64,     0,   -18,   -10,   512,     0,   171,    -1,     8,     0,   -18,    62,   -64,     0,   -18,   -10]
  K1( 135,:) = [   -10,     6,     3,    -1,    80,   -48,    30,   -10,    -1,   -21,   -24,     8,    71,   -21,   192,   -64, &
                    8,   168,     3,    -1,    62,     6,   -24,     8,    62,   -18,     0,     8,   -28,    36,     0,    80, &
                  -10,   -18,     0,   -64,    -1,   171,     0,   512,    62,   -18,     0,     8,   -10,   -18,     0,   -64]
  K1( 136,:) = [     6,   -10,    -1,     3,   -48,    80,   -10,    30,   -21,    -1,     8,   -24,   -21,    71,   -64,   192, &
                  168,     8,    -1,     3,     6,    62,     8,   -24,   -18,    62,     8,     0,    36,   -28,    80,     0, &
                  -18,   -10,   -64,     0,   171,    -1,   512,     0,   -18,    62,     8,     0,   -18,   -10,   -64,     0]
  K1( 137,:) = [     3,    -1,     8,   168,   -24,     8,    62,     6,    30,   -10,    80,   -48,     3,    -1,   -10,     6, &
                  192,   -64,    71,   -21,   -24,     8,    -1,   -21,     0,     8,    62,   -18,     0,   -64,   -10,   -18, &
                    0,    80,   -28,    36,     0,     8,    62,   -18,     0,   512,    -1,   171,     0,   -64,   -10,   -18]
  K1( 138,:) = [    -1,     3,   168,     8,     8,   -24,     6,    62,   -10,    30,   -48,    80,    -1,     3,     6,   -10, &
                  -64,   192,   -21,    71,     8,   -24,   -21,    -1,     8,     0,   -18,    62,   -64,     0,   -18,   -10, &
                   80,     0,    36,   -28,     8,     0,   -18,    62,   512,     0,   171,    -1,   -64,     0,   -18,   -10]
  K1( 139,:) = [     8,   168,     3,    -1,    62,     6,   -24,     8,    80,   -48,    30,   -10,   -10,     6,     3,    -1, &
                   71,   -21,   192,   -64,    -1,   -21,   -24,     8,    62,   -18,     0,     8,   -10,   -18,     0,   -64, &
                  -28,    36,     0,    80,    62,   -18,     0,     8,    -1,   171,     0,   512,   -10,   -18,     0,   -64]
  K1( 140,:) = [   168,     8,    -1,     3,     6,    62,     8,   -24,   -48,    80,   -10,    30,     6,   -10,    -1,     3, &
                  -21,    71,   -64,   192,   -21,    -1,     8,   -24,   -18,    62,     8,     0,   -18,   -10,   -64,     0, &
                   36,   -28,    80,     0,   -18,    62,     8,     0,   171,    -1,   512,     0,   -18,   -10,   -64,     0]
  K1( 141,:) = [    30,   -10,    80,   -48,     3,    -1,   -10,     6,     3,    -1,     8,   168,   -24,     8,    62,     6, &
                  -24,     8,    -1,   -21,   192,   -64,    71,   -21,     0,    80,   -28,    36,     0,     8,    62,   -18, &
                    0,     8,    62,   -18,     0,   -64,   -10,   -18,     0,   -64,   -10,   -18,     0,   512,    -1,   171]
  K1( 142,:) = [   -10,    30,   -48,    80,    -1,     3,     6,   -10,    -1,     3,   168,     8,     8,   -24,     6,    62, &
                    8,   -24,   -21,    -1,   -64,   192,   -21,    71,    80,     0,    36,   -28,     8,     0,   -18,    62, &
                    8,     0,   -18,    62,   -64,     0,   -18,   -10,   -64,     0,   -18,   -10,   512,     0,   171,    -1]
  K1( 143,:) = [    80,   -48,    30,   -10,   -10,     6,     3,    -1,     8,   168,     3,    -1,    62,     6,   -24,     8, &
                   -1,   -21,   -24,     8,    71,   -21,   192,   -64,   -28,    36,     0,    80,    62,   -18,     0,     8, &
                   62,   -18,     0,     8,   -10,   -18,     0,   -64,   -10,   -18,     0,   -64,    -1,   171,     0,   512]
  K1( 144,:) = [   -48,    80,   -10,    30,     6,   -10,    -1,     3,   168,     8,    -1,     3,     6,    62,     8,   -24, &
                  -21,    -1,     8,   -24,   -21,    71,   -64,   192,    36,   -28,    80,     0,   -18,    62,     8,     0, &
                  -18,    62,     8,     0,   -18,   -10,   -64,     0,   -18,   -10,   -64,     0,   171,    -1,   512,     0]
  K1( 145,:) = [  1536,   512,   512,   168,   192,   512,     8,     0,  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,   -64,    80,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,    80,   -64,   192]
  K1( 146,:) = [   512,  1536,   168,   512,   512,   192,     0,     8,   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  -64,     0,   192,    80,     8,     0,   -24,     8,     8,     0,   192,   512,    80,     0,   192,   -64]
  K1( 147,:) = [   512,   168,  1536,   512,     8,     0,   192,   512,   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                   80,   192,     0,   -64,     8,   -24,     0,     8,   512,   192,     0,     8,   -64,   192,     0,    80]
  K1( 148,:) = [   168,   512,   512,  1536,     0,     8,   512,   192,   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,    80,   -64,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,   -64,    80,     0]
  K1( 149,:) = [   192,   512,     8,     0,  1536,   512,   512,   168,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                 -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,    80,   -64,   192,     0,   -64,    80,   192,     0,     8,     8,   -24]
  K1( 150,:) = [   512,   192,     0,     8,   512,  1536,   168,   512,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,    80,     0,   192,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8]
  K1( 151,:) = [     8,     0,   192,   512,   512,   168,  1536,   512,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                  -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,   -64,   192,     0,    80,    80,   192,     0,   -64,     8,   -24,     0,     8]
  K1( 152,:) = [     0,     8,   512,   192,   168,   512,   512,  1536,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                  -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,   -64,    80,     0,   192,    80,   -64,     0,   -24,     8,     8,     0]
  K1( 153,:) = [  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,  1536,   512,   512,   168,   192,   512,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,     0,   -64,    80,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,     0,    80,   -64,   192,     0,     8,   512,   192]
  K1( 154,:) = [   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   512,  1536,   168,   512,   512,   192,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,     0,   192,   -64,     8,     0,   192,   512]
  K1( 155,:) = [   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   512,   168,  1536,   512,     8,     0,   192,   512, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,   192,     0,   -64,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   192,     0,    80,   512,   192,     0,     8]
  K1( 156,:) = [   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   168,   512,   512,  1536,     0,     8,   512,   192, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,   192,    80,   -64,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   192,   -64,    80,     0,   192,   512,     8,     0]
  K1( 157,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   192,   512,     8,     0,  1536,   512,   512,   168, &
                  -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,     0,     8,   512,   192,     0,    80,   -64,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,   -64,    80,   192]
  K1( 158,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,   512,   192,     0,     8,   512,  1536,   168,   512, &
                  -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,     0,   192,   512,    80,     0,   192,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,   -64,     0,   192,    80]
  K1( 159,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   192,   512,   512,   168,  1536,   512, &
                  -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,   192,     0,     8,   -64,   192,     0,    80, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,    80,   192,     0,   -64]
  K1( 160,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,   512,   192,   168,   512,   512,  1536, &
                    0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,   192,   512,     8,     0,   192,   -64,    80,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,    80,   -64,     0]
  K1( 161,:) = [   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                 1536,   512,   512,   168,   192,   512,     8,     0,     0,     8,     8,   -24,     0,   -64,    80,   192, &
                    0,    80,   -64,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24]
  K1( 162,:) = [   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  512,  1536,   168,   512,   512,   192,     0,     8,     8,     0,   -24,     8,   -64,     0,   192,    80, &
                   80,     0,   192,   -64,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64]
  K1( 163,:) = [   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  512,   168,  1536,   512,     8,     0,   192,   512,     8,   -24,     0,     8,    80,   192,     0,   -64, &
                  -64,   192,     0,    80,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64]
  K1( 164,:) = [     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                  168,   512,   512,  1536,     0,     8,   512,   192,   -24,     8,     8,     0,   192,    80,   -64,     0, &
                  192,   -64,    80,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0]
  K1( 165,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48, &
                  192,   512,     8,     0,  1536,   512,   512,   168,     0,    80,   -64,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,   -64,    80,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192]
  K1( 166,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64, &
                  512,   192,     0,     8,   512,  1536,   168,   512,    80,     0,   192,   -64,     8,     0,   192,   512, &
                    8,     0,   -24,     8,   -64,     0,   192,    80,   -64,     0,   -24,   -64,   512,     0,   192,     8]
  K1( 167,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64, &
                    8,     0,   192,   512,   512,   168,  1536,   512,   -64,   192,     0,    80,   512,   192,     0,     8, &
                    8,   -24,     0,     8,    80,   192,     0,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512]
  K1( 168,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192, &
                    0,     8,   512,   192,   168,   512,   512,  1536,   192,   -64,    80,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,    80,   -64,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0]
  K1( 169,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,    80,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,    80,   -64,   192,  1536,   512,   512,   168,  -192,   -64,   -64,   -48, &
                 -192,   -64,   -64,   -48,    24,     8,     8,   168,    24,     8,     8,   168,   240,    80,    80,   -48]
  K1( 170,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   192,    80,     8,     0,   192,   512, &
                    8,     0,   -24,     8,    80,     0,   192,   -64,   512,  1536,   168,   512,   -64,  -192,   -48,   -64, &
                  -64,  -192,   -48,   -64,     8,    24,   168,     8,     8,    24,   168,     8,    80,   240,   -48,    80]
  K1( 171,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,    80,   192,     0,   -64,   512,   192,     0,     8, &
                    8,   -24,     0,     8,   -64,   192,     0,    80,   512,   168,  1536,   512,   -64,   -48,  -192,   -64, &
                  -64,   -48,  -192,   -64,     8,   168,    24,     8,     8,   168,    24,     8,    80,   -48,   240,    80]
  K1( 172,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   192,    80,   -64,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,   -64,    80,     0,   168,   512,   512,  1536,   -48,   -64,   -64,  -192, &
                  -48,   -64,   -64,  -192,   168,     8,     8,    24,   168,     8,     8,    24,   -48,    80,    80,   240]
  K1( 173,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,    80,   -64,   192, &
                    0,   -64,    80,   192,     0,     8,   512,   192,  -192,   -64,   -64,   -48,  1536,   512,   512,   168, &
                   24,     8,     8,   168,   240,    80,    80,   -48,  -192,   -64,   -64,   -48,    24,     8,     8,   168]
  K1( 174,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,    80,     0,   192,   -64, &
                  -64,     0,   192,    80,     8,     0,   192,   512,   -64,  -192,   -48,   -64,   512,  1536,   168,   512, &
                    8,    24,   168,     8,    80,   240,   -48,    80,   -64,  -192,   -48,   -64,     8,    24,   168,     8]
  K1( 175,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,   -64,   192,     0,    80, &
                   80,   192,     0,   -64,   512,   192,     0,     8,   -64,   -48,  -192,   -64,   512,   168,  1536,   512, &
                    8,   168,    24,     8,    80,   -48,   240,    80,   -64,   -48,  -192,   -64,     8,   168,    24,     8]
  K1( 176,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,   -64,    80,     0, &
                  192,    80,   -64,     0,   192,   512,     8,     0,   -48,   -64,   -64,  -192,   168,   512,   512,  1536, &
                  168,     8,     8,    24,   -48,    80,    80,   240,   -48,   -64,   -64,  -192,   168,     8,     8,    24]
  K1( 177,:) = [     0,   -64,    80,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,    80,   -64,   192,     0,     8,     8,   -24,  -192,   -64,   -64,   -48,    24,     8,     8,   168, &
                 1536,   512,   512,   168,  -192,   -64,   -64,   -48,   240,    80,    80,   -48,    24,     8,     8,   168]
  K1( 178,:) = [   -64,     0,   192,    80,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                   80,     0,   192,   -64,     8,     0,   -24,     8,   -64,  -192,   -48,   -64,     8,    24,   168,     8, &
                  512,  1536,   168,   512,   -64,  -192,   -48,   -64,    80,   240,   -48,    80,     8,    24,   168,     8]
  K1( 179,:) = [    80,   192,     0,   -64,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  -64,   192,     0,    80,     8,   -24,     0,     8,   -64,   -48,  -192,   -64,     8,   168,    24,     8, &
                  512,   168,  1536,   512,   -64,   -48,  -192,   -64,    80,   -48,   240,    80,     8,   168,    24,     8]
  K1( 180,:) = [   192,    80,   -64,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,   -64,    80,     0,   -24,     8,     8,     0,   -48,   -64,   -64,  -192,   168,     8,     8,    24, &
                  168,   512,   512,  1536,   -48,   -64,   -64,  -192,   -48,    80,    80,   240,   168,     8,     8,    24]
  K1( 181,:) = [     0,     8,     8,   -24,     0,    80,   -64,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,   -64,    80,   192,    24,     8,     8,   168,   240,    80,    80,   -48, &
                 -192,   -64,   -64,   -48,  1536,   512,   512,   168,    24,     8,     8,   168,  -192,   -64,   -64,   -48]
  K1( 182,:) = [     8,     0,   -24,     8,    80,     0,   192,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,   -64,     0,   192,    80,     8,    24,   168,     8,    80,   240,   -48,    80, &
                  -64,  -192,   -48,   -64,   512,  1536,   168,   512,     8,    24,   168,     8,   -64,  -192,   -48,   -64]
  K1( 183,:) = [     8,   -24,     0,     8,   -64,   192,     0,    80,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,    80,   192,     0,   -64,     8,   168,    24,     8,    80,   -48,   240,    80, &
                  -64,   -48,  -192,   -64,   512,   168,  1536,   512,     8,   168,    24,     8,   -64,   -48,  -192,   -64]
  K1( 184,:) = [   -24,     8,     8,     0,   192,   -64,    80,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,    80,   -64,     0,   168,     8,     8,    24,   -48,    80,    80,   240, &
                  -48,   -64,   -64,  -192,   168,   512,   512,  1536,   168,     8,     8,    24,   -48,   -64,   -64,  -192]
  K1( 185,:) = [     0,     8,   512,   192,     0,   -64,    80,   192,     0,    80,   -64,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,    24,     8,     8,   168,  -192,   -64,   -64,   -48, &
                  240,    80,    80,   -48,    24,     8,     8,   168,  1536,   512,   512,   168,  -192,   -64,   -64,   -48]
  K1( 186,:) = [     8,     0,   192,   512,   -64,     0,   192,    80,    80,     0,   192,   -64,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,     8,    24,   168,     8,   -64,  -192,   -48,   -64, &
                   80,   240,   -48,    80,     8,    24,   168,     8,   512,  1536,   168,   512,   -64,  -192,   -48,   -64]
  K1( 187,:) = [   512,   192,     0,     8,    80,   192,     0,   -64,   -64,   192,     0,    80,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,     8,   168,    24,     8,   -64,   -48,  -192,   -64, &
                   80,   -48,   240,    80,     8,   168,    24,     8,   512,   168,  1536,   512,   -64,   -48,  -192,   -64]
  K1( 188,:) = [   192,   512,     8,     0,   192,    80,   -64,     0,   192,   -64,    80,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   168,     8,     8,    24,   -48,   -64,   -64,  -192, &
                  -48,    80,    80,   240,   168,     8,     8,    24,   168,   512,   512,  1536,   -48,   -64,   -64,  -192]
  K1( 189,:) = [     0,    80,   -64,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,   -64,    80,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   240,    80,    80,   -48,    24,     8,     8,   168, &
                   24,     8,     8,   168,  -192,   -64,   -64,   -48,  -192,   -64,   -64,   -48,  1536,   512,   512,   168]
  K1( 190,:) = [    80,     0,   192,   -64,     8,     0,   -24,     8,     8,     0,   192,   512,   -64,     0,   192,    80, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,    80,   240,   -48,    80,     8,    24,   168,     8, &
                    8,    24,   168,     8,   -64,  -192,   -48,   -64,   -64,  -192,   -48,   -64,   512,  1536,   168,   512]
  K1( 191,:) = [   -64,   192,     0,    80,     8,   -24,     0,     8,   512,   192,     0,     8,    80,   192,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,    80,   -48,   240,    80,     8,   168,    24,     8, &
                    8,   168,    24,     8,   -64,   -48,  -192,   -64,   -64,   -48,  -192,   -64,   512,   168,  1536,   512]
  K1( 192,:) = [   192,   -64,    80,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,    80,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -48,    80,    80,   240,   168,     8,     8,    24, &
                  168,     8,     8,    24,   -48,   -64,   -64,  -192,   -48,   -64,   -64,  -192,   168,   512,   512,  1536]
  K1( 193,:) = [   -24,    -8,    -8,    21,    -3,    -8,    10,     0,  -240,   -80,   -80,    -6,   -30,   -80,     1,     0, &
                  -30,     1,   -80,     0,    -3,    10,    -8,     0,     0,    -8,   -71,  -192,     0,     1,     1,    24, &
                    0,   -80,   -62,  -192,     0,    10,    10,    24,     0,   -71,    -8,  -192,     0,   -62,   -80,  -192]
  K1( 194,:) = [    -8,     0,    18,    64,    -8,    -6,    24,     1,   -80,     0,   -36,    -8,     1,    -6,    -3,    -8, &
                  -80,    -6,  -192,    -8,    10,    48,    24,    64,     1,    -3,    21,    -8,    10,    24,    21,    64, &
                   10,   -30,    -6,   -80,   -62,    -3,    -6,    -8,   -62,  -192,  -168,  -512,    28,    24,    48,    64]
  K1( 195,:) = [    -8,    18,     0,    64,    10,    24,    48,    64,   -80,   -36,     0,    -8,   -80,  -192,    -6,    -8, &
                    1,    -3,    -6,    -8,    -8,    24,    -6,     1,   -62,  -168,  -192,  -512,    10,    21,    24,    64, &
                   28,    48,    24,    64,   -62,    -6,    -3,    -8,     1,    21,    -3,    -8,    10,    -6,   -30,   -80]
  K1( 196,:) = [    21,    64,    64,   192,     0,     1,    64,    24,    -6,    -8,    -8,   -24,     0,    -8,    -8,    -3, &
                    0,    -8,    -8,    -3,     0,    64,     1,    24,    24,     1,    64,     0,    -3,    -8,    -8,     0, &
                   24,    10,    -8,     0,    -3,     1,     1,     0,    24,    64,     1,     0,    24,    -8,    10,     0]
  K1( 197,:) = [    -3,    -8,    10,     0,   -24,    -8,    -8,    21,   -30,     1,   -80,     0,    -3,    10,    -8,     0, &
                 -240,   -80,   -80,    -6,   -30,   -80,     1,     0,     0,     1,     1,    24,     0,    -8,   -71,  -192, &
                    0,   -71,    -8,  -192,     0,   -62,   -80,  -192,     0,   -80,   -62,  -192,     0,    10,    10,    24]
  K1( 198,:) = [    -8,    -6,    24,     1,    -8,     0,    18,    64,   -80,    -6,  -192,    -8,    10,    48,    24,    64, &
                  -80,     0,   -36,    -8,     1,    -6,    -3,    -8,    10,    24,    21,    64,     1,    -3,    21,    -8, &
                  -62,  -192,  -168,  -512,    28,    24,    48,    64,    10,   -30,    -6,   -80,   -62,    -3,    -6,    -8]
  K1( 199,:) = [    10,    24,    48,    64,    -8,    18,     0,    64,     1,    -3,    -6,    -8,    -8,    24,    -6,     1, &
                  -80,   -36,     0,    -8,   -80,  -192,    -6,    -8,    10,    21,    24,    64,   -62,  -168,  -192,  -512, &
                    1,    21,    -3,    -8,    10,    -6,   -30,   -80,    28,    48,    24,    64,   -62,    -6,    -3,    -8]
  K1( 200,:) = [     0,     1,    64,    24,    21,    64,    64,   192,     0,    -8,    -8,    -3,     0,    64,     1,    24, &
                   -6,    -8,    -8,   -24,     0,    -8,    -8,    -3,    -3,    -8,    -8,     0,    24,     1,    64,     0, &
                   24,    64,     1,     0,    24,    -8,    10,     0,    24,    10,    -8,     0,    -3,     1,     1,     0]
  K1( 201,:) = [  -240,   -80,   -80,    -6,   -30,   -80,     1,     0,   -24,    -8,    -8,    21,    -3,    -8,    10,     0, &
                   -3,    10,    -8,     0,   -30,     1,   -80,     0,     0,   -80,   -62,  -192,     0,    10,    10,    24, &
                    0,    -8,   -71,  -192,     0,     1,     1,    24,     0,   -62,   -80,  -192,     0,   -71,    -8,  -192]
  K1( 202,:) = [   -80,     0,   -36,    -8,     1,    -6,    -3,    -8,    -8,     0,    18,    64,    -8,    -6,    24,     1, &
                   10,    48,    24,    64,   -80,    -6,  -192,    -8,    10,   -30,    -6,   -80,   -62,    -3,    -6,    -8, &
                    1,    -3,    21,    -8,    10,    24,    21,    64,    28,    24,    48,    64,   -62,  -192,  -168,  -512]
  K1( 203,:) = [   -80,   -36,     0,    -8,   -80,  -192,    -6,    -8,    -8,    18,     0,    64,    10,    24,    48,    64, &
                   -8,    24,    -6,     1,     1,    -3,    -6,    -8,    28,    48,    24,    64,   -62,    -6,    -3,    -8, &
                  -62,  -168,  -192,  -512,    10,    21,    24,    64,    10,    -6,   -30,   -80,     1,    21,    -3,    -8]
  K1( 204,:) = [    -6,    -8,    -8,   -24,     0,    -8,    -8,    -3,    21,    64,    64,   192,     0,     1,    64,    24, &
                    0,    64,     1,    24,     0,    -8,    -8,    -3,    24,    10,    -8,     0,    -3,     1,     1,     0, &
                   24,     1,    64,     0,    -3,    -8,    -8,     0,    24,    -8,    10,     0,    24,    64,     1,     0]
  K1( 205,:) = [   -30,     1,   -80,     0,    -3,    10,    -8,     0,    -3,    -8,    10,     0,   -24,    -8,    -8,    21, &
                  -30,   -80,     1,     0,  -240,   -80,   -80,    -6,     0,   -71,    -8,  -192,     0,   -62,   -80,  -192, &
                    0,     1,     1,    24,     0,    -8,   -71,  -192,     0,    10,    10,    24,     0,   -80,   -62,  -192]
  K1( 206,:) = [   -80,    -6,  -192,    -8,    10,    48,    24,    64,    -8,    -6,    24,     1,    -8,     0,    18,    64, &
                    1,    -6,    -3,    -8,   -80,     0,   -36,    -8,   -62,  -192,  -168,  -512,    28,    24,    48,    64, &
                   10,    24,    21,    64,     1,    -3,    21,    -8,   -62,    -3,    -6,    -8,    10,   -30,    -6,   -80]
  K1( 207,:) = [     1,    -3,    -6,    -8,    -8,    24,    -6,     1,    10,    24,    48,    64,    -8,    18,     0,    64, &
                  -80,  -192,    -6,    -8,   -80,   -36,     0,    -8,     1,    21,    -3,    -8,    10,    -6,   -30,   -80, &
                   10,    21,    24,    64,   -62,  -168,  -192,  -512,   -62,    -6,    -3,    -8,    28,    48,    24,    64]
  K1( 208,:) = [     0,    -8,    -8,    -3,     0,    64,     1,    24,     0,     1,    64,    24,    21,    64,    64,   192, &
                    0,    -8,    -8,    -3,    -6,    -8,    -8,   -24,    24,    64,     1,     0,    24,    -8,    10,     0, &
                   -3,    -8,    -8,     0,    24,     1,    64,     0,    -3,     1,     1,     0,    24,    10,    -8,     0]
  K1( 209,:) = [   -30,   -80,     1,     0,  -240,   -80,   -80,    -6,    -3,    10,    -8,     0,   -30,     1,   -80,     0, &
                  -24,    -8,    -8,    21,    -3,    -8,    10,     0,     0,    10,    10,    24,     0,   -80,   -62,  -192, &
                    0,   -62,   -80,  -192,     0,   -71,    -8,  -192,     0,    -8,   -71,  -192,     0,     1,     1,    24]
  K1( 210,:) = [     1,    -6,    -3,    -8,   -80,     0,   -36,    -8,    10,    48,    24,    64,   -80,    -6,  -192,    -8, &
                   -8,     0,    18,    64,    -8,    -6,    24,     1,   -62,    -3,    -6,    -8,    10,   -30,    -6,   -80, &
                   28,    24,    48,    64,   -62,  -192,  -168,  -512,     1,    -3,    21,    -8,    10,    24,    21,    64]
  K1( 211,:) = [   -80,  -192,    -6,    -8,   -80,   -36,     0,    -8,    -8,    24,    -6,     1,     1,    -3,    -6,    -8, &
                   -8,    18,     0,    64,    10,    24,    48,    64,   -62,    -6,    -3,    -8,    28,    48,    24,    64, &
                   10,    -6,   -30,   -80,     1,    21,    -3,    -8,   -62,  -168,  -192,  -512,    10,    21,    24,    64]
  K1( 212,:) = [     0,    -8,    -8,    -3,    -6,    -8,    -8,   -24,     0,    64,     1,    24,     0,    -8,    -8,    -3, &
                   21,    64,    64,   192,     0,     1,    64,    24,    -3,     1,     1,     0,    24,    10,    -8,     0, &
                   24,    -8,    10,     0,    24,    64,     1,     0,    24,     1,    64,     0,    -3,    -8,    -8,     0]
  K1( 213,:) = [    -3,    10,    -8,     0,   -30,     1,   -80,     0,   -30,   -80,     1,     0,  -240,   -80,   -80,    -6, &
                   -3,    -8,    10,     0,   -24,    -8,    -8,    21,     0,   -62,   -80,  -192,     0,   -71,    -8,  -192, &
                    0,    10,    10,    24,     0,   -80,   -62,  -192,     0,     1,     1,    24,     0,    -8,   -71,  -192]
  K1( 214,:) = [    10,    48,    24,    64,   -80,    -6,  -192,    -8,     1,    -6,    -3,    -8,   -80,     0,   -36,    -8, &
                   -8,    -6,    24,     1,    -8,     0,    18,    64,    28,    24,    48,    64,   -62,  -192,  -168,  -512, &
                  -62,    -3,    -6,    -8,    10,   -30,    -6,   -80,    10,    24,    21,    64,     1,    -3,    21,    -8]
  K1( 215,:) = [    -8,    24,    -6,     1,     1,    -3,    -6,    -8,   -80,  -192,    -6,    -8,   -80,   -36,     0,    -8, &
                   10,    24,    48,    64,    -8,    18,     0,    64,    10,    -6,   -30,   -80,     1,    21,    -3,    -8, &
                  -62,    -6,    -3,    -8,    28,    48,    24,    64,    10,    21,    24,    64,   -62,  -168,  -192,  -512]
  K1( 216,:) = [     0,    64,     1,    24,     0,    -8,    -8,    -3,     0,    -8,    -8,    -3,    -6,    -8,    -8,   -24, &
                    0,     1,    64,    24,    21,    64,    64,   192,    24,    -8,    10,     0,    24,    64,     1,     0, &
                   -3,     1,     1,     0,    24,    10,    -8,     0,    -3,    -8,    -8,     0,    24,     1,    64,     0]
  K1( 217,:) = [     0,     1,   -62,    24,     0,    10,    10,    -3,     0,    10,    28,    24,     0,   -62,     1,    24, &
                    0,   -62,   -62,    -3,     0,    28,    10,    24,     3,     1,     1,  -168,    30,    10,    10,    48, &
                   30,    10,    10,    48,  -186,   -62,   -62,  -168,  -186,   -62,   -62,  -168,    84,    28,    28,    48]
  K1( 218,:) = [    -8,    -3,  -168,     1,     1,    24,    21,    -8,   -80,   -30,    48,    10,   -71,  -192,    21,    64, &
                   10,    -3,    -6,     1,   -62,    24,    -6,    -8,     1,     0,  -171,  -512,    10,     0,    18,    64, &
                   10,     0,    18,    64,   -62,     0,    18,    -8,   -62,     0,    18,    -8,    28,     0,   -36,   -80]
  K1( 219,:) = [   -71,    21,  -192,    64,     1,    21,    24,    -8,   -62,    -6,    24,    -8,    -8,  -168,    -3,     1, &
                   10,    -6,    -3,     1,   -80,    48,   -30,    10,     1,  -171,     0,  -512,    10,    18,     0,    64, &
                   10,    18,     0,    64,   -62,    18,     0,    -8,   -62,    18,     0,    -8,    28,   -36,     0,   -80]
  K1( 220,:) = [  -192,    -8,  -512,     0,    24,    64,    64,     0,  -192,   -80,    64,     0,  -192,  -512,    -8,     0, &
                   24,    -8,    -8,     0,  -192,    64,   -80,     0,  -168,  -512,  -512, -1536,    48,    64,    64,   192, &
                   48,    64,    64,   192,  -168,    -8,    -8,   -24,  -168,    -8,    -8,   -24,    48,   -80,   -80,  -240]
  K1( 221,:) = [     0,    10,    10,    -3,     0,     1,   -62,    24,     0,   -62,   -62,    -3,     0,    28,    10,    24, &
                    0,    10,    28,    24,     0,   -62,     1,    24,    30,    10,    10,    48,     3,     1,     1,  -168, &
                 -186,   -62,   -62,  -168,    84,    28,    28,    48,    30,    10,    10,    48,  -186,   -62,   -62,  -168]
  K1( 222,:) = [     1,    24,    21,    -8,    -8,    -3,  -168,     1,    10,    -3,    -6,     1,   -62,    24,    -6,    -8, &
                  -80,   -30,    48,    10,   -71,  -192,    21,    64,    10,     0,    18,    64,     1,     0,  -171,  -512, &
                  -62,     0,    18,    -8,    28,     0,   -36,   -80,    10,     0,    18,    64,   -62,     0,    18,    -8]
  K1( 223,:) = [     1,    21,    24,    -8,   -71,    21,  -192,    64,    10,    -6,    -3,     1,   -80,    48,   -30,    10, &
                  -62,    -6,    24,    -8,    -8,  -168,    -3,     1,    10,    18,     0,    64,     1,  -171,     0,  -512, &
                  -62,    18,     0,    -8,    28,   -36,     0,   -80,    10,    18,     0,    64,   -62,    18,     0,    -8]
  K1( 224,:) = [    24,    64,    64,     0,  -192,    -8,  -512,     0,    24,    -8,    -8,     0,  -192,    64,   -80,     0, &
                 -192,   -80,    64,     0,  -192,  -512,    -8,     0,    48,    64,    64,   192,  -168,  -512,  -512, -1536, &
                 -168,    -8,    -8,   -24,    48,   -80,   -80,  -240,    48,    64,    64,   192,  -168,    -8,    -8,   -24]
  K1( 225,:) = [     0,    10,    28,    24,     0,   -62,     1,    24,     0,     1,   -62,    24,     0,    10,    10,    -3, &
                    0,    28,    10,    24,     0,   -62,   -62,    -3,    30,    10,    10,    48,  -186,   -62,   -62,  -168, &
                    3,     1,     1,  -168,    30,    10,    10,    48,    84,    28,    28,    48,  -186,   -62,   -62,  -168]
  K1( 226,:) = [   -80,   -30,    48,    10,   -71,  -192,    21,    64,    -8,    -3,  -168,     1,     1,    24,    21,    -8, &
                  -62,    24,    -6,    -8,    10,    -3,    -6,     1,    10,     0,    18,    64,   -62,     0,    18,    -8, &
                    1,     0,  -171,  -512,    10,     0,    18,    64,    28,     0,   -36,   -80,   -62,     0,    18,    -8]
  K1( 227,:) = [   -62,    -6,    24,    -8,    -8,  -168,    -3,     1,   -71,    21,  -192,    64,     1,    21,    24,    -8, &
                  -80,    48,   -30,    10,    10,    -6,    -3,     1,    10,    18,     0,    64,   -62,    18,     0,    -8, &
                    1,  -171,     0,  -512,    10,    18,     0,    64,    28,   -36,     0,   -80,   -62,    18,     0,    -8]
  K1( 228,:) = [  -192,   -80,    64,     0,  -192,  -512,    -8,     0,  -192,    -8,  -512,     0,    24,    64,    64,     0, &
                 -192,    64,   -80,     0,    24,    -8,    -8,     0,    48,    64,    64,   192,  -168,    -8,    -8,   -24, &
                 -168,  -512,  -512, -1536,    48,    64,    64,   192,    48,   -80,   -80,  -240,  -168,    -8,    -8,   -24]
  K1( 229,:) = [     0,   -62,   -62,    -3,     0,    28,    10,    24,     0,    10,    10,    -3,     0,     1,   -62,    24, &
                    0,   -62,     1,    24,     0,    10,    28,    24,  -186,   -62,   -62,  -168,    84,    28,    28,    48, &
                   30,    10,    10,    48,     3,     1,     1,  -168,  -186,   -62,   -62,  -168,    30,    10,    10,    48]
  K1( 230,:) = [    10,    -3,    -6,     1,   -62,    24,    -6,    -8,     1,    24,    21,    -8,    -8,    -3,  -168,     1, &
                  -71,  -192,    21,    64,   -80,   -30,    48,    10,   -62,     0,    18,    -8,    28,     0,   -36,   -80, &
                   10,     0,    18,    64,     1,     0,  -171,  -512,   -62,     0,    18,    -8,    10,     0,    18,    64]
  K1( 231,:) = [    10,    -6,    -3,     1,   -80,    48,   -30,    10,     1,    21,    24,    -8,   -71,    21,  -192,    64, &
                   -8,  -168,    -3,     1,   -62,    -6,    24,    -8,   -62,    18,     0,    -8,    28,   -36,     0,   -80, &
                   10,    18,     0,    64,     1,  -171,     0,  -512,   -62,    18,     0,    -8,    10,    18,     0,    64]
  K1( 232,:) = [    24,    -8,    -8,     0,  -192,    64,   -80,     0,    24,    64,    64,     0,  -192,    -8,  -512,     0, &
                 -192,  -512,    -8,     0,  -192,   -80,    64,     0,  -168,    -8,    -8,   -24,    48,   -80,   -80,  -240, &
                   48,    64,    64,   192,  -168,  -512,  -512, -1536,  -168,    -8,    -8,   -24,    48,    64,    64,   192]
  K1( 233,:) = [     0,   -62,     1,    24,     0,    10,    28,    24,     0,    28,    10,    24,     0,   -62,   -62,    -3, &
                    0,     1,   -62,    24,     0,    10,    10,    -3,  -186,   -62,   -62,  -168,    30,    10,    10,    48, &
                   84,    28,    28,    48,  -186,   -62,   -62,  -168,     3,     1,     1,  -168,    30,    10,    10,    48]
  K1( 234,:) = [   -71,  -192,    21,    64,   -80,   -30,    48,    10,   -62,    24,    -6,    -8,    10,    -3,    -6,     1, &
                   -8,    -3,  -168,     1,     1,    24,    21,    -8,   -62,     0,    18,    -8,    10,     0,    18,    64, &
                   28,     0,   -36,   -80,   -62,     0,    18,    -8,     1,     0,  -171,  -512,    10,     0,    18,    64]
  K1( 235,:) = [    -8,  -168,    -3,     1,   -62,    -6,    24,    -8,   -80,    48,   -30,    10,    10,    -6,    -3,     1, &
                  -71,    21,  -192,    64,     1,    21,    24,    -8,   -62,    18,     0,    -8,    10,    18,     0,    64, &
                   28,   -36,     0,   -80,   -62,    18,     0,    -8,     1,  -171,     0,  -512,    10,    18,     0,    64]
  K1( 236,:) = [  -192,  -512,    -8,     0,  -192,   -80,    64,     0,  -192,    64,   -80,     0,    24,    -8,    -8,     0, &
                 -192,    -8,  -512,     0,    24,    64,    64,     0,  -168,    -8,    -8,   -24,    48,    64,    64,   192, &
                   48,   -80,   -80,  -240,  -168,    -8,    -8,   -24,  -168,  -512,  -512, -1536,    48,    64,    64,   192]
  K1( 237,:) = [     0,    28,    10,    24,     0,   -62,   -62,    -3,     0,   -62,     1,    24,     0,    10,    28,    24, &
                    0,    10,    10,    -3,     0,     1,   -62,    24,    84,    28,    28,    48,  -186,   -62,   -62,  -168, &
                 -186,   -62,   -62,  -168,    30,    10,    10,    48,    30,    10,    10,    48,     3,     1,     1,  -168]
  K1( 238,:) = [   -62,    24,    -6,    -8,    10,    -3,    -6,     1,   -71,  -192,    21,    64,   -80,   -30,    48,    10, &
                    1,    24,    21,    -8,    -8,    -3,  -168,     1,    28,     0,   -36,   -80,   -62,     0,    18,    -8, &
                  -62,     0,    18,    -8,    10,     0,    18,    64,    10,     0,    18,    64,     1,     0,  -171,  -512]
  K1( 239,:) = [   -80,    48,   -30,    10,    10,    -6,    -3,     1,    -8,  -168,    -3,     1,   -62,    -6,    24,    -8, &
                    1,    21,    24,    -8,   -71,    21,  -192,    64,    28,   -36,     0,   -80,   -62,    18,     0,    -8, &
                  -62,    18,     0,    -8,    10,    18,     0,    64,    10,    18,     0,    64,     1,  -171,     0,  -512]
  K1( 240,:) = [  -192,    64,   -80,     0,    24,    -8,    -8,     0,  -192,  -512,    -8,     0,  -192,   -80,    64,     0, &
                   24,    64,    64,     0,  -192,    -8,  -512,     0,    48,   -80,   -80,  -240,  -168,    -8,    -8,   -24, &
                 -168,    -8,    -8,   -24,    48,    64,    64,   192,    48,    64,    64,   192,  -168,  -512,  -512, -1536]
  K1( 241,:) = [     0,    -8,    64,    18,    -6,    -8,     1,    24,     0,   -80,    -8,   -36,    -6,     1,    -8,    -3, &
                   -6,   -80,    -8,  -192,    48,    10,    64,    24,    -3,     1,    -8,    21,    24,    10,    64,    21, &
                  -30,    10,   -80,    -6,    -3,   -62,    -8,    -6,  -192,   -62,  -512,  -168,    24,    28,    64,    48]
  K1( 242,:) = [    -8,   -24,    21,    -8,    -8,    -3,     0,    10,   -80,  -240,    -6,   -80,   -80,   -30,     0,     1, &
                    1,   -30,     0,   -80,    10,    -3,     0,    -8,    -8,     0,  -192,   -71,     1,     0,    24,     1, &
                  -80,     0,  -192,   -62,    10,     0,    24,    10,   -71,     0,  -192,    -8,   -62,     0,  -192,   -80]
  K1( 243,:) = [    64,    21,   192,    64,     1,     0,    24,    64,    -8,    -6,   -24,    -8,    -8,     0,    -3,    -8, &
                   -8,     0,    -3,    -8,    64,     0,    24,     1,     1,    24,     0,    64,    -8,    -3,     0,    -8, &
                   10,    24,     0,    -8,     1,    -3,     0,     1,    64,    24,     0,     1,    -8,    24,     0,    10]
  K1( 244,:) = [    18,    -8,    64,     0,    24,    10,    64,    48,   -36,   -80,    -8,     0,  -192,   -80,    -8,    -6, &
                   -3,     1,    -8,    -6,    24,    -8,     1,    -6,  -168,   -62,  -512,  -192,    21,    10,    64,    24, &
                   48,    28,    64,    24,    -6,   -62,    -8,    -3,    21,     1,    -8,    -3,    -6,    10,   -80,   -30]
  K1( 245,:) = [    -6,    -8,     1,    24,     0,    -8,    64,    18,    -6,   -80,    -8,  -192,    48,    10,    64,    24, &
                    0,   -80,    -8,   -36,    -6,     1,    -8,    -3,    24,    10,    64,    21,    -3,     1,    -8,    21, &
                 -192,   -62,  -512,  -168,    24,    28,    64,    48,   -30,    10,   -80,    -6,    -3,   -62,    -8,    -6]
  K1( 246,:) = [    -8,    -3,     0,    10,    -8,   -24,    21,    -8,     1,   -30,     0,   -80,    10,    -3,     0,    -8, &
                  -80,  -240,    -6,   -80,   -80,   -30,     0,     1,     1,     0,    24,     1,    -8,     0,  -192,   -71, &
                  -71,     0,  -192,    -8,   -62,     0,  -192,   -80,   -80,     0,  -192,   -62,    10,     0,    24,    10]
  K1( 247,:) = [     1,     0,    24,    64,    64,    21,   192,    64,    -8,     0,    -3,    -8,    64,     0,    24,     1, &
                   -8,    -6,   -24,    -8,    -8,     0,    -3,    -8,    -8,    -3,     0,    -8,     1,    24,     0,    64, &
                   64,    24,     0,     1,    -8,    24,     0,    10,    10,    24,     0,    -8,     1,    -3,     0,     1]
  K1( 248,:) = [    24,    10,    64,    48,    18,    -8,    64,     0,    -3,     1,    -8,    -6,    24,    -8,     1,    -6, &
                  -36,   -80,    -8,     0,  -192,   -80,    -8,    -6,    21,    10,    64,    24,  -168,   -62,  -512,  -192, &
                   21,     1,    -8,    -3,    -6,    10,   -80,   -30,    48,    28,    64,    24,    -6,   -62,    -8,    -3]
  K1( 249,:) = [     0,   -80,    -8,   -36,    -6,     1,    -8,    -3,     0,    -8,    64,    18,    -6,    -8,     1,    24, &
                   48,    10,    64,    24,    -6,   -80,    -8,  -192,   -30,    10,   -80,    -6,    -3,   -62,    -8,    -6, &
                   -3,     1,    -8,    21,    24,    10,    64,    21,    24,    28,    64,    48,  -192,   -62,  -512,  -168]
  K1( 250,:) = [   -80,  -240,    -6,   -80,   -80,   -30,     0,     1,    -8,   -24,    21,    -8,    -8,    -3,     0,    10, &
                   10,    -3,     0,    -8,     1,   -30,     0,   -80,   -80,     0,  -192,   -62,    10,     0,    24,    10, &
                   -8,     0,  -192,   -71,     1,     0,    24,     1,   -62,     0,  -192,   -80,   -71,     0,  -192,    -8]
  K1( 251,:) = [    -8,    -6,   -24,    -8,    -8,     0,    -3,    -8,    64,    21,   192,    64,     1,     0,    24,    64, &
                   64,     0,    24,     1,    -8,     0,    -3,    -8,    10,    24,     0,    -8,     1,    -3,     0,     1, &
                    1,    24,     0,    64,    -8,    -3,     0,    -8,    -8,    24,     0,    10,    64,    24,     0,     1]
  K1( 252,:) = [   -36,   -80,    -8,     0,  -192,   -80,    -8,    -6,    18,    -8,    64,     0,    24,    10,    64,    48, &
                   24,    -8,     1,    -6,    -3,     1,    -8,    -6,    48,    28,    64,    24,    -6,   -62,    -8,    -3, &
                 -168,   -62,  -512,  -192,    21,    10,    64,    24,    -6,    10,   -80,   -30,    21,     1,    -8,    -3]
  K1( 253,:) = [    -6,   -80,    -8,  -192,    48,    10,    64,    24,    -6,    -8,     1,    24,     0,    -8,    64,    18, &
                   -6,     1,    -8,    -3,     0,   -80,    -8,   -36,  -192,   -62,  -512,  -168,    24,    28,    64,    48, &
                   24,    10,    64,    21,    -3,     1,    -8,    21,    -3,   -62,    -8,    -6,   -30,    10,   -80,    -6]
  K1( 254,:) = [     1,   -30,     0,   -80,    10,    -3,     0,    -8,    -8,    -3,     0,    10,    -8,   -24,    21,    -8, &
                  -80,   -30,     0,     1,   -80,  -240,    -6,   -80,   -71,     0,  -192,    -8,   -62,     0,  -192,   -80, &
                    1,     0,    24,     1,    -8,     0,  -192,   -71,    10,     0,    24,    10,   -80,     0,  -192,   -62]
  K1( 255,:) = [    -8,     0,    -3,    -8,    64,     0,    24,     1,     1,     0,    24,    64,    64,    21,   192,    64, &
                   -8,     0,    -3,    -8,    -8,    -6,   -24,    -8,    64,    24,     0,     1,    -8,    24,     0,    10, &
                   -8,    -3,     0,    -8,     1,    24,     0,    64,     1,    -3,     0,     1,    10,    24,     0,    -8]
  K1( 256,:) = [    -3,     1,    -8,    -6,    24,    -8,     1,    -6,    24,    10,    64,    48,    18,    -8,    64,     0, &
                 -192,   -80,    -8,    -6,   -36,   -80,    -8,     0,    21,     1,    -8,    -3,    -6,    10,   -80,   -30, &
                   21,    10,    64,    24,  -168,   -62,  -512,  -192,    -6,   -62,    -8,    -3,    48,    28,    64,    24]
  K1( 257,:) = [    -6,     1,    -8,    -3,     0,   -80,    -8,   -36,    48,    10,    64,    24,    -6,   -80,    -8,  -192, &
                    0,    -8,    64,    18,    -6,    -8,     1,    24,    -3,   -62,    -8,    -6,   -30,    10,   -80,    -6, &
                   24,    28,    64,    48,  -192,   -62,  -512,  -168,    -3,     1,    -8,    21,    24,    10,    64,    21]
  K1( 258,:) = [   -80,   -30,     0,     1,   -80,  -240,    -6,   -80,    10,    -3,     0,    -8,     1,   -30,     0,   -80, &
                   -8,   -24,    21,    -8,    -8,    -3,     0,    10,    10,     0,    24,    10,   -80,     0,  -192,   -62, &
                  -62,     0,  -192,   -80,   -71,     0,  -192,    -8,    -8,     0,  -192,   -71,     1,     0,    24,     1]
  K1( 259,:) = [    -8,     0,    -3,    -8,    -8,    -6,   -24,    -8,    64,     0,    24,     1,    -8,     0,    -3,    -8, &
                   64,    21,   192,    64,     1,     0,    24,    64,     1,    -3,     0,     1,    10,    24,     0,    -8, &
                   -8,    24,     0,    10,    64,    24,     0,     1,     1,    24,     0,    64,    -8,    -3,     0,    -8]
  K1( 260,:) = [  -192,   -80,    -8,    -6,   -36,   -80,    -8,     0,    24,    -8,     1,    -6,    -3,     1,    -8,    -6, &
                   18,    -8,    64,     0,    24,    10,    64,    48,    -6,   -62,    -8,    -3,    48,    28,    64,    24, &
                   -6,    10,   -80,   -30,    21,     1,    -8,    -3,  -168,   -62,  -512,  -192,    21,    10,    64,    24]
  K1( 261,:) = [    48,    10,    64,    24,    -6,   -80,    -8,  -192,    -6,     1,    -8,    -3,     0,   -80,    -8,   -36, &
                   -6,    -8,     1,    24,     0,    -8,    64,    18,    24,    28,    64,    48,  -192,   -62,  -512,  -168, &
                   -3,   -62,    -8,    -6,   -30,    10,   -80,    -6,    24,    10,    64,    21,    -3,     1,    -8,    21]
  K1( 262,:) = [    10,    -3,     0,    -8,     1,   -30,     0,   -80,   -80,   -30,     0,     1,   -80,  -240,    -6,   -80, &
                   -8,    -3,     0,    10,    -8,   -24,    21,    -8,   -62,     0,  -192,   -80,   -71,     0,  -192,    -8, &
                   10,     0,    24,    10,   -80,     0,  -192,   -62,     1,     0,    24,     1,    -8,     0,  -192,   -71]
  K1( 263,:) = [    64,     0,    24,     1,    -8,     0,    -3,    -8,    -8,     0,    -3,    -8,    -8,    -6,   -24,    -8, &
                    1,     0,    24,    64,    64,    21,   192,    64,    -8,    24,     0,    10,    64,    24,     0,     1, &
                    1,    -3,     0,     1,    10,    24,     0,    -8,    -8,    -3,     0,    -8,     1,    24,     0,    64]
  K1( 264,:) = [    24,    -8,     1,    -6,    -3,     1,    -8,    -6,  -192,   -80,    -8,    -6,   -36,   -80,    -8,     0, &
                   24,    10,    64,    48,    18,    -8,    64,     0,    -6,    10,   -80,   -30,    21,     1,    -8,    -3, &
                   -6,   -62,    -8,    -3,    48,    28,    64,    24,    21,    10,    64,    24,  -168,   -62,  -512,  -192]
  K1( 265,:) = [    -3,    -8,     1,  -168,    24,     1,    -8,    21,   -30,   -80,    10,    48,  -192,   -71,    64,    21, &
                   -3,    10,     1,    -6,    24,   -62,    -8,    -6,     0,     1,  -512,  -171,     0,    10,    64,    18, &
                    0,    10,    64,    18,     0,   -62,    -8,    18,     0,   -62,    -8,    18,     0,    28,   -80,   -36]
  K1( 266,:) = [     1,     0,    24,   -62,    10,     0,    -3,    10,    10,     0,    24,    28,   -62,     0,    24,     1, &
                  -62,     0,    -3,   -62,    28,     0,    24,    10,     1,     3,  -168,     1,    10,    30,    48,    10, &
                   10,    30,    48,    10,   -62,  -186,  -168,   -62,   -62,  -186,  -168,   -62,    28,    84,    48,    28]
  K1( 267,:) = [    -8,  -192,     0,  -512,    64,    24,     0,    64,   -80,  -192,     0,    64,  -512,  -192,     0,    -8, &
                   -8,    24,     0,    -8,    64,  -192,     0,   -80,  -512,  -168, -1536,  -512,    64,    48,   192,    64, &
                   64,    48,   192,    64,    -8,  -168,   -24,    -8,    -8,  -168,   -24,    -8,   -80,    48,  -240,   -80]
  K1( 268,:) = [    21,   -71,    64,  -192,    21,     1,    -8,    24,    -6,   -62,    -8,    24,  -168,    -8,     1,    -3, &
                   -6,    10,     1,    -3,    48,   -80,    10,   -30,  -171,     1,  -512,     0,    18,    10,    64,     0, &
                   18,    10,    64,     0,    18,   -62,    -8,     0,    18,   -62,    -8,     0,   -36,    28,   -80,     0]
  K1( 269,:) = [    24,     1,    -8,    21,    -3,    -8,     1,  -168,    -3,    10,     1,    -6,    24,   -62,    -8,    -6, &
                  -30,   -80,    10,    48,  -192,   -71,    64,    21,     0,    10,    64,    18,     0,     1,  -512,  -171, &
                    0,   -62,    -8,    18,     0,    28,   -80,   -36,     0,    10,    64,    18,     0,   -62,    -8,    18]
  K1( 270,:) = [    10,     0,    -3,    10,     1,     0,    24,   -62,   -62,     0,    -3,   -62,    28,     0,    24,    10, &
                   10,     0,    24,    28,   -62,     0,    24,     1,    10,    30,    48,    10,     1,     3,  -168,     1, &
                  -62,  -186,  -168,   -62,    28,    84,    48,    28,    10,    30,    48,    10,   -62,  -186,  -168,   -62]
  K1( 271,:) = [    64,    24,     0,    64,    -8,  -192,     0,  -512,    -8,    24,     0,    -8,    64,  -192,     0,   -80, &
                  -80,  -192,     0,    64,  -512,  -192,     0,    -8,    64,    48,   192,    64,  -512,  -168, -1536,  -512, &
                   -8,  -168,   -24,    -8,   -80,    48,  -240,   -80,    64,    48,   192,    64,    -8,  -168,   -24,    -8]
  K1( 272,:) = [    21,     1,    -8,    24,    21,   -71,    64,  -192,    -6,    10,     1,    -3,    48,   -80,    10,   -30, &
                   -6,   -62,    -8,    24,  -168,    -8,     1,    -3,    18,    10,    64,     0,  -171,     1,  -512,     0, &
                   18,   -62,    -8,     0,   -36,    28,   -80,     0,    18,    10,    64,     0,    18,   -62,    -8,     0]
  K1( 273,:) = [   -30,   -80,    10,    48,  -192,   -71,    64,    21,    -3,    -8,     1,  -168,    24,     1,    -8,    21, &
                   24,   -62,    -8,    -6,    -3,    10,     1,    -6,     0,    10,    64,    18,     0,   -62,    -8,    18, &
                    0,     1,  -512,  -171,     0,    10,    64,    18,     0,    28,   -80,   -36,     0,   -62,    -8,    18]
  K1( 274,:) = [    10,     0,    24,    28,   -62,     0,    24,     1,     1,     0,    24,   -62,    10,     0,    -3,    10, &
                   28,     0,    24,    10,   -62,     0,    -3,   -62,    10,    30,    48,    10,   -62,  -186,  -168,   -62, &
                    1,     3,  -168,     1,    10,    30,    48,    10,    28,    84,    48,    28,   -62,  -186,  -168,   -62]
  K1( 275,:) = [   -80,  -192,     0,    64,  -512,  -192,     0,    -8,    -8,  -192,     0,  -512,    64,    24,     0,    64, &
                   64,  -192,     0,   -80,    -8,    24,     0,    -8,    64,    48,   192,    64,    -8,  -168,   -24,    -8, &
                 -512,  -168, -1536,  -512,    64,    48,   192,    64,   -80,    48,  -240,   -80,    -8,  -168,   -24,    -8]
  K1( 276,:) = [    -6,   -62,    -8,    24,  -168,    -8,     1,    -3,    21,   -71,    64,  -192,    21,     1,    -8,    24, &
                   48,   -80,    10,   -30,    -6,    10,     1,    -3,    18,    10,    64,     0,    18,   -62,    -8,     0, &
                 -171,     1,  -512,     0,    18,    10,    64,     0,   -36,    28,   -80,     0,    18,   -62,    -8,     0]
  K1( 277,:) = [    -3,    10,     1,    -6,    24,   -62,    -8,    -6,    24,     1,    -8,    21,    -3,    -8,     1,  -168, &
                 -192,   -71,    64,    21,   -30,   -80,    10,    48,     0,   -62,    -8,    18,     0,    28,   -80,   -36, &
                    0,    10,    64,    18,     0,     1,  -512,  -171,     0,   -62,    -8,    18,     0,    10,    64,    18]
  K1( 278,:) = [   -62,     0,    -3,   -62,    28,     0,    24,    10,    10,     0,    -3,    10,     1,     0,    24,   -62, &
                  -62,     0,    24,     1,    10,     0,    24,    28,   -62,  -186,  -168,   -62,    28,    84,    48,    28, &
                   10,    30,    48,    10,     1,     3,  -168,     1,   -62,  -186,  -168,   -62,    10,    30,    48,    10]
  K1( 279,:) = [    -8,    24,     0,    -8,    64,  -192,     0,   -80,    64,    24,     0,    64,    -8,  -192,     0,  -512, &
                 -512,  -192,     0,    -8,   -80,  -192,     0,    64,    -8,  -168,   -24,    -8,   -80,    48,  -240,   -80, &
                   64,    48,   192,    64,  -512,  -168, -1536,  -512,    -8,  -168,   -24,    -8,    64,    48,   192,    64]
  K1( 280,:) = [    -6,    10,     1,    -3,    48,   -80,    10,   -30,    21,     1,    -8,    24,    21,   -71,    64,  -192, &
                 -168,    -8,     1,    -3,    -6,   -62,    -8,    24,    18,   -62,    -8,     0,   -36,    28,   -80,     0, &
                   18,    10,    64,     0,  -171,     1,  -512,     0,    18,   -62,    -8,     0,    18,    10,    64,     0]
  K1( 281,:) = [  -192,   -71,    64,    21,   -30,   -80,    10,    48,    24,   -62,    -8,    -6,    -3,    10,     1,    -6, &
                   -3,    -8,     1,  -168,    24,     1,    -8,    21,     0,   -62,    -8,    18,     0,    10,    64,    18, &
                    0,    28,   -80,   -36,     0,   -62,    -8,    18,     0,     1,  -512,  -171,     0,    10,    64,    18]
  K1( 282,:) = [   -62,     0,    24,     1,    10,     0,    24,    28,    28,     0,    24,    10,   -62,     0,    -3,   -62, &
                    1,     0,    24,   -62,    10,     0,    -3,    10,   -62,  -186,  -168,   -62,    10,    30,    48,    10, &
                   28,    84,    48,    28,   -62,  -186,  -168,   -62,     1,     3,  -168,     1,    10,    30,    48,    10]
  K1( 283,:) = [  -512,  -192,     0,    -8,   -80,  -192,     0,    64,    64,  -192,     0,   -80,    -8,    24,     0,    -8, &
                   -8,  -192,     0,  -512,    64,    24,     0,    64,    -8,  -168,   -24,    -8,    64,    48,   192,    64, &
                  -80,    48,  -240,   -80,    -8,  -168,   -24,    -8,  -512,  -168, -1536,  -512,    64,    48,   192,    64]
  K1( 284,:) = [  -168,    -8,     1,    -3,    -6,   -62,    -8,    24,    48,   -80,    10,   -30,    -6,    10,     1,    -3, &
                   21,   -71,    64,  -192,    21,     1,    -8,    24,    18,   -62,    -8,     0,    18,    10,    64,     0, &
                  -36,    28,   -80,     0,    18,   -62,    -8,     0,  -171,     1,  -512,     0,    18,    10,    64,     0]
  K1( 285,:) = [    24,   -62,    -8,    -6,    -3,    10,     1,    -6,  -192,   -71,    64,    21,   -30,   -80,    10,    48, &
                   24,     1,    -8,    21,    -3,    -8,     1,  -168,     0,    28,   -80,   -36,     0,   -62,    -8,    18, &
                    0,   -62,    -8,    18,     0,    10,    64,    18,     0,    10,    64,    18,     0,     1,  -512,  -171]
  K1( 286,:) = [    28,     0,    24,    10,   -62,     0,    -3,   -62,   -62,     0,    24,     1,    10,     0,    24,    28, &
                   10,     0,    -3,    10,     1,     0,    24,   -62,    28,    84,    48,    28,   -62,  -186,  -168,   -62, &
                  -62,  -186,  -168,   -62,    10,    30,    48,    10,    10,    30,    48,    10,     1,     3,  -168,     1]
  K1( 287,:) = [    64,  -192,     0,   -80,    -8,    24,     0,    -8,  -512,  -192,     0,    -8,   -80,  -192,     0,    64, &
                   64,    24,     0,    64,    -8,  -192,     0,  -512,   -80,    48,  -240,   -80,    -8,  -168,   -24,    -8, &
                   -8,  -168,   -24,    -8,    64,    48,   192,    64,    64,    48,   192,    64,  -512,  -168, -1536,  -512]
  K1( 288,:) = [    48,   -80,    10,   -30,    -6,    10,     1,    -3,  -168,    -8,     1,    -3,    -6,   -62,    -8,    24, &
                   21,     1,    -8,    24,    21,   -71,    64,  -192,   -36,    28,   -80,     0,    18,   -62,    -8,     0, &
                   18,   -62,    -8,     0,    18,    10,    64,     0,    18,    10,    64,     0,  -171,     1,  -512,     0]
  K1( 289,:) = [  1536,   512,   512,   168,   192,   512,     8,     0,  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,   -64,    80,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,    80,   -64,   192]
  K1( 290,:) = [   512,  1536,   168,   512,   512,   192,     0,     8,   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  -64,     0,   192,    80,     8,     0,   -24,     8,     8,     0,   192,   512,    80,     0,   192,   -64]
  K1( 291,:) = [   512,   168,  1536,   512,     8,     0,   192,   512,   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                   80,   192,     0,   -64,     8,   -24,     0,     8,   512,   192,     0,     8,   -64,   192,     0,    80]
  K1( 292,:) = [   168,   512,   512,  1536,     0,     8,   512,   192,   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,    80,   -64,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,   -64,    80,     0]
  K1( 293,:) = [   192,   512,     8,     0,  1536,   512,   512,   168,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                 -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,    80,   -64,   192,     0,   -64,    80,   192,     0,     8,     8,   -24]
  K1( 294,:) = [   512,   192,     0,     8,   512,  1536,   168,   512,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,    80,     0,   192,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8]
  K1( 295,:) = [     8,     0,   192,   512,   512,   168,  1536,   512,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                  -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,   -64,   192,     0,    80,    80,   192,     0,   -64,     8,   -24,     0,     8]
  K1( 296,:) = [     0,     8,   512,   192,   168,   512,   512,  1536,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                  -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,   -64,    80,     0,   192,    80,   -64,     0,   -24,     8,     8,     0]
  K1( 297,:) = [  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,  1536,   512,   512,   168,   192,   512,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,     0,   -64,    80,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,     0,    80,   -64,   192,     0,     8,   512,   192]
  K1( 298,:) = [   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   512,  1536,   168,   512,   512,   192,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,     0,   192,   -64,     8,     0,   192,   512]
  K1( 299,:) = [   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   512,   168,  1536,   512,     8,     0,   192,   512, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,   192,     0,   -64,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   192,     0,    80,   512,   192,     0,     8]
  K1( 300,:) = [   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   168,   512,   512,  1536,     0,     8,   512,   192, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,   192,    80,   -64,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   192,   -64,    80,     0,   192,   512,     8,     0]
  K1( 301,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   192,   512,     8,     0,  1536,   512,   512,   168, &
                  -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,     0,     8,   512,   192,     0,    80,   -64,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,   -64,    80,   192]
  K1( 302,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,   512,   192,     0,     8,   512,  1536,   168,   512, &
                  -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,     0,   192,   512,    80,     0,   192,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,   -64,     0,   192,    80]
  K1( 303,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   192,   512,   512,   168,  1536,   512, &
                  -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,   192,     0,     8,   -64,   192,     0,    80, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,    80,   192,     0,   -64]
  K1( 304,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,   512,   192,   168,   512,   512,  1536, &
                    0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,   192,   512,     8,     0,   192,   -64,    80,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,    80,   -64,     0]
  K1( 305,:) = [   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                 1536,   512,   512,   168,   192,   512,     8,     0,     0,     8,     8,   -24,     0,   -64,    80,   192, &
                    0,    80,   -64,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24]
  K1( 306,:) = [   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  512,  1536,   168,   512,   512,   192,     0,     8,     8,     0,   -24,     8,   -64,     0,   192,    80, &
                   80,     0,   192,   -64,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64]
  K1( 307,:) = [   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  512,   168,  1536,   512,     8,     0,   192,   512,     8,   -24,     0,     8,    80,   192,     0,   -64, &
                  -64,   192,     0,    80,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64]
  K1( 308,:) = [     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                  168,   512,   512,  1536,     0,     8,   512,   192,   -24,     8,     8,     0,   192,    80,   -64,     0, &
                  192,   -64,    80,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0]
  K1( 309,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48, &
                  192,   512,     8,     0,  1536,   512,   512,   168,     0,    80,   -64,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,   -64,    80,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192]
  K1( 310,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64, &
                  512,   192,     0,     8,   512,  1536,   168,   512,    80,     0,   192,   -64,     8,     0,   192,   512, &
                    8,     0,   -24,     8,   -64,     0,   192,    80,   -64,     0,   -24,   -64,   512,     0,   192,     8]
  K1( 311,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64, &
                    8,     0,   192,   512,   512,   168,  1536,   512,   -64,   192,     0,    80,   512,   192,     0,     8, &
                    8,   -24,     0,     8,    80,   192,     0,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512]
  K1( 312,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192, &
                    0,     8,   512,   192,   168,   512,   512,  1536,   192,   -64,    80,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,    80,   -64,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0]
  K1( 313,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,    80,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,    80,   -64,   192,  1536,   512,   512,   168,  -192,   -64,   -64,   -48, &
                 -192,   -64,   -64,   -48,    24,     8,     8,   168,    24,     8,     8,   168,   240,    80,    80,   -48]
  K1( 314,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   192,    80,     8,     0,   192,   512, &
                    8,     0,   -24,     8,    80,     0,   192,   -64,   512,  1536,   168,   512,   -64,  -192,   -48,   -64, &
                  -64,  -192,   -48,   -64,     8,    24,   168,     8,     8,    24,   168,     8,    80,   240,   -48,    80]
  K1( 315,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,    80,   192,     0,   -64,   512,   192,     0,     8, &
                    8,   -24,     0,     8,   -64,   192,     0,    80,   512,   168,  1536,   512,   -64,   -48,  -192,   -64, &
                  -64,   -48,  -192,   -64,     8,   168,    24,     8,     8,   168,    24,     8,    80,   -48,   240,    80]
  K1( 316,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   192,    80,   -64,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,   -64,    80,     0,   168,   512,   512,  1536,   -48,   -64,   -64,  -192, &
                  -48,   -64,   -64,  -192,   168,     8,     8,    24,   168,     8,     8,    24,   -48,    80,    80,   240]
  K1( 317,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,    80,   -64,   192, &
                    0,   -64,    80,   192,     0,     8,   512,   192,  -192,   -64,   -64,   -48,  1536,   512,   512,   168, &
                   24,     8,     8,   168,   240,    80,    80,   -48,  -192,   -64,   -64,   -48,    24,     8,     8,   168]
  K1( 318,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,    80,     0,   192,   -64, &
                  -64,     0,   192,    80,     8,     0,   192,   512,   -64,  -192,   -48,   -64,   512,  1536,   168,   512, &
                    8,    24,   168,     8,    80,   240,   -48,    80,   -64,  -192,   -48,   -64,     8,    24,   168,     8]
  K1( 319,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,   -64,   192,     0,    80, &
                   80,   192,     0,   -64,   512,   192,     0,     8,   -64,   -48,  -192,   -64,   512,   168,  1536,   512, &
                    8,   168,    24,     8,    80,   -48,   240,    80,   -64,   -48,  -192,   -64,     8,   168,    24,     8]
  K1( 320,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,   -64,    80,     0, &
                  192,    80,   -64,     0,   192,   512,     8,     0,   -48,   -64,   -64,  -192,   168,   512,   512,  1536, &
                  168,     8,     8,    24,   -48,    80,    80,   240,   -48,   -64,   -64,  -192,   168,     8,     8,    24]
  K1( 321,:) = [     0,   -64,    80,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,    80,   -64,   192,     0,     8,     8,   -24,  -192,   -64,   -64,   -48,    24,     8,     8,   168, &
                 1536,   512,   512,   168,  -192,   -64,   -64,   -48,   240,    80,    80,   -48,    24,     8,     8,   168]
  K1( 322,:) = [   -64,     0,   192,    80,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                   80,     0,   192,   -64,     8,     0,   -24,     8,   -64,  -192,   -48,   -64,     8,    24,   168,     8, &
                  512,  1536,   168,   512,   -64,  -192,   -48,   -64,    80,   240,   -48,    80,     8,    24,   168,     8]
  K1( 323,:) = [    80,   192,     0,   -64,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  -64,   192,     0,    80,     8,   -24,     0,     8,   -64,   -48,  -192,   -64,     8,   168,    24,     8, &
                  512,   168,  1536,   512,   -64,   -48,  -192,   -64,    80,   -48,   240,    80,     8,   168,    24,     8]
  K1( 324,:) = [   192,    80,   -64,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,   -64,    80,     0,   -24,     8,     8,     0,   -48,   -64,   -64,  -192,   168,     8,     8,    24, &
                  168,   512,   512,  1536,   -48,   -64,   -64,  -192,   -48,    80,    80,   240,   168,     8,     8,    24]
  K1( 325,:) = [     0,     8,     8,   -24,     0,    80,   -64,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,   -64,    80,   192,    24,     8,     8,   168,   240,    80,    80,   -48, &
                 -192,   -64,   -64,   -48,  1536,   512,   512,   168,    24,     8,     8,   168,  -192,   -64,   -64,   -48]
  K1( 326,:) = [     8,     0,   -24,     8,    80,     0,   192,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,   -64,     0,   192,    80,     8,    24,   168,     8,    80,   240,   -48,    80, &
                  -64,  -192,   -48,   -64,   512,  1536,   168,   512,     8,    24,   168,     8,   -64,  -192,   -48,   -64]
  K1( 327,:) = [     8,   -24,     0,     8,   -64,   192,     0,    80,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,    80,   192,     0,   -64,     8,   168,    24,     8,    80,   -48,   240,    80, &
                  -64,   -48,  -192,   -64,   512,   168,  1536,   512,     8,   168,    24,     8,   -64,   -48,  -192,   -64]
  K1( 328,:) = [   -24,     8,     8,     0,   192,   -64,    80,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,    80,   -64,     0,   168,     8,     8,    24,   -48,    80,    80,   240, &
                  -48,   -64,   -64,  -192,   168,   512,   512,  1536,   168,     8,     8,    24,   -48,   -64,   -64,  -192]
  K1( 329,:) = [     0,     8,   512,   192,     0,   -64,    80,   192,     0,    80,   -64,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,    24,     8,     8,   168,  -192,   -64,   -64,   -48, &
                  240,    80,    80,   -48,    24,     8,     8,   168,  1536,   512,   512,   168,  -192,   -64,   -64,   -48]
  K1( 330,:) = [     8,     0,   192,   512,   -64,     0,   192,    80,    80,     0,   192,   -64,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,     8,    24,   168,     8,   -64,  -192,   -48,   -64, &
                   80,   240,   -48,    80,     8,    24,   168,     8,   512,  1536,   168,   512,   -64,  -192,   -48,   -64]
  K1( 331,:) = [   512,   192,     0,     8,    80,   192,     0,   -64,   -64,   192,     0,    80,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,     8,   168,    24,     8,   -64,   -48,  -192,   -64, &
                   80,   -48,   240,    80,     8,   168,    24,     8,   512,   168,  1536,   512,   -64,   -48,  -192,   -64]
  K1( 332,:) = [   192,   512,     8,     0,   192,    80,   -64,     0,   192,   -64,    80,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   168,     8,     8,    24,   -48,   -64,   -64,  -192, &
                  -48,    80,    80,   240,   168,     8,     8,    24,   168,   512,   512,  1536,   -48,   -64,   -64,  -192]
  K1( 333,:) = [     0,    80,   -64,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,   -64,    80,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   240,    80,    80,   -48,    24,     8,     8,   168, &
                   24,     8,     8,   168,  -192,   -64,   -64,   -48,  -192,   -64,   -64,   -48,  1536,   512,   512,   168]
  K1( 334,:) = [    80,     0,   192,   -64,     8,     0,   -24,     8,     8,     0,   192,   512,   -64,     0,   192,    80, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,    80,   240,   -48,    80,     8,    24,   168,     8, &
                    8,    24,   168,     8,   -64,  -192,   -48,   -64,   -64,  -192,   -48,   -64,   512,  1536,   168,   512]
  K1( 335,:) = [   -64,   192,     0,    80,     8,   -24,     0,     8,   512,   192,     0,     8,    80,   192,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,    80,   -48,   240,    80,     8,   168,    24,     8, &
                    8,   168,    24,     8,   -64,   -48,  -192,   -64,   -64,   -48,  -192,   -64,   512,   168,  1536,   512]
  K1( 336,:) = [   192,   -64,    80,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,    80,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -48,    80,    80,   240,   168,     8,     8,    24, &
                  168,     8,     8,    24,   -48,   -64,   -64,  -192,   -48,   -64,   -64,  -192,   168,   512,   512,  1536]
  K1( 337,:) = [     0,    64,    -8,    18,    48,    64,    10,    24,     0,    -8,   -80,   -36,    -6,    -8,   -80,  -192, &
                   -6,    -8,     1,    -3,    -6,     1,    -8,    24,  -192,  -512,   -62,  -168,    24,    64,    10,    21, &
                   24,    64,    28,    48,    -3,    -8,   -62,    -6,    -3,    -8,     1,    21,   -30,   -80,    10,    -6]
  K1( 338,:) = [    64,   192,    21,    64,    64,    24,     0,     1,    -8,   -24,    -6,    -8,    -8,    -3,     0,    -8, &
                   -8,    -3,     0,    -8,     1,    24,     0,    64,    64,     0,    24,     1,    -8,     0,    -3,    -8, &
                   -8,     0,    24,    10,     1,     0,    -3,     1,     1,     0,    24,    64,    10,     0,    24,    -8]
  K1( 339,:) = [    -8,    21,   -24,    -8,    10,     0,    -3,    -8,   -80,    -6,  -240,   -80,     1,     0,   -30,   -80, &
                  -80,     0,   -30,     1,    -8,     0,    -3,    10,   -71,  -192,     0,    -8,     1,    24,     0,     1, &
                  -62,  -192,     0,   -80,    10,    24,     0,    10,    -8,  -192,     0,   -71,   -80,  -192,     0,   -62]
  K1( 340,:) = [    18,    64,    -8,     0,    24,     1,    -8,    -6,   -36,    -8,   -80,     0,    -3,    -8,     1,    -6, &
                 -192,    -8,   -80,    -6,    24,    64,    10,    48,    21,    -8,     1,    -3,    21,    64,    10,    24, &
                   -6,   -80,    10,   -30,    -6,    -8,   -62,    -3,  -168,  -512,   -62,  -192,    48,    64,    28,    24]
  K1( 341,:) = [    48,    64,    10,    24,     0,    64,    -8,    18,    -6,    -8,     1,    -3,    -6,     1,    -8,    24, &
                    0,    -8,   -80,   -36,    -6,    -8,   -80,  -192,    24,    64,    10,    21,  -192,  -512,   -62,  -168, &
                   -3,    -8,     1,    21,   -30,   -80,    10,    -6,    24,    64,    28,    48,    -3,    -8,   -62,    -6]
  K1( 342,:) = [    64,    24,     0,     1,    64,   192,    21,    64,    -8,    -3,     0,    -8,     1,    24,     0,    64, &
                   -8,   -24,    -6,    -8,    -8,    -3,     0,    -8,    -8,     0,    -3,    -8,    64,     0,    24,     1, &
                    1,     0,    24,    64,    10,     0,    24,    -8,    -8,     0,    24,    10,     1,     0,    -3,     1]
  K1( 343,:) = [    10,     0,    -3,    -8,    -8,    21,   -24,    -8,   -80,     0,   -30,     1,    -8,     0,    -3,    10, &
                  -80,    -6,  -240,   -80,     1,     0,   -30,   -80,     1,    24,     0,     1,   -71,  -192,     0,    -8, &
                   -8,  -192,     0,   -71,   -80,  -192,     0,   -62,   -62,  -192,     0,   -80,    10,    24,     0,    10]
  K1( 344,:) = [    24,     1,    -8,    -6,    18,    64,    -8,     0,  -192,    -8,   -80,    -6,    24,    64,    10,    48, &
                  -36,    -8,   -80,     0,    -3,    -8,     1,    -6,    21,    64,    10,    24,    21,    -8,     1,    -3, &
                 -168,  -512,   -62,  -192,    48,    64,    28,    24,    -6,   -80,    10,   -30,    -6,    -8,   -62,    -3]
  K1( 345,:) = [     0,    -8,   -80,   -36,    -6,    -8,   -80,  -192,     0,    64,    -8,    18,    48,    64,    10,    24, &
                   -6,     1,    -8,    24,    -6,    -8,     1,    -3,    24,    64,    28,    48,    -3,    -8,   -62,    -6, &
                 -192,  -512,   -62,  -168,    24,    64,    10,    21,   -30,   -80,    10,    -6,    -3,    -8,     1,    21]
  K1( 346,:) = [    -8,   -24,    -6,    -8,    -8,    -3,     0,    -8,    64,   192,    21,    64,    64,    24,     0,     1, &
                    1,    24,     0,    64,    -8,    -3,     0,    -8,    -8,     0,    24,    10,     1,     0,    -3,     1, &
                   64,     0,    24,     1,    -8,     0,    -3,    -8,    10,     0,    24,    -8,     1,     0,    24,    64]
  K1( 347,:) = [   -80,    -6,  -240,   -80,     1,     0,   -30,   -80,    -8,    21,   -24,    -8,    10,     0,    -3,    -8, &
                   -8,     0,    -3,    10,   -80,     0,   -30,     1,   -62,  -192,     0,   -80,    10,    24,     0,    10, &
                  -71,  -192,     0,    -8,     1,    24,     0,     1,   -80,  -192,     0,   -62,    -8,  -192,     0,   -71]
  K1( 348,:) = [   -36,    -8,   -80,     0,    -3,    -8,     1,    -6,    18,    64,    -8,     0,    24,     1,    -8,    -6, &
                   24,    64,    10,    48,  -192,    -8,   -80,    -6,    -6,   -80,    10,   -30,    -6,    -8,   -62,    -3, &
                   21,    -8,     1,    -3,    21,    64,    10,    24,    48,    64,    28,    24,  -168,  -512,   -62,  -192]
  K1( 349,:) = [    -6,    -8,     1,    -3,    -6,     1,    -8,    24,    48,    64,    10,    24,     0,    64,    -8,    18, &
                   -6,    -8,   -80,  -192,     0,    -8,   -80,   -36,    -3,    -8,     1,    21,   -30,   -80,    10,    -6, &
                   24,    64,    10,    21,  -192,  -512,   -62,  -168,    -3,    -8,   -62,    -6,    24,    64,    28,    48]
  K1( 350,:) = [    -8,    -3,     0,    -8,     1,    24,     0,    64,    64,    24,     0,     1,    64,   192,    21,    64, &
                   -8,    -3,     0,    -8,    -8,   -24,    -6,    -8,     1,     0,    24,    64,    10,     0,    24,    -8, &
                   -8,     0,    -3,    -8,    64,     0,    24,     1,     1,     0,    -3,     1,    -8,     0,    24,    10]
  K1( 351,:) = [   -80,     0,   -30,     1,    -8,     0,    -3,    10,    10,     0,    -3,    -8,    -8,    21,   -24,    -8, &
                    1,     0,   -30,   -80,   -80,    -6,  -240,   -80,    -8,  -192,     0,   -71,   -80,  -192,     0,   -62, &
                    1,    24,     0,     1,   -71,  -192,     0,    -8,    10,    24,     0,    10,   -62,  -192,     0,   -80]
  K1( 352,:) = [  -192,    -8,   -80,    -6,    24,    64,    10,    48,    24,     1,    -8,    -6,    18,    64,    -8,     0, &
                   -3,    -8,     1,    -6,   -36,    -8,   -80,     0,  -168,  -512,   -62,  -192,    48,    64,    28,    24, &
                   21,    64,    10,    24,    21,    -8,     1,    -3,    -6,    -8,   -62,    -3,    -6,   -80,    10,   -30]
  K1( 353,:) = [    -6,    -8,   -80,  -192,     0,    -8,   -80,   -36,    -6,     1,    -8,    24,    -6,    -8,     1,    -3, &
                    0,    64,    -8,    18,    48,    64,    10,    24,    -3,    -8,   -62,    -6,    24,    64,    28,    48, &
                  -30,   -80,    10,    -6,    -3,    -8,     1,    21,  -192,  -512,   -62,  -168,    24,    64,    10,    21]
  K1( 354,:) = [    -8,    -3,     0,    -8,    -8,   -24,    -6,    -8,     1,    24,     0,    64,    -8,    -3,     0,    -8, &
                   64,   192,    21,    64,    64,    24,     0,     1,     1,     0,    -3,     1,    -8,     0,    24,    10, &
                   10,     0,    24,    -8,     1,     0,    24,    64,    64,     0,    24,     1,    -8,     0,    -3,    -8]
  K1( 355,:) = [     1,     0,   -30,   -80,   -80,    -6,  -240,   -80,    -8,     0,    -3,    10,   -80,     0,   -30,     1, &
                   -8,    21,   -24,    -8,    10,     0,    -3,    -8,    10,    24,     0,    10,   -62,  -192,     0,   -80, &
                  -80,  -192,     0,   -62,    -8,  -192,     0,   -71,   -71,  -192,     0,    -8,     1,    24,     0,     1]
  K1( 356,:) = [    -3,    -8,     1,    -6,   -36,    -8,   -80,     0,    24,    64,    10,    48,  -192,    -8,   -80,    -6, &
                   18,    64,    -8,     0,    24,     1,    -8,    -6,    -6,    -8,   -62,    -3,    -6,   -80,    10,   -30, &
                   48,    64,    28,    24,  -168,  -512,   -62,  -192,    21,    -8,     1,    -3,    21,    64,    10,    24]
  K1( 357,:) = [    -6,     1,    -8,    24,    -6,    -8,     1,    -3,    -6,    -8,   -80,  -192,     0,    -8,   -80,   -36, &
                   48,    64,    10,    24,     0,    64,    -8,    18,   -30,   -80,    10,    -6,    -3,    -8,     1,    21, &
                   -3,    -8,   -62,    -6,    24,    64,    28,    48,    24,    64,    10,    21,  -192,  -512,   -62,  -168]
  K1( 358,:) = [     1,    24,     0,    64,    -8,    -3,     0,    -8,    -8,    -3,     0,    -8,    -8,   -24,    -6,    -8, &
                   64,    24,     0,     1,    64,   192,    21,    64,    10,     0,    24,    -8,     1,     0,    24,    64, &
                    1,     0,    -3,     1,    -8,     0,    24,    10,    -8,     0,    -3,    -8,    64,     0,    24,     1]
  K1( 359,:) = [    -8,     0,    -3,    10,   -80,     0,   -30,     1,     1,     0,   -30,   -80,   -80,    -6,  -240,   -80, &
                   10,     0,    -3,    -8,    -8,    21,   -24,    -8,   -80,  -192,     0,   -62,    -8,  -192,     0,   -71, &
                   10,    24,     0,    10,   -62,  -192,     0,   -80,     1,    24,     0,     1,   -71,  -192,     0,    -8]
  K1( 360,:) = [    24,    64,    10,    48,  -192,    -8,   -80,    -6,    -3,    -8,     1,    -6,   -36,    -8,   -80,     0, &
                   24,     1,    -8,    -6,    18,    64,    -8,     0,    48,    64,    28,    24,  -168,  -512,   -62,  -192, &
                   -6,    -8,   -62,    -3,    -6,   -80,    10,   -30,    21,    64,    10,    24,    21,    -8,     1,    -3]
  K1( 361,:) = [  -192,    64,   -71,    21,    24,    -8,     1,    21,    24,    -8,   -62,    -6,    -3,     1,    -8,  -168, &
                   -3,     1,    10,    -6,   -30,    10,   -80,    48,     0,  -512,     1,  -171,     0,    64,    10,    18, &
                    0,    64,    10,    18,     0,    -8,   -62,    18,     0,    -8,   -62,    18,     0,   -80,    28,   -36]
  K1( 362,:) = [  -512,     0,  -192,    -8,    64,     0,    24,    64,    64,     0,  -192,   -80,    -8,     0,  -192,  -512, &
                   -8,     0,    24,    -8,   -80,     0,  -192,    64,  -512, -1536,  -168,  -512,    64,   192,    48,    64, &
                   64,   192,    48,    64,    -8,   -24,  -168,    -8,    -8,   -24,  -168,    -8,   -80,  -240,    48,   -80]
  K1( 363,:) = [   -62,    24,     0,     1,    10,    -3,     0,    10,    28,    24,     0,    10,     1,    24,     0,   -62, &
                  -62,    -3,     0,   -62,    10,    24,     0,    28,     1,  -168,     3,     1,    10,    48,    30,    10, &
                   10,    48,    30,    10,   -62,  -168,  -186,   -62,   -62,  -168,  -186,   -62,    28,    48,    84,    28]
  K1( 364,:) = [  -168,     1,    -8,    -3,    21,    -8,     1,    24,    48,    10,   -80,   -30,    21,    64,   -71,  -192, &
                   -6,     1,    10,    -3,    -6,    -8,   -62,    24,  -171,  -512,     1,     0,    18,    64,    10,     0, &
                   18,    64,    10,     0,    18,    -8,   -62,     0,    18,    -8,   -62,     0,   -36,   -80,    28,     0]
  K1( 365,:) = [    24,    -8,     1,    21,  -192,    64,   -71,    21,    -3,     1,    10,    -6,   -30,    10,   -80,    48, &
                   24,    -8,   -62,    -6,    -3,     1,    -8,  -168,     0,    64,    10,    18,     0,  -512,     1,  -171, &
                    0,    -8,   -62,    18,     0,   -80,    28,   -36,     0,    64,    10,    18,     0,    -8,   -62,    18]
  K1( 366,:) = [    64,     0,    24,    64,  -512,     0,  -192,    -8,    -8,     0,    24,    -8,   -80,     0,  -192,    64, &
                   64,     0,  -192,   -80,    -8,     0,  -192,  -512,    64,   192,    48,    64,  -512, -1536,  -168,  -512, &
                   -8,   -24,  -168,    -8,   -80,  -240,    48,   -80,    64,   192,    48,    64,    -8,   -24,  -168,    -8]
  K1( 367,:) = [    10,    -3,     0,    10,   -62,    24,     0,     1,   -62,    -3,     0,   -62,    10,    24,     0,    28, &
                   28,    24,     0,    10,     1,    24,     0,   -62,    10,    48,    30,    10,     1,  -168,     3,     1, &
                  -62,  -168,  -186,   -62,    28,    48,    84,    28,    10,    48,    30,    10,   -62,  -168,  -186,   -62]
  K1( 368,:) = [    21,    -8,     1,    24,  -168,     1,    -8,    -3,    -6,     1,    10,    -3,    -6,    -8,   -62,    24, &
                   48,    10,   -80,   -30,    21,    64,   -71,  -192,    18,    64,    10,     0,  -171,  -512,     1,     0, &
                   18,    -8,   -62,     0,   -36,   -80,    28,     0,    18,    64,    10,     0,    18,    -8,   -62,     0]
  K1( 369,:) = [    24,    -8,   -62,    -6,    -3,     1,    -8,  -168,  -192,    64,   -71,    21,    24,    -8,     1,    21, &
                  -30,    10,   -80,    48,    -3,     1,    10,    -6,     0,    64,    10,    18,     0,    -8,   -62,    18, &
                    0,  -512,     1,  -171,     0,    64,    10,    18,     0,   -80,    28,   -36,     0,    -8,   -62,    18]
  K1( 370,:) = [    64,     0,  -192,   -80,    -8,     0,  -192,  -512,  -512,     0,  -192,    -8,    64,     0,    24,    64, &
                  -80,     0,  -192,    64,    -8,     0,    24,    -8,    64,   192,    48,    64,    -8,   -24,  -168,    -8, &
                 -512, -1536,  -168,  -512,    64,   192,    48,    64,   -80,  -240,    48,   -80,    -8,   -24,  -168,    -8]
  K1( 371,:) = [    28,    24,     0,    10,     1,    24,     0,   -62,   -62,    24,     0,     1,    10,    -3,     0,    10, &
                   10,    24,     0,    28,   -62,    -3,     0,   -62,    10,    48,    30,    10,   -62,  -168,  -186,   -62, &
                    1,  -168,     3,     1,    10,    48,    30,    10,    28,    48,    84,    28,   -62,  -168,  -186,   -62]
  K1( 372,:) = [    48,    10,   -80,   -30,    21,    64,   -71,  -192,  -168,     1,    -8,    -3,    21,    -8,     1,    24, &
                   -6,    -8,   -62,    24,    -6,     1,    10,    -3,    18,    64,    10,     0,    18,    -8,   -62,     0, &
                 -171,  -512,     1,     0,    18,    64,    10,     0,   -36,   -80,    28,     0,    18,    -8,   -62,     0]
  K1( 373,:) = [    -3,     1,    10,    -6,   -30,    10,   -80,    48,    24,    -8,     1,    21,  -192,    64,   -71,    21, &
                   -3,     1,    -8,  -168,    24,    -8,   -62,    -6,     0,    -8,   -62,    18,     0,   -80,    28,   -36, &
                    0,    64,    10,    18,     0,  -512,     1,  -171,     0,    -8,   -62,    18,     0,    64,    10,    18]
  K1( 374,:) = [    -8,     0,    24,    -8,   -80,     0,  -192,    64,    64,     0,    24,    64,  -512,     0,  -192,    -8, &
                   -8,     0,  -192,  -512,    64,     0,  -192,   -80,    -8,   -24,  -168,    -8,   -80,  -240,    48,   -80, &
                   64,   192,    48,    64,  -512, -1536,  -168,  -512,    -8,   -24,  -168,    -8,    64,   192,    48,    64]
  K1( 375,:) = [   -62,    -3,     0,   -62,    10,    24,     0,    28,    10,    -3,     0,    10,   -62,    24,     0,     1, &
                    1,    24,     0,   -62,    28,    24,     0,    10,   -62,  -168,  -186,   -62,    28,    48,    84,    28, &
                   10,    48,    30,    10,     1,  -168,     3,     1,   -62,  -168,  -186,   -62,    10,    48,    30,    10]
  K1( 376,:) = [    -6,     1,    10,    -3,    -6,    -8,   -62,    24,    21,    -8,     1,    24,  -168,     1,    -8,    -3, &
                   21,    64,   -71,  -192,    48,    10,   -80,   -30,    18,    -8,   -62,     0,   -36,   -80,    28,     0, &
                   18,    64,    10,     0,  -171,  -512,     1,     0,    18,    -8,   -62,     0,    18,    64,    10,     0]
  K1( 377,:) = [    -3,     1,    -8,  -168,    24,    -8,   -62,    -6,   -30,    10,   -80,    48,    -3,     1,    10,    -6, &
                 -192,    64,   -71,    21,    24,    -8,     1,    21,     0,    -8,   -62,    18,     0,    64,    10,    18, &
                    0,   -80,    28,   -36,     0,    -8,   -62,    18,     0,  -512,     1,  -171,     0,    64,    10,    18]
  K1( 378,:) = [    -8,     0,  -192,  -512,    64,     0,  -192,   -80,   -80,     0,  -192,    64,    -8,     0,    24,    -8, &
                 -512,     0,  -192,    -8,    64,     0,    24,    64,    -8,   -24,  -168,    -8,    64,   192,    48,    64, &
                  -80,  -240,    48,   -80,    -8,   -24,  -168,    -8,  -512, -1536,  -168,  -512,    64,   192,    48,    64]
  K1( 379,:) = [     1,    24,     0,   -62,    28,    24,     0,    10,    10,    24,     0,    28,   -62,    -3,     0,   -62, &
                  -62,    24,     0,     1,    10,    -3,     0,    10,   -62,  -168,  -186,   -62,    10,    48,    30,    10, &
                   28,    48,    84,    28,   -62,  -168,  -186,   -62,     1,  -168,     3,     1,    10,    48,    30,    10]
  K1( 380,:) = [    21,    64,   -71,  -192,    48,    10,   -80,   -30,    -6,    -8,   -62,    24,    -6,     1,    10,    -3, &
                 -168,     1,    -8,    -3,    21,    -8,     1,    24,    18,    -8,   -62,     0,    18,    64,    10,     0, &
                  -36,   -80,    28,     0,    18,    -8,   -62,     0,  -171,  -512,     1,     0,    18,    64,    10,     0]
  K1( 381,:) = [   -30,    10,   -80,    48,    -3,     1,    10,    -6,    -3,     1,    -8,  -168,    24,    -8,   -62,    -6, &
                   24,    -8,     1,    21,  -192,    64,   -71,    21,     0,   -80,    28,   -36,     0,    -8,   -62,    18, &
                    0,    -8,   -62,    18,     0,    64,    10,    18,     0,    64,    10,    18,     0,  -512,     1,  -171]
  K1( 382,:) = [   -80,     0,  -192,    64,    -8,     0,    24,    -8,    -8,     0,  -192,  -512,    64,     0,  -192,   -80, &
                   64,     0,    24,    64,  -512,     0,  -192,    -8,   -80,  -240,    48,   -80,    -8,   -24,  -168,    -8, &
                   -8,   -24,  -168,    -8,    64,   192,    48,    64,    64,   192,    48,    64,  -512, -1536,  -168,  -512]
  K1( 383,:) = [    10,    24,     0,    28,   -62,    -3,     0,   -62,     1,    24,     0,   -62,    28,    24,     0,    10, &
                   10,    -3,     0,    10,   -62,    24,     0,     1,    28,    48,    84,    28,   -62,  -168,  -186,   -62, &
                  -62,  -168,  -186,   -62,    10,    48,    30,    10,    10,    48,    30,    10,     1,  -168,     3,     1]
  K1( 384,:) = [    -6,    -8,   -62,    24,    -6,     1,    10,    -3,    21,    64,   -71,  -192,    48,    10,   -80,   -30, &
                   21,    -8,     1,    24,  -168,     1,    -8,    -3,   -36,   -80,    28,     0,    18,    -8,   -62,     0, &
                   18,    -8,   -62,     0,    18,    64,    10,     0,    18,    64,    10,     0,  -171,  -512,     1,     0]
  K1( 385,:) = [   192,    64,    64,    21,    24,    64,     1,     0,   -24,    -8,    -8,    -6,    -3,    -8,    -8,     0, &
                   -3,    -8,    -8,     0,    24,     1,    64,     0,     0,    64,     1,    24,     0,    -8,    -8,    -3, &
                    0,    -8,    10,    24,     0,     1,     1,    -3,     0,     1,    64,    24,     0,    10,    -8,    24]
  K1( 386,:) = [    64,     0,    18,    -8,    64,    48,    24,    10,    -8,     0,   -36,   -80,    -8,    -6,  -192,   -80, &
                   -8,    -6,    -3,     1,     1,    -6,    24,    -8,  -512,  -192,  -168,   -62,    64,    24,    21,    10, &
                   64,    24,    48,    28,    -8,    -3,    -6,   -62,    -8,    -3,    21,     1,   -80,   -30,    -6,    10]
  K1( 387,:) = [    64,    18,     0,    -8,     1,    24,    -6,    -8,    -8,   -36,     0,   -80,    -8,    -3,    -6,     1, &
                   -8,  -192,    -6,   -80,    64,    24,    48,    10,    -8,    21,    -3,     1,    64,    21,    24,    10, &
                  -80,    -6,   -30,    10,    -8,    -6,    -3,   -62,  -512,  -168,  -192,   -62,    64,    48,    24,    28]
  K1( 388,:) = [    21,    -8,    -8,   -24,     0,    10,    -8,    -3,    -6,   -80,   -80,  -240,     0,     1,   -80,   -30, &
                    0,   -80,     1,   -30,     0,    -8,    10,    -3,  -192,   -71,    -8,     0,    24,     1,     1,     0, &
                 -192,   -62,   -80,     0,    24,    10,    10,     0,  -192,    -8,   -71,     0,  -192,   -80,   -62,     0]
  K1( 389,:) = [    24,    64,     1,     0,   192,    64,    64,    21,    -3,    -8,    -8,     0,    24,     1,    64,     0, &
                  -24,    -8,    -8,    -6,    -3,    -8,    -8,     0,     0,    -8,    -8,    -3,     0,    64,     1,    24, &
                    0,     1,    64,    24,     0,    10,    -8,    24,     0,    -8,    10,    24,     0,     1,     1,    -3]
  K1( 390,:) = [    64,    48,    24,    10,    64,     0,    18,    -8,    -8,    -6,    -3,     1,     1,    -6,    24,    -8, &
                   -8,     0,   -36,   -80,    -8,    -6,  -192,   -80,    64,    24,    21,    10,  -512,  -192,  -168,   -62, &
                   -8,    -3,    21,     1,   -80,   -30,    -6,    10,    64,    24,    48,    28,    -8,    -3,    -6,   -62]
  K1( 391,:) = [     1,    24,    -6,    -8,    64,    18,     0,    -8,    -8,  -192,    -6,   -80,    64,    24,    48,    10, &
                   -8,   -36,     0,   -80,    -8,    -3,    -6,     1,    64,    21,    24,    10,    -8,    21,    -3,     1, &
                 -512,  -168,  -192,   -62,    64,    48,    24,    28,   -80,    -6,   -30,    10,    -8,    -6,    -3,   -62]
  K1( 392,:) = [     0,    10,    -8,    -3,    21,    -8,    -8,   -24,     0,   -80,     1,   -30,     0,    -8,    10,    -3, &
                   -6,   -80,   -80,  -240,     0,     1,   -80,   -30,    24,     1,     1,     0,  -192,   -71,    -8,     0, &
                 -192,    -8,   -71,     0,  -192,   -80,   -62,     0,  -192,   -62,   -80,     0,    24,    10,    10,     0]
  K1( 393,:) = [   -24,    -8,    -8,    -6,    -3,    -8,    -8,     0,   192,    64,    64,    21,    24,    64,     1,     0, &
                   24,     1,    64,     0,    -3,    -8,    -8,     0,     0,    -8,    10,    24,     0,     1,     1,    -3, &
                    0,    64,     1,    24,     0,    -8,    -8,    -3,     0,    10,    -8,    24,     0,     1,    64,    24]
  K1( 394,:) = [    -8,     0,   -36,   -80,    -8,    -6,  -192,   -80,    64,     0,    18,    -8,    64,    48,    24,    10, &
                    1,    -6,    24,    -8,    -8,    -6,    -3,     1,    64,    24,    48,    28,    -8,    -3,    -6,   -62, &
                 -512,  -192,  -168,   -62,    64,    24,    21,    10,   -80,   -30,    -6,    10,    -8,    -3,    21,     1]
  K1( 395,:) = [    -8,   -36,     0,   -80,    -8,    -3,    -6,     1,    64,    18,     0,    -8,     1,    24,    -6,    -8, &
                   64,    24,    48,    10,    -8,  -192,    -6,   -80,   -80,    -6,   -30,    10,    -8,    -6,    -3,   -62, &
                   -8,    21,    -3,     1,    64,    21,    24,    10,    64,    48,    24,    28,  -512,  -168,  -192,   -62]
  K1( 396,:) = [    -6,   -80,   -80,  -240,     0,     1,   -80,   -30,    21,    -8,    -8,   -24,     0,    10,    -8,    -3, &
                    0,    -8,    10,    -3,     0,   -80,     1,   -30,  -192,   -62,   -80,     0,    24,    10,    10,     0, &
                 -192,   -71,    -8,     0,    24,     1,     1,     0,  -192,   -80,   -62,     0,  -192,    -8,   -71,     0]
  K1( 397,:) = [    -3,    -8,    -8,     0,    24,     1,    64,     0,    24,    64,     1,     0,   192,    64,    64,    21, &
                   -3,    -8,    -8,     0,   -24,    -8,    -8,    -6,     0,     1,    64,    24,     0,    10,    -8,    24, &
                    0,    -8,    -8,    -3,     0,    64,     1,    24,     0,     1,     1,    -3,     0,    -8,    10,    24]
  K1( 398,:) = [    -8,    -6,    -3,     1,     1,    -6,    24,    -8,    64,    48,    24,    10,    64,     0,    18,    -8, &
                   -8,    -6,  -192,   -80,    -8,     0,   -36,   -80,    -8,    -3,    21,     1,   -80,   -30,    -6,    10, &
                   64,    24,    21,    10,  -512,  -192,  -168,   -62,    -8,    -3,    -6,   -62,    64,    24,    48,    28]
  K1( 399,:) = [    -8,  -192,    -6,   -80,    64,    24,    48,    10,     1,    24,    -6,    -8,    64,    18,     0,    -8, &
                   -8,    -3,    -6,     1,    -8,   -36,     0,   -80,  -512,  -168,  -192,   -62,    64,    48,    24,    28, &
                   64,    21,    24,    10,    -8,    21,    -3,     1,    -8,    -6,    -3,   -62,   -80,    -6,   -30,    10]
  K1( 400,:) = [     0,   -80,     1,   -30,     0,    -8,    10,    -3,     0,    10,    -8,    -3,    21,    -8,    -8,   -24, &
                    0,     1,   -80,   -30,    -6,   -80,   -80,  -240,  -192,    -8,   -71,     0,  -192,   -80,   -62,     0, &
                   24,     1,     1,     0,  -192,   -71,    -8,     0,    24,    10,    10,     0,  -192,   -62,   -80,     0]
  K1( 401,:) = [    -3,    -8,    -8,     0,   -24,    -8,    -8,    -6,    24,     1,    64,     0,    -3,    -8,    -8,     0, &
                  192,    64,    64,    21,    24,    64,     1,     0,     0,     1,     1,    -3,     0,    -8,    10,    24, &
                    0,    10,    -8,    24,     0,     1,    64,    24,     0,    64,     1,    24,     0,    -8,    -8,    -3]
  K1( 402,:) = [    -8,    -6,  -192,   -80,    -8,     0,   -36,   -80,     1,    -6,    24,    -8,    -8,    -6,    -3,     1, &
                   64,     0,    18,    -8,    64,    48,    24,    10,    -8,    -3,    -6,   -62,    64,    24,    48,    28, &
                  -80,   -30,    -6,    10,    -8,    -3,    21,     1,  -512,  -192,  -168,   -62,    64,    24,    21,    10]
  K1( 403,:) = [    -8,    -3,    -6,     1,    -8,   -36,     0,   -80,    64,    24,    48,    10,    -8,  -192,    -6,   -80, &
                   64,    18,     0,    -8,     1,    24,    -6,    -8,    -8,    -6,    -3,   -62,   -80,    -6,   -30,    10, &
                   64,    48,    24,    28,  -512,  -168,  -192,   -62,    -8,    21,    -3,     1,    64,    21,    24,    10]
  K1( 404,:) = [     0,     1,   -80,   -30,    -6,   -80,   -80,  -240,     0,    -8,    10,    -3,     0,   -80,     1,   -30, &
                   21,    -8,    -8,   -24,     0,    10,    -8,    -3,    24,    10,    10,     0,  -192,   -62,   -80,     0, &
                 -192,   -80,   -62,     0,  -192,    -8,   -71,     0,  -192,   -71,    -8,     0,    24,     1,     1,     0]
  K1( 405,:) = [    24,     1,    64,     0,    -3,    -8,    -8,     0,    -3,    -8,    -8,     0,   -24,    -8,    -8,    -6, &
                   24,    64,     1,     0,   192,    64,    64,    21,     0,    10,    -8,    24,     0,     1,    64,    24, &
                    0,     1,     1,    -3,     0,    -8,    10,    24,     0,    -8,    -8,    -3,     0,    64,     1,    24]
  K1( 406,:) = [     1,    -6,    24,    -8,    -8,    -6,    -3,     1,    -8,    -6,  -192,   -80,    -8,     0,   -36,   -80, &
                   64,    48,    24,    10,    64,     0,    18,    -8,   -80,   -30,    -6,    10,    -8,    -3,    21,     1, &
                   -8,    -3,    -6,   -62,    64,    24,    48,    28,    64,    24,    21,    10,  -512,  -192,  -168,   -62]
  K1( 407,:) = [    64,    24,    48,    10,    -8,  -192,    -6,   -80,    -8,    -3,    -6,     1,    -8,   -36,     0,   -80, &
                    1,    24,    -6,    -8,    64,    18,     0,    -8,    64,    48,    24,    28,  -512,  -168,  -192,   -62, &
                   -8,    -6,    -3,   -62,   -80,    -6,   -30,    10,    64,    21,    24,    10,    -8,    21,    -3,     1]
  K1( 408,:) = [     0,    -8,    10,    -3,     0,   -80,     1,   -30,     0,     1,   -80,   -30,    -6,   -80,   -80,  -240, &
                    0,    10,    -8,    -3,    21,    -8,    -8,   -24,  -192,   -80,   -62,     0,  -192,    -8,   -71,     0, &
                   24,    10,    10,     0,  -192,   -62,   -80,     0,    24,     1,     1,     0,  -192,   -71,    -8,     0]
  K1( 409,:) = [     0,  -512,    -8,  -192,     0,    64,    64,    24,     0,    64,   -80,  -192,     0,    -8,  -512,  -192, &
                    0,    -8,    -8,    24,     0,   -80,    64,  -192, -1536,  -512,  -512,  -168,   192,    64,    64,    48, &
                  192,    64,    64,    48,   -24,    -8,    -8,  -168,   -24,    -8,    -8,  -168,  -240,   -80,   -80,    48]
  K1( 410,:) = [    64,  -192,    21,   -71,    -8,    24,    21,     1,    -8,    24,    -6,   -62,     1,    -3,  -168,    -8, &
                    1,    -3,    -6,    10,    10,   -30,    48,   -80,  -512,     0,  -171,     1,    64,     0,    18,    10, &
                   64,     0,    18,    10,    -8,     0,    18,   -62,    -8,     0,    18,   -62,   -80,     0,   -36,    28]
  K1( 411,:) = [     1,  -168,    -3,    -8,    -8,    21,    24,     1,    10,    48,   -30,   -80,    64,    21,  -192,   -71, &
                    1,    -6,    -3,    10,    -8,    -6,    24,   -62,  -512,  -171,     0,     1,    64,    18,     0,    10, &
                   64,    18,     0,    10,    -8,    18,     0,   -62,    -8,    18,     0,   -62,   -80,   -36,     0,    28]
  K1( 412,:) = [    24,   -62,     1,     0,    -3,    10,    10,     0,    24,    28,    10,     0,    24,     1,   -62,     0, &
                   -3,   -62,   -62,     0,    24,    10,    28,     0,  -168,     1,     1,     3,    48,    10,    10,    30, &
                   48,    10,    10,    30,  -168,   -62,   -62,  -186,  -168,   -62,   -62,  -186,    48,    28,    28,    84]
  K1( 413,:) = [     0,    64,    64,    24,     0,  -512,    -8,  -192,     0,    -8,    -8,    24,     0,   -80,    64,  -192, &
                    0,    64,   -80,  -192,     0,    -8,  -512,  -192,   192,    64,    64,    48, -1536,  -512,  -512,  -168, &
                  -24,    -8,    -8,  -168,  -240,   -80,   -80,    48,   192,    64,    64,    48,   -24,    -8,    -8,  -168]
  K1( 414,:) = [    -8,    24,    21,     1,    64,  -192,    21,   -71,     1,    -3,    -6,    10,    10,   -30,    48,   -80, &
                   -8,    24,    -6,   -62,     1,    -3,  -168,    -8,    64,     0,    18,    10,  -512,     0,  -171,     1, &
                   -8,     0,    18,   -62,   -80,     0,   -36,    28,    64,     0,    18,    10,    -8,     0,    18,   -62]
  K1( 415,:) = [    -8,    21,    24,     1,     1,  -168,    -3,    -8,     1,    -6,    -3,    10,    -8,    -6,    24,   -62, &
                   10,    48,   -30,   -80,    64,    21,  -192,   -71,    64,    18,     0,    10,  -512,  -171,     0,     1, &
                   -8,    18,     0,   -62,   -80,   -36,     0,    28,    64,    18,     0,    10,    -8,    18,     0,   -62]
  K1( 416,:) = [    -3,    10,    10,     0,    24,   -62,     1,     0,    -3,   -62,   -62,     0,    24,    10,    28,     0, &
                   24,    28,    10,     0,    24,     1,   -62,     0,    48,    10,    10,    30,  -168,     1,     1,     3, &
                 -168,   -62,   -62,  -186,    48,    28,    28,    84,    48,    10,    10,    30,  -168,   -62,   -62,  -186]
  K1( 417,:) = [     0,    64,   -80,  -192,     0,    -8,  -512,  -192,     0,  -512,    -8,  -192,     0,    64,    64,    24, &
                    0,   -80,    64,  -192,     0,    -8,    -8,    24,   192,    64,    64,    48,   -24,    -8,    -8,  -168, &
                -1536,  -512,  -512,  -168,   192,    64,    64,    48,  -240,   -80,   -80,    48,   -24,    -8,    -8,  -168]
  K1( 418,:) = [    -8,    24,    -6,   -62,     1,    -3,  -168,    -8,    64,  -192,    21,   -71,    -8,    24,    21,     1, &
                   10,   -30,    48,   -80,     1,    -3,    -6,    10,    64,     0,    18,    10,    -8,     0,    18,   -62, &
                 -512,     0,  -171,     1,    64,     0,    18,    10,   -80,     0,   -36,    28,    -8,     0,    18,   -62]
  K1( 419,:) = [    10,    48,   -30,   -80,    64,    21,  -192,   -71,     1,  -168,    -3,    -8,    -8,    21,    24,     1, &
                   -8,    -6,    24,   -62,     1,    -6,    -3,    10,    64,    18,     0,    10,    -8,    18,     0,   -62, &
                 -512,  -171,     0,     1,    64,    18,     0,    10,   -80,   -36,     0,    28,    -8,    18,     0,   -62]
  K1( 420,:) = [    24,    28,    10,     0,    24,     1,   -62,     0,    24,   -62,     1,     0,    -3,    10,    10,     0, &
                   24,    10,    28,     0,    -3,   -62,   -62,     0,    48,    10,    10,    30,  -168,   -62,   -62,  -186, &
                 -168,     1,     1,     3,    48,    10,    10,    30,    48,    28,    28,    84,  -168,   -62,   -62,  -186]
  K1( 421,:) = [     0,    -8,    -8,    24,     0,   -80,    64,  -192,     0,    64,    64,    24,     0,  -512,    -8,  -192, &
                    0,    -8,  -512,  -192,     0,    64,   -80,  -192,   -24,    -8,    -8,  -168,  -240,   -80,   -80,    48, &
                  192,    64,    64,    48, -1536,  -512,  -512,  -168,   -24,    -8,    -8,  -168,   192,    64,    64,    48]
  K1( 422,:) = [     1,    -3,    -6,    10,    10,   -30,    48,   -80,    -8,    24,    21,     1,    64,  -192,    21,   -71, &
                    1,    -3,  -168,    -8,    -8,    24,    -6,   -62,    -8,     0,    18,   -62,   -80,     0,   -36,    28, &
                   64,     0,    18,    10,  -512,     0,  -171,     1,    -8,     0,    18,   -62,    64,     0,    18,    10]
  K1( 423,:) = [     1,    -6,    -3,    10,    -8,    -6,    24,   -62,    -8,    21,    24,     1,     1,  -168,    -3,    -8, &
                   64,    21,  -192,   -71,    10,    48,   -30,   -80,    -8,    18,     0,   -62,   -80,   -36,     0,    28, &
                   64,    18,     0,    10,  -512,  -171,     0,     1,    -8,    18,     0,   -62,    64,    18,     0,    10]
  K1( 424,:) = [    -3,   -62,   -62,     0,    24,    10,    28,     0,    -3,    10,    10,     0,    24,   -62,     1,     0, &
                   24,     1,   -62,     0,    24,    28,    10,     0,  -168,   -62,   -62,  -186,    48,    28,    28,    84, &
                   48,    10,    10,    30,  -168,     1,     1,     3,  -168,   -62,   -62,  -186,    48,    10,    10,    30]
  K1( 425,:) = [     0,    -8,  -512,  -192,     0,    64,   -80,  -192,     0,   -80,    64,  -192,     0,    -8,    -8,    24, &
                    0,  -512,    -8,  -192,     0,    64,    64,    24,   -24,    -8,    -8,  -168,   192,    64,    64,    48, &
                 -240,   -80,   -80,    48,   -24,    -8,    -8,  -168, -1536,  -512,  -512,  -168,   192,    64,    64,    48]
  K1( 426,:) = [     1,    -3,  -168,    -8,    -8,    24,    -6,   -62,    10,   -30,    48,   -80,     1,    -3,    -6,    10, &
                   64,  -192,    21,   -71,    -8,    24,    21,     1,    -8,     0,    18,   -62,    64,     0,    18,    10, &
                  -80,     0,   -36,    28,    -8,     0,    18,   -62,  -512,     0,  -171,     1,    64,     0,    18,    10]
  K1( 427,:) = [    64,    21,  -192,   -71,    10,    48,   -30,   -80,    -8,    -6,    24,   -62,     1,    -6,    -3,    10, &
                    1,  -168,    -3,    -8,    -8,    21,    24,     1,    -8,    18,     0,   -62,    64,    18,     0,    10, &
                  -80,   -36,     0,    28,    -8,    18,     0,   -62,  -512,  -171,     0,     1,    64,    18,     0,    10]
  K1( 428,:) = [    24,     1,   -62,     0,    24,    28,    10,     0,    24,    10,    28,     0,    -3,   -62,   -62,     0, &
                   24,   -62,     1,     0,    -3,    10,    10,     0,  -168,   -62,   -62,  -186,    48,    10,    10,    30, &
                   48,    28,    28,    84,  -168,   -62,   -62,  -186,  -168,     1,     1,     3,    48,    10,    10,    30]
  K1( 429,:) = [     0,   -80,    64,  -192,     0,    -8,    -8,    24,     0,    -8,  -512,  -192,     0,    64,   -80,  -192, &
                    0,    64,    64,    24,     0,  -512,    -8,  -192,  -240,   -80,   -80,    48,   -24,    -8,    -8,  -168, &
                  -24,    -8,    -8,  -168,   192,    64,    64,    48,   192,    64,    64,    48, -1536,  -512,  -512,  -168]
  K1( 430,:) = [    10,   -30,    48,   -80,     1,    -3,    -6,    10,     1,    -3,  -168,    -8,    -8,    24,    -6,   -62, &
                   -8,    24,    21,     1,    64,  -192,    21,   -71,   -80,     0,   -36,    28,    -8,     0,    18,   -62, &
                   -8,     0,    18,   -62,    64,     0,    18,    10,    64,     0,    18,    10,  -512,     0,  -171,     1]
  K1( 431,:) = [    -8,    -6,    24,   -62,     1,    -6,    -3,    10,    64,    21,  -192,   -71,    10,    48,   -30,   -80, &
                   -8,    21,    24,     1,     1,  -168,    -3,    -8,   -80,   -36,     0,    28,    -8,    18,     0,   -62, &
                   -8,    18,     0,   -62,    64,    18,     0,    10,    64,    18,     0,    10,  -512,  -171,     0,     1]
  K1( 432,:) = [    24,    10,    28,     0,    -3,   -62,   -62,     0,    24,     1,   -62,     0,    24,    28,    10,     0, &
                   -3,    10,    10,     0,    24,   -62,     1,     0,    48,    28,    28,    84,  -168,   -62,   -62,  -186, &
                 -168,   -62,   -62,  -186,    48,    10,    10,    30,    48,    10,    10,    30,  -168,     1,     1,     3]
  K1( 433,:) = [     0,    -1,   512,   171,   -21,   -64,    71,   192,     0,   -10,   -64,   -18,   -21,     8,    -1,   -24, &
                  -21,     8,    -1,   -24,   168,    -1,     8,     3,     3,     8,    -1,   168,   -24,    -1,     8,   -21, &
                   30,    80,   -10,   -48,     3,   -10,    -1,     6,   192,    71,   -64,   -21,   -24,    62,     8,     6]
  K1( 434,:) = [    -1,     0,   171,   512,   -64,   -21,   192,    71,   -10,     0,   -18,   -64,     8,   -21,   -24,    -1, &
                    8,   -21,   -24,    -1,    -1,   168,     3,     8,     8,     3,   168,    -1,    -1,   -24,   -21,     8, &
                   80,    30,   -48,   -10,   -10,     3,     6,    -1,    71,   192,   -21,   -64,    62,   -24,     6,     8]
  K1( 435,:) = [   512,   171,     0,    -1,    71,   192,   -21,   -64,   -64,   -18,     0,   -10,    -1,   -24,   -21,     8, &
                   -1,   -24,   -21,     8,     8,     3,   168,    -1,    -1,   168,     3,     8,     8,   -21,   -24,    -1, &
                  -10,   -48,    30,    80,    -1,     6,     3,   -10,   -64,   -21,   192,    71,     8,     6,   -24,    62]
  K1( 436,:) = [   171,   512,    -1,     0,   192,    71,   -64,   -21,   -18,   -64,   -10,     0,   -24,    -1,     8,   -21, &
                  -24,    -1,     8,   -21,     3,     8,    -1,   168,   168,    -1,     8,     3,   -21,     8,    -1,   -24, &
                  -48,   -10,    80,    30,     6,    -1,   -10,     3,   -21,   -64,    71,   192,     6,     8,    62,   -24]
  K1( 437,:) = [   -21,   -64,    71,   192,     0,    -1,   512,   171,   -21,     8,    -1,   -24,   168,    -1,     8,     3, &
                    0,   -10,   -64,   -18,   -21,     8,    -1,   -24,   -24,    -1,     8,   -21,     3,     8,    -1,   168, &
                  192,    71,   -64,   -21,   -24,    62,     8,     6,    30,    80,   -10,   -48,     3,   -10,    -1,     6]
  K1( 438,:) = [   -64,   -21,   192,    71,    -1,     0,   171,   512,     8,   -21,   -24,    -1,    -1,   168,     3,     8, &
                  -10,     0,   -18,   -64,     8,   -21,   -24,    -1,    -1,   -24,   -21,     8,     8,     3,   168,    -1, &
                   71,   192,   -21,   -64,    62,   -24,     6,     8,    80,    30,   -48,   -10,   -10,     3,     6,    -1]
  K1( 439,:) = [    71,   192,   -21,   -64,   512,   171,     0,    -1,    -1,   -24,   -21,     8,     8,     3,   168,    -1, &
                  -64,   -18,     0,   -10,    -1,   -24,   -21,     8,     8,   -21,   -24,    -1,    -1,   168,     3,     8, &
                  -64,   -21,   192,    71,     8,     6,   -24,    62,   -10,   -48,    30,    80,    -1,     6,     3,   -10]
  K1( 440,:) = [   192,    71,   -64,   -21,   171,   512,    -1,     0,   -24,    -1,     8,   -21,     3,     8,    -1,   168, &
                  -18,   -64,   -10,     0,   -24,    -1,     8,   -21,   -21,     8,    -1,   -24,   168,    -1,     8,     3, &
                  -21,   -64,    71,   192,     6,     8,    62,   -24,   -48,   -10,    80,    30,     6,    -1,   -10,     3]
  K1( 441,:) = [     0,   -10,   -64,   -18,   -21,     8,    -1,   -24,     0,    -1,   512,   171,   -21,   -64,    71,   192, &
                  168,    -1,     8,     3,   -21,     8,    -1,   -24,    30,    80,   -10,   -48,     3,   -10,    -1,     6, &
                    3,     8,    -1,   168,   -24,    -1,     8,   -21,   -24,    62,     8,     6,   192,    71,   -64,   -21]
  K1( 442,:) = [   -10,     0,   -18,   -64,     8,   -21,   -24,    -1,    -1,     0,   171,   512,   -64,   -21,   192,    71, &
                   -1,   168,     3,     8,     8,   -21,   -24,    -1,    80,    30,   -48,   -10,   -10,     3,     6,    -1, &
                    8,     3,   168,    -1,    -1,   -24,   -21,     8,    62,   -24,     6,     8,    71,   192,   -21,   -64]
  K1( 443,:) = [   -64,   -18,     0,   -10,    -1,   -24,   -21,     8,   512,   171,     0,    -1,    71,   192,   -21,   -64, &
                    8,     3,   168,    -1,    -1,   -24,   -21,     8,   -10,   -48,    30,    80,    -1,     6,     3,   -10, &
                   -1,   168,     3,     8,     8,   -21,   -24,    -1,     8,     6,   -24,    62,   -64,   -21,   192,    71]
  K1( 444,:) = [   -18,   -64,   -10,     0,   -24,    -1,     8,   -21,   171,   512,    -1,     0,   192,    71,   -64,   -21, &
                    3,     8,    -1,   168,   -24,    -1,     8,   -21,   -48,   -10,    80,    30,     6,    -1,   -10,     3, &
                  168,    -1,     8,     3,   -21,     8,    -1,   -24,     6,     8,    62,   -24,   -21,   -64,    71,   192]
  K1( 445,:) = [   -21,     8,    -1,   -24,   168,    -1,     8,     3,   -21,   -64,    71,   192,     0,    -1,   512,   171, &
                  -21,     8,    -1,   -24,     0,   -10,   -64,   -18,   192,    71,   -64,   -21,   -24,    62,     8,     6, &
                  -24,    -1,     8,   -21,     3,     8,    -1,   168,     3,   -10,    -1,     6,    30,    80,   -10,   -48]
  K1( 446,:) = [     8,   -21,   -24,    -1,    -1,   168,     3,     8,   -64,   -21,   192,    71,    -1,     0,   171,   512, &
                    8,   -21,   -24,    -1,   -10,     0,   -18,   -64,    71,   192,   -21,   -64,    62,   -24,     6,     8, &
                   -1,   -24,   -21,     8,     8,     3,   168,    -1,   -10,     3,     6,    -1,    80,    30,   -48,   -10]
  K1( 447,:) = [    -1,   -24,   -21,     8,     8,     3,   168,    -1,    71,   192,   -21,   -64,   512,   171,     0,    -1, &
                   -1,   -24,   -21,     8,   -64,   -18,     0,   -10,   -64,   -21,   192,    71,     8,     6,   -24,    62, &
                    8,   -21,   -24,    -1,    -1,   168,     3,     8,    -1,     6,     3,   -10,   -10,   -48,    30,    80]
  K1( 448,:) = [   -24,    -1,     8,   -21,     3,     8,    -1,   168,   192,    71,   -64,   -21,   171,   512,    -1,     0, &
                  -24,    -1,     8,   -21,   -18,   -64,   -10,     0,   -21,   -64,    71,   192,     6,     8,    62,   -24, &
                  -21,     8,    -1,   -24,   168,    -1,     8,     3,     6,    -1,   -10,     3,   -48,   -10,    80,    30]
  K1( 449,:) = [   -21,     8,    -1,   -24,     0,   -10,   -64,   -18,   168,    -1,     8,     3,   -21,     8,    -1,   -24, &
                    0,    -1,   512,   171,   -21,   -64,    71,   192,     3,   -10,    -1,     6,    30,    80,   -10,   -48, &
                  -24,    62,     8,     6,   192,    71,   -64,   -21,     3,     8,    -1,   168,   -24,    -1,     8,   -21]
  K1( 450,:) = [     8,   -21,   -24,    -1,   -10,     0,   -18,   -64,    -1,   168,     3,     8,     8,   -21,   -24,    -1, &
                   -1,     0,   171,   512,   -64,   -21,   192,    71,   -10,     3,     6,    -1,    80,    30,   -48,   -10, &
                   62,   -24,     6,     8,    71,   192,   -21,   -64,     8,     3,   168,    -1,    -1,   -24,   -21,     8]
  K1( 451,:) = [    -1,   -24,   -21,     8,   -64,   -18,     0,   -10,     8,     3,   168,    -1,    -1,   -24,   -21,     8, &
                  512,   171,     0,    -1,    71,   192,   -21,   -64,    -1,     6,     3,   -10,   -10,   -48,    30,    80, &
                    8,     6,   -24,    62,   -64,   -21,   192,    71,    -1,   168,     3,     8,     8,   -21,   -24,    -1]
  K1( 452,:) = [   -24,    -1,     8,   -21,   -18,   -64,   -10,     0,     3,     8,    -1,   168,   -24,    -1,     8,   -21, &
                  171,   512,    -1,     0,   192,    71,   -64,   -21,     6,    -1,   -10,     3,   -48,   -10,    80,    30, &
                    6,     8,    62,   -24,   -21,   -64,    71,   192,   168,    -1,     8,     3,   -21,     8,    -1,   -24]
  K1( 453,:) = [   168,    -1,     8,     3,   -21,     8,    -1,   -24,   -21,     8,    -1,   -24,     0,   -10,   -64,   -18, &
                  -21,   -64,    71,   192,     0,    -1,   512,   171,   -24,    62,     8,     6,   192,    71,   -64,   -21, &
                    3,   -10,    -1,     6,    30,    80,   -10,   -48,   -24,    -1,     8,   -21,     3,     8,    -1,   168]
  K1( 454,:) = [    -1,   168,     3,     8,     8,   -21,   -24,    -1,     8,   -21,   -24,    -1,   -10,     0,   -18,   -64, &
                  -64,   -21,   192,    71,    -1,     0,   171,   512,    62,   -24,     6,     8,    71,   192,   -21,   -64, &
                  -10,     3,     6,    -1,    80,    30,   -48,   -10,    -1,   -24,   -21,     8,     8,     3,   168,    -1]
  K1( 455,:) = [     8,     3,   168,    -1,    -1,   -24,   -21,     8,    -1,   -24,   -21,     8,   -64,   -18,     0,   -10, &
                   71,   192,   -21,   -64,   512,   171,     0,    -1,     8,     6,   -24,    62,   -64,   -21,   192,    71, &
                   -1,     6,     3,   -10,   -10,   -48,    30,    80,     8,   -21,   -24,    -1,    -1,   168,     3,     8]
  K1( 456,:) = [     3,     8,    -1,   168,   -24,    -1,     8,   -21,   -24,    -1,     8,   -21,   -18,   -64,   -10,     0, &
                  192,    71,   -64,   -21,   171,   512,    -1,     0,     6,     8,    62,   -24,   -21,   -64,    71,   192, &
                    6,    -1,   -10,     3,   -48,   -10,    80,    30,   -21,     8,    -1,   -24,   168,    -1,     8,     3]
  K1( 457,:) = [     3,     8,    -1,   168,   -24,    -1,     8,   -21,    30,    80,   -10,   -48,   192,    71,   -64,   -21, &
                    3,   -10,    -1,     6,   -24,    62,     8,     6,     0,    -1,   512,   171,     0,   -10,   -64,   -18, &
                    0,   -10,   -64,   -18,     0,    62,     8,   -18,     0,    62,     8,   -18,     0,   -28,    80,    36]
  K1( 458,:) = [     8,     3,   168,    -1,    -1,   -24,   -21,     8,    80,    30,   -48,   -10,    71,   192,   -21,   -64, &
                  -10,     3,     6,    -1,    62,   -24,     6,     8,    -1,     0,   171,   512,   -10,     0,   -18,   -64, &
                  -10,     0,   -18,   -64,    62,     0,   -18,     8,    62,     0,   -18,     8,   -28,     0,    36,    80]
  K1( 459,:) = [    -1,   168,     3,     8,     8,   -21,   -24,    -1,   -10,   -48,    30,    80,   -64,   -21,   192,    71, &
                   -1,     6,     3,   -10,     8,     6,   -24,    62,   512,   171,     0,    -1,   -64,   -18,     0,   -10, &
                  -64,   -18,     0,   -10,     8,   -18,     0,    62,     8,   -18,     0,    62,    80,    36,     0,   -28]
  K1( 460,:) = [   168,    -1,     8,     3,   -21,     8,    -1,   -24,   -48,   -10,    80,    30,   -21,   -64,    71,   192, &
                    6,    -1,   -10,     3,     6,     8,    62,   -24,   171,   512,    -1,     0,   -18,   -64,   -10,     0, &
                  -18,   -64,   -10,     0,   -18,     8,    62,     0,   -18,     8,    62,     0,    36,    80,   -28,     0]
  K1( 461,:) = [   -24,    -1,     8,   -21,     3,     8,    -1,   168,     3,   -10,    -1,     6,   -24,    62,     8,     6, &
                   30,    80,   -10,   -48,   192,    71,   -64,   -21,     0,   -10,   -64,   -18,     0,    -1,   512,   171, &
                    0,    62,     8,   -18,     0,   -28,    80,    36,     0,   -10,   -64,   -18,     0,    62,     8,   -18]
  K1( 462,:) = [    -1,   -24,   -21,     8,     8,     3,   168,    -1,   -10,     3,     6,    -1,    62,   -24,     6,     8, &
                   80,    30,   -48,   -10,    71,   192,   -21,   -64,   -10,     0,   -18,   -64,    -1,     0,   171,   512, &
                   62,     0,   -18,     8,   -28,     0,    36,    80,   -10,     0,   -18,   -64,    62,     0,   -18,     8]
  K1( 463,:) = [     8,   -21,   -24,    -1,    -1,   168,     3,     8,    -1,     6,     3,   -10,     8,     6,   -24,    62, &
                  -10,   -48,    30,    80,   -64,   -21,   192,    71,   -64,   -18,     0,   -10,   512,   171,     0,    -1, &
                    8,   -18,     0,    62,    80,    36,     0,   -28,   -64,   -18,     0,   -10,     8,   -18,     0,    62]
  K1( 464,:) = [   -21,     8,    -1,   -24,   168,    -1,     8,     3,     6,    -1,   -10,     3,     6,     8,    62,   -24, &
                  -48,   -10,    80,    30,   -21,   -64,    71,   192,   -18,   -64,   -10,     0,   171,   512,    -1,     0, &
                  -18,     8,    62,     0,    36,    80,   -28,     0,   -18,   -64,   -10,     0,   -18,     8,    62,     0]
  K1( 465,:) = [    30,    80,   -10,   -48,   192,    71,   -64,   -21,     3,     8,    -1,   168,   -24,    -1,     8,   -21, &
                  -24,    62,     8,     6,     3,   -10,    -1,     6,     0,   -10,   -64,   -18,     0,    62,     8,   -18, &
                    0,    -1,   512,   171,     0,   -10,   -64,   -18,     0,   -28,    80,    36,     0,    62,     8,   -18]
  K1( 466,:) = [    80,    30,   -48,   -10,    71,   192,   -21,   -64,     8,     3,   168,    -1,    -1,   -24,   -21,     8, &
                   62,   -24,     6,     8,   -10,     3,     6,    -1,   -10,     0,   -18,   -64,    62,     0,   -18,     8, &
                   -1,     0,   171,   512,   -10,     0,   -18,   -64,   -28,     0,    36,    80,    62,     0,   -18,     8]
  K1( 467,:) = [   -10,   -48,    30,    80,   -64,   -21,   192,    71,    -1,   168,     3,     8,     8,   -21,   -24,    -1, &
                    8,     6,   -24,    62,    -1,     6,     3,   -10,   -64,   -18,     0,   -10,     8,   -18,     0,    62, &
                  512,   171,     0,    -1,   -64,   -18,     0,   -10,    80,    36,     0,   -28,     8,   -18,     0,    62]
  K1( 468,:) = [   -48,   -10,    80,    30,   -21,   -64,    71,   192,   168,    -1,     8,     3,   -21,     8,    -1,   -24, &
                    6,     8,    62,   -24,     6,    -1,   -10,     3,   -18,   -64,   -10,     0,   -18,     8,    62,     0, &
                  171,   512,    -1,     0,   -18,   -64,   -10,     0,    36,    80,   -28,     0,   -18,     8,    62,     0]
  K1( 469,:) = [     3,   -10,    -1,     6,   -24,    62,     8,     6,   -24,    -1,     8,   -21,     3,     8,    -1,   168, &
                  192,    71,   -64,   -21,    30,    80,   -10,   -48,     0,    62,     8,   -18,     0,   -28,    80,    36, &
                    0,   -10,   -64,   -18,     0,    -1,   512,   171,     0,    62,     8,   -18,     0,   -10,   -64,   -18]
  K1( 470,:) = [   -10,     3,     6,    -1,    62,   -24,     6,     8,    -1,   -24,   -21,     8,     8,     3,   168,    -1, &
                   71,   192,   -21,   -64,    80,    30,   -48,   -10,    62,     0,   -18,     8,   -28,     0,    36,    80, &
                  -10,     0,   -18,   -64,    -1,     0,   171,   512,    62,     0,   -18,     8,   -10,     0,   -18,   -64]
  K1( 471,:) = [    -1,     6,     3,   -10,     8,     6,   -24,    62,     8,   -21,   -24,    -1,    -1,   168,     3,     8, &
                  -64,   -21,   192,    71,   -10,   -48,    30,    80,     8,   -18,     0,    62,    80,    36,     0,   -28, &
                  -64,   -18,     0,   -10,   512,   171,     0,    -1,     8,   -18,     0,    62,   -64,   -18,     0,   -10]
  K1( 472,:) = [     6,    -1,   -10,     3,     6,     8,    62,   -24,   -21,     8,    -1,   -24,   168,    -1,     8,     3, &
                  -21,   -64,    71,   192,   -48,   -10,    80,    30,   -18,     8,    62,     0,    36,    80,   -28,     0, &
                  -18,   -64,   -10,     0,   171,   512,    -1,     0,   -18,     8,    62,     0,   -18,   -64,   -10,     0]
  K1( 473,:) = [   192,    71,   -64,   -21,    30,    80,   -10,   -48,   -24,    62,     8,     6,     3,   -10,    -1,     6, &
                    3,     8,    -1,   168,   -24,    -1,     8,   -21,     0,    62,     8,   -18,     0,   -10,   -64,   -18, &
                    0,   -28,    80,    36,     0,    62,     8,   -18,     0,    -1,   512,   171,     0,   -10,   -64,   -18]
  K1( 474,:) = [    71,   192,   -21,   -64,    80,    30,   -48,   -10,    62,   -24,     6,     8,   -10,     3,     6,    -1, &
                    8,     3,   168,    -1,    -1,   -24,   -21,     8,    62,     0,   -18,     8,   -10,     0,   -18,   -64, &
                  -28,     0,    36,    80,    62,     0,   -18,     8,    -1,     0,   171,   512,   -10,     0,   -18,   -64]
  K1( 475,:) = [   -64,   -21,   192,    71,   -10,   -48,    30,    80,     8,     6,   -24,    62,    -1,     6,     3,   -10, &
                   -1,   168,     3,     8,     8,   -21,   -24,    -1,     8,   -18,     0,    62,   -64,   -18,     0,   -10, &
                   80,    36,     0,   -28,     8,   -18,     0,    62,   512,   171,     0,    -1,   -64,   -18,     0,   -10]
  K1( 476,:) = [   -21,   -64,    71,   192,   -48,   -10,    80,    30,     6,     8,    62,   -24,     6,    -1,   -10,     3, &
                  168,    -1,     8,     3,   -21,     8,    -1,   -24,   -18,     8,    62,     0,   -18,   -64,   -10,     0, &
                   36,    80,   -28,     0,   -18,     8,    62,     0,   171,   512,    -1,     0,   -18,   -64,   -10,     0]
  K1( 477,:) = [   -24,    62,     8,     6,     3,   -10,    -1,     6,   192,    71,   -64,   -21,    30,    80,   -10,   -48, &
                  -24,    -1,     8,   -21,     3,     8,    -1,   168,     0,   -28,    80,    36,     0,    62,     8,   -18, &
                    0,    62,     8,   -18,     0,   -10,   -64,   -18,     0,   -10,   -64,   -18,     0,    -1,   512,   171]
  K1( 478,:) = [    62,   -24,     6,     8,   -10,     3,     6,    -1,    71,   192,   -21,   -64,    80,    30,   -48,   -10, &
                   -1,   -24,   -21,     8,     8,     3,   168,    -1,   -28,     0,    36,    80,    62,     0,   -18,     8, &
                   62,     0,   -18,     8,   -10,     0,   -18,   -64,   -10,     0,   -18,   -64,    -1,     0,   171,   512]
  K1( 479,:) = [     8,     6,   -24,    62,    -1,     6,     3,   -10,   -64,   -21,   192,    71,   -10,   -48,    30,    80, &
                    8,   -21,   -24,    -1,    -1,   168,     3,     8,    80,    36,     0,   -28,     8,   -18,     0,    62, &
                    8,   -18,     0,    62,   -64,   -18,     0,   -10,   -64,   -18,     0,   -10,   512,   171,     0,    -1]
  K1( 480,:) = [     6,     8,    62,   -24,     6,    -1,   -10,     3,   -21,   -64,    71,   192,   -48,   -10,    80,    30, &
                  -21,     8,    -1,   -24,   168,    -1,     8,     3,    36,    80,   -28,     0,   -18,     8,    62,     0, &
                  -18,     8,    62,     0,   -18,   -64,   -10,     0,   -18,   -64,   -10,     0,   171,   512,    -1,     0]
  K1( 481,:) = [  1536,   512,   512,   168,   192,   512,     8,     0,  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,   -64,    80,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,    80,   -64,   192]
  K1( 482,:) = [   512,  1536,   168,   512,   512,   192,     0,     8,   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  -64,     0,   192,    80,     8,     0,   -24,     8,     8,     0,   192,   512,    80,     0,   192,   -64]
  K1( 483,:) = [   512,   168,  1536,   512,     8,     0,   192,   512,   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                   80,   192,     0,   -64,     8,   -24,     0,     8,   512,   192,     0,     8,   -64,   192,     0,    80]
  K1( 484,:) = [   168,   512,   512,  1536,     0,     8,   512,   192,   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,    80,   -64,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,   -64,    80,     0]
  K1( 485,:) = [   192,   512,     8,     0,  1536,   512,   512,   168,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                 -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,    80,   -64,   192,     0,   -64,    80,   192,     0,     8,     8,   -24]
  K1( 486,:) = [   512,   192,     0,     8,   512,  1536,   168,   512,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,    80,     0,   192,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8]
  K1( 487,:) = [     8,     0,   192,   512,   512,   168,  1536,   512,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                  -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,   -64,   192,     0,    80,    80,   192,     0,   -64,     8,   -24,     0,     8]
  K1( 488,:) = [     0,     8,   512,   192,   168,   512,   512,  1536,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                  -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,   -64,    80,     0,   192,    80,   -64,     0,   -24,     8,     8,     0]
  K1( 489,:) = [  -192,   -64,   -64,   -48,   -24,   -64,   -64,     0,  1536,   512,   512,   168,   192,   512,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,     0,   -64,    80,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,     0,    80,   -64,   192,     0,     8,   512,   192]
  K1( 490,:) = [   -64,  -192,   -48,   -64,   -64,   -24,     0,   -64,   512,  1536,   168,   512,   512,   192,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,     0,   192,    80,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,     0,   192,   -64,     8,     0,   192,   512]
  K1( 491,:) = [   -64,   -48,  -192,   -64,   -64,     0,   -24,   -64,   512,   168,  1536,   512,     8,     0,   192,   512, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,    80,   192,     0,   -64,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   192,     0,    80,   512,   192,     0,     8]
  K1( 492,:) = [   -48,   -64,   -64,  -192,     0,   -64,   -64,   -24,   168,   512,   512,  1536,     0,     8,   512,   192, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,   192,    80,   -64,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   192,   -64,    80,     0,   192,   512,     8,     0]
  K1( 493,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   192,   512,     8,     0,  1536,   512,   512,   168, &
                  -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,     0,     8,   512,   192,     0,    80,   -64,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,   -64,    80,   192]
  K1( 494,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,   512,   192,     0,     8,   512,  1536,   168,   512, &
                  -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,     0,   192,   512,    80,     0,   192,   -64, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,   -64,     0,   192,    80]
  K1( 495,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   192,   512,   512,   168,  1536,   512, &
                  -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,   192,     0,     8,   -64,   192,     0,    80, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,    80,   192,     0,   -64]
  K1( 496,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,   512,   192,   168,   512,   512,  1536, &
                    0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,   192,   512,     8,     0,   192,   -64,    80,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,    80,   -64,     0]
  K1( 497,:) = [   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                 1536,   512,   512,   168,   192,   512,     8,     0,     0,     8,     8,   -24,     0,   -64,    80,   192, &
                    0,    80,   -64,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24]
  K1( 498,:) = [   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  512,  1536,   168,   512,   512,   192,     0,     8,     8,     0,   -24,     8,   -64,     0,   192,    80, &
                   80,     0,   192,   -64,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64]
  K1( 499,:) = [   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                  512,   168,  1536,   512,     8,     0,   192,   512,     8,   -24,     0,     8,    80,   192,     0,   -64, &
                  -64,   192,     0,    80,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64]
  K1( 500,:) = [     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                  168,   512,   512,  1536,     0,     8,   512,   192,   -24,     8,     8,     0,   192,    80,   -64,     0, &
                  192,   -64,    80,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0]
  K1( 501,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,     0,  -192,   -64,   -64,   -48, &
                  192,   512,     8,     0,  1536,   512,   512,   168,     0,    80,   -64,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,   -64,    80,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192]
  K1( 502,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,   -64,   -24,     0,   -64,   -64,  -192,   -48,   -64, &
                  512,   192,     0,     8,   512,  1536,   168,   512,    80,     0,   192,   -64,     8,     0,   192,   512, &
                    8,     0,   -24,     8,   -64,     0,   192,    80,   -64,     0,   -24,   -64,   512,     0,   192,     8]
  K1( 503,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   -24,   -64,   -64,   -48,  -192,   -64, &
                    8,     0,   192,   512,   512,   168,  1536,   512,   -64,   192,     0,    80,   512,   192,     0,     8, &
                    8,   -24,     0,     8,    80,   192,     0,   -64,   -64,   -24,     0,   -64,     8,   192,     0,   512]
  K1( 504,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,   -64,   -24,   -48,   -64,   -64,  -192, &
                    0,     8,   512,   192,   168,   512,   512,  1536,   192,   -64,    80,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,    80,   -64,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0]
  K1( 505,:) = [     0,   512,     8,   192,     0,   -64,   -64,   -24,     0,   -64,    80,   192,     0,     8,   512,   192, &
                    0,     8,     8,   -24,     0,    80,   -64,   192,  1536,   512,   512,   168,  -192,   -64,   -64,   -48, &
                 -192,   -64,   -64,   -48,    24,     8,     8,   168,    24,     8,     8,   168,   240,    80,    80,   -48]
  K1( 506,:) = [   512,     0,   192,     8,   -64,     0,   -24,   -64,   -64,     0,   192,    80,     8,     0,   192,   512, &
                    8,     0,   -24,     8,    80,     0,   192,   -64,   512,  1536,   168,   512,   -64,  -192,   -48,   -64, &
                  -64,  -192,   -48,   -64,     8,    24,   168,     8,     8,    24,   168,     8,    80,   240,   -48,    80]
  K1( 507,:) = [     8,   192,     0,   512,   -64,   -24,     0,   -64,    80,   192,     0,   -64,   512,   192,     0,     8, &
                    8,   -24,     0,     8,   -64,   192,     0,    80,   512,   168,  1536,   512,   -64,   -48,  -192,   -64, &
                  -64,   -48,  -192,   -64,     8,   168,    24,     8,     8,   168,    24,     8,    80,   -48,   240,    80]
  K1( 508,:) = [   192,     8,   512,     0,   -24,   -64,   -64,     0,   192,    80,   -64,     0,   192,   512,     8,     0, &
                  -24,     8,     8,     0,   192,   -64,    80,     0,   168,   512,   512,  1536,   -48,   -64,   -64,  -192, &
                  -48,   -64,   -64,  -192,   168,     8,     8,    24,   168,     8,     8,    24,   -48,    80,    80,   240]
  K1( 509,:) = [     0,   -64,   -64,   -24,     0,   512,     8,   192,     0,     8,     8,   -24,     0,    80,   -64,   192, &
                    0,   -64,    80,   192,     0,     8,   512,   192,  -192,   -64,   -64,   -48,  1536,   512,   512,   168, &
                   24,     8,     8,   168,   240,    80,    80,   -48,  -192,   -64,   -64,   -48,    24,     8,     8,   168]
  K1( 510,:) = [   -64,     0,   -24,   -64,   512,     0,   192,     8,     8,     0,   -24,     8,    80,     0,   192,   -64, &
                  -64,     0,   192,    80,     8,     0,   192,   512,   -64,  -192,   -48,   -64,   512,  1536,   168,   512, &
                    8,    24,   168,     8,    80,   240,   -48,    80,   -64,  -192,   -48,   -64,     8,    24,   168,     8]
  K1( 511,:) = [   -64,   -24,     0,   -64,     8,   192,     0,   512,     8,   -24,     0,     8,   -64,   192,     0,    80, &
                   80,   192,     0,   -64,   512,   192,     0,     8,   -64,   -48,  -192,   -64,   512,   168,  1536,   512, &
                    8,   168,    24,     8,    80,   -48,   240,    80,   -64,   -48,  -192,   -64,     8,   168,    24,     8]
  K1( 512,:) = [   -24,   -64,   -64,     0,   192,     8,   512,     0,   -24,     8,     8,     0,   192,   -64,    80,     0, &
                  192,    80,   -64,     0,   192,   512,     8,     0,   -48,   -64,   -64,  -192,   168,   512,   512,  1536, &
                  168,     8,     8,    24,   -48,    80,    80,   240,   -48,   -64,   -64,  -192,   168,     8,     8,    24]
  K1( 513,:) = [     0,   -64,    80,   192,     0,     8,   512,   192,     0,   512,     8,   192,     0,   -64,   -64,   -24, &
                    0,    80,   -64,   192,     0,     8,     8,   -24,  -192,   -64,   -64,   -48,    24,     8,     8,   168, &
                 1536,   512,   512,   168,  -192,   -64,   -64,   -48,   240,    80,    80,   -48,    24,     8,     8,   168]
  K1( 514,:) = [   -64,     0,   192,    80,     8,     0,   192,   512,   512,     0,   192,     8,   -64,     0,   -24,   -64, &
                   80,     0,   192,   -64,     8,     0,   -24,     8,   -64,  -192,   -48,   -64,     8,    24,   168,     8, &
                  512,  1536,   168,   512,   -64,  -192,   -48,   -64,    80,   240,   -48,    80,     8,    24,   168,     8]
  K1( 515,:) = [    80,   192,     0,   -64,   512,   192,     0,     8,     8,   192,     0,   512,   -64,   -24,     0,   -64, &
                  -64,   192,     0,    80,     8,   -24,     0,     8,   -64,   -48,  -192,   -64,     8,   168,    24,     8, &
                  512,   168,  1536,   512,   -64,   -48,  -192,   -64,    80,   -48,   240,    80,     8,   168,    24,     8]
  K1( 516,:) = [   192,    80,   -64,     0,   192,   512,     8,     0,   192,     8,   512,     0,   -24,   -64,   -64,     0, &
                  192,   -64,    80,     0,   -24,     8,     8,     0,   -48,   -64,   -64,  -192,   168,     8,     8,    24, &
                  168,   512,   512,  1536,   -48,   -64,   -64,  -192,   -48,    80,    80,   240,   168,     8,     8,    24]
  K1( 517,:) = [     0,     8,     8,   -24,     0,    80,   -64,   192,     0,   -64,   -64,   -24,     0,   512,     8,   192, &
                    0,     8,   512,   192,     0,   -64,    80,   192,    24,     8,     8,   168,   240,    80,    80,   -48, &
                 -192,   -64,   -64,   -48,  1536,   512,   512,   168,    24,     8,     8,   168,  -192,   -64,   -64,   -48]
  K1( 518,:) = [     8,     0,   -24,     8,    80,     0,   192,   -64,   -64,     0,   -24,   -64,   512,     0,   192,     8, &
                    8,     0,   192,   512,   -64,     0,   192,    80,     8,    24,   168,     8,    80,   240,   -48,    80, &
                  -64,  -192,   -48,   -64,   512,  1536,   168,   512,     8,    24,   168,     8,   -64,  -192,   -48,   -64]
  K1( 519,:) = [     8,   -24,     0,     8,   -64,   192,     0,    80,   -64,   -24,     0,   -64,     8,   192,     0,   512, &
                  512,   192,     0,     8,    80,   192,     0,   -64,     8,   168,    24,     8,    80,   -48,   240,    80, &
                  -64,   -48,  -192,   -64,   512,   168,  1536,   512,     8,   168,    24,     8,   -64,   -48,  -192,   -64]
  K1( 520,:) = [   -24,     8,     8,     0,   192,   -64,    80,     0,   -24,   -64,   -64,     0,   192,     8,   512,     0, &
                  192,   512,     8,     0,   192,    80,   -64,     0,   168,     8,     8,    24,   -48,    80,    80,   240, &
                  -48,   -64,   -64,  -192,   168,   512,   512,  1536,   168,     8,     8,    24,   -48,   -64,   -64,  -192]
  K1( 521,:) = [     0,     8,   512,   192,     0,   -64,    80,   192,     0,    80,   -64,   192,     0,     8,     8,   -24, &
                    0,   512,     8,   192,     0,   -64,   -64,   -24,    24,     8,     8,   168,  -192,   -64,   -64,   -48, &
                  240,    80,    80,   -48,    24,     8,     8,   168,  1536,   512,   512,   168,  -192,   -64,   -64,   -48]
  K1( 522,:) = [     8,     0,   192,   512,   -64,     0,   192,    80,    80,     0,   192,   -64,     8,     0,   -24,     8, &
                  512,     0,   192,     8,   -64,     0,   -24,   -64,     8,    24,   168,     8,   -64,  -192,   -48,   -64, &
                   80,   240,   -48,    80,     8,    24,   168,     8,   512,  1536,   168,   512,   -64,  -192,   -48,   -64]
  K1( 523,:) = [   512,   192,     0,     8,    80,   192,     0,   -64,   -64,   192,     0,    80,     8,   -24,     0,     8, &
                    8,   192,     0,   512,   -64,   -24,     0,   -64,     8,   168,    24,     8,   -64,   -48,  -192,   -64, &
                   80,   -48,   240,    80,     8,   168,    24,     8,   512,   168,  1536,   512,   -64,   -48,  -192,   -64]
  K1( 524,:) = [   192,   512,     8,     0,   192,    80,   -64,     0,   192,   -64,    80,     0,   -24,     8,     8,     0, &
                  192,     8,   512,     0,   -24,   -64,   -64,     0,   168,     8,     8,    24,   -48,   -64,   -64,  -192, &
                  -48,    80,    80,   240,   168,     8,     8,    24,   168,   512,   512,  1536,   -48,   -64,   -64,  -192]
  K1( 525,:) = [     0,    80,   -64,   192,     0,     8,     8,   -24,     0,     8,   512,   192,     0,   -64,    80,   192, &
                    0,   -64,   -64,   -24,     0,   512,     8,   192,   240,    80,    80,   -48,    24,     8,     8,   168, &
                   24,     8,     8,   168,  -192,   -64,   -64,   -48,  -192,   -64,   -64,   -48,  1536,   512,   512,   168]
  K1( 526,:) = [    80,     0,   192,   -64,     8,     0,   -24,     8,     8,     0,   192,   512,   -64,     0,   192,    80, &
                  -64,     0,   -24,   -64,   512,     0,   192,     8,    80,   240,   -48,    80,     8,    24,   168,     8, &
                    8,    24,   168,     8,   -64,  -192,   -48,   -64,   -64,  -192,   -48,   -64,   512,  1536,   168,   512]
  K1( 527,:) = [   -64,   192,     0,    80,     8,   -24,     0,     8,   512,   192,     0,     8,    80,   192,     0,   -64, &
                  -64,   -24,     0,   -64,     8,   192,     0,   512,    80,   -48,   240,    80,     8,   168,    24,     8, &
                    8,   168,    24,     8,   -64,   -48,  -192,   -64,   -64,   -48,  -192,   -64,   512,   168,  1536,   512]
  K1( 528,:) = [   192,   -64,    80,     0,   -24,     8,     8,     0,   192,   512,     8,     0,   192,    80,   -64,     0, &
                  -24,   -64,   -64,     0,   192,     8,   512,     0,   -48,    80,    80,   240,   168,     8,     8,    24, &
                  168,     8,     8,    24,   -48,   -64,   -64,  -192,   -48,   -64,   -64,  -192,   168,   512,   512,  1536]
  K1( 529,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 530,:) = [    72,     0,     0,   -72,    72,    54,     0,     9,    72,     0,    54,     9,     9,    27,    27,    72, &
                   72,     0,     0,   -72,   -72,  -216,  -216,  -576,    -9,    27,   -27,     9,   -90,  -216,   -27,   -72, &
                   -9,    27,    27,    90,    -9,   -27,    27,     9,    72,   216,   216,   576,   -90,   -27,  -216,   -72]
  K1( 531,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 532,:) = [     0,   -72,    72,     0,     0,     9,    72,    54,    54,     9,    72,     0,    27,    72,     9,    27, &
                    0,   -72,    72,     0,  -216,  -576,   -72,  -216,   -27,     9,    -9,    27,   -27,   -72,   -90,  -216, &
                   27,    90,    -9,    27,    27,     9,    -9,   -27,   216,   576,    72,   216,  -216,   -72,   -90,   -27]
  K1( 533,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1( 534,:) = [    72,    54,     0,     9,    72,     0,     0,   -72,    72,     0,     0,   -72,   -72,  -216,  -216,  -576, &
                   72,     0,    54,     9,     9,    27,    27,    72,   -90,  -216,   -27,   -72,    -9,    27,   -27,     9, &
                   72,   216,   216,   576,   -90,   -27,  -216,   -72,    -9,    27,    27,    90,    -9,   -27,    27,     9]
  K1( 535,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1( 536,:) = [     0,     9,    72,    54,     0,   -72,    72,     0,     0,   -72,    72,     0,  -216,  -576,   -72,  -216, &
                   54,     9,    72,     0,    27,    72,     9,    27,   -27,   -72,   -90,  -216,   -27,     9,    -9,    27, &
                  216,   576,    72,   216,  -216,   -72,   -90,   -27,    27,    90,    -9,    27,    27,     9,    -9,   -27]
  K1( 537,:) = [   216,    72,    72,    54,    27,    72,    72,     0, -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,     0,    72,   -90,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,     0,   -90,    72,  -216,     0,    -9,  -576,  -216]
  K1( 538,:) = [    72,     0,     0,     9,    -9,     0,     0,   -72,  -576,     0,  -189,     9,   -72,  -216,   -27,    -9, &
                   -9,   189,     0,   576,     9,    27,   216,    72,    -9,    27,   -27,   -72,    72,    27,   -27,     9, &
                   72,  -216,    27,   -72,    72,   216,    27,     9,    72,   -27,   216,   -72,    -9,   -27,  -216,   -72]
  K1( 539,:) = [    72,    54,   216,    72,    72,     0,    27,    72,  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,  -216,     0,    72,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,  -216,     0,   -90,  -576,  -216,     0,    -9]
  K1( 540,:) = [     0,     9,    72,     0,     0,   -72,    -9,     0,  -189,     9,  -576,     0,   -27,    -9,   -72,  -216, &
                    0,   576,    -9,   189,   216,    72,     9,    27,   -27,   -72,    -9,    27,   -27,     9,    72,    27, &
                   27,   -72,    72,  -216,    27,     9,    72,   216,   216,   -72,    72,   -27,  -216,   -72,    -9,   -27]
  K1( 541,:) = [    27,     9,    -9,    27,    27,   -72,    72,  -216,  -216,   -72,    -9,   -27,     0,  -576,     9,  -189, &
                   27,     9,    72,   216,     0,    72,    90,    54,     0,     9,    -9,  -189,     0,    90,   -90,    54, &
                    0,   -72,    -9,     0,     0,   576,    -9,   189,     0,     9,    72,     0,     0,   -72,   -90,   -54]
  K1( 542,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576, &
                   72,    27,     0,    72,    72,   216,    54,    72,    -9,     0,  -216,  -576,   -90,     0,  -216,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90]
  K1( 543,:) = [    -9,    27,    27,     9,    72,  -216,    27,   -72,    -9,   -27,  -216,   -72,     9,  -189,     0,  -576, &
                   72,   216,    27,     9,    90,    54,     0,    72,    -9,  -189,     0,     9,   -90,    54,     0,    90, &
                   -9,     0,     0,   -72,    -9,   189,     0,   576,    72,     0,     0,     9,   -90,   -54,     0,   -72]
  K1( 544,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728, &
                    0,    72,    72,    27,    54,    72,    72,   216,  -216,  -576,    -9,     0,  -216,    72,   -90,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,   -90,    72,     0]
  K1( 545,:) = [    27,    72,    72,     0,   216,    72,    72,    54,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,     0,    -9,    -9,    27,     0,    72,   -90,  -216, &
                    0,   -90,    72,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27]
  K1( 546,:) = [    -9,     0,     0,   -72,    72,     0,     0,     9,    -9,   189,     0,   576,     9,    27,   216,    72, &
                 -576,     0,  -189,     9,   -72,  -216,   -27,    -9,    72,    27,   -27,     9,    -9,    27,   -27,   -72, &
                   72,   -27,   216,   -72,    -9,   -27,  -216,   -72,    72,  -216,    27,   -72,    72,   216,    27,     9]
  K1( 547,:) = [    72,     0,    27,    72,    72,    54,   216,    72,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                 -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72, &
                   72,  -216,     0,   -90,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72]
  K1( 548,:) = [     0,   -72,    -9,     0,     0,     9,    72,     0,     0,   576,    -9,   189,   216,    72,     9,    27, &
                 -189,     9,  -576,     0,   -27,    -9,   -72,  -216,   -27,     9,    72,    27,   -27,   -72,    -9,    27, &
                  216,   -72,    72,   -27,  -216,   -72,    -9,   -27,    27,   -72,    72,  -216,    27,     9,    72,   216]
  K1( 549,:) = [    27,   -72,    72,  -216,    27,     9,    -9,    27,    27,     9,    72,   216,     0,    72,    90,    54, &
                 -216,   -72,    -9,   -27,     0,  -576,     9,  -189,     0,    90,   -90,    54,     0,     9,    -9,  -189, &
                    0,     9,    72,     0,     0,   -72,   -90,   -54,     0,   -72,    -9,     0,     0,   576,    -9,   189]
  K1( 550,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,    72,    27,     0,    72,    72,   216,    54,    72, &
                 -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,   -90,     0,  -216,    72,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,    72,     0,  -216,   -90,    72,     0,    27,    72,  -576,     0,  -216,    -9]
  K1( 551,:) = [    72,  -216,    27,   -72,    -9,    27,    27,     9,    72,   216,    27,     9,    90,    54,     0,    72, &
                   -9,   -27,  -216,   -72,     9,  -189,     0,  -576,   -90,    54,     0,    90,    -9,  -189,     0,     9, &
                   72,     0,     0,     9,   -90,   -54,     0,   -72,    -9,     0,     0,   -72,    -9,   189,     0,   576]
  K1( 552,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,    72,    27,    54,    72,    72,   216, &
                    0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,  -216,    72,   -90,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,   -90,    72,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0]
  K1( 553,:) = [     0,    -9,    72,   -27,     0,   -90,    -9,   -27,     0,    -9,   -90,   -27,     0,    -9,    -9,  -216, &
                    0,    72,    -9,   -27,     0,   -90,   -90,  -216,   -27,    -9,    -9,   189,  -270,   -90,   -90,   -54, &
                  -27,    -9,    -9,   -54,   -27,    -9,    -9,   189,   216,    72,    72,   189,  -270,   -90,   -90,   -54]
  K1( 554,:) = [    72,    27,   216,     9,    -9,  -216,   -27,   -72,    72,    27,  -216,   -72,     9,     0,  -189,  -576, &
                   -9,    27,    27,     9,    90,     0,    54,    72,    -9,     0,   189,   576,   -90,     0,   -54,   -72, &
                   -9,     0,     0,   -72,    -9,     0,  -189,     9,    72,     0,     0,     9,   -90,     0,    54,    90]
  K1( 555,:) = [    72,   -27,     0,    -9,    -9,   -27,     0,   -90,   -90,   -27,     0,    -9,    -9,  -216,     0,    -9, &
                   -9,   -27,     0,    72,   -90,  -216,     0,   -90,    -9,   189,   -27,    -9,   -90,   -54,  -270,   -90, &
                   -9,   -54,   -27,    -9,    -9,   189,   -27,    -9,    72,   189,   216,    72,   -90,   -54,  -270,   -90]
  K1( 556,:) = [   216,     9,    72,    27,   -27,   -72,    -9,  -216,  -216,   -72,    72,    27,  -189,  -576,     9,     0, &
                   27,     9,    -9,    27,    54,    72,    90,     0,   189,   576,    -9,     0,   -54,   -72,   -90,     0, &
                    0,   -72,    -9,     0,  -189,     9,    -9,     0,     0,     9,    72,     0,    54,    90,   -90,     0]
  K1( 557,:) = [     0,   -90,    -9,   -27,     0,    -9,    72,   -27,     0,    72,    -9,   -27,     0,   -90,   -90,  -216, &
                    0,    -9,   -90,   -27,     0,    -9,    -9,  -216,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   189, &
                  216,    72,    72,   189,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   -54,   -27,    -9,    -9,   189]
  K1( 558,:) = [    -9,  -216,   -27,   -72,    72,    27,   216,     9,    -9,    27,    27,     9,    90,     0,    54,    72, &
                   72,    27,  -216,   -72,     9,     0,  -189,  -576,   -90,     0,   -54,   -72,    -9,     0,   189,   576, &
                   72,     0,     0,     9,   -90,     0,    54,    90,    -9,     0,     0,   -72,    -9,     0,  -189,     9]
  K1( 559,:) = [    -9,   -27,     0,   -90,    72,   -27,     0,    -9,    -9,   -27,     0,    72,   -90,  -216,     0,   -90, &
                  -90,   -27,     0,    -9,    -9,  -216,     0,    -9,   -90,   -54,  -270,   -90,    -9,   189,   -27,    -9, &
                   72,   189,   216,    72,   -90,   -54,  -270,   -90,    -9,   -54,   -27,    -9,    -9,   189,   -27,    -9]
  K1( 560,:) = [   -27,   -72,    -9,  -216,   216,     9,    72,    27,    27,     9,    -9,    27,    54,    72,    90,     0, &
                 -216,   -72,    72,    27,  -189,  -576,     9,     0,   -54,   -72,   -90,     0,   189,   576,    -9,     0, &
                    0,     9,    72,     0,    54,    90,   -90,     0,     0,   -72,    -9,     0,  -189,     9,    -9,     0]
  K1( 561,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1( 562,:) = [    72,    27,   216,    90,    72,   216,   216,   576,  -576,  -216,  -216,   -72,   -72,     0,     0,    72, &
                  -90,   -27,  -216,   -72,     9,     0,     0,    -9,    -9,     0,   -54,   -72,    72,     0,   189,     9, &
                   72,     0,     0,   -72,    72,     0,    54,     9,    72,     0,     0,   -72,    -9,     0,  -189,   -72]
  K1( 563,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1( 564,:) = [   216,    90,    72,    27,   216,   576,    72,   216,  -216,   -72,  -576,  -216,     0,    72,   -72,     0, &
                 -216,   -72,   -90,   -27,     0,    -9,     9,     0,   -54,   -72,    -9,     0,   189,     9,    72,     0, &
                    0,   -72,    72,     0,    54,     9,    72,     0,     0,   -72,    72,     0,  -189,   -72,    -9,     0]
  K1( 565,:) = [     0,    -9,    -9,    27,     0,   -90,    72,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,    72,   -90,  -216,   -27,    -9,    -9,  -189,  -270,   -90,   -90,    54, &
                  216,    72,    72,    54, -1728,  -576,  -576,  -189,   -27,    -9,    -9,  -189,   216,    72,    72,    54]
  K1( 566,:) = [    -9,   -27,   -27,     9,    72,   -27,   216,   -72,    72,   216,    27,     9,   576,     0,   189,    -9, &
                   -9,   -27,  -216,   -72,   -72,     0,   -54,   -90,    -9,     0,   189,     9,   -90,     0,   -54,    90, &
                   72,     0,     0,     9,  -576,     0,  -189,     9,    -9,     0,     0,   -72,    72,     0,    54,    90]
  K1( 567,:) = [    -9,    27,     0,    -9,    72,  -216,     0,   -90,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,   -90,  -216,     0,    72,    -9,  -189,   -27,    -9,   -90,    54,  -270,   -90, &
                   72,    54,   216,    72,  -576,  -189, -1728,  -576,    -9,  -189,   -27,    -9,    72,    54,   216,    72]
  K1( 568,:) = [   -27,     9,    -9,   -27,   216,   -72,    72,   -27,    27,     9,    72,   216,   189,    -9,   576,     0, &
                 -216,   -72,    -9,   -27,   -54,   -90,   -72,     0,   189,     9,    -9,     0,   -54,    90,   -90,     0, &
                    0,     9,    72,     0,  -189,     9,  -576,     0,     0,   -72,    -9,     0,    54,    90,    72,     0]
  K1( 569,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 570,:) = [    72,   216,   216,   576,    72,    27,   216,    90,   -90,   -27,  -216,   -72,     9,     0,     0,    -9, &
                 -576,  -216,  -216,   -72,   -72,     0,     0,    72,    72,     0,   189,     9,    -9,     0,   -54,   -72, &
                   72,     0,     0,   -72,    -9,     0,  -189,   -72,    72,     0,     0,   -72,    72,     0,    54,     9]
  K1( 571,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 572,:) = [   216,   576,    72,   216,   216,    90,    72,    27,  -216,   -72,   -90,   -27,     0,    -9,     9,     0, &
                 -216,   -72,  -576,  -216,     0,    72,   -72,     0,   189,     9,    72,     0,   -54,   -72,    -9,     0, &
                    0,   -72,    72,     0,  -189,   -72,    -9,     0,     0,   -72,    72,     0,    54,     9,    72,     0]
  K1( 573,:) = [     0,   -90,    72,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,    72,   -90,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -270,   -90,   -90,    54,   -27,    -9,    -9,  -189, &
                  -27,    -9,    -9,  -189,   216,    72,    72,    54,   216,    72,    72,    54, -1728,  -576,  -576,  -189]
  K1( 574,:) = [    72,   -27,   216,   -72,    -9,   -27,   -27,     9,    -9,   -27,  -216,   -72,   -72,     0,   -54,   -90, &
                   72,   216,    27,     9,   576,     0,   189,    -9,   -90,     0,   -54,    90,    -9,     0,   189,     9, &
                   -9,     0,     0,   -72,    72,     0,    54,    90,    72,     0,     0,     9,  -576,     0,  -189,     9]
  K1( 575,:) = [    72,  -216,     0,   -90,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,   -90,  -216,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,   -90,    54,  -270,   -90,    -9,  -189,   -27,    -9, &
                   -9,  -189,   -27,    -9,    72,    54,   216,    72,    72,    54,   216,    72,  -576,  -189, -1728,  -576]
  K1( 576,:) = [   216,   -72,    72,   -27,   -27,     9,    -9,   -27,  -216,   -72,    -9,   -27,   -54,   -90,   -72,     0, &
                   27,     9,    72,   216,   189,    -9,   576,     0,   -54,    90,   -90,     0,   189,     9,    -9,     0, &
                    0,   -72,    -9,     0,    54,    90,    72,     0,     0,     9,    72,     0,  -189,     9,  -576,     0]
  K1( 577,:) = [     0,    72,   -72,     0,    54,    72,     9,     0,     0,    72,     9,    54,    27,     9,    72,    27, &
                    0,    72,   -72,     0,  -216,   -72,  -576,  -216,    27,    -9,     9,   -27,  -216,   -90,   -72,   -27, &
                   27,    -9,    90,    27,   -27,    -9,     9,    27,   216,    72,   576,   216,   -27,   -90,   -72,  -216]
  K1( 578,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 579,:) = [   -72,     0,     0,    72,     9,     0,    54,    72,     9,    54,     0,    72,    72,    27,    27,     9, &
                  -72,     0,     0,    72,  -576,  -216,  -216,   -72,     9,   -27,    27,    -9,   -72,   -27,  -216,   -90, &
                   90,    27,    27,    -9,     9,    27,   -27,    -9,   576,   216,   216,    72,   -72,  -216,   -27,   -90]
  K1( 580,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 581,:) = [    54,    72,     9,     0,     0,    72,   -72,     0,     0,    72,   -72,     0,  -216,   -72,  -576,  -216, &
                    0,    72,     9,    54,    27,     9,    72,    27,  -216,   -90,   -72,   -27,    27,    -9,     9,   -27, &
                  216,    72,   576,   216,   -27,   -90,   -72,  -216,    27,    -9,    90,    27,   -27,    -9,     9,    27]
  K1( 582,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1( 583,:) = [     9,     0,    54,    72,   -72,     0,     0,    72,   -72,     0,     0,    72,  -576,  -216,  -216,   -72, &
                    9,    54,     0,    72,    72,    27,    27,     9,   -72,   -27,  -216,   -90,     9,   -27,    27,    -9, &
                  576,   216,   216,    72,   -72,  -216,   -27,   -90,    90,    27,    27,    -9,     9,    27,   -27,    -9]
  K1( 584,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1( 585,:) = [     0,    72,     9,     0,     0,    -9,   -72,     0,     0,  -576,     9,  -189,  -216,   -72,    -9,   -27, &
                  189,    -9,   576,     0,    27,     9,    72,   216,    27,    -9,   -72,   -27,    27,    72,     9,   -27, &
                 -216,    72,   -72,    27,   216,    72,     9,    27,   -27,    72,   -72,   216,   -27,    -9,   -72,  -216]
  K1( 586,:) = [    72,   216,    54,    72,    72,    27,     0,    72,  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,     0,  -216,    72,    -9,     0,  -216,  -576]
  K1( 587,:) = [     9,     0,     0,    72,   -72,     0,     0,    -9,     9,  -189,     0,  -576,    -9,   -27,  -216,   -72, &
                  576,     0,   189,    -9,    72,   216,    27,     9,   -72,   -27,    27,    -9,     9,   -27,    27,    72, &
                  -72,    27,  -216,    72,     9,    27,   216,    72,   -72,   216,   -27,    72,   -72,  -216,   -27,    -9]
  K1( 588,:) = [    54,    72,    72,   216,     0,    72,    72,    27,  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,  -216,   -90,    72,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,    72,   -90,     0,  -216,  -576,    -9,     0]
  K1( 589,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189, &
                   27,    72,    72,     0,   216,    72,    72,    54,     0,    -9,  -576,  -216,     0,   -90,    72,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,    72,   -90,  -216]
  K1( 590,:) = [     9,    27,    27,    -9,   -72,    27,  -216,    72,   -72,  -216,   -27,    -9,  -576,     0,  -189,     9, &
                    9,    27,   216,    72,    72,     0,    54,    90,     9,     0,  -189,    -9,    90,     0,    54,   -90, &
                  -72,     0,     0,    -9,   576,     0,   189,    -9,     9,     0,     0,    72,   -72,     0,   -54,   -90]
  K1( 591,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576, &
                   72,     0,    27,    72,    72,    54,   216,    72,  -576,  -216,     0,    -9,    72,  -216,     0,   -90, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72]
  K1( 592,:) = [    27,    -9,     9,    27,  -216,    72,   -72,    27,   -27,    -9,   -72,  -216,  -189,     9,  -576,     0, &
                  216,    72,     9,    27,    54,    90,    72,     0,  -189,    -9,     9,     0,    54,   -90,    90,     0, &
                    0,    -9,   -72,     0,   189,    -9,   576,     0,     0,    72,     9,     0,   -54,   -90,   -72,     0]
  K1( 593,:) = [     0,    -9,   -72,     0,     0,    72,     9,     0,   189,    -9,   576,     0,    27,     9,    72,   216, &
                    0,  -576,     9,  -189,  -216,   -72,    -9,   -27,    27,    72,     9,   -27,    27,    -9,   -72,   -27, &
                  -27,    72,   -72,   216,   -27,    -9,   -72,  -216,  -216,    72,   -72,    27,   216,    72,     9,    27]
  K1( 594,:) = [    72,    27,     0,    72,    72,   216,    54,    72,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                 -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90, &
                  -90,     0,  -216,    72,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72]
  K1( 595,:) = [   -72,     0,     0,    -9,     9,     0,     0,    72,   576,     0,   189,    -9,    72,   216,    27,     9, &
                    9,  -189,     0,  -576,    -9,   -27,  -216,   -72,     9,   -27,    27,    72,   -72,   -27,    27,    -9, &
                  -72,   216,   -27,    72,   -72,  -216,   -27,    -9,   -72,    27,  -216,    72,     9,    27,   216,    72]
  K1( 596,:) = [     0,    72,    72,    27,    54,    72,    72,   216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                 -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    27,    -9,    -9,     0,  -216,   -90,    72,     0, &
                 -216,    72,   -90,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0]
  K1( 597,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,    27,    72,    72,     0,   216,    72,    72,    54, &
                 -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,     0,   -90,    72,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,    72,   -90,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216]
  K1( 598,:) = [   -72,    27,  -216,    72,     9,    27,    27,    -9,     9,    27,   216,    72,    72,     0,    54,    90, &
                  -72,  -216,   -27,    -9,  -576,     0,  -189,     9,    90,     0,    54,   -90,     9,     0,  -189,    -9, &
                    9,     0,     0,    72,   -72,     0,   -54,   -90,   -72,     0,     0,    -9,   576,     0,   189,    -9]
  K1( 599,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,    27,    72,    72,    54,   216,    72, &
                   -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,  -216,     0,   -90,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,   -90,  -216,     0,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576]
  K1( 600,:) = [  -216,    72,   -72,    27,    27,    -9,     9,    27,   216,    72,     9,    27,    54,    90,    72,     0, &
                  -27,    -9,   -72,  -216,  -189,     9,  -576,     0,    54,   -90,    90,     0,  -189,    -9,     9,     0, &
                    0,    72,     9,     0,   -54,   -90,   -72,     0,     0,    -9,   -72,     0,   189,    -9,   576,     0]
  K1( 601,:) = [    27,    72,     9,   216,  -216,    -9,   -72,   -27,    27,    72,   -72,  -216,     0,     9,  -576,  -189, &
                   27,    -9,     9,    27,     0,    90,    72,    54,     0,    -9,   576,   189,     0,   -90,   -72,   -54, &
                    0,    -9,   -72,     0,     0,    -9,     9,  -189,     0,    72,     9,     0,     0,   -90,    90,    54]
  K1( 602,:) = [    -9,     0,   -27,    72,   -90,     0,   -27,    -9,    -9,     0,   -27,   -90,    -9,     0,  -216,    -9, &
                   72,     0,   -27,    -9,   -90,     0,  -216,   -90,    -9,   -27,   189,    -9,   -90,  -270,   -54,   -90, &
                   -9,   -27,   -54,    -9,    -9,   -27,   189,    -9,    72,   216,   189,    72,   -90,  -270,   -54,   -90]
  K1( 603,:) = [     9,   216,    27,    72,   -72,   -27,  -216,    -9,   -72,  -216,    27,    72,  -576,  -189,     0,     9, &
                    9,    27,    27,    -9,    72,    54,     0,    90,   576,   189,     0,    -9,   -72,   -54,     0,   -90, &
                  -72,     0,     0,    -9,     9,  -189,     0,    -9,     9,     0,     0,    72,    90,    54,     0,   -90]
  K1( 604,:) = [   -27,    72,    -9,     0,   -27,    -9,   -90,     0,   -27,   -90,    -9,     0,  -216,    -9,    -9,     0, &
                  -27,    -9,    72,     0,  -216,   -90,   -90,     0,   189,    -9,    -9,   -27,   -54,   -90,   -90,  -270, &
                  -54,    -9,    -9,   -27,   189,    -9,    -9,   -27,   189,    72,    72,   216,   -54,   -90,   -90,  -270]
  K1( 605,:) = [  -216,    -9,   -72,   -27,    27,    72,     9,   216,    27,    -9,     9,    27,     0,    90,    72,    54, &
                   27,    72,   -72,  -216,     0,     9,  -576,  -189,     0,   -90,   -72,   -54,     0,    -9,   576,   189, &
                    0,    72,     9,     0,     0,   -90,    90,    54,     0,    -9,   -72,     0,     0,    -9,     9,  -189]
  K1( 606,:) = [   -90,     0,   -27,    -9,    -9,     0,   -27,    72,    72,     0,   -27,    -9,   -90,     0,  -216,   -90, &
                   -9,     0,   -27,   -90,    -9,     0,  -216,    -9,   -90,  -270,   -54,   -90,    -9,   -27,   189,    -9, &
                   72,   216,   189,    72,   -90,  -270,   -54,   -90,    -9,   -27,   -54,    -9,    -9,   -27,   189,    -9]
  K1( 607,:) = [   -72,   -27,  -216,    -9,     9,   216,    27,    72,     9,    27,    27,    -9,    72,    54,     0,    90, &
                  -72,  -216,    27,    72,  -576,  -189,     0,     9,   -72,   -54,     0,   -90,   576,   189,     0,    -9, &
                    9,     0,     0,    72,    90,    54,     0,   -90,   -72,     0,     0,    -9,     9,  -189,     0,    -9]
  K1( 608,:) = [   -27,    -9,   -90,     0,   -27,    72,    -9,     0,   -27,    -9,    72,     0,  -216,   -90,   -90,     0, &
                  -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -54,   -90,   -90,  -270,   189,    -9,    -9,   -27, &
                  189,    72,    72,   216,   -54,   -90,   -90,  -270,   -54,    -9,    -9,   -27,   189,    -9,    -9,   -27]
  K1( 609,:) = [    27,    72,    90,   216,   216,    72,   576,   216,  -216,  -576,   -72,  -216,     0,   -72,    72,     0, &
                  -27,   -90,   -72,  -216,     0,     9,    -9,     0,     0,    -9,   -72,   -54,     0,    72,     9,   189, &
                    0,    72,   -72,     0,     0,    72,     9,    54,     0,    72,   -72,     0,     0,    -9,   -72,  -189]
  K1( 610,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1( 611,:) = [    90,   216,    27,    72,   576,   216,   216,    72,   -72,  -216,  -216,  -576,    72,     0,     0,   -72, &
                  -72,  -216,   -27,   -90,    -9,     0,     0,     9,   -72,   -54,     0,    -9,     9,   189,     0,    72, &
                  -72,     0,     0,    72,     9,    54,     0,    72,   -72,     0,     0,    72,   -72,  -189,     0,    -9]
  K1( 612,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1( 613,:) = [   -27,    -9,     9,   -27,   -27,    72,   -72,   216,   216,    72,     9,    27,     0,   576,    -9,   189, &
                  -27,    -9,   -72,  -216,     0,   -72,   -90,   -54,     0,    -9,     9,   189,     0,   -90,    90,   -54, &
                    0,    72,     9,     0,     0,  -576,     9,  -189,     0,    -9,   -72,     0,     0,    72,    90,    54]
  K1( 614,:) = [    -9,     0,    27,    -9,   -90,     0,  -216,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,    72,     0,  -216,   -90,    -9,   -27,  -189,    -9,   -90,  -270,    54,   -90, &
                   72,   216,    54,    72,  -576, -1728,  -189,  -576,    -9,   -27,  -189,    -9,    72,   216,    54,    72]
  K1( 615,:) = [     9,   -27,   -27,    -9,   -72,   216,   -27,    72,     9,    27,   216,    72,    -9,   189,     0,   576, &
                  -72,  -216,   -27,    -9,   -90,   -54,     0,   -72,     9,   189,     0,    -9,    90,   -54,     0,   -90, &
                    9,     0,     0,    72,     9,  -189,     0,  -576,   -72,     0,     0,    -9,    90,    54,     0,    72]
  K1( 616,:) = [    27,    -9,    -9,     0,  -216,    72,   -90,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,   -90,    72,     0,  -189,    -9,    -9,   -27,    54,   -90,   -90,  -270, &
                   54,    72,    72,   216,  -189,  -576,  -576, -1728,  -189,    -9,    -9,   -27,    54,    72,    72,   216]
  K1( 617,:) = [   216,    72,   576,   216,    27,    72,    90,   216,   -27,   -90,   -72,  -216,     0,     9,    -9,     0, &
                 -216,  -576,   -72,  -216,     0,   -72,    72,     0,     0,    72,     9,   189,     0,    -9,   -72,   -54, &
                    0,    72,   -72,     0,     0,    -9,   -72,  -189,     0,    72,   -72,     0,     0,    72,     9,    54]
  K1( 618,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 619,:) = [   576,   216,   216,    72,    90,   216,    27,    72,   -72,  -216,   -27,   -90,    -9,     0,     0,     9, &
                  -72,  -216,  -216,  -576,    72,     0,     0,   -72,     9,   189,     0,    72,   -72,   -54,     0,    -9, &
                  -72,     0,     0,    72,   -72,  -189,     0,    -9,   -72,     0,     0,    72,     9,    54,     0,    72]
  K1( 620,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 621,:) = [   -27,    72,   -72,   216,   -27,    -9,     9,   -27,   -27,    -9,   -72,  -216,     0,   -72,   -90,   -54, &
                  216,    72,     9,    27,     0,   576,    -9,   189,     0,   -90,    90,   -54,     0,    -9,     9,   189, &
                    0,    -9,   -72,     0,     0,    72,    90,    54,     0,    72,     9,     0,     0,  -576,     9,  -189]
  K1( 622,:) = [   -90,     0,  -216,    72,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,    72,     0,  -216,   -90, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,   -90,  -270,    54,   -90,    -9,   -27,  -189,    -9, &
                   -9,   -27,  -189,    -9,    72,   216,    54,    72,    72,   216,    54,    72,  -576, -1728,  -189,  -576]
  K1( 623,:) = [   -72,   216,   -27,    72,     9,   -27,   -27,    -9,   -72,  -216,   -27,    -9,   -90,   -54,     0,   -72, &
                    9,    27,   216,    72,    -9,   189,     0,   576,    90,   -54,     0,   -90,     9,   189,     0,    -9, &
                  -72,     0,     0,    -9,    90,    54,     0,    72,     9,     0,     0,    72,     9,  -189,     0,  -576]
  K1( 624,:) = [  -216,    72,   -90,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,   -90,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    54,   -90,   -90,  -270,  -189,    -9,    -9,   -27, &
                 -189,    -9,    -9,   -27,    54,    72,    72,   216,    54,    72,    72,   216,  -189,  -576,  -576, -1728]
  K1( 625,:) = [ -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,   216,    72,    72,    54,    27,    72,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,    72,   -90,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,   -90,    72,  -216]
  K1( 626,:) = [  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    72,   216,    54,    72,    72,    27,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                   72,     0,  -216,   -90,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,   -90,     0,  -216,    72]
  K1( 627,:) = [  -576,  -189,     0,     9,    -9,     0,   189,   576,    72,     0,     0,     9,     9,   216,    27,    72, &
                   -9,     0,     0,   -72,   -72,   -27,  -216,    -9,    -9,  -216,   -27,   -72,    72,    27,   216,     9, &
                   72,   216,   -27,   -72,    72,   -27,    27,     9,    72,    27,  -216,   -72,    -9,   -27,    27,   -72]
  K1( 628,:) = [  -189,  -576,     9,     0,     0,    -9,   576,   189,     0,    72,     9,     0,   216,     9,    72,    27, &
                    0,    -9,   -72,     0,   -27,   -72,    -9,  -216,  -216,    -9,   -72,   -27,    27,    72,     9,   216, &
                  216,    72,   -72,   -27,   -27,    72,     9,    27,    27,    72,   -72,  -216,   -27,    -9,   -72,    27]
  K1( 629,:) = [  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                  216,    72,    72,    54,    27,    72,    72,     0,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,   -90,    72,  -216,     0,    72,   -90,  -216,     0,    -9,    -9,    27]
  K1( 630,:) = [  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                   72,   216,    54,    72,    72,    27,     0,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,   -90,     0,  -216,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9]
  K1( 631,:) = [    -9,     0,   189,   576,  -576,  -189,     0,     9,    -9,     0,     0,   -72,   -72,   -27,  -216,    -9, &
                   72,     0,     0,     9,     9,   216,    27,    72,    72,    27,   216,     9,    -9,  -216,   -27,   -72, &
                   72,    27,  -216,   -72,    -9,   -27,    27,   -72,    72,   216,   -27,   -72,    72,   -27,    27,     9]
  K1( 632,:) = [     0,    -9,   576,   189,  -189,  -576,     9,     0,     0,    -9,   -72,     0,   -27,   -72,    -9,  -216, &
                    0,    72,     9,     0,   216,     9,    72,    27,    27,    72,     9,   216,  -216,    -9,   -72,   -27, &
                   27,    72,   -72,  -216,   -27,    -9,   -72,    27,   216,    72,   -72,   -27,   -27,    72,     9,    27]
  K1( 633,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 634,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 635,:) = [    72,    54,     0,     9,    72,     0,     0,   -72,    72,     0,     0,   -72,   -72,  -216,  -216,  -576, &
                   72,     0,    54,     9,     9,    27,    27,    72,   -90,  -216,   -27,   -72,    -9,    27,   -27,     9, &
                   72,   216,   216,   576,   -90,   -27,  -216,   -72,    -9,    27,    27,    90,    -9,   -27,    27,     9]
  K1( 636,:) = [    54,    72,     9,     0,     0,    72,   -72,     0,     0,    72,   -72,     0,  -216,   -72,  -576,  -216, &
                    0,    72,     9,    54,    27,     9,    72,    27,  -216,   -90,   -72,   -27,    27,    -9,     9,   -27, &
                  216,    72,   576,   216,   -27,   -90,   -72,  -216,    27,    -9,    90,    27,   -27,    -9,     9,    27]
  K1( 637,:) = [    27,    72,     9,   216,  -216,    -9,   -72,   -27,    27,    72,   -72,  -216,     0,     9,  -576,  -189, &
                   27,    -9,     9,    27,     0,    90,    72,    54,     0,    -9,   576,   189,     0,   -90,   -72,   -54, &
                    0,    -9,   -72,     0,     0,    -9,     9,  -189,     0,    72,     9,     0,     0,   -90,    90,    54]
  K1( 638,:) = [    72,    27,   216,     9,    -9,  -216,   -27,   -72,    72,    27,  -216,   -72,     9,     0,  -189,  -576, &
                   -9,    27,    27,     9,    90,     0,    54,    72,    -9,     0,   189,   576,   -90,     0,   -54,   -72, &
                   -9,     0,     0,   -72,    -9,     0,  -189,     9,    72,     0,     0,     9,   -90,     0,    54,    90]
  K1( 639,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576, &
                   72,     0,    27,    72,    72,    54,   216,    72,  -576,  -216,     0,    -9,    72,  -216,     0,   -90, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72]
  K1( 640,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728, &
                    0,    72,    72,    27,    54,    72,    72,   216,  -216,  -576,    -9,     0,  -216,    72,   -90,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,   -90,    72,     0]
  K1( 641,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1( 642,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1( 643,:) = [    72,     0,     0,   -72,    72,    54,     0,     9,    72,     0,    54,     9,     9,    27,    27,    72, &
                   72,     0,     0,   -72,   -72,  -216,  -216,  -576,    -9,    27,   -27,     9,   -90,  -216,   -27,   -72, &
                   -9,    27,    27,    90,    -9,   -27,    27,     9,    72,   216,   216,   576,   -90,   -27,  -216,   -72]
  K1( 644,:) = [     0,    72,   -72,     0,    54,    72,     9,     0,     0,    72,     9,    54,    27,     9,    72,    27, &
                    0,    72,   -72,     0,  -216,   -72,  -576,  -216,    27,    -9,     9,   -27,  -216,   -90,   -72,   -27, &
                   27,    -9,    90,    27,   -27,    -9,     9,    27,   216,    72,   576,   216,   -27,   -90,   -72,  -216]
  K1( 645,:) = [  -216,    -9,   -72,   -27,    27,    72,     9,   216,    27,    -9,     9,    27,     0,    90,    72,    54, &
                   27,    72,   -72,  -216,     0,     9,  -576,  -189,     0,   -90,   -72,   -54,     0,    -9,   576,   189, &
                    0,    72,     9,     0,     0,   -90,    90,    54,     0,    -9,   -72,     0,     0,    -9,     9,  -189]
  K1( 646,:) = [    -9,  -216,   -27,   -72,    72,    27,   216,     9,    -9,    27,    27,     9,    90,     0,    54,    72, &
                   72,    27,  -216,   -72,     9,     0,  -189,  -576,   -90,     0,   -54,   -72,    -9,     0,   189,   576, &
                   72,     0,     0,     9,   -90,     0,    54,    90,    -9,     0,     0,   -72,    -9,     0,  -189,     9]
  K1( 647,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,    27,    72,    72,    54,   216,    72, &
                   -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,  -216,     0,   -90,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,   -90,  -216,     0,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576]
  K1( 648,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,    72,    27,    54,    72,    72,   216, &
                    0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,  -216,    72,   -90,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,   -90,    72,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0]
  K1( 649,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,   -90,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,   -90,    72,  -216, -1728,  -576,  -576,  -189,   216,    72,    72,    54, &
                  216,    72,    72,    54,   -27,    -9,    -9,  -189,   -27,    -9,    -9,  -189,  -270,   -90,   -90,    54]
  K1( 650,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,  -216,   -90,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,   -90,     0,  -216,    72,  -576, -1728,  -189,  -576,    72,   216,    54,    72, &
                   72,   216,    54,    72,    -9,   -27,  -189,    -9,    -9,   -27,  -189,    -9,   -90,  -270,    54,   -90]
  K1( 651,:) = [    -9,  -216,   -27,   -72,    72,    27,   216,     9,    72,   216,   -27,   -72,   576,   189,     0,    -9, &
                   -9,   -27,   -27,     9,   -72,   -54,     0,   -90,  -576,  -189,     0,     9,    72,    54,     0,    90, &
                   72,     0,     0,     9,    -9,   189,     0,     9,    -9,     0,     0,   -72,   -90,   -54,     0,    90]
  K1( 652,:) = [  -216,    -9,   -72,   -27,    27,    72,     9,   216,   216,    72,   -72,   -27,   189,   576,    -9,     0, &
                  -27,    -9,     9,   -27,   -54,   -72,   -90,     0,  -189,  -576,     9,     0,    54,    72,    90,     0, &
                    0,    72,     9,     0,   189,    -9,     9,     0,     0,    -9,   -72,     0,   -54,   -90,    90,     0]
  K1( 653,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,   -90,    72,  -216, &
                    0,    72,   -90,  -216,     0,    -9,  -576,  -216,   216,    72,    72,    54, -1728,  -576,  -576,  -189, &
                  -27,    -9,    -9,  -189,  -270,   -90,   -90,    54,   216,    72,    72,    54,   -27,    -9,    -9,  -189]
  K1( 654,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,   -90,     0,  -216,    72, &
                   72,     0,  -216,   -90,    -9,     0,  -216,  -576,    72,   216,    54,    72,  -576, -1728,  -189,  -576, &
                   -9,   -27,  -189,    -9,   -90,  -270,    54,   -90,    72,   216,    54,    72,    -9,   -27,  -189,    -9]
  K1( 655,:) = [    72,    27,   216,     9,    -9,  -216,   -27,   -72,    -9,   -27,   -27,     9,   -72,   -54,     0,   -90, &
                   72,   216,   -27,   -72,   576,   189,     0,    -9,    72,    54,     0,    90,  -576,  -189,     0,     9, &
                   -9,     0,     0,   -72,   -90,   -54,     0,    90,    72,     0,     0,     9,    -9,   189,     0,     9]
  K1( 656,:) = [    27,    72,     9,   216,  -216,    -9,   -72,   -27,   -27,    -9,     9,   -27,   -54,   -72,   -90,     0, &
                  216,    72,   -72,   -27,   189,   576,    -9,     0,    54,    72,    90,     0,  -189,  -576,     9,     0, &
                    0,    -9,   -72,     0,   -54,   -90,    90,     0,     0,    72,     9,     0,   189,    -9,     9,     0]
  K1( 657,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 658,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 659,:) = [   -90,  -216,   -27,   -72,  -576,  -216,  -216,   -72,    72,   216,   216,   576,   -72,     0,     0,    72, &
                   72,   216,    27,    90,     9,     0,     0,    -9,    72,    54,     0,     9,    -9,  -189,     0,   -72, &
                   72,     0,     0,   -72,    -9,   -54,     0,   -72,    72,     0,     0,   -72,    72,   189,     0,     9]
  K1( 660,:) = [  -216,   -90,   -72,   -27,  -216,  -576,   -72,  -216,   216,    72,   576,   216,     0,   -72,    72,     0, &
                  216,    72,    90,    27,     0,     9,    -9,     0,    54,    72,     9,     0,  -189,    -9,   -72,     0, &
                    0,    72,   -72,     0,   -54,    -9,   -72,     0,     0,    72,   -72,     0,   189,    72,     9,     0]
  K1( 661,:) = [     0,    -9,    72,   -27,     0,   -90,    -9,   -27,     0,    -9,   -90,   -27,     0,    -9,    -9,  -216, &
                    0,    72,    -9,   -27,     0,   -90,   -90,  -216,   -27,    -9,    -9,   189,  -270,   -90,   -90,   -54, &
                  -27,    -9,    -9,   -54,   -27,    -9,    -9,   189,   216,    72,    72,   189,  -270,   -90,   -90,   -54]
  K1( 662,:) = [    -9,     0,   -27,    72,   -90,     0,   -27,    -9,    -9,     0,   -27,   -90,    -9,     0,  -216,    -9, &
                   72,     0,   -27,    -9,   -90,     0,  -216,   -90,    -9,   -27,   189,    -9,   -90,  -270,   -54,   -90, &
                   -9,   -27,   -54,    -9,    -9,   -27,   189,    -9,    72,   216,   189,    72,   -90,  -270,   -54,   -90]
  K1( 663,:) = [    -9,    27,    27,     9,    72,  -216,    27,   -72,    -9,   -27,  -216,   -72,     9,  -189,     0,  -576, &
                   72,   216,    27,     9,    90,    54,     0,    72,    -9,  -189,     0,     9,   -90,    54,     0,    90, &
                   -9,     0,     0,   -72,    -9,   189,     0,   576,    72,     0,     0,     9,   -90,   -54,     0,   -72]
  K1( 664,:) = [    27,    -9,     9,    27,  -216,    72,   -72,    27,   -27,    -9,   -72,  -216,  -189,     9,  -576,     0, &
                  216,    72,     9,    27,    54,    90,    72,     0,  -189,    -9,     9,     0,    54,   -90,    90,     0, &
                    0,    -9,   -72,     0,   189,    -9,   576,     0,     0,    72,     9,     0,   -54,   -90,   -72,     0]
  K1( 665,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1( 666,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1( 667,:) = [  -576,  -216,  -216,   -72,   -90,  -216,   -27,   -72,    72,   216,    27,    90,     9,     0,     0,    -9, &
                   72,   216,   216,   576,   -72,     0,     0,    72,    -9,  -189,     0,   -72,    72,    54,     0,     9, &
                   72,     0,     0,   -72,    72,   189,     0,     9,    72,     0,     0,   -72,    -9,   -54,     0,   -72]
  K1( 668,:) = [  -216,  -576,   -72,  -216,  -216,   -90,   -72,   -27,   216,    72,    90,    27,     0,     9,    -9,     0, &
                  216,    72,   576,   216,     0,   -72,    72,     0,  -189,    -9,   -72,     0,    54,    72,     9,     0, &
                    0,    72,   -72,     0,   189,    72,     9,     0,     0,    72,   -72,     0,   -54,    -9,   -72,     0]
  K1( 669,:) = [     0,   -90,    -9,   -27,     0,    -9,    72,   -27,     0,    72,    -9,   -27,     0,   -90,   -90,  -216, &
                    0,    -9,   -90,   -27,     0,    -9,    -9,  -216,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   189, &
                  216,    72,    72,   189,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   -54,   -27,    -9,    -9,   189]
  K1( 670,:) = [   -90,     0,   -27,    -9,    -9,     0,   -27,    72,    72,     0,   -27,    -9,   -90,     0,  -216,   -90, &
                   -9,     0,   -27,   -90,    -9,     0,  -216,    -9,   -90,  -270,   -54,   -90,    -9,   -27,   189,    -9, &
                   72,   216,   189,    72,   -90,  -270,   -54,   -90,    -9,   -27,   -54,    -9,    -9,   -27,   189,    -9]
  K1( 671,:) = [    72,  -216,    27,   -72,    -9,    27,    27,     9,    72,   216,    27,     9,    90,    54,     0,    72, &
                   -9,   -27,  -216,   -72,     9,  -189,     0,  -576,   -90,    54,     0,    90,    -9,  -189,     0,     9, &
                   72,     0,     0,     9,   -90,   -54,     0,   -72,    -9,     0,     0,   -72,    -9,   189,     0,   576]
  K1( 672,:) = [  -216,    72,   -72,    27,    27,    -9,     9,    27,   216,    72,     9,    27,    54,    90,    72,     0, &
                  -27,    -9,   -72,  -216,  -189,     9,  -576,     0,    54,   -90,    90,     0,  -189,    -9,     9,     0, &
                    0,    72,     9,     0,   -54,   -90,   -72,     0,     0,    -9,   -72,     0,   189,    -9,   576,     0]
  K1( 673,:) = [     0,     9,  -576,  -189,   189,   576,    -9,     0,     0,     9,    72,     0,    27,    72,     9,   216, &
                    0,   -72,    -9,     0,  -216,    -9,   -72,   -27,   -27,   -72,    -9,  -216,   216,     9,    72,    27, &
                  -27,   -72,    72,   216,    27,     9,    72,   -27,  -216,   -72,    72,    27,    27,   -72,    -9,   -27]
  K1( 674,:) = [     9,     0,  -189,  -576,   576,   189,     0,    -9,     9,     0,     0,    72,    72,    27,   216,     9, &
                  -72,     0,     0,    -9,    -9,  -216,   -27,   -72,   -72,   -27,  -216,    -9,     9,   216,    27,    72, &
                  -72,   -27,   216,    72,     9,    27,   -27,    72,   -72,  -216,    27,    72,   -72,    27,   -27,    -9]
  K1( 675,:) = [  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    72,    54,   216,    72,    72,     0,    27,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                  -90,  -216,     0,    72,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,    72,  -216,     0,   -90]
  K1( 676,:) = [  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    54,    72,    72,   216,     0,    72,    72,    27, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,   -90,    72,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,    72,   -90,     0]
  K1( 677,:) = [   189,   576,    -9,     0,     0,     9,  -576,  -189,     0,   -72,    -9,     0,  -216,    -9,   -72,   -27, &
                    0,     9,    72,     0,    27,    72,     9,   216,   216,     9,    72,    27,   -27,   -72,    -9,  -216, &
                 -216,   -72,    72,    27,    27,   -72,    -9,   -27,   -27,   -72,    72,   216,    27,     9,    72,   -27]
  K1( 678,:) = [   576,   189,     0,    -9,     9,     0,  -189,  -576,   -72,     0,     0,    -9,    -9,  -216,   -27,   -72, &
                    9,     0,     0,    72,    72,    27,   216,     9,     9,   216,    27,    72,   -72,   -27,  -216,    -9, &
                  -72,  -216,    27,    72,   -72,    27,   -27,    -9,   -72,   -27,   216,    72,     9,    27,   -27,    72]
  K1( 679,:) = [    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   72,    54,   216,    72,    72,     0,    27,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,    72,  -216,     0,   -90,   -90,  -216,     0,    72,    -9,    27,     0,    -9]
  K1( 680,:) = [     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                   54,    72,    72,   216,     0,    72,    72,    27,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,    72,   -90,     0,  -216,   -90,    72,     0,    27,    -9,    -9,     0]
  K1( 681,:) = [     0,     9,    72,    54,     0,   -72,    72,     0,     0,   -72,    72,     0,  -216,  -576,   -72,  -216, &
                   54,     9,    72,     0,    27,    72,     9,    27,   -27,   -72,   -90,  -216,   -27,     9,    -9,    27, &
                  216,   576,    72,   216,  -216,   -72,   -90,   -27,    27,    90,    -9,    27,    27,     9,    -9,   -27]
  K1( 682,:) = [     9,     0,    54,    72,   -72,     0,     0,    72,   -72,     0,     0,    72,  -576,  -216,  -216,   -72, &
                    9,    54,     0,    72,    72,    27,    27,     9,   -72,   -27,  -216,   -90,     9,   -27,    27,    -9, &
                  576,   216,   216,    72,   -72,  -216,   -27,   -90,    90,    27,    27,    -9,     9,    27,   -27,    -9]
  K1( 683,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 684,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 685,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189, &
                   27,    72,    72,     0,   216,    72,    72,    54,     0,    -9,  -576,  -216,     0,   -90,    72,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,    72,   -90,  -216]
  K1( 686,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576, &
                   72,    27,     0,    72,    72,   216,    54,    72,    -9,     0,  -216,  -576,   -90,     0,  -216,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90]
  K1( 687,:) = [     9,   216,    27,    72,   -72,   -27,  -216,    -9,   -72,  -216,    27,    72,  -576,  -189,     0,     9, &
                    9,    27,    27,    -9,    72,    54,     0,    90,   576,   189,     0,    -9,   -72,   -54,     0,   -90, &
                  -72,     0,     0,    -9,     9,  -189,     0,    -9,     9,     0,     0,    72,    90,    54,     0,   -90]
  K1( 688,:) = [   216,     9,    72,    27,   -27,   -72,    -9,  -216,  -216,   -72,    72,    27,  -189,  -576,     9,     0, &
                   27,     9,    -9,    27,    54,    72,    90,     0,   189,   576,    -9,     0,   -54,   -72,   -90,     0, &
                    0,   -72,    -9,     0,  -189,     9,    -9,     0,     0,     9,    72,     0,    54,    90,   -90,     0]
  K1( 689,:) = [     0,   -72,    72,     0,     0,     9,    72,    54,    54,     9,    72,     0,    27,    72,     9,    27, &
                    0,   -72,    72,     0,  -216,  -576,   -72,  -216,   -27,     9,    -9,    27,   -27,   -72,   -90,  -216, &
                   27,    90,    -9,    27,    27,     9,    -9,   -27,   216,   576,    72,   216,  -216,   -72,   -90,   -27]
  K1( 690,:) = [   -72,     0,     0,    72,     9,     0,    54,    72,     9,    54,     0,    72,    72,    27,    27,     9, &
                  -72,     0,     0,    72,  -576,  -216,  -216,   -72,     9,   -27,    27,    -9,   -72,   -27,  -216,   -90, &
                   90,    27,    27,    -9,     9,    27,   -27,    -9,   576,   216,   216,    72,   -72,  -216,   -27,   -90]
  K1( 691,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1( 692,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1( 693,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,    27,    72,    72,     0,   216,    72,    72,    54, &
                 -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,     0,   -90,    72,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,    72,   -90,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216]
  K1( 694,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,    72,    27,     0,    72,    72,   216,    54,    72, &
                 -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,   -90,     0,  -216,    72,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,    72,     0,  -216,   -90,    72,     0,    27,    72,  -576,     0,  -216,    -9]
  K1( 695,:) = [   -72,   -27,  -216,    -9,     9,   216,    27,    72,     9,    27,    27,    -9,    72,    54,     0,    90, &
                  -72,  -216,    27,    72,  -576,  -189,     0,     9,   -72,   -54,     0,   -90,   576,   189,     0,    -9, &
                    9,     0,     0,    72,    90,    54,     0,   -90,   -72,     0,     0,    -9,     9,  -189,     0,    -9]
  K1( 696,:) = [   -27,   -72,    -9,  -216,   216,     9,    72,    27,    27,     9,    -9,    27,    54,    72,    90,     0, &
                 -216,   -72,    72,    27,  -189,  -576,     9,     0,   -54,   -72,   -90,     0,   189,   576,    -9,     0, &
                    0,     9,    72,     0,    54,    90,   -90,     0,     0,   -72,    -9,     0,  -189,     9,    -9,     0]
  K1( 697,:) = [   -27,   -72,    -9,  -216,   216,     9,    72,    27,   -27,   -72,    72,   216,     0,    -9,   576,   189, &
                  -27,     9,    -9,   -27,     0,   -90,   -72,   -54,     0,     9,  -576,  -189,     0,    90,    72,    54, &
                    0,     9,    72,     0,     0,     9,    -9,   189,     0,   -72,    -9,     0,     0,    90,   -90,   -54]
  K1( 698,:) = [   -72,   -27,  -216,    -9,     9,   216,    27,    72,   -72,   -27,   216,    72,    -9,     0,   189,   576, &
                    9,   -27,   -27,    -9,   -90,     0,   -54,   -72,     9,     0,  -189,  -576,    90,     0,    54,    72, &
                    9,     0,     0,    72,     9,     0,   189,    -9,   -72,     0,     0,    -9,    90,     0,   -54,   -90]
  K1( 699,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,   -90,  -216,     0,    72,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,    72,  -216,     0,   -90,  -576,  -189, -1728,  -576,    72,    54,   216,    72, &
                   72,    54,   216,    72,    -9,  -189,   -27,    -9,    -9,  -189,   -27,    -9,   -90,    54,  -270,   -90]
  K1( 700,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,   -90,    72,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,    72,   -90,     0,  -189,  -576,  -576, -1728,    54,    72,    72,   216, &
                   54,    72,    72,   216,  -189,    -9,    -9,   -27,  -189,    -9,    -9,   -27,    54,   -90,   -90,  -270]
  K1( 701,:) = [   216,     9,    72,    27,   -27,   -72,    -9,  -216,   -27,     9,    -9,   -27,     0,   -90,   -72,   -54, &
                  -27,   -72,    72,   216,     0,    -9,   576,   189,     0,    90,    72,    54,     0,     9,  -576,  -189, &
                    0,   -72,    -9,     0,     0,    90,   -90,   -54,     0,     9,    72,     0,     0,     9,    -9,   189]
  K1( 702,:) = [     9,   216,    27,    72,   -72,   -27,  -216,    -9,     9,   -27,   -27,    -9,   -90,     0,   -54,   -72, &
                  -72,   -27,   216,    72,    -9,     0,   189,   576,    90,     0,    54,    72,     9,     0,  -189,  -576, &
                  -72,     0,     0,    -9,    90,     0,   -54,   -90,     9,     0,     0,    72,     9,     0,   189,    -9]
  K1( 703,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,    72,  -216,     0,   -90, &
                  -90,  -216,     0,    72,  -576,  -216,     0,    -9,    72,    54,   216,    72,  -576,  -189, -1728,  -576, &
                   -9,  -189,   -27,    -9,   -90,    54,  -270,   -90,    72,    54,   216,    72,    -9,  -189,   -27,    -9]
  K1( 704,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,    72,   -90,     0, &
                 -216,   -90,    72,     0,  -216,  -576,    -9,     0,    54,    72,    72,   216,  -189,  -576,  -576, -1728, &
                 -189,    -9,    -9,   -27,    54,   -90,   -90,  -270,    54,    72,    72,   216,  -189,    -9,    -9,   -27]
  K1( 705,:) = [   -27,   -72,   -90,  -216,  -216,   -72,  -576,  -216,   216,   576,    72,   216,     0,    72,   -72,     0, &
                   27,    90,    72,   216,     0,    -9,     9,     0,     0,     9,    72,    54,     0,   -72,    -9,  -189, &
                    0,   -72,    72,     0,     0,   -72,    -9,   -54,     0,   -72,    72,     0,     0,     9,    72,   189]
  K1( 706,:) = [   -72,   -27,  -216,   -90,   -72,  -216,  -216,  -576,   576,   216,   216,    72,    72,     0,     0,   -72, &
                   90,    27,   216,    72,    -9,     0,     0,     9,     9,     0,    54,    72,   -72,     0,  -189,    -9, &
                  -72,     0,     0,    72,   -72,     0,   -54,    -9,   -72,     0,     0,    72,     9,     0,   189,    72]
  K1( 707,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 708,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 709,:) = [    27,     9,    -9,    27,    27,   -72,    72,  -216,  -216,   -72,    -9,   -27,     0,  -576,     9,  -189, &
                   27,     9,    72,   216,     0,    72,    90,    54,     0,     9,    -9,  -189,     0,    90,   -90,    54, &
                    0,   -72,    -9,     0,     0,   576,    -9,   189,     0,     9,    72,     0,     0,   -72,   -90,   -54]
  K1( 710,:) = [     9,    27,    27,    -9,   -72,    27,  -216,    72,   -72,  -216,   -27,    -9,  -576,     0,  -189,     9, &
                    9,    27,   216,    72,    72,     0,    54,    90,     9,     0,  -189,    -9,    90,     0,    54,   -90, &
                  -72,     0,     0,    -9,   576,     0,   189,    -9,     9,     0,     0,    72,   -72,     0,   -54,   -90]
  K1( 711,:) = [    72,   -27,     0,    -9,    -9,   -27,     0,   -90,   -90,   -27,     0,    -9,    -9,  -216,     0,    -9, &
                   -9,   -27,     0,    72,   -90,  -216,     0,   -90,    -9,   189,   -27,    -9,   -90,   -54,  -270,   -90, &
                   -9,   -54,   -27,    -9,    -9,   189,   -27,    -9,    72,   189,   216,    72,   -90,   -54,  -270,   -90]
  K1( 712,:) = [   -27,    72,    -9,     0,   -27,    -9,   -90,     0,   -27,   -90,    -9,     0,  -216,    -9,    -9,     0, &
                  -27,    -9,    72,     0,  -216,   -90,   -90,     0,   189,    -9,    -9,   -27,   -54,   -90,   -90,  -270, &
                  -54,    -9,    -9,   -27,   189,    -9,    -9,   -27,   189,    72,    72,   216,   -54,   -90,   -90,  -270]
  K1( 713,:) = [  -216,   -72,  -576,  -216,   -27,   -72,   -90,  -216,    27,    90,    72,   216,     0,    -9,     9,     0, &
                  216,   576,    72,   216,     0,    72,   -72,     0,     0,   -72,    -9,  -189,     0,     9,    72,    54, &
                    0,   -72,    72,     0,     0,     9,    72,   189,     0,   -72,    72,     0,     0,   -72,    -9,   -54]
  K1( 714,:) = [   -72,  -216,  -216,  -576,   -72,   -27,  -216,   -90,    90,    27,   216,    72,    -9,     0,     0,     9, &
                  576,   216,   216,    72,    72,     0,     0,   -72,   -72,     0,  -189,    -9,     9,     0,    54,    72, &
                  -72,     0,     0,    72,     9,     0,   189,    72,   -72,     0,     0,    72,   -72,     0,   -54,    -9]
  K1( 715,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1( 716,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1( 717,:) = [    27,   -72,    72,  -216,    27,     9,    -9,    27,    27,     9,    72,   216,     0,    72,    90,    54, &
                 -216,   -72,    -9,   -27,     0,  -576,     9,  -189,     0,    90,   -90,    54,     0,     9,    -9,  -189, &
                    0,     9,    72,     0,     0,   -72,   -90,   -54,     0,   -72,    -9,     0,     0,   576,    -9,   189]
  K1( 718,:) = [   -72,    27,  -216,    72,     9,    27,    27,    -9,     9,    27,   216,    72,    72,     0,    54,    90, &
                  -72,  -216,   -27,    -9,  -576,     0,  -189,     9,    90,     0,    54,   -90,     9,     0,  -189,    -9, &
                    9,     0,     0,    72,   -72,     0,   -54,   -90,   -72,     0,     0,    -9,   576,     0,   189,    -9]
  K1( 719,:) = [    -9,   -27,     0,   -90,    72,   -27,     0,    -9,    -9,   -27,     0,    72,   -90,  -216,     0,   -90, &
                  -90,   -27,     0,    -9,    -9,  -216,     0,    -9,   -90,   -54,  -270,   -90,    -9,   189,   -27,    -9, &
                   72,   189,   216,    72,   -90,   -54,  -270,   -90,    -9,   -54,   -27,    -9,    -9,   189,   -27,    -9]
  K1( 720,:) = [   -27,    -9,   -90,     0,   -27,    72,    -9,     0,   -27,    -9,    72,     0,  -216,   -90,   -90,     0, &
                  -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -54,   -90,   -90,  -270,   189,    -9,    -9,   -27, &
                  189,    72,    72,   216,   -54,   -90,   -90,  -270,   -54,    -9,    -9,   -27,   189,    -9,    -9,   -27]
  K1( 721,:) = [  3456,  1152,  1152,   378,   432,  1152,    18,     0,  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,  -144,   180,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,   180,  -144,   432]
  K1( 722,:) = [  1152,  3456,   378,  1152,  1152,   432,     0,    18,  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 -144,     0,   432,   180,    18,     0,   -54,    18,    18,     0,   432,  1152,   180,     0,   432,  -144]
  K1( 723,:) = [  1152,   378,  3456,  1152,    18,     0,   432,  1152,  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                  180,   432,     0,  -144,    18,   -54,     0,    18,  1152,   432,     0,    18,  -144,   432,     0,   180]
  K1( 724,:) = [   378,  1152,  1152,  3456,     0,    18,  1152,   432,  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,   180,  -144,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,  -144,   180,     0]
  K1( 725,:) = [   432,  1152,    18,     0,  3456,  1152,  1152,   378,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                 -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,   180,  -144,   432,     0,  -144,   180,   432,     0,    18,    18,   -54]
  K1( 726,:) = [  1152,   432,     0,    18,  1152,  3456,   378,  1152,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,   180,     0,   432,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18]
  K1( 727,:) = [    18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                 -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,  -144,   432,     0,   180,   180,   432,     0,  -144,    18,   -54,     0,    18]
  K1( 728,:) = [     0,    18,  1152,   432,   378,  1152,  1152,  3456,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                 -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,  -144,   180,     0,   432,   180,  -144,     0,   -54,    18,    18,     0]
  K1( 729,:) = [  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,  3456,  1152,  1152,   378,   432,  1152,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,     0,  -144,   180,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,   180,  -144,   432,     0,    18,  1152,   432]
  K1( 730,:) = [  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  1152,  3456,   378,  1152,  1152,   432,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,     0,   432,  -144,    18,     0,   432,  1152]
  K1( 731,:) = [  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  1152,   378,  3456,  1152,    18,     0,   432,  1152, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,   432,     0,  -144,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   432,     0,   180,  1152,   432,     0,    18]
  K1( 732,:) = [  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   378,  1152,  1152,  3456,     0,    18,  1152,   432, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,   432,   180,  -144,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,  -144,   180,     0,   432,  1152,    18,     0]
  K1( 733,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   432,  1152,    18,     0,  3456,  1152,  1152,   378, &
                  -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,     0,    18,  1152,   432,     0,   180,  -144,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,  -144,   180,   432]
  K1( 734,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,   432,     0,    18,  1152,  3456,   378,  1152, &
                 -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,     0,   432,  1152,   180,     0,   432,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,  -144,     0,   432,   180]
  K1( 735,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   432,  1152,  1152,   378,  3456,  1152, &
                 -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,   432,     0,    18,  -144,   432,     0,   180, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144]
  K1( 736,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,  1152,   432,   378,  1152,  1152,  3456, &
                    0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,   432,  1152,    18,     0,   432,  -144,   180,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,   180,  -144,     0]
  K1( 737,:) = [   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                 3456,  1152,  1152,   378,   432,  1152,    18,     0,     0,    18,    18,   -54,     0,  -144,   180,   432, &
                    0,   180,  -144,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54]
  K1( 738,:) = [  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 1152,  3456,   378,  1152,  1152,   432,     0,    18,    18,     0,   -54,    18,  -144,     0,   432,   180, &
                  180,     0,   432,  -144,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144]
  K1( 739,:) = [  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 1152,   378,  3456,  1152,    18,     0,   432,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144, &
                 -144,   432,     0,   180,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144]
  K1( 740,:) = [     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                  378,  1152,  1152,  3456,     0,    18,  1152,   432,   -54,    18,    18,     0,   432,   180,  -144,     0, &
                  432,  -144,   180,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0]
  K1( 741,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108, &
                  432,  1152,    18,     0,  3456,  1152,  1152,   378,     0,   180,  -144,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,  -144,   180,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432]
  K1( 742,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144, &
                 1152,   432,     0,    18,  1152,  3456,   378,  1152,   180,     0,   432,  -144,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,  -144,     0,   432,   180,  -144,     0,   -54,  -144,  1152,     0,   432,    18]
  K1( 743,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144, &
                   18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,   432,     0,   180,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,   180,   432,     0,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152]
  K1( 744,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432, &
                    0,    18,  1152,   432,   378,  1152,  1152,  3456,   432,  -144,   180,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,   180,  -144,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0]
  K1( 745,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,   180,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,   180,  -144,   432,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108, &
                 -432,  -144,  -144,  -108,    54,    18,    18,   378,    54,    18,    18,   378,   540,   180,   180,  -108]
  K1( 746,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   432,   180,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,   180,     0,   432,  -144,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144, &
                 -144,  -432,  -108,  -144,    18,    54,   378,    18,    18,    54,   378,    18,   180,   540,  -108,   180]
  K1( 747,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,   180,   432,     0,  -144,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,  -144,   432,     0,   180,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144, &
                 -144,  -108,  -432,  -144,    18,   378,    54,    18,    18,   378,    54,    18,   180,  -108,   540,   180]
  K1( 748,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,   180,  -144,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,  -144,   180,     0,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432, &
                 -108,  -144,  -144,  -432,   378,    18,    18,    54,   378,    18,    18,    54,  -108,   180,   180,   540]
  K1( 749,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,   180,  -144,   432, &
                    0,  -144,   180,   432,     0,    18,  1152,   432,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378, &
                   54,    18,    18,   378,   540,   180,   180,  -108,  -432,  -144,  -144,  -108,    54,    18,    18,   378]
  K1( 750,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,   180,     0,   432,  -144, &
                 -144,     0,   432,   180,    18,     0,   432,  1152,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152, &
                   18,    54,   378,    18,   180,   540,  -108,   180,  -144,  -432,  -108,  -144,    18,    54,   378,    18]
  K1( 751,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,  -144,   432,     0,   180, &
                  180,   432,     0,  -144,  1152,   432,     0,    18,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152, &
                   18,   378,    54,    18,   180,  -108,   540,   180,  -144,  -108,  -432,  -144,    18,   378,    54,    18]
  K1( 752,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,  -144,   180,     0, &
                  432,   180,  -144,     0,   432,  1152,    18,     0,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456, &
                  378,    18,    18,    54,  -108,   180,   180,   540,  -108,  -144,  -144,  -432,   378,    18,    18,    54]
  K1( 753,:) = [     0,  -144,   180,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,   180,  -144,   432,     0,    18,    18,   -54,  -432,  -144,  -144,  -108,    54,    18,    18,   378, &
                 3456,  1152,  1152,   378,  -432,  -144,  -144,  -108,   540,   180,   180,  -108,    54,    18,    18,   378]
  K1( 754,:) = [  -144,     0,   432,   180,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                  180,     0,   432,  -144,    18,     0,   -54,    18,  -144,  -432,  -108,  -144,    18,    54,   378,    18, &
                 1152,  3456,   378,  1152,  -144,  -432,  -108,  -144,   180,   540,  -108,   180,    18,    54,   378,    18]
  K1( 755,:) = [   180,   432,     0,  -144,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 -144,   432,     0,   180,    18,   -54,     0,    18,  -144,  -108,  -432,  -144,    18,   378,    54,    18, &
                 1152,   378,  3456,  1152,  -144,  -108,  -432,  -144,   180,  -108,   540,   180,    18,   378,    54,    18]
  K1( 756,:) = [   432,   180,  -144,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,  -144,   180,     0,   -54,    18,    18,     0,  -108,  -144,  -144,  -432,   378,    18,    18,    54, &
                  378,  1152,  1152,  3456,  -108,  -144,  -144,  -432,  -108,   180,   180,   540,   378,    18,    18,    54]
  K1( 757,:) = [     0,    18,    18,   -54,     0,   180,  -144,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,  -144,   180,   432,    54,    18,    18,   378,   540,   180,   180,  -108, &
                 -432,  -144,  -144,  -108,  3456,  1152,  1152,   378,    54,    18,    18,   378,  -432,  -144,  -144,  -108]
  K1( 758,:) = [    18,     0,   -54,    18,   180,     0,   432,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,  -144,     0,   432,   180,    18,    54,   378,    18,   180,   540,  -108,   180, &
                 -144,  -432,  -108,  -144,  1152,  3456,   378,  1152,    18,    54,   378,    18,  -144,  -432,  -108,  -144]
  K1( 759,:) = [    18,   -54,     0,    18,  -144,   432,     0,   180,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,   180,   432,     0,  -144,    18,   378,    54,    18,   180,  -108,   540,   180, &
                 -144,  -108,  -432,  -144,  1152,   378,  3456,  1152,    18,   378,    54,    18,  -144,  -108,  -432,  -144]
  K1( 760,:) = [   -54,    18,    18,     0,   432,  -144,   180,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,   180,  -144,     0,   378,    18,    18,    54,  -108,   180,   180,   540, &
                 -108,  -144,  -144,  -432,   378,  1152,  1152,  3456,   378,    18,    18,    54,  -108,  -144,  -144,  -432]
  K1( 761,:) = [     0,    18,  1152,   432,     0,  -144,   180,   432,     0,   180,  -144,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,    54,    18,    18,   378,  -432,  -144,  -144,  -108, &
                  540,   180,   180,  -108,    54,    18,    18,   378,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108]
  K1( 762,:) = [    18,     0,   432,  1152,  -144,     0,   432,   180,   180,     0,   432,  -144,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,    18,    54,   378,    18,  -144,  -432,  -108,  -144, &
                  180,   540,  -108,   180,    18,    54,   378,    18,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144]
  K1( 763,:) = [  1152,   432,     0,    18,   180,   432,     0,  -144,  -144,   432,     0,   180,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,    18,   378,    54,    18,  -144,  -108,  -432,  -144, &
                  180,  -108,   540,   180,    18,   378,    54,    18,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144]
  K1( 764,:) = [   432,  1152,    18,     0,   432,   180,  -144,     0,   432,  -144,   180,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   378,    18,    18,    54,  -108,  -144,  -144,  -432, &
                 -108,   180,   180,   540,   378,    18,    18,    54,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432]
  K1( 765,:) = [     0,   180,  -144,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,  -144,   180,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   540,   180,   180,  -108,    54,    18,    18,   378, &
                   54,    18,    18,   378,  -432,  -144,  -144,  -108,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378]
  K1( 766,:) = [   180,     0,   432,  -144,    18,     0,   -54,    18,    18,     0,   432,  1152,  -144,     0,   432,   180, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,   180,   540,  -108,   180,    18,    54,   378,    18, &
                   18,    54,   378,    18,  -144,  -432,  -108,  -144,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152]
  K1( 767,:) = [  -144,   432,     0,   180,    18,   -54,     0,    18,  1152,   432,     0,    18,   180,   432,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,   180,  -108,   540,   180,    18,   378,    54,    18, &
                   18,   378,    54,    18,  -144,  -108,  -432,  -144,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152]
  K1( 768,:) = [   432,  -144,   180,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,   180,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,  -108,   180,   180,   540,   378,    18,    18,    54, &
                  378,    18,    18,    54,  -108,  -144,  -144,  -432,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456]
  K1( 769,:) = [ -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,   216,    72,    72,    54,    27,    72,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,    72,   -90,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,   -90,    72,  -216]
  K1( 770,:) = [  -576,     0,  -189,     9,   -72,  -216,   -27,    -9,    72,     0,     0,     9,    -9,     0,     0,   -72, &
                    9,    27,   216,    72,    -9,   189,     0,   576,    72,  -216,    27,   -72,    72,   216,    27,     9, &
                   -9,    27,   -27,   -72,    72,    27,   -27,     9,    -9,   -27,  -216,   -72,    72,   -27,   216,   -72]
  K1( 771,:) = [  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    72,    54,   216,    72,    72,     0,    27,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                  -90,  -216,     0,    72,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,    72,  -216,     0,   -90]
  K1( 772,:) = [  -189,     9,  -576,     0,   -27,    -9,   -72,  -216,     0,     9,    72,     0,     0,   -72,    -9,     0, &
                  216,    72,     9,    27,     0,   576,    -9,   189,    27,   -72,    72,  -216,    27,     9,    72,   216, &
                  -27,   -72,    -9,    27,   -27,     9,    72,    27,  -216,   -72,    -9,   -27,   216,   -72,    72,   -27]
  K1( 773,:) = [  -216,   -72,    -9,   -27,     0,  -576,     9,  -189,    27,     9,    -9,    27,    27,   -72,    72,  -216, &
                    0,    72,    90,    54,    27,     9,    72,   216,     0,   -72,    -9,     0,     0,   576,    -9,   189, &
                    0,     9,    -9,  -189,     0,    90,   -90,    54,     0,   -72,   -90,   -54,     0,     9,    72,     0]
  K1( 774,:) = [  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                   72,   216,    54,    72,    72,    27,     0,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,   -90,     0,  -216,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9]
  K1( 775,:) = [    -9,   -27,  -216,   -72,     9,  -189,     0,  -576,    -9,    27,    27,     9,    72,  -216,    27,   -72, &
                   90,    54,     0,    72,    72,   216,    27,     9,    -9,     0,     0,   -72,    -9,   189,     0,   576, &
                   -9,  -189,     0,     9,   -90,    54,     0,    90,   -90,   -54,     0,   -72,    72,     0,     0,     9]
  K1( 776,:) = [     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                   54,    72,    72,   216,     0,    72,    72,    27,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,    72,   -90,     0,  -216,   -90,    72,     0,    27,    -9,    -9,     0]
  K1( 777,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 778,:) = [    72,     0,    54,     9,     9,    27,    27,    72,    72,     0,     0,   -72,    72,    54,     0,     9, &
                  -72,  -216,  -216,  -576,    72,     0,     0,   -72,    -9,    27,    27,    90,    -9,   -27,    27,     9, &
                   -9,    27,   -27,     9,   -90,  -216,   -27,   -72,   -90,   -27,  -216,   -72,    72,   216,   216,   576]
  K1( 779,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 780,:) = [    54,     9,    72,     0,    27,    72,     9,    27,     0,   -72,    72,     0,     0,     9,    72,    54, &
                 -216,  -576,   -72,  -216,     0,   -72,    72,     0,    27,    90,    -9,    27,    27,     9,    -9,   -27, &
                  -27,     9,    -9,    27,   -27,   -72,   -90,  -216,  -216,   -72,   -90,   -27,   216,   576,    72,   216]
  K1( 781,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1( 782,:) = [    72,     0,     0,   -72,   -72,  -216,  -216,  -576,    72,    54,     0,     9,    72,     0,     0,   -72, &
                    9,    27,    27,    72,    72,     0,    54,     9,    72,   216,   216,   576,   -90,   -27,  -216,   -72, &
                  -90,  -216,   -27,   -72,    -9,    27,   -27,     9,    -9,   -27,    27,     9,    -9,    27,    27,    90]
  K1( 783,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1( 784,:) = [     0,   -72,    72,     0,  -216,  -576,   -72,  -216,     0,     9,    72,    54,     0,   -72,    72,     0, &
                   27,    72,     9,    27,    54,     9,    72,     0,   216,   576,    72,   216,  -216,   -72,   -90,   -27, &
                  -27,   -72,   -90,  -216,   -27,     9,    -9,    27,    27,     9,    -9,   -27,    27,    90,    -9,    27]
  K1( 785,:) = [    27,     9,    72,   216,     0,    72,    90,    54,    27,   -72,    72,  -216,    27,     9,    -9,    27, &
                    0,  -576,     9,  -189,  -216,   -72,    -9,   -27,     0,     9,    72,     0,     0,   -72,   -90,   -54, &
                    0,    90,   -90,    54,     0,     9,    -9,  -189,     0,   576,    -9,   189,     0,   -72,    -9,     0]
  K1( 786,:) = [    72,    27,     0,    72,    72,   216,    54,    72,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                 -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90, &
                  -90,     0,  -216,    72,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72]
  K1( 787,:) = [    72,   216,    27,     9,    90,    54,     0,    72,    72,  -216,    27,   -72,    -9,    27,    27,     9, &
                    9,  -189,     0,  -576,    -9,   -27,  -216,   -72,    72,     0,     0,     9,   -90,   -54,     0,   -72, &
                  -90,    54,     0,    90,    -9,  -189,     0,     9,    -9,   189,     0,   576,    -9,     0,     0,   -72]
  K1( 788,:) = [     0,    72,    72,    27,    54,    72,    72,   216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                 -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    27,    -9,    -9,     0,  -216,   -90,    72,     0, &
                 -216,    72,   -90,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0]
  K1( 789,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,    27,    72,    72,     0,   216,    72,    72,    54, &
                 -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,     0,   -90,    72,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,    72,   -90,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216]
  K1( 790,:) = [    -9,   189,     0,   576,     9,    27,   216,    72,    -9,     0,     0,   -72,    72,     0,     0,     9, &
                  -72,  -216,   -27,    -9,  -576,     0,  -189,     9,    72,   -27,   216,   -72,    -9,   -27,  -216,   -72, &
                   72,    27,   -27,     9,    -9,    27,   -27,   -72,    72,   216,    27,     9,    72,  -216,    27,   -72]
  K1( 791,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,    27,    72,    72,    54,   216,    72, &
                   -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,  -216,     0,   -90,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,   -90,  -216,     0,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576]
  K1( 792,:) = [     0,   576,    -9,   189,   216,    72,     9,    27,     0,   -72,    -9,     0,     0,     9,    72,     0, &
                  -27,    -9,   -72,  -216,  -189,     9,  -576,     0,   216,   -72,    72,   -27,  -216,   -72,    -9,   -27, &
                  -27,     9,    72,    27,   -27,   -72,    -9,    27,    27,     9,    72,   216,    27,   -72,    72,  -216]
  K1( 793,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1( 794,:) = [  -576,  -216,  -216,   -72,   -72,     0,     0,    72,    72,    27,   216,    90,    72,   216,   216,   576, &
                    9,     0,     0,    -9,   -90,   -27,  -216,   -72,    72,     0,     0,   -72,    72,     0,    54,     9, &
                   -9,     0,   -54,   -72,    72,     0,   189,     9,    -9,     0,  -189,   -72,    72,     0,     0,   -72]
  K1( 795,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1( 796,:) = [  -216,   -72,  -576,  -216,     0,    72,   -72,     0,   216,    90,    72,    27,   216,   576,    72,   216, &
                    0,    -9,     9,     0,  -216,   -72,   -90,   -27,     0,   -72,    72,     0,    54,     9,    72,     0, &
                  -54,   -72,    -9,     0,   189,     9,    72,     0,  -189,   -72,    -9,     0,     0,   -72,    72,     0]
  K1( 797,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,   -90,    72,  -216, &
                    0,    72,   -90,  -216,     0,    -9,  -576,  -216,   216,    72,    72,    54, -1728,  -576,  -576,  -189, &
                  -27,    -9,    -9,  -189,  -270,   -90,   -90,    54,   216,    72,    72,    54,   -27,    -9,    -9,  -189]
  K1( 798,:) = [    72,   216,    27,     9,   576,     0,   189,    -9,    -9,   -27,   -27,     9,    72,   -27,   216,   -72, &
                  -72,     0,   -54,   -90,    -9,   -27,  -216,   -72,    72,     0,     0,     9,  -576,     0,  -189,     9, &
                   -9,     0,   189,     9,   -90,     0,   -54,    90,    72,     0,    54,    90,    -9,     0,     0,   -72]
  K1( 799,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,    72,  -216,     0,   -90, &
                  -90,  -216,     0,    72,  -576,  -216,     0,    -9,    72,    54,   216,    72,  -576,  -189, -1728,  -576, &
                   -9,  -189,   -27,    -9,   -90,    54,  -270,   -90,    72,    54,   216,    72,    -9,  -189,   -27,    -9]
  K1( 800,:) = [    27,     9,    72,   216,   189,    -9,   576,     0,   -27,     9,    -9,   -27,   216,   -72,    72,   -27, &
                  -54,   -90,   -72,     0,  -216,   -72,    -9,   -27,     0,     9,    72,     0,  -189,     9,  -576,     0, &
                  189,     9,    -9,     0,   -54,    90,   -90,     0,    54,    90,    72,     0,     0,   -72,    -9,     0]
  K1( 801,:) = [     0,    -9,   -90,   -27,     0,    -9,    -9,  -216,     0,    -9,    72,   -27,     0,   -90,    -9,   -27, &
                    0,   -90,   -90,  -216,     0,    72,    -9,   -27,   -27,    -9,    -9,   -54,   -27,    -9,    -9,   189, &
                  -27,    -9,    -9,   189,  -270,   -90,   -90,   -54,  -270,   -90,   -90,   -54,   216,    72,    72,   189]
  K1( 802,:) = [    72,    27,  -216,   -72,     9,     0,  -189,  -576,    72,    27,   216,     9,    -9,  -216,   -27,   -72, &
                   90,     0,    54,    72,    -9,    27,    27,     9,    -9,     0,     0,   -72,    -9,     0,  -189,     9, &
                   -9,     0,   189,   576,   -90,     0,   -54,   -72,   -90,     0,    54,    90,    72,     0,     0,     9]
  K1( 803,:) = [   -90,   -27,     0,    -9,    -9,  -216,     0,    -9,    72,   -27,     0,    -9,    -9,   -27,     0,   -90, &
                  -90,  -216,     0,   -90,    -9,   -27,     0,    72,    -9,   -54,   -27,    -9,    -9,   189,   -27,    -9, &
                   -9,   189,   -27,    -9,   -90,   -54,  -270,   -90,   -90,   -54,  -270,   -90,    72,   189,   216,    72]
  K1( 804,:) = [  -216,   -72,    72,    27,  -189,  -576,     9,     0,   216,     9,    72,    27,   -27,   -72,    -9,  -216, &
                   54,    72,    90,     0,    27,     9,    -9,    27,     0,   -72,    -9,     0,  -189,     9,    -9,     0, &
                  189,   576,    -9,     0,   -54,   -72,   -90,     0,    54,    90,   -90,     0,     0,     9,    72,     0]
  K1( 805,:) = [     0,    72,    -9,   -27,     0,   -90,   -90,  -216,     0,   -90,    -9,   -27,     0,    -9,    72,   -27, &
                    0,    -9,    -9,  -216,     0,    -9,   -90,   -27,   216,    72,    72,   189,  -270,   -90,   -90,   -54, &
                 -270,   -90,   -90,   -54,   -27,    -9,    -9,   189,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54]
  K1( 806,:) = [    -9,    27,    27,     9,    90,     0,    54,    72,    -9,  -216,   -27,   -72,    72,    27,   216,     9, &
                    9,     0,  -189,  -576,    72,    27,  -216,   -72,    72,     0,     0,     9,   -90,     0,    54,    90, &
                  -90,     0,   -54,   -72,    -9,     0,   189,   576,    -9,     0,  -189,     9,    -9,     0,     0,   -72]
  K1( 807,:) = [    -9,   -27,     0,    72,   -90,  -216,     0,   -90,    -9,   -27,     0,   -90,    72,   -27,     0,    -9, &
                   -9,  -216,     0,    -9,   -90,   -27,     0,    -9,    72,   189,   216,    72,   -90,   -54,  -270,   -90, &
                  -90,   -54,  -270,   -90,    -9,   189,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54,   -27,    -9]
  K1( 808,:) = [    27,     9,    -9,    27,    54,    72,    90,     0,   -27,   -72,    -9,  -216,   216,     9,    72,    27, &
                 -189,  -576,     9,     0,  -216,   -72,    72,    27,     0,     9,    72,     0,    54,    90,   -90,     0, &
                  -54,   -72,   -90,     0,   189,   576,    -9,     0,  -189,     9,    -9,     0,     0,   -72,    -9,     0]
  K1( 809,:) = [     0,    -9,  -576,  -216,     0,    72,   -90,  -216,     0,   -90,    72,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,   -27,    -9,    -9,  -189,   216,    72,    72,    54, &
                 -270,   -90,   -90,    54,   -27,    -9,    -9,  -189, -1728,  -576,  -576,  -189,   216,    72,    72,    54]
  K1( 810,:) = [    -9,   -27,  -216,   -72,   -72,     0,   -54,   -90,    72,   -27,   216,   -72,    -9,   -27,   -27,     9, &
                  576,     0,   189,    -9,    72,   216,    27,     9,    -9,     0,     0,   -72,    72,     0,    54,    90, &
                  -90,     0,   -54,    90,    -9,     0,   189,     9,  -576,     0,  -189,     9,    72,     0,     0,     9]
  K1( 811,:) = [  -576,  -216,     0,    -9,   -90,  -216,     0,    72,    72,  -216,     0,   -90,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    -9,  -189,   -27,    -9,    72,    54,   216,    72, &
                  -90,    54,  -270,   -90,    -9,  -189,   -27,    -9,  -576,  -189, -1728,  -576,    72,    54,   216,    72]
  K1( 812,:) = [  -216,   -72,    -9,   -27,   -54,   -90,   -72,     0,   216,   -72,    72,   -27,   -27,     9,    -9,   -27, &
                  189,    -9,   576,     0,    27,     9,    72,   216,     0,   -72,    -9,     0,    54,    90,    72,     0, &
                  -54,    90,   -90,     0,   189,     9,    -9,     0,  -189,     9,  -576,     0,     0,     9,    72,     0]
  K1( 813,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 814,:) = [   -90,   -27,  -216,   -72,     9,     0,     0,    -9,    72,   216,   216,   576,    72,    27,   216,    90, &
                  -72,     0,     0,    72,  -576,  -216,  -216,   -72,    72,     0,     0,   -72,    -9,     0,  -189,   -72, &
                   72,     0,   189,     9,    -9,     0,   -54,   -72,    72,     0,    54,     9,    72,     0,     0,   -72]
  K1( 815,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 816,:) = [  -216,   -72,   -90,   -27,     0,    -9,     9,     0,   216,   576,    72,   216,   216,    90,    72,    27, &
                    0,    72,   -72,     0,  -216,   -72,  -576,  -216,     0,   -72,    72,     0,  -189,   -72,    -9,     0, &
                  189,     9,    72,     0,   -54,   -72,    -9,     0,    54,     9,    72,     0,     0,   -72,    72,     0]
  K1( 817,:) = [     0,  -576,     9,  -189,  -216,   -72,    -9,   -27,     0,    72,     9,     0,     0,    -9,   -72,     0, &
                   27,     9,    72,   216,   189,    -9,   576,     0,  -216,    72,   -72,    27,   216,    72,     9,    27, &
                   27,    -9,   -72,   -27,    27,    72,     9,   -27,   -27,    -9,   -72,  -216,   -27,    72,   -72,   216]
  K1( 818,:) = [  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    72,   216,    54,    72,    72,    27,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                   72,     0,  -216,   -90,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,   -90,     0,  -216,    72]
  K1( 819,:) = [     9,  -189,     0,  -576,    -9,   -27,  -216,   -72,     9,     0,     0,    72,   -72,     0,     0,    -9, &
                   72,   216,    27,     9,   576,     0,   189,    -9,   -72,    27,  -216,    72,     9,    27,   216,    72, &
                  -72,   -27,    27,    -9,     9,   -27,    27,    72,   -72,  -216,   -27,    -9,   -72,   216,   -27,    72]
  K1( 820,:) = [  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    54,    72,    72,   216,     0,    72,    72,    27, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,   -90,    72,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,    72,   -90,     0]
  K1( 821,:) = [  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                  216,    72,    72,    54,    27,    72,    72,     0,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,   -90,    72,  -216,     0,    72,   -90,  -216,     0,    -9,    -9,    27]
  K1( 822,:) = [   -72,  -216,   -27,    -9,  -576,     0,  -189,     9,     9,    27,    27,    -9,   -72,    27,  -216,    72, &
                   72,     0,    54,    90,     9,    27,   216,    72,   -72,     0,     0,    -9,   576,     0,   189,    -9, &
                    9,     0,  -189,    -9,    90,     0,    54,   -90,   -72,     0,   -54,   -90,     9,     0,     0,    72]
  K1( 823,:) = [    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   72,    54,   216,    72,    72,     0,    27,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,    72,  -216,     0,   -90,   -90,  -216,     0,    72,    -9,    27,     0,    -9]
  K1( 824,:) = [   -27,    -9,   -72,  -216,  -189,     9,  -576,     0,    27,    -9,     9,    27,  -216,    72,   -72,    27, &
                   54,    90,    72,     0,   216,    72,     9,    27,     0,    -9,   -72,     0,   189,    -9,   576,     0, &
                 -189,    -9,     9,     0,    54,   -90,    90,     0,   -54,   -90,   -72,     0,     0,    72,     9,     0]
  K1( 825,:) = [     0,    72,     9,    54,    27,     9,    72,    27,     0,    72,   -72,     0,    54,    72,     9,     0, &
                 -216,   -72,  -576,  -216,     0,    72,   -72,     0,    27,    -9,    90,    27,   -27,    -9,     9,    27, &
                   27,    -9,     9,   -27,  -216,   -90,   -72,   -27,   -27,   -90,   -72,  -216,   216,    72,   576,   216]
  K1( 826,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 827,:) = [     9,    54,     0,    72,    72,    27,    27,     9,   -72,     0,     0,    72,     9,     0,    54,    72, &
                 -576,  -216,  -216,   -72,   -72,     0,     0,    72,    90,    27,    27,    -9,     9,    27,   -27,    -9, &
                    9,   -27,    27,    -9,   -72,   -27,  -216,   -90,   -72,  -216,   -27,   -90,   576,   216,   216,    72]
  K1( 828,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 829,:) = [     0,    72,   -72,     0,  -216,   -72,  -576,  -216,    54,    72,     9,     0,     0,    72,   -72,     0, &
                   27,     9,    72,    27,     0,    72,     9,    54,   216,    72,   576,   216,   -27,   -90,   -72,  -216, &
                 -216,   -90,   -72,   -27,    27,    -9,     9,   -27,   -27,    -9,     9,    27,    27,    -9,    90,    27]
  K1( 830,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1( 831,:) = [   -72,     0,     0,    72,  -576,  -216,  -216,   -72,     9,     0,    54,    72,   -72,     0,     0,    72, &
                   72,    27,    27,     9,     9,    54,     0,    72,   576,   216,   216,    72,   -72,  -216,   -27,   -90, &
                  -72,   -27,  -216,   -90,     9,   -27,    27,    -9,     9,    27,   -27,    -9,    90,    27,    27,    -9]
  K1( 832,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1( 833,:) = [    27,    72,    72,     0,   216,    72,    72,    54,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,     0,    -9,    -9,    27,     0,    72,   -90,  -216, &
                    0,   -90,    72,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27]
  K1( 834,:) = [     9,    27,   216,    72,    72,     0,    54,    90,   -72,    27,  -216,    72,     9,    27,    27,    -9, &
                 -576,     0,  -189,     9,   -72,  -216,   -27,    -9,     9,     0,     0,    72,   -72,     0,   -54,   -90, &
                   90,     0,    54,   -90,     9,     0,  -189,    -9,   576,     0,   189,    -9,   -72,     0,     0,    -9]
  K1( 835,:) = [    72,     0,    27,    72,    72,    54,   216,    72,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                 -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72, &
                   72,  -216,     0,   -90,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72]
  K1( 836,:) = [   216,    72,     9,    27,    54,    90,    72,     0,  -216,    72,   -72,    27,    27,    -9,     9,    27, &
                 -189,     9,  -576,     0,   -27,    -9,   -72,  -216,     0,    72,     9,     0,   -54,   -90,   -72,     0, &
                   54,   -90,    90,     0,  -189,    -9,     9,     0,   189,    -9,   576,     0,     0,    -9,   -72,     0]
  K1( 837,:) = [   189,    -9,   576,     0,    27,     9,    72,   216,     0,    -9,   -72,     0,     0,    72,     9,     0, &
                 -216,   -72,    -9,   -27,     0,  -576,     9,  -189,   -27,    72,   -72,   216,   -27,    -9,   -72,  -216, &
                   27,    72,     9,   -27,    27,    -9,   -72,   -27,   216,    72,     9,    27,  -216,    72,   -72,    27]
  K1( 838,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,    72,    27,     0,    72,    72,   216,    54,    72, &
                 -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,   -90,     0,  -216,    72,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,    72,     0,  -216,   -90,    72,     0,    27,    72,  -576,     0,  -216,    -9]
  K1( 839,:) = [   576,     0,   189,    -9,    72,   216,    27,     9,   -72,     0,     0,    -9,     9,     0,     0,    72, &
                   -9,   -27,  -216,   -72,     9,  -189,     0,  -576,   -72,   216,   -27,    72,   -72,  -216,   -27,    -9, &
                    9,   -27,    27,    72,   -72,   -27,    27,    -9,     9,    27,   216,    72,   -72,    27,  -216,    72]
  K1( 840,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,    72,    27,    54,    72,    72,   216, &
                    0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,  -216,    72,   -90,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,   -90,    72,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0]
  K1( 841,:) = [  -216,  -576,   -72,  -216,     0,   -72,    72,     0,    27,    72,    90,   216,   216,    72,   576,   216, &
                    0,     9,    -9,     0,   -27,   -90,   -72,  -216,     0,    72,   -72,     0,     0,    72,     9,    54, &
                    0,    -9,   -72,   -54,     0,    72,     9,   189,     0,    -9,   -72,  -189,     0,    72,   -72,     0]
  K1( 842,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1( 843,:) = [   -72,  -216,  -216,  -576,    72,     0,     0,   -72,    90,   216,    27,    72,   576,   216,   216,    72, &
                   -9,     0,     0,     9,   -72,  -216,   -27,   -90,   -72,     0,     0,    72,     9,    54,     0,    72, &
                  -72,   -54,     0,    -9,     9,   189,     0,    72,   -72,  -189,     0,    -9,   -72,     0,     0,    72]
  K1( 844,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1( 845,:) = [   216,    72,     9,    27,     0,   576,    -9,   189,   -27,    -9,     9,   -27,   -27,    72,   -72,   216, &
                    0,   -72,   -90,   -54,   -27,    -9,   -72,  -216,     0,    72,     9,     0,     0,  -576,     9,  -189, &
                    0,    -9,     9,   189,     0,   -90,    90,   -54,     0,    72,    90,    54,     0,    -9,   -72,     0]
  K1( 846,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,   -90,     0,  -216,    72, &
                   72,     0,  -216,   -90,    -9,     0,  -216,  -576,    72,   216,    54,    72,  -576, -1728,  -189,  -576, &
                   -9,   -27,  -189,    -9,   -90,  -270,    54,   -90,    72,   216,    54,    72,    -9,   -27,  -189,    -9]
  K1( 847,:) = [     9,    27,   216,    72,    -9,   189,     0,   576,     9,   -27,   -27,    -9,   -72,   216,   -27,    72, &
                  -90,   -54,     0,   -72,   -72,  -216,   -27,    -9,     9,     0,     0,    72,     9,  -189,     0,  -576, &
                    9,   189,     0,    -9,    90,   -54,     0,   -90,    90,    54,     0,    72,   -72,     0,     0,    -9]
  K1( 848,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,    72,   -90,     0, &
                 -216,   -90,    72,     0,  -216,  -576,    -9,     0,    54,    72,    72,   216,  -189,  -576,  -576, -1728, &
                 -189,    -9,    -9,   -27,    54,   -90,   -90,  -270,    54,    72,    72,   216,  -189,    -9,    -9,   -27]
  K1( 849,:) = [    27,    72,   -72,  -216,     0,     9,  -576,  -189,    27,    72,     9,   216,  -216,    -9,   -72,   -27, &
                    0,    90,    72,    54,    27,    -9,     9,    27,     0,    -9,   -72,     0,     0,    -9,     9,  -189, &
                    0,    -9,   576,   189,     0,   -90,   -72,   -54,     0,   -90,    90,    54,     0,    72,     9,     0]
  K1( 850,:) = [    -9,     0,   -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -27,    72,   -90,     0,   -27,    -9, &
                  -90,     0,  -216,   -90,    72,     0,   -27,    -9,    -9,   -27,   -54,    -9,    -9,   -27,   189,    -9, &
                   -9,   -27,   189,    -9,   -90,  -270,   -54,   -90,   -90,  -270,   -54,   -90,    72,   216,   189,    72]
  K1( 851,:) = [   -72,  -216,    27,    72,  -576,  -189,     0,     9,     9,   216,    27,    72,   -72,   -27,  -216,    -9, &
                   72,    54,     0,    90,     9,    27,    27,    -9,   -72,     0,     0,    -9,     9,  -189,     0,    -9, &
                  576,   189,     0,    -9,   -72,   -54,     0,   -90,    90,    54,     0,   -90,     9,     0,     0,    72]
  K1( 852,:) = [   -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -27,    72,    -9,     0,   -27,    -9,   -90,     0, &
                 -216,   -90,   -90,     0,   -27,    -9,    72,     0,   -54,    -9,    -9,   -27,   189,    -9,    -9,   -27, &
                  189,    -9,    -9,   -27,   -54,   -90,   -90,  -270,   -54,   -90,   -90,  -270,   189,    72,    72,   216]
  K1( 853,:) = [    27,    -9,     9,    27,     0,    90,    72,    54,  -216,    -9,   -72,   -27,    27,    72,     9,   216, &
                    0,     9,  -576,  -189,    27,    72,   -72,  -216,     0,    72,     9,     0,     0,   -90,    90,    54, &
                    0,   -90,   -72,   -54,     0,    -9,   576,   189,     0,    -9,     9,  -189,     0,    -9,   -72,     0]
  K1( 854,:) = [    72,     0,   -27,    -9,   -90,     0,  -216,   -90,   -90,     0,   -27,    -9,    -9,     0,   -27,    72, &
                   -9,     0,  -216,    -9,    -9,     0,   -27,   -90,    72,   216,   189,    72,   -90,  -270,   -54,   -90, &
                  -90,  -270,   -54,   -90,    -9,   -27,   189,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9]
  K1( 855,:) = [     9,    27,    27,    -9,    72,    54,     0,    90,   -72,   -27,  -216,    -9,     9,   216,    27,    72, &
                 -576,  -189,     0,     9,   -72,  -216,    27,    72,     9,     0,     0,    72,    90,    54,     0,   -90, &
                  -72,   -54,     0,   -90,   576,   189,     0,    -9,     9,  -189,     0,    -9,   -72,     0,     0,    -9]
  K1( 856,:) = [   -27,    -9,    72,     0,  -216,   -90,   -90,     0,   -27,    -9,   -90,     0,   -27,    72,    -9,     0, &
                 -216,    -9,    -9,     0,   -27,   -90,    -9,     0,   189,    72,    72,   216,   -54,   -90,   -90,  -270, &
                  -54,   -90,   -90,  -270,   189,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9,    -9,   -27]
  K1( 857,:) = [   -27,    -9,   -72,  -216,     0,   -72,   -90,   -54,   -27,    72,   -72,   216,   -27,    -9,     9,   -27, &
                    0,   576,    -9,   189,   216,    72,     9,    27,     0,    -9,   -72,     0,     0,    72,    90,    54, &
                    0,   -90,    90,   -54,     0,    -9,     9,   189,     0,  -576,     9,  -189,     0,    72,     9,     0]
  K1( 858,:) = [    -9,     0,  -216,  -576,    72,     0,  -216,   -90,   -90,     0,  -216,    72,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,    -9,   -27,  -189,    -9,    72,   216,    54,    72, &
                  -90,  -270,    54,   -90,    -9,   -27,  -189,    -9,  -576, -1728,  -189,  -576,    72,   216,    54,    72]
  K1( 859,:) = [   -72,  -216,   -27,    -9,   -90,   -54,     0,   -72,   -72,   216,   -27,    72,     9,   -27,   -27,    -9, &
                   -9,   189,     0,   576,     9,    27,   216,    72,   -72,     0,     0,    -9,    90,    54,     0,    72, &
                   90,   -54,     0,   -90,     9,   189,     0,    -9,     9,  -189,     0,  -576,     9,     0,     0,    72]
  K1( 860,:) = [  -216,  -576,    -9,     0,  -216,   -90,    72,     0,  -216,    72,   -90,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -189,    -9,    -9,   -27,    54,    72,    72,   216, &
                   54,   -90,   -90,  -270,  -189,    -9,    -9,   -27,  -189,  -576,  -576, -1728,    54,    72,    72,   216]
  K1( 861,:) = [   -27,   -90,   -72,  -216,     0,     9,    -9,     0,   216,    72,   576,   216,    27,    72,    90,   216, &
                    0,   -72,    72,     0,  -216,  -576,   -72,  -216,     0,    72,   -72,     0,     0,    -9,   -72,  -189, &
                    0,    72,     9,   189,     0,    -9,   -72,   -54,     0,    72,     9,    54,     0,    72,   -72,     0]
  K1( 862,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 863,:) = [   -72,  -216,   -27,   -90,    -9,     0,     0,     9,   576,   216,   216,    72,    90,   216,    27,    72, &
                   72,     0,     0,   -72,   -72,  -216,  -216,  -576,   -72,     0,     0,    72,   -72,  -189,     0,    -9, &
                    9,   189,     0,    72,   -72,   -54,     0,    -9,     9,    54,     0,    72,   -72,     0,     0,    72]
  K1( 864,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 865,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 866,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 867,:) = [    72,     0,     0,   -72,   -72,  -216,  -216,  -576,    72,    54,     0,     9,    72,     0,     0,   -72, &
                    9,    27,    27,    72,    72,     0,    54,     9,    72,   216,   216,   576,   -90,   -27,  -216,   -72, &
                  -90,  -216,   -27,   -72,    -9,    27,   -27,     9,    -9,   -27,    27,     9,    -9,    27,    27,    90]
  K1( 868,:) = [     0,    72,   -72,     0,  -216,   -72,  -576,  -216,    54,    72,     9,     0,     0,    72,   -72,     0, &
                   27,     9,    72,    27,     0,    72,     9,    54,   216,    72,   576,   216,   -27,   -90,   -72,  -216, &
                 -216,   -90,   -72,   -27,    27,    -9,     9,   -27,   -27,    -9,     9,    27,    27,    -9,    90,    27]
  K1( 869,:) = [    27,    72,   -72,  -216,     0,     9,  -576,  -189,    27,    72,     9,   216,  -216,    -9,   -72,   -27, &
                    0,    90,    72,    54,    27,    -9,     9,    27,     0,    -9,   -72,     0,     0,    -9,     9,  -189, &
                    0,    -9,   576,   189,     0,   -90,   -72,   -54,     0,   -90,    90,    54,     0,    72,     9,     0]
  K1( 870,:) = [    72,    27,  -216,   -72,     9,     0,  -189,  -576,    72,    27,   216,     9,    -9,  -216,   -27,   -72, &
                   90,     0,    54,    72,    -9,    27,    27,     9,    -9,     0,     0,   -72,    -9,     0,  -189,     9, &
                   -9,     0,   189,   576,   -90,     0,   -54,   -72,   -90,     0,    54,    90,    72,     0,     0,     9]
  K1( 871,:) = [    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   72,    54,   216,    72,    72,     0,    27,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,    72,  -216,     0,   -90,   -90,  -216,     0,    72,    -9,    27,     0,    -9]
  K1( 872,:) = [     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                   54,    72,    72,   216,     0,    72,    72,    27,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,    72,   -90,     0,  -216,   -90,    72,     0,    27,    -9,    -9,     0]
  K1( 873,:) = [   216,    72,    72,    54,    27,    72,    72,     0, -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,     0,    72,   -90,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,     0,   -90,    72,  -216,     0,    -9,  -576,  -216]
  K1( 874,:) = [    72,   216,    54,    72,    72,    27,     0,    72,  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,     0,  -216,    72,    -9,     0,  -216,  -576]
  K1( 875,:) = [    72,     0,     0,     9,     9,   216,    27,    72,  -576,  -189,     0,     9,    -9,     0,   189,   576, &
                  -72,   -27,  -216,    -9,    -9,     0,     0,   -72,    72,   216,   -27,   -72,    72,   -27,    27,     9, &
                   -9,  -216,   -27,   -72,    72,    27,   216,     9,    -9,   -27,    27,   -72,    72,    27,  -216,   -72]
  K1( 876,:) = [     0,    72,     9,     0,   216,     9,    72,    27,  -189,  -576,     9,     0,     0,    -9,   576,   189, &
                  -27,   -72,    -9,  -216,     0,    -9,   -72,     0,   216,    72,   -72,   -27,   -27,    72,     9,    27, &
                 -216,    -9,   -72,   -27,    27,    72,     9,   216,   -27,    -9,   -72,    27,    27,    72,   -72,  -216]
  K1( 877,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189, &
                   27,    72,    72,     0,   216,    72,    72,    54,     0,    -9,  -576,  -216,     0,   -90,    72,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,    72,   -90,  -216]
  K1( 878,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576, &
                   72,    27,     0,    72,    72,   216,    54,    72,    -9,     0,  -216,  -576,   -90,     0,  -216,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90]
  K1( 879,:) = [    -9,     0,     0,   -72,   -72,   -27,  -216,    -9,    -9,     0,   189,   576,  -576,  -189,     0,     9, &
                    9,   216,    27,    72,    72,     0,     0,     9,    72,    27,  -216,   -72,    -9,   -27,    27,   -72, &
                   72,    27,   216,     9,    -9,  -216,   -27,   -72,    72,   -27,    27,     9,    72,   216,   -27,   -72]
  K1( 880,:) = [     0,    -9,   -72,     0,   -27,   -72,    -9,  -216,     0,    -9,   576,   189,  -189,  -576,     9,     0, &
                  216,     9,    72,    27,     0,    72,     9,     0,    27,    72,   -72,  -216,   -27,    -9,   -72,    27, &
                   27,    72,     9,   216,  -216,    -9,   -72,   -27,   -27,    72,     9,    27,   216,    72,   -72,   -27]
  K1( 881,:) = [    27,    -9,     9,    27,     0,    90,    72,    54,  -216,    -9,   -72,   -27,    27,    72,     9,   216, &
                    0,     9,  -576,  -189,    27,    72,   -72,  -216,     0,    72,     9,     0,     0,   -90,    90,    54, &
                    0,   -90,   -72,   -54,     0,    -9,   576,   189,     0,    -9,     9,  -189,     0,    -9,   -72,     0]
  K1( 882,:) = [    -9,    27,    27,     9,    90,     0,    54,    72,    -9,  -216,   -27,   -72,    72,    27,   216,     9, &
                    9,     0,  -189,  -576,    72,    27,  -216,   -72,    72,     0,     0,     9,   -90,     0,    54,    90, &
                  -90,     0,   -54,   -72,    -9,     0,   189,   576,    -9,     0,  -189,     9,    -9,     0,     0,   -72]
  K1( 883,:) = [    72,     0,    27,    72,    72,    54,   216,    72,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                 -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72, &
                   72,  -216,     0,   -90,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72]
  K1( 884,:) = [     0,    72,    72,    27,    54,    72,    72,   216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                 -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    27,    -9,    -9,     0,  -216,   -90,    72,     0, &
                 -216,    72,   -90,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0]
  K1( 885,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1( 886,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1( 887,:) = [    72,     0,    54,     9,     9,    27,    27,    72,    72,     0,     0,   -72,    72,    54,     0,     9, &
                  -72,  -216,  -216,  -576,    72,     0,     0,   -72,    -9,    27,    27,    90,    -9,   -27,    27,     9, &
                   -9,    27,   -27,     9,   -90,  -216,   -27,   -72,   -90,   -27,  -216,   -72,    72,   216,   216,   576]
  K1( 888,:) = [     0,    72,     9,    54,    27,     9,    72,    27,     0,    72,   -72,     0,    54,    72,     9,     0, &
                 -216,   -72,  -576,  -216,     0,    72,   -72,     0,    27,    -9,    90,    27,   -27,    -9,     9,    27, &
                   27,    -9,     9,   -27,  -216,   -90,   -72,   -27,   -27,   -90,   -72,  -216,   216,    72,   576,   216]
  K1( 889,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 890,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 891,:) = [    72,   216,   216,   576,   -72,     0,     0,    72,   -90,  -216,   -27,   -72,  -576,  -216,  -216,   -72, &
                    9,     0,     0,    -9,    72,   216,    27,    90,    72,     0,     0,   -72,    -9,   -54,     0,   -72, &
                   72,    54,     0,     9,    -9,  -189,     0,   -72,    72,   189,     0,     9,    72,     0,     0,   -72]
  K1( 892,:) = [   216,    72,   576,   216,     0,   -72,    72,     0,  -216,   -90,   -72,   -27,  -216,  -576,   -72,  -216, &
                    0,     9,    -9,     0,   216,    72,    90,    27,     0,    72,   -72,     0,   -54,    -9,   -72,     0, &
                   54,    72,     9,     0,  -189,    -9,   -72,     0,   189,    72,     9,     0,     0,    72,   -72,     0]
  K1( 893,:) = [     0,    -9,   -90,   -27,     0,    -9,    -9,  -216,     0,    -9,    72,   -27,     0,   -90,    -9,   -27, &
                    0,   -90,   -90,  -216,     0,    72,    -9,   -27,   -27,    -9,    -9,   -54,   -27,    -9,    -9,   189, &
                  -27,    -9,    -9,   189,  -270,   -90,   -90,   -54,  -270,   -90,   -90,   -54,   216,    72,    72,   189]
  K1( 894,:) = [    -9,     0,   -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -27,    72,   -90,     0,   -27,    -9, &
                  -90,     0,  -216,   -90,    72,     0,   -27,    -9,    -9,   -27,   -54,    -9,    -9,   -27,   189,    -9, &
                   -9,   -27,   189,    -9,   -90,  -270,   -54,   -90,   -90,  -270,   -54,   -90,    72,   216,   189,    72]
  K1( 895,:) = [    -9,   -27,  -216,   -72,     9,  -189,     0,  -576,    -9,    27,    27,     9,    72,  -216,    27,   -72, &
                   90,    54,     0,    72,    72,   216,    27,     9,    -9,     0,     0,   -72,    -9,   189,     0,   576, &
                   -9,  -189,     0,     9,   -90,    54,     0,    90,   -90,   -54,     0,   -72,    72,     0,     0,     9]
  K1( 896,:) = [   -27,    -9,   -72,  -216,  -189,     9,  -576,     0,    27,    -9,     9,    27,  -216,    72,   -72,    27, &
                   54,    90,    72,     0,   216,    72,     9,    27,     0,    -9,   -72,     0,   189,    -9,   576,     0, &
                 -189,    -9,     9,     0,    54,   -90,    90,     0,   -54,   -90,   -72,     0,     0,    72,     9,     0]
  K1( 897,:) = [     0,    72,   -90,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,   -90,    72,  -216,     0,    -9,    -9,    27,   216,    72,    72,    54,   -27,    -9,    -9,  -189, &
                -1728,  -576,  -576,  -189,   216,    72,    72,    54,  -270,   -90,   -90,    54,   -27,    -9,    -9,  -189]
  K1( 898,:) = [    72,     0,  -216,   -90,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                  -90,     0,  -216,    72,    -9,     0,    27,    -9,    72,   216,    54,    72,    -9,   -27,  -189,    -9, &
                 -576, -1728,  -189,  -576,    72,   216,    54,    72,   -90,  -270,    54,   -90,    -9,   -27,  -189,    -9]
  K1( 899,:) = [    72,   216,   -27,   -72,   576,   189,     0,    -9,    -9,  -216,   -27,   -72,    72,    27,   216,     9, &
                  -72,   -54,     0,   -90,    -9,   -27,   -27,     9,    72,     0,     0,     9,    -9,   189,     0,     9, &
                 -576,  -189,     0,     9,    72,    54,     0,    90,   -90,   -54,     0,    90,    -9,     0,     0,   -72]
  K1( 900,:) = [   216,    72,   -72,   -27,   189,   576,    -9,     0,  -216,    -9,   -72,   -27,    27,    72,     9,   216, &
                  -54,   -72,   -90,     0,   -27,    -9,     9,   -27,     0,    72,     9,     0,   189,    -9,     9,     0, &
                 -189,  -576,     9,     0,    54,    72,    90,     0,   -54,   -90,    90,     0,     0,    -9,   -72,     0]
  K1( 901,:) = [     0,    -9,    -9,    27,     0,   -90,    72,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,    72,   -90,  -216,   -27,    -9,    -9,  -189,  -270,   -90,   -90,    54, &
                  216,    72,    72,    54, -1728,  -576,  -576,  -189,   -27,    -9,    -9,  -189,   216,    72,    72,    54]
  K1( 902,:) = [    -9,     0,    27,    -9,   -90,     0,  -216,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,    72,     0,  -216,   -90,    -9,   -27,  -189,    -9,   -90,  -270,    54,   -90, &
                   72,   216,    54,    72,  -576, -1728,  -189,  -576,    -9,   -27,  -189,    -9,    72,   216,    54,    72]
  K1( 903,:) = [    -9,   -27,   -27,     9,   -72,   -54,     0,   -90,    72,    27,   216,     9,    -9,  -216,   -27,   -72, &
                  576,   189,     0,    -9,    72,   216,   -27,   -72,    -9,     0,     0,   -72,   -90,   -54,     0,    90, &
                   72,    54,     0,    90,  -576,  -189,     0,     9,    -9,   189,     0,     9,    72,     0,     0,     9]
  K1( 904,:) = [   -27,    -9,     9,   -27,   -54,   -72,   -90,     0,    27,    72,     9,   216,  -216,    -9,   -72,   -27, &
                  189,   576,    -9,     0,   216,    72,   -72,   -27,     0,    -9,   -72,     0,   -54,   -90,    90,     0, &
                   54,    72,    90,     0,  -189,  -576,     9,     0,   189,    -9,     9,     0,     0,    72,     9,     0]
  K1( 905,:) = [     0,    72,    -9,   -27,     0,   -90,   -90,  -216,     0,   -90,    -9,   -27,     0,    -9,    72,   -27, &
                    0,    -9,    -9,  -216,     0,    -9,   -90,   -27,   216,    72,    72,   189,  -270,   -90,   -90,   -54, &
                 -270,   -90,   -90,   -54,   -27,    -9,    -9,   189,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54]
  K1( 906,:) = [    72,     0,   -27,    -9,   -90,     0,  -216,   -90,   -90,     0,   -27,    -9,    -9,     0,   -27,    72, &
                   -9,     0,  -216,    -9,    -9,     0,   -27,   -90,    72,   216,   189,    72,   -90,  -270,   -54,   -90, &
                  -90,  -270,   -54,   -90,    -9,   -27,   189,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9]
  K1( 907,:) = [    72,   216,    27,     9,    90,    54,     0,    72,    72,  -216,    27,   -72,    -9,    27,    27,     9, &
                    9,  -189,     0,  -576,    -9,   -27,  -216,   -72,    72,     0,     0,     9,   -90,   -54,     0,   -72, &
                  -90,    54,     0,    90,    -9,  -189,     0,     9,    -9,   189,     0,   576,    -9,     0,     0,   -72]
  K1( 908,:) = [   216,    72,     9,    27,    54,    90,    72,     0,  -216,    72,   -72,    27,    27,    -9,     9,    27, &
                 -189,     9,  -576,     0,   -27,    -9,   -72,  -216,     0,    72,     9,     0,   -54,   -90,   -72,     0, &
                   54,   -90,    90,     0,  -189,    -9,     9,     0,   189,    -9,   576,     0,     0,    -9,   -72,     0]
  K1( 909,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1( 910,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1( 911,:) = [    72,   216,    27,    90,     9,     0,     0,    -9,  -576,  -216,  -216,   -72,   -90,  -216,   -27,   -72, &
                  -72,     0,     0,    72,    72,   216,   216,   576,    72,     0,     0,   -72,    72,   189,     0,     9, &
                   -9,  -189,     0,   -72,    72,    54,     0,     9,    -9,   -54,     0,   -72,    72,     0,     0,   -72]
  K1( 912,:) = [   216,    72,    90,    27,     0,     9,    -9,     0,  -216,  -576,   -72,  -216,  -216,   -90,   -72,   -27, &
                    0,   -72,    72,     0,   216,    72,   576,   216,     0,    72,   -72,     0,   189,    72,     9,     0, &
                 -189,    -9,   -72,     0,    54,    72,     9,     0,   -54,    -9,   -72,     0,     0,    72,   -72,     0]
  K1( 913,:) = [     0,   -72,    72,     0,  -216,  -576,   -72,  -216,     0,     9,    72,    54,     0,   -72,    72,     0, &
                   27,    72,     9,    27,    54,     9,    72,     0,   216,   576,    72,   216,  -216,   -72,   -90,   -27, &
                  -27,   -72,   -90,  -216,   -27,     9,    -9,    27,    27,     9,    -9,   -27,    27,    90,    -9,    27]
  K1( 914,:) = [   -72,     0,     0,    72,  -576,  -216,  -216,   -72,     9,     0,    54,    72,   -72,     0,     0,    72, &
                   72,    27,    27,     9,     9,    54,     0,    72,   576,   216,   216,    72,   -72,  -216,   -27,   -90, &
                  -72,   -27,  -216,   -90,     9,   -27,    27,    -9,     9,    27,   -27,    -9,    90,    27,    27,    -9]
  K1( 915,:) = [    72,     0,   216,    72,    -9,     0,    27,    72,    72,     0,   216,    72,    -9,     0,    27,    72, &
                   72,     0,    27,    -9,    72,     0,    27,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9, &
                   72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72,    72,   216,     0,    72]
  K1( 916,:) = [     0,    72,    72,   216,     0,    -9,    72,    27,     0,    72,    72,   216,     0,    -9,    72,    27, &
                    0,    72,    -9,    27,     0,    72,    -9,    27,   216,    72,    72,     0,   -27,    -9,    -9,     0, &
                  216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0,   216,    72,    72,     0]
  K1( 917,:) = [  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                  216,    72,    72,    54,    27,    72,    72,     0,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,   -90,    72,  -216,     0,    72,   -90,  -216,     0,    -9,    -9,    27]
  K1( 918,:) = [  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                   72,   216,    54,    72,    72,    27,     0,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,   -90,     0,  -216,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9]
  K1( 919,:) = [   -72,  -216,    27,    72,  -576,  -189,     0,     9,     9,   216,    27,    72,   -72,   -27,  -216,    -9, &
                   72,    54,     0,    90,     9,    27,    27,    -9,   -72,     0,     0,    -9,     9,  -189,     0,    -9, &
                  576,   189,     0,    -9,   -72,   -54,     0,   -90,    90,    54,     0,   -90,     9,     0,     0,    72]
  K1( 920,:) = [  -216,   -72,    72,    27,  -189,  -576,     9,     0,   216,     9,    72,    27,   -27,   -72,    -9,  -216, &
                   54,    72,    90,     0,    27,     9,    -9,    27,     0,   -72,    -9,     0,  -189,     9,    -9,     0, &
                  189,   576,    -9,     0,   -54,   -72,   -90,     0,    54,    90,   -90,     0,     0,     9,    72,     0]
  K1( 921,:) = [     0,     9,    72,     0,    27,    72,     9,   216,     0,     9,  -576,  -189,   189,   576,    -9,     0, &
                 -216,    -9,   -72,   -27,     0,   -72,    -9,     0,   -27,   -72,    72,   216,    27,     9,    72,   -27, &
                  -27,   -72,    -9,  -216,   216,     9,    72,    27,    27,   -72,    -9,   -27,  -216,   -72,    72,    27]
  K1( 922,:) = [     9,     0,     0,    72,    72,    27,   216,     9,     9,     0,  -189,  -576,   576,   189,     0,    -9, &
                   -9,  -216,   -27,   -72,   -72,     0,     0,    -9,   -72,   -27,   216,    72,     9,    27,   -27,    72, &
                  -72,   -27,  -216,    -9,     9,   216,    27,    72,   -72,    27,   -27,    -9,   -72,  -216,    27,    72]
  K1( 923,:) = [    72,    54,   216,    72,    72,     0,    27,    72,  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,  -216,     0,    72,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,  -216,     0,   -90,  -576,  -216,     0,    -9]
  K1( 924,:) = [    54,    72,    72,   216,     0,    72,    72,    27,  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,  -216,   -90,    72,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,    72,   -90,     0,  -216,  -576,    -9,     0]
  K1( 925,:) = [     0,   -72,    -9,     0,  -216,    -9,   -72,   -27,   189,   576,    -9,     0,     0,     9,  -576,  -189, &
                   27,    72,     9,   216,     0,     9,    72,     0,  -216,   -72,    72,    27,    27,   -72,    -9,   -27, &
                  216,     9,    72,    27,   -27,   -72,    -9,  -216,    27,     9,    72,   -27,   -27,   -72,    72,   216]
  K1( 926,:) = [   -72,     0,     0,    -9,    -9,  -216,   -27,   -72,   576,   189,     0,    -9,     9,     0,  -189,  -576, &
                   72,    27,   216,     9,     9,     0,     0,    72,   -72,  -216,    27,    72,   -72,    27,   -27,    -9, &
                    9,   216,    27,    72,   -72,   -27,  -216,    -9,     9,    27,   -27,    72,   -72,   -27,   216,    72]
  K1( 927,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576, &
                   72,     0,    27,    72,    72,    54,   216,    72,  -576,  -216,     0,    -9,    72,  -216,     0,   -90, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72]
  K1( 928,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728, &
                    0,    72,    72,    27,    54,    72,    72,   216,  -216,  -576,    -9,     0,  -216,    72,   -90,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,   -90,    72,     0]
  K1( 929,:) = [    27,    72,    72,     0,   216,    72,    72,    54,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,     0,    -9,    -9,    27,     0,    72,   -90,  -216, &
                    0,   -90,    72,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27]
  K1( 930,:) = [    72,    27,     0,    72,    72,   216,    54,    72,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                 -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90, &
                  -90,     0,  -216,    72,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72]
  K1( 931,:) = [     9,    27,    27,    -9,    72,    54,     0,    90,   -72,   -27,  -216,    -9,     9,   216,    27,    72, &
                 -576,  -189,     0,     9,   -72,  -216,    27,    72,     9,     0,     0,    72,    90,    54,     0,   -90, &
                  -72,   -54,     0,   -90,   576,   189,     0,    -9,     9,  -189,     0,    -9,   -72,     0,     0,    -9]
  K1( 932,:) = [    27,     9,    -9,    27,    54,    72,    90,     0,   -27,   -72,    -9,  -216,   216,     9,    72,    27, &
                 -189,  -576,     9,     0,  -216,   -72,    72,    27,     0,     9,    72,     0,    54,    90,   -90,     0, &
                  -54,   -72,   -90,     0,   189,   576,    -9,     0,  -189,     9,    -9,     0,     0,   -72,    -9,     0]
  K1( 933,:) = [    54,     9,    72,     0,    27,    72,     9,    27,     0,   -72,    72,     0,     0,     9,    72,    54, &
                 -216,  -576,   -72,  -216,     0,   -72,    72,     0,    27,    90,    -9,    27,    27,     9,    -9,   -27, &
                  -27,     9,    -9,    27,   -27,   -72,   -90,  -216,  -216,   -72,   -90,   -27,   216,   576,    72,   216]
  K1( 934,:) = [     9,    54,     0,    72,    72,    27,    27,     9,   -72,     0,     0,    72,     9,     0,    54,    72, &
                 -576,  -216,  -216,   -72,   -72,     0,     0,    72,    90,    27,    27,    -9,     9,    27,   -27,    -9, &
                    9,   -27,    27,    -9,   -72,   -27,  -216,   -90,   -72,  -216,   -27,   -90,   576,   216,   216,    72]
  K1( 935,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1( 936,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1( 937,:) = [   216,   576,    72,   216,     0,    72,   -72,     0,   -27,   -72,   -90,  -216,  -216,   -72,  -576,  -216, &
                    0,    -9,     9,     0,    27,    90,    72,   216,     0,   -72,    72,     0,     0,   -72,    -9,   -54, &
                    0,     9,    72,    54,     0,   -72,    -9,  -189,     0,     9,    72,   189,     0,   -72,    72,     0]
  K1( 938,:) = [   576,   216,   216,    72,    72,     0,     0,   -72,   -72,   -27,  -216,   -90,   -72,  -216,  -216,  -576, &
                   -9,     0,     0,     9,    90,    27,   216,    72,   -72,     0,     0,    72,   -72,     0,   -54,    -9, &
                    9,     0,    54,    72,   -72,     0,  -189,    -9,     9,     0,   189,    72,   -72,     0,     0,    72]
  K1( 939,:) = [    72,   216,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72,    72,    27,     0,    -9, &
                   -9,    27,     0,    72,    -9,    27,     0,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9, &
                   72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72,    72,     0,   216,    72]
  K1( 940,:) = [   216,    72,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0,    27,    72,    -9,     0, &
                   27,    -9,    72,     0,    27,    -9,    72,     0,     0,    72,    72,   216,     0,    -9,    -9,   -27, &
                    0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    72,    72,   216]
  K1( 941,:) = [  -216,   -72,    -9,   -27,     0,  -576,     9,  -189,    27,     9,    -9,    27,    27,   -72,    72,  -216, &
                    0,    72,    90,    54,    27,     9,    72,   216,     0,   -72,    -9,     0,     0,   576,    -9,   189, &
                    0,     9,    -9,  -189,     0,    90,   -90,    54,     0,   -72,   -90,   -54,     0,     9,    72,     0]
  K1( 942,:) = [   -72,  -216,   -27,    -9,  -576,     0,  -189,     9,     9,    27,    27,    -9,   -72,    27,  -216,    72, &
                   72,     0,    54,    90,     9,    27,   216,    72,   -72,     0,     0,    -9,   576,     0,   189,    -9, &
                    9,     0,  -189,    -9,    90,     0,    54,   -90,   -72,     0,   -54,   -90,     9,     0,     0,    72]
  K1( 943,:) = [   -90,   -27,     0,    -9,    -9,  -216,     0,    -9,    72,   -27,     0,    -9,    -9,   -27,     0,   -90, &
                  -90,  -216,     0,   -90,    -9,   -27,     0,    72,    -9,   -54,   -27,    -9,    -9,   189,   -27,    -9, &
                   -9,   189,   -27,    -9,   -90,   -54,  -270,   -90,   -90,   -54,  -270,   -90,    72,   189,   216,    72]
  K1( 944,:) = [   -27,   -90,    -9,     0,  -216,    -9,    -9,     0,   -27,    72,    -9,     0,   -27,    -9,   -90,     0, &
                 -216,   -90,   -90,     0,   -27,    -9,    72,     0,   -54,    -9,    -9,   -27,   189,    -9,    -9,   -27, &
                  189,    -9,    -9,   -27,   -54,   -90,   -90,  -270,   -54,   -90,   -90,  -270,   189,    72,    72,   216]
  K1( 945,:) = [   -27,   -72,    72,   216,     0,    -9,   576,   189,   -27,   -72,    -9,  -216,   216,     9,    72,    27, &
                    0,   -90,   -72,   -54,   -27,     9,    -9,   -27,     0,     9,    72,     0,     0,     9,    -9,   189, &
                    0,     9,  -576,  -189,     0,    90,    72,    54,     0,    90,   -90,   -54,     0,   -72,    -9,     0]
  K1( 946,:) = [   -72,   -27,   216,    72,    -9,     0,   189,   576,   -72,   -27,  -216,    -9,     9,   216,    27,    72, &
                  -90,     0,   -54,   -72,     9,   -27,   -27,    -9,     9,     0,     0,    72,     9,     0,   189,    -9, &
                    9,     0,  -189,  -576,    90,     0,    54,    72,    90,     0,   -54,   -90,   -72,     0,     0,    -9]
  K1( 947,:) = [   -90,  -216,     0,    72,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                   72,  -216,     0,   -90,    -9,    27,     0,    -9,    72,    54,   216,    72,    -9,  -189,   -27,    -9, &
                 -576,  -189, -1728,  -576,    72,    54,   216,    72,   -90,    54,  -270,   -90,    -9,  -189,   -27,    -9]
  K1( 948,:) = [  -216,   -90,    72,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,    72,   -90,     0,    27,    -9,    -9,     0,    54,    72,    72,   216,  -189,    -9,    -9,   -27, &
                 -189,  -576,  -576, -1728,    54,    72,    72,   216,    54,   -90,   -90,  -270,  -189,    -9,    -9,   -27]
  K1( 949,:) = [   -27,     9,    -9,   -27,     0,   -90,   -72,   -54,   216,     9,    72,    27,   -27,   -72,    -9,  -216, &
                    0,    -9,   576,   189,   -27,   -72,    72,   216,     0,   -72,    -9,     0,     0,    90,   -90,   -54, &
                    0,    90,    72,    54,     0,     9,  -576,  -189,     0,     9,    -9,   189,     0,     9,    72,     0]
  K1( 950,:) = [     9,   -27,   -27,    -9,   -90,     0,   -54,   -72,     9,   216,    27,    72,   -72,   -27,  -216,    -9, &
                   -9,     0,   189,   576,   -72,   -27,   216,    72,   -72,     0,     0,    -9,    90,     0,   -54,   -90, &
                   90,     0,    54,    72,     9,     0,  -189,  -576,     9,     0,   189,    -9,     9,     0,     0,    72]
  K1( 951,:) = [    -9,    27,     0,    -9,    72,  -216,     0,   -90,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,   -90,  -216,     0,    72,    -9,  -189,   -27,    -9,   -90,    54,  -270,   -90, &
                   72,    54,   216,    72,  -576,  -189, -1728,  -576,    -9,  -189,   -27,    -9,    72,    54,   216,    72]
  K1( 952,:) = [    27,    -9,    -9,     0,  -216,    72,   -90,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,   -90,    72,     0,  -189,    -9,    -9,   -27,    54,   -90,   -90,  -270, &
                   54,    72,    72,   216,  -189,  -576,  -576, -1728,  -189,    -9,    -9,   -27,    54,    72,    72,   216]
  K1( 953,:) = [    27,     9,    72,   216,     0,    72,    90,    54,    27,   -72,    72,  -216,    27,     9,    -9,    27, &
                    0,  -576,     9,  -189,  -216,   -72,    -9,   -27,     0,     9,    72,     0,     0,   -72,   -90,   -54, &
                    0,    90,   -90,    54,     0,     9,    -9,  -189,     0,   576,    -9,   189,     0,   -72,    -9,     0]
  K1( 954,:) = [     9,    27,   216,    72,    72,     0,    54,    90,   -72,    27,  -216,    72,     9,    27,    27,    -9, &
                 -576,     0,  -189,     9,   -72,  -216,   -27,    -9,     9,     0,     0,    72,   -72,     0,   -54,   -90, &
                   90,     0,    54,   -90,     9,     0,  -189,    -9,   576,     0,   189,    -9,   -72,     0,     0,    -9]
  K1( 955,:) = [    -9,   -27,     0,    72,   -90,  -216,     0,   -90,    -9,   -27,     0,   -90,    72,   -27,     0,    -9, &
                   -9,  -216,     0,    -9,   -90,   -27,     0,    -9,    72,   189,   216,    72,   -90,   -54,  -270,   -90, &
                  -90,   -54,  -270,   -90,    -9,   189,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54,   -27,    -9]
  K1( 956,:) = [   -27,    -9,    72,     0,  -216,   -90,   -90,     0,   -27,    -9,   -90,     0,   -27,    72,    -9,     0, &
                 -216,    -9,    -9,     0,   -27,   -90,    -9,     0,   189,    72,    72,   216,   -54,   -90,   -90,  -270, &
                  -54,   -90,   -90,  -270,   189,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9,    -9,   -27]
  K1( 957,:) = [    27,    90,    72,   216,     0,    -9,     9,     0,  -216,   -72,  -576,  -216,   -27,   -72,   -90,  -216, &
                    0,    72,   -72,     0,   216,   576,    72,   216,     0,   -72,    72,     0,     0,     9,    72,   189, &
                    0,   -72,    -9,  -189,     0,     9,    72,    54,     0,   -72,    -9,   -54,     0,   -72,    72,     0]
  K1( 958,:) = [    90,    27,   216,    72,    -9,     0,     0,     9,   -72,  -216,  -216,  -576,   -72,   -27,  -216,   -90, &
                   72,     0,     0,   -72,   576,   216,   216,    72,   -72,     0,     0,    72,     9,     0,   189,    72, &
                  -72,     0,  -189,    -9,     9,     0,    54,    72,   -72,     0,   -54,    -9,   -72,     0,     0,    72]
  K1( 959,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1( 960,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1( 961,:) = [ -1944,  -648,  -648,  -189,  -243,  -648,     0,     0,     0,     0,     0,    54,     0,     0,    81,     0, &
                    0,    81,     0,     0,  -243,     0,  -648,     0,     0,  -648,   -81,  -432,     0,    81,    81,    54, &
                    0,     0,  -162,  -432,     0,     0,     0,    54,     0,   -81,  -648,  -432,     0,  -162,     0,  -432]
  K1( 962,:) = [  -648, -1944,  -189,  -648,  -648,  -243,     0,     0,     0,     0,    54,     0,     0,     0,     0,    81, &
                   81,     0,     0,     0,     0,  -243,     0,  -648,  -648,     0,  -432,   -81,    81,     0,    54,    81, &
                    0,     0,  -432,  -162,     0,     0,    54,     0,   -81,     0,  -432,  -648,  -162,     0,  -432,     0]
  K1( 963,:) = [  -648,  -189, -1944,  -648,     0,     0,  -243,  -648,     0,    54,     0,     0,    81,     0,     0,     0, &
                    0,     0,     0,    81,  -648,     0,  -243,     0,   -81,  -432,     0,  -648,    81,    54,     0,    81, &
                 -162,  -432,     0,     0,     0,    54,     0,     0,  -648,  -432,     0,   -81,     0,  -432,     0,  -162]
  K1( 964,:) = [  -189,  -648,  -648, -1944,     0,     0,  -648,  -243,    54,     0,     0,     0,     0,    81,     0,     0, &
                    0,     0,    81,     0,     0,  -648,     0,  -243,  -432,   -81,  -648,     0,    54,    81,    81,     0, &
                 -432,  -162,     0,     0,    54,     0,     0,     0,  -432,  -648,   -81,     0,  -432,     0,  -162,     0]
  K1( 965,:) = [  -243,  -648,     0,     0,     0,   -81,   648,   189,     0,     0,    81,     0,   432,    81,   648,   243, &
                    0,   -81,   -81,   -54,   -54,   -81,   -81,  -243,     0,    81,     0,     0,     0,    81,     0,   243, &
                    0,     0,  -648,  -243,     0,   162,    81,   243,     0,    81,  -162,  -243,     0,     0,   -81,     0]
  K1( 966,:) = [  -648,  -243,     0,     0,   -81,     0,   189,   648,     0,     0,     0,    81,    81,   432,   243,   648, &
                  -81,     0,   -54,   -81,   -81,   -54,  -243,   -81,    81,     0,     0,     0,    81,     0,   243,     0, &
                    0,     0,  -243,  -648,   162,     0,   243,    81,    81,     0,  -243,  -162,     0,     0,     0,   -81]
  K1( 967,:) = [     0,     0,  -243,  -648,   648,   189,     0,   -81,    81,     0,     0,     0,   648,   243,   432,    81, &
                  -81,   -54,     0,   -81,   -81,  -243,   -54,   -81,     0,     0,     0,    81,     0,   243,     0,    81, &
                 -648,  -243,     0,     0,    81,   243,     0,   162,  -162,  -243,     0,    81,   -81,     0,     0,     0]
  K1( 968,:) = [     0,     0,  -648,  -243,   189,   648,   -81,     0,     0,    81,     0,     0,   243,   648,    81,   432, &
                  -54,   -81,   -81,     0,  -243,   -81,   -81,   -54,     0,     0,    81,     0,   243,     0,    81,     0, &
                 -243,  -648,     0,     0,   243,    81,   162,     0,  -243,  -162,    81,     0,     0,   -81,     0,     0]
  K1( 969,:) = [     0,     0,     0,    54,     0,     0,    81,     0, -1944,  -648,  -648,  -189,  -243,  -648,     0,     0, &
                 -243,     0,  -648,     0,     0,    81,     0,     0,     0,     0,  -162,  -432,     0,     0,     0,    54, &
                    0,  -648,   -81,  -432,     0,    81,    81,    54,     0,  -162,     0,  -432,     0,   -81,  -648,  -432]
  K1( 970,:) = [     0,     0,    54,     0,     0,     0,     0,    81,  -648, -1944,  -189,  -648,  -648,  -243,     0,     0, &
                    0,  -243,     0,  -648,    81,     0,     0,     0,     0,     0,  -432,  -162,     0,     0,    54,     0, &
                 -648,     0,  -432,   -81,    81,     0,    54,    81,  -162,     0,  -432,     0,   -81,     0,  -432,  -648]
  K1( 971,:) = [     0,    54,     0,     0,    81,     0,     0,     0,  -648,  -189, -1944,  -648,     0,     0,  -243,  -648, &
                 -648,     0,  -243,     0,     0,     0,     0,    81,  -162,  -432,     0,     0,     0,    54,     0,     0, &
                  -81,  -432,     0,  -648,    81,    54,     0,    81,     0,  -432,     0,  -162,  -648,  -432,     0,   -81]
  K1( 972,:) = [    54,     0,     0,     0,     0,    81,     0,     0,  -189,  -648,  -648, -1944,     0,     0,  -648,  -243, &
                    0,  -648,     0,  -243,     0,     0,    81,     0,  -432,  -162,     0,     0,    54,     0,     0,     0, &
                 -432,   -81,  -648,     0,    54,    81,    81,     0,  -432,     0,  -162,     0,  -432,  -648,   -81,     0]
  K1( 973,:) = [     0,     0,    81,     0,   432,    81,   648,   243,  -243,  -648,     0,     0,     0,   -81,   648,   189, &
                  -54,   -81,   -81,  -243,     0,   -81,   -81,   -54,     0,     0,  -648,  -243,     0,   162,    81,   243, &
                    0,    81,     0,     0,     0,    81,     0,   243,     0,     0,   -81,     0,     0,    81,  -162,  -243]
  K1( 974,:) = [     0,     0,     0,    81,    81,   432,   243,   648,  -648,  -243,     0,     0,   -81,     0,   189,   648, &
                  -81,   -54,  -243,   -81,   -81,     0,   -54,   -81,     0,     0,  -243,  -648,   162,     0,   243,    81, &
                   81,     0,     0,     0,    81,     0,   243,     0,     0,     0,     0,   -81,    81,     0,  -243,  -162]
  K1( 975,:) = [    81,     0,     0,     0,   648,   243,   432,    81,     0,     0,  -243,  -648,   648,   189,     0,   -81, &
                  -81,  -243,   -54,   -81,   -81,   -54,     0,   -81,  -648,  -243,     0,     0,    81,   243,     0,   162, &
                    0,     0,     0,    81,     0,   243,     0,    81,   -81,     0,     0,     0,  -162,  -243,     0,    81]
  K1( 976,:) = [     0,    81,     0,     0,   243,   648,    81,   432,     0,     0,  -648,  -243,   189,   648,   -81,     0, &
                 -243,   -81,   -81,   -54,   -54,   -81,   -81,     0,  -243,  -648,     0,     0,   243,    81,   162,     0, &
                    0,     0,    81,     0,   243,     0,    81,     0,     0,   -81,     0,     0,  -243,  -162,    81,     0]
  K1( 977,:) = [     0,    81,     0,     0,     0,   -81,   -81,   -54,  -243,     0,  -648,     0,   -54,   -81,   -81,  -243, &
                    0,   648,   -81,   189,   432,   648,    81,   243,     0,   -81,     0,     0,     0,    81,   162,   243, &
                    0,  -162,    81,  -243,     0,     0,    81,   243,     0,  -648,     0,  -243,     0,     0,    81,     0]
  K1( 978,:) = [    81,     0,     0,     0,   -81,     0,   -54,   -81,     0,  -243,     0,  -648,   -81,   -54,  -243,   -81, &
                  648,     0,   189,   -81,   648,   432,   243,    81,   -81,     0,     0,     0,    81,     0,   243,   162, &
                 -162,     0,  -243,    81,     0,     0,   243,    81,  -648,     0,  -243,     0,     0,     0,     0,    81]
  K1( 979,:) = [     0,     0,     0,    81,   -81,   -54,     0,   -81,  -648,     0,  -243,     0,   -81,  -243,   -54,   -81, &
                  -81,   189,     0,   648,    81,   243,   432,   648,     0,     0,     0,   -81,   162,   243,     0,    81, &
                   81,  -243,     0,  -162,    81,   243,     0,     0,     0,  -243,     0,  -648,    81,     0,     0,     0]
  K1( 980,:) = [     0,     0,    81,     0,   -54,   -81,   -81,     0,     0,  -648,     0,  -243,  -243,   -81,   -81,   -54, &
                  189,   -81,   648,     0,   243,    81,   648,   432,     0,     0,   -81,     0,   243,   162,    81,     0, &
                 -243,    81,  -162,     0,   243,    81,     0,     0,  -243,     0,  -648,     0,     0,    81,     0,     0]
  K1( 981,:) = [  -243,     0,  -648,     0,   -54,   -81,   -81,  -243,     0,    81,     0,     0,     0,   -81,   -81,   -54, &
                  432,   648,    81,   243,     0,   648,   -81,   189,     0,  -162,    81,  -243,     0,     0,    81,   243, &
                    0,   -81,     0,     0,     0,    81,   162,   243,     0,     0,    81,     0,     0,  -648,     0,  -243]
  K1( 982,:) = [     0,  -243,     0,  -648,   -81,   -54,  -243,   -81,    81,     0,     0,     0,   -81,     0,   -54,   -81, &
                  648,   432,   243,    81,   648,     0,   189,   -81,  -162,     0,  -243,    81,     0,     0,   243,    81, &
                  -81,     0,     0,     0,    81,     0,   243,   162,     0,     0,     0,    81,  -648,     0,  -243,     0]
  K1( 983,:) = [  -648,     0,  -243,     0,   -81,  -243,   -54,   -81,     0,     0,     0,    81,   -81,   -54,     0,   -81, &
                   81,   243,   432,   648,   -81,   189,     0,   648,    81,  -243,     0,  -162,    81,   243,     0,     0, &
                    0,     0,     0,   -81,   162,   243,     0,    81,    81,     0,     0,     0,     0,  -243,     0,  -648]
  K1( 984,:) = [     0,  -648,     0,  -243,  -243,   -81,   -81,   -54,     0,     0,    81,     0,   -54,   -81,   -81,     0, &
                  243,    81,   648,   432,   189,   -81,   648,     0,  -243,    81,  -162,     0,   243,    81,     0,     0, &
                    0,     0,   -81,     0,   243,   162,    81,     0,     0,    81,     0,     0,  -243,     0,  -648,     0]
  K1( 985,:) = [     0,  -648,   -81,  -432,     0,    81,     0,     0,     0,     0,  -162,  -432,     0,     0,  -648,  -243, &
                    0,   -81,     0,     0,     0,  -162,    81,  -243, -1944,  -648,  -648,  -189,   243,    81,    81,    54, &
                    0,     0,     0,    54,     0,     0,     0,  -189,  -243,   -81,   -81,  -189,  -486,  -162,  -162,    54]
  K1( 986,:) = [  -648,     0,  -432,   -81,    81,     0,     0,     0,     0,     0,  -432,  -162,     0,     0,  -243,  -648, &
                  -81,     0,     0,     0,  -162,     0,  -243,    81,  -648, -1944,  -189,  -648,    81,   243,    54,    81, &
                    0,     0,    54,     0,     0,     0,  -189,     0,   -81,  -243,  -189,   -81,  -162,  -486,    54,  -162]
  K1( 987,:) = [   -81,  -432,     0,  -648,     0,     0,     0,    81,  -162,  -432,     0,     0,  -648,  -243,     0,     0, &
                    0,     0,     0,   -81,    81,  -243,     0,  -162,  -648,  -189, -1944,  -648,    81,    54,   243,    81, &
                    0,    54,     0,     0,     0,  -189,     0,     0,   -81,  -189,  -243,   -81,  -162,    54,  -486,  -162]
  K1( 988,:) = [  -432,   -81,  -648,     0,     0,     0,    81,     0,  -432,  -162,     0,     0,  -243,  -648,     0,     0, &
                    0,     0,   -81,     0,  -243,    81,  -162,     0,  -189,  -648,  -648, -1944,    54,    81,    81,   243, &
                   54,     0,     0,     0,  -189,     0,     0,     0,  -189,   -81,   -81,  -243,    54,  -162,  -162,  -486]
  K1( 989,:) = [     0,    81,    81,    54,     0,    81,     0,   243,     0,     0,     0,    54,     0,   162,    81,   243, &
                    0,    81,   162,   243,     0,     0,    81,   243,   243,    81,    81,    54,   243,    81,    81,  -189, &
                    0,     0,     0,  -189,   486,   162,   162,    54,   243,    81,    81,    54,     0,     0,     0,  -189]
  K1( 990,:) = [    81,     0,    54,    81,    81,     0,   243,     0,     0,     0,    54,     0,   162,     0,   243,    81, &
                   81,     0,   243,   162,     0,     0,   243,    81,    81,   243,    54,    81,    81,   243,  -189,    81, &
                    0,     0,  -189,     0,   162,   486,    54,   162,    81,   243,    54,    81,     0,     0,  -189,     0]
  K1( 991,:) = [    81,    54,     0,    81,     0,   243,     0,    81,     0,    54,     0,     0,    81,   243,     0,   162, &
                  162,   243,     0,    81,    81,   243,     0,     0,    81,    54,   243,    81,    81,  -189,   243,    81, &
                    0,  -189,     0,     0,   162,    54,   486,   162,    81,    54,   243,    81,     0,  -189,     0,     0]
  K1( 992,:) = [    54,    81,    81,     0,   243,     0,    81,     0,    54,     0,     0,     0,   243,    81,   162,     0, &
                  243,   162,    81,     0,   243,    81,     0,     0,    54,    81,    81,   243,  -189,    81,    81,   243, &
                 -189,     0,     0,     0,    54,   162,   162,   486,    54,    81,    81,   243,  -189,     0,     0,     0]
  K1( 993,:) = [     0,     0,  -162,  -432,     0,     0,  -648,  -243,     0,  -648,   -81,  -432,     0,    81,     0,     0, &
                    0,  -162,    81,  -243,     0,   -81,     0,     0,     0,     0,     0,    54,     0,     0,     0,  -189, &
                -1944,  -648,  -648,  -189,   243,    81,    81,    54,  -486,  -162,  -162,    54,  -243,   -81,   -81,  -189]
  K1( 994,:) = [     0,     0,  -432,  -162,     0,     0,  -243,  -648,  -648,     0,  -432,   -81,    81,     0,     0,     0, &
                 -162,     0,  -243,    81,   -81,     0,     0,     0,     0,     0,    54,     0,     0,     0,  -189,     0, &
                 -648, -1944,  -189,  -648,    81,   243,    54,    81,  -162,  -486,    54,  -162,   -81,  -243,  -189,   -81]
  K1( 995,:) = [  -162,  -432,     0,     0,  -648,  -243,     0,     0,   -81,  -432,     0,  -648,     0,     0,     0,    81, &
                   81,  -243,     0,  -162,     0,     0,     0,   -81,     0,    54,     0,     0,     0,  -189,     0,     0, &
                 -648,  -189, -1944,  -648,    81,    54,   243,    81,  -162,    54,  -486,  -162,   -81,  -189,  -243,   -81]
  K1( 996,:) = [  -432,  -162,     0,     0,  -243,  -648,     0,     0,  -432,   -81,  -648,     0,     0,     0,    81,     0, &
                 -243,    81,  -162,     0,     0,     0,   -81,     0,    54,     0,     0,     0,  -189,     0,     0,     0, &
                 -189,  -648,  -648, -1944,    54,    81,    81,   243,    54,  -162,  -162,  -486,  -189,   -81,   -81,  -243]
  K1( 997,:) = [     0,     0,     0,    54,     0,   162,    81,   243,     0,    81,    81,    54,     0,    81,     0,   243, &
                    0,     0,    81,   243,     0,    81,   162,   243,     0,     0,     0,  -189,   486,   162,   162,    54, &
                  243,    81,    81,    54,   243,    81,    81,  -189,     0,     0,     0,  -189,   243,    81,    81,    54]
  K1( 998,:) = [     0,     0,    54,     0,   162,     0,   243,    81,    81,     0,    54,    81,    81,     0,   243,     0, &
                    0,     0,   243,    81,    81,     0,   243,   162,     0,     0,  -189,     0,   162,   486,    54,   162, &
                   81,   243,    54,    81,    81,   243,  -189,    81,     0,     0,  -189,     0,    81,   243,    54,    81]
  K1( 999,:) = [     0,    54,     0,     0,    81,   243,     0,   162,    81,    54,     0,    81,     0,   243,     0,    81, &
                   81,   243,     0,     0,   162,   243,     0,    81,     0,  -189,     0,     0,   162,    54,   486,   162, &
                   81,    54,   243,    81,    81,  -189,   243,    81,     0,  -189,     0,     0,    81,    54,   243,    81]
  K1(1000,:) = [    54,     0,     0,     0,   243,    81,   162,     0,    54,    81,    81,     0,   243,     0,    81,     0, &
                  243,    81,     0,     0,   243,   162,    81,     0,  -189,     0,     0,     0,    54,   162,   162,   486, &
                   54,    81,    81,   243,  -189,    81,    81,   243,  -189,     0,     0,     0,    54,    81,    81,   243]
  K1(1001,:) = [     0,   -81,  -648,  -432,     0,    81,  -162,  -243,     0,  -162,     0,  -432,     0,     0,   -81,     0, &
                    0,  -648,     0,  -243,     0,     0,    81,     0,  -243,   -81,   -81,  -189,   243,    81,    81,    54, &
                 -486,  -162,  -162,    54,     0,     0,     0,  -189, -1944,  -648,  -648,  -189,     0,     0,     0,    54]
  K1(1002,:) = [   -81,     0,  -432,  -648,    81,     0,  -243,  -162,  -162,     0,  -432,     0,     0,     0,     0,   -81, &
                 -648,     0,  -243,     0,     0,     0,     0,    81,   -81,  -243,  -189,   -81,    81,   243,    54,    81, &
                 -162,  -486,    54,  -162,     0,     0,  -189,     0,  -648, -1944,  -189,  -648,     0,     0,    54,     0]
  K1(1003,:) = [  -648,  -432,     0,   -81,  -162,  -243,     0,    81,     0,  -432,     0,  -162,   -81,     0,     0,     0, &
                    0,  -243,     0,  -648,    81,     0,     0,     0,   -81,  -189,  -243,   -81,    81,    54,   243,    81, &
                 -162,    54,  -486,  -162,     0,  -189,     0,     0,  -648,  -189, -1944,  -648,     0,    54,     0,     0]
  K1(1004,:) = [  -432,  -648,   -81,     0,  -243,  -162,    81,     0,  -432,     0,  -162,     0,     0,   -81,     0,     0, &
                 -243,     0,  -648,     0,     0,    81,     0,     0,  -189,   -81,   -81,  -243,    54,    81,    81,   243, &
                   54,  -162,  -162,  -486,  -189,     0,     0,     0,  -189,  -648,  -648, -1944,    54,     0,     0,     0]
  K1(1005,:) = [     0,  -162,     0,  -432,     0,     0,   -81,     0,     0,   -81,  -648,  -432,     0,    81,  -162,  -243, &
                    0,     0,    81,     0,     0,  -648,     0,  -243,  -486,  -162,  -162,    54,     0,     0,     0,  -189, &
                 -243,   -81,   -81,  -189,   243,    81,    81,    54,     0,     0,     0,    54, -1944,  -648,  -648,  -189]
  K1(1006,:) = [  -162,     0,  -432,     0,     0,     0,     0,   -81,   -81,     0,  -432,  -648,    81,     0,  -243,  -162, &
                    0,     0,     0,    81,  -648,     0,  -243,     0,  -162,  -486,    54,  -162,     0,     0,  -189,     0, &
                  -81,  -243,  -189,   -81,    81,   243,    54,    81,     0,     0,    54,     0,  -648, -1944,  -189,  -648]
  K1(1007,:) = [     0,  -432,     0,  -162,   -81,     0,     0,     0,  -648,  -432,     0,   -81,  -162,  -243,     0,    81, &
                   81,     0,     0,     0,     0,  -243,     0,  -648,  -162,    54,  -486,  -162,     0,  -189,     0,     0, &
                  -81,  -189,  -243,   -81,    81,    54,   243,    81,     0,    54,     0,     0,  -648,  -189, -1944,  -648]
  K1(1008,:) = [  -432,     0,  -162,     0,     0,   -81,     0,     0,  -432,  -648,   -81,     0,  -243,  -162,    81,     0, &
                    0,    81,     0,     0,  -243,     0,  -648,     0,    54,  -162,  -162,  -486,  -189,     0,     0,     0, &
                 -189,   -81,   -81,  -243,    54,    81,    81,   243,    54,     0,     0,     0,  -189,  -648,  -648, -1944]
  K1(1009,:) = [  3456,  1152,  1152,   378,   432,  1152,    18,     0,  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,  -144,   180,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,   180,  -144,   432]
  K1(1010,:) = [  1152,  3456,   378,  1152,  1152,   432,     0,    18,  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 -144,     0,   432,   180,    18,     0,   -54,    18,    18,     0,   432,  1152,   180,     0,   432,  -144]
  K1(1011,:) = [  1152,   378,  3456,  1152,    18,     0,   432,  1152,  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                  180,   432,     0,  -144,    18,   -54,     0,    18,  1152,   432,     0,    18,  -144,   432,     0,   180]
  K1(1012,:) = [   378,  1152,  1152,  3456,     0,    18,  1152,   432,  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,   180,  -144,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,  -144,   180,     0]
  K1(1013,:) = [   432,  1152,    18,     0,  3456,  1152,  1152,   378,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                 -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,   180,  -144,   432,     0,  -144,   180,   432,     0,    18,    18,   -54]
  K1(1014,:) = [  1152,   432,     0,    18,  1152,  3456,   378,  1152,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,   180,     0,   432,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18]
  K1(1015,:) = [    18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                 -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,  -144,   432,     0,   180,   180,   432,     0,  -144,    18,   -54,     0,    18]
  K1(1016,:) = [     0,    18,  1152,   432,   378,  1152,  1152,  3456,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                 -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,  -144,   180,     0,   432,   180,  -144,     0,   -54,    18,    18,     0]
  K1(1017,:) = [  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,  3456,  1152,  1152,   378,   432,  1152,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,     0,  -144,   180,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,   180,  -144,   432,     0,    18,  1152,   432]
  K1(1018,:) = [  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  1152,  3456,   378,  1152,  1152,   432,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,     0,   432,  -144,    18,     0,   432,  1152]
  K1(1019,:) = [  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  1152,   378,  3456,  1152,    18,     0,   432,  1152, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,   432,     0,  -144,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   432,     0,   180,  1152,   432,     0,    18]
  K1(1020,:) = [  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   378,  1152,  1152,  3456,     0,    18,  1152,   432, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,   432,   180,  -144,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,  -144,   180,     0,   432,  1152,    18,     0]
  K1(1021,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   432,  1152,    18,     0,  3456,  1152,  1152,   378, &
                  -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,     0,    18,  1152,   432,     0,   180,  -144,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,  -144,   180,   432]
  K1(1022,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,   432,     0,    18,  1152,  3456,   378,  1152, &
                 -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,     0,   432,  1152,   180,     0,   432,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,  -144,     0,   432,   180]
  K1(1023,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   432,  1152,  1152,   378,  3456,  1152, &
                 -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,   432,     0,    18,  -144,   432,     0,   180, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144]
  K1(1024,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,  1152,   432,   378,  1152,  1152,  3456, &
                    0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,   432,  1152,    18,     0,   432,  -144,   180,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,   180,  -144,     0]
  K1(1025,:) = [   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                 3456,  1152,  1152,   378,   432,  1152,    18,     0,     0,    18,    18,   -54,     0,  -144,   180,   432, &
                    0,   180,  -144,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54]
  K1(1026,:) = [  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 1152,  3456,   378,  1152,  1152,   432,     0,    18,    18,     0,   -54,    18,  -144,     0,   432,   180, &
                  180,     0,   432,  -144,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144]
  K1(1027,:) = [  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 1152,   378,  3456,  1152,    18,     0,   432,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144, &
                 -144,   432,     0,   180,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144]
  K1(1028,:) = [     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                  378,  1152,  1152,  3456,     0,    18,  1152,   432,   -54,    18,    18,     0,   432,   180,  -144,     0, &
                  432,  -144,   180,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0]
  K1(1029,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108, &
                  432,  1152,    18,     0,  3456,  1152,  1152,   378,     0,   180,  -144,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,  -144,   180,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432]
  K1(1030,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144, &
                 1152,   432,     0,    18,  1152,  3456,   378,  1152,   180,     0,   432,  -144,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,  -144,     0,   432,   180,  -144,     0,   -54,  -144,  1152,     0,   432,    18]
  K1(1031,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144, &
                   18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,   432,     0,   180,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,   180,   432,     0,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152]
  K1(1032,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432, &
                    0,    18,  1152,   432,   378,  1152,  1152,  3456,   432,  -144,   180,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,   180,  -144,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0]
  K1(1033,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,   180,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,   180,  -144,   432,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108, &
                 -432,  -144,  -144,  -108,    54,    18,    18,   378,    54,    18,    18,   378,   540,   180,   180,  -108]
  K1(1034,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   432,   180,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,   180,     0,   432,  -144,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144, &
                 -144,  -432,  -108,  -144,    18,    54,   378,    18,    18,    54,   378,    18,   180,   540,  -108,   180]
  K1(1035,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,   180,   432,     0,  -144,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,  -144,   432,     0,   180,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144, &
                 -144,  -108,  -432,  -144,    18,   378,    54,    18,    18,   378,    54,    18,   180,  -108,   540,   180]
  K1(1036,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,   180,  -144,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,  -144,   180,     0,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432, &
                 -108,  -144,  -144,  -432,   378,    18,    18,    54,   378,    18,    18,    54,  -108,   180,   180,   540]
  K1(1037,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,   180,  -144,   432, &
                    0,  -144,   180,   432,     0,    18,  1152,   432,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378, &
                   54,    18,    18,   378,   540,   180,   180,  -108,  -432,  -144,  -144,  -108,    54,    18,    18,   378]
  K1(1038,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,   180,     0,   432,  -144, &
                 -144,     0,   432,   180,    18,     0,   432,  1152,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152, &
                   18,    54,   378,    18,   180,   540,  -108,   180,  -144,  -432,  -108,  -144,    18,    54,   378,    18]
  K1(1039,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,  -144,   432,     0,   180, &
                  180,   432,     0,  -144,  1152,   432,     0,    18,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152, &
                   18,   378,    54,    18,   180,  -108,   540,   180,  -144,  -108,  -432,  -144,    18,   378,    54,    18]
  K1(1040,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,  -144,   180,     0, &
                  432,   180,  -144,     0,   432,  1152,    18,     0,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456, &
                  378,    18,    18,    54,  -108,   180,   180,   540,  -108,  -144,  -144,  -432,   378,    18,    18,    54]
  K1(1041,:) = [     0,  -144,   180,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,   180,  -144,   432,     0,    18,    18,   -54,  -432,  -144,  -144,  -108,    54,    18,    18,   378, &
                 3456,  1152,  1152,   378,  -432,  -144,  -144,  -108,   540,   180,   180,  -108,    54,    18,    18,   378]
  K1(1042,:) = [  -144,     0,   432,   180,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                  180,     0,   432,  -144,    18,     0,   -54,    18,  -144,  -432,  -108,  -144,    18,    54,   378,    18, &
                 1152,  3456,   378,  1152,  -144,  -432,  -108,  -144,   180,   540,  -108,   180,    18,    54,   378,    18]
  K1(1043,:) = [   180,   432,     0,  -144,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 -144,   432,     0,   180,    18,   -54,     0,    18,  -144,  -108,  -432,  -144,    18,   378,    54,    18, &
                 1152,   378,  3456,  1152,  -144,  -108,  -432,  -144,   180,  -108,   540,   180,    18,   378,    54,    18]
  K1(1044,:) = [   432,   180,  -144,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,  -144,   180,     0,   -54,    18,    18,     0,  -108,  -144,  -144,  -432,   378,    18,    18,    54, &
                  378,  1152,  1152,  3456,  -108,  -144,  -144,  -432,  -108,   180,   180,   540,   378,    18,    18,    54]
  K1(1045,:) = [     0,    18,    18,   -54,     0,   180,  -144,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,  -144,   180,   432,    54,    18,    18,   378,   540,   180,   180,  -108, &
                 -432,  -144,  -144,  -108,  3456,  1152,  1152,   378,    54,    18,    18,   378,  -432,  -144,  -144,  -108]
  K1(1046,:) = [    18,     0,   -54,    18,   180,     0,   432,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,  -144,     0,   432,   180,    18,    54,   378,    18,   180,   540,  -108,   180, &
                 -144,  -432,  -108,  -144,  1152,  3456,   378,  1152,    18,    54,   378,    18,  -144,  -432,  -108,  -144]
  K1(1047,:) = [    18,   -54,     0,    18,  -144,   432,     0,   180,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,   180,   432,     0,  -144,    18,   378,    54,    18,   180,  -108,   540,   180, &
                 -144,  -108,  -432,  -144,  1152,   378,  3456,  1152,    18,   378,    54,    18,  -144,  -108,  -432,  -144]
  K1(1048,:) = [   -54,    18,    18,     0,   432,  -144,   180,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,   180,  -144,     0,   378,    18,    18,    54,  -108,   180,   180,   540, &
                 -108,  -144,  -144,  -432,   378,  1152,  1152,  3456,   378,    18,    18,    54,  -108,  -144,  -144,  -432]
  K1(1049,:) = [     0,    18,  1152,   432,     0,  -144,   180,   432,     0,   180,  -144,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,    54,    18,    18,   378,  -432,  -144,  -144,  -108, &
                  540,   180,   180,  -108,    54,    18,    18,   378,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108]
  K1(1050,:) = [    18,     0,   432,  1152,  -144,     0,   432,   180,   180,     0,   432,  -144,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,    18,    54,   378,    18,  -144,  -432,  -108,  -144, &
                  180,   540,  -108,   180,    18,    54,   378,    18,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144]
  K1(1051,:) = [  1152,   432,     0,    18,   180,   432,     0,  -144,  -144,   432,     0,   180,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,    18,   378,    54,    18,  -144,  -108,  -432,  -144, &
                  180,  -108,   540,   180,    18,   378,    54,    18,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144]
  K1(1052,:) = [   432,  1152,    18,     0,   432,   180,  -144,     0,   432,  -144,   180,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   378,    18,    18,    54,  -108,  -144,  -144,  -432, &
                 -108,   180,   180,   540,   378,    18,    18,    54,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432]
  K1(1053,:) = [     0,   180,  -144,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,  -144,   180,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   540,   180,   180,  -108,    54,    18,    18,   378, &
                   54,    18,    18,   378,  -432,  -144,  -144,  -108,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378]
  K1(1054,:) = [   180,     0,   432,  -144,    18,     0,   -54,    18,    18,     0,   432,  1152,  -144,     0,   432,   180, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,   180,   540,  -108,   180,    18,    54,   378,    18, &
                   18,    54,   378,    18,  -144,  -432,  -108,  -144,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152]
  K1(1055,:) = [  -144,   432,     0,   180,    18,   -54,     0,    18,  1152,   432,     0,    18,   180,   432,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,   180,  -108,   540,   180,    18,   378,    54,    18, &
                   18,   378,    54,    18,  -144,  -108,  -432,  -144,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152]
  K1(1056,:) = [   432,  -144,   180,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,   180,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,  -108,   180,   180,   540,   378,    18,    18,    54, &
                  378,    18,    18,    54,  -108,  -144,  -144,  -432,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456]
  K1(1057,:) = [     0,  -576,     9,  -189,  -216,   -72,    -9,   -27,     0,    72,    90,    54,    27,     9,    72,   216, &
                   27,     9,    -9,    27,    27,   -72,    72,  -216,     0,   576,    -9,   189,     0,   -72,    -9,     0, &
                    0,   -72,   -90,   -54,     0,     9,    72,     0,     0,     9,    -9,  -189,     0,    90,   -90,    54]
  K1(1058,:) = [  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    72,   216,    54,    72,    72,    27,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                   72,     0,  -216,   -90,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,   -90,     0,  -216,    72]
  K1(1059,:) = [     9,  -189,     0,  -576,    -9,   -27,  -216,   -72,    90,    54,     0,    72,    72,   216,    27,     9, &
                   -9,    27,    27,     9,    72,  -216,    27,   -72,    -9,   189,     0,   576,    -9,     0,     0,   -72, &
                  -90,   -54,     0,   -72,    72,     0,     0,     9,    -9,  -189,     0,     9,   -90,    54,     0,    90]
  K1(1060,:) = [  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    54,    72,    72,   216,     0,    72,    72,    27, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,   -90,    72,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,    72,   -90,     0]
  K1(1061,:) = [  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                  216,    72,    72,    54,    27,    72,    72,     0,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                    0,    -9,  -576,  -216,     0,   -90,    72,  -216,     0,    72,   -90,  -216,     0,    -9,    -9,    27]
  K1(1062,:) = [   -72,  -216,   -27,    -9,  -576,     0,  -189,     9,     9,    27,   216,    72,    -9,   189,     0,   576, &
                   72,     0,     0,     9,    -9,     0,     0,   -72,    72,   216,    27,     9,    72,  -216,    27,   -72, &
                   -9,   -27,  -216,   -72,    72,   -27,   216,   -72,    -9,    27,   -27,   -72,    72,    27,   -27,     9]
  K1(1063,:) = [    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   72,    54,   216,    72,    72,     0,    27,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                 -576,  -216,     0,    -9,    72,  -216,     0,   -90,   -90,  -216,     0,    72,    -9,    27,     0,    -9]
  K1(1064,:) = [   -27,    -9,   -72,  -216,  -189,     9,  -576,     0,   216,    72,     9,    27,     0,   576,    -9,   189, &
                    0,     9,    72,     0,     0,   -72,    -9,     0,    27,     9,    72,   216,    27,   -72,    72,  -216, &
                 -216,   -72,    -9,   -27,   216,   -72,    72,   -27,   -27,   -72,    -9,    27,   -27,     9,    72,    27]
  K1(1065,:) = [     0,    72,    90,    54,    27,     9,    72,   216,     0,  -576,     9,  -189,  -216,   -72,    -9,   -27, &
                   27,   -72,    72,  -216,    27,     9,    -9,    27,     0,   -72,   -90,   -54,     0,     9,    72,     0, &
                    0,   576,    -9,   189,     0,   -72,    -9,     0,     0,    90,   -90,    54,     0,     9,    -9,  -189]
  K1(1066,:) = [    72,   216,    54,    72,    72,    27,     0,    72,  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,     0,  -216,    72,    -9,     0,  -216,  -576]
  K1(1067,:) = [    90,    54,     0,    72,    72,   216,    27,     9,     9,  -189,     0,  -576,    -9,   -27,  -216,   -72, &
                   72,  -216,    27,   -72,    -9,    27,    27,     9,   -90,   -54,     0,   -72,    72,     0,     0,     9, &
                   -9,   189,     0,   576,    -9,     0,     0,   -72,   -90,    54,     0,    90,    -9,  -189,     0,     9]
  K1(1068,:) = [    54,    72,    72,   216,     0,    72,    72,    27,  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,  -216,   -90,    72,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,    72,   -90,     0,  -216,  -576,    -9,     0]
  K1(1069,:) = [    27,    72,    72,     0,  -216,    -9,  -576,     0,  -216,  -576,    -9,     0, -1728,  -576,  -576,  -189, &
                   27,    72,    72,     0,   216,    72,    72,    54,     0,    -9,  -576,  -216,     0,   -90,    72,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,    -9,    27,     0,    72,   -90,  -216]
  K1(1070,:) = [     9,    27,   216,    72,    -9,   189,     0,   576,   -72,  -216,   -27,    -9,  -576,     0,  -189,     9, &
                   -9,     0,     0,   -72,    72,     0,     0,     9,    -9,   -27,  -216,   -72,    72,   -27,   216,   -72, &
                   72,   216,    27,     9,    72,  -216,    27,   -72,    72,    27,   -27,     9,    -9,    27,   -27,   -72]
  K1(1071,:) = [    72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,  -216,  -576,  -576,  -189, -1728,  -576, &
                   72,     0,    27,    72,    72,    54,   216,    72,  -576,  -216,     0,    -9,    72,  -216,     0,   -90, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72]
  K1(1072,:) = [   216,    72,     9,    27,     0,   576,    -9,   189,   -27,    -9,   -72,  -216,  -189,     9,  -576,     0, &
                    0,   -72,    -9,     0,     0,     9,    72,     0,  -216,   -72,    -9,   -27,   216,   -72,    72,   -27, &
                   27,     9,    72,   216,    27,   -72,    72,  -216,   -27,     9,    72,    27,   -27,   -72,    -9,    27]
  K1(1073,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1(1074,:) = [     9,    27,    27,    72,    72,     0,    54,     9,   -72,  -216,  -216,  -576,    72,     0,     0,   -72, &
                   72,     0,     0,   -72,    72,    54,     0,     9,    -9,   -27,    27,     9,    -9,    27,    27,    90, &
                  -90,   -27,  -216,   -72,    72,   216,   216,   576,    -9,    27,   -27,     9,   -90,  -216,   -27,   -72]
  K1(1075,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1(1076,:) = [    27,    72,     9,    27,    54,     9,    72,     0,  -216,  -576,   -72,  -216,     0,   -72,    72,     0, &
                    0,   -72,    72,     0,     0,     9,    72,    54,    27,     9,    -9,   -27,    27,    90,    -9,    27, &
                 -216,   -72,   -90,   -27,   216,   576,    72,   216,   -27,     9,    -9,    27,   -27,   -72,   -90,  -216]
  K1(1077,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1(1078,:) = [   -72,  -216,  -216,  -576,    72,     0,     0,   -72,     9,    27,    27,    72,    72,     0,    54,     9, &
                   72,    54,     0,     9,    72,     0,     0,   -72,   -90,   -27,  -216,   -72,    72,   216,   216,   576, &
                   -9,   -27,    27,     9,    -9,    27,    27,    90,   -90,  -216,   -27,   -72,    -9,    27,   -27,     9]
  K1(1079,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1(1080,:) = [  -216,  -576,   -72,  -216,     0,   -72,    72,     0,    27,    72,     9,    27,    54,     9,    72,     0, &
                    0,     9,    72,    54,     0,   -72,    72,     0,  -216,   -72,   -90,   -27,   216,   576,    72,   216, &
                   27,     9,    -9,   -27,    27,    90,    -9,    27,   -27,   -72,   -90,  -216,   -27,     9,    -9,    27]
  K1(1081,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,   -90,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,   -90,    72,  -216, -1728,  -576,  -576,  -189,   216,    72,    72,    54, &
                  216,    72,    72,    54,   -27,    -9,    -9,  -189,   -27,    -9,    -9,  -189,  -270,   -90,   -90,    54]
  K1(1082,:) = [   576,     0,   189,    -9,    72,   216,    27,     9,   -72,     0,   -54,   -90,    -9,   -27,  -216,   -72, &
                   -9,   -27,   -27,     9,    72,   -27,   216,   -72,  -576,     0,  -189,     9,    72,     0,     0,     9, &
                   72,     0,    54,    90,    -9,     0,     0,   -72,    -9,     0,   189,     9,   -90,     0,   -54,    90]
  K1(1083,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,   -90,  -216,     0,    72,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,    72,  -216,     0,   -90,  -576,  -189, -1728,  -576,    72,    54,   216,    72, &
                   72,    54,   216,    72,    -9,  -189,   -27,    -9,    -9,  -189,   -27,    -9,   -90,    54,  -270,   -90]
  K1(1084,:) = [   189,    -9,   576,     0,    27,     9,    72,   216,   -54,   -90,   -72,     0,  -216,   -72,    -9,   -27, &
                  -27,     9,    -9,   -27,   216,   -72,    72,   -27,  -189,     9,  -576,     0,     0,     9,    72,     0, &
                   54,    90,    72,     0,     0,   -72,    -9,     0,   189,     9,    -9,     0,   -54,    90,   -90,     0]
  K1(1085,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1(1086,:) = [   -72,     0,     0,    72,  -576,  -216,  -216,   -72,     9,     0,     0,    -9,   -90,   -27,  -216,   -72, &
                   72,    27,   216,    90,    72,   216,   216,   576,    72,     0,    54,     9,    72,     0,     0,   -72, &
                   -9,     0,  -189,   -72,    72,     0,     0,   -72,    -9,     0,   -54,   -72,    72,     0,   189,     9]
  K1(1087,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1(1088,:) = [     0,    72,   -72,     0,  -216,   -72,  -576,  -216,     0,    -9,     9,     0,  -216,   -72,   -90,   -27, &
                  216,    90,    72,    27,   216,   576,    72,   216,    54,     9,    72,     0,     0,   -72,    72,     0, &
                 -189,   -72,    -9,     0,     0,   -72,    72,     0,   -54,   -72,    -9,     0,   189,     9,    72,     0]
  K1(1089,:) = [     0,    72,   -90,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,   -90,    72,  -216,     0,    -9,    -9,    27,   216,    72,    72,    54,   -27,    -9,    -9,  -189, &
                -1728,  -576,  -576,  -189,   216,    72,    72,    54,  -270,   -90,   -90,    54,   -27,    -9,    -9,  -189]
  K1(1090,:) = [   -72,     0,   -54,   -90,    -9,   -27,  -216,   -72,   576,     0,   189,    -9,    72,   216,    27,     9, &
                   72,   -27,   216,   -72,    -9,   -27,   -27,     9,    72,     0,    54,    90,    -9,     0,     0,   -72, &
                 -576,     0,  -189,     9,    72,     0,     0,     9,   -90,     0,   -54,    90,    -9,     0,   189,     9]
  K1(1091,:) = [   -90,  -216,     0,    72,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                   72,  -216,     0,   -90,    -9,    27,     0,    -9,    72,    54,   216,    72,    -9,  -189,   -27,    -9, &
                 -576,  -189, -1728,  -576,    72,    54,   216,    72,   -90,    54,  -270,   -90,    -9,  -189,   -27,    -9]
  K1(1092,:) = [   -54,   -90,   -72,     0,  -216,   -72,    -9,   -27,   189,    -9,   576,     0,    27,     9,    72,   216, &
                  216,   -72,    72,   -27,   -27,     9,    -9,   -27,    54,    90,    72,     0,     0,   -72,    -9,     0, &
                 -189,     9,  -576,     0,     0,     9,    72,     0,   -54,    90,   -90,     0,   189,     9,    -9,     0]
  K1(1093,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1(1094,:) = [     9,     0,     0,    -9,   -90,   -27,  -216,   -72,   -72,     0,     0,    72,  -576,  -216,  -216,   -72, &
                   72,   216,   216,   576,    72,    27,   216,    90,    -9,     0,  -189,   -72,    72,     0,     0,   -72, &
                   72,     0,    54,     9,    72,     0,     0,   -72,    72,     0,   189,     9,    -9,     0,   -54,   -72]
  K1(1095,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1(1096,:) = [     0,    -9,     9,     0,  -216,   -72,   -90,   -27,     0,    72,   -72,     0,  -216,   -72,  -576,  -216, &
                  216,   576,    72,   216,   216,    90,    72,    27,  -189,   -72,    -9,     0,     0,   -72,    72,     0, &
                   54,     9,    72,     0,     0,   -72,    72,     0,   189,     9,    72,     0,   -54,   -72,    -9,     0]
  K1(1097,:) = [     0,    -9,    -9,  -216,     0,    -9,   -90,   -27,     0,   -90,   -90,  -216,     0,    72,    -9,   -27, &
                    0,    -9,    72,   -27,     0,   -90,    -9,   -27,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54, &
                 -270,   -90,   -90,   -54,   216,    72,    72,   189,   -27,    -9,    -9,   189,  -270,   -90,   -90,   -54]
  K1(1098,:) = [     9,     0,  -189,  -576,    72,    27,  -216,   -72,    90,     0,    54,    72,    -9,    27,    27,     9, &
                   72,    27,   216,     9,    -9,  -216,   -27,   -72,    -9,     0,  -189,     9,    -9,     0,     0,   -72, &
                  -90,     0,    54,    90,    72,     0,     0,     9,    -9,     0,   189,   576,   -90,     0,   -54,   -72]
  K1(1099,:) = [    -9,  -216,     0,    -9,   -90,   -27,     0,    -9,   -90,  -216,     0,   -90,    -9,   -27,     0,    72, &
                   72,   -27,     0,    -9,    -9,   -27,     0,   -90,    -9,   189,   -27,    -9,    -9,   -54,   -27,    -9, &
                  -90,   -54,  -270,   -90,    72,   189,   216,    72,    -9,   189,   -27,    -9,   -90,   -54,  -270,   -90]
  K1(1100,:) = [  -189,  -576,     9,     0,  -216,   -72,    72,    27,    54,    72,    90,     0,    27,     9,    -9,    27, &
                  216,     9,    72,    27,   -27,   -72,    -9,  -216,  -189,     9,    -9,     0,     0,   -72,    -9,     0, &
                   54,    90,   -90,     0,     0,     9,    72,     0,   189,   576,    -9,     0,   -54,   -72,   -90,     0]
  K1(1101,:) = [     0,   -90,   -90,  -216,     0,    72,    -9,   -27,     0,    -9,    -9,  -216,     0,    -9,   -90,   -27, &
                    0,   -90,    -9,   -27,     0,    -9,    72,   -27,  -270,   -90,   -90,   -54,   216,    72,    72,   189, &
                  -27,    -9,    -9,   189,   -27,    -9,    -9,   -54,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   189]
  K1(1102,:) = [    90,     0,    54,    72,    -9,    27,    27,     9,     9,     0,  -189,  -576,    72,    27,  -216,   -72, &
                   -9,  -216,   -27,   -72,    72,    27,   216,     9,   -90,     0,    54,    90,    72,     0,     0,     9, &
                   -9,     0,  -189,     9,    -9,     0,     0,   -72,   -90,     0,   -54,   -72,    -9,     0,   189,   576]
  K1(1103,:) = [   -90,  -216,     0,   -90,    -9,   -27,     0,    72,    -9,  -216,     0,    -9,   -90,   -27,     0,    -9, &
                   -9,   -27,     0,   -90,    72,   -27,     0,    -9,   -90,   -54,  -270,   -90,    72,   189,   216,    72, &
                   -9,   189,   -27,    -9,    -9,   -54,   -27,    -9,   -90,   -54,  -270,   -90,    -9,   189,   -27,    -9]
  K1(1104,:) = [    54,    72,    90,     0,    27,     9,    -9,    27,  -189,  -576,     9,     0,  -216,   -72,    72,    27, &
                  -27,   -72,    -9,  -216,   216,     9,    72,    27,    54,    90,   -90,     0,     0,     9,    72,     0, &
                 -189,     9,    -9,     0,     0,   -72,    -9,     0,   -54,   -72,   -90,     0,   189,   576,    -9,     0]
  K1(1105,:) = [ -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,   216,    72,    72,    54,    27,    72,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,    72,   -90,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,   -90,    72,  -216]
  K1(1106,:) = [  -576,     0,  -189,     9,   -72,  -216,   -27,    -9,    72,     0,    54,    90,     9,    27,   216,    72, &
                    9,    27,    27,    -9,   -72,    27,  -216,    72,   576,     0,   189,    -9,   -72,     0,     0,    -9, &
                  -72,     0,   -54,   -90,     9,     0,     0,    72,     9,     0,  -189,    -9,    90,     0,    54,   -90]
  K1(1107,:) = [  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    72,    54,   216,    72,    72,     0,    27,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                  -90,  -216,     0,    72,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,    72,  -216,     0,   -90]
  K1(1108,:) = [  -189,     9,  -576,     0,   -27,    -9,   -72,  -216,    54,    90,    72,     0,   216,    72,     9,    27, &
                   27,    -9,     9,    27,  -216,    72,   -72,    27,   189,    -9,   576,     0,     0,    -9,   -72,     0, &
                  -54,   -90,   -72,     0,     0,    72,     9,     0,  -189,    -9,     9,     0,    54,   -90,    90,     0]
  K1(1109,:) = [  -216,   -72,    -9,   -27,     0,  -576,     9,  -189,    27,     9,    72,   216,   189,    -9,   576,     0, &
                    0,    72,     9,     0,     0,    -9,   -72,     0,   216,    72,     9,    27,  -216,    72,   -72,    27, &
                  -27,    -9,   -72,  -216,   -27,    72,   -72,   216,    27,    -9,   -72,   -27,    27,    72,     9,   -27]
  K1(1110,:) = [  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,    72,    27,     0,    72,    -9,  -216,     0,  -576, &
                   72,   216,    54,    72,    72,    27,     0,    72,    72,     0,    27,    72,  -576,     0,  -216,    -9, &
                   -9,     0,  -216,  -576,   -90,     0,  -216,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9]
  K1(1111,:) = [    -9,   -27,  -216,   -72,     9,  -189,     0,  -576,    72,   216,    27,     9,   576,     0,   189,    -9, &
                    9,     0,     0,    72,   -72,     0,     0,    -9,     9,    27,   216,    72,   -72,    27,  -216,    72, &
                  -72,  -216,   -27,    -9,   -72,   216,   -27,    72,   -72,   -27,    27,    -9,     9,   -27,    27,    72]
  K1(1112,:) = [     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,     0,    72,    72,    27,     0,  -576,    -9,  -216, &
                   54,    72,    72,   216,     0,    72,    72,    27,    27,    72,    72,     0,  -216,    -9,  -576,     0, &
                 -216,  -576,    -9,     0,  -216,    72,   -90,     0,  -216,   -90,    72,     0,    27,    -9,    -9,     0]
  K1(1113,:) = [   216,    72,    72,    54,    27,    72,    72,     0, -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,     0,    72,   -90,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,     0,   -90,    72,  -216,     0,    -9,  -576,  -216]
  K1(1114,:) = [    72,     0,    54,    90,     9,    27,   216,    72,  -576,     0,  -189,     9,   -72,  -216,   -27,    -9, &
                  -72,    27,  -216,    72,     9,    27,    27,    -9,   -72,     0,   -54,   -90,     9,     0,     0,    72, &
                  576,     0,   189,    -9,   -72,     0,     0,    -9,    90,     0,    54,   -90,     9,     0,  -189,    -9]
  K1(1115,:) = [    72,    54,   216,    72,    72,     0,    27,    72,  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,  -216,     0,    72,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,  -216,     0,   -90,  -576,  -216,     0,    -9]
  K1(1116,:) = [    54,    90,    72,     0,   216,    72,     9,    27,  -189,     9,  -576,     0,   -27,    -9,   -72,  -216, &
                 -216,    72,   -72,    27,    27,    -9,     9,    27,   -54,   -90,   -72,     0,     0,    72,     9,     0, &
                  189,    -9,   576,     0,     0,    -9,   -72,     0,    54,   -90,    90,     0,  -189,    -9,     9,     0]
  K1(1117,:) = [    27,     9,    72,   216,   189,    -9,   576,     0,  -216,   -72,    -9,   -27,     0,  -576,     9,  -189, &
                    0,    -9,   -72,     0,     0,    72,     9,     0,   -27,    -9,   -72,  -216,   -27,    72,   -72,   216, &
                  216,    72,     9,    27,  -216,    72,   -72,    27,    27,    72,     9,   -27,    27,    -9,   -72,   -27]
  K1(1118,:) = [    72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,  -216,     0,    -9,  -576, -1728,  -189,  -576, &
                   72,    27,     0,    72,    72,   216,    54,    72,    -9,     0,  -216,  -576,   -90,     0,  -216,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90]
  K1(1119,:) = [    72,   216,    27,     9,   576,     0,   189,    -9,    -9,   -27,  -216,   -72,     9,  -189,     0,  -576, &
                  -72,     0,     0,    -9,     9,     0,     0,    72,   -72,  -216,   -27,    -9,   -72,   216,   -27,    72, &
                    9,    27,   216,    72,   -72,    27,  -216,    72,     9,   -27,    27,    72,   -72,   -27,    27,    -9]
  K1(1120,:) = [     0,    72,    72,    27,     0,  -576,    -9,  -216,     0,    -9,  -576,  -216,  -189,  -576,  -576, -1728, &
                    0,    72,    72,    27,    54,    72,    72,   216,  -216,  -576,    -9,     0,  -216,    72,   -90,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    27,    -9,    -9,     0,  -216,   -90,    72,     0]
  K1(1121,:) = [    27,     9,    72,    27,     0,    72,     9,    54,  -216,   -72,  -576,  -216,     0,    72,   -72,     0, &
                    0,    72,   -72,     0,    54,    72,     9,     0,   -27,    -9,     9,    27,    27,    -9,    90,    27, &
                  -27,   -90,   -72,  -216,   216,    72,   576,   216,    27,    -9,     9,   -27,  -216,   -90,   -72,   -27]
  K1(1122,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1(1123,:) = [    72,    27,    27,     9,     9,    54,     0,    72,  -576,  -216,  -216,   -72,   -72,     0,     0,    72, &
                  -72,     0,     0,    72,     9,     0,    54,    72,     9,    27,   -27,    -9,    90,    27,    27,    -9, &
                  -72,  -216,   -27,   -90,   576,   216,   216,    72,     9,   -27,    27,    -9,   -72,   -27,  -216,   -90]
  K1(1124,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1(1125,:) = [  -216,   -72,  -576,  -216,     0,    72,   -72,     0,    27,     9,    72,    27,     0,    72,     9,    54, &
                   54,    72,     9,     0,     0,    72,   -72,     0,   -27,   -90,   -72,  -216,   216,    72,   576,   216, &
                  -27,    -9,     9,    27,    27,    -9,    90,    27,  -216,   -90,   -72,   -27,    27,    -9,     9,   -27]
  K1(1126,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1(1127,:) = [  -576,  -216,  -216,   -72,   -72,     0,     0,    72,    72,    27,    27,     9,     9,    54,     0,    72, &
                    9,     0,    54,    72,   -72,     0,     0,    72,   -72,  -216,   -27,   -90,   576,   216,   216,    72, &
                    9,    27,   -27,    -9,    90,    27,    27,    -9,   -72,   -27,  -216,   -90,     9,   -27,    27,    -9]
  K1(1128,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1(1129,:) = [     0,   576,    -9,   189,   216,    72,     9,    27,     0,   -72,   -90,   -54,   -27,    -9,   -72,  -216, &
                  -27,    -9,     9,   -27,   -27,    72,   -72,   216,     0,  -576,     9,  -189,     0,    72,     9,     0, &
                    0,    72,    90,    54,     0,    -9,   -72,     0,     0,    -9,     9,   189,     0,   -90,    90,   -54]
  K1(1130,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,  -216,   -90,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,   -90,     0,  -216,    72,  -576, -1728,  -189,  -576,    72,   216,    54,    72, &
                   72,   216,    54,    72,    -9,   -27,  -189,    -9,    -9,   -27,  -189,    -9,   -90,  -270,    54,   -90]
  K1(1131,:) = [    -9,   189,     0,   576,     9,    27,   216,    72,   -90,   -54,     0,   -72,   -72,  -216,   -27,    -9, &
                    9,   -27,   -27,    -9,   -72,   216,   -27,    72,     9,  -189,     0,  -576,     9,     0,     0,    72, &
                   90,    54,     0,    72,   -72,     0,     0,    -9,     9,   189,     0,    -9,    90,   -54,     0,   -90]
  K1(1132,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,   -90,    72,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,    72,   -90,     0,  -189,  -576,  -576, -1728,    54,    72,    72,   216, &
                   54,    72,    72,   216,  -189,    -9,    -9,   -27,  -189,    -9,    -9,   -27,    54,   -90,   -90,  -270]
  K1(1133,:) = [     0,   -72,    72,     0,  -216,  -576,   -72,  -216,     0,     9,    -9,     0,   -27,   -90,   -72,  -216, &
                   27,    72,    90,   216,   216,    72,   576,   216,     0,    72,     9,    54,     0,    72,   -72,     0, &
                    0,    -9,   -72,  -189,     0,    72,   -72,     0,     0,    -9,   -72,   -54,     0,    72,     9,   189]
  K1(1134,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1(1135,:) = [    72,     0,     0,   -72,   -72,  -216,  -216,  -576,    -9,     0,     0,     9,   -72,  -216,   -27,   -90, &
                   90,   216,    27,    72,   576,   216,   216,    72,     9,    54,     0,    72,   -72,     0,     0,    72, &
                  -72,  -189,     0,    -9,   -72,     0,     0,    72,   -72,   -54,     0,    -9,     9,   189,     0,    72]
  K1(1136,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1(1137,:) = [     0,   -72,   -90,   -54,   -27,    -9,   -72,  -216,     0,   576,    -9,   189,   216,    72,     9,    27, &
                  -27,    72,   -72,   216,   -27,    -9,     9,   -27,     0,    72,    90,    54,     0,    -9,   -72,     0, &
                    0,  -576,     9,  -189,     0,    72,     9,     0,     0,   -90,    90,   -54,     0,    -9,     9,   189]
  K1(1138,:) = [    72,     0,  -216,   -90,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                  -90,     0,  -216,    72,    -9,     0,    27,    -9,    72,   216,    54,    72,    -9,   -27,  -189,    -9, &
                 -576, -1728,  -189,  -576,    72,   216,    54,    72,   -90,  -270,    54,   -90,    -9,   -27,  -189,    -9]
  K1(1139,:) = [   -90,   -54,     0,   -72,   -72,  -216,   -27,    -9,    -9,   189,     0,   576,     9,    27,   216,    72, &
                  -72,   216,   -27,    72,     9,   -27,   -27,    -9,    90,    54,     0,    72,   -72,     0,     0,    -9, &
                    9,  -189,     0,  -576,     9,     0,     0,    72,    90,   -54,     0,   -90,     9,   189,     0,    -9]
  K1(1140,:) = [  -216,   -90,    72,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,    72,   -90,     0,    27,    -9,    -9,     0,    54,    72,    72,   216,  -189,    -9,    -9,   -27, &
                 -189,  -576,  -576, -1728,    54,    72,    72,   216,    54,   -90,   -90,  -270,  -189,    -9,    -9,   -27]
  K1(1141,:) = [     0,     9,    -9,     0,   -27,   -90,   -72,  -216,     0,   -72,    72,     0,  -216,  -576,   -72,  -216, &
                  216,    72,   576,   216,    27,    72,    90,   216,     0,    -9,   -72,  -189,     0,    72,   -72,     0, &
                    0,    72,     9,    54,     0,    72,   -72,     0,     0,    72,     9,   189,     0,    -9,   -72,   -54]
  K1(1142,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1(1143,:) = [    -9,     0,     0,     9,   -72,  -216,   -27,   -90,    72,     0,     0,   -72,   -72,  -216,  -216,  -576, &
                  576,   216,   216,    72,    90,   216,    27,    72,   -72,  -189,     0,    -9,   -72,     0,     0,    72, &
                    9,    54,     0,    72,   -72,     0,     0,    72,     9,   189,     0,    72,   -72,   -54,     0,    -9]
  K1(1144,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1(1145,:) = [     0,     9,  -576,  -189,    27,    72,   -72,  -216,     0,    90,    72,    54,    27,    -9,     9,    27, &
                   27,    72,     9,   216,  -216,    -9,   -72,   -27,     0,    -9,     9,  -189,     0,    -9,   -72,     0, &
                    0,   -90,    90,    54,     0,    72,     9,     0,     0,    -9,   576,   189,     0,   -90,   -72,   -54]
  K1(1146,:) = [    -9,     0,  -216,    -9,    -9,     0,   -27,   -90,   -90,     0,  -216,   -90,    72,     0,   -27,    -9, &
                   -9,     0,   -27,    72,   -90,     0,   -27,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9, &
                  -90,  -270,   -54,   -90,    72,   216,   189,    72,    -9,   -27,   189,    -9,   -90,  -270,   -54,   -90]
  K1(1147,:) = [  -576,  -189,     0,     9,   -72,  -216,    27,    72,    72,    54,     0,    90,     9,    27,    27,    -9, &
                    9,   216,    27,    72,   -72,   -27,  -216,    -9,     9,  -189,     0,    -9,   -72,     0,     0,    -9, &
                   90,    54,     0,   -90,     9,     0,     0,    72,   576,   189,     0,    -9,   -72,   -54,     0,   -90]
  K1(1148,:) = [  -216,    -9,    -9,     0,   -27,   -90,    -9,     0,  -216,   -90,   -90,     0,   -27,    -9,    72,     0, &
                  -27,    72,    -9,     0,   -27,    -9,   -90,     0,   189,    -9,    -9,   -27,   -54,    -9,    -9,   -27, &
                  -54,   -90,   -90,  -270,   189,    72,    72,   216,   189,    -9,    -9,   -27,   -54,   -90,   -90,  -270]
  K1(1149,:) = [     0,    90,    72,    54,    27,    -9,     9,    27,     0,     9,  -576,  -189,    27,    72,   -72,  -216, &
                 -216,    -9,   -72,   -27,    27,    72,     9,   216,     0,   -90,    90,    54,     0,    72,     9,     0, &
                    0,    -9,     9,  -189,     0,    -9,   -72,     0,     0,   -90,   -72,   -54,     0,    -9,   576,   189]
  K1(1150,:) = [   -90,     0,  -216,   -90,    72,     0,   -27,    -9,    -9,     0,  -216,    -9,    -9,     0,   -27,   -90, &
                  -90,     0,   -27,    -9,    -9,     0,   -27,    72,   -90,  -270,   -54,   -90,    72,   216,   189,    72, &
                   -9,   -27,   189,    -9,    -9,   -27,   -54,    -9,   -90,  -270,   -54,   -90,    -9,   -27,   189,    -9]
  K1(1151,:) = [    72,    54,     0,    90,     9,    27,    27,    -9,  -576,  -189,     0,     9,   -72,  -216,    27,    72, &
                  -72,   -27,  -216,    -9,     9,   216,    27,    72,    90,    54,     0,   -90,     9,     0,     0,    72, &
                    9,  -189,     0,    -9,   -72,     0,     0,    -9,   -72,   -54,     0,   -90,   576,   189,     0,    -9]
  K1(1152,:) = [  -216,   -90,   -90,     0,   -27,    -9,    72,     0,  -216,    -9,    -9,     0,   -27,   -90,    -9,     0, &
                  -27,    -9,   -90,     0,   -27,    72,    -9,     0,   -54,   -90,   -90,  -270,   189,    72,    72,   216, &
                  189,    -9,    -9,   -27,   -54,    -9,    -9,   -27,   -54,   -90,   -90,  -270,   189,    -9,    -9,   -27]
  K1(1153,:) = [     0,     9,  -576,  -189,    27,    72,   -72,  -216,     0,    90,    72,    54,    27,    -9,     9,    27, &
                   27,    72,     9,   216,  -216,    -9,   -72,   -27,     0,    -9,     9,  -189,     0,    -9,   -72,     0, &
                    0,   -90,    90,    54,     0,    72,     9,     0,     0,    -9,   576,   189,     0,   -90,   -72,   -54]
  K1(1154,:) = [     9,     0,  -189,  -576,    72,    27,  -216,   -72,    90,     0,    54,    72,    -9,    27,    27,     9, &
                   72,    27,   216,     9,    -9,  -216,   -27,   -72,    -9,     0,  -189,     9,    -9,     0,     0,   -72, &
                  -90,     0,    54,    90,    72,     0,     0,     9,    -9,     0,   189,   576,   -90,     0,   -54,   -72]
  K1(1155,:) = [  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    72,    54,   216,    72,    72,     0,    27,    72, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                  -90,  -216,     0,    72,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,    72,  -216,     0,   -90]
  K1(1156,:) = [  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    54,    72,    72,   216,     0,    72,    72,    27, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                 -216,   -90,    72,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,    72,   -90,     0]
  K1(1157,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1(1158,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1(1159,:) = [   -72,  -216,  -216,  -576,    72,     0,     0,   -72,     9,    27,    27,    72,    72,     0,    54,     9, &
                   72,    54,     0,     9,    72,     0,     0,   -72,   -90,   -27,  -216,   -72,    72,   216,   216,   576, &
                   -9,   -27,    27,     9,    -9,    27,    27,    90,   -90,  -216,   -27,   -72,    -9,    27,   -27,     9]
  K1(1160,:) = [  -216,   -72,  -576,  -216,     0,    72,   -72,     0,    27,     9,    72,    27,     0,    72,     9,    54, &
                   54,    72,     9,     0,     0,    72,   -72,     0,   -27,   -90,   -72,  -216,   216,    72,   576,   216, &
                  -27,    -9,     9,    27,    27,    -9,    90,    27,  -216,   -90,   -72,   -27,    27,    -9,     9,   -27]
  K1(1161,:) = [     0,    90,    72,    54,    27,    -9,     9,    27,     0,     9,  -576,  -189,    27,    72,   -72,  -216, &
                 -216,    -9,   -72,   -27,    27,    72,     9,   216,     0,   -90,    90,    54,     0,    72,     9,     0, &
                    0,    -9,     9,  -189,     0,    -9,   -72,     0,     0,   -90,   -72,   -54,     0,    -9,   576,   189]
  K1(1162,:) = [    90,     0,    54,    72,    -9,    27,    27,     9,     9,     0,  -189,  -576,    72,    27,  -216,   -72, &
                   -9,  -216,   -27,   -72,    72,    27,   216,     9,   -90,     0,    54,    90,    72,     0,     0,     9, &
                   -9,     0,  -189,     9,    -9,     0,     0,   -72,   -90,     0,   -54,   -72,    -9,     0,   189,   576]
  K1(1163,:) = [    72,    54,   216,    72,    72,     0,    27,    72,  -576,  -189, -1728,  -576,    -9,     0,  -216,  -576, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,  -216,     0,    72,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,  -216,     0,   -90,  -576,  -216,     0,    -9]
  K1(1164,:) = [    54,    72,    72,   216,     0,    72,    72,    27,  -189,  -576,  -576, -1728,     0,    -9,  -576,  -216, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,  -216,   -90,    72,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -216,    72,   -90,     0,  -216,  -576,    -9,     0]
  K1(1165,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1(1166,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1(1167,:) = [     9,    27,    27,    72,    72,     0,    54,     9,   -72,  -216,  -216,  -576,    72,     0,     0,   -72, &
                   72,     0,     0,   -72,    72,    54,     0,     9,    -9,   -27,    27,     9,    -9,    27,    27,    90, &
                  -90,   -27,  -216,   -72,    72,   216,   216,   576,    -9,    27,   -27,     9,   -90,  -216,   -27,   -72]
  K1(1168,:) = [    27,     9,    72,    27,     0,    72,     9,    54,  -216,   -72,  -576,  -216,     0,    72,   -72,     0, &
                    0,    72,   -72,     0,    54,    72,     9,     0,   -27,    -9,     9,    27,    27,    -9,    90,    27, &
                  -27,   -90,   -72,  -216,   216,    72,   576,   216,    27,    -9,     9,   -27,  -216,   -90,   -72,   -27]
  K1(1169,:) = [    27,    72,    72,     0,   216,    72,    72,    54,  -216,    -9,  -576,     0,    27,    72,    72,     0, &
                -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,     0,    -9,    -9,    27,     0,    72,   -90,  -216, &
                    0,   -90,    72,  -216,     0,    -9,  -576,  -216,     0,  -576,    -9,  -216,     0,    72,    72,    27]
  K1(1170,:) = [    72,    27,     0,    72,    72,   216,    54,    72,    -9,  -216,     0,  -576,    72,    27,     0,    72, &
                 -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    -9,     0,    27,    -9,    72,     0,  -216,   -90, &
                  -90,     0,  -216,    72,    -9,     0,  -216,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72]
  K1(1171,:) = [     9,   216,    27,    72,    72,     0,     0,     9,   -72,   -27,  -216,    -9,    -9,     0,     0,   -72, &
                 -576,  -189,     0,     9,    -9,     0,   189,   576,    72,   -27,    27,     9,    72,   216,   -27,   -72, &
                   -9,   -27,    27,   -72,    72,    27,  -216,   -72,    -9,  -216,   -27,   -72,    72,    27,   216,     9]
  K1(1172,:) = [   216,     9,    72,    27,     0,    72,     9,     0,   -27,   -72,    -9,  -216,     0,    -9,   -72,     0, &
                 -189,  -576,     9,     0,     0,    -9,   576,   189,   -27,    72,     9,    27,   216,    72,   -72,   -27, &
                  -27,    -9,   -72,    27,    27,    72,   -72,  -216,  -216,    -9,   -72,   -27,    27,    72,     9,   216]
  K1(1173,:) = [  -216,    -9,  -576,     0,    27,    72,    72,     0,    27,    72,    72,     0,   216,    72,    72,    54, &
                 -216,  -576,    -9,     0, -1728,  -576,  -576,  -189,     0,   -90,    72,  -216,     0,    -9,  -576,  -216, &
                    0,    -9,    -9,    27,     0,    72,   -90,  -216,     0,    72,    72,    27,     0,  -576,    -9,  -216]
  K1(1174,:) = [    -9,  -216,     0,  -576,    72,    27,     0,    72,    72,    27,     0,    72,    72,   216,    54,    72, &
                 -576,  -216,     0,    -9,  -576, -1728,  -189,  -576,   -90,     0,  -216,    72,    -9,     0,  -216,  -576, &
                   -9,     0,    27,    -9,    72,     0,  -216,   -90,    72,     0,    27,    72,  -576,     0,  -216,    -9]
  K1(1175,:) = [   -72,   -27,  -216,    -9,    -9,     0,     0,   -72,     9,   216,    27,    72,    72,     0,     0,     9, &
                   -9,     0,   189,   576,  -576,  -189,     0,     9,    -9,   -27,    27,   -72,    72,    27,  -216,   -72, &
                   72,   -27,    27,     9,    72,   216,   -27,   -72,    72,    27,   216,     9,    -9,  -216,   -27,   -72]
  K1(1176,:) = [   -27,   -72,    -9,  -216,     0,    -9,   -72,     0,   216,     9,    72,    27,     0,    72,     9,     0, &
                    0,    -9,   576,   189,  -189,  -576,     9,     0,   -27,    -9,   -72,    27,    27,    72,   -72,  -216, &
                  -27,    72,     9,    27,   216,    72,   -72,   -27,    27,    72,     9,   216,  -216,    -9,   -72,   -27]
  K1(1177,:) = [     0,    -9,    -9,  -216,     0,    -9,   -90,   -27,     0,   -90,   -90,  -216,     0,    72,    -9,   -27, &
                    0,    -9,    72,   -27,     0,   -90,    -9,   -27,   -27,    -9,    -9,   189,   -27,    -9,    -9,   -54, &
                 -270,   -90,   -90,   -54,   216,    72,    72,   189,   -27,    -9,    -9,   189,  -270,   -90,   -90,   -54]
  K1(1178,:) = [    -9,     0,  -216,    -9,    -9,     0,   -27,   -90,   -90,     0,  -216,   -90,    72,     0,   -27,    -9, &
                   -9,     0,   -27,    72,   -90,     0,   -27,    -9,    -9,   -27,   189,    -9,    -9,   -27,   -54,    -9, &
                  -90,  -270,   -54,   -90,    72,   216,   189,    72,    -9,   -27,   189,    -9,   -90,  -270,   -54,   -90]
  K1(1179,:) = [     9,  -189,     0,  -576,    -9,   -27,  -216,   -72,    90,    54,     0,    72,    72,   216,    27,     9, &
                   -9,    27,    27,     9,    72,  -216,    27,   -72,    -9,   189,     0,   576,    -9,     0,     0,   -72, &
                  -90,   -54,     0,   -72,    72,     0,     0,     9,    -9,  -189,     0,     9,   -90,    54,     0,    90]
  K1(1180,:) = [  -189,     9,  -576,     0,   -27,    -9,   -72,  -216,    54,    90,    72,     0,   216,    72,     9,    27, &
                   27,    -9,     9,    27,  -216,    72,   -72,    27,   189,    -9,   576,     0,     0,    -9,   -72,     0, &
                  -54,   -90,   -72,     0,     0,    72,     9,     0,  -189,    -9,     9,     0,    54,   -90,    90,     0]
  K1(1181,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1(1182,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1(1183,:) = [   -72,     0,     0,    72,    72,   216,   216,   576,     9,     0,     0,    -9,    72,   216,    27,    90, &
                  -90,  -216,   -27,   -72,  -576,  -216,  -216,   -72,    -9,   -54,     0,   -72,    72,     0,     0,   -72, &
                   72,   189,     0,     9,    72,     0,     0,   -72,    72,    54,     0,     9,    -9,  -189,     0,   -72]
  K1(1184,:) = [     0,   -72,    72,     0,   216,    72,   576,   216,     0,     9,    -9,     0,   216,    72,    90,    27, &
                 -216,   -90,   -72,   -27,  -216,  -576,   -72,  -216,   -54,    -9,   -72,     0,     0,    72,   -72,     0, &
                  189,    72,     9,     0,     0,    72,   -72,     0,    54,    72,     9,     0,  -189,    -9,   -72,     0]
  K1(1185,:) = [     0,   -90,   -90,  -216,     0,    72,    -9,   -27,     0,    -9,    -9,  -216,     0,    -9,   -90,   -27, &
                    0,   -90,    -9,   -27,     0,    -9,    72,   -27,  -270,   -90,   -90,   -54,   216,    72,    72,   189, &
                  -27,    -9,    -9,   189,   -27,    -9,    -9,   -54,  -270,   -90,   -90,   -54,   -27,    -9,    -9,   189]
  K1(1186,:) = [   -90,     0,  -216,   -90,    72,     0,   -27,    -9,    -9,     0,  -216,    -9,    -9,     0,   -27,   -90, &
                  -90,     0,   -27,    -9,    -9,     0,   -27,    72,   -90,  -270,   -54,   -90,    72,   216,   189,    72, &
                   -9,   -27,   189,    -9,    -9,   -27,   -54,    -9,   -90,  -270,   -54,   -90,    -9,   -27,   189,    -9]
  K1(1187,:) = [    90,    54,     0,    72,    72,   216,    27,     9,     9,  -189,     0,  -576,    -9,   -27,  -216,   -72, &
                   72,  -216,    27,   -72,    -9,    27,    27,     9,   -90,   -54,     0,   -72,    72,     0,     0,     9, &
                   -9,   189,     0,   576,    -9,     0,     0,   -72,   -90,    54,     0,    90,    -9,  -189,     0,     9]
  K1(1188,:) = [    54,    90,    72,     0,   216,    72,     9,    27,  -189,     9,  -576,     0,   -27,    -9,   -72,  -216, &
                 -216,    72,   -72,    27,    27,    -9,     9,    27,   -54,   -90,   -72,     0,     0,    72,     9,     0, &
                  189,    -9,   576,     0,     0,    -9,   -72,     0,    54,   -90,    90,     0,  -189,    -9,     9,     0]
  K1(1189,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1(1190,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1(1191,:) = [     9,     0,     0,    -9,    72,   216,    27,    90,   -72,     0,     0,    72,    72,   216,   216,   576, &
                 -576,  -216,  -216,   -72,   -90,  -216,   -27,   -72,    72,   189,     0,     9,    72,     0,     0,   -72, &
                   -9,   -54,     0,   -72,    72,     0,     0,   -72,    -9,  -189,     0,   -72,    72,    54,     0,     9]
  K1(1192,:) = [     0,     9,    -9,     0,   216,    72,    90,    27,     0,   -72,    72,     0,   216,    72,   576,   216, &
                 -216,  -576,   -72,  -216,  -216,   -90,   -72,   -27,   189,    72,     9,     0,     0,    72,   -72,     0, &
                  -54,    -9,   -72,     0,     0,    72,   -72,     0,  -189,    -9,   -72,     0,    54,    72,     9,     0]
  K1(1193,:) = [     0,    -9,  -576,  -216,     0,    72,   -90,  -216,     0,   -90,    72,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,   -27,    -9,    -9,  -189,   216,    72,    72,    54, &
                 -270,   -90,   -90,    54,   -27,    -9,    -9,  -189, -1728,  -576,  -576,  -189,   216,    72,    72,    54]
  K1(1194,:) = [    -9,     0,  -216,  -576,    72,     0,  -216,   -90,   -90,     0,  -216,    72,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,    -9,   -27,  -189,    -9,    72,   216,    54,    72, &
                  -90,  -270,    54,   -90,    -9,   -27,  -189,    -9,  -576, -1728,  -189,  -576,    72,   216,    54,    72]
  K1(1195,:) = [   576,   189,     0,    -9,    72,   216,   -27,   -72,   -72,   -54,     0,   -90,    -9,   -27,   -27,     9, &
                   -9,  -216,   -27,   -72,    72,    27,   216,     9,    -9,   189,     0,     9,    72,     0,     0,     9, &
                  -90,   -54,     0,    90,    -9,     0,     0,   -72,  -576,  -189,     0,     9,    72,    54,     0,    90]
  K1(1196,:) = [   189,   576,    -9,     0,   216,    72,   -72,   -27,   -54,   -72,   -90,     0,   -27,    -9,     9,   -27, &
                 -216,    -9,   -72,   -27,    27,    72,     9,   216,   189,    -9,     9,     0,     0,    72,     9,     0, &
                  -54,   -90,    90,     0,     0,    -9,   -72,     0,  -189,  -576,     9,     0,    54,    72,    90,     0]
  K1(1197,:) = [     0,   -90,    72,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,    72,   -90,  -216, &
                    0,    72,    72,    27,     0,  -576,    -9,  -216,  -270,   -90,   -90,    54,   -27,    -9,    -9,  -189, &
                  -27,    -9,    -9,  -189,   216,    72,    72,    54,   216,    72,    72,    54, -1728,  -576,  -576,  -189]
  K1(1198,:) = [   -90,     0,  -216,    72,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,    72,     0,  -216,   -90, &
                   72,     0,    27,    72,  -576,     0,  -216,    -9,   -90,  -270,    54,   -90,    -9,   -27,  -189,    -9, &
                   -9,   -27,  -189,    -9,    72,   216,    54,    72,    72,   216,    54,    72,  -576, -1728,  -189,  -576]
  K1(1199,:) = [   -72,   -54,     0,   -90,    -9,   -27,   -27,     9,   576,   189,     0,    -9,    72,   216,   -27,   -72, &
                   72,    27,   216,     9,    -9,  -216,   -27,   -72,   -90,   -54,     0,    90,    -9,     0,     0,   -72, &
                   -9,   189,     0,     9,    72,     0,     0,     9,    72,    54,     0,    90,  -576,  -189,     0,     9]
  K1(1200,:) = [   -54,   -72,   -90,     0,   -27,    -9,     9,   -27,   189,   576,    -9,     0,   216,    72,   -72,   -27, &
                   27,    72,     9,   216,  -216,    -9,   -72,   -27,   -54,   -90,    90,     0,     0,    -9,   -72,     0, &
                  189,    -9,     9,     0,     0,    72,     9,     0,    54,    72,    90,     0,  -189,  -576,     9,     0]
  K1(1201,:) = [ -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0,   216,    72,    72,    54,    27,    72,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                    0,    72,   -90,  -216,     0,    -9,    -9,    27,     0,    -9,  -576,  -216,     0,   -90,    72,  -216]
  K1(1202,:) = [  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9,    72,   216,    54,    72,    72,    27,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                   72,     0,  -216,   -90,    -9,     0,    27,    -9,    -9,     0,  -216,  -576,   -90,     0,  -216,    72]
  K1(1203,:) = [  -576,  -189,     0,     9,   -72,  -216,    27,    72,    72,    54,     0,    90,     9,    27,    27,    -9, &
                    9,   216,    27,    72,   -72,   -27,  -216,    -9,     9,  -189,     0,    -9,   -72,     0,     0,    -9, &
                   90,    54,     0,   -90,     9,     0,     0,    72,   576,   189,     0,    -9,   -72,   -54,     0,   -90]
  K1(1204,:) = [  -189,  -576,     9,     0,  -216,   -72,    72,    27,    54,    72,    90,     0,    27,     9,    -9,    27, &
                  216,     9,    72,    27,   -27,   -72,    -9,  -216,  -189,     9,    -9,     0,     0,   -72,    -9,     0, &
                   54,    90,   -90,     0,     0,     9,    72,     0,   189,   576,    -9,     0,   -54,   -72,   -90,     0]
  K1(1205,:) = [  -216,  -576,   -72,  -216,     0,   -72,    72,     0,    27,    72,     9,    27,    54,     9,    72,     0, &
                    0,     9,    72,    54,     0,   -72,    72,     0,  -216,   -72,   -90,   -27,   216,   576,    72,   216, &
                   27,     9,    -9,   -27,    27,    90,    -9,    27,   -27,   -72,   -90,  -216,   -27,     9,    -9,    27]
  K1(1206,:) = [  -576,  -216,  -216,   -72,   -72,     0,     0,    72,    72,    27,    27,     9,     9,    54,     0,    72, &
                    9,     0,    54,    72,   -72,     0,     0,    72,   -72,  -216,   -27,   -90,   576,   216,   216,    72, &
                    9,    27,   -27,    -9,    90,    27,    27,    -9,   -72,   -27,  -216,   -90,     9,   -27,    27,    -9]
  K1(1207,:) = [    -9,     0,    27,    72,    72,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9, &
                   72,     0,   216,    72,    -9,     0,    27,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72, &
                   72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    -9,   -27,     0,    -9]
  K1(1208,:) = [     0,    -9,    72,    27,     0,    72,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27, &
                    0,    72,    72,   216,     0,    -9,    72,    27,   -27,    -9,    -9,     0,   216,    72,    72,     0, &
                  216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0]
  K1(1209,:) = [   216,    72,    72,    54,    27,    72,    72,     0, -1728,  -576,  -576,  -189,  -216,  -576,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,     0,    72,   -90,  -216,     0,    -9,    -9,    27, &
                    0,  -576,    -9,  -216,     0,    72,    72,    27,     0,   -90,    72,  -216,     0,    -9,  -576,  -216]
  K1(1210,:) = [    72,   216,    54,    72,    72,    27,     0,    72,  -576, -1728,  -189,  -576,  -576,  -216,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    72,     0,  -216,   -90,    -9,     0,    27,    -9, &
                 -576,     0,  -216,    -9,    72,     0,    27,    72,   -90,     0,  -216,    72,    -9,     0,  -216,  -576]
  K1(1211,:) = [    72,    54,     0,    90,     9,    27,    27,    -9,  -576,  -189,     0,     9,   -72,  -216,    27,    72, &
                  -72,   -27,  -216,    -9,     9,   216,    27,    72,    90,    54,     0,   -90,     9,     0,     0,    72, &
                    9,  -189,     0,    -9,   -72,     0,     0,    -9,   -72,   -54,     0,   -90,   576,   189,     0,    -9]
  K1(1212,:) = [    54,    72,    90,     0,    27,     9,    -9,    27,  -189,  -576,     9,     0,  -216,   -72,    72,    27, &
                  -27,   -72,    -9,  -216,   216,     9,    72,    27,    54,    90,   -90,     0,     0,     9,    72,     0, &
                 -189,     9,    -9,     0,     0,   -72,    -9,     0,   -54,   -72,   -90,     0,   189,   576,    -9,     0]
  K1(1213,:) = [    27,    72,     9,    27,    54,     9,    72,     0,  -216,  -576,   -72,  -216,     0,   -72,    72,     0, &
                    0,   -72,    72,     0,     0,     9,    72,    54,    27,     9,    -9,   -27,    27,    90,    -9,    27, &
                 -216,   -72,   -90,   -27,   216,   576,    72,   216,   -27,     9,    -9,    27,   -27,   -72,   -90,  -216]
  K1(1214,:) = [    72,    27,    27,     9,     9,    54,     0,    72,  -576,  -216,  -216,   -72,   -72,     0,     0,    72, &
                  -72,     0,     0,    72,     9,     0,    54,    72,     9,    27,   -27,    -9,    90,    27,    27,    -9, &
                  -72,  -216,   -27,   -90,   576,   216,   216,    72,     9,   -27,    27,    -9,   -72,   -27,  -216,   -90]
  K1(1215,:) = [    72,     0,    27,    -9,    72,     0,    27,    -9,    -9,     0,    27,    72,    72,     0,   216,    72, &
                   -9,     0,    27,    72,    72,     0,   216,    72,    72,   216,     0,    72,    72,   216,     0,    72, &
                   -9,   -27,     0,    -9,    72,   216,     0,    72,    -9,   -27,     0,    -9,    72,   216,     0,    72]
  K1(1216,:) = [     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    -9,    72,    27,     0,    72,    72,   216, &
                    0,    -9,    72,    27,     0,    72,    72,   216,   216,    72,    72,     0,   216,    72,    72,     0, &
                  -27,    -9,    -9,     0,   216,    72,    72,     0,   -27,    -9,    -9,     0,   216,    72,    72,     0]
  K1(1217,:) = [    27,    72,     9,   216,     0,     9,    72,     0,  -216,    -9,   -72,   -27,     0,   -72,    -9,     0, &
                    0,     9,  -576,  -189,   189,   576,    -9,     0,    27,     9,    72,   -27,   -27,   -72,    72,   216, &
                   27,   -72,    -9,   -27,  -216,   -72,    72,    27,   -27,   -72,    -9,  -216,   216,     9,    72,    27]
  K1(1218,:) = [    72,    27,   216,     9,     9,     0,     0,    72,    -9,  -216,   -27,   -72,   -72,     0,     0,    -9, &
                    9,     0,  -189,  -576,   576,   189,     0,    -9,     9,    27,   -27,    72,   -72,   -27,   216,    72, &
                  -72,    27,   -27,    -9,   -72,  -216,    27,    72,   -72,   -27,  -216,    -9,     9,   216,    27,    72]
  K1(1219,:) = [    72,     0,    27,    72,    72,    54,   216,    72,  -576,     0,  -216,    -9,    72,     0,    27,    72, &
                 -576,  -189, -1728,  -576,    -9,     0,  -216,  -576,    -9,    27,     0,    -9,   -90,  -216,     0,    72, &
                   72,  -216,     0,   -90,  -576,  -216,     0,    -9,    -9,  -216,     0,  -576,    72,    27,     0,    72]
  K1(1220,:) = [     0,    72,    72,    27,    54,    72,    72,   216,     0,  -576,    -9,  -216,     0,    72,    72,    27, &
                 -189,  -576,  -576, -1728,     0,    -9,  -576,  -216,    27,    -9,    -9,     0,  -216,   -90,    72,     0, &
                 -216,    72,   -90,     0,  -216,  -576,    -9,     0,  -216,    -9,  -576,     0,    27,    72,    72,     0]
  K1(1221,:) = [  -216,    -9,   -72,   -27,     0,   -72,    -9,     0,    27,    72,     9,   216,     0,     9,    72,     0, &
                  189,   576,    -9,     0,     0,     9,  -576,  -189,    27,   -72,    -9,   -27,  -216,   -72,    72,    27, &
                   27,     9,    72,   -27,   -27,   -72,    72,   216,   216,     9,    72,    27,   -27,   -72,    -9,  -216]
  K1(1222,:) = [    -9,  -216,   -27,   -72,   -72,     0,     0,    -9,    72,    27,   216,     9,     9,     0,     0,    72, &
                  576,   189,     0,    -9,     9,     0,  -189,  -576,   -72,    27,   -27,    -9,   -72,  -216,    27,    72, &
                    9,    27,   -27,    72,   -72,   -27,   216,    72,     9,   216,    27,    72,   -72,   -27,  -216,    -9]
  K1(1223,:) = [  -576,     0,  -216,    -9,    72,     0,    27,    72,    72,     0,    27,    72,    72,    54,   216,    72, &
                   -9,     0,  -216,  -576,  -576,  -189, -1728,  -576,    72,  -216,     0,   -90,  -576,  -216,     0,    -9, &
                   -9,    27,     0,    -9,   -90,  -216,     0,    72,    72,    27,     0,    72,    -9,  -216,     0,  -576]
  K1(1224,:) = [     0,  -576,    -9,  -216,     0,    72,    72,    27,     0,    72,    72,    27,    54,    72,    72,   216, &
                    0,    -9,  -576,  -216,  -189,  -576,  -576, -1728,  -216,    72,   -90,     0,  -216,  -576,    -9,     0, &
                   27,    -9,    -9,     0,  -216,   -90,    72,     0,    27,    72,    72,     0,  -216,    -9,  -576,     0]
  K1(1225,:) = [     0,  -576,     9,  -189,  -216,   -72,    -9,   -27,     0,    72,    90,    54,    27,     9,    72,   216, &
                   27,     9,    -9,    27,    27,   -72,    72,  -216,     0,   576,    -9,   189,     0,   -72,    -9,     0, &
                    0,   -72,   -90,   -54,     0,     9,    72,     0,     0,     9,    -9,  -189,     0,    90,   -90,    54]
  K1(1226,:) = [  -576,     0,  -189,     9,   -72,  -216,   -27,    -9,    72,     0,    54,    90,     9,    27,   216,    72, &
                    9,    27,    27,    -9,   -72,    27,  -216,    72,   576,     0,   189,    -9,   -72,     0,     0,    -9, &
                  -72,     0,   -54,   -90,     9,     0,     0,    72,     9,     0,  -189,    -9,    90,     0,    54,   -90]
  K1(1227,:) = [    -9,  -216,     0,    -9,   -90,   -27,     0,    -9,   -90,  -216,     0,   -90,    -9,   -27,     0,    72, &
                   72,   -27,     0,    -9,    -9,   -27,     0,   -90,    -9,   189,   -27,    -9,    -9,   -54,   -27,    -9, &
                  -90,   -54,  -270,   -90,    72,   189,   216,    72,    -9,   189,   -27,    -9,   -90,   -54,  -270,   -90]
  K1(1228,:) = [  -216,    -9,    -9,     0,   -27,   -90,    -9,     0,  -216,   -90,   -90,     0,   -27,    -9,    72,     0, &
                  -27,    72,    -9,     0,   -27,    -9,   -90,     0,   189,    -9,    -9,   -27,   -54,    -9,    -9,   -27, &
                  -54,   -90,   -90,  -270,   189,    72,    72,   216,   189,    -9,    -9,   -27,   -54,   -90,   -90,  -270]
  K1(1229,:) = [     0,    72,   -72,     0,   216,   576,    72,   216,     0,    -9,     9,     0,    27,    90,    72,   216, &
                  -27,   -72,   -90,  -216,  -216,   -72,  -576,  -216,     0,   -72,    -9,   -54,     0,   -72,    72,     0, &
                    0,     9,    72,   189,     0,   -72,    72,     0,     0,     9,    72,    54,     0,   -72,    -9,  -189]
  K1(1230,:) = [    72,     0,     0,   -72,   576,   216,   216,    72,    -9,     0,     0,     9,    90,    27,   216,    72, &
                  -72,   -27,  -216,   -90,   -72,  -216,  -216,  -576,   -72,     0,   -54,    -9,   -72,     0,     0,    72, &
                    9,     0,   189,    72,   -72,     0,     0,    72,     9,     0,    54,    72,   -72,     0,  -189,    -9]
  K1(1231,:) = [    72,    27,     0,    -9,    72,   216,     0,    72,    -9,    27,     0,    72,    -9,    27,     0,    72, &
                   72,   216,     0,    72,    72,    27,     0,    -9,    -9,     0,   -27,    -9,    72,     0,   216,    72, &
                   72,     0,   216,    72,    72,     0,   216,    72,    72,     0,   216,    72,    -9,     0,   -27,    -9]
  K1(1232,:) = [    27,    72,    -9,     0,   216,    72,    72,     0,    27,    -9,    72,     0,    27,    -9,    72,     0, &
                  216,    72,    72,     0,    27,    72,    -9,     0,     0,    -9,    -9,   -27,     0,    72,    72,   216, &
                    0,    72,    72,   216,     0,    72,    72,   216,     0,    72,    72,   216,     0,    -9,    -9,   -27]
  K1(1233,:) = [     0,    72,    90,    54,    27,     9,    72,   216,     0,  -576,     9,  -189,  -216,   -72,    -9,   -27, &
                   27,   -72,    72,  -216,    27,     9,    -9,    27,     0,   -72,   -90,   -54,     0,     9,    72,     0, &
                    0,   576,    -9,   189,     0,   -72,    -9,     0,     0,    90,   -90,    54,     0,     9,    -9,  -189]
  K1(1234,:) = [    72,     0,    54,    90,     9,    27,   216,    72,  -576,     0,  -189,     9,   -72,  -216,   -27,    -9, &
                  -72,    27,  -216,    72,     9,    27,    27,    -9,   -72,     0,   -54,   -90,     9,     0,     0,    72, &
                  576,     0,   189,    -9,   -72,     0,     0,    -9,    90,     0,    54,   -90,     9,     0,  -189,    -9]
  K1(1235,:) = [   -90,  -216,     0,   -90,    -9,   -27,     0,    72,    -9,  -216,     0,    -9,   -90,   -27,     0,    -9, &
                   -9,   -27,     0,   -90,    72,   -27,     0,    -9,   -90,   -54,  -270,   -90,    72,   189,   216,    72, &
                   -9,   189,   -27,    -9,    -9,   -54,   -27,    -9,   -90,   -54,  -270,   -90,    -9,   189,   -27,    -9]
  K1(1236,:) = [  -216,   -90,   -90,     0,   -27,    -9,    72,     0,  -216,    -9,    -9,     0,   -27,   -90,    -9,     0, &
                  -27,    -9,   -90,     0,   -27,    72,    -9,     0,   -54,   -90,   -90,  -270,   189,    72,    72,   216, &
                  189,    -9,    -9,   -27,   -54,    -9,    -9,   -27,   -54,   -90,   -90,  -270,   189,    -9,    -9,   -27]
  K1(1237,:) = [     0,    -9,     9,     0,    27,    90,    72,   216,     0,    72,   -72,     0,   216,   576,    72,   216, &
                 -216,   -72,  -576,  -216,   -27,   -72,   -90,  -216,     0,     9,    72,   189,     0,   -72,    72,     0, &
                    0,   -72,    -9,   -54,     0,   -72,    72,     0,     0,   -72,    -9,  -189,     0,     9,    72,    54]
  K1(1238,:) = [    -9,     0,     0,     9,    90,    27,   216,    72,    72,     0,     0,   -72,   576,   216,   216,    72, &
                  -72,  -216,  -216,  -576,   -72,   -27,  -216,   -90,     9,     0,   189,    72,   -72,     0,     0,    72, &
                  -72,     0,   -54,    -9,   -72,     0,     0,    72,   -72,     0,  -189,    -9,     9,     0,    54,    72]
  K1(1239,:) = [    -9,    27,     0,    72,    -9,    27,     0,    72,    72,    27,     0,    -9,    72,   216,     0,    72, &
                   72,    27,     0,    -9,    72,   216,     0,    72,    72,     0,   216,    72,    72,     0,   216,    72, &
                   -9,     0,   -27,    -9,    72,     0,   216,    72,    -9,     0,   -27,    -9,    72,     0,   216,    72]
  K1(1240,:) = [    27,    -9,    72,     0,    27,    -9,    72,     0,    27,    72,    -9,     0,   216,    72,    72,     0, &
                   27,    72,    -9,     0,   216,    72,    72,     0,     0,    72,    72,   216,     0,    72,    72,   216, &
                    0,    -9,    -9,   -27,     0,    72,    72,   216,     0,    -9,    -9,   -27,     0,    72,    72,   216]
  K1(1241,:) = [     0,    -9,   576,   189,   -27,   -72,    72,   216,     0,   -90,   -72,   -54,   -27,     9,    -9,   -27, &
                  -27,   -72,    -9,  -216,   216,     9,    72,    27,     0,     9,    -9,   189,     0,     9,    72,     0, &
                    0,    90,   -90,   -54,     0,   -72,    -9,     0,     0,     9,  -576,  -189,     0,    90,    72,    54]
  K1(1242,:) = [    -9,     0,   189,   576,   -72,   -27,   216,    72,   -90,     0,   -54,   -72,     9,   -27,   -27,    -9, &
                  -72,   -27,  -216,    -9,     9,   216,    27,    72,     9,     0,   189,    -9,     9,     0,     0,    72, &
                   90,     0,   -54,   -90,   -72,     0,     0,    -9,     9,     0,  -189,  -576,    90,     0,    54,    72]
  K1(1243,:) = [  -576,  -216,     0,    -9,   -90,  -216,     0,    72,    72,  -216,     0,   -90,    -9,    27,     0,    -9, &
                   -9,  -216,     0,  -576,    72,    27,     0,    72,    -9,  -189,   -27,    -9,    72,    54,   216,    72, &
                  -90,    54,  -270,   -90,    -9,  -189,   -27,    -9,  -576,  -189, -1728,  -576,    72,    54,   216,    72]
  K1(1244,:) = [  -216,  -576,    -9,     0,  -216,   -90,    72,     0,  -216,    72,   -90,     0,    27,    -9,    -9,     0, &
                 -216,    -9,  -576,     0,    27,    72,    72,     0,  -189,    -9,    -9,   -27,    54,    72,    72,   216, &
                   54,   -90,   -90,  -270,  -189,    -9,    -9,   -27,  -189,  -576,  -576, -1728,    54,    72,    72,   216]
  K1(1245,:) = [     0,   -90,   -72,   -54,   -27,     9,    -9,   -27,     0,    -9,   576,   189,   -27,   -72,    72,   216, &
                  216,     9,    72,    27,   -27,   -72,    -9,  -216,     0,    90,   -90,   -54,     0,   -72,    -9,     0, &
                    0,     9,    -9,   189,     0,     9,    72,     0,     0,    90,    72,    54,     0,     9,  -576,  -189]
  K1(1246,:) = [   -90,     0,   -54,   -72,     9,   -27,   -27,    -9,    -9,     0,   189,   576,   -72,   -27,   216,    72, &
                    9,   216,    27,    72,   -72,   -27,  -216,    -9,    90,     0,   -54,   -90,   -72,     0,     0,    -9, &
                    9,     0,   189,    -9,     9,     0,     0,    72,    90,     0,    54,    72,     9,     0,  -189,  -576]
  K1(1247,:) = [    72,  -216,     0,   -90,    -9,    27,     0,    -9,  -576,  -216,     0,    -9,   -90,  -216,     0,    72, &
                   72,    27,     0,    72,    -9,  -216,     0,  -576,   -90,    54,  -270,   -90,    -9,  -189,   -27,    -9, &
                   -9,  -189,   -27,    -9,    72,    54,   216,    72,    72,    54,   216,    72,  -576,  -189, -1728,  -576]
  K1(1248,:) = [  -216,    72,   -90,     0,    27,    -9,    -9,     0,  -216,  -576,    -9,     0,  -216,   -90,    72,     0, &
                   27,    72,    72,     0,  -216,    -9,  -576,     0,    54,   -90,   -90,  -270,  -189,    -9,    -9,   -27, &
                 -189,    -9,    -9,   -27,    54,    72,    72,   216,    54,    72,    72,   216,  -189,  -576,  -576, -1728]
  K1(1249,:) = [     0,   -81,   648,   189,  -243,  -648,     0,     0,     0,   -81,   -81,   -54,   -54,   -81,   -81,  -243, &
                    0,     0,    81,     0,   432,    81,   648,   243,     0,    81,     0,   243,     0,    81,     0,     0, &
                    0,    81,  -162,  -243,     0,     0,   -81,     0,     0,     0,  -648,  -243,     0,   162,    81,   243]
  K1(1250,:) = [   -81,     0,   189,   648,  -648,  -243,     0,     0,   -81,     0,   -54,   -81,   -81,   -54,  -243,   -81, &
                    0,     0,     0,    81,    81,   432,   243,   648,    81,     0,   243,     0,    81,     0,     0,     0, &
                   81,     0,  -243,  -162,     0,     0,     0,   -81,     0,     0,  -243,  -648,   162,     0,   243,    81]
  K1(1251,:) = [   648,   189,     0,   -81,     0,     0,  -243,  -648,   -81,   -54,     0,   -81,   -81,  -243,   -54,   -81, &
                   81,     0,     0,     0,   648,   243,   432,    81,     0,   243,     0,    81,     0,     0,     0,    81, &
                 -162,  -243,     0,    81,   -81,     0,     0,     0,  -648,  -243,     0,     0,    81,   243,     0,   162]
  K1(1252,:) = [   189,   648,   -81,     0,     0,     0,  -648,  -243,   -54,   -81,   -81,     0,  -243,   -81,   -81,   -54, &
                    0,    81,     0,     0,   243,   648,    81,   432,   243,     0,    81,     0,     0,     0,    81,     0, &
                 -243,  -162,    81,     0,     0,   -81,     0,     0,  -243,  -648,     0,     0,   243,    81,   162,     0]
  K1(1253,:) = [  -243,  -648,     0,     0, -1944,  -648,  -648,  -189,     0,    81,     0,     0,  -243,     0,  -648,     0, &
                    0,     0,     0,    54,     0,     0,    81,     0,     0,    81,    81,    54,     0,  -648,   -81,  -432, &
                    0,   -81,  -648,  -432,     0,  -162,     0,  -432,     0,     0,  -162,  -432,     0,     0,     0,    54]
  K1(1254,:) = [  -648,  -243,     0,     0,  -648, -1944,  -189,  -648,    81,     0,     0,     0,     0,  -243,     0,  -648, &
                    0,     0,    54,     0,     0,     0,     0,    81,    81,     0,    54,    81,  -648,     0,  -432,   -81, &
                  -81,     0,  -432,  -648,  -162,     0,  -432,     0,     0,     0,  -432,  -162,     0,     0,    54,     0]
  K1(1255,:) = [     0,     0,  -243,  -648,  -648,  -189, -1944,  -648,     0,     0,     0,    81,  -648,     0,  -243,     0, &
                    0,    54,     0,     0,    81,     0,     0,     0,    81,    54,     0,    81,   -81,  -432,     0,  -648, &
                 -648,  -432,     0,   -81,     0,  -432,     0,  -162,  -162,  -432,     0,     0,     0,    54,     0,     0]
  K1(1256,:) = [     0,     0,  -648,  -243,  -189,  -648,  -648, -1944,     0,     0,    81,     0,     0,  -648,     0,  -243, &
                   54,     0,     0,     0,     0,    81,     0,     0,    54,    81,    81,     0,  -432,   -81,  -648,     0, &
                 -432,  -648,   -81,     0,  -432,     0,  -162,     0,  -432,  -162,     0,     0,    54,     0,     0,     0]
  K1(1257,:) = [     0,   -81,   -81,   -54,     0,    81,     0,     0,     0,   648,   -81,   189,   432,   648,    81,   243, &
                 -243,     0,  -648,     0,   -54,   -81,   -81,  -243,     0,    81,   162,   243,     0,   -81,     0,     0, &
                    0,  -648,     0,  -243,     0,     0,    81,     0,     0,  -162,    81,  -243,     0,     0,    81,   243]
  K1(1258,:) = [   -81,     0,   -54,   -81,    81,     0,     0,     0,   648,     0,   189,   -81,   648,   432,   243,    81, &
                    0,  -243,     0,  -648,   -81,   -54,  -243,   -81,    81,     0,   243,   162,   -81,     0,     0,     0, &
                 -648,     0,  -243,     0,     0,     0,     0,    81,  -162,     0,  -243,    81,     0,     0,   243,    81]
  K1(1259,:) = [   -81,   -54,     0,   -81,     0,     0,     0,    81,   -81,   189,     0,   648,    81,   243,   432,   648, &
                 -648,     0,  -243,     0,   -81,  -243,   -54,   -81,   162,   243,     0,    81,     0,     0,     0,   -81, &
                    0,  -243,     0,  -648,    81,     0,     0,     0,    81,  -243,     0,  -162,    81,   243,     0,     0]
  K1(1260,:) = [   -54,   -81,   -81,     0,     0,     0,    81,     0,   189,   -81,   648,     0,   243,    81,   648,   432, &
                    0,  -648,     0,  -243,  -243,   -81,   -81,   -54,   243,   162,    81,     0,     0,     0,   -81,     0, &
                 -243,     0,  -648,     0,     0,    81,     0,     0,  -243,    81,  -162,     0,   243,    81,     0,     0]
  K1(1261,:) = [   -54,   -81,   -81,  -243,  -243,     0,  -648,     0,   432,   648,    81,   243,     0,   648,   -81,   189, &
                    0,    81,     0,     0,     0,   -81,   -81,   -54,     0,     0,    81,   243,     0,  -162,    81,  -243, &
                    0,     0,    81,     0,     0,  -648,     0,  -243,     0,   -81,     0,     0,     0,    81,   162,   243]
  K1(1262,:) = [   -81,   -54,  -243,   -81,     0,  -243,     0,  -648,   648,   432,   243,    81,   648,     0,   189,   -81, &
                   81,     0,     0,     0,   -81,     0,   -54,   -81,     0,     0,   243,    81,  -162,     0,  -243,    81, &
                    0,     0,     0,    81,  -648,     0,  -243,     0,   -81,     0,     0,     0,    81,     0,   243,   162]
  K1(1263,:) = [   -81,  -243,   -54,   -81,  -648,     0,  -243,     0,    81,   243,   432,   648,   -81,   189,     0,   648, &
                    0,     0,     0,    81,   -81,   -54,     0,   -81,    81,   243,     0,     0,    81,  -243,     0,  -162, &
                   81,     0,     0,     0,     0,  -243,     0,  -648,     0,     0,     0,   -81,   162,   243,     0,    81]
  K1(1264,:) = [  -243,   -81,   -81,   -54,     0,  -648,     0,  -243,   243,    81,   648,   432,   189,   -81,   648,     0, &
                    0,     0,    81,     0,   -54,   -81,   -81,     0,   243,    81,     0,     0,  -243,    81,  -162,     0, &
                    0,    81,     0,     0,  -243,     0,  -648,     0,     0,     0,   -81,     0,   243,   162,    81,     0]
  K1(1265,:) = [     0,     0,    81,     0,     0,     0,     0,    54,  -243,     0,  -648,     0,     0,    81,     0,     0, &
                -1944,  -648,  -648,  -189,  -243,  -648,     0,     0,     0,     0,     0,    54,     0,     0,  -162,  -432, &
                    0,  -162,     0,  -432,     0,   -81,  -648,  -432,     0,  -648,   -81,  -432,     0,    81,    81,    54]
  K1(1266,:) = [     0,     0,     0,    81,     0,     0,    54,     0,     0,  -243,     0,  -648,    81,     0,     0,     0, &
                 -648, -1944,  -189,  -648,  -648,  -243,     0,     0,     0,     0,    54,     0,     0,     0,  -432,  -162, &
                 -162,     0,  -432,     0,   -81,     0,  -432,  -648,  -648,     0,  -432,   -81,    81,     0,    54,    81]
  K1(1267,:) = [    81,     0,     0,     0,     0,    54,     0,     0,  -648,     0,  -243,     0,     0,     0,     0,    81, &
                 -648,  -189, -1944,  -648,     0,     0,  -243,  -648,     0,    54,     0,     0,  -162,  -432,     0,     0, &
                    0,  -432,     0,  -162,  -648,  -432,     0,   -81,   -81,  -432,     0,  -648,    81,    54,     0,    81]
  K1(1268,:) = [     0,    81,     0,     0,    54,     0,     0,     0,     0,  -648,     0,  -243,     0,     0,    81,     0, &
                 -189,  -648,  -648, -1944,     0,     0,  -648,  -243,    54,     0,     0,     0,  -432,  -162,     0,     0, &
                 -432,     0,  -162,     0,  -432,  -648,   -81,     0,  -432,   -81,  -648,     0,    54,    81,    81,     0]
  K1(1269,:) = [   432,    81,   648,   243,     0,     0,    81,     0,   -54,   -81,   -81,  -243,     0,   -81,   -81,   -54, &
                 -243,  -648,     0,     0,     0,   -81,   648,   189,     0,   162,    81,   243,     0,     0,  -648,  -243, &
                    0,     0,   -81,     0,     0,    81,  -162,  -243,     0,    81,     0,     0,     0,    81,     0,   243]
  K1(1270,:) = [    81,   432,   243,   648,     0,     0,     0,    81,   -81,   -54,  -243,   -81,   -81,     0,   -54,   -81, &
                 -648,  -243,     0,     0,   -81,     0,   189,   648,   162,     0,   243,    81,     0,     0,  -243,  -648, &
                    0,     0,     0,   -81,    81,     0,  -243,  -162,    81,     0,     0,     0,    81,     0,   243,     0]
  K1(1271,:) = [   648,   243,   432,    81,    81,     0,     0,     0,   -81,  -243,   -54,   -81,   -81,   -54,     0,   -81, &
                    0,     0,  -243,  -648,   648,   189,     0,   -81,    81,   243,     0,   162,  -648,  -243,     0,     0, &
                  -81,     0,     0,     0,  -162,  -243,     0,    81,     0,     0,     0,    81,     0,   243,     0,    81]
  K1(1272,:) = [   243,   648,    81,   432,     0,    81,     0,     0,  -243,   -81,   -81,   -54,   -54,   -81,   -81,     0, &
                    0,     0,  -648,  -243,   189,   648,   -81,     0,   243,    81,   162,     0,  -243,  -648,     0,     0, &
                    0,   -81,     0,     0,  -243,  -162,    81,     0,     0,     0,    81,     0,   243,     0,    81,     0]
  K1(1273,:) = [     0,    81,     0,   243,     0,    81,    81,    54,     0,    81,   162,   243,     0,     0,    81,   243, &
                    0,     0,     0,    54,     0,   162,    81,   243,   243,    81,    81,  -189,   243,    81,    81,    54, &
                  243,    81,    81,    54,     0,     0,     0,  -189,     0,     0,     0,  -189,   486,   162,   162,    54]
  K1(1274,:) = [    81,     0,   243,     0,    81,     0,    54,    81,    81,     0,   243,   162,     0,     0,   243,    81, &
                    0,     0,    54,     0,   162,     0,   243,    81,    81,   243,  -189,    81,    81,   243,    54,    81, &
                   81,   243,    54,    81,     0,     0,  -189,     0,     0,     0,  -189,     0,   162,   486,    54,   162]
  K1(1275,:) = [     0,   243,     0,    81,    81,    54,     0,    81,   162,   243,     0,    81,    81,   243,     0,     0, &
                    0,    54,     0,     0,    81,   243,     0,   162,    81,  -189,   243,    81,    81,    54,   243,    81, &
                   81,    54,   243,    81,     0,  -189,     0,     0,     0,  -189,     0,     0,   162,    54,   486,   162]
  K1(1276,:) = [   243,     0,    81,     0,    54,    81,    81,     0,   243,   162,    81,     0,   243,    81,     0,     0, &
                   54,     0,     0,     0,   243,    81,   162,     0,  -189,    81,    81,   243,    54,    81,    81,   243, &
                   54,    81,    81,   243,  -189,     0,     0,     0,  -189,     0,     0,     0,    54,   162,   162,   486]
  K1(1277,:) = [     0,    81,     0,     0,     0,  -648,   -81,  -432,     0,   -81,     0,     0,     0,  -162,    81,  -243, &
                    0,     0,  -162,  -432,     0,     0,  -648,  -243,   243,    81,    81,    54, -1944,  -648,  -648,  -189, &
                 -243,   -81,   -81,  -189,  -486,  -162,  -162,    54,     0,     0,     0,    54,     0,     0,     0,  -189]
  K1(1278,:) = [    81,     0,     0,     0,  -648,     0,  -432,   -81,   -81,     0,     0,     0,  -162,     0,  -243,    81, &
                    0,     0,  -432,  -162,     0,     0,  -243,  -648,    81,   243,    54,    81,  -648, -1944,  -189,  -648, &
                  -81,  -243,  -189,   -81,  -162,  -486,    54,  -162,     0,     0,    54,     0,     0,     0,  -189,     0]
  K1(1279,:) = [     0,     0,     0,    81,   -81,  -432,     0,  -648,     0,     0,     0,   -81,    81,  -243,     0,  -162, &
                 -162,  -432,     0,     0,  -648,  -243,     0,     0,    81,    54,   243,    81,  -648,  -189, -1944,  -648, &
                  -81,  -189,  -243,   -81,  -162,    54,  -486,  -162,     0,    54,     0,     0,     0,  -189,     0,     0]
  K1(1280,:) = [     0,     0,    81,     0,  -432,   -81,  -648,     0,     0,     0,   -81,     0,  -243,    81,  -162,     0, &
                 -432,  -162,     0,     0,  -243,  -648,     0,     0,    54,    81,    81,   243,  -189,  -648,  -648, -1944, &
                 -189,   -81,   -81,  -243,    54,  -162,  -162,  -486,    54,     0,     0,     0,  -189,     0,     0,     0]
  K1(1281,:) = [     0,    81,  -162,  -243,     0,   -81,  -648,  -432,     0,  -648,     0,  -243,     0,     0,    81,     0, &
                    0,  -162,     0,  -432,     0,     0,   -81,     0,   243,    81,    81,    54,  -243,   -81,   -81,  -189, &
                -1944,  -648,  -648,  -189,     0,     0,     0,    54,  -486,  -162,  -162,    54,     0,     0,     0,  -189]
  K1(1282,:) = [    81,     0,  -243,  -162,   -81,     0,  -432,  -648,  -648,     0,  -243,     0,     0,     0,     0,    81, &
                 -162,     0,  -432,     0,     0,     0,     0,   -81,    81,   243,    54,    81,   -81,  -243,  -189,   -81, &
                 -648, -1944,  -189,  -648,     0,     0,    54,     0,  -162,  -486,    54,  -162,     0,     0,  -189,     0]
  K1(1283,:) = [  -162,  -243,     0,    81,  -648,  -432,     0,   -81,     0,  -243,     0,  -648,    81,     0,     0,     0, &
                    0,  -432,     0,  -162,   -81,     0,     0,     0,    81,    54,   243,    81,   -81,  -189,  -243,   -81, &
                 -648,  -189, -1944,  -648,     0,    54,     0,     0,  -162,    54,  -486,  -162,     0,  -189,     0,     0]
  K1(1284,:) = [  -243,  -162,    81,     0,  -432,  -648,   -81,     0,  -243,     0,  -648,     0,     0,    81,     0,     0, &
                 -432,     0,  -162,     0,     0,   -81,     0,     0,    54,    81,    81,   243,  -189,   -81,   -81,  -243, &
                 -189,  -648,  -648, -1944,    54,     0,     0,     0,    54,  -162,  -162,  -486,  -189,     0,     0,     0]
  K1(1285,:) = [     0,     0,   -81,     0,     0,  -162,     0,  -432,     0,     0,    81,     0,     0,  -648,     0,  -243, &
                    0,   -81,  -648,  -432,     0,    81,  -162,  -243,     0,     0,     0,  -189,  -486,  -162,  -162,    54, &
                    0,     0,     0,    54, -1944,  -648,  -648,  -189,  -243,   -81,   -81,  -189,   243,    81,    81,    54]
  K1(1286,:) = [     0,     0,     0,   -81,  -162,     0,  -432,     0,     0,     0,     0,    81,  -648,     0,  -243,     0, &
                  -81,     0,  -432,  -648,    81,     0,  -243,  -162,     0,     0,  -189,     0,  -162,  -486,    54,  -162, &
                    0,     0,    54,     0,  -648, -1944,  -189,  -648,   -81,  -243,  -189,   -81,    81,   243,    54,    81]
  K1(1287,:) = [   -81,     0,     0,     0,     0,  -432,     0,  -162,    81,     0,     0,     0,     0,  -243,     0,  -648, &
                 -648,  -432,     0,   -81,  -162,  -243,     0,    81,     0,  -189,     0,     0,  -162,    54,  -486,  -162, &
                    0,    54,     0,     0,  -648,  -189, -1944,  -648,   -81,  -189,  -243,   -81,    81,    54,   243,    81]
  K1(1288,:) = [     0,   -81,     0,     0,  -432,     0,  -162,     0,     0,    81,     0,     0,  -243,     0,  -648,     0, &
                 -432,  -648,   -81,     0,  -243,  -162,    81,     0,  -189,     0,     0,     0,    54,  -162,  -162,  -486, &
                   54,     0,     0,     0,  -189,  -648,  -648, -1944,  -189,   -81,   -81,  -243,    54,    81,    81,   243]
  K1(1289,:) = [     0,     0,  -648,  -243,     0,     0,  -162,  -432,     0,  -162,    81,  -243,     0,   -81,     0,     0, &
                    0,  -648,   -81,  -432,     0,    81,     0,     0,     0,     0,     0,  -189,     0,     0,     0,    54, &
                 -486,  -162,  -162,    54,  -243,   -81,   -81,  -189, -1944,  -648,  -648,  -189,   243,    81,    81,    54]
  K1(1290,:) = [     0,     0,  -243,  -648,     0,     0,  -432,  -162,  -162,     0,  -243,    81,   -81,     0,     0,     0, &
                 -648,     0,  -432,   -81,    81,     0,     0,     0,     0,     0,  -189,     0,     0,     0,    54,     0, &
                 -162,  -486,    54,  -162,   -81,  -243,  -189,   -81,  -648, -1944,  -189,  -648,    81,   243,    54,    81]
  K1(1291,:) = [  -648,  -243,     0,     0,  -162,  -432,     0,     0,    81,  -243,     0,  -162,     0,     0,     0,   -81, &
                  -81,  -432,     0,  -648,     0,     0,     0,    81,     0,  -189,     0,     0,     0,    54,     0,     0, &
                 -162,    54,  -486,  -162,   -81,  -189,  -243,   -81,  -648,  -189, -1944,  -648,    81,    54,   243,    81]
  K1(1292,:) = [  -243,  -648,     0,     0,  -432,  -162,     0,     0,  -243,    81,  -162,     0,     0,     0,   -81,     0, &
                 -432,   -81,  -648,     0,     0,     0,    81,     0,  -189,     0,     0,     0,    54,     0,     0,     0, &
                   54,  -162,  -162,  -486,  -189,   -81,   -81,  -243,  -189,  -648,  -648, -1944,    54,    81,    81,   243]
  K1(1293,:) = [     0,   162,    81,   243,     0,     0,     0,    54,     0,     0,    81,   243,     0,    81,   162,   243, &
                    0,    81,    81,    54,     0,    81,     0,   243,   486,   162,   162,    54,     0,     0,     0,  -189, &
                    0,     0,     0,  -189,   243,    81,    81,    54,   243,    81,    81,    54,   243,    81,    81,  -189]
  K1(1294,:) = [   162,     0,   243,    81,     0,     0,    54,     0,     0,     0,   243,    81,    81,     0,   243,   162, &
                   81,     0,    54,    81,    81,     0,   243,     0,   162,   486,    54,   162,     0,     0,  -189,     0, &
                    0,     0,  -189,     0,    81,   243,    54,    81,    81,   243,    54,    81,    81,   243,  -189,    81]
  K1(1295,:) = [    81,   243,     0,   162,     0,    54,     0,     0,    81,   243,     0,     0,   162,   243,     0,    81, &
                   81,    54,     0,    81,     0,   243,     0,    81,   162,    54,   486,   162,     0,  -189,     0,     0, &
                    0,  -189,     0,     0,    81,    54,   243,    81,    81,    54,   243,    81,    81,  -189,   243,    81]
  K1(1296,:) = [   243,    81,   162,     0,    54,     0,     0,     0,   243,    81,     0,     0,   243,   162,    81,     0, &
                   54,    81,    81,     0,   243,     0,    81,     0,    54,   162,   162,   486,  -189,     0,     0,     0, &
                 -189,     0,     0,     0,    54,    81,    81,   243,    54,    81,    81,   243,  -189,    81,    81,   243]
  K1(1297,:) = [     0,   648,   -81,   189,   432,   648,    81,   243,     0,   -81,   -81,   -54,     0,    81,     0,     0, &
                  -54,   -81,   -81,  -243,  -243,     0,  -648,     0,     0,  -648,     0,  -243,     0,     0,    81,     0, &
                    0,    81,   162,   243,     0,   -81,     0,     0,     0,     0,    81,   243,     0,  -162,    81,  -243]
  K1(1298,:) = [   648,     0,   189,   -81,   648,   432,   243,    81,   -81,     0,   -54,   -81,    81,     0,     0,     0, &
                  -81,   -54,  -243,   -81,     0,  -243,     0,  -648,  -648,     0,  -243,     0,     0,     0,     0,    81, &
                   81,     0,   243,   162,   -81,     0,     0,     0,     0,     0,   243,    81,  -162,     0,  -243,    81]
  K1(1299,:) = [   -81,   189,     0,   648,    81,   243,   432,   648,   -81,   -54,     0,   -81,     0,     0,     0,    81, &
                  -81,  -243,   -54,   -81,  -648,     0,  -243,     0,     0,  -243,     0,  -648,    81,     0,     0,     0, &
                  162,   243,     0,    81,     0,     0,     0,   -81,    81,   243,     0,     0,    81,  -243,     0,  -162]
  K1(1300,:) = [   189,   -81,   648,     0,   243,    81,   648,   432,   -54,   -81,   -81,     0,     0,     0,    81,     0, &
                 -243,   -81,   -81,   -54,     0,  -648,     0,  -243,  -243,     0,  -648,     0,     0,    81,     0,     0, &
                  243,   162,    81,     0,     0,     0,   -81,     0,   243,    81,     0,     0,  -243,    81,  -162,     0]
  K1(1301,:) = [   432,   648,    81,   243,     0,   648,   -81,   189,   -54,   -81,   -81,  -243,  -243,     0,  -648,     0, &
                    0,   -81,   -81,   -54,     0,    81,     0,     0,     0,     0,    81,     0,     0,  -648,     0,  -243, &
                    0,     0,    81,   243,     0,  -162,    81,  -243,     0,    81,   162,   243,     0,   -81,     0,     0]
  K1(1302,:) = [   648,   432,   243,    81,   648,     0,   189,   -81,   -81,   -54,  -243,   -81,     0,  -243,     0,  -648, &
                  -81,     0,   -54,   -81,    81,     0,     0,     0,     0,     0,     0,    81,  -648,     0,  -243,     0, &
                    0,     0,   243,    81,  -162,     0,  -243,    81,    81,     0,   243,   162,   -81,     0,     0,     0]
  K1(1303,:) = [    81,   243,   432,   648,   -81,   189,     0,   648,   -81,  -243,   -54,   -81,  -648,     0,  -243,     0, &
                  -81,   -54,     0,   -81,     0,     0,     0,    81,    81,     0,     0,     0,     0,  -243,     0,  -648, &
                   81,   243,     0,     0,    81,  -243,     0,  -162,   162,   243,     0,    81,     0,     0,     0,   -81]
  K1(1304,:) = [   243,    81,   648,   432,   189,   -81,   648,     0,  -243,   -81,   -81,   -54,     0,  -648,     0,  -243, &
                  -54,   -81,   -81,     0,     0,     0,    81,     0,     0,    81,     0,     0,  -243,     0,  -648,     0, &
                  243,    81,     0,     0,  -243,    81,  -162,     0,   243,   162,    81,     0,     0,     0,   -81,     0]
  K1(1305,:) = [     0,   -81,   -81,   -54,   -54,   -81,   -81,  -243,     0,   -81,   648,   189,  -243,  -648,     0,     0, &
                  432,    81,   648,   243,     0,     0,    81,     0,     0,    81,  -162,  -243,     0,     0,   -81,     0, &
                    0,    81,     0,   243,     0,    81,     0,     0,     0,   162,    81,   243,     0,     0,  -648,  -243]
  K1(1306,:) = [   -81,     0,   -54,   -81,   -81,   -54,  -243,   -81,   -81,     0,   189,   648,  -648,  -243,     0,     0, &
                   81,   432,   243,   648,     0,     0,     0,    81,    81,     0,  -243,  -162,     0,     0,     0,   -81, &
                   81,     0,   243,     0,    81,     0,     0,     0,   162,     0,   243,    81,     0,     0,  -243,  -648]
  K1(1307,:) = [   -81,   -54,     0,   -81,   -81,  -243,   -54,   -81,   648,   189,     0,   -81,     0,     0,  -243,  -648, &
                  648,   243,   432,    81,    81,     0,     0,     0,  -162,  -243,     0,    81,   -81,     0,     0,     0, &
                    0,   243,     0,    81,     0,     0,     0,    81,    81,   243,     0,   162,  -648,  -243,     0,     0]
  K1(1308,:) = [   -54,   -81,   -81,     0,  -243,   -81,   -81,   -54,   189,   648,   -81,     0,     0,     0,  -648,  -243, &
                  243,   648,    81,   432,     0,    81,     0,     0,  -243,  -162,    81,     0,     0,   -81,     0,     0, &
                  243,     0,    81,     0,     0,     0,    81,     0,   243,    81,   162,     0,  -243,  -648,     0,     0]
  K1(1309,:) = [     0,    81,     0,     0,  -243,     0,  -648,     0,  -243,  -648,     0,     0, -1944,  -648,  -648,  -189, &
                    0,     0,    81,     0,     0,     0,     0,    54,     0,   -81,  -648,  -432,     0,  -162,     0,  -432, &
                    0,    81,    81,    54,     0,  -648,   -81,  -432,     0,     0,     0,    54,     0,     0,  -162,  -432]
  K1(1310,:) = [    81,     0,     0,     0,     0,  -243,     0,  -648,  -648,  -243,     0,     0,  -648, -1944,  -189,  -648, &
                    0,     0,     0,    81,     0,     0,    54,     0,   -81,     0,  -432,  -648,  -162,     0,  -432,     0, &
                   81,     0,    54,    81,  -648,     0,  -432,   -81,     0,     0,    54,     0,     0,     0,  -432,  -162]
  K1(1311,:) = [     0,     0,     0,    81,  -648,     0,  -243,     0,     0,     0,  -243,  -648,  -648,  -189, -1944,  -648, &
                   81,     0,     0,     0,     0,    54,     0,     0,  -648,  -432,     0,   -81,     0,  -432,     0,  -162, &
                   81,    54,     0,    81,   -81,  -432,     0,  -648,     0,    54,     0,     0,  -162,  -432,     0,     0]
  K1(1312,:) = [     0,     0,    81,     0,     0,  -648,     0,  -243,     0,     0,  -648,  -243,  -189,  -648,  -648, -1944, &
                    0,    81,     0,     0,    54,     0,     0,     0,  -432,  -648,   -81,     0,  -432,     0,  -162,     0, &
                   54,    81,    81,     0,  -432,   -81,  -648,     0,    54,     0,     0,     0,  -432,  -162,     0,     0]
  K1(1313,:) = [   -54,   -81,   -81,  -243,     0,   -81,   -81,   -54,   432,    81,   648,   243,     0,     0,    81,     0, &
                    0,   -81,   648,   189,  -243,  -648,     0,     0,     0,     0,   -81,     0,     0,    81,  -162,  -243, &
                    0,   162,    81,   243,     0,     0,  -648,  -243,     0,    81,     0,   243,     0,    81,     0,     0]
  K1(1314,:) = [   -81,   -54,  -243,   -81,   -81,     0,   -54,   -81,    81,   432,   243,   648,     0,     0,     0,    81, &
                  -81,     0,   189,   648,  -648,  -243,     0,     0,     0,     0,     0,   -81,    81,     0,  -243,  -162, &
                  162,     0,   243,    81,     0,     0,  -243,  -648,    81,     0,   243,     0,    81,     0,     0,     0]
  K1(1315,:) = [   -81,  -243,   -54,   -81,   -81,   -54,     0,   -81,   648,   243,   432,    81,    81,     0,     0,     0, &
                  648,   189,     0,   -81,     0,     0,  -243,  -648,   -81,     0,     0,     0,  -162,  -243,     0,    81, &
                   81,   243,     0,   162,  -648,  -243,     0,     0,     0,   243,     0,    81,     0,     0,     0,    81]
  K1(1316,:) = [  -243,   -81,   -81,   -54,   -54,   -81,   -81,     0,   243,   648,    81,   432,     0,    81,     0,     0, &
                  189,   648,   -81,     0,     0,     0,  -648,  -243,     0,   -81,     0,     0,  -243,  -162,    81,     0, &
                  243,    81,   162,     0,  -243,  -648,     0,     0,   243,     0,    81,     0,     0,     0,    81,     0]
  K1(1317,:) = [  -243,     0,  -648,     0,     0,    81,     0,     0,     0,     0,    81,     0,     0,     0,     0,    54, &
                 -243,  -648,     0,     0, -1944,  -648,  -648,  -189,     0,  -162,     0,  -432,     0,   -81,  -648,  -432, &
                    0,     0,     0,    54,     0,     0,  -162,  -432,     0,    81,    81,    54,     0,  -648,   -81,  -432]
  K1(1318,:) = [     0,  -243,     0,  -648,    81,     0,     0,     0,     0,     0,     0,    81,     0,     0,    54,     0, &
                 -648,  -243,     0,     0,  -648, -1944,  -189,  -648,  -162,     0,  -432,     0,   -81,     0,  -432,  -648, &
                    0,     0,    54,     0,     0,     0,  -432,  -162,    81,     0,    54,    81,  -648,     0,  -432,   -81]
  K1(1319,:) = [  -648,     0,  -243,     0,     0,     0,     0,    81,    81,     0,     0,     0,     0,    54,     0,     0, &
                    0,     0,  -243,  -648,  -648,  -189, -1944,  -648,     0,  -432,     0,  -162,  -648,  -432,     0,   -81, &
                    0,    54,     0,     0,  -162,  -432,     0,     0,    81,    54,     0,    81,   -81,  -432,     0,  -648]
  K1(1320,:) = [     0,  -648,     0,  -243,     0,     0,    81,     0,     0,    81,     0,     0,    54,     0,     0,     0, &
                    0,     0,  -648,  -243,  -189,  -648,  -648, -1944,  -432,     0,  -162,     0,  -432,  -648,   -81,     0, &
                   54,     0,     0,     0,  -432,  -162,     0,     0,    54,    81,    81,     0,  -432,   -81,  -648,     0]
  K1(1321,:) = [     0,  -648,     0,  -243,     0,     0,    81,     0,     0,    81,  -162,  -243,     0,   -81,  -648,  -432, &
                    0,     0,   -81,     0,     0,  -162,     0,  -432, -1944,  -648,  -648,  -189,     0,     0,     0,    54, &
                  243,    81,    81,    54,  -243,   -81,   -81,  -189,     0,     0,     0,  -189,  -486,  -162,  -162,    54]
  K1(1322,:) = [  -648,     0,  -243,     0,     0,     0,     0,    81,    81,     0,  -243,  -162,   -81,     0,  -432,  -648, &
                    0,     0,     0,   -81,  -162,     0,  -432,     0,  -648, -1944,  -189,  -648,     0,     0,    54,     0, &
                   81,   243,    54,    81,   -81,  -243,  -189,   -81,     0,     0,  -189,     0,  -162,  -486,    54,  -162]
  K1(1323,:) = [     0,  -243,     0,  -648,    81,     0,     0,     0,  -162,  -243,     0,    81,  -648,  -432,     0,   -81, &
                  -81,     0,     0,     0,     0,  -432,     0,  -162,  -648,  -189, -1944,  -648,     0,    54,     0,     0, &
                   81,    54,   243,    81,   -81,  -189,  -243,   -81,     0,  -189,     0,     0,  -162,    54,  -486,  -162]
  K1(1324,:) = [  -243,     0,  -648,     0,     0,    81,     0,     0,  -243,  -162,    81,     0,  -432,  -648,   -81,     0, &
                    0,   -81,     0,     0,  -432,     0,  -162,     0,  -189,  -648,  -648, -1944,    54,     0,     0,     0, &
                   54,    81,    81,   243,  -189,   -81,   -81,  -243,  -189,     0,     0,     0,    54,  -162,  -162,  -486]
  K1(1325,:) = [     0,     0,    81,     0,     0,  -648,     0,  -243,     0,     0,   -81,     0,     0,  -162,     0,  -432, &
                    0,    81,  -162,  -243,     0,   -81,  -648,  -432,     0,     0,     0,    54, -1944,  -648,  -648,  -189, &
                    0,     0,     0,  -189,  -486,  -162,  -162,    54,   243,    81,    81,    54,  -243,   -81,   -81,  -189]
  K1(1326,:) = [     0,     0,     0,    81,  -648,     0,  -243,     0,     0,     0,     0,   -81,  -162,     0,  -432,     0, &
                   81,     0,  -243,  -162,   -81,     0,  -432,  -648,     0,     0,    54,     0,  -648, -1944,  -189,  -648, &
                    0,     0,  -189,     0,  -162,  -486,    54,  -162,    81,   243,    54,    81,   -81,  -243,  -189,   -81]
  K1(1327,:) = [    81,     0,     0,     0,     0,  -243,     0,  -648,   -81,     0,     0,     0,     0,  -432,     0,  -162, &
                 -162,  -243,     0,    81,  -648,  -432,     0,   -81,     0,    54,     0,     0,  -648,  -189, -1944,  -648, &
                    0,  -189,     0,     0,  -162,    54,  -486,  -162,    81,    54,   243,    81,   -81,  -189,  -243,   -81]
  K1(1328,:) = [     0,    81,     0,     0,  -243,     0,  -648,     0,     0,   -81,     0,     0,  -432,     0,  -162,     0, &
                 -243,  -162,    81,     0,  -432,  -648,   -81,     0,    54,     0,     0,     0,  -189,  -648,  -648, -1944, &
                 -189,     0,     0,     0,    54,  -162,  -162,  -486,    54,    81,    81,   243,  -189,   -81,   -81,  -243]
  K1(1329,:) = [     0,    81,   162,   243,     0,     0,    81,   243,     0,    81,     0,   243,     0,    81,    81,    54, &
                    0,   162,    81,   243,     0,     0,     0,    54,   243,    81,    81,    54,     0,     0,     0,  -189, &
                  243,    81,    81,  -189,   243,    81,    81,    54,   486,   162,   162,    54,     0,     0,     0,  -189]
  K1(1330,:) = [    81,     0,   243,   162,     0,     0,   243,    81,    81,     0,   243,     0,    81,     0,    54,    81, &
                  162,     0,   243,    81,     0,     0,    54,     0,    81,   243,    54,    81,     0,     0,  -189,     0, &
                   81,   243,  -189,    81,    81,   243,    54,    81,   162,   486,    54,   162,     0,     0,  -189,     0]
  K1(1331,:) = [   162,   243,     0,    81,    81,   243,     0,     0,     0,   243,     0,    81,    81,    54,     0,    81, &
                   81,   243,     0,   162,     0,    54,     0,     0,    81,    54,   243,    81,     0,  -189,     0,     0, &
                   81,  -189,   243,    81,    81,    54,   243,    81,   162,    54,   486,   162,     0,  -189,     0,     0]
  K1(1332,:) = [   243,   162,    81,     0,   243,    81,     0,     0,   243,     0,    81,     0,    54,    81,    81,     0, &
                  243,    81,   162,     0,    54,     0,     0,     0,    54,    81,    81,   243,  -189,     0,     0,     0, &
                 -189,    81,    81,   243,    54,    81,    81,   243,    54,   162,   162,   486,  -189,     0,     0,     0]
  K1(1333,:) = [     0,   -81,     0,     0,     0,  -162,    81,  -243,     0,    81,     0,     0,     0,  -648,   -81,  -432, &
                    0,     0,  -648,  -243,     0,     0,  -162,  -432,  -243,   -81,   -81,  -189,  -486,  -162,  -162,    54, &
                  243,    81,    81,    54, -1944,  -648,  -648,  -189,     0,     0,     0,  -189,     0,     0,     0,    54]
  K1(1334,:) = [   -81,     0,     0,     0,  -162,     0,  -243,    81,    81,     0,     0,     0,  -648,     0,  -432,   -81, &
                    0,     0,  -243,  -648,     0,     0,  -432,  -162,   -81,  -243,  -189,   -81,  -162,  -486,    54,  -162, &
                   81,   243,    54,    81,  -648, -1944,  -189,  -648,     0,     0,  -189,     0,     0,     0,    54,     0]
  K1(1335,:) = [     0,     0,     0,   -81,    81,  -243,     0,  -162,     0,     0,     0,    81,   -81,  -432,     0,  -648, &
                 -648,  -243,     0,     0,  -162,  -432,     0,     0,   -81,  -189,  -243,   -81,  -162,    54,  -486,  -162, &
                   81,    54,   243,    81,  -648,  -189, -1944,  -648,     0,  -189,     0,     0,     0,    54,     0,     0]
  K1(1336,:) = [     0,     0,   -81,     0,  -243,    81,  -162,     0,     0,     0,    81,     0,  -432,   -81,  -648,     0, &
                 -243,  -648,     0,     0,  -432,  -162,     0,     0,  -189,   -81,   -81,  -243,    54,  -162,  -162,  -486, &
                   54,    81,    81,   243,  -189,  -648,  -648, -1944,  -189,     0,     0,     0,    54,     0,     0,     0]
  K1(1337,:) = [     0,     0,    81,   243,     0,    81,   162,   243,     0,   162,    81,   243,     0,     0,     0,    54, &
                    0,    81,     0,   243,     0,    81,    81,    54,     0,     0,     0,  -189,   243,    81,    81,    54, &
                  486,   162,   162,    54,     0,     0,     0,  -189,   243,    81,    81,  -189,   243,    81,    81,    54]
  K1(1338,:) = [     0,     0,   243,    81,    81,     0,   243,   162,   162,     0,   243,    81,     0,     0,    54,     0, &
                   81,     0,   243,     0,    81,     0,    54,    81,     0,     0,  -189,     0,    81,   243,    54,    81, &
                  162,   486,    54,   162,     0,     0,  -189,     0,    81,   243,  -189,    81,    81,   243,    54,    81]
  K1(1339,:) = [    81,   243,     0,     0,   162,   243,     0,    81,    81,   243,     0,   162,     0,    54,     0,     0, &
                    0,   243,     0,    81,    81,    54,     0,    81,     0,  -189,     0,     0,    81,    54,   243,    81, &
                  162,    54,   486,   162,     0,  -189,     0,     0,    81,  -189,   243,    81,    81,    54,   243,    81]
  K1(1340,:) = [   243,    81,     0,     0,   243,   162,    81,     0,   243,    81,   162,     0,    54,     0,     0,     0, &
                  243,     0,    81,     0,    54,    81,    81,     0,  -189,     0,     0,     0,    54,    81,    81,   243, &
                   54,   162,   162,   486,  -189,     0,     0,     0,  -189,    81,    81,   243,    54,    81,    81,   243]
  K1(1341,:) = [     0,  -162,    81,  -243,     0,   -81,     0,     0,     0,     0,  -648,  -243,     0,     0,  -162,  -432, &
                    0,    81,     0,     0,     0,  -648,   -81,  -432,  -486,  -162,  -162,    54,  -243,   -81,   -81,  -189, &
                    0,     0,     0,  -189,     0,     0,     0,    54,   243,    81,    81,    54, -1944,  -648,  -648,  -189]
  K1(1342,:) = [  -162,     0,  -243,    81,   -81,     0,     0,     0,     0,     0,  -243,  -648,     0,     0,  -432,  -162, &
                   81,     0,     0,     0,  -648,     0,  -432,   -81,  -162,  -486,    54,  -162,   -81,  -243,  -189,   -81, &
                    0,     0,  -189,     0,     0,     0,    54,     0,    81,   243,    54,    81,  -648, -1944,  -189,  -648]
  K1(1343,:) = [    81,  -243,     0,  -162,     0,     0,     0,   -81,  -648,  -243,     0,     0,  -162,  -432,     0,     0, &
                    0,     0,     0,    81,   -81,  -432,     0,  -648,  -162,    54,  -486,  -162,   -81,  -189,  -243,   -81, &
                    0,  -189,     0,     0,     0,    54,     0,     0,    81,    54,   243,    81,  -648,  -189, -1944,  -648]
  K1(1344,:) = [  -243,    81,  -162,     0,     0,     0,   -81,     0,  -243,  -648,     0,     0,  -432,  -162,     0,     0, &
                    0,     0,    81,     0,  -432,   -81,  -648,     0,    54,  -162,  -162,  -486,  -189,   -81,   -81,  -243, &
                 -189,     0,     0,     0,    54,     0,     0,     0,    54,    81,    81,   243,  -189,  -648,  -648, -1944]
  K1(1345,:) = [  3456,  1152,  1152,   378,   432,  1152,    18,     0,  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,  -144,   180,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,   180,  -144,   432]
  K1(1346,:) = [  1152,  3456,   378,  1152,  1152,   432,     0,    18,  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 -144,     0,   432,   180,    18,     0,   -54,    18,    18,     0,   432,  1152,   180,     0,   432,  -144]
  K1(1347,:) = [  1152,   378,  3456,  1152,    18,     0,   432,  1152,  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                  180,   432,     0,  -144,    18,   -54,     0,    18,  1152,   432,     0,    18,  -144,   432,     0,   180]
  K1(1348,:) = [   378,  1152,  1152,  3456,     0,    18,  1152,   432,  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,   180,  -144,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,  -144,   180,     0]
  K1(1349,:) = [   432,  1152,    18,     0,  3456,  1152,  1152,   378,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                 -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,   180,  -144,   432,     0,  -144,   180,   432,     0,    18,    18,   -54]
  K1(1350,:) = [  1152,   432,     0,    18,  1152,  3456,   378,  1152,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,   180,     0,   432,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18]
  K1(1351,:) = [    18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                 -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,  -144,   432,     0,   180,   180,   432,     0,  -144,    18,   -54,     0,    18]
  K1(1352,:) = [     0,    18,  1152,   432,   378,  1152,  1152,  3456,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                 -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,  -144,   180,     0,   432,   180,  -144,     0,   -54,    18,    18,     0]
  K1(1353,:) = [  -432,  -144,  -144,  -108,   -54,  -144,  -144,     0,  3456,  1152,  1152,   378,   432,  1152,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,     0,  -144,   180,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,   180,  -144,   432,     0,    18,  1152,   432]
  K1(1354,:) = [  -144,  -432,  -108,  -144,  -144,   -54,     0,  -144,  1152,  3456,   378,  1152,  1152,   432,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,     0,   432,   180,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,     0,   432,  -144,    18,     0,   432,  1152]
  K1(1355,:) = [  -144,  -108,  -432,  -144,  -144,     0,   -54,  -144,  1152,   378,  3456,  1152,    18,     0,   432,  1152, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,   180,   432,     0,  -144,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   432,     0,   180,  1152,   432,     0,    18]
  K1(1356,:) = [  -108,  -144,  -144,  -432,     0,  -144,  -144,   -54,   378,  1152,  1152,  3456,     0,    18,  1152,   432, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,   432,   180,  -144,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,  -144,   180,     0,   432,  1152,    18,     0]
  K1(1357,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   432,  1152,    18,     0,  3456,  1152,  1152,   378, &
                  -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,     0,    18,  1152,   432,     0,   180,  -144,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,  -144,   180,   432]
  K1(1358,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,  1152,   432,     0,    18,  1152,  3456,   378,  1152, &
                 -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,     0,   432,  1152,   180,     0,   432,  -144, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,  -144,     0,   432,   180]
  K1(1359,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   432,  1152,  1152,   378,  3456,  1152, &
                 -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,   432,     0,    18,  -144,   432,     0,   180, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144]
  K1(1360,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,  1152,   432,   378,  1152,  1152,  3456, &
                    0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,   432,  1152,    18,     0,   432,  -144,   180,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,   180,  -144,     0]
  K1(1361,:) = [   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                 3456,  1152,  1152,   378,   432,  1152,    18,     0,     0,    18,    18,   -54,     0,  -144,   180,   432, &
                    0,   180,  -144,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54]
  K1(1362,:) = [  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 1152,  3456,   378,  1152,  1152,   432,     0,    18,    18,     0,   -54,    18,  -144,     0,   432,   180, &
                  180,     0,   432,  -144,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144]
  K1(1363,:) = [  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                 1152,   378,  3456,  1152,    18,     0,   432,  1152,    18,   -54,     0,    18,   180,   432,     0,  -144, &
                 -144,   432,     0,   180,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144]
  K1(1364,:) = [     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                  378,  1152,  1152,  3456,     0,    18,  1152,   432,   -54,    18,    18,     0,   432,   180,  -144,     0, &
                  432,  -144,   180,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0]
  K1(1365,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,     0,  -432,  -144,  -144,  -108, &
                  432,  1152,    18,     0,  3456,  1152,  1152,   378,     0,   180,  -144,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,  -144,   180,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432]
  K1(1366,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,  -144,   -54,     0,  -144,  -144,  -432,  -108,  -144, &
                 1152,   432,     0,    18,  1152,  3456,   378,  1152,   180,     0,   432,  -144,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,  -144,     0,   432,   180,  -144,     0,   -54,  -144,  1152,     0,   432,    18]
  K1(1367,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   -54,  -144,  -144,  -108,  -432,  -144, &
                   18,     0,   432,  1152,  1152,   378,  3456,  1152,  -144,   432,     0,   180,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,   180,   432,     0,  -144,  -144,   -54,     0,  -144,    18,   432,     0,  1152]
  K1(1368,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,  -144,   -54,  -108,  -144,  -144,  -432, &
                    0,    18,  1152,   432,   378,  1152,  1152,  3456,   432,  -144,   180,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,   180,  -144,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0]
  K1(1369,:) = [     0,  1152,    18,   432,     0,  -144,  -144,   -54,     0,  -144,   180,   432,     0,    18,  1152,   432, &
                    0,    18,    18,   -54,     0,   180,  -144,   432,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108, &
                 -432,  -144,  -144,  -108,    54,    18,    18,   378,    54,    18,    18,   378,   540,   180,   180,  -108]
  K1(1370,:) = [  1152,     0,   432,    18,  -144,     0,   -54,  -144,  -144,     0,   432,   180,    18,     0,   432,  1152, &
                   18,     0,   -54,    18,   180,     0,   432,  -144,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144, &
                 -144,  -432,  -108,  -144,    18,    54,   378,    18,    18,    54,   378,    18,   180,   540,  -108,   180]
  K1(1371,:) = [    18,   432,     0,  1152,  -144,   -54,     0,  -144,   180,   432,     0,  -144,  1152,   432,     0,    18, &
                   18,   -54,     0,    18,  -144,   432,     0,   180,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144, &
                 -144,  -108,  -432,  -144,    18,   378,    54,    18,    18,   378,    54,    18,   180,  -108,   540,   180]
  K1(1372,:) = [   432,    18,  1152,     0,   -54,  -144,  -144,     0,   432,   180,  -144,     0,   432,  1152,    18,     0, &
                  -54,    18,    18,     0,   432,  -144,   180,     0,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432, &
                 -108,  -144,  -144,  -432,   378,    18,    18,    54,   378,    18,    18,    54,  -108,   180,   180,   540]
  K1(1373,:) = [     0,  -144,  -144,   -54,     0,  1152,    18,   432,     0,    18,    18,   -54,     0,   180,  -144,   432, &
                    0,  -144,   180,   432,     0,    18,  1152,   432,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378, &
                   54,    18,    18,   378,   540,   180,   180,  -108,  -432,  -144,  -144,  -108,    54,    18,    18,   378]
  K1(1374,:) = [  -144,     0,   -54,  -144,  1152,     0,   432,    18,    18,     0,   -54,    18,   180,     0,   432,  -144, &
                 -144,     0,   432,   180,    18,     0,   432,  1152,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152, &
                   18,    54,   378,    18,   180,   540,  -108,   180,  -144,  -432,  -108,  -144,    18,    54,   378,    18]
  K1(1375,:) = [  -144,   -54,     0,  -144,    18,   432,     0,  1152,    18,   -54,     0,    18,  -144,   432,     0,   180, &
                  180,   432,     0,  -144,  1152,   432,     0,    18,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152, &
                   18,   378,    54,    18,   180,  -108,   540,   180,  -144,  -108,  -432,  -144,    18,   378,    54,    18]
  K1(1376,:) = [   -54,  -144,  -144,     0,   432,    18,  1152,     0,   -54,    18,    18,     0,   432,  -144,   180,     0, &
                  432,   180,  -144,     0,   432,  1152,    18,     0,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456, &
                  378,    18,    18,    54,  -108,   180,   180,   540,  -108,  -144,  -144,  -432,   378,    18,    18,    54]
  K1(1377,:) = [     0,  -144,   180,   432,     0,    18,  1152,   432,     0,  1152,    18,   432,     0,  -144,  -144,   -54, &
                    0,   180,  -144,   432,     0,    18,    18,   -54,  -432,  -144,  -144,  -108,    54,    18,    18,   378, &
                 3456,  1152,  1152,   378,  -432,  -144,  -144,  -108,   540,   180,   180,  -108,    54,    18,    18,   378]
  K1(1378,:) = [  -144,     0,   432,   180,    18,     0,   432,  1152,  1152,     0,   432,    18,  -144,     0,   -54,  -144, &
                  180,     0,   432,  -144,    18,     0,   -54,    18,  -144,  -432,  -108,  -144,    18,    54,   378,    18, &
                 1152,  3456,   378,  1152,  -144,  -432,  -108,  -144,   180,   540,  -108,   180,    18,    54,   378,    18]
  K1(1379,:) = [   180,   432,     0,  -144,  1152,   432,     0,    18,    18,   432,     0,  1152,  -144,   -54,     0,  -144, &
                 -144,   432,     0,   180,    18,   -54,     0,    18,  -144,  -108,  -432,  -144,    18,   378,    54,    18, &
                 1152,   378,  3456,  1152,  -144,  -108,  -432,  -144,   180,  -108,   540,   180,    18,   378,    54,    18]
  K1(1380,:) = [   432,   180,  -144,     0,   432,  1152,    18,     0,   432,    18,  1152,     0,   -54,  -144,  -144,     0, &
                  432,  -144,   180,     0,   -54,    18,    18,     0,  -108,  -144,  -144,  -432,   378,    18,    18,    54, &
                  378,  1152,  1152,  3456,  -108,  -144,  -144,  -432,  -108,   180,   180,   540,   378,    18,    18,    54]
  K1(1381,:) = [     0,    18,    18,   -54,     0,   180,  -144,   432,     0,  -144,  -144,   -54,     0,  1152,    18,   432, &
                    0,    18,  1152,   432,     0,  -144,   180,   432,    54,    18,    18,   378,   540,   180,   180,  -108, &
                 -432,  -144,  -144,  -108,  3456,  1152,  1152,   378,    54,    18,    18,   378,  -432,  -144,  -144,  -108]
  K1(1382,:) = [    18,     0,   -54,    18,   180,     0,   432,  -144,  -144,     0,   -54,  -144,  1152,     0,   432,    18, &
                   18,     0,   432,  1152,  -144,     0,   432,   180,    18,    54,   378,    18,   180,   540,  -108,   180, &
                 -144,  -432,  -108,  -144,  1152,  3456,   378,  1152,    18,    54,   378,    18,  -144,  -432,  -108,  -144]
  K1(1383,:) = [    18,   -54,     0,    18,  -144,   432,     0,   180,  -144,   -54,     0,  -144,    18,   432,     0,  1152, &
                 1152,   432,     0,    18,   180,   432,     0,  -144,    18,   378,    54,    18,   180,  -108,   540,   180, &
                 -144,  -108,  -432,  -144,  1152,   378,  3456,  1152,    18,   378,    54,    18,  -144,  -108,  -432,  -144]
  K1(1384,:) = [   -54,    18,    18,     0,   432,  -144,   180,     0,   -54,  -144,  -144,     0,   432,    18,  1152,     0, &
                  432,  1152,    18,     0,   432,   180,  -144,     0,   378,    18,    18,    54,  -108,   180,   180,   540, &
                 -108,  -144,  -144,  -432,   378,  1152,  1152,  3456,   378,    18,    18,    54,  -108,  -144,  -144,  -432]
  K1(1385,:) = [     0,    18,  1152,   432,     0,  -144,   180,   432,     0,   180,  -144,   432,     0,    18,    18,   -54, &
                    0,  1152,    18,   432,     0,  -144,  -144,   -54,    54,    18,    18,   378,  -432,  -144,  -144,  -108, &
                  540,   180,   180,  -108,    54,    18,    18,   378,  3456,  1152,  1152,   378,  -432,  -144,  -144,  -108]
  K1(1386,:) = [    18,     0,   432,  1152,  -144,     0,   432,   180,   180,     0,   432,  -144,    18,     0,   -54,    18, &
                 1152,     0,   432,    18,  -144,     0,   -54,  -144,    18,    54,   378,    18,  -144,  -432,  -108,  -144, &
                  180,   540,  -108,   180,    18,    54,   378,    18,  1152,  3456,   378,  1152,  -144,  -432,  -108,  -144]
  K1(1387,:) = [  1152,   432,     0,    18,   180,   432,     0,  -144,  -144,   432,     0,   180,    18,   -54,     0,    18, &
                   18,   432,     0,  1152,  -144,   -54,     0,  -144,    18,   378,    54,    18,  -144,  -108,  -432,  -144, &
                  180,  -108,   540,   180,    18,   378,    54,    18,  1152,   378,  3456,  1152,  -144,  -108,  -432,  -144]
  K1(1388,:) = [   432,  1152,    18,     0,   432,   180,  -144,     0,   432,  -144,   180,     0,   -54,    18,    18,     0, &
                  432,    18,  1152,     0,   -54,  -144,  -144,     0,   378,    18,    18,    54,  -108,  -144,  -144,  -432, &
                 -108,   180,   180,   540,   378,    18,    18,    54,   378,  1152,  1152,  3456,  -108,  -144,  -144,  -432]
  K1(1389,:) = [     0,   180,  -144,   432,     0,    18,    18,   -54,     0,    18,  1152,   432,     0,  -144,   180,   432, &
                    0,  -144,  -144,   -54,     0,  1152,    18,   432,   540,   180,   180,  -108,    54,    18,    18,   378, &
                   54,    18,    18,   378,  -432,  -144,  -144,  -108,  -432,  -144,  -144,  -108,  3456,  1152,  1152,   378]
  K1(1390,:) = [   180,     0,   432,  -144,    18,     0,   -54,    18,    18,     0,   432,  1152,  -144,     0,   432,   180, &
                 -144,     0,   -54,  -144,  1152,     0,   432,    18,   180,   540,  -108,   180,    18,    54,   378,    18, &
                   18,    54,   378,    18,  -144,  -432,  -108,  -144,  -144,  -432,  -108,  -144,  1152,  3456,   378,  1152]
  K1(1391,:) = [  -144,   432,     0,   180,    18,   -54,     0,    18,  1152,   432,     0,    18,   180,   432,     0,  -144, &
                 -144,   -54,     0,  -144,    18,   432,     0,  1152,   180,  -108,   540,   180,    18,   378,    54,    18, &
                   18,   378,    54,    18,  -144,  -108,  -432,  -144,  -144,  -108,  -432,  -144,  1152,   378,  3456,  1152]
  K1(1392,:) = [   432,  -144,   180,     0,   -54,    18,    18,     0,   432,  1152,    18,     0,   432,   180,  -144,     0, &
                  -54,  -144,  -144,     0,   432,    18,  1152,     0,  -108,   180,   180,   540,   378,    18,    18,    54, &
                  378,    18,    18,    54,  -108,  -144,  -144,  -432,  -108,  -144,  -144,  -432,   378,  1152,  1152,  3456]
  K1(1393,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1394,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1395,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1396,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1397,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1398,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1399,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1400,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1401,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1402,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1403,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1404,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1405,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1406,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1407,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1408,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1409,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1410,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1411,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1412,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1413,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1414,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1415,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1416,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1417,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1418,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1419,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1420,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1421,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1422,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1423,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1424,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1425,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1426,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1427,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1428,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1429,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1430,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1431,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1432,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1433,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1434,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1435,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1436,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1437,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1438,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1439,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1(1440,:) = [     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
                    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0]
  K1 = (1._/**/REALKIND / 54) * K1

  end subroutine colourmatrix_init
end module ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND



module ol_forced_parameters_pptttt_tttxtxggg_1_/**/REALKIND
  implicit none
  contains
  subroutine check_forced_parameters
    use ol_parameters_decl_/**/REALKIND
    use ol_loop_parameters_decl_/**/REALKIND
#ifndef PRECISION_dp
    use ol_loop_parameters_decl_/**/DREALKIND, only: LeadingColour, nc, nf, CKMORDER
#endif
    implicit none
    logical, save :: checks_not_written = .true.

    if (checks_not_written) then
    ! e.g.
    ! if (ME /= 0) write(*,101) 'ME = 0'
  if (CKMORDER /= 0) write(*,101) 'CKMORDER = 0'
  if (nc /= 3) write(*,101) 'nc = 3'
  if (nf /= 6) write(*,101) 'nf = 6'
  if (MU /= 0) write(*,101) 'MU = 0'
  if (MD /= 0) write(*,101) 'MD = 0'
  if (MS /= 0) write(*,101) 'MS = 0'
  if (MC /= 0) write(*,101) 'MC = 0'
  if (LeadingColour /= 0) write(*,101) 'LeadingColour = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'
  if (wMT /= 0) write(*,101) 'wMT = 0'


    checks_not_written = .false.
    end if

    101 format('[OpenLoops] === WARNING ===',/,'[OpenLoops] code was generated with ',A,/,'[OpenLoops] ===============')
  end subroutine check_forced_parameters
end module ol_forced_parameters_pptttt_tttxtxggg_1_/**/REALKIND

module ol_tree_pptttt_tttxtxggg_1_/**/REALKIND
  use KIND_TYPES, only: REALKIND, DREALKIND, intkind1, intkind2
  implicit none
  integer,           save :: factors_status = -1
  complex(REALKIND), save :: f(2)
  complex(REALKIND), save :: den(891)
#ifdef PRECISION_dp
  integer(intkind1), save :: ntry = 1
  integer(intkind2), parameter :: nheltot = 128 ! number of helicity configurations
  integer(intkind2), save :: nhel = 128 ! number of non-vanishing helicity configurations (adapted at runtime)
  integer(intkind2), save :: Hel(128) ! physical helicity states
  complex(DREALKIND) :: M1helarr(48,128) ! cache
#endif

  contains

subroutine factors_init()
  use ol_parameters_decl_/**/REALKIND
  use ol_loop_parameters_decl_/**/REALKIND, only: loop_parameters_status
  implicit none
  factors_status = parameters_status
  ! factors of the diagrams
    f(1) = CI*gQCD**5
    f(2) = gQCD**5

end subroutine factors_init


subroutine born_denominators_init()
  use ol_parameters_decl_/**/REALKIND ! masses
  use ol_momenta_decl_/**/REALKIND, only: Q
  implicit none

  ! propagators

  den(1) = 1 / (Q(5,5))
  den(2) = 1 / (Q(5,10))
  den(3) = 1 / (Q(5,48))
  den(6) = 1 / (Q(5,80))
  den(8) = 1 / (Q(5,21))
  den(11) = 1 / (Q(5,26))
  den(14) = 1 / (Q(5,96))
  den(16) = 1 / (Q(5,37))
  den(19) = 1 / (Q(5,42))
  den(22) = 1 / (Q(5,69))
  den(25) = 1 / (Q(5,74))
  den(28) = 1 / (Q(5,112))
  den(30) = 1 / (Q(5,18) - MT2)
  den(33) = 1 / (Q(5,24) - MT2)
  den(36) = 1 / (Q(5,34) - MT2)
  den(39) = 1 / (Q(5,40) - MT2)
  den(42) = 1 / (Q(5,66) - MT2)
  den(45) = 1 / (Q(5,72) - MT2)
  den(48) = 1 / (Q(5,7) - MT2)
  den(51) = 1 / (Q(5,114) - MT2)
  den(54) = 1 / (Q(5,9))
  den(55) = 1 / (Q(5,6))
  den(59) = 1 / (Q(5,25))
  den(62) = 1 / (Q(5,22))
  den(66) = 1 / (Q(5,41))
  den(69) = 1 / (Q(5,38))
  den(72) = 1 / (Q(5,73))
  den(75) = 1 / (Q(5,70))
  den(79) = 1 / (Q(5,17) - MT2)
  den(84) = 1 / (Q(5,33) - MT2)
  den(89) = 1 / (Q(5,65) - MT2)
  den(96) = 1 / (Q(5,113) - MT2)
  den(101) = 1 / (Q(5,20) - MT2)
  den(106) = 1 / (Q(5,36) - MT2)
  den(111) = 1 / (Q(5,68) - MT2)
  den(114) = 1 / (Q(5,11) - MT2)
  den(160) = 1 / (Q(5,82) - MT2)
  den(164) = 1 / (Q(5,104) - MT2)
  den(170) = 1 / (Q(5,50) - MT2)
  den(176) = 1 / (Q(5,13) - MT2)
  den(191) = 1 / (Q(5,98) - MT2)
  den(195) = 1 / (Q(5,88) - MT2)
  den(203) = 1 / (Q(5,56) - MT2)
  den(313) = 1 / (Q(5,81) - MT2)
  den(321) = 1 / (Q(5,49) - MT2)
  den(329) = 1 / (Q(5,14) - MT2)
  den(340) = 1 / (Q(5,97) - MT2)
  den(436) = 1 / (Q(5,100) - MT2)
  den(461) = 1 / (Q(5,84) - MT2)
  den(468) = 1 / (Q(5,52) - MT2)

  ! denominators

  den(4) = den(1)*den(2)
  den(5) = den(3)*den(4)
  den(7) = den(4)*den(6)
  den(9) = den(1)*den(8)
  den(10) = den(2)*den(9)
  den(12) = den(2)*den(11)
  den(13) = den(1)*den(12)
  den(15) = den(4)*den(14)
  den(17) = den(1)*den(16)
  den(18) = den(2)*den(17)
  den(20) = den(2)*den(19)
  den(21) = den(1)*den(20)
  den(23) = den(1)*den(22)
  den(24) = den(2)*den(23)
  den(26) = den(2)*den(25)
  den(27) = den(1)*den(26)
  den(29) = den(4)*den(28)
  den(31) = den(11)*den(30)
  den(32) = den(1)*den(31)
  den(34) = den(11)*den(33)
  den(35) = den(1)*den(34)
  den(37) = den(19)*den(36)
  den(38) = den(1)*den(37)
  den(40) = den(19)*den(39)
  den(41) = den(1)*den(40)
  den(43) = den(25)*den(42)
  den(44) = den(1)*den(43)
  den(46) = den(25)*den(45)
  den(47) = den(1)*den(46)
  den(49) = den(1)*den(48)
  den(50) = den(28)*den(49)
  den(52) = den(28)*den(51)
  den(53) = den(1)*den(52)
  den(56) = den(54)*den(55)
  den(57) = den(3)*den(56)
  den(58) = den(6)*den(56)
  den(60) = den(54)*den(59)
  den(61) = den(55)*den(60)
  den(63) = den(55)*den(62)
  den(64) = den(54)*den(63)
  den(65) = den(14)*den(56)
  den(67) = den(54)*den(66)
  den(68) = den(55)*den(67)
  den(70) = den(55)*den(69)
  den(71) = den(54)*den(70)
  den(73) = den(54)*den(72)
  den(74) = den(55)*den(73)
  den(76) = den(55)*den(75)
  den(77) = den(54)*den(76)
  den(78) = den(28)*den(56)
  den(80) = den(59)*den(79)
  den(81) = den(55)*den(80)
  den(82) = den(33)*den(59)
  den(83) = den(55)*den(82)
  den(85) = den(66)*den(84)
  den(86) = den(55)*den(85)
  den(87) = den(39)*den(66)
  den(88) = den(55)*den(87)
  den(90) = den(72)*den(89)
  den(91) = den(55)*den(90)
  den(92) = den(45)*den(72)
  den(93) = den(55)*den(92)
  den(94) = den(48)*den(55)
  den(95) = den(28)*den(94)
  den(97) = den(28)*den(96)
  den(98) = den(55)*den(97)
  den(99) = den(30)*den(62)
  den(100) = den(54)*den(99)
  den(102) = den(62)*den(101)
  den(103) = den(54)*den(102)
  den(104) = den(36)*den(69)
  den(105) = den(54)*den(104)
  den(107) = den(69)*den(106)
  den(108) = den(54)*den(107)
  den(109) = den(42)*den(75)
  den(110) = den(54)*den(109)
  den(112) = den(75)*den(111)
  den(113) = den(54)*den(112)
  den(115) = den(54)*den(114)
  den(116) = den(28)*den(115)
  den(117) = den(52)*den(54)
  den(118) = den(8)*den(79)
  den(119) = den(2)*den(118)
  den(120) = den(8)*den(101)
  den(121) = den(2)*den(120)
  den(122) = den(16)*den(84)
  den(123) = den(2)*den(122)
  den(124) = den(16)*den(106)
  den(125) = den(2)*den(124)
  den(126) = den(22)*den(89)
  den(127) = den(2)*den(126)
  den(128) = den(22)*den(111)
  den(129) = den(2)*den(128)
  den(130) = den(2)*den(114)
  den(131) = den(28)*den(130)
  den(132) = den(2)*den(97)
  den(133) = den(2)*den(3)
  den(134) = den(23)*den(133)
  den(135) = den(1)*den(3)
  den(136) = den(26)*den(135)
  den(137) = den(3)*den(28)
  den(138) = den(4)*den(137)
  den(139) = den(2)*den(6)
  den(140) = den(17)*den(139)
  den(141) = den(1)*den(6)
  den(142) = den(20)*den(141)
  den(143) = den(6)*den(28)
  den(144) = den(4)*den(143)
  den(145) = den(2)*den(14)
  den(146) = den(9)*den(145)
  den(147) = den(1)*den(14)
  den(148) = den(12)*den(147)
  den(149) = den(14)*den(28)
  den(150) = den(4)*den(149)
  den(151) = den(9)*den(20)
  den(152) = den(9)*den(26)
  den(153) = den(12)*den(17)
  den(154) = den(17)*den(26)
  den(155) = den(12)*den(23)
  den(156) = den(20)*den(23)
  den(157) = den(30)*den(39)
  den(158) = den(23)*den(157)
  den(159) = den(1)*den(39)
  den(161) = den(30)*den(160)
  den(162) = den(159)*den(161)
  den(163) = den(1)*den(30)
  den(165) = den(39)*den(164)
  den(166) = den(163)*den(165)
  den(167) = den(30)*den(45)
  den(168) = den(17)*den(167)
  den(169) = den(1)*den(45)
  den(171) = den(30)*den(170)
  den(172) = den(169)*den(171)
  den(173) = den(45)*den(164)
  den(174) = den(163)*den(173)
  den(175) = den(14)*den(30)
  den(177) = den(1)*den(176)
  den(178) = den(175)*den(177)
  den(179) = den(31)*den(147)
  den(180) = den(14)*den(164)
  den(181) = den(163)*den(180)
  den(182) = den(171)*den(177)
  den(183) = den(161)*den(177)
  den(184) = den(17)*den(31)
  den(185) = den(17)*den(161)
  den(186) = den(23)*den(31)
  den(187) = den(23)*den(171)
  den(188) = den(33)*den(36)
  den(189) = den(23)*den(188)
  den(190) = den(1)*den(33)
  den(192) = den(36)*den(191)
  den(193) = den(190)*den(192)
  den(194) = den(1)*den(36)
  den(196) = den(33)*den(195)
  den(197) = den(194)*den(196)
  den(198) = den(33)*den(42)
  den(199) = den(17)*den(198)
  den(200) = den(42)*den(191)
  den(201) = den(190)*den(200)
  den(202) = den(1)*den(42)
  den(204) = den(33)*den(203)
  den(205) = den(202)*den(204)
  den(206) = den(14)*den(33)
  den(207) = den(49)*den(206)
  den(208) = den(34)*den(147)
  den(209) = den(14)*den(191)
  den(210) = den(190)*den(209)
  den(211) = den(49)*den(196)
  den(212) = den(49)*den(204)
  den(213) = den(17)*den(34)
  den(214) = den(17)*den(196)
  den(215) = den(23)*den(34)
  den(216) = den(23)*den(204)
  den(217) = den(36)*den(45)
  den(218) = den(9)*den(217)
  den(219) = den(36)*den(170)
  den(220) = den(169)*den(219)
  den(221) = den(45)*den(195)
  den(222) = den(194)*den(221)
  den(223) = den(6)*den(36)
  den(224) = den(177)*den(223)
  den(225) = den(37)*den(141)
  den(226) = den(6)*den(195)
  den(227) = den(194)*den(226)
  den(228) = den(177)*den(219)
  den(229) = den(177)*den(192)
  den(230) = den(9)*den(37)
  den(231) = den(9)*den(192)
  den(232) = den(23)*den(37)
  den(233) = den(23)*den(219)
  den(234) = den(39)*den(42)
  den(235) = den(9)*den(234)
  den(236) = den(42)*den(160)
  den(237) = den(159)*den(236)
  den(238) = den(39)*den(203)
  den(239) = den(202)*den(238)
  den(240) = den(6)*den(39)
  den(241) = den(49)*den(240)
  den(242) = den(40)*den(141)
  den(243) = den(6)*den(160)
  den(244) = den(159)*den(243)
  den(245) = den(49)*den(165)
  den(246) = den(49)*den(238)
  den(247) = den(9)*den(40)
  den(248) = den(9)*den(165)
  den(249) = den(23)*den(40)
  den(250) = den(23)*den(238)
  den(251) = den(3)*den(42)
  den(252) = den(177)*den(251)
  den(253) = den(43)*den(135)
  den(254) = den(3)*den(203)
  den(255) = den(202)*den(254)
  den(256) = den(3)*den(45)
  den(257) = den(49)*den(256)
  den(258) = den(46)*den(135)
  den(259) = den(3)*den(170)
  den(260) = den(169)*den(259)
  den(261) = den(49)*den(137)
  den(262) = den(49)*den(254)
  den(263) = den(137)*den(177)
  den(264) = den(177)*den(259)
  den(265) = den(23)*den(259)
  den(266) = den(23)*den(254)
  den(267) = den(177)*den(236)
  den(268) = den(177)*den(200)
  den(269) = den(9)*den(43)
  den(270) = den(9)*den(200)
  den(271) = den(17)*den(43)
  den(272) = den(17)*den(236)
  den(273) = den(49)*den(173)
  den(274) = den(49)*den(221)
  den(275) = den(9)*den(46)
  den(276) = den(9)*den(173)
  den(277) = den(17)*den(46)
  den(278) = den(17)*den(221)
  den(279) = den(49)*den(143)
  den(280) = den(49)*den(226)
  den(281) = den(143)*den(177)
  den(282) = den(177)*den(243)
  den(283) = den(17)*den(243)
  den(284) = den(17)*den(226)
  den(285) = den(49)*den(149)
  den(286) = den(49)*den(180)
  den(287) = den(149)*den(177)
  den(288) = den(177)*den(209)
  den(289) = den(9)*den(180)
  den(290) = den(9)*den(209)
  den(291) = den(3)*den(55)
  den(292) = den(73)*den(291)
  den(293) = den(3)*den(54)
  den(294) = den(76)*den(293)
  den(295) = den(56)*den(137)
  den(296) = den(6)*den(55)
  den(297) = den(67)*den(296)
  den(298) = den(6)*den(54)
  den(299) = den(70)*den(298)
  den(300) = den(56)*den(143)
  den(301) = den(14)*den(55)
  den(302) = den(60)*den(301)
  den(303) = den(14)*den(54)
  den(304) = den(63)*den(303)
  den(305) = den(56)*den(149)
  den(306) = den(60)*den(70)
  den(307) = den(60)*den(76)
  den(308) = den(63)*den(67)
  den(309) = den(67)*den(76)
  den(310) = den(63)*den(73)
  den(311) = den(70)*den(73)
  den(312) = den(39)*den(55)
  den(314) = den(79)*den(313)
  den(315) = den(312)*den(314)
  den(316) = den(39)*den(79)
  den(317) = den(76)*den(316)
  den(318) = den(55)*den(79)
  den(319) = den(165)*den(318)
  den(320) = den(45)*den(55)
  den(322) = den(79)*den(321)
  den(323) = den(320)*den(322)
  den(324) = den(45)*den(79)
  den(325) = den(70)*den(324)
  den(326) = den(173)*den(318)
  den(327) = den(80)*den(301)
  den(328) = den(14)*den(79)
  den(330) = den(55)*den(329)
  den(331) = den(328)*den(330)
  den(332) = den(180)*den(318)
  den(333) = den(70)*den(80)
  den(334) = den(76)*den(80)
  den(335) = den(322)*den(330)
  den(336) = den(76)*den(322)
  den(337) = den(314)*den(330)
  den(338) = den(70)*den(314)
  den(339) = den(33)*den(55)
  den(341) = den(84)*den(340)
  den(342) = den(339)*den(341)
  den(343) = den(33)*den(84)
  den(344) = den(76)*den(343)
  den(345) = den(55)*den(84)
  den(346) = den(196)*den(345)
  den(347) = den(89)*den(340)
  den(348) = den(339)*den(347)
  den(349) = den(33)*den(89)
  den(350) = den(70)*den(349)
  den(351) = den(55)*den(89)
  den(352) = den(204)*den(351)
  den(353) = den(94)*den(206)
  den(354) = den(82)*den(301)
  den(355) = den(14)*den(340)
  den(356) = den(339)*den(355)
  den(357) = den(94)*den(196)
  den(358) = den(94)*den(204)
  den(359) = den(76)*den(82)
  den(360) = den(70)*den(82)
  den(361) = den(70)*den(196)
  den(362) = den(76)*den(204)
  den(363) = den(84)*den(321)
  den(364) = den(320)*den(363)
  den(365) = den(45)*den(84)
  den(366) = den(63)*den(365)
  den(367) = den(221)*den(345)
  den(368) = den(85)*den(296)
  den(369) = den(6)*den(84)
  den(370) = den(330)*den(369)
  den(371) = den(226)*den(345)
  den(372) = den(63)*den(85)
  den(373) = den(76)*den(85)
  den(374) = den(330)*den(363)
  den(375) = den(76)*den(363)
  den(376) = den(330)*den(341)
  den(377) = den(63)*den(341)
  den(378) = den(89)*den(313)
  den(379) = den(312)*den(378)
  den(380) = den(39)*den(89)
  den(381) = den(63)*den(380)
  den(382) = den(238)*den(351)
  den(383) = den(94)*den(240)
  den(384) = den(87)*den(296)
  den(385) = den(6)*den(313)
  den(386) = den(312)*den(385)
  den(387) = den(94)*den(165)
  den(388) = den(94)*den(238)
  den(389) = den(76)*den(87)
  den(390) = den(63)*den(87)
  den(391) = den(63)*den(165)
  den(392) = den(76)*den(238)
  den(393) = den(90)*den(291)
  den(394) = den(3)*den(89)
  den(395) = den(330)*den(394)
  den(396) = den(254)*den(351)
  den(397) = den(94)*den(256)
  den(398) = den(92)*den(291)
  den(399) = den(3)*den(321)
  den(400) = den(320)*den(399)
  den(401) = den(94)*den(137)
  den(402) = den(94)*den(254)
  den(403) = den(76)*den(399)
  den(404) = den(137)*den(330)
  den(405) = den(76)*den(254)
  den(406) = den(330)*den(399)
  den(407) = den(63)*den(90)
  den(408) = den(70)*den(90)
  den(409) = den(330)*den(378)
  den(410) = den(70)*den(378)
  den(411) = den(330)*den(347)
  den(412) = den(63)*den(347)
  den(413) = den(94)*den(173)
  den(414) = den(94)*den(221)
  den(415) = den(70)*den(92)
  den(416) = den(63)*den(92)
  den(417) = den(63)*den(173)
  den(418) = den(70)*den(221)
  den(419) = den(94)*den(143)
  den(420) = den(94)*den(226)
  den(421) = den(70)*den(385)
  den(422) = den(143)*den(330)
  den(423) = den(70)*den(226)
  den(424) = den(330)*den(385)
  den(425) = den(94)*den(149)
  den(426) = den(94)*den(180)
  den(427) = den(149)*den(330)
  den(428) = den(63)*den(180)
  den(429) = den(63)*den(355)
  den(430) = den(330)*den(355)
  den(431) = den(30)*den(106)
  den(432) = den(73)*den(431)
  den(433) = den(54)*den(106)
  den(434) = den(161)*den(433)
  den(435) = den(30)*den(54)
  den(437) = den(106)*den(436)
  den(438) = den(435)*den(437)
  den(439) = den(30)*den(111)
  den(440) = den(67)*den(439)
  den(441) = den(54)*den(111)
  den(442) = den(171)*den(441)
  den(443) = den(111)*den(436)
  den(444) = den(435)*den(443)
  den(445) = den(54)*den(176)
  den(446) = den(175)*den(445)
  den(447) = den(99)*den(303)
  den(448) = den(14)*den(436)
  den(449) = den(435)*den(448)
  den(450) = den(171)*den(445)
  den(451) = den(161)*den(445)
  den(452) = den(67)*den(99)
  den(453) = den(67)*den(161)
  den(454) = den(73)*den(99)
  den(455) = den(73)*den(171)
  den(456) = den(36)*den(101)
  den(457) = den(73)*den(456)
  den(458) = den(54)*den(101)
  den(459) = den(192)*den(458)
  den(460) = den(36)*den(54)
  den(462) = den(101)*den(461)
  den(463) = den(460)*den(462)
  den(464) = den(42)*den(101)
  den(465) = den(67)*den(464)
  den(466) = den(200)*den(458)
  den(467) = den(42)*den(54)
  den(469) = den(101)*den(468)
  den(470) = den(467)*den(469)
  den(471) = den(14)*den(101)
  den(472) = den(115)*den(471)
  den(473) = den(102)*den(303)
  den(474) = den(209)*den(458)
  den(475) = den(115)*den(462)
  den(476) = den(115)*den(469)
  den(477) = den(67)*den(102)
  den(478) = den(67)*den(462)
  den(479) = den(73)*den(102)
  den(480) = den(73)*den(469)
  den(481) = den(36)*den(111)
  den(482) = den(60)*den(481)
  den(483) = den(219)*den(441)
  den(484) = den(111)*den(461)
  den(485) = den(460)*den(484)
  den(486) = den(223)*den(445)
  den(487) = den(104)*den(298)
  den(488) = den(6)*den(461)
  den(489) = den(460)*den(488)
  den(490) = den(219)*den(445)
  den(491) = den(192)*den(445)
  den(492) = den(60)*den(104)
  den(493) = den(60)*den(192)
  den(494) = den(73)*den(104)
  den(495) = den(73)*den(219)
  den(496) = den(42)*den(106)
  den(497) = den(60)*den(496)
  den(498) = den(236)*den(433)
  den(499) = den(106)*den(468)
  den(500) = den(467)*den(499)
  den(501) = den(6)*den(106)
  den(502) = den(115)*den(501)
  den(503) = den(107)*den(298)
  den(504) = den(243)*den(433)
  den(505) = den(115)*den(437)
  den(506) = den(115)*den(499)
  den(507) = den(60)*den(107)
  den(508) = den(60)*den(437)
  den(509) = den(73)*den(107)
  den(510) = den(73)*den(499)
  den(511) = den(251)*den(445)
  den(512) = den(109)*den(293)
  den(513) = den(3)*den(468)
  den(514) = den(467)*den(513)
  den(515) = den(3)*den(111)
  den(516) = den(115)*den(515)
  den(517) = den(112)*den(293)
  den(518) = den(259)*den(441)
  den(519) = den(115)*den(137)
  den(520) = den(115)*den(513)
  den(521) = den(137)*den(445)
  den(522) = den(259)*den(445)
  den(523) = den(73)*den(259)
  den(524) = den(73)*den(513)
  den(525) = den(236)*den(445)
  den(526) = den(200)*den(445)
  den(527) = den(60)*den(109)
  den(528) = den(60)*den(200)
  den(529) = den(67)*den(109)
  den(530) = den(67)*den(236)
  den(531) = den(115)*den(443)
  den(532) = den(115)*den(484)
  den(533) = den(60)*den(112)
  den(534) = den(60)*den(443)
  den(535) = den(67)*den(112)
  den(536) = den(67)*den(484)
  den(537) = den(115)*den(143)
  den(538) = den(115)*den(488)
  den(539) = den(143)*den(445)
  den(540) = den(243)*den(445)
  den(541) = den(67)*den(243)
  den(542) = den(67)*den(488)
  den(543) = den(115)*den(149)
  den(544) = den(115)*den(448)
  den(545) = den(149)*den(445)
  den(546) = den(209)*den(445)
  den(547) = den(60)*den(448)
  den(548) = den(60)*den(209)
  den(549) = den(2)*den(106)
  den(550) = den(314)*den(549)
  den(551) = den(79)*den(106)
  den(552) = den(26)*den(551)
  den(553) = den(2)*den(79)
  den(554) = den(437)*den(553)
  den(555) = den(2)*den(111)
  den(556) = den(322)*den(555)
  den(557) = den(79)*den(111)
  den(558) = den(20)*den(557)
  den(559) = den(443)*den(553)
  den(560) = den(118)*den(145)
  den(561) = den(2)*den(329)
  den(562) = den(328)*den(561)
  den(563) = den(448)*den(553)
  den(564) = den(20)*den(118)
  den(565) = den(26)*den(118)
  den(566) = den(322)*den(561)
  den(567) = den(26)*den(322)
  den(568) = den(314)*den(561)
  den(569) = den(20)*den(314)
  den(570) = den(2)*den(101)
  den(571) = den(341)*den(570)
  den(572) = den(84)*den(101)
  den(573) = den(26)*den(572)
  den(574) = den(2)*den(84)
  den(575) = den(462)*den(574)
  den(576) = den(347)*den(570)
  den(577) = den(89)*den(101)
  den(578) = den(20)*den(577)
  den(579) = den(2)*den(89)
  den(580) = den(469)*den(579)
  den(581) = den(130)*den(471)
  den(582) = den(120)*den(145)
  den(583) = den(355)*den(570)
  den(584) = den(130)*den(462)
  den(585) = den(130)*den(469)
  den(586) = den(26)*den(120)
  den(587) = den(20)*den(120)
  den(588) = den(20)*den(462)
  den(589) = den(26)*den(469)
  den(590) = den(363)*den(555)
  den(591) = den(84)*den(111)
  den(592) = den(12)*den(591)
  den(593) = den(484)*den(574)
  den(594) = den(122)*den(139)
  den(595) = den(369)*den(561)
  den(596) = den(488)*den(574)
  den(597) = den(12)*den(122)
  den(598) = den(26)*den(122)
  den(599) = den(363)*den(561)
  den(600) = den(26)*den(363)
  den(601) = den(341)*den(561)
  den(602) = den(12)*den(341)
  den(603) = den(378)*den(549)
  den(604) = den(89)*den(106)
  den(605) = den(12)*den(604)
  den(606) = den(499)*den(579)
  den(607) = den(130)*den(501)
  den(608) = den(124)*den(139)
  den(609) = den(385)*den(549)
  den(610) = den(130)*den(437)
  den(611) = den(130)*den(499)
  den(612) = den(26)*den(124)
  den(613) = den(12)*den(124)
  den(614) = den(12)*den(437)
  den(615) = den(26)*den(499)
  den(616) = den(126)*den(133)
  den(617) = den(394)*den(561)
  den(618) = den(513)*den(579)
  den(619) = den(130)*den(515)
  den(620) = den(128)*den(133)
  den(621) = den(399)*den(555)
  den(622) = den(130)*den(137)
  den(623) = den(130)*den(513)
  den(624) = den(26)*den(399)
  den(625) = den(137)*den(561)
  den(626) = den(26)*den(513)
  den(627) = den(399)*den(561)
  den(628) = den(12)*den(126)
  den(629) = den(20)*den(126)
  den(630) = den(378)*den(561)
  den(631) = den(20)*den(378)
  den(632) = den(347)*den(561)
  den(633) = den(12)*den(347)
  den(634) = den(130)*den(443)
  den(635) = den(130)*den(484)
  den(636) = den(20)*den(128)
  den(637) = den(12)*den(128)
  den(638) = den(12)*den(443)
  den(639) = den(20)*den(484)
  den(640) = den(130)*den(143)
  den(641) = den(130)*den(488)
  den(642) = den(20)*den(385)
  den(643) = den(143)*den(561)
  den(644) = den(20)*den(488)
  den(645) = den(385)*den(561)
  den(646) = den(130)*den(149)
  den(647) = den(130)*den(448)
  den(648) = den(149)*den(561)
  den(649) = den(12)*den(448)
  den(650) = den(12)*den(355)
  den(651) = den(355)*den(561)
  den(652) = den(80)*den(481)
  den(653) = den(37)*den(557)
  den(654) = den(118)*den(217)
  den(655) = den(104)*den(324)
  den(656) = den(37)*den(118)
  den(657) = den(118)*den(192)
  den(658) = den(80)*den(104)
  den(659) = den(80)*den(192)
  den(660) = den(104)*den(314)
  den(661) = den(37)*den(314)
  den(662) = den(80)*den(496)
  den(663) = den(43)*den(551)
  den(664) = den(107)*den(324)
  den(665) = den(46)*den(551)
  den(666) = den(80)*den(107)
  den(667) = den(80)*den(437)
  den(668) = den(107)*den(314)
  den(669) = den(118)*den(234)
  den(670) = den(109)*den(316)
  den(671) = den(112)*den(316)
  den(672) = den(40)*den(557)
  den(673) = den(118)*den(165)
  den(674) = den(40)*den(118)
  den(675) = den(40)*den(314)
  den(676) = den(43)*den(118)
  den(677) = den(118)*den(200)
  den(678) = den(80)*den(109)
  den(679) = den(80)*den(200)
  den(680) = den(109)*den(322)
  den(681) = den(43)*den(322)
  den(682) = den(80)*den(112)
  den(683) = den(80)*den(443)
  den(684) = den(112)*den(322)
  den(685) = den(118)*den(173)
  den(686) = den(46)*den(118)
  den(687) = den(46)*den(322)
  den(688) = den(118)*den(180)
  den(689) = den(118)*den(209)
  den(690) = den(80)*den(448)
  den(691) = den(80)*den(209)
  den(692) = den(85)*den(439)
  den(693) = den(31)*den(591)
  den(694) = den(122)*den(167)
  den(695) = den(99)*den(365)
  den(696) = den(31)*den(122)
  den(697) = den(122)*den(161)
  den(698) = den(85)*den(99)
  den(699) = den(85)*den(161)
  den(700) = den(99)*den(341)
  den(701) = den(31)*den(341)
  den(702) = den(90)*den(431)
  den(703) = den(31)*den(604)
  den(704) = den(124)*den(167)
  den(705) = den(92)*den(431)
  den(706) = den(124)*den(161)
  den(707) = den(31)*den(124)
  den(708) = den(31)*den(437)
  den(709) = den(126)*den(157)
  den(710) = den(99)*den(380)
  den(711) = den(128)*den(157)
  den(712) = den(87)*den(439)
  den(713) = den(87)*den(161)
  den(714) = den(99)*den(165)
  den(715) = den(87)*den(99)
  den(716) = den(31)*den(126)
  den(717) = den(126)*den(171)
  den(718) = den(90)*den(99)
  den(719) = den(90)*den(171)
  den(720) = den(99)*den(347)
  den(721) = den(31)*den(347)
  den(722) = den(128)*den(171)
  den(723) = den(31)*den(128)
  den(724) = den(31)*den(443)
  den(725) = den(92)*den(171)
  den(726) = den(99)*den(173)
  den(727) = den(92)*den(99)
  den(728) = den(99)*den(180)
  den(729) = den(31)*den(448)
  den(730) = den(31)*den(355)
  den(731) = den(99)*den(355)
  den(732) = den(85)*den(464)
  den(733) = den(43)*den(572)
  den(734) = den(102)*den(365)
  den(735) = den(46)*den(572)
  den(736) = den(85)*den(102)
  den(737) = den(85)*den(462)
  den(738) = den(102)*den(341)
  den(739) = den(90)*den(456)
  den(740) = den(37)*den(577)
  den(741) = den(120)*den(217)
  den(742) = den(92)*den(456)
  den(743) = den(120)*den(192)
  den(744) = den(37)*den(120)
  den(745) = den(37)*den(462)
  den(746) = den(102)*den(380)
  den(747) = den(40)*den(577)
  den(748) = den(120)*den(234)
  den(749) = den(87)*den(464)
  den(750) = den(120)*den(165)
  den(751) = den(87)*den(462)
  den(752) = den(102)*den(165)
  den(753) = den(40)*den(462)
  den(754) = den(40)*den(120)
  den(755) = den(87)*den(102)
  den(756) = den(90)*den(102)
  den(757) = den(90)*den(469)
  den(758) = den(102)*den(347)
  den(759) = den(120)*den(200)
  den(760) = den(43)*den(120)
  den(761) = den(43)*den(469)
  den(762) = den(120)*den(173)
  den(763) = den(92)*den(469)
  den(764) = den(102)*den(173)
  den(765) = den(46)*den(469)
  den(766) = den(46)*den(120)
  den(767) = den(92)*den(102)
  den(768) = den(120)*den(180)
  den(769) = den(102)*den(180)
  den(770) = den(120)*den(209)
  den(771) = den(102)*den(355)
  den(772) = den(122)*den(198)
  den(773) = den(109)*den(343)
  den(774) = den(112)*den(343)
  den(775) = den(34)*den(591)
  den(776) = den(122)*den(196)
  den(777) = den(34)*den(122)
  den(778) = den(34)*den(341)
  den(779) = den(126)*den(188)
  den(780) = den(104)*den(349)
  den(781) = den(128)*den(188)
  den(782) = den(82)*den(481)
  den(783) = den(82)*den(192)
  den(784) = den(104)*den(196)
  den(785) = den(82)*den(104)
  den(786) = den(107)*den(349)
  den(787) = den(34)*den(604)
  den(788) = den(124)*den(198)
  den(789) = den(82)*den(496)
  den(790) = den(124)*den(196)
  den(791) = den(82)*den(437)
  den(792) = den(107)*den(196)
  den(793) = den(34)*den(437)
  den(794) = den(34)*den(124)
  den(795) = den(82)*den(107)
  den(796) = den(126)*den(204)
  den(797) = den(34)*den(126)
  den(798) = den(34)*den(347)
  den(799) = den(82)*den(200)
  den(800) = den(109)*den(204)
  den(801) = den(82)*den(109)
  den(802) = den(128)*den(204)
  den(803) = den(82)*den(443)
  den(804) = den(112)*den(204)
  den(805) = den(34)*den(443)
  den(806) = den(34)*den(128)
  den(807) = den(82)*den(112)
  den(808) = den(34)*den(448)
  den(809) = den(82)*den(448)
  den(810) = den(82)*den(209)
  den(811) = den(34)*den(355)
  den(812) = den(43)*den(122)
  den(813) = den(122)*den(236)
  den(814) = den(85)*den(109)
  den(815) = den(85)*den(236)
  den(816) = den(109)*den(363)
  den(817) = den(43)*den(363)
  den(818) = den(85)*den(112)
  den(819) = den(85)*den(484)
  den(820) = den(112)*den(363)
  den(821) = den(122)*den(221)
  den(822) = den(46)*den(122)
  den(823) = den(46)*den(363)
  den(824) = den(122)*den(226)
  den(825) = den(122)*den(243)
  den(826) = den(85)*den(488)
  den(827) = den(85)*den(243)
  den(828) = den(37)*den(126)
  den(829) = den(126)*den(219)
  den(830) = den(90)*den(104)
  den(831) = den(90)*den(219)
  den(832) = den(104)*den(378)
  den(833) = den(37)*den(378)
  den(834) = den(128)*den(219)
  den(835) = den(37)*den(128)
  den(836) = den(37)*den(484)
  den(837) = den(92)*den(219)
  den(838) = den(104)*den(221)
  den(839) = den(92)*den(104)
  den(840) = den(104)*den(226)
  den(841) = den(37)*den(488)
  den(842) = den(37)*den(385)
  den(843) = den(104)*den(385)
  den(844) = den(90)*den(107)
  den(845) = den(90)*den(499)
  den(846) = den(107)*den(378)
  den(847) = den(124)*den(236)
  den(848) = den(43)*den(124)
  den(849) = den(43)*den(499)
  den(850) = den(124)*den(221)
  den(851) = den(92)*den(499)
  den(852) = den(107)*den(221)
  den(853) = den(46)*den(499)
  den(854) = den(46)*den(124)
  den(855) = den(92)*den(107)
  den(856) = den(124)*den(226)
  den(857) = den(107)*den(226)
  den(858) = den(124)*den(243)
  den(859) = den(107)*den(385)
  den(860) = den(126)*den(238)
  den(861) = den(40)*den(126)
  den(862) = den(40)*den(378)
  den(863) = den(87)*den(236)
  den(864) = den(109)*den(238)
  den(865) = den(87)*den(109)
  den(866) = den(128)*den(238)
  den(867) = den(87)*den(484)
  den(868) = den(112)*den(238)
  den(869) = den(40)*den(484)
  den(870) = den(40)*den(128)
  den(871) = den(87)*den(112)
  den(872) = den(40)*den(488)
  den(873) = den(87)*den(488)
  den(874) = den(87)*den(243)
  den(875) = den(40)*den(385)
  den(876) = den(126)*den(254)
  den(877) = den(126)*den(259)
  den(878) = den(90)*den(513)
  den(879) = den(90)*den(259)
  den(880) = den(109)*den(254)
  den(881) = den(43)*den(513)
  den(882) = den(43)*den(399)
  den(883) = den(109)*den(399)
  den(884) = den(128)*den(254)
  den(885) = den(112)*den(254)
  den(886) = den(128)*den(259)
  den(887) = den(112)*den(399)
  den(888) = den(46)*den(513)
  den(889) = den(92)*den(513)
  den(890) = den(92)*den(259)
  den(891) = den(46)*den(399)

end subroutine born_denominators_init


! **********************************************************************
#ifdef PRECISION_dp
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu) &
    & bind(c,name="ol_f_amp2_pptttt_tttxtxggg_1")
#else
subroutine amp2(P_scatt, M2, I, MOM, nextcombs, extcombs, M2munu)
  use ol_tree_pptttt_tttxtxggg_1_/**/DREALKIND, only: &
    & ntry, nhel, Hel, M1helarr
#endif
! P_scatt(0:3,Npart) = incoming external momenta
! M2  = helicity-summed squared matrix element for top top anti-top anti-top glue glue glue -> 0
! I   = emitter, 0 means none (replace wave function I in the current crossing by the momentum MOM),
!       for I < 0 emitter for PowHeg B^mu,nu
! MOM = external "polarisation vector" for gluon emitter
! nextcombs is the length of the array extcombs
! The elements of the array extcombs specify for which external particle combinations
!   the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
!   i=j=0 -> 0 means no colour insertion.
! M2munu = Spin correlated born squared amplitude in PowHeg format B^mu,nu for emitter -I
! **********************************************************************
  use ol_parameters_decl_/**/REALKIND !, only: ci, parameters_status, ZERO, scalefactor, >masses<
  use ol_parameters_init_/**/REALKIND, only: ensure_mp_init
  use ol_init, only: tree_parameters_flush
  use ol_kinematics_/**/REALKIND, only: conv_mom_scatt2in, internal_momenta
  use ol_momenta_decl_/**/DREALKIND, only: momenta_nan_check
  use ol_momenta_decl_/**/REALKIND, only: Q
  use ol_data_types_/**/REALKIND
  use ol_helicity_bookkeeping_/**/REALKIND, only: &
    & helbookkeeping_wf, helsync, flip_phase
  use ol_helicity_init, only: helbookkeeping_flip, helsync_flip
  use ol_h_propagators_/**/REALKIND
  use ol_h_wavefunctions_/**/REALKIND
  use ol_wavefunctions_/**/REALKIND, only: wf_V_Std
  use ol_h_vertices_/**/REALKIND
  use ol_h_contractions_/**/REALKIND
  use ol_external_pptttt_tttxtxggg_1, only: &
    & external_perm_pptttt_tttxtxggg_1, &
    & external_perm_inv_pptttt_tttxtxggg_1, &
    & extcomb_perm_pptttt_tttxtxggg_1, &
    & average_factor_pptttt_tttxtxggg_1
  use ol_external_pptttt_tttxtxggg_1, only: &
    & H, hel_not_initialised, hel_init, POLSEL
  use ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND, only: &
    & colmat_not_initialised, colourmatrix_init
  use ol_forced_parameters_pptttt_tttxtxggg_1_/**/REALKIND, only: &
    & check_forced_parameters
  use ol_heltables_pptttt_tttxtxggg_1
  use ol_kinematics_/**/REALKIND, only: LC2Std_Rep_cmplx
  implicit none

  real(DREALKIND), intent(in)  :: P_scatt(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND),  intent(out) :: M2munu(4,4)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer,         intent(in)  :: nextcombs
  integer,         intent(in)  :: extcombs(nextcombs)

  integer           :: ReplacePol, JBmunu, extcombs_permuted(nextcombs), shift, k, r, m, n
  real(REALKIND)    :: P(0:3,7)
  real(REALKIND)    :: extmasses2(7)
  real(REALKIND)    :: M2add(0:30-1)
  complex(REALKIND) :: M2munuadd(2)
  complex(REALKIND) :: MOM_LC(4), M1(48), M1helarray(48,128)
  real(REALKIND)    :: P_scatt_intern(0:3,7)
  complex(REALKIND) :: epLC(1:4), epStd(1:4,2)
  real(REALKIND), save :: scalebackfactor, old_scalefactor = 0
  integer(intkind1) :: nsync

  ! type(wfun) :: ex1(h1), ex2(h2), ... ! external wave functions for h<n> helicities
  type(wfun) :: ex1(2), ex2(2), ex3(2), ex4(2), ex5(2), ex6(2), ex7(2)

  ! type(wfun) :: wf<h>(h,n), ... ! n wave functions with h helicity configurations
  type(wfun) :: wf4(4,31), wf8(8,130), wf16(16,338), wf32(32,18), wf128(128,786)

  type(polcont) :: A(128,786)
  complex(REALKIND) :: Aj(786)

  complex(REALKIND) :: omega(2) ! phases for helicity correlations

  call tree_parameters_flush()
  call ensure_mp_init()

  if (hel_not_initialised) call hel_init()
  if (colmat_not_initialised) call colourmatrix_init()
  if (factors_status /= parameters_status) then
    ! Note: if factors_init would only be called when parameters changed which are relevant for the factors,
    ! a different 'status' would have to be used, because check_forced_parameters should be called after every parameter change.
    call check_forced_parameters()
    call factors_init()
  end if

  if (momenta_nan_check(P_scatt) /= 0) then
    M2 = 0
    return
  end if

  ! Convert 2 -> n-2 PS-point to n -> 0 (so that P(1) + ... + P(n) = 0)
  extmasses2 = [ rMT2, rMT2, rMT2, rMT2, rZERO2, rZERO2, rZERO2 ]
  call conv_mom_scatt2in(P_scatt, extmasses2, P, &
    & external_perm_inv_pptttt_tttxtxggg_1,7)

  ! internal-propagator momenta in light-cone representation
  call internal_momenta(P,7)

  ! denominators
  call born_denominators_init()

  ReplacePol = 0
  JBmunu = 0
  if (I > 0) then
    ReplacePol = external_perm_pptttt_tttxtxggg_1(I)
  else if (I < 0) then
    JBmunu = external_perm_pptttt_tttxtxggg_1(-I)
  end if

  do k = 1, nextcombs
    extcombs_permuted(k) = extcomb_perm_pptttt_tttxtxggg_1(extcombs(k))
  end do

  if (heltables_not_init) call init_heltables()

  42 continue
  ! external WFs
  call pol_wf_Q(P(:,1), rMT, H1, ex1, POLSEL(1))
  call pol_wf_Q(P(:,2), rMT, H2, ex2, POLSEL(2))
  call pol_wf_A(P(:,3), rMT, H3, ex3, POLSEL(3))
  call pol_wf_A(P(:,4), rMT, H4, ex4, POLSEL(4))
  call pol_wf_V(P(:,5), rZERO, H5, ex5, POLSEL(5))
  call pol_wf_V(P(:,6), rZERO, H6, ex6, POLSEL(6))
  call pol_wf_V(P(:,7), rZERO, H7, ex7, POLSEL(7))


  if (ntry == 1) then
    shift = 1
    ! call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    ! call helbookkeeping_wf(H1, ex1, shift) ...

    if (any(POLSEL /= 0)) then

      call pol_wf_Q(P(:,1), rMT, H1, ex1, 0)
      call pol_wf_Q(P(:,2), rMT, H2, ex2, 0)
      call pol_wf_A(P(:,3), rMT, H3, ex3, 0)
      call pol_wf_A(P(:,4), rMT, H4, ex4, 0)
      call pol_wf_V(P(:,5), rZERO, H5, ex5, 0)
      call pol_wf_V(P(:,6), rZERO, H6, ex6, 0)
      call pol_wf_V(P(:,7), rZERO, H7, ex7, 0)

    end if

    call helbookkeeping_flip(H1, 1, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H1, ex1, shift)
    call helbookkeeping_flip(H2, 2, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H2, ex2, shift)
    call helbookkeeping_flip(H3, 3, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H3, ex3, shift)
    call helbookkeeping_flip(H4, 4, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H4, ex4, shift)
    call helbookkeeping_flip(H5, 5, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H5, ex5, shift)
    call helbookkeeping_flip(H6, 6, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H6, ex6, shift)
    call helbookkeeping_flip(H7, 7, shift, eflip, exthel, firstpol)
    call helbookkeeping_wf(H7, ex7, shift)

  end if

  ! internal WFs
  ! e.g. call vert_VQ_A(ntry, ex3, ex1, wf1, n1, t1) ...
  call vert_QA_V(ntry, ex1, ex3, wf4(:,1), n3(:,1), t3x4(:,:,1))
  call vert_QA_V(ntry, ex2, ex4, wf4(:,2), n3(:,2), t3x4(:,:,2))
  call vert_UV_W(ntry, ex5, Q(:,16), ex6, Q(:,32), wf4(:,3), n3(:,3), t3x4(:,:,3))
  call vert_GGG_G(ntry, wf4(:,1), wf4(:,2), ex7, wf32(:,1), n4(:,1), t4x32(:,:,1))
  call vert_GGG_G(ntry, wf4(:,2), ex7, wf4(:,1), wf32(:,2), n4(:,2), t4x32(:,:,2))
  call vert_GGG_G(ntry, ex7, wf4(:,1), wf4(:,2), wf32(:,3), n4(:,3), t4x32(:,:,3))
  call vert_UV_W(ntry, ex5, Q(:,16), ex7, Q(:,64), wf4(:,4), n3(:,4), t3x4(:,:,4))
  call vert_GGG_G(ntry, wf4(:,1), wf4(:,2), ex6, wf32(:,4), n4(:,4), t4x32(:,:,4))
  call vert_GGG_G(ntry, wf4(:,2), ex6, wf4(:,1), wf32(:,5), n4(:,5), t4x32(:,:,5))
  call vert_GGG_G(ntry, ex6, wf4(:,1), wf4(:,2), wf32(:,6), n4(:,6), t4x32(:,:,6))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), ex5, Q(:,16), wf8(:,1), n3(:,5), t3x8(:,:,1))
  call vert_GGG_G(ntry, wf4(:,2), ex6, ex7, wf16(:,1), n4(:,7), t4x16(:,:,1))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,2), wf16(:,2), n4(:,8), t4x16(:,:,2))
  call vert_GGG_G(ntry, ex7, wf4(:,2), ex6, wf16(:,3), n4(:,9), t4x16(:,:,3))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), ex5, Q(:,16), wf8(:,2), n3(:,6), t3x8(:,:,2))
  call vert_GGG_G(ntry, wf4(:,1), ex6, ex7, wf16(:,4), n4(:,10), t4x16(:,:,4))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,1), wf16(:,5), n4(:,11), t4x16(:,:,5))
  call vert_GGG_G(ntry, ex7, wf4(:,1), ex6, wf16(:,6), n4(:,12), t4x16(:,:,6))
  call vert_UV_W(ntry, ex6, Q(:,32), ex7, Q(:,64), wf4(:,5), n3(:,7), t3x4(:,:,5))
  call vert_GGG_G(ntry, wf4(:,1), wf4(:,2), ex5, wf32(:,7), n4(:,13), t4x32(:,:,7))
  call vert_GGG_G(ntry, wf4(:,2), ex5, wf4(:,1), wf32(:,8), n4(:,14), t4x32(:,:,8))
  call vert_GGG_G(ntry, ex5, wf4(:,1), wf4(:,2), wf32(:,9), n4(:,15), t4x32(:,:,9))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), ex6, Q(:,32), wf8(:,3), n3(:,8), t3x8(:,:,3))
  call vert_GGG_G(ntry, wf4(:,2), ex5, ex7, wf16(:,7), n4(:,16), t4x16(:,:,7))
  call vert_GGG_G(ntry, ex5, ex7, wf4(:,2), wf16(:,8), n4(:,17), t4x16(:,:,8))
  call vert_GGG_G(ntry, ex7, wf4(:,2), ex5, wf16(:,9), n4(:,18), t4x16(:,:,9))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), ex6, Q(:,32), wf8(:,4), n3(:,9), t3x8(:,:,4))
  call vert_GGG_G(ntry, wf4(:,1), ex5, ex7, wf16(:,10), n4(:,19), t4x16(:,:,10))
  call vert_GGG_G(ntry, ex5, ex7, wf4(:,1), wf16(:,11), n4(:,20), t4x16(:,:,11))
  call vert_GGG_G(ntry, ex7, wf4(:,1), ex5, wf16(:,12), n4(:,21), t4x16(:,:,12))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), ex7, Q(:,64), wf8(:,5), n3(:,10), t3x8(:,:,5))
  call vert_GGG_G(ntry, wf4(:,2), ex5, ex6, wf16(:,13), n4(:,22), t4x16(:,:,13))
  call vert_GGG_G(ntry, ex5, ex6, wf4(:,2), wf16(:,14), n4(:,23), t4x16(:,:,14))
  call vert_GGG_G(ntry, ex6, wf4(:,2), ex5, wf16(:,15), n4(:,24), t4x16(:,:,15))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), ex7, Q(:,64), wf8(:,6), n3(:,11), t3x8(:,:,6))
  call vert_GGG_G(ntry, wf4(:,1), ex5, ex6, wf16(:,16), n4(:,25), t4x16(:,:,16))
  call vert_GGG_G(ntry, ex5, ex6, wf4(:,1), wf16(:,17), n4(:,26), t4x16(:,:,17))
  call vert_GGG_G(ntry, ex6, wf4(:,1), ex5, wf16(:,18), n4(:,27), t4x16(:,:,18))
  call vert_GGG_G(ntry, ex5, ex6, ex7, wf8(:,7), n4(:,28), t4x8(:,:,1))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), wf4(:,2), Q(:,10), wf16(:,19), n3(:,12), t3x16(:,:,1))
  call vert_GGG_G(ntry, ex6, ex7, ex5, wf8(:,8), n4(:,29), t4x8(:,:,2))
  call vert_GGG_G(ntry, ex7, ex5, ex6, wf8(:,9), n4(:,30), t4x8(:,:,3))
  call vert_VQ_A(ntry, ex5, ex2, wf4(:,6), n3(:,13), t3x4(:,:,6))
  call prop_Q_A(ntry, wf4(:,6), Q(:,18), MT, 1_intkind1, wf4(:,7), n2(1))
  call vert_QA_V(ntry, wf4(:,7), ex4, wf8(:,10), n3(:,14), t3x8(:,:,7))
  call vert_AV_Q(ntry, ex4, ex5, wf4(:,8), n3(:,15), t3x4(:,:,7))
  call prop_A_Q(ntry, wf4(:,8), Q(:,24), MT, 1_intkind1, wf4(:,9), n2(2))
  call vert_QA_V(ntry, ex2, wf4(:,9), wf8(:,11), n3(:,16), t3x8(:,:,8))
  call vert_VQ_A(ntry, ex6, ex2, wf4(:,10), n3(:,17), t3x4(:,:,8))
  call prop_Q_A(ntry, wf4(:,10), Q(:,34), MT, 1_intkind1, wf4(:,11), n2(3))
  call vert_QA_V(ntry, wf4(:,11), ex4, wf8(:,12), n3(:,18), t3x8(:,:,9))
  call vert_AV_Q(ntry, ex4, ex6, wf4(:,12), n3(:,19), t3x4(:,:,9))
  call prop_A_Q(ntry, wf4(:,12), Q(:,40), MT, 1_intkind1, wf4(:,13), n2(4))
  call vert_QA_V(ntry, ex2, wf4(:,13), wf8(:,13), n3(:,20), t3x8(:,:,10))
  call vert_VQ_A(ntry, ex7, ex2, wf4(:,14), n3(:,21), t3x4(:,:,10))
  call prop_Q_A(ntry, wf4(:,14), Q(:,66), MT, 1_intkind1, wf4(:,15), n2(5))
  call vert_QA_V(ntry, wf4(:,15), ex4, wf8(:,14), n3(:,22), t3x8(:,:,11))
  call vert_AV_Q(ntry, ex4, ex7, wf4(:,16), n3(:,23), t3x4(:,:,11))
  call prop_A_Q(ntry, wf4(:,16), Q(:,72), MT, 1_intkind1, wf4(:,17), n2(6))
  call vert_QA_V(ntry, ex2, wf4(:,17), wf8(:,15), n3(:,24), t3x8(:,:,12))
  call vert_VQ_A(ntry, wf4(:,1), ex2, wf8(:,16), n3(:,25), t3x8(:,:,13))
  call vert_AV_Q(ntry, ex4, wf8(:,7), wf16(:,20), n3(:,26), t3x16(:,:,2))
  call prop_Q_A(ntry, wf8(:,16), Q(:,7), MT, 1_intkind1, wf8(:,17), n2(7))
  call vert_AV_Q(ntry, ex4, wf8(:,8), wf16(:,21), n3(:,27), t3x16(:,:,3))
  call vert_AV_Q(ntry, ex4, wf8(:,9), wf16(:,22), n3(:,28), t3x16(:,:,4))
  call vert_VQ_A(ntry, wf8(:,7), ex2, wf16(:,23), n3(:,29), t3x16(:,:,5))
  call vert_AV_Q(ntry, ex4, wf4(:,1), wf8(:,18), n3(:,30), t3x8(:,:,14))
  call prop_Q_A(ntry, wf16(:,23), Q(:,114), MT, 1_intkind1, wf16(:,24), n2(8))
  call vert_VQ_A(ntry, wf8(:,8), ex2, wf16(:,25), n3(:,31), t3x16(:,:,6))
  call prop_Q_A(ntry, wf16(:,25), Q(:,114), MT, 1_intkind1, wf16(:,26), n2(9))
  call vert_VQ_A(ntry, wf8(:,9), ex2, wf16(:,27), n3(:,32), t3x16(:,:,7))
  call prop_Q_A(ntry, wf16(:,27), Q(:,114), MT, 1_intkind1, wf16(:,28), n2(10))
  call vert_QA_V(ntry, ex1, ex4, wf4(:,18), n3(:,33), t3x4(:,:,12))
  call vert_QA_V(ntry, ex2, ex3, wf4(:,19), n3(:,34), t3x4(:,:,13))
  call vert_GGG_G(ntry, wf4(:,19), wf4(:,18), ex7, wf32(:,10), n4(:,31), t4x32(:,:,10))
  call vert_GGG_G(ntry, wf4(:,18), ex7, wf4(:,19), wf32(:,11), n4(:,32), t4x32(:,:,11))
  call vert_GGG_G(ntry, ex7, wf4(:,19), wf4(:,18), wf32(:,12), n4(:,33), t4x32(:,:,12))
  call vert_GGG_G(ntry, wf4(:,19), wf4(:,18), ex6, wf32(:,13), n4(:,34), t4x32(:,:,13))
  call vert_GGG_G(ntry, wf4(:,18), ex6, wf4(:,19), wf32(:,14), n4(:,35), t4x32(:,:,14))
  call vert_GGG_G(ntry, ex6, wf4(:,19), wf4(:,18), wf32(:,15), n4(:,36), t4x32(:,:,15))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), ex5, Q(:,16), wf8(:,19), n3(:,35), t3x8(:,:,15))
  call vert_GGG_G(ntry, wf4(:,19), ex6, ex7, wf16(:,29), n4(:,37), t4x16(:,:,19))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,19), wf16(:,30), n4(:,38), t4x16(:,:,20))
  call vert_GGG_G(ntry, ex7, wf4(:,19), ex6, wf16(:,31), n4(:,39), t4x16(:,:,21))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), ex5, Q(:,16), wf8(:,20), n3(:,36), t3x8(:,:,16))
  call vert_GGG_G(ntry, wf4(:,18), ex6, ex7, wf16(:,32), n4(:,40), t4x16(:,:,22))
  call vert_GGG_G(ntry, ex6, ex7, wf4(:,18), wf16(:,33), n4(:,41), t4x16(:,:,23))
  call vert_GGG_G(ntry, ex7, wf4(:,18), ex6, wf16(:,34), n4(:,42), t4x16(:,:,24))
  call vert_GGG_G(ntry, wf4(:,19), wf4(:,18), ex5, wf32(:,16), n4(:,43), t4x32(:,:,16))
  call vert_GGG_G(ntry, wf4(:,18), ex5, wf4(:,19), wf32(:,17), n4(:,44), t4x32(:,:,17))
  call vert_GGG_G(ntry, ex5, wf4(:,19), wf4(:,18), wf32(:,18), n4(:,45), t4x32(:,:,18))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), ex6, Q(:,32), wf8(:,21), n3(:,37), t3x8(:,:,17))
  call vert_GGG_G(ntry, wf4(:,19), ex5, ex7, wf16(:,35), n4(:,46), t4x16(:,:,25))
  call vert_GGG_G(ntry, ex5, ex7, wf4(:,19), wf16(:,36), n4(:,47), t4x16(:,:,26))
  call vert_GGG_G(ntry, ex7, wf4(:,19), ex5, wf16(:,37), n4(:,48), t4x16(:,:,27))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), ex6, Q(:,32), wf8(:,22), n3(:,38), t3x8(:,:,18))
  call vert_GGG_G(ntry, wf4(:,18), ex5, ex7, wf16(:,38), n4(:,49), t4x16(:,:,28))
  call vert_GGG_G(ntry, ex5, ex7, wf4(:,18), wf16(:,39), n4(:,50), t4x16(:,:,29))
  call vert_GGG_G(ntry, ex7, wf4(:,18), ex5, wf16(:,40), n4(:,51), t4x16(:,:,30))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), ex7, Q(:,64), wf8(:,23), n3(:,39), t3x8(:,:,19))
  call vert_GGG_G(ntry, wf4(:,19), ex5, ex6, wf16(:,41), n4(:,52), t4x16(:,:,31))
  call vert_GGG_G(ntry, ex5, ex6, wf4(:,19), wf16(:,42), n4(:,53), t4x16(:,:,32))
  call vert_GGG_G(ntry, ex6, wf4(:,19), ex5, wf16(:,43), n4(:,54), t4x16(:,:,33))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), ex7, Q(:,64), wf8(:,24), n3(:,40), t3x8(:,:,20))
  call vert_GGG_G(ntry, wf4(:,18), ex5, ex6, wf16(:,44), n4(:,55), t4x16(:,:,34))
  call vert_GGG_G(ntry, ex5, ex6, wf4(:,18), wf16(:,45), n4(:,56), t4x16(:,:,35))
  call vert_GGG_G(ntry, ex6, wf4(:,18), ex5, wf16(:,46), n4(:,57), t4x16(:,:,36))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), wf4(:,18), Q(:,9), wf16(:,47), n3(:,41), t3x16(:,:,8))
  call vert_VQ_A(ntry, ex5, ex1, wf4(:,20), n3(:,42), t3x4(:,:,14))
  call prop_Q_A(ntry, wf4(:,20), Q(:,17), MT, 1_intkind1, wf4(:,21), n2(11))
  call vert_QA_V(ntry, wf4(:,21), ex4, wf8(:,25), n3(:,43), t3x8(:,:,21))
  call vert_QA_V(ntry, ex1, wf4(:,9), wf8(:,26), n3(:,44), t3x8(:,:,22))
  call vert_VQ_A(ntry, ex6, ex1, wf4(:,22), n3(:,45), t3x4(:,:,15))
  call prop_Q_A(ntry, wf4(:,22), Q(:,33), MT, 1_intkind1, wf4(:,23), n2(12))
  call vert_QA_V(ntry, wf4(:,23), ex4, wf8(:,27), n3(:,46), t3x8(:,:,23))
  call vert_QA_V(ntry, ex1, wf4(:,13), wf8(:,28), n3(:,47), t3x8(:,:,24))
  call vert_VQ_A(ntry, ex7, ex1, wf4(:,24), n3(:,48), t3x4(:,:,16))
  call prop_Q_A(ntry, wf4(:,24), Q(:,65), MT, 1_intkind1, wf4(:,25), n2(13))
  call vert_QA_V(ntry, wf4(:,25), ex4, wf8(:,29), n3(:,49), t3x8(:,:,25))
  call vert_QA_V(ntry, ex1, wf4(:,17), wf8(:,30), n3(:,50), t3x8(:,:,26))
  call vert_VQ_A(ntry, wf4(:,19), ex1, wf8(:,31), n3(:,51), t3x8(:,:,27))
  call prop_Q_A(ntry, wf8(:,31), Q(:,7), MT, 1_intkind1, wf8(:,32), n2(14))
  call vert_VQ_A(ntry, wf8(:,7), ex1, wf16(:,48), n3(:,52), t3x16(:,:,9))
  call vert_AV_Q(ntry, ex4, wf4(:,19), wf8(:,33), n3(:,53), t3x8(:,:,28))
  call prop_Q_A(ntry, wf16(:,48), Q(:,113), MT, 1_intkind1, wf16(:,49), n2(15))
  call vert_VQ_A(ntry, wf8(:,8), ex1, wf16(:,50), n3(:,54), t3x16(:,:,10))
  call prop_Q_A(ntry, wf16(:,50), Q(:,113), MT, 1_intkind1, wf16(:,51), n2(16))
  call vert_VQ_A(ntry, wf8(:,9), ex1, wf16(:,52), n3(:,55), t3x16(:,:,11))
  call prop_Q_A(ntry, wf16(:,52), Q(:,113), MT, 1_intkind1, wf16(:,53), n2(17))
  call vert_QA_V(ntry, wf4(:,7), ex3, wf8(:,34), n3(:,56), t3x8(:,:,29))
  call vert_AV_Q(ntry, ex3, ex5, wf4(:,26), n3(:,57), t3x4(:,:,17))
  call prop_A_Q(ntry, wf4(:,26), Q(:,20), MT, 1_intkind1, wf4(:,27), n2(18))
  call vert_QA_V(ntry, ex2, wf4(:,27), wf8(:,35), n3(:,58), t3x8(:,:,30))
  call vert_QA_V(ntry, wf4(:,11), ex3, wf8(:,36), n3(:,59), t3x8(:,:,31))
  call vert_AV_Q(ntry, ex3, ex6, wf4(:,28), n3(:,60), t3x4(:,:,18))
  call prop_A_Q(ntry, wf4(:,28), Q(:,36), MT, 1_intkind1, wf4(:,29), n2(19))
  call vert_QA_V(ntry, ex2, wf4(:,29), wf8(:,37), n3(:,61), t3x8(:,:,32))
  call vert_QA_V(ntry, wf4(:,15), ex3, wf8(:,38), n3(:,62), t3x8(:,:,33))
  call vert_AV_Q(ntry, ex3, ex7, wf4(:,30), n3(:,63), t3x4(:,:,19))
  call prop_A_Q(ntry, wf4(:,30), Q(:,68), MT, 1_intkind1, wf4(:,31), n2(20))
  call vert_QA_V(ntry, ex2, wf4(:,31), wf8(:,39), n3(:,64), t3x8(:,:,34))
  call vert_VQ_A(ntry, wf4(:,18), ex2, wf8(:,40), n3(:,65), t3x8(:,:,35))
  call vert_AV_Q(ntry, ex3, wf8(:,7), wf16(:,54), n3(:,66), t3x16(:,:,12))
  call prop_Q_A(ntry, wf8(:,40), Q(:,11), MT, 1_intkind1, wf8(:,41), n2(21))
  call vert_AV_Q(ntry, ex3, wf8(:,8), wf16(:,55), n3(:,67), t3x16(:,:,13))
  call vert_AV_Q(ntry, ex3, wf8(:,9), wf16(:,56), n3(:,68), t3x16(:,:,14))
  call vert_AV_Q(ntry, ex3, wf4(:,18), wf8(:,42), n3(:,69), t3x8(:,:,36))
  call vert_QA_V(ntry, wf4(:,21), ex3, wf8(:,43), n3(:,70), t3x8(:,:,37))
  call vert_QA_V(ntry, ex1, wf4(:,27), wf8(:,44), n3(:,71), t3x8(:,:,38))
  call vert_QA_V(ntry, wf4(:,23), ex3, wf8(:,45), n3(:,72), t3x8(:,:,39))
  call vert_QA_V(ntry, ex1, wf4(:,29), wf8(:,46), n3(:,73), t3x8(:,:,40))
  call vert_QA_V(ntry, wf4(:,25), ex3, wf8(:,47), n3(:,74), t3x8(:,:,41))
  call vert_QA_V(ntry, ex1, wf4(:,31), wf8(:,48), n3(:,75), t3x8(:,:,42))
  call vert_VQ_A(ntry, wf4(:,2), ex1, wf8(:,49), n3(:,76), t3x8(:,:,43))
  call prop_Q_A(ntry, wf8(:,49), Q(:,11), MT, 1_intkind1, wf8(:,50), n2(22))
  call vert_AV_Q(ntry, ex3, wf4(:,2), wf8(:,51), n3(:,77), t3x8(:,:,44))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), wf4(:,3), Q(:,48), wf16(:,57), n3(:,78), t3x16(:,:,15))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), wf4(:,3), Q(:,48), wf16(:,58), n3(:,79), t3x16(:,:,16))
  call vert_UV_W(ntry, wf4(:,3), Q(:,48), ex7, Q(:,64), wf8(:,52), n3(:,80), t3x8(:,:,45))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), wf4(:,4), Q(:,80), wf16(:,59), n3(:,81), t3x16(:,:,17))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), wf4(:,4), Q(:,80), wf16(:,60), n3(:,82), t3x16(:,:,18))
  call vert_UV_W(ntry, ex6, Q(:,32), wf4(:,4), Q(:,80), wf8(:,53), n3(:,83), t3x8(:,:,46))
  call vert_UV_W(ntry, wf4(:,2), Q(:,10), wf4(:,5), Q(:,96), wf16(:,61), n3(:,84), t3x16(:,:,19))
  call vert_UV_W(ntry, wf4(:,1), Q(:,5), wf4(:,5), Q(:,96), wf16(:,62), n3(:,85), t3x16(:,:,20))
  call vert_UV_W(ntry, ex5, Q(:,16), wf4(:,5), Q(:,96), wf8(:,54), n3(:,86), t3x8(:,:,47))
  call vert_UV_W(ntry, wf8(:,1), Q(:,21), ex7, Q(:,64), wf16(:,63), n3(:,87), t3x16(:,:,21))
  call vert_UV_W(ntry, wf8(:,1), Q(:,21), ex6, Q(:,32), wf16(:,64), n3(:,88), t3x16(:,:,22))
  call vert_UV_W(ntry, wf8(:,2), Q(:,26), ex7, Q(:,64), wf16(:,65), n3(:,89), t3x16(:,:,23))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,3), Q(:,37), wf16(:,66), n3(:,90), t3x16(:,:,24))
  call vert_UV_W(ntry, wf8(:,2), Q(:,26), ex6, Q(:,32), wf16(:,67), n3(:,91), t3x16(:,:,25))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,4), Q(:,42), wf16(:,68), n3(:,92), t3x16(:,:,26))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,13), wf16(:,69), n3(:,93), t3x16(:,:,27))
  call vert_VQ_A(ntry, ex7, wf4(:,7), wf8(:,55), n3(:,94), t3x8(:,:,48))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,1), wf16(:,70), n3(:,95), t3x16(:,:,28))
  call prop_Q_A(ntry, wf8(:,55), Q(:,82), MT, 1_intkind1, wf8(:,56), n2(23))
  call vert_AV_Q(ntry, wf4(:,13), ex7, wf8(:,57), n3(:,96), t3x8(:,:,49))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,7), wf16(:,71), n3(:,97), t3x16(:,:,29))
  call prop_A_Q(ntry, wf8(:,57), Q(:,104), MT, 1_intkind1, wf8(:,58), n2(24))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,17), wf16(:,72), n3(:,98), t3x16(:,:,30))
  call vert_VQ_A(ntry, ex6, wf4(:,7), wf8(:,59), n3(:,99), t3x8(:,:,50))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,1), wf16(:,73), n3(:,100), t3x16(:,:,31))
  call prop_Q_A(ntry, wf8(:,59), Q(:,50), MT, 1_intkind1, wf8(:,60), n2(25))
  call vert_AV_Q(ntry, wf4(:,17), ex6, wf8(:,61), n3(:,101), t3x8(:,:,51))
  call prop_A_Q(ntry, wf8(:,61), Q(:,104), MT, 1_intkind1, wf8(:,62), n2(26))
  call vert_VQ_A(ntry, wf4(:,5), wf4(:,7), wf16(:,74), n3(:,102), t3x16(:,:,32))
  call prop_A_Q(ntry, wf8(:,18), Q(:,13), MT, 1_intkind1, wf8(:,63), n2(27))
  call vert_AV_Q(ntry, ex4, wf4(:,5), wf8(:,64), n3(:,103), t3x8(:,:,52))
  call prop_A_Q(ntry, wf8(:,64), Q(:,104), MT, 1_intkind1, wf8(:,65), n2(28))
  call vert_AV_Q(ntry, wf8(:,63), ex7, wf16(:,75), n3(:,104), t3x16(:,:,33))
  call vert_AV_Q(ntry, wf8(:,63), ex6, wf16(:,76), n3(:,105), t3x16(:,:,34))
  call vert_UV_W(ntry, wf8(:,10), Q(:,26), ex7, Q(:,64), wf16(:,77), n3(:,106), t3x16(:,:,35))
  call vert_AV_Q(ntry, ex4, wf8(:,3), wf16(:,78), n3(:,107), t3x16(:,:,36))
  call vert_UV_W(ntry, wf8(:,10), Q(:,26), ex6, Q(:,32), wf16(:,79), n3(:,108), t3x16(:,:,37))
  call vert_QA_V(ntry, wf8(:,60), ex4, wf16(:,80), n3(:,109), t3x16(:,:,38))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,9), wf16(:,81), n3(:,110), t3x16(:,:,39))
  call vert_VQ_A(ntry, ex7, wf4(:,11), wf8(:,66), n3(:,111), t3x8(:,:,53))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,1), wf16(:,82), n3(:,112), t3x16(:,:,40))
  call prop_Q_A(ntry, wf8(:,66), Q(:,98), MT, 1_intkind1, wf8(:,67), n2(29))
  call vert_AV_Q(ntry, wf4(:,9), ex7, wf8(:,68), n3(:,113), t3x8(:,:,54))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,11), wf16(:,83), n3(:,114), t3x16(:,:,41))
  call prop_A_Q(ntry, wf8(:,68), Q(:,88), MT, 1_intkind1, wf8(:,69), n2(30))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,9), wf16(:,84), n3(:,115), t3x16(:,:,42))
  call vert_VQ_A(ntry, ex6, wf4(:,15), wf8(:,70), n3(:,116), t3x8(:,:,55))
  call prop_Q_A(ntry, wf8(:,70), Q(:,98), MT, 1_intkind1, wf8(:,71), n2(31))
  call vert_AV_Q(ntry, wf4(:,9), ex6, wf8(:,72), n3(:,117), t3x8(:,:,56))
  call vert_VQ_A(ntry, wf4(:,1), wf4(:,15), wf16(:,85), n3(:,118), t3x16(:,:,43))
  call prop_A_Q(ntry, wf8(:,72), Q(:,56), MT, 1_intkind1, wf8(:,73), n2(32))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,5), wf16(:,86), n3(:,119), t3x16(:,:,44))
  call vert_VQ_A(ntry, wf4(:,5), ex2, wf8(:,74), n3(:,120), t3x8(:,:,57))
  call prop_Q_A(ntry, wf8(:,74), Q(:,98), MT, 1_intkind1, wf8(:,75), n2(33))
  call vert_VQ_A(ntry, ex6, wf8(:,17), wf16(:,87), n3(:,121), t3x16(:,:,45))
  call vert_VQ_A(ntry, ex7, wf8(:,17), wf16(:,88), n3(:,122), t3x16(:,:,46))
  call vert_UV_W(ntry, wf8(:,11), Q(:,26), ex7, Q(:,64), wf16(:,89), n3(:,123), t3x16(:,:,47))
  call vert_VQ_A(ntry, wf8(:,3), ex2, wf16(:,90), n3(:,124), t3x16(:,:,48))
  call vert_UV_W(ntry, wf8(:,11), Q(:,26), ex6, Q(:,32), wf16(:,91), n3(:,125), t3x16(:,:,49))
  call vert_QA_V(ntry, ex2, wf8(:,73), wf16(:,92), n3(:,126), t3x16(:,:,50))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,17), wf16(:,93), n3(:,127), t3x16(:,:,51))
  call vert_VQ_A(ntry, ex5, wf4(:,11), wf8(:,76), n3(:,128), t3x8(:,:,58))
  call prop_Q_A(ntry, wf8(:,76), Q(:,50), MT, 1_intkind1, wf8(:,77), n2(34))
  call vert_AV_Q(ntry, wf4(:,17), ex5, wf8(:,78), n3(:,129), t3x8(:,:,59))
  call prop_A_Q(ntry, wf8(:,78), Q(:,88), MT, 1_intkind1, wf8(:,79), n2(35))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,11), wf16(:,94), n3(:,130), t3x16(:,:,52))
  call vert_AV_Q(ntry, ex4, wf4(:,4), wf8(:,80), n3(:,131), t3x8(:,:,60))
  call prop_A_Q(ntry, wf8(:,80), Q(:,88), MT, 1_intkind1, wf8(:,81), n2(36))
  call vert_AV_Q(ntry, wf8(:,63), ex5, wf16(:,95), n3(:,132), t3x16(:,:,53))
  call vert_UV_W(ntry, wf8(:,12), Q(:,42), ex7, Q(:,64), wf16(:,96), n3(:,133), t3x16(:,:,54))
  call vert_AV_Q(ntry, ex4, wf8(:,1), wf16(:,97), n3(:,134), t3x16(:,:,55))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,12), Q(:,42), wf16(:,98), n3(:,135), t3x16(:,:,56))
  call vert_QA_V(ntry, wf8(:,77), ex4, wf16(:,99), n3(:,136), t3x16(:,:,57))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,13), wf16(:,100), n3(:,137), t3x16(:,:,58))
  call vert_VQ_A(ntry, ex5, wf4(:,15), wf8(:,82), n3(:,138), t3x8(:,:,61))
  call prop_Q_A(ntry, wf8(:,82), Q(:,82), MT, 1_intkind1, wf8(:,83), n2(37))
  call vert_AV_Q(ntry, wf4(:,13), ex5, wf8(:,84), n3(:,139), t3x8(:,:,62))
  call prop_A_Q(ntry, wf8(:,84), Q(:,56), MT, 1_intkind1, wf8(:,85), n2(38))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,4), wf16(:,101), n3(:,140), t3x16(:,:,59))
  call vert_VQ_A(ntry, wf4(:,4), ex2, wf8(:,86), n3(:,141), t3x8(:,:,63))
  call prop_Q_A(ntry, wf8(:,86), Q(:,82), MT, 1_intkind1, wf8(:,87), n2(39))
  call vert_VQ_A(ntry, ex5, wf8(:,17), wf16(:,102), n3(:,142), t3x16(:,:,60))
  call vert_UV_W(ntry, wf8(:,13), Q(:,42), ex7, Q(:,64), wf16(:,103), n3(:,143), t3x16(:,:,61))
  call vert_VQ_A(ntry, wf8(:,1), ex2, wf16(:,104), n3(:,144), t3x16(:,:,62))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,13), Q(:,42), wf16(:,105), n3(:,145), t3x16(:,:,63))
  call vert_QA_V(ntry, ex2, wf8(:,85), wf16(:,106), n3(:,146), t3x16(:,:,64))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,15), wf16(:,107), n3(:,147), t3x16(:,:,65))
  call vert_AV_Q(ntry, ex4, wf4(:,3), wf8(:,88), n3(:,148), t3x8(:,:,64))
  call prop_A_Q(ntry, wf8(:,88), Q(:,56), MT, 1_intkind1, wf8(:,89), n2(40))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,3), wf16(:,108), n3(:,149), t3x16(:,:,66))
  call vert_VQ_A(ntry, wf4(:,3), ex2, wf8(:,90), n3(:,150), t3x8(:,:,65))
  call prop_Q_A(ntry, wf8(:,90), Q(:,50), MT, 1_intkind1, wf8(:,91), n2(41))
  call vert_QA_V(ntry, wf8(:,17), ex4, wf16(:,109), n3(:,151), t3x16(:,:,67))
  call vert_QA_V(ntry, ex2, wf8(:,63), wf16(:,110), n3(:,152), t3x16(:,:,68))
  call vert_VQ_A(ntry, ex7, wf8(:,91), wf16(:,111), n3(:,153), t3x16(:,:,69))
  call vert_QA_V(ntry, wf8(:,91), ex4, wf16(:,112), n3(:,154), t3x16(:,:,70))
  call vert_QA_V(ntry, ex2, wf8(:,89), wf16(:,113), n3(:,155), t3x16(:,:,71))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,14), Q(:,74), wf16(:,114), n3(:,156), t3x16(:,:,72))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,14), Q(:,74), wf16(:,115), n3(:,157), t3x16(:,:,73))
  call vert_QA_V(ntry, wf8(:,83), ex4, wf16(:,116), n3(:,158), t3x16(:,:,74))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,15), Q(:,74), wf16(:,117), n3(:,159), t3x16(:,:,75))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,15), Q(:,74), wf16(:,118), n3(:,160), t3x16(:,:,76))
  call vert_QA_V(ntry, ex2, wf8(:,79), wf16(:,119), n3(:,161), t3x16(:,:,77))
  call vert_VQ_A(ntry, ex6, wf8(:,87), wf16(:,120), n3(:,162), t3x16(:,:,78))
  call vert_QA_V(ntry, wf8(:,87), ex4, wf16(:,121), n3(:,163), t3x16(:,:,79))
  call vert_QA_V(ntry, ex2, wf8(:,81), wf16(:,122), n3(:,164), t3x16(:,:,80))
  call vert_VQ_A(ntry, ex5, wf8(:,75), wf16(:,123), n3(:,165), t3x16(:,:,81))
  call vert_QA_V(ntry, ex2, wf8(:,65), wf16(:,124), n3(:,166), t3x16(:,:,82))
  call vert_QA_V(ntry, wf8(:,75), ex4, wf16(:,125), n3(:,167), t3x16(:,:,83))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), wf4(:,3), Q(:,48), wf16(:,126), n3(:,168), t3x16(:,:,84))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), wf4(:,3), Q(:,48), wf16(:,127), n3(:,169), t3x16(:,:,85))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), wf4(:,4), Q(:,80), wf16(:,128), n3(:,170), t3x16(:,:,86))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), wf4(:,4), Q(:,80), wf16(:,129), n3(:,171), t3x16(:,:,87))
  call vert_UV_W(ntry, wf4(:,19), Q(:,6), wf4(:,5), Q(:,96), wf16(:,130), n3(:,172), t3x16(:,:,88))
  call vert_UV_W(ntry, wf4(:,18), Q(:,9), wf4(:,5), Q(:,96), wf16(:,131), n3(:,173), t3x16(:,:,89))
  call vert_UV_W(ntry, wf8(:,19), Q(:,25), ex7, Q(:,64), wf16(:,132), n3(:,174), t3x16(:,:,90))
  call vert_UV_W(ntry, wf8(:,19), Q(:,25), ex6, Q(:,32), wf16(:,133), n3(:,175), t3x16(:,:,91))
  call vert_UV_W(ntry, wf8(:,20), Q(:,22), ex7, Q(:,64), wf16(:,134), n3(:,176), t3x16(:,:,92))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,21), Q(:,41), wf16(:,135), n3(:,177), t3x16(:,:,93))
  call vert_UV_W(ntry, wf8(:,20), Q(:,22), ex6, Q(:,32), wf16(:,136), n3(:,178), t3x16(:,:,94))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,22), Q(:,38), wf16(:,137), n3(:,179), t3x16(:,:,95))
  call vert_VQ_A(ntry, ex7, wf4(:,21), wf8(:,92), n3(:,180), t3x8(:,:,66))
  call vert_AV_Q(ntry, wf4(:,13), wf4(:,19), wf16(:,138), n3(:,181), t3x16(:,:,96))
  call prop_Q_A(ntry, wf8(:,92), Q(:,81), MT, 1_intkind1, wf8(:,93), n2(42))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,13), wf16(:,139), n3(:,182), t3x16(:,:,97))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,21), wf16(:,140), n3(:,183), t3x16(:,:,98))
  call vert_VQ_A(ntry, ex6, wf4(:,21), wf8(:,94), n3(:,184), t3x8(:,:,67))
  call vert_AV_Q(ntry, wf4(:,17), wf4(:,19), wf16(:,141), n3(:,185), t3x16(:,:,99))
  call prop_Q_A(ntry, wf8(:,94), Q(:,49), MT, 1_intkind1, wf8(:,95), n2(43))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,17), wf16(:,142), n3(:,186), t3x16(:,:,100))
  call vert_VQ_A(ntry, wf4(:,5), wf4(:,21), wf16(:,143), n3(:,187), t3x16(:,:,101))
  call prop_A_Q(ntry, wf8(:,33), Q(:,14), MT, 1_intkind1, wf8(:,96), n2(44))
  call vert_UV_W(ntry, wf8(:,25), Q(:,25), ex7, Q(:,64), wf16(:,144), n3(:,188), t3x16(:,:,102))
  call vert_UV_W(ntry, wf8(:,25), Q(:,25), ex6, Q(:,32), wf16(:,145), n3(:,189), t3x16(:,:,103))
  call vert_AV_Q(ntry, wf8(:,96), ex7, wf16(:,146), n3(:,190), t3x16(:,:,104))
  call vert_QA_V(ntry, wf8(:,95), ex4, wf16(:,147), n3(:,191), t3x16(:,:,105))
  call vert_AV_Q(ntry, wf8(:,96), ex6, wf16(:,148), n3(:,192), t3x16(:,:,106))
  call vert_AV_Q(ntry, ex4, wf8(:,22), wf16(:,149), n3(:,193), t3x16(:,:,107))
  call vert_VQ_A(ntry, ex7, wf4(:,23), wf8(:,97), n3(:,194), t3x8(:,:,68))
  call vert_AV_Q(ntry, wf4(:,9), wf4(:,19), wf16(:,150), n3(:,195), t3x16(:,:,108))
  call prop_Q_A(ntry, wf8(:,97), Q(:,97), MT, 1_intkind1, wf8(:,98), n2(45))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,9), wf16(:,151), n3(:,196), t3x16(:,:,109))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,23), wf16(:,152), n3(:,197), t3x16(:,:,110))
  call vert_VQ_A(ntry, ex6, wf4(:,25), wf8(:,99), n3(:,198), t3x8(:,:,69))
  call prop_Q_A(ntry, wf8(:,99), Q(:,97), MT, 1_intkind1, wf8(:,100), n2(46))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,9), wf16(:,153), n3(:,199), t3x16(:,:,111))
  call vert_VQ_A(ntry, wf4(:,19), wf4(:,25), wf16(:,154), n3(:,200), t3x16(:,:,112))
  call vert_VQ_A(ntry, wf4(:,5), ex1, wf8(:,101), n3(:,201), t3x8(:,:,70))
  call prop_Q_A(ntry, wf8(:,101), Q(:,97), MT, 1_intkind1, wf8(:,102), n2(47))
  call vert_VQ_A(ntry, ex6, wf8(:,32), wf16(:,155), n3(:,202), t3x16(:,:,113))
  call vert_VQ_A(ntry, ex7, wf8(:,32), wf16(:,156), n3(:,203), t3x16(:,:,114))
  call vert_UV_W(ntry, wf8(:,26), Q(:,25), ex6, Q(:,32), wf16(:,157), n3(:,204), t3x16(:,:,115))
  call vert_UV_W(ntry, wf8(:,26), Q(:,25), ex7, Q(:,64), wf16(:,158), n3(:,205), t3x16(:,:,116))
  call vert_VQ_A(ntry, wf8(:,22), ex1, wf16(:,159), n3(:,206), t3x16(:,:,117))
  call vert_QA_V(ntry, ex1, wf8(:,73), wf16(:,160), n3(:,207), t3x16(:,:,118))
  call vert_VQ_A(ntry, ex5, wf4(:,23), wf8(:,103), n3(:,208), t3x8(:,:,71))
  call prop_Q_A(ntry, wf8(:,103), Q(:,49), MT, 1_intkind1, wf8(:,104), n2(48))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,17), wf16(:,161), n3(:,209), t3x16(:,:,119))
  call vert_VQ_A(ntry, wf4(:,4), wf4(:,23), wf16(:,162), n3(:,210), t3x16(:,:,120))
  call vert_UV_W(ntry, wf8(:,27), Q(:,41), ex7, Q(:,64), wf16(:,163), n3(:,211), t3x16(:,:,121))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,27), Q(:,41), wf16(:,164), n3(:,212), t3x16(:,:,122))
  call vert_QA_V(ntry, wf8(:,104), ex4, wf16(:,165), n3(:,213), t3x16(:,:,123))
  call vert_AV_Q(ntry, wf8(:,96), ex5, wf16(:,166), n3(:,214), t3x16(:,:,124))
  call vert_AV_Q(ntry, ex4, wf8(:,20), wf16(:,167), n3(:,215), t3x16(:,:,125))
  call vert_VQ_A(ntry, ex5, wf4(:,25), wf8(:,105), n3(:,216), t3x8(:,:,72))
  call prop_Q_A(ntry, wf8(:,105), Q(:,81), MT, 1_intkind1, wf8(:,106), n2(49))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,13), wf16(:,168), n3(:,217), t3x16(:,:,126))
  call vert_VQ_A(ntry, wf4(:,4), ex1, wf8(:,107), n3(:,218), t3x8(:,:,73))
  call prop_Q_A(ntry, wf8(:,107), Q(:,81), MT, 1_intkind1, wf8(:,108), n2(50))
  call vert_VQ_A(ntry, ex5, wf8(:,32), wf16(:,169), n3(:,219), t3x16(:,:,127))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,28), Q(:,41), wf16(:,170), n3(:,220), t3x16(:,:,128))
  call vert_UV_W(ntry, wf8(:,28), Q(:,41), ex7, Q(:,64), wf16(:,171), n3(:,221), t3x16(:,:,129))
  call vert_VQ_A(ntry, wf8(:,20), ex1, wf16(:,172), n3(:,222), t3x16(:,:,130))
  call vert_QA_V(ntry, ex1, wf8(:,85), wf16(:,173), n3(:,223), t3x16(:,:,131))
  call vert_VQ_A(ntry, wf4(:,3), wf4(:,25), wf16(:,174), n3(:,224), t3x16(:,:,132))
  call vert_VQ_A(ntry, wf4(:,3), ex1, wf8(:,109), n3(:,225), t3x8(:,:,74))
  call prop_Q_A(ntry, wf8(:,109), Q(:,49), MT, 1_intkind1, wf8(:,110), n2(51))
  call vert_QA_V(ntry, wf8(:,32), ex4, wf16(:,175), n3(:,226), t3x16(:,:,133))
  call vert_QA_V(ntry, wf8(:,110), ex4, wf16(:,176), n3(:,227), t3x16(:,:,134))
  call vert_QA_V(ntry, ex1, wf8(:,96), wf16(:,177), n3(:,228), t3x16(:,:,135))
  call vert_QA_V(ntry, ex1, wf8(:,89), wf16(:,178), n3(:,229), t3x16(:,:,136))
  call vert_VQ_A(ntry, ex7, wf8(:,110), wf16(:,179), n3(:,230), t3x16(:,:,137))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,29), Q(:,73), wf16(:,180), n3(:,231), t3x16(:,:,138))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,29), Q(:,73), wf16(:,181), n3(:,232), t3x16(:,:,139))
  call vert_QA_V(ntry, wf8(:,106), ex4, wf16(:,182), n3(:,233), t3x16(:,:,140))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,30), Q(:,73), wf16(:,183), n3(:,234), t3x16(:,:,141))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,30), Q(:,73), wf16(:,184), n3(:,235), t3x16(:,:,142))
  call vert_QA_V(ntry, ex1, wf8(:,79), wf16(:,185), n3(:,236), t3x16(:,:,143))
  call vert_QA_V(ntry, wf8(:,108), ex4, wf16(:,186), n3(:,237), t3x16(:,:,144))
  call vert_QA_V(ntry, ex1, wf8(:,81), wf16(:,187), n3(:,238), t3x16(:,:,145))
  call vert_VQ_A(ntry, ex6, wf8(:,108), wf16(:,188), n3(:,239), t3x16(:,:,146))
  call vert_QA_V(ntry, ex1, wf8(:,65), wf16(:,189), n3(:,240), t3x16(:,:,147))
  call vert_QA_V(ntry, wf8(:,102), ex4, wf16(:,190), n3(:,241), t3x16(:,:,148))
  call vert_VQ_A(ntry, ex5, wf8(:,102), wf16(:,191), n3(:,242), t3x16(:,:,149))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,29), wf16(:,192), n3(:,243), t3x16(:,:,150))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,18), wf16(:,193), n3(:,244), t3x16(:,:,151))
  call vert_AV_Q(ntry, wf4(:,29), ex7, wf8(:,111), n3(:,245), t3x8(:,:,75))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,7), wf16(:,194), n3(:,246), t3x16(:,:,152))
  call prop_A_Q(ntry, wf8(:,111), Q(:,100), MT, 1_intkind1, wf8(:,112), n2(52))
  call vert_QA_V(ntry, wf4(:,7), wf4(:,31), wf16(:,195), n3(:,247), t3x16(:,:,153))
  call vert_AV_Q(ntry, wf4(:,31), wf4(:,18), wf16(:,196), n3(:,248), t3x16(:,:,154))
  call vert_AV_Q(ntry, wf4(:,31), ex6, wf8(:,113), n3(:,249), t3x8(:,:,76))
  call prop_A_Q(ntry, wf8(:,113), Q(:,100), MT, 1_intkind1, wf8(:,114), n2(53))
  call prop_A_Q(ntry, wf8(:,42), Q(:,13), MT, 1_intkind1, wf8(:,115), n2(54))
  call vert_AV_Q(ntry, ex3, wf4(:,5), wf8(:,116), n3(:,250), t3x8(:,:,77))
  call prop_A_Q(ntry, wf8(:,116), Q(:,100), MT, 1_intkind1, wf8(:,117), n2(55))
  call vert_AV_Q(ntry, wf8(:,115), ex7, wf16(:,197), n3(:,251), t3x16(:,:,155))
  call vert_AV_Q(ntry, wf8(:,115), ex6, wf16(:,198), n3(:,252), t3x16(:,:,156))
  call vert_UV_W(ntry, wf8(:,34), Q(:,22), ex7, Q(:,64), wf16(:,199), n3(:,253), t3x16(:,:,157))
  call vert_AV_Q(ntry, ex3, wf8(:,21), wf16(:,200), n3(:,254), t3x16(:,:,158))
  call vert_UV_W(ntry, wf8(:,34), Q(:,22), ex6, Q(:,32), wf16(:,201), n3(:,255), t3x16(:,:,159))
  call vert_QA_V(ntry, wf8(:,60), ex3, wf16(:,202), n3(:,256), t3x16(:,:,160))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,27), wf16(:,203), n3(:,257), t3x16(:,:,161))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,18), wf16(:,204), n3(:,258), t3x16(:,:,162))
  call vert_AV_Q(ntry, wf4(:,27), ex7, wf8(:,118), n3(:,259), t3x8(:,:,78))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,11), wf16(:,205), n3(:,260), t3x16(:,:,163))
  call prop_A_Q(ntry, wf8(:,118), Q(:,84), MT, 1_intkind1, wf8(:,119), n2(56))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,27), wf16(:,206), n3(:,261), t3x16(:,:,164))
  call vert_AV_Q(ntry, wf4(:,27), ex6, wf8(:,120), n3(:,262), t3x8(:,:,79))
  call vert_VQ_A(ntry, wf4(:,18), wf4(:,15), wf16(:,207), n3(:,263), t3x16(:,:,165))
  call prop_A_Q(ntry, wf8(:,120), Q(:,52), MT, 1_intkind1, wf8(:,121), n2(57))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,5), wf16(:,208), n3(:,264), t3x16(:,:,166))
  call vert_VQ_A(ntry, ex6, wf8(:,41), wf16(:,209), n3(:,265), t3x16(:,:,167))
  call vert_VQ_A(ntry, ex7, wf8(:,41), wf16(:,210), n3(:,266), t3x16(:,:,168))
  call vert_UV_W(ntry, wf8(:,35), Q(:,22), ex7, Q(:,64), wf16(:,211), n3(:,267), t3x16(:,:,169))
  call vert_VQ_A(ntry, wf8(:,21), ex2, wf16(:,212), n3(:,268), t3x16(:,:,170))
  call vert_UV_W(ntry, wf8(:,35), Q(:,22), ex6, Q(:,32), wf16(:,213), n3(:,269), t3x16(:,:,171))
  call vert_QA_V(ntry, ex2, wf8(:,121), wf16(:,214), n3(:,270), t3x16(:,:,172))
  call vert_QA_V(ntry, wf4(:,11), wf4(:,31), wf16(:,215), n3(:,271), t3x16(:,:,173))
  call vert_AV_Q(ntry, wf4(:,31), ex5, wf8(:,122), n3(:,272), t3x8(:,:,80))
  call prop_A_Q(ntry, wf8(:,122), Q(:,84), MT, 1_intkind1, wf8(:,123), n2(58))
  call vert_AV_Q(ntry, ex3, wf4(:,4), wf8(:,124), n3(:,273), t3x8(:,:,81))
  call prop_A_Q(ntry, wf8(:,124), Q(:,84), MT, 1_intkind1, wf8(:,125), n2(59))
  call vert_AV_Q(ntry, wf8(:,115), ex5, wf16(:,216), n3(:,274), t3x16(:,:,174))
  call vert_UV_W(ntry, wf8(:,36), Q(:,38), ex7, Q(:,64), wf16(:,217), n3(:,275), t3x16(:,:,175))
  call vert_AV_Q(ntry, ex3, wf8(:,19), wf16(:,218), n3(:,276), t3x16(:,:,176))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,36), Q(:,38), wf16(:,219), n3(:,277), t3x16(:,:,177))
  call vert_QA_V(ntry, wf8(:,77), ex3, wf16(:,220), n3(:,278), t3x16(:,:,178))
  call vert_QA_V(ntry, wf4(:,15), wf4(:,29), wf16(:,221), n3(:,279), t3x16(:,:,179))
  call vert_AV_Q(ntry, wf4(:,29), ex5, wf8(:,126), n3(:,280), t3x8(:,:,82))
  call prop_A_Q(ntry, wf8(:,126), Q(:,52), MT, 1_intkind1, wf8(:,127), n2(60))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,4), wf16(:,222), n3(:,281), t3x16(:,:,180))
  call vert_VQ_A(ntry, ex5, wf8(:,41), wf16(:,223), n3(:,282), t3x16(:,:,181))
  call vert_UV_W(ntry, wf8(:,37), Q(:,38), ex7, Q(:,64), wf16(:,224), n3(:,283), t3x16(:,:,182))
  call vert_VQ_A(ntry, wf8(:,19), ex2, wf16(:,225), n3(:,284), t3x16(:,:,183))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,37), Q(:,38), wf16(:,226), n3(:,285), t3x16(:,:,184))
  call vert_QA_V(ntry, ex2, wf8(:,127), wf16(:,227), n3(:,286), t3x16(:,:,185))
  call vert_AV_Q(ntry, ex3, wf4(:,3), wf8(:,128), n3(:,287), t3x8(:,:,83))
  call prop_A_Q(ntry, wf8(:,128), Q(:,52), MT, 1_intkind1, wf8(:,129), n2(61))
  call vert_AV_Q(ntry, wf4(:,31), wf4(:,3), wf16(:,228), n3(:,288), t3x16(:,:,186))
  call vert_QA_V(ntry, wf8(:,41), ex3, wf16(:,229), n3(:,289), t3x16(:,:,187))
  call vert_QA_V(ntry, ex2, wf8(:,115), wf16(:,230), n3(:,290), t3x16(:,:,188))
  call vert_QA_V(ntry, wf8(:,91), ex3, wf16(:,231), n3(:,291), t3x16(:,:,189))
  call vert_QA_V(ntry, ex2, wf8(:,129), wf16(:,232), n3(:,292), t3x16(:,:,190))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,38), Q(:,70), wf16(:,233), n3(:,293), t3x16(:,:,191))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,38), Q(:,70), wf16(:,234), n3(:,294), t3x16(:,:,192))
  call vert_QA_V(ntry, wf8(:,83), ex3, wf16(:,235), n3(:,295), t3x16(:,:,193))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,39), Q(:,70), wf16(:,236), n3(:,296), t3x16(:,:,194))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,39), Q(:,70), wf16(:,237), n3(:,297), t3x16(:,:,195))
  call vert_QA_V(ntry, ex2, wf8(:,123), wf16(:,238), n3(:,298), t3x16(:,:,196))
  call vert_QA_V(ntry, wf8(:,87), ex3, wf16(:,239), n3(:,299), t3x16(:,:,197))
  call vert_QA_V(ntry, ex2, wf8(:,125), wf16(:,240), n3(:,300), t3x16(:,:,198))
  call vert_QA_V(ntry, ex2, wf8(:,117), wf16(:,241), n3(:,301), t3x16(:,:,199))
  call vert_QA_V(ntry, wf8(:,75), ex3, wf16(:,242), n3(:,302), t3x16(:,:,200))
  call vert_AV_Q(ntry, wf4(:,29), wf4(:,2), wf16(:,243), n3(:,303), t3x16(:,:,201))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,29), wf16(:,244), n3(:,304), t3x16(:,:,202))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,21), wf16(:,245), n3(:,305), t3x16(:,:,203))
  call vert_AV_Q(ntry, wf4(:,31), wf4(:,2), wf16(:,246), n3(:,306), t3x16(:,:,204))
  call vert_QA_V(ntry, wf4(:,21), wf4(:,31), wf16(:,247), n3(:,307), t3x16(:,:,205))
  call prop_A_Q(ntry, wf8(:,51), Q(:,14), MT, 1_intkind1, wf8(:,130), n2(62))
  call vert_UV_W(ntry, wf8(:,43), Q(:,21), ex7, Q(:,64), wf16(:,248), n3(:,308), t3x16(:,:,206))
  call vert_UV_W(ntry, wf8(:,43), Q(:,21), ex6, Q(:,32), wf16(:,249), n3(:,309), t3x16(:,:,207))
  call vert_AV_Q(ntry, wf8(:,130), ex7, wf16(:,250), n3(:,310), t3x16(:,:,208))
  call vert_QA_V(ntry, wf8(:,95), ex3, wf16(:,251), n3(:,311), t3x16(:,:,209))
  call vert_AV_Q(ntry, wf8(:,130), ex6, wf16(:,252), n3(:,312), t3x16(:,:,210))
  call vert_AV_Q(ntry, ex3, wf8(:,4), wf16(:,253), n3(:,313), t3x16(:,:,211))
  call vert_AV_Q(ntry, wf4(:,27), wf4(:,2), wf16(:,254), n3(:,314), t3x16(:,:,212))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,27), wf16(:,255), n3(:,315), t3x16(:,:,213))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,23), wf16(:,256), n3(:,316), t3x16(:,:,214))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,27), wf16(:,257), n3(:,317), t3x16(:,:,215))
  call vert_VQ_A(ntry, wf4(:,2), wf4(:,25), wf16(:,258), n3(:,318), t3x16(:,:,216))
  call vert_VQ_A(ntry, ex6, wf8(:,50), wf16(:,259), n3(:,319), t3x16(:,:,217))
  call vert_VQ_A(ntry, ex7, wf8(:,50), wf16(:,260), n3(:,320), t3x16(:,:,218))
  call vert_UV_W(ntry, wf8(:,44), Q(:,21), ex6, Q(:,32), wf16(:,261), n3(:,321), t3x16(:,:,219))
  call vert_UV_W(ntry, wf8(:,44), Q(:,21), ex7, Q(:,64), wf16(:,262), n3(:,322), t3x16(:,:,220))
  call vert_VQ_A(ntry, wf8(:,4), ex1, wf16(:,263), n3(:,323), t3x16(:,:,221))
  call vert_QA_V(ntry, ex1, wf8(:,121), wf16(:,264), n3(:,324), t3x16(:,:,222))
  call vert_QA_V(ntry, wf4(:,23), wf4(:,31), wf16(:,265), n3(:,325), t3x16(:,:,223))
  call vert_UV_W(ntry, wf8(:,45), Q(:,37), ex7, Q(:,64), wf16(:,266), n3(:,326), t3x16(:,:,224))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,45), Q(:,37), wf16(:,267), n3(:,327), t3x16(:,:,225))
  call vert_QA_V(ntry, wf8(:,104), ex3, wf16(:,268), n3(:,328), t3x16(:,:,226))
  call vert_AV_Q(ntry, wf8(:,130), ex5, wf16(:,269), n3(:,329), t3x16(:,:,227))
  call vert_AV_Q(ntry, ex3, wf8(:,2), wf16(:,270), n3(:,330), t3x16(:,:,228))
  call vert_QA_V(ntry, wf4(:,25), wf4(:,29), wf16(:,271), n3(:,331), t3x16(:,:,229))
  call vert_VQ_A(ntry, ex5, wf8(:,50), wf16(:,272), n3(:,332), t3x16(:,:,230))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,46), Q(:,37), wf16(:,273), n3(:,333), t3x16(:,:,231))
  call vert_UV_W(ntry, wf8(:,46), Q(:,37), ex7, Q(:,64), wf16(:,274), n3(:,334), t3x16(:,:,232))
  call vert_VQ_A(ntry, wf8(:,2), ex1, wf16(:,275), n3(:,335), t3x16(:,:,233))
  call vert_QA_V(ntry, ex1, wf8(:,127), wf16(:,276), n3(:,336), t3x16(:,:,234))
  call vert_QA_V(ntry, wf8(:,50), ex3, wf16(:,277), n3(:,337), t3x16(:,:,235))
  call vert_QA_V(ntry, wf8(:,110), ex3, wf16(:,278), n3(:,338), t3x16(:,:,236))
  call vert_QA_V(ntry, ex1, wf8(:,130), wf16(:,279), n3(:,339), t3x16(:,:,237))
  call vert_QA_V(ntry, ex1, wf8(:,129), wf16(:,280), n3(:,340), t3x16(:,:,238))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,47), Q(:,69), wf16(:,281), n3(:,341), t3x16(:,:,239))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,47), Q(:,69), wf16(:,282), n3(:,342), t3x16(:,:,240))
  call vert_QA_V(ntry, wf8(:,106), ex3, wf16(:,283), n3(:,343), t3x16(:,:,241))
  call vert_UV_W(ntry, ex5, Q(:,16), wf8(:,48), Q(:,69), wf16(:,284), n3(:,344), t3x16(:,:,242))
  call vert_UV_W(ntry, ex6, Q(:,32), wf8(:,48), Q(:,69), wf16(:,285), n3(:,345), t3x16(:,:,243))
  call vert_QA_V(ntry, ex1, wf8(:,123), wf16(:,286), n3(:,346), t3x16(:,:,244))
  call vert_QA_V(ntry, wf8(:,108), ex3, wf16(:,287), n3(:,347), t3x16(:,:,245))
  call vert_QA_V(ntry, ex1, wf8(:,125), wf16(:,288), n3(:,348), t3x16(:,:,246))
  call vert_QA_V(ntry, ex1, wf8(:,117), wf16(:,289), n3(:,349), t3x16(:,:,247))
  call vert_QA_V(ntry, wf8(:,102), ex3, wf16(:,290), n3(:,350), t3x16(:,:,248))
  call vert_AV_Q(ntry, ex4, wf8(:,43), wf16(:,291), n3(:,351), t3x16(:,:,249))
  call vert_AV_Q(ntry, ex3, wf8(:,25), wf16(:,292), n3(:,352), t3x16(:,:,250))
  call vert_AV_Q(ntry, ex4, wf8(:,36), wf16(:,293), n3(:,353), t3x16(:,:,251))
  call vert_AV_Q(ntry, ex3, wf8(:,12), wf16(:,294), n3(:,354), t3x16(:,:,252))
  call vert_VQ_A(ntry, wf8(:,25), ex2, wf16(:,295), n3(:,355), t3x16(:,:,253))
  call vert_AV_Q(ntry, ex4, wf8(:,37), wf16(:,296), n3(:,356), t3x16(:,:,254))
  call vert_VQ_A(ntry, wf8(:,43), ex2, wf16(:,297), n3(:,357), t3x16(:,:,255))
  call vert_AV_Q(ntry, ex3, wf8(:,13), wf16(:,298), n3(:,358), t3x16(:,:,256))
  call vert_AV_Q(ntry, ex4, wf8(:,38), wf16(:,299), n3(:,359), t3x16(:,:,257))
  call vert_AV_Q(ntry, ex3, wf8(:,14), wf16(:,300), n3(:,360), t3x16(:,:,258))
  call vert_AV_Q(ntry, ex4, wf8(:,39), wf16(:,301), n3(:,361), t3x16(:,:,259))
  call vert_AV_Q(ntry, ex3, wf8(:,15), wf16(:,302), n3(:,362), t3x16(:,:,260))
  call vert_AV_Q(ntry, ex4, wf8(:,45), wf16(:,303), n3(:,363), t3x16(:,:,261))
  call vert_AV_Q(ntry, ex3, wf8(:,27), wf16(:,304), n3(:,364), t3x16(:,:,262))
  call vert_AV_Q(ntry, ex4, wf8(:,34), wf16(:,305), n3(:,365), t3x16(:,:,263))
  call vert_AV_Q(ntry, ex3, wf8(:,10), wf16(:,306), n3(:,366), t3x16(:,:,264))
  call vert_AV_Q(ntry, ex4, wf8(:,46), wf16(:,307), n3(:,367), t3x16(:,:,265))
  call vert_VQ_A(ntry, wf8(:,10), ex1, wf16(:,308), n3(:,368), t3x16(:,:,266))
  call vert_AV_Q(ntry, ex3, wf8(:,28), wf16(:,309), n3(:,369), t3x16(:,:,267))
  call vert_VQ_A(ntry, wf8(:,34), ex1, wf16(:,310), n3(:,370), t3x16(:,:,268))
  call vert_AV_Q(ntry, ex4, wf8(:,47), wf16(:,311), n3(:,371), t3x16(:,:,269))
  call vert_AV_Q(ntry, ex3, wf8(:,29), wf16(:,312), n3(:,372), t3x16(:,:,270))
  call vert_AV_Q(ntry, ex4, wf8(:,48), wf16(:,313), n3(:,373), t3x16(:,:,271))
  call vert_AV_Q(ntry, ex3, wf8(:,30), wf16(:,314), n3(:,374), t3x16(:,:,272))
  call vert_VQ_A(ntry, wf8(:,27), ex2, wf16(:,315), n3(:,375), t3x16(:,:,273))
  call vert_AV_Q(ntry, ex4, wf8(:,35), wf16(:,316), n3(:,376), t3x16(:,:,274))
  call vert_AV_Q(ntry, ex4, wf8(:,44), wf16(:,317), n3(:,377), t3x16(:,:,275))
  call vert_VQ_A(ntry, wf8(:,12), ex1, wf16(:,318), n3(:,378), t3x16(:,:,276))
  call vert_VQ_A(ntry, wf8(:,44), ex2, wf16(:,319), n3(:,379), t3x16(:,:,277))
  call vert_VQ_A(ntry, wf8(:,28), ex2, wf16(:,320), n3(:,380), t3x16(:,:,278))
  call vert_VQ_A(ntry, wf8(:,35), ex1, wf16(:,321), n3(:,381), t3x16(:,:,279))
  call vert_VQ_A(ntry, wf8(:,13), ex1, wf16(:,322), n3(:,382), t3x16(:,:,280))
  call vert_VQ_A(ntry, wf8(:,29), ex2, wf16(:,323), n3(:,383), t3x16(:,:,281))
  call vert_VQ_A(ntry, wf8(:,14), ex1, wf16(:,324), n3(:,384), t3x16(:,:,282))
  call vert_VQ_A(ntry, wf8(:,30), ex2, wf16(:,325), n3(:,385), t3x16(:,:,283))
  call vert_VQ_A(ntry, wf8(:,15), ex1, wf16(:,326), n3(:,386), t3x16(:,:,284))
  call vert_VQ_A(ntry, wf8(:,45), ex2, wf16(:,327), n3(:,387), t3x16(:,:,285))
  call vert_AV_Q(ntry, ex3, wf8(:,11), wf16(:,328), n3(:,388), t3x16(:,:,286))
  call vert_AV_Q(ntry, ex3, wf8(:,26), wf16(:,329), n3(:,389), t3x16(:,:,287))
  call vert_VQ_A(ntry, wf8(:,36), ex1, wf16(:,330), n3(:,390), t3x16(:,:,288))
  call vert_VQ_A(ntry, wf8(:,46), ex2, wf16(:,331), n3(:,391), t3x16(:,:,289))
  call vert_VQ_A(ntry, wf8(:,26), ex2, wf16(:,332), n3(:,392), t3x16(:,:,290))
  call vert_VQ_A(ntry, wf8(:,37), ex1, wf16(:,333), n3(:,393), t3x16(:,:,291))
  call vert_VQ_A(ntry, wf8(:,11), ex1, wf16(:,334), n3(:,394), t3x16(:,:,292))
  call vert_VQ_A(ntry, wf8(:,47), ex2, wf16(:,335), n3(:,395), t3x16(:,:,293))
  call vert_VQ_A(ntry, wf8(:,38), ex1, wf16(:,336), n3(:,396), t3x16(:,:,294))
  call vert_VQ_A(ntry, wf8(:,48), ex2, wf16(:,337), n3(:,397), t3x16(:,:,295))
  call vert_VQ_A(ntry, wf8(:,39), ex1, wf16(:,338), n3(:,398), t3x16(:,:,296))


  ! colour-stripped amplitudes
  do nsync = ntry+ntry-1, ntry+1  !  nsync = 1,2  for 1st point and nsync = 3 later
    call diagrams()
    if (nsync == 1) then
      call helsync(nsync, A, nhel, Hel)
      call helsync_flip(nsync, nhel, Hel, eflip, exthel)
      if (any(POLSEL /= 0)) then
        ntry = 2
        goto 42
      end if
    end if
  end do

  do k = 1, nhel
    call colourvector(A, k, M1helarray(:,k))
  end do
  M1helarray(:,nhel+1:) = 0
  M1helarr = M1helarray ! fill cache

  M2 = 0
  if (ReplacePol == 0) then ! no helicity correlation

    do k = 1, nhel
      call colint(M1helarray(:,k), M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do

  else ! helicity correlation

    call flip_phase(P(:,ReplacePol), firstpol(ReplacePol), MOM, omega)
    do k = 1, nhel
      M1 = M1helarray(:,k)
      r = eflip(k, ReplacePol) ! Flip helicity of external particle ReplacePol (gluon emitter).
      if (r <= nhel) then      ! Only add flipped helicity configuration if it does not vanish.
        M1 = M1 + omega(exthel(k,ReplacePol)) * M1helarray(:,r)
      end if
      call colint2(M1helarray(:,k), M1, M2add, extcombs_permuted)
      M2 = M2 + M2add
    end do
    M2 = 0.5_/**/REALKIND * M2

  end if

  if ( JBmunu /= 0 ) then ! POWHEG's Bmunu helicity correlation
    P_scatt_intern = P_scatt
    M2munu = 0
    ! get wfs
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, -1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,1))
    call wf_V_Std(P_scatt_intern(:,-I), rZERO, 1, epLC)
    call LC2Std_Rep_cmplx(epLC, epStd(:,2))

    ! sum over helicities
    do k = 1, nhel
      !same helicity case
      call colintmunu(M1helarray(:,k), M1helarray(:,k), M2munuadd(1))
      !opposite helicity case
      r = eflip(k, JBmunu) ! Flip helicity of external particle JBmunu (gluon emitter).
      if (r <= nhel) then  ! Only add opposite helicity configuration if it doesn't vanish.
        call colintmunu(M1helarray(:,k), M1helarray(:,r), M2munuadd(2))
      else
        M2munuadd(2) = 0
      end if
      ! Fill B^(mu,nu) = sum_(k) sum_(l1,l2) M^*_(k) M_(k) (eps^(mu)_(l1))^* eps^(nu)_(l2)
      do m = 1,4
        do n = 1,4
          M2munu(m,n) = M2munu(m,n) + M2munuadd(1)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(k,JBmunu))
          if (r <= nhel) then
            M2munu(m,n) = M2munu(m,n) + M2munuadd(2)*conjg(epStd(m,exthel(k,JBmunu)))*epStd(n,exthel(r,JBmunu))
          end if
        end do
      end do
    end do

    M2munu = M2munu / average_factor_pptttt_tttxtxggg_1
  end if

  ! Colour and helicity average and symmetry factor of outgoing particles
  M2add = M2 / average_factor_pptttt_tttxtxggg_1

  do k = 0, 30-1
    M2(k) = M2add(extcomb_perm_pptttt_tttxtxggg_1(k))
  end do

  if (ntry == 1) ntry = 2

  if (scalefactor /= old_scalefactor) then
    scalebackfactor = scalefactor**(2*7-8)
    old_scalefactor = scalefactor
  end if
  M2 = scalebackfactor * M2

  contains

subroutine diagrams()
  implicit none
  ! e.g. call cont_VV(nsync, wf3, wf6, A(:,1), n64, t64, nhel, den(5)) ...

    call cont_VV(nsync, wf4(:,3), wf32(:,1), A(:,1), n3(:,399), t3x128(:,:,1), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf32(:,2), A(:,2), n3(:,400), t3x128(:,:,2), nhel, den(5))
    call cont_VV(nsync, wf4(:,3), wf32(:,3), A(:,3), n3(:,401), t3x128(:,:,3), nhel, den(5))
    call cont_VV(nsync, wf4(:,4), wf32(:,4), A(:,4), n3(:,402), t3x128(:,:,4), nhel, den(7))
    call cont_VV(nsync, wf4(:,4), wf32(:,5), A(:,5), n3(:,403), t3x128(:,:,5), nhel, den(7))
    call cont_VV(nsync, wf4(:,4), wf32(:,6), A(:,6), n3(:,404), t3x128(:,:,6), nhel, den(7))
    call cont_VV(nsync, wf8(:,1), wf16(:,1), A(:,7), n3(:,405), t3x128(:,:,7), nhel, den(10))
    call cont_VV(nsync, wf8(:,1), wf16(:,2), A(:,8), n3(:,406), t3x128(:,:,8), nhel, den(10))
    call cont_VV(nsync, wf8(:,1), wf16(:,3), A(:,9), n3(:,407), t3x128(:,:,9), nhel, den(10))
    call cont_VV(nsync, wf8(:,2), wf16(:,4), A(:,10), n3(:,408), t3x128(:,:,10), nhel, den(13))
    call cont_VV(nsync, wf8(:,2), wf16(:,5), A(:,11), n3(:,409), t3x128(:,:,11), nhel, den(13))
    call cont_VV(nsync, wf8(:,2), wf16(:,6), A(:,12), n3(:,410), t3x128(:,:,12), nhel, den(13))
    call cont_VV(nsync, wf4(:,5), wf32(:,7), A(:,13), n3(:,411), t3x128(:,:,13), nhel, den(15))
    call cont_VV(nsync, wf4(:,5), wf32(:,8), A(:,14), n3(:,412), t3x128(:,:,14), nhel, den(15))
    call cont_VV(nsync, wf4(:,5), wf32(:,9), A(:,15), n3(:,413), t3x128(:,:,15), nhel, den(15))
    call cont_VV(nsync, wf8(:,3), wf16(:,7), A(:,16), n3(:,414), t3x128(:,:,16), nhel, den(18))
    call cont_VV(nsync, wf8(:,3), wf16(:,8), A(:,17), n3(:,415), t3x128(:,:,17), nhel, den(18))
    call cont_VV(nsync, wf8(:,3), wf16(:,9), A(:,18), n3(:,416), t3x128(:,:,18), nhel, den(18))
    call cont_VV(nsync, wf8(:,4), wf16(:,10), A(:,19), n3(:,417), t3x128(:,:,19), nhel, den(21))
    call cont_VV(nsync, wf8(:,4), wf16(:,11), A(:,20), n3(:,418), t3x128(:,:,20), nhel, den(21))
    call cont_VV(nsync, wf8(:,4), wf16(:,12), A(:,21), n3(:,419), t3x128(:,:,21), nhel, den(21))
    call cont_VV(nsync, wf8(:,5), wf16(:,13), A(:,22), n3(:,420), t3x128(:,:,22), nhel, den(24))
    call cont_VV(nsync, wf8(:,5), wf16(:,14), A(:,23), n3(:,421), t3x128(:,:,23), nhel, den(24))
    call cont_VV(nsync, wf8(:,5), wf16(:,15), A(:,24), n3(:,422), t3x128(:,:,24), nhel, den(24))
    call cont_VV(nsync, wf8(:,6), wf16(:,16), A(:,25), n3(:,423), t3x128(:,:,25), nhel, den(27))
    call cont_VV(nsync, wf8(:,6), wf16(:,17), A(:,26), n3(:,424), t3x128(:,:,26), nhel, den(27))
    call cont_VV(nsync, wf8(:,6), wf16(:,18), A(:,27), n3(:,425), t3x128(:,:,27), nhel, den(27))
    call cont_VV(nsync, wf8(:,7), wf16(:,19), A(:,28), n3(:,426), t3x128(:,:,28), nhel, den(29))
    call cont_VV(nsync, wf16(:,19), wf8(:,8), A(:,29), n3(:,427), t3x128(:,:,29), nhel, den(29))
    call cont_VV(nsync, wf16(:,19), wf8(:,9), A(:,30), n3(:,428), t3x128(:,:,30), nhel, den(29))
    call cont_VV(nsync, wf16(:,4), wf8(:,10), A(:,31), n3(:,429), t3x128(:,:,31), nhel, den(32))
    call cont_VV(nsync, wf16(:,5), wf8(:,10), A(:,32), n3(:,430), t3x128(:,:,32), nhel, den(32))
    call cont_VV(nsync, wf16(:,6), wf8(:,10), A(:,33), n3(:,431), t3x128(:,:,33), nhel, den(32))
    call cont_VV(nsync, wf16(:,4), wf8(:,11), A(:,34), n3(:,432), t3x128(:,:,34), nhel, den(35))
    call cont_VV(nsync, wf16(:,5), wf8(:,11), A(:,35), n3(:,433), t3x128(:,:,35), nhel, den(35))
    call cont_VV(nsync, wf16(:,6), wf8(:,11), A(:,36), n3(:,434), t3x128(:,:,36), nhel, den(35))
    call cont_VV(nsync, wf16(:,10), wf8(:,12), A(:,37), n3(:,435), t3x128(:,:,37), nhel, den(38))
    call cont_VV(nsync, wf16(:,11), wf8(:,12), A(:,38), n3(:,436), t3x128(:,:,38), nhel, den(38))
    call cont_VV(nsync, wf16(:,12), wf8(:,12), A(:,39), n3(:,437), t3x128(:,:,39), nhel, den(38))
    call cont_VV(nsync, wf16(:,10), wf8(:,13), A(:,40), n3(:,438), t3x128(:,:,40), nhel, den(41))
    call cont_VV(nsync, wf16(:,11), wf8(:,13), A(:,41), n3(:,439), t3x128(:,:,41), nhel, den(41))
    call cont_VV(nsync, wf16(:,12), wf8(:,13), A(:,42), n3(:,440), t3x128(:,:,42), nhel, den(41))
    call cont_VV(nsync, wf16(:,16), wf8(:,14), A(:,43), n3(:,441), t3x128(:,:,43), nhel, den(44))
    call cont_VV(nsync, wf16(:,17), wf8(:,14), A(:,44), n3(:,442), t3x128(:,:,44), nhel, den(44))
    call cont_VV(nsync, wf16(:,18), wf8(:,14), A(:,45), n3(:,443), t3x128(:,:,45), nhel, den(44))
    call cont_VV(nsync, wf16(:,16), wf8(:,15), A(:,46), n3(:,444), t3x128(:,:,46), nhel, den(47))
    call cont_VV(nsync, wf16(:,17), wf8(:,15), A(:,47), n3(:,445), t3x128(:,:,47), nhel, den(47))
    call cont_VV(nsync, wf16(:,18), wf8(:,15), A(:,48), n3(:,446), t3x128(:,:,48), nhel, den(47))
    call cont_QA(nsync, wf16(:,20), wf8(:,17), A(:,49), n3(:,447), t3x128(:,:,49), nhel, den(50))
    call cont_QA(nsync, wf8(:,17), wf16(:,21), A(:,50), n3(:,448), t3x128(:,:,50), nhel, den(50))
    call cont_QA(nsync, wf8(:,17), wf16(:,22), A(:,51), n3(:,449), t3x128(:,:,51), nhel, den(50))
    call cont_QA(nsync, wf8(:,18), wf16(:,24), A(:,52), n3(:,450), t3x128(:,:,52), nhel, den(53))
    call cont_QA(nsync, wf8(:,18), wf16(:,26), A(:,53), n3(:,451), t3x128(:,:,53), nhel, den(53))
    call cont_QA(nsync, wf8(:,18), wf16(:,28), A(:,54), n3(:,452), t3x128(:,:,54), nhel, den(53))
    call cont_VV(nsync, wf4(:,3), wf32(:,10), A(:,55), n3(:,453), t3x128(:,:,55), nhel, den(57))
    call cont_VV(nsync, wf4(:,3), wf32(:,11), A(:,56), n3(:,454), t3x128(:,:,56), nhel, den(57))
    call cont_VV(nsync, wf4(:,3), wf32(:,12), A(:,57), n3(:,455), t3x128(:,:,57), nhel, den(57))
    call cont_VV(nsync, wf4(:,4), wf32(:,13), A(:,58), n3(:,456), t3x128(:,:,58), nhel, den(58))
    call cont_VV(nsync, wf4(:,4), wf32(:,14), A(:,59), n3(:,457), t3x128(:,:,59), nhel, den(58))
    call cont_VV(nsync, wf4(:,4), wf32(:,15), A(:,60), n3(:,458), t3x128(:,:,60), nhel, den(58))
    call cont_VV(nsync, wf8(:,19), wf16(:,29), A(:,61), n3(:,459), t3x128(:,:,61), nhel, den(61))
    call cont_VV(nsync, wf8(:,19), wf16(:,30), A(:,62), n3(:,460), t3x128(:,:,62), nhel, den(61))
    call cont_VV(nsync, wf8(:,19), wf16(:,31), A(:,63), n3(:,461), t3x128(:,:,63), nhel, den(61))
    call cont_VV(nsync, wf8(:,20), wf16(:,32), A(:,64), n3(:,462), t3x128(:,:,64), nhel, den(64))
    call cont_VV(nsync, wf8(:,20), wf16(:,33), A(:,65), n3(:,463), t3x128(:,:,65), nhel, den(64))
    call cont_VV(nsync, wf8(:,20), wf16(:,34), A(:,66), n3(:,464), t3x128(:,:,66), nhel, den(64))
    call cont_VV(nsync, wf4(:,5), wf32(:,16), A(:,67), n3(:,465), t3x128(:,:,67), nhel, den(65))
    call cont_VV(nsync, wf4(:,5), wf32(:,17), A(:,68), n3(:,466), t3x128(:,:,68), nhel, den(65))
    call cont_VV(nsync, wf4(:,5), wf32(:,18), A(:,69), n3(:,467), t3x128(:,:,69), nhel, den(65))
    call cont_VV(nsync, wf8(:,21), wf16(:,35), A(:,70), n3(:,468), t3x128(:,:,70), nhel, den(68))
    call cont_VV(nsync, wf8(:,21), wf16(:,36), A(:,71), n3(:,469), t3x128(:,:,71), nhel, den(68))
    call cont_VV(nsync, wf8(:,21), wf16(:,37), A(:,72), n3(:,470), t3x128(:,:,72), nhel, den(68))
    call cont_VV(nsync, wf8(:,22), wf16(:,38), A(:,73), n3(:,471), t3x128(:,:,73), nhel, den(71))
    call cont_VV(nsync, wf8(:,22), wf16(:,39), A(:,74), n3(:,472), t3x128(:,:,74), nhel, den(71))
    call cont_VV(nsync, wf8(:,22), wf16(:,40), A(:,75), n3(:,473), t3x128(:,:,75), nhel, den(71))
    call cont_VV(nsync, wf8(:,23), wf16(:,41), A(:,76), n3(:,474), t3x128(:,:,76), nhel, den(74))
    call cont_VV(nsync, wf8(:,23), wf16(:,42), A(:,77), n3(:,475), t3x128(:,:,77), nhel, den(74))
    call cont_VV(nsync, wf8(:,23), wf16(:,43), A(:,78), n3(:,476), t3x128(:,:,78), nhel, den(74))
    call cont_VV(nsync, wf8(:,24), wf16(:,44), A(:,79), n3(:,477), t3x128(:,:,79), nhel, den(77))
    call cont_VV(nsync, wf8(:,24), wf16(:,45), A(:,80), n3(:,478), t3x128(:,:,80), nhel, den(77))
    call cont_VV(nsync, wf8(:,24), wf16(:,46), A(:,81), n3(:,479), t3x128(:,:,81), nhel, den(77))
    call cont_VV(nsync, wf8(:,7), wf16(:,47), A(:,82), n3(:,480), t3x128(:,:,82), nhel, den(78))
    call cont_VV(nsync, wf8(:,8), wf16(:,47), A(:,83), n3(:,481), t3x128(:,:,83), nhel, den(78))
    call cont_VV(nsync, wf8(:,9), wf16(:,47), A(:,84), n3(:,482), t3x128(:,:,84), nhel, den(78))
    call cont_VV(nsync, wf16(:,29), wf8(:,25), A(:,85), n3(:,483), t3x128(:,:,85), nhel, den(81))
    call cont_VV(nsync, wf16(:,30), wf8(:,25), A(:,86), n3(:,484), t3x128(:,:,86), nhel, den(81))
    call cont_VV(nsync, wf16(:,31), wf8(:,25), A(:,87), n3(:,485), t3x128(:,:,87), nhel, den(81))
    call cont_VV(nsync, wf16(:,29), wf8(:,26), A(:,88), n3(:,486), t3x128(:,:,88), nhel, den(83))
    call cont_VV(nsync, wf16(:,30), wf8(:,26), A(:,89), n3(:,487), t3x128(:,:,89), nhel, den(83))
    call cont_VV(nsync, wf16(:,31), wf8(:,26), A(:,90), n3(:,488), t3x128(:,:,90), nhel, den(83))
    call cont_VV(nsync, wf16(:,35), wf8(:,27), A(:,91), n3(:,489), t3x128(:,:,91), nhel, den(86))
    call cont_VV(nsync, wf16(:,36), wf8(:,27), A(:,92), n3(:,490), t3x128(:,:,92), nhel, den(86))
    call cont_VV(nsync, wf16(:,37), wf8(:,27), A(:,93), n3(:,491), t3x128(:,:,93), nhel, den(86))
    call cont_VV(nsync, wf16(:,35), wf8(:,28), A(:,94), n3(:,492), t3x128(:,:,94), nhel, den(88))
    call cont_VV(nsync, wf16(:,36), wf8(:,28), A(:,95), n3(:,493), t3x128(:,:,95), nhel, den(88))
    call cont_VV(nsync, wf16(:,37), wf8(:,28), A(:,96), n3(:,494), t3x128(:,:,96), nhel, den(88))
    call cont_VV(nsync, wf16(:,41), wf8(:,29), A(:,97), n3(:,495), t3x128(:,:,97), nhel, den(91))
    call cont_VV(nsync, wf16(:,42), wf8(:,29), A(:,98), n3(:,496), t3x128(:,:,98), nhel, den(91))
    call cont_VV(nsync, wf16(:,43), wf8(:,29), A(:,99), n3(:,497), t3x128(:,:,99), nhel, den(91))
    call cont_VV(nsync, wf16(:,41), wf8(:,30), A(:,100), n3(:,498), t3x128(:,:,100), nhel, den(93))
    call cont_VV(nsync, wf16(:,42), wf8(:,30), A(:,101), n3(:,499), t3x128(:,:,101), nhel, den(93))
    call cont_VV(nsync, wf16(:,43), wf8(:,30), A(:,102), n3(:,500), t3x128(:,:,102), nhel, den(93))
    call cont_QA(nsync, wf16(:,20), wf8(:,32), A(:,103), n3(:,501), t3x128(:,:,103), nhel, den(95))
    call cont_QA(nsync, wf16(:,21), wf8(:,32), A(:,104), n3(:,502), t3x128(:,:,104), nhel, den(95))
    call cont_QA(nsync, wf16(:,22), wf8(:,32), A(:,105), n3(:,503), t3x128(:,:,105), nhel, den(95))
    call cont_QA(nsync, wf8(:,33), wf16(:,49), A(:,106), n3(:,504), t3x128(:,:,106), nhel, den(98))
    call cont_QA(nsync, wf8(:,33), wf16(:,51), A(:,107), n3(:,505), t3x128(:,:,107), nhel, den(98))
    call cont_QA(nsync, wf8(:,33), wf16(:,53), A(:,108), n3(:,506), t3x128(:,:,108), nhel, den(98))
    call cont_VV(nsync, wf16(:,32), wf8(:,34), A(:,109), n3(:,507), t3x128(:,:,109), nhel, den(100))
    call cont_VV(nsync, wf16(:,33), wf8(:,34), A(:,110), n3(:,508), t3x128(:,:,110), nhel, den(100))
    call cont_VV(nsync, wf16(:,34), wf8(:,34), A(:,111), n3(:,509), t3x128(:,:,111), nhel, den(100))
    call cont_VV(nsync, wf16(:,32), wf8(:,35), A(:,112), n3(:,510), t3x128(:,:,112), nhel, den(103))
    call cont_VV(nsync, wf16(:,33), wf8(:,35), A(:,113), n3(:,511), t3x128(:,:,113), nhel, den(103))
    call cont_VV(nsync, wf16(:,34), wf8(:,35), A(:,114), n3(:,512), t3x128(:,:,114), nhel, den(103))
    call cont_VV(nsync, wf16(:,38), wf8(:,36), A(:,115), n3(:,513), t3x128(:,:,115), nhel, den(105))
    call cont_VV(nsync, wf16(:,39), wf8(:,36), A(:,116), n3(:,514), t3x128(:,:,116), nhel, den(105))
    call cont_VV(nsync, wf16(:,40), wf8(:,36), A(:,117), n3(:,515), t3x128(:,:,117), nhel, den(105))
    call cont_VV(nsync, wf16(:,38), wf8(:,37), A(:,118), n3(:,516), t3x128(:,:,118), nhel, den(108))
    call cont_VV(nsync, wf16(:,39), wf8(:,37), A(:,119), n3(:,517), t3x128(:,:,119), nhel, den(108))
    call cont_VV(nsync, wf16(:,40), wf8(:,37), A(:,120), n3(:,518), t3x128(:,:,120), nhel, den(108))
    call cont_VV(nsync, wf16(:,44), wf8(:,38), A(:,121), n3(:,519), t3x128(:,:,121), nhel, den(110))
    call cont_VV(nsync, wf16(:,45), wf8(:,38), A(:,122), n3(:,520), t3x128(:,:,122), nhel, den(110))
    call cont_VV(nsync, wf16(:,46), wf8(:,38), A(:,123), n3(:,521), t3x128(:,:,123), nhel, den(110))
    call cont_VV(nsync, wf16(:,44), wf8(:,39), A(:,124), n3(:,522), t3x128(:,:,124), nhel, den(113))
    call cont_VV(nsync, wf16(:,45), wf8(:,39), A(:,125), n3(:,523), t3x128(:,:,125), nhel, den(113))
    call cont_VV(nsync, wf16(:,46), wf8(:,39), A(:,126), n3(:,524), t3x128(:,:,126), nhel, den(113))
    call cont_QA(nsync, wf16(:,54), wf8(:,41), A(:,127), n3(:,525), t3x128(:,:,127), nhel, den(116))
    call cont_QA(nsync, wf8(:,41), wf16(:,55), A(:,128), n3(:,526), t3x128(:,:,128), nhel, den(116))
    call cont_QA(nsync, wf8(:,41), wf16(:,56), A(:,129), n3(:,527), t3x128(:,:,129), nhel, den(116))
    call cont_QA(nsync, wf16(:,24), wf8(:,42), A(:,130), n3(:,528), t3x128(:,:,130), nhel, den(117))
    call cont_QA(nsync, wf16(:,26), wf8(:,42), A(:,131), n3(:,529), t3x128(:,:,131), nhel, den(117))
    call cont_QA(nsync, wf16(:,28), wf8(:,42), A(:,132), n3(:,530), t3x128(:,:,132), nhel, den(117))
    call cont_VV(nsync, wf16(:,1), wf8(:,43), A(:,133), n3(:,531), t3x128(:,:,133), nhel, den(119))
    call cont_VV(nsync, wf16(:,2), wf8(:,43), A(:,134), n3(:,532), t3x128(:,:,134), nhel, den(119))
    call cont_VV(nsync, wf16(:,3), wf8(:,43), A(:,135), n3(:,533), t3x128(:,:,135), nhel, den(119))
    call cont_VV(nsync, wf16(:,1), wf8(:,44), A(:,136), n3(:,534), t3x128(:,:,136), nhel, den(121))
    call cont_VV(nsync, wf16(:,2), wf8(:,44), A(:,137), n3(:,535), t3x128(:,:,137), nhel, den(121))
    call cont_VV(nsync, wf16(:,3), wf8(:,44), A(:,138), n3(:,536), t3x128(:,:,138), nhel, den(121))
    call cont_VV(nsync, wf16(:,7), wf8(:,45), A(:,139), n3(:,537), t3x128(:,:,139), nhel, den(123))
    call cont_VV(nsync, wf16(:,8), wf8(:,45), A(:,140), n3(:,538), t3x128(:,:,140), nhel, den(123))
    call cont_VV(nsync, wf16(:,9), wf8(:,45), A(:,141), n3(:,539), t3x128(:,:,141), nhel, den(123))
    call cont_VV(nsync, wf16(:,7), wf8(:,46), A(:,142), n3(:,540), t3x128(:,:,142), nhel, den(125))
    call cont_VV(nsync, wf16(:,8), wf8(:,46), A(:,143), n3(:,541), t3x128(:,:,143), nhel, den(125))
    call cont_VV(nsync, wf16(:,9), wf8(:,46), A(:,144), n3(:,542), t3x128(:,:,144), nhel, den(125))
    call cont_VV(nsync, wf16(:,13), wf8(:,47), A(:,145), n3(:,543), t3x128(:,:,145), nhel, den(127))
    call cont_VV(nsync, wf16(:,14), wf8(:,47), A(:,146), n3(:,544), t3x128(:,:,146), nhel, den(127))
    call cont_VV(nsync, wf16(:,15), wf8(:,47), A(:,147), n3(:,545), t3x128(:,:,147), nhel, den(127))
    call cont_VV(nsync, wf16(:,13), wf8(:,48), A(:,148), n3(:,546), t3x128(:,:,148), nhel, den(129))
    call cont_VV(nsync, wf16(:,14), wf8(:,48), A(:,149), n3(:,547), t3x128(:,:,149), nhel, den(129))
    call cont_VV(nsync, wf16(:,15), wf8(:,48), A(:,150), n3(:,548), t3x128(:,:,150), nhel, den(129))
    call cont_QA(nsync, wf16(:,54), wf8(:,50), A(:,151), n3(:,549), t3x128(:,:,151), nhel, den(131))
    call cont_QA(nsync, wf16(:,55), wf8(:,50), A(:,152), n3(:,550), t3x128(:,:,152), nhel, den(131))
    call cont_QA(nsync, wf16(:,56), wf8(:,50), A(:,153), n3(:,551), t3x128(:,:,153), nhel, den(131))
    call cont_QA(nsync, wf16(:,49), wf8(:,51), A(:,154), n3(:,552), t3x128(:,:,154), nhel, den(132))
    call cont_QA(nsync, wf16(:,51), wf8(:,51), A(:,155), n3(:,553), t3x128(:,:,155), nhel, den(132))
    call cont_QA(nsync, wf16(:,53), wf8(:,51), A(:,156), n3(:,554), t3x128(:,:,156), nhel, den(132))
    call cont_VV(nsync, wf8(:,5), wf16(:,57), A(:,157), n3(:,555), t3x128(:,:,157), nhel, den(134))
    call cont_VV(nsync, wf8(:,6), wf16(:,58), A(:,158), n3(:,556), t3x128(:,:,158), nhel, den(136))
    call cont_VV(nsync, wf16(:,19), wf8(:,52), A(:,159), n3(:,557), t3x128(:,:,159), nhel, den(138))
    call cont_VV(nsync, wf8(:,3), wf16(:,59), A(:,160), n3(:,558), t3x128(:,:,160), nhel, den(140))
    call cont_VV(nsync, wf8(:,4), wf16(:,60), A(:,161), n3(:,559), t3x128(:,:,161), nhel, den(142))
    call cont_VV(nsync, wf16(:,19), wf8(:,53), A(:,162), n3(:,560), t3x128(:,:,162), nhel, den(144))
    call cont_VV(nsync, wf8(:,1), wf16(:,61), A(:,163), n3(:,561), t3x128(:,:,163), nhel, den(146))
    call cont_VV(nsync, wf8(:,2), wf16(:,62), A(:,164), n3(:,562), t3x128(:,:,164), nhel, den(148))
    call cont_VV(nsync, wf16(:,19), wf8(:,54), A(:,165), n3(:,563), t3x128(:,:,165), nhel, den(150))
    call cont_VV(nsync, wf8(:,4), wf16(:,63), A(:,166), n3(:,564), t3x128(:,:,166), nhel, den(151))
    call cont_VV(nsync, wf8(:,6), wf16(:,64), A(:,167), n3(:,565), t3x128(:,:,167), nhel, den(152))
    call cont_VV(nsync, wf8(:,3), wf16(:,65), A(:,168), n3(:,566), t3x128(:,:,168), nhel, den(153))
    call cont_VV(nsync, wf8(:,6), wf16(:,66), A(:,169), n3(:,567), t3x128(:,:,169), nhel, den(154))
    call cont_VV(nsync, wf8(:,5), wf16(:,67), A(:,170), n3(:,568), t3x128(:,:,170), nhel, den(155))
    call cont_VV(nsync, wf8(:,5), wf16(:,68), A(:,171), n3(:,569), t3x128(:,:,171), nhel, den(156))
    call cont_VV(nsync, wf8(:,5), wf16(:,69), A(:,172), n3(:,570), t3x128(:,:,172), nhel, den(158))
    call cont_QA(nsync, wf16(:,70), wf8(:,56), A(:,173), n3(:,571), t3x128(:,:,173), nhel, den(162))
    call cont_QA(nsync, wf16(:,71), wf8(:,58), A(:,174), n3(:,572), t3x128(:,:,174), nhel, den(166))
    call cont_VV(nsync, wf8(:,3), wf16(:,72), A(:,175), n3(:,573), t3x128(:,:,175), nhel, den(168))
    call cont_QA(nsync, wf16(:,73), wf8(:,60), A(:,176), n3(:,574), t3x128(:,:,176), nhel, den(172))
    call cont_QA(nsync, wf16(:,71), wf8(:,62), A(:,177), n3(:,575), t3x128(:,:,177), nhel, den(174))
    call cont_QA(nsync, wf16(:,74), wf8(:,63), A(:,178), n3(:,576), t3x128(:,:,178), nhel, den(178))
    call cont_VV(nsync, wf8(:,10), wf16(:,62), A(:,179), n3(:,577), t3x128(:,:,179), nhel, den(179))
    call cont_QA(nsync, wf16(:,71), wf8(:,65), A(:,180), n3(:,578), t3x128(:,:,180), nhel, den(181))
    call cont_QA(nsync, wf8(:,60), wf16(:,75), A(:,181), n3(:,579), t3x128(:,:,181), nhel, den(182))
    call cont_QA(nsync, wf8(:,56), wf16(:,76), A(:,182), n3(:,580), t3x128(:,:,182), nhel, den(183))
    call cont_VV(nsync, wf8(:,3), wf16(:,77), A(:,183), n3(:,581), t3x128(:,:,183), nhel, den(184))
    call cont_QA(nsync, wf8(:,56), wf16(:,78), A(:,184), n3(:,582), t3x128(:,:,184), nhel, den(185))
    call cont_VV(nsync, wf8(:,5), wf16(:,79), A(:,185), n3(:,583), t3x128(:,:,185), nhel, den(186))
    call cont_VV(nsync, wf8(:,5), wf16(:,80), A(:,186), n3(:,584), t3x128(:,:,186), nhel, den(187))
    call cont_VV(nsync, wf8(:,5), wf16(:,81), A(:,187), n3(:,585), t3x128(:,:,187), nhel, den(189))
    call cont_QA(nsync, wf16(:,82), wf8(:,67), A(:,188), n3(:,586), t3x128(:,:,188), nhel, den(193))
    call cont_QA(nsync, wf16(:,83), wf8(:,69), A(:,189), n3(:,587), t3x128(:,:,189), nhel, den(197))
    call cont_VV(nsync, wf8(:,3), wf16(:,84), A(:,190), n3(:,588), t3x128(:,:,190), nhel, den(199))
    call cont_QA(nsync, wf16(:,82), wf8(:,71), A(:,191), n3(:,589), t3x128(:,:,191), nhel, den(201))
    call cont_QA(nsync, wf16(:,85), wf8(:,73), A(:,192), n3(:,590), t3x128(:,:,192), nhel, den(205))
    call cont_QA(nsync, wf8(:,17), wf16(:,86), A(:,193), n3(:,591), t3x128(:,:,193), nhel, den(207))
    call cont_VV(nsync, wf8(:,11), wf16(:,62), A(:,194), n3(:,592), t3x128(:,:,194), nhel, den(208))
    call cont_QA(nsync, wf16(:,82), wf8(:,75), A(:,195), n3(:,593), t3x128(:,:,195), nhel, den(210))
    call cont_QA(nsync, wf8(:,69), wf16(:,87), A(:,196), n3(:,594), t3x128(:,:,196), nhel, den(211))
    call cont_QA(nsync, wf8(:,73), wf16(:,88), A(:,197), n3(:,595), t3x128(:,:,197), nhel, den(212))
    call cont_VV(nsync, wf8(:,3), wf16(:,89), A(:,198), n3(:,596), t3x128(:,:,198), nhel, den(213))
    call cont_QA(nsync, wf8(:,69), wf16(:,90), A(:,199), n3(:,597), t3x128(:,:,199), nhel, den(214))
    call cont_VV(nsync, wf8(:,5), wf16(:,91), A(:,200), n3(:,598), t3x128(:,:,200), nhel, den(215))
    call cont_VV(nsync, wf8(:,5), wf16(:,92), A(:,201), n3(:,599), t3x128(:,:,201), nhel, den(216))
    call cont_VV(nsync, wf8(:,1), wf16(:,93), A(:,202), n3(:,600), t3x128(:,:,202), nhel, den(218))
    call cont_QA(nsync, wf16(:,73), wf8(:,77), A(:,203), n3(:,601), t3x128(:,:,203), nhel, den(220))
    call cont_QA(nsync, wf16(:,83), wf8(:,79), A(:,204), n3(:,602), t3x128(:,:,204), nhel, den(222))
    call cont_QA(nsync, wf8(:,63), wf16(:,94), A(:,205), n3(:,603), t3x128(:,:,205), nhel, den(224))
    call cont_VV(nsync, wf8(:,12), wf16(:,60), A(:,206), n3(:,604), t3x128(:,:,206), nhel, den(225))
    call cont_QA(nsync, wf16(:,83), wf8(:,81), A(:,207), n3(:,605), t3x128(:,:,207), nhel, den(227))
    call cont_QA(nsync, wf16(:,75), wf8(:,77), A(:,208), n3(:,606), t3x128(:,:,208), nhel, den(228))
    call cont_QA(nsync, wf8(:,67), wf16(:,95), A(:,209), n3(:,607), t3x128(:,:,209), nhel, den(229))
    call cont_VV(nsync, wf8(:,1), wf16(:,96), A(:,210), n3(:,608), t3x128(:,:,210), nhel, den(230))
    call cont_QA(nsync, wf8(:,67), wf16(:,97), A(:,211), n3(:,609), t3x128(:,:,211), nhel, den(231))
    call cont_VV(nsync, wf8(:,5), wf16(:,98), A(:,212), n3(:,610), t3x128(:,:,212), nhel, den(232))
    call cont_VV(nsync, wf8(:,5), wf16(:,99), A(:,213), n3(:,611), t3x128(:,:,213), nhel, den(233))
    call cont_VV(nsync, wf8(:,1), wf16(:,100), A(:,214), n3(:,612), t3x128(:,:,214), nhel, den(235))
    call cont_QA(nsync, wf16(:,70), wf8(:,83), A(:,215), n3(:,613), t3x128(:,:,215), nhel, den(237))
    call cont_QA(nsync, wf16(:,85), wf8(:,85), A(:,216), n3(:,614), t3x128(:,:,216), nhel, den(239))
    call cont_QA(nsync, wf8(:,17), wf16(:,101), A(:,217), n3(:,615), t3x128(:,:,217), nhel, den(241))
    call cont_VV(nsync, wf8(:,13), wf16(:,60), A(:,218), n3(:,616), t3x128(:,:,218), nhel, den(242))
    call cont_QA(nsync, wf16(:,70), wf8(:,87), A(:,219), n3(:,617), t3x128(:,:,219), nhel, den(244))
    call cont_QA(nsync, wf8(:,58), wf16(:,102), A(:,220), n3(:,618), t3x128(:,:,220), nhel, den(245))
    call cont_QA(nsync, wf16(:,88), wf8(:,85), A(:,221), n3(:,619), t3x128(:,:,221), nhel, den(246))
    call cont_VV(nsync, wf8(:,1), wf16(:,103), A(:,222), n3(:,620), t3x128(:,:,222), nhel, den(247))
    call cont_QA(nsync, wf8(:,58), wf16(:,104), A(:,223), n3(:,621), t3x128(:,:,223), nhel, den(248))
    call cont_VV(nsync, wf8(:,5), wf16(:,105), A(:,224), n3(:,622), t3x128(:,:,224), nhel, den(249))
    call cont_VV(nsync, wf8(:,5), wf16(:,106), A(:,225), n3(:,623), t3x128(:,:,225), nhel, den(250))
    call cont_QA(nsync, wf8(:,63), wf16(:,107), A(:,226), n3(:,624), t3x128(:,:,226), nhel, den(252))
    call cont_VV(nsync, wf8(:,14), wf16(:,58), A(:,227), n3(:,625), t3x128(:,:,227), nhel, den(253))
    call cont_QA(nsync, wf16(:,85), wf8(:,89), A(:,228), n3(:,626), t3x128(:,:,228), nhel, den(255))
    call cont_QA(nsync, wf8(:,17), wf16(:,108), A(:,229), n3(:,627), t3x128(:,:,229), nhel, den(257))
    call cont_VV(nsync, wf8(:,15), wf16(:,58), A(:,230), n3(:,628), t3x128(:,:,230), nhel, den(258))
    call cont_QA(nsync, wf16(:,73), wf8(:,91), A(:,231), n3(:,629), t3x128(:,:,231), nhel, den(260))
    call cont_VV(nsync, wf8(:,52), wf16(:,109), A(:,232), n3(:,630), t3x128(:,:,232), nhel, den(261))
    call cont_QA(nsync, wf16(:,88), wf8(:,89), A(:,233), n3(:,631), t3x128(:,:,233), nhel, den(262))
    call cont_VV(nsync, wf8(:,52), wf16(:,110), A(:,234), n3(:,632), t3x128(:,:,234), nhel, den(263))
    call cont_QA(nsync, wf8(:,63), wf16(:,111), A(:,235), n3(:,633), t3x128(:,:,235), nhel, den(264))
    call cont_VV(nsync, wf8(:,5), wf16(:,112), A(:,236), n3(:,634), t3x128(:,:,236), nhel, den(265))
    call cont_VV(nsync, wf8(:,5), wf16(:,113), A(:,237), n3(:,635), t3x128(:,:,237), nhel, den(266))
    call cont_QA(nsync, wf16(:,76), wf8(:,83), A(:,238), n3(:,636), t3x128(:,:,238), nhel, den(267))
    call cont_QA(nsync, wf8(:,71), wf16(:,95), A(:,239), n3(:,637), t3x128(:,:,239), nhel, den(268))
    call cont_VV(nsync, wf8(:,1), wf16(:,114), A(:,240), n3(:,638), t3x128(:,:,240), nhel, den(269))
    call cont_QA(nsync, wf8(:,71), wf16(:,97), A(:,241), n3(:,639), t3x128(:,:,241), nhel, den(270))
    call cont_VV(nsync, wf8(:,3), wf16(:,115), A(:,242), n3(:,640), t3x128(:,:,242), nhel, den(271))
    call cont_VV(nsync, wf8(:,3), wf16(:,116), A(:,243), n3(:,641), t3x128(:,:,243), nhel, den(272))
    call cont_QA(nsync, wf8(:,62), wf16(:,102), A(:,244), n3(:,642), t3x128(:,:,244), nhel, den(273))
    call cont_QA(nsync, wf16(:,87), wf8(:,79), A(:,245), n3(:,643), t3x128(:,:,245), nhel, den(274))
    call cont_VV(nsync, wf8(:,1), wf16(:,117), A(:,246), n3(:,644), t3x128(:,:,246), nhel, den(275))
    call cont_QA(nsync, wf8(:,62), wf16(:,104), A(:,247), n3(:,645), t3x128(:,:,247), nhel, den(276))
    call cont_VV(nsync, wf8(:,3), wf16(:,118), A(:,248), n3(:,646), t3x128(:,:,248), nhel, den(277))
    call cont_VV(nsync, wf8(:,3), wf16(:,119), A(:,249), n3(:,647), t3x128(:,:,249), nhel, den(278))
    call cont_VV(nsync, wf8(:,53), wf16(:,109), A(:,250), n3(:,648), t3x128(:,:,250), nhel, den(279))
    call cont_QA(nsync, wf16(:,87), wf8(:,81), A(:,251), n3(:,649), t3x128(:,:,251), nhel, den(280))
    call cont_VV(nsync, wf8(:,53), wf16(:,110), A(:,252), n3(:,650), t3x128(:,:,252), nhel, den(281))
    call cont_QA(nsync, wf8(:,63), wf16(:,120), A(:,253), n3(:,651), t3x128(:,:,253), nhel, den(282))
    call cont_VV(nsync, wf8(:,3), wf16(:,121), A(:,254), n3(:,652), t3x128(:,:,254), nhel, den(283))
    call cont_VV(nsync, wf8(:,3), wf16(:,122), A(:,255), n3(:,653), t3x128(:,:,255), nhel, den(284))
    call cont_VV(nsync, wf8(:,54), wf16(:,109), A(:,256), n3(:,654), t3x128(:,:,256), nhel, den(285))
    call cont_QA(nsync, wf8(:,65), wf16(:,102), A(:,257), n3(:,655), t3x128(:,:,257), nhel, den(286))
    call cont_VV(nsync, wf8(:,54), wf16(:,110), A(:,258), n3(:,656), t3x128(:,:,258), nhel, den(287))
    call cont_QA(nsync, wf8(:,63), wf16(:,123), A(:,259), n3(:,657), t3x128(:,:,259), nhel, den(288))
    call cont_VV(nsync, wf8(:,1), wf16(:,124), A(:,260), n3(:,658), t3x128(:,:,260), nhel, den(289))
    call cont_VV(nsync, wf8(:,1), wf16(:,125), A(:,261), n3(:,659), t3x128(:,:,261), nhel, den(290))
    call cont_VV(nsync, wf8(:,23), wf16(:,126), A(:,262), n3(:,660), t3x128(:,:,262), nhel, den(292))
    call cont_VV(nsync, wf8(:,24), wf16(:,127), A(:,263), n3(:,661), t3x128(:,:,263), nhel, den(294))
    call cont_VV(nsync, wf16(:,47), wf8(:,52), A(:,264), n3(:,662), t3x128(:,:,264), nhel, den(295))
    call cont_VV(nsync, wf8(:,21), wf16(:,128), A(:,265), n3(:,663), t3x128(:,:,265), nhel, den(297))
    call cont_VV(nsync, wf8(:,22), wf16(:,129), A(:,266), n3(:,664), t3x128(:,:,266), nhel, den(299))
    call cont_VV(nsync, wf16(:,47), wf8(:,53), A(:,267), n3(:,665), t3x128(:,:,267), nhel, den(300))
    call cont_VV(nsync, wf8(:,19), wf16(:,130), A(:,268), n3(:,666), t3x128(:,:,268), nhel, den(302))
    call cont_VV(nsync, wf8(:,20), wf16(:,131), A(:,269), n3(:,667), t3x128(:,:,269), nhel, den(304))
    call cont_VV(nsync, wf16(:,47), wf8(:,54), A(:,270), n3(:,668), t3x128(:,:,270), nhel, den(305))
    call cont_VV(nsync, wf8(:,22), wf16(:,132), A(:,271), n3(:,669), t3x128(:,:,271), nhel, den(306))
    call cont_VV(nsync, wf8(:,24), wf16(:,133), A(:,272), n3(:,670), t3x128(:,:,272), nhel, den(307))
    call cont_VV(nsync, wf8(:,21), wf16(:,134), A(:,273), n3(:,671), t3x128(:,:,273), nhel, den(308))
    call cont_VV(nsync, wf8(:,24), wf16(:,135), A(:,274), n3(:,672), t3x128(:,:,274), nhel, den(309))
    call cont_VV(nsync, wf8(:,23), wf16(:,136), A(:,275), n3(:,673), t3x128(:,:,275), nhel, den(310))
    call cont_VV(nsync, wf8(:,23), wf16(:,137), A(:,276), n3(:,674), t3x128(:,:,276), nhel, den(311))
    call cont_QA(nsync, wf16(:,138), wf8(:,93), A(:,277), n3(:,675), t3x128(:,:,277), nhel, den(315))
    call cont_VV(nsync, wf8(:,24), wf16(:,139), A(:,278), n3(:,676), t3x128(:,:,278), nhel, den(317))
    call cont_QA(nsync, wf8(:,58), wf16(:,140), A(:,279), n3(:,677), t3x128(:,:,279), nhel, den(319))
    call cont_QA(nsync, wf16(:,141), wf8(:,95), A(:,280), n3(:,678), t3x128(:,:,280), nhel, den(323))
    call cont_VV(nsync, wf8(:,22), wf16(:,142), A(:,281), n3(:,679), t3x128(:,:,281), nhel, den(325))
    call cont_QA(nsync, wf8(:,62), wf16(:,140), A(:,282), n3(:,680), t3x128(:,:,282), nhel, den(326))
    call cont_VV(nsync, wf8(:,25), wf16(:,130), A(:,283), n3(:,681), t3x128(:,:,283), nhel, den(327))
    call cont_QA(nsync, wf16(:,143), wf8(:,96), A(:,284), n3(:,682), t3x128(:,:,284), nhel, den(331))
    call cont_QA(nsync, wf8(:,65), wf16(:,140), A(:,285), n3(:,683), t3x128(:,:,285), nhel, den(332))
    call cont_VV(nsync, wf8(:,22), wf16(:,144), A(:,286), n3(:,684), t3x128(:,:,286), nhel, den(333))
    call cont_VV(nsync, wf8(:,24), wf16(:,145), A(:,287), n3(:,685), t3x128(:,:,287), nhel, den(334))
    call cont_QA(nsync, wf8(:,95), wf16(:,146), A(:,288), n3(:,686), t3x128(:,:,288), nhel, den(335))
    call cont_VV(nsync, wf8(:,24), wf16(:,147), A(:,289), n3(:,687), t3x128(:,:,289), nhel, den(336))
    call cont_QA(nsync, wf8(:,93), wf16(:,148), A(:,290), n3(:,688), t3x128(:,:,290), nhel, den(337))
    call cont_QA(nsync, wf8(:,93), wf16(:,149), A(:,291), n3(:,689), t3x128(:,:,291), nhel, den(338))
    call cont_QA(nsync, wf16(:,150), wf8(:,98), A(:,292), n3(:,690), t3x128(:,:,292), nhel, den(342))
    call cont_VV(nsync, wf8(:,24), wf16(:,151), A(:,293), n3(:,691), t3x128(:,:,293), nhel, den(344))
    call cont_QA(nsync, wf8(:,69), wf16(:,152), A(:,294), n3(:,692), t3x128(:,:,294), nhel, den(346))
    call cont_QA(nsync, wf16(:,150), wf8(:,100), A(:,295), n3(:,693), t3x128(:,:,295), nhel, den(348))
    call cont_VV(nsync, wf8(:,22), wf16(:,153), A(:,296), n3(:,694), t3x128(:,:,296), nhel, den(350))
    call cont_QA(nsync, wf8(:,73), wf16(:,154), A(:,297), n3(:,695), t3x128(:,:,297), nhel, den(352))
    call cont_QA(nsync, wf8(:,32), wf16(:,86), A(:,298), n3(:,696), t3x128(:,:,298), nhel, den(353))
    call cont_VV(nsync, wf8(:,26), wf16(:,130), A(:,299), n3(:,697), t3x128(:,:,299), nhel, den(354))
    call cont_QA(nsync, wf16(:,150), wf8(:,102), A(:,300), n3(:,698), t3x128(:,:,300), nhel, den(356))
    call cont_QA(nsync, wf8(:,69), wf16(:,155), A(:,301), n3(:,699), t3x128(:,:,301), nhel, den(357))
    call cont_QA(nsync, wf8(:,73), wf16(:,156), A(:,302), n3(:,700), t3x128(:,:,302), nhel, den(358))
    call cont_VV(nsync, wf8(:,24), wf16(:,157), A(:,303), n3(:,701), t3x128(:,:,303), nhel, den(359))
    call cont_VV(nsync, wf8(:,22), wf16(:,158), A(:,304), n3(:,702), t3x128(:,:,304), nhel, den(360))
    call cont_QA(nsync, wf8(:,69), wf16(:,159), A(:,305), n3(:,703), t3x128(:,:,305), nhel, den(361))
    call cont_VV(nsync, wf8(:,24), wf16(:,160), A(:,306), n3(:,704), t3x128(:,:,306), nhel, den(362))
    call cont_QA(nsync, wf16(:,141), wf8(:,104), A(:,307), n3(:,705), t3x128(:,:,307), nhel, den(364))
    call cont_VV(nsync, wf8(:,20), wf16(:,161), A(:,308), n3(:,706), t3x128(:,:,308), nhel, den(366))
    call cont_QA(nsync, wf8(:,79), wf16(:,152), A(:,309), n3(:,707), t3x128(:,:,309), nhel, den(367))
    call cont_VV(nsync, wf8(:,27), wf16(:,128), A(:,310), n3(:,708), t3x128(:,:,310), nhel, den(368))
    call cont_QA(nsync, wf8(:,96), wf16(:,162), A(:,311), n3(:,709), t3x128(:,:,311), nhel, den(370))
    call cont_QA(nsync, wf8(:,81), wf16(:,152), A(:,312), n3(:,710), t3x128(:,:,312), nhel, den(371))
    call cont_VV(nsync, wf8(:,20), wf16(:,163), A(:,313), n3(:,711), t3x128(:,:,313), nhel, den(372))
    call cont_VV(nsync, wf8(:,24), wf16(:,164), A(:,314), n3(:,712), t3x128(:,:,314), nhel, den(373))
    call cont_QA(nsync, wf16(:,146), wf8(:,104), A(:,315), n3(:,713), t3x128(:,:,315), nhel, den(374))
    call cont_VV(nsync, wf8(:,24), wf16(:,165), A(:,316), n3(:,714), t3x128(:,:,316), nhel, den(375))
    call cont_QA(nsync, wf8(:,98), wf16(:,166), A(:,317), n3(:,715), t3x128(:,:,317), nhel, den(376))
    call cont_QA(nsync, wf8(:,98), wf16(:,167), A(:,318), n3(:,716), t3x128(:,:,318), nhel, den(377))
    call cont_QA(nsync, wf16(:,138), wf8(:,106), A(:,319), n3(:,717), t3x128(:,:,319), nhel, den(379))
    call cont_VV(nsync, wf8(:,20), wf16(:,168), A(:,320), n3(:,718), t3x128(:,:,320), nhel, den(381))
    call cont_QA(nsync, wf8(:,85), wf16(:,154), A(:,321), n3(:,719), t3x128(:,:,321), nhel, den(382))
    call cont_QA(nsync, wf8(:,32), wf16(:,101), A(:,322), n3(:,720), t3x128(:,:,322), nhel, den(383))
    call cont_VV(nsync, wf8(:,28), wf16(:,128), A(:,323), n3(:,721), t3x128(:,:,323), nhel, den(384))
    call cont_QA(nsync, wf16(:,138), wf8(:,108), A(:,324), n3(:,722), t3x128(:,:,324), nhel, den(386))
    call cont_QA(nsync, wf8(:,58), wf16(:,169), A(:,325), n3(:,723), t3x128(:,:,325), nhel, den(387))
    call cont_QA(nsync, wf8(:,85), wf16(:,156), A(:,326), n3(:,724), t3x128(:,:,326), nhel, den(388))
    call cont_VV(nsync, wf8(:,24), wf16(:,170), A(:,327), n3(:,725), t3x128(:,:,327), nhel, den(389))
    call cont_VV(nsync, wf8(:,20), wf16(:,171), A(:,328), n3(:,726), t3x128(:,:,328), nhel, den(390))
    call cont_QA(nsync, wf8(:,58), wf16(:,172), A(:,329), n3(:,727), t3x128(:,:,329), nhel, den(391))
    call cont_VV(nsync, wf8(:,24), wf16(:,173), A(:,330), n3(:,728), t3x128(:,:,330), nhel, den(392))
    call cont_VV(nsync, wf8(:,29), wf16(:,126), A(:,331), n3(:,729), t3x128(:,:,331), nhel, den(393))
    call cont_QA(nsync, wf8(:,96), wf16(:,174), A(:,332), n3(:,730), t3x128(:,:,332), nhel, den(395))
    call cont_QA(nsync, wf8(:,89), wf16(:,154), A(:,333), n3(:,731), t3x128(:,:,333), nhel, den(396))
    call cont_QA(nsync, wf8(:,32), wf16(:,108), A(:,334), n3(:,732), t3x128(:,:,334), nhel, den(397))
    call cont_VV(nsync, wf8(:,30), wf16(:,126), A(:,335), n3(:,733), t3x128(:,:,335), nhel, den(398))
    call cont_QA(nsync, wf16(:,141), wf8(:,110), A(:,336), n3(:,734), t3x128(:,:,336), nhel, den(400))
    call cont_VV(nsync, wf8(:,52), wf16(:,175), A(:,337), n3(:,735), t3x128(:,:,337), nhel, den(401))
    call cont_QA(nsync, wf8(:,89), wf16(:,156), A(:,338), n3(:,736), t3x128(:,:,338), nhel, den(402))
    call cont_VV(nsync, wf8(:,24), wf16(:,176), A(:,339), n3(:,737), t3x128(:,:,339), nhel, den(403))
    call cont_VV(nsync, wf8(:,52), wf16(:,177), A(:,340), n3(:,738), t3x128(:,:,340), nhel, den(404))
    call cont_VV(nsync, wf8(:,24), wf16(:,178), A(:,341), n3(:,739), t3x128(:,:,341), nhel, den(405))
    call cont_QA(nsync, wf8(:,96), wf16(:,179), A(:,342), n3(:,740), t3x128(:,:,342), nhel, den(406))
    call cont_VV(nsync, wf8(:,20), wf16(:,180), A(:,343), n3(:,741), t3x128(:,:,343), nhel, den(407))
    call cont_VV(nsync, wf8(:,22), wf16(:,181), A(:,344), n3(:,742), t3x128(:,:,344), nhel, den(408))
    call cont_QA(nsync, wf16(:,148), wf8(:,106), A(:,345), n3(:,743), t3x128(:,:,345), nhel, den(409))
    call cont_VV(nsync, wf8(:,22), wf16(:,182), A(:,346), n3(:,744), t3x128(:,:,346), nhel, den(410))
    call cont_QA(nsync, wf8(:,100), wf16(:,166), A(:,347), n3(:,745), t3x128(:,:,347), nhel, den(411))
    call cont_QA(nsync, wf8(:,100), wf16(:,167), A(:,348), n3(:,746), t3x128(:,:,348), nhel, den(412))
    call cont_QA(nsync, wf8(:,62), wf16(:,169), A(:,349), n3(:,747), t3x128(:,:,349), nhel, den(413))
    call cont_QA(nsync, wf8(:,79), wf16(:,155), A(:,350), n3(:,748), t3x128(:,:,350), nhel, den(414))
    call cont_VV(nsync, wf8(:,22), wf16(:,183), A(:,351), n3(:,749), t3x128(:,:,351), nhel, den(415))
    call cont_VV(nsync, wf8(:,20), wf16(:,184), A(:,352), n3(:,750), t3x128(:,:,352), nhel, den(416))
    call cont_QA(nsync, wf8(:,62), wf16(:,172), A(:,353), n3(:,751), t3x128(:,:,353), nhel, den(417))
    call cont_VV(nsync, wf8(:,22), wf16(:,185), A(:,354), n3(:,752), t3x128(:,:,354), nhel, den(418))
    call cont_VV(nsync, wf8(:,53), wf16(:,175), A(:,355), n3(:,753), t3x128(:,:,355), nhel, den(419))
    call cont_QA(nsync, wf8(:,81), wf16(:,155), A(:,356), n3(:,754), t3x128(:,:,356), nhel, den(420))
    call cont_VV(nsync, wf8(:,22), wf16(:,186), A(:,357), n3(:,755), t3x128(:,:,357), nhel, den(421))
    call cont_VV(nsync, wf8(:,53), wf16(:,177), A(:,358), n3(:,756), t3x128(:,:,358), nhel, den(422))
    call cont_VV(nsync, wf8(:,22), wf16(:,187), A(:,359), n3(:,757), t3x128(:,:,359), nhel, den(423))
    call cont_QA(nsync, wf8(:,96), wf16(:,188), A(:,360), n3(:,758), t3x128(:,:,360), nhel, den(424))
    call cont_VV(nsync, wf8(:,54), wf16(:,175), A(:,361), n3(:,759), t3x128(:,:,361), nhel, den(425))
    call cont_QA(nsync, wf8(:,65), wf16(:,169), A(:,362), n3(:,760), t3x128(:,:,362), nhel, den(426))
    call cont_VV(nsync, wf8(:,54), wf16(:,177), A(:,363), n3(:,761), t3x128(:,:,363), nhel, den(427))
    call cont_VV(nsync, wf8(:,20), wf16(:,189), A(:,364), n3(:,762), t3x128(:,:,364), nhel, den(428))
    call cont_VV(nsync, wf8(:,20), wf16(:,190), A(:,365), n3(:,763), t3x128(:,:,365), nhel, den(429))
    call cont_QA(nsync, wf8(:,96), wf16(:,191), A(:,366), n3(:,764), t3x128(:,:,366), nhel, den(430))
    call cont_VV(nsync, wf8(:,23), wf16(:,192), A(:,367), n3(:,765), t3x128(:,:,367), nhel, den(432))
    call cont_QA(nsync, wf8(:,56), wf16(:,193), A(:,368), n3(:,766), t3x128(:,:,368), nhel, den(434))
    call cont_QA(nsync, wf16(:,194), wf8(:,112), A(:,369), n3(:,767), t3x128(:,:,369), nhel, den(438))
    call cont_VV(nsync, wf8(:,21), wf16(:,195), A(:,370), n3(:,768), t3x128(:,:,370), nhel, den(440))
    call cont_QA(nsync, wf8(:,60), wf16(:,196), A(:,371), n3(:,769), t3x128(:,:,371), nhel, den(442))
    call cont_QA(nsync, wf16(:,194), wf8(:,114), A(:,372), n3(:,770), t3x128(:,:,372), nhel, den(444))
    call cont_QA(nsync, wf16(:,74), wf8(:,115), A(:,373), n3(:,771), t3x128(:,:,373), nhel, den(446))
    call cont_VV(nsync, wf8(:,34), wf16(:,131), A(:,374), n3(:,772), t3x128(:,:,374), nhel, den(447))
    call cont_QA(nsync, wf16(:,194), wf8(:,117), A(:,375), n3(:,773), t3x128(:,:,375), nhel, den(449))
    call cont_QA(nsync, wf8(:,60), wf16(:,197), A(:,376), n3(:,774), t3x128(:,:,376), nhel, den(450))
    call cont_QA(nsync, wf8(:,56), wf16(:,198), A(:,377), n3(:,775), t3x128(:,:,377), nhel, den(451))
    call cont_VV(nsync, wf8(:,21), wf16(:,199), A(:,378), n3(:,776), t3x128(:,:,378), nhel, den(452))
    call cont_QA(nsync, wf8(:,56), wf16(:,200), A(:,379), n3(:,777), t3x128(:,:,379), nhel, den(453))
    call cont_VV(nsync, wf8(:,23), wf16(:,201), A(:,380), n3(:,778), t3x128(:,:,380), nhel, den(454))
    call cont_VV(nsync, wf8(:,23), wf16(:,202), A(:,381), n3(:,779), t3x128(:,:,381), nhel, den(455))
    call cont_VV(nsync, wf8(:,23), wf16(:,203), A(:,382), n3(:,780), t3x128(:,:,382), nhel, den(457))
    call cont_QA(nsync, wf8(:,67), wf16(:,204), A(:,383), n3(:,781), t3x128(:,:,383), nhel, den(459))
    call cont_QA(nsync, wf16(:,205), wf8(:,119), A(:,384), n3(:,782), t3x128(:,:,384), nhel, den(463))
    call cont_VV(nsync, wf8(:,21), wf16(:,206), A(:,385), n3(:,783), t3x128(:,:,385), nhel, den(465))
    call cont_QA(nsync, wf8(:,71), wf16(:,204), A(:,386), n3(:,784), t3x128(:,:,386), nhel, den(466))
    call cont_QA(nsync, wf16(:,207), wf8(:,121), A(:,387), n3(:,785), t3x128(:,:,387), nhel, den(470))
    call cont_QA(nsync, wf8(:,41), wf16(:,208), A(:,388), n3(:,786), t3x128(:,:,388), nhel, den(472))
    call cont_VV(nsync, wf8(:,35), wf16(:,131), A(:,389), n3(:,787), t3x128(:,:,389), nhel, den(473))
    call cont_QA(nsync, wf8(:,75), wf16(:,204), A(:,390), n3(:,788), t3x128(:,:,390), nhel, den(474))
    call cont_QA(nsync, wf8(:,119), wf16(:,209), A(:,391), n3(:,789), t3x128(:,:,391), nhel, den(475))
    call cont_QA(nsync, wf8(:,121), wf16(:,210), A(:,392), n3(:,790), t3x128(:,:,392), nhel, den(476))
    call cont_VV(nsync, wf8(:,21), wf16(:,211), A(:,393), n3(:,791), t3x128(:,:,393), nhel, den(477))
    call cont_QA(nsync, wf8(:,119), wf16(:,212), A(:,394), n3(:,792), t3x128(:,:,394), nhel, den(478))
    call cont_VV(nsync, wf8(:,23), wf16(:,213), A(:,395), n3(:,793), t3x128(:,:,395), nhel, den(479))
    call cont_VV(nsync, wf8(:,23), wf16(:,214), A(:,396), n3(:,794), t3x128(:,:,396), nhel, den(480))
    call cont_VV(nsync, wf8(:,19), wf16(:,215), A(:,397), n3(:,795), t3x128(:,:,397), nhel, den(482))
    call cont_QA(nsync, wf8(:,77), wf16(:,196), A(:,398), n3(:,796), t3x128(:,:,398), nhel, den(483))
    call cont_QA(nsync, wf16(:,205), wf8(:,123), A(:,399), n3(:,797), t3x128(:,:,399), nhel, den(485))
    call cont_QA(nsync, wf16(:,94), wf8(:,115), A(:,400), n3(:,798), t3x128(:,:,400), nhel, den(486))
    call cont_VV(nsync, wf8(:,36), wf16(:,129), A(:,401), n3(:,799), t3x128(:,:,401), nhel, den(487))
    call cont_QA(nsync, wf16(:,205), wf8(:,125), A(:,402), n3(:,800), t3x128(:,:,402), nhel, den(489))
    call cont_QA(nsync, wf8(:,77), wf16(:,197), A(:,403), n3(:,801), t3x128(:,:,403), nhel, den(490))
    call cont_QA(nsync, wf8(:,67), wf16(:,216), A(:,404), n3(:,802), t3x128(:,:,404), nhel, den(491))
    call cont_VV(nsync, wf8(:,19), wf16(:,217), A(:,405), n3(:,803), t3x128(:,:,405), nhel, den(492))
    call cont_QA(nsync, wf8(:,67), wf16(:,218), A(:,406), n3(:,804), t3x128(:,:,406), nhel, den(493))
    call cont_VV(nsync, wf8(:,23), wf16(:,219), A(:,407), n3(:,805), t3x128(:,:,407), nhel, den(494))
    call cont_VV(nsync, wf8(:,23), wf16(:,220), A(:,408), n3(:,806), t3x128(:,:,408), nhel, den(495))
    call cont_VV(nsync, wf8(:,19), wf16(:,221), A(:,409), n3(:,807), t3x128(:,:,409), nhel, den(497))
    call cont_QA(nsync, wf8(:,83), wf16(:,193), A(:,410), n3(:,808), t3x128(:,:,410), nhel, den(498))
    call cont_QA(nsync, wf16(:,207), wf8(:,127), A(:,411), n3(:,809), t3x128(:,:,411), nhel, den(500))
    call cont_QA(nsync, wf8(:,41), wf16(:,222), A(:,412), n3(:,810), t3x128(:,:,412), nhel, den(502))
    call cont_VV(nsync, wf8(:,37), wf16(:,129), A(:,413), n3(:,811), t3x128(:,:,413), nhel, den(503))
    call cont_QA(nsync, wf8(:,87), wf16(:,193), A(:,414), n3(:,812), t3x128(:,:,414), nhel, den(504))
    call cont_QA(nsync, wf8(:,112), wf16(:,223), A(:,415), n3(:,813), t3x128(:,:,415), nhel, den(505))
    call cont_QA(nsync, wf16(:,210), wf8(:,127), A(:,416), n3(:,814), t3x128(:,:,416), nhel, den(506))
    call cont_VV(nsync, wf8(:,19), wf16(:,224), A(:,417), n3(:,815), t3x128(:,:,417), nhel, den(507))
    call cont_QA(nsync, wf8(:,112), wf16(:,225), A(:,418), n3(:,816), t3x128(:,:,418), nhel, den(508))
    call cont_VV(nsync, wf8(:,23), wf16(:,226), A(:,419), n3(:,817), t3x128(:,:,419), nhel, den(509))
    call cont_VV(nsync, wf8(:,23), wf16(:,227), A(:,420), n3(:,818), t3x128(:,:,420), nhel, den(510))
    call cont_QA(nsync, wf16(:,107), wf8(:,115), A(:,421), n3(:,819), t3x128(:,:,421), nhel, den(511))
    call cont_VV(nsync, wf8(:,38), wf16(:,127), A(:,422), n3(:,820), t3x128(:,:,422), nhel, den(512))
    call cont_QA(nsync, wf16(:,207), wf8(:,129), A(:,423), n3(:,821), t3x128(:,:,423), nhel, den(514))
    call cont_QA(nsync, wf8(:,41), wf16(:,228), A(:,424), n3(:,822), t3x128(:,:,424), nhel, den(516))
    call cont_VV(nsync, wf8(:,39), wf16(:,127), A(:,425), n3(:,823), t3x128(:,:,425), nhel, den(517))
    call cont_QA(nsync, wf8(:,91), wf16(:,196), A(:,426), n3(:,824), t3x128(:,:,426), nhel, den(518))
    call cont_VV(nsync, wf8(:,52), wf16(:,229), A(:,427), n3(:,825), t3x128(:,:,427), nhel, den(519))
    call cont_QA(nsync, wf16(:,210), wf8(:,129), A(:,428), n3(:,826), t3x128(:,:,428), nhel, den(520))
    call cont_VV(nsync, wf8(:,52), wf16(:,230), A(:,429), n3(:,827), t3x128(:,:,429), nhel, den(521))
    call cont_QA(nsync, wf16(:,111), wf8(:,115), A(:,430), n3(:,828), t3x128(:,:,430), nhel, den(522))
    call cont_VV(nsync, wf8(:,23), wf16(:,231), A(:,431), n3(:,829), t3x128(:,:,431), nhel, den(523))
    call cont_VV(nsync, wf8(:,23), wf16(:,232), A(:,432), n3(:,830), t3x128(:,:,432), nhel, den(524))
    call cont_QA(nsync, wf8(:,83), wf16(:,198), A(:,433), n3(:,831), t3x128(:,:,433), nhel, den(525))
    call cont_QA(nsync, wf8(:,71), wf16(:,216), A(:,434), n3(:,832), t3x128(:,:,434), nhel, den(526))
    call cont_VV(nsync, wf8(:,19), wf16(:,233), A(:,435), n3(:,833), t3x128(:,:,435), nhel, den(527))
    call cont_QA(nsync, wf8(:,71), wf16(:,218), A(:,436), n3(:,834), t3x128(:,:,436), nhel, den(528))
    call cont_VV(nsync, wf8(:,21), wf16(:,234), A(:,437), n3(:,835), t3x128(:,:,437), nhel, den(529))
    call cont_VV(nsync, wf8(:,21), wf16(:,235), A(:,438), n3(:,836), t3x128(:,:,438), nhel, den(530))
    call cont_QA(nsync, wf8(:,114), wf16(:,223), A(:,439), n3(:,837), t3x128(:,:,439), nhel, den(531))
    call cont_QA(nsync, wf16(:,209), wf8(:,123), A(:,440), n3(:,838), t3x128(:,:,440), nhel, den(532))
    call cont_VV(nsync, wf8(:,19), wf16(:,236), A(:,441), n3(:,839), t3x128(:,:,441), nhel, den(533))
    call cont_QA(nsync, wf8(:,114), wf16(:,225), A(:,442), n3(:,840), t3x128(:,:,442), nhel, den(534))
    call cont_VV(nsync, wf8(:,21), wf16(:,237), A(:,443), n3(:,841), t3x128(:,:,443), nhel, den(535))
    call cont_VV(nsync, wf8(:,21), wf16(:,238), A(:,444), n3(:,842), t3x128(:,:,444), nhel, den(536))
    call cont_VV(nsync, wf8(:,53), wf16(:,229), A(:,445), n3(:,843), t3x128(:,:,445), nhel, den(537))
    call cont_QA(nsync, wf16(:,209), wf8(:,125), A(:,446), n3(:,844), t3x128(:,:,446), nhel, den(538))
    call cont_VV(nsync, wf8(:,53), wf16(:,230), A(:,447), n3(:,845), t3x128(:,:,447), nhel, den(539))
    call cont_QA(nsync, wf16(:,120), wf8(:,115), A(:,448), n3(:,846), t3x128(:,:,448), nhel, den(540))
    call cont_VV(nsync, wf8(:,21), wf16(:,239), A(:,449), n3(:,847), t3x128(:,:,449), nhel, den(541))
    call cont_VV(nsync, wf8(:,21), wf16(:,240), A(:,450), n3(:,848), t3x128(:,:,450), nhel, den(542))
    call cont_VV(nsync, wf8(:,54), wf16(:,229), A(:,451), n3(:,849), t3x128(:,:,451), nhel, den(543))
    call cont_QA(nsync, wf8(:,117), wf16(:,223), A(:,452), n3(:,850), t3x128(:,:,452), nhel, den(544))
    call cont_VV(nsync, wf8(:,54), wf16(:,230), A(:,453), n3(:,851), t3x128(:,:,453), nhel, den(545))
    call cont_QA(nsync, wf16(:,123), wf8(:,115), A(:,454), n3(:,852), t3x128(:,:,454), nhel, den(546))
    call cont_VV(nsync, wf8(:,19), wf16(:,241), A(:,455), n3(:,853), t3x128(:,:,455), nhel, den(547))
    call cont_VV(nsync, wf8(:,19), wf16(:,242), A(:,456), n3(:,854), t3x128(:,:,456), nhel, den(548))
    call cont_QA(nsync, wf8(:,93), wf16(:,243), A(:,457), n3(:,855), t3x128(:,:,457), nhel, den(550))
    call cont_VV(nsync, wf8(:,6), wf16(:,244), A(:,458), n3(:,856), t3x128(:,:,458), nhel, den(552))
    call cont_QA(nsync, wf8(:,112), wf16(:,245), A(:,459), n3(:,857), t3x128(:,:,459), nhel, den(554))
    call cont_QA(nsync, wf8(:,95), wf16(:,246), A(:,460), n3(:,858), t3x128(:,:,460), nhel, den(556))
    call cont_VV(nsync, wf8(:,4), wf16(:,247), A(:,461), n3(:,859), t3x128(:,:,461), nhel, den(558))
    call cont_QA(nsync, wf8(:,114), wf16(:,245), A(:,462), n3(:,860), t3x128(:,:,462), nhel, den(559))
    call cont_VV(nsync, wf8(:,43), wf16(:,61), A(:,463), n3(:,861), t3x128(:,:,463), nhel, den(560))
    call cont_QA(nsync, wf16(:,143), wf8(:,130), A(:,464), n3(:,862), t3x128(:,:,464), nhel, den(562))
    call cont_QA(nsync, wf8(:,117), wf16(:,245), A(:,465), n3(:,863), t3x128(:,:,465), nhel, den(563))
    call cont_VV(nsync, wf8(:,4), wf16(:,248), A(:,466), n3(:,864), t3x128(:,:,466), nhel, den(564))
    call cont_VV(nsync, wf8(:,6), wf16(:,249), A(:,467), n3(:,865), t3x128(:,:,467), nhel, den(565))
    call cont_QA(nsync, wf8(:,95), wf16(:,250), A(:,468), n3(:,866), t3x128(:,:,468), nhel, den(566))
    call cont_VV(nsync, wf8(:,6), wf16(:,251), A(:,469), n3(:,867), t3x128(:,:,469), nhel, den(567))
    call cont_QA(nsync, wf8(:,93), wf16(:,252), A(:,470), n3(:,868), t3x128(:,:,470), nhel, den(568))
    call cont_QA(nsync, wf8(:,93), wf16(:,253), A(:,471), n3(:,869), t3x128(:,:,471), nhel, den(569))
    call cont_QA(nsync, wf8(:,98), wf16(:,254), A(:,472), n3(:,870), t3x128(:,:,472), nhel, den(571))
    call cont_VV(nsync, wf8(:,6), wf16(:,255), A(:,473), n3(:,871), t3x128(:,:,473), nhel, den(573))
    call cont_QA(nsync, wf8(:,119), wf16(:,256), A(:,474), n3(:,872), t3x128(:,:,474), nhel, den(575))
    call cont_QA(nsync, wf8(:,100), wf16(:,254), A(:,475), n3(:,873), t3x128(:,:,475), nhel, den(576))
    call cont_VV(nsync, wf8(:,4), wf16(:,257), A(:,476), n3(:,874), t3x128(:,:,476), nhel, den(578))
    call cont_QA(nsync, wf8(:,121), wf16(:,258), A(:,477), n3(:,875), t3x128(:,:,477), nhel, den(580))
    call cont_QA(nsync, wf8(:,50), wf16(:,208), A(:,478), n3(:,876), t3x128(:,:,478), nhel, den(581))
    call cont_VV(nsync, wf8(:,44), wf16(:,61), A(:,479), n3(:,877), t3x128(:,:,479), nhel, den(582))
    call cont_QA(nsync, wf8(:,102), wf16(:,254), A(:,480), n3(:,878), t3x128(:,:,480), nhel, den(583))
    call cont_QA(nsync, wf8(:,119), wf16(:,259), A(:,481), n3(:,879), t3x128(:,:,481), nhel, den(584))
    call cont_QA(nsync, wf8(:,121), wf16(:,260), A(:,482), n3(:,880), t3x128(:,:,482), nhel, den(585))
    call cont_VV(nsync, wf8(:,6), wf16(:,261), A(:,483), n3(:,881), t3x128(:,:,483), nhel, den(586))
    call cont_VV(nsync, wf8(:,4), wf16(:,262), A(:,484), n3(:,882), t3x128(:,:,484), nhel, den(587))
    call cont_QA(nsync, wf8(:,119), wf16(:,263), A(:,485), n3(:,883), t3x128(:,:,485), nhel, den(588))
    call cont_VV(nsync, wf8(:,6), wf16(:,264), A(:,486), n3(:,884), t3x128(:,:,486), nhel, den(589))
    call cont_QA(nsync, wf8(:,104), wf16(:,246), A(:,487), n3(:,885), t3x128(:,:,487), nhel, den(590))
    call cont_VV(nsync, wf8(:,2), wf16(:,265), A(:,488), n3(:,886), t3x128(:,:,488), nhel, den(592))
    call cont_QA(nsync, wf8(:,123), wf16(:,256), A(:,489), n3(:,887), t3x128(:,:,489), nhel, den(593))
    call cont_VV(nsync, wf8(:,45), wf16(:,59), A(:,490), n3(:,888), t3x128(:,:,490), nhel, den(594))
    call cont_QA(nsync, wf16(:,162), wf8(:,130), A(:,491), n3(:,889), t3x128(:,:,491), nhel, den(595))
    call cont_QA(nsync, wf8(:,125), wf16(:,256), A(:,492), n3(:,890), t3x128(:,:,492), nhel, den(596))
    call cont_VV(nsync, wf8(:,2), wf16(:,266), A(:,493), n3(:,891), t3x128(:,:,493), nhel, den(597))
    call cont_VV(nsync, wf8(:,6), wf16(:,267), A(:,494), n3(:,892), t3x128(:,:,494), nhel, den(598))
    call cont_QA(nsync, wf8(:,104), wf16(:,250), A(:,495), n3(:,893), t3x128(:,:,495), nhel, den(599))
    call cont_VV(nsync, wf8(:,6), wf16(:,268), A(:,496), n3(:,894), t3x128(:,:,496), nhel, den(600))
    call cont_QA(nsync, wf8(:,98), wf16(:,269), A(:,497), n3(:,895), t3x128(:,:,497), nhel, den(601))
    call cont_QA(nsync, wf8(:,98), wf16(:,270), A(:,498), n3(:,896), t3x128(:,:,498), nhel, den(602))
    call cont_QA(nsync, wf8(:,106), wf16(:,243), A(:,499), n3(:,897), t3x128(:,:,499), nhel, den(603))
    call cont_VV(nsync, wf8(:,2), wf16(:,271), A(:,500), n3(:,898), t3x128(:,:,500), nhel, den(605))
    call cont_QA(nsync, wf8(:,127), wf16(:,258), A(:,501), n3(:,899), t3x128(:,:,501), nhel, den(606))
    call cont_QA(nsync, wf8(:,50), wf16(:,222), A(:,502), n3(:,900), t3x128(:,:,502), nhel, den(607))
    call cont_VV(nsync, wf8(:,46), wf16(:,59), A(:,503), n3(:,901), t3x128(:,:,503), nhel, den(608))
    call cont_QA(nsync, wf8(:,108), wf16(:,243), A(:,504), n3(:,902), t3x128(:,:,504), nhel, den(609))
    call cont_QA(nsync, wf8(:,112), wf16(:,272), A(:,505), n3(:,903), t3x128(:,:,505), nhel, den(610))
    call cont_QA(nsync, wf8(:,127), wf16(:,260), A(:,506), n3(:,904), t3x128(:,:,506), nhel, den(611))
    call cont_VV(nsync, wf8(:,6), wf16(:,273), A(:,507), n3(:,905), t3x128(:,:,507), nhel, den(612))
    call cont_VV(nsync, wf8(:,2), wf16(:,274), A(:,508), n3(:,906), t3x128(:,:,508), nhel, den(613))
    call cont_QA(nsync, wf8(:,112), wf16(:,275), A(:,509), n3(:,907), t3x128(:,:,509), nhel, den(614))
    call cont_VV(nsync, wf8(:,6), wf16(:,276), A(:,510), n3(:,908), t3x128(:,:,510), nhel, den(615))
    call cont_VV(nsync, wf8(:,47), wf16(:,57), A(:,511), n3(:,909), t3x128(:,:,511), nhel, den(616))
    call cont_QA(nsync, wf16(:,174), wf8(:,130), A(:,512), n3(:,910), t3x128(:,:,512), nhel, den(617))
    call cont_QA(nsync, wf8(:,129), wf16(:,258), A(:,513), n3(:,911), t3x128(:,:,513), nhel, den(618))
    call cont_QA(nsync, wf8(:,50), wf16(:,228), A(:,514), n3(:,912), t3x128(:,:,514), nhel, den(619))
    call cont_VV(nsync, wf8(:,48), wf16(:,57), A(:,515), n3(:,913), t3x128(:,:,515), nhel, den(620))
    call cont_QA(nsync, wf8(:,110), wf16(:,246), A(:,516), n3(:,914), t3x128(:,:,516), nhel, den(621))
    call cont_VV(nsync, wf8(:,52), wf16(:,277), A(:,517), n3(:,915), t3x128(:,:,517), nhel, den(622))
    call cont_QA(nsync, wf8(:,129), wf16(:,260), A(:,518), n3(:,916), t3x128(:,:,518), nhel, den(623))
    call cont_VV(nsync, wf8(:,6), wf16(:,278), A(:,519), n3(:,917), t3x128(:,:,519), nhel, den(624))
    call cont_VV(nsync, wf8(:,52), wf16(:,279), A(:,520), n3(:,918), t3x128(:,:,520), nhel, den(625))
    call cont_VV(nsync, wf8(:,6), wf16(:,280), A(:,521), n3(:,919), t3x128(:,:,521), nhel, den(626))
    call cont_QA(nsync, wf16(:,179), wf8(:,130), A(:,522), n3(:,920), t3x128(:,:,522), nhel, den(627))
    call cont_VV(nsync, wf8(:,2), wf16(:,281), A(:,523), n3(:,921), t3x128(:,:,523), nhel, den(628))
    call cont_VV(nsync, wf8(:,4), wf16(:,282), A(:,524), n3(:,922), t3x128(:,:,524), nhel, den(629))
    call cont_QA(nsync, wf8(:,106), wf16(:,252), A(:,525), n3(:,923), t3x128(:,:,525), nhel, den(630))
    call cont_VV(nsync, wf8(:,4), wf16(:,283), A(:,526), n3(:,924), t3x128(:,:,526), nhel, den(631))
    call cont_QA(nsync, wf8(:,100), wf16(:,269), A(:,527), n3(:,925), t3x128(:,:,527), nhel, den(632))
    call cont_QA(nsync, wf8(:,100), wf16(:,270), A(:,528), n3(:,926), t3x128(:,:,528), nhel, den(633))
    call cont_QA(nsync, wf8(:,114), wf16(:,272), A(:,529), n3(:,927), t3x128(:,:,529), nhel, den(634))
    call cont_QA(nsync, wf8(:,123), wf16(:,259), A(:,530), n3(:,928), t3x128(:,:,530), nhel, den(635))
    call cont_VV(nsync, wf8(:,4), wf16(:,284), A(:,531), n3(:,929), t3x128(:,:,531), nhel, den(636))
    call cont_VV(nsync, wf8(:,2), wf16(:,285), A(:,532), n3(:,930), t3x128(:,:,532), nhel, den(637))
    call cont_QA(nsync, wf8(:,114), wf16(:,275), A(:,533), n3(:,931), t3x128(:,:,533), nhel, den(638))
    call cont_VV(nsync, wf8(:,4), wf16(:,286), A(:,534), n3(:,932), t3x128(:,:,534), nhel, den(639))
    call cont_VV(nsync, wf8(:,53), wf16(:,277), A(:,535), n3(:,933), t3x128(:,:,535), nhel, den(640))
    call cont_QA(nsync, wf8(:,125), wf16(:,259), A(:,536), n3(:,934), t3x128(:,:,536), nhel, den(641))
    call cont_VV(nsync, wf8(:,4), wf16(:,287), A(:,537), n3(:,935), t3x128(:,:,537), nhel, den(642))
    call cont_VV(nsync, wf8(:,53), wf16(:,279), A(:,538), n3(:,936), t3x128(:,:,538), nhel, den(643))
    call cont_VV(nsync, wf8(:,4), wf16(:,288), A(:,539), n3(:,937), t3x128(:,:,539), nhel, den(644))
    call cont_QA(nsync, wf16(:,188), wf8(:,130), A(:,540), n3(:,938), t3x128(:,:,540), nhel, den(645))
    call cont_VV(nsync, wf8(:,54), wf16(:,277), A(:,541), n3(:,939), t3x128(:,:,541), nhel, den(646))
    call cont_QA(nsync, wf8(:,117), wf16(:,272), A(:,542), n3(:,940), t3x128(:,:,542), nhel, den(647))
    call cont_VV(nsync, wf8(:,54), wf16(:,279), A(:,543), n3(:,941), t3x128(:,:,543), nhel, den(648))
    call cont_VV(nsync, wf8(:,2), wf16(:,289), A(:,544), n3(:,942), t3x128(:,:,544), nhel, den(649))
    call cont_VV(nsync, wf8(:,2), wf16(:,290), A(:,545), n3(:,943), t3x128(:,:,545), nhel, den(650))
    call cont_QA(nsync, wf16(:,191), wf8(:,130), A(:,546), n3(:,944), t3x128(:,:,546), nhel, den(651))
    call cont_VV(nsync, wf8(:,25), wf16(:,215), A(:,547), n3(:,945), t3x128(:,:,547), nhel, den(652))
    call cont_VV(nsync, wf8(:,12), wf16(:,247), A(:,548), n3(:,946), t3x128(:,:,548), nhel, den(653))
    call cont_VV(nsync, wf8(:,43), wf16(:,93), A(:,549), n3(:,947), t3x128(:,:,549), nhel, den(654))
    call cont_VV(nsync, wf8(:,36), wf16(:,142), A(:,550), n3(:,948), t3x128(:,:,550), nhel, den(655))
    call cont_VV(nsync, wf8(:,12), wf16(:,248), A(:,551), n3(:,949), t3x128(:,:,551), nhel, den(656))
    call cont_QA(nsync, wf8(:,67), wf16(:,291), A(:,552), n3(:,950), t3x128(:,:,552), nhel, den(657))
    call cont_VV(nsync, wf8(:,25), wf16(:,217), A(:,553), n3(:,951), t3x128(:,:,553), nhel, den(658))
    call cont_QA(nsync, wf8(:,67), wf16(:,292), A(:,554), n3(:,952), t3x128(:,:,554), nhel, den(659))
    call cont_QA(nsync, wf8(:,93), wf16(:,293), A(:,555), n3(:,953), t3x128(:,:,555), nhel, den(660))
    call cont_QA(nsync, wf8(:,93), wf16(:,294), A(:,556), n3(:,954), t3x128(:,:,556), nhel, den(661))
    call cont_VV(nsync, wf8(:,25), wf16(:,221), A(:,557), n3(:,955), t3x128(:,:,557), nhel, den(662))
    call cont_VV(nsync, wf8(:,14), wf16(:,244), A(:,558), n3(:,956), t3x128(:,:,558), nhel, den(663))
    call cont_VV(nsync, wf8(:,37), wf16(:,142), A(:,559), n3(:,957), t3x128(:,:,559), nhel, den(664))
    call cont_VV(nsync, wf8(:,15), wf16(:,244), A(:,560), n3(:,958), t3x128(:,:,560), nhel, den(665))
    call cont_VV(nsync, wf8(:,25), wf16(:,224), A(:,561), n3(:,959), t3x128(:,:,561), nhel, den(666))
    call cont_QA(nsync, wf8(:,112), wf16(:,295), A(:,562), n3(:,960), t3x128(:,:,562), nhel, den(667))
    call cont_QA(nsync, wf8(:,93), wf16(:,296), A(:,563), n3(:,961), t3x128(:,:,563), nhel, den(668))
    call cont_VV(nsync, wf8(:,43), wf16(:,100), A(:,564), n3(:,962), t3x128(:,:,564), nhel, den(669))
    call cont_VV(nsync, wf8(:,38), wf16(:,139), A(:,565), n3(:,963), t3x128(:,:,565), nhel, den(670))
    call cont_VV(nsync, wf8(:,39), wf16(:,139), A(:,566), n3(:,964), t3x128(:,:,566), nhel, den(671))
    call cont_VV(nsync, wf8(:,13), wf16(:,247), A(:,567), n3(:,965), t3x128(:,:,567), nhel, den(672))
    call cont_QA(nsync, wf8(:,58), wf16(:,297), A(:,568), n3(:,966), t3x128(:,:,568), nhel, den(673))
    call cont_VV(nsync, wf8(:,43), wf16(:,103), A(:,569), n3(:,967), t3x128(:,:,569), nhel, den(674))
    call cont_QA(nsync, wf8(:,93), wf16(:,298), A(:,570), n3(:,968), t3x128(:,:,570), nhel, den(675))
    call cont_VV(nsync, wf8(:,14), wf16(:,249), A(:,571), n3(:,969), t3x128(:,:,571), nhel, den(676))
    call cont_QA(nsync, wf8(:,71), wf16(:,291), A(:,572), n3(:,970), t3x128(:,:,572), nhel, den(677))
    call cont_VV(nsync, wf8(:,25), wf16(:,233), A(:,573), n3(:,971), t3x128(:,:,573), nhel, den(678))
    call cont_QA(nsync, wf8(:,71), wf16(:,292), A(:,574), n3(:,972), t3x128(:,:,574), nhel, den(679))
    call cont_QA(nsync, wf8(:,95), wf16(:,299), A(:,575), n3(:,973), t3x128(:,:,575), nhel, den(680))
    call cont_QA(nsync, wf8(:,95), wf16(:,300), A(:,576), n3(:,974), t3x128(:,:,576), nhel, den(681))
    call cont_VV(nsync, wf8(:,25), wf16(:,236), A(:,577), n3(:,975), t3x128(:,:,577), nhel, den(682))
    call cont_QA(nsync, wf8(:,114), wf16(:,295), A(:,578), n3(:,976), t3x128(:,:,578), nhel, den(683))
    call cont_QA(nsync, wf8(:,95), wf16(:,301), A(:,579), n3(:,977), t3x128(:,:,579), nhel, den(684))
    call cont_QA(nsync, wf8(:,62), wf16(:,297), A(:,580), n3(:,978), t3x128(:,:,580), nhel, den(685))
    call cont_VV(nsync, wf8(:,43), wf16(:,117), A(:,581), n3(:,979), t3x128(:,:,581), nhel, den(686))
    call cont_QA(nsync, wf8(:,95), wf16(:,302), A(:,582), n3(:,980), t3x128(:,:,582), nhel, den(687))
    call cont_QA(nsync, wf8(:,65), wf16(:,297), A(:,583), n3(:,981), t3x128(:,:,583), nhel, den(688))
    call cont_VV(nsync, wf8(:,43), wf16(:,125), A(:,584), n3(:,982), t3x128(:,:,584), nhel, den(689))
    call cont_VV(nsync, wf8(:,25), wf16(:,241), A(:,585), n3(:,983), t3x128(:,:,585), nhel, den(690))
    call cont_VV(nsync, wf8(:,25), wf16(:,242), A(:,586), n3(:,984), t3x128(:,:,586), nhel, den(691))
    call cont_VV(nsync, wf8(:,27), wf16(:,195), A(:,587), n3(:,985), t3x128(:,:,587), nhel, den(692))
    call cont_VV(nsync, wf8(:,10), wf16(:,265), A(:,588), n3(:,986), t3x128(:,:,588), nhel, den(693))
    call cont_VV(nsync, wf8(:,45), wf16(:,72), A(:,589), n3(:,987), t3x128(:,:,589), nhel, den(694))
    call cont_VV(nsync, wf8(:,34), wf16(:,161), A(:,590), n3(:,988), t3x128(:,:,590), nhel, den(695))
    call cont_VV(nsync, wf8(:,10), wf16(:,266), A(:,591), n3(:,989), t3x128(:,:,591), nhel, den(696))
    call cont_QA(nsync, wf8(:,56), wf16(:,303), A(:,592), n3(:,990), t3x128(:,:,592), nhel, den(697))
    call cont_VV(nsync, wf8(:,27), wf16(:,199), A(:,593), n3(:,991), t3x128(:,:,593), nhel, den(698))
    call cont_QA(nsync, wf8(:,56), wf16(:,304), A(:,594), n3(:,992), t3x128(:,:,594), nhel, den(699))
    call cont_QA(nsync, wf8(:,98), wf16(:,305), A(:,595), n3(:,993), t3x128(:,:,595), nhel, den(700))
    call cont_QA(nsync, wf8(:,98), wf16(:,306), A(:,596), n3(:,994), t3x128(:,:,596), nhel, den(701))
    call cont_VV(nsync, wf8(:,29), wf16(:,192), A(:,597), n3(:,995), t3x128(:,:,597), nhel, den(702))
    call cont_VV(nsync, wf8(:,10), wf16(:,271), A(:,598), n3(:,996), t3x128(:,:,598), nhel, den(703))
    call cont_VV(nsync, wf8(:,46), wf16(:,72), A(:,599), n3(:,997), t3x128(:,:,599), nhel, den(704))
    call cont_VV(nsync, wf8(:,30), wf16(:,192), A(:,600), n3(:,998), t3x128(:,:,600), nhel, den(705))
    call cont_QA(nsync, wf8(:,56), wf16(:,307), A(:,601), n3(:,999), t3x128(:,:,601), nhel, den(706))
    call cont_VV(nsync, wf8(:,10), wf16(:,274), A(:,602), n3(:,1000), t3x128(:,:,602), nhel, den(707))
    call cont_QA(nsync, wf8(:,112), wf16(:,308), A(:,603), n3(:,1001), t3x128(:,:,603), nhel, den(708))
    call cont_VV(nsync, wf8(:,47), wf16(:,69), A(:,604), n3(:,1002), t3x128(:,:,604), nhel, den(709))
    call cont_VV(nsync, wf8(:,34), wf16(:,168), A(:,605), n3(:,1003), t3x128(:,:,605), nhel, den(710))
    call cont_VV(nsync, wf8(:,48), wf16(:,69), A(:,606), n3(:,1004), t3x128(:,:,606), nhel, den(711))
    call cont_VV(nsync, wf8(:,28), wf16(:,195), A(:,607), n3(:,1005), t3x128(:,:,607), nhel, den(712))
    call cont_QA(nsync, wf8(:,56), wf16(:,309), A(:,608), n3(:,1006), t3x128(:,:,608), nhel, den(713))
    call cont_QA(nsync, wf8(:,58), wf16(:,310), A(:,609), n3(:,1007), t3x128(:,:,609), nhel, den(714))
    call cont_VV(nsync, wf8(:,34), wf16(:,171), A(:,610), n3(:,1008), t3x128(:,:,610), nhel, den(715))
    call cont_VV(nsync, wf8(:,10), wf16(:,281), A(:,611), n3(:,1009), t3x128(:,:,611), nhel, den(716))
    call cont_QA(nsync, wf8(:,60), wf16(:,311), A(:,612), n3(:,1010), t3x128(:,:,612), nhel, den(717))
    call cont_VV(nsync, wf8(:,29), wf16(:,201), A(:,613), n3(:,1011), t3x128(:,:,613), nhel, den(718))
    call cont_QA(nsync, wf8(:,60), wf16(:,312), A(:,614), n3(:,1012), t3x128(:,:,614), nhel, den(719))
    call cont_QA(nsync, wf8(:,100), wf16(:,305), A(:,615), n3(:,1013), t3x128(:,:,615), nhel, den(720))
    call cont_QA(nsync, wf8(:,100), wf16(:,306), A(:,616), n3(:,1014), t3x128(:,:,616), nhel, den(721))
    call cont_QA(nsync, wf8(:,60), wf16(:,313), A(:,617), n3(:,1015), t3x128(:,:,617), nhel, den(722))
    call cont_VV(nsync, wf8(:,10), wf16(:,285), A(:,618), n3(:,1016), t3x128(:,:,618), nhel, den(723))
    call cont_QA(nsync, wf8(:,114), wf16(:,308), A(:,619), n3(:,1017), t3x128(:,:,619), nhel, den(724))
    call cont_QA(nsync, wf8(:,60), wf16(:,314), A(:,620), n3(:,1018), t3x128(:,:,620), nhel, den(725))
    call cont_QA(nsync, wf8(:,62), wf16(:,310), A(:,621), n3(:,1019), t3x128(:,:,621), nhel, den(726))
    call cont_VV(nsync, wf8(:,34), wf16(:,184), A(:,622), n3(:,1020), t3x128(:,:,622), nhel, den(727))
    call cont_QA(nsync, wf8(:,65), wf16(:,310), A(:,623), n3(:,1021), t3x128(:,:,623), nhel, den(728))
    call cont_VV(nsync, wf8(:,10), wf16(:,289), A(:,624), n3(:,1022), t3x128(:,:,624), nhel, den(729))
    call cont_VV(nsync, wf8(:,10), wf16(:,290), A(:,625), n3(:,1023), t3x128(:,:,625), nhel, den(730))
    call cont_VV(nsync, wf8(:,34), wf16(:,190), A(:,626), n3(:,1024), t3x128(:,:,626), nhel, den(731))
    call cont_VV(nsync, wf8(:,27), wf16(:,206), A(:,627), n3(:,1025), t3x128(:,:,627), nhel, den(732))
    call cont_VV(nsync, wf8(:,14), wf16(:,255), A(:,628), n3(:,1026), t3x128(:,:,628), nhel, den(733))
    call cont_VV(nsync, wf8(:,35), wf16(:,161), A(:,629), n3(:,1027), t3x128(:,:,629), nhel, den(734))
    call cont_VV(nsync, wf8(:,15), wf16(:,255), A(:,630), n3(:,1028), t3x128(:,:,630), nhel, den(735))
    call cont_VV(nsync, wf8(:,27), wf16(:,211), A(:,631), n3(:,1029), t3x128(:,:,631), nhel, den(736))
    call cont_QA(nsync, wf8(:,119), wf16(:,315), A(:,632), n3(:,1030), t3x128(:,:,632), nhel, den(737))
    call cont_QA(nsync, wf8(:,98), wf16(:,316), A(:,633), n3(:,1031), t3x128(:,:,633), nhel, den(738))
    call cont_VV(nsync, wf8(:,29), wf16(:,203), A(:,634), n3(:,1032), t3x128(:,:,634), nhel, den(739))
    call cont_VV(nsync, wf8(:,12), wf16(:,257), A(:,635), n3(:,1033), t3x128(:,:,635), nhel, den(740))
    call cont_VV(nsync, wf8(:,44), wf16(:,93), A(:,636), n3(:,1034), t3x128(:,:,636), nhel, den(741))
    call cont_VV(nsync, wf8(:,30), wf16(:,203), A(:,637), n3(:,1035), t3x128(:,:,637), nhel, den(742))
    call cont_QA(nsync, wf8(:,67), wf16(:,317), A(:,638), n3(:,1036), t3x128(:,:,638), nhel, den(743))
    call cont_VV(nsync, wf8(:,12), wf16(:,262), A(:,639), n3(:,1037), t3x128(:,:,639), nhel, den(744))
    call cont_QA(nsync, wf8(:,119), wf16(:,318), A(:,640), n3(:,1038), t3x128(:,:,640), nhel, den(745))
    call cont_VV(nsync, wf8(:,35), wf16(:,168), A(:,641), n3(:,1039), t3x128(:,:,641), nhel, den(746))
    call cont_VV(nsync, wf8(:,13), wf16(:,257), A(:,642), n3(:,1040), t3x128(:,:,642), nhel, den(747))
    call cont_VV(nsync, wf8(:,44), wf16(:,100), A(:,643), n3(:,1041), t3x128(:,:,643), nhel, den(748))
    call cont_VV(nsync, wf8(:,28), wf16(:,206), A(:,644), n3(:,1042), t3x128(:,:,644), nhel, den(749))
    call cont_QA(nsync, wf8(:,58), wf16(:,319), A(:,645), n3(:,1043), t3x128(:,:,645), nhel, den(750))
    call cont_QA(nsync, wf8(:,119), wf16(:,320), A(:,646), n3(:,1044), t3x128(:,:,646), nhel, den(751))
    call cont_QA(nsync, wf8(:,58), wf16(:,321), A(:,647), n3(:,1045), t3x128(:,:,647), nhel, den(752))
    call cont_QA(nsync, wf8(:,119), wf16(:,322), A(:,648), n3(:,1046), t3x128(:,:,648), nhel, den(753))
    call cont_VV(nsync, wf8(:,13), wf16(:,262), A(:,649), n3(:,1047), t3x128(:,:,649), nhel, den(754))
    call cont_VV(nsync, wf8(:,35), wf16(:,171), A(:,650), n3(:,1048), t3x128(:,:,650), nhel, den(755))
    call cont_VV(nsync, wf8(:,29), wf16(:,213), A(:,651), n3(:,1049), t3x128(:,:,651), nhel, den(756))
    call cont_QA(nsync, wf8(:,121), wf16(:,323), A(:,652), n3(:,1050), t3x128(:,:,652), nhel, den(757))
    call cont_QA(nsync, wf8(:,100), wf16(:,316), A(:,653), n3(:,1051), t3x128(:,:,653), nhel, den(758))
    call cont_QA(nsync, wf8(:,71), wf16(:,317), A(:,654), n3(:,1052), t3x128(:,:,654), nhel, den(759))
    call cont_VV(nsync, wf8(:,14), wf16(:,261), A(:,655), n3(:,1053), t3x128(:,:,655), nhel, den(760))
    call cont_QA(nsync, wf8(:,121), wf16(:,324), A(:,656), n3(:,1054), t3x128(:,:,656), nhel, den(761))
    call cont_QA(nsync, wf8(:,62), wf16(:,319), A(:,657), n3(:,1055), t3x128(:,:,657), nhel, den(762))
    call cont_QA(nsync, wf8(:,121), wf16(:,325), A(:,658), n3(:,1056), t3x128(:,:,658), nhel, den(763))
    call cont_QA(nsync, wf8(:,62), wf16(:,321), A(:,659), n3(:,1057), t3x128(:,:,659), nhel, den(764))
    call cont_QA(nsync, wf8(:,121), wf16(:,326), A(:,660), n3(:,1058), t3x128(:,:,660), nhel, den(765))
    call cont_VV(nsync, wf8(:,15), wf16(:,261), A(:,661), n3(:,1059), t3x128(:,:,661), nhel, den(766))
    call cont_VV(nsync, wf8(:,35), wf16(:,184), A(:,662), n3(:,1060), t3x128(:,:,662), nhel, den(767))
    call cont_QA(nsync, wf8(:,65), wf16(:,319), A(:,663), n3(:,1061), t3x128(:,:,663), nhel, den(768))
    call cont_QA(nsync, wf8(:,65), wf16(:,321), A(:,664), n3(:,1062), t3x128(:,:,664), nhel, den(769))
    call cont_QA(nsync, wf8(:,75), wf16(:,317), A(:,665), n3(:,1063), t3x128(:,:,665), nhel, den(770))
    call cont_VV(nsync, wf8(:,35), wf16(:,190), A(:,666), n3(:,1064), t3x128(:,:,666), nhel, den(771))
    call cont_VV(nsync, wf8(:,45), wf16(:,84), A(:,667), n3(:,1065), t3x128(:,:,667), nhel, den(772))
    call cont_VV(nsync, wf8(:,38), wf16(:,151), A(:,668), n3(:,1066), t3x128(:,:,668), nhel, den(773))
    call cont_VV(nsync, wf8(:,39), wf16(:,151), A(:,669), n3(:,1067), t3x128(:,:,669), nhel, den(774))
    call cont_VV(nsync, wf8(:,11), wf16(:,265), A(:,670), n3(:,1068), t3x128(:,:,670), nhel, den(775))
    call cont_QA(nsync, wf8(:,69), wf16(:,327), A(:,671), n3(:,1069), t3x128(:,:,671), nhel, den(776))
    call cont_VV(nsync, wf8(:,45), wf16(:,89), A(:,672), n3(:,1070), t3x128(:,:,672), nhel, den(777))
    call cont_QA(nsync, wf8(:,98), wf16(:,328), A(:,673), n3(:,1071), t3x128(:,:,673), nhel, den(778))
    call cont_VV(nsync, wf8(:,47), wf16(:,81), A(:,674), n3(:,1072), t3x128(:,:,674), nhel, den(779))
    call cont_VV(nsync, wf8(:,36), wf16(:,153), A(:,675), n3(:,1073), t3x128(:,:,675), nhel, den(780))
    call cont_VV(nsync, wf8(:,48), wf16(:,81), A(:,676), n3(:,1074), t3x128(:,:,676), nhel, den(781))
    call cont_VV(nsync, wf8(:,26), wf16(:,215), A(:,677), n3(:,1075), t3x128(:,:,677), nhel, den(782))
    call cont_QA(nsync, wf8(:,67), wf16(:,329), A(:,678), n3(:,1076), t3x128(:,:,678), nhel, den(783))
    call cont_QA(nsync, wf8(:,69), wf16(:,330), A(:,679), n3(:,1077), t3x128(:,:,679), nhel, den(784))
    call cont_VV(nsync, wf8(:,36), wf16(:,158), A(:,680), n3(:,1078), t3x128(:,:,680), nhel, den(785))
    call cont_VV(nsync, wf8(:,37), wf16(:,153), A(:,681), n3(:,1079), t3x128(:,:,681), nhel, den(786))
    call cont_VV(nsync, wf8(:,11), wf16(:,271), A(:,682), n3(:,1080), t3x128(:,:,682), nhel, den(787))
    call cont_VV(nsync, wf8(:,46), wf16(:,84), A(:,683), n3(:,1081), t3x128(:,:,683), nhel, den(788))
    call cont_VV(nsync, wf8(:,26), wf16(:,221), A(:,684), n3(:,1082), t3x128(:,:,684), nhel, den(789))
    call cont_QA(nsync, wf8(:,69), wf16(:,331), A(:,685), n3(:,1083), t3x128(:,:,685), nhel, den(790))
    call cont_QA(nsync, wf8(:,112), wf16(:,332), A(:,686), n3(:,1084), t3x128(:,:,686), nhel, den(791))
    call cont_QA(nsync, wf8(:,69), wf16(:,333), A(:,687), n3(:,1085), t3x128(:,:,687), nhel, den(792))
    call cont_QA(nsync, wf8(:,112), wf16(:,334), A(:,688), n3(:,1086), t3x128(:,:,688), nhel, den(793))
    call cont_VV(nsync, wf8(:,11), wf16(:,274), A(:,689), n3(:,1087), t3x128(:,:,689), nhel, den(794))
    call cont_VV(nsync, wf8(:,37), wf16(:,158), A(:,690), n3(:,1088), t3x128(:,:,690), nhel, den(795))
    call cont_QA(nsync, wf8(:,73), wf16(:,335), A(:,691), n3(:,1089), t3x128(:,:,691), nhel, den(796))
    call cont_VV(nsync, wf8(:,47), wf16(:,91), A(:,692), n3(:,1090), t3x128(:,:,692), nhel, den(797))
    call cont_QA(nsync, wf8(:,100), wf16(:,328), A(:,693), n3(:,1091), t3x128(:,:,693), nhel, den(798))
    call cont_QA(nsync, wf8(:,71), wf16(:,329), A(:,694), n3(:,1092), t3x128(:,:,694), nhel, den(799))
    call cont_QA(nsync, wf8(:,73), wf16(:,336), A(:,695), n3(:,1093), t3x128(:,:,695), nhel, den(800))
    call cont_VV(nsync, wf8(:,38), wf16(:,157), A(:,696), n3(:,1094), t3x128(:,:,696), nhel, den(801))
    call cont_QA(nsync, wf8(:,73), wf16(:,337), A(:,697), n3(:,1095), t3x128(:,:,697), nhel, den(802))
    call cont_QA(nsync, wf8(:,114), wf16(:,332), A(:,698), n3(:,1096), t3x128(:,:,698), nhel, den(803))
    call cont_QA(nsync, wf8(:,73), wf16(:,338), A(:,699), n3(:,1097), t3x128(:,:,699), nhel, den(804))
    call cont_QA(nsync, wf8(:,114), wf16(:,334), A(:,700), n3(:,1098), t3x128(:,:,700), nhel, den(805))
    call cont_VV(nsync, wf8(:,11), wf16(:,285), A(:,701), n3(:,1099), t3x128(:,:,701), nhel, den(806))
    call cont_VV(nsync, wf8(:,39), wf16(:,157), A(:,702), n3(:,1100), t3x128(:,:,702), nhel, den(807))
    call cont_QA(nsync, wf8(:,117), wf16(:,334), A(:,703), n3(:,1101), t3x128(:,:,703), nhel, den(808))
    call cont_QA(nsync, wf8(:,117), wf16(:,332), A(:,704), n3(:,1102), t3x128(:,:,704), nhel, den(809))
    call cont_QA(nsync, wf8(:,75), wf16(:,329), A(:,705), n3(:,1103), t3x128(:,:,705), nhel, den(810))
    call cont_VV(nsync, wf8(:,11), wf16(:,290), A(:,706), n3(:,1104), t3x128(:,:,706), nhel, den(811))
    call cont_VV(nsync, wf8(:,14), wf16(:,267), A(:,707), n3(:,1105), t3x128(:,:,707), nhel, den(812))
    call cont_QA(nsync, wf8(:,83), wf16(:,303), A(:,708), n3(:,1106), t3x128(:,:,708), nhel, den(813))
    call cont_VV(nsync, wf8(:,27), wf16(:,234), A(:,709), n3(:,1107), t3x128(:,:,709), nhel, den(814))
    call cont_QA(nsync, wf8(:,83), wf16(:,304), A(:,710), n3(:,1108), t3x128(:,:,710), nhel, den(815))
    call cont_QA(nsync, wf8(:,104), wf16(:,299), A(:,711), n3(:,1109), t3x128(:,:,711), nhel, den(816))
    call cont_QA(nsync, wf8(:,104), wf16(:,300), A(:,712), n3(:,1110), t3x128(:,:,712), nhel, den(817))
    call cont_VV(nsync, wf8(:,27), wf16(:,237), A(:,713), n3(:,1111), t3x128(:,:,713), nhel, den(818))
    call cont_QA(nsync, wf8(:,123), wf16(:,315), A(:,714), n3(:,1112), t3x128(:,:,714), nhel, den(819))
    call cont_QA(nsync, wf8(:,104), wf16(:,301), A(:,715), n3(:,1113), t3x128(:,:,715), nhel, den(820))
    call cont_QA(nsync, wf8(:,79), wf16(:,327), A(:,716), n3(:,1114), t3x128(:,:,716), nhel, den(821))
    call cont_VV(nsync, wf8(:,45), wf16(:,118), A(:,717), n3(:,1115), t3x128(:,:,717), nhel, den(822))
    call cont_QA(nsync, wf8(:,104), wf16(:,302), A(:,718), n3(:,1116), t3x128(:,:,718), nhel, den(823))
    call cont_QA(nsync, wf8(:,81), wf16(:,327), A(:,719), n3(:,1117), t3x128(:,:,719), nhel, den(824))
    call cont_VV(nsync, wf8(:,45), wf16(:,121), A(:,720), n3(:,1118), t3x128(:,:,720), nhel, den(825))
    call cont_VV(nsync, wf8(:,27), wf16(:,240), A(:,721), n3(:,1119), t3x128(:,:,721), nhel, den(826))
    call cont_VV(nsync, wf8(:,27), wf16(:,239), A(:,722), n3(:,1120), t3x128(:,:,722), nhel, den(827))
    call cont_VV(nsync, wf8(:,12), wf16(:,282), A(:,723), n3(:,1121), t3x128(:,:,723), nhel, den(828))
    call cont_QA(nsync, wf8(:,77), wf16(:,311), A(:,724), n3(:,1122), t3x128(:,:,724), nhel, den(829))
    call cont_VV(nsync, wf8(:,29), wf16(:,219), A(:,725), n3(:,1123), t3x128(:,:,725), nhel, den(830))
    call cont_QA(nsync, wf8(:,77), wf16(:,312), A(:,726), n3(:,1124), t3x128(:,:,726), nhel, den(831))
    call cont_QA(nsync, wf8(:,106), wf16(:,293), A(:,727), n3(:,1125), t3x128(:,:,727), nhel, den(832))
    call cont_QA(nsync, wf8(:,106), wf16(:,294), A(:,728), n3(:,1126), t3x128(:,:,728), nhel, den(833))
    call cont_QA(nsync, wf8(:,77), wf16(:,313), A(:,729), n3(:,1127), t3x128(:,:,729), nhel, den(834))
    call cont_VV(nsync, wf8(:,12), wf16(:,284), A(:,730), n3(:,1128), t3x128(:,:,730), nhel, den(835))
    call cont_QA(nsync, wf8(:,123), wf16(:,318), A(:,731), n3(:,1129), t3x128(:,:,731), nhel, den(836))
    call cont_QA(nsync, wf8(:,77), wf16(:,314), A(:,732), n3(:,1130), t3x128(:,:,732), nhel, den(837))
    call cont_QA(nsync, wf8(:,79), wf16(:,330), A(:,733), n3(:,1131), t3x128(:,:,733), nhel, den(838))
    call cont_VV(nsync, wf8(:,36), wf16(:,183), A(:,734), n3(:,1132), t3x128(:,:,734), nhel, den(839))
    call cont_QA(nsync, wf8(:,81), wf16(:,330), A(:,735), n3(:,1133), t3x128(:,:,735), nhel, den(840))
    call cont_VV(nsync, wf8(:,12), wf16(:,288), A(:,736), n3(:,1134), t3x128(:,:,736), nhel, den(841))
    call cont_VV(nsync, wf8(:,12), wf16(:,287), A(:,737), n3(:,1135), t3x128(:,:,737), nhel, den(842))
    call cont_VV(nsync, wf8(:,36), wf16(:,186), A(:,738), n3(:,1136), t3x128(:,:,738), nhel, den(843))
    call cont_VV(nsync, wf8(:,29), wf16(:,226), A(:,739), n3(:,1137), t3x128(:,:,739), nhel, den(844))
    call cont_QA(nsync, wf8(:,127), wf16(:,323), A(:,740), n3(:,1138), t3x128(:,:,740), nhel, den(845))
    call cont_QA(nsync, wf8(:,106), wf16(:,296), A(:,741), n3(:,1139), t3x128(:,:,741), nhel, den(846))
    call cont_QA(nsync, wf8(:,83), wf16(:,307), A(:,742), n3(:,1140), t3x128(:,:,742), nhel, den(847))
    call cont_VV(nsync, wf8(:,14), wf16(:,273), A(:,743), n3(:,1141), t3x128(:,:,743), nhel, den(848))
    call cont_QA(nsync, wf8(:,127), wf16(:,324), A(:,744), n3(:,1142), t3x128(:,:,744), nhel, den(849))
    call cont_QA(nsync, wf8(:,79), wf16(:,331), A(:,745), n3(:,1143), t3x128(:,:,745), nhel, den(850))
    call cont_QA(nsync, wf8(:,127), wf16(:,325), A(:,746), n3(:,1144), t3x128(:,:,746), nhel, den(851))
    call cont_QA(nsync, wf8(:,79), wf16(:,333), A(:,747), n3(:,1145), t3x128(:,:,747), nhel, den(852))
    call cont_QA(nsync, wf8(:,127), wf16(:,326), A(:,748), n3(:,1146), t3x128(:,:,748), nhel, den(853))
    call cont_VV(nsync, wf8(:,15), wf16(:,273), A(:,749), n3(:,1147), t3x128(:,:,749), nhel, den(854))
    call cont_VV(nsync, wf8(:,37), wf16(:,183), A(:,750), n3(:,1148), t3x128(:,:,750), nhel, den(855))
    call cont_QA(nsync, wf8(:,81), wf16(:,331), A(:,751), n3(:,1149), t3x128(:,:,751), nhel, den(856))
    call cont_QA(nsync, wf8(:,81), wf16(:,333), A(:,752), n3(:,1150), t3x128(:,:,752), nhel, den(857))
    call cont_QA(nsync, wf8(:,87), wf16(:,307), A(:,753), n3(:,1151), t3x128(:,:,753), nhel, den(858))
    call cont_VV(nsync, wf8(:,37), wf16(:,186), A(:,754), n3(:,1152), t3x128(:,:,754), nhel, den(859))
    call cont_QA(nsync, wf8(:,85), wf16(:,335), A(:,755), n3(:,1153), t3x128(:,:,755), nhel, den(860))
    call cont_VV(nsync, wf8(:,47), wf16(:,105), A(:,756), n3(:,1154), t3x128(:,:,756), nhel, den(861))
    call cont_QA(nsync, wf8(:,106), wf16(:,298), A(:,757), n3(:,1155), t3x128(:,:,757), nhel, den(862))
    call cont_QA(nsync, wf8(:,83), wf16(:,309), A(:,758), n3(:,1156), t3x128(:,:,758), nhel, den(863))
    call cont_QA(nsync, wf8(:,85), wf16(:,336), A(:,759), n3(:,1157), t3x128(:,:,759), nhel, den(864))
    call cont_VV(nsync, wf8(:,38), wf16(:,170), A(:,760), n3(:,1158), t3x128(:,:,760), nhel, den(865))
    call cont_QA(nsync, wf8(:,85), wf16(:,337), A(:,761), n3(:,1159), t3x128(:,:,761), nhel, den(866))
    call cont_QA(nsync, wf8(:,123), wf16(:,320), A(:,762), n3(:,1160), t3x128(:,:,762), nhel, den(867))
    call cont_QA(nsync, wf8(:,85), wf16(:,338), A(:,763), n3(:,1161), t3x128(:,:,763), nhel, den(868))
    call cont_QA(nsync, wf8(:,123), wf16(:,322), A(:,764), n3(:,1162), t3x128(:,:,764), nhel, den(869))
    call cont_VV(nsync, wf8(:,13), wf16(:,284), A(:,765), n3(:,1163), t3x128(:,:,765), nhel, den(870))
    call cont_VV(nsync, wf8(:,39), wf16(:,170), A(:,766), n3(:,1164), t3x128(:,:,766), nhel, den(871))
    call cont_QA(nsync, wf8(:,125), wf16(:,322), A(:,767), n3(:,1165), t3x128(:,:,767), nhel, den(872))
    call cont_QA(nsync, wf8(:,125), wf16(:,320), A(:,768), n3(:,1166), t3x128(:,:,768), nhel, den(873))
    call cont_QA(nsync, wf8(:,87), wf16(:,309), A(:,769), n3(:,1167), t3x128(:,:,769), nhel, den(874))
    call cont_VV(nsync, wf8(:,13), wf16(:,287), A(:,770), n3(:,1168), t3x128(:,:,770), nhel, den(875))
    call cont_QA(nsync, wf8(:,89), wf16(:,335), A(:,771), n3(:,1169), t3x128(:,:,771), nhel, den(876))
    call cont_VV(nsync, wf8(:,47), wf16(:,112), A(:,772), n3(:,1170), t3x128(:,:,772), nhel, den(877))
    call cont_VV(nsync, wf8(:,29), wf16(:,232), A(:,773), n3(:,1171), t3x128(:,:,773), nhel, den(878))
    call cont_VV(nsync, wf8(:,29), wf16(:,231), A(:,774), n3(:,1172), t3x128(:,:,774), nhel, den(879))
    call cont_QA(nsync, wf8(:,89), wf16(:,336), A(:,775), n3(:,1173), t3x128(:,:,775), nhel, den(880))
    call cont_VV(nsync, wf8(:,14), wf16(:,280), A(:,776), n3(:,1174), t3x128(:,:,776), nhel, den(881))
    call cont_VV(nsync, wf8(:,14), wf16(:,278), A(:,777), n3(:,1175), t3x128(:,:,777), nhel, den(882))
    call cont_VV(nsync, wf8(:,38), wf16(:,176), A(:,778), n3(:,1176), t3x128(:,:,778), nhel, den(883))
    call cont_QA(nsync, wf8(:,89), wf16(:,337), A(:,779), n3(:,1177), t3x128(:,:,779), nhel, den(884))
    call cont_QA(nsync, wf8(:,89), wf16(:,338), A(:,780), n3(:,1178), t3x128(:,:,780), nhel, den(885))
    call cont_QA(nsync, wf8(:,91), wf16(:,313), A(:,781), n3(:,1179), t3x128(:,:,781), nhel, den(886))
    call cont_VV(nsync, wf8(:,39), wf16(:,176), A(:,782), n3(:,1180), t3x128(:,:,782), nhel, den(887))
    call cont_QA(nsync, wf8(:,129), wf16(:,326), A(:,783), n3(:,1181), t3x128(:,:,783), nhel, den(888))
    call cont_QA(nsync, wf8(:,129), wf16(:,325), A(:,784), n3(:,1182), t3x128(:,:,784), nhel, den(889))
    call cont_QA(nsync, wf8(:,91), wf16(:,314), A(:,785), n3(:,1183), t3x128(:,:,785), nhel, den(890))
    call cont_VV(nsync, wf8(:,15), wf16(:,278), A(:,786), n3(:,1184), t3x128(:,:,786), nhel, den(891))

end subroutine diagrams


elemental function diagmap(j, n)
  implicit none
  integer, intent(in) :: j, n
  complex(REALKIND) :: diagmap
  diagmap = A(j,n)%j
end function diagmap

function diagsum(j, pos, neg)
  implicit none
  integer, intent(in) :: j, pos(:), neg(:)
  complex(REALKIND) :: diagsum
  diagsum = sum(diagmap(j, pos)) - sum(diagmap(j, neg))
end function diagsum

subroutine colourvector(A, j, M1)
  implicit none
  type(polcont) :: A(:,:)
  integer, intent(in) :: j
  complex(REALKIND), intent(out) :: M1(48) ! M1helarray(48,128)
  integer :: empty(0)

  M1( 1) = ((-A(j,91)%j+A(j,93)%j+A(j,100)%j-A(j,101)%j-A(j,112)%j+A(j,114)%j+A(j,122)%j-A(j,123)%j+A(j,307)%j+A(j,313)%j &
        -A(j,314)%j+A(j,335)%j-A(j,339)%j+A(j,352)%j+A(j,387)%j+A(j,393)%j+A(j,395)%j-A(j,422)%j+A(j,432)%j+A(j,437)%j+A(j,627)%j &
        +A(j,629)%j+A(j,658)%j+A(j,711)%j)*f(1))/2._/**/REALKIND+((A(j,628)%j+A(j,630)%j+A(j,656)%j+A(j,660)%j+A(j,712)%j &
        +A(j,718)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,56)%j-A(j,57)%j-A(j,64)%j+A(j,66)%j+A(j,70)%j-A(j,72)%j+A(j,76)%j-A(j,77)%j &
        -A(j,80)%j+A(j,81)%j+A(j,262)%j+A(j,263)%j+A(j,273)%j+A(j,274)%j+A(j,275)%j+A(j,308)%j-A(j,316)%j+A(j,336)%j-A(j,385)%j &
        +A(j,396)%j+A(j,423)%j-A(j,631)%j+A(j,662)%j-A(j,709)%j+A(j,778)%j+A(j,784)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,776)%j &
        +A(j,777)%j+A(j,783)%j+A(j,786)%j)*f(2))/6._/**/REALKIND
  M1( 2) = ((A(j,37)%j-A(j,39)%j-A(j,46)%j+A(j,47)%j+A(j,136)%j-A(j,138)%j-A(j,146)%j+A(j,147)%j-A(j,203)%j-A(j,210)%j+A(j,212)%j &
        -A(j,230)%j+A(j,236)%j-A(j,246)%j-A(j,477)%j-A(j,483)%j-A(j,484)%j+A(j,511)%j-A(j,521)%j-A(j,524)%j-A(j,635)%j-A(j,636)%j &
        -A(j,660)%j-A(j,724)%j)*f(1))/2._/**/REALKIND+((-A(j,634)%j-A(j,637)%j-A(j,652)%j-A(j,658)%j-A(j,726)%j &
        -A(j,732)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,2)%j+A(j,3)%j+A(j,7)%j-A(j,9)%j-A(j,19)%j+A(j,21)%j+A(j,23)%j-A(j,24)%j &
        -A(j,25)%j+A(j,26)%j-A(j,157)%j-A(j,158)%j-A(j,166)%j-A(j,167)%j-A(j,171)%j-A(j,202)%j+A(j,213)%j-A(j,231)%j+A(j,476)%j &
        -A(j,486)%j-A(j,513)%j+A(j,639)%j-A(j,661)%j+A(j,723)%j-A(j,772)%j-A(j,783)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,773)%j &
        -A(j,774)%j-A(j,784)%j-A(j,785)%j)*f(2))/6._/**/REALKIND
  M1( 3) = ((A(j,34)%j-A(j,36)%j-A(j,44)%j+A(j,45)%j+A(j,139)%j-A(j,141)%j-A(j,148)%j+A(j,149)%j-A(j,192)%j-A(j,198)%j-A(j,200)%j &
        +A(j,227)%j-A(j,237)%j-A(j,242)%j-A(j,487)%j-A(j,493)%j+A(j,494)%j-A(j,515)%j+A(j,519)%j-A(j,532)%j-A(j,667)%j-A(j,670)%j &
        -A(j,697)%j-A(j,712)%j)*f(1))/2._/**/REALKIND+((-A(j,668)%j-A(j,669)%j-A(j,695)%j-A(j,699)%j-A(j,711)%j &
        -A(j,715)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,2)%j+A(j,3)%j+A(j,10)%j-A(j,12)%j-A(j,16)%j+A(j,18)%j-A(j,22)%j+A(j,23)%j &
        +A(j,26)%j-A(j,27)%j-A(j,157)%j-A(j,158)%j-A(j,168)%j-A(j,169)%j-A(j,170)%j+A(j,190)%j-A(j,201)%j-A(j,228)%j-A(j,488)%j &
        +A(j,496)%j-A(j,516)%j+A(j,672)%j-A(j,701)%j-A(j,707)%j-A(j,777)%j-A(j,779)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,775)%j &
        -A(j,778)%j-A(j,780)%j-A(j,782)%j)*f(2))/6._/**/REALKIND
  M1( 4) = ((-A(j,88)%j+A(j,90)%j+A(j,98)%j-A(j,99)%j-A(j,115)%j+A(j,117)%j+A(j,124)%j-A(j,125)%j+A(j,297)%j+A(j,303)%j+A(j,304)%j &
        -A(j,331)%j+A(j,341)%j+A(j,344)%j+A(j,398)%j+A(j,405)%j-A(j,407)%j+A(j,425)%j-A(j,431)%j+A(j,441)%j+A(j,675)%j+A(j,677)%j &
        +A(j,699)%j+A(j,726)%j)*f(1))/2._/**/REALKIND+((A(j,674)%j+A(j,676)%j+A(j,691)%j+A(j,697)%j+A(j,724)%j &
        +A(j,729)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,56)%j-A(j,57)%j-A(j,61)%j+A(j,63)%j+A(j,73)%j-A(j,75)%j-A(j,77)%j+A(j,78)%j &
        +A(j,79)%j-A(j,80)%j+A(j,262)%j+A(j,263)%j+A(j,271)%j+A(j,272)%j+A(j,276)%j-A(j,296)%j+A(j,306)%j+A(j,333)%j+A(j,397)%j &
        -A(j,408)%j+A(j,426)%j-A(j,680)%j+A(j,702)%j+A(j,725)%j+A(j,774)%j+A(j,780)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,771)%j &
        +A(j,772)%j+A(j,779)%j+A(j,781)%j)*f(2))/6._/**/REALKIND
  M1( 5) = ((A(j,94)%j-A(j,95)%j-A(j,97)%j+A(j,99)%j-A(j,112)%j+A(j,114)%j+A(j,116)%j-A(j,117)%j+A(j,319)%j+A(j,323)%j-A(j,328)%j &
        -A(j,343)%j-A(j,344)%j-A(j,357)%j+A(j,384)%j+A(j,393)%j+A(j,395)%j-A(j,401)%j+A(j,407)%j+A(j,450)%j+A(j,634)%j+A(j,641)%j &
        +A(j,646)%j+A(j,727)%j)*f(1))/2._/**/REALKIND+((A(j,635)%j+A(j,640)%j+A(j,642)%j+A(j,648)%j+A(j,728)%j &
        +A(j,757)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,59)%j-A(j,60)%j-A(j,64)%j+A(j,66)%j+A(j,70)%j-A(j,71)%j-A(j,74)%j+A(j,75)%j &
        +A(j,76)%j-A(j,78)%j+A(j,265)%j+A(j,266)%j+A(j,273)%j+A(j,275)%j-A(j,276)%j+A(j,320)%j+A(j,324)%j-A(j,346)%j-A(j,382)%j &
        +A(j,394)%j+A(j,402)%j-A(j,650)%j-A(j,651)%j-A(j,725)%j+A(j,738)%j+A(j,768)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,736)%j &
        +A(j,737)%j+A(j,767)%j+A(j,770)%j)*f(2))/6._/**/REALKIND
  M1( 6) = ((-A(j,40)%j+A(j,41)%j+A(j,43)%j-A(j,45)%j+A(j,136)%j-A(j,138)%j-A(j,140)%j+A(j,141)%j-A(j,215)%j-A(j,218)%j+A(j,222)%j &
        +A(j,240)%j+A(j,242)%j+A(j,254)%j-A(j,474)%j-A(j,483)%j-A(j,484)%j+A(j,490)%j-A(j,494)%j-A(j,539)%j-A(j,628)%j-A(j,643)%j &
        -A(j,648)%j-A(j,708)%j)*f(1))/2._/**/REALKIND+((-A(j,627)%j-A(j,632)%j-A(j,644)%j-A(j,646)%j-A(j,710)%j &
        -A(j,758)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,5)%j+A(j,6)%j+A(j,7)%j-A(j,9)%j+A(j,17)%j-A(j,18)%j-A(j,19)%j+A(j,20)%j &
        -A(j,25)%j+A(j,27)%j-A(j,160)%j-A(j,161)%j-A(j,166)%j-A(j,167)%j+A(j,169)%j-A(j,214)%j-A(j,219)%j+A(j,243)%j+A(j,473)%j &
        -A(j,485)%j-A(j,492)%j-A(j,649)%j+A(j,655)%j+A(j,707)%j-A(j,720)%j-A(j,767)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,721)%j &
        -A(j,722)%j-A(j,768)%j-A(j,769)%j)*f(2))/6._/**/REALKIND
  M1( 7) = ((A(j,34)%j-A(j,36)%j-A(j,38)%j+A(j,39)%j-A(j,142)%j+A(j,143)%j+A(j,145)%j-A(j,147)%j-A(j,189)%j-A(j,198)%j-A(j,200)%j &
        +A(j,206)%j-A(j,212)%j-A(j,255)%j-A(j,499)%j-A(j,503)%j+A(j,508)%j+A(j,523)%j+A(j,524)%j+A(j,537)%j-A(j,674)%j-A(j,682)%j &
        -A(j,685)%j-A(j,728)%j)*f(1))/2._/**/REALKIND+((-A(j,675)%j-A(j,679)%j-A(j,681)%j-A(j,687)%j-A(j,727)%j &
        -A(j,741)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,5)%j+A(j,6)%j+A(j,10)%j-A(j,12)%j-A(j,16)%j+A(j,17)%j+A(j,20)%j-A(j,21)%j &
        -A(j,22)%j+A(j,24)%j-A(j,160)%j-A(j,161)%j-A(j,168)%j-A(j,170)%j+A(j,171)%j+A(j,187)%j-A(j,199)%j-A(j,207)%j-A(j,500)%j &
        -A(j,504)%j+A(j,526)%j+A(j,689)%j+A(j,692)%j-A(j,723)%j-A(j,737)%j-A(j,751)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,735)%j &
        -A(j,738)%j-A(j,752)%j-A(j,754)%j)*f(2))/6._/**/REALKIND
  M1( 8) = ((-A(j,88)%j+A(j,90)%j+A(j,92)%j-A(j,93)%j+A(j,118)%j-A(j,119)%j-A(j,121)%j+A(j,123)%j+A(j,294)%j+A(j,303)%j+A(j,304)%j &
        -A(j,310)%j+A(j,314)%j+A(j,359)%j+A(j,410)%j+A(j,413)%j-A(j,417)%j-A(j,435)%j-A(j,437)%j-A(j,449)%j+A(j,668)%j+A(j,684)%j &
        +A(j,687)%j+A(j,710)%j)*f(1))/2._/**/REALKIND+((A(j,667)%j+A(j,671)%j+A(j,683)%j+A(j,685)%j+A(j,708)%j &
        +A(j,742)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,59)%j-A(j,60)%j-A(j,61)%j+A(j,63)%j-A(j,71)%j+A(j,72)%j+A(j,73)%j-A(j,74)%j &
        +A(j,79)%j-A(j,81)%j+A(j,265)%j+A(j,266)%j+A(j,271)%j+A(j,272)%j-A(j,274)%j-A(j,293)%j+A(j,305)%j+A(j,312)%j+A(j,409)%j &
        +A(j,414)%j-A(j,438)%j+A(j,690)%j-A(j,696)%j+A(j,709)%j+A(j,722)%j+A(j,752)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,719)%j &
        +A(j,720)%j+A(j,751)%j+A(j,753)%j)*f(2))/6._/**/REALKIND
  M1( 9) = ((-A(j,85)%j+A(j,87)%j+A(j,101)%j-A(j,102)%j-A(j,118)%j+A(j,120)%j+A(j,121)%j-A(j,122)%j+A(j,280)%j+A(j,286)%j &
        +A(j,287)%j-A(j,335)%j+A(j,339)%j+A(j,351)%j+A(j,411)%j+A(j,417)%j-A(j,419)%j+A(j,422)%j-A(j,432)%j+A(j,435)%j+A(j,557)%j &
        +A(j,559)%j+A(j,575)%j+A(j,746)%j)*f(1))/2._/**/REALKIND+((A(j,558)%j+A(j,560)%j+A(j,576)%j+A(j,582)%j+A(j,744)%j &
        +A(j,748)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,56)%j+A(j,57)%j+A(j,61)%j-A(j,63)%j-A(j,73)%j+A(j,75)%j+A(j,77)%j-A(j,78)%j &
        -A(j,79)%j+A(j,80)%j-A(j,262)%j-A(j,263)%j-A(j,271)%j-A(j,272)%j-A(j,276)%j+A(j,281)%j-A(j,289)%j-A(j,336)%j-A(j,409)%j &
        +A(j,420)%j-A(j,423)%j-A(j,561)%j-A(j,573)%j+A(j,750)%j-A(j,778)%j-A(j,784)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,776)%j &
        -A(j,777)%j-A(j,783)%j-A(j,786)%j)*f(2))/6._/**/REALKIND
  M1(10) = ((-A(j,597)%j-A(j,600)%j-A(j,614)%j-A(j,620)%j-A(j,740)%j-A(j,746)%j)*f(1))/6._/**/REALKIND+((A(j,31)%j-A(j,33)%j &
        -A(j,47)%j+A(j,48)%j+A(j,142)%j-A(j,144)%j-A(j,145)%j+A(j,146)%j-A(j,176)%j-A(j,183)%j-A(j,185)%j+A(j,230)%j-A(j,236)%j &
        -A(j,248)%j-A(j,501)%j+A(j,507)%j-A(j,508)%j-A(j,511)%j+A(j,521)%j-A(j,523)%j-A(j,598)%j-A(j,599)%j-A(j,612)%j &
        -A(j,748)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,2)%j-A(j,3)%j-A(j,10)%j+A(j,12)%j+A(j,16)%j-A(j,18)%j+A(j,22)%j-A(j,23)%j &
        -A(j,26)%j+A(j,27)%j+A(j,157)%j+A(j,158)%j+A(j,168)%j+A(j,169)%j+A(j,170)%j-A(j,175)%j+A(j,186)%j+A(j,231)%j+A(j,500)%j &
        -A(j,510)%j+A(j,513)%j+A(j,602)%j+A(j,611)%j+A(j,749)%j+A(j,772)%j+A(j,783)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,773)%j &
        +A(j,774)%j+A(j,784)%j+A(j,785)%j)*f(2))/6._/**/REALKIND
  M1(11) = ((A(j,40)%j-A(j,42)%j-A(j,43)%j+A(j,44)%j+A(j,133)%j-A(j,135)%j-A(j,149)%j+A(j,150)%j-A(j,216)%j-A(j,222)%j+A(j,224)%j &
        -A(j,227)%j+A(j,237)%j-A(j,240)%j-A(j,460)%j-A(j,466)%j-A(j,467)%j+A(j,515)%j-A(j,519)%j-A(j,531)%j-A(j,564)%j-A(j,567)%j &
        -A(j,576)%j-A(j,761)%j)*f(1))/2._/**/REALKIND+((-A(j,565)%j-A(j,566)%j-A(j,575)%j-A(j,579)%j-A(j,759)%j &
        -A(j,763)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,2)%j-A(j,3)%j-A(j,7)%j+A(j,9)%j+A(j,19)%j-A(j,21)%j-A(j,23)%j+A(j,24)%j &
        +A(j,25)%j-A(j,26)%j+A(j,157)%j+A(j,158)%j+A(j,166)%j+A(j,167)%j+A(j,171)%j+A(j,214)%j-A(j,225)%j+A(j,228)%j-A(j,461)%j &
        +A(j,469)%j+A(j,516)%j+A(j,569)%j+A(j,571)%j-A(j,765)%j+A(j,777)%j+A(j,779)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,775)%j &
        +A(j,778)%j+A(j,780)%j+A(j,782)%j)*f(2))/6._/**/REALKIND
  M1(12) = ((A(j,604)%j+A(j,606)%j+A(j,612)%j+A(j,617)%j+A(j,755)%j+A(j,761)%j)*f(1))/6._/**/REALKIND+((-A(j,94)%j+A(j,96)%j &
        +A(j,97)%j-A(j,98)%j-A(j,109)%j+A(j,111)%j+A(j,125)%j-A(j,126)%j+A(j,321)%j-A(j,327)%j+A(j,328)%j+A(j,331)%j-A(j,341)%j &
        +A(j,343)%j+A(j,371)%j+A(j,378)%j+A(j,380)%j-A(j,425)%j+A(j,431)%j+A(j,443)%j+A(j,605)%j+A(j,607)%j+A(j,614)%j &
        +A(j,763)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,56)%j+A(j,57)%j+A(j,64)%j-A(j,66)%j-A(j,70)%j+A(j,72)%j-A(j,76)%j+A(j,77)%j &
        +A(j,80)%j-A(j,81)%j-A(j,262)%j-A(j,263)%j-A(j,273)%j-A(j,274)%j-A(j,275)%j-A(j,320)%j+A(j,330)%j-A(j,333)%j+A(j,370)%j &
        -A(j,381)%j-A(j,426)%j-A(j,610)%j-A(j,613)%j-A(j,766)%j-A(j,774)%j-A(j,780)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,771)%j &
        -A(j,772)%j-A(j,779)%j-A(j,781)%j)*f(2))/6._/**/REALKIND
  M1(13) = ((A(j,88)%j-A(j,89)%j-A(j,97)%j+A(j,99)%j+A(j,110)%j-A(j,111)%j-A(j,118)%j+A(j,120)%j+A(j,295)%j+A(j,299)%j-A(j,304)%j &
        -A(j,343)%j-A(j,344)%j-A(j,365)%j+A(j,369)%j-A(j,374)%j-A(j,380)%j+A(j,417)%j-A(j,419)%j+A(j,455)%j+A(j,597)%j+A(j,615)%j &
        +A(j,681)%j+A(j,686)%j)*f(1))/2._/**/REALKIND+((A(j,598)%j+A(j,603)%j+A(j,616)%j+A(j,682)%j+A(j,688)%j &
        +A(j,693)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,624)%j+A(j,625)%j+A(j,703)%j+A(j,706)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,61)%j &
        -A(j,62)%j-A(j,65)%j+A(j,66)%j+A(j,68)%j-A(j,69)%j-A(j,73)%j+A(j,75)%j+A(j,76)%j-A(j,78)%j+A(j,268)%j+A(j,269)%j &
        -A(j,271)%j+A(j,275)%j-A(j,276)%j+A(j,296)%j+A(j,300)%j-A(j,348)%j-A(j,367)%j+A(j,375)%j+A(j,418)%j+A(j,613)%j+A(j,626)%j &
        -A(j,690)%j+A(j,704)%j+A(j,739)%j)*f(2))/2._/**/REALKIND
  M1(14) = ((-A(j,34)%j+A(j,35)%j+A(j,43)%j-A(j,45)%j-A(j,134)%j+A(j,135)%j+A(j,142)%j-A(j,144)%j-A(j,191)%j-A(j,194)%j+A(j,198)%j &
        +A(j,240)%j+A(j,242)%j+A(j,261)%j-A(j,459)%j+A(j,463)%j+A(j,467)%j+A(j,507)%j-A(j,508)%j-A(j,544)%j-A(j,558)%j-A(j,572)%j &
        -A(j,683)%j-A(j,688)%j)*f(1))/2._/**/REALKIND+((-A(j,557)%j-A(j,562)%j-A(j,574)%j-A(j,684)%j-A(j,686)%j &
        -A(j,694)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,585)%j-A(j,586)%j-A(j,704)%j-A(j,705)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,8)%j &
        -A(j,9)%j-A(j,10)%j+A(j,11)%j-A(j,14)%j+A(j,15)%j+A(j,16)%j-A(j,18)%j-A(j,25)%j+A(j,27)%j-A(j,163)%j-A(j,164)%j-A(j,167)%j &
        +A(j,168)%j+A(j,169)%j-A(j,190)%j-A(j,195)%j+A(j,241)%j+A(j,458)%j-A(j,465)%j-A(j,509)%j-A(j,571)%j-A(j,584)%j-A(j,689)%j &
        -A(j,703)%j-A(j,743)%j)*f(2))/2._/**/REALKIND
  M1(15) = ((-A(j,32)%j+A(j,33)%j+A(j,40)%j-A(j,42)%j-A(j,136)%j+A(j,137)%j+A(j,145)%j-A(j,147)%j-A(j,174)%j+A(j,179)%j+A(j,185)%j &
        -A(j,222)%j+A(j,224)%j-A(j,260)%j-A(j,475)%j-A(j,479)%j+A(j,484)%j+A(j,523)%j+A(j,524)%j+A(j,545)%j-A(j,604)%j-A(j,616)%j &
        -A(j,642)%j-A(j,645)%j)*f(1))/2._/**/REALKIND+((-A(j,605)%j-A(j,609)%j-A(j,615)%j-A(j,641)%j-A(j,647)%j &
        -A(j,653)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,623)%j-A(j,626)%j-A(j,664)%j-A(j,666)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,7)%j &
        +A(j,8)%j+A(j,11)%j-A(j,12)%j-A(j,14)%j+A(j,15)%j+A(j,19)%j-A(j,21)%j-A(j,22)%j+A(j,24)%j-A(j,163)%j-A(j,164)%j+A(j,166)%j &
        -A(j,170)%j+A(j,171)%j+A(j,172)%j-A(j,180)%j-A(j,223)%j-A(j,476)%j-A(j,480)%j+A(j,528)%j-A(j,611)%j-A(j,625)%j+A(j,649)%j &
        -A(j,663)%j-A(j,756)%j)*f(2))/2._/**/REALKIND
  M1(16) = ((A(j,86)%j-A(j,87)%j-A(j,94)%j+A(j,96)%j+A(j,112)%j-A(j,113)%j-A(j,121)%j+A(j,123)%j+A(j,279)%j-A(j,283)%j-A(j,287)%j &
        -A(j,327)%j+A(j,328)%j+A(j,364)%j+A(j,386)%j+A(j,389)%j-A(j,393)%j-A(j,435)%j-A(j,437)%j-A(j,456)%j+A(j,565)%j+A(j,574)%j &
        +A(j,644)%j+A(j,647)%j)*f(1))/2._/**/REALKIND+((A(j,564)%j+A(j,568)%j+A(j,572)%j+A(j,643)%j+A(j,645)%j &
        +A(j,654)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,583)%j+A(j,584)%j+A(j,663)%j+A(j,665)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,62)%j &
        +A(j,63)%j+A(j,64)%j-A(j,65)%j+A(j,68)%j-A(j,69)%j-A(j,70)%j+A(j,72)%j+A(j,79)%j-A(j,81)%j+A(j,268)%j+A(j,269)%j &
        +A(j,272)%j-A(j,273)%j-A(j,274)%j-A(j,278)%j+A(j,285)%j+A(j,329)%j+A(j,385)%j+A(j,390)%j-A(j,436)%j+A(j,573)%j+A(j,586)%j &
        +A(j,650)%j+A(j,664)%j+A(j,760)%j)*f(2))/2._/**/REALKIND
  M1(17) = ((-A(j,85)%j+A(j,87)%j+A(j,95)%j-A(j,96)%j+A(j,115)%j-A(j,116)%j-A(j,124)%j+A(j,126)%j+A(j,277)%j+A(j,286)%j+A(j,287)%j &
        -A(j,323)%j+A(j,327)%j+A(j,357)%j+A(j,399)%j+A(j,401)%j-A(j,405)%j-A(j,441)%j-A(j,443)%j-A(j,450)%j+A(j,547)%j+A(j,555)%j &
        +A(j,566)%j+A(j,762)%j)*f(1))/2._/**/REALKIND+((A(j,548)%j+A(j,556)%j+A(j,567)%j+A(j,570)%j+A(j,731)%j &
        +A(j,764)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,59)%j+A(j,60)%j+A(j,61)%j-A(j,63)%j+A(j,71)%j-A(j,72)%j-A(j,73)%j+A(j,74)%j &
        -A(j,79)%j+A(j,81)%j-A(j,265)%j-A(j,266)%j-A(j,271)%j-A(j,272)%j+A(j,274)%j+A(j,278)%j-A(j,291)%j-A(j,324)%j-A(j,397)%j &
        -A(j,402)%j+A(j,444)%j+A(j,553)%j+A(j,577)%j-A(j,738)%j+A(j,766)%j-A(j,768)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,736)%j &
        -A(j,737)%j-A(j,767)%j-A(j,770)%j)*f(2))/6._/**/REALKIND
  M1(18) = ((-A(j,587)%j-A(j,594)%j-A(j,607)%j-A(j,608)%j-A(j,714)%j-A(j,762)%j)*f(1))/6._/**/REALKIND+((A(j,31)%j-A(j,33)%j &
        -A(j,41)%j+A(j,42)%j-A(j,139)%j+A(j,140)%j+A(j,148)%j-A(j,150)%j-A(j,173)%j-A(j,183)%j-A(j,185)%j+A(j,218)%j-A(j,224)%j &
        -A(j,254)%j-A(j,489)%j-A(j,490)%j+A(j,493)%j+A(j,531)%j+A(j,532)%j+A(j,539)%j-A(j,588)%j-A(j,592)%j-A(j,606)%j &
        -A(j,764)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,5)%j-A(j,6)%j-A(j,10)%j+A(j,12)%j+A(j,16)%j-A(j,17)%j-A(j,20)%j+A(j,21)%j &
        +A(j,22)%j-A(j,24)%j+A(j,160)%j+A(j,161)%j+A(j,168)%j+A(j,170)%j-A(j,171)%j-A(j,172)%j+A(j,184)%j+A(j,219)%j+A(j,488)%j &
        +A(j,492)%j-A(j,534)%j-A(j,591)%j-A(j,618)%j+A(j,720)%j+A(j,765)%j+A(j,767)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,721)%j &
        +A(j,722)%j+A(j,768)%j+A(j,769)%j)*f(2))/6._/**/REALKIND
  M1(19) = ((-A(j,37)%j+A(j,38)%j+A(j,46)%j-A(j,48)%j+A(j,133)%j-A(j,135)%j-A(j,143)%j+A(j,144)%j-A(j,204)%j-A(j,206)%j+A(j,210)%j &
        +A(j,246)%j+A(j,248)%j+A(j,255)%j-A(j,457)%j-A(j,466)%j-A(j,467)%j+A(j,503)%j-A(j,507)%j-A(j,537)%j-A(j,549)%j-A(j,556)%j &
        -A(j,560)%j-A(j,745)%j)*f(1))/2._/**/REALKIND+((-A(j,550)%j-A(j,555)%j-A(j,559)%j-A(j,563)%j-A(j,733)%j &
        -A(j,747)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,5)%j-A(j,6)%j-A(j,7)%j+A(j,9)%j-A(j,17)%j+A(j,18)%j+A(j,19)%j-A(j,20)%j &
        +A(j,25)%j-A(j,27)%j+A(j,160)%j+A(j,161)%j+A(j,166)%j+A(j,167)%j-A(j,169)%j+A(j,202)%j+A(j,207)%j-A(j,249)%j-A(j,458)%j &
        +A(j,471)%j+A(j,504)%j+A(j,551)%j-A(j,581)%j+A(j,737)%j-A(j,749)%j+A(j,751)%j)*f(2))/2._/**/REALKIND+(CI*(A(j,735)%j &
        +A(j,738)%j+A(j,752)%j+A(j,754)%j)*f(2))/6._/**/REALKIND
  M1(20) = ((A(j,589)%j+A(j,592)%j+A(j,599)%j+A(j,601)%j+A(j,716)%j+A(j,745)%j)*f(1))/6._/**/REALKIND+((A(j,91)%j-A(j,92)%j &
        -A(j,100)%j+A(j,102)%j-A(j,109)%j+A(j,111)%j+A(j,119)%j-A(j,120)%j+A(j,309)%j+A(j,310)%j-A(j,313)%j-A(j,351)%j-A(j,352)%j &
        -A(j,359)%j+A(j,368)%j+A(j,378)%j+A(j,380)%j-A(j,413)%j+A(j,419)%j+A(j,449)%j+A(j,590)%j+A(j,594)%j+A(j,600)%j &
        +A(j,747)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,59)%j+A(j,60)%j+A(j,64)%j-A(j,66)%j-A(j,70)%j+A(j,71)%j+A(j,74)%j-A(j,75)%j &
        -A(j,76)%j+A(j,78)%j-A(j,265)%j-A(j,266)%j-A(j,273)%j-A(j,275)%j+A(j,276)%j-A(j,308)%j-A(j,312)%j+A(j,354)%j+A(j,367)%j &
        -A(j,379)%j-A(j,414)%j-A(j,593)%j+A(j,622)%j-A(j,722)%j-A(j,750)%j-A(j,752)%j)*f(2))/2._/**/REALKIND+(CI*(-A(j,719)%j &
        -A(j,720)%j-A(j,751)%j-A(j,753)%j)*f(2))/6._/**/REALKIND
  M1(21) = ((A(j,89)%j-A(j,90)%j-A(j,91)%j+A(j,93)%j+A(j,109)%j-A(j,110)%j-A(j,124)%j+A(j,126)%j+A(j,292)%j-A(j,299)%j-A(j,303)%j &
        +A(j,313)%j-A(j,314)%j+A(j,365)%j+A(j,372)%j+A(j,374)%j-A(j,378)%j-A(j,441)%j-A(j,443)%j-A(j,455)%j+A(j,587)%j+A(j,595)%j &
        +A(j,669)%j+A(j,698)%j)*f(1))/2._/**/REALKIND+((A(j,588)%j+A(j,596)%j+A(j,619)%j+A(j,670)%j+A(j,673)%j &
        +A(j,700)%j)*f(1))/6._/**/REALKIND+(CI*(-A(j,624)%j-A(j,625)%j-A(j,703)%j-A(j,706)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,62)%j &
        -A(j,63)%j-A(j,64)%j+A(j,65)%j-A(j,68)%j+A(j,69)%j+A(j,70)%j-A(j,72)%j-A(j,79)%j+A(j,81)%j-A(j,268)%j-A(j,269)%j &
        -A(j,272)%j+A(j,273)%j+A(j,274)%j+A(j,293)%j-A(j,300)%j-A(j,318)%j-A(j,370)%j-A(j,375)%j+A(j,442)%j+A(j,593)%j-A(j,626)%j &
        -A(j,702)%j-A(j,704)%j+A(j,713)%j)*f(2))/2._/**/REALKIND
  M1(22) = ((-A(j,547)%j-A(j,554)%j-A(j,578)%j-A(j,677)%j-A(j,678)%j-A(j,698)%j)*f(1))/6._/**/REALKIND+((-A(j,35)%j+A(j,36)%j &
        +A(j,37)%j-A(j,39)%j-A(j,133)%j+A(j,134)%j+A(j,148)%j-A(j,150)%j-A(j,188)%j+A(j,194)%j+A(j,200)%j-A(j,210)%j+A(j,212)%j &
        -A(j,261)%j-A(j,462)%j-A(j,463)%j+A(j,466)%j+A(j,531)%j+A(j,532)%j+A(j,544)%j-A(j,548)%j-A(j,552)%j-A(j,676)%j &
        -A(j,700)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,585)%j+A(j,586)%j+A(j,704)%j+A(j,705)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,7)%j &
        -A(j,8)%j-A(j,11)%j+A(j,12)%j+A(j,14)%j-A(j,15)%j-A(j,19)%j+A(j,21)%j+A(j,22)%j-A(j,24)%j+A(j,163)%j+A(j,164)%j-A(j,166)%j &
        +A(j,170)%j-A(j,171)%j-A(j,187)%j+A(j,195)%j+A(j,211)%j+A(j,461)%j+A(j,465)%j-A(j,533)%j-A(j,551)%j+A(j,584)%j+A(j,701)%j &
        +A(j,703)%j-A(j,730)%j)*f(2))/2._/**/REALKIND
  M1(23) = ((-A(j,31)%j+A(j,32)%j+A(j,46)%j-A(j,48)%j-A(j,137)%j+A(j,138)%j+A(j,139)%j-A(j,141)%j-A(j,177)%j-A(j,179)%j+A(j,183)%j &
        +A(j,246)%j+A(j,248)%j+A(j,260)%j-A(j,472)%j+A(j,479)%j+A(j,483)%j-A(j,493)%j+A(j,494)%j-A(j,545)%j-A(j,589)%j-A(j,596)%j &
        -A(j,630)%j-A(j,657)%j)*f(1))/2._/**/REALKIND+((-A(j,590)%j-A(j,595)%j-A(j,621)%j-A(j,629)%j-A(j,633)%j &
        -A(j,659)%j)*f(1))/6._/**/REALKIND+(CI*(A(j,623)%j+A(j,626)%j+A(j,664)%j+A(j,666)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,8)%j &
        +A(j,9)%j+A(j,10)%j-A(j,11)%j+A(j,14)%j-A(j,15)%j-A(j,16)%j+A(j,18)%j+A(j,25)%j-A(j,27)%j+A(j,163)%j+A(j,164)%j+A(j,167)%j &
        -A(j,168)%j-A(j,169)%j+A(j,175)%j+A(j,180)%j-A(j,247)%j-A(j,473)%j+A(j,480)%j+A(j,498)%j+A(j,591)%j+A(j,625)%j+A(j,661)%j &
        +A(j,663)%j-A(j,717)%j)*f(2))/2._/**/REALKIND
  M1(24) = ((A(j,549)%j+A(j,552)%j+A(j,580)%j+A(j,636)%j+A(j,638)%j+A(j,657)%j)*f(1))/6._/**/REALKIND+((A(j,85)%j-A(j,86)%j &
        -A(j,100)%j+A(j,102)%j+A(j,113)%j-A(j,114)%j-A(j,115)%j+A(j,117)%j+A(j,282)%j+A(j,283)%j-A(j,286)%j-A(j,351)%j-A(j,352)%j &
        -A(j,364)%j+A(j,383)%j-A(j,389)%j-A(j,395)%j+A(j,405)%j-A(j,407)%j+A(j,456)%j+A(j,550)%j+A(j,554)%j+A(j,637)%j &
        +A(j,659)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,583)%j-A(j,584)%j-A(j,663)%j-A(j,665)%j)*f(2))/6._/**/REALKIND+(CI*( &
        -A(j,61)%j+A(j,62)%j+A(j,65)%j-A(j,66)%j-A(j,68)%j+A(j,69)%j+A(j,73)%j-A(j,75)%j-A(j,76)%j+A(j,78)%j-A(j,268)%j-A(j,269)%j &
        +A(j,271)%j-A(j,275)%j+A(j,276)%j-A(j,281)%j-A(j,285)%j+A(j,353)%j+A(j,382)%j-A(j,390)%j-A(j,406)%j-A(j,553)%j-A(j,586)%j &
        -A(j,662)%j-A(j,664)%j+A(j,734)%j)*f(2))/2._/**/REALKIND
  M1(25) = ((A(j,151)%j-A(j,152)%j+A(j,154)%j-A(j,155)%j+A(j,475)%j+A(j,477)%j+A(j,482)%j+A(j,517)%j+A(j,520)%j+A(j,527)%j &
        +A(j,541)%j+A(j,543)%j)*f(1))/6._/**/REALKIND+((A(j,97)%j-A(j,98)%j+A(j,106)%j-A(j,107)%j+A(j,113)%j-A(j,114)%j+A(j,127)%j &
        -A(j,128)%j+A(j,331)%j+A(j,340)%j+A(j,343)%j+A(j,347)%j+A(j,363)%j+A(j,365)%j-A(j,389)%j+A(j,392)%j-A(j,395)%j+A(j,427)%j &
        -A(j,432)%j+A(j,451)%j+A(j,652)%j+A(j,653)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,478)%j+A(j,480)%j+A(j,512)%j+A(j,513)%j &
        +A(j,518)%j+A(j,546)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,55)%j-A(j,56)%j+A(j,65)%j-A(j,66)%j-A(j,67)%j+A(j,69)%j-A(j,76)%j &
        +A(j,77)%j-A(j,82)%j+A(j,83)%j-A(j,262)%j-A(j,264)%j-A(j,269)%j-A(j,270)%j-A(j,275)%j+A(j,332)%j+A(j,348)%j+A(j,366)%j &
        +A(j,388)%j-A(j,396)%j+A(j,428)%j+A(j,651)%j+A(j,666)%j+A(j,773)%j)*f(2))/2._/**/REALKIND
  M1(26) = ((-A(j,127)%j+A(j,128)%j-A(j,130)%j+A(j,131)%j-A(j,386)%j-A(j,387)%j-A(j,392)%j-A(j,427)%j-A(j,429)%j-A(j,434)%j &
        -A(j,451)%j-A(j,453)%j)*f(1))/6._/**/REALKIND+((-A(j,43)%j+A(j,44)%j-A(j,52)%j+A(j,53)%j-A(j,137)%j+A(j,138)%j-A(j,151)%j &
        +A(j,152)%j-A(j,227)%j-A(j,234)%j-A(j,239)%j-A(j,240)%j-A(j,258)%j-A(j,261)%j+A(j,479)%j-A(j,482)%j+A(j,483)%j-A(j,517)%j &
        +A(j,521)%j-A(j,541)%j-A(j,654)%j-A(j,656)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,388)%j-A(j,390)%j-A(j,421)%j-A(j,423)%j &
        -A(j,428)%j-A(j,454)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,1)%j+A(j,2)%j-A(j,8)%j+A(j,9)%j+A(j,13)%j-A(j,15)%j+A(j,25)%j &
        -A(j,26)%j+A(j,28)%j-A(j,29)%j+A(j,158)%j+A(j,159)%j+A(j,163)%j+A(j,165)%j+A(j,167)%j-A(j,226)%j-A(j,241)%j-A(j,259)%j &
        -A(j,478)%j+A(j,486)%j-A(j,518)%j-A(j,655)%j-A(j,665)%j-A(j,776)%j)*f(2))/2._/**/REALKIND
  M1(27) = ((-A(j,103)%j+A(j,104)%j-A(j,106)%j+A(j,107)%j-A(j,295)%j-A(j,297)%j-A(j,302)%j-A(j,337)%j-A(j,340)%j-A(j,347)%j &
        -A(j,361)%j-A(j,363)%j)*f(1))/6._/**/REALKIND+((-A(j,35)%j+A(j,36)%j-A(j,49)%j+A(j,50)%j-A(j,145)%j+A(j,146)%j-A(j,154)%j &
        +A(j,155)%j+A(j,194)%j-A(j,197)%j+A(j,200)%j-A(j,232)%j+A(j,237)%j-A(j,256)%j-A(j,511)%j-A(j,520)%j-A(j,523)%j-A(j,527)%j &
        -A(j,543)%j-A(j,545)%j-A(j,691)%j-A(j,693)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,298)%j-A(j,300)%j-A(j,332)%j-A(j,333)%j &
        -A(j,338)%j-A(j,366)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,1)%j-A(j,3)%j-A(j,11)%j+A(j,12)%j-A(j,13)%j+A(j,14)%j+A(j,22)%j &
        -A(j,23)%j-A(j,28)%j+A(j,29)%j+A(j,157)%j-A(j,159)%j+A(j,164)%j-A(j,165)%j+A(j,170)%j-A(j,193)%j+A(j,201)%j-A(j,233)%j &
        -A(j,512)%j-A(j,528)%j-A(j,546)%j-A(j,692)%j-A(j,706)%j-A(j,771)%j)*f(2))/2._/**/REALKIND
  M1(28) = ((A(j,49)%j-A(j,50)%j+A(j,52)%j-A(j,53)%j+A(j,191)%j+A(j,192)%j+A(j,197)%j+A(j,232)%j+A(j,234)%j+A(j,239)%j+A(j,256)%j &
        +A(j,258)%j)*f(1))/6._/**/REALKIND+((A(j,89)%j-A(j,90)%j+A(j,103)%j-A(j,104)%j+A(j,121)%j-A(j,122)%j+A(j,130)%j-A(j,131)%j &
        -A(j,299)%j+A(j,302)%j-A(j,303)%j+A(j,337)%j-A(j,341)%j+A(j,361)%j+A(j,422)%j+A(j,429)%j+A(j,434)%j+A(j,435)%j+A(j,453)%j &
        +A(j,456)%j+A(j,694)%j+A(j,695)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,193)%j+A(j,195)%j+A(j,226)%j+A(j,228)%j+A(j,233)%j &
        +A(j,259)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,55)%j+A(j,57)%j+A(j,62)%j-A(j,63)%j+A(j,67)%j-A(j,68)%j-A(j,79)%j+A(j,80)%j &
        +A(j,82)%j-A(j,83)%j-A(j,263)%j+A(j,264)%j-A(j,268)%j+A(j,270)%j-A(j,272)%j+A(j,298)%j-A(j,306)%j+A(j,338)%j+A(j,421)%j &
        +A(j,436)%j+A(j,454)%j+A(j,696)%j+A(j,705)%j+A(j,775)%j)*f(2))/2._/**/REALKIND
  M1(29) = ((A(j,152)%j-A(j,153)%j+A(j,155)%j-A(j,156)%j+A(j,472)%j+A(j,474)%j+A(j,481)%j+A(j,497)%j-A(j,535)%j-A(j,538)%j &
        -A(j,541)%j-A(j,543)%j)*f(1))/6._/**/REALKIND+((A(j,91)%j-A(j,92)%j+A(j,107)%j-A(j,108)%j+A(j,112)%j-A(j,113)%j+A(j,128)%j &
        -A(j,129)%j+A(j,310)%j-A(j,313)%j+A(j,317)%j-A(j,358)%j-A(j,363)%j-A(j,365)%j+A(j,389)%j+A(j,391)%j-A(j,393)%j-A(j,445)%j &
        -A(j,450)%j-A(j,451)%j+A(j,632)%j+A(j,633)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,478)%j-A(j,480)%j+A(j,491)%j+A(j,492)%j &
        +A(j,536)%j-A(j,546)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,58)%j-A(j,59)%j+A(j,64)%j-A(j,65)%j+A(j,67)%j-A(j,69)%j-A(j,70)%j &
        +A(j,71)%j-A(j,83)%j+A(j,84)%j-A(j,265)%j+A(j,267)%j+A(j,269)%j+A(j,270)%j-A(j,273)%j+A(j,311)%j+A(j,318)%j-A(j,366)%j &
        -A(j,388)%j-A(j,394)%j+A(j,446)%j+A(j,631)%j-A(j,666)%j+A(j,721)%j)*f(2))/2._/**/REALKIND
  M1(30) = ((-A(j,128)%j+A(j,129)%j-A(j,131)%j+A(j,132)%j-A(j,383)%j-A(j,384)%j-A(j,391)%j-A(j,404)%j+A(j,445)%j+A(j,447)%j &
        +A(j,451)%j+A(j,453)%j)*f(1))/6._/**/REALKIND+((-A(j,37)%j+A(j,38)%j-A(j,53)%j+A(j,54)%j-A(j,136)%j+A(j,137)%j-A(j,152)%j &
        +A(j,153)%j-A(j,206)%j-A(j,209)%j+A(j,210)%j+A(j,252)%j+A(j,258)%j+A(j,261)%j-A(j,479)%j-A(j,481)%j+A(j,484)%j+A(j,535)%j &
        +A(j,539)%j+A(j,541)%j-A(j,638)%j-A(j,640)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,388)%j+A(j,390)%j-A(j,400)%j-A(j,402)%j &
        -A(j,446)%j+A(j,454)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,4)%j+A(j,5)%j-A(j,7)%j+A(j,8)%j-A(j,13)%j+A(j,15)%j+A(j,19)%j &
        -A(j,20)%j+A(j,29)%j-A(j,30)%j+A(j,161)%j-A(j,162)%j-A(j,163)%j-A(j,165)%j+A(j,166)%j-A(j,205)%j-A(j,211)%j+A(j,259)%j &
        +A(j,478)%j+A(j,485)%j-A(j,536)%j-A(j,639)%j+A(j,665)%j-A(j,736)%j)*f(2))/2._/**/REALKIND
  M1(31) = ((-A(j,104)%j+A(j,105)%j-A(j,107)%j+A(j,108)%j-A(j,292)%j-A(j,294)%j-A(j,301)%j-A(j,317)%j+A(j,355)%j+A(j,358)%j &
        +A(j,361)%j+A(j,363)%j)*f(1))/6._/**/REALKIND+((-A(j,34)%j+A(j,35)%j-A(j,50)%j+A(j,51)%j-A(j,139)%j+A(j,140)%j-A(j,155)%j &
        +A(j,156)%j-A(j,194)%j-A(j,196)%j+A(j,198)%j+A(j,250)%j+A(j,255)%j+A(j,256)%j-A(j,490)%j+A(j,493)%j-A(j,497)%j+A(j,538)%j &
        +A(j,543)%j+A(j,545)%j-A(j,671)%j-A(j,673)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,298)%j+A(j,300)%j-A(j,311)%j-A(j,312)%j &
        -A(j,356)%j+A(j,366)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,4)%j-A(j,6)%j-A(j,10)%j+A(j,11)%j+A(j,13)%j-A(j,14)%j+A(j,16)%j &
        -A(j,17)%j-A(j,29)%j+A(j,30)%j+A(j,160)%j+A(j,162)%j-A(j,164)%j+A(j,165)%j+A(j,168)%j+A(j,193)%j+A(j,199)%j-A(j,251)%j &
        -A(j,491)%j-A(j,498)%j+A(j,546)%j-A(j,672)%j+A(j,706)%j-A(j,719)%j)*f(2))/2._/**/REALKIND
  M1(32) = ((A(j,50)%j-A(j,51)%j+A(j,53)%j-A(j,54)%j+A(j,188)%j+A(j,189)%j+A(j,196)%j+A(j,209)%j-A(j,250)%j-A(j,252)%j-A(j,256)%j &
        -A(j,258)%j)*f(1))/6._/**/REALKIND+((A(j,88)%j-A(j,89)%j+A(j,104)%j-A(j,105)%j+A(j,115)%j-A(j,116)%j+A(j,131)%j-A(j,132)%j &
        +A(j,299)%j+A(j,301)%j-A(j,304)%j-A(j,355)%j-A(j,359)%j-A(j,361)%j+A(j,401)%j+A(j,404)%j-A(j,405)%j-A(j,447)%j-A(j,453)%j &
        -A(j,456)%j+A(j,678)%j+A(j,679)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,193)%j-A(j,195)%j+A(j,205)%j+A(j,207)%j+A(j,251)%j &
        -A(j,259)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,58)%j+A(j,60)%j+A(j,61)%j-A(j,62)%j-A(j,67)%j+A(j,68)%j-A(j,73)%j+A(j,74)%j &
        +A(j,83)%j-A(j,84)%j-A(j,266)%j-A(j,267)%j+A(j,268)%j-A(j,270)%j-A(j,271)%j-A(j,298)%j-A(j,305)%j+A(j,356)%j+A(j,400)%j &
        +A(j,406)%j-A(j,454)%j+A(j,680)%j-A(j,705)%j+A(j,735)%j)*f(2))/2._/**/REALKIND
  M1(33) = ((-A(j,151)%j+A(j,153)%j-A(j,154)%j+A(j,156)%j+A(j,499)%j+A(j,501)%j+A(j,506)%j-A(j,517)%j-A(j,520)%j+A(j,525)%j &
        +A(j,535)%j+A(j,538)%j)*f(1))/6._/**/REALKIND+((A(j,98)%j-A(j,99)%j-A(j,106)%j+A(j,108)%j+A(j,119)%j-A(j,120)%j-A(j,127)%j &
        +A(j,129)%j-A(j,331)%j-A(j,340)%j+A(j,344)%j+A(j,345)%j+A(j,357)%j+A(j,358)%j-A(j,413)%j+A(j,416)%j+A(j,419)%j-A(j,427)%j &
        +A(j,432)%j+A(j,445)%j+A(j,740)%j+A(j,741)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,502)%j+A(j,504)%j-A(j,512)%j-A(j,513)%j &
        -A(j,518)%j+A(j,540)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,55)%j+A(j,56)%j-A(j,58)%j+A(j,60)%j+A(j,74)%j-A(j,75)%j-A(j,77)%j &
        +A(j,78)%j+A(j,82)%j-A(j,84)%j+A(j,262)%j+A(j,264)%j-A(j,266)%j-A(j,267)%j+A(j,276)%j-A(j,332)%j+A(j,346)%j+A(j,360)%j &
        +A(j,412)%j-A(j,420)%j-A(j,428)%j-A(j,739)%j+A(j,754)%j-A(j,773)%j)*f(2))/2._/**/REALKIND
  M1(34) = ((A(j,127)%j-A(j,129)%j+A(j,130)%j-A(j,132)%j-A(j,410)%j-A(j,411)%j-A(j,416)%j+A(j,427)%j+A(j,429)%j-A(j,433)%j &
        -A(j,445)%j-A(j,447)%j)*f(1))/6._/**/REALKIND+((-A(j,44)%j+A(j,45)%j+A(j,52)%j-A(j,54)%j-A(j,143)%j+A(j,144)%j+A(j,151)%j &
        -A(j,153)%j+A(j,227)%j+A(j,234)%j-A(j,238)%j-A(j,242)%j-A(j,252)%j-A(j,254)%j+A(j,503)%j-A(j,506)%j-A(j,507)%j+A(j,517)%j &
        -A(j,521)%j-A(j,535)%j-A(j,742)%j-A(j,744)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,412)%j-A(j,414)%j+A(j,421)%j+A(j,423)%j &
        +A(j,428)%j-A(j,448)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,1)%j-A(j,2)%j+A(j,4)%j-A(j,6)%j-A(j,17)%j+A(j,18)%j+A(j,26)%j &
        -A(j,27)%j-A(j,28)%j+A(j,30)%j-A(j,158)%j-A(j,159)%j+A(j,160)%j+A(j,162)%j-A(j,169)%j+A(j,226)%j-A(j,243)%j-A(j,253)%j &
        -A(j,502)%j+A(j,510)%j+A(j,518)%j+A(j,743)%j-A(j,753)%j+A(j,776)%j)*f(2))/2._/**/REALKIND
  M1(35) = ((A(j,103)%j-A(j,105)%j+A(j,106)%j-A(j,108)%j-A(j,319)%j-A(j,321)%j-A(j,326)%j+A(j,337)%j+A(j,340)%j-A(j,345)%j &
        -A(j,355)%j-A(j,358)%j)*f(1))/6._/**/REALKIND+((-A(j,41)%j+A(j,42)%j+A(j,49)%j-A(j,51)%j-A(j,146)%j+A(j,147)%j+A(j,154)%j &
        -A(j,156)%j+A(j,218)%j-A(j,221)%j-A(j,224)%j+A(j,232)%j-A(j,237)%j-A(j,250)%j+A(j,511)%j+A(j,520)%j-A(j,524)%j-A(j,525)%j &
        -A(j,537)%j-A(j,538)%j-A(j,755)%j-A(j,757)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,322)%j-A(j,324)%j+A(j,332)%j+A(j,333)%j &
        +A(j,338)%j-A(j,360)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,1)%j+A(j,3)%j-A(j,4)%j+A(j,5)%j-A(j,20)%j+A(j,21)%j+A(j,23)%j &
        -A(j,24)%j+A(j,28)%j-A(j,30)%j-A(j,157)%j+A(j,159)%j+A(j,161)%j-A(j,162)%j-A(j,171)%j-A(j,217)%j+A(j,225)%j+A(j,233)%j &
        +A(j,512)%j-A(j,526)%j-A(j,540)%j+A(j,756)%j-A(j,770)%j+A(j,771)%j)*f(2))/2._/**/REALKIND
  M1(36) = ((-A(j,49)%j+A(j,51)%j-A(j,52)%j+A(j,54)%j+A(j,215)%j+A(j,216)%j+A(j,221)%j-A(j,232)%j-A(j,234)%j+A(j,238)%j+A(j,250)%j &
        +A(j,252)%j)*f(1))/6._/**/REALKIND+((A(j,95)%j-A(j,96)%j-A(j,103)%j+A(j,105)%j+A(j,122)%j-A(j,123)%j-A(j,130)%j+A(j,132)%j &
        -A(j,323)%j+A(j,326)%j+A(j,327)%j-A(j,337)%j+A(j,341)%j+A(j,355)%j-A(j,422)%j-A(j,429)%j+A(j,433)%j+A(j,437)%j+A(j,447)%j &
        +A(j,449)%j+A(j,758)%j+A(j,759)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,217)%j+A(j,219)%j-A(j,226)%j-A(j,228)%j-A(j,233)%j &
        +A(j,253)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,55)%j-A(j,57)%j+A(j,58)%j-A(j,59)%j+A(j,71)%j-A(j,72)%j-A(j,80)%j+A(j,81)%j &
        -A(j,82)%j+A(j,84)%j+A(j,263)%j-A(j,264)%j-A(j,265)%j+A(j,267)%j+A(j,274)%j+A(j,322)%j-A(j,330)%j-A(j,338)%j-A(j,421)%j &
        +A(j,438)%j+A(j,448)%j-A(j,760)%j+A(j,769)%j-A(j,775)%j)*f(2))/2._/**/REALKIND
  M1(37) = ((A(j,152)%j-A(j,153)%j+A(j,155)%j-A(j,156)%j+A(j,457)%j+A(j,459)%j+A(j,470)%j+A(j,505)%j-A(j,535)%j-A(j,538)%j &
        -A(j,541)%j-A(j,543)%j)*f(1))/6._/**/REALKIND+((A(j,85)%j-A(j,86)%j+A(j,107)%j-A(j,108)%j+A(j,118)%j-A(j,119)%j+A(j,128)%j &
        -A(j,129)%j+A(j,283)%j-A(j,286)%j+A(j,290)%j-A(j,357)%j-A(j,358)%j-A(j,363)%j+A(j,413)%j+A(j,415)%j-A(j,417)%j-A(j,445)%j &
        -A(j,451)%j-A(j,455)%j+A(j,562)%j+A(j,563)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,464)%j+A(j,465)%j-A(j,502)%j-A(j,504)%j &
        -A(j,540)%j+A(j,542)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,58)%j-A(j,60)%j-A(j,61)%j+A(j,62)%j+A(j,67)%j-A(j,68)%j+A(j,73)%j &
        -A(j,74)%j-A(j,83)%j+A(j,84)%j+A(j,266)%j+A(j,267)%j-A(j,268)%j+A(j,270)%j+A(j,271)%j+A(j,284)%j+A(j,291)%j-A(j,360)%j &
        -A(j,412)%j-A(j,418)%j+A(j,452)%j+A(j,561)%j+A(j,585)%j-A(j,754)%j)*f(2))/2._/**/REALKIND
  M1(38) = ((-A(j,128)%j+A(j,129)%j-A(j,131)%j+A(j,132)%j-A(j,368)%j-A(j,369)%j-A(j,377)%j-A(j,415)%j+A(j,445)%j+A(j,447)%j &
        +A(j,451)%j+A(j,453)%j)*f(1))/6._/**/REALKIND+((-A(j,31)%j+A(j,32)%j-A(j,53)%j+A(j,54)%j-A(j,142)%j+A(j,143)%j-A(j,152)%j &
        +A(j,153)%j-A(j,179)%j-A(j,182)%j+A(j,183)%j+A(j,252)%j+A(j,254)%j+A(j,258)%j-A(j,503)%j-A(j,505)%j+A(j,508)%j+A(j,535)%j &
        +A(j,541)%j+A(j,544)%j-A(j,601)%j-A(j,603)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,373)%j-A(j,375)%j+A(j,412)%j+A(j,414)%j &
        +A(j,448)%j-A(j,452)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,4)%j+A(j,6)%j+A(j,10)%j-A(j,11)%j-A(j,13)%j+A(j,14)%j-A(j,16)%j &
        +A(j,17)%j+A(j,29)%j-A(j,30)%j-A(j,160)%j-A(j,162)%j+A(j,164)%j-A(j,165)%j-A(j,168)%j-A(j,178)%j-A(j,184)%j+A(j,253)%j &
        +A(j,502)%j+A(j,509)%j-A(j,542)%j-A(j,602)%j-A(j,624)%j+A(j,753)%j)*f(2))/2._/**/REALKIND
  M1(39) = ((-A(j,104)%j+A(j,105)%j-A(j,107)%j+A(j,108)%j-A(j,277)%j-A(j,279)%j-A(j,290)%j-A(j,325)%j+A(j,355)%j+A(j,358)%j &
        +A(j,361)%j+A(j,363)%j)*f(1))/6._/**/REALKIND+((-A(j,40)%j+A(j,41)%j-A(j,50)%j+A(j,51)%j-A(j,133)%j+A(j,134)%j-A(j,155)%j &
        +A(j,156)%j-A(j,218)%j-A(j,220)%j+A(j,222)%j+A(j,250)%j+A(j,256)%j+A(j,260)%j-A(j,463)%j+A(j,466)%j-A(j,470)%j+A(j,537)%j &
        +A(j,538)%j+A(j,543)%j-A(j,568)%j-A(j,570)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,284)%j-A(j,285)%j+A(j,322)%j+A(j,324)%j &
        +A(j,360)%j-A(j,362)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,4)%j-A(j,5)%j+A(j,7)%j-A(j,8)%j+A(j,13)%j-A(j,15)%j-A(j,19)%j &
        +A(j,20)%j-A(j,29)%j+A(j,30)%j-A(j,161)%j+A(j,162)%j+A(j,163)%j+A(j,165)%j-A(j,166)%j+A(j,217)%j+A(j,223)%j-A(j,257)%j &
        -A(j,464)%j-A(j,471)%j+A(j,540)%j-A(j,569)%j-A(j,583)%j+A(j,770)%j)*f(2))/2._/**/REALKIND
  M1(40) = ((A(j,50)%j-A(j,51)%j+A(j,53)%j-A(j,54)%j+A(j,173)%j+A(j,174)%j+A(j,182)%j+A(j,220)%j-A(j,250)%j-A(j,252)%j-A(j,256)%j &
        -A(j,258)%j)*f(1))/6._/**/REALKIND+((A(j,94)%j-A(j,95)%j+A(j,104)%j-A(j,105)%j+A(j,109)%j-A(j,110)%j+A(j,131)%j-A(j,132)%j &
        +A(j,323)%j+A(j,325)%j-A(j,328)%j-A(j,355)%j-A(j,361)%j-A(j,364)%j+A(j,374)%j+A(j,377)%j-A(j,378)%j-A(j,447)%j-A(j,449)%j &
        -A(j,453)%j+A(j,608)%j+A(j,609)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,178)%j+A(j,180)%j-A(j,217)%j-A(j,219)%j-A(j,253)%j &
        +A(j,257)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,58)%j+A(j,59)%j-A(j,64)%j+A(j,65)%j-A(j,67)%j+A(j,69)%j+A(j,70)%j-A(j,71)%j &
        +A(j,83)%j-A(j,84)%j+A(j,265)%j-A(j,267)%j-A(j,269)%j-A(j,270)%j+A(j,273)%j-A(j,322)%j-A(j,329)%j+A(j,362)%j+A(j,373)%j &
        +A(j,379)%j-A(j,448)%j+A(j,610)%j+A(j,623)%j-A(j,769)%j)*f(2))/2._/**/REALKIND
  M1(41) = ((-A(j,151)%j+A(j,153)%j-A(j,154)%j+A(j,156)%j+A(j,487)%j+A(j,489)%j+A(j,495)%j-A(j,517)%j-A(j,520)%j+A(j,530)%j &
        +A(j,535)%j+A(j,538)%j)*f(1))/6._/**/REALKIND+((A(j,92)%j-A(j,93)%j-A(j,106)%j+A(j,108)%j+A(j,125)%j-A(j,126)%j-A(j,127)%j &
        +A(j,129)%j-A(j,310)%j+A(j,314)%j+A(j,315)%j+A(j,339)%j-A(j,340)%j+A(j,358)%j-A(j,425)%j-A(j,427)%j+A(j,440)%j+A(j,443)%j &
        +A(j,445)%j+A(j,450)%j+A(j,714)%j+A(j,715)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,491)%j-A(j,492)%j+A(j,514)%j+A(j,516)%j &
        +A(j,522)%j-A(j,536)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,55)%j+A(j,57)%j-A(j,58)%j+A(j,59)%j-A(j,71)%j+A(j,72)%j+A(j,80)%j &
        -A(j,81)%j+A(j,82)%j-A(j,84)%j-A(j,263)%j+A(j,264)%j+A(j,265)%j-A(j,267)%j-A(j,274)%j-A(j,311)%j+A(j,316)%j+A(j,342)%j &
        +A(j,424)%j-A(j,444)%j-A(j,446)%j-A(j,713)%j-A(j,721)%j+A(j,782)%j)*f(2))/2._/**/REALKIND
  M1(42) = ((A(j,127)%j-A(j,129)%j+A(j,130)%j-A(j,132)%j-A(j,398)%j-A(j,399)%j-A(j,403)%j+A(j,427)%j+A(j,429)%j-A(j,440)%j &
        -A(j,445)%j-A(j,447)%j)*f(1))/6._/**/REALKIND+((-A(j,38)%j+A(j,39)%j+A(j,52)%j-A(j,54)%j-A(j,149)%j+A(j,150)%j+A(j,151)%j &
        -A(j,153)%j+A(j,206)%j-A(j,208)%j-A(j,212)%j+A(j,234)%j-A(j,236)%j-A(j,252)%j+A(j,515)%j+A(j,517)%j-A(j,530)%j-A(j,531)%j &
        -A(j,535)%j-A(j,539)%j-A(j,729)%j-A(j,731)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,400)%j+A(j,402)%j-A(j,424)%j-A(j,426)%j &
        -A(j,430)%j+A(j,446)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,1)%j-A(j,3)%j+A(j,4)%j-A(j,5)%j+A(j,20)%j-A(j,21)%j-A(j,23)%j &
        +A(j,24)%j-A(j,28)%j+A(j,30)%j+A(j,157)%j-A(j,159)%j-A(j,161)%j+A(j,162)%j+A(j,171)%j+A(j,205)%j-A(j,213)%j-A(j,235)%j &
        -A(j,514)%j+A(j,534)%j+A(j,536)%j+A(j,730)%j+A(j,736)%j-A(j,781)%j)*f(2))/2._/**/REALKIND
  M1(43) = ((A(j,103)%j-A(j,105)%j+A(j,106)%j-A(j,108)%j-A(j,307)%j-A(j,309)%j-A(j,315)%j+A(j,337)%j+A(j,340)%j-A(j,350)%j &
        -A(j,355)%j-A(j,358)%j)*f(1))/6._/**/REALKIND+((-A(j,47)%j+A(j,48)%j+A(j,49)%j-A(j,51)%j-A(j,140)%j+A(j,141)%j+A(j,154)%j &
        -A(j,156)%j+A(j,230)%j+A(j,232)%j-A(j,245)%j-A(j,248)%j-A(j,250)%j-A(j,255)%j+A(j,490)%j-A(j,494)%j-A(j,495)%j-A(j,519)%j &
        +A(j,520)%j-A(j,538)%j-A(j,716)%j-A(j,718)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,311)%j+A(j,312)%j-A(j,334)%j-A(j,336)%j &
        -A(j,342)%j+A(j,356)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,1)%j+A(j,2)%j-A(j,4)%j+A(j,6)%j+A(j,17)%j-A(j,18)%j-A(j,26)%j &
        +A(j,27)%j+A(j,28)%j-A(j,30)%j+A(j,158)%j+A(j,159)%j-A(j,160)%j-A(j,162)%j+A(j,169)%j-A(j,229)%j+A(j,249)%j+A(j,251)%j &
        +A(j,491)%j-A(j,496)%j-A(j,522)%j+A(j,717)%j+A(j,719)%j-A(j,786)%j)*f(2))/2._/**/REALKIND
  M1(44) = ((-A(j,49)%j+A(j,51)%j-A(j,52)%j+A(j,54)%j+A(j,203)%j+A(j,204)%j+A(j,208)%j-A(j,232)%j-A(j,234)%j+A(j,245)%j+A(j,250)%j &
        +A(j,252)%j)*f(1))/6._/**/REALKIND+((A(j,101)%j-A(j,102)%j-A(j,103)%j+A(j,105)%j+A(j,116)%j-A(j,117)%j-A(j,130)%j &
        +A(j,132)%j-A(j,335)%j-A(j,337)%j+A(j,350)%j+A(j,351)%j+A(j,355)%j+A(j,359)%j-A(j,401)%j+A(j,403)%j+A(j,407)%j-A(j,429)%j &
        +A(j,431)%j+A(j,447)%j+A(j,732)%j+A(j,733)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,205)%j-A(j,207)%j+A(j,229)%j+A(j,231)%j &
        +A(j,235)%j-A(j,251)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,55)%j-A(j,56)%j+A(j,58)%j-A(j,60)%j-A(j,74)%j+A(j,75)%j+A(j,77)%j &
        -A(j,78)%j-A(j,82)%j+A(j,84)%j-A(j,262)%j-A(j,264)%j+A(j,266)%j+A(j,267)%j-A(j,276)%j+A(j,334)%j-A(j,354)%j-A(j,356)%j &
        -A(j,400)%j+A(j,408)%j+A(j,430)%j-A(j,734)%j-A(j,735)%j+A(j,785)%j)*f(2))/2._/**/REALKIND
  M1(45) = ((A(j,151)%j-A(j,152)%j+A(j,154)%j-A(j,155)%j+A(j,460)%j+A(j,462)%j+A(j,468)%j+A(j,517)%j+A(j,520)%j+A(j,529)%j &
        +A(j,541)%j+A(j,543)%j)*f(1))/6._/**/REALKIND+((A(j,86)%j-A(j,87)%j+A(j,106)%j-A(j,107)%j+A(j,124)%j-A(j,125)%j+A(j,127)%j &
        -A(j,128)%j-A(j,283)%j-A(j,287)%j+A(j,288)%j-A(j,339)%j+A(j,340)%j+A(j,363)%j+A(j,425)%j+A(j,427)%j+A(j,439)%j+A(j,441)%j &
        +A(j,451)%j+A(j,455)%j+A(j,578)%j+A(j,579)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,464)%j-A(j,465)%j-A(j,514)%j-A(j,516)%j &
        -A(j,522)%j-A(j,542)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,55)%j-A(j,57)%j-A(j,62)%j+A(j,63)%j-A(j,67)%j+A(j,68)%j+A(j,79)%j &
        -A(j,80)%j-A(j,82)%j+A(j,83)%j+A(j,263)%j-A(j,264)%j+A(j,268)%j-A(j,270)%j+A(j,272)%j-A(j,284)%j+A(j,289)%j-A(j,342)%j &
        -A(j,424)%j-A(j,442)%j-A(j,452)%j-A(j,577)%j-A(j,585)%j-A(j,782)%j)*f(2))/2._/**/REALKIND
  M1(46) = ((-A(j,127)%j+A(j,128)%j-A(j,130)%j+A(j,131)%j-A(j,371)%j-A(j,372)%j-A(j,376)%j-A(j,427)%j-A(j,429)%j-A(j,439)%j &
        -A(j,451)%j-A(j,453)%j)*f(1))/6._/**/REALKIND+((-A(j,32)%j+A(j,33)%j-A(j,52)%j+A(j,53)%j-A(j,148)%j+A(j,149)%j-A(j,151)%j &
        +A(j,152)%j+A(j,179)%j-A(j,181)%j+A(j,185)%j-A(j,234)%j+A(j,236)%j-A(j,258)%j-A(j,515)%j-A(j,517)%j-A(j,529)%j-A(j,532)%j &
        -A(j,541)%j-A(j,544)%j-A(j,617)%j-A(j,619)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,373)%j+A(j,375)%j+A(j,424)%j+A(j,426)%j &
        +A(j,430)%j+A(j,452)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,1)%j+A(j,3)%j+A(j,11)%j-A(j,12)%j+A(j,13)%j-A(j,14)%j-A(j,22)%j &
        +A(j,23)%j+A(j,28)%j-A(j,29)%j-A(j,157)%j+A(j,159)%j-A(j,164)%j+A(j,165)%j-A(j,170)%j+A(j,178)%j-A(j,186)%j+A(j,235)%j &
        +A(j,514)%j+A(j,533)%j+A(j,542)%j+A(j,618)%j+A(j,624)%j+A(j,781)%j)*f(2))/2._/**/REALKIND
  M1(47) = ((-A(j,103)%j+A(j,104)%j-A(j,106)%j+A(j,107)%j-A(j,280)%j-A(j,282)%j-A(j,288)%j-A(j,337)%j-A(j,340)%j-A(j,349)%j &
        -A(j,361)%j-A(j,363)%j)*f(1))/6._/**/REALKIND+((-A(j,46)%j+A(j,47)%j-A(j,49)%j+A(j,50)%j-A(j,134)%j+A(j,135)%j-A(j,154)%j &
        +A(j,155)%j-A(j,230)%j-A(j,232)%j-A(j,244)%j-A(j,246)%j-A(j,256)%j-A(j,260)%j+A(j,463)%j+A(j,467)%j-A(j,468)%j+A(j,519)%j &
        -A(j,520)%j-A(j,543)%j-A(j,580)%j-A(j,582)%j)*f(1))/2._/**/REALKIND+(CI*(A(j,284)%j+A(j,285)%j+A(j,334)%j+A(j,336)%j &
        +A(j,342)%j+A(j,362)%j)*f(2))/6._/**/REALKIND+(CI*(A(j,1)%j-A(j,2)%j+A(j,8)%j-A(j,9)%j-A(j,13)%j+A(j,15)%j-A(j,25)%j &
        +A(j,26)%j-A(j,28)%j+A(j,29)%j-A(j,158)%j-A(j,159)%j-A(j,163)%j-A(j,165)%j-A(j,167)%j+A(j,229)%j+A(j,247)%j+A(j,257)%j &
        +A(j,464)%j-A(j,469)%j+A(j,522)%j+A(j,581)%j+A(j,583)%j+A(j,786)%j)*f(2))/2._/**/REALKIND
  M1(48) = ((A(j,49)%j-A(j,50)%j+A(j,52)%j-A(j,53)%j+A(j,176)%j+A(j,177)%j+A(j,181)%j+A(j,232)%j+A(j,234)%j+A(j,244)%j+A(j,256)%j &
        +A(j,258)%j)*f(1))/6._/**/REALKIND+((A(j,100)%j-A(j,101)%j+A(j,103)%j-A(j,104)%j+A(j,110)%j-A(j,111)%j+A(j,130)%j &
        -A(j,131)%j+A(j,335)%j+A(j,337)%j+A(j,349)%j+A(j,352)%j+A(j,361)%j+A(j,364)%j-A(j,374)%j+A(j,376)%j-A(j,380)%j+A(j,429)%j &
        -A(j,431)%j+A(j,453)%j+A(j,620)%j+A(j,621)%j)*f(1))/2._/**/REALKIND+(CI*(-A(j,178)%j-A(j,180)%j-A(j,229)%j-A(j,231)%j &
        -A(j,235)%j-A(j,257)%j)*f(2))/6._/**/REALKIND+(CI*(-A(j,55)%j+A(j,56)%j-A(j,65)%j+A(j,66)%j+A(j,67)%j-A(j,69)%j+A(j,76)%j &
        -A(j,77)%j+A(j,82)%j-A(j,83)%j+A(j,262)%j+A(j,264)%j+A(j,269)%j+A(j,270)%j+A(j,275)%j-A(j,334)%j-A(j,353)%j-A(j,362)%j &
        -A(j,373)%j+A(j,381)%j-A(j,430)%j-A(j,622)%j-A(j,623)%j-A(j,785)%j)*f(2))/2._/**/REALKIND

end subroutine colourvector


! **********************************************************************
subroutine colint(M, M2colint, extcombs)
! M(i)   = <M|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M|Ci> * <Ci|Cj> * <Cj|M>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M(48)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 48*extcomb
    do i = 1, 48
      do j = 1, 48
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M(i))*K1(i+colmatpos,j)*M(j))
      end do
    end do
  end do

end subroutine colint


! **********************************************************************
subroutine colint2(M1, M2, M2colint, extcombs)
! M1(i)   = <M1|Ci> colour component of matrix element
! M2(i)   = <M2|Ci> colour component of matrix element
! COLINT = <M|M>
!        = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!        = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! M2colint is an array which contains the colour interference for each colour matrix
! The elements of the array extcombs specifies for which external particle
! combinations the colour correlations will be calculated. For particles i,j: i*(i-1)/2+j
! i=j=0 -> 0 means no colour insertion.
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(48), M2(48)
  real(REALKIND),    intent(out) :: M2colint(0:30-1)
  integer,           intent(in)  :: extcombs(:)
  integer :: extcomb, colmatpos, i, j, eco

  M2colint = 0

  do eco = 1, size(extcombs)
    extcomb = extcombs(eco)
    colmatpos = 48*extcomb
    do i = 1, 48
      do j = 1, 48
        M2colint(extcomb) = M2colint(extcomb) + real(conjg(M1(i))*K1(i+colmatpos,j)*M2(j))
      end do
    end do
  end do

end subroutine colint2


! **********************************************************************
subroutine colintmunu(M1, M2, M2colint)
! M1(i)    = <M1|Ci> colour component of matrix element
! M2(i)    = <M2|Ci> colour component of matrix element
! M2colint = <M1|M2>
!          = Sum_{i,j} <M1|Ci> * <Ci|Cj> * <Cj|M2>
!          = colour-summed squared matrix element
! K1(i,j) = <Ci|Cj>
! **********************************************************************
  use ol_colourmatrix_pptttt_tttxtxggg_1_/**/REALKIND, only: K1
  implicit none

  complex(REALKIND), intent(in)  :: M1(48)
  complex(REALKIND), intent(in)  :: M2(48)
  complex(REALKIND),    intent(out) :: M2colint
  integer :: i, j

  M2colint = 0

  do i = 1, 48
    do j = 1, 48
      M2colint = M2colint + M1(i)*K1(i,j)*conjg(M2(j))
    end do
  end do

end subroutine colintmunu

end subroutine amp2


#ifdef PRECISION_dp
subroutine colourvector(M1out, nhelout) &
  & bind(c,name="ol_tree_colvect_pptttt_tttxtxggg_1")
  ! Retrieve M1helarr from cache. Cache must have been filled before by calling amp2().
  ! [out] M1out(:,h): colour vector for each helicity configuration h
  ! [out] nhelout: number of non-vanishing helicity configurations
  implicit none
  complex(DREALKIND) :: M1out(48,128)
  integer, intent(out) :: nhelout
  M1out = M1helarr
  nhelout = nhel
end subroutine colourvector
#endif


! =================================================== !
! Only interfaces for easier usage of AMP2_<procname> !
! =================================================== !

#ifdef PRECISION_dp
subroutine amp2tree(P, M2) &
    & bind(c,name="ol_f_amp2tree_pptttt_tttxtxggg_1")
#else
subroutine amp2tree(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix element without fuss.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ 0 ], M2munu)
  M2 = M2tmp(0)
end subroutine amp2tree


#ifdef PRECISION_dp
subroutine amp2ccone(P, M2, I, J) &
    & bind(c,name="ol_f_amp2ccone_pptttt_tttxtxggg_1")
#else
subroutine amp2ccone(P, M2, I, J)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for the colour correlation matrix for particles I and J.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2ccone


#ifdef PRECISION_dp
subroutine amp2ccall(P, M2) &
    & bind(c,name="ol_f_amp2ccall_pptttt_tttxtxggg_1")
#else
subroutine amp2ccall(P, M2)
#endif
  ! This is an interface for AMP2.
  ! Calculates the squared matrix for all colour correlation matrices.
  ! The correlation between particles i and j is at position i*(i-1)/2+j of the array M2.
  ! M2(0) is AMP2tree
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer :: k
  call amp2(P, M2, 0, [ 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND, 0._/**/REALKIND ], &
    30, [ (k, k = 0, 30-1) ], M2munu)
end subroutine amp2ccall


#ifdef PRECISION_dp
subroutine amp2hcone(P, M2, I, J, MOM) &
    & bind(c,name="ol_f_amp2hcone_pptttt_tttxtxggg_1")
#else
subroutine amp2hcone(P, M2, I, J, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates the helicity correlation for emitter I with momentum MOM and spectator J
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2
  integer,         intent(in)  :: I, J
  real(REALKIND),  intent(in)  :: MOM(0:3)
  integer        :: extcomb
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  if (J <= I) then
    extcomb = I*(I-1)/2 + J
  else
    extcomb = J*(J-1)/2 + I
  end if
  call amp2(P, M2tmp, I, MOM, 1, [ extcomb ], M2munu)
  M2 = M2tmp(extcomb)
end subroutine amp2hcone


#ifdef PRECISION_dp
subroutine amp2hcall(P, M2, I, MOM) &
    & bind(c,name="ol_f_amp2hcall_pptttt_tttxtxggg_1")
#else
subroutine amp2hcall(P, M2, I, MOM)
#endif
  ! This is an interface for AMP2.
  ! Calculates all helicity correlations for emitter I with momentum MOM.
  ! The correlator for spectator j is at position j of the array M2.
  implicit none
  real(DREALKIND), intent(in)  :: P(0:3,7)
  real(REALKIND),  intent(out) :: M2(7)
  integer,         intent(in)  :: I
  real(REALKIND),  intent(in)  :: MOM(0:3)
  real(REALKIND) :: M2tmp(0:30-1)
  real(REALKIND) :: M2munu(4,4)
  integer        :: J, extcombs(7)
  do J = 1, 7
    if (J <= I) then
      extcombs(J) = I*(I-1)/2 + J
    else
      extcombs(J) = J*(J-1)/2 + I
    end if
  end do
  call amp2(P, M2tmp, I, MOM, 7,extcombs, M2munu)
  do J = 1, 7
    M2(J) = M2tmp(extcombs(J))
  end do
end subroutine amp2hcall


#ifdef PRECISION_dp

subroutine amp2tree_c(p, m2) &
    & bind(c,name="ol_amp2tree_pptttt_tttxtxggg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  f_p = p
  call amp2tree(f_p, f_m2)
  m2 = f_m2
end subroutine amp2tree_c

subroutine amp2ccone_c(p, m2, i, j) &
    & bind(c,name="ol_amp2ccone_pptttt_tttxtxggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  f_p = p
  f_i = i
  f_j = j
  call amp2ccone(f_p, f_m2, f_i, f_j)
  m2 = f_m2
end subroutine amp2ccone_c

subroutine amp2ccall_c(p, m2) &
    & bind(c,name="ol_amp2ccall_pptttt_tttxtxggg_1")
  use, intrinsic :: iso_c_binding, only: c_double
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(0:30-1)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(0:30-1)
  f_p = p
  call amp2ccall(f_p, f_m2)
  m2 = f_m2
end subroutine amp2ccall_c

subroutine amp2hcone_c(p, m2, i, j, mom) &
    & bind(c,name="ol_amp2hcone_pptttt_tttxtxggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2
  integer(c_int), intent(in) :: i, j
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2
  integer :: f_i, f_j
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_j = j
  f_mom = mom
  call amp2hcone(f_p, f_m2, f_i, f_j, f_mom)
  m2 = f_m2
end subroutine amp2hcone_c

subroutine amp2hcall_c(p, m2, i, mom) &
    & bind(c,name="ol_amp2hcall_pptttt_tttxtxggg_1")
  use, intrinsic :: iso_c_binding, only: c_double, c_int
  implicit none
  real(c_double), intent(in)  :: p(0:3,7)
  real(c_double), intent(out) :: m2(7)
  integer(c_int), intent(in) :: i
  real(c_double), intent(in) :: mom(0:3)
  real(DREALKIND) :: f_p(0:3,7)
  real(DREALKIND) :: f_m2(7)
  integer :: f_i
  real(DREALKIND) :: f_mom(0:3)
  f_p = p
  f_i = i
  f_mom = mom
  call amp2hcall(f_p, f_m2, f_i, f_mom)
  m2 = f_m2
end subroutine amp2hcall_c

#endif

end module ol_tree_pptttt_tttxtxggg_1_/**/REALKIND
