
module ol_vamp_4_ppttjj_ttxgggg_1_/**/REALKIND
contains

! **********************************************************************
subroutine vamp_4(M)
! P(0:3,nlegs) = incoming external momenta
! Uses tree structures 'wf', factors 'c', and denominators 'den' from loop_ppttjj_ttxgggg_1.
! Sets colour stripped amplitudes A from the module loop_amplitudes_ppttjj_ttxgggg_1.
! **********************************************************************
  use KIND_TYPES, only: REALKIND, QREALKIND, intkind2
  use ol_parameters_decl_/**/DREALKIND, only: l_switch
  use ol_parameters_decl_/**/QREALKIND ! masses
  use ol_vert_interface_/**/REALKIND
  use ol_prop_interface_/**/REALKIND
  use ol_last_step_/**/REALKIND
  use ol_tables_storage_ppttjj_ttxgggg_1_/**/DREALKIND
  use ol_tensor_sum_storage_ppttjj_ttxgggg_1_/**/REALKIND
  use ol_loop_handling_/**/REALKIND
  use ofred_reduction_/**/REALKIND, only: Hotf_4pt_reduction, Hotf_4pt_reduction_last
  use ofred_reduction_/**/REALKIND, only: Hotf_5pt_reduction, Hotf_5pt_reduction_last
  use ol_loop_reduction_/**/REALKIND, only: TI_bubble_red, TI_triangle_red
use ol_loop_reduction_/**/REALKIND, only: compute_scalar_box

  use ol_loop_storage_ppttjj_ttxgggg_1_/**/REALKIND
#ifndef PRECISION_dp
  use ol_loop_storage_ppttjj_ttxgggg_1_/**/DREALKIND, only: &
    & ntryL, p_switch, Hel, merge_step, merge_mism, merge_tables, merge_hels
#endif
  use hol_initialisation_/**/REALKIND, only: G0_hol_initialisation
  use ol_h_vert_interface_/**/REALKIND
  use ol_h_prop_interface_/**/REALKIND
  use ol_h_last_step_/**/REALKIND
  use ol_merging_/**/REALKIND, only: ol_merge, ol_merge_tensors, ol_merge_last

  implicit none

  type(Hpolcont) :: Gcoeff(64)
  type(Hpolcont), intent(in) :: M(50,64)


#ifndef PRECISION_dp
  if (ntryL==1 .OR. p_switch == 1) Gcoeff(:)%hf = Hel
#else
  if (ntryL==1 .OR. p_switch == 2) Gcoeff(:)%hf = Hel
#endif

  ! =============================================
  Gcoeff(:)%j = (c(19)*M(15,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(31,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(307),h0tab(:,307),[32,1,2,16,12],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(79),m3h2x32(:,199),heltab2x64(:,:,199))
  Gcoeff(:)%j = (c(19)*M(13,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(30,:)%j+M(31,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(308),h0tab(:,308),[32,1,2,16,12],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(80),m3h2x32(:,200),heltab2x64(:,:,200))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j &
    +M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(309),h0tab(:,309),[32,1,2,16,12],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(81),m3h2x32(:,201),heltab2x64(:,:,201))
  Gcoeff(:)%j = (c(19)*M(7,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(310),h0tab(:,310),[32,1,2,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(82),m3h2x32(:,202),heltab2x64(:,:,202))
  Gcoeff(:)%j = (c(19)*M(1,:)%j+c(16)*(M(25,:)%j+M(27,:)%j+M(29,:)%j+M(31,:)%j+M(33,:)%j+M(35,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(311),h0tab(:,311),[32,1,2,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(83),m3h2x32(:,203),heltab2x64(:,:,203))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(312),h0tab(:,312),[32,1,2,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(84),m3h2x32(:,204),heltab2x64(:,:,204))
  Gcoeff(:)%j = (c(19)*M(18,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(42,:)%j &
    -M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(313),h0tab(:,313),[32,12,1,2,16],[0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(85),m3h2x32(:,205),heltab2x64(:,:,205))
  Gcoeff(:)%j = (c(19)*M(17,:)%j+c(16)*(M(25,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(41,:)%j-M(42,:)%j &
    -M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(314),h0tab(:,314),[32,12,1,2,16],[0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(86),m3h2x32(:,206),heltab2x64(:,:,206))
  Gcoeff(:)%j = (c(19)*(M(17,:)%j-M(18,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(315),h0tab(:,315),[32,12,1,2,16],[0,0,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(87),m3h2x32(:,207),heltab2x64(:,:,207))
  Gcoeff(:)%j = (c(19)*M(23,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j &
    -M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(316),h0tab(:,316),[32,2,1,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(88),m3h2x32(:,208),heltab2x64(:,:,208))
  Gcoeff(:)%j = (c(19)*M(24,:)%j+c(16)*(M(26,:)%j+M(28,:)%j+M(30,:)%j+M(32,:)%j+M(34,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j-M(40,:)%j &
    -M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(317),h0tab(:,317),[32,2,1,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(89),m3h2x32(:,209),heltab2x64(:,:,209))
  Gcoeff(:)%j = (c(19)*(-M(23,:)%j+M(24,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(318),h0tab(:,318),[32,2,1,12,16],[0,nMT,0,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(90),m3h2x32(:,210),heltab2x64(:,:,210))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j+M(31,:)%j+M(36,:)%j-M(37,:)%j-M(40,:)%j-M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(319),h0tab(:,319),[32,1,16,2,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(91),m3h2x32(:,211),heltab2x64(:,:,211))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j+M(31,:)%j+M(35,:)%j-M(39,:)%j-M(40,:)%j-M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(320),h0tab(:,320),[32,1,16,2,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(92),m3h2x32(:,212),heltab2x64(:,:,212))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(45,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(321),h0tab(:,321),[32,1,16,2,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(93),m3h2x32(:,213),heltab2x64(:,:,213))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j-M(33,:)%j-M(35,:)%j+M(41,:)%j+M(42,:)%j+M(44,:)%j-M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(322),h0tab(:,322),[32,1,16,12,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,214),heltab2x64(:,:,214))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(94),n2h32(85))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j-M(33,:)%j-M(36,:)%j+M(38,:)%j+M(42,:)%j+M(44,:)%j-M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(323),h0tab(:,323),[32,1,16,12,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,215),heltab2x64(:,:,215))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(95),n2h32(86))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(46,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(324),h0tab(:,324),[32,1,16,12,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,216),heltab2x64(:,:,216))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(96),n2h32(87))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j-M(32,:)%j-M(35,:)%j+M(39,:)%j+M(42,:)%j+M(44,:)%j-M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(325),h0tab(:,325),[32,2,16,1,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(97),m3h2x32(:,217),heltab2x64(:,:,217))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j-M(32,:)%j-M(36,:)%j+M(37,:)%j+M(42,:)%j+M(44,:)%j-M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(326),h0tab(:,326),[32,2,16,1,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(98),m3h2x32(:,218),heltab2x64(:,:,218))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(46,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(327),h0tab(:,327),[32,2,16,1,12],[0,nMT,nMT,0,0],6,0)
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(99),m3h2x32(:,219),heltab2x64(:,:,219))
  Gcoeff(:)%j = (c(16)*(M(36,:)%j-M(42,:)%j-M(44,:)%j+M(46,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(328),h0tab(:,328),[32,2,12,1,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,220),heltab2x64(:,:,220))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(100),n2h32(88))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(42,:)%j-M(44,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(329),h0tab(:,329),[32,2,12,1,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,221),heltab2x64(:,:,221))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(101),n2h32(89))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(36,:)%j-M(46,:)%j+M(50,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(330),h0tab(:,330),[32,2,12,1,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,222),heltab2x64(:,:,222))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(102),n2h32(90))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j-M(34,:)%j-M(35,:)%j+M(40,:)%j+M(41,:)%j+M(43,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(331),h0tab(:,331),[32,1,12,16,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,223),heltab2x64(:,:,223))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(103),n2h32(91))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j-M(34,:)%j-M(36,:)%j+M(38,:)%j+M(40,:)%j+M(43,:)%j-M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(332),h0tab(:,332),[32,1,12,16,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,224),heltab2x64(:,:,224))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(104),n2h32(92))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(333),h0tab(:,333),[32,1,12,16,2],[nMT,0,0,0,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,225),heltab2x64(:,:,225))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(105),n2h32(93))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(40,:)%j-M(43,:)%j+M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(334),h0tab(:,334),[32,1,12,2,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,226),heltab2x64(:,:,226))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(106),n2h32(94))
  Gcoeff(:)%j = (c(16)*(M(36,:)%j-M(40,:)%j-M(43,:)%j+M(45,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(335),h0tab(:,335),[32,1,12,2,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,227),heltab2x64(:,:,227))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(107),n2h32(95))
  Gcoeff(:)%j = (c(16)*(-M(35,:)%j+M(36,:)%j+M(45,:)%j-M(48,:)%j))
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(336),h0tab(:,336),[32,1,12,2,16],[nMT,0,0,nMT,nMT],6,0)
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,228),heltab2x64(:,:,228))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(108),n2h32(96))
  Gcoeff(:)%j = (-(c(28)*M(13,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(337),h0tab(:,337),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,229),heltab2x64(:,:,229))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(109),n2h32(97))
  Gcoeff(:)%j = (-(c(26)*M(13,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(338),h0tab(:,338),[32,3,16,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,230),heltab2x64(:,:,230))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(110),n2h32(98))
  Gcoeff(:)%j = (-(c(28)*M(21,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(339),h0tab(:,339),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,231),heltab2x64(:,:,231))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(111),n2h32(99))
  Gcoeff(:)%j = (-(c(26)*M(21,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(340),h0tab(:,340),[32,3,16,4,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,232),heltab2x64(:,:,232))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(112),n2h32(100))
  Gcoeff(:)%j = (-(c(28)*M(13,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(341),h0tab(:,341),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,233),heltab2x64(:,:,233))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(113),n2h32(101))
  Gcoeff(:)%j = (-(c(26)*M(13,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(342),h0tab(:,342),[32,3,16,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,234),heltab2x64(:,:,234))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(114),n2h32(102))
  Gcoeff(:)%j = (-(c(28)*M(21,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(343),h0tab(:,343),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,235),heltab2x64(:,:,235))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(115),n2h32(103))
  Gcoeff(:)%j = (-(c(26)*M(21,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(344),h0tab(:,344),[32,3,16,4,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,236),heltab2x64(:,:,236))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(116),n2h32(104))
  Gcoeff(:)%j = (c(9)*(M(13,:)%j-M(21,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(345),h0tab(:,345),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(117),m3h2x32(:,237),heltab2x64(:,:,237))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(21,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j &
    +M(32,:)%j+M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j &
    -M(44,:)%j+M(46,:)%j-M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(346),h0tab(:,346),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(118),m3h2x32(:,238),heltab2x64(:,:,238))
  Gcoeff(:)%j = (c(9)*(-M(13,:)%j+M(21,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j &
    +M(32,:)%j+M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j &
    -M(44,:)%j+M(46,:)%j-M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(347),h0tab(:,347),[32,3,16,4,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(119),m3h2x32(:,239),heltab2x64(:,:,239))
  Gcoeff(:)%j = (-(c(28)*M(23,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(348),h0tab(:,348),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,240),heltab2x64(:,:,240))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(120),n2h32(105))
  Gcoeff(:)%j = (-(c(26)*M(23,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(349),h0tab(:,349),[32,3,8,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,241),heltab2x64(:,:,241))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(121),n2h32(106))
  Gcoeff(:)%j = (-(c(28)*M(7,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(350),h0tab(:,350),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,242),heltab2x64(:,:,242))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(122),n2h32(107))
  Gcoeff(:)%j = (-(c(26)*M(7,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(351),h0tab(:,351),[32,3,8,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,243),heltab2x64(:,:,243))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(123),n2h32(108))
  Gcoeff(:)%j = (-(c(28)*M(23,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(352),h0tab(:,352),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,244),heltab2x64(:,:,244))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(124),n2h32(109))
  Gcoeff(:)%j = (-(c(26)*M(23,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(353),h0tab(:,353),[32,3,8,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,245),heltab2x64(:,:,245))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(125),n2h32(110))
  Gcoeff(:)%j = (-(c(28)*M(7,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(354),h0tab(:,354),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,246),heltab2x64(:,:,246))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(126),n2h32(111))
  Gcoeff(:)%j = (-(c(26)*M(7,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(355),h0tab(:,355),[32,3,8,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,247),heltab2x64(:,:,247))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(127),n2h32(112))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(23,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(356),h0tab(:,356),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(128),m3h2x32(:,248),heltab2x64(:,:,248))
  Gcoeff(:)%j = (c(9)*(M(7,:)%j-M(23,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(46,:)%j-M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(357),h0tab(:,357),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(129),m3h2x32(:,249),heltab2x64(:,:,249))
  Gcoeff(:)%j = (c(9)*(-M(7,:)%j+M(23,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(358),h0tab(:,358),[32,3,8,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(130),m3h2x32(:,250),heltab2x64(:,:,250))
  Gcoeff(:)%j = (-(c(28)*M(19,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(359),h0tab(:,359),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,251),heltab2x64(:,:,251))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(131),n2h32(113))
  Gcoeff(:)%j = (-(c(26)*M(19,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(360),h0tab(:,360),[32,3,16,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,252),heltab2x64(:,:,252))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(132),n2h32(114))
  Gcoeff(:)%j = (-(c(28)*M(15,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(361),h0tab(:,361),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,253),heltab2x64(:,:,253))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(133),n2h32(115))
  Gcoeff(:)%j = (-(c(26)*M(15,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(362),h0tab(:,362),[32,3,16,8,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,254),heltab2x64(:,:,254))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(134),n2h32(116))
  Gcoeff(:)%j = (-(c(28)*M(19,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(363),h0tab(:,363),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,255),heltab2x64(:,:,255))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(135),n2h32(117))
  Gcoeff(:)%j = (-(c(26)*M(19,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(364),h0tab(:,364),[32,3,16,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,256),heltab2x64(:,:,256))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(136),n2h32(118))
  Gcoeff(:)%j = (-(c(28)*M(15,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(365),h0tab(:,365),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,257),heltab2x64(:,:,257))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(137),n2h32(119))
  Gcoeff(:)%j = (-(c(26)*M(15,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(366),h0tab(:,366),[32,3,16,8,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,258),heltab2x64(:,:,258))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(138),n2h32(120))
  Gcoeff(:)%j = (c(9)*(-M(15,:)%j+M(19,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j &
    +M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j+M(43,:)%j &
    -M(44,:)%j-M(45,:)%j+M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(367),h0tab(:,367),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(139),m3h2x32(:,259),heltab2x64(:,:,259))
  Gcoeff(:)%j = (c(9)*(M(15,:)%j-M(19,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(368),h0tab(:,368),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(140),m3h2x32(:,260),heltab2x64(:,:,260))
  Gcoeff(:)%j = (c(9)*(-M(15,:)%j+M(19,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j &
    +M(32,:)%j+M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j+M(43,:)%j &
    -M(44,:)%j-M(45,:)%j+M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(369),h0tab(:,369),[32,3,16,8,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(141),m3h2x32(:,261),heltab2x64(:,:,261))
  Gcoeff(:)%j = (-(c(28)*M(17,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(370),h0tab(:,370),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,262),heltab2x64(:,:,262))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(142),n2h32(121))
  Gcoeff(:)%j = (-(c(26)*M(17,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(371),h0tab(:,371),[32,4,8,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,263),heltab2x64(:,:,263))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(143),n2h32(122))
  Gcoeff(:)%j = (-(c(28)*M(8,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(372),h0tab(:,372),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,264),heltab2x64(:,:,264))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(144),n2h32(123))
  Gcoeff(:)%j = (-(c(26)*M(8,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(373),h0tab(:,373),[32,4,8,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,265),heltab2x64(:,:,265))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(145),n2h32(124))
  Gcoeff(:)%j = (-(c(28)*M(17,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(374),h0tab(:,374),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,266),heltab2x64(:,:,266))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(146),n2h32(125))
  Gcoeff(:)%j = (-(c(26)*M(17,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(375),h0tab(:,375),[32,4,8,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,267),heltab2x64(:,:,267))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(147),n2h32(126))
  Gcoeff(:)%j = (-(c(28)*M(8,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(376),h0tab(:,376),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,268),heltab2x64(:,:,268))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(148),n2h32(127))
  Gcoeff(:)%j = (-(c(26)*M(8,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(377),h0tab(:,377),[32,4,8,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,269),heltab2x64(:,:,269))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(149),n2h32(128))
  Gcoeff(:)%j = (c(9)*(-M(8,:)%j+M(17,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    -M(45,:)%j+M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(378),h0tab(:,378),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(150),m3h2x32(:,270),heltab2x64(:,:,270))
  Gcoeff(:)%j = (c(9)*(M(8,:)%j-M(17,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(379),h0tab(:,379),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(151),m3h2x32(:,271),heltab2x64(:,:,271))
  Gcoeff(:)%j = (c(9)*(M(8,:)%j-M(17,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(380),h0tab(:,380),[32,4,8,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(152),m3h2x32(:,272),heltab2x64(:,:,272))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(381),h0tab(:,381),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,273),heltab2x64(:,:,273))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(153),n2h32(129))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(382),h0tab(:,382),[32,3,4,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,274),heltab2x64(:,:,274))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(154),n2h32(130))
  Gcoeff(:)%j = (-(c(28)*M(24,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(383),h0tab(:,383),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,275),heltab2x64(:,:,275))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(155),n2h32(131))
  Gcoeff(:)%j = (-(c(26)*M(24,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(384),h0tab(:,384),[32,3,4,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,276),heltab2x64(:,:,276))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(156),n2h32(132))
  Gcoeff(:)%j = (-(c(28)*M(1,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(385),h0tab(:,385),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,277),heltab2x64(:,:,277))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(157),n2h32(133))
  Gcoeff(:)%j = (-(c(26)*M(1,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(386),h0tab(:,386),[32,3,4,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,278),heltab2x64(:,:,278))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(158),n2h32(134))
  Gcoeff(:)%j = (-(c(28)*M(24,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(387),h0tab(:,387),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,279),heltab2x64(:,:,279))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(159),n2h32(135))
  Gcoeff(:)%j = (-(c(26)*M(24,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(388),h0tab(:,388),[32,3,4,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,280),heltab2x64(:,:,280))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(160),n2h32(136))
  Gcoeff(:)%j = (c(9)*(M(1,:)%j-M(24,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    -M(45,:)%j+M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(389),h0tab(:,389),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(161),m3h2x32(:,281),heltab2x64(:,:,281))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(24,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(390),h0tab(:,390),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(162),m3h2x32(:,282),heltab2x64(:,:,282))
  Gcoeff(:)%j = (c(9)*(-M(1,:)%j+M(24,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(391),h0tab(:,391),[32,3,4,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(163),m3h2x32(:,283),heltab2x64(:,:,283))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(392),h0tab(:,392),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,284),heltab2x64(:,:,284))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(164),n2h32(137))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(393),h0tab(:,393),[32,8,4,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,285),heltab2x64(:,:,285))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(165),n2h32(138))
  Gcoeff(:)%j = (-(c(28)*M(18,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(394),h0tab(:,394),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,286),heltab2x64(:,:,286))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(166),n2h32(139))
  Gcoeff(:)%j = (-(c(26)*M(18,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(395),h0tab(:,395),[32,8,4,3,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,287),heltab2x64(:,:,287))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(167),n2h32(140))
  Gcoeff(:)%j = (-(c(28)*M(2,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(396),h0tab(:,396),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,288),heltab2x64(:,:,288))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(168),n2h32(141))
  Gcoeff(:)%j = (-(c(26)*M(2,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(397),h0tab(:,397),[32,8,4,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,289),heltab2x64(:,:,289))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(169),n2h32(142))
  Gcoeff(:)%j = (-(c(28)*M(18,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(398),h0tab(:,398),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,290),heltab2x64(:,:,290))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(170),n2h32(143))
  Gcoeff(:)%j = (-(c(26)*M(18,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(399),h0tab(:,399),[32,8,4,3,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,291),heltab2x64(:,:,291))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(171),n2h32(144))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(400),h0tab(:,400),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(172),m3h2x32(:,292),heltab2x64(:,:,292))
  Gcoeff(:)%j = (c(9)*(-M(2,:)%j+M(18,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(46,:)%j-M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(401),h0tab(:,401),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(173),m3h2x32(:,293),heltab2x64(:,:,293))
  Gcoeff(:)%j = (c(9)*(M(2,:)%j-M(18,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(402),h0tab(:,402),[32,8,4,3,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(174),m3h2x32(:,294),heltab2x64(:,:,294))
  Gcoeff(:)%j = (-(c(28)*M(20,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(403),h0tab(:,403),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,295),heltab2x64(:,:,295))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(175),n2h32(145))
  Gcoeff(:)%j = (-(c(26)*M(20,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(404),h0tab(:,404),[32,3,8,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,296),heltab2x64(:,:,296))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(176),n2h32(146))
  Gcoeff(:)%j = (-(c(28)*M(9,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(405),h0tab(:,405),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,297),heltab2x64(:,:,297))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(177),n2h32(147))
  Gcoeff(:)%j = (-(c(26)*M(9,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(406),h0tab(:,406),[32,3,8,16,4],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,298),heltab2x64(:,:,298))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(178),n2h32(148))
  Gcoeff(:)%j = (-(c(28)*M(20,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(407),h0tab(:,407),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,299),heltab2x64(:,:,299))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(179),n2h32(149))
  Gcoeff(:)%j = (-(c(26)*M(20,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(408),h0tab(:,408),[32,3,8,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,300),heltab2x64(:,:,300))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(180),n2h32(150))
  Gcoeff(:)%j = (-(c(28)*M(9,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(409),h0tab(:,409),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,301),heltab2x64(:,:,301))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(181),n2h32(151))
  Gcoeff(:)%j = (-(c(26)*M(9,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(410),h0tab(:,410),[32,3,8,16,4],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,302),heltab2x64(:,:,302))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(182),n2h32(152))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(47,:)%j+M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(411),h0tab(:,411),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(183),m3h2x32(:,303),heltab2x64(:,:,303))
  Gcoeff(:)%j = (c(9)*(M(9,:)%j-M(20,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(412),h0tab(:,412),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(184),m3h2x32(:,304),heltab2x64(:,:,304))
  Gcoeff(:)%j = (c(9)*(-M(9,:)%j+M(20,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(47,:)%j+M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(413),h0tab(:,413),[32,3,8,16,4],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(185),m3h2x32(:,305),heltab2x64(:,:,305))
  Gcoeff(:)%j = (-(c(28)*M(11,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(414),h0tab(:,414),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,306),heltab2x64(:,:,306))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(186),n2h32(153))
  Gcoeff(:)%j = (-(c(26)*M(11,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(415),h0tab(:,415),[32,4,16,3,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,307),heltab2x64(:,:,307))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(187),n2h32(154))
  Gcoeff(:)%j = (-(c(28)*M(14,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(416),h0tab(:,416),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,308),heltab2x64(:,:,308))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(188),n2h32(155))
  Gcoeff(:)%j = (-(c(26)*M(14,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(417),h0tab(:,417),[32,4,16,3,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,309),heltab2x64(:,:,309))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(189),n2h32(156))
  Gcoeff(:)%j = (-(c(28)*M(11,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(418),h0tab(:,418),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,310),heltab2x64(:,:,310))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(190),n2h32(157))
  Gcoeff(:)%j = (-(c(26)*M(11,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(419),h0tab(:,419),[32,4,16,3,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,311),heltab2x64(:,:,311))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(191),n2h32(158))
  Gcoeff(:)%j = (-(c(28)*M(14,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(420),h0tab(:,420),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,312),heltab2x64(:,:,312))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(192),n2h32(159))
  Gcoeff(:)%j = (-(c(26)*M(14,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(421),h0tab(:,421),[32,4,16,3,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,313),heltab2x64(:,:,313))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(193),n2h32(160))
  Gcoeff(:)%j = (c(9)*(M(11,:)%j-M(14,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    +M(33,:)%j-M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(47,:)%j+M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(422),h0tab(:,422),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(194),m3h2x32(:,314),heltab2x64(:,:,314))
  Gcoeff(:)%j = (c(9)*(-M(11,:)%j+M(14,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(423),h0tab(:,423),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(195),m3h2x32(:,315),heltab2x64(:,:,315))
  Gcoeff(:)%j = (c(9)*(-M(11,:)%j+M(14,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    -M(33,:)%j+M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(424),h0tab(:,424),[32,4,16,3,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(196),m3h2x32(:,316),heltab2x64(:,:,316))
  Gcoeff(:)%j = (-(c(28)*M(3,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(425),h0tab(:,425),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,317),heltab2x64(:,:,317))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(197),n2h32(161))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(426),h0tab(:,426),[32,3,4,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,318),heltab2x64(:,:,318))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(198),n2h32(162))
  Gcoeff(:)%j = (-(c(28)*M(22,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(427),h0tab(:,427),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,319),heltab2x64(:,:,319))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(199),n2h32(163))
  Gcoeff(:)%j = (-(c(26)*M(22,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(428),h0tab(:,428),[32,3,4,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,320),heltab2x64(:,:,320))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(200),n2h32(164))
  Gcoeff(:)%j = (-(c(28)*M(3,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(429),h0tab(:,429),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,321),heltab2x64(:,:,321))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(201),n2h32(165))
  Gcoeff(:)%j = (-(c(26)*M(3,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(430),h0tab(:,430),[32,3,4,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,322),heltab2x64(:,:,322))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(202),n2h32(166))
  Gcoeff(:)%j = (-(c(28)*M(22,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(431),h0tab(:,431),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,323),heltab2x64(:,:,323))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(203),n2h32(167))
  Gcoeff(:)%j = (-(c(26)*M(22,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(432),h0tab(:,432),[32,3,4,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,324),heltab2x64(:,:,324))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(204),n2h32(168))
  Gcoeff(:)%j = (c(9)*(M(3,:)%j-M(22,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(47,:)%j+M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(433),h0tab(:,433),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(205),m3h2x32(:,325),heltab2x64(:,:,325))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(22,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(434),h0tab(:,434),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(206),m3h2x32(:,326),heltab2x64(:,:,326))
  Gcoeff(:)%j = (c(9)*(-M(3,:)%j+M(22,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(435),h0tab(:,435),[32,3,4,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(207),m3h2x32(:,327),heltab2x64(:,:,327))
  Gcoeff(:)%j = (-(c(28)*M(4,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(436),h0tab(:,436),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,328),heltab2x64(:,:,328))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(208),n2h32(169))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(437),h0tab(:,437),[32,8,3,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,329),heltab2x64(:,:,329))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(209),n2h32(170))
  Gcoeff(:)%j = (-(c(28)*M(12,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(438),h0tab(:,438),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,330),heltab2x64(:,:,330))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(210),n2h32(171))
  Gcoeff(:)%j = (-(c(26)*M(12,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(439),h0tab(:,439),[32,8,3,4,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,331),heltab2x64(:,:,331))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(211),n2h32(172))
  Gcoeff(:)%j = (-(c(28)*M(4,:)%j)+c(27)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(440),h0tab(:,440),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,332),heltab2x64(:,:,332))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(212),n2h32(173))
  Gcoeff(:)%j = (-(c(26)*M(4,:)%j)+c(25)*M(48,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(441),h0tab(:,441),[32,8,3,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,333),heltab2x64(:,:,333))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(213),n2h32(174))
  Gcoeff(:)%j = (-(c(28)*M(12,:)%j)+c(27)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(442),h0tab(:,442),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,334),heltab2x64(:,:,334))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(214),n2h32(175))
  Gcoeff(:)%j = (-(c(26)*M(12,:)%j)+c(25)*M(46,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(443),h0tab(:,443),[32,8,3,4,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,335),heltab2x64(:,:,335))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(215),n2h32(176))
  Gcoeff(:)%j = (c(9)*(M(4,:)%j-M(12,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(40,:)%j+M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(46,:)%j-M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(444),h0tab(:,444),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(216),m3h2x32(:,336),heltab2x64(:,:,336))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(12,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(445),h0tab(:,445),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(217),m3h2x32(:,337),heltab2x64(:,:,337))
  Gcoeff(:)%j = (c(9)*(-M(4,:)%j+M(12,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(40,:)%j-M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(46,:)%j+M(48,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(446),h0tab(:,446),[32,8,3,4,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(218),m3h2x32(:,338),heltab2x64(:,:,338))
  Gcoeff(:)%j = (-(c(28)*M(5,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(447),h0tab(:,447),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,339),heltab2x64(:,:,339))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(219),n2h32(177))
  Gcoeff(:)%j = (-(c(26)*M(5,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(448),h0tab(:,448),[32,4,3,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,340),heltab2x64(:,:,340))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(220),n2h32(178))
  Gcoeff(:)%j = (-(c(28)*M(16,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(449),h0tab(:,449),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,341),heltab2x64(:,:,341))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(221),n2h32(179))
  Gcoeff(:)%j = (-(c(26)*M(16,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(450),h0tab(:,450),[32,4,3,16,8],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,342),heltab2x64(:,:,342))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(222),n2h32(180))
  Gcoeff(:)%j = (-(c(28)*M(5,:)%j)+c(27)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(451),h0tab(:,451),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,343),heltab2x64(:,:,343))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(223),n2h32(181))
  Gcoeff(:)%j = (-(c(26)*M(5,:)%j)+c(25)*M(49,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(452),h0tab(:,452),[32,4,3,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,344),heltab2x64(:,:,344))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(224),n2h32(182))
  Gcoeff(:)%j = (-(c(28)*M(16,:)%j)+c(27)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(453),h0tab(:,453),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,345),heltab2x64(:,:,345))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(225),n2h32(183))
  Gcoeff(:)%j = (-(c(26)*M(16,:)%j)+c(25)*M(47,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(454),h0tab(:,454),[32,4,3,16,8],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,346),heltab2x64(:,:,346))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(226),n2h32(184))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(16,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(455),h0tab(:,455),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(227),m3h2x32(:,347),heltab2x64(:,:,347))
  Gcoeff(:)%j = (c(9)*(-M(5,:)%j+M(16,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j-M(29,:)%j+M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j-M(37,:)%j+M(38,:)%j+M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(43,:)%j+M(44,:)%j &
    -M(47,:)%j+M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(456),h0tab(:,456),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(228),m3h2x32(:,348),heltab2x64(:,:,348))
  Gcoeff(:)%j = (c(9)*(M(5,:)%j-M(16,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j+M(29,:)%j-M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j+M(37,:)%j-M(38,:)%j-M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(43,:)%j-M(44,:)%j &
    +M(47,:)%j-M(49,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(457),h0tab(:,457),[32,4,3,16,8],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(229),m3h2x32(:,349),heltab2x64(:,:,349))
  Gcoeff(:)%j = (-(c(28)*M(6,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(458),h0tab(:,458),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,350),heltab2x64(:,:,350))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(230),n2h32(185))
  Gcoeff(:)%j = (-(c(26)*M(6,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(459),h0tab(:,459),[32,4,3,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,351),heltab2x64(:,:,351))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(231),n2h32(186))
  Gcoeff(:)%j = (-(c(28)*M(10,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(460),h0tab(:,460),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,352),heltab2x64(:,:,352))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(232),n2h32(187))
  Gcoeff(:)%j = (-(c(26)*M(10,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(461),h0tab(:,461),[32,4,3,8,16],[nMT,nMT,nMT,nMT,nMT],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,353),heltab2x64(:,:,353))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(233),n2h32(188))
  Gcoeff(:)%j = (-(c(28)*M(6,:)%j)+c(27)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(462),h0tab(:,462),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,354),heltab2x64(:,:,354))
  call Hloop_Q_A(ntryL,G0H32(1),32,0,G1H32(234),n2h32(189))
  Gcoeff(:)%j = (-(c(26)*M(6,:)%j)+c(25)*M(50,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(463),h0tab(:,463),[32,4,3,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,355),heltab2x64(:,:,355))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMB,G1H32(235),n2h32(190))
  Gcoeff(:)%j = (-(c(28)*M(10,:)%j)+c(27)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(464),h0tab(:,464),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,356),heltab2x64(:,:,356))
  call Hloop_A_Q(ntryL,G0H32(1),32,0,G1H32(236),n2h32(191))
  Gcoeff(:)%j = (-(c(26)*M(10,:)%j)+c(25)*M(45,:)%j) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(465),h0tab(:,465),[32,4,3,8,16],[nMB,nMB,nMB,nMB,nMB],5,1,wf4(:,1))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,357),heltab2x64(:,:,357))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMB,G1H32(237),n2h32(192))
  Gcoeff(:)%j = (c(9)*(M(6,:)%j-M(10,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(466),h0tab(:,466),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_CV_D(ntryL,G0H64(1),0,ex6(:),32,G1H32(238),m3h2x32(:,358),heltab2x64(:,:,358))
  Gcoeff(:)%j = (c(9)*(-M(6,:)%j+M(10,:)%j)+c(6)*(M(25,:)%j-M(26,:)%j+M(27,:)%j-M(28,:)%j+M(29,:)%j-M(30,:)%j-M(31,:)%j+M(32,:)%j &
    -M(33,:)%j+M(34,:)%j-M(35,:)%j+M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j &
    -M(45,:)%j+M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(467),h0tab(:,467),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_DV_C(ntryL,G0H64(1),0,ex6(:),G1H32(239),m3h2x32(:,359),heltab2x64(:,:,359))
  Gcoeff(:)%j = (c(9)*(M(6,:)%j-M(10,:)%j)+c(6)*(-M(25,:)%j+M(26,:)%j-M(27,:)%j+M(28,:)%j-M(29,:)%j+M(30,:)%j+M(31,:)%j-M(32,:)%j &
    +M(33,:)%j-M(34,:)%j+M(35,:)%j-M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j &
    +M(45,:)%j-M(50,:)%j)) * den(1)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(468),h0tab(:,468),[32,4,3,8,16],[0,0,0,0,0],5,1,wf4(:,1))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(240),m3h2x32(:,360),heltab2x64(:,:,360))
  Gcoeff(:)%j = (c(6)*(M(34,:)%j-M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(469),h0tab(:,469),[32,5,16,2,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,361),heltab2x64(:,:,361))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(241),n2h32(193))
  Gcoeff(:)%j = (c(16)*(-M(32,:)%j-M(36,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(470),h0tab(:,470),[32,5,16,2,8],[0,nMT,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(242),m3h2x32(:,362),heltab2x64(:,:,362))
  Gcoeff(:)%j = (c(6)*(M(36,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(471),h0tab(:,471),[32,5,8,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,363),heltab2x64(:,:,363))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(243),n2h32(194))
  Gcoeff(:)%j = (c(16)*(-M(32,:)%j-M(34,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(472),h0tab(:,472),[32,5,8,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(244),m3h2x32(:,364),heltab2x64(:,:,364))
  Gcoeff(:)%j = (c(6)*(M(32,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(473),h0tab(:,473),[32,2,8,16,5],[0,nMT,nMT,nMT,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(245),m3h2x32(:,365),heltab2x64(:,:,365))
  Gcoeff(:)%j = (c(16)*(-M(34,:)%j-M(36,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(474),h0tab(:,474),[32,2,8,16,5],[nMT,0,0,0,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,366),heltab2x64(:,:,366))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(246),n2h32(195))
  Gcoeff(:)%j = (c(6)*(-M(36,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(475),h0tab(:,475),[32,2,8,5,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,367),heltab2x64(:,:,367))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(247),n2h32(196))
  Gcoeff(:)%j = (c(16)*(-M(32,:)%j-M(34,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(476),h0tab(:,476),[32,2,8,5,16],[0,nMT,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(248),m3h2x32(:,368),heltab2x64(:,:,368))
  Gcoeff(:)%j = (-(c(15)*M(10,:)%j)+c(16)*M(43,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(477),h0tab(:,477),[32,5,2,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,369),heltab2x64(:,:,369))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(249),n2h32(197))
  Gcoeff(:)%j = (-(c(9)*M(10,:)%j)+c(6)*(-M(32,:)%j-M(34,:)%j-M(36,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(478),h0tab(:,478),[32,5,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(250),m3h2x32(:,370),heltab2x64(:,:,370))
  Gcoeff(:)%j = (-(c(15)*M(12,:)%j)+c(16)*M(44,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(479),h0tab(:,479),[32,8,2,5,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,371),heltab2x64(:,:,371))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(251),n2h32(198))
  Gcoeff(:)%j = (c(9)*M(12,:)%j+c(6)*(M(32,:)%j+M(34,:)%j+M(36,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(480),h0tab(:,480),[32,8,2,5,16],[0,0,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(252),m3h2x32(:,372),heltab2x64(:,:,372))
  Gcoeff(:)%j = (c(6)*(M(32,:)%j-M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(481),h0tab(:,481),[32,2,16,8,5],[0,nMT,nMT,nMT,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(253),m3h2x32(:,373),heltab2x64(:,:,373))
  Gcoeff(:)%j = (c(16)*(-M(34,:)%j-M(36,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(482),h0tab(:,482),[32,2,16,8,5],[nMT,0,0,0,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,374),heltab2x64(:,:,374))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(254),n2h32(199))
  Gcoeff(:)%j = (c(6)*(-M(34,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(483),h0tab(:,483),[32,2,16,5,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,375),heltab2x64(:,:,375))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(255),n2h32(200))
  Gcoeff(:)%j = (c(16)*(-M(32,:)%j-M(36,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(484),h0tab(:,484),[32,2,16,5,8],[0,nMT,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(256),m3h2x32(:,376),heltab2x64(:,:,376))
  Gcoeff(:)%j = (-(c(15)*M(16,:)%j)+c(16)*M(44,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(485),h0tab(:,485),[32,5,2,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,377),heltab2x64(:,:,377))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(257),n2h32(201))
  Gcoeff(:)%j = (-(c(9)*M(16,:)%j)+c(6)*(-M(32,:)%j-M(34,:)%j-M(36,:)%j+M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(486),h0tab(:,486),[32,5,2,16,8],[0,nMT,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(258),m3h2x32(:,378),heltab2x64(:,:,378))
  Gcoeff(:)%j = (-(c(15)*M(18,:)%j)+c(16)*M(43,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(487),h0tab(:,487),[32,8,5,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,9))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,379),heltab2x64(:,:,379))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(259),n2h32(202))
  Gcoeff(:)%j = (-(c(9)*M(18,:)%j)+c(6)*(-M(32,:)%j-M(34,:)%j-M(36,:)%j+M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(488),h0tab(:,488),[32,8,5,2,16],[0,0,nMT,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(260),m3h2x32(:,380),heltab2x64(:,:,380))
  Gcoeff(:)%j = (-(c(15)*M(22,:)%j)+c(16)*M(43,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(489),h0tab(:,489),[32,2,5,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,381),heltab2x64(:,:,381))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(261),n2h32(203))
  Gcoeff(:)%j = (c(9)*M(22,:)%j+c(6)*(M(32,:)%j+M(34,:)%j+M(36,:)%j-M(44,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(490),h0tab(:,490),[32,2,5,16,8],[0,nMT,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(262),m3h2x32(:,382),heltab2x64(:,:,382))
  Gcoeff(:)%j = (-(c(15)*M(24,:)%j)+c(16)*M(44,:)%j) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(491),h0tab(:,491),[32,2,5,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,9))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,383),heltab2x64(:,:,383))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(263),n2h32(204))
  Gcoeff(:)%j = (c(9)*M(24,:)%j+c(6)*(M(32,:)%j+M(34,:)%j+M(36,:)%j-M(43,:)%j)) * den(22)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(492),h0tab(:,492),[32,2,5,8,16],[0,nMT,0,0,0],5,1,wf4(:,9))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(264),m3h2x32(:,384),heltab2x64(:,:,384))
  Gcoeff(:)%j = (c(6)*(-M(33,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(493),h0tab(:,493),[32,6,16,1,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,385),heltab2x64(:,:,385))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(265),n2h32(205))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(494),h0tab(:,494),[32,6,16,1,8],[0,nMT,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(266),m3h2x32(:,386),heltab2x64(:,:,386))
  Gcoeff(:)%j = (c(6)*(-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(495),h0tab(:,495),[32,6,8,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,387),heltab2x64(:,:,387))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(267),n2h32(206))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(33,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(496),h0tab(:,496),[32,6,8,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(268),m3h2x32(:,388),heltab2x64(:,:,388))
  Gcoeff(:)%j = (c(6)*(-M(31,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(497),h0tab(:,497),[32,1,8,16,6],[0,nMT,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(269),m3h2x32(:,389),heltab2x64(:,:,389))
  Gcoeff(:)%j = (c(16)*(-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(498),h0tab(:,498),[32,1,8,16,6],[nMT,0,0,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,390),heltab2x64(:,:,390))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(270),n2h32(207))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(499),h0tab(:,499),[32,1,8,6,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,391),heltab2x64(:,:,391))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(271),n2h32(208))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(33,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(500),h0tab(:,500),[32,1,8,6,16],[0,nMT,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(272),m3h2x32(:,392),heltab2x64(:,:,392))
  Gcoeff(:)%j = (-(c(15)*M(6,:)%j)+c(16)*M(44,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(501),h0tab(:,501),[32,6,1,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,393),heltab2x64(:,:,393))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(273),n2h32(209))
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(502),h0tab(:,502),[32,6,1,8,16],[0,nMT,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(274),m3h2x32(:,394),heltab2x64(:,:,394))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)+c(16)*M(43,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(503),h0tab(:,503),[32,8,1,6,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,395),heltab2x64(:,:,395))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(275),n2h32(210))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(504),h0tab(:,504),[32,8,1,6,16],[0,0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(276),m3h2x32(:,396),heltab2x64(:,:,396))
  Gcoeff(:)%j = (c(6)*(-M(31,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(505),h0tab(:,505),[32,1,16,8,6],[0,nMT,nMT,nMT,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(277),m3h2x32(:,397),heltab2x64(:,:,397))
  Gcoeff(:)%j = (c(16)*(-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(506),h0tab(:,506),[32,1,16,8,6],[nMT,0,0,0,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,398),heltab2x64(:,:,398))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(278),n2h32(211))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(507),h0tab(:,507),[32,1,16,6,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,399),heltab2x64(:,:,399))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(279),n2h32(212))
  Gcoeff(:)%j = (c(16)*(-M(31,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(508),h0tab(:,508),[32,1,16,6,8],[0,nMT,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(280),m3h2x32(:,400),heltab2x64(:,:,400))
  Gcoeff(:)%j = (-(c(15)*M(5,:)%j)+c(16)*M(43,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(509),h0tab(:,509),[32,6,1,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,401),heltab2x64(:,:,401))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(281),n2h32(213))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(510),h0tab(:,510),[32,6,1,16,8],[0,nMT,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(282),m3h2x32(:,402),heltab2x64(:,:,402))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(16)*M(44,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(511),h0tab(:,511),[32,8,6,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,11))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,403),heltab2x64(:,:,403))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(283),n2h32(214))
  Gcoeff(:)%j = (c(9)*M(2,:)%j+c(6)*(M(31,:)%j+M(33,:)%j+M(35,:)%j-M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(512),h0tab(:,512),[32,8,6,1,16],[0,0,nMT,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(284),m3h2x32(:,404),heltab2x64(:,:,404))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(16)*M(44,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(513),h0tab(:,513),[32,1,6,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,405),heltab2x64(:,:,405))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(285),n2h32(215))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(43,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(514),h0tab(:,514),[32,1,6,16,8],[0,nMT,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(286),m3h2x32(:,406),heltab2x64(:,:,406))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*M(43,:)%j) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(515),h0tab(:,515),[32,1,6,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,11))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,407),heltab2x64(:,:,407))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(287),n2h32(216))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(31,:)%j-M(33,:)%j-M(35,:)%j+M(44,:)%j)) * den(24)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(516),h0tab(:,516),[32,1,6,8,16],[0,nMT,0,0,0],5,1,wf4(:,11))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(288),m3h2x32(:,408),heltab2x64(:,:,408))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(517),h0tab(:,517),[32,4,2,16,9],[nMT,nMT,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,409),heltab2x64(:,:,409))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(289),n2h32(217))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(518),h0tab(:,518),[32,4,2,16,9],[0,0,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(290),m3h2x32(:,410),heltab2x64(:,:,410))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(519),h0tab(:,519),[32,9,4,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,411),heltab2x64(:,:,411))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(291),n2h32(218))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(30,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(520),h0tab(:,520),[32,9,4,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(292),m3h2x32(:,412),heltab2x64(:,:,412))
  Gcoeff(:)%j = (c(6)*(M(28,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(521),h0tab(:,521),[32,2,4,16,9],[0,nMT,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(293),m3h2x32(:,413),heltab2x64(:,:,413))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(522),h0tab(:,522),[32,2,4,16,9],[nMT,0,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,414),heltab2x64(:,:,414))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(294),n2h32(219))
  Gcoeff(:)%j = (c(6)*(-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(523),h0tab(:,523),[32,2,4,9,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,415),heltab2x64(:,:,415))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(295),n2h32(220))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(30,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(524),h0tab(:,524),[32,2,4,9,16],[0,nMT,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(296),m3h2x32(:,416),heltab2x64(:,:,416))
  Gcoeff(:)%j = (-(c(15)*M(4,:)%j)+c(16)*M(40,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(525),h0tab(:,525),[32,9,2,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,417),heltab2x64(:,:,417))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(297),n2h32(221))
  Gcoeff(:)%j = (-(c(9)*M(4,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(526),h0tab(:,526),[32,9,2,4,16],[0,nMT,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(298),m3h2x32(:,418),heltab2x64(:,:,418))
  Gcoeff(:)%j = (-(c(15)*M(6,:)%j)+c(16)*M(42,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(527),h0tab(:,527),[32,4,2,9,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,419),heltab2x64(:,:,419))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(299),n2h32(222))
  Gcoeff(:)%j = (c(9)*M(6,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(528),h0tab(:,528),[32,4,2,9,16],[0,0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(300),m3h2x32(:,420),heltab2x64(:,:,420))
  Gcoeff(:)%j = (c(6)*(M(28,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(529),h0tab(:,529),[32,2,16,4,9],[0,nMT,nMT,nMT,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(301),m3h2x32(:,421),heltab2x64(:,:,421))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(35,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(530),h0tab(:,530),[32,2,16,4,9],[nMT,0,0,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,422),heltab2x64(:,:,422))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(302),n2h32(223))
  Gcoeff(:)%j = (c(6)*(-M(30,:)%j+M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(531),h0tab(:,531),[32,2,16,9,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,423),heltab2x64(:,:,423))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(303),n2h32(224))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(532),h0tab(:,532),[32,2,16,9,4],[0,nMT,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(304),m3h2x32(:,424),heltab2x64(:,:,424))
  Gcoeff(:)%j = (-(c(15)*M(14,:)%j)+c(16)*M(42,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(533),h0tab(:,533),[32,4,16,2,9],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,425),heltab2x64(:,:,425))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(305),n2h32(225))
  Gcoeff(:)%j = (c(9)*M(14,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(534),h0tab(:,534),[32,4,16,2,9],[0,0,0,nMT,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(306),m3h2x32(:,426),heltab2x64(:,:,426))
  Gcoeff(:)%j = (-(c(15)*M(17,:)%j)+c(16)*M(40,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(535),h0tab(:,535),[32,4,9,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,13))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,427),heltab2x64(:,:,427))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(307),n2h32(226))
  Gcoeff(:)%j = (-(c(9)*M(17,:)%j)+c(6)*(-M(28,:)%j-M(30,:)%j-M(35,:)%j+M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(536),h0tab(:,536),[32,4,9,2,16],[0,0,nMT,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(308),m3h2x32(:,428),heltab2x64(:,:,428))
  Gcoeff(:)%j = (-(c(15)*M(20,:)%j)+c(16)*M(40,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(537),h0tab(:,537),[32,2,9,16,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,429),heltab2x64(:,:,429))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(309),n2h32(227))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(42,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(538),h0tab(:,538),[32,2,9,16,4],[0,nMT,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(310),m3h2x32(:,430),heltab2x64(:,:,430))
  Gcoeff(:)%j = (-(c(15)*M(23,:)%j)+c(16)*M(42,:)%j) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(539),h0tab(:,539),[32,2,9,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,13))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,431),heltab2x64(:,:,431))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(311),n2h32(228))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(28,:)%j+M(30,:)%j+M(35,:)%j-M(40,:)%j)) * den(26)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(540),h0tab(:,540),[32,2,9,4,16],[0,nMT,0,0,0],5,1,wf4(:,13))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(312),m3h2x32(:,432),heltab2x64(:,:,432))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(541),h0tab(:,541),[32,4,1,16,10],[nMT,nMT,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,433),heltab2x64(:,:,433))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(313),n2h32(229))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(542),h0tab(:,542),[32,4,1,16,10],[0,0,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(314),m3h2x32(:,434),heltab2x64(:,:,434))
  Gcoeff(:)%j = (c(6)*(-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(543),h0tab(:,543),[32,10,4,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,435),heltab2x64(:,:,435))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(315),n2h32(230))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(29,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(544),h0tab(:,544),[32,10,4,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(316),m3h2x32(:,436),heltab2x64(:,:,436))
  Gcoeff(:)%j = (c(6)*(-M(27,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(545),h0tab(:,545),[32,1,4,16,10],[0,nMT,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(317),m3h2x32(:,437),heltab2x64(:,:,437))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(546),h0tab(:,546),[32,1,4,16,10],[nMT,0,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,438),heltab2x64(:,:,438))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(318),n2h32(231))
  Gcoeff(:)%j = (c(6)*(M(36,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(547),h0tab(:,547),[32,1,4,10,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,439),heltab2x64(:,:,439))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(319),n2h32(232))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(29,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(548),h0tab(:,548),[32,1,4,10,16],[0,nMT,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(320),m3h2x32(:,440),heltab2x64(:,:,440))
  Gcoeff(:)%j = (-(c(15)*M(12,:)%j)+c(16)*M(42,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(549),h0tab(:,549),[32,10,1,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,441),heltab2x64(:,:,441))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(321),n2h32(233))
  Gcoeff(:)%j = (c(9)*M(12,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(550),h0tab(:,550),[32,10,1,4,16],[0,nMT,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(322),m3h2x32(:,442),heltab2x64(:,:,442))
  Gcoeff(:)%j = (-(c(15)*M(10,:)%j)+c(16)*M(40,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(551),h0tab(:,551),[32,4,1,10,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,443),heltab2x64(:,:,443))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(323),n2h32(234))
  Gcoeff(:)%j = (-(c(9)*M(10,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(552),h0tab(:,552),[32,4,1,10,16],[0,0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(324),m3h2x32(:,444),heltab2x64(:,:,444))
  Gcoeff(:)%j = (c(6)*(-M(27,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(553),h0tab(:,553),[32,1,16,4,10],[0,nMT,nMT,nMT,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(325),m3h2x32(:,445),heltab2x64(:,:,445))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(554),h0tab(:,554),[32,1,16,4,10],[nMT,0,0,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,446),heltab2x64(:,:,446))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(326),n2h32(235))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(555),h0tab(:,555),[32,1,16,10,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,447),heltab2x64(:,:,447))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(327),n2h32(236))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(556),h0tab(:,556),[32,1,16,10,4],[0,nMT,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(328),m3h2x32(:,448),heltab2x64(:,:,448))
  Gcoeff(:)%j = (-(c(15)*M(11,:)%j)+c(16)*M(40,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(557),h0tab(:,557),[32,4,16,1,10],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,449),heltab2x64(:,:,449))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(329),n2h32(237))
  Gcoeff(:)%j = (-(c(9)*M(11,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(558),h0tab(:,558),[32,4,16,1,10],[0,0,0,nMT,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(330),m3h2x32(:,450),heltab2x64(:,:,450))
  Gcoeff(:)%j = (-(c(15)*M(8,:)%j)+c(16)*M(42,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(559),h0tab(:,559),[32,4,10,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,15))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,451),heltab2x64(:,:,451))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(331),n2h32(238))
  Gcoeff(:)%j = (c(9)*M(8,:)%j+c(6)*(M(27,:)%j+M(29,:)%j+M(36,:)%j-M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(560),h0tab(:,560),[32,4,10,1,16],[0,0,nMT,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(332),m3h2x32(:,452),heltab2x64(:,:,452))
  Gcoeff(:)%j = (-(c(15)*M(9,:)%j)+c(16)*M(42,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(561),h0tab(:,561),[32,1,10,16,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,453),heltab2x64(:,:,453))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(333),n2h32(239))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(40,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(562),h0tab(:,562),[32,1,10,16,4],[0,nMT,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(334),m3h2x32(:,454),heltab2x64(:,:,454))
  Gcoeff(:)%j = (-(c(15)*M(7,:)%j)+c(16)*M(40,:)%j) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(563),h0tab(:,563),[32,1,10,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,15))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,455),heltab2x64(:,:,455))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(335),n2h32(240))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(27,:)%j-M(29,:)%j-M(36,:)%j+M(42,:)%j)) * den(28)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(564),h0tab(:,564),[32,1,10,4,16],[0,nMT,0,0,0],5,1,wf4(:,15))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(336),m3h2x32(:,456),heltab2x64(:,:,456))
  Gcoeff(:)%j = (c(5)*(M(19,:)%j-M(21,:)%j)+c(6)*(-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(565),h0tab(:,565),[32,2,1,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,457),heltab2x64(:,:,457))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(337),n2h32(241))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(21,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(46,:)%j &
    -M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(566),h0tab(:,566),[32,2,1,16,12],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(338),m3h2x32(:,458),heltab2x64(:,:,458))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(8,:)%j)+c(6)*(-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(567),h0tab(:,567),[32,12,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,459),heltab2x64(:,:,459))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(339),n2h32(242))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(8,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(568),h0tab(:,568),[32,12,2,1,16],[0,0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(340),m3h2x32(:,460),heltab2x64(:,:,460))
  Gcoeff(:)%j = (c(5)*(M(13,:)%j-M(15,:)%j)+c(6)*(-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(569),h0tab(:,569),[32,1,2,16,12],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,461),heltab2x64(:,:,461))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(341),n2h32(243))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(15,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j &
    +M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(570),h0tab(:,570),[32,1,2,16,12],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(342),m3h2x32(:,462),heltab2x64(:,:,462))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(7,:)%j)+c(6)*(-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(571),h0tab(:,571),[32,1,2,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,463),heltab2x64(:,:,463))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(343),n2h32(244))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(7,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(572),h0tab(:,572),[32,1,2,12,16],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(344),m3h2x32(:,464),heltab2x64(:,:,464))
  Gcoeff(:)%j = (c(5)*(M(17,:)%j-M(18,:)%j)+c(6)*(-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(573),h0tab(:,573),[32,12,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,465),heltab2x64(:,:,465))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(345),n2h32(245))
  Gcoeff(:)%j = (c(19)*(M(17,:)%j-M(18,:)%j)+c(16)*(M(35,:)%j-M(36,:)%j+M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j &
    +M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(574),h0tab(:,574),[32,12,1,2,16],[0,0,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(346),m3h2x32(:,466),heltab2x64(:,:,466))
  Gcoeff(:)%j = (c(5)*(M(23,:)%j-M(24,:)%j)+c(6)*(-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(575),h0tab(:,575),[32,2,1,12,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,467),heltab2x64(:,:,467))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(347),n2h32(246))
  Gcoeff(:)%j = (c(19)*(-M(23,:)%j+M(24,:)%j)+c(16)*(-M(35,:)%j+M(36,:)%j-M(37,:)%j-M(38,:)%j+M(39,:)%j+M(41,:)%j+M(45,:)%j &
    -M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(576),h0tab(:,576),[32,2,1,12,16],[0,nMT,0,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(348),m3h2x32(:,468),heltab2x64(:,:,468))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j+M(46,:)%j-M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(577),h0tab(:,577),[32,1,16,2,12],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,469),heltab2x64(:,:,469))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(349),n2h32(247))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(578),h0tab(:,578),[32,1,16,2,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(350),m3h2x32(:,470),heltab2x64(:,:,470))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(579),h0tab(:,579),[32,1,16,12,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(351),m3h2x32(:,471),heltab2x64(:,:,471))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(580),h0tab(:,580),[32,1,16,12,2],[nMT,0,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,472),heltab2x64(:,:,472))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(352),n2h32(248))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(581),h0tab(:,581),[32,2,16,1,12],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,473),heltab2x64(:,:,473))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(353),n2h32(249))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(37,:)%j-M(39,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(582),h0tab(:,582),[32,2,16,1,12],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(354),m3h2x32(:,474),heltab2x64(:,:,474))
  Gcoeff(:)%j = (c(16)*(M(35,:)%j-M(36,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(583),h0tab(:,583),[32,2,12,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,475),heltab2x64(:,:,475))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(355),n2h32(250))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(584),h0tab(:,584),[32,2,12,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(356),m3h2x32(:,476),heltab2x64(:,:,476))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(585),h0tab(:,585),[32,1,12,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(357),m3h2x32(:,477),heltab2x64(:,:,477))
  Gcoeff(:)%j = (c(6)*(M(35,:)%j-M(36,:)%j+M(38,:)%j-M(41,:)%j-M(45,:)%j+M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(586),h0tab(:,586),[32,1,12,16,2],[nMT,0,0,0,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,478),heltab2x64(:,:,478))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(358),n2h32(251))
  Gcoeff(:)%j = (c(16)*(-M(35,:)%j+M(36,:)%j+M(45,:)%j-M(48,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(587),h0tab(:,587),[32,1,12,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,2))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,479),heltab2x64(:,:,479))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(359),n2h32(252))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j+M(38,:)%j-M(39,:)%j-M(41,:)%j-M(46,:)%j+M(50,:)%j)) * den(2)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(588),h0tab(:,588),[32,1,12,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,2))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(360),m3h2x32(:,480),heltab2x64(:,:,480))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(589),h0tab(:,589),[32,4,2,8,17],[nMT,nMT,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,481),heltab2x64(:,:,481))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(361),n2h32(253))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(33,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(590),h0tab(:,590),[32,4,2,8,17],[0,0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(362),m3h2x32(:,482),heltab2x64(:,:,482))
  Gcoeff(:)%j = (c(6)*(-M(33,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(591),h0tab(:,591),[32,8,2,4,17],[nMT,nMT,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,483),heltab2x64(:,:,483))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(363),n2h32(254))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(29,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(592),h0tab(:,592),[32,8,2,4,17],[0,0,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(364),m3h2x32(:,484),heltab2x64(:,:,484))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(593),h0tab(:,593),[32,2,4,8,17],[0,nMT,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(365),m3h2x32(:,485),heltab2x64(:,:,485))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(594),h0tab(:,594),[32,2,4,8,17],[nMT,0,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,486),heltab2x64(:,:,486))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(366),n2h32(255))
  Gcoeff(:)%j = (c(6)*(-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(595),h0tab(:,595),[32,2,4,17,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,487),heltab2x64(:,:,487))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(367),n2h32(256))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(29,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(596),h0tab(:,596),[32,2,4,17,8],[0,nMT,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(368),m3h2x32(:,488),heltab2x64(:,:,488))
  Gcoeff(:)%j = (-(c(15)*M(2,:)%j)+c(16)*M(38,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(597),h0tab(:,597),[32,8,4,2,17],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,489),heltab2x64(:,:,489))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(369),n2h32(257))
  Gcoeff(:)%j = (c(9)*M(2,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(598),h0tab(:,598),[32,8,4,2,17],[0,0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(370),m3h2x32(:,490),heltab2x64(:,:,490))
  Gcoeff(:)%j = (-(c(15)*M(5,:)%j)+c(16)*M(41,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(599),h0tab(:,599),[32,4,2,17,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,491),heltab2x64(:,:,491))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(371),n2h32(258))
  Gcoeff(:)%j = (c(9)*M(5,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(600),h0tab(:,600),[32,4,2,17,8],[0,0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(372),m3h2x32(:,492),heltab2x64(:,:,492))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(601),h0tab(:,601),[32,2,8,4,17],[0,nMT,nMT,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(373),m3h2x32(:,493),heltab2x64(:,:,493))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j-M(33,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(602),h0tab(:,602),[32,2,8,4,17],[nMT,0,0,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,494),heltab2x64(:,:,494))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(374),n2h32(259))
  Gcoeff(:)%j = (c(6)*(-M(29,:)%j+M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(603),h0tab(:,603),[32,2,8,17,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,495),heltab2x64(:,:,495))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(375),n2h32(260))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(604),h0tab(:,604),[32,2,8,17,4],[0,nMT,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(376),m3h2x32(:,496),heltab2x64(:,:,496))
  Gcoeff(:)%j = (-(c(15)*M(8,:)%j)+c(16)*M(41,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(605),h0tab(:,605),[32,4,8,2,17],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,497),heltab2x64(:,:,497))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(377),n2h32(261))
  Gcoeff(:)%j = (c(9)*M(8,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(606),h0tab(:,606),[32,4,8,2,17],[0,0,0,nMT,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(378),m3h2x32(:,498),heltab2x64(:,:,498))
  Gcoeff(:)%j = (-(c(15)*M(11,:)%j)+c(16)*M(38,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(607),h0tab(:,607),[32,4,17,2,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,17))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,499),heltab2x64(:,:,499))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(379),n2h32(262))
  Gcoeff(:)%j = (-(c(9)*M(11,:)%j)+c(6)*(-M(26,:)%j-M(29,:)%j-M(33,:)%j+M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(608),h0tab(:,608),[32,4,17,2,8],[0,0,nMT,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(380),m3h2x32(:,500),heltab2x64(:,:,500))
  Gcoeff(:)%j = (-(c(15)*M(19,:)%j)+c(16)*M(38,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(609),h0tab(:,609),[32,2,17,8,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,501),heltab2x64(:,:,501))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(381),n2h32(263))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(41,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(610),h0tab(:,610),[32,2,17,8,4],[0,nMT,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(382),m3h2x32(:,502),heltab2x64(:,:,502))
  Gcoeff(:)%j = (-(c(15)*M(21,:)%j)+c(16)*M(41,:)%j) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(611),h0tab(:,611),[32,2,17,4,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,17))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,503),heltab2x64(:,:,503))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(383),n2h32(264))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(29,:)%j+M(33,:)%j-M(38,:)%j)) * den(30)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(612),h0tab(:,612),[32,2,17,4,8],[0,nMT,0,0,0],5,1,wf4(:,17))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(384),m3h2x32(:,504),heltab2x64(:,:,504))
  Gcoeff(:)%j = (c(6)*(M(30,:)%j-M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(613),h0tab(:,613),[32,4,1,8,18],[nMT,nMT,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,505),heltab2x64(:,:,505))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(385),n2h32(265))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(614),h0tab(:,614),[32,4,1,8,18],[0,0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(386),m3h2x32(:,506),heltab2x64(:,:,506))
  Gcoeff(:)%j = (c(6)*(M(34,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(615),h0tab(:,615),[32,8,1,4,18],[nMT,nMT,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,507),heltab2x64(:,:,507))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(387),n2h32(266))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(30,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(616),h0tab(:,616),[32,8,1,4,18],[0,0,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(388),m3h2x32(:,508),heltab2x64(:,:,508))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(617),h0tab(:,617),[32,1,4,8,18],[0,nMT,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(389),m3h2x32(:,509),heltab2x64(:,:,509))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(618),h0tab(:,618),[32,1,4,8,18],[nMT,0,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,510),heltab2x64(:,:,510))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(390),n2h32(267))
  Gcoeff(:)%j = (c(6)*(M(34,:)%j-M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(619),h0tab(:,619),[32,1,4,18,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,511),heltab2x64(:,:,511))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(391),n2h32(268))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(30,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(620),h0tab(:,620),[32,1,4,18,8],[0,nMT,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(392),m3h2x32(:,512),heltab2x64(:,:,512))
  Gcoeff(:)%j = (-(c(15)*M(18,:)%j)+c(16)*M(41,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(621),h0tab(:,621),[32,8,4,1,18],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,513),heltab2x64(:,:,513))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(393),n2h32(269))
  Gcoeff(:)%j = (-(c(9)*M(18,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(622),h0tab(:,622),[32,8,4,1,18],[0,0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(394),m3h2x32(:,514),heltab2x64(:,:,514))
  Gcoeff(:)%j = (-(c(15)*M(16,:)%j)+c(16)*M(38,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(623),h0tab(:,623),[32,4,1,18,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,515),heltab2x64(:,:,515))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(395),n2h32(270))
  Gcoeff(:)%j = (-(c(9)*M(16,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(624),h0tab(:,624),[32,4,1,18,8],[0,0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(396),m3h2x32(:,516),heltab2x64(:,:,516))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(625),h0tab(:,625),[32,1,8,4,18],[0,nMT,nMT,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(397),m3h2x32(:,517),heltab2x64(:,:,517))
  Gcoeff(:)%j = (c(16)*(-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(626),h0tab(:,626),[32,1,8,4,18],[nMT,0,0,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,518),heltab2x64(:,:,518))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(398),n2h32(271))
  Gcoeff(:)%j = (c(6)*(M(30,:)%j-M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(627),h0tab(:,627),[32,1,8,18,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,519),heltab2x64(:,:,519))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(399),n2h32(272))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(628),h0tab(:,628),[32,1,8,18,4],[0,nMT,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(400),m3h2x32(:,520),heltab2x64(:,:,520))
  Gcoeff(:)%j = (-(c(15)*M(17,:)%j)+c(16)*M(38,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(629),h0tab(:,629),[32,4,8,1,18],[nMT,nMT,nMT,0,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,521),heltab2x64(:,:,521))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(401),n2h32(273))
  Gcoeff(:)%j = (-(c(9)*M(17,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(630),h0tab(:,630),[32,4,8,1,18],[0,0,0,nMT,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(402),m3h2x32(:,522),heltab2x64(:,:,522))
  Gcoeff(:)%j = (-(c(15)*M(14,:)%j)+c(16)*M(41,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(631),h0tab(:,631),[32,4,18,1,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,19))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,523),heltab2x64(:,:,523))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(403),n2h32(274))
  Gcoeff(:)%j = (c(9)*M(14,:)%j+c(6)*(M(25,:)%j+M(30,:)%j+M(34,:)%j-M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(632),h0tab(:,632),[32,4,18,1,8],[0,0,nMT,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(404),m3h2x32(:,524),heltab2x64(:,:,524))
  Gcoeff(:)%j = (-(c(15)*M(15,:)%j)+c(16)*M(41,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(633),h0tab(:,633),[32,1,18,8,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,525),heltab2x64(:,:,525))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(405),n2h32(275))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(38,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(634),h0tab(:,634),[32,1,18,8,4],[0,nMT,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(406),m3h2x32(:,526),heltab2x64(:,:,526))
  Gcoeff(:)%j = (-(c(15)*M(13,:)%j)+c(16)*M(38,:)%j) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(635),h0tab(:,635),[32,1,18,4,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,19))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,527),heltab2x64(:,:,527))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(407),n2h32(276))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(30,:)%j-M(34,:)%j+M(41,:)%j)) * den(32)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(636),h0tab(:,636),[32,1,18,4,8],[0,nMT,0,0,0],5,1,wf4(:,19))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(408),m3h2x32(:,528),heltab2x64(:,:,528))
  Gcoeff(:)%j = (c(5)*(M(20,:)%j-M(23,:)%j)+c(6)*(M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(637),h0tab(:,637),[32,2,1,8,20],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,529),heltab2x64(:,:,529))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(409),n2h32(277))
  Gcoeff(:)%j = (c(19)*(-M(20,:)%j+M(23,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j+M(48,:)%j &
    -M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(638),h0tab(:,638),[32,2,1,8,20],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(410),m3h2x32(:,530),heltab2x64(:,:,530))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(14,:)%j)+c(6)*(-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(639),h0tab(:,639),[32,8,1,2,20],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,531),heltab2x64(:,:,531))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(411),n2h32(278))
  Gcoeff(:)%j = (c(19)*(M(4,:)%j-M(14,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j &
    -M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(640),h0tab(:,640),[32,8,1,2,20],[0,0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(412),m3h2x32(:,532),heltab2x64(:,:,532))
  Gcoeff(:)%j = (c(5)*(M(7,:)%j-M(9,:)%j)+c(6)*(-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(641),h0tab(:,641),[32,1,2,8,20],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,533),heltab2x64(:,:,533))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(413),n2h32(279))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(9,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j &
    -M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(642),h0tab(:,642),[32,1,2,8,20],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(414),m3h2x32(:,534),heltab2x64(:,:,534))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(13,:)%j)+c(6)*(M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(643),h0tab(:,643),[32,1,2,20,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,535),heltab2x64(:,:,535))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(415),n2h32(280))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(13,:)%j)+c(16)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j &
    +M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(644),h0tab(:,644),[32,1,2,20,8],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(416),m3h2x32(:,536),heltab2x64(:,:,536))
  Gcoeff(:)%j = (c(5)*(M(11,:)%j-M(12,:)%j)+c(6)*(M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(645),h0tab(:,645),[32,8,2,1,20],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,537),heltab2x64(:,:,537))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(417),n2h32(281))
  Gcoeff(:)%j = (c(19)*(-M(11,:)%j+M(12,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j+M(48,:)%j &
    -M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(646),h0tab(:,646),[32,8,2,1,20],[0,0,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(418),m3h2x32(:,538),heltab2x64(:,:,538))
  Gcoeff(:)%j = (c(5)*(M(21,:)%j-M(22,:)%j)+c(6)*(-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(647),h0tab(:,647),[32,2,1,20,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,539),heltab2x64(:,:,539))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(419),n2h32(282))
  Gcoeff(:)%j = (c(19)*(-M(21,:)%j+M(22,:)%j)+c(16)*(-M(33,:)%j+M(34,:)%j+M(37,:)%j-M(39,:)%j-M(40,:)%j+M(42,:)%j-M(46,:)%j &
    +M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(648),h0tab(:,648),[32,2,1,20,8],[0,nMT,0,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(420),m3h2x32(:,540),heltab2x64(:,:,540))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j+M(48,:)%j-M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(649),h0tab(:,649),[32,1,8,2,20],[nMT,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,541),heltab2x64(:,:,541))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(421),n2h32(283))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(650),h0tab(:,650),[32,1,8,2,20],[0,nMT,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(422),m3h2x32(:,542),heltab2x64(:,:,542))
  Gcoeff(:)%j = (c(16)*(-M(37,:)%j+M(39,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(651),h0tab(:,651),[32,1,8,20,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(423),m3h2x32(:,543),heltab2x64(:,:,543))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(652),h0tab(:,652),[32,1,8,20,2],[nMT,0,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,544),heltab2x64(:,:,544))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(424),n2h32(284))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(653),h0tab(:,653),[32,2,8,1,20],[nMT,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,545),heltab2x64(:,:,545))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(425),n2h32(285))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j-M(37,:)%j+M(39,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(654),h0tab(:,654),[32,2,8,1,20],[0,nMT,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(426),m3h2x32(:,546),heltab2x64(:,:,546))
  Gcoeff(:)%j = (c(16)*(M(33,:)%j-M(34,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(655),h0tab(:,655),[32,2,20,1,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,547),heltab2x64(:,:,547))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(427),n2h32(286))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(656),h0tab(:,656),[32,2,20,1,8],[0,nMT,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(428),m3h2x32(:,548),heltab2x64(:,:,548))
  Gcoeff(:)%j = (c(16)*(-M(37,:)%j+M(39,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(657),h0tab(:,657),[32,1,20,8,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(429),m3h2x32(:,549),heltab2x64(:,:,549))
  Gcoeff(:)%j = (c(6)*(M(33,:)%j-M(34,:)%j+M(40,:)%j-M(42,:)%j+M(46,:)%j-M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(658),h0tab(:,658),[32,1,20,8,2],[nMT,0,0,0,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,550),heltab2x64(:,:,550))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(430),n2h32(287))
  Gcoeff(:)%j = (c(16)*(-M(33,:)%j+M(34,:)%j-M(46,:)%j+M(47,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(659),h0tab(:,659),[32,1,20,2,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,3))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,551),heltab2x64(:,:,551))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(431),n2h32(288))
  Gcoeff(:)%j = (c(6)*(-M(37,:)%j+M(39,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(49,:)%j)) * den(4)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(660),h0tab(:,660),[32,1,20,2,8],[0,nMT,nMT,0,0],5,1,wf4(:,3))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(432),m3h2x32(:,552),heltab2x64(:,:,552))
  Gcoeff(:)%j = (c(5)*(M(22,:)%j-M(24,:)%j)+c(6)*(-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(661),h0tab(:,661),[32,2,1,4,24],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,553),heltab2x64(:,:,553))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(433),n2h32(289))
  Gcoeff(:)%j = (c(19)*(-M(22,:)%j+M(24,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(662),h0tab(:,662),[32,2,1,4,24],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(434),m3h2x32(:,554),heltab2x64(:,:,554))
  Gcoeff(:)%j = (c(5)*(M(10,:)%j-M(16,:)%j)+c(6)*(-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(663),h0tab(:,663),[32,4,1,2,24],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,555),heltab2x64(:,:,555))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(435),n2h32(290))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(16,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j &
    +M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(664),h0tab(:,664),[32,4,1,2,24],[0,0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(436),m3h2x32(:,556),heltab2x64(:,:,556))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(3,:)%j)+c(6)*(-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(665),h0tab(:,665),[32,1,2,4,24],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,557),heltab2x64(:,:,557))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(437),n2h32(291))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(3,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j &
    +M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(666),h0tab(:,666),[32,1,2,4,24],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(438),m3h2x32(:,558),heltab2x64(:,:,558))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(15,:)%j)+c(6)*(-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(667),h0tab(:,667),[32,1,2,24,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,559),heltab2x64(:,:,559))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(439),n2h32(292))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(15,:)%j)+c(16)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(668),h0tab(:,668),[32,1,2,24,4],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(440),m3h2x32(:,560),heltab2x64(:,:,560))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(6,:)%j)+c(6)*(-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(669),h0tab(:,669),[32,4,2,1,24],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,561),heltab2x64(:,:,561))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(441),n2h32(293))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(6,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(670),h0tab(:,670),[32,4,2,1,24],[0,0,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(442),m3h2x32(:,562),heltab2x64(:,:,562))
  Gcoeff(:)%j = (c(5)*(M(19,:)%j-M(20,:)%j)+c(6)*(-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(671),h0tab(:,671),[32,2,1,24,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,563),heltab2x64(:,:,563))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(443),n2h32(294))
  Gcoeff(:)%j = (c(19)*(-M(19,:)%j+M(20,:)%j)+c(16)*(-M(29,:)%j+M(30,:)%j-M(37,:)%j+M(39,:)%j-M(43,:)%j+M(44,:)%j+M(49,:)%j &
    -M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(672),h0tab(:,672),[32,2,1,24,4],[0,nMT,0,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(444),m3h2x32(:,564),heltab2x64(:,:,564))
  Gcoeff(:)%j = (c(16)*(-M(43,:)%j+M(44,:)%j+M(45,:)%j-M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(673),h0tab(:,673),[32,1,4,2,24],[nMT,0,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,565),heltab2x64(:,:,565))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(445),n2h32(295))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(674),h0tab(:,674),[32,1,4,2,24],[0,nMT,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(446),m3h2x32(:,566),heltab2x64(:,:,566))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(675),h0tab(:,675),[32,1,4,24,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(447),m3h2x32(:,567),heltab2x64(:,:,567))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(676),h0tab(:,676),[32,1,4,24,2],[nMT,0,0,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,568),heltab2x64(:,:,568))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(448),n2h32(296))
  Gcoeff(:)%j = (c(16)*(M(43,:)%j-M(44,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(677),h0tab(:,677),[32,2,4,1,24],[nMT,0,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,569),heltab2x64(:,:,569))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(449),n2h32(297))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(37,:)%j-M(39,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(678),h0tab(:,678),[32,2,4,1,24],[0,nMT,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(450),m3h2x32(:,570),heltab2x64(:,:,570))
  Gcoeff(:)%j = (c(16)*(M(29,:)%j-M(30,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(679),h0tab(:,679),[32,2,24,1,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_QV_A(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,571),heltab2x64(:,:,571))
  call Hloop_Q_A(ntryL,G0H32(1),32,nMT,G1H32(451),n2h32(298))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(680),h0tab(:,680),[32,2,24,1,4],[0,nMT,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(452),m3h2x32(:,572),heltab2x64(:,:,572))
  Gcoeff(:)%j = (c(16)*(M(37,:)%j-M(39,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(681),h0tab(:,681),[32,1,24,4,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(453),m3h2x32(:,573),heltab2x64(:,:,573))
  Gcoeff(:)%j = (c(6)*(M(29,:)%j-M(30,:)%j+M(43,:)%j-M(44,:)%j-M(49,:)%j+M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(682),h0tab(:,682),[32,1,24,4,2],[nMT,0,0,0,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,574),heltab2x64(:,:,574))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(454),n2h32(299))
  Gcoeff(:)%j = (c(16)*(-M(29,:)%j+M(30,:)%j+M(49,:)%j-M(50,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(683),h0tab(:,683),[32,1,24,2,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,5))
  call Hloop_AV_Q(ntryL,G0H64(1),ex6(:),G0H32(1),m3h2x32(:,575),heltab2x64(:,:,575))
  call Hloop_A_Q(ntryL,G0H32(1),32,nMT,G1H32(455),n2h32(300))
  Gcoeff(:)%j = (c(6)*(M(37,:)%j-M(39,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(47,:)%j)) * den(10)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(684),h0tab(:,684),[32,1,24,2,4],[0,nMT,nMT,0,0],5,1,wf4(:,5))
  call Hloop_UV_W(ntryL,G0H64(1),0,ex6(:),32,G1H32(456),m3h2x32(:,576),heltab2x64(:,:,576))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(685),h0tab(:,685),[33,8,2,4,16],[0,0,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(109),m3h4x16(:,1),heltab2x64(:,:,577))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(686),h0tab(:,686),[33,8,2,4,16],[nMT,nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(110),m3h4x16(:,2),heltab2x64(:,:,578))
  call Hloop_Q_A(ntryL,G0H16(110),33,nMT,G1H16(42),n2h16(115))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(687),h0tab(:,687),[33,4,2,8,16],[0,0,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(110),m3h4x16(:,3),heltab2x64(:,:,579))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(27,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(688),h0tab(:,688),[33,4,2,8,16],[nMT,nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(111),m3h4x16(:,4),heltab2x64(:,:,580))
  call Hloop_Q_A(ntryL,G0H16(111),33,nMT,G1H16(43),n2h16(116))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(689),h0tab(:,689),[33,8,4,2,16],[nMT,nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(111),m3h4x16(:,5),heltab2x64(:,:,581))
  call Hloop_Q_A(ntryL,G0H16(111),33,nMT,G1H16(44),n2h16(117))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(690),h0tab(:,690),[33,8,4,2,16],[0,0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(111),m3h4x16(:,6),heltab2x64(:,:,582))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(691),h0tab(:,691),[33,4,2,16,8],[0,0,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(112),m3h4x16(:,7),heltab2x64(:,:,583))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(27,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(692),h0tab(:,692),[33,4,2,16,8],[nMT,nMT,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(113),m3h4x16(:,8),heltab2x64(:,:,584))
  call Hloop_Q_A(ntryL,G0H16(113),33,nMT,G1H16(46),n2h16(118))
  Gcoeff(:)%j = (-(c(15)*M(1,:)%j)+c(16)*M(37,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(693),h0tab(:,693),[33,2,4,8,16],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(113),m3h4x16(:,9),heltab2x64(:,:,585))
  Gcoeff(:)%j = (-(c(9)*M(1,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(694),h0tab(:,694),[33,2,4,8,16],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(114),m3h4x16(:,10),heltab2x64(:,:,586))
  call Hloop_Q_A(ntryL,G0H16(114),33,nMT,G1H16(47),n2h16(119))
  Gcoeff(:)%j = (-(c(15)*M(3,:)%j)+c(16)*M(39,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(695),h0tab(:,695),[33,2,4,16,8],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(114),m3h4x16(:,11),heltab2x64(:,:,587))
  Gcoeff(:)%j = (-(c(9)*M(3,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(696),h0tab(:,696),[33,2,4,16,8],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(115),m3h4x16(:,12),heltab2x64(:,:,588))
  call Hloop_Q_A(ntryL,G0H16(115),33,nMT,G1H16(48),n2h16(120))
  Gcoeff(:)%j = (c(6)*(-M(25,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(697),h0tab(:,697),[33,4,8,2,16],[nMT,nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(115),m3h4x16(:,13),heltab2x64(:,:,589))
  call Hloop_Q_A(ntryL,G0H16(115),33,nMT,G1H16(49),n2h16(121))
  Gcoeff(:)%j = (c(16)*(-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(698),h0tab(:,698),[33,4,8,2,16],[0,0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(115),m3h4x16(:,14),heltab2x64(:,:,590))
  Gcoeff(:)%j = (c(6)*(-M(27,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(699),h0tab(:,699),[33,4,16,2,8],[nMT,nMT,nMT,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(116),m3h4x16(:,15),heltab2x64(:,:,591))
  call Hloop_Q_A(ntryL,G0H16(116),33,nMT,G1H16(50),n2h16(122))
  Gcoeff(:)%j = (c(16)*(-M(25,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(700),h0tab(:,700),[33,4,16,2,8],[0,0,0,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(116),m3h4x16(:,16),heltab2x64(:,:,592))
  Gcoeff(:)%j = (-(c(15)*M(7,:)%j)+c(16)*M(39,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(701),h0tab(:,701),[33,2,8,4,16],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(117),m3h4x16(:,17),heltab2x64(:,:,593))
  Gcoeff(:)%j = (-(c(9)*M(7,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(702),h0tab(:,702),[33,2,8,4,16],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(118),m3h4x16(:,18),heltab2x64(:,:,594))
  call Hloop_Q_A(ntryL,G0H16(118),33,nMT,G1H16(52),n2h16(123))
  Gcoeff(:)%j = (-(c(15)*M(9,:)%j)+c(16)*M(37,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(703),h0tab(:,703),[33,2,8,16,4],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(118),m3h4x16(:,19),heltab2x64(:,:,595))
  Gcoeff(:)%j = (-(c(9)*M(9,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(704),h0tab(:,704),[33,2,8,16,4],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(119),m3h4x16(:,20),heltab2x64(:,:,596))
  call Hloop_Q_A(ntryL,G0H16(119),33,nMT,G1H16(53),n2h16(124))
  Gcoeff(:)%j = (-(c(15)*M(13,:)%j)+c(16)*M(37,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(705),h0tab(:,705),[33,2,16,4,8],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(119),m3h4x16(:,21),heltab2x64(:,:,597))
  Gcoeff(:)%j = (-(c(9)*M(13,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(39,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(706),h0tab(:,706),[33,2,16,4,8],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(120),m3h4x16(:,22),heltab2x64(:,:,598))
  call Hloop_Q_A(ntryL,G0H16(120),33,nMT,G1H16(54),n2h16(125))
  Gcoeff(:)%j = (-(c(15)*M(15,:)%j)+c(16)*M(39,:)%j) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(707),h0tab(:,707),[33,2,16,8,4],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,21))
  call Hloop_AQ_V(ntryL,G0H64(1),wf4(:,21),G0H16(120),m3h4x16(:,23),heltab2x64(:,:,599))
  Gcoeff(:)%j = (-(c(9)*M(15,:)%j)+c(6)*(-M(25,:)%j-M(27,:)%j-M(31,:)%j+M(37,:)%j)) * den(34)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(708),h0tab(:,708),[33,2,16,8,4],[nMT,0,0,0,0],5,1,wf4(:,21))
  call Hloop_VQ_A(ntryL,G0H64(1),wf4(:,21),G0H16(121),m3h4x16(:,24),heltab2x64(:,:,600))
  call Hloop_Q_A(ntryL,G0H16(121),33,nMT,G1H16(55),n2h16(126))
  Gcoeff(:)%j = (c(6)*(-M(28,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(709),h0tab(:,709),[34,8,1,4,16],[0,0,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(121),m3h4x16(:,25),heltab2x64(:,:,601))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(32,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(710),h0tab(:,710),[34,8,1,4,16],[nMT,nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(122),m3h4x16(:,26),heltab2x64(:,:,602))
  call Hloop_A_Q(ntryL,G0H16(122),34,nMT,G1H16(56),n2h16(127))
  Gcoeff(:)%j = (c(6)*(-M(32,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(711),h0tab(:,711),[34,4,1,8,16],[0,0,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(122),m3h4x16(:,27),heltab2x64(:,:,603))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(28,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(712),h0tab(:,712),[34,4,1,8,16],[nMT,nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(123),m3h4x16(:,28),heltab2x64(:,:,604))
  call Hloop_A_Q(ntryL,G0H16(123),34,nMT,G1H16(58),n2h16(128))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(713),h0tab(:,713),[34,8,4,1,16],[nMT,nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(123),m3h4x16(:,29),heltab2x64(:,:,605))
  call Hloop_A_Q(ntryL,G0H16(123),34,nMT,G1H16(59),n2h16(129))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(32,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(714),h0tab(:,714),[34,8,4,1,16],[0,0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(123),m3h4x16(:,30),heltab2x64(:,:,606))
  Gcoeff(:)%j = (c(6)*(-M(32,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(715),h0tab(:,715),[34,4,1,16,8],[0,0,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(124),m3h4x16(:,31),heltab2x64(:,:,607))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(28,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(716),h0tab(:,716),[34,4,1,16,8],[nMT,nMT,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(125),m3h4x16(:,32),heltab2x64(:,:,608))
  call Hloop_A_Q(ntryL,G0H16(125),34,nMT,G1H16(60),n2h16(130))
  Gcoeff(:)%j = (-(c(15)*M(24,:)%j)+c(16)*M(39,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(717),h0tab(:,717),[34,1,4,8,16],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(125),m3h4x16(:,33),heltab2x64(:,:,609))
  Gcoeff(:)%j = (c(9)*M(24,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(718),h0tab(:,718),[34,1,4,8,16],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(126),m3h4x16(:,34),heltab2x64(:,:,610))
  call Hloop_A_Q(ntryL,G0H16(126),34,nMT,G1H16(61),n2h16(131))
  Gcoeff(:)%j = (-(c(15)*M(22,:)%j)+c(16)*M(37,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(719),h0tab(:,719),[34,1,4,16,8],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(126),m3h4x16(:,35),heltab2x64(:,:,611))
  Gcoeff(:)%j = (c(9)*M(22,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(720),h0tab(:,720),[34,1,4,16,8],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(127),m3h4x16(:,36),heltab2x64(:,:,612))
  call Hloop_A_Q(ntryL,G0H16(127),34,nMT,G1H16(62),n2h16(132))
  Gcoeff(:)%j = (c(6)*(M(26,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(721),h0tab(:,721),[34,4,8,1,16],[nMT,nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(127),m3h4x16(:,37),heltab2x64(:,:,613))
  call Hloop_A_Q(ntryL,G0H16(127),34,nMT,G1H16(64),n2h16(133))
  Gcoeff(:)%j = (c(16)*(-M(28,:)%j-M(32,:)%j+M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(722),h0tab(:,722),[34,4,8,1,16],[0,0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(127),m3h4x16(:,38),heltab2x64(:,:,614))
  Gcoeff(:)%j = (c(6)*(M(28,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(723),h0tab(:,723),[34,4,16,1,8],[nMT,nMT,nMT,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(128),m3h4x16(:,39),heltab2x64(:,:,615))
  call Hloop_A_Q(ntryL,G0H16(128),34,nMT,G1H16(65),n2h16(134))
  Gcoeff(:)%j = (c(16)*(-M(26,:)%j-M(32,:)%j+M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(724),h0tab(:,724),[34,4,16,1,8],[0,0,0,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(128),m3h4x16(:,40),heltab2x64(:,:,616))
  Gcoeff(:)%j = (-(c(15)*M(23,:)%j)+c(16)*M(37,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(725),h0tab(:,725),[34,1,8,4,16],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(129),m3h4x16(:,41),heltab2x64(:,:,617))
  Gcoeff(:)%j = (c(9)*M(23,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(726),h0tab(:,726),[34,1,8,4,16],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(130),m3h4x16(:,42),heltab2x64(:,:,618))
  call Hloop_A_Q(ntryL,G0H16(130),34,nMT,G1H16(66),n2h16(135))
  Gcoeff(:)%j = (-(c(15)*M(20,:)%j)+c(16)*M(39,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(727),h0tab(:,727),[34,1,8,16,4],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(130),m3h4x16(:,43),heltab2x64(:,:,619))
  Gcoeff(:)%j = (c(9)*M(20,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(728),h0tab(:,728),[34,1,8,16,4],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(131),m3h4x16(:,44),heltab2x64(:,:,620))
  call Hloop_A_Q(ntryL,G0H16(131),34,nMT,G1H16(67),n2h16(136))
  Gcoeff(:)%j = (-(c(15)*M(21,:)%j)+c(16)*M(39,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(729),h0tab(:,729),[34,1,16,4,8],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(131),m3h4x16(:,45),heltab2x64(:,:,621))
  Gcoeff(:)%j = (c(9)*M(21,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(37,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(730),h0tab(:,730),[34,1,16,4,8],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(132),m3h4x16(:,46),heltab2x64(:,:,622))
  call Hloop_A_Q(ntryL,G0H16(132),34,nMT,G1H16(68),n2h16(137))
  Gcoeff(:)%j = (-(c(15)*M(19,:)%j)+c(16)*M(37,:)%j) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(731),h0tab(:,731),[34,1,16,8,4],[0,nMT,nMT,nMT,nMT],5,1,wf4(:,23))
  call Hloop_QA_V(ntryL,G0H64(1),wf4(:,23),G0H16(132),m3h4x16(:,47),heltab2x64(:,:,623))
  Gcoeff(:)%j = (c(9)*M(19,:)%j+c(6)*(M(26,:)%j+M(28,:)%j+M(32,:)%j-M(39,:)%j)) * den(36)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(732),h0tab(:,732),[34,1,16,8,4],[nMT,0,0,0,0],5,1,wf4(:,23))
  call Hloop_VA_Q(ntryL,G0H64(1),wf4(:,23),G0H16(133),m3h4x16(:,48),heltab2x64(:,:,624))
  call Hloop_A_Q(ntryL,G0H16(133),34,nMT,G1H16(70),n2h16(138))
  Gcoeff(:)%j = (c(5)*(M(14,:)%j-M(17,:)%j)+c(6)*(M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(733),h0tab(:,733),[36,8,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,49),heltab2x64(:,:,625))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(71),n2h16(139))
  Gcoeff(:)%j = (c(19)*(M(14,:)%j-M(17,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j &
    -M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(734),h0tab(:,734),[36,8,1,2,16],[0,0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(72),m3h4x16(:,50),heltab2x64(:,:,626))
  Gcoeff(:)%j = (c(5)*(M(6,:)%j-M(20,:)%j)+c(6)*(M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(735),h0tab(:,735),[36,2,1,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,51),heltab2x64(:,:,627))
  call Hloop_Q_A(ntryL,G0H16(133),36,nMT,G1H16(1),n2h16(140))
  Gcoeff(:)%j = (c(19)*(-M(6,:)%j+M(20,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(45,:)%j &
    +M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(736),h0tab(:,736),[36,2,1,8,16],[0,nMT,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(2),m3h4x16(:,52),heltab2x64(:,:,628))
  Gcoeff(:)%j = (c(5)*(M(8,:)%j-M(11,:)%j)+c(6)*(M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(737),h0tab(:,737),[36,8,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,53),heltab2x64(:,:,629))
  call Hloop_Q_A(ntryL,G0H16(133),36,nMT,G1H16(74),n2h16(141))
  Gcoeff(:)%j = (c(19)*(-M(8,:)%j+M(11,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(45,:)%j &
    +M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(738),h0tab(:,738),[36,8,2,1,16],[0,0,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(75),m3h4x16(:,54),heltab2x64(:,:,630))
  Gcoeff(:)%j = (c(5)*(M(5,:)%j-M(19,:)%j)+c(6)*(M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(739),h0tab(:,739),[36,2,1,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,55),heltab2x64(:,:,631))
  call Hloop_Q_A(ntryL,G0H16(133),36,nMT,G1H16(76),n2h16(142))
  Gcoeff(:)%j = (c(19)*(-M(5,:)%j+M(19,:)%j)+c(16)*(-M(31,:)%j+M(32,:)%j+M(38,:)%j+M(40,:)%j-M(41,:)%j-M(42,:)%j-M(47,:)%j &
    +M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(740),h0tab(:,740),[36,2,1,16,8],[0,nMT,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(77),m3h4x16(:,56),heltab2x64(:,:,632))
  Gcoeff(:)%j = (c(5)*(M(9,:)%j-M(10,:)%j)+c(6)*(M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(741),h0tab(:,741),[36,1,2,8,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,57),heltab2x64(:,:,633))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(78),n2h16(143))
  Gcoeff(:)%j = (c(19)*(M(9,:)%j-M(10,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j &
    -M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(742),h0tab(:,742),[36,1,2,8,16],[0,nMT,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(80),m3h4x16(:,58),heltab2x64(:,:,634))
  Gcoeff(:)%j = (c(5)*(M(15,:)%j-M(16,:)%j)+c(6)*(M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(743),h0tab(:,743),[36,1,2,16,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,59),heltab2x64(:,:,635))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(81),n2h16(144))
  Gcoeff(:)%j = (c(19)*(M(15,:)%j-M(16,:)%j)+c(16)*(M(31,:)%j-M(32,:)%j-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j &
    -M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(744),h0tab(:,744),[36,1,2,16,8],[0,nMT,0,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(82),m3h4x16(:,60),heltab2x64(:,:,636))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(745),h0tab(:,745),[36,2,8,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,61),heltab2x64(:,:,637))
  call Hloop_Q_A(ntryL,G0H16(133),36,nMT,G1H16(83),n2h16(145))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(38,:)%j+M(41,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(746),h0tab(:,746),[36,2,8,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(84),m3h4x16(:,62),heltab2x64(:,:,638))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(747),h0tab(:,747),[36,2,16,1,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,63),heltab2x64(:,:,639))
  call Hloop_Q_A(ntryL,G0H16(133),36,nMT,G1H16(86),n2h16(146))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(40,:)%j+M(42,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(748),h0tab(:,748),[36,2,16,1,8],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(87),m3h4x16(:,64),heltab2x64(:,:,640))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j-M(45,:)%j+M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(749),h0tab(:,749),[36,1,8,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,65),heltab2x64(:,:,641))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(88),n2h16(147))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(38,:)%j+M(41,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(750),h0tab(:,750),[36,1,8,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(89),m3h4x16(:,66),heltab2x64(:,:,642))
  Gcoeff(:)%j = (c(16)*(M(31,:)%j-M(32,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(751),h0tab(:,751),[36,1,8,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(90),m3h4x16(:,67),heltab2x64(:,:,643))
  Gcoeff(:)%j = (c(6)*(-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(752),h0tab(:,752),[36,1,8,16,2],[nMT,0,0,0,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,68),heltab2x64(:,:,644))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(92),n2h16(148))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j-M(47,:)%j+M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(753),h0tab(:,753),[36,1,16,2,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,69),heltab2x64(:,:,645))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(93),n2h16(149))
  Gcoeff(:)%j = (c(6)*(M(31,:)%j-M(32,:)%j-M(40,:)%j+M(42,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(754),h0tab(:,754),[36,1,16,2,8],[0,nMT,nMT,0,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(94),m3h4x16(:,70),heltab2x64(:,:,646))
  Gcoeff(:)%j = (c(16)*(M(31,:)%j-M(32,:)%j+M(45,:)%j-M(49,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(755),h0tab(:,755),[36,1,16,8,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,4))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,4),36,G1H16(95),m3h4x16(:,71),heltab2x64(:,:,647))
  Gcoeff(:)%j = (c(6)*(-M(38,:)%j-M(40,:)%j+M(41,:)%j+M(42,:)%j+M(47,:)%j-M(50,:)%j)) * den(6)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(756),h0tab(:,756),[36,1,16,8,2],[nMT,0,0,0,nMT],5,1,wf4(:,4))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,4),G0H16(133),m3h4x16(:,72),heltab2x64(:,:,648))
  call Hloop_A_Q(ntryL,G0H16(133),36,nMT,G1H16(96),n2h16(150))
  Gcoeff(:)%j = (c(5)*(M(16,:)%j-M(18,:)%j)+c(6)*(-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(757),h0tab(:,757),[40,4,1,2,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,73),heltab2x64(:,:,649))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(98),n2h16(151))
  Gcoeff(:)%j = (c(19)*(M(16,:)%j-M(18,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j &
    +M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(758),h0tab(:,758),[40,4,1,2,16],[0,0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(99),m3h4x16(:,74),heltab2x64(:,:,650))
  Gcoeff(:)%j = (c(5)*(M(12,:)%j-M(22,:)%j)+c(6)*(-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(759),h0tab(:,759),[40,2,1,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,75),heltab2x64(:,:,651))
  call Hloop_Q_A(ntryL,G0H16(133),40,nMT,G1H16(100),n2h16(152))
  Gcoeff(:)%j = (c(19)*(-M(12,:)%j+M(22,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(47,:)%j &
    -M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(760),h0tab(:,760),[40,2,1,4,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(101),m3h4x16(:,76),heltab2x64(:,:,652))
  Gcoeff(:)%j = (c(5)*(M(2,:)%j-M(5,:)%j)+c(6)*(-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(761),h0tab(:,761),[40,4,2,1,16],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,77),heltab2x64(:,:,653))
  call Hloop_Q_A(ntryL,G0H16(133),40,nMT,G1H16(102),n2h16(153))
  Gcoeff(:)%j = (c(19)*(-M(2,:)%j+M(5,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(47,:)%j &
    -M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(762),h0tab(:,762),[40,4,2,1,16],[0,0,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(104),m3h4x16(:,78),heltab2x64(:,:,654))
  Gcoeff(:)%j = (c(5)*(M(11,:)%j-M(21,:)%j)+c(6)*(-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(763),h0tab(:,763),[40,2,1,16,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,79),heltab2x64(:,:,655))
  call Hloop_Q_A(ntryL,G0H16(133),40,nMT,G1H16(105),n2h16(154))
  Gcoeff(:)%j = (c(19)*(-M(11,:)%j+M(21,:)%j)+c(16)*(-M(27,:)%j+M(28,:)%j-M(38,:)%j+M(41,:)%j+M(43,:)%j-M(44,:)%j+M(46,:)%j &
    -M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(764),h0tab(:,764),[40,2,1,16,4],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(106),m3h4x16(:,80),heltab2x64(:,:,656))
  Gcoeff(:)%j = (c(5)*(M(3,:)%j-M(4,:)%j)+c(6)*(-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(765),h0tab(:,765),[40,1,2,4,16],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,81),heltab2x64(:,:,657))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(3),n2h16(155))
  Gcoeff(:)%j = (c(19)*(M(3,:)%j-M(4,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j &
    +M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(766),h0tab(:,766),[40,1,2,4,16],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(4),m3h4x16(:,82),heltab2x64(:,:,658))
  Gcoeff(:)%j = (c(5)*(M(13,:)%j-M(14,:)%j)+c(6)*(-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(767),h0tab(:,767),[40,1,2,16,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,83),heltab2x64(:,:,659))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(108),n2h16(156))
  Gcoeff(:)%j = (c(19)*(M(13,:)%j-M(14,:)%j)+c(16)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j &
    +M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(768),h0tab(:,768),[40,1,2,16,4],[0,nMT,0,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(109),m3h4x16(:,84),heltab2x64(:,:,660))
  Gcoeff(:)%j = (c(16)*(-M(43,:)%j+M(44,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(769),h0tab(:,769),[40,2,4,1,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,85),heltab2x64(:,:,661))
  call Hloop_Q_A(ntryL,G0H16(133),40,nMT,G1H16(110),n2h16(157))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(770),h0tab(:,770),[40,2,4,1,16],[0,nMT,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(111),m3h4x16(:,86),heltab2x64(:,:,662))
  Gcoeff(:)%j = (c(16)*(M(38,:)%j-M(41,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(771),h0tab(:,771),[40,2,16,1,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,87),heltab2x64(:,:,663))
  call Hloop_Q_A(ntryL,G0H16(133),40,nMT,G1H16(112),n2h16(158))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(772),h0tab(:,772),[40,2,16,1,4],[0,nMT,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(114),m3h4x16(:,88),heltab2x64(:,:,664))
  Gcoeff(:)%j = (c(16)*(M(43,:)%j-M(44,:)%j+M(47,:)%j-M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(773),h0tab(:,773),[40,1,4,2,16],[nMT,0,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,89),heltab2x64(:,:,665))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(115),n2h16(159))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j+M(38,:)%j-M(41,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(774),h0tab(:,774),[40,1,4,2,16],[0,nMT,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(116),m3h4x16(:,90),heltab2x64(:,:,666))
  Gcoeff(:)%j = (c(16)*(M(27,:)%j-M(28,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(775),h0tab(:,775),[40,1,4,16,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(117),m3h4x16(:,91),heltab2x64(:,:,667))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(776),h0tab(:,776),[40,1,4,16,2],[nMT,0,0,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,92),heltab2x64(:,:,668))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(118),n2h16(160))
  Gcoeff(:)%j = (c(16)*(-M(38,:)%j+M(41,:)%j+M(46,:)%j-M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(777),h0tab(:,777),[40,1,16,2,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,93),heltab2x64(:,:,669))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(120),n2h16(161))
  Gcoeff(:)%j = (c(6)*(M(27,:)%j-M(28,:)%j-M(43,:)%j+M(44,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(778),h0tab(:,778),[40,1,16,2,4],[0,nMT,nMT,0,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(121),m3h4x16(:,94),heltab2x64(:,:,670))
  Gcoeff(:)%j = (c(16)*(M(27,:)%j-M(28,:)%j-M(47,:)%j+M(48,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(779),h0tab(:,779),[40,1,16,4,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,6))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,6),40,G1H16(122),m3h4x16(:,95),heltab2x64(:,:,671))
  Gcoeff(:)%j = (c(6)*(M(38,:)%j-M(41,:)%j-M(43,:)%j+M(44,:)%j-M(46,:)%j+M(49,:)%j)) * den(12)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(780),h0tab(:,780),[40,1,16,4,2],[nMT,0,0,0,nMT],5,1,wf4(:,6))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,6),G0H16(133),m3h4x16(:,96),heltab2x64(:,:,672))
  call Hloop_A_Q(ntryL,G0H16(133),40,nMT,G1H16(123),n2h16(162))
  Gcoeff(:)%j = (c(5)*(M(10,:)%j-M(12,:)%j)+c(6)*(-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(781),h0tab(:,781),[48,4,1,2,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,97),heltab2x64(:,:,673))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(124),n2h16(163))
  Gcoeff(:)%j = (c(19)*(M(10,:)%j-M(12,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j &
    +M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(782),h0tab(:,782),[48,4,1,2,8],[0,0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(126),m3h4x16(:,98),heltab2x64(:,:,674))
  Gcoeff(:)%j = (c(5)*(M(18,:)%j-M(24,:)%j)+c(6)*(-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(783),h0tab(:,783),[48,2,1,4,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,99),heltab2x64(:,:,675))
  call Hloop_Q_A(ntryL,G0H16(133),48,nMT,G1H16(127),n2h16(164))
  Gcoeff(:)%j = (c(19)*(-M(18,:)%j+M(24,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(784),h0tab(:,784),[48,2,1,4,8],[0,nMT,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(128),m3h4x16(:,100),heltab2x64(:,:,676))
  Gcoeff(:)%j = (c(5)*(M(4,:)%j-M(6,:)%j)+c(6)*(-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(785),h0tab(:,785),[48,4,2,1,8],[nMT,nMT,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,101),heltab2x64(:,:,677))
  call Hloop_Q_A(ntryL,G0H16(133),48,nMT,G1H16(129),n2h16(165))
  Gcoeff(:)%j = (c(19)*(-M(4,:)%j+M(6,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(45,:)%j &
    -M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(786),h0tab(:,786),[48,4,2,1,8],[0,0,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(130),m3h4x16(:,102),heltab2x64(:,:,678))
  Gcoeff(:)%j = (c(5)*(M(17,:)%j-M(23,:)%j)+c(6)*(-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(787),h0tab(:,787),[48,2,1,8,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,103),heltab2x64(:,:,679))
  call Hloop_Q_A(ntryL,G0H16(133),48,nMT,G1H16(132),n2h16(166))
  Gcoeff(:)%j = (c(19)*(-M(17,:)%j+M(23,:)%j)+c(16)*(-M(25,:)%j+M(26,:)%j-M(40,:)%j+M(42,:)%j-M(43,:)%j+M(44,:)%j+M(48,:)%j &
    -M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(788),h0tab(:,788),[48,2,1,8,4],[0,nMT,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(133),m3h4x16(:,104),heltab2x64(:,:,680))
  Gcoeff(:)%j = (c(5)*(M(1,:)%j-M(2,:)%j)+c(6)*(-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(789),h0tab(:,789),[48,1,2,4,8],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,105),heltab2x64(:,:,681))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(134),n2h16(167))
  Gcoeff(:)%j = (c(19)*(M(1,:)%j-M(2,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j &
    +M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(790),h0tab(:,790),[48,1,2,4,8],[0,nMT,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(135),m3h4x16(:,106),heltab2x64(:,:,682))
  Gcoeff(:)%j = (c(5)*(M(7,:)%j-M(8,:)%j)+c(6)*(-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(791),h0tab(:,791),[48,1,2,8,4],[nMT,0,nMT,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,107),heltab2x64(:,:,683))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(136),n2h16(168))
  Gcoeff(:)%j = (c(19)*(M(7,:)%j-M(8,:)%j)+c(16)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j &
    +M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(792),h0tab(:,792),[48,1,2,8,4],[0,nMT,0,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(138),m3h4x16(:,108),heltab2x64(:,:,684))
  Gcoeff(:)%j = (c(16)*(M(43,:)%j-M(44,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(793),h0tab(:,793),[48,2,4,1,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,109),heltab2x64(:,:,685))
  call Hloop_Q_A(ntryL,G0H16(133),48,nMT,G1H16(139),n2h16(169))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(794),h0tab(:,794),[48,2,4,1,8],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(140),m3h4x16(:,110),heltab2x64(:,:,686))
  Gcoeff(:)%j = (c(16)*(M(40,:)%j-M(42,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(795),h0tab(:,795),[48,2,8,1,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_QV_A(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,111),heltab2x64(:,:,687))
  call Hloop_Q_A(ntryL,G0H16(133),48,nMT,G1H16(141),n2h16(170))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(796),h0tab(:,796),[48,2,8,1,4],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(142),m3h4x16(:,112),heltab2x64(:,:,688))
  Gcoeff(:)%j = (c(16)*(-M(43,:)%j+M(44,:)%j+M(45,:)%j-M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(797),h0tab(:,797),[48,1,4,2,8],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,113),heltab2x64(:,:,689))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(144),n2h16(171))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(40,:)%j-M(42,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(798),h0tab(:,798),[48,1,4,2,8],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(145),m3h4x16(:,114),heltab2x64(:,:,690))
  Gcoeff(:)%j = (c(16)*(M(25,:)%j-M(26,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(799),h0tab(:,799),[48,1,4,8,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(146),m3h4x16(:,115),heltab2x64(:,:,691))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(800),h0tab(:,800),[48,1,4,8,2],[nMT,0,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,116),heltab2x64(:,:,692))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(5),n2h16(172))
  Gcoeff(:)%j = (c(16)*(-M(40,:)%j+M(42,:)%j+M(48,:)%j-M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(801),h0tab(:,801),[48,1,8,2,4],[nMT,0,0,nMT,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,117),heltab2x64(:,:,693))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(6),n2h16(173))
  Gcoeff(:)%j = (c(6)*(M(25,:)%j-M(26,:)%j+M(43,:)%j-M(44,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(802),h0tab(:,802),[48,1,8,2,4],[0,nMT,nMT,0,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(8),m3h4x16(:,118),heltab2x64(:,:,694))
  Gcoeff(:)%j = (c(16)*(M(25,:)%j-M(26,:)%j-M(45,:)%j+M(46,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(803),h0tab(:,803),[48,1,8,4,2],[0,nMT,nMT,nMT,0],5,1,wf4(:,7))
  call Hloop_UV_W(ntryL,G0H64(1),0,wf4(:,7),48,G1H16(9),m3h4x16(:,119),heltab2x64(:,:,695))
  Gcoeff(:)%j = (c(6)*(M(40,:)%j-M(42,:)%j+M(43,:)%j-M(44,:)%j-M(48,:)%j+M(50,:)%j)) * den(16)
  call G0_hol_initialisation(ntryL,Gcoeff,G0H64(1),m0h(804),h0tab(:,804),[48,1,8,4,2],[nMT,0,0,0,nMT],5,1,wf4(:,7))
  call Hloop_AV_Q(ntryL,G0H64(1),wf4(:,7),G0H16(133),m3h4x16(:,120),heltab2x64(:,:,696))
  call Hloop_A_Q(ntryL,G0H16(133),48,nMT,G1H16(10),n2h16(174))
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(101),[G1H16(45),G0H16(42),G0H16(41),G0H16(40)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(80),[G1H16(51),G0H16(87),G0H16(86),G0H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(98),[G1H16(57)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(99),[G1H16(63),G0H16(39),G0H16(38),G0H16(37)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(82),[G1H16(69),G0H16(90),G0H16(89),G0H16(88)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(4),[G1H16(73),G0H16(51),G0H16(50),G0H16(49)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(2),[G1H16(79),G0H16(78),G0H16(77),G0H16(76)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(71),[G1H16(85)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(72),[G1H16(91),G0H16(75),G0H16(74),G0H16(73)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(102),[G1H16(107)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(104),[G1H16(113),G0H16(45),G0H16(44),G0H16(43)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(77),[G1H16(119),G0H16(84),G0H16(83),G0H16(82)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(74),[G1H16(125)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(75),[G1H16(131),G0H16(81),G0H16(80),G0H16(79)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(116),[G1H16(7),G0H16(63),G0H16(62),G0H16(61)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(58),[G1H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(89),[G1H16(152),G0H16(99),G0H16(98),G0H16(97)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(56),[G1H16(157)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(111),[G1H16(173),G0H16(57),G0H16(56),G0H16(55)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(60),[G1H16(178)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(94),[G1H16(184),G0H16(105),G0H16(104),G0H16(103)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(59),[G1H16(190)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(43),[G1H16(204)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(46),[G1H16(209)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(49),[G1H16(215)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(50),[G1H16(220)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(84),[G1H16(235),G0H16(93),G0H16(92),G0H16(91)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(87),[G1H16(241),G0H16(96),G0H16(95),G0H16(94)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(64),[G1H16(247)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(65),[G1H16(251)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(42),[G1H16(266)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(44),[G1H16(272)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(126),[G0H16(3),G0H16(2),G0H16(1)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(128),[G0H16(6),G0H16(5),G0H16(4)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(130),[G0H16(9),G0H16(8),G0H16(7)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(133),[G0H16(12),G0H16(11),G0H16(10)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(135),[G0H16(15),G0H16(14),G0H16(13)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(138),[G0H16(18),G0H16(17),G0H16(16)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(140),[G0H16(21),G0H16(20),G0H16(19)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(142),[G0H16(24),G0H16(23),G0H16(22)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(145),[G0H16(27),G0H16(26),G0H16(25)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(146),[G0H16(30),G0H16(29),G0H16(28)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(8),[G0H16(33),G0H16(32),G0H16(31)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(9),[G0H16(36),G0H16(35),G0H16(34)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(106),[G0H16(48),G0H16(47),G0H16(46)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(109),[G0H16(54),G0H16(53),G0H16(52)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(114),[G0H16(60),G0H16(59),G0H16(58)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(117),[G0H16(66),G0H16(65),G0H16(64)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(121),[G0H16(69),G0H16(68),G0H16(67)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(122),[G0H16(72),G0H16(71),G0H16(70)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(90),[G0H16(102),G0H16(101),G0H16(100)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H16(95),[G0H16(108),G0H16(107),G0H16(106)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(113),[G1H32(109)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(115),[G1H32(111)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(124),[G1H32(120)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(126),[G1H32(122)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(135),[G1H32(131)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(137),[G1H32(133)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(146),[G1H32(142)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(148),[G1H32(144)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(157),[G1H32(153)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(159),[G1H32(155)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(168),[G1H32(164)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(170),[G1H32(166)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(179),[G1H32(175)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(181),[G1H32(177)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(190),[G1H32(186)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(192),[G1H32(188)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(201),[G1H32(197)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(203),[G1H32(199)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(212),[G1H32(208)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(214),[G1H32(210)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(223),[G1H32(219)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(225),[G1H32(221)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(234),[G1H32(230)])
  call ol_merge(ntryL,merge_step,merge_mism,merge_tables,merge_hels,G1H32(236),[G1H32(232)])
  call Hloop_VA_Q(ntryL,G1H16(101),ex2(:),G1H8(407),m3h2x8(:,337),heltab2x16(:,:,337))
  call Hloop_A_Q(ntryL,G1H8(407),42,nMT,G2H8(55),n2h8(361))
  call Hloop_VQ_A(ntryL,G1H16(80),ex1(:),G1H8(408),m3h2x8(:,338),heltab2x16(:,:,338))
  call Hloop_Q_A(ntryL,G1H8(408),37,nMT,G2H8(56),n2h8(362))
  call Hloop_AV_Q(ntryL,G1H16(98),ex3(:),G1H8(425),m3h2x8(:,339),heltab2x16(:,:,339))
  call Hloop_A_Q(ntryL,G1H8(425),44,nMT,G2H8(57),n2h8(363))
  call Hloop_UV_W(ntryL,G1H16(99),40,ex3(:),4,G2H8(58),m3h2x8(:,340),heltab2x16(:,:,340))
  call Hloop_VQ_A(ntryL,G1H16(82),ex1(:),G1H8(426),m3h2x8(:,341),heltab2x16(:,:,341))
  call Hloop_Q_A(ntryL,G1H8(426),37,nMT,G2H8(59),n2h8(364))
  call Hloop_VQ_A(ntryL,G1H16(4),ex1(:),G1H8(443),m3h2x8(:,342),heltab2x16(:,:,342))
  call Hloop_Q_A(ntryL,G1H8(443),41,nMT,G2H8(60),n2h8(365))
  call Hloop_VA_Q(ntryL,G1H16(2),ex2(:),G1H8(444),m3h2x8(:,343),heltab2x16(:,:,343))
  call Hloop_A_Q(ntryL,G1H8(444),38,nMT,G2H8(61),n2h8(366))
  call Hloop_AV_Q(ntryL,G1H16(71),ex4(:),G1H8(461),m3h2x8(:,344),heltab2x16(:,:,344))
  call Hloop_A_Q(ntryL,G1H8(461),44,nMT,G2H8(62),n2h8(367))
  call Hloop_UV_W(ntryL,G1H16(72),36,ex4(:),8,G2H8(63),m3h2x8(:,345),heltab2x16(:,:,345))
  call Hloop_QV_A(ntryL,G1H16(97),ex5(:),G1H8(462),m3h2x8(:,346),heltab2x16(:,:,346))
  call Hloop_Q_A(ntryL,G1H8(462),52,nMT,G2H8(64),n2h8(368))
  call Hloop_UV_W(ntryL,G1H16(103),36,ex5(:),16,G2H8(65),m3h2x8(:,347),heltab2x16(:,:,347))
  call Hloop_QV_A(ntryL,G1H16(102),ex3(:),G1H8(479),m3h2x8(:,348),heltab2x16(:,:,348))
  call Hloop_Q_A(ntryL,G1H8(479),44,nMT,G2H8(66),n2h8(369))
  call Hloop_UV_W(ntryL,G1H16(104),40,ex3(:),4,G2H8(67),m3h2x8(:,349),heltab2x16(:,:,349))
  call Hloop_VA_Q(ntryL,G1H16(77),ex2(:),G1H8(480),m3h2x8(:,350),heltab2x16(:,:,350))
  call Hloop_A_Q(ntryL,G1H8(480),38,nMT,G2H8(70),n2h8(370))
  call Hloop_QV_A(ntryL,G1H16(74),ex4(:),G1H8(497),m3h2x8(:,351),heltab2x16(:,:,351))
  call Hloop_Q_A(ntryL,G1H8(497),44,nMT,G2H8(71),n2h8(371))
  call Hloop_UV_W(ntryL,G1H16(75),36,ex4(:),8,G2H8(72),m3h2x8(:,352),heltab2x16(:,:,352))
  call Hloop_AV_Q(ntryL,G1H16(137),ex5(:),G1H8(498),m3h2x8(:,353),heltab2x16(:,:,353))
  call Hloop_A_Q(ntryL,G1H8(498),52,nMT,G2H8(75),n2h8(372))
  call Hloop_UV_W(ntryL,G1H16(143),36,ex5(:),16,G2H8(76),m3h2x8(:,354),heltab2x16(:,:,354))
  call Hloop_VQ_A(ntryL,G1H16(116),ex1(:),G1H8(515),m3h2x8(:,355),heltab2x16(:,:,355))
  call Hloop_Q_A(ntryL,G1H8(515),41,nMT,G2H8(77),n2h8(373))
  call Hloop_AV_Q(ntryL,G1H16(58),ex3(:),G1H8(516),m3h2x8(:,356),heltab2x16(:,:,356))
  call Hloop_A_Q(ntryL,G1H8(516),38,nMT,G2H8(80),n2h8(374))
  call Hloop_VQ_A(ntryL,G1H16(89),ex1(:),G1H8(533),m3h2x8(:,357),heltab2x16(:,:,357))
  call Hloop_Q_A(ntryL,G1H8(533),37,nMT,G2H8(81),n2h8(375))
  call Hloop_AV_Q(ntryL,G1H16(56),ex4(:),G1H8(534),m3h2x8(:,358),heltab2x16(:,:,358))
  call Hloop_A_Q(ntryL,G1H8(534),42,nMT,G2H8(82),n2h8(376))
  call Hloop_AV_Q(ntryL,G1H16(163),ex5(:),G1H8(551),m3h2x8(:,359),heltab2x16(:,:,359))
  call Hloop_A_Q(ntryL,G1H8(551),50,nMT,G2H8(85),n2h8(377))
  call Hloop_AV_Q(ntryL,G1H16(167),ex5(:),G1H8(552),m3h2x8(:,360),heltab2x16(:,:,360))
  call Hloop_A_Q(ntryL,G1H8(552),50,nMT,G2H8(86),n2h8(378))
  call Hloop_VA_Q(ntryL,G1H16(111),ex2(:),G1H8(569),m3h2x8(:,361),heltab2x16(:,:,361))
  call Hloop_A_Q(ntryL,G1H8(569),42,nMT,G2H8(87),n2h8(379))
  call Hloop_AV_Q(ntryL,G1H16(60),ex3(:),G1H8(570),m3h2x8(:,362),heltab2x16(:,:,362))
  call Hloop_A_Q(ntryL,G1H8(570),38,nMT,G2H8(90),n2h8(380))
  call Hloop_VQ_A(ntryL,G1H16(94),ex1(:),G1H8(587),m3h2x8(:,363),heltab2x16(:,:,363))
  call Hloop_Q_A(ntryL,G1H8(587),37,nMT,G2H8(91),n2h8(381))
  call Hloop_AV_Q(ntryL,G1H16(59),ex4(:),G1H8(588),m3h2x8(:,364),heltab2x16(:,:,364))
  call Hloop_A_Q(ntryL,G1H8(588),42,nMT,G2H8(92),n2h8(382))
  call Hloop_AV_Q(ntryL,G1H16(194),ex4(:),G1H8(605),m3h2x8(:,365),heltab2x16(:,:,365))
  call Hloop_A_Q(ntryL,G1H8(605),42,nMT,G2H8(95),n2h8(383))
  call Hloop_AV_Q(ntryL,G1H16(199),ex5(:),G1H8(606),m3h2x8(:,366),heltab2x16(:,:,366))
  call Hloop_A_Q(ntryL,G1H8(606),50,nMT,G2H8(96),n2h8(384))
  call Hloop_QV_A(ntryL,G1H16(43),ex3(:),G1H8(623),m3h2x8(:,367),heltab2x16(:,:,367))
  call Hloop_Q_A(ntryL,G1H8(623),37,nMT,G2H8(97),n2h8(385))
  call Hloop_QV_A(ntryL,G1H16(46),ex3(:),G1H8(624),m3h2x8(:,368),heltab2x16(:,:,368))
  call Hloop_Q_A(ntryL,G1H8(624),37,nMT,G2H8(100),n2h8(386))
  call Hloop_QV_A(ntryL,G1H16(49),ex3(:),G1H8(641),m3h2x8(:,369),heltab2x16(:,:,369))
  call Hloop_Q_A(ntryL,G1H8(641),37,nMT,G2H8(101),n2h8(387))
  call Hloop_QV_A(ntryL,G1H16(50),ex3(:),G1H8(642),m3h2x8(:,370),heltab2x16(:,:,370))
  call Hloop_Q_A(ntryL,G1H8(642),37,nMT,G2H8(102),n2h8(388))
  call Hloop_QV_A(ntryL,G1H16(225),ex3(:),G1H8(659),m3h2x8(:,371),heltab2x16(:,:,371))
  call Hloop_Q_A(ntryL,G1H8(659),37,nMT,G2H8(105),n2h8(389))
  call Hloop_QV_A(ntryL,G1H16(230),ex3(:),G1H8(660),m3h2x8(:,372),heltab2x16(:,:,372))
  call Hloop_Q_A(ntryL,G1H8(660),37,nMT,G2H8(106),n2h8(390))
  call Hloop_VA_Q(ntryL,G1H16(84),ex2(:),G1H8(677),m3h2x8(:,373),heltab2x16(:,:,373))
  call Hloop_A_Q(ntryL,G1H8(677),38,nMT,G2H8(107),n2h8(391))
  call Hloop_VA_Q(ntryL,G1H16(87),ex2(:),G1H8(678),m3h2x8(:,374),heltab2x16(:,:,374))
  call Hloop_A_Q(ntryL,G1H8(678),38,nMT,G2H8(110),n2h8(392))
  call Hloop_AV_Q(ntryL,G1H16(64),ex3(:),G1H8(695),m3h2x8(:,375),heltab2x16(:,:,375))
  call Hloop_A_Q(ntryL,G1H8(695),38,nMT,G2H8(111),n2h8(393))
  call Hloop_AV_Q(ntryL,G1H16(65),ex3(:),G1H8(696),m3h2x8(:,376),heltab2x16(:,:,376))
  call Hloop_A_Q(ntryL,G1H8(696),38,nMT,G2H8(112),n2h8(394))
  call Hloop_AV_Q(ntryL,G1H16(256),ex4(:),G1H8(713),m3h2x8(:,377),heltab2x16(:,:,377))
  call Hloop_A_Q(ntryL,G1H8(713),42,nMT,G2H8(115),n2h8(395))
  call Hloop_AV_Q(ntryL,G1H16(261),ex5(:),G1H8(714),m3h2x8(:,378),heltab2x16(:,:,378))
  call Hloop_A_Q(ntryL,G1H8(714),50,nMT,G2H8(116),n2h8(396))
  call Hloop_QV_A(ntryL,G1H16(42),ex4(:),G1H8(731),m3h2x8(:,379),heltab2x16(:,:,379))
  call Hloop_Q_A(ntryL,G1H8(731),41,nMT,G2H8(117),n2h8(397))
  call Hloop_QV_A(ntryL,G1H16(44),ex4(:),G1H8(732),m3h2x8(:,380),heltab2x16(:,:,380))
  call Hloop_Q_A(ntryL,G1H8(732),41,nMT,G2H8(120),n2h8(398))
  call Hloop_QV_A(ntryL,G1H16(277),ex4(:),G1H8(749),m3h2x8(:,381),heltab2x16(:,:,381))
  call Hloop_Q_A(ntryL,G1H8(749),41,nMT,G2H8(121),n2h8(399))
  call Hloop_QV_A(ntryL,G1H16(282),ex4(:),G1H8(750),m3h2x8(:,382),heltab2x16(:,:,382))
  call Hloop_Q_A(ntryL,G1H8(750),41,nMT,G2H8(122),n2h8(400))
  call Hloop_QV_A(ntryL,G1H16(286),ex4(:),G1H8(767),m3h2x8(:,383),heltab2x16(:,:,383))
  call Hloop_Q_A(ntryL,G1H8(767),41,nMT,G2H8(125),n2h8(401))
  call Hloop_QV_A(ntryL,G1H16(292),ex4(:),G1H8(768),m3h2x8(:,384),heltab2x16(:,:,384))
  call Hloop_Q_A(ntryL,G1H8(768),41,nMT,G2H8(126),n2h8(402))
  call Hloop_QV_A(ntryL,G1H16(297),ex5(:),G1H8(785),m3h2x8(:,385),heltab2x16(:,:,385))
  call Hloop_Q_A(ntryL,G1H8(785),49,nMT,G2H8(127),n2h8(403))
  call Hloop_QV_A(ntryL,G1H16(302),ex5(:),G1H8(786),m3h2x8(:,386),heltab2x16(:,:,386))
  call Hloop_Q_A(ntryL,G1H8(786),49,nMT,G2H8(130),n2h8(404))
  call Hloop_QV_A(ntryL,G1H16(306),ex5(:),G1H8(803),m3h2x8(:,387),heltab2x16(:,:,387))
  call Hloop_Q_A(ntryL,G1H8(803),49,nMT,G2H8(131),n2h8(405))
  call Hloop_QV_A(ntryL,G1H16(312),ex5(:),G1H8(804),m3h2x8(:,388),heltab2x16(:,:,388))
  call Hloop_Q_A(ntryL,G1H8(804),49,nMT,G2H8(132),n2h8(406))
  call Hloop_QV_A(ntryL,G1H16(316),ex5(:),G1H8(821),m3h2x8(:,389),heltab2x16(:,:,389))
  call Hloop_Q_A(ntryL,G1H8(821),49,nMT,G2H8(135),n2h8(407))
  call Hloop_QV_A(ntryL,G1H16(322),ex5(:),G1H8(822),m3h2x8(:,390),heltab2x16(:,:,390))
  call Hloop_Q_A(ntryL,G1H8(822),49,nMT,G2H8(136),n2h8(408))
  call Hloop_UV_W(ntryL,G1H16(126),48,ex3(:),4,G2H8(137),m3h2x8(:,391),heltab2x16(:,:,391))
  call Hloop_VA_Q(ntryL,G1H16(128),ex2(:),G1H8(839),m3h2x8(:,392),heltab2x16(:,:,392))
  call Hloop_A_Q(ntryL,G1H8(839),50,nMT,G2H8(140),n2h8(409))
  call Hloop_UV_W(ntryL,G1H16(130),48,ex3(:),4,G2H8(141),m3h2x8(:,393),heltab2x16(:,:,393))
  call Hloop_VA_Q(ntryL,G1H16(133),ex2(:),G1H8(840),m3h2x8(:,394),heltab2x16(:,:,394))
  call Hloop_A_Q(ntryL,G1H8(840),50,nMT,G2H8(142),n2h8(410))
  call Hloop_VQ_A(ntryL,G1H16(135),ex1(:),G1H8(857),m3h2x8(:,395),heltab2x16(:,:,395))
  call Hloop_Q_A(ntryL,G1H8(857),49,nMT,G2H8(145),n2h8(411))
  call Hloop_VQ_A(ntryL,G1H16(138),ex1(:),G1H8(858),m3h2x8(:,396),heltab2x16(:,:,396))
  call Hloop_Q_A(ntryL,G1H8(858),49,nMT,G2H8(146),n2h8(412))
  call Hloop_VA_Q(ntryL,G1H16(140),ex2(:),G1H8(875),m3h2x8(:,397),heltab2x16(:,:,397))
  call Hloop_A_Q(ntryL,G1H8(875),50,nMT,G2H8(147),n2h8(413))
  call Hloop_VA_Q(ntryL,G1H16(142),ex2(:),G1H8(876),m3h2x8(:,398),heltab2x16(:,:,398))
  call Hloop_A_Q(ntryL,G1H8(876),50,nMT,G2H8(150),n2h8(414))
  call Hloop_VQ_A(ntryL,G1H16(145),ex1(:),G1H8(893),m3h2x8(:,399),heltab2x16(:,:,399))
  call Hloop_Q_A(ntryL,G1H8(893),49,nMT,G2H8(151),n2h8(415))
  call Hloop_VQ_A(ntryL,G1H16(146),ex1(:),G1H8(894),m3h2x8(:,400),heltab2x16(:,:,400))
  call Hloop_Q_A(ntryL,G1H8(894),49,nMT,G2H8(152),n2h8(416))
  call Hloop_VQ_A(ntryL,G1H16(8),ex1(:),G1H8(911),m3h2x8(:,401),heltab2x16(:,:,401))
  call Hloop_Q_A(ntryL,G1H8(911),49,nMT,G2H8(155),n2h8(417))
  call Hloop_VQ_A(ntryL,G1H16(9),ex1(:),G1H8(912),m3h2x8(:,402),heltab2x16(:,:,402))
  call Hloop_Q_A(ntryL,G1H8(912),49,nMT,G2H8(156),n2h8(418))
  call Hloop_VA_Q(ntryL,G1H16(106),ex2(:),G1H8(929),m3h2x8(:,403),heltab2x16(:,:,403))
  call Hloop_A_Q(ntryL,G1H8(929),42,nMT,G2H8(157),n2h8(419))
  call Hloop_VQ_A(ntryL,G1H16(109),ex1(:),G1H8(930),m3h2x8(:,404),heltab2x16(:,:,404))
  call Hloop_Q_A(ntryL,G1H8(930),41,nMT,G2H8(160),n2h8(420))
  call Hloop_VA_Q(ntryL,G1H16(114),ex2(:),G1H8(7),m3h2x8(:,405),heltab2x16(:,:,405))
  call Hloop_A_Q(ntryL,G1H8(7),42,nMT,G2H8(161),n2h8(421))
  call Hloop_VQ_A(ntryL,G1H16(117),ex1(:),G1H8(8),m3h2x8(:,406),heltab2x16(:,:,406))
  call Hloop_Q_A(ntryL,G1H8(8),41,nMT,G2H8(162),n2h8(422))
  call Hloop_VQ_A(ntryL,G1H16(121),ex1(:),G1H8(11),m3h2x8(:,407),heltab2x16(:,:,407))
  call Hloop_Q_A(ntryL,G1H8(11),41,nMT,G2H8(165),n2h8(423))
  call Hloop_VQ_A(ntryL,G1H16(122),ex1(:),G1H8(12),m3h2x8(:,408),heltab2x16(:,:,408))
  call Hloop_Q_A(ntryL,G1H8(12),41,nMT,G2H8(166),n2h8(424))
  call Hloop_VA_Q(ntryL,G1H32(1),ex2(:),G1H16(11),m3h2x16(:,121),heltab2x32(:,:,121))
  call Hloop_A_Q(ntryL,G1H16(11),34,nMT,G2H16(7),n2h16(175))
  call Hloop_VA_Q(ntryL,G1H32(2),ex2(:),G1H16(12),m3h2x16(:,122),heltab2x32(:,:,122))
  call Hloop_A_Q(ntryL,G1H16(12),34,nMT,G2H16(8),n2h16(176))
  call Hloop_VA_Q(ntryL,G1H32(3),ex2(:),G1H16(147),m3h2x16(:,123),heltab2x32(:,:,123))
  call Hloop_A_Q(ntryL,G1H16(147),34,nMT,G2H16(9),n2h16(177))
  call Hloop_UV_W(ntryL,G1H32(4),32,ex3(:),4,G2H16(10),m3h2x16(:,124),heltab2x32(:,:,124))
  call Hloop_UV_W(ntryL,G1H32(5),32,ex3(:),4,G2H16(11),m3h2x16(:,125),heltab2x32(:,:,125))
  call Hloop_UV_W(ntryL,G1H32(6),32,ex3(:),4,G2H16(12),m3h2x16(:,126),heltab2x32(:,:,126))
  call Hloop_VQ_A(ntryL,G1H32(7),ex1(:),G1H16(148),m3h2x16(:,127),heltab2x32(:,:,127))
  call Hloop_Q_A(ntryL,G1H16(148),33,nMT,G2H16(13),n2h16(178))
  call Hloop_VQ_A(ntryL,G1H32(8),ex1(:),G1H16(149),m3h2x16(:,128),heltab2x32(:,:,128))
  call Hloop_Q_A(ntryL,G1H16(149),33,nMT,G2H16(14),n2h16(179))
  call Hloop_VQ_A(ntryL,G1H32(9),ex1(:),G1H16(150),m3h2x16(:,129),heltab2x32(:,:,129))
  call Hloop_Q_A(ntryL,G1H16(150),33,nMT,G2H16(15),n2h16(180))
  call Hloop_VQ_A(ntryL,G1H32(10),ex1(:),G1H16(151),m3h2x16(:,130),heltab2x32(:,:,130))
  call Hloop_Q_A(ntryL,G1H16(151),33,nMT,G2H16(16),n2h16(181))
  call Hloop_VQ_A(ntryL,G1H32(11),ex1(:),G1H16(153),m3h2x16(:,131),heltab2x32(:,:,131))
  call Hloop_Q_A(ntryL,G1H16(153),33,nMT,G2H16(17),n2h16(182))
  call Hloop_VQ_A(ntryL,G1H32(12),ex1(:),G1H16(154),m3h2x16(:,132),heltab2x32(:,:,132))
  call Hloop_Q_A(ntryL,G1H16(154),33,nMT,G2H16(18),n2h16(183))
  call Hloop_UV_W(ntryL,G1H32(13),32,ex3(:),4,G2H16(19),m3h2x16(:,133),heltab2x32(:,:,133))
  call Hloop_UV_W(ntryL,G1H32(14),32,ex3(:),4,G2H16(20),m3h2x16(:,134),heltab2x32(:,:,134))
  call Hloop_UV_W(ntryL,G1H32(15),32,ex3(:),4,G2H16(21),m3h2x16(:,135),heltab2x32(:,:,135))
  call Hloop_VA_Q(ntryL,G1H32(16),ex2(:),G1H16(155),m3h2x16(:,136),heltab2x32(:,:,136))
  call Hloop_A_Q(ntryL,G1H16(155),34,nMT,G2H16(22),n2h16(184))
  call Hloop_VA_Q(ntryL,G1H32(17),ex2(:),G1H16(14),m3h2x16(:,137),heltab2x32(:,:,137))
  call Hloop_A_Q(ntryL,G1H16(14),34,nMT,G2H16(23),n2h16(185))
  call Hloop_VA_Q(ntryL,G1H32(18),ex2(:),G1H16(156),m3h2x16(:,138),heltab2x32(:,:,138))
  call Hloop_A_Q(ntryL,G1H16(156),34,nMT,G2H16(24),n2h16(186))
  call Hloop_VQ_A(ntryL,G1H32(19),ex1(:),G1H16(158),m3h2x16(:,139),heltab2x32(:,:,139))
  call Hloop_Q_A(ntryL,G1H16(158),33,nMT,G2H16(25),n2h16(187))
  call Hloop_VQ_A(ntryL,G1H32(20),ex1(:),G1H16(159),m3h2x16(:,140),heltab2x32(:,:,140))
  call Hloop_Q_A(ntryL,G1H16(159),33,nMT,G2H16(26),n2h16(188))
  call Hloop_VQ_A(ntryL,G1H32(21),ex1(:),G1H16(160),m3h2x16(:,141),heltab2x32(:,:,141))
  call Hloop_Q_A(ntryL,G1H16(160),33,nMT,G2H16(27),n2h16(189))
  call Hloop_AQ_V(ntryL,G1H32(22),ex1(:),G1H16(161),m3h2x16(:,142),heltab2x32(:,:,142))
  call Hloop_AQ_V(ntryL,G1H32(23),ex1(:),G1H16(162),m3h2x16(:,143),heltab2x32(:,:,143))
  call Hloop_AQ_V(ntryL,G1H32(24),ex1(:),G1H16(164),m3h2x16(:,144),heltab2x32(:,:,144))
  call Hloop_VA_Q(ntryL,G1H32(25),ex2(:),G1H16(165),m3h2x16(:,145),heltab2x32(:,:,145))
  call Hloop_A_Q(ntryL,G1H16(165),34,nMT,G2H16(28),n2h16(190))
  call Hloop_VA_Q(ntryL,G1H32(26),ex2(:),G1H16(166),m3h2x16(:,146),heltab2x32(:,:,146))
  call Hloop_A_Q(ntryL,G1H16(166),34,nMT,G2H16(29),n2h16(191))
  call Hloop_VA_Q(ntryL,G1H32(27),ex2(:),G1H16(15),m3h2x16(:,147),heltab2x32(:,:,147))
  call Hloop_A_Q(ntryL,G1H16(15),34,nMT,G2H16(30),n2h16(192))
  call Hloop_QA_V(ntryL,G1H32(28),ex2(:),G1H16(16),m3h2x16(:,148),heltab2x32(:,:,148))
  call Hloop_QA_V(ntryL,G1H32(29),ex2(:),G1H16(168),m3h2x16(:,149),heltab2x32(:,:,149))
  call Hloop_QA_V(ntryL,G1H32(30),ex2(:),G1H16(169),m3h2x16(:,150),heltab2x32(:,:,150))
  call Hloop_AQ_V(ntryL,G1H32(31),ex1(:),G1H16(170),m3h2x16(:,151),heltab2x32(:,:,151))
  call Hloop_AQ_V(ntryL,G1H32(32),ex1(:),G1H16(171),m3h2x16(:,152),heltab2x32(:,:,152))
  call Hloop_AQ_V(ntryL,G1H32(33),ex1(:),G1H16(172),m3h2x16(:,153),heltab2x32(:,:,153))
  call Hloop_AQ_V(ntryL,G1H32(34),ex1(:),G1H16(174),m3h2x16(:,154),heltab2x32(:,:,154))
  call Hloop_AQ_V(ntryL,G1H32(35),ex1(:),G1H16(175),m3h2x16(:,155),heltab2x32(:,:,155))
  call Hloop_AQ_V(ntryL,G1H32(36),ex1(:),G1H16(176),m3h2x16(:,156),heltab2x32(:,:,156))
  call Hloop_VQ_A(ntryL,G1H16(90),ex1(:),G1H8(13),m3h2x8(:,409),heltab2x16(:,:,409))
  call Hloop_Q_A(ntryL,G1H8(13),37,nMT,G2H8(167),n2h8(425))
  call Hloop_VQ_A(ntryL,G1H16(95),ex1(:),G1H8(14),m3h2x8(:,410),heltab2x16(:,:,410))
  call Hloop_Q_A(ntryL,G1H8(14),37,nMT,G2H8(170),n2h8(426))
  call Hloop_VA_Q(ntryL,G1H32(37),ex2(:),G1H16(17),m3h2x16(:,157),heltab2x32(:,:,157))
  call Hloop_A_Q(ntryL,G1H16(17),34,nMT,G2H16(31),n2h16(193))
  call Hloop_VA_Q(ntryL,G1H32(38),ex2(:),G1H16(177),m3h2x16(:,158),heltab2x32(:,:,158))
  call Hloop_A_Q(ntryL,G1H16(177),34,nMT,G2H16(32),n2h16(194))
  call Hloop_VA_Q(ntryL,G1H32(39),ex2(:),G1H16(179),m3h2x16(:,159),heltab2x32(:,:,159))
  call Hloop_A_Q(ntryL,G1H16(179),34,nMT,G2H16(33),n2h16(195))
  call Hloop_UV_W(ntryL,G1H32(40),32,ex4(:),8,G2H16(34),m3h2x16(:,160),heltab2x32(:,:,160))
  call Hloop_UV_W(ntryL,G1H32(41),32,ex4(:),8,G2H16(35),m3h2x16(:,161),heltab2x32(:,:,161))
  call Hloop_UV_W(ntryL,G1H32(42),32,ex4(:),8,G2H16(36),m3h2x16(:,162),heltab2x32(:,:,162))
  call Hloop_VQ_A(ntryL,G1H32(43),ex1(:),G1H16(180),m3h2x16(:,163),heltab2x32(:,:,163))
  call Hloop_Q_A(ntryL,G1H16(180),33,nMT,G2H16(37),n2h16(196))
  call Hloop_VQ_A(ntryL,G1H32(44),ex1(:),G1H16(181),m3h2x16(:,164),heltab2x32(:,:,164))
  call Hloop_Q_A(ntryL,G1H16(181),33,nMT,G2H16(38),n2h16(197))
  call Hloop_VQ_A(ntryL,G1H32(45),ex1(:),G1H16(182),m3h2x16(:,165),heltab2x32(:,:,165))
  call Hloop_Q_A(ntryL,G1H16(182),33,nMT,G2H16(39),n2h16(198))
  call Hloop_VQ_A(ntryL,G1H32(46),ex1(:),G1H16(183),m3h2x16(:,166),heltab2x32(:,:,166))
  call Hloop_Q_A(ntryL,G1H16(183),33,nMT,G2H16(40),n2h16(199))
  call Hloop_VQ_A(ntryL,G1H32(47),ex1(:),G1H16(185),m3h2x16(:,167),heltab2x32(:,:,167))
  call Hloop_Q_A(ntryL,G1H16(185),33,nMT,G2H16(41),n2h16(200))
  call Hloop_VQ_A(ntryL,G1H32(48),ex1(:),G1H16(186),m3h2x16(:,168),heltab2x32(:,:,168))
  call Hloop_Q_A(ntryL,G1H16(186),33,nMT,G2H16(42),n2h16(201))
  call Hloop_UV_W(ntryL,G1H32(49),32,ex4(:),8,G2H16(43),m3h2x16(:,169),heltab2x32(:,:,169))
  call Hloop_UV_W(ntryL,G1H32(50),32,ex4(:),8,G2H16(44),m3h2x16(:,170),heltab2x32(:,:,170))
  call Hloop_UV_W(ntryL,G1H32(51),32,ex4(:),8,G2H16(45),m3h2x16(:,171),heltab2x32(:,:,171))
  call Hloop_VA_Q(ntryL,G1H32(52),ex2(:),G1H16(187),m3h2x16(:,172),heltab2x32(:,:,172))
  call Hloop_A_Q(ntryL,G1H16(187),34,nMT,G2H16(46),n2h16(202))
  call Hloop_VA_Q(ntryL,G1H32(53),ex2(:),G1H16(188),m3h2x16(:,173),heltab2x32(:,:,173))
  call Hloop_A_Q(ntryL,G1H16(188),34,nMT,G2H16(47),n2h16(203))
  call Hloop_VA_Q(ntryL,G1H32(54),ex2(:),G1H16(189),m3h2x16(:,174),heltab2x32(:,:,174))
  call Hloop_A_Q(ntryL,G1H16(189),34,nMT,G2H16(48),n2h16(204))
  call Hloop_VQ_A(ntryL,G1H32(55),ex1(:),G1H16(191),m3h2x16(:,175),heltab2x32(:,:,175))
  call Hloop_Q_A(ntryL,G1H16(191),33,nMT,G2H16(49),n2h16(205))
  call Hloop_VQ_A(ntryL,G1H32(56),ex1(:),G1H16(192),m3h2x16(:,176),heltab2x32(:,:,176))
  call Hloop_Q_A(ntryL,G1H16(192),33,nMT,G2H16(50),n2h16(206))
  call Hloop_VQ_A(ntryL,G1H32(57),ex1(:),G1H16(193),m3h2x16(:,177),heltab2x32(:,:,177))
  call Hloop_Q_A(ntryL,G1H16(193),33,nMT,G2H16(51),n2h16(207))
  call Hloop_AQ_V(ntryL,G1H32(58),ex1(:),G1H16(18),m3h2x16(:,178),heltab2x32(:,:,178))
  call Hloop_AQ_V(ntryL,G1H32(59),ex1(:),G1H16(19),m3h2x16(:,179),heltab2x32(:,:,179))
  call Hloop_AQ_V(ntryL,G1H32(60),ex1(:),G1H16(195),m3h2x16(:,180),heltab2x32(:,:,180))
  call Hloop_VA_Q(ntryL,G1H32(61),ex2(:),G1H16(196),m3h2x16(:,181),heltab2x32(:,:,181))
  call Hloop_A_Q(ntryL,G1H16(196),34,nMT,G2H16(52),n2h16(208))
  call Hloop_VA_Q(ntryL,G1H32(62),ex2(:),G1H16(197),m3h2x16(:,182),heltab2x32(:,:,182))
  call Hloop_A_Q(ntryL,G1H16(197),34,nMT,G2H16(53),n2h16(209))
  call Hloop_VA_Q(ntryL,G1H32(63),ex2(:),G1H16(20),m3h2x16(:,183),heltab2x32(:,:,183))
  call Hloop_A_Q(ntryL,G1H16(20),34,nMT,G2H16(54),n2h16(210))
  call Hloop_QA_V(ntryL,G1H32(64),ex2(:),G1H16(198),m3h2x16(:,184),heltab2x32(:,:,184))
  call Hloop_QA_V(ntryL,G1H32(65),ex2(:),G1H16(200),m3h2x16(:,185),heltab2x32(:,:,185))
  call Hloop_QA_V(ntryL,G1H32(66),ex2(:),G1H16(201),m3h2x16(:,186),heltab2x32(:,:,186))
  call Hloop_AQ_V(ntryL,G1H32(67),ex1(:),G1H16(202),m3h2x16(:,187),heltab2x32(:,:,187))
  call Hloop_AQ_V(ntryL,G1H32(68),ex1(:),G1H16(21),m3h2x16(:,188),heltab2x32(:,:,188))
  call Hloop_AQ_V(ntryL,G1H32(69),ex1(:),G1H16(203),m3h2x16(:,189),heltab2x32(:,:,189))
  call Hloop_AQ_V(ntryL,G1H32(70),ex1(:),G1H16(205),m3h2x16(:,190),heltab2x32(:,:,190))
  call Hloop_AQ_V(ntryL,G1H32(71),ex1(:),G1H16(206),m3h2x16(:,191),heltab2x32(:,:,191))
  call Hloop_AQ_V(ntryL,G1H32(72),ex1(:),G1H16(207),m3h2x16(:,192),heltab2x32(:,:,192))
  call Hloop_VA_Q(ntryL,G1H32(73),ex2(:),G1H16(22),m3h2x16(:,193),heltab2x32(:,:,193))
  call Hloop_A_Q(ntryL,G1H16(22),34,nMT,G2H16(55),n2h16(211))
  call Hloop_VA_Q(ntryL,G1H32(74),ex2(:),G1H16(208),m3h2x16(:,194),heltab2x32(:,:,194))
  call Hloop_A_Q(ntryL,G1H16(208),34,nMT,G2H16(56),n2h16(212))
  call Hloop_VA_Q(ntryL,G1H32(75),ex2(:),G1H16(210),m3h2x16(:,195),heltab2x32(:,:,195))
  call Hloop_A_Q(ntryL,G1H16(210),34,nMT,G2H16(57),n2h16(213))
  call Hloop_GGG_G_12(ntryL,G1H32(76),ex4(:),ex3(:),G1H8(17),m4h2x2x8(:,1),heltab3x32(:,:,1))
  call Hloop_GGG_G_12(ntryL,G1H32(77),ex3(:),ex4(:),G1H8(18),m4h2x2x8(:,2),heltab3x32(:,:,2))
  call Hloop_GGG_G_23(ntryL,G1H32(78),ex4(:),ex3(:),G1H8(19),m4h2x2x8(:,3),heltab3x32(:,:,3))
  call Hloop_VQ_A(ntryL,G1H32(79),ex1(:),G1H16(211),m3h2x16(:,196),heltab2x32(:,:,196))
  call Hloop_Q_A(ntryL,G1H16(211),33,nMT,G2H16(58),n2h16(214))
  call Hloop_VQ_A(ntryL,G1H32(80),ex1(:),G1H16(212),m3h2x16(:,197),heltab2x32(:,:,197))
  call Hloop_Q_A(ntryL,G1H16(212),33,nMT,G2H16(59),n2h16(215))
  call Hloop_VQ_A(ntryL,G1H32(81),ex1(:),G1H16(213),m3h2x16(:,198),heltab2x32(:,:,198))
  call Hloop_Q_A(ntryL,G1H16(213),33,nMT,G2H16(60),n2h16(216))
  call Hloop_VQ_A(ntryL,G1H32(82),ex1(:),G1H16(214),m3h2x16(:,199),heltab2x32(:,:,199))
  call Hloop_Q_A(ntryL,G1H16(214),33,nMT,G2H16(61),n2h16(217))
  call Hloop_VQ_A(ntryL,G1H32(83),ex1(:),G1H16(216),m3h2x16(:,200),heltab2x32(:,:,200))
  call Hloop_Q_A(ntryL,G1H16(216),33,nMT,G2H16(62),n2h16(218))
  call Hloop_VQ_A(ntryL,G1H32(84),ex1(:),G1H16(217),m3h2x16(:,201),heltab2x32(:,:,201))
  call Hloop_Q_A(ntryL,G1H16(217),33,nMT,G2H16(63),n2h16(219))
  call Hloop_GGG_G_12(ntryL,G1H32(85),ex4(:),ex3(:),G1H8(20),m4h2x2x8(:,4),heltab3x32(:,:,4))
  call Hloop_GGG_G_12(ntryL,G1H32(86),ex3(:),ex4(:),G1H8(23),m4h2x2x8(:,5),heltab3x32(:,:,5))
  call Hloop_GGG_G_23(ntryL,G1H32(87),ex4(:),ex3(:),G1H8(24),m4h2x2x8(:,6),heltab3x32(:,:,6))
  call Hloop_VA_Q(ntryL,G1H32(88),ex2(:),G1H16(218),m3h2x16(:,202),heltab2x32(:,:,202))
  call Hloop_A_Q(ntryL,G1H16(218),34,nMT,G2H16(64),n2h16(220))
  call Hloop_VA_Q(ntryL,G1H32(89),ex2(:),G1H16(23),m3h2x16(:,203),heltab2x32(:,:,203))
  call Hloop_A_Q(ntryL,G1H16(23),34,nMT,G2H16(65),n2h16(221))
  call Hloop_VA_Q(ntryL,G1H32(90),ex2(:),G1H16(219),m3h2x16(:,204),heltab2x32(:,:,204))
  call Hloop_A_Q(ntryL,G1H16(219),34,nMT,G2H16(66),n2h16(222))
  call Hloop_VQ_A(ntryL,G1H32(91),ex1(:),G1H16(221),m3h2x16(:,205),heltab2x32(:,:,205))
  call Hloop_Q_A(ntryL,G1H16(221),33,nMT,G2H16(67),n2h16(223))
  call Hloop_VQ_A(ntryL,G1H32(92),ex1(:),G1H16(222),m3h2x16(:,206),heltab2x32(:,:,206))
  call Hloop_Q_A(ntryL,G1H16(222),33,nMT,G2H16(68),n2h16(224))
  call Hloop_VQ_A(ntryL,G1H32(93),ex1(:),G1H16(223),m3h2x16(:,207),heltab2x32(:,:,207))
  call Hloop_Q_A(ntryL,G1H16(223),33,nMT,G2H16(69),n2h16(225))
  call Hloop_AQ_V(ntryL,G1H32(94),ex1(:),G1H16(24),m3h2x16(:,208),heltab2x32(:,:,208))
  call Hloop_AQ_V(ntryL,G1H32(95),ex1(:),G1H16(224),m3h2x16(:,209),heltab2x32(:,:,209))
  call Hloop_AQ_V(ntryL,G1H32(96),ex1(:),G1H16(226),m3h2x16(:,210),heltab2x32(:,:,210))
  call Hloop_VA_Q(ntryL,G1H32(97),ex2(:),G1H16(227),m3h2x16(:,211),heltab2x32(:,:,211))
  call Hloop_A_Q(ntryL,G1H16(227),34,nMT,G2H16(70),n2h16(226))
  call Hloop_VA_Q(ntryL,G1H32(98),ex2(:),G1H16(228),m3h2x16(:,212),heltab2x32(:,:,212))
  call Hloop_A_Q(ntryL,G1H16(228),34,nMT,G2H16(71),n2h16(227))
  call Hloop_VA_Q(ntryL,G1H32(99),ex2(:),G1H16(25),m3h2x16(:,213),heltab2x32(:,:,213))
  call Hloop_A_Q(ntryL,G1H16(25),34,nMT,G2H16(72),n2h16(228))
  call Hloop_QA_V(ntryL,G1H32(100),ex2(:),G1H16(229),m3h2x16(:,214),heltab2x32(:,:,214))
  call Hloop_QA_V(ntryL,G1H32(101),ex2(:),G1H16(231),m3h2x16(:,215),heltab2x32(:,:,215))
  call Hloop_QA_V(ntryL,G1H32(102),ex2(:),G1H16(232),m3h2x16(:,216),heltab2x32(:,:,216))
  call Hloop_AQ_V(ntryL,G1H32(103),ex1(:),G1H16(233),m3h2x16(:,217),heltab2x32(:,:,217))
  call Hloop_AQ_V(ntryL,G1H32(104),ex1(:),G1H16(26),m3h2x16(:,218),heltab2x32(:,:,218))
  call Hloop_AQ_V(ntryL,G1H32(105),ex1(:),G1H16(234),m3h2x16(:,219),heltab2x32(:,:,219))
  call Hloop_AQ_V(ntryL,G1H32(106),ex1(:),G1H16(236),m3h2x16(:,220),heltab2x32(:,:,220))
  call Hloop_AQ_V(ntryL,G1H32(107),ex1(:),G1H16(237),m3h2x16(:,221),heltab2x32(:,:,221))
  call Hloop_AQ_V(ntryL,G1H32(108),ex1(:),G1H16(238),m3h2x16(:,222),heltab2x32(:,:,222))
  call Hloop_AV_Q(ntryL,G1H32(113),wf4(:,1),G1H8(25),m3h4x8(:,1),heltab2x32(:,:,223))
  call Hloop_A_Q(ntryL,G1H8(25),35,0,G2H8(171),n2h8(427))
  call Hloop_AV_Q(ntryL,G1H32(110),wf4(:,1),G1H8(26),m3h4x8(:,2),heltab2x32(:,:,224))
  call Hloop_A_Q(ntryL,G1H8(26),35,nMT,G2H8(172),n2h8(428))
  call Hloop_QV_A(ntryL,G1H32(115),wf4(:,1),G1H8(29),m3h4x8(:,3),heltab2x32(:,:,225))
  call Hloop_Q_A(ntryL,G1H8(29),35,0,G2H8(175),n2h8(429))
  call Hloop_QV_A(ntryL,G1H32(112),wf4(:,1),G1H8(30),m3h4x8(:,4),heltab2x32(:,:,226))
  call Hloop_Q_A(ntryL,G1H8(30),35,nMT,G2H8(176),n2h8(430))
  call Hloop_AV_Q(ntryL,G1H32(114),wf4(:,1),G1H8(31),m3h4x8(:,5),heltab2x32(:,:,227))
  call Hloop_A_Q(ntryL,G1H8(31),35,nMB,G2H8(177),n2h8(431))
  call Hloop_QV_A(ntryL,G1H32(116),wf4(:,1),G1H8(32),m3h4x8(:,6),heltab2x32(:,:,228))
  call Hloop_Q_A(ntryL,G1H8(32),35,nMB,G2H8(180),n2h8(432))
  call Hloop_DV_C(ntryL,G1H32(117),32,wf4(:,1),G2H8(181),m3h4x8(:,7),heltab2x32(:,:,229))
  call Hloop_CV_D(ntryL,G1H32(118),32,wf4(:,1),3,G2H8(182),m3h4x8(:,8),heltab2x32(:,:,230))
  call Hloop_UV_W(ntryL,G1H32(119),32,wf4(:,1),3,G2H8(185),m3h4x8(:,9),heltab2x32(:,:,231))
  call Hloop_QV_A(ntryL,G1H32(124),wf4(:,1),G1H8(35),m3h4x8(:,10),heltab2x32(:,:,232))
  call Hloop_Q_A(ntryL,G1H8(35),35,0,G2H8(186),n2h8(433))
  call Hloop_QV_A(ntryL,G1H32(121),wf4(:,1),G1H8(36),m3h4x8(:,11),heltab2x32(:,:,233))
  call Hloop_Q_A(ntryL,G1H8(36),35,nMT,G2H8(187),n2h8(434))
  call Hloop_AV_Q(ntryL,G1H32(126),wf4(:,1),G1H8(37),m3h4x8(:,12),heltab2x32(:,:,234))
  call Hloop_A_Q(ntryL,G1H8(37),35,0,G2H8(190),n2h8(435))
  call Hloop_AV_Q(ntryL,G1H32(123),wf4(:,1),G1H8(38),m3h4x8(:,13),heltab2x32(:,:,235))
  call Hloop_A_Q(ntryL,G1H8(38),35,nMT,G2H8(191),n2h8(436))
  call Hloop_QV_A(ntryL,G1H32(125),wf4(:,1),G1H8(41),m3h4x8(:,14),heltab2x32(:,:,236))
  call Hloop_Q_A(ntryL,G1H8(41),35,nMB,G2H8(192),n2h8(437))
  call Hloop_AV_Q(ntryL,G1H32(127),wf4(:,1),G1H8(42),m3h4x8(:,15),heltab2x32(:,:,237))
  call Hloop_A_Q(ntryL,G1H8(42),35,nMB,G2H8(195),n2h8(438))
  call Hloop_CV_D(ntryL,G1H32(128),32,wf4(:,1),3,G2H8(196),m3h4x8(:,16),heltab2x32(:,:,238))
  call Hloop_DV_C(ntryL,G1H32(129),32,wf4(:,1),G2H8(197),m3h4x8(:,17),heltab2x32(:,:,239))
  call Hloop_UV_W(ntryL,G1H32(130),32,wf4(:,1),3,G2H8(200),m3h4x8(:,18),heltab2x32(:,:,240))
  call Hloop_QV_A(ntryL,G1H32(135),wf4(:,1),G1H8(43),m3h4x8(:,19),heltab2x32(:,:,241))
  call Hloop_Q_A(ntryL,G1H8(43),35,0,G2H8(201),n2h8(439))
  call Hloop_QV_A(ntryL,G1H32(132),wf4(:,1),G1H8(44),m3h4x8(:,20),heltab2x32(:,:,242))
  call Hloop_Q_A(ntryL,G1H8(44),35,nMT,G2H8(202),n2h8(440))
  call Hloop_AV_Q(ntryL,G1H32(137),wf4(:,1),G1H8(47),m3h4x8(:,21),heltab2x32(:,:,243))
  call Hloop_A_Q(ntryL,G1H8(47),35,0,G2H8(205),n2h8(441))
  call Hloop_AV_Q(ntryL,G1H32(134),wf4(:,1),G1H8(48),m3h4x8(:,22),heltab2x32(:,:,244))
  call Hloop_A_Q(ntryL,G1H8(48),35,nMT,G2H8(206),n2h8(442))
  call Hloop_QV_A(ntryL,G1H32(136),wf4(:,1),G1H8(49),m3h4x8(:,23),heltab2x32(:,:,245))
  call Hloop_Q_A(ntryL,G1H8(49),35,nMB,G2H8(207),n2h8(443))
  call Hloop_AV_Q(ntryL,G1H32(138),wf4(:,1),G1H8(50),m3h4x8(:,24),heltab2x32(:,:,246))
  call Hloop_A_Q(ntryL,G1H8(50),35,nMB,G2H8(210),n2h8(444))
  call Hloop_CV_D(ntryL,G1H32(139),32,wf4(:,1),3,G2H8(211),m3h4x8(:,25),heltab2x32(:,:,247))
  call Hloop_DV_C(ntryL,G1H32(140),32,wf4(:,1),G2H8(212),m3h4x8(:,26),heltab2x32(:,:,248))
  call Hloop_UV_W(ntryL,G1H32(141),32,wf4(:,1),3,G2H8(215),m3h4x8(:,27),heltab2x32(:,:,249))
  call Hloop_AV_Q(ntryL,G1H32(146),ex3(:),G1H16(239),m3h2x16(:,223),heltab2x32(:,:,250))
  call Hloop_A_Q(ntryL,G1H16(239),36,0,G2H16(73),n2h16(229))
  call Hloop_AV_Q(ntryL,G1H32(143),ex3(:),G1H16(240),m3h2x16(:,224),heltab2x32(:,:,251))
  call Hloop_A_Q(ntryL,G1H16(240),36,nMT,G2H16(74),n2h16(230))
  call Hloop_QV_A(ntryL,G1H32(148),ex3(:),G1H16(242),m3h2x16(:,225),heltab2x32(:,:,252))
  call Hloop_Q_A(ntryL,G1H16(242),36,0,G2H16(75),n2h16(231))
  call Hloop_QV_A(ntryL,G1H32(145),ex3(:),G1H16(243),m3h2x16(:,226),heltab2x32(:,:,253))
  call Hloop_Q_A(ntryL,G1H16(243),36,nMT,G2H16(76),n2h16(232))
  call Hloop_AV_Q(ntryL,G1H32(147),ex3(:),G1H16(244),m3h2x16(:,227),heltab2x32(:,:,254))
  call Hloop_A_Q(ntryL,G1H16(244),36,nMB,G2H16(77),n2h16(233))
  call Hloop_QV_A(ntryL,G1H32(149),ex3(:),G1H16(245),m3h2x16(:,228),heltab2x32(:,:,255))
  call Hloop_Q_A(ntryL,G1H16(245),36,nMB,G2H16(78),n2h16(234))
  call Hloop_DV_C(ntryL,G1H32(150),32,ex3(:),G2H16(1),m3h2x16(:,229),heltab2x32(:,:,256))
  call Hloop_CV_D(ntryL,G1H32(151),32,ex3(:),4,G2H16(2),m3h2x16(:,230),heltab2x32(:,:,257))
  call Hloop_UV_W(ntryL,G1H32(152),32,ex3(:),4,G2H16(3),m3h2x16(:,231),heltab2x32(:,:,258))
  call Hloop_AV_Q(ntryL,G1H32(157),wf4(:,1),G1H8(53),m3h4x8(:,28),heltab2x32(:,:,259))
  call Hloop_A_Q(ntryL,G1H8(53),35,0,G2H8(216),n2h8(445))
  call Hloop_AV_Q(ntryL,G1H32(154),wf4(:,1),G1H8(54),m3h4x8(:,29),heltab2x32(:,:,260))
  call Hloop_A_Q(ntryL,G1H8(54),35,nMT,G2H8(217),n2h8(446))
  call Hloop_QV_A(ntryL,G1H32(159),wf4(:,1),G1H8(55),m3h4x8(:,30),heltab2x32(:,:,261))
  call Hloop_Q_A(ntryL,G1H8(55),35,0,G2H8(220),n2h8(447))
  call Hloop_QV_A(ntryL,G1H32(156),wf4(:,1),G1H8(56),m3h4x8(:,31),heltab2x32(:,:,262))
  call Hloop_Q_A(ntryL,G1H8(56),35,nMT,G2H8(221),n2h8(448))
  call Hloop_AV_Q(ntryL,G1H32(158),wf4(:,1),G1H8(59),m3h4x8(:,32),heltab2x32(:,:,263))
  call Hloop_A_Q(ntryL,G1H8(59),35,nMB,G2H8(222),n2h8(449))
  call Hloop_QV_A(ntryL,G1H32(160),wf4(:,1),G1H8(60),m3h4x8(:,33),heltab2x32(:,:,264))
  call Hloop_Q_A(ntryL,G1H8(60),35,nMB,G2H8(225),n2h8(450))
  call Hloop_DV_C(ntryL,G1H32(161),32,wf4(:,1),G2H8(226),m3h4x8(:,34),heltab2x32(:,:,265))
  call Hloop_CV_D(ntryL,G1H32(162),32,wf4(:,1),3,G2H8(227),m3h4x8(:,35),heltab2x32(:,:,266))
  call Hloop_UV_W(ntryL,G1H32(163),32,wf4(:,1),3,G2H8(230),m3h4x8(:,36),heltab2x32(:,:,267))
  call Hloop_QV_A(ntryL,G1H32(168),ex4(:),G1H16(246),m3h2x16(:,232),heltab2x32(:,:,268))
  call Hloop_Q_A(ntryL,G1H16(246),40,0,G2H16(4),n2h16(235))
  call Hloop_QV_A(ntryL,G1H32(165),ex4(:),G1H16(248),m3h2x16(:,233),heltab2x32(:,:,269))
  call Hloop_Q_A(ntryL,G1H16(248),40,nMT,G2H16(5),n2h16(236))
  call Hloop_AV_Q(ntryL,G1H32(170),ex4(:),G1H16(249),m3h2x16(:,234),heltab2x32(:,:,270))
  call Hloop_A_Q(ntryL,G1H16(249),40,0,G2H16(6),n2h16(237))
  call Hloop_AV_Q(ntryL,G1H32(167),ex4(:),G1H16(250),m3h2x16(:,235),heltab2x32(:,:,271))
  call Hloop_A_Q(ntryL,G1H16(250),40,nMT,G2H16(79),n2h16(238))
  call Hloop_QV_A(ntryL,G1H32(169),ex4(:),G1H16(27),m3h2x16(:,236),heltab2x32(:,:,272))
  call Hloop_Q_A(ntryL,G1H16(27),40,nMB,G2H16(80),n2h16(239))
  call Hloop_AV_Q(ntryL,G1H32(171),ex4(:),G1H16(28),m3h2x16(:,237),heltab2x32(:,:,273))
  call Hloop_A_Q(ntryL,G1H16(28),40,nMB,G2H16(81),n2h16(240))
  call Hloop_CV_D(ntryL,G1H32(172),32,ex4(:),8,G2H16(82),m3h2x16(:,238),heltab2x32(:,:,274))
  call Hloop_DV_C(ntryL,G1H32(173),32,ex4(:),G2H16(83),m3h2x16(:,239),heltab2x32(:,:,275))
  call Hloop_UV_W(ntryL,G1H32(174),32,ex4(:),8,G2H16(84),m3h2x16(:,240),heltab2x32(:,:,276))
  call Hloop_QV_A(ntryL,G1H32(179),wf4(:,1),G1H8(61),m3h4x8(:,37),heltab2x32(:,:,277))
  call Hloop_Q_A(ntryL,G1H8(61),35,0,G2H8(231),n2h8(451))
  call Hloop_QV_A(ntryL,G1H32(176),wf4(:,1),G1H8(62),m3h4x8(:,38),heltab2x32(:,:,278))
  call Hloop_Q_A(ntryL,G1H8(62),35,nMT,G2H8(232),n2h8(452))
  call Hloop_AV_Q(ntryL,G1H32(181),wf4(:,1),G1H8(65),m3h4x8(:,39),heltab2x32(:,:,279))
  call Hloop_A_Q(ntryL,G1H8(65),35,0,G2H8(235),n2h8(453))
  call Hloop_AV_Q(ntryL,G1H32(178),wf4(:,1),G1H8(66),m3h4x8(:,40),heltab2x32(:,:,280))
  call Hloop_A_Q(ntryL,G1H8(66),35,nMT,G2H8(236),n2h8(454))
  call Hloop_QV_A(ntryL,G1H32(180),wf4(:,1),G1H8(67),m3h4x8(:,41),heltab2x32(:,:,281))
  call Hloop_Q_A(ntryL,G1H8(67),35,nMB,G2H8(237),n2h8(455))
  call Hloop_AV_Q(ntryL,G1H32(182),wf4(:,1),G1H8(68),m3h4x8(:,42),heltab2x32(:,:,282))
  call Hloop_A_Q(ntryL,G1H8(68),35,nMB,G2H8(239),n2h8(456))
  call Hloop_CV_D(ntryL,G1H32(183),32,wf4(:,1),3,G2H8(240),m3h4x8(:,43),heltab2x32(:,:,283))
  call Hloop_DV_C(ntryL,G1H32(184),32,wf4(:,1),G2H8(241),m3h4x8(:,44),heltab2x32(:,:,284))
  call Hloop_UV_W(ntryL,G1H32(185),32,wf4(:,1),3,G2H8(243),m3h4x8(:,45),heltab2x32(:,:,285))
  call Hloop_AV_Q(ntryL,G1H32(190),ex3(:),G1H16(252),m3h2x16(:,241),heltab2x32(:,:,286))
  call Hloop_A_Q(ntryL,G1H16(252),36,0,G2H16(85),n2h16(241))
  call Hloop_AV_Q(ntryL,G1H32(187),ex3(:),G1H16(253),m3h2x16(:,242),heltab2x32(:,:,287))
  call Hloop_A_Q(ntryL,G1H16(253),36,nMT,G2H16(86),n2h16(242))
  call Hloop_QV_A(ntryL,G1H32(192),ex3(:),G1H16(254),m3h2x16(:,243),heltab2x32(:,:,288))
  call Hloop_Q_A(ntryL,G1H16(254),36,0,G2H16(87),n2h16(243))
  call Hloop_QV_A(ntryL,G1H32(189),ex3(:),G1H16(29),m3h2x16(:,244),heltab2x32(:,:,289))
  call Hloop_Q_A(ntryL,G1H16(29),36,nMT,G2H16(88),n2h16(244))
  call Hloop_AV_Q(ntryL,G1H32(191),ex3(:),G1H16(255),m3h2x16(:,245),heltab2x32(:,:,290))
  call Hloop_A_Q(ntryL,G1H16(255),36,nMB,G2H16(89),n2h16(245))
  call Hloop_QV_A(ntryL,G1H32(193),ex3(:),G1H16(257),m3h2x16(:,246),heltab2x32(:,:,291))
  call Hloop_Q_A(ntryL,G1H16(257),36,nMB,G2H16(90),n2h16(246))
  call Hloop_DV_C(ntryL,G1H32(194),32,ex3(:),G2H16(91),m3h2x16(:,247),heltab2x32(:,:,292))
  call Hloop_CV_D(ntryL,G1H32(195),32,ex3(:),4,G2H16(92),m3h2x16(:,248),heltab2x32(:,:,293))
  call Hloop_UV_W(ntryL,G1H32(196),32,ex3(:),4,G2H16(93),m3h2x16(:,249),heltab2x32(:,:,294))
  call Hloop_AV_Q(ntryL,G1H32(201),wf4(:,1),G1H8(71),m3h4x8(:,46),heltab2x32(:,:,295))
  call Hloop_A_Q(ntryL,G1H8(71),35,0,G2H8(244),n2h8(457))
  call Hloop_AV_Q(ntryL,G1H32(198),wf4(:,1),G1H8(72),m3h4x8(:,47),heltab2x32(:,:,296))
  call Hloop_A_Q(ntryL,G1H8(72),35,nMT,G2H8(245),n2h8(458))
  call Hloop_QV_A(ntryL,G1H32(203),wf4(:,1),G1H8(73),m3h4x8(:,48),heltab2x32(:,:,297))
  call Hloop_Q_A(ntryL,G1H8(73),35,0,G2H8(248),n2h8(459))
  call Hloop_QV_A(ntryL,G1H32(200),wf4(:,1),G1H8(74),m3h4x8(:,49),heltab2x32(:,:,298))
  call Hloop_Q_A(ntryL,G1H8(74),35,nMT,G2H8(249),n2h8(460))
  call Hloop_AV_Q(ntryL,G1H32(202),wf4(:,1),G1H8(77),m3h4x8(:,50),heltab2x32(:,:,299))
  call Hloop_A_Q(ntryL,G1H8(77),35,nMB,G2H8(250),n2h8(461))
  call Hloop_QV_A(ntryL,G1H32(204),wf4(:,1),G1H8(78),m3h4x8(:,51),heltab2x32(:,:,300))
  call Hloop_Q_A(ntryL,G1H8(78),35,nMB,G2H8(253),n2h8(462))
  call Hloop_DV_C(ntryL,G1H32(205),32,wf4(:,1),G2H8(254),m3h4x8(:,52),heltab2x32(:,:,301))
  call Hloop_CV_D(ntryL,G1H32(206),32,wf4(:,1),3,G2H8(255),m3h4x8(:,53),heltab2x32(:,:,302))
  call Hloop_UV_W(ntryL,G1H32(207),32,wf4(:,1),3,G2H8(258),m3h4x8(:,54),heltab2x32(:,:,303))
  call Hloop_AV_Q(ntryL,G1H32(212),ex4(:),G1H16(258),m3h2x16(:,250),heltab2x32(:,:,304))
  call Hloop_A_Q(ntryL,G1H16(258),40,0,G2H16(94),n2h16(247))
  call Hloop_AV_Q(ntryL,G1H32(209),ex4(:),G1H16(259),m3h2x16(:,251),heltab2x32(:,:,305))
  call Hloop_A_Q(ntryL,G1H16(259),40,nMT,G2H16(95),n2h16(248))
  call Hloop_QV_A(ntryL,G1H32(214),ex4(:),G1H16(30),m3h2x16(:,252),heltab2x32(:,:,306))
  call Hloop_Q_A(ntryL,G1H16(30),40,0,G2H16(96),n2h16(249))
  call Hloop_QV_A(ntryL,G1H32(211),ex4(:),G1H16(260),m3h2x16(:,253),heltab2x32(:,:,307))
  call Hloop_Q_A(ntryL,G1H16(260),40,nMT,G2H16(97),n2h16(250))
  call Hloop_AV_Q(ntryL,G1H32(213),ex4(:),G1H16(262),m3h2x16(:,254),heltab2x32(:,:,308))
  call Hloop_A_Q(ntryL,G1H16(262),40,nMB,G2H16(98),n2h16(251))
  call Hloop_QV_A(ntryL,G1H32(215),ex4(:),G1H16(263),m3h2x16(:,255),heltab2x32(:,:,309))
  call Hloop_Q_A(ntryL,G1H16(263),40,nMB,G2H16(99),n2h16(252))
  call Hloop_DV_C(ntryL,G1H32(216),32,ex4(:),G2H16(100),m3h2x16(:,256),heltab2x32(:,:,310))
  call Hloop_CV_D(ntryL,G1H32(217),32,ex4(:),8,G2H16(101),m3h2x16(:,257),heltab2x32(:,:,311))
  call Hloop_UV_W(ntryL,G1H32(218),32,ex4(:),8,G2H16(102),m3h2x16(:,258),heltab2x32(:,:,312))
  call Hloop_QV_A(ntryL,G1H32(223),ex3(:),G1H16(264),m3h2x16(:,259),heltab2x32(:,:,313))
  call Hloop_Q_A(ntryL,G1H16(264),36,0,G2H16(103),n2h16(253))
  call Hloop_QV_A(ntryL,G1H32(220),ex3(:),G1H16(31),m3h2x16(:,260),heltab2x32(:,:,314))
  call Hloop_Q_A(ntryL,G1H16(31),36,nMT,G2H16(104),n2h16(254))
  call Hloop_AV_Q(ntryL,G1H32(225),ex3(:),G1H16(265),m3h2x16(:,261),heltab2x32(:,:,315))
  call Hloop_A_Q(ntryL,G1H16(265),36,0,G2H16(105),n2h16(255))
  call Hloop_AV_Q(ntryL,G1H32(222),ex3(:),G1H16(267),m3h2x16(:,262),heltab2x32(:,:,316))
  call Hloop_A_Q(ntryL,G1H16(267),36,nMT,G2H16(106),n2h16(256))
  call Hloop_QV_A(ntryL,G1H32(224),ex3(:),G1H16(268),m3h2x16(:,263),heltab2x32(:,:,317))
  call Hloop_Q_A(ntryL,G1H16(268),36,nMB,G2H16(107),n2h16(257))
  call Hloop_AV_Q(ntryL,G1H32(226),ex3(:),G1H16(269),m3h2x16(:,264),heltab2x32(:,:,318))
  call Hloop_A_Q(ntryL,G1H16(269),36,nMB,G2H16(108),n2h16(258))
  call Hloop_CV_D(ntryL,G1H32(227),32,ex3(:),4,G2H16(109),m3h2x16(:,265),heltab2x32(:,:,319))
  call Hloop_DV_C(ntryL,G1H32(228),32,ex3(:),G2H16(110),m3h2x16(:,266),heltab2x32(:,:,320))
  call Hloop_UV_W(ntryL,G1H32(229),32,ex3(:),4,G2H16(111),m3h2x16(:,267),heltab2x32(:,:,321))
  call Hloop_QV_A(ntryL,G1H32(234),ex3(:),G1H16(270),m3h2x16(:,268),heltab2x32(:,:,322))
  call Hloop_Q_A(ntryL,G1H16(270),36,0,G2H16(112),n2h16(259))
  call Hloop_QV_A(ntryL,G1H32(231),ex3(:),G1H16(271),m3h2x16(:,269),heltab2x32(:,:,323))
  call Hloop_Q_A(ntryL,G1H16(271),36,nMT,G2H16(113),n2h16(260))
  call Hloop_AV_Q(ntryL,G1H32(236),ex3(:),G1H16(273),m3h2x16(:,270),heltab2x32(:,:,324))
  call Hloop_A_Q(ntryL,G1H16(273),36,0,G2H16(114),n2h16(261))
  call Hloop_AV_Q(ntryL,G1H32(233),ex3(:),G1H16(274),m3h2x16(:,271),heltab2x32(:,:,325))
  call Hloop_A_Q(ntryL,G1H16(274),36,nMT,G2H16(115),n2h16(262))
  call Hloop_QV_A(ntryL,G1H32(235),ex3(:),G1H16(275),m3h2x16(:,272),heltab2x32(:,:,326))
  call Hloop_Q_A(ntryL,G1H16(275),36,nMB,G2H16(116),n2h16(263))
  call Hloop_AV_Q(ntryL,G1H32(237),ex3(:),G1H16(32),m3h2x16(:,273),heltab2x32(:,:,327))
  call Hloop_A_Q(ntryL,G1H16(32),36,nMB,G2H16(117),n2h16(264))
  call Hloop_CV_D(ntryL,G1H32(238),32,ex3(:),4,G2H16(118),m3h2x16(:,274),heltab2x32(:,:,328))
  call Hloop_DV_C(ntryL,G1H32(239),32,ex3(:),G2H16(119),m3h2x16(:,275),heltab2x32(:,:,329))
  call Hloop_UV_W(ntryL,G1H32(240),32,ex3(:),4,G2H16(120),m3h2x16(:,276),heltab2x32(:,:,330))
  call Hloop_AQ_V(ntryL,G1H32(241),wf4(:,9),G1H8(79),m3h4x8(:,55),heltab2x32(:,:,331))
  call Hloop_VQ_A(ntryL,G1H32(242),wf4(:,9),G1H8(80),m3h4x8(:,56),heltab2x32(:,:,332))
  call Hloop_Q_A(ntryL,G1H8(80),37,nMT,G2H8(259),n2h8(463))
  call Hloop_AQ_V(ntryL,G1H32(243),wf4(:,9),G1H8(83),m3h4x8(:,57),heltab2x32(:,:,333))
  call Hloop_VQ_A(ntryL,G1H32(244),wf4(:,9),G1H8(84),m3h4x8(:,58),heltab2x32(:,:,334))
  call Hloop_Q_A(ntryL,G1H8(84),37,nMT,G2H8(260),n2h8(464))
  call Hloop_VA_Q(ntryL,G1H32(245),ex2(:),G1H16(276),m3h2x16(:,277),heltab2x32(:,:,335))
  call Hloop_A_Q(ntryL,G1H16(276),34,nMT,G2H16(121),n2h16(265))
  call Hloop_QA_V(ntryL,G1H32(246),ex2(:),G1H16(278),m3h2x16(:,278),heltab2x32(:,:,336))
  call Hloop_QA_V(ntryL,G1H32(247),ex2(:),G1H16(279),m3h2x16(:,279),heltab2x32(:,:,337))
  call Hloop_VA_Q(ntryL,G1H32(248),ex2(:),G1H16(280),m3h2x16(:,280),heltab2x32(:,:,338))
  call Hloop_A_Q(ntryL,G1H16(280),34,nMT,G2H16(122),n2h16(266))
  call Hloop_AQ_V(ntryL,G1H32(249),wf4(:,9),G1H8(85),m3h4x8(:,59),heltab2x32(:,:,339))
  call Hloop_VQ_A(ntryL,G1H32(250),wf4(:,9),G1H8(86),m3h4x8(:,60),heltab2x32(:,:,340))
  call Hloop_Q_A(ntryL,G1H8(86),37,nMT,G2H8(263),n2h8(465))
  call Hloop_QV_A(ntryL,G1H32(251),ex4(:),G1H16(33),m3h2x16(:,281),heltab2x32(:,:,341))
  call Hloop_Q_A(ntryL,G1H16(33),40,nMT,G2H16(123),n2h16(267))
  call Hloop_UV_W(ntryL,G1H32(252),32,ex4(:),8,G2H16(124),m3h2x16(:,282),heltab2x32(:,:,342))
  call Hloop_VA_Q(ntryL,G1H32(253),ex2(:),G1H16(281),m3h2x16(:,283),heltab2x32(:,:,343))
  call Hloop_A_Q(ntryL,G1H16(281),34,nMT,G2H16(125),n2h16(268))
  call Hloop_QA_V(ntryL,G1H32(254),ex2(:),G1H16(283),m3h2x16(:,284),heltab2x32(:,:,344))
  call Hloop_QA_V(ntryL,G1H32(255),ex2(:),G1H16(284),m3h2x16(:,285),heltab2x32(:,:,345))
  call Hloop_VA_Q(ntryL,G1H32(256),ex2(:),G1H16(285),m3h2x16(:,286),heltab2x32(:,:,346))
  call Hloop_A_Q(ntryL,G1H16(285),34,nMT,G2H16(126),n2h16(269))
  call Hloop_AQ_V(ntryL,G1H32(257),wf4(:,9),G1H8(89),m3h4x8(:,61),heltab2x32(:,:,347))
  call Hloop_VQ_A(ntryL,G1H32(258),wf4(:,9),G1H8(90),m3h4x8(:,62),heltab2x32(:,:,348))
  call Hloop_Q_A(ntryL,G1H8(90),37,nMT,G2H8(264),n2h8(466))
  call Hloop_AV_Q(ntryL,G1H32(259),ex4(:),G1H16(34),m3h2x16(:,287),heltab2x32(:,:,349))
  call Hloop_A_Q(ntryL,G1H16(34),40,nMT,G2H16(127),n2h16(270))
  call Hloop_UV_W(ntryL,G1H32(260),32,ex4(:),8,G2H16(128),m3h2x16(:,288),heltab2x32(:,:,350))
  call Hloop_QA_V(ntryL,G1H32(261),ex2(:),G1H16(35),m3h2x16(:,289),heltab2x32(:,:,351))
  call Hloop_VA_Q(ntryL,G1H32(262),ex2(:),G1H16(287),m3h2x16(:,290),heltab2x32(:,:,352))
  call Hloop_A_Q(ntryL,G1H16(287),34,nMT,G2H16(129),n2h16(271))
  call Hloop_QA_V(ntryL,G1H32(263),ex2(:),G1H16(288),m3h2x16(:,291),heltab2x32(:,:,353))
  call Hloop_VA_Q(ntryL,G1H32(264),ex2(:),G1H16(289),m3h2x16(:,292),heltab2x32(:,:,354))
  call Hloop_A_Q(ntryL,G1H16(289),34,nMT,G2H16(130),n2h16(272))
  call Hloop_QA_V(ntryL,G1H32(265),wf4(:,11),G1H8(91),m3h4x8(:,63),heltab2x32(:,:,355))
  call Hloop_VA_Q(ntryL,G1H32(266),wf4(:,11),G1H8(92),m3h4x8(:,64),heltab2x32(:,:,356))
  call Hloop_A_Q(ntryL,G1H8(92),38,nMT,G2H8(265),n2h8(467))
  call Hloop_QA_V(ntryL,G1H32(267),wf4(:,11),G1H8(95),m3h4x8(:,65),heltab2x32(:,:,357))
  call Hloop_VA_Q(ntryL,G1H32(268),wf4(:,11),G1H8(96),m3h4x8(:,66),heltab2x32(:,:,358))
  call Hloop_A_Q(ntryL,G1H8(96),38,nMT,G2H8(268),n2h8(468))
  call Hloop_VQ_A(ntryL,G1H32(269),ex1(:),G1H16(290),m3h2x16(:,293),heltab2x32(:,:,359))
  call Hloop_Q_A(ntryL,G1H16(290),33,nMT,G2H16(131),n2h16(273))
  call Hloop_AQ_V(ntryL,G1H32(270),ex1(:),G1H16(291),m3h2x16(:,294),heltab2x32(:,:,360))
  call Hloop_AQ_V(ntryL,G1H32(271),ex1(:),G1H16(293),m3h2x16(:,295),heltab2x32(:,:,361))
  call Hloop_VQ_A(ntryL,G1H32(272),ex1(:),G1H16(294),m3h2x16(:,296),heltab2x32(:,:,362))
  call Hloop_Q_A(ntryL,G1H16(294),33,nMT,G2H16(132),n2h16(274))
  call Hloop_QA_V(ntryL,G1H32(273),wf4(:,11),G1H8(97),m3h4x8(:,67),heltab2x32(:,:,363))
  call Hloop_VA_Q(ntryL,G1H32(274),wf4(:,11),G1H8(98),m3h4x8(:,68),heltab2x32(:,:,364))



end subroutine vamp_4

end module ol_vamp_4_ppttjj_ttxgggg_1_/**/REALKIND
